# -*- coding: utf8 -*-
# Copyright (c) 2017-2021 THL A29 Limited, a Tencent company. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class AbortAgentCruiseDialingCampaignRequest(AbstractModel):
    """AbortAgentCruiseDialingCampaign request structure.

    """

    def __init__(self):
        r"""
        :param _SdkAppId: Application ID (required) can be found at https://console.cloud.tencent.com/ccc.
        :type SdkAppId: int
        :param _CampaignId: Task ID.
        :type CampaignId: int
        """
        self._SdkAppId = None
        self._CampaignId = None

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def CampaignId(self):
        return self._CampaignId

    @CampaignId.setter
    def CampaignId(self, CampaignId):
        self._CampaignId = CampaignId


    def _deserialize(self, params):
        self._SdkAppId = params.get("SdkAppId")
        self._CampaignId = params.get("CampaignId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AbortAgentCruiseDialingCampaignResponse(AbstractModel):
    """AbortAgentCruiseDialingCampaign response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AbortPredictiveDialingCampaignRequest(AbstractModel):
    """AbortPredictiveDialingCampaign request structure.

    """

    def __init__(self):
        r"""
        :param _SdkAppId: Application ID (required) can be found at https://console.cloud.tencent.com/ccc.
        :type SdkAppId: int
        :param _CampaignId: Task ID.
        :type CampaignId: int
        """
        self._SdkAppId = None
        self._CampaignId = None

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def CampaignId(self):
        return self._CampaignId

    @CampaignId.setter
    def CampaignId(self, CampaignId):
        self._CampaignId = CampaignId


    def _deserialize(self, params):
        self._SdkAppId = params.get("SdkAppId")
        self._CampaignId = params.get("CampaignId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AbortPredictiveDialingCampaignResponse(AbstractModel):
    """AbortPredictiveDialingCampaign response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AudioFileInfo(AbstractModel):
    """Audio file review information

    """

    def __init__(self):
        r"""
        :param _FileId: File ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type FileId: int
        :param _CustomFileName: File alias
Note: This field may return null, indicating that no valid values can be obtained.
        :type CustomFileName: str
        :param _AudioFileName: Filename
Note: This field may return null, indicating that no valid values can be obtained.
        :type AudioFileName: str
        :param _Status: Review status, 0-Not reviewed, 1-Approved, 2-Rejected
Note: This field may return null, indicating that no valid values can be obtained.
        :type Status: int
        """
        self._FileId = None
        self._CustomFileName = None
        self._AudioFileName = None
        self._Status = None

    @property
    def FileId(self):
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def CustomFileName(self):
        return self._CustomFileName

    @CustomFileName.setter
    def CustomFileName(self, CustomFileName):
        self._CustomFileName = CustomFileName

    @property
    def AudioFileName(self):
        return self._AudioFileName

    @AudioFileName.setter
    def AudioFileName(self, AudioFileName):
        self._AudioFileName = AudioFileName

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._FileId = params.get("FileId")
        self._CustomFileName = params.get("CustomFileName")
        self._AudioFileName = params.get("AudioFileName")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AutoCalloutTaskCalleeInfo(AbstractModel):
    """Outbound call task called information.

    """

    def __init__(self):
        r"""
        :param _Callee: Called number.
        :type Callee: str
        :param _State: Call status 0 - Initial, 1 - Answered, 2 - Unanswered, 3 - Calling, 4 - Pending Retry.
        :type State: int
        :param _Sessions: List of session IDs.
        :type Sessions: list of str
        """
        self._Callee = None
        self._State = None
        self._Sessions = None

    @property
    def Callee(self):
        return self._Callee

    @Callee.setter
    def Callee(self, Callee):
        self._Callee = Callee

    @property
    def State(self):
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def Sessions(self):
        return self._Sessions

    @Sessions.setter
    def Sessions(self, Sessions):
        self._Sessions = Sessions


    def _deserialize(self, params):
        self._Callee = params.get("Callee")
        self._State = params.get("State")
        self._Sessions = params.get("Sessions")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AutoCalloutTaskInfo(AbstractModel):
    """Automatic outbound call task list item.

    """

    def __init__(self):
        r"""
        :param _Name: Task Name
        :type Name: str
        :param _CalleeCount: Number of calls.
        :type CalleeCount: int
        :param _Callers: List of calling numbers.
        :type Callers: list of str
        :param _NotBefore: Start timestamp.
        :type NotBefore: int
        :param _NotAfter: End timestamp.
Note: this field may return null, indicating that no valid values can be obtained.
        :type NotAfter: int
        :param _IvrId: IvrId used by the task.
        :type IvrId: int
        :param _State: Task status:
0 Initial: Task created, calling not started
1 Running
2  Completed: All calls in the task are completed
3 Ending: The task is due, but some calls are still not finished
4 Ended: Task terminated due to expiration
        :type State: int
        :param _TaskId: Task ID.
        :type TaskId: int
        """
        self._Name = None
        self._CalleeCount = None
        self._Callers = None
        self._NotBefore = None
        self._NotAfter = None
        self._IvrId = None
        self._State = None
        self._TaskId = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def CalleeCount(self):
        return self._CalleeCount

    @CalleeCount.setter
    def CalleeCount(self, CalleeCount):
        self._CalleeCount = CalleeCount

    @property
    def Callers(self):
        return self._Callers

    @Callers.setter
    def Callers(self, Callers):
        self._Callers = Callers

    @property
    def NotBefore(self):
        return self._NotBefore

    @NotBefore.setter
    def NotBefore(self, NotBefore):
        self._NotBefore = NotBefore

    @property
    def NotAfter(self):
        return self._NotAfter

    @NotAfter.setter
    def NotAfter(self, NotAfter):
        self._NotAfter = NotAfter

    @property
    def IvrId(self):
        return self._IvrId

    @IvrId.setter
    def IvrId(self, IvrId):
        self._IvrId = IvrId

    @property
    def State(self):
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._CalleeCount = params.get("CalleeCount")
        self._Callers = params.get("Callers")
        self._NotBefore = params.get("NotBefore")
        self._NotAfter = params.get("NotAfter")
        self._IvrId = params.get("IvrId")
        self._State = params.get("State")
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BindNumberCallOutSkillGroupRequest(AbstractModel):
    """BindNumberCallOutSkillGroup request structure.

    """

    def __init__(self):
        r"""
        :param _SdkAppId: Application ID (required) can be found at https://console.cloud.tencent.com/ccc.
        :type SdkAppId: int
        :param _Number: Number to be bound.
        :type Number: str
        :param _SkillGroupIds: Skill group ID list to be bound.
        :type SkillGroupIds: list of int non-negative
        """
        self._SdkAppId = None
        self._Number = None
        self._SkillGroupIds = None

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def Number(self):
        return self._Number

    @Number.setter
    def Number(self, Number):
        self._Number = Number

    @property
    def SkillGroupIds(self):
        return self._SkillGroupIds

    @SkillGroupIds.setter
    def SkillGroupIds(self, SkillGroupIds):
        self._SkillGroupIds = SkillGroupIds


    def _deserialize(self, params):
        self._SdkAppId = params.get("SdkAppId")
        self._Number = params.get("Number")
        self._SkillGroupIds = params.get("SkillGroupIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BindNumberCallOutSkillGroupResponse(AbstractModel):
    """BindNumberCallOutSkillGroup response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class BindStaffSkillGroupListRequest(AbstractModel):
    """BindStaffSkillGroupList request structure.

    """

    def __init__(self):
        r"""
        :param _SdkAppId: Application ID (required) can be found at https://console.cloud.tencent.com/ccc.
        :type SdkAppId: int
        :param _StaffEmail: Agent email.
        :type StaffEmail: str
        :param _SkillGroupList: Bound skill group list
        :type SkillGroupList: list of int
        :param _StaffSkillGroupList: Bound skill group list (required).
        :type StaffSkillGroupList: list of StaffSkillGroupList
        """
        self._SdkAppId = None
        self._StaffEmail = None
        self._SkillGroupList = None
        self._StaffSkillGroupList = None

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def StaffEmail(self):
        return self._StaffEmail

    @StaffEmail.setter
    def StaffEmail(self, StaffEmail):
        self._StaffEmail = StaffEmail

    @property
    def SkillGroupList(self):
        warnings.warn("parameter `SkillGroupList` is deprecated", DeprecationWarning) 

        return self._SkillGroupList

    @SkillGroupList.setter
    def SkillGroupList(self, SkillGroupList):
        warnings.warn("parameter `SkillGroupList` is deprecated", DeprecationWarning) 

        self._SkillGroupList = SkillGroupList

    @property
    def StaffSkillGroupList(self):
        return self._StaffSkillGroupList

    @StaffSkillGroupList.setter
    def StaffSkillGroupList(self, StaffSkillGroupList):
        self._StaffSkillGroupList = StaffSkillGroupList


    def _deserialize(self, params):
        self._SdkAppId = params.get("SdkAppId")
        self._StaffEmail = params.get("StaffEmail")
        self._SkillGroupList = params.get("SkillGroupList")
        if params.get("StaffSkillGroupList") is not None:
            self._StaffSkillGroupList = []
            for item in params.get("StaffSkillGroupList"):
                obj = StaffSkillGroupList()
                obj._deserialize(item)
                self._StaffSkillGroupList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BindStaffSkillGroupListResponse(AbstractModel):
    """BindStaffSkillGroupList response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CallInMetrics(AbstractModel):
    """Real-Time inbound metric.

    """

    def __init__(self):
        r"""
        :param _IvrCount: Number of IVR residency.
        :type IvrCount: int
        :param _QueueCount: Number in queue.
        :type QueueCount: int
        :param _RingCount: Number in ringing.
        :type RingCount: int
        :param _AcceptCount: Number in connection.
        :type AcceptCount: int
        :param _TransferOuterCount: Number of customer service transferring to the external line.
        :type TransferOuterCount: int
        :param _MaxQueueDuration: Maximum queue duration.
        :type MaxQueueDuration: int
        :param _AvgQueueDuration: Average queue duration.
        :type AvgQueueDuration: int
        :param _MaxRingDuration: Maximum ringing duration.
        :type MaxRingDuration: int
        :param _AvgRingDuration: Average ringing duration.
        :type AvgRingDuration: int
        :param _MaxAcceptDuration: Maximum connection duration.
        :type MaxAcceptDuration: int
        :param _AvgAcceptDuration: Average connection duration.
        :type AvgAcceptDuration: int
        """
        self._IvrCount = None
        self._QueueCount = None
        self._RingCount = None
        self._AcceptCount = None
        self._TransferOuterCount = None
        self._MaxQueueDuration = None
        self._AvgQueueDuration = None
        self._MaxRingDuration = None
        self._AvgRingDuration = None
        self._MaxAcceptDuration = None
        self._AvgAcceptDuration = None

    @property
    def IvrCount(self):
        return self._IvrCount

    @IvrCount.setter
    def IvrCount(self, IvrCount):
        self._IvrCount = IvrCount

    @property
    def QueueCount(self):
        return self._QueueCount

    @QueueCount.setter
    def QueueCount(self, QueueCount):
        self._QueueCount = QueueCount

    @property
    def RingCount(self):
        return self._RingCount

    @RingCount.setter
    def RingCount(self, RingCount):
        self._RingCount = RingCount

    @property
    def AcceptCount(self):
        return self._AcceptCount

    @AcceptCount.setter
    def AcceptCount(self, AcceptCount):
        self._AcceptCount = AcceptCount

    @property
    def TransferOuterCount(self):
        return self._TransferOuterCount

    @TransferOuterCount.setter
    def TransferOuterCount(self, TransferOuterCount):
        self._TransferOuterCount = TransferOuterCount

    @property
    def MaxQueueDuration(self):
        return self._MaxQueueDuration

    @MaxQueueDuration.setter
    def MaxQueueDuration(self, MaxQueueDuration):
        self._MaxQueueDuration = MaxQueueDuration

    @property
    def AvgQueueDuration(self):
        return self._AvgQueueDuration

    @AvgQueueDuration.setter
    def AvgQueueDuration(self, AvgQueueDuration):
        self._AvgQueueDuration = AvgQueueDuration

    @property
    def MaxRingDuration(self):
        return self._MaxRingDuration

    @MaxRingDuration.setter
    def MaxRingDuration(self, MaxRingDuration):
        self._MaxRingDuration = MaxRingDuration

    @property
    def AvgRingDuration(self):
        return self._AvgRingDuration

    @AvgRingDuration.setter
    def AvgRingDuration(self, AvgRingDuration):
        self._AvgRingDuration = AvgRingDuration

    @property
    def MaxAcceptDuration(self):
        return self._MaxAcceptDuration

    @MaxAcceptDuration.setter
    def MaxAcceptDuration(self, MaxAcceptDuration):
        self._MaxAcceptDuration = MaxAcceptDuration

    @property
    def AvgAcceptDuration(self):
        return self._AvgAcceptDuration

    @AvgAcceptDuration.setter
    def AvgAcceptDuration(self, AvgAcceptDuration):
        self._AvgAcceptDuration = AvgAcceptDuration


    def _deserialize(self, params):
        self._IvrCount = params.get("IvrCount")
        self._QueueCount = params.get("QueueCount")
        self._RingCount = params.get("RingCount")
        self._AcceptCount = params.get("AcceptCount")
        self._TransferOuterCount = params.get("TransferOuterCount")
        self._MaxQueueDuration = params.get("MaxQueueDuration")
        self._AvgQueueDuration = params.get("AvgQueueDuration")
        self._MaxRingDuration = params.get("MaxRingDuration")
        self._AvgRingDuration = params.get("AvgRingDuration")
        self._MaxAcceptDuration = params.get("MaxAcceptDuration")
        self._AvgAcceptDuration = params.get("AvgAcceptDuration")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CallInNumberMetrics(AbstractModel):
    """Inbound line dimension metrics.

    """

    def __init__(self):
        r"""
        :param _Number: Line number.
        :type Number: str
        :param _Metrics: Line-related metrics.
        :type Metrics: :class:`tencentcloud.ccc.v20200210.models.CallInMetrics`
        :param _SkillGroupMetrics: Bound skill group metrics.
        :type SkillGroupMetrics: list of CallInSkillGroupMetrics
        """
        self._Number = None
        self._Metrics = None
        self._SkillGroupMetrics = None

    @property
    def Number(self):
        return self._Number

    @Number.setter
    def Number(self, Number):
        self._Number = Number

    @property
    def Metrics(self):
        return self._Metrics

    @Metrics.setter
    def Metrics(self, Metrics):
        self._Metrics = Metrics

    @property
    def SkillGroupMetrics(self):
        return self._SkillGroupMetrics

    @SkillGroupMetrics.setter
    def SkillGroupMetrics(self, SkillGroupMetrics):
        self._SkillGroupMetrics = SkillGroupMetrics


    def _deserialize(self, params):
        self._Number = params.get("Number")
        if params.get("Metrics") is not None:
            self._Metrics = CallInMetrics()
            self._Metrics._deserialize(params.get("Metrics"))
        if params.get("SkillGroupMetrics") is not None:
            self._SkillGroupMetrics = []
            for item in params.get("SkillGroupMetrics"):
                obj = CallInSkillGroupMetrics()
                obj._deserialize(item)
                self._SkillGroupMetrics.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CallInSkillGroupMetrics(AbstractModel):
    """Inbound capability group metrics.

    """

    def __init__(self):
        r"""
        :param _SkillGroupId: Skill group ID.
        :type SkillGroupId: int
        :param _Metrics: Data metrics.
        :type Metrics: :class:`tencentcloud.ccc.v20200210.models.CallInMetrics`
        :param _Name: Skill group name.
        :type Name: str
        """
        self._SkillGroupId = None
        self._Metrics = None
        self._Name = None

    @property
    def SkillGroupId(self):
        return self._SkillGroupId

    @SkillGroupId.setter
    def SkillGroupId(self, SkillGroupId):
        self._SkillGroupId = SkillGroupId

    @property
    def Metrics(self):
        return self._Metrics

    @Metrics.setter
    def Metrics(self, Metrics):
        self._Metrics = Metrics

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._SkillGroupId = params.get("SkillGroupId")
        if params.get("Metrics") is not None:
            self._Metrics = CallInMetrics()
            self._Metrics._deserialize(params.get("Metrics"))
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CalleeAttribute(AbstractModel):
    """Property of the called.

    """

    def __init__(self):
        r"""
        :param _Callee: Called number.
        :type Callee: str
        :param _UUI: Associate data.
        :type UUI: str
        :param _Variables: Parameter
        :type Variables: list of Variable
        """
        self._Callee = None
        self._UUI = None
        self._Variables = None

    @property
    def Callee(self):
        return self._Callee

    @Callee.setter
    def Callee(self, Callee):
        self._Callee = Callee

    @property
    def UUI(self):
        return self._UUI

    @UUI.setter
    def UUI(self, UUI):
        self._UUI = UUI

    @property
    def Variables(self):
        return self._Variables

    @Variables.setter
    def Variables(self, Variables):
        self._Variables = Variables


    def _deserialize(self, params):
        self._Callee = params.get("Callee")
        self._UUI = params.get("UUI")
        if params.get("Variables") is not None:
            self._Variables = []
            for item in params.get("Variables"):
                obj = Variable()
                obj._deserialize(item)
                self._Variables.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAdminURLRequest(AbstractModel):
    """CreateAdminURL request structure.

    """

    def __init__(self):
        r"""
        :param _SdkAppId: Application ID (required) can be found at https://console.cloud.tencent.com/ccc.
        :type SdkAppId: int
        :param _SeatUserId: Admin account.
        :type SeatUserId: str
        """
        self._SdkAppId = None
        self._SeatUserId = None

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def SeatUserId(self):
        return self._SeatUserId

    @SeatUserId.setter
    def SeatUserId(self, SeatUserId):
        self._SeatUserId = SeatUserId


    def _deserialize(self, params):
        self._SdkAppId = params.get("SdkAppId")
        self._SeatUserId = params.get("SeatUserId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAdminURLResponse(AbstractModel):
    """CreateAdminURL response structure.

    """

    def __init__(self):
        r"""
        :param _URL: Log-in link.
        :type URL: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._URL = None
        self._RequestId = None

    @property
    def URL(self):
        return self._URL

    @URL.setter
    def URL(self, URL):
        self._URL = URL

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._URL = params.get("URL")
        self._RequestId = params.get("RequestId")


class CreateAgentCruiseDialingCampaignRequest(AbstractModel):
    """CreateAgentCruiseDialingCampaign request structure.

    """

    def __init__(self):
        r"""
        :param _SdkAppId: Application ID (required) can be found at https://console.cloud.tencent.com/ccc.
        :type SdkAppId: int
        :param _Name: Task Name
        :type Name: str
        :param _Agent: Agent Account
        :type Agent: str
        :param _ConcurrencyNumber: Single-round Concurrent Call Volume 1-20
        :type ConcurrencyNumber: int
        :param _StartTime: Task start time. Unix timestamp. The task will automatically start after this time.
        :type StartTime: int
        :param _EndTime: Task termination time. Unix timestamp. The task will automatically terminate after this time.
        :type EndTime: int
        :param _Callees: Called list supporting E.164 or number formats without country code.
        :type Callees: list of str
        :param _Callers: Calling list using the number formats displayed on the management side.
        :type Callers: list of str
        :param _CallOrder: Being called sequence: 0 for random 1 for in order.
        :type CallOrder: int
        :param _UUI: Caller Custom Data, Maximum Length 1024
        :type UUI: str
        """
        self._SdkAppId = None
        self._Name = None
        self._Agent = None
        self._ConcurrencyNumber = None
        self._StartTime = None
        self._EndTime = None
        self._Callees = None
        self._Callers = None
        self._CallOrder = None
        self._UUI = None

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Agent(self):
        return self._Agent

    @Agent.setter
    def Agent(self, Agent):
        self._Agent = Agent

    @property
    def ConcurrencyNumber(self):
        return self._ConcurrencyNumber

    @ConcurrencyNumber.setter
    def ConcurrencyNumber(self, ConcurrencyNumber):
        self._ConcurrencyNumber = ConcurrencyNumber

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Callees(self):
        return self._Callees

    @Callees.setter
    def Callees(self, Callees):
        self._Callees = Callees

    @property
    def Callers(self):
        return self._Callers

    @Callers.setter
    def Callers(self, Callers):
        self._Callers = Callers

    @property
    def CallOrder(self):
        return self._CallOrder

    @CallOrder.setter
    def CallOrder(self, CallOrder):
        self._CallOrder = CallOrder

    @property
    def UUI(self):
        return self._UUI

    @UUI.setter
    def UUI(self, UUI):
        self._UUI = UUI


    def _deserialize(self, params):
        self._SdkAppId = params.get("SdkAppId")
        self._Name = params.get("Name")
        self._Agent = params.get("Agent")
        self._ConcurrencyNumber = params.get("ConcurrencyNumber")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Callees = params.get("Callees")
        self._Callers = params.get("Callers")
        self._CallOrder = params.get("CallOrder")
        self._UUI = params.get("UUI")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAgentCruiseDialingCampaignResponse(AbstractModel):
    """CreateAgentCruiseDialingCampaign response structure.

    """

    def __init__(self):
        r"""
        :param _CampaignId: Generated task ID.
        :type CampaignId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._CampaignId = None
        self._RequestId = None

    @property
    def CampaignId(self):
        return self._CampaignId

    @CampaignId.setter
    def CampaignId(self, CampaignId):
        self._CampaignId = CampaignId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._CampaignId = params.get("CampaignId")
        self._RequestId = params.get("RequestId")


class CreateAutoCalloutTaskRequest(AbstractModel):
    """CreateAutoCalloutTask request structure.

    """

    def __init__(self):
        r"""
        :param _SdkAppId: Application ID (required) can be found at https://console.cloud.tencent.com/ccc.
        :type SdkAppId: int
        :param _NotBefore: Task starting timestamp. Unix second-level timestamp.
        :type NotBefore: int
        :param _Callees: List of called numbers.
        :type Callees: list of str
        :param _Callers: List of calling numbers.
        :type Callers: list of str
        :param _IvrId: IVR used for calling.
        :type IvrId: int
        :param _Name: Task name.
        :type Name: str
        :param _Description: Task description.
        :type Description: str
        :param _NotAfter: Task stop timestamp. Unix second-level timestamp.
        :type NotAfter: int
        :param _Tries: Maximum attempts, 1-3 times
        :type Tries: int
        :param _Variables: Custom variables (supported only in advanced versions).
        :type Variables: list of Variable
        :param _UUI: UUI
        :type UUI: str
        :param _CalleeAttributes: Property of the called.
        :type CalleeAttributes: list of CalleeAttribute
        """
        self._SdkAppId = None
        self._NotBefore = None
        self._Callees = None
        self._Callers = None
        self._IvrId = None
        self._Name = None
        self._Description = None
        self._NotAfter = None
        self._Tries = None
        self._Variables = None
        self._UUI = None
        self._CalleeAttributes = None

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def NotBefore(self):
        return self._NotBefore

    @NotBefore.setter
    def NotBefore(self, NotBefore):
        self._NotBefore = NotBefore

    @property
    def Callees(self):
        return self._Callees

    @Callees.setter
    def Callees(self, Callees):
        self._Callees = Callees

    @property
    def Callers(self):
        return self._Callers

    @Callers.setter
    def Callers(self, Callers):
        self._Callers = Callers

    @property
    def IvrId(self):
        return self._IvrId

    @IvrId.setter
    def IvrId(self, IvrId):
        self._IvrId = IvrId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def NotAfter(self):
        return self._NotAfter

    @NotAfter.setter
    def NotAfter(self, NotAfter):
        self._NotAfter = NotAfter

    @property
    def Tries(self):
        return self._Tries

    @Tries.setter
    def Tries(self, Tries):
        self._Tries = Tries

    @property
    def Variables(self):
        return self._Variables

    @Variables.setter
    def Variables(self, Variables):
        self._Variables = Variables

    @property
    def UUI(self):
        return self._UUI

    @UUI.setter
    def UUI(self, UUI):
        self._UUI = UUI

    @property
    def CalleeAttributes(self):
        return self._CalleeAttributes

    @CalleeAttributes.setter
    def CalleeAttributes(self, CalleeAttributes):
        self._CalleeAttributes = CalleeAttributes


    def _deserialize(self, params):
        self._SdkAppId = params.get("SdkAppId")
        self._NotBefore = params.get("NotBefore")
        self._Callees = params.get("Callees")
        self._Callers = params.get("Callers")
        self._IvrId = params.get("IvrId")
        self._Name = params.get("Name")
        self._Description = params.get("Description")
        self._NotAfter = params.get("NotAfter")
        self._Tries = params.get("Tries")
        if params.get("Variables") is not None:
            self._Variables = []
            for item in params.get("Variables"):
                obj = Variable()
                obj._deserialize(item)
                self._Variables.append(obj)
        self._UUI = params.get("UUI")
        if params.get("CalleeAttributes") is not None:
            self._CalleeAttributes = []
            for item in params.get("CalleeAttributes"):
                obj = CalleeAttribute()
                obj._deserialize(item)
                self._CalleeAttributes.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAutoCalloutTaskResponse(AbstractModel):
    """CreateAutoCalloutTask response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID.
        :type TaskId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class CreateCCCSkillGroupRequest(AbstractModel):
    """CreateCCCSkillGroup request structure.

    """

    def __init__(self):
        r"""
        :param _SdkAppId: Application ID (required).
        :type SdkAppId: int
        :param _SkillGroupName: Skill group name.
        :type SkillGroupName: str
        :param _SkillGroupType: Skill group type 0-Cell phone, 1-Online, 3-Audio, 4-Video.
        :type SkillGroupType: int
        :param _MaxConcurrency: The maximum number of people received by the skill group (the maximum number of people that one seat in this skill group can receive) is set to 1 by default. 1. If the skill group type is online, the maximum could be set to one and above.
2. If the skill group type is phone, audio, or video, then the maximum must be 1
        :type MaxConcurrency: int
        """
        self._SdkAppId = None
        self._SkillGroupName = None
        self._SkillGroupType = None
        self._MaxConcurrency = None

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def SkillGroupName(self):
        return self._SkillGroupName

    @SkillGroupName.setter
    def SkillGroupName(self, SkillGroupName):
        self._SkillGroupName = SkillGroupName

    @property
    def SkillGroupType(self):
        return self._SkillGroupType

    @SkillGroupType.setter
    def SkillGroupType(self, SkillGroupType):
        self._SkillGroupType = SkillGroupType

    @property
    def MaxConcurrency(self):
        return self._MaxConcurrency

    @MaxConcurrency.setter
    def MaxConcurrency(self, MaxConcurrency):
        self._MaxConcurrency = MaxConcurrency


    def _deserialize(self, params):
        self._SdkAppId = params.get("SdkAppId")
        self._SkillGroupName = params.get("SkillGroupName")
        self._SkillGroupType = params.get("SkillGroupType")
        self._MaxConcurrency = params.get("MaxConcurrency")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateCCCSkillGroupResponse(AbstractModel):
    """CreateCCCSkillGroup response structure.

    """

    def __init__(self):
        r"""
        :param _SkillGroupId: Skill group ID.
        :type SkillGroupId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SkillGroupId = None
        self._RequestId = None

    @property
    def SkillGroupId(self):
        return self._SkillGroupId

    @SkillGroupId.setter
    def SkillGroupId(self, SkillGroupId):
        self._SkillGroupId = SkillGroupId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SkillGroupId = params.get("SkillGroupId")
        self._RequestId = params.get("RequestId")


class CreateCallOutSessionRequest(AbstractModel):
    """CreateCallOutSession request structure.

    """

    def __init__(self):
        r"""
        :param _SdkAppId: Application ID
        :type SdkAppId: int
        :param _UserId: Customer Service User ID usually refers to the customer service email.
        :type UserId: str
        :param _Callee: Called number must be preceded by 0086.
        :type Callee: str
        :param _Caller: Caller number (obsolete one and use Callers) must be preceded by 0086.
        :type Caller: str
        :param _Callers: Designated caller number list. If the prior number fails, it will automatically switch to the next number that must be preceded by 0086.
        :type Callers: list of str
        :param _IsForceUseMobile: Whether to force the use of cell phone outbound call or not, currently only supports true, if true, please ensure that the allowlist has been configured.
        :type IsForceUseMobile: bool
        :param _Uui: Custom data, length limited to 1024 bytes.
        :type Uui: str
        :param _UUI: Custom data, length limited to 1024 bytes.
        :type UUI: str
        """
        self._SdkAppId = None
        self._UserId = None
        self._Callee = None
        self._Caller = None
        self._Callers = None
        self._IsForceUseMobile = None
        self._Uui = None
        self._UUI = None

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def UserId(self):
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def Callee(self):
        return self._Callee

    @Callee.setter
    def Callee(self, Callee):
        self._Callee = Callee

    @property
    def Caller(self):
        return self._Caller

    @Caller.setter
    def Caller(self, Caller):
        self._Caller = Caller

    @property
    def Callers(self):
        return self._Callers

    @Callers.setter
    def Callers(self, Callers):
        self._Callers = Callers

    @property
    def IsForceUseMobile(self):
        return self._IsForceUseMobile

    @IsForceUseMobile.setter
    def IsForceUseMobile(self, IsForceUseMobile):
        self._IsForceUseMobile = IsForceUseMobile

    @property
    def Uui(self):
        warnings.warn("parameter `Uui` is deprecated", DeprecationWarning) 

        return self._Uui

    @Uui.setter
    def Uui(self, Uui):
        warnings.warn("parameter `Uui` is deprecated", DeprecationWarning) 

        self._Uui = Uui

    @property
    def UUI(self):
        return self._UUI

    @UUI.setter
    def UUI(self, UUI):
        self._UUI = UUI


    def _deserialize(self, params):
        self._SdkAppId = params.get("SdkAppId")
        self._UserId = params.get("UserId")
        self._Callee = params.get("Callee")
        self._Caller = params.get("Caller")
        self._Callers = params.get("Callers")
        self._IsForceUseMobile = params.get("IsForceUseMobile")
        self._Uui = params.get("Uui")
        self._UUI = params.get("UUI")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateCallOutSessionResponse(AbstractModel):
    """CreateCallOutSession response structure.

    """

    def __init__(self):
        r"""
        :param _SessionId: Newly created session ID.
        :type SessionId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SessionId = None
        self._RequestId = None

    @property
    def SessionId(self):
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SessionId = params.get("SessionId")
        self._RequestId = params.get("RequestId")


class CreateExtensionRequest(AbstractModel):
    """CreateExtension request structure.

    """

    def __init__(self):
        r"""
        :param _SdkAppId: TCCC instance application ID.
        :type SdkAppId: int
        :param _ExtensionId: Extension
        :type ExtensionId: str
        :param _ExtensionName: Extension name.
        :type ExtensionName: str
        :param _SkillGroupIds: Bound skill group list.
        :type SkillGroupIds: list of int non-negative
        :param _Relation: Bound agent email.
        :type Relation: str
        """
        self._SdkAppId = None
        self._ExtensionId = None
        self._ExtensionName = None
        self._SkillGroupIds = None
        self._Relation = None

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def ExtensionId(self):
        return self._ExtensionId

    @ExtensionId.setter
    def ExtensionId(self, ExtensionId):
        self._ExtensionId = ExtensionId

    @property
    def ExtensionName(self):
        return self._ExtensionName

    @ExtensionName.setter
    def ExtensionName(self, ExtensionName):
        self._ExtensionName = ExtensionName

    @property
    def SkillGroupIds(self):
        return self._SkillGroupIds

    @SkillGroupIds.setter
    def SkillGroupIds(self, SkillGroupIds):
        self._SkillGroupIds = SkillGroupIds

    @property
    def Relation(self):
        return self._Relation

    @Relation.setter
    def Relation(self, Relation):
        self._Relation = Relation


    def _deserialize(self, params):
        self._SdkAppId = params.get("SdkAppId")
        self._ExtensionId = params.get("ExtensionId")
        self._ExtensionName = params.get("ExtensionName")
        self._SkillGroupIds = params.get("SkillGroupIds")
        self._Relation = params.get("Relation")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateExtensionResponse(AbstractModel):
    """CreateExtension response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateIVRSessionRequest(AbstractModel):
    """CreateIVRSession request structure.

    """

    def __init__(self):
        r"""
        :param _SdkAppId: Application ID (required) can be found at https://console.cloud.tencent.com/ccc.
        :type SdkAppId: int
        :param _Callee: Called.
        :type Callee: str
        :param _IVRId: Specified IVR Id. Currently, it supports inbound and automatic outbound types
        :type IVRId: int
        :param _Callers: List of calling numbers.
        :type Callers: list of str
        :param _Variables: Custom variable
        :type Variables: list of Variable
        :param _UUI: User Data
        :type UUI: str
        """
        self._SdkAppId = None
        self._Callee = None
        self._IVRId = None
        self._Callers = None
        self._Variables = None
        self._UUI = None

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def Callee(self):
        return self._Callee

    @Callee.setter
    def Callee(self, Callee):
        self._Callee = Callee

    @property
    def IVRId(self):
        return self._IVRId

    @IVRId.setter
    def IVRId(self, IVRId):
        self._IVRId = IVRId

    @property
    def Callers(self):
        return self._Callers

    @Callers.setter
    def Callers(self, Callers):
        self._Callers = Callers

    @property
    def Variables(self):
        return self._Variables

    @Variables.setter
    def Variables(self, Variables):
        self._Variables = Variables

    @property
    def UUI(self):
        return self._UUI

    @UUI.setter
    def UUI(self, UUI):
        self._UUI = UUI


    def _deserialize(self, params):
        self._SdkAppId = params.get("SdkAppId")
        self._Callee = params.get("Callee")
        self._IVRId = params.get("IVRId")
        self._Callers = params.get("Callers")
        if params.get("Variables") is not None:
            self._Variables = []
            for item in params.get("Variables"):
                obj = Variable()
                obj._deserialize(item)
                self._Variables.append(obj)
        self._UUI = params.get("UUI")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateIVRSessionResponse(AbstractModel):
    """CreateIVRSession response structure.

    """

    def __init__(self):
        r"""
        :param _SessionId: Newly created session ID.
        :type SessionId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SessionId = None
        self._RequestId = None

    @property
    def SessionId(self):
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SessionId = params.get("SessionId")
        self._RequestId = params.get("RequestId")


class CreatePredictiveDialingCampaignRequest(AbstractModel):
    """CreatePredictiveDialingCampaign request structure.

    """

    def __init__(self):
        r"""
        :param _SdkAppId: Application ID (required) can be found at https://console.cloud.tencent.com/ccc.
        :type SdkAppId: int
        :param _Name: Task Name
        :type Name: str
        :param _Callees: Called list supporting E.164 or number formats without country code.
        :type Callees: list of str
        :param _Callers: Calling list using the number formats displayed on the management side.
        :type Callers: list of str
        :param _CallOrder: Being called sequence: 0 for random 1 for in order.
        :type CallOrder: int
        :param _SkillGroupId: ID of the used skill group of agents.
        :type SkillGroupId: int
        :param _Priority: Running priority of multiple tasks in the same application, from high to low 1 - 5.
        :type Priority: int
        :param _ExpectedAbandonRate: Expected call drop rate, percentage, 5 - 50.
        :type ExpectedAbandonRate: int
        :param _RetryInterval: Call retry interval, in seconds, [60 - 86,400].
        :type RetryInterval: int
        :param _StartTime: Task start time. Unix timestamp. The task will automatically start after this time.
        :type StartTime: int
        :param _EndTime: Task termination time. Unix timestamp. The task will automatically terminate after this time.
        :type EndTime: int
        :param _IVRId: Specified IVR ID.
        :type IVRId: int
        :param _RetryTimes: Number of call retries, 0 - 2.
        :type RetryTimes: int
        """
        self._SdkAppId = None
        self._Name = None
        self._Callees = None
        self._Callers = None
        self._CallOrder = None
        self._SkillGroupId = None
        self._Priority = None
        self._ExpectedAbandonRate = None
        self._RetryInterval = None
        self._StartTime = None
        self._EndTime = None
        self._IVRId = None
        self._RetryTimes = None

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Callees(self):
        return self._Callees

    @Callees.setter
    def Callees(self, Callees):
        self._Callees = Callees

    @property
    def Callers(self):
        return self._Callers

    @Callers.setter
    def Callers(self, Callers):
        self._Callers = Callers

    @property
    def CallOrder(self):
        return self._CallOrder

    @CallOrder.setter
    def CallOrder(self, CallOrder):
        self._CallOrder = CallOrder

    @property
    def SkillGroupId(self):
        return self._SkillGroupId

    @SkillGroupId.setter
    def SkillGroupId(self, SkillGroupId):
        self._SkillGroupId = SkillGroupId

    @property
    def Priority(self):
        return self._Priority

    @Priority.setter
    def Priority(self, Priority):
        self._Priority = Priority

    @property
    def ExpectedAbandonRate(self):
        return self._ExpectedAbandonRate

    @ExpectedAbandonRate.setter
    def ExpectedAbandonRate(self, ExpectedAbandonRate):
        self._ExpectedAbandonRate = ExpectedAbandonRate

    @property
    def RetryInterval(self):
        return self._RetryInterval

    @RetryInterval.setter
    def RetryInterval(self, RetryInterval):
        self._RetryInterval = RetryInterval

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def IVRId(self):
        return self._IVRId

    @IVRId.setter
    def IVRId(self, IVRId):
        self._IVRId = IVRId

    @property
    def RetryTimes(self):
        return self._RetryTimes

    @RetryTimes.setter
    def RetryTimes(self, RetryTimes):
        self._RetryTimes = RetryTimes


    def _deserialize(self, params):
        self._SdkAppId = params.get("SdkAppId")
        self._Name = params.get("Name")
        self._Callees = params.get("Callees")
        self._Callers = params.get("Callers")
        self._CallOrder = params.get("CallOrder")
        self._SkillGroupId = params.get("SkillGroupId")
        self._Priority = params.get("Priority")
        self._ExpectedAbandonRate = params.get("ExpectedAbandonRate")
        self._RetryInterval = params.get("RetryInterval")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._IVRId = params.get("IVRId")
        self._RetryTimes = params.get("RetryTimes")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreatePredictiveDialingCampaignResponse(AbstractModel):
    """CreatePredictiveDialingCampaign response structure.

    """

    def __init__(self):
        r"""
        :param _CampaignId: Generated task ID.
        :type CampaignId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._CampaignId = None
        self._RequestId = None

    @property
    def CampaignId(self):
        return self._CampaignId

    @CampaignId.setter
    def CampaignId(self, CampaignId):
        self._CampaignId = CampaignId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._CampaignId = params.get("CampaignId")
        self._RequestId = params.get("RequestId")


class CreateSDKLoginTokenRequest(AbstractModel):
    """CreateSDKLoginToken request structure.

    """

    def __init__(self):
        r"""
        :param _SdkAppId: Application ID (required) can be found at https://console.cloud.tencent.com/ccc.
        :type SdkAppId: int
        :param _SeatUserId: Agent account.
        :type SeatUserId: str
        :param _OnlyOnce: Whether the generated token is for one-time verification?
        :type OnlyOnce: bool
        """
        self._SdkAppId = None
        self._SeatUserId = None
        self._OnlyOnce = None

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def SeatUserId(self):
        return self._SeatUserId

    @SeatUserId.setter
    def SeatUserId(self, SeatUserId):
        self._SeatUserId = SeatUserId

    @property
    def OnlyOnce(self):
        return self._OnlyOnce

    @OnlyOnce.setter
    def OnlyOnce(self, OnlyOnce):
        self._OnlyOnce = OnlyOnce


    def _deserialize(self, params):
        self._SdkAppId = params.get("SdkAppId")
        self._SeatUserId = params.get("SeatUserId")
        self._OnlyOnce = params.get("OnlyOnce")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSDKLoginTokenResponse(AbstractModel):
    """CreateSDKLoginToken response structure.

    """

    def __init__(self):
        r"""
        :param _Token: SDK log-in Token.
        :type Token: str
        :param _ExpiredTime: Expiry timestamp. Unix timestamp.
        :type ExpiredTime: int
        :param _SdkURL: The path in which the SDK is loaded will change with its release.
        :type SdkURL: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Token = None
        self._ExpiredTime = None
        self._SdkURL = None
        self._RequestId = None

    @property
    def Token(self):
        return self._Token

    @Token.setter
    def Token(self, Token):
        self._Token = Token

    @property
    def ExpiredTime(self):
        return self._ExpiredTime

    @ExpiredTime.setter
    def ExpiredTime(self, ExpiredTime):
        self._ExpiredTime = ExpiredTime

    @property
    def SdkURL(self):
        return self._SdkURL

    @SdkURL.setter
    def SdkURL(self, SdkURL):
        self._SdkURL = SdkURL

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Token = params.get("Token")
        self._ExpiredTime = params.get("ExpiredTime")
        self._SdkURL = params.get("SdkURL")
        self._RequestId = params.get("RequestId")


class CreateStaffRequest(AbstractModel):
    """CreateStaff request structure.

    """

    def __init__(self):
        r"""
        :param _SdkAppId: Application ID (required) can be found at https://console.cloud.tencent.com/ccc.
        :type SdkAppId: int
        :param _Staffs: Customer information, no more than 10.
        :type Staffs: list of SeatUserInfo
        :param _SendPassword: Whether to send a password mail or not (the default is true)
        :type SendPassword: bool
        """
        self._SdkAppId = None
        self._Staffs = None
        self._SendPassword = None

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def Staffs(self):
        return self._Staffs

    @Staffs.setter
    def Staffs(self, Staffs):
        self._Staffs = Staffs

    @property
    def SendPassword(self):
        return self._SendPassword

    @SendPassword.setter
    def SendPassword(self, SendPassword):
        self._SendPassword = SendPassword


    def _deserialize(self, params):
        self._SdkAppId = params.get("SdkAppId")
        if params.get("Staffs") is not None:
            self._Staffs = []
            for item in params.get("Staffs"):
                obj = SeatUserInfo()
                obj._deserialize(item)
                self._Staffs.append(obj)
        self._SendPassword = params.get("SendPassword")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateStaffResponse(AbstractModel):
    """CreateStaff response structure.

    """

    def __init__(self):
        r"""
        :param _ErrorStaffList: Error agent list and error information.
Note: This field may return null, indicating that no valid value could be obtained.
        :type ErrorStaffList: list of ErrStaffItem
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ErrorStaffList = None
        self._RequestId = None

    @property
    def ErrorStaffList(self):
        return self._ErrorStaffList

    @ErrorStaffList.setter
    def ErrorStaffList(self, ErrorStaffList):
        self._ErrorStaffList = ErrorStaffList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ErrorStaffList") is not None:
            self._ErrorStaffList = []
            for item in params.get("ErrorStaffList"):
                obj = ErrStaffItem()
                obj._deserialize(item)
                self._ErrorStaffList.append(obj)
        self._RequestId = params.get("RequestId")


class DeleteExtensionRequest(AbstractModel):
    """DeleteExtension request structure.

    """

    def __init__(self):
        r"""
        :param _SdkAppId: TCCC instance application ID.
        :type SdkAppId: int
        :param _ExtensionId: Extension
        :type ExtensionId: str
        """
        self._SdkAppId = None
        self._ExtensionId = None

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def ExtensionId(self):
        return self._ExtensionId

    @ExtensionId.setter
    def ExtensionId(self, ExtensionId):
        self._ExtensionId = ExtensionId


    def _deserialize(self, params):
        self._SdkAppId = params.get("SdkAppId")
        self._ExtensionId = params.get("ExtensionId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteExtensionResponse(AbstractModel):
    """DeleteExtension response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeletePredictiveDialingCampaignRequest(AbstractModel):
    """DeletePredictiveDialingCampaign request structure.

    """

    def __init__(self):
        r"""
        :param _SdkAppId: Application ID (required) can be found at https://console.cloud.tencent.com/ccc.
        :type SdkAppId: int
        :param _CampaignId: Task ID.
        :type CampaignId: int
        """
        self._SdkAppId = None
        self._CampaignId = None

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def CampaignId(self):
        return self._CampaignId

    @CampaignId.setter
    def CampaignId(self, CampaignId):
        self._CampaignId = CampaignId


    def _deserialize(self, params):
        self._SdkAppId = params.get("SdkAppId")
        self._CampaignId = params.get("CampaignId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeletePredictiveDialingCampaignResponse(AbstractModel):
    """DeletePredictiveDialingCampaign response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteStaffRequest(AbstractModel):
    """DeleteStaff request structure.

    """

    def __init__(self):
        r"""
        :param _SdkAppId: Application ID (required) can be found at https://console.cloud.tencent.com/ccc.
        :type SdkAppId: int
        :param _StaffList: Customer service emails, supports up to 200 at a time.
        :type StaffList: list of str
        """
        self._SdkAppId = None
        self._StaffList = None

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def StaffList(self):
        return self._StaffList

    @StaffList.setter
    def StaffList(self, StaffList):
        self._StaffList = StaffList


    def _deserialize(self, params):
        self._SdkAppId = params.get("SdkAppId")
        self._StaffList = params.get("StaffList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteStaffResponse(AbstractModel):
    """DeleteStaff response structure.

    """

    def __init__(self):
        r"""
        :param _OnlineStaffList: List of customer service staff that can't be deleted when being online.
Note: this field may return null, indicating that no valid values can be obtained.
        :type OnlineStaffList: list of str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._OnlineStaffList = None
        self._RequestId = None

    @property
    def OnlineStaffList(self):
        return self._OnlineStaffList

    @OnlineStaffList.setter
    def OnlineStaffList(self, OnlineStaffList):
        self._OnlineStaffList = OnlineStaffList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._OnlineStaffList = params.get("OnlineStaffList")
        self._RequestId = params.get("RequestId")


class DescribeAgentCruiseDialingCampaignRequest(AbstractModel):
    """DescribeAgentCruiseDialingCampaign request structure.

    """

    def __init__(self):
        r"""
        :param _SdkAppId: Application ID (required) can be found at https://console.cloud.tencent.com/ccc.
        :type SdkAppId: int
        :param _CampaignId: Task ID.
        :type CampaignId: int
        """
        self._SdkAppId = None
        self._CampaignId = None

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def CampaignId(self):
        return self._CampaignId

    @CampaignId.setter
    def CampaignId(self, CampaignId):
        self._CampaignId = CampaignId


    def _deserialize(self, params):
        self._SdkAppId = params.get("SdkAppId")
        self._CampaignId = params.get("CampaignId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAgentCruiseDialingCampaignResponse(AbstractModel):
    """DescribeAgentCruiseDialingCampaign response structure.

    """

    def __init__(self):
        r"""
        :param _Name: Task Name
        :type Name: str
        :param _Agent: Agent Account
        :type Agent: str
        :param _ConcurrencyNumber: Single-round Concurrent Call Volume 1-20
        :type ConcurrencyNumber: int
        :param _StartTime: Task start time. Unix timestamp. The task will automatically start after this time.
        :type StartTime: int
        :param _EndTime: Task termination time. Unix timestamp. The task will automatically terminate after this time.
        :type EndTime: int
        :param _CallOrder: Being called sequence: 0 for random 1 for in order.
        :type CallOrder: int
        :param _UUI: Caller Custom Data, Maximum Length 1024
        :type UUI: str
        :param _State: Task status 0 Not started 1 Running 2 Completed 3 Terminated
        :type State: int
        :param _TotalCalleeCount: Total number of called parties
        :type TotalCalleeCount: int
        :param _CalledCalleeCount: Number of called parties
        :type CalledCalleeCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Name = None
        self._Agent = None
        self._ConcurrencyNumber = None
        self._StartTime = None
        self._EndTime = None
        self._CallOrder = None
        self._UUI = None
        self._State = None
        self._TotalCalleeCount = None
        self._CalledCalleeCount = None
        self._RequestId = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Agent(self):
        return self._Agent

    @Agent.setter
    def Agent(self, Agent):
        self._Agent = Agent

    @property
    def ConcurrencyNumber(self):
        return self._ConcurrencyNumber

    @ConcurrencyNumber.setter
    def ConcurrencyNumber(self, ConcurrencyNumber):
        self._ConcurrencyNumber = ConcurrencyNumber

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def CallOrder(self):
        return self._CallOrder

    @CallOrder.setter
    def CallOrder(self, CallOrder):
        self._CallOrder = CallOrder

    @property
    def UUI(self):
        return self._UUI

    @UUI.setter
    def UUI(self, UUI):
        self._UUI = UUI

    @property
    def State(self):
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def TotalCalleeCount(self):
        return self._TotalCalleeCount

    @TotalCalleeCount.setter
    def TotalCalleeCount(self, TotalCalleeCount):
        self._TotalCalleeCount = TotalCalleeCount

    @property
    def CalledCalleeCount(self):
        return self._CalledCalleeCount

    @CalledCalleeCount.setter
    def CalledCalleeCount(self, CalledCalleeCount):
        self._CalledCalleeCount = CalledCalleeCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Agent = params.get("Agent")
        self._ConcurrencyNumber = params.get("ConcurrencyNumber")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._CallOrder = params.get("CallOrder")
        self._UUI = params.get("UUI")
        self._State = params.get("State")
        self._TotalCalleeCount = params.get("TotalCalleeCount")
        self._CalledCalleeCount = params.get("CalledCalleeCount")
        self._RequestId = params.get("RequestId")


class DescribeAutoCalloutTaskRequest(AbstractModel):
    """DescribeAutoCalloutTask request structure.

    """

    def __init__(self):
        r"""
        :param _SdkAppId: Application ID (required) can be found at https://console.cloud.tencent.com/ccc.
        :type SdkAppId: int
        :param _TaskId: Task ID.
        :type TaskId: int
        """
        self._SdkAppId = None
        self._TaskId = None

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._SdkAppId = params.get("SdkAppId")
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAutoCalloutTaskResponse(AbstractModel):
    """DescribeAutoCalloutTask response structure.

    """

    def __init__(self):
        r"""
        :param _Name: Task Name
        :type Name: str
        :param _Description: Task Description.
        :type Description: str
        :param _NotBefore: Task start timestamp.
        :type NotBefore: int
        :param _NotAfter: Task end timestamp.
Note: this field may return null, indicating that no valid values can be obtained.
        :type NotAfter: int
        :param _Callers: Calling list.
        :type Callers: list of str
        :param _Callees: Called information list.
        :type Callees: list of AutoCalloutTaskCalleeInfo
        :param _IvrId: IvrId used by the task.
        :type IvrId: int
        :param _State: Task status: 0 - initial, 1 - running, 2 - completed, 3 - ending, 4 - terminated.
        :type State: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Name = None
        self._Description = None
        self._NotBefore = None
        self._NotAfter = None
        self._Callers = None
        self._Callees = None
        self._IvrId = None
        self._State = None
        self._RequestId = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def NotBefore(self):
        return self._NotBefore

    @NotBefore.setter
    def NotBefore(self, NotBefore):
        self._NotBefore = NotBefore

    @property
    def NotAfter(self):
        return self._NotAfter

    @NotAfter.setter
    def NotAfter(self, NotAfter):
        self._NotAfter = NotAfter

    @property
    def Callers(self):
        return self._Callers

    @Callers.setter
    def Callers(self, Callers):
        self._Callers = Callers

    @property
    def Callees(self):
        return self._Callees

    @Callees.setter
    def Callees(self, Callees):
        self._Callees = Callees

    @property
    def IvrId(self):
        return self._IvrId

    @IvrId.setter
    def IvrId(self, IvrId):
        self._IvrId = IvrId

    @property
    def State(self):
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Description = params.get("Description")
        self._NotBefore = params.get("NotBefore")
        self._NotAfter = params.get("NotAfter")
        self._Callers = params.get("Callers")
        if params.get("Callees") is not None:
            self._Callees = []
            for item in params.get("Callees"):
                obj = AutoCalloutTaskCalleeInfo()
                obj._deserialize(item)
                self._Callees.append(obj)
        self._IvrId = params.get("IvrId")
        self._State = params.get("State")
        self._RequestId = params.get("RequestId")


class DescribeAutoCalloutTasksRequest(AbstractModel):
    """DescribeAutoCalloutTasks request structure.

    """

    def __init__(self):
        r"""
        :param _SdkAppId: Application ID (required) can be found at https://console.cloud.tencent.com/ccc.
        :type SdkAppId: int
        :param _PageSize: Page size
        :type PageSize: int
        :param _PageNumber: Page number
        :type PageNumber: int
        """
        self._SdkAppId = None
        self._PageSize = None
        self._PageNumber = None

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber


    def _deserialize(self, params):
        self._SdkAppId = params.get("SdkAppId")
        self._PageSize = params.get("PageSize")
        self._PageNumber = params.get("PageNumber")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAutoCalloutTasksResponse(AbstractModel):
    """DescribeAutoCalloutTasks response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total quantity.
        :type TotalCount: int
        :param _Tasks: Task list.
        :type Tasks: list of AutoCalloutTaskInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Tasks = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Tasks(self):
        return self._Tasks

    @Tasks.setter
    def Tasks(self, Tasks):
        self._Tasks = Tasks

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Tasks") is not None:
            self._Tasks = []
            for item in params.get("Tasks"):
                obj = AutoCalloutTaskInfo()
                obj._deserialize(item)
                self._Tasks.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCCCBuyInfoListRequest(AbstractModel):
    """DescribeCCCBuyInfoList request structure.

    """

    def __init__(self):
        r"""
        :param _SdkAppIds: Application ID list, query all applications when not transmitted.
        :type SdkAppIds: list of int
        """
        self._SdkAppIds = None

    @property
    def SdkAppIds(self):
        return self._SdkAppIds

    @SdkAppIds.setter
    def SdkAppIds(self, SdkAppIds):
        self._SdkAppIds = SdkAppIds


    def _deserialize(self, params):
        self._SdkAppIds = params.get("SdkAppIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCCCBuyInfoListResponse(AbstractModel):
    """DescribeCCCBuyInfoList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of applications.
        :type TotalCount: int
        :param _SdkAppIdBuyList: Application purchase information list.
        :type SdkAppIdBuyList: list of SdkAppIdBuyInfo
        :param _PackageBuyList: Package purchase information list.
        :type PackageBuyList: list of PackageBuyInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._SdkAppIdBuyList = None
        self._PackageBuyList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def SdkAppIdBuyList(self):
        return self._SdkAppIdBuyList

    @SdkAppIdBuyList.setter
    def SdkAppIdBuyList(self, SdkAppIdBuyList):
        self._SdkAppIdBuyList = SdkAppIdBuyList

    @property
    def PackageBuyList(self):
        return self._PackageBuyList

    @PackageBuyList.setter
    def PackageBuyList(self, PackageBuyList):
        self._PackageBuyList = PackageBuyList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("SdkAppIdBuyList") is not None:
            self._SdkAppIdBuyList = []
            for item in params.get("SdkAppIdBuyList"):
                obj = SdkAppIdBuyInfo()
                obj._deserialize(item)
                self._SdkAppIdBuyList.append(obj)
        if params.get("PackageBuyList") is not None:
            self._PackageBuyList = []
            for item in params.get("PackageBuyList"):
                obj = PackageBuyInfo()
                obj._deserialize(item)
                self._PackageBuyList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCallInMetricsRequest(AbstractModel):
    """DescribeCallInMetrics request structure.

    """

    def __init__(self):
        r"""
        :param _SdkAppId: Application ID (required) can be found at https://console.cloud.tencent.com/ccc.
        :type SdkAppId: int
        :param _EnabledSkillGroup: Whether to return skill group dimension information or not (the default is "Yes").
        :type EnabledSkillGroup: bool
        :param _EnabledNumber: Whether to return line dimension information or not (the default is "No").
        :type EnabledNumber: bool
        :param _GroupIdList: Filter skill group list.
        :type GroupIdList: list of int
        """
        self._SdkAppId = None
        self._EnabledSkillGroup = None
        self._EnabledNumber = None
        self._GroupIdList = None

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def EnabledSkillGroup(self):
        return self._EnabledSkillGroup

    @EnabledSkillGroup.setter
    def EnabledSkillGroup(self, EnabledSkillGroup):
        self._EnabledSkillGroup = EnabledSkillGroup

    @property
    def EnabledNumber(self):
        return self._EnabledNumber

    @EnabledNumber.setter
    def EnabledNumber(self, EnabledNumber):
        self._EnabledNumber = EnabledNumber

    @property
    def GroupIdList(self):
        return self._GroupIdList

    @GroupIdList.setter
    def GroupIdList(self, GroupIdList):
        self._GroupIdList = GroupIdList


    def _deserialize(self, params):
        self._SdkAppId = params.get("SdkAppId")
        self._EnabledSkillGroup = params.get("EnabledSkillGroup")
        self._EnabledNumber = params.get("EnabledNumber")
        self._GroupIdList = params.get("GroupIdList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCallInMetricsResponse(AbstractModel):
    """DescribeCallInMetrics response structure.

    """

    def __init__(self):
        r"""
        :param _Timestamp: Timestamp.
        :type Timestamp: int
        :param _TotalMetrics: Overall metrics.
        :type TotalMetrics: :class:`tencentcloud.ccc.v20200210.models.CallInMetrics`
        :param _NumberMetrics: Circuit dimension metrics.
Note: this field may return null, indicating that no valid values can be obtained.
        :type NumberMetrics: list of CallInNumberMetrics
        :param _SkillGroupMetrics: Skill group dimension metrics
Note: this field may return null, indicating that no valid values can be obtained.
        :type SkillGroupMetrics: list of CallInSkillGroupMetrics
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Timestamp = None
        self._TotalMetrics = None
        self._NumberMetrics = None
        self._SkillGroupMetrics = None
        self._RequestId = None

    @property
    def Timestamp(self):
        return self._Timestamp

    @Timestamp.setter
    def Timestamp(self, Timestamp):
        self._Timestamp = Timestamp

    @property
    def TotalMetrics(self):
        return self._TotalMetrics

    @TotalMetrics.setter
    def TotalMetrics(self, TotalMetrics):
        self._TotalMetrics = TotalMetrics

    @property
    def NumberMetrics(self):
        return self._NumberMetrics

    @NumberMetrics.setter
    def NumberMetrics(self, NumberMetrics):
        self._NumberMetrics = NumberMetrics

    @property
    def SkillGroupMetrics(self):
        return self._SkillGroupMetrics

    @SkillGroupMetrics.setter
    def SkillGroupMetrics(self, SkillGroupMetrics):
        self._SkillGroupMetrics = SkillGroupMetrics

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Timestamp = params.get("Timestamp")
        if params.get("TotalMetrics") is not None:
            self._TotalMetrics = CallInMetrics()
            self._TotalMetrics._deserialize(params.get("TotalMetrics"))
        if params.get("NumberMetrics") is not None:
            self._NumberMetrics = []
            for item in params.get("NumberMetrics"):
                obj = CallInNumberMetrics()
                obj._deserialize(item)
                self._NumberMetrics.append(obj)
        if params.get("SkillGroupMetrics") is not None:
            self._SkillGroupMetrics = []
            for item in params.get("SkillGroupMetrics"):
                obj = CallInSkillGroupMetrics()
                obj._deserialize(item)
                self._SkillGroupMetrics.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeExtensionRequest(AbstractModel):
    """DescribeExtension request structure.

    """

    def __init__(self):
        r"""
        :param _SdkAppId: TCCC instance application ID.
        :type SdkAppId: int
        :param _ExtensionId: Extension
        :type ExtensionId: str
        """
        self._SdkAppId = None
        self._ExtensionId = None

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def ExtensionId(self):
        return self._ExtensionId

    @ExtensionId.setter
    def ExtensionId(self, ExtensionId):
        self._ExtensionId = ExtensionId


    def _deserialize(self, params):
        self._SdkAppId = params.get("SdkAppId")
        self._ExtensionId = params.get("ExtensionId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeExtensionResponse(AbstractModel):
    """DescribeExtension response structure.

    """

    def __init__(self):
        r"""
        :param _ExtensionId: Extension
        :type ExtensionId: str
        :param _ExtensionDomain: Domain name
        :type ExtensionDomain: str
        :param _Password: Registered password.
        :type Password: str
        :param _OutboundProxy: Proxy server address.
        :type OutboundProxy: str
        :param _Transport: Transfer protocol.
        :type Transport: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ExtensionId = None
        self._ExtensionDomain = None
        self._Password = None
        self._OutboundProxy = None
        self._Transport = None
        self._RequestId = None

    @property
    def ExtensionId(self):
        return self._ExtensionId

    @ExtensionId.setter
    def ExtensionId(self, ExtensionId):
        self._ExtensionId = ExtensionId

    @property
    def ExtensionDomain(self):
        return self._ExtensionDomain

    @ExtensionDomain.setter
    def ExtensionDomain(self, ExtensionDomain):
        self._ExtensionDomain = ExtensionDomain

    @property
    def Password(self):
        return self._Password

    @Password.setter
    def Password(self, Password):
        self._Password = Password

    @property
    def OutboundProxy(self):
        return self._OutboundProxy

    @OutboundProxy.setter
    def OutboundProxy(self, OutboundProxy):
        self._OutboundProxy = OutboundProxy

    @property
    def Transport(self):
        return self._Transport

    @Transport.setter
    def Transport(self, Transport):
        self._Transport = Transport

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ExtensionId = params.get("ExtensionId")
        self._ExtensionDomain = params.get("ExtensionDomain")
        self._Password = params.get("Password")
        self._OutboundProxy = params.get("OutboundProxy")
        self._Transport = params.get("Transport")
        self._RequestId = params.get("RequestId")


class DescribeExtensionsRequest(AbstractModel):
    """DescribeExtensions request structure.

    """

    def __init__(self):
        r"""
        :param _SdkAppId: TCCC instance application ID.
        :type SdkAppId: int
        :param _PageNumber: Page number (starting from 0)
        :type PageNumber: int
        :param _ExtensionIds: Filtering extension number list
        :type ExtensionIds: list of str
        :param _PageSize: Page size
        :type PageSize: int
        :param _FuzzingKeyWord: Fuzzy query field (fuzzy query for extension number, extension name, agent email, and agent name).
        :type FuzzingKeyWord: str
        :param _IsNeedStatus: Whether to return the current status of the telephone or not.
        :type IsNeedStatus: bool
        """
        self._SdkAppId = None
        self._PageNumber = None
        self._ExtensionIds = None
        self._PageSize = None
        self._FuzzingKeyWord = None
        self._IsNeedStatus = None

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def ExtensionIds(self):
        return self._ExtensionIds

    @ExtensionIds.setter
    def ExtensionIds(self, ExtensionIds):
        self._ExtensionIds = ExtensionIds

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def FuzzingKeyWord(self):
        return self._FuzzingKeyWord

    @FuzzingKeyWord.setter
    def FuzzingKeyWord(self, FuzzingKeyWord):
        self._FuzzingKeyWord = FuzzingKeyWord

    @property
    def IsNeedStatus(self):
        return self._IsNeedStatus

    @IsNeedStatus.setter
    def IsNeedStatus(self, IsNeedStatus):
        self._IsNeedStatus = IsNeedStatus


    def _deserialize(self, params):
        self._SdkAppId = params.get("SdkAppId")
        self._PageNumber = params.get("PageNumber")
        self._ExtensionIds = params.get("ExtensionIds")
        self._PageSize = params.get("PageSize")
        self._FuzzingKeyWord = params.get("FuzzingKeyWord")
        self._IsNeedStatus = params.get("IsNeedStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeExtensionsResponse(AbstractModel):
    """DescribeExtensions response structure.

    """

    def __init__(self):
        r"""
        :param _Total: Total query count.
        :type Total: int
        :param _ExtensionList: Telephone information list.
        :type ExtensionList: list of ExtensionInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Total = None
        self._ExtensionList = None
        self._RequestId = None

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def ExtensionList(self):
        return self._ExtensionList

    @ExtensionList.setter
    def ExtensionList(self, ExtensionList):
        self._ExtensionList = ExtensionList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("ExtensionList") is not None:
            self._ExtensionList = []
            for item in params.get("ExtensionList"):
                obj = ExtensionInfo()
                obj._deserialize(item)
                self._ExtensionList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeIvrAudioListRequest(AbstractModel):
    """DescribeIvrAudioList request structure.

    """

    def __init__(self):
        r"""
        :param _SdkAppId: Application ID (required) can be found at https://console.cloud.tencent.com/ccc.
        :type SdkAppId: int
        :param _PageSize: Page size, upper limit 50
        :type PageSize: int
        :param _PageNumber: Page number starting from 0.
        :type PageNumber: int
        :param _CustomFileName: File alias
        :type CustomFileName: list of str
        :param _AudioFileName: Filename
        :type AudioFileName: list of str
        :param _FileId: File ID
        :type FileId: list of int non-negative
        """
        self._SdkAppId = None
        self._PageSize = None
        self._PageNumber = None
        self._CustomFileName = None
        self._AudioFileName = None
        self._FileId = None

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def CustomFileName(self):
        return self._CustomFileName

    @CustomFileName.setter
    def CustomFileName(self, CustomFileName):
        self._CustomFileName = CustomFileName

    @property
    def AudioFileName(self):
        return self._AudioFileName

    @AudioFileName.setter
    def AudioFileName(self, AudioFileName):
        self._AudioFileName = AudioFileName

    @property
    def FileId(self):
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId


    def _deserialize(self, params):
        self._SdkAppId = params.get("SdkAppId")
        self._PageSize = params.get("PageSize")
        self._PageNumber = params.get("PageNumber")
        self._CustomFileName = params.get("CustomFileName")
        self._AudioFileName = params.get("AudioFileName")
        self._FileId = params.get("FileId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIvrAudioListResponse(AbstractModel):
    """DescribeIvrAudioList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number
        :type TotalCount: int
        :param _FileInfo: File Information
        :type FileInfo: list of AudioFileInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._FileInfo = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def FileInfo(self):
        return self._FileInfo

    @FileInfo.setter
    def FileInfo(self, FileInfo):
        self._FileInfo = FileInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("FileInfo") is not None:
            self._FileInfo = []
            for item in params.get("FileInfo"):
                obj = AudioFileInfo()
                obj._deserialize(item)
                self._FileInfo.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeNumbersRequest(AbstractModel):
    """DescribeNumbers request structure.

    """

    def __init__(self):
        r"""
        :param _SdkAppId: Application ID (required) can be found at https://console.cloud.tencent.com/ccc.
        :type SdkAppId: int
        :param _PageNumber: Page number, starting from 0.
        :type PageNumber: int
        :param _PageSize: Page size, default 20.
        :type PageSize: int
        """
        self._SdkAppId = None
        self._PageNumber = None
        self._PageSize = None

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        self._SdkAppId = params.get("SdkAppId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNumbersResponse(AbstractModel):
    """DescribeNumbers response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total quantity
        :type TotalCount: int
        :param _Numbers: Number list.
        :type Numbers: list of NumberInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Numbers = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Numbers(self):
        return self._Numbers

    @Numbers.setter
    def Numbers(self, Numbers):
        self._Numbers = Numbers

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Numbers") is not None:
            self._Numbers = []
            for item in params.get("Numbers"):
                obj = NumberInfo()
                obj._deserialize(item)
                self._Numbers.append(obj)
        self._RequestId = params.get("RequestId")


class DescribePSTNActiveSessionListRequest(AbstractModel):
    """DescribePSTNActiveSessionList request structure.

    """

    def __init__(self):
        r"""
        :param _SdkAppId: Application ID (required) can be found at https://console.cloud.tencent.com/ccc.
        :type SdkAppId: int
        :param _Offset: Data offset.
        :type Offset: int
        :param _Limit: Number of returned data entries, up to 25.
        :type Limit: int
        """
        self._SdkAppId = None
        self._Offset = None
        self._Limit = None

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SdkAppId = params.get("SdkAppId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePSTNActiveSessionListResponse(AbstractModel):
    """DescribePSTNActiveSessionList response structure.

    """

    def __init__(self):
        r"""
        :param _Total: Total number of items in the list.
        :type Total: int
        :param _Sessions: List content.
        :type Sessions: list of PSTNSessionInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Total = None
        self._Sessions = None
        self._RequestId = None

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Sessions(self):
        return self._Sessions

    @Sessions.setter
    def Sessions(self, Sessions):
        self._Sessions = Sessions

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("Sessions") is not None:
            self._Sessions = []
            for item in params.get("Sessions"):
                obj = PSTNSessionInfo()
                obj._deserialize(item)
                self._Sessions.append(obj)
        self._RequestId = params.get("RequestId")


class DescribePredictiveDialingCampaignRequest(AbstractModel):
    """DescribePredictiveDialingCampaign request structure.

    """

    def __init__(self):
        r"""
        :param _SdkAppId: Application ID (required) can be found at https://console.cloud.tencent.com/ccc.
        :type SdkAppId: int
        :param _CampaignId: Task ID.
        :type CampaignId: int
        """
        self._SdkAppId = None
        self._CampaignId = None

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def CampaignId(self):
        return self._CampaignId

    @CampaignId.setter
    def CampaignId(self, CampaignId):
        self._CampaignId = CampaignId


    def _deserialize(self, params):
        self._SdkAppId = params.get("SdkAppId")
        self._CampaignId = params.get("CampaignId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePredictiveDialingCampaignResponse(AbstractModel):
    """DescribePredictiveDialingCampaign response structure.

    """

    def __init__(self):
        r"""
        :param _CampaignId: Task ID.
        :type CampaignId: int
        :param _Name: Task Name
        :type Name: str
        :param _CallOrder: Being called sequence: 0 for random 1 for in order.
        :type CallOrder: int
        :param _SkillGroupId: ID of the used skill group of agents.
        :type SkillGroupId: int
        :param _IVRId: Specified IVR ID.
        :type IVRId: int
        :param _Priority: Running priority of multiple tasks in the same application, from high to low 1 - 5.
        :type Priority: int
        :param _ExpectedAbandonRate: Expected call drop rate, percentage, 5 - 50.
        :type ExpectedAbandonRate: int
        :param _RetryTimes: Number of call retries, 0 - 2.
        :type RetryTimes: int
        :param _RetryInterval: Call retry interval, in seconds, [60 - 86,400].
        :type RetryInterval: int
        :param _StartTime: Task start time. Unix timestamp. The task will automatically start after this time.
        :type StartTime: int
        :param _EndTime: Task termination time. Unix timestamp. The task will automatically terminate after this time.
        :type EndTime: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._CampaignId = None
        self._Name = None
        self._CallOrder = None
        self._SkillGroupId = None
        self._IVRId = None
        self._Priority = None
        self._ExpectedAbandonRate = None
        self._RetryTimes = None
        self._RetryInterval = None
        self._StartTime = None
        self._EndTime = None
        self._RequestId = None

    @property
    def CampaignId(self):
        return self._CampaignId

    @CampaignId.setter
    def CampaignId(self, CampaignId):
        self._CampaignId = CampaignId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def CallOrder(self):
        return self._CallOrder

    @CallOrder.setter
    def CallOrder(self, CallOrder):
        self._CallOrder = CallOrder

    @property
    def SkillGroupId(self):
        return self._SkillGroupId

    @SkillGroupId.setter
    def SkillGroupId(self, SkillGroupId):
        self._SkillGroupId = SkillGroupId

    @property
    def IVRId(self):
        return self._IVRId

    @IVRId.setter
    def IVRId(self, IVRId):
        self._IVRId = IVRId

    @property
    def Priority(self):
        return self._Priority

    @Priority.setter
    def Priority(self, Priority):
        self._Priority = Priority

    @property
    def ExpectedAbandonRate(self):
        return self._ExpectedAbandonRate

    @ExpectedAbandonRate.setter
    def ExpectedAbandonRate(self, ExpectedAbandonRate):
        self._ExpectedAbandonRate = ExpectedAbandonRate

    @property
    def RetryTimes(self):
        return self._RetryTimes

    @RetryTimes.setter
    def RetryTimes(self, RetryTimes):
        self._RetryTimes = RetryTimes

    @property
    def RetryInterval(self):
        return self._RetryInterval

    @RetryInterval.setter
    def RetryInterval(self, RetryInterval):
        self._RetryInterval = RetryInterval

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._CampaignId = params.get("CampaignId")
        self._Name = params.get("Name")
        self._CallOrder = params.get("CallOrder")
        self._SkillGroupId = params.get("SkillGroupId")
        self._IVRId = params.get("IVRId")
        self._Priority = params.get("Priority")
        self._ExpectedAbandonRate = params.get("ExpectedAbandonRate")
        self._RetryTimes = params.get("RetryTimes")
        self._RetryInterval = params.get("RetryInterval")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._RequestId = params.get("RequestId")


class DescribePredictiveDialingCampaignsElement(AbstractModel):
    """Query the predictive outbound call task list elements.

    """

    def __init__(self):
        r"""
        :param _CampaignId: Task ID
Note: This field may return null if no valid value is obtained.
        :type CampaignId: int
        :param _Name: Task Name
Note: This field might return null if no valid values can be obtained.
        :type Name: str
        :param _Status: Task status 0 - Ready to start, 1 - In progress, 2 - Paused, 3 - Terminated, 4 - Completed.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Status: int
        :param _StatusReason: Task status reasons 0 - Normal, 1 - Manually ended, 2 - Ended due to overtime.
Note: this field may return null, indicating that no valid values can be obtained.
        :type StatusReason: int
        :param _CalleeCount: Number of called numbers.
Note: this field may return null, indicating that no valid values can be obtained.
        :type CalleeCount: int
        :param _FinishedCalleeCount: Number of completed calls.
Note: this field may return null, indicating that no valid values can be obtained.
        :type FinishedCalleeCount: int
        :param _Priority: Running priority of multiple tasks in the same application, from high to low 1 - 5.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Priority: int
        :param _SkillGroupId: ID of the used skill group of agents.
Note: this field may return null, indicating that no valid values can be obtained.
        :type SkillGroupId: int
        """
        self._CampaignId = None
        self._Name = None
        self._Status = None
        self._StatusReason = None
        self._CalleeCount = None
        self._FinishedCalleeCount = None
        self._Priority = None
        self._SkillGroupId = None

    @property
    def CampaignId(self):
        return self._CampaignId

    @CampaignId.setter
    def CampaignId(self, CampaignId):
        self._CampaignId = CampaignId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def StatusReason(self):
        return self._StatusReason

    @StatusReason.setter
    def StatusReason(self, StatusReason):
        self._StatusReason = StatusReason

    @property
    def CalleeCount(self):
        return self._CalleeCount

    @CalleeCount.setter
    def CalleeCount(self, CalleeCount):
        self._CalleeCount = CalleeCount

    @property
    def FinishedCalleeCount(self):
        return self._FinishedCalleeCount

    @FinishedCalleeCount.setter
    def FinishedCalleeCount(self, FinishedCalleeCount):
        self._FinishedCalleeCount = FinishedCalleeCount

    @property
    def Priority(self):
        return self._Priority

    @Priority.setter
    def Priority(self, Priority):
        self._Priority = Priority

    @property
    def SkillGroupId(self):
        return self._SkillGroupId

    @SkillGroupId.setter
    def SkillGroupId(self, SkillGroupId):
        self._SkillGroupId = SkillGroupId


    def _deserialize(self, params):
        self._CampaignId = params.get("CampaignId")
        self._Name = params.get("Name")
        self._Status = params.get("Status")
        self._StatusReason = params.get("StatusReason")
        self._CalleeCount = params.get("CalleeCount")
        self._FinishedCalleeCount = params.get("FinishedCalleeCount")
        self._Priority = params.get("Priority")
        self._SkillGroupId = params.get("SkillGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePredictiveDialingCampaignsRequest(AbstractModel):
    """DescribePredictiveDialingCampaigns request structure.

    """

    def __init__(self):
        r"""
        :param _SdkAppId: Application ID (required) can be found at https://console.cloud.tencent.com/ccc.
        :type SdkAppId: int
        :param _PageSize: Page size, 100 maximum.
        :type PageSize: int
        :param _PageNumber: Page number starting from 0.
        :type PageNumber: int
        :param _Name: Query the task list name keyword.
        :type Name: str
        :param _SkillGroupId: Query task list skill group ID.
        :type SkillGroupId: int
        """
        self._SdkAppId = None
        self._PageSize = None
        self._PageNumber = None
        self._Name = None
        self._SkillGroupId = None

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def SkillGroupId(self):
        return self._SkillGroupId

    @SkillGroupId.setter
    def SkillGroupId(self, SkillGroupId):
        self._SkillGroupId = SkillGroupId


    def _deserialize(self, params):
        self._SdkAppId = params.get("SdkAppId")
        self._PageSize = params.get("PageSize")
        self._PageNumber = params.get("PageNumber")
        self._Name = params.get("Name")
        self._SkillGroupId = params.get("SkillGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePredictiveDialingCampaignsResponse(AbstractModel):
    """DescribePredictiveDialingCampaigns response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total data volume.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _CampaignList: Data
Note: This field may return null, indicating that no valid values can be obtained.
        :type CampaignList: list of DescribePredictiveDialingCampaignsElement
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._CampaignList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def CampaignList(self):
        return self._CampaignList

    @CampaignList.setter
    def CampaignList(self, CampaignList):
        self._CampaignList = CampaignList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("CampaignList") is not None:
            self._CampaignList = []
            for item in params.get("CampaignList"):
                obj = DescribePredictiveDialingCampaignsElement()
                obj._deserialize(item)
                self._CampaignList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribePredictiveDialingSessionsRequest(AbstractModel):
    """DescribePredictiveDialingSessions request structure.

    """

    def __init__(self):
        r"""
        :param _SdkAppId: Application ID (required) can be found at https://console.cloud.tencent.com/ccc.
        :type SdkAppId: int
        :param _CampaignId: Generated task ID.
        :type CampaignId: int
        :param _PageSize: Page size, maximum of 1000
        :type PageSize: int
        :param _PageNumber: Page number starting from 0.
        :type PageNumber: int
        """
        self._SdkAppId = None
        self._CampaignId = None
        self._PageSize = None
        self._PageNumber = None

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def CampaignId(self):
        return self._CampaignId

    @CampaignId.setter
    def CampaignId(self, CampaignId):
        self._CampaignId = CampaignId

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber


    def _deserialize(self, params):
        self._SdkAppId = params.get("SdkAppId")
        self._CampaignId = params.get("CampaignId")
        self._PageSize = params.get("PageSize")
        self._PageNumber = params.get("PageNumber")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePredictiveDialingSessionsResponse(AbstractModel):
    """DescribePredictiveDialingSessions response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total data volume.
        :type TotalCount: int
        :param _SessionList: List of session IDs for a call. You can access detailed call bills in batches through https://intl.cloud.tencent.com/document/product/679/47714.?from_cn_redirect=1
        :type SessionList: list of str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._SessionList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def SessionList(self):
        return self._SessionList

    @SessionList.setter
    def SessionList(self, SessionList):
        self._SessionList = SessionList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        self._SessionList = params.get("SessionList")
        self._RequestId = params.get("RequestId")


class DescribeProtectedTelCdrRequest(AbstractModel):
    """DescribeProtectedTelCdr request structure.

    """

    def __init__(self):
        r"""
        :param _StartTimeStamp: Start timestamp. Unix second-level timestamp.
        :type StartTimeStamp: int
        :param _EndTimeStamp: End timestamp. Unix second-level timestamp.
        :type EndTimeStamp: int
        :param _SdkAppId: For the Application ID, go to https://console.cloud.tencent.com/ccc.
        :type SdkAppId: int
        :param _PageSize: Page size, upper limit 100.
        :type PageSize: int
        :param _PageNumber: Page number starting from 0.
        :type PageNumber: int
        """
        self._StartTimeStamp = None
        self._EndTimeStamp = None
        self._SdkAppId = None
        self._PageSize = None
        self._PageNumber = None

    @property
    def StartTimeStamp(self):
        return self._StartTimeStamp

    @StartTimeStamp.setter
    def StartTimeStamp(self, StartTimeStamp):
        self._StartTimeStamp = StartTimeStamp

    @property
    def EndTimeStamp(self):
        return self._EndTimeStamp

    @EndTimeStamp.setter
    def EndTimeStamp(self, EndTimeStamp):
        self._EndTimeStamp = EndTimeStamp

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber


    def _deserialize(self, params):
        self._StartTimeStamp = params.get("StartTimeStamp")
        self._EndTimeStamp = params.get("EndTimeStamp")
        self._SdkAppId = params.get("SdkAppId")
        self._PageSize = params.get("PageSize")
        self._PageNumber = params.get("PageNumber")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeProtectedTelCdrResponse(AbstractModel):
    """DescribeProtectedTelCdr response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of call records.
        :type TotalCount: int
        :param _TelCdrs: Call record.
        :type TelCdrs: list of TelCdrInfo
        :param _TelCdrList: Call record.
        :type TelCdrList: list of TelCdrInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._TelCdrs = None
        self._TelCdrList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TelCdrs(self):
        warnings.warn("parameter `TelCdrs` is deprecated", DeprecationWarning) 

        return self._TelCdrs

    @TelCdrs.setter
    def TelCdrs(self, TelCdrs):
        warnings.warn("parameter `TelCdrs` is deprecated", DeprecationWarning) 

        self._TelCdrs = TelCdrs

    @property
    def TelCdrList(self):
        return self._TelCdrList

    @TelCdrList.setter
    def TelCdrList(self, TelCdrList):
        self._TelCdrList = TelCdrList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("TelCdrs") is not None:
            self._TelCdrs = []
            for item in params.get("TelCdrs"):
                obj = TelCdrInfo()
                obj._deserialize(item)
                self._TelCdrs.append(obj)
        if params.get("TelCdrList") is not None:
            self._TelCdrList = []
            for item in params.get("TelCdrList"):
                obj = TelCdrInfo()
                obj._deserialize(item)
                self._TelCdrList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSkillGroupInfoListRequest(AbstractModel):
    """DescribeSkillGroupInfoList request structure.

    """

    def __init__(self):
        r"""
        :param _SdkAppId: Application ID (required) can be found at https://console.cloud.tencent.com/ccc.
        :type SdkAppId: int
        :param _PageSize: Page size, upper limit 100.
        :type PageSize: int
        :param _PageNumber: Page number starting from 0.
        :type PageNumber: int
        :param _SkillGroupId: Using skill group ID when querying a single skill group.
        :type SkillGroupId: int
        :param _ModifiedTime: Used when querying skill groups with a modified time greater or equal to ModifiedTime.
        :type ModifiedTime: int
        :param _SkillGroupName: Skill group name.
        :type SkillGroupName: str
        """
        self._SdkAppId = None
        self._PageSize = None
        self._PageNumber = None
        self._SkillGroupId = None
        self._ModifiedTime = None
        self._SkillGroupName = None

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def SkillGroupId(self):
        return self._SkillGroupId

    @SkillGroupId.setter
    def SkillGroupId(self, SkillGroupId):
        self._SkillGroupId = SkillGroupId

    @property
    def ModifiedTime(self):
        return self._ModifiedTime

    @ModifiedTime.setter
    def ModifiedTime(self, ModifiedTime):
        self._ModifiedTime = ModifiedTime

    @property
    def SkillGroupName(self):
        return self._SkillGroupName

    @SkillGroupName.setter
    def SkillGroupName(self, SkillGroupName):
        self._SkillGroupName = SkillGroupName


    def _deserialize(self, params):
        self._SdkAppId = params.get("SdkAppId")
        self._PageSize = params.get("PageSize")
        self._PageNumber = params.get("PageNumber")
        self._SkillGroupId = params.get("SkillGroupId")
        self._ModifiedTime = params.get("ModifiedTime")
        self._SkillGroupName = params.get("SkillGroupName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSkillGroupInfoListResponse(AbstractModel):
    """DescribeSkillGroupInfoList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of skill groups.
        :type TotalCount: int
        :param _SkillGroupList: Skill Group Information List.
        :type SkillGroupList: list of SkillGroupInfoItem
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._SkillGroupList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def SkillGroupList(self):
        return self._SkillGroupList

    @SkillGroupList.setter
    def SkillGroupList(self, SkillGroupList):
        self._SkillGroupList = SkillGroupList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("SkillGroupList") is not None:
            self._SkillGroupList = []
            for item in params.get("SkillGroupList"):
                obj = SkillGroupInfoItem()
                obj._deserialize(item)
                self._SkillGroupList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeStaffInfoListRequest(AbstractModel):
    """DescribeStaffInfoList request structure.

    """

    def __init__(self):
        r"""
        :param _SdkAppId: Application ID (required) can be found at https://console.cloud.tencent.com/ccc.
        :type SdkAppId: int
        :param _PageSize: Page size, upper limit 9,999
        :type PageSize: int
        :param _PageNumber: Page number starting from 0.
        :type PageNumber: int
        :param _StaffMail: Agent account used when querying a single agent.
        :type StaffMail: str
        :param _ModifiedTime: Use when querying for agents with a modification time greater or equal to ModifiedTime.
        :type ModifiedTime: int
        :param _SkillGroupId: Skill group ID.
        :type SkillGroupId: int
        """
        self._SdkAppId = None
        self._PageSize = None
        self._PageNumber = None
        self._StaffMail = None
        self._ModifiedTime = None
        self._SkillGroupId = None

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def StaffMail(self):
        return self._StaffMail

    @StaffMail.setter
    def StaffMail(self, StaffMail):
        self._StaffMail = StaffMail

    @property
    def ModifiedTime(self):
        return self._ModifiedTime

    @ModifiedTime.setter
    def ModifiedTime(self, ModifiedTime):
        self._ModifiedTime = ModifiedTime

    @property
    def SkillGroupId(self):
        return self._SkillGroupId

    @SkillGroupId.setter
    def SkillGroupId(self, SkillGroupId):
        self._SkillGroupId = SkillGroupId


    def _deserialize(self, params):
        self._SdkAppId = params.get("SdkAppId")
        self._PageSize = params.get("PageSize")
        self._PageNumber = params.get("PageNumber")
        self._StaffMail = params.get("StaffMail")
        self._ModifiedTime = params.get("ModifiedTime")
        self._SkillGroupId = params.get("SkillGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeStaffInfoListResponse(AbstractModel):
    """DescribeStaffInfoList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of agent users.
        :type TotalCount: int
        :param _StaffList: Agent user information list.
        :type StaffList: list of StaffInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._StaffList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def StaffList(self):
        return self._StaffList

    @StaffList.setter
    def StaffList(self, StaffList):
        self._StaffList = StaffList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("StaffList") is not None:
            self._StaffList = []
            for item in params.get("StaffList"):
                obj = StaffInfo()
                obj._deserialize(item)
                self._StaffList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeStaffStatusMetricsRequest(AbstractModel):
    """DescribeStaffStatusMetrics request structure.

    """

    def __init__(self):
        r"""
        :param _SdkAppId: Application ID (required) can be found at https://console.cloud.tencent.com/ccc.
        :type SdkAppId: int
        :param _StaffList: Filter agent list. By default, do not pass all returned agent information.
        :type StaffList: list of str
        :param _GroupIdList: Filter skill group ID list.
        :type GroupIdList: list of int
        :param _StatusList: Filter agent status list Agent status free Available | busy Busy | rest On Break | notReady Not Ready | afterCallWork Post-call Adjustment | offline Offline
        :type StatusList: list of str
        """
        self._SdkAppId = None
        self._StaffList = None
        self._GroupIdList = None
        self._StatusList = None

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def StaffList(self):
        return self._StaffList

    @StaffList.setter
    def StaffList(self, StaffList):
        self._StaffList = StaffList

    @property
    def GroupIdList(self):
        return self._GroupIdList

    @GroupIdList.setter
    def GroupIdList(self, GroupIdList):
        self._GroupIdList = GroupIdList

    @property
    def StatusList(self):
        return self._StatusList

    @StatusList.setter
    def StatusList(self, StatusList):
        self._StatusList = StatusList


    def _deserialize(self, params):
        self._SdkAppId = params.get("SdkAppId")
        self._StaffList = params.get("StaffList")
        self._GroupIdList = params.get("GroupIdList")
        self._StatusList = params.get("StatusList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeStaffStatusMetricsResponse(AbstractModel):
    """DescribeStaffStatusMetrics response structure.

    """

    def __init__(self):
        r"""
        :param _Metrics: Real-time information on agent status.
        :type Metrics: list of StaffStatusMetrics
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Metrics = None
        self._RequestId = None

    @property
    def Metrics(self):
        return self._Metrics

    @Metrics.setter
    def Metrics(self, Metrics):
        self._Metrics = Metrics

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Metrics") is not None:
            self._Metrics = []
            for item in params.get("Metrics"):
                obj = StaffStatusMetrics()
                obj._deserialize(item)
                self._Metrics.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTelCallInfoRequest(AbstractModel):
    """DescribeTelCallInfo request structure.

    """

    def __init__(self):
        r"""
        :param _StartTimeStamp: Start timestamp, Unix timestamp (query dimension supports only daily. For example, to query May 1st, pass startTime:"2023-05-01 00:00:00","endTime":"2023-05-01 23:59:59" timestamp. To query May 1st and May 2nd, pass startTime:"2023-05-01 00:00:00","endTime":"2023-05-02 23:59:59" timestamp)
        :type StartTimeStamp: int
        :param _EndTimeStamp: End timestamp, Unix timestamp, the query time range is up to 90 days (query dimension supports only daily. For example, to query May 1st, pass startTime:"2023-05-01 00:00:00","endTime":"2023-05-01 23:59:59" timestamp. To query May 1st and May 2nd, pass startTime:"2023-05-01 00:00:00","endTime":"2023-05-02 23:59:59" timestamp)
        :type EndTimeStamp: int
        :param _SdkAppIdList: Application ID list, when having multiple IDs, the returned value is the sum of all the IDs.
        :type SdkAppIdList: list of int
        """
        self._StartTimeStamp = None
        self._EndTimeStamp = None
        self._SdkAppIdList = None

    @property
    def StartTimeStamp(self):
        return self._StartTimeStamp

    @StartTimeStamp.setter
    def StartTimeStamp(self, StartTimeStamp):
        self._StartTimeStamp = StartTimeStamp

    @property
    def EndTimeStamp(self):
        return self._EndTimeStamp

    @EndTimeStamp.setter
    def EndTimeStamp(self, EndTimeStamp):
        self._EndTimeStamp = EndTimeStamp

    @property
    def SdkAppIdList(self):
        return self._SdkAppIdList

    @SdkAppIdList.setter
    def SdkAppIdList(self, SdkAppIdList):
        self._SdkAppIdList = SdkAppIdList


    def _deserialize(self, params):
        self._StartTimeStamp = params.get("StartTimeStamp")
        self._EndTimeStamp = params.get("EndTimeStamp")
        self._SdkAppIdList = params.get("SdkAppIdList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTelCallInfoResponse(AbstractModel):
    """DescribeTelCallInfo response structure.

    """

    def __init__(self):
        r"""
        :param _TelCallOutCount: Number of minutes consumed by Outbound Package.
        :type TelCallOutCount: int
        :param _TelCallInCount: Number of minutes consumed by Inbound Package.
        :type TelCallInCount: int
        :param _SeatUsedCount: Number of agent usage statistics.
        :type SeatUsedCount: int
        :param _VoipCallInCount: Number of minutes consumed by Audio package.
        :type VoipCallInCount: int
        :param _VOIPCallInCount: Number of minutes consumed by Audio package.
        :type VOIPCallInCount: int
        :param _AsrOfflineCount: Number of minutes consumed by Offline Speech-to-Text Package.
        :type AsrOfflineCount: int
        :param _AsrRealtimeCount: Number of minutes consumed by Real-time Speech-to-Text Package.
        :type AsrRealtimeCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TelCallOutCount = None
        self._TelCallInCount = None
        self._SeatUsedCount = None
        self._VoipCallInCount = None
        self._VOIPCallInCount = None
        self._AsrOfflineCount = None
        self._AsrRealtimeCount = None
        self._RequestId = None

    @property
    def TelCallOutCount(self):
        return self._TelCallOutCount

    @TelCallOutCount.setter
    def TelCallOutCount(self, TelCallOutCount):
        self._TelCallOutCount = TelCallOutCount

    @property
    def TelCallInCount(self):
        return self._TelCallInCount

    @TelCallInCount.setter
    def TelCallInCount(self, TelCallInCount):
        self._TelCallInCount = TelCallInCount

    @property
    def SeatUsedCount(self):
        return self._SeatUsedCount

    @SeatUsedCount.setter
    def SeatUsedCount(self, SeatUsedCount):
        self._SeatUsedCount = SeatUsedCount

    @property
    def VoipCallInCount(self):
        warnings.warn("parameter `VoipCallInCount` is deprecated", DeprecationWarning) 

        return self._VoipCallInCount

    @VoipCallInCount.setter
    def VoipCallInCount(self, VoipCallInCount):
        warnings.warn("parameter `VoipCallInCount` is deprecated", DeprecationWarning) 

        self._VoipCallInCount = VoipCallInCount

    @property
    def VOIPCallInCount(self):
        return self._VOIPCallInCount

    @VOIPCallInCount.setter
    def VOIPCallInCount(self, VOIPCallInCount):
        self._VOIPCallInCount = VOIPCallInCount

    @property
    def AsrOfflineCount(self):
        return self._AsrOfflineCount

    @AsrOfflineCount.setter
    def AsrOfflineCount(self, AsrOfflineCount):
        self._AsrOfflineCount = AsrOfflineCount

    @property
    def AsrRealtimeCount(self):
        return self._AsrRealtimeCount

    @AsrRealtimeCount.setter
    def AsrRealtimeCount(self, AsrRealtimeCount):
        self._AsrRealtimeCount = AsrRealtimeCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TelCallOutCount = params.get("TelCallOutCount")
        self._TelCallInCount = params.get("TelCallInCount")
        self._SeatUsedCount = params.get("SeatUsedCount")
        self._VoipCallInCount = params.get("VoipCallInCount")
        self._VOIPCallInCount = params.get("VOIPCallInCount")
        self._AsrOfflineCount = params.get("AsrOfflineCount")
        self._AsrRealtimeCount = params.get("AsrRealtimeCount")
        self._RequestId = params.get("RequestId")


class DescribeTelCdrRequest(AbstractModel):
    """DescribeTelCdr request structure.

    """

    def __init__(self):
        r"""
        :param _StartTimeStamp: Start timestamp, Unix Timestamp in Seconds. Supports up to the past 180 days.
        :type StartTimeStamp: int
        :param _EndTimeStamp: End timestamp, Unix Timestamp in Seconds. The range between the end time and start time is less than 90 days.
        :type EndTimeStamp: int
        :param _InstanceId: Instance ID (deprecated).
        :type InstanceId: int
        :param _Limit: Maximum number of returned entries (deprecated).
        :type Limit: int
        :param _Offset: Offset (deprecated).
        :type Offset: int
        :param _SdkAppId: Application ID (required) can be found at https://console.cloud.tencent.com/ccc.
        :type SdkAppId: int
        :param _PageSize: Page size (required), up to 100.
        :type PageSize: int
        :param _PageNumber: Page number (required), starting from 0.
        :type PageNumber: int
        :param _Phones: Filter by Phone Number.
        :type Phones: list of str
        :param _SessionIds: Filter by SessionId.
        :type SessionIds: list of str
        """
        self._StartTimeStamp = None
        self._EndTimeStamp = None
        self._InstanceId = None
        self._Limit = None
        self._Offset = None
        self._SdkAppId = None
        self._PageSize = None
        self._PageNumber = None
        self._Phones = None
        self._SessionIds = None

    @property
    def StartTimeStamp(self):
        return self._StartTimeStamp

    @StartTimeStamp.setter
    def StartTimeStamp(self, StartTimeStamp):
        self._StartTimeStamp = StartTimeStamp

    @property
    def EndTimeStamp(self):
        return self._EndTimeStamp

    @EndTimeStamp.setter
    def EndTimeStamp(self, EndTimeStamp):
        self._EndTimeStamp = EndTimeStamp

    @property
    def InstanceId(self):
        warnings.warn("parameter `InstanceId` is deprecated", DeprecationWarning) 

        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        warnings.warn("parameter `InstanceId` is deprecated", DeprecationWarning) 

        self._InstanceId = InstanceId

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def Phones(self):
        return self._Phones

    @Phones.setter
    def Phones(self, Phones):
        self._Phones = Phones

    @property
    def SessionIds(self):
        return self._SessionIds

    @SessionIds.setter
    def SessionIds(self, SessionIds):
        self._SessionIds = SessionIds


    def _deserialize(self, params):
        self._StartTimeStamp = params.get("StartTimeStamp")
        self._EndTimeStamp = params.get("EndTimeStamp")
        self._InstanceId = params.get("InstanceId")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._SdkAppId = params.get("SdkAppId")
        self._PageSize = params.get("PageSize")
        self._PageNumber = params.get("PageNumber")
        self._Phones = params.get("Phones")
        self._SessionIds = params.get("SessionIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTelCdrResponse(AbstractModel):
    """DescribeTelCdr response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of call records.
        :type TotalCount: int
        :param _TelCdrs: Call record.
        :type TelCdrs: list of TelCdrInfo
        :param _TelCdrList: Call record.
        :type TelCdrList: list of TelCdrInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._TelCdrs = None
        self._TelCdrList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TelCdrs(self):
        warnings.warn("parameter `TelCdrs` is deprecated", DeprecationWarning) 

        return self._TelCdrs

    @TelCdrs.setter
    def TelCdrs(self, TelCdrs):
        warnings.warn("parameter `TelCdrs` is deprecated", DeprecationWarning) 

        self._TelCdrs = TelCdrs

    @property
    def TelCdrList(self):
        return self._TelCdrList

    @TelCdrList.setter
    def TelCdrList(self, TelCdrList):
        self._TelCdrList = TelCdrList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("TelCdrs") is not None:
            self._TelCdrs = []
            for item in params.get("TelCdrs"):
                obj = TelCdrInfo()
                obj._deserialize(item)
                self._TelCdrs.append(obj)
        if params.get("TelCdrList") is not None:
            self._TelCdrList = []
            for item in params.get("TelCdrList"):
                obj = TelCdrInfo()
                obj._deserialize(item)
                self._TelCdrList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTelSessionRequest(AbstractModel):
    """DescribeTelSession request structure.

    """

    def __init__(self):
        r"""
        :param _SdkAppId: Application ID (required) can be found at https://console.cloud.tencent.com/ccc.
        :type SdkAppId: int
        :param _SessionId: Session ID.
        :type SessionId: str
        """
        self._SdkAppId = None
        self._SessionId = None

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def SessionId(self):
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId


    def _deserialize(self, params):
        self._SdkAppId = params.get("SdkAppId")
        self._SessionId = params.get("SessionId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTelSessionResponse(AbstractModel):
    """DescribeTelSession response structure.

    """

    def __init__(self):
        r"""
        :param _Session: Session information.
        :type Session: :class:`tencentcloud.ccc.v20200210.models.PSTNSession`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Session = None
        self._RequestId = None

    @property
    def Session(self):
        return self._Session

    @Session.setter
    def Session(self, Session):
        self._Session = Session

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Session") is not None:
            self._Session = PSTNSession()
            self._Session._deserialize(params.get("Session"))
        self._RequestId = params.get("RequestId")


class DisableCCCPhoneNumberRequest(AbstractModel):
    """DisableCCCPhoneNumber request structure.

    """

    def __init__(self):
        r"""
        :param _PhoneNumbers: Number list starting with 0086.
        :type PhoneNumbers: list of str
        :param _Disabled: Disable switch: 0 for enable, 1 for disable.
        :type Disabled: int
        :param _SdkAppId: TCCC instance application ID.
        :type SdkAppId: int
        """
        self._PhoneNumbers = None
        self._Disabled = None
        self._SdkAppId = None

    @property
    def PhoneNumbers(self):
        return self._PhoneNumbers

    @PhoneNumbers.setter
    def PhoneNumbers(self, PhoneNumbers):
        self._PhoneNumbers = PhoneNumbers

    @property
    def Disabled(self):
        return self._Disabled

    @Disabled.setter
    def Disabled(self, Disabled):
        self._Disabled = Disabled

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId


    def _deserialize(self, params):
        self._PhoneNumbers = params.get("PhoneNumbers")
        self._Disabled = params.get("Disabled")
        self._SdkAppId = params.get("SdkAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisableCCCPhoneNumberResponse(AbstractModel):
    """DisableCCCPhoneNumber response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ErrStaffItem(AbstractModel):
    """When adding customer service personnel in batches, information of the customer service personnel with an error is returned.

    """

    def __init__(self):
        r"""
        :param _StaffEmail: Agent Email Address
        :type StaffEmail: str
        :param _Code: Error code.
        :type Code: str
        :param _Message: Error description.
        :type Message: str
        """
        self._StaffEmail = None
        self._Code = None
        self._Message = None

    @property
    def StaffEmail(self):
        return self._StaffEmail

    @StaffEmail.setter
    def StaffEmail(self, StaffEmail):
        self._StaffEmail = StaffEmail

    @property
    def Code(self):
        return self._Code

    @Code.setter
    def Code(self, Code):
        self._Code = Code

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message


    def _deserialize(self, params):
        self._StaffEmail = params.get("StaffEmail")
        self._Code = params.get("Code")
        self._Message = params.get("Message")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExtensionInfo(AbstractModel):
    """Telephone information.

    """

    def __init__(self):
        r"""
        :param _SdkAppId: Instance ID.
        :type SdkAppId: int
        :param _FullExtensionId: Extension full name.
        :type FullExtensionId: str
        :param _ExtensionId: Extension
        :type ExtensionId: str
        :param _SkillGroupId: Affiliated skill group list.
        :type SkillGroupId: str
        :param _ExtensionName: Extension name.
        :type ExtensionName: str
        :param _CreateTime: Creation Time
        :type CreateTime: int
        :param _ModifyTime: Last modification time.
        :type ModifyTime: int
        :param _Status: Telephone status (0 Offline, 100 Free, 200 Busy).
        :type Status: int
        :param _Register: Whether to register.
        :type Register: bool
        :param _Relation: Bind Agent Email
        :type Relation: str
        :param _RelationName: Bind Agent Name
        :type RelationName: str
        """
        self._SdkAppId = None
        self._FullExtensionId = None
        self._ExtensionId = None
        self._SkillGroupId = None
        self._ExtensionName = None
        self._CreateTime = None
        self._ModifyTime = None
        self._Status = None
        self._Register = None
        self._Relation = None
        self._RelationName = None

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def FullExtensionId(self):
        return self._FullExtensionId

    @FullExtensionId.setter
    def FullExtensionId(self, FullExtensionId):
        self._FullExtensionId = FullExtensionId

    @property
    def ExtensionId(self):
        return self._ExtensionId

    @ExtensionId.setter
    def ExtensionId(self, ExtensionId):
        self._ExtensionId = ExtensionId

    @property
    def SkillGroupId(self):
        return self._SkillGroupId

    @SkillGroupId.setter
    def SkillGroupId(self, SkillGroupId):
        self._SkillGroupId = SkillGroupId

    @property
    def ExtensionName(self):
        return self._ExtensionName

    @ExtensionName.setter
    def ExtensionName(self, ExtensionName):
        self._ExtensionName = ExtensionName

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ModifyTime(self):
        return self._ModifyTime

    @ModifyTime.setter
    def ModifyTime(self, ModifyTime):
        self._ModifyTime = ModifyTime

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Register(self):
        return self._Register

    @Register.setter
    def Register(self, Register):
        self._Register = Register

    @property
    def Relation(self):
        return self._Relation

    @Relation.setter
    def Relation(self, Relation):
        self._Relation = Relation

    @property
    def RelationName(self):
        return self._RelationName

    @RelationName.setter
    def RelationName(self, RelationName):
        self._RelationName = RelationName


    def _deserialize(self, params):
        self._SdkAppId = params.get("SdkAppId")
        self._FullExtensionId = params.get("FullExtensionId")
        self._ExtensionId = params.get("ExtensionId")
        self._SkillGroupId = params.get("SkillGroupId")
        self._ExtensionName = params.get("ExtensionName")
        self._CreateTime = params.get("CreateTime")
        self._ModifyTime = params.get("ModifyTime")
        self._Status = params.get("Status")
        self._Register = params.get("Register")
        self._Relation = params.get("Relation")
        self._RelationName = params.get("RelationName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class HangUpCallRequest(AbstractModel):
    """HangUpCall request structure.

    """

    def __init__(self):
        r"""
        :param _SdkAppId: TCCC instance application ID.
        :type SdkAppId: int
        :param _SessionId: Session ID.
        :type SessionId: str
        """
        self._SdkAppId = None
        self._SessionId = None

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def SessionId(self):
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId


    def _deserialize(self, params):
        self._SdkAppId = params.get("SdkAppId")
        self._SessionId = params.get("SessionId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class HangUpCallResponse(AbstractModel):
    """HangUpCall response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class IVRKeyPressedElement(AbstractModel):
    """IVR Key Information.

    """

    def __init__(self):
        r"""
        :param _Key: Key.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Key: str
        :param _Label: Tag associated with key.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Label: str
        """
        self._Key = None
        self._Label = None

    @property
    def Key(self):
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key

    @property
    def Label(self):
        return self._Label

    @Label.setter
    def Label(self, Label):
        self._Label = Label


    def _deserialize(self, params):
        self._Key = params.get("Key")
        self._Label = params.get("Label")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyExtensionRequest(AbstractModel):
    """ModifyExtension request structure.

    """

    def __init__(self):
        r"""
        :param _SdkAppId: TCCC instance application ID.
        :type SdkAppId: int
        :param _ExtensionId: Extension
        :type ExtensionId: str
        :param _ExtensionName: Extension name.
        :type ExtensionName: str
        :param _SkillGroupIds: Affiliated skill group list.
        :type SkillGroupIds: list of int
        :param _Relation: Bind agent email account.
        :type Relation: str
        """
        self._SdkAppId = None
        self._ExtensionId = None
        self._ExtensionName = None
        self._SkillGroupIds = None
        self._Relation = None

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def ExtensionId(self):
        return self._ExtensionId

    @ExtensionId.setter
    def ExtensionId(self, ExtensionId):
        self._ExtensionId = ExtensionId

    @property
    def ExtensionName(self):
        return self._ExtensionName

    @ExtensionName.setter
    def ExtensionName(self, ExtensionName):
        self._ExtensionName = ExtensionName

    @property
    def SkillGroupIds(self):
        return self._SkillGroupIds

    @SkillGroupIds.setter
    def SkillGroupIds(self, SkillGroupIds):
        self._SkillGroupIds = SkillGroupIds

    @property
    def Relation(self):
        return self._Relation

    @Relation.setter
    def Relation(self, Relation):
        self._Relation = Relation


    def _deserialize(self, params):
        self._SdkAppId = params.get("SdkAppId")
        self._ExtensionId = params.get("ExtensionId")
        self._ExtensionName = params.get("ExtensionName")
        self._SkillGroupIds = params.get("SkillGroupIds")
        self._Relation = params.get("Relation")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyExtensionResponse(AbstractModel):
    """ModifyExtension response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyStaffPasswordRequest(AbstractModel):
    """ModifyStaffPassword request structure.

    """

    def __init__(self):
        r"""
        :param _SdkAppId: Application ID (required) can be found at https://console.cloud.tencent.com/ccc.
        :type SdkAppId: int
        :param _Email: Agent email.
        :type Email: str
        :param _Password: The set password 
        :type Password: str
        """
        self._SdkAppId = None
        self._Email = None
        self._Password = None

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def Email(self):
        return self._Email

    @Email.setter
    def Email(self, Email):
        self._Email = Email

    @property
    def Password(self):
        return self._Password

    @Password.setter
    def Password(self, Password):
        self._Password = Password


    def _deserialize(self, params):
        self._SdkAppId = params.get("SdkAppId")
        self._Email = params.get("Email")
        self._Password = params.get("Password")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyStaffPasswordResponse(AbstractModel):
    """ModifyStaffPassword response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyStaffRequest(AbstractModel):
    """ModifyStaff request structure.

    """

    def __init__(self):
        r"""
        :param _SdkAppId: Application ID
        :type SdkAppId: int
        :param _Email: Agent account.
        :type Email: str
        :param _Name: Agent name.
        :type Name: str
        :param _Phone: Agent phone number (preceded by 0086, example: 008618011111111).
        :type Phone: str
        :param _Nick: Agent nickname.
        :type Nick: str
        :param _StaffNo: Agent ID
        :type StaffNo: str
        :param _SkillGroupIds: Bind skill group ID list.
        :type SkillGroupIds: list of int
        :param _UseMobileCallOut: Whether the cell phone outbound call switch is enabled or not.
        :type UseMobileCallOut: bool
        :param _UseMobileAccept: Cell phone answering pattern: 0 - Off | 1 - Only when Offline | 2 - Always.
        :type UseMobileAccept: int
        """
        self._SdkAppId = None
        self._Email = None
        self._Name = None
        self._Phone = None
        self._Nick = None
        self._StaffNo = None
        self._SkillGroupIds = None
        self._UseMobileCallOut = None
        self._UseMobileAccept = None

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def Email(self):
        return self._Email

    @Email.setter
    def Email(self, Email):
        self._Email = Email

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Phone(self):
        return self._Phone

    @Phone.setter
    def Phone(self, Phone):
        self._Phone = Phone

    @property
    def Nick(self):
        return self._Nick

    @Nick.setter
    def Nick(self, Nick):
        self._Nick = Nick

    @property
    def StaffNo(self):
        return self._StaffNo

    @StaffNo.setter
    def StaffNo(self, StaffNo):
        self._StaffNo = StaffNo

    @property
    def SkillGroupIds(self):
        return self._SkillGroupIds

    @SkillGroupIds.setter
    def SkillGroupIds(self, SkillGroupIds):
        self._SkillGroupIds = SkillGroupIds

    @property
    def UseMobileCallOut(self):
        return self._UseMobileCallOut

    @UseMobileCallOut.setter
    def UseMobileCallOut(self, UseMobileCallOut):
        self._UseMobileCallOut = UseMobileCallOut

    @property
    def UseMobileAccept(self):
        return self._UseMobileAccept

    @UseMobileAccept.setter
    def UseMobileAccept(self, UseMobileAccept):
        self._UseMobileAccept = UseMobileAccept


    def _deserialize(self, params):
        self._SdkAppId = params.get("SdkAppId")
        self._Email = params.get("Email")
        self._Name = params.get("Name")
        self._Phone = params.get("Phone")
        self._Nick = params.get("Nick")
        self._StaffNo = params.get("StaffNo")
        self._SkillGroupIds = params.get("SkillGroupIds")
        self._UseMobileCallOut = params.get("UseMobileCallOut")
        self._UseMobileAccept = params.get("UseMobileAccept")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyStaffResponse(AbstractModel):
    """ModifyStaff response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class NumberInfo(AbstractModel):
    """Number information.

    """

    def __init__(self):
        r"""
        :param _Number: Number.
        :type Number: str
        :param _CallOutSkillGroupIds: Bound outbound call skill group.
        :type CallOutSkillGroupIds: list of int non-negative
        :param _State: Number status, 1-normal, 2-disabled due to overdue payment, 4-disabled by the administrator, 5-disabled due to violation.
        :type State: int
        """
        self._Number = None
        self._CallOutSkillGroupIds = None
        self._State = None

    @property
    def Number(self):
        return self._Number

    @Number.setter
    def Number(self, Number):
        self._Number = Number

    @property
    def CallOutSkillGroupIds(self):
        return self._CallOutSkillGroupIds

    @CallOutSkillGroupIds.setter
    def CallOutSkillGroupIds(self, CallOutSkillGroupIds):
        self._CallOutSkillGroupIds = CallOutSkillGroupIds

    @property
    def State(self):
        return self._State

    @State.setter
    def State(self, State):
        self._State = State


    def _deserialize(self, params):
        self._Number = params.get("Number")
        self._CallOutSkillGroupIds = params.get("CallOutSkillGroupIds")
        self._State = params.get("State")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PSTNSession(AbstractModel):
    """PSTN session type.

    """

    def __init__(self):
        r"""
        :param _SessionID: Session ID.
        :type SessionID: str
        :param _RoomID: Temporary room ID for session.
        :type RoomID: str
        :param _Caller: Caller.
        :type Caller: str
        :param _Callee: Called.
        :type Callee: str
        :param _StartTimestamp: Start time. Unix timestamp.
        :type StartTimestamp: int
        :param _RingTimestamp: Ring time. Unix timestamp.
        :type RingTimestamp: int
        :param _AcceptTimestamp: Answer time. Unix timestamp.
        :type AcceptTimestamp: int
        :param _StaffEmail: Agent email.
        :type StaffEmail: str
        :param _StaffNumber: Agent ID
        :type StaffNumber: str
        :param _SessionStatus: Session Status
ringing Ringing
seatJoining  waiting for the agent to answer
inProgress  Ongoing
finished - Completed.
        :type SessionStatus: str
        :param _Direction: Session call direction, 0 - Inbound | 1 - Outbound.
        :type Direction: int
        :param _OutBoundCaller: The number used for transferring to the external line (Outbound Caller).
        :type OutBoundCaller: str
        :param _OutBoundCallee: Outbound callee.
        :type OutBoundCallee: str
        :param _ProtectedCaller: Caller number protection ID. Effective when the number protection map feature is activated, and the Caller field is empty.
        :type ProtectedCaller: str
        :param _ProtectedCallee: Called number protection ID. Effective when the number protection map feature is activated, and the Callee field is empty.
        :type ProtectedCallee: str
        """
        self._SessionID = None
        self._RoomID = None
        self._Caller = None
        self._Callee = None
        self._StartTimestamp = None
        self._RingTimestamp = None
        self._AcceptTimestamp = None
        self._StaffEmail = None
        self._StaffNumber = None
        self._SessionStatus = None
        self._Direction = None
        self._OutBoundCaller = None
        self._OutBoundCallee = None
        self._ProtectedCaller = None
        self._ProtectedCallee = None

    @property
    def SessionID(self):
        return self._SessionID

    @SessionID.setter
    def SessionID(self, SessionID):
        self._SessionID = SessionID

    @property
    def RoomID(self):
        return self._RoomID

    @RoomID.setter
    def RoomID(self, RoomID):
        self._RoomID = RoomID

    @property
    def Caller(self):
        return self._Caller

    @Caller.setter
    def Caller(self, Caller):
        self._Caller = Caller

    @property
    def Callee(self):
        return self._Callee

    @Callee.setter
    def Callee(self, Callee):
        self._Callee = Callee

    @property
    def StartTimestamp(self):
        return self._StartTimestamp

    @StartTimestamp.setter
    def StartTimestamp(self, StartTimestamp):
        self._StartTimestamp = StartTimestamp

    @property
    def RingTimestamp(self):
        return self._RingTimestamp

    @RingTimestamp.setter
    def RingTimestamp(self, RingTimestamp):
        self._RingTimestamp = RingTimestamp

    @property
    def AcceptTimestamp(self):
        return self._AcceptTimestamp

    @AcceptTimestamp.setter
    def AcceptTimestamp(self, AcceptTimestamp):
        self._AcceptTimestamp = AcceptTimestamp

    @property
    def StaffEmail(self):
        return self._StaffEmail

    @StaffEmail.setter
    def StaffEmail(self, StaffEmail):
        self._StaffEmail = StaffEmail

    @property
    def StaffNumber(self):
        return self._StaffNumber

    @StaffNumber.setter
    def StaffNumber(self, StaffNumber):
        self._StaffNumber = StaffNumber

    @property
    def SessionStatus(self):
        return self._SessionStatus

    @SessionStatus.setter
    def SessionStatus(self, SessionStatus):
        self._SessionStatus = SessionStatus

    @property
    def Direction(self):
        return self._Direction

    @Direction.setter
    def Direction(self, Direction):
        self._Direction = Direction

    @property
    def OutBoundCaller(self):
        return self._OutBoundCaller

    @OutBoundCaller.setter
    def OutBoundCaller(self, OutBoundCaller):
        self._OutBoundCaller = OutBoundCaller

    @property
    def OutBoundCallee(self):
        return self._OutBoundCallee

    @OutBoundCallee.setter
    def OutBoundCallee(self, OutBoundCallee):
        self._OutBoundCallee = OutBoundCallee

    @property
    def ProtectedCaller(self):
        return self._ProtectedCaller

    @ProtectedCaller.setter
    def ProtectedCaller(self, ProtectedCaller):
        self._ProtectedCaller = ProtectedCaller

    @property
    def ProtectedCallee(self):
        return self._ProtectedCallee

    @ProtectedCallee.setter
    def ProtectedCallee(self, ProtectedCallee):
        self._ProtectedCallee = ProtectedCallee


    def _deserialize(self, params):
        self._SessionID = params.get("SessionID")
        self._RoomID = params.get("RoomID")
        self._Caller = params.get("Caller")
        self._Callee = params.get("Callee")
        self._StartTimestamp = params.get("StartTimestamp")
        self._RingTimestamp = params.get("RingTimestamp")
        self._AcceptTimestamp = params.get("AcceptTimestamp")
        self._StaffEmail = params.get("StaffEmail")
        self._StaffNumber = params.get("StaffNumber")
        self._SessionStatus = params.get("SessionStatus")
        self._Direction = params.get("Direction")
        self._OutBoundCaller = params.get("OutBoundCaller")
        self._OutBoundCallee = params.get("OutBoundCallee")
        self._ProtectedCaller = params.get("ProtectedCaller")
        self._ProtectedCallee = params.get("ProtectedCallee")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PSTNSessionInfo(AbstractModel):
    """PSTN Session Information.

    """

    def __init__(self):
        r"""
        :param _SessionID: Session ID.
        :type SessionID: str
        :param _RoomID: Temporary room ID for session.
        :type RoomID: str
        :param _Caller: Caller.
        :type Caller: str
        :param _Callee: Called.
        :type Callee: str
        :param _StartTimestamp: Start time. Unix timestamp.
        :type StartTimestamp: str
        :param _AcceptTimestamp: Answer time. Unix timestamp.
        :type AcceptTimestamp: str
        :param _StaffEmail: Agent email.
        :type StaffEmail: str
        :param _StaffNumber: Agent ID
        :type StaffNumber: str
        :param _SessionStatus: Agent Status inProgress Ongoing
        :type SessionStatus: str
        :param _Direction: Session call direction, 0 - Inbound | 1 - Outbound.
        :type Direction: int
        :param _RingTimestamp: Ring time. Unix timestamp.
        :type RingTimestamp: int
        :param _ProtectedCaller: Caller number protection ID. Effective when the number protection map feature is activated, and the Caller field is empty.
        :type ProtectedCaller: str
        :param _ProtectedCallee: Called number protection ID. Effective when the number protection map feature is activated, and the Callee field is empty.
        :type ProtectedCallee: str
        """
        self._SessionID = None
        self._RoomID = None
        self._Caller = None
        self._Callee = None
        self._StartTimestamp = None
        self._AcceptTimestamp = None
        self._StaffEmail = None
        self._StaffNumber = None
        self._SessionStatus = None
        self._Direction = None
        self._RingTimestamp = None
        self._ProtectedCaller = None
        self._ProtectedCallee = None

    @property
    def SessionID(self):
        return self._SessionID

    @SessionID.setter
    def SessionID(self, SessionID):
        self._SessionID = SessionID

    @property
    def RoomID(self):
        return self._RoomID

    @RoomID.setter
    def RoomID(self, RoomID):
        self._RoomID = RoomID

    @property
    def Caller(self):
        return self._Caller

    @Caller.setter
    def Caller(self, Caller):
        self._Caller = Caller

    @property
    def Callee(self):
        return self._Callee

    @Callee.setter
    def Callee(self, Callee):
        self._Callee = Callee

    @property
    def StartTimestamp(self):
        return self._StartTimestamp

    @StartTimestamp.setter
    def StartTimestamp(self, StartTimestamp):
        self._StartTimestamp = StartTimestamp

    @property
    def AcceptTimestamp(self):
        return self._AcceptTimestamp

    @AcceptTimestamp.setter
    def AcceptTimestamp(self, AcceptTimestamp):
        self._AcceptTimestamp = AcceptTimestamp

    @property
    def StaffEmail(self):
        return self._StaffEmail

    @StaffEmail.setter
    def StaffEmail(self, StaffEmail):
        self._StaffEmail = StaffEmail

    @property
    def StaffNumber(self):
        return self._StaffNumber

    @StaffNumber.setter
    def StaffNumber(self, StaffNumber):
        self._StaffNumber = StaffNumber

    @property
    def SessionStatus(self):
        return self._SessionStatus

    @SessionStatus.setter
    def SessionStatus(self, SessionStatus):
        self._SessionStatus = SessionStatus

    @property
    def Direction(self):
        return self._Direction

    @Direction.setter
    def Direction(self, Direction):
        self._Direction = Direction

    @property
    def RingTimestamp(self):
        return self._RingTimestamp

    @RingTimestamp.setter
    def RingTimestamp(self, RingTimestamp):
        self._RingTimestamp = RingTimestamp

    @property
    def ProtectedCaller(self):
        return self._ProtectedCaller

    @ProtectedCaller.setter
    def ProtectedCaller(self, ProtectedCaller):
        self._ProtectedCaller = ProtectedCaller

    @property
    def ProtectedCallee(self):
        return self._ProtectedCallee

    @ProtectedCallee.setter
    def ProtectedCallee(self, ProtectedCallee):
        self._ProtectedCallee = ProtectedCallee


    def _deserialize(self, params):
        self._SessionID = params.get("SessionID")
        self._RoomID = params.get("RoomID")
        self._Caller = params.get("Caller")
        self._Callee = params.get("Callee")
        self._StartTimestamp = params.get("StartTimestamp")
        self._AcceptTimestamp = params.get("AcceptTimestamp")
        self._StaffEmail = params.get("StaffEmail")
        self._StaffNumber = params.get("StaffNumber")
        self._SessionStatus = params.get("SessionStatus")
        self._Direction = params.get("Direction")
        self._RingTimestamp = params.get("RingTimestamp")
        self._ProtectedCaller = params.get("ProtectedCaller")
        self._ProtectedCallee = params.get("ProtectedCallee")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PackageBuyInfo(AbstractModel):
    """Package purchase information.

    """

    def __init__(self):
        r"""
        :param _PackageId: Package ID.
        :type PackageId: str
        :param _Type: Package type, 0 - Outbound call package | 1 - 400 inbound call package.
        :type Type: int
        :param _CapacitySize: Total package.
        :type CapacitySize: int
        :param _CapacityRemain: Remaining package.
        :type CapacityRemain: int
        :param _BuyTime: Purchased timestamp.
        :type BuyTime: int
        :param _EndTime: End timestamp.
        :type EndTime: int
        """
        self._PackageId = None
        self._Type = None
        self._CapacitySize = None
        self._CapacityRemain = None
        self._BuyTime = None
        self._EndTime = None

    @property
    def PackageId(self):
        return self._PackageId

    @PackageId.setter
    def PackageId(self, PackageId):
        self._PackageId = PackageId

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def CapacitySize(self):
        return self._CapacitySize

    @CapacitySize.setter
    def CapacitySize(self, CapacitySize):
        self._CapacitySize = CapacitySize

    @property
    def CapacityRemain(self):
        return self._CapacityRemain

    @CapacityRemain.setter
    def CapacityRemain(self, CapacityRemain):
        self._CapacityRemain = CapacityRemain

    @property
    def BuyTime(self):
        return self._BuyTime

    @BuyTime.setter
    def BuyTime(self, BuyTime):
        self._BuyTime = BuyTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._PackageId = params.get("PackageId")
        self._Type = params.get("Type")
        self._CapacitySize = params.get("CapacitySize")
        self._CapacityRemain = params.get("CapacityRemain")
        self._BuyTime = params.get("BuyTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PausePredictiveDialingCampaignRequest(AbstractModel):
    """PausePredictiveDialingCampaign request structure.

    """

    def __init__(self):
        r"""
        :param _SdkAppId: Application ID (required) can be found at https://console.cloud.tencent.com/ccc.
        :type SdkAppId: int
        :param _CampaignId: Task ID.
        :type CampaignId: int
        """
        self._SdkAppId = None
        self._CampaignId = None

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def CampaignId(self):
        return self._CampaignId

    @CampaignId.setter
    def CampaignId(self, CampaignId):
        self._CampaignId = CampaignId


    def _deserialize(self, params):
        self._SdkAppId = params.get("SdkAppId")
        self._CampaignId = params.get("CampaignId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PausePredictiveDialingCampaignResponse(AbstractModel):
    """PausePredictiveDialingCampaign response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class PhoneNumBuyInfo(AbstractModel):
    """Number purchase information.

    """

    def __init__(self):
        r"""
        :param _PhoneNum: Telephone Number
        :type PhoneNum: str
        :param _Type: Number type, 0 - Landline | 1 - Virtual Business Number | 2 - ISP Number | 3 - 400 Number.
        :type Type: int
        :param _CallType: Call type of the number, 1 - Inbound | 2 - Outbound | 3 - Inbound and outbound.
        :type CallType: int
        :param _BuyTime: Purchased timestamp.
        :type BuyTime: int
        :param _EndTime: End timestamp.
        :type EndTime: int
        :param _State: Number status, 1-Normal | 2-Suspended due to non-payment | 4-Admin suspended | 5-Suspended due to violation.
        :type State: int
        """
        self._PhoneNum = None
        self._Type = None
        self._CallType = None
        self._BuyTime = None
        self._EndTime = None
        self._State = None

    @property
    def PhoneNum(self):
        return self._PhoneNum

    @PhoneNum.setter
    def PhoneNum(self, PhoneNum):
        self._PhoneNum = PhoneNum

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def CallType(self):
        return self._CallType

    @CallType.setter
    def CallType(self, CallType):
        self._CallType = CallType

    @property
    def BuyTime(self):
        return self._BuyTime

    @BuyTime.setter
    def BuyTime(self, BuyTime):
        self._BuyTime = BuyTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def State(self):
        return self._State

    @State.setter
    def State(self, State):
        self._State = State


    def _deserialize(self, params):
        self._PhoneNum = params.get("PhoneNum")
        self._Type = params.get("Type")
        self._CallType = params.get("CallType")
        self._BuyTime = params.get("BuyTime")
        self._EndTime = params.get("EndTime")
        self._State = params.get("State")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ResetExtensionPasswordRequest(AbstractModel):
    """ResetExtensionPassword request structure.

    """

    def __init__(self):
        r"""
        :param _SdkAppId: TCCC instance application ID.
        :type SdkAppId: int
        :param _ExtensionId: Extension
        :type ExtensionId: str
        """
        self._SdkAppId = None
        self._ExtensionId = None

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def ExtensionId(self):
        return self._ExtensionId

    @ExtensionId.setter
    def ExtensionId(self, ExtensionId):
        self._ExtensionId = ExtensionId


    def _deserialize(self, params):
        self._SdkAppId = params.get("SdkAppId")
        self._ExtensionId = params.get("ExtensionId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ResetExtensionPasswordResponse(AbstractModel):
    """ResetExtensionPassword response structure.

    """

    def __init__(self):
        r"""
        :param _Password: Reset password.
        :type Password: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Password = None
        self._RequestId = None

    @property
    def Password(self):
        return self._Password

    @Password.setter
    def Password(self, Password):
        self._Password = Password

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Password = params.get("Password")
        self._RequestId = params.get("RequestId")


class ResumePredictiveDialingCampaignRequest(AbstractModel):
    """ResumePredictiveDialingCampaign request structure.

    """

    def __init__(self):
        r"""
        :param _SdkAppId: Application ID (required) can be found at https://console.cloud.tencent.com/ccc.
        :type SdkAppId: int
        :param _CampaignId: Task ID.
        :type CampaignId: int
        """
        self._SdkAppId = None
        self._CampaignId = None

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def CampaignId(self):
        return self._CampaignId

    @CampaignId.setter
    def CampaignId(self, CampaignId):
        self._CampaignId = CampaignId


    def _deserialize(self, params):
        self._SdkAppId = params.get("SdkAppId")
        self._CampaignId = params.get("CampaignId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ResumePredictiveDialingCampaignResponse(AbstractModel):
    """ResumePredictiveDialingCampaign response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class SdkAppIdBuyInfo(AbstractModel):
    """Application purchase information.

    """

    def __init__(self):
        r"""
        :param _SdkAppId: Application ID
        :type SdkAppId: int
        :param _Name: Application Name
        :type Name: str
        :param _StaffBuyNum: Agent Purchase Count (still within the validity period)
        :type StaffBuyNum: int
        :param _StaffBuyList: Agent Purchase List (still within the validity period)
        :type StaffBuyList: list of StaffBuyInfo
        :param _PhoneNumBuyList: List of numbers purchased.
        :type PhoneNumBuyList: list of PhoneNumBuyInfo
        :param _SipBuyNum: Number of office telephones purchased (still within the validity period).
Note: this field may return null, indicating that no valid values can be obtained.
        :type SipBuyNum: int
        """
        self._SdkAppId = None
        self._Name = None
        self._StaffBuyNum = None
        self._StaffBuyList = None
        self._PhoneNumBuyList = None
        self._SipBuyNum = None

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def StaffBuyNum(self):
        return self._StaffBuyNum

    @StaffBuyNum.setter
    def StaffBuyNum(self, StaffBuyNum):
        self._StaffBuyNum = StaffBuyNum

    @property
    def StaffBuyList(self):
        return self._StaffBuyList

    @StaffBuyList.setter
    def StaffBuyList(self, StaffBuyList):
        self._StaffBuyList = StaffBuyList

    @property
    def PhoneNumBuyList(self):
        return self._PhoneNumBuyList

    @PhoneNumBuyList.setter
    def PhoneNumBuyList(self, PhoneNumBuyList):
        self._PhoneNumBuyList = PhoneNumBuyList

    @property
    def SipBuyNum(self):
        return self._SipBuyNum

    @SipBuyNum.setter
    def SipBuyNum(self, SipBuyNum):
        self._SipBuyNum = SipBuyNum


    def _deserialize(self, params):
        self._SdkAppId = params.get("SdkAppId")
        self._Name = params.get("Name")
        self._StaffBuyNum = params.get("StaffBuyNum")
        if params.get("StaffBuyList") is not None:
            self._StaffBuyList = []
            for item in params.get("StaffBuyList"):
                obj = StaffBuyInfo()
                obj._deserialize(item)
                self._StaffBuyList.append(obj)
        if params.get("PhoneNumBuyList") is not None:
            self._PhoneNumBuyList = []
            for item in params.get("PhoneNumBuyList"):
                obj = PhoneNumBuyInfo()
                obj._deserialize(item)
                self._PhoneNumBuyList.append(obj)
        self._SipBuyNum = params.get("SipBuyNum")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SeatUserInfo(AbstractModel):
    """Agent User Information

    """

    def __init__(self):
        r"""
        :param _Name: Agent name.
        :type Name: str
        :param _Mail: Agent email.
        :type Mail: str
        :param _StaffNumber: Worker number.
Note: This field may return null, indicating that no valid value could be obtained.
        :type StaffNumber: str
        :param _Phone: Agent's Telephone Number (With 0086 Prefix)
        :type Phone: str
        :param _Nick: Agent nickname.
        :type Nick: str
        :param _UserId: User ID
        :type UserId: str
        :param _SkillGroupNameList: List of skill groups associated with the seat
Note: This field may return null, indicating that no valid values can be obtained.
        :type SkillGroupNameList: list of str
        :param _Role: 1: Admin.
2: Quality inspector.
3: Ordinary agent.
else: Custom Role ID.
Note: This field may return null, indicating that no valid value could be obtained.
        :type Role: int
        """
        self._Name = None
        self._Mail = None
        self._StaffNumber = None
        self._Phone = None
        self._Nick = None
        self._UserId = None
        self._SkillGroupNameList = None
        self._Role = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Mail(self):
        return self._Mail

    @Mail.setter
    def Mail(self, Mail):
        self._Mail = Mail

    @property
    def StaffNumber(self):
        return self._StaffNumber

    @StaffNumber.setter
    def StaffNumber(self, StaffNumber):
        self._StaffNumber = StaffNumber

    @property
    def Phone(self):
        return self._Phone

    @Phone.setter
    def Phone(self, Phone):
        self._Phone = Phone

    @property
    def Nick(self):
        return self._Nick

    @Nick.setter
    def Nick(self, Nick):
        self._Nick = Nick

    @property
    def UserId(self):
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def SkillGroupNameList(self):
        return self._SkillGroupNameList

    @SkillGroupNameList.setter
    def SkillGroupNameList(self, SkillGroupNameList):
        self._SkillGroupNameList = SkillGroupNameList

    @property
    def Role(self):
        return self._Role

    @Role.setter
    def Role(self, Role):
        self._Role = Role


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Mail = params.get("Mail")
        self._StaffNumber = params.get("StaffNumber")
        self._Phone = params.get("Phone")
        self._Nick = params.get("Nick")
        self._UserId = params.get("UserId")
        self._SkillGroupNameList = params.get("SkillGroupNameList")
        self._Role = params.get("Role")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ServeParticipant(AbstractModel):
    """Participant information.

    """

    def __init__(self):
        r"""
        :param _Mail: Agent email.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Mail: str
        :param _Phone: Agent Telephone
Note: This field may return null, indicating that no valid values can be obtained.
        :type Phone: str
        :param _RingTimestamp: Ring timestamp. Unix second-level timestamp.
Note: This field may return null, indicating that no valid values can be obtained.
        :type RingTimestamp: int
        :param _AcceptTimestamp: Answer timestamp. Unix second-level timestamp.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AcceptTimestamp: int
        :param _EndedTimestamp: End timestamp. Unix second-level timestamp.
Note: This field may return null, indicating that no valid values can be obtained.
        :type EndedTimestamp: int
        :param _RecordId: Recording ID, which can be used to index the recording on the agent side
Note: This field may return null, indicating that no valid values can be obtained.
        :type RecordId: str
        :param _Type: Participant type: "staffSeat", "outboundSeat", "staffPhoneSeat".
Note: This field may return null, indicating that no valid values can be obtained.
        :type Type: str
        :param _TransferFrom: Transfer Source Agent Information
Note: This field may return null, indicating that no valid values can be obtained.
        :type TransferFrom: str
        :param _TransferFromType: Transfer source participant type is consistent with the Type value.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TransferFromType: str
        :param _TransferTo: Transfer Destination Agent Information
Note: This field may return null, indicating that no valid values can be obtained.
        :type TransferTo: str
        :param _TransferToType: Transfer destination participant type is consistent with Type values.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TransferToType: str
        :param _SkillGroupId: Skill group ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SkillGroupId: int
        :param _EndStatusString: Ending status.
Note: This field may return null, indicating that no valid values can be obtained.
        :type EndStatusString: str
        :param _RecordURL: Recording URL.
Note: This field may return null, indicating that no valid values can be obtained.
        :type RecordURL: str
        :param _Sequence: Participant sequence number, starting from 0.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Sequence: int
        :param _StartTimestamp: Start timestamp. Unix second-level timestamp.
Note: This field may return null, indicating that no valid values can be obtained.
        :type StartTimestamp: int
        :param _SkillGroupName: Skill Group name.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SkillGroupName: str
        :param _CustomRecordURL: Address of the third party COS for transferring recording.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CustomRecordURL: str
        """
        self._Mail = None
        self._Phone = None
        self._RingTimestamp = None
        self._AcceptTimestamp = None
        self._EndedTimestamp = None
        self._RecordId = None
        self._Type = None
        self._TransferFrom = None
        self._TransferFromType = None
        self._TransferTo = None
        self._TransferToType = None
        self._SkillGroupId = None
        self._EndStatusString = None
        self._RecordURL = None
        self._Sequence = None
        self._StartTimestamp = None
        self._SkillGroupName = None
        self._CustomRecordURL = None

    @property
    def Mail(self):
        return self._Mail

    @Mail.setter
    def Mail(self, Mail):
        self._Mail = Mail

    @property
    def Phone(self):
        return self._Phone

    @Phone.setter
    def Phone(self, Phone):
        self._Phone = Phone

    @property
    def RingTimestamp(self):
        return self._RingTimestamp

    @RingTimestamp.setter
    def RingTimestamp(self, RingTimestamp):
        self._RingTimestamp = RingTimestamp

    @property
    def AcceptTimestamp(self):
        return self._AcceptTimestamp

    @AcceptTimestamp.setter
    def AcceptTimestamp(self, AcceptTimestamp):
        self._AcceptTimestamp = AcceptTimestamp

    @property
    def EndedTimestamp(self):
        return self._EndedTimestamp

    @EndedTimestamp.setter
    def EndedTimestamp(self, EndedTimestamp):
        self._EndedTimestamp = EndedTimestamp

    @property
    def RecordId(self):
        return self._RecordId

    @RecordId.setter
    def RecordId(self, RecordId):
        self._RecordId = RecordId

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def TransferFrom(self):
        return self._TransferFrom

    @TransferFrom.setter
    def TransferFrom(self, TransferFrom):
        self._TransferFrom = TransferFrom

    @property
    def TransferFromType(self):
        return self._TransferFromType

    @TransferFromType.setter
    def TransferFromType(self, TransferFromType):
        self._TransferFromType = TransferFromType

    @property
    def TransferTo(self):
        return self._TransferTo

    @TransferTo.setter
    def TransferTo(self, TransferTo):
        self._TransferTo = TransferTo

    @property
    def TransferToType(self):
        return self._TransferToType

    @TransferToType.setter
    def TransferToType(self, TransferToType):
        self._TransferToType = TransferToType

    @property
    def SkillGroupId(self):
        return self._SkillGroupId

    @SkillGroupId.setter
    def SkillGroupId(self, SkillGroupId):
        self._SkillGroupId = SkillGroupId

    @property
    def EndStatusString(self):
        return self._EndStatusString

    @EndStatusString.setter
    def EndStatusString(self, EndStatusString):
        self._EndStatusString = EndStatusString

    @property
    def RecordURL(self):
        return self._RecordURL

    @RecordURL.setter
    def RecordURL(self, RecordURL):
        self._RecordURL = RecordURL

    @property
    def Sequence(self):
        return self._Sequence

    @Sequence.setter
    def Sequence(self, Sequence):
        self._Sequence = Sequence

    @property
    def StartTimestamp(self):
        return self._StartTimestamp

    @StartTimestamp.setter
    def StartTimestamp(self, StartTimestamp):
        self._StartTimestamp = StartTimestamp

    @property
    def SkillGroupName(self):
        return self._SkillGroupName

    @SkillGroupName.setter
    def SkillGroupName(self, SkillGroupName):
        self._SkillGroupName = SkillGroupName

    @property
    def CustomRecordURL(self):
        return self._CustomRecordURL

    @CustomRecordURL.setter
    def CustomRecordURL(self, CustomRecordURL):
        self._CustomRecordURL = CustomRecordURL


    def _deserialize(self, params):
        self._Mail = params.get("Mail")
        self._Phone = params.get("Phone")
        self._RingTimestamp = params.get("RingTimestamp")
        self._AcceptTimestamp = params.get("AcceptTimestamp")
        self._EndedTimestamp = params.get("EndedTimestamp")
        self._RecordId = params.get("RecordId")
        self._Type = params.get("Type")
        self._TransferFrom = params.get("TransferFrom")
        self._TransferFromType = params.get("TransferFromType")
        self._TransferTo = params.get("TransferTo")
        self._TransferToType = params.get("TransferToType")
        self._SkillGroupId = params.get("SkillGroupId")
        self._EndStatusString = params.get("EndStatusString")
        self._RecordURL = params.get("RecordURL")
        self._Sequence = params.get("Sequence")
        self._StartTimestamp = params.get("StartTimestamp")
        self._SkillGroupName = params.get("SkillGroupName")
        self._CustomRecordURL = params.get("CustomRecordURL")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SkillGroupInfoItem(AbstractModel):
    """Skill group information.

    """

    def __init__(self):
        r"""
        :param _SkillGroupId: Skill group ID.
        :type SkillGroupId: int
        :param _SkillGroupName: Skill group name.
        :type SkillGroupName: str
        :param _Type: (Deprecated) Type: IM, TEL, ALL (full media).
        :type Type: str
        :param _RoutePolicy: Session allocation policy.
Note: this field may return null, indicating that no valid values can be obtained.
        :type RoutePolicy: str
        :param _UsingLastSeat: Should the conversation allocation prioritize the last service seat?
Note: This field may return null, indicating that no valid values can be obtained.
        :type UsingLastSeat: int
        :param _MaxConcurrency: Maximum concurrency number of single client service (default 1 for telephone type).
Note: this field may return null, indicating that no valid values can be obtained.
        :type MaxConcurrency: int
        :param _LastModifyTimestamp: Last modification time.
Note: this field may return null, indicating that no valid values can be obtained.
        :type LastModifyTimestamp: int
        :param _SkillGroupType: Skill group type 0-phone, 1-online, 3-audio, 4-video.
Note: this field may return null, indicating that no valid values can be obtained.
        :type SkillGroupType: int
        :param _Alias: Extension number within the skill group
Note: This field may return null, indicating that no valid values can be obtained.
        :type Alias: str
        """
        self._SkillGroupId = None
        self._SkillGroupName = None
        self._Type = None
        self._RoutePolicy = None
        self._UsingLastSeat = None
        self._MaxConcurrency = None
        self._LastModifyTimestamp = None
        self._SkillGroupType = None
        self._Alias = None

    @property
    def SkillGroupId(self):
        return self._SkillGroupId

    @SkillGroupId.setter
    def SkillGroupId(self, SkillGroupId):
        self._SkillGroupId = SkillGroupId

    @property
    def SkillGroupName(self):
        return self._SkillGroupName

    @SkillGroupName.setter
    def SkillGroupName(self, SkillGroupName):
        self._SkillGroupName = SkillGroupName

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def RoutePolicy(self):
        return self._RoutePolicy

    @RoutePolicy.setter
    def RoutePolicy(self, RoutePolicy):
        self._RoutePolicy = RoutePolicy

    @property
    def UsingLastSeat(self):
        return self._UsingLastSeat

    @UsingLastSeat.setter
    def UsingLastSeat(self, UsingLastSeat):
        self._UsingLastSeat = UsingLastSeat

    @property
    def MaxConcurrency(self):
        return self._MaxConcurrency

    @MaxConcurrency.setter
    def MaxConcurrency(self, MaxConcurrency):
        self._MaxConcurrency = MaxConcurrency

    @property
    def LastModifyTimestamp(self):
        return self._LastModifyTimestamp

    @LastModifyTimestamp.setter
    def LastModifyTimestamp(self, LastModifyTimestamp):
        self._LastModifyTimestamp = LastModifyTimestamp

    @property
    def SkillGroupType(self):
        return self._SkillGroupType

    @SkillGroupType.setter
    def SkillGroupType(self, SkillGroupType):
        self._SkillGroupType = SkillGroupType

    @property
    def Alias(self):
        return self._Alias

    @Alias.setter
    def Alias(self, Alias):
        self._Alias = Alias


    def _deserialize(self, params):
        self._SkillGroupId = params.get("SkillGroupId")
        self._SkillGroupName = params.get("SkillGroupName")
        self._Type = params.get("Type")
        self._RoutePolicy = params.get("RoutePolicy")
        self._UsingLastSeat = params.get("UsingLastSeat")
        self._MaxConcurrency = params.get("MaxConcurrency")
        self._LastModifyTimestamp = params.get("LastModifyTimestamp")
        self._SkillGroupType = params.get("SkillGroupType")
        self._Alias = params.get("Alias")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SkillGroupItem(AbstractModel):
    """Skill group information.

    """

    def __init__(self):
        r"""
        :param _SkillGroupId: Skill group ID.
        :type SkillGroupId: int
        :param _SkillGroupName: Skill group name.
        :type SkillGroupName: str
        :param _Priority: Priority
        :type Priority: int
        :param _Type: Type: IM, TEL, ALL (full media).
        :type Type: str
        """
        self._SkillGroupId = None
        self._SkillGroupName = None
        self._Priority = None
        self._Type = None

    @property
    def SkillGroupId(self):
        return self._SkillGroupId

    @SkillGroupId.setter
    def SkillGroupId(self, SkillGroupId):
        self._SkillGroupId = SkillGroupId

    @property
    def SkillGroupName(self):
        return self._SkillGroupName

    @SkillGroupName.setter
    def SkillGroupName(self, SkillGroupName):
        self._SkillGroupName = SkillGroupName

    @property
    def Priority(self):
        return self._Priority

    @Priority.setter
    def Priority(self, Priority):
        self._Priority = Priority

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._SkillGroupId = params.get("SkillGroupId")
        self._SkillGroupName = params.get("SkillGroupName")
        self._Priority = params.get("Priority")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class StaffBuyInfo(AbstractModel):
    """Agent purchase information

    """

    def __init__(self):
        r"""
        :param _Num: Number of agents purchased
        :type Num: int
        :param _BuyTime: Purchased timestamp.
        :type BuyTime: int
        :param _EndTime: End timestamp.
        :type EndTime: int
        :param _SipNum: Number of office telephones purchased.
Note: this field may return null, indicating that no valid values can be obtained.
        :type SipNum: int
        """
        self._Num = None
        self._BuyTime = None
        self._EndTime = None
        self._SipNum = None

    @property
    def Num(self):
        return self._Num

    @Num.setter
    def Num(self, Num):
        self._Num = Num

    @property
    def BuyTime(self):
        return self._BuyTime

    @BuyTime.setter
    def BuyTime(self, BuyTime):
        self._BuyTime = BuyTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def SipNum(self):
        return self._SipNum

    @SipNum.setter
    def SipNum(self, SipNum):
        self._SipNum = SipNum


    def _deserialize(self, params):
        self._Num = params.get("Num")
        self._BuyTime = params.get("BuyTime")
        self._EndTime = params.get("EndTime")
        self._SipNum = params.get("SipNum")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class StaffInfo(AbstractModel):
    """Agent Information with Skill Group Priority

    """

    def __init__(self):
        r"""
        :param _Name: Agent name.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Name: str
        :param _Mail: Agent email.
        :type Mail: str
        :param _Phone: Agent's Telephone Number
Note: This field may return null, indicating that no valid values can be obtained.
        :type Phone: str
        :param _Nick: Agent nickname.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Nick: str
        :param _StaffNumber: Agent ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type StaffNumber: str
        :param _RoleId: User Role ID
        :type RoleId: int
        :param _SkillGroupList: Affiliated Skill Group List.
Note: this field may return null, indicating that no valid values can be obtained.
        :type SkillGroupList: list of SkillGroupItem
        :param _LastModifyTimestamp: Last modification time.
Note: this field may return null, indicating that no valid values can be obtained.
        :type LastModifyTimestamp: int
        """
        self._Name = None
        self._Mail = None
        self._Phone = None
        self._Nick = None
        self._StaffNumber = None
        self._RoleId = None
        self._SkillGroupList = None
        self._LastModifyTimestamp = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Mail(self):
        return self._Mail

    @Mail.setter
    def Mail(self, Mail):
        self._Mail = Mail

    @property
    def Phone(self):
        return self._Phone

    @Phone.setter
    def Phone(self, Phone):
        self._Phone = Phone

    @property
    def Nick(self):
        return self._Nick

    @Nick.setter
    def Nick(self, Nick):
        self._Nick = Nick

    @property
    def StaffNumber(self):
        return self._StaffNumber

    @StaffNumber.setter
    def StaffNumber(self, StaffNumber):
        self._StaffNumber = StaffNumber

    @property
    def RoleId(self):
        return self._RoleId

    @RoleId.setter
    def RoleId(self, RoleId):
        self._RoleId = RoleId

    @property
    def SkillGroupList(self):
        return self._SkillGroupList

    @SkillGroupList.setter
    def SkillGroupList(self, SkillGroupList):
        self._SkillGroupList = SkillGroupList

    @property
    def LastModifyTimestamp(self):
        return self._LastModifyTimestamp

    @LastModifyTimestamp.setter
    def LastModifyTimestamp(self, LastModifyTimestamp):
        self._LastModifyTimestamp = LastModifyTimestamp


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Mail = params.get("Mail")
        self._Phone = params.get("Phone")
        self._Nick = params.get("Nick")
        self._StaffNumber = params.get("StaffNumber")
        self._RoleId = params.get("RoleId")
        if params.get("SkillGroupList") is not None:
            self._SkillGroupList = []
            for item in params.get("SkillGroupList"):
                obj = SkillGroupItem()
                obj._deserialize(item)
                self._SkillGroupList.append(obj)
        self._LastModifyTimestamp = params.get("LastModifyTimestamp")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class StaffSkillGroupList(AbstractModel):
    """Bound skill group list for agents.

    """

    def __init__(self):
        r"""
        :param _SkillGroupId: Skill group ID.
        :type SkillGroupId: int
        :param _Priority: Priority of the agent in the skill group (1 is the highest, 5 is the lowest, 3 by default).
        :type Priority: int
        """
        self._SkillGroupId = None
        self._Priority = None

    @property
    def SkillGroupId(self):
        return self._SkillGroupId

    @SkillGroupId.setter
    def SkillGroupId(self, SkillGroupId):
        self._SkillGroupId = SkillGroupId

    @property
    def Priority(self):
        return self._Priority

    @Priority.setter
    def Priority(self, Priority):
        self._Priority = Priority


    def _deserialize(self, params):
        self._SkillGroupId = params.get("SkillGroupId")
        self._Priority = params.get("Priority")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class StaffStatusExtra(AbstractModel):
    """Supplementary Information on Agent Status

    """

    def __init__(self):
        r"""
        :param _Type: IM - Text | TEL - Cell phone | ALL - Full media.
        :type Type: str
        :param _Direct: IN - Inbound | OUT - Outbound.
        :type Direct: str
        """
        self._Type = None
        self._Direct = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Direct(self):
        return self._Direct

    @Direct.setter
    def Direct(self, Direct):
        self._Direct = Direct


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Direct = params.get("Direct")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class StaffStatusMetrics(AbstractModel):
    """Agent status-related information

    """

    def __init__(self):
        r"""
        :param _Email: Agent email.
        :type Email: str
        :param _Status: Agent status free Available | busy Busy | rest On Break | notReady Not Ready | afterCallWork Post-call Adjustment | offline Offline
        :type Status: str
        :param _StatusExtra: Supplementary Information on Agent Status
        :type StatusExtra: :class:`tencentcloud.ccc.v20200210.models.StaffStatusExtra`
        :param _OnlineDuration: Total Online duration of the day.
        :type OnlineDuration: int
        :param _FreeDuration: Total Available duration of the day.
        :type FreeDuration: int
        :param _BusyDuration: Total Busy duration of the day.
        :type BusyDuration: int
        :param _NotReadyDuration: Total Not Ready status duration of the day.
        :type NotReadyDuration: int
        :param _RestDuration: Total Break duration of the day.
        :type RestDuration: int
        :param _AfterCallWorkDuration: Total After Call Work duration of the day.
        :type AfterCallWorkDuration: int
        :param _Reason: Reason for Break.
        :type Reason: str
        :param _ReserveRest: Whether to reserve Break status.
        :type ReserveRest: bool
        :param _ReserveNotReady: Whether to reserve Not Ready status.
        :type ReserveNotReady: bool
        :param _UseMobileAccept: Cell phone answering pattern: 0 - Off | 1 - Only when Offline | 2 - Always.
        :type UseMobileAccept: int
        :param _UseMobileCallOut: Cell phone outbound call switch.
        :type UseMobileCallOut: bool
        :param _LastOnlineTimestamp: Last online timestamp.
Note: This field may return null, indicating that no valid values can be obtained.
        :type LastOnlineTimestamp: int
        :param _LastStatusTimestamp: Last status timestamp.
Note: This field may return null, indicating that no valid values can be obtained.
        :type LastStatusTimestamp: int
        """
        self._Email = None
        self._Status = None
        self._StatusExtra = None
        self._OnlineDuration = None
        self._FreeDuration = None
        self._BusyDuration = None
        self._NotReadyDuration = None
        self._RestDuration = None
        self._AfterCallWorkDuration = None
        self._Reason = None
        self._ReserveRest = None
        self._ReserveNotReady = None
        self._UseMobileAccept = None
        self._UseMobileCallOut = None
        self._LastOnlineTimestamp = None
        self._LastStatusTimestamp = None

    @property
    def Email(self):
        return self._Email

    @Email.setter
    def Email(self, Email):
        self._Email = Email

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def StatusExtra(self):
        return self._StatusExtra

    @StatusExtra.setter
    def StatusExtra(self, StatusExtra):
        self._StatusExtra = StatusExtra

    @property
    def OnlineDuration(self):
        return self._OnlineDuration

    @OnlineDuration.setter
    def OnlineDuration(self, OnlineDuration):
        self._OnlineDuration = OnlineDuration

    @property
    def FreeDuration(self):
        return self._FreeDuration

    @FreeDuration.setter
    def FreeDuration(self, FreeDuration):
        self._FreeDuration = FreeDuration

    @property
    def BusyDuration(self):
        return self._BusyDuration

    @BusyDuration.setter
    def BusyDuration(self, BusyDuration):
        self._BusyDuration = BusyDuration

    @property
    def NotReadyDuration(self):
        return self._NotReadyDuration

    @NotReadyDuration.setter
    def NotReadyDuration(self, NotReadyDuration):
        self._NotReadyDuration = NotReadyDuration

    @property
    def RestDuration(self):
        return self._RestDuration

    @RestDuration.setter
    def RestDuration(self, RestDuration):
        self._RestDuration = RestDuration

    @property
    def AfterCallWorkDuration(self):
        return self._AfterCallWorkDuration

    @AfterCallWorkDuration.setter
    def AfterCallWorkDuration(self, AfterCallWorkDuration):
        self._AfterCallWorkDuration = AfterCallWorkDuration

    @property
    def Reason(self):
        return self._Reason

    @Reason.setter
    def Reason(self, Reason):
        self._Reason = Reason

    @property
    def ReserveRest(self):
        return self._ReserveRest

    @ReserveRest.setter
    def ReserveRest(self, ReserveRest):
        self._ReserveRest = ReserveRest

    @property
    def ReserveNotReady(self):
        return self._ReserveNotReady

    @ReserveNotReady.setter
    def ReserveNotReady(self, ReserveNotReady):
        self._ReserveNotReady = ReserveNotReady

    @property
    def UseMobileAccept(self):
        return self._UseMobileAccept

    @UseMobileAccept.setter
    def UseMobileAccept(self, UseMobileAccept):
        self._UseMobileAccept = UseMobileAccept

    @property
    def UseMobileCallOut(self):
        return self._UseMobileCallOut

    @UseMobileCallOut.setter
    def UseMobileCallOut(self, UseMobileCallOut):
        self._UseMobileCallOut = UseMobileCallOut

    @property
    def LastOnlineTimestamp(self):
        return self._LastOnlineTimestamp

    @LastOnlineTimestamp.setter
    def LastOnlineTimestamp(self, LastOnlineTimestamp):
        self._LastOnlineTimestamp = LastOnlineTimestamp

    @property
    def LastStatusTimestamp(self):
        return self._LastStatusTimestamp

    @LastStatusTimestamp.setter
    def LastStatusTimestamp(self, LastStatusTimestamp):
        self._LastStatusTimestamp = LastStatusTimestamp


    def _deserialize(self, params):
        self._Email = params.get("Email")
        self._Status = params.get("Status")
        if params.get("StatusExtra") is not None:
            self._StatusExtra = StaffStatusExtra()
            self._StatusExtra._deserialize(params.get("StatusExtra"))
        self._OnlineDuration = params.get("OnlineDuration")
        self._FreeDuration = params.get("FreeDuration")
        self._BusyDuration = params.get("BusyDuration")
        self._NotReadyDuration = params.get("NotReadyDuration")
        self._RestDuration = params.get("RestDuration")
        self._AfterCallWorkDuration = params.get("AfterCallWorkDuration")
        self._Reason = params.get("Reason")
        self._ReserveRest = params.get("ReserveRest")
        self._ReserveNotReady = params.get("ReserveNotReady")
        self._UseMobileAccept = params.get("UseMobileAccept")
        self._UseMobileCallOut = params.get("UseMobileCallOut")
        self._LastOnlineTimestamp = params.get("LastOnlineTimestamp")
        self._LastStatusTimestamp = params.get("LastStatusTimestamp")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class StopAutoCalloutTaskRequest(AbstractModel):
    """StopAutoCalloutTask request structure.

    """

    def __init__(self):
        r"""
        :param _SdkAppId: Call Center Instance ID.
        :type SdkAppId: int
        :param _TaskId: Task ID.
        :type TaskId: int
        """
        self._SdkAppId = None
        self._TaskId = None

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._SdkAppId = params.get("SdkAppId")
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class StopAutoCalloutTaskResponse(AbstractModel):
    """StopAutoCalloutTask response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class TelCdrInfo(AbstractModel):
    """Phone call information.

    """

    def __init__(self):
        r"""
        :param _Caller: Caller number.
        :type Caller: str
        :param _Callee: Called number.
        :type Callee: str
        :param _Time: Call initiation timestamp, Unix timestamp.
        :type Time: int
        :param _Direction: Call direction: 0 - Inbound, 1 - Outbound.
        :type Direction: int
        :param _Duration: Call duration.
        :type Duration: int
        :param _RecordURL: Recording Information.
        :type RecordURL: str
        :param _RecordId: Recording ID.
Note: this field may return null, indicating that no valid values can be obtained.
        :type RecordId: str
        :param _SeatUser: Agent Information
        :type SeatUser: :class:`tencentcloud.ccc.v20200210.models.SeatUserInfo`
        :param _EndStatus: EndStatus corresponds one-to-one with EndStatusString, specific enumerations are as follows:

**Scenario	         EndStatus	EndStatusString	Status Description**

Incoming & Outgoing Calls	1	        ok	                        Normal End

Incoming & Outgoing Calls	0	        error	                System Error

Incoming Call	             102	        ivrGiveUp	        User Gave Up During IVR

Incoming Call	             103	        waitingGiveUp	       User Gave Up During Queue

Incoming Call	             104	        ringingGiveUp	       User Gave Up During Ringing

Incoming Call	             105	        noSeatOnline	       No Seat Online

Incoming Call              106	       notWorkTime	       Non-Working Hours   

Incoming Call	            107	       ivrEnd	               Ended Directly After IVR

Incoming Call	            100	      blackList Incoming blocklist  

Outgoing Call               2	              unconnected	Unconnected

Outgoing Call             108	        restrictedCallee	Callee restricted due to high risk

Outgoing Call             109	        tooManyRequest	    Frequency limit exceeded

Outgoing Call             110	        restrictedArea	    Call to restricted area

Outgoing Call             111	        restrictedTime	Call time restricted
                         
Outgoing Call             201            unknown	Unknown status

Outgoing Call             202            notAnswer	Missed call

Outgoing Call            203	    userReject	Reject/Hang Up

Outgoing Call	          204	    powerOff	Shutting down

Outgoing Call           205            numberNotExist	Disconnected Number

Outgoing Call	         206	           busy	During the call

Outgoing Call   	        207	           outOfCredit	Overdue Payment

Outgoing Call	         208	           operatorError	 ISP Carrier Line Anomaly

Outgoing Call         	209	           callerCancel	Caller Cancelled

Outgoing Call	        210	           notInService	Out of Service Area

Incoming & Outgoing Calls	211    clientError    Client Error

        :type EndStatus: int
        :param _SkillGroup: Skill group name.
        :type SkillGroup: str
        :param _CallerLocation: Caller's location.
        :type CallerLocation: str
        :param _IVRDuration: Time spent in IVR stage.
Note: this field may return null, indicating that no valid values can be obtained.
        :type IVRDuration: int
        :param _RingTimestamp: Ring timestamp. UNIX second-level timestamp
Note: this field may return null, indicating that no valid values can be obtained.
        :type RingTimestamp: int
        :param _AcceptTimestamp: Answer timestamp. UNIX second-Level timestamp
Note: this field may return null, indicating that no valid values can be obtained.
        :type AcceptTimestamp: int
        :param _EndedTimestamp: End timestamp. UNIX second-level timestamp
Note: this field may return null, indicating that no valid values can be obtained.
        :type EndedTimestamp: int
        :param _IVRKeyPressed: IVR key information, e.g. ["1","2","3"]
Note: this field may return null, indicating that no valid values can be obtained.
        :type IVRKeyPressed: list of str
        :param _HungUpSide: Hanging Up Party seat Seat user Users system system
Note: This field may return null, indicating that no valid values can be obtained.
        :type HungUpSide: str
        :param _ServeParticipants: List of Service Participants
Note: this field may return null, indicating that no valid values can be obtained.
        :type ServeParticipants: list of ServeParticipant
        :param _SkillGroupId: Skill group ID.
Note: this field may return null, indicating that no valid values can be obtained.
        :type SkillGroupId: int
        :param _EndStatusString: EndStatus corresponds one-to-one with EndStatusString, specific enumerations are as follows:

**Scenario	         EndStatus	EndStatusString	Status Description**

Incoming & Outgoing Calls	1	        ok	                        Normal End

Incoming & Outgoing Calls	0	        error	                System Error

Incoming Call	             102	        ivrGiveUp	        User Gave Up During IVR

Incoming Call	             103	        waitingGiveUp	       User Gave Up During Queue

Incoming Call	             104	        ringingGiveUp	       User Gave Up During Ringing

Incoming Call	             105	        noSeatOnline	       No Seat Online

Incoming Call              106	       notWorkTime	       Non-Working Hours   

Incoming Call	            107	       ivrEnd	               Ended Directly After IVR

Incoming Call	            100	      blackList Incoming blocklist  

Outgoing Call               2	              unconnected	Unconnected

Outgoing Call             108	        restrictedCallee	Callee restricted due to high risk

Outgoing Call             109	        tooManyRequest	    Frequency limit exceeded

Outgoing Call             110	        restrictedArea	    Call to restricted area

Outgoing Call             111	        restrictedTime	Call time restricted
                         
Outgoing Call             201            unknown	Unknown status

Outgoing Call             202            notAnswer	Missed call

Outgoing Call            203	    userReject	Reject/Hang Up

Outgoing Call	          204	    powerOff	Shutting down

Outgoing Call           205            numberNotExist	Disconnected Number

Phone Call Out	         206	           busy	In Call

Outgoing Call   	        207	           outOfCredit	Overdue Payment

Outgoing Call	         208	           operatorError	 ISP Carrier Line Anomaly

Outgoing Call         	209	           callerCancel	Caller Cancelled

Outgoing Call	        210	           notInService	Out of Service Area

Phone Call In & Out	211    clientError    Client Error

Note: This field may return null, indicating that no valid values can be obtained.
        :type EndStatusString: str
        :param _StartTimestamp: Session start timestamp. UNIX second-level timestamp.
Note: This field may return null, indicating that no valid value can be obtained.
        :type StartTimestamp: int
        :param _QueuedTimestamp: Queue entry time. Unix second-level timestamp.
Note: This field may return null, indicating that no valid value can be obtained.
        :type QueuedTimestamp: int
        :param _PostIVRKeyPressed: Post-IVR key information (e.g. [{"Key":"1","Label":"Very Satisfied"}])
Note: This field may return null, indicating that no valid value can be obtained.
        :type PostIVRKeyPressed: list of IVRKeyPressedElement
        :param _QueuedSkillGroupId: Queue Skill Group ID.
Note: This field may return null, indicating that no valid value can be obtained.
        :type QueuedSkillGroupId: int
        :param _SessionId: Session ID.
Note: This field may return null, indicating that no valid value can be obtained.
        :type SessionId: str
        :param _ProtectedCaller: Caller number protection ID. (Effective when the number protection map feature is activated, and the Caller field is empty).
Note: This field may return null, indicating that no valid values can be obtained.
        :type ProtectedCaller: str
        :param _ProtectedCallee: Called number protection ID (Effective when the number protection map feature is activated, and the Callee field is empty).
Note: This field may return null, indicating that no valid values can be obtained.
        :type ProtectedCallee: str
        :param _Uui: Customer custom data. (User-to-User Interface)
Note: This field may return null, indicating that no valid values can be obtained.
        :type Uui: str
        :param _UUI: Customer custom data. (User-to-User Interface)
Note: This field may return null, indicating that no valid values can be obtained.
        :type UUI: str
        :param _IVRKeyPressedEx: IVR key information (e.g.?[{"Key":"1","Label":"highly satisfied"}])
Note: This field may return null, indicating that no valid values can be obtained.
        :type IVRKeyPressedEx: list of IVRKeyPressedElement
        :param _AsrUrl: Access to the ASR text information address of the recording.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AsrUrl: str
        :param _CustomRecordURL: Address of the third party COS for transferring recording.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CustomRecordURL: str
        :param _Remark: Remarks
Note: This field may return null, indicating that no valid values can be obtained.
        :type Remark: str
        :param _QueuedSkillGroupName: Queue skill group name.
Note: This field may return null, indicating that no valid values can be obtained.
        :type QueuedSkillGroupName: str
        :param _VoicemailRecordURL: Audio message recording URL during call.
Note: This field may return null, indicating that no valid values can be obtained.
        :type VoicemailRecordURL: list of str
        :param _VoicemailAsrURL: Text Information address of ASR audio message during a call.
Note: This field may return null, indicating that no valid values can be obtained.
        :type VoicemailAsrURL: list of str
        """
        self._Caller = None
        self._Callee = None
        self._Time = None
        self._Direction = None
        self._Duration = None
        self._RecordURL = None
        self._RecordId = None
        self._SeatUser = None
        self._EndStatus = None
        self._SkillGroup = None
        self._CallerLocation = None
        self._IVRDuration = None
        self._RingTimestamp = None
        self._AcceptTimestamp = None
        self._EndedTimestamp = None
        self._IVRKeyPressed = None
        self._HungUpSide = None
        self._ServeParticipants = None
        self._SkillGroupId = None
        self._EndStatusString = None
        self._StartTimestamp = None
        self._QueuedTimestamp = None
        self._PostIVRKeyPressed = None
        self._QueuedSkillGroupId = None
        self._SessionId = None
        self._ProtectedCaller = None
        self._ProtectedCallee = None
        self._Uui = None
        self._UUI = None
        self._IVRKeyPressedEx = None
        self._AsrUrl = None
        self._CustomRecordURL = None
        self._Remark = None
        self._QueuedSkillGroupName = None
        self._VoicemailRecordURL = None
        self._VoicemailAsrURL = None

    @property
    def Caller(self):
        return self._Caller

    @Caller.setter
    def Caller(self, Caller):
        self._Caller = Caller

    @property
    def Callee(self):
        return self._Callee

    @Callee.setter
    def Callee(self, Callee):
        self._Callee = Callee

    @property
    def Time(self):
        return self._Time

    @Time.setter
    def Time(self, Time):
        self._Time = Time

    @property
    def Direction(self):
        return self._Direction

    @Direction.setter
    def Direction(self, Direction):
        self._Direction = Direction

    @property
    def Duration(self):
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration

    @property
    def RecordURL(self):
        return self._RecordURL

    @RecordURL.setter
    def RecordURL(self, RecordURL):
        self._RecordURL = RecordURL

    @property
    def RecordId(self):
        return self._RecordId

    @RecordId.setter
    def RecordId(self, RecordId):
        self._RecordId = RecordId

    @property
    def SeatUser(self):
        return self._SeatUser

    @SeatUser.setter
    def SeatUser(self, SeatUser):
        self._SeatUser = SeatUser

    @property
    def EndStatus(self):
        return self._EndStatus

    @EndStatus.setter
    def EndStatus(self, EndStatus):
        self._EndStatus = EndStatus

    @property
    def SkillGroup(self):
        return self._SkillGroup

    @SkillGroup.setter
    def SkillGroup(self, SkillGroup):
        self._SkillGroup = SkillGroup

    @property
    def CallerLocation(self):
        return self._CallerLocation

    @CallerLocation.setter
    def CallerLocation(self, CallerLocation):
        self._CallerLocation = CallerLocation

    @property
    def IVRDuration(self):
        return self._IVRDuration

    @IVRDuration.setter
    def IVRDuration(self, IVRDuration):
        self._IVRDuration = IVRDuration

    @property
    def RingTimestamp(self):
        return self._RingTimestamp

    @RingTimestamp.setter
    def RingTimestamp(self, RingTimestamp):
        self._RingTimestamp = RingTimestamp

    @property
    def AcceptTimestamp(self):
        return self._AcceptTimestamp

    @AcceptTimestamp.setter
    def AcceptTimestamp(self, AcceptTimestamp):
        self._AcceptTimestamp = AcceptTimestamp

    @property
    def EndedTimestamp(self):
        return self._EndedTimestamp

    @EndedTimestamp.setter
    def EndedTimestamp(self, EndedTimestamp):
        self._EndedTimestamp = EndedTimestamp

    @property
    def IVRKeyPressed(self):
        return self._IVRKeyPressed

    @IVRKeyPressed.setter
    def IVRKeyPressed(self, IVRKeyPressed):
        self._IVRKeyPressed = IVRKeyPressed

    @property
    def HungUpSide(self):
        return self._HungUpSide

    @HungUpSide.setter
    def HungUpSide(self, HungUpSide):
        self._HungUpSide = HungUpSide

    @property
    def ServeParticipants(self):
        return self._ServeParticipants

    @ServeParticipants.setter
    def ServeParticipants(self, ServeParticipants):
        self._ServeParticipants = ServeParticipants

    @property
    def SkillGroupId(self):
        return self._SkillGroupId

    @SkillGroupId.setter
    def SkillGroupId(self, SkillGroupId):
        self._SkillGroupId = SkillGroupId

    @property
    def EndStatusString(self):
        return self._EndStatusString

    @EndStatusString.setter
    def EndStatusString(self, EndStatusString):
        self._EndStatusString = EndStatusString

    @property
    def StartTimestamp(self):
        return self._StartTimestamp

    @StartTimestamp.setter
    def StartTimestamp(self, StartTimestamp):
        self._StartTimestamp = StartTimestamp

    @property
    def QueuedTimestamp(self):
        return self._QueuedTimestamp

    @QueuedTimestamp.setter
    def QueuedTimestamp(self, QueuedTimestamp):
        self._QueuedTimestamp = QueuedTimestamp

    @property
    def PostIVRKeyPressed(self):
        return self._PostIVRKeyPressed

    @PostIVRKeyPressed.setter
    def PostIVRKeyPressed(self, PostIVRKeyPressed):
        self._PostIVRKeyPressed = PostIVRKeyPressed

    @property
    def QueuedSkillGroupId(self):
        return self._QueuedSkillGroupId

    @QueuedSkillGroupId.setter
    def QueuedSkillGroupId(self, QueuedSkillGroupId):
        self._QueuedSkillGroupId = QueuedSkillGroupId

    @property
    def SessionId(self):
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def ProtectedCaller(self):
        return self._ProtectedCaller

    @ProtectedCaller.setter
    def ProtectedCaller(self, ProtectedCaller):
        self._ProtectedCaller = ProtectedCaller

    @property
    def ProtectedCallee(self):
        return self._ProtectedCallee

    @ProtectedCallee.setter
    def ProtectedCallee(self, ProtectedCallee):
        self._ProtectedCallee = ProtectedCallee

    @property
    def Uui(self):
        warnings.warn("parameter `Uui` is deprecated", DeprecationWarning) 

        return self._Uui

    @Uui.setter
    def Uui(self, Uui):
        warnings.warn("parameter `Uui` is deprecated", DeprecationWarning) 

        self._Uui = Uui

    @property
    def UUI(self):
        return self._UUI

    @UUI.setter
    def UUI(self, UUI):
        self._UUI = UUI

    @property
    def IVRKeyPressedEx(self):
        return self._IVRKeyPressedEx

    @IVRKeyPressedEx.setter
    def IVRKeyPressedEx(self, IVRKeyPressedEx):
        self._IVRKeyPressedEx = IVRKeyPressedEx

    @property
    def AsrUrl(self):
        return self._AsrUrl

    @AsrUrl.setter
    def AsrUrl(self, AsrUrl):
        self._AsrUrl = AsrUrl

    @property
    def CustomRecordURL(self):
        return self._CustomRecordURL

    @CustomRecordURL.setter
    def CustomRecordURL(self, CustomRecordURL):
        self._CustomRecordURL = CustomRecordURL

    @property
    def Remark(self):
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def QueuedSkillGroupName(self):
        return self._QueuedSkillGroupName

    @QueuedSkillGroupName.setter
    def QueuedSkillGroupName(self, QueuedSkillGroupName):
        self._QueuedSkillGroupName = QueuedSkillGroupName

    @property
    def VoicemailRecordURL(self):
        return self._VoicemailRecordURL

    @VoicemailRecordURL.setter
    def VoicemailRecordURL(self, VoicemailRecordURL):
        self._VoicemailRecordURL = VoicemailRecordURL

    @property
    def VoicemailAsrURL(self):
        return self._VoicemailAsrURL

    @VoicemailAsrURL.setter
    def VoicemailAsrURL(self, VoicemailAsrURL):
        self._VoicemailAsrURL = VoicemailAsrURL


    def _deserialize(self, params):
        self._Caller = params.get("Caller")
        self._Callee = params.get("Callee")
        self._Time = params.get("Time")
        self._Direction = params.get("Direction")
        self._Duration = params.get("Duration")
        self._RecordURL = params.get("RecordURL")
        self._RecordId = params.get("RecordId")
        if params.get("SeatUser") is not None:
            self._SeatUser = SeatUserInfo()
            self._SeatUser._deserialize(params.get("SeatUser"))
        self._EndStatus = params.get("EndStatus")
        self._SkillGroup = params.get("SkillGroup")
        self._CallerLocation = params.get("CallerLocation")
        self._IVRDuration = params.get("IVRDuration")
        self._RingTimestamp = params.get("RingTimestamp")
        self._AcceptTimestamp = params.get("AcceptTimestamp")
        self._EndedTimestamp = params.get("EndedTimestamp")
        self._IVRKeyPressed = params.get("IVRKeyPressed")
        self._HungUpSide = params.get("HungUpSide")
        if params.get("ServeParticipants") is not None:
            self._ServeParticipants = []
            for item in params.get("ServeParticipants"):
                obj = ServeParticipant()
                obj._deserialize(item)
                self._ServeParticipants.append(obj)
        self._SkillGroupId = params.get("SkillGroupId")
        self._EndStatusString = params.get("EndStatusString")
        self._StartTimestamp = params.get("StartTimestamp")
        self._QueuedTimestamp = params.get("QueuedTimestamp")
        if params.get("PostIVRKeyPressed") is not None:
            self._PostIVRKeyPressed = []
            for item in params.get("PostIVRKeyPressed"):
                obj = IVRKeyPressedElement()
                obj._deserialize(item)
                self._PostIVRKeyPressed.append(obj)
        self._QueuedSkillGroupId = params.get("QueuedSkillGroupId")
        self._SessionId = params.get("SessionId")
        self._ProtectedCaller = params.get("ProtectedCaller")
        self._ProtectedCallee = params.get("ProtectedCallee")
        self._Uui = params.get("Uui")
        self._UUI = params.get("UUI")
        if params.get("IVRKeyPressedEx") is not None:
            self._IVRKeyPressedEx = []
            for item in params.get("IVRKeyPressedEx"):
                obj = IVRKeyPressedElement()
                obj._deserialize(item)
                self._IVRKeyPressedEx.append(obj)
        self._AsrUrl = params.get("AsrUrl")
        self._CustomRecordURL = params.get("CustomRecordURL")
        self._Remark = params.get("Remark")
        self._QueuedSkillGroupName = params.get("QueuedSkillGroupName")
        self._VoicemailRecordURL = params.get("VoicemailRecordURL")
        self._VoicemailAsrURL = params.get("VoicemailAsrURL")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UnbindNumberCallOutSkillGroupRequest(AbstractModel):
    """UnbindNumberCallOutSkillGroup request structure.

    """

    def __init__(self):
        r"""
        :param _SdkAppId: Application ID (required) can be found at https://console.cloud.tencent.com/ccc.
        :type SdkAppId: int
        :param _Number: Number to be unbound.
        :type Number: str
        :param _SkillGroupIds: List of skill group IDs to be unbound.
        :type SkillGroupIds: list of int non-negative
        """
        self._SdkAppId = None
        self._Number = None
        self._SkillGroupIds = None

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def Number(self):
        return self._Number

    @Number.setter
    def Number(self, Number):
        self._Number = Number

    @property
    def SkillGroupIds(self):
        return self._SkillGroupIds

    @SkillGroupIds.setter
    def SkillGroupIds(self, SkillGroupIds):
        self._SkillGroupIds = SkillGroupIds


    def _deserialize(self, params):
        self._SdkAppId = params.get("SdkAppId")
        self._Number = params.get("Number")
        self._SkillGroupIds = params.get("SkillGroupIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UnbindNumberCallOutSkillGroupResponse(AbstractModel):
    """UnbindNumberCallOutSkillGroup response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class UnbindStaffSkillGroupListRequest(AbstractModel):
    """UnbindStaffSkillGroupList request structure.

    """

    def __init__(self):
        r"""
        :param _SdkAppId: Application ID (required) can be found at https://console.cloud.tencent.com/ccc.
        :type SdkAppId: int
        :param _StaffEmail: Customer service email.
        :type StaffEmail: str
        :param _SkillGroupList: Unbound skill group list.
        :type SkillGroupList: list of int
        """
        self._SdkAppId = None
        self._StaffEmail = None
        self._SkillGroupList = None

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def StaffEmail(self):
        return self._StaffEmail

    @StaffEmail.setter
    def StaffEmail(self, StaffEmail):
        self._StaffEmail = StaffEmail

    @property
    def SkillGroupList(self):
        return self._SkillGroupList

    @SkillGroupList.setter
    def SkillGroupList(self, SkillGroupList):
        self._SkillGroupList = SkillGroupList


    def _deserialize(self, params):
        self._SdkAppId = params.get("SdkAppId")
        self._StaffEmail = params.get("StaffEmail")
        self._SkillGroupList = params.get("SkillGroupList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UnbindStaffSkillGroupListResponse(AbstractModel):
    """UnbindStaffSkillGroupList response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class UpdateCCCSkillGroupRequest(AbstractModel):
    """UpdateCCCSkillGroup request structure.

    """

    def __init__(self):
        r"""
        :param _SdkAppId: Application ID (required).
        :type SdkAppId: int
        :param _SkillGroupID: Skill group ID.
        :type SkillGroupID: int
        :param _SkillGroupName: Modified skill group name.
        :type SkillGroupName: str
        :param _MaxConcurrency: Modified maximum concurrency and the maximum synchronization is 2.
        :type MaxConcurrency: int
        :param _RingAll: True for simultaneous ringing, false for sequential ringing.
        :type RingAll: bool
        """
        self._SdkAppId = None
        self._SkillGroupID = None
        self._SkillGroupName = None
        self._MaxConcurrency = None
        self._RingAll = None

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def SkillGroupID(self):
        return self._SkillGroupID

    @SkillGroupID.setter
    def SkillGroupID(self, SkillGroupID):
        self._SkillGroupID = SkillGroupID

    @property
    def SkillGroupName(self):
        return self._SkillGroupName

    @SkillGroupName.setter
    def SkillGroupName(self, SkillGroupName):
        self._SkillGroupName = SkillGroupName

    @property
    def MaxConcurrency(self):
        return self._MaxConcurrency

    @MaxConcurrency.setter
    def MaxConcurrency(self, MaxConcurrency):
        self._MaxConcurrency = MaxConcurrency

    @property
    def RingAll(self):
        return self._RingAll

    @RingAll.setter
    def RingAll(self, RingAll):
        self._RingAll = RingAll


    def _deserialize(self, params):
        self._SdkAppId = params.get("SdkAppId")
        self._SkillGroupID = params.get("SkillGroupID")
        self._SkillGroupName = params.get("SkillGroupName")
        self._MaxConcurrency = params.get("MaxConcurrency")
        self._RingAll = params.get("RingAll")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UpdateCCCSkillGroupResponse(AbstractModel):
    """UpdateCCCSkillGroup response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class UpdatePredictiveDialingCampaignRequest(AbstractModel):
    """UpdatePredictiveDialingCampaign request structure.

    """

    def __init__(self):
        r"""
        :param _SdkAppId: Application ID (required) can be found at https://console.cloud.tencent.com/ccc.
        :type SdkAppId: int
        :param _CampaignId: Generated task ID.
        :type CampaignId: int
        :param _Name: Task Name
        :type Name: str
        :param _Callees: Called list supporting E.164 or number formats without country code.
        :type Callees: list of str
        :param _Callers: Calling list using the number formats displayed on the management side.
        :type Callers: list of str
        :param _CallOrder: Being called sequence: 0 for random 1 for in order.
        :type CallOrder: int
        :param _SkillGroupId: ID of the used skill group of agents.
        :type SkillGroupId: int
        :param _Priority: Running priority of multiple tasks in the same application, from high to low 1 - 5.
        :type Priority: int
        :param _ExpectedAbandonRate: Expected call drop rate, percentage, 5 - 50.
        :type ExpectedAbandonRate: int
        :param _RetryInterval: Call retry interval, in seconds, [60 - 86,400].
        :type RetryInterval: int
        :param _StartTime: Task start time. Unix timestamp. The task will automatically start after this time.
        :type StartTime: int
        :param _EndTime: Task termination time. Unix timestamp. The task will automatically terminate after this time.
        :type EndTime: int
        :param _IVRId: Specified IVR ID.
        :type IVRId: int
        :param _RetryTimes: Number of call retries, 0 - 2.
        :type RetryTimes: int
        """
        self._SdkAppId = None
        self._CampaignId = None
        self._Name = None
        self._Callees = None
        self._Callers = None
        self._CallOrder = None
        self._SkillGroupId = None
        self._Priority = None
        self._ExpectedAbandonRate = None
        self._RetryInterval = None
        self._StartTime = None
        self._EndTime = None
        self._IVRId = None
        self._RetryTimes = None

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def CampaignId(self):
        return self._CampaignId

    @CampaignId.setter
    def CampaignId(self, CampaignId):
        self._CampaignId = CampaignId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Callees(self):
        return self._Callees

    @Callees.setter
    def Callees(self, Callees):
        self._Callees = Callees

    @property
    def Callers(self):
        return self._Callers

    @Callers.setter
    def Callers(self, Callers):
        self._Callers = Callers

    @property
    def CallOrder(self):
        return self._CallOrder

    @CallOrder.setter
    def CallOrder(self, CallOrder):
        self._CallOrder = CallOrder

    @property
    def SkillGroupId(self):
        return self._SkillGroupId

    @SkillGroupId.setter
    def SkillGroupId(self, SkillGroupId):
        self._SkillGroupId = SkillGroupId

    @property
    def Priority(self):
        return self._Priority

    @Priority.setter
    def Priority(self, Priority):
        self._Priority = Priority

    @property
    def ExpectedAbandonRate(self):
        return self._ExpectedAbandonRate

    @ExpectedAbandonRate.setter
    def ExpectedAbandonRate(self, ExpectedAbandonRate):
        self._ExpectedAbandonRate = ExpectedAbandonRate

    @property
    def RetryInterval(self):
        return self._RetryInterval

    @RetryInterval.setter
    def RetryInterval(self, RetryInterval):
        self._RetryInterval = RetryInterval

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def IVRId(self):
        return self._IVRId

    @IVRId.setter
    def IVRId(self, IVRId):
        self._IVRId = IVRId

    @property
    def RetryTimes(self):
        return self._RetryTimes

    @RetryTimes.setter
    def RetryTimes(self, RetryTimes):
        self._RetryTimes = RetryTimes


    def _deserialize(self, params):
        self._SdkAppId = params.get("SdkAppId")
        self._CampaignId = params.get("CampaignId")
        self._Name = params.get("Name")
        self._Callees = params.get("Callees")
        self._Callers = params.get("Callers")
        self._CallOrder = params.get("CallOrder")
        self._SkillGroupId = params.get("SkillGroupId")
        self._Priority = params.get("Priority")
        self._ExpectedAbandonRate = params.get("ExpectedAbandonRate")
        self._RetryInterval = params.get("RetryInterval")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._IVRId = params.get("IVRId")
        self._RetryTimes = params.get("RetryTimes")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UpdatePredictiveDialingCampaignResponse(AbstractModel):
    """UpdatePredictiveDialingCampaign response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class UploadAudioInfo(AbstractModel):
    """Upload Audio File Information

    """

    def __init__(self):
        r"""
        :param _CustomFileName: File Alias (can be duplicated)
        :type CustomFileName: str
        :param _AudioUrl: Audio File Link (supports mp3 and wav formats, file size not exceeding 5MB)
        :type AudioUrl: str
        """
        self._CustomFileName = None
        self._AudioUrl = None

    @property
    def CustomFileName(self):
        return self._CustomFileName

    @CustomFileName.setter
    def CustomFileName(self, CustomFileName):
        self._CustomFileName = CustomFileName

    @property
    def AudioUrl(self):
        return self._AudioUrl

    @AudioUrl.setter
    def AudioUrl(self, AudioUrl):
        self._AudioUrl = AudioUrl


    def _deserialize(self, params):
        self._CustomFileName = params.get("CustomFileName")
        self._AudioUrl = params.get("AudioUrl")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UploadIvrAudioFailedInfo(AbstractModel):
    """Failed to upload audio file information

    """

    def __init__(self):
        r"""
        :param _FileName: Filename
Note: This field may return null, indicating that no valid values can be obtained.
        :type FileName: str
        :param _FailedMsg: Reason for failure
Note: This field may return null, indicating that no valid values can be obtained.
        :type FailedMsg: str
        """
        self._FileName = None
        self._FailedMsg = None

    @property
    def FileName(self):
        return self._FileName

    @FileName.setter
    def FileName(self, FileName):
        self._FileName = FileName

    @property
    def FailedMsg(self):
        return self._FailedMsg

    @FailedMsg.setter
    def FailedMsg(self, FailedMsg):
        self._FailedMsg = FailedMsg


    def _deserialize(self, params):
        self._FileName = params.get("FileName")
        self._FailedMsg = params.get("FailedMsg")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UploadIvrAudioRequest(AbstractModel):
    """UploadIvrAudio request structure.

    """

    def __init__(self):
        r"""
        :param _SdkAppId: Application ID (required) can be found at https://console.cloud.tencent.com/ccc.
        :type SdkAppId: int
        :param _AudioList: Audio File List
        :type AudioList: list of UploadAudioInfo
        """
        self._SdkAppId = None
        self._AudioList = None

    @property
    def SdkAppId(self):
        return self._SdkAppId

    @SdkAppId.setter
    def SdkAppId(self, SdkAppId):
        self._SdkAppId = SdkAppId

    @property
    def AudioList(self):
        return self._AudioList

    @AudioList.setter
    def AudioList(self, AudioList):
        self._AudioList = AudioList


    def _deserialize(self, params):
        self._SdkAppId = params.get("SdkAppId")
        if params.get("AudioList") is not None:
            self._AudioList = []
            for item in params.get("AudioList"):
                obj = UploadAudioInfo()
                obj._deserialize(item)
                self._AudioList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UploadIvrAudioResponse(AbstractModel):
    """UploadIvrAudio response structure.

    """

    def __init__(self):
        r"""
        :param _FailedFileList: List of failed uploads
Note: This field may return null, indicating that no valid values can be obtained.
        :type FailedFileList: list of UploadIvrAudioFailedInfo
        :param _SuccessFileList: List of successful uploads
Note: This field may return null, indicating that no valid values can be obtained.
        :type SuccessFileList: list of AudioFileInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FailedFileList = None
        self._SuccessFileList = None
        self._RequestId = None

    @property
    def FailedFileList(self):
        return self._FailedFileList

    @FailedFileList.setter
    def FailedFileList(self, FailedFileList):
        self._FailedFileList = FailedFileList

    @property
    def SuccessFileList(self):
        return self._SuccessFileList

    @SuccessFileList.setter
    def SuccessFileList(self, SuccessFileList):
        self._SuccessFileList = SuccessFileList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("FailedFileList") is not None:
            self._FailedFileList = []
            for item in params.get("FailedFileList"):
                obj = UploadIvrAudioFailedInfo()
                obj._deserialize(item)
                self._FailedFileList.append(obj)
        if params.get("SuccessFileList") is not None:
            self._SuccessFileList = []
            for item in params.get("SuccessFileList"):
                obj = AudioFileInfo()
                obj._deserialize(item)
                self._SuccessFileList.append(obj)
        self._RequestId = params.get("RequestId")


class Variable(AbstractModel):
    """Variable.

    """

    def __init__(self):
        r"""
        :param _Key: Variable name.
        :type Key: str
        :param _Value: Variable value.
        :type Value: str
        """
        self._Key = None
        self._Value = None

    @property
    def Key(self):
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key

    @property
    def Value(self):
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value


    def _deserialize(self, params):
        self._Key = params.get("Key")
        self._Value = params.get("Value")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        