# -*- coding: utf8 -*-
# Copyright (c) 2017-2021 THL A29 Limited, a Tencent company. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class ABTestConfig(AbstractModel):
    """Grayscale project configuration

    """

    def __init__(self):
        r"""
        :param _ProjectName: Greyscale project name
        :type ProjectName: str
        :param _Status: true: grayscale release in progress; false: grayscale release not in progress.
        :type Status: bool
        """
        self._ProjectName = None
        self._Status = None

    @property
    def ProjectName(self):
        return self._ProjectName

    @ProjectName.setter
    def ProjectName(self, ProjectName):
        self._ProjectName = ProjectName

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._ProjectName = params.get("ProjectName")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AccountStatistics(AbstractModel):
    """Account statistics data

    """

    def __init__(self):
        r"""
        :param _Username: Username
        :type Username: str
        :param _MachineNum: Number of hosts
        :type MachineNum: int
        """
        self._Username = None
        self._MachineNum = None

    @property
    def Username(self):
        return self._Username

    @Username.setter
    def Username(self, Username):
        self._Username = Username

    @property
    def MachineNum(self):
        return self._MachineNum

    @MachineNum.setter
    def MachineNum(self, MachineNum):
        self._MachineNum = MachineNum


    def _deserialize(self, params):
        self._Username = params.get("Username")
        self._MachineNum = params.get("MachineNum")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddLoginWhiteListsRequest(AbstractModel):
    """AddLoginWhiteLists request structure.

    """

    def __init__(self):
        r"""
        :param _HostLoginWhiteObj: Cross-region log-in allowlist entity
        :type HostLoginWhiteObj: :class:`tencentcloud.cwp.v20180228.models.HostLoginWhiteObj`
        :param _ProcessType: Synchronous event processing method:
"": do not process"All": add all events that match this configuration to the allowlist"Id": add the event corresponding to the event ID to the allowlist
        :type ProcessType: str
        :param _EventId: Cross-region log-in event ID. This parameter is required when ProcessType is set to Id.
        :type EventId: int
        """
        self._HostLoginWhiteObj = None
        self._ProcessType = None
        self._EventId = None

    @property
    def HostLoginWhiteObj(self):
        return self._HostLoginWhiteObj

    @HostLoginWhiteObj.setter
    def HostLoginWhiteObj(self, HostLoginWhiteObj):
        self._HostLoginWhiteObj = HostLoginWhiteObj

    @property
    def ProcessType(self):
        return self._ProcessType

    @ProcessType.setter
    def ProcessType(self, ProcessType):
        self._ProcessType = ProcessType

    @property
    def EventId(self):
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId


    def _deserialize(self, params):
        if params.get("HostLoginWhiteObj") is not None:
            self._HostLoginWhiteObj = HostLoginWhiteObj()
            self._HostLoginWhiteObj._deserialize(params.get("HostLoginWhiteObj"))
        self._ProcessType = params.get("ProcessType")
        self._EventId = params.get("EventId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddLoginWhiteListsResponse(AbstractModel):
    """AddLoginWhiteLists response structure.

    """

    def __init__(self):
        r"""
        :param _DuplicateHosts: Prompt list of duplicate addition
Note: This field may return null, indicating that no valid values can be obtained.
        :type DuplicateHosts: list of DuplicateHosts
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DuplicateHosts = None
        self._RequestId = None

    @property
    def DuplicateHosts(self):
        return self._DuplicateHosts

    @DuplicateHosts.setter
    def DuplicateHosts(self, DuplicateHosts):
        self._DuplicateHosts = DuplicateHosts

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DuplicateHosts") is not None:
            self._DuplicateHosts = []
            for item in params.get("DuplicateHosts"):
                obj = DuplicateHosts()
                obj._deserialize(item)
                self._DuplicateHosts.append(obj)
        self._RequestId = params.get("RequestId")


class AlarmInfo(AbstractModel):
    """Information on alarms associated with the node

    """

    def __init__(self):
        r"""
        :param _AlarmId: Table names of IDs of alarms associated with the node. Separate multiple pairs with commas. Example: t1:id1,t2:id2
        :type AlarmId: str
        :param _Status: Alarm status. This parameter takes effect when this node is an alarm node.
        :type Status: int
        """
        self._AlarmId = None
        self._Status = None

    @property
    def AlarmId(self):
        return self._AlarmId

    @AlarmId.setter
    def AlarmId(self, AlarmId):
        self._AlarmId = AlarmId

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._AlarmId = params.get("AlarmId")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetAppBaseInfo(AbstractModel):
    """Basic information on the resource management process

    """

    def __init__(self):
        r"""
        :param _MachineIp: Host private IP address
        :type MachineIp: str
        :param _MachineName: Host name
        :type MachineName: str
        :param _MachineWanIp: Host public IP address
        :type MachineWanIp: str
        :param _Uuid: Host UUID
        :type Uuid: str
        :param _Quuid: Host QUUID
        :type Quuid: str
        :param _ProjectId: Host business group ID
        :type ProjectId: int
        :param _Tag: Host tag
Note: This field may return null, indicating that no valid values can be obtained.
        :type Tag: list of MachineTag
        :param _Name: Application name
        :type Name: str
        :param _Type: Application type	
1: operations
2: database
3: Security
4: suspicious application
5: system architecture
6: system application
7: web service
99: other
        :type Type: int
        :param _BinPath: Binary path
        :type BinPath: str
        :param _OsInfo: Operating System Information
        :type OsInfo: str
        :param _ProcessCount: Number of associated processes
        :type ProcessCount: int
        :param _Desc: Application description
        :type Desc: str
        :param _Version: Version No.
        :type Version: str
        :param _ConfigPath: Configuration file path
        :type ConfigPath: str
        :param _FirstTime: First collection time
        :type FirstTime: str
        :param _UpdateTime: Data update time
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateTime: str
        :param _IsNew: Whether the web service is newly added [0: no|1: yes]
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsNew: int
        :param _MachineExtraInfo: Additional information
Note: This field may return null, indicating that no valid values can be obtained.
        :type MachineExtraInfo: :class:`tencentcloud.cwp.v20180228.models.MachineExtraInfo`
        """
        self._MachineIp = None
        self._MachineName = None
        self._MachineWanIp = None
        self._Uuid = None
        self._Quuid = None
        self._ProjectId = None
        self._Tag = None
        self._Name = None
        self._Type = None
        self._BinPath = None
        self._OsInfo = None
        self._ProcessCount = None
        self._Desc = None
        self._Version = None
        self._ConfigPath = None
        self._FirstTime = None
        self._UpdateTime = None
        self._IsNew = None
        self._MachineExtraInfo = None

    @property
    def MachineIp(self):
        return self._MachineIp

    @MachineIp.setter
    def MachineIp(self, MachineIp):
        self._MachineIp = MachineIp

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def MachineWanIp(self):
        return self._MachineWanIp

    @MachineWanIp.setter
    def MachineWanIp(self, MachineWanIp):
        self._MachineWanIp = MachineWanIp

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Tag(self):
        return self._Tag

    @Tag.setter
    def Tag(self, Tag):
        self._Tag = Tag

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def BinPath(self):
        return self._BinPath

    @BinPath.setter
    def BinPath(self, BinPath):
        self._BinPath = BinPath

    @property
    def OsInfo(self):
        return self._OsInfo

    @OsInfo.setter
    def OsInfo(self, OsInfo):
        self._OsInfo = OsInfo

    @property
    def ProcessCount(self):
        return self._ProcessCount

    @ProcessCount.setter
    def ProcessCount(self, ProcessCount):
        self._ProcessCount = ProcessCount

    @property
    def Desc(self):
        return self._Desc

    @Desc.setter
    def Desc(self, Desc):
        self._Desc = Desc

    @property
    def Version(self):
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def ConfigPath(self):
        return self._ConfigPath

    @ConfigPath.setter
    def ConfigPath(self, ConfigPath):
        self._ConfigPath = ConfigPath

    @property
    def FirstTime(self):
        return self._FirstTime

    @FirstTime.setter
    def FirstTime(self, FirstTime):
        self._FirstTime = FirstTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def IsNew(self):
        return self._IsNew

    @IsNew.setter
    def IsNew(self, IsNew):
        self._IsNew = IsNew

    @property
    def MachineExtraInfo(self):
        return self._MachineExtraInfo

    @MachineExtraInfo.setter
    def MachineExtraInfo(self, MachineExtraInfo):
        self._MachineExtraInfo = MachineExtraInfo


    def _deserialize(self, params):
        self._MachineIp = params.get("MachineIp")
        self._MachineName = params.get("MachineName")
        self._MachineWanIp = params.get("MachineWanIp")
        self._Uuid = params.get("Uuid")
        self._Quuid = params.get("Quuid")
        self._ProjectId = params.get("ProjectId")
        if params.get("Tag") is not None:
            self._Tag = []
            for item in params.get("Tag"):
                obj = MachineTag()
                obj._deserialize(item)
                self._Tag.append(obj)
        self._Name = params.get("Name")
        self._Type = params.get("Type")
        self._BinPath = params.get("BinPath")
        self._OsInfo = params.get("OsInfo")
        self._ProcessCount = params.get("ProcessCount")
        self._Desc = params.get("Desc")
        self._Version = params.get("Version")
        self._ConfigPath = params.get("ConfigPath")
        self._FirstTime = params.get("FirstTime")
        self._UpdateTime = params.get("UpdateTime")
        self._IsNew = params.get("IsNew")
        if params.get("MachineExtraInfo") is not None:
            self._MachineExtraInfo = MachineExtraInfo()
            self._MachineExtraInfo._deserialize(params.get("MachineExtraInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetAppProcessInfo(AbstractModel):
    """Software application-related process information

    """

    def __init__(self):
        r"""
        :param _Name: Name
        :type Name: str
        :param _Status: Process status
        :type Status: str
        :param _Version: Process version
        :type Version: str
        :param _Path: Path
        :type Path: str
        :param _User: User
        :type User: str
        :param _StartTime: Startup time
        :type StartTime: str
        """
        self._Name = None
        self._Status = None
        self._Version = None
        self._Path = None
        self._User = None
        self._StartTime = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Version(self):
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def Path(self):
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def User(self):
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Status = params.get("Status")
        self._Version = params.get("Version")
        self._Path = params.get("Path")
        self._User = params.get("User")
        self._StartTime = params.get("StartTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetCoreModuleBaseInfo(AbstractModel):
    """List of information on the asset management kernel module

    """

    def __init__(self):
        r"""
        :param _Name: Name
        :type Name: str
        :param _Desc: Description
        :type Desc: str
        :param _Path: Path
        :type Path: str
        :param _Version: Version
        :type Version: str
        :param _MachineIp: Server IP
        :type MachineIp: str
        :param _MachineName: Server name
        :type MachineName: str
        :param _OsInfo: Operating system
        :type OsInfo: str
        :param _Size: Module size
        :type Size: int
        :param _ProcessCount: Number of dependent processes
        :type ProcessCount: int
        :param _ModuleCount: Number of dependent modules
        :type ModuleCount: int
        :param _Id: Module ID
        :type Id: str
        :param _Quuid: Host QUUID
        :type Quuid: str
        :param _Uuid: Host UUID
        :type Uuid: str
        :param _UpdateTime: Data update time
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateTime: str
        :param _FirstTime: First collection time
        :type FirstTime: str
        :param _IsNew: Whether new [0: no|1: yes]
        :type IsNew: int
        :param _MachineWanIp: Server Public IP
        :type MachineWanIp: str
        :param _MachineExtraInfo: Additional information
Note: This field may return null, indicating that no valid values can be obtained.
        :type MachineExtraInfo: :class:`tencentcloud.cwp.v20180228.models.MachineExtraInfo`
        """
        self._Name = None
        self._Desc = None
        self._Path = None
        self._Version = None
        self._MachineIp = None
        self._MachineName = None
        self._OsInfo = None
        self._Size = None
        self._ProcessCount = None
        self._ModuleCount = None
        self._Id = None
        self._Quuid = None
        self._Uuid = None
        self._UpdateTime = None
        self._FirstTime = None
        self._IsNew = None
        self._MachineWanIp = None
        self._MachineExtraInfo = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Desc(self):
        return self._Desc

    @Desc.setter
    def Desc(self, Desc):
        self._Desc = Desc

    @property
    def Path(self):
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def Version(self):
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def MachineIp(self):
        return self._MachineIp

    @MachineIp.setter
    def MachineIp(self, MachineIp):
        self._MachineIp = MachineIp

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def OsInfo(self):
        return self._OsInfo

    @OsInfo.setter
    def OsInfo(self, OsInfo):
        self._OsInfo = OsInfo

    @property
    def Size(self):
        return self._Size

    @Size.setter
    def Size(self, Size):
        self._Size = Size

    @property
    def ProcessCount(self):
        return self._ProcessCount

    @ProcessCount.setter
    def ProcessCount(self, ProcessCount):
        self._ProcessCount = ProcessCount

    @property
    def ModuleCount(self):
        return self._ModuleCount

    @ModuleCount.setter
    def ModuleCount(self, ModuleCount):
        self._ModuleCount = ModuleCount

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def FirstTime(self):
        return self._FirstTime

    @FirstTime.setter
    def FirstTime(self, FirstTime):
        self._FirstTime = FirstTime

    @property
    def IsNew(self):
        return self._IsNew

    @IsNew.setter
    def IsNew(self, IsNew):
        self._IsNew = IsNew

    @property
    def MachineWanIp(self):
        return self._MachineWanIp

    @MachineWanIp.setter
    def MachineWanIp(self, MachineWanIp):
        self._MachineWanIp = MachineWanIp

    @property
    def MachineExtraInfo(self):
        return self._MachineExtraInfo

    @MachineExtraInfo.setter
    def MachineExtraInfo(self, MachineExtraInfo):
        self._MachineExtraInfo = MachineExtraInfo


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Desc = params.get("Desc")
        self._Path = params.get("Path")
        self._Version = params.get("Version")
        self._MachineIp = params.get("MachineIp")
        self._MachineName = params.get("MachineName")
        self._OsInfo = params.get("OsInfo")
        self._Size = params.get("Size")
        self._ProcessCount = params.get("ProcessCount")
        self._ModuleCount = params.get("ModuleCount")
        self._Id = params.get("Id")
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._UpdateTime = params.get("UpdateTime")
        self._FirstTime = params.get("FirstTime")
        self._IsNew = params.get("IsNew")
        self._MachineWanIp = params.get("MachineWanIp")
        if params.get("MachineExtraInfo") is not None:
            self._MachineExtraInfo = MachineExtraInfo()
            self._MachineExtraInfo._deserialize(params.get("MachineExtraInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetCoreModuleDetail(AbstractModel):
    """Details of the asset management kernel module

    """

    def __init__(self):
        r"""
        :param _Name: Name
        :type Name: str
        :param _Desc: Description
        :type Desc: str
        :param _Path: Path
        :type Path: str
        :param _Version: Version
        :type Version: str
        :param _Size: Size
        :type Size: int
        :param _Processes: Dependent processes
        :type Processes: str
        :param _Modules: Dependent modules
        :type Modules: str
        :param _Params: Parameter information
Note: This field may return null, indicating that no valid values can be obtained.
        :type Params: list of AssetCoreModuleParam
        :param _UpdateTime: Data update time
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateTime: str
        """
        self._Name = None
        self._Desc = None
        self._Path = None
        self._Version = None
        self._Size = None
        self._Processes = None
        self._Modules = None
        self._Params = None
        self._UpdateTime = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Desc(self):
        return self._Desc

    @Desc.setter
    def Desc(self, Desc):
        self._Desc = Desc

    @property
    def Path(self):
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def Version(self):
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def Size(self):
        return self._Size

    @Size.setter
    def Size(self, Size):
        self._Size = Size

    @property
    def Processes(self):
        return self._Processes

    @Processes.setter
    def Processes(self, Processes):
        self._Processes = Processes

    @property
    def Modules(self):
        return self._Modules

    @Modules.setter
    def Modules(self, Modules):
        self._Modules = Modules

    @property
    def Params(self):
        return self._Params

    @Params.setter
    def Params(self, Params):
        self._Params = Params

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Desc = params.get("Desc")
        self._Path = params.get("Path")
        self._Version = params.get("Version")
        self._Size = params.get("Size")
        self._Processes = params.get("Processes")
        self._Modules = params.get("Modules")
        if params.get("Params") is not None:
            self._Params = []
            for item in params.get("Params"):
                obj = AssetCoreModuleParam()
                obj._deserialize(item)
                self._Params.append(obj)
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetCoreModuleParam(AbstractModel):
    """Parameters of the asset management kernel module

    """

    def __init__(self):
        r"""
        :param _Name: Name
        :type Name: str
        :param _Data: Data
        :type Data: str
        """
        self._Name = None
        self._Data = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Data = params.get("Data")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetDatabaseBaseInfo(AbstractModel):
    """Resource management database list information

    """

    def __init__(self):
        r"""
        :param _MachineIp: Host private IP address
        :type MachineIp: str
        :param _MachineWanIp: Host public IP address
        :type MachineWanIp: str
        :param _Quuid: Host QUUID
        :type Quuid: str
        :param _Uuid: Host UUID
        :type Uuid: str
        :param _OsInfo: Operating System Information
        :type OsInfo: str
        :param _ProjectId: Host business group ID
        :type ProjectId: int
        :param _Tag: Host tag
Note: This field may return null, indicating that no valid values can be obtained.
        :type Tag: list of MachineTag
        :param _Name: Database name
        :type Name: str
        :param _Version: Version
        :type Version: str
        :param _Port: Listening port
        :type Port: str
        :param _Proto: Protocol
        :type Proto: str
        :param _User: Running user
        :type User: str
        :param _Ip: Bound IP
        :type Ip: str
        :param _ConfigPath: Configuration file path
        :type ConfigPath: str
        :param _LogPath: Log file path
        :type LogPath: str
        :param _DataPath: Data path
        :type DataPath: str
        :param _Permission: Running permission
        :type Permission: str
        :param _ErrorLogPath: Error log path
        :type ErrorLogPath: str
        :param _PlugInPath: Plugin path
        :type PlugInPath: str
        :param _BinPath: Binary path
        :type BinPath: str
        :param _Param: Startup parameter
        :type Param: str
        :param _Id: Database ID
        :type Id: str
        :param _UpdateTime: Data update time
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateTime: str
        :param _FirstTime: First collection time
        :type FirstTime: str
        :param _IsNew: Whether newly added [0: no|1: yes]
        :type IsNew: int
        :param _MachineName: Host name
        :type MachineName: str
        :param _MachineExtraInfo: Additional information
Note: This field may return null, indicating that no valid values can be obtained.
        :type MachineExtraInfo: :class:`tencentcloud.cwp.v20180228.models.MachineExtraInfo`
        """
        self._MachineIp = None
        self._MachineWanIp = None
        self._Quuid = None
        self._Uuid = None
        self._OsInfo = None
        self._ProjectId = None
        self._Tag = None
        self._Name = None
        self._Version = None
        self._Port = None
        self._Proto = None
        self._User = None
        self._Ip = None
        self._ConfigPath = None
        self._LogPath = None
        self._DataPath = None
        self._Permission = None
        self._ErrorLogPath = None
        self._PlugInPath = None
        self._BinPath = None
        self._Param = None
        self._Id = None
        self._UpdateTime = None
        self._FirstTime = None
        self._IsNew = None
        self._MachineName = None
        self._MachineExtraInfo = None

    @property
    def MachineIp(self):
        return self._MachineIp

    @MachineIp.setter
    def MachineIp(self, MachineIp):
        self._MachineIp = MachineIp

    @property
    def MachineWanIp(self):
        return self._MachineWanIp

    @MachineWanIp.setter
    def MachineWanIp(self, MachineWanIp):
        self._MachineWanIp = MachineWanIp

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def OsInfo(self):
        return self._OsInfo

    @OsInfo.setter
    def OsInfo(self, OsInfo):
        self._OsInfo = OsInfo

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Tag(self):
        return self._Tag

    @Tag.setter
    def Tag(self, Tag):
        self._Tag = Tag

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Version(self):
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def Port(self):
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def Proto(self):
        return self._Proto

    @Proto.setter
    def Proto(self, Proto):
        self._Proto = Proto

    @property
    def User(self):
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def Ip(self):
        return self._Ip

    @Ip.setter
    def Ip(self, Ip):
        self._Ip = Ip

    @property
    def ConfigPath(self):
        return self._ConfigPath

    @ConfigPath.setter
    def ConfigPath(self, ConfigPath):
        self._ConfigPath = ConfigPath

    @property
    def LogPath(self):
        return self._LogPath

    @LogPath.setter
    def LogPath(self, LogPath):
        self._LogPath = LogPath

    @property
    def DataPath(self):
        return self._DataPath

    @DataPath.setter
    def DataPath(self, DataPath):
        self._DataPath = DataPath

    @property
    def Permission(self):
        return self._Permission

    @Permission.setter
    def Permission(self, Permission):
        self._Permission = Permission

    @property
    def ErrorLogPath(self):
        return self._ErrorLogPath

    @ErrorLogPath.setter
    def ErrorLogPath(self, ErrorLogPath):
        self._ErrorLogPath = ErrorLogPath

    @property
    def PlugInPath(self):
        return self._PlugInPath

    @PlugInPath.setter
    def PlugInPath(self, PlugInPath):
        self._PlugInPath = PlugInPath

    @property
    def BinPath(self):
        return self._BinPath

    @BinPath.setter
    def BinPath(self, BinPath):
        self._BinPath = BinPath

    @property
    def Param(self):
        return self._Param

    @Param.setter
    def Param(self, Param):
        self._Param = Param

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def FirstTime(self):
        return self._FirstTime

    @FirstTime.setter
    def FirstTime(self, FirstTime):
        self._FirstTime = FirstTime

    @property
    def IsNew(self):
        return self._IsNew

    @IsNew.setter
    def IsNew(self, IsNew):
        self._IsNew = IsNew

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def MachineExtraInfo(self):
        return self._MachineExtraInfo

    @MachineExtraInfo.setter
    def MachineExtraInfo(self, MachineExtraInfo):
        self._MachineExtraInfo = MachineExtraInfo


    def _deserialize(self, params):
        self._MachineIp = params.get("MachineIp")
        self._MachineWanIp = params.get("MachineWanIp")
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._OsInfo = params.get("OsInfo")
        self._ProjectId = params.get("ProjectId")
        if params.get("Tag") is not None:
            self._Tag = []
            for item in params.get("Tag"):
                obj = MachineTag()
                obj._deserialize(item)
                self._Tag.append(obj)
        self._Name = params.get("Name")
        self._Version = params.get("Version")
        self._Port = params.get("Port")
        self._Proto = params.get("Proto")
        self._User = params.get("User")
        self._Ip = params.get("Ip")
        self._ConfigPath = params.get("ConfigPath")
        self._LogPath = params.get("LogPath")
        self._DataPath = params.get("DataPath")
        self._Permission = params.get("Permission")
        self._ErrorLogPath = params.get("ErrorLogPath")
        self._PlugInPath = params.get("PlugInPath")
        self._BinPath = params.get("BinPath")
        self._Param = params.get("Param")
        self._Id = params.get("Id")
        self._UpdateTime = params.get("UpdateTime")
        self._FirstTime = params.get("FirstTime")
        self._IsNew = params.get("IsNew")
        self._MachineName = params.get("MachineName")
        if params.get("MachineExtraInfo") is not None:
            self._MachineExtraInfo = MachineExtraInfo()
            self._MachineExtraInfo._deserialize(params.get("MachineExtraInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetDatabaseDetail(AbstractModel):
    """Resource management database list information

    """

    def __init__(self):
        r"""
        :param _MachineIp: Host private IP address
        :type MachineIp: str
        :param _MachineWanIp: Host public IP address
        :type MachineWanIp: str
        :param _Quuid: Host QUUID
        :type Quuid: str
        :param _Uuid: Host UUID
        :type Uuid: str
        :param _OsInfo: Operating System Information
        :type OsInfo: str
        :param _Name: Database name
        :type Name: str
        :param _Version: Version
        :type Version: str
        :param _Port: Listening port
        :type Port: str
        :param _Proto: Protocol
        :type Proto: str
        :param _User: Running user
        :type User: str
        :param _Ip: Bind IP
        :type Ip: str
        :param _ConfigPath: Configuration file path
        :type ConfigPath: str
        :param _LogPath: Log file path
        :type LogPath: str
        :param _DataPath: Data path
        :type DataPath: str
        :param _Permission: Running permission
        :type Permission: str
        :param _ErrorLogPath: Error log path
        :type ErrorLogPath: str
        :param _PlugInPath: Plugin path
        :type PlugInPath: str
        :param _BinPath: Binary path
        :type BinPath: str
        :param _Param: Startup parameter
        :type Param: str
        :param _UpdateTime: Data update time
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateTime: str
        """
        self._MachineIp = None
        self._MachineWanIp = None
        self._Quuid = None
        self._Uuid = None
        self._OsInfo = None
        self._Name = None
        self._Version = None
        self._Port = None
        self._Proto = None
        self._User = None
        self._Ip = None
        self._ConfigPath = None
        self._LogPath = None
        self._DataPath = None
        self._Permission = None
        self._ErrorLogPath = None
        self._PlugInPath = None
        self._BinPath = None
        self._Param = None
        self._UpdateTime = None

    @property
    def MachineIp(self):
        return self._MachineIp

    @MachineIp.setter
    def MachineIp(self, MachineIp):
        self._MachineIp = MachineIp

    @property
    def MachineWanIp(self):
        return self._MachineWanIp

    @MachineWanIp.setter
    def MachineWanIp(self, MachineWanIp):
        self._MachineWanIp = MachineWanIp

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def OsInfo(self):
        return self._OsInfo

    @OsInfo.setter
    def OsInfo(self, OsInfo):
        self._OsInfo = OsInfo

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Version(self):
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def Port(self):
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def Proto(self):
        return self._Proto

    @Proto.setter
    def Proto(self, Proto):
        self._Proto = Proto

    @property
    def User(self):
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def Ip(self):
        return self._Ip

    @Ip.setter
    def Ip(self, Ip):
        self._Ip = Ip

    @property
    def ConfigPath(self):
        return self._ConfigPath

    @ConfigPath.setter
    def ConfigPath(self, ConfigPath):
        self._ConfigPath = ConfigPath

    @property
    def LogPath(self):
        return self._LogPath

    @LogPath.setter
    def LogPath(self, LogPath):
        self._LogPath = LogPath

    @property
    def DataPath(self):
        return self._DataPath

    @DataPath.setter
    def DataPath(self, DataPath):
        self._DataPath = DataPath

    @property
    def Permission(self):
        return self._Permission

    @Permission.setter
    def Permission(self, Permission):
        self._Permission = Permission

    @property
    def ErrorLogPath(self):
        return self._ErrorLogPath

    @ErrorLogPath.setter
    def ErrorLogPath(self, ErrorLogPath):
        self._ErrorLogPath = ErrorLogPath

    @property
    def PlugInPath(self):
        return self._PlugInPath

    @PlugInPath.setter
    def PlugInPath(self, PlugInPath):
        self._PlugInPath = PlugInPath

    @property
    def BinPath(self):
        return self._BinPath

    @BinPath.setter
    def BinPath(self, BinPath):
        self._BinPath = BinPath

    @property
    def Param(self):
        return self._Param

    @Param.setter
    def Param(self, Param):
        self._Param = Param

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._MachineIp = params.get("MachineIp")
        self._MachineWanIp = params.get("MachineWanIp")
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._OsInfo = params.get("OsInfo")
        self._Name = params.get("Name")
        self._Version = params.get("Version")
        self._Port = params.get("Port")
        self._Proto = params.get("Proto")
        self._User = params.get("User")
        self._Ip = params.get("Ip")
        self._ConfigPath = params.get("ConfigPath")
        self._LogPath = params.get("LogPath")
        self._DataPath = params.get("DataPath")
        self._Permission = params.get("Permission")
        self._ErrorLogPath = params.get("ErrorLogPath")
        self._PlugInPath = params.get("PlugInPath")
        self._BinPath = params.get("BinPath")
        self._Param = params.get("Param")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetDiskPartitionInfo(AbstractModel):
    """Asset management disk partition information

    """

    def __init__(self):
        r"""
        :param _Name: Partition name
        :type Name: str
        :param _Size: Partition size (unit: G)
        :type Size: int
        :param _Percent: Partition utilization
        :type Percent: float
        :param _Type: File system type
        :type Type: str
        :param _Path: Mounting directory
        :type Path: str
        :param _Used: Used space (unit: G)
        :type Used: int
        """
        self._Name = None
        self._Size = None
        self._Percent = None
        self._Type = None
        self._Path = None
        self._Used = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Size(self):
        return self._Size

    @Size.setter
    def Size(self, Size):
        self._Size = Size

    @property
    def Percent(self):
        return self._Percent

    @Percent.setter
    def Percent(self, Percent):
        self._Percent = Percent

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Path(self):
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def Used(self):
        return self._Used

    @Used.setter
    def Used(self, Used):
        self._Used = Used


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Size = params.get("Size")
        self._Percent = params.get("Percent")
        self._Type = params.get("Type")
        self._Path = params.get("Path")
        self._Used = params.get("Used")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetEnvBaseInfo(AbstractModel):
    """List of asset management environment variables

    """

    def __init__(self):
        r"""
        :param _Name: Name
        :type Name: str
        :param _Type: Type:
0: user variable
1: system variable
        :type Type: int
        :param _User: Startup user
        :type User: str
        :param _Value: Environment variable value
        :type Value: str
        :param _MachineIp: Server IP
        :type MachineIp: str
        :param _MachineName: Server name
        :type MachineName: str
        :param _OsInfo: Operating system
        :type OsInfo: str
        :param _Quuid: Host QUUID
        :type Quuid: str
        :param _Uuid: Host UUID
        :type Uuid: str
        :param _UpdateTime: Data update time
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateTime: str
        :param _FirstTime: First collection time
        :type FirstTime: str
        :param _IsNew: Whether new [0: no|1: yes]
        :type IsNew: int
        :param _MachineWanIp: Server Public IP
        :type MachineWanIp: str
        :param _MachineExtraInfo: Additional information

Note: This field may return null, indicating that no valid values can be obtained.
        :type MachineExtraInfo: :class:`tencentcloud.cwp.v20180228.models.MachineExtraInfo`
        """
        self._Name = None
        self._Type = None
        self._User = None
        self._Value = None
        self._MachineIp = None
        self._MachineName = None
        self._OsInfo = None
        self._Quuid = None
        self._Uuid = None
        self._UpdateTime = None
        self._FirstTime = None
        self._IsNew = None
        self._MachineWanIp = None
        self._MachineExtraInfo = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def User(self):
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def Value(self):
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value

    @property
    def MachineIp(self):
        return self._MachineIp

    @MachineIp.setter
    def MachineIp(self, MachineIp):
        self._MachineIp = MachineIp

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def OsInfo(self):
        return self._OsInfo

    @OsInfo.setter
    def OsInfo(self, OsInfo):
        self._OsInfo = OsInfo

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def FirstTime(self):
        return self._FirstTime

    @FirstTime.setter
    def FirstTime(self, FirstTime):
        self._FirstTime = FirstTime

    @property
    def IsNew(self):
        return self._IsNew

    @IsNew.setter
    def IsNew(self, IsNew):
        self._IsNew = IsNew

    @property
    def MachineWanIp(self):
        return self._MachineWanIp

    @MachineWanIp.setter
    def MachineWanIp(self, MachineWanIp):
        self._MachineWanIp = MachineWanIp

    @property
    def MachineExtraInfo(self):
        return self._MachineExtraInfo

    @MachineExtraInfo.setter
    def MachineExtraInfo(self, MachineExtraInfo):
        self._MachineExtraInfo = MachineExtraInfo


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Type = params.get("Type")
        self._User = params.get("User")
        self._Value = params.get("Value")
        self._MachineIp = params.get("MachineIp")
        self._MachineName = params.get("MachineName")
        self._OsInfo = params.get("OsInfo")
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._UpdateTime = params.get("UpdateTime")
        self._FirstTime = params.get("FirstTime")
        self._IsNew = params.get("IsNew")
        self._MachineWanIp = params.get("MachineWanIp")
        if params.get("MachineExtraInfo") is not None:
            self._MachineExtraInfo = MachineExtraInfo()
            self._MachineExtraInfo._deserialize(params.get("MachineExtraInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetFilters(AbstractModel):
    """Container security
    Description key-value pair filter, which is used for conditional filtering queries. For example, filter by ID, name, and status.
    If there are multiple Filters, the logical relationship between them is AND.
    If there are multiple Values in the same Filter, the logical relationship between the Values under the same Filter is OR.

    """

    def __init__(self):
        r"""
        :param _Name: Name of filter key
        :type Name: str
        :param _Values: One or more filter values
        :type Values: list of str
        :param _ExactMatch: Whether to use fuzzy query
        :type ExactMatch: bool
        """
        self._Name = None
        self._Values = None
        self._ExactMatch = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Values(self):
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values

    @property
    def ExactMatch(self):
        return self._ExactMatch

    @ExactMatch.setter
    def ExactMatch(self, ExactMatch):
        self._ExactMatch = ExactMatch


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Values = params.get("Values")
        self._ExactMatch = params.get("ExactMatch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetInitServiceBaseInfo(AbstractModel):
    """List of asset management startup services

    """

    def __init__(self):
        r"""
        :param _Name: Name
        :type Name: str
        :param _Type: Type:
1: Encoder
2: IE plugin
3: Network provider
4: Mirror hijacking
5: LSA provider
6:KnownDLLs
7: Start execution
8:WMI
9: Scheduled task
10: Winsock provider
11: Print monitor
12: Resource manager
13: Driver service
14: Log-in
        :type Type: int
        :param _Status: Default enabling status: 0 - disabled; 1 - enabled
        :type Status: int
        :param _User: Startup user
        :type User: str
        :param _Path: Path
        :type Path: str
        :param _MachineIp: Server IP
        :type MachineIp: str
        :param _MachineName: Name
        :type MachineName: str
        :param _OsInfo: Operating system
        :type OsInfo: str
        :param _Quuid: Host QUUID
        :type Quuid: str
        :param _Uuid: Host UUID
        :type Uuid: str
        :param _UpdateTime: Data update time
        :type UpdateTime: str
        :param _FirstTime: First collection time
        :type FirstTime: str
        :param _IsNew: Whether newly added [0: no|1: yes]
        :type IsNew: int
        :param _MachineWanIp: Server Public IP
        :type MachineWanIp: str
        :param _MachineExtraInfo: Additional information

Note: This field may return null, indicating that no valid values can be obtained.
        :type MachineExtraInfo: :class:`tencentcloud.cwp.v20180228.models.MachineExtraInfo`
        :param _IsAutoRun: Start at boot [0: No|1: Yes]
        :type IsAutoRun: int
        """
        self._Name = None
        self._Type = None
        self._Status = None
        self._User = None
        self._Path = None
        self._MachineIp = None
        self._MachineName = None
        self._OsInfo = None
        self._Quuid = None
        self._Uuid = None
        self._UpdateTime = None
        self._FirstTime = None
        self._IsNew = None
        self._MachineWanIp = None
        self._MachineExtraInfo = None
        self._IsAutoRun = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def User(self):
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def Path(self):
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def MachineIp(self):
        return self._MachineIp

    @MachineIp.setter
    def MachineIp(self, MachineIp):
        self._MachineIp = MachineIp

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def OsInfo(self):
        return self._OsInfo

    @OsInfo.setter
    def OsInfo(self, OsInfo):
        self._OsInfo = OsInfo

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def FirstTime(self):
        return self._FirstTime

    @FirstTime.setter
    def FirstTime(self, FirstTime):
        self._FirstTime = FirstTime

    @property
    def IsNew(self):
        return self._IsNew

    @IsNew.setter
    def IsNew(self, IsNew):
        self._IsNew = IsNew

    @property
    def MachineWanIp(self):
        return self._MachineWanIp

    @MachineWanIp.setter
    def MachineWanIp(self, MachineWanIp):
        self._MachineWanIp = MachineWanIp

    @property
    def MachineExtraInfo(self):
        return self._MachineExtraInfo

    @MachineExtraInfo.setter
    def MachineExtraInfo(self, MachineExtraInfo):
        self._MachineExtraInfo = MachineExtraInfo

    @property
    def IsAutoRun(self):
        return self._IsAutoRun

    @IsAutoRun.setter
    def IsAutoRun(self, IsAutoRun):
        self._IsAutoRun = IsAutoRun


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Type = params.get("Type")
        self._Status = params.get("Status")
        self._User = params.get("User")
        self._Path = params.get("Path")
        self._MachineIp = params.get("MachineIp")
        self._MachineName = params.get("MachineName")
        self._OsInfo = params.get("OsInfo")
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._UpdateTime = params.get("UpdateTime")
        self._FirstTime = params.get("FirstTime")
        self._IsNew = params.get("IsNew")
        self._MachineWanIp = params.get("MachineWanIp")
        if params.get("MachineExtraInfo") is not None:
            self._MachineExtraInfo = MachineExtraInfo()
            self._MachineExtraInfo._deserialize(params.get("MachineExtraInfo"))
        self._IsAutoRun = params.get("IsAutoRun")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetJarBaseInfo(AbstractModel):
    """List of asset management JAR packages

    """

    def __init__(self):
        r"""
        :param _Name: Name
        :type Name: str
        :param _Type: Type. 1: application; 2: system class library; 3: web service built-in library; 8: others.
        :type Type: int
        :param _Status: Whether it is executable. 0: unknown; 1: yes; 2: no.
        :type Status: int
        :param _Version: Version
        :type Version: str
        :param _Path: Path
        :type Path: str
        :param _MachineIp: Server IP address
        :type MachineIp: str
        :param _MachineName: Server name
        :type MachineName: str
        :param _OsInfo: Operating system
        :type OsInfo: str
        :param _Id: JAR package ID
        :type Id: str
        :param _Md5: JAR package Md5
        :type Md5: str
        :param _Quuid: Host QUUID
        :type Quuid: str
        :param _Uuid: Host UUID
        :type Uuid: str
        :param _UpdateTime: Data update time
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateTime: str
        :param _FirstTime: First collection time
        :type FirstTime: str
        :param _IsNew: Whether it is newly added [0: no | 1: yes]
        :type IsNew: int
        :param _MachineWanIp: Server public IP
        :type MachineWanIp: str
        :param _MachineExtraInfo: Additional information

Note: This field may return null, indicating that no valid values can be obtained.
        :type MachineExtraInfo: :class:`tencentcloud.cwp.v20180228.models.MachineExtraInfo`
        """
        self._Name = None
        self._Type = None
        self._Status = None
        self._Version = None
        self._Path = None
        self._MachineIp = None
        self._MachineName = None
        self._OsInfo = None
        self._Id = None
        self._Md5 = None
        self._Quuid = None
        self._Uuid = None
        self._UpdateTime = None
        self._FirstTime = None
        self._IsNew = None
        self._MachineWanIp = None
        self._MachineExtraInfo = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Version(self):
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def Path(self):
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def MachineIp(self):
        return self._MachineIp

    @MachineIp.setter
    def MachineIp(self, MachineIp):
        self._MachineIp = MachineIp

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def OsInfo(self):
        return self._OsInfo

    @OsInfo.setter
    def OsInfo(self, OsInfo):
        self._OsInfo = OsInfo

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Md5(self):
        return self._Md5

    @Md5.setter
    def Md5(self, Md5):
        self._Md5 = Md5

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def FirstTime(self):
        return self._FirstTime

    @FirstTime.setter
    def FirstTime(self, FirstTime):
        self._FirstTime = FirstTime

    @property
    def IsNew(self):
        return self._IsNew

    @IsNew.setter
    def IsNew(self, IsNew):
        self._IsNew = IsNew

    @property
    def MachineWanIp(self):
        return self._MachineWanIp

    @MachineWanIp.setter
    def MachineWanIp(self, MachineWanIp):
        self._MachineWanIp = MachineWanIp

    @property
    def MachineExtraInfo(self):
        return self._MachineExtraInfo

    @MachineExtraInfo.setter
    def MachineExtraInfo(self, MachineExtraInfo):
        self._MachineExtraInfo = MachineExtraInfo


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Type = params.get("Type")
        self._Status = params.get("Status")
        self._Version = params.get("Version")
        self._Path = params.get("Path")
        self._MachineIp = params.get("MachineIp")
        self._MachineName = params.get("MachineName")
        self._OsInfo = params.get("OsInfo")
        self._Id = params.get("Id")
        self._Md5 = params.get("Md5")
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._UpdateTime = params.get("UpdateTime")
        self._FirstTime = params.get("FirstTime")
        self._IsNew = params.get("IsNew")
        self._MachineWanIp = params.get("MachineWanIp")
        if params.get("MachineExtraInfo") is not None:
            self._MachineExtraInfo = MachineExtraInfo()
            self._MachineExtraInfo._deserialize(params.get("MachineExtraInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetJarDetail(AbstractModel):
    """Asset management jar package details

    """

    def __init__(self):
        r"""
        :param _Name: Name
        :type Name: str
        :param _Type: Type: 1: application; 2: system library; 3: Web service built-in library; 8: other
        :type Type: int
        :param _Status: Whether executable: 0: unknown; 1: yes; 2: no
        :type Status: int
        :param _Version: Version
        :type Version: str
        :param _Path: Path
        :type Path: str
        :param _MachineIp: Server IP
        :type MachineIp: str
        :param _MachineName: Server name
        :type MachineName: str
        :param _OsInfo: Operating system
        :type OsInfo: str
        :param _Process: Reference process list
Note: This field may return null, indicating that no valid values can be obtained.
        :type Process: list of AssetAppProcessInfo
        :param _Md5: Jar package Md5
Note: This field may return null, indicating that no valid values can be obtained.
        :type Md5: str
        :param _UpdateTime: Data update time
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateTime: str
        """
        self._Name = None
        self._Type = None
        self._Status = None
        self._Version = None
        self._Path = None
        self._MachineIp = None
        self._MachineName = None
        self._OsInfo = None
        self._Process = None
        self._Md5 = None
        self._UpdateTime = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Version(self):
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def Path(self):
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def MachineIp(self):
        return self._MachineIp

    @MachineIp.setter
    def MachineIp(self, MachineIp):
        self._MachineIp = MachineIp

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def OsInfo(self):
        return self._OsInfo

    @OsInfo.setter
    def OsInfo(self, OsInfo):
        self._OsInfo = OsInfo

    @property
    def Process(self):
        return self._Process

    @Process.setter
    def Process(self, Process):
        self._Process = Process

    @property
    def Md5(self):
        return self._Md5

    @Md5.setter
    def Md5(self, Md5):
        self._Md5 = Md5

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Type = params.get("Type")
        self._Status = params.get("Status")
        self._Version = params.get("Version")
        self._Path = params.get("Path")
        self._MachineIp = params.get("MachineIp")
        self._MachineName = params.get("MachineName")
        self._OsInfo = params.get("OsInfo")
        if params.get("Process") is not None:
            self._Process = []
            for item in params.get("Process"):
                obj = AssetAppProcessInfo()
                obj._deserialize(item)
                self._Process.append(obj)
        self._Md5 = params.get("Md5")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetKeyVal(AbstractModel):
    """Generic data structure of Key-val type

    """

    def __init__(self):
        r"""
        :param _Key: Tag
        :type Key: str
        :param _Value: Quantity
        :type Value: int
        :param _Desc: Description information
Note: This field may return null, indicating that no valid values can be obtained.
        :type Desc: str
        :param _NewCount: Number of additions today
Note: This field may return null, indicating that no valid values can be obtained.
        :type NewCount: int
        """
        self._Key = None
        self._Value = None
        self._Desc = None
        self._NewCount = None

    @property
    def Key(self):
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key

    @property
    def Value(self):
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value

    @property
    def Desc(self):
        return self._Desc

    @Desc.setter
    def Desc(self, Desc):
        self._Desc = Desc

    @property
    def NewCount(self):
        return self._NewCount

    @NewCount.setter
    def NewCount(self, NewCount):
        self._NewCount = NewCount


    def _deserialize(self, params):
        self._Key = params.get("Key")
        self._Value = params.get("Value")
        self._Desc = params.get("Desc")
        self._NewCount = params.get("NewCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetLoadDetail(AbstractModel):
    """Asset management load information

    """

    def __init__(self):
        r"""
        :param _MachineName: Host name
        :type MachineName: str
        :param _Desc: Description
        :type Desc: str
        :param _Value: Load
        :type Value: float
        :param _Quuid: Host QUUID
        :type Quuid: str
        :param _Uuid: Host UUID
        :type Uuid: str
        """
        self._MachineName = None
        self._Desc = None
        self._Value = None
        self._Quuid = None
        self._Uuid = None

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def Desc(self):
        return self._Desc

    @Desc.setter
    def Desc(self, Desc):
        self._Desc = Desc

    @property
    def Value(self):
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid


    def _deserialize(self, params):
        self._MachineName = params.get("MachineName")
        self._Desc = params.get("Desc")
        self._Value = params.get("Value")
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetLoadSummary(AbstractModel):
    """Resource load overview

    """

    def __init__(self):
        r"""
        :param _Counts: Load amount array, in ascending order:
[
0% or unknown quantity
0%～20%
20%～50%
50%～80%
80%～100%
]
        :type Counts: list of int non-negative
        :param _Top5: Top 5 Load
Note: This field may return null, indicating that no valid values can be obtained.
        :type Top5: list of AssetLoadDetail
        """
        self._Counts = None
        self._Top5 = None

    @property
    def Counts(self):
        return self._Counts

    @Counts.setter
    def Counts(self, Counts):
        self._Counts = Counts

    @property
    def Top5(self):
        return self._Top5

    @Top5.setter
    def Top5(self, Top5):
        self._Top5 = Top5


    def _deserialize(self, params):
        self._Counts = params.get("Counts")
        if params.get("Top5") is not None:
            self._Top5 = []
            for item in params.get("Top5"):
                obj = AssetLoadDetail()
                obj._deserialize(item)
                self._Top5.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetMachineBaseInfo(AbstractModel):
    """Basic information on the server list in asset fingerprint

    """

    def __init__(self):
        r"""
        :param _Quuid: Server QUUID
        :type Quuid: str
        :param _Uuid: Server UUID
        :type Uuid: str
        :param _MachineIp: Private IP address of server
        :type MachineIp: str
        :param _MachineName: Server name
        :type MachineName: str
        :param _OsInfo: Operating system name
        :type OsInfo: str
        :param _Cpu: CPU information
        :type Cpu: str
        :param _MemSize: Memory capacity, in GB
        :type MemSize: int
        :param _MemLoad: Memory utilization, in percentage
        :type MemLoad: str
        :param _DiskSize: Hard disk capacity, in GB
        :type DiskSize: int
        :param _DiskLoad: Hard disk utilization, in percentage
        :type DiskLoad: str
        :param _PartitionCount: Number of partitions
        :type PartitionCount: int
        :param _MachineWanIp: Host public IP address
        :type MachineWanIp: str
        :param _ProjectId: Business group ID
        :type ProjectId: int
        :param _CpuSize: CPU count
        :type CpuSize: int
        :param _CpuLoad: CPU utilization, in percentage
        :type CpuLoad: str
        :param _Tag: Tag
Note: This field may return null, indicating that no valid values can be obtained.
        :type Tag: list of MachineTag
        :param _UpdateTime: Data update time
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateTime: str
        :param _IsNew: Whether it is newly added [0 - no;1 - yes]
        :type IsNew: int
        :param _FirstTime: First collection time
        :type FirstTime: str
        :param _MachineExtraInfo: Additional information
Note: This field may return null, indicating that no valid values can be obtained.
        :type MachineExtraInfo: :class:`tencentcloud.cwp.v20180228.models.MachineExtraInfo`
        :param _CpuLoadNum: CPU load readings (only valid for Linux systems)
Note: This field may return null, indicating that no valid values can be obtained.
        :type CpuLoadNum: str
        """
        self._Quuid = None
        self._Uuid = None
        self._MachineIp = None
        self._MachineName = None
        self._OsInfo = None
        self._Cpu = None
        self._MemSize = None
        self._MemLoad = None
        self._DiskSize = None
        self._DiskLoad = None
        self._PartitionCount = None
        self._MachineWanIp = None
        self._ProjectId = None
        self._CpuSize = None
        self._CpuLoad = None
        self._Tag = None
        self._UpdateTime = None
        self._IsNew = None
        self._FirstTime = None
        self._MachineExtraInfo = None
        self._CpuLoadNum = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def MachineIp(self):
        return self._MachineIp

    @MachineIp.setter
    def MachineIp(self, MachineIp):
        self._MachineIp = MachineIp

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def OsInfo(self):
        return self._OsInfo

    @OsInfo.setter
    def OsInfo(self, OsInfo):
        self._OsInfo = OsInfo

    @property
    def Cpu(self):
        return self._Cpu

    @Cpu.setter
    def Cpu(self, Cpu):
        self._Cpu = Cpu

    @property
    def MemSize(self):
        return self._MemSize

    @MemSize.setter
    def MemSize(self, MemSize):
        self._MemSize = MemSize

    @property
    def MemLoad(self):
        return self._MemLoad

    @MemLoad.setter
    def MemLoad(self, MemLoad):
        self._MemLoad = MemLoad

    @property
    def DiskSize(self):
        return self._DiskSize

    @DiskSize.setter
    def DiskSize(self, DiskSize):
        self._DiskSize = DiskSize

    @property
    def DiskLoad(self):
        return self._DiskLoad

    @DiskLoad.setter
    def DiskLoad(self, DiskLoad):
        self._DiskLoad = DiskLoad

    @property
    def PartitionCount(self):
        return self._PartitionCount

    @PartitionCount.setter
    def PartitionCount(self, PartitionCount):
        self._PartitionCount = PartitionCount

    @property
    def MachineWanIp(self):
        return self._MachineWanIp

    @MachineWanIp.setter
    def MachineWanIp(self, MachineWanIp):
        self._MachineWanIp = MachineWanIp

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def CpuSize(self):
        return self._CpuSize

    @CpuSize.setter
    def CpuSize(self, CpuSize):
        self._CpuSize = CpuSize

    @property
    def CpuLoad(self):
        return self._CpuLoad

    @CpuLoad.setter
    def CpuLoad(self, CpuLoad):
        self._CpuLoad = CpuLoad

    @property
    def Tag(self):
        return self._Tag

    @Tag.setter
    def Tag(self, Tag):
        self._Tag = Tag

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def IsNew(self):
        return self._IsNew

    @IsNew.setter
    def IsNew(self, IsNew):
        self._IsNew = IsNew

    @property
    def FirstTime(self):
        return self._FirstTime

    @FirstTime.setter
    def FirstTime(self, FirstTime):
        self._FirstTime = FirstTime

    @property
    def MachineExtraInfo(self):
        return self._MachineExtraInfo

    @MachineExtraInfo.setter
    def MachineExtraInfo(self, MachineExtraInfo):
        self._MachineExtraInfo = MachineExtraInfo

    @property
    def CpuLoadNum(self):
        return self._CpuLoadNum

    @CpuLoadNum.setter
    def CpuLoadNum(self, CpuLoadNum):
        self._CpuLoadNum = CpuLoadNum


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._MachineIp = params.get("MachineIp")
        self._MachineName = params.get("MachineName")
        self._OsInfo = params.get("OsInfo")
        self._Cpu = params.get("Cpu")
        self._MemSize = params.get("MemSize")
        self._MemLoad = params.get("MemLoad")
        self._DiskSize = params.get("DiskSize")
        self._DiskLoad = params.get("DiskLoad")
        self._PartitionCount = params.get("PartitionCount")
        self._MachineWanIp = params.get("MachineWanIp")
        self._ProjectId = params.get("ProjectId")
        self._CpuSize = params.get("CpuSize")
        self._CpuLoad = params.get("CpuLoad")
        if params.get("Tag") is not None:
            self._Tag = []
            for item in params.get("Tag"):
                obj = MachineTag()
                obj._deserialize(item)
                self._Tag.append(obj)
        self._UpdateTime = params.get("UpdateTime")
        self._IsNew = params.get("IsNew")
        self._FirstTime = params.get("FirstTime")
        if params.get("MachineExtraInfo") is not None:
            self._MachineExtraInfo = MachineExtraInfo()
            self._MachineExtraInfo._deserialize(params.get("MachineExtraInfo"))
        self._CpuLoadNum = params.get("CpuLoadNum")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetMachineDetail(AbstractModel):
    """Basic information on the server list in asset fingerprint

    """

    def __init__(self):
        r"""
        :param _Quuid: Server QUUID
        :type Quuid: str
        :param _Uuid: Server UUID
        :type Uuid: str
        :param _MachineIp: Private IP address of server
        :type MachineIp: str
        :param _MachineName: Server name
        :type MachineName: str
        :param _OsInfo: Operating system name
        :type OsInfo: str
        :param _Cpu: CPU information
        :type Cpu: str
        :param _MemSize: Memory capacity, in GB
        :type MemSize: int
        :param _MemLoad: Memory utilization, in percentage
        :type MemLoad: str
        :param _DiskSize: Hard disk capacity, in GB
        :type DiskSize: int
        :param _DiskLoad: Hard disk usage, in percentage
        :type DiskLoad: str
        :param _PartitionCount: Number of partitions
        :type PartitionCount: int
        :param _MachineWanIp: Host public IP address
        :type MachineWanIp: str
        :param _CpuSize: Number of CPU
        :type CpuSize: int
        :param _CpuLoad: CPU load
        :type CpuLoad: str
        :param _ProtectLevel: Protection Level. 0 Basic Edition; 1 Professional Edition; 2 Premium Edition; 3 General Discount Edition
        :type ProtectLevel: int
        :param _RiskStatus: Risk status: UNKNOW - unknown; RISK - risky; SAFT - Safe
        :type RiskStatus: str
        :param _ProtectDays: Days protected
        :type ProtectDays: int
        :param _BuyTime: Professional edition activation time
        :type BuyTime: str
        :param _EndTime: Professional edition expiration time
        :type EndTime: str
        :param _CoreVersion: Kernel version
        :type CoreVersion: str
        :param _OsType: linux/windows
        :type OsType: str
        :param _AgentVersion: Agent version
        :type AgentVersion: str
        :param _InstallTime: Installation time
        :type InstallTime: str
        :param _BootTime: System startup time
        :type BootTime: str
        :param _LastLiveTime: Last online time
        :type LastLiveTime: str
        :param _Producer: Manufacturer
        :type Producer: str
        :param _SerialNumber: Serial number
        :type SerialNumber: str
        :param _NetCards: Network interface

        :type NetCards: list of AssetNetworkCardInfo
        :param _Disks: Partition
        :type Disks: list of AssetDiskPartitionInfo
        :param _Status: 0: online; 1: offline
        :type Status: int
        :param _ProjectId: Business group ID
        :type ProjectId: int
        :param _DeviceVersion: Server model
        :type DeviceVersion: str
        :param _OfflineTime: Offline time
Note: This field may return null, indicating that no valid values can be obtained.
        :type OfflineTime: str
        :param _InstanceId: Host ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type InstanceId: str
        :param _UpdateTime: Data update time
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateTime: str
        :param _MachineExtraInfo: Host Additional Information
Note: This field may return null, indicating that no valid values can be obtained.
        :type MachineExtraInfo: :class:`tencentcloud.cwp.v20180228.models.MachineExtraInfo`
        :param _CpuLoadVul: CpuLoadVul
Note: This field may return null, indicating that no valid values can be obtained.
        :type CpuLoadVul: str
        :param _FirstTime: Time
Note: This field may return null, indicating that no valid values can be obtained.
        :type FirstTime: str
        """
        self._Quuid = None
        self._Uuid = None
        self._MachineIp = None
        self._MachineName = None
        self._OsInfo = None
        self._Cpu = None
        self._MemSize = None
        self._MemLoad = None
        self._DiskSize = None
        self._DiskLoad = None
        self._PartitionCount = None
        self._MachineWanIp = None
        self._CpuSize = None
        self._CpuLoad = None
        self._ProtectLevel = None
        self._RiskStatus = None
        self._ProtectDays = None
        self._BuyTime = None
        self._EndTime = None
        self._CoreVersion = None
        self._OsType = None
        self._AgentVersion = None
        self._InstallTime = None
        self._BootTime = None
        self._LastLiveTime = None
        self._Producer = None
        self._SerialNumber = None
        self._NetCards = None
        self._Disks = None
        self._Status = None
        self._ProjectId = None
        self._DeviceVersion = None
        self._OfflineTime = None
        self._InstanceId = None
        self._UpdateTime = None
        self._MachineExtraInfo = None
        self._CpuLoadVul = None
        self._FirstTime = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def MachineIp(self):
        return self._MachineIp

    @MachineIp.setter
    def MachineIp(self, MachineIp):
        self._MachineIp = MachineIp

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def OsInfo(self):
        return self._OsInfo

    @OsInfo.setter
    def OsInfo(self, OsInfo):
        self._OsInfo = OsInfo

    @property
    def Cpu(self):
        return self._Cpu

    @Cpu.setter
    def Cpu(self, Cpu):
        self._Cpu = Cpu

    @property
    def MemSize(self):
        return self._MemSize

    @MemSize.setter
    def MemSize(self, MemSize):
        self._MemSize = MemSize

    @property
    def MemLoad(self):
        return self._MemLoad

    @MemLoad.setter
    def MemLoad(self, MemLoad):
        self._MemLoad = MemLoad

    @property
    def DiskSize(self):
        return self._DiskSize

    @DiskSize.setter
    def DiskSize(self, DiskSize):
        self._DiskSize = DiskSize

    @property
    def DiskLoad(self):
        return self._DiskLoad

    @DiskLoad.setter
    def DiskLoad(self, DiskLoad):
        self._DiskLoad = DiskLoad

    @property
    def PartitionCount(self):
        return self._PartitionCount

    @PartitionCount.setter
    def PartitionCount(self, PartitionCount):
        self._PartitionCount = PartitionCount

    @property
    def MachineWanIp(self):
        return self._MachineWanIp

    @MachineWanIp.setter
    def MachineWanIp(self, MachineWanIp):
        self._MachineWanIp = MachineWanIp

    @property
    def CpuSize(self):
        return self._CpuSize

    @CpuSize.setter
    def CpuSize(self, CpuSize):
        self._CpuSize = CpuSize

    @property
    def CpuLoad(self):
        return self._CpuLoad

    @CpuLoad.setter
    def CpuLoad(self, CpuLoad):
        self._CpuLoad = CpuLoad

    @property
    def ProtectLevel(self):
        return self._ProtectLevel

    @ProtectLevel.setter
    def ProtectLevel(self, ProtectLevel):
        self._ProtectLevel = ProtectLevel

    @property
    def RiskStatus(self):
        return self._RiskStatus

    @RiskStatus.setter
    def RiskStatus(self, RiskStatus):
        self._RiskStatus = RiskStatus

    @property
    def ProtectDays(self):
        return self._ProtectDays

    @ProtectDays.setter
    def ProtectDays(self, ProtectDays):
        self._ProtectDays = ProtectDays

    @property
    def BuyTime(self):
        return self._BuyTime

    @BuyTime.setter
    def BuyTime(self, BuyTime):
        self._BuyTime = BuyTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def CoreVersion(self):
        return self._CoreVersion

    @CoreVersion.setter
    def CoreVersion(self, CoreVersion):
        self._CoreVersion = CoreVersion

    @property
    def OsType(self):
        return self._OsType

    @OsType.setter
    def OsType(self, OsType):
        self._OsType = OsType

    @property
    def AgentVersion(self):
        return self._AgentVersion

    @AgentVersion.setter
    def AgentVersion(self, AgentVersion):
        self._AgentVersion = AgentVersion

    @property
    def InstallTime(self):
        return self._InstallTime

    @InstallTime.setter
    def InstallTime(self, InstallTime):
        self._InstallTime = InstallTime

    @property
    def BootTime(self):
        return self._BootTime

    @BootTime.setter
    def BootTime(self, BootTime):
        self._BootTime = BootTime

    @property
    def LastLiveTime(self):
        return self._LastLiveTime

    @LastLiveTime.setter
    def LastLiveTime(self, LastLiveTime):
        self._LastLiveTime = LastLiveTime

    @property
    def Producer(self):
        return self._Producer

    @Producer.setter
    def Producer(self, Producer):
        self._Producer = Producer

    @property
    def SerialNumber(self):
        return self._SerialNumber

    @SerialNumber.setter
    def SerialNumber(self, SerialNumber):
        self._SerialNumber = SerialNumber

    @property
    def NetCards(self):
        return self._NetCards

    @NetCards.setter
    def NetCards(self, NetCards):
        self._NetCards = NetCards

    @property
    def Disks(self):
        return self._Disks

    @Disks.setter
    def Disks(self, Disks):
        self._Disks = Disks

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def DeviceVersion(self):
        return self._DeviceVersion

    @DeviceVersion.setter
    def DeviceVersion(self, DeviceVersion):
        self._DeviceVersion = DeviceVersion

    @property
    def OfflineTime(self):
        return self._OfflineTime

    @OfflineTime.setter
    def OfflineTime(self, OfflineTime):
        self._OfflineTime = OfflineTime

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def MachineExtraInfo(self):
        return self._MachineExtraInfo

    @MachineExtraInfo.setter
    def MachineExtraInfo(self, MachineExtraInfo):
        self._MachineExtraInfo = MachineExtraInfo

    @property
    def CpuLoadVul(self):
        return self._CpuLoadVul

    @CpuLoadVul.setter
    def CpuLoadVul(self, CpuLoadVul):
        self._CpuLoadVul = CpuLoadVul

    @property
    def FirstTime(self):
        return self._FirstTime

    @FirstTime.setter
    def FirstTime(self, FirstTime):
        self._FirstTime = FirstTime


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._MachineIp = params.get("MachineIp")
        self._MachineName = params.get("MachineName")
        self._OsInfo = params.get("OsInfo")
        self._Cpu = params.get("Cpu")
        self._MemSize = params.get("MemSize")
        self._MemLoad = params.get("MemLoad")
        self._DiskSize = params.get("DiskSize")
        self._DiskLoad = params.get("DiskLoad")
        self._PartitionCount = params.get("PartitionCount")
        self._MachineWanIp = params.get("MachineWanIp")
        self._CpuSize = params.get("CpuSize")
        self._CpuLoad = params.get("CpuLoad")
        self._ProtectLevel = params.get("ProtectLevel")
        self._RiskStatus = params.get("RiskStatus")
        self._ProtectDays = params.get("ProtectDays")
        self._BuyTime = params.get("BuyTime")
        self._EndTime = params.get("EndTime")
        self._CoreVersion = params.get("CoreVersion")
        self._OsType = params.get("OsType")
        self._AgentVersion = params.get("AgentVersion")
        self._InstallTime = params.get("InstallTime")
        self._BootTime = params.get("BootTime")
        self._LastLiveTime = params.get("LastLiveTime")
        self._Producer = params.get("Producer")
        self._SerialNumber = params.get("SerialNumber")
        if params.get("NetCards") is not None:
            self._NetCards = []
            for item in params.get("NetCards"):
                obj = AssetNetworkCardInfo()
                obj._deserialize(item)
                self._NetCards.append(obj)
        if params.get("Disks") is not None:
            self._Disks = []
            for item in params.get("Disks"):
                obj = AssetDiskPartitionInfo()
                obj._deserialize(item)
                self._Disks.append(obj)
        self._Status = params.get("Status")
        self._ProjectId = params.get("ProjectId")
        self._DeviceVersion = params.get("DeviceVersion")
        self._OfflineTime = params.get("OfflineTime")
        self._InstanceId = params.get("InstanceId")
        self._UpdateTime = params.get("UpdateTime")
        if params.get("MachineExtraInfo") is not None:
            self._MachineExtraInfo = MachineExtraInfo()
            self._MachineExtraInfo._deserialize(params.get("MachineExtraInfo"))
        self._CpuLoadVul = params.get("CpuLoadVul")
        self._FirstTime = params.get("FirstTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetNetworkCardInfo(AbstractModel):
    """Asset management network interface information

    """

    def __init__(self):
        r"""
        :param _Name: Network interface name
        :type Name: str
        :param _Ip: IPv4 address
        :type Ip: str
        :param _GateWay: Gateway
        :type GateWay: str
        :param _Mac: MAC address
        :type Mac: str
        :param _Ipv6: IPv6 address
        :type Ipv6: str
        :param _DnsServer: DNS server
        :type DnsServer: str
        """
        self._Name = None
        self._Ip = None
        self._GateWay = None
        self._Mac = None
        self._Ipv6 = None
        self._DnsServer = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Ip(self):
        return self._Ip

    @Ip.setter
    def Ip(self, Ip):
        self._Ip = Ip

    @property
    def GateWay(self):
        return self._GateWay

    @GateWay.setter
    def GateWay(self, GateWay):
        self._GateWay = GateWay

    @property
    def Mac(self):
        return self._Mac

    @Mac.setter
    def Mac(self, Mac):
        self._Mac = Mac

    @property
    def Ipv6(self):
        return self._Ipv6

    @Ipv6.setter
    def Ipv6(self, Ipv6):
        self._Ipv6 = Ipv6

    @property
    def DnsServer(self):
        return self._DnsServer

    @DnsServer.setter
    def DnsServer(self, DnsServer):
        self._DnsServer = DnsServer


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Ip = params.get("Ip")
        self._GateWay = params.get("GateWay")
        self._Mac = params.get("Mac")
        self._Ipv6 = params.get("Ipv6")
        self._DnsServer = params.get("DnsServer")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetPlanTask(AbstractModel):
    """List of asset management plan tasks

    """

    def __init__(self):
        r"""
        :param _Status: Default enabling status. 1 - enabled; 2 - not enabled
        :type Status: int
        :param _Cycle: Execution cycle
        :type Cycle: str
        :param _Command: Execute command or script
        :type Command: str
        :param _User: Startup user
        :type User: str
        :param _ConfigPath: Configuration file path
        :type ConfigPath: str
        :param _MachineIp: Server IP
        :type MachineIp: str
        :param _MachineName: Name
        :type MachineName: str
        :param _OsInfo: Operating system
        :type OsInfo: str
        :param _Quuid: Host QUUID
        :type Quuid: str
        :param _Uuid: Host UUID
        :type Uuid: str
        :param _UpdateTime: Data update time
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateTime: str
        :param _FirstTime: First collection time
        :type FirstTime: str
        :param _IsNew: Whether newly added [0: no|1: yes]
        :type IsNew: int
        :param _MachineWanIp: Server Public IP
        :type MachineWanIp: str
        :param _MachineExtraInfo: Additional information
Note: This field may return null, indicating that no valid values can be obtained.
        :type MachineExtraInfo: :class:`tencentcloud.cwp.v20180228.models.MachineExtraInfo`
        """
        self._Status = None
        self._Cycle = None
        self._Command = None
        self._User = None
        self._ConfigPath = None
        self._MachineIp = None
        self._MachineName = None
        self._OsInfo = None
        self._Quuid = None
        self._Uuid = None
        self._UpdateTime = None
        self._FirstTime = None
        self._IsNew = None
        self._MachineWanIp = None
        self._MachineExtraInfo = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Cycle(self):
        return self._Cycle

    @Cycle.setter
    def Cycle(self, Cycle):
        self._Cycle = Cycle

    @property
    def Command(self):
        return self._Command

    @Command.setter
    def Command(self, Command):
        self._Command = Command

    @property
    def User(self):
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def ConfigPath(self):
        return self._ConfigPath

    @ConfigPath.setter
    def ConfigPath(self, ConfigPath):
        self._ConfigPath = ConfigPath

    @property
    def MachineIp(self):
        return self._MachineIp

    @MachineIp.setter
    def MachineIp(self, MachineIp):
        self._MachineIp = MachineIp

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def OsInfo(self):
        return self._OsInfo

    @OsInfo.setter
    def OsInfo(self, OsInfo):
        self._OsInfo = OsInfo

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def FirstTime(self):
        return self._FirstTime

    @FirstTime.setter
    def FirstTime(self, FirstTime):
        self._FirstTime = FirstTime

    @property
    def IsNew(self):
        return self._IsNew

    @IsNew.setter
    def IsNew(self, IsNew):
        self._IsNew = IsNew

    @property
    def MachineWanIp(self):
        return self._MachineWanIp

    @MachineWanIp.setter
    def MachineWanIp(self, MachineWanIp):
        self._MachineWanIp = MachineWanIp

    @property
    def MachineExtraInfo(self):
        return self._MachineExtraInfo

    @MachineExtraInfo.setter
    def MachineExtraInfo(self, MachineExtraInfo):
        self._MachineExtraInfo = MachineExtraInfo


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._Cycle = params.get("Cycle")
        self._Command = params.get("Command")
        self._User = params.get("User")
        self._ConfigPath = params.get("ConfigPath")
        self._MachineIp = params.get("MachineIp")
        self._MachineName = params.get("MachineName")
        self._OsInfo = params.get("OsInfo")
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._UpdateTime = params.get("UpdateTime")
        self._FirstTime = params.get("FirstTime")
        self._IsNew = params.get("IsNew")
        self._MachineWanIp = params.get("MachineWanIp")
        if params.get("MachineExtraInfo") is not None:
            self._MachineExtraInfo = MachineExtraInfo()
            self._MachineExtraInfo._deserialize(params.get("MachineExtraInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetPortBaseInfo(AbstractModel):
    """Basic information of resource management account

    """

    def __init__(self):
        r"""
        :param _MachineIp: Private IP address of the host
        :type MachineIp: str
        :param _MachineWanIp: Public IP address of the host
        :type MachineWanIp: str
        :param _Quuid: Host QUUID
        :type Quuid: str
        :param _Uuid: Host UUID
        :type Uuid: str
        :param _OsInfo: Operating System Information
        :type OsInfo: str
        :param _ProjectId: Host business group ID
        :type ProjectId: int
        :param _Tag: Host tag
Note: This field may return null, indicating that no valid values can be obtained.
        :type Tag: list of MachineTag
        :param _ProcessName: Process name
        :type ProcessName: str
        :param _ProcessVersion: Process version
        :type ProcessVersion: str
        :param _ProcessPath: Process path
        :type ProcessPath: str
        :param _Pid: Process ID
        :type Pid: str
        :param _User: Running user
        :type User: str
        :param _StartTime: Start time
        :type StartTime: str
        :param _Param: Start parameter
        :type Param: str
        :param _Teletype: Process TTY
        :type Teletype: str
        :param _Port: Port
        :type Port: str
        :param _GroupName: User group
        :type GroupName: str
        :param _Md5: Process MD5
        :type Md5: str
        :param _Ppid: Parent process ID
        :type Ppid: str
        :param _ParentProcessName: Parent process name
        :type ParentProcessName: str
        :param _Proto: Port protocol
        :type Proto: str
        :param _BindIp: Bound IP
        :type BindIp: str
        :param _MachineName: Host name
        :type MachineName: str
        :param _UpdateTime: Data update time
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateTime: str
        :param _FirstTime: First collection time
        :type FirstTime: str
        :param _IsNew: Whether to add [0: no | 1: yes]
        :type IsNew: int
        :param _MachineExtraInfo: Additional information
Note: This field may return null, indicating that no valid values can be obtained.
        :type MachineExtraInfo: :class:`tencentcloud.cwp.v20180228.models.MachineExtraInfo`
        """
        self._MachineIp = None
        self._MachineWanIp = None
        self._Quuid = None
        self._Uuid = None
        self._OsInfo = None
        self._ProjectId = None
        self._Tag = None
        self._ProcessName = None
        self._ProcessVersion = None
        self._ProcessPath = None
        self._Pid = None
        self._User = None
        self._StartTime = None
        self._Param = None
        self._Teletype = None
        self._Port = None
        self._GroupName = None
        self._Md5 = None
        self._Ppid = None
        self._ParentProcessName = None
        self._Proto = None
        self._BindIp = None
        self._MachineName = None
        self._UpdateTime = None
        self._FirstTime = None
        self._IsNew = None
        self._MachineExtraInfo = None

    @property
    def MachineIp(self):
        return self._MachineIp

    @MachineIp.setter
    def MachineIp(self, MachineIp):
        self._MachineIp = MachineIp

    @property
    def MachineWanIp(self):
        return self._MachineWanIp

    @MachineWanIp.setter
    def MachineWanIp(self, MachineWanIp):
        self._MachineWanIp = MachineWanIp

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def OsInfo(self):
        return self._OsInfo

    @OsInfo.setter
    def OsInfo(self, OsInfo):
        self._OsInfo = OsInfo

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Tag(self):
        return self._Tag

    @Tag.setter
    def Tag(self, Tag):
        self._Tag = Tag

    @property
    def ProcessName(self):
        return self._ProcessName

    @ProcessName.setter
    def ProcessName(self, ProcessName):
        self._ProcessName = ProcessName

    @property
    def ProcessVersion(self):
        return self._ProcessVersion

    @ProcessVersion.setter
    def ProcessVersion(self, ProcessVersion):
        self._ProcessVersion = ProcessVersion

    @property
    def ProcessPath(self):
        return self._ProcessPath

    @ProcessPath.setter
    def ProcessPath(self, ProcessPath):
        self._ProcessPath = ProcessPath

    @property
    def Pid(self):
        return self._Pid

    @Pid.setter
    def Pid(self, Pid):
        self._Pid = Pid

    @property
    def User(self):
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def Param(self):
        return self._Param

    @Param.setter
    def Param(self, Param):
        self._Param = Param

    @property
    def Teletype(self):
        return self._Teletype

    @Teletype.setter
    def Teletype(self, Teletype):
        self._Teletype = Teletype

    @property
    def Port(self):
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def GroupName(self):
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName

    @property
    def Md5(self):
        return self._Md5

    @Md5.setter
    def Md5(self, Md5):
        self._Md5 = Md5

    @property
    def Ppid(self):
        return self._Ppid

    @Ppid.setter
    def Ppid(self, Ppid):
        self._Ppid = Ppid

    @property
    def ParentProcessName(self):
        return self._ParentProcessName

    @ParentProcessName.setter
    def ParentProcessName(self, ParentProcessName):
        self._ParentProcessName = ParentProcessName

    @property
    def Proto(self):
        return self._Proto

    @Proto.setter
    def Proto(self, Proto):
        self._Proto = Proto

    @property
    def BindIp(self):
        return self._BindIp

    @BindIp.setter
    def BindIp(self, BindIp):
        self._BindIp = BindIp

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def FirstTime(self):
        return self._FirstTime

    @FirstTime.setter
    def FirstTime(self, FirstTime):
        self._FirstTime = FirstTime

    @property
    def IsNew(self):
        return self._IsNew

    @IsNew.setter
    def IsNew(self, IsNew):
        self._IsNew = IsNew

    @property
    def MachineExtraInfo(self):
        return self._MachineExtraInfo

    @MachineExtraInfo.setter
    def MachineExtraInfo(self, MachineExtraInfo):
        self._MachineExtraInfo = MachineExtraInfo


    def _deserialize(self, params):
        self._MachineIp = params.get("MachineIp")
        self._MachineWanIp = params.get("MachineWanIp")
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._OsInfo = params.get("OsInfo")
        self._ProjectId = params.get("ProjectId")
        if params.get("Tag") is not None:
            self._Tag = []
            for item in params.get("Tag"):
                obj = MachineTag()
                obj._deserialize(item)
                self._Tag.append(obj)
        self._ProcessName = params.get("ProcessName")
        self._ProcessVersion = params.get("ProcessVersion")
        self._ProcessPath = params.get("ProcessPath")
        self._Pid = params.get("Pid")
        self._User = params.get("User")
        self._StartTime = params.get("StartTime")
        self._Param = params.get("Param")
        self._Teletype = params.get("Teletype")
        self._Port = params.get("Port")
        self._GroupName = params.get("GroupName")
        self._Md5 = params.get("Md5")
        self._Ppid = params.get("Ppid")
        self._ParentProcessName = params.get("ParentProcessName")
        self._Proto = params.get("Proto")
        self._BindIp = params.get("BindIp")
        self._MachineName = params.get("MachineName")
        self._UpdateTime = params.get("UpdateTime")
        self._FirstTime = params.get("FirstTime")
        self._IsNew = params.get("IsNew")
        if params.get("MachineExtraInfo") is not None:
            self._MachineExtraInfo = MachineExtraInfo()
            self._MachineExtraInfo._deserialize(params.get("MachineExtraInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetProcessBaseInfo(AbstractModel):
    """Basic information on the resource management process

    """

    def __init__(self):
        r"""
        :param _MachineIp: Host private IP address
        :type MachineIp: str
        :param _MachineWanIp: Host public IP address
        :type MachineWanIp: str
        :param _Quuid: Host QUUID
        :type Quuid: str
        :param _Uuid: Host UUID
        :type Uuid: str
        :param _OsInfo: Operating System Information
        :type OsInfo: str
        :param _ProjectId: Host business group ID
        :type ProjectId: int
        :param _Tag: Host tag
Note: This field may return null, indicating that no valid values can be obtained.
        :type Tag: list of MachineTag
        :param _Name: Process name
        :type Name: str
        :param _Desc: Process description
        :type Desc: str
        :param _Path: Process path
        :type Path: str
        :param _Pid: Process ID
        :type Pid: str
        :param _User: Running user
        :type User: str
        :param _StartTime: Startup time
        :type StartTime: str
        :param _Param: Startup parameter
        :type Param: str
        :param _Tty: Process TTY
        :type Tty: str
        :param _Version: Process version
        :type Version: str
        :param _GroupName: Process user group
        :type GroupName: str
        :param _Md5: Process MD5
        :type Md5: str
        :param _Ppid: Parent process ID
        :type Ppid: str
        :param _ParentProcessName: Parent process name
        :type ParentProcessName: str
        :param _Status: Process status
        :type Status: str
        :param _HasSign: Digital signature. 0: no; 1: yes; 999: null (Windows only).
        :type HasSign: int
        :param _InstallByPackage: Whether to install the package. 0: no; 1: yes; 999: null (Linux only).
        :type InstallByPackage: int
        :param _PackageName: Software package name
        :type PackageName: str
        :param _MachineName: Host name
        :type MachineName: str
        :param _UpdateTime: Data update time
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateTime: str
        :param _FirstTime: First collection time
        :type FirstTime: str
        :param _IsNew: Whether new [0: no|1: yes]
        :type IsNew: int
        :param _MachineExtraInfo: Additional information

Note: This field may return null, indicating that no valid values can be obtained.
        :type MachineExtraInfo: :class:`tencentcloud.cwp.v20180228.models.MachineExtraInfo`
        """
        self._MachineIp = None
        self._MachineWanIp = None
        self._Quuid = None
        self._Uuid = None
        self._OsInfo = None
        self._ProjectId = None
        self._Tag = None
        self._Name = None
        self._Desc = None
        self._Path = None
        self._Pid = None
        self._User = None
        self._StartTime = None
        self._Param = None
        self._Tty = None
        self._Version = None
        self._GroupName = None
        self._Md5 = None
        self._Ppid = None
        self._ParentProcessName = None
        self._Status = None
        self._HasSign = None
        self._InstallByPackage = None
        self._PackageName = None
        self._MachineName = None
        self._UpdateTime = None
        self._FirstTime = None
        self._IsNew = None
        self._MachineExtraInfo = None

    @property
    def MachineIp(self):
        return self._MachineIp

    @MachineIp.setter
    def MachineIp(self, MachineIp):
        self._MachineIp = MachineIp

    @property
    def MachineWanIp(self):
        return self._MachineWanIp

    @MachineWanIp.setter
    def MachineWanIp(self, MachineWanIp):
        self._MachineWanIp = MachineWanIp

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def OsInfo(self):
        return self._OsInfo

    @OsInfo.setter
    def OsInfo(self, OsInfo):
        self._OsInfo = OsInfo

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Tag(self):
        return self._Tag

    @Tag.setter
    def Tag(self, Tag):
        self._Tag = Tag

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Desc(self):
        return self._Desc

    @Desc.setter
    def Desc(self, Desc):
        self._Desc = Desc

    @property
    def Path(self):
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def Pid(self):
        return self._Pid

    @Pid.setter
    def Pid(self, Pid):
        self._Pid = Pid

    @property
    def User(self):
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def Param(self):
        return self._Param

    @Param.setter
    def Param(self, Param):
        self._Param = Param

    @property
    def Tty(self):
        return self._Tty

    @Tty.setter
    def Tty(self, Tty):
        self._Tty = Tty

    @property
    def Version(self):
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def GroupName(self):
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName

    @property
    def Md5(self):
        return self._Md5

    @Md5.setter
    def Md5(self, Md5):
        self._Md5 = Md5

    @property
    def Ppid(self):
        return self._Ppid

    @Ppid.setter
    def Ppid(self, Ppid):
        self._Ppid = Ppid

    @property
    def ParentProcessName(self):
        return self._ParentProcessName

    @ParentProcessName.setter
    def ParentProcessName(self, ParentProcessName):
        self._ParentProcessName = ParentProcessName

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def HasSign(self):
        return self._HasSign

    @HasSign.setter
    def HasSign(self, HasSign):
        self._HasSign = HasSign

    @property
    def InstallByPackage(self):
        return self._InstallByPackage

    @InstallByPackage.setter
    def InstallByPackage(self, InstallByPackage):
        self._InstallByPackage = InstallByPackage

    @property
    def PackageName(self):
        return self._PackageName

    @PackageName.setter
    def PackageName(self, PackageName):
        self._PackageName = PackageName

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def FirstTime(self):
        return self._FirstTime

    @FirstTime.setter
    def FirstTime(self, FirstTime):
        self._FirstTime = FirstTime

    @property
    def IsNew(self):
        return self._IsNew

    @IsNew.setter
    def IsNew(self, IsNew):
        self._IsNew = IsNew

    @property
    def MachineExtraInfo(self):
        return self._MachineExtraInfo

    @MachineExtraInfo.setter
    def MachineExtraInfo(self, MachineExtraInfo):
        self._MachineExtraInfo = MachineExtraInfo


    def _deserialize(self, params):
        self._MachineIp = params.get("MachineIp")
        self._MachineWanIp = params.get("MachineWanIp")
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._OsInfo = params.get("OsInfo")
        self._ProjectId = params.get("ProjectId")
        if params.get("Tag") is not None:
            self._Tag = []
            for item in params.get("Tag"):
                obj = MachineTag()
                obj._deserialize(item)
                self._Tag.append(obj)
        self._Name = params.get("Name")
        self._Desc = params.get("Desc")
        self._Path = params.get("Path")
        self._Pid = params.get("Pid")
        self._User = params.get("User")
        self._StartTime = params.get("StartTime")
        self._Param = params.get("Param")
        self._Tty = params.get("Tty")
        self._Version = params.get("Version")
        self._GroupName = params.get("GroupName")
        self._Md5 = params.get("Md5")
        self._Ppid = params.get("Ppid")
        self._ParentProcessName = params.get("ParentProcessName")
        self._Status = params.get("Status")
        self._HasSign = params.get("HasSign")
        self._InstallByPackage = params.get("InstallByPackage")
        self._PackageName = params.get("PackageName")
        self._MachineName = params.get("MachineName")
        self._UpdateTime = params.get("UpdateTime")
        self._FirstTime = params.get("FirstTime")
        self._IsNew = params.get("IsNew")
        if params.get("MachineExtraInfo") is not None:
            self._MachineExtraInfo = MachineExtraInfo()
            self._MachineExtraInfo._deserialize(params.get("MachineExtraInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetSystemPackageInfo(AbstractModel):
    """Information on resource management system installation package list

    """

    def __init__(self):
        r"""
        :param _Name: Database name
        :type Name: str
        :param _Desc: Description
        :type Desc: str
        :param _Version: Version
        :type Version: str
        :param _InstallTime: Installation time
        :type InstallTime: str
        :param _Type: Type
        :type Type: str
        :param _MachineName: Host name
        :type MachineName: str
        :param _MachineIp: Host IP
        :type MachineIp: str
        :param _OsInfo: Operating system
        :type OsInfo: str
        :param _UpdateTime: Data update time
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateTime: str
        :param _FirstTime: First collection time
        :type FirstTime: str
        :param _IsNew: Whether newly added [0: no|1: yes]
        :type IsNew: int
        :param _MachineExtraInfo: Additional information
        :type MachineExtraInfo: :class:`tencentcloud.cwp.v20180228.models.MachineExtraInfo`
        :param _Quuid: Host ID
        :type Quuid: str
        :param _Uuid: Agent Id
        :type Uuid: str
        """
        self._Name = None
        self._Desc = None
        self._Version = None
        self._InstallTime = None
        self._Type = None
        self._MachineName = None
        self._MachineIp = None
        self._OsInfo = None
        self._UpdateTime = None
        self._FirstTime = None
        self._IsNew = None
        self._MachineExtraInfo = None
        self._Quuid = None
        self._Uuid = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Desc(self):
        return self._Desc

    @Desc.setter
    def Desc(self, Desc):
        self._Desc = Desc

    @property
    def Version(self):
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def InstallTime(self):
        return self._InstallTime

    @InstallTime.setter
    def InstallTime(self, InstallTime):
        self._InstallTime = InstallTime

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def MachineIp(self):
        return self._MachineIp

    @MachineIp.setter
    def MachineIp(self, MachineIp):
        self._MachineIp = MachineIp

    @property
    def OsInfo(self):
        return self._OsInfo

    @OsInfo.setter
    def OsInfo(self, OsInfo):
        self._OsInfo = OsInfo

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def FirstTime(self):
        return self._FirstTime

    @FirstTime.setter
    def FirstTime(self, FirstTime):
        self._FirstTime = FirstTime

    @property
    def IsNew(self):
        return self._IsNew

    @IsNew.setter
    def IsNew(self, IsNew):
        self._IsNew = IsNew

    @property
    def MachineExtraInfo(self):
        return self._MachineExtraInfo

    @MachineExtraInfo.setter
    def MachineExtraInfo(self, MachineExtraInfo):
        self._MachineExtraInfo = MachineExtraInfo

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Desc = params.get("Desc")
        self._Version = params.get("Version")
        self._InstallTime = params.get("InstallTime")
        self._Type = params.get("Type")
        self._MachineName = params.get("MachineName")
        self._MachineIp = params.get("MachineIp")
        self._OsInfo = params.get("OsInfo")
        self._UpdateTime = params.get("UpdateTime")
        self._FirstTime = params.get("FirstTime")
        self._IsNew = params.get("IsNew")
        if params.get("MachineExtraInfo") is not None:
            self._MachineExtraInfo = MachineExtraInfo()
            self._MachineExtraInfo._deserialize(params.get("MachineExtraInfo"))
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetType(AbstractModel):
    """Asset fingerprint type description

    """

    def __init__(self):
        r"""
        :param _Id: Type ID
        :type Id: int
        :param _Name: Type name
        :type Name: str
        """
        self._Id = None
        self._Name = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetUserBaseInfo(AbstractModel):
    """Resource management account basic information

    """

    def __init__(self):
        r"""
        :param _MachineIp: Host private IP address
        :type MachineIp: str
        :param _MachineWanIp: Host public IP address
        :type MachineWanIp: str
        :param _MachineName: Host name
        :type MachineName: str
        :param _OsInfo: Operating System Information
        :type OsInfo: str
        :param _Uuid: Host UUID
        :type Uuid: str
        :param _Quuid: Host QUUID
        :type Quuid: str
        :param _Uid: Account UID
        :type Uid: str
        :param _Gid: Account GID
        :type Gid: str
        :param _Status: Account status. 0: disabled; 1: enabled
        :type Status: int
        :param _IsRoot: Whether there is root permission. 0: no; 1: yes; 999: null (Linux only)
        :type IsRoot: int
        :param _LoginType: Log-in method. 0: log-in not allowed; 1: only key-based log-in allowed; 2: only password-based log-in allowed; 3: both key-based log-in and password-based log-in allowed; 999: null (Linux only)
        :type LoginType: int
        :param _LastLoginTime: Last log-in time
        :type LastLoginTime: str
        :param _Name: Account name
        :type Name: str
        :param _ProjectId: Host business group ID
        :type ProjectId: int
        :param _UserType: Account type. 0: guest user; 1: standard user; 2: administrator user; 999: null (Windows only)
        :type UserType: int
        :param _IsDomain: Whether a domain account. 0: no; 1: yes; 2: no; 999: null (Windows only)
        :type IsDomain: int
        :param _IsSudo: Whether there is sudo permissions: 1: yes; 0: No; 999: null (Linux only)
        :type IsSudo: int
        :param _IsSshLogin: Whether ssh log-in allowed. 1: yes; 0: no; 999: null (Linux only)
        :type IsSshLogin: int
        :param _HomePath: Home directory
        :type HomePath: str
        :param _Shell: Shell path (Linux only)
        :type Shell: str
        :param _ShellLoginStatus: Whether shell log-in allowed. 0: no; 1: yes (Linux only)
        :type ShellLoginStatus: int
        :param _PasswordChangeTime: Password modification time
        :type PasswordChangeTime: str
        :param _PasswordDueTime: Password expiration time (Linux only)
        :type PasswordDueTime: str
        :param _PasswordLockDays: Password locking time (unit: day): -1 - never locked; 999 - null (Linux only)
        :type PasswordLockDays: int
        :param _PasswordStatus: Password status: 1 - normal; 2 - expiring soon; 3 - expired; 4 - locked; 999 - null (Linux only)
        :type PasswordStatus: int
        :param _UpdateTime: Update time
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateTime: str
        :param _FirstTime: First collection time
        :type FirstTime: str
        :param _IsNew: Whether new [0: no|1: yes]
        :type IsNew: int
        :param _MachineExtraInfo: Additional information
Note: This field may return null, indicating that no valid values can be obtained.
        :type MachineExtraInfo: :class:`tencentcloud.cwp.v20180228.models.MachineExtraInfo`
        """
        self._MachineIp = None
        self._MachineWanIp = None
        self._MachineName = None
        self._OsInfo = None
        self._Uuid = None
        self._Quuid = None
        self._Uid = None
        self._Gid = None
        self._Status = None
        self._IsRoot = None
        self._LoginType = None
        self._LastLoginTime = None
        self._Name = None
        self._ProjectId = None
        self._UserType = None
        self._IsDomain = None
        self._IsSudo = None
        self._IsSshLogin = None
        self._HomePath = None
        self._Shell = None
        self._ShellLoginStatus = None
        self._PasswordChangeTime = None
        self._PasswordDueTime = None
        self._PasswordLockDays = None
        self._PasswordStatus = None
        self._UpdateTime = None
        self._FirstTime = None
        self._IsNew = None
        self._MachineExtraInfo = None

    @property
    def MachineIp(self):
        return self._MachineIp

    @MachineIp.setter
    def MachineIp(self, MachineIp):
        self._MachineIp = MachineIp

    @property
    def MachineWanIp(self):
        return self._MachineWanIp

    @MachineWanIp.setter
    def MachineWanIp(self, MachineWanIp):
        self._MachineWanIp = MachineWanIp

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def OsInfo(self):
        return self._OsInfo

    @OsInfo.setter
    def OsInfo(self, OsInfo):
        self._OsInfo = OsInfo

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uid(self):
        return self._Uid

    @Uid.setter
    def Uid(self, Uid):
        self._Uid = Uid

    @property
    def Gid(self):
        return self._Gid

    @Gid.setter
    def Gid(self, Gid):
        self._Gid = Gid

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def IsRoot(self):
        return self._IsRoot

    @IsRoot.setter
    def IsRoot(self, IsRoot):
        self._IsRoot = IsRoot

    @property
    def LoginType(self):
        return self._LoginType

    @LoginType.setter
    def LoginType(self, LoginType):
        self._LoginType = LoginType

    @property
    def LastLoginTime(self):
        return self._LastLoginTime

    @LastLoginTime.setter
    def LastLoginTime(self, LastLoginTime):
        self._LastLoginTime = LastLoginTime

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def UserType(self):
        return self._UserType

    @UserType.setter
    def UserType(self, UserType):
        self._UserType = UserType

    @property
    def IsDomain(self):
        return self._IsDomain

    @IsDomain.setter
    def IsDomain(self, IsDomain):
        self._IsDomain = IsDomain

    @property
    def IsSudo(self):
        return self._IsSudo

    @IsSudo.setter
    def IsSudo(self, IsSudo):
        self._IsSudo = IsSudo

    @property
    def IsSshLogin(self):
        return self._IsSshLogin

    @IsSshLogin.setter
    def IsSshLogin(self, IsSshLogin):
        self._IsSshLogin = IsSshLogin

    @property
    def HomePath(self):
        return self._HomePath

    @HomePath.setter
    def HomePath(self, HomePath):
        self._HomePath = HomePath

    @property
    def Shell(self):
        return self._Shell

    @Shell.setter
    def Shell(self, Shell):
        self._Shell = Shell

    @property
    def ShellLoginStatus(self):
        return self._ShellLoginStatus

    @ShellLoginStatus.setter
    def ShellLoginStatus(self, ShellLoginStatus):
        self._ShellLoginStatus = ShellLoginStatus

    @property
    def PasswordChangeTime(self):
        return self._PasswordChangeTime

    @PasswordChangeTime.setter
    def PasswordChangeTime(self, PasswordChangeTime):
        self._PasswordChangeTime = PasswordChangeTime

    @property
    def PasswordDueTime(self):
        return self._PasswordDueTime

    @PasswordDueTime.setter
    def PasswordDueTime(self, PasswordDueTime):
        self._PasswordDueTime = PasswordDueTime

    @property
    def PasswordLockDays(self):
        return self._PasswordLockDays

    @PasswordLockDays.setter
    def PasswordLockDays(self, PasswordLockDays):
        self._PasswordLockDays = PasswordLockDays

    @property
    def PasswordStatus(self):
        return self._PasswordStatus

    @PasswordStatus.setter
    def PasswordStatus(self, PasswordStatus):
        self._PasswordStatus = PasswordStatus

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def FirstTime(self):
        return self._FirstTime

    @FirstTime.setter
    def FirstTime(self, FirstTime):
        self._FirstTime = FirstTime

    @property
    def IsNew(self):
        return self._IsNew

    @IsNew.setter
    def IsNew(self, IsNew):
        self._IsNew = IsNew

    @property
    def MachineExtraInfo(self):
        return self._MachineExtraInfo

    @MachineExtraInfo.setter
    def MachineExtraInfo(self, MachineExtraInfo):
        self._MachineExtraInfo = MachineExtraInfo


    def _deserialize(self, params):
        self._MachineIp = params.get("MachineIp")
        self._MachineWanIp = params.get("MachineWanIp")
        self._MachineName = params.get("MachineName")
        self._OsInfo = params.get("OsInfo")
        self._Uuid = params.get("Uuid")
        self._Quuid = params.get("Quuid")
        self._Uid = params.get("Uid")
        self._Gid = params.get("Gid")
        self._Status = params.get("Status")
        self._IsRoot = params.get("IsRoot")
        self._LoginType = params.get("LoginType")
        self._LastLoginTime = params.get("LastLoginTime")
        self._Name = params.get("Name")
        self._ProjectId = params.get("ProjectId")
        self._UserType = params.get("UserType")
        self._IsDomain = params.get("IsDomain")
        self._IsSudo = params.get("IsSudo")
        self._IsSshLogin = params.get("IsSshLogin")
        self._HomePath = params.get("HomePath")
        self._Shell = params.get("Shell")
        self._ShellLoginStatus = params.get("ShellLoginStatus")
        self._PasswordChangeTime = params.get("PasswordChangeTime")
        self._PasswordDueTime = params.get("PasswordDueTime")
        self._PasswordLockDays = params.get("PasswordLockDays")
        self._PasswordStatus = params.get("PasswordStatus")
        self._UpdateTime = params.get("UpdateTime")
        self._FirstTime = params.get("FirstTime")
        self._IsNew = params.get("IsNew")
        if params.get("MachineExtraInfo") is not None:
            self._MachineExtraInfo = MachineExtraInfo()
            self._MachineExtraInfo._deserialize(params.get("MachineExtraInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetUserDetail(AbstractModel):
    """Basic information for resource management account

    """

    def __init__(self):
        r"""
        :param _MachineIp: Host private IP address
        :type MachineIp: str
        :param _MachineName: Host name
        :type MachineName: str
        :param _Uuid: Host UUID
        :type Uuid: str
        :param _Quuid: Host QUUID
        :type Quuid: str
        :param _Uid: Account UID
        :type Uid: str
        :param _Gid: Account GID
        :type Gid: str
        :param _Status: Account status. 0: disabled; 1: enabled.
        :type Status: int
        :param _IsRoot: Whether there is root permission. 0: no; 1: yes; 999: null (Linux only).
        :type IsRoot: int
        :param _LastLoginTime: Last log-in time
        :type LastLoginTime: str
        :param _Name: Account name
        :type Name: str
        :param _UserType: Account type. 0: guest user; 1: standard user; 2: administrator user; 999: null (Windows only).
        :type UserType: int
        :param _IsDomain: Whether the account is a domain account. 0: no; 1: yes; 999: null (Windows only).
        :type IsDomain: int
        :param _IsSshLogin: Whether SSH log-in allowed. 1: yes; 0: no; 999: null (Linux only).
        :type IsSshLogin: int
        :param _HomePath: Home directory
        :type HomePath: str
        :param _Shell: Shell path (Linux only)
        :type Shell: str
        :param _ShellLoginStatus: Whether shell log-in allowed. 0: no; 1: yes (Linux only).
        :type ShellLoginStatus: int
        :param _PasswordChangeTime: Password modification time
        :type PasswordChangeTime: str
        :param _PasswordDueTime: Password expiration time (Linux only)
        :type PasswordDueTime: str
        :param _PasswordLockDays: Password locking time (unit: day). -1: never locked; 999: null (Linux only).
        :type PasswordLockDays: int
        :param _Remark: Remarks
        :type Remark: str
        :param _GroupName: User group name
        :type GroupName: str
        :param _DisableTime: Account expiration time
        :type DisableTime: str
        :param _LastLoginTerminal: Last log-in terminal
        :type LastLoginTerminal: str
        :param _LastLoginLoc: Last log-in location
        :type LastLoginLoc: str
        :param _LastLoginIp: Last log-in IP address
        :type LastLoginIp: str
        :param _PasswordWarnDays: Password expiration reminder, in days
        :type PasswordWarnDays: int
        :param _PasswordChangeType: Password change settings. 0: not allowed; 1: allowed.
        :type PasswordChangeType: int
        :param _Keys: User public key listNote: This field may return null, indicating that no valid values can be obtained.
        :type Keys: list of AssetUserKeyInfo
        :param _UpdateTime: Data update time
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateTime: str
        """
        self._MachineIp = None
        self._MachineName = None
        self._Uuid = None
        self._Quuid = None
        self._Uid = None
        self._Gid = None
        self._Status = None
        self._IsRoot = None
        self._LastLoginTime = None
        self._Name = None
        self._UserType = None
        self._IsDomain = None
        self._IsSshLogin = None
        self._HomePath = None
        self._Shell = None
        self._ShellLoginStatus = None
        self._PasswordChangeTime = None
        self._PasswordDueTime = None
        self._PasswordLockDays = None
        self._Remark = None
        self._GroupName = None
        self._DisableTime = None
        self._LastLoginTerminal = None
        self._LastLoginLoc = None
        self._LastLoginIp = None
        self._PasswordWarnDays = None
        self._PasswordChangeType = None
        self._Keys = None
        self._UpdateTime = None

    @property
    def MachineIp(self):
        return self._MachineIp

    @MachineIp.setter
    def MachineIp(self, MachineIp):
        self._MachineIp = MachineIp

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uid(self):
        return self._Uid

    @Uid.setter
    def Uid(self, Uid):
        self._Uid = Uid

    @property
    def Gid(self):
        return self._Gid

    @Gid.setter
    def Gid(self, Gid):
        self._Gid = Gid

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def IsRoot(self):
        return self._IsRoot

    @IsRoot.setter
    def IsRoot(self, IsRoot):
        self._IsRoot = IsRoot

    @property
    def LastLoginTime(self):
        return self._LastLoginTime

    @LastLoginTime.setter
    def LastLoginTime(self, LastLoginTime):
        self._LastLoginTime = LastLoginTime

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def UserType(self):
        return self._UserType

    @UserType.setter
    def UserType(self, UserType):
        self._UserType = UserType

    @property
    def IsDomain(self):
        return self._IsDomain

    @IsDomain.setter
    def IsDomain(self, IsDomain):
        self._IsDomain = IsDomain

    @property
    def IsSshLogin(self):
        return self._IsSshLogin

    @IsSshLogin.setter
    def IsSshLogin(self, IsSshLogin):
        self._IsSshLogin = IsSshLogin

    @property
    def HomePath(self):
        return self._HomePath

    @HomePath.setter
    def HomePath(self, HomePath):
        self._HomePath = HomePath

    @property
    def Shell(self):
        return self._Shell

    @Shell.setter
    def Shell(self, Shell):
        self._Shell = Shell

    @property
    def ShellLoginStatus(self):
        return self._ShellLoginStatus

    @ShellLoginStatus.setter
    def ShellLoginStatus(self, ShellLoginStatus):
        self._ShellLoginStatus = ShellLoginStatus

    @property
    def PasswordChangeTime(self):
        return self._PasswordChangeTime

    @PasswordChangeTime.setter
    def PasswordChangeTime(self, PasswordChangeTime):
        self._PasswordChangeTime = PasswordChangeTime

    @property
    def PasswordDueTime(self):
        return self._PasswordDueTime

    @PasswordDueTime.setter
    def PasswordDueTime(self, PasswordDueTime):
        self._PasswordDueTime = PasswordDueTime

    @property
    def PasswordLockDays(self):
        return self._PasswordLockDays

    @PasswordLockDays.setter
    def PasswordLockDays(self, PasswordLockDays):
        self._PasswordLockDays = PasswordLockDays

    @property
    def Remark(self):
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def GroupName(self):
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName

    @property
    def DisableTime(self):
        return self._DisableTime

    @DisableTime.setter
    def DisableTime(self, DisableTime):
        self._DisableTime = DisableTime

    @property
    def LastLoginTerminal(self):
        return self._LastLoginTerminal

    @LastLoginTerminal.setter
    def LastLoginTerminal(self, LastLoginTerminal):
        self._LastLoginTerminal = LastLoginTerminal

    @property
    def LastLoginLoc(self):
        return self._LastLoginLoc

    @LastLoginLoc.setter
    def LastLoginLoc(self, LastLoginLoc):
        self._LastLoginLoc = LastLoginLoc

    @property
    def LastLoginIp(self):
        return self._LastLoginIp

    @LastLoginIp.setter
    def LastLoginIp(self, LastLoginIp):
        self._LastLoginIp = LastLoginIp

    @property
    def PasswordWarnDays(self):
        return self._PasswordWarnDays

    @PasswordWarnDays.setter
    def PasswordWarnDays(self, PasswordWarnDays):
        self._PasswordWarnDays = PasswordWarnDays

    @property
    def PasswordChangeType(self):
        return self._PasswordChangeType

    @PasswordChangeType.setter
    def PasswordChangeType(self, PasswordChangeType):
        self._PasswordChangeType = PasswordChangeType

    @property
    def Keys(self):
        return self._Keys

    @Keys.setter
    def Keys(self, Keys):
        self._Keys = Keys

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._MachineIp = params.get("MachineIp")
        self._MachineName = params.get("MachineName")
        self._Uuid = params.get("Uuid")
        self._Quuid = params.get("Quuid")
        self._Uid = params.get("Uid")
        self._Gid = params.get("Gid")
        self._Status = params.get("Status")
        self._IsRoot = params.get("IsRoot")
        self._LastLoginTime = params.get("LastLoginTime")
        self._Name = params.get("Name")
        self._UserType = params.get("UserType")
        self._IsDomain = params.get("IsDomain")
        self._IsSshLogin = params.get("IsSshLogin")
        self._HomePath = params.get("HomePath")
        self._Shell = params.get("Shell")
        self._ShellLoginStatus = params.get("ShellLoginStatus")
        self._PasswordChangeTime = params.get("PasswordChangeTime")
        self._PasswordDueTime = params.get("PasswordDueTime")
        self._PasswordLockDays = params.get("PasswordLockDays")
        self._Remark = params.get("Remark")
        self._GroupName = params.get("GroupName")
        self._DisableTime = params.get("DisableTime")
        self._LastLoginTerminal = params.get("LastLoginTerminal")
        self._LastLoginLoc = params.get("LastLoginLoc")
        self._LastLoginIp = params.get("LastLoginIp")
        self._PasswordWarnDays = params.get("PasswordWarnDays")
        self._PasswordChangeType = params.get("PasswordChangeType")
        if params.get("Keys") is not None:
            self._Keys = []
            for item in params.get("Keys"):
                obj = AssetUserKeyInfo()
                obj._deserialize(item)
                self._Keys.append(obj)
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetUserKeyInfo(AbstractModel):
    """Details of the asset management account key

    """

    def __init__(self):
        r"""
        :param _Value: Public key value
        :type Value: str
        :param _Comment: Public key remarks
        :type Comment: str
        :param _EncryptType: Encryption method
        :type EncryptType: str
        """
        self._Value = None
        self._Comment = None
        self._EncryptType = None

    @property
    def Value(self):
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def EncryptType(self):
        return self._EncryptType

    @EncryptType.setter
    def EncryptType(self, EncryptType):
        self._EncryptType = EncryptType


    def _deserialize(self, params):
        self._Value = params.get("Value")
        self._Comment = params.get("Comment")
        self._EncryptType = params.get("EncryptType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetWebAppBaseInfo(AbstractModel):
    """List of the information on the resource management web application

    """

    def __init__(self):
        r"""
        :param _MachineIp: Host private IP address
        :type MachineIp: str
        :param _MachineWanIp: Host public IP address
        :type MachineWanIp: str
        :param _Quuid: Host QUUID
        :type Quuid: str
        :param _Uuid: Host UUID
        :type Uuid: str
        :param _OsInfo: Operating system information
        :type OsInfo: str
        :param _ProjectId: Host business group ID
        :type ProjectId: int
        :param _Tag: Host tag
Note: This field may return null, indicating that no valid values can be obtained.
        :type Tag: list of MachineTag
        :param _Name: Application name
        :type Name: str
        :param _Version: Version
        :type Version: str
        :param _RootPath: Root path
        :type RootPath: str
        :param _ServiceType: Service type
        :type ServiceType: str
        :param _Domain: Site domain name
        :type Domain: str
        :param _VirtualPath: Virtual path
        :type VirtualPath: str
        :param _PluginCount: Number of plugins
        :type PluginCount: int
        :param _Id: Application ID
        :type Id: str
        :param _Desc: Application description
        :type Desc: str
        :param _MachineName: Host name
        :type MachineName: str
        :param _UpdateTime: Data update time
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateTime: str
        :param _FirstTime: First collection time
        :type FirstTime: str
        :param _IsNew: Whether it is newly added [0: no | 1: yes]
        :type IsNew: int
        :param _MachineExtraInfo: Additional information
Note: This field may return null, indicating that no valid values can be obtained.
        :type MachineExtraInfo: :class:`tencentcloud.cwp.v20180228.models.MachineExtraInfo`
        """
        self._MachineIp = None
        self._MachineWanIp = None
        self._Quuid = None
        self._Uuid = None
        self._OsInfo = None
        self._ProjectId = None
        self._Tag = None
        self._Name = None
        self._Version = None
        self._RootPath = None
        self._ServiceType = None
        self._Domain = None
        self._VirtualPath = None
        self._PluginCount = None
        self._Id = None
        self._Desc = None
        self._MachineName = None
        self._UpdateTime = None
        self._FirstTime = None
        self._IsNew = None
        self._MachineExtraInfo = None

    @property
    def MachineIp(self):
        return self._MachineIp

    @MachineIp.setter
    def MachineIp(self, MachineIp):
        self._MachineIp = MachineIp

    @property
    def MachineWanIp(self):
        return self._MachineWanIp

    @MachineWanIp.setter
    def MachineWanIp(self, MachineWanIp):
        self._MachineWanIp = MachineWanIp

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def OsInfo(self):
        return self._OsInfo

    @OsInfo.setter
    def OsInfo(self, OsInfo):
        self._OsInfo = OsInfo

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Tag(self):
        return self._Tag

    @Tag.setter
    def Tag(self, Tag):
        self._Tag = Tag

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Version(self):
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def RootPath(self):
        return self._RootPath

    @RootPath.setter
    def RootPath(self, RootPath):
        self._RootPath = RootPath

    @property
    def ServiceType(self):
        return self._ServiceType

    @ServiceType.setter
    def ServiceType(self, ServiceType):
        self._ServiceType = ServiceType

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def VirtualPath(self):
        return self._VirtualPath

    @VirtualPath.setter
    def VirtualPath(self, VirtualPath):
        self._VirtualPath = VirtualPath

    @property
    def PluginCount(self):
        return self._PluginCount

    @PluginCount.setter
    def PluginCount(self, PluginCount):
        self._PluginCount = PluginCount

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Desc(self):
        return self._Desc

    @Desc.setter
    def Desc(self, Desc):
        self._Desc = Desc

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def FirstTime(self):
        return self._FirstTime

    @FirstTime.setter
    def FirstTime(self, FirstTime):
        self._FirstTime = FirstTime

    @property
    def IsNew(self):
        return self._IsNew

    @IsNew.setter
    def IsNew(self, IsNew):
        self._IsNew = IsNew

    @property
    def MachineExtraInfo(self):
        return self._MachineExtraInfo

    @MachineExtraInfo.setter
    def MachineExtraInfo(self, MachineExtraInfo):
        self._MachineExtraInfo = MachineExtraInfo


    def _deserialize(self, params):
        self._MachineIp = params.get("MachineIp")
        self._MachineWanIp = params.get("MachineWanIp")
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._OsInfo = params.get("OsInfo")
        self._ProjectId = params.get("ProjectId")
        if params.get("Tag") is not None:
            self._Tag = []
            for item in params.get("Tag"):
                obj = MachineTag()
                obj._deserialize(item)
                self._Tag.append(obj)
        self._Name = params.get("Name")
        self._Version = params.get("Version")
        self._RootPath = params.get("RootPath")
        self._ServiceType = params.get("ServiceType")
        self._Domain = params.get("Domain")
        self._VirtualPath = params.get("VirtualPath")
        self._PluginCount = params.get("PluginCount")
        self._Id = params.get("Id")
        self._Desc = params.get("Desc")
        self._MachineName = params.get("MachineName")
        self._UpdateTime = params.get("UpdateTime")
        self._FirstTime = params.get("FirstTime")
        self._IsNew = params.get("IsNew")
        if params.get("MachineExtraInfo") is not None:
            self._MachineExtraInfo = MachineExtraInfo()
            self._MachineExtraInfo._deserialize(params.get("MachineExtraInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetWebAppPluginInfo(AbstractModel):
    """Details of web application plugin for asset management

    """

    def __init__(self):
        r"""
        :param _Name: Name
        :type Name: str
        :param _Desc: Description
        :type Desc: str
        :param _Version: Version
        :type Version: str
        :param _Link: Link
        :type Link: str
        """
        self._Name = None
        self._Desc = None
        self._Version = None
        self._Link = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Desc(self):
        return self._Desc

    @Desc.setter
    def Desc(self, Desc):
        self._Desc = Desc

    @property
    def Version(self):
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def Link(self):
        return self._Link

    @Link.setter
    def Link(self, Link):
        self._Link = Link


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Desc = params.get("Desc")
        self._Version = params.get("Version")
        self._Link = params.get("Link")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetWebFrameBaseInfo(AbstractModel):
    """Resource management Web application list information

    """

    def __init__(self):
        r"""
        :param _MachineIp: Host private IP address
        :type MachineIp: str
        :param _MachineWanIp: Host public IP address
        :type MachineWanIp: str
        :param _Quuid: Host QUUID
        :type Quuid: str
        :param _Uuid: Host UUID
        :type Uuid: str
        :param _OsInfo: Operating System Information
        :type OsInfo: str
        :param _ProjectId: Host business group ID
        :type ProjectId: int
        :param _Tag: Host tag
Note: This field may return null, indicating that no valid values can be obtained.
        :type Tag: list of MachineTag
        :param _Name: Database name
        :type Name: str
        :param _Version: Version
        :type Version: str
        :param _Lang: Language
        :type Lang: str
        :param _ServiceType: Service type
        :type ServiceType: str
        :param _MachineName: Host name
        :type MachineName: str
        :param _UpdateTime: Data update time
        :type UpdateTime: str
        :param _FirstTime: First collection time
        :type FirstTime: str
        :param _IsNew: Whether new [0: no|1: yes]
        :type IsNew: int
        :param _MachineExtraInfo: Additional information
Note: This field may return null, indicating that no valid values can be obtained.
        :type MachineExtraInfo: :class:`tencentcloud.cwp.v20180228.models.MachineExtraInfo`
        :param _Path: Application path
        :type Path: str
        """
        self._MachineIp = None
        self._MachineWanIp = None
        self._Quuid = None
        self._Uuid = None
        self._OsInfo = None
        self._ProjectId = None
        self._Tag = None
        self._Name = None
        self._Version = None
        self._Lang = None
        self._ServiceType = None
        self._MachineName = None
        self._UpdateTime = None
        self._FirstTime = None
        self._IsNew = None
        self._MachineExtraInfo = None
        self._Path = None

    @property
    def MachineIp(self):
        return self._MachineIp

    @MachineIp.setter
    def MachineIp(self, MachineIp):
        self._MachineIp = MachineIp

    @property
    def MachineWanIp(self):
        return self._MachineWanIp

    @MachineWanIp.setter
    def MachineWanIp(self, MachineWanIp):
        self._MachineWanIp = MachineWanIp

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def OsInfo(self):
        return self._OsInfo

    @OsInfo.setter
    def OsInfo(self, OsInfo):
        self._OsInfo = OsInfo

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Tag(self):
        return self._Tag

    @Tag.setter
    def Tag(self, Tag):
        self._Tag = Tag

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Version(self):
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def Lang(self):
        return self._Lang

    @Lang.setter
    def Lang(self, Lang):
        self._Lang = Lang

    @property
    def ServiceType(self):
        return self._ServiceType

    @ServiceType.setter
    def ServiceType(self, ServiceType):
        self._ServiceType = ServiceType

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def FirstTime(self):
        return self._FirstTime

    @FirstTime.setter
    def FirstTime(self, FirstTime):
        self._FirstTime = FirstTime

    @property
    def IsNew(self):
        return self._IsNew

    @IsNew.setter
    def IsNew(self, IsNew):
        self._IsNew = IsNew

    @property
    def MachineExtraInfo(self):
        return self._MachineExtraInfo

    @MachineExtraInfo.setter
    def MachineExtraInfo(self, MachineExtraInfo):
        self._MachineExtraInfo = MachineExtraInfo

    @property
    def Path(self):
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path


    def _deserialize(self, params):
        self._MachineIp = params.get("MachineIp")
        self._MachineWanIp = params.get("MachineWanIp")
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._OsInfo = params.get("OsInfo")
        self._ProjectId = params.get("ProjectId")
        if params.get("Tag") is not None:
            self._Tag = []
            for item in params.get("Tag"):
                obj = MachineTag()
                obj._deserialize(item)
                self._Tag.append(obj)
        self._Name = params.get("Name")
        self._Version = params.get("Version")
        self._Lang = params.get("Lang")
        self._ServiceType = params.get("ServiceType")
        self._MachineName = params.get("MachineName")
        self._UpdateTime = params.get("UpdateTime")
        self._FirstTime = params.get("FirstTime")
        self._IsNew = params.get("IsNew")
        if params.get("MachineExtraInfo") is not None:
            self._MachineExtraInfo = MachineExtraInfo()
            self._MachineExtraInfo._deserialize(params.get("MachineExtraInfo"))
        self._Path = params.get("Path")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetWebLocationBaseInfo(AbstractModel):
    """Asset management Web site list information

    """

    def __init__(self):
        r"""
        :param _Uuid: Host UUID
        :type Uuid: str
        :param _Quuid: Host QUUID
        :type Quuid: str
        :param _MachineIp: Private IP address
        :type MachineIp: str
        :param _MachineWanIp: Public IP address
        :type MachineWanIp: str
        :param _MachineName: Host name
        :type MachineName: str
        :param _OsInfo: Operating system
        :type OsInfo: str
        :param _Name: Domain name
        :type Name: str
        :param _Port: Site port
        :type Port: str
        :param _Proto: Site protocol
        :type Proto: str
        :param _ServiceType: Service type
        :type ServiceType: str
        :param _PathCount: Number of site paths
        :type PathCount: int
        :param _User: Running user
        :type User: str
        :param _MainPath: Home directory
        :type MainPath: str
        :param _MainPathOwner: Home directory owner
        :type MainPathOwner: str
        :param _Permission: Owner permissions
        :type Permission: str
        :param _ProjectId: Host business group ID
        :type ProjectId: int
        :param _Tag: Host tag
        :type Tag: list of MachineTag
        :param _Id: Web site ID
        :type Id: str
        :param _UpdateTime: Data update time
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateTime: str
        :param _FirstTime: First collection time
        :type FirstTime: str
        :param _IsNew: Whether the web service is newly added [0 - no|1 - yes]
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsNew: int
        :param _MachineExtraInfo: Additional information
Note: This field may return null, indicating that no valid values can be obtained.
        :type MachineExtraInfo: :class:`tencentcloud.cwp.v20180228.models.MachineExtraInfo`
        """
        self._Uuid = None
        self._Quuid = None
        self._MachineIp = None
        self._MachineWanIp = None
        self._MachineName = None
        self._OsInfo = None
        self._Name = None
        self._Port = None
        self._Proto = None
        self._ServiceType = None
        self._PathCount = None
        self._User = None
        self._MainPath = None
        self._MainPathOwner = None
        self._Permission = None
        self._ProjectId = None
        self._Tag = None
        self._Id = None
        self._UpdateTime = None
        self._FirstTime = None
        self._IsNew = None
        self._MachineExtraInfo = None

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def MachineIp(self):
        return self._MachineIp

    @MachineIp.setter
    def MachineIp(self, MachineIp):
        self._MachineIp = MachineIp

    @property
    def MachineWanIp(self):
        return self._MachineWanIp

    @MachineWanIp.setter
    def MachineWanIp(self, MachineWanIp):
        self._MachineWanIp = MachineWanIp

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def OsInfo(self):
        return self._OsInfo

    @OsInfo.setter
    def OsInfo(self, OsInfo):
        self._OsInfo = OsInfo

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Port(self):
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def Proto(self):
        return self._Proto

    @Proto.setter
    def Proto(self, Proto):
        self._Proto = Proto

    @property
    def ServiceType(self):
        return self._ServiceType

    @ServiceType.setter
    def ServiceType(self, ServiceType):
        self._ServiceType = ServiceType

    @property
    def PathCount(self):
        return self._PathCount

    @PathCount.setter
    def PathCount(self, PathCount):
        self._PathCount = PathCount

    @property
    def User(self):
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def MainPath(self):
        return self._MainPath

    @MainPath.setter
    def MainPath(self, MainPath):
        self._MainPath = MainPath

    @property
    def MainPathOwner(self):
        return self._MainPathOwner

    @MainPathOwner.setter
    def MainPathOwner(self, MainPathOwner):
        self._MainPathOwner = MainPathOwner

    @property
    def Permission(self):
        return self._Permission

    @Permission.setter
    def Permission(self, Permission):
        self._Permission = Permission

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Tag(self):
        return self._Tag

    @Tag.setter
    def Tag(self, Tag):
        self._Tag = Tag

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def FirstTime(self):
        return self._FirstTime

    @FirstTime.setter
    def FirstTime(self, FirstTime):
        self._FirstTime = FirstTime

    @property
    def IsNew(self):
        return self._IsNew

    @IsNew.setter
    def IsNew(self, IsNew):
        self._IsNew = IsNew

    @property
    def MachineExtraInfo(self):
        return self._MachineExtraInfo

    @MachineExtraInfo.setter
    def MachineExtraInfo(self, MachineExtraInfo):
        self._MachineExtraInfo = MachineExtraInfo


    def _deserialize(self, params):
        self._Uuid = params.get("Uuid")
        self._Quuid = params.get("Quuid")
        self._MachineIp = params.get("MachineIp")
        self._MachineWanIp = params.get("MachineWanIp")
        self._MachineName = params.get("MachineName")
        self._OsInfo = params.get("OsInfo")
        self._Name = params.get("Name")
        self._Port = params.get("Port")
        self._Proto = params.get("Proto")
        self._ServiceType = params.get("ServiceType")
        self._PathCount = params.get("PathCount")
        self._User = params.get("User")
        self._MainPath = params.get("MainPath")
        self._MainPathOwner = params.get("MainPathOwner")
        self._Permission = params.get("Permission")
        self._ProjectId = params.get("ProjectId")
        if params.get("Tag") is not None:
            self._Tag = []
            for item in params.get("Tag"):
                obj = MachineTag()
                obj._deserialize(item)
                self._Tag.append(obj)
        self._Id = params.get("Id")
        self._UpdateTime = params.get("UpdateTime")
        self._FirstTime = params.get("FirstTime")
        self._IsNew = params.get("IsNew")
        if params.get("MachineExtraInfo") is not None:
            self._MachineExtraInfo = MachineExtraInfo()
            self._MachineExtraInfo._deserialize(params.get("MachineExtraInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetWebLocationInfo(AbstractModel):
    """Asset management Web site list information

    """

    def __init__(self):
        r"""
        :param _Name: Domain name
        :type Name: str
        :param _Port: Site port
        :type Port: str
        :param _Proto: Site protocol
        :type Proto: str
        :param _ServiceType: Service type
        :type ServiceType: str
        :param _SafeStatus: Security module status. 0: not enabled; 1: enabled; 999: null (nginx only)
        :type SafeStatus: int
        :param _User: Running user
        :type User: str
        :param _MainPath: Home directory
        :type MainPath: str
        :param _Command: Startup command
        :type Command: str
        :param _Ip: Bind IP
        :type Ip: str
        :param _UpdateTime: Data update time
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateTime: str
        """
        self._Name = None
        self._Port = None
        self._Proto = None
        self._ServiceType = None
        self._SafeStatus = None
        self._User = None
        self._MainPath = None
        self._Command = None
        self._Ip = None
        self._UpdateTime = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Port(self):
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def Proto(self):
        return self._Proto

    @Proto.setter
    def Proto(self, Proto):
        self._Proto = Proto

    @property
    def ServiceType(self):
        return self._ServiceType

    @ServiceType.setter
    def ServiceType(self, ServiceType):
        self._ServiceType = ServiceType

    @property
    def SafeStatus(self):
        return self._SafeStatus

    @SafeStatus.setter
    def SafeStatus(self, SafeStatus):
        self._SafeStatus = SafeStatus

    @property
    def User(self):
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def MainPath(self):
        return self._MainPath

    @MainPath.setter
    def MainPath(self, MainPath):
        self._MainPath = MainPath

    @property
    def Command(self):
        return self._Command

    @Command.setter
    def Command(self, Command):
        self._Command = Command

    @property
    def Ip(self):
        return self._Ip

    @Ip.setter
    def Ip(self, Ip):
        self._Ip = Ip

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Port = params.get("Port")
        self._Proto = params.get("Proto")
        self._ServiceType = params.get("ServiceType")
        self._SafeStatus = params.get("SafeStatus")
        self._User = params.get("User")
        self._MainPath = params.get("MainPath")
        self._Command = params.get("Command")
        self._Ip = params.get("Ip")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetWebLocationPath(AbstractModel):
    """Virtual directory of the asset management web site

    """

    def __init__(self):
        r"""
        :param _VirtualPath: Virtual path
        :type VirtualPath: str
        :param _RealPath: Physical path
        :type RealPath: str
        :param _User: File owner
        :type User: str
        :param _Group: File group
        :type Group: str
        :param _Permission: File permission
        :type Permission: str
        """
        self._VirtualPath = None
        self._RealPath = None
        self._User = None
        self._Group = None
        self._Permission = None

    @property
    def VirtualPath(self):
        return self._VirtualPath

    @VirtualPath.setter
    def VirtualPath(self, VirtualPath):
        self._VirtualPath = VirtualPath

    @property
    def RealPath(self):
        return self._RealPath

    @RealPath.setter
    def RealPath(self, RealPath):
        self._RealPath = RealPath

    @property
    def User(self):
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def Group(self):
        return self._Group

    @Group.setter
    def Group(self, Group):
        self._Group = Group

    @property
    def Permission(self):
        return self._Permission

    @Permission.setter
    def Permission(self, Permission):
        self._Permission = Permission


    def _deserialize(self, params):
        self._VirtualPath = params.get("VirtualPath")
        self._RealPath = params.get("RealPath")
        self._User = params.get("User")
        self._Group = params.get("Group")
        self._Permission = params.get("Permission")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetWebServiceBaseInfo(AbstractModel):
    """List information on resource management Web service

    """

    def __init__(self):
        r"""
        :param _MachineIp: Private IP address of a host
        :type MachineIp: str
        :param _MachineWanIp: Public IP address of a host
        :type MachineWanIp: str
        :param _Quuid: Host QUUID
        :type Quuid: str
        :param _Uuid: Host UUID
        :type Uuid: str
        :param _OsInfo: Operating System Information
        :type OsInfo: str
        :param _ProjectId: Host business group ID
        :type ProjectId: int
        :param _Tag: Host tag
Note: This field may return null, indicating that no valid values can be obtained.
        :type Tag: list of MachineTag
        :param _Name: Database name
        :type Name: str
        :param _Version: Version
        :type Version: str
        :param _BinPath: Binary path
        :type BinPath: str
        :param _User: Startup user
        :type User: str
        :param _InstallPath: Installation path
        :type InstallPath: str
        :param _ConfigPath: Configuration path
        :type ConfigPath: str
        :param _ProcessCount: Number of associated processes
        :type ProcessCount: int
        :param _Id: Web Service ID
        :type Id: str
        :param _MachineName: Host name
        :type MachineName: str
        :param _Desc: Description
        :type Desc: str
        :param _UpdateTime: Data update time
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateTime: str
        :param _FirstTime: First collection time
        :type FirstTime: str
        :param _IsNew: Whether newly added [0: no|1: yes]
        :type IsNew: int
        :param _MachineExtraInfo: Additional information
Note: This field may return null, indicating that no valid values can be obtained.
        :type MachineExtraInfo: :class:`tencentcloud.cwp.v20180228.models.MachineExtraInfo`
        """
        self._MachineIp = None
        self._MachineWanIp = None
        self._Quuid = None
        self._Uuid = None
        self._OsInfo = None
        self._ProjectId = None
        self._Tag = None
        self._Name = None
        self._Version = None
        self._BinPath = None
        self._User = None
        self._InstallPath = None
        self._ConfigPath = None
        self._ProcessCount = None
        self._Id = None
        self._MachineName = None
        self._Desc = None
        self._UpdateTime = None
        self._FirstTime = None
        self._IsNew = None
        self._MachineExtraInfo = None

    @property
    def MachineIp(self):
        return self._MachineIp

    @MachineIp.setter
    def MachineIp(self, MachineIp):
        self._MachineIp = MachineIp

    @property
    def MachineWanIp(self):
        return self._MachineWanIp

    @MachineWanIp.setter
    def MachineWanIp(self, MachineWanIp):
        self._MachineWanIp = MachineWanIp

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def OsInfo(self):
        return self._OsInfo

    @OsInfo.setter
    def OsInfo(self, OsInfo):
        self._OsInfo = OsInfo

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Tag(self):
        return self._Tag

    @Tag.setter
    def Tag(self, Tag):
        self._Tag = Tag

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Version(self):
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def BinPath(self):
        return self._BinPath

    @BinPath.setter
    def BinPath(self, BinPath):
        self._BinPath = BinPath

    @property
    def User(self):
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def InstallPath(self):
        return self._InstallPath

    @InstallPath.setter
    def InstallPath(self, InstallPath):
        self._InstallPath = InstallPath

    @property
    def ConfigPath(self):
        return self._ConfigPath

    @ConfigPath.setter
    def ConfigPath(self, ConfigPath):
        self._ConfigPath = ConfigPath

    @property
    def ProcessCount(self):
        return self._ProcessCount

    @ProcessCount.setter
    def ProcessCount(self, ProcessCount):
        self._ProcessCount = ProcessCount

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def Desc(self):
        return self._Desc

    @Desc.setter
    def Desc(self, Desc):
        self._Desc = Desc

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def FirstTime(self):
        return self._FirstTime

    @FirstTime.setter
    def FirstTime(self, FirstTime):
        self._FirstTime = FirstTime

    @property
    def IsNew(self):
        return self._IsNew

    @IsNew.setter
    def IsNew(self, IsNew):
        self._IsNew = IsNew

    @property
    def MachineExtraInfo(self):
        return self._MachineExtraInfo

    @MachineExtraInfo.setter
    def MachineExtraInfo(self, MachineExtraInfo):
        self._MachineExtraInfo = MachineExtraInfo


    def _deserialize(self, params):
        self._MachineIp = params.get("MachineIp")
        self._MachineWanIp = params.get("MachineWanIp")
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._OsInfo = params.get("OsInfo")
        self._ProjectId = params.get("ProjectId")
        if params.get("Tag") is not None:
            self._Tag = []
            for item in params.get("Tag"):
                obj = MachineTag()
                obj._deserialize(item)
                self._Tag.append(obj)
        self._Name = params.get("Name")
        self._Version = params.get("Version")
        self._BinPath = params.get("BinPath")
        self._User = params.get("User")
        self._InstallPath = params.get("InstallPath")
        self._ConfigPath = params.get("ConfigPath")
        self._ProcessCount = params.get("ProcessCount")
        self._Id = params.get("Id")
        self._MachineName = params.get("MachineName")
        self._Desc = params.get("Desc")
        self._UpdateTime = params.get("UpdateTime")
        self._FirstTime = params.get("FirstTime")
        self._IsNew = params.get("IsNew")
        if params.get("MachineExtraInfo") is not None:
            self._MachineExtraInfo = MachineExtraInfo()
            self._MachineExtraInfo._deserialize(params.get("MachineExtraInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AttackSource(AbstractModel):
    """Attack backtracking

    """

    def __init__(self):
        r"""
        :param _Nodes: Attack backtracking node description
Note: This field may return null, indicating that no valid values can be obtained.
        :type Nodes: list of AttackSourceNode
        :param _Edges: Attack backtracking node path
Note: This field may return null, indicating that no valid values can be obtained.
        :type Edges: list of AttackSourceEdge
        :param _EventInfoParam: Parameters for requesting details on node-related events
Note: This field may return null, indicating that no valid values can be obtained.
        :type EventInfoParam: str
        """
        self._Nodes = None
        self._Edges = None
        self._EventInfoParam = None

    @property
    def Nodes(self):
        return self._Nodes

    @Nodes.setter
    def Nodes(self, Nodes):
        self._Nodes = Nodes

    @property
    def Edges(self):
        return self._Edges

    @Edges.setter
    def Edges(self, Edges):
        self._Edges = Edges

    @property
    def EventInfoParam(self):
        return self._EventInfoParam

    @EventInfoParam.setter
    def EventInfoParam(self, EventInfoParam):
        self._EventInfoParam = EventInfoParam


    def _deserialize(self, params):
        if params.get("Nodes") is not None:
            self._Nodes = []
            for item in params.get("Nodes"):
                obj = AttackSourceNode()
                obj._deserialize(item)
                self._Nodes.append(obj)
        if params.get("Edges") is not None:
            self._Edges = []
            for item in params.get("Edges"):
                obj = AttackSourceEdge()
                obj._deserialize(item)
                self._Edges.append(obj)
        self._EventInfoParam = params.get("EventInfoParam")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AttackSourceEdge(AbstractModel):
    """Attack backtracking path description

    """

    def __init__(self):
        r"""
        :param _From: Starting node
        :type From: str
        :param _To: Target node
        :type To: str
        """
        self._From = None
        self._To = None

    @property
    def From(self):
        return self._From

    @From.setter
    def From(self, From):
        self._From = From

    @property
    def To(self):
        return self._To

    @To.setter
    def To(self, To):
        self._To = To


    def _deserialize(self, params):
        self._From = params.get("From")
        self._To = params.get("To")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AttackSourceEvent(AbstractModel):
    """Attack backtracking event

    """

    def __init__(self):
        r"""
        :param _EventType: Event type. 0: virus scanning; 1: abnormal log-in; 2: password cracking; 3: malicious request; 4: high-risk command.
        :type EventType: int
        :param _Content: [Virus scanning] Virus name: VirusName, file name: FileName, file path: FilePath, file size: FileSize, file MD5: MD5, first detection time: CreateTime, last detection time: LatestScanTime, severity description: HarmDescribe, fixing suggestion: SuggestScheme
[Abnormal log-in] Source IP: SrcIp, location: Location, log-in username: UserName, log-in time: LoginTime
[Password cracking] Source IP: SrcIp, location: City and Country, protocol: Protocol, log-in username: UserName, port: Port, attempt count: Count, first attack time: CreateTime, last attack time: ModifyTime
[Malicious request] Malicious request domain name: Url, process: ProcessName, MD5: ProcessMd5, PID: Pid, request count: AccessCount, last request time: MergeTime, severity description: HarmDescribe, fixing suggestion: SuggestScheme
[High-risk command] Hit rule name: RuleName, rule category: RuleCategory, command content: BashCmd, data source: DetectBy, Log-in user: User, PID: Pid, occurrence time: CreateTime, severity description: HarmDescribe, fixing suggestion: SuggestScheme
        :type Content: str
        :param _CreatedTime: Intrusion time
        :type CreatedTime: str
        :param _Level: Unified event risk level. 0: prompt; 1: low; 2: medium; 3: high; 4: critical.
        :type Level: int
        :param _LevelZh: Risk level string in Chinese
        :type LevelZh: str
        :param _Id: Event ID
        :type Id: int
        :param _Uuid: Host UUID
        :type Uuid: str
        """
        self._EventType = None
        self._Content = None
        self._CreatedTime = None
        self._Level = None
        self._LevelZh = None
        self._Id = None
        self._Uuid = None

    @property
    def EventType(self):
        return self._EventType

    @EventType.setter
    def EventType(self, EventType):
        self._EventType = EventType

    @property
    def Content(self):
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content

    @property
    def CreatedTime(self):
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime

    @property
    def Level(self):
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level

    @property
    def LevelZh(self):
        return self._LevelZh

    @LevelZh.setter
    def LevelZh(self, LevelZh):
        self._LevelZh = LevelZh

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid


    def _deserialize(self, params):
        self._EventType = params.get("EventType")
        self._Content = params.get("Content")
        self._CreatedTime = params.get("CreatedTime")
        self._Level = params.get("Level")
        self._LevelZh = params.get("LevelZh")
        self._Id = params.get("Id")
        self._Uuid = params.get("Uuid")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AttackSourceNode(AbstractModel):
    """Attack backtracking node

    """

    def __init__(self):
        r"""
        :param _EventId: Event ID. If this parameter is left blank, no corresponding event exists.
        :type EventId: int
        :param _EventType: BRUTEFORCE: password cracking; MALWARE: Trojan; BASH: high-risk command; RISK_DNS: malicious request; LOGIN: cross-region log-in; HOST: host node; TIME_ORDER: general node.
        :type EventType: str
        :param _Ip: Node IP address. When the node is HOST, the value is the IP address of this node.
        :type Ip: str
        :param _Level: Level. 0: prompt; 1: low-risk; 2: medium-risk; 3: high-risk; 4: critical.
        :type Level: int
        :param _NodeId: Node ID
        :type NodeId: str
        :param _StartTime: Start time
        :type StartTime: str
        :param _EndTime: End time
        :type EndTime: str
        :param _NodeDesc: General node description
        :type NodeDesc: str
        :param _TimeLineNum: Timeline number. Nodes with the same number belong to the same timeline.
        :type TimeLineNum: int
        :param _NodeDetail: Node details
        :type NodeDetail: str
        """
        self._EventId = None
        self._EventType = None
        self._Ip = None
        self._Level = None
        self._NodeId = None
        self._StartTime = None
        self._EndTime = None
        self._NodeDesc = None
        self._TimeLineNum = None
        self._NodeDetail = None

    @property
    def EventId(self):
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId

    @property
    def EventType(self):
        return self._EventType

    @EventType.setter
    def EventType(self, EventType):
        self._EventType = EventType

    @property
    def Ip(self):
        return self._Ip

    @Ip.setter
    def Ip(self, Ip):
        self._Ip = Ip

    @property
    def Level(self):
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level

    @property
    def NodeId(self):
        return self._NodeId

    @NodeId.setter
    def NodeId(self, NodeId):
        self._NodeId = NodeId

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def NodeDesc(self):
        return self._NodeDesc

    @NodeDesc.setter
    def NodeDesc(self, NodeDesc):
        self._NodeDesc = NodeDesc

    @property
    def TimeLineNum(self):
        return self._TimeLineNum

    @TimeLineNum.setter
    def TimeLineNum(self, TimeLineNum):
        self._TimeLineNum = TimeLineNum

    @property
    def NodeDetail(self):
        return self._NodeDetail

    @NodeDetail.setter
    def NodeDetail(self, NodeDetail):
        self._NodeDetail = NodeDetail


    def _deserialize(self, params):
        self._EventId = params.get("EventId")
        self._EventType = params.get("EventType")
        self._Ip = params.get("Ip")
        self._Level = params.get("Level")
        self._NodeId = params.get("NodeId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._NodeDesc = params.get("NodeDesc")
        self._TimeLineNum = params.get("TimeLineNum")
        self._NodeDetail = params.get("NodeDetail")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BanWhiteList(AbstractModel):
    """Block allowlist rules

    """

    def __init__(self):
        r"""
        :param _Id: Allowlist IDs
        :type Id: str
        :param _Remark: Allowlist aliases
        :type Remark: str
        :param _SrcIp: Block source IP
        :type SrcIp: str
        :param _ModifyTime: Time of modifying allowlists
        :type ModifyTime: str
        :param _CreateTime: Time of creating allowlists
        :type CreateTime: str
        :param _Uuid: Machine associated with the allowlist
Note: This field may return null, indicating that no valid values can be obtained.
        :type Uuid: str
        :param _IsGlobal: Whether the allowlist is global
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsGlobal: bool
        :param _Quuids: Machine list associated with the allowlist
Note: This field may return null, indicating that no valid values can be obtained.
        :type Quuids: list of str
        """
        self._Id = None
        self._Remark = None
        self._SrcIp = None
        self._ModifyTime = None
        self._CreateTime = None
        self._Uuid = None
        self._IsGlobal = None
        self._Quuids = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Remark(self):
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def SrcIp(self):
        return self._SrcIp

    @SrcIp.setter
    def SrcIp(self, SrcIp):
        self._SrcIp = SrcIp

    @property
    def ModifyTime(self):
        return self._ModifyTime

    @ModifyTime.setter
    def ModifyTime(self, ModifyTime):
        self._ModifyTime = ModifyTime

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def IsGlobal(self):
        return self._IsGlobal

    @IsGlobal.setter
    def IsGlobal(self, IsGlobal):
        self._IsGlobal = IsGlobal

    @property
    def Quuids(self):
        return self._Quuids

    @Quuids.setter
    def Quuids(self, Quuids):
        self._Quuids = Quuids


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Remark = params.get("Remark")
        self._SrcIp = params.get("SrcIp")
        self._ModifyTime = params.get("ModifyTime")
        self._CreateTime = params.get("CreateTime")
        self._Uuid = params.get("Uuid")
        self._IsGlobal = params.get("IsGlobal")
        self._Quuids = params.get("Quuids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BanWhiteListDetail(AbstractModel):
    """List of displayed blocking allowlist information, including the machine information

    """

    def __init__(self):
        r"""
        :param _Id: Allowlist ID
        :type Id: str
        :param _Remark: Allowlist alias
        :type Remark: str
        :param _SrcIp: Blocking source IP address
        :type SrcIp: str
        :param _ModifyTime: Allowlist modification time
        :type ModifyTime: str
        :param _CreateTime: Allowlist creation time
        :type CreateTime: str
        :param _IsGlobal: Whether the allowlist takes effect globally
        :type IsGlobal: bool
        :param _Quuid: Machine UUID
        :type Quuid: str
        :param _Uuid: CWPP program UUID
        :type Uuid: str
        :param _MachineIp: Machine IP address
        :type MachineIp: str
        :param _MachineName: Machine name
        :type MachineName: str
        """
        self._Id = None
        self._Remark = None
        self._SrcIp = None
        self._ModifyTime = None
        self._CreateTime = None
        self._IsGlobal = None
        self._Quuid = None
        self._Uuid = None
        self._MachineIp = None
        self._MachineName = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Remark(self):
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def SrcIp(self):
        return self._SrcIp

    @SrcIp.setter
    def SrcIp(self, SrcIp):
        self._SrcIp = SrcIp

    @property
    def ModifyTime(self):
        return self._ModifyTime

    @ModifyTime.setter
    def ModifyTime(self, ModifyTime):
        self._ModifyTime = ModifyTime

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def IsGlobal(self):
        return self._IsGlobal

    @IsGlobal.setter
    def IsGlobal(self, IsGlobal):
        self._IsGlobal = IsGlobal

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def MachineIp(self):
        return self._MachineIp

    @MachineIp.setter
    def MachineIp(self, MachineIp):
        self._MachineIp = MachineIp

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Remark = params.get("Remark")
        self._SrcIp = params.get("SrcIp")
        self._ModifyTime = params.get("ModifyTime")
        self._CreateTime = params.get("CreateTime")
        self._IsGlobal = params.get("IsGlobal")
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._MachineIp = params.get("MachineIp")
        self._MachineName = params.get("MachineName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaselineBasicInfo(AbstractModel):
    """Basic baseline information

    """

    def __init__(self):
        r"""
        :param _Name: Baseline name
Note: This field may return null, indicating that no valid values can be obtained.
        :type Name: str
        :param _BaselineId: Baseline ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type BaselineId: int
        :param _ParentId: Parent ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type ParentId: int
        """
        self._Name = None
        self._BaselineId = None
        self._ParentId = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def BaselineId(self):
        return self._BaselineId

    @BaselineId.setter
    def BaselineId(self, BaselineId):
        self._BaselineId = BaselineId

    @property
    def ParentId(self):
        return self._ParentId

    @ParentId.setter
    def ParentId(self, ParentId):
        self._ParentId = ParentId


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._BaselineId = params.get("BaselineId")
        self._ParentId = params.get("ParentId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaselineCustomRuleIdName(AbstractModel):
    """Baseline Custom Rule ID and Name

    """

    def __init__(self):
        r"""
        :param _RuleId: Custom rule ID　
Note: This field may return null, indicating that no valid values can be obtained.
        :type RuleId: int
        :param _RuleName: Custom Rule Name
Note: This field may return null, indicating that no valid values can be obtained.
        :type RuleName: str
        """
        self._RuleId = None
        self._RuleName = None

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def RuleName(self):
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        self._RuleName = params.get("RuleName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaselineDetail(AbstractModel):
    """Baseline details

    """

    def __init__(self):
        r"""
        :param _Description: Baseline description
Note: This field may return null, indicating that no valid values can be obtained.
        :type Description: str
        :param _Level: Severity level
Note: This field may return null, indicating that no valid values can be obtained.
        :type Level: int
        :param _PackageName: Package name
Note: This field may return null, indicating that no valid values can be obtained.
        :type PackageName: str
        :param _ParentId: Parent ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type ParentId: int
        :param _Name: Baseline name
Note: This field may return null, indicating that no valid values can be obtained.
        :type Name: str
        """
        self._Description = None
        self._Level = None
        self._PackageName = None
        self._ParentId = None
        self._Name = None

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Level(self):
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level

    @property
    def PackageName(self):
        return self._PackageName

    @PackageName.setter
    def PackageName(self, PackageName):
        self._PackageName = PackageName

    @property
    def ParentId(self):
        return self._ParentId

    @ParentId.setter
    def ParentId(self, ParentId):
        self._ParentId = ParentId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Description = params.get("Description")
        self._Level = params.get("Level")
        self._PackageName = params.get("PackageName")
        self._ParentId = params.get("ParentId")
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaselineDetectParam(AbstractModel):
    """Baseline check parameters

    """

    def __init__(self):
        r"""
        :param _PolicyIds: Collection of check policies
        :type PolicyIds: list of int
        :param _RuleIds: Collection of check rules
        :type RuleIds: list of int
        :param _ItemIds: Collection of check items
        :type ItemIds: list of int
        :param _HostIds: Collection of checked server IDs
        :type HostIds: list of str
        """
        self._PolicyIds = None
        self._RuleIds = None
        self._ItemIds = None
        self._HostIds = None

    @property
    def PolicyIds(self):
        return self._PolicyIds

    @PolicyIds.setter
    def PolicyIds(self, PolicyIds):
        self._PolicyIds = PolicyIds

    @property
    def RuleIds(self):
        return self._RuleIds

    @RuleIds.setter
    def RuleIds(self, RuleIds):
        self._RuleIds = RuleIds

    @property
    def ItemIds(self):
        return self._ItemIds

    @ItemIds.setter
    def ItemIds(self, ItemIds):
        self._ItemIds = ItemIds

    @property
    def HostIds(self):
        return self._HostIds

    @HostIds.setter
    def HostIds(self, HostIds):
        self._HostIds = HostIds


    def _deserialize(self, params):
        self._PolicyIds = params.get("PolicyIds")
        self._RuleIds = params.get("RuleIds")
        self._ItemIds = params.get("ItemIds")
        self._HostIds = params.get("HostIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaselineEffectHost(AbstractModel):
    """Information on the host affected by baseline

    """

    def __init__(self):
        r"""
        :param _PassCount: Passed item
Note: This field may return null, indicating that no valid values can be obtained.
        :type PassCount: int
        :param _FailCount: Risky item
Note: This field may return null, indicating that no valid values can be obtained.
        :type FailCount: int
        :param _FirstScanTime: First check time
Note: This field may return null, indicating that no valid values can be obtained.
        :type FirstScanTime: str
        :param _LastScanTime: Last check time
Note: This field may return null, indicating that no valid values can be obtained.
        :type LastScanTime: str
        :param _Status: Risky item processing status. 0: failed; 1: passed.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Status: int
        :param _Quuid: Host QUUID
Note: This field may return null, indicating that no valid values can be obtained.
        :type Quuid: str
        :param _HostIp: Host IP address
Note: This field may return null, indicating that no valid values can be obtained.
        :type HostIp: str
        :param _AliasName: Host alias
Note: This field may return null, indicating that no valid values can be obtained.
        :type AliasName: str
        :param _Uuid: Host UUID
Note: This field may return null, indicating that no valid values can be obtained.
        :type Uuid: str
        :param _MaxStatus: Check status
Note: This field may return null, indicating that no valid values can be obtained.
        :type MaxStatus: int
        """
        self._PassCount = None
        self._FailCount = None
        self._FirstScanTime = None
        self._LastScanTime = None
        self._Status = None
        self._Quuid = None
        self._HostIp = None
        self._AliasName = None
        self._Uuid = None
        self._MaxStatus = None

    @property
    def PassCount(self):
        return self._PassCount

    @PassCount.setter
    def PassCount(self, PassCount):
        self._PassCount = PassCount

    @property
    def FailCount(self):
        return self._FailCount

    @FailCount.setter
    def FailCount(self, FailCount):
        self._FailCount = FailCount

    @property
    def FirstScanTime(self):
        return self._FirstScanTime

    @FirstScanTime.setter
    def FirstScanTime(self, FirstScanTime):
        self._FirstScanTime = FirstScanTime

    @property
    def LastScanTime(self):
        return self._LastScanTime

    @LastScanTime.setter
    def LastScanTime(self, LastScanTime):
        self._LastScanTime = LastScanTime

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def HostIp(self):
        return self._HostIp

    @HostIp.setter
    def HostIp(self, HostIp):
        self._HostIp = HostIp

    @property
    def AliasName(self):
        return self._AliasName

    @AliasName.setter
    def AliasName(self, AliasName):
        self._AliasName = AliasName

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def MaxStatus(self):
        return self._MaxStatus

    @MaxStatus.setter
    def MaxStatus(self, MaxStatus):
        self._MaxStatus = MaxStatus


    def _deserialize(self, params):
        self._PassCount = params.get("PassCount")
        self._FailCount = params.get("FailCount")
        self._FirstScanTime = params.get("FirstScanTime")
        self._LastScanTime = params.get("LastScanTime")
        self._Status = params.get("Status")
        self._Quuid = params.get("Quuid")
        self._HostIp = params.get("HostIp")
        self._AliasName = params.get("AliasName")
        self._Uuid = params.get("Uuid")
        self._MaxStatus = params.get("MaxStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaselineEventLevelInfo(AbstractModel):
    """Host information of Top server risks

    """

    def __init__(self):
        r"""
        :param _EventLevel: Hazard level: 1-Low-risk; 2-Medium-risk; 3-High-risk; 4-Critical
Note: This field may return null, indicating that no valid values can be obtained.
        :type EventLevel: int
        :param _EventCount: Number of vulnerabilities
Note: This field may return null, indicating that no valid values can be obtained.
        :type EventCount: int
        """
        self._EventLevel = None
        self._EventCount = None

    @property
    def EventLevel(self):
        return self._EventLevel

    @EventLevel.setter
    def EventLevel(self, EventLevel):
        self._EventLevel = EventLevel

    @property
    def EventCount(self):
        return self._EventCount

    @EventCount.setter
    def EventCount(self, EventCount):
        self._EventCount = EventCount


    def _deserialize(self, params):
        self._EventLevel = params.get("EventLevel")
        self._EventCount = params.get("EventCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaselineHost(AbstractModel):
    """Baseline host information

    """

    def __init__(self):
        r"""
        :param _HostId: Host ID
        :type HostId: str
        :param _HostName: Host name
Note: This field may return null, indicating that no valid values can be obtained.
        :type HostName: str
        :param _HostTag: Host tag
Note: This field may return null, indicating that no valid values can be obtained.
        :type HostTag: str
        :param _HostIp: Private IP address
Note: This field may return null, indicating that no valid values can be obtained.
        :type HostIp: str
        :param _WanIp: Public IP address
Note: This field may return null, indicating that no valid values can be obtained.
        :type WanIp: str
        :param _MachineExtraInfo: Host Additional Information
Note: This field may return null, indicating that no valid values can be obtained.
        :type MachineExtraInfo: :class:`tencentcloud.cwp.v20180228.models.MachineExtraInfo`
        """
        self._HostId = None
        self._HostName = None
        self._HostTag = None
        self._HostIp = None
        self._WanIp = None
        self._MachineExtraInfo = None

    @property
    def HostId(self):
        return self._HostId

    @HostId.setter
    def HostId(self, HostId):
        self._HostId = HostId

    @property
    def HostName(self):
        return self._HostName

    @HostName.setter
    def HostName(self, HostName):
        self._HostName = HostName

    @property
    def HostTag(self):
        return self._HostTag

    @HostTag.setter
    def HostTag(self, HostTag):
        self._HostTag = HostTag

    @property
    def HostIp(self):
        return self._HostIp

    @HostIp.setter
    def HostIp(self, HostIp):
        self._HostIp = HostIp

    @property
    def WanIp(self):
        return self._WanIp

    @WanIp.setter
    def WanIp(self, WanIp):
        self._WanIp = WanIp

    @property
    def MachineExtraInfo(self):
        return self._MachineExtraInfo

    @MachineExtraInfo.setter
    def MachineExtraInfo(self, MachineExtraInfo):
        self._MachineExtraInfo = MachineExtraInfo


    def _deserialize(self, params):
        self._HostId = params.get("HostId")
        self._HostName = params.get("HostName")
        self._HostTag = params.get("HostTag")
        self._HostIp = params.get("HostIp")
        self._WanIp = params.get("WanIp")
        if params.get("MachineExtraInfo") is not None:
            self._MachineExtraInfo = MachineExtraInfo()
            self._MachineExtraInfo._deserialize(params.get("MachineExtraInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaselineHostDetect(AbstractModel):
    """Baseline Host Detection

    """

    def __init__(self):
        r"""
        :param _HostId: Host ID
        :type HostId: str
        :param _HostIp: Private IP address
        :type HostIp: str
        :param _HostName: Host name
        :type HostName: str
        :param _WanIp: Public IP address
        :type WanIp: str
        :param _DetectStatus: 0: Failed; 1: Ignored; 3: Passed; 5: Under detection
        :type DetectStatus: int
        :param _PassedItemCount: Number of Passed Tasks in Detection
        :type PassedItemCount: int
        :param _ItemCount: Associated Detection Item Count
        :type ItemCount: int
        :param _NotPassedItemCount: Detection Failure Count
        :type NotPassedItemCount: int
        :param _FirstTime: First detection time
        :type FirstTime: str
        :param _LastTime: Last detection Time
        :type LastTime: str
        :param _Uuid: CWPP UUID
Note: This field may return null, indicating that no valid values can be obtained.
        :type Uuid: str
        :param _MachineExtraInfo: Host Additional Information
Note: This field may return null, indicating that no valid values can be obtained.
        :type MachineExtraInfo: :class:`tencentcloud.cwp.v20180228.models.MachineExtraInfo`
        """
        self._HostId = None
        self._HostIp = None
        self._HostName = None
        self._WanIp = None
        self._DetectStatus = None
        self._PassedItemCount = None
        self._ItemCount = None
        self._NotPassedItemCount = None
        self._FirstTime = None
        self._LastTime = None
        self._Uuid = None
        self._MachineExtraInfo = None

    @property
    def HostId(self):
        return self._HostId

    @HostId.setter
    def HostId(self, HostId):
        self._HostId = HostId

    @property
    def HostIp(self):
        return self._HostIp

    @HostIp.setter
    def HostIp(self, HostIp):
        self._HostIp = HostIp

    @property
    def HostName(self):
        return self._HostName

    @HostName.setter
    def HostName(self, HostName):
        self._HostName = HostName

    @property
    def WanIp(self):
        return self._WanIp

    @WanIp.setter
    def WanIp(self, WanIp):
        self._WanIp = WanIp

    @property
    def DetectStatus(self):
        return self._DetectStatus

    @DetectStatus.setter
    def DetectStatus(self, DetectStatus):
        self._DetectStatus = DetectStatus

    @property
    def PassedItemCount(self):
        return self._PassedItemCount

    @PassedItemCount.setter
    def PassedItemCount(self, PassedItemCount):
        self._PassedItemCount = PassedItemCount

    @property
    def ItemCount(self):
        return self._ItemCount

    @ItemCount.setter
    def ItemCount(self, ItemCount):
        self._ItemCount = ItemCount

    @property
    def NotPassedItemCount(self):
        return self._NotPassedItemCount

    @NotPassedItemCount.setter
    def NotPassedItemCount(self, NotPassedItemCount):
        self._NotPassedItemCount = NotPassedItemCount

    @property
    def FirstTime(self):
        return self._FirstTime

    @FirstTime.setter
    def FirstTime(self, FirstTime):
        self._FirstTime = FirstTime

    @property
    def LastTime(self):
        return self._LastTime

    @LastTime.setter
    def LastTime(self, LastTime):
        self._LastTime = LastTime

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def MachineExtraInfo(self):
        return self._MachineExtraInfo

    @MachineExtraInfo.setter
    def MachineExtraInfo(self, MachineExtraInfo):
        self._MachineExtraInfo = MachineExtraInfo


    def _deserialize(self, params):
        self._HostId = params.get("HostId")
        self._HostIp = params.get("HostIp")
        self._HostName = params.get("HostName")
        self._WanIp = params.get("WanIp")
        self._DetectStatus = params.get("DetectStatus")
        self._PassedItemCount = params.get("PassedItemCount")
        self._ItemCount = params.get("ItemCount")
        self._NotPassedItemCount = params.get("NotPassedItemCount")
        self._FirstTime = params.get("FirstTime")
        self._LastTime = params.get("LastTime")
        self._Uuid = params.get("Uuid")
        if params.get("MachineExtraInfo") is not None:
            self._MachineExtraInfo = MachineExtraInfo()
            self._MachineExtraInfo._deserialize(params.get("MachineExtraInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaselineHostTopList(AbstractModel):
    """Baseline affected servers list data

    """

    def __init__(self):
        r"""
        :param _EventLevelList: List of event levels and occurrences
Note: This field may return null, indicating that no valid values can be obtained.
        :type EventLevelList: list of BaselineEventLevelInfo
        :param _HostName: Host name
Note: This field may return null, indicating that no valid values can be obtained.
        :type HostName: str
        :param _Quuid: Host QUUID
Note: This field may return null, indicating that no valid values can be obtained.
        :type Quuid: str
        :param _Score: Score for calculating weight
Note: This field may return null, indicating that no valid values can be obtained.
        :type Score: int
        """
        self._EventLevelList = None
        self._HostName = None
        self._Quuid = None
        self._Score = None

    @property
    def EventLevelList(self):
        return self._EventLevelList

    @EventLevelList.setter
    def EventLevelList(self, EventLevelList):
        self._EventLevelList = EventLevelList

    @property
    def HostName(self):
        return self._HostName

    @HostName.setter
    def HostName(self, HostName):
        self._HostName = HostName

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Score(self):
        return self._Score

    @Score.setter
    def Score(self, Score):
        self._Score = Score


    def _deserialize(self, params):
        if params.get("EventLevelList") is not None:
            self._EventLevelList = []
            for item in params.get("EventLevelList"):
                obj = BaselineEventLevelInfo()
                obj._deserialize(item)
                self._EventLevelList.append(obj)
        self._HostName = params.get("HostName")
        self._Quuid = params.get("Quuid")
        self._Score = params.get("Score")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaselineInfo(AbstractModel):
    """Baseline Information

    """

    def __init__(self):
        r"""
        :param _Name: Baseline name
Note: This field may return null, indicating that no valid values can be obtained.
        :type Name: str
        :param _Level: Hazard level: 1-Low-risk; 2-Medium-risk; 3-High-risk; 4-Critical
Note: This field may return null, indicating that no valid values can be obtained.
        :type Level: int
        :param _RuleCount: Number of check items
Note: This field may return null, indicating that no valid values can be obtained.
        :type RuleCount: int
        :param _HostCount: Number of affected servers
Note: This field may return null, indicating that no valid values can be obtained.
        :type HostCount: int
        :param _Status: Pass status. 0: passed; 1: failed.Note: This field may return null, indicating that no valid values can be obtained.
        :type Status: int
        :param _CategoryId: Baseline ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type CategoryId: int
        :param _LastScanTime: Last check time
Note: This field may return null, indicating that no valid values can be obtained.
        :type LastScanTime: str
        :param _MaxStatus: 5: checking
Note: This field may return null, indicating that no valid values can be obtained.
        :type MaxStatus: int
        :param _BaselineFailCount: Baseline check items with risks
Note: This field may return null, indicating that no valid values can be obtained.
        :type BaselineFailCount: int
        """
        self._Name = None
        self._Level = None
        self._RuleCount = None
        self._HostCount = None
        self._Status = None
        self._CategoryId = None
        self._LastScanTime = None
        self._MaxStatus = None
        self._BaselineFailCount = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Level(self):
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level

    @property
    def RuleCount(self):
        return self._RuleCount

    @RuleCount.setter
    def RuleCount(self, RuleCount):
        self._RuleCount = RuleCount

    @property
    def HostCount(self):
        return self._HostCount

    @HostCount.setter
    def HostCount(self, HostCount):
        self._HostCount = HostCount

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def CategoryId(self):
        return self._CategoryId

    @CategoryId.setter
    def CategoryId(self, CategoryId):
        self._CategoryId = CategoryId

    @property
    def LastScanTime(self):
        return self._LastScanTime

    @LastScanTime.setter
    def LastScanTime(self, LastScanTime):
        self._LastScanTime = LastScanTime

    @property
    def MaxStatus(self):
        return self._MaxStatus

    @MaxStatus.setter
    def MaxStatus(self, MaxStatus):
        self._MaxStatus = MaxStatus

    @property
    def BaselineFailCount(self):
        return self._BaselineFailCount

    @BaselineFailCount.setter
    def BaselineFailCount(self, BaselineFailCount):
        self._BaselineFailCount = BaselineFailCount


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Level = params.get("Level")
        self._RuleCount = params.get("RuleCount")
        self._HostCount = params.get("HostCount")
        self._Status = params.get("Status")
        self._CategoryId = params.get("CategoryId")
        self._LastScanTime = params.get("LastScanTime")
        self._MaxStatus = params.get("MaxStatus")
        self._BaselineFailCount = params.get("BaselineFailCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaselineItem(AbstractModel):
    """Baseline Item

    """

    def __init__(self):
        r"""
        :param _ItemId: Item ID
        :type ItemId: int
        :param _ItemName: Item Name
        :type ItemName: str
        :param _CategoryId: Detection Item Classification
        :type CategoryId: int
        :param _ItemDesc: Item Description
        :type ItemDesc: str
        :param _FixMethod: Fixing Method
        :type FixMethod: str
        :param _RuleName: Rule
        :type RuleName: str
        :param _DetectResultDesc: Check result description
Note: This field may return null, indicating that no valid values can be obtained.
        :type DetectResultDesc: str
        :param _Level: Risk level
Note: This field may return null, indicating that no valid values can be obtained.
        :type Level: int
        :param _DetectStatus: Detection Status. 0: Failed; 1: Ignored; 3: Passed; 5: Under detection
Note: This field may return null, indicating that no valid values can be obtained.
        :type DetectStatus: int
        :param _HostId: Host ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type HostId: str
        :param _HostName: Host name
Note: This field may return null, indicating that no valid values can be obtained.
        :type HostName: str
        :param _HostIp: Host IP address
Note: This field may return null, indicating that no valid values can be obtained.
        :type HostIp: str
        :param _WanIp: Public IP address
Note: This field may return null, indicating that no valid values can be obtained.
        :type WanIp: str
        :param _FirstTime: First Occurrence Time
Note: This field may return null, indicating that no valid values can be obtained.
        :type FirstTime: str
        :param _LastTime: Last Occurrence Time
Note: This field may return null, indicating that no valid values can be obtained.
        :type LastTime: str
        :param _CanBeFixed: Can Be Fixed or Not
Note: This field may return null, indicating that no valid values can be obtained.
        :type CanBeFixed: int
        :param _Uuid: Host Security UUID
Note: This field may return null, indicating that no valid values can be obtained.
        :type Uuid: str
        :param _MachineExtraInfo: Host Additional Information
Note: This field may return null, indicating that no valid values can be obtained.
        :type MachineExtraInfo: :class:`tencentcloud.cwp.v20180228.models.MachineExtraInfo`
        """
        self._ItemId = None
        self._ItemName = None
        self._CategoryId = None
        self._ItemDesc = None
        self._FixMethod = None
        self._RuleName = None
        self._DetectResultDesc = None
        self._Level = None
        self._DetectStatus = None
        self._HostId = None
        self._HostName = None
        self._HostIp = None
        self._WanIp = None
        self._FirstTime = None
        self._LastTime = None
        self._CanBeFixed = None
        self._Uuid = None
        self._MachineExtraInfo = None

    @property
    def ItemId(self):
        return self._ItemId

    @ItemId.setter
    def ItemId(self, ItemId):
        self._ItemId = ItemId

    @property
    def ItemName(self):
        return self._ItemName

    @ItemName.setter
    def ItemName(self, ItemName):
        self._ItemName = ItemName

    @property
    def CategoryId(self):
        return self._CategoryId

    @CategoryId.setter
    def CategoryId(self, CategoryId):
        self._CategoryId = CategoryId

    @property
    def ItemDesc(self):
        return self._ItemDesc

    @ItemDesc.setter
    def ItemDesc(self, ItemDesc):
        self._ItemDesc = ItemDesc

    @property
    def FixMethod(self):
        return self._FixMethod

    @FixMethod.setter
    def FixMethod(self, FixMethod):
        self._FixMethod = FixMethod

    @property
    def RuleName(self):
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName

    @property
    def DetectResultDesc(self):
        return self._DetectResultDesc

    @DetectResultDesc.setter
    def DetectResultDesc(self, DetectResultDesc):
        self._DetectResultDesc = DetectResultDesc

    @property
    def Level(self):
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level

    @property
    def DetectStatus(self):
        return self._DetectStatus

    @DetectStatus.setter
    def DetectStatus(self, DetectStatus):
        self._DetectStatus = DetectStatus

    @property
    def HostId(self):
        return self._HostId

    @HostId.setter
    def HostId(self, HostId):
        self._HostId = HostId

    @property
    def HostName(self):
        return self._HostName

    @HostName.setter
    def HostName(self, HostName):
        self._HostName = HostName

    @property
    def HostIp(self):
        return self._HostIp

    @HostIp.setter
    def HostIp(self, HostIp):
        self._HostIp = HostIp

    @property
    def WanIp(self):
        return self._WanIp

    @WanIp.setter
    def WanIp(self, WanIp):
        self._WanIp = WanIp

    @property
    def FirstTime(self):
        return self._FirstTime

    @FirstTime.setter
    def FirstTime(self, FirstTime):
        self._FirstTime = FirstTime

    @property
    def LastTime(self):
        return self._LastTime

    @LastTime.setter
    def LastTime(self, LastTime):
        self._LastTime = LastTime

    @property
    def CanBeFixed(self):
        return self._CanBeFixed

    @CanBeFixed.setter
    def CanBeFixed(self, CanBeFixed):
        self._CanBeFixed = CanBeFixed

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def MachineExtraInfo(self):
        return self._MachineExtraInfo

    @MachineExtraInfo.setter
    def MachineExtraInfo(self, MachineExtraInfo):
        self._MachineExtraInfo = MachineExtraInfo


    def _deserialize(self, params):
        self._ItemId = params.get("ItemId")
        self._ItemName = params.get("ItemName")
        self._CategoryId = params.get("CategoryId")
        self._ItemDesc = params.get("ItemDesc")
        self._FixMethod = params.get("FixMethod")
        self._RuleName = params.get("RuleName")
        self._DetectResultDesc = params.get("DetectResultDesc")
        self._Level = params.get("Level")
        self._DetectStatus = params.get("DetectStatus")
        self._HostId = params.get("HostId")
        self._HostName = params.get("HostName")
        self._HostIp = params.get("HostIp")
        self._WanIp = params.get("WanIp")
        self._FirstTime = params.get("FirstTime")
        self._LastTime = params.get("LastTime")
        self._CanBeFixed = params.get("CanBeFixed")
        self._Uuid = params.get("Uuid")
        if params.get("MachineExtraInfo") is not None:
            self._MachineExtraInfo = MachineExtraInfo()
            self._MachineExtraInfo._deserialize(params.get("MachineExtraInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaselineItemDetect(AbstractModel):
    """Baseline detection item

    """

    def __init__(self):
        r"""
        :param _ItemId: Item ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type ItemId: int
        :param _ItemName: Item Name
Note: This field may return null, indicating that no valid values can be obtained.
        :type ItemName: str
        :param _ItemDesc: Item Description
Note: This field may return null, indicating that no valid values can be obtained.
        :type ItemDesc: str
        :param _FixMethod: Fixing Method
Note: This field may return null, indicating that no valid values can be obtained.
        :type FixMethod: str
        :param _RuleName: Rule
Note: This field may return null, indicating that no valid values can be obtained.
        :type RuleName: str
        :param _DetectStatus: 0: Failed; 1: Ignored; 3: Passed; 5: Under detection
Note: This field may return null, indicating that no valid values can be obtained.
        :type DetectStatus: int
        :param _Level: Risk level
Note: This field may return null, indicating that no valid values can be obtained.
        :type Level: int
        :param _HostCount: Number of affected servers
Note: This field may return null, indicating that no valid values can be obtained.
        :type HostCount: int
        :param _FirstTime: First detection time
Note: This field may return null, indicating that no valid values can be obtained.
        :type FirstTime: str
        :param _LastTime: Last Detection Time
Note: This field may return null, indicating that no valid values can be obtained.
        :type LastTime: str
        :param _DetectResult: Detection result, JSON string
Note: This field may return null, indicating that no valid values can be obtained.
        :type DetectResult: str
        :param _RuleId: Rule ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type RuleId: int
        :param _PassedHostCount: Number of servers passed
Note: This field may return null, indicating that no valid values can be obtained.
        :type PassedHostCount: int
        :param _NotPassedHostCount: Number of servers failed
Note: This field may return null, indicating that no valid values can be obtained.
        :type NotPassedHostCount: int
        """
        self._ItemId = None
        self._ItemName = None
        self._ItemDesc = None
        self._FixMethod = None
        self._RuleName = None
        self._DetectStatus = None
        self._Level = None
        self._HostCount = None
        self._FirstTime = None
        self._LastTime = None
        self._DetectResult = None
        self._RuleId = None
        self._PassedHostCount = None
        self._NotPassedHostCount = None

    @property
    def ItemId(self):
        return self._ItemId

    @ItemId.setter
    def ItemId(self, ItemId):
        self._ItemId = ItemId

    @property
    def ItemName(self):
        return self._ItemName

    @ItemName.setter
    def ItemName(self, ItemName):
        self._ItemName = ItemName

    @property
    def ItemDesc(self):
        return self._ItemDesc

    @ItemDesc.setter
    def ItemDesc(self, ItemDesc):
        self._ItemDesc = ItemDesc

    @property
    def FixMethod(self):
        return self._FixMethod

    @FixMethod.setter
    def FixMethod(self, FixMethod):
        self._FixMethod = FixMethod

    @property
    def RuleName(self):
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName

    @property
    def DetectStatus(self):
        return self._DetectStatus

    @DetectStatus.setter
    def DetectStatus(self, DetectStatus):
        self._DetectStatus = DetectStatus

    @property
    def Level(self):
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level

    @property
    def HostCount(self):
        return self._HostCount

    @HostCount.setter
    def HostCount(self, HostCount):
        self._HostCount = HostCount

    @property
    def FirstTime(self):
        return self._FirstTime

    @FirstTime.setter
    def FirstTime(self, FirstTime):
        self._FirstTime = FirstTime

    @property
    def LastTime(self):
        return self._LastTime

    @LastTime.setter
    def LastTime(self, LastTime):
        self._LastTime = LastTime

    @property
    def DetectResult(self):
        return self._DetectResult

    @DetectResult.setter
    def DetectResult(self, DetectResult):
        self._DetectResult = DetectResult

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def PassedHostCount(self):
        return self._PassedHostCount

    @PassedHostCount.setter
    def PassedHostCount(self, PassedHostCount):
        self._PassedHostCount = PassedHostCount

    @property
    def NotPassedHostCount(self):
        return self._NotPassedHostCount

    @NotPassedHostCount.setter
    def NotPassedHostCount(self, NotPassedHostCount):
        self._NotPassedHostCount = NotPassedHostCount


    def _deserialize(self, params):
        self._ItemId = params.get("ItemId")
        self._ItemName = params.get("ItemName")
        self._ItemDesc = params.get("ItemDesc")
        self._FixMethod = params.get("FixMethod")
        self._RuleName = params.get("RuleName")
        self._DetectStatus = params.get("DetectStatus")
        self._Level = params.get("Level")
        self._HostCount = params.get("HostCount")
        self._FirstTime = params.get("FirstTime")
        self._LastTime = params.get("LastTime")
        self._DetectResult = params.get("DetectResult")
        self._RuleId = params.get("RuleId")
        self._PassedHostCount = params.get("PassedHostCount")
        self._NotPassedHostCount = params.get("NotPassedHostCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaselineItemInfo(AbstractModel):
    """Baseline Information

    """

    def __init__(self):
        r"""
        :param _ItemId: Baseline Detection Item ID
        :type ItemId: int
        :param _ItemName: Detection Item Name
        :type ItemName: str
        :param _RuleId: ID of the Rule to Which the Detection Item Belongs
Note: This field may return null, indicating that no valid values can be obtained.
        :type RuleId: int
        :param _ItemDesc: Detection item description
        :type ItemDesc: str
        :param _FixMethod: Remediation Method for Inspection Items
        :type FixMethod: str
        :param _RuleName: Rule Name of Detection Item
        :type RuleName: str
        :param _Level: Risk level
        :type Level: int
        :param _SysRuleId: System Rule ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type SysRuleId: int
        :param _RelatedCustomRuleInfo: Referenced Custom Rule Information
Note: This field may return null, indicating that no valid values can be obtained.
        :type RelatedCustomRuleInfo: list of BaselineCustomRuleIdName
        """
        self._ItemId = None
        self._ItemName = None
        self._RuleId = None
        self._ItemDesc = None
        self._FixMethod = None
        self._RuleName = None
        self._Level = None
        self._SysRuleId = None
        self._RelatedCustomRuleInfo = None

    @property
    def ItemId(self):
        return self._ItemId

    @ItemId.setter
    def ItemId(self, ItemId):
        self._ItemId = ItemId

    @property
    def ItemName(self):
        return self._ItemName

    @ItemName.setter
    def ItemName(self, ItemName):
        self._ItemName = ItemName

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def ItemDesc(self):
        return self._ItemDesc

    @ItemDesc.setter
    def ItemDesc(self, ItemDesc):
        self._ItemDesc = ItemDesc

    @property
    def FixMethod(self):
        return self._FixMethod

    @FixMethod.setter
    def FixMethod(self, FixMethod):
        self._FixMethod = FixMethod

    @property
    def RuleName(self):
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName

    @property
    def Level(self):
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level

    @property
    def SysRuleId(self):
        return self._SysRuleId

    @SysRuleId.setter
    def SysRuleId(self, SysRuleId):
        self._SysRuleId = SysRuleId

    @property
    def RelatedCustomRuleInfo(self):
        return self._RelatedCustomRuleInfo

    @RelatedCustomRuleInfo.setter
    def RelatedCustomRuleInfo(self, RelatedCustomRuleInfo):
        self._RelatedCustomRuleInfo = RelatedCustomRuleInfo


    def _deserialize(self, params):
        self._ItemId = params.get("ItemId")
        self._ItemName = params.get("ItemName")
        self._RuleId = params.get("RuleId")
        self._ItemDesc = params.get("ItemDesc")
        self._FixMethod = params.get("FixMethod")
        self._RuleName = params.get("RuleName")
        self._Level = params.get("Level")
        self._SysRuleId = params.get("SysRuleId")
        if params.get("RelatedCustomRuleInfo") is not None:
            self._RelatedCustomRuleInfo = []
            for item in params.get("RelatedCustomRuleInfo"):
                obj = BaselineCustomRuleIdName()
                obj._deserialize(item)
                self._RelatedCustomRuleInfo.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaselinePolicy(AbstractModel):
    """Baseline policy information

    """

    def __init__(self):
        r"""
        :param _PolicyName: Policy name, which is no more than 128 English characters in length.
        :type PolicyName: str
        :param _DetectInterval: Detection interval [1: 1 day|3: 3 days|5: 5 days|7: 7 days]
        :type DetectInterval: int
        :param _DetectTime: Detection time
        :type DetectTime: str
        :param _IsEnabled: Whether enabled [0: not enabled|1: enabled]
        :type IsEnabled: int
        :param _AssetType: Asset type [0: all Professional and Ultimate editions|1: ID | 2: IP]
        :type AssetType: int
        :param _PolicyId: Policy ID
        :type PolicyId: int
        :param _RuleCount: Number of associated baseline items
        :type RuleCount: int
        :param _ItemCount: Number of associated baseline items
        :type ItemCount: int
        :param _HostCount: Number of associated baseline hosts
        :type HostCount: int
        :param _RuleIds: Rule ID
        :type RuleIds: list of int
        :param _HostIds: Host ID
        :type HostIds: list of str
        :param _HostIps: Host IP
        :type HostIps: list of str
        :param _IsDefault: Whether the system default
        :type IsDefault: int
        """
        self._PolicyName = None
        self._DetectInterval = None
        self._DetectTime = None
        self._IsEnabled = None
        self._AssetType = None
        self._PolicyId = None
        self._RuleCount = None
        self._ItemCount = None
        self._HostCount = None
        self._RuleIds = None
        self._HostIds = None
        self._HostIps = None
        self._IsDefault = None

    @property
    def PolicyName(self):
        return self._PolicyName

    @PolicyName.setter
    def PolicyName(self, PolicyName):
        self._PolicyName = PolicyName

    @property
    def DetectInterval(self):
        return self._DetectInterval

    @DetectInterval.setter
    def DetectInterval(self, DetectInterval):
        self._DetectInterval = DetectInterval

    @property
    def DetectTime(self):
        return self._DetectTime

    @DetectTime.setter
    def DetectTime(self, DetectTime):
        self._DetectTime = DetectTime

    @property
    def IsEnabled(self):
        return self._IsEnabled

    @IsEnabled.setter
    def IsEnabled(self, IsEnabled):
        self._IsEnabled = IsEnabled

    @property
    def AssetType(self):
        return self._AssetType

    @AssetType.setter
    def AssetType(self, AssetType):
        self._AssetType = AssetType

    @property
    def PolicyId(self):
        return self._PolicyId

    @PolicyId.setter
    def PolicyId(self, PolicyId):
        self._PolicyId = PolicyId

    @property
    def RuleCount(self):
        return self._RuleCount

    @RuleCount.setter
    def RuleCount(self, RuleCount):
        self._RuleCount = RuleCount

    @property
    def ItemCount(self):
        return self._ItemCount

    @ItemCount.setter
    def ItemCount(self, ItemCount):
        self._ItemCount = ItemCount

    @property
    def HostCount(self):
        return self._HostCount

    @HostCount.setter
    def HostCount(self, HostCount):
        self._HostCount = HostCount

    @property
    def RuleIds(self):
        return self._RuleIds

    @RuleIds.setter
    def RuleIds(self, RuleIds):
        self._RuleIds = RuleIds

    @property
    def HostIds(self):
        return self._HostIds

    @HostIds.setter
    def HostIds(self, HostIds):
        self._HostIds = HostIds

    @property
    def HostIps(self):
        return self._HostIps

    @HostIps.setter
    def HostIps(self, HostIps):
        self._HostIps = HostIps

    @property
    def IsDefault(self):
        return self._IsDefault

    @IsDefault.setter
    def IsDefault(self, IsDefault):
        self._IsDefault = IsDefault


    def _deserialize(self, params):
        self._PolicyName = params.get("PolicyName")
        self._DetectInterval = params.get("DetectInterval")
        self._DetectTime = params.get("DetectTime")
        self._IsEnabled = params.get("IsEnabled")
        self._AssetType = params.get("AssetType")
        self._PolicyId = params.get("PolicyId")
        self._RuleCount = params.get("RuleCount")
        self._ItemCount = params.get("ItemCount")
        self._HostCount = params.get("HostCount")
        self._RuleIds = params.get("RuleIds")
        self._HostIds = params.get("HostIds")
        self._HostIps = params.get("HostIps")
        self._IsDefault = params.get("IsDefault")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaselineRuleInfo(AbstractModel):
    """Baseline detection information

    """

    def __init__(self):
        r"""
        :param _RuleName: Detection item name
        :type RuleName: str
        :param _Description: Detection item description
        :type Description: str
        :param _FixMessage: Fixing suggestion
        :type FixMessage: str
        :param _Level: Severity level
        :type Level: int
        :param _Status: Status
        :type Status: int
        :param _RuleId: Detection Item ID
        :type RuleId: int
        :param _LastScanAt: Last detection Time
        :type LastScanAt: str
        :param _RuleRemark: Specific reason explanation
        :type RuleRemark: str
        :param _Uuid: Unique UUID
        :type Uuid: str
        :param _EventId: Unique event ID
        :type EventId: int
        """
        self._RuleName = None
        self._Description = None
        self._FixMessage = None
        self._Level = None
        self._Status = None
        self._RuleId = None
        self._LastScanAt = None
        self._RuleRemark = None
        self._Uuid = None
        self._EventId = None

    @property
    def RuleName(self):
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def FixMessage(self):
        return self._FixMessage

    @FixMessage.setter
    def FixMessage(self, FixMessage):
        self._FixMessage = FixMessage

    @property
    def Level(self):
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def LastScanAt(self):
        return self._LastScanAt

    @LastScanAt.setter
    def LastScanAt(self, LastScanAt):
        self._LastScanAt = LastScanAt

    @property
    def RuleRemark(self):
        return self._RuleRemark

    @RuleRemark.setter
    def RuleRemark(self, RuleRemark):
        self._RuleRemark = RuleRemark

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def EventId(self):
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId


    def _deserialize(self, params):
        self._RuleName = params.get("RuleName")
        self._Description = params.get("Description")
        self._FixMessage = params.get("FixMessage")
        self._Level = params.get("Level")
        self._Status = params.get("Status")
        self._RuleId = params.get("RuleId")
        self._LastScanAt = params.get("LastScanAt")
        self._RuleRemark = params.get("RuleRemark")
        self._Uuid = params.get("Uuid")
        self._EventId = params.get("EventId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaselineRuleTopInfo(AbstractModel):
    """Information on TOP baseline detection item

    """

    def __init__(self):
        r"""
        :param _RuleName: Baseline detection item name
Note: This field may return null, indicating that no valid values can be obtained.
        :type RuleName: str
        :param _Level: Detection item hazard level
Note: This field may return null, indicating that no valid values can be obtained.
        :type Level: int
        :param _EventCount: Total number of events
Note: This field may return null, indicating that no valid values can be obtained.
        :type EventCount: int
        :param _RuleId: Detection Item ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type RuleId: int
        """
        self._RuleName = None
        self._Level = None
        self._EventCount = None
        self._RuleId = None

    @property
    def RuleName(self):
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName

    @property
    def Level(self):
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level

    @property
    def EventCount(self):
        return self._EventCount

    @EventCount.setter
    def EventCount(self, EventCount):
        self._EventCount = EventCount

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId


    def _deserialize(self, params):
        self._RuleName = params.get("RuleName")
        self._Level = params.get("Level")
        self._EventCount = params.get("EventCount")
        self._RuleId = params.get("RuleId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaselineWeakPassword(AbstractModel):
    """Baseline weak password

    """

    def __init__(self):
        r"""
        :param _PasswordId: Password ID
        :type PasswordId: int
        :param _WeakPassword: Password
        :type WeakPassword: str
        :param _CreateTime: Creation time
        :type CreateTime: str
        :param _ModifyTime: Modification time
        :type ModifyTime: str
        """
        self._PasswordId = None
        self._WeakPassword = None
        self._CreateTime = None
        self._ModifyTime = None

    @property
    def PasswordId(self):
        return self._PasswordId

    @PasswordId.setter
    def PasswordId(self, PasswordId):
        self._PasswordId = PasswordId

    @property
    def WeakPassword(self):
        return self._WeakPassword

    @WeakPassword.setter
    def WeakPassword(self, WeakPassword):
        self._WeakPassword = WeakPassword

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ModifyTime(self):
        return self._ModifyTime

    @ModifyTime.setter
    def ModifyTime(self, ModifyTime):
        self._ModifyTime = ModifyTime


    def _deserialize(self, params):
        self._PasswordId = params.get("PasswordId")
        self._WeakPassword = params.get("WeakPassword")
        self._CreateTime = params.get("CreateTime")
        self._ModifyTime = params.get("ModifyTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BashEvent(AbstractModel):
    """High-risk command data

    """

    def __init__(self):
        r"""
        :param _Id: Data ID
        :type Id: int
        :param _Uuid: CWPP ID
        :type Uuid: str
        :param _Quuid: Server ID
        :type Quuid: str
        :param _Hostip: Host private IP address
        :type Hostip: str
        :param _User: Username for execution
        :type User: str
        :param _Platform: Platform type
        :type Platform: int
        :param _BashCmd: Executed commands
        :type BashCmd: str
        :param _RuleId: Rule ID
        :type RuleId: int
        :param _RuleName: Rule name
        :type RuleName: str
        :param _RuleLevel: Rule level: 1 - high-risk 2 - medium-risk; 3 - low-risk
        :type RuleLevel: int
        :param _Status: Processing status: 0 - pending; 1 - processed; 2 - allowlisted; 3 - ignored
        :type Status: int
        :param _CreateTime: Occurrence time
        :type CreateTime: str
        :param _MachineName: Server name
        :type MachineName: str
        :param _DetectBy: 0: bash log; 1: real-time monitoring (thunder edition)
Note: This field may return null, indicating that no valid values can be obtained.
        :type DetectBy: int
        :param _Pid: Process ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type Pid: str
        :param _Exe: Process name
Note: This field may return null, indicating that no valid values can be obtained.
        :type Exe: str
        :param _ModifyTime: Processing time
Note: This field may return null, indicating that no valid values can be obtained.
        :type ModifyTime: str
        :param _RuleCategory: Rule category: 0 - system rule; 1 - user rule
Note: This field may return null, indicating that no valid values can be obtained.
        :type RuleCategory: int
        :param _RegexBashCmd: Automatically generated regular expression\nNote: This field may return null, indicating that no valid values can be obtained.
        :type RegexBashCmd: str
        :param _HostName: Host HostName
Note: This field may return null, indicating that no valid values can be obtained.
        :type HostName: str
        """
        self._Id = None
        self._Uuid = None
        self._Quuid = None
        self._Hostip = None
        self._User = None
        self._Platform = None
        self._BashCmd = None
        self._RuleId = None
        self._RuleName = None
        self._RuleLevel = None
        self._Status = None
        self._CreateTime = None
        self._MachineName = None
        self._DetectBy = None
        self._Pid = None
        self._Exe = None
        self._ModifyTime = None
        self._RuleCategory = None
        self._RegexBashCmd = None
        self._HostName = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Hostip(self):
        return self._Hostip

    @Hostip.setter
    def Hostip(self, Hostip):
        self._Hostip = Hostip

    @property
    def User(self):
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def Platform(self):
        return self._Platform

    @Platform.setter
    def Platform(self, Platform):
        self._Platform = Platform

    @property
    def BashCmd(self):
        return self._BashCmd

    @BashCmd.setter
    def BashCmd(self, BashCmd):
        self._BashCmd = BashCmd

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def RuleName(self):
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName

    @property
    def RuleLevel(self):
        return self._RuleLevel

    @RuleLevel.setter
    def RuleLevel(self, RuleLevel):
        self._RuleLevel = RuleLevel

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def DetectBy(self):
        return self._DetectBy

    @DetectBy.setter
    def DetectBy(self, DetectBy):
        self._DetectBy = DetectBy

    @property
    def Pid(self):
        return self._Pid

    @Pid.setter
    def Pid(self, Pid):
        self._Pid = Pid

    @property
    def Exe(self):
        return self._Exe

    @Exe.setter
    def Exe(self, Exe):
        self._Exe = Exe

    @property
    def ModifyTime(self):
        return self._ModifyTime

    @ModifyTime.setter
    def ModifyTime(self, ModifyTime):
        self._ModifyTime = ModifyTime

    @property
    def RuleCategory(self):
        return self._RuleCategory

    @RuleCategory.setter
    def RuleCategory(self, RuleCategory):
        self._RuleCategory = RuleCategory

    @property
    def RegexBashCmd(self):
        return self._RegexBashCmd

    @RegexBashCmd.setter
    def RegexBashCmd(self, RegexBashCmd):
        self._RegexBashCmd = RegexBashCmd

    @property
    def HostName(self):
        return self._HostName

    @HostName.setter
    def HostName(self, HostName):
        self._HostName = HostName


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Uuid = params.get("Uuid")
        self._Quuid = params.get("Quuid")
        self._Hostip = params.get("Hostip")
        self._User = params.get("User")
        self._Platform = params.get("Platform")
        self._BashCmd = params.get("BashCmd")
        self._RuleId = params.get("RuleId")
        self._RuleName = params.get("RuleName")
        self._RuleLevel = params.get("RuleLevel")
        self._Status = params.get("Status")
        self._CreateTime = params.get("CreateTime")
        self._MachineName = params.get("MachineName")
        self._DetectBy = params.get("DetectBy")
        self._Pid = params.get("Pid")
        self._Exe = params.get("Exe")
        self._ModifyTime = params.get("ModifyTime")
        self._RuleCategory = params.get("RuleCategory")
        self._RegexBashCmd = params.get("RegexBashCmd")
        self._HostName = params.get("HostName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BashEventNew(AbstractModel):
    """High-risk command data (new)

    """

    def __init__(self):
        r"""
        :param _Id: Data ID
        :type Id: int
        :param _Uuid: CWPP ID
        :type Uuid: str
        :param _Quuid: Host ID
        :type Quuid: str
        :param _HostIp: Host private IP address
        :type HostIp: str
        :param _User: Username for execution
        :type User: str
        :param _Platform: Platform type
        :type Platform: int
        :param _BashCmd: Execute commands
        :type BashCmd: str
        :param _RuleId: Rule ID
        :type RuleId: int
        :param _RuleName: Rule name
        :type RuleName: str
        :param _RuleLevel: Rule level: 1: high-risk 2: medium-risk; 3: low-risk
        :type RuleLevel: int
        :param _Status: Processing status: 0: pending; 1: processed; 2: allowlisted; 3: ignored
        :type Status: int
        :param _CreateTime: Occurrence time
        :type CreateTime: str
        :param _MachineName: Host name
        :type MachineName: str
        :param _DetectBy: 0: bash log; 1: real-time monitoring (Leiting edition)
Note: This field may return null, indicating that no valid values can be obtained.
        :type DetectBy: int
        :param _Pid: Process ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type Pid: str
        :param _Exe: Process name
Note: This field may return null, indicating that no valid values can be obtained.
        :type Exe: str
        :param _ModifyTime: Processing time
Note: This field may return null, indicating that no valid values can be obtained.
        :type ModifyTime: str
        :param _RuleCategory: Rule category. 0: system rule; 1: user rule
Note: This field may return null, indicating that no valid values can be obtained.
        :type RuleCategory: int
        :param _RegexBashCmd: Automatically generated regular expression
Note: This field may return null, indicating that no valid values can be obtained.
        :type RegexBashCmd: str
        :param _MachineType: 0: normal; 1: Professional edition; 2: Ultimate edition
Note: This field may return null, indicating that no valid values can be obtained.
        :type MachineType: int
        :param _MachineExtraInfo: Additional Information on Machine
Note: This field may return null, indicating that no valid values can be obtained.
        :type MachineExtraInfo: :class:`tencentcloud.cwp.v20180228.models.MachineExtraInfo`
        """
        self._Id = None
        self._Uuid = None
        self._Quuid = None
        self._HostIp = None
        self._User = None
        self._Platform = None
        self._BashCmd = None
        self._RuleId = None
        self._RuleName = None
        self._RuleLevel = None
        self._Status = None
        self._CreateTime = None
        self._MachineName = None
        self._DetectBy = None
        self._Pid = None
        self._Exe = None
        self._ModifyTime = None
        self._RuleCategory = None
        self._RegexBashCmd = None
        self._MachineType = None
        self._MachineExtraInfo = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def HostIp(self):
        return self._HostIp

    @HostIp.setter
    def HostIp(self, HostIp):
        self._HostIp = HostIp

    @property
    def User(self):
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def Platform(self):
        return self._Platform

    @Platform.setter
    def Platform(self, Platform):
        self._Platform = Platform

    @property
    def BashCmd(self):
        return self._BashCmd

    @BashCmd.setter
    def BashCmd(self, BashCmd):
        self._BashCmd = BashCmd

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def RuleName(self):
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName

    @property
    def RuleLevel(self):
        return self._RuleLevel

    @RuleLevel.setter
    def RuleLevel(self, RuleLevel):
        self._RuleLevel = RuleLevel

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def DetectBy(self):
        return self._DetectBy

    @DetectBy.setter
    def DetectBy(self, DetectBy):
        self._DetectBy = DetectBy

    @property
    def Pid(self):
        return self._Pid

    @Pid.setter
    def Pid(self, Pid):
        self._Pid = Pid

    @property
    def Exe(self):
        return self._Exe

    @Exe.setter
    def Exe(self, Exe):
        self._Exe = Exe

    @property
    def ModifyTime(self):
        return self._ModifyTime

    @ModifyTime.setter
    def ModifyTime(self, ModifyTime):
        self._ModifyTime = ModifyTime

    @property
    def RuleCategory(self):
        return self._RuleCategory

    @RuleCategory.setter
    def RuleCategory(self, RuleCategory):
        self._RuleCategory = RuleCategory

    @property
    def RegexBashCmd(self):
        return self._RegexBashCmd

    @RegexBashCmd.setter
    def RegexBashCmd(self, RegexBashCmd):
        self._RegexBashCmd = RegexBashCmd

    @property
    def MachineType(self):
        return self._MachineType

    @MachineType.setter
    def MachineType(self, MachineType):
        self._MachineType = MachineType

    @property
    def MachineExtraInfo(self):
        return self._MachineExtraInfo

    @MachineExtraInfo.setter
    def MachineExtraInfo(self, MachineExtraInfo):
        self._MachineExtraInfo = MachineExtraInfo


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Uuid = params.get("Uuid")
        self._Quuid = params.get("Quuid")
        self._HostIp = params.get("HostIp")
        self._User = params.get("User")
        self._Platform = params.get("Platform")
        self._BashCmd = params.get("BashCmd")
        self._RuleId = params.get("RuleId")
        self._RuleName = params.get("RuleName")
        self._RuleLevel = params.get("RuleLevel")
        self._Status = params.get("Status")
        self._CreateTime = params.get("CreateTime")
        self._MachineName = params.get("MachineName")
        self._DetectBy = params.get("DetectBy")
        self._Pid = params.get("Pid")
        self._Exe = params.get("Exe")
        self._ModifyTime = params.get("ModifyTime")
        self._RuleCategory = params.get("RuleCategory")
        self._RegexBashCmd = params.get("RegexBashCmd")
        self._MachineType = params.get("MachineType")
        if params.get("MachineExtraInfo") is not None:
            self._MachineExtraInfo = MachineExtraInfo()
            self._MachineExtraInfo._deserialize(params.get("MachineExtraInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BashEventsInfo(AbstractModel):
    """Details of high-risk command data

    """

    def __init__(self):
        r"""
        :param _Id: Data ID
        :type Id: int
        :param _Uuid: Yunjing ID
        :type Uuid: str
        :param _Quuid: Host ID
        :type Quuid: str
        :param _HostIp: Host private IP address
        :type HostIp: str
        :param _Platform: Platform type
        :type Platform: int
        :param _BashCmd: Executed commands
        :type BashCmd: str
        :param _RuleId: Rule ID equals 0 indicating that the rule has been deleted or the effective scope has been modified.
        :type RuleId: int
        :param _RuleName: Rule name
        :type RuleName: str
        :param _RuleLevel: Rule level: 1 - high-risk 2 - medium-risk; 3 - low-risk
        :type RuleLevel: int
        :param _Status: Processing status. 0: Pending; 1: Processed; 2: Whitelisted; 3: Ignored
        :type Status: int
        :param _CreateTime: Occurrence time
        :type CreateTime: str
        :param _MachineName: Host name
        :type MachineName: str
        :param _Exe: Process name
Note: This field may return null, indicating that no valid values can be obtained.
        :type Exe: str
        :param _ModifyTime: Processing time
Note: This field may return null, indicating that no valid values can be obtained.
        :type ModifyTime: str
        :param _RuleCategory: Rule category: 0 - system rule; 1 - user rule
Note: This field may return null, indicating that no valid values can be obtained.
        :type RuleCategory: int
        :param _RegexBashCmd: Automatically generated regular expression
Note: This field may return null, indicating that no valid values can be obtained.
        :type RegexBashCmd: str
        :param _PsTree: Process tree json  pid: process ID; exe: file path; account: groups and users to which the process belongs; cmdline: command execution; ssh_service: ssh service IP, ssh_source: log-in source
Note: This field may return null, indicating that no valid values can be obtained.
        :type PsTree: str
        :param _SuggestScheme: Recommended solution
Note: This field may return null, indicating that no valid values can be obtained.
        :type SuggestScheme: str
        :param _HarmDescribe: Description
Note: This field may return null, indicating that no valid values can be obtained.
        :type HarmDescribe: str
        :param _Tags: Tag
Note: This field may return null, indicating that no valid values can be obtained.
        :type Tags: list of str
        :param _References: Reference link
Note: This field may return null, indicating that no valid values can be obtained.
        :type References: list of str
        :param _MachineWanIp: Host public IP address
Note: This field may return null, indicating that no valid values can be obtained.
        :type MachineWanIp: str
        :param _MachineStatus: Host online status: OFFLINE  ONLINE
Note: This field may return null, indicating that no valid values can be obtained.
        :type MachineStatus: str
        :param _User: Log-in user
Note: This field may return null, indicating that no valid values can be obtained.
        :type User: str
        :param _Pid: Process ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type Pid: str
        :param _DetectBy: Data source
Note: This field may return null, indicating that no valid values can be obtained.
        :type DetectBy: str
        """
        self._Id = None
        self._Uuid = None
        self._Quuid = None
        self._HostIp = None
        self._Platform = None
        self._BashCmd = None
        self._RuleId = None
        self._RuleName = None
        self._RuleLevel = None
        self._Status = None
        self._CreateTime = None
        self._MachineName = None
        self._Exe = None
        self._ModifyTime = None
        self._RuleCategory = None
        self._RegexBashCmd = None
        self._PsTree = None
        self._SuggestScheme = None
        self._HarmDescribe = None
        self._Tags = None
        self._References = None
        self._MachineWanIp = None
        self._MachineStatus = None
        self._User = None
        self._Pid = None
        self._DetectBy = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def HostIp(self):
        return self._HostIp

    @HostIp.setter
    def HostIp(self, HostIp):
        self._HostIp = HostIp

    @property
    def Platform(self):
        return self._Platform

    @Platform.setter
    def Platform(self, Platform):
        self._Platform = Platform

    @property
    def BashCmd(self):
        return self._BashCmd

    @BashCmd.setter
    def BashCmd(self, BashCmd):
        self._BashCmd = BashCmd

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def RuleName(self):
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName

    @property
    def RuleLevel(self):
        return self._RuleLevel

    @RuleLevel.setter
    def RuleLevel(self, RuleLevel):
        self._RuleLevel = RuleLevel

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def Exe(self):
        return self._Exe

    @Exe.setter
    def Exe(self, Exe):
        self._Exe = Exe

    @property
    def ModifyTime(self):
        return self._ModifyTime

    @ModifyTime.setter
    def ModifyTime(self, ModifyTime):
        self._ModifyTime = ModifyTime

    @property
    def RuleCategory(self):
        return self._RuleCategory

    @RuleCategory.setter
    def RuleCategory(self, RuleCategory):
        self._RuleCategory = RuleCategory

    @property
    def RegexBashCmd(self):
        return self._RegexBashCmd

    @RegexBashCmd.setter
    def RegexBashCmd(self, RegexBashCmd):
        self._RegexBashCmd = RegexBashCmd

    @property
    def PsTree(self):
        return self._PsTree

    @PsTree.setter
    def PsTree(self, PsTree):
        self._PsTree = PsTree

    @property
    def SuggestScheme(self):
        return self._SuggestScheme

    @SuggestScheme.setter
    def SuggestScheme(self, SuggestScheme):
        self._SuggestScheme = SuggestScheme

    @property
    def HarmDescribe(self):
        return self._HarmDescribe

    @HarmDescribe.setter
    def HarmDescribe(self, HarmDescribe):
        self._HarmDescribe = HarmDescribe

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def References(self):
        return self._References

    @References.setter
    def References(self, References):
        self._References = References

    @property
    def MachineWanIp(self):
        return self._MachineWanIp

    @MachineWanIp.setter
    def MachineWanIp(self, MachineWanIp):
        self._MachineWanIp = MachineWanIp

    @property
    def MachineStatus(self):
        return self._MachineStatus

    @MachineStatus.setter
    def MachineStatus(self, MachineStatus):
        self._MachineStatus = MachineStatus

    @property
    def User(self):
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def Pid(self):
        return self._Pid

    @Pid.setter
    def Pid(self, Pid):
        self._Pid = Pid

    @property
    def DetectBy(self):
        return self._DetectBy

    @DetectBy.setter
    def DetectBy(self, DetectBy):
        self._DetectBy = DetectBy


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Uuid = params.get("Uuid")
        self._Quuid = params.get("Quuid")
        self._HostIp = params.get("HostIp")
        self._Platform = params.get("Platform")
        self._BashCmd = params.get("BashCmd")
        self._RuleId = params.get("RuleId")
        self._RuleName = params.get("RuleName")
        self._RuleLevel = params.get("RuleLevel")
        self._Status = params.get("Status")
        self._CreateTime = params.get("CreateTime")
        self._MachineName = params.get("MachineName")
        self._Exe = params.get("Exe")
        self._ModifyTime = params.get("ModifyTime")
        self._RuleCategory = params.get("RuleCategory")
        self._RegexBashCmd = params.get("RegexBashCmd")
        self._PsTree = params.get("PsTree")
        self._SuggestScheme = params.get("SuggestScheme")
        self._HarmDescribe = params.get("HarmDescribe")
        self._Tags = params.get("Tags")
        self._References = params.get("References")
        self._MachineWanIp = params.get("MachineWanIp")
        self._MachineStatus = params.get("MachineStatus")
        self._User = params.get("User")
        self._Pid = params.get("Pid")
        self._DetectBy = params.get("DetectBy")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BashEventsInfoNew(AbstractModel):
    """Details of high-risk command data (new)

    """

    def __init__(self):
        r"""
        :param _Id: Data ID
        :type Id: int
        :param _Uuid: CWPP ID
        :type Uuid: str
        :param _Quuid: Host ID
        :type Quuid: str
        :param _HostIp: Host private IP address
        :type HostIp: str
        :param _Platform: Platform type
        :type Platform: int
        :param _BashCmd: Executed commands
        :type BashCmd: str
        :param _RuleId: Rule ID equals 0 indicating that the rule has been deleted or the effective scope has been modified.
        :type RuleId: int
        :param _RuleName: Rule name
        :type RuleName: str
        :param _RuleLevel: Rule level: 1 - high-risk 2 - medium-risk; 3 - low-risk
        :type RuleLevel: int
        :param _Status: Processing status: 0: Pending; 1: Processed; 2: Whitelisted; 3: Ignored
        :type Status: int
        :param _CreateTime: Occurrence time
        :type CreateTime: str
        :param _MachineName: Host name
        :type MachineName: str
        :param _Exe: Process name
Note: This field may return null, indicating that no valid values can be obtained.
        :type Exe: str
        :param _ModifyTime: Processing time
Note: This field may return null, indicating that no valid values can be obtained.
        :type ModifyTime: str
        :param _RuleCategory: Rule category. 0 - system rule; 1 - user rule
Note: This field may return null, indicating that no valid values can be obtained.
        :type RuleCategory: int
        :param _RegexBashCmd: Automatically generated regular expression
Note: This field may return null, indicating that no valid values can be obtained.
        :type RegexBashCmd: str
        :param _PsTree: Process tree json  pid: process ID; exe: file path; account: groups and users to which the process belongs; cmdline: command execution; ssh_service: ssh service IP, ssh_source: log-in source
Note: This field may return null, indicating that no valid values can be obtained.
        :type PsTree: str
        :param _SuggestScheme: Recommended solution
Note: This field may return null, indicating that no valid values can be obtained.
        :type SuggestScheme: str
        :param _HarmDescribe: Description
Note: This field may return null, indicating that no valid values can be obtained.
        :type HarmDescribe: str
        :param _Tags: Tag
Note: This field may return null, indicating that no valid values can be obtained.
        :type Tags: list of str
        :param _References: Reference link
Note: This field may return null, indicating that no valid values can be obtained.
        :type References: list of str
        :param _MachineWanIp: Host public IP address
Note: This field may return null, indicating that no valid values can be obtained.
        :type MachineWanIp: str
        :param _MachineStatus: Host online status: OFFLINE; ONLINE
Note: This field may return null, indicating that no valid values can be obtained.
        :type MachineStatus: str
        :param _User: Log-in user
Note: This field may return null, indicating that no valid values can be obtained.
        :type User: str
        :param _Pid: Process ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type Pid: str
        :param _MachineType: 0: normal; 1: professional version; 2: ultimate edition
Note: This field may return null, indicating that no valid values can be obtained.
        :type MachineType: int
        :param _DetectBy: Source of Detection: 0: bash log; 1: real-time monitoring
Note: This field may return null, indicating that no valid values can be obtained.
        :type DetectBy: int
        """
        self._Id = None
        self._Uuid = None
        self._Quuid = None
        self._HostIp = None
        self._Platform = None
        self._BashCmd = None
        self._RuleId = None
        self._RuleName = None
        self._RuleLevel = None
        self._Status = None
        self._CreateTime = None
        self._MachineName = None
        self._Exe = None
        self._ModifyTime = None
        self._RuleCategory = None
        self._RegexBashCmd = None
        self._PsTree = None
        self._SuggestScheme = None
        self._HarmDescribe = None
        self._Tags = None
        self._References = None
        self._MachineWanIp = None
        self._MachineStatus = None
        self._User = None
        self._Pid = None
        self._MachineType = None
        self._DetectBy = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def HostIp(self):
        return self._HostIp

    @HostIp.setter
    def HostIp(self, HostIp):
        self._HostIp = HostIp

    @property
    def Platform(self):
        return self._Platform

    @Platform.setter
    def Platform(self, Platform):
        self._Platform = Platform

    @property
    def BashCmd(self):
        return self._BashCmd

    @BashCmd.setter
    def BashCmd(self, BashCmd):
        self._BashCmd = BashCmd

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def RuleName(self):
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName

    @property
    def RuleLevel(self):
        return self._RuleLevel

    @RuleLevel.setter
    def RuleLevel(self, RuleLevel):
        self._RuleLevel = RuleLevel

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def Exe(self):
        return self._Exe

    @Exe.setter
    def Exe(self, Exe):
        self._Exe = Exe

    @property
    def ModifyTime(self):
        return self._ModifyTime

    @ModifyTime.setter
    def ModifyTime(self, ModifyTime):
        self._ModifyTime = ModifyTime

    @property
    def RuleCategory(self):
        return self._RuleCategory

    @RuleCategory.setter
    def RuleCategory(self, RuleCategory):
        self._RuleCategory = RuleCategory

    @property
    def RegexBashCmd(self):
        return self._RegexBashCmd

    @RegexBashCmd.setter
    def RegexBashCmd(self, RegexBashCmd):
        self._RegexBashCmd = RegexBashCmd

    @property
    def PsTree(self):
        return self._PsTree

    @PsTree.setter
    def PsTree(self, PsTree):
        self._PsTree = PsTree

    @property
    def SuggestScheme(self):
        return self._SuggestScheme

    @SuggestScheme.setter
    def SuggestScheme(self, SuggestScheme):
        self._SuggestScheme = SuggestScheme

    @property
    def HarmDescribe(self):
        return self._HarmDescribe

    @HarmDescribe.setter
    def HarmDescribe(self, HarmDescribe):
        self._HarmDescribe = HarmDescribe

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def References(self):
        return self._References

    @References.setter
    def References(self, References):
        self._References = References

    @property
    def MachineWanIp(self):
        return self._MachineWanIp

    @MachineWanIp.setter
    def MachineWanIp(self, MachineWanIp):
        self._MachineWanIp = MachineWanIp

    @property
    def MachineStatus(self):
        return self._MachineStatus

    @MachineStatus.setter
    def MachineStatus(self, MachineStatus):
        self._MachineStatus = MachineStatus

    @property
    def User(self):
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def Pid(self):
        return self._Pid

    @Pid.setter
    def Pid(self, Pid):
        self._Pid = Pid

    @property
    def MachineType(self):
        return self._MachineType

    @MachineType.setter
    def MachineType(self, MachineType):
        self._MachineType = MachineType

    @property
    def DetectBy(self):
        return self._DetectBy

    @DetectBy.setter
    def DetectBy(self, DetectBy):
        self._DetectBy = DetectBy


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Uuid = params.get("Uuid")
        self._Quuid = params.get("Quuid")
        self._HostIp = params.get("HostIp")
        self._Platform = params.get("Platform")
        self._BashCmd = params.get("BashCmd")
        self._RuleId = params.get("RuleId")
        self._RuleName = params.get("RuleName")
        self._RuleLevel = params.get("RuleLevel")
        self._Status = params.get("Status")
        self._CreateTime = params.get("CreateTime")
        self._MachineName = params.get("MachineName")
        self._Exe = params.get("Exe")
        self._ModifyTime = params.get("ModifyTime")
        self._RuleCategory = params.get("RuleCategory")
        self._RegexBashCmd = params.get("RegexBashCmd")
        self._PsTree = params.get("PsTree")
        self._SuggestScheme = params.get("SuggestScheme")
        self._HarmDescribe = params.get("HarmDescribe")
        self._Tags = params.get("Tags")
        self._References = params.get("References")
        self._MachineWanIp = params.get("MachineWanIp")
        self._MachineStatus = params.get("MachineStatus")
        self._User = params.get("User")
        self._Pid = params.get("Pid")
        self._MachineType = params.get("MachineType")
        self._DetectBy = params.get("DetectBy")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BashPolicy(AbstractModel):
    """High-risk command policy

    """

    def __init__(self):
        r"""
        :param _Name: Policy name
        :type Name: str
        :param _Enable: 1: valid; 0: invalid
        :type Enable: int
        :param _White: 0: blocklist; 1: allowlist
        :type White: int
        :param _BashAction: 0: alarm; 1: allowlist; 2: intercept
        :type BashAction: int
        :param _Rule: Regular expression
        :type Rule: str
        :param _Level: Risk level (0: none; 1: high-risk; 2: medium-risk; 3: low-risk)
        :type Level: int
        :param _Scope: Effective scope (0: a group of QUUID; 1: all professional editions (including ultimate edition); 2: all ultimate editions; 3: all hosts)
        :type Scope: int
        :param _Id: Policy ID
        :type Id: int
        :param _Descript: Policy description
Note: This field may return null, indicating that no valid values can be obtained.
        :type Descript: str
        :param _EventId: When it is added to the allowlist, the EventId needs to be passed in.Note: This field may return null, indicating that no valid values can be obtained.
        :type EventId: int
        :param _DealOldEvents: Whether to process old events as allowlisted ones: 0 - no; 1 - yes
Note: This field may return null, indicating that no valid values can be obtained.
        :type DealOldEvents: int
        :param _Quuids: A collection of QUUIDs for effective hosts
Note: This field may return null, indicating that no valid values can be obtained.
        :type Quuids: list of str
        :param _Category: Policy type: 0 - system; 1 - user
        :type Category: int
        :param _CreateTime: Creation time
        :type CreateTime: str
        :param _ModifyTime: Modification time
        :type ModifyTime: str
        :param _Uuids: Compatibility with older versions may be needed.
        :type Uuids: list of str
        """
        self._Name = None
        self._Enable = None
        self._White = None
        self._BashAction = None
        self._Rule = None
        self._Level = None
        self._Scope = None
        self._Id = None
        self._Descript = None
        self._EventId = None
        self._DealOldEvents = None
        self._Quuids = None
        self._Category = None
        self._CreateTime = None
        self._ModifyTime = None
        self._Uuids = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Enable(self):
        return self._Enable

    @Enable.setter
    def Enable(self, Enable):
        self._Enable = Enable

    @property
    def White(self):
        return self._White

    @White.setter
    def White(self, White):
        self._White = White

    @property
    def BashAction(self):
        return self._BashAction

    @BashAction.setter
    def BashAction(self, BashAction):
        self._BashAction = BashAction

    @property
    def Rule(self):
        return self._Rule

    @Rule.setter
    def Rule(self, Rule):
        self._Rule = Rule

    @property
    def Level(self):
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level

    @property
    def Scope(self):
        return self._Scope

    @Scope.setter
    def Scope(self, Scope):
        self._Scope = Scope

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Descript(self):
        return self._Descript

    @Descript.setter
    def Descript(self, Descript):
        self._Descript = Descript

    @property
    def EventId(self):
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId

    @property
    def DealOldEvents(self):
        return self._DealOldEvents

    @DealOldEvents.setter
    def DealOldEvents(self, DealOldEvents):
        self._DealOldEvents = DealOldEvents

    @property
    def Quuids(self):
        return self._Quuids

    @Quuids.setter
    def Quuids(self, Quuids):
        self._Quuids = Quuids

    @property
    def Category(self):
        return self._Category

    @Category.setter
    def Category(self, Category):
        self._Category = Category

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ModifyTime(self):
        return self._ModifyTime

    @ModifyTime.setter
    def ModifyTime(self, ModifyTime):
        self._ModifyTime = ModifyTime

    @property
    def Uuids(self):
        return self._Uuids

    @Uuids.setter
    def Uuids(self, Uuids):
        self._Uuids = Uuids


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Enable = params.get("Enable")
        self._White = params.get("White")
        self._BashAction = params.get("BashAction")
        self._Rule = params.get("Rule")
        self._Level = params.get("Level")
        self._Scope = params.get("Scope")
        self._Id = params.get("Id")
        self._Descript = params.get("Descript")
        self._EventId = params.get("EventId")
        self._DealOldEvents = params.get("DealOldEvents")
        self._Quuids = params.get("Quuids")
        self._Category = params.get("Category")
        self._CreateTime = params.get("CreateTime")
        self._ModifyTime = params.get("ModifyTime")
        self._Uuids = params.get("Uuids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BashRule(AbstractModel):
    """High-risk command rules

    """

    def __init__(self):
        r"""
        :param _Id: Rule ID
        :type Id: int
        :param _Uuid: Client ID
        :type Uuid: str
        :param _Name: Rule name
        :type Name: str
        :param _Level: Risk level (0: none, 1: high-risk, 2: medium-risk, 3: low-risk)
        :type Level: int
        :param _Rule: Regular expression
        :type Rule: str
        :param _Decription: Rule description
        :type Decription: str
        :param _Operator: Operator
        :type Operator: str
        :param _IsGlobal: Whether a global rule
        :type IsGlobal: int
        :param _Status: Status (0: valid; 1: invalid)
        :type Status: int
        :param _CreateTime: Creation time
        :type CreateTime: str
        :param _ModifyTime: Modification time
        :type ModifyTime: str
        :param _Hostip: Host IP
        :type Hostip: str
        :param _Uuids: Arrays of UUIDs for servers to be effective
Note: This field may return null, indicating that no valid values can be obtained.
        :type Uuids: list of str
        :param _White: 0= blocklist; 1= allowlist
Note: This field may return null, indicating that no valid values can be obtained.
        :type White: int
        :param _DealOldEvents: Whether to process previous events: 0: do not process; 1: process
Note: This field may return null, indicating that no valid values can be obtained.
        :type DealOldEvents: int
        :param _Description: Rule description
Note: This field may return null, indicating that no valid values can be obtained.
        :type Description: str
        """
        self._Id = None
        self._Uuid = None
        self._Name = None
        self._Level = None
        self._Rule = None
        self._Decription = None
        self._Operator = None
        self._IsGlobal = None
        self._Status = None
        self._CreateTime = None
        self._ModifyTime = None
        self._Hostip = None
        self._Uuids = None
        self._White = None
        self._DealOldEvents = None
        self._Description = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Level(self):
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level

    @property
    def Rule(self):
        return self._Rule

    @Rule.setter
    def Rule(self, Rule):
        self._Rule = Rule

    @property
    def Decription(self):
        warnings.warn("parameter `Decription` is deprecated", DeprecationWarning) 

        return self._Decription

    @Decription.setter
    def Decription(self, Decription):
        warnings.warn("parameter `Decription` is deprecated", DeprecationWarning) 

        self._Decription = Decription

    @property
    def Operator(self):
        return self._Operator

    @Operator.setter
    def Operator(self, Operator):
        self._Operator = Operator

    @property
    def IsGlobal(self):
        return self._IsGlobal

    @IsGlobal.setter
    def IsGlobal(self, IsGlobal):
        self._IsGlobal = IsGlobal

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ModifyTime(self):
        return self._ModifyTime

    @ModifyTime.setter
    def ModifyTime(self, ModifyTime):
        self._ModifyTime = ModifyTime

    @property
    def Hostip(self):
        return self._Hostip

    @Hostip.setter
    def Hostip(self, Hostip):
        self._Hostip = Hostip

    @property
    def Uuids(self):
        return self._Uuids

    @Uuids.setter
    def Uuids(self, Uuids):
        self._Uuids = Uuids

    @property
    def White(self):
        return self._White

    @White.setter
    def White(self, White):
        self._White = White

    @property
    def DealOldEvents(self):
        return self._DealOldEvents

    @DealOldEvents.setter
    def DealOldEvents(self, DealOldEvents):
        self._DealOldEvents = DealOldEvents

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Uuid = params.get("Uuid")
        self._Name = params.get("Name")
        self._Level = params.get("Level")
        self._Rule = params.get("Rule")
        self._Decription = params.get("Decription")
        self._Operator = params.get("Operator")
        self._IsGlobal = params.get("IsGlobal")
        self._Status = params.get("Status")
        self._CreateTime = params.get("CreateTime")
        self._ModifyTime = params.get("ModifyTime")
        self._Hostip = params.get("Hostip")
        self._Uuids = params.get("Uuids")
        self._White = params.get("White")
        self._DealOldEvents = params.get("DealOldEvents")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BroadcastInfo(AbstractModel):
    """Security report article details

    """

    def __init__(self):
        r"""
        :param _Title: Article name
Note: This field may return null, indicating that no valid values can be obtained.
        :type Title: str
        :param _GotoType: Redirection location: 0: no redirection; 1: virus scanning; 2: vulnerability scan; 3: security baseline
Note: This field may return null, indicating that no valid values can be obtained.
        :type GotoType: int
        :param _Subtitle: Subtitle
        :type Subtitle: str
        :param _CreateTime: Release time
        :type CreateTime: str
        :param _Content: Rich text content information
        :type Content: str
        :param _Id: Article unique ID
        :type Id: int
        :param _Type: Type: 0: emergency notification; 1: feature update; 2: industry honor; 3: version release
        :type Type: int
        """
        self._Title = None
        self._GotoType = None
        self._Subtitle = None
        self._CreateTime = None
        self._Content = None
        self._Id = None
        self._Type = None

    @property
    def Title(self):
        return self._Title

    @Title.setter
    def Title(self, Title):
        self._Title = Title

    @property
    def GotoType(self):
        return self._GotoType

    @GotoType.setter
    def GotoType(self, GotoType):
        self._GotoType = GotoType

    @property
    def Subtitle(self):
        return self._Subtitle

    @Subtitle.setter
    def Subtitle(self, Subtitle):
        self._Subtitle = Subtitle

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def Content(self):
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Title = params.get("Title")
        self._GotoType = params.get("GotoType")
        self._Subtitle = params.get("Subtitle")
        self._CreateTime = params.get("CreateTime")
        self._Content = params.get("Content")
        self._Id = params.get("Id")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Broadcasts(AbstractModel):
    """Security report list

    """

    def __init__(self):
        r"""
        :param _Title: Article name
Note: This field may return null, indicating that no valid values can be obtained.
        :type Title: str
        :param _Type: Type: 0: emergency notification; 1: feature update; 2: industry honor; 3: version release
Note: This field may return null, indicating that no valid values can be obtained.
        :type Type: int
        :param _Subtitle: Subtitle
        :type Subtitle: str
        :param _CreateTime: Release time
        :type CreateTime: str
        :param _Id: Article unique ID
        :type Id: int
        :param _Level: Severity level. 0: none; 1: critical; 2: high-risk; 3: medium-risk; 4: low-risk
        :type Level: int
        """
        self._Title = None
        self._Type = None
        self._Subtitle = None
        self._CreateTime = None
        self._Id = None
        self._Level = None

    @property
    def Title(self):
        return self._Title

    @Title.setter
    def Title(self, Title):
        self._Title = Title

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Subtitle(self):
        return self._Subtitle

    @Subtitle.setter
    def Subtitle(self, Subtitle):
        self._Subtitle = Subtitle

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Level(self):
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level


    def _deserialize(self, params):
        self._Title = params.get("Title")
        self._Type = params.get("Type")
        self._Subtitle = params.get("Subtitle")
        self._CreateTime = params.get("CreateTime")
        self._Id = params.get("Id")
        self._Level = params.get("Level")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BruteAttackInfo(AbstractModel):
    """Password cracking list entity

    """

    def __init__(self):
        r"""
        :param _Id: Unique ID
        :type Id: int
        :param _Uuid: CWPP client UUID
Note: This field may return null, indicating that no valid values can be obtained.
        :type Uuid: str
        :param _MachineIp: Host IP address
Note: This field may return null, indicating that no valid values can be obtained.
        :type MachineIp: str
        :param _MachineName: Host name
Note: This field may return null, indicating that no valid values can be obtained.
        :type MachineName: str
        :param _UserName: Username
Note: This field may return null, indicating that no valid values can be obtained.
        :type UserName: str
        :param _SrcIp: Source IP address
Note: This field may return null, indicating that no valid values can be obtained.
        :type SrcIp: str
        :param _Status: SUCCESS: cracking successful; FAILED: cracking failed
Note: This field may return null, indicating that no valid values can be obtained.
        :type Status: str
        :param _Country: Country/Region ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type Country: int
        :param _City: City ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type City: int
        :param _Province: Province ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type Province: int
        :param _CreateTime: Creation time
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        :param _BanStatus: 0: no blocking (not supported for the client version)1: blocked
2: blocking failed (program exception)
3: no blocking (do not block for the private network)
4: availability zone does not support blocking
10: blocking
81: no blocking (blocking disabled)
82: no blocking (non-Pro Edition)
83: no blocking (added to the allowlist)
86: no blocking (system allowlist)
87: no blocking (client offline)
Note: This field may return null, indicating that no valid values can be obtained.
        :type BanStatus: int
        :param _EventType: Event type. 200: brute force cracking event; 300: event of successful brute force cracking (page display); 400: event of brute force cracking on a non-existent account.Note: This field may return null, indicating that no valid values can be obtained.
        :type EventType: int
        :param _Count: Occurrence count
Note: This field may return null, indicating that no valid values can be obtained.
        :type Count: int
        :param _Quuid: Machine UUID
Note: This field may return null, indicating that no valid values can be obtained.
        :type Quuid: str
        :param _IsProVersion: Whether it is of the Pro Edition (true/false)
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsProVersion: bool
        :param _Protocol: Username of the attacked service
Note: This field may return null, indicating that no valid values can be obtained.
        :type Protocol: str
        :param _Port: Port
Note: This field may return null, indicating that no valid values can be obtained.
        :type Port: int
        :param _ModifyTime: Last attack time
Note: This field may return null, indicating that no valid values can be obtained.
        :type ModifyTime: str
        :param _InstanceId: Instance ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type InstanceId: str
        :param _DataStatus: 0: pending; 1: ignored; 5: fixed; 6: added to allowlist
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataStatus: int
        :param _MachineExtraInfo: Additional information
Note: This field may return null, indicating that no valid values can be obtained.
        :type MachineExtraInfo: :class:`tencentcloud.cwp.v20180228.models.MachineExtraInfo`
        :param _Location: Geo-location in Chinese
Note: This field may return null, indicating that no valid values can be obtained.
        :type Location: str
        :param _RiskLevel: Threat level. 0: low-risk; 1: medium-risk; 2: high-risk.Note: This field may return null, indicating that no valid values can be obtained.
        :type RiskLevel: int
        :param _DataFrom: Event source. 0: blocking rule; 1: threat intelligence.Note: This field may return null, indicating that no valid values can be obtained.
        :type DataFrom: int
        :param _AttackStatusDesc: Description of the brute force cracking status
Note: This field may return null, indicating that no valid values can be obtained.
        :type AttackStatusDesc: str
        :param _BanExpiredTime: Blocking expiration time (valid only for events in blocking status)
Note: This field may return null, indicating that no valid values can be obtained.
        :type BanExpiredTime: str
        """
        self._Id = None
        self._Uuid = None
        self._MachineIp = None
        self._MachineName = None
        self._UserName = None
        self._SrcIp = None
        self._Status = None
        self._Country = None
        self._City = None
        self._Province = None
        self._CreateTime = None
        self._BanStatus = None
        self._EventType = None
        self._Count = None
        self._Quuid = None
        self._IsProVersion = None
        self._Protocol = None
        self._Port = None
        self._ModifyTime = None
        self._InstanceId = None
        self._DataStatus = None
        self._MachineExtraInfo = None
        self._Location = None
        self._RiskLevel = None
        self._DataFrom = None
        self._AttackStatusDesc = None
        self._BanExpiredTime = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def MachineIp(self):
        return self._MachineIp

    @MachineIp.setter
    def MachineIp(self, MachineIp):
        self._MachineIp = MachineIp

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def UserName(self):
        return self._UserName

    @UserName.setter
    def UserName(self, UserName):
        self._UserName = UserName

    @property
    def SrcIp(self):
        return self._SrcIp

    @SrcIp.setter
    def SrcIp(self, SrcIp):
        self._SrcIp = SrcIp

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Country(self):
        return self._Country

    @Country.setter
    def Country(self, Country):
        self._Country = Country

    @property
    def City(self):
        return self._City

    @City.setter
    def City(self, City):
        self._City = City

    @property
    def Province(self):
        return self._Province

    @Province.setter
    def Province(self, Province):
        self._Province = Province

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def BanStatus(self):
        return self._BanStatus

    @BanStatus.setter
    def BanStatus(self, BanStatus):
        self._BanStatus = BanStatus

    @property
    def EventType(self):
        return self._EventType

    @EventType.setter
    def EventType(self, EventType):
        self._EventType = EventType

    @property
    def Count(self):
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def IsProVersion(self):
        return self._IsProVersion

    @IsProVersion.setter
    def IsProVersion(self, IsProVersion):
        self._IsProVersion = IsProVersion

    @property
    def Protocol(self):
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def Port(self):
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def ModifyTime(self):
        return self._ModifyTime

    @ModifyTime.setter
    def ModifyTime(self, ModifyTime):
        self._ModifyTime = ModifyTime

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def DataStatus(self):
        return self._DataStatus

    @DataStatus.setter
    def DataStatus(self, DataStatus):
        self._DataStatus = DataStatus

    @property
    def MachineExtraInfo(self):
        return self._MachineExtraInfo

    @MachineExtraInfo.setter
    def MachineExtraInfo(self, MachineExtraInfo):
        self._MachineExtraInfo = MachineExtraInfo

    @property
    def Location(self):
        return self._Location

    @Location.setter
    def Location(self, Location):
        self._Location = Location

    @property
    def RiskLevel(self):
        return self._RiskLevel

    @RiskLevel.setter
    def RiskLevel(self, RiskLevel):
        self._RiskLevel = RiskLevel

    @property
    def DataFrom(self):
        return self._DataFrom

    @DataFrom.setter
    def DataFrom(self, DataFrom):
        self._DataFrom = DataFrom

    @property
    def AttackStatusDesc(self):
        return self._AttackStatusDesc

    @AttackStatusDesc.setter
    def AttackStatusDesc(self, AttackStatusDesc):
        self._AttackStatusDesc = AttackStatusDesc

    @property
    def BanExpiredTime(self):
        return self._BanExpiredTime

    @BanExpiredTime.setter
    def BanExpiredTime(self, BanExpiredTime):
        self._BanExpiredTime = BanExpiredTime


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Uuid = params.get("Uuid")
        self._MachineIp = params.get("MachineIp")
        self._MachineName = params.get("MachineName")
        self._UserName = params.get("UserName")
        self._SrcIp = params.get("SrcIp")
        self._Status = params.get("Status")
        self._Country = params.get("Country")
        self._City = params.get("City")
        self._Province = params.get("Province")
        self._CreateTime = params.get("CreateTime")
        self._BanStatus = params.get("BanStatus")
        self._EventType = params.get("EventType")
        self._Count = params.get("Count")
        self._Quuid = params.get("Quuid")
        self._IsProVersion = params.get("IsProVersion")
        self._Protocol = params.get("Protocol")
        self._Port = params.get("Port")
        self._ModifyTime = params.get("ModifyTime")
        self._InstanceId = params.get("InstanceId")
        self._DataStatus = params.get("DataStatus")
        if params.get("MachineExtraInfo") is not None:
            self._MachineExtraInfo = MachineExtraInfo()
            self._MachineExtraInfo._deserialize(params.get("MachineExtraInfo"))
        self._Location = params.get("Location")
        self._RiskLevel = params.get("RiskLevel")
        self._DataFrom = params.get("DataFrom")
        self._AttackStatusDesc = params.get("AttackStatusDesc")
        self._BanExpiredTime = params.get("BanExpiredTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BruteAttackRule(AbstractModel):
    """Standard blocking mode rule

    """

    def __init__(self):
        r"""
        :param _TimeRange: Timeframe of the brute force event (unit: second)
        :type TimeRange: int
        :param _LoginFailTimes: Number of failed attempts during the brute force event
        :type LoginFailTimes: int
        """
        self._TimeRange = None
        self._LoginFailTimes = None

    @property
    def TimeRange(self):
        return self._TimeRange

    @TimeRange.setter
    def TimeRange(self, TimeRange):
        self._TimeRange = TimeRange

    @property
    def LoginFailTimes(self):
        return self._LoginFailTimes

    @LoginFailTimes.setter
    def LoginFailTimes(self, LoginFailTimes):
        self._LoginFailTimes = LoginFailTimes


    def _deserialize(self, params):
        self._TimeRange = params.get("TimeRange")
        self._LoginFailTimes = params.get("LoginFailTimes")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BruteAttackRuleList(AbstractModel):
    """List of rules for determining brute force cracking

    """

    def __init__(self):
        r"""
        :param _TimeRange: Timeframe of the brute force cracking event (unit: second)
        :type TimeRange: int
        :param _LoginFailTimes: Number of failed attempts during the brute force cracking event
        :type LoginFailTimes: int
        :param _Enable: Whether the rule is empty. If yes, fill in the default rule.
        :type Enable: bool
        :param _TimeRangeDefault: Occurrence time range of brute force cracking events, in seconds (default rule)
        :type TimeRangeDefault: int
        :param _LoginFailTimesDefault: Number of failed brute force cracking events (default rule)
        :type LoginFailTimesDefault: int
        """
        self._TimeRange = None
        self._LoginFailTimes = None
        self._Enable = None
        self._TimeRangeDefault = None
        self._LoginFailTimesDefault = None

    @property
    def TimeRange(self):
        return self._TimeRange

    @TimeRange.setter
    def TimeRange(self, TimeRange):
        self._TimeRange = TimeRange

    @property
    def LoginFailTimes(self):
        return self._LoginFailTimes

    @LoginFailTimes.setter
    def LoginFailTimes(self, LoginFailTimes):
        self._LoginFailTimes = LoginFailTimes

    @property
    def Enable(self):
        return self._Enable

    @Enable.setter
    def Enable(self, Enable):
        self._Enable = Enable

    @property
    def TimeRangeDefault(self):
        return self._TimeRangeDefault

    @TimeRangeDefault.setter
    def TimeRangeDefault(self, TimeRangeDefault):
        self._TimeRangeDefault = TimeRangeDefault

    @property
    def LoginFailTimesDefault(self):
        return self._LoginFailTimesDefault

    @LoginFailTimesDefault.setter
    def LoginFailTimesDefault(self, LoginFailTimesDefault):
        self._LoginFailTimesDefault = LoginFailTimesDefault


    def _deserialize(self, params):
        self._TimeRange = params.get("TimeRange")
        self._LoginFailTimes = params.get("LoginFailTimes")
        self._Enable = params.get("Enable")
        self._TimeRangeDefault = params.get("TimeRangeDefault")
        self._LoginFailTimesDefault = params.get("LoginFailTimesDefault")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CKafkaInstanceInfo(AbstractModel):
    """CKafka instance information

    """

    def __init__(self):
        r"""
        :param _InstanceID: Instance ID
        :type InstanceID: str
        :param _InstanceName: Instance name
        :type InstanceName: str
        :param _KafkaVersion: Version No.
        :type KafkaVersion: str
        :param _TopicList: Topic list
Note: This field may return null, indicating that no valid values can be obtained.
        :type TopicList: list of CKafkaTopicInfo
        :param _RouteList: Routing List
        :type RouteList: list of CKafkaRouteInfo
        :param _DiskSize: Disk capacity (unit: GB)
        :type DiskSize: int
        :param _VpcId: vpcId. Leaving it blank indicates a basic network.
        :type VpcId: str
        :param _SubnetId: Subnet ID
        :type SubnetId: str
        :param _Healthy: Status: 1 - healthy; 2 - alarm; 3 - abnormal instance status
        :type Healthy: int
        :param _Zone: Availability zone
        :type Zone: str
        :param _Az: Region
        :type Az: str
        :param _Bandwidth: Instance bandwidth (unit: Mbps)
        :type Bandwidth: int
        """
        self._InstanceID = None
        self._InstanceName = None
        self._KafkaVersion = None
        self._TopicList = None
        self._RouteList = None
        self._DiskSize = None
        self._VpcId = None
        self._SubnetId = None
        self._Healthy = None
        self._Zone = None
        self._Az = None
        self._Bandwidth = None

    @property
    def InstanceID(self):
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID

    @property
    def InstanceName(self):
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def KafkaVersion(self):
        return self._KafkaVersion

    @KafkaVersion.setter
    def KafkaVersion(self, KafkaVersion):
        self._KafkaVersion = KafkaVersion

    @property
    def TopicList(self):
        return self._TopicList

    @TopicList.setter
    def TopicList(self, TopicList):
        self._TopicList = TopicList

    @property
    def RouteList(self):
        return self._RouteList

    @RouteList.setter
    def RouteList(self, RouteList):
        self._RouteList = RouteList

    @property
    def DiskSize(self):
        return self._DiskSize

    @DiskSize.setter
    def DiskSize(self, DiskSize):
        self._DiskSize = DiskSize

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def Healthy(self):
        return self._Healthy

    @Healthy.setter
    def Healthy(self, Healthy):
        self._Healthy = Healthy

    @property
    def Zone(self):
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def Az(self):
        return self._Az

    @Az.setter
    def Az(self, Az):
        self._Az = Az

    @property
    def Bandwidth(self):
        return self._Bandwidth

    @Bandwidth.setter
    def Bandwidth(self, Bandwidth):
        self._Bandwidth = Bandwidth


    def _deserialize(self, params):
        self._InstanceID = params.get("InstanceID")
        self._InstanceName = params.get("InstanceName")
        self._KafkaVersion = params.get("KafkaVersion")
        if params.get("TopicList") is not None:
            self._TopicList = []
            for item in params.get("TopicList"):
                obj = CKafkaTopicInfo()
                obj._deserialize(item)
                self._TopicList.append(obj)
        if params.get("RouteList") is not None:
            self._RouteList = []
            for item in params.get("RouteList"):
                obj = CKafkaRouteInfo()
                obj._deserialize(item)
                self._RouteList.append(obj)
        self._DiskSize = params.get("DiskSize")
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._Healthy = params.get("Healthy")
        self._Zone = params.get("Zone")
        self._Az = params.get("Az")
        self._Bandwidth = params.get("Bandwidth")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CKafkaRouteInfo(AbstractModel):
    """CKafka domain name information

    """

    def __init__(self):
        r"""
        :param _RouteID: Routing ID
        :type RouteID: int
        :param _Domain: Domain name
        :type Domain: str
        :param _DomainPort: Domain Port
        :type DomainPort: int
        :param _Vip: Virtual IP
        :type Vip: str
        :param _VipType: Virtual IP Type
        :type VipType: int
        :param _AccessType: Access type
        :type AccessType: int
        """
        self._RouteID = None
        self._Domain = None
        self._DomainPort = None
        self._Vip = None
        self._VipType = None
        self._AccessType = None

    @property
    def RouteID(self):
        return self._RouteID

    @RouteID.setter
    def RouteID(self, RouteID):
        self._RouteID = RouteID

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def DomainPort(self):
        return self._DomainPort

    @DomainPort.setter
    def DomainPort(self, DomainPort):
        self._DomainPort = DomainPort

    @property
    def Vip(self):
        return self._Vip

    @Vip.setter
    def Vip(self, Vip):
        self._Vip = Vip

    @property
    def VipType(self):
        return self._VipType

    @VipType.setter
    def VipType(self, VipType):
        self._VipType = VipType

    @property
    def AccessType(self):
        return self._AccessType

    @AccessType.setter
    def AccessType(self, AccessType):
        self._AccessType = AccessType


    def _deserialize(self, params):
        self._RouteID = params.get("RouteID")
        self._Domain = params.get("Domain")
        self._DomainPort = params.get("DomainPort")
        self._Vip = params.get("Vip")
        self._VipType = params.get("VipType")
        self._AccessType = params.get("AccessType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CKafkaTopicInfo(AbstractModel):
    """CKafka topic name

    """

    def __init__(self):
        r"""
        :param _TopicID: Topic ID
        :type TopicID: str
        :param _TopicName: Topic name
        :type TopicName: str
        """
        self._TopicID = None
        self._TopicName = None

    @property
    def TopicID(self):
        return self._TopicID

    @TopicID.setter
    def TopicID(self, TopicID):
        self._TopicID = TopicID

    @property
    def TopicName(self):
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName


    def _deserialize(self, params):
        self._TopicID = params.get("TopicID")
        self._TopicName = params.get("TopicName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CanFixVulInfo(AbstractModel):
    """Host information for batch vulnerability fixing

    """

    def __init__(self):
        r"""
        :param _VulId: Vulnerability ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type VulId: int
        :param _VulName: Vulnerability name
Note: This field may return null, indicating that no valid values can be obtained.
        :type VulName: str
        :param _HostList: Information on hosts where this vulnerability can be fixed
Note: This field may return null, indicating that no valid values can be obtained.
        :type HostList: list of VulInfoHostInfo
        :param _FixTag: Fixing prompt tag
Note: This field may return null, indicating that no valid values can be obtained.
        :type FixTag: list of str
        :param _VulCategory: 
        :type VulCategory: int
        """
        self._VulId = None
        self._VulName = None
        self._HostList = None
        self._FixTag = None
        self._VulCategory = None

    @property
    def VulId(self):
        return self._VulId

    @VulId.setter
    def VulId(self, VulId):
        self._VulId = VulId

    @property
    def VulName(self):
        return self._VulName

    @VulName.setter
    def VulName(self, VulName):
        self._VulName = VulName

    @property
    def HostList(self):
        return self._HostList

    @HostList.setter
    def HostList(self, HostList):
        self._HostList = HostList

    @property
    def FixTag(self):
        return self._FixTag

    @FixTag.setter
    def FixTag(self, FixTag):
        self._FixTag = FixTag

    @property
    def VulCategory(self):
        return self._VulCategory

    @VulCategory.setter
    def VulCategory(self, VulCategory):
        self._VulCategory = VulCategory


    def _deserialize(self, params):
        self._VulId = params.get("VulId")
        self._VulName = params.get("VulName")
        if params.get("HostList") is not None:
            self._HostList = []
            for item in params.get("HostList"):
                obj = VulInfoHostInfo()
                obj._deserialize(item)
                self._HostList.append(obj)
        self._FixTag = params.get("FixTag")
        self._VulCategory = params.get("VulCategory")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CanNotSeparateInfo(AbstractModel):
    """Information on machine with non-isolatable Trojan

    """

    def __init__(self):
        r"""
        :param _Quuid: Host QUUID
        :type Quuid: str
        :param _Uuid: Host UUID
        :type Uuid: str
        :param _Alias: Server name
        :type Alias: str
        :param _PrivateIp: Private IP address
        :type PrivateIp: str
        :param _PublicIp: Public IP
        :type PublicIp: str
        :param _Reason: Reason for isolation failure: 1 - agent offline
        :type Reason: int
        """
        self._Quuid = None
        self._Uuid = None
        self._Alias = None
        self._PrivateIp = None
        self._PublicIp = None
        self._Reason = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Alias(self):
        return self._Alias

    @Alias.setter
    def Alias(self, Alias):
        self._Alias = Alias

    @property
    def PrivateIp(self):
        return self._PrivateIp

    @PrivateIp.setter
    def PrivateIp(self, PrivateIp):
        self._PrivateIp = PrivateIp

    @property
    def PublicIp(self):
        return self._PublicIp

    @PublicIp.setter
    def PublicIp(self, PublicIp):
        self._PublicIp = PublicIp

    @property
    def Reason(self):
        return self._Reason

    @Reason.setter
    def Reason(self, Reason):
        self._Reason = Reason


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._Alias = params.get("Alias")
        self._PrivateIp = params.get("PrivateIp")
        self._PublicIp = params.get("PublicIp")
        self._Reason = params.get("Reason")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CancelIgnoreVulRequest(AbstractModel):
    """CancelIgnoreVul request structure.

    """

    def __init__(self):
        r"""
        :param _EventIds: Vulnerability event ID string (multiple entries are separated by comma)
        :type EventIds: str
        """
        self._EventIds = None

    @property
    def EventIds(self):
        return self._EventIds

    @EventIds.setter
    def EventIds(self, EventIds):
        self._EventIds = EventIds


    def _deserialize(self, params):
        self._EventIds = params.get("EventIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CancelIgnoreVulResponse(AbstractModel):
    """CancelIgnoreVul response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ChangeRuleEventsIgnoreStatusRequest(AbstractModel):
    """ChangeRuleEventsIgnoreStatus request structure.

    """

    def __init__(self):
        r"""
        :param _IgnoreStatus: Ignore status: 0: unignore; 1: ignore
        :type IgnoreStatus: int
        :param _RuleIdList: Detection item ID array
        :type RuleIdList: list of int non-negative
        :param _EventIdList: Event ID array
        :type EventIdList: list of int non-negative
        """
        self._IgnoreStatus = None
        self._RuleIdList = None
        self._EventIdList = None

    @property
    def IgnoreStatus(self):
        return self._IgnoreStatus

    @IgnoreStatus.setter
    def IgnoreStatus(self, IgnoreStatus):
        self._IgnoreStatus = IgnoreStatus

    @property
    def RuleIdList(self):
        return self._RuleIdList

    @RuleIdList.setter
    def RuleIdList(self, RuleIdList):
        self._RuleIdList = RuleIdList

    @property
    def EventIdList(self):
        return self._EventIdList

    @EventIdList.setter
    def EventIdList(self, EventIdList):
        self._EventIdList = EventIdList


    def _deserialize(self, params):
        self._IgnoreStatus = params.get("IgnoreStatus")
        self._RuleIdList = params.get("RuleIdList")
        self._EventIdList = params.get("EventIdList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ChangeRuleEventsIgnoreStatusResponse(AbstractModel):
    """ChangeRuleEventsIgnoreStatus response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ChangeStrategyEnableStatusRequest(AbstractModel):
    """ChangeStrategyEnableStatus request structure.

    """

    def __init__(self):
        r"""
        :param _StrategyId: Baseline policy ID
        :type StrategyId: int
        :param _Status: Enabling status
        :type Status: int
        """
        self._StrategyId = None
        self._Status = None

    @property
    def StrategyId(self):
        return self._StrategyId

    @StrategyId.setter
    def StrategyId(self, StrategyId):
        self._StrategyId = StrategyId

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._StrategyId = params.get("StrategyId")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ChangeStrategyEnableStatusResponse(AbstractModel):
    """ChangeStrategyEnableStatus response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CheckBashPolicyParamsRequest(AbstractModel):
    """CheckBashPolicyParams request structure.

    """

    def __init__(self):
        r"""
        :param _CheckField: Verify content Name or Rule. (Use a comma to separate them if both need to be verified.)
        :type CheckField: str
        :param _EventId: Event ID needs to be submitted when allowlisting an event in the event list.
        :type EventId: int
        :param _Name: Name of rule to be entered
        :type Name: str
        :param _Rule: The regular expression to be entered by the user: It must match command content corresponding to the submitted EventId.
        :type Rule: str
        :param _Id: Rule ID passed during editing
        :type Id: int
        """
        self._CheckField = None
        self._EventId = None
        self._Name = None
        self._Rule = None
        self._Id = None

    @property
    def CheckField(self):
        return self._CheckField

    @CheckField.setter
    def CheckField(self, CheckField):
        self._CheckField = CheckField

    @property
    def EventId(self):
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Rule(self):
        return self._Rule

    @Rule.setter
    def Rule(self, Rule):
        self._Rule = Rule

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._CheckField = params.get("CheckField")
        self._EventId = params.get("EventId")
        self._Name = params.get("Name")
        self._Rule = params.get("Rule")
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckBashPolicyParamsResponse(AbstractModel):
    """CheckBashPolicyParams response structure.

    """

    def __init__(self):
        r"""
        :param _ErrCode: 0: verification passed; 1: rule name verification failed; 2: regular expression verification failed.
        :type ErrCode: int
        :param _ErrMsg: Verification information
        :type ErrMsg: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ErrCode = None
        self._ErrMsg = None
        self._RequestId = None

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def ErrMsg(self):
        return self._ErrMsg

    @ErrMsg.setter
    def ErrMsg(self, ErrMsg):
        self._ErrMsg = ErrMsg

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrCode = params.get("ErrCode")
        self._ErrMsg = params.get("ErrMsg")
        self._RequestId = params.get("RequestId")


class CheckBashRuleParamsRequest(AbstractModel):
    """CheckBashRuleParams request structure.

    """

    def __init__(self):
        r"""
        :param _CheckField: Verify content Name or Rule. (Use a comma to separate them if both need to be verified.)
        :type CheckField: str
        :param _EventId: Event ID needs to be submitted when allowlisting an event in the event list.
        :type EventId: int
        :param _Name: Name of rule to be entered
        :type Name: str
        :param _Rule: The regular expression to be entered by the user: It must match command content corresponding to the submitted EventId.
        :type Rule: str
        :param _Id: Rule ID passed during editing
        :type Id: int
        """
        self._CheckField = None
        self._EventId = None
        self._Name = None
        self._Rule = None
        self._Id = None

    @property
    def CheckField(self):
        return self._CheckField

    @CheckField.setter
    def CheckField(self, CheckField):
        self._CheckField = CheckField

    @property
    def EventId(self):
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Rule(self):
        return self._Rule

    @Rule.setter
    def Rule(self, Rule):
        self._Rule = Rule

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._CheckField = params.get("CheckField")
        self._EventId = params.get("EventId")
        self._Name = params.get("Name")
        self._Rule = params.get("Rule")
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckBashRuleParamsResponse(AbstractModel):
    """CheckBashRuleParams response structure.

    """

    def __init__(self):
        r"""
        :param _ErrCode: 0: verification passed; 1: rule name verification failed; 2: regular expression verification failed.
        :type ErrCode: int
        :param _ErrMsg: Verification information
        :type ErrMsg: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ErrCode = None
        self._ErrMsg = None
        self._RequestId = None

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def ErrMsg(self):
        return self._ErrMsg

    @ErrMsg.setter
    def ErrMsg(self, ErrMsg):
        self._ErrMsg = ErrMsg

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrCode = params.get("ErrCode")
        self._ErrMsg = params.get("ErrMsg")
        self._RequestId = params.get("RequestId")


class CheckFileTamperRuleRequest(AbstractModel):
    """CheckFileTamperRule request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Name of rule to be entered
        :type Name: str
        :param _Id: Rule ID passed during editing
        :type Id: int
        """
        self._Name = None
        self._Id = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckFileTamperRuleResponse(AbstractModel):
    """CheckFileTamperRule response structure.

    """

    def __init__(self):
        r"""
        :param _ErrCode: 0=verification passed; 1=rule name verification failed
        :type ErrCode: int
        :param _ErrMsg: Verification information
        :type ErrMsg: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ErrCode = None
        self._ErrMsg = None
        self._RequestId = None

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def ErrMsg(self):
        return self._ErrMsg

    @ErrMsg.setter
    def ErrMsg(self, ErrMsg):
        self._ErrMsg = ErrMsg

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrCode = params.get("ErrCode")
        self._ErrMsg = params.get("ErrMsg")
        self._RequestId = params.get("RequestId")


class CheckFirstScanBaselineRequest(AbstractModel):
    """CheckFirstScanBaseline request structure.

    """


class CheckFirstScanBaselineResponse(AbstractModel):
    """CheckFirstScanBaseline response structure.

    """

    def __init__(self):
        r"""
        :param _FirstScan: Whether the first detection: 0 - no; 1 - yes
        :type FirstScan: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FirstScan = None
        self._RequestId = None

    @property
    def FirstScan(self):
        return self._FirstScan

    @FirstScan.setter
    def FirstScan(self, FirstScan):
        self._FirstScan = FirstScan

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FirstScan = params.get("FirstScan")
        self._RequestId = params.get("RequestId")


class CheckLogKafkaConnectionStateRequest(AbstractModel):
    """CheckLogKafkaConnectionState request structure.

    """

    def __init__(self):
        r"""
        :param _AccessType: Access method: 1 - public network domain name access; 2 - supported environment access
        :type AccessType: int
        :param _AccessAddr: Access address: domain name or IP, with port
        :type AccessAddr: str
        :param _Username: Username
        :type Username: str
        :param _HasPwd: 0 - without password; 1 - with password
        :type HasPwd: int
        :param _Pwd: Password, using AES encryption
        :type Pwd: str
        :param _KafkaId: Kafka instance ID
        :type KafkaId: str
        :param _InsVersion: Kafka version
        :type InsVersion: str
        """
        self._AccessType = None
        self._AccessAddr = None
        self._Username = None
        self._HasPwd = None
        self._Pwd = None
        self._KafkaId = None
        self._InsVersion = None

    @property
    def AccessType(self):
        return self._AccessType

    @AccessType.setter
    def AccessType(self, AccessType):
        self._AccessType = AccessType

    @property
    def AccessAddr(self):
        return self._AccessAddr

    @AccessAddr.setter
    def AccessAddr(self, AccessAddr):
        self._AccessAddr = AccessAddr

    @property
    def Username(self):
        return self._Username

    @Username.setter
    def Username(self, Username):
        self._Username = Username

    @property
    def HasPwd(self):
        return self._HasPwd

    @HasPwd.setter
    def HasPwd(self, HasPwd):
        self._HasPwd = HasPwd

    @property
    def Pwd(self):
        return self._Pwd

    @Pwd.setter
    def Pwd(self, Pwd):
        self._Pwd = Pwd

    @property
    def KafkaId(self):
        return self._KafkaId

    @KafkaId.setter
    def KafkaId(self, KafkaId):
        self._KafkaId = KafkaId

    @property
    def InsVersion(self):
        return self._InsVersion

    @InsVersion.setter
    def InsVersion(self, InsVersion):
        self._InsVersion = InsVersion


    def _deserialize(self, params):
        self._AccessType = params.get("AccessType")
        self._AccessAddr = params.get("AccessAddr")
        self._Username = params.get("Username")
        self._HasPwd = params.get("HasPwd")
        self._Pwd = params.get("Pwd")
        self._KafkaId = params.get("KafkaId")
        self._InsVersion = params.get("InsVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckLogKafkaConnectionStateResponse(AbstractModel):
    """CheckLogKafkaConnectionState response structure.

    """

    def __init__(self):
        r"""
        :param _IsConnect: true: connected; false: not connected.
        :type IsConnect: bool
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._IsConnect = None
        self._RequestId = None

    @property
    def IsConnect(self):
        return self._IsConnect

    @IsConnect.setter
    def IsConnect(self, IsConnect):
        self._IsConnect = IsConnect

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._IsConnect = params.get("IsConnect")
        self._RequestId = params.get("RequestId")


class ClearLocalStorageRequest(AbstractModel):
    """ClearLocalStorage request structure.

    """


class ClearLocalStorageResponse(AbstractModel):
    """ClearLocalStorage response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CloudProtectService(AbstractModel):
    """

    """

    def __init__(self):
        r"""
        :param _ResourceId: Resource ID
        :type ResourceId: str
        :param _Type: Type: new purchase in this case
        :type Type: str
        :param _Config: Configuration: information of purchased configuration
        :type Config: str
        :param _ServiceName: Service name
        :type ServiceName: str
        :param _BeginTime: Time of purchase
        :type BeginTime: str
        """
        self._ResourceId = None
        self._Type = None
        self._Config = None
        self._ServiceName = None
        self._BeginTime = None

    @property
    def ResourceId(self):
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Config(self):
        return self._Config

    @Config.setter
    def Config(self, Config):
        self._Config = Config

    @property
    def ServiceName(self):
        return self._ServiceName

    @ServiceName.setter
    def ServiceName(self, ServiceName):
        self._ServiceName = ServiceName

    @property
    def BeginTime(self):
        return self._BeginTime

    @BeginTime.setter
    def BeginTime(self, BeginTime):
        self._BeginTime = BeginTime


    def _deserialize(self, params):
        self._ResourceId = params.get("ResourceId")
        self._Type = params.get("Type")
        self._Config = params.get("Config")
        self._ServiceName = params.get("ServiceName")
        self._BeginTime = params.get("BeginTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComponentStatistics(AbstractModel):
    """Component statistics

    """

    def __init__(self):
        r"""
        :param _Id: Component ID
        :type Id: int
        :param _MachineNum: Number of hosts
        :type MachineNum: int
        :param _ComponentName: Component name
        :type ComponentName: str
        :param _ComponentType: Component type
<li>WEB: Web component</li>
<li>SYSTEM: system component</li>
        :type ComponentType: str
        :param _Description: Component description
        :type Description: str
        """
        self._Id = None
        self._MachineNum = None
        self._ComponentName = None
        self._ComponentType = None
        self._Description = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def MachineNum(self):
        return self._MachineNum

    @MachineNum.setter
    def MachineNum(self, MachineNum):
        self._MachineNum = MachineNum

    @property
    def ComponentName(self):
        return self._ComponentName

    @ComponentName.setter
    def ComponentName(self, ComponentName):
        self._ComponentName = ComponentName

    @property
    def ComponentType(self):
        return self._ComponentType

    @ComponentType.setter
    def ComponentType(self, ComponentType):
        self._ComponentType = ComponentType

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._MachineNum = params.get("MachineNum")
        self._ComponentName = params.get("ComponentName")
        self._ComponentType = params.get("ComponentType")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateBanWhiteListRequest(AbstractModel):
    """CreateBanWhiteList request structure.

    """

    def __init__(self):
        r"""
        :param _Rules: Block rules
        :type Rules: :class:`tencentcloud.cwp.v20180228.models.BanWhiteList`
        :param _EventId: Event list ID, which is passed when the event list is allowlisted. After it is successfully allowlisted, the events in the list will be marked as whitelisted.
        :type EventId: int
        """
        self._Rules = None
        self._EventId = None

    @property
    def Rules(self):
        return self._Rules

    @Rules.setter
    def Rules(self, Rules):
        self._Rules = Rules

    @property
    def EventId(self):
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId


    def _deserialize(self, params):
        if params.get("Rules") is not None:
            self._Rules = BanWhiteList()
            self._Rules._deserialize(params.get("Rules"))
        self._EventId = params.get("EventId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateBanWhiteListResponse(AbstractModel):
    """CreateBanWhiteList response structure.

    """

    def __init__(self):
        r"""
        :param _IsGlobal: Whether a global rule
        :type IsGlobal: bool
        :param _IsDuplicate: Whether the addition of a rule would result in a duplicate
        :type IsDuplicate: bool
        :param _DuplicateHosts: Information on duplicate machines
        :type DuplicateHosts: list of DuplicateHosts
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._IsGlobal = None
        self._IsDuplicate = None
        self._DuplicateHosts = None
        self._RequestId = None

    @property
    def IsGlobal(self):
        return self._IsGlobal

    @IsGlobal.setter
    def IsGlobal(self, IsGlobal):
        self._IsGlobal = IsGlobal

    @property
    def IsDuplicate(self):
        return self._IsDuplicate

    @IsDuplicate.setter
    def IsDuplicate(self, IsDuplicate):
        self._IsDuplicate = IsDuplicate

    @property
    def DuplicateHosts(self):
        return self._DuplicateHosts

    @DuplicateHosts.setter
    def DuplicateHosts(self, DuplicateHosts):
        self._DuplicateHosts = DuplicateHosts

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._IsGlobal = params.get("IsGlobal")
        self._IsDuplicate = params.get("IsDuplicate")
        if params.get("DuplicateHosts") is not None:
            self._DuplicateHosts = []
            for item in params.get("DuplicateHosts"):
                obj = DuplicateHosts()
                obj._deserialize(item)
                self._DuplicateHosts.append(obj)
        self._RequestId = params.get("RequestId")


class CreateBaselineStrategyRequest(AbstractModel):
    """CreateBaselineStrategy request structure.

    """

    def __init__(self):
        r"""
        :param _StrategyName: Policy name
        :type StrategyName: str
        :param _ScanCycle: Check cycle, indicating the number of days between checks. Example: 2, indicating that the check is carried out every 2 days.
        :type ScanCycle: int
        :param _ScanAt: Time for a periodic check. The scan task is issued at this time. Example: "22:00", indicating that the task is issued at 22:00.
        :type ScanAt: str
        :param _CategoryIds: Array of selected baseline IDs under this policy. Example: [1,3,5,7]
        :type CategoryIds: list of int non-negative
        :param _IsGlobal: Whether all servers are scanned. 1: yes; 0: no. If the value is 1, all Professional Edition hosts are scanned.
        :type IsGlobal: int
        :param _MachineType: Cloud host type:
CVM: virtual machine
BM: bare metal server
ECM: edge computing machine
LH: Lighthouse 
Other: hybrid cloud machine
        :type MachineType: str
        :param _RegionCode: Host region. Example: "ap-guangzhou"
        :type RegionCode: str
        :param _Quuids: Host ID array. Example: ["quuid1","quuid2"]
        :type Quuids: list of str
        """
        self._StrategyName = None
        self._ScanCycle = None
        self._ScanAt = None
        self._CategoryIds = None
        self._IsGlobal = None
        self._MachineType = None
        self._RegionCode = None
        self._Quuids = None

    @property
    def StrategyName(self):
        return self._StrategyName

    @StrategyName.setter
    def StrategyName(self, StrategyName):
        self._StrategyName = StrategyName

    @property
    def ScanCycle(self):
        return self._ScanCycle

    @ScanCycle.setter
    def ScanCycle(self, ScanCycle):
        self._ScanCycle = ScanCycle

    @property
    def ScanAt(self):
        return self._ScanAt

    @ScanAt.setter
    def ScanAt(self, ScanAt):
        self._ScanAt = ScanAt

    @property
    def CategoryIds(self):
        return self._CategoryIds

    @CategoryIds.setter
    def CategoryIds(self, CategoryIds):
        self._CategoryIds = CategoryIds

    @property
    def IsGlobal(self):
        return self._IsGlobal

    @IsGlobal.setter
    def IsGlobal(self, IsGlobal):
        self._IsGlobal = IsGlobal

    @property
    def MachineType(self):
        return self._MachineType

    @MachineType.setter
    def MachineType(self, MachineType):
        self._MachineType = MachineType

    @property
    def RegionCode(self):
        return self._RegionCode

    @RegionCode.setter
    def RegionCode(self, RegionCode):
        self._RegionCode = RegionCode

    @property
    def Quuids(self):
        return self._Quuids

    @Quuids.setter
    def Quuids(self, Quuids):
        self._Quuids = Quuids


    def _deserialize(self, params):
        self._StrategyName = params.get("StrategyName")
        self._ScanCycle = params.get("ScanCycle")
        self._ScanAt = params.get("ScanAt")
        self._CategoryIds = params.get("CategoryIds")
        self._IsGlobal = params.get("IsGlobal")
        self._MachineType = params.get("MachineType")
        self._RegionCode = params.get("RegionCode")
        self._Quuids = params.get("Quuids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateBaselineStrategyResponse(AbstractModel):
    """CreateBaselineStrategy response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateBuyBindTaskRequest(AbstractModel):
    """CreateBuyBindTask request structure.

    """

    def __init__(self):
        r"""
        :param _DealName: Order Number
        :type DealName: str
        :param _LicenseType: Optional parameters. 1: Pro Edition-monthly subscription; 2: Ultimate Edition-monthly subscription
        :type LicenseType: int
        :param _QuuidList: Machine list
        :type QuuidList: list of str
        :param _IsAll: Whether to select all machines
        :type IsAll: bool
        """
        self._DealName = None
        self._LicenseType = None
        self._QuuidList = None
        self._IsAll = None

    @property
    def DealName(self):
        return self._DealName

    @DealName.setter
    def DealName(self, DealName):
        self._DealName = DealName

    @property
    def LicenseType(self):
        return self._LicenseType

    @LicenseType.setter
    def LicenseType(self, LicenseType):
        self._LicenseType = LicenseType

    @property
    def QuuidList(self):
        return self._QuuidList

    @QuuidList.setter
    def QuuidList(self, QuuidList):
        self._QuuidList = QuuidList

    @property
    def IsAll(self):
        return self._IsAll

    @IsAll.setter
    def IsAll(self, IsAll):
        self._IsAll = IsAll


    def _deserialize(self, params):
        self._DealName = params.get("DealName")
        self._LicenseType = params.get("LicenseType")
        self._QuuidList = params.get("QuuidList")
        self._IsAll = params.get("IsAll")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateBuyBindTaskResponse(AbstractModel):
    """CreateBuyBindTask response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateCloudProtectServiceOrderRecordRequest(AbstractModel):
    """CreateCloudProtectServiceOrderRecord request structure.

    """

    def __init__(self):
        r"""
        :param _ResourceIds: Resource ID corresponding to cloud escort service
        :type ResourceIds: list of str
        """
        self._ResourceIds = None

    @property
    def ResourceIds(self):
        return self._ResourceIds

    @ResourceIds.setter
    def ResourceIds(self, ResourceIds):
        self._ResourceIds = ResourceIds


    def _deserialize(self, params):
        self._ResourceIds = params.get("ResourceIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateCloudProtectServiceOrderRecordResponse(AbstractModel):
    """CreateCloudProtectServiceOrderRecord response structure.

    """

    def __init__(self):
        r"""
        :param _Success: ID of the successfully received resource
        :type Success: list of str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Success = None
        self._RequestId = None

    @property
    def Success(self):
        return self._Success

    @Success.setter
    def Success(self, Success):
        self._Success = Success

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Success = params.get("Success")
        self._RequestId = params.get("RequestId")


class CreateEmergencyVulScanRequest(AbstractModel):
    """CreateEmergencyVulScan request structure.

    """

    def __init__(self):
        r"""
        :param _VulId: Vulnerability ID
        :type VulId: int
        :param _Uuids: Array of host UUID strings. This parameter is valid for specified servers.
        :type Uuids: list of str
        :param _TimeoutPeriod: Scan timeout duration, in seconds.
        :type TimeoutPeriod: int
        """
        self._VulId = None
        self._Uuids = None
        self._TimeoutPeriod = None

    @property
    def VulId(self):
        return self._VulId

    @VulId.setter
    def VulId(self, VulId):
        self._VulId = VulId

    @property
    def Uuids(self):
        return self._Uuids

    @Uuids.setter
    def Uuids(self, Uuids):
        self._Uuids = Uuids

    @property
    def TimeoutPeriod(self):
        return self._TimeoutPeriod

    @TimeoutPeriod.setter
    def TimeoutPeriod(self, TimeoutPeriod):
        self._TimeoutPeriod = TimeoutPeriod


    def _deserialize(self, params):
        self._VulId = params.get("VulId")
        self._Uuids = params.get("Uuids")
        self._TimeoutPeriod = params.get("TimeoutPeriod")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateEmergencyVulScanResponse(AbstractModel):
    """CreateEmergencyVulScan response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateIncidentBacktrackingRequest(AbstractModel):
    """CreateIncidentBacktracking request structure.

    """

    def __init__(self):
        r"""
        :param _Quuid: CWPP QUUID
        :type Quuid: str
        """
        self._Quuid = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateIncidentBacktrackingResponse(AbstractModel):
    """CreateIncidentBacktracking response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateLicenseOrderRequest(AbstractModel):
    """CreateLicenseOrder request structure.

    """

    def __init__(self):
        r"""
        :param _Tags: Tag array. Leaving it blank indicates no tags need to be bound.
        :type Tags: list of Tags
        :param _LicenseType: Authorization type. 0: Pro Edition-pay-as-you-go; 1: Pro Edition-monthly subscription; 2 - Ultimate Edition-monthly subscriptionThe default is 0.
        :type LicenseType: int
        :param _LicenseNum: Authorization quantity: the number of units that need to be purchased
The default is 1.
        :type LicenseNum: int
        :param _RegionId: Region of purchase order. In this case, only 1 - Guangzhou and 9 - Singapore are supported. Guangzhou is recommended. Singapore region is reserved for allowlisted users.
The default is 1.
        :type RegionId: int
        :param _ProjectId: Project ID
The default is 0.
        :type ProjectId: int
        :param _TimeSpan: Purchase duration, with a default value of 1. The optional values are 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 24, and 36
This parameter is only valid for monthly subscription.
        :type TimeSpan: int
        :param _AutoRenewFlag: Whether to auto-renew. The default is not to auto-renew.
This parameter is only valid for monthly subscription.
        :type AutoRenewFlag: bool
        :param _AutoProtectOpenConfig: This field is deprecated.
        :type AutoProtectOpenConfig: str
        :param _ModifyConfig: Reconfiguration Parameters
        :type ModifyConfig: :class:`tencentcloud.cwp.v20180228.models.OrderModifyObject`
        """
        self._Tags = None
        self._LicenseType = None
        self._LicenseNum = None
        self._RegionId = None
        self._ProjectId = None
        self._TimeSpan = None
        self._AutoRenewFlag = None
        self._AutoProtectOpenConfig = None
        self._ModifyConfig = None

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def LicenseType(self):
        return self._LicenseType

    @LicenseType.setter
    def LicenseType(self, LicenseType):
        self._LicenseType = LicenseType

    @property
    def LicenseNum(self):
        return self._LicenseNum

    @LicenseNum.setter
    def LicenseNum(self, LicenseNum):
        self._LicenseNum = LicenseNum

    @property
    def RegionId(self):
        return self._RegionId

    @RegionId.setter
    def RegionId(self, RegionId):
        self._RegionId = RegionId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TimeSpan(self):
        return self._TimeSpan

    @TimeSpan.setter
    def TimeSpan(self, TimeSpan):
        self._TimeSpan = TimeSpan

    @property
    def AutoRenewFlag(self):
        return self._AutoRenewFlag

    @AutoRenewFlag.setter
    def AutoRenewFlag(self, AutoRenewFlag):
        self._AutoRenewFlag = AutoRenewFlag

    @property
    def AutoProtectOpenConfig(self):
        return self._AutoProtectOpenConfig

    @AutoProtectOpenConfig.setter
    def AutoProtectOpenConfig(self, AutoProtectOpenConfig):
        self._AutoProtectOpenConfig = AutoProtectOpenConfig

    @property
    def ModifyConfig(self):
        return self._ModifyConfig

    @ModifyConfig.setter
    def ModifyConfig(self, ModifyConfig):
        self._ModifyConfig = ModifyConfig


    def _deserialize(self, params):
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tags()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._LicenseType = params.get("LicenseType")
        self._LicenseNum = params.get("LicenseNum")
        self._RegionId = params.get("RegionId")
        self._ProjectId = params.get("ProjectId")
        self._TimeSpan = params.get("TimeSpan")
        self._AutoRenewFlag = params.get("AutoRenewFlag")
        self._AutoProtectOpenConfig = params.get("AutoProtectOpenConfig")
        if params.get("ModifyConfig") is not None:
            self._ModifyConfig = OrderModifyObject()
            self._ModifyConfig._deserialize(params.get("ModifyConfig"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateLicenseOrderResponse(AbstractModel):
    """CreateLicenseOrder response structure.

    """

    def __init__(self):
        r"""
        :param _DealNames: Order ID list
        :type DealNames: list of str
        :param _ResourceIds: Resource ID list. This field needs to be left blank for prepaid orders.
        :type ResourceIds: list of str
        :param _BigDealId: Large order ID. This field needs to be left blank for postpaid orders.
        :type BigDealId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DealNames = None
        self._ResourceIds = None
        self._BigDealId = None
        self._RequestId = None

    @property
    def DealNames(self):
        return self._DealNames

    @DealNames.setter
    def DealNames(self, DealNames):
        self._DealNames = DealNames

    @property
    def ResourceIds(self):
        return self._ResourceIds

    @ResourceIds.setter
    def ResourceIds(self, ResourceIds):
        self._ResourceIds = ResourceIds

    @property
    def BigDealId(self):
        return self._BigDealId

    @BigDealId.setter
    def BigDealId(self, BigDealId):
        self._BigDealId = BigDealId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DealNames = params.get("DealNames")
        self._ResourceIds = params.get("ResourceIds")
        self._BigDealId = params.get("BigDealId")
        self._RequestId = params.get("RequestId")


class CreateLogExportRequest(AbstractModel):
    """CreateLogExport request structure.

    """

    def __init__(self):
        r"""
        :param _Count: Number of logs exported. The maximum value is 50 million.
        :type Count: int
        :param _StartTime: Start time of log export, with a timestamp in milliseconds
        :type StartTime: int
        :param _EndTime: End time of log export, with a timestamp in milliseconds
        :type EndTime: int
        :param _QueryString: Retrieval statements for log export, and [SQL statements] are not supported
        :type QueryString: str
        :param _Sort: Sorting for log export time. Valid values are asc and desc, and the default value is desc.
        :type Sort: str
        :param _Format: Data format for exported log. Valid values are json an csv, the default value is json.
        :type Format: str
        """
        self._Count = None
        self._StartTime = None
        self._EndTime = None
        self._QueryString = None
        self._Sort = None
        self._Format = None

    @property
    def Count(self):
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def QueryString(self):
        return self._QueryString

    @QueryString.setter
    def QueryString(self, QueryString):
        self._QueryString = QueryString

    @property
    def Sort(self):
        return self._Sort

    @Sort.setter
    def Sort(self, Sort):
        self._Sort = Sort

    @property
    def Format(self):
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format


    def _deserialize(self, params):
        self._Count = params.get("Count")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._QueryString = params.get("QueryString")
        self._Sort = params.get("Sort")
        self._Format = params.get("Format")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateLogExportResponse(AbstractModel):
    """CreateLogExport response structure.

    """

    def __init__(self):
        r"""
        :param _ExportId: Task ID of exported logs
        :type ExportId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ExportId = None
        self._RequestId = None

    @property
    def ExportId(self):
        return self._ExportId

    @ExportId.setter
    def ExportId(self, ExportId):
        self._ExportId = ExportId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ExportId = params.get("ExportId")
        self._RequestId = params.get("RequestId")


class CreateMaliciousRequestWhiteListRequest(AbstractModel):
    """CreateMaliciousRequestWhiteList request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Allowlisted domain names
        :type Domain: str
        :param _Mark: Remarks
        :type Mark: str
        """
        self._Domain = None
        self._Mark = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Mark(self):
        return self._Mark

    @Mark.setter
    def Mark(self, Mark):
        self._Mark = Mark


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Mark = params.get("Mark")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateMaliciousRequestWhiteListResponse(AbstractModel):
    """CreateMaliciousRequestWhiteList response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateMalwareWhiteListRequest(AbstractModel):
    """CreateMalwareWhiteList request structure.

    """

    def __init__(self):
        r"""
        :param _Mode: Allowlist mode. 0: MD5 allowlist; 1: customization
        :type Mode: int
        :param _QuuidList: QUUID list
        :type QuuidList: list of str
        :param _IsGlobal: Whether applies all hosts. 0: no; 1: yes
        :type IsGlobal: int
        :param _MatchType: Matching pattern; 0 for exact match, 1 for fuzzy match (deprecated).
        :type MatchType: int
        :param _FileName: File Name (regular expression); up to 200 characters in length
        :type FileName: list of str
        :param _FileDirectory: File Directory (regular expression); up to 200 characters in length, content base64 encoded.
        :type FileDirectory: list of str
        :param _FileExtension: File Suffix; Up to 200 characters in length, content base64 escaped (deprecated)
        :type FileExtension: list of str
        :param _Md5List: MD5 list
        :type Md5List: list of str
        :param _EventId: Trojan event ID
        :type EventId: int
        :param _IsHandleHistoryEvents: 
        :type IsHandleHistoryEvents: int
        """
        self._Mode = None
        self._QuuidList = None
        self._IsGlobal = None
        self._MatchType = None
        self._FileName = None
        self._FileDirectory = None
        self._FileExtension = None
        self._Md5List = None
        self._EventId = None
        self._IsHandleHistoryEvents = None

    @property
    def Mode(self):
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def QuuidList(self):
        return self._QuuidList

    @QuuidList.setter
    def QuuidList(self, QuuidList):
        self._QuuidList = QuuidList

    @property
    def IsGlobal(self):
        return self._IsGlobal

    @IsGlobal.setter
    def IsGlobal(self, IsGlobal):
        self._IsGlobal = IsGlobal

    @property
    def MatchType(self):
        return self._MatchType

    @MatchType.setter
    def MatchType(self, MatchType):
        self._MatchType = MatchType

    @property
    def FileName(self):
        return self._FileName

    @FileName.setter
    def FileName(self, FileName):
        self._FileName = FileName

    @property
    def FileDirectory(self):
        return self._FileDirectory

    @FileDirectory.setter
    def FileDirectory(self, FileDirectory):
        self._FileDirectory = FileDirectory

    @property
    def FileExtension(self):
        return self._FileExtension

    @FileExtension.setter
    def FileExtension(self, FileExtension):
        self._FileExtension = FileExtension

    @property
    def Md5List(self):
        return self._Md5List

    @Md5List.setter
    def Md5List(self, Md5List):
        self._Md5List = Md5List

    @property
    def EventId(self):
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId

    @property
    def IsHandleHistoryEvents(self):
        return self._IsHandleHistoryEvents

    @IsHandleHistoryEvents.setter
    def IsHandleHistoryEvents(self, IsHandleHistoryEvents):
        self._IsHandleHistoryEvents = IsHandleHistoryEvents


    def _deserialize(self, params):
        self._Mode = params.get("Mode")
        self._QuuidList = params.get("QuuidList")
        self._IsGlobal = params.get("IsGlobal")
        self._MatchType = params.get("MatchType")
        self._FileName = params.get("FileName")
        self._FileDirectory = params.get("FileDirectory")
        self._FileExtension = params.get("FileExtension")
        self._Md5List = params.get("Md5List")
        self._EventId = params.get("EventId")
        self._IsHandleHistoryEvents = params.get("IsHandleHistoryEvents")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateMalwareWhiteListResponse(AbstractModel):
    """CreateMalwareWhiteList response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateNetAttackWhiteListRequest(AbstractModel):
    """CreateNetAttackWhiteList request structure.

    """

    def __init__(self):
        r"""
        :param _Scope: Whether the allowlist applies to all hosts. 0: no; 1: yes.
        :type Scope: int
        :param _SrcIp: Source IP. Single IP: 1.1.1.1, IP Range: 1.1.1.1-1.1.2.1, IP Range: 1.1.1.0/24 
        :type SrcIp: list of str
        :param _QuuidList: QUUID list
        :type QuuidList: list of str
        :param _EventId: Event ID
        :type EventId: int
        :param _DealOldEvents: Whether to allowlist all alarms that match this rule: 1: Yes, 0: No.
        :type DealOldEvents: int
        :param _Description: Description
        :type Description: str
        """
        self._Scope = None
        self._SrcIp = None
        self._QuuidList = None
        self._EventId = None
        self._DealOldEvents = None
        self._Description = None

    @property
    def Scope(self):
        return self._Scope

    @Scope.setter
    def Scope(self, Scope):
        self._Scope = Scope

    @property
    def SrcIp(self):
        return self._SrcIp

    @SrcIp.setter
    def SrcIp(self, SrcIp):
        self._SrcIp = SrcIp

    @property
    def QuuidList(self):
        return self._QuuidList

    @QuuidList.setter
    def QuuidList(self, QuuidList):
        self._QuuidList = QuuidList

    @property
    def EventId(self):
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId

    @property
    def DealOldEvents(self):
        return self._DealOldEvents

    @DealOldEvents.setter
    def DealOldEvents(self, DealOldEvents):
        self._DealOldEvents = DealOldEvents

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._Scope = params.get("Scope")
        self._SrcIp = params.get("SrcIp")
        self._QuuidList = params.get("QuuidList")
        self._EventId = params.get("EventId")
        self._DealOldEvents = params.get("DealOldEvents")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateNetAttackWhiteListResponse(AbstractModel):
    """CreateNetAttackWhiteList response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateRansomDefenseStrategyRequest(AbstractModel):
    """CreateRansomDefenseStrategy request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Policy name
        :type Name: str
        :param _Hour: Scheduled snapshot execution time (0-23): 01:00; 23:00.
        :type Hour: str
        :param _Id: Policy ID: Modify the policy when filling in the ID. Otherwise, add a new policy.
        :type Id: int
        :param _Description: Policy Remarks
        :type Description: str
        :param _Status: Whether to enable: 0 Off, 1 On.
        :type Status: int
        :param _IsAll: Apply to all machines or not. 0: No; 1: Yes
        :type IsAll: int
        :param _IncludeDir: Include directories, separated by semicolons (;).
        :type IncludeDir: str
        :param _ExcludeDir: Exclude directories, separated by semicolons (;).
        :type ExcludeDir: str
        :param _BackupType: Backup pattern: 0 weekly, 1 daily.
        :type BackupType: int
        :param _Weekday: Scheduled task execution days in a week (1-7): 1; 2; 7.
        :type Weekday: str
        :param _SaveDay: Retention Period: 0 Permanent.
        :type SaveDay: int
        :param _Machines: Bound Host List
        :type Machines: list of RansomDefenseStrategyMachineInfo
        """
        self._Name = None
        self._Hour = None
        self._Id = None
        self._Description = None
        self._Status = None
        self._IsAll = None
        self._IncludeDir = None
        self._ExcludeDir = None
        self._BackupType = None
        self._Weekday = None
        self._SaveDay = None
        self._Machines = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Hour(self):
        return self._Hour

    @Hour.setter
    def Hour(self, Hour):
        self._Hour = Hour

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def IsAll(self):
        return self._IsAll

    @IsAll.setter
    def IsAll(self, IsAll):
        self._IsAll = IsAll

    @property
    def IncludeDir(self):
        return self._IncludeDir

    @IncludeDir.setter
    def IncludeDir(self, IncludeDir):
        self._IncludeDir = IncludeDir

    @property
    def ExcludeDir(self):
        return self._ExcludeDir

    @ExcludeDir.setter
    def ExcludeDir(self, ExcludeDir):
        self._ExcludeDir = ExcludeDir

    @property
    def BackupType(self):
        return self._BackupType

    @BackupType.setter
    def BackupType(self, BackupType):
        self._BackupType = BackupType

    @property
    def Weekday(self):
        return self._Weekday

    @Weekday.setter
    def Weekday(self, Weekday):
        self._Weekday = Weekday

    @property
    def SaveDay(self):
        return self._SaveDay

    @SaveDay.setter
    def SaveDay(self, SaveDay):
        self._SaveDay = SaveDay

    @property
    def Machines(self):
        return self._Machines

    @Machines.setter
    def Machines(self, Machines):
        self._Machines = Machines


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Hour = params.get("Hour")
        self._Id = params.get("Id")
        self._Description = params.get("Description")
        self._Status = params.get("Status")
        self._IsAll = params.get("IsAll")
        self._IncludeDir = params.get("IncludeDir")
        self._ExcludeDir = params.get("ExcludeDir")
        self._BackupType = params.get("BackupType")
        self._Weekday = params.get("Weekday")
        self._SaveDay = params.get("SaveDay")
        if params.get("Machines") is not None:
            self._Machines = []
            for item in params.get("Machines"):
                obj = RansomDefenseStrategyMachineInfo()
                obj._deserialize(item)
                self._Machines.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRansomDefenseStrategyResponse(AbstractModel):
    """CreateRansomDefenseStrategy response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateScanMalwareSettingRequest(AbstractModel):
    """CreateScanMalwareSetting request structure.

    """

    def __init__(self):
        r"""
        :param _ScanPattern: Scan mode: 0 - full disk scan; 1 - rapid scan
        :type ScanPattern: int
        :param _HostType: Server classification: 1: Professional Edition servers; 2: self-selected servers
        :type HostType: int
        :param _QuuidList: Effective for selected servers; a string array of host QUUIDs
        :type QuuidList: list of str
        :param _TimeoutPeriod: Timeout unit: seconds, which is 3,600 seconds by default.
        :type TimeoutPeriod: int
        :param _EngineType: 1 - standard mode (only critical and high-risk are reported.); 2 - enhanced mode (critical, high-risk, and medium-risk are reported.); 3 - strict mode (critical, high-risk, medium-risk, low-risk, and prompt are reported.)
        :type EngineType: int
        :param _EnableMemShellScan: Whether to enable malicious process killing [0: Not Enabled; 1: Enabled]
        :type EnableMemShellScan: int
        """
        self._ScanPattern = None
        self._HostType = None
        self._QuuidList = None
        self._TimeoutPeriod = None
        self._EngineType = None
        self._EnableMemShellScan = None

    @property
    def ScanPattern(self):
        return self._ScanPattern

    @ScanPattern.setter
    def ScanPattern(self, ScanPattern):
        self._ScanPattern = ScanPattern

    @property
    def HostType(self):
        return self._HostType

    @HostType.setter
    def HostType(self, HostType):
        self._HostType = HostType

    @property
    def QuuidList(self):
        return self._QuuidList

    @QuuidList.setter
    def QuuidList(self, QuuidList):
        self._QuuidList = QuuidList

    @property
    def TimeoutPeriod(self):
        return self._TimeoutPeriod

    @TimeoutPeriod.setter
    def TimeoutPeriod(self, TimeoutPeriod):
        self._TimeoutPeriod = TimeoutPeriod

    @property
    def EngineType(self):
        return self._EngineType

    @EngineType.setter
    def EngineType(self, EngineType):
        self._EngineType = EngineType

    @property
    def EnableMemShellScan(self):
        return self._EnableMemShellScan

    @EnableMemShellScan.setter
    def EnableMemShellScan(self, EnableMemShellScan):
        self._EnableMemShellScan = EnableMemShellScan


    def _deserialize(self, params):
        self._ScanPattern = params.get("ScanPattern")
        self._HostType = params.get("HostType")
        self._QuuidList = params.get("QuuidList")
        self._TimeoutPeriod = params.get("TimeoutPeriod")
        self._EngineType = params.get("EngineType")
        self._EnableMemShellScan = params.get("EnableMemShellScan")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateScanMalwareSettingResponse(AbstractModel):
    """CreateScanMalwareSetting response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type TaskId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class CreateSearchLogRequest(AbstractModel):
    """CreateSearchLog request structure.

    """

    def __init__(self):
        r"""
        :param _SearchContent: Search by content
        :type SearchContent: str
        """
        self._SearchContent = None

    @property
    def SearchContent(self):
        return self._SearchContent

    @SearchContent.setter
    def SearchContent(self, SearchContent):
        self._SearchContent = SearchContent


    def _deserialize(self, params):
        self._SearchContent = params.get("SearchContent")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSearchLogResponse(AbstractModel):
    """CreateSearchLog response structure.

    """

    def __init__(self):
        r"""
        :param _Status: 0: succeeded; 	non-zero: failed
        :type Status: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Status = None
        self._RequestId = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._RequestId = params.get("RequestId")


class CreateSearchTemplateRequest(AbstractModel):
    """CreateSearchTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _SearchTemplate: Search template
        :type SearchTemplate: :class:`tencentcloud.cwp.v20180228.models.SearchTemplate`
        """
        self._SearchTemplate = None

    @property
    def SearchTemplate(self):
        return self._SearchTemplate

    @SearchTemplate.setter
    def SearchTemplate(self, SearchTemplate):
        self._SearchTemplate = SearchTemplate


    def _deserialize(self, params):
        if params.get("SearchTemplate") is not None:
            self._SearchTemplate = SearchTemplate()
            self._SearchTemplate._deserialize(params.get("SearchTemplate"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSearchTemplateResponse(AbstractModel):
    """CreateSearchTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _Status: 0: succeeded; 	non-0: failed
        :type Status: int
        :param _Message: Reason for failure
        :type Message: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Status = None
        self._Message = None
        self._RequestId = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._Message = params.get("Message")
        self._RequestId = params.get("RequestId")


class CreateVulFixRequest(AbstractModel):
    """CreateVulFix request structure.

    """

    def __init__(self):
        r"""
        :param _CreateVulFixTaskQuuids: List of hosts for which the vulnerability should be fixed
        :type CreateVulFixTaskQuuids: list of CreateVulFixTaskQuuids
        :param _SaveDays: Snapshot retention days: 0 days indicates that no snapshot will be created. Hosts without a snapshot for 24 hours must have a snapshot created to be restored.
        :type SaveDays: int
        :param _SnapshotName: Snapshot name
        :type SnapshotName: str
        """
        self._CreateVulFixTaskQuuids = None
        self._SaveDays = None
        self._SnapshotName = None

    @property
    def CreateVulFixTaskQuuids(self):
        return self._CreateVulFixTaskQuuids

    @CreateVulFixTaskQuuids.setter
    def CreateVulFixTaskQuuids(self, CreateVulFixTaskQuuids):
        self._CreateVulFixTaskQuuids = CreateVulFixTaskQuuids

    @property
    def SaveDays(self):
        return self._SaveDays

    @SaveDays.setter
    def SaveDays(self, SaveDays):
        self._SaveDays = SaveDays

    @property
    def SnapshotName(self):
        return self._SnapshotName

    @SnapshotName.setter
    def SnapshotName(self, SnapshotName):
        self._SnapshotName = SnapshotName


    def _deserialize(self, params):
        if params.get("CreateVulFixTaskQuuids") is not None:
            self._CreateVulFixTaskQuuids = []
            for item in params.get("CreateVulFixTaskQuuids"):
                obj = CreateVulFixTaskQuuids()
                obj._deserialize(item)
                self._CreateVulFixTaskQuuids.append(obj)
        self._SaveDays = params.get("SaveDays")
        self._SnapshotName = params.get("SnapshotName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVulFixResponse(AbstractModel):
    """CreateVulFix response structure.

    """

    def __init__(self):
        r"""
        :param _FixId: Task ID
        :type FixId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FixId = None
        self._RequestId = None

    @property
    def FixId(self):
        return self._FixId

    @FixId.setter
    def FixId(self, FixId):
        self._FixId = FixId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FixId = params.get("FixId")
        self._RequestId = params.get("RequestId")


class CreateVulFixTaskQuuids(AbstractModel):
    """Create QUUIDs for fixing tasks

    """

    def __init__(self):
        r"""
        :param _VulId: Vulnerability ID
        :type VulId: int
        :param _Quuids: Hosts that need to fix vulnerabilities. All hosts need to have the vulnerability with the ID of VulId and be in a pending fix status.
        :type Quuids: list of str
        :param _FixMethod: 
        :type FixMethod: int
        """
        self._VulId = None
        self._Quuids = None
        self._FixMethod = None

    @property
    def VulId(self):
        return self._VulId

    @VulId.setter
    def VulId(self, VulId):
        self._VulId = VulId

    @property
    def Quuids(self):
        return self._Quuids

    @Quuids.setter
    def Quuids(self, Quuids):
        self._Quuids = Quuids

    @property
    def FixMethod(self):
        return self._FixMethod

    @FixMethod.setter
    def FixMethod(self, FixMethod):
        self._FixMethod = FixMethod


    def _deserialize(self, params):
        self._VulId = params.get("VulId")
        self._Quuids = params.get("Quuids")
        self._FixMethod = params.get("FixMethod")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateWhiteListOrderRequest(AbstractModel):
    """CreateWhiteListOrder request structure.

    """

    def __init__(self):
        r"""
        :param _LicenseType: Authorization type
        :type LicenseType: int
        :param _LicenseNum: Number of authorizations (The minimum value is 1, and the maximum value is 99999.)
        :type LicenseNum: int
        :param _Deadline: Expiration time (The minimum value is 1.)
        :type Deadline: int
        :param _RuleName: Rule name, big asset center: asset_center
        :type RuleName: str
        :param _SourceType: Order type. 1: trial; 2: free; 3: experience; 4: free SSL certificate gift; 5: free CVM
        :type SourceType: int
        :param _RegionId: Region: 1 Guangzhou; 9 Singapore. The default is 1. Do not select 9 unless necessary.
        :type RegionId: int
        :param _ExtraParam: Additional parameters; JSON string, including ResourceId and LicenseType.
        :type ExtraParam: str
        """
        self._LicenseType = None
        self._LicenseNum = None
        self._Deadline = None
        self._RuleName = None
        self._SourceType = None
        self._RegionId = None
        self._ExtraParam = None

    @property
    def LicenseType(self):
        return self._LicenseType

    @LicenseType.setter
    def LicenseType(self, LicenseType):
        self._LicenseType = LicenseType

    @property
    def LicenseNum(self):
        return self._LicenseNum

    @LicenseNum.setter
    def LicenseNum(self, LicenseNum):
        self._LicenseNum = LicenseNum

    @property
    def Deadline(self):
        return self._Deadline

    @Deadline.setter
    def Deadline(self, Deadline):
        self._Deadline = Deadline

    @property
    def RuleName(self):
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName

    @property
    def SourceType(self):
        return self._SourceType

    @SourceType.setter
    def SourceType(self, SourceType):
        self._SourceType = SourceType

    @property
    def RegionId(self):
        return self._RegionId

    @RegionId.setter
    def RegionId(self, RegionId):
        self._RegionId = RegionId

    @property
    def ExtraParam(self):
        return self._ExtraParam

    @ExtraParam.setter
    def ExtraParam(self, ExtraParam):
        self._ExtraParam = ExtraParam


    def _deserialize(self, params):
        self._LicenseType = params.get("LicenseType")
        self._LicenseNum = params.get("LicenseNum")
        self._Deadline = params.get("Deadline")
        self._RuleName = params.get("RuleName")
        self._SourceType = params.get("SourceType")
        self._RegionId = params.get("RegionId")
        self._ExtraParam = params.get("ExtraParam")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateWhiteListOrderResponse(AbstractModel):
    """CreateWhiteListOrder response structure.

    """

    def __init__(self):
        r"""
        :param _Resource: Resource object
        :type Resource: :class:`tencentcloud.cwp.v20180228.models.OrderResource`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Resource = None
        self._RequestId = None

    @property
    def Resource(self):
        return self._Resource

    @Resource.setter
    def Resource(self, Resource):
        self._Resource = Resource

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Resource") is not None:
            self._Resource = OrderResource()
            self._Resource._deserialize(params.get("Resource"))
        self._RequestId = params.get("RequestId")


class DefaultStrategyInfo(AbstractModel):
    """Default policy basic information

    """

    def __init__(self):
        r"""
        :param _StrategyName: Policy name
        :type StrategyName: str
        :param _StrategyId: Policy ID
        :type StrategyId: int
        """
        self._StrategyName = None
        self._StrategyId = None

    @property
    def StrategyName(self):
        return self._StrategyName

    @StrategyName.setter
    def StrategyName(self, StrategyName):
        self._StrategyName = StrategyName

    @property
    def StrategyId(self):
        return self._StrategyId

    @StrategyId.setter
    def StrategyId(self, StrategyId):
        self._StrategyId = StrategyId


    def _deserialize(self, params):
        self._StrategyName = params.get("StrategyName")
        self._StrategyId = params.get("StrategyId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DefendAttackLog(AbstractModel):
    """Network attack log

    """

    def __init__(self):
        r"""
        :param _Id: Log ID
        :type Id: int
        :param _Uuid: Client ID
        :type Uuid: str
        :param _SrcIp: Source IP
        :type SrcIp: str
        :param _SrcPort: Source port
        :type SrcPort: int
        :param _HttpMethod: Attack method
        :type HttpMethod: str
        :param _HttpCgi: Attack description
        :type HttpCgi: str
        :param _HttpParam: Attack parameter
        :type HttpParam: str
        :param _VulType: Threat type
        :type VulType: str
        :param _CreatedAt: Attack time
        :type CreatedAt: str
        :param _MachineIp: Target server IP
        :type MachineIp: str
        :param _MachineName: Target server name
        :type MachineName: str
        :param _DstIp: Target IP
        :type DstIp: str
        :param _DstPort: Target port
        :type DstPort: int
        :param _HttpContent: Attack content
        :type HttpContent: str
        :param _MachineExtraInfo: Host Additional Information
Note: This field may return null, indicating that no valid values can be obtained.
        :type MachineExtraInfo: :class:`tencentcloud.cwp.v20180228.models.MachineExtraInfo`
        """
        self._Id = None
        self._Uuid = None
        self._SrcIp = None
        self._SrcPort = None
        self._HttpMethod = None
        self._HttpCgi = None
        self._HttpParam = None
        self._VulType = None
        self._CreatedAt = None
        self._MachineIp = None
        self._MachineName = None
        self._DstIp = None
        self._DstPort = None
        self._HttpContent = None
        self._MachineExtraInfo = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def SrcIp(self):
        return self._SrcIp

    @SrcIp.setter
    def SrcIp(self, SrcIp):
        self._SrcIp = SrcIp

    @property
    def SrcPort(self):
        return self._SrcPort

    @SrcPort.setter
    def SrcPort(self, SrcPort):
        self._SrcPort = SrcPort

    @property
    def HttpMethod(self):
        return self._HttpMethod

    @HttpMethod.setter
    def HttpMethod(self, HttpMethod):
        self._HttpMethod = HttpMethod

    @property
    def HttpCgi(self):
        return self._HttpCgi

    @HttpCgi.setter
    def HttpCgi(self, HttpCgi):
        self._HttpCgi = HttpCgi

    @property
    def HttpParam(self):
        return self._HttpParam

    @HttpParam.setter
    def HttpParam(self, HttpParam):
        self._HttpParam = HttpParam

    @property
    def VulType(self):
        return self._VulType

    @VulType.setter
    def VulType(self, VulType):
        self._VulType = VulType

    @property
    def CreatedAt(self):
        return self._CreatedAt

    @CreatedAt.setter
    def CreatedAt(self, CreatedAt):
        self._CreatedAt = CreatedAt

    @property
    def MachineIp(self):
        return self._MachineIp

    @MachineIp.setter
    def MachineIp(self, MachineIp):
        self._MachineIp = MachineIp

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def DstIp(self):
        return self._DstIp

    @DstIp.setter
    def DstIp(self, DstIp):
        self._DstIp = DstIp

    @property
    def DstPort(self):
        return self._DstPort

    @DstPort.setter
    def DstPort(self, DstPort):
        self._DstPort = DstPort

    @property
    def HttpContent(self):
        return self._HttpContent

    @HttpContent.setter
    def HttpContent(self, HttpContent):
        self._HttpContent = HttpContent

    @property
    def MachineExtraInfo(self):
        return self._MachineExtraInfo

    @MachineExtraInfo.setter
    def MachineExtraInfo(self, MachineExtraInfo):
        self._MachineExtraInfo = MachineExtraInfo


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Uuid = params.get("Uuid")
        self._SrcIp = params.get("SrcIp")
        self._SrcPort = params.get("SrcPort")
        self._HttpMethod = params.get("HttpMethod")
        self._HttpCgi = params.get("HttpCgi")
        self._HttpParam = params.get("HttpParam")
        self._VulType = params.get("VulType")
        self._CreatedAt = params.get("CreatedAt")
        self._MachineIp = params.get("MachineIp")
        self._MachineName = params.get("MachineName")
        self._DstIp = params.get("DstIp")
        self._DstPort = params.get("DstPort")
        self._HttpContent = params.get("HttpContent")
        if params.get("MachineExtraInfo") is not None:
            self._MachineExtraInfo = MachineExtraInfo()
            self._MachineExtraInfo._deserialize(params.get("MachineExtraInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAllJavaMemShellsRequest(AbstractModel):
    """DeleteAllJavaMemShells request structure.

    """

    def __init__(self):
        r"""
        :param _Quuid: Server QUUID
        :type Quuid: str
        """
        self._Quuid = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAllJavaMemShellsResponse(AbstractModel):
    """DeleteAllJavaMemShells response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteBanWhiteListRequest(AbstractModel):
    """DeleteBanWhiteList request structure.

    """

    def __init__(self):
        r"""
        :param _Ids: Allowlist ID list to be deleted (up to 100)
        :type Ids: list of int non-negative
        """
        self._Ids = None

    @property
    def Ids(self):
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids


    def _deserialize(self, params):
        self._Ids = params.get("Ids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteBanWhiteListResponse(AbstractModel):
    """DeleteBanWhiteList response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteBaselinePolicyRequest(AbstractModel):
    """DeleteBaselinePolicy request structure.

    """

    def __init__(self):
        r"""
        :param _PolicyIds: Policy ID
        :type PolicyIds: list of int
        """
        self._PolicyIds = None

    @property
    def PolicyIds(self):
        return self._PolicyIds

    @PolicyIds.setter
    def PolicyIds(self, PolicyIds):
        self._PolicyIds = PolicyIds


    def _deserialize(self, params):
        self._PolicyIds = params.get("PolicyIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteBaselinePolicyResponse(AbstractModel):
    """DeleteBaselinePolicy response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteBaselineStrategyRequest(AbstractModel):
    """DeleteBaselineStrategy request structure.

    """

    def __init__(self):
        r"""
        :param _StrategyId: Baseline policy ID
        :type StrategyId: int
        """
        self._StrategyId = None

    @property
    def StrategyId(self):
        return self._StrategyId

    @StrategyId.setter
    def StrategyId(self, StrategyId):
        self._StrategyId = StrategyId


    def _deserialize(self, params):
        self._StrategyId = params.get("StrategyId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteBaselineStrategyResponse(AbstractModel):
    """DeleteBaselineStrategy response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteBashEventsRequest(AbstractModel):
    """DeleteBashEvents request structure.

    """

    def __init__(self):
        r"""
        :param _Ids: ID array. Maximum number of IDs: 100.
        :type Ids: list of int non-negative
        """
        self._Ids = None

    @property
    def Ids(self):
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids


    def _deserialize(self, params):
        self._Ids = params.get("Ids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteBashEventsResponse(AbstractModel):
    """DeleteBashEvents response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteBashPoliciesRequest(AbstractModel):
    """DeleteBashPolicies request structure.

    """

    def __init__(self):
        r"""
        :param _Ids: ID array, with the maximum value being 100.
        :type Ids: list of int non-negative
        """
        self._Ids = None

    @property
    def Ids(self):
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids


    def _deserialize(self, params):
        self._Ids = params.get("Ids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteBashPoliciesResponse(AbstractModel):
    """DeleteBashPolicies response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteBashRulesRequest(AbstractModel):
    """DeleteBashRules request structure.

    """

    def __init__(self):
        r"""
        :param _Ids: ID array (The maximum number of IDs is 100)
        :type Ids: list of int non-negative
        """
        self._Ids = None

    @property
    def Ids(self):
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids


    def _deserialize(self, params):
        self._Ids = params.get("Ids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteBashRulesResponse(AbstractModel):
    """DeleteBashRules response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteBruteAttacksRequest(AbstractModel):
    """DeleteBruteAttacks request structure.

    """

    def __init__(self):
        r"""
        :param _Ids: Array of brute force cracking event IDs (maximum: 100)
        :type Ids: list of int non-negative
        """
        self._Ids = None

    @property
    def Ids(self):
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids


    def _deserialize(self, params):
        self._Ids = params.get("Ids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteBruteAttacksResponse(AbstractModel):
    """DeleteBruteAttacks response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteLicenseRecordAllRequest(AbstractModel):
    """DeleteLicenseRecordAll request structure.

    """


class DeleteLicenseRecordAllResponse(AbstractModel):
    """DeleteLicenseRecordAll response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteLicenseRecordRequest(AbstractModel):
    """DeleteLicenseRecord request structure.

    """

    def __init__(self):
        r"""
        :param _LicenseId: Authorization ID, which can be obtained from the authorization order list
        :type LicenseId: int
        :param _LicenseType: Authorization type
        :type LicenseType: int
        :param _ResourceId: Resource ID
        :type ResourceId: str
        """
        self._LicenseId = None
        self._LicenseType = None
        self._ResourceId = None

    @property
    def LicenseId(self):
        return self._LicenseId

    @LicenseId.setter
    def LicenseId(self, LicenseId):
        self._LicenseId = LicenseId

    @property
    def LicenseType(self):
        return self._LicenseType

    @LicenseType.setter
    def LicenseType(self, LicenseType):
        self._LicenseType = LicenseType

    @property
    def ResourceId(self):
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId


    def _deserialize(self, params):
        self._LicenseId = params.get("LicenseId")
        self._LicenseType = params.get("LicenseType")
        self._ResourceId = params.get("ResourceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteLicenseRecordResponse(AbstractModel):
    """DeleteLicenseRecord response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteLogExportRequest(AbstractModel):
    """DeleteLogExport request structure.

    """

    def __init__(self):
        r"""
        :param _ExportId: Task ID of exported logs
        :type ExportId: str
        """
        self._ExportId = None

    @property
    def ExportId(self):
        return self._ExportId

    @ExportId.setter
    def ExportId(self, ExportId):
        self._ExportId = ExportId


    def _deserialize(self, params):
        self._ExportId = params.get("ExportId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteLogExportResponse(AbstractModel):
    """DeleteLogExport response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteLoginWhiteListRequest(AbstractModel):
    """DeleteLoginWhiteList request structure.

    """

    def __init__(self):
        r"""
        :param _Ids: Allowlisted IDs (The maximum number is 100.)
        :type Ids: list of int non-negative
        """
        self._Ids = None

    @property
    def Ids(self):
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids


    def _deserialize(self, params):
        self._Ids = params.get("Ids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteLoginWhiteListResponse(AbstractModel):
    """DeleteLoginWhiteList response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteMachineClearHistoryRequest(AbstractModel):
    """DeleteMachineClearHistory request structure.

    """

    def __init__(self):
        r"""
        :param _Ids: IDs of records to be deleted, up to 100 characters in length
        :type Ids: list of int non-negative
        """
        self._Ids = None

    @property
    def Ids(self):
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids


    def _deserialize(self, params):
        self._Ids = params.get("Ids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteMachineClearHistoryResponse(AbstractModel):
    """DeleteMachineClearHistory response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteMachineRequest(AbstractModel):
    """DeleteMachine request structure.

    """

    def __init__(self):
        r"""
        :param _Uuid: CWPP client Uuid
        :type Uuid: str
        """
        self._Uuid = None

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid


    def _deserialize(self, params):
        self._Uuid = params.get("Uuid")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteMachineResponse(AbstractModel):
    """DeleteMachine response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteMachineTagRequest(AbstractModel):
    """DeleteMachineTag request structure.

    """

    def __init__(self):
        r"""
        :param _Rid: Associated tag ID
        :type Rid: int
        """
        self._Rid = None

    @property
    def Rid(self):
        return self._Rid

    @Rid.setter
    def Rid(self, Rid):
        self._Rid = Rid


    def _deserialize(self, params):
        self._Rid = params.get("Rid")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteMachineTagResponse(AbstractModel):
    """DeleteMachineTag response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteMaliciousRequestWhiteListRequest(AbstractModel):
    """DeleteMaliciousRequestWhiteList request structure.

    """

    def __init__(self):
        r"""
        :param _Ids: Allowlist IDs (The maximum number is 100.)
        :type Ids: list of int non-negative
        """
        self._Ids = None

    @property
    def Ids(self):
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids


    def _deserialize(self, params):
        self._Ids = params.get("Ids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteMaliciousRequestWhiteListResponse(AbstractModel):
    """DeleteMaliciousRequestWhiteList response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteMaliciousRequestsRequest(AbstractModel):
    """DeleteMaliciousRequests request structure.

    """

    def __init__(self):
        r"""
        :param _Ids: Malicious request record ID array (The maximum number of IDs is 100)
        :type Ids: list of int non-negative
        """
        self._Ids = None

    @property
    def Ids(self):
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids


    def _deserialize(self, params):
        self._Ids = params.get("Ids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteMaliciousRequestsResponse(AbstractModel):
    """DeleteMaliciousRequests response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteMalwareScanTaskRequest(AbstractModel):
    """DeleteMalwareScanTask request structure.

    """


class DeleteMalwareScanTaskResponse(AbstractModel):
    """DeleteMalwareScanTask response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteMalwareWhiteListRequest(AbstractModel):
    """DeleteMalwareWhiteList request structure.

    """

    def __init__(self):
        r"""
        :param _Ids: ID array, with the maximum value being 100.
        :type Ids: list of int non-negative
        """
        self._Ids = None

    @property
    def Ids(self):
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids


    def _deserialize(self, params):
        self._Ids = params.get("Ids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteMalwareWhiteListResponse(AbstractModel):
    """DeleteMalwareWhiteList response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteMalwaresRequest(AbstractModel):
    """DeleteMalwares request structure.

    """

    def __init__(self):
        r"""
        :param _Ids: Trojan record ID array (The maximum number of IDs is 100.)
        :type Ids: list of int non-negative
        """
        self._Ids = None

    @property
    def Ids(self):
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids


    def _deserialize(self, params):
        self._Ids = params.get("Ids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteMalwaresResponse(AbstractModel):
    """DeleteMalwares response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteNetAttackWhiteListRequest(AbstractModel):
    """DeleteNetAttackWhiteList request structure.

    """

    def __init__(self):
        r"""
        :param _Ids: ID array, with the maximum value being 100.
        :type Ids: list of int non-negative
        """
        self._Ids = None

    @property
    def Ids(self):
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids


    def _deserialize(self, params):
        self._Ids = params.get("Ids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteNetAttackWhiteListResponse(AbstractModel):
    """DeleteNetAttackWhiteList response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteNonlocalLoginPlacesRequest(AbstractModel):
    """DeleteNonlocalLoginPlaces request structure.

    """

    def __init__(self):
        r"""
        :param _DelType: Method for deleting cross-region log-in events, available values are Ids, Ip, and All. The default is Ids.
        :type DelType: str
        :param _Ids: Array of cross-region log-in event IDs. Required if DelType is Ids or DelType is not filled.
        :type Ids: list of int non-negative
        :param _Ip: IP of cross-region log-in event. Required if DelType is Ip.
        :type Ip: list of str
        :param _Uuid: Host UUID
        :type Uuid: str
        """
        self._DelType = None
        self._Ids = None
        self._Ip = None
        self._Uuid = None

    @property
    def DelType(self):
        return self._DelType

    @DelType.setter
    def DelType(self, DelType):
        self._DelType = DelType

    @property
    def Ids(self):
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids

    @property
    def Ip(self):
        return self._Ip

    @Ip.setter
    def Ip(self, Ip):
        self._Ip = Ip

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid


    def _deserialize(self, params):
        self._DelType = params.get("DelType")
        self._Ids = params.get("Ids")
        self._Ip = params.get("Ip")
        self._Uuid = params.get("Uuid")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteNonlocalLoginPlacesResponse(AbstractModel):
    """DeleteNonlocalLoginPlaces response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeletePrivilegeEventsRequest(AbstractModel):
    """DeletePrivilegeEvents request structure.

    """

    def __init__(self):
        r"""
        :param _Ids: ID array, with the maximum number being 100.
        :type Ids: list of int non-negative
        """
        self._Ids = None

    @property
    def Ids(self):
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids


    def _deserialize(self, params):
        self._Ids = params.get("Ids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeletePrivilegeEventsResponse(AbstractModel):
    """DeletePrivilegeEvents response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeletePrivilegeRulesRequest(AbstractModel):
    """DeletePrivilegeRules request structure.

    """

    def __init__(self):
        r"""
        :param _Ids: ID array, with the maximum value being 100.
        :type Ids: list of int non-negative
        """
        self._Ids = None

    @property
    def Ids(self):
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids


    def _deserialize(self, params):
        self._Ids = params.get("Ids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeletePrivilegeRulesResponse(AbstractModel):
    """DeletePrivilegeRules response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteReverseShellEventsRequest(AbstractModel):
    """DeleteReverseShellEvents request structure.

    """

    def __init__(self):
        r"""
        :param _Ids: ID array, with the maximum value being 100.
        :type Ids: list of int non-negative
        """
        self._Ids = None

    @property
    def Ids(self):
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids


    def _deserialize(self, params):
        self._Ids = params.get("Ids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteReverseShellEventsResponse(AbstractModel):
    """DeleteReverseShellEvents response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteReverseShellRulesRequest(AbstractModel):
    """DeleteReverseShellRules request structure.

    """

    def __init__(self):
        r"""
        :param _Ids: ID array (The maximum quantity is 100.)
        :type Ids: list of int non-negative
        """
        self._Ids = None

    @property
    def Ids(self):
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids


    def _deserialize(self, params):
        self._Ids = params.get("Ids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteReverseShellRulesResponse(AbstractModel):
    """DeleteReverseShellRules response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteRiskDnsEventRequest(AbstractModel):
    """DeleteRiskDnsEvent request structure.

    """

    def __init__(self):
        r"""
        :param _Ids: Malicious request record ID array. (The maximum number of IDs is 100.) Delete all if it is left blank.
        :type Ids: list of int
        """
        self._Ids = None

    @property
    def Ids(self):
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids


    def _deserialize(self, params):
        self._Ids = params.get("Ids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRiskDnsEventResponse(AbstractModel):
    """DeleteRiskDnsEvent response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteRiskDnsPolicyRequest(AbstractModel):
    """DeleteRiskDnsPolicy request structure.

    """

    def __init__(self):
        r"""
        :param _PolicyIds: Policy ID
        :type PolicyIds: list of int
        """
        self._PolicyIds = None

    @property
    def PolicyIds(self):
        return self._PolicyIds

    @PolicyIds.setter
    def PolicyIds(self, PolicyIds):
        self._PolicyIds = PolicyIds


    def _deserialize(self, params):
        self._PolicyIds = params.get("PolicyIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRiskDnsPolicyResponse(AbstractModel):
    """DeleteRiskDnsPolicy response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteScanTaskRequest(AbstractModel):
    """DeleteScanTask request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID
        :type TaskId: int
        :param _ModuleType: Module type. Malware (Trojan), Vul (vulnerability), and Baseline are currently available.
        :type ModuleType: str
        :param _QuuidList: Effective for selected servers; a string array of host QUUIDs
        :type QuuidList: list of str
        """
        self._TaskId = None
        self._ModuleType = None
        self._QuuidList = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ModuleType(self):
        return self._ModuleType

    @ModuleType.setter
    def ModuleType(self, ModuleType):
        self._ModuleType = ModuleType

    @property
    def QuuidList(self):
        return self._QuuidList

    @QuuidList.setter
    def QuuidList(self, QuuidList):
        self._QuuidList = QuuidList


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ModuleType = params.get("ModuleType")
        self._QuuidList = params.get("QuuidList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteScanTaskResponse(AbstractModel):
    """DeleteScanTask response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteSearchTemplateRequest(AbstractModel):
    """DeleteSearchTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Id: Template ID
        :type Id: int
        """
        self._Id = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSearchTemplateResponse(AbstractModel):
    """DeleteSearchTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _Status: 0: succeeded; 	non-zero: failed
        :type Status: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Status = None
        self._RequestId = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._RequestId = params.get("RequestId")


class DeleteTagsRequest(AbstractModel):
    """DeleteTags request structure.

    """

    def __init__(self):
        r"""
        :param _Ids:  Tag ID (maximum: 100)
        :type Ids: list of int non-negative
        """
        self._Ids = None

    @property
    def Ids(self):
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids


    def _deserialize(self, params):
        self._Ids = params.get("Ids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteTagsResponse(AbstractModel):
    """DeleteTags response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteWebHookPolicyRequest(AbstractModel):
    """DeleteWebHookPolicy request structure.

    """

    def __init__(self):
        r"""
        :param _Ids: ID list
        :type Ids: list of int
        """
        self._Ids = None

    @property
    def Ids(self):
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids


    def _deserialize(self, params):
        self._Ids = params.get("Ids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteWebHookPolicyResponse(AbstractModel):
    """DeleteWebHookPolicy response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteWebHookReceiverRequest(AbstractModel):
    """DeleteWebHookReceiver request structure.

    """

    def __init__(self):
        r"""
        :param _Ids: ID array
        :type Ids: list of int
        """
        self._Ids = None

    @property
    def Ids(self):
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids


    def _deserialize(self, params):
        self._Ids = params.get("Ids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteWebHookReceiverResponse(AbstractModel):
    """DeleteWebHookReceiver response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteWebHookRuleRequest(AbstractModel):
    """DeleteWebHookRule request structure.

    """

    def __init__(self):
        r"""
        :param _Ids: Rule ID list
        :type Ids: list of int
        """
        self._Ids = None

    @property
    def Ids(self):
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids


    def _deserialize(self, params):
        self._Ids = params.get("Ids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteWebHookRuleResponse(AbstractModel):
    """DeleteWebHookRule response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeliverTypeDetails(AbstractModel):
    """Log shipping type details

    """

    def __init__(self):
        r"""
        :param _SecurityType: Security module type. 1: intrusion detection; 2: vulnerability management; 3: baseline management; 4: advanced defense; 5: client security; 6: asset fingerprint; 7: host list; 8: client reporting.
        :type SecurityType: int
        :param _LogType: Type of logs of the security module
        :type LogType: list of int
        :param _TopicId: Topic ID
        :type TopicId: str
        :param _TopicName: Topic name
        :type TopicName: str
        :param _Switch: Shipping enabling status. 0: disabled; 1: enabled.
        :type Switch: int
        :param _Status: Shipping status. 0: disabled; 1: normal; 2: abnormal.
        :type Status: int
        :param _ErrInfo: Error message
        :type ErrInfo: str
        :param _StatusTime: Timestamp of last status reporting
        :type StatusTime: int
        :param _LogName: Logset name
        :type LogName: str
        :param _LogSetId: Logset ID
        :type LogSetId: str
        :param _Region: Logset region
        :type Region: str
        """
        self._SecurityType = None
        self._LogType = None
        self._TopicId = None
        self._TopicName = None
        self._Switch = None
        self._Status = None
        self._ErrInfo = None
        self._StatusTime = None
        self._LogName = None
        self._LogSetId = None
        self._Region = None

    @property
    def SecurityType(self):
        return self._SecurityType

    @SecurityType.setter
    def SecurityType(self, SecurityType):
        self._SecurityType = SecurityType

    @property
    def LogType(self):
        return self._LogType

    @LogType.setter
    def LogType(self, LogType):
        self._LogType = LogType

    @property
    def TopicId(self):
        return self._TopicId

    @TopicId.setter
    def TopicId(self, TopicId):
        self._TopicId = TopicId

    @property
    def TopicName(self):
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrInfo(self):
        return self._ErrInfo

    @ErrInfo.setter
    def ErrInfo(self, ErrInfo):
        self._ErrInfo = ErrInfo

    @property
    def StatusTime(self):
        return self._StatusTime

    @StatusTime.setter
    def StatusTime(self, StatusTime):
        self._StatusTime = StatusTime

    @property
    def LogName(self):
        return self._LogName

    @LogName.setter
    def LogName(self, LogName):
        self._LogName = LogName

    @property
    def LogSetId(self):
        return self._LogSetId

    @LogSetId.setter
    def LogSetId(self, LogSetId):
        self._LogSetId = LogSetId

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region


    def _deserialize(self, params):
        self._SecurityType = params.get("SecurityType")
        self._LogType = params.get("LogType")
        self._TopicId = params.get("TopicId")
        self._TopicName = params.get("TopicName")
        self._Switch = params.get("Switch")
        self._Status = params.get("Status")
        self._ErrInfo = params.get("ErrInfo")
        self._StatusTime = params.get("StatusTime")
        self._LogName = params.get("LogName")
        self._LogSetId = params.get("LogSetId")
        self._Region = params.get("Region")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeABTestConfigRequest(AbstractModel):
    """DescribeABTestConfig request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectName: Greyscale project name
        :type ProjectName: str
        """
        self._ProjectName = None

    @property
    def ProjectName(self):
        return self._ProjectName

    @ProjectName.setter
    def ProjectName(self, ProjectName):
        self._ProjectName = ProjectName


    def _deserialize(self, params):
        self._ProjectName = params.get("ProjectName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeABTestConfigResponse(AbstractModel):
    """DescribeABTestConfig response structure.

    """

    def __init__(self):
        r"""
        :param _Config: Grayscale project configuration
        :type Config: list of ABTestConfig
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Config = None
        self._RequestId = None

    @property
    def Config(self):
        return self._Config

    @Config.setter
    def Config(self, Config):
        self._Config = Config

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Config") is not None:
            self._Config = []
            for item in params.get("Config"):
                obj = ABTestConfig()
                obj._deserialize(item)
                self._Config.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAESKeyRequest(AbstractModel):
    """DescribeAESKey request structure.

    """


class DescribeAESKeyResponse(AbstractModel):
    """DescribeAESKey response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DescribeAccountStatisticsRequest(AbstractModel):
    """DescribeAccountStatistics request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of entries to be returned. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Filters: Filtering criteria
<li>Username - String - required: no - account username</li>
        :type Filters: list of Filter
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAccountStatisticsResponse(AbstractModel):
    """DescribeAccountStatistics response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of account statistics list records
        :type TotalCount: int
        :param _AccountStatistics: Account statistics list
        :type AccountStatistics: list of AccountStatistics
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._AccountStatistics = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AccountStatistics(self):
        return self._AccountStatistics

    @AccountStatistics.setter
    def AccountStatistics(self, AccountStatistics):
        self._AccountStatistics = AccountStatistics

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AccountStatistics") is not None:
            self._AccountStatistics = []
            for item in params.get("AccountStatistics"):
                obj = AccountStatistics()
                obj._deserialize(item)
                self._AccountStatistics.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAgentInstallCommandRequest(AbstractModel):
    """DescribeAgentInstallCommand request structure.

    """

    def __init__(self):
        r"""
        :param _IsCloud: Whether Tencent Cloud
        :type IsCloud: bool
        :param _NetType: Network type: basic - basic network; private - VPC; public - public network; direct - direct connect
        :type NetType: str
        :param _RegionCode: Region identifier, required when NetType=direct
        :type RegionCode: str
        :param _VpcId: VpcId, required when NetType=direct
        :type VpcId: str
        :param _TagIds: Tag ID list, effective only when IsCloud=false
        :type TagIds: list of int non-negative
        :param _ExpireDate: Command validity period, required for non-Tencent Cloud instances
        :type ExpireDate: str
        :param _Vip: VIP Accessed via Proxy Mode
        :type Vip: str
        """
        self._IsCloud = None
        self._NetType = None
        self._RegionCode = None
        self._VpcId = None
        self._TagIds = None
        self._ExpireDate = None
        self._Vip = None

    @property
    def IsCloud(self):
        return self._IsCloud

    @IsCloud.setter
    def IsCloud(self, IsCloud):
        self._IsCloud = IsCloud

    @property
    def NetType(self):
        return self._NetType

    @NetType.setter
    def NetType(self, NetType):
        self._NetType = NetType

    @property
    def RegionCode(self):
        return self._RegionCode

    @RegionCode.setter
    def RegionCode(self, RegionCode):
        self._RegionCode = RegionCode

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def TagIds(self):
        return self._TagIds

    @TagIds.setter
    def TagIds(self, TagIds):
        self._TagIds = TagIds

    @property
    def ExpireDate(self):
        return self._ExpireDate

    @ExpireDate.setter
    def ExpireDate(self, ExpireDate):
        self._ExpireDate = ExpireDate

    @property
    def Vip(self):
        return self._Vip

    @Vip.setter
    def Vip(self, Vip):
        self._Vip = Vip


    def _deserialize(self, params):
        self._IsCloud = params.get("IsCloud")
        self._NetType = params.get("NetType")
        self._RegionCode = params.get("RegionCode")
        self._VpcId = params.get("VpcId")
        self._TagIds = params.get("TagIds")
        self._ExpireDate = params.get("ExpireDate")
        self._Vip = params.get("Vip")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAgentInstallCommandResponse(AbstractModel):
    """DescribeAgentInstallCommand response structure.

    """

    def __init__(self):
        r"""
        :param _LinuxCommand: Linux installation command
        :type LinuxCommand: str
        :param _WindowsCommand: Windows installation command (Windows 2008 or later)
        :type WindowsCommand: str
        :param _WindowsStepOne: Step 1 of Window installation command (Windows 2003)
        :type WindowsStepOne: str
        :param _WindowsStepTwo: Step 2 of Window installation command (Windows 2003)
        :type WindowsStepTwo: str
        :param _WindowsDownloadUrl: Download URL of the agent for Windows
        :type WindowsDownloadUrl: str
        :param _ARMCommand: Arm installation command
Note: This field may return null, indicating that no valid values can be obtained.
        :type ARMCommand: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._LinuxCommand = None
        self._WindowsCommand = None
        self._WindowsStepOne = None
        self._WindowsStepTwo = None
        self._WindowsDownloadUrl = None
        self._ARMCommand = None
        self._RequestId = None

    @property
    def LinuxCommand(self):
        return self._LinuxCommand

    @LinuxCommand.setter
    def LinuxCommand(self, LinuxCommand):
        self._LinuxCommand = LinuxCommand

    @property
    def WindowsCommand(self):
        return self._WindowsCommand

    @WindowsCommand.setter
    def WindowsCommand(self, WindowsCommand):
        self._WindowsCommand = WindowsCommand

    @property
    def WindowsStepOne(self):
        return self._WindowsStepOne

    @WindowsStepOne.setter
    def WindowsStepOne(self, WindowsStepOne):
        self._WindowsStepOne = WindowsStepOne

    @property
    def WindowsStepTwo(self):
        return self._WindowsStepTwo

    @WindowsStepTwo.setter
    def WindowsStepTwo(self, WindowsStepTwo):
        self._WindowsStepTwo = WindowsStepTwo

    @property
    def WindowsDownloadUrl(self):
        return self._WindowsDownloadUrl

    @WindowsDownloadUrl.setter
    def WindowsDownloadUrl(self, WindowsDownloadUrl):
        self._WindowsDownloadUrl = WindowsDownloadUrl

    @property
    def ARMCommand(self):
        return self._ARMCommand

    @ARMCommand.setter
    def ARMCommand(self, ARMCommand):
        self._ARMCommand = ARMCommand

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._LinuxCommand = params.get("LinuxCommand")
        self._WindowsCommand = params.get("WindowsCommand")
        self._WindowsStepOne = params.get("WindowsStepOne")
        self._WindowsStepTwo = params.get("WindowsStepTwo")
        self._WindowsDownloadUrl = params.get("WindowsDownloadUrl")
        self._ARMCommand = params.get("ARMCommand")
        self._RequestId = params.get("RequestId")


class DescribeAgentInstallationTokenRequest(AbstractModel):
    """DescribeAgentInstallationToken request structure.

    """

    def __init__(self):
        r"""
        :param _ExpireDate: Token expiration time
        :type ExpireDate: str
        """
        self._ExpireDate = None

    @property
    def ExpireDate(self):
        return self._ExpireDate

    @ExpireDate.setter
    def ExpireDate(self, ExpireDate):
        self._ExpireDate = ExpireDate


    def _deserialize(self, params):
        self._ExpireDate = params.get("ExpireDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAgentInstallationTokenResponse(AbstractModel):
    """DescribeAgentInstallationToken response structure.

    """

    def __init__(self):
        r"""
        :param _Token: Installation command token
        :type Token: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Token = None
        self._RequestId = None

    @property
    def Token(self):
        return self._Token

    @Token.setter
    def Token(self, Token):
        self._Token = Token

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Token = params.get("Token")
        self._RequestId = params.get("RequestId")


class DescribeAlarmIncidentNodesRequest(AbstractModel):
    """DescribeAlarmIncidentNodes request structure.

    """

    def __init__(self):
        r"""
        :param _Uuid: Machine UUID
        :type Uuid: str
        :param _AlarmVid: Alarm VID
        :type AlarmVid: str
        :param _AlarmTime: Alarm time
        :type AlarmTime: int
        :param _TableId: Alarm source table ID
        :type TableId: int
        """
        self._Uuid = None
        self._AlarmVid = None
        self._AlarmTime = None
        self._TableId = None

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def AlarmVid(self):
        return self._AlarmVid

    @AlarmVid.setter
    def AlarmVid(self, AlarmVid):
        self._AlarmVid = AlarmVid

    @property
    def AlarmTime(self):
        return self._AlarmTime

    @AlarmTime.setter
    def AlarmTime(self, AlarmTime):
        self._AlarmTime = AlarmTime

    @property
    def TableId(self):
        return self._TableId

    @TableId.setter
    def TableId(self, TableId):
        self._TableId = TableId


    def _deserialize(self, params):
        self._Uuid = params.get("Uuid")
        self._AlarmVid = params.get("AlarmVid")
        self._AlarmTime = params.get("AlarmTime")
        self._TableId = params.get("TableId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAlarmIncidentNodesResponse(AbstractModel):
    """DescribeAlarmIncidentNodes response structure.

    """

    def __init__(self):
        r"""
        :param _IncidentNodes: All node information on the event corresponding to an alarm. Multiple events may be involved.
Note: This field may return null, indicating that no valid values can be obtained.
        :type IncidentNodes: list of IncidentVertexInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._IncidentNodes = None
        self._RequestId = None

    @property
    def IncidentNodes(self):
        return self._IncidentNodes

    @IncidentNodes.setter
    def IncidentNodes(self, IncidentNodes):
        self._IncidentNodes = IncidentNodes

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("IncidentNodes") is not None:
            self._IncidentNodes = []
            for item in params.get("IncidentNodes"):
                obj = IncidentVertexInfo()
                obj._deserialize(item)
                self._IncidentNodes.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAlarmVertexIdRequest(AbstractModel):
    """DescribeAlarmVertexId request structure.

    """

    def __init__(self):
        r"""
        :param _Uuid: Machine UUID
        :type Uuid: str
        :param _StartTime: Start timestamp
        :type StartTime: int
        :param _EndTime: End timestamp
        :type EndTime: int
        """
        self._Uuid = None
        self._StartTime = None
        self._EndTime = None

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._Uuid = params.get("Uuid")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAlarmVertexIdResponse(AbstractModel):
    """DescribeAlarmVertexId response structure.

    """

    def __init__(self):
        r"""
        :param _AlarmVertexIds: List of alarm IDs
Note: This field may return null, indicating that no valid values can be obtained.
        :type AlarmVertexIds: list of str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._AlarmVertexIds = None
        self._RequestId = None

    @property
    def AlarmVertexIds(self):
        return self._AlarmVertexIds

    @AlarmVertexIds.setter
    def AlarmVertexIds(self, AlarmVertexIds):
        self._AlarmVertexIds = AlarmVertexIds

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AlarmVertexIds = params.get("AlarmVertexIds")
        self._RequestId = params.get("RequestId")


class DescribeAssetAppCountRequest(AbstractModel):
    """DescribeAssetAppCount request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Search criteria: Search for processes of all software whose names contain Name and return a list.
        :type Name: str
        """
        self._Name = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetAppCountResponse(AbstractModel):
    """DescribeAssetAppCount response structure.

    """

    def __init__(self):
        r"""
        :param _Apps: Number of software applications
Note: This field may return null, indicating that no valid values can be obtained.
        :type Apps: list of AssetKeyVal
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Apps = None
        self._RequestId = None

    @property
    def Apps(self):
        return self._Apps

    @Apps.setter
    def Apps(self, Apps):
        self._Apps = Apps

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Apps") is not None:
            self._Apps = []
            for item in params.get("Apps"):
                obj = AssetKeyVal()
                obj._deserialize(item)
                self._Apps.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAssetAppListRequest(AbstractModel):
    """DescribeAssetAppList request structure.

    """

    def __init__(self):
        r"""
        :param _Quuid: Query information of a specified QUUID host
        :type Quuid: str
        :param _Filters: Filter criteria
<li>AppName - string - required: no - application name for search</li>
<li>IP - String - required: no - host IP address</li>
<li>MachineName - String - required: no - host name</li>
<li>InstanceID - string - required: no - instance ID</li>
<li>Type - int - required: no - type : Linux only	
0: all
1: operations
2: database
3: Security
4: suspicious application
5: system architecture
6: system application
7: web service
99: other</li>
<li>OsType - uint64 - required: no - Windows/Linux</li>
<li>Os - String required: no - operating system (value of DescribeMachineOsList)</li>
        :type Filters: list of AssetFilters
        :param _Limit: Number of items to be returned. It is 10 by default, and the maximum value is 100.
        :type Limit: int
        :param _Offset: Offset, which defaults to 0
        :type Offset: int
        :param _Order: Sorting method: asc for ascending order or desc for descending order
        :type Order: str
        :param _By: Sorting field: [FirstTime|ProcessCount]
        :type By: str
        """
        self._Quuid = None
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetAppListResponse(AbstractModel):
    """DescribeAssetAppList response structure.

    """

    def __init__(self):
        r"""
        :param _Apps: Application list
Note: This field may return null, indicating that no valid values can be obtained.
        :type Apps: list of AssetAppBaseInfo
        :param _Total: Total number
        :type Total: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Apps = None
        self._Total = None
        self._RequestId = None

    @property
    def Apps(self):
        return self._Apps

    @Apps.setter
    def Apps(self, Apps):
        self._Apps = Apps

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Apps") is not None:
            self._Apps = []
            for item in params.get("Apps"):
                obj = AssetAppBaseInfo()
                obj._deserialize(item)
                self._Apps.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeAssetAppProcessListRequest(AbstractModel):
    """DescribeAssetAppProcessList request structure.

    """

    def __init__(self):
        r"""
        :param _Quuid: Host QUUID
        :type Quuid: str
        :param _Uuid: Host UUID
        :type Uuid: str
        :param _Name: App name
        :type Name: str
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of entries to be returned. Default value: 10. Maximum value: 100.
        :type Limit: int
        """
        self._Quuid = None
        self._Uuid = None
        self._Name = None
        self._Offset = None
        self._Limit = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._Name = params.get("Name")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetAppProcessListResponse(AbstractModel):
    """DescribeAssetAppProcessList response structure.

    """

    def __init__(self):
        r"""
        :param _Process: Process list
Note: This field may return null, indicating that no valid values can be obtained.
        :type Process: list of AssetAppProcessInfo
        :param _Total: Total number of partitions
        :type Total: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Process = None
        self._Total = None
        self._RequestId = None

    @property
    def Process(self):
        return self._Process

    @Process.setter
    def Process(self, Process):
        self._Process = Process

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Process") is not None:
            self._Process = []
            for item in params.get("Process"):
                obj = AssetAppProcessInfo()
                obj._deserialize(item)
                self._Process.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeAssetCoreModuleInfoRequest(AbstractModel):
    """DescribeAssetCoreModuleInfo request structure.

    """

    def __init__(self):
        r"""
        :param _Quuid: Server QUUID
        :type Quuid: str
        :param _Uuid: Server UUID
        :type Uuid: str
        :param _Id: Kernel module ID
        :type Id: str
        """
        self._Quuid = None
        self._Uuid = None
        self._Id = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetCoreModuleInfoResponse(AbstractModel):
    """DescribeAssetCoreModuleInfo response structure.

    """

    def __init__(self):
        r"""
        :param _Module: Kernel module details
        :type Module: :class:`tencentcloud.cwp.v20180228.models.AssetCoreModuleDetail`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Module = None
        self._RequestId = None

    @property
    def Module(self):
        return self._Module

    @Module.setter
    def Module(self, Module):
        self._Module = Module

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Module") is not None:
            self._Module = AssetCoreModuleDetail()
            self._Module._deserialize(params.get("Module"))
        self._RequestId = params.get("RequestId")


class DescribeAssetCoreModuleListRequest(AbstractModel):
    """DescribeAssetCoreModuleList request structure.

    """

    def __init__(self):
        r"""
        :param _Uuid: Server UUID
        :type Uuid: str
        :param _Quuid: Server QUUID
        :type Quuid: str
        :param _Filters: Filtering criteria
<li>IP - String - required: no - host IP address</li>
<li>MachineName - String - required: no - host name</li>
<li>InstanceID - string - required: no - instance ID</li>
<li>Name - string - required: no - package name</li>
<li>User - string - required: no - user</li>
        :type Filters: list of AssetFilters
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of entries to be returned. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param _Order: Sorting method: asc for ascending order or desc for descending order
        :type Order: str
        :param _By: Sorting method [Size|FirstTime|ProcessCount|ModuleCount]
        :type By: str
        """
        self._Uuid = None
        self._Quuid = None
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._Order = None
        self._By = None

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Uuid = params.get("Uuid")
        self._Quuid = params.get("Quuid")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetCoreModuleListResponse(AbstractModel):
    """DescribeAssetCoreModuleList response structure.

    """

    def __init__(self):
        r"""
        :param _Modules: List
Note: This field may return null, indicating that no valid values can be obtained.
        :type Modules: list of AssetCoreModuleBaseInfo
        :param _Total: Total number
        :type Total: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Modules = None
        self._Total = None
        self._RequestId = None

    @property
    def Modules(self):
        return self._Modules

    @Modules.setter
    def Modules(self, Modules):
        self._Modules = Modules

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Modules") is not None:
            self._Modules = []
            for item in params.get("Modules"):
                obj = AssetCoreModuleBaseInfo()
                obj._deserialize(item)
                self._Modules.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeAssetDatabaseCountRequest(AbstractModel):
    """DescribeAssetDatabaseCount request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Search criteria: Return a list of databases whose names contain Name.
        :type Name: str
        """
        self._Name = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetDatabaseCountResponse(AbstractModel):
    """DescribeAssetDatabaseCount response structure.

    """

    def __init__(self):
        r"""
        :param _Databases: Number of obtained database assets
        :type Databases: list of AssetKeyVal
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Databases = None
        self._RequestId = None

    @property
    def Databases(self):
        return self._Databases

    @Databases.setter
    def Databases(self, Databases):
        self._Databases = Databases

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Databases") is not None:
            self._Databases = []
            for item in params.get("Databases"):
                obj = AssetKeyVal()
                obj._deserialize(item)
                self._Databases.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAssetDatabaseInfoRequest(AbstractModel):
    """DescribeAssetDatabaseInfo request structure.

    """

    def __init__(self):
        r"""
        :param _Quuid: Server QUUID
        :type Quuid: str
        :param _Uuid: Server UUID
        :type Uuid: str
        :param _Id: Database ID
        :type Id: str
        """
        self._Quuid = None
        self._Uuid = None
        self._Id = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetDatabaseInfoResponse(AbstractModel):
    """DescribeAssetDatabaseInfo response structure.

    """

    def __init__(self):
        r"""
        :param _Database: Database details
        :type Database: :class:`tencentcloud.cwp.v20180228.models.AssetDatabaseDetail`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Database = None
        self._RequestId = None

    @property
    def Database(self):
        return self._Database

    @Database.setter
    def Database(self, Database):
        self._Database = Database

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Database") is not None:
            self._Database = AssetDatabaseDetail()
            self._Database._deserialize(params.get("Database"))
        self._RequestId = params.get("RequestId")


class DescribeAssetDatabaseListRequest(AbstractModel):
    """DescribeAssetDatabaseList request structure.

    """

    def __init__(self):
        r"""
        :param _Quuid: Query information of a specified QUUID host
        :type Quuid: str
        :param _Filters: Filter criteria
<li>MachineName - String - required: no - host alias for filtering</li>
<li>IP - String - required: no - host IP address for filtering</li>
<li>InstanceID - String - required: no - host instance ID for filtering</li>
<li>User- string - required: no - running user</li>
<li>Port - Int - required: no - port</li>
<li>Name - Int - required: no - database name
0: all
1:MySQL
2:Redis
3:Oracle
4:MongoDB
5:MemCache
6:PostgreSQL
7:HBase
8:DB2
9:Sybase
10:TiDB</li>
<li>Proto - String - required: no - protocol: 1: TCP; 2: UDP; 3: unknown</li>
<li>OsType - String - required: no - operating system: linux/windows</li>
<li>Os - String required: no - operating system (value of DescribeMachineOsList)</li>
        :type Filters: list of AssetFilters
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of results to be returned. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param _Order: Sorting method: asc for ascending order or desc for descending order
        :type Order: str
        :param _By: Sorting method: [FirstTime]
        :type By: str
        """
        self._Quuid = None
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._Order = None
        self._By = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetDatabaseListResponse(AbstractModel):
    """DescribeAssetDatabaseList response structure.

    """

    def __init__(self):
        r"""
        :param _Databases: List
Note: This field may return null, indicating that no valid values can be obtained.
        :type Databases: list of AssetDatabaseBaseInfo
        :param _Total: Total number
        :type Total: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Databases = None
        self._Total = None
        self._RequestId = None

    @property
    def Databases(self):
        return self._Databases

    @Databases.setter
    def Databases(self, Databases):
        self._Databases = Databases

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Databases") is not None:
            self._Databases = []
            for item in params.get("Databases"):
                obj = AssetDatabaseBaseInfo()
                obj._deserialize(item)
                self._Databases.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeAssetDiskListRequest(AbstractModel):
    """DescribeAssetDiskList request structure.

    """

    def __init__(self):
        r"""
        :param _Quuid: Host QUUID
        :type Quuid: str
        :param _Uuid: Host UUID
        :type Uuid: str
        :param _Offset: Offset, which defaults to 0
        :type Offset: int
        :param _Limit: Number of items to be returned. It is 10 by default, and the maximum value is 100.
        :type Limit: int
        """
        self._Quuid = None
        self._Uuid = None
        self._Offset = None
        self._Limit = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetDiskListResponse(AbstractModel):
    """DescribeAssetDiskList response structure.

    """

    def __init__(self):
        r"""
        :param _Disks: Disk partition list
Note: This field may return null, indicating that no valid values can be obtained.
        :type Disks: list of AssetDiskPartitionInfo
        :param _Total: Total number of partitions
        :type Total: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Disks = None
        self._Total = None
        self._RequestId = None

    @property
    def Disks(self):
        return self._Disks

    @Disks.setter
    def Disks(self, Disks):
        self._Disks = Disks

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Disks") is not None:
            self._Disks = []
            for item in params.get("Disks"):
                obj = AssetDiskPartitionInfo()
                obj._deserialize(item)
                self._Disks.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeAssetEnvListRequest(AbstractModel):
    """DescribeAssetEnvList request structure.

    """

    def __init__(self):
        r"""
        :param _Uuid: Server UUID
        :type Uuid: str
        :param _Quuid: Server QUUID
        :type Quuid: str
        :param _Type: This field has been deprecated and replaced with Filters.
        :type Type: int
        :param _Filters: Filter criteria
<li>IpOrAlias - String - required: no - filter by host IP or alias</li>
<li>Name - string - required: no - environment variable name</li>
<li>Type - int - required: no - type: 0: user variable; 1: system variable</li>
        :type Filters: list of AssetFilters
        :param _Offset: Offset, which defaults to 0
        :type Offset: int
        :param _Limit: Number of items to be returned. It is 10 by default, and the maximum value is 100.
        :type Limit: int
        :param _Order: Sorting method: asc for ascending order or desc for descending order
        :type Order: str
        :param _By: Sorting method: [FirstTime]
        :type By: str
        """
        self._Uuid = None
        self._Quuid = None
        self._Type = None
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._Order = None
        self._By = None

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Uuid = params.get("Uuid")
        self._Quuid = params.get("Quuid")
        self._Type = params.get("Type")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetEnvListResponse(AbstractModel):
    """DescribeAssetEnvList response structure.

    """

    def __init__(self):
        r"""
        :param _Envs: List
Note: This field may return null, indicating that no valid values can be obtained.
        :type Envs: list of AssetEnvBaseInfo
        :param _Total: Total number
        :type Total: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Envs = None
        self._Total = None
        self._RequestId = None

    @property
    def Envs(self):
        return self._Envs

    @Envs.setter
    def Envs(self, Envs):
        self._Envs = Envs

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Envs") is not None:
            self._Envs = []
            for item in params.get("Envs"):
                obj = AssetEnvBaseInfo()
                obj._deserialize(item)
                self._Envs.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeAssetHostTotalCountRequest(AbstractModel):
    """DescribeAssetHostTotalCount request structure.

    """

    def __init__(self):
        r"""
        :param _Uuid: Host UUID
        :type Uuid: str
        :param _Quuid: Host QUUID
        :type Quuid: str
        """
        self._Uuid = None
        self._Quuid = None

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid


    def _deserialize(self, params):
        self._Uuid = params.get("Uuid")
        self._Quuid = params.get("Quuid")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetHostTotalCountResponse(AbstractModel):
    """DescribeAssetHostTotalCount response structure.

    """

    def __init__(self):
        r"""
        :param _Types: Number of individual resources
system: resource monitoring
account: account
port: port
process: process
app: application software
database: database
webapp: Web application
webframe: Web framework
webservice: Web service
weblocation: Web site
systempackage: system installation package
jar: jar package
initservice: startup service
env: environment variable
coremodule: kernel module
        :type Types: list of AssetKeyVal
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Types = None
        self._RequestId = None

    @property
    def Types(self):
        return self._Types

    @Types.setter
    def Types(self, Types):
        self._Types = Types

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Types") is not None:
            self._Types = []
            for item in params.get("Types"):
                obj = AssetKeyVal()
                obj._deserialize(item)
                self._Types.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAssetInfoRequest(AbstractModel):
    """DescribeAssetInfo request structure.

    """


class DescribeAssetInfoResponse(AbstractModel):
    """DescribeAssetInfo response structure.

    """

    def __init__(self):
        r"""
        :param _MachineCount: Number of Hosts
        :type MachineCount: int
        :param _AccountCount: Number of Accounts
        :type AccountCount: int
        :param _PortCount: Number of ports
        :type PortCount: int
        :param _ProcessCount: Number of Processes
        :type ProcessCount: int
        :param _SoftwareCount: Number of software
        :type SoftwareCount: int
        :param _DatabaseCount: Number of databases
        :type DatabaseCount: int
        :param _WebAppCount: Number of web applications
        :type WebAppCount: int
        :param _WebFrameCount: Number of web frameworks
        :type WebFrameCount: int
        :param _WebServiceCount: Number of web services
        :type WebServiceCount: int
        :param _WebLocationCount: Number of web sites
        :type WebLocationCount: int
        :param _AccountNewCount: New accounts today
        :type AccountNewCount: int
        :param _PortNewCount: New ports today
        :type PortNewCount: int
        :param _ProcessNewCount: New processes today
        :type ProcessNewCount: int
        :param _SoftwareNewCount: New software today
        :type SoftwareNewCount: int
        :param _DatabaseNewCount: New databases today
        :type DatabaseNewCount: int
        :param _WebAppNewCount: New web applications today
        :type WebAppNewCount: int
        :param _WebFrameNewCount: New web frameworks today
        :type WebFrameNewCount: int
        :param _WebServiceNewCount: New web services today
        :type WebServiceNewCount: int
        :param _WebLocationNewCount: New web sites today
        :type WebLocationNewCount: int
        :param _MachineNewCount: New hosts today
        :type MachineNewCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._MachineCount = None
        self._AccountCount = None
        self._PortCount = None
        self._ProcessCount = None
        self._SoftwareCount = None
        self._DatabaseCount = None
        self._WebAppCount = None
        self._WebFrameCount = None
        self._WebServiceCount = None
        self._WebLocationCount = None
        self._AccountNewCount = None
        self._PortNewCount = None
        self._ProcessNewCount = None
        self._SoftwareNewCount = None
        self._DatabaseNewCount = None
        self._WebAppNewCount = None
        self._WebFrameNewCount = None
        self._WebServiceNewCount = None
        self._WebLocationNewCount = None
        self._MachineNewCount = None
        self._RequestId = None

    @property
    def MachineCount(self):
        return self._MachineCount

    @MachineCount.setter
    def MachineCount(self, MachineCount):
        self._MachineCount = MachineCount

    @property
    def AccountCount(self):
        return self._AccountCount

    @AccountCount.setter
    def AccountCount(self, AccountCount):
        self._AccountCount = AccountCount

    @property
    def PortCount(self):
        return self._PortCount

    @PortCount.setter
    def PortCount(self, PortCount):
        self._PortCount = PortCount

    @property
    def ProcessCount(self):
        return self._ProcessCount

    @ProcessCount.setter
    def ProcessCount(self, ProcessCount):
        self._ProcessCount = ProcessCount

    @property
    def SoftwareCount(self):
        return self._SoftwareCount

    @SoftwareCount.setter
    def SoftwareCount(self, SoftwareCount):
        self._SoftwareCount = SoftwareCount

    @property
    def DatabaseCount(self):
        return self._DatabaseCount

    @DatabaseCount.setter
    def DatabaseCount(self, DatabaseCount):
        self._DatabaseCount = DatabaseCount

    @property
    def WebAppCount(self):
        return self._WebAppCount

    @WebAppCount.setter
    def WebAppCount(self, WebAppCount):
        self._WebAppCount = WebAppCount

    @property
    def WebFrameCount(self):
        return self._WebFrameCount

    @WebFrameCount.setter
    def WebFrameCount(self, WebFrameCount):
        self._WebFrameCount = WebFrameCount

    @property
    def WebServiceCount(self):
        return self._WebServiceCount

    @WebServiceCount.setter
    def WebServiceCount(self, WebServiceCount):
        self._WebServiceCount = WebServiceCount

    @property
    def WebLocationCount(self):
        return self._WebLocationCount

    @WebLocationCount.setter
    def WebLocationCount(self, WebLocationCount):
        self._WebLocationCount = WebLocationCount

    @property
    def AccountNewCount(self):
        return self._AccountNewCount

    @AccountNewCount.setter
    def AccountNewCount(self, AccountNewCount):
        self._AccountNewCount = AccountNewCount

    @property
    def PortNewCount(self):
        return self._PortNewCount

    @PortNewCount.setter
    def PortNewCount(self, PortNewCount):
        self._PortNewCount = PortNewCount

    @property
    def ProcessNewCount(self):
        return self._ProcessNewCount

    @ProcessNewCount.setter
    def ProcessNewCount(self, ProcessNewCount):
        self._ProcessNewCount = ProcessNewCount

    @property
    def SoftwareNewCount(self):
        return self._SoftwareNewCount

    @SoftwareNewCount.setter
    def SoftwareNewCount(self, SoftwareNewCount):
        self._SoftwareNewCount = SoftwareNewCount

    @property
    def DatabaseNewCount(self):
        return self._DatabaseNewCount

    @DatabaseNewCount.setter
    def DatabaseNewCount(self, DatabaseNewCount):
        self._DatabaseNewCount = DatabaseNewCount

    @property
    def WebAppNewCount(self):
        return self._WebAppNewCount

    @WebAppNewCount.setter
    def WebAppNewCount(self, WebAppNewCount):
        self._WebAppNewCount = WebAppNewCount

    @property
    def WebFrameNewCount(self):
        return self._WebFrameNewCount

    @WebFrameNewCount.setter
    def WebFrameNewCount(self, WebFrameNewCount):
        self._WebFrameNewCount = WebFrameNewCount

    @property
    def WebServiceNewCount(self):
        return self._WebServiceNewCount

    @WebServiceNewCount.setter
    def WebServiceNewCount(self, WebServiceNewCount):
        self._WebServiceNewCount = WebServiceNewCount

    @property
    def WebLocationNewCount(self):
        return self._WebLocationNewCount

    @WebLocationNewCount.setter
    def WebLocationNewCount(self, WebLocationNewCount):
        self._WebLocationNewCount = WebLocationNewCount

    @property
    def MachineNewCount(self):
        return self._MachineNewCount

    @MachineNewCount.setter
    def MachineNewCount(self, MachineNewCount):
        self._MachineNewCount = MachineNewCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._MachineCount = params.get("MachineCount")
        self._AccountCount = params.get("AccountCount")
        self._PortCount = params.get("PortCount")
        self._ProcessCount = params.get("ProcessCount")
        self._SoftwareCount = params.get("SoftwareCount")
        self._DatabaseCount = params.get("DatabaseCount")
        self._WebAppCount = params.get("WebAppCount")
        self._WebFrameCount = params.get("WebFrameCount")
        self._WebServiceCount = params.get("WebServiceCount")
        self._WebLocationCount = params.get("WebLocationCount")
        self._AccountNewCount = params.get("AccountNewCount")
        self._PortNewCount = params.get("PortNewCount")
        self._ProcessNewCount = params.get("ProcessNewCount")
        self._SoftwareNewCount = params.get("SoftwareNewCount")
        self._DatabaseNewCount = params.get("DatabaseNewCount")
        self._WebAppNewCount = params.get("WebAppNewCount")
        self._WebFrameNewCount = params.get("WebFrameNewCount")
        self._WebServiceNewCount = params.get("WebServiceNewCount")
        self._WebLocationNewCount = params.get("WebLocationNewCount")
        self._MachineNewCount = params.get("MachineNewCount")
        self._RequestId = params.get("RequestId")


class DescribeAssetInitServiceListRequest(AbstractModel):
    """DescribeAssetInitServiceList request structure.

    """

    def __init__(self):
        r"""
        :param _Uuid: Server UUID
        :type Uuid: str
        :param _Quuid: Server QUUID
        :type Quuid: str
        :param _Filters: Filter criteria
<li>IP - String - required: no - host IP address</li>
<li>MachineName - String - required: no - host name</li>
<li>InstanceID - string - required: no - instance ID</li>
<li>Name- string - required: no - package name</li>
<li>User- string - required: no - user</li>
<li>IsAutoRun - string - required: no - whether it starts at boot: 0: no; 1: yes</li>
<li>Status- string - required: no - default enabling status: 0: unenabled; 1: enabled (Linux only)</li>
<li>Type- string - required: no - type: type (Windows only)
1: Encoder
2: IE plugin
3: Network provider
4: Mirror hijacking
5: LSA provider
6:KnownDLLs
7: Start execution
8:WMI
9: Scheduled task
10: Winsock provider
11: Printing monitor
12: Resource manager
13: Driver service
14: Log-in </li>
        :type Filters: list of AssetFilters
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of items to be returned. It is 10 by default, and the maximum value is 100.
        :type Limit: int
        :param _Order: Sorting method: asc for ascending order or desc for descending order
        :type Order: str
        :param _By: Sorting method: [FirstTime]
        :type By: str
        """
        self._Uuid = None
        self._Quuid = None
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._Order = None
        self._By = None

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Uuid = params.get("Uuid")
        self._Quuid = params.get("Quuid")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetInitServiceListResponse(AbstractModel):
    """DescribeAssetInitServiceList response structure.

    """

    def __init__(self):
        r"""
        :param _Services: List
Note: This field may return null, indicating that no valid values can be obtained.
        :type Services: list of AssetInitServiceBaseInfo
        :param _Total: Total number
        :type Total: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Services = None
        self._Total = None
        self._RequestId = None

    @property
    def Services(self):
        return self._Services

    @Services.setter
    def Services(self, Services):
        self._Services = Services

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Services") is not None:
            self._Services = []
            for item in params.get("Services"):
                obj = AssetInitServiceBaseInfo()
                obj._deserialize(item)
                self._Services.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeAssetJarInfoRequest(AbstractModel):
    """DescribeAssetJarInfo request structure.

    """

    def __init__(self):
        r"""
        :param _Quuid: Server QUUID
        :type Quuid: str
        :param _Uuid: Server UUID
        :type Uuid: str
        :param _Id: JAR package ID
        :type Id: str
        """
        self._Quuid = None
        self._Uuid = None
        self._Id = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetJarInfoResponse(AbstractModel):
    """DescribeAssetJarInfo response structure.

    """

    def __init__(self):
        r"""
        :param _Jar: JAR package details
        :type Jar: :class:`tencentcloud.cwp.v20180228.models.AssetJarDetail`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Jar = None
        self._RequestId = None

    @property
    def Jar(self):
        return self._Jar

    @Jar.setter
    def Jar(self, Jar):
        self._Jar = Jar

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Jar") is not None:
            self._Jar = AssetJarDetail()
            self._Jar._deserialize(params.get("Jar"))
        self._RequestId = params.get("RequestId")


class DescribeAssetJarListRequest(AbstractModel):
    """DescribeAssetJarList request structure.

    """

    def __init__(self):
        r"""
        :param _Uuid: Server UUID
        :type Uuid: str
        :param _Quuid: Server QUUID
        :type Quuid: str
        :param _Filters: Filtering criteria
<li>IP - String - required: no - host IP address</li>
<li>MachineName - String - required: no - host name</li>
<li>InstanceID - string - required: no - instance ID</li>
<li>Name- string - required: no - package name</li>
<li>Type- uint - required: no - type	
1: application
2: system class library3: web service built-in library
4: other dependent packages</li>
<li>Status - string - required: no - whether execution is allowed: 0: no; 1: yes</li>
        :type Filters: list of AssetFilters
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of results to be returned. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param _Order: Sorting method: asc for ascending order or desc for descending order
        :type Order: str
        :param _By: Sorting method: [FirstTime]
        :type By: str
        """
        self._Uuid = None
        self._Quuid = None
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._Order = None
        self._By = None

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Uuid = params.get("Uuid")
        self._Quuid = params.get("Quuid")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetJarListResponse(AbstractModel):
    """DescribeAssetJarList response structure.

    """

    def __init__(self):
        r"""
        :param _Jars: Application list
Note: This field may return null, indicating that no valid values can be obtained.
        :type Jars: list of AssetJarBaseInfo
        :param _Total: Total number
        :type Total: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Jars = None
        self._Total = None
        self._RequestId = None

    @property
    def Jars(self):
        return self._Jars

    @Jars.setter
    def Jars(self, Jars):
        self._Jars = Jars

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Jars") is not None:
            self._Jars = []
            for item in params.get("Jars"):
                obj = AssetJarBaseInfo()
                obj._deserialize(item)
                self._Jars.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeAssetLoadInfoRequest(AbstractModel):
    """DescribeAssetLoadInfo request structure.

    """


class DescribeAssetLoadInfoResponse(AbstractModel):
    """DescribeAssetLoadInfo response structure.

    """

    def __init__(self):
        r"""
        :param _CpuLoad: System load
Note: This field may return null, indicating that no valid values can be obtained.
        :type CpuLoad: :class:`tencentcloud.cwp.v20180228.models.AssetLoadSummary`
        :param _MemLoad: Memory utilization
Note: This field may return null, indicating that no valid values can be obtained.
        :type MemLoad: :class:`tencentcloud.cwp.v20180228.models.AssetLoadSummary`
        :param _DiskLoad: Hard disk utilization
Note: This field may return null, indicating that no valid values can be obtained.
        :type DiskLoad: :class:`tencentcloud.cwp.v20180228.models.AssetLoadSummary`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._CpuLoad = None
        self._MemLoad = None
        self._DiskLoad = None
        self._RequestId = None

    @property
    def CpuLoad(self):
        return self._CpuLoad

    @CpuLoad.setter
    def CpuLoad(self, CpuLoad):
        self._CpuLoad = CpuLoad

    @property
    def MemLoad(self):
        return self._MemLoad

    @MemLoad.setter
    def MemLoad(self, MemLoad):
        self._MemLoad = MemLoad

    @property
    def DiskLoad(self):
        return self._DiskLoad

    @DiskLoad.setter
    def DiskLoad(self, DiskLoad):
        self._DiskLoad = DiskLoad

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("CpuLoad") is not None:
            self._CpuLoad = AssetLoadSummary()
            self._CpuLoad._deserialize(params.get("CpuLoad"))
        if params.get("MemLoad") is not None:
            self._MemLoad = AssetLoadSummary()
            self._MemLoad._deserialize(params.get("MemLoad"))
        if params.get("DiskLoad") is not None:
            self._DiskLoad = AssetLoadSummary()
            self._DiskLoad._deserialize(params.get("DiskLoad"))
        self._RequestId = params.get("RequestId")


class DescribeAssetMachineDetailRequest(AbstractModel):
    """DescribeAssetMachineDetail request structure.

    """

    def __init__(self):
        r"""
        :param _Quuid: Server QUUID
        :type Quuid: str
        :param _Uuid: Server UUID
        :type Uuid: str
        """
        self._Quuid = None
        self._Uuid = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetMachineDetailResponse(AbstractModel):
    """DescribeAssetMachineDetail response structure.

    """

    def __init__(self):
        r"""
        :param _MachineDetail: Host details
        :type MachineDetail: :class:`tencentcloud.cwp.v20180228.models.AssetMachineDetail`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._MachineDetail = None
        self._RequestId = None

    @property
    def MachineDetail(self):
        return self._MachineDetail

    @MachineDetail.setter
    def MachineDetail(self, MachineDetail):
        self._MachineDetail = MachineDetail

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("MachineDetail") is not None:
            self._MachineDetail = AssetMachineDetail()
            self._MachineDetail._deserialize(params.get("MachineDetail"))
        self._RequestId = params.get("RequestId")


class DescribeAssetMachineListRequest(AbstractModel):
    """DescribeAssetMachineList request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filter criteria
<li>MachineName  Host name</li>
<li>InstanceID  Instance ID  </li>
<li>IP   Private or public IP address</li>
<li>OsType - String - required: no - Windows or Linux</li>
<li>CpuLoad - Int - required: no - 
	0: unknown; 1: low load;
	2: medium load; 3: high load</li>
<li>DiskLoad - Int - required: no - 
	0: 0% or unknown; 1: 0%-20%;
	2: 20%～50%  3: 50%～80%
	4: 80%～100%</li>
<li>MemLoad - Int - required: no - 
	0: 0% or unknown; 1: 0%-20%;
	2: 20%～50%  3: 50%～80%
	4: 80%～100%</li>
<li>Quuid: Host QUUID</li>
<li>Os - String required: no - operating system (value of DescribeMachineOsList)</li>
        :type Filters: list of Filter
        :param _Limit: Number of results to be returned. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Order: Sorting method: asc for ascending order or desc for descending order
        :type Order: str
        :param _By: Optional sorting method [FirstTime|PartitionCount]
        :type By: str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetMachineListResponse(AbstractModel):
    """DescribeAssetMachineList response structure.

    """

    def __init__(self):
        r"""
        :param _Total: Total number
        :type Total: int
        :param _Machines: Record list
Note: This field may return null, indicating that no valid values can be obtained.
        :type Machines: list of AssetMachineBaseInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Total = None
        self._Machines = None
        self._RequestId = None

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Machines(self):
        return self._Machines

    @Machines.setter
    def Machines(self, Machines):
        self._Machines = Machines

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("Machines") is not None:
            self._Machines = []
            for item in params.get("Machines"):
                obj = AssetMachineBaseInfo()
                obj._deserialize(item)
                self._Machines.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAssetMachineTagTopRequest(AbstractModel):
    """DescribeAssetMachineTagTop request structure.

    """


class DescribeAssetMachineTagTopResponse(AbstractModel):
    """DescribeAssetMachineTagTop response structure.

    """

    def __init__(self):
        r"""
        :param _Tags: Top 5 tags along with their counts
Note: This field may return null, indicating that no valid values can be obtained.
        :type Tags: list of AssetKeyVal
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Tags = None
        self._RequestId = None

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = AssetKeyVal()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAssetPlanTaskListRequest(AbstractModel):
    """DescribeAssetPlanTaskList request structure.

    """

    def __init__(self):
        r"""
        :param _Uuid: Server UUID
        :type Uuid: str
        :param _Quuid: Server QUUID
        :type Quuid: str
        :param _Filters: Filtering criteria
<li>IP - String - required: no - host IP address</li>
<li>MachineName - String - required: no - host name</li>
<li>InstanceID - string - required: no - instance ID</li>
<li>User- string - required: no - user</li>
<li>Status- int - required: no - default enabling status: 0: disabled; 1: enabled </li>
        :type Filters: list of AssetFilters
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of entries to be returned. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param _Order: Sorting method: asc for ascending order or desc for descending order
        :type Order: str
        :param _By: Sorting method: [FirstTime]
        :type By: str
        """
        self._Uuid = None
        self._Quuid = None
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._Order = None
        self._By = None

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Uuid = params.get("Uuid")
        self._Quuid = params.get("Quuid")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetPlanTaskListResponse(AbstractModel):
    """DescribeAssetPlanTaskList response structure.

    """

    def __init__(self):
        r"""
        :param _Tasks: List
Note: This field may return null, indicating that no valid values can be obtained.
        :type Tasks: list of AssetPlanTask
        :param _Total: Total number
        :type Total: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Tasks = None
        self._Total = None
        self._RequestId = None

    @property
    def Tasks(self):
        return self._Tasks

    @Tasks.setter
    def Tasks(self, Tasks):
        self._Tasks = Tasks

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Tasks") is not None:
            self._Tasks = []
            for item in params.get("Tasks"):
                obj = AssetPlanTask()
                obj._deserialize(item)
                self._Tasks.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeAssetPortCountRequest(AbstractModel):
    """DescribeAssetPortCount request structure.

    """

    def __init__(self):
        r"""
        :param _Port: Search criteria: Return the data of specified port numbers.
        :type Port: int
        """
        self._Port = None

    @property
    def Port(self):
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port


    def _deserialize(self, params):
        self._Port = params.get("Port")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetPortCountResponse(AbstractModel):
    """DescribeAssetPortCount response structure.

    """

    def __init__(self):
        r"""
        :param _Ports: Number of processes
        :type Ports: list of AssetKeyVal
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Ports = None
        self._RequestId = None

    @property
    def Ports(self):
        return self._Ports

    @Ports.setter
    def Ports(self, Ports):
        self._Ports = Ports

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Ports") is not None:
            self._Ports = []
            for item in params.get("Ports"):
                obj = AssetKeyVal()
                obj._deserialize(item)
                self._Ports.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAssetPortInfoListRequest(AbstractModel):
    """DescribeAssetPortInfoList request structure.

    """

    def __init__(self):
        r"""
        :param _Quuid: Query information of a specified QUUID host
        :type Quuid: str
        :param _Filters: Filter criteria
<li>Port - uint64 - Required: no - port</li>
<li>IP - String - required: no - host IP address</li>
<li>MachineName - String - required: no - host name</li>
<li>InstanceID - string - required: no - instance ID</li>
<li>ProcessName - String - Required: no - process name</li>
<li>Pid - uint64 - Required: no - PID</li>
<li>User - String - required: no - running user</li>
<li>Group - String - Required: no - user group</li>
<li>Ppid - uint64 - Required: no - PPID</li>
<li>Proto - string - Required: no - tcp/udp or "" (empty string to filter unknown status)</li>
<li>OsType - uint64 - required: no - Windows/Linux</li>
<li>RunTimeStart - String - required: no - running start time</li>
<li>RunTimeEnd - String - required: no - running end time</li>
<li>Os - String required: no - operating system (value of DescribeMachineOsList)</li>
        :type Filters: list of Filter
        :param _Limit: Number of results to be returned. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Order: Sorting method: asc for ascending order or desc for descending order
        :type Order: str
        :param _By: Sorting method: [FirstTime|StartTime]
        :type By: str
        """
        self._Quuid = None
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetPortInfoListResponse(AbstractModel):
    """DescribeAssetPortInfoList response structure.

    """

    def __init__(self):
        r"""
        :param _Total: Total number of records
        :type Total: int
        :param _Ports: List
Note: This field may return null, indicating that no valid values can be obtained.
        :type Ports: list of AssetPortBaseInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Total = None
        self._Ports = None
        self._RequestId = None

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Ports(self):
        return self._Ports

    @Ports.setter
    def Ports(self, Ports):
        self._Ports = Ports

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("Ports") is not None:
            self._Ports = []
            for item in params.get("Ports"):
                obj = AssetPortBaseInfo()
                obj._deserialize(item)
                self._Ports.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAssetProcessCountRequest(AbstractModel):
    """DescribeAssetProcessCount request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Search criteria: Search and return a list of all process names containing Name.
        :type Name: str
        """
        self._Name = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetProcessCountResponse(AbstractModel):
    """DescribeAssetProcessCount response structure.

    """

    def __init__(self):
        r"""
        :param _Process: Number of individual processes
Note: This field may return null, indicating that no valid values can be obtained.
        :type Process: list of AssetKeyVal
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Process = None
        self._RequestId = None

    @property
    def Process(self):
        return self._Process

    @Process.setter
    def Process(self, Process):
        self._Process = Process

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Process") is not None:
            self._Process = []
            for item in params.get("Process"):
                obj = AssetKeyVal()
                obj._deserialize(item)
                self._Process.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAssetProcessInfoListRequest(AbstractModel):
    """DescribeAssetProcessInfoList request structure.

    """

    def __init__(self):
        r"""
        :param _Quuid: Query the information on the host with the specified QUUID
        :type Quuid: str
        :param _Filters: Filtering criteria
<li>IP - String - required: no - host IP address</li>
<li>MachineName - String - required: no - host name</li>
<li>InstanceID - string - required: no - instance ID</li>
<li>Name - String - required: no - process name</li>
<li>User - String - required: no - process user</li>
<li>Group - String - required: no - process user group</li>
<li>Pid - uint64 - required: no - process ID</li>
<li>Ppid - uint64 - required: no - parent process ID</li>
<li>OsType - uint64 - required: no - Windows/Linux</li>
<li>Status - string - required: no - process status:
1: R, runnable
2: S, interruptible
3: D, uninterruptible
4: T, stopped or traced
5: Z, zombie
6: X, to be terminated</li>
<li>RunTimeStart - String - required: no - running start time</li>
<li>RunTimeEnd - String - required: no - running end time</li>
<li>InstallByPackage - uint64 - required: no - whether to install by package: 0: no; 1: yes</li>
<li>Os - String required: no - operating system (value of DescribeMachineOsList)</li>
        :type Filters: list of Filter
        :param _Limit: Number of items to be returned. It is 10 by default, and the maximum value is 100.
        :type Limit: int
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Order: Sorting method: asc for ascending order or desc for descending order
        :type Order: str
        :param _By: Sorting method: [FirstTime|StartTime]
        :type By: str
        """
        self._Quuid = None
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetProcessInfoListResponse(AbstractModel):
    """DescribeAssetProcessInfoList response structure.

    """

    def __init__(self):
        r"""
        :param _Total: Total number of records
        :type Total: int
        :param _Process: List
Note: This field may return null, indicating that no valid values can be obtained.
        :type Process: list of AssetProcessBaseInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Total = None
        self._Process = None
        self._RequestId = None

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Process(self):
        return self._Process

    @Process.setter
    def Process(self, Process):
        self._Process = Process

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("Process") is not None:
            self._Process = []
            for item in params.get("Process"):
                obj = AssetProcessBaseInfo()
                obj._deserialize(item)
                self._Process.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAssetRecentMachineInfoRequest(AbstractModel):
    """DescribeAssetRecentMachineInfo request structure.

    """

    def __init__(self):
        r"""
        :param _BeginDate: Start time. For example, 2020-09-22.
        :type BeginDate: str
        :param _EndDate: End time. For example, 2020-09-22.
        :type EndDate: str
        """
        self._BeginDate = None
        self._EndDate = None

    @property
    def BeginDate(self):
        return self._BeginDate

    @BeginDate.setter
    def BeginDate(self, BeginDate):
        self._BeginDate = BeginDate

    @property
    def EndDate(self):
        return self._EndDate

    @EndDate.setter
    def EndDate(self, EndDate):
        self._EndDate = EndDate


    def _deserialize(self, params):
        self._BeginDate = params.get("BeginDate")
        self._EndDate = params.get("EndDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetRecentMachineInfoResponse(AbstractModel):
    """DescribeAssetRecentMachineInfo response structure.

    """

    def __init__(self):
        r"""
        :param _TotalList: List of total assets
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalList: list of AssetKeyVal
        :param _LiveList: List of online assets
Note: This field may return null, indicating that no valid values can be obtained.
        :type LiveList: list of AssetKeyVal
        :param _OfflineList: List of offline assets
Note: This field may return null, indicating that no valid values can be obtained.
        :type OfflineList: list of AssetKeyVal
        :param _RiskList: List of risky assets
Note: This field may return null, indicating that no valid values can be obtained.
        :type RiskList: list of AssetKeyVal
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalList = None
        self._LiveList = None
        self._OfflineList = None
        self._RiskList = None
        self._RequestId = None

    @property
    def TotalList(self):
        return self._TotalList

    @TotalList.setter
    def TotalList(self, TotalList):
        self._TotalList = TotalList

    @property
    def LiveList(self):
        return self._LiveList

    @LiveList.setter
    def LiveList(self, LiveList):
        self._LiveList = LiveList

    @property
    def OfflineList(self):
        return self._OfflineList

    @OfflineList.setter
    def OfflineList(self, OfflineList):
        self._OfflineList = OfflineList

    @property
    def RiskList(self):
        return self._RiskList

    @RiskList.setter
    def RiskList(self, RiskList):
        self._RiskList = RiskList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TotalList") is not None:
            self._TotalList = []
            for item in params.get("TotalList"):
                obj = AssetKeyVal()
                obj._deserialize(item)
                self._TotalList.append(obj)
        if params.get("LiveList") is not None:
            self._LiveList = []
            for item in params.get("LiveList"):
                obj = AssetKeyVal()
                obj._deserialize(item)
                self._LiveList.append(obj)
        if params.get("OfflineList") is not None:
            self._OfflineList = []
            for item in params.get("OfflineList"):
                obj = AssetKeyVal()
                obj._deserialize(item)
                self._OfflineList.append(obj)
        if params.get("RiskList") is not None:
            self._RiskList = []
            for item in params.get("RiskList"):
                obj = AssetKeyVal()
                obj._deserialize(item)
                self._RiskList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAssetSystemPackageListRequest(AbstractModel):
    """DescribeAssetSystemPackageList request structure.

    """

    def __init__(self):
        r"""
        :param _Uuid: Host UUID
        :type Uuid: str
        :param _Quuid: Host QUUID
        :type Quuid: str
        :param _Filters: Filter criteria
<li>Name - String - required: no - package name</li>
<li>StartTime - String - required: no - start time of installation</li>
<li>EndTime - String - required: no - end time of installation</li>
<li>Type- int - required: no - installation package type:
1:rmp
2:dpkg
3:java
4:system</li>
        :type Filters: list of Filter
        :param _Offset: Offset, which is 0 by default.
        :type Offset: int
        :param _Limit: Number of items to be returned. It is 10 by default, and the maximum value is 100.
        :type Limit: int
        :param _Order: Sorting method: asc for ascending order or desc for descending order. Default: desc for descending order.
        :type Order: str
        :param _By: Optional sorting method: [FistTime|InstallTime: installation time]
        :type By: str
        """
        self._Uuid = None
        self._Quuid = None
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._Order = None
        self._By = None

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Uuid = params.get("Uuid")
        self._Quuid = params.get("Quuid")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetSystemPackageListResponse(AbstractModel):
    """DescribeAssetSystemPackageList response structure.

    """

    def __init__(self):
        r"""
        :param _Total: Total number of records
        :type Total: int
        :param _Packages: List
Note: This field may return null, indicating that no valid values can be obtained.
        :type Packages: list of AssetSystemPackageInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Total = None
        self._Packages = None
        self._RequestId = None

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Packages(self):
        return self._Packages

    @Packages.setter
    def Packages(self, Packages):
        self._Packages = Packages

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("Packages") is not None:
            self._Packages = []
            for item in params.get("Packages"):
                obj = AssetSystemPackageInfo()
                obj._deserialize(item)
                self._Packages.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAssetTotalCountRequest(AbstractModel):
    """DescribeAssetTotalCount request structure.

    """


class DescribeAssetTotalCountResponse(AbstractModel):
    """DescribeAssetTotalCount response structure.

    """

    def __init__(self):
        r"""
        :param _Types: Number of individual resources
system: resource monitoring
account: account
port: port
process: process
app: application software
database: database
webapp: Web application
webframe: Web framework
webservice: Web service
weblocation: Web site
jar: Jar package
initservice: startup service
planTask: scheduled task
env: environment variable
coremodule: kernel module
        :type Types: list of AssetKeyVal
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Types = None
        self._RequestId = None

    @property
    def Types(self):
        return self._Types

    @Types.setter
    def Types(self, Types):
        self._Types = Types

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Types") is not None:
            self._Types = []
            for item in params.get("Types"):
                obj = AssetKeyVal()
                obj._deserialize(item)
                self._Types.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAssetTypeTopRequest(AbstractModel):
    """DescribeAssetTypeTop request structure.

    """


class DescribeAssetTypeTopResponse(AbstractModel):
    """DescribeAssetTypeTop response structure.

    """

    def __init__(self):
        r"""
        :param _User: Top 5 accounts
Note: This field may return null, indicating that no valid values can be obtained.
        :type User: list of AssetKeyVal
        :param _Port: Top 5 ports
Note: This field may return null, indicating that no valid values can be obtained.
        :type Port: list of AssetKeyVal
        :param _Process: Top 5 processes
Note: This field may return null, indicating that no valid values can be obtained.
        :type Process: list of AssetKeyVal
        :param _Software: Top 5 software
Note: This field may return null, indicating that no valid values can be obtained.
        :type Software: list of AssetKeyVal
        :param _Database: Top 5 databases
Note: This field may return null, indicating that no valid values can be obtained.
        :type Database: list of AssetKeyVal
        :param _WebApp: Top 5 web applications
Note: This field may return null, indicating that no valid values can be obtained.
        :type WebApp: list of AssetKeyVal
        :param _WebLocation: Top 5 web sites
Note: This field may return null, indicating that no valid values can be obtained.
        :type WebLocation: list of AssetKeyVal
        :param _WebFrame: Top 5 web frameworks
Note: This field may return null, indicating that no valid values can be obtained.
        :type WebFrame: list of AssetKeyVal
        :param _WebService: Top 5 web services
Note: This field may return null, indicating that no valid values can be obtained.
        :type WebService: list of AssetKeyVal
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._User = None
        self._Port = None
        self._Process = None
        self._Software = None
        self._Database = None
        self._WebApp = None
        self._WebLocation = None
        self._WebFrame = None
        self._WebService = None
        self._RequestId = None

    @property
    def User(self):
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def Port(self):
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def Process(self):
        return self._Process

    @Process.setter
    def Process(self, Process):
        self._Process = Process

    @property
    def Software(self):
        return self._Software

    @Software.setter
    def Software(self, Software):
        self._Software = Software

    @property
    def Database(self):
        return self._Database

    @Database.setter
    def Database(self, Database):
        self._Database = Database

    @property
    def WebApp(self):
        return self._WebApp

    @WebApp.setter
    def WebApp(self, WebApp):
        self._WebApp = WebApp

    @property
    def WebLocation(self):
        return self._WebLocation

    @WebLocation.setter
    def WebLocation(self, WebLocation):
        self._WebLocation = WebLocation

    @property
    def WebFrame(self):
        return self._WebFrame

    @WebFrame.setter
    def WebFrame(self, WebFrame):
        self._WebFrame = WebFrame

    @property
    def WebService(self):
        return self._WebService

    @WebService.setter
    def WebService(self, WebService):
        self._WebService = WebService

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("User") is not None:
            self._User = []
            for item in params.get("User"):
                obj = AssetKeyVal()
                obj._deserialize(item)
                self._User.append(obj)
        if params.get("Port") is not None:
            self._Port = []
            for item in params.get("Port"):
                obj = AssetKeyVal()
                obj._deserialize(item)
                self._Port.append(obj)
        if params.get("Process") is not None:
            self._Process = []
            for item in params.get("Process"):
                obj = AssetKeyVal()
                obj._deserialize(item)
                self._Process.append(obj)
        if params.get("Software") is not None:
            self._Software = []
            for item in params.get("Software"):
                obj = AssetKeyVal()
                obj._deserialize(item)
                self._Software.append(obj)
        if params.get("Database") is not None:
            self._Database = []
            for item in params.get("Database"):
                obj = AssetKeyVal()
                obj._deserialize(item)
                self._Database.append(obj)
        if params.get("WebApp") is not None:
            self._WebApp = []
            for item in params.get("WebApp"):
                obj = AssetKeyVal()
                obj._deserialize(item)
                self._WebApp.append(obj)
        if params.get("WebLocation") is not None:
            self._WebLocation = []
            for item in params.get("WebLocation"):
                obj = AssetKeyVal()
                obj._deserialize(item)
                self._WebLocation.append(obj)
        if params.get("WebFrame") is not None:
            self._WebFrame = []
            for item in params.get("WebFrame"):
                obj = AssetKeyVal()
                obj._deserialize(item)
                self._WebFrame.append(obj)
        if params.get("WebService") is not None:
            self._WebService = []
            for item in params.get("WebService"):
                obj = AssetKeyVal()
                obj._deserialize(item)
                self._WebService.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAssetTypesRequest(AbstractModel):
    """DescribeAssetTypes request structure.

    """


class DescribeAssetTypesResponse(AbstractModel):
    """DescribeAssetTypes response structure.

    """

    def __init__(self):
        r"""
        :param _Types: Asset fingerprint type list
        :type Types: list of AssetType
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Types = None
        self._RequestId = None

    @property
    def Types(self):
        return self._Types

    @Types.setter
    def Types(self, Types):
        self._Types = Types

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Types") is not None:
            self._Types = []
            for item in params.get("Types"):
                obj = AssetType()
                obj._deserialize(item)
                self._Types.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAssetUserCountRequest(AbstractModel):
    """DescribeAssetUserCount request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Search criteria: Search all account lists containing the name in the name.
        :type Name: str
        """
        self._Name = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetUserCountResponse(AbstractModel):
    """DescribeAssetUserCount response structure.

    """

    def __init__(self):
        r"""
        :param _Users: Number of accounts
        :type Users: list of AssetKeyVal
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Users = None
        self._RequestId = None

    @property
    def Users(self):
        return self._Users

    @Users.setter
    def Users(self, Users):
        self._Users = Users

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Users") is not None:
            self._Users = []
            for item in params.get("Users"):
                obj = AssetKeyVal()
                obj._deserialize(item)
                self._Users.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAssetUserInfoRequest(AbstractModel):
    """DescribeAssetUserInfo request structure.

    """

    def __init__(self):
        r"""
        :param _Quuid: CVM UUID
        :type Quuid: str
        :param _Uuid: CWPP UUID
        :type Uuid: str
        :param _Name: Account name
        :type Name: str
        """
        self._Quuid = None
        self._Uuid = None
        self._Name = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetUserInfoResponse(AbstractModel):
    """DescribeAssetUserInfo response structure.

    """

    def __init__(self):
        r"""
        :param _User: Detailed user information
        :type User: :class:`tencentcloud.cwp.v20180228.models.AssetUserDetail`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._User = None
        self._RequestId = None

    @property
    def User(self):
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("User") is not None:
            self._User = AssetUserDetail()
            self._User._deserialize(params.get("User"))
        self._RequestId = params.get("RequestId")


class DescribeAssetUserKeyListRequest(AbstractModel):
    """DescribeAssetUserKeyList request structure.

    """

    def __init__(self):
        r"""
        :param _Quuid: Host QUUID
        :type Quuid: str
        :param _Uuid: Host UUID
        :type Uuid: str
        :param _Name: Account name
        :type Name: str
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of items to be returned. It is 10 by default, and the maximum value is 100.
        :type Limit: int
        """
        self._Quuid = None
        self._Uuid = None
        self._Name = None
        self._Offset = None
        self._Limit = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._Name = params.get("Name")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetUserKeyListResponse(AbstractModel):
    """DescribeAssetUserKeyList response structure.

    """

    def __init__(self):
        r"""
        :param _Keys: Public key list
Note: This field may return null, indicating that no valid values can be obtained.
        :type Keys: list of AssetUserKeyInfo
        :param _Total: Total number of partitions
        :type Total: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Keys = None
        self._Total = None
        self._RequestId = None

    @property
    def Keys(self):
        return self._Keys

    @Keys.setter
    def Keys(self, Keys):
        self._Keys = Keys

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Keys") is not None:
            self._Keys = []
            for item in params.get("Keys"):
                obj = AssetUserKeyInfo()
                obj._deserialize(item)
                self._Keys.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeAssetUserListRequest(AbstractModel):
    """DescribeAssetUserList request structure.

    """

    def __init__(self):
        r"""
        :param _Quuid: Query the information on the host with the specified QUUID
        :type Quuid: str
        :param _Filters: Filter criteria
<li>IP - String - required: no - host IP address</li>
<li>MachineName - String - required: no - host name</li>
<li>InstanceID - string - required: no - instance ID<li>
<li>Name - String - required: no - account name (fuzzy match)</li>
<li>NameStrict - String - required: no - account name (strict match)</li>
<li>Uid - uint64 - required: no - UID</li>
<li>Guid - uint64 - required: no - GUID</li>
<li>LoginTimeStart - String - required: no - start time, such as 2021-01-11</li>
<li>LoginTimeEnd - String - required: no - end time, such as 2021-01-11</li>
<li>LoginType - uint64 - required: no - 0 - not allowed to log in; 1 - only key-based log-in allowed; 2 - only password-based log-in allowed; 3 - both key-based and password-based log-in allowed (Linux only)</li>
<li>OsType - String - required: no - Windows or Linux</li>
<li>Status - uint64 - required: no - account status: 0 - disabled; 1 - enabled</li>
<li>UserType - uint64 - required: no - account type: 0 - guest user; 1 - standard user; 2 - administrator user (Windows Only)</li>
<li>IsDomain - uint64 - required: no - whether a domain account: 0 - no; 1 - yes (Windows only)</li>
<li>IsRoot - uint64 - required: no - whether there is root permission: 0 - no; 1 - yes (Linux only)</li>
<li>IsSudo - uint64 - required: no - whether there is sudo permission: 0 - no; 1 - yes (Linux only)</li>
<li>IsSshLogin - uint64 - required: no - whether to use SSH log-in: 0 - no; 1 - yes (Linux only)</li>
<li>ShellLoginStatus - uint64 - required: no - whether to use Shell log-in: 0 - no; 1 - yes (Linux only)</li>
<li>PasswordStatus - uint64 - required: no - password status: 1 - normal; 2 - expiring soon; 3 - expired; 4 - locked (Linux only)</li>
<li>Os -String required: no - operating system (the value of DescribeMachineOsList API)</li>
        :type Filters: list of Filter
        :param _Limit: Number of items to be returned. It is 10 by default, and the maximum value is 100.
        :type Limit: int
        :param _Offset: Offset, which is 0 by default.
        :type Offset: int
        :param _Order: Sorting method: asc for ascending order or desc for descending order
        :type Order: str
        :param _By: Optional sorting method: [FirstTime|LoginTime|PasswordChangeTime|PasswordDuaTime|PasswordLockDays]

        :type By: str
        """
        self._Quuid = None
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetUserListResponse(AbstractModel):
    """DescribeAssetUserList response structure.

    """

    def __init__(self):
        r"""
        :param _Total: Total number of records
        :type Total: int
        :param _Users: Account list
Note: This field may return null, indicating that no valid values can be obtained.
        :type Users: list of AssetUserBaseInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Total = None
        self._Users = None
        self._RequestId = None

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Users(self):
        return self._Users

    @Users.setter
    def Users(self, Users):
        self._Users = Users

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("Users") is not None:
            self._Users = []
            for item in params.get("Users"):
                obj = AssetUserBaseInfo()
                obj._deserialize(item)
                self._Users.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAssetWebAppCountRequest(AbstractModel):
    """DescribeAssetWebAppCount request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Search criteria: Return a list of all Web applications containing Name.
        :type Name: str
        """
        self._Name = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetWebAppCountResponse(AbstractModel):
    """DescribeAssetWebAppCount response structure.

    """

    def __init__(self):
        r"""
        :param _WebApps: Number of individual Web applications
        :type WebApps: list of AssetKeyVal
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._WebApps = None
        self._RequestId = None

    @property
    def WebApps(self):
        return self._WebApps

    @WebApps.setter
    def WebApps(self, WebApps):
        self._WebApps = WebApps

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("WebApps") is not None:
            self._WebApps = []
            for item in params.get("WebApps"):
                obj = AssetKeyVal()
                obj._deserialize(item)
                self._WebApps.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAssetWebAppListRequest(AbstractModel):
    """DescribeAssetWebAppList request structure.

    """

    def __init__(self):
        r"""
        :param _Quuid: Query the information on the host with the specified QUUID
        :type Quuid: str
        :param _Filters: Filtering criteria
<li>IP - String - required: no - host IP address</li>
<li>MachineName - String - required: no - host name</li>
<li>InstanceID - string - required: no - instance ID</li>
<li>Name - String - required: no - application name</li>
<li>Domain - String - required: no - site domain name</li>
<li>Type - int - required: no - service type:
0: all
1:Tomcat
2:Apache
3:Nginx
4:WebLogic
5:Websphere
6:JBoss
7:Jetty
8:IHS
9:Tengine</li>
<li>OsType - String - required: no - Windows/Linux</li>
<li>Os - String required: no - operating system (value of DescribeMachineOsList)</li>
        :type Filters: list of Filter
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of entries to be returned. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param _Order: Sorting method: asc for ascending order or desc for descending order
        :type Order: str
        :param _By: Sorting method: [FirstTime|PluginCount]
        :type By: str
        """
        self._Quuid = None
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._Order = None
        self._By = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetWebAppListResponse(AbstractModel):
    """DescribeAssetWebAppList response structure.

    """

    def __init__(self):
        r"""
        :param _Total: Total number of records
        :type Total: int
        :param _WebApps: Data list
Note: This field may return null, indicating that no valid values can be obtained.
        :type WebApps: list of AssetWebAppBaseInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Total = None
        self._WebApps = None
        self._RequestId = None

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def WebApps(self):
        return self._WebApps

    @WebApps.setter
    def WebApps(self, WebApps):
        self._WebApps = WebApps

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("WebApps") is not None:
            self._WebApps = []
            for item in params.get("WebApps"):
                obj = AssetWebAppBaseInfo()
                obj._deserialize(item)
                self._WebApps.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAssetWebAppPluginListRequest(AbstractModel):
    """DescribeAssetWebAppPluginList request structure.

    """

    def __init__(self):
        r"""
        :param _Quuid: Host QUUID
        :type Quuid: str
        :param _Uuid: Host UUID
        :type Uuid: str
        :param _Id: Web application ID
        :type Id: str
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of items to be returned. It is 10 by default, and the maximum value is 100.
        :type Limit: int
        """
        self._Quuid = None
        self._Uuid = None
        self._Id = None
        self._Offset = None
        self._Limit = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._Id = params.get("Id")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetWebAppPluginListResponse(AbstractModel):
    """DescribeAssetWebAppPluginList response structure.

    """

    def __init__(self):
        r"""
        :param _Plugins: Data list
Note: This field may return null, indicating that no valid values can be obtained.
        :type Plugins: list of AssetWebAppPluginInfo
        :param _Total: Total number of partitions
        :type Total: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Plugins = None
        self._Total = None
        self._RequestId = None

    @property
    def Plugins(self):
        return self._Plugins

    @Plugins.setter
    def Plugins(self, Plugins):
        self._Plugins = Plugins

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Plugins") is not None:
            self._Plugins = []
            for item in params.get("Plugins"):
                obj = AssetWebAppPluginInfo()
                obj._deserialize(item)
                self._Plugins.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeAssetWebFrameCountRequest(AbstractModel):
    """DescribeAssetWebFrameCount request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Search criteria: Return a list of all Web frameworks containing Name.
        :type Name: str
        """
        self._Name = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetWebFrameCountResponse(AbstractModel):
    """DescribeAssetWebFrameCount response structure.

    """

    def __init__(self):
        r"""
        :param _WebFrames: Number of individual Web frameworks
        :type WebFrames: list of AssetKeyVal
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._WebFrames = None
        self._RequestId = None

    @property
    def WebFrames(self):
        return self._WebFrames

    @WebFrames.setter
    def WebFrames(self, WebFrames):
        self._WebFrames = WebFrames

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("WebFrames") is not None:
            self._WebFrames = []
            for item in params.get("WebFrames"):
                obj = AssetKeyVal()
                obj._deserialize(item)
                self._WebFrames.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAssetWebFrameListRequest(AbstractModel):
    """DescribeAssetWebFrameList request structure.

    """

    def __init__(self):
        r"""
        :param _Quuid: Query the information on the host with the specified QUUID
        :type Quuid: str
        :param _Filters: Filtering criteria
<li>IP - String - required: no - host IP address</li>
<li>MachineName - String - required: no - host name</li>
<li>InstanceID - string - required: no - instance ID</li>
<li>Name - String - required: no - framework name</li>
<li>NameStrict - String - required: no - framework name (strict match)</li>
<li>Lang - String - required: no - framework language: java/python</li>
<li>Type - String - required: no - service type:
0: all
1:Tomcat
2:Apache
3:Nginx
4:WebLogic
5:Websphere
6:JBoss
7:WildFly
8:Jetty
9:IHS
10:Tengine</li>
<li>OsType - String - required: no - Windows/Linux</li>
<li>Os -String required: no - operating system (value of DescribeMachineOsList)</li>
        :type Filters: list of Filter
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of results to be returned. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param _Order: Sorting method: asc for ascending order or desc for descending order
        :type Order: str
        :param _By: Sorting method: [FirstTime|JarCount]
        :type By: str
        """
        self._Quuid = None
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._Order = None
        self._By = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetWebFrameListResponse(AbstractModel):
    """DescribeAssetWebFrameList response structure.

    """

    def __init__(self):
        r"""
        :param _Total: Total number of records
        :type Total: int
        :param _WebFrames: Data list
Note: This field may return null, indicating that no valid values can be obtained.
        :type WebFrames: list of AssetWebFrameBaseInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Total = None
        self._WebFrames = None
        self._RequestId = None

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def WebFrames(self):
        return self._WebFrames

    @WebFrames.setter
    def WebFrames(self, WebFrames):
        self._WebFrames = WebFrames

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("WebFrames") is not None:
            self._WebFrames = []
            for item in params.get("WebFrames"):
                obj = AssetWebFrameBaseInfo()
                obj._deserialize(item)
                self._WebFrames.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAssetWebLocationCountRequest(AbstractModel):
    """DescribeAssetWebLocationCount request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Search criteria: return a list of all web sites whose names contain Name.
        :type Name: str
        """
        self._Name = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetWebLocationCountResponse(AbstractModel):
    """DescribeAssetWebLocationCount response structure.

    """

    def __init__(self):
        r"""
        :param _WebLocations: Number of individual Web sites
        :type WebLocations: list of AssetKeyVal
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._WebLocations = None
        self._RequestId = None

    @property
    def WebLocations(self):
        return self._WebLocations

    @WebLocations.setter
    def WebLocations(self, WebLocations):
        self._WebLocations = WebLocations

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("WebLocations") is not None:
            self._WebLocations = []
            for item in params.get("WebLocations"):
                obj = AssetKeyVal()
                obj._deserialize(item)
                self._WebLocations.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAssetWebLocationInfoRequest(AbstractModel):
    """DescribeAssetWebLocationInfo request structure.

    """

    def __init__(self):
        r"""
        :param _Quuid: Server QUUID
        :type Quuid: str
        :param _Uuid: Server UUID
        :type Uuid: str
        :param _Id: Site ID
        :type Id: str
        """
        self._Quuid = None
        self._Uuid = None
        self._Id = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetWebLocationInfoResponse(AbstractModel):
    """DescribeAssetWebLocationInfo response structure.

    """

    def __init__(self):
        r"""
        :param _WebLocation: Site information
Note: This field may return null, indicating that no valid values can be obtained.
        :type WebLocation: :class:`tencentcloud.cwp.v20180228.models.AssetWebLocationInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._WebLocation = None
        self._RequestId = None

    @property
    def WebLocation(self):
        return self._WebLocation

    @WebLocation.setter
    def WebLocation(self, WebLocation):
        self._WebLocation = WebLocation

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("WebLocation") is not None:
            self._WebLocation = AssetWebLocationInfo()
            self._WebLocation._deserialize(params.get("WebLocation"))
        self._RequestId = params.get("RequestId")


class DescribeAssetWebLocationListRequest(AbstractModel):
    """DescribeAssetWebLocationList request structure.

    """

    def __init__(self):
        r"""
        :param _Quuid: Query the information on the host with the specified QUUID
        :type Quuid: str
        :param _Filters: Filtering criteria
<li>IP - String - required: no - host IP address</li>
<li>MachineName - String - required: no - host name</li>
<li>InstanceID - string - required: no - instance ID</li>
<li>Name - String - required: no - domain name</li>
<li>User - String - required: no - running user</li>
<li>Port - uint64 - required: no - site port</li>
<li>Proto - uint64 - required: no - site protocol: 1: HTTP; 2: HTTPS</li><li>ServiceType - uint64 - required: no - service type:
1:Tomcat
2: Apache
3:Nginx
4:WebLogic
5:Websphere
6:JBoss
7:WildFly
8:Jetty
9:IHS
10:Tengine</li>
<li>OsType - String - required: no - Windows/Linux</li>
<li>Os - String required: no - operating system (value of DescribeMachineOsList)</li>
        :type Filters: list of Filter
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of entries to be returned. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param _Order: Sorting method: asc for ascending order or desc for descending order
        :type Order: str
        :param _By: Sorting method: [FirstTime|PathCount]
        :type By: str
        """
        self._Quuid = None
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._Order = None
        self._By = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetWebLocationListResponse(AbstractModel):
    """DescribeAssetWebLocationList response structure.

    """

    def __init__(self):
        r"""
        :param _Total: Total number of records
        :type Total: int
        :param _Locations: Site list
Note: This field may return null, indicating that no valid values can be obtained.
        :type Locations: list of AssetWebLocationBaseInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Total = None
        self._Locations = None
        self._RequestId = None

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Locations(self):
        return self._Locations

    @Locations.setter
    def Locations(self, Locations):
        self._Locations = Locations

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("Locations") is not None:
            self._Locations = []
            for item in params.get("Locations"):
                obj = AssetWebLocationBaseInfo()
                obj._deserialize(item)
                self._Locations.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAssetWebLocationPathListRequest(AbstractModel):
    """DescribeAssetWebLocationPathList request structure.

    """

    def __init__(self):
        r"""
        :param _Quuid: Server QUUID
        :type Quuid: str
        :param _Uuid: Server UUID
        :type Uuid: str
        :param _Id: Web site ID
        :type Id: str
        :param _Limit: Number of returned lists. It is 10 by default, and the maximum number is 100.
        :type Limit: int
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        """
        self._Quuid = None
        self._Uuid = None
        self._Id = None
        self._Limit = None
        self._Offset = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._Id = params.get("Id")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetWebLocationPathListResponse(AbstractModel):
    """DescribeAssetWebLocationPathList response structure.

    """

    def __init__(self):
        r"""
        :param _Total: Total number
Note: This field may return null, indicating that no valid values can be obtained.
        :type Total: int
        :param _Paths: List
Note: This field may return null, indicating that no valid values can be obtained.
        :type Paths: list of AssetWebLocationPath
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Total = None
        self._Paths = None
        self._RequestId = None

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Paths(self):
        return self._Paths

    @Paths.setter
    def Paths(self, Paths):
        self._Paths = Paths

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("Paths") is not None:
            self._Paths = []
            for item in params.get("Paths"):
                obj = AssetWebLocationPath()
                obj._deserialize(item)
                self._Paths.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAssetWebServiceCountRequest(AbstractModel):
    """DescribeAssetWebServiceCount request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Search criteria: Return a list of all Web services containing Name in the name.
        :type Name: str
        """
        self._Name = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetWebServiceCountResponse(AbstractModel):
    """DescribeAssetWebServiceCount response structure.

    """

    def __init__(self):
        r"""
        :param _WebServices: Number of web services
        :type WebServices: list of AssetKeyVal
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._WebServices = None
        self._RequestId = None

    @property
    def WebServices(self):
        return self._WebServices

    @WebServices.setter
    def WebServices(self, WebServices):
        self._WebServices = WebServices

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("WebServices") is not None:
            self._WebServices = []
            for item in params.get("WebServices"):
                obj = AssetKeyVal()
                obj._deserialize(item)
                self._WebServices.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAssetWebServiceInfoListRequest(AbstractModel):
    """DescribeAssetWebServiceInfoList request structure.

    """

    def __init__(self):
        r"""
        :param _Quuid: Query the information on the host with the specified QUUID
        :type Quuid: str
        :param _Filters: Filter criteria
<li>User - string - required: no - running user</li>
<li>Name - string - required: no - Web service name:</li>
1:Tomcat
2:Apache
3:Nginx
4:WebLogic
5:Websphere
6:JBoss
7:WildFly
8:Jetty
9:IHS
10:Tengine</li>
<li>OsType - string - required: no - Windows/Linux</li>
<li>Os -String required: no - operating system (the value of DescribeMachineOsList API)</li>
        :type Filters: list of AssetFilters
        :param _Offset: Offset, which is 0 by default.
<li>IpOrAlias - String - required: no - filter by host IP or alias</li>
        :type Offset: int
        :param _Limit: Number of items to be returned. It is 10 by default, and the maximum value is 100.
        :type Limit: int
        :param _Order: Sorting method: asc for ascending order or desc for descending order
        :type Order: str
        :param _By: Optional sorting method: [FirstTime|ProcessCount]
        :type By: str
        """
        self._Quuid = None
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._Order = None
        self._By = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetWebServiceInfoListResponse(AbstractModel):
    """DescribeAssetWebServiceInfoList response structure.

    """

    def __init__(self):
        r"""
        :param _WebServices: List
Note: This field may return null, indicating that no valid values can be obtained.
        :type WebServices: list of AssetWebServiceBaseInfo
        :param _Total: Total number
        :type Total: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._WebServices = None
        self._Total = None
        self._RequestId = None

    @property
    def WebServices(self):
        return self._WebServices

    @WebServices.setter
    def WebServices(self, WebServices):
        self._WebServices = WebServices

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("WebServices") is not None:
            self._WebServices = []
            for item in params.get("WebServices"):
                obj = AssetWebServiceBaseInfo()
                obj._deserialize(item)
                self._WebServices.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeAssetWebServiceProcessListRequest(AbstractModel):
    """DescribeAssetWebServiceProcessList request structure.

    """

    def __init__(self):
        r"""
        :param _Quuid: Host QUUID
        :type Quuid: str
        :param _Uuid: Host UUID
        :type Uuid: str
        :param _Id: Web service ID
        :type Id: str
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of results to be returned. Default value: 10. Maximum value: 100.
        :type Limit: int
        """
        self._Quuid = None
        self._Uuid = None
        self._Id = None
        self._Offset = None
        self._Limit = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._Id = params.get("Id")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetWebServiceProcessListResponse(AbstractModel):
    """DescribeAssetWebServiceProcessList response structure.

    """

    def __init__(self):
        r"""
        :param _Process: Process list
Note: This field may return null, indicating that no valid values can be obtained.
        :type Process: list of AssetAppProcessInfo
        :param _Total: Total number
        :type Total: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Process = None
        self._Total = None
        self._RequestId = None

    @property
    def Process(self):
        return self._Process

    @Process.setter
    def Process(self, Process):
        self._Process = Process

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Process") is not None:
            self._Process = []
            for item in params.get("Process"):
                obj = AssetAppProcessInfo()
                obj._deserialize(item)
                self._Process.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeAttackEventInfoRequest(AbstractModel):
    """DescribeAttackEventInfo request structure.

    """

    def __init__(self):
        r"""
        :param _Id: Event ID
        :type Id: int
        """
        self._Id = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAttackEventInfoResponse(AbstractModel):
    """DescribeAttackEventInfo response structure.

    """

    def __init__(self):
        r"""
        :param _NetAttackEventInfo: Network attack event details
        :type NetAttackEventInfo: :class:`tencentcloud.cwp.v20180228.models.NetAttackEventInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NetAttackEventInfo = None
        self._RequestId = None

    @property
    def NetAttackEventInfo(self):
        return self._NetAttackEventInfo

    @NetAttackEventInfo.setter
    def NetAttackEventInfo(self, NetAttackEventInfo):
        self._NetAttackEventInfo = NetAttackEventInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NetAttackEventInfo") is not None:
            self._NetAttackEventInfo = NetAttackEventInfo()
            self._NetAttackEventInfo._deserialize(params.get("NetAttackEventInfo"))
        self._RequestId = params.get("RequestId")


class DescribeAttackEventsRequest(AbstractModel):
    """DescribeAttackEvents request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of returns. The maximum value is 100.
        :type Limit: int
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Filters:  Filter criteria
<li>Type - String attack status. 0: attempted attack; 1: attack succeeded - required: no</li>
<li>Status - String event processing status: 0: pending 1: processed; 2: allowlisted; 3: ignored; 4: deleted - required: no</li>
<li>SrcIP - String source IP - required: no</li>
<li>Uuids - String CWPP UUID - required: no</li>
<li>Quuids - String CVM UUID - required: no</li>
<li>DstPort - String attack target port - required: no</li>
<li>MachineName - String host name - required: no</li>
<li>InstanceID - String host instance ID - required: no</li>
<li>AttackTimeBegin - String attack start time - required: no</li>
<li>AttackTimeEnd - String attack end time - required: no</li>
<li>VulSupportDefense - String: whether the vulnerability can be defended: 0: no;1: yes - required: no</li>

        :type Filters: list of Filter
        :param _By: Sort
        :type By: str
        :param _Order: Sorting method: ASC, DESC
        :type Order: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._By = None
        self._Order = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAttackEventsResponse(AbstractModel):
    """DescribeAttackEvents response structure.

    """

    def __init__(self):
        r"""
        :param _List: Attack Event List
Note: This field may return null, indicating that no valid values can be obtained.
        :type List: list of NetAttackEvent
        :param _TotalCount: Total number of entries
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = NetAttackEvent()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAttackLogsRequest(AbstractModel):
    """DescribeAttackLogs request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of returns. The maximum value is 100.
        :type Limit: int
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Filters: Filter criteria
<li>HttpMethod - String - required: no - attack method (POST|GET)</li>
<li>DateRange - String - required: no - timeframe (store data from the past 3 months), such as the last month ["2019-11-17", "2019-12-17"]</li>
<li>VulType - String threat type - required: no</li>
<li>SrcIp - String attack source IP - required: no</li>
<li>DstIp - String attack target IP - required: no</li>
<li>SrcPort - String attack source port - required: no</li>
<li>DstPort - String attack target port - required: no</li>
        :type Filters: list of Filter
        :param _Uuid: CWPP client ID
        :type Uuid: str
        :param _Quuid: CVM machine ID
        :type Quuid: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Uuid = None
        self._Quuid = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Uuid = params.get("Uuid")
        self._Quuid = params.get("Quuid")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAttackLogsResponse(AbstractModel):
    """DescribeAttackLogs response structure.

    """

    def __init__(self):
        r"""
        :param _AttackLogs: Log list
Note: This field may return null, indicating that no valid values can be obtained.
        :type AttackLogs: list of DefendAttackLog
        :param _TotalCount: Total number
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._AttackLogs = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def AttackLogs(self):
        return self._AttackLogs

    @AttackLogs.setter
    def AttackLogs(self, AttackLogs):
        self._AttackLogs = AttackLogs

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("AttackLogs") is not None:
            self._AttackLogs = []
            for item in params.get("AttackLogs"):
                obj = DefendAttackLog()
                obj._deserialize(item)
                self._AttackLogs.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAttackSourceEventsRequest(AbstractModel):
    """DescribeAttackSourceEvents request structure.

    """

    def __init__(self):
        r"""
        :param _Uuid: Host UUID
        :type Uuid: str
        :param _BeginDate: Start date
        :type BeginDate: str
        :param _EndDate: End date
        :type EndDate: str
        :param _EventInfoParam: EventInfoParam returned by DescribeAttackSource API
        :type EventInfoParam: str
        :param _Limit: Maximum number of paginations, which is 10 by default.
        :type Limit: int
        :param _Offset: Starting step size, which is 0 by default.
        :type Offset: int
        """
        self._Uuid = None
        self._BeginDate = None
        self._EndDate = None
        self._EventInfoParam = None
        self._Limit = None
        self._Offset = None

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def BeginDate(self):
        return self._BeginDate

    @BeginDate.setter
    def BeginDate(self, BeginDate):
        self._BeginDate = BeginDate

    @property
    def EndDate(self):
        return self._EndDate

    @EndDate.setter
    def EndDate(self, EndDate):
        self._EndDate = EndDate

    @property
    def EventInfoParam(self):
        return self._EventInfoParam

    @EventInfoParam.setter
    def EventInfoParam(self, EventInfoParam):
        self._EventInfoParam = EventInfoParam

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._Uuid = params.get("Uuid")
        self._BeginDate = params.get("BeginDate")
        self._EndDate = params.get("EndDate")
        self._EventInfoParam = params.get("EventInfoParam")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAttackSourceEventsResponse(AbstractModel):
    """DescribeAttackSourceEvents response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of entries
        :type TotalCount: int
        :param _List: Attack tracing event list
        :type List: list of AttackSourceEvent
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._List = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = AttackSourceEvent()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAttackSourceRequest(AbstractModel):
    """DescribeAttackSource request structure.

    """

    def __init__(self):
        r"""
        :param _Uuid: Host UUID
        :type Uuid: str
        :param _BeginDate: Start date
        :type BeginDate: str
        :param _EndDate: End date
        :type EndDate: str
        """
        self._Uuid = None
        self._BeginDate = None
        self._EndDate = None

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def BeginDate(self):
        return self._BeginDate

    @BeginDate.setter
    def BeginDate(self, BeginDate):
        self._BeginDate = BeginDate

    @property
    def EndDate(self):
        return self._EndDate

    @EndDate.setter
    def EndDate(self, EndDate):
        self._EndDate = EndDate


    def _deserialize(self, params):
        self._Uuid = params.get("Uuid")
        self._BeginDate = params.get("BeginDate")
        self._EndDate = params.get("EndDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAttackSourceResponse(AbstractModel):
    """DescribeAttackSource response structure.

    """

    def __init__(self):
        r"""
        :param _AttackSource: Attack backtracking data
        :type AttackSource: :class:`tencentcloud.cwp.v20180228.models.AttackSource`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._AttackSource = None
        self._RequestId = None

    @property
    def AttackSource(self):
        return self._AttackSource

    @AttackSource.setter
    def AttackSource(self, AttackSource):
        self._AttackSource = AttackSource

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("AttackSource") is not None:
            self._AttackSource = AttackSource()
            self._AttackSource._deserialize(params.get("AttackSource"))
        self._RequestId = params.get("RequestId")


class DescribeAttackStatisticsRequest(AbstractModel):
    """DescribeAttackStatistics request structure.

    """


class DescribeAttackStatisticsResponse(AbstractModel):
    """DescribeAttackStatistics response structure.

    """

    def __init__(self):
        r"""
        :param _PendingAttackCount: Total Number of Attacks
Note: This field may return null, indicating that no valid values can be obtained.
        :type PendingAttackCount: int
        :param _PendingTryAttackCount: Total Attack Attempts
Note: This field may return null, indicating that no valid values can be obtained.
        :type PendingTryAttackCount: int
        :param _PendingSuccAttackCount: Total Number of Successful Attacks
Note: This field may return null, indicating that no valid values can be obtained.
        :type PendingSuccAttackCount: int
        :param _PendingNewAttackCount: Number of New Attacks Today
Note: This field may return null, indicating that no valid values can be obtained.
        :type PendingNewAttackCount: int
        :param _AttackedAssetCount: Total Number of Assets Under Attack
Note: This field may return null, indicating that no valid values can be obtained.
        :type AttackedAssetCount: int
        :param _NewAttackedAssetCount: Number of New Attacked Assets Today
Note: This field may return null, indicating that no valid values can be obtained.
        :type NewAttackedAssetCount: int
        :param _AttackedPortCount: Total Number of Attacked Ports
Note: This field may return null, indicating that no valid values can be obtained.
        :type AttackedPortCount: int
        :param _NewAttackedPortCount: Number of New Attacked Ports Today
Note: This field may return null, indicating that no valid values can be obtained.
        :type NewAttackedPortCount: int
        :param _AttackSrcIpCount: Total Number of Attack Source IPs
Note: This field may return null, indicating that no valid values can be obtained.
        :type AttackSrcIpCount: int
        :param _NewAttackSrcIpCount: Number of New Attacking Source IPs Today
Note: This field may return null, indicating that no valid values can be obtained.
        :type NewAttackSrcIpCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._PendingAttackCount = None
        self._PendingTryAttackCount = None
        self._PendingSuccAttackCount = None
        self._PendingNewAttackCount = None
        self._AttackedAssetCount = None
        self._NewAttackedAssetCount = None
        self._AttackedPortCount = None
        self._NewAttackedPortCount = None
        self._AttackSrcIpCount = None
        self._NewAttackSrcIpCount = None
        self._RequestId = None

    @property
    def PendingAttackCount(self):
        return self._PendingAttackCount

    @PendingAttackCount.setter
    def PendingAttackCount(self, PendingAttackCount):
        self._PendingAttackCount = PendingAttackCount

    @property
    def PendingTryAttackCount(self):
        return self._PendingTryAttackCount

    @PendingTryAttackCount.setter
    def PendingTryAttackCount(self, PendingTryAttackCount):
        self._PendingTryAttackCount = PendingTryAttackCount

    @property
    def PendingSuccAttackCount(self):
        return self._PendingSuccAttackCount

    @PendingSuccAttackCount.setter
    def PendingSuccAttackCount(self, PendingSuccAttackCount):
        self._PendingSuccAttackCount = PendingSuccAttackCount

    @property
    def PendingNewAttackCount(self):
        return self._PendingNewAttackCount

    @PendingNewAttackCount.setter
    def PendingNewAttackCount(self, PendingNewAttackCount):
        self._PendingNewAttackCount = PendingNewAttackCount

    @property
    def AttackedAssetCount(self):
        return self._AttackedAssetCount

    @AttackedAssetCount.setter
    def AttackedAssetCount(self, AttackedAssetCount):
        self._AttackedAssetCount = AttackedAssetCount

    @property
    def NewAttackedAssetCount(self):
        return self._NewAttackedAssetCount

    @NewAttackedAssetCount.setter
    def NewAttackedAssetCount(self, NewAttackedAssetCount):
        self._NewAttackedAssetCount = NewAttackedAssetCount

    @property
    def AttackedPortCount(self):
        return self._AttackedPortCount

    @AttackedPortCount.setter
    def AttackedPortCount(self, AttackedPortCount):
        self._AttackedPortCount = AttackedPortCount

    @property
    def NewAttackedPortCount(self):
        return self._NewAttackedPortCount

    @NewAttackedPortCount.setter
    def NewAttackedPortCount(self, NewAttackedPortCount):
        self._NewAttackedPortCount = NewAttackedPortCount

    @property
    def AttackSrcIpCount(self):
        return self._AttackSrcIpCount

    @AttackSrcIpCount.setter
    def AttackSrcIpCount(self, AttackSrcIpCount):
        self._AttackSrcIpCount = AttackSrcIpCount

    @property
    def NewAttackSrcIpCount(self):
        return self._NewAttackSrcIpCount

    @NewAttackSrcIpCount.setter
    def NewAttackSrcIpCount(self, NewAttackSrcIpCount):
        self._NewAttackSrcIpCount = NewAttackSrcIpCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._PendingAttackCount = params.get("PendingAttackCount")
        self._PendingTryAttackCount = params.get("PendingTryAttackCount")
        self._PendingSuccAttackCount = params.get("PendingSuccAttackCount")
        self._PendingNewAttackCount = params.get("PendingNewAttackCount")
        self._AttackedAssetCount = params.get("AttackedAssetCount")
        self._NewAttackedAssetCount = params.get("NewAttackedAssetCount")
        self._AttackedPortCount = params.get("AttackedPortCount")
        self._NewAttackedPortCount = params.get("NewAttackedPortCount")
        self._AttackSrcIpCount = params.get("AttackSrcIpCount")
        self._NewAttackSrcIpCount = params.get("NewAttackSrcIpCount")
        self._RequestId = params.get("RequestId")


class DescribeAttackTopRequest(AbstractModel):
    """DescribeAttackTop request structure.

    """

    def __init__(self):
        r"""
        :param _Filters:  Filter criteria
<li>BeginTime - String - start time, defaulted to last 7 days - required: no</li>
        :type Filters: list of Filter
        """
        self._Filters = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAttackTopResponse(AbstractModel):
    """DescribeAttackTop response structure.

    """

    def __init__(self):
        r"""
        :param _NetAttackTopInfo: Top Statistics
Note: This field may return null, indicating that no valid values can be obtained.
        :type NetAttackTopInfo: :class:`tencentcloud.cwp.v20180228.models.NetAttackTopInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NetAttackTopInfo = None
        self._RequestId = None

    @property
    def NetAttackTopInfo(self):
        return self._NetAttackTopInfo

    @NetAttackTopInfo.setter
    def NetAttackTopInfo(self, NetAttackTopInfo):
        self._NetAttackTopInfo = NetAttackTopInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NetAttackTopInfo") is not None:
            self._NetAttackTopInfo = NetAttackTopInfo()
            self._NetAttackTopInfo._deserialize(params.get("NetAttackTopInfo"))
        self._RequestId = params.get("RequestId")


class DescribeAttackTrendsRequest(AbstractModel):
    """DescribeAttackTrends request structure.

    """

    def __init__(self):
        r"""
        :param _Filters:  Filter criteria
<li>BeginTime - String start time, default: last 7 days - required: no</li>
        :type Filters: list of Filter
        """
        self._Filters = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAttackTrendsResponse(AbstractModel):
    """DescribeAttackTrends response structure.

    """

    def __init__(self):
        r"""
        :param _NetAttackTrend: Attack Trend Statistics (Days)
Note: This field may return null, indicating that no valid values can be obtained.
        :type NetAttackTrend: list of NetAttackTrend
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NetAttackTrend = None
        self._RequestId = None

    @property
    def NetAttackTrend(self):
        return self._NetAttackTrend

    @NetAttackTrend.setter
    def NetAttackTrend(self, NetAttackTrend):
        self._NetAttackTrend = NetAttackTrend

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NetAttackTrend") is not None:
            self._NetAttackTrend = []
            for item in params.get("NetAttackTrend"):
                obj = NetAttackTrend()
                obj._deserialize(item)
                self._NetAttackTrend.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAttackVulTypeListRequest(AbstractModel):
    """DescribeAttackVulTypeList request structure.

    """


class DescribeAttackVulTypeListResponse(AbstractModel):
    """DescribeAttackVulTypeList response structure.

    """

    def __init__(self):
        r"""
        :param _List: Threat type list
        :type List: list of str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._List = params.get("List")
        self._RequestId = params.get("RequestId")


class DescribeAvailableExpertServiceDetailRequest(AbstractModel):
    """DescribeAvailableExpertServiceDetail request structure.

    """


class DescribeAvailableExpertServiceDetailResponse(AbstractModel):
    """DescribeAvailableExpertServiceDetail response structure.

    """

    def __init__(self):
        r"""
        :param _ExpertService: Security manager order
        :type ExpertService: list of ExpertServiceOrderInfo
        :param _EmergencyResponse: Number of available emergency responses
        :type EmergencyResponse: int
        :param _ProtectNet: 
        :type ProtectNet: int
        :param _ExpertServiceBuy: Whether you purchased security manager
        :type ExpertServiceBuy: bool
        :param _EmergencyResponseBuy: Whether you purchased emergency response
        :type EmergencyResponseBuy: bool
        :param _ProtectNetBuy: 
        :type ProtectNetBuy: bool
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ExpertService = None
        self._EmergencyResponse = None
        self._ProtectNet = None
        self._ExpertServiceBuy = None
        self._EmergencyResponseBuy = None
        self._ProtectNetBuy = None
        self._RequestId = None

    @property
    def ExpertService(self):
        return self._ExpertService

    @ExpertService.setter
    def ExpertService(self, ExpertService):
        self._ExpertService = ExpertService

    @property
    def EmergencyResponse(self):
        return self._EmergencyResponse

    @EmergencyResponse.setter
    def EmergencyResponse(self, EmergencyResponse):
        self._EmergencyResponse = EmergencyResponse

    @property
    def ProtectNet(self):
        return self._ProtectNet

    @ProtectNet.setter
    def ProtectNet(self, ProtectNet):
        self._ProtectNet = ProtectNet

    @property
    def ExpertServiceBuy(self):
        return self._ExpertServiceBuy

    @ExpertServiceBuy.setter
    def ExpertServiceBuy(self, ExpertServiceBuy):
        self._ExpertServiceBuy = ExpertServiceBuy

    @property
    def EmergencyResponseBuy(self):
        return self._EmergencyResponseBuy

    @EmergencyResponseBuy.setter
    def EmergencyResponseBuy(self, EmergencyResponseBuy):
        self._EmergencyResponseBuy = EmergencyResponseBuy

    @property
    def ProtectNetBuy(self):
        return self._ProtectNetBuy

    @ProtectNetBuy.setter
    def ProtectNetBuy(self, ProtectNetBuy):
        self._ProtectNetBuy = ProtectNetBuy

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ExpertService") is not None:
            self._ExpertService = []
            for item in params.get("ExpertService"):
                obj = ExpertServiceOrderInfo()
                obj._deserialize(item)
                self._ExpertService.append(obj)
        self._EmergencyResponse = params.get("EmergencyResponse")
        self._ProtectNet = params.get("ProtectNet")
        self._ExpertServiceBuy = params.get("ExpertServiceBuy")
        self._EmergencyResponseBuy = params.get("EmergencyResponseBuy")
        self._ProtectNetBuy = params.get("ProtectNetBuy")
        self._RequestId = params.get("RequestId")


class DescribeBanModeRequest(AbstractModel):
    """DescribeBanMode request structure.

    """


class DescribeBanModeResponse(AbstractModel):
    """DescribeBanMode response structure.

    """

    def __init__(self):
        r"""
        :param _Mode: Blocking mode. STANDARD_MODE: standard mode; DEEP_MODE: deep mode.
        :type Mode: str
        :param _StandardModeConfig: Configuration of the standard blocking mode
        :type StandardModeConfig: :class:`tencentcloud.cwp.v20180228.models.StandardModeConfig`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Mode = None
        self._StandardModeConfig = None
        self._RequestId = None

    @property
    def Mode(self):
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def StandardModeConfig(self):
        return self._StandardModeConfig

    @StandardModeConfig.setter
    def StandardModeConfig(self, StandardModeConfig):
        self._StandardModeConfig = StandardModeConfig

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Mode = params.get("Mode")
        if params.get("StandardModeConfig") is not None:
            self._StandardModeConfig = StandardModeConfig()
            self._StandardModeConfig._deserialize(params.get("StandardModeConfig"))
        self._RequestId = params.get("RequestId")


class DescribeBanRegionsRequest(AbstractModel):
    """DescribeBanRegions request structure.

    """

    def __init__(self):
        r"""
        :param _Mode: Blocking mode. STANDARD_MODE: standard mode; DEEP_MODE: deep mode.
        :type Mode: str
        """
        self._Mode = None

    @property
    def Mode(self):
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode


    def _deserialize(self, params):
        self._Mode = params.get("Mode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBanRegionsResponse(AbstractModel):
    """DescribeBanRegions response structure.

    """

    def __init__(self):
        r"""
        :param _RegionSet: Region information list
        :type RegionSet: list of RegionSet
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RegionSet = None
        self._RequestId = None

    @property
    def RegionSet(self):
        return self._RegionSet

    @RegionSet.setter
    def RegionSet(self, RegionSet):
        self._RegionSet = RegionSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RegionSet") is not None:
            self._RegionSet = []
            for item in params.get("RegionSet"):
                obj = RegionSet()
                obj._deserialize(item)
                self._RegionSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBanStatusRequest(AbstractModel):
    """DescribeBanStatus request structure.

    """


class DescribeBanStatusResponse(AbstractModel):
    """DescribeBanStatus response structure.

    """

    def __init__(self):
        r"""
        :param _Status: Blocking enabling status:
0: disabled 
1: advanced blocking
2: basic blocking (block only malicious IP addresses in the intelligence database)
        :type Status: int
        :param _ShowTips: Whether to display the pop-up prompt. False: no; true: yes.
        :type ShowTips: bool
        :param _OpenSmartMode: Whether to enable intelligent over-allowing mode
        :type OpenSmartMode: bool
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Status = None
        self._ShowTips = None
        self._OpenSmartMode = None
        self._RequestId = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ShowTips(self):
        return self._ShowTips

    @ShowTips.setter
    def ShowTips(self, ShowTips):
        self._ShowTips = ShowTips

    @property
    def OpenSmartMode(self):
        return self._OpenSmartMode

    @OpenSmartMode.setter
    def OpenSmartMode(self, OpenSmartMode):
        self._OpenSmartMode = OpenSmartMode

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ShowTips = params.get("ShowTips")
        self._OpenSmartMode = params.get("OpenSmartMode")
        self._RequestId = params.get("RequestId")


class DescribeBanWhiteListRequest(AbstractModel):
    """DescribeBanWhiteList request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Offset, which defaults to 0
        :type Offset: int
        :param _Limit: Quantity of returns. The maximum value is 100.
        :type Limit: int
        :param _Filters: Filter criteria
<li>Keywords - String - required: no - query by keywords</li>
        :type Filters: list of Filter
        """
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBanWhiteListResponse(AbstractModel):
    """DescribeBanWhiteList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of records
        :type TotalCount: int
        :param _WhiteList: Allowlist
        :type WhiteList: list of BanWhiteListDetail
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._WhiteList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def WhiteList(self):
        return self._WhiteList

    @WhiteList.setter
    def WhiteList(self, WhiteList):
        self._WhiteList = WhiteList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("WhiteList") is not None:
            self._WhiteList = []
            for item in params.get("WhiteList"):
                obj = BanWhiteListDetail()
                obj._deserialize(item)
                self._WhiteList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBaselineBasicInfoRequest(AbstractModel):
    """DescribeBaselineBasicInfo request structure.

    """

    def __init__(self):
        r"""
        :param _BaselineName: Baseline name
        :type BaselineName: str
        """
        self._BaselineName = None

    @property
    def BaselineName(self):
        return self._BaselineName

    @BaselineName.setter
    def BaselineName(self, BaselineName):
        self._BaselineName = BaselineName


    def _deserialize(self, params):
        self._BaselineName = params.get("BaselineName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselineBasicInfoResponse(AbstractModel):
    """DescribeBaselineBasicInfo response structure.

    """

    def __init__(self):
        r"""
        :param _BaselineBasicInfoList: Baseline basic information list
Note: This field may return null, indicating that no valid values can be obtained.
        :type BaselineBasicInfoList: list of BaselineBasicInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._BaselineBasicInfoList = None
        self._RequestId = None

    @property
    def BaselineBasicInfoList(self):
        return self._BaselineBasicInfoList

    @BaselineBasicInfoList.setter
    def BaselineBasicInfoList(self, BaselineBasicInfoList):
        self._BaselineBasicInfoList = BaselineBasicInfoList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("BaselineBasicInfoList") is not None:
            self._BaselineBasicInfoList = []
            for item in params.get("BaselineBasicInfoList"):
                obj = BaselineBasicInfo()
                obj._deserialize(item)
                self._BaselineBasicInfoList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBaselineDefaultStrategyListRequest(AbstractModel):
    """DescribeBaselineDefaultStrategyList request structure.

    """


class DescribeBaselineDefaultStrategyListResponse(AbstractModel):
    """DescribeBaselineDefaultStrategyList response structure.

    """

    def __init__(self):
        r"""
        :param _StrategyList: List of the basic default policy information
Note: This field may return null, indicating that no valid values can be obtained.
        :type StrategyList: list of DefaultStrategyInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._StrategyList = None
        self._RequestId = None

    @property
    def StrategyList(self):
        return self._StrategyList

    @StrategyList.setter
    def StrategyList(self, StrategyList):
        self._StrategyList = StrategyList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("StrategyList") is not None:
            self._StrategyList = []
            for item in params.get("StrategyList"):
                obj = DefaultStrategyInfo()
                obj._deserialize(item)
                self._StrategyList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBaselineDetailRequest(AbstractModel):
    """DescribeBaselineDetail request structure.

    """

    def __init__(self):
        r"""
        :param _BaselineId: Baseline ID
        :type BaselineId: int
        """
        self._BaselineId = None

    @property
    def BaselineId(self):
        return self._BaselineId

    @BaselineId.setter
    def BaselineId(self, BaselineId):
        self._BaselineId = BaselineId


    def _deserialize(self, params):
        self._BaselineId = params.get("BaselineId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselineDetailResponse(AbstractModel):
    """DescribeBaselineDetail response structure.

    """

    def __init__(self):
        r"""
        :param _BaselineDetail: Baseline details
Note: This field may return null, indicating that no valid values can be obtained.
        :type BaselineDetail: :class:`tencentcloud.cwp.v20180228.models.BaselineDetail`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._BaselineDetail = None
        self._RequestId = None

    @property
    def BaselineDetail(self):
        return self._BaselineDetail

    @BaselineDetail.setter
    def BaselineDetail(self, BaselineDetail):
        self._BaselineDetail = BaselineDetail

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("BaselineDetail") is not None:
            self._BaselineDetail = BaselineDetail()
            self._BaselineDetail._deserialize(params.get("BaselineDetail"))
        self._RequestId = params.get("RequestId")


class DescribeBaselineEffectHostListRequest(AbstractModel):
    """DescribeBaselineEffectHostList request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Pagination parameters (The maximum number is 100.)
        :type Limit: int
        :param _Offset: Pagination parameter
        :type Offset: int
        :param _BaselineId: Baseline ID
        :type BaselineId: int
        :param _Filters: Filter criteria
<li>AliasName - String - host alias</li>
<li>Status- Uint: 1 - passed; 0 - failed; 5 - under detection</li>
        :type Filters: list of Filters
        :param _StrategyId: Policy ID
        :type StrategyId: int
        :param _UuidList: Host UUID array
        :type UuidList: list of str
        """
        self._Limit = None
        self._Offset = None
        self._BaselineId = None
        self._Filters = None
        self._StrategyId = None
        self._UuidList = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def BaselineId(self):
        return self._BaselineId

    @BaselineId.setter
    def BaselineId(self, BaselineId):
        self._BaselineId = BaselineId

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def StrategyId(self):
        return self._StrategyId

    @StrategyId.setter
    def StrategyId(self, StrategyId):
        self._StrategyId = StrategyId

    @property
    def UuidList(self):
        return self._UuidList

    @UuidList.setter
    def UuidList(self, UuidList):
        self._UuidList = UuidList


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._BaselineId = params.get("BaselineId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._StrategyId = params.get("StrategyId")
        self._UuidList = params.get("UuidList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselineEffectHostListResponse(AbstractModel):
    """DescribeBaselineEffectHostList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of records
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _EffectHostList: List of affected servers
Note: This field may return null, indicating that no valid values can be obtained.
        :type EffectHostList: list of BaselineEffectHost
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._EffectHostList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def EffectHostList(self):
        return self._EffectHostList

    @EffectHostList.setter
    def EffectHostList(self, EffectHostList):
        self._EffectHostList = EffectHostList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("EffectHostList") is not None:
            self._EffectHostList = []
            for item in params.get("EffectHostList"):
                obj = BaselineEffectHost()
                obj._deserialize(item)
                self._EffectHostList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBaselineHostDetectListRequest(AbstractModel):
    """DescribeBaselineHostDetectList request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: <li>PolicyId - int64 - required: no - policy ID</li>
</li>HostName - string - required: no - host name</i>
<li>HostIp - string - required: no - host IP</i>
<li>ItemId - int64 - required: no - item ID</i>
<li>RuleId - int64 - required: no - rule ID</li>
<li>DetectStatus - int - required: no - detection status</li>
<li>Level - int - required: no - risk level<li>
<li>StartTime - string - required: no - start time</li>
<li>EndTime - string - required: no - end time</li>
        :type Filters: list of Filter
        :param _Limit: Limit Entries, 10 by default, up to 100
        :type Limit: int
        :param _Offset: Offset, which is 0 by default.
        :type Offset: int
        :param _Order: Sorting Method: [ASC: Ascending Order, DESC: Descending Order]
        :type Order: str
        :param _By: Optional Order Column: [LastTime|ItemCount|PassedItemCount|NotPassedItemCount|FirstTime]
        :type By: str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselineHostDetectListResponse(AbstractModel):
    """DescribeBaselineHostDetectList response structure.

    """

    def __init__(self):
        r"""
        :param _List: None
        :type List: list of BaselineHostDetect
        :param _Total: Total number
        :type Total: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._Total = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = BaselineHostDetect()
                obj._deserialize(item)
                self._List.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeBaselineHostTopRequest(AbstractModel):
    """DescribeBaselineHostTop request structure.

    """

    def __init__(self):
        r"""
        :param _Top: Dynamic top value
        :type Top: int
        :param _StrategyId: Policy ID
        :type StrategyId: int
        """
        self._Top = None
        self._StrategyId = None

    @property
    def Top(self):
        return self._Top

    @Top.setter
    def Top(self, Top):
        self._Top = Top

    @property
    def StrategyId(self):
        return self._StrategyId

    @StrategyId.setter
    def StrategyId(self, StrategyId):
        self._StrategyId = StrategyId


    def _deserialize(self, params):
        self._Top = params.get("Top")
        self._StrategyId = params.get("StrategyId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselineHostTopResponse(AbstractModel):
    """DescribeBaselineHostTop response structure.

    """

    def __init__(self):
        r"""
        :param _BaselineHostTopList: Top host baseline policy events
Note: This field may return null, indicating that no valid values can be obtained.
        :type BaselineHostTopList: list of BaselineHostTopList
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._BaselineHostTopList = None
        self._RequestId = None

    @property
    def BaselineHostTopList(self):
        return self._BaselineHostTopList

    @BaselineHostTopList.setter
    def BaselineHostTopList(self, BaselineHostTopList):
        self._BaselineHostTopList = BaselineHostTopList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("BaselineHostTopList") is not None:
            self._BaselineHostTopList = []
            for item in params.get("BaselineHostTopList"):
                obj = BaselineHostTopList()
                obj._deserialize(item)
                self._BaselineHostTopList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBaselineItemDetectListRequest(AbstractModel):
    """DescribeBaselineItemDetectList request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: <li>HostId - string - required: no - host ID</li>
<li>RuleId - int64 - required: no - rule ID</li>
<li>PolicyId - int64 - required: no - policy ID</li>
<li>ItemName - string - required: no - item name</li>
<li>DetectStatus - int - required: no - detection status</li>
<li>Level - int - required: no - risk level</li>
<li>StartTime - string - required: no - start time</li>
<li>EndTime - string - required: no - end time</li>
        :type Filters: list of Filter
        :param _Limit: Limit Entries, 10 by default, up to 100
        :type Limit: int
        :param _Offset: Offset, which is 0 by default.
        :type Offset: int
        :param _Order: Sorting Method: [ASC: Ascending Order, DESC: Descending Order]
        :type Order: str
        :param _By: Sorting column: [HostCount|FirstTime|LastTime]
        :type By: str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselineItemDetectListResponse(AbstractModel):
    """DescribeBaselineItemDetectList response structure.

    """

    def __init__(self):
        r"""
        :param _Total: Total number
        :type Total: int
        :param _List: None
        :type List: list of BaselineItemDetect
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Total = None
        self._List = None
        self._RequestId = None

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = BaselineItemDetect()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBaselineItemListRequest(AbstractModel):
    """DescribeBaselineItemList request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: <li>PolicyId - int64 - required: no - policy ID</li>
<li>RuleId - int64 - required: no - rule ID</li>
<li>HostId - string - required: no - host ID</li>
<li>HostName - string - required: no - host name</li>
<li>HostIp - string - required: no - host IP</li>
<li>ItemId - String - required: no - detection item ID</li>
<li>ItemName - String - required: no - item name</li>
<li>DetectStatus - int - required: no - detection status [0: not passed|3: passed|5: detecting]</li>
<li>Level - int - required: no - risk level</li>
<li>StartTime - string - required: no - start time</li>
<li>EndTime - string - required: no - end time</li>
        :type Filters: list of Filter
        :param _Limit: Limit Entries, 10 by default, up to 100
        :type Limit: int
        :param _Offset: Offset, which is 0 by default.
        :type Offset: int
        :param _Order: Sorting Method: [ASC: Ascending Order, DESC: Descending Order]
        :type Order: str
        :param _By: Optional sorting columns
        :type By: str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselineItemListResponse(AbstractModel):
    """DescribeBaselineItemList response structure.

    """

    def __init__(self):
        r"""
        :param _List: None
        :type List: list of BaselineItem
        :param _Total: Total number
        :type Total: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._Total = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = BaselineItem()
                obj._deserialize(item)
                self._List.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeBaselineListRequest(AbstractModel):
    """DescribeBaselineList request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Pagination parameter, indicating the number of entries per page. Maximum value: 100.
        :type Limit: int
        :param _Offset: Pagination parameter
        :type Offset: int
        :param _Filters: Filtering criteria
<li>StrategyId - Uint64 - baseline policy ID</li>
<li>Status - Uint64 - processing status: 1: passed; 0: failed</li><li>Level - Uint64[] - risk level: 1: low; 2: medium; 3: high; 4: critical</li><li>BaselineName - String - baseline name</li>
<li>Quuid - String - host QUUID</li>
<li>Uuid - String - host UUID</li>
        :type Filters: list of Filters
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselineListResponse(AbstractModel):
    """DescribeBaselineList response structure.

    """

    def __init__(self):
        r"""
        :param _BaselineList: List of baseline information
Note: This field may return null, indicating that no valid values can be obtained.
        :type BaselineList: list of BaselineInfo
        :param _TotalCount: Total number of records for paging query
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._BaselineList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def BaselineList(self):
        return self._BaselineList

    @BaselineList.setter
    def BaselineList(self, BaselineList):
        self._BaselineList = BaselineList

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("BaselineList") is not None:
            self._BaselineList = []
            for item in params.get("BaselineList"):
                obj = BaselineInfo()
                obj._deserialize(item)
                self._BaselineList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeBaselinePolicyListRequest(AbstractModel):
    """DescribeBaselinePolicyList request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: <li>PolicyName - String - required: no - policy name</li>
        :type Filters: list of Filter
        :param _Limit: Limit Entries, 10 by default, up to 100
        :type Limit: int
        :param _Offset: Offset, which is 0 by default.
        :type Offset: int
        :param _Order: Sorting Method: [ASC: Ascending Order, DESC: Descending Order]
        :type Order: str
        :param _By: Sorting column: [RuleCount|ItemCount|HostCount]
        :type By: str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselinePolicyListResponse(AbstractModel):
    """DescribeBaselinePolicyList response structure.

    """

    def __init__(self):
        r"""
        :param _List: None
        :type List: list of BaselinePolicy
        :param _Total: Total number
        :type Total: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._Total = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = BaselinePolicy()
                obj._deserialize(item)
                self._List.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeBaselineRuleRequest(AbstractModel):
    """DescribeBaselineRule request structure.

    """

    def __init__(self):
        r"""
        :param _BaselineId: Baseline ID
        :type BaselineId: int
        :param _Limit: Pagination limit, with the maximum value being 100.
        :type Limit: int
        :param _Offset: Pagination parameter
        :type Offset: int
        :param _Level: Severity level
        :type Level: list of int non-negative
        :param _Status: Status
        :type Status: int
        :param _Quuid: Host QUUID
        :type Quuid: str
        :param _Uuid: Host UUID
        :type Uuid: str
        """
        self._BaselineId = None
        self._Limit = None
        self._Offset = None
        self._Level = None
        self._Status = None
        self._Quuid = None
        self._Uuid = None

    @property
    def BaselineId(self):
        return self._BaselineId

    @BaselineId.setter
    def BaselineId(self, BaselineId):
        self._BaselineId = BaselineId

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Level(self):
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid


    def _deserialize(self, params):
        self._BaselineId = params.get("BaselineId")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Level = params.get("Level")
        self._Status = params.get("Status")
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselineRuleResponse(AbstractModel):
    """DescribeBaselineRule response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of pagination query records
        :type TotalCount: int
        :param _BaselineRuleList: Baseline check item list
Note: This field may return null, indicating that no valid values can be obtained.
        :type BaselineRuleList: list of BaselineRuleInfo
        :param _ShowRuleRemark: Whether to display the description column. True: yes; false: no.Note: This field may return null, indicating that no valid values can be obtained.
        :type ShowRuleRemark: bool
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._BaselineRuleList = None
        self._ShowRuleRemark = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def BaselineRuleList(self):
        return self._BaselineRuleList

    @BaselineRuleList.setter
    def BaselineRuleList(self, BaselineRuleList):
        self._BaselineRuleList = BaselineRuleList

    @property
    def ShowRuleRemark(self):
        return self._ShowRuleRemark

    @ShowRuleRemark.setter
    def ShowRuleRemark(self, ShowRuleRemark):
        self._ShowRuleRemark = ShowRuleRemark

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("BaselineRuleList") is not None:
            self._BaselineRuleList = []
            for item in params.get("BaselineRuleList"):
                obj = BaselineRuleInfo()
                obj._deserialize(item)
                self._BaselineRuleList.append(obj)
        self._ShowRuleRemark = params.get("ShowRuleRemark")
        self._RequestId = params.get("RequestId")


class DescribeBaselineScanScheduleRequest(AbstractModel):
    """DescribeBaselineScanSchedule request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID
        :type TaskId: int
        """
        self._TaskId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselineScanScheduleResponse(AbstractModel):
    """DescribeBaselineScanSchedule response structure.

    """

    def __init__(self):
        r"""
        :param _Schedule: Check progress (percentage)
Note: This field may return null, indicating that no valid values can be obtained.
        :type Schedule: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Schedule = None
        self._RequestId = None

    @property
    def Schedule(self):
        return self._Schedule

    @Schedule.setter
    def Schedule(self, Schedule):
        self._Schedule = Schedule

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Schedule = params.get("Schedule")
        self._RequestId = params.get("RequestId")


class DescribeBaselineStrategyDetailRequest(AbstractModel):
    """DescribeBaselineStrategyDetail request structure.

    """

    def __init__(self):
        r"""
        :param _StrategyId: User baseline policy ID
        :type StrategyId: int
        """
        self._StrategyId = None

    @property
    def StrategyId(self):
        return self._StrategyId

    @StrategyId.setter
    def StrategyId(self, StrategyId):
        self._StrategyId = StrategyId


    def _deserialize(self, params):
        self._StrategyId = params.get("StrategyId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselineStrategyDetailResponse(AbstractModel):
    """DescribeBaselineStrategyDetail response structure.

    """

    def __init__(self):
        r"""
        :param _PassRate: Policy scan pass rate
Note: This field may return null, indicating that no valid values can be obtained.
        :type PassRate: int
        :param _StrategyName: Policy name
Note: This field may return null, indicating that no valid values can be obtained.
        :type StrategyName: str
        :param _ScanCycle: policy scan cycle (days)
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanCycle: str
        :param _ScanAt: Regular scan time. The scan task is triggered at this time.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanAt: str
        :param _IsGlobal: Whether all hosts are scanned. 1: yes; 0: no. If the value is 1, all Pro Edition hosts are scanned.Note: This field may return null, indicating that no valid values can be obtained.
        :type IsGlobal: int
        :param _MachineType: Machine type:
cvm: Tencent Cloud Virtual Machine
bm: BM
ecm: Edge Computing Machine
lh: Lighthouse
other: Hybrid Cloud Machine
Note: This field may return null, indicating that no valid values can be obtained.
        :type MachineType: str
        :param _Region: Host region
Note: This field may return null, indicating that no valid values can be obtained.
        :type Region: str
        :param _Quuids: IDs of all user hosts involved in this policy
Note: This field may return null, indicating that no valid values can be obtained.
        :type Quuids: list of str
        :param _CategoryIds: IDs of all user baselines involved in this policy
Note: This field may return null, indicating that no valid values can be obtained.
        :type CategoryIds: list of str
        :param _IfScanned: 1: scanned; 0: not scanned.Note: This field may return null, indicating that no valid values can be obtained.
        :type IfScanned: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._PassRate = None
        self._StrategyName = None
        self._ScanCycle = None
        self._ScanAt = None
        self._IsGlobal = None
        self._MachineType = None
        self._Region = None
        self._Quuids = None
        self._CategoryIds = None
        self._IfScanned = None
        self._RequestId = None

    @property
    def PassRate(self):
        return self._PassRate

    @PassRate.setter
    def PassRate(self, PassRate):
        self._PassRate = PassRate

    @property
    def StrategyName(self):
        return self._StrategyName

    @StrategyName.setter
    def StrategyName(self, StrategyName):
        self._StrategyName = StrategyName

    @property
    def ScanCycle(self):
        return self._ScanCycle

    @ScanCycle.setter
    def ScanCycle(self, ScanCycle):
        self._ScanCycle = ScanCycle

    @property
    def ScanAt(self):
        return self._ScanAt

    @ScanAt.setter
    def ScanAt(self, ScanAt):
        self._ScanAt = ScanAt

    @property
    def IsGlobal(self):
        return self._IsGlobal

    @IsGlobal.setter
    def IsGlobal(self, IsGlobal):
        self._IsGlobal = IsGlobal

    @property
    def MachineType(self):
        return self._MachineType

    @MachineType.setter
    def MachineType(self, MachineType):
        self._MachineType = MachineType

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Quuids(self):
        return self._Quuids

    @Quuids.setter
    def Quuids(self, Quuids):
        self._Quuids = Quuids

    @property
    def CategoryIds(self):
        return self._CategoryIds

    @CategoryIds.setter
    def CategoryIds(self, CategoryIds):
        self._CategoryIds = CategoryIds

    @property
    def IfScanned(self):
        return self._IfScanned

    @IfScanned.setter
    def IfScanned(self, IfScanned):
        self._IfScanned = IfScanned

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._PassRate = params.get("PassRate")
        self._StrategyName = params.get("StrategyName")
        self._ScanCycle = params.get("ScanCycle")
        self._ScanAt = params.get("ScanAt")
        self._IsGlobal = params.get("IsGlobal")
        self._MachineType = params.get("MachineType")
        self._Region = params.get("Region")
        self._Quuids = params.get("Quuids")
        self._CategoryIds = params.get("CategoryIds")
        self._IfScanned = params.get("IfScanned")
        self._RequestId = params.get("RequestId")


class DescribeBaselineStrategyListRequest(AbstractModel):
    """DescribeBaselineStrategyList request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Pagination parameters (The maximum number is 100.)
        :type Limit: int
        :param _Offset: Pagination parameter
        :type Offset: int
        :param _Enabled: Rule switch: 1 - on; 0 - off; 2: all
        :type Enabled: int
        """
        self._Limit = None
        self._Offset = None
        self._Enabled = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Enabled(self):
        return self._Enabled

    @Enabled.setter
    def Enabled(self, Enabled):
        self._Enabled = Enabled


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Enabled = params.get("Enabled")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselineStrategyListResponse(AbstractModel):
    """DescribeBaselineStrategyList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of pagination query records
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _StrategyList: User policy information list
Note: This field may return null, indicating that no valid values can be obtained.
        :type StrategyList: list of Strategy
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._StrategyList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def StrategyList(self):
        return self._StrategyList

    @StrategyList.setter
    def StrategyList(self, StrategyList):
        self._StrategyList = StrategyList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("StrategyList") is not None:
            self._StrategyList = []
            for item in params.get("StrategyList"):
                obj = Strategy()
                obj._deserialize(item)
                self._StrategyList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBaselineTopRequest(AbstractModel):
    """DescribeBaselineTop request structure.

    """

    def __init__(self):
        r"""
        :param _Top: Dynamic top value
        :type Top: int
        :param _StrategyId: Policy ID
        :type StrategyId: int
        """
        self._Top = None
        self._StrategyId = None

    @property
    def Top(self):
        return self._Top

    @Top.setter
    def Top(self, Top):
        self._Top = Top

    @property
    def StrategyId(self):
        return self._StrategyId

    @StrategyId.setter
    def StrategyId(self, StrategyId):
        self._StrategyId = StrategyId


    def _deserialize(self, params):
        self._Top = params.get("Top")
        self._StrategyId = params.get("StrategyId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselineTopResponse(AbstractModel):
    """DescribeBaselineTop response structure.

    """

    def __init__(self):
        r"""
        :param _RuleTopList: List of top check items
Note: This field may return null, indicating that no valid values can be obtained.
        :type RuleTopList: list of BaselineRuleTopInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RuleTopList = None
        self._RequestId = None

    @property
    def RuleTopList(self):
        return self._RuleTopList

    @RuleTopList.setter
    def RuleTopList(self, RuleTopList):
        self._RuleTopList = RuleTopList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RuleTopList") is not None:
            self._RuleTopList = []
            for item in params.get("RuleTopList"):
                obj = BaselineRuleTopInfo()
                obj._deserialize(item)
                self._RuleTopList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBaselineWeakPasswordListRequest(AbstractModel):
    """DescribeBaselineWeakPasswordList request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: <li>WeakPassword - string - required: no - weak password</li>
        :type Filters: list of Filter
        :param _Limit: Limit Entries, 10 by default, up to 100
        :type Limit: int
        :param _Offset: Offset, which is 0 by default.
        :type Offset: int
        :param _Order: Sorting order [ASC: ascending|DESC: descending]
        :type Order: str
        :param _By: Sorting column [CreateTime|ModifyTime]
        :type By: str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselineWeakPasswordListResponse(AbstractModel):
    """DescribeBaselineWeakPasswordList response structure.

    """

    def __init__(self):
        r"""
        :param _Total: Total number
        :type Total: int
        :param _List: None
        :type List: list of BaselineWeakPassword
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Total = None
        self._List = None
        self._RequestId = None

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = BaselineWeakPassword()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBashEventsInfoNewRequest(AbstractModel):
    """DescribeBashEventsInfoNew request structure.

    """

    def __init__(self):
        r"""
        :param _Id: Event ID
        :type Id: int
        """
        self._Id = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBashEventsInfoNewResponse(AbstractModel):
    """DescribeBashEventsInfoNew response structure.

    """

    def __init__(self):
        r"""
        :param _BashEventsInfo: Event details
Note: This field may return null, indicating that no valid values can be obtained.
        :type BashEventsInfo: :class:`tencentcloud.cwp.v20180228.models.BashEventsInfoNew`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._BashEventsInfo = None
        self._RequestId = None

    @property
    def BashEventsInfo(self):
        return self._BashEventsInfo

    @BashEventsInfo.setter
    def BashEventsInfo(self, BashEventsInfo):
        self._BashEventsInfo = BashEventsInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("BashEventsInfo") is not None:
            self._BashEventsInfo = BashEventsInfoNew()
            self._BashEventsInfo._deserialize(params.get("BashEventsInfo"))
        self._RequestId = params.get("RequestId")


class DescribeBashEventsInfoRequest(AbstractModel):
    """DescribeBashEventsInfo request structure.

    """

    def __init__(self):
        r"""
        :param _Id: Event ID
        :type Id: int
        """
        self._Id = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBashEventsInfoResponse(AbstractModel):
    """DescribeBashEventsInfo response structure.

    """

    def __init__(self):
        r"""
        :param _BashEventsInfo: Event details
Note: This field may return null, indicating that no valid values can be obtained.
        :type BashEventsInfo: :class:`tencentcloud.cwp.v20180228.models.BashEventsInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._BashEventsInfo = None
        self._RequestId = None

    @property
    def BashEventsInfo(self):
        return self._BashEventsInfo

    @BashEventsInfo.setter
    def BashEventsInfo(self, BashEventsInfo):
        self._BashEventsInfo = BashEventsInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("BashEventsInfo") is not None:
            self._BashEventsInfo = BashEventsInfo()
            self._BashEventsInfo._deserialize(params.get("BashEventsInfo"))
        self._RequestId = params.get("RequestId")


class DescribeBashEventsNewRequest(AbstractModel):
    """DescribeBashEventsNew request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Quantity of returns. It is 10 by default, and the maximum value is 100.
        :type Limit: int
        :param _Filters: Filter criteria
<li>HostName - String - required: no - host name</li>
<li>Hostip - String - required: no - host's private IP address</li>
<li>HostIp - String - required: no - host's private IP address</li>
<li>RuleCategory - Int - required: no - policy type (all types or a single type): 0: system; 1: user</li><li>RuleName - String - required: no - policy name</li>
<li>RuleLevel - Int - required: no - threat Level (multiple levels supported)</li>
<li>Status - Int - required: no - processing status (multiple statuses supported): 0: pending; 1: processed; 2: added to allowlist; 3: ignored; 4: deleted; 5: blocked</li>
<li>DetectBy - Int - required: no - data source (multiple sources supported): 0: bash logs; 1: real-time monitoring</li>
<li>StartTime - String - required: no - start time</li>
<li>EndTime - String - required: no - end time</li>
        :type Filters: list of Filter
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Order: Sorting method: sort by number of requests. asc: ascending; desc: descending.
        :type Order: str
        :param _By: Sorting field. CreateTime: occurrence time; ModifyTime: processing time.
        :type By: str
        """
        self._Limit = None
        self._Filters = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBashEventsNewResponse(AbstractModel):
    """DescribeBashEventsNew response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number
        :type TotalCount: int
        :param _List: High-risk command event list
        :type List: list of BashEventNew
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._List = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = BashEventNew()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBashEventsRequest(AbstractModel):
    """DescribeBashEvents request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of items to be returned. It is 10 by default, and the maximum value is 100.
        :type Limit: int
        :param _Filters: Filter criteria
<li>HostName - String - required: no - host name</li>
<li>Hostip - String - required: no - host's private IP address</li>
<li>RuleCategory - Int - required: no - policy type (all types or a single type): 0: system; 1: user</li>
<li>RuleName - String - required: no - policy name</li>
<li>RuleLevel - Int - required: no - threat Level (multiple levels supported)</li>
<li>Status - Int - required: no - processing status (multiple statuses supported): 0: pending; 1: processed; 2: added to allowlist; 3: ignored; 4: deleted; 5: blocked</li>
<li>DetectBy - Int - required: no - data source (multiple sources supported): 0: bash logs; 1: real-time monitoring</li>
<li>StartTime - String - required: no - start time</li>
<li>EndTime - String - required: no - end time</li>
        :type Filters: list of Filter
        :param _Offset: Offset, which defaults to 0
        :type Offset: int
        :param _Order: Sorting method: sort by number of requests. asc: ascending order; desc: descending order.
        :type Order: str
        :param _By: Sorting field. CreateTime: occurrence time; ModifyTime: processing time.
        :type By: str
        """
        self._Limit = None
        self._Filters = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBashEventsResponse(AbstractModel):
    """DescribeBashEvents response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of entries
        :type TotalCount: int
        :param _List: List of high-risk command events
        :type List: list of BashEvent
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._List = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = BashEvent()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBashPoliciesRequest(AbstractModel):
    """DescribeBashPolicies request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Quantity of returned entries. The maximum value is 100.
        :type Limit: int
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Filters: Filtering criteria
<li>Name - String - required: no - rule name</li>
<li>Rule - String - required: no - rule content</li>
<li>Level - Int - required: no - threat level</li>
<li>White - Int - required: no - allowlist type</li>
<li>Category - Int - required: no - policy type</li>
<li>BashAction - Int - required: no - action</li>
<li>Enable - Int - required: no - enabling status</li>
<li>Id - Int - required: no - policy ID</li>
<li>PolicyId - Int - required: no - policy ID</li>
<li>RuleId - Int - required: no - rule ID</li>
        :type Filters: list of Filter
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBashPoliciesResponse(AbstractModel):
    """DescribeBashPolicies response structure.

    """

    def __init__(self):
        r"""
        :param _List: List content
        :type List: list of BashPolicy
        :param _TotalCount: Total number of entries
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = BashPolicy()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeBashRulesRequest(AbstractModel):
    """DescribeBashRules request structure.

    """

    def __init__(self):
        r"""
        :param _Type: 0: system rule; 1: user rule.
        :type Type: int
        :param _Limit: Number of returned entries. Maximum value: 100.
        :type Limit: int
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Filters: Filter criteria
<li>Keywords - String - required: no - keyword (rule name)</li>
        :type Filters: list of Filter
        """
        self._Type = None
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBashRulesResponse(AbstractModel):
    """DescribeBashRules response structure.

    """

    def __init__(self):
        r"""
        :param _List: List content
        :type List: list of BashRule
        :param _TotalCount: Total number
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = BashRule()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeBruteAttackListRequest(AbstractModel):
    """DescribeBruteAttackList request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of items to be returned. The maximum value is 100.
        :type Limit: int
        :param _Offset: Offset, which defaults to 0
        :type Offset: int
        :param _Filters: Filter criteria
<li>IpOrAlias - String - required: no - filter by host IP or alias</li>
<li>Uuid - String - required: no - CWPP unique UUID</li>
<li>Quuid - String - required: no - CVM UUID</li>
<li>Status - String - required: no - filter by status: failed - FAILED; succeeded - SUCCESS</li>
<li>UserName - String - required: no - filter by UserName</li>
<li>SrcIp - String - required: no - filter by source IP</li>
<li>CreateBeginTime - String - required: no - filter by first attack time, start time</li>
<li>CreateEndTime - String - required: no - filter by first attack time, end time</li>
<li>ModifyBeginTime - String - required: no - filter by last attack time, start time</li>
<li>ModifyEndTime - String - required: no - filter by last attack time, end time</li>
<li>Banned - String - required: no - filter by blocking status (separate multiple items with commas): 0 - not blocked (global ZK switch is off); 82 - not blocked (Non-Pro Edition); 83 - not blocked (allowlisted); 1 - blocked; 2 - not blocked (abnormal program); 3 - not blocked (private network attacks cannot be blocked); 4 - not blocked (Anping is not supported)</li>
        :type Filters: list of Filter
        :param _Order: Sorting method: sort by number of requests: asc - ascending order/desc - descending order
        :type Order: str
        :param _By: Sorting field: CreateTime - first attack time
        :type By: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBruteAttackListResponse(AbstractModel):
    """DescribeBruteAttackList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _BruteAttackList: List of password cracking attacks
Note: This field may return null, indicating that no valid values can be obtained.
        :type BruteAttackList: list of BruteAttackInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._BruteAttackList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def BruteAttackList(self):
        return self._BruteAttackList

    @BruteAttackList.setter
    def BruteAttackList(self, BruteAttackList):
        self._BruteAttackList = BruteAttackList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("BruteAttackList") is not None:
            self._BruteAttackList = []
            for item in params.get("BruteAttackList"):
                obj = BruteAttackInfo()
                obj._deserialize(item)
                self._BruteAttackList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBruteAttackRulesRequest(AbstractModel):
    """DescribeBruteAttackRules request structure.

    """


class DescribeBruteAttackRulesResponse(AbstractModel):
    """DescribeBruteAttackRules response structure.

    """

    def __init__(self):
        r"""
        :param _Rules: List of rules for blocking brute force cracking
        :type Rules: list of BruteAttackRuleList
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Rules = None
        self._RequestId = None

    @property
    def Rules(self):
        return self._Rules

    @Rules.setter
    def Rules(self, Rules):
        self._Rules = Rules

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Rules") is not None:
            self._Rules = []
            for item in params.get("Rules"):
                obj = BruteAttackRuleList()
                obj._deserialize(item)
                self._Rules.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCanFixVulMachineRequest(AbstractModel):
    """DescribeCanFixVulMachine request structure.

    """

    def __init__(self):
        r"""
        :param _VulIds: Vulnerability IDs
        :type VulIds: list of int non-negative
        :param _Quuids: Hosts requiring fixing. This parameter has an AND relationship with VulIds.
        :type Quuids: list of str
        """
        self._VulIds = None
        self._Quuids = None

    @property
    def VulIds(self):
        return self._VulIds

    @VulIds.setter
    def VulIds(self, VulIds):
        self._VulIds = VulIds

    @property
    def Quuids(self):
        return self._Quuids

    @Quuids.setter
    def Quuids(self, Quuids):
        self._Quuids = Quuids


    def _deserialize(self, params):
        self._VulIds = params.get("VulIds")
        self._Quuids = params.get("Quuids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCanFixVulMachineResponse(AbstractModel):
    """DescribeCanFixVulMachine response structure.

    """

    def __init__(self):
        r"""
        :param _VulInfo: Host vulnerability fixing information list
Note: This field may return null, indicating that no valid values can be obtained.
        :type VulInfo: list of CanFixVulInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._VulInfo = None
        self._RequestId = None

    @property
    def VulInfo(self):
        return self._VulInfo

    @VulInfo.setter
    def VulInfo(self, VulInfo):
        self._VulInfo = VulInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("VulInfo") is not None:
            self._VulInfo = []
            for item in params.get("VulInfo"):
                obj = CanFixVulInfo()
                obj._deserialize(item)
                self._VulInfo.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCanNotSeparateMachineRequest(AbstractModel):
    """DescribeCanNotSeparateMachine request structure.

    """

    def __init__(self):
        r"""
        :param _Ids: An array of event IDs that need to be modified, and batch operation is supported.
        :type Ids: list of int non-negative
        :param _UpdateAll: Whether to update all, i.e. whether to operate on all events; this parameter is invalid when IDs are not left blank.
        :type UpdateAll: bool
        :param _ExcludeId: Excluded event ID: When operating on all events, this ID needs to be excluded.
        :type ExcludeId: list of int non-negative
        :param _Filters: <li>IpOrAlias - String - required: no - filter by host IP or alias</li>
<li>FilePath - String - required: no - filter by path</li>
<li>VirusName - String - required: no - filter by description</li>
<li>CreateBeginTime - String - required: no - filter by creation time - start time</li>
<li>CreateEndTime - String - required: no - filter by creation time - end time</li>
<li>Status - String - required: no - status for filtering: 4: pending; 5: trusted; 6: isolated; 10: isolating; 11: canceling isolation</li>
        :type Filters: list of Filters
        """
        self._Ids = None
        self._UpdateAll = None
        self._ExcludeId = None
        self._Filters = None

    @property
    def Ids(self):
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids

    @property
    def UpdateAll(self):
        return self._UpdateAll

    @UpdateAll.setter
    def UpdateAll(self, UpdateAll):
        self._UpdateAll = UpdateAll

    @property
    def ExcludeId(self):
        return self._ExcludeId

    @ExcludeId.setter
    def ExcludeId(self, ExcludeId):
        self._ExcludeId = ExcludeId

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Ids = params.get("Ids")
        self._UpdateAll = params.get("UpdateAll")
        self._ExcludeId = params.get("ExcludeId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCanNotSeparateMachineResponse(AbstractModel):
    """DescribeCanNotSeparateMachine response structure.

    """

    def __init__(self):
        r"""
        :param _List: List of non-isolatable hosts
        :type List: list of CanNotSeparateInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = CanNotSeparateInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeClientExceptionRequest(AbstractModel):
    """DescribeClientException request structure.

    """

    def __init__(self):
        r"""
        :param _ExceptionType: Client Exception Type 1: Client Offline, 2: Client Uninstallation
        :type ExceptionType: int
        :param _Offset: Pagination offset
        :type Offset: int
        :param _Limit: Limit per Page, not 0, up to 100
        :type Limit: int
        :param _StartTime: Start time in the format of `2006-01-02 15:04:05`
        :type StartTime: str
        :param _EndTime: End time in the format of `2006-01-02 15:04:05`
        :type EndTime: str
        """
        self._ExceptionType = None
        self._Offset = None
        self._Limit = None
        self._StartTime = None
        self._EndTime = None

    @property
    def ExceptionType(self):
        return self._ExceptionType

    @ExceptionType.setter
    def ExceptionType(self, ExceptionType):
        self._ExceptionType = ExceptionType

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._ExceptionType = params.get("ExceptionType")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClientExceptionResponse(AbstractModel):
    """DescribeClientException response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of events
        :type TotalCount: int
        :param _Records: Event details
        :type Records: list of RecordInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Records = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Records(self):
        return self._Records

    @Records.setter
    def Records(self, Records):
        self._Records = Records

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Records") is not None:
            self._Records = []
            for item in params.get("Records"):
                obj = RecordInfo()
                obj._deserialize(item)
                self._Records.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCloudProtectServiceOrderListRequest(AbstractModel):
    """DescribeCloudProtectServiceOrderList request structure.

    """

    def __init__(self):
        r"""
        :param _Order: Sorting field, which currently supports BeginTime
        :type Order: str
        :param _By: Sorting method, which currently supports:
ASC for ascending order; DESC for descending order
        :type By: str
        """
        self._Order = None
        self._By = None

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCloudProtectServiceOrderListResponse(AbstractModel):
    """DescribeCloudProtectServiceOrderList response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Cloud escort order list
        :type Data: list of CloudProtectService
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = CloudProtectService()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeComponentStatisticsRequest(AbstractModel):
    """DescribeComponentStatistics request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Quantity of returns. It is 10 by default, and the maximum value is 100.
        :type Limit: int
        :param _Offset: Offset, which defaults to 0
        :type Offset: int
        :param _Filters: Filter criteria
ComponentName - String - required: no - component name
        :type Filters: list of Filter
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeComponentStatisticsResponse(AbstractModel):
    """DescribeComponentStatistics response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of records in the component statistics list
        :type TotalCount: int
        :param _ComponentStatistics: Array of list of counted components
        :type ComponentStatistics: list of ComponentStatistics
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._ComponentStatistics = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ComponentStatistics(self):
        return self._ComponentStatistics

    @ComponentStatistics.setter
    def ComponentStatistics(self, ComponentStatistics):
        self._ComponentStatistics = ComponentStatistics

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ComponentStatistics") is not None:
            self._ComponentStatistics = []
            for item in params.get("ComponentStatistics"):
                obj = ComponentStatistics()
                obj._deserialize(item)
                self._ComponentStatistics.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDefenceEventDetailRequest(AbstractModel):
    """DescribeDefenceEventDetail request structure.

    """

    def __init__(self):
        r"""
        :param _Id: Vulnerability Event ID
        :type Id: int
        """
        self._Id = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDefenceEventDetailResponse(AbstractModel):
    """DescribeDefenceEventDetail response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Vulnerability event details
        :type Data: :class:`tencentcloud.cwp.v20180228.models.VulDefenceEventDetail`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = VulDefenceEventDetail()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeDirectConnectInstallCommandRequest(AbstractModel):
    """DescribeDirectConnectInstallCommand request structure.

    """

    def __init__(self):
        r"""
        :param _RegionCode: Region identifier
        :type RegionCode: str
        :param _VpcId: VPC ID
        :type VpcId: str
        :param _ExpireDate: Command expiration time
        :type ExpireDate: str
        """
        self._RegionCode = None
        self._VpcId = None
        self._ExpireDate = None

    @property
    def RegionCode(self):
        return self._RegionCode

    @RegionCode.setter
    def RegionCode(self, RegionCode):
        self._RegionCode = RegionCode

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def ExpireDate(self):
        return self._ExpireDate

    @ExpireDate.setter
    def ExpireDate(self, ExpireDate):
        self._ExpireDate = ExpireDate


    def _deserialize(self, params):
        self._RegionCode = params.get("RegionCode")
        self._VpcId = params.get("VpcId")
        self._ExpireDate = params.get("ExpireDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDirectConnectInstallCommandResponse(AbstractModel):
    """DescribeDirectConnectInstallCommand response structure.

    """

    def __init__(self):
        r"""
        :param _Ip: IP address for the installation command
        :type Ip: str
        :param _Token: Token for the installation command
        :type Token: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Ip = None
        self._Token = None
        self._RequestId = None

    @property
    def Ip(self):
        return self._Ip

    @Ip.setter
    def Ip(self, Ip):
        self._Ip = Ip

    @property
    def Token(self):
        return self._Token

    @Token.setter
    def Token(self, Token):
        self._Token = Token

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Ip = params.get("Ip")
        self._Token = params.get("Token")
        self._RequestId = params.get("RequestId")


class DescribeESAggregationsRequest(AbstractModel):
    """DescribeESAggregations request structure.

    """

    def __init__(self):
        r"""
        :param _Query: ES aggregation conditional JSON
        :type Query: str
        """
        self._Query = None

    @property
    def Query(self):
        return self._Query

    @Query.setter
    def Query(self, Query):
        self._Query = Query


    def _deserialize(self, params):
        self._Query = params.get("Query")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeESAggregationsResponse(AbstractModel):
    """DescribeESAggregations response structure.

    """

    def __init__(self):
        r"""
        :param _Data: ES aggregation result JSON
        :type Data: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DescribeEmergencyResponseListRequest(AbstractModel):
    """DescribeEmergencyResponseList request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filter criteria
<li>Keyword - String - whether required: no - filter by keyword</li>
<li>Uuids - String - whether required: no - filter by host ID</li>
        :type Filters: list of Filters
        :param _Limit: Number of items to be returned. The maximum value is 100.
        :type Limit: int
        :param _Offset: Sorting step size
        :type Offset: int
        :param _Order: Sort method
        :type Order: str
        :param _By: Sorting field: StartTime, EndTime
        :type By: str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEmergencyResponseListResponse(AbstractModel):
    """DescribeEmergencyResponseList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of entries
        :type TotalCount: int
        :param _List: Emergency Response List
        :type List: list of EmergencyResponseInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._List = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = EmergencyResponseInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeEmergencyVulListRequest(AbstractModel):
    """DescribeEmergencyVulList request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Quantity of returns. The maximum value is 100.
        :type Limit: int
        :param _Offset: Offset, which defaults to 0
        :type Offset: int
        :param _Filters: Filter criteria
<li>Status - String - required: Yes - vulnerability status filter: 0: not detected; 1: at risk; 2: no risk; 3: show progress while detecting</li>
<li>Level - String - required: no - filter by vulnerability level: 1 - low; 2 - medium; 3 - high; 4 - prompt</li>
<li>VulName - String - required: no - vulnerability name search</li>
<li>Uuids- String - required: no - host uuid</li>
<li>IsSupportDefense - int- required: no - whether to support defense: 0: no; 1: yes</li>
        :type Filters: list of Filters
        :param _Order: Sorting method: desc and asc
        :type Order: str
        :param _By: Sorting field PublishDate  LastScanTime HostCount
        :type By: str
        :param _HotspotAttack: Whether hot spot vulnerabilities
        :type HotspotAttack: bool
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None
        self._HotspotAttack = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def HotspotAttack(self):
        return self._HotspotAttack

    @HotspotAttack.setter
    def HotspotAttack(self, HotspotAttack):
        self._HotspotAttack = HotspotAttack


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        self._HotspotAttack = params.get("HotspotAttack")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEmergencyVulListResponse(AbstractModel):
    """DescribeEmergencyVulList response structure.

    """

    def __init__(self):
        r"""
        :param _List: Vulnerability list
Note: This field may return null, indicating that no valid values can be obtained.
        :type List: list of EmergencyVul
        :param _TotalCount: Total number of vulnerabilities
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _ExistsRisk: Whether there is any risk
Note: This field may return null, indicating that no valid values can be obtained.
        :type ExistsRisk: bool
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._ExistsRisk = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ExistsRisk(self):
        return self._ExistsRisk

    @ExistsRisk.setter
    def ExistsRisk(self, ExistsRisk):
        self._ExistsRisk = ExistsRisk

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = EmergencyVul()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._ExistsRisk = params.get("ExistsRisk")
        self._RequestId = params.get("RequestId")


class DescribeEventByTableRequest(AbstractModel):
    """DescribeEventByTable request structure.

    """

    def __init__(self):
        r"""
        :param _TableName: Event table name
        :type TableName: str
        :param _Ids: Event table ID
        :type Ids: list of int
        """
        self._TableName = None
        self._Ids = None

    @property
    def TableName(self):
        return self._TableName

    @TableName.setter
    def TableName(self, TableName):
        self._TableName = TableName

    @property
    def Ids(self):
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids


    def _deserialize(self, params):
        self._TableName = params.get("TableName")
        self._Ids = params.get("Ids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEventByTableResponse(AbstractModel):
    """DescribeEventByTable response structure.

    """

    def __init__(self):
        r"""
        :param _Type: Alarm type. Bruteattack: brute force cracking; bash: high-risk command; malware: malicious file; risk_dns: malicious request; privilege_escalation: local privilege escalation; reverse_shell: reverse shell; java_shell: Java webshell.
        :type Type: str
        :param _Value: JSON string of the event content. The field structure is the same as that of the event table.
        :type Value: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Type = None
        self._Value = None
        self._RequestId = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Value(self):
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Value = params.get("Value")
        self._RequestId = params.get("RequestId")


class DescribeExpertServiceListRequest(AbstractModel):
    """DescribeExpertServiceList request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filter criteria
<li>Keyword - String - whether required: no - filter by keyword</li>
<li>Uuids - String - whether required: no - filter by host ID</li>
        :type Filters: list of Filters
        :param _Limit: Number of items to be returned. The maximum value is 100.
        :type Limit: int
        :param _Offset: Sorting step size
        :type Offset: int
        :param _Order: Sort method
        :type Order: str
        :param _By: Sorting field: StartTime, EndTime
        :type By: str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeExpertServiceListResponse(AbstractModel):
    """DescribeExpertServiceList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of entries
        :type TotalCount: int
        :param _List: Security manager data
        :type List: list of SecurityButlerInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._List = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = SecurityButlerInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeExpertServiceOrderListRequest(AbstractModel):
    """DescribeExpertServiceOrderList request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: <li>InquireType- String - required: no - order type for filtering,</li>
        :type Filters: list of Filters
        :param _Limit: Number of entries on each page. Maximum value: 100.
        :type Limit: int
        :param _Offset: Offset
        :type Offset: int
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeExpertServiceOrderListResponse(AbstractModel):
    """DescribeExpertServiceOrderList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of entries
        :type TotalCount: int
        :param _List: Order list
        :type List: list of ExpertServiceOrderInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._List = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ExpertServiceOrderInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeExportMachinesRequest(AbstractModel):
    """DescribeExportMachines request structure.

    """

    def __init__(self):
        r"""
        :param _MachineType: CVM type
<li>CVM: Represent a virtual machine</li>
<li>BM: Represent a physical machine</li>
        :type MachineType: str
        :param _MachineRegion: Machine region. Example: ap-guangzhou, ap-shanghai
        :type MachineRegion: str
        :param _Limit: Quantity of returns. It is 10 by default, and the maximum value is 100.
        :type Limit: int
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Filters: Filter criteria
<li>Keywords - String - required: no - keyword for query </li>
<li>Status - String - required: no - client online status (OFFLINE: offline | ONLINE: online | UNINSTALLED: not installed)</li>
<li>Version - String - required: no - current protection version (PRO_VERSION: Pro Edition | BASIC_VERSION: Basic Edition)</li>
Only one value is allowed for each filter criterion. Multiple values with the OR relationship are not supported for queries.
        :type Filters: list of Filter
        :param _ProjectIds: ID List of Businesses to which machines belong
        :type ProjectIds: list of int non-negative
        """
        self._MachineType = None
        self._MachineRegion = None
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._ProjectIds = None

    @property
    def MachineType(self):
        return self._MachineType

    @MachineType.setter
    def MachineType(self, MachineType):
        self._MachineType = MachineType

    @property
    def MachineRegion(self):
        return self._MachineRegion

    @MachineRegion.setter
    def MachineRegion(self, MachineRegion):
        self._MachineRegion = MachineRegion

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def ProjectIds(self):
        return self._ProjectIds

    @ProjectIds.setter
    def ProjectIds(self, ProjectIds):
        self._ProjectIds = ProjectIds


    def _deserialize(self, params):
        self._MachineType = params.get("MachineType")
        self._MachineRegion = params.get("MachineRegion")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._ProjectIds = params.get("ProjectIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeExportMachinesResponse(AbstractModel):
    """DescribeExportMachines response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID, required for obtaining the DownloadURL at API Asynchronous Export Task ExportTasks
        :type TaskId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class DescribeFastAnalysisRequest(AbstractModel):
    """DescribeFastAnalysis request structure.

    """

    def __init__(self):
        r"""
        :param _From: Start time. Unit: ms.
        :type From: int
        :param _To: End time. Unit: ms.
        :type To: int
        :param _Query: Query statement, up to 4096 in statement length
        :type Query: str
        :param _FieldName: Log field name
        :type FieldName: str
        """
        self._From = None
        self._To = None
        self._Query = None
        self._FieldName = None

    @property
    def From(self):
        return self._From

    @From.setter
    def From(self, From):
        self._From = From

    @property
    def To(self):
        return self._To

    @To.setter
    def To(self, To):
        self._To = To

    @property
    def Query(self):
        return self._Query

    @Query.setter
    def Query(self, Query):
        self._Query = Query

    @property
    def FieldName(self):
        return self._FieldName

    @FieldName.setter
    def FieldName(self, FieldName):
        self._FieldName = FieldName


    def _deserialize(self, params):
        self._From = params.get("From")
        self._To = params.get("To")
        self._Query = params.get("Query")
        self._FieldName = params.get("FieldName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFastAnalysisResponse(AbstractModel):
    """DescribeFastAnalysis response structure.

    """

    def __init__(self):
        r"""
        :param _FieldValueRatioInfos: Statistical data after analysis
Note: This field may return null, indicating that no valid values can be obtained.
        :type FieldValueRatioInfos: list of FieldValueRatioInfo
        :param _TotalCount: Total number
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FieldValueRatioInfos = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def FieldValueRatioInfos(self):
        return self._FieldValueRatioInfos

    @FieldValueRatioInfos.setter
    def FieldValueRatioInfos(self, FieldValueRatioInfos):
        self._FieldValueRatioInfos = FieldValueRatioInfos

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("FieldValueRatioInfos") is not None:
            self._FieldValueRatioInfos = []
            for item in params.get("FieldValueRatioInfos"):
                obj = FieldValueRatioInfo()
                obj._deserialize(item)
                self._FieldValueRatioInfos.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeFileTamperEventRuleInfoRequest(AbstractModel):
    """DescribeFileTamperEventRuleInfo request structure.

    """

    def __init__(self):
        r"""
        :param _Id: Event ID
        :type Id: int
        :param _Limit: Number of returned UUIDs per page
        :type Limit: int
        :param _Offset: Offset
        :type Offset: int
        """
        self._Id = None
        self._Limit = None
        self._Offset = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFileTamperEventRuleInfoResponse(AbstractModel):
    """DescribeFileTamperEventRuleInfo response structure.

    """

    def __init__(self):
        r"""
        :param _FileTamperRuleDetail: Rule details
        :type FileTamperRuleDetail: :class:`tencentcloud.cwp.v20180228.models.FileTamperRuleDetail`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FileTamperRuleDetail = None
        self._RequestId = None

    @property
    def FileTamperRuleDetail(self):
        return self._FileTamperRuleDetail

    @FileTamperRuleDetail.setter
    def FileTamperRuleDetail(self, FileTamperRuleDetail):
        self._FileTamperRuleDetail = FileTamperRuleDetail

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("FileTamperRuleDetail") is not None:
            self._FileTamperRuleDetail = FileTamperRuleDetail()
            self._FileTamperRuleDetail._deserialize(params.get("FileTamperRuleDetail"))
        self._RequestId = params.get("RequestId")


class DescribeFileTamperEventsRequest(AbstractModel):
    """DescribeFileTamperEvents request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filter criteria
<li>Status - String - required: no - processing status: 0: pending; 1: allowlisted; 2: deleted; 3: ignored</li>
<li>ModifyTime - String - required: no - last occurrence time</li>
<li>Uuid- String - required: no - query by host UUID</li>
<li>RuleCategory - string - required: no - rule category. 0: system rule; 1: custom rule</li>
<li>FileAction - string - required: no - threat behavior: read - read file; write - write file</li>
        :type Filters: list of Filters
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of items to be returned. It is 10 by default, and the maximum value is 100.
        :type Limit: int
        :param _Order: Sorting method: ASC, DESC
        :type Order: str
        :param _By: Sorting field: CreateTime; ModifyTime
        :type By: str
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFileTamperEventsResponse(AbstractModel):
    """DescribeFileTamperEvents response structure.

    """

    def __init__(self):
        r"""
        :param _List: Core File Event List
Note: This field may return null, indicating that no valid values can be obtained.
        :type List: list of FileTamperEvent
        :param _TotalCount: Total number of data entries
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = FileTamperEvent()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeFileTamperRuleCountRequest(AbstractModel):
    """DescribeFileTamperRuleCount request structure.

    """

    def __init__(self):
        r"""
        :param _Uuids: Query Host UUIDs, up to 100 queries at a time
        :type Uuids: list of str
        """
        self._Uuids = None

    @property
    def Uuids(self):
        return self._Uuids

    @Uuids.setter
    def Uuids(self, Uuids):
        self._Uuids = Uuids


    def _deserialize(self, params):
        self._Uuids = params.get("Uuids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFileTamperRuleCountResponse(AbstractModel):
    """DescribeFileTamperRuleCount response structure.

    """

    def __init__(self):
        r"""
        :param _List: Information on Number of Host-associated Core File Rules
Note: This field may return null, indicating that no valid values can be obtained.
        :type List: list of FileTamperRuleCount
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = FileTamperRuleCount()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeFileTamperRuleInfoRequest(AbstractModel):
    """DescribeFileTamperRuleInfo request structure.

    """

    def __init__(self):
        r"""
        :param _Id: Rule ID
        :type Id: int
        :param _Limit: Control the number of UUIDs returned
        :type Limit: int
        :param _Offset: Control the number of UUIDs returned, starting position
        :type Offset: int
        """
        self._Id = None
        self._Limit = None
        self._Offset = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFileTamperRuleInfoResponse(AbstractModel):
    """DescribeFileTamperRuleInfo response structure.

    """

    def __init__(self):
        r"""
        :param _FileTamperRuleDetail: Rule details
        :type FileTamperRuleDetail: :class:`tencentcloud.cwp.v20180228.models.FileTamperRuleDetail`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FileTamperRuleDetail = None
        self._RequestId = None

    @property
    def FileTamperRuleDetail(self):
        return self._FileTamperRuleDetail

    @FileTamperRuleDetail.setter
    def FileTamperRuleDetail(self, FileTamperRuleDetail):
        self._FileTamperRuleDetail = FileTamperRuleDetail

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("FileTamperRuleDetail") is not None:
            self._FileTamperRuleDetail = FileTamperRuleDetail()
            self._FileTamperRuleDetail._deserialize(params.get("FileTamperRuleDetail"))
        self._RequestId = params.get("RequestId")


class DescribeFileTamperRulesRequest(AbstractModel):
    """DescribeFileTamperRules request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filtering criteria
<li>RuleCategory - string - rule category: 0: system rule; 1: user rule</li><li>Name - String - rule name</li>
        :type Filters: list of Filters
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of entries to be returned. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param _Order: Sorting order: ASC, DESC
        :type Order: str
        :param _By: Sorting field: CreateTime, ModifyTime, HostCount
        :type By: str
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFileTamperRulesResponse(AbstractModel):
    """DescribeFileTamperRules response structure.

    """

    def __init__(self):
        r"""
        :param _List: List of rules
Note: This field may return null, indicating that no valid values can be obtained.
        :type List: list of FileTamperRuleInfo
        :param _TotalCount: Total number
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = FileTamperRuleInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeGeneralStatRequest(AbstractModel):
    """DescribeGeneralStat request structure.

    """

    def __init__(self):
        r"""
        :param _MachineType: CVM type
<li>CVM: Indicates Tencent CVM.</li>
<li>BM: indicates Blackstone physical machine</li>
<li>ECM: indicates edge computing server</li>
<li>LH: indicates Tencent Cloud Lighthouse</li>
<li>Other: Indicates Hybrid cloud machines.</li>
        :type MachineType: str
        :param _MachineRegion: Machine region. Example: ap-guangzhou, ap-shanghai
        :type MachineRegion: str
        """
        self._MachineType = None
        self._MachineRegion = None

    @property
    def MachineType(self):
        return self._MachineType

    @MachineType.setter
    def MachineType(self, MachineType):
        self._MachineType = MachineType

    @property
    def MachineRegion(self):
        return self._MachineRegion

    @MachineRegion.setter
    def MachineRegion(self, MachineRegion):
        self._MachineRegion = MachineRegion


    def _deserialize(self, params):
        self._MachineType = params.get("MachineType")
        self._MachineRegion = params.get("MachineRegion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeGeneralStatResponse(AbstractModel):
    """DescribeGeneralStat response structure.

    """

    def __init__(self):
        r"""
        :param _MachinesAll: Total number of hosts
        :type MachinesAll: int
        :param _MachinesUninstalled: Total number of hosts not installed with the CWPP client
        :type MachinesUninstalled: int
        :param _AgentsAll: Total number of CWPP clients
        :type AgentsAll: int
        :param _AgentsOnline: Total number of online CWPP clients
        :type AgentsOnline: int
        :param _AgentsOffline: Total number of CWPP clients that are offline and shut down
        :type AgentsOffline: int
        :param _AgentsPro: Total number of Pro Edition CWPP clients
        :type AgentsPro: int
        :param _AgentsBasic: Total number of Basic Edition CWPP clients
        :type AgentsBasic: int
        :param _AgentsProExpireWithInSevenDays: Total number of prepaid Pro Edition CWPP clients that will expire in 7 days
        :type AgentsProExpireWithInSevenDays: int
        :param _RiskMachine: Total number of risky hosts
        :type RiskMachine: int
        :param _Shutdown: Total number of hosts that are shut down
        :type Shutdown: int
        :param _Offline: Total number of offline hosts
        :type Offline: int
        :param _FlagshipMachineCnt: Number of Ultimate Edition hosts
Note: This field may return null, indicating that no valid values can be obtained.
        :type FlagshipMachineCnt: int
        :param _ProtectDays: Protection duration, in days
Note: This field may return null, indicating that no valid values can be obtained.
        :type ProtectDays: int
        :param _AddedOnTheFifteen: Number of hosts added in the last 15 days
Note: This field may return null, indicating that no valid values can be obtained.
        :type AddedOnTheFifteen: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._MachinesAll = None
        self._MachinesUninstalled = None
        self._AgentsAll = None
        self._AgentsOnline = None
        self._AgentsOffline = None
        self._AgentsPro = None
        self._AgentsBasic = None
        self._AgentsProExpireWithInSevenDays = None
        self._RiskMachine = None
        self._Shutdown = None
        self._Offline = None
        self._FlagshipMachineCnt = None
        self._ProtectDays = None
        self._AddedOnTheFifteen = None
        self._RequestId = None

    @property
    def MachinesAll(self):
        return self._MachinesAll

    @MachinesAll.setter
    def MachinesAll(self, MachinesAll):
        self._MachinesAll = MachinesAll

    @property
    def MachinesUninstalled(self):
        return self._MachinesUninstalled

    @MachinesUninstalled.setter
    def MachinesUninstalled(self, MachinesUninstalled):
        self._MachinesUninstalled = MachinesUninstalled

    @property
    def AgentsAll(self):
        return self._AgentsAll

    @AgentsAll.setter
    def AgentsAll(self, AgentsAll):
        self._AgentsAll = AgentsAll

    @property
    def AgentsOnline(self):
        return self._AgentsOnline

    @AgentsOnline.setter
    def AgentsOnline(self, AgentsOnline):
        self._AgentsOnline = AgentsOnline

    @property
    def AgentsOffline(self):
        return self._AgentsOffline

    @AgentsOffline.setter
    def AgentsOffline(self, AgentsOffline):
        self._AgentsOffline = AgentsOffline

    @property
    def AgentsPro(self):
        return self._AgentsPro

    @AgentsPro.setter
    def AgentsPro(self, AgentsPro):
        self._AgentsPro = AgentsPro

    @property
    def AgentsBasic(self):
        return self._AgentsBasic

    @AgentsBasic.setter
    def AgentsBasic(self, AgentsBasic):
        self._AgentsBasic = AgentsBasic

    @property
    def AgentsProExpireWithInSevenDays(self):
        return self._AgentsProExpireWithInSevenDays

    @AgentsProExpireWithInSevenDays.setter
    def AgentsProExpireWithInSevenDays(self, AgentsProExpireWithInSevenDays):
        self._AgentsProExpireWithInSevenDays = AgentsProExpireWithInSevenDays

    @property
    def RiskMachine(self):
        return self._RiskMachine

    @RiskMachine.setter
    def RiskMachine(self, RiskMachine):
        self._RiskMachine = RiskMachine

    @property
    def Shutdown(self):
        return self._Shutdown

    @Shutdown.setter
    def Shutdown(self, Shutdown):
        self._Shutdown = Shutdown

    @property
    def Offline(self):
        return self._Offline

    @Offline.setter
    def Offline(self, Offline):
        self._Offline = Offline

    @property
    def FlagshipMachineCnt(self):
        return self._FlagshipMachineCnt

    @FlagshipMachineCnt.setter
    def FlagshipMachineCnt(self, FlagshipMachineCnt):
        self._FlagshipMachineCnt = FlagshipMachineCnt

    @property
    def ProtectDays(self):
        return self._ProtectDays

    @ProtectDays.setter
    def ProtectDays(self, ProtectDays):
        self._ProtectDays = ProtectDays

    @property
    def AddedOnTheFifteen(self):
        return self._AddedOnTheFifteen

    @AddedOnTheFifteen.setter
    def AddedOnTheFifteen(self, AddedOnTheFifteen):
        self._AddedOnTheFifteen = AddedOnTheFifteen

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._MachinesAll = params.get("MachinesAll")
        self._MachinesUninstalled = params.get("MachinesUninstalled")
        self._AgentsAll = params.get("AgentsAll")
        self._AgentsOnline = params.get("AgentsOnline")
        self._AgentsOffline = params.get("AgentsOffline")
        self._AgentsPro = params.get("AgentsPro")
        self._AgentsBasic = params.get("AgentsBasic")
        self._AgentsProExpireWithInSevenDays = params.get("AgentsProExpireWithInSevenDays")
        self._RiskMachine = params.get("RiskMachine")
        self._Shutdown = params.get("Shutdown")
        self._Offline = params.get("Offline")
        self._FlagshipMachineCnt = params.get("FlagshipMachineCnt")
        self._ProtectDays = params.get("ProtectDays")
        self._AddedOnTheFifteen = params.get("AddedOnTheFifteen")
        self._RequestId = params.get("RequestId")


class DescribeHistoryAccountsRequest(AbstractModel):
    """DescribeHistoryAccounts request structure.

    """

    def __init__(self):
        r"""
        :param _Uuid: Yunjing client UUID
        :type Uuid: str
        :param _Limit: Number of returns. It is 10 by default, and the maximum value is 100.
        :type Limit: int
        :param _Offset: Quantity of returns. It is 10 by default, and the maximum value is 100.
        :type Offset: int
        :param _Filters: Filter criteria
<li>Username - String - required: no - username</li>
        :type Filters: list of Filter
        """
        self._Uuid = None
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Uuid = params.get("Uuid")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeHistoryAccountsResponse(AbstractModel):
    """DescribeHistoryAccounts response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of records in the history account list
        :type TotalCount: int
        :param _HistoryAccounts: Array of history accounts
        :type HistoryAccounts: list of HistoryAccount
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._HistoryAccounts = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def HistoryAccounts(self):
        return self._HistoryAccounts

    @HistoryAccounts.setter
    def HistoryAccounts(self, HistoryAccounts):
        self._HistoryAccounts = HistoryAccounts

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("HistoryAccounts") is not None:
            self._HistoryAccounts = []
            for item in params.get("HistoryAccounts"):
                obj = HistoryAccount()
                obj._deserialize(item)
                self._HistoryAccounts.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeHistoryServiceRequest(AbstractModel):
    """DescribeHistoryService request structure.

    """


class DescribeHistoryServiceResponse(AbstractModel):
    """DescribeHistoryService response structure.

    """

    def __init__(self):
        r"""
        :param _BuyStatus: 1: available for purchase; 2: specification adjustment only; 3: redirection to renewal management page only.
        :type BuyStatus: int
        :param _InquireNum: Capacity purchased by the user, in GB
        :type InquireNum: int
        :param _EndTime: Expiration time
        :type EndTime: str
        :param _IsAutoOpenRenew: Whether automatic renewal is enabled. 0: initial value; 1: enabled; 2: disabled.
        :type IsAutoOpenRenew: int
        :param _ResourceId: Resource ID
        :type ResourceId: str
        :param _Status: 0: not activated; 1: normal; 2: isolated; 3: terminated.
        :type Status: int
        :param _StartTime: Start time
        :type StartTime: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._BuyStatus = None
        self._InquireNum = None
        self._EndTime = None
        self._IsAutoOpenRenew = None
        self._ResourceId = None
        self._Status = None
        self._StartTime = None
        self._RequestId = None

    @property
    def BuyStatus(self):
        return self._BuyStatus

    @BuyStatus.setter
    def BuyStatus(self, BuyStatus):
        self._BuyStatus = BuyStatus

    @property
    def InquireNum(self):
        return self._InquireNum

    @InquireNum.setter
    def InquireNum(self, InquireNum):
        self._InquireNum = InquireNum

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def IsAutoOpenRenew(self):
        return self._IsAutoOpenRenew

    @IsAutoOpenRenew.setter
    def IsAutoOpenRenew(self, IsAutoOpenRenew):
        self._IsAutoOpenRenew = IsAutoOpenRenew

    @property
    def ResourceId(self):
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._BuyStatus = params.get("BuyStatus")
        self._InquireNum = params.get("InquireNum")
        self._EndTime = params.get("EndTime")
        self._IsAutoOpenRenew = params.get("IsAutoOpenRenew")
        self._ResourceId = params.get("ResourceId")
        self._Status = params.get("Status")
        self._StartTime = params.get("StartTime")
        self._RequestId = params.get("RequestId")


class DescribeHostInfoRequest(AbstractModel):
    """DescribeHostInfo request structure.

    """

    def __init__(self):
        r"""
        :param _QuuidList: Host QUUID array
        :type QuuidList: list of str
        :param _Uuids: UUIDs for querying. Leave this parameter blank if QUUIDs are used for querying.
        :type Uuids: list of str
        """
        self._QuuidList = None
        self._Uuids = None

    @property
    def QuuidList(self):
        return self._QuuidList

    @QuuidList.setter
    def QuuidList(self, QuuidList):
        self._QuuidList = QuuidList

    @property
    def Uuids(self):
        return self._Uuids

    @Uuids.setter
    def Uuids(self, Uuids):
        self._Uuids = Uuids


    def _deserialize(self, params):
        self._QuuidList = params.get("QuuidList")
        self._Uuids = params.get("Uuids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeHostInfoResponse(AbstractModel):
    """DescribeHostInfo response structure.

    """

    def __init__(self):
        r"""
        :param _HostInfoList: Host and tag information
Note: This field may return null, indicating that no valid values can be obtained.
        :type HostInfoList: list of HostTagInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._HostInfoList = None
        self._RequestId = None

    @property
    def HostInfoList(self):
        return self._HostInfoList

    @HostInfoList.setter
    def HostInfoList(self, HostInfoList):
        self._HostInfoList = HostInfoList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("HostInfoList") is not None:
            self._HostInfoList = []
            for item in params.get("HostInfoList"):
                obj = HostTagInfo()
                obj._deserialize(item)
                self._HostInfoList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeHostLoginListRequest(AbstractModel):
    """DescribeHostLoginList request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of items to be returned. The maximum value is 100.
        :type Limit: int
        :param _Offset: Offset, which defaults to 0
        :type Offset: int
        :param _Filters: Filter criteria
<li>Quuid - String - required: no - CVM UUID</li>
<li>Uuid - String - required: no - CWPP unique UUID</li>
<li>MachineName - String - required: no - host alias</li>
<li>Ip - String - required: no - host IP</li>
<li>InstanceID - String - required: no - host instance ID</li>
<li>SrcIp - String - required: no - filter by source IP</li>
<li>UserName - String - required: no - filter by username</li>
<li>Status - int - required: no - status filtering: 1: normal log-in; 5: whitelisted; 14: processed; 15: ignored</li>
<li>LoginTimeBegin - String - required: no - filter by modification time; start time</li>
<li>LoginTimeEnd - String - required: no - filter by modification time; end time</li>
<li>RiskLevel - int - required: no - status filtering: 0: high-risk; 1: suspicious</li>
        :type Filters: list of Filter
        :param _Order: Sorting method: sort by number of requests: asc - ascending order/desc - descending order
        :type Order: str
        :param _By: Sorting field: LoginTime - occurrence time
        :type By: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeHostLoginListResponse(AbstractModel):
    """DescribeHostLoginList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number
        :type TotalCount: int
        :param _HostLoginList: Log-in an audit list
Note: This field may return null, indicating that no valid values can be obtained.
        :type HostLoginList: list of HostLoginList
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._HostLoginList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def HostLoginList(self):
        return self._HostLoginList

    @HostLoginList.setter
    def HostLoginList(self, HostLoginList):
        self._HostLoginList = HostLoginList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("HostLoginList") is not None:
            self._HostLoginList = []
            for item in params.get("HostLoginList"):
                obj = HostLoginList()
                obj._deserialize(item)
                self._HostLoginList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeHotVulTopRequest(AbstractModel):
    """DescribeHotVulTop request structure.

    """


class DescribeHotVulTopResponse(AbstractModel):
    """DescribeHotVulTop response structure.

    """

    def __init__(self):
        r"""
        :param _List: Vulnerability information
Note: This field may return null, indicating that no valid values can be obtained.
        :type List: list of VulStoreListInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = VulStoreListInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeIgnoreBaselineRuleRequest(AbstractModel):
    """DescribeIgnoreBaselineRule request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Pagination parameters (The maximum quantity is 100)
        :type Limit: int
        :param _Offset: Pagination parameter
        :type Offset: int
        :param _RuleName: Detection item name
        :type RuleName: str
        """
        self._Limit = None
        self._Offset = None
        self._RuleName = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def RuleName(self):
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._RuleName = params.get("RuleName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIgnoreBaselineRuleResponse(AbstractModel):
    """DescribeIgnoreBaselineRule response structure.

    """

    def __init__(self):
        r"""
        :param _IgnoreBaselineRuleList: List of ignored baseline check items
Note: This field may return null, indicating that no valid values can be obtained.
        :type IgnoreBaselineRuleList: list of IgnoreBaselineRule
        :param _TotalCount: Total number of pagination query records
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._IgnoreBaselineRuleList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def IgnoreBaselineRuleList(self):
        return self._IgnoreBaselineRuleList

    @IgnoreBaselineRuleList.setter
    def IgnoreBaselineRuleList(self, IgnoreBaselineRuleList):
        self._IgnoreBaselineRuleList = IgnoreBaselineRuleList

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("IgnoreBaselineRuleList") is not None:
            self._IgnoreBaselineRuleList = []
            for item in params.get("IgnoreBaselineRuleList"):
                obj = IgnoreBaselineRule()
                obj._deserialize(item)
                self._IgnoreBaselineRuleList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeIgnoreHostAndItemConfigRequest(AbstractModel):
    """DescribeIgnoreHostAndItemConfig request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: <li>ItemId - int64 - whether required: no - item ID</i>
<li>RuleId - int64 - whether required: no - rule ID</li>
<li>HostId - string - whether required: no - host ID</li>
        :type Filters: list of Filter
        """
        self._Filters = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIgnoreHostAndItemConfigResponse(AbstractModel):
    """DescribeIgnoreHostAndItemConfig response structure.

    """

    def __init__(self):
        r"""
        :param _ItemSet: Affected detection items
Note: This field may return null, indicating that no valid values can be obtained.
        :type ItemSet: list of BaselineItemInfo
        :param _HostSet: Affected hosts
Note: This field may return null, indicating that no valid values can be obtained.
        :type HostSet: list of BaselineHost
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ItemSet = None
        self._HostSet = None
        self._RequestId = None

    @property
    def ItemSet(self):
        return self._ItemSet

    @ItemSet.setter
    def ItemSet(self, ItemSet):
        self._ItemSet = ItemSet

    @property
    def HostSet(self):
        return self._HostSet

    @HostSet.setter
    def HostSet(self, HostSet):
        self._HostSet = HostSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ItemSet") is not None:
            self._ItemSet = []
            for item in params.get("ItemSet"):
                obj = BaselineItemInfo()
                obj._deserialize(item)
                self._ItemSet.append(obj)
        if params.get("HostSet") is not None:
            self._HostSet = []
            for item in params.get("HostSet"):
                obj = BaselineHost()
                obj._deserialize(item)
                self._HostSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeIgnoreRuleEffectHostListRequest(AbstractModel):
    """DescribeIgnoreRuleEffectHostList request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Pagination parameters (The maximum quantity is 100)
        :type Limit: int
        :param _Offset: Pagination parameter
        :type Offset: int
        :param _RuleId: Detection Item ID
        :type RuleId: int
        :param _Filters: Filter criteria
<li>AliasName - String - host alias</li>
        :type Filters: list of Filters
        :param _TagNames: Host tag name
        :type TagNames: list of str
        """
        self._Limit = None
        self._Offset = None
        self._RuleId = None
        self._Filters = None
        self._TagNames = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def TagNames(self):
        return self._TagNames

    @TagNames.setter
    def TagNames(self, TagNames):
        self._TagNames = TagNames


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._RuleId = params.get("RuleId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._TagNames = params.get("TagNames")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIgnoreRuleEffectHostListResponse(AbstractModel):
    """DescribeIgnoreRuleEffectHostList response structure.

    """

    def __init__(self):
        r"""
        :param _IgnoreRuleEffectHostList: List of hosts affected by ignored check items
Note: This field may return null, indicating that no valid values can be obtained.
        :type IgnoreRuleEffectHostList: list of IgnoreRuleEffectHostInfo
        :param _TotalCount: Total number of records for paging query
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._IgnoreRuleEffectHostList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def IgnoreRuleEffectHostList(self):
        return self._IgnoreRuleEffectHostList

    @IgnoreRuleEffectHostList.setter
    def IgnoreRuleEffectHostList(self, IgnoreRuleEffectHostList):
        self._IgnoreRuleEffectHostList = IgnoreRuleEffectHostList

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("IgnoreRuleEffectHostList") is not None:
            self._IgnoreRuleEffectHostList = []
            for item in params.get("IgnoreRuleEffectHostList"):
                obj = IgnoreRuleEffectHostInfo()
                obj._deserialize(item)
                self._IgnoreRuleEffectHostList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeIndexListRequest(AbstractModel):
    """DescribeIndexList request structure.

    """


class DescribeIndexListResponse(AbstractModel):
    """DescribeIndexList response structure.

    """

    def __init__(self):
        r"""
        :param _Data: ES index information
        :type Data: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DescribeJavaMemShellInfoRequest(AbstractModel):
    """DescribeJavaMemShellInfo request structure.

    """

    def __init__(self):
        r"""
        :param _Id: Event ID
        :type Id: int
        """
        self._Id = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeJavaMemShellInfoResponse(AbstractModel):
    """DescribeJavaMemShellInfo response structure.

    """

    def __init__(self):
        r"""
        :param _Info: Java webshell event details
Note: This field may return null, indicating that no valid values can be obtained.
        :type Info: :class:`tencentcloud.cwp.v20180228.models.JavaMemShellDetail`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Info = None
        self._RequestId = None

    @property
    def Info(self):
        return self._Info

    @Info.setter
    def Info(self, Info):
        self._Info = Info

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Info") is not None:
            self._Info = JavaMemShellDetail()
            self._Info._deserialize(params.get("Info"))
        self._RequestId = params.get("RequestId")


class DescribeJavaMemShellListRequest(AbstractModel):
    """DescribeJavaMemShellList request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filtering criteria: Keywords: IP or host name for fuzzy query; Type or status for precise match; CreateBeginTime, CreateEndTime for time period query
        :type Filters: list of Filters
        :param _Offset: Offset, which defaults to 0
        :type Offset: int
        :param _Limit: Number of items to be returned. It is 10 by default, and the maximum value is 100.
        :type Limit: int
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeJavaMemShellListResponse(AbstractModel):
    """DescribeJavaMemShellList response structure.

    """

    def __init__(self):
        r"""
        :param _List: Event list
Note: This field may return null, indicating that no valid values can be obtained.
        :type List: list of JavaMemShellInfo
        :param _TotalCount: Total number
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = JavaMemShellInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeJavaMemShellPluginInfoRequest(AbstractModel):
    """DescribeJavaMemShellPluginInfo request structure.

    """

    def __init__(self):
        r"""
        :param _Quuid: Host QUUID
        :type Quuid: str
        :param _Filters: Filter Criteria: Exact match of Pid, fuzzy match of MainClass
        :type Filters: list of Filters
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of results to be returned. Default value: 10. Maximum value: 100.
        :type Limit: int
        """
        self._Quuid = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeJavaMemShellPluginInfoResponse(AbstractModel):
    """DescribeJavaMemShellPluginInfo response structure.

    """

    def __init__(self):
        r"""
        :param _List: Java Memory Trojan Plugin List
Note: This field may return null, indicating that no valid values can be obtained.
        :type List: list of JavaMemShellPluginInfo
        :param _TotalCount: Total number
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = JavaMemShellPluginInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeJavaMemShellPluginListRequest(AbstractModel):
    """DescribeJavaMemShellPluginList request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filter Criteria: Keywords: Fuzzy query of IP or host name, JavaShellStatus, exact match of Exception
        :type Filters: list of Filters
        :param _Offset: Offset, which defaults to 0
        :type Offset: int
        :param _Limit: Number of items to be returned. It is 10 by default, and the maximum value is 100.
        :type Limit: int
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeJavaMemShellPluginListResponse(AbstractModel):
    """DescribeJavaMemShellPluginList response structure.

    """

    def __init__(self):
        r"""
        :param _List: Java Memory Trojan Plugin List
Note: This field may return null, indicating that no valid values can be obtained.
        :type List: list of JavaMemShellPluginSetting
        :param _TotalCount: Total
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = JavaMemShellPluginSetting()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeLicenseBindListRequest(AbstractModel):
    """DescribeLicenseBindList request structure.

    """

    def __init__(self):
        r"""
        :param _LicenseId: Authorization ID
        :type LicenseId: int
        :param _LicenseType: Authorization type
        :type LicenseType: int
        :param _ResourceId: Resource ID
        :type ResourceId: str
        :param _Filters: <li>InstanceID, IP,

and MachineName for fuzzy search</li>
        :type Filters: list of Filters
        :param _Limit: Limit number, 10 by default.
        :type Limit: int
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        """
        self._LicenseId = None
        self._LicenseType = None
        self._ResourceId = None
        self._Filters = None
        self._Limit = None
        self._Offset = None

    @property
    def LicenseId(self):
        return self._LicenseId

    @LicenseId.setter
    def LicenseId(self, LicenseId):
        self._LicenseId = LicenseId

    @property
    def LicenseType(self):
        return self._LicenseType

    @LicenseType.setter
    def LicenseType(self, LicenseType):
        self._LicenseType = LicenseType

    @property
    def ResourceId(self):
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._LicenseId = params.get("LicenseId")
        self._LicenseType = params.get("LicenseType")
        self._ResourceId = params.get("ResourceId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLicenseBindListResponse(AbstractModel):
    """DescribeLicenseBindList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of entries
        :type TotalCount: int
        :param _List: List of bound machines
        :type List: list of LicenseBindDetail
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._List = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = LicenseBindDetail()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLicenseBindScheduleRequest(AbstractModel):
    """DescribeLicenseBindSchedule request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID
        :type TaskId: int
        :param _Limit: Limit number, 10 by default.
        :type Limit: int
        :param _Offset: Offset, which is 0 by default.
        :type Offset: int
        :param _Filters: Filter parameters
Status - binding progress status. 0 - in progress; 1 - completed; 2 - failed
        :type Filters: list of Filter
        """
        self._TaskId = None
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLicenseBindScheduleResponse(AbstractModel):
    """DescribeLicenseBindSchedule response structure.

    """

    def __init__(self):
        r"""
        :param _Schedule: Progress
        :type Schedule: int
        :param _List: Bound Task Details
        :type List: list of LicenseBindTaskDetail
        :param _TotalCount: Total number of entries
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Schedule = None
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def Schedule(self):
        return self._Schedule

    @Schedule.setter
    def Schedule(self, Schedule):
        self._Schedule = Schedule

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Schedule = params.get("Schedule")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = LicenseBindTaskDetail()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeLicenseGeneralRequest(AbstractModel):
    """DescribeLicenseGeneral request structure.

    """


class DescribeLicenseGeneralResponse(AbstractModel):
    """DescribeLicenseGeneral response structure.

    """

    def __init__(self):
        r"""
        :param _LicenseCnt: Total number of authorizations (including those that are isolated, expired, and in other states)
        :type LicenseCnt: int
        :param _AvailableLicenseCnt: Number of available authorizations
        :type AvailableLicenseCnt: int
        :param _AvailableProVersionLicenseCnt: Number of available Professional Edition authorizations (including those in postpaid mode)
        :type AvailableProVersionLicenseCnt: int
        :param _AvailableFlagshipVersionLicenseCnt: Number of available Ultimate Edition authorizations
        :type AvailableFlagshipVersionLicenseCnt: int
        :param _NearExpiryLicenseCnt: Number of authorizations about to expire (no more than 15 days left)
        :type NearExpiryLicenseCnt: int
        :param _ExpireLicenseCnt: Number of expired authorizations (excluding deleted ones)
        :type ExpireLicenseCnt: int
        :param _AutoOpenStatus: Automatic upgrade enabling status. True: enabled; false: disabled. Default value: false.
        :type AutoOpenStatus: bool
        :param _ProtectType: PROVERSION_POSTPAY: Pro Edition - postpaid; PROVERSION_PREPAY: Pro edition - prepaid; FLAGSHIP_PREPAY: Ultimate Edition - prepaid.
        :type ProtectType: str
        :param _IsOpenStatusHistory: Whether automatic upgrade has been enabled before
        :type IsOpenStatusHistory: bool
        :param _UsedLicenseCnt: Number of used authorizations
        :type UsedLicenseCnt: int
        :param _NotExpiredLicenseCnt: Number of authorizations that have not expired
        :type NotExpiredLicenseCnt: int
        :param _FlagshipVersionLicenseCnt: Total number of Ultimate Edition authorizations (valid orders)
        :type FlagshipVersionLicenseCnt: int
        :param _ProVersionLicenseCnt: Total number of Pro Edition authorizations (valid orders)
        :type ProVersionLicenseCnt: int
        :param _CwpVersionLicenseCnt: Total number of Inclusive Edition authorizations (those of valid orders)
        :type CwpVersionLicenseCnt: int
        :param _AvailableLHLicenseCnt: Number of available Inclusive Edition authorizations
        :type AvailableLHLicenseCnt: int
        :param _AutoRepurchaseSwitch: Auto-purchase switch, true for ON, false for OFF
        :type AutoRepurchaseSwitch: bool
        :param _AutoRepurchaseRenewSwitch: Is auto-renewal required for auto-purchase orders, true for ON, false for OFF
        :type AutoRepurchaseRenewSwitch: bool
        :param _DestroyOrderNum: Number of terminated orders
        :type DestroyOrderNum: int
        :param _RepurchaseRenewSwitch: Whether automatic renewal is enabled. True: enabled; false: disabled.
        :type RepurchaseRenewSwitch: bool
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._LicenseCnt = None
        self._AvailableLicenseCnt = None
        self._AvailableProVersionLicenseCnt = None
        self._AvailableFlagshipVersionLicenseCnt = None
        self._NearExpiryLicenseCnt = None
        self._ExpireLicenseCnt = None
        self._AutoOpenStatus = None
        self._ProtectType = None
        self._IsOpenStatusHistory = None
        self._UsedLicenseCnt = None
        self._NotExpiredLicenseCnt = None
        self._FlagshipVersionLicenseCnt = None
        self._ProVersionLicenseCnt = None
        self._CwpVersionLicenseCnt = None
        self._AvailableLHLicenseCnt = None
        self._AutoRepurchaseSwitch = None
        self._AutoRepurchaseRenewSwitch = None
        self._DestroyOrderNum = None
        self._RepurchaseRenewSwitch = None
        self._RequestId = None

    @property
    def LicenseCnt(self):
        return self._LicenseCnt

    @LicenseCnt.setter
    def LicenseCnt(self, LicenseCnt):
        self._LicenseCnt = LicenseCnt

    @property
    def AvailableLicenseCnt(self):
        return self._AvailableLicenseCnt

    @AvailableLicenseCnt.setter
    def AvailableLicenseCnt(self, AvailableLicenseCnt):
        self._AvailableLicenseCnt = AvailableLicenseCnt

    @property
    def AvailableProVersionLicenseCnt(self):
        return self._AvailableProVersionLicenseCnt

    @AvailableProVersionLicenseCnt.setter
    def AvailableProVersionLicenseCnt(self, AvailableProVersionLicenseCnt):
        self._AvailableProVersionLicenseCnt = AvailableProVersionLicenseCnt

    @property
    def AvailableFlagshipVersionLicenseCnt(self):
        return self._AvailableFlagshipVersionLicenseCnt

    @AvailableFlagshipVersionLicenseCnt.setter
    def AvailableFlagshipVersionLicenseCnt(self, AvailableFlagshipVersionLicenseCnt):
        self._AvailableFlagshipVersionLicenseCnt = AvailableFlagshipVersionLicenseCnt

    @property
    def NearExpiryLicenseCnt(self):
        return self._NearExpiryLicenseCnt

    @NearExpiryLicenseCnt.setter
    def NearExpiryLicenseCnt(self, NearExpiryLicenseCnt):
        self._NearExpiryLicenseCnt = NearExpiryLicenseCnt

    @property
    def ExpireLicenseCnt(self):
        return self._ExpireLicenseCnt

    @ExpireLicenseCnt.setter
    def ExpireLicenseCnt(self, ExpireLicenseCnt):
        self._ExpireLicenseCnt = ExpireLicenseCnt

    @property
    def AutoOpenStatus(self):
        return self._AutoOpenStatus

    @AutoOpenStatus.setter
    def AutoOpenStatus(self, AutoOpenStatus):
        self._AutoOpenStatus = AutoOpenStatus

    @property
    def ProtectType(self):
        return self._ProtectType

    @ProtectType.setter
    def ProtectType(self, ProtectType):
        self._ProtectType = ProtectType

    @property
    def IsOpenStatusHistory(self):
        return self._IsOpenStatusHistory

    @IsOpenStatusHistory.setter
    def IsOpenStatusHistory(self, IsOpenStatusHistory):
        self._IsOpenStatusHistory = IsOpenStatusHistory

    @property
    def UsedLicenseCnt(self):
        return self._UsedLicenseCnt

    @UsedLicenseCnt.setter
    def UsedLicenseCnt(self, UsedLicenseCnt):
        self._UsedLicenseCnt = UsedLicenseCnt

    @property
    def NotExpiredLicenseCnt(self):
        return self._NotExpiredLicenseCnt

    @NotExpiredLicenseCnt.setter
    def NotExpiredLicenseCnt(self, NotExpiredLicenseCnt):
        self._NotExpiredLicenseCnt = NotExpiredLicenseCnt

    @property
    def FlagshipVersionLicenseCnt(self):
        return self._FlagshipVersionLicenseCnt

    @FlagshipVersionLicenseCnt.setter
    def FlagshipVersionLicenseCnt(self, FlagshipVersionLicenseCnt):
        self._FlagshipVersionLicenseCnt = FlagshipVersionLicenseCnt

    @property
    def ProVersionLicenseCnt(self):
        return self._ProVersionLicenseCnt

    @ProVersionLicenseCnt.setter
    def ProVersionLicenseCnt(self, ProVersionLicenseCnt):
        self._ProVersionLicenseCnt = ProVersionLicenseCnt

    @property
    def CwpVersionLicenseCnt(self):
        return self._CwpVersionLicenseCnt

    @CwpVersionLicenseCnt.setter
    def CwpVersionLicenseCnt(self, CwpVersionLicenseCnt):
        self._CwpVersionLicenseCnt = CwpVersionLicenseCnt

    @property
    def AvailableLHLicenseCnt(self):
        return self._AvailableLHLicenseCnt

    @AvailableLHLicenseCnt.setter
    def AvailableLHLicenseCnt(self, AvailableLHLicenseCnt):
        self._AvailableLHLicenseCnt = AvailableLHLicenseCnt

    @property
    def AutoRepurchaseSwitch(self):
        return self._AutoRepurchaseSwitch

    @AutoRepurchaseSwitch.setter
    def AutoRepurchaseSwitch(self, AutoRepurchaseSwitch):
        self._AutoRepurchaseSwitch = AutoRepurchaseSwitch

    @property
    def AutoRepurchaseRenewSwitch(self):
        return self._AutoRepurchaseRenewSwitch

    @AutoRepurchaseRenewSwitch.setter
    def AutoRepurchaseRenewSwitch(self, AutoRepurchaseRenewSwitch):
        self._AutoRepurchaseRenewSwitch = AutoRepurchaseRenewSwitch

    @property
    def DestroyOrderNum(self):
        return self._DestroyOrderNum

    @DestroyOrderNum.setter
    def DestroyOrderNum(self, DestroyOrderNum):
        self._DestroyOrderNum = DestroyOrderNum

    @property
    def RepurchaseRenewSwitch(self):
        return self._RepurchaseRenewSwitch

    @RepurchaseRenewSwitch.setter
    def RepurchaseRenewSwitch(self, RepurchaseRenewSwitch):
        self._RepurchaseRenewSwitch = RepurchaseRenewSwitch

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._LicenseCnt = params.get("LicenseCnt")
        self._AvailableLicenseCnt = params.get("AvailableLicenseCnt")
        self._AvailableProVersionLicenseCnt = params.get("AvailableProVersionLicenseCnt")
        self._AvailableFlagshipVersionLicenseCnt = params.get("AvailableFlagshipVersionLicenseCnt")
        self._NearExpiryLicenseCnt = params.get("NearExpiryLicenseCnt")
        self._ExpireLicenseCnt = params.get("ExpireLicenseCnt")
        self._AutoOpenStatus = params.get("AutoOpenStatus")
        self._ProtectType = params.get("ProtectType")
        self._IsOpenStatusHistory = params.get("IsOpenStatusHistory")
        self._UsedLicenseCnt = params.get("UsedLicenseCnt")
        self._NotExpiredLicenseCnt = params.get("NotExpiredLicenseCnt")
        self._FlagshipVersionLicenseCnt = params.get("FlagshipVersionLicenseCnt")
        self._ProVersionLicenseCnt = params.get("ProVersionLicenseCnt")
        self._CwpVersionLicenseCnt = params.get("CwpVersionLicenseCnt")
        self._AvailableLHLicenseCnt = params.get("AvailableLHLicenseCnt")
        self._AutoRepurchaseSwitch = params.get("AutoRepurchaseSwitch")
        self._AutoRepurchaseRenewSwitch = params.get("AutoRepurchaseRenewSwitch")
        self._DestroyOrderNum = params.get("DestroyOrderNum")
        self._RepurchaseRenewSwitch = params.get("RepurchaseRenewSwitch")
        self._RequestId = params.get("RequestId")


class DescribeLicenseListRequest(AbstractModel):
    """DescribeLicenseList request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Take the intersection when filtering with multiple conditions.
<li> LicenseStatus authorization status information: 0 - not used; 1 - partially used; 2 - used up; 3 - unavailable; 4 - available</li>
<li> BuyTime: time of purchase</li>
<li> LicenseType authorization type. 0: Pro Edition-pay-as-you-go; 1: Pro Edition-monthly subscription; 2: Ultimate Edition-monthly subscription</li>
<li>DeadlineStatus expiration status: NotExpired -not expired; expire - expired (including terminated); nearexpiry - about to expire</li>
<li>ResourceId resource ID</li>
<li>Keywords IP filtering</li>
<li>PayMode payment mode. 0: pay-as-you-go; 1: monthly subscription</li>
<li>OrderStatus order status. 1: normal; 2: isolated; 3: terminated</li>
<li>DealNames sub-order number, with a maximum length of 10, exceeding this will result in a failure.</li>
        :type Filters: list of Filters
        :param _Limit: Limit number, 10 by default.
        :type Limit: int
        :param _Offset: Offset, which is 0 by default.
        :type Offset: int
        :param _Tags: Tag filtering; filter by the platform's tag capabilities. In this case, you should pass in the tag key and tag value as an object.
        :type Tags: list of Tags
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Tags = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tags()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLicenseListResponse(AbstractModel):
    """DescribeLicenseList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number
        :type TotalCount: int
        :param _List: Authorization quantity list information
        :type List: list of LicenseDetail
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._List = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = LicenseDetail()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLicenseRequest(AbstractModel):
    """DescribeLicense request structure.

    """


class DescribeLicenseResponse(AbstractModel):
    """DescribeLicense response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DescribeLicenseWhiteConfigRequest(AbstractModel):
    """DescribeLicenseWhiteConfig request structure.

    """

    def __init__(self):
        r"""
        :param _RuleName: Rule name. For example, cwp.
        :type RuleName: str
        """
        self._RuleName = None

    @property
    def RuleName(self):
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName


    def _deserialize(self, params):
        self._RuleName = params.get("RuleName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLicenseWhiteConfigResponse(AbstractModel):
    """DescribeLicenseWhiteConfig response structure.

    """

    def __init__(self):
        r"""
        :param _FlagShip: Ultimate Edition configuration information
        :type FlagShip: :class:`tencentcloud.cwp.v20180228.models.VersionWhiteConfig`
        :param _Professional: Pro Edition configuration information
        :type Professional: :class:`tencentcloud.cwp.v20180228.models.VersionWhiteConfig`
        :param _PrattWhitney: Inclusive Edition configuration information
        :type PrattWhitney: :class:`tencentcloud.cwp.v20180228.models.VersionWhiteConfig`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FlagShip = None
        self._Professional = None
        self._PrattWhitney = None
        self._RequestId = None

    @property
    def FlagShip(self):
        return self._FlagShip

    @FlagShip.setter
    def FlagShip(self, FlagShip):
        self._FlagShip = FlagShip

    @property
    def Professional(self):
        return self._Professional

    @Professional.setter
    def Professional(self, Professional):
        self._Professional = Professional

    @property
    def PrattWhitney(self):
        return self._PrattWhitney

    @PrattWhitney.setter
    def PrattWhitney(self, PrattWhitney):
        self._PrattWhitney = PrattWhitney

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("FlagShip") is not None:
            self._FlagShip = VersionWhiteConfig()
            self._FlagShip._deserialize(params.get("FlagShip"))
        if params.get("Professional") is not None:
            self._Professional = VersionWhiteConfig()
            self._Professional._deserialize(params.get("Professional"))
        if params.get("PrattWhitney") is not None:
            self._PrattWhitney = VersionWhiteConfig()
            self._PrattWhitney._deserialize(params.get("PrattWhitney"))
        self._RequestId = params.get("RequestId")


class DescribeLogDeliveryKafkaOptionsRequest(AbstractModel):
    """DescribeLogDeliveryKafkaOptions request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceID: Kafka instance ID
        :type InstanceID: str
        """
        self._InstanceID = None

    @property
    def InstanceID(self):
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID


    def _deserialize(self, params):
        self._InstanceID = params.get("InstanceID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLogDeliveryKafkaOptionsResponse(AbstractModel):
    """DescribeLogDeliveryKafkaOptions response structure.

    """

    def __init__(self):
        r"""
        :param _InstanceList: Instance list
        :type InstanceList: list of CKafkaInstanceInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._InstanceList = None
        self._RequestId = None

    @property
    def InstanceList(self):
        return self._InstanceList

    @InstanceList.setter
    def InstanceList(self, InstanceList):
        self._InstanceList = InstanceList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("InstanceList") is not None:
            self._InstanceList = []
            for item in params.get("InstanceList"):
                obj = CKafkaInstanceInfo()
                obj._deserialize(item)
                self._InstanceList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLogExportsRequest(AbstractModel):
    """DescribeLogExports request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Paging offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of entries per page. Default value: 20. Maximum value: 100.
        :type Limit: int
        """
        self._Offset = None
        self._Limit = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLogExportsResponse(AbstractModel):
    """DescribeLogExports response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number
        :type TotalCount: int
        :param _Exports: List of exported logs
        :type Exports: list of ExportInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Exports = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Exports(self):
        return self._Exports

    @Exports.setter
    def Exports(self, Exports):
        self._Exports = Exports

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Exports") is not None:
            self._Exports = []
            for item in params.get("Exports"):
                obj = ExportInfo()
                obj._deserialize(item)
                self._Exports.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLogHistogramRequest(AbstractModel):
    """DescribeLogHistogram request structure.

    """

    def __init__(self):
        r"""
        :param _StartTime: Start time of logs to be queried, which is a Unix timestamp in milliseconds
        :type StartTime: int
        :param _EndTime: End time of logs to be queried, which is a Unix timestamp in milliseconds
        :type EndTime: int
        :param _QueryString: Query statement
        :type QueryString: str
        :param _Interval: Time interval, in ms
        :type Interval: int
        """
        self._StartTime = None
        self._EndTime = None
        self._QueryString = None
        self._Interval = None

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def QueryString(self):
        return self._QueryString

    @QueryString.setter
    def QueryString(self, QueryString):
        self._QueryString = QueryString

    @property
    def Interval(self):
        return self._Interval

    @Interval.setter
    def Interval(self, Interval):
        self._Interval = Interval


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._QueryString = params.get("QueryString")
        self._Interval = params.get("Interval")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLogHistogramResponse(AbstractModel):
    """DescribeLogHistogram response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Result details of statistics within the period
        :type Data: list of LogHistogram
        :param _Period: Statistical period (unit: ms)
        :type Period: int
        :param _TotalCount: Total number of logs that hit the keywords
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._Period = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def Period(self):
        return self._Period

    @Period.setter
    def Period(self, Period):
        self._Period = Period

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = LogHistogram()
                obj._deserialize(item)
                self._Data.append(obj)
        self._Period = params.get("Period")
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeLogIndexRequest(AbstractModel):
    """DescribeLogIndex request structure.

    """


class DescribeLogIndexResponse(AbstractModel):
    """DescribeLogIndex response structure.

    """

    def __init__(self):
        r"""
        :param _Status: Whether effective
        :type Status: bool
        :param _Rule: Index rule
        :type Rule: :class:`tencentcloud.cwp.v20180228.models.RuleInfo`
        :param _ModifyTime: Index modification time, which is initially the index creation time.
        :type ModifyTime: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Status = None
        self._Rule = None
        self._ModifyTime = None
        self._RequestId = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Rule(self):
        return self._Rule

    @Rule.setter
    def Rule(self, Rule):
        self._Rule = Rule

    @property
    def ModifyTime(self):
        return self._ModifyTime

    @ModifyTime.setter
    def ModifyTime(self, ModifyTime):
        self._ModifyTime = ModifyTime

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Status = params.get("Status")
        if params.get("Rule") is not None:
            self._Rule = RuleInfo()
            self._Rule._deserialize(params.get("Rule"))
        self._ModifyTime = params.get("ModifyTime")
        self._RequestId = params.get("RequestId")


class DescribeLogKafkaDeliverInfoRequest(AbstractModel):
    """DescribeLogKafkaDeliverInfo request structure.

    """


class DescribeLogKafkaDeliverInfoResponse(AbstractModel):
    """DescribeLogKafkaDeliverInfo response structure.

    """

    def __init__(self):
        r"""
        :param _KafkaEnvName: Instance environment
        :type KafkaEnvName: str
        :param _KafkaId: Instance ID
        :type KafkaId: str
        :param _Zone: Region
        :type Zone: str
        :param _Az: Availability zone
        :type Az: str
        :param _VpcId: Network
        :type VpcId: str
        :param _SubnetId: Subnet
        :type SubnetId: str
        :param _AccessType: Access method. 1: public network domain name access; 2: support environment access
        :type AccessType: int
        :param _AccessAddr: Access address
        :type AccessAddr: str
        :param _DeliverStatus: Shipping status. 1: healthy; 2: alarm; 3: abnormal
        :type DeliverStatus: int
        :param _InsVersion: Kafka edition
        :type InsVersion: str
        :param _BandWidth: Peak bandwidth
        :type BandWidth: int
        :param _DiskSize: Disk capacity
        :type DiskSize: int
        :param _Username: Username
        :type Username: str
        :param _DeliverTypeDetails: xx
        :type DeliverTypeDetails: list of DeliverTypeDetails
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._KafkaEnvName = None
        self._KafkaId = None
        self._Zone = None
        self._Az = None
        self._VpcId = None
        self._SubnetId = None
        self._AccessType = None
        self._AccessAddr = None
        self._DeliverStatus = None
        self._InsVersion = None
        self._BandWidth = None
        self._DiskSize = None
        self._Username = None
        self._DeliverTypeDetails = None
        self._RequestId = None

    @property
    def KafkaEnvName(self):
        return self._KafkaEnvName

    @KafkaEnvName.setter
    def KafkaEnvName(self, KafkaEnvName):
        self._KafkaEnvName = KafkaEnvName

    @property
    def KafkaId(self):
        return self._KafkaId

    @KafkaId.setter
    def KafkaId(self, KafkaId):
        self._KafkaId = KafkaId

    @property
    def Zone(self):
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def Az(self):
        return self._Az

    @Az.setter
    def Az(self, Az):
        self._Az = Az

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def AccessType(self):
        return self._AccessType

    @AccessType.setter
    def AccessType(self, AccessType):
        self._AccessType = AccessType

    @property
    def AccessAddr(self):
        return self._AccessAddr

    @AccessAddr.setter
    def AccessAddr(self, AccessAddr):
        self._AccessAddr = AccessAddr

    @property
    def DeliverStatus(self):
        return self._DeliverStatus

    @DeliverStatus.setter
    def DeliverStatus(self, DeliverStatus):
        self._DeliverStatus = DeliverStatus

    @property
    def InsVersion(self):
        return self._InsVersion

    @InsVersion.setter
    def InsVersion(self, InsVersion):
        self._InsVersion = InsVersion

    @property
    def BandWidth(self):
        return self._BandWidth

    @BandWidth.setter
    def BandWidth(self, BandWidth):
        self._BandWidth = BandWidth

    @property
    def DiskSize(self):
        return self._DiskSize

    @DiskSize.setter
    def DiskSize(self, DiskSize):
        self._DiskSize = DiskSize

    @property
    def Username(self):
        return self._Username

    @Username.setter
    def Username(self, Username):
        self._Username = Username

    @property
    def DeliverTypeDetails(self):
        return self._DeliverTypeDetails

    @DeliverTypeDetails.setter
    def DeliverTypeDetails(self, DeliverTypeDetails):
        self._DeliverTypeDetails = DeliverTypeDetails

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._KafkaEnvName = params.get("KafkaEnvName")
        self._KafkaId = params.get("KafkaId")
        self._Zone = params.get("Zone")
        self._Az = params.get("Az")
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._AccessType = params.get("AccessType")
        self._AccessAddr = params.get("AccessAddr")
        self._DeliverStatus = params.get("DeliverStatus")
        self._InsVersion = params.get("InsVersion")
        self._BandWidth = params.get("BandWidth")
        self._DiskSize = params.get("DiskSize")
        self._Username = params.get("Username")
        if params.get("DeliverTypeDetails") is not None:
            self._DeliverTypeDetails = []
            for item in params.get("DeliverTypeDetails"):
                obj = DeliverTypeDetails()
                obj._deserialize(item)
                self._DeliverTypeDetails.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLogStorageConfigRequest(AbstractModel):
    """DescribeLogStorageConfig request structure.

    """


class DescribeLogStorageConfigResponse(AbstractModel):
    """DescribeLogStorageConfig response structure.

    """

    def __init__(self):
        r"""
        :param _Type: Storage type. The value is an array of strings.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Type: list of str
        :param _Period: Log retention days. The value 3640 means the retention days are not limited.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Period: int
        :param _PeriodModifyCount: Count of period changes in this month
Note: This field may return null, indicating that no valid values can be obtained.
        :type PeriodModifyCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Type = None
        self._Period = None
        self._PeriodModifyCount = None
        self._RequestId = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Period(self):
        return self._Period

    @Period.setter
    def Period(self, Period):
        self._Period = Period

    @property
    def PeriodModifyCount(self):
        return self._PeriodModifyCount

    @PeriodModifyCount.setter
    def PeriodModifyCount(self, PeriodModifyCount):
        self._PeriodModifyCount = PeriodModifyCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Period = params.get("Period")
        self._PeriodModifyCount = params.get("PeriodModifyCount")
        self._RequestId = params.get("RequestId")


class DescribeLogStorageRecordRequest(AbstractModel):
    """DescribeLogStorageRecord request structure.

    """


class DescribeLogStorageRecordResponse(AbstractModel):
    """DescribeLogStorageRecord response structure.

    """

    def __init__(self):
        r"""
        :param _Records: Storage amount record
Note: This field may return null, indicating that no valid values can be obtained.
        :type Records: list of LogStorageRecord
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Records = None
        self._RequestId = None

    @property
    def Records(self):
        return self._Records

    @Records.setter
    def Records(self, Records):
        self._Records = Records

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Records") is not None:
            self._Records = []
            for item in params.get("Records"):
                obj = LogStorageRecord()
                obj._deserialize(item)
                self._Records.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLogStorageStatisticRequest(AbstractModel):
    """DescribeLogStorageStatistic request structure.

    """


class DescribeLogStorageStatisticResponse(AbstractModel):
    """DescribeLogStorageStatistic response structure.

    """

    def __init__(self):
        r"""
        :param _TotalSize: Total capacity (unit: GB)
        :type TotalSize: int
        :param _UsedSize: Used capacity (unit: GB)
        :type UsedSize: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalSize = None
        self._UsedSize = None
        self._RequestId = None

    @property
    def TotalSize(self):
        return self._TotalSize

    @TotalSize.setter
    def TotalSize(self, TotalSize):
        self._TotalSize = TotalSize

    @property
    def UsedSize(self):
        return self._UsedSize

    @UsedSize.setter
    def UsedSize(self, UsedSize):
        self._UsedSize = UsedSize

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalSize = params.get("TotalSize")
        self._UsedSize = params.get("UsedSize")
        self._RequestId = params.get("RequestId")


class DescribeLogTypeRequest(AbstractModel):
    """DescribeLogType request structure.

    """


class DescribeLogTypeResponse(AbstractModel):
    """DescribeLogType response structure.

    """

    def __init__(self):
        r"""
        :param _Data: CLS log type information
        :type Data: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DescribeLoginWhiteCombinedListRequest(AbstractModel):
    """DescribeLoginWhiteCombinedList request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of items to be returned. It is 10 by default, and the maximum value is 100.
        :type Limit: int
        :param _Offset: Offset, which defaults to 0
        :type Offset: int
        :param _Filters: Filter criteria
<li>IpOrAlias - String - required: no - filter by host IP or alias</li>
<li>UserName - String - required: no - filter by username</li>
<li>ModifyBeginTime - String - required: no - filter by modification time; start time</li>
<li>ModifyEndTime - String - required: no - Filter by modification time; end time</li>
        :type Filters: list of Filter
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLoginWhiteCombinedListResponse(AbstractModel):
    """DescribeLoginWhiteCombinedList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number
        :type TotalCount: int
        :param _LoginWhiteCombinedInfos: List of allowlists after merge
Note: This field may return null, indicating that no valid values can be obtained.
        :type LoginWhiteCombinedInfos: list of LoginWhiteCombinedInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._LoginWhiteCombinedInfos = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def LoginWhiteCombinedInfos(self):
        return self._LoginWhiteCombinedInfos

    @LoginWhiteCombinedInfos.setter
    def LoginWhiteCombinedInfos(self, LoginWhiteCombinedInfos):
        self._LoginWhiteCombinedInfos = LoginWhiteCombinedInfos

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("LoginWhiteCombinedInfos") is not None:
            self._LoginWhiteCombinedInfos = []
            for item in params.get("LoginWhiteCombinedInfos"):
                obj = LoginWhiteCombinedInfo()
                obj._deserialize(item)
                self._LoginWhiteCombinedInfos.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLoginWhiteHostListRequest(AbstractModel):
    """DescribeLoginWhiteHostList request structure.

    """

    def __init__(self):
        r"""
        :param _Id: Allowlist ID
        :type Id: int
        :param _Limit: Number of results to be returned. Maximum value: 1000.
        :type Limit: int
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Filters: Filtering criteria <li>IpOrAlias - String - required: no - host IP or alias for filtering</li>
        :type Filters: list of AssetFilters
        """
        self._Id = None
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLoginWhiteHostListResponse(AbstractModel):
    """DescribeLoginWhiteHostList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number
        :type TotalCount: int
        :param _Hosts: Server list
        :type Hosts: list of HostDesc
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._Hosts = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Hosts(self):
        return self._Hosts

    @Hosts.setter
    def Hosts(self, Hosts):
        self._Hosts = Hosts

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Hosts") is not None:
            self._Hosts = []
            for item in params.get("Hosts"):
                obj = HostDesc()
                obj._deserialize(item)
                self._Hosts.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLoginWhiteListRequest(AbstractModel):
    """DescribeLoginWhiteList request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of returned entries. Maximum value: 100.
        :type Limit: int
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Filters: Filter criteria
<li>IpOrAlias - String - required: no - keyword for search </li>
<li>UserName - String - required: no - username for filtering </li>
<li>ModifyBeginTime - String - required: no - modification start time for filtering </li>
<li>ModifyEndTime - String - required: no - modification end time for filtering </li>
        :type Filters: list of Filter
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLoginWhiteListResponse(AbstractModel):
    """DescribeLoginWhiteList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of records
        :type TotalCount: int
        :param _LoginWhiteLists: Cross-region log-in allowlist array
        :type LoginWhiteLists: list of LoginWhiteLists
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._LoginWhiteLists = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def LoginWhiteLists(self):
        return self._LoginWhiteLists

    @LoginWhiteLists.setter
    def LoginWhiteLists(self, LoginWhiteLists):
        self._LoginWhiteLists = LoginWhiteLists

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("LoginWhiteLists") is not None:
            self._LoginWhiteLists = []
            for item in params.get("LoginWhiteLists"):
                obj = LoginWhiteLists()
                obj._deserialize(item)
                self._LoginWhiteLists.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeMachineClearHistoryRequest(AbstractModel):
    """DescribeMachineClearHistory request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filtering criteria
Return entries that match both Keywords and TimeBetween when multiple filtering criteria are used
<li> Keywords: instance name, private IP address, public IP address</li>
<li> TimeBetween: time interval</li>
        :type Filters: list of Filters
        :param _Limit: Limit Entries, 10 by default, up to 100.
        :type Limit: int
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Order: Ascending order, ASC, Descending order DESC, ASC by default.
        :type Order: str
        :param _By: AgentLastOfflineTime: last offline time of client
AutoClearTime: clearing time
        :type By: str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMachineClearHistoryResponse(AbstractModel):
    """DescribeMachineClearHistory response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of entries
        :type TotalCount: int
        :param _List: List data
        :type List: list of MachineClearHistory
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._List = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = MachineClearHistory()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeMachineDefenseCntRequest(AbstractModel):
    """DescribeMachineDefenseCnt request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filtering criteria
<li>Uuids - String - required: no - host UUID</li>
        :type Filters: list of Filter
        """
        self._Filters = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMachineDefenseCntResponse(AbstractModel):
    """DescribeMachineDefenseCnt response structure.

    """

    def __init__(self):
        r"""
        :param _AttackLogs: Attack detection statistics
        :type AttackLogs: int
        :param _FileTamper: Core file monitoring statistics
        :type FileTamper: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._AttackLogs = None
        self._FileTamper = None
        self._RequestId = None

    @property
    def AttackLogs(self):
        return self._AttackLogs

    @AttackLogs.setter
    def AttackLogs(self, AttackLogs):
        self._AttackLogs = AttackLogs

    @property
    def FileTamper(self):
        return self._FileTamper

    @FileTamper.setter
    def FileTamper(self, FileTamper):
        self._FileTamper = FileTamper

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AttackLogs = params.get("AttackLogs")
        self._FileTamper = params.get("FileTamper")
        self._RequestId = params.get("RequestId")


class DescribeMachineFileTamperRulesRequest(AbstractModel):
    """DescribeMachineFileTamperRules request structure.

    """

    def __init__(self):
        r"""
        :param _Uuid: Host UUID
        :type Uuid: str
        :param _Offset: Offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of results to be returned. Default value: 10. Maximum value: 100.
        :type Limit: int
        """
        self._Uuid = None
        self._Offset = None
        self._Limit = None

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._Uuid = params.get("Uuid")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMachineFileTamperRulesResponse(AbstractModel):
    """DescribeMachineFileTamperRules response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number
        :type TotalCount: int
        :param _List: Query Details of Host-related Core File Monitoring Rules
        :type List: list of MachineFileTamperRule
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._List = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = MachineFileTamperRule()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeMachineGeneralRequest(AbstractModel):
    """DescribeMachineGeneral request structure.

    """


class DescribeMachineGeneralResponse(AbstractModel):
    """DescribeMachineGeneral response structure.

    """

    def __init__(self):
        r"""
        :param _MachineCnt: Total number of assets
        :type MachineCnt: int
        :param _TencentCloudMachineCnt: Number of Tencent Cloud machines
        :type TencentCloudMachineCnt: int
        :param _AliCloudMachineCnt: Number of Alibaba Cloud machines
        :type AliCloudMachineCnt: int
        :param _BaiduCloudMachineCnt: Number of Baidu Cloud machines
        :type BaiduCloudMachineCnt: int
        :param _IDCMachineCnt: Number of IDC machines
        :type IDCMachineCnt: int
        :param _OtherCloudMachineCnt: Number of machines from other cloud service vendors
        :type OtherCloudMachineCnt: int
        :param _ProtectMachineCnt: Number of protected machines
        :type ProtectMachineCnt: int
        :param _BaseMachineCnt: Number of protected Basic Edition machines
        :type BaseMachineCnt: int
        :param _SpecialtyMachineCnt: Number of protected Pro Edition machines
        :type SpecialtyMachineCnt: int
        :param _FlagshipMachineCnt: Number of protected Ultimate Edition machines
        :type FlagshipMachineCnt: int
        :param _RiskMachineCnt: Number of risky machines
        :type RiskMachineCnt: int
        :param _CompareYesterdayRiskMachineCnt: Number of new risky machines compared with that yesterday
        :type CompareYesterdayRiskMachineCnt: int
        :param _CompareYesterdayNotProtectMachineCnt: Number of new unprotected machines compared with that yesterday
        :type CompareYesterdayNotProtectMachineCnt: int
        :param _CompareYesterdayDeadlineMachineCnt: Number of new machines about to expire compared with that yesterday
        :type CompareYesterdayDeadlineMachineCnt: int
        :param _DeadlineMachineCnt: Number of machines about to expire
        :type DeadlineMachineCnt: int
        :param _NotProtectMachineCnt: Number of unprotected machines
        :type NotProtectMachineCnt: int
        :param _LHGeneralDiscountCnt: Number of protected Inclusive Edition machines (Lighthouse machines)
        :type LHGeneralDiscountCnt: int
        :param _CompareYesterdayMachineCnt: Number of new hosts compared with that yesterday
        :type CompareYesterdayMachineCnt: int
        :param _MachineDestroyAfterOfflineHours: Auto-cleanup Time, maximum 720 hours, minimum 0, 0 by default, 0=OFF
        :type MachineDestroyAfterOfflineHours: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._MachineCnt = None
        self._TencentCloudMachineCnt = None
        self._AliCloudMachineCnt = None
        self._BaiduCloudMachineCnt = None
        self._IDCMachineCnt = None
        self._OtherCloudMachineCnt = None
        self._ProtectMachineCnt = None
        self._BaseMachineCnt = None
        self._SpecialtyMachineCnt = None
        self._FlagshipMachineCnt = None
        self._RiskMachineCnt = None
        self._CompareYesterdayRiskMachineCnt = None
        self._CompareYesterdayNotProtectMachineCnt = None
        self._CompareYesterdayDeadlineMachineCnt = None
        self._DeadlineMachineCnt = None
        self._NotProtectMachineCnt = None
        self._LHGeneralDiscountCnt = None
        self._CompareYesterdayMachineCnt = None
        self._MachineDestroyAfterOfflineHours = None
        self._RequestId = None

    @property
    def MachineCnt(self):
        return self._MachineCnt

    @MachineCnt.setter
    def MachineCnt(self, MachineCnt):
        self._MachineCnt = MachineCnt

    @property
    def TencentCloudMachineCnt(self):
        return self._TencentCloudMachineCnt

    @TencentCloudMachineCnt.setter
    def TencentCloudMachineCnt(self, TencentCloudMachineCnt):
        self._TencentCloudMachineCnt = TencentCloudMachineCnt

    @property
    def AliCloudMachineCnt(self):
        return self._AliCloudMachineCnt

    @AliCloudMachineCnt.setter
    def AliCloudMachineCnt(self, AliCloudMachineCnt):
        self._AliCloudMachineCnt = AliCloudMachineCnt

    @property
    def BaiduCloudMachineCnt(self):
        return self._BaiduCloudMachineCnt

    @BaiduCloudMachineCnt.setter
    def BaiduCloudMachineCnt(self, BaiduCloudMachineCnt):
        self._BaiduCloudMachineCnt = BaiduCloudMachineCnt

    @property
    def IDCMachineCnt(self):
        return self._IDCMachineCnt

    @IDCMachineCnt.setter
    def IDCMachineCnt(self, IDCMachineCnt):
        self._IDCMachineCnt = IDCMachineCnt

    @property
    def OtherCloudMachineCnt(self):
        return self._OtherCloudMachineCnt

    @OtherCloudMachineCnt.setter
    def OtherCloudMachineCnt(self, OtherCloudMachineCnt):
        self._OtherCloudMachineCnt = OtherCloudMachineCnt

    @property
    def ProtectMachineCnt(self):
        return self._ProtectMachineCnt

    @ProtectMachineCnt.setter
    def ProtectMachineCnt(self, ProtectMachineCnt):
        self._ProtectMachineCnt = ProtectMachineCnt

    @property
    def BaseMachineCnt(self):
        return self._BaseMachineCnt

    @BaseMachineCnt.setter
    def BaseMachineCnt(self, BaseMachineCnt):
        self._BaseMachineCnt = BaseMachineCnt

    @property
    def SpecialtyMachineCnt(self):
        return self._SpecialtyMachineCnt

    @SpecialtyMachineCnt.setter
    def SpecialtyMachineCnt(self, SpecialtyMachineCnt):
        self._SpecialtyMachineCnt = SpecialtyMachineCnt

    @property
    def FlagshipMachineCnt(self):
        return self._FlagshipMachineCnt

    @FlagshipMachineCnt.setter
    def FlagshipMachineCnt(self, FlagshipMachineCnt):
        self._FlagshipMachineCnt = FlagshipMachineCnt

    @property
    def RiskMachineCnt(self):
        return self._RiskMachineCnt

    @RiskMachineCnt.setter
    def RiskMachineCnt(self, RiskMachineCnt):
        self._RiskMachineCnt = RiskMachineCnt

    @property
    def CompareYesterdayRiskMachineCnt(self):
        return self._CompareYesterdayRiskMachineCnt

    @CompareYesterdayRiskMachineCnt.setter
    def CompareYesterdayRiskMachineCnt(self, CompareYesterdayRiskMachineCnt):
        self._CompareYesterdayRiskMachineCnt = CompareYesterdayRiskMachineCnt

    @property
    def CompareYesterdayNotProtectMachineCnt(self):
        return self._CompareYesterdayNotProtectMachineCnt

    @CompareYesterdayNotProtectMachineCnt.setter
    def CompareYesterdayNotProtectMachineCnt(self, CompareYesterdayNotProtectMachineCnt):
        self._CompareYesterdayNotProtectMachineCnt = CompareYesterdayNotProtectMachineCnt

    @property
    def CompareYesterdayDeadlineMachineCnt(self):
        return self._CompareYesterdayDeadlineMachineCnt

    @CompareYesterdayDeadlineMachineCnt.setter
    def CompareYesterdayDeadlineMachineCnt(self, CompareYesterdayDeadlineMachineCnt):
        self._CompareYesterdayDeadlineMachineCnt = CompareYesterdayDeadlineMachineCnt

    @property
    def DeadlineMachineCnt(self):
        return self._DeadlineMachineCnt

    @DeadlineMachineCnt.setter
    def DeadlineMachineCnt(self, DeadlineMachineCnt):
        self._DeadlineMachineCnt = DeadlineMachineCnt

    @property
    def NotProtectMachineCnt(self):
        return self._NotProtectMachineCnt

    @NotProtectMachineCnt.setter
    def NotProtectMachineCnt(self, NotProtectMachineCnt):
        self._NotProtectMachineCnt = NotProtectMachineCnt

    @property
    def LHGeneralDiscountCnt(self):
        return self._LHGeneralDiscountCnt

    @LHGeneralDiscountCnt.setter
    def LHGeneralDiscountCnt(self, LHGeneralDiscountCnt):
        self._LHGeneralDiscountCnt = LHGeneralDiscountCnt

    @property
    def CompareYesterdayMachineCnt(self):
        return self._CompareYesterdayMachineCnt

    @CompareYesterdayMachineCnt.setter
    def CompareYesterdayMachineCnt(self, CompareYesterdayMachineCnt):
        self._CompareYesterdayMachineCnt = CompareYesterdayMachineCnt

    @property
    def MachineDestroyAfterOfflineHours(self):
        return self._MachineDestroyAfterOfflineHours

    @MachineDestroyAfterOfflineHours.setter
    def MachineDestroyAfterOfflineHours(self, MachineDestroyAfterOfflineHours):
        self._MachineDestroyAfterOfflineHours = MachineDestroyAfterOfflineHours

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._MachineCnt = params.get("MachineCnt")
        self._TencentCloudMachineCnt = params.get("TencentCloudMachineCnt")
        self._AliCloudMachineCnt = params.get("AliCloudMachineCnt")
        self._BaiduCloudMachineCnt = params.get("BaiduCloudMachineCnt")
        self._IDCMachineCnt = params.get("IDCMachineCnt")
        self._OtherCloudMachineCnt = params.get("OtherCloudMachineCnt")
        self._ProtectMachineCnt = params.get("ProtectMachineCnt")
        self._BaseMachineCnt = params.get("BaseMachineCnt")
        self._SpecialtyMachineCnt = params.get("SpecialtyMachineCnt")
        self._FlagshipMachineCnt = params.get("FlagshipMachineCnt")
        self._RiskMachineCnt = params.get("RiskMachineCnt")
        self._CompareYesterdayRiskMachineCnt = params.get("CompareYesterdayRiskMachineCnt")
        self._CompareYesterdayNotProtectMachineCnt = params.get("CompareYesterdayNotProtectMachineCnt")
        self._CompareYesterdayDeadlineMachineCnt = params.get("CompareYesterdayDeadlineMachineCnt")
        self._DeadlineMachineCnt = params.get("DeadlineMachineCnt")
        self._NotProtectMachineCnt = params.get("NotProtectMachineCnt")
        self._LHGeneralDiscountCnt = params.get("LHGeneralDiscountCnt")
        self._CompareYesterdayMachineCnt = params.get("CompareYesterdayMachineCnt")
        self._MachineDestroyAfterOfflineHours = params.get("MachineDestroyAfterOfflineHours")
        self._RequestId = params.get("RequestId")


class DescribeMachineLicenseDetailRequest(AbstractModel):
    """DescribeMachineLicenseDetail request structure.

    """

    def __init__(self):
        r"""
        :param _Quuids: Host QUUID
        :type Quuids: list of str
        """
        self._Quuids = None

    @property
    def Quuids(self):
        return self._Quuids

    @Quuids.setter
    def Quuids(self, Quuids):
        self._Quuids = Quuids


    def _deserialize(self, params):
        self._Quuids = params.get("Quuids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMachineLicenseDetailResponse(AbstractModel):
    """DescribeMachineLicenseDetail response structure.

    """

    def __init__(self):
        r"""
        :param _MachineLicense: Authorization information
Note: This field may return null, indicating that no valid values can be obtained.
        :type MachineLicense: list of MachineLicenseDetail
        :param _TotalCount: Total number
Note: This field may return null, indicating that 