# -*- coding: utf8 -*-
# Copyright (c) 2017-2021 THL A29 Limited, a Tencent company. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class AddExternalSAMLIdPCertificateRequest(AbstractModel):
    """AddExternalSAMLIdPCertificate request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _X509Certificate: X509 certificate in PEM format, provided by the SAML identity provider.
        :type X509Certificate: str
        """
        self._ZoneId = None
        self._X509Certificate = None

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def X509Certificate(self):
        return self._X509Certificate

    @X509Certificate.setter
    def X509Certificate(self, X509Certificate):
        self._X509Certificate = X509Certificate


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._X509Certificate = params.get("X509Certificate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddExternalSAMLIdPCertificateResponse(AbstractModel):
    """AddExternalSAMLIdPCertificate response structure.

    """

    def __init__(self):
        r"""
        :param _CertificateId: SAML signing certificate ID.
        :type CertificateId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._CertificateId = None
        self._RequestId = None

    @property
    def CertificateId(self):
        return self._CertificateId

    @CertificateId.setter
    def CertificateId(self, CertificateId):
        self._CertificateId = CertificateId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._CertificateId = params.get("CertificateId")
        self._RequestId = params.get("RequestId")


class AddOrganizationNodeRequest(AbstractModel):
    """AddOrganizationNode request structure.

    """

    def __init__(self):
        r"""
        :param _ParentNodeId: Parent node ID, which can be obtained through [DescribeOrganizationNodes](https://intl.cloud.tencent.com/document/product/850/82926?from_cn_redirect=1).
        :type ParentNodeId: int
        :param _Name: Node name, which can contain up to 40 letters, digits, and symbols `+@&._[]-`.
        :type Name: str
        :param _Remark: Remarks.
        :type Remark: str
        :param _Tags: Department tag list, with a maximum of 10.
        :type Tags: list of Tag
        """
        self._ParentNodeId = None
        self._Name = None
        self._Remark = None
        self._Tags = None

    @property
    def ParentNodeId(self):
        return self._ParentNodeId

    @ParentNodeId.setter
    def ParentNodeId(self, ParentNodeId):
        self._ParentNodeId = ParentNodeId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Remark(self):
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._ParentNodeId = params.get("ParentNodeId")
        self._Name = params.get("Name")
        self._Remark = params.get("Remark")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddOrganizationNodeResponse(AbstractModel):
    """AddOrganizationNode response structure.

    """

    def __init__(self):
        r"""
        :param _NodeId: Node ID.
        :type NodeId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NodeId = None
        self._RequestId = None

    @property
    def NodeId(self):
        return self._NodeId

    @NodeId.setter
    def NodeId(self, NodeId):
        self._NodeId = NodeId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._NodeId = params.get("NodeId")
        self._RequestId = params.get("RequestId")


class AddPermissionPolicyToRoleConfigurationRequest(AbstractModel):
    """AddPermissionPolicyToRoleConfiguration request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _RoleConfigurationId: Permission configuration ID.
        :type RoleConfigurationId: str
        :param _RolePolicyType: Permission policy type. Valid values: System: system policy, namely the CAM system policy reused; Custom: custom policy, namely the custom policy prepared according to the CAM permission policy syntax and structure. Only the system policy is supported at the early stage, and the custom policy will be supported later.
        :type RolePolicyType: str
        :param _RolePolicyNames: Permission policy name, which includes up to 20 policies, each containing up to 32 characters.
        :type RolePolicyNames: list of str
        :param _RolePolicies: Policy details.
        :type RolePolicies: list of PolicyDetail
        :param _CustomPolicyDocument: Custom policy content, which contains up to 4096 characters. When RolePolicyType is Inline, this parameter must be configured. For details, see the permission policy syntax and structure.
        :type CustomPolicyDocument: str
        """
        self._ZoneId = None
        self._RoleConfigurationId = None
        self._RolePolicyType = None
        self._RolePolicyNames = None
        self._RolePolicies = None
        self._CustomPolicyDocument = None

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def RoleConfigurationId(self):
        return self._RoleConfigurationId

    @RoleConfigurationId.setter
    def RoleConfigurationId(self, RoleConfigurationId):
        self._RoleConfigurationId = RoleConfigurationId

    @property
    def RolePolicyType(self):
        return self._RolePolicyType

    @RolePolicyType.setter
    def RolePolicyType(self, RolePolicyType):
        self._RolePolicyType = RolePolicyType

    @property
    def RolePolicyNames(self):
        return self._RolePolicyNames

    @RolePolicyNames.setter
    def RolePolicyNames(self, RolePolicyNames):
        self._RolePolicyNames = RolePolicyNames

    @property
    def RolePolicies(self):
        return self._RolePolicies

    @RolePolicies.setter
    def RolePolicies(self, RolePolicies):
        self._RolePolicies = RolePolicies

    @property
    def CustomPolicyDocument(self):
        return self._CustomPolicyDocument

    @CustomPolicyDocument.setter
    def CustomPolicyDocument(self, CustomPolicyDocument):
        self._CustomPolicyDocument = CustomPolicyDocument


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._RoleConfigurationId = params.get("RoleConfigurationId")
        self._RolePolicyType = params.get("RolePolicyType")
        self._RolePolicyNames = params.get("RolePolicyNames")
        if params.get("RolePolicies") is not None:
            self._RolePolicies = []
            for item in params.get("RolePolicies"):
                obj = PolicyDetail()
                obj._deserialize(item)
                self._RolePolicies.append(obj)
        self._CustomPolicyDocument = params.get("CustomPolicyDocument")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddPermissionPolicyToRoleConfigurationResponse(AbstractModel):
    """AddPermissionPolicyToRoleConfiguration response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AddUserToGroupRequest(AbstractModel):
    """AddUserToGroup request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _GroupId: User group ID.
        :type GroupId: str
        :param _UserId: User ID.
        :type UserId: str
        """
        self._ZoneId = None
        self._GroupId = None
        self._UserId = None

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def GroupId(self):
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def UserId(self):
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._GroupId = params.get("GroupId")
        self._UserId = params.get("UserId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddUserToGroupResponse(AbstractModel):
    """AddUserToGroup response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AuthRelationFile(AbstractModel):
    """Real-name mutual trust application proof file.

    """

    def __init__(self):
        r"""
        :param _Name: File name.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Name: str
        :param _Url: File path.

Note: This field may return null, indicating that no valid values can be obtained.
        :type Url: str
        """
        self._Name = None
        self._Url = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Url(self):
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Url = params.get("Url")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BindOrganizationMemberAuthAccountRequest(AbstractModel):
    """BindOrganizationMemberAuthAccount request structure.

    """

    def __init__(self):
        r"""
        :param _MemberUin: Member UIN.
        :type MemberUin: int
        :param _PolicyId: Policy ID, which can be obtained by calling [DescribeOrganizationMemberPolicies](https://intl.cloud.tencent.com/document/product/850/82935?from_cn_redirect=1).
        :type PolicyId: int
        :param _OrgSubAccountUins: List of sub-account UINs of the organization admin, which can contain up to five UINs.
        :type OrgSubAccountUins: list of int
        """
        self._MemberUin = None
        self._PolicyId = None
        self._OrgSubAccountUins = None

    @property
    def MemberUin(self):
        return self._MemberUin

    @MemberUin.setter
    def MemberUin(self, MemberUin):
        self._MemberUin = MemberUin

    @property
    def PolicyId(self):
        return self._PolicyId

    @PolicyId.setter
    def PolicyId(self, PolicyId):
        self._PolicyId = PolicyId

    @property
    def OrgSubAccountUins(self):
        return self._OrgSubAccountUins

    @OrgSubAccountUins.setter
    def OrgSubAccountUins(self, OrgSubAccountUins):
        self._OrgSubAccountUins = OrgSubAccountUins


    def _deserialize(self, params):
        self._MemberUin = params.get("MemberUin")
        self._PolicyId = params.get("PolicyId")
        self._OrgSubAccountUins = params.get("OrgSubAccountUins")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BindOrganizationMemberAuthAccountResponse(AbstractModel):
    """BindOrganizationMemberAuthAccount response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CancelOrganizationMemberAuthAccountRequest(AbstractModel):
    """CancelOrganizationMemberAuthAccount request structure.

    """

    def __init__(self):
        r"""
        :param _MemberUin: Member UIN.
        :type MemberUin: int
        :param _PolicyId: Policy ID, which can be obtained through [DescribeOrganizationMemberPolicies](https://intl.cloud.tencent.com/document/product/850/82935?from_cn_redirect=1).
        :type PolicyId: int
        :param _OrgSubAccountUin: Organization sub-account UIN.
        :type OrgSubAccountUin: int
        """
        self._MemberUin = None
        self._PolicyId = None
        self._OrgSubAccountUin = None

    @property
    def MemberUin(self):
        return self._MemberUin

    @MemberUin.setter
    def MemberUin(self, MemberUin):
        self._MemberUin = MemberUin

    @property
    def PolicyId(self):
        return self._PolicyId

    @PolicyId.setter
    def PolicyId(self, PolicyId):
        self._PolicyId = PolicyId

    @property
    def OrgSubAccountUin(self):
        return self._OrgSubAccountUin

    @OrgSubAccountUin.setter
    def OrgSubAccountUin(self, OrgSubAccountUin):
        self._OrgSubAccountUin = OrgSubAccountUin


    def _deserialize(self, params):
        self._MemberUin = params.get("MemberUin")
        self._PolicyId = params.get("PolicyId")
        self._OrgSubAccountUin = params.get("OrgSubAccountUin")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CancelOrganizationMemberAuthAccountResponse(AbstractModel):
    """CancelOrganizationMemberAuthAccount response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ClearExternalSAMLIdentityProviderRequest(AbstractModel):
    """ClearExternalSAMLIdentityProvider request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        """
        self._ZoneId = None

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClearExternalSAMLIdentityProviderResponse(AbstractModel):
    """ClearExternalSAMLIdentityProvider response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateGroupRequest(AbstractModel):
    """CreateGroup request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _GroupName: User group name, which contains up to 128 characters, including English letters, digits, and special characters (-).
        :type GroupName: str
        :param _Description: User group description, which contains up to 1024 characters.
        :type Description: str
        """
        self._ZoneId = None
        self._GroupName = None
        self._Description = None

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def GroupName(self):
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._GroupName = params.get("GroupName")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateGroupResponse(AbstractModel):
    """CreateGroup response structure.

    """

    def __init__(self):
        r"""
        :param _GroupInfo: User group information.
        :type GroupInfo: :class:`tencentcloud.organization.v20210331.models.GroupInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._GroupInfo = None
        self._RequestId = None

    @property
    def GroupInfo(self):
        return self._GroupInfo

    @GroupInfo.setter
    def GroupInfo(self, GroupInfo):
        self._GroupInfo = GroupInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("GroupInfo") is not None:
            self._GroupInfo = GroupInfo()
            self._GroupInfo._deserialize(params.get("GroupInfo"))
        self._RequestId = params.get("RequestId")


class CreateOrgServiceAssignRequest(AbstractModel):
    """CreateOrgServiceAssign request structure.

    """

    def __init__(self):
        r"""
        :param _ServiceId: Organization service ID, which can be obtained through [ListOrganizationService](https://intl.cloud.tencent.com/document/product/850/109561?from_cn_redirect=1).
        :type ServiceId: int
        :param _MemberUins: Uin list of the delegated admins, including up to 20 items.
        :type MemberUins: list of int
        :param _ManagementScope: Management scope of the delegated admin. Valid values: 1 (all members), 2 (partial members). Default value: 1.
        :type ManagementScope: int
        :param _ManagementScopeUins: Uin list of the managed members. This parameter is valid when ManagementScope is 2.
        :type ManagementScopeUins: list of int
        :param _ManagementScopeNodeIds: ID list of the managed departments. This parameter is valid when ManagementScope is 2.
        :type ManagementScopeNodeIds: list of int
        """
        self._ServiceId = None
        self._MemberUins = None
        self._ManagementScope = None
        self._ManagementScopeUins = None
        self._ManagementScopeNodeIds = None

    @property
    def ServiceId(self):
        return self._ServiceId

    @ServiceId.setter
    def ServiceId(self, ServiceId):
        self._ServiceId = ServiceId

    @property
    def MemberUins(self):
        return self._MemberUins

    @MemberUins.setter
    def MemberUins(self, MemberUins):
        self._MemberUins = MemberUins

    @property
    def ManagementScope(self):
        return self._ManagementScope

    @ManagementScope.setter
    def ManagementScope(self, ManagementScope):
        self._ManagementScope = ManagementScope

    @property
    def ManagementScopeUins(self):
        return self._ManagementScopeUins

    @ManagementScopeUins.setter
    def ManagementScopeUins(self, ManagementScopeUins):
        self._ManagementScopeUins = ManagementScopeUins

    @property
    def ManagementScopeNodeIds(self):
        return self._ManagementScopeNodeIds

    @ManagementScopeNodeIds.setter
    def ManagementScopeNodeIds(self, ManagementScopeNodeIds):
        self._ManagementScopeNodeIds = ManagementScopeNodeIds


    def _deserialize(self, params):
        self._ServiceId = params.get("ServiceId")
        self._MemberUins = params.get("MemberUins")
        self._ManagementScope = params.get("ManagementScope")
        self._ManagementScopeUins = params.get("ManagementScopeUins")
        self._ManagementScopeNodeIds = params.get("ManagementScopeNodeIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOrgServiceAssignResponse(AbstractModel):
    """CreateOrgServiceAssign response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateOrganizationMemberPolicyRequest(AbstractModel):
    """CreateOrganizationMemberPolicy request structure.

    """

    def __init__(self):
        r"""
        :param _MemberUin: Member UIN.
        :type MemberUin: int
        :param _PolicyName: Policy name, which can contain up to 128 letters, digits, and symbols `+=,.@_-`.
        :type PolicyName: str
        :param _IdentityId: Member access identity ID, which can be obtained through [DescribeOrganizationMemberAuthIdentities](https://intl.cloud.tencent.com/document/product/850/82936?from_cn_redirect=1).
        :type IdentityId: int
        :param _Description: Description.
        :type Description: str
        """
        self._MemberUin = None
        self._PolicyName = None
        self._IdentityId = None
        self._Description = None

    @property
    def MemberUin(self):
        return self._MemberUin

    @MemberUin.setter
    def MemberUin(self, MemberUin):
        self._MemberUin = MemberUin

    @property
    def PolicyName(self):
        return self._PolicyName

    @PolicyName.setter
    def PolicyName(self, PolicyName):
        self._PolicyName = PolicyName

    @property
    def IdentityId(self):
        return self._IdentityId

    @IdentityId.setter
    def IdentityId(self, IdentityId):
        self._IdentityId = IdentityId

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._MemberUin = params.get("MemberUin")
        self._PolicyName = params.get("PolicyName")
        self._IdentityId = params.get("IdentityId")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOrganizationMemberPolicyResponse(AbstractModel):
    """CreateOrganizationMemberPolicy response structure.

    """

    def __init__(self):
        r"""
        :param _PolicyId: Policy ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :type PolicyId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._PolicyId = None
        self._RequestId = None

    @property
    def PolicyId(self):
        return self._PolicyId

    @PolicyId.setter
    def PolicyId(self, PolicyId):
        self._PolicyId = PolicyId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._PolicyId = params.get("PolicyId")
        self._RequestId = params.get("RequestId")


class CreateOrganizationMemberRequest(AbstractModel):
    """CreateOrganizationMember request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Member name, which can contain up to 25 letters, digits, and symbols `+@&._[]-:,`.
        :type Name: str
        :param _PolicyType: Relationship policy. Valid value: `Financial`.
        :type PolicyType: str
        :param _PermissionIds: List of member financial permission IDs. `7` indicates paying, which is the default value.
        :type PermissionIds: list of int non-negative
        :param _NodeId: Node ID of the member's department, which can be obtained through [DescribeOrganizationNodes](https://intl.cloud.tencent.com/document/product/850/82926?from_cn_redirect=1).
        :type NodeId: int
        :param _AccountName: Account name, which can contain up to 25 letters, digits, and symbols `+@&._[]-:,`.
        :type AccountName: str
        :param _Remark: Remarks.
        :type Remark: str
        :param _RecordId: Member creation record ID, which is required during retry upon creation exception.
        :type RecordId: int
        :param _PayUin: Payer UIN, which is required during paying for a member.
        :type PayUin: str
        :param _IdentityRoleID: List of member access identity IDs, which can be obtained through the `ListOrganizationIdentity` API. `1` indicates supported, which is the default value.
        :type IdentityRoleID: list of int non-negative
        :param _AuthRelationId: Verified entity relationship ID, which is required during creating members for different entities.
        :type AuthRelationId: int
        :param _Tags: Member tag list, with a maximum of 10.
        :type Tags: list of Tag
        """
        self._Name = None
        self._PolicyType = None
        self._PermissionIds = None
        self._NodeId = None
        self._AccountName = None
        self._Remark = None
        self._RecordId = None
        self._PayUin = None
        self._IdentityRoleID = None
        self._AuthRelationId = None
        self._Tags = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def PolicyType(self):
        return self._PolicyType

    @PolicyType.setter
    def PolicyType(self, PolicyType):
        self._PolicyType = PolicyType

    @property
    def PermissionIds(self):
        return self._PermissionIds

    @PermissionIds.setter
    def PermissionIds(self, PermissionIds):
        self._PermissionIds = PermissionIds

    @property
    def NodeId(self):
        return self._NodeId

    @NodeId.setter
    def NodeId(self, NodeId):
        self._NodeId = NodeId

    @property
    def AccountName(self):
        return self._AccountName

    @AccountName.setter
    def AccountName(self, AccountName):
        self._AccountName = AccountName

    @property
    def Remark(self):
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def RecordId(self):
        return self._RecordId

    @RecordId.setter
    def RecordId(self, RecordId):
        self._RecordId = RecordId

    @property
    def PayUin(self):
        return self._PayUin

    @PayUin.setter
    def PayUin(self, PayUin):
        self._PayUin = PayUin

    @property
    def IdentityRoleID(self):
        return self._IdentityRoleID

    @IdentityRoleID.setter
    def IdentityRoleID(self, IdentityRoleID):
        self._IdentityRoleID = IdentityRoleID

    @property
    def AuthRelationId(self):
        return self._AuthRelationId

    @AuthRelationId.setter
    def AuthRelationId(self, AuthRelationId):
        self._AuthRelationId = AuthRelationId

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._PolicyType = params.get("PolicyType")
        self._PermissionIds = params.get("PermissionIds")
        self._NodeId = params.get("NodeId")
        self._AccountName = params.get("AccountName")
        self._Remark = params.get("Remark")
        self._RecordId = params.get("RecordId")
        self._PayUin = params.get("PayUin")
        self._IdentityRoleID = params.get("IdentityRoleID")
        self._AuthRelationId = params.get("AuthRelationId")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOrganizationMemberResponse(AbstractModel):
    """CreateOrganizationMember response structure.

    """

    def __init__(self):
        r"""
        :param _Uin: Member UIN.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Uin: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Uin = None
        self._RequestId = None

    @property
    def Uin(self):
        return self._Uin

    @Uin.setter
    def Uin(self, Uin):
        self._Uin = Uin

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Uin = params.get("Uin")
        self._RequestId = params.get("RequestId")


class CreateRoleAssignmentRequest(AbstractModel):
    """CreateRoleAssignment request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _RoleAssignmentInfo: Authorized member account information, up to 50 entries.
        :type RoleAssignmentInfo: list of RoleAssignmentInfo
        """
        self._ZoneId = None
        self._RoleAssignmentInfo = None

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def RoleAssignmentInfo(self):
        return self._RoleAssignmentInfo

    @RoleAssignmentInfo.setter
    def RoleAssignmentInfo(self, RoleAssignmentInfo):
        self._RoleAssignmentInfo = RoleAssignmentInfo


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        if params.get("RoleAssignmentInfo") is not None:
            self._RoleAssignmentInfo = []
            for item in params.get("RoleAssignmentInfo"):
                obj = RoleAssignmentInfo()
                obj._deserialize(item)
                self._RoleAssignmentInfo.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRoleAssignmentResponse(AbstractModel):
    """CreateRoleAssignment response structure.

    """

    def __init__(self):
        r"""
        :param _Tasks: Task details.
        :type Tasks: list of TaskInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Tasks = None
        self._RequestId = None

    @property
    def Tasks(self):
        return self._Tasks

    @Tasks.setter
    def Tasks(self, Tasks):
        self._Tasks = Tasks

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Tasks") is not None:
            self._Tasks = []
            for item in params.get("Tasks"):
                obj = TaskInfo()
                obj._deserialize(item)
                self._Tasks.append(obj)
        self._RequestId = params.get("RequestId")


class CreateRoleConfigurationRequest(AbstractModel):
    """CreateRoleConfiguration request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _RoleConfigurationName: Access configuration name, which contains up to 128 characters, including English letters, digits, and hyphens (-).
        :type RoleConfigurationName: str
        :param _Description: Access configuration description, which contains up to 1024 characters.
        :type Description: str
        :param _SessionDuration: Session duration. It indicates the maximum session duration when CIC users use the access configuration to access the target account of the Tencent Cloud Organization. Unit: seconds. Value range: 900-43,200 (15 minutes to 12 hours). Default value: 3600 (1 hour).
        :type SessionDuration: int
        :param _RelayState: Initial access page. It indicates the initial access page URL when CIC users use the access configuration to access the target account of the Tencent Cloud Organization. This page must be the Tencent Cloud console page. The default is null, which indicates navigating to the home page of the Tencent Cloud console.
        :type RelayState: str
        """
        self._ZoneId = None
        self._RoleConfigurationName = None
        self._Description = None
        self._SessionDuration = None
        self._RelayState = None

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def RoleConfigurationName(self):
        return self._RoleConfigurationName

    @RoleConfigurationName.setter
    def RoleConfigurationName(self, RoleConfigurationName):
        self._RoleConfigurationName = RoleConfigurationName

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def SessionDuration(self):
        return self._SessionDuration

    @SessionDuration.setter
    def SessionDuration(self, SessionDuration):
        self._SessionDuration = SessionDuration

    @property
    def RelayState(self):
        return self._RelayState

    @RelayState.setter
    def RelayState(self, RelayState):
        self._RelayState = RelayState


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._RoleConfigurationName = params.get("RoleConfigurationName")
        self._Description = params.get("Description")
        self._SessionDuration = params.get("SessionDuration")
        self._RelayState = params.get("RelayState")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRoleConfigurationResponse(AbstractModel):
    """CreateRoleConfiguration response structure.

    """

    def __init__(self):
        r"""
        :param _RoleConfigurationInfo: Access configuration details.
        :type RoleConfigurationInfo: :class:`tencentcloud.organization.v20210331.models.RoleConfiguration`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RoleConfigurationInfo = None
        self._RequestId = None

    @property
    def RoleConfigurationInfo(self):
        return self._RoleConfigurationInfo

    @RoleConfigurationInfo.setter
    def RoleConfigurationInfo(self, RoleConfigurationInfo):
        self._RoleConfigurationInfo = RoleConfigurationInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RoleConfigurationInfo") is not None:
            self._RoleConfigurationInfo = RoleConfiguration()
            self._RoleConfigurationInfo._deserialize(params.get("RoleConfigurationInfo"))
        self._RequestId = params.get("RequestId")


class CreateUserRequest(AbstractModel):
    """CreateUser request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _UserName: User name, which must be unique within the space and cannot be modified. It contains up to 64 characters, including digits, English letters, and special characters such as plus signs (+), equal signs (=), commas (,), periods (.), at signs (@), hyphens (-), and underscores (_).
        :type UserName: str
        :param _FirstName: Last name of the user, which contains up to 64 characters.
        :type FirstName: str
        :param _LastName: First name of the user, which contains up to 64 characters.
        :type LastName: str
        :param _DisplayName: Display name of the user, which contains up to 256 characters.
        :type DisplayName: str
        :param _Description: User description, which contains up to 1024 characters.
        :type Description: str
        :param _Email: Email address of the user, which must be unique within the directory and contains up to 128 characters.
        :type Email: str
        :param _UserStatus: User status. Valid values: Enabled (default), Disabled.
        :type UserStatus: str
        """
        self._ZoneId = None
        self._UserName = None
        self._FirstName = None
        self._LastName = None
        self._DisplayName = None
        self._Description = None
        self._Email = None
        self._UserStatus = None

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def UserName(self):
        return self._UserName

    @UserName.setter
    def UserName(self, UserName):
        self._UserName = UserName

    @property
    def FirstName(self):
        return self._FirstName

    @FirstName.setter
    def FirstName(self, FirstName):
        self._FirstName = FirstName

    @property
    def LastName(self):
        return self._LastName

    @LastName.setter
    def LastName(self, LastName):
        self._LastName = LastName

    @property
    def DisplayName(self):
        return self._DisplayName

    @DisplayName.setter
    def DisplayName(self, DisplayName):
        self._DisplayName = DisplayName

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Email(self):
        return self._Email

    @Email.setter
    def Email(self, Email):
        self._Email = Email

    @property
    def UserStatus(self):
        return self._UserStatus

    @UserStatus.setter
    def UserStatus(self, UserStatus):
        self._UserStatus = UserStatus


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._UserName = params.get("UserName")
        self._FirstName = params.get("FirstName")
        self._LastName = params.get("LastName")
        self._DisplayName = params.get("DisplayName")
        self._Description = params.get("Description")
        self._Email = params.get("Email")
        self._UserStatus = params.get("UserStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateUserResponse(AbstractModel):
    """CreateUser response structure.

    """

    def __init__(self):
        r"""
        :param _UserInfo: User details.
        :type UserInfo: :class:`tencentcloud.organization.v20210331.models.UserInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._UserInfo = None
        self._RequestId = None

    @property
    def UserInfo(self):
        return self._UserInfo

    @UserInfo.setter
    def UserInfo(self, UserInfo):
        self._UserInfo = UserInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("UserInfo") is not None:
            self._UserInfo = UserInfo()
            self._UserInfo._deserialize(params.get("UserInfo"))
        self._RequestId = params.get("RequestId")


class CreateUserSyncProvisioningRequest(AbstractModel):
    """CreateUserSyncProvisioning request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _UserSyncProvisionings: CAM user synchronization information.
        :type UserSyncProvisionings: list of UserSyncProvisioning
        """
        self._ZoneId = None
        self._UserSyncProvisionings = None

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def UserSyncProvisionings(self):
        return self._UserSyncProvisionings

    @UserSyncProvisionings.setter
    def UserSyncProvisionings(self, UserSyncProvisionings):
        self._UserSyncProvisionings = UserSyncProvisionings


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        if params.get("UserSyncProvisionings") is not None:
            self._UserSyncProvisionings = []
            for item in params.get("UserSyncProvisionings"):
                obj = UserSyncProvisioning()
                obj._deserialize(item)
                self._UserSyncProvisionings.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateUserSyncProvisioningResponse(AbstractModel):
    """CreateUserSyncProvisioning response structure.

    """

    def __init__(self):
        r"""
        :param _Tasks: Task details.
        :type Tasks: list of UserProvisioningsTask
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Tasks = None
        self._RequestId = None

    @property
    def Tasks(self):
        return self._Tasks

    @Tasks.setter
    def Tasks(self, Tasks):
        self._Tasks = Tasks

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Tasks") is not None:
            self._Tasks = []
            for item in params.get("Tasks"):
                obj = UserProvisioningsTask()
                obj._deserialize(item)
                self._Tasks.append(obj)
        self._RequestId = params.get("RequestId")


class DeleteGroupRequest(AbstractModel):
    """DeleteGroup request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _GroupId: User group ID.
        :type GroupId: str
        """
        self._ZoneId = None
        self._GroupId = None

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def GroupId(self):
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._GroupId = params.get("GroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteGroupResponse(AbstractModel):
    """DeleteGroup response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteOrgServiceAssignRequest(AbstractModel):
    """DeleteOrgServiceAssign request structure.

    """

    def __init__(self):
        r"""
        :param _ServiceId: Organization service ID, which can be obtained through [ListOrganizationService](https://intl.cloud.tencent.com/document/product/850/109561?from_cn_redirect=1).
        :type ServiceId: int
        :param _MemberUin: Uin of the delegated admin.
        :type MemberUin: int
        """
        self._ServiceId = None
        self._MemberUin = None

    @property
    def ServiceId(self):
        return self._ServiceId

    @ServiceId.setter
    def ServiceId(self, ServiceId):
        self._ServiceId = ServiceId

    @property
    def MemberUin(self):
        return self._MemberUin

    @MemberUin.setter
    def MemberUin(self, MemberUin):
        self._MemberUin = MemberUin


    def _deserialize(self, params):
        self._ServiceId = params.get("ServiceId")
        self._MemberUin = params.get("MemberUin")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteOrgServiceAssignResponse(AbstractModel):
    """DeleteOrgServiceAssign response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteOrganizationMembersRequest(AbstractModel):
    """DeleteOrganizationMembers request structure.

    """

    def __init__(self):
        r"""
        :param _MemberUin: Uin list of the deleted members.
        :type MemberUin: list of int
        """
        self._MemberUin = None

    @property
    def MemberUin(self):
        return self._MemberUin

    @MemberUin.setter
    def MemberUin(self, MemberUin):
        self._MemberUin = MemberUin


    def _deserialize(self, params):
        self._MemberUin = params.get("MemberUin")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteOrganizationMembersResponse(AbstractModel):
    """DeleteOrganizationMembers response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteOrganizationNodesRequest(AbstractModel):
    """DeleteOrganizationNodes request structure.

    """

    def __init__(self):
        r"""
        :param _NodeId: Node ID list, which can be obtained through [DescribeOrganizationNodes](https://intl.cloud.tencent.com/document/product/850/82926?from_cn_redirect=1).
        :type NodeId: list of int
        """
        self._NodeId = None

    @property
    def NodeId(self):
        return self._NodeId

    @NodeId.setter
    def NodeId(self, NodeId):
        self._NodeId = NodeId


    def _deserialize(self, params):
        self._NodeId = params.get("NodeId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteOrganizationNodesResponse(AbstractModel):
    """DeleteOrganizationNodes response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteRoleAssignmentRequest(AbstractModel):
    """DeleteRoleAssignment request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _RoleConfigurationId: Permission configuration ID.
        :type RoleConfigurationId: str
        :param _TargetType: Type of the synchronized target account of the Tencent Cloud Organization. ManagerUin: admin account; MemberUin: member account.
        :type TargetType: str
        :param _TargetUin: UIN of the target account of the Tencent Cloud Organization.
        :type TargetUin: int
        :param _PrincipalType: Identity type for the CAM user synchronization. Valid values: User: indicates that the identity for the CAM user synchronization is a CIC user; Group: indicates that the identity for the CAM user synchronization is a CIC user group.
        :type PrincipalType: str
        :param _PrincipalId: Identity ID for the CAM user synchronization. Valid values: When the PrincipalType value is Group, it is the CIC user group ID (g-********). When the PrincipalType value is User, it is the CIC user ID (u-********).  	
        :type PrincipalId: str
        :param _DeprovisionStrategy: Whether to undeploy an access configuration synchronously when you remove the last authorization for using this access configuration on the target account of the Tencent Cloud Organization. Valid values: DeprovisionForLastRoleAssignmentOnAccount: Undeploy the access configuration; None (default): Do not undeploy access configuration.
        :type DeprovisionStrategy: str
        """
        self._ZoneId = None
        self._RoleConfigurationId = None
        self._TargetType = None
        self._TargetUin = None
        self._PrincipalType = None
        self._PrincipalId = None
        self._DeprovisionStrategy = None

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def RoleConfigurationId(self):
        return self._RoleConfigurationId

    @RoleConfigurationId.setter
    def RoleConfigurationId(self, RoleConfigurationId):
        self._RoleConfigurationId = RoleConfigurationId

    @property
    def TargetType(self):
        return self._TargetType

    @TargetType.setter
    def TargetType(self, TargetType):
        self._TargetType = TargetType

    @property
    def TargetUin(self):
        return self._TargetUin

    @TargetUin.setter
    def TargetUin(self, TargetUin):
        self._TargetUin = TargetUin

    @property
    def PrincipalType(self):
        return self._PrincipalType

    @PrincipalType.setter
    def PrincipalType(self, PrincipalType):
        self._PrincipalType = PrincipalType

    @property
    def PrincipalId(self):
        return self._PrincipalId

    @PrincipalId.setter
    def PrincipalId(self, PrincipalId):
        self._PrincipalId = PrincipalId

    @property
    def DeprovisionStrategy(self):
        return self._DeprovisionStrategy

    @DeprovisionStrategy.setter
    def DeprovisionStrategy(self, DeprovisionStrategy):
        self._DeprovisionStrategy = DeprovisionStrategy


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._RoleConfigurationId = params.get("RoleConfigurationId")
        self._TargetType = params.get("TargetType")
        self._TargetUin = params.get("TargetUin")
        self._PrincipalType = params.get("PrincipalType")
        self._PrincipalId = params.get("PrincipalId")
        self._DeprovisionStrategy = params.get("DeprovisionStrategy")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRoleAssignmentResponse(AbstractModel):
    """DeleteRoleAssignment response structure.

    """

    def __init__(self):
        r"""
        :param _Task: Task details.
        :type Task: :class:`tencentcloud.organization.v20210331.models.TaskInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Task = None
        self._RequestId = None

    @property
    def Task(self):
        return self._Task

    @Task.setter
    def Task(self, Task):
        self._Task = Task

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Task") is not None:
            self._Task = TaskInfo()
            self._Task._deserialize(params.get("Task"))
        self._RequestId = params.get("RequestId")


class DeleteRoleConfigurationRequest(AbstractModel):
    """DeleteRoleConfiguration request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _RoleConfigurationId: Permission configuration ID.
        :type RoleConfigurationId: str
        """
        self._ZoneId = None
        self._RoleConfigurationId = None

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def RoleConfigurationId(self):
        return self._RoleConfigurationId

    @RoleConfigurationId.setter
    def RoleConfigurationId(self, RoleConfigurationId):
        self._RoleConfigurationId = RoleConfigurationId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._RoleConfigurationId = params.get("RoleConfigurationId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRoleConfigurationResponse(AbstractModel):
    """DeleteRoleConfiguration response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteUserRequest(AbstractModel):
    """DeleteUser request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _UserId: User ID.
        :type UserId: str
        """
        self._ZoneId = None
        self._UserId = None

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def UserId(self):
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._UserId = params.get("UserId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteUserResponse(AbstractModel):
    """DeleteUser response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteUserSyncProvisioningRequest(AbstractModel):
    """DeleteUserSyncProvisioning request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _UserProvisioningId: User synchronization ID.
        :type UserProvisioningId: str
        """
        self._ZoneId = None
        self._UserProvisioningId = None

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def UserProvisioningId(self):
        return self._UserProvisioningId

    @UserProvisioningId.setter
    def UserProvisioningId(self, UserProvisioningId):
        self._UserProvisioningId = UserProvisioningId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._UserProvisioningId = params.get("UserProvisioningId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteUserSyncProvisioningResponse(AbstractModel):
    """DeleteUserSyncProvisioning response structure.

    """

    def __init__(self):
        r"""
        :param _Tasks: Task details.
        :type Tasks: :class:`tencentcloud.organization.v20210331.models.UserProvisioningsTask`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Tasks = None
        self._RequestId = None

    @property
    def Tasks(self):
        return self._Tasks

    @Tasks.setter
    def Tasks(self, Tasks):
        self._Tasks = Tasks

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Tasks") is not None:
            self._Tasks = UserProvisioningsTask()
            self._Tasks._deserialize(params.get("Tasks"))
        self._RequestId = params.get("RequestId")


class DescribeIdentityCenterRequest(AbstractModel):
    """DescribeIdentityCenter request structure.

    """


class DescribeIdentityCenterResponse(AbstractModel):
    """DescribeIdentityCenter response structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID, which starts with the z- prefix, followed by 12 random digits/lowercase letters.
        :type ZoneId: str
        :param _ZoneName: Space name, which must be globally unique and contain 2-64 characters including lowercase letters, digits, and hyphens (-). It can neither start or end with a hyphen (-) nor contain two consecutive hyphens (-).
        :type ZoneName: str
        :param _ServiceStatus: Service activation status. Disabled: not activated; Enabled: activated.
        :type ServiceStatus: str
        :param _ScimSyncStatus: SCIM synchronization status. Enabled: enabled. Disabled: disabled.
        :type ScimSyncStatus: str
        :param _CreateTime: Creation time
        :type CreateTime: str
        :param _UpdateTime: Update date
        :type UpdateTime: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ZoneId = None
        self._ZoneName = None
        self._ServiceStatus = None
        self._ScimSyncStatus = None
        self._CreateTime = None
        self._UpdateTime = None
        self._RequestId = None

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def ZoneName(self):
        return self._ZoneName

    @ZoneName.setter
    def ZoneName(self, ZoneName):
        self._ZoneName = ZoneName

    @property
    def ServiceStatus(self):
        return self._ServiceStatus

    @ServiceStatus.setter
    def ServiceStatus(self, ServiceStatus):
        self._ServiceStatus = ServiceStatus

    @property
    def ScimSyncStatus(self):
        return self._ScimSyncStatus

    @ScimSyncStatus.setter
    def ScimSyncStatus(self, ScimSyncStatus):
        self._ScimSyncStatus = ScimSyncStatus

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._ZoneName = params.get("ZoneName")
        self._ServiceStatus = params.get("ServiceStatus")
        self._ScimSyncStatus = params.get("ScimSyncStatus")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._RequestId = params.get("RequestId")


class DescribeOrganizationMemberAuthAccountsRequest(AbstractModel):
    """DescribeOrganizationMemberAuthAccounts request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Offset. Its value must be an integer multiple of the limit. Default value: 0.
        :type Offset: int
        :param _Limit: Limit. Value range: 1-50. Default value: 10.
        :type Limit: int
        :param _MemberUin: Member UIN.
        :type MemberUin: int
        :param _PolicyId: Policy ID, which can be obtained through [DescribeOrganizationMemberPolicies](https://intl.cloud.tencent.com/document/product/850/82935?from_cn_redirect=1).
        :type PolicyId: int
        """
        self._Offset = None
        self._Limit = None
        self._MemberUin = None
        self._PolicyId = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def MemberUin(self):
        return self._MemberUin

    @MemberUin.setter
    def MemberUin(self, MemberUin):
        self._MemberUin = MemberUin

    @property
    def PolicyId(self):
        return self._PolicyId

    @PolicyId.setter
    def PolicyId(self, PolicyId):
        self._PolicyId = PolicyId


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._MemberUin = params.get("MemberUin")
        self._PolicyId = params.get("PolicyId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOrganizationMemberAuthAccountsResponse(AbstractModel):
    """DescribeOrganizationMemberAuthAccounts response structure.

    """

    def __init__(self):
        r"""
        :param _Items: List
Note: This field may return null, indicating that no valid values can be obtained.
        :type Items: list of OrgMemberAuthAccount
        :param _Total: Total number
Note: This field may return null, indicating that no valid values can be obtained.
        :type Total: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Items = None
        self._Total = None
        self._RequestId = None

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = OrgMemberAuthAccount()
                obj._deserialize(item)
                self._Items.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeOrganizationMemberAuthIdentitiesRequest(AbstractModel):
    """DescribeOrganizationMemberAuthIdentities request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Offset, which is an integer multiple of the value of `Limit`. Default value: `0`.
        :type Offset: int
        :param _Limit: Limit, which defaults to `10`. Value range: 1-50.
        :type Limit: int
        :param _MemberUin: Uin of the organization member. At least one of the input parameters MemberUin and IdentityId must be entered.
        :type MemberUin: int
        :param _IdentityId: Identity ID. At least one of the input parameters MemberUin and IdentityId must be provided. It can be obtained through [ListOrganizationIdentity](https://intl.cloud.tencent.com/document/product/850/82934?from_cn_redirect=1).
        :type IdentityId: int
        """
        self._Offset = None
        self._Limit = None
        self._MemberUin = None
        self._IdentityId = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def MemberUin(self):
        return self._MemberUin

    @MemberUin.setter
    def MemberUin(self, MemberUin):
        self._MemberUin = MemberUin

    @property
    def IdentityId(self):
        return self._IdentityId

    @IdentityId.setter
    def IdentityId(self, IdentityId):
        self._IdentityId = IdentityId


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._MemberUin = params.get("MemberUin")
        self._IdentityId = params.get("IdentityId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOrganizationMemberAuthIdentitiesResponse(AbstractModel):
    """DescribeOrganizationMemberAuthIdentities response structure.

    """

    def __init__(self):
        r"""
        :param _Items: List of authorizable identities
Note: This field may return null, indicating that no valid values can be obtained.
        :type Items: list of OrgMemberAuthIdentity
        :param _Total: Total number.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Total: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Items = None
        self._Total = None
        self._RequestId = None

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = OrgMemberAuthIdentity()
                obj._deserialize(item)
                self._Items.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeOrganizationMemberPoliciesRequest(AbstractModel):
    """DescribeOrganizationMemberPolicies request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Offset. Its value must be an integer multiple of the limit. Default value: 0.
        :type Offset: int
        :param _Limit: Limit. Value range: 1-50. Default value: 10.
        :type Limit: int
        :param _MemberUin: Member UIN.
        :type MemberUin: int
        :param _SearchKey: Search keyword, which can be the policy name or description.
        :type SearchKey: str
        """
        self._Offset = None
        self._Limit = None
        self._MemberUin = None
        self._SearchKey = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def MemberUin(self):
        return self._MemberUin

    @MemberUin.setter
    def MemberUin(self, MemberUin):
        self._MemberUin = MemberUin

    @property
    def SearchKey(self):
        return self._SearchKey

    @SearchKey.setter
    def SearchKey(self, SearchKey):
        self._SearchKey = SearchKey


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._MemberUin = params.get("MemberUin")
        self._SearchKey = params.get("SearchKey")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOrganizationMemberPoliciesResponse(AbstractModel):
    """DescribeOrganizationMemberPolicies response structure.

    """

    def __init__(self):
        r"""
        :param _Items: List.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Items: list of OrgMemberPolicy
        :param _Total: Total number.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Total: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Items = None
        self._Total = None
        self._RequestId = None

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = OrgMemberPolicy()
                obj._deserialize(item)
                self._Items.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeOrganizationMembersRequest(AbstractModel):
    """DescribeOrganizationMembers request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Offset, which is an integer multiple of the value of `Limit`. Default value: `0`.
        :type Offset: int
        :param _Limit: Limit, which defaults to `10`. Value range: 1-50.
        :type Limit: int
        :param _Lang: Valid values: `en` (Tencent Cloud International); `zh` (Tencent Cloud).
        :type Lang: str
        :param _SearchKey: Search by member name or ID.
        :type SearchKey: str
        :param _AuthName: Entity name.
        :type AuthName: str
        :param _Product: Abbreviation of the trusted service, which is required during querying the trusted service admin.
        :type Product: str
        :param _Tags: Member tag search list, with a maximum of 10.
        :type Tags: list of Tag
        """
        self._Offset = None
        self._Limit = None
        self._Lang = None
        self._SearchKey = None
        self._AuthName = None
        self._Product = None
        self._Tags = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Lang(self):
        return self._Lang

    @Lang.setter
    def Lang(self, Lang):
        self._Lang = Lang

    @property
    def SearchKey(self):
        return self._SearchKey

    @SearchKey.setter
    def SearchKey(self, SearchKey):
        self._SearchKey = SearchKey

    @property
    def AuthName(self):
        return self._AuthName

    @AuthName.setter
    def AuthName(self, AuthName):
        self._AuthName = AuthName

    @property
    def Product(self):
        return self._Product

    @Product.setter
    def Product(self, Product):
        self._Product = Product

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Lang = params.get("Lang")
        self._SearchKey = params.get("SearchKey")
        self._AuthName = params.get("AuthName")
        self._Product = params.get("Product")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOrganizationMembersResponse(AbstractModel):
    """DescribeOrganizationMembers response structure.

    """

    def __init__(self):
        r"""
        :param _Items: Member list.
        :type Items: list of OrgMember
        :param _Total: Total number.
        :type Total: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Items = None
        self._Total = None
        self._RequestId = None

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = OrgMember()
                obj._deserialize(item)
                self._Items.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeOrganizationNodesRequest(AbstractModel):
    """DescribeOrganizationNodes request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Maximum number of returned results. Maximum value: `50`.
        :type Limit: int
        :param _Offset: Offset. Its value must be an integer multiple of the limit. Default value: 0.
        :type Offset: int
        :param _Tags: Department tag search list, with a maximum of 10.
        :type Tags: list of Tag
        """
        self._Limit = None
        self._Offset = None
        self._Tags = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOrganizationNodesResponse(AbstractModel):
    """DescribeOrganizationNodes response structure.

    """

    def __init__(self):
        r"""
        :param _Total: Total number.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Total: int
        :param _Items: List details.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Items: list of OrgNode
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Total = None
        self._Items = None
        self._RequestId = None

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = OrgNode()
                obj._deserialize(item)
                self._Items.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeOrganizationRequest(AbstractModel):
    """DescribeOrganization request structure.

    """

    def __init__(self):
        r"""
        :param _Lang: Valid values: `en` (Tencent Cloud International); `zh` (Tencent Cloud).
        :type Lang: str
        :param _Product: Abbreviation of the trusted service, which is required during querying the trusted service admin.
        :type Product: str
        """
        self._Lang = None
        self._Product = None

    @property
    def Lang(self):
        return self._Lang

    @Lang.setter
    def Lang(self, Lang):
        self._Lang = Lang

    @property
    def Product(self):
        return self._Product

    @Product.setter
    def Product(self, Product):
        self._Product = Product


    def _deserialize(self, params):
        self._Lang = params.get("Lang")
        self._Product = params.get("Product")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOrganizationResponse(AbstractModel):
    """DescribeOrganization response structure.

    """

    def __init__(self):
        r"""
        :param _OrgId: Organization ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :type OrgId: int
        :param _HostUin: Creator UIN.
Note: This field may return null, indicating that no valid values can be obtained.
        :type HostUin: int
        :param _NickName: Creator name.
Note: This field may return null, indicating that no valid values can be obtained.
        :type NickName: str
        :param _OrgType: Organization type.
Note: This field may return null, indicating that no valid values can be obtained.
        :type OrgType: int
        :param _IsManager: Whether the member is the organization admin. Valid values: `true` (yes); `false` (no).
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsManager: bool
        :param _OrgPolicyType: Policy type. Valid values: `Financial` (finance management).
Note: This field may return null, indicating that no valid values can be obtained.
        :type OrgPolicyType: str
        :param _OrgPolicyName: Policy name.
Note: This field may return null, indicating that no valid values can be obtained.
        :type OrgPolicyName: str
        :param _OrgPermission: List of member financial permissions.
Note: This field may return null, indicating that no valid values can be obtained.
        :type OrgPermission: list of OrgPermission
        :param _RootNodeId: Organization root node ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :type RootNodeId: int
        :param _CreateTime: Organization creation time.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        :param _JoinTime: Member joining time.
Note: This field may return null, indicating that no valid values can be obtained.
        :type JoinTime: str
        :param _IsAllowQuit: Whether the member is allowed to leave. Valid values: `Allow`, `Denied`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsAllowQuit: str
        :param _PayUin: Payer UIN.
Note: This field may return null, indicating that no valid values can be obtained.
        :type PayUin: str
        :param _PayName: Payer name.
Note: This field may return null, indicating that no valid values can be obtained.
        :type PayName: str
        :param _IsAssignManager: Whether the member is the trusted service admin. Valid values: `true` (yes); `false` (no).
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsAssignManager: bool
        :param _IsAuthManager: Whether the member is the verified entity admin. Valid values: `true` (yes); `false` (no).
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsAuthManager: bool
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._OrgId = None
        self._HostUin = None
        self._NickName = None
        self._OrgType = None
        self._IsManager = None
        self._OrgPolicyType = None
        self._OrgPolicyName = None
        self._OrgPermission = None
        self._RootNodeId = None
        self._CreateTime = None
        self._JoinTime = None
        self._IsAllowQuit = None
        self._PayUin = None
        self._PayName = None
        self._IsAssignManager = None
        self._IsAuthManager = None
        self._RequestId = None

    @property
    def OrgId(self):
        return self._OrgId

    @OrgId.setter
    def OrgId(self, OrgId):
        self._OrgId = OrgId

    @property
    def HostUin(self):
        return self._HostUin

    @HostUin.setter
    def HostUin(self, HostUin):
        self._HostUin = HostUin

    @property
    def NickName(self):
        return self._NickName

    @NickName.setter
    def NickName(self, NickName):
        self._NickName = NickName

    @property
    def OrgType(self):
        return self._OrgType

    @OrgType.setter
    def OrgType(self, OrgType):
        self._OrgType = OrgType

    @property
    def IsManager(self):
        return self._IsManager

    @IsManager.setter
    def IsManager(self, IsManager):
        self._IsManager = IsManager

    @property
    def OrgPolicyType(self):
        return self._OrgPolicyType

    @OrgPolicyType.setter
    def OrgPolicyType(self, OrgPolicyType):
        self._OrgPolicyType = OrgPolicyType

    @property
    def OrgPolicyName(self):
        return self._OrgPolicyName

    @OrgPolicyName.setter
    def OrgPolicyName(self, OrgPolicyName):
        self._OrgPolicyName = OrgPolicyName

    @property
    def OrgPermission(self):
        return self._OrgPermission

    @OrgPermission.setter
    def OrgPermission(self, OrgPermission):
        self._OrgPermission = OrgPermission

    @property
    def RootNodeId(self):
        return self._RootNodeId

    @RootNodeId.setter
    def RootNodeId(self, RootNodeId):
        self._RootNodeId = RootNodeId

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def JoinTime(self):
        return self._JoinTime

    @JoinTime.setter
    def JoinTime(self, JoinTime):
        self._JoinTime = JoinTime

    @property
    def IsAllowQuit(self):
        return self._IsAllowQuit

    @IsAllowQuit.setter
    def IsAllowQuit(self, IsAllowQuit):
        self._IsAllowQuit = IsAllowQuit

    @property
    def PayUin(self):
        return self._PayUin

    @PayUin.setter
    def PayUin(self, PayUin):
        self._PayUin = PayUin

    @property
    def PayName(self):
        return self._PayName

    @PayName.setter
    def PayName(self, PayName):
        self._PayName = PayName

    @property
    def IsAssignManager(self):
        return self._IsAssignManager

    @IsAssignManager.setter
    def IsAssignManager(self, IsAssignManager):
        self._IsAssignManager = IsAssignManager

    @property
    def IsAuthManager(self):
        return self._IsAuthManager

    @IsAuthManager.setter
    def IsAuthManager(self, IsAuthManager):
        self._IsAuthManager = IsAuthManager

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._OrgId = params.get("OrgId")
        self._HostUin = params.get("HostUin")
        self._NickName = params.get("NickName")
        self._OrgType = params.get("OrgType")
        self._IsManager = params.get("IsManager")
        self._OrgPolicyType = params.get("OrgPolicyType")
        self._OrgPolicyName = params.get("OrgPolicyName")
        if params.get("OrgPermission") is not None:
            self._OrgPermission = []
            for item in params.get("OrgPermission"):
                obj = OrgPermission()
                obj._deserialize(item)
                self._OrgPermission.append(obj)
        self._RootNodeId = params.get("RootNodeId")
        self._CreateTime = params.get("CreateTime")
        self._JoinTime = params.get("JoinTime")
        self._IsAllowQuit = params.get("IsAllowQuit")
        self._PayUin = params.get("PayUin")
        self._PayName = params.get("PayName")
        self._IsAssignManager = params.get("IsAssignManager")
        self._IsAuthManager = params.get("IsAuthManager")
        self._RequestId = params.get("RequestId")


class DismantleRoleConfigurationRequest(AbstractModel):
    """DismantleRoleConfiguration request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _RoleConfigurationId: Permission configuration ID.
        :type RoleConfigurationId: str
        :param _TargetType: Type of the synchronized target account of the Tencent Cloud Organization. ManagerUin: admin account; MemberUin: member account.
        :type TargetType: str
        :param _TargetUin: UIN of the synchronized target account of the Tencent Cloud Organization.
        :type TargetUin: int
        """
        self._ZoneId = None
        self._RoleConfigurationId = None
        self._TargetType = None
        self._TargetUin = None

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def RoleConfigurationId(self):
        return self._RoleConfigurationId

    @RoleConfigurationId.setter
    def RoleConfigurationId(self, RoleConfigurationId):
        self._RoleConfigurationId = RoleConfigurationId

    @property
    def TargetType(self):
        return self._TargetType

    @TargetType.setter
    def TargetType(self, TargetType):
        self._TargetType = TargetType

    @property
    def TargetUin(self):
        return self._TargetUin

    @TargetUin.setter
    def TargetUin(self, TargetUin):
        self._TargetUin = TargetUin


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._RoleConfigurationId = params.get("RoleConfigurationId")
        self._TargetType = params.get("TargetType")
        self._TargetUin = params.get("TargetUin")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DismantleRoleConfigurationResponse(AbstractModel):
    """DismantleRoleConfiguration response structure.

    """

    def __init__(self):
        r"""
        :param _Task: Task details.
        :type Task: :class:`tencentcloud.organization.v20210331.models.RoleProvisioningsTask`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Task = None
        self._RequestId = None

    @property
    def Task(self):
        return self._Task

    @Task.setter
    def Task(self, Task):
        self._Task = Task

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Task") is not None:
            self._Task = RoleProvisioningsTask()
            self._Task._deserialize(params.get("Task"))
        self._RequestId = params.get("RequestId")


class GetExternalSAMLIdentityProviderRequest(AbstractModel):
    """GetExternalSAMLIdentityProvider request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        """
        self._ZoneId = None

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetExternalSAMLIdentityProviderResponse(AbstractModel):
    """GetExternalSAMLIdentityProvider response structure.

    """

    def __init__(self):
        r"""
        :param _SAMLIdentityProviderConfiguration: SAML identity provider configuration information.
        :type SAMLIdentityProviderConfiguration: :class:`tencentcloud.organization.v20210331.models.SAMLIdentityProviderConfiguration`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SAMLIdentityProviderConfiguration = None
        self._RequestId = None

    @property
    def SAMLIdentityProviderConfiguration(self):
        return self._SAMLIdentityProviderConfiguration

    @SAMLIdentityProviderConfiguration.setter
    def SAMLIdentityProviderConfiguration(self, SAMLIdentityProviderConfiguration):
        self._SAMLIdentityProviderConfiguration = SAMLIdentityProviderConfiguration

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SAMLIdentityProviderConfiguration") is not None:
            self._SAMLIdentityProviderConfiguration = SAMLIdentityProviderConfiguration()
            self._SAMLIdentityProviderConfiguration._deserialize(params.get("SAMLIdentityProviderConfiguration"))
        self._RequestId = params.get("RequestId")


class GetGroupRequest(AbstractModel):
    """GetGroup request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _GroupId: User group ID.
        :type GroupId: str
        """
        self._ZoneId = None
        self._GroupId = None

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def GroupId(self):
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._GroupId = params.get("GroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetGroupResponse(AbstractModel):
    """GetGroup response structure.

    """

    def __init__(self):
        r"""
        :param _GroupInfo: User group information.
        :type GroupInfo: :class:`tencentcloud.organization.v20210331.models.GroupInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._GroupInfo = None
        self._RequestId = None

    @property
    def GroupInfo(self):
        return self._GroupInfo

    @GroupInfo.setter
    def GroupInfo(self, GroupInfo):
        self._GroupInfo = GroupInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("GroupInfo") is not None:
            self._GroupInfo = GroupInfo()
            self._GroupInfo._deserialize(params.get("GroupInfo"))
        self._RequestId = params.get("RequestId")


class GetProvisioningTaskStatusRequest(AbstractModel):
    """GetProvisioningTaskStatus request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _TaskId: Task ID.
        :type TaskId: str
        """
        self._ZoneId = None
        self._TaskId = None

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetProvisioningTaskStatusResponse(AbstractModel):
    """GetProvisioningTaskStatus response structure.

    """

    def __init__(self):
        r"""
        :param _TaskStatus: Task status information.
        :type TaskStatus: :class:`tencentcloud.organization.v20210331.models.TaskStatus`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskStatus = None
        self._RequestId = None

    @property
    def TaskStatus(self):
        return self._TaskStatus

    @TaskStatus.setter
    def TaskStatus(self, TaskStatus):
        self._TaskStatus = TaskStatus

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TaskStatus") is not None:
            self._TaskStatus = TaskStatus()
            self._TaskStatus._deserialize(params.get("TaskStatus"))
        self._RequestId = params.get("RequestId")


class GetRoleConfigurationRequest(AbstractModel):
    """GetRoleConfiguration request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _RoleConfigurationId: Permission configuration ID.
        :type RoleConfigurationId: str
        """
        self._ZoneId = None
        self._RoleConfigurationId = None

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def RoleConfigurationId(self):
        return self._RoleConfigurationId

    @RoleConfigurationId.setter
    def RoleConfigurationId(self, RoleConfigurationId):
        self._RoleConfigurationId = RoleConfigurationId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._RoleConfigurationId = params.get("RoleConfigurationId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetRoleConfigurationResponse(AbstractModel):
    """GetRoleConfiguration response structure.

    """

    def __init__(self):
        r"""
        :param _RoleConfigurationInfo: Permission configuration details.
        :type RoleConfigurationInfo: :class:`tencentcloud.organization.v20210331.models.RoleConfiguration`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RoleConfigurationInfo = None
        self._RequestId = None

    @property
    def RoleConfigurationInfo(self):
        return self._RoleConfigurationInfo

    @RoleConfigurationInfo.setter
    def RoleConfigurationInfo(self, RoleConfigurationInfo):
        self._RoleConfigurationInfo = RoleConfigurationInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RoleConfigurationInfo") is not None:
            self._RoleConfigurationInfo = RoleConfiguration()
            self._RoleConfigurationInfo._deserialize(params.get("RoleConfigurationInfo"))
        self._RequestId = params.get("RequestId")


class GetTaskStatusRequest(AbstractModel):
    """GetTaskStatus request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _TaskId: Task ID.
        :type TaskId: str
        """
        self._ZoneId = None
        self._TaskId = None

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetTaskStatusResponse(AbstractModel):
    """GetTaskStatus response structure.

    """

    def __init__(self):
        r"""
        :param _TaskStatus: Task status information.
        :type TaskStatus: :class:`tencentcloud.organization.v20210331.models.TaskStatus`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskStatus = None
        self._RequestId = None

    @property
    def TaskStatus(self):
        return self._TaskStatus

    @TaskStatus.setter
    def TaskStatus(self, TaskStatus):
        self._TaskStatus = TaskStatus

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TaskStatus") is not None:
            self._TaskStatus = TaskStatus()
            self._TaskStatus._deserialize(params.get("TaskStatus"))
        self._RequestId = params.get("RequestId")


class GetUserRequest(AbstractModel):
    """GetUser request structure.

    """

    def __init__(self):
        r"""
        :param _UserId: User ID.
        :type UserId: str
        :param _ZoneId: Space ID.
        :type ZoneId: str
        """
        self._UserId = None
        self._ZoneId = None

    @property
    def UserId(self):
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId


    def _deserialize(self, params):
        self._UserId = params.get("UserId")
        self._ZoneId = params.get("ZoneId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetUserResponse(AbstractModel):
    """GetUser response structure.

    """

    def __init__(self):
        r"""
        :param _UserInfo: User information.
        :type UserInfo: :class:`tencentcloud.organization.v20210331.models.UserInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._UserInfo = None
        self._RequestId = None

    @property
    def UserInfo(self):
        return self._UserInfo

    @UserInfo.setter
    def UserInfo(self, UserInfo):
        self._UserInfo = UserInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("UserInfo") is not None:
            self._UserInfo = UserInfo()
            self._UserInfo._deserialize(params.get("UserInfo"))
        self._RequestId = params.get("RequestId")


class GetUserSyncProvisioningRequest(AbstractModel):
    """GetUserSyncProvisioning request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _UserProvisioningId: ID of the CAM user synchronization.
        :type UserProvisioningId: str
        """
        self._ZoneId = None
        self._UserProvisioningId = None

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def UserProvisioningId(self):
        return self._UserProvisioningId

    @UserProvisioningId.setter
    def UserProvisioningId(self, UserProvisioningId):
        self._UserProvisioningId = UserProvisioningId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._UserProvisioningId = params.get("UserProvisioningId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetUserSyncProvisioningResponse(AbstractModel):
    """GetUserSyncProvisioning response structure.

    """

    def __init__(self):
        r"""
        :param _UserProvisioning: CAM user synchronization information.
        :type UserProvisioning: :class:`tencentcloud.organization.v20210331.models.UserProvisioning`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._UserProvisioning = None
        self._RequestId = None

    @property
    def UserProvisioning(self):
        return self._UserProvisioning

    @UserProvisioning.setter
    def UserProvisioning(self, UserProvisioning):
        self._UserProvisioning = UserProvisioning

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("UserProvisioning") is not None:
            self._UserProvisioning = UserProvisioning()
            self._UserProvisioning._deserialize(params.get("UserProvisioning"))
        self._RequestId = params.get("RequestId")


class GetZoneSAMLServiceProviderInfoRequest(AbstractModel):
    """GetZoneSAMLServiceProviderInfo request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        """
        self._ZoneId = None

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetZoneSAMLServiceProviderInfoResponse(AbstractModel):
    """GetZoneSAMLServiceProviderInfo response structure.

    """

    def __init__(self):
        r"""
        :param _SAMLServiceProvider: SAML service provider configuration information.
        :type SAMLServiceProvider: :class:`tencentcloud.organization.v20210331.models.SAMLServiceProvider`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SAMLServiceProvider = None
        self._RequestId = None

    @property
    def SAMLServiceProvider(self):
        return self._SAMLServiceProvider

    @SAMLServiceProvider.setter
    def SAMLServiceProvider(self, SAMLServiceProvider):
        self._SAMLServiceProvider = SAMLServiceProvider

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SAMLServiceProvider") is not None:
            self._SAMLServiceProvider = SAMLServiceProvider()
            self._SAMLServiceProvider._deserialize(params.get("SAMLServiceProvider"))
        self._RequestId = params.get("RequestId")


class GetZoneStatisticsRequest(AbstractModel):
    """GetZoneStatistics request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        """
        self._ZoneId = None

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetZoneStatisticsResponse(AbstractModel):
    """GetZoneStatistics response structure.

    """

    def __init__(self):
        r"""
        :param _ZoneStatistics: Space statistics.
        :type ZoneStatistics: :class:`tencentcloud.organization.v20210331.models.ZoneStatistics`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ZoneStatistics = None
        self._RequestId = None

    @property
    def ZoneStatistics(self):
        return self._ZoneStatistics

    @ZoneStatistics.setter
    def ZoneStatistics(self, ZoneStatistics):
        self._ZoneStatistics = ZoneStatistics

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ZoneStatistics") is not None:
            self._ZoneStatistics = ZoneStatistics()
            self._ZoneStatistics._deserialize(params.get("ZoneStatistics"))
        self._RequestId = params.get("RequestId")


class GroupInfo(AbstractModel):
    """User group information.

    """

    def __init__(self):
        r"""
        :param _GroupName: User group name.
        :type GroupName: str
        :param _Description: User group description.
        :type Description: str
        :param _CreateTime: Creation time of the user group.
        :type CreateTime: str
        :param _GroupType: User group type. Manual: manually created; Synchronized: externally imported.
        :type GroupType: str
        :param _UpdateTime: Modification time of the user group.
        :type UpdateTime: str
        :param _GroupId: User group ID.
        :type GroupId: str
        :param _MemberCount: Number of group members.
        :type MemberCount: int
        :param _IsSelected: If the input parameter FilterUsers is provided, return true when the user is in the user group; otherwise, return false.
        :type IsSelected: bool
        """
        self._GroupName = None
        self._Description = None
        self._CreateTime = None
        self._GroupType = None
        self._UpdateTime = None
        self._GroupId = None
        self._MemberCount = None
        self._IsSelected = None

    @property
    def GroupName(self):
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def GroupType(self):
        return self._GroupType

    @GroupType.setter
    def GroupType(self, GroupType):
        self._GroupType = GroupType

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def GroupId(self):
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def MemberCount(self):
        return self._MemberCount

    @MemberCount.setter
    def MemberCount(self, MemberCount):
        self._MemberCount = MemberCount

    @property
    def IsSelected(self):
        return self._IsSelected

    @IsSelected.setter
    def IsSelected(self, IsSelected):
        self._IsSelected = IsSelected


    def _deserialize(self, params):
        self._GroupName = params.get("GroupName")
        self._Description = params.get("Description")
        self._CreateTime = params.get("CreateTime")
        self._GroupType = params.get("GroupType")
        self._UpdateTime = params.get("UpdateTime")
        self._GroupId = params.get("GroupId")
        self._MemberCount = params.get("MemberCount")
        self._IsSelected = params.get("IsSelected")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GroupMembers(AbstractModel):
    """User information.

    """

    def __init__(self):
        r"""
        :param _UserName: Queried username.
        :type UserName: str
        :param _DisplayName: Display name of the user.
        :type DisplayName: str
        :param _Description: User description.
        :type Description: str
        :param _Email: Email address of the user, which must be unique within the directory.
        :type Email: str
        :param _UserStatus: User status: Enabled, Disabled.
        :type UserStatus: str
        :param _UserType: User type. Manual: manually created; Synchronized: externally imported.
        :type UserType: str
        :param _UserId: User ID.
        :type UserId: str
        :param _JoinTime: Time when the user joins the user group.
        :type JoinTime: str
        """
        self._UserName = None
        self._DisplayName = None
        self._Description = None
        self._Email = None
        self._UserStatus = None
        self._UserType = None
        self._UserId = None
        self._JoinTime = None

    @property
    def UserName(self):
        return self._UserName

    @UserName.setter
    def UserName(self, UserName):
        self._UserName = UserName

    @property
    def DisplayName(self):
        return self._DisplayName

    @DisplayName.setter
    def DisplayName(self, DisplayName):
        self._DisplayName = DisplayName

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Email(self):
        return self._Email

    @Email.setter
    def Email(self, Email):
        self._Email = Email

    @property
    def UserStatus(self):
        return self._UserStatus

    @UserStatus.setter
    def UserStatus(self, UserStatus):
        self._UserStatus = UserStatus

    @property
    def UserType(self):
        return self._UserType

    @UserType.setter
    def UserType(self, UserType):
        self._UserType = UserType

    @property
    def UserId(self):
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def JoinTime(self):
        return self._JoinTime

    @JoinTime.setter
    def JoinTime(self, JoinTime):
        self._JoinTime = JoinTime


    def _deserialize(self, params):
        self._UserName = params.get("UserName")
        self._DisplayName = params.get("DisplayName")
        self._Description = params.get("Description")
        self._Email = params.get("Email")
        self._UserStatus = params.get("UserStatus")
        self._UserType = params.get("UserType")
        self._UserId = params.get("UserId")
        self._JoinTime = params.get("JoinTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class IdentityPolicy(AbstractModel):
    """Organization identity policy

    """

    def __init__(self):
        r"""
        :param _PolicyId: CAM preset policy ID, which is valid and required when PolicyType is a preset policy.
        :type PolicyId: int
        :param _PolicyName: CAM preset policy name, which is valid and required when PolicyType is a preset policy.
        :type PolicyName: str
        :param _PolicyType: Policy type. Valid values: 1 (custom policy), 2 (preset policy). The default is 2.
Note: This field may return null, indicating that no valid values can be obtained.
        :type PolicyType: int
        :param _PolicyDocument: Custom policy content, which follows the CAM policy syntax. It is valid and required when PolicyType is a custom policy.
Note: This field may return null, indicating that no valid values can be obtained.
        :type PolicyDocument: str
        """
        self._PolicyId = None
        self._PolicyName = None
        self._PolicyType = None
        self._PolicyDocument = None

    @property
    def PolicyId(self):
        return self._PolicyId

    @PolicyId.setter
    def PolicyId(self, PolicyId):
        self._PolicyId = PolicyId

    @property
    def PolicyName(self):
        return self._PolicyName

    @PolicyName.setter
    def PolicyName(self, PolicyName):
        self._PolicyName = PolicyName

    @property
    def PolicyType(self):
        return self._PolicyType

    @PolicyType.setter
    def PolicyType(self, PolicyType):
        self._PolicyType = PolicyType

    @property
    def PolicyDocument(self):
        return self._PolicyDocument

    @PolicyDocument.setter
    def PolicyDocument(self, PolicyDocument):
        self._PolicyDocument = PolicyDocument


    def _deserialize(self, params):
        self._PolicyId = params.get("PolicyId")
        self._PolicyName = params.get("PolicyName")
        self._PolicyType = params.get("PolicyType")
        self._PolicyDocument = params.get("PolicyDocument")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InviteOrganizationMemberRequest(AbstractModel):
    """InviteOrganizationMember request structure.

    """

    def __init__(self):
        r"""
        :param _MemberUin: UIN of an invited account.
        :type MemberUin: int
        :param _Name: Member name, which contains up to 25 characters, including English letters, digits, and symbols `+@&._[]-:,`.
        :type Name: str
        :param _PolicyType: Relationship policy. Valid value: `Financial`.
        :type PolicyType: str
        :param _PermissionIds: List of member financial permission IDs. Valid values: 1: View bills. 2: View balance. 3: Transfer funds. 4: Consolidate bills. 5: Issue invoice. 6: Inherit discounts. 7: Pay on behalf. 1 and 2 are required by default.
        :type PermissionIds: list of int non-negative
        :param _NodeId: Node ID of the member's department, which can be obtained through [DescribeOrganizationNodes](https://intl.cloud.tencent.com/document/product/850/82926?from_cn_redirect=1).
        :type NodeId: int
        :param _Remark: Remarks.
        :type Remark: str
        :param _IsAllowQuit: Whether to allow a member to exit. Valid values: Allow, Denied.
        :type IsAllowQuit: str
        :param _PayUin: Payer UIN, which is required when pay-on-behalf mode is used.
        :type PayUin: str
        :param _RelationAuthName: Name of a mutual trust real-name entity.
        :type RelationAuthName: str
        :param _AuthFile: List of proof files of a mutual trust entity.
        :type AuthFile: list of AuthRelationFile
        :param _Tags: Member tag list, with a maximum of 10.
        :type Tags: list of Tag
        """
        self._MemberUin = None
        self._Name = None
        self._PolicyType = None
        self._PermissionIds = None
        self._NodeId = None
        self._Remark = None
        self._IsAllowQuit = None
        self._PayUin = None
        self._RelationAuthName = None
        self._AuthFile = None
        self._Tags = None

    @property
    def MemberUin(self):
        return self._MemberUin

    @MemberUin.setter
    def MemberUin(self, MemberUin):
        self._MemberUin = MemberUin

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def PolicyType(self):
        return self._PolicyType

    @PolicyType.setter
    def PolicyType(self, PolicyType):
        self._PolicyType = PolicyType

    @property
    def PermissionIds(self):
        return self._PermissionIds

    @PermissionIds.setter
    def PermissionIds(self, PermissionIds):
        self._PermissionIds = PermissionIds

    @property
    def NodeId(self):
        return self._NodeId

    @NodeId.setter
    def NodeId(self, NodeId):
        self._NodeId = NodeId

    @property
    def Remark(self):
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def IsAllowQuit(self):
        return self._IsAllowQuit

    @IsAllowQuit.setter
    def IsAllowQuit(self, IsAllowQuit):
        self._IsAllowQuit = IsAllowQuit

    @property
    def PayUin(self):
        return self._PayUin

    @PayUin.setter
    def PayUin(self, PayUin):
        self._PayUin = PayUin

    @property
    def RelationAuthName(self):
        return self._RelationAuthName

    @RelationAuthName.setter
    def RelationAuthName(self, RelationAuthName):
        self._RelationAuthName = RelationAuthName

    @property
    def AuthFile(self):
        return self._AuthFile

    @AuthFile.setter
    def AuthFile(self, AuthFile):
        self._AuthFile = AuthFile

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._MemberUin = params.get("MemberUin")
        self._Name = params.get("Name")
        self._PolicyType = params.get("PolicyType")
        self._PermissionIds = params.get("PermissionIds")
        self._NodeId = params.get("NodeId")
        self._Remark = params.get("Remark")
        self._IsAllowQuit = params.get("IsAllowQuit")
        self._PayUin = params.get("PayUin")
        self._RelationAuthName = params.get("RelationAuthName")
        if params.get("AuthFile") is not None:
            self._AuthFile = []
            for item in params.get("AuthFile"):
                obj = AuthRelationFile()
                obj._deserialize(item)
                self._AuthFile.append(obj)
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InviteOrganizationMemberResponse(AbstractModel):
    """InviteOrganizationMember response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class JoinedGroups(AbstractModel):
    """User group joined by the user.

    """

    def __init__(self):
        r"""
        :param _GroupName: User group name.
        :type GroupName: str
        :param _Description: User group description.
        :type Description: str
        :param _GroupId: User group ID.
        :type GroupId: str
        :param _GroupType: User group type. Valid values:

Manual: manually created.
Synchronized: externally synchronized.
        :type GroupType: str
        :param _JoinTime: Time of joining the user group.
        :type JoinTime: str
        """
        self._GroupName = None
        self._Description = None
        self._GroupId = None
        self._GroupType = None
        self._JoinTime = None

    @property
    def GroupName(self):
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def GroupId(self):
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def GroupType(self):
        return self._GroupType

    @GroupType.setter
    def GroupType(self, GroupType):
        self._GroupType = GroupType

    @property
    def JoinTime(self):
        return self._JoinTime

    @JoinTime.setter
    def JoinTime(self, JoinTime):
        self._JoinTime = JoinTime


    def _deserialize(self, params):
        self._GroupName = params.get("GroupName")
        self._Description = params.get("Description")
        self._GroupId = params.get("GroupId")
        self._GroupType = params.get("GroupType")
        self._JoinTime = params.get("JoinTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ListExternalSAMLIdPCertificatesRequest(AbstractModel):
    """ListExternalSAMLIdPCertificates request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        """
        self._ZoneId = None

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ListExternalSAMLIdPCertificatesResponse(AbstractModel):
    """ListExternalSAMLIdPCertificates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCounts: Total number of data entries that meet the request parameter conditions.
        :type TotalCounts: int
        :param _SAMLIdPCertificates: SAML signing certificate list.
        :type SAMLIdPCertificates: list of SAMLIdPCertificate
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCounts = None
        self._SAMLIdPCertificates = None
        self._RequestId = None

    @property
    def TotalCounts(self):
        return self._TotalCounts

    @TotalCounts.setter
    def TotalCounts(self, TotalCounts):
        self._TotalCounts = TotalCounts

    @property
    def SAMLIdPCertificates(self):
        return self._SAMLIdPCertificates

    @SAMLIdPCertificates.setter
    def SAMLIdPCertificates(self, SAMLIdPCertificates):
        self._SAMLIdPCertificates = SAMLIdPCertificates

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCounts = params.get("TotalCounts")
        if params.get("SAMLIdPCertificates") is not None:
            self._SAMLIdPCertificates = []
            for item in params.get("SAMLIdPCertificates"):
                obj = SAMLIdPCertificate()
                obj._deserialize(item)
                self._SAMLIdPCertificates.append(obj)
        self._RequestId = params.get("RequestId")


class ListGroupMembersRequest(AbstractModel):
    """ListGroupMembers request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _GroupId: User ID.
        :type GroupId: str
        :param _NextToken: Token for querying the next page of returned results. During use of the API for the first time, NextToken is not needed. When you call the API for the first time, if the total number of returned data entries exceeds the MaxResults limit, the data is truncated and only MaxResults data entries are returned. Meanwhile, the return parameter IsTruncated is true and a NextToken is returned. You can use the NextToken returned last time to continue calling the API with other request parameters unchanged, to query the truncated data. You can use this method for multiple queries until IsTruncated is false, indicating that all data has been queried.
        :type NextToken: str
        :param _MaxResults: Maximum number of data entries per page. Value range: 1-100. Default value: 10.
        :type MaxResults: int
        :param _UserType: Type of the user. Manual: manually created; Synchronized: imported from external sources.
        :type UserType: str
        """
        self._ZoneId = None
        self._GroupId = None
        self._NextToken = None
        self._MaxResults = None
        self._UserType = None

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def GroupId(self):
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def NextToken(self):
        return self._NextToken

    @NextToken.setter
    def NextToken(self, NextToken):
        self._NextToken = NextToken

    @property
    def MaxResults(self):
        return self._MaxResults

    @MaxResults.setter
    def MaxResults(self, MaxResults):
        self._MaxResults = MaxResults

    @property
    def UserType(self):
        return self._UserType

    @UserType.setter
    def UserType(self, UserType):
        self._UserType = UserType


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._GroupId = params.get("GroupId")
        self._NextToken = params.get("NextToken")
        self._MaxResults = params.get("MaxResults")
        self._UserType = params.get("UserType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ListGroupMembersResponse(AbstractModel):
    """ListGroupMembers response structure.

    """

    def __init__(self):
        r"""
        :param _NextToken: Token for querying the next page of returned results. Note: This parameter is displayed only when IsTruncated is true.
        :type NextToken: str
        :param _TotalCounts: Total number of data entries that meet the request parameter conditions.
        :type TotalCounts: int
        :param _MaxResults: Maximum number of data entries per page.
        :type MaxResults: int
        :param _IsTruncated: Whether the returned result is truncated. Valid values: true: truncated; false: not truncated.
        :type IsTruncated: bool
        :param _GroupMembers: The user list of a user group.
        :type GroupMembers: list of GroupMembers
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NextToken = None
        self._TotalCounts = None
        self._MaxResults = None
        self._IsTruncated = None
        self._GroupMembers = None
        self._RequestId = None

    @property
    def NextToken(self):
        return self._NextToken

    @NextToken.setter
    def NextToken(self, NextToken):
        self._NextToken = NextToken

    @property
    def TotalCounts(self):
        return self._TotalCounts

    @TotalCounts.setter
    def TotalCounts(self, TotalCounts):
        self._TotalCounts = TotalCounts

    @property
    def MaxResults(self):
        return self._MaxResults

    @MaxResults.setter
    def MaxResults(self, MaxResults):
        self._MaxResults = MaxResults

    @property
    def IsTruncated(self):
        return self._IsTruncated

    @IsTruncated.setter
    def IsTruncated(self, IsTruncated):
        self._IsTruncated = IsTruncated

    @property
    def GroupMembers(self):
        return self._GroupMembers

    @GroupMembers.setter
    def GroupMembers(self, GroupMembers):
        self._GroupMembers = GroupMembers

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._NextToken = params.get("NextToken")
        self._TotalCounts = params.get("TotalCounts")
        self._MaxResults = params.get("MaxResults")
        self._IsTruncated = params.get("IsTruncated")
        if params.get("GroupMembers") is not None:
            self._GroupMembers = []
            for item in params.get("GroupMembers"):
                obj = GroupMembers()
                obj._deserialize(item)
                self._GroupMembers.append(obj)
        self._RequestId = params.get("RequestId")


class ListGroupsRequest(AbstractModel):
    """ListGroups request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _NextToken: Token for querying the next page of returned results. During use of the API for the first time, NextToken is not needed. When you call the API for the first time, if the total number of returned data entries exceeds the MaxResults limit, the data is truncated and only MaxResults data entries are returned. Meanwhile, the return parameter IsTruncated is true and a NextToken is returned. You can use the NextToken returned last time to continue calling the API with other request parameters unchanged, to query the truncated data. You can use this method for multiple queries until IsTruncated is false, indicating that all data has been queried.
        :type NextToken: str
        :param _MaxResults: Maximum number of data entries per page. Value range: 1-100. Default value: 10.
        :type MaxResults: int
        :param _Filter: Filter criterion. Format: <Attribute> <Operator> <Value>, case-insensitive. Currently, <Attribute> supports only GroupName, and <Operator> supports only eq (Equals) and sw (Start With). For example, Filter = "GroupName sw test" indicates querying all user groups with names starting with test; Filter = "GroupName eq testgroup" indicates querying the user group with the name testgroup.
        :type Filter: str
        :param _GroupType: User group type. Manual: manually created; Synchronized: externally imported.
        :type GroupType: str
        :param _FilterUsers: Filtered user. IsSelected=1 will be returned for the user group associated with this user.
        :type FilterUsers: list of str
        :param _SortField: Sorting field, which currently only supports CreateTime. The default is the CreateTime field.
        :type SortField: str
        :param _SortType: Sorting type. Desc: descending order; Asc: ascending order. It should be set along with SortField.
        :type SortType: str
        """
        self._ZoneId = None
        self._NextToken = None
        self._MaxResults = None
        self._Filter = None
        self._GroupType = None
        self._FilterUsers = None
        self._SortField = None
        self._SortType = None

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def NextToken(self):
        return self._NextToken

    @NextToken.setter
    def NextToken(self, NextToken):
        self._NextToken = NextToken

    @property
    def MaxResults(self):
        return self._MaxResults

    @MaxResults.setter
    def MaxResults(self, MaxResults):
        self._MaxResults = MaxResults

    @property
    def Filter(self):
        return self._Filter

    @Filter.setter
    def Filter(self, Filter):
        self._Filter = Filter

    @property
    def GroupType(self):
        return self._GroupType

    @GroupType.setter
    def GroupType(self, GroupType):
        self._GroupType = GroupType

    @property
    def FilterUsers(self):
        return self._FilterUsers

    @FilterUsers.setter
    def FilterUsers(self, FilterUsers):
        self._FilterUsers = FilterUsers

    @property
    def SortField(self):
        return self._SortField

    @SortField.setter
    def SortField(self, SortField):
        self._SortField = SortField

    @property
    def SortType(self):
        return self._SortType

    @SortType.setter
    def SortType(self, SortType):
        self._SortType = SortType


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._NextToken = params.get("NextToken")
        self._MaxResults = params.get("MaxResults")
        self._Filter = params.get("Filter")
        self._GroupType = params.get("GroupType")
        self._FilterUsers = params.get("FilterUsers")
        self._SortField = params.get("SortField")
        self._SortType = params.get("SortType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ListGroupsResponse(AbstractModel):
    """ListGroups response structure.

    """

    def __init__(self):
        r"""
        :param _NextToken: Token for querying the next page of returned results. Note: This parameter is displayed only when IsTruncated is true.
        :type NextToken: str
        :param _Groups: User group list.
        :type Groups: list of GroupInfo
        :param _MaxResults: Maximum number of data entries per page.
        :type MaxResults: int
        :param _TotalCounts: Total number of data entries that meet the request parameter conditions.
        :type TotalCounts: int
        :param _IsTruncated: Whether the returned result is truncated. Valid values: true: truncated; false: not truncated.
        :type IsTruncated: bool
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NextToken = None
        self._Groups = None
        self._MaxResults = None
        self._TotalCounts = None
        self._IsTruncated = None
        self._RequestId = None

    @property
    def NextToken(self):
        return self._NextToken

    @NextToken.setter
    def NextToken(self, NextToken):
        self._NextToken = NextToken

    @property
    def Groups(self):
        return self._Groups

    @Groups.setter
    def Groups(self, Groups):
        self._Groups = Groups

    @property
    def MaxResults(self):
        return self._MaxResults

    @MaxResults.setter
    def MaxResults(self, MaxResults):
        self._MaxResults = MaxResults

    @property
    def TotalCounts(self):
        return self._TotalCounts

    @TotalCounts.setter
    def TotalCounts(self, TotalCounts):
        self._TotalCounts = TotalCounts

    @property
    def IsTruncated(self):
        return self._IsTruncated

    @IsTruncated.setter
    def IsTruncated(self, IsTruncated):
        self._IsTruncated = IsTruncated

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._NextToken = params.get("NextToken")
        if params.get("Groups") is not None:
            self._Groups = []
            for item in params.get("Groups"):
                obj = GroupInfo()
                obj._deserialize(item)
                self._Groups.append(obj)
        self._MaxResults = params.get("MaxResults")
        self._TotalCounts = params.get("TotalCounts")
        self._IsTruncated = params.get("IsTruncated")
        self._RequestId = params.get("RequestId")


class ListJoinedGroupsForUserRequest(AbstractModel):
    """ListJoinedGroupsForUser request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _UserId: User ID
        :type UserId: str
        :param _NextToken: Token for querying the next page of returned results. During use of the API for the first time, NextToken is not needed. When you call the API for the first time, if the total number of returned data entries exceeds the MaxResults limit, the data is truncated and only MaxResults data entries are returned. Meanwhile, the return parameter IsTruncated is true and a NextToken is returned. You can use the NextToken returned last time to continue calling the API with other request parameters unchanged, to query the truncated data. You can use this method for multiple queries until IsTruncated is false, indicating that all data has been queried.
        :type NextToken: str
        :param _MaxResults: Maximum number of data entries per page. Value range: 1-100. Default value: 10.
        :type MaxResults: int
        """
        self._ZoneId = None
        self._UserId = None
        self._NextToken = None
        self._MaxResults = None

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def UserId(self):
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def NextToken(self):
        return self._NextToken

    @NextToken.setter
    def NextToken(self, NextToken):
        self._NextToken = NextToken

    @property
    def MaxResults(self):
        return self._MaxResults

    @MaxResults.setter
    def MaxResults(self, MaxResults):
        self._MaxResults = MaxResults


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._UserId = params.get("UserId")
        self._NextToken = params.get("NextToken")
        self._MaxResults = params.get("MaxResults")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ListJoinedGroupsForUserResponse(AbstractModel):
    """ListJoinedGroupsForUser response structure.

    """

    def __init__(self):
        r"""
        :param _NextToken: Token for querying the next page of returned results. Note: This parameter is displayed only when IsTruncated is true.
        :type NextToken: str
        :param _TotalCounts: Total number of data entries that meet the request parameter conditions.
        :type TotalCounts: int
        :param _MaxResults: Maximum number of data entries per page.
        :type MaxResults: int
        :param _IsTruncated: Whether the returned result is truncated. Valid values: true: truncated; false: not truncated.
        :type IsTruncated: bool
        :param _JoinedGroups: List of user groups joined by the user.
        :type JoinedGroups: list of JoinedGroups
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NextToken = None
        self._TotalCounts = None
        self._MaxResults = None
        self._IsTruncated = None
        self._JoinedGroups = None
        self._RequestId = None

    @property
    def NextToken(self):
        return self._NextToken

    @NextToken.setter
    def NextToken(self, NextToken):
        self._NextToken = NextToken

    @property
    def TotalCounts(self):
        return self._TotalCounts

    @TotalCounts.setter
    def TotalCounts(self, TotalCounts):
        self._TotalCounts = TotalCounts

    @property
    def MaxResults(self):
        return self._MaxResults

    @MaxResults.setter
    def MaxResults(self, MaxResults):
        self._MaxResults = MaxResults

    @property
    def IsTruncated(self):
        return self._IsTruncated

    @IsTruncated.setter
    def IsTruncated(self, IsTruncated):
        self._IsTruncated = IsTruncated

    @property
    def JoinedGroups(self):
        return self._JoinedGroups

    @JoinedGroups.setter
    def JoinedGroups(self, JoinedGroups):
        self._JoinedGroups = JoinedGroups

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._NextToken = params.get("NextToken")
        self._TotalCounts = params.get("TotalCounts")
        self._MaxResults = params.get("MaxResults")
        self._IsTruncated = params.get("IsTruncated")
        if params.get("JoinedGroups") is not None:
            self._JoinedGroups = []
            for item in params.get("JoinedGroups"):
                obj = JoinedGroups()
                obj._deserialize(item)
                self._JoinedGroups.append(obj)
        self._RequestId = params.get("RequestId")


class ListOrgServiceAssignMemberRequest(AbstractModel):
    """ListOrgServiceAssignMember request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Offset. Its value must be an integer multiple of the limit. Default value: 0.
        :type Offset: int
        :param _Limit: Limit. Value range: 1-50. Default value: 10.
        :type Limit: int
        :param _ServiceId: Organization service ID, which can be obtained through [ListOrganizationService](https://intl.cloud.tencent.com/document/product/850/109561?from_cn_redirect=1).
        :type ServiceId: int
        """
        self._Offset = None
        self._Limit = None
        self._ServiceId = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def ServiceId(self):
        return self._ServiceId

    @ServiceId.setter
    def ServiceId(self, ServiceId):
        self._ServiceId = ServiceId


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._ServiceId = params.get("ServiceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ListOrgServiceAssignMemberResponse(AbstractModel):
    """ListOrgServiceAssignMember response structure.

    """

    def __init__(self):
        r"""
        :param _Total: Total quantity.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Total: int
        :param _Items: List of the delegated admins.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Items: list of OrganizationServiceAssignMember
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Total = None
        self._Items = None
        self._RequestId = None

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = OrganizationServiceAssignMember()
                obj._deserialize(item)
                self._Items.append(obj)
        self._RequestId = params.get("RequestId")


class ListOrganizationIdentityRequest(AbstractModel):
    """ListOrganizationIdentity request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Offset.  It must be an integer multiple of the value of `Limit`.  Default value: `0`.
        :type Offset: int
        :param _Limit: The limit for the number of query results.  Value range:  1-50.  Default value:  `10`.
        :type Limit: int
        :param _SearchKey: Search by name.
        :type SearchKey: str
        :param _IdentityId: Identity ID, which can be searched by identity ID.
        :type IdentityId: int
        :param _IdentityType: Identity type.  Valid values: `1` (Preset), `2` (Custom).
        :type IdentityType: int
        """
        self._Offset = None
        self._Limit = None
        self._SearchKey = None
        self._IdentityId = None
        self._IdentityType = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def SearchKey(self):
        return self._SearchKey

    @SearchKey.setter
    def SearchKey(self, SearchKey):
        self._SearchKey = SearchKey

    @property
    def IdentityId(self):
        return self._IdentityId

    @IdentityId.setter
    def IdentityId(self, IdentityId):
        self._IdentityId = IdentityId

    @property
    def IdentityType(self):
        return self._IdentityType

    @IdentityType.setter
    def IdentityType(self, IdentityType):
        self._IdentityType = IdentityType


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._SearchKey = params.get("SearchKey")
        self._IdentityId = params.get("IdentityId")
        self._IdentityType = params.get("IdentityType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ListOrganizationIdentityResponse(AbstractModel):
    """ListOrganizationIdentity response structure.

    """

    def __init__(self):
        r"""
        :param _Total: Total number.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Total: int
        :param _Items: Item details.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Items: list of OrgIdentity
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Total = None
        self._Items = None
        self._RequestId = None

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = OrgIdentity()
                obj._deserialize(item)
                self._Items.append(obj)
        self._RequestId = params.get("RequestId")


class ListOrganizationServiceRequest(AbstractModel):
    """ListOrganizationService request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Offset. Its value must be an integer multiple of the limit. Default value: 0.
        :type Offset: int
        :param _Limit: Limit. Value range: 1-50. Default value: 10.
        :type Limit: int
        :param _SearchKey: Keyword for search by name.
        :type SearchKey: str
        """
        self._Offset = None
        self._Limit = None
        self._SearchKey = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def SearchKey(self):
        return self._SearchKey

    @SearchKey.setter
    def SearchKey(self, SearchKey):
        self._SearchKey = SearchKey


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._SearchKey = params.get("SearchKey")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ListOrganizationServiceResponse(AbstractModel):
    """ListOrganizationService response structure.

    """

    def __init__(self):
        r"""
        :param _Total: Total quantity.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Total: int
        :param _Items: Organization service list.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Items: list of OrganizationServiceAssign
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Total = None
        self._Items = None
        self._RequestId = None

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = OrganizationServiceAssign()
                obj._deserialize(item)
                self._Items.append(obj)
        self._RequestId = params.get("RequestId")


class ListPermissionPoliciesInRoleConfigurationRequest(AbstractModel):
    """ListPermissionPoliciesInRoleConfiguration request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _RoleConfigurationId: Permission configuration ID.
        :type RoleConfigurationId: str
        :param _RolePolicyType: Permission policy type. Valid values: System: system policy, namely the CAM system policy reused; Custom: custom policy, namely the custom policy prepared according to the CAM permission policy syntax and structure.
        :type RolePolicyType: str
        :param _Filter: Search by policy name.
        :type Filter: str
        """
        self._ZoneId = None
        self._RoleConfigurationId = None
        self._RolePolicyType = None
        self._Filter = None

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def RoleConfigurationId(self):
        return self._RoleConfigurationId

    @RoleConfigurationId.setter
    def RoleConfigurationId(self, RoleConfigurationId):
        self._RoleConfigurationId = RoleConfigurationId

    @property
    def RolePolicyType(self):
        return self._RolePolicyType

    @RolePolicyType.setter
    def RolePolicyType(self, RolePolicyType):
        self._RolePolicyType = RolePolicyType

    @property
    def Filter(self):
        return self._Filter

    @Filter.setter
    def Filter(self, Filter):
        self._Filter = Filter


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._RoleConfigurationId = params.get("RoleConfigurationId")
        self._RolePolicyType = params.get("RolePolicyType")
        self._Filter = params.get("Filter")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ListPermissionPoliciesInRoleConfigurationResponse(AbstractModel):
    """ListPermissionPoliciesInRoleConfiguration response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCounts: Total number of permission policies.
        :type TotalCounts: int
        :param _RolePolicies: Permission policy list.
        :type RolePolicies: list of RolePolicie
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCounts = None
        self._RolePolicies = None
        self._RequestId = None

    @property
    def TotalCounts(self):
        return self._TotalCounts

    @TotalCounts.setter
    def TotalCounts(self, TotalCounts):
        self._TotalCounts = TotalCounts

    @property
    def RolePolicies(self):
        return self._RolePolicies

    @RolePolicies.setter
    def RolePolicies(self, RolePolicies):
        self._RolePolicies = RolePolicies

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCounts = params.get("TotalCounts")
        if params.get("RolePolicies") is not None:
            self._RolePolicies = []
            for item in params.get("RolePolicies"):
                obj = RolePolicie()
                obj._deserialize(item)
                self._RolePolicies.append(obj)
        self._RequestId = params.get("RequestId")


class ListRoleAssignmentsRequest(AbstractModel):
    """ListRoleAssignments request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _RoleConfigurationId: Permission configuration ID.
        :type RoleConfigurationId: str
        :param _MaxResults: Maximum number of data entries per page. Value range: 1-100. Default value: 10.
        :type MaxResults: int
        :param _NextToken: Token for querying the next page of returned results. During use of the API for the first time, NextToken is not needed. When you call the API for the first time, if the total number of returned data entries exceeds the MaxResults limit, the data is truncated and only MaxResults data entries are returned. Meanwhile, the return parameter IsTruncated is true and a NextToken is returned. You can use the NextToken returned last time to continue calling the API with other request parameters unchanged, to query the truncated data. You can use this method for multiple queries until IsTruncated is false, indicating that all data has been queried.
        :type NextToken: str
        :param _TargetType: Type of the synchronized target account of the Tencent Cloud Organization. ManagerUin: admin account; MemberUin: member account.
        :type TargetType: str
        :param _TargetUin: UIN of the synchronized target account of the Tencent Cloud Organization.
        :type TargetUin: int
        :param _PrincipalType: Identity type for the CAM user synchronization. Valid values: User: indicates that the identity for the CAM user synchronization is a CIC user; Group: indicates that the identity for the CAM user synchronization is a CIC user group.
        :type PrincipalType: str
        :param _PrincipalId: Identity ID for the CAM user synchronization. Valid values: When the PrincipalType value is Group, it is the CIC user group ID (g-********). When the PrincipalType value is User, it is the CIC user ID (u-********).
        :type PrincipalId: str
        :param _Filter: Query condition, which currently only supports search by permission configuration name.
        :type Filter: str
        """
        self._ZoneId = None
        self._RoleConfigurationId = None
        self._MaxResults = None
        self._NextToken = None
        self._TargetType = None
        self._TargetUin = None
        self._PrincipalType = None
        self._PrincipalId = None
        self._Filter = None

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def RoleConfigurationId(self):
        return self._RoleConfigurationId

    @RoleConfigurationId.setter
    def RoleConfigurationId(self, RoleConfigurationId):
        self._RoleConfigurationId = RoleConfigurationId

    @property
    def MaxResults(self):
        return self._MaxResults

    @MaxResults.setter
    def MaxResults(self, MaxResults):
        self._MaxResults = MaxResults

    @property
    def NextToken(self):
        return self._NextToken

    @NextToken.setter
    def NextToken(self, NextToken):
        self._NextToken = NextToken

    @property
    def TargetType(self):
        return self._TargetType

    @TargetType.setter
    def TargetType(self, TargetType):
        self._TargetType = TargetType

    @property
    def TargetUin(self):
        return self._TargetUin

    @TargetUin.setter
    def TargetUin(self, TargetUin):
        self._TargetUin = TargetUin

    @property
    def PrincipalType(self):
        return self._PrincipalType

    @PrincipalType.setter
    def PrincipalType(self, PrincipalType):
        self._PrincipalType = PrincipalType

    @property
    def PrincipalId(self):
        return self._PrincipalId

    @PrincipalId.setter
    def PrincipalId(self, PrincipalId):
        self._PrincipalId = PrincipalId

    @property
    def Filter(self):
        return self._Filter

    @Filter.setter
    def Filter(self, Filter):
        self._Filter = Filter


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._RoleConfigurationId = params.get("RoleConfigurationId")
        self._MaxResults = params.get("MaxResults")
        self._NextToken = params.get("NextToken")
        self._TargetType = params.get("TargetType")
        self._TargetUin = params.get("TargetUin")
        self._PrincipalType = params.get("PrincipalType")
        self._PrincipalId = params.get("PrincipalId")
        self._Filter = params.get("Filter")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ListRoleAssignmentsResponse(AbstractModel):
    """ListRoleAssignments response structure.

    """

    def __init__(self):
        r"""
        :param _NextToken: Token for querying the next page of returned results. Note: This parameter is displayed only when IsTruncated is true.
        :type NextToken: str
        :param _TotalCounts: Total number of data entries that meet the request parameter conditions.
        :type TotalCounts: int
        :param _MaxResults: Maximum number of data entries per page.
        :type MaxResults: int
        :param _IsTruncated: Whether the returned result is truncated. Valid values: true: truncated; false: not truncated.
        :type IsTruncated: bool
        :param _RoleAssignments: Authorization list of the target account of the Tencent Cloud Organization.
        :type RoleAssignments: list of RoleAssignments
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NextToken = None
        self._TotalCounts = None
        self._MaxResults = None
        self._IsTruncated = None
        self._RoleAssignments = None
        self._RequestId = None

    @property
    def NextToken(self):
        return self._NextToken

    @NextToken.setter
    def NextToken(self, NextToken):
        self._NextToken = NextToken

    @property
    def TotalCounts(self):
        return self._TotalCounts

    @TotalCounts.setter
    def TotalCounts(self, TotalCounts):
        self._TotalCounts = TotalCounts

    @property
    def MaxResults(self):
        return self._MaxResults

    @MaxResults.setter
    def MaxResults(self, MaxResults):
        self._MaxResults = MaxResults

    @property
    def IsTruncated(self):
        return self._IsTruncated

    @IsTruncated.setter
    def IsTruncated(self, IsTruncated):
        self._IsTruncated = IsTruncated

    @property
    def RoleAssignments(self):
        return self._RoleAssignments

    @RoleAssignments.setter
    def RoleAssignments(self, RoleAssignments):
        self._RoleAssignments = RoleAssignments

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._NextToken = params.get("NextToken")
        self._TotalCounts = params.get("TotalCounts")
        self._MaxResults = params.get("MaxResults")
        self._IsTruncated = params.get("IsTruncated")
        if params.get("RoleAssignments") is not None:
            self._RoleAssignments = []
            for item in params.get("RoleAssignments"):
                obj = RoleAssignments()
                obj._deserialize(item)
                self._RoleAssignments.append(obj)
        self._RequestId = params.get("RequestId")


class ListRoleConfigurationProvisioningsRequest(AbstractModel):
    """ListRoleConfigurationProvisionings request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _RoleConfigurationId: Permission configuration ID.
        :type RoleConfigurationId: str
        :param _MaxResults: Maximum number of data entries per page. Value range: 1-100. Default value: 10.
        :type MaxResults: int
        :param _NextToken: Token for querying the next page of returned results. During use of the API for the first time, NextToken is not needed. When you call the API for the first time, if the total number of returned data entries exceeds the MaxResults limit, the data is truncated and only MaxResults data entries are returned. Meanwhile, the return parameter IsTruncated is true and a NextToken is returned. You can use the NextToken returned last time to continue calling the API with other request parameters unchanged, to query the truncated data. You can use this method for multiple queries until IsTruncated is false, indicating that all data has been queried.
        :type NextToken: str
        :param _TargetType: Type of the synchronized target account of the Tencent Cloud Organization. ManagerUin: admin account; MemberUin: member account.
        :type TargetType: str
        :param _TargetUin: UIN of the synchronized target account of the Tencent Cloud Organization.
        :type TargetUin: int
        :param _DeploymentStatus: Deployed: Deployment succeeded; DeployedRequired: Redeployment required; DeployFailed: Deployment failed.
        :type DeploymentStatus: str
        :param _Filter: Search by configuration name is supported.
        :type Filter: str
        """
        self._ZoneId = None
        self._RoleConfigurationId = None
        self._MaxResults = None
        self._NextToken = None
        self._TargetType = None
        self._TargetUin = None
        self._DeploymentStatus = None
        self._Filter = None

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def RoleConfigurationId(self):
        return self._RoleConfigurationId

    @RoleConfigurationId.setter
    def RoleConfigurationId(self, RoleConfigurationId):
        self._RoleConfigurationId = RoleConfigurationId

    @property
    def MaxResults(self):
        return self._MaxResults

    @MaxResults.setter
    def MaxResults(self, MaxResults):
        self._MaxResults = MaxResults

    @property
    def NextToken(self):
        return self._NextToken

    @NextToken.setter
    def NextToken(self, NextToken):
        self._NextToken = NextToken

    @property
    def TargetType(self):
        return self._TargetType

    @TargetType.setter
    def TargetType(self, TargetType):
        self._TargetType = TargetType

    @property
    def TargetUin(self):
        return self._TargetUin

    @TargetUin.setter
    def TargetUin(self, TargetUin):
        self._TargetUin = TargetUin

    @property
    def DeploymentStatus(self):
        return self._DeploymentStatus

    @DeploymentStatus.setter
    def DeploymentStatus(self, DeploymentStatus):
        self._DeploymentStatus = DeploymentStatus

    @property
    def Filter(self):
        return self._Filter

    @Filter.setter
    def Filter(self, Filter):
        self._Filter = Filter


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._RoleConfigurationId = params.get("RoleConfigurationId")
        self._MaxResults = params.get("MaxResults")
        self._NextToken = params.get("NextToken")
        self._TargetType = params.get("TargetType")
        self._TargetUin = params.get("TargetUin")
        self._DeploymentStatus = params.get("DeploymentStatus")
        self._Filter = params.get("Filter")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ListRoleConfigurationProvisioningsResponse(AbstractModel):
    """ListRoleConfigurationProvisionings response structure.

    """

    def __init__(self):
        r"""
        :param _NextToken: Token for querying the next page of returned results. Note: This parameter is displayed only when IsTruncated is true.
        :type NextToken: str
        :param _TotalCounts: Total number of data entries that meet the request parameter conditions.
        :type TotalCounts: int
        :param _MaxResults: Maximum number of data entries per page.
        :type MaxResults: int
        :param _IsTruncated: Whether the returned result is truncated. Valid values: true: truncated; false: not truncated.
        :type IsTruncated: bool
        :param _RoleConfigurationProvisionings: Department member account list.
        :type RoleConfigurationProvisionings: list of RoleConfigurationProvisionings
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NextToken = None
        self._TotalCounts = None
        self._MaxResults = None
        self._IsTruncated = None
        self._RoleConfigurationProvisionings = None
        self._RequestId = None

    @property
    def NextToken(self):
        return self._NextToken

    @NextToken.setter
    def NextToken(self, NextToken):
        self._NextToken = NextToken

    @property
    def TotalCounts(self):
        return self._TotalCounts

    @TotalCounts.setter
    def TotalCounts(self, TotalCounts):
        self._TotalCounts = TotalCounts

    @property
    def MaxResults(self):
        return self._MaxResults

    @MaxResults.setter
    def MaxResults(self, MaxResults):
        self._MaxResults = MaxResults

    @property
    def IsTruncated(self):
        return self._IsTruncated

    @IsTruncated.setter
    def IsTruncated(self, IsTruncated):
        self._IsTruncated = IsTruncated

    @property
    def RoleConfigurationProvisionings(self):
        return self._RoleConfigurationProvisionings

    @RoleConfigurationProvisionings.setter
    def RoleConfigurationProvisionings(self, RoleConfigurationProvisionings):
        self._RoleConfigurationProvisionings = RoleConfigurationProvisionings

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._NextToken = params.get("NextToken")
        self._TotalCounts = params.get("TotalCounts")
        self._MaxResults = params.get("MaxResults")
        self._IsTruncated = params.get("IsTruncated")
        if params.get("RoleConfigurationProvisionings") is not None:
            self._RoleConfigurationProvisionings = []
            for item in params.get("RoleConfigurationProvisionings"):
                obj = RoleConfigurationProvisionings()
                obj._deserialize(item)
                self._RoleConfigurationProvisionings.append(obj)
        self._RequestId = params.get("RequestId")


class ListRoleConfigurationsRequest(AbstractModel):
    """ListRoleConfigurations request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _NextToken: Token for querying the next page of returned results. During use of the API for the first time, NextToken is not needed. When you call the API for the first time, if the total number of returned data entries exceeds the MaxResults limit, the data is truncated and only MaxResults data entries are returned. Meanwhile, the return parameter IsTruncated is true and a NextToken is returned. You can use the NextToken returned last time to continue calling the API with other request parameters unchanged, to query the truncated data. You can use this method for multiple queries until IsTruncated is false, indicating that all data has been queried.
        :type NextToken: str
        :param _MaxResults: Maximum number of data entries per page. Value range: 1-100. Default value: 10.
        :type MaxResults: int
        :param _Filter: Filter criterion, case-insensitive. Currently, only RoleConfigurationName is supported, and only eq (Equals) and sw (Starts With) are supported. For example, Filter = "RoleConfigurationName, sw test" indicates querying all access configurations with names starting with test; Filter = "RoleConfigurationName, eq TestRoleConfiguration" indicates querying the access configuration with the name TestRoleConfiguration.
        :type Filter: str
        :param _FilterTargets: Check whether the member account has been configured with permissions. If configured, return IsSelected: true; otherwise, return false.
        :type FilterTargets: list of int
        :param _PrincipalId: UserId of the authorized user or GroupId of the authorized user group, which must be set together with the input parameter FilterTargets.
        :type PrincipalId: str
        """
        self._ZoneId = None
        self._NextToken = None
        self._MaxResults = None
        self._Filter = None
        self._FilterTargets = None
        self._PrincipalId = None

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def NextToken(self):
        return self._NextToken

    @NextToken.setter
    def NextToken(self, NextToken):
        self._NextToken = NextToken

    @property
    def MaxResults(self):
        return self._MaxResults

    @MaxResults.setter
    def MaxResults(self, MaxResults):
        self._MaxResults = MaxResults

    @property
    def Filter(self):
        return self._Filter

    @Filter.setter
    def Filter(self, Filter):
        self._Filter = Filter

    @property
    def FilterTargets(self):
        return self._FilterTargets

    @FilterTargets.setter
    def FilterTargets(self, FilterTargets):
        self._FilterTargets = FilterTargets

    @property
    def PrincipalId(self):
        return self._PrincipalId

    @PrincipalId.setter
    def PrincipalId(self, PrincipalId):
        self._PrincipalId = PrincipalId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._NextToken = params.get("NextToken")
        self._MaxResults = params.get("MaxResults")
        self._Filter = params.get("Filter")
        self._FilterTargets = params.get("FilterTargets")
        self._PrincipalId = params.get("PrincipalId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ListRoleConfigurationsResponse(AbstractModel):
    """ListRoleConfigurations response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCounts: Total number of data entries that meet the request parameter conditions.
        :type TotalCounts: int
        :param _MaxResults: Maximum number of data entries per page.
        :type MaxResults: int
        :param _IsTruncated: Whether the returned result is truncated. Valid values: true: truncated; false: not truncated.
        :type IsTruncated: bool
        :param _NextToken: Token for querying the next page of returned results. Note: This parameter is displayed only when IsTruncated is true.
        :type NextToken: str
        :param _RoleConfigurations: Permission configuration list.
        :type RoleConfigurations: list of RoleConfiguration
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCounts = None
        self._MaxResults = None
        self._IsTruncated = None
        self._NextToken = None
        self._RoleConfigurations = None
        self._RequestId = None

    @property
    def TotalCounts(self):
        return self._TotalCounts

    @TotalCounts.setter
    def TotalCounts(self, TotalCounts):
        self._TotalCounts = TotalCounts

    @property
    def MaxResults(self):
        return self._MaxResults

    @MaxResults.setter
    def MaxResults(self, MaxResults):
        self._MaxResults = MaxResults

    @property
    def IsTruncated(self):
        return self._IsTruncated

    @IsTruncated.setter
    def IsTruncated(self, IsTruncated):
        self._IsTruncated = IsTruncated

    @property
    def NextToken(self):
        return self._NextToken

    @NextToken.setter
    def NextToken(self, NextToken):
        self._NextToken = NextToken

    @property
    def RoleConfigurations(self):
        return self._RoleConfigurations

    @RoleConfigurations.setter
    def RoleConfigurations(self, RoleConfigurations):
        self._RoleConfigurations = RoleConfigurations

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCounts = params.get("TotalCounts")
        self._MaxResults = params.get("MaxResults")
        self._IsTruncated = params.get("IsTruncated")
        self._NextToken = params.get("NextToken")
        if params.get("RoleConfigurations") is not None:
            self._RoleConfigurations = []
            for item in params.get("RoleConfigurations"):
                obj = RoleConfiguration()
                obj._deserialize(item)
                self._RoleConfigurations.append(obj)
        self._RequestId = params.get("RequestId")


class ListTasksRequest(AbstractModel):
    """ListTasks request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _PrincipalId: Identity ID for the CAM user synchronization. Valid values: When the PrincipalType value is Group, it is the CIC user group ID (g-********). When the PrincipalType value is User, it is the CIC user ID (u-********).
        :type PrincipalId: str
        :param _NextToken: Token for querying the next page of returned results. During use of the API for the first time, NextToken is not needed. When you call the API for the first time, if the total number of returned data entries exceeds the MaxResults limit, the data is truncated and only MaxResults data entries are returned. Meanwhile, the return parameter IsTruncated is true and a NextToken is returned. You can use the NextToken returned last time to continue calling the API with other request parameters unchanged, to query the truncated data. You can use this method for multiple queries until IsTruncated is false, indicating that all data has been queried.
        :type NextToken: str
        :param _MaxResults: Maximum number of data entries per page. Value range: 1-100. Default value: 10.
        :type MaxResults: int
        :param _PrincipalType: Identity type for the CAM user synchronization. Valid values: User: indicates that the identity for the CAM user synchronization is a CIC user; Group: indicates that the identity for the CAM user synchronization is a CIC user group.
        :type PrincipalType: str
        :param _TargetUin: UIN of the synchronized target account of the Tencent Cloud Organization.
        :type TargetUin: int
        :param _TargetType: Type of the synchronized target account of the Tencent Cloud Organization. ManagerUin: admin account; MemberUin: member account.
        :type TargetType: str
        :param _RoleConfigurationId: Permission configuration ID.
        :type RoleConfigurationId: str
        :param _Status: InProgress: The task is being executed; Success: The task execution succeeded; Failed: The task execution failed.
        :type Status: str
        :param _TaskType: Task type.
        :type TaskType: str
        """
        self._ZoneId = None
        self._PrincipalId = None
        self._NextToken = None
        self._MaxResults = None
        self._PrincipalType = None
        self._TargetUin = None
        self._TargetType = None
        self._RoleConfigurationId = None
        self._Status = None
        self._TaskType = None

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def PrincipalId(self):
        return self._PrincipalId

    @PrincipalId.setter
    def PrincipalId(self, PrincipalId):
        self._PrincipalId = PrincipalId

    @property
    def NextToken(self):
        return self._NextToken

    @NextToken.setter
    def NextToken(self, NextToken):
        self._NextToken = NextToken

    @property
    def MaxResults(self):
        return self._MaxResults

    @MaxResults.setter
    def MaxResults(self, MaxResults):
        self._MaxResults = MaxResults

    @property
    def PrincipalType(self):
        return self._PrincipalType

    @PrincipalType.setter
    def PrincipalType(self, PrincipalType):
        self._PrincipalType = PrincipalType

    @property
    def TargetUin(self):
        return self._TargetUin

    @TargetUin.setter
    def TargetUin(self, TargetUin):
        self._TargetUin = TargetUin

    @property
    def TargetType(self):
        return self._TargetType

    @TargetType.setter
    def TargetType(self, TargetType):
        self._TargetType = TargetType

    @property
    def RoleConfigurationId(self):
        return self._RoleConfigurationId

    @RoleConfigurationId.setter
    def RoleConfigurationId(self, RoleConfigurationId):
        self._RoleConfigurationId = RoleConfigurationId

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._PrincipalId = params.get("PrincipalId")
        self._NextToken = params.get("NextToken")
        self._MaxResults = params.get("MaxResults")
        self._PrincipalType = params.get("PrincipalType")
        self._TargetUin = params.get("TargetUin")
        self._TargetType = params.get("TargetType")
        self._RoleConfigurationId = params.get("RoleConfigurationId")
        self._Status = params.get("Status")
        self._TaskType = params.get("TaskType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ListTasksResponse(AbstractModel):
    """ListTasks response structure.

    """

    def __init__(self):
        r"""
        :param _NextToken: Token for querying the next page of returned results. Note: This parameter is displayed only when IsTruncated is true.
        :type NextToken: str
        :param _TotalCounts: Total number of data entries that meet the request parameter conditions.
        :type TotalCounts: int
        :param _MaxResults: Maximum number of data entries per page.
        :type MaxResults: int
        :param _IsTruncated: Whether the returned result is truncated. Valid values: true: truncated; false: not truncated.
        :type IsTruncated: bool
        :param _Tasks: Task details.
        :type Tasks: list of TaskInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NextToken = None
        self._TotalCounts = None
        self._MaxResults = None
        self._IsTruncated = None
        self._Tasks = None
        self._RequestId = None

    @property
    def NextToken(self):
        return self._NextToken

    @NextToken.setter
    def NextToken(self, NextToken):
        self._NextToken = NextToken

    @property
    def TotalCounts(self):
        return self._TotalCounts

    @TotalCounts.setter
    def TotalCounts(self, TotalCounts):
        self._TotalCounts = TotalCounts

    @property
    def MaxResults(self):
        return self._MaxResults

    @MaxResults.setter
    def MaxResults(self, MaxResults):
        self._MaxResults = MaxResults

    @property
    def IsTruncated(self):
        return self._IsTruncated

    @IsTruncated.setter
    def IsTruncated(self, IsTruncated):
        self._IsTruncated = IsTruncated

    @property
    def Tasks(self):
        return self._Tasks

    @Tasks.setter
    def Tasks(self, Tasks):
        self._Tasks = Tasks

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._NextToken = params.get("NextToken")
        self._TotalCounts = params.get("TotalCounts")
        self._MaxResults = params.get("MaxResults")
        self._IsTruncated = params.get("IsTruncated")
        if params.get("Tasks") is not None:
            self._Tasks = []
            for item in params.get("Tasks"):
                obj = TaskInfo()
                obj._deserialize(item)
                self._Tasks.append(obj)
        self._RequestId = params.get("RequestId")


class ListUserSyncProvisioningsRequest(AbstractModel):
    """ListUserSyncProvisionings request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _PrincipalId: Identity ID for the CAM user synchronization. Valid values: When the PrincipalType value is Group, it is the CIC user group ID (g-********). When the PrincipalType value is User, it is the CIC user ID (u-********).
        :type PrincipalId: str
        :param _NextToken: Token for querying the next page of returned results. During use of the API for the first time, NextToken is not needed. When you call the API for the first time, if the total number of returned data entries exceeds the MaxResults limit, the data is truncated and only MaxResults data entries are returned. Meanwhile, the return parameter IsTruncated is true and a NextToken is returned. You can use the NextToken returned last time to continue calling the API with other request parameters unchanged, to query the truncated data. You can use this method for multiple queries until IsTruncated is false, indicating that all data has been queried.
        :type NextToken: str
        :param _MaxResults: Maximum number of data entries per page. Value range: 1-100. Default value: 10.
        :type MaxResults: int
        :param _PrincipalType: Identity type for the CAM user synchronization. Valid values: User: indicates that the identity for the CAM user synchronization is a CIC user; Group: indicates that the identity for the CAM user synchronization is a CIC user group.
        :type PrincipalType: str
        :param _TargetUin: UIN of the target account of the Tencent Cloud Organization.
        :type TargetUin: int
        :param _TargetType: Type of the synchronized target account of the Tencent Cloud Organization. ManagerUin: admin account; MemberUin: member account.
        :type TargetType: str
        :param _Filter: Detection condition.
        :type Filter: str
        """
        self._ZoneId = None
        self._PrincipalId = None
        self._NextToken = None
        self._MaxResults = None
        self._PrincipalType = None
        self._TargetUin = None
        self._TargetType = None
        self._Filter = None

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def PrincipalId(self):
        return self._PrincipalId

    @PrincipalId.setter
    def PrincipalId(self, PrincipalId):
        self._PrincipalId = PrincipalId

    @property
    def NextToken(self):
        return self._NextToken

    @NextToken.setter
    def NextToken(self, NextToken):
        self._NextToken = NextToken

    @property
    def MaxResults(self):
        return self._MaxResults

    @MaxResults.setter
    def MaxResults(self, MaxResults):
        self._MaxResults = MaxResults

    @property
    def PrincipalType(self):
        return self._PrincipalType

    @PrincipalType.setter
    def PrincipalType(self, PrincipalType):
        self._PrincipalType = PrincipalType

    @property
    def TargetUin(self):
        return self._TargetUin

    @TargetUin.setter
    def TargetUin(self, TargetUin):
        self._TargetUin = TargetUin

    @property
    def TargetType(self):
        return self._TargetType

    @TargetType.setter
    def TargetType(self, TargetType):
        self._TargetType = TargetType

    @property
    def Filter(self):
        return self._Filter

    @Filter.setter
    def Filter(self, Filter):
        self._Filter = Filter


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._PrincipalId = params.get("PrincipalId")
        self._NextToken = params.get("NextToken")
        self._MaxResults = params.get("MaxResults")
        self._PrincipalType = params.get("PrincipalType")
        self._TargetUin = params.get("TargetUin")
        self._TargetType = params.get("TargetType")
        self._Filter = params.get("Filter")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ListUserSyncProvisioningsResponse(AbstractModel):
    """ListUserSyncProvisionings response structure.

    """

    def __init__(self):
        r"""
        :param _NextToken: Token for querying the next page of returned results. Note: This parameter is displayed only when IsTruncated is true.
        :type NextToken: str
        :param _TotalCounts: Total number of data entries that meet the request parameter conditions.
        :type TotalCounts: int
        :param _MaxResults: Maximum number of data entries per page.
        :type MaxResults: int
        :param _IsTruncated: Whether the returned result is truncated. Valid values: true: truncated; false: not truncated.
        :type IsTruncated: bool
        :param _UserProvisionings: User list of the CAM synchronization.
        :type UserProvisionings: list of UserProvisioning
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NextToken = None
        self._TotalCounts = None
        self._MaxResults = None
        self._IsTruncated = None
        self._UserProvisionings = None
        self._RequestId = None

    @property
    def NextToken(self):
        return self._NextToken

    @NextToken.setter
    def NextToken(self, NextToken):
        self._NextToken = NextToken

    @property
    def TotalCounts(self):
        return self._TotalCounts

    @TotalCounts.setter
    def TotalCounts(self, TotalCounts):
        self._TotalCounts = TotalCounts

    @property
    def MaxResults(self):
        return self._MaxResults

    @MaxResults.setter
    def MaxResults(self, MaxResults):
        self._MaxResults = MaxResults

    @property
    def IsTruncated(self):
        return self._IsTruncated

    @IsTruncated.setter
    def IsTruncated(self, IsTruncated):
        self._IsTruncated = IsTruncated

    @property
    def UserProvisionings(self):
        return self._UserProvisionings

    @UserProvisionings.setter
    def UserProvisionings(self, UserProvisionings):
        self._UserProvisionings = UserProvisionings

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._NextToken = params.get("NextToken")
        self._TotalCounts = params.get("TotalCounts")
        self._MaxResults = params.get("MaxResults")
        self._IsTruncated = params.get("IsTruncated")
        if params.get("UserProvisionings") is not None:
            self._UserProvisionings = []
            for item in params.get("UserProvisionings"):
                obj = UserProvisioning()
                obj._deserialize(item)
                self._UserProvisionings.append(obj)
        self._RequestId = params.get("RequestId")


class ListUsersRequest(AbstractModel):
    """ListUsers request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _UserStatus: User status: Enabled, Disabled.
        :type UserStatus: str
        :param _UserType: User type. Manual: manually created; Synchronized: externally imported.
        :type UserType: str
        :param _Filter: Filter criterion, which currently only supports username, email address, userId, and description.
        :type Filter: str
        :param _MaxResults: Maximum number of data entries per page. Value range: 1-100. Default value: 10.
        :type MaxResults: int
        :param _NextToken: Token for querying the next page of returned results. During use of the API for the first time, NextToken is not needed. When you call the API for the first time, if the total number of returned data entries exceeds the MaxResults limit, the data is truncated and only MaxResults data entries are returned. Meanwhile, the return parameter IsTruncated is true and a NextToken is returned. You can use the NextToken returned last time to continue calling the API with other request parameters unchanged, to query the truncated data. You can use this method for multiple queries until IsTruncated is false, indicating that all data has been queried.
        :type NextToken: str
        :param _FilterGroups: Filtered user group. IsSelected=1 will be returned for the sub-user associated with this user group.
        :type FilterGroups: list of str
        :param _SortField: Sorting field, which currently only supports CreateTime. The default is the CreateTime field.
        :type SortField: str
        :param _SortType: Sorting type. Desc: descending order; Asc: ascending order. It should be set along with SortField.
        :type SortType: str
        """
        self._ZoneId = None
        self._UserStatus = None
        self._UserType = None
        self._Filter = None
        self._MaxResults = None
        self._NextToken = None
        self._FilterGroups = None
        self._SortField = None
        self._SortType = None

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def UserStatus(self):
        return self._UserStatus

    @UserStatus.setter
    def UserStatus(self, UserStatus):
        self._UserStatus = UserStatus

    @property
    def UserType(self):
        return self._UserType

    @UserType.setter
    def UserType(self, UserType):
        self._UserType = UserType

    @property
    def Filter(self):
        return self._Filter

    @Filter.setter
    def Filter(self, Filter):
        self._Filter = Filter

    @property
    def MaxResults(self):
        return self._MaxResults

    @MaxResults.setter
    def MaxResults(self, MaxResults):
        self._MaxResults = MaxResults

    @property
    def NextToken(self):
        return self._NextToken

    @NextToken.setter
    def NextToken(self, NextToken):
        self._NextToken = NextToken

    @property
    def FilterGroups(self):
        return self._FilterGroups

    @FilterGroups.setter
    def FilterGroups(self, FilterGroups):
        self._FilterGroups = FilterGroups

    @property
    def SortField(self):
        return self._SortField

    @SortField.setter
    def SortField(self, SortField):
        self._SortField = SortField

    @property
    def SortType(self):
        return self._SortType

    @SortType.setter
    def SortType(self, SortType):
        self._SortType = SortType


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._UserStatus = params.get("UserStatus")
        self._UserType = params.get("UserType")
        self._Filter = params.get("Filter")
        self._MaxResults = params.get("MaxResults")
        self._NextToken = params.get("NextToken")
        self._FilterGroups = params.get("FilterGroups")
        self._SortField = params.get("SortField")
        self._SortType = params.get("SortType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ListUsersResponse(AbstractModel):
    """ListUsers response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCounts: Total number of data entries that meet the request parameter conditions.
        :type TotalCounts: int
        :param _MaxResults: Maximum number of data entries per page.
        :type MaxResults: int
        :param _Users: User list.
        :type Users: list of UserInfo
        :param _NextToken: Token for querying the next page of returned results. This parameter is displayed only when IsTruncated is true.
        :type NextToken: str
        :param _IsTruncated: Whether the returned result is truncated. Valid values: true: truncated; false: not truncated.
        :type IsTruncated: bool
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCounts = None
        self._MaxResults = None
        self._Users = None
        self._NextToken = None
        self._IsTruncated = None
        self._RequestId = None

    @property
    def TotalCounts(self):
        return self._TotalCounts

    @TotalCounts.setter
    def TotalCounts(self, TotalCounts):
        self._TotalCounts = TotalCounts

    @property
    def MaxResults(self):
        return self._MaxResults

    @MaxResults.setter
    def MaxResults(self, MaxResults):
        self._MaxResults = MaxResults

    @property
    def Users(self):
        return self._Users

    @Users.setter
    def Users(self, Users):
        self._Users = Users

    @property
    def NextToken(self):
        return self._NextToken

    @NextToken.setter
    def NextToken(self, NextToken):
        self._NextToken = NextToken

    @property
    def IsTruncated(self):
        return self._IsTruncated

    @IsTruncated.setter
    def IsTruncated(self, IsTruncated):
        self._IsTruncated = IsTruncated

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCounts = params.get("TotalCounts")
        self._MaxResults = params.get("MaxResults")
        if params.get("Users") is not None:
            self._Users = []
            for item in params.get("Users"):
                obj = UserInfo()
                obj._deserialize(item)
                self._Users.append(obj)
        self._NextToken = params.get("NextToken")
        self._IsTruncated = params.get("IsTruncated")
        self._RequestId = params.get("RequestId")


class MemberIdentity(AbstractModel):
    """Member management identity

    """

    def __init__(self):
        r"""
        :param _IdentityId: Identity ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :type IdentityId: int
        :param _IdentityAliasName: Identity name.
Note: This field may return null, indicating that no valid values can be obtained.
        :type IdentityAliasName: str
        """
        self._IdentityId = None
        self._IdentityAliasName = None

    @property
    def IdentityId(self):
        return self._IdentityId

    @IdentityId.setter
    def IdentityId(self, IdentityId):
        self._IdentityId = IdentityId

    @property
    def IdentityAliasName(self):
        return self._IdentityAliasName

    @IdentityAliasName.setter
    def IdentityAliasName(self, IdentityAliasName):
        self._IdentityAliasName = IdentityAliasName


    def _deserialize(self, params):
        self._IdentityId = params.get("IdentityId")
        self._IdentityAliasName = params.get("IdentityAliasName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MemberMainInfo(AbstractModel):
    """Main member information.

    """

    def __init__(self):
        r"""
        :param _MemberUin: Member UIN
Note: This field may return null, indicating that no valid values can be obtained.
        :type MemberUin: int
        :param _MemberName: Member name j.
Note: This field may return null, indicating that no valid values can be obtained.
        :type MemberName: str
        """
        self._MemberUin = None
        self._MemberName = None

    @property
    def MemberUin(self):
        return self._MemberUin

    @MemberUin.setter
    def MemberUin(self, MemberUin):
        self._MemberUin = MemberUin

    @property
    def MemberName(self):
        return self._MemberName

    @MemberName.setter
    def MemberName(self, MemberName):
        self._MemberName = MemberName


    def _deserialize(self, params):
        self._MemberUin = params.get("MemberUin")
        self._MemberName = params.get("MemberName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MoveOrganizationNodeMembersRequest(AbstractModel):
    """MoveOrganizationNodeMembers request structure.

    """

    def __init__(self):
        r"""
        :param _NodeId: Organization node ID, which can be obtained through [DescribeOrganizationNodes](https://intl.cloud.tencent.com/document/product/850/82926?from_cn_redirect=1).
        :type NodeId: int
        :param _MemberUin: Uin list of the members.
        :type MemberUin: list of int
        """
        self._NodeId = None
        self._MemberUin = None

    @property
    def NodeId(self):
        return self._NodeId

    @NodeId.setter
    def NodeId(self, NodeId):
        self._NodeId = NodeId

    @property
    def MemberUin(self):
        return self._MemberUin

    @MemberUin.setter
    def MemberUin(self, MemberUin):
        self._MemberUin = MemberUin


    def _deserialize(self, params):
        self._NodeId = params.get("NodeId")
        self._MemberUin = params.get("MemberUin")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MoveOrganizationNodeMembersResponse(AbstractModel):
    """MoveOrganizationNodeMembers response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class NodeMainInfo(AbstractModel):
    """Main department information.

    """

    def __init__(self):
        r"""
        :param _NodeId: Department ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type NodeId: int
        :param _NodeName: Department name.
Note: This field may return null, indicating that no valid values can be obtained.
        :type NodeName: str
        """
        self._NodeId = None
        self._NodeName = None

    @property
    def NodeId(self):
        return self._NodeId

    @NodeId.setter
    def NodeId(self, NodeId):
        self._NodeId = NodeId

    @property
    def NodeName(self):
        return self._NodeName

    @NodeName.setter
    def NodeName(self, NodeName):
        self._NodeName = NodeName


    def _deserialize(self, params):
        self._NodeId = params.get("NodeId")
        self._NodeName = params.get("NodeName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OpenIdentityCenterRequest(AbstractModel):
    """OpenIdentityCenter request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneName: Space name, which must be globally unique and contain 2-64 characters including lowercase letters, digits, and hyphens (-). It can neither start or end with a hyphen (-) nor contain two consecutive hyphens (-).
        :type ZoneName: str
        """
        self._ZoneName = None

    @property
    def ZoneName(self):
        return self._ZoneName

    @ZoneName.setter
    def ZoneName(self, ZoneName):
        self._ZoneName = ZoneName


    def _deserialize(self, params):
        self._ZoneName = params.get("ZoneName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OpenIdentityCenterResponse(AbstractModel):
    """OpenIdentityCenter response structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID, which starts with the z- prefix, followed by 12 random digits/lowercase letters.
        :type ZoneId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ZoneId = None
        self._RequestId = None

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._RequestId = params.get("RequestId")


class OrgIdentity(AbstractModel):
    """Organization identity

    """

    def __init__(self):
        r"""
        :param _IdentityId: Identity ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :type IdentityId: int
        :param _IdentityAliasName: Identity name.
Note: This field may return null, indicating that no valid values can be obtained.
        :type IdentityAliasName: str
        :param _Description: Description.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Description: str
        :param _IdentityPolicy: Identity policy.
Note: This field may return null, indicating that no valid values can be obtained.
        :type IdentityPolicy: list of IdentityPolicy
        :param _IdentityType: Identity type. Valid values: `1` (preset); `2` (custom).
Note: This field may return null, indicating that no valid values can be obtained.
        :type IdentityType: int
        :param _UpdateTime: Update time.
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateTime: str
        """
        self._IdentityId = None
        self._IdentityAliasName = None
        self._Description = None
        self._IdentityPolicy = None
        self._IdentityType = None
        self._UpdateTime = None

    @property
    def IdentityId(self):
        return self._IdentityId

    @IdentityId.setter
    def IdentityId(self, IdentityId):
        self._IdentityId = IdentityId

    @property
    def IdentityAliasName(self):
        return self._IdentityAliasName

    @IdentityAliasName.setter
    def IdentityAliasName(self, IdentityAliasName):
        self._IdentityAliasName = IdentityAliasName

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def IdentityPolicy(self):
        return self._IdentityPolicy

    @IdentityPolicy.setter
    def IdentityPolicy(self, IdentityPolicy):
        self._IdentityPolicy = IdentityPolicy

    @property
    def IdentityType(self):
        return self._IdentityType

    @IdentityType.setter
    def IdentityType(self, IdentityType):
        self._IdentityType = IdentityType

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._IdentityId = params.get("IdentityId")
        self._IdentityAliasName = params.get("IdentityAliasName")
        self._Description = params.get("Description")
        if params.get("IdentityPolicy") is not None:
            self._IdentityPolicy = []
            for item in params.get("IdentityPolicy"):
                obj = IdentityPolicy()
                obj._deserialize(item)
                self._IdentityPolicy.append(obj)
        self._IdentityType = params.get("IdentityType")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OrgMember(AbstractModel):
    """Organization member

    """

    def __init__(self):
        r"""
        :param _MemberUin: Member UIN
Note: This field may return null, indicating that no valid values can be obtained.
        :type MemberUin: int
        :param _Name: Member name
Note: This field may return null, indicating that no valid values can be obtained.
        :type Name: str
        :param _MemberType: Member type. Valid values: `Invite` (invited); `Create` (created).
Note: This field may return null, indicating that no valid values can be obtained.
        :type MemberType: str
        :param _OrgPolicyType: Relationship policy type
Note: This field may return null, indicating that no valid values can be obtained.
        :type OrgPolicyType: str
        :param _OrgPolicyName: Relationship policy name
Note: This field may return null, indicating that no valid values can be obtained.
        :type OrgPolicyName: str
        :param _OrgPermission: Relationship policy permission
Note: This field may return null, indicating that no valid values can be obtained.
        :type OrgPermission: list of OrgPermission
        :param _NodeId: Node ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type NodeId: int
        :param _NodeName: Node name
Note: This field may return null, indicating that no valid values can be obtained.
        :type NodeName: str
        :param _Remark: Remarks
Note: This field may return null, indicating that no valid values can be obtained.
        :type Remark: str
        :param _CreateTime: Creation time
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        :param _UpdateTime: Update time
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateTime: str
        :param _IsAllowQuit: Whether the member is allowed to leave. Valid values: `Allow`, `Denied`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsAllowQuit: str
        :param _PayUin: Payer UIN
Note: This field may return null, indicating that no valid values can be obtained.
        :type PayUin: str
        :param _PayName: Payer name
Note: This field may return null, indicating that no valid values can be obtained.
        :type PayName: str
        :param _OrgIdentity: Management identity
Note: This field may return null, indicating that no valid values can be obtained.
        :type OrgIdentity: list of MemberIdentity
        :param _BindStatus: Security information binding status. Valid values: `Unbound`, `Valid`, `Success`, `Failed`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type BindStatus: str
        :param _PermissionStatus: Member permission status. Valid values: `Confirmed`, `UnConfirmed`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type PermissionStatus: str
        :param _Tags: Member tag list.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Tags: list of Tag
        """
        self._MemberUin = None
        self._Name = None
        self._MemberType = None
        self._OrgPolicyType = None
        self._OrgPolicyName = None
        self._OrgPermission = None
        self._NodeId = None
        self._NodeName = None
        self._Remark = None
        self._CreateTime = None
        self._UpdateTime = None
        self._IsAllowQuit = None
        self._PayUin = None
        self._PayName = None
        self._OrgIdentity = None
        self._BindStatus = None
        self._PermissionStatus = None
        self._Tags = None

    @property
    def MemberUin(self):
        return self._MemberUin

    @MemberUin.setter
    def MemberUin(self, MemberUin):
        self._MemberUin = MemberUin

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def MemberType(self):
        return self._MemberType

    @MemberType.setter
    def MemberType(self, MemberType):
        self._MemberType = MemberType

    @property
    def OrgPolicyType(self):
        return self._OrgPolicyType

    @OrgPolicyType.setter
    def OrgPolicyType(self, OrgPolicyType):
        self._OrgPolicyType = OrgPolicyType

    @property
    def OrgPolicyName(self):
        return self._OrgPolicyName

    @OrgPolicyName.setter
    def OrgPolicyName(self, OrgPolicyName):
        self._OrgPolicyName = OrgPolicyName

    @property
    def OrgPermission(self):
        return self._OrgPermission

    @OrgPermission.setter
    def OrgPermission(self, OrgPermission):
        self._OrgPermission = OrgPermission

    @property
    def NodeId(self):
        return self._NodeId

    @NodeId.setter
    def NodeId(self, NodeId):
        self._NodeId = NodeId

    @property
    def NodeName(self):
        return self._NodeName

    @NodeName.setter
    def NodeName(self, NodeName):
        self._NodeName = NodeName

    @property
    def Remark(self):
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def IsAllowQuit(self):
        return self._IsAllowQuit

    @IsAllowQuit.setter
    def IsAllowQuit(self, IsAllowQuit):
        self._IsAllowQuit = IsAllowQuit

    @property
    def PayUin(self):
        return self._PayUin

    @PayUin.setter
    def PayUin(self, PayUin):
        self._PayUin = PayUin

    @property
    def PayName(self):
        return self._PayName

    @PayName.setter
    def PayName(self, PayName):
        self._PayName = PayName

    @property
    def OrgIdentity(self):
        return self._OrgIdentity

    @OrgIdentity.setter
    def OrgIdentity(self, OrgIdentity):
        self._OrgIdentity = OrgIdentity

    @property
    def BindStatus(self):
        return self._BindStatus

    @BindStatus.setter
    def BindStatus(self, BindStatus):
        self._BindStatus = BindStatus

    @property
    def PermissionStatus(self):
        return self._PermissionStatus

    @PermissionStatus.setter
    def PermissionStatus(self, PermissionStatus):
        self._PermissionStatus = PermissionStatus

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._MemberUin = params.get("MemberUin")
        self._Name = params.get("Name")
        self._MemberType = params.get("MemberType")
        self._OrgPolicyType = params.get("OrgPolicyType")
        self._OrgPolicyName = params.get("OrgPolicyName")
        if params.get("OrgPermission") is not None:
            self._OrgPermission = []
            for item in params.get("OrgPermission"):
                obj = OrgPermission()
                obj._deserialize(item)
                self._OrgPermission.append(obj)
        self._NodeId = params.get("NodeId")
        self._NodeName = params.get("NodeName")
        self._Remark = params.get("Remark")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._IsAllowQuit = params.get("IsAllowQuit")
        self._PayUin = params.get("PayUin")
        self._PayName = params.get("PayName")
        if params.get("OrgIdentity") is not None:
            self._OrgIdentity = []
            for item in params.get("OrgIdentity"):
                obj = MemberIdentity()
                obj._deserialize(item)
                self._OrgIdentity.append(obj)
        self._BindStatus = params.get("BindStatus")
        self._PermissionStatus = params.get("PermissionStatus")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OrgMemberAuthAccount(AbstractModel):
    """Authorization relationship between the member and sub-account

    """

    def __init__(self):
        r"""
        :param _OrgSubAccountUin: Organization sub-account UIN.
Note: This field may return null, indicating that no valid values can be obtained.
        :type OrgSubAccountUin: int
        :param _PolicyId: Policy ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :type PolicyId: int
        :param _PolicyName: Policy name.
Note: This field may return null, indicating that no valid values can be obtained.
        :type PolicyName: str
        :param _IdentityId: Identity ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :type IdentityId: int
        :param _IdentityRoleName: Identity role name.
Note: This field may return null, indicating that no valid values can be obtained.
        :type IdentityRoleName: str
        :param _IdentityRoleAliasName: Identity role alias.
Note: This field may return null, indicating that no valid values can be obtained.
        :type IdentityRoleAliasName: str
        :param _CreateTime: Creation time.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        :param _UpdateTime: Update time.
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateTime: str
        :param _OrgSubAccountName: Sub-account name
Note: This field may return null, indicating that no valid values can be obtained.
        :type OrgSubAccountName: str
        """
        self._OrgSubAccountUin = None
        self._PolicyId = None
        self._PolicyName = None
        self._IdentityId = None
        self._IdentityRoleName = None
        self._IdentityRoleAliasName = None
        self._CreateTime = None
        self._UpdateTime = None
        self._OrgSubAccountName = None

    @property
    def OrgSubAccountUin(self):
        return self._OrgSubAccountUin

    @OrgSubAccountUin.setter
    def OrgSubAccountUin(self, OrgSubAccountUin):
        self._OrgSubAccountUin = OrgSubAccountUin

    @property
    def PolicyId(self):
        return self._PolicyId

    @PolicyId.setter
    def PolicyId(self, PolicyId):
        self._PolicyId = PolicyId

    @property
    def PolicyName(self):
        return self._PolicyName

    @PolicyName.setter
    def PolicyName(self, PolicyName):
        self._PolicyName = PolicyName

    @property
    def IdentityId(self):
        return self._IdentityId

    @IdentityId.setter
    def IdentityId(self, IdentityId):
        self._IdentityId = IdentityId

    @property
    def IdentityRoleName(self):
        return self._IdentityRoleName

    @IdentityRoleName.setter
    def IdentityRoleName(self, IdentityRoleName):
        self._IdentityRoleName = IdentityRoleName

    @property
    def IdentityRoleAliasName(self):
        return self._IdentityRoleAliasName

    @IdentityRoleAliasName.setter
    def IdentityRoleAliasName(self, IdentityRoleAliasName):
        self._IdentityRoleAliasName = IdentityRoleAliasName

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def OrgSubAccountName(self):
        return self._OrgSubAccountName

    @OrgSubAccountName.setter
    def OrgSubAccountName(self, OrgSubAccountName):
        self._OrgSubAccountName = OrgSubAccountName


    def _deserialize(self, params):
        self._OrgSubAccountUin = params.get("OrgSubAccountUin")
        self._PolicyId = params.get("PolicyId")
        self._PolicyName = params.get("PolicyName")
        self._IdentityId = params.get("IdentityId")
        self._IdentityRoleName = params.get("IdentityRoleName")
        self._IdentityRoleAliasName = params.get("IdentityRoleAliasName")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._OrgSubAccountName = params.get("OrgSubAccountName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OrgMemberAuthIdentity(AbstractModel):
    """Authorizable identity of the organization member

    """

    def __init__(self):
        r"""
        :param _IdentityId: Identity ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :type IdentityId: int
        :param _IdentityRoleName: Role name of an identity
Note: This field may return null, indicating that no valid values can be obtained.
        :type IdentityRoleName: str
        :param _IdentityRoleAliasName: Role alias of an identity
Note: This field may return null, indicating that no valid values can be obtained.
        :type IdentityRoleAliasName: str
        :param _Description: Identity description.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Description: str
        :param _CreateTime: Time of initial configuration success.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        :param _UpdateTime: Time of last configuration success.
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateTime: str
        :param _IdentityType: Identity type. Valid values: 1 (preset identity), 2 (custom identity).
Note: This field may return null, indicating that no valid values can be obtained.
        :type IdentityType: int
        :param _Status: Configuration status. Valid values: 1 (configuration completed), 2 (reconfiguration required).
Note: This field may return null, indicating that no valid values can be obtained.
        :type Status: int
        :param _MemberUin: Member Uin.
Note: This field may return null, indicating that no valid values can be obtained.
        :type MemberUin: int
        :param _MemberName: Member name.
Note: This field may return null, indicating that no valid values can be obtained.
        :type MemberName: str
        """
        self._IdentityId = None
        self._IdentityRoleName = None
        self._IdentityRoleAliasName = None
        self._Description = None
        self._CreateTime = None
        self._UpdateTime = None
        self._IdentityType = None
        self._Status = None
        self._MemberUin = None
        self._MemberName = None

    @property
    def IdentityId(self):
        return self._IdentityId

    @IdentityId.setter
    def IdentityId(self, IdentityId):
        self._IdentityId = IdentityId

    @property
    def IdentityRoleName(self):
        return self._IdentityRoleName

    @IdentityRoleName.setter
    def IdentityRoleName(self, IdentityRoleName):
        self._IdentityRoleName = IdentityRoleName

    @property
    def IdentityRoleAliasName(self):
        return self._IdentityRoleAliasName

    @IdentityRoleAliasName.setter
    def IdentityRoleAliasName(self, IdentityRoleAliasName):
        self._IdentityRoleAliasName = IdentityRoleAliasName

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def IdentityType(self):
        return self._IdentityType

    @IdentityType.setter
    def IdentityType(self, IdentityType):
        self._IdentityType = IdentityType

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def MemberUin(self):
        return self._MemberUin

    @MemberUin.setter
    def MemberUin(self, MemberUin):
        self._MemberUin = MemberUin

    @property
    def MemberName(self):
        return self._MemberName

    @MemberName.setter
    def MemberName(self, MemberName):
        self._MemberName = MemberName


    def _deserialize(self, params):
        self._IdentityId = params.get("IdentityId")
        self._IdentityRoleName = params.get("IdentityRoleName")
        self._IdentityRoleAliasName = params.get("IdentityRoleAliasName")
        self._Description = params.get("Description")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._IdentityType = params.get("IdentityType")
        self._Status = params.get("Status")
        self._MemberUin = params.get("MemberUin")
        self._MemberName = params.get("MemberName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OrgMemberPolicy(AbstractModel):
    """Authorized policy of the organization member

    """

    def __init__(self):
        r"""
        :param _PolicyId: Policy ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :type PolicyId: int
        :param _PolicyName: Policy name.
Note: This field may return null, indicating that no valid values can be obtained.
        :type PolicyName: str
        :param _IdentityId: Identity ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :type IdentityId: int
        :param _IdentityRoleName: Identity role name.
Note: This field may return null, indicating that no valid values can be obtained.
        :type IdentityRoleName: str
        :param _IdentityRoleAliasName: Identity role alias.
Note: This field may return null, indicating that no valid values can be obtained.
        :type IdentityRoleAliasName: str
        :param _Description: Description.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Description: str
        :param _CreateTime: Creation time.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        :param _UpdateTime: Update time.
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateTime: str
        """
        self._PolicyId = None
        self._PolicyName = None
        self._IdentityId = None
        self._IdentityRoleName = None
        self._IdentityRoleAliasName = None
        self._Description = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def PolicyId(self):
        return self._PolicyId

    @PolicyId.setter
    def PolicyId(self, PolicyId):
        self._PolicyId = PolicyId

    @property
    def PolicyName(self):
        return self._PolicyName

    @PolicyName.setter
    def PolicyName(self, PolicyName):
        self._PolicyName = PolicyName

    @property
    def IdentityId(self):
        return self._IdentityId

    @IdentityId.setter
    def IdentityId(self, IdentityId):
        self._IdentityId = IdentityId

    @property
    def IdentityRoleName(self):
        return self._IdentityRoleName

    @IdentityRoleName.setter
    def IdentityRoleName(self, IdentityRoleName):
        self._IdentityRoleName = IdentityRoleName

    @property
    def IdentityRoleAliasName(self):
        return self._IdentityRoleAliasName

    @IdentityRoleAliasName.setter
    def IdentityRoleAliasName(self, IdentityRoleAliasName):
        self._IdentityRoleAliasName = IdentityRoleAliasName

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._PolicyId = params.get("PolicyId")
        self._PolicyName = params.get("PolicyName")
        self._IdentityId = params.get("IdentityId")
        self._IdentityRoleName = params.get("IdentityRoleName")
        self._IdentityRoleAliasName = params.get("IdentityRoleAliasName")
        self._Description = params.get("Description")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OrgNode(AbstractModel):
    """Department

    """

    def __init__(self):
        r"""
        :param _NodeId: Organization node ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type NodeId: int
        :param _Name: Name
Note: This field may return null, indicating that no valid values can be obtained.
        :type Name: str
        :param _ParentNodeId: Parent node ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type ParentNodeId: int
        :param _Remark: Remarks
Note: This field may return null, indicating that no valid values can be obtained.
        :type Remark: str
        :param _CreateTime: Creation time
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        :param _UpdateTime: Update time
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateTime: str
        :param _Tags: Member tag list.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Tags: list of Tag
        """
        self._NodeId = None
        self._Name = None
        self._ParentNodeId = None
        self._Remark = None
        self._CreateTime = None
        self._UpdateTime = None
        self._Tags = None

    @property
    def NodeId(self):
        return self._NodeId

    @NodeId.setter
    def NodeId(self, NodeId):
        self._NodeId = NodeId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def ParentNodeId(self):
        return self._ParentNodeId

    @ParentNodeId.setter
    def ParentNodeId(self, ParentNodeId):
        self._ParentNodeId = ParentNodeId

    @property
    def Remark(self):
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._NodeId = params.get("NodeId")
        self._Name = params.get("Name")
        self._ParentNodeId = params.get("ParentNodeId")
        self._Remark = params.get("Remark")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OrgPermission(AbstractModel):
    """Relationship policy permission

    """

    def __init__(self):
        r"""
        :param _Id: Permission ID
        :type Id: int
        :param _Name: Permission name
        :type Name: str
        """
        self._Id = None
        self._Name = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OrganizationServiceAssign(AbstractModel):
    """Organization service settings.

    """

    def __init__(self):
        r"""
        :param _ServiceId: Organization service ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ServiceId: int
        :param _ProductName: Organization service product name.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ProductName: str
        :param _IsAssign: Whether to support delegation. Valid values: 1 (yes), 2 (no).
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsAssign: int
        :param _Description: Organization service description.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Description: str
        :param _MemberNum: Number of the current delegated admins.
Note: This field may return null, indicating that no valid values can be obtained.
        :type MemberNum: str
        :param _Document: Help documentation.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Document: str
        :param _ConsoleUrl: Console path of the organization service product.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ConsoleUrl: str
        :param _IsUsageStatus: Whether to access the usage status. Valid values: 1 (yes), 
 2 (no).
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsUsageStatus: int
        :param _CanAssignCount: Limit for the number of delegated admins.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CanAssignCount: int
        :param _Product: Organization service product identifier.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Product: str
        :param _ServiceGrant: Whether to support organization service authorization. Valid values: 1 (yes), 2 (no).
Note: This field may return null, indicating that no valid values can be obtained.
        :type ServiceGrant: int
        :param _GrantStatus: Enabling status of organization service authorization. This field is valid when ServiceGrant is 1. Valid values: Enabled, Disabled. 
Note: This field may return null, indicating that no valid values can be obtained.
        :type GrantStatus: str
        :param _IsSetManagementScope: Whether to support setting the delegated management scope. Valid values: 1 (yes), 2 (no).
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsSetManagementScope: int
        """
        self._ServiceId = None
        self._ProductName = None
        self._IsAssign = None
        self._Description = None
        self._MemberNum = None
        self._Document = None
        self._ConsoleUrl = None
        self._IsUsageStatus = None
        self._CanAssignCount = None
        self._Product = None
        self._ServiceGrant = None
        self._GrantStatus = None
        self._IsSetManagementScope = None

    @property
    def ServiceId(self):
        return self._ServiceId

    @ServiceId.setter
    def ServiceId(self, ServiceId):
        self._ServiceId = ServiceId

    @property
    def ProductName(self):
        return self._ProductName

    @ProductName.setter
    def ProductName(self, ProductName):
        self._ProductName = ProductName

    @property
    def IsAssign(self):
        return self._IsAssign

    @IsAssign.setter
    def IsAssign(self, IsAssign):
        self._IsAssign = IsAssign

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def MemberNum(self):
        return self._MemberNum

    @MemberNum.setter
    def MemberNum(self, MemberNum):
        self._MemberNum = MemberNum

    @property
    def Document(self):
        return self._Document

    @Document.setter
    def Document(self, Document):
        self._Document = Document

    @property
    def ConsoleUrl(self):
        return self._ConsoleUrl

    @ConsoleUrl.setter
    def ConsoleUrl(self, ConsoleUrl):
        self._ConsoleUrl = ConsoleUrl

    @property
    def IsUsageStatus(self):
        return self._IsUsageStatus

    @IsUsageStatus.setter
    def IsUsageStatus(self, IsUsageStatus):
        self._IsUsageStatus = IsUsageStatus

    @property
    def CanAssignCount(self):
        return self._CanAssignCount

    @CanAssignCount.setter
    def CanAssignCount(self, CanAssignCount):
        self._CanAssignCount = CanAssignCount

    @property
    def Product(self):
        return self._Product

    @Product.setter
    def Product(self, Product):
        self._Product = Product

    @property
    def ServiceGrant(self):
        return self._ServiceGrant

    @ServiceGrant.setter
    def ServiceGrant(self, ServiceGrant):
        self._ServiceGrant = ServiceGrant

    @property
    def GrantStatus(self):
        return self._GrantStatus

    @GrantStatus.setter
    def GrantStatus(self, GrantStatus):
        self._GrantStatus = GrantStatus

    @property
    def IsSetManagementScope(self):
        return self._IsSetManagementScope

    @IsSetManagementScope.setter
    def IsSetManagementScope(self, IsSetManagementScope):
        self._IsSetManagementScope = IsSetManagementScope


    def _deserialize(self, params):
        self._ServiceId = params.get("ServiceId")
        self._ProductName = params.get("ProductName")
        self._IsAssign = params.get("IsAssign")
        self._Description = params.get("Description")
        self._MemberNum = params.get("MemberNum")
        self._Document = params.get("Document")
        self._ConsoleUrl = params.get("ConsoleUrl")
        self._IsUsageStatus = params.get("IsUsageStatus")
        self._CanAssignCount = params.get("CanAssignCount")
        self._Product = params.get("Product")
        self._ServiceGrant = params.get("ServiceGrant")
        self._GrantStatus = params.get("GrantStatus")
        self._IsSetManagementScope = params.get("IsSetManagementScope")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OrganizationServiceAssignMember(AbstractModel):
    """Information on the delegated member of the organization service.

    """

    def __init__(self):
        r"""
        :param _ServiceId: Organization service ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ServiceId: int
        :param _ProductName: Organization service product name.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ProductName: str
        :param _MemberUin: Uin of the delegated admin.
Note: This field may return null, indicating that no valid values can be obtained.
        :type MemberUin: int
        :param _MemberName: Name of the delegated admin.
Note: This field may return null, indicating that no valid values can be obtained.
        :type MemberName: str
        :param _UsageStatus: Activation status. Valid values: 0 (the service has no activation status), 1 (activated), 2 (not activated).
Note: This field may return null, indicating that no valid values can be obtained.
        :type UsageStatus: int
        :param _CreateTime: Delegation time.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        :param _ManagementScope: Management scope of the delegated admin. Valid values: 1 (all members), 2 (partial members).
Note: This field may return null, indicating that no valid values can be obtained.
        :type ManagementScope: int
        :param _ManagementScopeMembers: Uin list of managed members. This parameter is valid when ManagementScope is 2.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ManagementScopeMembers: list of MemberMainInfo
        :param _ManagementScopeNodes: ID list of the managed departments. This parameter is valid when ManagementScope is 2.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ManagementScopeNodes: list of NodeMainInfo
        """
        self._ServiceId = None
        self._ProductName = None
        self._MemberUin = None
        self._MemberName = None
        self._UsageStatus = None
        self._CreateTime = None
        self._ManagementScope = None
        self._ManagementScopeMembers = None
        self._ManagementScopeNodes = None

    @property
    def ServiceId(self):
        return self._ServiceId

    @ServiceId.setter
    def ServiceId(self, ServiceId):
        self._ServiceId = ServiceId

    @property
    def ProductName(self):
        return self._ProductName

    @ProductName.setter
    def ProductName(self, ProductName):
        self._ProductName = ProductName

    @property
    def MemberUin(self):
        return self._MemberUin

    @MemberUin.setter
    def MemberUin(self, MemberUin):
        self._MemberUin = MemberUin

    @property
    def MemberName(self):
        return self._MemberName

    @MemberName.setter
    def MemberName(self, MemberName):
        self._MemberName = MemberName

    @property
    def UsageStatus(self):
        return self._UsageStatus

    @UsageStatus.setter
    def UsageStatus(self, UsageStatus):
        self._UsageStatus = UsageStatus

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ManagementScope(self):
        return self._ManagementScope

    @ManagementScope.setter
    def ManagementScope(self, ManagementScope):
        self._ManagementScope = ManagementScope

    @property
    def ManagementScopeMembers(self):
        return self._ManagementScopeMembers

    @ManagementScopeMembers.setter
    def ManagementScopeMembers(self, ManagementScopeMembers):
        self._ManagementScopeMembers = ManagementScopeMembers

    @property
    def ManagementScopeNodes(self):
        return self._ManagementScopeNodes

    @ManagementScopeNodes.setter
    def ManagementScopeNodes(self, ManagementScopeNodes):
        self._ManagementScopeNodes = ManagementScopeNodes


    def _deserialize(self, params):
        self._ServiceId = params.get("ServiceId")
        self._ProductName = params.get("ProductName")
        self._MemberUin = params.get("MemberUin")
        self._MemberName = params.get("MemberName")
        self._UsageStatus = params.get("UsageStatus")
        self._CreateTime = params.get("CreateTime")
        self._ManagementScope = params.get("ManagementScope")
        if params.get("ManagementScopeMembers") is not None:
            self._ManagementScopeMembers = []
            for item in params.get("ManagementScopeMembers"):
                obj = MemberMainInfo()
                obj._deserialize(item)
                self._ManagementScopeMembers.append(obj)
        if params.get("ManagementScopeNodes") is not None:
            self._ManagementScopeNodes = []
            for item in params.get("ManagementScopeNodes"):
                obj = NodeMainInfo()
                obj._deserialize(item)
                self._ManagementScopeNodes.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PolicyDetail(AbstractModel):
    """Policy details.

    """

    def __init__(self):
        r"""
        :param _PolicyId: Policy ID.
        :type PolicyId: int
        :param _PolicyName: Policy name.
Note: This field may return null, indicating that no valid values can be obtained.
        :type PolicyName: str
        """
        self._PolicyId = None
        self._PolicyName = None

    @property
    def PolicyId(self):
        return self._PolicyId

    @PolicyId.setter
    def PolicyId(self, PolicyId):
        self._PolicyId = PolicyId

    @property
    def PolicyName(self):
        return self._PolicyName

    @PolicyName.setter
    def PolicyName(self, PolicyName):
        self._PolicyName = PolicyName


    def _deserialize(self, params):
        self._PolicyId = params.get("PolicyId")
        self._PolicyName = params.get("PolicyName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ProvisionRoleConfigurationRequest(AbstractModel):
    """ProvisionRoleConfiguration request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _RoleConfigurationId: Permission configuration ID.
        :type RoleConfigurationId: str
        :param _TargetType: Type of the synchronized target account of the Tencent Cloud Organization. ManagerUin: admin account; MemberUin: member account.
        :type TargetType: str
        :param _TargetUin: UIN of the target account of the Tencent Cloud Organization.
        :type TargetUin: int
        """
        self._ZoneId = None
        self._RoleConfigurationId = None
        self._TargetType = None
        self._TargetUin = None

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def RoleConfigurationId(self):
        return self._RoleConfigurationId

    @RoleConfigurationId.setter
    def RoleConfigurationId(self, RoleConfigurationId):
        self._RoleConfigurationId = RoleConfigurationId

    @property
    def TargetType(self):
        return self._TargetType

    @TargetType.setter
    def TargetType(self, TargetType):
        self._TargetType = TargetType

    @property
    def TargetUin(self):
        return self._TargetUin

    @TargetUin.setter
    def TargetUin(self, TargetUin):
        self._TargetUin = TargetUin


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._RoleConfigurationId = params.get("RoleConfigurationId")
        self._TargetType = params.get("TargetType")
        self._TargetUin = params.get("TargetUin")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ProvisionRoleConfigurationResponse(AbstractModel):
    """ProvisionRoleConfiguration response structure.

    """

    def __init__(self):
        r"""
        :param _Task: Task details.
        :type Task: :class:`tencentcloud.organization.v20210331.models.RoleProvisioningsTask`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Task = None
        self._RequestId = None

    @property
    def Task(self):
        return self._Task

    @Task.setter
    def Task(self, Task):
        self._Task = Task

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Task") is not None:
            self._Task = RoleProvisioningsTask()
            self._Task._deserialize(params.get("Task"))
        self._RequestId = params.get("RequestId")


class RemoveExternalSAMLIdPCertificateRequest(AbstractModel):
    """RemoveExternalSAMLIdPCertificate request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _CertificateId: X509 certificate in PEM format, provided by the SAML identity provider.
        :type CertificateId: str
        """
        self._ZoneId = None
        self._CertificateId = None

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def CertificateId(self):
        return self._CertificateId

    @CertificateId.setter
    def CertificateId(self, CertificateId):
        self._CertificateId = CertificateId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._CertificateId = params.get("CertificateId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RemoveExternalSAMLIdPCertificateResponse(AbstractModel):
    """RemoveExternalSAMLIdPCertificate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class RemovePermissionPolicyFromRoleConfigurationRequest(AbstractModel):
    """RemovePermissionPolicyFromRoleConfiguration request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _RoleConfigurationId: Permission configuration ID.
        :type RoleConfigurationId: str
        :param _RolePolicyType: Permission policy type. Valid values: System: system policy, namely the CAM system policy reused; Custom: custom policy, namely the custom policy prepared according to the CAM permission policy syntax and structure.
        :type RolePolicyType: str
        :param _RolePolicyName: Permission policy name, which contains up to 32 characters.
        :type RolePolicyName: str
        :param _RolePolicyId: Policy ID.
        :type RolePolicyId: int
        """
        self._ZoneId = None
        self._RoleConfigurationId = None
        self._RolePolicyType = None
        self._RolePolicyName = None
        self._RolePolicyId = None

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def RoleConfigurationId(self):
        return self._RoleConfigurationId

    @RoleConfigurationId.setter
    def RoleConfigurationId(self, RoleConfigurationId):
        self._RoleConfigurationId = RoleConfigurationId

    @property
    def RolePolicyType(self):
        return self._RolePolicyType

    @RolePolicyType.setter
    def RolePolicyType(self, RolePolicyType):
        self._RolePolicyType = RolePolicyType

    @property
    def RolePolicyName(self):
        return self._RolePolicyName

    @RolePolicyName.setter
    def RolePolicyName(self, RolePolicyName):
        self._RolePolicyName = RolePolicyName

    @property
    def RolePolicyId(self):
        return self._RolePolicyId

    @RolePolicyId.setter
    def RolePolicyId(self, RolePolicyId):
        self._RolePolicyId = RolePolicyId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._RoleConfigurationId = params.get("RoleConfigurationId")
        self._RolePolicyType = params.get("RolePolicyType")
        self._RolePolicyName = params.get("RolePolicyName")
        self._RolePolicyId = params.get("RolePolicyId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RemovePermissionPolicyFromRoleConfigurationResponse(AbstractModel):
    """RemovePermissionPolicyFromRoleConfiguration response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class RemoveUserFromGroupRequest(AbstractModel):
    """RemoveUserFromGroup request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _GroupId: User group ID.
        :type GroupId: str
        :param _UserId: User ID.
        :type UserId: str
        """
        self._ZoneId = None
        self._GroupId = None
        self._UserId = None

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def GroupId(self):
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def UserId(self):
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._GroupId = params.get("GroupId")
        self._UserId = params.get("UserId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RemoveUserFromGroupResponse(AbstractModel):
    """RemoveUserFromGroup response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class RoleAssignmentInfo(AbstractModel):
    """Authorized member account information.

    """

    def __init__(self):
        r"""
        :param _PrincipalId: Identity ID for the CAM user synchronization. Valid values:
When the PrincipalType value is Group, it is the CIC user group ID (g-********).
When the PrincipalType value is User, it is the CIC user ID (u-********).
        :type PrincipalId: str
        :param _PrincipalType: Identity type for the CAM user synchronization. Valid values:

User: indicates that the identity for the CAM user synchronization is a CIC user.
Group: indicates that the identity for the CAM user synchronization is a CIC user group.
        :type PrincipalType: str
        :param _TargetUin: UIN of the synchronized target account of the Tencent Cloud Organization.
        :type TargetUin: int
        :param _TargetType: Type of the synchronized target account of the Tencent Cloud Organization. ManagerUin: admin account; MemberUin: member account.
        :type TargetType: str
        :param _RoleConfigurationId: Permission configuration ID.
        :type RoleConfigurationId: str
        """
        self._PrincipalId = None
        self._PrincipalType = None
        self._TargetUin = None
        self._TargetType = None
        self._RoleConfigurationId = None

    @property
    def PrincipalId(self):
        return self._PrincipalId

    @PrincipalId.setter
    def PrincipalId(self, PrincipalId):
        self._PrincipalId = PrincipalId

    @property
    def PrincipalType(self):
        return self._PrincipalType

    @PrincipalType.setter
    def PrincipalType(self, PrincipalType):
        self._PrincipalType = PrincipalType

    @property
    def TargetUin(self):
        return self._TargetUin

    @TargetUin.setter
    def TargetUin(self, TargetUin):
        self._TargetUin = TargetUin

    @property
    def TargetType(self):
        return self._TargetType

    @TargetType.setter
    def TargetType(self, TargetType):
        self._TargetType = TargetType

    @property
    def RoleConfigurationId(self):
        return self._RoleConfigurationId

    @RoleConfigurationId.setter
    def RoleConfigurationId(self, RoleConfigurationId):
        self._RoleConfigurationId = RoleConfigurationId


    def _deserialize(self, params):
        self._PrincipalId = params.get("PrincipalId")
        self._PrincipalType = params.get("PrincipalType")
        self._TargetUin = params.get("TargetUin")
        self._TargetType = params.get("TargetType")
        self._RoleConfigurationId = params.get("RoleConfigurationId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RoleAssignments(AbstractModel):
    """Authorization details of the member account.

    """

    def __init__(self):
        r"""
        :param _RoleConfigurationId: Permission configuration ID.
        :type RoleConfigurationId: str
        :param _RoleConfigurationName: Permission configuration name.
        :type RoleConfigurationName: str
        :param _TargetUin: UIN of the target account of the Tencent Cloud Organization.
        :type TargetUin: int
        :param _TargetType: Type of the synchronized target account of the Tencent Cloud Organization. ManagerUin: admin account; MemberUin: member account.
        :type TargetType: str
        :param _PrincipalId: Identity ID for the CAM user synchronization. Valid values: When the PrincipalType value is Group, it is the CIC user group ID (g-********). When the PrincipalType value is User, it is the CIC user ID (u-********).
        :type PrincipalId: str
        :param _PrincipalType: Identity type for the CAM user synchronization. Valid values: User: indicates that the identity for the CAM user synchronization is a CIC user; Group: indicates that the identity for the CAM user synchronization is a CIC user group.
        :type PrincipalType: str
        :param _PrincipalName: User name or user group name.
        :type PrincipalName: str
        :param _CreateTime: Creation time.
        :type CreateTime: str
        :param _UpdateTime: Update time.
        :type UpdateTime: str
        :param _TargetName: Name of the target account of the Tencent Cloud Organization.
        :type TargetName: str
        """
        self._RoleConfigurationId = None
        self._RoleConfigurationName = None
        self._TargetUin = None
        self._TargetType = None
        self._PrincipalId = None
        self._PrincipalType = None
        self._PrincipalName = None
        self._CreateTime = None
        self._UpdateTime = None
        self._TargetName = None

    @property
    def RoleConfigurationId(self):
        return self._RoleConfigurationId

    @RoleConfigurationId.setter
    def RoleConfigurationId(self, RoleConfigurationId):
        self._RoleConfigurationId = RoleConfigurationId

    @property
    def RoleConfigurationName(self):
        return self._RoleConfigurationName

    @RoleConfigurationName.setter
    def RoleConfigurationName(self, RoleConfigurationName):
        self._RoleConfigurationName = RoleConfigurationName

    @property
    def TargetUin(self):
        return self._TargetUin

    @TargetUin.setter
    def TargetUin(self, TargetUin):
        self._TargetUin = TargetUin

    @property
    def TargetType(self):
        return self._TargetType

    @TargetType.setter
    def TargetType(self, TargetType):
        self._TargetType = TargetType

    @property
    def PrincipalId(self):
        return self._PrincipalId

    @PrincipalId.setter
    def PrincipalId(self, PrincipalId):
        self._PrincipalId = PrincipalId

    @property
    def PrincipalType(self):
        return self._PrincipalType

    @PrincipalType.setter
    def PrincipalType(self, PrincipalType):
        self._PrincipalType = PrincipalType

    @property
    def PrincipalName(self):
        return self._PrincipalName

    @PrincipalName.setter
    def PrincipalName(self, PrincipalName):
        self._PrincipalName = PrincipalName

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def TargetName(self):
        return self._TargetName

    @TargetName.setter
    def TargetName(self, TargetName):
        self._TargetName = TargetName


    def _deserialize(self, params):
        self._RoleConfigurationId = params.get("RoleConfigurationId")
        self._RoleConfigurationName = params.get("RoleConfigurationName")
        self._TargetUin = params.get("TargetUin")
        self._TargetType = params.get("TargetType")
        self._PrincipalId = params.get("PrincipalId")
        self._PrincipalType = params.get("PrincipalType")
        self._PrincipalName = params.get("PrincipalName")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._TargetName = params.get("TargetName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RoleConfiguration(AbstractModel):
    """CIC permission configuration.

    """

    def __init__(self):
        r"""
        :param _RoleConfigurationId: Permission configuration ID.
        :type RoleConfigurationId: str
        :param _RoleConfigurationName: Permission configuration name.
        :type RoleConfigurationName: str
        :param _Description: Permission configuration description.
        :type Description: str
        :param _SessionDuration: Session duration. It indicates the maximum session duration when CIC users use the access configuration to access member accounts.
Unit: seconds.
        :type SessionDuration: int
        :param _RelayState: Initial access page. It indicates the initial access page URL when CIC users use the access configuration to access member accounts.
        :type RelayState: str
        :param _CreateTime: Creation time of the permission configuration.
        :type CreateTime: str
        :param _UpdateTime: Update time of the permission configuration.
        :type UpdateTime: str
        :param _IsSelected: If the input parameter FilterTargets is provided, check whether the member account has been configured with permissions. If configured, return true; otherwise, return false.
        :type IsSelected: bool
        """
        self._RoleConfigurationId = None
        self._RoleConfigurationName = None
        self._Description = None
        self._SessionDuration = None
        self._RelayState = None
        self._CreateTime = None
        self._UpdateTime = None
        self._IsSelected = None

    @property
    def RoleConfigurationId(self):
        return self._RoleConfigurationId

    @RoleConfigurationId.setter
    def RoleConfigurationId(self, RoleConfigurationId):
        self._RoleConfigurationId = RoleConfigurationId

    @property
    def RoleConfigurationName(self):
        return self._RoleConfigurationName

    @RoleConfigurationName.setter
    def RoleConfigurationName(self, RoleConfigurationName):
        self._RoleConfigurationName = RoleConfigurationName

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def SessionDuration(self):
        return self._SessionDuration

    @SessionDuration.setter
    def SessionDuration(self, SessionDuration):
        self._SessionDuration = SessionDuration

    @property
    def RelayState(self):
        return self._RelayState

    @RelayState.setter
    def RelayState(self, RelayState):
        self._RelayState = RelayState

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def IsSelected(self):
        return self._IsSelected

    @IsSelected.setter
    def IsSelected(self, IsSelected):
        self._IsSelected = IsSelected


    def _deserialize(self, params):
        self._RoleConfigurationId = params.get("RoleConfigurationId")
        self._RoleConfigurationName = params.get("RoleConfigurationName")
        self._Description = params.get("Description")
        self._SessionDuration = params.get("SessionDuration")
        self._RelayState = params.get("RelayState")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._IsSelected = params.get("IsSelected")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RoleConfigurationProvisionings(AbstractModel):
    """Permission configuration synchronization.

    """

    def __init__(self):
        r"""
        :param _DeploymentStatus: Deployed: Deployment succeeded; DeployedRequired: Redeployment required; DeployFailed: Deployment failed.
        :type DeploymentStatus: str
        :param _RoleConfigurationId: Permission configuration ID.
        :type RoleConfigurationId: str
        :param _RoleConfigurationName: Permission configuration name.
        :type RoleConfigurationName: str
        :param _TargetUin: UIN of the target account of the Tencent Cloud Organization.
        :type TargetUin: int
        :param _TargetName: Name of the target account of the Tencent Cloud Organization.
        :type TargetName: str
        :param _CreateTime: Creation time.
        :type CreateTime: str
        :param _UpdateTime: Modification time.
        :type UpdateTime: str
        :param _TargetType: Type of the synchronized target account of the Tencent Cloud Organization. ManagerUin: admin account; MemberUin: member account.
        :type TargetType: str
        """
        self._DeploymentStatus = None
        self._RoleConfigurationId = None
        self._RoleConfigurationName = None
        self._TargetUin = None
        self._TargetName = None
        self._CreateTime = None
        self._UpdateTime = None
        self._TargetType = None

    @property
    def DeploymentStatus(self):
        return self._DeploymentStatus

    @DeploymentStatus.setter
    def DeploymentStatus(self, DeploymentStatus):
        self._DeploymentStatus = DeploymentStatus

    @property
    def RoleConfigurationId(self):
        return self._RoleConfigurationId

    @RoleConfigurationId.setter
    def RoleConfigurationId(self, RoleConfigurationId):
        self._RoleConfigurationId = RoleConfigurationId

    @property
    def RoleConfigurationName(self):
        return self._RoleConfigurationName

    @RoleConfigurationName.setter
    def RoleConfigurationName(self, RoleConfigurationName):
        self._RoleConfigurationName = RoleConfigurationName

    @property
    def TargetUin(self):
        return self._TargetUin

    @TargetUin.setter
    def TargetUin(self, TargetUin):
        self._TargetUin = TargetUin

    @property
    def TargetName(self):
        return self._TargetName

    @TargetName.setter
    def TargetName(self, TargetName):
        self._TargetName = TargetName

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def TargetType(self):
        return self._TargetType

    @TargetType.setter
    def TargetType(self, TargetType):
        self._TargetType = TargetType


    def _deserialize(self, params):
        self._DeploymentStatus = params.get("DeploymentStatus")
        self._RoleConfigurationId = params.get("RoleConfigurationId")
        self._RoleConfigurationName = params.get("RoleConfigurationName")
        self._TargetUin = params.get("TargetUin")
        self._TargetName = params.get("TargetName")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._TargetType = params.get("TargetType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RolePolicie(AbstractModel):
    """CIC permission policy.

    """

    def __init__(self):
        r"""
        :param _RolePolicyId: Policy ID.
Note: This field may return null, indicating that no valid values can be obtained.
        :type RolePolicyId: int
        :param _RolePolicyName: Permission policy name.
        :type RolePolicyName: str
        :param _RolePolicyType: Permission policy type.
        :type RolePolicyType: str
        :param _RolePolicyDocument: Custom policy content. This parameter is only returned for custom policies.
        :type RolePolicyDocument: str
        :param _AddTime: The time when the permission policy is added to the permission configuration.
        :type AddTime: str
        """
        self._RolePolicyId = None
        self._RolePolicyName = None
        self._RolePolicyType = None
        self._RolePolicyDocument = None
        self._AddTime = None

    @property
    def RolePolicyId(self):
        return self._RolePolicyId

    @RolePolicyId.setter
    def RolePolicyId(self, RolePolicyId):
        self._RolePolicyId = RolePolicyId

    @property
    def RolePolicyName(self):
        return self._RolePolicyName

    @RolePolicyName.setter
    def RolePolicyName(self, RolePolicyName):
        self._RolePolicyName = RolePolicyName

    @property
    def RolePolicyType(self):
        return self._RolePolicyType

    @RolePolicyType.setter
    def RolePolicyType(self, RolePolicyType):
        self._RolePolicyType = RolePolicyType

    @property
    def RolePolicyDocument(self):
        return self._RolePolicyDocument

    @RolePolicyDocument.setter
    def RolePolicyDocument(self, RolePolicyDocument):
        self._RolePolicyDocument = RolePolicyDocument

    @property
    def AddTime(self):
        return self._AddTime

    @AddTime.setter
    def AddTime(self, AddTime):
        self._AddTime = AddTime


    def _deserialize(self, params):
        self._RolePolicyId = params.get("RolePolicyId")
        self._RolePolicyName = params.get("RolePolicyName")
        self._RolePolicyType = params.get("RolePolicyType")
        self._RolePolicyDocument = params.get("RolePolicyDocument")
        self._AddTime = params.get("AddTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RoleProvisioningsTask(AbstractModel):
    """Status information of the role synchronization task.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID.
        :type TaskId: str
        :param _RoleConfigurationId: Permission configuration ID.
        :type RoleConfigurationId: str
        :param _RoleConfigurationName: Permission configuration name.
        :type RoleConfigurationName: str
        :param _TargetUin: UIN of the authorized target account of the Tencent Cloud Organization.
        :type TargetUin: int
        :param _TargetType: Type of the synchronized target account of the Tencent Cloud Organization. ManagerUin: admin account; MemberUin: member account.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TargetType: str
        :param _TaskType: Task type.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TaskType: str
        :param _TaskStatus: Task status. InProgress: The task is in progress; Failed: The task failed; Success: The task succeeded.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TaskStatus: str
        """
        self._TaskId = None
        self._RoleConfigurationId = None
        self._RoleConfigurationName = None
        self._TargetUin = None
        self._TargetType = None
        self._TaskType = None
        self._TaskStatus = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RoleConfigurationId(self):
        return self._RoleConfigurationId

    @RoleConfigurationId.setter
    def RoleConfigurationId(self, RoleConfigurationId):
        self._RoleConfigurationId = RoleConfigurationId

    @property
    def RoleConfigurationName(self):
        return self._RoleConfigurationName

    @RoleConfigurationName.setter
    def RoleConfigurationName(self, RoleConfigurationName):
        self._RoleConfigurationName = RoleConfigurationName

    @property
    def TargetUin(self):
        return self._TargetUin

    @TargetUin.setter
    def TargetUin(self, TargetUin):
        self._TargetUin = TargetUin

    @property
    def TargetType(self):
        return self._TargetType

    @TargetType.setter
    def TargetType(self, TargetType):
        self._TargetType = TargetType

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def TaskStatus(self):
        return self._TaskStatus

    @TaskStatus.setter
    def TaskStatus(self, TaskStatus):
        self._TaskStatus = TaskStatus


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RoleConfigurationId = params.get("RoleConfigurationId")
        self._RoleConfigurationName = params.get("RoleConfigurationName")
        self._TargetUin = params.get("TargetUin")
        self._TargetType = params.get("TargetType")
        self._TaskType = params.get("TaskType")
        self._TaskStatus = params.get("TaskStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SAMLIdPCertificate(AbstractModel):
    """SAML signing certificate information.

    """

    def __init__(self):
        r"""
        :param _SerialNumber: Certificate serial number.
        :type SerialNumber: str
        :param _Issuer: Certificate issuer.
        :type Issuer: str
        :param _Version: Certificate version.
        :type Version: int
        :param _CertificateId: Certificate ID.
        :type CertificateId: str
        :param _PublicKey: Public key certificate in PEM format (Base64 encoded).
        :type PublicKey: str
        :param _SignatureAlgorithm: Signature algorithm of the certificate.
        :type SignatureAlgorithm: str
        :param _NotAfter: Expiration time of the certificate.
        :type NotAfter: str
        :param _NotBefore: Creation time of the certificate.
        :type NotBefore: str
        :param _Subject: Certificate subject.
        :type Subject: str
        :param _X509Certificate: X509 certificate in PEM format.
        :type X509Certificate: str
        """
        self._SerialNumber = None
        self._Issuer = None
        self._Version = None
        self._CertificateId = None
        self._PublicKey = None
        self._SignatureAlgorithm = None
        self._NotAfter = None
        self._NotBefore = None
        self._Subject = None
        self._X509Certificate = None

    @property
    def SerialNumber(self):
        return self._SerialNumber

    @SerialNumber.setter
    def SerialNumber(self, SerialNumber):
        self._SerialNumber = SerialNumber

    @property
    def Issuer(self):
        return self._Issuer

    @Issuer.setter
    def Issuer(self, Issuer):
        self._Issuer = Issuer

    @property
    def Version(self):
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def CertificateId(self):
        return self._CertificateId

    @CertificateId.setter
    def CertificateId(self, CertificateId):
        self._CertificateId = CertificateId

    @property
    def PublicKey(self):
        return self._PublicKey

    @PublicKey.setter
    def PublicKey(self, PublicKey):
        self._PublicKey = PublicKey

    @property
    def SignatureAlgorithm(self):
        return self._SignatureAlgorithm

    @SignatureAlgorithm.setter
    def SignatureAlgorithm(self, SignatureAlgorithm):
        self._SignatureAlgorithm = SignatureAlgorithm

    @property
    def NotAfter(self):
        return self._NotAfter

    @NotAfter.setter
    def NotAfter(self, NotAfter):
        self._NotAfter = NotAfter

    @property
    def NotBefore(self):
        return self._NotBefore

    @NotBefore.setter
    def NotBefore(self, NotBefore):
        self._NotBefore = NotBefore

    @property
    def Subject(self):
        return self._Subject

    @Subject.setter
    def Subject(self, Subject):
        self._Subject = Subject

    @property
    def X509Certificate(self):
        return self._X509Certificate

    @X509Certificate.setter
    def X509Certificate(self, X509Certificate):
        self._X509Certificate = X509Certificate


    def _deserialize(self, params):
        self._SerialNumber = params.get("SerialNumber")
        self._Issuer = params.get("Issuer")
        self._Version = params.get("Version")
        self._CertificateId = params.get("CertificateId")
        self._PublicKey = params.get("PublicKey")
        self._SignatureAlgorithm = params.get("SignatureAlgorithm")
        self._NotAfter = params.get("NotAfter")
        self._NotBefore = params.get("NotBefore")
        self._Subject = params.get("Subject")
        self._X509Certificate = params.get("X509Certificate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SAMLIdentityProviderConfiguration(AbstractModel):
    """SAML identity provider configuration information.

    """

    def __init__(self):
        r"""
        :param _EntityId: IdP identifier.
        :type EntityId: str
        :param _SSOStatus: SSO enabling status. Valid values: Enabled, Disabled (default).
        :type SSOStatus: str
        :param _EncodedMetadataDocument: IdP metadata document (Base64 encoded).
        :type EncodedMetadataDocument: str
        :param _CertificateIds: X509 certificate ID.
        :type CertificateIds: list of str
        :param _LoginUrl: IdP login URL.
        :type LoginUrl: str
        :param _CreateTime: Creation time.
        :type CreateTime: str
        :param _UpdateTime: Update time.
        :type UpdateTime: str
        """
        self._EntityId = None
        self._SSOStatus = None
        self._EncodedMetadataDocument = None
        self._CertificateIds = None
        self._LoginUrl = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def EntityId(self):
        return self._EntityId

    @EntityId.setter
    def EntityId(self, EntityId):
        self._EntityId = EntityId

    @property
    def SSOStatus(self):
        return self._SSOStatus

    @SSOStatus.setter
    def SSOStatus(self, SSOStatus):
        self._SSOStatus = SSOStatus

    @property
    def EncodedMetadataDocument(self):
        return self._EncodedMetadataDocument

    @EncodedMetadataDocument.setter
    def EncodedMetadataDocument(self, EncodedMetadataDocument):
        self._EncodedMetadataDocument = EncodedMetadataDocument

    @property
    def CertificateIds(self):
        return self._CertificateIds

    @CertificateIds.setter
    def CertificateIds(self, CertificateIds):
        self._CertificateIds = CertificateIds

    @property
    def LoginUrl(self):
        return self._LoginUrl

    @LoginUrl.setter
    def LoginUrl(self, LoginUrl):
        self._LoginUrl = LoginUrl

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._EntityId = params.get("EntityId")
        self._SSOStatus = params.get("SSOStatus")
        self._EncodedMetadataDocument = params.get("EncodedMetadataDocument")
        self._CertificateIds = params.get("CertificateIds")
        self._LoginUrl = params.get("LoginUrl")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SAMLServiceProvider(AbstractModel):
    """SAML service provider information.

    """

    def __init__(self):
        r"""
        :param _EntityId: https://tencentcloudsso.com/saml/sp/z-sjw8ensa**
        :type EntityId: str
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _EncodedMetadataDocument: SP metadata document (Base64 encoded).
        :type EncodedMetadataDocument: str
        :param _AcsUrl: SP ACS URL.
        :type AcsUrl: str
        """
        self._EntityId = None
        self._ZoneId = None
        self._EncodedMetadataDocument = None
        self._AcsUrl = None

    @property
    def EntityId(self):
        return self._EntityId

    @EntityId.setter
    def EntityId(self, EntityId):
        self._EntityId = EntityId

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def EncodedMetadataDocument(self):
        return self._EncodedMetadataDocument

    @EncodedMetadataDocument.setter
    def EncodedMetadataDocument(self, EncodedMetadataDocument):
        self._EncodedMetadataDocument = EncodedMetadataDocument

    @property
    def AcsUrl(self):
        return self._AcsUrl

    @AcsUrl.setter
    def AcsUrl(self, AcsUrl):
        self._AcsUrl = AcsUrl


    def _deserialize(self, params):
        self._EntityId = params.get("EntityId")
        self._ZoneId = params.get("ZoneId")
        self._EncodedMetadataDocument = params.get("EncodedMetadataDocument")
        self._AcsUrl = params.get("AcsUrl")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SetExternalSAMLIdentityProviderRequest(AbstractModel):
    """SetExternalSAMLIdentityProvider request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _EncodedMetadataDocument: IdP metadata document (Base64 encoded). Provided by an IdP that supports the SAML 2.0 protocol.
        :type EncodedMetadataDocument: str
        :param _SSOStatus: SSO enabling status. Valid values: Enabled, Disabled (default).
        :type SSOStatus: str
        :param _EntityId: IdP identifier.
        :type EntityId: str
        :param _LoginUrl: IdP login URL.
        :type LoginUrl: str
        :param _X509Certificate: X509 certificate in PEM format. If this parameter is specified, all existing certificates will be replaced.
        :type X509Certificate: str
        """
        self._ZoneId = None
        self._EncodedMetadataDocument = None
        self._SSOStatus = None
        self._EntityId = None
        self._LoginUrl = None
        self._X509Certificate = None

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def EncodedMetadataDocument(self):
        return self._EncodedMetadataDocument

    @EncodedMetadataDocument.setter
    def EncodedMetadataDocument(self, EncodedMetadataDocument):
        self._EncodedMetadataDocument = EncodedMetadataDocument

    @property
    def SSOStatus(self):
        return self._SSOStatus

    @SSOStatus.setter
    def SSOStatus(self, SSOStatus):
        self._SSOStatus = SSOStatus

    @property
    def EntityId(self):
        return self._EntityId

    @EntityId.setter
    def EntityId(self, EntityId):
        self._EntityId = EntityId

    @property
    def LoginUrl(self):
        return self._LoginUrl

    @LoginUrl.setter
    def LoginUrl(self, LoginUrl):
        self._LoginUrl = LoginUrl

    @property
    def X509Certificate(self):
        return self._X509Certificate

    @X509Certificate.setter
    def X509Certificate(self, X509Certificate):
        self._X509Certificate = X509Certificate


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._EncodedMetadataDocument = params.get("EncodedMetadataDocument")
        self._SSOStatus = params.get("SSOStatus")
        self._EntityId = params.get("EntityId")
        self._LoginUrl = params.get("LoginUrl")
        self._X509Certificate = params.get("X509Certificate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SetExternalSAMLIdentityProviderResponse(AbstractModel):
    """SetExternalSAMLIdentityProvider response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class Tag(AbstractModel):
    """Tag key-value pair.

    """

    def __init__(self):
        r"""
        :param _TagKey: Tag key

Note: This field may return null, indicating that no valid values can be obtained.
        :type TagKey: str
        :param _TagValue: Tag value

Note: This field may return null, indicating that no valid values can be obtained.
        :type TagValue: str
        """
        self._TagKey = None
        self._TagValue = None

    @property
    def TagKey(self):
        return self._TagKey

    @TagKey.setter
    def TagKey(self, TagKey):
        self._TagKey = TagKey

    @property
    def TagValue(self):
        return self._TagValue

    @TagValue.setter
    def TagValue(self, TagValue):
        self._TagValue = TagValue


    def _deserialize(self, params):
        self._TagKey = params.get("TagKey")
        self._TagValue = params.get("TagValue")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class TaskInfo(AbstractModel):
    """Task status information.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID.
        :type TaskId: str
        :param _RoleConfigurationId: Permission configuration ID.
        :type RoleConfigurationId: str
        :param _RoleConfigurationName: Permission configuration name.
        :type RoleConfigurationName: str
        :param _TargetUin: UIN of the authorized target member account.
        :type TargetUin: int
        :param _TargetType: Type of the synchronized target account. ManagerUin: admin account; MemberUin: member account.
        :type TargetType: str
        :param _PrincipalId: Identity ID for the user authorization. If the identity type is CIC user, it is the user ID; if the identity type is user group, it is the user group ID.
        :type PrincipalId: str
        :param _PrincipalType: Identity type for the user authorization. User: CIC user; Group: CIC user group.
        :type PrincipalType: str
        :param _TaskType: Task type.
        :type TaskType: str
        :param _Status: InProgress: The task is being executed; Success: The task execution succeeded; Failed: The task execution failed.
        :type Status: str
        :param _FailureReason: Cause of the failure.
Note: This field may return null, indicating that no valid values can be obtained.
        :type FailureReason: str
        """
        self._TaskId = None
        self._RoleConfigurationId = None
        self._RoleConfigurationName = None
        self._TargetUin = None
        self._TargetType = None
        self._PrincipalId = None
        self._PrincipalType = None
        self._TaskType = None
        self._Status = None
        self._FailureReason = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RoleConfigurationId(self):
        return self._RoleConfigurationId

    @RoleConfigurationId.setter
    def RoleConfigurationId(self, RoleConfigurationId):
        self._RoleConfigurationId = RoleConfigurationId

    @property
    def RoleConfigurationName(self):
        return self._RoleConfigurationName

    @RoleConfigurationName.setter
    def RoleConfigurationName(self, RoleConfigurationName):
        self._RoleConfigurationName = RoleConfigurationName

    @property
    def TargetUin(self):
        return self._TargetUin

    @TargetUin.setter
    def TargetUin(self, TargetUin):
        self._TargetUin = TargetUin

    @property
    def TargetType(self):
        return self._TargetType

    @TargetType.setter
    def TargetType(self, TargetType):
        self._TargetType = TargetType

    @property
    def PrincipalId(self):
        return self._PrincipalId

    @PrincipalId.setter
    def PrincipalId(self, PrincipalId):
        self._PrincipalId = PrincipalId

    @property
    def PrincipalType(self):
        return self._PrincipalType

    @PrincipalType.setter
    def PrincipalType(self, PrincipalType):
        self._PrincipalType = PrincipalType

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def FailureReason(self):
        return self._FailureReason

    @FailureReason.setter
    def FailureReason(self, FailureReason):
        self._FailureReason = FailureReason


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RoleConfigurationId = params.get("RoleConfigurationId")
        self._RoleConfigurationName = params.get("RoleConfigurationName")
        self._TargetUin = params.get("TargetUin")
        self._TargetType = params.get("TargetType")
        self._PrincipalId = params.get("PrincipalId")
        self._PrincipalType = params.get("PrincipalType")
        self._TaskType = params.get("TaskType")
        self._Status = params.get("Status")
        self._FailureReason = params.get("FailureReason")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class TaskStatus(AbstractModel):
    """Task status information.

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: InProgress: The task is being executed; Success: The task execution succeeded; Failed: The task execution failed.
        :type Status: str
        :param _TaskId: Task ID.
        :type TaskId: str
        :param _TaskType: Task type. Valid values:ProvisionRoleConfiguration: Deploy permission configurations.
DeprovisionRoleConfiguration: Undeploy permission configurations.CreateRoleAssignment: Grant authorizations on member accounts.
DeleteRoleAssignment: Remove authorizations on member accounts.
        :type TaskType: str
        :param _FailureReason: Cause of task failure.
Description.
This parameter is displayed only when the Status is Failed.
        :type FailureReason: str
        """
        self._Status = None
        self._TaskId = None
        self._TaskType = None
        self._FailureReason = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def FailureReason(self):
        return self._FailureReason

    @FailureReason.setter
    def FailureReason(self, FailureReason):
        self._FailureReason = FailureReason


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._TaskId = params.get("TaskId")
        self._TaskType = params.get("TaskType")
        self._FailureReason = params.get("FailureReason")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UpdateGroupRequest(AbstractModel):
    """UpdateGroup request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _GroupId: User group ID.
        :type GroupId: str
        :param _NewGroupName: New user group name.
        :type NewGroupName: str
        :param _NewDescription: New user group description.
        :type NewDescription: str
        """
        self._ZoneId = None
        self._GroupId = None
        self._NewGroupName = None
        self._NewDescription = None

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def GroupId(self):
        return self._GroupId

    @GroupId.setter
    def GroupId(self, GroupId):
        self._GroupId = GroupId

    @property
    def NewGroupName(self):
        return self._NewGroupName

    @NewGroupName.setter
    def NewGroupName(self, NewGroupName):
        self._NewGroupName = NewGroupName

    @property
    def NewDescription(self):
        return self._NewDescription

    @NewDescription.setter
    def NewDescription(self, NewDescription):
        self._NewDescription = NewDescription


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._GroupId = params.get("GroupId")
        self._NewGroupName = params.get("NewGroupName")
        self._NewDescription = params.get("NewDescription")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UpdateGroupResponse(AbstractModel):
    """UpdateGroup response structure.

    """

    def __init__(self):
        r"""
        :param _GroupInfo: User group information.
        :type GroupInfo: :class:`tencentcloud.organization.v20210331.models.GroupInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._GroupInfo = None
        self._RequestId = None

    @property
    def GroupInfo(self):
        return self._GroupInfo

    @GroupInfo.setter
    def GroupInfo(self, GroupInfo):
        self._GroupInfo = GroupInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("GroupInfo") is not None:
            self._GroupInfo = GroupInfo()
            self._GroupInfo._deserialize(params.get("GroupInfo"))
        self._RequestId = params.get("RequestId")


class UpdateOrganizationNodeRequest(AbstractModel):
    """UpdateOrganizationNode request structure.

    """

    def __init__(self):
        r"""
        :param _NodeId: Node ID, which can be obtained through [DescribeOrganizationNodes](https://intl.cloud.tencent.com/document/product/850/82926?from_cn_redirect=1).
        :type NodeId: int
        :param _Name: Node name, which can contain up to 40 letters, digits, and symbols `+@&._[]-`.
        :type Name: str
        :param _Remark: Remarks.
        :type Remark: str
        """
        self._NodeId = None
        self._Name = None
        self._Remark = None

    @property
    def NodeId(self):
        return self._NodeId

    @NodeId.setter
    def NodeId(self, NodeId):
        self._NodeId = NodeId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Remark(self):
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark


    def _deserialize(self, params):
        self._NodeId = params.get("NodeId")
        self._Name = params.get("Name")
        self._Remark = params.get("Remark")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UpdateOrganizationNodeResponse(AbstractModel):
    """UpdateOrganizationNode response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class UpdateRoleConfigurationRequest(AbstractModel):
    """UpdateRoleConfiguration request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _RoleConfigurationId: Permission configuration ID.
        :type RoleConfigurationId: str
        :param _NewDescription: Description of new access configuration, which contains up to 1024 characters.
        :type NewDescription: str
        :param _NewSessionDuration: New session duration. It indicates the maximum session duration when CIC users use the access configuration to access the target account of the Tencent Cloud Organization. Unit: seconds. Value range: 900-43,200 (15 minutes to 12 hours).
        :type NewSessionDuration: int
        :param _NewRelayState: New initial access page. It indicates the initial access page URL when CIC users use the access configuration to access the target account of the Tencent Cloud Organization. This page must be the Tencent Cloud console page.
        :type NewRelayState: str
        """
        self._ZoneId = None
        self._RoleConfigurationId = None
        self._NewDescription = None
        self._NewSessionDuration = None
        self._NewRelayState = None

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def RoleConfigurationId(self):
        return self._RoleConfigurationId

    @RoleConfigurationId.setter
    def RoleConfigurationId(self, RoleConfigurationId):
        self._RoleConfigurationId = RoleConfigurationId

    @property
    def NewDescription(self):
        return self._NewDescription

    @NewDescription.setter
    def NewDescription(self, NewDescription):
        self._NewDescription = NewDescription

    @property
    def NewSessionDuration(self):
        return self._NewSessionDuration

    @NewSessionDuration.setter
    def NewSessionDuration(self, NewSessionDuration):
        self._NewSessionDuration = NewSessionDuration

    @property
    def NewRelayState(self):
        return self._NewRelayState

    @NewRelayState.setter
    def NewRelayState(self, NewRelayState):
        self._NewRelayState = NewRelayState


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._RoleConfigurationId = params.get("RoleConfigurationId")
        self._NewDescription = params.get("NewDescription")
        self._NewSessionDuration = params.get("NewSessionDuration")
        self._NewRelayState = params.get("NewRelayState")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UpdateRoleConfigurationResponse(AbstractModel):
    """UpdateRoleConfiguration response structure.

    """

    def __init__(self):
        r"""
        :param _RoleConfigurationInfo: Permission configuration details.
        :type RoleConfigurationInfo: :class:`tencentcloud.organization.v20210331.models.RoleConfiguration`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RoleConfigurationInfo = None
        self._RequestId = None

    @property
    def RoleConfigurationInfo(self):
        return self._RoleConfigurationInfo

    @RoleConfigurationInfo.setter
    def RoleConfigurationInfo(self, RoleConfigurationInfo):
        self._RoleConfigurationInfo = RoleConfigurationInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RoleConfigurationInfo") is not None:
            self._RoleConfigurationInfo = RoleConfiguration()
            self._RoleConfigurationInfo._deserialize(params.get("RoleConfigurationInfo"))
        self._RequestId = params.get("RequestId")


class UpdateUserRequest(AbstractModel):
    """UpdateUser request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _UserId: User ID.
        :type UserId: str
        :param _NewFirstName: First name of the user.
        :type NewFirstName: str
        :param _NewLastName: Last name of the user.
        :type NewLastName: str
        :param _NewDisplayName: Display name of the user.
        :type NewDisplayName: str
        :param _NewDescription: User description.
        :type NewDescription: str
        :param _NewEmail: Email address of the user.
        :type NewEmail: str
        """
        self._ZoneId = None
        self._UserId = None
        self._NewFirstName = None
        self._NewLastName = None
        self._NewDisplayName = None
        self._NewDescription = None
        self._NewEmail = None

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def UserId(self):
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def NewFirstName(self):
        return self._NewFirstName

    @NewFirstName.setter
    def NewFirstName(self, NewFirstName):
        self._NewFirstName = NewFirstName

    @property
    def NewLastName(self):
        return self._NewLastName

    @NewLastName.setter
    def NewLastName(self, NewLastName):
        self._NewLastName = NewLastName

    @property
    def NewDisplayName(self):
        return self._NewDisplayName

    @NewDisplayName.setter
    def NewDisplayName(self, NewDisplayName):
        self._NewDisplayName = NewDisplayName

    @property
    def NewDescription(self):
        return self._NewDescription

    @NewDescription.setter
    def NewDescription(self, NewDescription):
        self._NewDescription = NewDescription

    @property
    def NewEmail(self):
        return self._NewEmail

    @NewEmail.setter
    def NewEmail(self, NewEmail):
        self._NewEmail = NewEmail


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._UserId = params.get("UserId")
        self._NewFirstName = params.get("NewFirstName")
        self._NewLastName = params.get("NewLastName")
        self._NewDisplayName = params.get("NewDisplayName")
        self._NewDescription = params.get("NewDescription")
        self._NewEmail = params.get("NewEmail")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UpdateUserResponse(AbstractModel):
    """UpdateUser response structure.

    """

    def __init__(self):
        r"""
        :param _UserInfo: User information
        :type UserInfo: :class:`tencentcloud.organization.v20210331.models.UserInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._UserInfo = None
        self._RequestId = None

    @property
    def UserInfo(self):
        return self._UserInfo

    @UserInfo.setter
    def UserInfo(self, UserInfo):
        self._UserInfo = UserInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("UserInfo") is not None:
            self._UserInfo = UserInfo()
            self._UserInfo._deserialize(params.get("UserInfo"))
        self._RequestId = params.get("RequestId")


class UpdateUserStatusRequest(AbstractModel):
    """UpdateUserStatus request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _UserId: User ID.
        :type UserId: str
        :param _NewUserStatus: User status. Valid values: Enabled, Disabled.
        :type NewUserStatus: str
        """
        self._ZoneId = None
        self._UserId = None
        self._NewUserStatus = None

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def UserId(self):
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def NewUserStatus(self):
        return self._NewUserStatus

    @NewUserStatus.setter
    def NewUserStatus(self, NewUserStatus):
        self._NewUserStatus = NewUserStatus


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._UserId = params.get("UserId")
        self._NewUserStatus = params.get("NewUserStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UpdateUserStatusResponse(AbstractModel):
    """UpdateUserStatus response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class UpdateUserSyncProvisioningRequest(AbstractModel):
    """UpdateUserSyncProvisioning request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID.
        :type ZoneId: str
        :param _UserProvisioningId: User synchronization ID.
        :type UserProvisioningId: str
        :param _NewDescription: User synchronization description.
        :type NewDescription: str
        :param _NewDuplicationStateful: Conflict policy. It indicates the handling policy for existence of a user with the same username when CIC users are synchronized to CAM. Valid values: KeepBoth: Keep both, that is, add the _cic suffix to the CIC user's username and then try to create a CAM user with the username when CIC users are synchronized to CAM and a user with the same username already exists in CAM; TakeOver: Replace, that is, directly replace the existing CAM user with the synchronized CIC user when CIC users are synchronized to CAM and a user with the same username already exists in CAM.
        :type NewDuplicationStateful: str
        :param _NewDeletionStrategy: Deletion policy. It indicates the handling policy for CAM users already synchronized when the CAM user synchronization is deleted. Valid values: Delete: Delete the CAM users already synchronized from CIC to CAM when the CAM user synchronization is deleted; Keep: Keep the CAM users already synchronized from CIC to CAM when the CAM user synchronization is deleted.
        :type NewDeletionStrategy: str
        """
        self._ZoneId = None
        self._UserProvisioningId = None
        self._NewDescription = None
        self._NewDuplicationStateful = None
        self._NewDeletionStrategy = None

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def UserProvisioningId(self):
        return self._UserProvisioningId

    @UserProvisioningId.setter
    def UserProvisioningId(self, UserProvisioningId):
        self._UserProvisioningId = UserProvisioningId

    @property
    def NewDescription(self):
        return self._NewDescription

    @NewDescription.setter
    def NewDescription(self, NewDescription):
        self._NewDescription = NewDescription

    @property
    def NewDuplicationStateful(self):
        return self._NewDuplicationStateful

    @NewDuplicationStateful.setter
    def NewDuplicationStateful(self, NewDuplicationStateful):
        self._NewDuplicationStateful = NewDuplicationStateful

    @property
    def NewDeletionStrategy(self):
        return self._NewDeletionStrategy

    @NewDeletionStrategy.setter
    def NewDeletionStrategy(self, NewDeletionStrategy):
        self._NewDeletionStrategy = NewDeletionStrategy


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._UserProvisioningId = params.get("UserProvisioningId")
        self._NewDescription = params.get("NewDescription")
        self._NewDuplicationStateful = params.get("NewDuplicationStateful")
        self._NewDeletionStrategy = params.get("NewDeletionStrategy")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UpdateUserSyncProvisioningResponse(AbstractModel):
    """UpdateUserSyncProvisioning response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class UpdateZoneRequest(AbstractModel):
    """UpdateZone request structure.

    """

    def __init__(self):
        r"""
        :param _ZoneId: Space ID, which starts with the z- prefix, followed by 12 random digits/lowercase letters.
        :type ZoneId: str
        :param _NewZoneName: Space name, which must be globally unique and contain 2-64 characters including lowercase letters, digits, and hyphens (-). It can neither start or end with a hyphen (-) nor contain two consecutive hyphens (-).
        :type NewZoneName: str
        """
        self._ZoneId = None
        self._NewZoneName = None

    @property
    def ZoneId(self):
        return self._ZoneId

    @ZoneId.setter
    def ZoneId(self, ZoneId):
        self._ZoneId = ZoneId

    @property
    def NewZoneName(self):
        return self._NewZoneName

    @NewZoneName.setter
    def NewZoneName(self, NewZoneName):
        self._NewZoneName = NewZoneName


    def _deserialize(self, params):
        self._ZoneId = params.get("ZoneId")
        self._NewZoneName = params.get("NewZoneName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UpdateZoneResponse(AbstractModel):
    """UpdateZone response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class UserInfo(AbstractModel):
    """User information.

    """

    def __init__(self):
        r"""
        :param _UserName: Queried username.
        :type UserName: str
        :param _FirstName: First name of the user.
        :type FirstName: str
        :param _LastName: Last name of the user.
        :type LastName: str
        :param _DisplayName: Display name of the user.
        :type DisplayName: str
        :param _Description: User description.
        :type Description: str
        :param _Email: Email address of the user, which must be unique within the directory.
        :type Email: str
        :param _UserStatus: User status. Valid values: Enabled, Disabled.
        :type UserStatus: str
        :param _UserType: User type. Manual: manually created; Synchronized: externally imported.
        :type UserType: str
        :param _UserId: User ID.
        :type UserId: str
        :param _CreateTime: Creation time of the user.
        :type CreateTime: str
        :param _UpdateTime: Modification time of the user.
        :type UpdateTime: str
        :param _IsSelected: Whether selected
        :type IsSelected: bool
        """
        self._UserName = None
        self._FirstName = None
        self._LastName = None
        self._DisplayName = None
        self._Description = None
        self._Email = None
        self._UserStatus = None
        self._UserType = None
        self._UserId = None
        self._CreateTime = None
        self._UpdateTime = None
        self._IsSelected = None

    @property
    def UserName(self):
        return self._UserName

    @UserName.setter
    def UserName(self, UserName):
        self._UserName = UserName

    @property
    def FirstName(self):
        return self._FirstName

    @FirstName.setter
    def FirstName(self, FirstName):
        self._FirstName = FirstName

    @property
    def LastName(self):
        return self._LastName

    @LastName.setter
    def LastName(self, LastName):
        self._LastName = LastName

    @property
    def DisplayName(self):
        return self._DisplayName

    @DisplayName.setter
    def DisplayName(self, DisplayName):
        self._DisplayName = DisplayName

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Email(self):
        return self._Email

    @Email.setter
    def Email(self, Email):
        self._Email = Email

    @property
    def UserStatus(self):
        return self._UserStatus

    @UserStatus.setter
    def UserStatus(self, UserStatus):
        self._UserStatus = UserStatus

    @property
    def UserType(self):
        return self._UserType

    @UserType.setter
    def UserType(self, UserType):
        self._UserType = UserType

    @property
    def UserId(self):
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def IsSelected(self):
        return self._IsSelected

    @IsSelected.setter
    def IsSelected(self, IsSelected):
        self._IsSelected = IsSelected


    def _deserialize(self, params):
        self._UserName = params.get("UserName")
        self._FirstName = params.get("FirstName")
        self._LastName = params.get("LastName")
        self._DisplayName = params.get("DisplayName")
        self._Description = params.get("Description")
        self._Email = params.get("Email")
        self._UserStatus = params.get("UserStatus")
        self._UserType = params.get("UserType")
        self._UserId = params.get("UserId")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._IsSelected = params.get("IsSelected")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UserProvisioning(AbstractModel):
    """User synchronization information.

    """

    def __init__(self):
        r"""
        :param _UserProvisioningId: CAM user synchronization status. Valid values:

Enabled: CAM user synchronization is enabled.
Disabled: CAM user synchronization is disabled.
        :type UserProvisioningId: str
        :param _Description: Description.
        :type Description: str
        :param _Status: CAM user synchronization status. Valid values:

Enabled: CAM user synchronization is enabled.
Disabled: CAM user synchronization is disabled.
        :type Status: str
        :param _PrincipalId: Identity ID for the CAM user synchronization. Valid values:
When the PrincipalType value is Group, it is the CIC user group ID (g-********).
When the PrincipalType value is User, it is the CIC user ID (u-********).
        :type PrincipalId: str
        :param _PrincipalName: Identity name for the CAM user synchronization. Valid values:When the PrincipalType value is Group, it is the CIC user group name.
When the PrincipalType value is User, it is the CIC user name.
        :type PrincipalName: str
        :param _PrincipalType: Identity type for the CAM user synchronization. Valid values:

User: indicates that the identity for the CAM user synchronization is a CIC user.
Group: indicates that the identity for the CAM user synchronization is a CIC user group.
        :type PrincipalType: str
        :param _TargetUin: UIN of the target account of the Tencent Cloud Organization.
        :type TargetUin: int
        :param _TargetName: Name of the target account of the Tencent Cloud Organization.
        :type TargetName: str
        :param _DuplicationStrategy: Conflict policy. It indicates the handling policy for existence of a user with the same username when CIC users are synchronized to CAM. Valid values: KeepBoth: Keep both, that is, add the _cic suffix to the CIC user's username and then try to create a CAM user with the username when CIC users are synchronized to CAM and a user with the same username already exists in CAM; TakeOver: Replace, that is, directly replace the existing CAM user with the synchronized CIC user when CIC users are synchronized to CAM and a user with the same username already exists in CAM.
        :type DuplicationStrategy: str
        :param _DeletionStrategy: Deletion policy. It indicates the handling policy for CAM users already synchronized when the CAM user synchronization is deleted. Valid values: Delete: Delete the CAM users already synchronized from CIC to CAM when the CAM user synchronization is deleted; Keep: Keep the CAM users already synchronized from CIC to CAM when the CAM user synchronization is deleted.
        :type DeletionStrategy: str
        :param _CreateTime: Creation time.
        :type CreateTime: str
        :param _UpdateTime: Update time.
        :type UpdateTime: str
        :param _TargetType: Type of the synchronized target account of the Tencent Cloud Organization. ManagerUin: admin account; MemberUin: member account.
        :type TargetType: str
        """
        self._UserProvisioningId = None
        self._Description = None
        self._Status = None
        self._PrincipalId = None
        self._PrincipalName = None
        self._PrincipalType = None
        self._TargetUin = None
        self._TargetName = None
        self._DuplicationStrategy = None
        self._DeletionStrategy = None
        self._CreateTime = None
        self._UpdateTime = None
        self._TargetType = None

    @property
    def UserProvisioningId(self):
        return self._UserProvisioningId

    @UserProvisioningId.setter
    def UserProvisioningId(self, UserProvisioningId):
        self._UserProvisioningId = UserProvisioningId

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def PrincipalId(self):
        return self._PrincipalId

    @PrincipalId.setter
    def PrincipalId(self, PrincipalId):
        self._PrincipalId = PrincipalId

    @property
    def PrincipalName(self):
        return self._PrincipalName

    @PrincipalName.setter
    def PrincipalName(self, PrincipalName):
        self._PrincipalName = PrincipalName

    @property
    def PrincipalType(self):
        return self._PrincipalType

    @PrincipalType.setter
    def PrincipalType(self, PrincipalType):
        self._PrincipalType = PrincipalType

    @property
    def TargetUin(self):
        return self._TargetUin

    @TargetUin.setter
    def TargetUin(self, TargetUin):
        self._TargetUin = TargetUin

    @property
    def TargetName(self):
        return self._TargetName

    @TargetName.setter
    def TargetName(self, TargetName):
        self._TargetName = TargetName

    @property
    def DuplicationStrategy(self):
        return self._DuplicationStrategy

    @DuplicationStrategy.setter
    def DuplicationStrategy(self, DuplicationStrategy):
        self._DuplicationStrategy = DuplicationStrategy

    @property
    def DeletionStrategy(self):
        return self._DeletionStrategy

    @DeletionStrategy.setter
    def DeletionStrategy(self, DeletionStrategy):
        self._DeletionStrategy = DeletionStrategy

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def TargetType(self):
        return self._TargetType

    @TargetType.setter
    def TargetType(self, TargetType):
        self._TargetType = TargetType


    def _deserialize(self, params):
        self._UserProvisioningId = params.get("UserProvisioningId")
        self._Description = params.get("Description")
        self._Status = params.get("Status")
        self._PrincipalId = params.get("PrincipalId")
        self._PrincipalName = params.get("PrincipalName")
        self._PrincipalType = params.get("PrincipalType")
        self._TargetUin = params.get("TargetUin")
        self._TargetName = params.get("TargetName")
        self._DuplicationStrategy = params.get("DuplicationStrategy")
        self._DeletionStrategy = params.get("DeletionStrategy")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._TargetType = params.get("TargetType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UserProvisioningsTask(AbstractModel):
    """Status information of the user synchronization task.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID.
        :type TaskId: str
        :param _TargetUin: UIN of the authorized target account of the Tencent Cloud Organization.
        :type TargetUin: int
        :param _TargetType: Type of the synchronized target account of the Tencent Cloud Organization. ManagerUin: admin account; MemberUin: member account.
        :type TargetType: str
        :param _TaskType: Task type. StartProvisioning: Start the user synchronization; DeleteProvisioning: Delete the user synchronization.
        :type TaskType: str
        :param _TaskStatus: Task status. InProgress: The task is in progress; Failed: The task failed; Success: The task succeeded.
        :type TaskStatus: str
        :param _UserProvisioningId: User synchronization ID.
        :type UserProvisioningId: str
        :param _PrincipalId: Identity ID for the CAM user synchronization. Valid values: When the PrincipalType value is Group, it is the CIC user group ID (g-********). When the PrincipalType value is User, it is the CIC user ID (u-********).
        :type PrincipalId: str
        :param _PrincipalType: Identity type for the CAM user synchronization. Valid values: User: indicates that the identity for the CAM user synchronization is a CIC user; Group: indicates that the identity for the CAM user synchronization is a CIC user group.
        :type PrincipalType: str
        :param _PrincipalName: User name or user group name.
        :type PrincipalName: str
        :param _DuplicationStrategy: Conflict policy. KeepBoth: Keep both; TakeOver: Replace.
        :type DuplicationStrategy: str
        :param _DeletionStrategy: Deletion policy: Delete, Keep.
        :type DeletionStrategy: str
        """
        self._TaskId = None
        self._TargetUin = None
        self._TargetType = None
        self._TaskType = None
        self._TaskStatus = None
        self._UserProvisioningId = None
        self._PrincipalId = None
        self._PrincipalType = None
        self._PrincipalName = None
        self._DuplicationStrategy = None
        self._DeletionStrategy = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TargetUin(self):
        return self._TargetUin

    @TargetUin.setter
    def TargetUin(self, TargetUin):
        self._TargetUin = TargetUin

    @property
    def TargetType(self):
        return self._TargetType

    @TargetType.setter
    def TargetType(self, TargetType):
        self._TargetType = TargetType

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def TaskStatus(self):
        return self._TaskStatus

    @TaskStatus.setter
    def TaskStatus(self, TaskStatus):
        self._TaskStatus = TaskStatus

    @property
    def UserProvisioningId(self):
        return self._UserProvisioningId

    @UserProvisioningId.setter
    def UserProvisioningId(self, UserProvisioningId):
        self._UserProvisioningId = UserProvisioningId

    @property
    def PrincipalId(self):
        return self._PrincipalId

    @PrincipalId.setter
    def PrincipalId(self, PrincipalId):
        self._PrincipalId = PrincipalId

    @property
    def PrincipalType(self):
        return self._PrincipalType

    @PrincipalType.setter
    def PrincipalType(self, PrincipalType):
        self._PrincipalType = PrincipalType

    @property
    def PrincipalName(self):
        return self._PrincipalName

    @PrincipalName.setter
    def PrincipalName(self, PrincipalName):
        self._PrincipalName = PrincipalName

    @property
    def DuplicationStrategy(self):
        return self._DuplicationStrategy

    @DuplicationStrategy.setter
    def DuplicationStrategy(self, DuplicationStrategy):
        self._DuplicationStrategy = DuplicationStrategy

    @property
    def DeletionStrategy(self):
        return self._DeletionStrategy

    @DeletionStrategy.setter
    def DeletionStrategy(self, DeletionStrategy):
        self._DeletionStrategy = DeletionStrategy


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._TargetUin = params.get("TargetUin")
        self._TargetType = params.get("TargetType")
        self._TaskType = params.get("TaskType")
        self._TaskStatus = params.get("TaskStatus")
        self._UserProvisioningId = params.get("UserProvisioningId")
        self._PrincipalId = params.get("PrincipalId")
        self._PrincipalType = params.get("PrincipalType")
        self._PrincipalName = params.get("PrincipalName")
        self._DuplicationStrategy = params.get("DuplicationStrategy")
        self._DeletionStrategy = params.get("DeletionStrategy")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UserSyncProvisioning(AbstractModel):
    """CAM user synchronization information.

    """

    def __init__(self):
        r"""
        :param _Description: Description.
        :type Description: str
        :param _PrincipalId: Identity ID for the CAM user synchronization. Valid values:
When the PrincipalType value is Group, it is the CIC user group ID (g-********).
When the PrincipalType value is User, it is the CIC user ID (u-********).
        :type PrincipalId: str
        :param _PrincipalType: Identity type for the CAM user synchronization. Valid values:

User: indicates that the identity for the CAM user synchronization is a CIC user.
Group: indicates that the identity for the CAM user synchronization is a CIC user group.
        :type PrincipalType: str
        :param _TargetUin: UIN of the synchronized target account of the Tencent Cloud Organization.
        :type TargetUin: int
        :param _DuplicationStrategy: Conflict policy. It indicates the handling policy for existence of a user with the same username when CIC users are synchronized to CAM. Valid values: KeepBoth: Keep both, that is, add the _cic suffix to the CIC user's username and then try to create a CAM user with the username when CIC users are synchronized to CAM and a user with the same username already exists in CAM; TakeOver: Replace, that is, directly replace the existing CAM user with the synchronized CIC user when CIC users are synchronized to CAM and a user with the same username already exists in CAM.
        :type DuplicationStrategy: str
        :param _DeletionStrategy: Deletion policy. It indicates the handling policy for CAM users already synchronized when the CAM user synchronization is deleted. Valid values: Delete: Delete the CAM users already synchronized from CIC to CAM when the CAM user synchronization is deleted; Keep: Keep the CAM users already synchronized from CIC to CAM when the CAM user synchronization is deleted.
        :type DeletionStrategy: str
        :param _TargetType: Type of the synchronized target account of the Tencent Cloud Organization. ManagerUin: admin account; MemberUin: member account.
        :type TargetType: str
        """
        self._Description = None
        self._PrincipalId = None
        self._PrincipalType = None
        self._TargetUin = None
        self._DuplicationStrategy = None
        self._DeletionStrategy = None
        self._TargetType = None

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def PrincipalId(self):
        return self._PrincipalId

    @PrincipalId.setter
    def PrincipalId(self, PrincipalId):
        self._PrincipalId = PrincipalId

    @property
    def PrincipalType(self):
        return self._PrincipalType

    @PrincipalType.setter
    def PrincipalType(self, PrincipalType):
        self._PrincipalType = PrincipalType

    @property
    def TargetUin(self):
        return self._TargetUin

    @TargetUin.setter
    def TargetUin(self, TargetUin):
        self._TargetUin = TargetUin

    @property
    def DuplicationStrategy(self):
        return self._DuplicationStrategy

    @DuplicationStrategy.setter
    def DuplicationStrategy(self, DuplicationStrategy):
        self._DuplicationStrategy = DuplicationStrategy

    @property
    def DeletionStrategy(self):
        return self._DeletionStrategy

    @DeletionStrategy.setter
    def DeletionStrategy(self, DeletionStrategy):
        self._DeletionStrategy = DeletionStrategy

    @property
    def TargetType(self):
        return self._TargetType

    @TargetType.setter
    def TargetType(self, TargetType):
        self._TargetType = TargetType


    def _deserialize(self, params):
        self._Description = params.get("Description")
        self._PrincipalId = params.get("PrincipalId")
        self._PrincipalType = params.get("PrincipalType")
        self._TargetUin = params.get("TargetUin")
        self._DuplicationStrategy = params.get("DuplicationStrategy")
        self._DeletionStrategy = params.get("DeletionStrategy")
        self._TargetType = params.get("TargetType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ZoneStatistics(AbstractModel):
    """CIC space statistics.

    """

    def __init__(self):
        r"""
        :param _UserQuota: User quota.
        :type UserQuota: int
        :param _GroupQuota: User group quota.
        :type GroupQuota: int
        :param _RoleConfigurationQuota: Permission configuration quota.
        :type RoleConfigurationQuota: int
        :param _SystemPolicyPerRoleConfigurationQuota: System policy quota bound to the permission configuration.
        :type SystemPolicyPerRoleConfigurationQuota: int
        :param _UserCount: Number of users.
        :type UserCount: int
        :param _GroupCount: Number of user groups.
        :type GroupCount: int
        :param _RoleConfigurationCount: Number of permission configurations.
        :type RoleConfigurationCount: int
        :param _UserProvisioningCount: Number of synchronized users.
        :type UserProvisioningCount: int
        :param _RoleConfigurationSyncCount: Number of synchronized roles.
        :type RoleConfigurationSyncCount: int
        """
        self._UserQuota = None
        self._GroupQuota = None
        self._RoleConfigurationQuota = None
        self._SystemPolicyPerRoleConfigurationQuota = None
        self._UserCount = None
        self._GroupCount = None
        self._RoleConfigurationCount = None
        self._UserProvisioningCount = None
        self._RoleConfigurationSyncCount = None

    @property
    def UserQuota(self):
        return self._UserQuota

    @UserQuota.setter
    def UserQuota(self, UserQuota):
        self._UserQuota = UserQuota

    @property
    def GroupQuota(self):
        return self._GroupQuota

    @GroupQuota.setter
    def GroupQuota(self, GroupQuota):
        self._GroupQuota = GroupQuota

    @property
    def RoleConfigurationQuota(self):
        return self._RoleConfigurationQuota

    @RoleConfigurationQuota.setter
    def RoleConfigurationQuota(self, RoleConfigurationQuota):
        self._RoleConfigurationQuota = RoleConfigurationQuota

    @property
    def SystemPolicyPerRoleConfigurationQuota(self):
        return self._SystemPolicyPerRoleConfigurationQuota

    @SystemPolicyPerRoleConfigurationQuota.setter
    def SystemPolicyPerRoleConfigurationQuota(self, SystemPolicyPerRoleConfigurationQuota):
        self._SystemPolicyPerRoleConfigurationQuota = SystemPolicyPerRoleConfigurationQuota

    @property
    def UserCount(self):
        return self._UserCount

    @UserCount.setter
    def UserCount(self, UserCount):
        self._UserCount = UserCount

    @property
    def GroupCount(self):
        return self._GroupCount

    @GroupCount.setter
    def GroupCount(self, GroupCount):
        self._GroupCount = GroupCount

    @property
    def RoleConfigurationCount(self):
        return self._RoleConfigurationCount

    @RoleConfigurationCount.setter
    def RoleConfigurationCount(self, RoleConfigurationCount):
        self._RoleConfigurationCount = RoleConfigurationCount

    @property
    def UserProvisioningCount(self):
        return self._UserProvisioningCount

    @UserProvisioningCount.setter
    def UserProvisioningCount(self, UserProvisioningCount):
        self._UserProvisioningCount = UserProvisioningCount

    @property
    def RoleConfigurationSyncCount(self):
        return self._RoleConfigurationSyncCount

    @RoleConfigurationSyncCount.setter
    def RoleConfigurationSyncCount(self, RoleConfigurationSyncCount):
        self._RoleConfigurationSyncCount = RoleConfigurationSyncCount


    def _deserialize(self, params):
        self._UserQuota = params.get("UserQuota")
        self._GroupQuota = params.get("GroupQuota")
        self._RoleConfigurationQuota = params.get("RoleConfigurationQuota")
        self._SystemPolicyPerRoleConfigurationQuota = params.get("SystemPolicyPerRoleConfigurationQuota")
        self._UserCount = params.get("UserCount")
        self._GroupCount = params.get("GroupCount")
        self._RoleConfigurationCount = params.get("RoleConfigurationCount")
        self._UserProvisioningCount = params.get("UserProvisioningCount")
        self._RoleConfigurationSyncCount = params.get("RoleConfigurationSyncCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        