# -*- coding: utf8 -*-
# Copyright (c) 2017-2021 THL A29 Limited, a Tencent company. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class AddTeamMemberRequest(AbstractModel):
    """AddTeamMember request structure.

    """

    def __init__(self):
        r"""
        :param _TeamId: Team ID
        :type TeamId: str
        :param _MemberList: Members to be added
        :type MemberList: list of CreateTeamMemberInfoReq
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._TeamId = None
        self._MemberList = None
        self._PlatformId = None

    @property
    def TeamId(self):
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId

    @property
    def MemberList(self):
        return self._MemberList

    @MemberList.setter
    def MemberList(self, MemberList):
        self._MemberList = MemberList

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._TeamId = params.get("TeamId")
        if params.get("MemberList") is not None:
            self._MemberList = []
            for item in params.get("MemberList"):
                obj = CreateTeamMemberInfoReq()
                obj._deserialize(item)
                self._MemberList.append(obj)
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddTeamMemberResponse(AbstractModel):
    """AddTeamMember response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class ApplicationDetail(AbstractModel):
    """Application details

    """

    def __init__(self):
        r"""
        :param _ApplicationID: Application ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationID: str
        :param _AppIdentityID: Product ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type AppIdentityID: int
        :param _ApplicationName: The application name.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationName: str
        :param _ApplicationEnglishName: English name of the application (this field is not used yet)
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationEnglishName: str
        :param _Logo: Application icon
Note: This field may return null, indicating that no valid values can be obtained.
        :type Logo: str
        :param _Remark: Remarks
Note: This field may return null, indicating that no valid values can be obtained.
        :type Remark: str
        :param _AndroidAppKey: Android package name
Note: This field may return null, indicating that no valid values can be obtained.
        :type AndroidAppKey: str
        :param _IosAppKey: iOS bundleId
Note: This field may return null, indicating that no valid values can be obtained.
        :type IosAppKey: str
        :param _CreateUser: Creator
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateUser: str
        :param _CreateTime: The creation time.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        :param _UpdateUser: Updated by
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateUser: str
        :param _UpdateTime: Update date
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateTime: str
        :param _BindMNPCount: Number of bound mini programs
Note: This field may return null, indicating that no valid values can be obtained.
        :type BindMNPCount: int
        :param _BindMNPList: Information of bound mini programs
Note: This field may return null, indicating that no valid values can be obtained.
        :type BindMNPList: list of ApplicationMNPRelInfoResp
        :param _Intro: Application description
Note: This field may return null, indicating that no valid values can be obtained.
        :type Intro: str
        :param _AndroidAppUrl: Android App download address
Note: This field may return null, indicating that no valid values can be obtained.
        :type AndroidAppUrl: str
        :param _IosAppUrl: iOS App download address
Note: This field may return null, indicating that no valid values can be obtained.
        :type IosAppUrl: str
        :param _TeamId: Team ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamId: str
        :param _TeamName: Team name
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamName: str
        :param _SensitiveApiCount: Quantity of sensitive APIs
Note: This field may return null, indicating that no valid values can be obtained.
        :type SensitiveApiCount: int
        :param _ApplicationType: Application type. 1: Test; 2: Formal
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationType: int
        """
        self._ApplicationID = None
        self._AppIdentityID = None
        self._ApplicationName = None
        self._ApplicationEnglishName = None
        self._Logo = None
        self._Remark = None
        self._AndroidAppKey = None
        self._IosAppKey = None
        self._CreateUser = None
        self._CreateTime = None
        self._UpdateUser = None
        self._UpdateTime = None
        self._BindMNPCount = None
        self._BindMNPList = None
        self._Intro = None
        self._AndroidAppUrl = None
        self._IosAppUrl = None
        self._TeamId = None
        self._TeamName = None
        self._SensitiveApiCount = None
        self._ApplicationType = None

    @property
    def ApplicationID(self):
        return self._ApplicationID

    @ApplicationID.setter
    def ApplicationID(self, ApplicationID):
        self._ApplicationID = ApplicationID

    @property
    def AppIdentityID(self):
        return self._AppIdentityID

    @AppIdentityID.setter
    def AppIdentityID(self, AppIdentityID):
        self._AppIdentityID = AppIdentityID

    @property
    def ApplicationName(self):
        return self._ApplicationName

    @ApplicationName.setter
    def ApplicationName(self, ApplicationName):
        self._ApplicationName = ApplicationName

    @property
    def ApplicationEnglishName(self):
        return self._ApplicationEnglishName

    @ApplicationEnglishName.setter
    def ApplicationEnglishName(self, ApplicationEnglishName):
        self._ApplicationEnglishName = ApplicationEnglishName

    @property
    def Logo(self):
        return self._Logo

    @Logo.setter
    def Logo(self, Logo):
        self._Logo = Logo

    @property
    def Remark(self):
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def AndroidAppKey(self):
        return self._AndroidAppKey

    @AndroidAppKey.setter
    def AndroidAppKey(self, AndroidAppKey):
        self._AndroidAppKey = AndroidAppKey

    @property
    def IosAppKey(self):
        return self._IosAppKey

    @IosAppKey.setter
    def IosAppKey(self, IosAppKey):
        self._IosAppKey = IosAppKey

    @property
    def CreateUser(self):
        return self._CreateUser

    @CreateUser.setter
    def CreateUser(self, CreateUser):
        self._CreateUser = CreateUser

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateUser(self):
        return self._UpdateUser

    @UpdateUser.setter
    def UpdateUser(self, UpdateUser):
        self._UpdateUser = UpdateUser

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def BindMNPCount(self):
        return self._BindMNPCount

    @BindMNPCount.setter
    def BindMNPCount(self, BindMNPCount):
        self._BindMNPCount = BindMNPCount

    @property
    def BindMNPList(self):
        return self._BindMNPList

    @BindMNPList.setter
    def BindMNPList(self, BindMNPList):
        self._BindMNPList = BindMNPList

    @property
    def Intro(self):
        return self._Intro

    @Intro.setter
    def Intro(self, Intro):
        self._Intro = Intro

    @property
    def AndroidAppUrl(self):
        return self._AndroidAppUrl

    @AndroidAppUrl.setter
    def AndroidAppUrl(self, AndroidAppUrl):
        self._AndroidAppUrl = AndroidAppUrl

    @property
    def IosAppUrl(self):
        return self._IosAppUrl

    @IosAppUrl.setter
    def IosAppUrl(self, IosAppUrl):
        self._IosAppUrl = IosAppUrl

    @property
    def TeamId(self):
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId

    @property
    def TeamName(self):
        return self._TeamName

    @TeamName.setter
    def TeamName(self, TeamName):
        self._TeamName = TeamName

    @property
    def SensitiveApiCount(self):
        return self._SensitiveApiCount

    @SensitiveApiCount.setter
    def SensitiveApiCount(self, SensitiveApiCount):
        self._SensitiveApiCount = SensitiveApiCount

    @property
    def ApplicationType(self):
        return self._ApplicationType

    @ApplicationType.setter
    def ApplicationType(self, ApplicationType):
        self._ApplicationType = ApplicationType


    def _deserialize(self, params):
        self._ApplicationID = params.get("ApplicationID")
        self._AppIdentityID = params.get("AppIdentityID")
        self._ApplicationName = params.get("ApplicationName")
        self._ApplicationEnglishName = params.get("ApplicationEnglishName")
        self._Logo = params.get("Logo")
        self._Remark = params.get("Remark")
        self._AndroidAppKey = params.get("AndroidAppKey")
        self._IosAppKey = params.get("IosAppKey")
        self._CreateUser = params.get("CreateUser")
        self._CreateTime = params.get("CreateTime")
        self._UpdateUser = params.get("UpdateUser")
        self._UpdateTime = params.get("UpdateTime")
        self._BindMNPCount = params.get("BindMNPCount")
        if params.get("BindMNPList") is not None:
            self._BindMNPList = []
            for item in params.get("BindMNPList"):
                obj = ApplicationMNPRelInfoResp()
                obj._deserialize(item)
                self._BindMNPList.append(obj)
        self._Intro = params.get("Intro")
        self._AndroidAppUrl = params.get("AndroidAppUrl")
        self._IosAppUrl = params.get("IosAppUrl")
        self._TeamId = params.get("TeamId")
        self._TeamName = params.get("TeamName")
        self._SensitiveApiCount = params.get("SensitiveApiCount")
        self._ApplicationType = params.get("ApplicationType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApplicationInfo(AbstractModel):
    """Application information

    """

    def __init__(self):
        r"""
        :param _CustomerID: Platform ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type CustomerID: str
        :param _ApplicationID: Application ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationID: str
        :param _AppIdentityID: Product ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type AppIdentityID: int
        :param _ApplicationName: Name
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationName: str
        :param _ApplicationEnglishName: English name
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationEnglishName: str
        :param _Logo: Icon
        :type Logo: str
        :param _Remark: Remarks
        :type Remark: str
        :param _AndroidAppKey: Android package name
Note: This field may return null, indicating that no valid values can be obtained.
        :type AndroidAppKey: str
        :param _IosAppKey: iOS bundleId
Note: This field may return null, indicating that no valid values can be obtained.
        :type IosAppKey: str
        :param _CreateUser: Creator
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateUser: str
        :param _CreateTime: Creation time
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        :param _UpdateUser: Updater
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateUser: str
        :param _UpdateTime: Update date
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateTime: str
        :param _Intro: Introduction
        :type Intro: str
        :param _IosAppUrl: iOS app download address
        :type IosAppUrl: str
        :param _AndroidAppUrl: Android app download address
        :type AndroidAppUrl: str
        :param _TeamId: Team ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamId: str
        :param _TeamName: Team name
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamName: str
        :param _SensitiveApiCount: Number of privacy APIs
Note: This field may return null, indicating that no valid values can be obtained.
        :type SensitiveApiCount: int
        :param _ApplicationType: Application type 1-Test 2-Formal
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationType: int
        """
        self._CustomerID = None
        self._ApplicationID = None
        self._AppIdentityID = None
        self._ApplicationName = None
        self._ApplicationEnglishName = None
        self._Logo = None
        self._Remark = None
        self._AndroidAppKey = None
        self._IosAppKey = None
        self._CreateUser = None
        self._CreateTime = None
        self._UpdateUser = None
        self._UpdateTime = None
        self._Intro = None
        self._IosAppUrl = None
        self._AndroidAppUrl = None
        self._TeamId = None
        self._TeamName = None
        self._SensitiveApiCount = None
        self._ApplicationType = None

    @property
    def CustomerID(self):
        return self._CustomerID

    @CustomerID.setter
    def CustomerID(self, CustomerID):
        self._CustomerID = CustomerID

    @property
    def ApplicationID(self):
        return self._ApplicationID

    @ApplicationID.setter
    def ApplicationID(self, ApplicationID):
        self._ApplicationID = ApplicationID

    @property
    def AppIdentityID(self):
        return self._AppIdentityID

    @AppIdentityID.setter
    def AppIdentityID(self, AppIdentityID):
        self._AppIdentityID = AppIdentityID

    @property
    def ApplicationName(self):
        return self._ApplicationName

    @ApplicationName.setter
    def ApplicationName(self, ApplicationName):
        self._ApplicationName = ApplicationName

    @property
    def ApplicationEnglishName(self):
        return self._ApplicationEnglishName

    @ApplicationEnglishName.setter
    def ApplicationEnglishName(self, ApplicationEnglishName):
        self._ApplicationEnglishName = ApplicationEnglishName

    @property
    def Logo(self):
        return self._Logo

    @Logo.setter
    def Logo(self, Logo):
        self._Logo = Logo

    @property
    def Remark(self):
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def AndroidAppKey(self):
        return self._AndroidAppKey

    @AndroidAppKey.setter
    def AndroidAppKey(self, AndroidAppKey):
        self._AndroidAppKey = AndroidAppKey

    @property
    def IosAppKey(self):
        return self._IosAppKey

    @IosAppKey.setter
    def IosAppKey(self, IosAppKey):
        self._IosAppKey = IosAppKey

    @property
    def CreateUser(self):
        return self._CreateUser

    @CreateUser.setter
    def CreateUser(self, CreateUser):
        self._CreateUser = CreateUser

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateUser(self):
        return self._UpdateUser

    @UpdateUser.setter
    def UpdateUser(self, UpdateUser):
        self._UpdateUser = UpdateUser

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def Intro(self):
        return self._Intro

    @Intro.setter
    def Intro(self, Intro):
        self._Intro = Intro

    @property
    def IosAppUrl(self):
        return self._IosAppUrl

    @IosAppUrl.setter
    def IosAppUrl(self, IosAppUrl):
        self._IosAppUrl = IosAppUrl

    @property
    def AndroidAppUrl(self):
        return self._AndroidAppUrl

    @AndroidAppUrl.setter
    def AndroidAppUrl(self, AndroidAppUrl):
        self._AndroidAppUrl = AndroidAppUrl

    @property
    def TeamId(self):
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId

    @property
    def TeamName(self):
        return self._TeamName

    @TeamName.setter
    def TeamName(self, TeamName):
        self._TeamName = TeamName

    @property
    def SensitiveApiCount(self):
        return self._SensitiveApiCount

    @SensitiveApiCount.setter
    def SensitiveApiCount(self, SensitiveApiCount):
        self._SensitiveApiCount = SensitiveApiCount

    @property
    def ApplicationType(self):
        return self._ApplicationType

    @ApplicationType.setter
    def ApplicationType(self, ApplicationType):
        self._ApplicationType = ApplicationType


    def _deserialize(self, params):
        self._CustomerID = params.get("CustomerID")
        self._ApplicationID = params.get("ApplicationID")
        self._AppIdentityID = params.get("AppIdentityID")
        self._ApplicationName = params.get("ApplicationName")
        self._ApplicationEnglishName = params.get("ApplicationEnglishName")
        self._Logo = params.get("Logo")
        self._Remark = params.get("Remark")
        self._AndroidAppKey = params.get("AndroidAppKey")
        self._IosAppKey = params.get("IosAppKey")
        self._CreateUser = params.get("CreateUser")
        self._CreateTime = params.get("CreateTime")
        self._UpdateUser = params.get("UpdateUser")
        self._UpdateTime = params.get("UpdateTime")
        self._Intro = params.get("Intro")
        self._IosAppUrl = params.get("IosAppUrl")
        self._AndroidAppUrl = params.get("AndroidAppUrl")
        self._TeamId = params.get("TeamId")
        self._TeamName = params.get("TeamName")
        self._SensitiveApiCount = params.get("SensitiveApiCount")
        self._ApplicationType = params.get("ApplicationType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApplicationMNPRelInfoResp(AbstractModel):
    """Information of bound applications

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPId: str
        :param _MNPName: Mini program name
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPName: str
        :param _MNPIcon: Mini program icon
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPIcon: str
        :param _MNPType: Mini program type
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPType: str
        :param _MNPIntro: Introduction
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPIntro: str
        :param _MNPDesc: Description
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPDesc: str
        :param _EffectStatus: Effectiveness. 1: Not effective 2: Effective
Note: This field may return null, indicating that no valid values can be obtained.
        :type EffectStatus: int
        :param _EffectMNPVersion: Effective version
Note: This field may return null, indicating that no valid values can be obtained.
        :type EffectMNPVersion: str
        :param _MNPOnlineVersion: Online version
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPOnlineVersion: str
        :param _OnlineStatus: 0: Not released; 1: Released
Note: This field may return null, indicating that no valid values can be obtained.
        :type OnlineStatus: int
        """
        self._MNPId = None
        self._MNPName = None
        self._MNPIcon = None
        self._MNPType = None
        self._MNPIntro = None
        self._MNPDesc = None
        self._EffectStatus = None
        self._EffectMNPVersion = None
        self._MNPOnlineVersion = None
        self._OnlineStatus = None

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def MNPName(self):
        return self._MNPName

    @MNPName.setter
    def MNPName(self, MNPName):
        self._MNPName = MNPName

    @property
    def MNPIcon(self):
        return self._MNPIcon

    @MNPIcon.setter
    def MNPIcon(self, MNPIcon):
        self._MNPIcon = MNPIcon

    @property
    def MNPType(self):
        return self._MNPType

    @MNPType.setter
    def MNPType(self, MNPType):
        self._MNPType = MNPType

    @property
    def MNPIntro(self):
        return self._MNPIntro

    @MNPIntro.setter
    def MNPIntro(self, MNPIntro):
        self._MNPIntro = MNPIntro

    @property
    def MNPDesc(self):
        return self._MNPDesc

    @MNPDesc.setter
    def MNPDesc(self, MNPDesc):
        self._MNPDesc = MNPDesc

    @property
    def EffectStatus(self):
        return self._EffectStatus

    @EffectStatus.setter
    def EffectStatus(self, EffectStatus):
        self._EffectStatus = EffectStatus

    @property
    def EffectMNPVersion(self):
        return self._EffectMNPVersion

    @EffectMNPVersion.setter
    def EffectMNPVersion(self, EffectMNPVersion):
        self._EffectMNPVersion = EffectMNPVersion

    @property
    def MNPOnlineVersion(self):
        return self._MNPOnlineVersion

    @MNPOnlineVersion.setter
    def MNPOnlineVersion(self, MNPOnlineVersion):
        self._MNPOnlineVersion = MNPOnlineVersion

    @property
    def OnlineStatus(self):
        return self._OnlineStatus

    @OnlineStatus.setter
    def OnlineStatus(self, OnlineStatus):
        self._OnlineStatus = OnlineStatus


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._MNPName = params.get("MNPName")
        self._MNPIcon = params.get("MNPIcon")
        self._MNPType = params.get("MNPType")
        self._MNPIntro = params.get("MNPIntro")
        self._MNPDesc = params.get("MNPDesc")
        self._EffectStatus = params.get("EffectStatus")
        self._EffectMNPVersion = params.get("EffectMNPVersion")
        self._MNPOnlineVersion = params.get("MNPOnlineVersion")
        self._OnlineStatus = params.get("OnlineStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApplicationPageInfo(AbstractModel):
    """List of applications

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of results.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _DataList: List information
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataList: list of ApplicationInfo
        """
        self._TotalCount = None
        self._DataList = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DataList(self):
        return self._DataList

    @DataList.setter
    def DataList(self, DataList):
        self._DataList = DataList


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DataList") is not None:
            self._DataList = []
            for item in params.get("DataList"):
                obj = ApplicationInfo()
                obj._deserialize(item)
                self._DataList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApplicationSimpleInfo(AbstractModel):
    """Application information

    """

    def __init__(self):
        r"""
        :param _ApplicationId: Application ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationId: str
        :param _ApplicationName: Application name
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationName: str
        """
        self._ApplicationId = None
        self._ApplicationName = None

    @property
    def ApplicationId(self):
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def ApplicationName(self):
        return self._ApplicationName

    @ApplicationName.setter
    def ApplicationName(self, ApplicationName):
        self._ApplicationName = ApplicationName


    def _deserialize(self, params):
        self._ApplicationId = params.get("ApplicationId")
        self._ApplicationName = params.get("ApplicationName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApplicationSimpleInfoResp(AbstractModel):
    """Simple information of the application

    """

    def __init__(self):
        r"""
        :param _ApplicationID: Application ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationID: str
        :param _AppIdentityID: Product ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type AppIdentityID: int
        :param _ApplicationName: The application name.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationName: str
        """
        self._ApplicationID = None
        self._AppIdentityID = None
        self._ApplicationName = None

    @property
    def ApplicationID(self):
        return self._ApplicationID

    @ApplicationID.setter
    def ApplicationID(self, ApplicationID):
        self._ApplicationID = ApplicationID

    @property
    def AppIdentityID(self):
        return self._AppIdentityID

    @AppIdentityID.setter
    def AppIdentityID(self, AppIdentityID):
        self._AppIdentityID = AppIdentityID

    @property
    def ApplicationName(self):
        return self._ApplicationName

    @ApplicationName.setter
    def ApplicationName(self, ApplicationName):
        self._ApplicationName = ApplicationName


    def _deserialize(self, params):
        self._ApplicationID = params.get("ApplicationID")
        self._AppIdentityID = params.get("AppIdentityID")
        self._ApplicationName = params.get("ApplicationName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApplicationSimpleListInfoResp(AbstractModel):
    """Simple list of applications

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of results.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _DataList: List information
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataList: list of ApplicationSimpleInfoResp
        """
        self._TotalCount = None
        self._DataList = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DataList(self):
        return self._DataList

    @DataList.setter
    def DataList(self, DataList):
        self._DataList = DataList


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DataList") is not None:
            self._DataList = []
            for item in params.get("DataList"):
                obj = ApplicationSimpleInfoResp()
                obj._deserialize(item)
                self._DataList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApprovalItem(AbstractModel):
    """Result of the mini program approval requests

    """

    def __init__(self):
        r"""
        :param _AppId: Application ID
        :type AppId: str
        :param _ApprovalResult: Approval result. 2: Rejected;
3: Approved
        :type ApprovalResult: int
        :param _ApprovalNote: Approval notes. It’s required when the request is rejected. 
        :type ApprovalNote: str
        """
        self._AppId = None
        self._ApprovalResult = None
        self._ApprovalNote = None

    @property
    def AppId(self):
        return self._AppId

    @AppId.setter
    def AppId(self, AppId):
        self._AppId = AppId

    @property
    def ApprovalResult(self):
        return self._ApprovalResult

    @ApprovalResult.setter
    def ApprovalResult(self, ApprovalResult):
        self._ApprovalResult = ApprovalResult

    @property
    def ApprovalNote(self):
        return self._ApprovalNote

    @ApprovalNote.setter
    def ApprovalNote(self, ApprovalNote):
        self._ApprovalNote = ApprovalNote


    def _deserialize(self, params):
        self._AppId = params.get("AppId")
        self._ApprovalResult = params.get("ApprovalResult")
        self._ApprovalNote = params.get("ApprovalNote")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AuditInfoReq(AbstractModel):
    """Approval information

    """

    def __init__(self):
        r"""
        :param _ApplicationId: Application ID
        :type ApplicationId: str
        :param _AuditStatus: Approval status 2- Rejected
3 - Approved
        :type AuditStatus: int
        :param _AuditNote: Approval description

        :type AuditNote: str
        """
        self._ApplicationId = None
        self._AuditStatus = None
        self._AuditNote = None

    @property
    def ApplicationId(self):
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def AuditStatus(self):
        return self._AuditStatus

    @AuditStatus.setter
    def AuditStatus(self, AuditStatus):
        self._AuditStatus = AuditStatus

    @property
    def AuditNote(self):
        return self._AuditNote

    @AuditNote.setter
    def AuditNote(self, AuditNote):
        self._AuditNote = AuditNote


    def _deserialize(self, params):
        self._ApplicationId = params.get("ApplicationId")
        self._AuditStatus = params.get("AuditStatus")
        self._AuditNote = params.get("AuditNote")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BooleanInfo(AbstractModel):
    """Used for Data object when no data is returned after the a successful action.

    """

    def __init__(self):
        r"""
        :param _Result: Bool type response object
Note: This field may return null, indicating that no valid values can be obtained.
        :type Result: bool
        """
        self._Result = None

    @property
    def Result(self):
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result


    def _deserialize(self, params):
        self._Result = params.get("Result")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckGlobalDomainRequest(AbstractModel):
    """CheckGlobalDomain request structure.

    """

    def __init__(self):
        r"""
        :param _DomainUrlList: Domain name list
        :type DomainUrlList: list of str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._DomainUrlList = None
        self._PlatformId = None

    @property
    def DomainUrlList(self):
        return self._DomainUrlList

    @DomainUrlList.setter
    def DomainUrlList(self, DomainUrlList):
        self._DomainUrlList = DomainUrlList

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._DomainUrlList = params.get("DomainUrlList")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckGlobalDomainResponse(AbstractModel):
    """CheckGlobalDomain response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.GlobalDomainCheckResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = GlobalDomainCheckResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class ConfigureMNPPreviewRequest(AbstractModel):
    """ConfigureMNPPreview request structure.

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _ActionType: 1: Set; 2: Cancel
        :type ActionType: int
        :param _MNPVersionId: Mini program version ID
        :type MNPVersionId: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _PreivewEntrancePath: Path to the preview page
        :type PreivewEntrancePath: str
        """
        self._MNPId = None
        self._ActionType = None
        self._MNPVersionId = None
        self._PlatformId = None
        self._PreivewEntrancePath = None

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def ActionType(self):
        return self._ActionType

    @ActionType.setter
    def ActionType(self, ActionType):
        self._ActionType = ActionType

    @property
    def MNPVersionId(self):
        return self._MNPVersionId

    @MNPVersionId.setter
    def MNPVersionId(self, MNPVersionId):
        self._MNPVersionId = MNPVersionId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def PreivewEntrancePath(self):
        return self._PreivewEntrancePath

    @PreivewEntrancePath.setter
    def PreivewEntrancePath(self, PreivewEntrancePath):
        self._PreivewEntrancePath = PreivewEntrancePath


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._ActionType = params.get("ActionType")
        self._MNPVersionId = params.get("MNPVersionId")
        self._PlatformId = params.get("PlatformId")
        self._PreivewEntrancePath = params.get("PreivewEntrancePath")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ConfigureMNPPreviewResponse(AbstractModel):
    """ConfigureMNPPreview response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CreateApplicationRequest(AbstractModel):
    """CreateApplication request structure.

    """

    def __init__(self):
        r"""
        :param _ApplicationName: Application name
        :type ApplicationName: str
        :param _Logo: Logo address
        :type Logo: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _TeamId: Team ID
        :type TeamId: str
        :param _ApplicationType: Application type. 1: Test; 2: Formal
        :type ApplicationType: int
        :param _Intro: Introduction
        :type Intro: str
        :param _AndroidAppKey: Android app package name
        :type AndroidAppKey: str
        :param _IosAppKey: iOS App bundleId
        :type IosAppKey: str
        :param _Remark: Remarks
        :type Remark: str
        """
        self._ApplicationName = None
        self._Logo = None
        self._PlatformId = None
        self._TeamId = None
        self._ApplicationType = None
        self._Intro = None
        self._AndroidAppKey = None
        self._IosAppKey = None
        self._Remark = None

    @property
    def ApplicationName(self):
        return self._ApplicationName

    @ApplicationName.setter
    def ApplicationName(self, ApplicationName):
        self._ApplicationName = ApplicationName

    @property
    def Logo(self):
        return self._Logo

    @Logo.setter
    def Logo(self, Logo):
        self._Logo = Logo

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def TeamId(self):
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId

    @property
    def ApplicationType(self):
        return self._ApplicationType

    @ApplicationType.setter
    def ApplicationType(self, ApplicationType):
        self._ApplicationType = ApplicationType

    @property
    def Intro(self):
        return self._Intro

    @Intro.setter
    def Intro(self, Intro):
        self._Intro = Intro

    @property
    def AndroidAppKey(self):
        return self._AndroidAppKey

    @AndroidAppKey.setter
    def AndroidAppKey(self, AndroidAppKey):
        self._AndroidAppKey = AndroidAppKey

    @property
    def IosAppKey(self):
        return self._IosAppKey

    @IosAppKey.setter
    def IosAppKey(self, IosAppKey):
        self._IosAppKey = IosAppKey

    @property
    def Remark(self):
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark


    def _deserialize(self, params):
        self._ApplicationName = params.get("ApplicationName")
        self._Logo = params.get("Logo")
        self._PlatformId = params.get("PlatformId")
        self._TeamId = params.get("TeamId")
        self._ApplicationType = params.get("ApplicationType")
        self._Intro = params.get("Intro")
        self._AndroidAppKey = params.get("AndroidAppKey")
        self._IosAppKey = params.get("IosAppKey")
        self._Remark = params.get("Remark")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateApplicationResponse(AbstractModel):
    """CreateApplication response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.ResourceIdStringInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = ResourceIdStringInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CreateApplicationSensitiveAPIReq(AbstractModel):
    """Parameters of the request to add a sensitive API

    """

    def __init__(self):
        r"""
        :param _APIName: API name
Note: This field may return null, indicating that no valid values can be obtained.
        :type APIName: str
        :param _APIDesc: API description
Note: This field may return null, indicating that no valid values can be obtained.
        :type APIDesc: str
        :param _APIType: API type. 1: System; 2: Custom
Note: This field may return null, indicating that no valid values can be obtained.
        :type APIType: int
        """
        self._APIName = None
        self._APIDesc = None
        self._APIType = None

    @property
    def APIName(self):
        return self._APIName

    @APIName.setter
    def APIName(self, APIName):
        self._APIName = APIName

    @property
    def APIDesc(self):
        return self._APIDesc

    @APIDesc.setter
    def APIDesc(self, APIDesc):
        self._APIDesc = APIDesc

    @property
    def APIType(self):
        return self._APIType

    @APIType.setter
    def APIType(self, APIType):
        self._APIType = APIType


    def _deserialize(self, params):
        self._APIName = params.get("APIName")
        self._APIDesc = params.get("APIDesc")
        self._APIType = params.get("APIType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateApplicationSensitiveAPIRequest(AbstractModel):
    """CreateApplicationSensitiveAPI request structure.

    """

    def __init__(self):
        r"""
        :param _ApplicationId: Application ID
        :type ApplicationId: str
        :param _APIList: List of newly-added APIs
        :type APIList: list of CreateApplicationSensitiveAPIReq
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._ApplicationId = None
        self._APIList = None
        self._PlatformId = None

    @property
    def ApplicationId(self):
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def APIList(self):
        return self._APIList

    @APIList.setter
    def APIList(self, APIList):
        self._APIList = APIList

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._ApplicationId = params.get("ApplicationId")
        if params.get("APIList") is not None:
            self._APIList = []
            for item in params.get("APIList"):
                obj = CreateApplicationSensitiveAPIReq()
                obj._deserialize(item)
                self._APIList.append(obj)
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateApplicationSensitiveAPIResponse(AbstractModel):
    """CreateApplicationSensitiveAPI response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CreateConsoleMNPVersionCompileTaskRequest(AbstractModel):
    """CreateConsoleMNPVersionCompileTask request structure.

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _MNPVersion: Version
        :type MNPVersion: str
        :param _FileUrl: External URL of the document
        :type FileUrl: str
        :param _FileInnerUrl: Internal URL of the document
        :type FileInnerUrl: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _TaskType: Type 2 Version
        :type TaskType: int
        :param _MNPVersionIntro: Version introduction
        :type MNPVersionIntro: str
        :param _MNPVersionDesc: Version description
        :type MNPVersionDesc: str
        :param _SourceType: Type 1 Unencrypted 2 Encrypted 3 Source
        :type SourceType: int
        :param _ReleaseChannel: Upload platform 1- TCMPP 2 WeChat 3. TCMPP + WeChat
        :type ReleaseChannel: int
        """
        self._MNPId = None
        self._MNPVersion = None
        self._FileUrl = None
        self._FileInnerUrl = None
        self._PlatformId = None
        self._TaskType = None
        self._MNPVersionIntro = None
        self._MNPVersionDesc = None
        self._SourceType = None
        self._ReleaseChannel = None

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def MNPVersion(self):
        return self._MNPVersion

    @MNPVersion.setter
    def MNPVersion(self, MNPVersion):
        self._MNPVersion = MNPVersion

    @property
    def FileUrl(self):
        return self._FileUrl

    @FileUrl.setter
    def FileUrl(self, FileUrl):
        self._FileUrl = FileUrl

    @property
    def FileInnerUrl(self):
        return self._FileInnerUrl

    @FileInnerUrl.setter
    def FileInnerUrl(self, FileInnerUrl):
        self._FileInnerUrl = FileInnerUrl

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def MNPVersionIntro(self):
        return self._MNPVersionIntro

    @MNPVersionIntro.setter
    def MNPVersionIntro(self, MNPVersionIntro):
        self._MNPVersionIntro = MNPVersionIntro

    @property
    def MNPVersionDesc(self):
        return self._MNPVersionDesc

    @MNPVersionDesc.setter
    def MNPVersionDesc(self, MNPVersionDesc):
        self._MNPVersionDesc = MNPVersionDesc

    @property
    def SourceType(self):
        return self._SourceType

    @SourceType.setter
    def SourceType(self, SourceType):
        self._SourceType = SourceType

    @property
    def ReleaseChannel(self):
        return self._ReleaseChannel

    @ReleaseChannel.setter
    def ReleaseChannel(self, ReleaseChannel):
        self._ReleaseChannel = ReleaseChannel


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._MNPVersion = params.get("MNPVersion")
        self._FileUrl = params.get("FileUrl")
        self._FileInnerUrl = params.get("FileInnerUrl")
        self._PlatformId = params.get("PlatformId")
        self._TaskType = params.get("TaskType")
        self._MNPVersionIntro = params.get("MNPVersionIntro")
        self._MNPVersionDesc = params.get("MNPVersionDesc")
        self._SourceType = params.get("SourceType")
        self._ReleaseChannel = params.get("ReleaseChannel")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateConsoleMNPVersionCompileTaskResponse(AbstractModel):
    """CreateConsoleMNPVersionCompileTask response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.CreateMNPVersionCompileTaskResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = CreateMNPVersionCompileTaskResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CreateDomainParam(AbstractModel):
    """Parameters to create a domain name

    """

    def __init__(self):
        r"""
        :param _DomainUrlList: Array of domain name URLs
        :type DomainUrlList: list of str
        :param _DomainType: Domain type. 1: requests domain; 2: WebView load domain, 3: sockets domain; 4: File upload; 5: File download
        :type DomainType: int
        """
        self._DomainUrlList = None
        self._DomainType = None

    @property
    def DomainUrlList(self):
        return self._DomainUrlList

    @DomainUrlList.setter
    def DomainUrlList(self, DomainUrlList):
        self._DomainUrlList = DomainUrlList

    @property
    def DomainType(self):
        return self._DomainType

    @DomainType.setter
    def DomainType(self, DomainType):
        self._DomainType = DomainType


    def _deserialize(self, params):
        self._DomainUrlList = params.get("DomainUrlList")
        self._DomainType = params.get("DomainType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDomainRequest(AbstractModel):
    """CreateDomain request structure.

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _Domain: Domain name list
        :type Domain: list of CreateDomainParam
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._MNPId = None
        self._Domain = None
        self._PlatformId = None

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        if params.get("Domain") is not None:
            self._Domain = []
            for item in params.get("Domain"):
                obj = CreateDomainParam()
                obj._deserialize(item)
                self._Domain.append(obj)
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDomainResponse(AbstractModel):
    """CreateDomain response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CreateGlobalDomainACLRequest(AbstractModel):
    """CreateGlobalDomainACL request structure.

    """

    def __init__(self):
        r"""
        :param _DomainUrlList: Domain name list
        :type DomainUrlList: list of str
        :param _DomainType: Domain type. 1: Allowed; 2: Blocked
        :type DomainType: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._DomainUrlList = None
        self._DomainType = None
        self._PlatformId = None

    @property
    def DomainUrlList(self):
        return self._DomainUrlList

    @DomainUrlList.setter
    def DomainUrlList(self, DomainUrlList):
        self._DomainUrlList = DomainUrlList

    @property
    def DomainType(self):
        return self._DomainType

    @DomainType.setter
    def DomainType(self, DomainType):
        self._DomainType = DomainType

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._DomainUrlList = params.get("DomainUrlList")
        self._DomainType = params.get("DomainType")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateGlobalDomainACLResponse(AbstractModel):
    """CreateGlobalDomainACL response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.CreateGlobalDomainResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = CreateGlobalDomainResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CreateGlobalDomainRequest(AbstractModel):
    """CreateGlobalDomain request structure.

    """

    def __init__(self):
        r"""
        :param _DomainUrlList: Domain name list
        :type DomainUrlList: list of str
        :param _DomainType: Domain type. 1: Allowed; 2: Blocked
        :type DomainType: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._DomainUrlList = None
        self._DomainType = None
        self._PlatformId = None

    @property
    def DomainUrlList(self):
        return self._DomainUrlList

    @DomainUrlList.setter
    def DomainUrlList(self, DomainUrlList):
        self._DomainUrlList = DomainUrlList

    @property
    def DomainType(self):
        return self._DomainType

    @DomainType.setter
    def DomainType(self, DomainType):
        self._DomainType = DomainType

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._DomainUrlList = params.get("DomainUrlList")
        self._DomainType = params.get("DomainType")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateGlobalDomainResp(AbstractModel):
    """Response of creating a global domain name

    """

    def __init__(self):
        r"""
        :param _Result: Result
Note: This field may return null, indicating that no valid values can be obtained.
        :type Result: bool
        :param _RepeatUrls: List of duplicate domain names
Note: This field may return null, indicating that no valid values can be obtained.
        :type RepeatUrls: list of str
        :param _ExistsWhiteUrls: List of allowed domain names
Note: This field may return null, indicating that no valid values can be obtained.
        :type ExistsWhiteUrls: list of str
        :param _ExistsBlackUrls: List of blocked domain names
Note: This field may return null, indicating that no valid values can be obtained.
        :type ExistsBlackUrls: list of str
        """
        self._Result = None
        self._RepeatUrls = None
        self._ExistsWhiteUrls = None
        self._ExistsBlackUrls = None

    @property
    def Result(self):
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RepeatUrls(self):
        return self._RepeatUrls

    @RepeatUrls.setter
    def RepeatUrls(self, RepeatUrls):
        self._RepeatUrls = RepeatUrls

    @property
    def ExistsWhiteUrls(self):
        return self._ExistsWhiteUrls

    @ExistsWhiteUrls.setter
    def ExistsWhiteUrls(self, ExistsWhiteUrls):
        self._ExistsWhiteUrls = ExistsWhiteUrls

    @property
    def ExistsBlackUrls(self):
        return self._ExistsBlackUrls

    @ExistsBlackUrls.setter
    def ExistsBlackUrls(self, ExistsBlackUrls):
        self._ExistsBlackUrls = ExistsBlackUrls


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RepeatUrls = params.get("RepeatUrls")
        self._ExistsWhiteUrls = params.get("ExistsWhiteUrls")
        self._ExistsBlackUrls = params.get("ExistsBlackUrls")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateGlobalDomainResponse(AbstractModel):
    """CreateGlobalDomain response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.CreateGlobalDomainResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = CreateGlobalDomainResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CreateMNPApprovalRequest(AbstractModel):
    """CreateMNPApproval request structure.

    """

    def __init__(self):
        r"""
        :param _MNPVersionId: Mini program version ID
        :type MNPVersionId: int
        :param _ApplyAction: submit: Submit an approval request; cancel: Cancel the approval request
        :type ApplyAction: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._MNPVersionId = None
        self._ApplyAction = None
        self._PlatformId = None

    @property
    def MNPVersionId(self):
        return self._MNPVersionId

    @MNPVersionId.setter
    def MNPVersionId(self, MNPVersionId):
        self._MNPVersionId = MNPVersionId

    @property
    def ApplyAction(self):
        return self._ApplyAction

    @ApplyAction.setter
    def ApplyAction(self, ApplyAction):
        self._ApplyAction = ApplyAction

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._MNPVersionId = params.get("MNPVersionId")
        self._ApplyAction = params.get("ApplyAction")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateMNPApprovalResponse(AbstractModel):
    """CreateMNPApproval response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CreateMNPDomainACLRequest(AbstractModel):
    """CreateMNPDomainACL request structure.

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _Domain: Domain name list
        :type Domain: list of CreateDomainParam
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._MNPId = None
        self._Domain = None
        self._PlatformId = None

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        if params.get("Domain") is not None:
            self._Domain = []
            for item in params.get("Domain"):
                obj = CreateDomainParam()
                obj._deserialize(item)
                self._Domain.append(obj)
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateMNPDomainACLResponse(AbstractModel):
    """CreateMNPDomainACL response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CreateMNPRequest(AbstractModel):
    """CreateMNP request structure.

    """

    def __init__(self):
        r"""
        :param _MNPType: Mini program type
        :type MNPType: str
        :param _MNPName: Mini program name
        :type MNPName: str
        :param _MNPIcon: Mini app icon
        :type MNPIcon: str
        :param _MNPIntro: Mini program introduction
        :type MNPIntro: str
        :param _MNPDesc: Mini program description
        :type MNPDesc: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _TeamId: Team ID
        :type TeamId: str
        """
        self._MNPType = None
        self._MNPName = None
        self._MNPIcon = None
        self._MNPIntro = None
        self._MNPDesc = None
        self._PlatformId = None
        self._TeamId = None

    @property
    def MNPType(self):
        return self._MNPType

    @MNPType.setter
    def MNPType(self, MNPType):
        self._MNPType = MNPType

    @property
    def MNPName(self):
        return self._MNPName

    @MNPName.setter
    def MNPName(self, MNPName):
        self._MNPName = MNPName

    @property
    def MNPIcon(self):
        return self._MNPIcon

    @MNPIcon.setter
    def MNPIcon(self, MNPIcon):
        self._MNPIcon = MNPIcon

    @property
    def MNPIntro(self):
        return self._MNPIntro

    @MNPIntro.setter
    def MNPIntro(self, MNPIntro):
        self._MNPIntro = MNPIntro

    @property
    def MNPDesc(self):
        return self._MNPDesc

    @MNPDesc.setter
    def MNPDesc(self, MNPDesc):
        self._MNPDesc = MNPDesc

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def TeamId(self):
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId


    def _deserialize(self, params):
        self._MNPType = params.get("MNPType")
        self._MNPName = params.get("MNPName")
        self._MNPIcon = params.get("MNPIcon")
        self._MNPIntro = params.get("MNPIntro")
        self._MNPDesc = params.get("MNPDesc")
        self._PlatformId = params.get("PlatformId")
        self._TeamId = params.get("TeamId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateMNPResponse(AbstractModel):
    """CreateMNP response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.ResourceIdStringInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = ResourceIdStringInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CreateMNPSensitiveAPIPermissionApprovalRequest(AbstractModel):
    """CreateMNPSensitiveAPIPermissionApproval request structure.

    """

    def __init__(self):
        r"""
        :param _APIId: API Id
        :type APIId: str
        :param _ApplyReason: Reason for application
        :type ApplyReason: str
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._APIId = None
        self._ApplyReason = None
        self._MNPId = None
        self._PlatformId = None

    @property
    def APIId(self):
        return self._APIId

    @APIId.setter
    def APIId(self, APIId):
        self._APIId = APIId

    @property
    def ApplyReason(self):
        return self._ApplyReason

    @ApplyReason.setter
    def ApplyReason(self, ApplyReason):
        self._ApplyReason = ApplyReason

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._APIId = params.get("APIId")
        self._ApplyReason = params.get("ApplyReason")
        self._MNPId = params.get("MNPId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateMNPSensitiveAPIPermissionApprovalResponse(AbstractModel):
    """CreateMNPSensitiveAPIPermissionApproval response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.ResourceIdStringInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = ResourceIdStringInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CreateMNPVersionCompileTaskResp(AbstractModel):
    """Compilation task

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type TaskId: str
        :param _WSUrl: WS address
Note: This field may return null, indicating that no valid values can be obtained.
        :type WSUrl: str
        :param _RoomId: Room ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type RoomId: str
        """
        self._TaskId = None
        self._WSUrl = None
        self._RoomId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def WSUrl(self):
        return self._WSUrl

    @WSUrl.setter
    def WSUrl(self, WSUrl):
        self._WSUrl = WSUrl

    @property
    def RoomId(self):
        return self._RoomId

    @RoomId.setter
    def RoomId(self, RoomId):
        self._RoomId = RoomId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._WSUrl = params.get("WSUrl")
        self._RoomId = params.get("RoomId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateMNPVersionRequest(AbstractModel):
    """CreateMNPVersion request structure.

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _MNPVersion: Version number
        :type MNPVersion: str
        :param _FileUrl: Address of the mini program package. You can export the package from IDE and upload it to a file server. 
        :type FileUrl: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _MNPVersionIntro: Version introduction
        :type MNPVersionIntro: str
        """
        self._MNPId = None
        self._MNPVersion = None
        self._FileUrl = None
        self._PlatformId = None
        self._MNPVersionIntro = None

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def MNPVersion(self):
        return self._MNPVersion

    @MNPVersion.setter
    def MNPVersion(self, MNPVersion):
        self._MNPVersion = MNPVersion

    @property
    def FileUrl(self):
        return self._FileUrl

    @FileUrl.setter
    def FileUrl(self, FileUrl):
        self._FileUrl = FileUrl

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def MNPVersionIntro(self):
        return self._MNPVersionIntro

    @MNPVersionIntro.setter
    def MNPVersionIntro(self, MNPVersionIntro):
        self._MNPVersionIntro = MNPVersionIntro


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._MNPVersion = params.get("MNPVersion")
        self._FileUrl = params.get("FileUrl")
        self._PlatformId = params.get("PlatformId")
        self._MNPVersionIntro = params.get("MNPVersionIntro")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateMNPVersionResp(AbstractModel):
    """Response of creating a mini program version

    """

    def __init__(self):
        r"""
        :param _TaskId: ID of the task to create a mini program version
Note: This field may return null, indicating that no valid values can be obtained.
        :type TaskId: str
        """
        self._TaskId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateMNPVersionResponse(AbstractModel):
    """CreateMNPVersion response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.CreateMNPVersionResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = CreateMNPVersionResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CreateOnlineApplyRequest(AbstractModel):
    """CreateOnlineApply request structure.

    """

    def __init__(self):
        r"""
        :param _MNPVersionId: Mini program version ID
        :type MNPVersionId: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._MNPVersionId = None
        self._PlatformId = None

    @property
    def MNPVersionId(self):
        return self._MNPVersionId

    @MNPVersionId.setter
    def MNPVersionId(self, MNPVersionId):
        self._MNPVersionId = MNPVersionId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._MNPVersionId = params.get("MNPVersionId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOnlineApplyResponse(AbstractModel):
    """CreateOnlineApply response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CreatePlatformAuditRequest(AbstractModel):
    """CreatePlatformAudit request structure.

    """

    def __init__(self):
        r"""
        :param _MNPVersionId: Mini program version ID
        :type MNPVersionId: int
        :param _ApplyAction: submit - submit the review ticket, cancel - cancel the review ticket
        :type ApplyAction: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._MNPVersionId = None
        self._ApplyAction = None
        self._PlatformId = None

    @property
    def MNPVersionId(self):
        return self._MNPVersionId

    @MNPVersionId.setter
    def MNPVersionId(self, MNPVersionId):
        self._MNPVersionId = MNPVersionId

    @property
    def ApplyAction(self):
        return self._ApplyAction

    @ApplyAction.setter
    def ApplyAction(self, ApplyAction):
        self._ApplyAction = ApplyAction

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._MNPVersionId = params.get("MNPVersionId")
        self._ApplyAction = params.get("ApplyAction")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreatePlatformAuditResponse(AbstractModel):
    """CreatePlatformAudit response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CreatePresetKeyRequest(AbstractModel):
    """CreatePresetKey request structure.

    """


class CreatePresetKeyResponse(AbstractModel):
    """CreatePresetKey response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.PresetResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = PresetResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CreateSensitiveAPIReq(AbstractModel):
    """New sensitive APIs

    """

    def __init__(self):
        r"""
        :param _ApiName: API name
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApiName: str
        :param _ApiDesc: API description
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApiDesc: str
        :param _ApiType: API type 1-System API 2-Custom API
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApiType: int
        """
        self._ApiName = None
        self._ApiDesc = None
        self._ApiType = None

    @property
    def ApiName(self):
        return self._ApiName

    @ApiName.setter
    def ApiName(self, ApiName):
        self._ApiName = ApiName

    @property
    def ApiDesc(self):
        return self._ApiDesc

    @ApiDesc.setter
    def ApiDesc(self, ApiDesc):
        self._ApiDesc = ApiDesc

    @property
    def ApiType(self):
        return self._ApiType

    @ApiType.setter
    def ApiType(self, ApiType):
        self._ApiType = ApiType


    def _deserialize(self, params):
        self._ApiName = params.get("ApiName")
        self._ApiDesc = params.get("ApiDesc")
        self._ApiType = params.get("ApiType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSensitiveAPIRequest(AbstractModel):
    """CreateSensitiveAPI request structure.

    """

    def __init__(self):
        r"""
        :param _ApplicationId: Application ID
        :type ApplicationId: str
        :param _ApiList: New API list
        :type ApiList: list of CreateSensitiveAPIReq
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._ApplicationId = None
        self._ApiList = None
        self._PlatformId = None

    @property
    def ApplicationId(self):
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def ApiList(self):
        return self._ApiList

    @ApiList.setter
    def ApiList(self, ApiList):
        self._ApiList = ApiList

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._ApplicationId = params.get("ApplicationId")
        if params.get("ApiList") is not None:
            self._ApiList = []
            for item in params.get("ApiList"):
                obj = CreateSensitiveAPIReq()
                obj._deserialize(item)
                self._ApiList.append(obj)
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSensitiveAPIResponse(AbstractModel):
    """CreateSensitiveAPI response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CreateSensitiveApiApplyRequest(AbstractModel):
    """CreateSensitiveApiApply request structure.

    """

    def __init__(self):
        r"""
        :param _APIId: Application ID
        :type APIId: str
        :param _ApplyReason: Reason for application
        :type ApplyReason: str
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._APIId = None
        self._ApplyReason = None
        self._MNPId = None
        self._PlatformId = None

    @property
    def APIId(self):
        return self._APIId

    @APIId.setter
    def APIId(self, APIId):
        self._APIId = APIId

    @property
    def ApplyReason(self):
        return self._ApplyReason

    @ApplyReason.setter
    def ApplyReason(self, ApplyReason):
        self._ApplyReason = ApplyReason

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._APIId = params.get("APIId")
        self._ApplyReason = params.get("ApplyReason")
        self._MNPId = params.get("MNPId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSensitiveApiApplyResponse(AbstractModel):
    """CreateSensitiveApiApply response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.ResourceIdStringInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = ResourceIdStringInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CreateTeamMemberInfoReq(AbstractModel):
    """New team member - Member information

    """

    def __init__(self):
        r"""
        :param _UserId: User ID
        :type UserId: str
        :param _UserRoleId: User role ID
        :type UserRoleId: int
        """
        self._UserId = None
        self._UserRoleId = None

    @property
    def UserId(self):
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def UserRoleId(self):
        return self._UserRoleId

    @UserRoleId.setter
    def UserRoleId(self, UserRoleId):
        self._UserRoleId = UserRoleId


    def _deserialize(self, params):
        self._UserId = params.get("UserId")
        self._UserRoleId = params.get("UserRoleId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateTeamMemberInfoResp(AbstractModel):
    """Response of creating team member

    """

    def __init__(self):
        r"""
        :param _UserId: User ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type UserId: str
        """
        self._UserId = None

    @property
    def UserId(self):
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId


    def _deserialize(self, params):
        self._UserId = params.get("UserId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateTeamMemberRequest(AbstractModel):
    """CreateTeamMember request structure.

    """

    def __init__(self):
        r"""
        :param _UserName: Username
        :type UserName: str
        :param _UserAccount: User account
        :type UserAccount: str
        :param _UserPassword: Account password. Use CreatePresetKey to get publick key to encrypt the password.
        :type UserPassword: str
        :param _TeamId: Team ID
        :type TeamId: str
        :param _RoleId: Team role
        :type RoleId: int
        :param _KeyId: Call CreatePresetKey to get the keyID from RequestId
        :type KeyId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._UserName = None
        self._UserAccount = None
        self._UserPassword = None
        self._TeamId = None
        self._RoleId = None
        self._KeyId = None
        self._PlatformId = None

    @property
    def UserName(self):
        return self._UserName

    @UserName.setter
    def UserName(self, UserName):
        self._UserName = UserName

    @property
    def UserAccount(self):
        return self._UserAccount

    @UserAccount.setter
    def UserAccount(self, UserAccount):
        self._UserAccount = UserAccount

    @property
    def UserPassword(self):
        return self._UserPassword

    @UserPassword.setter
    def UserPassword(self, UserPassword):
        self._UserPassword = UserPassword

    @property
    def TeamId(self):
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId

    @property
    def RoleId(self):
        return self._RoleId

    @RoleId.setter
    def RoleId(self, RoleId):
        self._RoleId = RoleId

    @property
    def KeyId(self):
        return self._KeyId

    @KeyId.setter
    def KeyId(self, KeyId):
        self._KeyId = KeyId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._UserName = params.get("UserName")
        self._UserAccount = params.get("UserAccount")
        self._UserPassword = params.get("UserPassword")
        self._TeamId = params.get("TeamId")
        self._RoleId = params.get("RoleId")
        self._KeyId = params.get("KeyId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateTeamMemberResponse(AbstractModel):
    """CreateTeamMember response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.CreateTeamMemberInfoResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = CreateTeamMemberInfoResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CreateTeamRequest(AbstractModel):
    """CreateTeam request structure.

    """

    def __init__(self):
        r"""
        :param _TeamName: Team name
        :type TeamName: str
        :param _AdminUserId: Administrator name
        :type AdminUserId: str
        :param _TeamRoleTypeList: Permission assigned to the team. 1: Mini program; 2: Application (only one of these types is supported)
        :type TeamRoleTypeList: list of int
        :param _Remark: Remarks
        :type Remark: str
        :param _PlatformId: Platform ID, required for API call
        :type PlatformId: str
        :param _RelatedTeamId: Associated team ID
        :type RelatedTeamId: str
        """
        self._TeamName = None
        self._AdminUserId = None
        self._TeamRoleTypeList = None
        self._Remark = None
        self._PlatformId = None
        self._RelatedTeamId = None

    @property
    def TeamName(self):
        return self._TeamName

    @TeamName.setter
    def TeamName(self, TeamName):
        self._TeamName = TeamName

    @property
    def AdminUserId(self):
        return self._AdminUserId

    @AdminUserId.setter
    def AdminUserId(self, AdminUserId):
        self._AdminUserId = AdminUserId

    @property
    def TeamRoleTypeList(self):
        return self._TeamRoleTypeList

    @TeamRoleTypeList.setter
    def TeamRoleTypeList(self, TeamRoleTypeList):
        self._TeamRoleTypeList = TeamRoleTypeList

    @property
    def Remark(self):
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def RelatedTeamId(self):
        return self._RelatedTeamId

    @RelatedTeamId.setter
    def RelatedTeamId(self, RelatedTeamId):
        self._RelatedTeamId = RelatedTeamId


    def _deserialize(self, params):
        self._TeamName = params.get("TeamName")
        self._AdminUserId = params.get("AdminUserId")
        self._TeamRoleTypeList = params.get("TeamRoleTypeList")
        self._Remark = params.get("Remark")
        self._PlatformId = params.get("PlatformId")
        self._RelatedTeamId = params.get("RelatedTeamId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateTeamResponse(AbstractModel):
    """CreateTeam response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateUserRequest(AbstractModel):
    """CreateUser request structure.

    """

    def __init__(self):
        r"""
        :param _UserAccount: User account
        :type UserAccount: str
        :param _UserName: User name
        :type UserName: str
        :param _AccountType: User account type. 2: Platform administrator; 3: Ordinary member. 
        :type AccountType: int
        :param _Password: Account password. Use CreatePresetKey to get the public key to encrypt the password.
        :type Password: str
        :param _KeyId: Call CreatePresetKey to get the keyID from RequestId
        :type KeyId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._UserAccount = None
        self._UserName = None
        self._AccountType = None
        self._Password = None
        self._KeyId = None
        self._PlatformId = None

    @property
    def UserAccount(self):
        return self._UserAccount

    @UserAccount.setter
    def UserAccount(self, UserAccount):
        self._UserAccount = UserAccount

    @property
    def UserName(self):
        return self._UserName

    @UserName.setter
    def UserName(self, UserName):
        self._UserName = UserName

    @property
    def AccountType(self):
        return self._AccountType

    @AccountType.setter
    def AccountType(self, AccountType):
        self._AccountType = AccountType

    @property
    def Password(self):
        return self._Password

    @Password.setter
    def Password(self, Password):
        self._Password = Password

    @property
    def KeyId(self):
        return self._KeyId

    @KeyId.setter
    def KeyId(self, KeyId):
        self._KeyId = KeyId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._UserAccount = params.get("UserAccount")
        self._UserName = params.get("UserName")
        self._AccountType = params.get("AccountType")
        self._Password = params.get("Password")
        self._KeyId = params.get("KeyId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateUserResponse(AbstractModel):
    """CreateUser response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data, user ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.ResourceIdStringInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = ResourceIdStringInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DeleteApplicationRequest(AbstractModel):
    """DeleteApplication request structure.

    """

    def __init__(self):
        r"""
        :param _ApplicationId: Application ID
        :type ApplicationId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._ApplicationId = None
        self._PlatformId = None

    @property
    def ApplicationId(self):
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._ApplicationId = params.get("ApplicationId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteApplicationResponse(AbstractModel):
    """DeleteApplication response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DeleteApplicationSensitiveAPIRequest(AbstractModel):
    """DeleteApplicationSensitiveAPI request structure.

    """

    def __init__(self):
        r"""
        :param _APIId: API ID
        :type APIId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._APIId = None
        self._PlatformId = None

    @property
    def APIId(self):
        return self._APIId

    @APIId.setter
    def APIId(self, APIId):
        self._APIId = APIId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._APIId = params.get("APIId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteApplicationSensitiveAPIResponse(AbstractModel):
    """DeleteApplicationSensitiveAPI response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DeleteGlobalDomainRequest(AbstractModel):
    """DeleteGlobalDomain request structure.

    """

    def __init__(self):
        r"""
        :param _DomainId: Domain ID
        :type DomainId: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._DomainId = None
        self._PlatformId = None

    @property
    def DomainId(self):
        return self._DomainId

    @DomainId.setter
    def DomainId(self, DomainId):
        self._DomainId = DomainId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._DomainId = params.get("DomainId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteGlobalDomainResponse(AbstractModel):
    """DeleteGlobalDomain response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.GlobalDomainDeleteResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = GlobalDomainDeleteResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DeleteMNPRequest(AbstractModel):
    """DeleteMNP request structure.

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._MNPId = None
        self._PlatformId = None

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteMNPResponse(AbstractModel):
    """DeleteMNP response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DeleteSensitiveAPIRequest(AbstractModel):
    """DeleteSensitiveAPI request structure.

    """

    def __init__(self):
        r"""
        :param _ApiId: API ID
        :type ApiId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._ApiId = None
        self._PlatformId = None

    @property
    def ApiId(self):
        return self._ApiId

    @ApiId.setter
    def ApiId(self, ApiId):
        self._ApiId = ApiId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._ApiId = params.get("ApiId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSensitiveAPIResponse(AbstractModel):
    """DeleteSensitiveAPI response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DeleteTeamMemberRequest(AbstractModel):
    """DeleteTeamMember request structure.

    """

    def __init__(self):
        r"""
        :param _TeamId: Team ID
        :type TeamId: str
        :param _UserId: User ID
        :type UserId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._TeamId = None
        self._UserId = None
        self._PlatformId = None

    @property
    def TeamId(self):
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId

    @property
    def UserId(self):
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._TeamId = params.get("TeamId")
        self._UserId = params.get("UserId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteTeamMemberResponse(AbstractModel):
    """DeleteTeamMember response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DeleteTeamRequest(AbstractModel):
    """DeleteTeam request structure.

    """

    def __init__(self):
        r"""
        :param _TeamId: Team ID
        :type TeamId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._TeamId = None
        self._PlatformId = None

    @property
    def TeamId(self):
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._TeamId = params.get("TeamId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteTeamResponse(AbstractModel):
    """DeleteTeam response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DeleteUserRequest(AbstractModel):
    """DeleteUser request structure.

    """

    def __init__(self):
        r"""
        :param _UserId: User ID
        :type UserId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._UserId = None
        self._PlatformId = None

    @property
    def UserId(self):
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._UserId = params.get("UserId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteUserResponse(AbstractModel):
    """DeleteUser response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeApplicationConfigFileRequest(AbstractModel):
    """DescribeApplicationConfigFile request structure.

    """

    def __init__(self):
        r"""
        :param _ApplicationId: Application ID
        :type ApplicationId: str
        :param _AppType: Application platform. 2: Android; 3: iOS
        :type AppType: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._ApplicationId = None
        self._AppType = None
        self._PlatformId = None

    @property
    def ApplicationId(self):
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def AppType(self):
        return self._AppType

    @AppType.setter
    def AppType(self, AppType):
        self._AppType = AppType

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._ApplicationId = params.get("ApplicationId")
        self._AppType = params.get("AppType")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeApplicationConfigFileResponse(AbstractModel):
    """DescribeApplicationConfigFile response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.DownloadApplicationConfigResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DownloadApplicationConfigResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeApplicationConfigRequest(AbstractModel):
    """DescribeApplicationConfig request structure.

    """

    def __init__(self):
        r"""
        :param _ApplicationId: Application ID
        :type ApplicationId: str
        :param _AppType: Application platform. 2: Android; 3: iOS
        :type AppType: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._ApplicationId = None
        self._AppType = None
        self._PlatformId = None

    @property
    def ApplicationId(self):
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def AppType(self):
        return self._AppType

    @AppType.setter
    def AppType(self, AppType):
        self._AppType = AppType

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._ApplicationId = params.get("ApplicationId")
        self._AppType = params.get("AppType")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeApplicationConfigResponse(AbstractModel):
    """DescribeApplicationConfig response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.DownloadApplicationConfigResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DownloadApplicationConfigResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeApplicationListRequest(AbstractModel):
    """DescribeApplicationList request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Page offset
        :type Offset: int
        :param _Limit: Number of results per page
        :type Limit: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _Keyword: Keywords for search (app name)
        :type Keyword: str
        :param _TeamId: Team ID
        :type TeamId: str
        """
        self._Offset = None
        self._Limit = None
        self._PlatformId = None
        self._Keyword = None
        self._TeamId = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def Keyword(self):
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword

    @property
    def TeamId(self):
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._PlatformId = params.get("PlatformId")
        self._Keyword = params.get("Keyword")
        self._TeamId = params.get("TeamId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeApplicationListResponse(AbstractModel):
    """DescribeApplicationList response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.ApplicationPageInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = ApplicationPageInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeApplicationMNPVersionAuditListInfoResp(AbstractModel):
    """Mini program review list information

    """

    def __init__(self):
        r"""
        :param _AuditNo: Approval ticket ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type AuditNo: str
        :param _ApplicationId: Application ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationId: str
        :param _AuditStatus: Approval status : 1: Processing; 2: Rejected; 3: Approved; 4: Cancelled
Note: This field may return null, indicating that no valid values can be obtained.
        :type AuditStatus: int
        :param _MNPId: Mini program ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPId: str
        :param _MNPVersion: Mini program version
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPVersion: str
        :param _MNPVersionId: Mini program version ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPVersionId: int
        :param _ApplyUser: Applicant
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplyUser: str
        :param _ApplyTime: Application time
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplyTime: str
        :param _MNPName: Mini program name
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPName: str
        :param _MNPIcon: Mini program icon
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPIcon: str
        :param _ApplicationName: Application name
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationName: str
        :param _ApplicationLogo: Application icon
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationLogo: str
        :param _TeamId: Team ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamId: str
        :param _TeamName: Team name
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamName: str
        :param _ApplicationAndUrl: Android app download address
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationAndUrl: str
        :param _ApplicationIOSUrl: iOS app download address
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationIOSUrl: str
        :param _MNPQrCodeUrl: Mini Program QR code
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPQrCodeUrl: str
        :param _MNPType: Mini program type
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPType: str
        :param _AuditUser: Approver
Note: This field may return null, indicating that no valid values can be obtained.
        :type AuditUser: str
        :param _AuditTime: Approval time
Note: This field may return null, indicating that no valid values can be obtained.
        :type AuditTime: str
        :param _AuditNote: Approval notes
Note: This field may return null, indicating that no valid values can be obtained.
        :type AuditNote: str
        :param _ScanStatus: Scan result. 0: Scanning, 1: Healthy; 2: Unhealthy; 3: Task failed
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanStatus: int
        :param _ScanScore: Scan score
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanScore: int
        :param _ScanHtmlPath: Address scanned
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanHtmlPath: str
        """
        self._AuditNo = None
        self._ApplicationId = None
        self._AuditStatus = None
        self._MNPId = None
        self._MNPVersion = None
        self._MNPVersionId = None
        self._ApplyUser = None
        self._ApplyTime = None
        self._MNPName = None
        self._MNPIcon = None
        self._ApplicationName = None
        self._ApplicationLogo = None
        self._TeamId = None
        self._TeamName = None
        self._ApplicationAndUrl = None
        self._ApplicationIOSUrl = None
        self._MNPQrCodeUrl = None
        self._MNPType = None
        self._AuditUser = None
        self._AuditTime = None
        self._AuditNote = None
        self._ScanStatus = None
        self._ScanScore = None
        self._ScanHtmlPath = None

    @property
    def AuditNo(self):
        return self._AuditNo

    @AuditNo.setter
    def AuditNo(self, AuditNo):
        self._AuditNo = AuditNo

    @property
    def ApplicationId(self):
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def AuditStatus(self):
        return self._AuditStatus

    @AuditStatus.setter
    def AuditStatus(self, AuditStatus):
        self._AuditStatus = AuditStatus

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def MNPVersion(self):
        return self._MNPVersion

    @MNPVersion.setter
    def MNPVersion(self, MNPVersion):
        self._MNPVersion = MNPVersion

    @property
    def MNPVersionId(self):
        return self._MNPVersionId

    @MNPVersionId.setter
    def MNPVersionId(self, MNPVersionId):
        self._MNPVersionId = MNPVersionId

    @property
    def ApplyUser(self):
        return self._ApplyUser

    @ApplyUser.setter
    def ApplyUser(self, ApplyUser):
        self._ApplyUser = ApplyUser

    @property
    def ApplyTime(self):
        return self._ApplyTime

    @ApplyTime.setter
    def ApplyTime(self, ApplyTime):
        self._ApplyTime = ApplyTime

    @property
    def MNPName(self):
        return self._MNPName

    @MNPName.setter
    def MNPName(self, MNPName):
        self._MNPName = MNPName

    @property
    def MNPIcon(self):
        return self._MNPIcon

    @MNPIcon.setter
    def MNPIcon(self, MNPIcon):
        self._MNPIcon = MNPIcon

    @property
    def ApplicationName(self):
        return self._ApplicationName

    @ApplicationName.setter
    def ApplicationName(self, ApplicationName):
        self._ApplicationName = ApplicationName

    @property
    def ApplicationLogo(self):
        return self._ApplicationLogo

    @ApplicationLogo.setter
    def ApplicationLogo(self, ApplicationLogo):
        self._ApplicationLogo = ApplicationLogo

    @property
    def TeamId(self):
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId

    @property
    def TeamName(self):
        return self._TeamName

    @TeamName.setter
    def TeamName(self, TeamName):
        self._TeamName = TeamName

    @property
    def ApplicationAndUrl(self):
        return self._ApplicationAndUrl

    @ApplicationAndUrl.setter
    def ApplicationAndUrl(self, ApplicationAndUrl):
        self._ApplicationAndUrl = ApplicationAndUrl

    @property
    def ApplicationIOSUrl(self):
        return self._ApplicationIOSUrl

    @ApplicationIOSUrl.setter
    def ApplicationIOSUrl(self, ApplicationIOSUrl):
        self._ApplicationIOSUrl = ApplicationIOSUrl

    @property
    def MNPQrCodeUrl(self):
        return self._MNPQrCodeUrl

    @MNPQrCodeUrl.setter
    def MNPQrCodeUrl(self, MNPQrCodeUrl):
        self._MNPQrCodeUrl = MNPQrCodeUrl

    @property
    def MNPType(self):
        return self._MNPType

    @MNPType.setter
    def MNPType(self, MNPType):
        self._MNPType = MNPType

    @property
    def AuditUser(self):
        return self._AuditUser

    @AuditUser.setter
    def AuditUser(self, AuditUser):
        self._AuditUser = AuditUser

    @property
    def AuditTime(self):
        return self._AuditTime

    @AuditTime.setter
    def AuditTime(self, AuditTime):
        self._AuditTime = AuditTime

    @property
    def AuditNote(self):
        return self._AuditNote

    @AuditNote.setter
    def AuditNote(self, AuditNote):
        self._AuditNote = AuditNote

    @property
    def ScanStatus(self):
        return self._ScanStatus

    @ScanStatus.setter
    def ScanStatus(self, ScanStatus):
        self._ScanStatus = ScanStatus

    @property
    def ScanScore(self):
        return self._ScanScore

    @ScanScore.setter
    def ScanScore(self, ScanScore):
        self._ScanScore = ScanScore

    @property
    def ScanHtmlPath(self):
        return self._ScanHtmlPath

    @ScanHtmlPath.setter
    def ScanHtmlPath(self, ScanHtmlPath):
        self._ScanHtmlPath = ScanHtmlPath


    def _deserialize(self, params):
        self._AuditNo = params.get("AuditNo")
        self._ApplicationId = params.get("ApplicationId")
        self._AuditStatus = params.get("AuditStatus")
        self._MNPId = params.get("MNPId")
        self._MNPVersion = params.get("MNPVersion")
        self._MNPVersionId = params.get("MNPVersionId")
        self._ApplyUser = params.get("ApplyUser")
        self._ApplyTime = params.get("ApplyTime")
        self._MNPName = params.get("MNPName")
        self._MNPIcon = params.get("MNPIcon")
        self._ApplicationName = params.get("ApplicationName")
        self._ApplicationLogo = params.get("ApplicationLogo")
        self._TeamId = params.get("TeamId")
        self._TeamName = params.get("TeamName")
        self._ApplicationAndUrl = params.get("ApplicationAndUrl")
        self._ApplicationIOSUrl = params.get("ApplicationIOSUrl")
        self._MNPQrCodeUrl = params.get("MNPQrCodeUrl")
        self._MNPType = params.get("MNPType")
        self._AuditUser = params.get("AuditUser")
        self._AuditTime = params.get("AuditTime")
        self._AuditNote = params.get("AuditNote")
        self._ScanStatus = params.get("ScanStatus")
        self._ScanScore = params.get("ScanScore")
        self._ScanHtmlPath = params.get("ScanHtmlPath")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeApplicationMNPVersionAuditListPageResp(AbstractModel):
    """Approval tickets of the specified application/mini program

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of results.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _DataList: List information
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataList: list of DescribeApplicationMNPVersionAuditListInfoResp
        """
        self._TotalCount = None
        self._DataList = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DataList(self):
        return self._DataList

    @DataList.setter
    def DataList(self, DataList):
        self._DataList = DataList


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DataList") is not None:
            self._DataList = []
            for item in params.get("DataList"):
                obj = DescribeApplicationMNPVersionAuditListInfoResp()
                obj._deserialize(item)
                self._DataList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeApplicationMNPVersionAuditListRequest(AbstractModel):
    """DescribeApplicationMNPVersionAuditList request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Page offset
        :type Offset: int
        :param _Limit: Number of results per page
        :type Limit: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _AuditStatusList: Approval status 1 Processing 2 Rejected 3 Approved 4 Cancelled
        :type AuditStatusList: list of int
        :param _Keyword: Keyword
        :type Keyword: str
        :param _ApplicationId: Application ID
        :type ApplicationId: str
        :param _TeamId: Team ID
        :type TeamId: str
        """
        self._Offset = None
        self._Limit = None
        self._PlatformId = None
        self._AuditStatusList = None
        self._Keyword = None
        self._ApplicationId = None
        self._TeamId = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def AuditStatusList(self):
        return self._AuditStatusList

    @AuditStatusList.setter
    def AuditStatusList(self, AuditStatusList):
        self._AuditStatusList = AuditStatusList

    @property
    def Keyword(self):
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword

    @property
    def ApplicationId(self):
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def TeamId(self):
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._PlatformId = params.get("PlatformId")
        self._AuditStatusList = params.get("AuditStatusList")
        self._Keyword = params.get("Keyword")
        self._ApplicationId = params.get("ApplicationId")
        self._TeamId = params.get("TeamId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeApplicationMNPVersionAuditListResponse(AbstractModel):
    """DescribeApplicationMNPVersionAuditList response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.DescribeApplicationMNPVersionAuditListPageResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeApplicationMNPVersionAuditListPageResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeApplicationRequest(AbstractModel):
    """DescribeApplication request structure.

    """

    def __init__(self):
        r"""
        :param _ApplicationId: Application ID
        :type ApplicationId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._ApplicationId = None
        self._PlatformId = None

    @property
    def ApplicationId(self):
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._ApplicationId = params.get("ApplicationId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeApplicationResponse(AbstractModel):
    """DescribeApplication response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.ApplicationDetail`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = ApplicationDetail()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeApplicationSensitiveAPIListData(AbstractModel):
    """List of sensitive APIs of an application

    """

    def __init__(self):
        r"""
        :param _APIId: APIID
        :type APIId: str
        :param _APIName: API name
        :type APIName: str
        :param _APIMethod: API request method
        :type APIMethod: str
        :param _APIDesc: API description
Note: This field may return null, indicating that no valid values can be obtained.
        :type APIDesc: str
        :param _CreateUser: Creator
        :type CreateUser: str
        :param _CreateTime: Creation time
        :type CreateTime: str
        :param _UpdateUser: Updater
        :type UpdateUser: str
        :param _UpdateTime: Update time
        :type UpdateTime: str
        :param _ApplicationId: Application ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationId: str
        :param _ApplicationName: Application name
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationName: str
        :param _TeamId: Team ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamId: str
        :param _TeamName: Team name
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamName: str
        :param _ApplicationLogo: Application icon
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationLogo: str
        :param _APIType: API type. 1: System; 2: Custom
Note: This field may return null, indicating that no valid values can be obtained.
        :type APIType: int
        :param _Status: API status. 0: Public; 1: Restricted
Note: This field may return null, indicating that no valid values can be obtained.
        :type Status: int
        """
        self._APIId = None
        self._APIName = None
        self._APIMethod = None
        self._APIDesc = None
        self._CreateUser = None
        self._CreateTime = None
        self._UpdateUser = None
        self._UpdateTime = None
        self._ApplicationId = None
        self._ApplicationName = None
        self._TeamId = None
        self._TeamName = None
        self._ApplicationLogo = None
        self._APIType = None
        self._Status = None

    @property
    def APIId(self):
        return self._APIId

    @APIId.setter
    def APIId(self, APIId):
        self._APIId = APIId

    @property
    def APIName(self):
        return self._APIName

    @APIName.setter
    def APIName(self, APIName):
        self._APIName = APIName

    @property
    def APIMethod(self):
        return self._APIMethod

    @APIMethod.setter
    def APIMethod(self, APIMethod):
        self._APIMethod = APIMethod

    @property
    def APIDesc(self):
        return self._APIDesc

    @APIDesc.setter
    def APIDesc(self, APIDesc):
        self._APIDesc = APIDesc

    @property
    def CreateUser(self):
        return self._CreateUser

    @CreateUser.setter
    def CreateUser(self, CreateUser):
        self._CreateUser = CreateUser

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateUser(self):
        return self._UpdateUser

    @UpdateUser.setter
    def UpdateUser(self, UpdateUser):
        self._UpdateUser = UpdateUser

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def ApplicationId(self):
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def ApplicationName(self):
        return self._ApplicationName

    @ApplicationName.setter
    def ApplicationName(self, ApplicationName):
        self._ApplicationName = ApplicationName

    @property
    def TeamId(self):
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId

    @property
    def TeamName(self):
        return self._TeamName

    @TeamName.setter
    def TeamName(self, TeamName):
        self._TeamName = TeamName

    @property
    def ApplicationLogo(self):
        return self._ApplicationLogo

    @ApplicationLogo.setter
    def ApplicationLogo(self, ApplicationLogo):
        self._ApplicationLogo = ApplicationLogo

    @property
    def APIType(self):
        return self._APIType

    @APIType.setter
    def APIType(self, APIType):
        self._APIType = APIType

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._APIId = params.get("APIId")
        self._APIName = params.get("APIName")
        self._APIMethod = params.get("APIMethod")
        self._APIDesc = params.get("APIDesc")
        self._CreateUser = params.get("CreateUser")
        self._CreateTime = params.get("CreateTime")
        self._UpdateUser = params.get("UpdateUser")
        self._UpdateTime = params.get("UpdateTime")
        self._ApplicationId = params.get("ApplicationId")
        self._ApplicationName = params.get("ApplicationName")
        self._TeamId = params.get("TeamId")
        self._TeamName = params.get("TeamName")
        self._ApplicationLogo = params.get("ApplicationLogo")
        self._APIType = params.get("APIType")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeApplicationSensitiveAPIListRequest(AbstractModel):
    """DescribeApplicationSensitiveAPIList request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Page offset
        :type Offset: int
        :param _Limit: Number of results per page
        :type Limit: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _ApplicationId: Application ID
        :type ApplicationId: str
        :param _Keyword: Keywords for search (API name or method)
        :type Keyword: str
        :param _TeamId: Team ID
        :type TeamId: str
        """
        self._Offset = None
        self._Limit = None
        self._PlatformId = None
        self._ApplicationId = None
        self._Keyword = None
        self._TeamId = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def ApplicationId(self):
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def Keyword(self):
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword

    @property
    def TeamId(self):
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._PlatformId = params.get("PlatformId")
        self._ApplicationId = params.get("ApplicationId")
        self._Keyword = params.get("Keyword")
        self._TeamId = params.get("TeamId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeApplicationSensitiveAPIListResp(AbstractModel):
    """List of sensitive APIs of the application

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of entries
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _DataList: List information
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataList: list of DescribeApplicationSensitiveAPIListData
        """
        self._TotalCount = None
        self._DataList = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DataList(self):
        return self._DataList

    @DataList.setter
    def DataList(self, DataList):
        self._DataList = DataList


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DataList") is not None:
            self._DataList = []
            for item in params.get("DataList"):
                obj = DescribeApplicationSensitiveAPIListData()
                obj._deserialize(item)
                self._DataList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeApplicationSensitiveAPIListResponse(AbstractModel):
    """DescribeApplicationSensitiveAPIList response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.DescribeApplicationSensitiveAPIListResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeApplicationSensitiveAPIListResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeConsoleMNPVersionCompileTaskRequest(AbstractModel):
    """DescribeConsoleMNPVersionCompileTask request structure.

    """

    def __init__(self):
        r"""
        :param _BusinessId: Task ID
        :type BusinessId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._BusinessId = None
        self._PlatformId = None

    @property
    def BusinessId(self):
        return self._BusinessId

    @BusinessId.setter
    def BusinessId(self, BusinessId):
        self._BusinessId = BusinessId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._BusinessId = params.get("BusinessId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeConsoleMNPVersionCompileTaskResponse(AbstractModel):
    """DescribeConsoleMNPVersionCompileTask response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.DescribeMNPVersionCompileTaskResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeMNPVersionCompileTaskResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeDomainInfoParam(AbstractModel):
    """Domain information

    """

    def __init__(self):
        r"""
        :param _DomainUrl: Multiple domain separators ';'
Note: This field may return null, indicating that no valid values can be obtained.
        :type DomainUrl: str
        :param _DomainType: Domain type 1-requests domain 2-WebView load domain
Note: This field may return null, indicating that no valid values can be obtained.
        :type DomainType: int
        """
        self._DomainUrl = None
        self._DomainType = None

    @property
    def DomainUrl(self):
        return self._DomainUrl

    @DomainUrl.setter
    def DomainUrl(self, DomainUrl):
        self._DomainUrl = DomainUrl

    @property
    def DomainType(self):
        return self._DomainType

    @DomainType.setter
    def DomainType(self, DomainType):
        self._DomainType = DomainType


    def _deserialize(self, params):
        self._DomainUrl = params.get("DomainUrl")
        self._DomainType = params.get("DomainType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDomainInfoRequest(AbstractModel):
    """DescribeDomainInfo request structure.

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._MNPId = None
        self._PlatformId = None

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDomainInfoResponse(AbstractModel):
    """DescribeDomainInfo response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: list of DescribeDomainInfoParam
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = DescribeDomainInfoParam()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDomainTeamListInfoResp(AbstractModel):
    """Information of enterprise domain names

    """

    def __init__(self):
        r"""
        :param _TeamId: Team ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamId: str
        :param _TeamName: Team name
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamName: str
        :param _CreateUser: Creator
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateUser: str
        :param _CreateTime: Creation time
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        """
        self._TeamId = None
        self._TeamName = None
        self._CreateUser = None
        self._CreateTime = None

    @property
    def TeamId(self):
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId

    @property
    def TeamName(self):
        return self._TeamName

    @TeamName.setter
    def TeamName(self, TeamName):
        self._TeamName = TeamName

    @property
    def CreateUser(self):
        return self._CreateUser

    @CreateUser.setter
    def CreateUser(self, CreateUser):
        self._CreateUser = CreateUser

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime


    def _deserialize(self, params):
        self._TeamId = params.get("TeamId")
        self._TeamName = params.get("TeamName")
        self._CreateUser = params.get("CreateUser")
        self._CreateTime = params.get("CreateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDomainTeamListPageResp(AbstractModel):
    """Team domain list

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of entries
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _DataList: List information
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataList: list of DescribeDomainTeamListInfoResp
        """
        self._TotalCount = None
        self._DataList = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DataList(self):
        return self._DataList

    @DataList.setter
    def DataList(self, DataList):
        self._DataList = DataList


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DataList") is not None:
            self._DataList = []
            for item in params.get("DataList"):
                obj = DescribeDomainTeamListInfoResp()
                obj._deserialize(item)
                self._DataList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDomainTeamListRequest(AbstractModel):
    """DescribeDomainTeamList request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Pagination offset
        :type Offset: int
        :param _Limit: Number of results per page
        :type Limit: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _Keyword: Query keywords (team name)
        :type Keyword: str
        """
        self._Offset = None
        self._Limit = None
        self._PlatformId = None
        self._Keyword = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def Keyword(self):
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._PlatformId = params.get("PlatformId")
        self._Keyword = params.get("Keyword")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDomainTeamListResponse(AbstractModel):
    """DescribeDomainTeamList response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.DescribeDomainTeamListPageResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeDomainTeamListPageResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeGlobalDomainACLRequest(AbstractModel):
    """DescribeGlobalDomainACL request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Page offset
        :type Offset: int
        :param _Limit: Number of results per page
        :type Limit: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _DomainTypes: Domain type. 1: Allowed; 2: Blocked
        :type DomainTypes: list of int
        :param _Keyword: Domain names to be queried.
        :type Keyword: str
        """
        self._Offset = None
        self._Limit = None
        self._PlatformId = None
        self._DomainTypes = None
        self._Keyword = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def DomainTypes(self):
        return self._DomainTypes

    @DomainTypes.setter
    def DomainTypes(self, DomainTypes):
        self._DomainTypes = DomainTypes

    @property
    def Keyword(self):
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._PlatformId = params.get("PlatformId")
        self._DomainTypes = params.get("DomainTypes")
        self._Keyword = params.get("Keyword")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeGlobalDomainACLResponse(AbstractModel):
    """DescribeGlobalDomainACL response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.DescribeGlobalDomainsResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeGlobalDomainsResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeGlobalDomainListRequest(AbstractModel):
    """DescribeGlobalDomainList request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Pagination offset
        :type Offset: int
        :param _Limit: Number of results per page
        :type Limit: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _DomainTypes: Domain type. 1: Allowed; 2: Blocked
        :type DomainTypes: list of int
        :param _Keyword: Domain names to be queried.
        :type Keyword: str
        """
        self._Offset = None
        self._Limit = None
        self._PlatformId = None
        self._DomainTypes = None
        self._Keyword = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def DomainTypes(self):
        return self._DomainTypes

    @DomainTypes.setter
    def DomainTypes(self, DomainTypes):
        self._DomainTypes = DomainTypes

    @property
    def Keyword(self):
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._PlatformId = params.get("PlatformId")
        self._DomainTypes = params.get("DomainTypes")
        self._Keyword = params.get("Keyword")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeGlobalDomainListResponse(AbstractModel):
    """DescribeGlobalDomainList response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.GlobalDomainDescribeListPageResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = GlobalDomainDescribeListPageResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeGlobalDomainsListData(AbstractModel):
    """List of global domain names

    """

    def __init__(self):
        r"""
        :param _DomainId: Domain ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type DomainId: int
        :param _DomainUrl: Domain name
Note: This field may return null, indicating that no valid values can be obtained.
        :type DomainUrl: str
        :param _DomainType: Type. 1: Allowed; 2: Blocked
Note: This field may return null, indicating that no valid values can be obtained.
        :type DomainType: int
        :param _CreateUser: Creator
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateUser: str
        :param _CreateTime: Creation time
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        :param _UpdateUser: Updater
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateUser: str
        :param _UpdateTime: Update time
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateTime: str
        """
        self._DomainId = None
        self._DomainUrl = None
        self._DomainType = None
        self._CreateUser = None
        self._CreateTime = None
        self._UpdateUser = None
        self._UpdateTime = None

    @property
    def DomainId(self):
        return self._DomainId

    @DomainId.setter
    def DomainId(self, DomainId):
        self._DomainId = DomainId

    @property
    def DomainUrl(self):
        return self._DomainUrl

    @DomainUrl.setter
    def DomainUrl(self, DomainUrl):
        self._DomainUrl = DomainUrl

    @property
    def DomainType(self):
        return self._DomainType

    @DomainType.setter
    def DomainType(self, DomainType):
        self._DomainType = DomainType

    @property
    def CreateUser(self):
        return self._CreateUser

    @CreateUser.setter
    def CreateUser(self, CreateUser):
        self._CreateUser = CreateUser

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateUser(self):
        return self._UpdateUser

    @UpdateUser.setter
    def UpdateUser(self, UpdateUser):
        self._UpdateUser = UpdateUser

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._DomainId = params.get("DomainId")
        self._DomainUrl = params.get("DomainUrl")
        self._DomainType = params.get("DomainType")
        self._CreateUser = params.get("CreateUser")
        self._CreateTime = params.get("CreateTime")
        self._UpdateUser = params.get("UpdateUser")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeGlobalDomainsResp(AbstractModel):
    """Global domain name list

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of results
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _DataList: Domain name information
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataList: list of DescribeGlobalDomainsListData
        """
        self._TotalCount = None
        self._DataList = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DataList(self):
        return self._DataList

    @DataList.setter
    def DataList(self, DataList):
        self._DataList = DataList


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DataList") is not None:
            self._DataList = []
            for item in params.get("DataList"):
                obj = DescribeGlobalDomainsListData()
                obj._deserialize(item)
                self._DataList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPAllStageVersionsRequest(AbstractModel):
    """DescribeMNPAllStageVersions request structure.

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._MNPId = None
        self._PlatformId = None

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPAllStageVersionsResponse(AbstractModel):
    """DescribeMNPAllStageVersions response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: list of DescribeMPAllStageVersionsResp
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = DescribeMPAllStageVersionsResp()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeMNPApprovalListData(AbstractModel):
    """List of mini program approval requests of the application

    """

    def __init__(self):
        r"""
        :param _ApprovalNo: Approval request ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApprovalNo: str
        :param _ApplicationId: Application ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationId: str
        :param _ApprovalStatus: Approval status : 1: Processing; 2: Rejected; 3: Approved; 4: Cancelled
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApprovalStatus: int
        :param _MNPId: Mini program ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPId: str
        :param _MNPVersion: Mini program version
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPVersion: str
        :param _MNPVersionId: Mini program version ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPVersionId: int
        :param _ApplyUser: Applicant
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplyUser: str
        :param _ApplyTime: Application time
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplyTime: str
        :param _MNPName: Mini program name
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPName: str
        :param _MNPIcon: Mini program icon
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPIcon: str
        :param _ApplicationName: Application name
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationName: str
        :param _ApplicationLogo: Application icon
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationLogo: str
        :param _TeamId: Team ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamId: str
        :param _TeamName: Team name
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamName: str
        :param _MNPQrCodeUrl: Mini Program QR code
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPQrCodeUrl: str
        :param _MNPType: Mini program type
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPType: str
        :param _ApprovalUser: Approver
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApprovalUser: str
        :param _ApprovalTime: Approval time
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApprovalTime: str
        :param _ApprovalNote: Approval notes
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApprovalNote: str
        """
        self._ApprovalNo = None
        self._ApplicationId = None
        self._ApprovalStatus = None
        self._MNPId = None
        self._MNPVersion = None
        self._MNPVersionId = None
        self._ApplyUser = None
        self._ApplyTime = None
        self._MNPName = None
        self._MNPIcon = None
        self._ApplicationName = None
        self._ApplicationLogo = None
        self._TeamId = None
        self._TeamName = None
        self._MNPQrCodeUrl = None
        self._MNPType = None
        self._ApprovalUser = None
        self._ApprovalTime = None
        self._ApprovalNote = None

    @property
    def ApprovalNo(self):
        return self._ApprovalNo

    @ApprovalNo.setter
    def ApprovalNo(self, ApprovalNo):
        self._ApprovalNo = ApprovalNo

    @property
    def ApplicationId(self):
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def ApprovalStatus(self):
        return self._ApprovalStatus

    @ApprovalStatus.setter
    def ApprovalStatus(self, ApprovalStatus):
        self._ApprovalStatus = ApprovalStatus

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def MNPVersion(self):
        return self._MNPVersion

    @MNPVersion.setter
    def MNPVersion(self, MNPVersion):
        self._MNPVersion = MNPVersion

    @property
    def MNPVersionId(self):
        return self._MNPVersionId

    @MNPVersionId.setter
    def MNPVersionId(self, MNPVersionId):
        self._MNPVersionId = MNPVersionId

    @property
    def ApplyUser(self):
        return self._ApplyUser

    @ApplyUser.setter
    def ApplyUser(self, ApplyUser):
        self._ApplyUser = ApplyUser

    @property
    def ApplyTime(self):
        return self._ApplyTime

    @ApplyTime.setter
    def ApplyTime(self, ApplyTime):
        self._ApplyTime = ApplyTime

    @property
    def MNPName(self):
        return self._MNPName

    @MNPName.setter
    def MNPName(self, MNPName):
        self._MNPName = MNPName

    @property
    def MNPIcon(self):
        return self._MNPIcon

    @MNPIcon.setter
    def MNPIcon(self, MNPIcon):
        self._MNPIcon = MNPIcon

    @property
    def ApplicationName(self):
        return self._ApplicationName

    @ApplicationName.setter
    def ApplicationName(self, ApplicationName):
        self._ApplicationName = ApplicationName

    @property
    def ApplicationLogo(self):
        return self._ApplicationLogo

    @ApplicationLogo.setter
    def ApplicationLogo(self, ApplicationLogo):
        self._ApplicationLogo = ApplicationLogo

    @property
    def TeamId(self):
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId

    @property
    def TeamName(self):
        return self._TeamName

    @TeamName.setter
    def TeamName(self, TeamName):
        self._TeamName = TeamName

    @property
    def MNPQrCodeUrl(self):
        return self._MNPQrCodeUrl

    @MNPQrCodeUrl.setter
    def MNPQrCodeUrl(self, MNPQrCodeUrl):
        self._MNPQrCodeUrl = MNPQrCodeUrl

    @property
    def MNPType(self):
        return self._MNPType

    @MNPType.setter
    def MNPType(self, MNPType):
        self._MNPType = MNPType

    @property
    def ApprovalUser(self):
        return self._ApprovalUser

    @ApprovalUser.setter
    def ApprovalUser(self, ApprovalUser):
        self._ApprovalUser = ApprovalUser

    @property
    def ApprovalTime(self):
        return self._ApprovalTime

    @ApprovalTime.setter
    def ApprovalTime(self, ApprovalTime):
        self._ApprovalTime = ApprovalTime

    @property
    def ApprovalNote(self):
        return self._ApprovalNote

    @ApprovalNote.setter
    def ApprovalNote(self, ApprovalNote):
        self._ApprovalNote = ApprovalNote


    def _deserialize(self, params):
        self._ApprovalNo = params.get("ApprovalNo")
        self._ApplicationId = params.get("ApplicationId")
        self._ApprovalStatus = params.get("ApprovalStatus")
        self._MNPId = params.get("MNPId")
        self._MNPVersion = params.get("MNPVersion")
        self._MNPVersionId = params.get("MNPVersionId")
        self._ApplyUser = params.get("ApplyUser")
        self._ApplyTime = params.get("ApplyTime")
        self._MNPName = params.get("MNPName")
        self._MNPIcon = params.get("MNPIcon")
        self._ApplicationName = params.get("ApplicationName")
        self._ApplicationLogo = params.get("ApplicationLogo")
        self._TeamId = params.get("TeamId")
        self._TeamName = params.get("TeamName")
        self._MNPQrCodeUrl = params.get("MNPQrCodeUrl")
        self._MNPType = params.get("MNPType")
        self._ApprovalUser = params.get("ApprovalUser")
        self._ApprovalTime = params.get("ApprovalTime")
        self._ApprovalNote = params.get("ApprovalNote")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPApprovalListRequest(AbstractModel):
    """DescribeMNPApprovalList request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Page offset
        :type Offset: int
        :param _Limit: Number of results per page
        :type Limit: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _ApprovalStatusList: Approval status. 1: Processing; 2: Rejected; 3: Approved; 4 Cancelled
        :type ApprovalStatusList: list of int
        :param _Keyword: Keywords of the mini program name to search
        :type Keyword: str
        :param _ApplicationId: Application ID
        :type ApplicationId: str
        :param _TeamId: Team ID
        :type TeamId: str
        """
        self._Offset = None
        self._Limit = None
        self._PlatformId = None
        self._ApprovalStatusList = None
        self._Keyword = None
        self._ApplicationId = None
        self._TeamId = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def ApprovalStatusList(self):
        return self._ApprovalStatusList

    @ApprovalStatusList.setter
    def ApprovalStatusList(self, ApprovalStatusList):
        self._ApprovalStatusList = ApprovalStatusList

    @property
    def Keyword(self):
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword

    @property
    def ApplicationId(self):
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def TeamId(self):
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._PlatformId = params.get("PlatformId")
        self._ApprovalStatusList = params.get("ApprovalStatusList")
        self._Keyword = params.get("Keyword")
        self._ApplicationId = params.get("ApplicationId")
        self._TeamId = params.get("TeamId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPApprovalListResp(AbstractModel):
    """List of mini program approval requests of an application

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of entries
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _DataList: List information
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataList: list of DescribeMNPApprovalListData
        """
        self._TotalCount = None
        self._DataList = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DataList(self):
        return self._DataList

    @DataList.setter
    def DataList(self, DataList):
        self._DataList = DataList


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DataList") is not None:
            self._DataList = []
            for item in params.get("DataList"):
                obj = DescribeMNPApprovalListData()
                obj._deserialize(item)
                self._DataList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPApprovalListResponse(AbstractModel):
    """DescribeMNPApprovalList response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.DescribeMNPApprovalListResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeMNPApprovalListResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeMNPBoardRequest(AbstractModel):
    """DescribeMNPBoard request structure.

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._MNPId = None
        self._PlatformId = None

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPBoardResponse(AbstractModel):
    """DescribeMNPBoard response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: list of VersionBoardResp
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = VersionBoardResp()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeMNPCategoryRequest(AbstractModel):
    """DescribeMNPCategory request structure.

    """

    def __init__(self):
        r"""
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._PlatformId = None

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPCategoryResponse(AbstractModel):
    """DescribeMNPCategory response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: list of MNPTypeDefine
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = MNPTypeDefine()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeMNPDetailRequest(AbstractModel):
    """DescribeMNPDetail request structure.

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._MNPId = None
        self._PlatformId = None

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPDetailResponse(AbstractModel):
    """DescribeMNPDetail response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.MNPDetail`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = MNPDetail()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeMNPDomainACLRequest(AbstractModel):
    """DescribeMNPDomainACL request structure.

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._MNPId = None
        self._PlatformId = None

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPDomainACLResponse(AbstractModel):
    """DescribeMNPDomainACL response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: list of DescribeDomainInfoParam
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = DescribeDomainInfoParam()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeMNPListData(AbstractModel):
    """Mini program list

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _MNPIcon: Mini program icon
        :type MNPIcon: str
        :param _MNPName: Mini program name
        :type MNPName: str
        :param _TeamName: Name of the associated team
        :type TeamName: str
        :param _MNPType: Mini program type
        :type MNPType: str
        :param _Status: Whether the mini program is submitted to the application. 1: Submitted; 2: Removed
Note: This field may return null, indicating that no valid values can be obtained.
        :type Status: int
        :param _MNPIntro: Mini program introduction
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPIntro: str
        :param _CreateUser: Creator
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateUser: str
        :param _CreateTime: Creation time
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        :param _UpdateUser: Updater
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateUser: str
        :param _UpdateTime: Update time
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateTime: str
        :param _ApplicationName: Application name
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationName: str
        :param _EffectStatus: Effective status of the bound application. 1: Not effective; 2: Effective
Note: This field may return null, indicating that no valid values can be obtained.
        :type EffectStatus: int
        :param _EffectMNPVersionId: ID of the application bound with the mini program
Note: This field may return null, indicating that no valid values can be obtained.
        :type EffectMNPVersionId: int
        :param _EffectMNPVersion: Effective version number of the application that bound with the mini program
Note: This field may return null, indicating that no valid values can be obtained.
        :type EffectMNPVersion: str
        """
        self._MNPId = None
        self._MNPIcon = None
        self._MNPName = None
        self._TeamName = None
        self._MNPType = None
        self._Status = None
        self._MNPIntro = None
        self._CreateUser = None
        self._CreateTime = None
        self._UpdateUser = None
        self._UpdateTime = None
        self._ApplicationName = None
        self._EffectStatus = None
        self._EffectMNPVersionId = None
        self._EffectMNPVersion = None

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def MNPIcon(self):
        return self._MNPIcon

    @MNPIcon.setter
    def MNPIcon(self, MNPIcon):
        self._MNPIcon = MNPIcon

    @property
    def MNPName(self):
        return self._MNPName

    @MNPName.setter
    def MNPName(self, MNPName):
        self._MNPName = MNPName

    @property
    def TeamName(self):
        return self._TeamName

    @TeamName.setter
    def TeamName(self, TeamName):
        self._TeamName = TeamName

    @property
    def MNPType(self):
        return self._MNPType

    @MNPType.setter
    def MNPType(self, MNPType):
        self._MNPType = MNPType

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def MNPIntro(self):
        return self._MNPIntro

    @MNPIntro.setter
    def MNPIntro(self, MNPIntro):
        self._MNPIntro = MNPIntro

    @property
    def CreateUser(self):
        return self._CreateUser

    @CreateUser.setter
    def CreateUser(self, CreateUser):
        self._CreateUser = CreateUser

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateUser(self):
        return self._UpdateUser

    @UpdateUser.setter
    def UpdateUser(self, UpdateUser):
        self._UpdateUser = UpdateUser

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def ApplicationName(self):
        return self._ApplicationName

    @ApplicationName.setter
    def ApplicationName(self, ApplicationName):
        self._ApplicationName = ApplicationName

    @property
    def EffectStatus(self):
        return self._EffectStatus

    @EffectStatus.setter
    def EffectStatus(self, EffectStatus):
        self._EffectStatus = EffectStatus

    @property
    def EffectMNPVersionId(self):
        return self._EffectMNPVersionId

    @EffectMNPVersionId.setter
    def EffectMNPVersionId(self, EffectMNPVersionId):
        self._EffectMNPVersionId = EffectMNPVersionId

    @property
    def EffectMNPVersion(self):
        return self._EffectMNPVersion

    @EffectMNPVersion.setter
    def EffectMNPVersion(self, EffectMNPVersion):
        self._EffectMNPVersion = EffectMNPVersion


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._MNPIcon = params.get("MNPIcon")
        self._MNPName = params.get("MNPName")
        self._TeamName = params.get("TeamName")
        self._MNPType = params.get("MNPType")
        self._Status = params.get("Status")
        self._MNPIntro = params.get("MNPIntro")
        self._CreateUser = params.get("CreateUser")
        self._CreateTime = params.get("CreateTime")
        self._UpdateUser = params.get("UpdateUser")
        self._UpdateTime = params.get("UpdateTime")
        self._ApplicationName = params.get("ApplicationName")
        self._EffectStatus = params.get("EffectStatus")
        self._EffectMNPVersionId = params.get("EffectMNPVersionId")
        self._EffectMNPVersion = params.get("EffectMNPVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPListRequest(AbstractModel):
    """DescribeMNPList request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Page offset
        :type Offset: int
        :param _Limit: Number of results per page
        :type Limit: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _Keyword: Keywords for search (mini program name)
        :type Keyword: str
        :param _TeamId: Team ID
        :type TeamId: str
        :param _ApplicationId: Application ID
        :type ApplicationId: str
        """
        self._Offset = None
        self._Limit = None
        self._PlatformId = None
        self._Keyword = None
        self._TeamId = None
        self._ApplicationId = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def Keyword(self):
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword

    @property
    def TeamId(self):
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId

    @property
    def ApplicationId(self):
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._PlatformId = params.get("PlatformId")
        self._Keyword = params.get("Keyword")
        self._TeamId = params.get("TeamId")
        self._ApplicationId = params.get("ApplicationId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPListResp(AbstractModel):
    """Mini program list

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of entries
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _DataList: List information
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataList: list of DescribeMNPListData
        """
        self._TotalCount = None
        self._DataList = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DataList(self):
        return self._DataList

    @DataList.setter
    def DataList(self, DataList):
        self._DataList = DataList


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DataList") is not None:
            self._DataList = []
            for item in params.get("DataList"):
                obj = DescribeMNPListData()
                obj._deserialize(item)
                self._DataList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPListResponse(AbstractModel):
    """DescribeMNPList response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.DescribeMNPListResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeMNPListResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeMNPManagerDetailData(AbstractModel):
    """Mini program details

    """

    def __init__(self):
        r"""
        :param _MNPType: Mini program type 
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPType: str
        :param _MNPId: Mini program ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPId: str
        :param _MNPName: Mini program name
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPName: str
        :param _MNPIcon: Mini program icon
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPIcon: str
        :param _MNPIntro: Mini program introduction
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPIntro: str
        :param _MNPDesc: Mini program description
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPDesc: str
        :param _CreateTime: Timestamp of the creation time
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        :param _CreateUser: Creator
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateUser: str
        :param _AccessStatus: Connection status. 1: Not connected; 2: Connected
Note: This field may return null, indicating that no valid values can be obtained.
        :type AccessStatus: int
        :param _TeamName: The name of the associated team
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamName: str
        :param _TeamId: Team ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamId: str
        :param _Status: Mini program release status. 1: Released; 2: Removed
Note: This field may return null, indicating that no valid values can be obtained.
        :type Status: int
        """
        self._MNPType = None
        self._MNPId = None
        self._MNPName = None
        self._MNPIcon = None
        self._MNPIntro = None
        self._MNPDesc = None
        self._CreateTime = None
        self._CreateUser = None
        self._AccessStatus = None
        self._TeamName = None
        self._TeamId = None
        self._Status = None

    @property
    def MNPType(self):
        return self._MNPType

    @MNPType.setter
    def MNPType(self, MNPType):
        self._MNPType = MNPType

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def MNPName(self):
        return self._MNPName

    @MNPName.setter
    def MNPName(self, MNPName):
        self._MNPName = MNPName

    @property
    def MNPIcon(self):
        return self._MNPIcon

    @MNPIcon.setter
    def MNPIcon(self, MNPIcon):
        self._MNPIcon = MNPIcon

    @property
    def MNPIntro(self):
        return self._MNPIntro

    @MNPIntro.setter
    def MNPIntro(self, MNPIntro):
        self._MNPIntro = MNPIntro

    @property
    def MNPDesc(self):
        return self._MNPDesc

    @MNPDesc.setter
    def MNPDesc(self, MNPDesc):
        self._MNPDesc = MNPDesc

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def CreateUser(self):
        return self._CreateUser

    @CreateUser.setter
    def CreateUser(self, CreateUser):
        self._CreateUser = CreateUser

    @property
    def AccessStatus(self):
        return self._AccessStatus

    @AccessStatus.setter
    def AccessStatus(self, AccessStatus):
        self._AccessStatus = AccessStatus

    @property
    def TeamName(self):
        return self._TeamName

    @TeamName.setter
    def TeamName(self, TeamName):
        self._TeamName = TeamName

    @property
    def TeamId(self):
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._MNPType = params.get("MNPType")
        self._MNPId = params.get("MNPId")
        self._MNPName = params.get("MNPName")
        self._MNPIcon = params.get("MNPIcon")
        self._MNPIntro = params.get("MNPIntro")
        self._MNPDesc = params.get("MNPDesc")
        self._CreateTime = params.get("CreateTime")
        self._CreateUser = params.get("CreateUser")
        self._AccessStatus = params.get("AccessStatus")
        self._TeamName = params.get("TeamName")
        self._TeamId = params.get("TeamId")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPManagerDetailRequest(AbstractModel):
    """DescribeMNPManagerDetail request structure.

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._MNPId = None
        self._PlatformId = None

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPManagerDetailResponse(AbstractModel):
    """DescribeMNPManagerDetail response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.DescribeMNPManagerDetailData`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeMNPManagerDetailData()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeMNPManagerListData(AbstractModel):
    """Mini program management page list

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _MNPIcon: Mini program icon
        :type MNPIcon: str
        :param _MNPName: Mini program name
        :type MNPName: str
        :param _TeamName: Team name
        :type TeamName: str
        :param _AccessStatus: Access status 1-Not accessed 2-Accessed
        :type AccessStatus: int
        :param _Status: Mini program release status. 1: Released; 2: Removed
Note: This field may return null, indicating that no valid values can be obtained.
        :type Status: int
        """
        self._MNPId = None
        self._MNPIcon = None
        self._MNPName = None
        self._TeamName = None
        self._AccessStatus = None
        self._Status = None

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def MNPIcon(self):
        return self._MNPIcon

    @MNPIcon.setter
    def MNPIcon(self, MNPIcon):
        self._MNPIcon = MNPIcon

    @property
    def MNPName(self):
        return self._MNPName

    @MNPName.setter
    def MNPName(self, MNPName):
        self._MNPName = MNPName

    @property
    def TeamName(self):
        return self._TeamName

    @TeamName.setter
    def TeamName(self, TeamName):
        self._TeamName = TeamName

    @property
    def AccessStatus(self):
        return self._AccessStatus

    @AccessStatus.setter
    def AccessStatus(self, AccessStatus):
        self._AccessStatus = AccessStatus

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._MNPIcon = params.get("MNPIcon")
        self._MNPName = params.get("MNPName")
        self._TeamName = params.get("TeamName")
        self._AccessStatus = params.get("AccessStatus")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPManagerListRequest(AbstractModel):
    """DescribeMNPManagerList request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Page offset
        :type Offset: int
        :param _Limit: Number of results per page
        :type Limit: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _Keyword: Keywords for search (mini program name)
        :type Keyword: str
        :param _TeamId: Team ID
        :type TeamId: str
        """
        self._Offset = None
        self._Limit = None
        self._PlatformId = None
        self._Keyword = None
        self._TeamId = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def Keyword(self):
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword

    @property
    def TeamId(self):
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._PlatformId = params.get("PlatformId")
        self._Keyword = params.get("Keyword")
        self._TeamId = params.get("TeamId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPManagerListResp(AbstractModel):
    """Mini program list

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of entries
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _DataList: List information
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataList: list of DescribeMNPManagerListData
        """
        self._TotalCount = None
        self._DataList = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DataList(self):
        return self._DataList

    @DataList.setter
    def DataList(self, DataList):
        self._DataList = DataList


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DataList") is not None:
            self._DataList = []
            for item in params.get("DataList"):
                obj = DescribeMNPManagerListData()
                obj._deserialize(item)
                self._DataList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPManagerListResponse(AbstractModel):
    """DescribeMNPManagerList response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.DescribeMNPManagerListResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeMNPManagerListResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeMNPOfflinePackageURLRequest(AbstractModel):
    """DescribeMNPOfflinePackageURL request structure.

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._MNPId = None
        self._PlatformId = None

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPOfflinePackageURLResponse(AbstractModel):
    """DescribeMNPOfflinePackageURL response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.StringData`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = StringData()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeMNPPreviewRequest(AbstractModel):
    """DescribeMNPPreview request structure.

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _MNPVersionId: Mini program version ID
        :type MNPVersionId: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._MNPId = None
        self._MNPVersionId = None
        self._PlatformId = None

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def MNPVersionId(self):
        return self._MNPVersionId

    @MNPVersionId.setter
    def MNPVersionId(self, MNPVersionId):
        self._MNPVersionId = MNPVersionId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._MNPVersionId = params.get("MNPVersionId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPPreviewResp(AbstractModel):
    """Response of querying the preview version

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPId: str
        :param _MNPName: Mini program name
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPName: str
        :param _MNPDesc: Mini program description
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPDesc: str
        :param _MNPVersion: Mini program version
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPVersion: str
        :param _MNPVersionIntro: Mini program introduction
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPVersionIntro: str
        :param _QRCodeUrl: Mini program QR code
Note: This field may return null, indicating that no valid values can be obtained.
        :type QRCodeUrl: str
        :param _PreviewEntrancePath: Path to the preview version
Note: This field may return null, indicating that no valid values can be obtained.
        :type PreviewEntrancePath: str
        """
        self._MNPId = None
        self._MNPName = None
        self._MNPDesc = None
        self._MNPVersion = None
        self._MNPVersionIntro = None
        self._QRCodeUrl = None
        self._PreviewEntrancePath = None

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def MNPName(self):
        return self._MNPName

    @MNPName.setter
    def MNPName(self, MNPName):
        self._MNPName = MNPName

    @property
    def MNPDesc(self):
        return self._MNPDesc

    @MNPDesc.setter
    def MNPDesc(self, MNPDesc):
        self._MNPDesc = MNPDesc

    @property
    def MNPVersion(self):
        return self._MNPVersion

    @MNPVersion.setter
    def MNPVersion(self, MNPVersion):
        self._MNPVersion = MNPVersion

    @property
    def MNPVersionIntro(self):
        return self._MNPVersionIntro

    @MNPVersionIntro.setter
    def MNPVersionIntro(self, MNPVersionIntro):
        self._MNPVersionIntro = MNPVersionIntro

    @property
    def QRCodeUrl(self):
        return self._QRCodeUrl

    @QRCodeUrl.setter
    def QRCodeUrl(self, QRCodeUrl):
        self._QRCodeUrl = QRCodeUrl

    @property
    def PreviewEntrancePath(self):
        return self._PreviewEntrancePath

    @PreviewEntrancePath.setter
    def PreviewEntrancePath(self, PreviewEntrancePath):
        self._PreviewEntrancePath = PreviewEntrancePath


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._MNPName = params.get("MNPName")
        self._MNPDesc = params.get("MNPDesc")
        self._MNPVersion = params.get("MNPVersion")
        self._MNPVersionIntro = params.get("MNPVersionIntro")
        self._QRCodeUrl = params.get("QRCodeUrl")
        self._PreviewEntrancePath = params.get("PreviewEntrancePath")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPPreviewResponse(AbstractModel):
    """DescribeMNPPreview response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.DescribeMNPPreviewResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeMNPPreviewResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeMNPPrivacyRequest(AbstractModel):
    """DescribeMNPPrivacy request structure.

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._MNPId = None
        self._PlatformId = None

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPPrivacyResponse(AbstractModel):
    """DescribeMNPPrivacy response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DescribeMNPReleasedVersionHistoryRequest(AbstractModel):
    """DescribeMNPReleasedVersionHistory request structure.

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._MNPId = None
        self._PlatformId = None

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPReleasedVersionHistoryResponse(AbstractModel):
    """DescribeMNPReleasedVersionHistory response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.DescribeRevertOnlineVersionPageResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeRevertOnlineVersionPageResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeMNPRequest(AbstractModel):
    """DescribeMNP request structure.

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._MNPId = None
        self._PlatformId = None

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPResponse(AbstractModel):
    """DescribeMNP response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.DescribeMNPManagerDetailData`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeMNPManagerDetailData()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeMNPSensitiveAPIPermissionApprovalData(AbstractModel):
    """Details of a permission request to allow a mini program calling sensitive APIs

    """

    def __init__(self):
        r"""
        :param _APIId: API ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type APIId: str
        :param _APIMethod: API request method
Note: This field may return null, indicating that no valid values can be obtained.
        :type APIMethod: str
        :param _ApplyReason: Reason for the request
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplyReason: str
        :param _RejectReason: Reason for rejection
Note: This field may return null, indicating that no valid values can be obtained.
        :type RejectReason: str
        :param _ApprovalStatus: Approval status. 20: Rejected; 30: Approved
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApprovalStatus: int
        :param _APIDesc: API feature description
Note: This field may return null, indicating that no valid values can be obtained.
        :type APIDesc: str
        :param _APIType: API type. 1: System; 2: Custom
Note: This field may return null, indicating that no valid values can be obtained.
        :type APIType: int
        """
        self._APIId = None
        self._APIMethod = None
        self._ApplyReason = None
        self._RejectReason = None
        self._ApprovalStatus = None
        self._APIDesc = None
        self._APIType = None

    @property
    def APIId(self):
        return self._APIId

    @APIId.setter
    def APIId(self, APIId):
        self._APIId = APIId

    @property
    def APIMethod(self):
        return self._APIMethod

    @APIMethod.setter
    def APIMethod(self, APIMethod):
        self._APIMethod = APIMethod

    @property
    def ApplyReason(self):
        return self._ApplyReason

    @ApplyReason.setter
    def ApplyReason(self, ApplyReason):
        self._ApplyReason = ApplyReason

    @property
    def RejectReason(self):
        return self._RejectReason

    @RejectReason.setter
    def RejectReason(self, RejectReason):
        self._RejectReason = RejectReason

    @property
    def ApprovalStatus(self):
        return self._ApprovalStatus

    @ApprovalStatus.setter
    def ApprovalStatus(self, ApprovalStatus):
        self._ApprovalStatus = ApprovalStatus

    @property
    def APIDesc(self):
        return self._APIDesc

    @APIDesc.setter
    def APIDesc(self, APIDesc):
        self._APIDesc = APIDesc

    @property
    def APIType(self):
        return self._APIType

    @APIType.setter
    def APIType(self, APIType):
        self._APIType = APIType


    def _deserialize(self, params):
        self._APIId = params.get("APIId")
        self._APIMethod = params.get("APIMethod")
        self._ApplyReason = params.get("ApplyReason")
        self._RejectReason = params.get("RejectReason")
        self._ApprovalStatus = params.get("ApprovalStatus")
        self._APIDesc = params.get("APIDesc")
        self._APIType = params.get("APIType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPSensitiveAPIPermissionApprovalListData(AbstractModel):
    """List of permission requests to allow a mini program calling sensitive APIs

    """

    def __init__(self):
        r"""
        :param _ApprovalNo: Approval ID
        :type ApprovalNo: str
        :param _APIId: Sensitive API ID
        :type APIId: str
        :param _APIName: API name
        :type APIName: str
        :param _APIMethod: API request method
        :type APIMethod: str
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _MNPName: Mini program name
        :type MNPName: str
        :param _ApplyUser: Applicant
        :type ApplyUser: str
        :param _ApplyTime: Application time
        :type ApplyTime: str
        :param _ApplyNote: Application notes
        :type ApplyNote: str
        :param _ApprovalStatus: Approval status. 1: Processing; 20: Rejected; 30: Approved
        :type ApprovalStatus: int
        :param _ApprovalUser: Approver
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApprovalUser: str
        :param _ApprovalTime: Approval time
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApprovalTime: str
        :param _ApprovalNote: Approval notes
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApprovalNote: str
        :param _ApplicationId: Application ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationId: str
        :param _ApplicationName: Application name
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationName: str
        :param _ApplicationLogo: Application icon
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationLogo: str
        :param _APIType: API type. 1: System; 2: Custom
Note: This field may return null, indicating that no valid values can be obtained.
        :type APIType: int
        :param _APIDesc: API feature description
Note: This field may return null, indicating that no valid values can be obtained.
        :type APIDesc: str
        """
        self._ApprovalNo = None
        self._APIId = None
        self._APIName = None
        self._APIMethod = None
        self._MNPId = None
        self._MNPName = None
        self._ApplyUser = None
        self._ApplyTime = None
        self._ApplyNote = None
        self._ApprovalStatus = None
        self._ApprovalUser = None
        self._ApprovalTime = None
        self._ApprovalNote = None
        self._ApplicationId = None
        self._ApplicationName = None
        self._ApplicationLogo = None
        self._APIType = None
        self._APIDesc = None

    @property
    def ApprovalNo(self):
        return self._ApprovalNo

    @ApprovalNo.setter
    def ApprovalNo(self, ApprovalNo):
        self._ApprovalNo = ApprovalNo

    @property
    def APIId(self):
        return self._APIId

    @APIId.setter
    def APIId(self, APIId):
        self._APIId = APIId

    @property
    def APIName(self):
        return self._APIName

    @APIName.setter
    def APIName(self, APIName):
        self._APIName = APIName

    @property
    def APIMethod(self):
        return self._APIMethod

    @APIMethod.setter
    def APIMethod(self, APIMethod):
        self._APIMethod = APIMethod

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def MNPName(self):
        return self._MNPName

    @MNPName.setter
    def MNPName(self, MNPName):
        self._MNPName = MNPName

    @property
    def ApplyUser(self):
        return self._ApplyUser

    @ApplyUser.setter
    def ApplyUser(self, ApplyUser):
        self._ApplyUser = ApplyUser

    @property
    def ApplyTime(self):
        return self._ApplyTime

    @ApplyTime.setter
    def ApplyTime(self, ApplyTime):
        self._ApplyTime = ApplyTime

    @property
    def ApplyNote(self):
        return self._ApplyNote

    @ApplyNote.setter
    def ApplyNote(self, ApplyNote):
        self._ApplyNote = ApplyNote

    @property
    def ApprovalStatus(self):
        return self._ApprovalStatus

    @ApprovalStatus.setter
    def ApprovalStatus(self, ApprovalStatus):
        self._ApprovalStatus = ApprovalStatus

    @property
    def ApprovalUser(self):
        return self._ApprovalUser

    @ApprovalUser.setter
    def ApprovalUser(self, ApprovalUser):
        self._ApprovalUser = ApprovalUser

    @property
    def ApprovalTime(self):
        return self._ApprovalTime

    @ApprovalTime.setter
    def ApprovalTime(self, ApprovalTime):
        self._ApprovalTime = ApprovalTime

    @property
    def ApprovalNote(self):
        return self._ApprovalNote

    @ApprovalNote.setter
    def ApprovalNote(self, ApprovalNote):
        self._ApprovalNote = ApprovalNote

    @property
    def ApplicationId(self):
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def ApplicationName(self):
        return self._ApplicationName

    @ApplicationName.setter
    def ApplicationName(self, ApplicationName):
        self._ApplicationName = ApplicationName

    @property
    def ApplicationLogo(self):
        return self._ApplicationLogo

    @ApplicationLogo.setter
    def ApplicationLogo(self, ApplicationLogo):
        self._ApplicationLogo = ApplicationLogo

    @property
    def APIType(self):
        return self._APIType

    @APIType.setter
    def APIType(self, APIType):
        self._APIType = APIType

    @property
    def APIDesc(self):
        return self._APIDesc

    @APIDesc.setter
    def APIDesc(self, APIDesc):
        self._APIDesc = APIDesc


    def _deserialize(self, params):
        self._ApprovalNo = params.get("ApprovalNo")
        self._APIId = params.get("APIId")
        self._APIName = params.get("APIName")
        self._APIMethod = params.get("APIMethod")
        self._MNPId = params.get("MNPId")
        self._MNPName = params.get("MNPName")
        self._ApplyUser = params.get("ApplyUser")
        self._ApplyTime = params.get("ApplyTime")
        self._ApplyNote = params.get("ApplyNote")
        self._ApprovalStatus = params.get("ApprovalStatus")
        self._ApprovalUser = params.get("ApprovalUser")
        self._ApprovalTime = params.get("ApprovalTime")
        self._ApprovalNote = params.get("ApprovalNote")
        self._ApplicationId = params.get("ApplicationId")
        self._ApplicationName = params.get("ApplicationName")
        self._ApplicationLogo = params.get("ApplicationLogo")
        self._APIType = params.get("APIType")
        self._APIDesc = params.get("APIDesc")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPSensitiveAPIPermissionApprovalListRequest(AbstractModel):
    """DescribeMNPSensitiveAPIPermissionApprovalList request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Page offset
        :type Offset: int
        :param _Limit: Number of results per page
        :type Limit: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _ApprovalStatusList: Approval status. 1: Processing; 20: Rejected; 30: Approved
        :type ApprovalStatusList: list of int
        :param _Keyword: Keywords for search (API name, API method or application name)
        :type Keyword: str
        """
        self._Offset = None
        self._Limit = None
        self._PlatformId = None
        self._ApprovalStatusList = None
        self._Keyword = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def ApprovalStatusList(self):
        return self._ApprovalStatusList

    @ApprovalStatusList.setter
    def ApprovalStatusList(self, ApprovalStatusList):
        self._ApprovalStatusList = ApprovalStatusList

    @property
    def Keyword(self):
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._PlatformId = params.get("PlatformId")
        self._ApprovalStatusList = params.get("ApprovalStatusList")
        self._Keyword = params.get("Keyword")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPSensitiveAPIPermissionApprovalListResp(AbstractModel):
    """List of permission requests to allow a mini program calling sensitive APIs

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of entries
        :type TotalCount: int
        :param _DataList: List information
        :type DataList: list of DescribeMNPSensitiveAPIPermissionApprovalListData
        """
        self._TotalCount = None
        self._DataList = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DataList(self):
        return self._DataList

    @DataList.setter
    def DataList(self, DataList):
        self._DataList = DataList


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DataList") is not None:
            self._DataList = []
            for item in params.get("DataList"):
                obj = DescribeMNPSensitiveAPIPermissionApprovalListData()
                obj._deserialize(item)
                self._DataList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPSensitiveAPIPermissionApprovalListResponse(AbstractModel):
    """DescribeMNPSensitiveAPIPermissionApprovalList response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.DescribeMNPSensitiveAPIPermissionApprovalListResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeMNPSensitiveAPIPermissionApprovalListResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeMNPSensitiveAPIPermissionApprovalRequest(AbstractModel):
    """DescribeMNPSensitiveAPIPermissionApproval request structure.

    """

    def __init__(self):
        r"""
        :param _ApprovalNo: Approval request number
        :type ApprovalNo: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._ApprovalNo = None
        self._PlatformId = None

    @property
    def ApprovalNo(self):
        return self._ApprovalNo

    @ApprovalNo.setter
    def ApprovalNo(self, ApprovalNo):
        self._ApprovalNo = ApprovalNo

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._ApprovalNo = params.get("ApprovalNo")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPSensitiveAPIPermissionApprovalResponse(AbstractModel):
    """DescribeMNPSensitiveAPIPermissionApproval response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.DescribeMNPSensitiveAPIPermissionApprovalData`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeMNPSensitiveAPIPermissionApprovalData()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeMNPSensitiveAPIPermissionListData(AbstractModel):
    """List of sensitive APIs that can be called by a mini program

    """

    def __init__(self):
        r"""
        :param _APIId: API ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type APIId: str
        :param _APIName: API name
Note: This field may return null, indicating that no valid values can be obtained.
        :type APIName: str
        :param _APIMethod: API request method
Note: This field may return null, indicating that no valid values can be obtained.
        :type APIMethod: str
        :param _APIStatus: API status
Note: This field may return null, indicating that no valid values can be obtained.
        :type APIStatus: int
        :param _APIApplyStatus: API application status
Note: This field may return null, indicating that no valid values can be obtained.
        :type APIApplyStatus: int
        :param _RejectReason: Reason for rejection
Note: This field may return null, indicating that no valid values can be obtained.
        :type RejectReason: str
        :param _ApprovalNo: Approval ID
        :type ApprovalNo: str
        :param _ApplicationId: Application ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationId: str
        :param _ApplicationIcon: Application icon
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationIcon: str
        :param _ApplicationName: Application name
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationName: str
        :param _APIType: API type. 1: System; 2: Custom
Note: This field may return null, indicating that no valid values can be obtained.
        :type APIType: int
        :param _APIDesc: API feature description
Note: This field may return null, indicating that no valid values can be obtained.
        :type APIDesc: str
        """
        self._APIId = None
        self._APIName = None
        self._APIMethod = None
        self._APIStatus = None
        self._APIApplyStatus = None
        self._RejectReason = None
        self._ApprovalNo = None
        self._ApplicationId = None
        self._ApplicationIcon = None
        self._ApplicationName = None
        self._APIType = None
        self._APIDesc = None

    @property
    def APIId(self):
        return self._APIId

    @APIId.setter
    def APIId(self, APIId):
        self._APIId = APIId

    @property
    def APIName(self):
        return self._APIName

    @APIName.setter
    def APIName(self, APIName):
        self._APIName = APIName

    @property
    def APIMethod(self):
        return self._APIMethod

    @APIMethod.setter
    def APIMethod(self, APIMethod):
        self._APIMethod = APIMethod

    @property
    def APIStatus(self):
        return self._APIStatus

    @APIStatus.setter
    def APIStatus(self, APIStatus):
        self._APIStatus = APIStatus

    @property
    def APIApplyStatus(self):
        return self._APIApplyStatus

    @APIApplyStatus.setter
    def APIApplyStatus(self, APIApplyStatus):
        self._APIApplyStatus = APIApplyStatus

    @property
    def RejectReason(self):
        return self._RejectReason

    @RejectReason.setter
    def RejectReason(self, RejectReason):
        self._RejectReason = RejectReason

    @property
    def ApprovalNo(self):
        return self._ApprovalNo

    @ApprovalNo.setter
    def ApprovalNo(self, ApprovalNo):
        self._ApprovalNo = ApprovalNo

    @property
    def ApplicationId(self):
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def ApplicationIcon(self):
        return self._ApplicationIcon

    @ApplicationIcon.setter
    def ApplicationIcon(self, ApplicationIcon):
        self._ApplicationIcon = ApplicationIcon

    @property
    def ApplicationName(self):
        return self._ApplicationName

    @ApplicationName.setter
    def ApplicationName(self, ApplicationName):
        self._ApplicationName = ApplicationName

    @property
    def APIType(self):
        return self._APIType

    @APIType.setter
    def APIType(self, APIType):
        self._APIType = APIType

    @property
    def APIDesc(self):
        return self._APIDesc

    @APIDesc.setter
    def APIDesc(self, APIDesc):
        self._APIDesc = APIDesc


    def _deserialize(self, params):
        self._APIId = params.get("APIId")
        self._APIName = params.get("APIName")
        self._APIMethod = params.get("APIMethod")
        self._APIStatus = params.get("APIStatus")
        self._APIApplyStatus = params.get("APIApplyStatus")
        self._RejectReason = params.get("RejectReason")
        self._ApprovalNo = params.get("ApprovalNo")
        self._ApplicationId = params.get("ApplicationId")
        self._ApplicationIcon = params.get("ApplicationIcon")
        self._ApplicationName = params.get("ApplicationName")
        self._APIType = params.get("APIType")
        self._APIDesc = params.get("APIDesc")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPSensitiveAPIPermissionListRequest(AbstractModel):
    """DescribeMNPSensitiveAPIPermissionList request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Page offset
        :type Offset: int
        :param _Limit: Number of results per page
        :type Limit: int
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _ApplicationId: Application ID
        :type ApplicationId: str
        :param _Keyword: Keywords for search (API name)
        :type Keyword: str
        """
        self._Offset = None
        self._Limit = None
        self._MNPId = None
        self._PlatformId = None
        self._ApplicationId = None
        self._Keyword = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def ApplicationId(self):
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def Keyword(self):
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._MNPId = params.get("MNPId")
        self._PlatformId = params.get("PlatformId")
        self._ApplicationId = params.get("ApplicationId")
        self._Keyword = params.get("Keyword")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPSensitiveAPIPermissionListResp(AbstractModel):
    """List of sensitive APIs that can be called by a mini program

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of entries
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _DataList: List data
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataList: list of DescribeMNPSensitiveAPIPermissionListData
        """
        self._TotalCount = None
        self._DataList = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DataList(self):
        return self._DataList

    @DataList.setter
    def DataList(self, DataList):
        self._DataList = DataList


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DataList") is not None:
            self._DataList = []
            for item in params.get("DataList"):
                obj = DescribeMNPSensitiveAPIPermissionListData()
                obj._deserialize(item)
                self._DataList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPSensitiveAPIPermissionListResponse(AbstractModel):
    """DescribeMNPSensitiveAPIPermissionList response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response parameters
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.DescribeMNPSensitiveAPIPermissionListResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeMNPSensitiveAPIPermissionListResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeMNPTypeRequest(AbstractModel):
    """DescribeMNPType request structure.

    """

    def __init__(self):
        r"""
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._PlatformId = None

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPTypeResponse(AbstractModel):
    """DescribeMNPType response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: list of MNPTypeDefine
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = MNPTypeDefine()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeMNPVersionCompileTaskExtInfo(AbstractModel):
    """Additional compilation task info

    """

    def __init__(self):
        r"""
        :param _TCMPPErrMsg: TCMPP error message
Note: This field may return null, indicating that no valid values can be obtained.
        :type TCMPPErrMsg: str
        :param _WXErrMsg: WX Error Message
Note: This field may return null, indicating that no valid values can be obtained.
        :type WXErrMsg: str
        :param _WXQrCode: WeChat QR code
Note: This field may return null, indicating that no valid values can be obtained.
        :type WXQrCode: str
        :param _SizeInfo: Compile size Information
Note: This field may return null, indicating that no valid values can be obtained.
        :type SizeInfo: str
        """
        self._TCMPPErrMsg = None
        self._WXErrMsg = None
        self._WXQrCode = None
        self._SizeInfo = None

    @property
    def TCMPPErrMsg(self):
        return self._TCMPPErrMsg

    @TCMPPErrMsg.setter
    def TCMPPErrMsg(self, TCMPPErrMsg):
        self._TCMPPErrMsg = TCMPPErrMsg

    @property
    def WXErrMsg(self):
        return self._WXErrMsg

    @WXErrMsg.setter
    def WXErrMsg(self, WXErrMsg):
        self._WXErrMsg = WXErrMsg

    @property
    def WXQrCode(self):
        return self._WXQrCode

    @WXQrCode.setter
    def WXQrCode(self, WXQrCode):
        self._WXQrCode = WXQrCode

    @property
    def SizeInfo(self):
        return self._SizeInfo

    @SizeInfo.setter
    def SizeInfo(self, SizeInfo):
        self._SizeInfo = SizeInfo


    def _deserialize(self, params):
        self._TCMPPErrMsg = params.get("TCMPPErrMsg")
        self._WXErrMsg = params.get("WXErrMsg")
        self._WXQrCode = params.get("WXQrCode")
        self._SizeInfo = params.get("SizeInfo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPVersionCompileTaskResp(AbstractModel):
    """Task details

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPId: str
        :param _TaskId: Task ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type TaskId: str
        :param _TaskStatus: 1: Pending; 20: Running; 30: Failed; 60: Succeeded 
Note: This field may return null, indicating that no valid values can be obtained.
        :type TaskStatus: int
        :param _TaskMsg: Task status message
Note: This field may return null, indicating that no valid values can be obtained.
        :type TaskMsg: str
        :param _QrCodeUrl: QR code address
Note: This field may return null, indicating that no valid values can be obtained.
        :type QrCodeUrl: str
        :param _PkgSize: Packet size
Note: This field may return null, indicating that no valid values can be obtained.
        :type PkgSize: int
        :param _SubPkgInfos: Subpackage information
Note: This field may return null, indicating that no valid values can be obtained.
        :type SubPkgInfos: list of DescribeMNPVersionCompileTaskSubSimpleInfo
        :param _QrCodeContent: QR code content
Note: This field may return null, indicating that no valid values can be obtained.
        :type QrCodeContent: str
        :param _ExtInfo: Additional information
Note: This field may return null, indicating that no valid values can be obtained.
        :type ExtInfo: :class:`tencentcloud.tcmpp.v20240801.models.DescribeMNPVersionCompileTaskExtInfo`
        """
        self._MNPId = None
        self._TaskId = None
        self._TaskStatus = None
        self._TaskMsg = None
        self._QrCodeUrl = None
        self._PkgSize = None
        self._SubPkgInfos = None
        self._QrCodeContent = None
        self._ExtInfo = None

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TaskStatus(self):
        return self._TaskStatus

    @TaskStatus.setter
    def TaskStatus(self, TaskStatus):
        self._TaskStatus = TaskStatus

    @property
    def TaskMsg(self):
        return self._TaskMsg

    @TaskMsg.setter
    def TaskMsg(self, TaskMsg):
        self._TaskMsg = TaskMsg

    @property
    def QrCodeUrl(self):
        return self._QrCodeUrl

    @QrCodeUrl.setter
    def QrCodeUrl(self, QrCodeUrl):
        self._QrCodeUrl = QrCodeUrl

    @property
    def PkgSize(self):
        return self._PkgSize

    @PkgSize.setter
    def PkgSize(self, PkgSize):
        self._PkgSize = PkgSize

    @property
    def SubPkgInfos(self):
        return self._SubPkgInfos

    @SubPkgInfos.setter
    def SubPkgInfos(self, SubPkgInfos):
        self._SubPkgInfos = SubPkgInfos

    @property
    def QrCodeContent(self):
        return self._QrCodeContent

    @QrCodeContent.setter
    def QrCodeContent(self, QrCodeContent):
        self._QrCodeContent = QrCodeContent

    @property
    def ExtInfo(self):
        return self._ExtInfo

    @ExtInfo.setter
    def ExtInfo(self, ExtInfo):
        self._ExtInfo = ExtInfo


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._TaskId = params.get("TaskId")
        self._TaskStatus = params.get("TaskStatus")
        self._TaskMsg = params.get("TaskMsg")
        self._QrCodeUrl = params.get("QrCodeUrl")
        self._PkgSize = params.get("PkgSize")
        if params.get("SubPkgInfos") is not None:
            self._SubPkgInfos = []
            for item in params.get("SubPkgInfos"):
                obj = DescribeMNPVersionCompileTaskSubSimpleInfo()
                obj._deserialize(item)
                self._SubPkgInfos.append(obj)
        self._QrCodeContent = params.get("QrCodeContent")
        if params.get("ExtInfo") is not None:
            self._ExtInfo = DescribeMNPVersionCompileTaskExtInfo()
            self._ExtInfo._deserialize(params.get("ExtInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPVersionCompileTaskSubSimpleInfo(AbstractModel):
    """Information of the subpackage built in a compiling task

    """

    def __init__(self):
        r"""
        :param _PkgName: Name
Note: This field may return null, indicating that no valid values can be obtained.
        :type PkgName: str
        :param _PathPrefix: Prefix of the package name
Note: This field may return null, indicating that no valid values can be obtained.
        :type PathPrefix: str
        :param _PkgSize: Package size in bytes
Note: This field may return null, indicating that no valid values can be obtained.
        :type PkgSize: int
        """
        self._PkgName = None
        self._PathPrefix = None
        self._PkgSize = None

    @property
    def PkgName(self):
        return self._PkgName

    @PkgName.setter
    def PkgName(self, PkgName):
        self._PkgName = PkgName

    @property
    def PathPrefix(self):
        return self._PathPrefix

    @PathPrefix.setter
    def PathPrefix(self, PathPrefix):
        self._PathPrefix = PathPrefix

    @property
    def PkgSize(self):
        return self._PkgSize

    @PkgSize.setter
    def PkgSize(self, PkgSize):
        self._PkgSize = PkgSize


    def _deserialize(self, params):
        self._PkgName = params.get("PkgName")
        self._PathPrefix = params.get("PathPrefix")
        self._PkgSize = params.get("PkgSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPVersionPreviewRequest(AbstractModel):
    """DescribeMNPVersionPreview request structure.

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _MNPVersionId: Mini program version ID
        :type MNPVersionId: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._MNPId = None
        self._MNPVersionId = None
        self._PlatformId = None

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def MNPVersionId(self):
        return self._MNPVersionId

    @MNPVersionId.setter
    def MNPVersionId(self, MNPVersionId):
        self._MNPVersionId = MNPVersionId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._MNPVersionId = params.get("MNPVersionId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPVersionPreviewResponse(AbstractModel):
    """DescribeMNPVersionPreview response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.DescribeShowCaseResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeShowCaseResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeMNPVersionRequest(AbstractModel):
    """DescribeMNPVersion request structure.

    """

    def __init__(self):
        r"""
        :param _BusinessId: ID of the task to create a mini program version
        :type BusinessId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._BusinessId = None
        self._PlatformId = None

    @property
    def BusinessId(self):
        return self._BusinessId

    @BusinessId.setter
    def BusinessId(self, BusinessId):
        self._BusinessId = BusinessId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._BusinessId = params.get("BusinessId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPVersionResp(AbstractModel):
    """Result of the task to create a mini program version

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPId: str
        :param _TaskId: Task ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type TaskId: str
        :param _TaskStatus: 1: Pending; 20: Running; 30: Failed; 60: Succeeded 
Note: This field may return null, indicating that no valid values can be obtained.
        :type TaskStatus: int
        :param _TaskMsg: Task status message
Note: This field may return null, indicating that no valid values can be obtained.
        :type TaskMsg: str
        """
        self._MNPId = None
        self._TaskId = None
        self._TaskStatus = None
        self._TaskMsg = None

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TaskStatus(self):
        return self._TaskStatus

    @TaskStatus.setter
    def TaskStatus(self, TaskStatus):
        self._TaskStatus = TaskStatus

    @property
    def TaskMsg(self):
        return self._TaskMsg

    @TaskMsg.setter
    def TaskMsg(self, TaskMsg):
        self._TaskMsg = TaskMsg


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._TaskId = params.get("TaskId")
        self._TaskStatus = params.get("TaskStatus")
        self._TaskMsg = params.get("TaskMsg")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMNPVersionResponse(AbstractModel):
    """DescribeMNPVersion response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.DescribeMNPVersionResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeMNPVersionResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeMPAllStageVersionsResp(AbstractModel):
    """List of all Developer versions of a mini program

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPId: str
        :param _MNPVersionId: Mini program version ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPVersionId: int
        :param _MNPName: Mini program name
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPName: str
        :param _MNPIcon: Mini program icon
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPIcon: str
        :param _MNPType: Mini program type
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPType: str
        :param _MNPIntro: Mini program introduction
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPIntro: str
        :param _MNPDesc: Mini program description
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPDesc: str
        :param _CreateUser: Developer
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateUser: str
        :param _CreateTime: The time when the developer created it
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        :param _MNPVersion: Mini program version
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPVersion: str
        :param _MNPVersionIntro: Version features
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPVersionIntro: str
        :param _Phase: Phase. Values: [Develop,Platform,Online]
Note: This field may return null, indicating that no valid values can be obtained.
        :type Phase: str
        :param _ApprovalStatus: 0: Pending; 1: Processing; 2: Rejected; 3: Approved; 4: Cancelled
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApprovalStatus: int
        :param _ApprovalNo: Approval request ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApprovalNo: str
        :param _ShowCase: Whether it is a preview version. 
0: Not a preview version; 1: Preview version
Note: This field may return null, indicating that no valid values can be obtained.
        :type ShowCase: int
        :param _RollbackVersion: Version number to roll back to
Note: This field may return null, indicating that no valid values can be obtained.
        :type RollbackVersion: int
        :param _Status: Release status
Note: This field may return null, indicating that no valid values can be obtained.
        :type Status: int
        :param _VersionCurrentStatus: Version approval status. 0: Pending; 1: Processing; 2: Rejected; 3: Approved; 4: Cancelled
Note: This field may return null, indicating that no valid values can be obtained.
        :type VersionCurrentStatus: int
        """
        self._MNPId = None
        self._MNPVersionId = None
        self._MNPName = None
        self._MNPIcon = None
        self._MNPType = None
        self._MNPIntro = None
        self._MNPDesc = None
        self._CreateUser = None
        self._CreateTime = None
        self._MNPVersion = None
        self._MNPVersionIntro = None
        self._Phase = None
        self._ApprovalStatus = None
        self._ApprovalNo = None
        self._ShowCase = None
        self._RollbackVersion = None
        self._Status = None
        self._VersionCurrentStatus = None

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def MNPVersionId(self):
        return self._MNPVersionId

    @MNPVersionId.setter
    def MNPVersionId(self, MNPVersionId):
        self._MNPVersionId = MNPVersionId

    @property
    def MNPName(self):
        return self._MNPName

    @MNPName.setter
    def MNPName(self, MNPName):
        self._MNPName = MNPName

    @property
    def MNPIcon(self):
        return self._MNPIcon

    @MNPIcon.setter
    def MNPIcon(self, MNPIcon):
        self._MNPIcon = MNPIcon

    @property
    def MNPType(self):
        return self._MNPType

    @MNPType.setter
    def MNPType(self, MNPType):
        self._MNPType = MNPType

    @property
    def MNPIntro(self):
        return self._MNPIntro

    @MNPIntro.setter
    def MNPIntro(self, MNPIntro):
        self._MNPIntro = MNPIntro

    @property
    def MNPDesc(self):
        return self._MNPDesc

    @MNPDesc.setter
    def MNPDesc(self, MNPDesc):
        self._MNPDesc = MNPDesc

    @property
    def CreateUser(self):
        return self._CreateUser

    @CreateUser.setter
    def CreateUser(self, CreateUser):
        self._CreateUser = CreateUser

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def MNPVersion(self):
        return self._MNPVersion

    @MNPVersion.setter
    def MNPVersion(self, MNPVersion):
        self._MNPVersion = MNPVersion

    @property
    def MNPVersionIntro(self):
        return self._MNPVersionIntro

    @MNPVersionIntro.setter
    def MNPVersionIntro(self, MNPVersionIntro):
        self._MNPVersionIntro = MNPVersionIntro

    @property
    def Phase(self):
        return self._Phase

    @Phase.setter
    def Phase(self, Phase):
        self._Phase = Phase

    @property
    def ApprovalStatus(self):
        return self._ApprovalStatus

    @ApprovalStatus.setter
    def ApprovalStatus(self, ApprovalStatus):
        self._ApprovalStatus = ApprovalStatus

    @property
    def ApprovalNo(self):
        return self._ApprovalNo

    @ApprovalNo.setter
    def ApprovalNo(self, ApprovalNo):
        self._ApprovalNo = ApprovalNo

    @property
    def ShowCase(self):
        return self._ShowCase

    @ShowCase.setter
    def ShowCase(self, ShowCase):
        self._ShowCase = ShowCase

    @property
    def RollbackVersion(self):
        return self._RollbackVersion

    @RollbackVersion.setter
    def RollbackVersion(self, RollbackVersion):
        self._RollbackVersion = RollbackVersion

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def VersionCurrentStatus(self):
        return self._VersionCurrentStatus

    @VersionCurrentStatus.setter
    def VersionCurrentStatus(self, VersionCurrentStatus):
        self._VersionCurrentStatus = VersionCurrentStatus


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._MNPVersionId = params.get("MNPVersionId")
        self._MNPName = params.get("MNPName")
        self._MNPIcon = params.get("MNPIcon")
        self._MNPType = params.get("MNPType")
        self._MNPIntro = params.get("MNPIntro")
        self._MNPDesc = params.get("MNPDesc")
        self._CreateUser = params.get("CreateUser")
        self._CreateTime = params.get("CreateTime")
        self._MNPVersion = params.get("MNPVersion")
        self._MNPVersionIntro = params.get("MNPVersionIntro")
        self._Phase = params.get("Phase")
        self._ApprovalStatus = params.get("ApprovalStatus")
        self._ApprovalNo = params.get("ApprovalNo")
        self._ShowCase = params.get("ShowCase")
        self._RollbackVersion = params.get("RollbackVersion")
        self._Status = params.get("Status")
        self._VersionCurrentStatus = params.get("VersionCurrentStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOfflineMNPPackageRequest(AbstractModel):
    """DescribeOfflineMNPPackage request structure.

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._MNPId = None
        self._PlatformId = None

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOfflineMNPPackageResponse(AbstractModel):
    """DescribeOfflineMNPPackage response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.StringData`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = StringData()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeOnlineVersionRequest(AbstractModel):
    """DescribeOnlineVersion request structure.

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._MNPId = None
        self._PlatformId = None

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOnlineVersionResponse(AbstractModel):
    """DescribeOnlineVersion response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.DescribeRevertOnlineVersionPageResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeRevertOnlineVersionPageResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRevertOnlineVersionPageResp(AbstractModel):
    """Response of querying the rollback version list

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of entries
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _DataList: List information
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataList: list of QueryOnlineVersionResp
        """
        self._TotalCount = None
        self._DataList = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DataList(self):
        return self._DataList

    @DataList.setter
    def DataList(self, DataList):
        self._DataList = DataList


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DataList") is not None:
            self._DataList = []
            for item in params.get("DataList"):
                obj = QueryOnlineVersionResp()
                obj._deserialize(item)
                self._DataList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRoleDetailRequest(AbstractModel):
    """DescribeRoleDetail request structure.

    """

    def __init__(self):
        r"""
        :param _RoleId: Role ID
        :type RoleId: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._RoleId = None
        self._PlatformId = None

    @property
    def RoleId(self):
        return self._RoleId

    @RoleId.setter
    def RoleId(self, RoleId):
        self._RoleId = RoleId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._RoleId = params.get("RoleId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRoleDetailResp(AbstractModel):
    """Role details

    """

    def __init__(self):
        r"""
        :param _RoleId: Role ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type RoleId: int
        :param _RoleName: Role name
Note: This field may return null, indicating that no valid values can be obtained.
        :type RoleName: str
        :param _TeamId: Team ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamId: str
        :param _TeamName: Team name
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamName: str
        :param _ResourceIds: Accessible menu list
Note: This field may return null, indicating that no valid values can be obtained.
        :type ResourceIds: list of str
        """
        self._RoleId = None
        self._RoleName = None
        self._TeamId = None
        self._TeamName = None
        self._ResourceIds = None

    @property
    def RoleId(self):
        return self._RoleId

    @RoleId.setter
    def RoleId(self, RoleId):
        self._RoleId = RoleId

    @property
    def RoleName(self):
        return self._RoleName

    @RoleName.setter
    def RoleName(self, RoleName):
        self._RoleName = RoleName

    @property
    def TeamId(self):
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId

    @property
    def TeamName(self):
        return self._TeamName

    @TeamName.setter
    def TeamName(self, TeamName):
        self._TeamName = TeamName

    @property
    def ResourceIds(self):
        return self._ResourceIds

    @ResourceIds.setter
    def ResourceIds(self, ResourceIds):
        self._ResourceIds = ResourceIds


    def _deserialize(self, params):
        self._RoleId = params.get("RoleId")
        self._RoleName = params.get("RoleName")
        self._TeamId = params.get("TeamId")
        self._TeamName = params.get("TeamName")
        self._ResourceIds = params.get("ResourceIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRoleDetailResponse(AbstractModel):
    """DescribeRoleDetail response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.DescribeRoleDetailResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeRoleDetailResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRoleListData(AbstractModel):
    """Role management list

    """

    def __init__(self):
        r"""
        :param _RoleId: Role ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type RoleId: int
        :param _RoleName: Role name
Note: This field may return null, indicating that no valid values can be obtained.
        :type RoleName: str
        :param _TeamName: Team name
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamName: str
        :param _CreateTime: Creation time
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        :param _RoleType: Role type 1-Preset role 2-Custom role
Note: This field may return null, indicating that no valid values can be obtained.
        :type RoleType: int
        """
        self._RoleId = None
        self._RoleName = None
        self._TeamName = None
        self._CreateTime = None
        self._RoleType = None

    @property
    def RoleId(self):
        return self._RoleId

    @RoleId.setter
    def RoleId(self, RoleId):
        self._RoleId = RoleId

    @property
    def RoleName(self):
        return self._RoleName

    @RoleName.setter
    def RoleName(self, RoleName):
        self._RoleName = RoleName

    @property
    def TeamName(self):
        return self._TeamName

    @TeamName.setter
    def TeamName(self, TeamName):
        self._TeamName = TeamName

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def RoleType(self):
        return self._RoleType

    @RoleType.setter
    def RoleType(self, RoleType):
        self._RoleType = RoleType


    def _deserialize(self, params):
        self._RoleId = params.get("RoleId")
        self._RoleName = params.get("RoleName")
        self._TeamName = params.get("TeamName")
        self._CreateTime = params.get("CreateTime")
        self._RoleType = params.get("RoleType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRoleListRequest(AbstractModel):
    """DescribeRoleList request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Page offset
        :type Offset: int
        :param _Limit: Number of results per page
        :type Limit: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _Keyword: Keywords for search (role name)
        :type Keyword: str
        :param _TeamId: Team ID
        :type TeamId: str
        """
        self._Offset = None
        self._Limit = None
        self._PlatformId = None
        self._Keyword = None
        self._TeamId = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def Keyword(self):
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword

    @property
    def TeamId(self):
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._PlatformId = params.get("PlatformId")
        self._Keyword = params.get("Keyword")
        self._TeamId = params.get("TeamId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRoleListResp(AbstractModel):
    """Role management list

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of entries
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _DataList: List data
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataList: list of DescribeRoleListData
        """
        self._TotalCount = None
        self._DataList = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DataList(self):
        return self._DataList

    @DataList.setter
    def DataList(self, DataList):
        self._DataList = DataList


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DataList") is not None:
            self._DataList = []
            for item in params.get("DataList"):
                obj = DescribeRoleListData()
                obj._deserialize(item)
                self._DataList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRoleListResponse(AbstractModel):
    """DescribeRoleList response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.DescribeRoleListResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeRoleListResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeSensitiveAPIAuditListRequest(AbstractModel):
    """DescribeSensitiveAPIAuditList request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Page offset
        :type Offset: int
        :param _Limit: Number of results per page
        :type Limit: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _AuditStatusList: Status list
        :type AuditStatusList: list of int
        :param _Keyword: Keywords for search (API name or API method or app name)
        :type Keyword: str
        """
        self._Offset = None
        self._Limit = None
        self._PlatformId = None
        self._AuditStatusList = None
        self._Keyword = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def AuditStatusList(self):
        return self._AuditStatusList

    @AuditStatusList.setter
    def AuditStatusList(self, AuditStatusList):
        self._AuditStatusList = AuditStatusList

    @property
    def Keyword(self):
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._PlatformId = params.get("PlatformId")
        self._AuditStatusList = params.get("AuditStatusList")
        self._Keyword = params.get("Keyword")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSensitiveAPIAuditListResponse(AbstractModel):
    """DescribeSensitiveAPIAuditList response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.SensitiveApiAuditInfoPageResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = SensitiveApiAuditInfoPageResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeSensitiveAPIListRequest(AbstractModel):
    """DescribeSensitiveAPIList request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Page offset
        :type Offset: int
        :param _Limit: Number of results per page
        :type Limit: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _Keyword: Keywords for search (API name or method)
        :type Keyword: str
        :param _TeamId: Team ID
        :type TeamId: str
        :param _ApplicationId: Application ID
        :type ApplicationId: str
        """
        self._Offset = None
        self._Limit = None
        self._PlatformId = None
        self._Keyword = None
        self._TeamId = None
        self._ApplicationId = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def Keyword(self):
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword

    @property
    def TeamId(self):
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId

    @property
    def ApplicationId(self):
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._PlatformId = params.get("PlatformId")
        self._Keyword = params.get("Keyword")
        self._TeamId = params.get("TeamId")
        self._ApplicationId = params.get("ApplicationId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSensitiveAPIListResponse(AbstractModel):
    """DescribeSensitiveAPIList response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.SensitiveApiPageInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = SensitiveApiPageInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeSensitiveApiApplyDetail(AbstractModel):
    """Details of sensitive API applications

    """

    def __init__(self):
        r"""
        :param _APIId: API ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type APIId: str
        :param _APIMethod: API request method
Note: This field may return null, indicating that no valid values can be obtained.
        :type APIMethod: str
        :param _ApplyReason: Reason for application
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplyReason: str
        :param _RejectReason: Reason for rejection
Note: This field may return null, indicating that no valid values can be obtained.
        :type RejectReason: str
        :param _AuditStatus: Approval status
Note: This field may return null, indicating that no valid values can be obtained.
        :type AuditStatus: int
        :param _APIDesc: API function description
Note: This field may return null, indicating that no valid values can be obtained.
        :type APIDesc: str
        :param _APIType: API type. 1: System; 2: Custom
Note: This field may return null, indicating that no valid values can be obtained.
        :type APIType: int
        """
        self._APIId = None
        self._APIMethod = None
        self._ApplyReason = None
        self._RejectReason = None
        self._AuditStatus = None
        self._APIDesc = None
        self._APIType = None

    @property
    def APIId(self):
        return self._APIId

    @APIId.setter
    def APIId(self, APIId):
        self._APIId = APIId

    @property
    def APIMethod(self):
        return self._APIMethod

    @APIMethod.setter
    def APIMethod(self, APIMethod):
        self._APIMethod = APIMethod

    @property
    def ApplyReason(self):
        return self._ApplyReason

    @ApplyReason.setter
    def ApplyReason(self, ApplyReason):
        self._ApplyReason = ApplyReason

    @property
    def RejectReason(self):
        return self._RejectReason

    @RejectReason.setter
    def RejectReason(self, RejectReason):
        self._RejectReason = RejectReason

    @property
    def AuditStatus(self):
        return self._AuditStatus

    @AuditStatus.setter
    def AuditStatus(self, AuditStatus):
        self._AuditStatus = AuditStatus

    @property
    def APIDesc(self):
        return self._APIDesc

    @APIDesc.setter
    def APIDesc(self, APIDesc):
        self._APIDesc = APIDesc

    @property
    def APIType(self):
        return self._APIType

    @APIType.setter
    def APIType(self, APIType):
        self._APIType = APIType


    def _deserialize(self, params):
        self._APIId = params.get("APIId")
        self._APIMethod = params.get("APIMethod")
        self._ApplyReason = params.get("ApplyReason")
        self._RejectReason = params.get("RejectReason")
        self._AuditStatus = params.get("AuditStatus")
        self._APIDesc = params.get("APIDesc")
        self._APIType = params.get("APIType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSensitiveApiApplyDetailRequest(AbstractModel):
    """DescribeSensitiveApiApplyDetail request structure.

    """

    def __init__(self):
        r"""
        :param _AuditNo: Approval ticket ID
        :type AuditNo: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._AuditNo = None
        self._PlatformId = None

    @property
    def AuditNo(self):
        return self._AuditNo

    @AuditNo.setter
    def AuditNo(self, AuditNo):
        self._AuditNo = AuditNo

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._AuditNo = params.get("AuditNo")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSensitiveApiApplyDetailResponse(AbstractModel):
    """DescribeSensitiveApiApplyDetail response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.DescribeSensitiveApiApplyDetail`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeSensitiveApiApplyDetail()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeSensitiveApiAuthListParam(AbstractModel):
    """Privacy API permission list

    """

    def __init__(self):
        r"""
        :param _APIId: API ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type APIId: str
        :param _APIName: API name
Note: This field may return null, indicating that no valid values can be obtained.
        :type APIName: str
        :param _APIMethod: API method
Note: This field may return null, indicating that no valid values can be obtained.
        :type APIMethod: str
        :param _APIStatus: API status
Note: This field may return null, indicating that no valid values can be obtained.
        :type APIStatus: int
        :param _APIApplyStatus: API application status
Note: This field may return null, indicating that no valid values can be obtained.
        :type APIApplyStatus: int
        :param _RejectReason: Reason for rejection
Note: This field may return null, indicating that no valid values can be obtained.
        :type RejectReason: str
        :param _AuditNo: Approval ticket ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type AuditNo: str
        :param _ApplicationId: Application ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationId: str
        :param _ApplicationIcon: Application icon
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationIcon: str
        :param _ApplicationName: Application name
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationName: str
        :param _APIType: API type 1 - System API 2 - Custom API
Note: This field may return null, indicating that no valid values can be obtained.
        :type APIType: int
        :param _APIDesc: API feature description
Note: This field may return null, indicating that no valid values can be obtained.
        :type APIDesc: str
        """
        self._APIId = None
        self._APIName = None
        self._APIMethod = None
        self._APIStatus = None
        self._APIApplyStatus = None
        self._RejectReason = None
        self._AuditNo = None
        self._ApplicationId = None
        self._ApplicationIcon = None
        self._ApplicationName = None
        self._APIType = None
        self._APIDesc = None

    @property
    def APIId(self):
        return self._APIId

    @APIId.setter
    def APIId(self, APIId):
        self._APIId = APIId

    @property
    def APIName(self):
        return self._APIName

    @APIName.setter
    def APIName(self, APIName):
        self._APIName = APIName

    @property
    def APIMethod(self):
        return self._APIMethod

    @APIMethod.setter
    def APIMethod(self, APIMethod):
        self._APIMethod = APIMethod

    @property
    def APIStatus(self):
        return self._APIStatus

    @APIStatus.setter
    def APIStatus(self, APIStatus):
        self._APIStatus = APIStatus

    @property
    def APIApplyStatus(self):
        return self._APIApplyStatus

    @APIApplyStatus.setter
    def APIApplyStatus(self, APIApplyStatus):
        self._APIApplyStatus = APIApplyStatus

    @property
    def RejectReason(self):
        return self._RejectReason

    @RejectReason.setter
    def RejectReason(self, RejectReason):
        self._RejectReason = RejectReason

    @property
    def AuditNo(self):
        return self._AuditNo

    @AuditNo.setter
    def AuditNo(self, AuditNo):
        self._AuditNo = AuditNo

    @property
    def ApplicationId(self):
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def ApplicationIcon(self):
        return self._ApplicationIcon

    @ApplicationIcon.setter
    def ApplicationIcon(self, ApplicationIcon):
        self._ApplicationIcon = ApplicationIcon

    @property
    def ApplicationName(self):
        return self._ApplicationName

    @ApplicationName.setter
    def ApplicationName(self, ApplicationName):
        self._ApplicationName = ApplicationName

    @property
    def APIType(self):
        return self._APIType

    @APIType.setter
    def APIType(self, APIType):
        self._APIType = APIType

    @property
    def APIDesc(self):
        return self._APIDesc

    @APIDesc.setter
    def APIDesc(self, APIDesc):
        self._APIDesc = APIDesc


    def _deserialize(self, params):
        self._APIId = params.get("APIId")
        self._APIName = params.get("APIName")
        self._APIMethod = params.get("APIMethod")
        self._APIStatus = params.get("APIStatus")
        self._APIApplyStatus = params.get("APIApplyStatus")
        self._RejectReason = params.get("RejectReason")
        self._AuditNo = params.get("AuditNo")
        self._ApplicationId = params.get("ApplicationId")
        self._ApplicationIcon = params.get("ApplicationIcon")
        self._ApplicationName = params.get("ApplicationName")
        self._APIType = params.get("APIType")
        self._APIDesc = params.get("APIDesc")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSensitiveApiAuthListRequest(AbstractModel):
    """DescribeSensitiveApiAuthList request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Page offset
        :type Offset: int
        :param _Limit: Number of results per page
        :type Limit: int
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _ApplicationId: Application ID
        :type ApplicationId: str
        :param _Keyword: Keywords for search (API name)
        :type Keyword: str
        """
        self._Offset = None
        self._Limit = None
        self._MNPId = None
        self._PlatformId = None
        self._ApplicationId = None
        self._Keyword = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def ApplicationId(self):
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def Keyword(self):
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._MNPId = params.get("MNPId")
        self._PlatformId = params.get("PlatformId")
        self._ApplicationId = params.get("ApplicationId")
        self._Keyword = params.get("Keyword")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSensitiveApiAuthListResponse(AbstractModel):
    """DescribeSensitiveApiAuthList response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.DescribeSensitiveApiAuthPageParam`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeSensitiveApiAuthPageParam()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeSensitiveApiAuthPageParam(AbstractModel):
    """Privacy API permissions page list

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of entries
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _DataList: List data
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataList: list of DescribeSensitiveApiAuthListParam
        """
        self._TotalCount = None
        self._DataList = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DataList(self):
        return self._DataList

    @DataList.setter
    def DataList(self, DataList):
        self._DataList = DataList


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DataList") is not None:
            self._DataList = []
            for item in params.get("DataList"):
                obj = DescribeSensitiveApiAuthListParam()
                obj._deserialize(item)
                self._DataList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeShowCaseResp(AbstractModel):
    """Response of querying the trial version

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPId: str
        :param _MNPName: Mini program name
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPName: str
        :param _MNPDesc: Mini program description
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPDesc: str
        :param _MNPVersion: Mini program version
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPVersion: str
        :param _MNPVersionIntro: Mini program introduction
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPVersionIntro: str
        :param _QRCodeUrl: Mini program QR code
Note: This field may return null, indicating that no valid values can be obtained.
        :type QRCodeUrl: str
        :param _AppList: Application information
Note: This field may return null, indicating that no valid values can be obtained.
        :type AppList: list of ShowCaseRelAppInfo
        :param _TestEntrancePath: Path to the demo
Note: This field may return null, indicating that no valid values can be obtained.
        :type TestEntrancePath: str
        """
        self._MNPId = None
        self._MNPName = None
        self._MNPDesc = None
        self._MNPVersion = None
        self._MNPVersionIntro = None
        self._QRCodeUrl = None
        self._AppList = None
        self._TestEntrancePath = None

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def MNPName(self):
        return self._MNPName

    @MNPName.setter
    def MNPName(self, MNPName):
        self._MNPName = MNPName

    @property
    def MNPDesc(self):
        return self._MNPDesc

    @MNPDesc.setter
    def MNPDesc(self, MNPDesc):
        self._MNPDesc = MNPDesc

    @property
    def MNPVersion(self):
        return self._MNPVersion

    @MNPVersion.setter
    def MNPVersion(self, MNPVersion):
        self._MNPVersion = MNPVersion

    @property
    def MNPVersionIntro(self):
        return self._MNPVersionIntro

    @MNPVersionIntro.setter
    def MNPVersionIntro(self, MNPVersionIntro):
        self._MNPVersionIntro = MNPVersionIntro

    @property
    def QRCodeUrl(self):
        return self._QRCodeUrl

    @QRCodeUrl.setter
    def QRCodeUrl(self, QRCodeUrl):
        self._QRCodeUrl = QRCodeUrl

    @property
    def AppList(self):
        return self._AppList

    @AppList.setter
    def AppList(self, AppList):
        self._AppList = AppList

    @property
    def TestEntrancePath(self):
        return self._TestEntrancePath

    @TestEntrancePath.setter
    def TestEntrancePath(self, TestEntrancePath):
        self._TestEntrancePath = TestEntrancePath


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._MNPName = params.get("MNPName")
        self._MNPDesc = params.get("MNPDesc")
        self._MNPVersion = params.get("MNPVersion")
        self._MNPVersionIntro = params.get("MNPVersionIntro")
        self._QRCodeUrl = params.get("QRCodeUrl")
        if params.get("AppList") is not None:
            self._AppList = []
            for item in params.get("AppList"):
                obj = ShowCaseRelAppInfo()
                obj._deserialize(item)
                self._AppList.append(obj)
        self._TestEntrancePath = params.get("TestEntrancePath")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSimpleApplicationInfoListRequest(AbstractModel):
    """DescribeSimpleApplicationInfoList request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Pagination offset
        :type Offset: int
        :param _Limit: Number of results per page
        :type Limit: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _Keyword: Query keywords (application name)
        :type Keyword: str
        :param _LoadAssistantApp: Whether TCMPP Assistant is loaded
        :type LoadAssistantApp: bool
        :param _MNPId: Mini program ID
        :type MNPId: str
        """
        self._Offset = None
        self._Limit = None
        self._PlatformId = None
        self._Keyword = None
        self._LoadAssistantApp = None
        self._MNPId = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def Keyword(self):
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword

    @property
    def LoadAssistantApp(self):
        return self._LoadAssistantApp

    @LoadAssistantApp.setter
    def LoadAssistantApp(self, LoadAssistantApp):
        self._LoadAssistantApp = LoadAssistantApp

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._PlatformId = params.get("PlatformId")
        self._Keyword = params.get("Keyword")
        self._LoadAssistantApp = params.get("LoadAssistantApp")
        self._MNPId = params.get("MNPId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSimpleApplicationInfoListResponse(AbstractModel):
    """DescribeSimpleApplicationInfoList response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.ApplicationSimpleListInfoResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = ApplicationSimpleListInfoResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeSimpleTeamListRequest(AbstractModel):
    """DescribeSimpleTeamList request structure.

    """

    def __init__(self):
        r"""
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _TeamRoleTypeList: Team permission type 1. Mini program management 2 Application management
        :type TeamRoleTypeList: list of int
        """
        self._PlatformId = None
        self._TeamRoleTypeList = None

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def TeamRoleTypeList(self):
        return self._TeamRoleTypeList

    @TeamRoleTypeList.setter
    def TeamRoleTypeList(self, TeamRoleTypeList):
        self._TeamRoleTypeList = TeamRoleTypeList


    def _deserialize(self, params):
        self._PlatformId = params.get("PlatformId")
        self._TeamRoleTypeList = params.get("TeamRoleTypeList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSimpleTeamListResp(AbstractModel):
    """Simple team list

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of entries
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _DataList: List information
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataList: list of SimpleStringKeyValue
        """
        self._TotalCount = None
        self._DataList = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DataList(self):
        return self._DataList

    @DataList.setter
    def DataList(self, DataList):
        self._DataList = DataList


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DataList") is not None:
            self._DataList = []
            for item in params.get("DataList"):
                obj = SimpleStringKeyValue()
                obj._deserialize(item)
                self._DataList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSimpleTeamListResponse(AbstractModel):
    """DescribeSimpleTeamList response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.DescribeSimpleTeamListResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeSimpleTeamListResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeTeamDetailResp(AbstractModel):
    """Team details

    """

    def __init__(self):
        r"""
        :param _TeamName: Team name
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamName: str
        :param _TeamRoleType: Team role type 1-Mini program team 2-Application team
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamRoleType: int
        :param _AdminUserAccount: Admin account
Note: This field may return null, indicating that no valid values can be obtained.
        :type AdminUserAccount: str
        :param _CreateUser: Creator
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateUser: str
        :param _CreateTime: Creation time
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        :param _MemberCount: Number of team members
Note: This field may return null, indicating that no valid values can be obtained.
        :type MemberCount: int
        :param _BindMiniTeamCount: Number of bound mini program teams
Note: This field may return null, indicating that no valid values can be obtained.
        :type BindMiniTeamCount: int
        :param _BindTeamName: Name of the bound team
        :type BindTeamName: str
        :param _RegisterLink: Team registration link
        :type RegisterLink: str
        :param _ApplicationName: Application name. It’s required when querying details of a mini program team.
        :type ApplicationName: str
        """
        self._TeamName = None
        self._TeamRoleType = None
        self._AdminUserAccount = None
        self._CreateUser = None
        self._CreateTime = None
        self._MemberCount = None
        self._BindMiniTeamCount = None
        self._BindTeamName = None
        self._RegisterLink = None
        self._ApplicationName = None

    @property
    def TeamName(self):
        return self._TeamName

    @TeamName.setter
    def TeamName(self, TeamName):
        self._TeamName = TeamName

    @property
    def TeamRoleType(self):
        return self._TeamRoleType

    @TeamRoleType.setter
    def TeamRoleType(self, TeamRoleType):
        self._TeamRoleType = TeamRoleType

    @property
    def AdminUserAccount(self):
        return self._AdminUserAccount

    @AdminUserAccount.setter
    def AdminUserAccount(self, AdminUserAccount):
        self._AdminUserAccount = AdminUserAccount

    @property
    def CreateUser(self):
        return self._CreateUser

    @CreateUser.setter
    def CreateUser(self, CreateUser):
        self._CreateUser = CreateUser

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def MemberCount(self):
        return self._MemberCount

    @MemberCount.setter
    def MemberCount(self, MemberCount):
        self._MemberCount = MemberCount

    @property
    def BindMiniTeamCount(self):
        return self._BindMiniTeamCount

    @BindMiniTeamCount.setter
    def BindMiniTeamCount(self, BindMiniTeamCount):
        self._BindMiniTeamCount = BindMiniTeamCount

    @property
    def BindTeamName(self):
        return self._BindTeamName

    @BindTeamName.setter
    def BindTeamName(self, BindTeamName):
        self._BindTeamName = BindTeamName

    @property
    def RegisterLink(self):
        return self._RegisterLink

    @RegisterLink.setter
    def RegisterLink(self, RegisterLink):
        self._RegisterLink = RegisterLink

    @property
    def ApplicationName(self):
        return self._ApplicationName

    @ApplicationName.setter
    def ApplicationName(self, ApplicationName):
        self._ApplicationName = ApplicationName


    def _deserialize(self, params):
        self._TeamName = params.get("TeamName")
        self._TeamRoleType = params.get("TeamRoleType")
        self._AdminUserAccount = params.get("AdminUserAccount")
        self._CreateUser = params.get("CreateUser")
        self._CreateTime = params.get("CreateTime")
        self._MemberCount = params.get("MemberCount")
        self._BindMiniTeamCount = params.get("BindMiniTeamCount")
        self._BindTeamName = params.get("BindTeamName")
        self._RegisterLink = params.get("RegisterLink")
        self._ApplicationName = params.get("ApplicationName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTeamDomainListInfoResp(AbstractModel):
    """Information of team domains

    """

    def __init__(self):
        r"""
        :param _DomainId: Domain ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type DomainId: int
        :param _MNPId: Mini program ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPId: str
        :param _MNPName: Mini program name
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPName: str
        :param _DomainUrl: Domain name
Note: This field may return null, indicating that no valid values can be obtained.
        :type DomainUrl: str
        :param _DomainType: Type 
Note: This field may return null, indicating that no valid values can be obtained.
        :type DomainType: int
        :param _Status: Domain name status. 1: Normal; 2: Disabled
Note: This field may return null, indicating that no valid values can be obtained.
        :type Status: int
        :param _CreateUser: Creator
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateUser: str
        :param _CreateTime: The creation time.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        """
        self._DomainId = None
        self._MNPId = None
        self._MNPName = None
        self._DomainUrl = None
        self._DomainType = None
        self._Status = None
        self._CreateUser = None
        self._CreateTime = None

    @property
    def DomainId(self):
        return self._DomainId

    @DomainId.setter
    def DomainId(self, DomainId):
        self._DomainId = DomainId

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def MNPName(self):
        return self._MNPName

    @MNPName.setter
    def MNPName(self, MNPName):
        self._MNPName = MNPName

    @property
    def DomainUrl(self):
        return self._DomainUrl

    @DomainUrl.setter
    def DomainUrl(self, DomainUrl):
        self._DomainUrl = DomainUrl

    @property
    def DomainType(self):
        return self._DomainType

    @DomainType.setter
    def DomainType(self, DomainType):
        self._DomainType = DomainType

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def CreateUser(self):
        return self._CreateUser

    @CreateUser.setter
    def CreateUser(self, CreateUser):
        self._CreateUser = CreateUser

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime


    def _deserialize(self, params):
        self._DomainId = params.get("DomainId")
        self._MNPId = params.get("MNPId")
        self._MNPName = params.get("MNPName")
        self._DomainUrl = params.get("DomainUrl")
        self._DomainType = params.get("DomainType")
        self._Status = params.get("Status")
        self._CreateUser = params.get("CreateUser")
        self._CreateTime = params.get("CreateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTeamDomainListPageResp(AbstractModel):
    """Team domain name list

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of entries
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _DataList: List information
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataList: list of DescribeTeamDomainListInfoResp
        """
        self._TotalCount = None
        self._DataList = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DataList(self):
        return self._DataList

    @DataList.setter
    def DataList(self, DataList):
        self._DataList = DataList


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DataList") is not None:
            self._DataList = []
            for item in params.get("DataList"):
                obj = DescribeTeamDomainListInfoResp()
                obj._deserialize(item)
                self._DataList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTeamDomainListRequest(AbstractModel):
    """DescribeTeamDomainList request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Page offset
        :type Offset: int
        :param _Limit: Number of results per page
        :type Limit: int
        :param _TeamId: Team ID
        :type TeamId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._Offset = None
        self._Limit = None
        self._TeamId = None
        self._PlatformId = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def TeamId(self):
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._TeamId = params.get("TeamId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTeamDomainListResponse(AbstractModel):
    """DescribeTeamDomainList response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.DescribeTeamDomainListPageResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeTeamDomainListPageResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeTeamListInfoResp(AbstractModel):
    """Team list information

    """

    def __init__(self):
        r"""
        :param _TeamId: Team ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamId: str
        :param _TeamName: Team name
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamName: str
        :param _AdminUserId: Admin ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type AdminUserId: str
        :param _AdminUserAccount: Admin account
Note: This field may return null, indicating that no valid values can be obtained.
        :type AdminUserAccount: str
        :param _AdminUserName: Admin username
Note: This field may return null, indicating that no valid values can be obtained.
        :type AdminUserName: str
        :param _MemberCount: Number of team members
Note: This field may return null, indicating that no valid values can be obtained.
        :type MemberCount: int
        :param _RegisterLink: Team registration link
        :type RegisterLink: str
        :param _TeamRoleTypeList: Team permission type
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamRoleTypeList: list of int
        :param _RelatedTeamId: Associated team ID
        :type RelatedTeamId: int
        """
        self._TeamId = None
        self._TeamName = None
        self._AdminUserId = None
        self._AdminUserAccount = None
        self._AdminUserName = None
        self._MemberCount = None
        self._RegisterLink = None
        self._TeamRoleTypeList = None
        self._RelatedTeamId = None

    @property
    def TeamId(self):
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId

    @property
    def TeamName(self):
        return self._TeamName

    @TeamName.setter
    def TeamName(self, TeamName):
        self._TeamName = TeamName

    @property
    def AdminUserId(self):
        return self._AdminUserId

    @AdminUserId.setter
    def AdminUserId(self, AdminUserId):
        self._AdminUserId = AdminUserId

    @property
    def AdminUserAccount(self):
        return self._AdminUserAccount

    @AdminUserAccount.setter
    def AdminUserAccount(self, AdminUserAccount):
        self._AdminUserAccount = AdminUserAccount

    @property
    def AdminUserName(self):
        return self._AdminUserName

    @AdminUserName.setter
    def AdminUserName(self, AdminUserName):
        self._AdminUserName = AdminUserName

    @property
    def MemberCount(self):
        return self._MemberCount

    @MemberCount.setter
    def MemberCount(self, MemberCount):
        self._MemberCount = MemberCount

    @property
    def RegisterLink(self):
        return self._RegisterLink

    @RegisterLink.setter
    def RegisterLink(self, RegisterLink):
        self._RegisterLink = RegisterLink

    @property
    def TeamRoleTypeList(self):
        return self._TeamRoleTypeList

    @TeamRoleTypeList.setter
    def TeamRoleTypeList(self, TeamRoleTypeList):
        self._TeamRoleTypeList = TeamRoleTypeList

    @property
    def RelatedTeamId(self):
        return self._RelatedTeamId

    @RelatedTeamId.setter
    def RelatedTeamId(self, RelatedTeamId):
        self._RelatedTeamId = RelatedTeamId


    def _deserialize(self, params):
        self._TeamId = params.get("TeamId")
        self._TeamName = params.get("TeamName")
        self._AdminUserId = params.get("AdminUserId")
        self._AdminUserAccount = params.get("AdminUserAccount")
        self._AdminUserName = params.get("AdminUserName")
        self._MemberCount = params.get("MemberCount")
        self._RegisterLink = params.get("RegisterLink")
        self._TeamRoleTypeList = params.get("TeamRoleTypeList")
        self._RelatedTeamId = params.get("RelatedTeamId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTeamListRequest(AbstractModel):
    """DescribeTeamList request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Pagination offset
        :type Offset: int
        :param _Limit: Number of results per page
        :type Limit: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _Keyword: Name of the team to be queried
        :type Keyword: str
        """
        self._Offset = None
        self._Limit = None
        self._PlatformId = None
        self._Keyword = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def Keyword(self):
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._PlatformId = params.get("PlatformId")
        self._Keyword = params.get("Keyword")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTeamListResponse(AbstractModel):
    """DescribeTeamList response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.DescribeTeamPageResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeTeamPageResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeTeamMemberInfoResp(AbstractModel):
    """Team member information

    """

    def __init__(self):
        r"""
        :param _UserId: User ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type UserId: str
        :param _UserAccount: User account
Note: This field may return null, indicating that no valid values can be obtained.
        :type UserAccount: str
        :param _UserName: User name
Note: This field may return null, indicating that no valid values can be obtained.
        :type UserName: str
        :param _TeamId: Team ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamId: str
        :param _TeamName: Team name
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamName: str
        :param _TeamRoleName: Team role name
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamRoleName: str
        :param _TeamRoleId: Team role ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamRoleId: int
        :param _CanEdit: Editable or not
Note: This field may return null, indicating that no valid values can be obtained.
        :type CanEdit: bool
        """
        self._UserId = None
        self._UserAccount = None
        self._UserName = None
        self._TeamId = None
        self._TeamName = None
        self._TeamRoleName = None
        self._TeamRoleId = None
        self._CanEdit = None

    @property
    def UserId(self):
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def UserAccount(self):
        return self._UserAccount

    @UserAccount.setter
    def UserAccount(self, UserAccount):
        self._UserAccount = UserAccount

    @property
    def UserName(self):
        return self._UserName

    @UserName.setter
    def UserName(self, UserName):
        self._UserName = UserName

    @property
    def TeamId(self):
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId

    @property
    def TeamName(self):
        return self._TeamName

    @TeamName.setter
    def TeamName(self, TeamName):
        self._TeamName = TeamName

    @property
    def TeamRoleName(self):
        return self._TeamRoleName

    @TeamRoleName.setter
    def TeamRoleName(self, TeamRoleName):
        self._TeamRoleName = TeamRoleName

    @property
    def TeamRoleId(self):
        return self._TeamRoleId

    @TeamRoleId.setter
    def TeamRoleId(self, TeamRoleId):
        self._TeamRoleId = TeamRoleId

    @property
    def CanEdit(self):
        return self._CanEdit

    @CanEdit.setter
    def CanEdit(self, CanEdit):
        self._CanEdit = CanEdit


    def _deserialize(self, params):
        self._UserId = params.get("UserId")
        self._UserAccount = params.get("UserAccount")
        self._UserName = params.get("UserName")
        self._TeamId = params.get("TeamId")
        self._TeamName = params.get("TeamName")
        self._TeamRoleName = params.get("TeamRoleName")
        self._TeamRoleId = params.get("TeamRoleId")
        self._CanEdit = params.get("CanEdit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTeamMemberListPageResp(AbstractModel):
    """List of members

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of results.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _DataList: List information
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataList: list of DescribeTeamMemberInfoResp
        """
        self._TotalCount = None
        self._DataList = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DataList(self):
        return self._DataList

    @DataList.setter
    def DataList(self, DataList):
        self._DataList = DataList


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DataList") is not None:
            self._DataList = []
            for item in params.get("DataList"):
                obj = DescribeTeamMemberInfoResp()
                obj._deserialize(item)
                self._DataList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTeamMemberListRequest(AbstractModel):
    """DescribeTeamMemberList request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Page offset
        :type Offset: int
        :param _Limit: Number of results per page
        :type Limit: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _TeamId: Team ID
        :type TeamId: str
        :param _Keyword: Keywords for search (user name)
        :type Keyword: str
        :param _RoleIds: Role ID
        :type RoleIds: list of int
        """
        self._Offset = None
        self._Limit = None
        self._PlatformId = None
        self._TeamId = None
        self._Keyword = None
        self._RoleIds = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def TeamId(self):
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId

    @property
    def Keyword(self):
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword

    @property
    def RoleIds(self):
        return self._RoleIds

    @RoleIds.setter
    def RoleIds(self, RoleIds):
        self._RoleIds = RoleIds


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._PlatformId = params.get("PlatformId")
        self._TeamId = params.get("TeamId")
        self._Keyword = params.get("Keyword")
        self._RoleIds = params.get("RoleIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTeamMemberListResponse(AbstractModel):
    """DescribeTeamMemberList response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.DescribeTeamMemberListPageResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeTeamMemberListPageResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeTeamMembersInfoPageResp(AbstractModel):
    """Team member information

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of results.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _DataList: List information
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataList: list of DescribeTeamMembersInfoResp
        """
        self._TotalCount = None
        self._DataList = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DataList(self):
        return self._DataList

    @DataList.setter
    def DataList(self, DataList):
        self._DataList = DataList


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DataList") is not None:
            self._DataList = []
            for item in params.get("DataList"):
                obj = DescribeTeamMembersInfoResp()
                obj._deserialize(item)
                self._DataList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTeamMembersInfoResp(AbstractModel):
    """Team member information

    """

    def __init__(self):
        r"""
        :param _UserId: User ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type UserId: str
        :param _UserAccount: User account
Note: This field may return null, indicating that no valid values can be obtained.
        :type UserAccount: str
        :param _UserName: Username
Note: This field may return null, indicating that no valid values can be obtained.
        :type UserName: str
        :param _UserRoles: Role
Note: This field may return null, indicating that no valid values can be obtained.
        :type UserRoles: str
        """
        self._UserId = None
        self._UserAccount = None
        self._UserName = None
        self._UserRoles = None

    @property
    def UserId(self):
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def UserAccount(self):
        return self._UserAccount

    @UserAccount.setter
    def UserAccount(self, UserAccount):
        self._UserAccount = UserAccount

    @property
    def UserName(self):
        return self._UserName

    @UserName.setter
    def UserName(self, UserName):
        self._UserName = UserName

    @property
    def UserRoles(self):
        return self._UserRoles

    @UserRoles.setter
    def UserRoles(self, UserRoles):
        self._UserRoles = UserRoles


    def _deserialize(self, params):
        self._UserId = params.get("UserId")
        self._UserAccount = params.get("UserAccount")
        self._UserName = params.get("UserName")
        self._UserRoles = params.get("UserRoles")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTeamMembersRequest(AbstractModel):
    """DescribeTeamMembers request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Pagination offset
        :type Offset: int
        :param _Limit: Number of results per page
        :type Limit: int
        :param _TeamId: Team ID
        :type TeamId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._Offset = None
        self._Limit = None
        self._TeamId = None
        self._PlatformId = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def TeamId(self):
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._TeamId = params.get("TeamId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTeamMembersResponse(AbstractModel):
    """DescribeTeamMembers response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.DescribeTeamMembersInfoPageResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeTeamMembersInfoPageResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeTeamPageResp(AbstractModel):
    """List of teams

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of results.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _DataList: List information
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataList: list of DescribeTeamListInfoResp
        """
        self._TotalCount = None
        self._DataList = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DataList(self):
        return self._DataList

    @DataList.setter
    def DataList(self, DataList):
        self._DataList = DataList


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DataList") is not None:
            self._DataList = []
            for item in params.get("DataList"):
                obj = DescribeTeamListInfoResp()
                obj._deserialize(item)
                self._DataList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTeamRequest(AbstractModel):
    """DescribeTeam request structure.

    """

    def __init__(self):
        r"""
        :param _TeamId: Team ID
        :type TeamId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._TeamId = None
        self._PlatformId = None

    @property
    def TeamId(self):
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._TeamId = params.get("TeamId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTeamResponse(AbstractModel):
    """DescribeTeam response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.DescribeTeamDetailResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeTeamDetailResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeTempSecret4UploadFile2CosRequest(AbstractModel):
    """DescribeTempSecret4UploadFile2Cos request structure.

    """

    def __init__(self):
        r"""
        :param _BusinessName: Service name
        :type BusinessName: str
        :param _Suffix: File suffix
        :type Suffix: str
        """
        self._BusinessName = None
        self._Suffix = None

    @property
    def BusinessName(self):
        return self._BusinessName

    @BusinessName.setter
    def BusinessName(self, BusinessName):
        self._BusinessName = BusinessName

    @property
    def Suffix(self):
        return self._Suffix

    @Suffix.setter
    def Suffix(self, Suffix):
        self._Suffix = Suffix


    def _deserialize(self, params):
        self._BusinessName = params.get("BusinessName")
        self._Suffix = params.get("Suffix")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTempSecret4UploadFile2CosResponse(AbstractModel):
    """DescribeTempSecret4UploadFile2Cos response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.UploadFileTempSecret`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = UploadFileTempSecret()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeUserDetailRequest(AbstractModel):
    """DescribeUserDetail request structure.

    """

    def __init__(self):
        r"""
        :param _UserId: User ID
        :type UserId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._UserId = None
        self._PlatformId = None

    @property
    def UserId(self):
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._UserId = params.get("UserId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeUserDetailResp(AbstractModel):
    """User details

    """

    def __init__(self):
        r"""
        :param _UserId: User ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type UserId: str
        :param _UserAccount: User account
Note: This field may return null, indicating that no valid values can be obtained.
        :type UserAccount: str
        :param _AccountType: User account
1 - Super admin 2 - Platform admin 3 - Ordinary member
Note: This field may return null, indicating that no valid values can be obtained.
        :type AccountType: int
        :param _UserName: User name
Note: This field may return null, indicating that no valid values can be obtained.
        :type UserName: str
        """
        self._UserId = None
        self._UserAccount = None
        self._AccountType = None
        self._UserName = None

    @property
    def UserId(self):
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def UserAccount(self):
        return self._UserAccount

    @UserAccount.setter
    def UserAccount(self, UserAccount):
        self._UserAccount = UserAccount

    @property
    def AccountType(self):
        return self._AccountType

    @AccountType.setter
    def AccountType(self, AccountType):
        self._AccountType = AccountType

    @property
    def UserName(self):
        return self._UserName

    @UserName.setter
    def UserName(self, UserName):
        self._UserName = UserName


    def _deserialize(self, params):
        self._UserId = params.get("UserId")
        self._UserAccount = params.get("UserAccount")
        self._AccountType = params.get("AccountType")
        self._UserName = params.get("UserName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeUserDetailResponse(AbstractModel):
    """DescribeUserDetail response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.DescribeUserDetailResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeUserDetailResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeUserListData(AbstractModel):
    """Information of the specified user

    """

    def __init__(self):
        r"""
        :param _UserId: User ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type UserId: str
        :param _UserAccount: User account
Note: This field may return null, indicating that no valid values can be obtained.
        :type UserAccount: str
        :param _Teams: Associated team
Note: This field may return null, indicating that no valid values can be obtained.
        :type Teams: str
        :param _AccountType: Account type. 1: Super administrator; 2: Platform administrator; 3: Ordinary member
Note: This field may return null, indicating that no valid values can be obtained.
        :type AccountType: int
        :param _UserName: User name
Note: This field may return null, indicating that no valid values can be obtained.
        :type UserName: str
        :param _CreateTime: Creation time
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        :param _Status: Status. 1: Normal; 2: Disabled
Note: This field may return null, indicating that no valid values can be obtained.
        :type Status: int
        :param _TeamName: Team name
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamName: str
        """
        self._UserId = None
        self._UserAccount = None
        self._Teams = None
        self._AccountType = None
        self._UserName = None
        self._CreateTime = None
        self._Status = None
        self._TeamName = None

    @property
    def UserId(self):
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def UserAccount(self):
        return self._UserAccount

    @UserAccount.setter
    def UserAccount(self, UserAccount):
        self._UserAccount = UserAccount

    @property
    def Teams(self):
        warnings.warn("parameter `Teams` is deprecated", DeprecationWarning) 

        return self._Teams

    @Teams.setter
    def Teams(self, Teams):
        warnings.warn("parameter `Teams` is deprecated", DeprecationWarning) 

        self._Teams = Teams

    @property
    def AccountType(self):
        return self._AccountType

    @AccountType.setter
    def AccountType(self, AccountType):
        self._AccountType = AccountType

    @property
    def UserName(self):
        return self._UserName

    @UserName.setter
    def UserName(self, UserName):
        self._UserName = UserName

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def TeamName(self):
        return self._TeamName

    @TeamName.setter
    def TeamName(self, TeamName):
        self._TeamName = TeamName


    def _deserialize(self, params):
        self._UserId = params.get("UserId")
        self._UserAccount = params.get("UserAccount")
        self._Teams = params.get("Teams")
        self._AccountType = params.get("AccountType")
        self._UserName = params.get("UserName")
        self._CreateTime = params.get("CreateTime")
        self._Status = params.get("Status")
        self._TeamName = params.get("TeamName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeUserListRequest(AbstractModel):
    """DescribeUserList request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Page offset
        :type Offset: int
        :param _Limit: Number of results per page
        :type Limit: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _Keyword: Keywords for search (username or account)
        :type Keyword: str
        :param _AccountType: User account 1 - Super Admin 2 - Platform Admin 3 - Ordinary member
        :type AccountType: int
        :param _TeamId: Team ID
        :type TeamId: str
        """
        self._Offset = None
        self._Limit = None
        self._PlatformId = None
        self._Keyword = None
        self._AccountType = None
        self._TeamId = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def Keyword(self):
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword

    @property
    def AccountType(self):
        return self._AccountType

    @AccountType.setter
    def AccountType(self, AccountType):
        self._AccountType = AccountType

    @property
    def TeamId(self):
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._PlatformId = params.get("PlatformId")
        self._Keyword = params.get("Keyword")
        self._AccountType = params.get("AccountType")
        self._TeamId = params.get("TeamId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeUserListResp(AbstractModel):
    """User management list

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of entries
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _DataList: List data
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataList: list of DescribeUserListData
        """
        self._TotalCount = None
        self._DataList = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DataList(self):
        return self._DataList

    @DataList.setter
    def DataList(self, DataList):
        self._DataList = DataList


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DataList") is not None:
            self._DataList = []
            for item in params.get("DataList"):
                obj = DescribeUserListData()
                obj._deserialize(item)
                self._DataList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeUserListResponse(AbstractModel):
    """DescribeUserList response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.DescribeUserListResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeUserListResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeUserRequest(AbstractModel):
    """DescribeUser request structure.

    """

    def __init__(self):
        r"""
        :param _UserId: User ID
        :type UserId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._UserId = None
        self._PlatformId = None

    @property
    def UserId(self):
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._UserId = params.get("UserId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeUserResponse(AbstractModel):
    """DescribeUser response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.DescribeUserDetailResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeUserDetailResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DisableApplicationSensitiveAPIRequest(AbstractModel):
    """DisableApplicationSensitiveAPI request structure.

    """

    def __init__(self):
        r"""
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _APIId: API ID
        :type APIId: str
        """
        self._PlatformId = None
        self._APIId = None

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def APIId(self):
        return self._APIId

    @APIId.setter
    def APIId(self, APIId):
        self._APIId = APIId


    def _deserialize(self, params):
        self._PlatformId = params.get("PlatformId")
        self._APIId = params.get("APIId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisableApplicationSensitiveAPIResponse(AbstractModel):
    """DisableApplicationSensitiveAPI response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DisableEnterpriseDomainResp(AbstractModel):
    """Response data of disabled domain names

    """

    def __init__(self):
        r"""
        :param _Result: Result
Note: This field may return null, indicating that no valid values can be obtained.
        :type Result: bool
        """
        self._Result = None

    @property
    def Result(self):
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result


    def _deserialize(self, params):
        self._Result = params.get("Result")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisableTeamDomainRequest(AbstractModel):
    """DisableTeamDomain request structure.

    """

    def __init__(self):
        r"""
        :param _DomainId: 
        :type DomainId: int
        :param _PlatformId: 
        :type PlatformId: str
        """
        self._DomainId = None
        self._PlatformId = None

    @property
    def DomainId(self):
        return self._DomainId

    @DomainId.setter
    def DomainId(self, DomainId):
        self._DomainId = DomainId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._DomainId = params.get("DomainId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisableTeamDomainResponse(AbstractModel):
    """DisableTeamDomain response structure.

    """

    def __init__(self):
        r"""
        :param _Data: 
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.DisableEnterpriseDomainResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DisableEnterpriseDomainResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DownloadApplicationConfigResp(AbstractModel):
    """Application configuration information

    """

    def __init__(self):
        r"""
        :param _File: Configuration information in Base64 format
Note: This field may return null, indicating that no valid values can be obtained.
        :type File: str
        """
        self._File = None

    @property
    def File(self):
        return self._File

    @File.setter
    def File(self, File):
        self._File = File


    def _deserialize(self, params):
        self._File = params.get("File")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EnableApplicationSensitiveAPIRequest(AbstractModel):
    """EnableApplicationSensitiveAPI request structure.

    """

    def __init__(self):
        r"""
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _APIId: API ID
        :type APIId: str
        """
        self._PlatformId = None
        self._APIId = None

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def APIId(self):
        return self._APIId

    @APIId.setter
    def APIId(self, APIId):
        self._APIId = APIId


    def _deserialize(self, params):
        self._PlatformId = params.get("PlatformId")
        self._APIId = params.get("APIId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EnableApplicationSensitiveAPIResponse(AbstractModel):
    """EnableApplicationSensitiveAPI response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class GlobalDomainCheckResp(AbstractModel):
    """Result of global domain name check

    """

    def __init__(self):
        r"""
        :param _RepeatUrls: List of duplicate domain names
Note: This field may return null, indicating that no valid values can be obtained.
        :type RepeatUrls: list of str
        :param _ExistsWhiteUrls: List of allowed domain names
Note: This field may return null, indicating that no valid values can be obtained.
        :type ExistsWhiteUrls: list of str
        :param _ExistsBlackUrls: List of blocked domain names
Note: This field may return null, indicating that no valid values can be obtained.
        :type ExistsBlackUrls: list of str
        """
        self._RepeatUrls = None
        self._ExistsWhiteUrls = None
        self._ExistsBlackUrls = None

    @property
    def RepeatUrls(self):
        return self._RepeatUrls

    @RepeatUrls.setter
    def RepeatUrls(self, RepeatUrls):
        self._RepeatUrls = RepeatUrls

    @property
    def ExistsWhiteUrls(self):
        return self._ExistsWhiteUrls

    @ExistsWhiteUrls.setter
    def ExistsWhiteUrls(self, ExistsWhiteUrls):
        self._ExistsWhiteUrls = ExistsWhiteUrls

    @property
    def ExistsBlackUrls(self):
        return self._ExistsBlackUrls

    @ExistsBlackUrls.setter
    def ExistsBlackUrls(self, ExistsBlackUrls):
        self._ExistsBlackUrls = ExistsBlackUrls


    def _deserialize(self, params):
        self._RepeatUrls = params.get("RepeatUrls")
        self._ExistsWhiteUrls = params.get("ExistsWhiteUrls")
        self._ExistsBlackUrls = params.get("ExistsBlackUrls")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GlobalDomainDeleteResp(AbstractModel):
    """Response of deleting a global domain name

    """

    def __init__(self):
        r"""
        :param _Result: Response result
Note: This field may return null, indicating that no valid values can be obtained.
        :type Result: bool
        """
        self._Result = None

    @property
    def Result(self):
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result


    def _deserialize(self, params):
        self._Result = params.get("Result")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GlobalDomainDescribeListInfoResp(AbstractModel):
    """List of global domain names

    """

    def __init__(self):
        r"""
        :param _DomainId: Domain ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type DomainId: int
        :param _CustomerID: Platform ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type CustomerID: str
        :param _DomainURL: Domain name
Note: This field may return null, indicating that no valid values can be obtained.
        :type DomainURL: str
        :param _DomainType: Type. 1: Allowed; 2: Blocked
Note: This field may return null, indicating that no valid values can be obtained.
        :type DomainType: int
        :param _CreateUser: Creator
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateUser: str
        :param _CreateTime: Creation time
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        :param _UpdateUser: Updated by
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateUser: str
        :param _UpdateTime: Update date
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateTime: str
        """
        self._DomainId = None
        self._CustomerID = None
        self._DomainURL = None
        self._DomainType = None
        self._CreateUser = None
        self._CreateTime = None
        self._UpdateUser = None
        self._UpdateTime = None

    @property
    def DomainId(self):
        return self._DomainId

    @DomainId.setter
    def DomainId(self, DomainId):
        self._DomainId = DomainId

    @property
    def CustomerID(self):
        return self._CustomerID

    @CustomerID.setter
    def CustomerID(self, CustomerID):
        self._CustomerID = CustomerID

    @property
    def DomainURL(self):
        return self._DomainURL

    @DomainURL.setter
    def DomainURL(self, DomainURL):
        self._DomainURL = DomainURL

    @property
    def DomainType(self):
        return self._DomainType

    @DomainType.setter
    def DomainType(self, DomainType):
        self._DomainType = DomainType

    @property
    def CreateUser(self):
        return self._CreateUser

    @CreateUser.setter
    def CreateUser(self, CreateUser):
        self._CreateUser = CreateUser

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateUser(self):
        return self._UpdateUser

    @UpdateUser.setter
    def UpdateUser(self, UpdateUser):
        self._UpdateUser = UpdateUser

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._DomainId = params.get("DomainId")
        self._CustomerID = params.get("CustomerID")
        self._DomainURL = params.get("DomainURL")
        self._DomainType = params.get("DomainType")
        self._CreateUser = params.get("CreateUser")
        self._CreateTime = params.get("CreateTime")
        self._UpdateUser = params.get("UpdateUser")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GlobalDomainDescribeListPageResp(AbstractModel):
    """Global domain name page list

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of results
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _DataList: Domain name information
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataList: list of GlobalDomainDescribeListInfoResp
        """
        self._TotalCount = None
        self._DataList = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DataList(self):
        return self._DataList

    @DataList.setter
    def DataList(self, DataList):
        self._DataList = DataList


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DataList") is not None:
            self._DataList = []
            for item in params.get("DataList"):
                obj = GlobalDomainDescribeListInfoResp()
                obj._deserialize(item)
                self._DataList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GlobalDomainModifyRespResp(AbstractModel):
    """Response of global domain name modification

    """

    def __init__(self):
        r"""
        :param _Result: 0: Success; 1: Allowed domains exist; 2: Blocked domains exist
Note: This field may return null, indicating that no valid values can be obtained.
        :type Result: int
        """
        self._Result = None

    @property
    def Result(self):
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result


    def _deserialize(self, params):
        self._Result = params.get("Result")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MNPDetail(AbstractModel):
    """Mini program details

    """

    def __init__(self):
        r"""
        :param _MNPType: Mini program type 
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPType: str
        :param _MNPId: Mini program ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPId: str
        :param _MNPName: Mini program name
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPName: str
        :param _MNPIcon: Mini program icon
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPIcon: str
        :param _MNPIntro: Mini program introduction
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPIntro: str
        :param _MNPDesc: Mini program description
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPDesc: str
        :param _CreateUser: Creator account
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateUser: str
        :param _CreateTime: Creation time, timestamp
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: int
        :param _OnlineStatus: Online Status 0 Not Online, 1 Online
Note: This field may return null, indicating that no valid values can be obtained.
        :type OnlineStatus: int
        :param _Applications: Application information
Note: This field may return null, indicating that no valid values can be obtained.
        :type Applications: list of ApplicationSimpleInfo
        :param _Tags: Mini program tag
Note: This field may return null, indicating that no valid values can be obtained.
        :type Tags: list of str
        :param _Status: Mini program status 1-Released 2-Removed
Note: This field may return null, indicating that no valid values can be obtained.
        :type Status: int
        """
        self._MNPType = None
        self._MNPId = None
        self._MNPName = None
        self._MNPIcon = None
        self._MNPIntro = None
        self._MNPDesc = None
        self._CreateUser = None
        self._CreateTime = None
        self._OnlineStatus = None
        self._Applications = None
        self._Tags = None
        self._Status = None

    @property
    def MNPType(self):
        return self._MNPType

    @MNPType.setter
    def MNPType(self, MNPType):
        self._MNPType = MNPType

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def MNPName(self):
        return self._MNPName

    @MNPName.setter
    def MNPName(self, MNPName):
        self._MNPName = MNPName

    @property
    def MNPIcon(self):
        return self._MNPIcon

    @MNPIcon.setter
    def MNPIcon(self, MNPIcon):
        self._MNPIcon = MNPIcon

    @property
    def MNPIntro(self):
        return self._MNPIntro

    @MNPIntro.setter
    def MNPIntro(self, MNPIntro):
        self._MNPIntro = MNPIntro

    @property
    def MNPDesc(self):
        return self._MNPDesc

    @MNPDesc.setter
    def MNPDesc(self, MNPDesc):
        self._MNPDesc = MNPDesc

    @property
    def CreateUser(self):
        return self._CreateUser

    @CreateUser.setter
    def CreateUser(self, CreateUser):
        self._CreateUser = CreateUser

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def OnlineStatus(self):
        return self._OnlineStatus

    @OnlineStatus.setter
    def OnlineStatus(self, OnlineStatus):
        self._OnlineStatus = OnlineStatus

    @property
    def Applications(self):
        return self._Applications

    @Applications.setter
    def Applications(self, Applications):
        self._Applications = Applications

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._MNPType = params.get("MNPType")
        self._MNPId = params.get("MNPId")
        self._MNPName = params.get("MNPName")
        self._MNPIcon = params.get("MNPIcon")
        self._MNPIntro = params.get("MNPIntro")
        self._MNPDesc = params.get("MNPDesc")
        self._CreateUser = params.get("CreateUser")
        self._CreateTime = params.get("CreateTime")
        self._OnlineStatus = params.get("OnlineStatus")
        if params.get("Applications") is not None:
            self._Applications = []
            for item in params.get("Applications"):
                obj = ApplicationSimpleInfo()
                obj._deserialize(item)
                self._Applications.append(obj)
        self._Tags = params.get("Tags")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MNPTypeDefine(AbstractModel):
    """Information of mini program categories

    """

    def __init__(self):
        r"""
        :param _TypeName: Mini program category name
Note: This field may return null, indicating that no valid values can be obtained.
        :type TypeName: str
        :param _TypeValue: Mini program category value
Note: This field may return null, indicating that no valid values can be obtained.
        :type TypeValue: list of str
        :param _TypeId: Category ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type TypeId: int
        :param _CreateTime: Creation time
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: int
        :param _CreateUser: Creator
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateUser: str
        :param _IsSystem: Whether it is a system category
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsSystem: bool
        """
        self._TypeName = None
        self._TypeValue = None
        self._TypeId = None
        self._CreateTime = None
        self._CreateUser = None
        self._IsSystem = None

    @property
    def TypeName(self):
        return self._TypeName

    @TypeName.setter
    def TypeName(self, TypeName):
        self._TypeName = TypeName

    @property
    def TypeValue(self):
        return self._TypeValue

    @TypeValue.setter
    def TypeValue(self, TypeValue):
        self._TypeValue = TypeValue

    @property
    def TypeId(self):
        return self._TypeId

    @TypeId.setter
    def TypeId(self, TypeId):
        self._TypeId = TypeId

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def CreateUser(self):
        return self._CreateUser

    @CreateUser.setter
    def CreateUser(self, CreateUser):
        self._CreateUser = CreateUser

    @property
    def IsSystem(self):
        return self._IsSystem

    @IsSystem.setter
    def IsSystem(self, IsSystem):
        self._IsSystem = IsSystem


    def _deserialize(self, params):
        self._TypeName = params.get("TypeName")
        self._TypeValue = params.get("TypeValue")
        self._TypeId = params.get("TypeId")
        self._CreateTime = params.get("CreateTime")
        self._CreateUser = params.get("CreateUser")
        self._IsSystem = params.get("IsSystem")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyApplicationAppKeyRequest(AbstractModel):
    """ModifyApplicationAppKey request structure.

    """

    def __init__(self):
        r"""
        :param _ApplicationId: Application ID
        :type ApplicationId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _AndroidAppKey: Android package name
        :type AndroidAppKey: str
        :param _IOSAppKey: iOS package name
        :type IOSAppKey: str
        """
        self._ApplicationId = None
        self._PlatformId = None
        self._AndroidAppKey = None
        self._IOSAppKey = None

    @property
    def ApplicationId(self):
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def AndroidAppKey(self):
        return self._AndroidAppKey

    @AndroidAppKey.setter
    def AndroidAppKey(self, AndroidAppKey):
        self._AndroidAppKey = AndroidAppKey

    @property
    def IOSAppKey(self):
        return self._IOSAppKey

    @IOSAppKey.setter
    def IOSAppKey(self, IOSAppKey):
        self._IOSAppKey = IOSAppKey


    def _deserialize(self, params):
        self._ApplicationId = params.get("ApplicationId")
        self._PlatformId = params.get("PlatformId")
        self._AndroidAppKey = params.get("AndroidAppKey")
        self._IOSAppKey = params.get("IOSAppKey")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyApplicationAppKeyResponse(AbstractModel):
    """ModifyApplicationAppKey response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class ModifyApplicationAppUrlRequest(AbstractModel):
    """ModifyApplicationAppUrl request structure.

    """

    def __init__(self):
        r"""
        :param _ApplicationId: Application ID
        :type ApplicationId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _AndroidAppURL: Android address
        :type AndroidAppURL: str
        :param _IOSAppURL: iOS address
        :type IOSAppURL: str
        """
        self._ApplicationId = None
        self._PlatformId = None
        self._AndroidAppURL = None
        self._IOSAppURL = None

    @property
    def ApplicationId(self):
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def AndroidAppURL(self):
        return self._AndroidAppURL

    @AndroidAppURL.setter
    def AndroidAppURL(self, AndroidAppURL):
        self._AndroidAppURL = AndroidAppURL

    @property
    def IOSAppURL(self):
        return self._IOSAppURL

    @IOSAppURL.setter
    def IOSAppURL(self, IOSAppURL):
        self._IOSAppURL = IOSAppURL


    def _deserialize(self, params):
        self._ApplicationId = params.get("ApplicationId")
        self._PlatformId = params.get("PlatformId")
        self._AndroidAppURL = params.get("AndroidAppURL")
        self._IOSAppURL = params.get("IOSAppURL")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyApplicationAppUrlResponse(AbstractModel):
    """ModifyApplicationAppUrl response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class ModifyApplicationRequest(AbstractModel):
    """ModifyApplication request structure.

    """

    def __init__(self):
        r"""
        :param _ApplicationId: Application ID
        :type ApplicationId: str
        :param _ApplicationName: The application name.
        :type ApplicationName: str
        :param _Intro: Application introduction
        :type Intro: str
        :param _Logo: Icon
        :type Logo: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _AndroidAppKey: Android app package name
        :type AndroidAppKey: str
        :param _IosAppKey: iOS App bundleId
        :type IosAppKey: str
        :param _Remark: Remarks
        :type Remark: str
        """
        self._ApplicationId = None
        self._ApplicationName = None
        self._Intro = None
        self._Logo = None
        self._PlatformId = None
        self._AndroidAppKey = None
        self._IosAppKey = None
        self._Remark = None

    @property
    def ApplicationId(self):
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def ApplicationName(self):
        return self._ApplicationName

    @ApplicationName.setter
    def ApplicationName(self, ApplicationName):
        self._ApplicationName = ApplicationName

    @property
    def Intro(self):
        return self._Intro

    @Intro.setter
    def Intro(self, Intro):
        self._Intro = Intro

    @property
    def Logo(self):
        return self._Logo

    @Logo.setter
    def Logo(self, Logo):
        self._Logo = Logo

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def AndroidAppKey(self):
        return self._AndroidAppKey

    @AndroidAppKey.setter
    def AndroidAppKey(self, AndroidAppKey):
        self._AndroidAppKey = AndroidAppKey

    @property
    def IosAppKey(self):
        return self._IosAppKey

    @IosAppKey.setter
    def IosAppKey(self, IosAppKey):
        self._IosAppKey = IosAppKey

    @property
    def Remark(self):
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark


    def _deserialize(self, params):
        self._ApplicationId = params.get("ApplicationId")
        self._ApplicationName = params.get("ApplicationName")
        self._Intro = params.get("Intro")
        self._Logo = params.get("Logo")
        self._PlatformId = params.get("PlatformId")
        self._AndroidAppKey = params.get("AndroidAppKey")
        self._IosAppKey = params.get("IosAppKey")
        self._Remark = params.get("Remark")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyApplicationResponse(AbstractModel):
    """ModifyApplication response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class ModifyDomainRequest(AbstractModel):
    """ModifyDomain request structure.

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _Domain: Domain name list
        :type Domain: list of CreateDomainParam
        """
        self._MNPId = None
        self._PlatformId = None
        self._Domain = None

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._PlatformId = params.get("PlatformId")
        if params.get("Domain") is not None:
            self._Domain = []
            for item in params.get("Domain"):
                obj = CreateDomainParam()
                obj._deserialize(item)
                self._Domain.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyDomainResponse(AbstractModel):
    """ModifyDomain response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class ModifyGlobalDomainRequest(AbstractModel):
    """ModifyGlobalDomain request structure.

    """

    def __init__(self):
        r"""
        :param _DomainId: Domain ID
        :type DomainId: int
        :param _DomainUrl: Domain name
        :type DomainUrl: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._DomainId = None
        self._DomainUrl = None
        self._PlatformId = None

    @property
    def DomainId(self):
        return self._DomainId

    @DomainId.setter
    def DomainId(self, DomainId):
        self._DomainId = DomainId

    @property
    def DomainUrl(self):
        return self._DomainUrl

    @DomainUrl.setter
    def DomainUrl(self, DomainUrl):
        self._DomainUrl = DomainUrl

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._DomainId = params.get("DomainId")
        self._DomainUrl = params.get("DomainUrl")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyGlobalDomainResponse(AbstractModel):
    """ModifyGlobalDomain response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.GlobalDomainModifyRespResp`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = GlobalDomainModifyRespResp()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class ModifyMNPDomainRequest(AbstractModel):
    """ModifyMNPDomain request structure.

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _Domain: Domain name list
        :type Domain: list of CreateDomainParam
        """
        self._MNPId = None
        self._PlatformId = None
        self._Domain = None

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._PlatformId = params.get("PlatformId")
        if params.get("Domain") is not None:
            self._Domain = []
            for item in params.get("Domain"):
                obj = CreateDomainParam()
                obj._deserialize(item)
                self._Domain.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyMNPDomainResponse(AbstractModel):
    """ModifyMNPDomain response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class ModifyMNPRequest(AbstractModel):
    """ModifyMNP request structure.

    """

    def __init__(self):
        r"""
        :param _MNPType: Mini program type
        :type MNPType: str
        :param _MNPName: Mini program name
        :type MNPName: str
        :param _MNPIntro: Mini program introduction
        :type MNPIntro: str
        :param _MNPDesc: Mini program description
        :type MNPDesc: str
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _MNPIcon: Mini program icon
        :type MNPIcon: str
        """
        self._MNPType = None
        self._MNPName = None
        self._MNPIntro = None
        self._MNPDesc = None
        self._MNPId = None
        self._PlatformId = None
        self._MNPIcon = None

    @property
    def MNPType(self):
        return self._MNPType

    @MNPType.setter
    def MNPType(self, MNPType):
        self._MNPType = MNPType

    @property
    def MNPName(self):
        return self._MNPName

    @MNPName.setter
    def MNPName(self, MNPName):
        self._MNPName = MNPName

    @property
    def MNPIntro(self):
        return self._MNPIntro

    @MNPIntro.setter
    def MNPIntro(self, MNPIntro):
        self._MNPIntro = MNPIntro

    @property
    def MNPDesc(self):
        return self._MNPDesc

    @MNPDesc.setter
    def MNPDesc(self, MNPDesc):
        self._MNPDesc = MNPDesc

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def MNPIcon(self):
        return self._MNPIcon

    @MNPIcon.setter
    def MNPIcon(self, MNPIcon):
        self._MNPIcon = MNPIcon


    def _deserialize(self, params):
        self._MNPType = params.get("MNPType")
        self._MNPName = params.get("MNPName")
        self._MNPIntro = params.get("MNPIntro")
        self._MNPDesc = params.get("MNPDesc")
        self._MNPId = params.get("MNPId")
        self._PlatformId = params.get("PlatformId")
        self._MNPIcon = params.get("MNPIcon")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyMNPResponse(AbstractModel):
    """ModifyMNP response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.ResourceIdInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = ResourceIdInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class ModifyMNPStatusOfflineRequest(AbstractModel):
    """ModifyMNPStatusOffline request structure.

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._MNPId = None
        self._PlatformId = None

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyMNPStatusOfflineResponse(AbstractModel):
    """ModifyMNPStatusOffline response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class ModifyMNPVersionPreviewRequest(AbstractModel):
    """ModifyMNPVersionPreview request structure.

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _ActionType: 1 Set 2 Cancel
        :type ActionType: int
        :param _MNPVersionId: Mini program version ID
        :type MNPVersionId: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _TestEntrancePath: Path to the demo page
        :type TestEntrancePath: str
        """
        self._MNPId = None
        self._ActionType = None
        self._MNPVersionId = None
        self._PlatformId = None
        self._TestEntrancePath = None

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def ActionType(self):
        return self._ActionType

    @ActionType.setter
    def ActionType(self, ActionType):
        self._ActionType = ActionType

    @property
    def MNPVersionId(self):
        return self._MNPVersionId

    @MNPVersionId.setter
    def MNPVersionId(self, MNPVersionId):
        self._MNPVersionId = MNPVersionId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def TestEntrancePath(self):
        return self._TestEntrancePath

    @TestEntrancePath.setter
    def TestEntrancePath(self, TestEntrancePath):
        self._TestEntrancePath = TestEntrancePath


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._ActionType = params.get("ActionType")
        self._MNPVersionId = params.get("MNPVersionId")
        self._PlatformId = params.get("PlatformId")
        self._TestEntrancePath = params.get("TestEntrancePath")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyMNPVersionPreviewResponse(AbstractModel):
    """ModifyMNPVersionPreview response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class ModifyOnlineVersionRequest(AbstractModel):
    """ModifyOnlineVersion request structure.

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _MNPVersionId: Mini program version ID
        :type MNPVersionId: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _MNPVersion: Mini program version number
        :type MNPVersion: str
        """
        self._MNPId = None
        self._MNPVersionId = None
        self._PlatformId = None
        self._MNPVersion = None

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def MNPVersionId(self):
        return self._MNPVersionId

    @MNPVersionId.setter
    def MNPVersionId(self, MNPVersionId):
        self._MNPVersionId = MNPVersionId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def MNPVersion(self):
        return self._MNPVersion

    @MNPVersion.setter
    def MNPVersion(self, MNPVersion):
        self._MNPVersion = MNPVersion


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._MNPVersionId = params.get("MNPVersionId")
        self._PlatformId = params.get("PlatformId")
        self._MNPVersion = params.get("MNPVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyOnlineVersionResponse(AbstractModel):
    """ModifyOnlineVersion response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class ModifyPlatformAuditStatusRequest(AbstractModel):
    """ModifyPlatformAuditStatus request structure.

    """

    def __init__(self):
        r"""
        :param _AuditNo: Approval ticket ID
        :type AuditNo: str
        :param _AuditResult: Approval result
        :type AuditResult: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _AuditNote: Approval description
        :type AuditNote: str
        :param _AuditItems: Approval details
        :type AuditItems: list of AuditInfoReq
        """
        self._AuditNo = None
        self._AuditResult = None
        self._PlatformId = None
        self._AuditNote = None
        self._AuditItems = None

    @property
    def AuditNo(self):
        return self._AuditNo

    @AuditNo.setter
    def AuditNo(self, AuditNo):
        self._AuditNo = AuditNo

    @property
    def AuditResult(self):
        return self._AuditResult

    @AuditResult.setter
    def AuditResult(self, AuditResult):
        self._AuditResult = AuditResult

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def AuditNote(self):
        return self._AuditNote

    @AuditNote.setter
    def AuditNote(self, AuditNote):
        self._AuditNote = AuditNote

    @property
    def AuditItems(self):
        return self._AuditItems

    @AuditItems.setter
    def AuditItems(self, AuditItems):
        self._AuditItems = AuditItems


    def _deserialize(self, params):
        self._AuditNo = params.get("AuditNo")
        self._AuditResult = params.get("AuditResult")
        self._PlatformId = params.get("PlatformId")
        self._AuditNote = params.get("AuditNote")
        if params.get("AuditItems") is not None:
            self._AuditItems = []
            for item in params.get("AuditItems"):
                obj = AuditInfoReq()
                obj._deserialize(item)
                self._AuditItems.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyPlatformAuditStatusResponse(AbstractModel):
    """ModifyPlatformAuditStatus response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class ModifySensitiveAPIAuditStatusRequest(AbstractModel):
    """ModifySensitiveAPIAuditStatus request structure.

    """

    def __init__(self):
        r"""
        :param _AuditNo: Approval ticket ID
        :type AuditNo: str
        :param _AuditStatus: Approval status 20 Rejected 30 Approved
        :type AuditStatus: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _AuditNote: Approval notes
        :type AuditNote: str
        """
        self._AuditNo = None
        self._AuditStatus = None
        self._PlatformId = None
        self._AuditNote = None

    @property
    def AuditNo(self):
        return self._AuditNo

    @AuditNo.setter
    def AuditNo(self, AuditNo):
        self._AuditNo = AuditNo

    @property
    def AuditStatus(self):
        return self._AuditStatus

    @AuditStatus.setter
    def AuditStatus(self, AuditStatus):
        self._AuditStatus = AuditStatus

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def AuditNote(self):
        return self._AuditNote

    @AuditNote.setter
    def AuditNote(self, AuditNote):
        self._AuditNote = AuditNote


    def _deserialize(self, params):
        self._AuditNo = params.get("AuditNo")
        self._AuditStatus = params.get("AuditStatus")
        self._PlatformId = params.get("PlatformId")
        self._AuditNote = params.get("AuditNote")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifySensitiveAPIAuditStatusResponse(AbstractModel):
    """ModifySensitiveAPIAuditStatus response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class ModifyTeamMemberRequest(AbstractModel):
    """ModifyTeamMember request structure.

    """

    def __init__(self):
        r"""
        :param _TeamId: Team ID
        :type TeamId: str
        :param _UserId: User ID
        :type UserId: str
        :param _RoleId: Role ID.
        :type RoleId: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._TeamId = None
        self._UserId = None
        self._RoleId = None
        self._PlatformId = None

    @property
    def TeamId(self):
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId

    @property
    def UserId(self):
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def RoleId(self):
        return self._RoleId

    @RoleId.setter
    def RoleId(self, RoleId):
        self._RoleId = RoleId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._TeamId = params.get("TeamId")
        self._UserId = params.get("UserId")
        self._RoleId = params.get("RoleId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyTeamMemberResponse(AbstractModel):
    """ModifyTeamMember response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class ModifyTeamRequest(AbstractModel):
    """ModifyTeam request structure.

    """

    def __init__(self):
        r"""
        :param _TeamId: Team ID
        :type TeamId: str
        :param _TeamName: Team name
        :type TeamName: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _AdminUserId: Team administrator
        :type AdminUserId: str
        """
        self._TeamId = None
        self._TeamName = None
        self._PlatformId = None
        self._AdminUserId = None

    @property
    def TeamId(self):
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId

    @property
    def TeamName(self):
        return self._TeamName

    @TeamName.setter
    def TeamName(self, TeamName):
        self._TeamName = TeamName

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def AdminUserId(self):
        return self._AdminUserId

    @AdminUserId.setter
    def AdminUserId(self, AdminUserId):
        self._AdminUserId = AdminUserId


    def _deserialize(self, params):
        self._TeamId = params.get("TeamId")
        self._TeamName = params.get("TeamName")
        self._PlatformId = params.get("PlatformId")
        self._AdminUserId = params.get("AdminUserId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyTeamResponse(AbstractModel):
    """ModifyTeam response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class ModifyUserPasswordRequest(AbstractModel):
    """ModifyUserPassword request structure.

    """

    def __init__(self):
        r"""
        :param _UserId: User ID
        :type UserId: str
        :param _Password: Account password. Use CreatePresetKey to get publick key to encrypt the password.
        :type Password: str
        :param _KeyId: Call CreatePresetKey to get the keyID from RequestId
        :type KeyId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._UserId = None
        self._Password = None
        self._KeyId = None
        self._PlatformId = None

    @property
    def UserId(self):
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def Password(self):
        return self._Password

    @Password.setter
    def Password(self, Password):
        self._Password = Password

    @property
    def KeyId(self):
        return self._KeyId

    @KeyId.setter
    def KeyId(self, KeyId):
        self._KeyId = KeyId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._UserId = params.get("UserId")
        self._Password = params.get("Password")
        self._KeyId = params.get("KeyId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyUserPasswordResponse(AbstractModel):
    """ModifyUserPassword response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class ModifyUserRequest(AbstractModel):
    """ModifyUser request structure.

    """

    def __init__(self):
        r"""
        :param _UserId: User ID
        :type UserId: str
        :param _UserName: User name
        :type UserName: str
        :param _AccountType: Account type 2 - Platform administrator 3 - Ordinary member
        :type AccountType: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _UserAccount: Account
        :type UserAccount: str
        """
        self._UserId = None
        self._UserName = None
        self._AccountType = None
        self._PlatformId = None
        self._UserAccount = None

    @property
    def UserId(self):
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def UserName(self):
        return self._UserName

    @UserName.setter
    def UserName(self, UserName):
        self._UserName = UserName

    @property
    def AccountType(self):
        return self._AccountType

    @AccountType.setter
    def AccountType(self, AccountType):
        self._AccountType = AccountType

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def UserAccount(self):
        warnings.warn("parameter `UserAccount` is deprecated", DeprecationWarning) 

        return self._UserAccount

    @UserAccount.setter
    def UserAccount(self, UserAccount):
        warnings.warn("parameter `UserAccount` is deprecated", DeprecationWarning) 

        self._UserAccount = UserAccount


    def _deserialize(self, params):
        self._UserId = params.get("UserId")
        self._UserName = params.get("UserName")
        self._AccountType = params.get("AccountType")
        self._PlatformId = params.get("PlatformId")
        self._UserAccount = params.get("UserAccount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyUserResponse(AbstractModel):
    """ModifyUser response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class PresetResp(AbstractModel):
    """Encryption key returned

    """

    def __init__(self):
        r"""
        :param _Key: RSA encryption public key
Note: This field may return null, indicating that no valid values can be obtained.
        :type Key: str
        """
        self._Key = None

    @property
    def Key(self):
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key


    def _deserialize(self, params):
        self._Key = params.get("Key")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ProcessMNPApprovalRequest(AbstractModel):
    """ProcessMNPApproval request structure.

    """

    def __init__(self):
        r"""
        :param _ApprovalNo: Approval ID
        :type ApprovalNo: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _ApprovalItems: Approval details
        :type ApprovalItems: list of ApprovalItem
        """
        self._ApprovalNo = None
        self._PlatformId = None
        self._ApprovalItems = None

    @property
    def ApprovalNo(self):
        return self._ApprovalNo

    @ApprovalNo.setter
    def ApprovalNo(self, ApprovalNo):
        self._ApprovalNo = ApprovalNo

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def ApprovalItems(self):
        return self._ApprovalItems

    @ApprovalItems.setter
    def ApprovalItems(self, ApprovalItems):
        self._ApprovalItems = ApprovalItems


    def _deserialize(self, params):
        self._ApprovalNo = params.get("ApprovalNo")
        self._PlatformId = params.get("PlatformId")
        if params.get("ApprovalItems") is not None:
            self._ApprovalItems = []
            for item in params.get("ApprovalItems"):
                obj = ApprovalItem()
                obj._deserialize(item)
                self._ApprovalItems.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ProcessMNPApprovalResponse(AbstractModel):
    """ProcessMNPApproval response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class ProcessMNPSensitiveAPIPermissionApprovalRequest(AbstractModel):
    """ProcessMNPSensitiveAPIPermissionApproval request structure.

    """

    def __init__(self):
        r"""
        :param _ApprovalNo: Approval ID
        :type ApprovalNo: str
        :param _ApprovalStatus: Approval status. 20: Rejected; 30: Approved
        :type ApprovalStatus: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _ApprovalNote: Approval notes
        :type ApprovalNote: str
        """
        self._ApprovalNo = None
        self._ApprovalStatus = None
        self._PlatformId = None
        self._ApprovalNote = None

    @property
    def ApprovalNo(self):
        return self._ApprovalNo

    @ApprovalNo.setter
    def ApprovalNo(self, ApprovalNo):
        self._ApprovalNo = ApprovalNo

    @property
    def ApprovalStatus(self):
        return self._ApprovalStatus

    @ApprovalStatus.setter
    def ApprovalStatus(self, ApprovalStatus):
        self._ApprovalStatus = ApprovalStatus

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def ApprovalNote(self):
        return self._ApprovalNote

    @ApprovalNote.setter
    def ApprovalNote(self, ApprovalNote):
        self._ApprovalNote = ApprovalNote


    def _deserialize(self, params):
        self._ApprovalNo = params.get("ApprovalNo")
        self._ApprovalStatus = params.get("ApprovalStatus")
        self._PlatformId = params.get("PlatformId")
        self._ApprovalNote = params.get("ApprovalNote")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ProcessMNPSensitiveAPIPermissionApprovalResponse(AbstractModel):
    """ProcessMNPSensitiveAPIPermissionApproval response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class QueryOnlineVersionResp(AbstractModel):
    """Mini program online version ID

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPId: str
        :param _MNPVersion: Version
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPVersion: str
        :param _MNPVersionId: Version ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPVersionId: int
        :param _MNPVersionNote: Version note
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPVersionNote: str
        :param _UpdateTime: Update time
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateTime: str
        """
        self._MNPId = None
        self._MNPVersion = None
        self._MNPVersionId = None
        self._MNPVersionNote = None
        self._UpdateTime = None

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def MNPVersion(self):
        return self._MNPVersion

    @MNPVersion.setter
    def MNPVersion(self, MNPVersion):
        self._MNPVersion = MNPVersion

    @property
    def MNPVersionId(self):
        return self._MNPVersionId

    @MNPVersionId.setter
    def MNPVersionId(self, MNPVersionId):
        self._MNPVersionId = MNPVersionId

    @property
    def MNPVersionNote(self):
        return self._MNPVersionNote

    @MNPVersionNote.setter
    def MNPVersionNote(self, MNPVersionNote):
        self._MNPVersionNote = MNPVersionNote

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._MNPVersion = params.get("MNPVersion")
        self._MNPVersionId = params.get("MNPVersionId")
        self._MNPVersionNote = params.get("MNPVersionNote")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ReleaseMNPVersionRequest(AbstractModel):
    """ReleaseMNPVersion request structure.

    """

    def __init__(self):
        r"""
        :param _MNPVersionId: Mini program version ID
        :type MNPVersionId: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._MNPVersionId = None
        self._PlatformId = None

    @property
    def MNPVersionId(self):
        return self._MNPVersionId

    @MNPVersionId.setter
    def MNPVersionId(self, MNPVersionId):
        self._MNPVersionId = MNPVersionId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._MNPVersionId = params.get("MNPVersionId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ReleaseMNPVersionResponse(AbstractModel):
    """ReleaseMNPVersion response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class RemoveMNPRequest(AbstractModel):
    """RemoveMNP request structure.

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _PlatformId: Platform ID
        :type PlatformId: str
        """
        self._MNPId = None
        self._PlatformId = None

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._PlatformId = params.get("PlatformId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RemoveMNPResponse(AbstractModel):
    """RemoveMNP response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class ResourceIdInfo(AbstractModel):
    """Unified operation success ID - integer

    """

    def __init__(self):
        r"""
        :param _ResourceId: Resource ID
0: No trial version currently available
1: A trial version is currently available and uploaded by the current user
2: A trial version is currently available and uploaded by another user
Note: This field may return null, indicating that no valid values can be obtained.
        :type ResourceId: int
        """
        self._ResourceId = None

    @property
    def ResourceId(self):
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId


    def _deserialize(self, params):
        self._ResourceId = params.get("ResourceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ResourceIdStringInfo(AbstractModel):
    """The general parameter for resource ID returned for successful operations

    """

    def __init__(self):
        r"""
        :param _ResourceId: The ID of the resource returned
Note: This field may return null, indicating that no valid values can be obtained.
        :type ResourceId: str
        """
        self._ResourceId = None

    @property
    def ResourceId(self):
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId


    def _deserialize(self, params):
        self._ResourceId = params.get("ResourceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RollbackMNPVersionRequest(AbstractModel):
    """RollbackMNPVersion request structure.

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _MNPVersionId: Mini program version ID
        :type MNPVersionId: int
        :param _PlatformId: Platform ID
        :type PlatformId: str
        :param _MNPVersion: Mini program version number
        :type MNPVersion: str
        """
        self._MNPId = None
        self._MNPVersionId = None
        self._PlatformId = None
        self._MNPVersion = None

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def MNPVersionId(self):
        return self._MNPVersionId

    @MNPVersionId.setter
    def MNPVersionId(self, MNPVersionId):
        self._MNPVersionId = MNPVersionId

    @property
    def PlatformId(self):
        return self._PlatformId

    @PlatformId.setter
    def PlatformId(self, PlatformId):
        self._PlatformId = PlatformId

    @property
    def MNPVersion(self):
        return self._MNPVersion

    @MNPVersion.setter
    def MNPVersion(self, MNPVersion):
        self._MNPVersion = MNPVersion


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._MNPVersionId = params.get("MNPVersionId")
        self._PlatformId = params.get("PlatformId")
        self._MNPVersion = params.get("MNPVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RollbackMNPVersionResponse(AbstractModel):
    """RollbackMNPVersion response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response data
        :type Data: :class:`tencentcloud.tcmpp.v20240801.models.BooleanInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class SensitiveApiAuditInfoPageResp(AbstractModel):
    """Sensitive API approval info page

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of entries
        :type TotalCount: int
        :param _DataList: List information
        :type DataList: list of SensitiveApiAuditInfoResp
        """
        self._TotalCount = None
        self._DataList = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DataList(self):
        return self._DataList

    @DataList.setter
    def DataList(self, DataList):
        self._DataList = DataList


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DataList") is not None:
            self._DataList = []
            for item in params.get("DataList"):
                obj = SensitiveApiAuditInfoResp()
                obj._deserialize(item)
                self._DataList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SensitiveApiAuditInfoResp(AbstractModel):
    """Sensitive API approval information

    """

    def __init__(self):
        r"""
        :param _AuditNo: Approval ticket ID
        :type AuditNo: str
        :param _ApiId: Approval ticket ID
        :type ApiId: str
        :param _ApiName: API name
        :type ApiName: str
        :param _ApiMethod: API request method
        :type ApiMethod: str
        :param _MNPId: Mini program ID
        :type MNPId: str
        :param _MNPName: Mini program name
        :type MNPName: str
        :param _ApplyUser: Applicant
        :type ApplyUser: str
        :param _ApplyTime: Application time
        :type ApplyTime: str
        :param _ApplyNote: Application notes
        :type ApplyNote: str
        :param _AuditStatus: Approval status
        :type AuditStatus: int
        :param _AuditUser: Approver
Note: This field may return null, indicating that no valid values can be obtained.
        :type AuditUser: str
        :param _AuditTime: Approval time
Note: This field may return null, indicating that no valid values can be obtained.
        :type AuditTime: str
        :param _AuditNote: Approval notes
Note: This field may return null, indicating that no valid values can be obtained.
        :type AuditNote: str
        :param _ApplicationId: Application ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationId: str
        :param _ApplicationName: The application name.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationName: str
        :param _ApplicationLogo: Application icon
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationLogo: str
        :param _ApiType: API type. 1: System; 2: Custom
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApiType: int
        :param _ApiDesc: API function description
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApiDesc: str
        """
        self._AuditNo = None
        self._ApiId = None
        self._ApiName = None
        self._ApiMethod = None
        self._MNPId = None
        self._MNPName = None
        self._ApplyUser = None
        self._ApplyTime = None
        self._ApplyNote = None
        self._AuditStatus = None
        self._AuditUser = None
        self._AuditTime = None
        self._AuditNote = None
        self._ApplicationId = None
        self._ApplicationName = None
        self._ApplicationLogo = None
        self._ApiType = None
        self._ApiDesc = None

    @property
    def AuditNo(self):
        return self._AuditNo

    @AuditNo.setter
    def AuditNo(self, AuditNo):
        self._AuditNo = AuditNo

    @property
    def ApiId(self):
        return self._ApiId

    @ApiId.setter
    def ApiId(self, ApiId):
        self._ApiId = ApiId

    @property
    def ApiName(self):
        return self._ApiName

    @ApiName.setter
    def ApiName(self, ApiName):
        self._ApiName = ApiName

    @property
    def ApiMethod(self):
        return self._ApiMethod

    @ApiMethod.setter
    def ApiMethod(self, ApiMethod):
        self._ApiMethod = ApiMethod

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def MNPName(self):
        return self._MNPName

    @MNPName.setter
    def MNPName(self, MNPName):
        self._MNPName = MNPName

    @property
    def ApplyUser(self):
        return self._ApplyUser

    @ApplyUser.setter
    def ApplyUser(self, ApplyUser):
        self._ApplyUser = ApplyUser

    @property
    def ApplyTime(self):
        return self._ApplyTime

    @ApplyTime.setter
    def ApplyTime(self, ApplyTime):
        self._ApplyTime = ApplyTime

    @property
    def ApplyNote(self):
        return self._ApplyNote

    @ApplyNote.setter
    def ApplyNote(self, ApplyNote):
        self._ApplyNote = ApplyNote

    @property
    def AuditStatus(self):
        return self._AuditStatus

    @AuditStatus.setter
    def AuditStatus(self, AuditStatus):
        self._AuditStatus = AuditStatus

    @property
    def AuditUser(self):
        return self._AuditUser

    @AuditUser.setter
    def AuditUser(self, AuditUser):
        self._AuditUser = AuditUser

    @property
    def AuditTime(self):
        return self._AuditTime

    @AuditTime.setter
    def AuditTime(self, AuditTime):
        self._AuditTime = AuditTime

    @property
    def AuditNote(self):
        return self._AuditNote

    @AuditNote.setter
    def AuditNote(self, AuditNote):
        self._AuditNote = AuditNote

    @property
    def ApplicationId(self):
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def ApplicationName(self):
        return self._ApplicationName

    @ApplicationName.setter
    def ApplicationName(self, ApplicationName):
        self._ApplicationName = ApplicationName

    @property
    def ApplicationLogo(self):
        return self._ApplicationLogo

    @ApplicationLogo.setter
    def ApplicationLogo(self, ApplicationLogo):
        self._ApplicationLogo = ApplicationLogo

    @property
    def ApiType(self):
        return self._ApiType

    @ApiType.setter
    def ApiType(self, ApiType):
        self._ApiType = ApiType

    @property
    def ApiDesc(self):
        return self._ApiDesc

    @ApiDesc.setter
    def ApiDesc(self, ApiDesc):
        self._ApiDesc = ApiDesc


    def _deserialize(self, params):
        self._AuditNo = params.get("AuditNo")
        self._ApiId = params.get("ApiId")
        self._ApiName = params.get("ApiName")
        self._ApiMethod = params.get("ApiMethod")
        self._MNPId = params.get("MNPId")
        self._MNPName = params.get("MNPName")
        self._ApplyUser = params.get("ApplyUser")
        self._ApplyTime = params.get("ApplyTime")
        self._ApplyNote = params.get("ApplyNote")
        self._AuditStatus = params.get("AuditStatus")
        self._AuditUser = params.get("AuditUser")
        self._AuditTime = params.get("AuditTime")
        self._AuditNote = params.get("AuditNote")
        self._ApplicationId = params.get("ApplicationId")
        self._ApplicationName = params.get("ApplicationName")
        self._ApplicationLogo = params.get("ApplicationLogo")
        self._ApiType = params.get("ApiType")
        self._ApiDesc = params.get("ApiDesc")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SensitiveApiInfoResp(AbstractModel):
    """Sensitive API information

    """

    def __init__(self):
        r"""
        :param _ApiId: APIID
        :type ApiId: str
        :param _ApiName: API name
        :type ApiName: str
        :param _ApiMethod: API method
        :type ApiMethod: str
        :param _ApiDesc: API description
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApiDesc: str
        :param _CreateUser: Creator
        :type CreateUser: str
        :param _CreateTime: Creation time
        :type CreateTime: str
        :param _UpdateUser: Updater
        :type UpdateUser: str
        :param _UpdateTime: Update date
        :type UpdateTime: str
        :param _ApplicationId: Application ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationId: str
        :param _ApplicationName: Application name
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationName: str
        :param _TeamId: Team ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamId: str
        :param _TeamName: Team name
Note: This field may return null, indicating that no valid values can be obtained.
        :type TeamName: str
        :param _ApplicationLogo: Application icon
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationLogo: str
        :param _APIType: API type 1 - System API 2 Custom API
Note: This field may return null, indicating that no valid values can be obtained.
        :type APIType: int
        :param _Status: API status 0 Public 1 Restricted
Note: This field may return null, indicating that no valid values can be obtained.
        :type Status: int
        """
        self._ApiId = None
        self._ApiName = None
        self._ApiMethod = None
        self._ApiDesc = None
        self._CreateUser = None
        self._CreateTime = None
        self._UpdateUser = None
        self._UpdateTime = None
        self._ApplicationId = None
        self._ApplicationName = None
        self._TeamId = None
        self._TeamName = None
        self._ApplicationLogo = None
        self._APIType = None
        self._Status = None

    @property
    def ApiId(self):
        return self._ApiId

    @ApiId.setter
    def ApiId(self, ApiId):
        self._ApiId = ApiId

    @property
    def ApiName(self):
        return self._ApiName

    @ApiName.setter
    def ApiName(self, ApiName):
        self._ApiName = ApiName

    @property
    def ApiMethod(self):
        return self._ApiMethod

    @ApiMethod.setter
    def ApiMethod(self, ApiMethod):
        self._ApiMethod = ApiMethod

    @property
    def ApiDesc(self):
        return self._ApiDesc

    @ApiDesc.setter
    def ApiDesc(self, ApiDesc):
        self._ApiDesc = ApiDesc

    @property
    def CreateUser(self):
        return self._CreateUser

    @CreateUser.setter
    def CreateUser(self, CreateUser):
        self._CreateUser = CreateUser

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateUser(self):
        return self._UpdateUser

    @UpdateUser.setter
    def UpdateUser(self, UpdateUser):
        self._UpdateUser = UpdateUser

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def ApplicationId(self):
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def ApplicationName(self):
        return self._ApplicationName

    @ApplicationName.setter
    def ApplicationName(self, ApplicationName):
        self._ApplicationName = ApplicationName

    @property
    def TeamId(self):
        return self._TeamId

    @TeamId.setter
    def TeamId(self, TeamId):
        self._TeamId = TeamId

    @property
    def TeamName(self):
        return self._TeamName

    @TeamName.setter
    def TeamName(self, TeamName):
        self._TeamName = TeamName

    @property
    def ApplicationLogo(self):
        return self._ApplicationLogo

    @ApplicationLogo.setter
    def ApplicationLogo(self, ApplicationLogo):
        self._ApplicationLogo = ApplicationLogo

    @property
    def APIType(self):
        return self._APIType

    @APIType.setter
    def APIType(self, APIType):
        self._APIType = APIType

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._ApiId = params.get("ApiId")
        self._ApiName = params.get("ApiName")
        self._ApiMethod = params.get("ApiMethod")
        self._ApiDesc = params.get("ApiDesc")
        self._CreateUser = params.get("CreateUser")
        self._CreateTime = params.get("CreateTime")
        self._UpdateUser = params.get("UpdateUser")
        self._UpdateTime = params.get("UpdateTime")
        self._ApplicationId = params.get("ApplicationId")
        self._ApplicationName = params.get("ApplicationName")
        self._TeamId = params.get("TeamId")
        self._TeamName = params.get("TeamName")
        self._ApplicationLogo = params.get("ApplicationLogo")
        self._APIType = params.get("APIType")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SensitiveApiPageInfo(AbstractModel):
    """Information of sensitive APIs

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of results.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _DataList: List information
Note: This field may return null, indicating that no valid values can be obtained.
        :type DataList: list of SensitiveApiInfoResp
        """
        self._TotalCount = None
        self._DataList = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DataList(self):
        return self._DataList

    @DataList.setter
    def DataList(self, DataList):
        self._DataList = DataList


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DataList") is not None:
            self._DataList = []
            for item in params.get("DataList"):
                obj = SensitiveApiInfoResp()
                obj._deserialize(item)
                self._DataList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ShowCaseRelAppInfo(AbstractModel):
    """Mini program associated application information

    """

    def __init__(self):
        r"""
        :param _ApplicationId: Application ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationId: str
        :param _ApplicationName: Application name
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationName: str
        :param _ApplicationAndUrl: Android URL
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationAndUrl: str
        :param _ApplicationIOSUrl: iOS URL
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationIOSUrl: str
        :param _ApplicationIcon: Application icon
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApplicationIcon: str
        """
        self._ApplicationId = None
        self._ApplicationName = None
        self._ApplicationAndUrl = None
        self._ApplicationIOSUrl = None
        self._ApplicationIcon = None

    @property
    def ApplicationId(self):
        return self._ApplicationId

    @ApplicationId.setter
    def ApplicationId(self, ApplicationId):
        self._ApplicationId = ApplicationId

    @property
    def ApplicationName(self):
        return self._ApplicationName

    @ApplicationName.setter
    def ApplicationName(self, ApplicationName):
        self._ApplicationName = ApplicationName

    @property
    def ApplicationAndUrl(self):
        return self._ApplicationAndUrl

    @ApplicationAndUrl.setter
    def ApplicationAndUrl(self, ApplicationAndUrl):
        self._ApplicationAndUrl = ApplicationAndUrl

    @property
    def ApplicationIOSUrl(self):
        return self._ApplicationIOSUrl

    @ApplicationIOSUrl.setter
    def ApplicationIOSUrl(self, ApplicationIOSUrl):
        self._ApplicationIOSUrl = ApplicationIOSUrl

    @property
    def ApplicationIcon(self):
        return self._ApplicationIcon

    @ApplicationIcon.setter
    def ApplicationIcon(self, ApplicationIcon):
        self._ApplicationIcon = ApplicationIcon


    def _deserialize(self, params):
        self._ApplicationId = params.get("ApplicationId")
        self._ApplicationName = params.get("ApplicationName")
        self._ApplicationAndUrl = params.get("ApplicationAndUrl")
        self._ApplicationIOSUrl = params.get("ApplicationIOSUrl")
        self._ApplicationIcon = params.get("ApplicationIcon")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SimpleStringKeyValue(AbstractModel):
    """General key, value map object

    """

    def __init__(self):
        r"""
        :param _Key: Key ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type Key: str
        :param _Value: Text description
Note: This field may return null, indicating that no valid values can be obtained.
        :type Value: str
        """
        self._Key = None
        self._Value = None

    @property
    def Key(self):
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key

    @property
    def Value(self):
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value


    def _deserialize(self, params):
        self._Key = params.get("Key")
        self._Value = params.get("Value")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class StringData(AbstractModel):
    """String data object

    """

    def __init__(self):
        r"""
        :param _Data: String type response data
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: str
        """
        self._Data = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data


    def _deserialize(self, params):
        self._Data = params.get("Data")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UploadFileTempSecret(AbstractModel):
    """Temporary key for file upload

    """

    def __init__(self):
        r"""
        :param _Bucket: Bucket
Note: This field may return null, indicating that no valid values can be obtained.
        :type Bucket: str
        :param _Region: Region
Note: This field may return null, indicating that no valid values can be obtained.
        :type Region: str
        :param _Path: Destination of upload
Note: This field may return null, indicating that no valid values can be obtained.
        :type Path: str
        :param _TempSecretId: Temporary secret ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type TempSecretId: str
        :param _TempSecretKey: Temporary secret key
Note: This field may return null, indicating that no valid values can be obtained.
        :type TempSecretKey: str
        :param _Token: Token 
Note: This field may return null, indicating that no valid values can be obtained.
        :type Token: str
        """
        self._Bucket = None
        self._Region = None
        self._Path = None
        self._TempSecretId = None
        self._TempSecretKey = None
        self._Token = None

    @property
    def Bucket(self):
        return self._Bucket

    @Bucket.setter
    def Bucket(self, Bucket):
        self._Bucket = Bucket

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Path(self):
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def TempSecretId(self):
        return self._TempSecretId

    @TempSecretId.setter
    def TempSecretId(self, TempSecretId):
        self._TempSecretId = TempSecretId

    @property
    def TempSecretKey(self):
        return self._TempSecretKey

    @TempSecretKey.setter
    def TempSecretKey(self, TempSecretKey):
        self._TempSecretKey = TempSecretKey

    @property
    def Token(self):
        return self._Token

    @Token.setter
    def Token(self, Token):
        self._Token = Token


    def _deserialize(self, params):
        self._Bucket = params.get("Bucket")
        self._Region = params.get("Region")
        self._Path = params.get("Path")
        self._TempSecretId = params.get("TempSecretId")
        self._TempSecretKey = params.get("TempSecretKey")
        self._Token = params.get("Token")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class VersionBoardResp(AbstractModel):
    """Information of the specified version of mini program

    """

    def __init__(self):
        r"""
        :param _MNPId: Mini program ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPId: str
        :param _MNPVersionId: Mini program version ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPVersionId: int
        :param _MNPName: Mini program name
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPName: str
        :param _MNPIcon: Mini program icon
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPIcon: str
        :param _MNPType: Mini program category
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPType: str
        :param _MNPIntro: Mini program introduction
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPIntro: str
        :param _MNPDesc: Mini program description
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPDesc: str
        :param _CreateUser: Developer
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateUser: str
        :param _CreateTime: The time when the developer created it
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        :param _MNPVersion: Mini program version
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPVersion: str
        :param _MNPVersionIntro: Version features
Note: This field may return null, indicating that no valid values can be obtained.
        :type MNPVersionIntro: str
        :param _Phase: Phase. Values: [Develop,Platform,Online]
Note: This field may return null, indicating that no valid values can be obtained.
        :type Phase: str
        :param _AuditStatus: 0: Pending; 1: Processing; 2: Rejected; 3: Approved; 4: Cancelled
Note: This field may return null, indicating that no valid values can be obtained.
        :type AuditStatus: int
        :param _AuditNo: Approval ticket ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type AuditNo: str
        :param _ShowCase: Whether it is a trial version. 
0: Not a trial version; 1: Trial version
Note: This field may return null, indicating that no valid values can be obtained.
        :type ShowCase: int
        :param _ScanStatus: Scanning status
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanStatus: int
        :param _ScanScore: Scan score
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanScore: int
        :param _RollbackVersion: Version number to roll back to
Note: This field may return null, indicating that no valid values can be obtained.
        :type RollbackVersion: int
        :param _Status: Release status
Note: This field may return null, indicating that no valid values can be obtained.
        :type Status: int
        :param _ScanHtmlPath: Address of the scan result
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanHtmlPath: str
        :param _VersionCurrentStatus: Version approval status. 0: Pending; 1: Processing; 2: Rejected; 3: Approved; 4: Cancelled
Note: This field may return null, indicating that no valid values can be obtained.
        :type VersionCurrentStatus: int
        """
        self._MNPId = None
        self._MNPVersionId = None
        self._MNPName = None
        self._MNPIcon = None
        self._MNPType = None
        self._MNPIntro = None
        self._MNPDesc = None
        self._CreateUser = None
        self._CreateTime = None
        self._MNPVersion = None
        self._MNPVersionIntro = None
        self._Phase = None
        self._AuditStatus = None
        self._AuditNo = None
        self._ShowCase = None
        self._ScanStatus = None
        self._ScanScore = None
        self._RollbackVersion = None
        self._Status = None
        self._ScanHtmlPath = None
        self._VersionCurrentStatus = None

    @property
    def MNPId(self):
        return self._MNPId

    @MNPId.setter
    def MNPId(self, MNPId):
        self._MNPId = MNPId

    @property
    def MNPVersionId(self):
        return self._MNPVersionId

    @MNPVersionId.setter
    def MNPVersionId(self, MNPVersionId):
        self._MNPVersionId = MNPVersionId

    @property
    def MNPName(self):
        return self._MNPName

    @MNPName.setter
    def MNPName(self, MNPName):
        self._MNPName = MNPName

    @property
    def MNPIcon(self):
        return self._MNPIcon

    @MNPIcon.setter
    def MNPIcon(self, MNPIcon):
        self._MNPIcon = MNPIcon

    @property
    def MNPType(self):
        return self._MNPType

    @MNPType.setter
    def MNPType(self, MNPType):
        self._MNPType = MNPType

    @property
    def MNPIntro(self):
        return self._MNPIntro

    @MNPIntro.setter
    def MNPIntro(self, MNPIntro):
        self._MNPIntro = MNPIntro

    @property
    def MNPDesc(self):
        return self._MNPDesc

    @MNPDesc.setter
    def MNPDesc(self, MNPDesc):
        self._MNPDesc = MNPDesc

    @property
    def CreateUser(self):
        return self._CreateUser

    @CreateUser.setter
    def CreateUser(self, CreateUser):
        self._CreateUser = CreateUser

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def MNPVersion(self):
        return self._MNPVersion

    @MNPVersion.setter
    def MNPVersion(self, MNPVersion):
        self._MNPVersion = MNPVersion

    @property
    def MNPVersionIntro(self):
        return self._MNPVersionIntro

    @MNPVersionIntro.setter
    def MNPVersionIntro(self, MNPVersionIntro):
        self._MNPVersionIntro = MNPVersionIntro

    @property
    def Phase(self):
        return self._Phase

    @Phase.setter
    def Phase(self, Phase):
        self._Phase = Phase

    @property
    def AuditStatus(self):
        return self._AuditStatus

    @AuditStatus.setter
    def AuditStatus(self, AuditStatus):
        self._AuditStatus = AuditStatus

    @property
    def AuditNo(self):
        return self._AuditNo

    @AuditNo.setter
    def AuditNo(self, AuditNo):
        self._AuditNo = AuditNo

    @property
    def ShowCase(self):
        return self._ShowCase

    @ShowCase.setter
    def ShowCase(self, ShowCase):
        self._ShowCase = ShowCase

    @property
    def ScanStatus(self):
        return self._ScanStatus

    @ScanStatus.setter
    def ScanStatus(self, ScanStatus):
        self._ScanStatus = ScanStatus

    @property
    def ScanScore(self):
        return self._ScanScore

    @ScanScore.setter
    def ScanScore(self, ScanScore):
        self._ScanScore = ScanScore

    @property
    def RollbackVersion(self):
        return self._RollbackVersion

    @RollbackVersion.setter
    def RollbackVersion(self, RollbackVersion):
        self._RollbackVersion = RollbackVersion

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ScanHtmlPath(self):
        return self._ScanHtmlPath

    @ScanHtmlPath.setter
    def ScanHtmlPath(self, ScanHtmlPath):
        self._ScanHtmlPath = ScanHtmlPath

    @property
    def VersionCurrentStatus(self):
        return self._VersionCurrentStatus

    @VersionCurrentStatus.setter
    def VersionCurrentStatus(self, VersionCurrentStatus):
        self._VersionCurrentStatus = VersionCurrentStatus


    def _deserialize(self, params):
        self._MNPId = params.get("MNPId")
        self._MNPVersionId = params.get("MNPVersionId")
        self._MNPName = params.get("MNPName")
        self._MNPIcon = params.get("MNPIcon")
        self._MNPType = params.get("MNPType")
        self._MNPIntro = params.get("MNPIntro")
        self._MNPDesc = params.get("MNPDesc")
        self._CreateUser = params.get("CreateUser")
        self._CreateTime = params.get("CreateTime")
        self._MNPVersion = params.get("MNPVersion")
        self._MNPVersionIntro = params.get("MNPVersionIntro")
        self._Phase = params.get("Phase")
        self._AuditStatus = params.get("AuditStatus")
        self._AuditNo = params.get("AuditNo")
        self._ShowCase = params.get("ShowCase")
        self._ScanStatus = params.get("ScanStatus")
        self._ScanScore = params.get("ScanScore")
        self._RollbackVersion = params.get("RollbackVersion")
        self._Status = params.get("Status")
        self._ScanHtmlPath = params.get("ScanHtmlPath")
        self._VersionCurrentStatus = params.get("VersionCurrentStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        