# -*- coding: utf8 -*-
# Copyright (c) 2017-2021 THL A29 Limited, a Tencent company. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class AddAntiFakeUrlRequest(AbstractModel):
    """AddAntiFakeUrl request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _Name: Name
        :type Name: str
        :param _Uri: uri
        :type Uri: str
        """
        self._Domain = None
        self._Name = None
        self._Uri = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Uri(self):
        return self._Uri

    @Uri.setter
    def Uri(self, Uri):
        self._Uri = Uri


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Name = params.get("Name")
        self._Uri = params.get("Uri")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddAntiFakeUrlResponse(AbstractModel):
    """AddAntiFakeUrl response structure.

    """

    def __init__(self):
        r"""
        :param _Result: Result
        :type Result: str
        :param _Id: Rule ID
        :type Id: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Result = None
        self._Id = None
        self._RequestId = None

    @property
    def Result(self):
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._Id = params.get("Id")
        self._RequestId = params.get("RequestId")


class AddAntiInfoLeakRulesRequest(AbstractModel):
    """AddAntiInfoLeakRules request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _Name: Rule name
        :type Name: str
        :param _ActionType: Actions: 0 (alarm), 1 (replace), 2 (only display the first four digits), 3 (only display the last four digits), 4 (block)
        :type ActionType: int
        :param _Strategies: Policy details
        :type Strategies: list of StrategyForAntiInfoLeak
        :param _Uri: URL
        :type Uri: str
        """
        self._Domain = None
        self._Name = None
        self._ActionType = None
        self._Strategies = None
        self._Uri = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def ActionType(self):
        return self._ActionType

    @ActionType.setter
    def ActionType(self, ActionType):
        self._ActionType = ActionType

    @property
    def Strategies(self):
        return self._Strategies

    @Strategies.setter
    def Strategies(self, Strategies):
        self._Strategies = Strategies

    @property
    def Uri(self):
        return self._Uri

    @Uri.setter
    def Uri(self, Uri):
        self._Uri = Uri


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Name = params.get("Name")
        self._ActionType = params.get("ActionType")
        if params.get("Strategies") is not None:
            self._Strategies = []
            for item in params.get("Strategies"):
                obj = StrategyForAntiInfoLeak()
                obj._deserialize(item)
                self._Strategies.append(obj)
        self._Uri = params.get("Uri")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddAntiInfoLeakRulesResponse(AbstractModel):
    """AddAntiInfoLeakRules response structure.

    """

    def __init__(self):
        r"""
        :param _RuleId: Rule ID
        :type RuleId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RuleId = None
        self._RequestId = None

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        self._RequestId = params.get("RequestId")


class AddCustomRuleRequest(AbstractModel):
    """AddCustomRule request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Rule name
        :type Name: str
        :param _SortId: Priority
        :type SortId: str
        :param _Strategies: Policy details
        :type Strategies: list of Strategy
        :param _Domain: Domain name for adding policy
        :type Domain: str
        :param _ActionType: Action type: 1 for Block, 2 captcha, 3 for Observe, 4 for Redirect
        :type ActionType: str
        :param _Redirect: If the action is redirect, it indicates the redirect address; otherwise, it can be left blank.
        :type Redirect: str
        :param _ExpireTime: Expiration time: in second-level timestamp, for example, 1677254399 indicates the expiration time is 2023-02-24 23:59:59; 0 indicates it will never expire.
        :type ExpireTime: str
        :param _Edition: WAF instance type: sparta-waf for SaaS WAF, clb-waf for CLB WAF.
        :type Edition: str
        :param _Bypass: Details of release
        :type Bypass: str
        :param _EventId: Source of the rule addition, default is empty
        :type EventId: str
        :param _JobType: Rule execution mode: TimedJob indicates scheduled execution. CronJob indicates periodic execution.
        :type JobType: str
        :param _JobDateTime: Rule execution time
        :type JobDateTime: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        :param _Source: Rule source. You can determine whether a rule comes from a mini program.
        :type Source: str
        :param _Label: Rule tag. It is used for mini program rules and identifies whether a rule is a built-in rule or a custom rule.
        :type Label: str
        :param _Status: Switch status. This value is passed when mini program risk control rules are used.
        :type Status: int
        :param _PageId: Interception page ID
        :type PageId: str
        """
        self._Name = None
        self._SortId = None
        self._Strategies = None
        self._Domain = None
        self._ActionType = None
        self._Redirect = None
        self._ExpireTime = None
        self._Edition = None
        self._Bypass = None
        self._EventId = None
        self._JobType = None
        self._JobDateTime = None
        self._Source = None
        self._Label = None
        self._Status = None
        self._PageId = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def SortId(self):
        return self._SortId

    @SortId.setter
    def SortId(self, SortId):
        self._SortId = SortId

    @property
    def Strategies(self):
        return self._Strategies

    @Strategies.setter
    def Strategies(self, Strategies):
        self._Strategies = Strategies

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def ActionType(self):
        return self._ActionType

    @ActionType.setter
    def ActionType(self, ActionType):
        self._ActionType = ActionType

    @property
    def Redirect(self):
        return self._Redirect

    @Redirect.setter
    def Redirect(self, Redirect):
        self._Redirect = Redirect

    @property
    def ExpireTime(self):
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def Edition(self):
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def Bypass(self):
        return self._Bypass

    @Bypass.setter
    def Bypass(self, Bypass):
        self._Bypass = Bypass

    @property
    def EventId(self):
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId

    @property
    def JobType(self):
        return self._JobType

    @JobType.setter
    def JobType(self, JobType):
        self._JobType = JobType

    @property
    def JobDateTime(self):
        return self._JobDateTime

    @JobDateTime.setter
    def JobDateTime(self, JobDateTime):
        self._JobDateTime = JobDateTime

    @property
    def Source(self):
        return self._Source

    @Source.setter
    def Source(self, Source):
        self._Source = Source

    @property
    def Label(self):
        return self._Label

    @Label.setter
    def Label(self, Label):
        self._Label = Label

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def PageId(self):
        return self._PageId

    @PageId.setter
    def PageId(self, PageId):
        self._PageId = PageId


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._SortId = params.get("SortId")
        if params.get("Strategies") is not None:
            self._Strategies = []
            for item in params.get("Strategies"):
                obj = Strategy()
                obj._deserialize(item)
                self._Strategies.append(obj)
        self._Domain = params.get("Domain")
        self._ActionType = params.get("ActionType")
        self._Redirect = params.get("Redirect")
        self._ExpireTime = params.get("ExpireTime")
        self._Edition = params.get("Edition")
        self._Bypass = params.get("Bypass")
        self._EventId = params.get("EventId")
        self._JobType = params.get("JobType")
        if params.get("JobDateTime") is not None:
            self._JobDateTime = JobDateTime()
            self._JobDateTime._deserialize(params.get("JobDateTime"))
        self._Source = params.get("Source")
        self._Label = params.get("Label")
        self._Status = params.get("Status")
        self._PageId = params.get("PageId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddCustomRuleResponse(AbstractModel):
    """AddCustomRule response structure.

    """

    def __init__(self):
        r"""
        :param _Success: Operation status code: if all resource operations succeed, the success status code is returned; if any resource operation fails, the content of Message needs to be parsed to see which resource failed.
        :type Success: :class:`tencentcloud.waf.v20180125.models.ResponseCode`
        :param _RuleId: Successfully added rule ID

Note: This field may return null, indicating that no valid values can be obtained.
        :type RuleId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Success = None
        self._RuleId = None
        self._RequestId = None

    @property
    def Success(self):
        return self._Success

    @Success.setter
    def Success(self, Success):
        self._Success = Success

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Success") is not None:
            self._Success = ResponseCode()
            self._Success._deserialize(params.get("Success"))
        self._RuleId = params.get("RuleId")
        self._RequestId = params.get("RequestId")


class AddCustomWhiteRuleRequest(AbstractModel):
    """AddCustomWhiteRule request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Rule name
        :type Name: str
        :param _SortId: Priority
        :type SortId: str
        :param _ExpireTime: Expiration time
        :type ExpireTime: str
        :param _Strategies: Policy details
        :type Strategies: list of Strategy
        :param _Domain: Domain name for adding policy
        :type Domain: str
        :param _Bypass: Details of release
        :type Bypass: str
        :param _JobType: Scheduled task type
        :type JobType: str
        :param _JobDateTime: Scheduled task configuration
        :type JobDateTime: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        """
        self._Name = None
        self._SortId = None
        self._ExpireTime = None
        self._Strategies = None
        self._Domain = None
        self._Bypass = None
        self._JobType = None
        self._JobDateTime = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def SortId(self):
        return self._SortId

    @SortId.setter
    def SortId(self, SortId):
        self._SortId = SortId

    @property
    def ExpireTime(self):
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def Strategies(self):
        return self._Strategies

    @Strategies.setter
    def Strategies(self, Strategies):
        self._Strategies = Strategies

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Bypass(self):
        return self._Bypass

    @Bypass.setter
    def Bypass(self, Bypass):
        self._Bypass = Bypass

    @property
    def JobType(self):
        return self._JobType

    @JobType.setter
    def JobType(self, JobType):
        self._JobType = JobType

    @property
    def JobDateTime(self):
        return self._JobDateTime

    @JobDateTime.setter
    def JobDateTime(self, JobDateTime):
        self._JobDateTime = JobDateTime


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._SortId = params.get("SortId")
        self._ExpireTime = params.get("ExpireTime")
        if params.get("Strategies") is not None:
            self._Strategies = []
            for item in params.get("Strategies"):
                obj = Strategy()
                obj._deserialize(item)
                self._Strategies.append(obj)
        self._Domain = params.get("Domain")
        self._Bypass = params.get("Bypass")
        self._JobType = params.get("JobType")
        if params.get("JobDateTime") is not None:
            self._JobDateTime = JobDateTime()
            self._JobDateTime._deserialize(params.get("JobDateTime"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddCustomWhiteRuleResponse(AbstractModel):
    """AddCustomWhiteRule response structure.

    """

    def __init__(self):
        r"""
        :param _Success: Operation status code: if all resource operations succeed, the success status code is returned; if any resource operation fails, the content of Message needs to be parsed to see which resource failed.
        :type Success: :class:`tencentcloud.waf.v20180125.models.ResponseCode`
        :param _RuleId: Successfully added rule ID

Note: This field may return null, indicating that no valid values can be obtained.
        :type RuleId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Success = None
        self._RuleId = None
        self._RequestId = None

    @property
    def Success(self):
        return self._Success

    @Success.setter
    def Success(self, Success):
        self._Success = Success

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Success") is not None:
            self._Success = ResponseCode()
            self._Success._deserialize(params.get("Success"))
        self._RuleId = params.get("RuleId")
        self._RequestId = params.get("RequestId")


class AddSpartaProtectionRequest(AbstractModel):
    """AddSpartaProtection request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain requiring protection
        :type Domain: str
        :param _CertType: Certificate type
0: no certificate, with only the HTTP listening port configured
1: self-owned certificate
2: managed certificate
        :type CertType: int
        :param _IsCdn: Whether a layer-7 proxy service is deployed before WAF
0: No proxy service deployed
1: Proxy service deployed, and WAF will use XFF to obtain the client IP address
2: Proxy service deployed and WAF will use remote_addr to obtain the client IP address
3: Proxy service deployed, and WAF will use a custom header in ip_headers to obtain the client IP address
        :type IsCdn: int
        :param _UpstreamType: Upstream type
0: proxy to upstream by IP address
1: proxy to upstream by domain name
        :type UpstreamType: int
        :param _IsWebsocket: Whether to enable websocket
0: disable
1: enable
        :type IsWebsocket: int
        :param _LoadBalance: Load balancing policy for upstream
0: round-robin
1: IP hash
2: weighted round-robin
        :type LoadBalance: str
        :param _Ports: Service port list configuration
NginxServerId: fill in '0' in this function
Port: listening port number
Protocol: port protocol
UpstreamPort: same as Port
UpstreamProtocol: same as Protocol
        :type Ports: list of PortItem
        :param _IsKeepAlive: (Required) Whether to enable persistent connection
0: non-persistent connection
1: persistent connection
        :type IsKeepAlive: str
        :param _InstanceID: (Required) Instance ID of the domain name
        :type InstanceID: str
        :param _Cert: When CertType is 1, this parameter is required, indicating the self-owned certificate chain
        :type Cert: str
        :param _PrivateKey: When CertType=1, this parameter is required, indicating the private key of the self-owned certificate.
        :type PrivateKey: str
        :param _SSLId: When CertType is 2, this parameter must be filled, indicating the certificate ID hosted on Tencent Cloud's SSL platform
        :type SSLId: str
        :param _ResourceId: To be deprecated, not required. WAF resource ID.
        :type ResourceId: str
        :param _IpHeaders: When IsCdn is 3, this parameter is required, indicating a custom header.
        :type IpHeaders: list of str
        :param _UpstreamScheme: Upstream protocol for HTTPS when the service is configured with an HTTPS port
http: Use the HTTP protocol for upstream. It is used together with HttpsUpstreamPort.
https: Use the HTTPS protocol for upstream.
        :type UpstreamScheme: str
        :param _HttpsUpstreamPort: HTTPS upstream port, required only when UpstreamScheme is http
        :type HttpsUpstreamPort: str
        :param _IsGray: To be deprecated, can be left blank. Whether to enable grayscale: 0 indicates not to enable grayscale.
        :type IsGray: int
        :param _GrayAreas: To be deprecated, can be left blank. Grayscale area.
        :type GrayAreas: list of str
        :param _HttpsRewrite: (Required) Whether to enable forced redirection from HTTP to HTTPS
0: do not force redirect
1: enable forced redirect
        :type HttpsRewrite: int
        :param _UpstreamDomain: Upstream domain when proxy to upstream by domain. When UpstreamType=1, this field needs to be filled
        :type UpstreamDomain: str
        :param _SrcList: Upstream IP list when IP is back to source. When UpstreamType=0, this field is required
        :type SrcList: list of str
        :param _IsHttp2: (Required) Whether to enable HTTP2. You should enable HTTPS as well.
0: disable
1: enable
        :type IsHttp2: int
        :param _Edition: WAF instance type. This parameter will be deprecated in later versions and is not required in the current version.
sparta-waf: SaaS WAF
clb-waf: CLB WAF
cdn-waf: web protection capability on CDN
        :type Edition: str
        :param _Anycast: To be deprecated, currently just fill in 0. Anycast IP type switch: 0 Ordinary IP, 1 Anycast IP
        :type Anycast: int
        :param _Weights: Weight of each IP in the back-to-source IP List, corresponding to SrcList. Required only when UpstreamType is 0, and SrcList contains multiple IPs, and LoadBalance is 2; otherwise, fill in [ ].
        :type Weights: list of int
        :param _ActiveCheck: (Required) Whether to enable active health check
0: disable
1: enable
        :type ActiveCheck: int
        :param _TLSVersion: TLS version information
        :type TLSVersion: int
        :param _CipherTemplate: (Required) Cipher suite template
0: default template
1: general template
2: security template
3: custom template
        :type CipherTemplate: int
        :param _Ciphers: Custom encryption suite list. When CipherTemplate is 3, this field is required, indicating the custom encryption suite, value obtained through DescribeCiphersDetail API.
        :type Ciphers: list of int
        :param _ProxyReadTimeout: Read timeout between WAF and upstream server, 300s by default.
        :type ProxyReadTimeout: int
        :param _ProxySendTimeout: WAF and upstream server write timeout, 300s by default.
        :type ProxySendTimeout: int
        :param _SniType: SNI type during WAF sending request to upstream
0: Disable SNI and do not configure server_name in client_hello.
1: Enable SNI. server_name in client_hello is a protected domain name.
2: Enable SNI. SNI is the origin server domain name during the domain name origin-pull.
3: Enable SNI. SNI is a custom domain name.
        :type SniType: int
        :param _SniHost: When SniType=3, this parameter is required, indicating a custom SNI;
        :type SniHost: str
        :param _XFFReset: Whether to enable XFF reset
0: disable
1: enable
        :type XFFReset: int
        :param _Note: Domain name remarks
        :type Note: str
        :param _UpstreamHost: Custom upstream host. The default value is an empty string, indicating that  protected domain is used as the upstream host.
        :type UpstreamHost: str
        :param _ProxyBuffer: Whether to enable caching. 0: disable; 1: enable.
        :type ProxyBuffer: int
        :param _ProbeStatus: 0: disable probe test; 1: enable probe test. The test is enabled by default.
        :type ProbeStatus: int
        """
        self._Domain = None
        self._CertType = None
        self._IsCdn = None
        self._UpstreamType = None
        self._IsWebsocket = None
        self._LoadBalance = None
        self._Ports = None
        self._IsKeepAlive = None
        self._InstanceID = None
        self._Cert = None
        self._PrivateKey = None
        self._SSLId = None
        self._ResourceId = None
        self._IpHeaders = None
        self._UpstreamScheme = None
        self._HttpsUpstreamPort = None
        self._IsGray = None
        self._GrayAreas = None
        self._HttpsRewrite = None
        self._UpstreamDomain = None
        self._SrcList = None
        self._IsHttp2 = None
        self._Edition = None
        self._Anycast = None
        self._Weights = None
        self._ActiveCheck = None
        self._TLSVersion = None
        self._CipherTemplate = None
        self._Ciphers = None
        self._ProxyReadTimeout = None
        self._ProxySendTimeout = None
        self._SniType = None
        self._SniHost = None
        self._XFFReset = None
        self._Note = None
        self._UpstreamHost = None
        self._ProxyBuffer = None
        self._ProbeStatus = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def CertType(self):
        return self._CertType

    @CertType.setter
    def CertType(self, CertType):
        self._CertType = CertType

    @property
    def IsCdn(self):
        return self._IsCdn

    @IsCdn.setter
    def IsCdn(self, IsCdn):
        self._IsCdn = IsCdn

    @property
    def UpstreamType(self):
        return self._UpstreamType

    @UpstreamType.setter
    def UpstreamType(self, UpstreamType):
        self._UpstreamType = UpstreamType

    @property
    def IsWebsocket(self):
        return self._IsWebsocket

    @IsWebsocket.setter
    def IsWebsocket(self, IsWebsocket):
        self._IsWebsocket = IsWebsocket

    @property
    def LoadBalance(self):
        return self._LoadBalance

    @LoadBalance.setter
    def LoadBalance(self, LoadBalance):
        self._LoadBalance = LoadBalance

    @property
    def Ports(self):
        return self._Ports

    @Ports.setter
    def Ports(self, Ports):
        self._Ports = Ports

    @property
    def IsKeepAlive(self):
        return self._IsKeepAlive

    @IsKeepAlive.setter
    def IsKeepAlive(self, IsKeepAlive):
        self._IsKeepAlive = IsKeepAlive

    @property
    def InstanceID(self):
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID

    @property
    def Cert(self):
        return self._Cert

    @Cert.setter
    def Cert(self, Cert):
        self._Cert = Cert

    @property
    def PrivateKey(self):
        return self._PrivateKey

    @PrivateKey.setter
    def PrivateKey(self, PrivateKey):
        self._PrivateKey = PrivateKey

    @property
    def SSLId(self):
        return self._SSLId

    @SSLId.setter
    def SSLId(self, SSLId):
        self._SSLId = SSLId

    @property
    def ResourceId(self):
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId

    @property
    def IpHeaders(self):
        return self._IpHeaders

    @IpHeaders.setter
    def IpHeaders(self, IpHeaders):
        self._IpHeaders = IpHeaders

    @property
    def UpstreamScheme(self):
        return self._UpstreamScheme

    @UpstreamScheme.setter
    def UpstreamScheme(self, UpstreamScheme):
        self._UpstreamScheme = UpstreamScheme

    @property
    def HttpsUpstreamPort(self):
        return self._HttpsUpstreamPort

    @HttpsUpstreamPort.setter
    def HttpsUpstreamPort(self, HttpsUpstreamPort):
        self._HttpsUpstreamPort = HttpsUpstreamPort

    @property
    def IsGray(self):
        return self._IsGray

    @IsGray.setter
    def IsGray(self, IsGray):
        self._IsGray = IsGray

    @property
    def GrayAreas(self):
        return self._GrayAreas

    @GrayAreas.setter
    def GrayAreas(self, GrayAreas):
        self._GrayAreas = GrayAreas

    @property
    def HttpsRewrite(self):
        return self._HttpsRewrite

    @HttpsRewrite.setter
    def HttpsRewrite(self, HttpsRewrite):
        self._HttpsRewrite = HttpsRewrite

    @property
    def UpstreamDomain(self):
        return self._UpstreamDomain

    @UpstreamDomain.setter
    def UpstreamDomain(self, UpstreamDomain):
        self._UpstreamDomain = UpstreamDomain

    @property
    def SrcList(self):
        return self._SrcList

    @SrcList.setter
    def SrcList(self, SrcList):
        self._SrcList = SrcList

    @property
    def IsHttp2(self):
        return self._IsHttp2

    @IsHttp2.setter
    def IsHttp2(self, IsHttp2):
        self._IsHttp2 = IsHttp2

    @property
    def Edition(self):
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def Anycast(self):
        return self._Anycast

    @Anycast.setter
    def Anycast(self, Anycast):
        self._Anycast = Anycast

    @property
    def Weights(self):
        return self._Weights

    @Weights.setter
    def Weights(self, Weights):
        self._Weights = Weights

    @property
    def ActiveCheck(self):
        return self._ActiveCheck

    @ActiveCheck.setter
    def ActiveCheck(self, ActiveCheck):
        self._ActiveCheck = ActiveCheck

    @property
    def TLSVersion(self):
        return self._TLSVersion

    @TLSVersion.setter
    def TLSVersion(self, TLSVersion):
        self._TLSVersion = TLSVersion

    @property
    def CipherTemplate(self):
        return self._CipherTemplate

    @CipherTemplate.setter
    def CipherTemplate(self, CipherTemplate):
        self._CipherTemplate = CipherTemplate

    @property
    def Ciphers(self):
        return self._Ciphers

    @Ciphers.setter
    def Ciphers(self, Ciphers):
        self._Ciphers = Ciphers

    @property
    def ProxyReadTimeout(self):
        return self._ProxyReadTimeout

    @ProxyReadTimeout.setter
    def ProxyReadTimeout(self, ProxyReadTimeout):
        self._ProxyReadTimeout = ProxyReadTimeout

    @property
    def ProxySendTimeout(self):
        return self._ProxySendTimeout

    @ProxySendTimeout.setter
    def ProxySendTimeout(self, ProxySendTimeout):
        self._ProxySendTimeout = ProxySendTimeout

    @property
    def SniType(self):
        return self._SniType

    @SniType.setter
    def SniType(self, SniType):
        self._SniType = SniType

    @property
    def SniHost(self):
        return self._SniHost

    @SniHost.setter
    def SniHost(self, SniHost):
        self._SniHost = SniHost

    @property
    def XFFReset(self):
        return self._XFFReset

    @XFFReset.setter
    def XFFReset(self, XFFReset):
        self._XFFReset = XFFReset

    @property
    def Note(self):
        return self._Note

    @Note.setter
    def Note(self, Note):
        self._Note = Note

    @property
    def UpstreamHost(self):
        return self._UpstreamHost

    @UpstreamHost.setter
    def UpstreamHost(self, UpstreamHost):
        self._UpstreamHost = UpstreamHost

    @property
    def ProxyBuffer(self):
        return self._ProxyBuffer

    @ProxyBuffer.setter
    def ProxyBuffer(self, ProxyBuffer):
        self._ProxyBuffer = ProxyBuffer

    @property
    def ProbeStatus(self):
        return self._ProbeStatus

    @ProbeStatus.setter
    def ProbeStatus(self, ProbeStatus):
        self._ProbeStatus = ProbeStatus


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._CertType = params.get("CertType")
        self._IsCdn = params.get("IsCdn")
        self._UpstreamType = params.get("UpstreamType")
        self._IsWebsocket = params.get("IsWebsocket")
        self._LoadBalance = params.get("LoadBalance")
        if params.get("Ports") is not None:
            self._Ports = []
            for item in params.get("Ports"):
                obj = PortItem()
                obj._deserialize(item)
                self._Ports.append(obj)
        self._IsKeepAlive = params.get("IsKeepAlive")
        self._InstanceID = params.get("InstanceID")
        self._Cert = params.get("Cert")
        self._PrivateKey = params.get("PrivateKey")
        self._SSLId = params.get("SSLId")
        self._ResourceId = params.get("ResourceId")
        self._IpHeaders = params.get("IpHeaders")
        self._UpstreamScheme = params.get("UpstreamScheme")
        self._HttpsUpstreamPort = params.get("HttpsUpstreamPort")
        self._IsGray = params.get("IsGray")
        self._GrayAreas = params.get("GrayAreas")
        self._HttpsRewrite = params.get("HttpsRewrite")
        self._UpstreamDomain = params.get("UpstreamDomain")
        self._SrcList = params.get("SrcList")
        self._IsHttp2 = params.get("IsHttp2")
        self._Edition = params.get("Edition")
        self._Anycast = params.get("Anycast")
        self._Weights = params.get("Weights")
        self._ActiveCheck = params.get("ActiveCheck")
        self._TLSVersion = params.get("TLSVersion")
        self._CipherTemplate = params.get("CipherTemplate")
        self._Ciphers = params.get("Ciphers")
        self._ProxyReadTimeout = params.get("ProxyReadTimeout")
        self._ProxySendTimeout = params.get("ProxySendTimeout")
        self._SniType = params.get("SniType")
        self._SniHost = params.get("SniHost")
        self._XFFReset = params.get("XFFReset")
        self._Note = params.get("Note")
        self._UpstreamHost = params.get("UpstreamHost")
        self._ProxyBuffer = params.get("ProxyBuffer")
        self._ProbeStatus = params.get("ProbeStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddSpartaProtectionResponse(AbstractModel):
    """AddSpartaProtection response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ApiPkg(AbstractModel):
    """API security resource information

    """

    def __init__(self):
        r"""
        :param _ResourceIds: Resource ID

Note: This field may return null, indicating that no valid values can be obtained.
        :type ResourceIds: str
        :param _Status: Status

Note: This field may return null, indicating that no valid values can be obtained.
        :type Status: int
        :param _Region: Region

Note: This field may return null, indicating that no valid values can be obtained.
        :type Region: int
        :param _BeginTime: Start time

Note: This field may return null, indicating that no valid values can be obtained.
        :type BeginTime: str
        :param _EndTime: End time

Note: This field may return null, indicating that no valid values can be obtained.
        :type EndTime: str
        :param _InquireNum: Application Quantity

Note: This field may return null, indicating that no valid values can be obtained.
        :type InquireNum: int
        :param _UsedNum: Usage Quantity

Note: This field may return null, indicating that no valid values can be obtained.
        :type UsedNum: int
        :param _RenewFlag: Renewal flag.
Note: This field may return null, indicating that no valid values can be obtained.
        :type RenewFlag: int
        :param _BillingItem: Billing item.
Note: This field may return null, indicating that no valid values can be obtained.
        :type BillingItem: str
        :param _IsAPISecurityTrial: API security 7-day trial flag. 1 for trial. 0 for no trial.

Note: This field may return null, indicating that no valid values can be obtained.
        :type IsAPISecurityTrial: int
        """
        self._ResourceIds = None
        self._Status = None
        self._Region = None
        self._BeginTime = None
        self._EndTime = None
        self._InquireNum = None
        self._UsedNum = None
        self._RenewFlag = None
        self._BillingItem = None
        self._IsAPISecurityTrial = None

    @property
    def ResourceIds(self):
        return self._ResourceIds

    @ResourceIds.setter
    def ResourceIds(self, ResourceIds):
        self._ResourceIds = ResourceIds

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def BeginTime(self):
        return self._BeginTime

    @BeginTime.setter
    def BeginTime(self, BeginTime):
        self._BeginTime = BeginTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def InquireNum(self):
        return self._InquireNum

    @InquireNum.setter
    def InquireNum(self, InquireNum):
        self._InquireNum = InquireNum

    @property
    def UsedNum(self):
        return self._UsedNum

    @UsedNum.setter
    def UsedNum(self, UsedNum):
        self._UsedNum = UsedNum

    @property
    def RenewFlag(self):
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag

    @property
    def BillingItem(self):
        return self._BillingItem

    @BillingItem.setter
    def BillingItem(self, BillingItem):
        self._BillingItem = BillingItem

    @property
    def IsAPISecurityTrial(self):
        return self._IsAPISecurityTrial

    @IsAPISecurityTrial.setter
    def IsAPISecurityTrial(self, IsAPISecurityTrial):
        self._IsAPISecurityTrial = IsAPISecurityTrial


    def _deserialize(self, params):
        self._ResourceIds = params.get("ResourceIds")
        self._Status = params.get("Status")
        self._Region = params.get("Region")
        self._BeginTime = params.get("BeginTime")
        self._EndTime = params.get("EndTime")
        self._InquireNum = params.get("InquireNum")
        self._UsedNum = params.get("UsedNum")
        self._RenewFlag = params.get("RenewFlag")
        self._BillingItem = params.get("BillingItem")
        self._IsAPISecurityTrial = params.get("IsAPISecurityTrial")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchIpAccessControlData(AbstractModel):
    """Returned description of the multi-domain blocklist/allowlist

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number
        :type TotalCount: int
        :param _Res: Entries of blocklist/allowlist
        :type Res: list of BatchIpAccessControlItem
        """
        self._TotalCount = None
        self._Res = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Res(self):
        return self._Res

    @Res.setter
    def Res(self, Res):
        self._Res = Res


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Res") is not None:
            self._Res = []
            for item in params.get("Res"):
                obj = BatchIpAccessControlItem()
                obj._deserialize(item)
                self._Res.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchIpAccessControlItem(AbstractModel):
    """Batch multi-domain blocklist/allowlist IP list

    """

    def __init__(self):
        r"""
        :param _Id: MongoDB Table Auto-increment ID

Note: This field may return null, indicating that no valid values can be obtained.
        :type Id: str
        :param _ActionType: Blocklist 42 or allowlist 40
        :type ActionType: int
        :param _Ip: IP of the blocklist/allowlist
        :type Ip: str
        :param _Note: Remarks
        :type Note: str
        :param _Source: Path addition
        :type Source: str
        :param _TsVersion: Modification time
        :type TsVersion: int
        :param _ValidTs: Timeout period
        :type ValidTs: int
        :param _Hosts: Domain name list
        :type Hosts: list of str
        :param _RuleId: 55101145
Note: This field may return null, indicating that no valid values can be obtained.
        :type RuleId: int
        :param _IpList: IP list
Note: This field may return null, indicating that no valid values can be obtained.
        :type IpList: list of str
        :param _CreateTime: Creation time

Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: int
        :param _JobType: Scheduled task type
Note: This field may return null, indicating that no valid values can be obtained.
        :type JobType: str
        :param _CronType: Periodic task type
Note: This field may return null, indicating that no valid values can be obtained.
        :type CronType: str
        :param _JobDateTime: Scheduled task configuration details
Note: This field may return null, indicating that no valid values can be obtained.
        :type JobDateTime: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        :param _ValidStatus: Effective status
Note: This field may return null, indicating that no valid values can be obtained.
        :type ValidStatus: int
        """
        self._Id = None
        self._ActionType = None
        self._Ip = None
        self._Note = None
        self._Source = None
        self._TsVersion = None
        self._ValidTs = None
        self._Hosts = None
        self._RuleId = None
        self._IpList = None
        self._CreateTime = None
        self._JobType = None
        self._CronType = None
        self._JobDateTime = None
        self._ValidStatus = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def ActionType(self):
        return self._ActionType

    @ActionType.setter
    def ActionType(self, ActionType):
        self._ActionType = ActionType

    @property
    def Ip(self):
        return self._Ip

    @Ip.setter
    def Ip(self, Ip):
        self._Ip = Ip

    @property
    def Note(self):
        return self._Note

    @Note.setter
    def Note(self, Note):
        self._Note = Note

    @property
    def Source(self):
        return self._Source

    @Source.setter
    def Source(self, Source):
        self._Source = Source

    @property
    def TsVersion(self):
        return self._TsVersion

    @TsVersion.setter
    def TsVersion(self, TsVersion):
        self._TsVersion = TsVersion

    @property
    def ValidTs(self):
        return self._ValidTs

    @ValidTs.setter
    def ValidTs(self, ValidTs):
        self._ValidTs = ValidTs

    @property
    def Hosts(self):
        return self._Hosts

    @Hosts.setter
    def Hosts(self, Hosts):
        self._Hosts = Hosts

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def IpList(self):
        return self._IpList

    @IpList.setter
    def IpList(self, IpList):
        self._IpList = IpList

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def JobType(self):
        return self._JobType

    @JobType.setter
    def JobType(self, JobType):
        self._JobType = JobType

    @property
    def CronType(self):
        return self._CronType

    @CronType.setter
    def CronType(self, CronType):
        self._CronType = CronType

    @property
    def JobDateTime(self):
        return self._JobDateTime

    @JobDateTime.setter
    def JobDateTime(self, JobDateTime):
        self._JobDateTime = JobDateTime

    @property
    def ValidStatus(self):
        return self._ValidStatus

    @ValidStatus.setter
    def ValidStatus(self, ValidStatus):
        self._ValidStatus = ValidStatus


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._ActionType = params.get("ActionType")
        self._Ip = params.get("Ip")
        self._Note = params.get("Note")
        self._Source = params.get("Source")
        self._TsVersion = params.get("TsVersion")
        self._ValidTs = params.get("ValidTs")
        self._Hosts = params.get("Hosts")
        self._RuleId = params.get("RuleId")
        self._IpList = params.get("IpList")
        self._CreateTime = params.get("CreateTime")
        self._JobType = params.get("JobType")
        self._CronType = params.get("CronType")
        if params.get("JobDateTime") is not None:
            self._JobDateTime = JobDateTime()
            self._JobDateTime._deserialize(params.get("JobDateTime"))
        self._ValidStatus = params.get("ValidStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BotPkg(AbstractModel):
    """Bot Resource Information

    """

    def __init__(self):
        r"""
        :param _ResourceIds: Resource ID

Note: This field may return null, indicating that no valid values can be obtained.
        :type ResourceIds: str
        :param _Status: Status

Note: This field may return null, indicating that no valid values can be obtained.
        :type Status: int
        :param _Region: Region

Note: This field may return null, indicating that no valid values can be obtained.
        :type Region: int
        :param _BeginTime: Start time

Note: This field may return null, indicating that no valid values can be obtained.
        :type BeginTime: str
        :param _EndTime: End time

Note: This field may return null, indicating that no valid values can be obtained.
        :type EndTime: str
        :param _InquireNum: Application Quantity

Note: This field may return null, indicating that no valid values can be obtained.
        :type InquireNum: int
        :param _UsedNum: Usage Quantity

Note: This field may return null, indicating that no valid values can be obtained.
        :type UsedNum: int
        :param _Type: Sub-product code.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Type: str
        :param _RenewFlag: Renewal flag.	
Note: This field may return null, indicating that no valid values can be obtained.
        :type RenewFlag: int
        :param _BotCPWaf: Purchase Page Bot 40% Off

Note: This field may return null, indicating that no valid values can be obtained.
        :type BotCPWaf: int
        :param _BotNPWaf: Console Buy Bot with 50% Off

Note: This field may return null, indicating that no valid values can be obtained.
        :type BotNPWaf: int
        :param _IsBotTrial: 7-day Bot Trial Identification, 1 for Trial, 0 for No Trial

Note: This field may return null, indicating that no valid values can be obtained.
        :type IsBotTrial: int
        """
        self._ResourceIds = None
        self._Status = None
        self._Region = None
        self._BeginTime = None
        self._EndTime = None
        self._InquireNum = None
        self._UsedNum = None
        self._Type = None
        self._RenewFlag = None
        self._BotCPWaf = None
        self._BotNPWaf = None
        self._IsBotTrial = None

    @property
    def ResourceIds(self):
        return self._ResourceIds

    @ResourceIds.setter
    def ResourceIds(self, ResourceIds):
        self._ResourceIds = ResourceIds

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def BeginTime(self):
        return self._BeginTime

    @BeginTime.setter
    def BeginTime(self, BeginTime):
        self._BeginTime = BeginTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def InquireNum(self):
        return self._InquireNum

    @InquireNum.setter
    def InquireNum(self, InquireNum):
        self._InquireNum = InquireNum

    @property
    def UsedNum(self):
        return self._UsedNum

    @UsedNum.setter
    def UsedNum(self, UsedNum):
        self._UsedNum = UsedNum

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def RenewFlag(self):
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag

    @property
    def BotCPWaf(self):
        return self._BotCPWaf

    @BotCPWaf.setter
    def BotCPWaf(self, BotCPWaf):
        self._BotCPWaf = BotCPWaf

    @property
    def BotNPWaf(self):
        return self._BotNPWaf

    @BotNPWaf.setter
    def BotNPWaf(self, BotNPWaf):
        self._BotNPWaf = BotNPWaf

    @property
    def IsBotTrial(self):
        return self._IsBotTrial

    @IsBotTrial.setter
    def IsBotTrial(self, IsBotTrial):
        self._IsBotTrial = IsBotTrial


    def _deserialize(self, params):
        self._ResourceIds = params.get("ResourceIds")
        self._Status = params.get("Status")
        self._Region = params.get("Region")
        self._BeginTime = params.get("BeginTime")
        self._EndTime = params.get("EndTime")
        self._InquireNum = params.get("InquireNum")
        self._UsedNum = params.get("UsedNum")
        self._Type = params.get("Type")
        self._RenewFlag = params.get("RenewFlag")
        self._BotCPWaf = params.get("BotCPWaf")
        self._BotNPWaf = params.get("BotNPWaf")
        self._IsBotTrial = params.get("IsBotTrial")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BotQPS(AbstractModel):
    """Bot's QPS details

    """

    def __init__(self):
        r"""
        :param _ResourceIds: Resource ID
        :type ResourceIds: str
        :param _ValidTime: Expiration time
        :type ValidTime: str
        :param _Count: Resource quantity.
        :type Count: int
        :param _Region: Resource Location
        :type Region: str
        :param _MaxBotQPS: Maximum QPS Usage
        :type MaxBotQPS: int
        :param _RenewFlag: Renewal flag.
Note: This field may return null, indicating that no valid values can be obtained.
        :type RenewFlag: int
        """
        self._ResourceIds = None
        self._ValidTime = None
        self._Count = None
        self._Region = None
        self._MaxBotQPS = None
        self._RenewFlag = None

    @property
    def ResourceIds(self):
        return self._ResourceIds

    @ResourceIds.setter
    def ResourceIds(self, ResourceIds):
        self._ResourceIds = ResourceIds

    @property
    def ValidTime(self):
        return self._ValidTime

    @ValidTime.setter
    def ValidTime(self, ValidTime):
        self._ValidTime = ValidTime

    @property
    def Count(self):
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def MaxBotQPS(self):
        return self._MaxBotQPS

    @MaxBotQPS.setter
    def MaxBotQPS(self, MaxBotQPS):
        self._MaxBotQPS = MaxBotQPS

    @property
    def RenewFlag(self):
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag


    def _deserialize(self, params):
        self._ResourceIds = params.get("ResourceIds")
        self._ValidTime = params.get("ValidTime")
        self._Count = params.get("Count")
        self._Region = params.get("Region")
        self._MaxBotQPS = params.get("MaxBotQPS")
        self._RenewFlag = params.get("RenewFlag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CCRuleData(AbstractModel):
    """Data Encapsulation

    """

    def __init__(self):
        r"""
        :param _Res: CC rules
        :type Res: list of CCRuleItem
        :param _TotalCount: Number of Rules
        :type TotalCount: int
        """
        self._Res = None
        self._TotalCount = None

    @property
    def Res(self):
        return self._Res

    @Res.setter
    def Res(self, Res):
        self._Res = Res

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount


    def _deserialize(self, params):
        if params.get("Res") is not None:
            self._Res = []
            for item in params.get("Res"):
                obj = CCRuleItem()
                obj._deserialize(item)
                self._Res.append(obj)
        self._TotalCount = params.get("TotalCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CCRuleItem(AbstractModel):
    """CC rules

    """

    def __init__(self):
        r"""
        :param _ActionType: Action
        :type ActionType: int
        :param _Advance: Advanced mode
        :type Advance: int
        :param _Interval: Time period
        :type Interval: int
        :param _Limit: Limit Attempts
        :type Limit: int
        :param _MatchFunc: Matching Method
        :type MatchFunc: int
        :param _Name: Name
        :type Name: str
        :param _Priority: Priority
        :type Priority: int
        :param _Status: Status
        :type Status: int
        :param _TsVersion: Update Timestamp
        :type TsVersion: int
        :param _Url: Matching URL
        :type Url: str
        :param _ValidTime: Policy Action Validity Period
        :type ValidTime: int
        :param _OptionsArr: Advanced Parameters

Note: This field may return null, indicating that no valid values can be obtained.
        :type OptionsArr: str
        :param _Length: URL length
Note: This field may return null, indicating that no valid values can be obtained.
        :type Length: int
        :param _RuleId: Rule ID

Note: This field may return null, indicating that no valid values can be obtained.
        :type RuleId: int
        :param _EventId: Event ID

Note: This field may return null, indicating that no valid values can be obtained.
        :type EventId: str
        :param _SessionApplied: Associated session rules

Note: This field may return null, indicating that no valid values can be obtained.
        :type SessionApplied: list of int
        :param _CreateTime: Creation time

Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: int
        """
        self._ActionType = None
        self._Advance = None
        self._Interval = None
        self._Limit = None
        self._MatchFunc = None
        self._Name = None
        self._Priority = None
        self._Status = None
        self._TsVersion = None
        self._Url = None
        self._ValidTime = None
        self._OptionsArr = None
        self._Length = None
        self._RuleId = None
        self._EventId = None
        self._SessionApplied = None
        self._CreateTime = None

    @property
    def ActionType(self):
        return self._ActionType

    @ActionType.setter
    def ActionType(self, ActionType):
        self._ActionType = ActionType

    @property
    def Advance(self):
        return self._Advance

    @Advance.setter
    def Advance(self, Advance):
        self._Advance = Advance

    @property
    def Interval(self):
        return self._Interval

    @Interval.setter
    def Interval(self, Interval):
        self._Interval = Interval

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def MatchFunc(self):
        return self._MatchFunc

    @MatchFunc.setter
    def MatchFunc(self, MatchFunc):
        self._MatchFunc = MatchFunc

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Priority(self):
        return self._Priority

    @Priority.setter
    def Priority(self, Priority):
        self._Priority = Priority

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def TsVersion(self):
        return self._TsVersion

    @TsVersion.setter
    def TsVersion(self, TsVersion):
        self._TsVersion = TsVersion

    @property
    def Url(self):
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def ValidTime(self):
        return self._ValidTime

    @ValidTime.setter
    def ValidTime(self, ValidTime):
        self._ValidTime = ValidTime

    @property
    def OptionsArr(self):
        return self._OptionsArr

    @OptionsArr.setter
    def OptionsArr(self, OptionsArr):
        self._OptionsArr = OptionsArr

    @property
    def Length(self):
        return self._Length

    @Length.setter
    def Length(self, Length):
        self._Length = Length

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def EventId(self):
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId

    @property
    def SessionApplied(self):
        return self._SessionApplied

    @SessionApplied.setter
    def SessionApplied(self, SessionApplied):
        self._SessionApplied = SessionApplied

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime


    def _deserialize(self, params):
        self._ActionType = params.get("ActionType")
        self._Advance = params.get("Advance")
        self._Interval = params.get("Interval")
        self._Limit = params.get("Limit")
        self._MatchFunc = params.get("MatchFunc")
        self._Name = params.get("Name")
        self._Priority = params.get("Priority")
        self._Status = params.get("Status")
        self._TsVersion = params.get("TsVersion")
        self._Url = params.get("Url")
        self._ValidTime = params.get("ValidTime")
        self._OptionsArr = params.get("OptionsArr")
        self._Length = params.get("Length")
        self._RuleId = params.get("RuleId")
        self._EventId = params.get("EventId")
        self._SessionApplied = params.get("SessionApplied")
        self._CreateTime = params.get("CreateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CCRuleItems(AbstractModel):
    """CC rule details

    """

    def __init__(self):
        r"""
        :param _Name: Name
        :type Name: str
        :param _Status: Status
        :type Status: int
        :param _Advance: Mode
        :type Advance: int
        :param _Limit: Limit
        :type Limit: int
        :param _Interval: Detection interval
        :type Interval: int
        :param _Url: URL
        :type Url: str
        :param _MatchFunc: Type to match
        :type MatchFunc: int
        :param _ActionType: Action
        :type ActionType: int
        :param _Priority: Priority
        :type Priority: int
        :param _ValidTime: Expiration time
        :type ValidTime: int
        :param _TsVersion: Version
        :type TsVersion: int
        :param _Options: Rule details
        :type Options: str
        :param _RuleId: Rule ID
        :type RuleId: int
        :param _EventId: Event ID

Note: This field may return null, indicating that no valid values can be obtained.
        :type EventId: str
        :param _SessionApplied: Associated session rules

Note: This field may return null, indicating that no valid values can be obtained.
        :type SessionApplied: list of int
        :param _CreateTime: Creation time

Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: int
        """
        self._Name = None
        self._Status = None
        self._Advance = None
        self._Limit = None
        self._Interval = None
        self._Url = None
        self._MatchFunc = None
        self._ActionType = None
        self._Priority = None
        self._ValidTime = None
        self._TsVersion = None
        self._Options = None
        self._RuleId = None
        self._EventId = None
        self._SessionApplied = None
        self._CreateTime = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Advance(self):
        return self._Advance

    @Advance.setter
    def Advance(self, Advance):
        self._Advance = Advance

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Interval(self):
        return self._Interval

    @Interval.setter
    def Interval(self, Interval):
        self._Interval = Interval

    @property
    def Url(self):
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def MatchFunc(self):
        return self._MatchFunc

    @MatchFunc.setter
    def MatchFunc(self, MatchFunc):
        self._MatchFunc = MatchFunc

    @property
    def ActionType(self):
        return self._ActionType

    @ActionType.setter
    def ActionType(self, ActionType):
        self._ActionType = ActionType

    @property
    def Priority(self):
        return self._Priority

    @Priority.setter
    def Priority(self, Priority):
        self._Priority = Priority

    @property
    def ValidTime(self):
        return self._ValidTime

    @ValidTime.setter
    def ValidTime(self, ValidTime):
        self._ValidTime = ValidTime

    @property
    def TsVersion(self):
        return self._TsVersion

    @TsVersion.setter
    def TsVersion(self, TsVersion):
        self._TsVersion = TsVersion

    @property
    def Options(self):
        return self._Options

    @Options.setter
    def Options(self, Options):
        self._Options = Options

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def EventId(self):
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId

    @property
    def SessionApplied(self):
        return self._SessionApplied

    @SessionApplied.setter
    def SessionApplied(self, SessionApplied):
        self._SessionApplied = SessionApplied

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Status = params.get("Status")
        self._Advance = params.get("Advance")
        self._Limit = params.get("Limit")
        self._Interval = params.get("Interval")
        self._Url = params.get("Url")
        self._MatchFunc = params.get("MatchFunc")
        self._ActionType = params.get("ActionType")
        self._Priority = params.get("Priority")
        self._ValidTime = params.get("ValidTime")
        self._TsVersion = params.get("TsVersion")
        self._Options = params.get("Options")
        self._RuleId = params.get("RuleId")
        self._EventId = params.get("EventId")
        self._SessionApplied = params.get("SessionApplied")
        self._CreateTime = params.get("CreateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CCRuleLists(AbstractModel):
    """CC rule overview

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number
        :type TotalCount: int
        :param _Res: Rule

Note: This field may return null, indicating that no valid values can be obtained.
        :type Res: list of CCRuleItems
        """
        self._TotalCount = None
        self._Res = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Res(self):
        return self._Res

    @Res.setter
    def Res(self, Res):
        self._Res = Res


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Res") is not None:
            self._Res = []
            for item in params.get("Res"):
                obj = CCRuleItems()
                obj._deserialize(item)
                self._Res.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CacheUrlItem(AbstractModel):
    """Tamper-proof URL Elements

    """

    def __init__(self):
        r"""
        :param _Id: Id
        :type Id: str
        :param _Name: Name
        :type Name: str
        :param _Domain: Domain name
        :type Domain: str
        :param _Uri: uri
        :type Uri: str
        :param _Protocol: Protocol
        :type Protocol: str
        :param _Status: Status
        :type Status: str
        """
        self._Id = None
        self._Name = None
        self._Domain = None
        self._Uri = None
        self._Protocol = None
        self._Status = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Uri(self):
        return self._Uri

    @Uri.setter
    def Uri(self, Uri):
        self._Uri = Uri

    @property
    def Protocol(self):
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Name = params.get("Name")
        self._Domain = params.get("Domain")
        self._Uri = params.get("Uri")
        self._Protocol = params.get("Protocol")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CacheUrlItems(AbstractModel):
    """Tamper-proof URL Elements

    """

    def __init__(self):
        r"""
        :param _Id: Identifier
        :type Id: int
        :param _Name: Name
        :type Name: str
        :param _Domain: Domain name
        :type Domain: str
        :param _Uri: URL
        :type Uri: str
        :param _Protocol: Protocol
        :type Protocol: str
        :param _Status: Status
        :type Status: int
        :param _ModifyTime: Modification time

Note: This field may return null, indicating that no valid values can be obtained.
        :type ModifyTime: str
        :param _CreateTime: Creation time

Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        """
        self._Id = None
        self._Name = None
        self._Domain = None
        self._Uri = None
        self._Protocol = None
        self._Status = None
        self._ModifyTime = None
        self._CreateTime = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Uri(self):
        return self._Uri

    @Uri.setter
    def Uri(self, Uri):
        self._Uri = Uri

    @property
    def Protocol(self):
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ModifyTime(self):
        return self._ModifyTime

    @ModifyTime.setter
    def ModifyTime(self, ModifyTime):
        self._ModifyTime = ModifyTime

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Name = params.get("Name")
        self._Domain = params.get("Domain")
        self._Uri = params.get("Uri")
        self._Protocol = params.get("Protocol")
        self._Status = params.get("Status")
        self._ModifyTime = params.get("ModifyTime")
        self._CreateTime = params.get("CreateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClbDomainsInfo(AbstractModel):
    """Details about the domain name protected by CLB WAF

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _DomainId: Unique domain name ID
        :type DomainId: str
        :param _InstanceId: Instance ID of the domain name
        :type InstanceId: str
        :param _InstanceName: Name of the instance of the domain name
        :type InstanceName: str
        :param _Edition: Instance type of the domain name
        :type Edition: str
        :param _IsCdn: Whether a layer-7 proxy service is deployed before the WAF. 0: No proxy service is deployed; 1: The proxy service is deployed. The WAF will use XFF to obtain the client IP address; 2: The proxy service is deployed. The WAF will use remote_addr to obtain the client IP address; 3: The proxy service is deployed. The WAF will use a custom header in ip_headers to obtain the client IP address.
        :type IsCdn: int
        :param _LoadBalancerSet: CLB information when the CLB type is clb
        :type LoadBalancerSet: list of LoadBalancerPackageNew
        :param _FlowMode: CLB WAF traffic mode. 1: cleaning mode; 0: image mode
        :type FlowMode: int
        :param _State: Domain name-bound CLB status
Note: This field may return null, indicating that no valid values can be obtained.
        :type State: int
        :param _AlbType: CLB Type, either CLB or Apisix

Note: This field may return null, indicating that no valid values can be obtained.
        :type AlbType: str
        :param _IpHeaders: IsCdn=3 indicates custom header

Note: This field may return null, indicating that no valid values can be obtained.
        :type IpHeaders: list of str
        :param _CdcClusters: CDC cluster information for the WAF of the cdc-clb-waf type
Note: This field may return null, indicating that no valid values can be obtained.
        :type CdcClusters: str
        :param _CloudType: Cloud Type: public: Public Cloud; private: Private Cloud; hybrid: Hybrid Cloud

Note: This field may return null, indicating that no valid values can be obtained.
        :type CloudType: str
        :param _Note: Domain name remarks
Note: This field may return null, indicating that no valid values can be obtained.
        :type Note: str
        """
        self._Domain = None
        self._DomainId = None
        self._InstanceId = None
        self._InstanceName = None
        self._Edition = None
        self._IsCdn = None
        self._LoadBalancerSet = None
        self._FlowMode = None
        self._State = None
        self._AlbType = None
        self._IpHeaders = None
        self._CdcClusters = None
        self._CloudType = None
        self._Note = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def DomainId(self):
        return self._DomainId

    @DomainId.setter
    def DomainId(self, DomainId):
        self._DomainId = DomainId

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def InstanceName(self):
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def Edition(self):
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def IsCdn(self):
        return self._IsCdn

    @IsCdn.setter
    def IsCdn(self, IsCdn):
        self._IsCdn = IsCdn

    @property
    def LoadBalancerSet(self):
        return self._LoadBalancerSet

    @LoadBalancerSet.setter
    def LoadBalancerSet(self, LoadBalancerSet):
        self._LoadBalancerSet = LoadBalancerSet

    @property
    def FlowMode(self):
        return self._FlowMode

    @FlowMode.setter
    def FlowMode(self, FlowMode):
        self._FlowMode = FlowMode

    @property
    def State(self):
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def AlbType(self):
        return self._AlbType

    @AlbType.setter
    def AlbType(self, AlbType):
        self._AlbType = AlbType

    @property
    def IpHeaders(self):
        return self._IpHeaders

    @IpHeaders.setter
    def IpHeaders(self, IpHeaders):
        self._IpHeaders = IpHeaders

    @property
    def CdcClusters(self):
        return self._CdcClusters

    @CdcClusters.setter
    def CdcClusters(self, CdcClusters):
        self._CdcClusters = CdcClusters

    @property
    def CloudType(self):
        return self._CloudType

    @CloudType.setter
    def CloudType(self, CloudType):
        self._CloudType = CloudType

    @property
    def Note(self):
        return self._Note

    @Note.setter
    def Note(self, Note):
        self._Note = Note


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._DomainId = params.get("DomainId")
        self._InstanceId = params.get("InstanceId")
        self._InstanceName = params.get("InstanceName")
        self._Edition = params.get("Edition")
        self._IsCdn = params.get("IsCdn")
        if params.get("LoadBalancerSet") is not None:
            self._LoadBalancerSet = []
            for item in params.get("LoadBalancerSet"):
                obj = LoadBalancerPackageNew()
                obj._deserialize(item)
                self._LoadBalancerSet.append(obj)
        self._FlowMode = params.get("FlowMode")
        self._State = params.get("State")
        self._AlbType = params.get("AlbType")
        self._IpHeaders = params.get("IpHeaders")
        self._CdcClusters = params.get("CdcClusters")
        self._CloudType = params.get("CloudType")
        self._Note = params.get("Note")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClbObject(AbstractModel):
    """CLB type protection object

    """

    def __init__(self):
        r"""
        :param _ObjectId: Object ID
        :type ObjectId: str
        :param _InstanceId: Instance ID
        :type InstanceId: str
        :param _InstanceName: Instance name
        :type InstanceName: str
        :param _PreciseDomains: Precise Domain List
        :type PreciseDomains: list of str
        :param _Status: WAF Feature Switch Status, 0 Off 1 On
        :type Status: int
        :param _ClsStatus: WAF Log Switch Status, 0 Off 1 On
        :type ClsStatus: int
        :param _VirtualDomain: Virtual Domain Name Corresponding to CLB Object
        :type VirtualDomain: str
        :param _ObjectName: Object name
        :type ObjectName: str
        :param _PublicIp: Public network address
        :type PublicIp: list of str
        :param _PrivateIp: Private network address
        :type PrivateIp: list of str
        :param _VpcName: VPC name
        :type VpcName: str
        :param _Vpc: VPC ID
        :type Vpc: str
        :param _InstanceLevel: WAF instance level, if no instance is bound, it is 0
        :type InstanceLevel: int
        :param _PostCLSStatus: CLB Shipping Switch
        :type PostCLSStatus: int
        :param _PostCKafkaStatus: Kafka Shipping Switch
        :type PostCKafkaStatus: int
        :param _Type: Object type: CLB: Load Balancer, TSE: Cloud-native Gateway

Note: This field may return null, indicating that no valid values can be obtained.
        :type Type: str
        :param _Region: Object Region

Note: This field may return null, indicating that no valid values can be obtained.
        :type Region: str
        :param _Proxy: Proxy status. 0: disabled; 1: Use the first IP address in XFF as the client IP address; 2: Use remote_addr as the client IP address; 3: Obtain the client IP address from the specified header field. The field is given by the IpHeaders field.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Proxy: int
        :param _IpHeaders: List of header fields for obtaining the client IP. This parameter is effective when IsCdn is 3.
Note: This field may return null, indicating that no valid values can be obtained.
        :type IpHeaders: list of str
        :param _BotStatus: Bot protection switch
Note: This field may return null, indicating that no valid values can be obtained.
        :type BotStatus: int
        :param _ApiStatus: API protection switch
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApiStatus: int
        :param _ObjectFlowMode: Object access mode. 0: image mode; 1: cleaning mode; 2: examination mode. By default, the cleaning mode is used.Note: This field may return null, indicating that no valid values can be obtained.
        :type ObjectFlowMode: int
        """
        self._ObjectId = None
        self._InstanceId = None
        self._InstanceName = None
        self._PreciseDomains = None
        self._Status = None
        self._ClsStatus = None
        self._VirtualDomain = None
        self._ObjectName = None
        self._PublicIp = None
        self._PrivateIp = None
        self._VpcName = None
        self._Vpc = None
        self._InstanceLevel = None
        self._PostCLSStatus = None
        self._PostCKafkaStatus = None
        self._Type = None
        self._Region = None
        self._Proxy = None
        self._IpHeaders = None
        self._BotStatus = None
        self._ApiStatus = None
        self._ObjectFlowMode = None

    @property
    def ObjectId(self):
        return self._ObjectId

    @ObjectId.setter
    def ObjectId(self, ObjectId):
        self._ObjectId = ObjectId

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def InstanceName(self):
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def PreciseDomains(self):
        return self._PreciseDomains

    @PreciseDomains.setter
    def PreciseDomains(self, PreciseDomains):
        self._PreciseDomains = PreciseDomains

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ClsStatus(self):
        return self._ClsStatus

    @ClsStatus.setter
    def ClsStatus(self, ClsStatus):
        self._ClsStatus = ClsStatus

    @property
    def VirtualDomain(self):
        return self._VirtualDomain

    @VirtualDomain.setter
    def VirtualDomain(self, VirtualDomain):
        self._VirtualDomain = VirtualDomain

    @property
    def ObjectName(self):
        return self._ObjectName

    @ObjectName.setter
    def ObjectName(self, ObjectName):
        self._ObjectName = ObjectName

    @property
    def PublicIp(self):
        return self._PublicIp

    @PublicIp.setter
    def PublicIp(self, PublicIp):
        self._PublicIp = PublicIp

    @property
    def PrivateIp(self):
        return self._PrivateIp

    @PrivateIp.setter
    def PrivateIp(self, PrivateIp):
        self._PrivateIp = PrivateIp

    @property
    def VpcName(self):
        return self._VpcName

    @VpcName.setter
    def VpcName(self, VpcName):
        self._VpcName = VpcName

    @property
    def Vpc(self):
        return self._Vpc

    @Vpc.setter
    def Vpc(self, Vpc):
        self._Vpc = Vpc

    @property
    def InstanceLevel(self):
        return self._InstanceLevel

    @InstanceLevel.setter
    def InstanceLevel(self, InstanceLevel):
        self._InstanceLevel = InstanceLevel

    @property
    def PostCLSStatus(self):
        return self._PostCLSStatus

    @PostCLSStatus.setter
    def PostCLSStatus(self, PostCLSStatus):
        self._PostCLSStatus = PostCLSStatus

    @property
    def PostCKafkaStatus(self):
        return self._PostCKafkaStatus

    @PostCKafkaStatus.setter
    def PostCKafkaStatus(self, PostCKafkaStatus):
        self._PostCKafkaStatus = PostCKafkaStatus

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Proxy(self):
        return self._Proxy

    @Proxy.setter
    def Proxy(self, Proxy):
        self._Proxy = Proxy

    @property
    def IpHeaders(self):
        return self._IpHeaders

    @IpHeaders.setter
    def IpHeaders(self, IpHeaders):
        self._IpHeaders = IpHeaders

    @property
    def BotStatus(self):
        return self._BotStatus

    @BotStatus.setter
    def BotStatus(self, BotStatus):
        self._BotStatus = BotStatus

    @property
    def ApiStatus(self):
        return self._ApiStatus

    @ApiStatus.setter
    def ApiStatus(self, ApiStatus):
        self._ApiStatus = ApiStatus

    @property
    def ObjectFlowMode(self):
        return self._ObjectFlowMode

    @ObjectFlowMode.setter
    def ObjectFlowMode(self, ObjectFlowMode):
        self._ObjectFlowMode = ObjectFlowMode


    def _deserialize(self, params):
        self._ObjectId = params.get("ObjectId")
        self._InstanceId = params.get("InstanceId")
        self._InstanceName = params.get("InstanceName")
        self._PreciseDomains = params.get("PreciseDomains")
        self._Status = params.get("Status")
        self._ClsStatus = params.get("ClsStatus")
        self._VirtualDomain = params.get("VirtualDomain")
        self._ObjectName = params.get("ObjectName")
        self._PublicIp = params.get("PublicIp")
        self._PrivateIp = params.get("PrivateIp")
        self._VpcName = params.get("VpcName")
        self._Vpc = params.get("Vpc")
        self._InstanceLevel = params.get("InstanceLevel")
        self._PostCLSStatus = params.get("PostCLSStatus")
        self._PostCKafkaStatus = params.get("PostCKafkaStatus")
        self._Type = params.get("Type")
        self._Region = params.get("Region")
        self._Proxy = params.get("Proxy")
        self._IpHeaders = params.get("IpHeaders")
        self._BotStatus = params.get("BotStatus")
        self._ApiStatus = params.get("ApiStatus")
        self._ObjectFlowMode = params.get("ObjectFlowMode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClbWafRegionItem(AbstractModel):
    """CLB-WAF Regional Information

    """

    def __init__(self):
        r"""
        :param _Id: Region ID

Note: This field may return null, indicating that no valid values can be obtained.
        :type Id: str
        :param _Text: Regional Chinese Description

Note: This field may return null, indicating that no valid values can be obtained.
        :type Text: str
        :param _Value: Full English Name of the Region

Note: This field may return null, indicating that no valid values can be obtained.
        :type Value: str
        :param _Code: Region encoding

Note: This field may return null, indicating that no valid values can be obtained.
        :type Code: str
        """
        self._Id = None
        self._Text = None
        self._Value = None
        self._Code = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Text(self):
        return self._Text

    @Text.setter
    def Text(self, Text):
        self._Text = Text

    @property
    def Value(self):
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value

    @property
    def Code(self):
        return self._Code

    @Code.setter
    def Code(self, Code):
        self._Code = Code


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Text = params.get("Text")
        self._Value = params.get("Value")
        self._Code = params.get("Code")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDealsGoods(AbstractModel):
    """Input/Output parameter goods of billing & ordering API

    """

    def __init__(self):
        r"""
        :param _GoodsNum: Number of products
        :type GoodsNum: int
        :param _GoodsDetail: Product Detail
        :type GoodsDetail: :class:`tencentcloud.waf.v20180125.models.CreateDealsGoodsDetail`
        :param _GoodsCategoryId: Order type ID, which is used to uniquely identify a business scene. (There are three scenes in total: new purchase, configuration change, and renewal.)
Advanced Edition: 102375 (new purchase), 102376 (renewal), and 102377 (configuration change)
Enterprise Edition: 102378 (new purchase), 102379 (renewal), and 102380 (configuration change)
Ultimate Edition: 102369 (new purchase), 102370 (renewal), and 102371 (configuration change)
Domain name package: 102372 (new purchase), 102373 (renewal), and 102374 (configuration change)
Business expansion package: 101040 (new purchase), 101041 (renewal), and 101042 (configuration change)

Advanced Edition - CLB: 101198 (new purchase), 101199 (renewal), and 101200 (configuration change)
Enterprise Edition - CLB: 101204 (new purchase), 101205 (renewal), and 101206 (configuration change)
Ultimate Edition - CLB: 101201 (new purchase), 101202 (renewal), and 101203 (configuration change)
Domain name package - CLB: 101207 (new purchase), 101208 (renewal), and 101209 (configuration change)
Business expansion package - CLB: 101210 (new purchase), 101211 (renewal), and 101212 (configuration adjustment)

Note: This field may return null, indicating that no valid values can be obtained.
        :type GoodsCategoryId: int
        :param _RegionId: Region ID for purchasing WAF instance

1 indicates purchasing resources in Chinese mainland.
9 indicates purchasing resources outside Chinese mainland.
Note: This field may return null, indicating that no valid values can be obtained.
        :type RegionId: int
        """
        self._GoodsNum = None
        self._GoodsDetail = None
        self._GoodsCategoryId = None
        self._RegionId = None

    @property
    def GoodsNum(self):
        return self._GoodsNum

    @GoodsNum.setter
    def GoodsNum(self, GoodsNum):
        self._GoodsNum = GoodsNum

    @property
    def GoodsDetail(self):
        return self._GoodsDetail

    @GoodsDetail.setter
    def GoodsDetail(self, GoodsDetail):
        self._GoodsDetail = GoodsDetail

    @property
    def GoodsCategoryId(self):
        return self._GoodsCategoryId

    @GoodsCategoryId.setter
    def GoodsCategoryId(self, GoodsCategoryId):
        self._GoodsCategoryId = GoodsCategoryId

    @property
    def RegionId(self):
        return self._RegionId

    @RegionId.setter
    def RegionId(self, RegionId):
        self._RegionId = RegionId


    def _deserialize(self, params):
        self._GoodsNum = params.get("GoodsNum")
        if params.get("GoodsDetail") is not None:
            self._GoodsDetail = CreateDealsGoodsDetail()
            self._GoodsDetail._deserialize(params.get("GoodsDetail"))
        self._GoodsCategoryId = params.get("GoodsCategoryId")
        self._RegionId = params.get("RegionId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDealsGoodsDetail(AbstractModel):
    """Product details

    """

    def __init__(self):
        r"""
        :param _TimeSpan: Time interval
Note: This field may return null, indicating that no valid values can be obtained.
        :type TimeSpan: int
        :param _TimeUnit: Unit, support for purchasing d, m, y, i.e., (day, month, year)

Note: This field may return null, indicating that no valid values can be obtained.
        :type TimeUnit: str
        :param _SubProductCode: Sub-product tag. It is mandatory for new purchase and renewal. For configuration change, it will be placed in oldConfig and newConfig.

SaaS Advanced Edition: sp_wsm_waf_premium
SaaS Enterprise Edition: sp_wsm_waf_enterprise
SaaS Ultimate Edition: sp_wsm_waf_ultimate
SaaS business expansion package: sp_wsm_waf_qpsep
SaaS domain name expansion package: sp_wsm_waf_domain

Advanced Edition - CLB: sp_wsm_waf_premium_clb
Enterprise Edition - CLB: sp_wsm_waf_enterprise_clb
Ultimate Edition - CLB: sp_wsm_waf_ultimate_clb
 business expansion package - CLB: sp_wsm_waf_qpsep_clb
Domain name expansion package - CLB: sp_wsm_waf_domain_clb

Note: This field may return null, indicating that no valid values can be obtained.
        :type SubProductCode: str
        :param _Pid: PID applied for a business product (corresponding to a pricing formula). The pricing model can be found through PID billing.
Advanced Edition: 1000827
Enterprise Edition: 1000830
Ultimate Edition: 1000832
Domain name package: 1000834
Business expansion package: 1000481
Advanced Edition - CLB: 1001150
Enterprise Edition - CLB: 1001152
Ultimate Edition - CLB: 1001154
Domain name package - CLB: 1001156
Business expansion package - CLB: 1001160

Note: This field may return null, indicating that no valid values can be obtained.
        :type Pid: int
        :param _InstanceName: WAF Instance Name

Note: This field may return null, indicating that no valid values can be obtained.
        :type InstanceName: str
        :param _AutoRenewFlag: 1: Auto-renewal, 0: No Auto-renewal

Note: This field may return null, indicating that no valid values can be obtained.
        :type AutoRenewFlag: int
        :param _RealRegion: Actual Geographic Information of WAF Purchase

Note: This field may return null, indicating that no valid values can be obtained.
        :type RealRegion: int
        :param _LabelTypes: Billing Detail Tag Array

SaaS Advanced Edition: sv_wsm_waf_package_premium
SaaS Enterprise Edition: sv_wsm_waf_package_enterprise
SaaS Ultimate Edition: sv_wsm_waf_package_ultimate
SaaS non-Chinese Mainland Advanced Edition: sv_wsm_waf_package_premium_intl
SaaS non-Chinese Mainland Enterprise Edition: sv_wsm_waf_package_enterprise_intl
SaaS non-Chinese Mainland Ultimate Edition: sv_wsm_waf_package_ultimate_intl
SaaS business expansion package: sv_wsm_waf_qps_ep
SaaS domain name expansion package: sv_wsm_waf_domain

Advanced Edition CLB: sv_wsm_waf_package_premium_clb
Enterprise Edition CLB: sv_wsm_waf_package_enterprise_clb
Ultimate Edition CLB: sv_wsm_waf_package_ultimate_clb
Non-Chinese Mainland Advanced Edition CLB: sv_wsm_waf_package_premium_clb_intl
Non-Chinese Mainland Enterprise Edition CLB: sv_wsm_waf_package_premium_clb_intl
Non-Chinese Mainland Ultimate Edition CLB: sv_wsm_waf_package_ultimate_clb_intl
Business expansion package CLB: sv_wsm_waf_qps_ep_clb
Domain name expansion package CLB: sv_wsm_waf_domain_clb

Note: This field may return null, indicating that no valid values can be obtained.
        :type LabelTypes: list of str
        :param _LabelCounts: Number of Billing Detail Tags, Generally Corresponds One-to-One with SvLabelType

Note: This field may return null, indicating that no valid values can be obtained.
        :type LabelCounts: list of int
        :param _CurDeadline: Dynamic Configuration Usage, Instance Expiration Time

Note: This field may return null, indicating that no valid values can be obtained.
        :type CurDeadline: str
        :param _InstanceId: Purchasing Bot or API Security for Existing Instances

Note: This field may return null, indicating that no valid values can be obtained.
        :type InstanceId: str
        :param _ResourceId: Resource ID

Note: This field may return null, indicating that no valid values can be obtained.
        :type ResourceId: str
        """
        self._TimeSpan = None
        self._TimeUnit = None
        self._SubProductCode = None
        self._Pid = None
        self._InstanceName = None
        self._AutoRenewFlag = None
        self._RealRegion = None
        self._LabelTypes = None
        self._LabelCounts = None
        self._CurDeadline = None
        self._InstanceId = None
        self._ResourceId = None

    @property
    def TimeSpan(self):
        return self._TimeSpan

    @TimeSpan.setter
    def TimeSpan(self, TimeSpan):
        self._TimeSpan = TimeSpan

    @property
    def TimeUnit(self):
        return self._TimeUnit

    @TimeUnit.setter
    def TimeUnit(self, TimeUnit):
        self._TimeUnit = TimeUnit

    @property
    def SubProductCode(self):
        return self._SubProductCode

    @SubProductCode.setter
    def SubProductCode(self, SubProductCode):
        self._SubProductCode = SubProductCode

    @property
    def Pid(self):
        return self._Pid

    @Pid.setter
    def Pid(self, Pid):
        self._Pid = Pid

    @property
    def InstanceName(self):
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def AutoRenewFlag(self):
        return self._AutoRenewFlag

    @AutoRenewFlag.setter
    def AutoRenewFlag(self, AutoRenewFlag):
        self._AutoRenewFlag = AutoRenewFlag

    @property
    def RealRegion(self):
        return self._RealRegion

    @RealRegion.setter
    def RealRegion(self, RealRegion):
        self._RealRegion = RealRegion

    @property
    def LabelTypes(self):
        return self._LabelTypes

    @LabelTypes.setter
    def LabelTypes(self, LabelTypes):
        self._LabelTypes = LabelTypes

    @property
    def LabelCounts(self):
        return self._LabelCounts

    @LabelCounts.setter
    def LabelCounts(self, LabelCounts):
        self._LabelCounts = LabelCounts

    @property
    def CurDeadline(self):
        return self._CurDeadline

    @CurDeadline.setter
    def CurDeadline(self, CurDeadline):
        self._CurDeadline = CurDeadline

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def ResourceId(self):
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId


    def _deserialize(self, params):
        self._TimeSpan = params.get("TimeSpan")
        self._TimeUnit = params.get("TimeUnit")
        self._SubProductCode = params.get("SubProductCode")
        self._Pid = params.get("Pid")
        self._InstanceName = params.get("InstanceName")
        self._AutoRenewFlag = params.get("AutoRenewFlag")
        self._RealRegion = params.get("RealRegion")
        self._LabelTypes = params.get("LabelTypes")
        self._LabelCounts = params.get("LabelCounts")
        self._CurDeadline = params.get("CurDeadline")
        self._InstanceId = params.get("InstanceId")
        self._ResourceId = params.get("ResourceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDealsRequest(AbstractModel):
    """CreateDeals request structure.

    """

    def __init__(self):
        r"""
        :param _Goods: Billing and ordering input parameters
        :type Goods: list of CreateDealsGoods
        """
        self._Goods = None

    @property
    def Goods(self):
        return self._Goods

    @Goods.setter
    def Goods(self, Goods):
        self._Goods = Goods


    def _deserialize(self, params):
        if params.get("Goods") is not None:
            self._Goods = []
            for item in params.get("Goods"):
                obj = CreateDealsGoods()
                obj._deserialize(item)
                self._Goods.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDealsResponse(AbstractModel):
    """CreateDeals response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Billing order response structure

Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.waf.v20180125.models.DealData`
        :param _Status: 1: Success, 0: Failure
        :type Status: int
        :param _ReturnMessage: Returned message

Note: This field may return null, indicating that no valid values can be obtained.
        :type ReturnMessage: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._Status = None
        self._ReturnMessage = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ReturnMessage(self):
        return self._ReturnMessage

    @ReturnMessage.setter
    def ReturnMessage(self, ReturnMessage):
        self._ReturnMessage = ReturnMessage

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DealData()
            self._Data._deserialize(params.get("Data"))
        self._Status = params.get("Status")
        self._ReturnMessage = params.get("ReturnMessage")
        self._RequestId = params.get("RequestId")


class CreateHostRequest(AbstractModel):
    """CreateHost request structure.

    """

    def __init__(self):
        r"""
        :param _Host: Protection Domain Configuration Information
        :type Host: :class:`tencentcloud.waf.v20180125.models.HostRecord`
        :param _InstanceID: Instance ID
        :type InstanceID: str
        """
        self._Host = None
        self._InstanceID = None

    @property
    def Host(self):
        return self._Host

    @Host.setter
    def Host(self, Host):
        self._Host = Host

    @property
    def InstanceID(self):
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID


    def _deserialize(self, params):
        if params.get("Host") is not None:
            self._Host = HostRecord()
            self._Host._deserialize(params.get("Host"))
        self._InstanceID = params.get("InstanceID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateHostResponse(AbstractModel):
    """CreateHost response structure.

    """

    def __init__(self):
        r"""
        :param _DomainId: Unique ID of domain
        :type DomainId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DomainId = None
        self._RequestId = None

    @property
    def DomainId(self):
        return self._DomainId

    @DomainId.setter
    def DomainId(self, DomainId):
        self._DomainId = DomainId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DomainId = params.get("DomainId")
        self._RequestId = params.get("RequestId")


class CreateIpAccessControlRequest(AbstractModel):
    """CreateIpAccessControl request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Specific domain name, for example, test.qcloudwaf.com.
Global domain name, that is, global.
        :type Domain: str
        :param _IpList: IP parameter list.
        :type IpList: list of str
        :param _ActionType: 42: blocklist; 40: allowlist.
        :type ActionType: int
        :param _ValidTS: valid_ts indicates a valid date. Its value is a second-level timestamp, such as 1680570420, which indicates 2023-04-04 09:07:00.
        :type ValidTS: int
        :param _InstanceId: Instance ID
        :type InstanceId: str
        :param _Edition: WAF instance type: sparta-waf for SaaS WAF, clb-waf for CLB WAF.
        :type Edition: str
        :param _SourceType: Valid values: batch (adding in batches), bot (adding to the bot details list in bot traffic analysis), cc (adding to IP addresses of the CC attack type in the attack log list), custom (default value for adding not in batches).
        :type SourceType: str
        :param _Note: Remarks
        :type Note: str
        :param _JobType: Scheduled configuration type.
        :type JobType: str
        :param _JobDateTime: Details of scheduled configuration.
        :type JobDateTime: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        """
        self._Domain = None
        self._IpList = None
        self._ActionType = None
        self._ValidTS = None
        self._InstanceId = None
        self._Edition = None
        self._SourceType = None
        self._Note = None
        self._JobType = None
        self._JobDateTime = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def IpList(self):
        return self._IpList

    @IpList.setter
    def IpList(self, IpList):
        self._IpList = IpList

    @property
    def ActionType(self):
        return self._ActionType

    @ActionType.setter
    def ActionType(self, ActionType):
        self._ActionType = ActionType

    @property
    def ValidTS(self):
        return self._ValidTS

    @ValidTS.setter
    def ValidTS(self, ValidTS):
        self._ValidTS = ValidTS

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Edition(self):
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def SourceType(self):
        return self._SourceType

    @SourceType.setter
    def SourceType(self, SourceType):
        self._SourceType = SourceType

    @property
    def Note(self):
        return self._Note

    @Note.setter
    def Note(self, Note):
        self._Note = Note

    @property
    def JobType(self):
        return self._JobType

    @JobType.setter
    def JobType(self, JobType):
        self._JobType = JobType

    @property
    def JobDateTime(self):
        return self._JobDateTime

    @JobDateTime.setter
    def JobDateTime(self, JobDateTime):
        self._JobDateTime = JobDateTime


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._IpList = params.get("IpList")
        self._ActionType = params.get("ActionType")
        self._ValidTS = params.get("ValidTS")
        self._InstanceId = params.get("InstanceId")
        self._Edition = params.get("Edition")
        self._SourceType = params.get("SourceType")
        self._Note = params.get("Note")
        self._JobType = params.get("JobType")
        if params.get("JobDateTime") is not None:
            self._JobDateTime = JobDateTime()
            self._JobDateTime._deserialize(params.get("JobDateTime"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateIpAccessControlResponse(AbstractModel):
    """CreateIpAccessControl response structure.

    """

    def __init__(self):
        r"""
        :param _RuleId: ID of the new rule.

Note: This field may return null, indicating that no valid values can be obtained.
        :type RuleId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RuleId = None
        self._RequestId = None

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        self._RequestId = params.get("RequestId")


class CronJob(AbstractModel):
    """Data structure of periodic rule execution

    """

    def __init__(self):
        r"""
        :param _Days: Days in each month for execution
Note: This field may return null, indicating that no valid values can be obtained.
        :type Days: list of int non-negative
        :param _WDays: Days of each week for execution
Note: This field may return null, indicating that no valid values can be obtained.
        :type WDays: list of int non-negative
        :param _StartTime: Start time

Note: This field may return null, indicating that no valid values can be obtained.
        :type StartTime: str
        :param _EndTime: End time

Note: This field may return null, indicating that no valid values can be obtained.
        :type EndTime: str
        """
        self._Days = None
        self._WDays = None
        self._StartTime = None
        self._EndTime = None

    @property
    def Days(self):
        return self._Days

    @Days.setter
    def Days(self, Days):
        self._Days = Days

    @property
    def WDays(self):
        return self._WDays

    @WDays.setter
    def WDays(self, WDays):
        self._WDays = WDays

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._Days = params.get("Days")
        self._WDays = params.get("WDays")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DealData(AbstractModel):
    """Billing order response entity

    """

    def __init__(self):
        r"""
        :param _DealNames: Order Number List: the number of elements matches the number of elements in the Goods array of the request package. Product details correspond to orders in sequence
        :type DealNames: list of str
        :param _BigDealId: Large Order Number, a large order number can have multiple sub-orders, indicating the same order placement [{},{}]
        :type BigDealId: str
        """
        self._DealNames = None
        self._BigDealId = None

    @property
    def DealNames(self):
        return self._DealNames

    @DealNames.setter
    def DealNames(self, DealNames):
        self._DealNames = DealNames

    @property
    def BigDealId(self):
        return self._BigDealId

    @BigDealId.setter
    def BigDealId(self, BigDealId):
        self._BigDealId = BigDealId


    def _deserialize(self, params):
        self._DealNames = params.get("DealNames")
        self._BigDealId = params.get("BigDealId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAntiFakeUrlRequest(AbstractModel):
    """DeleteAntiFakeUrl request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _Id: Id
        :type Id: int
        """
        self._Domain = None
        self._Id = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAntiFakeUrlResponse(AbstractModel):
    """DeleteAntiFakeUrl response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteAntiInfoLeakRuleRequest(AbstractModel):
    """DeleteAntiInfoLeakRule request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _RuleId: Rule ID
        :type RuleId: int
        """
        self._Domain = None
        self._RuleId = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._RuleId = params.get("RuleId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAntiInfoLeakRuleResponse(AbstractModel):
    """DeleteAntiInfoLeakRule response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteCCRuleRequest(AbstractModel):
    """DeleteCCRule request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _Name: Rule name
        :type Name: str
        :param _Edition: clb-waf or sparta-waf
        :type Edition: str
        :param _RuleId: Rule ID
        :type RuleId: int
        """
        self._Domain = None
        self._Name = None
        self._Edition = None
        self._RuleId = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Edition(self):
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Name = params.get("Name")
        self._Edition = params.get("Edition")
        self._RuleId = params.get("RuleId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCCRuleResponse(AbstractModel):
    """DeleteCCRule response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Normally null

Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: str
        :param _RuleId: Operational rule ID
        :type RuleId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RuleId = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RuleId = params.get("RuleId")
        self._RequestId = params.get("RequestId")


class DeleteCustomRuleRequest(AbstractModel):
    """DeleteCustomRule request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Deleted domain
        :type Domain: str
        :param _RuleId: Deleted rule ID
        :type RuleId: str
        :param _Edition: Version of WAF. clb-waf indicates CLB WAF; sparta-waf indicates SaaS WAF. sparta-waf by default.
        :type Edition: str
        :param _DomainRuleIdList: List of rules to be deleted in batches
        :type DomainRuleIdList: list of DomainRuleId
        """
        self._Domain = None
        self._RuleId = None
        self._Edition = None
        self._DomainRuleIdList = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def Edition(self):
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def DomainRuleIdList(self):
        return self._DomainRuleIdList

    @DomainRuleIdList.setter
    def DomainRuleIdList(self, DomainRuleIdList):
        self._DomainRuleIdList = DomainRuleIdList


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._RuleId = params.get("RuleId")
        self._Edition = params.get("Edition")
        if params.get("DomainRuleIdList") is not None:
            self._DomainRuleIdList = []
            for item in params.get("DomainRuleIdList"):
                obj = DomainRuleId()
                obj._deserialize(item)
                self._DomainRuleIdList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCustomRuleResponse(AbstractModel):
    """DeleteCustomRule response structure.

    """

    def __init__(self):
        r"""
        :param _Success: Operation status code: if all resource operations succeed, the success status code is returned; if any resource operation fails, the content of Message needs to be parsed to see which resource failed.
        :type Success: :class:`tencentcloud.waf.v20180125.models.ResponseCode`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Success = None
        self._RequestId = None

    @property
    def Success(self):
        return self._Success

    @Success.setter
    def Success(self, Success):
        self._Success = Success

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Success") is not None:
            self._Success = ResponseCode()
            self._Success._deserialize(params.get("Success"))
        self._RequestId = params.get("RequestId")


class DeleteCustomWhiteRuleRequest(AbstractModel):
    """DeleteCustomWhiteRule request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Deleted domain
        :type Domain: str
        :param _RuleId: Deleted rule ID
        :type RuleId: int
        """
        self._Domain = None
        self._RuleId = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._RuleId = params.get("RuleId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCustomWhiteRuleResponse(AbstractModel):
    """DeleteCustomWhiteRule response structure.

    """

    def __init__(self):
        r"""
        :param _Success: Operation status code: if all resource operations succeed, the success status code is returned; if any resource operation fails, the content of Message needs to be parsed to see which resource failed.
        :type Success: :class:`tencentcloud.waf.v20180125.models.ResponseCode`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Success = None
        self._RequestId = None

    @property
    def Success(self):
        return self._Success

    @Success.setter
    def Success(self, Success):
        self._Success = Success

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Success") is not None:
            self._Success = ResponseCode()
            self._Success._deserialize(params.get("Success"))
        self._RequestId = params.get("RequestId")


class DeleteHostRequest(AbstractModel):
    """DeleteHost request structure.

    """

    def __init__(self):
        r"""
        :param _HostsDel: List of domains to be deleted
        :type HostsDel: list of HostDel
        """
        self._HostsDel = None

    @property
    def HostsDel(self):
        return self._HostsDel

    @HostsDel.setter
    def HostsDel(self, HostsDel):
        self._HostsDel = HostsDel


    def _deserialize(self, params):
        if params.get("HostsDel") is not None:
            self._HostsDel = []
            for item in params.get("HostsDel"):
                obj = HostDel()
                obj._deserialize(item)
                self._HostsDel.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteHostResponse(AbstractModel):
    """DeleteHost response structure.

    """

    def __init__(self):
        r"""
        :param _Success: Domain name deletion result. Code represents the status code, and Message represents details.
        :type Success: :class:`tencentcloud.waf.v20180125.models.ResponseCode`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Success = None
        self._RequestId = None

    @property
    def Success(self):
        return self._Success

    @Success.setter
    def Success(self, Success):
        self._Success = Success

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Success") is not None:
            self._Success = ResponseCode()
            self._Success._deserialize(params.get("Success"))
        self._RequestId = params.get("RequestId")


class DeleteIpAccessControlV2Request(AbstractModel):
    """DeleteIpAccessControlV2 request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _RuleIds: Rule ID list, which supports deletion in batches.
        :type RuleIds: list of int non-negative
        :param _DeleteAll: Whether to delete all IP blocklists/allowlists under the corresponding domain. True indicates deleting all; false indicates only deleting a specified IP list.
        :type DeleteAll: bool
        :param _SourceType: batch: indicates batch protection IP allowlists/blocklists.
        :type SourceType: str
        :param _ActionType: IP allowlist/blocklist type. 40: IP allowlist; 42: IP blocklist.
        :type ActionType: int
        """
        self._Domain = None
        self._RuleIds = None
        self._DeleteAll = None
        self._SourceType = None
        self._ActionType = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def RuleIds(self):
        return self._RuleIds

    @RuleIds.setter
    def RuleIds(self, RuleIds):
        self._RuleIds = RuleIds

    @property
    def DeleteAll(self):
        return self._DeleteAll

    @DeleteAll.setter
    def DeleteAll(self, DeleteAll):
        self._DeleteAll = DeleteAll

    @property
    def SourceType(self):
        return self._SourceType

    @SourceType.setter
    def SourceType(self, SourceType):
        self._SourceType = SourceType

    @property
    def ActionType(self):
        return self._ActionType

    @ActionType.setter
    def ActionType(self, ActionType):
        self._ActionType = ActionType


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._RuleIds = params.get("RuleIds")
        self._DeleteAll = params.get("DeleteAll")
        self._SourceType = params.get("SourceType")
        self._ActionType = params.get("ActionType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteIpAccessControlV2Response(AbstractModel):
    """DeleteIpAccessControlV2 response structure.

    """

    def __init__(self):
        r"""
        :param _FailedCount: Number of items that fail to be deleted during deletion in batches.
        :type FailedCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FailedCount = None
        self._RequestId = None

    @property
    def FailedCount(self):
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FailedCount = params.get("FailedCount")
        self._RequestId = params.get("RequestId")


class DeleteSessionRequest(AbstractModel):
    """DeleteSession request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _Edition: clb-waf or sparta-waf
        :type Edition: str
        :param _SessionID: SessionID to be deleted
        :type SessionID: int
        """
        self._Domain = None
        self._Edition = None
        self._SessionID = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Edition(self):
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def SessionID(self):
        return self._SessionID

    @SessionID.setter
    def SessionID(self, SessionID):
        self._SessionID = SessionID


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Edition = params.get("Edition")
        self._SessionID = params.get("SessionID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSessionResponse(AbstractModel):
    """DeleteSession response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Result

Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteSpartaProtectionRequest(AbstractModel):
    """DeleteSpartaProtection request structure.

    """

    def __init__(self):
        r"""
        :param _Domains: Domain name list
        :type Domains: list of str
        :param _Edition: Instance type
        :type Edition: str
        :param _InstanceID: (Required) Instance ID of the domain name
        :type InstanceID: str
        """
        self._Domains = None
        self._Edition = None
        self._InstanceID = None

    @property
    def Domains(self):
        return self._Domains

    @Domains.setter
    def Domains(self, Domains):
        self._Domains = Domains

    @property
    def Edition(self):
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def InstanceID(self):
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID


    def _deserialize(self, params):
        self._Domains = params.get("Domains")
        self._Edition = params.get("Edition")
        self._InstanceID = params.get("InstanceID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSpartaProtectionResponse(AbstractModel):
    """DeleteSpartaProtection response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DescribeAntiFakeRulesRequest(AbstractModel):
    """DescribeAntiFakeRules request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _Offset: Offset
        :type Offset: int
        :param _Limit: Capacity
        :type Limit: int
        :param _Filters: Filter array. A name can be one of the following values: RuleID, ParamName, Url, Action, Method, Source, and Status.
        :type Filters: list of FiltersItemNew
        :param _Order: asc or desc
        :type Order: str
        :param _By: Currently supports sorting by TS
        :type By: str
        """
        self._Domain = None
        self._Offset = None
        self._Limit = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = FiltersItemNew()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAntiFakeRulesResponse(AbstractModel):
    """DescribeAntiFakeRules response structure.

    """

    def __init__(self):
        r"""
        :param _Total: Total number
        :type Total: int
        :param _Data: Returned value
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: list of CacheUrlItems
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Total = None
        self._Data = None
        self._RequestId = None

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = CacheUrlItems()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAntiFakeUrlRequest(AbstractModel):
    """DescribeAntiFakeUrl request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _PageInfo: Page turning parameters
        :type PageInfo: :class:`tencentcloud.waf.v20180125.models.PageInfo`
        """
        self._Domain = None
        self._PageInfo = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def PageInfo(self):
        return self._PageInfo

    @PageInfo.setter
    def PageInfo(self, PageInfo):
        self._PageInfo = PageInfo


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        if params.get("PageInfo") is not None:
            self._PageInfo = PageInfo()
            self._PageInfo._deserialize(params.get("PageInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAntiFakeUrlResponse(AbstractModel):
    """DescribeAntiFakeUrl response structure.

    """

    def __init__(self):
        r"""
        :param _Total: Total number
        :type Total: str
        :param _List: Information
        :type List: list of CacheUrlItem
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Total = None
        self._List = None
        self._RequestId = None

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = CacheUrlItem()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAntiInfoLeakRulesRequest(AbstractModel):
    """DescribeAntiInfoLeakRules request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _ActionType: Action type
        :type ActionType: int
        :param _PageInfo: Page turning
        :type PageInfo: :class:`tencentcloud.waf.v20180125.models.PageInfo`
        """
        self._Domain = None
        self._ActionType = None
        self._PageInfo = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def ActionType(self):
        return self._ActionType

    @ActionType.setter
    def ActionType(self, ActionType):
        self._ActionType = ActionType

    @property
    def PageInfo(self):
        return self._PageInfo

    @PageInfo.setter
    def PageInfo(self, PageInfo):
        self._PageInfo = PageInfo


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._ActionType = params.get("ActionType")
        if params.get("PageInfo") is not None:
            self._PageInfo = PageInfo()
            self._PageInfo._deserialize(params.get("PageInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAntiInfoLeakRulesResponse(AbstractModel):
    """DescribeAntiInfoLeakRules response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of records
        :type TotalCount: str
        :param _RuleList: List of rules
        :type RuleList: list of DescribeAntiInfoLeakRulesRuleItem
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._RuleList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RuleList(self):
        return self._RuleList

    @RuleList.setter
    def RuleList(self, RuleList):
        self._RuleList = RuleList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("RuleList") is not None:
            self._RuleList = []
            for item in params.get("RuleList"):
                obj = DescribeAntiInfoLeakRulesRuleItem()
                obj._deserialize(item)
                self._RuleList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAntiInfoLeakRulesRuleItem(AbstractModel):
    """Rule list element returned by DescribeAntiInfoLeakRules

    """

    def __init__(self):
        r"""
        :param _RuleId: Rule ID
        :type RuleId: str
        :param _Name: Rule name
        :type Name: str
        :param _Status: Rule status
        :type Status: str
        :param _ActionType: Rule Action Type
        :type ActionType: str
        :param _CreateTime: Rule creation time
        :type CreateTime: str
        :param _Strategies: Detailed Rules
        :type Strategies: list of DescribeAntiInfoLeakRulesStrategyItem
        """
        self._RuleId = None
        self._Name = None
        self._Status = None
        self._ActionType = None
        self._CreateTime = None
        self._Strategies = None

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ActionType(self):
        return self._ActionType

    @ActionType.setter
    def ActionType(self, ActionType):
        self._ActionType = ActionType

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def Strategies(self):
        return self._Strategies

    @Strategies.setter
    def Strategies(self, Strategies):
        self._Strategies = Strategies


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        self._Name = params.get("Name")
        self._Status = params.get("Status")
        self._ActionType = params.get("ActionType")
        self._CreateTime = params.get("CreateTime")
        if params.get("Strategies") is not None:
            self._Strategies = []
            for item in params.get("Strategies"):
                obj = DescribeAntiInfoLeakRulesStrategyItem()
                obj._deserialize(item)
                self._Strategies.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAntiInfoLeakRulesStrategyItem(AbstractModel):
    """Specific rule elements within the rule elements returned by DescribeAntiInfoLeakRules

    """

    def __init__(self):
        r"""
        :param _Field: Field
        :type Field: str
        :param _CompareFunc: Condition
        :type CompareFunc: str
        :param _Content: Content
        :type Content: str
        """
        self._Field = None
        self._CompareFunc = None
        self._Content = None

    @property
    def Field(self):
        return self._Field

    @Field.setter
    def Field(self, Field):
        self._Field = Field

    @property
    def CompareFunc(self):
        return self._CompareFunc

    @CompareFunc.setter
    def CompareFunc(self, CompareFunc):
        self._CompareFunc = CompareFunc

    @property
    def Content(self):
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content


    def _deserialize(self, params):
        self._Field = params.get("Field")
        self._CompareFunc = params.get("CompareFunc")
        self._Content = params.get("Content")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAntiInfoLeakageRulesRequest(AbstractModel):
    """DescribeAntiInfoLeakageRules request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _Offset: Page turning support, read offset
        :type Offset: int
        :param _Limit: Paging support, read length limit
        :type Limit: int
        :param _Order: Sort method, asc or desc
        :type Order: str
        :param _Filters: Filter. The following values are allowed:
RuleId,Match_field,Name,Action,Status
        :type Filters: list of FiltersItemNew
        """
        self._Domain = None
        self._Offset = None
        self._Limit = None
        self._Order = None
        self._Filters = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Order = params.get("Order")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = FiltersItemNew()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAntiInfoLeakageRulesResponse(AbstractModel):
    """DescribeAntiInfoLeakageRules response structure.

    """

    def __init__(self):
        r"""
        :param _Total: Number of records
        :type Total: int
        :param _RuleList: List of rules
        :type RuleList: list of DescribeAntiLeakageItem
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Total = None
        self._RuleList = None
        self._RequestId = None

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RuleList(self):
        return self._RuleList

    @RuleList.setter
    def RuleList(self, RuleList):
        self._RuleList = RuleList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("RuleList") is not None:
            self._RuleList = []
            for item in params.get("RuleList"):
                obj = DescribeAntiLeakageItem()
                obj._deserialize(item)
                self._RuleList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAntiLeakageItem(AbstractModel):
    """Output parameters

    """

    def __init__(self):
        r"""
        :param _RuleId: Rule ID
        :type RuleId: int
        :param _Name: Name
        :type Name: str
        :param _Status: Status value
        :type Status: int
        :param _Action: Action
        :type Action: str
        :param _CreateTime: Creation time
        :type CreateTime: str
        :param _Strategies: Match condition
Note: This field may return null, indicating that no valid values can be obtained.
        :type Strategies: list of DescribeAntiInfoLeakRulesStrategyItem
        :param _Uri: Matched URL

Note: This field may return null, indicating that no valid values can be obtained.
        :type Uri: str
        :param _ModifyTime: Modification time

Note: This field may return null, indicating that no valid values can be obtained.
        :type ModifyTime: str
        """
        self._RuleId = None
        self._Name = None
        self._Status = None
        self._Action = None
        self._CreateTime = None
        self._Strategies = None
        self._Uri = None
        self._ModifyTime = None

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Action(self):
        return self._Action

    @Action.setter
    def Action(self, Action):
        self._Action = Action

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def Strategies(self):
        return self._Strategies

    @Strategies.setter
    def Strategies(self, Strategies):
        self._Strategies = Strategies

    @property
    def Uri(self):
        return self._Uri

    @Uri.setter
    def Uri(self, Uri):
        self._Uri = Uri

    @property
    def ModifyTime(self):
        return self._ModifyTime

    @ModifyTime.setter
    def ModifyTime(self, ModifyTime):
        self._ModifyTime = ModifyTime


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        self._Name = params.get("Name")
        self._Status = params.get("Status")
        self._Action = params.get("Action")
        self._CreateTime = params.get("CreateTime")
        if params.get("Strategies") is not None:
            self._Strategies = []
            for item in params.get("Strategies"):
                obj = DescribeAntiInfoLeakRulesStrategyItem()
                obj._deserialize(item)
                self._Strategies.append(obj)
        self._Uri = params.get("Uri")
        self._ModifyTime = params.get("ModifyTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAttackTypeRequest(AbstractModel):
    """DescribeAttackType request structure.

    """

    def __init__(self):
        r"""
        :param _FromTime: Start time
        :type FromTime: str
        :param _ToTime: End time
        :type ToTime: str
        :param _Host: Compatible host, gradually phasing out Host field
        :type Host: str
        :param _Edition: Only two values are valid: sparta-waf, clb-waf. No filtering if not input.
        :type Edition: str
        :param _InstanceID: WAF instance ID. No filter will be carried out if it is not input.
        :type InstanceID: str
        :param _Domain: Domain filtering, not applied if not input, used to replace Host field and phase out Host
        :type Domain: str
        """
        self._FromTime = None
        self._ToTime = None
        self._Host = None
        self._Edition = None
        self._InstanceID = None
        self._Domain = None

    @property
    def FromTime(self):
        return self._FromTime

    @FromTime.setter
    def FromTime(self, FromTime):
        self._FromTime = FromTime

    @property
    def ToTime(self):
        return self._ToTime

    @ToTime.setter
    def ToTime(self, ToTime):
        self._ToTime = ToTime

    @property
    def Host(self):
        return self._Host

    @Host.setter
    def Host(self, Host):
        self._Host = Host

    @property
    def Edition(self):
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def InstanceID(self):
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain


    def _deserialize(self, params):
        self._FromTime = params.get("FromTime")
        self._ToTime = params.get("ToTime")
        self._Host = params.get("Host")
        self._Edition = params.get("Edition")
        self._InstanceID = params.get("InstanceID")
        self._Domain = params.get("Domain")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAttackTypeResponse(AbstractModel):
    """DescribeAttackType response structure.

    """

    def __init__(self):
        r"""
        :param _Piechart: Quantity
        :type Piechart: list of PiechartItem
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Piechart = None
        self._RequestId = None

    @property
    def Piechart(self):
        return self._Piechart

    @Piechart.setter
    def Piechart(self, Piechart):
        self._Piechart = Piechart

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Piechart") is not None:
            self._Piechart = []
            for item in params.get("Piechart"):
                obj = PiechartItem()
                obj._deserialize(item)
                self._Piechart.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBatchIpAccessControlRequest(AbstractModel):
    """DescribeBatchIpAccessControl request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filter criteria: supports ActionType 40/42, IP: IP address, Domain: Three types of domains
        :type Filters: list of FiltersItemNew
        :param _OffSet: Offset
        :type OffSet: int
        :param _Limit: Limit
        :type Limit: int
        :param _Sort: Sort parameters
        :type Sort: str
        """
        self._Filters = None
        self._OffSet = None
        self._Limit = None
        self._Sort = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OffSet(self):
        return self._OffSet

    @OffSet.setter
    def OffSet(self, OffSet):
        self._OffSet = OffSet

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Sort(self):
        return self._Sort

    @Sort.setter
    def Sort(self, Sort):
        self._Sort = Sort


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = FiltersItemNew()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._OffSet = params.get("OffSet")
        self._Limit = params.get("Limit")
        self._Sort = params.get("Sort")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBatchIpAccessControlResponse(AbstractModel):
    """DescribeBatchIpAccessControl response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Output
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.waf.v20180125.models.BatchIpAccessControlData`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BatchIpAccessControlData()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeCCRuleListRequest(AbstractModel):
    """DescribeCCRuleList request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name of the API to be queried
        :type Domain: str
        :param _Offset: Offset
        :type Offset: int
        :param _Limit: Capacity
        :type Limit: int
        :param _By: Currently supports sorting by ts_version
        :type By: str
        :param _Filters: Filter array. A name can be one of the following values: RuleID, ParamName, Url, Action, Method, Source, and Status.
        :type Filters: list of FiltersItemNew
        :param _Order: asc or desc
        :type Order: str
        """
        self._Domain = None
        self._Offset = None
        self._Limit = None
        self._By = None
        self._Filters = None
        self._Order = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._By = params.get("By")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = FiltersItemNew()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCCRuleListResponse(AbstractModel):
    """DescribeCCRuleList response structure.

    """

    def __init__(self):
        r"""
        :param _Data: List of CC rules found

Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.waf.v20180125.models.CCRuleLists`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = CCRuleLists()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeCCRuleRequest(AbstractModel):
    """DescribeCCRule request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _Offset: Page number
        :type Offset: int
        :param _Limit: Number of pages
        :type Limit: int
        :param _Sort: Sort parameters
        :type Sort: str
        :param _Edition: clb-waf or sparta-waf
        :type Edition: str
        :param _Name: Filter criteria.
        :type Name: str
        """
        self._Domain = None
        self._Offset = None
        self._Limit = None
        self._Sort = None
        self._Edition = None
        self._Name = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Sort(self):
        return self._Sort

    @Sort.setter
    def Sort(self, Sort):
        self._Sort = Sort

    @property
    def Edition(self):
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Sort = params.get("Sort")
        self._Edition = params.get("Edition")
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCCRuleResponse(AbstractModel):
    """DescribeCCRule response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Result
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.waf.v20180125.models.CCRuleData`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = CCRuleData()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeCertificateVerifyResultRequest(AbstractModel):
    """DescribeCertificateVerifyResult request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _CertType: Certificate type. 0: no certificate, with only the HTTP listening port configured; 1: self-owned certificate; 2: managed certificate.
        :type CertType: int
        :param _Certificate: When CertType is 1, this parameter is required, indicating the self-owned certificate chain
        :type Certificate: str
        :param _CertID: When CertType is 2, this parameter must be filled, indicating the certificate ID hosted on Tencent Cloud's SSL platform
        :type CertID: str
        :param _PrivateKey: When CertType=1, this parameter is required, indicating the private key of the self-owned certificate.
        :type PrivateKey: str
        """
        self._Domain = None
        self._CertType = None
        self._Certificate = None
        self._CertID = None
        self._PrivateKey = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def CertType(self):
        return self._CertType

    @CertType.setter
    def CertType(self, CertType):
        self._CertType = CertType

    @property
    def Certificate(self):
        return self._Certificate

    @Certificate.setter
    def Certificate(self, Certificate):
        self._Certificate = Certificate

    @property
    def CertID(self):
        return self._CertID

    @CertID.setter
    def CertID(self, CertID):
        self._CertID = CertID

    @property
    def PrivateKey(self):
        return self._PrivateKey

    @PrivateKey.setter
    def PrivateKey(self, PrivateKey):
        self._PrivateKey = PrivateKey


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._CertType = params.get("CertType")
        self._Certificate = params.get("Certificate")
        self._CertID = params.get("CertID")
        self._PrivateKey = params.get("PrivateKey")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCertificateVerifyResultResponse(AbstractModel):
    """DescribeCertificateVerifyResult response structure.

    """

    def __init__(self):
        r"""
        :param _Status: Status code
0: normal certificate
310: abnormal certificate
311: certificate expired
312: certificate about to expire
        :type Status: int
        :param _Detail: Error details
        :type Detail: list of str
        :param _NotAfter: Expiration time
        :type NotAfter: str
        :param _Changed: Whether the certificate is changed
0: not changed
1: changed
Note: This field may return null, indicating that no valid values can be obtained.
        :type Changed: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Status = None
        self._Detail = None
        self._NotAfter = None
        self._Changed = None
        self._RequestId = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Detail(self):
        return self._Detail

    @Detail.setter
    def Detail(self, Detail):
        self._Detail = Detail

    @property
    def NotAfter(self):
        return self._NotAfter

    @NotAfter.setter
    def NotAfter(self, NotAfter):
        self._NotAfter = NotAfter

    @property
    def Changed(self):
        return self._Changed

    @Changed.setter
    def Changed(self, Changed):
        self._Changed = Changed

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._Detail = params.get("Detail")
        self._NotAfter = params.get("NotAfter")
        self._Changed = params.get("Changed")
        self._RequestId = params.get("RequestId")


class DescribeCiphersDetailRequest(AbstractModel):
    """DescribeCiphersDetail request structure.

    """


class DescribeCiphersDetailResponse(AbstractModel):
    """DescribeCiphersDetail response structure.

    """

    def __init__(self):
        r"""
        :param _Ciphers: Cipher suite information

Note: This field may return null, indicating that no valid values can be obtained.
        :type Ciphers: list of TLSCiphers
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Ciphers = None
        self._RequestId = None

    @property
    def Ciphers(self):
        return self._Ciphers

    @Ciphers.setter
    def Ciphers(self, Ciphers):
        self._Ciphers = Ciphers

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Ciphers") is not None:
            self._Ciphers = []
            for item in params.get("Ciphers"):
                obj = TLSCiphers()
                obj._deserialize(item)
                self._Ciphers.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCustomRuleListRequest(AbstractModel):
    """DescribeCustomRuleList request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _Offset: Offset
        :type Offset: int
        :param _Limit: Capacity
        :type Limit: int
        :param _Filters: Filter array. A name can be one of the following: RuleID, RuleName, and Match.
        :type Filters: list of FiltersItemNew
        :param _Order: asc or desc
        :type Order: str
        :param _By: exp_ts or mod_ts
        :type By: str
        :param _DomainList: Domain name list to query. This parameter is not required on the access control page.
        :type DomainList: list of str
        """
        self._Domain = None
        self._Offset = None
        self._Limit = None
        self._Filters = None
        self._Order = None
        self._By = None
        self._DomainList = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def DomainList(self):
        return self._DomainList

    @DomainList.setter
    def DomainList(self, DomainList):
        self._DomainList = DomainList


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = FiltersItemNew()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        self._DomainList = params.get("DomainList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCustomRuleListResponse(AbstractModel):
    """DescribeCustomRuleList response structure.

    """

    def __init__(self):
        r"""
        :param _RuleList: Rule details
        :type RuleList: list of DescribeCustomRulesRspRuleListItem
        :param _TotalCount: Number of rules
        :type TotalCount: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RuleList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def RuleList(self):
        return self._RuleList

    @RuleList.setter
    def RuleList(self, RuleList):
        self._RuleList = RuleList

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RuleList") is not None:
            self._RuleList = []
            for item in params.get("RuleList"):
                obj = DescribeCustomRulesRspRuleListItem()
                obj._deserialize(item)
                self._RuleList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeCustomRulesRspRuleListItem(AbstractModel):
    """Complex type in the DescribeCustomRules interface response packet

    """

    def __init__(self):
        r"""
        :param _ActionType: Action type
        :type ActionType: str
        :param _Bypass: Skipped Policy
        :type Bypass: str
        :param _CreateTime: Creation time
        :type CreateTime: str
        :param _ExpireTime: Expiration time
        :type ExpireTime: str
        :param _Name: Policy name
        :type Name: str
        :param _Redirect: URL for redirection
        :type Redirect: str
        :param _RuleId: Policy ID
        :type RuleId: str
        :param _SortId: Priority
        :type SortId: str
        :param _Status: Status
        :type Status: str
        :param _Strategies: Policy details
        :type Strategies: list of Strategy
        :param _EventId: Event ID

Note: This field may return null, indicating that no valid values can be obtained.
        :type EventId: str
        :param _ModifyTime: Modification time

Note: This field may return null, indicating that no valid values can be obtained.
        :type ModifyTime: str
        :param _ValidStatus: Effective status
Note: This field may return null, indicating that no valid values can be obtained.
        :type ValidStatus: int
        :param _Source: Source
Note: This field may return null, indicating that no valid values can be obtained.
        :type Source: str
        :param _JobType: Scheduled task type
Note: This field may return null, indicating that no valid values can be obtained.
        :type JobType: str
        :param _JobDateTime: Scheduled task configuration
Note: This field may return null, indicating that no valid values can be obtained.
        :type JobDateTime: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        :param _CronType: Periodic task granularity
Note: This field may return null, indicating that no valid values can be obtained.
        :type CronType: str
        :param _Label: Custom tag in risk control rules, indicating whether a rule is built-in or user-defined
Note: This field may return null, indicating that no valid values can be obtained.
        :type Label: str
        :param _PageId: ID of the blocked page
Note: This field may return null, indicating that no valid values can be obtained.
        :type PageId: str
        :param _Domain: Domain name

Note: This field may return null, indicating that no valid values can be obtained.
        :type Domain: str
        """
        self._ActionType = None
        self._Bypass = None
        self._CreateTime = None
        self._ExpireTime = None
        self._Name = None
        self._Redirect = None
        self._RuleId = None
        self._SortId = None
        self._Status = None
        self._Strategies = None
        self._EventId = None
        self._ModifyTime = None
        self._ValidStatus = None
        self._Source = None
        self._JobType = None
        self._JobDateTime = None
        self._CronType = None
        self._Label = None
        self._PageId = None
        self._Domain = None

    @property
    def ActionType(self):
        return self._ActionType

    @ActionType.setter
    def ActionType(self, ActionType):
        self._ActionType = ActionType

    @property
    def Bypass(self):
        return self._Bypass

    @Bypass.setter
    def Bypass(self, Bypass):
        self._Bypass = Bypass

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ExpireTime(self):
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Redirect(self):
        return self._Redirect

    @Redirect.setter
    def Redirect(self, Redirect):
        self._Redirect = Redirect

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def SortId(self):
        return self._SortId

    @SortId.setter
    def SortId(self, SortId):
        self._SortId = SortId

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Strategies(self):
        return self._Strategies

    @Strategies.setter
    def Strategies(self, Strategies):
        self._Strategies = Strategies

    @property
    def EventId(self):
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId

    @property
    def ModifyTime(self):
        return self._ModifyTime

    @ModifyTime.setter
    def ModifyTime(self, ModifyTime):
        self._ModifyTime = ModifyTime

    @property
    def ValidStatus(self):
        return self._ValidStatus

    @ValidStatus.setter
    def ValidStatus(self, ValidStatus):
        self._ValidStatus = ValidStatus

    @property
    def Source(self):
        return self._Source

    @Source.setter
    def Source(self, Source):
        self._Source = Source

    @property
    def JobType(self):
        return self._JobType

    @JobType.setter
    def JobType(self, JobType):
        self._JobType = JobType

    @property
    def JobDateTime(self):
        return self._JobDateTime

    @JobDateTime.setter
    def JobDateTime(self, JobDateTime):
        self._JobDateTime = JobDateTime

    @property
    def CronType(self):
        return self._CronType

    @CronType.setter
    def CronType(self, CronType):
        self._CronType = CronType

    @property
    def Label(self):
        return self._Label

    @Label.setter
    def Label(self, Label):
        self._Label = Label

    @property
    def PageId(self):
        return self._PageId

    @PageId.setter
    def PageId(self, PageId):
        self._PageId = PageId

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain


    def _deserialize(self, params):
        self._ActionType = params.get("ActionType")
        self._Bypass = params.get("Bypass")
        self._CreateTime = params.get("CreateTime")
        self._ExpireTime = params.get("ExpireTime")
        self._Name = params.get("Name")
        self._Redirect = params.get("Redirect")
        self._RuleId = params.get("RuleId")
        self._SortId = params.get("SortId")
        self._Status = params.get("Status")
        if params.get("Strategies") is not None:
            self._Strategies = []
            for item in params.get("Strategies"):
                obj = Strategy()
                obj._deserialize(item)
                self._Strategies.append(obj)
        self._EventId = params.get("EventId")
        self._ModifyTime = params.get("ModifyTime")
        self._ValidStatus = params.get("ValidStatus")
        self._Source = params.get("Source")
        self._JobType = params.get("JobType")
        if params.get("JobDateTime") is not None:
            self._JobDateTime = JobDateTime()
            self._JobDateTime._deserialize(params.get("JobDateTime"))
        self._CronType = params.get("CronType")
        self._Label = params.get("Label")
        self._PageId = params.get("PageId")
        self._Domain = params.get("Domain")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCustomWhiteRuleRequest(AbstractModel):
    """DescribeCustomWhiteRule request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _Offset: Offset.
        :type Offset: int
        :param _Limit: Capacity
        :type Limit: int
        :param _Filters: Filter array. A name can be one of the following: RuleID, RuleName, and Match.
        :type Filters: list of FiltersItemNew
        :param _Order: asc or desc
        :type Order: str
        :param _By: exp_ts or mod_ts
        :type By: str
        """
        self._Domain = None
        self._Offset = None
        self._Limit = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = FiltersItemNew()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCustomWhiteRuleResponse(AbstractModel):
    """DescribeCustomWhiteRule response structure.

    """

    def __init__(self):
        r"""
        :param _RuleList: Rule details
        :type RuleList: list of DescribeCustomRulesRspRuleListItem
        :param _TotalCount: Number of rules
        :type TotalCount: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RuleList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def RuleList(self):
        return self._RuleList

    @RuleList.setter
    def RuleList(self, RuleList):
        self._RuleList = RuleList

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RuleList") is not None:
            self._RuleList = []
            for item in params.get("RuleList"):
                obj = DescribeCustomRulesRspRuleListItem()
                obj._deserialize(item)
                self._RuleList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeDomainCountInfoRequest(AbstractModel):
    """DescribeDomainCountInfo request structure.

    """


class DescribeDomainCountInfoResponse(AbstractModel):
    """DescribeDomainCountInfo response structure.

    """

    def __init__(self):
        r"""
        :param _AllDomain: Total number of domain names
        :type AllDomain: int
        :param _UpdateTime: Last discovery time
        :type UpdateTime: str
        :param _WafDomainCount: Total number of connected domains
        :type WafDomainCount: int
        :param _LeftDomainCount: Remaining quota
        :type LeftDomainCount: int
        :param _OpenWafDomain: Number of protected domain names
        :type OpenWafDomain: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._AllDomain = None
        self._UpdateTime = None
        self._WafDomainCount = None
        self._LeftDomainCount = None
        self._OpenWafDomain = None
        self._RequestId = None

    @property
    def AllDomain(self):
        return self._AllDomain

    @AllDomain.setter
    def AllDomain(self, AllDomain):
        self._AllDomain = AllDomain

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def WafDomainCount(self):
        return self._WafDomainCount

    @WafDomainCount.setter
    def WafDomainCount(self, WafDomainCount):
        self._WafDomainCount = WafDomainCount

    @property
    def LeftDomainCount(self):
        return self._LeftDomainCount

    @LeftDomainCount.setter
    def LeftDomainCount(self, LeftDomainCount):
        self._LeftDomainCount = LeftDomainCount

    @property
    def OpenWafDomain(self):
        return self._OpenWafDomain

    @OpenWafDomain.setter
    def OpenWafDomain(self, OpenWafDomain):
        self._OpenWafDomain = OpenWafDomain

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AllDomain = params.get("AllDomain")
        self._UpdateTime = params.get("UpdateTime")
        self._WafDomainCount = params.get("WafDomainCount")
        self._LeftDomainCount = params.get("LeftDomainCount")
        self._OpenWafDomain = params.get("OpenWafDomain")
        self._RequestId = params.get("RequestId")


class DescribeDomainDetailsClbRequest(AbstractModel):
    """DescribeDomainDetailsClb request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _DomainId: Domain ID
        :type DomainId: str
        :param _InstanceId: Instance ID
        :type InstanceId: str
        """
        self._Domain = None
        self._DomainId = None
        self._InstanceId = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def DomainId(self):
        return self._DomainId

    @DomainId.setter
    def DomainId(self, DomainId):
        self._DomainId = DomainId

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._DomainId = params.get("DomainId")
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDomainDetailsClbResponse(AbstractModel):
    """DescribeDomainDetailsClb response structure.

    """

    def __init__(self):
        r"""
        :param _DomainsClbPartInfo: CLB domain details
        :type DomainsClbPartInfo: :class:`tencentcloud.waf.v20180125.models.ClbDomainsInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DomainsClbPartInfo = None
        self._RequestId = None

    @property
    def DomainsClbPartInfo(self):
        return self._DomainsClbPartInfo

    @DomainsClbPartInfo.setter
    def DomainsClbPartInfo(self, DomainsClbPartInfo):
        self._DomainsClbPartInfo = DomainsClbPartInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DomainsClbPartInfo") is not None:
            self._DomainsClbPartInfo = ClbDomainsInfo()
            self._DomainsClbPartInfo._deserialize(params.get("DomainsClbPartInfo"))
        self._RequestId = params.get("RequestId")


class DescribeDomainDetailsSaasRequest(AbstractModel):
    """DescribeDomainDetailsSaas request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _DomainId: Domain ID
        :type DomainId: str
        :param _InstanceId: Instance ID
        :type InstanceId: str
        """
        self._Domain = None
        self._DomainId = None
        self._InstanceId = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def DomainId(self):
        return self._DomainId

    @DomainId.setter
    def DomainId(self, DomainId):
        self._DomainId = DomainId

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._DomainId = params.get("DomainId")
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDomainDetailsSaasResponse(AbstractModel):
    """DescribeDomainDetailsSaas response structure.

    """

    def __init__(self):
        r"""
        :param _DomainsPartInfo: Domain name details
        :type DomainsPartInfo: :class:`tencentcloud.waf.v20180125.models.DomainsPartInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DomainsPartInfo = None
        self._RequestId = None

    @property
    def DomainsPartInfo(self):
        return self._DomainsPartInfo

    @DomainsPartInfo.setter
    def DomainsPartInfo(self, DomainsPartInfo):
        self._DomainsPartInfo = DomainsPartInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DomainsPartInfo") is not None:
            self._DomainsPartInfo = DomainsPartInfo()
            self._DomainsPartInfo._deserialize(params.get("DomainsPartInfo"))
        self._RequestId = params.get("RequestId")


class DescribeDomainVerifyResultRequest(AbstractModel):
    """DescribeDomainVerifyResult request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _InstanceID: Instance ID
        :type InstanceID: str
        """
        self._Domain = None
        self._InstanceID = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def InstanceID(self):
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._InstanceID = params.get("InstanceID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDomainVerifyResultResponse(AbstractModel):
    """DescribeDomainVerifyResult response structure.

    """

    def __init__(self):
        r"""
        :param _Msg: Result description: if possible, return an empty string
        :type Msg: str
        :param _VerifyCode: Inspection status. 0 indicates that it can be added; greater than 0 indicates that it cannot be added.
        :type VerifyCode: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Msg = None
        self._VerifyCode = None
        self._RequestId = None

    @property
    def Msg(self):
        return self._Msg

    @Msg.setter
    def Msg(self, Msg):
        self._Msg = Msg

    @property
    def VerifyCode(self):
        return self._VerifyCode

    @VerifyCode.setter
    def VerifyCode(self, VerifyCode):
        self._VerifyCode = VerifyCode

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Msg = params.get("Msg")
        self._VerifyCode = params.get("VerifyCode")
        self._RequestId = params.get("RequestId")


class DescribeDomainsRequest(AbstractModel):
    """DescribeDomains request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Paging offset, a multiple of limit. The minimum value is 0, and the maximum value is Total/Limit rounded up.
        :type Offset: int
        :param _Limit: Number of returned domains
        :type Limit: int
        :param _Filters: Filter array
        :type Filters: list of FiltersItemNew
        """
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = FiltersItemNew()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDomainsResponse(AbstractModel):
    """DescribeDomains response structure.

    """

    def __init__(self):
        r"""
        :param _Total: Total number
        :type Total: int
        :param _Domains: Domain list

Note: This field may return null, indicating that no valid values can be obtained.
        :type Domains: list of DomainInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Total = None
        self._Domains = None
        self._RequestId = None

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Domains(self):
        return self._Domains

    @Domains.setter
    def Domains(self, Domains):
        self._Domains = Domains

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("Domains") is not None:
            self._Domains = []
            for item in params.get("Domains"):
                obj = DomainInfo()
                obj._deserialize(item)
                self._Domains.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeFindDomainListRequest(AbstractModel):
    """DescribeFindDomainList request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Pagination
        :type Offset: int
        :param _Limit: Capacity per page
        :type Limit: int
        :param _Key: Filter criteria.
        :type Key: str
        :param _IsWafDomain: Whether to access WAF
        :type IsWafDomain: str
        :param _By: Sort parameters
        :type By: str
        :param _Order: Sorting method
        :type Order: str
        """
        self._Offset = None
        self._Limit = None
        self._Key = None
        self._IsWafDomain = None
        self._By = None
        self._Order = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Key(self):
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key

    @property
    def IsWafDomain(self):
        return self._IsWafDomain

    @IsWafDomain.setter
    def IsWafDomain(self, IsWafDomain):
        self._IsWafDomain = IsWafDomain

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Key = params.get("Key")
        self._IsWafDomain = params.get("IsWafDomain")
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFindDomainListResponse(AbstractModel):
    """DescribeFindDomainList response structure.

    """

    def __init__(self):
        r"""
        :param _Total: Total number of domain names
        :type Total: int
        :param _List: Domain information list
        :type List: list of FindAllDomainDetail
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Total = None
        self._List = None
        self._RequestId = None

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = FindAllDomainDetail()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeHistogramRequest(AbstractModel):
    """DescribeHistogram request structure.

    """

    def __init__(self):
        r"""
        :param _FromTime: Start time
        :type FromTime: str
        :param _ToTime: End time
        :type ToTime: str
        :param _QueryField: Clustering fields. ip: IP aggregation; art: response time aggregation; url: URL aggregation; local: city aggregation after IP conversion; qps: second-level peak request count aggregation; up: peak upstream bandwidth aggregation; down: peak downstream bandwidth aggregation
        :type QueryField: str
        :param _Source: Condition, access for access logs, attack for attack logs
        :type Source: str
        :param _Host: Compatible host, gradually phasing out Host field
        :type Host: str
        :param _Edition: Only two values are valid: sparta-waf, clb-waf. No filtering if not input.
        :type Edition: str
        :param _InstanceID: WAF instance ID. No filter will be carried out if it is not input.
        :type InstanceID: str
        :param _Domain: Domain filtering, not applied if not input, used to replace Host field and phase out Host
        :type Domain: str
        """
        self._FromTime = None
        self._ToTime = None
        self._QueryField = None
        self._Source = None
        self._Host = None
        self._Edition = None
        self._InstanceID = None
        self._Domain = None

    @property
    def FromTime(self):
        return self._FromTime

    @FromTime.setter
    def FromTime(self, FromTime):
        self._FromTime = FromTime

    @property
    def ToTime(self):
        return self._ToTime

    @ToTime.setter
    def ToTime(self, ToTime):
        self._ToTime = ToTime

    @property
    def QueryField(self):
        return self._QueryField

    @QueryField.setter
    def QueryField(self, QueryField):
        self._QueryField = QueryField

    @property
    def Source(self):
        return self._Source

    @Source.setter
    def Source(self, Source):
        self._Source = Source

    @property
    def Host(self):
        return self._Host

    @Host.setter
    def Host(self, Host):
        self._Host = Host

    @property
    def Edition(self):
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def InstanceID(self):
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain


    def _deserialize(self, params):
        self._FromTime = params.get("FromTime")
        self._ToTime = params.get("ToTime")
        self._QueryField = params.get("QueryField")
        self._Source = params.get("Source")
        self._Host = params.get("Host")
        self._Edition = params.get("Edition")
        self._InstanceID = params.get("InstanceID")
        self._Domain = params.get("Domain")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeHistogramResponse(AbstractModel):
    """DescribeHistogram response structure.

    """

    def __init__(self):
        r"""
        :param _Histogram: Statistical data
        :type Histogram: list of str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Histogram = None
        self._RequestId = None

    @property
    def Histogram(self):
        return self._Histogram

    @Histogram.setter
    def Histogram(self, Histogram):
        self._Histogram = Histogram

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Histogram = params.get("Histogram")
        self._RequestId = params.get("RequestId")


class DescribeHostLimitRequest(AbstractModel):
    """DescribeHostLimit request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Added domain
        :type Domain: str
        :param _InstanceID: Instance ID
        :type InstanceID: str
        :param _AlbType: Traffic source
        :type AlbType: str
        """
        self._Domain = None
        self._InstanceID = None
        self._AlbType = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def InstanceID(self):
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID

    @property
    def AlbType(self):
        return self._AlbType

    @AlbType.setter
    def AlbType(self, AlbType):
        self._AlbType = AlbType


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._InstanceID = params.get("InstanceID")
        self._AlbType = params.get("AlbType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeHostLimitResponse(AbstractModel):
    """DescribeHostLimit response structure.

    """

    def __init__(self):
        r"""
        :param _Success: Successfully returned status code

Note: This field may return null, indicating that no valid values can be obtained.
        :type Success: :class:`tencentcloud.waf.v20180125.models.ResponseCode`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Success = None
        self._RequestId = None

    @property
    def Success(self):
        return self._Success

    @Success.setter
    def Success(self, Success):
        self._Success = Success

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Success") is not None:
            self._Success = ResponseCode()
            self._Success._deserialize(params.get("Success"))
        self._RequestId = params.get("RequestId")


class DescribeHostRequest(AbstractModel):
    """DescribeHost request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _DomainId: Domain ID
        :type DomainId: str
        :param _InstanceID: Instance ID
        :type InstanceID: str
        """
        self._Domain = None
        self._DomainId = None
        self._InstanceID = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def DomainId(self):
        return self._DomainId

    @DomainId.setter
    def DomainId(self, DomainId):
        self._DomainId = DomainId

    @property
    def InstanceID(self):
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._DomainId = params.get("DomainId")
        self._InstanceID = params.get("InstanceID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeHostResponse(AbstractModel):
    """DescribeHost response structure.

    """

    def __init__(self):
        r"""
        :param _Host: Domain name details
        :type Host: :class:`tencentcloud.waf.v20180125.models.HostRecord`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Host = None
        self._RequestId = None

    @property
    def Host(self):
        return self._Host

    @Host.setter
    def Host(self, Host):
        self._Host = Host

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Host") is not None:
            self._Host = HostRecord()
            self._Host._deserialize(params.get("Host"))
        self._RequestId = params.get("RequestId")


class DescribeHostsRequest(AbstractModel):
    """DescribeHosts request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Protection domain. If a specific protection domain is to be queried, this parameter should be input. It requires an accurate domain and does not support fuzzy search.
        :type Domain: str
        :param _DomainId: Protection domain ID. If it is to query a specific protection domain, this parameter is input, requiring the accurate domain ID. This parameter does not support fuzzy search.
        :type DomainId: str
        :param _Search: Searching criteria, fuzzy search on domain based on this parameter
        :type Search: str
        :param _Item: Complex search criteria
        :type Item: :class:`tencentcloud.waf.v20180125.models.SearchItem`
        :param _InstanceID: Instance ID
        :type InstanceID: str
        """
        self._Domain = None
        self._DomainId = None
        self._Search = None
        self._Item = None
        self._InstanceID = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def DomainId(self):
        return self._DomainId

    @DomainId.setter
    def DomainId(self, DomainId):
        self._DomainId = DomainId

    @property
    def Search(self):
        return self._Search

    @Search.setter
    def Search(self, Search):
        self._Search = Search

    @property
    def Item(self):
        return self._Item

    @Item.setter
    def Item(self, Item):
        self._Item = Item

    @property
    def InstanceID(self):
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._DomainId = params.get("DomainId")
        self._Search = params.get("Search")
        if params.get("Item") is not None:
            self._Item = SearchItem()
            self._Item._deserialize(params.get("Item"))
        self._InstanceID = params.get("InstanceID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeHostsResponse(AbstractModel):
    """DescribeHosts response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Length of a protection domain list
        :type TotalCount: int
        :param _HostList: List of protection domains

Note: This field may return null, indicating that no valid values can be obtained.
        :type HostList: list of HostRecord
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._HostList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def HostList(self):
        return self._HostList

    @HostList.setter
    def HostList(self, HostList):
        self._HostList = HostList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("HostList") is not None:
            self._HostList = []
            for item in params.get("HostList"):
                obj = HostRecord()
                obj._deserialize(item)
                self._HostList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeInstancesRequest(AbstractModel):
    """DescribeInstances request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Offset.
        :type Offset: int
        :param _Limit: Capacity
        :type Limit: int
        :param _Filters: Filter array
        :type Filters: list of FiltersItemNew
        :param _FreeDelayFlag: Deletion delay flag.
        :type FreeDelayFlag: int
        """
        self._Offset = None
        self._Limit = None
        self._Filters = None
        self._FreeDelayFlag = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def FreeDelayFlag(self):
        return self._FreeDelayFlag

    @FreeDelayFlag.setter
    def FreeDelayFlag(self, FreeDelayFlag):
        self._FreeDelayFlag = FreeDelayFlag


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = FiltersItemNew()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._FreeDelayFlag = params.get("FreeDelayFlag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInstancesResponse(AbstractModel):
    """DescribeInstances response structure.

    """

    def __init__(self):
        r"""
        :param _Total: Total number
        :type Total: int
        :param _Instances: Instance list
        :type Instances: list of InstanceInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Total = None
        self._Instances = None
        self._RequestId = None

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Instances(self):
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = InstanceInfo()
                obj._deserialize(item)
                self._Instances.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeIpAccessControlRequest(AbstractModel):
    """DescribeIpAccessControl request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _Count: Count identifier
        :type Count: int
        :param _ActionType: Action. 40 for querying the allowlist, 42 for querying the blocklist
        :type ActionType: int
        :param _VtsMin: Timestamp of the minimum valid time
        :type VtsMin: int
        :param _VtsMax: Timestamp of the maximum valid time
        :type VtsMax: int
        :param _CtsMin: Timestamp for minimum creation time
        :type CtsMin: int
        :param _CtsMax: Timestamp for Maximum Creation Time
        :type CtsMax: int
        :param _OffSet: Paging offset, a multiple of limit. The minimum value is 0, and the maximum value is Total/Limit rounded up.
        :type OffSet: int
        :param _Limit: Number of records returned per page, which is 20 by default.
        :type Limit: int
        :param _Source: Source.
        :type Source: str
        :param _Sort: Sort parameters
        :type Sort: str
        :param _Ip: IP
        :type Ip: str
        :param _ValidStatus: Effective status.
        :type ValidStatus: int
        :param _ValidTimeStampMin: Timestamp of the minimum valid time
        :type ValidTimeStampMin: str
        :param _ValidTimeStampMax: Timestamp of the maximum valid time
        :type ValidTimeStampMax: str
        :param _RuleId: Rule ID
        :type RuleId: int
        :param _TimerType: Filter by scheduled task type. Valid values: 0, 1, 2, 3, 4.
        :type TimerType: int
        """
        self._Domain = None
        self._Count = None
        self._ActionType = None
        self._VtsMin = None
        self._VtsMax = None
        self._CtsMin = None
        self._CtsMax = None
        self._OffSet = None
        self._Limit = None
        self._Source = None
        self._Sort = None
        self._Ip = None
        self._ValidStatus = None
        self._ValidTimeStampMin = None
        self._ValidTimeStampMax = None
        self._RuleId = None
        self._TimerType = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Count(self):
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def ActionType(self):
        return self._ActionType

    @ActionType.setter
    def ActionType(self, ActionType):
        self._ActionType = ActionType

    @property
    def VtsMin(self):
        warnings.warn("parameter `VtsMin` is deprecated", DeprecationWarning) 

        return self._VtsMin

    @VtsMin.setter
    def VtsMin(self, VtsMin):
        warnings.warn("parameter `VtsMin` is deprecated", DeprecationWarning) 

        self._VtsMin = VtsMin

    @property
    def VtsMax(self):
        warnings.warn("parameter `VtsMax` is deprecated", DeprecationWarning) 

        return self._VtsMax

    @VtsMax.setter
    def VtsMax(self, VtsMax):
        warnings.warn("parameter `VtsMax` is deprecated", DeprecationWarning) 

        self._VtsMax = VtsMax

    @property
    def CtsMin(self):
        return self._CtsMin

    @CtsMin.setter
    def CtsMin(self, CtsMin):
        self._CtsMin = CtsMin

    @property
    def CtsMax(self):
        return self._CtsMax

    @CtsMax.setter
    def CtsMax(self, CtsMax):
        self._CtsMax = CtsMax

    @property
    def OffSet(self):
        return self._OffSet

    @OffSet.setter
    def OffSet(self, OffSet):
        self._OffSet = OffSet

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Source(self):
        return self._Source

    @Source.setter
    def Source(self, Source):
        self._Source = Source

    @property
    def Sort(self):
        return self._Sort

    @Sort.setter
    def Sort(self, Sort):
        self._Sort = Sort

    @property
    def Ip(self):
        return self._Ip

    @Ip.setter
    def Ip(self, Ip):
        self._Ip = Ip

    @property
    def ValidStatus(self):
        return self._ValidStatus

    @ValidStatus.setter
    def ValidStatus(self, ValidStatus):
        self._ValidStatus = ValidStatus

    @property
    def ValidTimeStampMin(self):
        return self._ValidTimeStampMin

    @ValidTimeStampMin.setter
    def ValidTimeStampMin(self, ValidTimeStampMin):
        self._ValidTimeStampMin = ValidTimeStampMin

    @property
    def ValidTimeStampMax(self):
        return self._ValidTimeStampMax

    @ValidTimeStampMax.setter
    def ValidTimeStampMax(self, ValidTimeStampMax):
        self._ValidTimeStampMax = ValidTimeStampMax

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def TimerType(self):
        return self._TimerType

    @TimerType.setter
    def TimerType(self, TimerType):
        self._TimerType = TimerType


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Count = params.get("Count")
        self._ActionType = params.get("ActionType")
        self._VtsMin = params.get("VtsMin")
        self._VtsMax = params.get("VtsMax")
        self._CtsMin = params.get("CtsMin")
        self._CtsMax = params.get("CtsMax")
        self._OffSet = params.get("OffSet")
        self._Limit = params.get("Limit")
        self._Source = params.get("Source")
        self._Sort = params.get("Sort")
        self._Ip = params.get("Ip")
        self._ValidStatus = params.get("ValidStatus")
        self._ValidTimeStampMin = params.get("ValidTimeStampMin")
        self._ValidTimeStampMax = params.get("ValidTimeStampMax")
        self._RuleId = params.get("RuleId")
        self._TimerType = params.get("TimerType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIpAccessControlResponse(AbstractModel):
    """DescribeIpAccessControl response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Output.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.waf.v20180125.models.IpAccessControlData`
        :param _UsedTotal: Total number of IP addresses in the used IP allowlist/blocklist.

Note: This field may return null, indicating that no valid values can be obtained.
        :type UsedTotal: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._UsedTotal = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def UsedTotal(self):
        return self._UsedTotal

    @UsedTotal.setter
    def UsedTotal(self, UsedTotal):
        self._UsedTotal = UsedTotal

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = IpAccessControlData()
            self._Data._deserialize(params.get("Data"))
        self._UsedTotal = params.get("UsedTotal")
        self._RequestId = params.get("RequestId")


class DescribeModuleStatusRequest(AbstractModel):
    """DescribeModuleStatus request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain to query status
        :type Domain: str
        """
        self._Domain = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeModuleStatusResponse(AbstractModel):
    """DescribeModuleStatus response structure.

    """

    def __init__(self):
        r"""
        :param _WebSecurity: Whether web security rules are enabled
        :type WebSecurity: int
        :param _AccessControl: Whether access control rule is enabled
        :type AccessControl: int
        :param _CcProtection: Whether CC protection is enabled.
        :type CcProtection: int
        :param _AntiTamper: Whether web tamper-proof is enabled
        :type AntiTamper: int
        :param _AntiLeakage: Whether information leakage prevention is enabled
        :type AntiLeakage: int
        :param _ApiProtection: Whether API security is enabled
        :type ApiProtection: int
        :param _RateLimit: Traffic limiting module switch
        :type RateLimit: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._WebSecurity = None
        self._AccessControl = None
        self._CcProtection = None
        self._AntiTamper = None
        self._AntiLeakage = None
        self._ApiProtection = None
        self._RateLimit = None
        self._RequestId = None

    @property
    def WebSecurity(self):
        return self._WebSecurity

    @WebSecurity.setter
    def WebSecurity(self, WebSecurity):
        self._WebSecurity = WebSecurity

    @property
    def AccessControl(self):
        return self._AccessControl

    @AccessControl.setter
    def AccessControl(self, AccessControl):
        self._AccessControl = AccessControl

    @property
    def CcProtection(self):
        return self._CcProtection

    @CcProtection.setter
    def CcProtection(self, CcProtection):
        self._CcProtection = CcProtection

    @property
    def AntiTamper(self):
        return self._AntiTamper

    @AntiTamper.setter
    def AntiTamper(self, AntiTamper):
        self._AntiTamper = AntiTamper

    @property
    def AntiLeakage(self):
        return self._AntiLeakage

    @AntiLeakage.setter
    def AntiLeakage(self, AntiLeakage):
        self._AntiLeakage = AntiLeakage

    @property
    def ApiProtection(self):
        return self._ApiProtection

    @ApiProtection.setter
    def ApiProtection(self, ApiProtection):
        self._ApiProtection = ApiProtection

    @property
    def RateLimit(self):
        return self._RateLimit

    @RateLimit.setter
    def RateLimit(self, RateLimit):
        self._RateLimit = RateLimit

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._WebSecurity = params.get("WebSecurity")
        self._AccessControl = params.get("AccessControl")
        self._CcProtection = params.get("CcProtection")
        self._AntiTamper = params.get("AntiTamper")
        self._AntiLeakage = params.get("AntiLeakage")
        self._ApiProtection = params.get("ApiProtection")
        self._RateLimit = params.get("RateLimit")
        self._RequestId = params.get("RequestId")


class DescribeObjectsRequest(AbstractModel):
    """DescribeObjects request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Supported filters:
	ObjectId: CLB instance ID
	VIP: public IP address of the CLB instance
	InstanceId: WAF instance ID
	Domain: precise domain name
	Status: WAF protection switch status. 0: disabled; 1: enabled
	ClsStatus: WAF log switch. 0: disabled; 1: enabled
        :type Filters: list of FiltersItemNew
        """
        self._Filters = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = FiltersItemNew()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeObjectsResponse(AbstractModel):
    """DescribeObjects response structure.

    """

    def __init__(self):
        r"""
        :param _ClbObjects: Object list
        :type ClbObjects: list of ClbObject
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ClbObjects = None
        self._RequestId = None

    @property
    def ClbObjects(self):
        return self._ClbObjects

    @ClbObjects.setter
    def ClbObjects(self, ClbObjects):
        self._ClbObjects = ClbObjects

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ClbObjects") is not None:
            self._ClbObjects = []
            for item in params.get("ClbObjects"):
                obj = ClbObject()
                obj._deserialize(item)
                self._ClbObjects.append(obj)
        self._RequestId = params.get("RequestId")


class DescribePeakPointsRequest(AbstractModel):
    """DescribePeakPoints request structure.

    """

    def __init__(self):
        r"""
        :param _FromTime: Query start time
        :type FromTime: str
        :param _ToTime: Query End Time
        :type ToTime: str
        :param _Domain: The domain to query, leave this parameter blank if querying data for all domains
        :type Domain: str
        :param _Edition: Only two values are valid: sparta-waf, clb-waf. No filtering if not input.
        :type Edition: str
        :param _InstanceID: WAF instance ID. No filter will be carried out if it is not input.
        :type InstanceID: str
        :param _MetricName: Twelve available values:
access: peak QPS trend chart
botAccess: peak bot QPS trend chart
down: downstream peak bandwidth trend chart
up: upstream peak bandwidth trend chart
attack: trend chart of total web attacks
cc: trend chart of total CC attacks
bw: trend chart of total attacks from blocklisted IP addresses
tamper: trend chart of total tampering attacks
leak: total leakage trend chart
acl: trend chart of total access control attacks
http_status: status code trend chart
wx_access: trend chart of peak WeChat mini program QPS
        :type MetricName: str
        """
        self._FromTime = None
        self._ToTime = None
        self._Domain = None
        self._Edition = None
        self._InstanceID = None
        self._MetricName = None

    @property
    def FromTime(self):
        return self._FromTime

    @FromTime.setter
    def FromTime(self, FromTime):
        self._FromTime = FromTime

    @property
    def ToTime(self):
        return self._ToTime

    @ToTime.setter
    def ToTime(self, ToTime):
        self._ToTime = ToTime

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Edition(self):
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def InstanceID(self):
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID

    @property
    def MetricName(self):
        return self._MetricName

    @MetricName.setter
    def MetricName(self, MetricName):
        self._MetricName = MetricName


    def _deserialize(self, params):
        self._FromTime = params.get("FromTime")
        self._ToTime = params.get("ToTime")
        self._Domain = params.get("Domain")
        self._Edition = params.get("Edition")
        self._InstanceID = params.get("InstanceID")
        self._MetricName = params.get("MetricName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePeakPointsResponse(AbstractModel):
    """DescribePeakPoints response structure.

    """

    def __init__(self):
        r"""
        :param _Points: Data points
        :type Points: list of PeakPointsItem
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Points = None
        self._RequestId = None

    @property
    def Points(self):
        return self._Points

    @Points.setter
    def Points(self, Points):
        self._Points = Points

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Points") is not None:
            self._Points = []
            for item in params.get("Points"):
                obj = PeakPointsItem()
                obj._deserialize(item)
                self._Points.append(obj)
        self._RequestId = params.get("RequestId")


class DescribePolicyStatusRequest(AbstractModel):
    """DescribePolicyStatus request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _Edition: clb-waf or saas-waf
        :type Edition: str
        """
        self._Domain = None
        self._Edition = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Edition(self):
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Edition = params.get("Edition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePolicyStatusResponse(AbstractModel):
    """DescribePolicyStatus response structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID
        :type InstanceId: str
        :param _Status: Protection status
        :type Status: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._InstanceId = None
        self._Status = None
        self._RequestId = None

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Status = params.get("Status")
        self._RequestId = params.get("RequestId")


class DescribePortsRequest(AbstractModel):
    """DescribePorts request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceID: Instance ID
        :type InstanceID: str
        :param _Edition: Instance type
        :type Edition: str
        """
        self._InstanceID = None
        self._Edition = None

    @property
    def InstanceID(self):
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID

    @property
    def Edition(self):
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition


    def _deserialize(self, params):
        self._InstanceID = params.get("InstanceID")
        self._Edition = params.get("Edition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePortsResponse(AbstractModel):
    """DescribePorts response structure.

    """

    def __init__(self):
        r"""
        :param _HttpPorts: HTTP Port List
        :type HttpPorts: list of str
        :param _HttpsPorts: HTTPS port list
        :type HttpsPorts: list of str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._HttpPorts = None
        self._HttpsPorts = None
        self._RequestId = None

    @property
    def HttpPorts(self):
        return self._HttpPorts

    @HttpPorts.setter
    def HttpPorts(self, HttpPorts):
        self._HttpPorts = HttpPorts

    @property
    def HttpsPorts(self):
        return self._HttpsPorts

    @HttpsPorts.setter
    def HttpsPorts(self, HttpsPorts):
        self._HttpsPorts = HttpsPorts

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._HttpPorts = params.get("HttpPorts")
        self._HttpsPorts = params.get("HttpsPorts")
        self._RequestId = params.get("RequestId")


class DescribeRuleLimitRequest(AbstractModel):
    """DescribeRuleLimit request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _InstanceId: Instance ID
        :type InstanceId: str
        """
        self._Domain = None
        self._InstanceId = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleLimitResponse(AbstractModel):
    """DescribeRuleLimit response structure.

    """

    def __init__(self):
        r"""
        :param _Res: WAF module specifications
        :type Res: :class:`tencentcloud.waf.v20180125.models.WafRuleLimit`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Res = None
        self._RequestId = None

    @property
    def Res(self):
        return self._Res

    @Res.setter
    def Res(self, Res):
        self._Res = Res

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Res") is not None:
            self._Res = WafRuleLimit()
            self._Res._deserialize(params.get("Res"))
        self._RequestId = params.get("RequestId")


class DescribeSessionRequest(AbstractModel):
    """DescribeSession request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _Edition: clb-waf or sparta-waf
        :type Edition: str
        """
        self._Domain = None
        self._Edition = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Edition(self):
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Edition = params.get("Edition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSessionResponse(AbstractModel):
    """DescribeSession response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Returned result
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.waf.v20180125.models.SessionData`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = SessionData()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeSpartaProtectionInfoRequest(AbstractModel):
    """DescribeSpartaProtectionInfo request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _Edition: Version
        :type Edition: str
        :param _InstanceID: Instance
        :type InstanceID: str
        """
        self._Domain = None
        self._Edition = None
        self._InstanceID = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Edition(self):
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def InstanceID(self):
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Edition = params.get("Edition")
        self._InstanceID = params.get("InstanceID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSpartaProtectionInfoResponse(AbstractModel):
    """DescribeSpartaProtectionInfo response structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _DomainId: Domain ID
        :type DomainId: str
        :param _Cname: CNAME value
        :type Cname: str
        :param _Status: Status
        :type Status: str
        :param _SrcList: Source IP address list
        :type SrcList: list of str
        :param _CertType: Certificate type
        :type CertType: str
        :param _Cert: Certificate
        :type Cert: str
        :param _PrivateKey: Private key
        :type PrivateKey: str
        :param _Sslid: SSL ID
        :type Sslid: str
        :param _IsCdn: Whether it is a CDN
        :type IsCdn: str
        :param _GrayAreas: Grayscale area list
        :type GrayAreas: list of str
        :param _Engine: Engine
        :type Engine: str
        :param _HttpsRewrite: HTTPS rewriting
        :type HttpsRewrite: str
        :param _UpstreamType: upstreamType value
        :type UpstreamType: str
        :param _UpstreamDomain: Value of upstreamDomain
        :type UpstreamDomain: str
        :param _UpstreamScheme: Value of upstreamScheme
        :type UpstreamScheme: str
        :param _IsHttp2: Whether it is HTTP2.
        :type IsHttp2: str
        :param _IsWebsocket: Whether it includes WebSocket
        :type IsWebsocket: str
        :param _LoadBalance: LoadBalance information
        :type LoadBalance: str
        :param _HttpsUpstreamPort: Value of httpsUpstreamPort
        :type HttpsUpstreamPort: str
        :param _Ports: Port information
        :type Ports: list of PortItem
        :param _IsGray: Whether it is grayscale
        :type IsGray: str
        :param _Mode: Mode
        :type Mode: str
        :param _Level: Defense level: 100, 200, 300
        :type Level: str
        :param _IsKeepAlive: Whether to maintain a long connection with the origin server
        :type IsKeepAlive: str
        :param _Anycast: 0: BGP; 1: Anycast.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Anycast: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Domain = None
        self._DomainId = None
        self._Cname = None
        self._Status = None
        self._SrcList = None
        self._CertType = None
        self._Cert = None
        self._PrivateKey = None
        self._Sslid = None
        self._IsCdn = None
        self._GrayAreas = None
        self._Engine = None
        self._HttpsRewrite = None
        self._UpstreamType = None
        self._UpstreamDomain = None
        self._UpstreamScheme = None
        self._IsHttp2 = None
        self._IsWebsocket = None
        self._LoadBalance = None
        self._HttpsUpstreamPort = None
        self._Ports = None
        self._IsGray = None
        self._Mode = None
        self._Level = None
        self._IsKeepAlive = None
        self._Anycast = None
        self._RequestId = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def DomainId(self):
        return self._DomainId

    @DomainId.setter
    def DomainId(self, DomainId):
        self._DomainId = DomainId

    @property
    def Cname(self):
        return self._Cname

    @Cname.setter
    def Cname(self, Cname):
        self._Cname = Cname

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def SrcList(self):
        return self._SrcList

    @SrcList.setter
    def SrcList(self, SrcList):
        self._SrcList = SrcList

    @property
    def CertType(self):
        return self._CertType

    @CertType.setter
    def CertType(self, CertType):
        self._CertType = CertType

    @property
    def Cert(self):
        return self._Cert

    @Cert.setter
    def Cert(self, Cert):
        self._Cert = Cert

    @property
    def PrivateKey(self):
        return self._PrivateKey

    @PrivateKey.setter
    def PrivateKey(self, PrivateKey):
        self._PrivateKey = PrivateKey

    @property
    def Sslid(self):
        return self._Sslid

    @Sslid.setter
    def Sslid(self, Sslid):
        self._Sslid = Sslid

    @property
    def IsCdn(self):
        return self._IsCdn

    @IsCdn.setter
    def IsCdn(self, IsCdn):
        self._IsCdn = IsCdn

    @property
    def GrayAreas(self):
        return self._GrayAreas

    @GrayAreas.setter
    def GrayAreas(self, GrayAreas):
        self._GrayAreas = GrayAreas

    @property
    def Engine(self):
        return self._Engine

    @Engine.setter
    def Engine(self, Engine):
        self._Engine = Engine

    @property
    def HttpsRewrite(self):
        return self._HttpsRewrite

    @HttpsRewrite.setter
    def HttpsRewrite(self, HttpsRewrite):
        self._HttpsRewrite = HttpsRewrite

    @property
    def UpstreamType(self):
        return self._UpstreamType

    @UpstreamType.setter
    def UpstreamType(self, UpstreamType):
        self._UpstreamType = UpstreamType

    @property
    def UpstreamDomain(self):
        return self._UpstreamDomain

    @UpstreamDomain.setter
    def UpstreamDomain(self, UpstreamDomain):
        self._UpstreamDomain = UpstreamDomain

    @property
    def UpstreamScheme(self):
        return self._UpstreamScheme

    @UpstreamScheme.setter
    def UpstreamScheme(self, UpstreamScheme):
        self._UpstreamScheme = UpstreamScheme

    @property
    def IsHttp2(self):
        return self._IsHttp2

    @IsHttp2.setter
    def IsHttp2(self, IsHttp2):
        self._IsHttp2 = IsHttp2

    @property
    def IsWebsocket(self):
        return self._IsWebsocket

    @IsWebsocket.setter
    def IsWebsocket(self, IsWebsocket):
        self._IsWebsocket = IsWebsocket

    @property
    def LoadBalance(self):
        return self._LoadBalance

    @LoadBalance.setter
    def LoadBalance(self, LoadBalance):
        self._LoadBalance = LoadBalance

    @property
    def HttpsUpstreamPort(self):
        return self._HttpsUpstreamPort

    @HttpsUpstreamPort.setter
    def HttpsUpstreamPort(self, HttpsUpstreamPort):
        self._HttpsUpstreamPort = HttpsUpstreamPort

    @property
    def Ports(self):
        return self._Ports

    @Ports.setter
    def Ports(self, Ports):
        self._Ports = Ports

    @property
    def IsGray(self):
        return self._IsGray

    @IsGray.setter
    def IsGray(self, IsGray):
        self._IsGray = IsGray

    @property
    def Mode(self):
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def Level(self):
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level

    @property
    def IsKeepAlive(self):
        return self._IsKeepAlive

    @IsKeepAlive.setter
    def IsKeepAlive(self, IsKeepAlive):
        self._IsKeepAlive = IsKeepAlive

    @property
    def Anycast(self):
        return self._Anycast

    @Anycast.setter
    def Anycast(self, Anycast):
        self._Anycast = Anycast

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._DomainId = params.get("DomainId")
        self._Cname = params.get("Cname")
        self._Status = params.get("Status")
        self._SrcList = params.get("SrcList")
        self._CertType = params.get("CertType")
        self._Cert = params.get("Cert")
        self._PrivateKey = params.get("PrivateKey")
        self._Sslid = params.get("Sslid")
        self._IsCdn = params.get("IsCdn")
        self._GrayAreas = params.get("GrayAreas")
        self._Engine = params.get("Engine")
        self._HttpsRewrite = params.get("HttpsRewrite")
        self._UpstreamType = params.get("UpstreamType")
        self._UpstreamDomain = params.get("UpstreamDomain")
        self._UpstreamScheme = params.get("UpstreamScheme")
        self._IsHttp2 = params.get("IsHttp2")
        self._IsWebsocket = params.get("IsWebsocket")
        self._LoadBalance = params.get("LoadBalance")
        self._HttpsUpstreamPort = params.get("HttpsUpstreamPort")
        if params.get("Ports") is not None:
            self._Ports = []
            for item in params.get("Ports"):
                obj = PortItem()
                obj._deserialize(item)
                self._Ports.append(obj)
        self._IsGray = params.get("IsGray")
        self._Mode = params.get("Mode")
        self._Level = params.get("Level")
        self._IsKeepAlive = params.get("IsKeepAlive")
        self._Anycast = params.get("Anycast")
        self._RequestId = params.get("RequestId")


class DescribeTlsVersionRequest(AbstractModel):
    """DescribeTlsVersion request structure.

    """


class DescribeTlsVersionResponse(AbstractModel):
    """DescribeTlsVersion response structure.

    """

    def __init__(self):
        r"""
        :param _TLS: TLS key value
        :type TLS: list of TLSVersion
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TLS = None
        self._RequestId = None

    @property
    def TLS(self):
        return self._TLS

    @TLS.setter
    def TLS(self, TLS):
        self._TLS = TLS

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TLS") is not None:
            self._TLS = []
            for item in params.get("TLS"):
                obj = TLSVersion()
                obj._deserialize(item)
                self._TLS.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTopAttackDomainRequest(AbstractModel):
    """DescribeTopAttackDomain request structure.

    """

    def __init__(self):
        r"""
        :param _FromTime: Query start time
        :type FromTime: str
        :param _ToTime: Query end time
        :type ToTime: str
        :param _Count: Top N, selectable from 0-10. The default is 10.
        :type Count: int
        :param _Edition: Only two values are valid: sparta-waf, clb-waf. No filtering if not input.
        :type Edition: str
        :param _InstanceID: WAF instance ID. No filter will be carried out if it is not input.
        :type InstanceID: str
        """
        self._FromTime = None
        self._ToTime = None
        self._Count = None
        self._Edition = None
        self._InstanceID = None

    @property
    def FromTime(self):
        return self._FromTime

    @FromTime.setter
    def FromTime(self, FromTime):
        self._FromTime = FromTime

    @property
    def ToTime(self):
        return self._ToTime

    @ToTime.setter
    def ToTime(self, ToTime):
        self._ToTime = ToTime

    @property
    def Count(self):
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def Edition(self):
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def InstanceID(self):
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID


    def _deserialize(self, params):
        self._FromTime = params.get("FromTime")
        self._ToTime = params.get("ToTime")
        self._Count = params.get("Count")
        self._Edition = params.get("Edition")
        self._InstanceID = params.get("InstanceID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTopAttackDomainResponse(AbstractModel):
    """DescribeTopAttackDomain response structure.

    """

    def __init__(self):
        r"""
        :param _CC: CC attack domain list
        :type CC: list of KVInt
        :param _Web: Web attack domain list
        :type Web: list of KVInt
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._CC = None
        self._Web = None
        self._RequestId = None

    @property
    def CC(self):
        return self._CC

    @CC.setter
    def CC(self, CC):
        self._CC = CC

    @property
    def Web(self):
        return self._Web

    @Web.setter
    def Web(self, Web):
        self._Web = Web

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("CC") is not None:
            self._CC = []
            for item in params.get("CC"):
                obj = KVInt()
                obj._deserialize(item)
                self._CC.append(obj)
        if params.get("Web") is not None:
            self._Web = []
            for item in params.get("Web"):
                obj = KVInt()
                obj._deserialize(item)
                self._Web.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeUserClbWafRegionsRequest(AbstractModel):
    """DescribeUserClbWafRegions request structure.

    """

    def __init__(self):
        r"""
        :param _AlbType: 
        :type AlbType: str
        """
        self._AlbType = None

    @property
    def AlbType(self):
        return self._AlbType

    @AlbType.setter
    def AlbType(self, AlbType):
        self._AlbType = AlbType


    def _deserialize(self, params):
        self._AlbType = params.get("AlbType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeUserClbWafRegionsResponse(AbstractModel):
    """DescribeUserClbWafRegions response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Region (in standard ap-format) list

Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: list of str
        :param _RichDatas: Geographical information with detailed attributes

Note: This field may return null, indicating that no valid values can be obtained.
        :type RichDatas: list of ClbWafRegionItem
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RichDatas = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RichDatas(self):
        return self._RichDatas

    @RichDatas.setter
    def RichDatas(self, RichDatas):
        self._RichDatas = RichDatas

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        if params.get("RichDatas") is not None:
            self._RichDatas = []
            for item in params.get("RichDatas"):
                obj = ClbWafRegionItem()
                obj._deserialize(item)
                self._RichDatas.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeUserDomainInfoRequest(AbstractModel):
    """DescribeUserDomainInfo request structure.

    """


class DescribeUserDomainInfoResponse(AbstractModel):
    """DescribeUserDomainInfo response structure.

    """

    def __init__(self):
        r"""
        :param _UsersInfo: SaaS and CLB domain information
        :type UsersInfo: list of UserDomainInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._UsersInfo = None
        self._RequestId = None

    @property
    def UsersInfo(self):
        return self._UsersInfo

    @UsersInfo.setter
    def UsersInfo(self, UsersInfo):
        self._UsersInfo = UsersInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("UsersInfo") is not None:
            self._UsersInfo = []
            for item in params.get("UsersInfo"):
                obj = UserDomainInfo()
                obj._deserialize(item)
                self._UsersInfo.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeUserLevelRequest(AbstractModel):
    """DescribeUserLevel request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        """
        self._Domain = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeUserLevelResponse(AbstractModel):
    """DescribeUserLevel response structure.

    """

    def __init__(self):
        r"""
        :param _Level: 300: Normal, 400: Strict
        :type Level: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Level = None
        self._RequestId = None

    @property
    def Level(self):
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Level = params.get("Level")
        self._RequestId = params.get("RequestId")


class DescribeVipInfoRequest(AbstractModel):
    """DescribeVipInfo request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceIds: WAF instance ID list
        :type InstanceIds: list of str
        """
        self._InstanceIds = None

    @property
    def InstanceIds(self):
        return self._InstanceIds

    @InstanceIds.setter
    def InstanceIds(self, InstanceIds):
        self._InstanceIds = InstanceIds


    def _deserialize(self, params):
        self._InstanceIds = params.get("InstanceIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVipInfoResponse(AbstractModel):
    """DescribeVipInfo response structure.

    """

    def __init__(self):
        r"""
        :param _VipInfo: VIP information
        :type VipInfo: list of VipInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._VipInfo = None
        self._RequestId = None

    @property
    def VipInfo(self):
        return self._VipInfo

    @VipInfo.setter
    def VipInfo(self, VipInfo):
        self._VipInfo = VipInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("VipInfo") is not None:
            self._VipInfo = []
            for item in params.get("VipInfo"):
                obj = VipInfo()
                obj._deserialize(item)
                self._VipInfo.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeWebshellStatusRequest(AbstractModel):
    """DescribeWebshellStatus request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        """
        self._Domain = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeWebshellStatusResponse(AbstractModel):
    """DescribeWebshellStatus response structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Webshell domain
        :type Domain: str
        :param _Status: Enabling status
        :type Status: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Domain = None
        self._Status = None
        self._RequestId = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Status = params.get("Status")
        self._RequestId = params.get("RequestId")


class DomainInfo(AbstractModel):
    """Domain list

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _DomainId: Domain ID
        :type DomainId: str
        :param _InstanceId: Instance ID
        :type InstanceId: str
        :param _Cname: CNAME Address
        :type Cname: str
        :param _Edition: Instance type of the domain name.
sparta-waf: SaaS WAF instance
clb-waf: CLB WAF instance
cdc-clb-waf: CLB WAF instances in the CDC environment
        :type Edition: str
        :param _Region: Region
"Toronto": "ca"
"Guangzhou": "gz"
"Chengdu": "cd"
"Fuzhou": "fzec"
"Shenzhen": "szx"
"India": "in"
"Jinan": "jnec"
"Chongqing": "cq"
"Tianjin": "tsn"
"Northeast Europe": "ru"
"Nanjing": "nj"
"Silicon Valley, USA": "usw"
"Thailand": "th"
"Guangzhou Open": "gzopen"
"Shenzhen Finance": "szjr"
"Frankfurt": "de"
"Japan": "jp"
"Virginia": "use"
"Beijing": "bj"
"Hong Kong (China)": "hk"
"Hangzhou": "hzec"
"Beijing Finance": "bjjr"
"Shanghai Finance": "shjr"
"Taipei (China)": "tpe"
"Seoul": "kr"
"Shanghai": "sh"
"Singapore": "sg"
"Qingyuan": "qy"
        :type Region: str
        :param _InstanceName: Instance name
        :type InstanceName: str
        :param _ClsStatus: Access log switch status
0: disabled
1: enabled
        :type ClsStatus: int
        :param _FlowMode: CLB WAF usage mode
0: image mode
1: cleaning mode
        :type FlowMode: int
        :param _Status: WAF switch status
0: disabled
1: enabled
        :type Status: int
        :param _Mode: Rule engine protection mode
0: observation mode
1: interception mode
        :type Mode: int
        :param _Engine: Joint status of rule engine and AI engine protection modes.
1: initial status: interception for the rule engine and disabled for the AI engine
10: observation for the rule engine and disabled for the AI engine
11: observation for both the rule engine and AI engine
12: observation for the rule engine and interception for the AI engine
20: interception for the rule engine and disabled for the AI engine
21: interception for the rule engine and observation for the AI engine
22: interception for both the rule engine and AI engine
        :type Engine: int
        :param _CCList: Sandbox cluster origin-pull outbound IP list
        :type CCList: list of str
        :param _RsList: Production cluster origin-pull outbound IP list
        :type RsList: list of str
        :param _Ports: Service port configuration
        :type Ports: list of PortInfo
        :param _LoadBalancerSet: CLB-related configuration
        :type LoadBalancerSet: list of LoadBalancerPackageNew
        :param _AppId: User ID
        :type AppId: int
        :param _State: LB listener status of the domain name protected by CLB WAF0: Operation successful.
4: The LB is being bound.
6: The LB is being unbound.
7: Failed to unbind the LB.
8: Failed to bind the LB.
10: Internal error.
        :type State: int
        :param _CreateTime: Creation time
        :type CreateTime: str
        :param _Ipv6Status: IPv6 switch status.
0: disabled
1: enabled
        :type Ipv6Status: int
        :param _BotStatus: Bot switch status.
0: disabled
1: disabled
2: enabled
3: enabled
        :type BotStatus: int
        :param _Level: Instance version information.
101: Small and Micro Agile Edition
102: Small and Micro Ultra-light Edition
2: Advanced Edition
3: Enterprise Edition
4: Ultimate Edition
6: Exclusive Edition
        :type Level: int
        :param _PostCLSStatus: Shipping status of CLS.
0: disabled
1: enabled
        :type PostCLSStatus: int
        :param _PostCKafkaStatus: Shipping status of CKafka.
0: disabled
1: enabled
        :type PostCKafkaStatus: int
        :param _CdcClusters: Cluster information accessed by the CDC instance domain name, which can be ignored for non-CDC instances.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CdcClusters: str
        :param _ApiStatus: API security switch status.
0: disabled
1: enabled
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApiStatus: int
        :param _AlbType: Application-based CLB type. The default value is clb.
clb: layer-7 CLB
apisix: APISIX gateway
Note: This field may return null, indicating that no valid values can be obtained.
        :type AlbType: str
        :param _SgState: Security group status.
0: not display
1: non-Tencent Cloud origin server
2: Security group binding failed.
3: security groups changed.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SgState: int
        :param _SgDetail: Detailed Explanation of Security Group Status

Note: This field may return null, indicating that no valid values can be obtained.
        :type SgDetail: str
        :param _CloudType: Domain name cloud environment. hybrid: hybrid cloud domain name
public: public cloud domain name
Note: This field may return null, indicating that no valid values can be obtained.
        :type CloudType: str
        :param _Note: Domain name remarks
Note: This field may return null, indicating that no valid values can be obtained.
        :type Note: str
        :param _SrcList: SaaS WAF origin server IP list
Note: This field may return null, indicating that no valid values can be obtained.
        :type SrcList: list of str
        :param _UpstreamDomainList: SaaS WAF origin server domain name list
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpstreamDomainList: list of str
        :param _SgID: Security group ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type SgID: str
        :param _AccessStatus: CLB WAF access status
Note: This field may return null, indicating that no valid values can be obtained.
        :type AccessStatus: int
        """
        self._Domain = None
        self._DomainId = None
        self._InstanceId = None
        self._Cname = None
        self._Edition = None
        self._Region = None
        self._InstanceName = None
        self._ClsStatus = None
        self._FlowMode = None
        self._Status = None
        self._Mode = None
        self._Engine = None
        self._CCList = None
        self._RsList = None
        self._Ports = None
        self._LoadBalancerSet = None
        self._AppId = None
        self._State = None
        self._CreateTime = None
        self._Ipv6Status = None
        self._BotStatus = None
        self._Level = None
        self._PostCLSStatus = None
        self._PostCKafkaStatus = None
        self._CdcClusters = None
        self._ApiStatus = None
        self._AlbType = None
        self._SgState = None
        self._SgDetail = None
        self._CloudType = None
        self._Note = None
        self._SrcList = None
        self._UpstreamDomainList = None
        self._SgID = None
        self._AccessStatus = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def DomainId(self):
        return self._DomainId

    @DomainId.setter
    def DomainId(self, DomainId):
        self._DomainId = DomainId

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Cname(self):
        return self._Cname

    @Cname.setter
    def Cname(self, Cname):
        self._Cname = Cname

    @property
    def Edition(self):
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def InstanceName(self):
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def ClsStatus(self):
        return self._ClsStatus

    @ClsStatus.setter
    def ClsStatus(self, ClsStatus):
        self._ClsStatus = ClsStatus

    @property
    def FlowMode(self):
        return self._FlowMode

    @FlowMode.setter
    def FlowMode(self, FlowMode):
        self._FlowMode = FlowMode

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Mode(self):
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def Engine(self):
        return self._Engine

    @Engine.setter
    def Engine(self, Engine):
        self._Engine = Engine

    @property
    def CCList(self):
        return self._CCList

    @CCList.setter
    def CCList(self, CCList):
        self._CCList = CCList

    @property
    def RsList(self):
        return self._RsList

    @RsList.setter
    def RsList(self, RsList):
        self._RsList = RsList

    @property
    def Ports(self):
        return self._Ports

    @Ports.setter
    def Ports(self, Ports):
        self._Ports = Ports

    @property
    def LoadBalancerSet(self):
        return self._LoadBalancerSet

    @LoadBalancerSet.setter
    def LoadBalancerSet(self, LoadBalancerSet):
        self._LoadBalancerSet = LoadBalancerSet

    @property
    def AppId(self):
        return self._AppId

    @AppId.setter
    def AppId(self, AppId):
        self._AppId = AppId

    @property
    def State(self):
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def Ipv6Status(self):
        return self._Ipv6Status

    @Ipv6Status.setter
    def Ipv6Status(self, Ipv6Status):
        self._Ipv6Status = Ipv6Status

    @property
    def BotStatus(self):
        return self._BotStatus

    @BotStatus.setter
    def BotStatus(self, BotStatus):
        self._BotStatus = BotStatus

    @property
    def Level(self):
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level

    @property
    def PostCLSStatus(self):
        return self._PostCLSStatus

    @PostCLSStatus.setter
    def PostCLSStatus(self, PostCLSStatus):
        self._PostCLSStatus = PostCLSStatus

    @property
    def PostCKafkaStatus(self):
        return self._PostCKafkaStatus

    @PostCKafkaStatus.setter
    def PostCKafkaStatus(self, PostCKafkaStatus):
        self._PostCKafkaStatus = PostCKafkaStatus

    @property
    def CdcClusters(self):
        return self._CdcClusters

    @CdcClusters.setter
    def CdcClusters(self, CdcClusters):
        self._CdcClusters = CdcClusters

    @property
    def ApiStatus(self):
        return self._ApiStatus

    @ApiStatus.setter
    def ApiStatus(self, ApiStatus):
        self._ApiStatus = ApiStatus

    @property
    def AlbType(self):
        return self._AlbType

    @AlbType.setter
    def AlbType(self, AlbType):
        self._AlbType = AlbType

    @property
    def SgState(self):
        return self._SgState

    @SgState.setter
    def SgState(self, SgState):
        self._SgState = SgState

    @property
    def SgDetail(self):
        return self._SgDetail

    @SgDetail.setter
    def SgDetail(self, SgDetail):
        self._SgDetail = SgDetail

    @property
    def CloudType(self):
        return self._CloudType

    @CloudType.setter
    def CloudType(self, CloudType):
        self._CloudType = CloudType

    @property
    def Note(self):
        return self._Note

    @Note.setter
    def Note(self, Note):
        self._Note = Note

    @property
    def SrcList(self):
        return self._SrcList

    @SrcList.setter
    def SrcList(self, SrcList):
        self._SrcList = SrcList

    @property
    def UpstreamDomainList(self):
        return self._UpstreamDomainList

    @UpstreamDomainList.setter
    def UpstreamDomainList(self, UpstreamDomainList):
        self._UpstreamDomainList = UpstreamDomainList

    @property
    def SgID(self):
        return self._SgID

    @SgID.setter
    def SgID(self, SgID):
        self._SgID = SgID

    @property
    def AccessStatus(self):
        return self._AccessStatus

    @AccessStatus.setter
    def AccessStatus(self, AccessStatus):
        self._AccessStatus = AccessStatus


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._DomainId = params.get("DomainId")
        self._InstanceId = params.get("InstanceId")
        self._Cname = params.get("Cname")
        self._Edition = params.get("Edition")
        self._Region = params.get("Region")
        self._InstanceName = params.get("InstanceName")
        self._ClsStatus = params.get("ClsStatus")
        self._FlowMode = params.get("FlowMode")
        self._Status = params.get("Status")
        self._Mode = params.get("Mode")
        self._Engine = params.get("Engine")
        self._CCList = params.get("CCList")
        self._RsList = params.get("RsList")
        if params.get("Ports") is not None:
            self._Ports = []
            for item in params.get("Ports"):
                obj = PortInfo()
                obj._deserialize(item)
                self._Ports.append(obj)
        if params.get("LoadBalancerSet") is not None:
            self._LoadBalancerSet = []
            for item in params.get("LoadBalancerSet"):
                obj = LoadBalancerPackageNew()
                obj._deserialize(item)
                self._LoadBalancerSet.append(obj)
        self._AppId = params.get("AppId")
        self._State = params.get("State")
        self._CreateTime = params.get("CreateTime")
        self._Ipv6Status = params.get("Ipv6Status")
        self._BotStatus = params.get("BotStatus")
        self._Level = params.get("Level")
        self._PostCLSStatus = params.get("PostCLSStatus")
        self._PostCKafkaStatus = params.get("PostCKafkaStatus")
        self._CdcClusters = params.get("CdcClusters")
        self._ApiStatus = params.get("ApiStatus")
        self._AlbType = params.get("AlbType")
        self._SgState = params.get("SgState")
        self._SgDetail = params.get("SgDetail")
        self._CloudType = params.get("CloudType")
        self._Note = params.get("Note")
        self._SrcList = params.get("SrcList")
        self._UpstreamDomainList = params.get("UpstreamDomainList")
        self._SgID = params.get("SgID")
        self._AccessStatus = params.get("AccessStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DomainPackageNew(AbstractModel):
    """CLB-WAF domain extension package

    """

    def __init__(self):
        r"""
        :param _ResourceIds: Resource ID

Note: This field may return null, indicating that no valid values can be obtained.
        :type ResourceIds: str
        :param _ValidTime: Expiration time

Note: This field may return null, indicating that no valid values can be obtained.
        :type ValidTime: str
        :param _RenewFlag: Auto-renewal, 1: Enabled, 0: Disabled

Note: This field may return null, indicating that no valid values can be obtained.
        :type RenewFlag: int
        :param _Count: Number of Package Purchases

Note: This field may return null, indicating that no valid values can be obtained.
        :type Count: int
        :param _Region: Package Purchase Region, currently not used in CLB-WAF

Note: This field may return null, indicating that no valid values can be obtained.
        :type Region: str
        """
        self._ResourceIds = None
        self._ValidTime = None
        self._RenewFlag = None
        self._Count = None
        self._Region = None

    @property
    def ResourceIds(self):
        return self._ResourceIds

    @ResourceIds.setter
    def ResourceIds(self, ResourceIds):
        self._ResourceIds = ResourceIds

    @property
    def ValidTime(self):
        return self._ValidTime

    @ValidTime.setter
    def ValidTime(self, ValidTime):
        self._ValidTime = ValidTime

    @property
    def RenewFlag(self):
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag

    @property
    def Count(self):
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region


    def _deserialize(self, params):
        self._ResourceIds = params.get("ResourceIds")
        self._ValidTime = params.get("ValidTime")
        self._RenewFlag = params.get("RenewFlag")
        self._Count = params.get("Count")
        self._Region = params.get("Region")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DomainRuleId(AbstractModel):
    """Domain name, which corresponds to the rule ID structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name

Note: This field may return null, indicating that no valid values can be obtained.
        :type Domain: str
        :param _RuleId: Rule ID

Note: This field may return null, indicating that no valid values can be obtained.
        :type RuleId: str
        """
        self._Domain = None
        self._RuleId = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._RuleId = params.get("RuleId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DomainURI(AbstractModel):
    """Unique positioning domain

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _Edition: Version
        :type Edition: str
        :param _InstanceID: Instance ID

Note: This field may return null, indicating that no valid values can be obtained.
        :type InstanceID: str
        """
        self._Domain = None
        self._Edition = None
        self._InstanceID = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Edition(self):
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def InstanceID(self):
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Edition = params.get("Edition")
        self._InstanceID = params.get("InstanceID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DomainsPartInfo(AbstractModel):
    """Details of domain names protected by SaaS WAF

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _DomainId: Unique domain name ID
        :type DomainId: str
        :param _InstanceId: Unique instance ID of the domain name
        :type InstanceId: str
        :param _Edition: Instance type of the domain name
        :type Edition: str
        :param _InstanceName: Instance name of the domain name
        :type InstanceName: str
        :param _Cert: Certificate
        :type Cert: str
        :param _CreateTime: Creation time
        :type CreateTime: str
        :param _Engine: Status of the rule engine and AI engine
1: initial status. Interception for the rule engine and disabled for the AI engine.
10: observation for the rule engine and disabled for the AI engine
11: observation for both the rule engine and AI engine
12: observation for the rule engine and interception for the AI engine
20: interception for the rule engine and disabled for the AI engine
21: interception for the rule engine and observation for the AI engine
22: interception for both the rule engine and AI engine
        :type Engine: int
        :param _HttpsRewrite: Whether to enable forced redirection from HTTP to HTTPS
0: do not force redirection
1: enable forced redirection
        :type HttpsRewrite: int
        :param _HttpsUpstreamPort: HTTPS origin-pull port
        :type HttpsUpstreamPort: str
        :param _IsCdn: Whether a layer-7 proxy service is deployed before WAF
0: No proxy service deployed
1: Proxy service deployed, and WAF will use XFF to obtain the client IP address
2: Proxy service deployed and WAF will use remote_addr to obtain the client IP address
3: Proxy service deployed and WAF will use the custom header in ip_headers to obtain the client IP address
        :type IsCdn: int
        :param _IsGray: This parameter has been deprecated.
        :type IsGray: int
        :param _IsHttp2: Whether to enable HTTP2. You should enable HTTPS as well.
0: disable
1: enable
        :type IsHttp2: int
        :param _IsWebsocket: Whether to enable support for WebSocket
0: disable
1: enable
        :type IsWebsocket: int
        :param _LoadBalance: Load balancing policy for origin-pull
0: round-robin
1: IP hash
2: weighted round-robin
        :type LoadBalance: int
        :param _Mode: Protection mode
0: observation mode
1: interception mode
        :type Mode: int
        :param _PrivateKey: Private key of the self-owned certificate
        :type PrivateKey: str
        :param _SSLId: When CertType is 2, this parameter must be filled, indicating the certificate ID hosted on Tencent Cloud's SSL platform
        :type SSLId: str
        :param _UpstreamDomain: Origin domain when domain is back to source. When UpstreamType=1, this field needs to be filled
        :type UpstreamDomain: str
        :param _UpstreamType: Origin-pull type
0: origin-pull via IP address
1: origin-pull via domain name
        :type UpstreamType: int
        :param _SrcList: Origin IP list when IP is back to source. When UpstreamType=0, this field is required
        :type SrcList: list of str
        :param _Ports:  Domain name port configuration
        :type Ports: list of PortInfo
        :param _CertType: Certificate type
0: no certificate, with only the HTTP listening port configured
1: self-owned certificate
2: managed certificate
        :type CertType: int
        :param _UpstreamScheme: Origin-pull protocol for HTTPS when the service is configured with an HTTPS port
http: Use the HTTP protocol for origin-pull. It is used together with HttpsUpstreamPort.
https: Use the HTTPS protocol for origin-pull.
        :type UpstreamScheme: str
        :param _Cls: Whether to enable access logging
0: disable
1: enable
        :type Cls: int
        :param _Cname: CNAME record for accessing a domain name protected by SaaS WAF
        :type Cname: str
        :param _IsKeepAlive: Whether to enable persistent connection
0: non-persistent connection
1: persistent connection
        :type IsKeepAlive: int
        :param _ActiveCheck: Whether to enable proactive health check
0: disable
1: enable
Note: This field may return null, indicating that no valid values can be obtained.
        :type ActiveCheck: int
        :param _TLSVersion: TLS version information

Note: This field may return null, indicating that no valid values can be obtained.
        :type TLSVersion: int
        :param _Ciphers: Custom encryption suite list. When CipherTemplate is 3, this field is required, indicating the custom encryption suite, value obtained through DescribeCiphersDetail API.

Note: This field may return null, indicating that no valid values can be obtained.
        :type Ciphers: list of int
        :param _CipherTemplate: Cipher suite template
0: default template
1: general template
2: security template
3: custom template
Note: This field may return null, indicating that no valid values can be obtained.
        :type CipherTemplate: int
        :param _ProxyReadTimeout: Read timeout between WAF and origin server, 300s by default.

Note: This field may return null, indicating that no valid values can be obtained.
        :type ProxyReadTimeout: int
        :param _ProxySendTimeout: WAF and origin server write timeout, 300s by default.

Note: This field may return null, indicating that no valid values can be obtained.
        :type ProxySendTimeout: int
        :param _SniType: SNI type during WAF origin-pull
0: Disable SNI and do not configure server_name in client_hello.
1: Enable SNI. server_name in client_hello is a protected domain name.
2: Enable SNI. SNI is the origin server domain name during the domain name origin-pull.
3: Enable SNI. SNI is a custom domain name.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SniType: int
        :param _SniHost: When SniType=3, this parameter is required, indicating a custom SNI;

Note: This field may return null, indicating that no valid values can be obtained.
        :type SniHost: str
        :param _Weights: Weight of the IP address for origin-pull
Note: This field may return null, indicating that no valid values can be obtained.
        :type Weights: list of str
        :param _IpHeaders: IsCdn=3 indicates custom header

Note: This field may return null, indicating that no valid values can be obtained.
        :type IpHeaders: list of str
        :param _XFFReset: Whether to enable XFF reset
0: disable
1: enable
Note: This field may return null, indicating that no valid values can be obtained.
        :type XFFReset: int
        :param _Note: Domain name remarks
Note: This field may return null, indicating that no valid values can be obtained.
        :type Note: str
        :param _UpstreamHost: Custom origin-pull host. The default value is a null string, indicating that a protected domain name is used as the origin-pull host.
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpstreamHost: str
        :param _Level: Protection rule
Note: This field may return null, indicating that no valid values can be obtained.
        :type Level: str
        :param _ProxyBuffer: Whether to enable caching. 0: disable; 1: enable.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ProxyBuffer: int
        """
        self._Domain = None
        self._DomainId = None
        self._InstanceId = None
        self._Edition = None
        self._InstanceName = None
        self._Cert = None
        self._CreateTime = None
        self._Engine = None
        self._HttpsRewrite = None
        self._HttpsUpstreamPort = None
        self._IsCdn = None
        self._IsGray = None
        self._IsHttp2 = None
        self._IsWebsocket = None
        self._LoadBalance = None
        self._Mode = None
        self._PrivateKey = None
        self._SSLId = None
        self._UpstreamDomain = None
        self._UpstreamType = None
        self._SrcList = None
        self._Ports = None
        self._CertType = None
        self._UpstreamScheme = None
        self._Cls = None
        self._Cname = None
        self._IsKeepAlive = None
        self._ActiveCheck = None
        self._TLSVersion = None
        self._Ciphers = None
        self._CipherTemplate = None
        self._ProxyReadTimeout = None
        self._ProxySendTimeout = None
        self._SniType = None
        self._SniHost = None
        self._Weights = None
        self._IpHeaders = None
        self._XFFReset = None
        self._Note = None
        self._UpstreamHost = None
        self._Level = None
        self._ProxyBuffer = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def DomainId(self):
        return self._DomainId

    @DomainId.setter
    def DomainId(self, DomainId):
        self._DomainId = DomainId

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Edition(self):
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def InstanceName(self):
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def Cert(self):
        return self._Cert

    @Cert.setter
    def Cert(self, Cert):
        self._Cert = Cert

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def Engine(self):
        return self._Engine

    @Engine.setter
    def Engine(self, Engine):
        self._Engine = Engine

    @property
    def HttpsRewrite(self):
        return self._HttpsRewrite

    @HttpsRewrite.setter
    def HttpsRewrite(self, HttpsRewrite):
        self._HttpsRewrite = HttpsRewrite

    @property
    def HttpsUpstreamPort(self):
        return self._HttpsUpstreamPort

    @HttpsUpstreamPort.setter
    def HttpsUpstreamPort(self, HttpsUpstreamPort):
        self._HttpsUpstreamPort = HttpsUpstreamPort

    @property
    def IsCdn(self):
        return self._IsCdn

    @IsCdn.setter
    def IsCdn(self, IsCdn):
        self._IsCdn = IsCdn

    @property
    def IsGray(self):
        return self._IsGray

    @IsGray.setter
    def IsGray(self, IsGray):
        self._IsGray = IsGray

    @property
    def IsHttp2(self):
        return self._IsHttp2

    @IsHttp2.setter
    def IsHttp2(self, IsHttp2):
        self._IsHttp2 = IsHttp2

    @property
    def IsWebsocket(self):
        return self._IsWebsocket

    @IsWebsocket.setter
    def IsWebsocket(self, IsWebsocket):
        self._IsWebsocket = IsWebsocket

    @property
    def LoadBalance(self):
        return self._LoadBalance

    @LoadBalance.setter
    def LoadBalance(self, LoadBalance):
        self._LoadBalance = LoadBalance

    @property
    def Mode(self):
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def PrivateKey(self):
        return self._PrivateKey

    @PrivateKey.setter
    def PrivateKey(self, PrivateKey):
        self._PrivateKey = PrivateKey

    @property
    def SSLId(self):
        return self._SSLId

    @SSLId.setter
    def SSLId(self, SSLId):
        self._SSLId = SSLId

    @property
    def UpstreamDomain(self):
        return self._UpstreamDomain

    @UpstreamDomain.setter
    def UpstreamDomain(self, UpstreamDomain):
        self._UpstreamDomain = UpstreamDomain

    @property
    def UpstreamType(self):
        return self._UpstreamType

    @UpstreamType.setter
    def UpstreamType(self, UpstreamType):
        self._UpstreamType = UpstreamType

    @property
    def SrcList(self):
        return self._SrcList

    @SrcList.setter
    def SrcList(self, SrcList):
        self._SrcList = SrcList

    @property
    def Ports(self):
        return self._Ports

    @Ports.setter
    def Ports(self, Ports):
        self._Ports = Ports

    @property
    def CertType(self):
        return self._CertType

    @CertType.setter
    def CertType(self, CertType):
        self._CertType = CertType

    @property
    def UpstreamScheme(self):
        return self._UpstreamScheme

    @UpstreamScheme.setter
    def UpstreamScheme(self, UpstreamScheme):
        self._UpstreamScheme = UpstreamScheme

    @property
    def Cls(self):
        return self._Cls

    @Cls.setter
    def Cls(self, Cls):
        self._Cls = Cls

    @property
    def Cname(self):
        return self._Cname

    @Cname.setter
    def Cname(self, Cname):
        self._Cname = Cname

    @property
    def IsKeepAlive(self):
        return self._IsKeepAlive

    @IsKeepAlive.setter
    def IsKeepAlive(self, IsKeepAlive):
        self._IsKeepAlive = IsKeepAlive

    @property
    def ActiveCheck(self):
        return self._ActiveCheck

    @ActiveCheck.setter
    def ActiveCheck(self, ActiveCheck):
        self._ActiveCheck = ActiveCheck

    @property
    def TLSVersion(self):
        return self._TLSVersion

    @TLSVersion.setter
    def TLSVersion(self, TLSVersion):
        self._TLSVersion = TLSVersion

    @property
    def Ciphers(self):
        return self._Ciphers

    @Ciphers.setter
    def Ciphers(self, Ciphers):
        self._Ciphers = Ciphers

    @property
    def CipherTemplate(self):
        return self._CipherTemplate

    @CipherTemplate.setter
    def CipherTemplate(self, CipherTemplate):
        self._CipherTemplate = CipherTemplate

    @property
    def ProxyReadTimeout(self):
        return self._ProxyReadTimeout

    @ProxyReadTimeout.setter
    def ProxyReadTimeout(self, ProxyReadTimeout):
        self._ProxyReadTimeout = ProxyReadTimeout

    @property
    def ProxySendTimeout(self):
        return self._ProxySendTimeout

    @ProxySendTimeout.setter
    def ProxySendTimeout(self, ProxySendTimeout):
        self._ProxySendTimeout = ProxySendTimeout

    @property
    def SniType(self):
        return self._SniType

    @SniType.setter
    def SniType(self, SniType):
        self._SniType = SniType

    @property
    def SniHost(self):
        return self._SniHost

    @SniHost.setter
    def SniHost(self, SniHost):
        self._SniHost = SniHost

    @property
    def Weights(self):
        return self._Weights

    @Weights.setter
    def Weights(self, Weights):
        self._Weights = Weights

    @property
    def IpHeaders(self):
        return self._IpHeaders

    @IpHeaders.setter
    def IpHeaders(self, IpHeaders):
        self._IpHeaders = IpHeaders

    @property
    def XFFReset(self):
        return self._XFFReset

    @XFFReset.setter
    def XFFReset(self, XFFReset):
        self._XFFReset = XFFReset

    @property
    def Note(self):
        return self._Note

    @Note.setter
    def Note(self, Note):
        self._Note = Note

    @property
    def UpstreamHost(self):
        return self._UpstreamHost

    @UpstreamHost.setter
    def UpstreamHost(self, UpstreamHost):
        self._UpstreamHost = UpstreamHost

    @property
    def Level(self):
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level

    @property
    def ProxyBuffer(self):
        return self._ProxyBuffer

    @ProxyBuffer.setter
    def ProxyBuffer(self, ProxyBuffer):
        self._ProxyBuffer = ProxyBuffer


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._DomainId = params.get("DomainId")
        self._InstanceId = params.get("InstanceId")
        self._Edition = params.get("Edition")
        self._InstanceName = params.get("InstanceName")
        self._Cert = params.get("Cert")
        self._CreateTime = params.get("CreateTime")
        self._Engine = params.get("Engine")
        self._HttpsRewrite = params.get("HttpsRewrite")
        self._HttpsUpstreamPort = params.get("HttpsUpstreamPort")
        self._IsCdn = params.get("IsCdn")
        self._IsGray = params.get("IsGray")
        self._IsHttp2 = params.get("IsHttp2")
        self._IsWebsocket = params.get("IsWebsocket")
        self._LoadBalance = params.get("LoadBalance")
        self._Mode = params.get("Mode")
        self._PrivateKey = params.get("PrivateKey")
        self._SSLId = params.get("SSLId")
        self._UpstreamDomain = params.get("UpstreamDomain")
        self._UpstreamType = params.get("UpstreamType")
        self._SrcList = params.get("SrcList")
        if params.get("Ports") is not None:
            self._Ports = []
            for item in params.get("Ports"):
                obj = PortInfo()
                obj._deserialize(item)
                self._Ports.append(obj)
        self._CertType = params.get("CertType")
        self._UpstreamScheme = params.get("UpstreamScheme")
        self._Cls = params.get("Cls")
        self._Cname = params.get("Cname")
        self._IsKeepAlive = params.get("IsKeepAlive")
        self._ActiveCheck = params.get("ActiveCheck")
        self._TLSVersion = params.get("TLSVersion")
        self._Ciphers = params.get("Ciphers")
        self._CipherTemplate = params.get("CipherTemplate")
        self._ProxyReadTimeout = params.get("ProxyReadTimeout")
        self._ProxySendTimeout = params.get("ProxySendTimeout")
        self._SniType = params.get("SniType")
        self._SniHost = params.get("SniHost")
        self._Weights = params.get("Weights")
        self._IpHeaders = params.get("IpHeaders")
        self._XFFReset = params.get("XFFReset")
        self._Note = params.get("Note")
        self._UpstreamHost = params.get("UpstreamHost")
        self._Level = params.get("Level")
        self._ProxyBuffer = params.get("ProxyBuffer")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FiltersItemNew(AbstractModel):
    """Filter array

    """

    def __init__(self):
        r"""
        :param _Name: Field name, used for filtering
Filter the sub-order number (value) by DealName.
        :type Name: str
        :param _Values: Values after filtering
        :type Values: list of str
        :param _ExactMatch: Exact search or not
        :type ExactMatch: bool
        """
        self._Name = None
        self._Values = None
        self._ExactMatch = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Values(self):
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values

    @property
    def ExactMatch(self):
        return self._ExactMatch

    @ExactMatch.setter
    def ExactMatch(self, ExactMatch):
        self._ExactMatch = ExactMatch


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Values = params.get("Values")
        self._ExactMatch = params.get("ExactMatch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FindAllDomainDetail(AbstractModel):
    """Domain name list

    """

    def __init__(self):
        r"""
        :param _Appid: User ID
        :type Appid: int
        :param _Domain: Domain name
        :type Domain: str
        :param _Ips: Domain IP
        :type Ips: list of str
        :param _FindTime: Detection time
        :type FindTime: str
        :param _InstanceId: Instance ID
        :type InstanceId: str
        :param _DomainId: Domain ID
        :type DomainId: str
        :param _Edition: WAF type
        :type Edition: str
        :param _IsWafDomain: Whether to access WAF
        :type IsWafDomain: int
        """
        self._Appid = None
        self._Domain = None
        self._Ips = None
        self._FindTime = None
        self._InstanceId = None
        self._DomainId = None
        self._Edition = None
        self._IsWafDomain = None

    @property
    def Appid(self):
        return self._Appid

    @Appid.setter
    def Appid(self, Appid):
        self._Appid = Appid

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Ips(self):
        return self._Ips

    @Ips.setter
    def Ips(self, Ips):
        self._Ips = Ips

    @property
    def FindTime(self):
        return self._FindTime

    @FindTime.setter
    def FindTime(self, FindTime):
        self._FindTime = FindTime

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def DomainId(self):
        return self._DomainId

    @DomainId.setter
    def DomainId(self, DomainId):
        self._DomainId = DomainId

    @property
    def Edition(self):
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def IsWafDomain(self):
        return self._IsWafDomain

    @IsWafDomain.setter
    def IsWafDomain(self, IsWafDomain):
        self._IsWafDomain = IsWafDomain


    def _deserialize(self, params):
        self._Appid = params.get("Appid")
        self._Domain = params.get("Domain")
        self._Ips = params.get("Ips")
        self._FindTime = params.get("FindTime")
        self._InstanceId = params.get("InstanceId")
        self._DomainId = params.get("DomainId")
        self._Edition = params.get("Edition")
        self._IsWafDomain = params.get("IsWafDomain")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FraudPkg(AbstractModel):
    """Business security resource information

    """

    def __init__(self):
        r"""
        :param _ResourceIds: Resource ID

Note: This field may return null, indicating that no valid values can be obtained.
        :type ResourceIds: str
        :param _Status: Status

Note: This field may return null, indicating that no valid values can be obtained.
        :type Status: int
        :param _Region: Region

Note: This field may return null, indicating that no valid values can be obtained.
        :type Region: int
        :param _BeginTime: Start time

Note: This field may return null, indicating that no valid values can be obtained.
        :type BeginTime: str
        :param _EndTime: End time

Note: This field may return null, indicating that no valid values can be obtained.
        :type EndTime: str
        :param _InquireNum: Application Quantity

Note: This field may return null, indicating that no valid values can be obtained.
        :type InquireNum: int
        :param _UsedNum: Usage Quantity

Note: This field may return null, indicating that no valid values can be obtained.
        :type UsedNum: int
        :param _RenewFlag: Renewal flag.
Note: This field may return null, indicating that no valid values can be obtained.
        :type RenewFlag: int
        """
        self._ResourceIds = None
        self._Status = None
        self._Region = None
        self._BeginTime = None
        self._EndTime = None
        self._InquireNum = None
        self._UsedNum = None
        self._RenewFlag = None

    @property
    def ResourceIds(self):
        return self._ResourceIds

    @ResourceIds.setter
    def ResourceIds(self, ResourceIds):
        self._ResourceIds = ResourceIds

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def BeginTime(self):
        return self._BeginTime

    @BeginTime.setter
    def BeginTime(self, BeginTime):
        self._BeginTime = BeginTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def InquireNum(self):
        return self._InquireNum

    @InquireNum.setter
    def InquireNum(self, InquireNum):
        self._InquireNum = InquireNum

    @property
    def UsedNum(self):
        return self._UsedNum

    @UsedNum.setter
    def UsedNum(self, UsedNum):
        self._UsedNum = UsedNum

    @property
    def RenewFlag(self):
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag


    def _deserialize(self, params):
        self._ResourceIds = params.get("ResourceIds")
        self._Status = params.get("Status")
        self._Region = params.get("Region")
        self._BeginTime = params.get("BeginTime")
        self._EndTime = params.get("EndTime")
        self._InquireNum = params.get("InquireNum")
        self._UsedNum = params.get("UsedNum")
        self._RenewFlag = params.get("RenewFlag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FreshAntiFakeUrlRequest(AbstractModel):
    """FreshAntiFakeUrl request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _Id: Id
        :type Id: int
        """
        self._Domain = None
        self._Id = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FreshAntiFakeUrlResponse(AbstractModel):
    """FreshAntiFakeUrl response structure.

    """

    def __init__(self):
        r"""
        :param _Result: Whether the result is successful
        :type Result: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class GenerateDealsAndPayNewRequest(AbstractModel):
    """GenerateDealsAndPayNew request structure.

    """

    def __init__(self):
        r"""
        :param _Goods: Billing and ordering input parameters
        :type Goods: list of GoodNews
        """
        self._Goods = None

    @property
    def Goods(self):
        return self._Goods

    @Goods.setter
    def Goods(self, Goods):
        self._Goods = Goods


    def _deserialize(self, params):
        if params.get("Goods") is not None:
            self._Goods = []
            for item in params.get("Goods"):
                obj = GoodNews()
                obj._deserialize(item)
                self._Goods.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GenerateDealsAndPayNewResponse(AbstractModel):
    """GenerateDealsAndPayNew response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Billing order response structure

Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: :class:`tencentcloud.waf.v20180125.models.DealData`
        :param _Status: 1: Success, 0: Failure
        :type Status: int
        :param _ReturnMessage: Returned message

Note: This field may return null, indicating that no valid values can be obtained.
        :type ReturnMessage: str
        :param _InstanceId: Purchased instance ID

Note: This field may return null, indicating that no valid values can be obtained.
        :type InstanceId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._Status = None
        self._ReturnMessage = None
        self._InstanceId = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ReturnMessage(self):
        return self._ReturnMessage

    @ReturnMessage.setter
    def ReturnMessage(self, ReturnMessage):
        self._ReturnMessage = ReturnMessage

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DealData()
            self._Data._deserialize(params.get("Data"))
        self._Status = params.get("Status")
        self._ReturnMessage = params.get("ReturnMessage")
        self._InstanceId = params.get("InstanceId")
        self._RequestId = params.get("RequestId")


class GetAttackTotalCountRequest(AbstractModel):
    """GetAttackTotalCount request structure.

    """

    def __init__(self):
        r"""
        :param _StartTime: Start time
        :type StartTime: str
        :param _EndTime: End time
        :type EndTime: str
        :param _Domain: Domain names queried. Fill in all for all domain names.
        :type Domain: str
        :param _QueryString: Query criteria, "" by default
        :type QueryString: str
        """
        self._StartTime = None
        self._EndTime = None
        self._Domain = None
        self._QueryString = None

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def QueryString(self):
        return self._QueryString

    @QueryString.setter
    def QueryString(self, QueryString):
        self._QueryString = QueryString


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Domain = params.get("Domain")
        self._QueryString = params.get("QueryString")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetAttackTotalCountResponse(AbstractModel):
    """GetAttackTotalCount response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total attack count
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class GetInstanceQpsLimitRequest(AbstractModel):
    """GetInstanceQpsLimit request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Package instance ID
        :type InstanceId: str
        :param _Type: Package type.
        :type Type: str
        """
        self._InstanceId = None
        self._Type = None

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetInstanceQpsLimitResponse(AbstractModel):
    """GetInstanceQpsLimit response structure.

    """

    def __init__(self):
        r"""
        :param _QpsData: Elastic QPS related value set
        :type QpsData: :class:`tencentcloud.waf.v20180125.models.QpsData`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._QpsData = None
        self._RequestId = None

    @property
    def QpsData(self):
        return self._QpsData

    @QpsData.setter
    def QpsData(self, QpsData):
        self._QpsData = QpsData

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("QpsData") is not None:
            self._QpsData = QpsData()
            self._QpsData._deserialize(params.get("QpsData"))
        self._RequestId = params.get("RequestId")


class GoodNews(AbstractModel):
    """Input/Output parameter goods of billing & ordering API

    """

    def __init__(self):
        r"""
        :param _GoodsNum: Number of products
        :type GoodsNum: int
        :param _GoodsDetail: Product Detail
        :type GoodsDetail: :class:`tencentcloud.waf.v20180125.models.GoodsDetailNew`
        :param _GoodsCategoryId: Order type ID, which is used to uniquely identify a business scene. (There are three scenes in total: new purchase, configuration change, and renewal.)
Advanced Edition: 102375 (new purchase), 102376 (renewal), and 102377 (configuration change)
Enterprise Edition: 102378 (new purchase), 102379 (renewal), and 102380 (configuration change)
Ultimate Edition: 102369 (new purchase), 102370 (renewal), and 102371 (configuration change)
Domain name package: 102372 (new purchase), 102373 (renewal), and 102374 (configuration change)
Business expansion package: 101040 (new purchase), 101041 (renewal), and 101042 (configuration change)

Advanced Edition - CLB: 101198 (new purchase), 101199 (renewal), and 101200 (configuration change)
Enterprise Edition - CLB: 101204 (new purchase), 101205 (renewal), and 101206 (configuration change)
Ultimate Edition - CLB: 101201 (new purchase), 101202 (renewal), and 101203 (configuration change)
Domain name package - CLB: 101207 (new purchase), 101208 (renewal), and 101209 (configuration change)
Business expansion package - CLB: 101210 (new purchase), 101211 (renewal), and 101212 (configuration adjustment)

Note: This field may return null, indicating that no valid values can be obtained.
        :type GoodsCategoryId: int
        :param _RegionId: Region ID for purchasing WAF instance

1 indicates purchasing resources in Chinese mainland.
9 indicates purchasing resources outside Chinese mainland.
Note: This field may return null, indicating that no valid values can be obtained.
        :type RegionId: int
        """
        self._GoodsNum = None
        self._GoodsDetail = None
        self._GoodsCategoryId = None
        self._RegionId = None

    @property
    def GoodsNum(self):
        return self._GoodsNum

    @GoodsNum.setter
    def GoodsNum(self, GoodsNum):
        self._GoodsNum = GoodsNum

    @property
    def GoodsDetail(self):
        return self._GoodsDetail

    @GoodsDetail.setter
    def GoodsDetail(self, GoodsDetail):
        self._GoodsDetail = GoodsDetail

    @property
    def GoodsCategoryId(self):
        return self._GoodsCategoryId

    @GoodsCategoryId.setter
    def GoodsCategoryId(self, GoodsCategoryId):
        self._GoodsCategoryId = GoodsCategoryId

    @property
    def RegionId(self):
        return self._RegionId

    @RegionId.setter
    def RegionId(self, RegionId):
        self._RegionId = RegionId


    def _deserialize(self, params):
        self._GoodsNum = params.get("GoodsNum")
        if params.get("GoodsDetail") is not None:
            self._GoodsDetail = GoodsDetailNew()
            self._GoodsDetail._deserialize(params.get("GoodsDetail"))
        self._GoodsCategoryId = params.get("GoodsCategoryId")
        self._RegionId = params.get("RegionId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GoodsDetailNew(AbstractModel):
    """Product details

    """

    def __init__(self):
        r"""
        :param _TimeSpan: Time interval
Note: This field may return null, indicating that no valid values can be obtained.
        :type TimeSpan: int
        :param _TimeUnit: Unit, support for purchasing d, m, y, i.e., (day, month, year)

Note: This field may return null, indicating that no valid values can be obtained.
        :type TimeUnit: str
        :param _SubProductCode: Sub-product tag. It is mandatory for new purchase and renewal. For configuration change, it will be placed in oldConfig and newConfig.

SaaS Advanced Edition: sp_wsm_waf_premium
SaaS Enterprise Edition: sp_wsm_waf_enterprise
SaaS Ultimate Edition: sp_wsm_waf_ultimate
SaaS business expansion package: sp_wsm_waf_qpsep
SaaS domain name expansion package: sp_wsm_waf_domain

Advanced Edition - CLB: sp_wsm_waf_premium_clb
Enterprise Edition - CLB: sp_wsm_waf_enterprise_clb
Ultimate Edition - CLB: sp_wsm_waf_ultimate_clb
 Business expansion package - CLB: sp_wsm_waf_qpsep_clb
Domain name expansion package - CLB: sp_wsm_waf_domain_clb

Note: This field may return null, indicating that no valid values can be obtained.
        :type SubProductCode: str
        :param _Pid: PID applied for a business product (corresponding to a pricing formula). The pricing model can be found through PID billing.
Advanced Edition: 1000827
Enterprise Edition: 1000830
Ultimate Edition: 1000832
Domain name package: 1000834
Business expansion package: 1000481
Advanced Edition - CLB: 1001150
Enterprise Edition - CLB: 1001152
Ultimate Edition - CLB: 1001154
Domain name package - CLB: 1001156
Business expansion package - CLB: 1001160

Note: This field may return null, indicating that no valid values can be obtained.
        :type Pid: int
        :param _InstanceName: WAF Instance Name

Note: This field may return null, indicating that no valid values can be obtained.
        :type InstanceName: str
        :param _AutoRenewFlag: 1: Auto-renewal, 0: No Auto-renewal

Note: This field may return null, indicating that no valid values can be obtained.
        :type AutoRenewFlag: int
        :param _RealRegion: Actual Geographic Information of WAF Purchase

Note: This field may return null, indicating that no valid values can be obtained.
        :type RealRegion: int
        :param _LabelTypes: Billing Detail Tag Array

SaaS Advanced Edition: sv_wsm_waf_package_premium
SaaS Enterprise Edition: sv_wsm_waf_package_enterprise
SaaS Ultimate Edition: sv_wsm_waf_package_ultimate
SaaS non-Chinese Mainland Advanced Edition: sv_wsm_waf_package_premium_intl
SaaS non-Chinese Mainland Enterprise Edition: sv_wsm_waf_package_enterprise_intl
SaaS non-Chinese Mainland Ultimate Edition: sv_wsm_waf_package_ultimate_intl
SaaS business expansion package: sv_wsm_waf_qps_ep
SaaS domain name expansion package: sv_wsm_waf_domain

Advanced Edition CLB: sv_wsm_waf_package_premium_clb
Enterprise Edition CLB: sv_wsm_waf_package_enterprise_clb
Ultimate Edition CLB: sv_wsm_waf_package_ultimate_clb
Non-Chinese Mainland Advanced Edition CLB: sv_wsm_waf_package_premium_clb_intl
Non-Chinese Mainland Enterprise Edition CLB: sv_wsm_waf_package_premium_clb_intl
Non-Chinese Mainland Ultimate Edition CLB: sv_wsm_waf_package_ultimate_clb_intl
Business expansion package CLB: sv_wsm_waf_qps_ep_clb
Domain name expansion package CLB: sv_wsm_waf_domain_clb

Note: This field may return null, indicating that no valid values can be obtained.
        :type LabelTypes: list of str
        :param _LabelCounts: Number of Billing Detail Tags, Generally Corresponds One-to-One with SvLabelType

Note: This field may return null, indicating that no valid values can be obtained.
        :type LabelCounts: list of int
        :param _CurDeadline: Dynamic Configuration Usage, Instance Expiration Time

Note: This field may return null, indicating that no valid values can be obtained.
        :type CurDeadline: str
        :param _InstanceId: Purchasing Bot or API Security for Existing Instances

Note: This field may return null, indicating that no valid values can be obtained.
        :type InstanceId: str
        :param _ResourceId: Resource ID

Note: This field may return null, indicating that no valid values can be obtained.
        :type ResourceId: str
        """
        self._TimeSpan = None
        self._TimeUnit = None
        self._SubProductCode = None
        self._Pid = None
        self._InstanceName = None
        self._AutoRenewFlag = None
        self._RealRegion = None
        self._LabelTypes = None
        self._LabelCounts = None
        self._CurDeadline = None
        self._InstanceId = None
        self._ResourceId = None

    @property
    def TimeSpan(self):
        return self._TimeSpan

    @TimeSpan.setter
    def TimeSpan(self, TimeSpan):
        self._TimeSpan = TimeSpan

    @property
    def TimeUnit(self):
        return self._TimeUnit

    @TimeUnit.setter
    def TimeUnit(self, TimeUnit):
        self._TimeUnit = TimeUnit

    @property
    def SubProductCode(self):
        return self._SubProductCode

    @SubProductCode.setter
    def SubProductCode(self, SubProductCode):
        self._SubProductCode = SubProductCode

    @property
    def Pid(self):
        return self._Pid

    @Pid.setter
    def Pid(self, Pid):
        self._Pid = Pid

    @property
    def InstanceName(self):
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def AutoRenewFlag(self):
        return self._AutoRenewFlag

    @AutoRenewFlag.setter
    def AutoRenewFlag(self, AutoRenewFlag):
        self._AutoRenewFlag = AutoRenewFlag

    @property
    def RealRegion(self):
        return self._RealRegion

    @RealRegion.setter
    def RealRegion(self, RealRegion):
        self._RealRegion = RealRegion

    @property
    def LabelTypes(self):
        return self._LabelTypes

    @LabelTypes.setter
    def LabelTypes(self, LabelTypes):
        self._LabelTypes = LabelTypes

    @property
    def LabelCounts(self):
        return self._LabelCounts

    @LabelCounts.setter
    def LabelCounts(self, LabelCounts):
        self._LabelCounts = LabelCounts

    @property
    def CurDeadline(self):
        return self._CurDeadline

    @CurDeadline.setter
    def CurDeadline(self, CurDeadline):
        self._CurDeadline = CurDeadline

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def ResourceId(self):
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId


    def _deserialize(self, params):
        self._TimeSpan = params.get("TimeSpan")
        self._TimeUnit = params.get("TimeUnit")
        self._SubProductCode = params.get("SubProductCode")
        self._Pid = params.get("Pid")
        self._InstanceName = params.get("InstanceName")
        self._AutoRenewFlag = params.get("AutoRenewFlag")
        self._RealRegion = params.get("RealRegion")
        self._LabelTypes = params.get("LabelTypes")
        self._LabelCounts = params.get("LabelCounts")
        self._CurDeadline = params.get("CurDeadline")
        self._InstanceId = params.get("InstanceId")
        self._ResourceId = params.get("ResourceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class HostDel(AbstractModel):
    """CLB-WAF deleted domain parameters

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _DomainId: Domain ID
        :type DomainId: str
        :param _InstanceID: Instance type
        :type InstanceID: str
        """
        self._Domain = None
        self._DomainId = None
        self._InstanceID = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def DomainId(self):
        return self._DomainId

    @DomainId.setter
    def DomainId(self, DomainId):
        self._DomainId = DomainId

    @property
    def InstanceID(self):
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._DomainId = params.get("DomainId")
        self._InstanceID = params.get("InstanceID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class HostRecord(AbstractModel):
    """Information on domain names protected by CLB WAF

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _DomainId: Unique domain name ID
        :type DomainId: str
        :param _MainDomain: Primary Domain, empty upon input
        :type MainDomain: str
        :param _Mode: Rule engine protection mode
0: observation mode
1: interception mode
        :type Mode: int
        :param _Status: Binding relationship between WAF and CLB
0: unbound
1: bound
        :type Status: int
        :param _State: Domain name listener status of CLB WAF
0: operation successful
4: CLB instance binding in progress
6: CLB instance unbinding in progress
7: CLB instance unbinding failed
8: CLB instance binding failed
10: internal error
        :type State: int
        :param _Engine: Status of the rule engine and AI engine
1: initial status. Interception for the rule engine and disabled for the AI engine.
10: observation for the rule engine and disabled for the AI engine
11: observation for both the rule engine and AI engine
12: observation for the rule engine and interception for the AI engine
20: interception for the rule engine and disabled for the AI engine
21: interception for the rule engine and observation for the AI engine
22: interception for both the rule engine and AI engine
        :type Engine: int
        :param _IsCdn: Whether a layer-7 proxy service is deployed before WAF. 0: No proxy service deployed; 1: Proxy service deployed, and WAF will use XFF to obtain the client IP address; 2: Proxy service deployed, and WAF will use remote_addr to obtain the client IP address; 3: Proxy service deployed, and WAF will use the custom header in ip_headers to obtain the client IP address.
        :type IsCdn: int
        :param _LoadBalancerSet: List of the information on the bound CLB instance
        :type LoadBalancerSet: list of LoadBalancer
        :param _Region: Region of the CLB instance bound to the domain name. Separate multiple regions by commas.
        :type Region: str
        :param _Edition: Instance type of the domain name. For CLB WAF, the value is "clb-waf".
        :type Edition: str
        :param _FlowMode: Traffic mode of domain names protected by CLB WAF
1: cleaning mode
0: mirror mode
        :type FlowMode: int
        :param _ClsStatus: Whether to enable access logging
1: enable
0: disable
        :type ClsStatus: int
        :param _Level: Protection Level, Optional Values: 100, 200, 300

Note: This field may return null, indicating that no valid values can be obtained.
        :type Level: int
        :param _CdcClusters: List of CDC clusters to which the domain name needs to be delivered. Specify this parameter for CDC scenes only.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CdcClusters: list of str
        :param _AlbType: Application CLB type. Default value: clb. 
clb: layer-7 CLB
tsegw: Tencent Cloud API Gateway
scf: Tencent Cloud Serverless
apisix: Other Tencent Cloud Gateway. eg: APISIX gateway
Note: This field may return null, indicating that no valid values can be obtained.
        :type AlbType: str
        :param _IpHeaders: IsCdn=3 required for this parameter, indicates custom header

Note: This field may return null, indicating that no valid values can be obtained.
        :type IpHeaders: list of str
        :param _EngineType: Rule engine type
1: menshen
2: tiga
Note: This field may return null, indicating that no valid values can be obtained.
        :type EngineType: int
        :param _CloudType: Cloud type
public: public cloud
private: private cloud
hybrid: hybrid cloud
Note: This field may return null, indicating that no valid values can be obtained.
        :type CloudType: str
        :param _Note: Domain name remarks
Note: This field may return null, indicating that no valid values can be obtained.
        :type Note: str
        """
        self._Domain = None
        self._DomainId = None
        self._MainDomain = None
        self._Mode = None
        self._Status = None
        self._State = None
        self._Engine = None
        self._IsCdn = None
        self._LoadBalancerSet = None
        self._Region = None
        self._Edition = None
        self._FlowMode = None
        self._ClsStatus = None
        self._Level = None
        self._CdcClusters = None
        self._AlbType = None
        self._IpHeaders = None
        self._EngineType = None
        self._CloudType = None
        self._Note = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def DomainId(self):
        return self._DomainId

    @DomainId.setter
    def DomainId(self, DomainId):
        self._DomainId = DomainId

    @property
    def MainDomain(self):
        return self._MainDomain

    @MainDomain.setter
    def MainDomain(self, MainDomain):
        self._MainDomain = MainDomain

    @property
    def Mode(self):
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def State(self):
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def Engine(self):
        return self._Engine

    @Engine.setter
    def Engine(self, Engine):
        self._Engine = Engine

    @property
    def IsCdn(self):
        return self._IsCdn

    @IsCdn.setter
    def IsCdn(self, IsCdn):
        self._IsCdn = IsCdn

    @property
    def LoadBalancerSet(self):
        return self._LoadBalancerSet

    @LoadBalancerSet.setter
    def LoadBalancerSet(self, LoadBalancerSet):
        self._LoadBalancerSet = LoadBalancerSet

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Edition(self):
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def FlowMode(self):
        return self._FlowMode

    @FlowMode.setter
    def FlowMode(self, FlowMode):
        self._FlowMode = FlowMode

    @property
    def ClsStatus(self):
        return self._ClsStatus

    @ClsStatus.setter
    def ClsStatus(self, ClsStatus):
        self._ClsStatus = ClsStatus

    @property
    def Level(self):
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level

    @property
    def CdcClusters(self):
        return self._CdcClusters

    @CdcClusters.setter
    def CdcClusters(self, CdcClusters):
        self._CdcClusters = CdcClusters

    @property
    def AlbType(self):
        return self._AlbType

    @AlbType.setter
    def AlbType(self, AlbType):
        self._AlbType = AlbType

    @property
    def IpHeaders(self):
        return self._IpHeaders

    @IpHeaders.setter
    def IpHeaders(self, IpHeaders):
        self._IpHeaders = IpHeaders

    @property
    def EngineType(self):
        return self._EngineType

    @EngineType.setter
    def EngineType(self, EngineType):
        self._EngineType = EngineType

    @property
    def CloudType(self):
        return self._CloudType

    @CloudType.setter
    def CloudType(self, CloudType):
        self._CloudType = CloudType

    @property
    def Note(self):
        return self._Note

    @Note.setter
    def Note(self, Note):
        self._Note = Note


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._DomainId = params.get("DomainId")
        self._MainDomain = params.get("MainDomain")
        self._Mode = params.get("Mode")
        self._Status = params.get("Status")
        self._State = params.get("State")
        self._Engine = params.get("Engine")
        self._IsCdn = params.get("IsCdn")
        if params.get("LoadBalancerSet") is not None:
            self._LoadBalancerSet = []
            for item in params.get("LoadBalancerSet"):
                obj = LoadBalancer()
                obj._deserialize(item)
                self._LoadBalancerSet.append(obj)
        self._Region = params.get("Region")
        self._Edition = params.get("Edition")
        self._FlowMode = params.get("FlowMode")
        self._ClsStatus = params.get("ClsStatus")
        self._Level = params.get("Level")
        self._CdcClusters = params.get("CdcClusters")
        self._AlbType = params.get("AlbType")
        self._IpHeaders = params.get("IpHeaders")
        self._EngineType = params.get("EngineType")
        self._CloudType = params.get("CloudType")
        self._Note = params.get("Note")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class HostStatus(AbstractModel):
    """Structure for setting WAF status

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _DomainId: Domain ID
        :type DomainId: str
        :param _Status: WAF switch. 1: On, 0: Off
        :type Status: int
        :param _InstanceID: Instance ID
        :type InstanceID: str
        """
        self._Domain = None
        self._DomainId = None
        self._Status = None
        self._InstanceID = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def DomainId(self):
        return self._DomainId

    @DomainId.setter
    def DomainId(self, DomainId):
        self._DomainId = DomainId

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def InstanceID(self):
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._DomainId = params.get("DomainId")
        self._Status = params.get("Status")
        self._InstanceID = params.get("InstanceID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class HybridPkg(AbstractModel):
    """Hybrid cloud node resource information

    """

    def __init__(self):
        r"""
        :param _ResourceIds: Resource ID

Note: This field may return null, indicating that no valid values can be obtained.
        :type ResourceIds: str
        :param _Status: Status

Note: This field may return null, indicating that no valid values can be obtained.
        :type Status: int
        :param _Region: Region

Note: This field may return null, indicating that no valid values can be obtained.
        :type Region: int
        :param _BeginTime: Start time

Note: This field may return null, indicating that no valid values can be obtained.
        :type BeginTime: str
        :param _EndTime: End time

Note: This field may return null, indicating that no valid values can be obtained.
        :type EndTime: str
        :param _InquireNum: Application Quantity

Note: This field may return null, indicating that no valid values can be obtained.
        :type InquireNum: int
        :param _UsedNum: Usage Quantity

Note: This field may return null, indicating that no valid values can be obtained.
        :type UsedNum: int
        :param _RenewFlag: Renewal flag.
Note: This field may return null, indicating that no valid values can be obtained.
        :type RenewFlag: int
        """
        self._ResourceIds = None
        self._Status = None
        self._Region = None
        self._BeginTime = None
        self._EndTime = None
        self._InquireNum = None
        self._UsedNum = None
        self._RenewFlag = None

    @property
    def ResourceIds(self):
        return self._ResourceIds

    @ResourceIds.setter
    def ResourceIds(self, ResourceIds):
        self._ResourceIds = ResourceIds

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def BeginTime(self):
        return self._BeginTime

    @BeginTime.setter
    def BeginTime(self, BeginTime):
        self._BeginTime = BeginTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def InquireNum(self):
        return self._InquireNum

    @InquireNum.setter
    def InquireNum(self, InquireNum):
        self._InquireNum = InquireNum

    @property
    def UsedNum(self):
        return self._UsedNum

    @UsedNum.setter
    def UsedNum(self, UsedNum):
        self._UsedNum = UsedNum

    @property
    def RenewFlag(self):
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag


    def _deserialize(self, params):
        self._ResourceIds = params.get("ResourceIds")
        self._Status = params.get("Status")
        self._Region = params.get("Region")
        self._BeginTime = params.get("BeginTime")
        self._EndTime = params.get("EndTime")
        self._InquireNum = params.get("InquireNum")
        self._UsedNum = params.get("UsedNum")
        self._RenewFlag = params.get("RenewFlag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ImportIpAccessControlRequest(AbstractModel):
    """ImportIpAccessControl request structure.

    """

    def __init__(self):
        r"""
        :param _Data: List of imported IP allowlists/blocklists.
        :type Data: list of IpAccessControlParam
        :param _Domain: Specific domain name, for example, test.qcloudwaf.com.
Global domain name, that is, global.
        :type Domain: str
        :param _SourceType: Batch protection IP blocklists/allowlists or not. If yes, the value is batch; otherwise, it is empty.
        :type SourceType: str
        :param _InstanceId: Instance ID
        :type InstanceId: str
        """
        self._Data = None
        self._Domain = None
        self._SourceType = None
        self._InstanceId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def SourceType(self):
        return self._SourceType

    @SourceType.setter
    def SourceType(self, SourceType):
        self._SourceType = SourceType

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = IpAccessControlParam()
                obj._deserialize(item)
                self._Data.append(obj)
        self._Domain = params.get("Domain")
        self._SourceType = params.get("SourceType")
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ImportIpAccessControlResponse(AbstractModel):
    """ImportIpAccessControl response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class InstanceInfo(AbstractModel):
    """Detailed information of an instance

    """

    def __init__(self):
        r"""
        :param _InstanceId: Unique Instance ID
        :type InstanceId: str
        :param _InstanceName: Instance name
        :type InstanceName: str
        :param _ResourceIds: Resource ID corresponding to the Instance, for billing usage
        :type ResourceIds: str
        :param _Region: Instance region
        :type Region: str
        :param _PayMode: Payment mode
        :type PayMode: int
        :param _RenewFlag: Auto-renewal flag.

0: disable

1: enable
        :type RenewFlag: int
        :param _Mode: Elastic billing switch.
0: disable

1: enable
        :type Mode: int
        :param _Level: Instance package version.
101: Small and Micro Edition.
102: Ultra-light Edition.
2: Advanced Edition.
3: Enterprise Edition.
4: Ultimate Edition.
6: Exclusive Edition
        :type Level: int
        :param _ValidTime: Instance expiration time
        :type ValidTime: str
        :param _BeginTime: Instance Start Time
        :type BeginTime: str
        :param _DomainCount: Configured Domain Count
        :type DomainCount: int
        :param _SubDomainLimit: Maximum Domain Count
        :type SubDomainLimit: int
        :param _MainDomainCount: Configured Primary Domain Count
        :type MainDomainCount: int
        :param _MainDomainLimit: Maximum Number of Primary Domain Names
        :type MainDomainLimit: int
        :param _MaxQPS: Instance QPS Peak within 30 Days
        :type MaxQPS: int
        :param _QPS: QPS Expansion Package Information
        :type QPS: :class:`tencentcloud.waf.v20180125.models.QPSPackageNew`
        :param _DomainPkg: Domain Extension Package Information
        :type DomainPkg: :class:`tencentcloud.waf.v20180125.models.DomainPackageNew`
        :param _AppId: User appid.
        :type AppId: int
        :param _Edition: CLB or SaaS
        :type Edition: str
        :param _FraudPkg: Business Security Package

Note: This field may return null, indicating that no valid values can be obtained.
        :type FraudPkg: :class:`tencentcloud.waf.v20180125.models.FraudPkg`
        :param _BotPkg: Bot Resource Package

Note: This field may return null, indicating that no valid values can be obtained.
        :type BotPkg: :class:`tencentcloud.waf.v20180125.models.BotPkg`
        :param _BotQPS: Bot's QPS details

Note: This field may return null, indicating that no valid values can be obtained.
        :type BotQPS: :class:`tencentcloud.waf.v20180125.models.BotQPS`
        :param _ElasticBilling: QPS Elastic Billing Cap

Note: This field may return null, indicating that no valid values can be obtained.
        :type ElasticBilling: int
        :param _AttackLogPost: Attack Log Shipping Switch

Note: This field may return null, indicating that no valid values can be obtained.
        :type AttackLogPost: int
        :param _MaxBandwidth: Peak Bandwidth, in B/s (Bytes per Second)

Note: This field may return null, indicating that no valid values can be obtained.
        :type MaxBandwidth: int
        :param _APISecurity: Whether API security is purchased
        :type APISecurity: int
        :param _QpsStandard: Purchased QPS Specification

Note: This field may return null, indicating that no valid values can be obtained.
        :type QpsStandard: int
        :param _BandwidthStandard: Purchased Bandwidth Specification

Note: This field may return null, indicating that no valid values can be obtained.
        :type BandwidthStandard: int
        :param _Status: Instance status

Note: This field may return null, indicating that no valid values can be obtained.
        :type Status: int
        :param _SandboxQps: Instance Sandbox QPS Value

Note: This field may return null, indicating that no valid values can be obtained.
        :type SandboxQps: int
        :param _IsAPISecurityTrial: Whether API Security is on Trial

Note: This field may return null, indicating that no valid values can be obtained.
        :type IsAPISecurityTrial: int
        :param _MajorEventsPkg: Premium Package

Note: This field may return null, indicating that no valid values can be obtained.
        :type MajorEventsPkg: :class:`tencentcloud.waf.v20180125.models.MajorEventsPkg`
        :param _HybridPkg: Hybrid Cloud Sub-node Package

Note: This field may return null, indicating that no valid values can be obtained.
        :type HybridPkg: :class:`tencentcloud.waf.v20180125.models.HybridPkg`
        :param _ApiPkg: API security resource package

Note: This field may return null, indicating that no valid values can be obtained.
        :type ApiPkg: :class:`tencentcloud.waf.v20180125.models.ApiPkg`
        :param _MiniPkg: MMPS Acceleration Package

Note: This field may return null, indicating that no valid values can be obtained.
        :type MiniPkg: :class:`tencentcloud.waf.v20180125.models.MiniPkg`
        :param _MiniQpsStandard: Mini Program QPS Specification

Note: This field may return null, indicating that no valid values can be obtained.
        :type MiniQpsStandard: int
        :param _MiniMaxQPS: Mini Program QPS Peak

Note: This field may return null, indicating that no valid values can be obtained.
        :type MiniMaxQPS: int
        :param _LastQpsExceedTime: Last overage time.
Note: This field may return null, indicating that no valid values can be obtained.
        :type LastQpsExceedTime: str
        :param _MiniExtendPkg: ID quantity expansion package for secure mini program access.

Note: This field may return null, indicating that no valid values can be obtained.
        :type MiniExtendPkg: :class:`tencentcloud.waf.v20180125.models.MiniExtendPkg`
        :param _BillingItem: Billing item.
Note: This field may return null, indicating that no valid values can be obtained.
        :type BillingItem: str
        :param _FreeDelayFlag: Flag for delay of instance deletion.

Note: This field may return null, indicating that no valid values can be obtained.
        :type FreeDelayFlag: int
        """
        self._InstanceId = None
        self._InstanceName = None
        self._ResourceIds = None
        self._Region = None
        self._PayMode = None
        self._RenewFlag = None
        self._Mode = None
        self._Level = None
        self._ValidTime = None
        self._BeginTime = None
        self._DomainCount = None
        self._SubDomainLimit = None
        self._MainDomainCount = None
        self._MainDomainLimit = None
        self._MaxQPS = None
        self._QPS = None
        self._DomainPkg = None
        self._AppId = None
        self._Edition = None
        self._FraudPkg = None
        self._BotPkg = None
        self._BotQPS = None
        self._ElasticBilling = None
        self._AttackLogPost = None
        self._MaxBandwidth = None
        self._APISecurity = None
        self._QpsStandard = None
        self._BandwidthStandard = None
        self._Status = None
        self._SandboxQps = None
        self._IsAPISecurityTrial = None
        self._MajorEventsPkg = None
        self._HybridPkg = None
        self._ApiPkg = None
        self._MiniPkg = None
        self._MiniQpsStandard = None
        self._MiniMaxQPS = None
        self._LastQpsExceedTime = None
        self._MiniExtendPkg = None
        self._BillingItem = None
        self._FreeDelayFlag = None

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def InstanceName(self):
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def ResourceIds(self):
        return self._ResourceIds

    @ResourceIds.setter
    def ResourceIds(self, ResourceIds):
        self._ResourceIds = ResourceIds

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def PayMode(self):
        return self._PayMode

    @PayMode.setter
    def PayMode(self, PayMode):
        self._PayMode = PayMode

    @property
    def RenewFlag(self):
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag

    @property
    def Mode(self):
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def Level(self):
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level

    @property
    def ValidTime(self):
        return self._ValidTime

    @ValidTime.setter
    def ValidTime(self, ValidTime):
        self._ValidTime = ValidTime

    @property
    def BeginTime(self):
        return self._BeginTime

    @BeginTime.setter
    def BeginTime(self, BeginTime):
        self._BeginTime = BeginTime

    @property
    def DomainCount(self):
        return self._DomainCount

    @DomainCount.setter
    def DomainCount(self, DomainCount):
        self._DomainCount = DomainCount

    @property
    def SubDomainLimit(self):
        return self._SubDomainLimit

    @SubDomainLimit.setter
    def SubDomainLimit(self, SubDomainLimit):
        self._SubDomainLimit = SubDomainLimit

    @property
    def MainDomainCount(self):
        return self._MainDomainCount

    @MainDomainCount.setter
    def MainDomainCount(self, MainDomainCount):
        self._MainDomainCount = MainDomainCount

    @property
    def MainDomainLimit(self):
        return self._MainDomainLimit

    @MainDomainLimit.setter
    def MainDomainLimit(self, MainDomainLimit):
        self._MainDomainLimit = MainDomainLimit

    @property
    def MaxQPS(self):
        return self._MaxQPS

    @MaxQPS.setter
    def MaxQPS(self, MaxQPS):
        self._MaxQPS = MaxQPS

    @property
    def QPS(self):
        return self._QPS

    @QPS.setter
    def QPS(self, QPS):
        self._QPS = QPS

    @property
    def DomainPkg(self):
        return self._DomainPkg

    @DomainPkg.setter
    def DomainPkg(self, DomainPkg):
        self._DomainPkg = DomainPkg

    @property
    def AppId(self):
        return self._AppId

    @AppId.setter
    def AppId(self, AppId):
        self._AppId = AppId

    @property
    def Edition(self):
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def FraudPkg(self):
        return self._FraudPkg

    @FraudPkg.setter
    def FraudPkg(self, FraudPkg):
        self._FraudPkg = FraudPkg

    @property
    def BotPkg(self):
        return self._BotPkg

    @BotPkg.setter
    def BotPkg(self, BotPkg):
        self._BotPkg = BotPkg

    @property
    def BotQPS(self):
        return self._BotQPS

    @BotQPS.setter
    def BotQPS(self, BotQPS):
        self._BotQPS = BotQPS

    @property
    def ElasticBilling(self):
        return self._ElasticBilling

    @ElasticBilling.setter
    def ElasticBilling(self, ElasticBilling):
        self._ElasticBilling = ElasticBilling

    @property
    def AttackLogPost(self):
        return self._AttackLogPost

    @AttackLogPost.setter
    def AttackLogPost(self, AttackLogPost):
        self._AttackLogPost = AttackLogPost

    @property
    def MaxBandwidth(self):
        return self._MaxBandwidth

    @MaxBandwidth.setter
    def MaxBandwidth(self, MaxBandwidth):
        self._MaxBandwidth = MaxBandwidth

    @property
    def APISecurity(self):
        return self._APISecurity

    @APISecurity.setter
    def APISecurity(self, APISecurity):
        self._APISecurity = APISecurity

    @property
    def QpsStandard(self):
        return self._QpsStandard

    @QpsStandard.setter
    def QpsStandard(self, QpsStandard):
        self._QpsStandard = QpsStandard

    @property
    def BandwidthStandard(self):
        return self._BandwidthStandard

    @BandwidthStandard.setter
    def BandwidthStandard(self, BandwidthStandard):
        self._BandwidthStandard = BandwidthStandard

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def SandboxQps(self):
        return self._SandboxQps

    @SandboxQps.setter
    def SandboxQps(self, SandboxQps):
        self._SandboxQps = SandboxQps

    @property
    def IsAPISecurityTrial(self):
        return self._IsAPISecurityTrial

    @IsAPISecurityTrial.setter
    def IsAPISecurityTrial(self, IsAPISecurityTrial):
        self._IsAPISecurityTrial = IsAPISecurityTrial

    @property
    def MajorEventsPkg(self):
        return self._MajorEventsPkg

    @MajorEventsPkg.setter
    def MajorEventsPkg(self, MajorEventsPkg):
        self._MajorEventsPkg = MajorEventsPkg

    @property
    def HybridPkg(self):
        return self._HybridPkg

    @HybridPkg.setter
    def HybridPkg(self, HybridPkg):
        self._HybridPkg = HybridPkg

    @property
    def ApiPkg(self):
        return self._ApiPkg

    @ApiPkg.setter
    def ApiPkg(self, ApiPkg):
        self._ApiPkg = ApiPkg

    @property
    def MiniPkg(self):
        return self._MiniPkg

    @MiniPkg.setter
    def MiniPkg(self, MiniPkg):
        self._MiniPkg = MiniPkg

    @property
    def MiniQpsStandard(self):
        return self._MiniQpsStandard

    @MiniQpsStandard.setter
    def MiniQpsStandard(self, MiniQpsStandard):
        self._MiniQpsStandard = MiniQpsStandard

    @property
    def MiniMaxQPS(self):
        return self._MiniMaxQPS

    @MiniMaxQPS.setter
    def MiniMaxQPS(self, MiniMaxQPS):
        self._MiniMaxQPS = MiniMaxQPS

    @property
    def LastQpsExceedTime(self):
        return self._LastQpsExceedTime

    @LastQpsExceedTime.setter
    def LastQpsExceedTime(self, LastQpsExceedTime):
        self._LastQpsExceedTime = LastQpsExceedTime

    @property
    def MiniExtendPkg(self):
        return self._MiniExtendPkg

    @MiniExtendPkg.setter
    def MiniExtendPkg(self, MiniExtendPkg):
        self._MiniExtendPkg = MiniExtendPkg

    @property
    def BillingItem(self):
        return self._BillingItem

    @BillingItem.setter
    def BillingItem(self, BillingItem):
        self._BillingItem = BillingItem

    @property
    def FreeDelayFlag(self):
        return self._FreeDelayFlag

    @FreeDelayFlag.setter
    def FreeDelayFlag(self, FreeDelayFlag):
        self._FreeDelayFlag = FreeDelayFlag


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._InstanceName = params.get("InstanceName")
        self._ResourceIds = params.get("ResourceIds")
        self._Region = params.get("Region")
        self._PayMode = params.get("PayMode")
        self._RenewFlag = params.get("RenewFlag")
        self._Mode = params.get("Mode")
        self._Level = params.get("Level")
        self._ValidTime = params.get("ValidTime")
        self._BeginTime = params.get("BeginTime")
        self._DomainCount = params.get("DomainCount")
        self._SubDomainLimit = params.get("SubDomainLimit")
        self._MainDomainCount = params.get("MainDomainCount")
        self._MainDomainLimit = params.get("MainDomainLimit")
        self._MaxQPS = params.get("MaxQPS")
        if params.get("QPS") is not None:
            self._QPS = QPSPackageNew()
            self._QPS._deserialize(params.get("QPS"))
        if params.get("DomainPkg") is not None:
            self._DomainPkg = DomainPackageNew()
            self._DomainPkg._deserialize(params.get("DomainPkg"))
        self._AppId = params.get("AppId")
        self._Edition = params.get("Edition")
        if params.get("FraudPkg") is not None:
            self._FraudPkg = FraudPkg()
            self._FraudPkg._deserialize(params.get("FraudPkg"))
        if params.get("BotPkg") is not None:
            self._BotPkg = BotPkg()
            self._BotPkg._deserialize(params.get("BotPkg"))
        if params.get("BotQPS") is not None:
            self._BotQPS = BotQPS()
            self._BotQPS._deserialize(params.get("BotQPS"))
        self._ElasticBilling = params.get("ElasticBilling")
        self._AttackLogPost = params.get("AttackLogPost")
        self._MaxBandwidth = params.get("MaxBandwidth")
        self._APISecurity = params.get("APISecurity")
        self._QpsStandard = params.get("QpsStandard")
        self._BandwidthStandard = params.get("BandwidthStandard")
        self._Status = params.get("Status")
        self._SandboxQps = params.get("SandboxQps")
        self._IsAPISecurityTrial = params.get("IsAPISecurityTrial")
        if params.get("MajorEventsPkg") is not None:
            self._MajorEventsPkg = MajorEventsPkg()
            self._MajorEventsPkg._deserialize(params.get("MajorEventsPkg"))
        if params.get("HybridPkg") is not None:
            self._HybridPkg = HybridPkg()
            self._HybridPkg._deserialize(params.get("HybridPkg"))
        if params.get("ApiPkg") is not None:
            self._ApiPkg = ApiPkg()
            self._ApiPkg._deserialize(params.get("ApiPkg"))
        if params.get("MiniPkg") is not None:
            self._MiniPkg = MiniPkg()
            self._MiniPkg._deserialize(params.get("MiniPkg"))
        self._MiniQpsStandard = params.get("MiniQpsStandard")
        self._MiniMaxQPS = params.get("MiniMaxQPS")
        self._LastQpsExceedTime = params.get("LastQpsExceedTime")
        if params.get("MiniExtendPkg") is not None:
            self._MiniExtendPkg = MiniExtendPkg()
            self._MiniExtendPkg._deserialize(params.get("MiniExtendPkg"))
        self._BillingItem = params.get("BillingItem")
        self._FreeDelayFlag = params.get("FreeDelayFlag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class IpAccessControlData(AbstractModel):
    """Data Encapsulation

    """

    def __init__(self):
        r"""
        :param _Res: IP Blocklist/Allowlist

Note: This field may return null, indicating that no valid values can be obtained.
        :type Res: list of IpAccessControlItem
        :param _TotalCount: Counting.
        :type TotalCount: int
        """
        self._Res = None
        self._TotalCount = None

    @property
    def Res(self):
        return self._Res

    @Res.setter
    def Res(self, Res):
        self._Res = Res

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount


    def _deserialize(self, params):
        if params.get("Res") is not None:
            self._Res = []
            for item in params.get("Res"):
                obj = IpAccessControlItem()
                obj._deserialize(item)
                self._Res.append(obj)
        self._TotalCount = params.get("TotalCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class IpAccessControlItem(AbstractModel):
    """IP Blocklist/Allowlist

    """

    def __init__(self):
        r"""
        :param _Id: MongoDB Table Auto-increment ID

Note: This field may return null, indicating that no valid values can be obtained.
        :type Id: str
        :param _ActionType: Action
        :type ActionType: int
        :param _Ip: ip
        :type Ip: str
        :param _Note: Remarks
        :type Note: str
        :param _Source: Source.
        :type Source: str
        :param _TsVersion: Update Timestamp

Note: This field may return null, indicating that no valid values can be obtained.
        :type TsVersion: int
        :param _ValidTs: Expiration Timestamp
        :type ValidTs: int
        :param _ValidStatus: Effective status.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ValidStatus: int
        :param _RuleId: 55000001
Note: This field may return null, indicating that no valid values can be obtained.
        :type RuleId: int
        :param _IpList: IP list.
Note: This field may return null, indicating that no valid values can be obtained.
        :type IpList: list of str
        :param _CreateTime: Rule creation time

Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: int
        :param _JobType: Scheduled task type

Note: This field may return null, indicating that no valid values can be obtained.
        :type JobType: str
        :param _CronType: Periodic task type.

Note: This field may return null, indicating that no valid values can be obtained.
        :type CronType: str
        :param _JobDateTime: Details of scheduled task configuration.

Note: This field may return null, indicating that no valid values can be obtained.
        :type JobDateTime: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        """
        self._Id = None
        self._ActionType = None
        self._Ip = None
        self._Note = None
        self._Source = None
        self._TsVersion = None
        self._ValidTs = None
        self._ValidStatus = None
        self._RuleId = None
        self._IpList = None
        self._CreateTime = None
        self._JobType = None
        self._CronType = None
        self._JobDateTime = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def ActionType(self):
        return self._ActionType

    @ActionType.setter
    def ActionType(self, ActionType):
        self._ActionType = ActionType

    @property
    def Ip(self):
        return self._Ip

    @Ip.setter
    def Ip(self, Ip):
        self._Ip = Ip

    @property
    def Note(self):
        return self._Note

    @Note.setter
    def Note(self, Note):
        self._Note = Note

    @property
    def Source(self):
        return self._Source

    @Source.setter
    def Source(self, Source):
        self._Source = Source

    @property
    def TsVersion(self):
        return self._TsVersion

    @TsVersion.setter
    def TsVersion(self, TsVersion):
        self._TsVersion = TsVersion

    @property
    def ValidTs(self):
        return self._ValidTs

    @ValidTs.setter
    def ValidTs(self, ValidTs):
        self._ValidTs = ValidTs

    @property
    def ValidStatus(self):
        return self._ValidStatus

    @ValidStatus.setter
    def ValidStatus(self, ValidStatus):
        self._ValidStatus = ValidStatus

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def IpList(self):
        return self._IpList

    @IpList.setter
    def IpList(self, IpList):
        self._IpList = IpList

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def JobType(self):
        return self._JobType

    @JobType.setter
    def JobType(self, JobType):
        self._JobType = JobType

    @property
    def CronType(self):
        return self._CronType

    @CronType.setter
    def CronType(self, CronType):
        self._CronType = CronType

    @property
    def JobDateTime(self):
        return self._JobDateTime

    @JobDateTime.setter
    def JobDateTime(self, JobDateTime):
        self._JobDateTime = JobDateTime


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._ActionType = params.get("ActionType")
        self._Ip = params.get("Ip")
        self._Note = params.get("Note")
        self._Source = params.get("Source")
        self._TsVersion = params.get("TsVersion")
        self._ValidTs = params.get("ValidTs")
        self._ValidStatus = params.get("ValidStatus")
        self._RuleId = params.get("RuleId")
        self._IpList = params.get("IpList")
        self._CreateTime = params.get("CreateTime")
        self._JobType = params.get("JobType")
        self._CronType = params.get("CronType")
        if params.get("JobDateTime") is not None:
            self._JobDateTime = JobDateTime()
            self._JobDateTime._deserialize(params.get("JobDateTime"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class IpAccessControlParam(AbstractModel):
    """IP blocklist/allowlist parameters structure, which is mainly used for IP blocklist/allowlist import.

    """

    def __init__(self):
        r"""
        :param _IpList: IP list.
        :type IpList: list of str
        :param _ValidTs: valid_ts indicates a valid date. Its value is a second-level timestamp, such as 1680570420, which indicates 2023-04-04 09:07:00.
        :type ValidTs: int
        :param _ActionType: 42: blocklist; 40: allowlist.
        :type ActionType: int
        :param _Note: Remarks
        :type Note: str
        """
        self._IpList = None
        self._ValidTs = None
        self._ActionType = None
        self._Note = None

    @property
    def IpList(self):
        return self._IpList

    @IpList.setter
    def IpList(self, IpList):
        self._IpList = IpList

    @property
    def ValidTs(self):
        return self._ValidTs

    @ValidTs.setter
    def ValidTs(self, ValidTs):
        self._ValidTs = ValidTs

    @property
    def ActionType(self):
        return self._ActionType

    @ActionType.setter
    def ActionType(self, ActionType):
        self._ActionType = ActionType

    @property
    def Note(self):
        return self._Note

    @Note.setter
    def Note(self, Note):
        self._Note = Note


    def _deserialize(self, params):
        self._IpList = params.get("IpList")
        self._ValidTs = params.get("ValidTs")
        self._ActionType = params.get("ActionType")
        self._Note = params.get("Note")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class JobDateTime(AbstractModel):
    """Rule execution time structure

    """

    def __init__(self):
        r"""
        :param _Timed: Time parameters for scheduled execution
Note: This field may return null, indicating that no valid values can be obtained.
        :type Timed: list of TimedJob
        :param _Cron: Time parameters for periodic execution
Note: This field may return null, indicating that no valid values can be obtained.
        :type Cron: list of CronJob
        :param _TimeTZone: Time zone
Note: This field may return null, indicating that no valid values can be obtained.
        :type TimeTZone: str
        """
        self._Timed = None
        self._Cron = None
        self._TimeTZone = None

    @property
    def Timed(self):
        return self._Timed

    @Timed.setter
    def Timed(self, Timed):
        self._Timed = Timed

    @property
    def Cron(self):
        return self._Cron

    @Cron.setter
    def Cron(self, Cron):
        self._Cron = Cron

    @property
    def TimeTZone(self):
        return self._TimeTZone

    @TimeTZone.setter
    def TimeTZone(self, TimeTZone):
        self._TimeTZone = TimeTZone


    def _deserialize(self, params):
        if params.get("Timed") is not None:
            self._Timed = []
            for item in params.get("Timed"):
                obj = TimedJob()
                obj._deserialize(item)
                self._Timed.append(obj)
        if params.get("Cron") is not None:
            self._Cron = []
            for item in params.get("Cron"):
                obj = CronJob()
                obj._deserialize(item)
                self._Cron.append(obj)
        self._TimeTZone = params.get("TimeTZone")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class KVInt(AbstractModel):
    """In the form of Key-Value, where Value is an Int

    """

    def __init__(self):
        r"""
        :param _Key: Key
        :type Key: str
        :param _Value: Value
        :type Value: int
        """
        self._Key = None
        self._Value = None

    @property
    def Key(self):
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key

    @property
    def Value(self):
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value


    def _deserialize(self, params):
        self._Key = params.get("Key")
        self._Value = params.get("Value")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LoadBalancer(AbstractModel):
    """CLB listener

    """

    def __init__(self):
        r"""
        :param _LoadBalancerId: CLB LD's ID
        :type LoadBalancerId: str
        :param _LoadBalancerName: CLB LD's Name
        :type LoadBalancerName: str
        :param _ListenerId: CLB Listener ID
        :type ListenerId: str
        :param _ListenerName: Name of CLB Listener
        :type ListenerName: str
        :param _Vip: IP of CLB Instance
        :type Vip: str
        :param _Vport: Port of the CLB Instance
        :type Vport: int
        :param _Region: CLB LD's Region
        :type Region: str
        :param _Protocol: Listener Protocol, HTTP, HTTPS
        :type Protocol: str
        :param _Zone: Zone of the CLB Listener
        :type Zone: str
        :param _NumericalVpcId: CLB's VPC ID, -1 for public network, fill in the actual number for private network

Note: This field may return null, indicating that no valid values can be obtained.
        :type NumericalVpcId: int
        :param _LoadBalancerType: CLB Network Type

Note: This field may return null, indicating that no valid values can be obtained.
        :type LoadBalancerType: str
        :param _LoadBalancerDomain: CLB Domain Name

Note: This field may return null, indicating that no valid values can be obtained.
        :type LoadBalancerDomain: str
        """
        self._LoadBalancerId = None
        self._LoadBalancerName = None
        self._ListenerId = None
        self._ListenerName = None
        self._Vip = None
        self._Vport = None
        self._Region = None
        self._Protocol = None
        self._Zone = None
        self._NumericalVpcId = None
        self._LoadBalancerType = None
        self._LoadBalancerDomain = None

    @property
    def LoadBalancerId(self):
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def LoadBalancerName(self):
        return self._LoadBalancerName

    @LoadBalancerName.setter
    def LoadBalancerName(self, LoadBalancerName):
        self._LoadBalancerName = LoadBalancerName

    @property
    def ListenerId(self):
        return self._ListenerId

    @ListenerId.setter
    def ListenerId(self, ListenerId):
        self._ListenerId = ListenerId

    @property
    def ListenerName(self):
        return self._ListenerName

    @ListenerName.setter
    def ListenerName(self, ListenerName):
        self._ListenerName = ListenerName

    @property
    def Vip(self):
        return self._Vip

    @Vip.setter
    def Vip(self, Vip):
        self._Vip = Vip

    @property
    def Vport(self):
        return self._Vport

    @Vport.setter
    def Vport(self, Vport):
        self._Vport = Vport

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Protocol(self):
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def Zone(self):
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def NumericalVpcId(self):
        return self._NumericalVpcId

    @NumericalVpcId.setter
    def NumericalVpcId(self, NumericalVpcId):
        self._NumericalVpcId = NumericalVpcId

    @property
    def LoadBalancerType(self):
        return self._LoadBalancerType

    @LoadBalancerType.setter
    def LoadBalancerType(self, LoadBalancerType):
        self._LoadBalancerType = LoadBalancerType

    @property
    def LoadBalancerDomain(self):
        return self._LoadBalancerDomain

    @LoadBalancerDomain.setter
    def LoadBalancerDomain(self, LoadBalancerDomain):
        self._LoadBalancerDomain = LoadBalancerDomain


    def _deserialize(self, params):
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._LoadBalancerName = params.get("LoadBalancerName")
        self._ListenerId = params.get("ListenerId")
        self._ListenerName = params.get("ListenerName")
        self._Vip = params.get("Vip")
        self._Vport = params.get("Vport")
        self._Region = params.get("Region")
        self._Protocol = params.get("Protocol")
        self._Zone = params.get("Zone")
        self._NumericalVpcId = params.get("NumericalVpcId")
        self._LoadBalancerType = params.get("LoadBalancerType")
        self._LoadBalancerDomain = params.get("LoadBalancerDomain")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LoadBalancerPackageNew(AbstractModel):
    """CLB

    """

    def __init__(self):
        r"""
        :param _ListenerId: Listener ID

Note: This field may return null, indicating that no valid values can be obtained.
        :type ListenerId: str
        :param _ListenerName: Listening Name

Note: This field may return null, indicating that no valid values can be obtained.
        :type ListenerName: str
        :param _LoadBalancerId: CLB instance ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type LoadBalancerId: str
        :param _LoadBalancerName: CLB name

Note: This field may return null, indicating that no valid values can be obtained.
        :type LoadBalancerName: str
        :param _Protocol: Protocol

Note: This field may return null, indicating that no valid values can be obtained.
        :type Protocol: str
        :param _Region: Region
"Toronto": "ca",
"Guangzhou": "gz",
"Chengdu": "cd",
"Fuzhou": "fzec",
"Shenzhen": "szx",
"India": "in",
"Jinan": "jnec",
"Chongqing": "cq",
"Tianjin": "tsn",
"Northeast Europe": "ru",
"Nanjing": "nj",
"Silicon Valley (U.S.)": "usw",
"Thailand": "th",
"Guangzhou Open": "gzopen",
"Shenzhen Finance": "szjr",
"Frankfurt": "de",
"Japan": "jp",
"Virginia": "use",
"Beijing": "bj",
"Hong Kong (China)": "hk",
"Hangzhou": "hzec",
"Beijing Finance": "bjjr",
"Shanghai Finance": "shjr",
"Taipei (China)": "tpe",
"Seoul": "kr",
"Shanghai": "sh",
"Singapore": "sg",
"Qingyuan": "qy"
Note: This field may return null, indicating that no valid values can be obtained.
        :type Region: str
        :param _Vip: Access IP

Note: This field may return null, indicating that no valid values can be obtained.
        :type Vip: str
        :param _Vport: Access Port

Note: This field may return null, indicating that no valid values can be obtained.
        :type Vport: int
        :param _Zone: Region

Note: This field may return null, indicating that no valid values can be obtained.
        :type Zone: str
        :param _NumericalVpcId: VPCID
Note: This field may return null, indicating that no valid values can be obtained.
        :type NumericalVpcId: int
        :param _LoadBalancerType: CLB Type

Note: This field may return null, indicating that no valid values can be obtained.
        :type LoadBalancerType: str
        :param _LoadBalancerDomain: Domain Name of CLB

Note: This field may return null, indicating that no valid values can be obtained.
        :type LoadBalancerDomain: str
        """
        self._ListenerId = None
        self._ListenerName = None
        self._LoadBalancerId = None
        self._LoadBalancerName = None
        self._Protocol = None
        self._Region = None
        self._Vip = None
        self._Vport = None
        self._Zone = None
        self._NumericalVpcId = None
        self._LoadBalancerType = None
        self._LoadBalancerDomain = None

    @property
    def ListenerId(self):
        return self._ListenerId

    @ListenerId.setter
    def ListenerId(self, ListenerId):
        self._ListenerId = ListenerId

    @property
    def ListenerName(self):
        return self._ListenerName

    @ListenerName.setter
    def ListenerName(self, ListenerName):
        self._ListenerName = ListenerName

    @property
    def LoadBalancerId(self):
        return self._LoadBalancerId

    @LoadBalancerId.setter
    def LoadBalancerId(self, LoadBalancerId):
        self._LoadBalancerId = LoadBalancerId

    @property
    def LoadBalancerName(self):
        return self._LoadBalancerName

    @LoadBalancerName.setter
    def LoadBalancerName(self, LoadBalancerName):
        self._LoadBalancerName = LoadBalancerName

    @property
    def Protocol(self):
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Vip(self):
        return self._Vip

    @Vip.setter
    def Vip(self, Vip):
        self._Vip = Vip

    @property
    def Vport(self):
        return self._Vport

    @Vport.setter
    def Vport(self, Vport):
        self._Vport = Vport

    @property
    def Zone(self):
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def NumericalVpcId(self):
        return self._NumericalVpcId

    @NumericalVpcId.setter
    def NumericalVpcId(self, NumericalVpcId):
        self._NumericalVpcId = NumericalVpcId

    @property
    def LoadBalancerType(self):
        return self._LoadBalancerType

    @LoadBalancerType.setter
    def LoadBalancerType(self, LoadBalancerType):
        self._LoadBalancerType = LoadBalancerType

    @property
    def LoadBalancerDomain(self):
        return self._LoadBalancerDomain

    @LoadBalancerDomain.setter
    def LoadBalancerDomain(self, LoadBalancerDomain):
        self._LoadBalancerDomain = LoadBalancerDomain


    def _deserialize(self, params):
        self._ListenerId = params.get("ListenerId")
        self._ListenerName = params.get("ListenerName")
        self._LoadBalancerId = params.get("LoadBalancerId")
        self._LoadBalancerName = params.get("LoadBalancerName")
        self._Protocol = params.get("Protocol")
        self._Region = params.get("Region")
        self._Vip = params.get("Vip")
        self._Vport = params.get("Vport")
        self._Zone = params.get("Zone")
        self._NumericalVpcId = params.get("NumericalVpcId")
        self._LoadBalancerType = params.get("LoadBalancerType")
        self._LoadBalancerDomain = params.get("LoadBalancerDomain")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MajorEventsPkg(AbstractModel):
    """Key protection resource information

    """

    def __init__(self):
        r"""
        :param _ResourceIds: Resource ID

Note: This field may return null, indicating that no valid values can be obtained.
        :type ResourceIds: str
        :param _Status: Status

Note: This field may return null, indicating that no valid values can be obtained.
        :type Status: int
        :param _Region: Region

Note: This field may return null, indicating that no valid values can be obtained.
        :type Region: int
        :param _BeginTime: Start time

Note: This field may return null, indicating that no valid values can be obtained.
        :type BeginTime: str
        :param _EndTime: End time

Note: This field may return null, indicating that no valid values can be obtained.
        :type EndTime: str
        :param _InquireNum: Application Quantity

Note: This field may return null, indicating that no valid values can be obtained.
        :type InquireNum: int
        :param _UsedNum: Usage Quantity

Note: This field may return null, indicating that no valid values can be obtained.
        :type UsedNum: int
        :param _RenewFlag: Renewal flag.
Note: This field may return null, indicating that no valid values can be obtained.
        :type RenewFlag: int
        :param _BillingItem: Billing item.
Note: This field may return null, indicating that no valid values can be obtained.
        :type BillingItem: str
        :param _HWState: Protection Package Status

Note: This field may return null, indicating that no valid values can be obtained.
        :type HWState: int
        """
        self._ResourceIds = None
        self._Status = None
        self._Region = None
        self._BeginTime = None
        self._EndTime = None
        self._InquireNum = None
        self._UsedNum = None
        self._RenewFlag = None
        self._BillingItem = None
        self._HWState = None

    @property
    def ResourceIds(self):
        return self._ResourceIds

    @ResourceIds.setter
    def ResourceIds(self, ResourceIds):
        self._ResourceIds = ResourceIds

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def BeginTime(self):
        return self._BeginTime

    @BeginTime.setter
    def BeginTime(self, BeginTime):
        self._BeginTime = BeginTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def InquireNum(self):
        return self._InquireNum

    @InquireNum.setter
    def InquireNum(self, InquireNum):
        self._InquireNum = InquireNum

    @property
    def UsedNum(self):
        return self._UsedNum

    @UsedNum.setter
    def UsedNum(self, UsedNum):
        self._UsedNum = UsedNum

    @property
    def RenewFlag(self):
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag

    @property
    def BillingItem(self):
        return self._BillingItem

    @BillingItem.setter
    def BillingItem(self, BillingItem):
        self._BillingItem = BillingItem

    @property
    def HWState(self):
        return self._HWState

    @HWState.setter
    def HWState(self, HWState):
        self._HWState = HWState


    def _deserialize(self, params):
        self._ResourceIds = params.get("ResourceIds")
        self._Status = params.get("Status")
        self._Region = params.get("Region")
        self._BeginTime = params.get("BeginTime")
        self._EndTime = params.get("EndTime")
        self._InquireNum = params.get("InquireNum")
        self._UsedNum = params.get("UsedNum")
        self._RenewFlag = params.get("RenewFlag")
        self._BillingItem = params.get("BillingItem")
        self._HWState = params.get("HWState")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MiniExtendPkg(AbstractModel):
    """Mobile Mini Programs Security access ID extension resource information.

    """

    def __init__(self):
        r"""
        :param _ResourceIds: Resource ID

Note: This field may return null, indicating that no valid values can be obtained.
        :type ResourceIds: str
        :param _Status: Status

Note: This field may return null, indicating that no valid values can be obtained.
        :type Status: int
        :param _Region: Region

Note: This field may return null, indicating that no valid values can be obtained.
        :type Region: int
        :param _BeginTime: Start time

Note: This field may return null, indicating that no valid values can be obtained.
        :type BeginTime: str
        :param _EndTime: End time

Note: This field may return null, indicating that no valid values can be obtained.
        :type EndTime: str
        :param _Count: Purchase quantity.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Count: int
        :param _RenewFlag: Renewal flag.
Note: This field may return null, indicating that no valid values can be obtained.
        :type RenewFlag: int
        :param _BillingItem: Billing item.
Note: This field may return null, indicating that no valid values can be obtained.
        :type BillingItem: str
        """
        self._ResourceIds = None
        self._Status = None
        self._Region = None
        self._BeginTime = None
        self._EndTime = None
        self._Count = None
        self._RenewFlag = None
        self._BillingItem = None

    @property
    def ResourceIds(self):
        return self._ResourceIds

    @ResourceIds.setter
    def ResourceIds(self, ResourceIds):
        self._ResourceIds = ResourceIds

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def BeginTime(self):
        return self._BeginTime

    @BeginTime.setter
    def BeginTime(self, BeginTime):
        self._BeginTime = BeginTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Count(self):
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def RenewFlag(self):
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag

    @property
    def BillingItem(self):
        return self._BillingItem

    @BillingItem.setter
    def BillingItem(self, BillingItem):
        self._BillingItem = BillingItem


    def _deserialize(self, params):
        self._ResourceIds = params.get("ResourceIds")
        self._Status = params.get("Status")
        self._Region = params.get("Region")
        self._BeginTime = params.get("BeginTime")
        self._EndTime = params.get("EndTime")
        self._Count = params.get("Count")
        self._RenewFlag = params.get("RenewFlag")
        self._BillingItem = params.get("BillingItem")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MiniPkg(AbstractModel):
    """API security resource information

    """

    def __init__(self):
        r"""
        :param _ResourceIds: Resource ID

Note: This field may return null, indicating that no valid values can be obtained.
        :type ResourceIds: str
        :param _Status: Status

Note: This field may return null, indicating that no valid values can be obtained.
        :type Status: int
        :param _Region: Region

Note: This field may return null, indicating that no valid values can be obtained.
        :type Region: int
        :param _BeginTime: Start time

Note: This field may return null, indicating that no valid values can be obtained.
        :type BeginTime: str
        :param _EndTime: End time

Note: This field may return null, indicating that no valid values can be obtained.
        :type EndTime: str
        :param _Count: Purchase quantity.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Count: int
        :param _RenewFlag: Renewal flag.
Note: This field may return null, indicating that no valid values can be obtained.
        :type RenewFlag: int
        :param _BillingItem: Billing item.
Note: This field may return null, indicating that no valid values can be obtained.
        :type BillingItem: str
        """
        self._ResourceIds = None
        self._Status = None
        self._Region = None
        self._BeginTime = None
        self._EndTime = None
        self._Count = None
        self._RenewFlag = None
        self._BillingItem = None

    @property
    def ResourceIds(self):
        return self._ResourceIds

    @ResourceIds.setter
    def ResourceIds(self, ResourceIds):
        self._ResourceIds = ResourceIds

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def BeginTime(self):
        return self._BeginTime

    @BeginTime.setter
    def BeginTime(self, BeginTime):
        self._BeginTime = BeginTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Count(self):
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def RenewFlag(self):
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag

    @property
    def BillingItem(self):
        return self._BillingItem

    @BillingItem.setter
    def BillingItem(self, BillingItem):
        self._BillingItem = BillingItem


    def _deserialize(self, params):
        self._ResourceIds = params.get("ResourceIds")
        self._Status = params.get("Status")
        self._Region = params.get("Region")
        self._BeginTime = params.get("BeginTime")
        self._EndTime = params.get("EndTime")
        self._Count = params.get("Count")
        self._RenewFlag = params.get("RenewFlag")
        self._BillingItem = params.get("BillingItem")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAntiFakeUrlRequest(AbstractModel):
    """ModifyAntiFakeUrl request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _Name: Name
        :type Name: str
        :param _Uri: uri
        :type Uri: str
        :param _Id: ID
        :type Id: int
        """
        self._Domain = None
        self._Name = None
        self._Uri = None
        self._Id = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Uri(self):
        return self._Uri

    @Uri.setter
    def Uri(self, Uri):
        self._Uri = Uri

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Name = params.get("Name")
        self._Uri = params.get("Uri")
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAntiFakeUrlResponse(AbstractModel):
    """ModifyAntiFakeUrl response structure.

    """

    def __init__(self):
        r"""
        :param _Result: Result
        :type Result: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class ModifyAntiFakeUrlStatusRequest(AbstractModel):
    """ModifyAntiFakeUrlStatus request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _Status: Status
        :type Status: int
        :param _Ids: ID List
        :type Ids: list of int non-negative
        """
        self._Domain = None
        self._Status = None
        self._Ids = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Ids(self):
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Status = params.get("Status")
        self._Ids = params.get("Ids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAntiFakeUrlStatusResponse(AbstractModel):
    """ModifyAntiFakeUrlStatus response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyAntiInfoLeakRuleStatusRequest(AbstractModel):
    """ModifyAntiInfoLeakRuleStatus request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _RuleId: Rule
        :type RuleId: int
        :param _Status: Status
        :type Status: int
        """
        self._Domain = None
        self._RuleId = None
        self._Status = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._RuleId = params.get("RuleId")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAntiInfoLeakRuleStatusResponse(AbstractModel):
    """ModifyAntiInfoLeakRuleStatus response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyAntiInfoLeakRulesRequest(AbstractModel):
    """ModifyAntiInfoLeakRules request structure.

    """

    def __init__(self):
        r"""
        :param _RuleId: Rule ID
        :type RuleId: int
        :param _Name: Rule name
        :type Name: str
        :param _Domain: Domain name
        :type Domain: str
        :param _ActionType: Action value
        :type ActionType: int
        :param _Strategies: Policy array
        :type Strategies: list of StrategyForAntiInfoLeak
        """
        self._RuleId = None
        self._Name = None
        self._Domain = None
        self._ActionType = None
        self._Strategies = None

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def ActionType(self):
        return self._ActionType

    @ActionType.setter
    def ActionType(self, ActionType):
        self._ActionType = ActionType

    @property
    def Strategies(self):
        return self._Strategies

    @Strategies.setter
    def Strategies(self, Strategies):
        self._Strategies = Strategies


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        self._Name = params.get("Name")
        self._Domain = params.get("Domain")
        self._ActionType = params.get("ActionType")
        if params.get("Strategies") is not None:
            self._Strategies = []
            for item in params.get("Strategies"):
                obj = StrategyForAntiInfoLeak()
                obj._deserialize(item)
                self._Strategies.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAntiInfoLeakRulesResponse(AbstractModel):
    """ModifyAntiInfoLeakRules response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyApiAnalyzeStatusRequest(AbstractModel):
    """ModifyApiAnalyzeStatus request structure.

    """

    def __init__(self):
        r"""
        :param _Status: Enabling status
        :type Status: int
        :param _Domain: Domain name
        :type Domain: str
        :param _InstanceId: Instance ID
        :type InstanceId: str
        :param _TargetList: List of entities to be bulk enabled
        :type TargetList: list of TargetEntity
        """
        self._Status = None
        self._Domain = None
        self._InstanceId = None
        self._TargetList = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def TargetList(self):
        return self._TargetList

    @TargetList.setter
    def TargetList(self, TargetList):
        self._TargetList = TargetList


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._Domain = params.get("Domain")
        self._InstanceId = params.get("InstanceId")
        if params.get("TargetList") is not None:
            self._TargetList = []
            for item in params.get("TargetList"):
                obj = TargetEntity()
                obj._deserialize(item)
                self._TargetList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyApiAnalyzeStatusResponse(AbstractModel):
    """ModifyApiAnalyzeStatus response structure.

    """

    def __init__(self):
        r"""
        :param _Count: Number of Activated. If the returned value is 3 (greater than the number of domains supported for activation), the activation has failed.

Note: This field may return null, indicating that no valid values can be obtained.
        :type Count: int
        :param _UnSupportedList: Domain list not supported to enable

Note: This field may return null, indicating that no valid values can be obtained.
        :type UnSupportedList: list of str
        :param _FailDomainList: Domain list with enabling/disabling failed

Note: This field may return null, indicating that no valid values can be obtained.
        :type FailDomainList: list of str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Count = None
        self._UnSupportedList = None
        self._FailDomainList = None
        self._RequestId = None

    @property
    def Count(self):
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def UnSupportedList(self):
        return self._UnSupportedList

    @UnSupportedList.setter
    def UnSupportedList(self, UnSupportedList):
        self._UnSupportedList = UnSupportedList

    @property
    def FailDomainList(self):
        return self._FailDomainList

    @FailDomainList.setter
    def FailDomainList(self, FailDomainList):
        self._FailDomainList = FailDomainList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Count = params.get("Count")
        self._UnSupportedList = params.get("UnSupportedList")
        self._FailDomainList = params.get("FailDomainList")
        self._RequestId = params.get("RequestId")


class ModifyBotStatusRequest(AbstractModel):
    """ModifyBotStatus request structure.

    """

    def __init__(self):
        r"""
        :param _Category: Category
        :type Category: str
        :param _Status: Status
        :type Status: str
        :param _Domain: Domain name
        :type Domain: str
        :param _InstanceID: Instance ID
        :type InstanceID: str
        :param _IsVersionFour: Whether it is the bot 4.0 version
        :type IsVersionFour: bool
        :param _BotVersion: Enter the bot version number, scenario-based version: 4.1.0
        :type BotVersion: str
        :param _DomainList: List of domain names on which bot detection is to be enabled or disabled in batch
        :type DomainList: list of str
        """
        self._Category = None
        self._Status = None
        self._Domain = None
        self._InstanceID = None
        self._IsVersionFour = None
        self._BotVersion = None
        self._DomainList = None

    @property
    def Category(self):
        return self._Category

    @Category.setter
    def Category(self, Category):
        self._Category = Category

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def InstanceID(self):
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID

    @property
    def IsVersionFour(self):
        return self._IsVersionFour

    @IsVersionFour.setter
    def IsVersionFour(self, IsVersionFour):
        self._IsVersionFour = IsVersionFour

    @property
    def BotVersion(self):
        return self._BotVersion

    @BotVersion.setter
    def BotVersion(self, BotVersion):
        self._BotVersion = BotVersion

    @property
    def DomainList(self):
        return self._DomainList

    @DomainList.setter
    def DomainList(self, DomainList):
        self._DomainList = DomainList


    def _deserialize(self, params):
        self._Category = params.get("Category")
        self._Status = params.get("Status")
        self._Domain = params.get("Domain")
        self._InstanceID = params.get("InstanceID")
        self._IsVersionFour = params.get("IsVersionFour")
        self._BotVersion = params.get("BotVersion")
        self._DomainList = params.get("DomainList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyBotStatusResponse(AbstractModel):
    """ModifyBotStatus response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Normally null

Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: str
        :param _UnSupportedList: List of domain names for which no bots are purchased
Note: This field may return null, indicating that no valid values can be obtained.
        :type UnSupportedList: list of str
        :param _FailDomainList: List of domain names which bots are purchased but the operation fails
Note: This field may return null, indicating that no valid values can be obtained.
        :type FailDomainList: list of str
        :param _Count: Number of successes
        :type Count: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._UnSupportedList = None
        self._FailDomainList = None
        self._Count = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def UnSupportedList(self):
        return self._UnSupportedList

    @UnSupportedList.setter
    def UnSupportedList(self, UnSupportedList):
        self._UnSupportedList = UnSupportedList

    @property
    def FailDomainList(self):
        return self._FailDomainList

    @FailDomainList.setter
    def FailDomainList(self, FailDomainList):
        self._FailDomainList = FailDomainList

    @property
    def Count(self):
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._UnSupportedList = params.get("UnSupportedList")
        self._FailDomainList = params.get("FailDomainList")
        self._Count = params.get("Count")
        self._RequestId = params.get("RequestId")


class ModifyCustomRuleRequest(AbstractModel):
    """ModifyCustomRule request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Edited domain
        :type Domain: str
        :param _RuleId: Edited rule ID
        :type RuleId: int
        :param _RuleName: Edited rule name
        :type RuleName: str
        :param _RuleAction: Executed actions: 0-allow, 1-block, 2-CAPTCHA, 3-observe, 4-redirect
        :type RuleAction: str
        :param _Strategies: Matching condition array
        :type Strategies: list of Strategy
        :param _Edition: Version of WAF. clb-waf indicates CLB WAF; sparta-waf indicates SaaS WAF. sparta-waf by default.
        :type Edition: str
        :param _Redirect: Redirected URL when action is set to redirect, / by default
        :type Redirect: str
        :param _Bypass: Whether to continue executing other check logic upon allowing. geoip: continue region blocking protection; cc: continue CC policy protection; owasp: continue web application protection; ai: continue AI engine protection; antileakage: continue information leakage prevention. If multiple values are entered, separate them with commas (,).
The default value is "geoip,cc,owasp,ai,antileakage".
        :type Bypass: str
        :param _SortId: Priority, an integer from 1 to 100. The smaller the number, the higher the execution priority of this rule.

The default value is 100.
        :type SortId: int
        :param _ExpireTime: Rule expiration deadline: 0 - permanently effective; other values correspond to the timestamp of the specified time.

The default value is 0.
        :type ExpireTime: int
        :param _JobType: Scheduled task type
        :type JobType: str
        :param _JobDateTime: Scheduled task configuration
        :type JobDateTime: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        :param _Source: Rule source. This parameter checks whether the rule source is mini program.
        :type Source: str
        :param _Status: Enabling status. Pass the value for rules of mini program risk control.
        :type Status: int
        :param _PageId: ID of the blocked page
        :type PageId: str
        """
        self._Domain = None
        self._RuleId = None
        self._RuleName = None
        self._RuleAction = None
        self._Strategies = None
        self._Edition = None
        self._Redirect = None
        self._Bypass = None
        self._SortId = None
        self._ExpireTime = None
        self._JobType = None
        self._JobDateTime = None
        self._Source = None
        self._Status = None
        self._PageId = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def RuleName(self):
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName

    @property
    def RuleAction(self):
        return self._RuleAction

    @RuleAction.setter
    def RuleAction(self, RuleAction):
        self._RuleAction = RuleAction

    @property
    def Strategies(self):
        return self._Strategies

    @Strategies.setter
    def Strategies(self, Strategies):
        self._Strategies = Strategies

    @property
    def Edition(self):
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def Redirect(self):
        return self._Redirect

    @Redirect.setter
    def Redirect(self, Redirect):
        self._Redirect = Redirect

    @property
    def Bypass(self):
        return self._Bypass

    @Bypass.setter
    def Bypass(self, Bypass):
        self._Bypass = Bypass

    @property
    def SortId(self):
        return self._SortId

    @SortId.setter
    def SortId(self, SortId):
        self._SortId = SortId

    @property
    def ExpireTime(self):
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def JobType(self):
        return self._JobType

    @JobType.setter
    def JobType(self, JobType):
        self._JobType = JobType

    @property
    def JobDateTime(self):
        return self._JobDateTime

    @JobDateTime.setter
    def JobDateTime(self, JobDateTime):
        self._JobDateTime = JobDateTime

    @property
    def Source(self):
        return self._Source

    @Source.setter
    def Source(self, Source):
        self._Source = Source

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def PageId(self):
        return self._PageId

    @PageId.setter
    def PageId(self, PageId):
        self._PageId = PageId


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._RuleId = params.get("RuleId")
        self._RuleName = params.get("RuleName")
        self._RuleAction = params.get("RuleAction")
        if params.get("Strategies") is not None:
            self._Strategies = []
            for item in params.get("Strategies"):
                obj = Strategy()
                obj._deserialize(item)
                self._Strategies.append(obj)
        self._Edition = params.get("Edition")
        self._Redirect = params.get("Redirect")
        self._Bypass = params.get("Bypass")
        self._SortId = params.get("SortId")
        self._ExpireTime = params.get("ExpireTime")
        self._JobType = params.get("JobType")
        if params.get("JobDateTime") is not None:
            self._JobDateTime = JobDateTime()
            self._JobDateTime._deserialize(params.get("JobDateTime"))
        self._Source = params.get("Source")
        self._Status = params.get("Status")
        self._PageId = params.get("PageId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyCustomRuleResponse(AbstractModel):
    """ModifyCustomRule response structure.

    """

    def __init__(self):
        r"""
        :param _Success: Operation status code: if all resource operations succeed, the success status code is returned; if any resource operation fails, the content of Message needs to be parsed to see which resource failed.
        :type Success: :class:`tencentcloud.waf.v20180125.models.ResponseCode`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Success = None
        self._RequestId = None

    @property
    def Success(self):
        return self._Success

    @Success.setter
    def Success(self, Success):
        self._Success = Success

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Success") is not None:
            self._Success = ResponseCode()
            self._Success._deserialize(params.get("Success"))
        self._RequestId = params.get("RequestId")


class ModifyCustomRuleStatusRequest(AbstractModel):
    """ModifyCustomRuleStatus request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _RuleId: Rule ID
        :type RuleId: int
        :param _Status: Status of the switch: 1 is On, 0 is Off
        :type Status: int
        :param _Edition: Version of WAF. clb-waf indicates CLB WAF; sparta-waf indicates SaaS WAF. sparta-waf by default.
        :type Edition: str
        :param _DomainRuleIdList: Rule ID
        :type DomainRuleIdList: list of DomainRuleId
        """
        self._Domain = None
        self._RuleId = None
        self._Status = None
        self._Edition = None
        self._DomainRuleIdList = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Edition(self):
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def DomainRuleIdList(self):
        return self._DomainRuleIdList

    @DomainRuleIdList.setter
    def DomainRuleIdList(self, DomainRuleIdList):
        self._DomainRuleIdList = DomainRuleIdList


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._RuleId = params.get("RuleId")
        self._Status = params.get("Status")
        self._Edition = params.get("Edition")
        if params.get("DomainRuleIdList") is not None:
            self._DomainRuleIdList = []
            for item in params.get("DomainRuleIdList"):
                obj = DomainRuleId()
                obj._deserialize(item)
                self._DomainRuleIdList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyCustomRuleStatusResponse(AbstractModel):
    """ModifyCustomRuleStatus response structure.

    """

    def __init__(self):
        r"""
        :param _Success: Operation status code: if all resource operations succeed, the success status code is returned; if any resource operation fails, the content of Message needs to be parsed to see which resource failed.
        :type Success: :class:`tencentcloud.waf.v20180125.models.ResponseCode`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Success = None
        self._RequestId = None

    @property
    def Success(self):
        return self._Success

    @Success.setter
    def Success(self, Success):
        self._Success = Success

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Success") is not None:
            self._Success = ResponseCode()
            self._Success._deserialize(params.get("Success"))
        self._RequestId = params.get("RequestId")


class ModifyCustomWhiteRuleRequest(AbstractModel):
    """ModifyCustomWhiteRule request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Edited domain
        :type Domain: str
        :param _RuleId: Edited rule ID
        :type RuleId: int
        :param _RuleName: Edited rule name
        :type RuleName: str
        :param _Bypass: Whether to continue executing other check logics when bypassing, continue executing regional ban protection - geoip; continue executing CC policy protection - cc; continue executing WEB application protection: owasp; continue executing AI engine protection - ai; continue executing information leakage protection - antileakage. If multiple items are selected, concatenate with commas (,).
        :type Bypass: str
        :param _SortId: Priority, an integer from 1 to 100. The smaller the number, the higher the execution priority of this rule.
        :type SortId: int
        :param _ExpireTime: Rule expiration deadline: 0 - permanently effective; other values correspond to the timestamp of the specified time.
        :type ExpireTime: int
        :param _Strategies: Matching condition array
        :type Strategies: list of Strategy
        :param _JobType: Scheduled task type
        :type JobType: str
        :param _JobDateTime: Scheduled task configuration
        :type JobDateTime: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        """
        self._Domain = None
        self._RuleId = None
        self._RuleName = None
        self._Bypass = None
        self._SortId = None
        self._ExpireTime = None
        self._Strategies = None
        self._JobType = None
        self._JobDateTime = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def RuleName(self):
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName

    @property
    def Bypass(self):
        return self._Bypass

    @Bypass.setter
    def Bypass(self, Bypass):
        self._Bypass = Bypass

    @property
    def SortId(self):
        return self._SortId

    @SortId.setter
    def SortId(self, SortId):
        self._SortId = SortId

    @property
    def ExpireTime(self):
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def Strategies(self):
        return self._Strategies

    @Strategies.setter
    def Strategies(self, Strategies):
        self._Strategies = Strategies

    @property
    def JobType(self):
        return self._JobType

    @JobType.setter
    def JobType(self, JobType):
        self._JobType = JobType

    @property
    def JobDateTime(self):
        return self._JobDateTime

    @JobDateTime.setter
    def JobDateTime(self, JobDateTime):
        self._JobDateTime = JobDateTime


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._RuleId = params.get("RuleId")
        self._RuleName = params.get("RuleName")
        self._Bypass = params.get("Bypass")
        self._SortId = params.get("SortId")
        self._ExpireTime = params.get("ExpireTime")
        if params.get("Strategies") is not None:
            self._Strategies = []
            for item in params.get("Strategies"):
                obj = Strategy()
                obj._deserialize(item)
                self._Strategies.append(obj)
        self._JobType = params.get("JobType")
        if params.get("JobDateTime") is not None:
            self._JobDateTime = JobDateTime()
            self._JobDateTime._deserialize(params.get("JobDateTime"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyCustomWhiteRuleResponse(AbstractModel):
    """ModifyCustomWhiteRule response structure.

    """

    def __init__(self):
        r"""
        :param _Success: Operation status code: if all resource operations succeed, the success status code is returned; if any resource operation fails, the content of Message needs to be parsed to see which resource failed.
        :type Success: :class:`tencentcloud.waf.v20180125.models.ResponseCode`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Success = None
        self._RequestId = None

    @property
    def Success(self):
        return self._Success

    @Success.setter
    def Success(self, Success):
        self._Success = Success

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Success") is not None:
            self._Success = ResponseCode()
            self._Success._deserialize(params.get("Success"))
        self._RequestId = params.get("RequestId")


class ModifyCustomWhiteRuleStatusRequest(AbstractModel):
    """ModifyCustomWhiteRuleStatus request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _RuleId: Rule ID
        :type RuleId: int
        :param _Status: Status of the switch: 1 is On, 0 is Off
        :type Status: int
        """
        self._Domain = None
        self._RuleId = None
        self._Status = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._RuleId = params.get("RuleId")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyCustomWhiteRuleStatusResponse(AbstractModel):
    """ModifyCustomWhiteRuleStatus response structure.

    """

    def __init__(self):
        r"""
        :param _Success: Operation status code: if all resource operations succeed, the success status code is returned; if any resource operation fails, the content of Message needs to be parsed to see which resource failed.
        :type Success: :class:`tencentcloud.waf.v20180125.models.ResponseCode`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Success = None
        self._RequestId = None

    @property
    def Success(self):
        return self._Success

    @Success.setter
    def Success(self, Success):
        self._Success = Success

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Success") is not None:
            self._Success = ResponseCode()
            self._Success._deserialize(params.get("Success"))
        self._RequestId = params.get("RequestId")


class ModifyDomainIpv6StatusRequest(AbstractModel):
    """ModifyDomainIpv6Status request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID of the domain to be modified
        :type InstanceId: str
        :param _Domain: Domain to modify
        :type Domain: str
        :param _DomainId: Domain ID to be modified
        :type DomainId: str
        :param _Status: IPv6 switch for modifying domain is Status (1: enable, 2: disable)
        :type Status: int
        """
        self._InstanceId = None
        self._Domain = None
        self._DomainId = None
        self._Status = None

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def DomainId(self):
        return self._DomainId

    @DomainId.setter
    def DomainId(self, DomainId):
        self._DomainId = DomainId

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Domain = params.get("Domain")
        self._DomainId = params.get("DomainId")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyDomainIpv6StatusResponse(AbstractModel):
    """ModifyDomainIpv6Status response structure.

    """

    def __init__(self):
        r"""
        :param _Ipv6Status: Returned status (0: Operation Failed 1: Operation Succeeded 2: Not Supported for Enterprise Edition and Above 3: Not Supported for Below Enterprise Edition)
        :type Ipv6Status: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Ipv6Status = None
        self._RequestId = None

    @property
    def Ipv6Status(self):
        return self._Ipv6Status

    @Ipv6Status.setter
    def Ipv6Status(self, Ipv6Status):
        self._Ipv6Status = Ipv6Status

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Ipv6Status = params.get("Ipv6Status")
        self._RequestId = params.get("RequestId")


class ModifyDomainsCLSStatusRequest(AbstractModel):
    """ModifyDomainsCLSStatus request structure.

    """

    def __init__(self):
        r"""
        :param _Domains: Domain name list to be modified
        :type Domains: list of DomainURI
        :param _Status: Change the access log switch of the domain to Status
        :type Status: int
        """
        self._Domains = None
        self._Status = None

    @property
    def Domains(self):
        return self._Domains

    @Domains.setter
    def Domains(self, Domains):
        self._Domains = Domains

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        if params.get("Domains") is not None:
            self._Domains = []
            for item in params.get("Domains"):
                obj = DomainURI()
                obj._deserialize(item)
                self._Domains.append(obj)
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyDomainsCLSStatusResponse(AbstractModel):
    """ModifyDomainsCLSStatus response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyHostFlowModeRequest(AbstractModel):
    """ModifyHostFlowMode request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _DomainId: Domain ID
        :type DomainId: str
        :param _FlowMode: WAF traffic mode
0: mirror mode (default)
1: cleaning mode
        :type FlowMode: int
        :param _InstanceID: Instance ID
        :type InstanceID: str
        """
        self._Domain = None
        self._DomainId = None
        self._FlowMode = None
        self._InstanceID = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def DomainId(self):
        return self._DomainId

    @DomainId.setter
    def DomainId(self, DomainId):
        self._DomainId = DomainId

    @property
    def FlowMode(self):
        return self._FlowMode

    @FlowMode.setter
    def FlowMode(self, FlowMode):
        self._FlowMode = FlowMode

    @property
    def InstanceID(self):
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._DomainId = params.get("DomainId")
        self._FlowMode = params.get("FlowMode")
        self._InstanceID = params.get("InstanceID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyHostFlowModeResponse(AbstractModel):
    """ModifyHostFlowMode response structure.

    """

    def __init__(self):
        r"""
        :param _Success: Successful status code
        :type Success: :class:`tencentcloud.waf.v20180125.models.ResponseCode`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Success = None
        self._RequestId = None

    @property
    def Success(self):
        return self._Success

    @Success.setter
    def Success(self, Success):
        self._Success = Success

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Success") is not None:
            self._Success = ResponseCode()
            self._Success._deserialize(params.get("Success"))
        self._RequestId = params.get("RequestId")


class ModifyHostModeRequest(AbstractModel):
    """ModifyHostMode request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _DomainId: Domain ID
        :type DomainId: str
        :param _Mode: Protection status:
10: rule-based observation and AI disabling; 11: rule- and AI-based observation; 12: rule-based observation and AI-based interception
20: rule-based interception and AI disabling; 21: rule-based interception and AI-based observation; 22: rule- and AI-based interception
        :type Mode: int
        :param _Type: 0: Change protection mode, 1: Modify AI
        :type Type: int
        :param _InstanceID: Instance ID
        :type InstanceID: str
        :param _Edition: Instance type
        :type Edition: str
        """
        self._Domain = None
        self._DomainId = None
        self._Mode = None
        self._Type = None
        self._InstanceID = None
        self._Edition = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def DomainId(self):
        return self._DomainId

    @DomainId.setter
    def DomainId(self, DomainId):
        self._DomainId = DomainId

    @property
    def Mode(self):
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def InstanceID(self):
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID

    @property
    def Edition(self):
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._DomainId = params.get("DomainId")
        self._Mode = params.get("Mode")
        self._Type = params.get("Type")
        self._InstanceID = params.get("InstanceID")
        self._Edition = params.get("Edition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyHostModeResponse(AbstractModel):
    """ModifyHostMode response structure.

    """

    def __init__(self):
        r"""
        :param _Success: Operation status code: if all resource operations succeed, the success status code is returned; if any resource operation fails, the content of Message needs to be parsed to see which resource failed.

Note: This field may return null, indicating that no valid values can be obtained.
        :type Success: :class:`tencentcloud.waf.v20180125.models.ResponseCode`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Success = None
        self._RequestId = None

    @property
    def Success(self):
        return self._Success

    @Success.setter
    def Success(self, Success):
        self._Success = Success

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Success") is not None:
            self._Success = ResponseCode()
            self._Success._deserialize(params.get("Success"))
        self._RequestId = params.get("RequestId")


class ModifyHostRequest(AbstractModel):
    """ModifyHost request structure.

    """

    def __init__(self):
        r"""
        :param _Host: Edited domain configuration information
        :type Host: :class:`tencentcloud.waf.v20180125.models.HostRecord`
        :param _InstanceID: Unique Instance ID
        :type InstanceID: str
        """
        self._Host = None
        self._InstanceID = None

    @property
    def Host(self):
        return self._Host

    @Host.setter
    def Host(self, Host):
        self._Host = Host

    @property
    def InstanceID(self):
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID


    def _deserialize(self, params):
        if params.get("Host") is not None:
            self._Host = HostRecord()
            self._Host._deserialize(params.get("Host"))
        self._InstanceID = params.get("InstanceID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyHostResponse(AbstractModel):
    """ModifyHost response structure.

    """

    def __init__(self):
        r"""
        :param _DomainId: Edited domain ID
        :type DomainId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DomainId = None
        self._RequestId = None

    @property
    def DomainId(self):
        return self._DomainId

    @DomainId.setter
    def DomainId(self, DomainId):
        self._DomainId = DomainId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DomainId = params.get("DomainId")
        self._RequestId = params.get("RequestId")


class ModifyHostStatusRequest(AbstractModel):
    """ModifyHostStatus request structure.

    """

    def __init__(self):
        r"""
        :param _HostsStatus: Domain status list
        :type HostsStatus: list of HostStatus
        """
        self._HostsStatus = None

    @property
    def HostsStatus(self):
        return self._HostsStatus

    @HostsStatus.setter
    def HostsStatus(self, HostsStatus):
        self._HostsStatus = HostsStatus


    def _deserialize(self, params):
        if params.get("HostsStatus") is not None:
            self._HostsStatus = []
            for item in params.get("HostsStatus"):
                obj = HostStatus()
                obj._deserialize(item)
                self._HostsStatus.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyHostStatusResponse(AbstractModel):
    """ModifyHostStatus response structure.

    """

    def __init__(self):
        r"""
        :param _Success: Successful status code, needs JSON decoding before use, the returned format is {Domain:Status}, successful status code is Success, others are failed status codes (YunAPI Defined Error Codes)
        :type Success: :class:`tencentcloud.waf.v20180125.models.ResponseCode`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Success = None
        self._RequestId = None

    @property
    def Success(self):
        return self._Success

    @Success.setter
    def Success(self, Success):
        self._Success = Success

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Success") is not None:
            self._Success = ResponseCode()
            self._Success._deserialize(params.get("Success"))
        self._RequestId = params.get("RequestId")


class ModifyInstanceElasticModeRequest(AbstractModel):
    """ModifyInstanceElasticMode request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID
        :type InstanceId: str
        :param _Mode: Elastic billing switch.
        :type Mode: int
        """
        self._InstanceId = None
        self._Mode = None

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Mode(self):
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Mode = params.get("Mode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyInstanceElasticModeResponse(AbstractModel):
    """ModifyInstanceElasticMode response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyInstanceNameRequest(AbstractModel):
    """ModifyInstanceName request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceName: New name.
        :type InstanceName: str
        :param _InstanceID: Instance ID
        :type InstanceID: str
        :param _Edition: Version
        :type Edition: str
        """
        self._InstanceName = None
        self._InstanceID = None
        self._Edition = None

    @property
    def InstanceName(self):
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def InstanceID(self):
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID

    @property
    def Edition(self):
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition


    def _deserialize(self, params):
        self._InstanceName = params.get("InstanceName")
        self._InstanceID = params.get("InstanceID")
        self._Edition = params.get("Edition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyInstanceNameResponse(AbstractModel):
    """ModifyInstanceName response structure.

    """

    def __init__(self):
        r"""
        :param _ModifyCode: Modification status: 0 indicates success
        :type ModifyCode: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ModifyCode = None
        self._RequestId = None

    @property
    def ModifyCode(self):
        return self._ModifyCode

    @ModifyCode.setter
    def ModifyCode(self, ModifyCode):
        self._ModifyCode = ModifyCode

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ModifyCode = params.get("ModifyCode")
        self._RequestId = params.get("RequestId")


class ModifyInstanceQpsLimitRequest(AbstractModel):
    """ModifyInstanceQpsLimit request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Package instance ID
        :type InstanceId: str
        :param _QpsLimit: QPS cap
        :type QpsLimit: int
        """
        self._InstanceId = None
        self._QpsLimit = None

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def QpsLimit(self):
        return self._QpsLimit

    @QpsLimit.setter
    def QpsLimit(self, QpsLimit):
        self._QpsLimit = QpsLimit


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._QpsLimit = params.get("QpsLimit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyInstanceQpsLimitResponse(AbstractModel):
    """ModifyInstanceQpsLimit response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyInstanceRenewFlagRequest(AbstractModel):
    """ModifyInstanceRenewFlag request structure.

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID
        :type InstanceId: str
        :param _RenewFlag: Renewal switch
        :type RenewFlag: int
        """
        self._InstanceId = None
        self._RenewFlag = None

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def RenewFlag(self):
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._RenewFlag = params.get("RenewFlag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyInstanceRenewFlagResponse(AbstractModel):
    """ModifyInstanceRenewFlag response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyIpAccessControlRequest(AbstractModel):
    """ModifyIpAccessControl request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Specific domain name, for example, test.qcloudwaf.com.
Global domain name, that is, global.
        :type Domain: str
        :param _IpList: IP parameter list.
        :type IpList: list of str
        :param _ActionType: 42: blocklist; 40: allowlist.
        :type ActionType: int
        :param _ValidTS: valid_ts indicates a valid date. Its value is a second-level timestamp, such as 1680570420, which indicates 2023-04-04 09:07:00.
        :type ValidTS: int
        :param _RuleId: Rule ID
        :type RuleId: int
        :param _InstanceId: Instance ID
        :type InstanceId: str
        :param _Edition: WAF instance type: sparta-waf for SaaS WAF, clb-waf for CLB WAF.
        :type Edition: str
        :param _SourceType: Batch protection IP blocklists/allowlists or not. If yes, the value is batch; otherwise, it is empty.
        :type SourceType: str
        :param _Note: Remarks
        :type Note: str
        :param _JobType: Scheduled configuration type.
        :type JobType: str
        :param _JobDateTime: Details of scheduled configuration.
        :type JobDateTime: :class:`tencentcloud.waf.v20180125.models.JobDateTime`
        """
        self._Domain = None
        self._IpList = None
        self._ActionType = None
        self._ValidTS = None
        self._RuleId = None
        self._InstanceId = None
        self._Edition = None
        self._SourceType = None
        self._Note = None
        self._JobType = None
        self._JobDateTime = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def IpList(self):
        return self._IpList

    @IpList.setter
    def IpList(self, IpList):
        self._IpList = IpList

    @property
    def ActionType(self):
        return self._ActionType

    @ActionType.setter
    def ActionType(self, ActionType):
        self._ActionType = ActionType

    @property
    def ValidTS(self):
        return self._ValidTS

    @ValidTS.setter
    def ValidTS(self, ValidTS):
        self._ValidTS = ValidTS

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Edition(self):
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def SourceType(self):
        return self._SourceType

    @SourceType.setter
    def SourceType(self, SourceType):
        self._SourceType = SourceType

    @property
    def Note(self):
        return self._Note

    @Note.setter
    def Note(self, Note):
        self._Note = Note

    @property
    def JobType(self):
        return self._JobType

    @JobType.setter
    def JobType(self, JobType):
        self._JobType = JobType

    @property
    def JobDateTime(self):
        return self._JobDateTime

    @JobDateTime.setter
    def JobDateTime(self, JobDateTime):
        self._JobDateTime = JobDateTime


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._IpList = params.get("IpList")
        self._ActionType = params.get("ActionType")
        self._ValidTS = params.get("ValidTS")
        self._RuleId = params.get("RuleId")
        self._InstanceId = params.get("InstanceId")
        self._Edition = params.get("Edition")
        self._SourceType = params.get("SourceType")
        self._Note = params.get("Note")
        self._JobType = params.get("JobType")
        if params.get("JobDateTime") is not None:
            self._JobDateTime = JobDateTime()
            self._JobDateTime._deserialize(params.get("JobDateTime"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyIpAccessControlResponse(AbstractModel):
    """ModifyIpAccessControl response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyModuleStatusRequest(AbstractModel):
    """ModifyModuleStatus request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain to be set
        :type Domain: str
        :param _WebSecurity: Enabling status of the web security module. The value is 0 or 1.
        :type WebSecurity: int
        :param _AccessControl: Access control module switch: 0 or 1
        :type AccessControl: int
        :param _CcProtection: CC module switch, 0 or 1
        :type CcProtection: int
        :param _ApiProtection: API security module switch, 0 or 1
        :type ApiProtection: int
        :param _AntiTamper: Tamper-proof module switch: 0 or 1
        :type AntiTamper: int
        :param _AntiLeakage: Leakage prevention module switch: 0 or 1
        :type AntiLeakage: int
        :param _RateLimit: Traffic limiting module switch: 0 or 1
        :type RateLimit: int
        """
        self._Domain = None
        self._WebSecurity = None
        self._AccessControl = None
        self._CcProtection = None
        self._ApiProtection = None
        self._AntiTamper = None
        self._AntiLeakage = None
        self._RateLimit = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def WebSecurity(self):
        return self._WebSecurity

    @WebSecurity.setter
    def WebSecurity(self, WebSecurity):
        self._WebSecurity = WebSecurity

    @property
    def AccessControl(self):
        return self._AccessControl

    @AccessControl.setter
    def AccessControl(self, AccessControl):
        self._AccessControl = AccessControl

    @property
    def CcProtection(self):
        return self._CcProtection

    @CcProtection.setter
    def CcProtection(self, CcProtection):
        self._CcProtection = CcProtection

    @property
    def ApiProtection(self):
        return self._ApiProtection

    @ApiProtection.setter
    def ApiProtection(self, ApiProtection):
        self._ApiProtection = ApiProtection

    @property
    def AntiTamper(self):
        return self._AntiTamper

    @AntiTamper.setter
    def AntiTamper(self, AntiTamper):
        self._AntiTamper = AntiTamper

    @property
    def AntiLeakage(self):
        return self._AntiLeakage

    @AntiLeakage.setter
    def AntiLeakage(self, AntiLeakage):
        self._AntiLeakage = AntiLeakage

    @property
    def RateLimit(self):
        return self._RateLimit

    @RateLimit.setter
    def RateLimit(self, RateLimit):
        self._RateLimit = RateLimit


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._WebSecurity = params.get("WebSecurity")
        self._AccessControl = params.get("AccessControl")
        self._CcProtection = params.get("CcProtection")
        self._ApiProtection = params.get("ApiProtection")
        self._AntiTamper = params.get("AntiTamper")
        self._AntiLeakage = params.get("AntiLeakage")
        self._RateLimit = params.get("RateLimit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyModuleStatusResponse(AbstractModel):
    """ModifyModuleStatus response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyObjectRequest(AbstractModel):
    """ModifyObject request structure.

    """

    def __init__(self):
        r"""
        :param _ObjectId: Modifies the object identifier
        :type ObjectId: str
        :param _OpType: Action type. Status: change enabling status; InstanceId: bind to an instance; Proxy: set the proxy status.
        :type OpType: str
        :param _Status: New WAF switch status, considered successful if identical to existing status
        :type Status: int
        :param _InstanceId: New instance ID: considered a successful modification if identical to an already bound instance
        :type InstanceId: str
        :param _Proxy: Whether to enable proxy. 0: do not enable; 1: use the first IP address in XFF as the client IP address; 2: use remote_addr as the client IP address; 3: obtain the client IP address from the specified header field that is given in IpHeaders. (This value is effective when OpType is set to Status or Proxy.)
        :type Proxy: int
        :param _IpHeaders: This parameter indicates a custom header and is required when IsCdn is set to 3. (The value is effective when OpType is set to Status or Proxy.)
        :type IpHeaders: list of str
        """
        self._ObjectId = None
        self._OpType = None
        self._Status = None
        self._InstanceId = None
        self._Proxy = None
        self._IpHeaders = None

    @property
    def ObjectId(self):
        return self._ObjectId

    @ObjectId.setter
    def ObjectId(self, ObjectId):
        self._ObjectId = ObjectId

    @property
    def OpType(self):
        return self._OpType

    @OpType.setter
    def OpType(self, OpType):
        self._OpType = OpType

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Proxy(self):
        return self._Proxy

    @Proxy.setter
    def Proxy(self, Proxy):
        self._Proxy = Proxy

    @property
    def IpHeaders(self):
        return self._IpHeaders

    @IpHeaders.setter
    def IpHeaders(self, IpHeaders):
        self._IpHeaders = IpHeaders


    def _deserialize(self, params):
        self._ObjectId = params.get("ObjectId")
        self._OpType = params.get("OpType")
        self._Status = params.get("Status")
        self._InstanceId = params.get("InstanceId")
        self._Proxy = params.get("Proxy")
        self._IpHeaders = params.get("IpHeaders")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyObjectResponse(AbstractModel):
    """ModifyObject response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyProtectionStatusRequest(AbstractModel):
    """ModifyProtectionStatus request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _Status: Status
        :type Status: int
        :param _Edition: Version of WAF. clb-waf indicates CLB WAF; sparta-waf indicates SaaS WAF. sparta-waf by default.
        :type Edition: str
        """
        self._Domain = None
        self._Status = None
        self._Edition = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Edition(self):
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Status = params.get("Status")
        self._Edition = params.get("Edition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyProtectionStatusResponse(AbstractModel):
    """ModifyProtectionStatus response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifySpartaProtectionModeRequest(AbstractModel):
    """ModifySpartaProtectionMode request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _Mode: Protection status:
10: rule-based observation and AI disabling; 11: rule- and AI-based observation; 12: rule-based observation and AI-based interception
20: rule-based interception and AI disabling; 21: rule-based interception and AI-based observation; 22: rule- and AI-based interception
        :type Mode: int
        :param _Edition: Version of WAF. clb-waf indicates CLB WAF; sparta-waf indicates SaaS WAF. sparta-waf by default.
        :type Edition: str
        :param _Type: 0 is for modifying the Rule Engine Status; 1 is for modifying the AI Status
        :type Type: int
        """
        self._Domain = None
        self._Mode = None
        self._Edition = None
        self._Type = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Mode(self):
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def Edition(self):
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Mode = params.get("Mode")
        self._Edition = params.get("Edition")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifySpartaProtectionModeResponse(AbstractModel):
    """ModifySpartaProtectionMode response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifySpartaProtectionRequest(AbstractModel):
    """ModifySpartaProtection request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _DomainId: Required. Unique domain name ID
        :type DomainId: str
        :param _InstanceID: Required. Instance ID of the domain name
        :type InstanceID: str
        :param _CertType: Certificate type. 0: no certificate, with only the HTTP listening port configured; 1: self-owned certificate; 2: managed certificate.
        :type CertType: int
        :param _Cert: When CertType is 1, this parameter is required, indicating the self-owned certificate chain
        :type Cert: str
        :param _PrivateKey: When CertType=1, this parameter is required, indicating the private key of the self-owned certificate.
        :type PrivateKey: str
        :param _SSLId: When CertType is 2, this parameter must be filled, indicating the certificate ID hosted on Tencent Cloud's SSL platform
        :type SSLId: str
        :param _IsCdn: Whether a layer-7 proxy service is deployed before the WAF. 0: No proxy service is deployed; 1: The proxy service is deployed. The WAF will use XFF to obtain the client IP address; 2: The proxy service is deployed. The WAF will use remote_addr to obtain the client IP address; 3: The proxy service is deployed. The WAF will use a custom header in ip_headers to obtain the client IP address.
        :type IsCdn: int
        :param _UpstreamScheme: Origin-pull protocol for HTTPS when the service is configured with an HTTPS port.
http: Use the HTTP protocol for origin-pull. It is used with HttpsUpstreamPort.
https: Use the HTTPS protocol for origin-pull.
        :type UpstreamScheme: str
        :param _HttpsUpstreamPort: HTTPS upstream port, required only when UpstreamScheme is http
        :type HttpsUpstreamPort: str
        :param _HttpsRewrite: Whether to enable forced redirection from HTTP to HTTPS. 0: disable; 1: enable
        :type HttpsRewrite: int
        :param _UpstreamType: upstream type. 0: proxy to upstream by IP; 1: proxy to upstream by domain name
        :type UpstreamType: int
        :param _UpstreamDomain: Upstream domain when proxy to upstream by domain. When UpstreamType=1, this field needs to be filled
        :type UpstreamDomain: str
        :param _SrcList: Upstream IP list when proxy to upstream by IP. When UpstreamType=0, this field is required
        :type SrcList: list of str
        :param _IsHttp2: Whether to enable HTTP2. You should enable HTTPS as well. 0: disable; 1: enable
        :type IsHttp2: int
        :param _IsWebsocket: Whether to enable WebSocket. 0: disable; 1: enable
        :type IsWebsocket: int
        :param _LoadBalance: Load balancing policy for upstream. 0: round-robin scheduling; 1: IP hash; 2: weighted round-robin scheduling
        :type LoadBalance: int
        :param _IsGray: To be deprecated, can be left blank. Whether to enable grayscale: 0 indicates not to enable grayscale.
        :type IsGray: int
        :param _Edition: Instance type of the domain name
        :type Edition: str
        :param _Ports: Port information, which can be obtained through the DescribeDomains API
        :type Ports: list of SpartaProtectionPort
        :param _IsKeepAlive: Whether to enable persistent connection. 0: non-persistent connection; 1: persistent connection
        :type IsKeepAlive: str
        :param _Anycast: To be deprecated. Currently, set this parameter to 0. Anycast IP type switch. 0: common IP; 1: Anycast IP
        :type Anycast: int
        :param _Weights: Weight of each IP in the upstream IP List, corresponding to SrcList. Required only when UpstreamType is 0, and SrcList contains multiple IPs, and LoadBalance is 2; otherwise, fill in [ ].
        :type Weights: list of int
        :param _ActiveCheck: Whether to enable proactive health detection. 0: disable; 1: enable
        :type ActiveCheck: int
        :param _TLSVersion: TLS version information
        :type TLSVersion: int
        :param _Ciphers: Cipher suite information
        :type Ciphers: list of int
        :param _CipherTemplate: Cipher suite template. 0: default template (no selection); 1: general template; 2: secure template; 3: custom template
        :type CipherTemplate: int
        :param _ProxyReadTimeout: Read timeout between WAF and upstream server, 300s by default.
        :type ProxyReadTimeout: int
        :param _ProxySendTimeout: WAF and origin server write timeout, 300s by default.
        :type ProxySendTimeout: int
        :param _SniType: SNI type when proxy to upstream.
0: Disable SNI and do not configure server_name in client_hello.
1: Enable SNI. server_name in client_hello is the protected domain name.
2: Enable SNI. SNI is the origin server domain name when proxy to upstream by domain.
3: Enable SNI. SNI is the custom domain name.
        :type SniType: int
        :param _SniHost: When SniType=3, this parameter is required, indicating a custom SNI;
        :type SniHost: str
        :param _IpHeaders: IsCdn=3 required for this parameter, indicates custom header
        :type IpHeaders: list of str
        :param _XFFReset: Whether to enable XFF reset. 0: disable; 1: enable
        :type XFFReset: int
        :param _Note: Domain name remarks
        :type Note: str
        :param _UpstreamHost: Custom upstream host. The default value is a null string, indicating that the protected domain name is used as the upstream host.
        :type UpstreamHost: str
        :param _ProxyBuffer: Whether to enable caching. 0: disable; 1: enable.
        :type ProxyBuffer: int
        :param _ProbeStatus: 0: Disable probe test; 1: Enable probe test. The probe test is enabled by default.
        :type ProbeStatus: int
        """
        self._Domain = None
        self._DomainId = None
        self._InstanceID = None
        self._CertType = None
        self._Cert = None
        self._PrivateKey = None
        self._SSLId = None
        self._IsCdn = None
        self._UpstreamScheme = None
        self._HttpsUpstreamPort = None
        self._HttpsRewrite = None
        self._UpstreamType = None
        self._UpstreamDomain = None
        self._SrcList = None
        self._IsHttp2 = None
        self._IsWebsocket = None
        self._LoadBalance = None
        self._IsGray = None
        self._Edition = None
        self._Ports = None
        self._IsKeepAlive = None
        self._Anycast = None
        self._Weights = None
        self._ActiveCheck = None
        self._TLSVersion = None
        self._Ciphers = None
        self._CipherTemplate = None
        self._ProxyReadTimeout = None
        self._ProxySendTimeout = None
        self._SniType = None
        self._SniHost = None
        self._IpHeaders = None
        self._XFFReset = None
        self._Note = None
        self._UpstreamHost = None
        self._ProxyBuffer = None
        self._ProbeStatus = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def DomainId(self):
        return self._DomainId

    @DomainId.setter
    def DomainId(self, DomainId):
        self._DomainId = DomainId

    @property
    def InstanceID(self):
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID

    @property
    def CertType(self):
        return self._CertType

    @CertType.setter
    def CertType(self, CertType):
        self._CertType = CertType

    @property
    def Cert(self):
        return self._Cert

    @Cert.setter
    def Cert(self, Cert):
        self._Cert = Cert

    @property
    def PrivateKey(self):
        return self._PrivateKey

    @PrivateKey.setter
    def PrivateKey(self, PrivateKey):
        self._PrivateKey = PrivateKey

    @property
    def SSLId(self):
        return self._SSLId

    @SSLId.setter
    def SSLId(self, SSLId):
        self._SSLId = SSLId

    @property
    def IsCdn(self):
        return self._IsCdn

    @IsCdn.setter
    def IsCdn(self, IsCdn):
        self._IsCdn = IsCdn

    @property
    def UpstreamScheme(self):
        return self._UpstreamScheme

    @UpstreamScheme.setter
    def UpstreamScheme(self, UpstreamScheme):
        self._UpstreamScheme = UpstreamScheme

    @property
    def HttpsUpstreamPort(self):
        return self._HttpsUpstreamPort

    @HttpsUpstreamPort.setter
    def HttpsUpstreamPort(self, HttpsUpstreamPort):
        self._HttpsUpstreamPort = HttpsUpstreamPort

    @property
    def HttpsRewrite(self):
        return self._HttpsRewrite

    @HttpsRewrite.setter
    def HttpsRewrite(self, HttpsRewrite):
        self._HttpsRewrite = HttpsRewrite

    @property
    def UpstreamType(self):
        return self._UpstreamType

    @UpstreamType.setter
    def UpstreamType(self, UpstreamType):
        self._UpstreamType = UpstreamType

    @property
    def UpstreamDomain(self):
        return self._UpstreamDomain

    @UpstreamDomain.setter
    def UpstreamDomain(self, UpstreamDomain):
        self._UpstreamDomain = UpstreamDomain

    @property
    def SrcList(self):
        return self._SrcList

    @SrcList.setter
    def SrcList(self, SrcList):
        self._SrcList = SrcList

    @property
    def IsHttp2(self):
        return self._IsHttp2

    @IsHttp2.setter
    def IsHttp2(self, IsHttp2):
        self._IsHttp2 = IsHttp2

    @property
    def IsWebsocket(self):
        return self._IsWebsocket

    @IsWebsocket.setter
    def IsWebsocket(self, IsWebsocket):
        self._IsWebsocket = IsWebsocket

    @property
    def LoadBalance(self):
        return self._LoadBalance

    @LoadBalance.setter
    def LoadBalance(self, LoadBalance):
        self._LoadBalance = LoadBalance

    @property
    def IsGray(self):
        return self._IsGray

    @IsGray.setter
    def IsGray(self, IsGray):
        self._IsGray = IsGray

    @property
    def Edition(self):
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def Ports(self):
        return self._Ports

    @Ports.setter
    def Ports(self, Ports):
        self._Ports = Ports

    @property
    def IsKeepAlive(self):
        return self._IsKeepAlive

    @IsKeepAlive.setter
    def IsKeepAlive(self, IsKeepAlive):
        self._IsKeepAlive = IsKeepAlive

    @property
    def Anycast(self):
        return self._Anycast

    @Anycast.setter
    def Anycast(self, Anycast):
        self._Anycast = Anycast

    @property
    def Weights(self):
        return self._Weights

    @Weights.setter
    def Weights(self, Weights):
        self._Weights = Weights

    @property
    def ActiveCheck(self):
        return self._ActiveCheck

    @ActiveCheck.setter
    def ActiveCheck(self, ActiveCheck):
        self._ActiveCheck = ActiveCheck

    @property
    def TLSVersion(self):
        return self._TLSVersion

    @TLSVersion.setter
    def TLSVersion(self, TLSVersion):
        self._TLSVersion = TLSVersion

    @property
    def Ciphers(self):
        return self._Ciphers

    @Ciphers.setter
    def Ciphers(self, Ciphers):
        self._Ciphers = Ciphers

    @property
    def CipherTemplate(self):
        return self._CipherTemplate

    @CipherTemplate.setter
    def CipherTemplate(self, CipherTemplate):
        self._CipherTemplate = CipherTemplate

    @property
    def ProxyReadTimeout(self):
        return self._ProxyReadTimeout

    @ProxyReadTimeout.setter
    def ProxyReadTimeout(self, ProxyReadTimeout):
        self._ProxyReadTimeout = ProxyReadTimeout

    @property
    def ProxySendTimeout(self):
        return self._ProxySendTimeout

    @ProxySendTimeout.setter
    def ProxySendTimeout(self, ProxySendTimeout):
        self._ProxySendTimeout = ProxySendTimeout

    @property
    def SniType(self):
        return self._SniType

    @SniType.setter
    def SniType(self, SniType):
        self._SniType = SniType

    @property
    def SniHost(self):
        return self._SniHost

    @SniHost.setter
    def SniHost(self, SniHost):
        self._SniHost = SniHost

    @property
    def IpHeaders(self):
        return self._IpHeaders

    @IpHeaders.setter
    def IpHeaders(self, IpHeaders):
        self._IpHeaders = IpHeaders

    @property
    def XFFReset(self):
        return self._XFFReset

    @XFFReset.setter
    def XFFReset(self, XFFReset):
        self._XFFReset = XFFReset

    @property
    def Note(self):
        return self._Note

    @Note.setter
    def Note(self, Note):
        self._Note = Note

    @property
    def UpstreamHost(self):
        return self._UpstreamHost

    @UpstreamHost.setter
    def UpstreamHost(self, UpstreamHost):
        self._UpstreamHost = UpstreamHost

    @property
    def ProxyBuffer(self):
        return self._ProxyBuffer

    @ProxyBuffer.setter
    def ProxyBuffer(self, ProxyBuffer):
        self._ProxyBuffer = ProxyBuffer

    @property
    def ProbeStatus(self):
        return self._ProbeStatus

    @ProbeStatus.setter
    def ProbeStatus(self, ProbeStatus):
        self._ProbeStatus = ProbeStatus


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._DomainId = params.get("DomainId")
        self._InstanceID = params.get("InstanceID")
        self._CertType = params.get("CertType")
        self._Cert = params.get("Cert")
        self._PrivateKey = params.get("PrivateKey")
        self._SSLId = params.get("SSLId")
        self._IsCdn = params.get("IsCdn")
        self._UpstreamScheme = params.get("UpstreamScheme")
        self._HttpsUpstreamPort = params.get("HttpsUpstreamPort")
        self._HttpsRewrite = params.get("HttpsRewrite")
        self._UpstreamType = params.get("UpstreamType")
        self._UpstreamDomain = params.get("UpstreamDomain")
        self._SrcList = params.get("SrcList")
        self._IsHttp2 = params.get("IsHttp2")
        self._IsWebsocket = params.get("IsWebsocket")
        self._LoadBalance = params.get("LoadBalance")
        self._IsGray = params.get("IsGray")
        self._Edition = params.get("Edition")
        if params.get("Ports") is not None:
            self._Ports = []
            for item in params.get("Ports"):
                obj = SpartaProtectionPort()
                obj._deserialize(item)
                self._Ports.append(obj)
        self._IsKeepAlive = params.get("IsKeepAlive")
        self._Anycast = params.get("Anycast")
        self._Weights = params.get("Weights")
        self._ActiveCheck = params.get("ActiveCheck")
        self._TLSVersion = params.get("TLSVersion")
        self._Ciphers = params.get("Ciphers")
        self._CipherTemplate = params.get("CipherTemplate")
        self._ProxyReadTimeout = params.get("ProxyReadTimeout")
        self._ProxySendTimeout = params.get("ProxySendTimeout")
        self._SniType = params.get("SniType")
        self._SniHost = params.get("SniHost")
        self._IpHeaders = params.get("IpHeaders")
        self._XFFReset = params.get("XFFReset")
        self._Note = params.get("Note")
        self._UpstreamHost = params.get("UpstreamHost")
        self._ProxyBuffer = params.get("ProxyBuffer")
        self._ProbeStatus = params.get("ProbeStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifySpartaProtectionResponse(AbstractModel):
    """ModifySpartaProtection response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyUserLevelRequest(AbstractModel):
    """ModifyUserLevel request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _Level: Protection rule level: 300=standard, 400=extended
        :type Level: int
        """
        self._Domain = None
        self._Level = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Level(self):
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Level = params.get("Level")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyUserLevelResponse(AbstractModel):
    """ModifyUserLevel response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyUserSignatureRuleRequest(AbstractModel):
    """ModifyUserSignatureRule request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _MainClassID: Main class ID
        :type MainClassID: str
        :param _Status: Main class switch 0=off, 1=on, 2=alarm only
        :type Status: int
        :param _RuleID: List of rules issued for modification
        :type RuleID: list of ReqUserRule
        """
        self._Domain = None
        self._MainClassID = None
        self._Status = None
        self._RuleID = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def MainClassID(self):
        return self._MainClassID

    @MainClassID.setter
    def MainClassID(self, MainClassID):
        self._MainClassID = MainClassID

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def RuleID(self):
        return self._RuleID

    @RuleID.setter
    def RuleID(self, RuleID):
        self._RuleID = RuleID


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._MainClassID = params.get("MainClassID")
        self._Status = params.get("Status")
        if params.get("RuleID") is not None:
            self._RuleID = []
            for item in params.get("RuleID"):
                obj = ReqUserRule()
                obj._deserialize(item)
                self._RuleID.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyUserSignatureRuleResponse(AbstractModel):
    """ModifyUserSignatureRule response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyWebshellStatusRequest(AbstractModel):
    """ModifyWebshellStatus request structure.

    """

    def __init__(self):
        r"""
        :param _Webshell: Domain Webshell Status
        :type Webshell: :class:`tencentcloud.waf.v20180125.models.WebshellStatus`
        """
        self._Webshell = None

    @property
    def Webshell(self):
        return self._Webshell

    @Webshell.setter
    def Webshell(self, Webshell):
        self._Webshell = Webshell


    def _deserialize(self, params):
        if params.get("Webshell") is not None:
            self._Webshell = WebshellStatus()
            self._Webshell._deserialize(params.get("Webshell"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyWebshellStatusResponse(AbstractModel):
    """ModifyWebshellStatus response structure.

    """

    def __init__(self):
        r"""
        :param _Success: Successful status code, needs JSON decoding before use, the returned format is {Domain:Status}, successful status code is Success, others are failed status codes (YunAPI Defined Error Codes)
        :type Success: :class:`tencentcloud.waf.v20180125.models.ResponseCode`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Success = None
        self._RequestId = None

    @property
    def Success(self):
        return self._Success

    @Success.setter
    def Success(self, Success):
        self._Success = Success

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Success") is not None:
            self._Success = ResponseCode()
            self._Success._deserialize(params.get("Success"))
        self._RequestId = params.get("RequestId")


class PageInfo(AbstractModel):
    """Common paging parameters

    """

    def __init__(self):
        r"""
        :param _PageNumber: Page number
        :type PageNumber: str
        :param _PageSize: Page Entry Quantity
        :type PageSize: str
        """
        self._PageNumber = None
        self._PageSize = None

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PeakPointsItem(AbstractModel):
    """PeakPoints array item

    """

    def __init__(self):
        r"""
        :param _Time: Second-level Timestamp
        :type Time: int
        :param _Access: QPS
        :type Access: int
        :param _Up: Upstream bandwidth peak, unit: B
        :type Up: int
        :param _Down: Downstream bandwidth peak, unit: B
        :type Down: int
        :param _Attack: Web attack count
        :type Attack: int
        :param _Cc: CC attack count
        :type Cc: int
        :param _BotAccess: Bot qps
        :type BotAccess: int
        :param _StatusServerError: Number of 5xx status codes returned by WAF to client

Note: This field may return null, indicating that no valid values can be obtained.
        :type StatusServerError: int
        :param _StatusClientError: Number of times WAF returned 4xx status codes to client

Note: This field may return null, indicating that no valid values can be obtained.
        :type StatusClientError: int
        :param _StatusRedirect: WAF Returned to Client Status Code 302 Count

Note: This field may return null, indicating that no valid values can be obtained.
        :type StatusRedirect: int
        :param _StatusOk: Number of Times WAF Returns Status Code 202 to Client

Note: This field may return null, indicating that no valid values can be obtained.
        :type StatusOk: int
        :param _UpstreamServerError: Number of Times the Origin Server Returned 5xx Status Codes to WAF

Note: This field may return null, indicating that no valid values can be obtained.
        :type UpstreamServerError: int
        :param _UpstreamClientError: Number of times the origin server returned 4xx status codes to WAF

Note: This field may return null, indicating that no valid values can be obtained.
        :type UpstreamClientError: int
        :param _UpstreamRedirect: Number of times the original server returns status code 302 to WAF

Note: This field may return null, indicating that no valid values can be obtained.
        :type UpstreamRedirect: int
        :param _BlackIP: Blocklist Count

Note: This field may return null, indicating that no valid values can be obtained.
        :type BlackIP: int
        :param _Tamper: Tamper-Proof Attempts

Note: This field may return null, indicating that no valid values can be obtained.
        :type Tamper: int
        :param _Leak: Information Leakage Prevention Count

Note: This field may return null, indicating that no valid values can be obtained.
        :type Leak: int
        :param _ACL: Access control
Note: This field may return null, indicating that no valid values can be obtained.
        :type ACL: int
        :param _WxAccess: Mini Program QPS

Note: This field may return null, indicating that no valid values can be obtained.
        :type WxAccess: int
        :param _WxCount: Number of mini program requests
Note: This field may return null, indicating that no valid values can be obtained.
        :type WxCount: int
        :param _WxUp: Peak upstream bandwidth of the mini program. Unit: B
Note: This field may return null, indicating that no valid values can be obtained.
        :type WxUp: int
        :param _WxDown: Peak downstream bandwidth of the mini program. Unit: B
Note: This field may return null, indicating that no valid values can be obtained.
        :type WxDown: int
        """
        self._Time = None
        self._Access = None
        self._Up = None
        self._Down = None
        self._Attack = None
        self._Cc = None
        self._BotAccess = None
        self._StatusServerError = None
        self._StatusClientError = None
        self._StatusRedirect = None
        self._StatusOk = None
        self._UpstreamServerError = None
        self._UpstreamClientError = None
        self._UpstreamRedirect = None
        self._BlackIP = None
        self._Tamper = None
        self._Leak = None
        self._ACL = None
        self._WxAccess = None
        self._WxCount = None
        self._WxUp = None
        self._WxDown = None

    @property
    def Time(self):
        return self._Time

    @Time.setter
    def Time(self, Time):
        self._Time = Time

    @property
    def Access(self):
        return self._Access

    @Access.setter
    def Access(self, Access):
        self._Access = Access

    @property
    def Up(self):
        return self._Up

    @Up.setter
    def Up(self, Up):
        self._Up = Up

    @property
    def Down(self):
        return self._Down

    @Down.setter
    def Down(self, Down):
        self._Down = Down

    @property
    def Attack(self):
        return self._Attack

    @Attack.setter
    def Attack(self, Attack):
        self._Attack = Attack

    @property
    def Cc(self):
        return self._Cc

    @Cc.setter
    def Cc(self, Cc):
        self._Cc = Cc

    @property
    def BotAccess(self):
        return self._BotAccess

    @BotAccess.setter
    def BotAccess(self, BotAccess):
        self._BotAccess = BotAccess

    @property
    def StatusServerError(self):
        return self._StatusServerError

    @StatusServerError.setter
    def StatusServerError(self, StatusServerError):
        self._StatusServerError = StatusServerError

    @property
    def StatusClientError(self):
        return self._StatusClientError

    @StatusClientError.setter
    def StatusClientError(self, StatusClientError):
        self._StatusClientError = StatusClientError

    @property
    def StatusRedirect(self):
        return self._StatusRedirect

    @StatusRedirect.setter
    def StatusRedirect(self, StatusRedirect):
        self._StatusRedirect = StatusRedirect

    @property
    def StatusOk(self):
        return self._StatusOk

    @StatusOk.setter
    def StatusOk(self, StatusOk):
        self._StatusOk = StatusOk

    @property
    def UpstreamServerError(self):
        return self._UpstreamServerError

    @UpstreamServerError.setter
    def UpstreamServerError(self, UpstreamServerError):
        self._UpstreamServerError = UpstreamServerError

    @property
    def UpstreamClientError(self):
        return self._UpstreamClientError

    @UpstreamClientError.setter
    def UpstreamClientError(self, UpstreamClientError):
        self._UpstreamClientError = UpstreamClientError

    @property
    def UpstreamRedirect(self):
        return self._UpstreamRedirect

    @UpstreamRedirect.setter
    def UpstreamRedirect(self, UpstreamRedirect):
        self._UpstreamRedirect = UpstreamRedirect

    @property
    def BlackIP(self):
        return self._BlackIP

    @BlackIP.setter
    def BlackIP(self, BlackIP):
        self._BlackIP = BlackIP

    @property
    def Tamper(self):
        return self._Tamper

    @Tamper.setter
    def Tamper(self, Tamper):
        self._Tamper = Tamper

    @property
    def Leak(self):
        return self._Leak

    @Leak.setter
    def Leak(self, Leak):
        self._Leak = Leak

    @property
    def ACL(self):
        return self._ACL

    @ACL.setter
    def ACL(self, ACL):
        self._ACL = ACL

    @property
    def WxAccess(self):
        return self._WxAccess

    @WxAccess.setter
    def WxAccess(self, WxAccess):
        self._WxAccess = WxAccess

    @property
    def WxCount(self):
        return self._WxCount

    @WxCount.setter
    def WxCount(self, WxCount):
        self._WxCount = WxCount

    @property
    def WxUp(self):
        return self._WxUp

    @WxUp.setter
    def WxUp(self, WxUp):
        self._WxUp = WxUp

    @property
    def WxDown(self):
        return self._WxDown

    @WxDown.setter
    def WxDown(self, WxDown):
        self._WxDown = WxDown


    def _deserialize(self, params):
        self._Time = params.get("Time")
        self._Access = params.get("Access")
        self._Up = params.get("Up")
        self._Down = params.get("Down")
        self._Attack = params.get("Attack")
        self._Cc = params.get("Cc")
        self._BotAccess = params.get("BotAccess")
        self._StatusServerError = params.get("StatusServerError")
        self._StatusClientError = params.get("StatusClientError")
        self._StatusRedirect = params.get("StatusRedirect")
        self._StatusOk = params.get("StatusOk")
        self._UpstreamServerError = params.get("UpstreamServerError")
        self._UpstreamClientError = params.get("UpstreamClientError")
        self._UpstreamRedirect = params.get("UpstreamRedirect")
        self._BlackIP = params.get("BlackIP")
        self._Tamper = params.get("Tamper")
        self._Leak = params.get("Leak")
        self._ACL = params.get("ACL")
        self._WxAccess = params.get("WxAccess")
        self._WxCount = params.get("WxCount")
        self._WxUp = params.get("WxUp")
        self._WxDown = params.get("WxDown")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PiechartItem(AbstractModel):
    """Pie chart data type

    """

    def __init__(self):
        r"""
        :param _Type: Type
        :type Type: str
        :param _Count: Quantity
        :type Count: int
        """
        self._Type = None
        self._Count = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Count(self):
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Count = params.get("Count")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PortInfo(AbstractModel):
    """Service port configuration

    """

    def __init__(self):
        r"""
        :param _NginxServerId: Nginx Server ID
        :type NginxServerId: int
        :param _Port: Listening Port Configuration
        :type Port: str
        :param _Protocol: Protocol Corresponding to the Port
        :type Protocol: str
        :param _UpstreamPort: Origin-pull port
        :type UpstreamPort: str
        :param _UpstreamProtocol: Origin-pull protocol
        :type UpstreamProtocol: str
        """
        self._NginxServerId = None
        self._Port = None
        self._Protocol = None
        self._UpstreamPort = None
        self._UpstreamProtocol = None

    @property
    def NginxServerId(self):
        return self._NginxServerId

    @NginxServerId.setter
    def NginxServerId(self, NginxServerId):
        self._NginxServerId = NginxServerId

    @property
    def Port(self):
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def Protocol(self):
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def UpstreamPort(self):
        return self._UpstreamPort

    @UpstreamPort.setter
    def UpstreamPort(self, UpstreamPort):
        self._UpstreamPort = UpstreamPort

    @property
    def UpstreamProtocol(self):
        return self._UpstreamProtocol

    @UpstreamProtocol.setter
    def UpstreamProtocol(self, UpstreamProtocol):
        self._UpstreamProtocol = UpstreamProtocol


    def _deserialize(self, params):
        self._NginxServerId = params.get("NginxServerId")
        self._Port = params.get("Port")
        self._Protocol = params.get("Protocol")
        self._UpstreamPort = params.get("UpstreamPort")
        self._UpstreamProtocol = params.get("UpstreamProtocol")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PortItem(AbstractModel):
    """Protection domain port configuration information

    """

    def __init__(self):
        r"""
        :param _Port: Listening Port Configuration
        :type Port: str
        :param _Protocol: Corresponds one-to-one with ports, indicating the protocol associated with the port.
        :type Protocol: str
        :param _UpstreamPort: Corresponds one-to-one with port, indicates the origin port
        :type UpstreamPort: str
        :param _UpstreamProtocol: Corresponds one-to-one with Port, indicating the origin protocol
        :type UpstreamProtocol: str
        :param _NginxServerId: Nginx Server ID
        :type NginxServerId: str
        """
        self._Port = None
        self._Protocol = None
        self._UpstreamPort = None
        self._UpstreamProtocol = None
        self._NginxServerId = None

    @property
    def Port(self):
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def Protocol(self):
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def UpstreamPort(self):
        return self._UpstreamPort

    @UpstreamPort.setter
    def UpstreamPort(self, UpstreamPort):
        self._UpstreamPort = UpstreamPort

    @property
    def UpstreamProtocol(self):
        return self._UpstreamProtocol

    @UpstreamProtocol.setter
    def UpstreamProtocol(self, UpstreamProtocol):
        self._UpstreamProtocol = UpstreamProtocol

    @property
    def NginxServerId(self):
        return self._NginxServerId

    @NginxServerId.setter
    def NginxServerId(self, NginxServerId):
        self._NginxServerId = NginxServerId


    def _deserialize(self, params):
        self._Port = params.get("Port")
        self._Protocol = params.get("Protocol")
        self._UpstreamPort = params.get("UpstreamPort")
        self._UpstreamProtocol = params.get("UpstreamProtocol")
        self._NginxServerId = params.get("NginxServerId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class QPSPackageNew(AbstractModel):
    """CLB-WAF QPS package new

    """

    def __init__(self):
        r"""
        :param _ResourceIds: Resource ID

Note: This field may return null, indicating that no valid values can be obtained.
        :type ResourceIds: str
        :param _ValidTime: Expiration time

Note: This field may return null, indicating that no valid values can be obtained.
        :type ValidTime: str
        :param _RenewFlag: Auto-renewal, 1: Enabled, 0: Disabled

Note: This field may return null, indicating that no valid values can be obtained.
        :type RenewFlag: int
        :param _Count: Number of Package Purchases

Note: This field may return null, indicating that no valid values can be obtained.
        :type Count: int
        :param _Region: Package Purchase Region, currently not used in CLB-WAF

Note: This field may return null, indicating that no valid values can be obtained.
        :type Region: str
        :param _BillingItem: Billing item.
Note: This field may return null, indicating that no valid values can be obtained.
        :type BillingItem: str
        """
        self._ResourceIds = None
        self._ValidTime = None
        self._RenewFlag = None
        self._Count = None
        self._Region = None
        self._BillingItem = None

    @property
    def ResourceIds(self):
        return self._ResourceIds

    @ResourceIds.setter
    def ResourceIds(self, ResourceIds):
        self._ResourceIds = ResourceIds

    @property
    def ValidTime(self):
        return self._ValidTime

    @ValidTime.setter
    def ValidTime(self, ValidTime):
        self._ValidTime = ValidTime

    @property
    def RenewFlag(self):
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag

    @property
    def Count(self):
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def BillingItem(self):
        return self._BillingItem

    @BillingItem.setter
    def BillingItem(self, BillingItem):
        self._BillingItem = BillingItem


    def _deserialize(self, params):
        self._ResourceIds = params.get("ResourceIds")
        self._ValidTime = params.get("ValidTime")
        self._RenewFlag = params.get("RenewFlag")
        self._Count = params.get("Count")
        self._Region = params.get("Region")
        self._BillingItem = params.get("BillingItem")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class QpsData(AbstractModel):
    """Obtain the default value for elastic QPS

    """

    def __init__(self):
        r"""
        :param _ElasticBillingDefault: Elastic QPS Default Value

Note: This field may return null, indicating that no valid values can be obtained.
        :type ElasticBillingDefault: int
        :param _ElasticBillingMin: Elastic QPS Minimum Value

Note: This field may return null, indicating that no valid values can be obtained.
        :type ElasticBillingMin: int
        :param _ElasticBillingMax: Maximum Elastic QPS

Note: This field may return null, indicating that no valid values can be obtained.
        :type ElasticBillingMax: int
        :param _QPSExtendMax: Maximum QPS for Business Expansion Package

Note: This field may return null, indicating that no valid values can be obtained.
        :type QPSExtendMax: int
        :param _QPSExtendIntlMax: Maximum QPS for Overseas Business Expansion Package

Note: This field may return null, indicating that no valid values can be obtained.
        :type QPSExtendIntlMax: int
        """
        self._ElasticBillingDefault = None
        self._ElasticBillingMin = None
        self._ElasticBillingMax = None
        self._QPSExtendMax = None
        self._QPSExtendIntlMax = None

    @property
    def ElasticBillingDefault(self):
        return self._ElasticBillingDefault

    @ElasticBillingDefault.setter
    def ElasticBillingDefault(self, ElasticBillingDefault):
        self._ElasticBillingDefault = ElasticBillingDefault

    @property
    def ElasticBillingMin(self):
        return self._ElasticBillingMin

    @ElasticBillingMin.setter
    def ElasticBillingMin(self, ElasticBillingMin):
        self._ElasticBillingMin = ElasticBillingMin

    @property
    def ElasticBillingMax(self):
        return self._ElasticBillingMax

    @ElasticBillingMax.setter
    def ElasticBillingMax(self, ElasticBillingMax):
        self._ElasticBillingMax = ElasticBillingMax

    @property
    def QPSExtendMax(self):
        return self._QPSExtendMax

    @QPSExtendMax.setter
    def QPSExtendMax(self, QPSExtendMax):
        self._QPSExtendMax = QPSExtendMax

    @property
    def QPSExtendIntlMax(self):
        return self._QPSExtendIntlMax

    @QPSExtendIntlMax.setter
    def QPSExtendIntlMax(self, QPSExtendIntlMax):
        self._QPSExtendIntlMax = QPSExtendIntlMax


    def _deserialize(self, params):
        self._ElasticBillingDefault = params.get("ElasticBillingDefault")
        self._ElasticBillingMin = params.get("ElasticBillingMin")
        self._ElasticBillingMax = params.get("ElasticBillingMax")
        self._QPSExtendMax = params.get("QPSExtendMax")
        self._QPSExtendIntlMax = params.get("QPSExtendIntlMax")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RefreshAccessCheckResultRequest(AbstractModel):
    """RefreshAccessCheckResult request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        """
        self._Domain = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RefreshAccessCheckResultResponse(AbstractModel):
    """RefreshAccessCheckResult response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ReqUserRule(AbstractModel):
    """User Rule Update Output Rule Subitem

    """

    def __init__(self):
        r"""
        :param _Id: Feature serial number
        :type Id: str
        :param _Status: Rule switch
0: disabled
1: enabled
2: alarm only
        :type Status: int
        :param _Reason: Reason for modification

0: none (Compatibility records are empty.)
1: avoidance of false positives due to business characteristics
2: reporting of rule-based false positives
3: grayscale release of core business rules
4: others
        :type Reason: int
        """
        self._Id = None
        self._Status = None
        self._Reason = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Reason(self):
        return self._Reason

    @Reason.setter
    def Reason(self, Reason):
        self._Reason = Reason


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Status = params.get("Status")
        self._Reason = params.get("Reason")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ResponseCode(AbstractModel):
    """Return code of the response body

    """

    def __init__(self):
        r"""
        :param _Code: If successful, return a success; if failed, return Cloud API Defined Error Codes
        :type Code: str
        :param _Message: If successful, return a success; if failed, return the secondary error code of WAF Definition
        :type Message: str
        """
        self._Code = None
        self._Message = None

    @property
    def Code(self):
        return self._Code

    @Code.setter
    def Code(self, Code):
        self._Code = Code

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message


    def _deserialize(self, params):
        self._Code = params.get("Code")
        self._Message = params.get("Message")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SearchItem(AbstractModel):
    """Complex Conditions on Access List Query

    """

    def __init__(self):
        r"""
        :param _ClsStatus: Log switch
        :type ClsStatus: str
        :param _Status: WAF Switch
        :type Status: str
        :param _FlowMode: Traffic mode
        :type FlowMode: str
        """
        self._ClsStatus = None
        self._Status = None
        self._FlowMode = None

    @property
    def ClsStatus(self):
        return self._ClsStatus

    @ClsStatus.setter
    def ClsStatus(self, ClsStatus):
        self._ClsStatus = ClsStatus

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def FlowMode(self):
        return self._FlowMode

    @FlowMode.setter
    def FlowMode(self, FlowMode):
        self._FlowMode = FlowMode


    def _deserialize(self, params):
        self._ClsStatus = params.get("ClsStatus")
        self._Status = params.get("Status")
        self._FlowMode = params.get("FlowMode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SessionData(AbstractModel):
    """Parameter Wrapping

    """

    def __init__(self):
        r"""
        :param _Res: Session definition
        :type Res: list of SessionItem
        """
        self._Res = None

    @property
    def Res(self):
        return self._Res

    @Res.setter
    def Res(self, Res):
        self._Res = Res


    def _deserialize(self, params):
        if params.get("Res") is not None:
            self._Res = []
            for item in params.get("Res"):
                obj = SessionItem()
                obj._deserialize(item)
                self._Res.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SessionItem(AbstractModel):
    """Session definition

    """

    def __init__(self):
        r"""
        :param _Category: Type to match
        :type Category: str
        :param _KeyOrStartMat: Start Mode
        :type KeyOrStartMat: str
        :param _EndMat: End Mode
        :type EndMat: str
        :param _StartOffset: Starting Offset
        :type StartOffset: str
        :param _EndOffset: End Offset
        :type EndOffset: str
        :param _Source: Data source
        :type Source: str
        :param _TsVersion: Update Timestamp
        :type TsVersion: str
        :param _SessionId: SessionID
Note: This field may return null, indicating that no valid values can be obtained.
        :type SessionId: int
        :param _SessionName: Session Name

Note: This field may return null, indicating that no valid values can be obtained.
        :type SessionName: str
        :param _SessionInUsed: Whether the session is being enabled

Note: This field may return null, indicating that no valid values can be obtained.
        :type SessionInUsed: bool
        :param _RelatedRuleID: Session-related CC Rule ID

Note: This field may return null, indicating that no valid values can be obtained.
        :type RelatedRuleID: list of int
        """
        self._Category = None
        self._KeyOrStartMat = None
        self._EndMat = None
        self._StartOffset = None
        self._EndOffset = None
        self._Source = None
        self._TsVersion = None
        self._SessionId = None
        self._SessionName = None
        self._SessionInUsed = None
        self._RelatedRuleID = None

    @property
    def Category(self):
        return self._Category

    @Category.setter
    def Category(self, Category):
        self._Category = Category

    @property
    def KeyOrStartMat(self):
        return self._KeyOrStartMat

    @KeyOrStartMat.setter
    def KeyOrStartMat(self, KeyOrStartMat):
        self._KeyOrStartMat = KeyOrStartMat

    @property
    def EndMat(self):
        return self._EndMat

    @EndMat.setter
    def EndMat(self, EndMat):
        self._EndMat = EndMat

    @property
    def StartOffset(self):
        return self._StartOffset

    @StartOffset.setter
    def StartOffset(self, StartOffset):
        self._StartOffset = StartOffset

    @property
    def EndOffset(self):
        return self._EndOffset

    @EndOffset.setter
    def EndOffset(self, EndOffset):
        self._EndOffset = EndOffset

    @property
    def Source(self):
        return self._Source

    @Source.setter
    def Source(self, Source):
        self._Source = Source

    @property
    def TsVersion(self):
        return self._TsVersion

    @TsVersion.setter
    def TsVersion(self, TsVersion):
        self._TsVersion = TsVersion

    @property
    def SessionId(self):
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def SessionName(self):
        return self._SessionName

    @SessionName.setter
    def SessionName(self, SessionName):
        self._SessionName = SessionName

    @property
    def SessionInUsed(self):
        return self._SessionInUsed

    @SessionInUsed.setter
    def SessionInUsed(self, SessionInUsed):
        self._SessionInUsed = SessionInUsed

    @property
    def RelatedRuleID(self):
        return self._RelatedRuleID

    @RelatedRuleID.setter
    def RelatedRuleID(self, RelatedRuleID):
        self._RelatedRuleID = RelatedRuleID


    def _deserialize(self, params):
        self._Category = params.get("Category")
        self._KeyOrStartMat = params.get("KeyOrStartMat")
        self._EndMat = params.get("EndMat")
        self._StartOffset = params.get("StartOffset")
        self._EndOffset = params.get("EndOffset")
        self._Source = params.get("Source")
        self._TsVersion = params.get("TsVersion")
        self._SessionId = params.get("SessionId")
        self._SessionName = params.get("SessionName")
        self._SessionInUsed = params.get("SessionInUsed")
        self._RelatedRuleID = params.get("RelatedRuleID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SpartaProtectionPort(AbstractModel):
    """WAF Sparta - Edit port structure in the protection domain

    """

    def __init__(self):
        r"""
        :param _NginxServerId: nginx Id
        :type NginxServerId: int
        :param _Port: Port
        :type Port: str
        :param _Protocol: Protocol
        :type Protocol: str
        :param _UpstreamPort: Backend port
        :type UpstreamPort: str
        :param _UpstreamProtocol: Backend protocol
        :type UpstreamProtocol: str
        """
        self._NginxServerId = None
        self._Port = None
        self._Protocol = None
        self._UpstreamPort = None
        self._UpstreamProtocol = None

    @property
    def NginxServerId(self):
        return self._NginxServerId

    @NginxServerId.setter
    def NginxServerId(self, NginxServerId):
        self._NginxServerId = NginxServerId

    @property
    def Port(self):
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def Protocol(self):
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def UpstreamPort(self):
        return self._UpstreamPort

    @UpstreamPort.setter
    def UpstreamPort(self, UpstreamPort):
        self._UpstreamPort = UpstreamPort

    @property
    def UpstreamProtocol(self):
        return self._UpstreamProtocol

    @UpstreamProtocol.setter
    def UpstreamProtocol(self, UpstreamProtocol):
        self._UpstreamProtocol = UpstreamProtocol


    def _deserialize(self, params):
        self._NginxServerId = params.get("NginxServerId")
        self._Port = params.get("Port")
        self._Protocol = params.get("Protocol")
        self._UpstreamPort = params.get("UpstreamPort")
        self._UpstreamProtocol = params.get("UpstreamProtocol")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Strategy(AbstractModel):
    """Matching criteria structure for custom rules

    """

    def __init__(self):
        r"""
        :param _Field: Matching field

    Different matching fields result in different matching parameters, logical operators, and matching contents. The details are as follows:
<table><thead><tr><th>Matching Field</th> <th>Matching Parameter</th> <th>Logical Symbol</th> <th>Matching Content</th></tr></thead> <tbody><tr><td>IP (source IP)</td> <td>Parameters are not supported.</td> <td>ipmatch (match)<br/>ipnmatch (mismatch)</td> <td>Multiple IP addresses are separated by commas. A maximum of 20 IP addresses are allowed.</td></tr> <tr><td>IPv6 (source IPv6)</td> <td>Parameters are not supported.</td> <td>ipmatch (match)<br/>ipnmatch (mismatch)</td> <td>A single IPv6 address is supported.</td></tr> <tr><td>Referer (referer)</td> <td>Parameters are not supported.</td> <td>empty (Content is empty.)<br/>null (do not exist)<br/>eq (equal to)<br/>neq (not equal to)<br/>contains (contain)<br/>ncontains (do not contain)<br/>len_eq (length equals to)<br/>len_gt (length is greater than)<br/>len_lt (length is less than)<br/>strprefix (prefix matching)<br/>strsuffix (suffix matching)<br/>rematch (regular expression matching)</td> <td>Enter the content, with a maximum of 512 characters.</td></tr> <tr><td>URL (request path)</td> <td>Parameters are not supported.</td> <td>eq (equal to)<br/>neq (not equal to)<br/>contains (contain)<br/>ncontains (do not contain)<br/>len_eq (length equals to)<br/>len_gt (length is greater than)<br/>len_lt (length is 
 less than)<br/>strprefix (prefix matching)<br/>strsuffix (suffix matching)<br/>rematch (regular expression matching)</td> <td>Enter the content starting with /, with a maximum of 512 characters.</td></tr> <tr><td>UserAgent (UserAgent)</td> <td>Parameters are not supported.</td><td>Same logical symbols as the matching field <font color="Red">Referer</font></td> <td>Enter the content with a maximum of 512 characters.</td></tr> <tr><td>HTTP_METHOD (HTTP request method)</td> <td>Parameters are not supported.</td> <td>eq (equal to)<br/>neq (not equal to)</td> <td>Enter the method name. The uppercase is recommended.</td></tr> <tr><td>QUERY_STRING (request string)</td> <td>Parameters are not supported.</td> <td>Same logical symbol as the matching field <font color="Red">Request Path</font></td><td>Enter the content with a maximum of 512 characters.</td></tr> <tr><td>GET (GET parameter value)</td> <td>Parameter entry is supported.</td> <td>contains (contain)<br/>ncontains (do not contain)<br/>len_eq (length equals to)<br/>len_gt (length is greater than)<br/>len_lt (length is less than)<br/>strprefix (prefix matching)<br/>strsuffix (suffix matching)</td> <td>Enter the content with a maximum of 512 characters.</td></tr> <tr><td>GET_PARAMS_NAMES (GET parameter name)</td> <td>Parameters are not supported.</td> <td>exist (Parameter exists.)<br/>nexist (Parameter does not exist.)<br/>len_eq (length equals to)<br/>len_gt (length is greater than)<br/>len_lt (length is less than)<br/>strprefix (prefix matching)<br/>strsuffix (suffix matching)</td><td>Enter the content with a maximum of 512 characters.</td></tr> <tr><td>POST (POST parameter value)</td> <td>Parameter entry is supported.</td> <td>Same logical symbol as the matching field <font color="Red">GET Parameter Value</font></td> <td>Enter the content with a maximum of 512 characters.</td></tr> <tr><td>GET_POST_NAMES (POST parameter name)</td> <td>Parameters are not supported.</td> <td>Same logical symbol as the matching field <font color="Red">GET Parameter Name</font></td> <td>Enter the content with a maximum of 512 characters.</td></tr> <tr><td>POST_BODY (complete body)</td> <td>Parameters are not supported.</td> <td>Same logical symbol as the matching field <font color="Red">Request Path</font></td><td>Enter the body content with a maximum of 512 characters.</td></tr> <tr><td>COOKIE (cookie)</td> <td>Parameters are not supported.</td> <td>empty (Content is empty.)<br/>null (do not exist)<br/>rematch (regular expression matching)</td> <td><font color="Red">Unsupported currently</font></td></tr> <tr><td>GET_COOKIES_NAMES (cookie parameter name)</td> <td>Parameters are not supported.</td> <td>Same logical symbol as the matching field <font color="Red">GET Parameter Name</font></td> <td>Enter the content with a maximum of 512 characters.</td></tr> <tr><td>ARGS_COOKIE (cookie parameter value)</td> <td>Parameter entry is supported.</td> <td>Same logical symbol as the matching field <font color="Red">GET Parameter Value</font></td> <td>Enter the contentwith a maximum of 512 characters.</td></tr> <tr><td>GET_HEADERS_NAMES (header parameter name)</td> <td>Parameters are not supported.</td> <td>exist (Parameter exists.)<br/>nexist (Parameter does not exist.)<br/>len_eq (length equals to)<br/>len_gt (length is greater than)<br/>len_lt (length is less than)<br/>strprefix (prefix matching)<br/>strsuffix (suffix matching)<br/>rematch (regular expression matching)</td> <td>Enter the content with a maximum of 512 characters. The lowercase is recommended.</td> </tr><tr><td>ARGS_HEADER (header parameter value)</td> <td>Parameter entry is supported.</td> <td>contains (contain)<br/>ncontains (do not contain)<br/>len_eq (length equals to)<br/>len_gt (length is greater than)<br/>len_lt (length is less than)<br/>strprefix (prefix matching)<br/>strsuffix (suffix matching)<br/>rematch (regular expression matching)</td> <td>Enter the content with a maximum of 512 characters.</td></tr></tbody></table>
Note: This field may return null, indicating that no valid values can be obtained.
        :type Field: str
        :param _CompareFunc: Logic symbol

    Logical symbols are divided into the following types:
        empty (content is empty)
        null (do not exist)
        eq (equal to)
        neq (not equal to)
        contains (contain)
        ncontains (do not contain)
        strprefix (prefix matching)
        strsuffix (suffix matching)
        len_eq (length equals to)
        len_gt (length is greater than)
        len_lt (length is less than)
        ipmatch (belong to)
        ipnmatch (do not belong to)
    Different matching fields correspond to different logical operators. For details, see the matching field table above.

Note: This field may return null, indicating that no valid values can be obtained.
        :type CompareFunc: str
        :param _Content: Matching content

    Currently, when the matching field is COOKIE (cookie), the matching content  is not required. In other scenes, the matching content is required.

Note: This field may return null, indicating that no valid values can be obtained.
        :type Content: str
        :param _Arg: Matching parameter

    There are two types of configuration parameters: unsupported parameters and supported parameters.
    The matching parameter can be entered only when the matching field is one of the following four. Otherwise, the parameter is not supported.
        GET (GET parameter value)		
        POST (POST parameter value)		
        ARGS_COOKIE (Cookie parameter value)		
        ARGS_HEADER (Header parameter value)

Note: This field may return null, indicating that no valid values can be obtained.
        :type Arg: str
        """
        self._Field = None
        self._CompareFunc = None
        self._Content = None
        self._Arg = None

    @property
    def Field(self):
        return self._Field

    @Field.setter
    def Field(self, Field):
        self._Field = Field

    @property
    def CompareFunc(self):
        return self._CompareFunc

    @CompareFunc.setter
    def CompareFunc(self, CompareFunc):
        self._CompareFunc = CompareFunc

    @property
    def Content(self):
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content

    @property
    def Arg(self):
        return self._Arg

    @Arg.setter
    def Arg(self, Arg):
        self._Arg = Arg


    def _deserialize(self, params):
        self._Field = params.get("Field")
        self._CompareFunc = params.get("CompareFunc")
        self._Content = params.get("Content")
        self._Arg = params.get("Arg")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class StrategyForAntiInfoLeak(AbstractModel):
    """Matching criteria structure for preventing information leakage

    """

    def __init__(self):
        r"""
        :param _Field: Matching Criteria, returncode (Response Code), keywords (Keywords), information (Sensitive Information)
        :type Field: str
        :param _CompareFunc: Logical operator, fixed value: contains
        :type CompareFunc: str
        :param _Content: Matching content
The following options are available when Field is set to information:
idcard (ID card), phone (phone number), and bankcard (bank card).
The following options are available when Field is set to returncode:
400 (status code 400), 403 (status code 403), 404 (status code 404), 4xx (other 4xx status codes), 500 (status code 500), 501 (status code 501), 502 (status code 502), 504 (status code 504), and 5xx (other 5xx status codes).
When Field is set to keywords, users need to input the matching content themselves.

        :type Content: str
        """
        self._Field = None
        self._CompareFunc = None
        self._Content = None

    @property
    def Field(self):
        return self._Field

    @Field.setter
    def Field(self, Field):
        self._Field = Field

    @property
    def CompareFunc(self):
        return self._CompareFunc

    @CompareFunc.setter
    def CompareFunc(self, CompareFunc):
        self._CompareFunc = CompareFunc

    @property
    def Content(self):
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content


    def _deserialize(self, params):
        self._Field = params.get("Field")
        self._CompareFunc = params.get("CompareFunc")
        self._Content = params.get("Content")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SwitchElasticModeRequest(AbstractModel):
    """SwitchElasticMode request structure.

    """

    def __init__(self):
        r"""
        :param _Edition: Version, can only be sparta-waf, clb-waf, or cdn-waf
        :type Edition: str
        :param _Mode: 0 indicates Off; 1 indicates On
        :type Mode: int
        :param _InstanceID: Instance ID
        :type InstanceID: str
        """
        self._Edition = None
        self._Mode = None
        self._InstanceID = None

    @property
    def Edition(self):
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def Mode(self):
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def InstanceID(self):
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID


    def _deserialize(self, params):
        self._Edition = params.get("Edition")
        self._Mode = params.get("Mode")
        self._InstanceID = params.get("InstanceID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SwitchElasticModeResponse(AbstractModel):
    """SwitchElasticMode response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class TLSCiphers(AbstractModel):
    """TLS encryption suite

    """

    def __init__(self):
        r"""
        :param _VersionId: TLS version ID

Note: This field may return null, indicating that no valid values can be obtained.
        :type VersionId: int
        :param _CipherId: Encryption Suite ID

Note: This field may return null, indicating that no valid values can be obtained.
        :type CipherId: int
        :param _CipherName: Cipher suite
Note: This field may return null, indicating that no valid values can be obtained.
        :type CipherName: str
        """
        self._VersionId = None
        self._CipherId = None
        self._CipherName = None

    @property
    def VersionId(self):
        return self._VersionId

    @VersionId.setter
    def VersionId(self, VersionId):
        self._VersionId = VersionId

    @property
    def CipherId(self):
        return self._CipherId

    @CipherId.setter
    def CipherId(self, CipherId):
        self._CipherId = CipherId

    @property
    def CipherName(self):
        return self._CipherName

    @CipherName.setter
    def CipherName(self, CipherName):
        self._CipherName = CipherName


    def _deserialize(self, params):
        self._VersionId = params.get("VersionId")
        self._CipherId = params.get("CipherId")
        self._CipherName = params.get("CipherName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class TLSVersion(AbstractModel):
    """TLS information

    """

    def __init__(self):
        r"""
        :param _VersionId: ID of TLSVERSION

Note: This field may return null, indicating that no valid values can be obtained.
        :type VersionId: int
        :param _VersionName: TLSVERSION's Name

Note: This field may return null, indicating that no valid values can be obtained.
        :type VersionName: str
        """
        self._VersionId = None
        self._VersionName = None

    @property
    def VersionId(self):
        return self._VersionId

    @VersionId.setter
    def VersionId(self, VersionId):
        self._VersionId = VersionId

    @property
    def VersionName(self):
        return self._VersionName

    @VersionName.setter
    def VersionName(self, VersionName):
        self._VersionName = VersionName


    def _deserialize(self, params):
        self._VersionId = params.get("VersionId")
        self._VersionName = params.get("VersionName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class TargetEntity(AbstractModel):
    """Entity combining instance + domain that requires enabling/disabling API security

    """

    def __init__(self):
        r"""
        :param _InstanceId: Instance ID
        :type InstanceId: str
        :param _Domain: Domain name
        :type Domain: str
        """
        self._InstanceId = None
        self._Domain = None

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Domain = params.get("Domain")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class TimedJob(AbstractModel):
    """Rule-based scheduled task data structure

    """

    def __init__(self):
        r"""
        :param _StartDateTime: Start timestamp, in seconds
Note: This field may return null, indicating that no valid values can be obtained.
        :type StartDateTime: int
        :param _EndDateTime: End timestamp, in seconds
Note: This field may return null, indicating that no valid values can be obtained.
        :type EndDateTime: int
        """
        self._StartDateTime = None
        self._EndDateTime = None

    @property
    def StartDateTime(self):
        return self._StartDateTime

    @StartDateTime.setter
    def StartDateTime(self, StartDateTime):
        self._StartDateTime = StartDateTime

    @property
    def EndDateTime(self):
        return self._EndDateTime

    @EndDateTime.setter
    def EndDateTime(self, EndDateTime):
        self._EndDateTime = EndDateTime


    def _deserialize(self, params):
        self._StartDateTime = params.get("StartDateTime")
        self._EndDateTime = params.get("EndDateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UpsertCCRuleRequest(AbstractModel):
    """UpsertCCRule request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _Name: Name
        :type Name: str
        :param _Status: Status
        :type Status: int
        :param _Advance: Advanced mode (whether to use session detection). 0: disabled; 1: enabled
        :type Advance: str
        :param _Limit: CC detection threshold
        :type Limit: str
        :param _Interval: CC detection cycle
        :type Interval: str
        :param _Url: Detection URL
        :type Url: str
        :param _MatchFunc: Matching method. 0: equal to; 1: prefix matching; 2: included
        :type MatchFunc: int
        :param _ActionType: Action. 20: observation; 21: CAPTCHA; 22: interception; 23: precise interception
        :type ActionType: str
        :param _Priority: Priority
        :type Priority: int
        :param _ValidTime: Valid time for action
        :type ValidTime: int
        :param _OptionsArr: Additional Parameters
        :type OptionsArr: str
        :param _Edition: WAF version. The value can be sparta-waf or clb-waf.
        :type Edition: str
        :param _Type: Operation type
        :type Type: int
        :param _EventId: Source event ID for adding rules
        :type EventId: str
        :param _SessionApplied: Session ID that needs to be enabled for the rule
        :type SessionApplied: list of int
        :param _RuleId: Rule ID: fill in 0 when adding
        :type RuleId: int
        :param _CreateTime: Rule creation time
        :type CreateTime: int
        :param _Length: URL length
        :type Length: int
        """
        self._Domain = None
        self._Name = None
        self._Status = None
        self._Advance = None
        self._Limit = None
        self._Interval = None
        self._Url = None
        self._MatchFunc = None
        self._ActionType = None
        self._Priority = None
        self._ValidTime = None
        self._OptionsArr = None
        self._Edition = None
        self._Type = None
        self._EventId = None
        self._SessionApplied = None
        self._RuleId = None
        self._CreateTime = None
        self._Length = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Advance(self):
        return self._Advance

    @Advance.setter
    def Advance(self, Advance):
        self._Advance = Advance

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Interval(self):
        return self._Interval

    @Interval.setter
    def Interval(self, Interval):
        self._Interval = Interval

    @property
    def Url(self):
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def MatchFunc(self):
        return self._MatchFunc

    @MatchFunc.setter
    def MatchFunc(self, MatchFunc):
        self._MatchFunc = MatchFunc

    @property
    def ActionType(self):
        return self._ActionType

    @ActionType.setter
    def ActionType(self, ActionType):
        self._ActionType = ActionType

    @property
    def Priority(self):
        return self._Priority

    @Priority.setter
    def Priority(self, Priority):
        self._Priority = Priority

    @property
    def ValidTime(self):
        return self._ValidTime

    @ValidTime.setter
    def ValidTime(self, ValidTime):
        self._ValidTime = ValidTime

    @property
    def OptionsArr(self):
        return self._OptionsArr

    @OptionsArr.setter
    def OptionsArr(self, OptionsArr):
        self._OptionsArr = OptionsArr

    @property
    def Edition(self):
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def EventId(self):
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId

    @property
    def SessionApplied(self):
        return self._SessionApplied

    @SessionApplied.setter
    def SessionApplied(self, SessionApplied):
        self._SessionApplied = SessionApplied

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def Length(self):
        return self._Length

    @Length.setter
    def Length(self, Length):
        self._Length = Length


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Name = params.get("Name")
        self._Status = params.get("Status")
        self._Advance = params.get("Advance")
        self._Limit = params.get("Limit")
        self._Interval = params.get("Interval")
        self._Url = params.get("Url")
        self._MatchFunc = params.get("MatchFunc")
        self._ActionType = params.get("ActionType")
        self._Priority = params.get("Priority")
        self._ValidTime = params.get("ValidTime")
        self._OptionsArr = params.get("OptionsArr")
        self._Edition = params.get("Edition")
        self._Type = params.get("Type")
        self._EventId = params.get("EventId")
        self._SessionApplied = params.get("SessionApplied")
        self._RuleId = params.get("RuleId")
        self._CreateTime = params.get("CreateTime")
        self._Length = params.get("Length")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UpsertCCRuleResponse(AbstractModel):
    """UpsertCCRule response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Normally null

Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: str
        :param _RuleId: Operated RuleId
        :type RuleId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RuleId = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RuleId = params.get("RuleId")
        self._RequestId = params.get("RequestId")


class UpsertSessionRequest(AbstractModel):
    """UpsertSession request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _Source: Session source location
        :type Source: str
        :param _Category: Extraction category
        :type Category: str
        :param _KeyOrStartMat: Extract key or initial match mode
        :type KeyOrStartMat: str
        :param _EndMat: End match mode
        :type EndMat: str
        :param _StartOffset: Start offset position
        :type StartOffset: str
        :param _EndOffset: End offset position
        :type EndOffset: str
        :param _Edition: Version
        :type Edition: str
        :param _SessionName: Session Name
        :type SessionName: str
        :param _SessionID: ID corresponding to session
        :type SessionID: int
        """
        self._Domain = None
        self._Source = None
        self._Category = None
        self._KeyOrStartMat = None
        self._EndMat = None
        self._StartOffset = None
        self._EndOffset = None
        self._Edition = None
        self._SessionName = None
        self._SessionID = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Source(self):
        return self._Source

    @Source.setter
    def Source(self, Source):
        self._Source = Source

    @property
    def Category(self):
        return self._Category

    @Category.setter
    def Category(self, Category):
        self._Category = Category

    @property
    def KeyOrStartMat(self):
        return self._KeyOrStartMat

    @KeyOrStartMat.setter
    def KeyOrStartMat(self, KeyOrStartMat):
        self._KeyOrStartMat = KeyOrStartMat

    @property
    def EndMat(self):
        return self._EndMat

    @EndMat.setter
    def EndMat(self, EndMat):
        self._EndMat = EndMat

    @property
    def StartOffset(self):
        return self._StartOffset

    @StartOffset.setter
    def StartOffset(self, StartOffset):
        self._StartOffset = StartOffset

    @property
    def EndOffset(self):
        return self._EndOffset

    @EndOffset.setter
    def EndOffset(self, EndOffset):
        self._EndOffset = EndOffset

    @property
    def Edition(self):
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def SessionName(self):
        return self._SessionName

    @SessionName.setter
    def SessionName(self, SessionName):
        self._SessionName = SessionName

    @property
    def SessionID(self):
        return self._SessionID

    @SessionID.setter
    def SessionID(self, SessionID):
        self._SessionID = SessionID


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Source = params.get("Source")
        self._Category = params.get("Category")
        self._KeyOrStartMat = params.get("KeyOrStartMat")
        self._EndMat = params.get("EndMat")
        self._StartOffset = params.get("StartOffset")
        self._EndOffset = params.get("EndOffset")
        self._Edition = params.get("Edition")
        self._SessionName = params.get("SessionName")
        self._SessionID = params.get("SessionID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UpsertSessionResponse(AbstractModel):
    """UpsertSession response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Result
Note: This field may return null, indicating that no valid values can be obtained.
        :type Data: str
        :param _SessionID: SessionID
Note: This field may return null, indicating that no valid values can be obtained.
        :type SessionID: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._SessionID = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def SessionID(self):
        return self._SessionID

    @SessionID.setter
    def SessionID(self, SessionID):
        self._SessionID = SessionID

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._SessionID = params.get("SessionID")
        self._RequestId = params.get("RequestId")


class UserDomainInfo(AbstractModel):
    """SaaS and CLB information

    """

    def __init__(self):
        r"""
        :param _Appid: User ID
        :type Appid: int
        :param _Domain: Domain name
        :type Domain: str
        :param _DomainId: Domain ID
        :type DomainId: str
        :param _InstanceId: Instance ID
        :type InstanceId: str
        :param _InstanceName: Instance name
        :type InstanceName: str
        :param _Edition: WAF type
        :type Edition: str
        :param _Level: Version

Note: This field may return null, indicating that no valid values can be obtained.
        :type Level: str
        :param _WriteConfig: Switch for Specified Domain Access Log Fields

Note: This field may return null, indicating that no valid values can be obtained.
        :type WriteConfig: str
        :param _Cls: Whether to Write the CLS Switch for the Specified Domain 1: Yes, 0: No

Note: This field may return null, indicating that no valid values can be obtained.
        :type Cls: int
        :param _CloudType: Marks if it is hybrid cloud access. Hybrid indicates a hybrid cloud access domain

Note: This field may return null, indicating that no valid values can be obtained.
        :type CloudType: str
        :param _AlbType: CLB WAF type
Note: This field may return null, indicating that no valid values can be obtained.
        :type AlbType: str
        :param _BotStatus: Bot detection enabling status
Note: This field may return null, indicating that no valid values can be obtained.
        :type BotStatus: int
        :param _ApiStatus: API enabling status
Note: This field may return null, indicating that no valid values can be obtained.
        :type ApiStatus: int
        """
        self._Appid = None
        self._Domain = None
        self._DomainId = None
        self._InstanceId = None
        self._InstanceName = None
        self._Edition = None
        self._Level = None
        self._WriteConfig = None
        self._Cls = None
        self._CloudType = None
        self._AlbType = None
        self._BotStatus = None
        self._ApiStatus = None

    @property
    def Appid(self):
        return self._Appid

    @Appid.setter
    def Appid(self, Appid):
        self._Appid = Appid

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def DomainId(self):
        return self._DomainId

    @DomainId.setter
    def DomainId(self, DomainId):
        self._DomainId = DomainId

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def InstanceName(self):
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def Edition(self):
        return self._Edition

    @Edition.setter
    def Edition(self, Edition):
        self._Edition = Edition

    @property
    def Level(self):
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level

    @property
    def WriteConfig(self):
        return self._WriteConfig

    @WriteConfig.setter
    def WriteConfig(self, WriteConfig):
        self._WriteConfig = WriteConfig

    @property
    def Cls(self):
        return self._Cls

    @Cls.setter
    def Cls(self, Cls):
        self._Cls = Cls

    @property
    def CloudType(self):
        return self._CloudType

    @CloudType.setter
    def CloudType(self, CloudType):
        self._CloudType = CloudType

    @property
    def AlbType(self):
        return self._AlbType

    @AlbType.setter
    def AlbType(self, AlbType):
        self._AlbType = AlbType

    @property
    def BotStatus(self):
        return self._BotStatus

    @BotStatus.setter
    def BotStatus(self, BotStatus):
        self._BotStatus = BotStatus

    @property
    def ApiStatus(self):
        return self._ApiStatus

    @ApiStatus.setter
    def ApiStatus(self, ApiStatus):
        self._ApiStatus = ApiStatus


    def _deserialize(self, params):
        self._Appid = params.get("Appid")
        self._Domain = params.get("Domain")
        self._DomainId = params.get("DomainId")
        self._InstanceId = params.get("InstanceId")
        self._InstanceName = params.get("InstanceName")
        self._Edition = params.get("Edition")
        self._Level = params.get("Level")
        self._WriteConfig = params.get("WriteConfig")
        self._Cls = params.get("Cls")
        self._CloudType = params.get("CloudType")
        self._AlbType = params.get("AlbType")
        self._BotStatus = params.get("BotStatus")
        self._ApiStatus = params.get("ApiStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class VipInfo(AbstractModel):
    """VIP information

    """

    def __init__(self):
        r"""
        :param _Vip: Virtual IP
Note: This field may return null, indicating that no valid values can be obtained.
        :type Vip: str
        :param _InstanceId: WAF Instance ID

Note: This field may return null, indicating that no valid values can be obtained.
        :type InstanceId: str
        """
        self._Vip = None
        self._InstanceId = None

    @property
    def Vip(self):
        return self._Vip

    @Vip.setter
    def Vip(self, Vip):
        self._Vip = Vip

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._Vip = params.get("Vip")
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class WafRuleLimit(AbstractModel):
    """WAF module specifications

    """

    def __init__(self):
        r"""
        :param _CC: Specifications of Custom CC
        :type CC: int
        :param _CustomRule: Specifications for Custom Policy
        :type CustomRule: int
        :param _IPControl: Specifications for Blocklist/Allowlist
        :type IPControl: int
        :param _AntiLeak: Specifications for Information Leakage Prevention
        :type AntiLeak: int
        :param _AntiTamper: Tamper-proof Specifications
        :type AntiTamper: int
        :param _AutoCC: Specifications for Urgent CC
        :type AutoCC: int
        :param _AreaBan: Specifications for Region Banning
        :type AreaBan: int
        :param _CCSession: Configure Session in Custom CC
        :type CCSession: int
        :param _AI: AI Specifications
        :type AI: int
        :param _CustomWhite: Specifications of Precision Allowlist
        :type CustomWhite: int
        :param _ApiSecurity: API Security Specification
        :type ApiSecurity: int
        :param _ClientMsg: Specifications for client traffic flag
        :type ClientMsg: int
        :param _TrafficMarking: Specifications for Traffic Tagging
        :type TrafficMarking: int
        """
        self._CC = None
        self._CustomRule = None
        self._IPControl = None
        self._AntiLeak = None
        self._AntiTamper = None
        self._AutoCC = None
        self._AreaBan = None
        self._CCSession = None
        self._AI = None
        self._CustomWhite = None
        self._ApiSecurity = None
        self._ClientMsg = None
        self._TrafficMarking = None

    @property
    def CC(self):
        return self._CC

    @CC.setter
    def CC(self, CC):
        self._CC = CC

    @property
    def CustomRule(self):
        return self._CustomRule

    @CustomRule.setter
    def CustomRule(self, CustomRule):
        self._CustomRule = CustomRule

    @property
    def IPControl(self):
        return self._IPControl

    @IPControl.setter
    def IPControl(self, IPControl):
        self._IPControl = IPControl

    @property
    def AntiLeak(self):
        return self._AntiLeak

    @AntiLeak.setter
    def AntiLeak(self, AntiLeak):
        self._AntiLeak = AntiLeak

    @property
    def AntiTamper(self):
        return self._AntiTamper

    @AntiTamper.setter
    def AntiTamper(self, AntiTamper):
        self._AntiTamper = AntiTamper

    @property
    def AutoCC(self):
        return self._AutoCC

    @AutoCC.setter
    def AutoCC(self, AutoCC):
        self._AutoCC = AutoCC

    @property
    def AreaBan(self):
        return self._AreaBan

    @AreaBan.setter
    def AreaBan(self, AreaBan):
        self._AreaBan = AreaBan

    @property
    def CCSession(self):
        return self._CCSession

    @CCSession.setter
    def CCSession(self, CCSession):
        self._CCSession = CCSession

    @property
    def AI(self):
        return self._AI

    @AI.setter
    def AI(self, AI):
        self._AI = AI

    @property
    def CustomWhite(self):
        return self._CustomWhite

    @CustomWhite.setter
    def CustomWhite(self, CustomWhite):
        self._CustomWhite = CustomWhite

    @property
    def ApiSecurity(self):
        return self._ApiSecurity

    @ApiSecurity.setter
    def ApiSecurity(self, ApiSecurity):
        self._ApiSecurity = ApiSecurity

    @property
    def ClientMsg(self):
        return self._ClientMsg

    @ClientMsg.setter
    def ClientMsg(self, ClientMsg):
        self._ClientMsg = ClientMsg

    @property
    def TrafficMarking(self):
        return self._TrafficMarking

    @TrafficMarking.setter
    def TrafficMarking(self, TrafficMarking):
        self._TrafficMarking = TrafficMarking


    def _deserialize(self, params):
        self._CC = params.get("CC")
        self._CustomRule = params.get("CustomRule")
        self._IPControl = params.get("IPControl")
        self._AntiLeak = params.get("AntiLeak")
        self._AntiTamper = params.get("AntiTamper")
        self._AutoCC = params.get("AutoCC")
        self._AreaBan = params.get("AreaBan")
        self._CCSession = params.get("CCSession")
        self._AI = params.get("AI")
        self._CustomWhite = params.get("CustomWhite")
        self._ApiSecurity = params.get("ApiSecurity")
        self._ClientMsg = params.get("ClientMsg")
        self._TrafficMarking = params.get("TrafficMarking")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class WebshellStatus(AbstractModel):
    """Domain's Webshell activation status

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _Status: Webshell Switch, 1: On. 0: Off. 2: Observation
        :type Status: int
        """
        self._Domain = None
        self._Status = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        