# -*- coding: utf8 -*-
# Copyright (c) 2017-2021 THL A29 Limited, a Tencent company. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class AdhocDetail(AbstractModel):
    """Subtask records

    """

    def __init__(self):
        r"""
        :param _Id: Subtask record Id
        :type Id: int
        :param _ScriptContent: Script Content
        :type ScriptContent: str
        :param _StartTime: Task start time
Note: This field may return null, indicating that no valid value can be obtained.
        :type StartTime: str
        :param _EndTime: Task termination time
Note: This field may return null, indicating that no valid value can be obtained.
        :type EndTime: str
        :param _Status: Current Task Status
        :type Status: str
        :param _RecordId: Submit Task ID
        :type RecordId: int
        """
        self._Id = None
        self._ScriptContent = None
        self._StartTime = None
        self._EndTime = None
        self._Status = None
        self._RecordId = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def ScriptContent(self):
        return self._ScriptContent

    @ScriptContent.setter
    def ScriptContent(self, ScriptContent):
        self._ScriptContent = ScriptContent

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def RecordId(self):
        return self._RecordId

    @RecordId.setter
    def RecordId(self, RecordId):
        self._RecordId = RecordId


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._ScriptContent = params.get("ScriptContent")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Status = params.get("Status")
        self._RecordId = params.get("RecordId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AdhocRecord(AbstractModel):
    """Task Submission Record

    """

    def __init__(self):
        r"""
        :param _Id: Task Submission Record ID
Note: This field may return null, indicating that no valid value can be obtained.
        :type Id: int
        :param _ScriptContent: Script ContentNote: This field may return null, indicating that no valid value can be obtained.
        :type ScriptContent: str
        :param _CreateTime: Task Submission Time
Note: This field may return null, indicating that no valid value can be obtained.
        :type CreateTime: str
        :param _Status: Task StatusNote: This field may return null, indicating that no valid value can be obtained.
        :type Status: str
        :param _InstanceId: Instance ID
Note: This field may return null, indicating that no valid value can be obtained.
        :type InstanceId: str
        """
        self._Id = None
        self._ScriptContent = None
        self._CreateTime = None
        self._Status = None
        self._InstanceId = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def ScriptContent(self):
        return self._ScriptContent

    @ScriptContent.setter
    def ScriptContent(self, ScriptContent):
        self._ScriptContent = ScriptContent

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._ScriptContent = params.get("ScriptContent")
        self._CreateTime = params.get("CreateTime")
        self._Status = params.get("Status")
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AgentStatus(AbstractModel):
    """Agent Collector Status Statistics

    """

    def __init__(self):
        r"""
        :param _Running: Running Quantity
Note: This field may return null, indicating that no valid value can be obtained.
        :type Running: int
        :param _Abnormal: Number of Anomalies
Note: This field may return null, indicating that no valid value can be obtained.
        :type Abnormal: int
        :param _InOperation: Operating Quantity
Note: This field may return null, indicating that no valid value can be obtained.
        :type InOperation: int
        """
        self._Running = None
        self._Abnormal = None
        self._InOperation = None

    @property
    def Running(self):
        return self._Running

    @Running.setter
    def Running(self, Running):
        self._Running = Running

    @property
    def Abnormal(self):
        return self._Abnormal

    @Abnormal.setter
    def Abnormal(self, Abnormal):
        self._Abnormal = Abnormal

    @property
    def InOperation(self):
        return self._InOperation

    @InOperation.setter
    def InOperation(self, InOperation):
        self._InOperation = InOperation


    def _deserialize(self, params):
        self._Running = params.get("Running")
        self._Abnormal = params.get("Abnormal")
        self._InOperation = params.get("InOperation")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AlarmEventInfo(AbstractModel):
    """Alarm Event Details

    """

    def __init__(self):
        r"""
        :param _AlarmId: Alert ID
        :type AlarmId: str
        :param _AlarmTime: Alarm Time
        :type AlarmTime: str
        :param _TaskId: Task ID
        :type TaskId: str
        :param _RegularName: Rule name
        :type RegularName: str
        :param _AlarmLevel: Alert level, 0 for normal, 1 for important, 2 for urgent
        :type AlarmLevel: int
        :param _AlarmWay: Alert Method, separated by commas (1: email, 2: SMS, 3: WeChat, 4: voice call, 5: represents WeCom, 6: http)
        :type AlarmWay: int
        :param _AlarmRecipientId: Alert Recipient ID, separated by commas
        :type AlarmRecipientId: str
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _AlarmIndicator: Alert Metrics, 0 for task failure, 1 for task run timeout, 2 for task stop, 3 for task pause
        :type AlarmIndicator: int
        :param _AlarmIndicatorDesc: Alert Metric Description
Note: This field may return null, indicating that no valid value can be obtained.
        :type AlarmIndicatorDesc: str
        :param _TriggerType: Metric threshold, 1 indicates the first run failure of the offline task, 2 indicates failure after all retries of the offline task
Note: This field may return null, indicating that no valid value can be obtained.
        :type TriggerType: int
        :param _EstimatedTime: Estimated timeout, minute level
Note: This field may return null, indicating that no valid value can be obtained.
        :type EstimatedTime: int
        :param _InstanceId: Instance IDNote: This field may return null, indicating that no valid value can be obtained.
        :type InstanceId: str
        :param _TaskName: Task NameNote: This field may return null, indicating that no valid value can be obtained.
        :type TaskName: str
        :param _IsSendSuccess: 0: Partial Success, 1: Complete Success, 2: Complete Failure
Note: This field may return null, indicating that no valid value can be obtained.
        :type IsSendSuccess: int
        :param _InQuitePeriods: During Do Not Disturb time, 0: No, 1: Yes
Note: This field may return null, indicating that no valid value can be obtained.
        :type InQuitePeriods: int
        :param _RecordId: Alert Record ID
Note: This field may return null, indicating that no valid value can be obtained.
        :type RecordId: int
        :param _MessageId: Message ID
Note: This field may return null, indicating that no valid value can be obtained.
        :type MessageId: str
        :param _Operator: Threshold Calculation Operator, 1: Greater than, 2: Less than
Note: This field may return null, indicating that no valid value can be obtained.
        :type Operator: int
        :param _RegularId: Alert Rule ID
Note: This field may return null, indicating that no valid value can be obtained.
        :type RegularId: str
        :param _AlarmRecipientName: Alert Recipient Nickname
Note: This field may return null, indicating that no valid value can be obtained.
        :type AlarmRecipientName: str
        :param _TaskType: Alert Task Type
Note: This field may return null, indicating that no valid value can be obtained.
        :type TaskType: int
        :param _SendResult: Send Result
Note: This field may return null, indicating that no valid value can be obtained.
        :type SendResult: str
        :param _MonitorObjectId: Monitoring Object ID
Note: This field may return null, indicating that no valid value can be obtained.
        :type MonitorObjectId: str
        :param _MonitorObjectName: Monitoring Object Name
Note: This field may return null, indicating that no valid value can be obtained.
        :type MonitorObjectName: str
        :param _Threshold: Metric Threshold
Note: This field may return null, indicating that no valid value can be obtained.
        :type Threshold: float
        """
        self._AlarmId = None
        self._AlarmTime = None
        self._TaskId = None
        self._RegularName = None
        self._AlarmLevel = None
        self._AlarmWay = None
        self._AlarmRecipientId = None
        self._ProjectId = None
        self._AlarmIndicator = None
        self._AlarmIndicatorDesc = None
        self._TriggerType = None
        self._EstimatedTime = None
        self._InstanceId = None
        self._TaskName = None
        self._IsSendSuccess = None
        self._InQuitePeriods = None
        self._RecordId = None
        self._MessageId = None
        self._Operator = None
        self._RegularId = None
        self._AlarmRecipientName = None
        self._TaskType = None
        self._SendResult = None
        self._MonitorObjectId = None
        self._MonitorObjectName = None
        self._Threshold = None

    @property
    def AlarmId(self):
        return self._AlarmId

    @AlarmId.setter
    def AlarmId(self, AlarmId):
        self._AlarmId = AlarmId

    @property
    def AlarmTime(self):
        return self._AlarmTime

    @AlarmTime.setter
    def AlarmTime(self, AlarmTime):
        self._AlarmTime = AlarmTime

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RegularName(self):
        return self._RegularName

    @RegularName.setter
    def RegularName(self, RegularName):
        self._RegularName = RegularName

    @property
    def AlarmLevel(self):
        return self._AlarmLevel

    @AlarmLevel.setter
    def AlarmLevel(self, AlarmLevel):
        self._AlarmLevel = AlarmLevel

    @property
    def AlarmWay(self):
        return self._AlarmWay

    @AlarmWay.setter
    def AlarmWay(self, AlarmWay):
        self._AlarmWay = AlarmWay

    @property
    def AlarmRecipientId(self):
        return self._AlarmRecipientId

    @AlarmRecipientId.setter
    def AlarmRecipientId(self, AlarmRecipientId):
        self._AlarmRecipientId = AlarmRecipientId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def AlarmIndicator(self):
        return self._AlarmIndicator

    @AlarmIndicator.setter
    def AlarmIndicator(self, AlarmIndicator):
        self._AlarmIndicator = AlarmIndicator

    @property
    def AlarmIndicatorDesc(self):
        return self._AlarmIndicatorDesc

    @AlarmIndicatorDesc.setter
    def AlarmIndicatorDesc(self, AlarmIndicatorDesc):
        self._AlarmIndicatorDesc = AlarmIndicatorDesc

    @property
    def TriggerType(self):
        return self._TriggerType

    @TriggerType.setter
    def TriggerType(self, TriggerType):
        self._TriggerType = TriggerType

    @property
    def EstimatedTime(self):
        return self._EstimatedTime

    @EstimatedTime.setter
    def EstimatedTime(self, EstimatedTime):
        self._EstimatedTime = EstimatedTime

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def TaskName(self):
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def IsSendSuccess(self):
        return self._IsSendSuccess

    @IsSendSuccess.setter
    def IsSendSuccess(self, IsSendSuccess):
        self._IsSendSuccess = IsSendSuccess

    @property
    def InQuitePeriods(self):
        return self._InQuitePeriods

    @InQuitePeriods.setter
    def InQuitePeriods(self, InQuitePeriods):
        self._InQuitePeriods = InQuitePeriods

    @property
    def RecordId(self):
        return self._RecordId

    @RecordId.setter
    def RecordId(self, RecordId):
        self._RecordId = RecordId

    @property
    def MessageId(self):
        return self._MessageId

    @MessageId.setter
    def MessageId(self, MessageId):
        self._MessageId = MessageId

    @property
    def Operator(self):
        return self._Operator

    @Operator.setter
    def Operator(self, Operator):
        self._Operator = Operator

    @property
    def RegularId(self):
        return self._RegularId

    @RegularId.setter
    def RegularId(self, RegularId):
        self._RegularId = RegularId

    @property
    def AlarmRecipientName(self):
        return self._AlarmRecipientName

    @AlarmRecipientName.setter
    def AlarmRecipientName(self, AlarmRecipientName):
        self._AlarmRecipientName = AlarmRecipientName

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def SendResult(self):
        return self._SendResult

    @SendResult.setter
    def SendResult(self, SendResult):
        self._SendResult = SendResult

    @property
    def MonitorObjectId(self):
        return self._MonitorObjectId

    @MonitorObjectId.setter
    def MonitorObjectId(self, MonitorObjectId):
        self._MonitorObjectId = MonitorObjectId

    @property
    def MonitorObjectName(self):
        return self._MonitorObjectName

    @MonitorObjectName.setter
    def MonitorObjectName(self, MonitorObjectName):
        self._MonitorObjectName = MonitorObjectName

    @property
    def Threshold(self):
        return self._Threshold

    @Threshold.setter
    def Threshold(self, Threshold):
        self._Threshold = Threshold


    def _deserialize(self, params):
        self._AlarmId = params.get("AlarmId")
        self._AlarmTime = params.get("AlarmTime")
        self._TaskId = params.get("TaskId")
        self._RegularName = params.get("RegularName")
        self._AlarmLevel = params.get("AlarmLevel")
        self._AlarmWay = params.get("AlarmWay")
        self._AlarmRecipientId = params.get("AlarmRecipientId")
        self._ProjectId = params.get("ProjectId")
        self._AlarmIndicator = params.get("AlarmIndicator")
        self._AlarmIndicatorDesc = params.get("AlarmIndicatorDesc")
        self._TriggerType = params.get("TriggerType")
        self._EstimatedTime = params.get("EstimatedTime")
        self._InstanceId = params.get("InstanceId")
        self._TaskName = params.get("TaskName")
        self._IsSendSuccess = params.get("IsSendSuccess")
        self._InQuitePeriods = params.get("InQuitePeriods")
        self._RecordId = params.get("RecordId")
        self._MessageId = params.get("MessageId")
        self._Operator = params.get("Operator")
        self._RegularId = params.get("RegularId")
        self._AlarmRecipientName = params.get("AlarmRecipientName")
        self._TaskType = params.get("TaskType")
        self._SendResult = params.get("SendResult")
        self._MonitorObjectId = params.get("MonitorObjectId")
        self._MonitorObjectName = params.get("MonitorObjectName")
        self._Threshold = params.get("Threshold")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AlarmIndicatorInfo(AbstractModel):
    """Alert Metrics

    """

    def __init__(self):
        r"""
        :param _Id: Metric ID
Note: This field may return null, indicating that no valid value can be obtained.
        :type Id: str
        :param _AlarmIndicator: Alert Metrics, 0 for task failure, 1 for task execution timeout, 2 for task stop, 3 for task pause, 4 read speed, 5 write speed, 6 read throughput, 7 write throughput, 8 dirty data byte count, 9 number of dirty data entries, 10 task exception, 11 task detection anomaly, 12 restart times, 13 task delay, 14 number of restarts within the last 20 minutes, 15 transmission delay, 16 business delay, 50 offline package CPU usage rate, 51 offline package memory usage rate, 52 offline package parallelism utilization, 53 number of instances queued for offline packages, 54 real-time package resource utilization, 55 number of tasks running in real-time packages
Note: This field may return null, indicating that no valid value can be obtained.
        :type AlarmIndicator: int
        :param _AlarmIndicatorDesc: Alert Metric Description
Note: This field may return null, indicating that no valid value can be obtained.
        :type AlarmIndicatorDesc: str
        :param _TriggerType: Metric Threshold, 1 for the first run failure of an offline task, 2 for all retries failed of an offline task
Note: This field may return null, indicating that no valid value can be obtained.
        :type TriggerType: int
        :param _EstimatedTime: Estimated timeout duration, minute level
Note: This field may return null, indicating that no valid value can be obtained.
        :type EstimatedTime: int
        :param _Operator: Alert threshold operator, 1 Greater than, 2 Less than
Note: This field may return null, indicating that no valid value can be obtained.
        :type Operator: int
        :param _AlarmIndicatorUnit: Alert metric threshold unit: ms (milliseconds), s (seconds), min (minutes)
Note: This field may return null, indicating that no valid value can be obtained.
        :type AlarmIndicatorUnit: str
        :param _Duration: Alert Interval
        :type Duration: int
        :param _DurationUnit: Alert interval unit: hour, minute, day
        :type DurationUnit: str
        :param _MaxTimes: Maximum number of alerts within a cycle
        :type MaxTimes: int
        :param _Threshold: Metric Threshold
Note: This field may return null, indicating that no valid value can be obtained.
        :type Threshold: float
        """
        self._Id = None
        self._AlarmIndicator = None
        self._AlarmIndicatorDesc = None
        self._TriggerType = None
        self._EstimatedTime = None
        self._Operator = None
        self._AlarmIndicatorUnit = None
        self._Duration = None
        self._DurationUnit = None
        self._MaxTimes = None
        self._Threshold = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def AlarmIndicator(self):
        return self._AlarmIndicator

    @AlarmIndicator.setter
    def AlarmIndicator(self, AlarmIndicator):
        self._AlarmIndicator = AlarmIndicator

    @property
    def AlarmIndicatorDesc(self):
        return self._AlarmIndicatorDesc

    @AlarmIndicatorDesc.setter
    def AlarmIndicatorDesc(self, AlarmIndicatorDesc):
        self._AlarmIndicatorDesc = AlarmIndicatorDesc

    @property
    def TriggerType(self):
        return self._TriggerType

    @TriggerType.setter
    def TriggerType(self, TriggerType):
        self._TriggerType = TriggerType

    @property
    def EstimatedTime(self):
        return self._EstimatedTime

    @EstimatedTime.setter
    def EstimatedTime(self, EstimatedTime):
        self._EstimatedTime = EstimatedTime

    @property
    def Operator(self):
        return self._Operator

    @Operator.setter
    def Operator(self, Operator):
        self._Operator = Operator

    @property
    def AlarmIndicatorUnit(self):
        return self._AlarmIndicatorUnit

    @AlarmIndicatorUnit.setter
    def AlarmIndicatorUnit(self, AlarmIndicatorUnit):
        self._AlarmIndicatorUnit = AlarmIndicatorUnit

    @property
    def Duration(self):
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration

    @property
    def DurationUnit(self):
        return self._DurationUnit

    @DurationUnit.setter
    def DurationUnit(self, DurationUnit):
        self._DurationUnit = DurationUnit

    @property
    def MaxTimes(self):
        return self._MaxTimes

    @MaxTimes.setter
    def MaxTimes(self, MaxTimes):
        self._MaxTimes = MaxTimes

    @property
    def Threshold(self):
        return self._Threshold

    @Threshold.setter
    def Threshold(self, Threshold):
        self._Threshold = Threshold


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._AlarmIndicator = params.get("AlarmIndicator")
        self._AlarmIndicatorDesc = params.get("AlarmIndicatorDesc")
        self._TriggerType = params.get("TriggerType")
        self._EstimatedTime = params.get("EstimatedTime")
        self._Operator = params.get("Operator")
        self._AlarmIndicatorUnit = params.get("AlarmIndicatorUnit")
        self._Duration = params.get("Duration")
        self._DurationUnit = params.get("DurationUnit")
        self._MaxTimes = params.get("MaxTimes")
        self._Threshold = params.get("Threshold")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AlarmInfo(AbstractModel):
    """Task Alert Information

    """

    def __init__(self):
        r"""
        :param _TaskIds: Associated Task ID
        :type TaskIds: str
        :param _AlarmType: Alert Categories; 'failure' indicates failure alert; 'overtime' indicates timeout alert
        :type AlarmType: str
        :param _AlarmWay: Alert Method; 'SMS' indicates SMS; 'Email' indicates email; 'HTTP' indicates an interface method; 'Wechat' indicates WeChat method
        :type AlarmWay: str
        :param _AlarmRecipient: Alert Recipient, multiple recipients separated by ;
        :type AlarmRecipient: str
        :param _AlarmRecipientId: Alert Recipient ID, multiple recipient IDs separated by ;
        :type AlarmRecipientId: str
        :param _Hours: Estimated Running Hours, value range 0-23
        :type Hours: int
        :param _Minutes: Estimated Running Minutes, value range 0-59
        :type Minutes: int
        :param _TriggerType: Alert Trigger Moment; '1' means first run failure; '2' means failure after all retries;
        :type TriggerType: int
        :param _AlarmId: Alert Information ID
        :type AlarmId: str
        :param _Status: Alert Status Setting; '1' indicates available; '0' indicates unavailable, default is available
        :type Status: int
        """
        self._TaskIds = None
        self._AlarmType = None
        self._AlarmWay = None
        self._AlarmRecipient = None
        self._AlarmRecipientId = None
        self._Hours = None
        self._Minutes = None
        self._TriggerType = None
        self._AlarmId = None
        self._Status = None

    @property
    def TaskIds(self):
        return self._TaskIds

    @TaskIds.setter
    def TaskIds(self, TaskIds):
        self._TaskIds = TaskIds

    @property
    def AlarmType(self):
        return self._AlarmType

    @AlarmType.setter
    def AlarmType(self, AlarmType):
        self._AlarmType = AlarmType

    @property
    def AlarmWay(self):
        return self._AlarmWay

    @AlarmWay.setter
    def AlarmWay(self, AlarmWay):
        self._AlarmWay = AlarmWay

    @property
    def AlarmRecipient(self):
        return self._AlarmRecipient

    @AlarmRecipient.setter
    def AlarmRecipient(self, AlarmRecipient):
        self._AlarmRecipient = AlarmRecipient

    @property
    def AlarmRecipientId(self):
        return self._AlarmRecipientId

    @AlarmRecipientId.setter
    def AlarmRecipientId(self, AlarmRecipientId):
        self._AlarmRecipientId = AlarmRecipientId

    @property
    def Hours(self):
        return self._Hours

    @Hours.setter
    def Hours(self, Hours):
        self._Hours = Hours

    @property
    def Minutes(self):
        return self._Minutes

    @Minutes.setter
    def Minutes(self, Minutes):
        self._Minutes = Minutes

    @property
    def TriggerType(self):
        return self._TriggerType

    @TriggerType.setter
    def TriggerType(self, TriggerType):
        self._TriggerType = TriggerType

    @property
    def AlarmId(self):
        return self._AlarmId

    @AlarmId.setter
    def AlarmId(self, AlarmId):
        self._AlarmId = AlarmId

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._TaskIds = params.get("TaskIds")
        self._AlarmType = params.get("AlarmType")
        self._AlarmWay = params.get("AlarmWay")
        self._AlarmRecipient = params.get("AlarmRecipient")
        self._AlarmRecipientId = params.get("AlarmRecipientId")
        self._Hours = params.get("Hours")
        self._Minutes = params.get("Minutes")
        self._TriggerType = params.get("TriggerType")
        self._AlarmId = params.get("AlarmId")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AlarmReceiverInfo(AbstractModel):
    """Alert Recipient Details

    """

    def __init__(self):
        r"""
        :param _AlarmId: Alert ID
        :type AlarmId: str
        :param _AlarmReceiver: Alarm Recipient ID
        :type AlarmReceiver: str
        :param _Email: Email,0: Not set,1: Success,2: Failure
        :type Email: int
        :param _Sms: SMS,0: Not set,1: Success,2: Failure
        :type Sms: int
        :param _Wechat: WeChat,0: Not set,1: Success,2: Failure
        :type Wechat: int
        :param _Voice: Telephone,0: Not set,1: Success,2: Failure
        :type Voice: int
        :param _Wecom: WeCom,0: Not set,1: Success,2: Failure
        :type Wecom: int
        :param _Http: http,0: Not set,1: Success,2: Failure
        :type Http: int
        :param _WecomGroup: Enterprise WeChat group,0: Not set,1: Success,2: Failure
Note: This field may return null, indicating that no valid value can be obtained.
        :type WecomGroup: int
        :param _LarkGroup: FeiShu Group,0: Not set,1: Success,2: Failure
Note: This field may return null, indicating that no valid value can be obtained.
        :type LarkGroup: int
        """
        self._AlarmId = None
        self._AlarmReceiver = None
        self._Email = None
        self._Sms = None
        self._Wechat = None
        self._Voice = None
        self._Wecom = None
        self._Http = None
        self._WecomGroup = None
        self._LarkGroup = None

    @property
    def AlarmId(self):
        return self._AlarmId

    @AlarmId.setter
    def AlarmId(self, AlarmId):
        self._AlarmId = AlarmId

    @property
    def AlarmReceiver(self):
        return self._AlarmReceiver

    @AlarmReceiver.setter
    def AlarmReceiver(self, AlarmReceiver):
        self._AlarmReceiver = AlarmReceiver

    @property
    def Email(self):
        return self._Email

    @Email.setter
    def Email(self, Email):
        self._Email = Email

    @property
    def Sms(self):
        return self._Sms

    @Sms.setter
    def Sms(self, Sms):
        self._Sms = Sms

    @property
    def Wechat(self):
        return self._Wechat

    @Wechat.setter
    def Wechat(self, Wechat):
        self._Wechat = Wechat

    @property
    def Voice(self):
        return self._Voice

    @Voice.setter
    def Voice(self, Voice):
        self._Voice = Voice

    @property
    def Wecom(self):
        return self._Wecom

    @Wecom.setter
    def Wecom(self, Wecom):
        self._Wecom = Wecom

    @property
    def Http(self):
        return self._Http

    @Http.setter
    def Http(self, Http):
        self._Http = Http

    @property
    def WecomGroup(self):
        return self._WecomGroup

    @WecomGroup.setter
    def WecomGroup(self, WecomGroup):
        self._WecomGroup = WecomGroup

    @property
    def LarkGroup(self):
        return self._LarkGroup

    @LarkGroup.setter
    def LarkGroup(self, LarkGroup):
        self._LarkGroup = LarkGroup


    def _deserialize(self, params):
        self._AlarmId = params.get("AlarmId")
        self._AlarmReceiver = params.get("AlarmReceiver")
        self._Email = params.get("Email")
        self._Sms = params.get("Sms")
        self._Wechat = params.get("Wechat")
        self._Voice = params.get("Voice")
        self._Wecom = params.get("Wecom")
        self._Http = params.get("Http")
        self._WecomGroup = params.get("WecomGroup")
        self._LarkGroup = params.get("LarkGroup")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Apply(AbstractModel):
    """Approval List Information

    """

    def __init__(self):
        r"""
        :param _ApplicantId: Applicant ID
        :type ApplicantId: str
        :param _ApplicantName: Applicant Name
        :type ApplicantName: str
        :param _Remark: Approval Remarks
Note: This field may return null, indicating that no valid value can be obtained.
        :type Remark: str
        :param _ApproveClassification: Approval Category Key
        :type ApproveClassification: str
        :param _ApproveId: Approval Form ID
        :type ApproveId: str
        :param _ApproveType: Approval Type Key
        :type ApproveType: str
        :param _Reason: Application Reason
Note: This field may return null, indicating that no valid value can be obtained.
        :type Reason: str
        :param _CreateTime: Creation Time
        :type CreateTime: str
        :param _ApproveTime: Approval Time
Note: This field may return null, indicating that no valid value can be obtained.
        :type ApproveTime: str
        :param _ApproveClassificationName: Approval Category Name
        :type ApproveClassificationName: str
        :param _Status: Status
        :type Status: str
        :param _ApproveTypeName: Approval Type Name
        :type ApproveTypeName: str
        :param _ErrorMessage: Approval Exception or Failure Information
        :type ErrorMessage: str
        :param _ApplyName: Apply for Name
Note: This field may return null, indicating that no valid value can be obtained.
        :type ApplyName: str
        :param _ApproverId: Approver ID
Note: This field may return null, indicating that no valid value can be obtained.
        :type ApproverId: str
        :param _ApproverName: Approver Name
Note: This field may return null, indicating that no valid value can be obtained.
        :type ApproverName: str
        :param _ApproveProjectName: Project for Approval
Note: This field may return null, indicating that no valid value can be obtained.
        :type ApproveProjectName: str
        """
        self._ApplicantId = None
        self._ApplicantName = None
        self._Remark = None
        self._ApproveClassification = None
        self._ApproveId = None
        self._ApproveType = None
        self._Reason = None
        self._CreateTime = None
        self._ApproveTime = None
        self._ApproveClassificationName = None
        self._Status = None
        self._ApproveTypeName = None
        self._ErrorMessage = None
        self._ApplyName = None
        self._ApproverId = None
        self._ApproverName = None
        self._ApproveProjectName = None

    @property
    def ApplicantId(self):
        return self._ApplicantId

    @ApplicantId.setter
    def ApplicantId(self, ApplicantId):
        self._ApplicantId = ApplicantId

    @property
    def ApplicantName(self):
        return self._ApplicantName

    @ApplicantName.setter
    def ApplicantName(self, ApplicantName):
        self._ApplicantName = ApplicantName

    @property
    def Remark(self):
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def ApproveClassification(self):
        return self._ApproveClassification

    @ApproveClassification.setter
    def ApproveClassification(self, ApproveClassification):
        self._ApproveClassification = ApproveClassification

    @property
    def ApproveId(self):
        return self._ApproveId

    @ApproveId.setter
    def ApproveId(self, ApproveId):
        self._ApproveId = ApproveId

    @property
    def ApproveType(self):
        return self._ApproveType

    @ApproveType.setter
    def ApproveType(self, ApproveType):
        self._ApproveType = ApproveType

    @property
    def Reason(self):
        return self._Reason

    @Reason.setter
    def Reason(self, Reason):
        self._Reason = Reason

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ApproveTime(self):
        return self._ApproveTime

    @ApproveTime.setter
    def ApproveTime(self, ApproveTime):
        self._ApproveTime = ApproveTime

    @property
    def ApproveClassificationName(self):
        return self._ApproveClassificationName

    @ApproveClassificationName.setter
    def ApproveClassificationName(self, ApproveClassificationName):
        self._ApproveClassificationName = ApproveClassificationName

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ApproveTypeName(self):
        return self._ApproveTypeName

    @ApproveTypeName.setter
    def ApproveTypeName(self, ApproveTypeName):
        self._ApproveTypeName = ApproveTypeName

    @property
    def ErrorMessage(self):
        return self._ErrorMessage

    @ErrorMessage.setter
    def ErrorMessage(self, ErrorMessage):
        self._ErrorMessage = ErrorMessage

    @property
    def ApplyName(self):
        return self._ApplyName

    @ApplyName.setter
    def ApplyName(self, ApplyName):
        self._ApplyName = ApplyName

    @property
    def ApproverId(self):
        return self._ApproverId

    @ApproverId.setter
    def ApproverId(self, ApproverId):
        self._ApproverId = ApproverId

    @property
    def ApproverName(self):
        return self._ApproverName

    @ApproverName.setter
    def ApproverName(self, ApproverName):
        self._ApproverName = ApproverName

    @property
    def ApproveProjectName(self):
        return self._ApproveProjectName

    @ApproveProjectName.setter
    def ApproveProjectName(self, ApproveProjectName):
        self._ApproveProjectName = ApproveProjectName


    def _deserialize(self, params):
        self._ApplicantId = params.get("ApplicantId")
        self._ApplicantName = params.get("ApplicantName")
        self._Remark = params.get("Remark")
        self._ApproveClassification = params.get("ApproveClassification")
        self._ApproveId = params.get("ApproveId")
        self._ApproveType = params.get("ApproveType")
        self._Reason = params.get("Reason")
        self._CreateTime = params.get("CreateTime")
        self._ApproveTime = params.get("ApproveTime")
        self._ApproveClassificationName = params.get("ApproveClassificationName")
        self._Status = params.get("Status")
        self._ApproveTypeName = params.get("ApproveTypeName")
        self._ErrorMessage = params.get("ErrorMessage")
        self._ApplyName = params.get("ApplyName")
        self._ApproverId = params.get("ApproverId")
        self._ApproverName = params.get("ApproverName")
        self._ApproveProjectName = params.get("ApproveProjectName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApproveModify(AbstractModel):
    """Modify Approval Form Status

    """

    def __init__(self):
        r"""
        :param _ApproveId: Approval Form ID
        :type ApproveId: str
        :param _Success: Modification successful?
        :type Success: bool
        """
        self._ApproveId = None
        self._Success = None

    @property
    def ApproveId(self):
        return self._ApproveId

    @ApproveId.setter
    def ApproveId(self, ApproveId):
        self._ApproveId = ApproveId

    @property
    def Success(self):
        return self._Success

    @Success.setter
    def Success(self, Success):
        self._Success = Success


    def _deserialize(self, params):
        self._ApproveId = params.get("ApproveId")
        self._Success = params.get("Success")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApproveType(AbstractModel):
    """Approval Category

    """

    def __init__(self):
        r"""
        :param _Type: Application Category Key
        :type Type: str
        :param _TypeName: Type Name
        :type TypeName: str
        :param _Classification: Application Type Key
        :type Classification: str
        """
        self._Type = None
        self._TypeName = None
        self._Classification = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def TypeName(self):
        return self._TypeName

    @TypeName.setter
    def TypeName(self, TypeName):
        self._TypeName = TypeName

    @property
    def Classification(self):
        return self._Classification

    @Classification.setter
    def Classification(self, Classification):
        self._Classification = Classification


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._TypeName = params.get("TypeName")
        self._Classification = params.get("Classification")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AttributeItemDTO(AbstractModel):
    """AIOps basic information

    """

    def __init__(self):
        r"""
        :param _Key: key
Note: This field may return null, indicating that no valid value can be obtained.
        :type Key: str
        :param _Value: value
Note: This field may return null, indicating that no valid value can be obtained.
        :type Value: str
        :param _Description: DescriptionNote: This field may return null, indicating that no valid value can be obtained.
        :type Description: str
        """
        self._Key = None
        self._Value = None
        self._Description = None

    @property
    def Key(self):
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key

    @property
    def Value(self):
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._Key = params.get("Key")
        self._Value = params.get("Value")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaseClusterInfo(AbstractModel):
    """Cluster Basic Information

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
Note: This field may return null, indicating that no valid value can be obtained.
        :type ClusterId: str
        :param _ClusterType: Cluster Type, EMR/CDW, etc.
Note: This field may return null, indicating that no valid value can be obtained.
        :type ClusterType: str
        :param _ClusterName: Cluster NameNote: This field may return null, indicating that no valid value can be obtained.
        :type ClusterName: str
        :param _RegionCn: Region Chinese
Note: This field may return null, indicating that no valid value can be obtained.
        :type RegionCn: str
        :param _RegionEn: Region English
Note: This field may return null, indicating that no valid value can be obtained.
        :type RegionEn: str
        :param _RegionArea: RegionNote: This field may return null, indicating that no valid value can be obtained.
        :type RegionArea: str
        :param _Used: Whether the Cluster is Used
Note: This field may return null, indicating that no valid value can be obtained.
        :type Used: bool
        :param _Status: Cluster StatusNote: This field may return null, indicating that no valid value can be obtained.
        :type Status: int
        :param _StatusInfo: Cluster State Information
Note: This field may return null, indicating that no valid value can be obtained.
        :type StatusInfo: str
        :param _StorageType: Cluster Storage Type
Note: This field may return null, indicating that no valid value can be obtained.
        :type StorageType: str
        :param _ComputeType: Cluster Computing Type
Note: This field may return null, indicating that no valid value can be obtained.
        :type ComputeType: str
        :param _ClusterResource: Cluster Resource Quantity
Note: This field may return null, indicating that no valid value can be obtained.
        :type ClusterResource: str
        :param _ChargeType: Cluster Payment Method
Note: This field may return null, indicating that no valid value can be obtained.
        :type ChargeType: str
        :param _CreateTime: Cluster Creation Time
Note: This field may return null, indicating that no valid value can be obtained.
        :type CreateTime: str
        :param _ExtraConf: Additional Configuration
Note: This field may return null, indicating that no valid value can be obtained.
        :type ExtraConf: str
        :param _RangerUserName: Ranger Account Name
Note: This field may return null, indicating that no valid value can be obtained.
        :type RangerUserName: str
        :param _CdwUserName: CDW Account (for display)
Note: This field may return null, indicating that no valid value can be obtained.
        :type CdwUserName: str
        """
        self._ClusterId = None
        self._ClusterType = None
        self._ClusterName = None
        self._RegionCn = None
        self._RegionEn = None
        self._RegionArea = None
        self._Used = None
        self._Status = None
        self._StatusInfo = None
        self._StorageType = None
        self._ComputeType = None
        self._ClusterResource = None
        self._ChargeType = None
        self._CreateTime = None
        self._ExtraConf = None
        self._RangerUserName = None
        self._CdwUserName = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterType(self):
        return self._ClusterType

    @ClusterType.setter
    def ClusterType(self, ClusterType):
        self._ClusterType = ClusterType

    @property
    def ClusterName(self):
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def RegionCn(self):
        return self._RegionCn

    @RegionCn.setter
    def RegionCn(self, RegionCn):
        self._RegionCn = RegionCn

    @property
    def RegionEn(self):
        return self._RegionEn

    @RegionEn.setter
    def RegionEn(self, RegionEn):
        self._RegionEn = RegionEn

    @property
    def RegionArea(self):
        return self._RegionArea

    @RegionArea.setter
    def RegionArea(self, RegionArea):
        self._RegionArea = RegionArea

    @property
    def Used(self):
        return self._Used

    @Used.setter
    def Used(self, Used):
        self._Used = Used

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def StatusInfo(self):
        return self._StatusInfo

    @StatusInfo.setter
    def StatusInfo(self, StatusInfo):
        self._StatusInfo = StatusInfo

    @property
    def StorageType(self):
        return self._StorageType

    @StorageType.setter
    def StorageType(self, StorageType):
        self._StorageType = StorageType

    @property
    def ComputeType(self):
        return self._ComputeType

    @ComputeType.setter
    def ComputeType(self, ComputeType):
        self._ComputeType = ComputeType

    @property
    def ClusterResource(self):
        return self._ClusterResource

    @ClusterResource.setter
    def ClusterResource(self, ClusterResource):
        self._ClusterResource = ClusterResource

    @property
    def ChargeType(self):
        return self._ChargeType

    @ChargeType.setter
    def ChargeType(self, ChargeType):
        self._ChargeType = ChargeType

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ExtraConf(self):
        return self._ExtraConf

    @ExtraConf.setter
    def ExtraConf(self, ExtraConf):
        self._ExtraConf = ExtraConf

    @property
    def RangerUserName(self):
        return self._RangerUserName

    @RangerUserName.setter
    def RangerUserName(self, RangerUserName):
        self._RangerUserName = RangerUserName

    @property
    def CdwUserName(self):
        return self._CdwUserName

    @CdwUserName.setter
    def CdwUserName(self, CdwUserName):
        self._CdwUserName = CdwUserName


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ClusterType = params.get("ClusterType")
        self._ClusterName = params.get("ClusterName")
        self._RegionCn = params.get("RegionCn")
        self._RegionEn = params.get("RegionEn")
        self._RegionArea = params.get("RegionArea")
        self._Used = params.get("Used")
        self._Status = params.get("Status")
        self._StatusInfo = params.get("StatusInfo")
        self._StorageType = params.get("StorageType")
        self._ComputeType = params.get("ComputeType")
        self._ClusterResource = params.get("ClusterResource")
        self._ChargeType = params.get("ChargeType")
        self._CreateTime = params.get("CreateTime")
        self._ExtraConf = params.get("ExtraConf")
        self._RangerUserName = params.get("RangerUserName")
        self._CdwUserName = params.get("CdwUserName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaseTenant(AbstractModel):
    """Tenant basic information

    """

    def __init__(self):
        r"""
        :param _TenantId: Tenant IDNote: This field may return null, indicating that no valid value can be obtained.
        :type TenantId: str
        :param _TenantName: Tenant ID
Note: This field may return null, indicating that no valid value can be obtained.
        :type TenantName: str
        :param _DisplayName: Tenant display name, usually the Chinese name
Note: This field may return null, indicating that no valid value can be obtained.
        :type DisplayName: str
        :param _Description: RemarksNote: This field may return null, indicating that no valid value can be obtained.
        :type Description: str
        :param _OwnerUserId: Tenant Main Account
Note: This field may return null, indicating that no valid value can be obtained.
        :type OwnerUserId: str
        :param _Params: Tenant's additional configuration parameters, in JSON format string
Note: This field may return null, indicating that no valid value can be obtained.
        :type Params: str
        """
        self._TenantId = None
        self._TenantName = None
        self._DisplayName = None
        self._Description = None
        self._OwnerUserId = None
        self._Params = None

    @property
    def TenantId(self):
        return self._TenantId

    @TenantId.setter
    def TenantId(self, TenantId):
        self._TenantId = TenantId

    @property
    def TenantName(self):
        return self._TenantName

    @TenantName.setter
    def TenantName(self, TenantName):
        self._TenantName = TenantName

    @property
    def DisplayName(self):
        return self._DisplayName

    @DisplayName.setter
    def DisplayName(self, DisplayName):
        self._DisplayName = DisplayName

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def OwnerUserId(self):
        return self._OwnerUserId

    @OwnerUserId.setter
    def OwnerUserId(self, OwnerUserId):
        self._OwnerUserId = OwnerUserId

    @property
    def Params(self):
        return self._Params

    @Params.setter
    def Params(self, Params):
        self._Params = Params


    def _deserialize(self, params):
        self._TenantId = params.get("TenantId")
        self._TenantName = params.get("TenantName")
        self._DisplayName = params.get("DisplayName")
        self._Description = params.get("Description")
        self._OwnerUserId = params.get("OwnerUserId")
        self._Params = params.get("Params")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaseUser(AbstractModel):
    """Basic User Information

    """

    def __init__(self):
        r"""
        :param _UserId: Cloud User UIN, Globally Unique
Note: This field may return null, indicating that no valid value can be obtained.
        :type UserId: str
        :param _UserName: User Global Unique Identifier
Note: This field may return null, indicating that no valid value can be obtained.
        :type UserName: str
        :param _DisplayName: User Display Name
Note: This field may return null, indicating that no valid value can be obtained.
        :type DisplayName: str
        :param _PhoneNum: Telephone Number
Note: This field may return null, indicating that no valid value can be obtained.
        :type PhoneNum: str
        :param _Email: Email
Note: This field may return null, indicating that no valid value can be obtained.
        :type Email: str
        """
        self._UserId = None
        self._UserName = None
        self._DisplayName = None
        self._PhoneNum = None
        self._Email = None

    @property
    def UserId(self):
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def UserName(self):
        return self._UserName

    @UserName.setter
    def UserName(self, UserName):
        self._UserName = UserName

    @property
    def DisplayName(self):
        return self._DisplayName

    @DisplayName.setter
    def DisplayName(self, DisplayName):
        self._DisplayName = DisplayName

    @property
    def PhoneNum(self):
        return self._PhoneNum

    @PhoneNum.setter
    def PhoneNum(self, PhoneNum):
        self._PhoneNum = PhoneNum

    @property
    def Email(self):
        return self._Email

    @Email.setter
    def Email(self, Email):
        self._Email = Email


    def _deserialize(self, params):
        self._UserId = params.get("UserId")
        self._UserName = params.get("UserName")
        self._DisplayName = params.get("DisplayName")
        self._PhoneNum = params.get("PhoneNum")
        self._Email = params.get("Email")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchCreateIntegrationTaskAlarmsRequest(AbstractModel):
    """BatchCreateIntegrationTaskAlarms request structure.

    """

    def __init__(self):
        r"""
        :param _TaskIds: Task ID.
        :type TaskIds: list of str
        :param _TaskAlarmInfo: Alert Configuration Information
        :type TaskAlarmInfo: :class:`tencentcloud.wedata.v20210820.models.TaskAlarmInfo`
        :param _ProjectId: Project ID
        :type ProjectId: str
        """
        self._TaskIds = None
        self._TaskAlarmInfo = None
        self._ProjectId = None

    @property
    def TaskIds(self):
        return self._TaskIds

    @TaskIds.setter
    def TaskIds(self, TaskIds):
        self._TaskIds = TaskIds

    @property
    def TaskAlarmInfo(self):
        return self._TaskAlarmInfo

    @TaskAlarmInfo.setter
    def TaskAlarmInfo(self, TaskAlarmInfo):
        self._TaskAlarmInfo = TaskAlarmInfo

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskIds = params.get("TaskIds")
        if params.get("TaskAlarmInfo") is not None:
            self._TaskAlarmInfo = TaskAlarmInfo()
            self._TaskAlarmInfo._deserialize(params.get("TaskAlarmInfo"))
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchCreateIntegrationTaskAlarmsResponse(AbstractModel):
    """BatchCreateIntegrationTaskAlarms response structure.

    """

    def __init__(self):
        r"""
        :param _SuccessCount: Note: This field may return null, indicating that no valid value can be obtained.
        :type SuccessCount: int
        :param _FailedCount: Note: This field may return null, indicating that no valid value can be obtained.
        :type FailedCount: int
        :param _TotalCount: Note: This field may return null, indicating that no valid value can be obtained.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SuccessCount(self):
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class BatchCreateTaskVersionDTO(AbstractModel):
    """Used by BatchCreateTaskVersion, describes task information

    """

    def __init__(self):
        r"""
        :param _TaskId: Task IDNote: This field may return null, indicating that no valid value can be obtained.
        :type TaskId: str
        :param _VersionRemark: VersionRemark
Note: This field may return null, indicating that no valid value can be obtained.
        :type VersionRemark: str
        :param _FolderId: Folder ID
Note: This field may return null, indicating that no valid value can be obtained.
        :type FolderId: str
        """
        self._TaskId = None
        self._VersionRemark = None
        self._FolderId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def VersionRemark(self):
        return self._VersionRemark

    @VersionRemark.setter
    def VersionRemark(self, VersionRemark):
        self._VersionRemark = VersionRemark

    @property
    def FolderId(self):
        return self._FolderId

    @FolderId.setter
    def FolderId(self, FolderId):
        self._FolderId = FolderId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._VersionRemark = params.get("VersionRemark")
        self._FolderId = params.get("FolderId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchDeleteIntegrationTasksRequest(AbstractModel):
    """BatchDeleteIntegrationTasks request structure.

    """

    def __init__(self):
        r"""
        :param _TaskIds: Task ID
        :type TaskIds: list of str
        :param _TaskType: Task Type, 201 for real-time tasks, 202 for offline tasks
        :type TaskType: int
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _DeleteKFFlag: Whether to delete development state tasks. By default, development state is not deleted, 0 means do not delete, 1 means delete
        :type DeleteKFFlag: int
        :param _Name: Operation Name
        :type Name: str
        :param _TaskNames: This batch operation involves tasks for auditing
        :type TaskNames: list of str
        """
        self._TaskIds = None
        self._TaskType = None
        self._ProjectId = None
        self._DeleteKFFlag = None
        self._Name = None
        self._TaskNames = None

    @property
    def TaskIds(self):
        return self._TaskIds

    @TaskIds.setter
    def TaskIds(self, TaskIds):
        self._TaskIds = TaskIds

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def DeleteKFFlag(self):
        return self._DeleteKFFlag

    @DeleteKFFlag.setter
    def DeleteKFFlag(self, DeleteKFFlag):
        self._DeleteKFFlag = DeleteKFFlag

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def TaskNames(self):
        return self._TaskNames

    @TaskNames.setter
    def TaskNames(self, TaskNames):
        self._TaskNames = TaskNames


    def _deserialize(self, params):
        self._TaskIds = params.get("TaskIds")
        self._TaskType = params.get("TaskType")
        self._ProjectId = params.get("ProjectId")
        self._DeleteKFFlag = params.get("DeleteKFFlag")
        self._Name = params.get("Name")
        self._TaskNames = params.get("TaskNames")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchDeleteIntegrationTasksResponse(AbstractModel):
    """BatchDeleteIntegrationTasks response structure.

    """

    def __init__(self):
        r"""
        :param _SuccessCount: Note: This field may return null, indicating that no valid value can be obtained.
        :type SuccessCount: int
        :param _FailedCount: Note: This field may return null, indicating that no valid value can be obtained.
        :type FailedCount: int
        :param _TotalCount: Note: This field may return null, indicating that no valid value can be obtained.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SuccessCount(self):
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class BatchDeleteOpsTasksRequest(AbstractModel):
    """BatchDeleteOpsTasks request structure.

    """

    def __init__(self):
        r"""
        :param _TaskIdList: Batch Deleted Task TaskId
        :type TaskIdList: list of str
        :param _DeleteMode: true: After deletion, downstream tasks can run normally
false: After deletion, downstream tasks cannot run
        :type DeleteMode: bool
        :param _EnableNotify: true: Notify Downstream Task Responsible Persons
false: Do Not Notify Downstream Task Responsible Persons
        :type EnableNotify: bool
        :param _ProjectId: Project ID
        :type ProjectId: str
        """
        self._TaskIdList = None
        self._DeleteMode = None
        self._EnableNotify = None
        self._ProjectId = None

    @property
    def TaskIdList(self):
        return self._TaskIdList

    @TaskIdList.setter
    def TaskIdList(self, TaskIdList):
        self._TaskIdList = TaskIdList

    @property
    def DeleteMode(self):
        return self._DeleteMode

    @DeleteMode.setter
    def DeleteMode(self, DeleteMode):
        self._DeleteMode = DeleteMode

    @property
    def EnableNotify(self):
        return self._EnableNotify

    @EnableNotify.setter
    def EnableNotify(self, EnableNotify):
        self._EnableNotify = EnableNotify

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskIdList = params.get("TaskIdList")
        self._DeleteMode = params.get("DeleteMode")
        self._EnableNotify = params.get("EnableNotify")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchDeleteOpsTasksResponse(AbstractModel):
    """BatchDeleteOpsTasks response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Returns the number of successful batch operations, the number of failures, and the total number of operations
        :type Data: :class:`tencentcloud.wedata.v20210820.models.BatchOperationOpsDto`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BatchOperationOpsDto()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class BatchForceSuccessIntegrationTaskInstancesRequest(AbstractModel):
    """BatchForceSuccessIntegrationTaskInstances request structure.

    """

    def __init__(self):
        r"""
        :param _Instances: Instance Information
        :type Instances: list of SchedulerTaskInstanceInfo
        :param _ProjectId: Project ID
        :type ProjectId: str
        """
        self._Instances = None
        self._ProjectId = None

    @property
    def Instances(self):
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = SchedulerTaskInstanceInfo()
                obj._deserialize(item)
                self._Instances.append(obj)
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchForceSuccessIntegrationTaskInstancesResponse(AbstractModel):
    """BatchForceSuccessIntegrationTaskInstances response structure.

    """

    def __init__(self):
        r"""
        :param _SuccessCount: Number of Successful Operations
        :type SuccessCount: int
        :param _FailedCount: Number of Failed Operations
        :type FailedCount: int
        :param _TotalCount: Total Number of Tasks
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SuccessCount(self):
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class BatchKillIntegrationTaskInstancesRequest(AbstractModel):
    """BatchKillIntegrationTaskInstances request structure.

    """

    def __init__(self):
        r"""
        :param _Instances: Instance Information
        :type Instances: list of SchedulerTaskInstanceInfo
        :param _ProjectId: Project ID
        :type ProjectId: str
        """
        self._Instances = None
        self._ProjectId = None

    @property
    def Instances(self):
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = SchedulerTaskInstanceInfo()
                obj._deserialize(item)
                self._Instances.append(obj)
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchKillIntegrationTaskInstancesResponse(AbstractModel):
    """BatchKillIntegrationTaskInstances response structure.

    """

    def __init__(self):
        r"""
        :param _SuccessCount: Number of Successfully Operated Tasks
        :type SuccessCount: int
        :param _FailedCount: Number of Failed Tasks
        :type FailedCount: int
        :param _TotalCount: Total Number of Tasks
        :type TotalCount: int
        :param _TaskNames: What is actually passed is taskId
Note: This field may return null, indicating that no valid value can be obtained.
        :type TaskNames: list of str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None
        self._TaskNames = None
        self._RequestId = None

    @property
    def SuccessCount(self):
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TaskNames(self):
        return self._TaskNames

    @TaskNames.setter
    def TaskNames(self, TaskNames):
        self._TaskNames = TaskNames

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        self._TaskNames = params.get("TaskNames")
        self._RequestId = params.get("RequestId")


class BatchMakeUpIntegrationTasksRequest(AbstractModel):
    """BatchMakeUpIntegrationTasks request structure.

    """

    def __init__(self):
        r"""
        :param _TaskIds: Task ID
        :type TaskIds: list of str
        :param _TaskType: Task Type, 201 for Real-time Task, 202 for Offline Task
        :type TaskType: int
        :param _StartTime: Data Supplement Start Time
        :type StartTime: str
        :param _EndTime: Data Supplement End Time
        :type EndTime: str
        :param _ProjectId: Project ID
        :type ProjectId: str
        """
        self._TaskIds = None
        self._TaskType = None
        self._StartTime = None
        self._EndTime = None
        self._ProjectId = None

    @property
    def TaskIds(self):
        return self._TaskIds

    @TaskIds.setter
    def TaskIds(self, TaskIds):
        self._TaskIds = TaskIds

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskIds = params.get("TaskIds")
        self._TaskType = params.get("TaskType")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchMakeUpIntegrationTasksResponse(AbstractModel):
    """BatchMakeUpIntegrationTasks response structure.

    """

    def __init__(self):
        r"""
        :param _SuccessCount: Number of Successfully Operated Tasks
        :type SuccessCount: int
        :param _FailedCount: Number of Failed Tasks
        :type FailedCount: int
        :param _TotalCount: Total Number of Tasks
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SuccessCount(self):
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class BatchModifyOpsOwnersRequest(AbstractModel):
    """BatchModifyOpsOwners request structure.

    """

    def __init__(self):
        r"""
        :param _TaskIdList: TaskId Array that Needs Updated Responsible Person
        :type TaskIdList: list of str
        :param _Owners: Responsible User Id Information that Needs Updating, Connect Multiple Persons in Charge with ;
        :type Owners: str
        :param _ProjectId: Project ID
        :type ProjectId: str
        """
        self._TaskIdList = None
        self._Owners = None
        self._ProjectId = None

    @property
    def TaskIdList(self):
        return self._TaskIdList

    @TaskIdList.setter
    def TaskIdList(self, TaskIdList):
        self._TaskIdList = TaskIdList

    @property
    def Owners(self):
        return self._Owners

    @Owners.setter
    def Owners(self, Owners):
        self._Owners = Owners

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskIdList = params.get("TaskIdList")
        self._Owners = params.get("Owners")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchModifyOpsOwnersResponse(AbstractModel):
    """BatchModifyOpsOwners response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Return the number of successful batch operations, the number of failures, and the total number of operations
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: :class:`tencentcloud.wedata.v20210820.models.BatchOperationOpsDto`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BatchOperationOpsDto()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class BatchOperateResult(AbstractModel):
    """Batch operation result return

    """

    def __init__(self):
        r"""
        :param _SuccessCount: Number of Batch Operations Succeeded
        :type SuccessCount: int
        :param _FailedCount: Number of Batch Operations Failed
        :type FailedCount: int
        :param _TotalCount: Total Number of Batch Operations
        :type TotalCount: int
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None

    @property
    def SuccessCount(self):
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchOperateResultOpsDto(AbstractModel):
    """Instance Batch Operation Result Class

    """

    def __init__(self):
        r"""
        :param _Result: ResultNote: This field may return null, indicating that no valid value can be obtained.
        :type Result: bool
        :param _ErrorId: Error ID
Note: This field may return null, indicating that no valid value can be obtained.
        :type ErrorId: str
        :param _ErrorDesc: Error Description
Note: This field may return null, indicating that no valid value can be obtained.
        :type ErrorDesc: str
        """
        self._Result = None
        self._ErrorId = None
        self._ErrorDesc = None

    @property
    def Result(self):
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def ErrorId(self):
        return self._ErrorId

    @ErrorId.setter
    def ErrorId(self, ErrorId):
        self._ErrorId = ErrorId

    @property
    def ErrorDesc(self):
        return self._ErrorDesc

    @ErrorDesc.setter
    def ErrorDesc(self, ErrorDesc):
        self._ErrorDesc = ErrorDesc


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._ErrorId = params.get("ErrorId")
        self._ErrorDesc = params.get("ErrorDesc")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchOperationOpsDto(AbstractModel):
    """Batch operation result return

    """

    def __init__(self):
        r"""
        :param _SuccessCount: Number of successful batch operations
Note: This field may return null, indicating that no valid value can be obtained.
        :type SuccessCount: int
        :param _FailedCount: Number of failed batch operations
Note: This field may return null, indicating that no valid value can be obtained.
        :type FailedCount: int
        :param _TotalCount: Total number of batch operations
Note: This field may return null, indicating that no valid value can be obtained.
        :type TotalCount: int
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None

    @property
    def SuccessCount(self):
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchOpsDTO(AbstractModel):
    """Batch Operation Result, with Failure Reason

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total Quantity
Note: This field may return null, indicating that no valid value can be obtained.
        :type TotalCount: int
        :param _SuccessCount: Success count
Note: This field may return null, indicating that no valid value can be obtained.
        :type SuccessCount: int
        :param _FailCount: Failure count
Note: This field may return null, indicating that no valid value can be obtained.
        :type FailCount: int
        :param _FailMessageList: Failure reason
Note: This field may return null, indicating that no valid value can be obtained.
        :type FailMessageList: list of FailMessage
        """
        self._TotalCount = None
        self._SuccessCount = None
        self._FailCount = None
        self._FailMessageList = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def SuccessCount(self):
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailCount(self):
        return self._FailCount

    @FailCount.setter
    def FailCount(self, FailCount):
        self._FailCount = FailCount

    @property
    def FailMessageList(self):
        return self._FailMessageList

    @FailMessageList.setter
    def FailMessageList(self, FailMessageList):
        self._FailMessageList = FailMessageList


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        self._SuccessCount = params.get("SuccessCount")
        self._FailCount = params.get("FailCount")
        if params.get("FailMessageList") is not None:
            self._FailMessageList = []
            for item in params.get("FailMessageList"):
                obj = FailMessage()
                obj._deserialize(item)
                self._FailMessageList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchRerunIntegrationTaskInstancesRequest(AbstractModel):
    """BatchRerunIntegrationTaskInstances request structure.

    """

    def __init__(self):
        r"""
        :param _Instances: Instance Information
        :type Instances: list of SchedulerTaskInstanceInfo
        :param _ProjectId: Project ID
        :type ProjectId: str
        """
        self._Instances = None
        self._ProjectId = None

    @property
    def Instances(self):
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = SchedulerTaskInstanceInfo()
                obj._deserialize(item)
                self._Instances.append(obj)
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchRerunIntegrationTaskInstancesResponse(AbstractModel):
    """BatchRerunIntegrationTaskInstances response structure.

    """

    def __init__(self):
        r"""
        :param _SuccessCount: Number of Successfully Operated Tasks
        :type SuccessCount: int
        :param _FailedCount: Number of Failed Tasks
        :type FailedCount: int
        :param _TotalCount: Total Number of Tasks
        :type TotalCount: int
        :param _TaskNames: What is actually passed is taskId
        :type TaskNames: list of str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None
        self._TaskNames = None
        self._RequestId = None

    @property
    def SuccessCount(self):
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TaskNames(self):
        return self._TaskNames

    @TaskNames.setter
    def TaskNames(self, TaskNames):
        self._TaskNames = TaskNames

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        self._TaskNames = params.get("TaskNames")
        self._RequestId = params.get("RequestId")


class BatchResult(AbstractModel):
    """Batch Operation Result

    """

    def __init__(self):
        r"""
        :param _Running: Number of Tasks Running
        :type Running: int
        :param _Success: Number of Tasks Executed Successfully
        :type Success: int
        :param _Failed: Number of Tasks Executed Failed
        :type Failed: int
        :param _Total: Total Tasks
        :type Total: int
        """
        self._Running = None
        self._Success = None
        self._Failed = None
        self._Total = None

    @property
    def Running(self):
        return self._Running

    @Running.setter
    def Running(self, Running):
        self._Running = Running

    @property
    def Success(self):
        return self._Success

    @Success.setter
    def Success(self, Success):
        self._Success = Success

    @property
    def Failed(self):
        return self._Failed

    @Failed.setter
    def Failed(self, Failed):
        self._Failed = Failed

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total


    def _deserialize(self, params):
        self._Running = params.get("Running")
        self._Success = params.get("Success")
        self._Failed = params.get("Failed")
        self._Total = params.get("Total")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchResumeIntegrationTasksRequest(AbstractModel):
    """BatchResumeIntegrationTasks request structure.

    """

    def __init__(self):
        r"""
        :param _TaskIds: Task ID
        :type TaskIds: list of str
        :param _TaskType: Task Type, 201 for Real-time Task, 202 for Offline Task
        :type TaskType: int
        :param _ProjectId: Project ID
        :type ProjectId: str
        """
        self._TaskIds = None
        self._TaskType = None
        self._ProjectId = None

    @property
    def TaskIds(self):
        return self._TaskIds

    @TaskIds.setter
    def TaskIds(self, TaskIds):
        self._TaskIds = TaskIds

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskIds = params.get("TaskIds")
        self._TaskType = params.get("TaskType")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchResumeIntegrationTasksResponse(AbstractModel):
    """BatchResumeIntegrationTasks response structure.

    """

    def __init__(self):
        r"""
        :param _SuccessCount: Number of Successfully Operated Tasks
        :type SuccessCount: int
        :param _FailedCount: Number of Failed Tasks
        :type FailedCount: int
        :param _TotalCount: Total Number of Tasks
        :type TotalCount: int
        :param _TaskNames: This batch operation involves tasks for auditing
        :type TaskNames: list of str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None
        self._TaskNames = None
        self._RequestId = None

    @property
    def SuccessCount(self):
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TaskNames(self):
        return self._TaskNames

    @TaskNames.setter
    def TaskNames(self, TaskNames):
        self._TaskNames = TaskNames

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        self._TaskNames = params.get("TaskNames")
        self._RequestId = params.get("RequestId")


class BatchReturn(AbstractModel):
    """Operation result

    """

    def __init__(self):
        r"""
        :param _Result: Execution Result
        :type Result: bool
        :param _ErrorDesc: Execution remarks
Note: This field may return null, indicating that no valid value can be obtained.
        :type ErrorDesc: str
        :param _ErrorId: Execution ID
Note: This field may return null, indicating that no valid value can be obtained.
        :type ErrorId: str
        """
        self._Result = None
        self._ErrorDesc = None
        self._ErrorId = None

    @property
    def Result(self):
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def ErrorDesc(self):
        return self._ErrorDesc

    @ErrorDesc.setter
    def ErrorDesc(self, ErrorDesc):
        self._ErrorDesc = ErrorDesc

    @property
    def ErrorId(self):
        return self._ErrorId

    @ErrorId.setter
    def ErrorId(self, ErrorId):
        self._ErrorId = ErrorId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._ErrorDesc = params.get("ErrorDesc")
        self._ErrorId = params.get("ErrorId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchRunOpsTaskRequest(AbstractModel):
    """BatchRunOpsTask request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _EnableMakeUp: Whether to Supplement Intermediate Instances, 0 for not supplementing; 1 for supplementing
        :type EnableMakeUp: int
        :param _Tasks: Task ID list
        :type Tasks: list of str
        """
        self._ProjectId = None
        self._EnableMakeUp = None
        self._Tasks = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def EnableMakeUp(self):
        return self._EnableMakeUp

    @EnableMakeUp.setter
    def EnableMakeUp(self, EnableMakeUp):
        self._EnableMakeUp = EnableMakeUp

    @property
    def Tasks(self):
        return self._Tasks

    @Tasks.setter
    def Tasks(self, Tasks):
        self._Tasks = Tasks


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._EnableMakeUp = params.get("EnableMakeUp")
        self._Tasks = params.get("Tasks")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchRunOpsTaskResponse(AbstractModel):
    """BatchRunOpsTask response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Operation resultNote: This field may return null, indicating that no valid value can be obtained.
        :type Data: bool
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class BatchStartIntegrationTasksRequest(AbstractModel):
    """BatchStartIntegrationTasks request structure.

    """

    def __init__(self):
        r"""
        :param _TaskType: Task Type, 201 for real-time tasks, 202 for offline tasks
        :type TaskType: int
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _TaskIds: Task ID
        :type TaskIds: list of str
        :param _StartTaskInfoSet: Batch run integration tasks, currently only used in real-time integration
        :type StartTaskInfoSet: list of StartTaskInfo
        """
        self._TaskType = None
        self._ProjectId = None
        self._TaskIds = None
        self._StartTaskInfoSet = None

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskIds(self):
        return self._TaskIds

    @TaskIds.setter
    def TaskIds(self, TaskIds):
        self._TaskIds = TaskIds

    @property
    def StartTaskInfoSet(self):
        return self._StartTaskInfoSet

    @StartTaskInfoSet.setter
    def StartTaskInfoSet(self, StartTaskInfoSet):
        self._StartTaskInfoSet = StartTaskInfoSet


    def _deserialize(self, params):
        self._TaskType = params.get("TaskType")
        self._ProjectId = params.get("ProjectId")
        self._TaskIds = params.get("TaskIds")
        if params.get("StartTaskInfoSet") is not None:
            self._StartTaskInfoSet = []
            for item in params.get("StartTaskInfoSet"):
                obj = StartTaskInfo()
                obj._deserialize(item)
                self._StartTaskInfoSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchStartIntegrationTasksResponse(AbstractModel):
    """BatchStartIntegrationTasks response structure.

    """

    def __init__(self):
        r"""
        :param _SuccessCount: Number of Successfully Operated Tasks
        :type SuccessCount: int
        :param _FailedCount: Number of Failed Tasks
        :type FailedCount: int
        :param _TotalCount: Total Number of Tasks
        :type TotalCount: int
        :param _TaskNames: Batch operation successful task IDs for audit
        :type TaskNames: list of str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None
        self._TaskNames = None
        self._RequestId = None

    @property
    def SuccessCount(self):
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TaskNames(self):
        return self._TaskNames

    @TaskNames.setter
    def TaskNames(self, TaskNames):
        self._TaskNames = TaskNames

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        self._TaskNames = params.get("TaskNames")
        self._RequestId = params.get("RequestId")


class BatchStopIntegrationTasksRequest(AbstractModel):
    """BatchStopIntegrationTasks request structure.

    """

    def __init__(self):
        r"""
        :param _TaskIds: Task ID
        :type TaskIds: list of str
        :param _TaskType: Task Type, 201 for real-time tasks, 202 for offline tasks
        :type TaskType: int
        :param _ProjectId: Project ID
        :type ProjectId: str
        """
        self._TaskIds = None
        self._TaskType = None
        self._ProjectId = None

    @property
    def TaskIds(self):
        return self._TaskIds

    @TaskIds.setter
    def TaskIds(self, TaskIds):
        self._TaskIds = TaskIds

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskIds = params.get("TaskIds")
        self._TaskType = params.get("TaskType")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchStopIntegrationTasksResponse(AbstractModel):
    """BatchStopIntegrationTasks response structure.

    """

    def __init__(self):
        r"""
        :param _SuccessCount: Number of Successful Operations
        :type SuccessCount: int
        :param _FailedCount: Number of Failed Operations
        :type FailedCount: int
        :param _TotalCount: Total Number of Tasks
        :type TotalCount: int
        :param _TaskNames: Number of successful tasks involved in this batch operation, for auditing
        :type TaskNames: list of str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None
        self._TaskNames = None
        self._RequestId = None

    @property
    def SuccessCount(self):
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TaskNames(self):
        return self._TaskNames

    @TaskNames.setter
    def TaskNames(self, TaskNames):
        self._TaskNames = TaskNames

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        self._TaskNames = params.get("TaskNames")
        self._RequestId = params.get("RequestId")


class BatchStopOpsTasksRequest(AbstractModel):
    """BatchStopOpsTasks request structure.

    """

    def __init__(self):
        r"""
        :param _TaskIdList: TaskId for batch stop tasks
        :type TaskIdList: list of str
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _KillInstance: Whether to terminate the generated instance
        :type KillInstance: bool
        """
        self._TaskIdList = None
        self._ProjectId = None
        self._KillInstance = None

    @property
    def TaskIdList(self):
        return self._TaskIdList

    @TaskIdList.setter
    def TaskIdList(self, TaskIdList):
        self._TaskIdList = TaskIdList

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def KillInstance(self):
        return self._KillInstance

    @KillInstance.setter
    def KillInstance(self, KillInstance):
        self._KillInstance = KillInstance


    def _deserialize(self, params):
        self._TaskIdList = params.get("TaskIdList")
        self._ProjectId = params.get("ProjectId")
        self._KillInstance = params.get("KillInstance")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchStopOpsTasksResponse(AbstractModel):
    """BatchStopOpsTasks response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Returns the number of successful batch operations, the number of failures, and the total number of operations
        :type Data: :class:`tencentcloud.wedata.v20210820.models.BatchOperationOpsDto`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BatchOperationOpsDto()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class BatchStopWorkflowsByIdsRequest(AbstractModel):
    """BatchStopWorkflowsByIds request structure.

    """

    def __init__(self):
        r"""
        :param _WorkflowIds: Workflow ID List
        :type WorkflowIds: list of str
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _KillInstance: Whether to terminate the generated instance
        :type KillInstance: bool
        """
        self._WorkflowIds = None
        self._ProjectId = None
        self._KillInstance = None

    @property
    def WorkflowIds(self):
        return self._WorkflowIds

    @WorkflowIds.setter
    def WorkflowIds(self, WorkflowIds):
        self._WorkflowIds = WorkflowIds

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def KillInstance(self):
        return self._KillInstance

    @KillInstance.setter
    def KillInstance(self, KillInstance):
        self._KillInstance = KillInstance


    def _deserialize(self, params):
        self._WorkflowIds = params.get("WorkflowIds")
        self._ProjectId = params.get("ProjectId")
        self._KillInstance = params.get("KillInstance")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchStopWorkflowsByIdsResponse(AbstractModel):
    """BatchStopWorkflowsByIds response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Operation ResultNote: This field may return null, indicating that no valid value can be obtained.
        :type Data: :class:`tencentcloud.wedata.v20210820.models.OperationOpsDto`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = OperationOpsDto()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class BatchSuspendIntegrationTasksRequest(AbstractModel):
    """BatchSuspendIntegrationTasks request structure.

    """

    def __init__(self):
        r"""
        :param _TaskIds: Task ID
        :type TaskIds: list of str
        :param _TaskType: Task Type, 201 for real-time tasks, 202 for offline tasks
        :type TaskType: int
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _Event: Event Type (START, STOP, SUSPEND, SUSPEND_WITHOUT_SP, RESUME, COMMIT, TIMESTAMP)	
        :type Event: str
        :param _TaskNames: This batch operation involves tasks for auditing
        :type TaskNames: list of str
        """
        self._TaskIds = None
        self._TaskType = None
        self._ProjectId = None
        self._Event = None
        self._TaskNames = None

    @property
    def TaskIds(self):
        return self._TaskIds

    @TaskIds.setter
    def TaskIds(self, TaskIds):
        self._TaskIds = TaskIds

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Event(self):
        return self._Event

    @Event.setter
    def Event(self, Event):
        self._Event = Event

    @property
    def TaskNames(self):
        return self._TaskNames

    @TaskNames.setter
    def TaskNames(self, TaskNames):
        self._TaskNames = TaskNames


    def _deserialize(self, params):
        self._TaskIds = params.get("TaskIds")
        self._TaskType = params.get("TaskType")
        self._ProjectId = params.get("ProjectId")
        self._Event = params.get("Event")
        self._TaskNames = params.get("TaskNames")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchSuspendIntegrationTasksResponse(AbstractModel):
    """BatchSuspendIntegrationTasks response structure.

    """

    def __init__(self):
        r"""
        :param _SuccessCount: Number of Successfully Operated Tasks
        :type SuccessCount: int
        :param _FailedCount: Number of Failed Tasks
        :type FailedCount: int
        :param _TotalCount: Total Number of Tasks
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SuccessCount(self):
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class BatchUpdateIntegrationTasksRequest(AbstractModel):
    """BatchUpdateIntegrationTasks request structure.

    """

    def __init__(self):
        r"""
        :param _TaskIds: Task ID
        :type TaskIds: list of str
        :param _Incharge: Person in Charge (separate multiple persons in charge with a lowercase semicolon; offline tasks use the account name, real-time tasks use the account ID)
        :type Incharge: str
        :param _TaskType: Task Type
        :type TaskType: int
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _InchargeIds: Responsible Person ID (separate multiple persons in charge with a lowercase semicolon)
        :type InchargeIds: str
        :param _TaskNames: This batch operation involves tasks for auditing
        :type TaskNames: list of str
        """
        self._TaskIds = None
        self._Incharge = None
        self._TaskType = None
        self._ProjectId = None
        self._InchargeIds = None
        self._TaskNames = None

    @property
    def TaskIds(self):
        return self._TaskIds

    @TaskIds.setter
    def TaskIds(self, TaskIds):
        self._TaskIds = TaskIds

    @property
    def Incharge(self):
        return self._Incharge

    @Incharge.setter
    def Incharge(self, Incharge):
        self._Incharge = Incharge

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def InchargeIds(self):
        return self._InchargeIds

    @InchargeIds.setter
    def InchargeIds(self, InchargeIds):
        self._InchargeIds = InchargeIds

    @property
    def TaskNames(self):
        return self._TaskNames

    @TaskNames.setter
    def TaskNames(self, TaskNames):
        self._TaskNames = TaskNames


    def _deserialize(self, params):
        self._TaskIds = params.get("TaskIds")
        self._Incharge = params.get("Incharge")
        self._TaskType = params.get("TaskType")
        self._ProjectId = params.get("ProjectId")
        self._InchargeIds = params.get("InchargeIds")
        self._TaskNames = params.get("TaskNames")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchUpdateIntegrationTasksResponse(AbstractModel):
    """BatchUpdateIntegrationTasks response structure.

    """

    def __init__(self):
        r"""
        :param _SuccessCount: Number of Successful Operations
        :type SuccessCount: int
        :param _FailedCount: Number of Failed Operations
        :type FailedCount: int
        :param _TotalCount: Total Number of Tasks
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SuccessCount(self):
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class BytesSpeed(AbstractModel):
    """Real-time task synchronization speed Bytes/s

    """

    def __init__(self):
        r"""
        :param _NodeType: Node TypeNote: This field may return null, indicating that no valid value can be obtained.
        :type NodeType: str
        :param _NodeName: Node nameNote: This field may return null, indicating that no valid value can be obtained.
        :type NodeName: str
        :param _Values: Speed value list
Note: This field may return null, indicating that no valid value can be obtained.
        :type Values: list of SpeedValue
        """
        self._NodeType = None
        self._NodeName = None
        self._Values = None

    @property
    def NodeType(self):
        return self._NodeType

    @NodeType.setter
    def NodeType(self, NodeType):
        self._NodeType = NodeType

    @property
    def NodeName(self):
        return self._NodeName

    @NodeName.setter
    def NodeName(self, NodeName):
        self._NodeName = NodeName

    @property
    def Values(self):
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values


    def _deserialize(self, params):
        self._NodeType = params.get("NodeType")
        self._NodeName = params.get("NodeName")
        if params.get("Values") is not None:
            self._Values = []
            for item in params.get("Values"):
                obj = SpeedValue()
                obj._deserialize(item)
                self._Values.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckAlarmRegularNameExistRequest(AbstractModel):
    """CheckAlarmRegularNameExist request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project name
        :type ProjectId: str
        :param _AlarmRegularName: Rule name
        :type AlarmRegularName: str
        :param _TaskId: Task ID
        :type TaskId: str
        :param _Id: Primary key ID
        :type Id: str
        :param _TaskType: Task type: 201.Real-time, 202.Offline
        :type TaskType: int
        :param _MonitorType: Monitored Object Type (1: All Tasks, 2: Assigned Task, 3: Designated Responsible Person, 4: Specified Resource Group)
        :type MonitorType: int
        """
        self._ProjectId = None
        self._AlarmRegularName = None
        self._TaskId = None
        self._Id = None
        self._TaskType = None
        self._MonitorType = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def AlarmRegularName(self):
        return self._AlarmRegularName

    @AlarmRegularName.setter
    def AlarmRegularName(self, AlarmRegularName):
        self._AlarmRegularName = AlarmRegularName

    @property
    def TaskId(self):
        warnings.warn("parameter `TaskId` is deprecated", DeprecationWarning) 

        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        warnings.warn("parameter `TaskId` is deprecated", DeprecationWarning) 

        self._TaskId = TaskId

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def MonitorType(self):
        return self._MonitorType

    @MonitorType.setter
    def MonitorType(self, MonitorType):
        self._MonitorType = MonitorType


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._AlarmRegularName = params.get("AlarmRegularName")
        self._TaskId = params.get("TaskId")
        self._Id = params.get("Id")
        self._TaskType = params.get("TaskType")
        self._MonitorType = params.get("MonitorType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckAlarmRegularNameExistResponse(AbstractModel):
    """CheckAlarmRegularNameExist response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Whether there are duplicate names
        :type Data: bool
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CheckIntegrationNodeNameExistsRequest(AbstractModel):
    """CheckIntegrationNodeNameExists request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID
        :type TaskId: str
        :param _Name: Node name
        :type Name: str
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _Id: Node ID
        :type Id: int
        """
        self._TaskId = None
        self._Name = None
        self._ProjectId = None
        self._Id = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Name = params.get("Name")
        self._ProjectId = params.get("ProjectId")
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckIntegrationNodeNameExistsResponse(AbstractModel):
    """CheckIntegrationNodeNameExists response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Return true means it exists, return false means it does not exist
        :type Data: bool
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CheckIntegrationTaskNameExistsRequest(AbstractModel):
    """CheckIntegrationTaskNameExists request structure.

    """

    def __init__(self):
        r"""
        :param _TaskName: Task Name
        :type TaskName: str
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _TaskId: Task ID
        :type TaskId: str
        :param _SyncType: Synchronization Type 1. Single Table Synchronization, 2. Solution
        :type SyncType: int
        """
        self._TaskName = None
        self._ProjectId = None
        self._TaskId = None
        self._SyncType = None

    @property
    def TaskName(self):
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def SyncType(self):
        return self._SyncType

    @SyncType.setter
    def SyncType(self, SyncType):
        self._SyncType = SyncType


    def _deserialize(self, params):
        self._TaskName = params.get("TaskName")
        self._ProjectId = params.get("ProjectId")
        self._TaskId = params.get("TaskId")
        self._SyncType = params.get("SyncType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckIntegrationTaskNameExistsResponse(AbstractModel):
    """CheckIntegrationTaskNameExists response structure.

    """

    def __init__(self):
        r"""
        :param _Data: true indicates it exists, false indicates it does not exist
        :type Data: bool
        :param _ExistsType: Task Name Duplication Type (0: Not duplicated, 1: Duplicated in development state, 2: Duplicated in production state)
        :type ExistsType: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._ExistsType = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def ExistsType(self):
        return self._ExistsType

    @ExistsType.setter
    def ExistsType(self, ExistsType):
        self._ExistsType = ExistsType

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._ExistsType = params.get("ExistsType")
        self._RequestId = params.get("RequestId")


class CheckTaskNameExistRequest(AbstractModel):
    """CheckTaskNameExist request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID/Workspace ID
        :type ProjectId: str
        :param _TypeId: Task Type (consistent with scheduling parameters)
        :type TypeId: int
        :param _TaskName: Task Name
        :type TaskName: str
        """
        self._ProjectId = None
        self._TypeId = None
        self._TaskName = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TypeId(self):
        return self._TypeId

    @TypeId.setter
    def TypeId(self, TypeId):
        self._TypeId = TypeId

    @property
    def TaskName(self):
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TypeId = params.get("TypeId")
        self._TaskName = params.get("TaskName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckTaskNameExistResponse(AbstractModel):
    """CheckTaskNameExist response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Result
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: bool
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CollectionFolderOpsDto(AbstractModel):
    """Folder List

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total numberNote: This field may return null, indicating that no valid value can be obtained.
        :type TotalCount: int
        :param _TotalPage: Total number of pages
Note: This field may return null, indicating that no valid value can be obtained.
        :type TotalPage: int
        :param _PageCount: Current Page Number
Note: This field may return null, indicating that no valid value can be obtained.
        :type PageCount: int
        :param _PageNumber: Page Number
Note: This field may return null, indicating that no valid value can be obtained.
        :type PageNumber: int
        :param _PageSize: Quantity per page
Note: This field may return null, indicating that no valid value can be obtained.
        :type PageSize: int
        :param _Items: Task InformationNote: This field may return null, indicating that no valid value can be obtained.
        :type Items: list of FolderOpsDto
        """
        self._TotalCount = None
        self._TotalPage = None
        self._PageCount = None
        self._PageNumber = None
        self._PageSize = None
        self._Items = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TotalPage(self):
        return self._TotalPage

    @TotalPage.setter
    def TotalPage(self, TotalPage):
        self._TotalPage = TotalPage

    @property
    def PageCount(self):
        return self._PageCount

    @PageCount.setter
    def PageCount(self, PageCount):
        self._PageCount = PageCount

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        self._TotalPage = params.get("TotalPage")
        self._PageCount = params.get("PageCount")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = FolderOpsDto()
                obj._deserialize(item)
                self._Items.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CollectionInstanceOpsDto(AbstractModel):
    """Instance List Structure

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total numberNote: This field may return null, indicating that no valid value can be obtained.
        :type TotalCount: int
        :param _TotalPage: Total Number of Pages
Note: This field may return null, indicating that no valid value can be obtained.
        :type TotalPage: int
        :param _PageCount: Current Page Number
Note: This field may return null, indicating that no valid value can be obtained.
        :type PageCount: int
        :param _PageNumber: Page Number
Note: This field may return null, indicating that no valid value can be obtained.
        :type PageNumber: int
        :param _PageSize: Quantity per page
Note: This field may return null, indicating that no valid value can be obtained.
        :type PageSize: int
        :param _Items: Instance InformationNote: This field may return null, indicating that no valid value can be obtained.
        :type Items: list of InstanceOpsDto
        """
        self._TotalCount = None
        self._TotalPage = None
        self._PageCount = None
        self._PageNumber = None
        self._PageSize = None
        self._Items = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TotalPage(self):
        return self._TotalPage

    @TotalPage.setter
    def TotalPage(self, TotalPage):
        self._TotalPage = TotalPage

    @property
    def PageCount(self):
        return self._PageCount

    @PageCount.setter
    def PageCount(self, PageCount):
        self._PageCount = PageCount

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        self._TotalPage = params.get("TotalPage")
        self._PageCount = params.get("PageCount")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = InstanceOpsDto()
                obj._deserialize(item)
                self._Items.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ColumnAggregationLineage(AbstractModel):
    """Column Lineage Aggregation Information

    """

    def __init__(self):
        r"""
        :param _TableName: Table nameNote: This field may return null, indicating that no valid value can be obtained.
        :type TableName: str
        :param _ParentId: Parent Node ID
Note: This field may return null, indicating that no valid value can be obtained.
        :type ParentId: str
        :param _MetastoreType: Metadata Type
Note: This field may return null, indicating that no valid value can be obtained.
        :type MetastoreType: str
        :param _ParentSet: String Type Parent Node Collection
Note: This field may return null, indicating that no valid value can be obtained.
        :type ParentSet: str
        :param _ChildSet: String Type Child Node Collection
Note: This field may return null, indicating that no valid value can be obtained.
        :type ChildSet: str
        :param _ColumnInfoSet: Column Information Collection
Note: This field may return null, indicating that no valid value can be obtained.
        :type ColumnInfoSet: list of SimpleColumnInfo
        """
        self._TableName = None
        self._ParentId = None
        self._MetastoreType = None
        self._ParentSet = None
        self._ChildSet = None
        self._ColumnInfoSet = None

    @property
    def TableName(self):
        return self._TableName

    @TableName.setter
    def TableName(self, TableName):
        self._TableName = TableName

    @property
    def ParentId(self):
        return self._ParentId

    @ParentId.setter
    def ParentId(self, ParentId):
        self._ParentId = ParentId

    @property
    def MetastoreType(self):
        return self._MetastoreType

    @MetastoreType.setter
    def MetastoreType(self, MetastoreType):
        self._MetastoreType = MetastoreType

    @property
    def ParentSet(self):
        return self._ParentSet

    @ParentSet.setter
    def ParentSet(self, ParentSet):
        self._ParentSet = ParentSet

    @property
    def ChildSet(self):
        return self._ChildSet

    @ChildSet.setter
    def ChildSet(self, ChildSet):
        self._ChildSet = ChildSet

    @property
    def ColumnInfoSet(self):
        return self._ColumnInfoSet

    @ColumnInfoSet.setter
    def ColumnInfoSet(self, ColumnInfoSet):
        self._ColumnInfoSet = ColumnInfoSet


    def _deserialize(self, params):
        self._TableName = params.get("TableName")
        self._ParentId = params.get("ParentId")
        self._MetastoreType = params.get("MetastoreType")
        self._ParentSet = params.get("ParentSet")
        self._ChildSet = params.get("ChildSet")
        if params.get("ColumnInfoSet") is not None:
            self._ColumnInfoSet = []
            for item in params.get("ColumnInfoSet"):
                obj = SimpleColumnInfo()
                obj._deserialize(item)
                self._ColumnInfoSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ColumnBasicInfo(AbstractModel):
    """Table Metadata Information

    """

    def __init__(self):
        r"""
        :param _TableId: Table's Globally Unique ID
Note: This field may return null, indicating that no valid value can be obtained.
        :type TableId: str
        :param _DatasourceId: Data Source Globally Unique ID
Note: This field may return null, indicating that no valid value can be obtained.
        :type DatasourceId: str
        :param _DatasourceName: Data Source Name
Note: This field may return null, indicating that no valid value can be obtained.
        :type DatasourceName: str
        :param _DatabaseId: Database ID
Note: This field may return null, indicating that no valid value can be obtained.
        :type DatabaseId: str
        :param _DatabaseName: Database nameNote: This field may return null, indicating that no valid value can be obtained.
        :type DatabaseName: str
        :param _TableName: Table Name
Note: This field may return null, indicating that no valid value can be obtained.
        :type TableName: str
        :param _ColumnName: Field NameNote: This field may return null, indicating that no valid value can be obtained.
        :type ColumnName: str
        :param _DataType: Data Type, such as string/int etc.
Note: This field may return null, indicating that no valid value can be obtained.
        :type DataType: str
        :param _ColumnType: Field Type, such as varchar(32)/int(10) etc.
Note: This field may return null, indicating that no valid value can be obtained.
        :type ColumnType: str
        :param _ColumnDefault: Field Default Value
Note: This field may return null, indicating that no valid value can be obtained.
        :type ColumnDefault: str
        :param _ColumnKey: Index Type, such as PRI/MUL/PARTITION etc., For normal fields, this value is an empty string
Note: This field may return null, indicating that no valid value can be obtained.
        :type ColumnKey: str
        :param _ColumnPosition: Field Order Identifier
Note: This field may return null, indicating that no valid value can be obtained.
        :type ColumnPosition: int
        :param _ColumnComment: Field Comment
Note: This field may return null, indicating that no valid value can be obtained.
        :type ColumnComment: str
        :param _StoreType: Data TypeNote: This field may return null, indicating that no valid value can be obtained.
        :type StoreType: str
        :param _ProjectId: Project ID
Note: This field may return null, indicating that no valid value can be obtained.
        :type ProjectId: str
        :param _ProjectName: Project Name in English
Note: This field may return null, indicating that no valid value can be obtained.
        :type ProjectName: str
        :param _ProjectDisplayName: Project Name in Chinese
Note: This field may return null, indicating that no valid value can be obtained.
        :type ProjectDisplayName: str
        :param _CreateTime: Creation TimeNote: This field may return null, indicating that no valid value can be obtained.
        :type CreateTime: str
        :param _UpdateTime: Update timeNote: This field may return null, indicating that no valid value can be obtained.
        :type UpdateTime: str
        :param _Scale: Precision
Note: This field may return null, indicating that no valid value can be obtained.
        :type Scale: int
        """
        self._TableId = None
        self._DatasourceId = None
        self._DatasourceName = None
        self._DatabaseId = None
        self._DatabaseName = None
        self._TableName = None
        self._ColumnName = None
        self._DataType = None
        self._ColumnType = None
        self._ColumnDefault = None
        self._ColumnKey = None
        self._ColumnPosition = None
        self._ColumnComment = None
        self._StoreType = None
        self._ProjectId = None
        self._ProjectName = None
        self._ProjectDisplayName = None
        self._CreateTime = None
        self._UpdateTime = None
        self._Scale = None

    @property
    def TableId(self):
        return self._TableId

    @TableId.setter
    def TableId(self, TableId):
        self._TableId = TableId

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def DatasourceName(self):
        return self._DatasourceName

    @DatasourceName.setter
    def DatasourceName(self, DatasourceName):
        self._DatasourceName = DatasourceName

    @property
    def DatabaseId(self):
        return self._DatabaseId

    @DatabaseId.setter
    def DatabaseId(self, DatabaseId):
        self._DatabaseId = DatabaseId

    @property
    def DatabaseName(self):
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def TableName(self):
        return self._TableName

    @TableName.setter
    def TableName(self, TableName):
        self._TableName = TableName

    @property
    def ColumnName(self):
        return self._ColumnName

    @ColumnName.setter
    def ColumnName(self, ColumnName):
        self._ColumnName = ColumnName

    @property
    def DataType(self):
        return self._DataType

    @DataType.setter
    def DataType(self, DataType):
        self._DataType = DataType

    @property
    def ColumnType(self):
        return self._ColumnType

    @ColumnType.setter
    def ColumnType(self, ColumnType):
        self._ColumnType = ColumnType

    @property
    def ColumnDefault(self):
        return self._ColumnDefault

    @ColumnDefault.setter
    def ColumnDefault(self, ColumnDefault):
        self._ColumnDefault = ColumnDefault

    @property
    def ColumnKey(self):
        return self._ColumnKey

    @ColumnKey.setter
    def ColumnKey(self, ColumnKey):
        self._ColumnKey = ColumnKey

    @property
    def ColumnPosition(self):
        return self._ColumnPosition

    @ColumnPosition.setter
    def ColumnPosition(self, ColumnPosition):
        self._ColumnPosition = ColumnPosition

    @property
    def ColumnComment(self):
        return self._ColumnComment

    @ColumnComment.setter
    def ColumnComment(self, ColumnComment):
        self._ColumnComment = ColumnComment

    @property
    def StoreType(self):
        return self._StoreType

    @StoreType.setter
    def StoreType(self, StoreType):
        self._StoreType = StoreType

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ProjectName(self):
        return self._ProjectName

    @ProjectName.setter
    def ProjectName(self, ProjectName):
        self._ProjectName = ProjectName

    @property
    def ProjectDisplayName(self):
        return self._ProjectDisplayName

    @ProjectDisplayName.setter
    def ProjectDisplayName(self, ProjectDisplayName):
        self._ProjectDisplayName = ProjectDisplayName

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def Scale(self):
        return self._Scale

    @Scale.setter
    def Scale(self, Scale):
        self._Scale = Scale


    def _deserialize(self, params):
        self._TableId = params.get("TableId")
        self._DatasourceId = params.get("DatasourceId")
        self._DatasourceName = params.get("DatasourceName")
        self._DatabaseId = params.get("DatabaseId")
        self._DatabaseName = params.get("DatabaseName")
        self._TableName = params.get("TableName")
        self._ColumnName = params.get("ColumnName")
        self._DataType = params.get("DataType")
        self._ColumnType = params.get("ColumnType")
        self._ColumnDefault = params.get("ColumnDefault")
        self._ColumnKey = params.get("ColumnKey")
        self._ColumnPosition = params.get("ColumnPosition")
        self._ColumnComment = params.get("ColumnComment")
        self._StoreType = params.get("StoreType")
        self._ProjectId = params.get("ProjectId")
        self._ProjectName = params.get("ProjectName")
        self._ProjectDisplayName = params.get("ProjectDisplayName")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._Scale = params.get("Scale")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ColumnData(AbstractModel):
    """ColumnItem

    """

    def __init__(self):
        r"""
        :param _EventName: ColumnName1
Note: This field may return null, indicating that no valid value can be obtained.
        :type EventName: str
        :param _EventProjectName: ColumnName1
Note: This field may return null, indicating that no valid value can be obtained.
        :type EventProjectName: str
        :param _Type: 1
Note: This field may return null, indicating that no valid value can be obtained.
        :type Type: str
        :param _CurRunDate: 1
Note: This field may return null, indicating that no valid value can be obtained.
        :type CurRunDate: str
        :param _TaskId: 1
Note: This field may return null, indicating that no valid value can be obtained.
        :type TaskId: str
        :param _State: 1
Note: This field may return null, indicating that no valid value can be obtained.
        :type State: str
        :param _EventType: 1
Note: This field may return null, indicating that no valid value can be obtained.
        :type EventType: str
        :param _TaskName: Task NameNote: This field may return null, indicating that no valid value can be obtained.
        :type TaskName: str
        :param _ProjectName: Project nameNote: This field may return null, indicating that no valid value can be obtained.
        :type ProjectName: str
        :param _ProjectId: Project IDNote: This field may return null, indicating that no valid value can be obtained.
        :type ProjectId: str
        """
        self._EventName = None
        self._EventProjectName = None
        self._Type = None
        self._CurRunDate = None
        self._TaskId = None
        self._State = None
        self._EventType = None
        self._TaskName = None
        self._ProjectName = None
        self._ProjectId = None

    @property
    def EventName(self):
        return self._EventName

    @EventName.setter
    def EventName(self, EventName):
        self._EventName = EventName

    @property
    def EventProjectName(self):
        return self._EventProjectName

    @EventProjectName.setter
    def EventProjectName(self, EventProjectName):
        self._EventProjectName = EventProjectName

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def CurRunDate(self):
        return self._CurRunDate

    @CurRunDate.setter
    def CurRunDate(self, CurRunDate):
        self._CurRunDate = CurRunDate

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def State(self):
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def EventType(self):
        return self._EventType

    @EventType.setter
    def EventType(self, EventType):
        self._EventType = EventType

    @property
    def TaskName(self):
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def ProjectName(self):
        return self._ProjectName

    @ProjectName.setter
    def ProjectName(self, ProjectName):
        self._ProjectName = ProjectName

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._EventName = params.get("EventName")
        self._EventProjectName = params.get("EventProjectName")
        self._Type = params.get("Type")
        self._CurRunDate = params.get("CurRunDate")
        self._TaskId = params.get("TaskId")
        self._State = params.get("State")
        self._EventType = params.get("EventType")
        self._TaskName = params.get("TaskName")
        self._ProjectName = params.get("ProjectName")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ColumnItem(AbstractModel):
    """ColumnItem

    """

    def __init__(self):
        r"""
        :param _ColumnName: ColumnName1
Note: This field may return null, indicating that no valid value can be obtained.
        :type ColumnName: str
        :param _ColumnRef: ColumnName1
Note: This field may return null, indicating that no valid value can be obtained.
        :type ColumnRef: str
        """
        self._ColumnName = None
        self._ColumnRef = None

    @property
    def ColumnName(self):
        return self._ColumnName

    @ColumnName.setter
    def ColumnName(self, ColumnName):
        self._ColumnName = ColumnName

    @property
    def ColumnRef(self):
        return self._ColumnRef

    @ColumnRef.setter
    def ColumnRef(self, ColumnRef):
        self._ColumnRef = ColumnRef


    def _deserialize(self, params):
        self._ColumnName = params.get("ColumnName")
        self._ColumnRef = params.get("ColumnRef")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ColumnLineageInfo(AbstractModel):
    """Lineage Field Information

    """

    def __init__(self):
        r"""
        :param _Id: Lineage ID
Note: This field may return null, indicating that no valid value can be obtained.
        :type Id: str
        :param _DatasourceId: Data Source ID
Note: This field may return null, indicating that no valid value can be obtained.
        :type DatasourceId: str
        :param _ColumnName: Field NameNote: This field may return null, indicating that no valid value can be obtained.
        :type ColumnName: str
        :param _ColumnNameCn: Field Chinese Name
Note: This field may return null, indicating that no valid value can be obtained.
        :type ColumnNameCn: str
        :param _ColumnType: Field TypeNote: This field may return null, indicating that no valid value can be obtained.
        :type ColumnType: str
        :param _RelationParams: Relationship Parameters
Note: This field may return null, indicating that no valid value can be obtained.
        :type RelationParams: str
        :param _Params: ParameterNote: This field may return null, indicating that no valid value can be obtained.
        :type Params: str
        :param _ParentId: Parent ID
Note: This field may return null, indicating that no valid value can be obtained.
        :type ParentId: str
        :param _MetastoreType: Metadata Type
Note: This field may return null, indicating that no valid value can be obtained.
        :type MetastoreType: str
        :param _MetastoreTypeName: Metadata Type Name
Note: This field may return null, indicating that no valid value can be obtained.
        :type MetastoreTypeName: str
        :param _TableName: Table Name
Note: This field may return null, indicating that no valid value can be obtained.
        :type TableName: str
        :param _QualifiedName: Full Field Name
Note: This field may return null, indicating that no valid value can be obtained.
        :type QualifiedName: str
        :param _DownStreamCount: Number of Downstream Nodes
Note: This field may return null, indicating that no valid value can be obtained.
        :type DownStreamCount: int
        :param _UpStreamCount: Number of Upstream Nodes
Note: This field may return null, indicating that no valid value can be obtained.
        :type UpStreamCount: int
        :param _Description: DescriptionNote: This field may return null, indicating that no valid value can be obtained.
        :type Description: str
        :param _PrefixPath: Path Information Starting from the Central Node
Note: This field may return null, indicating that no valid value can be obtained.
        :type PrefixPath: str
        :param _CreateTime: Creation TimeNote: This field may return null, indicating that no valid value can be obtained.
        :type CreateTime: str
        :param _ModifyTime: Update timeNote: This field may return null, indicating that no valid value can be obtained.
        :type ModifyTime: str
        :param _Tasks: Task ID list
Note: This field may return null, indicating that no valid value can be obtained.
        :type Tasks: list of str
        :param _ParentSet: Parent Node List String
Note: This field may return null, indicating that no valid value can be obtained.
        :type ParentSet: str
        :param _ChildSet: Child Node List String
Note: This field may return null, indicating that no valid value can be obtained.
        :type ChildSet: str
        :param _ExtParams: Additional parameters
Note: This field may return null, indicating that no valid value can be obtained.
        :type ExtParams: list of LineageParamRecord
        :param _TableId: Table IDNote: This field may return null, indicating that no valid value can be obtained.
        :type TableId: str
        """
        self._Id = None
        self._DatasourceId = None
        self._ColumnName = None
        self._ColumnNameCn = None
        self._ColumnType = None
        self._RelationParams = None
        self._Params = None
        self._ParentId = None
        self._MetastoreType = None
        self._MetastoreTypeName = None
        self._TableName = None
        self._QualifiedName = None
        self._DownStreamCount = None
        self._UpStreamCount = None
        self._Description = None
        self._PrefixPath = None
        self._CreateTime = None
        self._ModifyTime = None
        self._Tasks = None
        self._ParentSet = None
        self._ChildSet = None
        self._ExtParams = None
        self._TableId = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def ColumnName(self):
        return self._ColumnName

    @ColumnName.setter
    def ColumnName(self, ColumnName):
        self._ColumnName = ColumnName

    @property
    def ColumnNameCn(self):
        return self._ColumnNameCn

    @ColumnNameCn.setter
    def ColumnNameCn(self, ColumnNameCn):
        self._ColumnNameCn = ColumnNameCn

    @property
    def ColumnType(self):
        return self._ColumnType

    @ColumnType.setter
    def ColumnType(self, ColumnType):
        self._ColumnType = ColumnType

    @property
    def RelationParams(self):
        return self._RelationParams

    @RelationParams.setter
    def RelationParams(self, RelationParams):
        self._RelationParams = RelationParams

    @property
    def Params(self):
        return self._Params

    @Params.setter
    def Params(self, Params):
        self._Params = Params

    @property
    def ParentId(self):
        return self._ParentId

    @ParentId.setter
    def ParentId(self, ParentId):
        self._ParentId = ParentId

    @property
    def MetastoreType(self):
        return self._MetastoreType

    @MetastoreType.setter
    def MetastoreType(self, MetastoreType):
        self._MetastoreType = MetastoreType

    @property
    def MetastoreTypeName(self):
        return self._MetastoreTypeName

    @MetastoreTypeName.setter
    def MetastoreTypeName(self, MetastoreTypeName):
        self._MetastoreTypeName = MetastoreTypeName

    @property
    def TableName(self):
        return self._TableName

    @TableName.setter
    def TableName(self, TableName):
        self._TableName = TableName

    @property
    def QualifiedName(self):
        return self._QualifiedName

    @QualifiedName.setter
    def QualifiedName(self, QualifiedName):
        self._QualifiedName = QualifiedName

    @property
    def DownStreamCount(self):
        return self._DownStreamCount

    @DownStreamCount.setter
    def DownStreamCount(self, DownStreamCount):
        self._DownStreamCount = DownStreamCount

    @property
    def UpStreamCount(self):
        return self._UpStreamCount

    @UpStreamCount.setter
    def UpStreamCount(self, UpStreamCount):
        self._UpStreamCount = UpStreamCount

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def PrefixPath(self):
        return self._PrefixPath

    @PrefixPath.setter
    def PrefixPath(self, PrefixPath):
        self._PrefixPath = PrefixPath

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ModifyTime(self):
        return self._ModifyTime

    @ModifyTime.setter
    def ModifyTime(self, ModifyTime):
        self._ModifyTime = ModifyTime

    @property
    def Tasks(self):
        return self._Tasks

    @Tasks.setter
    def Tasks(self, Tasks):
        self._Tasks = Tasks

    @property
    def ParentSet(self):
        return self._ParentSet

    @ParentSet.setter
    def ParentSet(self, ParentSet):
        self._ParentSet = ParentSet

    @property
    def ChildSet(self):
        return self._ChildSet

    @ChildSet.setter
    def ChildSet(self, ChildSet):
        self._ChildSet = ChildSet

    @property
    def ExtParams(self):
        return self._ExtParams

    @ExtParams.setter
    def ExtParams(self, ExtParams):
        self._ExtParams = ExtParams

    @property
    def TableId(self):
        return self._TableId

    @TableId.setter
    def TableId(self, TableId):
        self._TableId = TableId


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._DatasourceId = params.get("DatasourceId")
        self._ColumnName = params.get("ColumnName")
        self._ColumnNameCn = params.get("ColumnNameCn")
        self._ColumnType = params.get("ColumnType")
        self._RelationParams = params.get("RelationParams")
        self._Params = params.get("Params")
        self._ParentId = params.get("ParentId")
        self._MetastoreType = params.get("MetastoreType")
        self._MetastoreTypeName = params.get("MetastoreTypeName")
        self._TableName = params.get("TableName")
        self._QualifiedName = params.get("QualifiedName")
        self._DownStreamCount = params.get("DownStreamCount")
        self._UpStreamCount = params.get("UpStreamCount")
        self._Description = params.get("Description")
        self._PrefixPath = params.get("PrefixPath")
        self._CreateTime = params.get("CreateTime")
        self._ModifyTime = params.get("ModifyTime")
        self._Tasks = params.get("Tasks")
        self._ParentSet = params.get("ParentSet")
        self._ChildSet = params.get("ChildSet")
        if params.get("ExtParams") is not None:
            self._ExtParams = []
            for item in params.get("ExtParams"):
                obj = LineageParamRecord()
                obj._deserialize(item)
                self._ExtParams.append(obj)
        self._TableId = params.get("TableId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ColumnMeta(AbstractModel):
    """Column Metadata

    """

    def __init__(self):
        r"""
        :param _NameEn: Field English Name
Note: This field may return null, indicating that no valid value can be obtained.
        :type NameEn: str
        :param _NameCn: Field Chinese Name
Note: This field may return null, indicating that no valid value can be obtained.
        :type NameCn: str
        :param _Type: Field TypeNote: This field may return null, indicating that no valid value can be obtained.
        :type Type: str
        :param _Description: Field DescriptionNote: This field may return null, indicating that no valid value can be obtained.
        :type Description: str
        :param _Position: Field Sequence Number
Note: This field may return null, indicating that no valid value can be obtained.
        :type Position: int
        :param _IsPartition: Is Partition Field
Note: This field may return null, indicating that no valid value can be obtained.
        :type IsPartition: bool
        :param _Name: Field nameNote: This field may return null, indicating that no valid value can be obtained.
        :type Name: str
        :param _ColumnFamiliesFieldSet: HBase Column Family Attribute Set
Note: This field may return null, indicating that no valid value can be obtained.
        :type ColumnFamiliesFieldSet: list of Pair
        :param _DictionaryId: Corresponding Code Table Dictionary ID
Note: This field may return null, indicating that no valid value can be obtained.
        :type DictionaryId: str
        :param _DictionaryName: Corresponding Code Table Dictionary Name
Note: This field may return null, indicating that no valid value can be obtained.
        :type DictionaryName: str
        :param _LevelName: Security Level: Name
Note: This field may return null, indicating that no valid value can be obtained.
        :type LevelName: str
        :param _LevelRank: Security Level: Value Range 1-10
Note: This field may return null, indicating that no valid value can be obtained.
        :type LevelRank: int
        """
        self._NameEn = None
        self._NameCn = None
        self._Type = None
        self._Description = None
        self._Position = None
        self._IsPartition = None
        self._Name = None
        self._ColumnFamiliesFieldSet = None
        self._DictionaryId = None
        self._DictionaryName = None
        self._LevelName = None
        self._LevelRank = None

    @property
    def NameEn(self):
        return self._NameEn

    @NameEn.setter
    def NameEn(self, NameEn):
        self._NameEn = NameEn

    @property
    def NameCn(self):
        return self._NameCn

    @NameCn.setter
    def NameCn(self, NameCn):
        self._NameCn = NameCn

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Position(self):
        return self._Position

    @Position.setter
    def Position(self, Position):
        self._Position = Position

    @property
    def IsPartition(self):
        return self._IsPartition

    @IsPartition.setter
    def IsPartition(self, IsPartition):
        self._IsPartition = IsPartition

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def ColumnFamiliesFieldSet(self):
        return self._ColumnFamiliesFieldSet

    @ColumnFamiliesFieldSet.setter
    def ColumnFamiliesFieldSet(self, ColumnFamiliesFieldSet):
        self._ColumnFamiliesFieldSet = ColumnFamiliesFieldSet

    @property
    def DictionaryId(self):
        return self._DictionaryId

    @DictionaryId.setter
    def DictionaryId(self, DictionaryId):
        self._DictionaryId = DictionaryId

    @property
    def DictionaryName(self):
        return self._DictionaryName

    @DictionaryName.setter
    def DictionaryName(self, DictionaryName):
        self._DictionaryName = DictionaryName

    @property
    def LevelName(self):
        return self._LevelName

    @LevelName.setter
    def LevelName(self, LevelName):
        self._LevelName = LevelName

    @property
    def LevelRank(self):
        return self._LevelRank

    @LevelRank.setter
    def LevelRank(self, LevelRank):
        self._LevelRank = LevelRank


    def _deserialize(self, params):
        self._NameEn = params.get("NameEn")
        self._NameCn = params.get("NameCn")
        self._Type = params.get("Type")
        self._Description = params.get("Description")
        self._Position = params.get("Position")
        self._IsPartition = params.get("IsPartition")
        self._Name = params.get("Name")
        if params.get("ColumnFamiliesFieldSet") is not None:
            self._ColumnFamiliesFieldSet = []
            for item in params.get("ColumnFamiliesFieldSet"):
                obj = Pair()
                obj._deserialize(item)
                self._ColumnFamiliesFieldSet.append(obj)
        self._DictionaryId = params.get("DictionaryId")
        self._DictionaryName = params.get("DictionaryName")
        self._LevelName = params.get("LevelName")
        self._LevelRank = params.get("LevelRank")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CommitIntegrationTaskRequest(AbstractModel):
    """CommitIntegrationTask request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID
        :type TaskId: str
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _CommitType: 0. Only submit, 1. Start immediately, 2. Stop online jobs, discard job state data, restart, 3. Pause online jobs, keep job state data, continue running, 4. Keep job state data, continue running
        :type CommitType: int
        :param _TaskType: Real-time task 201 Offline task 202 Default is real-time task
        :type TaskType: int
        :param _ExtConfig: Additional parameters
        :type ExtConfig: list of RecordField
        :param _VersionDesc: Submit version description
        :type VersionDesc: str
        :param _InstanceVersion: Submit version number
        :type InstanceVersion: int
        :param _EventDesc: Describe the type of front-end operation
        :type EventDesc: str
        """
        self._TaskId = None
        self._ProjectId = None
        self._CommitType = None
        self._TaskType = None
        self._ExtConfig = None
        self._VersionDesc = None
        self._InstanceVersion = None
        self._EventDesc = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def CommitType(self):
        return self._CommitType

    @CommitType.setter
    def CommitType(self, CommitType):
        self._CommitType = CommitType

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ExtConfig(self):
        return self._ExtConfig

    @ExtConfig.setter
    def ExtConfig(self, ExtConfig):
        self._ExtConfig = ExtConfig

    @property
    def VersionDesc(self):
        return self._VersionDesc

    @VersionDesc.setter
    def VersionDesc(self, VersionDesc):
        self._VersionDesc = VersionDesc

    @property
    def InstanceVersion(self):
        return self._InstanceVersion

    @InstanceVersion.setter
    def InstanceVersion(self, InstanceVersion):
        self._InstanceVersion = InstanceVersion

    @property
    def EventDesc(self):
        return self._EventDesc

    @EventDesc.setter
    def EventDesc(self, EventDesc):
        self._EventDesc = EventDesc


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ProjectId = params.get("ProjectId")
        self._CommitType = params.get("CommitType")
        self._TaskType = params.get("TaskType")
        if params.get("ExtConfig") is not None:
            self._ExtConfig = []
            for item in params.get("ExtConfig"):
                obj = RecordField()
                obj._deserialize(item)
                self._ExtConfig.append(obj)
        self._VersionDesc = params.get("VersionDesc")
        self._InstanceVersion = params.get("InstanceVersion")
        self._EventDesc = params.get("EventDesc")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CommitIntegrationTaskResponse(AbstractModel):
    """CommitIntegrationTask response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Operation Success or Failure Indicator
        :type Data: bool
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CommitRuleGroupTaskRequest(AbstractModel):
    """CommitRuleGroupTask request structure.

    """

    def __init__(self):
        r"""
        :param _RuleGroupId: Rule Group ID
        :type RuleGroupId: int
        :param _TriggerType: Trigger Type 1. Manual Trigger 2. In-process Scheduling Trigger 3. Periodic Scheduling Trigger
        :type TriggerType: int
        :param _ExecRuleConfig: Rule Configuration List
        :type ExecRuleConfig: list of RuleConfig
        :param _ExecConfig: Execution configuration
        :type ExecConfig: :class:`tencentcloud.wedata.v20210820.models.RuleExecConfig`
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _EngineType: The execution engine that this rule runs. If this parameter is not passed, the default execution engine under this data source will be requested.
        :type EngineType: str
        """
        self._RuleGroupId = None
        self._TriggerType = None
        self._ExecRuleConfig = None
        self._ExecConfig = None
        self._ProjectId = None
        self._EngineType = None

    @property
    def RuleGroupId(self):
        return self._RuleGroupId

    @RuleGroupId.setter
    def RuleGroupId(self, RuleGroupId):
        self._RuleGroupId = RuleGroupId

    @property
    def TriggerType(self):
        return self._TriggerType

    @TriggerType.setter
    def TriggerType(self, TriggerType):
        self._TriggerType = TriggerType

    @property
    def ExecRuleConfig(self):
        return self._ExecRuleConfig

    @ExecRuleConfig.setter
    def ExecRuleConfig(self, ExecRuleConfig):
        self._ExecRuleConfig = ExecRuleConfig

    @property
    def ExecConfig(self):
        return self._ExecConfig

    @ExecConfig.setter
    def ExecConfig(self, ExecConfig):
        self._ExecConfig = ExecConfig

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def EngineType(self):
        return self._EngineType

    @EngineType.setter
    def EngineType(self, EngineType):
        self._EngineType = EngineType


    def _deserialize(self, params):
        self._RuleGroupId = params.get("RuleGroupId")
        self._TriggerType = params.get("TriggerType")
        if params.get("ExecRuleConfig") is not None:
            self._ExecRuleConfig = []
            for item in params.get("ExecRuleConfig"):
                obj = RuleConfig()
                obj._deserialize(item)
                self._ExecRuleConfig.append(obj)
        if params.get("ExecConfig") is not None:
            self._ExecConfig = RuleExecConfig()
            self._ExecConfig._deserialize(params.get("ExecConfig"))
        self._ProjectId = params.get("ProjectId")
        self._EngineType = params.get("EngineType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CommitRuleGroupTaskResponse(AbstractModel):
    """CommitRuleGroupTask response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Rule Group Execution ID
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleGroupExecResult`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleGroupExecResult()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CommonContent(AbstractModel):
    """Content Details

    """

    def __init__(self):
        r"""
        :param _Content: Detailed Content
Note: This field may return null, indicating that no valid value can be obtained.
        :type Content: str
        """
        self._Content = None

    @property
    def Content(self):
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content


    def _deserialize(self, params):
        self._Content = params.get("Content")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CommonId(AbstractModel):
    """ID Wrapper Object

    """

    def __init__(self):
        r"""
        :param _Id: ID Value
Note: This field may return null, indicating that no valid value can be obtained.
        :type Id: str
        """
        self._Id = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CommonIdOpsDto(AbstractModel):
    """Return Command ID

    """

    def __init__(self):
        r"""
        :param _Id: Returns the supplemental plan id
Note: This field may return null, indicating that no valid value can be obtained.
        :type Id: str
        """
        self._Id = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CompareResult(AbstractModel):
    """Quality Check Comparison Results

    """

    def __init__(self):
        r"""
        :param _Items: Comparison Result Item List
Note: This field may return null, indicating that no valid value can be obtained.
        :type Items: list of CompareResultItem
        :param _TotalRows: Total Number of Rows Detected
Note: This field may return null, indicating that no valid value can be obtained.
        :type TotalRows: int
        :param _PassRows: Number of Rows Passed
Note: This field may return null, indicating that no valid value can be obtained.
        :type PassRows: int
        :param _TriggerRows: Number of Rows Failed
Note: This field may return null, indicating that no valid value can be obtained.
        :type TriggerRows: int
        """
        self._Items = None
        self._TotalRows = None
        self._PassRows = None
        self._TriggerRows = None

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def TotalRows(self):
        return self._TotalRows

    @TotalRows.setter
    def TotalRows(self, TotalRows):
        self._TotalRows = TotalRows

    @property
    def PassRows(self):
        return self._PassRows

    @PassRows.setter
    def PassRows(self, PassRows):
        self._PassRows = PassRows

    @property
    def TriggerRows(self):
        return self._TriggerRows

    @TriggerRows.setter
    def TriggerRows(self, TriggerRows):
        self._TriggerRows = TriggerRows


    def _deserialize(self, params):
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = CompareResultItem()
                obj._deserialize(item)
                self._Items.append(obj)
        self._TotalRows = params.get("TotalRows")
        self._PassRows = params.get("PassRows")
        self._TriggerRows = params.get("TriggerRows")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CompareResultItem(AbstractModel):
    """Comparison Result Item

    """

    def __init__(self):
        r"""
        :param _FixResult: Comparison Result, 1 is true, 2 is false
Note: This field may return null, indicating that no valid value can be obtained.
        :type FixResult: int
        :param _ResultValue: Quality SQL Execution Result
Note: This field may return null, indicating that no valid value can be obtained.
        :type ResultValue: str
        :param _Values: Threshold List
Note: This field may return null, indicating that no valid value can be obtained.
        :type Values: list of ThresholdValue
        :param _Operator: Comparison Operation Type
Note: This field may return null, indicating that no valid value can be obtained.
        :type Operator: str
        :param _CompareType: Comparison Type
Note: This field may return null, indicating that no valid value can be obtained.
        :type CompareType: int
        :param _ValueComputeType: Value Comparison Type
Note: This field may return null, indicating that no valid value can be obtained.
        :type ValueComputeType: int
        """
        self._FixResult = None
        self._ResultValue = None
        self._Values = None
        self._Operator = None
        self._CompareType = None
        self._ValueComputeType = None

    @property
    def FixResult(self):
        return self._FixResult

    @FixResult.setter
    def FixResult(self, FixResult):
        self._FixResult = FixResult

    @property
    def ResultValue(self):
        return self._ResultValue

    @ResultValue.setter
    def ResultValue(self, ResultValue):
        self._ResultValue = ResultValue

    @property
    def Values(self):
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values

    @property
    def Operator(self):
        return self._Operator

    @Operator.setter
    def Operator(self, Operator):
        self._Operator = Operator

    @property
    def CompareType(self):
        return self._CompareType

    @CompareType.setter
    def CompareType(self, CompareType):
        self._CompareType = CompareType

    @property
    def ValueComputeType(self):
        return self._ValueComputeType

    @ValueComputeType.setter
    def ValueComputeType(self, ValueComputeType):
        self._ValueComputeType = ValueComputeType


    def _deserialize(self, params):
        self._FixResult = params.get("FixResult")
        self._ResultValue = params.get("ResultValue")
        if params.get("Values") is not None:
            self._Values = []
            for item in params.get("Values"):
                obj = ThresholdValue()
                obj._deserialize(item)
                self._Values.append(obj)
        self._Operator = params.get("Operator")
        self._CompareType = params.get("CompareType")
        self._ValueComputeType = params.get("ValueComputeType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CompareRule(AbstractModel):
    """Comparison Rules

    """

    def __init__(self):
        r"""
        :param _Items: Comparison Criteria List
Note: This field may return null, indicating that no valid value can be obtained.
        :type Items: list of CompareRuleItem
        :param _CycleStep: Default cycle of the periodic template, Unit: seconds
Note: This field may return null, indicating that no valid value can be obtained.
        :type CycleStep: int
        :param _ComputeExpression: o represents OR, a represents AND, numbers represent items' indices
Note: This field may return null, indicating that no valid value can be obtained.
        :type ComputeExpression: str
        """
        self._Items = None
        self._CycleStep = None
        self._ComputeExpression = None

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def CycleStep(self):
        return self._CycleStep

    @CycleStep.setter
    def CycleStep(self, CycleStep):
        self._CycleStep = CycleStep

    @property
    def ComputeExpression(self):
        return self._ComputeExpression

    @ComputeExpression.setter
    def ComputeExpression(self, ComputeExpression):
        self._ComputeExpression = ComputeExpression


    def _deserialize(self, params):
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = CompareRuleItem()
                obj._deserialize(item)
                self._Items.append(obj)
        self._CycleStep = params.get("CycleStep")
        self._ComputeExpression = params.get("ComputeExpression")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CompareRuleItem(AbstractModel):
    """Comparison Criterion

    """

    def __init__(self):
        r"""
        :param _CompareType: Comparison Type 1. Fixed value  2. Fluctuation Value  3. Numeric Range Comparison  4. Enumeration Range Comparison  5. No Comparison
Note: This field may return null, indicating that no valid value can be obtained.
        :type CompareType: int
        :param _Operator: Comparison Operation Type
<  <=  ==  =>  > !=
IRLCRO: Within the interval (left closed, right open)
IRLORC: Within the interval (left open, right closed)
IRLCRC: Within the interval (left closed, right closed)
IRLORO: Within the interval (left open, right open)
NRLCRO: Not within the range (left-closed, right-open)
NRLORC: Not within the range (left-open, right-closed)
NRLCRC: Not within the range (left-closed, right-closed)
NRLORO: Not within the range (left-open, right-open)
Note: This field may return null, indicating that no valid value can be obtained.
        :type Operator: str
        :param _ValueComputeType: Quality statistical value types 1. Absolute Value 2. Increase 3. Decline 4. _C includes 5. N_C does not include
Note: This field may return null, indicating that no valid value can be obtained.
        :type ValueComputeType: int
        :param _ValueList: Comparison threshold list
Note: This field may return null, indicating that no valid value can be obtained.
        :type ValueList: list of ThresholdValue
        """
        self._CompareType = None
        self._Operator = None
        self._ValueComputeType = None
        self._ValueList = None

    @property
    def CompareType(self):
        return self._CompareType

    @CompareType.setter
    def CompareType(self, CompareType):
        self._CompareType = CompareType

    @property
    def Operator(self):
        return self._Operator

    @Operator.setter
    def Operator(self, Operator):
        self._Operator = Operator

    @property
    def ValueComputeType(self):
        return self._ValueComputeType

    @ValueComputeType.setter
    def ValueComputeType(self, ValueComputeType):
        self._ValueComputeType = ValueComputeType

    @property
    def ValueList(self):
        return self._ValueList

    @ValueList.setter
    def ValueList(self, ValueList):
        self._ValueList = ValueList


    def _deserialize(self, params):
        self._CompareType = params.get("CompareType")
        self._Operator = params.get("Operator")
        self._ValueComputeType = params.get("ValueComputeType")
        if params.get("ValueList") is not None:
            self._ValueList = []
            for item in params.get("ValueList"):
                obj = ThresholdValue()
                obj._deserialize(item)
                self._ValueList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Content(AbstractModel):
    """Content

    """

    def __init__(self):
        r"""
        :param _TaskId: Task IDNote: This field may return null, indicating that no valid value can be obtained.
        :type TaskId: str
        :param _TaskName: Task NameNote: This field may return null, indicating that no valid value can be obtained.
        :type TaskName: str
        :param _Diagnose: Diagnosis
Note: This field may return null, indicating that no valid value can be obtained.
        :type Diagnose: str
        :param _Reason: Reason
Note: This field may return null, indicating that no valid value can be obtained.
        :type Reason: str
        :param _Operation: OperationNote: This field may return null, indicating that no valid value can be obtained.
        :type Operation: str
        :param _Url: Link
Note: This field may return null, indicating that no valid value can be obtained.
        :type Url: str
        """
        self._TaskId = None
        self._TaskName = None
        self._Diagnose = None
        self._Reason = None
        self._Operation = None
        self._Url = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TaskName(self):
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def Diagnose(self):
        return self._Diagnose

    @Diagnose.setter
    def Diagnose(self, Diagnose):
        self._Diagnose = Diagnose

    @property
    def Reason(self):
        return self._Reason

    @Reason.setter
    def Reason(self, Reason):
        self._Reason = Reason

    @property
    def Operation(self):
        return self._Operation

    @Operation.setter
    def Operation(self, Operation):
        self._Operation = Operation

    @property
    def Url(self):
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._TaskName = params.get("TaskName")
        self._Diagnose = params.get("Diagnose")
        self._Reason = params.get("Reason")
        self._Operation = params.get("Operation")
        self._Url = params.get("Url")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CountOpsInstanceStateRequest(AbstractModel):
    """CountOpsInstanceState request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID
        :type TaskId: str
        :param _ProjectId: Project ID
        :type ProjectId: str
        """
        self._TaskId = None
        self._ProjectId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CountOpsInstanceStateResponse(AbstractModel):
    """CountOpsInstanceState response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Task Corresponding Instance Status Statistics
        :type Data: :class:`tencentcloud.wedata.v20210820.models.TaskInstanceCountDto`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = TaskInstanceCountDto()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CreateCustomFunctionRequest(AbstractModel):
    """CreateCustomFunction request structure.

    """

    def __init__(self):
        r"""
        :param _Type: Enumerated values: HIVE, SPARK, DLC
        :type Type: str
        :param _Kind: Enumerated values: ANALYSIS (function), ENCRYPTION (encryption function), AGGREGATE (aggregate function), LOGIC (logic function), DATE_AND_TIME (date and time function), MATH (math function), CONVERSION (conversion function), STRING (string function), IP_AND_DOMAIN (IP and domain function), WINDOW (window function), OTHER (other function)
        :type Kind: str
        :param _Name: Function Name
        :type Name: str
        :param _ClusterIdentifier: Cluster Instance Engine ID
        :type ClusterIdentifier: str
        :param _DbName: Database name
        :type DbName: str
        :param _ProjectId: Project ID
        :type ProjectId: str
        """
        self._Type = None
        self._Kind = None
        self._Name = None
        self._ClusterIdentifier = None
        self._DbName = None
        self._ProjectId = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Kind(self):
        return self._Kind

    @Kind.setter
    def Kind(self, Kind):
        self._Kind = Kind

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def ClusterIdentifier(self):
        return self._ClusterIdentifier

    @ClusterIdentifier.setter
    def ClusterIdentifier(self, ClusterIdentifier):
        self._ClusterIdentifier = ClusterIdentifier

    @property
    def DbName(self):
        return self._DbName

    @DbName.setter
    def DbName(self, DbName):
        self._DbName = DbName

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Kind = params.get("Kind")
        self._Name = params.get("Name")
        self._ClusterIdentifier = params.get("ClusterIdentifier")
        self._DbName = params.get("DbName")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateCustomFunctionResponse(AbstractModel):
    """CreateCustomFunction response structure.

    """

    def __init__(self):
        r"""
        :param _FunctionId: Function Unique IdentifierNote: This field may return null, indicating that no valid value can be obtained.
        :type FunctionId: str
        :param _ErrorMessage: NoNote: This field may return null, indicating that no valid value can be obtained.
        :type ErrorMessage: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FunctionId = None
        self._ErrorMessage = None
        self._RequestId = None

    @property
    def FunctionId(self):
        return self._FunctionId

    @FunctionId.setter
    def FunctionId(self, FunctionId):
        self._FunctionId = FunctionId

    @property
    def ErrorMessage(self):
        return self._ErrorMessage

    @ErrorMessage.setter
    def ErrorMessage(self, ErrorMessage):
        self._ErrorMessage = ErrorMessage

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FunctionId = params.get("FunctionId")
        self._ErrorMessage = params.get("ErrorMessage")
        self._RequestId = params.get("RequestId")


class CreateDataSourceRequest(AbstractModel):
    """CreateDataSource request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Data Source Name, cannot be empty under the same SpaceName
        :type Name: str
        :param _Category: Data Source Category: Binding Engine, Binding Database
        :type Category: str
        :param _Type: Data Source Type: enumerated values
        :type Type: str
        :param _OwnerProjectId: Project ID
        :type OwnerProjectId: str
        :param _OwnerProjectName: Project Name
        :type OwnerProjectName: str
        :param _OwnerProjectIdent: Project Name (Chinese)
        :type OwnerProjectIdent: str
        :param _BizParams: Configuration Information Extension of Business Data Source
        :type BizParams: str
        :param _Params: Data source configuration information, stored as JSON KV. The KV storage information varies according to the data source type
        :type Params: str
        :param _Description: Data source description information
        :type Description: str
        :param _Display: Data Source Display Name, for visual inspection
        :type Display: str
        :param _DatabaseName: If the data source list is bound to a database, then it is the database name
        :type DatabaseName: str
        :param _Instance: Instance ID of the data source engine, e.g., CDB Instance ID
        :type Instance: str
        :param _Status: Visibility of the data source, where 1 is visible and 0 is not visible. Default is 1
        :type Status: int
        :param _ClusterId: Name of the business space to which the data source belongs
        :type ClusterId: str
        :param _Collect: Collection Status
        :type Collect: str
        :param _COSBucket: COS Bucket Information
        :type COSBucket: str
        :param _COSRegion: cos region
        :type COSRegion: str
        :param _ConnectResult: Connection Test Result
        :type ConnectResult: str
        :param _DevelopmentParams: Development Environment Data Source Configuration
        :type DevelopmentParams: str
        """
        self._Name = None
        self._Category = None
        self._Type = None
        self._OwnerProjectId = None
        self._OwnerProjectName = None
        self._OwnerProjectIdent = None
        self._BizParams = None
        self._Params = None
        self._Description = None
        self._Display = None
        self._DatabaseName = None
        self._Instance = None
        self._Status = None
        self._ClusterId = None
        self._Collect = None
        self._COSBucket = None
        self._COSRegion = None
        self._ConnectResult = None
        self._DevelopmentParams = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Category(self):
        return self._Category

    @Category.setter
    def Category(self, Category):
        self._Category = Category

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def OwnerProjectId(self):
        return self._OwnerProjectId

    @OwnerProjectId.setter
    def OwnerProjectId(self, OwnerProjectId):
        self._OwnerProjectId = OwnerProjectId

    @property
    def OwnerProjectName(self):
        return self._OwnerProjectName

    @OwnerProjectName.setter
    def OwnerProjectName(self, OwnerProjectName):
        self._OwnerProjectName = OwnerProjectName

    @property
    def OwnerProjectIdent(self):
        return self._OwnerProjectIdent

    @OwnerProjectIdent.setter
    def OwnerProjectIdent(self, OwnerProjectIdent):
        self._OwnerProjectIdent = OwnerProjectIdent

    @property
    def BizParams(self):
        return self._BizParams

    @BizParams.setter
    def BizParams(self, BizParams):
        self._BizParams = BizParams

    @property
    def Params(self):
        return self._Params

    @Params.setter
    def Params(self, Params):
        self._Params = Params

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Display(self):
        return self._Display

    @Display.setter
    def Display(self, Display):
        self._Display = Display

    @property
    def DatabaseName(self):
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def Instance(self):
        return self._Instance

    @Instance.setter
    def Instance(self, Instance):
        self._Instance = Instance

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Collect(self):
        return self._Collect

    @Collect.setter
    def Collect(self, Collect):
        self._Collect = Collect

    @property
    def COSBucket(self):
        return self._COSBucket

    @COSBucket.setter
    def COSBucket(self, COSBucket):
        self._COSBucket = COSBucket

    @property
    def COSRegion(self):
        return self._COSRegion

    @COSRegion.setter
    def COSRegion(self, COSRegion):
        self._COSRegion = COSRegion

    @property
    def ConnectResult(self):
        return self._ConnectResult

    @ConnectResult.setter
    def ConnectResult(self, ConnectResult):
        self._ConnectResult = ConnectResult

    @property
    def DevelopmentParams(self):
        return self._DevelopmentParams

    @DevelopmentParams.setter
    def DevelopmentParams(self, DevelopmentParams):
        self._DevelopmentParams = DevelopmentParams


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Category = params.get("Category")
        self._Type = params.get("Type")
        self._OwnerProjectId = params.get("OwnerProjectId")
        self._OwnerProjectName = params.get("OwnerProjectName")
        self._OwnerProjectIdent = params.get("OwnerProjectIdent")
        self._BizParams = params.get("BizParams")
        self._Params = params.get("Params")
        self._Description = params.get("Description")
        self._Display = params.get("Display")
        self._DatabaseName = params.get("DatabaseName")
        self._Instance = params.get("Instance")
        self._Status = params.get("Status")
        self._ClusterId = params.get("ClusterId")
        self._Collect = params.get("Collect")
        self._COSBucket = params.get("COSBucket")
        self._COSRegion = params.get("COSRegion")
        self._ConnectResult = params.get("ConnectResult")
        self._DevelopmentParams = params.get("DevelopmentParams")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDataSourceResponse(AbstractModel):
    """CreateDataSource response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Primary Key ID
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CreateDsFolderRequest(AbstractModel):
    """CreateDsFolder request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _FolderName: Folder Name
        :type FolderName: str
        :param _ParentsFolderId: Parent Folder ID
        :type ParentsFolderId: str
        """
        self._ProjectId = None
        self._FolderName = None
        self._ParentsFolderId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def FolderName(self):
        return self._FolderName

    @FolderName.setter
    def FolderName(self, FolderName):
        self._FolderName = FolderName

    @property
    def ParentsFolderId(self):
        return self._ParentsFolderId

    @ParentsFolderId.setter
    def ParentsFolderId(self, ParentsFolderId):
        self._ParentsFolderId = ParentsFolderId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._FolderName = params.get("FolderName")
        self._ParentsFolderId = params.get("ParentsFolderId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDsFolderResponse(AbstractModel):
    """CreateDsFolder response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Folder ID, null if creation fails
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CreateHiveTableByDDLRequest(AbstractModel):
    """CreateHiveTableByDDL request structure.

    """

    def __init__(self):
        r"""
        :param _DatasourceId: Data Source ID
        :type DatasourceId: str
        :param _Database: Database
        :type Database: str
        :param _DDLSql: Create Hive Table DDL
        :type DDLSql: str
        :param _Privilege: Table permissions, default is 0: Project share; 1: Individual and administrator only
        :type Privilege: int
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _Type: Target Table Type (HIVE or GBASE)
        :type Type: str
        :param _Incharge: Person in Charge
        :type Incharge: str
        :param _SchemaName: Schema Name
        :type SchemaName: str
        """
        self._DatasourceId = None
        self._Database = None
        self._DDLSql = None
        self._Privilege = None
        self._ProjectId = None
        self._Type = None
        self._Incharge = None
        self._SchemaName = None

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def Database(self):
        return self._Database

    @Database.setter
    def Database(self, Database):
        self._Database = Database

    @property
    def DDLSql(self):
        return self._DDLSql

    @DDLSql.setter
    def DDLSql(self, DDLSql):
        self._DDLSql = DDLSql

    @property
    def Privilege(self):
        return self._Privilege

    @Privilege.setter
    def Privilege(self, Privilege):
        self._Privilege = Privilege

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Incharge(self):
        return self._Incharge

    @Incharge.setter
    def Incharge(self, Incharge):
        self._Incharge = Incharge

    @property
    def SchemaName(self):
        return self._SchemaName

    @SchemaName.setter
    def SchemaName(self, SchemaName):
        self._SchemaName = SchemaName


    def _deserialize(self, params):
        self._DatasourceId = params.get("DatasourceId")
        self._Database = params.get("Database")
        self._DDLSql = params.get("DDLSql")
        self._Privilege = params.get("Privilege")
        self._ProjectId = params.get("ProjectId")
        self._Type = params.get("Type")
        self._Incharge = params.get("Incharge")
        self._SchemaName = params.get("SchemaName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateHiveTableByDDLResponse(AbstractModel):
    """CreateHiveTableByDDL response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Table Name
        :type Data: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CreateHiveTableRequest(AbstractModel):
    """CreateHiveTable request structure.

    """

    def __init__(self):
        r"""
        :param _DatasourceId: Data source ID
        :type DatasourceId: str
        :param _Database: Database name
        :type Database: str
        :param _DDLSql: Base64-encoded Table Creation Statement
        :type DDLSql: str
        :param _Privilege: Table permissions, default is 0: Project share; 1: Individual and administrator only
        :type Privilege: int
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _Incharge: Person in Charge
        :type Incharge: str
        """
        self._DatasourceId = None
        self._Database = None
        self._DDLSql = None
        self._Privilege = None
        self._ProjectId = None
        self._Incharge = None

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def Database(self):
        return self._Database

    @Database.setter
    def Database(self, Database):
        self._Database = Database

    @property
    def DDLSql(self):
        return self._DDLSql

    @DDLSql.setter
    def DDLSql(self, DDLSql):
        self._DDLSql = DDLSql

    @property
    def Privilege(self):
        return self._Privilege

    @Privilege.setter
    def Privilege(self, Privilege):
        self._Privilege = Privilege

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Incharge(self):
        return self._Incharge

    @Incharge.setter
    def Incharge(self, Incharge):
        self._Incharge = Incharge


    def _deserialize(self, params):
        self._DatasourceId = params.get("DatasourceId")
        self._Database = params.get("Database")
        self._DDLSql = params.get("DDLSql")
        self._Privilege = params.get("Privilege")
        self._ProjectId = params.get("ProjectId")
        self._Incharge = params.get("Incharge")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateHiveTableResponse(AbstractModel):
    """CreateHiveTable response structure.

    """

    def __init__(self):
        r"""
        :param _IsSuccess: Whether table creation was successful
        :type IsSuccess: bool
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._IsSuccess = None
        self._RequestId = None

    @property
    def IsSuccess(self):
        return self._IsSuccess

    @IsSuccess.setter
    def IsSuccess(self, IsSuccess):
        self._IsSuccess = IsSuccess

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._IsSuccess = params.get("IsSuccess")
        self._RequestId = params.get("RequestId")


class CreateIntegrationNodeRequest(AbstractModel):
    """CreateIntegrationNode request structure.

    """

    def __init__(self):
        r"""
        :param _NodeInfo: Integrated Node Information
        :type NodeInfo: :class:`tencentcloud.wedata.v20210820.models.IntegrationNodeInfo`
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _TaskType: Task Type, 201 for real-time tasks, 202 for offline tasks
        :type TaskType: int
        """
        self._NodeInfo = None
        self._ProjectId = None
        self._TaskType = None

    @property
    def NodeInfo(self):
        return self._NodeInfo

    @NodeInfo.setter
    def NodeInfo(self, NodeInfo):
        self._NodeInfo = NodeInfo

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType


    def _deserialize(self, params):
        if params.get("NodeInfo") is not None:
            self._NodeInfo = IntegrationNodeInfo()
            self._NodeInfo._deserialize(params.get("NodeInfo"))
        self._ProjectId = params.get("ProjectId")
        self._TaskType = params.get("TaskType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateIntegrationNodeResponse(AbstractModel):
    """CreateIntegrationNode response structure.

    """

    def __init__(self):
        r"""
        :param _Id: Node
        :type Id: str
        :param _TaskId: Current Task ID
Note: This field may return null, indicating that no valid value can be obtained.
        :type TaskId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Id = None
        self._TaskId = None
        self._RequestId = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class CreateIntegrationTaskRequest(AbstractModel):
    """CreateIntegrationTask request structure.

    """

    def __init__(self):
        r"""
        :param _TaskInfo: Task Information
        :type TaskInfo: :class:`tencentcloud.wedata.v20210820.models.IntegrationTaskInfo`
        :param _ProjectId: Project ID
        :type ProjectId: str
        """
        self._TaskInfo = None
        self._ProjectId = None

    @property
    def TaskInfo(self):
        return self._TaskInfo

    @TaskInfo.setter
    def TaskInfo(self, TaskInfo):
        self._TaskInfo = TaskInfo

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        if params.get("TaskInfo") is not None:
            self._TaskInfo = IntegrationTaskInfo()
            self._TaskInfo._deserialize(params.get("TaskInfo"))
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateIntegrationTaskResponse(AbstractModel):
    """CreateIntegrationTask response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID
        :type TaskId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class CreateMakeDatetimeInfo(AbstractModel):
    """Supplementary Plan Date Range

    """

    def __init__(self):
        r"""
        :param _StartDate: Start date
Note: This field may return null, indicating that no valid value can be obtained.
        :type StartDate: str
        :param _EndDate: End date
Note: This field may return null, indicating that no valid value can be obtained.
        :type EndDate: str
        :param _StartTime: Start TimeNote: This field may return null, indicating that no valid value can be obtained.
        :type StartTime: str
        :param _EndTime: End timeNote: This field may return null, indicating that no valid value can be obtained.
        :type EndTime: str
        """
        self._StartDate = None
        self._EndDate = None
        self._StartTime = None
        self._EndTime = None

    @property
    def StartDate(self):
        return self._StartDate

    @StartDate.setter
    def StartDate(self, StartDate):
        self._StartDate = StartDate

    @property
    def EndDate(self):
        return self._EndDate

    @EndDate.setter
    def EndDate(self, EndDate):
        self._EndDate = EndDate

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._StartDate = params.get("StartDate")
        self._EndDate = params.get("EndDate")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOfflineTaskRequest(AbstractModel):
    """CreateOfflineTask request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _CycleStep: Interval, optional, default is 1. Not null. Default is 1
        :type CycleStep: int
        :param _DelayTime: Delayed Execution Time, in minutes
        :type DelayTime: int
        :param _EndTime: Task End Data Time. Not Empty. Default to Current Time
        :type EndTime: str
        :param _Notes: Remarks
        :type Notes: str
        :param _StartTime: Current date
        :type StartTime: str
        :param _TaskName: Task Name
        :type TaskName: str
        :param _TypeId: Keep it consistent with the previous call to the scheduling interface 27
        :type TypeId: int
        :param _TaskAction: Time Specification, for monthly tasks specify days like 1,3, then enter 1,3. Not Empty. Default "" Monthly Task: For specific days like "1,3", specifying the end of the month cannot be combined with specific dates, can only be "L"
        :type TaskAction: str
        :param _TaskMode: Distinguish between canvas and form
        :type TaskMode: str
        """
        self._ProjectId = None
        self._CycleStep = None
        self._DelayTime = None
        self._EndTime = None
        self._Notes = None
        self._StartTime = None
        self._TaskName = None
        self._TypeId = None
        self._TaskAction = None
        self._TaskMode = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def CycleStep(self):
        return self._CycleStep

    @CycleStep.setter
    def CycleStep(self, CycleStep):
        self._CycleStep = CycleStep

    @property
    def DelayTime(self):
        return self._DelayTime

    @DelayTime.setter
    def DelayTime(self, DelayTime):
        self._DelayTime = DelayTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Notes(self):
        return self._Notes

    @Notes.setter
    def Notes(self, Notes):
        self._Notes = Notes

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def TaskName(self):
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def TypeId(self):
        return self._TypeId

    @TypeId.setter
    def TypeId(self, TypeId):
        self._TypeId = TypeId

    @property
    def TaskAction(self):
        return self._TaskAction

    @TaskAction.setter
    def TaskAction(self, TaskAction):
        self._TaskAction = TaskAction

    @property
    def TaskMode(self):
        return self._TaskMode

    @TaskMode.setter
    def TaskMode(self, TaskMode):
        self._TaskMode = TaskMode


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._CycleStep = params.get("CycleStep")
        self._DelayTime = params.get("DelayTime")
        self._EndTime = params.get("EndTime")
        self._Notes = params.get("Notes")
        self._StartTime = params.get("StartTime")
        self._TaskName = params.get("TaskName")
        self._TypeId = params.get("TypeId")
        self._TaskAction = params.get("TaskAction")
        self._TaskMode = params.get("TaskMode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOfflineTaskResponse(AbstractModel):
    """CreateOfflineTask response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task IDNote: This field may return null, indicating that no valid value can be obtained.
        :type TaskId: str
        :param _Data: Result
        :type Data: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._Data = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CreateOpsMakePlanRequest(AbstractModel):
    """CreateOpsMakePlan request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _MakeName: Supplemental Plan Name
        :type MakeName: str
        :param _TaskIdList: Supplementary Task Collection
        :type TaskIdList: list of str
        :param _MakeDatetimeList: Supplementary Plan Date Range
        :type MakeDatetimeList: list of CreateMakeDatetimeInfo
        :param _ProjectIdent: Project Identifier
        :type ProjectIdent: str
        :param _CheckParent: Check Parent Task Status for Supplement, default is not to check. Not recommended for use, will be deprecated, recommend using CheckParentType.
        :type CheckParent: bool
        :param _CheckParentType: Check Parent Task Type for Supplementary. Value range:
<li> NONE: Do not check any </li>
<li> ALL: Check all upstream parent tasks </li>
<li> MAKE_SCOPE: Check only within the selected tasks of (the current supplementary plan) </li>
        :type CheckParentType: str
        :param _ProjectName: Project name
        :type ProjectName: str
        :param _SelfDependence: Deprecated. Task Self-Dependency Type: parallel, serial (unordered parallel), orderly (ordered serial)
        :type SelfDependence: str
        :param _ParallelNum: Parallelism
        :type ParallelNum: int
        :param _SameCycle: Is the generation cycle of the supplementary instance the same as the original cycle, default is true
        :type SameCycle: bool
        :param _TargetTaskCycle: Supplementary Instance Target Cycle Type
        :type TargetTaskCycle: str
        :param _TargetTaskAction: Specified Time for Supplementary Instance Target Cycle Type
        :type TargetTaskAction: int
        :param _MapParamList: Custom Parameters for Supplement Instance
        :type MapParamList: list of StrToStrMap
        :param _CreatorId: Creator ID
        :type CreatorId: str
        :param _Creator: Creator
        :type Creator: str
        :param _Remark: Supplementary Plan Description
        :type Remark: str
        :param _SameSelfDependType: Use Original Self-Dependency Configuration of Task, default is true
        :type SameSelfDependType: bool
        :param _SourceTaskCycle: Supplementary Instance Original Cycle Type
        :type SourceTaskCycle: str
        :param _SchedulerResourceGroup: If no specified scheduling resource group (ID) is provided, the original task scheduling execution resource group will be used
        :type SchedulerResourceGroup: str
        :param _IntegrationResourceGroup: If no specified integration resource group (ID) is provided, the original task integration execution resource group will be used
        :type IntegrationResourceGroup: str
        :param _SchedulerResourceGroupName: If no specified scheduling resource group name is provided, the original task scheduling execution resource group will be used
        :type SchedulerResourceGroupName: str
        :param _IntegrationResourceGroupName: If no specified integration resource group name is provided, the original task integration execution resource group will be used
        :type IntegrationResourceGroupName: str
        """
        self._ProjectId = None
        self._MakeName = None
        self._TaskIdList = None
        self._MakeDatetimeList = None
        self._ProjectIdent = None
        self._CheckParent = None
        self._CheckParentType = None
        self._ProjectName = None
        self._SelfDependence = None
        self._ParallelNum = None
        self._SameCycle = None
        self._TargetTaskCycle = None
        self._TargetTaskAction = None
        self._MapParamList = None
        self._CreatorId = None
        self._Creator = None
        self._Remark = None
        self._SameSelfDependType = None
        self._SourceTaskCycle = None
        self._SchedulerResourceGroup = None
        self._IntegrationResourceGroup = None
        self._SchedulerResourceGroupName = None
        self._IntegrationResourceGroupName = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def MakeName(self):
        return self._MakeName

    @MakeName.setter
    def MakeName(self, MakeName):
        self._MakeName = MakeName

    @property
    def TaskIdList(self):
        return self._TaskIdList

    @TaskIdList.setter
    def TaskIdList(self, TaskIdList):
        self._TaskIdList = TaskIdList

    @property
    def MakeDatetimeList(self):
        return self._MakeDatetimeList

    @MakeDatetimeList.setter
    def MakeDatetimeList(self, MakeDatetimeList):
        self._MakeDatetimeList = MakeDatetimeList

    @property
    def ProjectIdent(self):
        return self._ProjectIdent

    @ProjectIdent.setter
    def ProjectIdent(self, ProjectIdent):
        self._ProjectIdent = ProjectIdent

    @property
    def CheckParent(self):
        return self._CheckParent

    @CheckParent.setter
    def CheckParent(self, CheckParent):
        self._CheckParent = CheckParent

    @property
    def CheckParentType(self):
        return self._CheckParentType

    @CheckParentType.setter
    def CheckParentType(self, CheckParentType):
        self._CheckParentType = CheckParentType

    @property
    def ProjectName(self):
        return self._ProjectName

    @ProjectName.setter
    def ProjectName(self, ProjectName):
        self._ProjectName = ProjectName

    @property
    def SelfDependence(self):
        return self._SelfDependence

    @SelfDependence.setter
    def SelfDependence(self, SelfDependence):
        self._SelfDependence = SelfDependence

    @property
    def ParallelNum(self):
        return self._ParallelNum

    @ParallelNum.setter
    def ParallelNum(self, ParallelNum):
        self._ParallelNum = ParallelNum

    @property
    def SameCycle(self):
        return self._SameCycle

    @SameCycle.setter
    def SameCycle(self, SameCycle):
        self._SameCycle = SameCycle

    @property
    def TargetTaskCycle(self):
        return self._TargetTaskCycle

    @TargetTaskCycle.setter
    def TargetTaskCycle(self, TargetTaskCycle):
        self._TargetTaskCycle = TargetTaskCycle

    @property
    def TargetTaskAction(self):
        return self._TargetTaskAction

    @TargetTaskAction.setter
    def TargetTaskAction(self, TargetTaskAction):
        self._TargetTaskAction = TargetTaskAction

    @property
    def MapParamList(self):
        return self._MapParamList

    @MapParamList.setter
    def MapParamList(self, MapParamList):
        self._MapParamList = MapParamList

    @property
    def CreatorId(self):
        return self._CreatorId

    @CreatorId.setter
    def CreatorId(self, CreatorId):
        self._CreatorId = CreatorId

    @property
    def Creator(self):
        return self._Creator

    @Creator.setter
    def Creator(self, Creator):
        self._Creator = Creator

    @property
    def Remark(self):
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def SameSelfDependType(self):
        return self._SameSelfDependType

    @SameSelfDependType.setter
    def SameSelfDependType(self, SameSelfDependType):
        self._SameSelfDependType = SameSelfDependType

    @property
    def SourceTaskCycle(self):
        return self._SourceTaskCycle

    @SourceTaskCycle.setter
    def SourceTaskCycle(self, SourceTaskCycle):
        self._SourceTaskCycle = SourceTaskCycle

    @property
    def SchedulerResourceGroup(self):
        return self._SchedulerResourceGroup

    @SchedulerResourceGroup.setter
    def SchedulerResourceGroup(self, SchedulerResourceGroup):
        self._SchedulerResourceGroup = SchedulerResourceGroup

    @property
    def IntegrationResourceGroup(self):
        return self._IntegrationResourceGroup

    @IntegrationResourceGroup.setter
    def IntegrationResourceGroup(self, IntegrationResourceGroup):
        self._IntegrationResourceGroup = IntegrationResourceGroup

    @property
    def SchedulerResourceGroupName(self):
        return self._SchedulerResourceGroupName

    @SchedulerResourceGroupName.setter
    def SchedulerResourceGroupName(self, SchedulerResourceGroupName):
        self._SchedulerResourceGroupName = SchedulerResourceGroupName

    @property
    def IntegrationResourceGroupName(self):
        return self._IntegrationResourceGroupName

    @IntegrationResourceGroupName.setter
    def IntegrationResourceGroupName(self, IntegrationResourceGroupName):
        self._IntegrationResourceGroupName = IntegrationResourceGroupName


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._MakeName = params.get("MakeName")
        self._TaskIdList = params.get("TaskIdList")
        if params.get("MakeDatetimeList") is not None:
            self._MakeDatetimeList = []
            for item in params.get("MakeDatetimeList"):
                obj = CreateMakeDatetimeInfo()
                obj._deserialize(item)
                self._MakeDatetimeList.append(obj)
        self._ProjectIdent = params.get("ProjectIdent")
        self._CheckParent = params.get("CheckParent")
        self._CheckParentType = params.get("CheckParentType")
        self._ProjectName = params.get("ProjectName")
        self._SelfDependence = params.get("SelfDependence")
        self._ParallelNum = params.get("ParallelNum")
        self._SameCycle = params.get("SameCycle")
        self._TargetTaskCycle = params.get("TargetTaskCycle")
        self._TargetTaskAction = params.get("TargetTaskAction")
        if params.get("MapParamList") is not None:
            self._MapParamList = []
            for item in params.get("MapParamList"):
                obj = StrToStrMap()
                obj._deserialize(item)
                self._MapParamList.append(obj)
        self._CreatorId = params.get("CreatorId")
        self._Creator = params.get("Creator")
        self._Remark = params.get("Remark")
        self._SameSelfDependType = params.get("SameSelfDependType")
        self._SourceTaskCycle = params.get("SourceTaskCycle")
        self._SchedulerResourceGroup = params.get("SchedulerResourceGroup")
        self._IntegrationResourceGroup = params.get("IntegrationResourceGroup")
        self._SchedulerResourceGroupName = params.get("SchedulerResourceGroupName")
        self._IntegrationResourceGroupName = params.get("IntegrationResourceGroupName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOpsMakePlanResponse(AbstractModel):
    """CreateOpsMakePlan response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Result
        :type Data: :class:`tencentcloud.wedata.v20210820.models.CommonIdOpsDto`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = CommonIdOpsDto()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CreateRuleRequest(AbstractModel):
    """CreateRule request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _RuleGroupId: Rule Group ID
        :type RuleGroupId: int
        :param _Name: Rule name
        :type Name: str
        :param _TableId: Data Table ID
        :type TableId: str
        :param _RuleTemplateId: Rule Template List
        :type RuleTemplateId: int
        :param _Type: Rule type 1.System Template, 2.Custom Definition Template, 3.Custom Definition SQL
        :type Type: int
        :param _QualityDim: Quality Dimension of Rule (1: Accuracy, 2: Uniqueness, 3: Integrity, 4: Consistency, 5: Timeliness, 6: Validity)
        :type QualityDim: int
        :param _SourceObjectDataTypeName: Source Field Detailed Type, int, string
        :type SourceObjectDataTypeName: str
        :param _SourceObjectValue: Source Field Name
        :type SourceObjectValue: str
        :param _ConditionType: Detection Range 1.Whole Table 2.Conditional Scan
        :type ConditionType: int
        :param _ConditionExpression: Conditional Scan WHERE Condition Expression
        :type ConditionExpression: str
        :param _CustomSql: Custom Definition SQL
        :type CustomSql: str
        :param _CompareRule: Alert Trigger Condition
        :type CompareRule: :class:`tencentcloud.wedata.v20210820.models.CompareRule`
        :param _AlarmLevel: Alert Trigger Level 1.Low, 2.Medium, 3.High
        :type AlarmLevel: int
        :param _Description: Rule Description
        :type Description: str
        :param _DatasourceId: Data Source ID
        :type DatasourceId: str
        :param _DatabaseId: Database ID
        :type DatabaseId: str
        :param _TargetDatabaseId: Target Database Id
        :type TargetDatabaseId: str
        :param _TargetTableId: Target Table Id
        :type TargetTableId: str
        :param _TargetConditionExpr: Target Filter Condition Expression
        :type TargetConditionExpr: str
        :param _RelConditionExpr: Source Field and Target Field Association Condition ON Expression
        :type RelConditionExpr: str
        :param _FieldConfig: Custom Definition Template SQL Expression Field Replacement Parameter
        :type FieldConfig: :class:`tencentcloud.wedata.v20210820.models.RuleFieldConfig`
        :param _TargetObjectValue: Target Field Name CITY
        :type TargetObjectValue: str
        :param _SourceEngineTypes: Supported Execution Engine List for the Rule
        :type SourceEngineTypes: list of int non-negative
        """
        self._ProjectId = None
        self._RuleGroupId = None
        self._Name = None
        self._TableId = None
        self._RuleTemplateId = None
        self._Type = None
        self._QualityDim = None
        self._SourceObjectDataTypeName = None
        self._SourceObjectValue = None
        self._ConditionType = None
        self._ConditionExpression = None
        self._CustomSql = None
        self._CompareRule = None
        self._AlarmLevel = None
        self._Description = None
        self._DatasourceId = None
        self._DatabaseId = None
        self._TargetDatabaseId = None
        self._TargetTableId = None
        self._TargetConditionExpr = None
        self._RelConditionExpr = None
        self._FieldConfig = None
        self._TargetObjectValue = None
        self._SourceEngineTypes = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def RuleGroupId(self):
        return self._RuleGroupId

    @RuleGroupId.setter
    def RuleGroupId(self, RuleGroupId):
        self._RuleGroupId = RuleGroupId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def TableId(self):
        return self._TableId

    @TableId.setter
    def TableId(self, TableId):
        self._TableId = TableId

    @property
    def RuleTemplateId(self):
        return self._RuleTemplateId

    @RuleTemplateId.setter
    def RuleTemplateId(self, RuleTemplateId):
        self._RuleTemplateId = RuleTemplateId

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def QualityDim(self):
        return self._QualityDim

    @QualityDim.setter
    def QualityDim(self, QualityDim):
        self._QualityDim = QualityDim

    @property
    def SourceObjectDataTypeName(self):
        return self._SourceObjectDataTypeName

    @SourceObjectDataTypeName.setter
    def SourceObjectDataTypeName(self, SourceObjectDataTypeName):
        self._SourceObjectDataTypeName = SourceObjectDataTypeName

    @property
    def SourceObjectValue(self):
        return self._SourceObjectValue

    @SourceObjectValue.setter
    def SourceObjectValue(self, SourceObjectValue):
        self._SourceObjectValue = SourceObjectValue

    @property
    def ConditionType(self):
        return self._ConditionType

    @ConditionType.setter
    def ConditionType(self, ConditionType):
        self._ConditionType = ConditionType

    @property
    def ConditionExpression(self):
        return self._ConditionExpression

    @ConditionExpression.setter
    def ConditionExpression(self, ConditionExpression):
        self._ConditionExpression = ConditionExpression

    @property
    def CustomSql(self):
        return self._CustomSql

    @CustomSql.setter
    def CustomSql(self, CustomSql):
        self._CustomSql = CustomSql

    @property
    def CompareRule(self):
        return self._CompareRule

    @CompareRule.setter
    def CompareRule(self, CompareRule):
        self._CompareRule = CompareRule

    @property
    def AlarmLevel(self):
        return self._AlarmLevel

    @AlarmLevel.setter
    def AlarmLevel(self, AlarmLevel):
        self._AlarmLevel = AlarmLevel

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def DatabaseId(self):
        return self._DatabaseId

    @DatabaseId.setter
    def DatabaseId(self, DatabaseId):
        self._DatabaseId = DatabaseId

    @property
    def TargetDatabaseId(self):
        return self._TargetDatabaseId

    @TargetDatabaseId.setter
    def TargetDatabaseId(self, TargetDatabaseId):
        self._TargetDatabaseId = TargetDatabaseId

    @property
    def TargetTableId(self):
        return self._TargetTableId

    @TargetTableId.setter
    def TargetTableId(self, TargetTableId):
        self._TargetTableId = TargetTableId

    @property
    def TargetConditionExpr(self):
        return self._TargetConditionExpr

    @TargetConditionExpr.setter
    def TargetConditionExpr(self, TargetConditionExpr):
        self._TargetConditionExpr = TargetConditionExpr

    @property
    def RelConditionExpr(self):
        return self._RelConditionExpr

    @RelConditionExpr.setter
    def RelConditionExpr(self, RelConditionExpr):
        self._RelConditionExpr = RelConditionExpr

    @property
    def FieldConfig(self):
        return self._FieldConfig

    @FieldConfig.setter
    def FieldConfig(self, FieldConfig):
        self._FieldConfig = FieldConfig

    @property
    def TargetObjectValue(self):
        return self._TargetObjectValue

    @TargetObjectValue.setter
    def TargetObjectValue(self, TargetObjectValue):
        self._TargetObjectValue = TargetObjectValue

    @property
    def SourceEngineTypes(self):
        return self._SourceEngineTypes

    @SourceEngineTypes.setter
    def SourceEngineTypes(self, SourceEngineTypes):
        self._SourceEngineTypes = SourceEngineTypes


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._RuleGroupId = params.get("RuleGroupId")
        self._Name = params.get("Name")
        self._TableId = params.get("TableId")
        self._RuleTemplateId = params.get("RuleTemplateId")
        self._Type = params.get("Type")
        self._QualityDim = params.get("QualityDim")
        self._SourceObjectDataTypeName = params.get("SourceObjectDataTypeName")
        self._SourceObjectValue = params.get("SourceObjectValue")
        self._ConditionType = params.get("ConditionType")
        self._ConditionExpression = params.get("ConditionExpression")
        self._CustomSql = params.get("CustomSql")
        if params.get("CompareRule") is not None:
            self._CompareRule = CompareRule()
            self._CompareRule._deserialize(params.get("CompareRule"))
        self._AlarmLevel = params.get("AlarmLevel")
        self._Description = params.get("Description")
        self._DatasourceId = params.get("DatasourceId")
        self._DatabaseId = params.get("DatabaseId")
        self._TargetDatabaseId = params.get("TargetDatabaseId")
        self._TargetTableId = params.get("TargetTableId")
        self._TargetConditionExpr = params.get("TargetConditionExpr")
        self._RelConditionExpr = params.get("RelConditionExpr")
        if params.get("FieldConfig") is not None:
            self._FieldConfig = RuleFieldConfig()
            self._FieldConfig._deserialize(params.get("FieldConfig"))
        self._TargetObjectValue = params.get("TargetObjectValue")
        self._SourceEngineTypes = params.get("SourceEngineTypes")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRuleResponse(AbstractModel):
    """CreateRule response structure.

    """

    def __init__(self):
        r"""
        :param _Data: RuleNote: This field may return null, indicating that no valid value can be obtained.
        :type Data: :class:`tencentcloud.wedata.v20210820.models.Rule`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = Rule()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CreateRuleTemplateRequest(AbstractModel):
    """CreateRuleTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Type: Template Type 1. System Template 2. Custom Definition Template
        :type Type: int
        :param _Name: Template Name
        :type Name: str
        :param _QualityDim: Quality Inspection Dimension 1. Accuracy 2. Uniqueness 3. Integrity 4. Consistency 5. Timeliness 6. Validity
        :type QualityDim: int
        :param _SourceObjectType: Source Data Object Type 1. Constant 2. Offline Table Level 2. Offline Field Level
        :type SourceObjectType: int
        :param _Description: Template Description
        :type Description: str
        :param _SourceEngineTypes: Corresponding Engine Type of the Source
        :type SourceEngineTypes: list of int non-negative
        :param _MultiSourceFlag: Whether to Associate with Other Databases and Tables
        :type MultiSourceFlag: bool
        :param _SqlExpression: SQL Expression
        :type SqlExpression: str
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _WhereFlag: Whether to add where parameter
        :type WhereFlag: bool
        """
        self._Type = None
        self._Name = None
        self._QualityDim = None
        self._SourceObjectType = None
        self._Description = None
        self._SourceEngineTypes = None
        self._MultiSourceFlag = None
        self._SqlExpression = None
        self._ProjectId = None
        self._WhereFlag = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def QualityDim(self):
        return self._QualityDim

    @QualityDim.setter
    def QualityDim(self, QualityDim):
        self._QualityDim = QualityDim

    @property
    def SourceObjectType(self):
        return self._SourceObjectType

    @SourceObjectType.setter
    def SourceObjectType(self, SourceObjectType):
        self._SourceObjectType = SourceObjectType

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def SourceEngineTypes(self):
        return self._SourceEngineTypes

    @SourceEngineTypes.setter
    def SourceEngineTypes(self, SourceEngineTypes):
        self._SourceEngineTypes = SourceEngineTypes

    @property
    def MultiSourceFlag(self):
        return self._MultiSourceFlag

    @MultiSourceFlag.setter
    def MultiSourceFlag(self, MultiSourceFlag):
        self._MultiSourceFlag = MultiSourceFlag

    @property
    def SqlExpression(self):
        return self._SqlExpression

    @SqlExpression.setter
    def SqlExpression(self, SqlExpression):
        self._SqlExpression = SqlExpression

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def WhereFlag(self):
        return self._WhereFlag

    @WhereFlag.setter
    def WhereFlag(self, WhereFlag):
        self._WhereFlag = WhereFlag


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        self._QualityDim = params.get("QualityDim")
        self._SourceObjectType = params.get("SourceObjectType")
        self._Description = params.get("Description")
        self._SourceEngineTypes = params.get("SourceEngineTypes")
        self._MultiSourceFlag = params.get("MultiSourceFlag")
        self._SqlExpression = params.get("SqlExpression")
        self._ProjectId = params.get("ProjectId")
        self._WhereFlag = params.get("WhereFlag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRuleTemplateResponse(AbstractModel):
    """CreateRuleTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Template ID
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CreateTaskAlarmRegularRequest(AbstractModel):
    """CreateTaskAlarmRegular request structure.

    """

    def __init__(self):
        r"""
        :param _TaskAlarmInfo: Alert Configuration Information
        :type TaskAlarmInfo: :class:`tencentcloud.wedata.v20210820.models.TaskAlarmInfo`
        :param _ProjectId: Project ID
        :type ProjectId: str
        """
        self._TaskAlarmInfo = None
        self._ProjectId = None

    @property
    def TaskAlarmInfo(self):
        return self._TaskAlarmInfo

    @TaskAlarmInfo.setter
    def TaskAlarmInfo(self, TaskAlarmInfo):
        self._TaskAlarmInfo = TaskAlarmInfo

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        if params.get("TaskAlarmInfo") is not None:
            self._TaskAlarmInfo = TaskAlarmInfo()
            self._TaskAlarmInfo._deserialize(params.get("TaskAlarmInfo"))
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateTaskAlarmRegularResponse(AbstractModel):
    """CreateTaskAlarmRegular response structure.

    """

    def __init__(self):
        r"""
        :param _AlarmId: Alert ID
        :type AlarmId: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._AlarmId = None
        self._RequestId = None

    @property
    def AlarmId(self):
        return self._AlarmId

    @AlarmId.setter
    def AlarmId(self, AlarmId):
        self._AlarmId = AlarmId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AlarmId = params.get("AlarmId")
        self._RequestId = params.get("RequestId")


class CreateTaskFolderRequest(AbstractModel):
    """CreateTaskFolder request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _FolderName: Folder Name
        :type FolderName: str
        :param _WorkflowId: Workflow ID
        :type WorkflowId: str
        :param _ParentFolderId: Parent Folder ID
        :type ParentFolderId: str
        """
        self._ProjectId = None
        self._FolderName = None
        self._WorkflowId = None
        self._ParentFolderId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def FolderName(self):
        return self._FolderName

    @FolderName.setter
    def FolderName(self, FolderName):
        self._FolderName = FolderName

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId

    @property
    def ParentFolderId(self):
        return self._ParentFolderId

    @ParentFolderId.setter
    def ParentFolderId(self, ParentFolderId):
        self._ParentFolderId = ParentFolderId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._FolderName = params.get("FolderName")
        self._WorkflowId = params.get("WorkflowId")
        self._ParentFolderId = params.get("ParentFolderId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateTaskFolderResponse(AbstractModel):
    """CreateTaskFolder response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Task Folder ID, null if creation failed
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CreateTaskRequest(AbstractModel):
    """CreateTask request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _WorkflowId: Workflow ID
        :type WorkflowId: str
        :param _TaskName: Task Name
        :type TaskName: str
        :param _TaskType: 26 Offline Synchronization,30 Python,31 PySpark,32 DLC,33 Impala,34 Hive SQL,35 Shell,36 Spark SQL,39 Spark,40 TCHouse-P,92 MapReduce
        :type TaskType: int
        :param _TaskExt: Extended Attributes
        :type TaskExt: list of TaskExtInfo
        """
        self._ProjectId = None
        self._WorkflowId = None
        self._TaskName = None
        self._TaskType = None
        self._TaskExt = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId

    @property
    def TaskName(self):
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def TaskExt(self):
        return self._TaskExt

    @TaskExt.setter
    def TaskExt(self, TaskExt):
        self._TaskExt = TaskExt


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._WorkflowId = params.get("WorkflowId")
        self._TaskName = params.get("TaskName")
        self._TaskType = params.get("TaskType")
        if params.get("TaskExt") is not None:
            self._TaskExt = []
            for item in params.get("TaskExt"):
                obj = TaskExtInfo()
                obj._deserialize(item)
                self._TaskExt.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateTaskResponse(AbstractModel):
    """CreateTask response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Return Task ID
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: :class:`tencentcloud.wedata.v20210820.models.CommonId`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = CommonId()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CreateTaskVersionDsRequest(AbstractModel):
    """CreateTaskVersionDs request structure.

    """

    def __init__(self):
        r"""
        :param _Task: Task ID
        :type Task: :class:`tencentcloud.wedata.v20210820.models.BatchCreateTaskVersionDTO`
        :param _NeedCheckParentSubmitted: Whether to verify that the parent task has been submitted for scheduling
        :type NeedCheckParentSubmitted: bool
        :param _AutoRun: Automatic Execution
        :type AutoRun: bool
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _RequestFromSource: Request Source, WEB frontend; CLIENT client
        :type RequestFromSource: str
        :param _AlarmWays: Alert Method: email-Email; sms-SMS; wecom-WeCom
        :type AlarmWays: str
        :param _AlarmRecipientTypes: Alert Object: 1-Project Administrator, 2-Task Owner
        :type AlarmRecipientTypes: str
        :param _EnableCheckTaskCycleLink: Whether to verify circular dependencies, default is true. If false is passed after successful validation using CheckTaskCycleLink and CheckTaskCycleConfiguration interfaces, the back-end server will not perform validation
        :type EnableCheckTaskCycleLink: bool
        """
        self._Task = None
        self._NeedCheckParentSubmitted = None
        self._AutoRun = None
        self._ProjectId = None
        self._RequestFromSource = None
        self._AlarmWays = None
        self._AlarmRecipientTypes = None
        self._EnableCheckTaskCycleLink = None

    @property
    def Task(self):
        return self._Task

    @Task.setter
    def Task(self, Task):
        self._Task = Task

    @property
    def NeedCheckParentSubmitted(self):
        return self._NeedCheckParentSubmitted

    @NeedCheckParentSubmitted.setter
    def NeedCheckParentSubmitted(self, NeedCheckParentSubmitted):
        self._NeedCheckParentSubmitted = NeedCheckParentSubmitted

    @property
    def AutoRun(self):
        return self._AutoRun

    @AutoRun.setter
    def AutoRun(self, AutoRun):
        self._AutoRun = AutoRun

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def RequestFromSource(self):
        return self._RequestFromSource

    @RequestFromSource.setter
    def RequestFromSource(self, RequestFromSource):
        self._RequestFromSource = RequestFromSource

    @property
    def AlarmWays(self):
        return self._AlarmWays

    @AlarmWays.setter
    def AlarmWays(self, AlarmWays):
        self._AlarmWays = AlarmWays

    @property
    def AlarmRecipientTypes(self):
        return self._AlarmRecipientTypes

    @AlarmRecipientTypes.setter
    def AlarmRecipientTypes(self, AlarmRecipientTypes):
        self._AlarmRecipientTypes = AlarmRecipientTypes

    @property
    def EnableCheckTaskCycleLink(self):
        return self._EnableCheckTaskCycleLink

    @EnableCheckTaskCycleLink.setter
    def EnableCheckTaskCycleLink(self, EnableCheckTaskCycleLink):
        self._EnableCheckTaskCycleLink = EnableCheckTaskCycleLink


    def _deserialize(self, params):
        if params.get("Task") is not None:
            self._Task = BatchCreateTaskVersionDTO()
            self._Task._deserialize(params.get("Task"))
        self._NeedCheckParentSubmitted = params.get("NeedCheckParentSubmitted")
        self._AutoRun = params.get("AutoRun")
        self._ProjectId = params.get("ProjectId")
        self._RequestFromSource = params.get("RequestFromSource")
        self._AlarmWays = params.get("AlarmWays")
        self._AlarmRecipientTypes = params.get("AlarmRecipientTypes")
        self._EnableCheckTaskCycleLink = params.get("EnableCheckTaskCycleLink")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateTaskVersionDsResponse(AbstractModel):
    """CreateTaskVersionDs response structure.

    """

    def __init__(self):
        r"""
        :param _Data: VersionNote: This field may return null, indicating that no valid value can be obtained.
        :type Data: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CreateWorkflowDsRequest(AbstractModel):
    """CreateWorkflowDs request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _WorkflowName: Workflow name
        :type WorkflowName: str
        :param _FolderId: Folder ID
        :type FolderId: str
        :param _WorkflowDesc: Workflow Description
        :type WorkflowDesc: str
        """
        self._ProjectId = None
        self._WorkflowName = None
        self._FolderId = None
        self._WorkflowDesc = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def WorkflowName(self):
        return self._WorkflowName

    @WorkflowName.setter
    def WorkflowName(self, WorkflowName):
        self._WorkflowName = WorkflowName

    @property
    def FolderId(self):
        return self._FolderId

    @FolderId.setter
    def FolderId(self, FolderId):
        self._FolderId = FolderId

    @property
    def WorkflowDesc(self):
        return self._WorkflowDesc

    @WorkflowDesc.setter
    def WorkflowDesc(self, WorkflowDesc):
        self._WorkflowDesc = WorkflowDesc


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._WorkflowName = params.get("WorkflowName")
        self._FolderId = params.get("FolderId")
        self._WorkflowDesc = params.get("WorkflowDesc")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateWorkflowDsResponse(AbstractModel):
    """CreateWorkflowDs response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Workflow ID
        :type Data: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DagInstancesRequest(AbstractModel):
    """DagInstances request structure.

    """

    def __init__(self):
        r"""
        :param _Instances: Instance List
        :type Instances: list of InstanceOpsDto
        :param _CheckFather: Check Parent Task Type, true: Check parent task; false: Do not check parent task
        :type CheckFather: bool
        :param _RerunType: Rerun Type, 1: Self; 3: Child; 2: Self and Child
        :type RerunType: str
        :param _DependentWay: Instance Dependency Mode, 1: Self-dependent; 2: Task-dependent; 3: Self and Parent-Child dependent
        :type DependentWay: str
        :param _SkipEventListening: Rerun Ignore Event Listening or Not
        :type SkipEventListening: bool
        :param _SonInstanceType: Downstream Instance Range 1: Within the workflow 2: Within the project 3: Across all workflows dependent on the project
        :type SonInstanceType: str
        :param _SearchCondition: Query conditions, this interface requires the example information to be placed in this field
        :type SearchCondition: :class:`tencentcloud.wedata.v20210820.models.InstanceApiOpsRequest`
        :param _OptType: Access type
        :type OptType: str
        :param _OperatorName: Operator Name
        :type OperatorName: str
        :param _OperatorId: Operator ID
        :type OperatorId: str
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _ProjectIdent: Project Identifier
        :type ProjectIdent: str
        :param _ProjectName: Project name
        :type ProjectName: str
        :param _PageIndex: Index Page Number
        :type PageIndex: int
        :param _PageSize: Page size
        :type PageSize: int
        :param _Count: Total Data
        :type Count: int
        :param _RequestBaseInfo: Basic Request Information
        :type RequestBaseInfo: :class:`tencentcloud.wedata.v20210820.models.ProjectBaseInfoOpsRequest`
        :param _IsCount: Whether to Calculate Total
        :type IsCount: bool
        """
        self._Instances = None
        self._CheckFather = None
        self._RerunType = None
        self._DependentWay = None
        self._SkipEventListening = None
        self._SonInstanceType = None
        self._SearchCondition = None
        self._OptType = None
        self._OperatorName = None
        self._OperatorId = None
        self._ProjectId = None
        self._ProjectIdent = None
        self._ProjectName = None
        self._PageIndex = None
        self._PageSize = None
        self._Count = None
        self._RequestBaseInfo = None
        self._IsCount = None

    @property
    def Instances(self):
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances

    @property
    def CheckFather(self):
        return self._CheckFather

    @CheckFather.setter
    def CheckFather(self, CheckFather):
        self._CheckFather = CheckFather

    @property
    def RerunType(self):
        return self._RerunType

    @RerunType.setter
    def RerunType(self, RerunType):
        self._RerunType = RerunType

    @property
    def DependentWay(self):
        return self._DependentWay

    @DependentWay.setter
    def DependentWay(self, DependentWay):
        self._DependentWay = DependentWay

    @property
    def SkipEventListening(self):
        return self._SkipEventListening

    @SkipEventListening.setter
    def SkipEventListening(self, SkipEventListening):
        self._SkipEventListening = SkipEventListening

    @property
    def SonInstanceType(self):
        return self._SonInstanceType

    @SonInstanceType.setter
    def SonInstanceType(self, SonInstanceType):
        self._SonInstanceType = SonInstanceType

    @property
    def SearchCondition(self):
        return self._SearchCondition

    @SearchCondition.setter
    def SearchCondition(self, SearchCondition):
        self._SearchCondition = SearchCondition

    @property
    def OptType(self):
        return self._OptType

    @OptType.setter
    def OptType(self, OptType):
        self._OptType = OptType

    @property
    def OperatorName(self):
        return self._OperatorName

    @OperatorName.setter
    def OperatorName(self, OperatorName):
        self._OperatorName = OperatorName

    @property
    def OperatorId(self):
        return self._OperatorId

    @OperatorId.setter
    def OperatorId(self, OperatorId):
        self._OperatorId = OperatorId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ProjectIdent(self):
        return self._ProjectIdent

    @ProjectIdent.setter
    def ProjectIdent(self, ProjectIdent):
        self._ProjectIdent = ProjectIdent

    @property
    def ProjectName(self):
        return self._ProjectName

    @ProjectName.setter
    def ProjectName(self, ProjectName):
        self._ProjectName = ProjectName

    @property
    def PageIndex(self):
        return self._PageIndex

    @PageIndex.setter
    def PageIndex(self, PageIndex):
        self._PageIndex = PageIndex

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Count(self):
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def RequestBaseInfo(self):
        return self._RequestBaseInfo

    @RequestBaseInfo.setter
    def RequestBaseInfo(self, RequestBaseInfo):
        self._RequestBaseInfo = RequestBaseInfo

    @property
    def IsCount(self):
        return self._IsCount

    @IsCount.setter
    def IsCount(self, IsCount):
        self._IsCount = IsCount


    def _deserialize(self, params):
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = InstanceOpsDto()
                obj._deserialize(item)
                self._Instances.append(obj)
        self._CheckFather = params.get("CheckFather")
        self._RerunType = params.get("RerunType")
        self._DependentWay = params.get("DependentWay")
        self._SkipEventListening = params.get("SkipEventListening")
        self._SonInstanceType = params.get("SonInstanceType")
        if params.get("SearchCondition") is not None:
            self._SearchCondition = InstanceApiOpsRequest()
            self._SearchCondition._deserialize(params.get("SearchCondition"))
        self._OptType = params.get("OptType")
        self._OperatorName = params.get("OperatorName")
        self._OperatorId = params.get("OperatorId")
        self._ProjectId = params.get("ProjectId")
        self._ProjectIdent = params.get("ProjectIdent")
        self._ProjectName = params.get("ProjectName")
        self._PageIndex = params.get("PageIndex")
        self._PageSize = params.get("PageSize")
        self._Count = params.get("Count")
        if params.get("RequestBaseInfo") is not None:
            self._RequestBaseInfo = ProjectBaseInfoOpsRequest()
            self._RequestBaseInfo._deserialize(params.get("RequestBaseInfo"))
        self._IsCount = params.get("IsCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DagInstancesResponse(AbstractModel):
    """DagInstances response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Result
        :type Data: :class:`tencentcloud.wedata.v20210820.models.CollectionInstanceOpsDto`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = CollectionInstanceOpsDto()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DailyScoreInfo(AbstractModel):
    """Daily Rating Information

    """

    def __init__(self):
        r"""
        :param _StatisticsDate: Statistics Date TimestampNote: This field may return null, indicating that no valid value can be obtained.
        :type StatisticsDate: int
        :param _Score: ScoringNote: This field may return null, indicating that no valid value can be obtained.
        :type Score: float
        """
        self._StatisticsDate = None
        self._Score = None

    @property
    def StatisticsDate(self):
        return self._StatisticsDate

    @StatisticsDate.setter
    def StatisticsDate(self, StatisticsDate):
        self._StatisticsDate = StatisticsDate

    @property
    def Score(self):
        return self._Score

    @Score.setter
    def Score(self, Score):
        self._Score = Score


    def _deserialize(self, params):
        self._StatisticsDate = params.get("StatisticsDate")
        self._Score = params.get("Score")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataCheckStat(AbstractModel):
    """Data Monitoring Results

    """

    def __init__(self):
        r"""
        :param _TableTotal: Total Tables
        :type TableTotal: int
        :param _ColumnTotal: Total Number of Fields
        :type ColumnTotal: int
        :param _TableConfig: Number of Table Configuration Checks
        :type TableConfig: int
        :param _ColumnConfig: Number of Field Configuration Checks
        :type ColumnConfig: int
        :param _TableExec: Actual Number of Table Checks
        :type TableExec: int
        :param _ColumnExec: Actual Number of Field Checks
        :type ColumnExec: int
        """
        self._TableTotal = None
        self._ColumnTotal = None
        self._TableConfig = None
        self._ColumnConfig = None
        self._TableExec = None
        self._ColumnExec = None

    @property
    def TableTotal(self):
        return self._TableTotal

    @TableTotal.setter
    def TableTotal(self, TableTotal):
        self._TableTotal = TableTotal

    @property
    def ColumnTotal(self):
        return self._ColumnTotal

    @ColumnTotal.setter
    def ColumnTotal(self, ColumnTotal):
        self._ColumnTotal = ColumnTotal

    @property
    def TableConfig(self):
        return self._TableConfig

    @TableConfig.setter
    def TableConfig(self, TableConfig):
        self._TableConfig = TableConfig

    @property
    def ColumnConfig(self):
        return self._ColumnConfig

    @ColumnConfig.setter
    def ColumnConfig(self, ColumnConfig):
        self._ColumnConfig = ColumnConfig

    @property
    def TableExec(self):
        return self._TableExec

    @TableExec.setter
    def TableExec(self, TableExec):
        self._TableExec = TableExec

    @property
    def ColumnExec(self):
        return self._ColumnExec

    @ColumnExec.setter
    def ColumnExec(self, ColumnExec):
        self._ColumnExec = ColumnExec


    def _deserialize(self, params):
        self._TableTotal = params.get("TableTotal")
        self._ColumnTotal = params.get("ColumnTotal")
        self._TableConfig = params.get("TableConfig")
        self._ColumnConfig = params.get("ColumnConfig")
        self._TableExec = params.get("TableExec")
        self._ColumnExec = params.get("ColumnExec")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataSourceInfo(AbstractModel):
    """Data Source Object

    """

    def __init__(self):
        r"""
        :param _DatabaseName: If the data source list is bound to a database, then it is the database nameNote: This field may return null, indicating that no valid value can be obtained.
        :type DatabaseName: str
        :param _Description: Data source description informationNote: This field may return null, indicating that no valid value can be obtained.
        :type Description: str
        :param _ID: Data Source ID
Note: This field may return null, indicating that no valid value can be obtained.
        :type ID: int
        :param _Instance: Instance ID of the data source engine, e.g., CDB Instance IDNote: This field may return null, indicating that no valid value can be obtained.
        :type Instance: str
        :param _Name: Data Source Name, cannot be empty under the same SpaceNameNote: This field may return null, indicating that no valid value can be obtained.
        :type Name: str
        :param _Region: Region to which the data source engine belongs
Note: This field may return null, indicating that no valid value can be obtained.
        :type Region: str
        :param _Type: Data Source Type: enumerated valuesNote: This field may return null, indicating that no valid value can be obtained.
        :type Type: str
        :param _ClusterId: Cluster ID to which the data source belongs
Note: This field may return null, indicating that no valid value can be obtained.
        :type ClusterId: str
        :param _AppId: Application ID AppId
Note: This field may return null, indicating that no valid value can be obtained.
        :type AppId: int
        :param _BizParams: Configuration Information Extension of Business Data SourceNote: This field may return null, indicating that no valid value can be obtained.
        :type BizParams: str
        :param _Category: Data Source Category: Binding Engine, Binding DatabaseNote: This field may return null, indicating that no valid value can be obtained.
        :type Category: str
        :param _Display: Data Source Display Name, for visual inspectionNote: This field may return null, indicating that no valid value can be obtained.
        :type Display: str
        :param _OwnerAccount: Data Source Responsible Person Account ID
Note: This field may return null, indicating that no valid value can be obtained.
        :type OwnerAccount: str
        :param _Params: Data source configuration information, stored as JSON KV. The KV storage information varies according to the data source typeNote: This field may return null, indicating that no valid value can be obtained.
        :type Params: str
        :param _Status: Visibility of the data source, where 1 is visible and 0 is not visible. Default is 1Note: This field may return null, indicating that no valid value can be obtained.
        :type Status: int
        :param _OwnerAccountName: Data source owner account name
Note: This field may return null, indicating that no valid value can be obtained.
        :type OwnerAccountName: str
        :param _ClusterName: Cluster NameNote: This field may return null, indicating that no valid value can be obtained.
        :type ClusterName: str
        :param _OwnerProjectId: Project IDNote: This field may return null, indicating that no valid value can be obtained.
        :type OwnerProjectId: str
        :param _OwnerProjectName: Project NameNote: This field may return null, indicating that no valid value can be obtained.
        :type OwnerProjectName: str
        :param _OwnerProjectIdent: Belonging project identifier
Note: This field may return null, indicating that no valid value can be obtained.
        :type OwnerProjectIdent: str
        :param _AuthorityProjectName: Authorized project
Note: This field may return null, indicating that no valid value can be obtained.
        :type AuthorityProjectName: str
        :param _AuthorityUserName: Authorized user
Note: This field may return null, indicating that no valid value can be obtained.
        :type AuthorityUserName: str
        :param _Edit: Edit permissions available
Note: This field may return null, indicating that no valid value can be obtained.
        :type Edit: bool
        :param _Author: Authorization permissions available
Note: This field may return null, indicating that no valid value can be obtained.
        :type Author: bool
        :param _Deliver: Transfer permissions available
Note: This field may return null, indicating that no valid value can be obtained.
        :type Deliver: bool
        :param _DataSourceStatus: Data source status
Note: This field may return null, indicating that no valid value can be obtained.
        :type DataSourceStatus: str
        :param _CreateTime: TimeNote: This field may return null, indicating that no valid value can be obtained.
        :type CreateTime: int
        :param _ParamsString: Params JSON string
Note: This field may return null, indicating that no valid value can be obtained.
        :type ParamsString: str
        :param _BizParamsString: BizParams JSON string
Note: This field may return null, indicating that no valid value can be obtained.
        :type BizParamsString: str
        :param _ModifiedTime: Modification TimeNote: This field may return null, indicating that no valid value can be obtained.
        :type ModifiedTime: int
        :param _ShowType: Data source display type, corresponding to Type
Note: This field may return null, indicating that no valid value can be obtained.
        :type ShowType: str
        :param _ProductId: Current data source production source Id
Note: This field may return null, indicating that no valid value can be obtained.
        :type ProductId: int
        :param _DevelopmentId: Current data source development source Id
Note: This field may return null, indicating that no valid value can be obtained.
        :type DevelopmentId: int
        :param _DevelopmentParams: Same as params, content is the data for the development data source
Note: This field may return null, indicating that no valid value can be obtained.
        :type DevelopmentParams: str
        """
        self._DatabaseName = None
        self._Description = None
        self._ID = None
        self._Instance = None
        self._Name = None
        self._Region = None
        self._Type = None
        self._ClusterId = None
        self._AppId = None
        self._BizParams = None
        self._Category = None
        self._Display = None
        self._OwnerAccount = None
        self._Params = None
        self._Status = None
        self._OwnerAccountName = None
        self._ClusterName = None
        self._OwnerProjectId = None
        self._OwnerProjectName = None
        self._OwnerProjectIdent = None
        self._AuthorityProjectName = None
        self._AuthorityUserName = None
        self._Edit = None
        self._Author = None
        self._Deliver = None
        self._DataSourceStatus = None
        self._CreateTime = None
        self._ParamsString = None
        self._BizParamsString = None
        self._ModifiedTime = None
        self._ShowType = None
        self._ProductId = None
        self._DevelopmentId = None
        self._DevelopmentParams = None

    @property
    def DatabaseName(self):
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def ID(self):
        return self._ID

    @ID.setter
    def ID(self, ID):
        self._ID = ID

    @property
    def Instance(self):
        return self._Instance

    @Instance.setter
    def Instance(self, Instance):
        self._Instance = Instance

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def AppId(self):
        return self._AppId

    @AppId.setter
    def AppId(self, AppId):
        self._AppId = AppId

    @property
    def BizParams(self):
        return self._BizParams

    @BizParams.setter
    def BizParams(self, BizParams):
        self._BizParams = BizParams

    @property
    def Category(self):
        return self._Category

    @Category.setter
    def Category(self, Category):
        self._Category = Category

    @property
    def Display(self):
        return self._Display

    @Display.setter
    def Display(self, Display):
        self._Display = Display

    @property
    def OwnerAccount(self):
        return self._OwnerAccount

    @OwnerAccount.setter
    def OwnerAccount(self, OwnerAccount):
        self._OwnerAccount = OwnerAccount

    @property
    def Params(self):
        return self._Params

    @Params.setter
    def Params(self, Params):
        self._Params = Params

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def OwnerAccountName(self):
        return self._OwnerAccountName

    @OwnerAccountName.setter
    def OwnerAccountName(self, OwnerAccountName):
        self._OwnerAccountName = OwnerAccountName

    @property
    def ClusterName(self):
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def OwnerProjectId(self):
        return self._OwnerProjectId

    @OwnerProjectId.setter
    def OwnerProjectId(self, OwnerProjectId):
        self._OwnerProjectId = OwnerProjectId

    @property
    def OwnerProjectName(self):
        return self._OwnerProjectName

    @OwnerProjectName.setter
    def OwnerProjectName(self, OwnerProjectName):
        self._OwnerProjectName = OwnerProjectName

    @property
    def OwnerProjectIdent(self):
        return self._OwnerProjectIdent

    @OwnerProjectIdent.setter
    def OwnerProjectIdent(self, OwnerProjectIdent):
        self._OwnerProjectIdent = OwnerProjectIdent

    @property
    def AuthorityProjectName(self):
        return self._AuthorityProjectName

    @AuthorityProjectName.setter
    def AuthorityProjectName(self, AuthorityProjectName):
        self._AuthorityProjectName = AuthorityProjectName

    @property
    def AuthorityUserName(self):
        return self._AuthorityUserName

    @AuthorityUserName.setter
    def AuthorityUserName(self, AuthorityUserName):
        self._AuthorityUserName = AuthorityUserName

    @property
    def Edit(self):
        return self._Edit

    @Edit.setter
    def Edit(self, Edit):
        self._Edit = Edit

    @property
    def Author(self):
        return self._Author

    @Author.setter
    def Author(self, Author):
        self._Author = Author

    @property
    def Deliver(self):
        return self._Deliver

    @Deliver.setter
    def Deliver(self, Deliver):
        self._Deliver = Deliver

    @property
    def DataSourceStatus(self):
        return self._DataSourceStatus

    @DataSourceStatus.setter
    def DataSourceStatus(self, DataSourceStatus):
        self._DataSourceStatus = DataSourceStatus

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ParamsString(self):
        return self._ParamsString

    @ParamsString.setter
    def ParamsString(self, ParamsString):
        self._ParamsString = ParamsString

    @property
    def BizParamsString(self):
        return self._BizParamsString

    @BizParamsString.setter
    def BizParamsString(self, BizParamsString):
        self._BizParamsString = BizParamsString

    @property
    def ModifiedTime(self):
        return self._ModifiedTime

    @ModifiedTime.setter
    def ModifiedTime(self, ModifiedTime):
        self._ModifiedTime = ModifiedTime

    @property
    def ShowType(self):
        return self._ShowType

    @ShowType.setter
    def ShowType(self, ShowType):
        self._ShowType = ShowType

    @property
    def ProductId(self):
        return self._ProductId

    @ProductId.setter
    def ProductId(self, ProductId):
        self._ProductId = ProductId

    @property
    def DevelopmentId(self):
        return self._DevelopmentId

    @DevelopmentId.setter
    def DevelopmentId(self, DevelopmentId):
        self._DevelopmentId = DevelopmentId

    @property
    def DevelopmentParams(self):
        return self._DevelopmentParams

    @DevelopmentParams.setter
    def DevelopmentParams(self, DevelopmentParams):
        self._DevelopmentParams = DevelopmentParams


    def _deserialize(self, params):
        self._DatabaseName = params.get("DatabaseName")
        self._Description = params.get("Description")
        self._ID = params.get("ID")
        self._Instance = params.get("Instance")
        self._Name = params.get("Name")
        self._Region = params.get("Region")
        self._Type = params.get("Type")
        self._ClusterId = params.get("ClusterId")
        self._AppId = params.get("AppId")
        self._BizParams = params.get("BizParams")
        self._Category = params.get("Category")
        self._Display = params.get("Display")
        self._OwnerAccount = params.get("OwnerAccount")
        self._Params = params.get("Params")
        self._Status = params.get("Status")
        self._OwnerAccountName = params.get("OwnerAccountName")
        self._ClusterName = params.get("ClusterName")
        self._OwnerProjectId = params.get("OwnerProjectId")
        self._OwnerProjectName = params.get("OwnerProjectName")
        self._OwnerProjectIdent = params.get("OwnerProjectIdent")
        self._AuthorityProjectName = params.get("AuthorityProjectName")
        self._AuthorityUserName = params.get("AuthorityUserName")
        self._Edit = params.get("Edit")
        self._Author = params.get("Author")
        self._Deliver = params.get("Deliver")
        self._DataSourceStatus = params.get("DataSourceStatus")
        self._CreateTime = params.get("CreateTime")
        self._ParamsString = params.get("ParamsString")
        self._BizParamsString = params.get("BizParamsString")
        self._ModifiedTime = params.get("ModifiedTime")
        self._ShowType = params.get("ShowType")
        self._ProductId = params.get("ProductId")
        self._DevelopmentId = params.get("DevelopmentId")
        self._DevelopmentParams = params.get("DevelopmentParams")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataSourceInfoPage(AbstractModel):
    """Query Data Source Pagination List

    """

    def __init__(self):
        r"""
        :param _PageNumber: pagination page number
Note: This field may return null, indicating that no valid value can be obtained.
        :type PageNumber: int
        :param _PageSize: pagination size
Note: This field may return null, indicating that no valid value can be obtained.
        :type PageSize: int
        :param _Rows: data source list
Note: This field may return null, indicating that no valid value can be obtained.
        :type Rows: list of DataSourceInfo
        :param _TotalCount: Total numberNote: This field may return null, indicating that no valid value can be obtained.
        :type TotalCount: int
        :param _TotalPageNumber: total pagination pages
Note: This field may return null, indicating that no valid value can be obtained.
        :type TotalPageNumber: int
        """
        self._PageNumber = None
        self._PageSize = None
        self._Rows = None
        self._TotalCount = None
        self._TotalPageNumber = None

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Rows(self):
        return self._Rows

    @Rows.setter
    def Rows(self, Rows):
        self._Rows = Rows

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TotalPageNumber(self):
        return self._TotalPageNumber

    @TotalPageNumber.setter
    def TotalPageNumber(self, TotalPageNumber):
        self._TotalPageNumber = TotalPageNumber


    def _deserialize(self, params):
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Rows") is not None:
            self._Rows = []
            for item in params.get("Rows"):
                obj = DataSourceInfo()
                obj._deserialize(item)
                self._Rows.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._TotalPageNumber = params.get("TotalPageNumber")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DatabaseInfo(AbstractModel):
    """Data Quality Data Source Database

    """

    def __init__(self):
        r"""
        :param _DatasourceName: Data source name
Note: This field may return null, indicating that no valid value can be obtained.
        :type DatasourceName: str
        :param _DatasourceId: Data Source IDNote: This field may return null, indicating that no valid value can be obtained.
        :type DatasourceId: str
        :param _DatabaseName: Database nameNote: This field may return null, indicating that no valid value can be obtained.
        :type DatabaseName: str
        :param _DatabaseId: Database id
Note: This field may return null, indicating that no valid value can be obtained.
        :type DatabaseId: str
        :param _InstanceId: Instance Id
Note: This field may return null, indicating that no valid value can be obtained.
        :type InstanceId: str
        :param _DatasourceType: Data source typeNote: This field may return null, indicating that no valid value can be obtained.
        :type DatasourceType: int
        :param _OriginDatabaseName: Database Original Name
Note: This field may return null, indicating that no valid value can be obtained.
        :type OriginDatabaseName: str
        :param _OriginSchemaName: Schema NameNote: This field may return null, indicating that no valid value can be obtained.
        :type OriginSchemaName: str
        :param _DsEnvType: 0 or Not Returned. Undefined, 1. generation 2. development
Note: This field may return null, indicating that no valid value can be obtained.
        :type DsEnvType: int
        """
        self._DatasourceName = None
        self._DatasourceId = None
        self._DatabaseName = None
        self._DatabaseId = None
        self._InstanceId = None
        self._DatasourceType = None
        self._OriginDatabaseName = None
        self._OriginSchemaName = None
        self._DsEnvType = None

    @property
    def DatasourceName(self):
        return self._DatasourceName

    @DatasourceName.setter
    def DatasourceName(self, DatasourceName):
        self._DatasourceName = DatasourceName

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def DatabaseName(self):
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def DatabaseId(self):
        return self._DatabaseId

    @DatabaseId.setter
    def DatabaseId(self, DatabaseId):
        self._DatabaseId = DatabaseId

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def DatasourceType(self):
        return self._DatasourceType

    @DatasourceType.setter
    def DatasourceType(self, DatasourceType):
        self._DatasourceType = DatasourceType

    @property
    def OriginDatabaseName(self):
        return self._OriginDatabaseName

    @OriginDatabaseName.setter
    def OriginDatabaseName(self, OriginDatabaseName):
        self._OriginDatabaseName = OriginDatabaseName

    @property
    def OriginSchemaName(self):
        return self._OriginSchemaName

    @OriginSchemaName.setter
    def OriginSchemaName(self, OriginSchemaName):
        self._OriginSchemaName = OriginSchemaName

    @property
    def DsEnvType(self):
        return self._DsEnvType

    @DsEnvType.setter
    def DsEnvType(self, DsEnvType):
        self._DsEnvType = DsEnvType


    def _deserialize(self, params):
        self._DatasourceName = params.get("DatasourceName")
        self._DatasourceId = params.get("DatasourceId")
        self._DatabaseName = params.get("DatabaseName")
        self._DatabaseId = params.get("DatabaseId")
        self._InstanceId = params.get("InstanceId")
        self._DatasourceType = params.get("DatasourceType")
        self._OriginDatabaseName = params.get("OriginDatabaseName")
        self._OriginSchemaName = params.get("OriginSchemaName")
        self._DsEnvType = params.get("DsEnvType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DatabaseMeta(AbstractModel):
    """Data Source Metadata

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project IDNote: This field may return null, indicating that no valid value can be obtained.
        :type ProjectId: str
        :param _MetastoreType: Technology Type
Note: This field may return null, indicating that no valid value can be obtained.
        :type MetastoreType: str
        :param _DatasourceName: Data Source Name
Note: This field may return null, indicating that no valid value can be obtained.
        :type DatasourceName: str
        :param _DatasourceId: Data Source IDNote: This field may return null, indicating that no valid value can be obtained.
        :type DatasourceId: int
        :param _ProjectName: Project English Name
Note: This field may return null, indicating that no valid value can be obtained.
        :type ProjectName: str
        :param _Category: Data Source Category: Binding Engine, Binding Database, Available Values: DB, ENGINE
Note: This field may return null, indicating that no valid value can be obtained.
        :type Category: str
        :param _Description: Data source description informationNote: This field may return null, indicating that no valid value can be obtained.
        :type Description: str
        :param _Instance: Instance ID of the data source engine, e.g., CDB Instance IDNote: This field may return null, indicating that no valid value can be obtained.
        :type Instance: str
        :param _Region: Data Source Engine Region
Note: This field may return null, indicating that no valid value can be obtained.
        :type Region: str
        :param _Status: Visibility of the data source, where 1 is visible and 0 is not visible. Default is 1Note: This field may return null, indicating that no valid value can be obtained.
        :type Status: int
        :param _DatabaseName: Database Name
Note: This field may return null, indicating that no valid value can be obtained.
        :type DatabaseName: str
        :param _ProjectDisplayName: Project Chinese Name
Note: This field may return null, indicating that no valid value can be obtained.
        :type ProjectDisplayName: str
        :param _OwnerAccountName: Person in Charge Name
Note: This field may return null, indicating that no valid value can be obtained.
        :type OwnerAccountName: str
        :param _DisplayName: Data Source Display Name
Note: This field may return null, indicating that no valid value can be obtained.
        :type DisplayName: str
        :param _DatabaseId: Database ID
Note: This field may return null, indicating that no valid value can be obtained.
        :type DatabaseId: str
        :param _Catalog: Data Source Type: hive/mysql/hbase, etc.
Note: This field may return null, indicating that no valid value can be obtained.
        :type Catalog: str
        :param _StorageSize: Storage Size in bytes
Note: This field may return null, indicating that no valid value can be obtained.
        :type StorageSize: int
        :param _StorageSizeWithUnit: Formatted Storage Size, with unit, e.g., 12B
Note: This field may return null, indicating that no valid value can be obtained.
        :type StorageSizeWithUnit: str
        :param _CreateTime: Creation TimeNote: This field may return null, indicating that no valid value can be obtained.
        :type CreateTime: str
        """
        self._ProjectId = None
        self._MetastoreType = None
        self._DatasourceName = None
        self._DatasourceId = None
        self._ProjectName = None
        self._Category = None
        self._Description = None
        self._Instance = None
        self._Region = None
        self._Status = None
        self._DatabaseName = None
        self._ProjectDisplayName = None
        self._OwnerAccountName = None
        self._DisplayName = None
        self._DatabaseId = None
        self._Catalog = None
        self._StorageSize = None
        self._StorageSizeWithUnit = None
        self._CreateTime = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def MetastoreType(self):
        return self._MetastoreType

    @MetastoreType.setter
    def MetastoreType(self, MetastoreType):
        self._MetastoreType = MetastoreType

    @property
    def DatasourceName(self):
        return self._DatasourceName

    @DatasourceName.setter
    def DatasourceName(self, DatasourceName):
        self._DatasourceName = DatasourceName

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def ProjectName(self):
        return self._ProjectName

    @ProjectName.setter
    def ProjectName(self, ProjectName):
        self._ProjectName = ProjectName

    @property
    def Category(self):
        return self._Category

    @Category.setter
    def Category(self, Category):
        self._Category = Category

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Instance(self):
        return self._Instance

    @Instance.setter
    def Instance(self, Instance):
        self._Instance = Instance

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def DatabaseName(self):
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def ProjectDisplayName(self):
        return self._ProjectDisplayName

    @ProjectDisplayName.setter
    def ProjectDisplayName(self, ProjectDisplayName):
        self._ProjectDisplayName = ProjectDisplayName

    @property
    def OwnerAccountName(self):
        return self._OwnerAccountName

    @OwnerAccountName.setter
    def OwnerAccountName(self, OwnerAccountName):
        self._OwnerAccountName = OwnerAccountName

    @property
    def DisplayName(self):
        return self._DisplayName

    @DisplayName.setter
    def DisplayName(self, DisplayName):
        self._DisplayName = DisplayName

    @property
    def DatabaseId(self):
        return self._DatabaseId

    @DatabaseId.setter
    def DatabaseId(self, DatabaseId):
        self._DatabaseId = DatabaseId

    @property
    def Catalog(self):
        return self._Catalog

    @Catalog.setter
    def Catalog(self, Catalog):
        self._Catalog = Catalog

    @property
    def StorageSize(self):
        return self._StorageSize

    @StorageSize.setter
    def StorageSize(self, StorageSize):
        self._StorageSize = StorageSize

    @property
    def StorageSizeWithUnit(self):
        return self._StorageSizeWithUnit

    @StorageSizeWithUnit.setter
    def StorageSizeWithUnit(self, StorageSizeWithUnit):
        self._StorageSizeWithUnit = StorageSizeWithUnit

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._MetastoreType = params.get("MetastoreType")
        self._DatasourceName = params.get("DatasourceName")
        self._DatasourceId = params.get("DatasourceId")
        self._ProjectName = params.get("ProjectName")
        self._Category = params.get("Category")
        self._Description = params.get("Description")
        self._Instance = params.get("Instance")
        self._Region = params.get("Region")
        self._Status = params.get("Status")
        self._DatabaseName = params.get("DatabaseName")
        self._ProjectDisplayName = params.get("ProjectDisplayName")
        self._OwnerAccountName = params.get("OwnerAccountName")
        self._DisplayName = params.get("DisplayName")
        self._DatabaseId = params.get("DatabaseId")
        self._Catalog = params.get("Catalog")
        self._StorageSize = params.get("StorageSize")
        self._StorageSizeWithUnit = params.get("StorageSizeWithUnit")
        self._CreateTime = params.get("CreateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DatasourceBaseInfo(AbstractModel):
    """Data Source Object

    """

    def __init__(self):
        r"""
        :param _DatabaseNames: If the data source list is bound to a database, then it is the database nameNote: This field may return null, indicating that no valid value can be obtained.
        :type DatabaseNames: list of str
        :param _Description: Data source description informationNote: This field may return null, indicating that no valid value can be obtained.
        :type Description: str
        :param _ID: Data Source ID
        :type ID: int
        :param _Instance: Instance ID of the data source engine, e.g., CDB Instance IDNote: This field may return null, indicating that no valid value can be obtained.
        :type Instance: str
        :param _Name: Data Source Name, cannot be empty under the same SpaceName
        :type Name: str
        :param _Region: Region to which the data source engine belongs
Note: This field may return null, indicating that no valid value can be obtained.
        :type Region: str
        :param _Type: Data Source Type: enumerated valuesNote: This field may return null, indicating that no valid value can be obtained.
        :type Type: str
        :param _ClusterId: Cluster ID to which the data source belongs
Note: This field may return null, indicating that no valid value can be obtained.
        :type ClusterId: str
        :param _Version: Version information of the data source
Note: This field may return null, indicating that no valid value can be obtained.
        :type Version: str
        :param _ParamsString: Attached parameter information of the data source Params JSON string
Note: This field may return null, indicating that no valid value can be obtained.
        :type ParamsString: str
        :param _Category: Distinguish whether the data source type is a custom Definition source or a system source
Note: This field may return null, indicating that no valid value can be obtained.
        :type Category: str
        """
        self._DatabaseNames = None
        self._Description = None
        self._ID = None
        self._Instance = None
        self._Name = None
        self._Region = None
        self._Type = None
        self._ClusterId = None
        self._Version = None
        self._ParamsString = None
        self._Category = None

    @property
    def DatabaseNames(self):
        return self._DatabaseNames

    @DatabaseNames.setter
    def DatabaseNames(self, DatabaseNames):
        self._DatabaseNames = DatabaseNames

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def ID(self):
        return self._ID

    @ID.setter
    def ID(self, ID):
        self._ID = ID

    @property
    def Instance(self):
        return self._Instance

    @Instance.setter
    def Instance(self, Instance):
        self._Instance = Instance

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Version(self):
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def ParamsString(self):
        return self._ParamsString

    @ParamsString.setter
    def ParamsString(self, ParamsString):
        self._ParamsString = ParamsString

    @property
    def Category(self):
        return self._Category

    @Category.setter
    def Category(self, Category):
        self._Category = Category


    def _deserialize(self, params):
        self._DatabaseNames = params.get("DatabaseNames")
        self._Description = params.get("Description")
        self._ID = params.get("ID")
        self._Instance = params.get("Instance")
        self._Name = params.get("Name")
        self._Region = params.get("Region")
        self._Type = params.get("Type")
        self._ClusterId = params.get("ClusterId")
        self._Version = params.get("Version")
        self._ParamsString = params.get("ParamsString")
        self._Category = params.get("Category")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCustomFunctionRequest(AbstractModel):
    """DeleteCustomFunction request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterIdentifier: Cluster Instance ID
        :type ClusterIdentifier: str
        :param _FunctionId: Function ID
        :type FunctionId: str
        :param _ProjectId: Project ID, required
        :type ProjectId: str
        :param _FunctionName: Function Name
        :type FunctionName: str
        :param _FunctionType: Function Type, HIVE, SPARK, DLC, CDW_POSTGRESQL
        :type FunctionType: str
        :param _DatabaseName: Database name
        :type DatabaseName: str
        :param _SchemaName: Pattern name
        :type SchemaName: str
        :param _CommandFormat: Function Command Format
        :type CommandFormat: str
        """
        self._ClusterIdentifier = None
        self._FunctionId = None
        self._ProjectId = None
        self._FunctionName = None
        self._FunctionType = None
        self._DatabaseName = None
        self._SchemaName = None
        self._CommandFormat = None

    @property
    def ClusterIdentifier(self):
        return self._ClusterIdentifier

    @ClusterIdentifier.setter
    def ClusterIdentifier(self, ClusterIdentifier):
        self._ClusterIdentifier = ClusterIdentifier

    @property
    def FunctionId(self):
        return self._FunctionId

    @FunctionId.setter
    def FunctionId(self, FunctionId):
        self._FunctionId = FunctionId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def FunctionName(self):
        return self._FunctionName

    @FunctionName.setter
    def FunctionName(self, FunctionName):
        self._FunctionName = FunctionName

    @property
    def FunctionType(self):
        return self._FunctionType

    @FunctionType.setter
    def FunctionType(self, FunctionType):
        self._FunctionType = FunctionType

    @property
    def DatabaseName(self):
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def SchemaName(self):
        return self._SchemaName

    @SchemaName.setter
    def SchemaName(self, SchemaName):
        self._SchemaName = SchemaName

    @property
    def CommandFormat(self):
        return self._CommandFormat

    @CommandFormat.setter
    def CommandFormat(self, CommandFormat):
        self._CommandFormat = CommandFormat


    def _deserialize(self, params):
        self._ClusterIdentifier = params.get("ClusterIdentifier")
        self._FunctionId = params.get("FunctionId")
        self._ProjectId = params.get("ProjectId")
        self._FunctionName = params.get("FunctionName")
        self._FunctionType = params.get("FunctionType")
        self._DatabaseName = params.get("DatabaseName")
        self._SchemaName = params.get("SchemaName")
        self._CommandFormat = params.get("CommandFormat")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCustomFunctionResponse(AbstractModel):
    """DeleteCustomFunction response structure.

    """

    def __init__(self):
        r"""
        :param _FunctionId: Function ID
Note: This field may return null, indicating that no valid value can be obtained.
        :type FunctionId: str
        :param _ErrorMessage: NoNote: This field may return null, indicating that no valid value can be obtained.
        :type ErrorMessage: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FunctionId = None
        self._ErrorMessage = None
        self._RequestId = None

    @property
    def FunctionId(self):
        return self._FunctionId

    @FunctionId.setter
    def FunctionId(self, FunctionId):
        self._FunctionId = FunctionId

    @property
    def ErrorMessage(self):
        return self._ErrorMessage

    @ErrorMessage.setter
    def ErrorMessage(self, ErrorMessage):
        self._ErrorMessage = ErrorMessage

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FunctionId = params.get("FunctionId")
        self._ErrorMessage = params.get("ErrorMessage")
        self._RequestId = params.get("RequestId")


class DeleteDataSourcesRequest(AbstractModel):
    """DeleteDataSources request structure.

    """

    def __init__(self):
        r"""
        :param _Ids: ID List
        :type Ids: list of int non-negative
        :param _ProjectId: Project ID
        :type ProjectId: str
        """
        self._Ids = None
        self._ProjectId = None

    @property
    def Ids(self):
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._Ids = params.get("Ids")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteDataSourcesResponse(AbstractModel):
    """DeleteDataSources response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Delete successful?
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: bool
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteDsFolderRequest(AbstractModel):
    """DeleteDsFolder request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _FolderId: Folder ID
        :type FolderId: str
        """
        self._ProjectId = None
        self._FolderId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def FolderId(self):
        return self._FolderId

    @FolderId.setter
    def FolderId(self, FolderId):
        self._FolderId = FolderId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._FolderId = params.get("FolderId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteDsFolderResponse(AbstractModel):
    """DeleteDsFolder response structure.

    """

    def __init__(self):
        r"""
        :param _Data: true means deletion successful, false means deletion failed
        :type Data: bool
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteFilePathRequest(AbstractModel):
    """DeleteFilePath request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _ResourceIds: Resource ID
        :type ResourceIds: list of str
        :param _UseStatus: Usage Status- true
- false
        :type UseStatus: str
        :param _FilePaths: File path
        :type FilePaths: list of str
        """
        self._ProjectId = None
        self._ResourceIds = None
        self._UseStatus = None
        self._FilePaths = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ResourceIds(self):
        return self._ResourceIds

    @ResourceIds.setter
    def ResourceIds(self, ResourceIds):
        self._ResourceIds = ResourceIds

    @property
    def UseStatus(self):
        return self._UseStatus

    @UseStatus.setter
    def UseStatus(self, UseStatus):
        self._UseStatus = UseStatus

    @property
    def FilePaths(self):
        return self._FilePaths

    @FilePaths.setter
    def FilePaths(self, FilePaths):
        self._FilePaths = FilePaths


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._ResourceIds = params.get("ResourceIds")
        self._UseStatus = params.get("UseStatus")
        self._FilePaths = params.get("FilePaths")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteFilePathResponse(AbstractModel):
    """DeleteFilePath response structure.

    """

    def __init__(self):
        r"""
        :param _UserFileList: File ListNote: This field may return null, indicating that no valid value can be obtained.
        :type UserFileList: list of UserFileInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._UserFileList = None
        self._RequestId = None

    @property
    def UserFileList(self):
        return self._UserFileList

    @UserFileList.setter
    def UserFileList(self, UserFileList):
        self._UserFileList = UserFileList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("UserFileList") is not None:
            self._UserFileList = []
            for item in params.get("UserFileList"):
                obj = UserFileInfo()
                obj._deserialize(item)
                self._UserFileList.append(obj)
        self._RequestId = params.get("RequestId")


class DeleteFileRequest(AbstractModel):
    """DeleteFile request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _ResourceId: Resource ID
        :type ResourceId: str
        """
        self._ProjectId = None
        self._ResourceId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ResourceId(self):
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._ResourceId = params.get("ResourceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteFileResponse(AbstractModel):
    """DeleteFile response structure.

    """

    def __init__(self):
        r"""
        :param _Result: Delete Result
Note: This field may return null, indicating that no valid value can be obtained.
        :type Result: bool
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class DeleteIntegrationNodeRequest(AbstractModel):
    """DeleteIntegrationNode request structure.

    """

    def __init__(self):
        r"""
        :param _Id: Node ID
        :type Id: str
        :param _ProjectId: Project ID
        :type ProjectId: str
        """
        self._Id = None
        self._ProjectId = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteIntegrationNodeResponse(AbstractModel):
    """DeleteIntegrationNode response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Indication of whether the deletion was successful
        :type Data: bool
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteIntegrationTaskRequest(AbstractModel):
    """DeleteIntegrationTask request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID
        :type TaskId: str
        :param _ProjectId: Project ID
        :type ProjectId: str
        """
        self._TaskId = None
        self._ProjectId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteIntegrationTaskResponse(AbstractModel):
    """DeleteIntegrationTask response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Task Deletion Success or Failure Indicator
        :type Data: bool
        :param _DeleteFlag: Task Deletion Success or Failure Indicator
0 indicates deletion was successful
1 indicates failure, see DeleteErrInfo for the reason
100 indicates running or suspend task can't be deleted, the reason will also be written in DeleteErrInfo
Note: This field may return null, indicating that no valid value can be obtained.
        :type DeleteFlag: int
        :param _DeleteErrInfo: Reason for Deletion Failure
Note: This field may return null, indicating that no valid value can be obtained.
        :type DeleteErrInfo: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._DeleteFlag = None
        self._DeleteErrInfo = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def DeleteFlag(self):
        return self._DeleteFlag

    @DeleteFlag.setter
    def DeleteFlag(self, DeleteFlag):
        self._DeleteFlag = DeleteFlag

    @property
    def DeleteErrInfo(self):
        return self._DeleteErrInfo

    @DeleteErrInfo.setter
    def DeleteErrInfo(self, DeleteErrInfo):
        self._DeleteErrInfo = DeleteErrInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._DeleteFlag = params.get("DeleteFlag")
        self._DeleteErrInfo = params.get("DeleteErrInfo")
        self._RequestId = params.get("RequestId")


class DeleteOfflineTaskRequest(AbstractModel):
    """DeleteOfflineTask request structure.

    """

    def __init__(self):
        r"""
        :param _OperatorName: Operator's name
        :type OperatorName: str
        :param _ProjectId: Project/workspace ID
        :type ProjectId: str
        :param _TaskId: Task ID
        :type TaskId: str
        :param _VirtualFlag: Virtual task marker (defaults to false, consistent with previous scheduling interfaces)
        :type VirtualFlag: bool
        """
        self._OperatorName = None
        self._ProjectId = None
        self._TaskId = None
        self._VirtualFlag = None

    @property
    def OperatorName(self):
        return self._OperatorName

    @OperatorName.setter
    def OperatorName(self, OperatorName):
        self._OperatorName = OperatorName

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def VirtualFlag(self):
        return self._VirtualFlag

    @VirtualFlag.setter
    def VirtualFlag(self, VirtualFlag):
        self._VirtualFlag = VirtualFlag


    def _deserialize(self, params):
        self._OperatorName = params.get("OperatorName")
        self._ProjectId = params.get("ProjectId")
        self._TaskId = params.get("TaskId")
        self._VirtualFlag = params.get("VirtualFlag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteOfflineTaskResponse(AbstractModel):
    """DeleteOfflineTask response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Result
        :type Data: bool
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteProjectParamDsRequest(AbstractModel):
    """DeleteProjectParamDs request structure.

    """

    def __init__(self):
        r"""
        :param _ParamKey: Parameter Name
        :type ParamKey: str
        :param _ProjectId: Project ID
        :type ProjectId: str
        """
        self._ParamKey = None
        self._ProjectId = None

    @property
    def ParamKey(self):
        return self._ParamKey

    @ParamKey.setter
    def ParamKey(self, ParamKey):
        self._ParamKey = ParamKey

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._ParamKey = params.get("ParamKey")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteProjectParamDsResponse(AbstractModel):
    """DeleteProjectParamDs response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Result true Deleted Successfully
false Deletion Failed
        :type Data: bool
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteProjectUsersRequest(AbstractModel):
    """DeleteProjectUsers request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _UserIds: User ID list
        :type UserIds: list of str
        """
        self._ProjectId = None
        self._UserIds = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def UserIds(self):
        return self._UserIds

    @UserIds.setter
    def UserIds(self, UserIds):
        self._UserIds = UserIds


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._UserIds = params.get("UserIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteProjectUsersResponse(AbstractModel):
    """DeleteProjectUsers response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteResourceFileRequest(AbstractModel):
    """DeleteResourceFile request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _ResourceId: Resource ID
        :type ResourceId: str
        """
        self._ProjectId = None
        self._ResourceId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ResourceId(self):
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._ResourceId = params.get("ResourceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteResourceFileResponse(AbstractModel):
    """DeleteResourceFile response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Resource Deletion Result
        :type Data: bool
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteResourceFilesRequest(AbstractModel):
    """DeleteResourceFiles request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _UseStatus: Usage Status
        :type UseStatus: bool
        :param _ResourceIds: Resource ID List
        :type ResourceIds: list of str
        :param _FilePaths: Resource Path List
        :type FilePaths: list of str
        """
        self._ProjectId = None
        self._UseStatus = None
        self._ResourceIds = None
        self._FilePaths = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def UseStatus(self):
        return self._UseStatus

    @UseStatus.setter
    def UseStatus(self, UseStatus):
        self._UseStatus = UseStatus

    @property
    def ResourceIds(self):
        return self._ResourceIds

    @ResourceIds.setter
    def ResourceIds(self, ResourceIds):
        self._ResourceIds = ResourceIds

    @property
    def FilePaths(self):
        return self._FilePaths

    @FilePaths.setter
    def FilePaths(self, FilePaths):
        self._FilePaths = FilePaths


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._UseStatus = params.get("UseStatus")
        self._ResourceIds = params.get("ResourceIds")
        self._FilePaths = params.get("FilePaths")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteResourceFilesResponse(AbstractModel):
    """DeleteResourceFiles response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Resource Batch Deletion Result
        :type Data: bool
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteResourceRequest(AbstractModel):
    """DeleteResource request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _ResourceId: Resource ID
        :type ResourceId: str
        """
        self._ProjectId = None
        self._ResourceId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ResourceId(self):
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._ResourceId = params.get("ResourceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteResourceResponse(AbstractModel):
    """DeleteResource response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Success Status
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: bool
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteRuleRequest(AbstractModel):
    """DeleteRule request structure.

    """

    def __init__(self):
        r"""
        :param _RuleId: Quality Rule ID
        :type RuleId: int
        :param _ProjectId: Project ID
        :type ProjectId: str
        """
        self._RuleId = None
        self._ProjectId = None

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRuleResponse(AbstractModel):
    """DeleteRule response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Whether Deletion is Successful
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: bool
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteRuleTemplateRequest(AbstractModel):
    """DeleteRuleTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _Ids: Template ID List
        :type Ids: list of int non-negative
        """
        self._ProjectId = None
        self._Ids = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Ids(self):
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._Ids = params.get("Ids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRuleTemplateResponse(AbstractModel):
    """DeleteRuleTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Deleted successfully
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: bool
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteTaskAlarmRegularRequest(AbstractModel):
    """DeleteTaskAlarmRegular request structure.

    """

    def __init__(self):
        r"""
        :param _Id: Primary key ID
        :type Id: str
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _TaskId: Task ID
        :type TaskId: str
        :param _TaskType: Task Type (201 represents Real-time task, 202 represents Offline task)
        :type TaskType: int
        """
        self._Id = None
        self._ProjectId = None
        self._TaskId = None
        self._TaskType = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._ProjectId = params.get("ProjectId")
        self._TaskId = params.get("TaskId")
        self._TaskType = params.get("TaskType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteTaskAlarmRegularResponse(AbstractModel):
    """DeleteTaskAlarmRegular response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Delete Result (true for success, false for failure)
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: bool
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteTaskDsRequest(AbstractModel):
    """DeleteTaskDs request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _DeleteScript: Delete script?
true: delete
false: do not delete
Default false if not passed
        :type DeleteScript: bool
        :param _OperateInform: Task operation: Notify downstream task owners?
true: notify
false: do not notify
Default false if not passed
        :type OperateInform: bool
        :param _TaskId: Task IDChoose either VirtualTaskId or
        :type TaskId: str
        :param _VirtualTaskId: Virtual task id
Either TaskId or this field is optional

        :type VirtualTaskId: str
        :param _VirtualFlag: Virtual task flag
true: It is a virtual task
false: It is not a virtual task
Default false if not passed
        :type VirtualFlag: bool
        :param _DeleteMode: Task deletion method
true: Do not force fail downstream task instances
false: Force fail downstream task instances
If not specified, the default is false

        :type DeleteMode: bool
        """
        self._ProjectId = None
        self._DeleteScript = None
        self._OperateInform = None
        self._TaskId = None
        self._VirtualTaskId = None
        self._VirtualFlag = None
        self._DeleteMode = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def DeleteScript(self):
        return self._DeleteScript

    @DeleteScript.setter
    def DeleteScript(self, DeleteScript):
        self._DeleteScript = DeleteScript

    @property
    def OperateInform(self):
        return self._OperateInform

    @OperateInform.setter
    def OperateInform(self, OperateInform):
        self._OperateInform = OperateInform

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def VirtualTaskId(self):
        return self._VirtualTaskId

    @VirtualTaskId.setter
    def VirtualTaskId(self, VirtualTaskId):
        self._VirtualTaskId = VirtualTaskId

    @property
    def VirtualFlag(self):
        return self._VirtualFlag

    @VirtualFlag.setter
    def VirtualFlag(self, VirtualFlag):
        self._VirtualFlag = VirtualFlag

    @property
    def DeleteMode(self):
        return self._DeleteMode

    @DeleteMode.setter
    def DeleteMode(self, DeleteMode):
        self._DeleteMode = DeleteMode


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._DeleteScript = params.get("DeleteScript")
        self._OperateInform = params.get("OperateInform")
        self._TaskId = params.get("TaskId")
        self._VirtualTaskId = params.get("VirtualTaskId")
        self._VirtualFlag = params.get("VirtualFlag")
        self._DeleteMode = params.get("DeleteMode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteTaskDsResponse(AbstractModel):
    """DeleteTaskDs response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Delete successful?
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: bool
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteWorkflowByIdRequest(AbstractModel):
    """DeleteWorkflowById request structure.

    """

    def __init__(self):
        r"""
        :param _WorkflowId: Workflow ID
        :type WorkflowId: str
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _DeleteMode: Handling method for downstream tasks after deletion, true: all downstream tasks run normally false: all downstream tasks fail
        :type DeleteMode: bool
        :param _EnableNotify: Notify downstream task owners after task deletion, true: notify false: do not notify
        :type EnableNotify: bool
        """
        self._WorkflowId = None
        self._ProjectId = None
        self._DeleteMode = None
        self._EnableNotify = None

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def DeleteMode(self):
        return self._DeleteMode

    @DeleteMode.setter
    def DeleteMode(self, DeleteMode):
        self._DeleteMode = DeleteMode

    @property
    def EnableNotify(self):
        return self._EnableNotify

    @EnableNotify.setter
    def EnableNotify(self, EnableNotify):
        self._EnableNotify = EnableNotify


    def _deserialize(self, params):
        self._WorkflowId = params.get("WorkflowId")
        self._ProjectId = params.get("ProjectId")
        self._DeleteMode = params.get("DeleteMode")
        self._EnableNotify = params.get("EnableNotify")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteWorkflowByIdResponse(AbstractModel):
    """DeleteWorkflowById response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Delete Result
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: :class:`tencentcloud.wedata.v20210820.models.OperationOpsDto`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = OperationOpsDto()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DependencyConfig(AbstractModel):
    """Dependency Configuration

    """

    def __init__(self):
        r"""
        :param _DependConfType: Only five types of periodic execution dependency configurations: HOUR, DAY, WEEK, MONTH, YEAR, CRONTAB, MINUTE
        :type DependConfType: str
        :param _SubordinateCyclicType: Dependency Configuration Subordinate Period Type, CURRENT_HOUR, PREVIOUS_HOUR, CURRENT_DAY, PREVIOUS_DAY, PREVIOUS_WEEK, PREVIOUS_FRIDAY, PREVIOUS_WEEKEND, CURRENT_MONTH, PREVIOUS_MONTH, PREVIOUS_END_OF_MONTH
     * PREVIOUS_BEGIN_OF_MONTH,ALL_MONTH_OF_YEAR,ALL_DAY_OF_YEAR,CURRENT_YEAR,CURRENT,CURRENT_MINUTE,PREVIOUS_MINUTE_CYCLE,PREVIOUS_HOUR_CYCLE
        :type SubordinateCyclicType: str
        :param _DependencyStrategy: WAITING, waiting (default policy) EXECUTING: executing
        :type DependencyStrategy: str
        :param _ParentTask: Parent Task Information
Note: This field may return null, indicating that no valid value can be obtained.
        :type ParentTask: :class:`tencentcloud.wedata.v20210820.models.TaskInnerInfo`
        :param _SonTask: Subtask Information
Note: This field may return null, indicating that no valid value can be obtained.
        :type SonTask: :class:`tencentcloud.wedata.v20210820.models.TaskInnerInfo`
        """
        self._DependConfType = None
        self._SubordinateCyclicType = None
        self._DependencyStrategy = None
        self._ParentTask = None
        self._SonTask = None

    @property
    def DependConfType(self):
        return self._DependConfType

    @DependConfType.setter
    def DependConfType(self, DependConfType):
        self._DependConfType = DependConfType

    @property
    def SubordinateCyclicType(self):
        return self._SubordinateCyclicType

    @SubordinateCyclicType.setter
    def SubordinateCyclicType(self, SubordinateCyclicType):
        self._SubordinateCyclicType = SubordinateCyclicType

    @property
    def DependencyStrategy(self):
        return self._DependencyStrategy

    @DependencyStrategy.setter
    def DependencyStrategy(self, DependencyStrategy):
        self._DependencyStrategy = DependencyStrategy

    @property
    def ParentTask(self):
        return self._ParentTask

    @ParentTask.setter
    def ParentTask(self, ParentTask):
        self._ParentTask = ParentTask

    @property
    def SonTask(self):
        return self._SonTask

    @SonTask.setter
    def SonTask(self, SonTask):
        self._SonTask = SonTask


    def _deserialize(self, params):
        self._DependConfType = params.get("DependConfType")
        self._SubordinateCyclicType = params.get("SubordinateCyclicType")
        self._DependencyStrategy = params.get("DependencyStrategy")
        if params.get("ParentTask") is not None:
            self._ParentTask = TaskInnerInfo()
            self._ParentTask._deserialize(params.get("ParentTask"))
        if params.get("SonTask") is not None:
            self._SonTask = TaskInnerInfo()
            self._SonTask._deserialize(params.get("SonTask"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAlarmEventsRequest(AbstractModel):
    """DescribeAlarmEvents request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _PageNumber: Current Page
        :type PageNumber: int
        :param _PageSize: Number of records per page
        :type PageSize: int
        :param _Filters: Filter criteria (key can be: AlarmLevel, AlarmIndicator, KeyWord)
        :type Filters: list of Filter
        :param _OrderFields: Sort Fields (AlarmTime)
        :type OrderFields: list of OrderField
        :param _TaskType: Type (201 for real-time, 202 for offline)
        :type TaskType: int
        :param _StartTime: Start Time
        :type StartTime: str
        :param _EndTime: End time
        :type EndTime: str
        :param _MonitorType: Monitored Object Type (1: All Tasks, 2: Assigned Task, 3: Designated Responsible Person, 4: Specified Resource Group)
        :type MonitorType: int
        """
        self._ProjectId = None
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None
        self._OrderFields = None
        self._TaskType = None
        self._StartTime = None
        self._EndTime = None
        self._MonitorType = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def MonitorType(self):
        return self._MonitorType

    @MonitorType.setter
    def MonitorType(self, MonitorType):
        self._MonitorType = MonitorType


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        self._TaskType = params.get("TaskType")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._MonitorType = params.get("MonitorType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAlarmEventsResponse(AbstractModel):
    """DescribeAlarmEvents response structure.

    """

    def __init__(self):
        r"""
        :param _AlarmEventInfoList: Alert event listNote: This field may return null, indicating that no valid value can be obtained.
        :type AlarmEventInfoList: list of AlarmEventInfo
        :param _TotalCount: Number of records
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._AlarmEventInfoList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def AlarmEventInfoList(self):
        return self._AlarmEventInfoList

    @AlarmEventInfoList.setter
    def AlarmEventInfoList(self, AlarmEventInfoList):
        self._AlarmEventInfoList = AlarmEventInfoList

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("AlarmEventInfoList") is not None:
            self._AlarmEventInfoList = []
            for item in params.get("AlarmEventInfoList"):
                obj = AlarmEventInfo()
                obj._deserialize(item)
                self._AlarmEventInfoList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAlarmReceiverRequest(AbstractModel):
    """DescribeAlarmReceiver request structure.

    """

    def __init__(self):
        r"""
        :param _AlarmId: Alert ID
        :type AlarmId: str
        :param _PageNumber: Current Page
        :type PageNumber: int
        :param _PageSize: Number of records per page
        :type PageSize: int
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _TaskType: Type
        :type TaskType: int
        :param _AlarmRecipient: Alarm Recipient ID (comma-separated)
        :type AlarmRecipient: str
        :param _AlarmRecipientName: Name of alarm recipient (comma-separated)
        :type AlarmRecipientName: str
        :param _AlarmTime: Alarm Time
        :type AlarmTime: str
        :param _MessageId: Message ID
        :type MessageId: str
        :param _RecordId: Alert Record ID
        :type RecordId: int
        :param _MonitorType: Monitored Object Type (1: All Tasks, 2: Assigned Task, 3: Designated Responsible Person, 4: Specified Resource Group)
        :type MonitorType: int
        """
        self._AlarmId = None
        self._PageNumber = None
        self._PageSize = None
        self._ProjectId = None
        self._TaskType = None
        self._AlarmRecipient = None
        self._AlarmRecipientName = None
        self._AlarmTime = None
        self._MessageId = None
        self._RecordId = None
        self._MonitorType = None

    @property
    def AlarmId(self):
        return self._AlarmId

    @AlarmId.setter
    def AlarmId(self, AlarmId):
        self._AlarmId = AlarmId

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def AlarmRecipient(self):
        return self._AlarmRecipient

    @AlarmRecipient.setter
    def AlarmRecipient(self, AlarmRecipient):
        self._AlarmRecipient = AlarmRecipient

    @property
    def AlarmRecipientName(self):
        return self._AlarmRecipientName

    @AlarmRecipientName.setter
    def AlarmRecipientName(self, AlarmRecipientName):
        self._AlarmRecipientName = AlarmRecipientName

    @property
    def AlarmTime(self):
        return self._AlarmTime

    @AlarmTime.setter
    def AlarmTime(self, AlarmTime):
        self._AlarmTime = AlarmTime

    @property
    def MessageId(self):
        return self._MessageId

    @MessageId.setter
    def MessageId(self, MessageId):
        self._MessageId = MessageId

    @property
    def RecordId(self):
        return self._RecordId

    @RecordId.setter
    def RecordId(self, RecordId):
        self._RecordId = RecordId

    @property
    def MonitorType(self):
        return self._MonitorType

    @MonitorType.setter
    def MonitorType(self, MonitorType):
        self._MonitorType = MonitorType


    def _deserialize(self, params):
        self._AlarmId = params.get("AlarmId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        self._ProjectId = params.get("ProjectId")
        self._TaskType = params.get("TaskType")
        self._AlarmRecipient = params.get("AlarmRecipient")
        self._AlarmRecipientName = params.get("AlarmRecipientName")
        self._AlarmTime = params.get("AlarmTime")
        self._MessageId = params.get("MessageId")
        self._RecordId = params.get("RecordId")
        self._MonitorType = params.get("MonitorType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAlarmReceiverResponse(AbstractModel):
    """DescribeAlarmReceiver response structure.

    """

    def __init__(self):
        r"""
        :param _AlarmReceiverInfoList: Alert Recipient List
Note: This field may return null, indicating that no valid value can be obtained.
        :type AlarmReceiverInfoList: list of AlarmReceiverInfo
        :param _TotalCount: Number of records
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._AlarmReceiverInfoList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def AlarmReceiverInfoList(self):
        return self._AlarmReceiverInfoList

    @AlarmReceiverInfoList.setter
    def AlarmReceiverInfoList(self, AlarmReceiverInfoList):
        self._AlarmReceiverInfoList = AlarmReceiverInfoList

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("AlarmReceiverInfoList") is not None:
            self._AlarmReceiverInfoList = []
            for item in params.get("AlarmReceiverInfoList"):
                obj = AlarmReceiverInfo()
                obj._deserialize(item)
                self._AlarmReceiverInfoList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAllByFolderNewRequest(AbstractModel):
    """DescribeAllByFolderNew request structure.

    """

    def __init__(self):
        r"""
        :param _Folder: Folder Attributes
        :type Folder: :class:`tencentcloud.wedata.v20210820.models.FolderOpsDto`
        :param _Workflows: Workflow List
        :type Workflows: list of WorkflowCanvasOpsDto
        :param _TargetFolderId: Target File ID
        :type TargetFolderId: str
        :param _KeyWords: Keyword
        :type KeyWords: str
        :param _ParentsFolderId: Parent File ID
        :type ParentsFolderId: str
        :param _IsAddWorkflow: Pull Folder List
        :type IsAddWorkflow: str
        :param _TaskStates: Task Status
        :type TaskStates: list of str
        :param _FindType: Search type
        :type FindType: str
        :param _OptType: Access type
        :type OptType: str
        :param _OperatorName: Operator Name
        :type OperatorName: str
        :param _OperatorId: Operator ID
        :type OperatorId: str
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _ProjectIdent: Project Identifier
        :type ProjectIdent: str
        :param _ProjectName: Project name
        :type ProjectName: str
        :param _PageIndex: Index Page Number
        :type PageIndex: int
        :param _PageSize: Page size
        :type PageSize: int
        :param _Count: Total Data
        :type Count: int
        :param _RequestBaseInfo: Basic Request Information
        :type RequestBaseInfo: :class:`tencentcloud.wedata.v20210820.models.ProjectBaseInfoOpsRequest`
        :param _IsCount: Whether to Calculate Total
        :type IsCount: bool
        """
        self._Folder = None
        self._Workflows = None
        self._TargetFolderId = None
        self._KeyWords = None
        self._ParentsFolderId = None
        self._IsAddWorkflow = None
        self._TaskStates = None
        self._FindType = None
        self._OptType = None
        self._OperatorName = None
        self._OperatorId = None
        self._ProjectId = None
        self._ProjectIdent = None
        self._ProjectName = None
        self._PageIndex = None
        self._PageSize = None
        self._Count = None
        self._RequestBaseInfo = None
        self._IsCount = None

    @property
    def Folder(self):
        return self._Folder

    @Folder.setter
    def Folder(self, Folder):
        self._Folder = Folder

    @property
    def Workflows(self):
        return self._Workflows

    @Workflows.setter
    def Workflows(self, Workflows):
        self._Workflows = Workflows

    @property
    def TargetFolderId(self):
        return self._TargetFolderId

    @TargetFolderId.setter
    def TargetFolderId(self, TargetFolderId):
        self._TargetFolderId = TargetFolderId

    @property
    def KeyWords(self):
        return self._KeyWords

    @KeyWords.setter
    def KeyWords(self, KeyWords):
        self._KeyWords = KeyWords

    @property
    def ParentsFolderId(self):
        return self._ParentsFolderId

    @ParentsFolderId.setter
    def ParentsFolderId(self, ParentsFolderId):
        self._ParentsFolderId = ParentsFolderId

    @property
    def IsAddWorkflow(self):
        return self._IsAddWorkflow

    @IsAddWorkflow.setter
    def IsAddWorkflow(self, IsAddWorkflow):
        self._IsAddWorkflow = IsAddWorkflow

    @property
    def TaskStates(self):
        return self._TaskStates

    @TaskStates.setter
    def TaskStates(self, TaskStates):
        self._TaskStates = TaskStates

    @property
    def FindType(self):
        return self._FindType

    @FindType.setter
    def FindType(self, FindType):
        self._FindType = FindType

    @property
    def OptType(self):
        return self._OptType

    @OptType.setter
    def OptType(self, OptType):
        self._OptType = OptType

    @property
    def OperatorName(self):
        return self._OperatorName

    @OperatorName.setter
    def OperatorName(self, OperatorName):
        self._OperatorName = OperatorName

    @property
    def OperatorId(self):
        return self._OperatorId

    @OperatorId.setter
    def OperatorId(self, OperatorId):
        self._OperatorId = OperatorId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ProjectIdent(self):
        return self._ProjectIdent

    @ProjectIdent.setter
    def ProjectIdent(self, ProjectIdent):
        self._ProjectIdent = ProjectIdent

    @property
    def ProjectName(self):
        return self._ProjectName

    @ProjectName.setter
    def ProjectName(self, ProjectName):
        self._ProjectName = ProjectName

    @property
    def PageIndex(self):
        return self._PageIndex

    @PageIndex.setter
    def PageIndex(self, PageIndex):
        self._PageIndex = PageIndex

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Count(self):
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def RequestBaseInfo(self):
        return self._RequestBaseInfo

    @RequestBaseInfo.setter
    def RequestBaseInfo(self, RequestBaseInfo):
        self._RequestBaseInfo = RequestBaseInfo

    @property
    def IsCount(self):
        return self._IsCount

    @IsCount.setter
    def IsCount(self, IsCount):
        self._IsCount = IsCount


    def _deserialize(self, params):
        if params.get("Folder") is not None:
            self._Folder = FolderOpsDto()
            self._Folder._deserialize(params.get("Folder"))
        if params.get("Workflows") is not None:
            self._Workflows = []
            for item in params.get("Workflows"):
                obj = WorkflowCanvasOpsDto()
                obj._deserialize(item)
                self._Workflows.append(obj)
        self._TargetFolderId = params.get("TargetFolderId")
        self._KeyWords = params.get("KeyWords")
        self._ParentsFolderId = params.get("ParentsFolderId")
        self._IsAddWorkflow = params.get("IsAddWorkflow")
        self._TaskStates = params.get("TaskStates")
        self._FindType = params.get("FindType")
        self._OptType = params.get("OptType")
        self._OperatorName = params.get("OperatorName")
        self._OperatorId = params.get("OperatorId")
        self._ProjectId = params.get("ProjectId")
        self._ProjectIdent = params.get("ProjectIdent")
        self._ProjectName = params.get("ProjectName")
        self._PageIndex = params.get("PageIndex")
        self._PageSize = params.get("PageSize")
        self._Count = params.get("Count")
        if params.get("RequestBaseInfo") is not None:
            self._RequestBaseInfo = ProjectBaseInfoOpsRequest()
            self._RequestBaseInfo._deserialize(params.get("RequestBaseInfo"))
        self._IsCount = params.get("IsCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAllByFolderNewResponse(AbstractModel):
    """DescribeAllByFolderNew response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Result Set
        :type Data: :class:`tencentcloud.wedata.v20210820.models.CollectionFolderOpsDto`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = CollectionFolderOpsDto()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeApply(AbstractModel):
    """Application List

    """

    def __init__(self):
        r"""
        :param _Rows: Application List Details
        :type Rows: list of Apply
        :param _TotalPageNumber: Total Pagination Pages
        :type TotalPageNumber: int
        :param _TotalCount: Total Count
        :type TotalCount: int
        :param _PageNumber: Page number
        :type PageNumber: int
        :param _PageSize: Page size
        :type PageSize: int
        """
        self._Rows = None
        self._TotalPageNumber = None
        self._TotalCount = None
        self._PageNumber = None
        self._PageSize = None

    @property
    def Rows(self):
        return self._Rows

    @Rows.setter
    def Rows(self, Rows):
        self._Rows = Rows

    @property
    def TotalPageNumber(self):
        return self._TotalPageNumber

    @TotalPageNumber.setter
    def TotalPageNumber(self, TotalPageNumber):
        self._TotalPageNumber = TotalPageNumber

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        if params.get("Rows") is not None:
            self._Rows = []
            for item in params.get("Rows"):
                obj = Apply()
                obj._deserialize(item)
                self._Rows.append(obj)
        self._TotalPageNumber = params.get("TotalPageNumber")
        self._TotalCount = params.get("TotalCount")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeApproveListRequest(AbstractModel):
    """DescribeApproveList request structure.

    """

    def __init__(self):
        r"""
        :param _ApproveClassification: Approval Category Key
        :type ApproveClassification: str
        :param _PageSize: Page size
        :type PageSize: int
        :param _PageNumber: Pagination Number
        :type PageNumber: int
        :param _Filters: Custom Definition condition query
        :type Filters: list of FilterOptional
        :param _OrderFields: Sort Fields
        :type OrderFields: list of OrderFieldOptional
        """
        self._ApproveClassification = None
        self._PageSize = None
        self._PageNumber = None
        self._Filters = None
        self._OrderFields = None

    @property
    def ApproveClassification(self):
        return self._ApproveClassification

    @ApproveClassification.setter
    def ApproveClassification(self, ApproveClassification):
        self._ApproveClassification = ApproveClassification

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields


    def _deserialize(self, params):
        self._ApproveClassification = params.get("ApproveClassification")
        self._PageSize = params.get("PageSize")
        self._PageNumber = params.get("PageNumber")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = FilterOptional()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderFieldOptional()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeApproveListResponse(AbstractModel):
    """DescribeApproveList response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Pending Approval List Details
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: :class:`tencentcloud.wedata.v20210820.models.DescribeApply`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeApply()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeApproveTypeListRequest(AbstractModel):
    """DescribeApproveTypeList request structure.

    """

    def __init__(self):
        r"""
        :param _Classification: Type key
        :type Classification: str
        """
        self._Classification = None

    @property
    def Classification(self):
        return self._Classification

    @Classification.setter
    def Classification(self, Classification):
        self._Classification = Classification


    def _deserialize(self, params):
        self._Classification = params.get("Classification")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeApproveTypeListResponse(AbstractModel):
    """DescribeApproveTypeList response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Get Approval Category List
        :type Data: list of ApproveType
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = ApproveType()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBatchOperateTaskDTO(AbstractModel):
    """Batch Operation Task List

    """

    def __init__(self):
        r"""
        :param _TaskId: Task IDNote: This field may return null, indicating that no valid value can be obtained.
        :type TaskId: str
        :param _TaskName: Task NameNote: This field may return null, indicating that no valid value can be obtained.
        :type TaskName: str
        :param _WorkflowId: Workflow Id
Note: This field may return null, indicating that no valid value can be obtained.
        :type WorkflowId: str
        :param _WorkflowName: Workflow name
Note: This field may return null, indicating that no valid value can be obtained.
        :type WorkflowName: str
        :param _Status: StatusNote: This field may return null, indicating that no valid value can be obtained.
        :type Status: str
        :param _TaskTypeId: Task IDNote: This field may return null, indicating that no valid value can be obtained.
        :type TaskTypeId: int
        :param _TaskTypeDesc: Task TypeNote: This field may return null, indicating that no valid value can be obtained.
        :type TaskTypeDesc: str
        :param _FolderName: Folder name
Note: This field may return null, indicating that no valid value can be obtained.
        :type FolderName: str
        :param _FolderId: Folder IDNote: This field may return null, indicating that no valid value can be obtained.
        :type FolderId: str
        :param _InCharge: Owner
Note: This field may return null, indicating that no valid value can be obtained.
        :type InCharge: str
        :param _Submit: Submitted?
Note: This field may return null, indicating that no valid value can be obtained.
        :type Submit: int
        :param _DataEngine: Engine:
presto\SparkJob\SparkSql
Note: This field may return null, indicating that no valid value can be obtained.
        :type DataEngine: str
        :param _UpdateTime: Update timeNote: This field may return null, indicating that no valid value can be obtained.
        :type UpdateTime: str
        :param _CreateTime: Creation time
Note: This field may return null, indicating that no valid value can be obtained.
        :type CreateTime: str
        :param _CycleUnit: Cycle type
Note: This field may return null, indicating that no valid value can be obtained.
        :type CycleUnit: str
        :param _ScheduleDesc: Scheduling plan
Note: This field may return null, indicating that no valid value can be obtained.
        :type ScheduleDesc: str
        :param _DatasourceId: Data source ID
Note: This field may return null, indicating that no valid value can be obtained.
        :type DatasourceId: str
        :param _DatasourceType: Data source typeNote: This field may return null, indicating that no valid value can be obtained.
        :type DatasourceType: str
        """
        self._TaskId = None
        self._TaskName = None
        self._WorkflowId = None
        self._WorkflowName = None
        self._Status = None
        self._TaskTypeId = None
        self._TaskTypeDesc = None
        self._FolderName = None
        self._FolderId = None
        self._InCharge = None
        self._Submit = None
        self._DataEngine = None
        self._UpdateTime = None
        self._CreateTime = None
        self._CycleUnit = None
        self._ScheduleDesc = None
        self._DatasourceId = None
        self._DatasourceType = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TaskName(self):
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId

    @property
    def WorkflowName(self):
        return self._WorkflowName

    @WorkflowName.setter
    def WorkflowName(self, WorkflowName):
        self._WorkflowName = WorkflowName

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def TaskTypeId(self):
        return self._TaskTypeId

    @TaskTypeId.setter
    def TaskTypeId(self, TaskTypeId):
        self._TaskTypeId = TaskTypeId

    @property
    def TaskTypeDesc(self):
        return self._TaskTypeDesc

    @TaskTypeDesc.setter
    def TaskTypeDesc(self, TaskTypeDesc):
        self._TaskTypeDesc = TaskTypeDesc

    @property
    def FolderName(self):
        return self._FolderName

    @FolderName.setter
    def FolderName(self, FolderName):
        self._FolderName = FolderName

    @property
    def FolderId(self):
        return self._FolderId

    @FolderId.setter
    def FolderId(self, FolderId):
        self._FolderId = FolderId

    @property
    def InCharge(self):
        return self._InCharge

    @InCharge.setter
    def InCharge(self, InCharge):
        self._InCharge = InCharge

    @property
    def Submit(self):
        return self._Submit

    @Submit.setter
    def Submit(self, Submit):
        self._Submit = Submit

    @property
    def DataEngine(self):
        return self._DataEngine

    @DataEngine.setter
    def DataEngine(self, DataEngine):
        self._DataEngine = DataEngine

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def CycleUnit(self):
        return self._CycleUnit

    @CycleUnit.setter
    def CycleUnit(self, CycleUnit):
        self._CycleUnit = CycleUnit

    @property
    def ScheduleDesc(self):
        return self._ScheduleDesc

    @ScheduleDesc.setter
    def ScheduleDesc(self, ScheduleDesc):
        self._ScheduleDesc = ScheduleDesc

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def DatasourceType(self):
        return self._DatasourceType

    @DatasourceType.setter
    def DatasourceType(self, DatasourceType):
        self._DatasourceType = DatasourceType


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._TaskName = params.get("TaskName")
        self._WorkflowId = params.get("WorkflowId")
        self._WorkflowName = params.get("WorkflowName")
        self._Status = params.get("Status")
        self._TaskTypeId = params.get("TaskTypeId")
        self._TaskTypeDesc = params.get("TaskTypeDesc")
        self._FolderName = params.get("FolderName")
        self._FolderId = params.get("FolderId")
        self._InCharge = params.get("InCharge")
        self._Submit = params.get("Submit")
        self._DataEngine = params.get("DataEngine")
        self._UpdateTime = params.get("UpdateTime")
        self._CreateTime = params.get("CreateTime")
        self._CycleUnit = params.get("CycleUnit")
        self._ScheduleDesc = params.get("ScheduleDesc")
        self._DatasourceId = params.get("DatasourceId")
        self._DatasourceType = params.get("DatasourceType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBatchOperateTaskPage(AbstractModel):
    """Batch Operation Task List Pagination

    """

    def __init__(self):
        r"""
        :param _PageCount: Total Number of Pages
Note: This field may return null, indicating that no valid value can be obtained.
        :type PageCount: int
        :param _Items: ContentNote: This field may return null, indicating that no valid value can be obtained.
        :type Items: list of DescribeBatchOperateTaskDTO
        :param _TotalCount: Total count
Note: This field may return null, indicating that no valid value can be obtained.
        :type TotalCount: int
        """
        self._PageCount = None
        self._Items = None
        self._TotalCount = None

    @property
    def PageCount(self):
        return self._PageCount

    @PageCount.setter
    def PageCount(self, PageCount):
        self._PageCount = PageCount

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount


    def _deserialize(self, params):
        self._PageCount = params.get("PageCount")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = DescribeBatchOperateTaskDTO()
                obj._deserialize(item)
                self._Items.append(obj)
        self._TotalCount = params.get("TotalCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBatchOperateTaskRequest(AbstractModel):
    """DescribeBatchOperateTask request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _Page: Page Number
        :type Page: str
        :param _Size: Page Number
        :type Size: str
        :param _StatusList: Status ListDraft: 'NS','N','P','R'
Running: 'Y'
Stopped: 'F'
Frozen: 'O'
Stopping: 'T'
        :type StatusList: list of str
        :param _OwnerNameList: List of Responsible Persons
        :type OwnerNameList: list of str
        :param _WorkflowIdList: Workflow List
        :type WorkflowIdList: list of str
        :param _TaskNameFilter: Task Name Search
        :type TaskNameFilter: str
        :param _TaskTypeList: Task Type List
        :type TaskTypeList: list of str
        :param _FordIdList: Folder List
        :type FordIdList: list of str
        :param _TaskIdFilter: Task ID Search
        :type TaskIdFilter: str
        :param _OwnerNameFilter: Responsible Person Search
        :type OwnerNameFilter: str
        :param _SortItem: Sort Fields:
UpdateTime
CreateTime
        :type SortItem: str
        :param _SortType: asc: Ascending
desc: Descending
        :type SortType: str
        :param _DataEngineList: Engine Type List: Three Types
SparkJob
SparkSql
presto
        :type DataEngineList: list of str
        :param _UserId: Operator Name
        :type UserId: str
        :param _OwnerId: 1
        :type OwnerId: str
        :param _TenantId: 1
        :type TenantId: str
        :param _DatasourceIdList: Data Source ID List
        :type DatasourceIdList: list of str
        :param _DatasourceTypeList: Data Source Type List
        :type DatasourceTypeList: list of str
        :param _CycleUnitList: Scheduling Unit Type List
        :type CycleUnitList: list of str
        :param _CanSubmit: Filter out tasks that can be submitted?
        :type CanSubmit: bool
        """
        self._ProjectId = None
        self._Page = None
        self._Size = None
        self._StatusList = None
        self._OwnerNameList = None
        self._WorkflowIdList = None
        self._TaskNameFilter = None
        self._TaskTypeList = None
        self._FordIdList = None
        self._TaskIdFilter = None
        self._OwnerNameFilter = None
        self._SortItem = None
        self._SortType = None
        self._DataEngineList = None
        self._UserId = None
        self._OwnerId = None
        self._TenantId = None
        self._DatasourceIdList = None
        self._DatasourceTypeList = None
        self._CycleUnitList = None
        self._CanSubmit = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Page(self):
        return self._Page

    @Page.setter
    def Page(self, Page):
        self._Page = Page

    @property
    def Size(self):
        return self._Size

    @Size.setter
    def Size(self, Size):
        self._Size = Size

    @property
    def StatusList(self):
        return self._StatusList

    @StatusList.setter
    def StatusList(self, StatusList):
        self._StatusList = StatusList

    @property
    def OwnerNameList(self):
        return self._OwnerNameList

    @OwnerNameList.setter
    def OwnerNameList(self, OwnerNameList):
        self._OwnerNameList = OwnerNameList

    @property
    def WorkflowIdList(self):
        return self._WorkflowIdList

    @WorkflowIdList.setter
    def WorkflowIdList(self, WorkflowIdList):
        self._WorkflowIdList = WorkflowIdList

    @property
    def TaskNameFilter(self):
        return self._TaskNameFilter

    @TaskNameFilter.setter
    def TaskNameFilter(self, TaskNameFilter):
        self._TaskNameFilter = TaskNameFilter

    @property
    def TaskTypeList(self):
        return self._TaskTypeList

    @TaskTypeList.setter
    def TaskTypeList(self, TaskTypeList):
        self._TaskTypeList = TaskTypeList

    @property
    def FordIdList(self):
        return self._FordIdList

    @FordIdList.setter
    def FordIdList(self, FordIdList):
        self._FordIdList = FordIdList

    @property
    def TaskIdFilter(self):
        return self._TaskIdFilter

    @TaskIdFilter.setter
    def TaskIdFilter(self, TaskIdFilter):
        self._TaskIdFilter = TaskIdFilter

    @property
    def OwnerNameFilter(self):
        return self._OwnerNameFilter

    @OwnerNameFilter.setter
    def OwnerNameFilter(self, OwnerNameFilter):
        self._OwnerNameFilter = OwnerNameFilter

    @property
    def SortItem(self):
        return self._SortItem

    @SortItem.setter
    def SortItem(self, SortItem):
        self._SortItem = SortItem

    @property
    def SortType(self):
        return self._SortType

    @SortType.setter
    def SortType(self, SortType):
        self._SortType = SortType

    @property
    def DataEngineList(self):
        return self._DataEngineList

    @DataEngineList.setter
    def DataEngineList(self, DataEngineList):
        self._DataEngineList = DataEngineList

    @property
    def UserId(self):
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def OwnerId(self):
        return self._OwnerId

    @OwnerId.setter
    def OwnerId(self, OwnerId):
        self._OwnerId = OwnerId

    @property
    def TenantId(self):
        return self._TenantId

    @TenantId.setter
    def TenantId(self, TenantId):
        self._TenantId = TenantId

    @property
    def DatasourceIdList(self):
        return self._DatasourceIdList

    @DatasourceIdList.setter
    def DatasourceIdList(self, DatasourceIdList):
        self._DatasourceIdList = DatasourceIdList

    @property
    def DatasourceTypeList(self):
        return self._DatasourceTypeList

    @DatasourceTypeList.setter
    def DatasourceTypeList(self, DatasourceTypeList):
        self._DatasourceTypeList = DatasourceTypeList

    @property
    def CycleUnitList(self):
        return self._CycleUnitList

    @CycleUnitList.setter
    def CycleUnitList(self, CycleUnitList):
        self._CycleUnitList = CycleUnitList

    @property
    def CanSubmit(self):
        return self._CanSubmit

    @CanSubmit.setter
    def CanSubmit(self, CanSubmit):
        self._CanSubmit = CanSubmit


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._Page = params.get("Page")
        self._Size = params.get("Size")
        self._StatusList = params.get("StatusList")
        self._OwnerNameList = params.get("OwnerNameList")
        self._WorkflowIdList = params.get("WorkflowIdList")
        self._TaskNameFilter = params.get("TaskNameFilter")
        self._TaskTypeList = params.get("TaskTypeList")
        self._FordIdList = params.get("FordIdList")
        self._TaskIdFilter = params.get("TaskIdFilter")
        self._OwnerNameFilter = params.get("OwnerNameFilter")
        self._SortItem = params.get("SortItem")
        self._SortType = params.get("SortType")
        self._DataEngineList = params.get("DataEngineList")
        self._UserId = params.get("UserId")
        self._OwnerId = params.get("OwnerId")
        self._TenantId = params.get("TenantId")
        self._DatasourceIdList = params.get("DatasourceIdList")
        self._DatasourceTypeList = params.get("DatasourceTypeList")
        self._CycleUnitList = params.get("CycleUnitList")
        self._CanSubmit = params.get("CanSubmit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBatchOperateTaskResponse(AbstractModel):
    """DescribeBatchOperateTask response structure.

    """

    def __init__(self):
        r"""
        :param _Data: NoNote: This field may return null, indicating that no valid value can be obtained.
        :type Data: :class:`tencentcloud.wedata.v20210820.models.DescribeBatchOperateTaskPage`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeBatchOperateTaskPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeColumnLineageRequest(AbstractModel):
    """DescribeColumnLineage request structure.

    """

    def __init__(self):
        r"""
        :param _Direction: Query Direction, INPUT, OUTPUT, BOTH enumerated values
        :type Direction: str
        :param _Data: Field Information
        :type Data: :class:`tencentcloud.wedata.v20210820.models.ColumnLineageInfo`
        :param _InputDepth: Single Query Indegree
        :type InputDepth: int
        :param _OutputDepth: Single Query Outdegree
        :type OutputDepth: int
        :param _ExtParams: Additional Parameters (Pass Caller Information)
        :type ExtParams: list of RecordField
        :param _IgnoreTemp: Filter Temporary Tables with the default value true
        :type IgnoreTemp: bool
        """
        self._Direction = None
        self._Data = None
        self._InputDepth = None
        self._OutputDepth = None
        self._ExtParams = None
        self._IgnoreTemp = None

    @property
    def Direction(self):
        return self._Direction

    @Direction.setter
    def Direction(self, Direction):
        self._Direction = Direction

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def InputDepth(self):
        return self._InputDepth

    @InputDepth.setter
    def InputDepth(self, InputDepth):
        self._InputDepth = InputDepth

    @property
    def OutputDepth(self):
        return self._OutputDepth

    @OutputDepth.setter
    def OutputDepth(self, OutputDepth):
        self._OutputDepth = OutputDepth

    @property
    def ExtParams(self):
        return self._ExtParams

    @ExtParams.setter
    def ExtParams(self, ExtParams):
        self._ExtParams = ExtParams

    @property
    def IgnoreTemp(self):
        return self._IgnoreTemp

    @IgnoreTemp.setter
    def IgnoreTemp(self, IgnoreTemp):
        self._IgnoreTemp = IgnoreTemp


    def _deserialize(self, params):
        self._Direction = params.get("Direction")
        if params.get("Data") is not None:
            self._Data = ColumnLineageInfo()
            self._Data._deserialize(params.get("Data"))
        self._InputDepth = params.get("InputDepth")
        self._OutputDepth = params.get("OutputDepth")
        if params.get("ExtParams") is not None:
            self._ExtParams = []
            for item in params.get("ExtParams"):
                obj = RecordField()
                obj._deserialize(item)
                self._ExtParams.append(obj)
        self._IgnoreTemp = params.get("IgnoreTemp")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeColumnLineageResponse(AbstractModel):
    """DescribeColumnLineage response structure.

    """

    def __init__(self):
        r"""
        :param _ColumnAggregationLineage: Field lineage information
Note: This field may return null, indicating that no valid value can be obtained.
        :type ColumnAggregationLineage: :class:`tencentcloud.wedata.v20210820.models.ColumnAggregationLineage`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ColumnAggregationLineage = None
        self._RequestId = None

    @property
    def ColumnAggregationLineage(self):
        return self._ColumnAggregationLineage

    @ColumnAggregationLineage.setter
    def ColumnAggregationLineage(self, ColumnAggregationLineage):
        self._ColumnAggregationLineage = ColumnAggregationLineage

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ColumnAggregationLineage") is not None:
            self._ColumnAggregationLineage = ColumnAggregationLineage()
            self._ColumnAggregationLineage._deserialize(params.get("ColumnAggregationLineage"))
        self._RequestId = params.get("RequestId")


class DescribeColumnsMetaRequest(AbstractModel):
    """DescribeColumnsMeta request structure.

    """

    def __init__(self):
        r"""
        :param _TableId: Table ID
        :type TableId: str
        :param _PageNumber: Page Number
        :type PageNumber: int
        :param _PageSize: Page Size
        :type PageSize: int
        :param _FilterSet: Filter
        :type FilterSet: list of Filter
        :param _OrderFieldSet: Sort Fields
        :type OrderFieldSet: list of OrderField
        :param _IsPartitionQuery: Whether to Query Partition Field, Default false
        :type IsPartitionQuery: bool
        :param _ComplianceId: Compliance Group ID
        :type ComplianceId: int
        """
        self._TableId = None
        self._PageNumber = None
        self._PageSize = None
        self._FilterSet = None
        self._OrderFieldSet = None
        self._IsPartitionQuery = None
        self._ComplianceId = None

    @property
    def TableId(self):
        return self._TableId

    @TableId.setter
    def TableId(self, TableId):
        self._TableId = TableId

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def FilterSet(self):
        return self._FilterSet

    @FilterSet.setter
    def FilterSet(self, FilterSet):
        self._FilterSet = FilterSet

    @property
    def OrderFieldSet(self):
        return self._OrderFieldSet

    @OrderFieldSet.setter
    def OrderFieldSet(self, OrderFieldSet):
        self._OrderFieldSet = OrderFieldSet

    @property
    def IsPartitionQuery(self):
        return self._IsPartitionQuery

    @IsPartitionQuery.setter
    def IsPartitionQuery(self, IsPartitionQuery):
        self._IsPartitionQuery = IsPartitionQuery

    @property
    def ComplianceId(self):
        return self._ComplianceId

    @ComplianceId.setter
    def ComplianceId(self, ComplianceId):
        self._ComplianceId = ComplianceId


    def _deserialize(self, params):
        self._TableId = params.get("TableId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("FilterSet") is not None:
            self._FilterSet = []
            for item in params.get("FilterSet"):
                obj = Filter()
                obj._deserialize(item)
                self._FilterSet.append(obj)
        if params.get("OrderFieldSet") is not None:
            self._OrderFieldSet = []
            for item in params.get("OrderFieldSet"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFieldSet.append(obj)
        self._IsPartitionQuery = params.get("IsPartitionQuery")
        self._ComplianceId = params.get("ComplianceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeColumnsMetaResponse(AbstractModel):
    """DescribeColumnsMeta response structure.

    """

    def __init__(self):
        r"""
        :param _ColumnMetaSet: Pagination return
Note: This field may return null, indicating that no valid value can be obtained.
        :type ColumnMetaSet: list of ColumnMeta
        :param _TotalCount: Number of records
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ColumnMetaSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def ColumnMetaSet(self):
        return self._ColumnMetaSet

    @ColumnMetaSet.setter
    def ColumnMetaSet(self, ColumnMetaSet):
        self._ColumnMetaSet = ColumnMetaSet

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ColumnMetaSet") is not None:
            self._ColumnMetaSet = []
            for item in params.get("ColumnMetaSet"):
                obj = ColumnMeta()
                obj._deserialize(item)
                self._ColumnMetaSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeDataCheckStatRequest(AbstractModel):
    """DescribeDataCheckStat request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _BeginDate: Start time, timestamp to the second
        :type BeginDate: str
        :param _EndDate: End time, timestamp to the second
        :type EndDate: str
        """
        self._ProjectId = None
        self._BeginDate = None
        self._EndDate = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def BeginDate(self):
        return self._BeginDate

    @BeginDate.setter
    def BeginDate(self, BeginDate):
        self._BeginDate = BeginDate

    @property
    def EndDate(self):
        return self._EndDate

    @EndDate.setter
    def EndDate(self, EndDate):
        self._EndDate = EndDate


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._BeginDate = params.get("BeginDate")
        self._EndDate = params.get("EndDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDataCheckStatResponse(AbstractModel):
    """DescribeDataCheckStat response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Result
        :type Data: :class:`tencentcloud.wedata.v20210820.models.DataCheckStat`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DataCheckStat()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeDataSourceInfoListRequest(AbstractModel):
    """DescribeDataSourceInfoList request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _PageNumber: Page Number
        :type PageNumber: int
        :param _PageSize: Page number
        :type PageSize: int
        :param _Filters: Filter condition (not supported yet)
        :type Filters: :class:`tencentcloud.wedata.v20210820.models.Filter`
        :param _OrderFields: Sorting Configuration
        :type OrderFields: :class:`tencentcloud.wedata.v20210820.models.OrderField`
        :param _Type: Data Source Type, mandatory (e.g., MYSQL, DLC, etc.)
        :type Type: str
        :param _DatasourceName: Data Source Name Filter
        :type DatasourceName: str
        """
        self._ProjectId = None
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None
        self._OrderFields = None
        self._Type = None
        self._DatasourceName = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def DatasourceName(self):
        return self._DatasourceName

    @DatasourceName.setter
    def DatasourceName(self, DatasourceName):
        self._DatasourceName = DatasourceName


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = Filter()
            self._Filters._deserialize(params.get("Filters"))
        if params.get("OrderFields") is not None:
            self._OrderFields = OrderField()
            self._OrderFields._deserialize(params.get("OrderFields"))
        self._Type = params.get("Type")
        self._DatasourceName = params.get("DatasourceName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDataSourceInfoListResponse(AbstractModel):
    """DescribeDataSourceInfoList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of items.
        :type TotalCount: int
        :param _DatasourceSet: Data Source Information List.
Note: This field may return null, indicating that no valid value can be obtained.
        :type DatasourceSet: list of DatasourceBaseInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._DatasourceSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DatasourceSet(self):
        return self._DatasourceSet

    @DatasourceSet.setter
    def DatasourceSet(self, DatasourceSet):
        self._DatasourceSet = DatasourceSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DatasourceSet") is not None:
            self._DatasourceSet = []
            for item in params.get("DatasourceSet"):
                obj = DatasourceBaseInfo()
                obj._deserialize(item)
                self._DatasourceSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDataSourceListRequest(AbstractModel):
    """DescribeDataSourceList request structure.

    """

    def __init__(self):
        r"""
        :param _PageNumber: Page Number
        :type PageNumber: int
        :param _PageSize: Number of returns
        :type PageSize: int
        :param _OrderFields: Sorting Configuration
        :type OrderFields: list of OrderField
        :param _Filters: Optional Filter Criteria, Filter optional configurations (reference): "Name": { "type": "string", "description": "Data Source Name" }, "Type": { "type": "string", "description": "Type" }, "ClusterId": { "type": "string", "description": "Cluster ID" }, "CategoryId": { "type": "string", "description": "Classification, Project or Space ID" }
        :type Filters: list of Filter
        """
        self._PageNumber = None
        self._PageSize = None
        self._OrderFields = None
        self._Filters = None

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDataSourceListResponse(AbstractModel):
    """DescribeDataSourceList response structure.

    """

    def __init__(self):
        r"""
        :param _Data: data source list
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: :class:`tencentcloud.wedata.v20210820.models.DataSourceInfoPage`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DataSourceInfoPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeDatabaseInfoListRequest(AbstractModel):
    """DescribeDatabaseInfoList request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Ignore Query String
        :type Filters: list of Filter
        :param _ConnectionType: Connection Type
        :type ConnectionType: str
        """
        self._Filters = None
        self._ConnectionType = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def ConnectionType(self):
        return self._ConnectionType

    @ConnectionType.setter
    def ConnectionType(self, ConnectionType):
        self._ConnectionType = ConnectionType


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._ConnectionType = params.get("ConnectionType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDatabaseInfoListResponse(AbstractModel):
    """DescribeDatabaseInfoList response structure.

    """

    def __init__(self):
        r"""
        :param _DatabaseInfo: Database List
Note: This field may return null, indicating that no valid value can be obtained.
        :type DatabaseInfo: list of DatabaseInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DatabaseInfo = None
        self._RequestId = None

    @property
    def DatabaseInfo(self):
        return self._DatabaseInfo

    @DatabaseInfo.setter
    def DatabaseInfo(self, DatabaseInfo):
        self._DatabaseInfo = DatabaseInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DatabaseInfo") is not None:
            self._DatabaseInfo = []
            for item in params.get("DatabaseInfo"):
                obj = DatabaseInfo()
                obj._deserialize(item)
                self._DatabaseInfo.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDatabaseMetasRequest(AbstractModel):
    """DescribeDatabaseMetas request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filter Fields, projectIds/msTypes/createTime/modifiedTime
        :type Filters: list of Filter
        :param _OrderFields: Sort Fields, such as name
        :type OrderFields: list of OrderField
        """
        self._Filters = None
        self._OrderFields = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDatabaseMetasResponse(AbstractModel):
    """DescribeDatabaseMetas response structure.

    """

    def __init__(self):
        r"""
        :param _DatabaseMeta: NoNote: This field may return null, indicating that no valid value can be obtained.
        :type DatabaseMeta: list of DatabaseMeta
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DatabaseMeta = None
        self._RequestId = None

    @property
    def DatabaseMeta(self):
        return self._DatabaseMeta

    @DatabaseMeta.setter
    def DatabaseMeta(self, DatabaseMeta):
        self._DatabaseMeta = DatabaseMeta

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DatabaseMeta") is not None:
            self._DatabaseMeta = []
            for item in params.get("DatabaseMeta"):
                obj = DatabaseMeta()
                obj._deserialize(item)
                self._DatabaseMeta.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDatasourceRequest(AbstractModel):
    """DescribeDatasource request structure.

    """

    def __init__(self):
        r"""
        :param _Id: Unique Object ID
        :type Id: int
        :param _Env: production: production, development: development
        :type Env: str
        """
        self._Id = None
        self._Env = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Env(self):
        return self._Env

    @Env.setter
    def Env(self, Env):
        self._Env = Env


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Env = params.get("Env")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDatasourceResponse(AbstractModel):
    """DescribeDatasource response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Data Source Object
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: :class:`tencentcloud.wedata.v20210820.models.DataSourceInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DataSourceInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeDependOpsTasksRequest(AbstractModel):
    """DescribeDependOpsTasks request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID
        :type TaskId: str
        :param _Deep: Upstream/Downstream Levels 1-6
        :type Deep: int
        :param _Up: 1: Indicates querying upstream nodes; 0: Indicates querying downstream nodes; 2: Indicates querying both upstream and downstream nodes
        :type Up: int
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _WorkflowId: Task Workflow ID
        :type WorkflowId: str
        """
        self._TaskId = None
        self._Deep = None
        self._Up = None
        self._ProjectId = None
        self._WorkflowId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Deep(self):
        return self._Deep

    @Deep.setter
    def Deep(self, Deep):
        self._Deep = Deep

    @property
    def Up(self):
        return self._Up

    @Up.setter
    def Up(self, Up):
        self._Up = Up

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Deep = params.get("Deep")
        self._Up = params.get("Up")
        self._ProjectId = params.get("ProjectId")
        self._WorkflowId = params.get("WorkflowId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDependOpsTasksResponse(AbstractModel):
    """DescribeDependOpsTasks response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Canvas Task and Link Information
        :type Data: :class:`tencentcloud.wedata.v20210820.models.OpsTaskCanvasInfoList`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = OpsTaskCanvasInfoList()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeDependTaskListsRequest(AbstractModel):
    """DescribeDependTaskLists request structure.

    """

    def __init__(self):
        r"""
        :param _TaskIds: Task ID List
        :type TaskIds: list of str
        :param _ProjectId: Project ID
        :type ProjectId: str
        """
        self._TaskIds = None
        self._ProjectId = None

    @property
    def TaskIds(self):
        return self._TaskIds

    @TaskIds.setter
    def TaskIds(self, TaskIds):
        self._TaskIds = TaskIds

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskIds = params.get("TaskIds")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDependTaskListsResponse(AbstractModel):
    """DescribeDependTaskLists response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Delete Result
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: list of TaskOpsDto
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = TaskOpsDto()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDimensionScoreRequest(AbstractModel):
    """DescribeDimensionScore request structure.

    """

    def __init__(self):
        r"""
        :param _StatisticsDate: Statistics Date Timestamp
        :type StatisticsDate: int
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _DatasourceId: Data source ID
        :type DatasourceId: str
        :param _Filters: Ignore Query String
        :type Filters: list of Filter
        """
        self._StatisticsDate = None
        self._ProjectId = None
        self._DatasourceId = None
        self._Filters = None

    @property
    def StatisticsDate(self):
        return self._StatisticsDate

    @StatisticsDate.setter
    def StatisticsDate(self, StatisticsDate):
        self._StatisticsDate = StatisticsDate

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._StatisticsDate = params.get("StatisticsDate")
        self._ProjectId = params.get("ProjectId")
        self._DatasourceId = params.get("DatasourceId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDimensionScoreResponse(AbstractModel):
    """DescribeDimensionScore response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Dimensional scoring
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: :class:`tencentcloud.wedata.v20210820.models.DimensionScore`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DimensionScore()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeDrInstancePageRequest(AbstractModel):
    """DescribeDrInstancePage request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _TaskSource: Task Source ADHOC || WORKFLOW
        :type TaskSource: str
        :param _PageIndex: Index Page Number
        :type PageIndex: int
        :param _PageSize: Page size
        :type PageSize: int
        :param _TaskName: Task Name
        :type TaskName: str
        :param _StartTime: Submission Start Time yyyy-MM-dd HH:mm:ss
        :type StartTime: str
        :param _EndTime: Submission End Time yyyy-MM-dd HH:mm:ss
        :type EndTime: str
        :param _FolderIds: Folder ID
        :type FolderIds: list of str
        :param _WorkflowIds: Workflow ID
        :type WorkflowIds: list of str
        :param _JustMe: View Only Mine
        :type JustMe: bool
        :param _TaskTypes: Task Type
        :type TaskTypes: list of str
        :param _SubmitUsers: Trial Run Submitter userId List
        :type SubmitUsers: list of str
        :param _StatusList: Trial Run Status
        :type StatusList: list of str
        """
        self._ProjectId = None
        self._TaskSource = None
        self._PageIndex = None
        self._PageSize = None
        self._TaskName = None
        self._StartTime = None
        self._EndTime = None
        self._FolderIds = None
        self._WorkflowIds = None
        self._JustMe = None
        self._TaskTypes = None
        self._SubmitUsers = None
        self._StatusList = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskSource(self):
        return self._TaskSource

    @TaskSource.setter
    def TaskSource(self, TaskSource):
        self._TaskSource = TaskSource

    @property
    def PageIndex(self):
        return self._PageIndex

    @PageIndex.setter
    def PageIndex(self, PageIndex):
        self._PageIndex = PageIndex

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def TaskName(self):
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def FolderIds(self):
        return self._FolderIds

    @FolderIds.setter
    def FolderIds(self, FolderIds):
        self._FolderIds = FolderIds

    @property
    def WorkflowIds(self):
        return self._WorkflowIds

    @WorkflowIds.setter
    def WorkflowIds(self, WorkflowIds):
        self._WorkflowIds = WorkflowIds

    @property
    def JustMe(self):
        return self._JustMe

    @JustMe.setter
    def JustMe(self, JustMe):
        self._JustMe = JustMe

    @property
    def TaskTypes(self):
        return self._TaskTypes

    @TaskTypes.setter
    def TaskTypes(self, TaskTypes):
        self._TaskTypes = TaskTypes

    @property
    def SubmitUsers(self):
        return self._SubmitUsers

    @SubmitUsers.setter
    def SubmitUsers(self, SubmitUsers):
        self._SubmitUsers = SubmitUsers

    @property
    def StatusList(self):
        return self._StatusList

    @StatusList.setter
    def StatusList(self, StatusList):
        self._StatusList = StatusList


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TaskSource = params.get("TaskSource")
        self._PageIndex = params.get("PageIndex")
        self._PageSize = params.get("PageSize")
        self._TaskName = params.get("TaskName")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._FolderIds = params.get("FolderIds")
        self._WorkflowIds = params.get("WorkflowIds")
        self._JustMe = params.get("JustMe")
        self._TaskTypes = params.get("TaskTypes")
        self._SubmitUsers = params.get("SubmitUsers")
        self._StatusList = params.get("StatusList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDrInstancePageResponse(AbstractModel):
    """DescribeDrInstancePage response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Result Set
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: :class:`tencentcloud.wedata.v20210820.models.DrInstanceOpsDtoPage`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DrInstanceOpsDtoPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeDsFolderTreeRequest(AbstractModel):
    """DescribeDsFolderTree request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _FirstLevelPull: Whether to Pull at First Level true Yes 
false No
        :type FirstLevelPull: bool
        :param _FolderId: Folder ID
        :type FolderId: str
        :param _WorkflowId: Workflow ID
        :type WorkflowId: str
        :param _Keyword: Keyword Search
        :type Keyword: str
        :param _IncludeWorkflow: Whether to Include Workflow true Yes 
false No
        :type IncludeWorkflow: bool
        :param _IncludeTask: Whether to Include Tasks true Yes 
false No
        :type IncludeTask: bool
        :param _IncludeVirtualTask: Does it include virtual tasks? This parameter is effective only when IncludeTask is true, default is true
        :type IncludeVirtualTask: bool
        :param _TaskFolderId: Task directory ID
        :type TaskFolderId: str
        :param _DisplayType: classification. Categorized Display  catalog. Directory Display
        :type DisplayType: str
        :param _IncludeTaskFolder: Does it include task directories? true means yes
false No
        :type IncludeTaskFolder: bool
        """
        self._ProjectId = None
        self._FirstLevelPull = None
        self._FolderId = None
        self._WorkflowId = None
        self._Keyword = None
        self._IncludeWorkflow = None
        self._IncludeTask = None
        self._IncludeVirtualTask = None
        self._TaskFolderId = None
        self._DisplayType = None
        self._IncludeTaskFolder = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def FirstLevelPull(self):
        return self._FirstLevelPull

    @FirstLevelPull.setter
    def FirstLevelPull(self, FirstLevelPull):
        self._FirstLevelPull = FirstLevelPull

    @property
    def FolderId(self):
        return self._FolderId

    @FolderId.setter
    def FolderId(self, FolderId):
        self._FolderId = FolderId

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId

    @property
    def Keyword(self):
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword

    @property
    def IncludeWorkflow(self):
        return self._IncludeWorkflow

    @IncludeWorkflow.setter
    def IncludeWorkflow(self, IncludeWorkflow):
        self._IncludeWorkflow = IncludeWorkflow

    @property
    def IncludeTask(self):
        return self._IncludeTask

    @IncludeTask.setter
    def IncludeTask(self, IncludeTask):
        self._IncludeTask = IncludeTask

    @property
    def IncludeVirtualTask(self):
        return self._IncludeVirtualTask

    @IncludeVirtualTask.setter
    def IncludeVirtualTask(self, IncludeVirtualTask):
        self._IncludeVirtualTask = IncludeVirtualTask

    @property
    def TaskFolderId(self):
        return self._TaskFolderId

    @TaskFolderId.setter
    def TaskFolderId(self, TaskFolderId):
        self._TaskFolderId = TaskFolderId

    @property
    def DisplayType(self):
        return self._DisplayType

    @DisplayType.setter
    def DisplayType(self, DisplayType):
        self._DisplayType = DisplayType

    @property
    def IncludeTaskFolder(self):
        return self._IncludeTaskFolder

    @IncludeTaskFolder.setter
    def IncludeTaskFolder(self, IncludeTaskFolder):
        self._IncludeTaskFolder = IncludeTaskFolder


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._FirstLevelPull = params.get("FirstLevelPull")
        self._FolderId = params.get("FolderId")
        self._WorkflowId = params.get("WorkflowId")
        self._Keyword = params.get("Keyword")
        self._IncludeWorkflow = params.get("IncludeWorkflow")
        self._IncludeTask = params.get("IncludeTask")
        self._IncludeVirtualTask = params.get("IncludeVirtualTask")
        self._TaskFolderId = params.get("TaskFolderId")
        self._DisplayType = params.get("DisplayType")
        self._IncludeTaskFolder = params.get("IncludeTaskFolder")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDsFolderTreeResponse(AbstractModel):
    """DescribeDsFolderTree response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Unified Tree Structure Return Attribute List
        :type Data: list of PathNodeDsVO
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = PathNodeDsVO()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDsParentFolderTreeRequest(AbstractModel):
    """DescribeDsParentFolderTree request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _FolderId: Folder ID
        :type FolderId: str
        :param _WorkflowId: Workflow ID
        :type WorkflowId: str
        :param _TaskId: Task ID
        :type TaskId: str
        :param _DisplayType: Task Display Format, Example Values
-    classification: Categorized Display
-    catalog: Directory Display
        :type DisplayType: str
        """
        self._ProjectId = None
        self._FolderId = None
        self._WorkflowId = None
        self._TaskId = None
        self._DisplayType = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def FolderId(self):
        return self._FolderId

    @FolderId.setter
    def FolderId(self, FolderId):
        self._FolderId = FolderId

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def DisplayType(self):
        return self._DisplayType

    @DisplayType.setter
    def DisplayType(self, DisplayType):
        self._DisplayType = DisplayType


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._FolderId = params.get("FolderId")
        self._WorkflowId = params.get("WorkflowId")
        self._TaskId = params.get("TaskId")
        self._DisplayType = params.get("DisplayType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDsParentFolderTreeResponse(AbstractModel):
    """DescribeDsParentFolderTree response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Unified Tree Structure Return Attribute List
        :type Data: list of PathNodeDsVO
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = PathNodeDsVO()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeEventCasesRequest(AbstractModel):
    """DescribeEventCases request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _Category: Event Instance Catalog, Example Value:
- Expired: expired
- Not Expired: consuming
- All: all

        :type Category: str
        :param _PageNumber: Page Number
        :type PageNumber: int
        :param _PageSize: Number of items per page
        :type PageSize: int
        :param _EventName: Event name
        :type EventName: str
        :param _EventType: Event type
        :type EventType: str
        :param _EventSubType: Event Segmentation Type
        :type EventSubType: str
        :param _EventBroadcastType: Event Broadcast Type
        :type EventBroadcastType: str
        :param _Status: Event Instance Status, Example Value:
- Consumed: COMSUMED
- Expired: EXPIRED
- Pending Consumption: ACTIVE
- Consuming: CONSUMING
        :type Status: str
        :param _CreationTimeStart: Minimum Creation Time of Event Instance
        :type CreationTimeStart: str
        :param _CreationTimeEnd: Maximum Creation Time of Event Instance
        :type CreationTimeEnd: str
        :param _EventTriggeredTimeStart: Minimum Trigger Time of Event Instance
        :type EventTriggeredTimeStart: str
        :param _EventTriggeredTimeEnd: Maximum Trigger Time of Event Instance
        :type EventTriggeredTimeEnd: str
        :param _LogTimeStart: Minimum Consumption Time of Event Instance
        :type LogTimeStart: str
        :param _LogTimeEnd: Maximum Consumption Time of Event Instance
        :type LogTimeEnd: str
        :param _Dimension: Event Instance Data Timestamp
        :type Dimension: str
        :param _TimeToLive: Event Instance Validity Period
        :type TimeToLive: str
        :param _SortItem: Sort Fields
        :type SortItem: str
        :param _SortType: Sorting Order
        :type SortType: str
        """
        self._ProjectId = None
        self._Category = None
        self._PageNumber = None
        self._PageSize = None
        self._EventName = None
        self._EventType = None
        self._EventSubType = None
        self._EventBroadcastType = None
        self._Status = None
        self._CreationTimeStart = None
        self._CreationTimeEnd = None
        self._EventTriggeredTimeStart = None
        self._EventTriggeredTimeEnd = None
        self._LogTimeStart = None
        self._LogTimeEnd = None
        self._Dimension = None
        self._TimeToLive = None
        self._SortItem = None
        self._SortType = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Category(self):
        return self._Category

    @Category.setter
    def Category(self, Category):
        self._Category = Category

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def EventName(self):
        return self._EventName

    @EventName.setter
    def EventName(self, EventName):
        self._EventName = EventName

    @property
    def EventType(self):
        warnings.warn("parameter `EventType` is deprecated", DeprecationWarning) 

        return self._EventType

    @EventType.setter
    def EventType(self, EventType):
        warnings.warn("parameter `EventType` is deprecated", DeprecationWarning) 

        self._EventType = EventType

    @property
    def EventSubType(self):
        return self._EventSubType

    @EventSubType.setter
    def EventSubType(self, EventSubType):
        self._EventSubType = EventSubType

    @property
    def EventBroadcastType(self):
        warnings.warn("parameter `EventBroadcastType` is deprecated", DeprecationWarning) 

        return self._EventBroadcastType

    @EventBroadcastType.setter
    def EventBroadcastType(self, EventBroadcastType):
        warnings.warn("parameter `EventBroadcastType` is deprecated", DeprecationWarning) 

        self._EventBroadcastType = EventBroadcastType

    @property
    def Status(self):
        warnings.warn("parameter `Status` is deprecated", DeprecationWarning) 

        return self._Status

    @Status.setter
    def Status(self, Status):
        warnings.warn("parameter `Status` is deprecated", DeprecationWarning) 

        self._Status = Status

    @property
    def CreationTimeStart(self):
        return self._CreationTimeStart

    @CreationTimeStart.setter
    def CreationTimeStart(self, CreationTimeStart):
        self._CreationTimeStart = CreationTimeStart

    @property
    def CreationTimeEnd(self):
        return self._CreationTimeEnd

    @CreationTimeEnd.setter
    def CreationTimeEnd(self, CreationTimeEnd):
        self._CreationTimeEnd = CreationTimeEnd

    @property
    def EventTriggeredTimeStart(self):
        return self._EventTriggeredTimeStart

    @EventTriggeredTimeStart.setter
    def EventTriggeredTimeStart(self, EventTriggeredTimeStart):
        self._EventTriggeredTimeStart = EventTriggeredTimeStart

    @property
    def EventTriggeredTimeEnd(self):
        return self._EventTriggeredTimeEnd

    @EventTriggeredTimeEnd.setter
    def EventTriggeredTimeEnd(self, EventTriggeredTimeEnd):
        self._EventTriggeredTimeEnd = EventTriggeredTimeEnd

    @property
    def LogTimeStart(self):
        return self._LogTimeStart

    @LogTimeStart.setter
    def LogTimeStart(self, LogTimeStart):
        self._LogTimeStart = LogTimeStart

    @property
    def LogTimeEnd(self):
        return self._LogTimeEnd

    @LogTimeEnd.setter
    def LogTimeEnd(self, LogTimeEnd):
        self._LogTimeEnd = LogTimeEnd

    @property
    def Dimension(self):
        return self._Dimension

    @Dimension.setter
    def Dimension(self, Dimension):
        self._Dimension = Dimension

    @property
    def TimeToLive(self):
        return self._TimeToLive

    @TimeToLive.setter
    def TimeToLive(self, TimeToLive):
        self._TimeToLive = TimeToLive

    @property
    def SortItem(self):
        return self._SortItem

    @SortItem.setter
    def SortItem(self, SortItem):
        self._SortItem = SortItem

    @property
    def SortType(self):
        return self._SortType

    @SortType.setter
    def SortType(self, SortType):
        self._SortType = SortType


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._Category = params.get("Category")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        self._EventName = params.get("EventName")
        self._EventType = params.get("EventType")
        self._EventSubType = params.get("EventSubType")
        self._EventBroadcastType = params.get("EventBroadcastType")
        self._Status = params.get("Status")
        self._CreationTimeStart = params.get("CreationTimeStart")
        self._CreationTimeEnd = params.get("CreationTimeEnd")
        self._EventTriggeredTimeStart = params.get("EventTriggeredTimeStart")
        self._EventTriggeredTimeEnd = params.get("EventTriggeredTimeEnd")
        self._LogTimeStart = params.get("LogTimeStart")
        self._LogTimeEnd = params.get("LogTimeEnd")
        self._Dimension = params.get("Dimension")
        self._TimeToLive = params.get("TimeToLive")
        self._SortItem = params.get("SortItem")
        self._SortType = params.get("SortType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEventCasesResponse(AbstractModel):
    """DescribeEventCases response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Event Instance Pagination Query Results
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: :class:`tencentcloud.wedata.v20210820.models.EventCaseAuditLogVOCollection`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = EventCaseAuditLogVOCollection()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeEventConsumeTasksRequest(AbstractModel):
    """DescribeEventConsumeTasks request structure.

    """

    def __init__(self):
        r"""
        :param _EventCaseId: Event Instance ID
        :type EventCaseId: str
        :param _PageNumber: Page Number
        :type PageNumber: int
        :param _PageSize: Number of items per page
        :type PageSize: int
        """
        self._EventCaseId = None
        self._PageNumber = None
        self._PageSize = None

    @property
    def EventCaseId(self):
        return self._EventCaseId

    @EventCaseId.setter
    def EventCaseId(self, EventCaseId):
        self._EventCaseId = EventCaseId

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        self._EventCaseId = params.get("EventCaseId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEventConsumeTasksResponse(AbstractModel):
    """DescribeEventConsumeTasks response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Event Consumption Task Record List
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: :class:`tencentcloud.wedata.v20210820.models.EventCaseConsumeLogOptDtoCollection`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = EventCaseConsumeLogOptDtoCollection()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeEventRequest(AbstractModel):
    """DescribeEvent request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _EventName: Event name
        :type EventName: str
        """
        self._ProjectId = None
        self._EventName = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def EventName(self):
        return self._EventName

    @EventName.setter
    def EventName(self, EventName):
        self._EventName = EventName


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._EventName = params.get("EventName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEventResponse(AbstractModel):
    """DescribeEvent response structure.

    """

    def __init__(self):
        r"""
        :param _Data: EventNote: This field may return null, indicating that no valid value can be obtained.
        :type Data: :class:`tencentcloud.wedata.v20210820.models.EventOpsDto`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = EventOpsDto()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeExecStrategyRequest(AbstractModel):
    """DescribeExecStrategy request structure.

    """

    def __init__(self):
        r"""
        :param _RuleGroupId: Rule Group ID
        :type RuleGroupId: int
        :param _ProjectId: Project ID
        :type ProjectId: str
        """
        self._RuleGroupId = None
        self._ProjectId = None

    @property
    def RuleGroupId(self):
        return self._RuleGroupId

    @RuleGroupId.setter
    def RuleGroupId(self, RuleGroupId):
        self._RuleGroupId = RuleGroupId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._RuleGroupId = params.get("RuleGroupId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeExecStrategyResponse(AbstractModel):
    """DescribeExecStrategy response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Rule Group Execution Strategy
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleGroupExecStrategy`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleGroupExecStrategy()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeFieldBasicInfoRequest(AbstractModel):
    """DescribeFieldBasicInfo request structure.

    """

    def __init__(self):
        r"""
        :param _PageNumber: Page Number
        :type PageNumber: int
        :param _PageSize: Page Size
        :type PageSize: int
        :param _Filters: Filter field
        :type Filters: list of Filter
        :param _OrderFields: Sort Fields
        :type OrderFields: list of OrderField
        """
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None
        self._OrderFields = None

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields


    def _deserialize(self, params):
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFieldBasicInfoResponse(AbstractModel):
    """DescribeFieldBasicInfo response structure.

    """

    def __init__(self):
        r"""
        :param _ColumnBasicInfoList: Field Metadata
Note: This field may return null, indicating that no valid value can be obtained.
        :type ColumnBasicInfoList: list of ColumnBasicInfo
        :param _TotalCount: Total number of items
Note: This field may return null, indicating that no valid value can be obtained.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ColumnBasicInfoList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def ColumnBasicInfoList(self):
        return self._ColumnBasicInfoList

    @ColumnBasicInfoList.setter
    def ColumnBasicInfoList(self, ColumnBasicInfoList):
        self._ColumnBasicInfoList = ColumnBasicInfoList

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ColumnBasicInfoList") is not None:
            self._ColumnBasicInfoList = []
            for item in params.get("ColumnBasicInfoList"):
                obj = ColumnBasicInfo()
                obj._deserialize(item)
                self._ColumnBasicInfoList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeFolderWorkflowListData(AbstractModel):
    """Folder Pagination Information

    """

    def __init__(self):
        r"""
        :param _Items: Workflow Information List
        :type Items: list of Workflow
        :param _TotalCount: Total number of items
        :type TotalCount: int
        :param _PageNumber: Page Number
        :type PageNumber: int
        :param _PageSize: Page Size
        :type PageSize: int
        """
        self._Items = None
        self._TotalCount = None
        self._PageNumber = None
        self._PageSize = None

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = Workflow()
                obj._deserialize(item)
                self._Items.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFolderWorkflowListRequest(AbstractModel):
    """DescribeFolderWorkflowList request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _ParentsFolderId: Parent Folder ID
        :type ParentsFolderId: str
        :param _KeyWords: Keyword
        :type KeyWords: str
        :param _PageNumber: Page number, default is 1
        :type PageNumber: int
        :param _PageSize: Page size, default is 10
        :type PageSize: int
        """
        self._ProjectId = None
        self._ParentsFolderId = None
        self._KeyWords = None
        self._PageNumber = None
        self._PageSize = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ParentsFolderId(self):
        return self._ParentsFolderId

    @ParentsFolderId.setter
    def ParentsFolderId(self, ParentsFolderId):
        self._ParentsFolderId = ParentsFolderId

    @property
    def KeyWords(self):
        return self._KeyWords

    @KeyWords.setter
    def KeyWords(self, KeyWords):
        self._KeyWords = KeyWords

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._ParentsFolderId = params.get("ParentsFolderId")
        self._KeyWords = params.get("KeyWords")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFolderWorkflowListResponse(AbstractModel):
    """DescribeFolderWorkflowList response structure.

    """

    def __init__(self):
        r"""
        :param _Data: NoNote: This field may return null, indicating that no valid value can be obtained.
        :type Data: :class:`tencentcloud.wedata.v20210820.models.DescribeFolderWorkflowListData`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeFolderWorkflowListData()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeFunctionKindsRequest(AbstractModel):
    """DescribeFunctionKinds request structure.

    """


class DescribeFunctionKindsResponse(AbstractModel):
    """DescribeFunctionKinds response structure.

    """

    def __init__(self):
        r"""
        :param _Kinds: NoNote: This field may return null, indicating that no valid value can be obtained.
        :type Kinds: list of FunctionTypeOrKind
        :param _ErrorMessage: NoNote: This field may return null, indicating that no valid value can be obtained.
        :type ErrorMessage: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Kinds = None
        self._ErrorMessage = None
        self._RequestId = None

    @property
    def Kinds(self):
        return self._Kinds

    @Kinds.setter
    def Kinds(self, Kinds):
        self._Kinds = Kinds

    @property
    def ErrorMessage(self):
        return self._ErrorMessage

    @ErrorMessage.setter
    def ErrorMessage(self, ErrorMessage):
        self._ErrorMessage = ErrorMessage

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Kinds") is not None:
            self._Kinds = []
            for item in params.get("Kinds"):
                obj = FunctionTypeOrKind()
                obj._deserialize(item)
                self._Kinds.append(obj)
        self._ErrorMessage = params.get("ErrorMessage")
        self._RequestId = params.get("RequestId")


class DescribeFunctionTypesRequest(AbstractModel):
    """DescribeFunctionTypes request structure.

    """


class DescribeFunctionTypesResponse(AbstractModel):
    """DescribeFunctionTypes response structure.

    """

    def __init__(self):
        r"""
        :param _Types: TypeNote: This field may return null, indicating that no valid value can be obtained.
        :type Types: list of FunctionTypeOrKind
        :param _ErrorMessage: Error messageNote: This field may return null, indicating that no valid value can be obtained.
        :type ErrorMessage: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Types = None
        self._ErrorMessage = None
        self._RequestId = None

    @property
    def Types(self):
        return self._Types

    @Types.setter
    def Types(self, Types):
        self._Types = Types

    @property
    def ErrorMessage(self):
        return self._ErrorMessage

    @ErrorMessage.setter
    def ErrorMessage(self, ErrorMessage):
        self._ErrorMessage = ErrorMessage

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Types") is not None:
            self._Types = []
            for item in params.get("Types"):
                obj = FunctionTypeOrKind()
                obj._deserialize(item)
                self._Types.append(obj)
        self._ErrorMessage = params.get("ErrorMessage")
        self._RequestId = params.get("RequestId")


class DescribeInstanceByCycleRequest(AbstractModel):
    """DescribeInstanceByCycle request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: 1
        :type ProjectId: str
        :param _TenantId: 1
        :type TenantId: str
        """
        self._ProjectId = None
        self._TenantId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TenantId(self):
        return self._TenantId

    @TenantId.setter
    def TenantId(self, TenantId):
        self._TenantId = TenantId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TenantId = params.get("TenantId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInstanceByCycleResponse(AbstractModel):
    """DescribeInstanceByCycle response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Statistical Results
        :type Data: list of TaskByCycle
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = TaskByCycle()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeInstanceLastLogRequest(AbstractModel):
    """DescribeInstanceLastLog request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID
        :type TaskId: str
        :param _CurRunDate: Data Timestamp
        :type CurRunDate: str
        """
        self._TaskId = None
        self._CurRunDate = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def CurRunDate(self):
        return self._CurRunDate

    @CurRunDate.setter
    def CurRunDate(self, CurRunDate):
        self._CurRunDate = CurRunDate


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._CurRunDate = params.get("CurRunDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInstanceLastLogResponse(AbstractModel):
    """DescribeInstanceLastLog response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Log
        :type Data: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DescribeInstanceListRequest(AbstractModel):
    """DescribeInstanceList request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project/workspace ID
        :type ProjectId: str
        :param _PageIndex: Page Number
        :type PageIndex: int
        :param _PageSize: Number of items displayed per page
        :type PageSize: int
        :param _CycleList: Cycle List (e.g., daily, one-time), optional
        :type CycleList: list of str
        :param _OwnerList: Person in Charge
        :type OwnerList: list of str
        :param _InstanceType: Keep consistent with previous
        :type InstanceType: str
        :param _Sort: Sorting Order (asc, desc)
        :type Sort: str
        :param _SortCol: Sort Column (costTime Runtime duration, startTime Start Time, state Instance status, curRunDate Data Timestamp)
        :type SortCol: str
        :param _TaskTypeList: Type List (e.g., Python Task Type: 30
PySpark Task Type: 31
hivesql task type:34
shell task type:35
sparksql task type:36 jdbcsql task type:21 dlc task type:32), optional
        :type TaskTypeList: list of int
        :param _StateList: Status list (e.g., success 2, executing 1), optional
        :type StateList: list of int
        :param _Keyword: Task Name
        :type Keyword: str
        """
        self._ProjectId = None
        self._PageIndex = None
        self._PageSize = None
        self._CycleList = None
        self._OwnerList = None
        self._InstanceType = None
        self._Sort = None
        self._SortCol = None
        self._TaskTypeList = None
        self._StateList = None
        self._Keyword = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PageIndex(self):
        return self._PageIndex

    @PageIndex.setter
    def PageIndex(self, PageIndex):
        self._PageIndex = PageIndex

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def CycleList(self):
        return self._CycleList

    @CycleList.setter
    def CycleList(self, CycleList):
        self._CycleList = CycleList

    @property
    def OwnerList(self):
        return self._OwnerList

    @OwnerList.setter
    def OwnerList(self, OwnerList):
        self._OwnerList = OwnerList

    @property
    def InstanceType(self):
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def Sort(self):
        return self._Sort

    @Sort.setter
    def Sort(self, Sort):
        self._Sort = Sort

    @property
    def SortCol(self):
        return self._SortCol

    @SortCol.setter
    def SortCol(self, SortCol):
        self._SortCol = SortCol

    @property
    def TaskTypeList(self):
        return self._TaskTypeList

    @TaskTypeList.setter
    def TaskTypeList(self, TaskTypeList):
        self._TaskTypeList = TaskTypeList

    @property
    def StateList(self):
        return self._StateList

    @StateList.setter
    def StateList(self, StateList):
        self._StateList = StateList

    @property
    def Keyword(self):
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._PageIndex = params.get("PageIndex")
        self._PageSize = params.get("PageSize")
        self._CycleList = params.get("CycleList")
        self._OwnerList = params.get("OwnerList")
        self._InstanceType = params.get("InstanceType")
        self._Sort = params.get("Sort")
        self._SortCol = params.get("SortCol")
        self._TaskTypeList = params.get("TaskTypeList")
        self._StateList = params.get("StateList")
        self._Keyword = params.get("Keyword")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInstanceListResponse(AbstractModel):
    """DescribeInstanceList response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Result
        :type Data: str
        :param _InstanceList: Instance ListNote: This field may return null, indicating that no valid value can be obtained.
        :type InstanceList: list of InstanceList
        :param _TotalCount: Total number of itemsNote: This field may return null, indicating that no valid value can be obtained.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._InstanceList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def InstanceList(self):
        return self._InstanceList

    @InstanceList.setter
    def InstanceList(self, InstanceList):
        self._InstanceList = InstanceList

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        if params.get("InstanceList") is not None:
            self._InstanceList = []
            for item in params.get("InstanceList"):
                obj = InstanceList()
                obj._deserialize(item)
                self._InstanceList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeInstanceLogDetailRequest(AbstractModel):
    """DescribeInstanceLogDetail request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _TaskId: Task ID
        :type TaskId: str
        :param _CurRunDate: Data Timestamp
        :type CurRunDate: str
        :param _BrokerIp: Server Ip
        :type BrokerIp: str
        :param _OriginFileName: File Name
        :type OriginFileName: str
        :param _StartCount: Starting Row
        :type StartCount: int
        :param _LineCount: Number of Rows Per Query
        :type LineCount: int
        """
        self._ProjectId = None
        self._TaskId = None
        self._CurRunDate = None
        self._BrokerIp = None
        self._OriginFileName = None
        self._StartCount = None
        self._LineCount = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def CurRunDate(self):
        return self._CurRunDate

    @CurRunDate.setter
    def CurRunDate(self, CurRunDate):
        self._CurRunDate = CurRunDate

    @property
    def BrokerIp(self):
        return self._BrokerIp

    @BrokerIp.setter
    def BrokerIp(self, BrokerIp):
        self._BrokerIp = BrokerIp

    @property
    def OriginFileName(self):
        return self._OriginFileName

    @OriginFileName.setter
    def OriginFileName(self, OriginFileName):
        self._OriginFileName = OriginFileName

    @property
    def StartCount(self):
        return self._StartCount

    @StartCount.setter
    def StartCount(self, StartCount):
        self._StartCount = StartCount

    @property
    def LineCount(self):
        return self._LineCount

    @LineCount.setter
    def LineCount(self, LineCount):
        self._LineCount = LineCount


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TaskId = params.get("TaskId")
        self._CurRunDate = params.get("CurRunDate")
        self._BrokerIp = params.get("BrokerIp")
        self._OriginFileName = params.get("OriginFileName")
        self._StartCount = params.get("StartCount")
        self._LineCount = params.get("LineCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInstanceLogDetailResponse(AbstractModel):
    """DescribeInstanceLogDetail response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Log results
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: :class:`tencentcloud.wedata.v20210820.models.InstanceLogInfoOpsDto`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = InstanceLogInfoOpsDto()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeInstanceLogFileRequest(AbstractModel):
    """DescribeInstanceLogFile request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _TaskId: Task ID
        :type TaskId: str
        :param _CurRunDate: Instance data time
        :type CurRunDate: str
        :param _BrokerIp: Executor IP
        :type BrokerIp: str
        :param _OriginFileName: Log file name
        :type OriginFileName: str
        """
        self._ProjectId = None
        self._TaskId = None
        self._CurRunDate = None
        self._BrokerIp = None
        self._OriginFileName = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def CurRunDate(self):
        return self._CurRunDate

    @CurRunDate.setter
    def CurRunDate(self, CurRunDate):
        self._CurRunDate = CurRunDate

    @property
    def BrokerIp(self):
        return self._BrokerIp

    @BrokerIp.setter
    def BrokerIp(self, BrokerIp):
        self._BrokerIp = BrokerIp

    @property
    def OriginFileName(self):
        return self._OriginFileName

    @OriginFileName.setter
    def OriginFileName(self, OriginFileName):
        self._OriginFileName = OriginFileName


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TaskId = params.get("TaskId")
        self._CurRunDate = params.get("CurRunDate")
        self._BrokerIp = params.get("BrokerIp")
        self._OriginFileName = params.get("OriginFileName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInstanceLogFileResponse(AbstractModel):
    """DescribeInstanceLogFile response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Download File Details
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: :class:`tencentcloud.wedata.v20210820.models.InstanceDownloadLogInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = InstanceDownloadLogInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeInstanceLogListRequest(AbstractModel):
    """DescribeInstanceLogList request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID
        :type TaskId: str
        :param _CurRunDate: Data Timestamp
        :type CurRunDate: str
        """
        self._TaskId = None
        self._CurRunDate = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def CurRunDate(self):
        return self._CurRunDate

    @CurRunDate.setter
    def CurRunDate(self, CurRunDate):
        self._CurRunDate = CurRunDate


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._CurRunDate = params.get("CurRunDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInstanceLogListResponse(AbstractModel):
    """DescribeInstanceLogList response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Log list
        :type Data: str
        :param _InstanceLogList: Log listNote: This field may return null, indicating that no valid value can be obtained.
        :type InstanceLogList: list of InstanceLogList
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._InstanceLogList = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def InstanceLogList(self):
        return self._InstanceLogList

    @InstanceLogList.setter
    def InstanceLogList(self, InstanceLogList):
        self._InstanceLogList = InstanceLogList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        if params.get("InstanceLogList") is not None:
            self._InstanceLogList = []
            for item in params.get("InstanceLogList"):
                obj = InstanceLogList()
                obj._deserialize(item)
                self._InstanceLogList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeInstanceLogRequest(AbstractModel):
    """DescribeInstanceLog request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID
        :type TaskId: str
        :param _CurRunDate: Data Timestamp
        :type CurRunDate: str
        :param _BrokerIp: Server Ip
        :type BrokerIp: str
        :param _OriginFileName: File Name
        :type OriginFileName: str
        """
        self._TaskId = None
        self._CurRunDate = None
        self._BrokerIp = None
        self._OriginFileName = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def CurRunDate(self):
        return self._CurRunDate

    @CurRunDate.setter
    def CurRunDate(self, CurRunDate):
        self._CurRunDate = CurRunDate

    @property
    def BrokerIp(self):
        return self._BrokerIp

    @BrokerIp.setter
    def BrokerIp(self, BrokerIp):
        self._BrokerIp = BrokerIp

    @property
    def OriginFileName(self):
        return self._OriginFileName

    @OriginFileName.setter
    def OriginFileName(self, OriginFileName):
        self._OriginFileName = OriginFileName


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._CurRunDate = params.get("CurRunDate")
        self._BrokerIp = params.get("BrokerIp")
        self._OriginFileName = params.get("OriginFileName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInstanceLogResponse(AbstractModel):
    """DescribeInstanceLog response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Returned result
        :type Data: str
        :param _InstanceLogInfo: Return results
Note: This field may return null, indicating that no valid value can be obtained.
        :type InstanceLogInfo: :class:`tencentcloud.wedata.v20210820.models.IntegrationInstanceLog`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._InstanceLogInfo = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def InstanceLogInfo(self):
        return self._InstanceLogInfo

    @InstanceLogInfo.setter
    def InstanceLogInfo(self, InstanceLogInfo):
        self._InstanceLogInfo = InstanceLogInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        if params.get("InstanceLogInfo") is not None:
            self._InstanceLogInfo = IntegrationInstanceLog()
            self._InstanceLogInfo._deserialize(params.get("InstanceLogInfo"))
        self._RequestId = params.get("RequestId")


class DescribeIntegrationNodeRequest(AbstractModel):
    """DescribeIntegrationNode request structure.

    """

    def __init__(self):
        r"""
        :param _Id: Node ID
        :type Id: str
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _TaskType: Task Type, 201 for Real-time Task, 202 for Offline Task
        :type TaskType: int
        """
        self._Id = None
        self._ProjectId = None
        self._TaskType = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._ProjectId = params.get("ProjectId")
        self._TaskType = params.get("TaskType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIntegrationNodeResponse(AbstractModel):
    """DescribeIntegrationNode response structure.

    """

    def __init__(self):
        r"""
        :param _NodeInfo: Node information\nNote: This field may return null, indicating that no valid value can be obtained.
        :type NodeInfo: :class:`tencentcloud.wedata.v20210820.models.IntegrationNodeInfo`
        :param _SourceCheckFlag: Has the upstream node been modified? true Modified, needs to be prompted; false Not modified\nNote: This field may return null, indicating that no valid value can be obtained.
        :type SourceCheckFlag: bool
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NodeInfo = None
        self._SourceCheckFlag = None
        self._RequestId = None

    @property
    def NodeInfo(self):
        return self._NodeInfo

    @NodeInfo.setter
    def NodeInfo(self, NodeInfo):
        self._NodeInfo = NodeInfo

    @property
    def SourceCheckFlag(self):
        return self._SourceCheckFlag

    @SourceCheckFlag.setter
    def SourceCheckFlag(self, SourceCheckFlag):
        self._SourceCheckFlag = SourceCheckFlag

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NodeInfo") is not None:
            self._NodeInfo = IntegrationNodeInfo()
            self._NodeInfo._deserialize(params.get("NodeInfo"))
        self._SourceCheckFlag = params.get("SourceCheckFlag")
        self._RequestId = params.get("RequestId")


class DescribeIntegrationStatisticsInstanceTrendRequest(AbstractModel):
    """DescribeIntegrationStatisticsInstanceTrend request structure.

    """

    def __init__(self):
        r"""
        :param _TaskType: Task Type (Real-time: 201, Offline: 202)
        :type TaskType: int
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _QueryDate: Query Date
        :type QueryDate: str
        :param _ExecutorGroupId: Resource Group ID
        :type ExecutorGroupId: str
        """
        self._TaskType = None
        self._ProjectId = None
        self._QueryDate = None
        self._ExecutorGroupId = None

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def QueryDate(self):
        return self._QueryDate

    @QueryDate.setter
    def QueryDate(self, QueryDate):
        self._QueryDate = QueryDate

    @property
    def ExecutorGroupId(self):
        return self._ExecutorGroupId

    @ExecutorGroupId.setter
    def ExecutorGroupId(self, ExecutorGroupId):
        self._ExecutorGroupId = ExecutorGroupId


    def _deserialize(self, params):
        self._TaskType = params.get("TaskType")
        self._ProjectId = params.get("ProjectId")
        self._QueryDate = params.get("QueryDate")
        self._ExecutorGroupId = params.get("ExecutorGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIntegrationStatisticsInstanceTrendResponse(AbstractModel):
    """DescribeIntegrationStatisticsInstanceTrend response structure.

    """

    def __init__(self):
        r"""
        :param _TrendsData: Statistical ResultsNote: This field may return null, indicating that no valid value can be obtained.
        :type TrendsData: list of IntegrationStatisticsTrendResult
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TrendsData = None
        self._RequestId = None

    @property
    def TrendsData(self):
        return self._TrendsData

    @TrendsData.setter
    def TrendsData(self, TrendsData):
        self._TrendsData = TrendsData

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TrendsData") is not None:
            self._TrendsData = []
            for item in params.get("TrendsData"):
                obj = IntegrationStatisticsTrendResult()
                obj._deserialize(item)
                self._TrendsData.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeIntegrationStatisticsRecordsTrendRequest(AbstractModel):
    """DescribeIntegrationStatisticsRecordsTrend request structure.

    """

    def __init__(self):
        r"""
        :param _TaskType: Task Type (Real-time: 201, Offline: 202)
        :type TaskType: int
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _QueryDate: Query Date
        :type QueryDate: str
        """
        self._TaskType = None
        self._ProjectId = None
        self._QueryDate = None

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def QueryDate(self):
        return self._QueryDate

    @QueryDate.setter
    def QueryDate(self, QueryDate):
        self._QueryDate = QueryDate


    def _deserialize(self, params):
        self._TaskType = params.get("TaskType")
        self._ProjectId = params.get("ProjectId")
        self._QueryDate = params.get("QueryDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIntegrationStatisticsRecordsTrendResponse(AbstractModel):
    """DescribeIntegrationStatisticsRecordsTrend response structure.

    """

    def __init__(self):
        r"""
        :param _TrendsData: Statistical ResultsNote: This field may return null, indicating that no valid value can be obtained.
        :type TrendsData: list of IntegrationStatisticsTrendResult
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TrendsData = None
        self._RequestId = None

    @property
    def TrendsData(self):
        return self._TrendsData

    @TrendsData.setter
    def TrendsData(self, TrendsData):
        self._TrendsData = TrendsData

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TrendsData") is not None:
            self._TrendsData = []
            for item in params.get("TrendsData"):
                obj = IntegrationStatisticsTrendResult()
                obj._deserialize(item)
                self._TrendsData.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeIntegrationStatisticsRequest(AbstractModel):
    """DescribeIntegrationStatistics request structure.

    """

    def __init__(self):
        r"""
        :param _TaskType: Task Type (Real-time: 201, Offline: 202)
        :type TaskType: int
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _QueryDate: Query Date
        :type QueryDate: str
        """
        self._TaskType = None
        self._ProjectId = None
        self._QueryDate = None

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def QueryDate(self):
        return self._QueryDate

    @QueryDate.setter
    def QueryDate(self, QueryDate):
        self._QueryDate = QueryDate


    def _deserialize(self, params):
        self._TaskType = params.get("TaskType")
        self._ProjectId = params.get("ProjectId")
        self._QueryDate = params.get("QueryDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIntegrationStatisticsResponse(AbstractModel):
    """DescribeIntegrationStatistics response structure.

    """

    def __init__(self):
        r"""
        :param _TotalTask: Total Tasks
Note: This field may return null, indicating that no valid value can be obtained.
        :type TotalTask: int
        :param _ProdTask: Number of Production Tasks
Note: This field may return null, indicating that no valid value can be obtained.
        :type ProdTask: int
        :param _DevTask: Number of Development Tasks
Note: This field may return null, indicating that no valid value can be obtained.
        :type DevTask: int
        :param _TotalReadRecords: Total Number of Reads
Note: This field may return null, indicating that no valid value can be obtained.
        :type TotalReadRecords: int
        :param _TotalWriteRecords: Total Number of Writes
Note: This field may return null, indicating that no valid value can be obtained.
        :type TotalWriteRecords: int
        :param _TotalErrorRecords: Total Number of Dirty Data Entries
Note: This field may return null, indicating that no valid value can be obtained.
        :type TotalErrorRecords: int
        :param _TotalAlarmEvent: Total Number of Alarm Events
Note: This field may return null, indicating that no valid value can be obtained.
        :type TotalAlarmEvent: int
        :param _IncreaseReadRecords: Daily Increase in Reads
Note: This field may return null, indicating that no valid value can be obtained.
        :type IncreaseReadRecords: int
        :param _IncreaseWriteRecords: Daily Increase in Writes
Note: This field may return null, indicating that no valid value can be obtained.
        :type IncreaseWriteRecords: int
        :param _IncreaseErrorRecords: Daily Increase in Dirty Data Entries
Note: This field may return null, indicating that no valid value can be obtained.
        :type IncreaseErrorRecords: int
        :param _IncreaseAlarmEvent: Daily Increase in Alarm Events
Note: This field may return null, indicating that no valid value can be obtained.
        :type IncreaseAlarmEvent: int
        :param _AlarmEvent: Alarm Event Statistics
Note: This field may return null, indicating that no valid value can be obtained.
        :type AlarmEvent: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalTask = None
        self._ProdTask = None
        self._DevTask = None
        self._TotalReadRecords = None
        self._TotalWriteRecords = None
        self._TotalErrorRecords = None
        self._TotalAlarmEvent = None
        self._IncreaseReadRecords = None
        self._IncreaseWriteRecords = None
        self._IncreaseErrorRecords = None
        self._IncreaseAlarmEvent = None
        self._AlarmEvent = None
        self._RequestId = None

    @property
    def TotalTask(self):
        return self._TotalTask

    @TotalTask.setter
    def TotalTask(self, TotalTask):
        self._TotalTask = TotalTask

    @property
    def ProdTask(self):
        return self._ProdTask

    @ProdTask.setter
    def ProdTask(self, ProdTask):
        self._ProdTask = ProdTask

    @property
    def DevTask(self):
        return self._DevTask

    @DevTask.setter
    def DevTask(self, DevTask):
        self._DevTask = DevTask

    @property
    def TotalReadRecords(self):
        return self._TotalReadRecords

    @TotalReadRecords.setter
    def TotalReadRecords(self, TotalReadRecords):
        self._TotalReadRecords = TotalReadRecords

    @property
    def TotalWriteRecords(self):
        return self._TotalWriteRecords

    @TotalWriteRecords.setter
    def TotalWriteRecords(self, TotalWriteRecords):
        self._TotalWriteRecords = TotalWriteRecords

    @property
    def TotalErrorRecords(self):
        return self._TotalErrorRecords

    @TotalErrorRecords.setter
    def TotalErrorRecords(self, TotalErrorRecords):
        self._TotalErrorRecords = TotalErrorRecords

    @property
    def TotalAlarmEvent(self):
        return self._TotalAlarmEvent

    @TotalAlarmEvent.setter
    def TotalAlarmEvent(self, TotalAlarmEvent):
        self._TotalAlarmEvent = TotalAlarmEvent

    @property
    def IncreaseReadRecords(self):
        return self._IncreaseReadRecords

    @IncreaseReadRecords.setter
    def IncreaseReadRecords(self, IncreaseReadRecords):
        self._IncreaseReadRecords = IncreaseReadRecords

    @property
    def IncreaseWriteRecords(self):
        return self._IncreaseWriteRecords

    @IncreaseWriteRecords.setter
    def IncreaseWriteRecords(self, IncreaseWriteRecords):
        self._IncreaseWriteRecords = IncreaseWriteRecords

    @property
    def IncreaseErrorRecords(self):
        return self._IncreaseErrorRecords

    @IncreaseErrorRecords.setter
    def IncreaseErrorRecords(self, IncreaseErrorRecords):
        self._IncreaseErrorRecords = IncreaseErrorRecords

    @property
    def IncreaseAlarmEvent(self):
        return self._IncreaseAlarmEvent

    @IncreaseAlarmEvent.setter
    def IncreaseAlarmEvent(self, IncreaseAlarmEvent):
        self._IncreaseAlarmEvent = IncreaseAlarmEvent

    @property
    def AlarmEvent(self):
        return self._AlarmEvent

    @AlarmEvent.setter
    def AlarmEvent(self, AlarmEvent):
        self._AlarmEvent = AlarmEvent

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalTask = params.get("TotalTask")
        self._ProdTask = params.get("ProdTask")
        self._DevTask = params.get("DevTask")
        self._TotalReadRecords = params.get("TotalReadRecords")
        self._TotalWriteRecords = params.get("TotalWriteRecords")
        self._TotalErrorRecords = params.get("TotalErrorRecords")
        self._TotalAlarmEvent = params.get("TotalAlarmEvent")
        self._IncreaseReadRecords = params.get("IncreaseReadRecords")
        self._IncreaseWriteRecords = params.get("IncreaseWriteRecords")
        self._IncreaseErrorRecords = params.get("IncreaseErrorRecords")
        self._IncreaseAlarmEvent = params.get("IncreaseAlarmEvent")
        self._AlarmEvent = params.get("AlarmEvent")
        self._RequestId = params.get("RequestId")


class DescribeIntegrationStatisticsTaskStatusRequest(AbstractModel):
    """DescribeIntegrationStatisticsTaskStatus request structure.

    """

    def __init__(self):
        r"""
        :param _TaskType: Task Type (Real-time: 201, Offline: 202)
        :type TaskType: int
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _QueryDate: Query Date
        :type QueryDate: str
        :param _ExecutorGroupId: Resource Group ID
        :type ExecutorGroupId: str
        """
        self._TaskType = None
        self._ProjectId = None
        self._QueryDate = None
        self._ExecutorGroupId = None

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def QueryDate(self):
        return self._QueryDate

    @QueryDate.setter
    def QueryDate(self, QueryDate):
        self._QueryDate = QueryDate

    @property
    def ExecutorGroupId(self):
        return self._ExecutorGroupId

    @ExecutorGroupId.setter
    def ExecutorGroupId(self, ExecutorGroupId):
        self._ExecutorGroupId = ExecutorGroupId


    def _deserialize(self, params):
        self._TaskType = params.get("TaskType")
        self._ProjectId = params.get("ProjectId")
        self._QueryDate = params.get("QueryDate")
        self._ExecutorGroupId = params.get("ExecutorGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIntegrationStatisticsTaskStatusResponse(AbstractModel):
    """DescribeIntegrationStatisticsTaskStatus response structure.

    """

    def __init__(self):
        r"""
        :param _StatusData: Statistical ResultsNote: This field may return null, indicating that no valid value can be obtained.
        :type StatusData: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._StatusData = None
        self._RequestId = None

    @property
    def StatusData(self):
        return self._StatusData

    @StatusData.setter
    def StatusData(self, StatusData):
        self._StatusData = StatusData

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._StatusData = params.get("StatusData")
        self._RequestId = params.get("RequestId")


class DescribeIntegrationStatisticsTaskStatusTrendRequest(AbstractModel):
    """DescribeIntegrationStatisticsTaskStatusTrend request structure.

    """

    def __init__(self):
        r"""
        :param _TaskType: Task Type (Real-time:201, Offline:202)
        :type TaskType: int
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _QueryDate: Query Date
        :type QueryDate: str
        :param _ExecutorGroupId: Resource Group ID
        :type ExecutorGroupId: str
        """
        self._TaskType = None
        self._ProjectId = None
        self._QueryDate = None
        self._ExecutorGroupId = None

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def QueryDate(self):
        return self._QueryDate

    @QueryDate.setter
    def QueryDate(self, QueryDate):
        self._QueryDate = QueryDate

    @property
    def ExecutorGroupId(self):
        return self._ExecutorGroupId

    @ExecutorGroupId.setter
    def ExecutorGroupId(self, ExecutorGroupId):
        self._ExecutorGroupId = ExecutorGroupId


    def _deserialize(self, params):
        self._TaskType = params.get("TaskType")
        self._ProjectId = params.get("ProjectId")
        self._QueryDate = params.get("QueryDate")
        self._ExecutorGroupId = params.get("ExecutorGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIntegrationStatisticsTaskStatusTrendResponse(AbstractModel):
    """DescribeIntegrationStatisticsTaskStatusTrend response structure.

    """

    def __init__(self):
        r"""
        :param _TrendsData: Statistical Results
Note: This field may return null, indicating that no valid value can be obtained.
        :type TrendsData: list of IntegrationStatisticsTrendResult
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TrendsData = None
        self._RequestId = None

    @property
    def TrendsData(self):
        return self._TrendsData

    @TrendsData.setter
    def TrendsData(self, TrendsData):
        self._TrendsData = TrendsData

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TrendsData") is not None:
            self._TrendsData = []
            for item in params.get("TrendsData"):
                obj = IntegrationStatisticsTrendResult()
                obj._deserialize(item)
                self._TrendsData.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeIntegrationTaskRequest(AbstractModel):
    """DescribeIntegrationTask request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID
        :type TaskId: str
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _TaskType: Task Type, 201: Real-time Integration Task, 202: Offline Integration Task, default value is 201 for real-time task if not specified
        :type TaskType: int
        :param _InstanceVersion: Submit version number
        :type InstanceVersion: int
        """
        self._TaskId = None
        self._ProjectId = None
        self._TaskType = None
        self._InstanceVersion = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def InstanceVersion(self):
        return self._InstanceVersion

    @InstanceVersion.setter
    def InstanceVersion(self, InstanceVersion):
        self._InstanceVersion = InstanceVersion


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ProjectId = params.get("ProjectId")
        self._TaskType = params.get("TaskType")
        self._InstanceVersion = params.get("InstanceVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIntegrationTaskResponse(AbstractModel):
    """DescribeIntegrationTask response structure.

    """

    def __init__(self):
        r"""
        :param _TaskInfo: Task InformationNote: This field may return null, indicating that no valid value can be obtained.
        :type TaskInfo: :class:`tencentcloud.wedata.v20210820.models.IntegrationTaskInfo`
        :param _AgentStatus: Collector statistics
Note: This field may return null, indicating that no valid value can be obtained.
        :type AgentStatus: :class:`tencentcloud.wedata.v20210820.models.AgentStatus`
        :param _TaskVersion: Task version information
Note: This field may return null, indicating that no valid value can be obtained.
        :type TaskVersion: :class:`tencentcloud.wedata.v20210820.models.TaskVersionInstance`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskInfo = None
        self._AgentStatus = None
        self._TaskVersion = None
        self._RequestId = None

    @property
    def TaskInfo(self):
        return self._TaskInfo

    @TaskInfo.setter
    def TaskInfo(self, TaskInfo):
        self._TaskInfo = TaskInfo

    @property
    def AgentStatus(self):
        return self._AgentStatus

    @AgentStatus.setter
    def AgentStatus(self, AgentStatus):
        self._AgentStatus = AgentStatus

    @property
    def TaskVersion(self):
        return self._TaskVersion

    @TaskVersion.setter
    def TaskVersion(self, TaskVersion):
        self._TaskVersion = TaskVersion

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TaskInfo") is not None:
            self._TaskInfo = IntegrationTaskInfo()
            self._TaskInfo._deserialize(params.get("TaskInfo"))
        if params.get("AgentStatus") is not None:
            self._AgentStatus = AgentStatus()
            self._AgentStatus._deserialize(params.get("AgentStatus"))
        if params.get("TaskVersion") is not None:
            self._TaskVersion = TaskVersionInstance()
            self._TaskVersion._deserialize(params.get("TaskVersion"))
        self._RequestId = params.get("RequestId")


class DescribeIntegrationTasksRequest(AbstractModel):
    """DescribeIntegrationTasks request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _PageNumber: Page n of Pagination
        :type PageNumber: int
        :param _PageSize: Page size
        :type PageSize: int
        :param _Filters: Query Filter
        :type Filters: list of Filter
        :param _OrderFields: Sorting Field Information
        :type OrderFields: list of OrderField
        :param _StartTime: Start Time
        :type StartTime: str
        :param _EndTime: End time
        :type EndTime: str
        :param _TaskType: 201. Real-time synchronization, 202. Offline Synchronization Default is real-time
        :type TaskType: int
        """
        self._ProjectId = None
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None
        self._OrderFields = None
        self._StartTime = None
        self._EndTime = None
        self._TaskType = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._TaskType = params.get("TaskType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIntegrationTasksResponse(AbstractModel):
    """DescribeIntegrationTasks response structure.

    """

    def __init__(self):
        r"""
        :param _TaskInfoSet: Task ListNote: This field may return null, indicating that no valid value can be obtained.
        :type TaskInfoSet: list of IntegrationTaskInfo
        :param _TotalCount: Total Number of Tasks
Note: This field may return null, indicating that no valid value can be obtained.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskInfoSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def TaskInfoSet(self):
        return self._TaskInfoSet

    @TaskInfoSet.setter
    def TaskInfoSet(self, TaskInfoSet):
        self._TaskInfoSet = TaskInfoSet

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TaskInfoSet") is not None:
            self._TaskInfoSet = []
            for item in params.get("TaskInfoSet"):
                obj = IntegrationTaskInfo()
                obj._deserialize(item)
                self._TaskInfoSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeIntegrationVersionNodesInfoRequest(AbstractModel):
    """DescribeIntegrationVersionNodesInfo request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID
        :type TaskId: str
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _TaskVersionPath: The selected version's storage path for the task:
The value of Base64.encode($region | $bucket | $ftp.file.name) under TaskInfo.TaskExt.Properties returned by DescribeDsTaskVersionList or DescribeDsTaskVersionInfo
        :type TaskVersionPath: str
        :param _TaskVersion: The selected version ID for the task:
The value of VersionId returned by DescribeDsTaskVersionList or DescribeDsTaskVersionInfo
        :type TaskVersion: str
        """
        self._TaskId = None
        self._ProjectId = None
        self._TaskVersionPath = None
        self._TaskVersion = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskVersionPath(self):
        return self._TaskVersionPath

    @TaskVersionPath.setter
    def TaskVersionPath(self, TaskVersionPath):
        self._TaskVersionPath = TaskVersionPath

    @property
    def TaskVersion(self):
        return self._TaskVersion

    @TaskVersion.setter
    def TaskVersion(self, TaskVersion):
        self._TaskVersion = TaskVersion


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ProjectId = params.get("ProjectId")
        self._TaskVersionPath = params.get("TaskVersionPath")
        self._TaskVersion = params.get("TaskVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIntegrationVersionNodesInfoResponse(AbstractModel):
    """DescribeIntegrationVersionNodesInfo response structure.

    """

    def __init__(self):
        r"""
        :param _Nodes: Task Node Information
Note: This field may return null, indicating that no valid value can be obtained.
        :type Nodes: list of IntegrationNodeInfo
        :param _Mappings: Task Mapping Information
Note: This field may return null, indicating that no valid value can be obtained.
        :type Mappings: list of IntegrationNodeMapping
        :param _TaskId: Task ID
        :type TaskId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Nodes = None
        self._Mappings = None
        self._TaskId = None
        self._RequestId = None

    @property
    def Nodes(self):
        return self._Nodes

    @Nodes.setter
    def Nodes(self, Nodes):
        self._Nodes = Nodes

    @property
    def Mappings(self):
        return self._Mappings

    @Mappings.setter
    def Mappings(self, Mappings):
        self._Mappings = Mappings

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Nodes") is not None:
            self._Nodes = []
            for item in params.get("Nodes"):
                obj = IntegrationNodeInfo()
                obj._deserialize(item)
                self._Nodes.append(obj)
        if params.get("Mappings") is not None:
            self._Mappings = []
            for item in params.get("Mappings"):
                obj = IntegrationNodeMapping()
                obj._deserialize(item)
                self._Mappings.append(obj)
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class DescribeOfflineTaskTokenRequest(AbstractModel):
    """DescribeOfflineTaskToken request structure.

    """


class DescribeOfflineTaskTokenResponse(AbstractModel):
    """DescribeOfflineTaskToken response structure.

    """

    def __init__(self):
        r"""
        :param _Token: Long Connection Temporary Token
        :type Token: str
        :param _Data: Long Connection Temporary Token. Same meaning as Token, prioritize Data, if Data is null, then use Token.
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Token = None
        self._Data = None
        self._RequestId = None

    @property
    def Token(self):
        return self._Token

    @Token.setter
    def Token(self, Token):
        self._Token = Token

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Token = params.get("Token")
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DescribeOperateOpsTasksRequest(AbstractModel):
    """DescribeOperateOpsTasks request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _FolderIdList: Folder ID, multiple folders separated by commas
        :type FolderIdList: str
        :param _WorkFlowIdList: Workflow ID, multiple Workflow IDs separated by English commas
        :type WorkFlowIdList: str
        :param _WorkFlowNameList: Workflow name, multiple Workflow names separated by English commas
        :type WorkFlowNameList: str
        :param _TaskNameList: Task Name, multiple Task Names separated by English commas
        :type TaskNameList: str
        :param _TaskIdList: Task ID, multiple Task IDs separated by English commas
        :type TaskIdList: str
        :param _PageNumber: Page Number
        :type PageNumber: str
        :param _PageSize: Page size
        :type PageSize: str
        :param _SortItem: Sort Fields, supported fields are FirstSubmitTime and FirstRunTime, indicating the most recent submission and the first execution event
        :type SortItem: str
        :param _SortType: Sort Type. Two values DESC,ASC
        :type SortType: str
        :param _InChargeList: Person in Charge, multiple Persons in Charge separated by English commas
        :type InChargeList: str
        :param _TaskTypeIdList: Task Type ID String, multiple Task Type IDs separated by English commas
        :type TaskTypeIdList: str
        :param _StatusList: Task Status String, multiple Task Statuses separated by English commas
        :type StatusList: str
        :param _TaskCycleUnitList: Task Cycle Type String, multiple Task Cycles separated by English commas
        :type TaskCycleUnitList: str
        :param _ProductNameList: Task Belonging Product Type
        :type ProductNameList: str
        :param _SourceServiceId: Data Source ID or (only for offline sync tasks) Source Data Source ID
        :type SourceServiceId: str
        :param _SourceServiceType: Data Source Type or (only for offline sync tasks) Source Data Source Type
        :type SourceServiceType: str
        :param _TargetServiceId: (Only for offline sync tasks) Target Data Source ID
        :type TargetServiceId: str
        :param _TargetServiceType: (Only for offline sync tasks) Target Data Source Type
        :type TargetServiceType: str
        :param _AlarmType: Alarm Type, multiple types separated by commas
        :type AlarmType: str
        :param _ExecutorGroupIdList: Resource Group ID, multiple Resource Group IDs separated by English commas
        :type ExecutorGroupIdList: str
        :param _TaskTags: Task tag
        :type TaskTags: list of TaskTag
        :param _KeyWord: Query Keyword
        :type KeyWord: str
        :param _InitStrategy: Instance Generation Method
        :type InitStrategy: str
        :param _RequestResourceTypes: Additional Requested Resource Types
        :type RequestResourceTypes: list of str
        """
        self._ProjectId = None
        self._FolderIdList = None
        self._WorkFlowIdList = None
        self._WorkFlowNameList = None
        self._TaskNameList = None
        self._TaskIdList = None
        self._PageNumber = None
        self._PageSize = None
        self._SortItem = None
        self._SortType = None
        self._InChargeList = None
        self._TaskTypeIdList = None
        self._StatusList = None
        self._TaskCycleUnitList = None
        self._ProductNameList = None
        self._SourceServiceId = None
        self._SourceServiceType = None
        self._TargetServiceId = None
        self._TargetServiceType = None
        self._AlarmType = None
        self._ExecutorGroupIdList = None
        self._TaskTags = None
        self._KeyWord = None
        self._InitStrategy = None
        self._RequestResourceTypes = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def FolderIdList(self):
        return self._FolderIdList

    @FolderIdList.setter
    def FolderIdList(self, FolderIdList):
        self._FolderIdList = FolderIdList

    @property
    def WorkFlowIdList(self):
        return self._WorkFlowIdList

    @WorkFlowIdList.setter
    def WorkFlowIdList(self, WorkFlowIdList):
        self._WorkFlowIdList = WorkFlowIdList

    @property
    def WorkFlowNameList(self):
        return self._WorkFlowNameList

    @WorkFlowNameList.setter
    def WorkFlowNameList(self, WorkFlowNameList):
        self._WorkFlowNameList = WorkFlowNameList

    @property
    def TaskNameList(self):
        return self._TaskNameList

    @TaskNameList.setter
    def TaskNameList(self, TaskNameList):
        self._TaskNameList = TaskNameList

    @property
    def TaskIdList(self):
        return self._TaskIdList

    @TaskIdList.setter
    def TaskIdList(self, TaskIdList):
        self._TaskIdList = TaskIdList

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def SortItem(self):
        return self._SortItem

    @SortItem.setter
    def SortItem(self, SortItem):
        self._SortItem = SortItem

    @property
    def SortType(self):
        return self._SortType

    @SortType.setter
    def SortType(self, SortType):
        self._SortType = SortType

    @property
    def InChargeList(self):
        return self._InChargeList

    @InChargeList.setter
    def InChargeList(self, InChargeList):
        self._InChargeList = InChargeList

    @property
    def TaskTypeIdList(self):
        return self._TaskTypeIdList

    @TaskTypeIdList.setter
    def TaskTypeIdList(self, TaskTypeIdList):
        self._TaskTypeIdList = TaskTypeIdList

    @property
    def StatusList(self):
        return self._StatusList

    @StatusList.setter
    def StatusList(self, StatusList):
        self._StatusList = StatusList

    @property
    def TaskCycleUnitList(self):
        return self._TaskCycleUnitList

    @TaskCycleUnitList.setter
    def TaskCycleUnitList(self, TaskCycleUnitList):
        self._TaskCycleUnitList = TaskCycleUnitList

    @property
    def ProductNameList(self):
        return self._ProductNameList

    @ProductNameList.setter
    def ProductNameList(self, ProductNameList):
        self._ProductNameList = ProductNameList

    @property
    def SourceServiceId(self):
        return self._SourceServiceId

    @SourceServiceId.setter
    def SourceServiceId(self, SourceServiceId):
        self._SourceServiceId = SourceServiceId

    @property
    def SourceServiceType(self):
        return self._SourceServiceType

    @SourceServiceType.setter
    def SourceServiceType(self, SourceServiceType):
        self._SourceServiceType = SourceServiceType

    @property
    def TargetServiceId(self):
        return self._TargetServiceId

    @TargetServiceId.setter
    def TargetServiceId(self, TargetServiceId):
        self._TargetServiceId = TargetServiceId

    @property
    def TargetServiceType(self):
        return self._TargetServiceType

    @TargetServiceType.setter
    def TargetServiceType(self, TargetServiceType):
        self._TargetServiceType = TargetServiceType

    @property
    def AlarmType(self):
        return self._AlarmType

    @AlarmType.setter
    def AlarmType(self, AlarmType):
        self._AlarmType = AlarmType

    @property
    def ExecutorGroupIdList(self):
        return self._ExecutorGroupIdList

    @ExecutorGroupIdList.setter
    def ExecutorGroupIdList(self, ExecutorGroupIdList):
        self._ExecutorGroupIdList = ExecutorGroupIdList

    @property
    def TaskTags(self):
        return self._TaskTags

    @TaskTags.setter
    def TaskTags(self, TaskTags):
        self._TaskTags = TaskTags

    @property
    def KeyWord(self):
        return self._KeyWord

    @KeyWord.setter
    def KeyWord(self, KeyWord):
        self._KeyWord = KeyWord

    @property
    def InitStrategy(self):
        return self._InitStrategy

    @InitStrategy.setter
    def InitStrategy(self, InitStrategy):
        self._InitStrategy = InitStrategy

    @property
    def RequestResourceTypes(self):
        return self._RequestResourceTypes

    @RequestResourceTypes.setter
    def RequestResourceTypes(self, RequestResourceTypes):
        self._RequestResourceTypes = RequestResourceTypes


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._FolderIdList = params.get("FolderIdList")
        self._WorkFlowIdList = params.get("WorkFlowIdList")
        self._WorkFlowNameList = params.get("WorkFlowNameList")
        self._TaskNameList = params.get("TaskNameList")
        self._TaskIdList = params.get("TaskIdList")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        self._SortItem = params.get("SortItem")
        self._SortType = params.get("SortType")
        self._InChargeList = params.get("InChargeList")
        self._TaskTypeIdList = params.get("TaskTypeIdList")
        self._StatusList = params.get("StatusList")
        self._TaskCycleUnitList = params.get("TaskCycleUnitList")
        self._ProductNameList = params.get("ProductNameList")
        self._SourceServiceId = params.get("SourceServiceId")
        self._SourceServiceType = params.get("SourceServiceType")
        self._TargetServiceId = params.get("TargetServiceId")
        self._TargetServiceType = params.get("TargetServiceType")
        self._AlarmType = params.get("AlarmType")
        self._ExecutorGroupIdList = params.get("ExecutorGroupIdList")
        if params.get("TaskTags") is not None:
            self._TaskTags = []
            for item in params.get("TaskTags"):
                obj = TaskTag()
                obj._deserialize(item)
                self._TaskTags.append(obj)
        self._KeyWord = params.get("KeyWord")
        self._InitStrategy = params.get("InitStrategy")
        self._RequestResourceTypes = params.get("RequestResourceTypes")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOperateOpsTasksResponse(AbstractModel):
    """DescribeOperateOpsTasks response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Task List Information
        :type Data: :class:`tencentcloud.wedata.v20210820.models.OpsTaskInfoPage`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = OpsTaskInfoPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeOpsInstanceLogListRequest(AbstractModel):
    """DescribeOpsInstanceLogList request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID
        :type TaskId: str
        :param _CurRunDate: Data Timestamp
        :type CurRunDate: str
        """
        self._TaskId = None
        self._CurRunDate = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def CurRunDate(self):
        return self._CurRunDate

    @CurRunDate.setter
    def CurRunDate(self, CurRunDate):
        self._CurRunDate = CurRunDate


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._CurRunDate = params.get("CurRunDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOpsInstanceLogListResponse(AbstractModel):
    """DescribeOpsInstanceLogList response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Instance Log List
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: list of InstanceLogInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = InstanceLogInfo()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeOpsMakePlanInstancesRequest(AbstractModel):
    """DescribeOpsMakePlanInstances request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _PlanId: Supplemental Plan ID
        :type PlanId: str
        :param _TaskId: Supplementary Task ID
        :type TaskId: str
        :param _PageNumber: Page number, default value 1
        :type PageNumber: int
        :param _PageSize: Page size, default value 10
        :type PageSize: int
        """
        self._ProjectId = None
        self._PlanId = None
        self._TaskId = None
        self._PageNumber = None
        self._PageSize = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PlanId(self):
        return self._PlanId

    @PlanId.setter
    def PlanId(self, PlanId):
        self._PlanId = PlanId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._PlanId = params.get("PlanId")
        self._TaskId = params.get("TaskId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOpsMakePlanInstancesResponse(AbstractModel):
    """DescribeOpsMakePlanInstances response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Supplemental plan instance paged query results
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: :class:`tencentcloud.wedata.v20210820.models.MakePlanInstanceOpsDtoCollection`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = MakePlanInstanceOpsDtoCollection()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeOpsMakePlanTasksRequest(AbstractModel):
    """DescribeOpsMakePlanTasks request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _PlanId: Supplemental Plan ID
        :type PlanId: str
        :param _PageNumber: Page number, default value 1
        :type PageNumber: int
        :param _PageSize: Page size, default value 10
        :type PageSize: int
        """
        self._ProjectId = None
        self._PlanId = None
        self._PageNumber = None
        self._PageSize = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PlanId(self):
        return self._PlanId

    @PlanId.setter
    def PlanId(self, PlanId):
        self._PlanId = PlanId

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._PlanId = params.get("PlanId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOpsMakePlanTasksResponse(AbstractModel):
    """DescribeOpsMakePlanTasks response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Supplementary plan task pagination query results
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: :class:`tencentcloud.wedata.v20210820.models.MakePlanTaskOpsDtoCollection`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = MakePlanTaskOpsDtoCollection()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeOpsMakePlansRequest(AbstractModel):
    """DescribeOpsMakePlans request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _PageNumber: Pagination number, default value: 1
        :type PageNumber: int
        :param _PageSize: Page size, default value 10
        :type PageSize: int
        :param _PlanId: Supplemental Plan ID
        :type PlanId: str
        :param _PlanName: Supplemental Plan Name
        :type PlanName: str
        :param _TaskName: Supplementary Task Name
        :type TaskName: str
        :param _TaskId: Supplementary Task ID
        :type TaskId: str
        :param _Creator: Supplementary Plan Creator
        :type Creator: str
        :param _MinCreateTime: Minimum Creation Time of Supplementary Plan
        :type MinCreateTime: str
        :param _MaxCreateTime: Maximum Creation Time of Supplementary Plan
        :type MaxCreateTime: str
        """
        self._ProjectId = None
        self._PageNumber = None
        self._PageSize = None
        self._PlanId = None
        self._PlanName = None
        self._TaskName = None
        self._TaskId = None
        self._Creator = None
        self._MinCreateTime = None
        self._MaxCreateTime = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def PlanId(self):
        return self._PlanId

    @PlanId.setter
    def PlanId(self, PlanId):
        self._PlanId = PlanId

    @property
    def PlanName(self):
        return self._PlanName

    @PlanName.setter
    def PlanName(self, PlanName):
        self._PlanName = PlanName

    @property
    def TaskName(self):
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Creator(self):
        return self._Creator

    @Creator.setter
    def Creator(self, Creator):
        self._Creator = Creator

    @property
    def MinCreateTime(self):
        return self._MinCreateTime

    @MinCreateTime.setter
    def MinCreateTime(self, MinCreateTime):
        self._MinCreateTime = MinCreateTime

    @property
    def MaxCreateTime(self):
        return self._MaxCreateTime

    @MaxCreateTime.setter
    def MaxCreateTime(self, MaxCreateTime):
        self._MaxCreateTime = MaxCreateTime


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        self._PlanId = params.get("PlanId")
        self._PlanName = params.get("PlanName")
        self._TaskName = params.get("TaskName")
        self._TaskId = params.get("TaskId")
        self._Creator = params.get("Creator")
        self._MinCreateTime = params.get("MinCreateTime")
        self._MaxCreateTime = params.get("MaxCreateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOpsMakePlansResponse(AbstractModel):
    """DescribeOpsMakePlans response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Supplemental Plan Pagination Query Results
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: :class:`tencentcloud.wedata.v20210820.models.MakePlanOpsDtoCollection`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = MakePlanOpsDtoCollection()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeOpsWorkflowsRequest(AbstractModel):
    """DescribeOpsWorkflows request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _ProductNameList: Task Product Type Name List, separated by ','
        :type ProductNameList: str
        :param _FolderIdList: File ID list, separated by ','
        :type FolderIdList: str
        :param _WorkFlowIdList: Workflow ID, separated by ','
        :type WorkFlowIdList: str
        :param _WorkFlowNameList: Workflow Name List, separated by ','
        :type WorkFlowNameList: str
        :param _TaskNameList: Task Name List, separated by ','
        :type TaskNameList: str
        :param _TaskIdList: Task ID list, separated by ','
        :type TaskIdList: str
        :param _StatusList: Status List, separated by ','
        :type StatusList: str
        :param _InChargeList: Person in Charge List, separated by ','
        :type InChargeList: str
        :param _PageNumber: Page number
        :type PageNumber: int
        :param _PageSize: Page size
        :type PageSize: int
        :param _SortItem: Sorting Item
        :type SortItem: str
        :param _SortType: Sort Method, DESC or ASC
        :type SortType: str
        """
        self._ProjectId = None
        self._ProductNameList = None
        self._FolderIdList = None
        self._WorkFlowIdList = None
        self._WorkFlowNameList = None
        self._TaskNameList = None
        self._TaskIdList = None
        self._StatusList = None
        self._InChargeList = None
        self._PageNumber = None
        self._PageSize = None
        self._SortItem = None
        self._SortType = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ProductNameList(self):
        return self._ProductNameList

    @ProductNameList.setter
    def ProductNameList(self, ProductNameList):
        self._ProductNameList = ProductNameList

    @property
    def FolderIdList(self):
        return self._FolderIdList

    @FolderIdList.setter
    def FolderIdList(self, FolderIdList):
        self._FolderIdList = FolderIdList

    @property
    def WorkFlowIdList(self):
        return self._WorkFlowIdList

    @WorkFlowIdList.setter
    def WorkFlowIdList(self, WorkFlowIdList):
        self._WorkFlowIdList = WorkFlowIdList

    @property
    def WorkFlowNameList(self):
        return self._WorkFlowNameList

    @WorkFlowNameList.setter
    def WorkFlowNameList(self, WorkFlowNameList):
        self._WorkFlowNameList = WorkFlowNameList

    @property
    def TaskNameList(self):
        return self._TaskNameList

    @TaskNameList.setter
    def TaskNameList(self, TaskNameList):
        self._TaskNameList = TaskNameList

    @property
    def TaskIdList(self):
        return self._TaskIdList

    @TaskIdList.setter
    def TaskIdList(self, TaskIdList):
        self._TaskIdList = TaskIdList

    @property
    def StatusList(self):
        return self._StatusList

    @StatusList.setter
    def StatusList(self, StatusList):
        self._StatusList = StatusList

    @property
    def InChargeList(self):
        return self._InChargeList

    @InChargeList.setter
    def InChargeList(self, InChargeList):
        self._InChargeList = InChargeList

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def SortItem(self):
        return self._SortItem

    @SortItem.setter
    def SortItem(self, SortItem):
        self._SortItem = SortItem

    @property
    def SortType(self):
        return self._SortType

    @SortType.setter
    def SortType(self, SortType):
        self._SortType = SortType


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._ProductNameList = params.get("ProductNameList")
        self._FolderIdList = params.get("FolderIdList")
        self._WorkFlowIdList = params.get("WorkFlowIdList")
        self._WorkFlowNameList = params.get("WorkFlowNameList")
        self._TaskNameList = params.get("TaskNameList")
        self._TaskIdList = params.get("TaskIdList")
        self._StatusList = params.get("StatusList")
        self._InChargeList = params.get("InChargeList")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        self._SortItem = params.get("SortItem")
        self._SortType = params.get("SortType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOpsWorkflowsResponse(AbstractModel):
    """DescribeOpsWorkflows response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Workflow ListNote: This field may return null, indicating that no valid value can be obtained.
        :type Data: :class:`tencentcloud.wedata.v20210820.models.WorkflowExtOpsDtoPage`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = WorkflowExtOpsDtoPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeOrganizationalFunctionsRequest(AbstractModel):
    """DescribeOrganizationalFunctions request structure.

    """

    def __init__(self):
        r"""
        :param _Type: Scenario Type: Development, In Use
        :type Type: str
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _Name: Function Name
        :type Name: str
        :param _DisplayName: Display Name
        :type DisplayName: str
        :param _EnvType: Standard Mode Development Environment: DEV
Standard Mode Production Environment: PROD
Simple Mode: ALL

        :type EnvType: str
        """
        self._Type = None
        self._ProjectId = None
        self._Name = None
        self._DisplayName = None
        self._EnvType = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def DisplayName(self):
        return self._DisplayName

    @DisplayName.setter
    def DisplayName(self, DisplayName):
        self._DisplayName = DisplayName

    @property
    def EnvType(self):
        return self._EnvType

    @EnvType.setter
    def EnvType(self, EnvType):
        self._EnvType = EnvType


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._ProjectId = params.get("ProjectId")
        self._Name = params.get("Name")
        self._DisplayName = params.get("DisplayName")
        self._EnvType = params.get("EnvType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOrganizationalFunctionsResponse(AbstractModel):
    """DescribeOrganizationalFunctions response structure.

    """

    def __init__(self):
        r"""
        :param _Content: Function information
Note: This field may return null, indicating that no valid value can be obtained.
        :type Content: list of OrganizationalFunction
        :param _ErrorMessage: Operation failed
Note: This field may return null, indicating that no valid value can be obtained.
        :type ErrorMessage: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Content = None
        self._ErrorMessage = None
        self._RequestId = None

    @property
    def Content(self):
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content

    @property
    def ErrorMessage(self):
        return self._ErrorMessage

    @ErrorMessage.setter
    def ErrorMessage(self, ErrorMessage):
        self._ErrorMessage = ErrorMessage

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Content") is not None:
            self._Content = []
            for item in params.get("Content"):
                obj = OrganizationalFunction()
                obj._deserialize(item)
                self._Content.append(obj)
        self._ErrorMessage = params.get("ErrorMessage")
        self._RequestId = params.get("RequestId")


class DescribeProjectRequest(AbstractModel):
    """DescribeProject request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID. It is common to use the Project ID for queries, and either this or projectName must be present.
        :type ProjectId: str
        :param _DescribeClusters: Whether to Display Associated Cluster Information
        :type DescribeClusters: bool
        :param _DescribeExecutors: Whether to Display Information of Associated Execution Group, only partial information.
        :type DescribeExecutors: bool
        :param _DescribeAdminUsers: Default not to display project administrator information
        :type DescribeAdminUsers: bool
        :param _DescribeMemberCount: Default not to count the number of project personnel
        :type DescribeMemberCount: bool
        :param _DescribeCreator: Default not to query creator's information
        :type DescribeCreator: bool
        :param _ProjectName: The project name is unique within a tenant, generally used for conversion to Project ID.
        :type ProjectName: str
        """
        self._ProjectId = None
        self._DescribeClusters = None
        self._DescribeExecutors = None
        self._DescribeAdminUsers = None
        self._DescribeMemberCount = None
        self._DescribeCreator = None
        self._ProjectName = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def DescribeClusters(self):
        return self._DescribeClusters

    @DescribeClusters.setter
    def DescribeClusters(self, DescribeClusters):
        self._DescribeClusters = DescribeClusters

    @property
    def DescribeExecutors(self):
        return self._DescribeExecutors

    @DescribeExecutors.setter
    def DescribeExecutors(self, DescribeExecutors):
        self._DescribeExecutors = DescribeExecutors

    @property
    def DescribeAdminUsers(self):
        return self._DescribeAdminUsers

    @DescribeAdminUsers.setter
    def DescribeAdminUsers(self, DescribeAdminUsers):
        self._DescribeAdminUsers = DescribeAdminUsers

    @property
    def DescribeMemberCount(self):
        return self._DescribeMemberCount

    @DescribeMemberCount.setter
    def DescribeMemberCount(self, DescribeMemberCount):
        self._DescribeMemberCount = DescribeMemberCount

    @property
    def DescribeCreator(self):
        return self._DescribeCreator

    @DescribeCreator.setter
    def DescribeCreator(self, DescribeCreator):
        self._DescribeCreator = DescribeCreator

    @property
    def ProjectName(self):
        return self._ProjectName

    @ProjectName.setter
    def ProjectName(self, ProjectName):
        self._ProjectName = ProjectName


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._DescribeClusters = params.get("DescribeClusters")
        self._DescribeExecutors = params.get("DescribeExecutors")
        self._DescribeAdminUsers = params.get("DescribeAdminUsers")
        self._DescribeMemberCount = params.get("DescribeMemberCount")
        self._DescribeCreator = params.get("DescribeCreator")
        self._ProjectName = params.get("ProjectName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeProjectResponse(AbstractModel):
    """DescribeProject response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Project Information
        :type Data: :class:`tencentcloud.wedata.v20210820.models.Project`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = Project()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeQualityScoreRequest(AbstractModel):
    """DescribeQualityScore request structure.

    """

    def __init__(self):
        r"""
        :param _StatisticsDate: Statistics Date
        :type StatisticsDate: int
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _DatasourceId: Data source ID
        :type DatasourceId: str
        :param _ScoreType: 1: Calculate by full dimension weight, 2: Calculate by configured dimension weight, 3: Do not calculate by dimension weight, default is 1
        :type ScoreType: str
        :param _Filters: Ignore Query String
        :type Filters: list of Filter
        """
        self._StatisticsDate = None
        self._ProjectId = None
        self._DatasourceId = None
        self._ScoreType = None
        self._Filters = None

    @property
    def StatisticsDate(self):
        return self._StatisticsDate

    @StatisticsDate.setter
    def StatisticsDate(self, StatisticsDate):
        self._StatisticsDate = StatisticsDate

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def ScoreType(self):
        return self._ScoreType

    @ScoreType.setter
    def ScoreType(self, ScoreType):
        self._ScoreType = ScoreType

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._StatisticsDate = params.get("StatisticsDate")
        self._ProjectId = params.get("ProjectId")
        self._DatasourceId = params.get("DatasourceId")
        self._ScoreType = params.get("ScoreType")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeQualityScoreResponse(AbstractModel):
    """DescribeQualityScore response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Quality Score
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: :class:`tencentcloud.wedata.v20210820.models.QualityScore`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = QualityScore()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeQualityScoreTrendRequest(AbstractModel):
    """DescribeQualityScoreTrend request structure.

    """

    def __init__(self):
        r"""
        :param _StatisticsStartDate: Start Date of Statistics
        :type StatisticsStartDate: int
        :param _StatisticsEndDate: Statistics End Date
        :type StatisticsEndDate: int
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _DatasourceId: Data source ID
        :type DatasourceId: str
        :param _ScoreType: 1: Calculate by full dimension weight, 2: Calculate by configured dimension weight, 3: Do not calculate by dimension weight, default is 1
        :type ScoreType: str
        :param _Filters: Ignore Query String
        :type Filters: list of Filter
        """
        self._StatisticsStartDate = None
        self._StatisticsEndDate = None
        self._ProjectId = None
        self._DatasourceId = None
        self._ScoreType = None
        self._Filters = None

    @property
    def StatisticsStartDate(self):
        return self._StatisticsStartDate

    @StatisticsStartDate.setter
    def StatisticsStartDate(self, StatisticsStartDate):
        self._StatisticsStartDate = StatisticsStartDate

    @property
    def StatisticsEndDate(self):
        return self._StatisticsEndDate

    @StatisticsEndDate.setter
    def StatisticsEndDate(self, StatisticsEndDate):
        self._StatisticsEndDate = StatisticsEndDate

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def ScoreType(self):
        return self._ScoreType

    @ScoreType.setter
    def ScoreType(self, ScoreType):
        self._ScoreType = ScoreType

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._StatisticsStartDate = params.get("StatisticsStartDate")
        self._StatisticsEndDate = params.get("StatisticsEndDate")
        self._ProjectId = params.get("ProjectId")
        self._DatasourceId = params.get("DatasourceId")
        self._ScoreType = params.get("ScoreType")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeQualityScoreTrendResponse(AbstractModel):
    """DescribeQualityScoreTrend response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Quality score trend view
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: :class:`tencentcloud.wedata.v20210820.models.QualityScoreTrend`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = QualityScoreTrend()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRealTimeTaskInstanceNodeInfoRequest(AbstractModel):
    """DescribeRealTimeTaskInstanceNodeInfo request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Real-time Task ID
        :type TaskId: str
        :param _ProjectId: Project ID
        :type ProjectId: str
        """
        self._TaskId = None
        self._ProjectId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRealTimeTaskInstanceNodeInfoResponse(AbstractModel):
    """DescribeRealTimeTaskInstanceNodeInfo response structure.

    """

    def __init__(self):
        r"""
        :param _RealTimeTaskInstanceNodeInfo: Real-time task instance node related information
Note: This field may return null, indicating that no valid value can be obtained.
        :type RealTimeTaskInstanceNodeInfo: :class:`tencentcloud.wedata.v20210820.models.RealTimeTaskInstanceNodeInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RealTimeTaskInstanceNodeInfo = None
        self._RequestId = None

    @property
    def RealTimeTaskInstanceNodeInfo(self):
        return self._RealTimeTaskInstanceNodeInfo

    @RealTimeTaskInstanceNodeInfo.setter
    def RealTimeTaskInstanceNodeInfo(self, RealTimeTaskInstanceNodeInfo):
        self._RealTimeTaskInstanceNodeInfo = RealTimeTaskInstanceNodeInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RealTimeTaskInstanceNodeInfo") is not None:
            self._RealTimeTaskInstanceNodeInfo = RealTimeTaskInstanceNodeInfo()
            self._RealTimeTaskInstanceNodeInfo._deserialize(params.get("RealTimeTaskInstanceNodeInfo"))
        self._RequestId = params.get("RequestId")


class DescribeRealTimeTaskMetricOverviewRequest(AbstractModel):
    """DescribeRealTimeTaskMetricOverview request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID of the real-time task to be viewed, which can be obtained from the task list page
        :type TaskId: str
        :param _ProjectId: Project ID to be viewed
        :type ProjectId: str
        :param _StartTime: Start Time
        :type StartTime: int
        :param _EndTime: End time
        :type EndTime: int
        """
        self._TaskId = None
        self._ProjectId = None
        self._StartTime = None
        self._EndTime = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ProjectId = params.get("ProjectId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRealTimeTaskMetricOverviewResponse(AbstractModel):
    """DescribeRealTimeTaskMetricOverview response structure.

    """

    def __init__(self):
        r"""
        :param _TotalRecordNumOfRead: Total Read Records
        :type TotalRecordNumOfRead: int
        :param _TotalRecordByteNumOfRead: Total Read Bytes
        :type TotalRecordByteNumOfRead: int
        :param _TotalRecordNumOfWrite: Total Write Records
        :type TotalRecordNumOfWrite: int
        :param _TotalRecordByteNumOfWrite: Total Write Bytes Unit: bytes
        :type TotalRecordByteNumOfWrite: int
        :param _TotalDirtyRecordNum: Total Dirty Record Data
        :type TotalDirtyRecordNum: int
        :param _TotalDirtyRecordByte: Total Dirty Bytes Unit: bytes
        :type TotalDirtyRecordByte: int
        :param _TotalDuration: Execution Duration Unit: s
        :type TotalDuration: int
        :param _BeginRunTime: Start Running Time
        :type BeginRunTime: str
        :param _EndRunTime: Current Running Time
        :type EndRunTime: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalRecordNumOfRead = None
        self._TotalRecordByteNumOfRead = None
        self._TotalRecordNumOfWrite = None
        self._TotalRecordByteNumOfWrite = None
        self._TotalDirtyRecordNum = None
        self._TotalDirtyRecordByte = None
        self._TotalDuration = None
        self._BeginRunTime = None
        self._EndRunTime = None
        self._RequestId = None

    @property
    def TotalRecordNumOfRead(self):
        return self._TotalRecordNumOfRead

    @TotalRecordNumOfRead.setter
    def TotalRecordNumOfRead(self, TotalRecordNumOfRead):
        self._TotalRecordNumOfRead = TotalRecordNumOfRead

    @property
    def TotalRecordByteNumOfRead(self):
        return self._TotalRecordByteNumOfRead

    @TotalRecordByteNumOfRead.setter
    def TotalRecordByteNumOfRead(self, TotalRecordByteNumOfRead):
        self._TotalRecordByteNumOfRead = TotalRecordByteNumOfRead

    @property
    def TotalRecordNumOfWrite(self):
        return self._TotalRecordNumOfWrite

    @TotalRecordNumOfWrite.setter
    def TotalRecordNumOfWrite(self, TotalRecordNumOfWrite):
        self._TotalRecordNumOfWrite = TotalRecordNumOfWrite

    @property
    def TotalRecordByteNumOfWrite(self):
        return self._TotalRecordByteNumOfWrite

    @TotalRecordByteNumOfWrite.setter
    def TotalRecordByteNumOfWrite(self, TotalRecordByteNumOfWrite):
        self._TotalRecordByteNumOfWrite = TotalRecordByteNumOfWrite

    @property
    def TotalDirtyRecordNum(self):
        return self._TotalDirtyRecordNum

    @TotalDirtyRecordNum.setter
    def TotalDirtyRecordNum(self, TotalDirtyRecordNum):
        self._TotalDirtyRecordNum = TotalDirtyRecordNum

    @property
    def TotalDirtyRecordByte(self):
        return self._TotalDirtyRecordByte

    @TotalDirtyRecordByte.setter
    def TotalDirtyRecordByte(self, TotalDirtyRecordByte):
        self._TotalDirtyRecordByte = TotalDirtyRecordByte

    @property
    def TotalDuration(self):
        return self._TotalDuration

    @TotalDuration.setter
    def TotalDuration(self, TotalDuration):
        self._TotalDuration = TotalDuration

    @property
    def BeginRunTime(self):
        return self._BeginRunTime

    @BeginRunTime.setter
    def BeginRunTime(self, BeginRunTime):
        self._BeginRunTime = BeginRunTime

    @property
    def EndRunTime(self):
        return self._EndRunTime

    @EndRunTime.setter
    def EndRunTime(self, EndRunTime):
        self._EndRunTime = EndRunTime

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalRecordNumOfRead = params.get("TotalRecordNumOfRead")
        self._TotalRecordByteNumOfRead = params.get("TotalRecordByteNumOfRead")
        self._TotalRecordNumOfWrite = params.get("TotalRecordNumOfWrite")
        self._TotalRecordByteNumOfWrite = params.get("TotalRecordByteNumOfWrite")
        self._TotalDirtyRecordNum = params.get("TotalDirtyRecordNum")
        self._TotalDirtyRecordByte = params.get("TotalDirtyRecordByte")
        self._TotalDuration = params.get("TotalDuration")
        self._BeginRunTime = params.get("BeginRunTime")
        self._EndRunTime = params.get("EndRunTime")
        self._RequestId = params.get("RequestId")


class DescribeRealTimeTaskSpeedRequest(AbstractModel):
    """DescribeRealTimeTaskSpeed request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID
        :type TaskId: str
        :param _StartTime: Timestamp with Milliseconds
        :type StartTime: int
        :param _EndTime: Timestamp with Milliseconds
        :type EndTime: int
        :param _Granularity: Granularity, 1 or 5
        :type Granularity: int
        :param _ProjectId: Project ID
        :type ProjectId: str
        """
        self._TaskId = None
        self._StartTime = None
        self._EndTime = None
        self._Granularity = None
        self._ProjectId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Granularity(self):
        return self._Granularity

    @Granularity.setter
    def Granularity(self, Granularity):
        self._Granularity = Granularity

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Granularity = params.get("Granularity")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRealTimeTaskSpeedResponse(AbstractModel):
    """DescribeRealTimeTaskSpeed response structure.

    """

    def __init__(self):
        r"""
        :param _RecordsSpeedList: Synchronous Speed Bar/s List
        :type RecordsSpeedList: list of RecordsSpeed
        :param _BytesSpeedList: Synchronous Speed Bytes/s List
        :type BytesSpeedList: list of BytesSpeed
        :param _Data: Synchronous Speed, including RecordsSpeedList and BytesSpeedList
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RealTimeTaskSpeed`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RecordsSpeedList = None
        self._BytesSpeedList = None
        self._Data = None
        self._RequestId = None

    @property
    def RecordsSpeedList(self):
        return self._RecordsSpeedList

    @RecordsSpeedList.setter
    def RecordsSpeedList(self, RecordsSpeedList):
        self._RecordsSpeedList = RecordsSpeedList

    @property
    def BytesSpeedList(self):
        return self._BytesSpeedList

    @BytesSpeedList.setter
    def BytesSpeedList(self, BytesSpeedList):
        self._BytesSpeedList = BytesSpeedList

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RecordsSpeedList") is not None:
            self._RecordsSpeedList = []
            for item in params.get("RecordsSpeedList"):
                obj = RecordsSpeed()
                obj._deserialize(item)
                self._RecordsSpeedList.append(obj)
        if params.get("BytesSpeedList") is not None:
            self._BytesSpeedList = []
            for item in params.get("BytesSpeedList"):
                obj = BytesSpeed()
                obj._deserialize(item)
                self._BytesSpeedList.append(obj)
        if params.get("Data") is not None:
            self._Data = RealTimeTaskSpeed()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeResourceManagePathTreesRequest(AbstractModel):
    """DescribeResourceManagePathTrees request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _Name: Name, for search
        :type Name: str
        :param _FileType: File Type
        :type FileType: str
        :param _FilePath: File path
        :type FilePath: str
        :param _DirType: Folder Type
personal individual
project Item
resource
        :type DirType: str
        """
        self._ProjectId = None
        self._Name = None
        self._FileType = None
        self._FilePath = None
        self._DirType = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def FileType(self):
        return self._FileType

    @FileType.setter
    def FileType(self, FileType):
        self._FileType = FileType

    @property
    def FilePath(self):
        return self._FilePath

    @FilePath.setter
    def FilePath(self, FilePath):
        self._FilePath = FilePath

    @property
    def DirType(self):
        return self._DirType

    @DirType.setter
    def DirType(self, DirType):
        self._DirType = DirType


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._Name = params.get("Name")
        self._FileType = params.get("FileType")
        self._FilePath = params.get("FilePath")
        self._DirType = params.get("DirType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeResourceManagePathTreesResponse(AbstractModel):
    """DescribeResourceManagePathTrees response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response Data
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: list of ResourcePathTree
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = ResourcePathTree()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRuleDimStatRequest(AbstractModel):
    """DescribeRuleDimStat request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _BeginDate: Start time, timestamp to the second
        :type BeginDate: str
        :param _EndDate: End time, timestamp to the second
        :type EndDate: str
        """
        self._ProjectId = None
        self._BeginDate = None
        self._EndDate = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def BeginDate(self):
        return self._BeginDate

    @BeginDate.setter
    def BeginDate(self, BeginDate):
        self._BeginDate = BeginDate

    @property
    def EndDate(self):
        return self._EndDate

    @EndDate.setter
    def EndDate(self, EndDate):
        self._EndDate = EndDate


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._BeginDate = params.get("BeginDate")
        self._EndDate = params.get("EndDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleDimStatResponse(AbstractModel):
    """DescribeRuleDimStat response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Result
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleDimStat`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleDimStat()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleExecDetailRequest(AbstractModel):
    """DescribeRuleExecDetail request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _RuleExecId: Rule Execution ID
        :type RuleExecId: int
        """
        self._ProjectId = None
        self._RuleExecId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def RuleExecId(self):
        return self._RuleExecId

    @RuleExecId.setter
    def RuleExecId(self, RuleExecId):
        self._RuleExecId = RuleExecId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._RuleExecId = params.get("RuleExecId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleExecDetailResponse(AbstractModel):
    """DescribeRuleExecDetail response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Rule Execution Result DetailsNote: This field may return null, indicating that no valid value can be obtained.
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleExecResultDetail`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleExecResultDetail()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleExecLogRequest(AbstractModel):
    """DescribeRuleExecLog request structure.

    """

    def __init__(self):
        r"""
        :param _RuleExecId: Rule Execution ID
        :type RuleExecId: int
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _RuleGroupExecId: Rule Group Execution ID
        :type RuleGroupExecId: int
        """
        self._RuleExecId = None
        self._ProjectId = None
        self._RuleGroupExecId = None

    @property
    def RuleExecId(self):
        return self._RuleExecId

    @RuleExecId.setter
    def RuleExecId(self, RuleExecId):
        self._RuleExecId = RuleExecId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def RuleGroupExecId(self):
        return self._RuleGroupExecId

    @RuleGroupExecId.setter
    def RuleGroupExecId(self, RuleGroupExecId):
        self._RuleGroupExecId = RuleGroupExecId


    def _deserialize(self, params):
        self._RuleExecId = params.get("RuleExecId")
        self._ProjectId = params.get("ProjectId")
        self._RuleGroupExecId = params.get("RuleGroupExecId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleExecLogResponse(AbstractModel):
    """DescribeRuleExecLog response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Rule Execution LogNote: This field may return null, indicating that no valid value can be obtained.
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleExecLog`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleExecLog()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleExecResultsRequest(AbstractModel):
    """DescribeRuleExecResults request structure.

    """

    def __init__(self):
        r"""
        :param _RuleGroupExecId: Rule Group Execution ID
        :type RuleGroupExecId: int
        :param _ProjectId: Project ID
        :type ProjectId: str
        """
        self._RuleGroupExecId = None
        self._ProjectId = None

    @property
    def RuleGroupExecId(self):
        return self._RuleGroupExecId

    @RuleGroupExecId.setter
    def RuleGroupExecId(self, RuleGroupExecId):
        self._RuleGroupExecId = RuleGroupExecId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._RuleGroupExecId = params.get("RuleGroupExecId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleExecResultsResponse(AbstractModel):
    """DescribeRuleExecResults response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Rule Execution Result List
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleExecResultPage`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleExecResultPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleExecStatRequest(AbstractModel):
    """DescribeRuleExecStat request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _BeginDate: Start time, timestamp to the second
        :type BeginDate: str
        :param _EndDate: End time, timestamp to the second
        :type EndDate: str
        """
        self._ProjectId = None
        self._BeginDate = None
        self._EndDate = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def BeginDate(self):
        return self._BeginDate

    @BeginDate.setter
    def BeginDate(self, BeginDate):
        self._BeginDate = BeginDate

    @property
    def EndDate(self):
        return self._EndDate

    @EndDate.setter
    def EndDate(self, EndDate):
        self._EndDate = EndDate


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._BeginDate = params.get("BeginDate")
        self._EndDate = params.get("EndDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleExecStatResponse(AbstractModel):
    """DescribeRuleExecStat response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Result
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleExecStat`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleExecStat()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleGroupExecResultsByPageRequest(AbstractModel):
    """DescribeRuleGroupExecResultsByPage request structure.

    """

    def __init__(self):
        r"""
        :param _PageNumber: Pagination Index
        :type PageNumber: int
        :param _PageSize: Page size
        :type PageSize: int
        :param _Filters: Filter criteria
        :type Filters: list of Filter
        :param _OrderFields: Sort Fields
        :type OrderFields: list of OrderField
        :param _ProjectId: Project ID
        :type ProjectId: str
        """
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None
        self._OrderFields = None
        self._ProjectId = None

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleGroupExecResultsByPageResponse(AbstractModel):
    """DescribeRuleGroupExecResultsByPage response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Rule Group Execution Result List
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleGroupExecResultPage`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleGroupExecResultPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleGroupRequest(AbstractModel):
    """DescribeRuleGroup request structure.

    """

    def __init__(self):
        r"""
        :param _RuleGroupId: Rule Group ID
        :type RuleGroupId: int
        :param _DatasourceId: Data Source ID
        :type DatasourceId: str
        :param _TableId: Data Table ID
        :type TableId: str
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _DatabaseId: Database ID
        :type DatabaseId: str
        """
        self._RuleGroupId = None
        self._DatasourceId = None
        self._TableId = None
        self._ProjectId = None
        self._DatabaseId = None

    @property
    def RuleGroupId(self):
        return self._RuleGroupId

    @RuleGroupId.setter
    def RuleGroupId(self, RuleGroupId):
        self._RuleGroupId = RuleGroupId

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def TableId(self):
        return self._TableId

    @TableId.setter
    def TableId(self, TableId):
        self._TableId = TableId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def DatabaseId(self):
        return self._DatabaseId

    @DatabaseId.setter
    def DatabaseId(self, DatabaseId):
        self._DatabaseId = DatabaseId


    def _deserialize(self, params):
        self._RuleGroupId = params.get("RuleGroupId")
        self._DatasourceId = params.get("DatasourceId")
        self._TableId = params.get("TableId")
        self._ProjectId = params.get("ProjectId")
        self._DatabaseId = params.get("DatabaseId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleGroupResponse(AbstractModel):
    """DescribeRuleGroup response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Data quality rule group details
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleGroup`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleGroup()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleGroupSubscriptionRequest(AbstractModel):
    """DescribeRuleGroupSubscription request structure.

    """

    def __init__(self):
        r"""
        :param _RuleGroupId: Rule Group ID
        :type RuleGroupId: int
        :param _ProjectId: Project ID
        :type ProjectId: str
        """
        self._RuleGroupId = None
        self._ProjectId = None

    @property
    def RuleGroupId(self):
        return self._RuleGroupId

    @RuleGroupId.setter
    def RuleGroupId(self, RuleGroupId):
        self._RuleGroupId = RuleGroupId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._RuleGroupId = params.get("RuleGroupId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleGroupSubscriptionResponse(AbstractModel):
    """DescribeRuleGroupSubscription response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Rule Group Subscription Information
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleGroupSubscribe`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleGroupSubscribe()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleGroupTableRequest(AbstractModel):
    """DescribeRuleGroupTable request structure.

    """

    def __init__(self):
        r"""
        :param _TableId: Table ID
        :type TableId: str
        """
        self._TableId = None

    @property
    def TableId(self):
        return self._TableId

    @TableId.setter
    def TableId(self, TableId):
        self._TableId = TableId


    def _deserialize(self, params):
        self._TableId = params.get("TableId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleGroupTableResponse(AbstractModel):
    """DescribeRuleGroupTable response structure.

    """

    def __init__(self):
        r"""
        :param _Data: DataNote: This field may return null, indicating that no valid value can be obtained.
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleGroupTable`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleGroupTable()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleGroupsByPageRequest(AbstractModel):
    """DescribeRuleGroupsByPage request structure.

    """

    def __init__(self):
        r"""
        :param _PageNumber: Pagination Index
        :type PageNumber: int
        :param _PageSize: Page size
        :type PageSize: int
        :param _Filters: Filter criteria, each request's Filters limit is 10, Filter.Values limit is 5
        :type Filters: list of Filter
        :param _OrderFields: Sorting Method
        :type OrderFields: list of OrderField
        :param _ProjectId: Project ID
        :type ProjectId: str
        """
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None
        self._OrderFields = None
        self._ProjectId = None

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleGroupsByPageResponse(AbstractModel):
    """DescribeRuleGroupsByPage response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Rule Group List
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleGroupPage`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleGroupPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleRequest(AbstractModel):
    """DescribeRule request structure.

    """

    def __init__(self):
        r"""
        :param _RuleId: Quality Rule ID
        :type RuleId: int
        :param _ProjectId: Project ID
        :type ProjectId: str
        """
        self._RuleId = None
        self._ProjectId = None

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleResponse(AbstractModel):
    """DescribeRule response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Rule Details
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: :class:`tencentcloud.wedata.v20210820.models.Rule`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = Rule()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleTemplateRequest(AbstractModel):
    """DescribeRuleTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _TemplateId: Rule Template ID
        :type TemplateId: int
        """
        self._ProjectId = None
        self._TemplateId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TemplateId(self):
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TemplateId = params.get("TemplateId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleTemplateResponse(AbstractModel):
    """DescribeRuleTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Template Details
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleTemplate`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleTemplate()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleTemplatesByPageRequest(AbstractModel):
    """DescribeRuleTemplatesByPage request structure.

    """

    def __init__(self):
        r"""
        :param _PageNumber: Current Page
        :type PageNumber: int
        :param _PageSize: Number of records per page
        :type PageSize: int
        :param _ProjectId: Workspace ID
        :type ProjectId: str
        :param _OrderFields: Universal Sort Field
        :type OrderFields: list of OrderField
        :param _Filters: Universal Filter Criteria
        :type Filters: list of Filter
        """
        self._PageNumber = None
        self._PageSize = None
        self._ProjectId = None
        self._OrderFields = None
        self._Filters = None

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        self._ProjectId = params.get("ProjectId")
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleTemplatesByPageResponse(AbstractModel):
    """DescribeRuleTemplatesByPage response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Result
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleTemplatePage`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleTemplatePage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleTemplatesRequest(AbstractModel):
    """DescribeRuleTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _Type: Template Type 1. System Template 2. Custom Definition Template
        :type Type: int
        :param _SourceObjectType: 1. Constant 2. Offline Table Level 2. Offline Field Level
        :type SourceObjectType: int
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _SourceEngineTypes: Corresponding Engine Type of the Source
        :type SourceEngineTypes: list of int non-negative
        """
        self._Type = None
        self._SourceObjectType = None
        self._ProjectId = None
        self._SourceEngineTypes = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def SourceObjectType(self):
        return self._SourceObjectType

    @SourceObjectType.setter
    def SourceObjectType(self, SourceObjectType):
        self._SourceObjectType = SourceObjectType

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def SourceEngineTypes(self):
        return self._SourceEngineTypes

    @SourceEngineTypes.setter
    def SourceEngineTypes(self, SourceEngineTypes):
        self._SourceEngineTypes = SourceEngineTypes


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._SourceObjectType = params.get("SourceObjectType")
        self._ProjectId = params.get("ProjectId")
        self._SourceEngineTypes = params.get("SourceEngineTypes")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleTemplatesResponse(AbstractModel):
    """DescribeRuleTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Rule Template List
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: list of RuleTemplate
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = RuleTemplate()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRulesByPageRequest(AbstractModel):
    """DescribeRulesByPage request structure.

    """

    def __init__(self):
        r"""
        :param _PageNumber: Pagination Index
        :type PageNumber: int
        :param _PageSize: Page size
        :type PageSize: int
        :param _Filters: Filter criteria
        :type Filters: list of Filter
        :param _OrderFields: Sort Fields
        :type OrderFields: list of OrderField
        :param _ProjectId: Project ID
        :type ProjectId: str
        """
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None
        self._OrderFields = None
        self._ProjectId = None

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRulesByPageResponse(AbstractModel):
    """DescribeRulesByPage response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Rule Quality List
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RulePage`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RulePage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRulesRequest(AbstractModel):
    """DescribeRules request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _RuleGroupId: Rule Group ID
        :type RuleGroupId: int
        :param _EngineType: The running execution engine, if not specified, the default execution engine under this data source will be requested
        :type EngineType: str
        """
        self._ProjectId = None
        self._RuleGroupId = None
        self._EngineType = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def RuleGroupId(self):
        return self._RuleGroupId

    @RuleGroupId.setter
    def RuleGroupId(self, RuleGroupId):
        self._RuleGroupId = RuleGroupId

    @property
    def EngineType(self):
        return self._EngineType

    @EngineType.setter
    def EngineType(self, EngineType):
        self._EngineType = EngineType


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._RuleGroupId = params.get("RuleGroupId")
        self._EngineType = params.get("EngineType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRulesResponse(AbstractModel):
    """DescribeRules response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Rule list
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: list of Rule
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = Rule()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeScheduleInstancesRequest(AbstractModel):
    """DescribeScheduleInstances request structure.

    """

    def __init__(self):
        r"""
        :param _Instances: Instance List
        :type Instances: list of InstanceOpsDto
        :param _CheckFather: Check Parent Task Type, true: Check parent task; false: Do not check parent task
        :type CheckFather: bool
        :param _RerunType: Rerun Type, 1: Self; 3: Child; 2: Self and Child
        :type RerunType: str
        :param _DependentWay: Instance Dependency Mode, 1: Self-dependent; 2: Task-dependent; 3: Self and Parent-Child dependent
        :type DependentWay: str
        :param _SkipEventListening: Rerun Ignore Event Listening or Not
        :type SkipEventListening: bool
        :param _SonInstanceType: Downstream Instance Range 1: Within the workflow 2: Within the project 3: Across all workflows dependent on the project
        :type SonInstanceType: str
        :param _SearchCondition: Query conditions
        :type SearchCondition: :class:`tencentcloud.wedata.v20210820.models.InstanceApiOpsRequest`
        :param _OptType: Access type
        :type OptType: str
        :param _OperatorName: Operator Name
        :type OperatorName: str
        :param _OperatorId: Operator ID
        :type OperatorId: str
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _ProjectIdent: Project Identifier
        :type ProjectIdent: str
        :param _ProjectName: Project name
        :type ProjectName: str
        :param _PageIndex: Index Page Number
        :type PageIndex: int
        :param _PageSize: Page size
        :type PageSize: int
        :param _Count: Total Data
        :type Count: int
        :param _RequestBaseInfo: Basic Request Information
        :type RequestBaseInfo: :class:`tencentcloud.wedata.v20210820.models.ProjectBaseInfoOpsRequest`
        :param _IsCount: Whether to Calculate Total
        :type IsCount: bool
        """
        self._Instances = None
        self._CheckFather = None
        self._RerunType = None
        self._DependentWay = None
        self._SkipEventListening = None
        self._SonInstanceType = None
        self._SearchCondition = None
        self._OptType = None
        self._OperatorName = None
        self._OperatorId = None
        self._ProjectId = None
        self._ProjectIdent = None
        self._ProjectName = None
        self._PageIndex = None
        self._PageSize = None
        self._Count = None
        self._RequestBaseInfo = None
        self._IsCount = None

    @property
    def Instances(self):
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances

    @property
    def CheckFather(self):
        return self._CheckFather

    @CheckFather.setter
    def CheckFather(self, CheckFather):
        self._CheckFather = CheckFather

    @property
    def RerunType(self):
        return self._RerunType

    @RerunType.setter
    def RerunType(self, RerunType):
        self._RerunType = RerunType

    @property
    def DependentWay(self):
        return self._DependentWay

    @DependentWay.setter
    def DependentWay(self, DependentWay):
        self._DependentWay = DependentWay

    @property
    def SkipEventListening(self):
        return self._SkipEventListening

    @SkipEventListening.setter
    def SkipEventListening(self, SkipEventListening):
        self._SkipEventListening = SkipEventListening

    @property
    def SonInstanceType(self):
        return self._SonInstanceType

    @SonInstanceType.setter
    def SonInstanceType(self, SonInstanceType):
        self._SonInstanceType = SonInstanceType

    @property
    def SearchCondition(self):
        return self._SearchCondition

    @SearchCondition.setter
    def SearchCondition(self, SearchCondition):
        self._SearchCondition = SearchCondition

    @property
    def OptType(self):
        return self._OptType

    @OptType.setter
    def OptType(self, OptType):
        self._OptType = OptType

    @property
    def OperatorName(self):
        return self._OperatorName

    @OperatorName.setter
    def OperatorName(self, OperatorName):
        self._OperatorName = OperatorName

    @property
    def OperatorId(self):
        return self._OperatorId

    @OperatorId.setter
    def OperatorId(self, OperatorId):
        self._OperatorId = OperatorId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ProjectIdent(self):
        return self._ProjectIdent

    @ProjectIdent.setter
    def ProjectIdent(self, ProjectIdent):
        self._ProjectIdent = ProjectIdent

    @property
    def ProjectName(self):
        return self._ProjectName

    @ProjectName.setter
    def ProjectName(self, ProjectName):
        self._ProjectName = ProjectName

    @property
    def PageIndex(self):
        return self._PageIndex

    @PageIndex.setter
    def PageIndex(self, PageIndex):
        self._PageIndex = PageIndex

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Count(self):
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def RequestBaseInfo(self):
        return self._RequestBaseInfo

    @RequestBaseInfo.setter
    def RequestBaseInfo(self, RequestBaseInfo):
        self._RequestBaseInfo = RequestBaseInfo

    @property
    def IsCount(self):
        return self._IsCount

    @IsCount.setter
    def IsCount(self, IsCount):
        self._IsCount = IsCount


    def _deserialize(self, params):
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = InstanceOpsDto()
                obj._deserialize(item)
                self._Instances.append(obj)
        self._CheckFather = params.get("CheckFather")
        self._RerunType = params.get("RerunType")
        self._DependentWay = params.get("DependentWay")
        self._SkipEventListening = params.get("SkipEventListening")
        self._SonInstanceType = params.get("SonInstanceType")
        if params.get("SearchCondition") is not None:
            self._SearchCondition = InstanceApiOpsRequest()
            self._SearchCondition._deserialize(params.get("SearchCondition"))
        self._OptType = params.get("OptType")
        self._OperatorName = params.get("OperatorName")
        self._OperatorId = params.get("OperatorId")
        self._ProjectId = params.get("ProjectId")
        self._ProjectIdent = params.get("ProjectIdent")
        self._ProjectName = params.get("ProjectName")
        self._PageIndex = params.get("PageIndex")
        self._PageSize = params.get("PageSize")
        self._Count = params.get("Count")
        if params.get("RequestBaseInfo") is not None:
            self._RequestBaseInfo = ProjectBaseInfoOpsRequest()
            self._RequestBaseInfo._deserialize(params.get("RequestBaseInfo"))
        self._IsCount = params.get("IsCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeScheduleInstancesResponse(AbstractModel):
    """DescribeScheduleInstances response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Instance Result Set
        :type Data: :class:`tencentcloud.wedata.v20210820.models.CollectionInstanceOpsDto`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = CollectionInstanceOpsDto()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeSchedulerInstanceStatusRequest(AbstractModel):
    """DescribeSchedulerInstanceStatus request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _TaskTypeId: Task Type ID
        :type TaskTypeId: str
        :param _ExecutionGroupId: Execution Resource Group ID
        :type ExecutionGroupId: str
        :param _ExecutionGroupName: Execution Resource Group Name
        :type ExecutionGroupName: str
        :param _StartTime: Start Time
        :type StartTime: str
        :param _EndTime: End time
        :type EndTime: str
        :param _InCharge: Person in Charge
        :type InCharge: str
        :param _WorkflowId: Workflow ID
        :type WorkflowId: str
        """
        self._ProjectId = None
        self._TaskTypeId = None
        self._ExecutionGroupId = None
        self._ExecutionGroupName = None
        self._StartTime = None
        self._EndTime = None
        self._InCharge = None
        self._WorkflowId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskTypeId(self):
        return self._TaskTypeId

    @TaskTypeId.setter
    def TaskTypeId(self, TaskTypeId):
        self._TaskTypeId = TaskTypeId

    @property
    def ExecutionGroupId(self):
        return self._ExecutionGroupId

    @ExecutionGroupId.setter
    def ExecutionGroupId(self, ExecutionGroupId):
        self._ExecutionGroupId = ExecutionGroupId

    @property
    def ExecutionGroupName(self):
        return self._ExecutionGroupName

    @ExecutionGroupName.setter
    def ExecutionGroupName(self, ExecutionGroupName):
        self._ExecutionGroupName = ExecutionGroupName

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def InCharge(self):
        return self._InCharge

    @InCharge.setter
    def InCharge(self, InCharge):
        self._InCharge = InCharge

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TaskTypeId = params.get("TaskTypeId")
        self._ExecutionGroupId = params.get("ExecutionGroupId")
        self._ExecutionGroupName = params.get("ExecutionGroupName")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._InCharge = params.get("InCharge")
        self._WorkflowId = params.get("WorkflowId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSchedulerInstanceStatusResponse(AbstractModel):
    """DescribeSchedulerInstanceStatus response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response Data
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: list of ScreenInstanceInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = ScreenInstanceInfo()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSchedulerRunTimeInstanceCntByStatusRequest(AbstractModel):
    """DescribeSchedulerRunTimeInstanceCntByStatus request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _CycleUnit: Cycle Type
        :type CycleUnit: str
        :param _TimeUnit: Time Unit e.g.: 12h
        :type TimeUnit: str
        :param _StartTime: Start Date: 2023-03-02
        :type StartTime: str
        :param _EndTime: Before End Date: 2023-03-20
        :type EndTime: str
        :param _TaskType: Task Type
        :type TaskType: int
        :param _InCharge: Person in Charge
        :type InCharge: str
        :param _WorkflowId: Workflow ID
        :type WorkflowId: str
        :param _SortItem: Sort Fields
        :type SortItem: str
        :param _SortType: Ascending/Descending Order
        :type SortType: str
        """
        self._ProjectId = None
        self._CycleUnit = None
        self._TimeUnit = None
        self._StartTime = None
        self._EndTime = None
        self._TaskType = None
        self._InCharge = None
        self._WorkflowId = None
        self._SortItem = None
        self._SortType = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def CycleUnit(self):
        return self._CycleUnit

    @CycleUnit.setter
    def CycleUnit(self, CycleUnit):
        self._CycleUnit = CycleUnit

    @property
    def TimeUnit(self):
        return self._TimeUnit

    @TimeUnit.setter
    def TimeUnit(self, TimeUnit):
        self._TimeUnit = TimeUnit

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def InCharge(self):
        return self._InCharge

    @InCharge.setter
    def InCharge(self, InCharge):
        self._InCharge = InCharge

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId

    @property
    def SortItem(self):
        return self._SortItem

    @SortItem.setter
    def SortItem(self, SortItem):
        self._SortItem = SortItem

    @property
    def SortType(self):
        return self._SortType

    @SortType.setter
    def SortType(self, SortType):
        self._SortType = SortType


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._CycleUnit = params.get("CycleUnit")
        self._TimeUnit = params.get("TimeUnit")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._TaskType = params.get("TaskType")
        self._InCharge = params.get("InCharge")
        self._WorkflowId = params.get("WorkflowId")
        self._SortItem = params.get("SortItem")
        self._SortType = params.get("SortType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSchedulerRunTimeInstanceCntByStatusResponse(AbstractModel):
    """DescribeSchedulerRunTimeInstanceCntByStatus response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Response Data
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: list of RuntimeInstanceCntTop
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = RuntimeInstanceCntTop()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSchedulerTaskCntByStatusRequest(AbstractModel):
    """DescribeSchedulerTaskCntByStatus request structure.

    """

    def __init__(self):
        r"""
        :param _TaskType: 1
        :type TaskType: int
        :param _TypeName: Y
        :type TypeName: str
        :param _ProjectId: 111
        :type ProjectId: str
        :param _InCharge: 1
        :type InCharge: str
        :param _WorkflowId: Workflow ID
        :type WorkflowId: str
        """
        self._TaskType = None
        self._TypeName = None
        self._ProjectId = None
        self._InCharge = None
        self._WorkflowId = None

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def TypeName(self):
        return self._TypeName

    @TypeName.setter
    def TypeName(self, TypeName):
        self._TypeName = TypeName

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def InCharge(self):
        return self._InCharge

    @InCharge.setter
    def InCharge(self, InCharge):
        self._InCharge = InCharge

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId


    def _deserialize(self, params):
        self._TaskType = params.get("TaskType")
        self._TypeName = params.get("TypeName")
        self._ProjectId = params.get("ProjectId")
        self._InCharge = params.get("InCharge")
        self._WorkflowId = params.get("WorkflowId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSchedulerTaskCntByStatusResponse(AbstractModel):
    """DescribeSchedulerTaskCntByStatus response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Statistical Results
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: list of ScreenTaskInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = ScreenTaskInfo()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSchedulerTaskTypeCntRequest(AbstractModel):
    """DescribeSchedulerTaskTypeCnt request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _InCharge: Person in Charge
        :type InCharge: str
        """
        self._ProjectId = None
        self._InCharge = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def InCharge(self):
        return self._InCharge

    @InCharge.setter
    def InCharge(self, InCharge):
        self._InCharge = InCharge


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._InCharge = params.get("InCharge")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSchedulerTaskTypeCntResponse(AbstractModel):
    """DescribeSchedulerTaskTypeCnt response structure.

    """

    def __init__(self):
        r"""
        :param _Data: data
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: list of TaskTypeCnt
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = TaskTypeCnt()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeStatisticInstanceStatusTrendOpsRequest(AbstractModel):
    """DescribeStatisticInstanceStatusTrendOps request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _TaskTypeId: Task Type Id
        :type TaskTypeId: str
        :param _TimeType: Time Type
        :type TimeType: str
        :param _TypeName: Task Type Name
        :type TypeName: str
        :param _StartTime: Start Time
        :type StartTime: str
        :param _EndTime: End time
        :type EndTime: str
        :param _ExecutionGroupId: Resource Group ID
        :type ExecutionGroupId: str
        :param _ExecutionGroupName: Resource Group Name
        :type ExecutionGroupName: str
        :param _InCharge: 1
        :type InCharge: str
        :param _TaskType: 1
        :type TaskType: int
        :param _StateList: 1
        :type StateList: list of int
        :param _AggregationUnit: D represents days, H represents hours
        :type AggregationUnit: str
        :param _AverageWindowSize: 1
        :type AverageWindowSize: int
        :param _WorkflowId: Workflow ID
        :type WorkflowId: str
        """
        self._ProjectId = None
        self._TaskTypeId = None
        self._TimeType = None
        self._TypeName = None
        self._StartTime = None
        self._EndTime = None
        self._ExecutionGroupId = None
        self._ExecutionGroupName = None
        self._InCharge = None
        self._TaskType = None
        self._StateList = None
        self._AggregationUnit = None
        self._AverageWindowSize = None
        self._WorkflowId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskTypeId(self):
        return self._TaskTypeId

    @TaskTypeId.setter
    def TaskTypeId(self, TaskTypeId):
        self._TaskTypeId = TaskTypeId

    @property
    def TimeType(self):
        return self._TimeType

    @TimeType.setter
    def TimeType(self, TimeType):
        self._TimeType = TimeType

    @property
    def TypeName(self):
        return self._TypeName

    @TypeName.setter
    def TypeName(self, TypeName):
        self._TypeName = TypeName

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def ExecutionGroupId(self):
        return self._ExecutionGroupId

    @ExecutionGroupId.setter
    def ExecutionGroupId(self, ExecutionGroupId):
        self._ExecutionGroupId = ExecutionGroupId

    @property
    def ExecutionGroupName(self):
        return self._ExecutionGroupName

    @ExecutionGroupName.setter
    def ExecutionGroupName(self, ExecutionGroupName):
        self._ExecutionGroupName = ExecutionGroupName

    @property
    def InCharge(self):
        return self._InCharge

    @InCharge.setter
    def InCharge(self, InCharge):
        self._InCharge = InCharge

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def StateList(self):
        return self._StateList

    @StateList.setter
    def StateList(self, StateList):
        self._StateList = StateList

    @property
    def AggregationUnit(self):
        return self._AggregationUnit

    @AggregationUnit.setter
    def AggregationUnit(self, AggregationUnit):
        self._AggregationUnit = AggregationUnit

    @property
    def AverageWindowSize(self):
        return self._AverageWindowSize

    @AverageWindowSize.setter
    def AverageWindowSize(self, AverageWindowSize):
        self._AverageWindowSize = AverageWindowSize

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TaskTypeId = params.get("TaskTypeId")
        self._TimeType = params.get("TimeType")
        self._TypeName = params.get("TypeName")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._ExecutionGroupId = params.get("ExecutionGroupId")
        self._ExecutionGroupName = params.get("ExecutionGroupName")
        self._InCharge = params.get("InCharge")
        self._TaskType = params.get("TaskType")
        self._StateList = params.get("StateList")
        self._AggregationUnit = params.get("AggregationUnit")
        self._AverageWindowSize = params.get("AverageWindowSize")
        self._WorkflowId = params.get("WorkflowId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeStatisticInstanceStatusTrendOpsResponse(AbstractModel):
    """DescribeStatisticInstanceStatusTrendOps response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Instance status statistics results
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: list of InstanceStatisticInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = InstanceStatisticInfo()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeStreamTaskLogListRequest(AbstractModel):
    """DescribeStreamTaskLogList request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _TaskId: Task ID
        :type TaskId: str
        :param _JobId: Job ID
        :type JobId: str
        :param _EndTime: End time
        :type EndTime: int
        :param _StartTime: Start Time
        :type StartTime: int
        :param _Container: container Name
        :type Container: str
        :param _Limit: Number of entries
        :type Limit: int
        :param _OrderType: Sort Type desc asc
        :type OrderType: str
        :param _RunningOrderId: Instance ID of Job Execution
        :type RunningOrderId: int
        :param _Keyword: Keyword
        :type Keyword: str
        """
        self._ProjectId = None
        self._TaskId = None
        self._JobId = None
        self._EndTime = None
        self._StartTime = None
        self._Container = None
        self._Limit = None
        self._OrderType = None
        self._RunningOrderId = None
        self._Keyword = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def Container(self):
        return self._Container

    @Container.setter
    def Container(self, Container):
        self._Container = Container

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def OrderType(self):
        return self._OrderType

    @OrderType.setter
    def OrderType(self, OrderType):
        self._OrderType = OrderType

    @property
    def RunningOrderId(self):
        return self._RunningOrderId

    @RunningOrderId.setter
    def RunningOrderId(self, RunningOrderId):
        self._RunningOrderId = RunningOrderId

    @property
    def Keyword(self):
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TaskId = params.get("TaskId")
        self._JobId = params.get("JobId")
        self._EndTime = params.get("EndTime")
        self._StartTime = params.get("StartTime")
        self._Container = params.get("Container")
        self._Limit = params.get("Limit")
        self._OrderType = params.get("OrderType")
        self._RunningOrderId = params.get("RunningOrderId")
        self._Keyword = params.get("Keyword")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeStreamTaskLogListResponse(AbstractModel):
    """DescribeStreamTaskLogList response structure.

    """

    def __init__(self):
        r"""
        :param _ListOver: Is it full
Note: This field may return null, indicating that no valid value can be obtained.
        :type ListOver: bool
        :param _LogContentList: Log Collection
Note: This field may return null, indicating that no valid value can be obtained.
        :type LogContentList: list of LogContentInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ListOver = None
        self._LogContentList = None
        self._RequestId = None

    @property
    def ListOver(self):
        return self._ListOver

    @ListOver.setter
    def ListOver(self, ListOver):
        self._ListOver = ListOver

    @property
    def LogContentList(self):
        return self._LogContentList

    @LogContentList.setter
    def LogContentList(self, LogContentList):
        self._LogContentList = LogContentList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ListOver = params.get("ListOver")
        if params.get("LogContentList") is not None:
            self._LogContentList = []
            for item in params.get("LogContentList"):
                obj = LogContentInfo()
                obj._deserialize(item)
                self._LogContentList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSuccessorOpsTaskInfosRequest(AbstractModel):
    """DescribeSuccessorOpsTaskInfos request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID
        :type TaskId: str
        :param _ProjectId: Project ID
        :type ProjectId: str
        """
        self._TaskId = None
        self._ProjectId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSuccessorOpsTaskInfosResponse(AbstractModel):
    """DescribeSuccessorOpsTaskInfos response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Downstream Task List
        :type Data: list of TaskOpsDto
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = TaskOpsDto()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTableBasicInfoRequest(AbstractModel):
    """DescribeTableBasicInfo request structure.

    """

    def __init__(self):
        r"""
        :param _PageNumber: Page number
        :type PageNumber: int
        :param _PageSize: Page size
        :type PageSize: int
        :param _Filters: Filter field
        :type Filters: list of Filter
        :param _OrderFields: Sort Fields
        :type OrderFields: list of OrderField
        """
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None
        self._OrderFields = None

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields


    def _deserialize(self, params):
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTableBasicInfoResponse(AbstractModel):
    """DescribeTableBasicInfo response structure.

    """

    def __init__(self):
        r"""
        :param _TableBasicInfoList: Table Metadata
Note: This field may return null, indicating that no valid value can be obtained.
        :type TableBasicInfoList: list of TableBasicInfo
        :param _TotalCount: Total number of items
Note: This field may return null, indicating that no valid value can be obtained.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TableBasicInfoList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def TableBasicInfoList(self):
        return self._TableBasicInfoList

    @TableBasicInfoList.setter
    def TableBasicInfoList(self, TableBasicInfoList):
        self._TableBasicInfoList = TableBasicInfoList

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TableBasicInfoList") is not None:
            self._TableBasicInfoList = []
            for item in params.get("TableBasicInfoList"):
                obj = TableBasicInfo()
                obj._deserialize(item)
                self._TableBasicInfoList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeTableInfoListRequest(AbstractModel):
    """DescribeTableInfoList request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Table name
        :type Filters: list of Filter
        :param _ConnectionType: If it is hive write rpc, if it is other types do not transmit
        :type ConnectionType: str
        :param _Catalog: Database source type
        :type Catalog: str
        """
        self._Filters = None
        self._ConnectionType = None
        self._Catalog = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def ConnectionType(self):
        return self._ConnectionType

    @ConnectionType.setter
    def ConnectionType(self, ConnectionType):
        self._ConnectionType = ConnectionType

    @property
    def Catalog(self):
        return self._Catalog

    @Catalog.setter
    def Catalog(self, Catalog):
        self._Catalog = Catalog


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._ConnectionType = params.get("ConnectionType")
        self._Catalog = params.get("Catalog")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTableInfoListResponse(AbstractModel):
    """DescribeTableInfoList response structure.

    """

    def __init__(self):
        r"""
        :param _TableInfo: Table informationNote: This field may return null, indicating that no valid value can be obtained.
        :type TableInfo: list of TableInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TableInfo = None
        self._RequestId = None

    @property
    def TableInfo(self):
        return self._TableInfo

    @TableInfo.setter
    def TableInfo(self, TableInfo):
        self._TableInfo = TableInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TableInfo") is not None:
            self._TableInfo = []
            for item in params.get("TableInfo"):
                obj = TableInfo()
                obj._deserialize(item)
                self._TableInfo.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTableLineageInfoRequest(AbstractModel):
    """DescribeTableLineageInfo request structure.

    """

    def __init__(self):
        r"""
        :param _Direction: Query Direction, INPUT, OUTPUT, BOTH enumerated values
        :type Direction: str
        :param _Data: Table information
        :type Data: :class:`tencentcloud.wedata.v20210820.models.TableLineageInfo`
        :param _InputDepth: Single Query Indegree, default 1
        :type InputDepth: int
        :param _OutputDepth: Single Query Outdegree, default 1
        :type OutputDepth: int
        :param _ExtParams: Additional Parameters (Pass Caller Information)
        :type ExtParams: list of LineageParamRecord
        :param _IgnoreTemp: Filter Temporary Tables, default true
        :type IgnoreTemp: bool
        :param _RecursiveSecond: Recursively Query Number of Secondary Nodes, default is true
        :type RecursiveSecond: bool
        """
        self._Direction = None
        self._Data = None
        self._InputDepth = None
        self._OutputDepth = None
        self._ExtParams = None
        self._IgnoreTemp = None
        self._RecursiveSecond = None

    @property
    def Direction(self):
        return self._Direction

    @Direction.setter
    def Direction(self, Direction):
        self._Direction = Direction

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def InputDepth(self):
        return self._InputDepth

    @InputDepth.setter
    def InputDepth(self, InputDepth):
        self._InputDepth = InputDepth

    @property
    def OutputDepth(self):
        return self._OutputDepth

    @OutputDepth.setter
    def OutputDepth(self, OutputDepth):
        self._OutputDepth = OutputDepth

    @property
    def ExtParams(self):
        return self._ExtParams

    @ExtParams.setter
    def ExtParams(self, ExtParams):
        self._ExtParams = ExtParams

    @property
    def IgnoreTemp(self):
        return self._IgnoreTemp

    @IgnoreTemp.setter
    def IgnoreTemp(self, IgnoreTemp):
        self._IgnoreTemp = IgnoreTemp

    @property
    def RecursiveSecond(self):
        return self._RecursiveSecond

    @RecursiveSecond.setter
    def RecursiveSecond(self, RecursiveSecond):
        self._RecursiveSecond = RecursiveSecond


    def _deserialize(self, params):
        self._Direction = params.get("Direction")
        if params.get("Data") is not None:
            self._Data = TableLineageInfo()
            self._Data._deserialize(params.get("Data"))
        self._InputDepth = params.get("InputDepth")
        self._OutputDepth = params.get("OutputDepth")
        if params.get("ExtParams") is not None:
            self._ExtParams = []
            for item in params.get("ExtParams"):
                obj = LineageParamRecord()
                obj._deserialize(item)
                self._ExtParams.append(obj)
        self._IgnoreTemp = params.get("IgnoreTemp")
        self._RecursiveSecond = params.get("RecursiveSecond")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTableLineageInfoResponse(AbstractModel):
    """DescribeTableLineageInfo response structure.

    """

    def __init__(self):
        r"""
        :param _TableLineageBasicInfo: Table Lineage Information
Note: This field may return null, indicating that no valid value can be obtained.
        :type TableLineageBasicInfo: :class:`tencentcloud.wedata.v20210820.models.TableLineageBaseInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TableLineageBasicInfo = None
        self._RequestId = None

    @property
    def TableLineageBasicInfo(self):
        return self._TableLineageBasicInfo

    @TableLineageBasicInfo.setter
    def TableLineageBasicInfo(self, TableLineageBasicInfo):
        self._TableLineageBasicInfo = TableLineageBasicInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TableLineageBasicInfo") is not None:
            self._TableLineageBasicInfo = TableLineageBaseInfo()
            self._TableLineageBasicInfo._deserialize(params.get("TableLineageBasicInfo"))
        self._RequestId = params.get("RequestId")


class DescribeTableLineageRequest(AbstractModel):
    """DescribeTableLineage request structure.

    """

    def __init__(self):
        r"""
        :param _Direction: Query Direction, INPUT, OUTPUT, BOTH enumerated values
        :type Direction: str
        :param _Data: Table information
        :type Data: :class:`tencentcloud.wedata.v20210820.models.TableLineageInfo`
        :param _InputDepth: Single Query Indegree, default 1
        :type InputDepth: int
        :param _OutputDepth: Single Query Outdegree, default 1
        :type OutputDepth: int
        :param _ExtParams: Additional Parameters (Pass Caller Information)
        :type ExtParams: list of LineageParamRecord
        :param _IgnoreTemp: Filter Temporary Tables, default true
        :type IgnoreTemp: bool
        :param _RecursiveSecond: Recursively Query Number of Secondary Nodes, default is true
        :type RecursiveSecond: bool
        """
        self._Direction = None
        self._Data = None
        self._InputDepth = None
        self._OutputDepth = None
        self._ExtParams = None
        self._IgnoreTemp = None
        self._RecursiveSecond = None

    @property
    def Direction(self):
        return self._Direction

    @Direction.setter
    def Direction(self, Direction):
        self._Direction = Direction

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def InputDepth(self):
        return self._InputDepth

    @InputDepth.setter
    def InputDepth(self, InputDepth):
        self._InputDepth = InputDepth

    @property
    def OutputDepth(self):
        return self._OutputDepth

    @OutputDepth.setter
    def OutputDepth(self, OutputDepth):
        self._OutputDepth = OutputDepth

    @property
    def ExtParams(self):
        return self._ExtParams

    @ExtParams.setter
    def ExtParams(self, ExtParams):
        self._ExtParams = ExtParams

    @property
    def IgnoreTemp(self):
        return self._IgnoreTemp

    @IgnoreTemp.setter
    def IgnoreTemp(self, IgnoreTemp):
        self._IgnoreTemp = IgnoreTemp

    @property
    def RecursiveSecond(self):
        return self._RecursiveSecond

    @RecursiveSecond.setter
    def RecursiveSecond(self, RecursiveSecond):
        self._RecursiveSecond = RecursiveSecond


    def _deserialize(self, params):
        self._Direction = params.get("Direction")
        if params.get("Data") is not None:
            self._Data = TableLineageInfo()
            self._Data._deserialize(params.get("Data"))
        self._InputDepth = params.get("InputDepth")
        self._OutputDepth = params.get("OutputDepth")
        if params.get("ExtParams") is not None:
            self._ExtParams = []
            for item in params.get("ExtParams"):
                obj = LineageParamRecord()
                obj._deserialize(item)
                self._ExtParams.append(obj)
        self._IgnoreTemp = params.get("IgnoreTemp")
        self._RecursiveSecond = params.get("RecursiveSecond")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTableLineageResponse(AbstractModel):
    """DescribeTableLineage response structure.

    """

    def __init__(self):
        r"""
        :param _TableLineage: Table Lineage Information
Note: This field may return null, indicating that no valid value can be obtained.
        :type TableLineage: :class:`tencentcloud.wedata.v20210820.models.TableLineageInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TableLineage = None
        self._RequestId = None

    @property
    def TableLineage(self):
        return self._TableLineage

    @TableLineage.setter
    def TableLineage(self, TableLineage):
        self._TableLineage = TableLineage

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TableLineage") is not None:
            self._TableLineage = TableLineageInfo()
            self._TableLineage._deserialize(params.get("TableLineage"))
        self._RequestId = params.get("RequestId")


class DescribeTableMetaRequest(AbstractModel):
    """DescribeTableMeta request structure.

    """

    def __init__(self):
        r"""
        :param _TableId: Unique Table ID
        :type TableId: str
        :param _TableNameFilter: Query conditions by Name
        :type TableNameFilter: :class:`tencentcloud.wedata.v20210820.models.TableNameFilter`
        :param _TableFilterType: Query condition type: 0 by ID, 1 by Name, default is 0
        :type TableFilterType: int
        """
        self._TableId = None
        self._TableNameFilter = None
        self._TableFilterType = None

    @property
    def TableId(self):
        return self._TableId

    @TableId.setter
    def TableId(self, TableId):
        self._TableId = TableId

    @property
    def TableNameFilter(self):
        return self._TableNameFilter

    @TableNameFilter.setter
    def TableNameFilter(self, TableNameFilter):
        self._TableNameFilter = TableNameFilter

    @property
    def TableFilterType(self):
        return self._TableFilterType

    @TableFilterType.setter
    def TableFilterType(self, TableFilterType):
        self._TableFilterType = TableFilterType


    def _deserialize(self, params):
        self._TableId = params.get("TableId")
        if params.get("TableNameFilter") is not None:
            self._TableNameFilter = TableNameFilter()
            self._TableNameFilter._deserialize(params.get("TableNameFilter"))
        self._TableFilterType = params.get("TableFilterType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTableMetaResponse(AbstractModel):
    """DescribeTableMeta response structure.

    """

    def __init__(self):
        r"""
        :param _TableMeta: Table Metadata InformationNote: This field may return null, indicating that no valid value can be obtained.
        :type TableMeta: :class:`tencentcloud.wedata.v20210820.models.TableMeta`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TableMeta = None
        self._RequestId = None

    @property
    def TableMeta(self):
        return self._TableMeta

    @TableMeta.setter
    def TableMeta(self, TableMeta):
        self._TableMeta = TableMeta

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TableMeta") is not None:
            self._TableMeta = TableMeta()
            self._TableMeta._deserialize(params.get("TableMeta"))
        self._RequestId = params.get("RequestId")


class DescribeTableMetasRequest(AbstractModel):
    """DescribeTableMetas request structure.

    """

    def __init__(self):
        r"""
        :param _PageNumber: Page number
        :type PageNumber: int
        :param _PageSize: Page size
        :type PageSize: int
        :param _Filters: Filter field
        :type Filters: list of Filter
        :param _OrderFields: Sort Fields
        :type OrderFields: list of OrderField
        """
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None
        self._OrderFields = None

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields


    def _deserialize(self, params):
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTableMetasResponse(AbstractModel):
    """DescribeTableMetas response structure.

    """

    def __init__(self):
        r"""
        :param _TableMetas: Table Metadata
Note: This field may return null, indicating that no valid value can be obtained.
        :type TableMetas: list of TableMeta
        :param _TotalCount: Total number of items
Note: This field may return null, indicating that no valid value can be obtained.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TableMetas = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def TableMetas(self):
        return self._TableMetas

    @TableMetas.setter
    def TableMetas(self, TableMetas):
        self._TableMetas = TableMetas

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TableMetas") is not None:
            self._TableMetas = []
            for item in params.get("TableMetas"):
                obj = TableMeta()
                obj._deserialize(item)
                self._TableMetas.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeTableQualityDetailsRequest(AbstractModel):
    """DescribeTableQualityDetails request structure.

    """

    def __init__(self):
        r"""
        :param _StatisticsDate: Statistics Date
        :type StatisticsDate: int
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _PageNumber: Pagination Index
        :type PageNumber: int
        :param _PageSize: Page size
        :type PageSize: int
        :param _Filters: Filter Parameters TableName, DatabaseId, DatabaseName, OwnerUserName
        :type Filters: list of Filter
        :param _OrderFields: Sorting Parameters Sort order DESC or ASC, Table score sorting TableScore
        :type OrderFields: list of OrderField
        :param _DatasourceId: Data source ID
        :type DatasourceId: str
        :param _ScoreType: 1: Calculate by full dimension weight, 2: Calculate by configured dimension weight, 3: Do not calculate by dimension weight, default is 1
        :type ScoreType: str
        """
        self._StatisticsDate = None
        self._ProjectId = None
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None
        self._OrderFields = None
        self._DatasourceId = None
        self._ScoreType = None

    @property
    def StatisticsDate(self):
        return self._StatisticsDate

    @StatisticsDate.setter
    def StatisticsDate(self, StatisticsDate):
        self._StatisticsDate = StatisticsDate

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def ScoreType(self):
        return self._ScoreType

    @ScoreType.setter
    def ScoreType(self, ScoreType):
        self._ScoreType = ScoreType


    def _deserialize(self, params):
        self._StatisticsDate = params.get("StatisticsDate")
        self._ProjectId = params.get("ProjectId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        self._DatasourceId = params.get("DatasourceId")
        self._ScoreType = params.get("ScoreType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTableQualityDetailsResponse(AbstractModel):
    """DescribeTableQualityDetails response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Table quality score details result
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: :class:`tencentcloud.wedata.v20210820.models.TableQualityDetailPage`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = TableQualityDetailPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeTableSchemaInfoRequest(AbstractModel):
    """DescribeTableSchemaInfo request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Table Name
        :type Name: str
        :param _DatabaseName: Database name
        :type DatabaseName: str
        :param _MsType: Data Source Types (e.g., MYSQL, HIVE, KAFKA, etc.)
        :type MsType: str
        :param _DatasourceId: Data source ID
        :type DatasourceId: str
        :param _ConnectionType: Connection Type (example value: rpc)
        :type ConnectionType: str
        :param _SchemaName: Schema Name under Metadata Database
        :type SchemaName: str
        """
        self._Name = None
        self._DatabaseName = None
        self._MsType = None
        self._DatasourceId = None
        self._ConnectionType = None
        self._SchemaName = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def DatabaseName(self):
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def MsType(self):
        return self._MsType

    @MsType.setter
    def MsType(self, MsType):
        self._MsType = MsType

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def ConnectionType(self):
        return self._ConnectionType

    @ConnectionType.setter
    def ConnectionType(self, ConnectionType):
        self._ConnectionType = ConnectionType

    @property
    def SchemaName(self):
        return self._SchemaName

    @SchemaName.setter
    def SchemaName(self, SchemaName):
        self._SchemaName = SchemaName


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._DatabaseName = params.get("DatabaseName")
        self._MsType = params.get("MsType")
        self._DatasourceId = params.get("DatasourceId")
        self._ConnectionType = params.get("ConnectionType")
        self._SchemaName = params.get("SchemaName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTableSchemaInfoResponse(AbstractModel):
    """DescribeTableSchemaInfo response structure.

    """

    def __init__(self):
        r"""
        :param _SchemaInfoList: Retrieved SchemaInfo Information
Note: This field may return null, indicating that no valid value can be obtained.
        :type SchemaInfoList: list of SchemaDetail
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SchemaInfoList = None
        self._RequestId = None

    @property
    def SchemaInfoList(self):
        return self._SchemaInfoList

    @SchemaInfoList.setter
    def SchemaInfoList(self, SchemaInfoList):
        self._SchemaInfoList = SchemaInfoList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SchemaInfoList") is not None:
            self._SchemaInfoList = []
            for item in params.get("SchemaInfoList"):
                obj = SchemaDetail()
                obj._deserialize(item)
                self._SchemaInfoList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTableScoreTrendRequest(AbstractModel):
    """DescribeTableScoreTrend request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _StatisticsStartDate: Start time Second-level Timestamp
        :type StatisticsStartDate: int
        :param _StatisticsEndDate: End time Second-level Timestamp
        :type StatisticsEndDate: int
        :param _TableId: Table ID
        :type TableId: str
        :param _ScoreType: 1: Calculate by full dimension weight, 2: Calculate by configured dimension weight, 3: Do not calculate by dimension weight, default is 1
        :type ScoreType: str
        """
        self._ProjectId = None
        self._StatisticsStartDate = None
        self._StatisticsEndDate = None
        self._TableId = None
        self._ScoreType = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def StatisticsStartDate(self):
        return self._StatisticsStartDate

    @StatisticsStartDate.setter
    def StatisticsStartDate(self, StatisticsStartDate):
        self._StatisticsStartDate = StatisticsStartDate

    @property
    def StatisticsEndDate(self):
        return self._StatisticsEndDate

    @StatisticsEndDate.setter
    def StatisticsEndDate(self, StatisticsEndDate):
        self._StatisticsEndDate = StatisticsEndDate

    @property
    def TableId(self):
        return self._TableId

    @TableId.setter
    def TableId(self, TableId):
        self._TableId = TableId

    @property
    def ScoreType(self):
        return self._ScoreType

    @ScoreType.setter
    def ScoreType(self, ScoreType):
        self._ScoreType = ScoreType


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._StatisticsStartDate = params.get("StatisticsStartDate")
        self._StatisticsEndDate = params.get("StatisticsEndDate")
        self._TableId = params.get("TableId")
        self._ScoreType = params.get("ScoreType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTableScoreTrendResponse(AbstractModel):
    """DescribeTableScoreTrend response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Table Scoring Trend
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: :class:`tencentcloud.wedata.v20210820.models.QualityScoreTrend`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = QualityScoreTrend()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeTaskAlarmRegulationsRequest(AbstractModel):
    """DescribeTaskAlarmRegulations request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _PageNumber: Current Page
        :type PageNumber: int
        :param _PageSize: Number of records per page
        :type PageSize: int
        :param _Filters: Filter criteria (name includes RegularStatus, AlarmLevel, AlarmIndicator, RegularName)
        :type Filters: list of Filter
        :param _OrderFields: Sorting criteria (RegularId)
        :type OrderFields: list of OrderField
        :param _TaskId: Task ID
        :type TaskId: str
        :param _TaskType: Task Type (201 for real-time task, 202 for offline task)
        :type TaskType: int
        """
        self._ProjectId = None
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None
        self._OrderFields = None
        self._TaskId = None
        self._TaskType = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        self._TaskId = params.get("TaskId")
        self._TaskType = params.get("TaskType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskAlarmRegulationsResponse(AbstractModel):
    """DescribeTaskAlarmRegulations response structure.

    """

    def __init__(self):
        r"""
        :param _TaskAlarmInfos: Alert Rule Information
Note: This field may return null, indicating that no valid value can be obtained.
        :type TaskAlarmInfos: list of TaskAlarmInfo
        :param _TotalCount: Number of recordsNote: This field may return null, indicating that no valid value can be obtained.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskAlarmInfos = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def TaskAlarmInfos(self):
        return self._TaskAlarmInfos

    @TaskAlarmInfos.setter
    def TaskAlarmInfos(self, TaskAlarmInfos):
        self._TaskAlarmInfos = TaskAlarmInfos

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TaskAlarmInfos") is not None:
            self._TaskAlarmInfos = []
            for item in params.get("TaskAlarmInfos"):
                obj = TaskAlarmInfo()
                obj._deserialize(item)
                self._TaskAlarmInfos.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeTaskByCycleReportRequest(AbstractModel):
    """DescribeTaskByCycleReport request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _Type: Task Cycle Type
        :type Type: str
        :param _StartTime: Start Time
        :type StartTime: str
        :param _EndTime: End time
        :type EndTime: str
        """
        self._ProjectId = None
        self._Type = None
        self._StartTime = None
        self._EndTime = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._Type = params.get("Type")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskByCycleReportResponse(AbstractModel):
    """DescribeTaskByCycleReport response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Task Cycle Growth Trend Statistics
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: list of TaskByStatus
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = TaskByStatus()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTaskByCycleRequest(AbstractModel):
    """DescribeTaskByCycle request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _InCharge: 1
        :type InCharge: str
        :param _WorkflowId: Workflow ID
        :type WorkflowId: str
        """
        self._ProjectId = None
        self._InCharge = None
        self._WorkflowId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def InCharge(self):
        return self._InCharge

    @InCharge.setter
    def InCharge(self, InCharge):
        self._InCharge = InCharge

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._InCharge = params.get("InCharge")
        self._WorkflowId = params.get("WorkflowId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskByCycleResponse(AbstractModel):
    """DescribeTaskByCycle response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Periodic Task Statistics
        :type Data: list of TaskByCycle
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = TaskByCycle()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTaskByStatusReportRequest(AbstractModel):
    """DescribeTaskByStatusReport request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _Type: Time Type
        :type Type: str
        :param _TaskType: Type
        :type TaskType: str
        :param _TypeName: Type Name
        :type TypeName: str
        :param _StartTime: Start Time
        :type StartTime: str
        :param _EndTime: End time
        :type EndTime: str
        :param _AggregationUnit: Aggregation Unit, H Hours
        :type AggregationUnit: str
        :param _CycleUnit: Cycle
        :type CycleUnit: str
        :param _Status: Status
        :type Status: str
        :param _InCharge: Person in Charge
        :type InCharge: str
        :param _WorkflowId: Workflow ID
        :type WorkflowId: str
        """
        self._ProjectId = None
        self._Type = None
        self._TaskType = None
        self._TypeName = None
        self._StartTime = None
        self._EndTime = None
        self._AggregationUnit = None
        self._CycleUnit = None
        self._Status = None
        self._InCharge = None
        self._WorkflowId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def TypeName(self):
        return self._TypeName

    @TypeName.setter
    def TypeName(self, TypeName):
        self._TypeName = TypeName

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def AggregationUnit(self):
        return self._AggregationUnit

    @AggregationUnit.setter
    def AggregationUnit(self, AggregationUnit):
        self._AggregationUnit = AggregationUnit

    @property
    def CycleUnit(self):
        return self._CycleUnit

    @CycleUnit.setter
    def CycleUnit(self, CycleUnit):
        self._CycleUnit = CycleUnit

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def InCharge(self):
        return self._InCharge

    @InCharge.setter
    def InCharge(self, InCharge):
        self._InCharge = InCharge

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._Type = params.get("Type")
        self._TaskType = params.get("TaskType")
        self._TypeName = params.get("TypeName")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._AggregationUnit = params.get("AggregationUnit")
        self._CycleUnit = params.get("CycleUnit")
        self._Status = params.get("Status")
        self._InCharge = params.get("InCharge")
        self._WorkflowId = params.get("WorkflowId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskByStatusReportResponse(AbstractModel):
    """DescribeTaskByStatusReport response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Task reporting trend indicators
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: list of TaskByStatus
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = TaskByStatus()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTaskLockStatusRequest(AbstractModel):
    """DescribeTaskLockStatus request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID
        :type TaskId: str
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _TaskType: Task Type: 201. stream, 202. offline
        :type TaskType: int
        """
        self._TaskId = None
        self._ProjectId = None
        self._TaskType = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ProjectId = params.get("ProjectId")
        self._TaskType = params.get("TaskType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskLockStatusResponse(AbstractModel):
    """DescribeTaskLockStatus response structure.

    """

    def __init__(self):
        r"""
        :param _TaskLockStatus: Task lock status information
        :type TaskLockStatus: :class:`tencentcloud.wedata.v20210820.models.TaskLockStatus`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskLockStatus = None
        self._RequestId = None

    @property
    def TaskLockStatus(self):
        return self._TaskLockStatus

    @TaskLockStatus.setter
    def TaskLockStatus(self, TaskLockStatus):
        self._TaskLockStatus = TaskLockStatus

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TaskLockStatus") is not None:
            self._TaskLockStatus = TaskLockStatus()
            self._TaskLockStatus._deserialize(params.get("TaskLockStatus"))
        self._RequestId = params.get("RequestId")


class DescribeTaskRunHistoryRequest(AbstractModel):
    """DescribeTaskRunHistory request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _SearchCondition: Search Criteria
        :type SearchCondition: :class:`tencentcloud.wedata.v20210820.models.InstanceSearchCondition`
        :param _PageSize: Page Size
        :type PageSize: int
        :param _PageNumber: Page Number
        :type PageNumber: int
        """
        self._ProjectId = None
        self._SearchCondition = None
        self._PageSize = None
        self._PageNumber = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def SearchCondition(self):
        return self._SearchCondition

    @SearchCondition.setter
    def SearchCondition(self, SearchCondition):
        self._SearchCondition = SearchCondition

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        if params.get("SearchCondition") is not None:
            self._SearchCondition = InstanceSearchCondition()
            self._SearchCondition._deserialize(params.get("SearchCondition"))
        self._PageSize = params.get("PageSize")
        self._PageNumber = params.get("PageNumber")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskRunHistoryResponse(AbstractModel):
    """DescribeTaskRunHistory response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Paginated Query Task Run History Results
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: :class:`tencentcloud.wedata.v20210820.models.InstanceOpsInfoPage`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = InstanceOpsInfoPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeTaskScriptRequest(AbstractModel):
    """DescribeTaskScript request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _TaskId: Task ID
        :type TaskId: str
        """
        self._ProjectId = None
        self._TaskId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskScriptResponse(AbstractModel):
    """DescribeTaskScript response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Task Script Content
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: :class:`tencentcloud.wedata.v20210820.models.TaskScriptContent`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = TaskScriptContent()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeTemplateDimCountRequest(AbstractModel):
    """DescribeTemplateDimCount request structure.

    """

    def __init__(self):
        r"""
        :param _Type: Template Type
        :type Type: int
        :param _ProjectId: Project ID
        :type ProjectId: str
        """
        self._Type = None
        self._ProjectId = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTemplateDimCountResponse(AbstractModel):
    """DescribeTemplateDimCount response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Dimensional statistics results
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: list of DimensionCount
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = DimensionCount()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeThirdTaskRunLogRequest(AbstractModel):
    """DescribeThirdTaskRunLog request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID
        :type TaskId: str
        :param _CurRunDate: Instance data time
        :type CurRunDate: str
        """
        self._TaskId = None
        self._CurRunDate = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def CurRunDate(self):
        return self._CurRunDate

    @CurRunDate.setter
    def CurRunDate(self, CurRunDate):
        self._CurRunDate = CurRunDate


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._CurRunDate = params.get("CurRunDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeThirdTaskRunLogResponse(AbstractModel):
    """DescribeThirdTaskRunLog response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Get third-party operation logsNote: This field may return null, indicating that no valid value can be obtained.
        :type Data: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DescribeTopTableStatRequest(AbstractModel):
    """DescribeTopTableStat request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _BeginDate: Start time, timestamp to the second
        :type BeginDate: str
        :param _EndDate: End time, timestamp to the second
        :type EndDate: str
        """
        self._ProjectId = None
        self._BeginDate = None
        self._EndDate = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def BeginDate(self):
        return self._BeginDate

    @BeginDate.setter
    def BeginDate(self, BeginDate):
        self._BeginDate = BeginDate

    @property
    def EndDate(self):
        return self._EndDate

    @EndDate.setter
    def EndDate(self, EndDate):
        self._EndDate = EndDate


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._BeginDate = params.get("BeginDate")
        self._EndDate = params.get("EndDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTopTableStatResponse(AbstractModel):
    """DescribeTopTableStat response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Result
        :type Data: :class:`tencentcloud.wedata.v20210820.models.TopTableStat`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = TopTableStat()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeTrendStatRequest(AbstractModel):
    """DescribeTrendStat request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _BeginDate: Start time, timestamp to the second
        :type BeginDate: str
        :param _EndDate: End time, timestamp to the second
        :type EndDate: str
        """
        self._ProjectId = None
        self._BeginDate = None
        self._EndDate = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def BeginDate(self):
        return self._BeginDate

    @BeginDate.setter
    def BeginDate(self, BeginDate):
        self._BeginDate = BeginDate

    @property
    def EndDate(self):
        return self._EndDate

    @EndDate.setter
    def EndDate(self, EndDate):
        self._EndDate = EndDate


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._BeginDate = params.get("BeginDate")
        self._EndDate = params.get("EndDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTrendStatResponse(AbstractModel):
    """DescribeTrendStat response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Result
        :type Data: list of RuleExecDateStat
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = RuleExecDateStat()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeWorkflowCanvasInfoRequest(AbstractModel):
    """DescribeWorkflowCanvasInfo request structure.

    """

    def __init__(self):
        r"""
        :param _WorkflowId: Workflow ID
        :type WorkflowId: str
        :param _ProjectId: Project ID
        :type ProjectId: str
        """
        self._WorkflowId = None
        self._ProjectId = None

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._WorkflowId = params.get("WorkflowId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeWorkflowCanvasInfoResponse(AbstractModel):
    """DescribeWorkflowCanvasInfo response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Workflow Scheduling Details
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: :class:`tencentcloud.wedata.v20210820.models.WorkflowCanvasOpsDto`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = WorkflowCanvasOpsDto()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeWorkflowExecuteByIdRequest(AbstractModel):
    """DescribeWorkflowExecuteById request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _WorkFlowIdList: Workflow ID
        :type WorkFlowIdList: str
        :param _PageNumber: Page size
        :type PageNumber: int
        :param _PageSize: Pagination index
        :type PageSize: int
        """
        self._ProjectId = None
        self._WorkFlowIdList = None
        self._PageNumber = None
        self._PageSize = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def WorkFlowIdList(self):
        return self._WorkFlowIdList

    @WorkFlowIdList.setter
    def WorkFlowIdList(self, WorkFlowIdList):
        self._WorkFlowIdList = WorkFlowIdList

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._WorkFlowIdList = params.get("WorkFlowIdList")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeWorkflowExecuteByIdResponse(AbstractModel):
    """DescribeWorkflowExecuteById response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Workflow Runtime Information
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: :class:`tencentcloud.wedata.v20210820.models.WorkFlowExecuteDtoByPage`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = WorkFlowExecuteDtoByPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeWorkflowInfoByIdRequest(AbstractModel):
    """DescribeWorkflowInfoById request structure.

    """

    def __init__(self):
        r"""
        :param _WorkflowId: Workflow ID
        :type WorkflowId: str
        :param _ProjectId: Project ID
        :type ProjectId: str
        """
        self._WorkflowId = None
        self._ProjectId = None

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._WorkflowId = params.get("WorkflowId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeWorkflowInfoByIdResponse(AbstractModel):
    """DescribeWorkflowInfoById response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Workflow Scheduling Details
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: :class:`tencentcloud.wedata.v20210820.models.WorkflowSchedulerOpsDto`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = WorkflowSchedulerOpsDto()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeWorkflowListByProjectIdRequest(AbstractModel):
    """DescribeWorkflowListByProjectId request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        """
        self._ProjectId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeWorkflowListByProjectIdResponse(AbstractModel):
    """DescribeWorkflowListByProjectId response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Obtain a list of all workflows under the project based on the project ID
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: list of WorkflowCanvasOpsDto
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = WorkflowCanvasOpsDto()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeWorkflowTaskCountRequest(AbstractModel):
    """DescribeWorkflowTaskCount request structure.

    """

    def __init__(self):
        r"""
        :param _WorkflowId: Workflow List
        :type WorkflowId: str
        :param _ProjectId: Project ID
        :type ProjectId: str
        """
        self._WorkflowId = None
        self._ProjectId = None

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._WorkflowId = params.get("WorkflowId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeWorkflowTaskCountResponse(AbstractModel):
    """DescribeWorkflowTaskCount response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Statistical Results
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: :class:`tencentcloud.wedata.v20210820.models.WorkflowTaskCountOpsDto`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = WorkflowTaskCountOpsDto()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DiagnoseProRequest(AbstractModel):
    """DiagnosePro request structure.

    """

    def __init__(self):
        r"""
        :param _Instances: Instance List
        :type Instances: list of InstanceOpsDto
        :param _CheckFather: Check Parent Task Type, true: Check parent task; false: Do not check parent task
        :type CheckFather: bool
        :param _RerunType: Rerun Type, 1: Self; 3: Child; 2: Self and Child
        :type RerunType: str
        :param _DependentWay: Instance Dependency Mode, 1: Self-dependent; 2: Task-dependent; 3: Self and Parent-Child dependent
        :type DependentWay: str
        :param _SkipEventListening: Rerun Ignore Event Listening or Not
        :type SkipEventListening: bool
        :param _SonInstanceType: Downstream Instance Range 1: Within the workflow 2: Within the project 3: Across all workflows dependent on the project
        :type SonInstanceType: str
        :param _SearchCondition: Query Conditions (TaskId and CurRunDate need to be filled in this field for diagnosis)
        :type SearchCondition: :class:`tencentcloud.wedata.v20210820.models.InstanceApiOpsRequest`
        :param _OptType: Access type
        :type OptType: str
        :param _OperatorName: Operator Name
        :type OperatorName: str
        :param _OperatorId: Operator ID
        :type OperatorId: str
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _ProjectIdent: Project Identifier
        :type ProjectIdent: str
        :param _ProjectName: Project name
        :type ProjectName: str
        :param _PageIndex: Index Page Number
        :type PageIndex: int
        :param _PageSize: Page size
        :type PageSize: int
        :param _Count: Total Data
        :type Count: int
        :param _RequestBaseInfo: Basic Request Information
        :type RequestBaseInfo: :class:`tencentcloud.wedata.v20210820.models.ProjectBaseInfoOpsRequest`
        :param _IsCount: Whether to Calculate Total
        :type IsCount: bool
        """
        self._Instances = None
        self._CheckFather = None
        self._RerunType = None
        self._DependentWay = None
        self._SkipEventListening = None
        self._SonInstanceType = None
        self._SearchCondition = None
        self._OptType = None
        self._OperatorName = None
        self._OperatorId = None
        self._ProjectId = None
        self._ProjectIdent = None
        self._ProjectName = None
        self._PageIndex = None
        self._PageSize = None
        self._Count = None
        self._RequestBaseInfo = None
        self._IsCount = None

    @property
    def Instances(self):
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances

    @property
    def CheckFather(self):
        return self._CheckFather

    @CheckFather.setter
    def CheckFather(self, CheckFather):
        self._CheckFather = CheckFather

    @property
    def RerunType(self):
        return self._RerunType

    @RerunType.setter
    def RerunType(self, RerunType):
        self._RerunType = RerunType

    @property
    def DependentWay(self):
        return self._DependentWay

    @DependentWay.setter
    def DependentWay(self, DependentWay):
        self._DependentWay = DependentWay

    @property
    def SkipEventListening(self):
        return self._SkipEventListening

    @SkipEventListening.setter
    def SkipEventListening(self, SkipEventListening):
        self._SkipEventListening = SkipEventListening

    @property
    def SonInstanceType(self):
        return self._SonInstanceType

    @SonInstanceType.setter
    def SonInstanceType(self, SonInstanceType):
        self._SonInstanceType = SonInstanceType

    @property
    def SearchCondition(self):
        return self._SearchCondition

    @SearchCondition.setter
    def SearchCondition(self, SearchCondition):
        self._SearchCondition = SearchCondition

    @property
    def OptType(self):
        return self._OptType

    @OptType.setter
    def OptType(self, OptType):
        self._OptType = OptType

    @property
    def OperatorName(self):
        return self._OperatorName

    @OperatorName.setter
    def OperatorName(self, OperatorName):
        self._OperatorName = OperatorName

    @property
    def OperatorId(self):
        return self._OperatorId

    @OperatorId.setter
    def OperatorId(self, OperatorId):
        self._OperatorId = OperatorId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ProjectIdent(self):
        return self._ProjectIdent

    @ProjectIdent.setter
    def ProjectIdent(self, ProjectIdent):
        self._ProjectIdent = ProjectIdent

    @property
    def ProjectName(self):
        return self._ProjectName

    @ProjectName.setter
    def ProjectName(self, ProjectName):
        self._ProjectName = ProjectName

    @property
    def PageIndex(self):
        return self._PageIndex

    @PageIndex.setter
    def PageIndex(self, PageIndex):
        self._PageIndex = PageIndex

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Count(self):
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def RequestBaseInfo(self):
        return self._RequestBaseInfo

    @RequestBaseInfo.setter
    def RequestBaseInfo(self, RequestBaseInfo):
        self._RequestBaseInfo = RequestBaseInfo

    @property
    def IsCount(self):
        return self._IsCount

    @IsCount.setter
    def IsCount(self, IsCount):
        self._IsCount = IsCount


    def _deserialize(self, params):
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = InstanceOpsDto()
                obj._deserialize(item)
                self._Instances.append(obj)
        self._CheckFather = params.get("CheckFather")
        self._RerunType = params.get("RerunType")
        self._DependentWay = params.get("DependentWay")
        self._SkipEventListening = params.get("SkipEventListening")
        self._SonInstanceType = params.get("SonInstanceType")
        if params.get("SearchCondition") is not None:
            self._SearchCondition = InstanceApiOpsRequest()
            self._SearchCondition._deserialize(params.get("SearchCondition"))
        self._OptType = params.get("OptType")
        self._OperatorName = params.get("OperatorName")
        self._OperatorId = params.get("OperatorId")
        self._ProjectId = params.get("ProjectId")
        self._ProjectIdent = params.get("ProjectIdent")
        self._ProjectName = params.get("ProjectName")
        self._PageIndex = params.get("PageIndex")
        self._PageSize = params.get("PageSize")
        self._Count = params.get("Count")
        if params.get("RequestBaseInfo") is not None:
            self._RequestBaseInfo = ProjectBaseInfoOpsRequest()
            self._RequestBaseInfo._deserialize(params.get("RequestBaseInfo"))
        self._IsCount = params.get("IsCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DiagnoseProResponse(AbstractModel):
    """DiagnosePro response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Result
        :type Data: :class:`tencentcloud.wedata.v20210820.models.DiagnoseRep`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DiagnoseRep()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DiagnoseRep(AbstractModel):
    """DiagnoseRep

    """

    def __init__(self):
        r"""
        :param _Content: Diagnostic information content
Note: This field may return null, indicating that no valid value can be obtained.
        :type Content: :class:`tencentcloud.wedata.v20210820.models.Content`
        :param _Table: List of diagnostic result-related information
Note: This field may return null, indicating that no valid value can be obtained.
        :type Table: :class:`tencentcloud.wedata.v20210820.models.Table`
        """
        self._Content = None
        self._Table = None

    @property
    def Content(self):
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content

    @property
    def Table(self):
        return self._Table

    @Table.setter
    def Table(self, Table):
        self._Table = Table


    def _deserialize(self, params):
        if params.get("Content") is not None:
            self._Content = Content()
            self._Content._deserialize(params.get("Content"))
        if params.get("Table") is not None:
            self._Table = Table()
            self._Table._deserialize(params.get("Table"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DimensionCount(AbstractModel):
    """Dimension statistical business view

    """

    def __init__(self):
        r"""
        :param _DimType: Dimension types 1: Accuracy, 2: Uniqueness, 3: Completeness, 4: Consistency, 5: Timeliness, 6: Validity
Note: This field may return null, indicating that no valid value can be obtained.
        :type DimType: int
        :param _Count: Statistics value
Note: This field may return null, indicating that no valid value can be obtained.
        :type Count: int
        :param _QualityDim: Dimension types 1: Accuracy, 2: Uniqueness, 3: Completeness, 4: Consistency, 5: Timeliness, 6: Validity
Note: This field may return null, indicating that no valid value can be obtained.
        :type QualityDim: int
        """
        self._DimType = None
        self._Count = None
        self._QualityDim = None

    @property
    def DimType(self):
        warnings.warn("parameter `DimType` is deprecated", DeprecationWarning) 

        return self._DimType

    @DimType.setter
    def DimType(self, DimType):
        warnings.warn("parameter `DimType` is deprecated", DeprecationWarning) 

        self._DimType = DimType

    @property
    def Count(self):
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def QualityDim(self):
        return self._QualityDim

    @QualityDim.setter
    def QualityDim(self, QualityDim):
        self._QualityDim = QualityDim


    def _deserialize(self, params):
        self._DimType = params.get("DimType")
        self._Count = params.get("Count")
        self._QualityDim = params.get("QualityDim")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DimensionScore(AbstractModel):
    """Dimension Scoring

    """

    def __init__(self):
        r"""
        :param _DimensionScoreList: Dimension Scoring List
Note: This field may return null, indicating that no valid value can be obtained.
        :type DimensionScoreList: list of DimensionScoreInfo
        """
        self._DimensionScoreList = None

    @property
    def DimensionScoreList(self):
        return self._DimensionScoreList

    @DimensionScoreList.setter
    def DimensionScoreList(self, DimensionScoreList):
        self._DimensionScoreList = DimensionScoreList


    def _deserialize(self, params):
        if params.get("DimensionScoreList") is not None:
            self._DimensionScoreList = []
            for item in params.get("DimensionScoreList"):
                obj = DimensionScoreInfo()
                obj._deserialize(item)
                self._DimensionScoreList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DimensionScoreInfo(AbstractModel):
    """Dimension Scoring Information

    """

    def __init__(self):
        r"""
        :param _Name: Dimension NameNote: This field may return null, indicating that no valid value can be obtained.
        :type Name: str
        :param _Weight: WeightNote: This field may return null, indicating that no valid value can be obtained.
        :type Weight: float
        :param _UserId: Setter ID
Note: This field may return null, indicating that no valid value can be obtained.
        :type UserId: int
        :param _UserName: Setter Name
Note: This field may return null, indicating that no valid value can be obtained.
        :type UserName: str
        :param _UpdateTime: Update Time Timestamp
Note: This field may return null, indicating that no valid value can be obtained.
        :type UpdateTime: int
        :param _JoinTableNumber: Number of Evaluation Forms Involved
        :type JoinTableNumber: int
        :param _Score: Scoring
        :type Score: float
        :param _UserIdStr: Set by User ID Str
Note: This field may return null, indicating that no valid value can be obtained.
        :type UserIdStr: str
        """
        self._Name = None
        self._Weight = None
        self._UserId = None
        self._UserName = None
        self._UpdateTime = None
        self._JoinTableNumber = None
        self._Score = None
        self._UserIdStr = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Weight(self):
        return self._Weight

    @Weight.setter
    def Weight(self, Weight):
        self._Weight = Weight

    @property
    def UserId(self):
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def UserName(self):
        return self._UserName

    @UserName.setter
    def UserName(self, UserName):
        self._UserName = UserName

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def JoinTableNumber(self):
        return self._JoinTableNumber

    @JoinTableNumber.setter
    def JoinTableNumber(self, JoinTableNumber):
        self._JoinTableNumber = JoinTableNumber

    @property
    def Score(self):
        return self._Score

    @Score.setter
    def Score(self, Score):
        self._Score = Score

    @property
    def UserIdStr(self):
        return self._UserIdStr

    @UserIdStr.setter
    def UserIdStr(self, UserIdStr):
        self._UserIdStr = UserIdStr


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Weight = params.get("Weight")
        self._UserId = params.get("UserId")
        self._UserName = params.get("UserName")
        self._UpdateTime = params.get("UpdateTime")
        self._JoinTableNumber = params.get("JoinTableNumber")
        self._Score = params.get("Score")
        self._UserIdStr = params.get("UserIdStr")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DlcDataGovernPolicy(AbstractModel):
    """Data Governance Configuration Items

    """

    def __init__(self):
        r"""
        :param _RewriteDataPolicy: Data Layout Governance Item
Note: This field may return null, indicating that no valid value can be obtained.
        :type RewriteDataPolicy: :class:`tencentcloud.wedata.v20210820.models.DlcRewriteDataInfo`
        :param _ExpiredSnapshotsPolicy: Snapshot Expiration Governance Item
Note: This field may return null, indicating that no valid value can be obtained.
        :type ExpiredSnapshotsPolicy: :class:`tencentcloud.wedata.v20210820.models.DlcExpiredSnapshotsInfo`
        :param _RemoveOrphanFilesPolicy: Remove Isolated Files Governance Item
Note: This field may return null, indicating that no valid value can be obtained.
        :type RemoveOrphanFilesPolicy: :class:`tencentcloud.wedata.v20210820.models.DlcRemoveOrphanFilesInfo`
        :param _MergeManifestsPolicy: Merge Metadata Manifests Governance Item
Note: This field may return null, indicating that no valid value can be obtained.
        :type MergeManifestsPolicy: :class:`tencentcloud.wedata.v20210820.models.DlcMergeManifestsInfo`
        :param _InheritDataBase: Integration Library Rules: default (Default Inheritance), none (No Inheritance)
Note: This field may return null, indicating that no valid value can be obtained.
        :type InheritDataBase: str
        :param _RuleType: Governance Rule Types, Customize: Custom Definition; Intelligence: Intelligent Governance
Note: This field may return null, indicating that no valid value can be obtained.
        :type RuleType: str
        :param _GovernEngine: Governance Engine
Note: This field may return null, indicating that no valid value can be obtained.
        :type GovernEngine: str
        """
        self._RewriteDataPolicy = None
        self._ExpiredSnapshotsPolicy = None
        self._RemoveOrphanFilesPolicy = None
        self._MergeManifestsPolicy = None
        self._InheritDataBase = None
        self._RuleType = None
        self._GovernEngine = None

    @property
    def RewriteDataPolicy(self):
        return self._RewriteDataPolicy

    @RewriteDataPolicy.setter
    def RewriteDataPolicy(self, RewriteDataPolicy):
        self._RewriteDataPolicy = RewriteDataPolicy

    @property
    def ExpiredSnapshotsPolicy(self):
        return self._ExpiredSnapshotsPolicy

    @ExpiredSnapshotsPolicy.setter
    def ExpiredSnapshotsPolicy(self, ExpiredSnapshotsPolicy):
        self._ExpiredSnapshotsPolicy = ExpiredSnapshotsPolicy

    @property
    def RemoveOrphanFilesPolicy(self):
        return self._RemoveOrphanFilesPolicy

    @RemoveOrphanFilesPolicy.setter
    def RemoveOrphanFilesPolicy(self, RemoveOrphanFilesPolicy):
        self._RemoveOrphanFilesPolicy = RemoveOrphanFilesPolicy

    @property
    def MergeManifestsPolicy(self):
        return self._MergeManifestsPolicy

    @MergeManifestsPolicy.setter
    def MergeManifestsPolicy(self, MergeManifestsPolicy):
        self._MergeManifestsPolicy = MergeManifestsPolicy

    @property
    def InheritDataBase(self):
        return self._InheritDataBase

    @InheritDataBase.setter
    def InheritDataBase(self, InheritDataBase):
        self._InheritDataBase = InheritDataBase

    @property
    def RuleType(self):
        return self._RuleType

    @RuleType.setter
    def RuleType(self, RuleType):
        self._RuleType = RuleType

    @property
    def GovernEngine(self):
        return self._GovernEngine

    @GovernEngine.setter
    def GovernEngine(self, GovernEngine):
        self._GovernEngine = GovernEngine


    def _deserialize(self, params):
        if params.get("RewriteDataPolicy") is not None:
            self._RewriteDataPolicy = DlcRewriteDataInfo()
            self._RewriteDataPolicy._deserialize(params.get("RewriteDataPolicy"))
        if params.get("ExpiredSnapshotsPolicy") is not None:
            self._ExpiredSnapshotsPolicy = DlcExpiredSnapshotsInfo()
            self._ExpiredSnapshotsPolicy._deserialize(params.get("ExpiredSnapshotsPolicy"))
        if params.get("RemoveOrphanFilesPolicy") is not None:
            self._RemoveOrphanFilesPolicy = DlcRemoveOrphanFilesInfo()
            self._RemoveOrphanFilesPolicy._deserialize(params.get("RemoveOrphanFilesPolicy"))
        if params.get("MergeManifestsPolicy") is not None:
            self._MergeManifestsPolicy = DlcMergeManifestsInfo()
            self._MergeManifestsPolicy._deserialize(params.get("MergeManifestsPolicy"))
        self._InheritDataBase = params.get("InheritDataBase")
        self._RuleType = params.get("RuleType")
        self._GovernEngine = params.get("GovernEngine")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DlcExpiredSnapshotsInfo(AbstractModel):
    """Snapshot Expiration Governance Item

    """

    def __init__(self):
        r"""
        :param _ExpiredSnapshotsEnable: Whether to enable snapshot expiration governance: enable, none
Note: This field may return null, indicating that no valid value can be obtained.
        :type ExpiredSnapshotsEnable: str
        :param _Engine: Name of the engine used to run snapshot expiration governance
Note: This field may return null, indicating that no valid value can be obtained.
        :type Engine: str
        :param _RetainLast: Number of recent snapshots to retain
Note: This field may return null, indicating that no valid value can be obtained.
        :type RetainLast: int
        :param _BeforeDays: Snapshots expired before specified days
Note: This field may return null, indicating that no valid value can be obtained.
        :type BeforeDays: int
        :param _MaxConcurrentDeletes: Number of parallel processes for cleaning up expired snapshots
Note: This field may return null, indicating that no valid value can be obtained.
        :type MaxConcurrentDeletes: int
        :param _IntervalMin: Snapshot expiration governance run cycle, unit: minutes
Note: This field may return null, indicating that no valid value can be obtained.
        :type IntervalMin: int
        """
        self._ExpiredSnapshotsEnable = None
        self._Engine = None
        self._RetainLast = None
        self._BeforeDays = None
        self._MaxConcurrentDeletes = None
        self._IntervalMin = None

    @property
    def ExpiredSnapshotsEnable(self):
        return self._ExpiredSnapshotsEnable

    @ExpiredSnapshotsEnable.setter
    def ExpiredSnapshotsEnable(self, ExpiredSnapshotsEnable):
        self._ExpiredSnapshotsEnable = ExpiredSnapshotsEnable

    @property
    def Engine(self):
        return self._Engine

    @Engine.setter
    def Engine(self, Engine):
        self._Engine = Engine

    @property
    def RetainLast(self):
        return self._RetainLast

    @RetainLast.setter
    def RetainLast(self, RetainLast):
        self._RetainLast = RetainLast

    @property
    def BeforeDays(self):
        return self._BeforeDays

    @BeforeDays.setter
    def BeforeDays(self, BeforeDays):
        self._BeforeDays = BeforeDays

    @property
    def MaxConcurrentDeletes(self):
        return self._MaxConcurrentDeletes

    @MaxConcurrentDeletes.setter
    def MaxConcurrentDeletes(self, MaxConcurrentDeletes):
        self._MaxConcurrentDeletes = MaxConcurrentDeletes

    @property
    def IntervalMin(self):
        return self._IntervalMin

    @IntervalMin.setter
    def IntervalMin(self, IntervalMin):
        self._IntervalMin = IntervalMin


    def _deserialize(self, params):
        self._ExpiredSnapshotsEnable = params.get("ExpiredSnapshotsEnable")
        self._Engine = params.get("Engine")
        self._RetainLast = params.get("RetainLast")
        self._BeforeDays = params.get("BeforeDays")
        self._MaxConcurrentDeletes = params.get("MaxConcurrentDeletes")
        self._IntervalMin = params.get("IntervalMin")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DlcMergeManifestsInfo(AbstractModel):
    """Merge metadata Manifests governance items

    """

    def __init__(self):
        r"""
        :param _MergeManifestsEnable: Whether to enable merging metadata Manifests file governance items: enable, none
Note: This field may return null, indicating that no valid value can be obtained.
        :type MergeManifestsEnable: str
        :param _Engine: Engine name used to run merging metadata Manifests file governance items
Note: This field may return null, indicating that no valid value can be obtained.
        :type Engine: str
        :param _IntervalMin: Merge Metadata Manifests file governance runtime cycle, in minutes
Note: This field may return null, indicating that no valid value can be obtained.
        :type IntervalMin: int
        """
        self._MergeManifestsEnable = None
        self._Engine = None
        self._IntervalMin = None

    @property
    def MergeManifestsEnable(self):
        return self._MergeManifestsEnable

    @MergeManifestsEnable.setter
    def MergeManifestsEnable(self, MergeManifestsEnable):
        self._MergeManifestsEnable = MergeManifestsEnable

    @property
    def Engine(self):
        return self._Engine

    @Engine.setter
    def Engine(self, Engine):
        self._Engine = Engine

    @property
    def IntervalMin(self):
        return self._IntervalMin

    @IntervalMin.setter
    def IntervalMin(self, IntervalMin):
        self._IntervalMin = IntervalMin


    def _deserialize(self, params):
        self._MergeManifestsEnable = params.get("MergeManifestsEnable")
        self._Engine = params.get("Engine")
        self._IntervalMin = params.get("IntervalMin")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DlcRemoveOrphanFilesInfo(AbstractModel):
    """Remove Isolated Files Governance Item

    """

    def __init__(self):
        r"""
        :param _RemoveOrphanFilesEnable: Enable Removal of Isolated Files Governance Item: enable, none
Note: This field may return null, indicating that no valid value can be obtained.
        :type RemoveOrphanFilesEnable: str
        :param _Engine: Engine Name for Running Removal of Isolated Files Governance Item
Note: This field may return null, indicating that no valid value can be obtained.
        :type Engine: str
        :param _BeforeDays: Remove Isolated Files Older Than Specified Days
Note: This field may return null, indicating that no valid value can be obtained.
        :type BeforeDays: int
        :param _MaxConcurrentDeletes: Number of Concurrent Processes for Removing Isolated Files
Note: This field may return null, indicating that no valid value can be obtained.
        :type MaxConcurrentDeletes: int
        :param _IntervalMin: Isolated Files Governance Run Cycle, in minutes
Note: This field may return null, indicating that no valid value can be obtained.
        :type IntervalMin: int
        """
        self._RemoveOrphanFilesEnable = None
        self._Engine = None
        self._BeforeDays = None
        self._MaxConcurrentDeletes = None
        self._IntervalMin = None

    @property
    def RemoveOrphanFilesEnable(self):
        return self._RemoveOrphanFilesEnable

    @RemoveOrphanFilesEnable.setter
    def RemoveOrphanFilesEnable(self, RemoveOrphanFilesEnable):
        self._RemoveOrphanFilesEnable = RemoveOrphanFilesEnable

    @property
    def Engine(self):
        return self._Engine

    @Engine.setter
    def Engine(self, Engine):
        self._Engine = Engine

    @property
    def BeforeDays(self):
        return self._BeforeDays

    @BeforeDays.setter
    def BeforeDays(self, BeforeDays):
        self._BeforeDays = BeforeDays

    @property
    def MaxConcurrentDeletes(self):
        return self._MaxConcurrentDeletes

    @MaxConcurrentDeletes.setter
    def MaxConcurrentDeletes(self, MaxConcurrentDeletes):
        self._MaxConcurrentDeletes = MaxConcurrentDeletes

    @property
    def IntervalMin(self):
        return self._IntervalMin

    @IntervalMin.setter
    def IntervalMin(self, IntervalMin):
        self._IntervalMin = IntervalMin


    def _deserialize(self, params):
        self._RemoveOrphanFilesEnable = params.get("RemoveOrphanFilesEnable")
        self._Engine = params.get("Engine")
        self._BeforeDays = params.get("BeforeDays")
        self._MaxConcurrentDeletes = params.get("MaxConcurrentDeletes")
        self._IntervalMin = params.get("IntervalMin")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DlcRewriteDataInfo(AbstractModel):
    """Data Layout Governance Item

    """

    def __init__(self):
        r"""
        :param _RewriteDataEnable: Whether to enable data layout governance item: enable (start), disable (do not enable, default)
Note: This field may return null, indicating that no valid value can be obtained.
        :type RewriteDataEnable: str
        :param _Engine: Engine name used to run data layout governance item
Note: This field may return null, indicating that no valid value can be obtained.
        :type Engine: str
        :param _MinInputFiles: Number of files executed by the rearrangement task
Note: This field may return null, indicating that no valid value can be obtained.
        :type MinInputFiles: int
        :param _TargetFileSizeBytes: Data file size after data rearrangement, in bytes
Note: This field may return null, indicating that no valid value can be obtained.
        :type TargetFileSizeBytes: int
        :param _IntervalMin: Data layout governance runtime cycle, in minutes
Note: This field may return null, indicating that no valid value can be obtained.
        :type IntervalMin: int
        """
        self._RewriteDataEnable = None
        self._Engine = None
        self._MinInputFiles = None
        self._TargetFileSizeBytes = None
        self._IntervalMin = None

    @property
    def RewriteDataEnable(self):
        return self._RewriteDataEnable

    @RewriteDataEnable.setter
    def RewriteDataEnable(self, RewriteDataEnable):
        self._RewriteDataEnable = RewriteDataEnable

    @property
    def Engine(self):
        return self._Engine

    @Engine.setter
    def Engine(self, Engine):
        self._Engine = Engine

    @property
    def MinInputFiles(self):
        return self._MinInputFiles

    @MinInputFiles.setter
    def MinInputFiles(self, MinInputFiles):
        self._MinInputFiles = MinInputFiles

    @property
    def TargetFileSizeBytes(self):
        return self._TargetFileSizeBytes

    @TargetFileSizeBytes.setter
    def TargetFileSizeBytes(self, TargetFileSizeBytes):
        self._TargetFileSizeBytes = TargetFileSizeBytes

    @property
    def IntervalMin(self):
        return self._IntervalMin

    @IntervalMin.setter
    def IntervalMin(self, IntervalMin):
        self._IntervalMin = IntervalMin


    def _deserialize(self, params):
        self._RewriteDataEnable = params.get("RewriteDataEnable")
        self._Engine = params.get("Engine")
        self._MinInputFiles = params.get("MinInputFiles")
        self._TargetFileSizeBytes = params.get("TargetFileSizeBytes")
        self._IntervalMin = params.get("IntervalMin")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DrInstanceOpsDto(AbstractModel):
    """Trial Run Record

    """

    def __init__(self):
        r"""
        :param _TaskSource: Task Source
Note: This field may return null, indicating that no valid value can be obtained.
        :type TaskSource: str
        :param _JobId: Orchestration Space jobId
Note: This field may return null, indicating that no valid value can be obtained.
        :type JobId: str
        :param _RecordId: Task Submission Record Id
Note: This field may return null, indicating that no valid value can be obtained.
        :type RecordId: int
        :param _SonRecordId: Subtask record id
Note: This field may return null, indicating that no valid value can be obtained.
        :type SonRecordId: int
        :param _InstanceId: Task instance Id
Note: This field may return null, indicating that no valid value can be obtained.
        :type InstanceId: str
        :param _TaskId: For orchestration space, the task id; for development space, the script id
Note: This field may return null, indicating that no valid value can be obtained.
        :type TaskId: str
        :param _RemotePath: Script COS address
Note: This field may return null, indicating that no valid value can be obtained.
        :type RemotePath: str
        :param _ScriptContent: Trial run content
Note: This field may return null, indicating that no valid value can be obtained.
        :type ScriptContent: str
        :param _CreateTime: Task submission time
Note: This field may return null, indicating that no valid value can be obtained.
        :type CreateTime: str
        :param _StartTime: Task start time
Note: This field may return null, indicating that no valid value can be obtained.
        :type StartTime: str
        :param _Duration: Running duration (seconds)
Note: This field may return null, indicating that no valid value can be obtained.
        :type Duration: str
        :param _Status: Trial run status
Note: This field may return null, indicating that no valid value can be obtained.
        :type Status: str
        :param _TaskName: For orchestration space, the task name; for development space, the script name
Note: This field may return null, indicating that no valid value can be obtained.
        :type TaskName: str
        :param _SubmitUserName: Trial run submitter
Note: This field may return null, indicating that no valid value can be obtained.
        :type SubmitUserName: str
        :param _SubmitUserId: Trial run submitter userId
Note: This field may return null, indicating that no valid value can be obtained.
        :type SubmitUserId: str
        :param _TaskType: Task TypeNote: This field may return null, indicating that no valid value can be obtained.
        :type TaskType: str
        :param _HasResultSet: Contains result set
Note: This field may return null, indicating that no valid value can be obtained.
        :type HasResultSet: bool
        """
        self._TaskSource = None
        self._JobId = None
        self._RecordId = None
        self._SonRecordId = None
        self._InstanceId = None
        self._TaskId = None
        self._RemotePath = None
        self._ScriptContent = None
        self._CreateTime = None
        self._StartTime = None
        self._Duration = None
        self._Status = None
        self._TaskName = None
        self._SubmitUserName = None
        self._SubmitUserId = None
        self._TaskType = None
        self._HasResultSet = None

    @property
    def TaskSource(self):
        return self._TaskSource

    @TaskSource.setter
    def TaskSource(self, TaskSource):
        self._TaskSource = TaskSource

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RecordId(self):
        return self._RecordId

    @RecordId.setter
    def RecordId(self, RecordId):
        self._RecordId = RecordId

    @property
    def SonRecordId(self):
        return self._SonRecordId

    @SonRecordId.setter
    def SonRecordId(self, SonRecordId):
        self._SonRecordId = SonRecordId

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RemotePath(self):
        return self._RemotePath

    @RemotePath.setter
    def RemotePath(self, RemotePath):
        self._RemotePath = RemotePath

    @property
    def ScriptContent(self):
        return self._ScriptContent

    @ScriptContent.setter
    def ScriptContent(self, ScriptContent):
        self._ScriptContent = ScriptContent

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def Duration(self):
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def TaskName(self):
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def SubmitUserName(self):
        return self._SubmitUserName

    @SubmitUserName.setter
    def SubmitUserName(self, SubmitUserName):
        self._SubmitUserName = SubmitUserName

    @property
    def SubmitUserId(self):
        return self._SubmitUserId

    @SubmitUserId.setter
    def SubmitUserId(self, SubmitUserId):
        self._SubmitUserId = SubmitUserId

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def HasResultSet(self):
        return self._HasResultSet

    @HasResultSet.setter
    def HasResultSet(self, HasResultSet):
        self._HasResultSet = HasResultSet


    def _deserialize(self, params):
        self._TaskSource = params.get("TaskSource")
        self._JobId = params.get("JobId")
        self._RecordId = params.get("RecordId")
        self._SonRecordId = params.get("SonRecordId")
        self._InstanceId = params.get("InstanceId")
        self._TaskId = params.get("TaskId")
        self._RemotePath = params.get("RemotePath")
        self._ScriptContent = params.get("ScriptContent")
        self._CreateTime = params.get("CreateTime")
        self._StartTime = params.get("StartTime")
        self._Duration = params.get("Duration")
        self._Status = params.get("Status")
        self._TaskName = params.get("TaskName")
        self._SubmitUserName = params.get("SubmitUserName")
        self._SubmitUserId = params.get("SubmitUserId")
        self._TaskType = params.get("TaskType")
        self._HasResultSet = params.get("HasResultSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DrInstanceOpsDtoPage(AbstractModel):
    """Trial Run Record

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total Record Count
Note: This field may return null, indicating that no valid value can be obtained.
        :type TotalCount: int
        :param _Items: Record List
Note: This field may return null, indicating that no valid value can be obtained.
        :type Items: list of DrInstanceOpsDto
        """
        self._TotalCount = None
        self._Items = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = DrInstanceOpsDto()
                obj._deserialize(item)
                self._Items.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DryRunDIOfflineTaskRequest(AbstractModel):
    """DryRunDIOfflineTask request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID
        :type TaskId: str
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _ResourceGroup: Resource Group ID
        :type ResourceGroup: str
        :param _TaskTypeId: Default 27
        :type TaskTypeId: int
        """
        self._TaskId = None
        self._ProjectId = None
        self._ResourceGroup = None
        self._TaskTypeId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ResourceGroup(self):
        return self._ResourceGroup

    @ResourceGroup.setter
    def ResourceGroup(self, ResourceGroup):
        self._ResourceGroup = ResourceGroup

    @property
    def TaskTypeId(self):
        return self._TaskTypeId

    @TaskTypeId.setter
    def TaskTypeId(self, TaskTypeId):
        self._TaskTypeId = TaskTypeId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ProjectId = params.get("ProjectId")
        self._ResourceGroup = params.get("ResourceGroup")
        self._TaskTypeId = params.get("TaskTypeId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DryRunDIOfflineTaskResponse(AbstractModel):
    """DryRunDIOfflineTask response structure.

    """

    def __init__(self):
        r"""
        :param _CurrentRunDate: Data Timestamp
        :type CurrentRunDate: str
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _Status: Task Status
        :type Status: str
        :param _TaskId: Task ID
        :type TaskId: str
        :param _TaskInstanceKey: Unique Key for Task Instance
        :type TaskInstanceKey: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._CurrentRunDate = None
        self._ProjectId = None
        self._Status = None
        self._TaskId = None
        self._TaskInstanceKey = None
        self._RequestId = None

    @property
    def CurrentRunDate(self):
        return self._CurrentRunDate

    @CurrentRunDate.setter
    def CurrentRunDate(self, CurrentRunDate):
        self._CurrentRunDate = CurrentRunDate

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TaskInstanceKey(self):
        return self._TaskInstanceKey

    @TaskInstanceKey.setter
    def TaskInstanceKey(self, TaskInstanceKey):
        self._TaskInstanceKey = TaskInstanceKey

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._CurrentRunDate = params.get("CurrentRunDate")
        self._ProjectId = params.get("ProjectId")
        self._Status = params.get("Status")
        self._TaskId = params.get("TaskId")
        self._TaskInstanceKey = params.get("TaskInstanceKey")
        self._RequestId = params.get("RequestId")


class EventBatchCaseDTO(AbstractModel):
    """Event Continuous Time Instance Information

    """

    def __init__(self):
        r"""
        :param _CaseId: Event Instance ID
        :type CaseId: str
        :param _Name: Event
        :type Name: str
        :param _StartDimension: Event Trigger Start Time
        :type StartDimension: str
        :param _CreationTs: Creation Time
        :type CreationTs: str
        :param _ConsumerId: Consumer ID
        :type ConsumerId: str
        :param _Description: Description
        :type Description: str
        :param _EndDimension: Event Trigger End Time
        :type EndDimension: str
        :param _EventSubType: Event Cycle
        :type EventSubType: str
        """
        self._CaseId = None
        self._Name = None
        self._StartDimension = None
        self._CreationTs = None
        self._ConsumerId = None
        self._Description = None
        self._EndDimension = None
        self._EventSubType = None

    @property
    def CaseId(self):
        return self._CaseId

    @CaseId.setter
    def CaseId(self, CaseId):
        self._CaseId = CaseId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def StartDimension(self):
        return self._StartDimension

    @StartDimension.setter
    def StartDimension(self, StartDimension):
        self._StartDimension = StartDimension

    @property
    def CreationTs(self):
        return self._CreationTs

    @CreationTs.setter
    def CreationTs(self, CreationTs):
        self._CreationTs = CreationTs

    @property
    def ConsumerId(self):
        return self._ConsumerId

    @ConsumerId.setter
    def ConsumerId(self, ConsumerId):
        self._ConsumerId = ConsumerId

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def EndDimension(self):
        return self._EndDimension

    @EndDimension.setter
    def EndDimension(self, EndDimension):
        self._EndDimension = EndDimension

    @property
    def EventSubType(self):
        return self._EventSubType

    @EventSubType.setter
    def EventSubType(self, EventSubType):
        self._EventSubType = EventSubType


    def _deserialize(self, params):
        self._CaseId = params.get("CaseId")
        self._Name = params.get("Name")
        self._StartDimension = params.get("StartDimension")
        self._CreationTs = params.get("CreationTs")
        self._ConsumerId = params.get("ConsumerId")
        self._Description = params.get("Description")
        self._EndDimension = params.get("EndDimension")
        self._EventSubType = params.get("EventSubType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EventCaseAuditLogOptDto(AbstractModel):
    """Event Instance

    """

    def __init__(self):
        r"""
        :param _CaseId: Event Instance ID
Note: This field may return null, indicating that no valid value can be obtained.
        :type CaseId: str
        :param _EventName: Event nameNote: This field may return null, indicating that no valid value can be obtained.
        :type EventName: str
        :param _EventType: Event typeNote: This field may return null, indicating that no valid value can be obtained.
        :type EventType: str
        :param _EventSubType: Event Split Type
Note: This field may return null, indicating that no valid value can be obtained.
        :type EventSubType: str
        :param _EventBroadcastType: Event Broadcast Type
Note: This field may return null, indicating that no valid value can be obtained.
        :type EventBroadcastType: str
        :param _TTL: Event Instance TTL
Note: This field may return null, indicating that no valid value can be obtained.
        :type TTL: int
        :param _TimeUnit: Event Instance TTL Unit
Note: This field may return null, indicating that no valid value can be obtained.
        :type TimeUnit: str
        :param _Dimension: Data Time
Note: This field may return null, indicating that no valid value can be obtained.
        :type Dimension: str
        :param _Status: Event Instance Status
Note: This field may return null, indicating that no valid value can be obtained.
        :type Status: str
        :param _EventTriggerTimestamp: Event Instance Trigger Timestamp
Note: This field may return null, indicating that no valid value can be obtained.
        :type EventTriggerTimestamp: str
        :param _LogTimestamp: Event Instance Consumption Timestamp
Note: This field may return null, indicating that no valid value can be obtained.
        :type LogTimestamp: str
        :param _Description: Event Instance Description
Note: This field may return null, indicating that no valid value can be obtained.
        :type Description: str
        """
        self._CaseId = None
        self._EventName = None
        self._EventType = None
        self._EventSubType = None
        self._EventBroadcastType = None
        self._TTL = None
        self._TimeUnit = None
        self._Dimension = None
        self._Status = None
        self._EventTriggerTimestamp = None
        self._LogTimestamp = None
        self._Description = None

    @property
    def CaseId(self):
        return self._CaseId

    @CaseId.setter
    def CaseId(self, CaseId):
        self._CaseId = CaseId

    @property
    def EventName(self):
        return self._EventName

    @EventName.setter
    def EventName(self, EventName):
        self._EventName = EventName

    @property
    def EventType(self):
        return self._EventType

    @EventType.setter
    def EventType(self, EventType):
        self._EventType = EventType

    @property
    def EventSubType(self):
        return self._EventSubType

    @EventSubType.setter
    def EventSubType(self, EventSubType):
        self._EventSubType = EventSubType

    @property
    def EventBroadcastType(self):
        return self._EventBroadcastType

    @EventBroadcastType.setter
    def EventBroadcastType(self, EventBroadcastType):
        self._EventBroadcastType = EventBroadcastType

    @property
    def TTL(self):
        return self._TTL

    @TTL.setter
    def TTL(self, TTL):
        self._TTL = TTL

    @property
    def TimeUnit(self):
        return self._TimeUnit

    @TimeUnit.setter
    def TimeUnit(self, TimeUnit):
        self._TimeUnit = TimeUnit

    @property
    def Dimension(self):
        return self._Dimension

    @Dimension.setter
    def Dimension(self, Dimension):
        self._Dimension = Dimension

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def EventTriggerTimestamp(self):
        return self._EventTriggerTimestamp

    @EventTriggerTimestamp.setter
    def EventTriggerTimestamp(self, EventTriggerTimestamp):
        self._EventTriggerTimestamp = EventTriggerTimestamp

    @property
    def LogTimestamp(self):
        return self._LogTimestamp

    @LogTimestamp.setter
    def LogTimestamp(self, LogTimestamp):
        self._LogTimestamp = LogTimestamp

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._CaseId = params.get("CaseId")
        self._EventName = params.get("EventName")
        self._EventType = params.get("EventType")
        self._EventSubType = params.get("EventSubType")
        self._EventBroadcastType = params.get("EventBroadcastType")
        self._TTL = params.get("TTL")
        self._TimeUnit = params.get("TimeUnit")
        self._Dimension = params.get("Dimension")
        self._Status = params.get("Status")
        self._EventTriggerTimestamp = params.get("EventTriggerTimestamp")
        self._LogTimestamp = params.get("LogTimestamp")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EventCaseAuditLogVOCollection(AbstractModel):
    """Event Instance Pagination Query Results

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of resultsNote: This field may return null, indicating that no valid value can be obtained.
        :type TotalCount: int
        :param _TotalPage: Total PagesNote: This field may return null, indicating that no valid value can be obtained.
        :type TotalPage: int
        :param _PageCount: Number of records on current page
Note: This field may return null, indicating that no valid value can be obtained.
        :type PageCount: int
        :param _PageNumber: Page NumberNote: This field may return null, indicating that no valid value can be obtained.
        :type PageNumber: int
        :param _PageSize: Page sizeNote: This field may return null, indicating that no valid value can be obtained.
        :type PageSize: int
        :param _Items: Pagination Data
Note: This field may return null, indicating that no valid value can be obtained.
        :type Items: list of EventCaseAuditLogOptDto
        """
        self._TotalCount = None
        self._TotalPage = None
        self._PageCount = None
        self._PageNumber = None
        self._PageSize = None
        self._Items = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TotalPage(self):
        return self._TotalPage

    @TotalPage.setter
    def TotalPage(self, TotalPage):
        self._TotalPage = TotalPage

    @property
    def PageCount(self):
        return self._PageCount

    @PageCount.setter
    def PageCount(self, PageCount):
        self._PageCount = PageCount

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        self._TotalPage = params.get("TotalPage")
        self._PageCount = params.get("PageCount")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = EventCaseAuditLogOptDto()
                obj._deserialize(item)
                self._Items.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EventCaseConsumeLogOptDto(AbstractModel):
    """Event Consumption Record

    """

    def __init__(self):
        r"""
        :param _ConsumeLogId: Consumer ID\nNote: This field may return null, indicating that no valid value can be obtained.
        :type ConsumeLogId: str
        :param _EventCaseId: Event Case ID\nNote: This field may return null, indicating that no valid value can be obtained.
        :type EventCaseId: str
        :param _ConsumerId: Consumer ID\nNote: This field may return null, indicating that no valid value can be obtained.
        :type ConsumerId: str
        :param _CreationTimestamp: Consumption Timestamp\nNote: This field may return null, indicating that no valid value can be obtained.
        :type CreationTimestamp: str
        :param _ConsumerDetail: Task DetailsNote: This field may return null, indicating that no valid value can be obtained.
        :type ConsumerDetail: :class:`tencentcloud.wedata.v20210820.models.TaskOpsDto`
        """
        self._ConsumeLogId = None
        self._EventCaseId = None
        self._ConsumerId = None
        self._CreationTimestamp = None
        self._ConsumerDetail = None

    @property
    def ConsumeLogId(self):
        return self._ConsumeLogId

    @ConsumeLogId.setter
    def ConsumeLogId(self, ConsumeLogId):
        self._ConsumeLogId = ConsumeLogId

    @property
    def EventCaseId(self):
        return self._EventCaseId

    @EventCaseId.setter
    def EventCaseId(self, EventCaseId):
        self._EventCaseId = EventCaseId

    @property
    def ConsumerId(self):
        return self._ConsumerId

    @ConsumerId.setter
    def ConsumerId(self, ConsumerId):
        self._ConsumerId = ConsumerId

    @property
    def CreationTimestamp(self):
        return self._CreationTimestamp

    @CreationTimestamp.setter
    def CreationTimestamp(self, CreationTimestamp):
        self._CreationTimestamp = CreationTimestamp

    @property
    def ConsumerDetail(self):
        return self._ConsumerDetail

    @ConsumerDetail.setter
    def ConsumerDetail(self, ConsumerDetail):
        self._ConsumerDetail = ConsumerDetail


    def _deserialize(self, params):
        self._ConsumeLogId = params.get("ConsumeLogId")
        self._EventCaseId = params.get("EventCaseId")
        self._ConsumerId = params.get("ConsumerId")
        self._CreationTimestamp = params.get("CreationTimestamp")
        if params.get("ConsumerDetail") is not None:
            self._ConsumerDetail = TaskOpsDto()
            self._ConsumerDetail._deserialize(params.get("ConsumerDetail"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EventCaseConsumeLogOptDtoCollection(AbstractModel):
    """Event Consumption Task Record List

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of resultsNote: This field may return null, indicating that no valid value can be obtained.
        :type TotalCount: int
        :param _TotalPage: Total Number of Pages
Note: This field may return null, indicating that no valid value can be obtained.
        :type TotalPage: int
        :param _PageCount: Number of Results on Current Page
Note: This field may return null, indicating that no valid value can be obtained.
        :type PageCount: int
        :param _PageNumber: Page NumberNote: This field may return null, indicating that no valid value can be obtained.
        :type PageNumber: int
        :param _PageSize: Number of items per pageNote: This field may return null, indicating that no valid value can be obtained.
        :type PageSize: int
        :param _Items: Pagination Data
Note: This field may return null, indicating that no valid value can be obtained.
        :type Items: list of EventCaseConsumeLogOptDto
        """
        self._TotalCount = None
        self._TotalPage = None
        self._PageCount = None
        self._PageNumber = None
        self._PageSize = None
        self._Items = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TotalPage(self):
        return self._TotalPage

    @TotalPage.setter
    def TotalPage(self, TotalPage):
        self._TotalPage = TotalPage

    @property
    def PageCount(self):
        return self._PageCount

    @PageCount.setter
    def PageCount(self, PageCount):
        self._PageCount = PageCount

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        self._TotalPage = params.get("TotalPage")
        self._PageCount = params.get("PageCount")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = EventCaseConsumeLogOptDto()
                obj._deserialize(item)
                self._Items.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EventCaseDTO(AbstractModel):
    """Event Instance Information

    """

    def __init__(self):
        r"""
        :param _CaseId: Event Instance ID
        :type CaseId: str
        :param _Name: Event
        :type Name: str
        :param _Dimension: Event Format
        :type Dimension: str
        :param _CreationTs: Creation Time
        :type CreationTs: str
        :param _ConsumerId: Consumer ID
        :type ConsumerId: str
        :param _Description: Description
        :type Description: str
        """
        self._CaseId = None
        self._Name = None
        self._Dimension = None
        self._CreationTs = None
        self._ConsumerId = None
        self._Description = None

    @property
    def CaseId(self):
        return self._CaseId

    @CaseId.setter
    def CaseId(self, CaseId):
        self._CaseId = CaseId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Dimension(self):
        return self._Dimension

    @Dimension.setter
    def Dimension(self, Dimension):
        self._Dimension = Dimension

    @property
    def CreationTs(self):
        return self._CreationTs

    @CreationTs.setter
    def CreationTs(self, CreationTs):
        self._CreationTs = CreationTs

    @property
    def ConsumerId(self):
        return self._ConsumerId

    @ConsumerId.setter
    def ConsumerId(self, ConsumerId):
        self._ConsumerId = ConsumerId

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._CaseId = params.get("CaseId")
        self._Name = params.get("Name")
        self._Dimension = params.get("Dimension")
        self._CreationTs = params.get("CreationTs")
        self._ConsumerId = params.get("ConsumerId")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EventCaseOpsDto(AbstractModel):
    """EventCaseOpsDto

    """

    def __init__(self):
        r"""
        :param _CaseId: Case ID
Note: This field may return null, indicating that no valid value can be obtained.
        :type CaseId: str
        :param _Name: Case Name
Note: This field may return null, indicating that no valid value can be obtained.
        :type Name: str
        :param _Dimension: time format
Note: This field may return null, indicating that no valid value can be obtained.
        :type Dimension: str
        :param _CreationTimestamp: Creation TimeNote: This field may return null, indicating that no valid value can be obtained.
        :type CreationTimestamp: str
        :param _ConsumerId: Consumer ID
Note: This field may return null, indicating that no valid value can be obtained.
        :type ConsumerId: str
        :param _Description: DescriptionNote: This field may return null, indicating that no valid value can be obtained.
        :type Description: str
        """
        self._CaseId = None
        self._Name = None
        self._Dimension = None
        self._CreationTimestamp = None
        self._ConsumerId = None
        self._Description = None

    @property
    def CaseId(self):
        return self._CaseId

    @CaseId.setter
    def CaseId(self, CaseId):
        self._CaseId = CaseId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Dimension(self):
        return self._Dimension

    @Dimension.setter
    def Dimension(self, Dimension):
        self._Dimension = Dimension

    @property
    def CreationTimestamp(self):
        return self._CreationTimestamp

    @CreationTimestamp.setter
    def CreationTimestamp(self, CreationTimestamp):
        self._CreationTimestamp = CreationTimestamp

    @property
    def ConsumerId(self):
        return self._ConsumerId

    @ConsumerId.setter
    def ConsumerId(self, ConsumerId):
        self._ConsumerId = ConsumerId

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._CaseId = params.get("CaseId")
        self._Name = params.get("Name")
        self._Dimension = params.get("Dimension")
        self._CreationTimestamp = params.get("CreationTimestamp")
        self._ConsumerId = params.get("ConsumerId")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EventListenerOpsDto(AbstractModel):
    """Event Listener

    """

    def __init__(self):
        r"""
        :param _EventName: Event nameNote: This field may return null, indicating that no valid value can be obtained.
        :type EventName: str
        :param _Key: Keyword, if it is a task, then it is the Task ID
Note: This field may return null, indicating that no valid value can be obtained.
        :type Key: str
        :param _Type: Trigger methodNote: This field may return null, indicating that no valid value can be obtained.
        :type Type: str
        :param _Properties: Event Attributes
Note: This field may return null, indicating that no valid value can be obtained.
        :type Properties: str
        :param _CreationTimestamp: Creation TimeNote: This field may return null, indicating that no valid value can be obtained.
        :type CreationTimestamp: str
        """
        self._EventName = None
        self._Key = None
        self._Type = None
        self._Properties = None
        self._CreationTimestamp = None

    @property
    def EventName(self):
        return self._EventName

    @EventName.setter
    def EventName(self, EventName):
        self._EventName = EventName

    @property
    def Key(self):
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Properties(self):
        return self._Properties

    @Properties.setter
    def Properties(self, Properties):
        self._Properties = Properties

    @property
    def CreationTimestamp(self):
        return self._CreationTimestamp

    @CreationTimestamp.setter
    def CreationTimestamp(self, CreationTimestamp):
        self._CreationTimestamp = CreationTimestamp


    def _deserialize(self, params):
        self._EventName = params.get("EventName")
        self._Key = params.get("Key")
        self._Type = params.get("Type")
        self._Properties = params.get("Properties")
        self._CreationTimestamp = params.get("CreationTimestamp")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EventOpsDto(AbstractModel):
    """Event details

    """

    def __init__(self):
        r"""
        :param _Name: Event nameNote: This field may return null, indicating that no valid value can be obtained.
        :type Name: str
        :param _EventType: Event typeNote: This field may return null, indicating that no valid value can be obtained.
        :type EventType: str
        :param _EventSubType: Event Segmentation TypeNote: This field may return null, indicating that no valid value can be obtained.
        :type EventSubType: str
        :param _EventBroadcastType: Event Broadcast TypeNote: This field may return null, indicating that no valid value can be obtained.
        :type EventBroadcastType: str
        :param _DimensionFormat: Data Time Format
Note: This field may return null, indicating that no valid value can be obtained.
        :type DimensionFormat: str
        :param _TimeToLive: UptimeNote: This field may return null, indicating that no valid value can be obtained.
        :type TimeToLive: int
        :param _TimeUnit: Lifetime Unit
Note: This field may return null, indicating that no valid value can be obtained.
        :type TimeUnit: str
        :param _CreationTimestamp: Creation Timestamp
Note: This field may return null, indicating that no valid value can be obtained.
        :type CreationTimestamp: str
        :param _Owner: Owner
Note: This field may return null, indicating that no valid value can be obtained.
        :type Owner: str
        :param _Properties: AttributeNote: This field may return null, indicating that no valid value can be obtained.
        :type Properties: str
        :param _Description: DescriptionNote: This field may return null, indicating that no valid value can be obtained.
        :type Description: str
        :param _Listeners: Listener
Note: This field may return null, indicating that no valid value can be obtained.
        :type Listeners: list of EventListenerOpsDto
        :param _EventCases: Incident Case
Note: This field may return null, indicating that no valid value can be obtained.
        :type EventCases: list of EventCaseOpsDto
        """
        self._Name = None
        self._EventType = None
        self._EventSubType = None
        self._EventBroadcastType = None
        self._DimensionFormat = None
        self._TimeToLive = None
        self._TimeUnit = None
        self._CreationTimestamp = None
        self._Owner = None
        self._Properties = None
        self._Description = None
        self._Listeners = None
        self._EventCases = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def EventType(self):
        return self._EventType

    @EventType.setter
    def EventType(self, EventType):
        self._EventType = EventType

    @property
    def EventSubType(self):
        return self._EventSubType

    @EventSubType.setter
    def EventSubType(self, EventSubType):
        self._EventSubType = EventSubType

    @property
    def EventBroadcastType(self):
        return self._EventBroadcastType

    @EventBroadcastType.setter
    def EventBroadcastType(self, EventBroadcastType):
        self._EventBroadcastType = EventBroadcastType

    @property
    def DimensionFormat(self):
        return self._DimensionFormat

    @DimensionFormat.setter
    def DimensionFormat(self, DimensionFormat):
        self._DimensionFormat = DimensionFormat

    @property
    def TimeToLive(self):
        return self._TimeToLive

    @TimeToLive.setter
    def TimeToLive(self, TimeToLive):
        self._TimeToLive = TimeToLive

    @property
    def TimeUnit(self):
        return self._TimeUnit

    @TimeUnit.setter
    def TimeUnit(self, TimeUnit):
        self._TimeUnit = TimeUnit

    @property
    def CreationTimestamp(self):
        return self._CreationTimestamp

    @CreationTimestamp.setter
    def CreationTimestamp(self, CreationTimestamp):
        self._CreationTimestamp = CreationTimestamp

    @property
    def Owner(self):
        return self._Owner

    @Owner.setter
    def Owner(self, Owner):
        self._Owner = Owner

    @property
    def Properties(self):
        return self._Properties

    @Properties.setter
    def Properties(self, Properties):
        self._Properties = Properties

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Listeners(self):
        return self._Listeners

    @Listeners.setter
    def Listeners(self, Listeners):
        self._Listeners = Listeners

    @property
    def EventCases(self):
        return self._EventCases

    @EventCases.setter
    def EventCases(self, EventCases):
        self._EventCases = EventCases


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._EventType = params.get("EventType")
        self._EventSubType = params.get("EventSubType")
        self._EventBroadcastType = params.get("EventBroadcastType")
        self._DimensionFormat = params.get("DimensionFormat")
        self._TimeToLive = params.get("TimeToLive")
        self._TimeUnit = params.get("TimeUnit")
        self._CreationTimestamp = params.get("CreationTimestamp")
        self._Owner = params.get("Owner")
        self._Properties = params.get("Properties")
        self._Description = params.get("Description")
        if params.get("Listeners") is not None:
            self._Listeners = []
            for item in params.get("Listeners"):
                obj = EventListenerOpsDto()
                obj._deserialize(item)
                self._Listeners.append(obj)
        if params.get("EventCases") is not None:
            self._EventCases = []
            for item in params.get("EventCases"):
                obj = EventCaseOpsDto()
                obj._deserialize(item)
                self._EventCases.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FailMessage(AbstractModel):
    """Error Handling Result Information

    """

    def __init__(self):
        r"""
        :param _Key: Unique Data Identifier
Note: This field may return null, indicating that no valid value can be obtained.
        :type Key: str
        :param _ErrorMessage: Failure Reason
Note: This field may return null, indicating that no valid value can be obtained.
        :type ErrorMessage: str
        """
        self._Key = None
        self._ErrorMessage = None

    @property
    def Key(self):
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key

    @property
    def ErrorMessage(self):
        return self._ErrorMessage

    @ErrorMessage.setter
    def ErrorMessage(self, ErrorMessage):
        self._ErrorMessage = ErrorMessage


    def _deserialize(self, params):
        self._Key = params.get("Key")
        self._ErrorMessage = params.get("ErrorMessage")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FieldConfig(AbstractModel):
    """Field Variable

    """

    def __init__(self):
        r"""
        :param _FieldKey: Field key
Note: This field may return null, indicating that no valid value can be obtained.
        :type FieldKey: str
        :param _FieldValue: Field valueNote: This field may return null, indicating that no valid value can be obtained.
        :type FieldValue: str
        :param _FieldDataType: Field Value Type
Note: This field may return null, indicating that no valid value can be obtained.
        :type FieldDataType: str
        """
        self._FieldKey = None
        self._FieldValue = None
        self._FieldDataType = None

    @property
    def FieldKey(self):
        return self._FieldKey

    @FieldKey.setter
    def FieldKey(self, FieldKey):
        self._FieldKey = FieldKey

    @property
    def FieldValue(self):
        return self._FieldValue

    @FieldValue.setter
    def FieldValue(self, FieldValue):
        self._FieldValue = FieldValue

    @property
    def FieldDataType(self):
        return self._FieldDataType

    @FieldDataType.setter
    def FieldDataType(self, FieldDataType):
        self._FieldDataType = FieldDataType


    def _deserialize(self, params):
        self._FieldKey = params.get("FieldKey")
        self._FieldValue = params.get("FieldValue")
        self._FieldDataType = params.get("FieldDataType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Filter(AbstractModel):
    """Universal Filter

    """

    def __init__(self):
        r"""
        :param _Name: Filter Field Name
        :type Name: str
        :param _Values: Filter Value List
        :type Values: list of str
        """
        self._Name = None
        self._Values = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Values(self):
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Values = params.get("Values")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FilterOptional(AbstractModel):
    """Universal Filter

    """

    def __init__(self):
        r"""
        :param _Name: Filter Field Name
        :type Name: str
        :param _Values: Filter Value List
        :type Values: list of str
        """
        self._Name = None
        self._Values = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Values(self):
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Values = params.get("Values")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FindAllFolderRequest(AbstractModel):
    """FindAllFolder request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        """
        self._ProjectId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FindAllFolderResponse(AbstractModel):
    """FindAllFolder response structure.

    """

    def __init__(self):
        r"""
        :param _FolderList: Folder ListNote: This field may return null, indicating that no valid value can be obtained.
        :type FolderList: list of FolderDsDto
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FolderList = None
        self._RequestId = None

    @property
    def FolderList(self):
        return self._FolderList

    @FolderList.setter
    def FolderList(self, FolderList):
        self._FolderList = FolderList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("FolderList") is not None:
            self._FolderList = []
            for item in params.get("FolderList"):
                obj = FolderDsDto()
                obj._deserialize(item)
                self._FolderList.append(obj)
        self._RequestId = params.get("RequestId")


class FolderDsDto(AbstractModel):
    """Folder Attributes

    """

    def __init__(self):
        r"""
        :param _Id: Folder ID
Note: This field may return null, indicating that no valid value can be obtained.
        :type Id: str
        :param _CreateTime: Creation TimeNote: This field may return null, indicating that no valid value can be obtained.
        :type CreateTime: str
        :param _Name: Folder NameNote: This field may return null, indicating that no valid value can be obtained.
        :type Name: str
        :param _ProjectId: Project ID
Note: This field may return null, indicating that no valid value can be obtained.
        :type ProjectId: str
        :param _UpdateTime: Update timeNote: This field may return null, indicating that no valid value can be obtained.
        :type UpdateTime: str
        :param _ParentsFolderId: Parent Folder ID
Note: This field may return null, indicating that no valid value can be obtained.
        :type ParentsFolderId: str
        :param _Total: Total Workflows
Note: This field may return null, indicating that no valid value can be obtained.
        :type Total: int
        :param _Workflows: Workflow ListNote: This field may return null, indicating that no valid value can be obtained.
        :type Workflows: list of WorkflowCanvasOpsDto
        :param _TotalFolders: Total Subfolders
Note: This field may return null, indicating that no valid value can be obtained.
        :type TotalFolders: int
        :param _Folders: Subfolder List
Note: This field may return null, indicating that no valid value can be obtained.
        :type Folders: list of FolderDsDto
        :param _FindType: Search typeNote: This field may return null, indicating that no valid value can be obtained.
        :type FindType: str
        """
        self._Id = None
        self._CreateTime = None
        self._Name = None
        self._ProjectId = None
        self._UpdateTime = None
        self._ParentsFolderId = None
        self._Total = None
        self._Workflows = None
        self._TotalFolders = None
        self._Folders = None
        self._FindType = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def ParentsFolderId(self):
        return self._ParentsFolderId

    @ParentsFolderId.setter
    def ParentsFolderId(self, ParentsFolderId):
        self._ParentsFolderId = ParentsFolderId

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Workflows(self):
        return self._Workflows

    @Workflows.setter
    def Workflows(self, Workflows):
        self._Workflows = Workflows

    @property
    def TotalFolders(self):
        return self._TotalFolders

    @TotalFolders.setter
    def TotalFolders(self, TotalFolders):
        self._TotalFolders = TotalFolders

    @property
    def Folders(self):
        return self._Folders

    @Folders.setter
    def Folders(self, Folders):
        self._Folders = Folders

    @property
    def FindType(self):
        return self._FindType

    @FindType.setter
    def FindType(self, FindType):
        self._FindType = FindType


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._CreateTime = params.get("CreateTime")
        self._Name = params.get("Name")
        self._ProjectId = params.get("ProjectId")
        self._UpdateTime = params.get("UpdateTime")
        self._ParentsFolderId = params.get("ParentsFolderId")
        self._Total = params.get("Total")
        if params.get("Workflows") is not None:
            self._Workflows = []
            for item in params.get("Workflows"):
                obj = WorkflowCanvasOpsDto()
                obj._deserialize(item)
                self._Workflows.append(obj)
        self._TotalFolders = params.get("TotalFolders")
        if params.get("Folders") is not None:
            self._Folders = []
            for item in params.get("Folders"):
                obj = FolderDsDto()
                obj._deserialize(item)
                self._Folders.append(obj)
        self._FindType = params.get("FindType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FolderOpsDto(AbstractModel):
    """Folder Attributes

    """

    def __init__(self):
        r"""
        :param _Id: Folder IDNote: This field may return null, indicating that no valid value can be obtained.
        :type Id: str
        :param _CreateTime: Creation TimeNote: This field may return null, indicating that no valid value can be obtained.
        :type CreateTime: str
        :param _Name: Folder NameNote: This field may return null, indicating that no valid value can be obtained.
        :type Name: str
        :param _ProjectId: Project ID
Note: This field may return null, indicating that no valid value can be obtained.
        :type ProjectId: str
        :param _UpdateTime: Update timeNote: This field may return null, indicating that no valid value can be obtained.
        :type UpdateTime: str
        :param _ParentsFolderId: Parent Folder ID
Note: This field may return null, indicating that no valid value can be obtained.
        :type ParentsFolderId: str
        :param _Total: Total Workflows
Note: This field may return null, indicating that no valid value can be obtained.
        :type Total: int
        :param _Workflows: Workflow ListNote: This field may return null, indicating that no valid value can be obtained.
        :type Workflows: list of WorkflowCanvasOpsDto
        :param _TotalFolders: Total Subfolders
Note: This field may return null, indicating that no valid value can be obtained.
        :type TotalFolders: int
        :param _FoldersList: Subfolder List
Note: This field may return null, indicating that no valid value can be obtained.
        :type FoldersList: str
        :param _FindType: Search typeNote: This field may return null, indicating that no valid value can be obtained.
        :type FindType: str
        """
        self._Id = None
        self._CreateTime = None
        self._Name = None
        self._ProjectId = None
        self._UpdateTime = None
        self._ParentsFolderId = None
        self._Total = None
        self._Workflows = None
        self._TotalFolders = None
        self._FoldersList = None
        self._FindType = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def ParentsFolderId(self):
        return self._ParentsFolderId

    @ParentsFolderId.setter
    def ParentsFolderId(self, ParentsFolderId):
        self._ParentsFolderId = ParentsFolderId

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Workflows(self):
        return self._Workflows

    @Workflows.setter
    def Workflows(self, Workflows):
        self._Workflows = Workflows

    @property
    def TotalFolders(self):
        return self._TotalFolders

    @TotalFolders.setter
    def TotalFolders(self, TotalFolders):
        self._TotalFolders = TotalFolders

    @property
    def FoldersList(self):
        return self._FoldersList

    @FoldersList.setter
    def FoldersList(self, FoldersList):
        self._FoldersList = FoldersList

    @property
    def FindType(self):
        return self._FindType

    @FindType.setter
    def FindType(self, FindType):
        self._FindType = FindType


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._CreateTime = params.get("CreateTime")
        self._Name = params.get("Name")
        self._ProjectId = params.get("ProjectId")
        self._UpdateTime = params.get("UpdateTime")
        self._ParentsFolderId = params.get("ParentsFolderId")
        self._Total = params.get("Total")
        if params.get("Workflows") is not None:
            self._Workflows = []
            for item in params.get("Workflows"):
                obj = WorkflowCanvasOpsDto()
                obj._deserialize(item)
                self._Workflows.append(obj)
        self._TotalFolders = params.get("TotalFolders")
        self._FoldersList = params.get("FoldersList")
        self._FindType = params.get("FindType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FreezeOpsTasksRequest(AbstractModel):
    """FreezeOpsTasks request structure.

    """

    def __init__(self):
        r"""
        :param _Tasks: Task List
        :type Tasks: list of SimpleTaskInfo
        :param _OperateIsInform: Whether Task Operation Notifies Downstream Task Owners
        :type OperateIsInform: bool
        :param _KillInstance: Whether to terminate the generated instance
        :type KillInstance: bool
        """
        self._Tasks = None
        self._OperateIsInform = None
        self._KillInstance = None

    @property
    def Tasks(self):
        return self._Tasks

    @Tasks.setter
    def Tasks(self, Tasks):
        self._Tasks = Tasks

    @property
    def OperateIsInform(self):
        return self._OperateIsInform

    @OperateIsInform.setter
    def OperateIsInform(self, OperateIsInform):
        self._OperateIsInform = OperateIsInform

    @property
    def KillInstance(self):
        return self._KillInstance

    @KillInstance.setter
    def KillInstance(self, KillInstance):
        self._KillInstance = KillInstance


    def _deserialize(self, params):
        if params.get("Tasks") is not None:
            self._Tasks = []
            for item in params.get("Tasks"):
                obj = SimpleTaskInfo()
                obj._deserialize(item)
                self._Tasks.append(obj)
        self._OperateIsInform = params.get("OperateIsInform")
        self._KillInstance = params.get("KillInstance")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FreezeOpsTasksResponse(AbstractModel):
    """FreezeOpsTasks response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Operation result
        :type Data: bool
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class FreezeTasksByWorkflowIdsRequest(AbstractModel):
    """FreezeTasksByWorkflowIds request structure.

    """

    def __init__(self):
        r"""
        :param _WorkflowIds: Workflow ID List
        :type WorkflowIds: list of str
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _KillInstance: Whether to terminate the generated instance
        :type KillInstance: bool
        """
        self._WorkflowIds = None
        self._ProjectId = None
        self._KillInstance = None

    @property
    def WorkflowIds(self):
        return self._WorkflowIds

    @WorkflowIds.setter
    def WorkflowIds(self, WorkflowIds):
        self._WorkflowIds = WorkflowIds

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def KillInstance(self):
        return self._KillInstance

    @KillInstance.setter
    def KillInstance(self, KillInstance):
        self._KillInstance = KillInstance


    def _deserialize(self, params):
        self._WorkflowIds = params.get("WorkflowIds")
        self._ProjectId = params.get("ProjectId")
        self._KillInstance = params.get("KillInstance")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FreezeTasksByWorkflowIdsResponse(AbstractModel):
    """FreezeTasksByWorkflowIds response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Operation ResultNote: This field may return null, indicating that no valid value can be obtained.
        :type Data: :class:`tencentcloud.wedata.v20210820.models.OperationOpsDto`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = OperationOpsDto()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class FunctionResource(AbstractModel):
    """Function Resource Information

    """

    def __init__(self):
        r"""
        :param _Path: Resource PathNote: This field may return null, indicating that no valid value can be obtained.
        :type Path: str
        :param _Name: NoNote: This field may return null, indicating that no valid value can be obtained.
        :type Name: str
        :param _Id: Resource Unique Identifier
        :type Id: str
        :param _Md5: Resource MD5 Value
Note: This field may return null, indicating that no valid value can be obtained.
        :type Md5: str
        :param _Type: Default is HDFS
Note: This field may return null, indicating that no valid value can be obtained.
        :type Type: str
        """
        self._Path = None
        self._Name = None
        self._Id = None
        self._Md5 = None
        self._Type = None

    @property
    def Path(self):
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Md5(self):
        return self._Md5

    @Md5.setter
    def Md5(self, Md5):
        self._Md5 = Md5

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Path = params.get("Path")
        self._Name = params.get("Name")
        self._Id = params.get("Id")
        self._Md5 = params.get("Md5")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FunctionTypeOrKind(AbstractModel):
    """Function Type or Function Classification

    """

    def __init__(self):
        r"""
        :param _Name: Name
        :type Name: str
        :param _ZhName: Function Classification English Name
        :type ZhName: str
        :param _EnName: Function Classification Chinese Name
        :type EnName: str
        """
        self._Name = None
        self._ZhName = None
        self._EnName = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def ZhName(self):
        return self._ZhName

    @ZhName.setter
    def ZhName(self, ZhName):
        self._ZhName = ZhName

    @property
    def EnName(self):
        return self._EnName

    @EnName.setter
    def EnName(self, EnName):
        self._EnName = EnName


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._ZhName = params.get("ZhName")
        self._EnName = params.get("EnName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FunctionVersion(AbstractModel):
    """Function Submission Version Information

    """

    def __init__(self):
        r"""
        :param _Tag: Version number: V0 V1 V2
        :type Tag: str
        :param _UserId: Submitter ID
        :type UserId: str
        :param _Type: Change Type: ADD, MODIFY
        :type Type: str
        :param _Comment: Remarks
        :type Comment: str
        :param _Timestamp: Submission Time: UTC Seconds
        :type Timestamp: str
        :param _UserName: Submitter Name
Note: This field may return null, indicating that no valid value can be obtained.
        :type UserName: str
        :param _Content: Version Information: json string format
Note: This field may return null, indicating that no valid value can be obtained.
        :type Content: str
        """
        self._Tag = None
        self._UserId = None
        self._Type = None
        self._Comment = None
        self._Timestamp = None
        self._UserName = None
        self._Content = None

    @property
    def Tag(self):
        return self._Tag

    @Tag.setter
    def Tag(self, Tag):
        self._Tag = Tag

    @property
    def UserId(self):
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def Timestamp(self):
        return self._Timestamp

    @Timestamp.setter
    def Timestamp(self, Timestamp):
        self._Timestamp = Timestamp

    @property
    def UserName(self):
        return self._UserName

    @UserName.setter
    def UserName(self, UserName):
        self._UserName = UserName

    @property
    def Content(self):
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content


    def _deserialize(self, params):
        self._Tag = params.get("Tag")
        self._UserId = params.get("UserId")
        self._Type = params.get("Type")
        self._Comment = params.get("Comment")
        self._Timestamp = params.get("Timestamp")
        self._UserName = params.get("UserName")
        self._Content = params.get("Content")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GenHiveTableDDLSqlRequest(AbstractModel):
    """GenHiveTableDDLSql request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _SinkDatabase: Target Database
        :type SinkDatabase: str
        :param _Id: Node ID
        :type Id: str
        :param _MsType: Metadata Type (MYSQL,ORACLE)
        :type MsType: str
        :param _DatasourceId: Data source ID
        :type DatasourceId: str
        :param _SourceDatabase: Source Library Name
        :type SourceDatabase: str
        :param _TableName: Source Table Name
        :type TableName: str
        :param _SinkType: Target Table Metadata Type (HIVE,GBASE)
        :type SinkType: str
        :param _SchemaName: Source Schema Name
        :type SchemaName: str
        :param _SourceFieldInfoList: Field Information of Upstream Node
        :type SourceFieldInfoList: list of SourceFieldInfo
        :param _Partitions: Partition Field
        :type Partitions: list of Partition
        :param _Properties: Table Creation Attributes
        :type Properties: list of Property
        :param _TableMode: Table Creation Mode,0: Wizard Mode,1: ddl
        :type TableMode: int
        :param _TableVersion: DLC Table Version, v1/v2
        :type TableVersion: str
        :param _UpsertFlag: Whether to Upsert Writes
        :type UpsertFlag: bool
        :param _TableComment: Table Description Information
        :type TableComment: str
        :param _AddDataFiles: Threshold for Increased Number of Files, Exceeding Value Will Trigger Small File Merge
        :type AddDataFiles: int
        :param _AddEqualityDeletes: Threshold for Increased Number of Equality Deletes, Exceeding Value Will Trigger Small File Merge
        :type AddEqualityDeletes: int
        :param _AddPositionDeletes: Threshold for Increased Number of Position Deletes, Exceeding Value Will Trigger Small File Merge
        :type AddPositionDeletes: int
        :param _AddDeleteFiles: Threshold for Increased Number of Delete Files
        :type AddDeleteFiles: int
        :param _TargetDatasourceId: Downstream Node Data Source ID
        :type TargetDatasourceId: str
        :param _UpsertKeys: DLC Upsert Primary Key
        :type UpsertKeys: list of str
        :param _TableBaseInfo: DLC Table Governance Information
        :type TableBaseInfo: :class:`tencentcloud.wedata.v20210820.models.TableBaseInfo`
        :param _SinkSchemaName: Target Schema Name
        :type SinkSchemaName: str
        """
        self._ProjectId = None
        self._SinkDatabase = None
        self._Id = None
        self._MsType = None
        self._DatasourceId = None
        self._SourceDatabase = None
        self._TableName = None
        self._SinkType = None
        self._SchemaName = None
        self._SourceFieldInfoList = None
        self._Partitions = None
        self._Properties = None
        self._TableMode = None
        self._TableVersion = None
        self._UpsertFlag = None
        self._TableComment = None
        self._AddDataFiles = None
        self._AddEqualityDeletes = None
        self._AddPositionDeletes = None
        self._AddDeleteFiles = None
        self._TargetDatasourceId = None
        self._UpsertKeys = None
        self._TableBaseInfo = None
        self._SinkSchemaName = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def SinkDatabase(self):
        return self._SinkDatabase

    @SinkDatabase.setter
    def SinkDatabase(self, SinkDatabase):
        self._SinkDatabase = SinkDatabase

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def MsType(self):
        return self._MsType

    @MsType.setter
    def MsType(self, MsType):
        self._MsType = MsType

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def SourceDatabase(self):
        return self._SourceDatabase

    @SourceDatabase.setter
    def SourceDatabase(self, SourceDatabase):
        self._SourceDatabase = SourceDatabase

    @property
    def TableName(self):
        return self._TableName

    @TableName.setter
    def TableName(self, TableName):
        self._TableName = TableName

    @property
    def SinkType(self):
        return self._SinkType

    @SinkType.setter
    def SinkType(self, SinkType):
        self._SinkType = SinkType

    @property
    def SchemaName(self):
        return self._SchemaName

    @SchemaName.setter
    def SchemaName(self, SchemaName):
        self._SchemaName = SchemaName

    @property
    def SourceFieldInfoList(self):
        return self._SourceFieldInfoList

    @SourceFieldInfoList.setter
    def SourceFieldInfoList(self, SourceFieldInfoList):
        self._SourceFieldInfoList = SourceFieldInfoList

    @property
    def Partitions(self):
        return self._Partitions

    @Partitions.setter
    def Partitions(self, Partitions):
        self._Partitions = Partitions

    @property
    def Properties(self):
        return self._Properties

    @Properties.setter
    def Properties(self, Properties):
        self._Properties = Properties

    @property
    def TableMode(self):
        return self._TableMode

    @TableMode.setter
    def TableMode(self, TableMode):
        self._TableMode = TableMode

    @property
    def TableVersion(self):
        return self._TableVersion

    @TableVersion.setter
    def TableVersion(self, TableVersion):
        self._TableVersion = TableVersion

    @property
    def UpsertFlag(self):
        return self._UpsertFlag

    @UpsertFlag.setter
    def UpsertFlag(self, UpsertFlag):
        self._UpsertFlag = UpsertFlag

    @property
    def TableComment(self):
        return self._TableComment

    @TableComment.setter
    def TableComment(self, TableComment):
        self._TableComment = TableComment

    @property
    def AddDataFiles(self):
        return self._AddDataFiles

    @AddDataFiles.setter
    def AddDataFiles(self, AddDataFiles):
        self._AddDataFiles = AddDataFiles

    @property
    def AddEqualityDeletes(self):
        return self._AddEqualityDeletes

    @AddEqualityDeletes.setter
    def AddEqualityDeletes(self, AddEqualityDeletes):
        self._AddEqualityDeletes = AddEqualityDeletes

    @property
    def AddPositionDeletes(self):
        return self._AddPositionDeletes

    @AddPositionDeletes.setter
    def AddPositionDeletes(self, AddPositionDeletes):
        self._AddPositionDeletes = AddPositionDeletes

    @property
    def AddDeleteFiles(self):
        return self._AddDeleteFiles

    @AddDeleteFiles.setter
    def AddDeleteFiles(self, AddDeleteFiles):
        self._AddDeleteFiles = AddDeleteFiles

    @property
    def TargetDatasourceId(self):
        return self._TargetDatasourceId

    @TargetDatasourceId.setter
    def TargetDatasourceId(self, TargetDatasourceId):
        self._TargetDatasourceId = TargetDatasourceId

    @property
    def UpsertKeys(self):
        return self._UpsertKeys

    @UpsertKeys.setter
    def UpsertKeys(self, UpsertKeys):
        self._UpsertKeys = UpsertKeys

    @property
    def TableBaseInfo(self):
        return self._TableBaseInfo

    @TableBaseInfo.setter
    def TableBaseInfo(self, TableBaseInfo):
        self._TableBaseInfo = TableBaseInfo

    @property
    def SinkSchemaName(self):
        return self._SinkSchemaName

    @SinkSchemaName.setter
    def SinkSchemaName(self, SinkSchemaName):
        self._SinkSchemaName = SinkSchemaName


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._SinkDatabase = params.get("SinkDatabase")
        self._Id = params.get("Id")
        self._MsType = params.get("MsType")
        self._DatasourceId = params.get("DatasourceId")
        self._SourceDatabase = params.get("SourceDatabase")
        self._TableName = params.get("TableName")
        self._SinkType = params.get("SinkType")
        self._SchemaName = params.get("SchemaName")
        if params.get("SourceFieldInfoList") is not None:
            self._SourceFieldInfoList = []
            for item in params.get("SourceFieldInfoList"):
                obj = SourceFieldInfo()
                obj._deserialize(item)
                self._SourceFieldInfoList.append(obj)
        if params.get("Partitions") is not None:
            self._Partitions = []
            for item in params.get("Partitions"):
                obj = Partition()
                obj._deserialize(item)
                self._Partitions.append(obj)
        if params.get("Properties") is not None:
            self._Properties = []
            for item in params.get("Properties"):
                obj = Property()
                obj._deserialize(item)
                self._Properties.append(obj)
        self._TableMode = params.get("TableMode")
        self._TableVersion = params.get("TableVersion")
        self._UpsertFlag = params.get("UpsertFlag")
        self._TableComment = params.get("TableComment")
        self._AddDataFiles = params.get("AddDataFiles")
        self._AddEqualityDeletes = params.get("AddEqualityDeletes")
        self._AddPositionDeletes = params.get("AddPositionDeletes")
        self._AddDeleteFiles = params.get("AddDeleteFiles")
        self._TargetDatasourceId = params.get("TargetDatasourceId")
        self._UpsertKeys = params.get("UpsertKeys")
        if params.get("TableBaseInfo") is not None:
            self._TableBaseInfo = TableBaseInfo()
            self._TableBaseInfo._deserialize(params.get("TableBaseInfo"))
        self._SinkSchemaName = params.get("SinkSchemaName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GenHiveTableDDLSqlResponse(AbstractModel):
    """GenHiveTableDDLSql response structure.

    """

    def __init__(self):
        r"""
        :param _DDLSql: Generated DDL Statement
        :type DDLSql: str
        :param _Data: Generated DDL Statement. Same meaning as DDLSql, prioritizing Data. If Data is null, then DDLSql is taken.
Note: This field may return null, indicating that no valid value can be obtained.
        :type Data: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DDLSql = None
        self._Data = None
        self._RequestId = None

    @property
    def DDLSql(self):
        return self._DDLSql

    @DDLSql.setter
    def DDLSql(self, DDLSql):
        self._DDLSql = DDLSql

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DDLSql = params.get("DDLSql")
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class GeneralTaskParam(AbstractModel):
    """Spark SQL Configuration Parameters

    """

    def __init__(self):
        r"""
        :param _Type: Common Task Parameter Type, for example: SPARK_SQL
        :type Type: str
        :param _Value: Common Task Parameter Content, parameters that directly apply to the task. Separate different parameters with;
Split
        :type Value: str
        """
        self._Type = None
        self._Value = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Value(self):
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Value = params.get("Value")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetFileInfoRequest(AbstractModel):
    """GetFileInfo request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _FilePath: File pathProject Area 1470575647377821696 project, in directory f1: /datastudio/project/1470575647377821696/f1/sql1234.sql Personal Area: /datastudio/personal/sqlTTT.sql
        :type FilePath: str
        """
        self._ProjectId = None
        self._FilePath = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def FilePath(self):
        return self._FilePath

    @FilePath.setter
    def FilePath(self, FilePath):
        self._FilePath = FilePath


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._FilePath = params.get("FilePath")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetFileInfoResponse(AbstractModel):
    """GetFileInfo response structure.

    """

    def __init__(self):
        r"""
        :param _UserFileInfo: Current Script Information
Note: This field may return null, indicating that no valid value can be obtained.
        :type UserFileInfo: :class:`tencentcloud.wedata.v20210820.models.UserFileInfo`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._UserFileInfo = None
        self._RequestId = None

    @property
    def UserFileInfo(self):
        return self._UserFileInfo

    @UserFileInfo.setter
    def UserFileInfo(self, UserFileInfo):
        self._UserFileInfo = UserFileInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("UserFileInfo") is not None:
            self._UserFileInfo = UserFileInfo()
            self._UserFileInfo._deserialize(params.get("UserFileInfo"))
        self._RequestId = params.get("RequestId")


class GetIntegrationNodeColumnSchemaRequest(AbstractModel):
    """GetIntegrationNodeColumnSchema request structure.

    """

    def __init__(self):
        r"""
        :param _ColumnContent: Field Example (JSON Format)
        :type ColumnContent: str
        :param _DatasourceType: Data Source Type MYSQL|HIVE|KAFKA|ES|MONGODB|REST_API|SYBASE|TIDB|DORIS|DM|
        :type DatasourceType: str
        """
        self._ColumnContent = None
        self._DatasourceType = None

    @property
    def ColumnContent(self):
        return self._ColumnContent

    @ColumnContent.setter
    def ColumnContent(self, ColumnContent):
        self._ColumnContent = ColumnContent

    @property
    def DatasourceType(self):
        return self._DatasourceType

    @DatasourceType.setter
    def DatasourceType(self, DatasourceType):
        self._DatasourceType = DatasourceType


    def _deserialize(self, params):
        self._ColumnContent = params.get("ColumnContent")
        self._DatasourceType = params.get("DatasourceType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetIntegrationNodeColumnSchemaResponse(AbstractModel):
    """GetIntegrationNodeColumnSchema response structure.

    """

    def __init__(self):
        r"""
        :param _Schemas: Field List
Note: This field may return null, indicating that no valid value can be obtained.
        :type Schemas: list of IntegrationNodeSchema
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Schemas = None
        self._RequestId = None

    @property
    def Schemas(self):
        return self._Schemas

    @Schemas.setter
    def Schemas(self, Schemas):
        self._Schemas = Schemas

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Schemas") is not None:
            self._Schemas = []
            for item in params.get("Schemas"):
                obj = IntegrationNodeSchema()
                obj._deserialize(item)
                self._Schemas.append(obj)
        self._RequestId = params.get("RequestId")


class GetOfflineDIInstanceListRequest(AbstractModel):
    """GetOfflineDIInstanceList request structure.

    """

    def __init__(self):
        r"""
        :param _PageIndex: Which Page
        :type PageIndex: int
        :param _PageSize: Number of Items per Page
        :type PageSize: int
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _SearchCondition: No
        :type SearchCondition: :class:`tencentcloud.wedata.v20210820.models.SearchConditionNew`
        """
        self._PageIndex = None
        self._PageSize = None
        self._ProjectId = None
        self._SearchCondition = None

    @property
    def PageIndex(self):
        return self._PageIndex

    @PageIndex.setter
    def PageIndex(self, PageIndex):
        self._PageIndex = PageIndex

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def SearchCondition(self):
        return self._SearchCondition

    @SearchCondition.setter
    def SearchCondition(self, SearchCondition):
        self._SearchCondition = SearchCondition


    def _deserialize(self, params):
        self._PageIndex = params.get("PageIndex")
        self._PageSize = params.get("PageSize")
        self._ProjectId = params.get("ProjectId")
        if params.get("SearchCondition") is not None:
            self._SearchCondition = SearchConditionNew()
            self._SearchCondition._deserialize(params.get("SearchCondition"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetOfflineDIInstanceListResponse(AbstractModel):
    """GetOfflineDIInstanceList response structure.

    """

    def __init__(self):
        r"""
        :param _Total: Total number of items
        :type Total: int
        :param _List: Instance details
        :type List: list of OfflineInstance
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Total = None
        self._List = None
        self._RequestId = None

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = OfflineInstance()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class GetOfflineInstanceListRequest(AbstractModel):
    """GetOfflineInstanceList request structure.

    """

    def __init__(self):
        r"""
        :param _PageIndex: Which Page
        :type PageIndex: str
        :param _PageSize: Number of Items per Page
        :type PageSize: int
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _SearchCondition: No
        :type SearchCondition: :class:`tencentcloud.wedata.v20210820.models.SearchCondition`
        """
        self._PageIndex = None
        self._PageSize = None
        self._ProjectId = None
        self._SearchCondition = None

    @property
    def PageIndex(self):
        return self._PageIndex

    @PageIndex.setter
    def PageIndex(self, PageIndex):
        self._PageIndex = PageIndex

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def SearchCondition(self):
        return self._SearchCondition

    @SearchCondition.setter
    def SearchCondition(self, SearchCondition):
        self._SearchCondition = SearchCondition


    def _deserialize(self, params):
        self._PageIndex = params.get("PageIndex")
        self._PageSize = params.get("PageSize")
        self._ProjectId = params.get("ProjectId")
        if params.get("SearchCondition") is not None:
            self._SearchCondition = SearchCondition()
            self._SearchCondition._deserialize(params.get("SearchCondition"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetOfflineInstanceListResponse(AbstractModel):
    """GetOfflineInstanceList response structure.

    """

    def __init__(self):
        r"""
        :param _Total: Total number of items
        :type Total: int
        :param _List: Instance details
        :type List: list of OfflineInstance
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Total = None
        self._List = None
        self._RequestId = None

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = OfflineInstance()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class InstanceApiOpsRequest(AbstractModel):
    """Instance Query Type

    """

    def __init__(self):
        r"""
        :param _Instance: Single Query Condition
        :type Instance: :class:`tencentcloud.wedata.v20210820.models.InstanceOpsDto`
        :param _SortCol: Sort fields, currently includes: Retry Count, Instance Data Time, Runtime Duration
        :type SortCol: str
        :param _TaskIdList: Task ID list
        :type TaskIdList: list of str
        :param _TaskNameList: Fuzzy search by taskName
        :type TaskNameList: list of str
        :param _FolderList: Folder List
        :type FolderList: list of str
        :param _Sort: Ascending or Descending
        :type Sort: str
        :param _StateList: Instance Status List
        :type StateList: list of int
        :param _TaskTypeList: Instance Type List
        :type TaskTypeList: list of int
        :param _CycleList: Cycle Type
        :type CycleList: list of str
        :param _OwnerList: Person in Charge
        :type OwnerList: list of str
        :param _DateFrom: Data Timestamp
        :type DateFrom: str
        :param _DateTo: Data Timestamp
        :type DateTo: str
        :param _CreateTimeFrom: Instance Storage Time
        :type CreateTimeFrom: str
        :param _CreateTimeTo: Instance Storage Time
        :type CreateTimeTo: str
        :param _StartFrom: Start Execution Time
        :type StartFrom: str
        :param _StartTo: Start Execution Time
        :type StartTo: str
        :param _WorkflowIdList: Belongs to Workflow
        :type WorkflowIdList: list of str
        :param _WorkflowNameList: Fuzzy search by workflowName
        :type WorkflowNameList: list of str
        :param _Keyword: Keyword Fuzzy Search
        :type Keyword: str
        :param _SearchColumns: searchColumns are the list of field names to search
        :type SearchColumns: list of str
        :param _ProjectId: Project ID
        :type ProjectId: str
        :param _Limit: Limit
        :type Limit: int
        :param _TaskTypeMap: Task Type Mapping Relationship, storing Task Type ID and Task Type Description Information
        :type TaskTypeMap: list of TaskTypeMap
        :param _InstanceType: 0 Supplementary Entry Type 1 Periodic Instance 2 Non-periodic Instance
        :type InstanceType: str
        :param _DagDeal: Whether it is DAG
        :type DagDeal: bool
        :param _DagType: 1 Parent instance 2 Child instance
        :type DagType: str
        :param _DagDependent: 1 Self-Dependency 2 Task Dependency 3 All Dependencies
        :type DagDependent: str
        :param _DagDepth: DAG Depth Default to 1, value range 1-6
        :type DagDepth: int
        :param _TenantId: Tenant ID
        :type TenantId: str
        :param _DataTimeCycle: Inquiry based on Current Data Time or Next Data Time, default to Current Data Time
        :type DataTimeCycle: str
        :param _ExecutorGroupIdList: Resource Group ID, multiple Resource Group IDs separated by English commas
        :type ExecutorGroupIdList: list of str
        """
        self._Instance = None
        self._SortCol = None
        self._TaskIdList = None
        self._TaskNameList = None
        self._FolderList = None
        self._Sort = None
        self._StateList = None
        self._TaskTypeList = None
        self._CycleList = None
        self._OwnerList = None
        self._DateFrom = None
        self._DateTo = None
        self._CreateTimeFrom = None
        self._CreateTimeTo = None
        self._StartFrom = None
        self._StartTo = None
        self._WorkflowIdList = None
        self._WorkflowNameList = None
        self._Keyword = None
        self._SearchColumns = None
        self._ProjectId = None
        self._Limit = None
        self._TaskTypeMap = None
        self._InstanceType = None
        self._DagDeal = None
        self._DagType = None
        self._DagDependent = None
        self._DagDepth = None
        self._TenantId = None
        self._DataTimeCycle = None
        self._ExecutorGroupIdList = None

    @property
    def Instance(self):
        return self._Instance

    @Instance.setter
    def Instance(self, Instance):
        self._Instance = Instance

    @property
    def SortCol(self):
        return self._SortCol

    @SortCol.setter
    def SortCol(self, SortCol):
        self._SortCol = SortCol

    @property
    def TaskIdList(self):
        return self._TaskIdList

    @TaskIdList.setter
    def TaskIdList(self, TaskIdList):
        self._TaskIdList = TaskIdList

    @property
    def TaskNameList(self):
        return self._TaskNameList

    @TaskNameList.setter
    def TaskNameList(self, TaskNameList):
        self._TaskNameList = TaskNameList

    @property
    def FolderList(self):
        return self._FolderList

    @FolderList.setter
    def FolderList(self, FolderList):
        self._FolderList = FolderList

    @property
    def Sort(self):
        return self._Sort

    @Sort.setter
    def Sort(self, Sort):
        self._Sort = Sort

    @property
    def StateList(self):
        return self._StateList

    @StateList.setter
    def StateList(self, StateList):
        self._StateList = StateList

    @property
    def TaskTypeList(self):
        return self._TaskTypeList

    @TaskTypeList.setter
    def TaskTypeList(self, TaskTypeList):
        self._TaskTypeList = TaskTypeList

    @property
    def CycleList(self):
        return self._CycleList

    @CycleList.setter
    def CycleList(self, CycleList):
        self._CycleList = CycleList

    @property
    def OwnerList(self):
        return self._OwnerList

    @OwnerList.setter
    def OwnerList(self, OwnerList):
        self._OwnerList = OwnerList

    @property
    def DateFrom(self):
        return self._DateFrom

    @DateFrom.setter
    def DateFrom(self, DateFrom):
        self._DateFrom = DateFrom

    @property
    def DateTo(self):
        return self._DateTo

    @DateTo.setter
    def DateTo(self, DateTo):
        self._DateTo = DateTo

    @property
    def CreateTimeFrom(self):
        return self._CreateTimeFrom

    @CreateTimeFrom.setter
    def CreateTimeFrom(self, CreateTimeFrom):
        self._CreateTimeFrom = CreateTimeFrom

    @property
    def CreateTimeTo(self):
        return self._CreateTimeTo

    @CreateTimeTo.setter
    def CreateTimeTo(self, CreateTimeTo):
        self._CreateTimeTo = CreateTimeTo

    @property
    def StartFrom(self):
        return self._StartFrom

    @StartFrom.setter
    def StartFrom(self, StartFrom):
        self._StartFrom = StartFrom

    @property
    def StartTo(self):
        return self._StartTo

    @StartTo.setter
    def StartTo(self, StartTo):
        self._StartTo = StartTo

    @property
    def WorkflowIdList(self):
        return self._WorkflowIdList

    @WorkflowIdList.setter
    def WorkflowIdList(self, WorkflowIdList):
        self._WorkflowIdList = WorkflowIdList

    @property
    def WorkflowNameList(self):
        return self._WorkflowNameList

    @WorkflowNameList.setter
    def WorkflowNameList(self, WorkflowNameList):
        self._WorkflowNameList = WorkflowNameList

    @property
    def Keyword(self):
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword

    @property
    def SearchColumns(self):
        return self._SearchColumns

    @SearchColumns.setter
    def SearchColumns(self, SearchColumns):
        self._SearchColumns = SearchColumns

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def TaskTypeMap(self):
        return self._TaskTypeMap

    @TaskTypeMap.setter
    def TaskTypeMap(self, TaskTypeMap):
        self._TaskTypeMap = TaskTypeMap

    @property
    def InstanceType(self):
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def DagDeal(self):
        return self._DagDeal

    @DagDeal.setter
    def DagDeal(self, DagDeal):
        self._DagDeal = DagDeal

    @property
    def DagType(self):
        return self._DagType

    @DagType.setter
    def DagType(self, DagType):
        self._DagType = DagType

    @property
    def DagDependent(self):
        return self._DagDependent

    @DagDependent.setter
    def DagDependent(self, DagDependent):
        self._DagDependent = DagDependent

    @property
    def DagDepth(self):
        return self._DagDepth

    @DagDepth.setter
    def DagDepth(self, DagDepth):
        self._DagDepth = DagDepth

    @property
    def TenantId(self):
        return self._TenantId

    @TenantId.setter
    def TenantId(self, TenantId):
        self._TenantId = TenantId

    @property
    def DataTimeCycle(self):
        return self._DataTimeCycle

    @DataTimeCycle.setter
    def DataTimeCycle(self, DataTimeCycle):
        self._DataTimeCycle = DataTimeCycle

    @property
    def ExecutorGroupIdList(self):
        return self._ExecutorGroupIdList

    @ExecutorGroupIdList.setter
    def ExecutorGroupIdList(self, ExecutorGroupIdList):
        self._ExecutorGroupIdList = ExecutorGroupIdList


    def _deserialize(self, params):
        if params.get("Instance") is not None:
            self._Instance = InstanceOpsDto()
            self._Instance._deserialize(params.get("Instance"))
        self._SortCol = params.get("SortCol")
        self._TaskIdList = params.get("TaskIdList")
        self._TaskNameList = params.get("TaskNameList")
        self._FolderList = params.get("FolderList")
        self._Sort = params.get("Sort")
        self._StateList = params.get("StateList")
        self._TaskTypeList = params.get("TaskTypeList")
        self._CycleList = params.get("CycleList")
        self._OwnerList = params.get("OwnerList")
        self._DateFrom = params.get("DateFrom")
        self._DateTo = params.get("DateTo")
        self._CreateTimeFrom = params.get("CreateTimeFrom")
        self._CreateTimeTo = params.get("CreateTimeTo")
        self._StartFrom = params.get("StartFrom")
        self._StartTo = params.get("StartTo")
        self._WorkflowIdList = params.get("WorkflowIdList")
        self._WorkflowNameList = params.get("WorkflowNameList")
        self._Keyword = params.get("Keyword")
        self._SearchColumns = params.get("SearchColumns")
        self._ProjectId = params.get("ProjectId")
        self._Limit = params.get("Limit")
        if params.get("TaskTypeMap") is not None:
            self._TaskTypeMap = []
            for item in params.get("TaskTypeMap"):
                obj = TaskTypeMap()
                obj._deserialize(item)
                self._TaskTypeMap.append(obj)
        self._InstanceType = params.get("InstanceType")
        self._DagDeal = params.get("DagDeal")
        self._DagType = params.get("DagType")
        self._DagDependent = params.get("DagDependent")
        self._DagDepth = params.get("DagDepth")
        self._TenantId = params.get("TenantId")
        self._DataTimeCycle = params.get("DataTimeCycle")
        self._ExecutorGroupIdList = params.get("ExecutorGroupIdList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InstanceCondition(AbstractModel):
    """Instance Retrieval Criteria

    """

    def __init__(self):
        r"""
        :param _ExecutionSpace: Execution Type
        :type ExecutionSpace: str
        :param _ProductName: Task Product Type
        :type ProductName: str
        """
        self._ExecutionSpace = None
        self._ProductName = None

    @property
    def ExecutionSpace(self):
        return self._ExecutionSpace

    @ExecutionSpace.setter
    def ExecutionSpace(self, ExecutionSpace):
        self._ExecutionSpace = ExecutionSpace

    @property
    def ProductName(self):
        return self._ProductName

    @ProductName.setter
    def ProductName(self, ProductName):
        self._ProductName = ProductName


    def _deserialize(self, params):
        self._ExecutionSpace = params.get("ExecutionSpace")
        self._ProductName = params.get("ProductName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InstanceDownloadLogInfo(AbstractModel):
    """Download Log Details

    """

    def __init__(self):
        r"""
        :param _FileName: File NameNote: This field may return null, indicating that no valid value can be obtained.
        :type FileName: str
        :param _FileUrl: File URL
Note: This field may return null, indicating that no valid value can be obtained.
        :type FileUrl: str
        """
        self._FileName = None
        self._FileUrl = None

    @property
    def FileName(self):
        return self._FileName

    @FileName.setter
    def FileName(self, FileName):
        self._FileName = FileName

    @property
    def FileUrl(self):
        return self._FileUrl

    @FileUrl.setter
    def FileUrl(self, FileUrl):
        self._FileUrl = FileUrl


    def _deserialize(self, params):
        self._FileName = params.get("FileName")
        self._FileUrl = params.get("FileUrl")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InstanceLifeCycleOpsDto(AbstractModel):
    """Instance Lifecycle Details

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID
Note: This field may return null, indicating that no valid value can be obtained.
        :type TaskId: str
        :param _CurRunDate: Data Timestamp
Note: This field may return null, indicating that no valid value can be obtained.
        :type CurRunDate: str
        :param _LifeRound: Instance Lifecycle Count
Note: This field may return null, indicating that no valid value can be obtained.
        :type LifeRound: int
        :param _RunType: Run Type Rerun/Supplement/Periodic/Non-periodic
Note: This field may return null, indicating that no valid value can be obtained.
        :type RunType: str
        :param _Tries: Number of Reruns
Note: This field may return null, indicating that no valid value can be obtained.
        :type Tries: int
        :param _InstanceLifeDetailDtoList: Instance LifecycleNote: This field may return null, indicating that no valid value can be obtained.
        :type InstanceLifeDetailDtoList: list of InstanceLifeDetailDto
        :param _RunnerState: Runner Status
Note: This field may return null, indicating that no valid value can be obtained.
        :type RunnerState: str
        :param _ErrorDesc: Error codeNote: This field may return null, indicating that no valid value can be obtained.
        :type ErrorDesc: str
        :param _ErrorCodeLevel: Error Alert Level
Note: This field may return null, indicating that no valid value can be obtained.
        :type ErrorCodeLevel: str
        :param _InstanceLogListOpsDto: Instance Log Summary
Note: This field may return null, indicating that no valid value can be obtained.
        :type InstanceLogListOpsDto: :class:`tencentcloud.wedata.v20210820.models.InstanceLogInfo`
        :param _InstanceState: Instance StatusNote: This field may return null, indicating that no valid value can be obtained.
        :type InstanceState: str
        """
        self._TaskId = None
        self._CurRunDate = None
        self._LifeRound = None
        self._RunType = None
        self._Tries = None
        self._InstanceLifeDetailDtoList = None
        self._RunnerState = None
        self._ErrorDesc = None
        self._ErrorCodeLevel = None
        self._InstanceLogListOpsDto = None
        self._InstanceState = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def CurRunDate(self):
        return self._CurRunDate

    @CurRunDate.setter
    def CurRunDate(self, CurRunDate):
        self._CurRunDate = CurRunDate

    @property
    def LifeRound(self):
        return self._LifeRound

    @LifeRound.setter
    def LifeRound(self, LifeRound):
        self._LifeRound = LifeRound

    @property
    def RunType(self):
        return self._RunType

    @RunType.setter
    def RunType(self, RunType):
        self._RunType = RunType

    @property
    def Tries(self):
        return self._Tries

    @Tries.setter
    def Tries(self, Tries):
        self._Tries = Tries

    @property
    def InstanceLifeDetailDtoList(self):
        return self._InstanceLifeDetailDtoList

    @InstanceLifeDetailDtoList.setter
    def InstanceLifeDetailDtoList(self, InstanceLifeDetailDtoList):
        self._InstanceLifeDetailDtoList = InstanceLifeDetailDtoList

    @property
    def RunnerState(self):
        return self._RunnerState

    @RunnerState.setter
    def RunnerState(self, RunnerState):
        self._RunnerState = RunnerState

    @property
    def ErrorDesc(self):
        return self._ErrorDesc

    @ErrorDesc.setter
    def ErrorDesc(self, ErrorDesc):
        self._ErrorDesc = ErrorDesc

    @property
    def ErrorCodeLevel(self):
        return self._ErrorCodeLevel

    @ErrorCodeLevel.setter
    def ErrorCodeLevel(self, ErrorCodeLevel):
        self._ErrorCodeLevel = ErrorCodeLevel

    @property
    def InstanceLogListOpsDto(self):
        return self._InstanceLogListOpsDto

    @InstanceLogListOpsDto.setter
    def InstanceLogListOpsDto(self, InstanceLogListOpsDto):
        self._InstanceLogListOpsDto = InstanceLogListOpsDto

    @property
    def InstanceState(self):
        return self._InstanceState

    @InstanceState.setter
    def InstanceState(self, InstanceState):
        self._InstanceState = InstanceState


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._CurRunDate = params.get("CurRunDate")
        self._LifeRound = params.get("LifeRound")
        self._RunType = params.get("RunType")
        self._Tries = params.get("Tries")
        if params.get("InstanceLifeDetailDtoList") is not None:
            self._InstanceLifeDetailDtoList = []
            for item in params.get("InstanceLifeDetailDtoList"):
                obj = InstanceLifeDetailDto()
                obj._deserialize(item)
                self._InstanceLifeDetailDtoList.append(obj)
        self._RunnerState = params.get("RunnerState")
        self._ErrorDesc = params.get("ErrorDesc")
        self._ErrorCodeLevel = params.get("ErrorCodeLevel")
        if params.get("InstanceLogListOpsDto") is not None:
            self._InstanceLogListOpsDto = InstanceLogInfo()
            self._InstanceLogListOpsDto._deserialize(params.get("InstanceLogListOpsDto"))
        self._InstanceState = params.get("InstanceState")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InstanceLifeDetailDto(AbstractModel):
    """Instance Lifecycle Detail

    """

    def __init__(self):
        r"""
        :param _State: Instance StatusNote: This field may return null, indicating that no valid value can be obtained.
        :type State: str
        :param _StartTime: Start Time of the State
Note: This field may return null, indicating that no valid value can be obtained.
        :type StartTime: str
        :param _DetailState: Instance Lifecycle Phase Status
Note: This field may return null, indicating that no valid value can be obtained.
        :type DetailState: str
        :param _EndTime: End Time of the State
Note: This field may return null, indicating that no valid value can be obtained.
        :type EndTime: str
        """
        self._State = None
        self._StartTime = None
        self._DetailState = None
        self._EndTime = None

    @property
    def State(self):
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def DetailState(self):
        return self._DetailState

    @DetailState.setter
    def DetailState(self, DetailState):
        self._DetailState = DetailState

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._State = params.get("State")
        self._StartTime = params.get("StartTime")
        self._DetailState = params.get("DetailState")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InstanceList(AbstractModel):
    """Offline operation and maintenance instance list

    """

    def __init__(self):
        r"""
        :param _CostTime: Time Consumed
Note: This field may return null, indicating that no valid value can be obtained.
        :type CostTime: str
        :param _CurRunDate: Data TimestampNote: This field may return null, indicating that no valid value can be obtained.
        :type CurRunDate: str
        :param _CycleType: Cycle type
Note: This field may return null, indicating that no valid value can be obtained.
        :type CycleType: str
        :param _DoFlag: Whether to Supplement
Note: This field may return null, indicating that no valid value can be obtained.
        :type DoFlag: int
        :param _InCharge: Person in ChargeNote: This field may return null, indicating that no valid value can be obtained.
        :type InCharge: str
        :param _LastLog: LogNote: This field may return null, indicating that no valid value can be obtained.
        :type LastLog: str
        :param _SchedulerDesc: Scheduling plan
Note: This field may return null, indicating that no valid value can be obtained.
        :type SchedulerDesc: str
        :param _StartTime: Start startup time
Note: This field may return null, indicating that no valid value can be obtained.
        :type StartTime: str
        :param _State: Instance status EVENT_LISTENING|DEPENDENCE|BEFORE_ASPECT|ALLOCATED|LAUNCHED|KILL|SNAP_STATE_SAVING|ISSUED|RUNNING|AFTER_ASPECT|PENDING|KILLING|FINAL_STATE_SAVING|FAILED|KILL_FAILED| COMPLETED|EXPIRED|KILL_EXPIRED|DELETED
Note: This field may return null, indicating that no valid value can be obtained.
        :type State: str
        :param _TaskId: Task IDNote: This field may return null, indicating that no valid value can be obtained.
        :type TaskId: str
        :param _TaskName: Task NameNote: This field may return null, indicating that no valid value can be obtained.
        :type TaskName: str
        :param _TryLimit: Number of trial runs
Note: This field may return null, indicating that no valid value can be obtained.
        :type TryLimit: int
        """
        self._CostTime = None
        self._CurRunDate = None
        self._CycleType = None
        self._DoFlag = None
        self._InCharge = None
        self._LastLog = None
        self._SchedulerDesc = None
        self._StartTime = None
        self._State = None
        self._TaskId = None
        self._TaskName = None
        self._TryLimit = None

    @property
    def CostTime(self):
        return self._CostTime

    @CostTime.setter
    def CostTime(self, CostTime):
        self._CostTime = CostTime

    @property
    def CurRunDate(self):
        return self._CurRunDate

    @CurRunDate.setter
    def CurRunDate(self, CurRunDate):
        self._CurRunDate = CurRunDate

    @property
    def CycleType(self):
        return self._CycleType

    @CycleType.setter
    def CycleType(self, CycleType):
        self._CycleType = CycleType

    @property
    def DoFlag(self):
        return self._DoFlag

    @DoFlag.setter
    def DoFlag(self, DoFlag):
        self._DoFlag = DoFlag

    @property
    def InCharge(self):
        return self._InCharge

    @InCharge.setter
    def InCharge(self, InCharge):
        self._InCharge = InCharge

    @property
    def LastLog(self):
        return self._LastLog

    @LastLog.setter
    def LastLog(self, LastLog):
        self._LastLog = LastLog

    @property
    def SchedulerDesc(self):
        return self._SchedulerDesc

    @SchedulerDesc.setter
    def SchedulerDesc(self, SchedulerDesc):
        self._SchedulerDesc = SchedulerDesc

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def State(self):
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TaskName(self):
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def TryLimit(self):
        return self._TryLimit

    @TryLimit.setter
    def TryLimit(self, TryLimit):
        self._TryLimit = TryLimit


    def _deserialize(self, params):
        self._CostTime = params.get("CostTime")
        self._CurRunDate = params.get("CurRunDate")
        self._CycleType = params.get("CycleType")
        self._DoFlag = params.get("DoFlag")
        self._InCharge = params.get("InCharge")
        self._LastLog = params.get("LastLog")
        self._SchedulerDesc = params.get("SchedulerDesc")
        self._StartTime = params.get("StartTime")
        self._State = params.get("State")
        self._TaskId = params.get("TaskId")
        self._TaskName = params.get("TaskName")
        self._TryLimit = params.get("TryLimit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InstanceLogInfo(AbstractModel):
    """Instance Log Summary Information

    """

    def __init__(self):
        r"""
        :param _TaskId: Task IDNote: This field may return null, indicating that no valid value can be obtained.
        :type TaskId: str
        :param _CurRunDate: Data TimestampNote: This field may return null, indicating that no valid value can be obtained.
        :type CurRunDate: str
        :param _Tries: Number of trial runs
Note: This field may return null, indicating that no valid value can be obtained.
        :type Tries: str
        :param _LastUpdate: Log Update Time
Note: This field may return null, indicating that no valid value can be obtained.
        :type LastUpdate: str
        :param _BrokerIp: Log Node
Note: This field may return null, indicating that no valid value can be obtained.
        :type BrokerIp: str
        :param _FileSize: File sizeNote: This field may return null, indicating that no valid value can be obtained.
        :type FileSize: str
        :param _OriginFileName: File Name including Full Path
Note: This field may return null, indicating that no valid value can be obtained.
        :type OriginFileName: str
        :param _CreateTime: Log Creation Time
Note: This field may return null, indicating that no valid value can be obtained.
        :type CreateTime: str
        :param _InstanceLogType: Instance Log Type, run: running; kill: termination
Note: This field may return null, indicating that no valid value can be obtained.
        :type InstanceLogType: str
        :param _TaskName: Task NameNote: This field may return null, indicating that no valid value can be obtained.
        :type TaskName: str
        :param _CostTime: Runtime Duration
Note: This field may return null, indicating that no valid value can be obtained.
        :type CostTime: str
        :param _InstanceStatus: Instance Status COMPLETED completed FAILED failed retry EXPIRED failed RUNNING running
Note: This field may return null, indicating that no valid value can be obtained.
        :type InstanceStatus: str
        :param _CodeFileName: Instance Code File, absence indicates the corresponding code file does not exist, possibly due to the executor not being upgraded/certain types of tasks having no code.
Note: This field may return null, indicating that no valid value can be obtained.
        :type CodeFileName: str
        :param _ExtensionInfo: Extended Attributes
Note: This field may return null, indicating that no valid value can be obtained.
        :type ExtensionInfo: list of AttributeItemDTO
        """
        self._TaskId = None
        self._CurRunDate = None
        self._Tries = None
        self._LastUpdate = None
        self._BrokerIp = None
        self._FileSize = None
        self._OriginFileName = None
        self._CreateTime = None
        self._InstanceLogType = None
        self._TaskName = None
        self._CostTime = None
        self._InstanceStatus = None
        self._CodeFileName = None
        self._ExtensionInfo = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def CurRunDate(self):
        return self._CurRunDate

    @CurRunDate.setter
    def CurRunDate(self, CurRunDate):
        self._CurRunDate = CurRunDate

    @property
    def Tries(self):
        return self._Tries

    @Tries.setter
    def Tries(self, Tries):
        self._Tries = Tries

    @property
    def LastUpdate(self):
        return self._LastUpdate

    @LastUpdate.setter
    def LastUpdate(self, LastUpdate):
        self._LastUpdate = LastUpdate

    @property
    def BrokerIp(self):
        return self._BrokerIp

    @BrokerIp.setter
    def BrokerIp(self, BrokerIp):
        self._BrokerIp = BrokerIp

    @property
    def FileSize(self):
        return self._FileSize

    @FileSize.setter
    def FileSize(self, FileSize):
        self._FileSize = FileSize

    @property
    def OriginFileName(self):
        return self._OriginFileName

    @OriginFileName.setter
    def OriginFileName(self, OriginFileName):
        self._OriginFileName = OriginFileName

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def InstanceLogType(self):
        return self._InstanceLogType

    @InstanceLogType.setter
    def InstanceLogType(self, InstanceLogType):
        self._InstanceLogType = InstanceLogType

    @property
    def TaskName(self):
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def CostTime(self):
        return self._CostTime

    @CostTime.setter
    def CostTime(self, CostTime):
        self._CostTime = CostTime

    @property
    def InstanceStatus(self):
        return self._InstanceStatus

    @InstanceStatus.setter
    def InstanceStatus(self, InstanceStatus):
        self._InstanceStatus = InstanceStatus

    @property
    def CodeFileName(self):
        return self._CodeFileName

    @CodeFileName.setter
    def CodeFileName(self, CodeFileName):
        self._CodeFileName = CodeFileName

    @property
    def ExtensionInfo(self):
        return self._ExtensionInfo

    @ExtensionInfo.setter
    def ExtensionInfo(self, ExtensionInfo):
        self._ExtensionInfo = ExtensionInfo


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._CurRunDate = params.get("CurRunDate")
        self._Tries = params.get("Tries")
        self._LastUpdate = params.get("LastUpdate")
        self._BrokerIp = params.get("BrokerIp")
        self._FileSize = params.get("FileSize")
        self._OriginFileName = params.get("OriginFileName")
        self._CreateTime = params.get("CreateTime")
        self._InstanceLogType = params.get("InstanceLogType")
        self._TaskName = params.get("TaskName")
        self._CostTime = params.get("CostTime")
        self._InstanceStatus = params.get("InstanceStatus")
        self._CodeFileName = params.get("CodeFileName")
        if params.get("ExtensionInfo") is not None:
            self._ExtensionInfo = []
            for item in params.get("ExtensionInfo"):
                obj = AttributeItemDTO()
                obj._deserialize(item)
                self._ExtensionInfo.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InstanceLogInfoOpsDto(AbstractModel):
    """Instance log information details

    """

    def __init__(self):
        r"""
        :param _LogInfo: Instance running log
Note: This field may return null, indicating that no valid value can be obtained.
        :type LogInfo: str
        :param _YarnLogInfo: The Yarn log address submitted by the instance run
Note: This field may return null, indicating that no valid value can be obtained.
        :type YarnLogInfo: list of str
        :param _DataLogInfo: The datax log generated by the instance run
Note: This field may return null, indicating that no valid value can be obtained.
        :type DataLogInfo: str
        :param _ThirdTaskRunLogInfo: Third-party Task Execution Log
Note: This field may return null, indicating that no valid value can be obtained.
        :type ThirdTaskRunLogInfo: str
        :param _ThirdTaskLogUrlDesc: Third-party Task Log Link Description
Note: This field may return null, indicating that no valid value can be obtained.
        :type ThirdTaskLogUrlDesc: str
        :param _LineCount: Number of Log Lines
Note: This field may return null, indicating that no valid value can be obtained.
        :type LineCount: int
        """
        self._LogInfo = None
        self._YarnLogInfo = None
        self._DataLogInfo = None
        self._ThirdTaskRunLogInfo = None
        self._ThirdTaskLogUrlDesc = None
        self._LineCount = None

    @property
    def LogInfo(self):
        return self._LogInfo

    @LogInfo.setter
    def LogInfo(self, LogInfo):
        self._LogInfo = LogInfo

    @property
    def YarnLogInfo(self):
        return self._YarnLogInfo

    @YarnLogInfo.setter
    def YarnLogInfo(self, YarnLogInfo):
        self._YarnLogInfo = YarnLogInfo

    @property
    def DataLogInfo(self):
        return self._DataLogInfo

    @DataLogInfo.setter
    def DataLogInfo(self, DataLogInfo):
        self._DataLogInfo = DataLogInfo

    @property
    def ThirdTaskRunLogInfo(self):
        return self._ThirdTaskRunLogInfo

    @ThirdTaskRunLogInfo.setter
    def ThirdTaskRunLogInfo(self, ThirdTaskRunLogInfo):
        self._ThirdTaskRunLogInfo = ThirdTaskRunLogInfo

    @property
    def ThirdTaskLogUrlDesc(self):
        return self._ThirdTaskLogUrlDesc

    @ThirdTaskLogUrlDesc.setter
    def ThirdTaskLogUrlDesc(self, ThirdTaskLogUrlDesc):
        self._ThirdTaskLogUrlDesc = ThirdTaskLogUrlDesc

    @property
    def LineCount(self):
        return self._LineCount

    @LineCount.setter
    def LineCount(self, LineCount):
        self._LineCount = LineCount


    def _deserialize(self, params):
        self._LogInfo = params.get("LogInfo")
        self._YarnLogInfo = params.get("YarnLogInfo")
        self._DataLogInfo = params.get("DataLogInfo")
        self._ThirdTaskRunLogInfo = params.get("ThirdTaskRunLogInfo")
        self._ThirdTaskLogUrlDesc = params.get("ThirdTaskLogUrlDesc")
        self._LineCount = params.get("LineCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InstanceLogList(AbstractModel):
    """Instance log information

    """

    def __init__(self):
        r"""
        :param _TaskId: Task IDNote: This field may return null, indicating that no valid value can be obtained.
        :type TaskId: str
        :param _CurRunDate: Data TimestampNote: This field may return null, indicating that no valid value can be obtained.
        :type CurRunDate: str
        :param _Tries: Maximum number of retriesNote: This field may return null, indicating that no valid value can be obtained.
        :type Tries: str
        :param _LastUpdate: Last Updated TimeNote: This field may return null, indicating that no valid value can be obtained.
        :type LastUpdate: str
        :param _BrokerIp: Node IP
Note: This field may return null, indicating that no valid value can be obtained.
        :type BrokerIp: str
        :param _FileSize: File sizeNote: This field may return null, indicating that no valid value can be obtained.
        :type FileSize: str
        :param _OriginFileName: Original File Name
Note: This field may return null, indicating that no valid value can be obtained.
        :type OriginFileName: str
        :param _CreateTime: Creation TimeNote: This field may return null, indicating that no valid value can be obtained.
        :type CreateTime: str
        :param _InstanceLogType: Instance Log Type
Note: This field may return null, indicating that no valid value can be obtained.
        :type InstanceLogType: str
        :param _TaskName: Task NameNote: This field may return null, indicating that no valid value can be obtained.
        :type TaskName: str
        :param _CostTime: Time Consumed
Note: This field may return null, indicating that no valid value can be obtained.
        :type CostTime: str
        """
        self._TaskId = None
        self._CurRunDate = None
        self._Tries = None
        self._LastUpdate = None
        self._BrokerIp = None
        self._FileSize = None
        self._OriginFileName = None
        self._CreateTime = None
        self._InstanceLogType = None
        self._TaskName = None
        self._CostTime = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def CurRunDate(self):
        return self._CurRunDate

    @CurRunDate.setter
    def CurRunDate(self, CurRunDate):
        self._CurRunDate = CurRunDate

    @property
    def Tries(self):
        return self._Tries

    @Tries.setter
    def Tries(self, Tries):
        self._Tries = Tries

    @property
    def LastUpdate(self):
        return self._LastUpdate

    @LastUpdate.setter
    def LastUpdate(self, LastUpdate):
        self._LastUpdate = LastUpdate

    @property
    def BrokerIp(self):
        return self._BrokerIp

    @BrokerIp.setter
    def BrokerIp(self, BrokerIp):
        self._BrokerIp = BrokerIp

    @property
    def FileSize(self):
        return self._FileSize

    @FileSize.setter
    def FileSize(self, FileSize):
        self._FileSize = FileSize

    @property
    def OriginFileName(self):
        return self._OriginFileName

    @OriginFileName.setter
    def OriginFileName(self, OriginFileName):
        self._OriginFileName = OriginFileName

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def InstanceLogType(self):
        return self._InstanceLogType

    @InstanceLogType.setter
    def InstanceLogType(self, InstanceLogType):
        self._InstanceLogType = InstanceLogType

    @property
    def TaskName(self):
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def CostTime(self):
        return self._CostTime

    @CostTime.setter
    def CostTime(self, CostTime):
        self._CostTime = CostTime


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._CurRunDate = params.get("CurRunDate")
        self._Tries = params.get("Tries")
        self._LastUpdate = params.get("LastUpdate")
        self._BrokerIp = params.get("BrokerIp")
        self._FileSize = params.get("FileSize")
        self._OriginFileName = params.get("OriginFileName")
        self._CreateTime = params.get("CreateTime")
        self._InstanceLogType = params.get("InstanceLogType")
        self._TaskName = params.get("TaskName")
        self._CostTime = params.get("CostTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            propert