# -*- coding: utf8 -*-
# Copyright (c) 2017-2025 Tencent. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class AbortCronJobsRequest(AbstractModel):
    """AbortCronJobs request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID.
        :type ProjectId: str
        :param _CronJobIds: Array of CronJob ID.
        :type CronJobIds: list of str
        """
        self._ProjectId = None
        self._CronJobIds = None

    @property
    def ProjectId(self):
        """Project ID.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def CronJobIds(self):
        """Array of CronJob ID.
        :rtype: list of str
        """
        return self._CronJobIds

    @CronJobIds.setter
    def CronJobIds(self, CronJobIds):
        self._CronJobIds = CronJobIds


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._CronJobIds = params.get("CronJobIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AbortCronJobsResponse(AbstractModel):
    """AbortCronJobs response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AbortJobRequest(AbstractModel):
    """AbortJob request structure.

    """

    def __init__(self):
        r"""
        :param _JobId: Job ID.
        :type JobId: str
        :param _ProjectId: Project ID.
        :type ProjectId: str
        :param _ScenarioId: Scenario ID.
        :type ScenarioId: str
        :param _AbortReason: Reason for stopping.
        :type AbortReason: int
        """
        self._JobId = None
        self._ProjectId = None
        self._ScenarioId = None
        self._AbortReason = None

    @property
    def JobId(self):
        """Job ID.
        :rtype: str
        """
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def ProjectId(self):
        """Project ID.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ScenarioId(self):
        """Scenario ID.
        :rtype: str
        """
        return self._ScenarioId

    @ScenarioId.setter
    def ScenarioId(self, ScenarioId):
        self._ScenarioId = ScenarioId

    @property
    def AbortReason(self):
        """Reason for stopping.
        :rtype: int
        """
        return self._AbortReason

    @AbortReason.setter
    def AbortReason(self, AbortReason):
        self._AbortReason = AbortReason


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._ProjectId = params.get("ProjectId")
        self._ScenarioId = params.get("ScenarioId")
        self._AbortReason = params.get("AbortReason")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AbortJobResponse(AbstractModel):
    """AbortJob response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AdjustJobSpeedRequest(AbstractModel):
    """AdjustJobSpeed request structure.

    """

    def __init__(self):
        r"""
        :param _JobId: Job ID.
        :type JobId: str
        :param _TargetRequestsPerSecond: Target RPS. The value should be greater than the initial RPS and less than the maximum RPS.
        :type TargetRequestsPerSecond: int
        """
        self._JobId = None
        self._TargetRequestsPerSecond = None

    @property
    def JobId(self):
        """Job ID.
        :rtype: str
        """
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def TargetRequestsPerSecond(self):
        """Target RPS. The value should be greater than the initial RPS and less than the maximum RPS.
        :rtype: int
        """
        return self._TargetRequestsPerSecond

    @TargetRequestsPerSecond.setter
    def TargetRequestsPerSecond(self, TargetRequestsPerSecond):
        self._TargetRequestsPerSecond = TargetRequestsPerSecond


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._TargetRequestsPerSecond = params.get("TargetRequestsPerSecond")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AdjustJobSpeedResponse(AbstractModel):
    """AdjustJobSpeed response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AggregationLegend(AbstractModel):
    """Aggregation function

    """

    def __init__(self):
        r"""
        :param _Aggregation: Aggregation functions supported by the metric.
        :type Aggregation: str
        :param _Legend: Description after the aggregation function is applied to the metric.
        :type Legend: str
        :param _Unit: Metric unit after aggregation.
        :type Unit: str
        """
        self._Aggregation = None
        self._Legend = None
        self._Unit = None

    @property
    def Aggregation(self):
        """Aggregation functions supported by the metric.
        :rtype: str
        """
        return self._Aggregation

    @Aggregation.setter
    def Aggregation(self, Aggregation):
        self._Aggregation = Aggregation

    @property
    def Legend(self):
        """Description after the aggregation function is applied to the metric.
        :rtype: str
        """
        return self._Legend

    @Legend.setter
    def Legend(self, Legend):
        self._Legend = Legend

    @property
    def Unit(self):
        """Metric unit after aggregation.
        :rtype: str
        """
        return self._Unit

    @Unit.setter
    def Unit(self, Unit):
        self._Unit = Unit


    def _deserialize(self, params):
        self._Aggregation = params.get("Aggregation")
        self._Legend = params.get("Legend")
        self._Unit = params.get("Unit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AlertChannel(AbstractModel):
    """Alert notification channel

    """

    def __init__(self):
        r"""
        :param _NoticeId: Notification template ID.

Note: This field may return null, indicating that no valid value is found.
        :type NoticeId: str
        :param _AMPConsumerId: AMP consumer ID.

Note: This field may return null, indicating that no valid value is found.
        :type AMPConsumerId: str
        """
        self._NoticeId = None
        self._AMPConsumerId = None

    @property
    def NoticeId(self):
        """Notification template ID.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._NoticeId

    @NoticeId.setter
    def NoticeId(self, NoticeId):
        self._NoticeId = NoticeId

    @property
    def AMPConsumerId(self):
        """AMP consumer ID.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._AMPConsumerId

    @AMPConsumerId.setter
    def AMPConsumerId(self, AMPConsumerId):
        self._AMPConsumerId = AMPConsumerId


    def _deserialize(self, params):
        self._NoticeId = params.get("NoticeId")
        self._AMPConsumerId = params.get("AMPConsumerId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AlertChannelRecord(AbstractModel):
    """Alert notification recipient group.

    """

    def __init__(self):
        r"""
        :param _NoticeId: Notice ID.

Note: This field may return null, indicating that no valid value is found.
        :type NoticeId: str
        :param _AMPConsumerId: Consumer ID.

Note: This field may return null, indicating that no valid value is found.
        :type AMPConsumerId: str
        :param _ProjectId: Project ID.

Note: This field may return null, indicating that no valid value is found.
        :type ProjectId: str
        :param _Status: Status.

Note: This field may return null, indicating that no valid value is found.
        :type Status: int
        :param _CreatedAt: Create time.

Note: This field may return null, indicating that no valid value is found.
        :type CreatedAt: str
        :param _UpdatedAt: Update time.

Note: This field may return null, indicating that no valid value is found.
        :type UpdatedAt: str
        :param _AppId: App ID.

Note: This field may return null, indicating that no valid value is found.
        :type AppId: int
        :param _Uin: Account uin.

Note: This field may return null, indicating that no valid value is found.
        :type Uin: str
        :param _SubAccountUin: Sub account uin.

Note: This field may return null, indicating that no valid value is found.
        :type SubAccountUin: str
        """
        self._NoticeId = None
        self._AMPConsumerId = None
        self._ProjectId = None
        self._Status = None
        self._CreatedAt = None
        self._UpdatedAt = None
        self._AppId = None
        self._Uin = None
        self._SubAccountUin = None

    @property
    def NoticeId(self):
        """Notice ID.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._NoticeId

    @NoticeId.setter
    def NoticeId(self, NoticeId):
        self._NoticeId = NoticeId

    @property
    def AMPConsumerId(self):
        """Consumer ID.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._AMPConsumerId

    @AMPConsumerId.setter
    def AMPConsumerId(self, AMPConsumerId):
        self._AMPConsumerId = AMPConsumerId

    @property
    def ProjectId(self):
        """Project ID.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Status(self):
        """Status.

Note: This field may return null, indicating that no valid value is found.
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def CreatedAt(self):
        """Create time.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._CreatedAt

    @CreatedAt.setter
    def CreatedAt(self, CreatedAt):
        self._CreatedAt = CreatedAt

    @property
    def UpdatedAt(self):
        """Update time.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._UpdatedAt

    @UpdatedAt.setter
    def UpdatedAt(self, UpdatedAt):
        self._UpdatedAt = UpdatedAt

    @property
    def AppId(self):
        """App ID.

Note: This field may return null, indicating that no valid value is found.
        :rtype: int
        """
        return self._AppId

    @AppId.setter
    def AppId(self, AppId):
        self._AppId = AppId

    @property
    def Uin(self):
        """Account uin.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Uin

    @Uin.setter
    def Uin(self, Uin):
        self._Uin = Uin

    @property
    def SubAccountUin(self):
        """Sub account uin.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._SubAccountUin

    @SubAccountUin.setter
    def SubAccountUin(self, SubAccountUin):
        self._SubAccountUin = SubAccountUin


    def _deserialize(self, params):
        self._NoticeId = params.get("NoticeId")
        self._AMPConsumerId = params.get("AMPConsumerId")
        self._ProjectId = params.get("ProjectId")
        self._Status = params.get("Status")
        self._CreatedAt = params.get("CreatedAt")
        self._UpdatedAt = params.get("UpdatedAt")
        self._AppId = params.get("AppId")
        self._Uin = params.get("Uin")
        self._SubAccountUin = params.get("SubAccountUin")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AlertRecord(AbstractModel):
    """Alert history record.

    """

    def __init__(self):
        r"""
        :param _AlertRecordId: Alert history record ID.

Note: This field may return null, indicating that no valid value is found.
        :type AlertRecordId: str
        :param _ProjectId: Project ID.

Note: This field may return null, indicating that no valid value is found.
        :type ProjectId: str
        :param _ScenarioId: Scenario ID.

Note: This field may return null, indicating that no valid value is found.
        :type ScenarioId: str
        :param _Status: Status.

Note: This field may return null, indicating that no valid value is found.
        :type Status: :class:`tencentcloud.pts.v20210728.models.AlertRecordStatus`
        :param _CreatedAt: Create time.

Note: This field may return null, indicating that no valid value is found.
        :type CreatedAt: str
        :param _UpdatedAt: Update time.

Note: This field may return null, indicating that no valid value is found.
        :type UpdatedAt: str
        :param _JobId: Job ID.

Note: This field may return null, indicating that no valid value is found.
        :type JobId: str
        :param _AppId: App ID.

Note: This field may return null, indicating that no valid value is found.
        :type AppId: int
        :param _Uin: Account uin.

Note: This field may return null, indicating that no valid value is found.
        :type Uin: str
        :param _SubAccountUin: Sub account uin.

Note: This field may return null, indicating that no valid value is found.
        :type SubAccountUin: str
        :param _ScenarioName: Scenario name.

Note: This field may return null, indicating that no valid value is found.
        :type ScenarioName: str
        :param _Target: Alert target.

Note: This field may return null, indicating that no valid value is found.
        :type Target: str
        :param _JobSLAId: SLA ID.

Note: This field may return null, indicating that no valid value is found.
        :type JobSLAId: str
        :param _JobSLADescription: SLA description.

Note: This field may return null, indicating that no valid value is found.
        :type JobSLADescription: str
        """
        self._AlertRecordId = None
        self._ProjectId = None
        self._ScenarioId = None
        self._Status = None
        self._CreatedAt = None
        self._UpdatedAt = None
        self._JobId = None
        self._AppId = None
        self._Uin = None
        self._SubAccountUin = None
        self._ScenarioName = None
        self._Target = None
        self._JobSLAId = None
        self._JobSLADescription = None

    @property
    def AlertRecordId(self):
        """Alert history record ID.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._AlertRecordId

    @AlertRecordId.setter
    def AlertRecordId(self, AlertRecordId):
        self._AlertRecordId = AlertRecordId

    @property
    def ProjectId(self):
        """Project ID.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ScenarioId(self):
        """Scenario ID.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._ScenarioId

    @ScenarioId.setter
    def ScenarioId(self, ScenarioId):
        self._ScenarioId = ScenarioId

    @property
    def Status(self):
        """Status.

Note: This field may return null, indicating that no valid value is found.
        :rtype: :class:`tencentcloud.pts.v20210728.models.AlertRecordStatus`
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def CreatedAt(self):
        """Create time.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._CreatedAt

    @CreatedAt.setter
    def CreatedAt(self, CreatedAt):
        self._CreatedAt = CreatedAt

    @property
    def UpdatedAt(self):
        """Update time.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._UpdatedAt

    @UpdatedAt.setter
    def UpdatedAt(self, UpdatedAt):
        self._UpdatedAt = UpdatedAt

    @property
    def JobId(self):
        """Job ID.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def AppId(self):
        """App ID.

Note: This field may return null, indicating that no valid value is found.
        :rtype: int
        """
        return self._AppId

    @AppId.setter
    def AppId(self, AppId):
        self._AppId = AppId

    @property
    def Uin(self):
        """Account uin.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Uin

    @Uin.setter
    def Uin(self, Uin):
        self._Uin = Uin

    @property
    def SubAccountUin(self):
        """Sub account uin.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._SubAccountUin

    @SubAccountUin.setter
    def SubAccountUin(self, SubAccountUin):
        self._SubAccountUin = SubAccountUin

    @property
    def ScenarioName(self):
        """Scenario name.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._ScenarioName

    @ScenarioName.setter
    def ScenarioName(self, ScenarioName):
        self._ScenarioName = ScenarioName

    @property
    def Target(self):
        """Alert target.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Target

    @Target.setter
    def Target(self, Target):
        self._Target = Target

    @property
    def JobSLAId(self):
        """SLA ID.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._JobSLAId

    @JobSLAId.setter
    def JobSLAId(self, JobSLAId):
        self._JobSLAId = JobSLAId

    @property
    def JobSLADescription(self):
        """SLA description.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._JobSLADescription

    @JobSLADescription.setter
    def JobSLADescription(self, JobSLADescription):
        self._JobSLADescription = JobSLADescription


    def _deserialize(self, params):
        self._AlertRecordId = params.get("AlertRecordId")
        self._ProjectId = params.get("ProjectId")
        self._ScenarioId = params.get("ScenarioId")
        if params.get("Status") is not None:
            self._Status = AlertRecordStatus()
            self._Status._deserialize(params.get("Status"))
        self._CreatedAt = params.get("CreatedAt")
        self._UpdatedAt = params.get("UpdatedAt")
        self._JobId = params.get("JobId")
        self._AppId = params.get("AppId")
        self._Uin = params.get("Uin")
        self._SubAccountUin = params.get("SubAccountUin")
        self._ScenarioName = params.get("ScenarioName")
        self._Target = params.get("Target")
        self._JobSLAId = params.get("JobSLAId")
        self._JobSLADescription = params.get("JobSLADescription")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AlertRecordStatus(AbstractModel):
    """Status of alert history record

    """

    def __init__(self):
        r"""
        :param _AbortJob: Success or failure of stopping performance test job.

Note: This field may return null, indicating that no valid value is found.
        :type AbortJob: int
        :param _SendNotice: Success or failure of sending alert notification.

Note: This field may return null, indicating that no valid value is found.
        :type SendNotice: int
        """
        self._AbortJob = None
        self._SendNotice = None

    @property
    def AbortJob(self):
        """Success or failure of stopping performance test job.

Note: This field may return null, indicating that no valid value is found.
        :rtype: int
        """
        return self._AbortJob

    @AbortJob.setter
    def AbortJob(self, AbortJob):
        self._AbortJob = AbortJob

    @property
    def SendNotice(self):
        """Success or failure of sending alert notification.

Note: This field may return null, indicating that no valid value is found.
        :rtype: int
        """
        return self._SendNotice

    @SendNotice.setter
    def SendNotice(self, SendNotice):
        self._SendNotice = SendNotice


    def _deserialize(self, params):
        self._AbortJob = params.get("AbortJob")
        self._SendNotice = params.get("SendNotice")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Attributes(AbstractModel):
    """Sampling log attributes

    """

    def __init__(self):
        r"""
        :param _Status: Response status code.

Note: This field may return null, indicating that no valid value is found.
        :type Status: str
        :param _Result: Response result code.

Note: This field may return null, indicating that no valid value is found.
        :type Result: str
        :param _Service: Request service.

Note: This field may return null, indicating that no valid value is found.
        :type Service: str
        :param _Method: Request method.

Note: This field may return null, indicating that no valid value is found.
        :type Method: str
        :param _Duration: Request duration.

Note: This field may return null, indicating that no valid value is found.
        :type Duration: str
        """
        self._Status = None
        self._Result = None
        self._Service = None
        self._Method = None
        self._Duration = None

    @property
    def Status(self):
        """Response status code.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Result(self):
        """Response result code.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def Service(self):
        """Request service.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Service

    @Service.setter
    def Service(self, Service):
        self._Service = Service

    @property
    def Method(self):
        """Request method.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Method

    @Method.setter
    def Method(self, Method):
        self._Method = Method

    @property
    def Duration(self):
        """Request duration.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._Result = params.get("Result")
        self._Service = params.get("Service")
        self._Method = params.get("Method")
        self._Duration = params.get("Duration")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckSummary(AbstractModel):
    """Checkpoint summary results

    """

    def __init__(self):
        r"""
        :param _Name: Checkpoint name.
        :type Name: str
        :param _Step: Step name of the checkpoint.
        :type Step: str
        :param _SuccessCount: Number of successful checks.
        :type SuccessCount: int
        :param _FailCount: Number of failed checks.
        :type FailCount: int
        :param _ErrorRate: Error ratio.
        :type ErrorRate: float
        """
        self._Name = None
        self._Step = None
        self._SuccessCount = None
        self._FailCount = None
        self._ErrorRate = None

    @property
    def Name(self):
        """Checkpoint name.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Step(self):
        """Step name of the checkpoint.
        :rtype: str
        """
        return self._Step

    @Step.setter
    def Step(self, Step):
        self._Step = Step

    @property
    def SuccessCount(self):
        """Number of successful checks.
        :rtype: int
        """
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailCount(self):
        """Number of failed checks.
        :rtype: int
        """
        return self._FailCount

    @FailCount.setter
    def FailCount(self, FailCount):
        self._FailCount = FailCount

    @property
    def ErrorRate(self):
        """Error ratio.
        :rtype: float
        """
        return self._ErrorRate

    @ErrorRate.setter
    def ErrorRate(self, ErrorRate):
        self._ErrorRate = ErrorRate


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Step = params.get("Step")
        self._SuccessCount = params.get("SuccessCount")
        self._FailCount = params.get("FailCount")
        self._ErrorRate = params.get("ErrorRate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Concurrency(AbstractModel):
    """Load configuration for concurrency mode

    """

    def __init__(self):
        r"""
        :param _Stages: Array of multi-stage configuration.

Note: This field may return null, indicating that no valid value is found.
        :type Stages: list of Stage
        :param _IterationCount: Number of iteration.

Note: This field may return null, indicating that no valid value is found.
        :type IterationCount: int
        :param _MaxRequestsPerSecond: Maximum rps.

Note: This field may return null, indicating that no valid value is found.
        :type MaxRequestsPerSecond: int
        :param _GracefulStopSeconds: Graceful termination job waiting time.

Note: This field may return null, indicating that no valid value is found.
        :type GracefulStopSeconds: int
        :param _Resources: Number of resource.

Note: This field may return null, indicating that no valid value is found.
        :type Resources: int
        """
        self._Stages = None
        self._IterationCount = None
        self._MaxRequestsPerSecond = None
        self._GracefulStopSeconds = None
        self._Resources = None

    @property
    def Stages(self):
        """Array of multi-stage configuration.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of Stage
        """
        return self._Stages

    @Stages.setter
    def Stages(self, Stages):
        self._Stages = Stages

    @property
    def IterationCount(self):
        """Number of iteration.

Note: This field may return null, indicating that no valid value is found.
        :rtype: int
        """
        return self._IterationCount

    @IterationCount.setter
    def IterationCount(self, IterationCount):
        self._IterationCount = IterationCount

    @property
    def MaxRequestsPerSecond(self):
        """Maximum rps.

Note: This field may return null, indicating that no valid value is found.
        :rtype: int
        """
        return self._MaxRequestsPerSecond

    @MaxRequestsPerSecond.setter
    def MaxRequestsPerSecond(self, MaxRequestsPerSecond):
        self._MaxRequestsPerSecond = MaxRequestsPerSecond

    @property
    def GracefulStopSeconds(self):
        """Graceful termination job waiting time.

Note: This field may return null, indicating that no valid value is found.
        :rtype: int
        """
        return self._GracefulStopSeconds

    @GracefulStopSeconds.setter
    def GracefulStopSeconds(self, GracefulStopSeconds):
        self._GracefulStopSeconds = GracefulStopSeconds

    @property
    def Resources(self):
        """Number of resource.

Note: This field may return null, indicating that no valid value is found.
        :rtype: int
        """
        return self._Resources

    @Resources.setter
    def Resources(self, Resources):
        self._Resources = Resources


    def _deserialize(self, params):
        if params.get("Stages") is not None:
            self._Stages = []
            for item in params.get("Stages"):
                obj = Stage()
                obj._deserialize(item)
                self._Stages.append(obj)
        self._IterationCount = params.get("IterationCount")
        self._MaxRequestsPerSecond = params.get("MaxRequestsPerSecond")
        self._GracefulStopSeconds = params.get("GracefulStopSeconds")
        self._Resources = params.get("Resources")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CopyScenarioRequest(AbstractModel):
    """CopyScenario request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID.
        :type ProjectId: str
        :param _ScenarioId: Scenario ID.
        :type ScenarioId: str
        """
        self._ProjectId = None
        self._ScenarioId = None

    @property
    def ProjectId(self):
        """Project ID.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ScenarioId(self):
        """Scenario ID.
        :rtype: str
        """
        return self._ScenarioId

    @ScenarioId.setter
    def ScenarioId(self, ScenarioId):
        self._ScenarioId = ScenarioId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._ScenarioId = params.get("ScenarioId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CopyScenarioResponse(AbstractModel):
    """CopyScenario response structure.

    """

    def __init__(self):
        r"""
        :param _ScenarioId: Newly copied scenario ID.
        :type ScenarioId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ScenarioId = None
        self._RequestId = None

    @property
    def ScenarioId(self):
        """Newly copied scenario ID.
        :rtype: str
        """
        return self._ScenarioId

    @ScenarioId.setter
    def ScenarioId(self, ScenarioId):
        self._ScenarioId = ScenarioId

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ScenarioId = params.get("ScenarioId")
        self._RequestId = params.get("RequestId")


class CreateAlertChannelRequest(AbstractModel):
    """CreateAlertChannel request structure.

    """

    def __init__(self):
        r"""
        :param _NoticeId: The NoticeId of alarm notification template in the monitor service, can be obtained from the Id field in the response of the DescribeAlarmNotices API of the monitor service's cloud API. (In the input parameters of the CreateAlertChannel API, either AMPConsumerId or NoticeId can be used to identify an alarm notification template.)
        :type NoticeId: str
        :param _ProjectId: Project ID.
        :type ProjectId: str
        :param _AMPConsumerId: The AMPConsumerId of alarm notification template for monitor service, can be obtained from the AMPConsumerId field in the response of the DescribeAlarmNotices API of the monitor service's cloud API. (In the input parameters of the CreateAlertChannel API, either AMPConsumerId or Noticeid can be used to identify an alarm notification template.)
        :type AMPConsumerId: str
        """
        self._NoticeId = None
        self._ProjectId = None
        self._AMPConsumerId = None

    @property
    def NoticeId(self):
        """The NoticeId of alarm notification template in the monitor service, can be obtained from the Id field in the response of the DescribeAlarmNotices API of the monitor service's cloud API. (In the input parameters of the CreateAlertChannel API, either AMPConsumerId or NoticeId can be used to identify an alarm notification template.)
        :rtype: str
        """
        return self._NoticeId

    @NoticeId.setter
    def NoticeId(self, NoticeId):
        self._NoticeId = NoticeId

    @property
    def ProjectId(self):
        """Project ID.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def AMPConsumerId(self):
        """The AMPConsumerId of alarm notification template for monitor service, can be obtained from the AMPConsumerId field in the response of the DescribeAlarmNotices API of the monitor service's cloud API. (In the input parameters of the CreateAlertChannel API, either AMPConsumerId or Noticeid can be used to identify an alarm notification template.)
        :rtype: str
        """
        return self._AMPConsumerId

    @AMPConsumerId.setter
    def AMPConsumerId(self, AMPConsumerId):
        self._AMPConsumerId = AMPConsumerId


    def _deserialize(self, params):
        self._NoticeId = params.get("NoticeId")
        self._ProjectId = params.get("ProjectId")
        self._AMPConsumerId = params.get("AMPConsumerId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAlertChannelResponse(AbstractModel):
    """CreateAlertChannel response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateCronJobRequest(AbstractModel):
    """CreateCronJob request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Name.
        :type Name: str
        :param _ProjectId: Project ID.
        :type ProjectId: str
        :param _ScenarioId: Scenario ID.
        :type ScenarioId: str
        :param _ScenarioName: Scenario name.
        :type ScenarioName: str
        :param _FrequencyType: Execution frequency type: 1, execute once only; 2, Daily; 3, Weekly; 4, Advanced mode using cron expression.
        :type FrequencyType: int
        :param _CronExpression: Cron expression.
        :type CronExpression: str
        :param _JobOwner: Cron job initiator.
        :type JobOwner: str
        :param _EndTime: End time.
        :type EndTime: str
        :param _NoticeId: Notice ID.
        :type NoticeId: str
        :param _Note: Note.
        :type Note: str
        """
        self._Name = None
        self._ProjectId = None
        self._ScenarioId = None
        self._ScenarioName = None
        self._FrequencyType = None
        self._CronExpression = None
        self._JobOwner = None
        self._EndTime = None
        self._NoticeId = None
        self._Note = None

    @property
    def Name(self):
        """Name.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def ProjectId(self):
        """Project ID.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ScenarioId(self):
        """Scenario ID.
        :rtype: str
        """
        return self._ScenarioId

    @ScenarioId.setter
    def ScenarioId(self, ScenarioId):
        self._ScenarioId = ScenarioId

    @property
    def ScenarioName(self):
        """Scenario name.
        :rtype: str
        """
        return self._ScenarioName

    @ScenarioName.setter
    def ScenarioName(self, ScenarioName):
        self._ScenarioName = ScenarioName

    @property
    def FrequencyType(self):
        """Execution frequency type: 1, execute once only; 2, Daily; 3, Weekly; 4, Advanced mode using cron expression.
        :rtype: int
        """
        return self._FrequencyType

    @FrequencyType.setter
    def FrequencyType(self, FrequencyType):
        self._FrequencyType = FrequencyType

    @property
    def CronExpression(self):
        """Cron expression.
        :rtype: str
        """
        return self._CronExpression

    @CronExpression.setter
    def CronExpression(self, CronExpression):
        self._CronExpression = CronExpression

    @property
    def JobOwner(self):
        """Cron job initiator.
        :rtype: str
        """
        return self._JobOwner

    @JobOwner.setter
    def JobOwner(self, JobOwner):
        self._JobOwner = JobOwner

    @property
    def EndTime(self):
        """End time.
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def NoticeId(self):
        """Notice ID.
        :rtype: str
        """
        return self._NoticeId

    @NoticeId.setter
    def NoticeId(self, NoticeId):
        self._NoticeId = NoticeId

    @property
    def Note(self):
        """Note.
        :rtype: str
        """
        return self._Note

    @Note.setter
    def Note(self, Note):
        self._Note = Note


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._ProjectId = params.get("ProjectId")
        self._ScenarioId = params.get("ScenarioId")
        self._ScenarioName = params.get("ScenarioName")
        self._FrequencyType = params.get("FrequencyType")
        self._CronExpression = params.get("CronExpression")
        self._JobOwner = params.get("JobOwner")
        self._EndTime = params.get("EndTime")
        self._NoticeId = params.get("NoticeId")
        self._Note = params.get("Note")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateCronJobResponse(AbstractModel):
    """CreateCronJob response structure.

    """

    def __init__(self):
        r"""
        :param _CronJobId: Cron job ID.
        :type CronJobId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._CronJobId = None
        self._RequestId = None

    @property
    def CronJobId(self):
        """Cron job ID.
        :rtype: str
        """
        return self._CronJobId

    @CronJobId.setter
    def CronJobId(self, CronJobId):
        self._CronJobId = CronJobId

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._CronJobId = params.get("CronJobId")
        self._RequestId = params.get("RequestId")


class CreateEnvironmentRequest(AbstractModel):
    """CreateEnvironment request structure.

    """


class CreateEnvironmentResponse(AbstractModel):
    """CreateEnvironment response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateFileRequest(AbstractModel):
    """CreateFile request structure.

    """

    def __init__(self):
        r"""
        :param _FileId: File ID. Its value should be the corresponding directory of the file in the COS bucket after it has been uploaded in the previous step.
        :type FileId: str
        :param _ProjectId: Project ID.
        :type ProjectId: str
        :param _Kind: File type. 1 represents parameter file, 2 represents protocol file, 3 represents request file.
        :type Kind: int
        :param _Name: Filename.
        :type Name: str
        :param _Size: File size.
        :type Size: int
        :param _Type: File type. The 'folder' represents a folder; if not specified, it represents a file.
        :type Type: str
        :param _LineCount: Number of Rows.
        :type LineCount: int
        :param _HeadLines: First few rows of file.
        :type HeadLines: list of str
        :param _TailLines: Last few rows of file.
        :type TailLines: list of str
        :param _HeaderInFile: Whether the header is in the file.
        :type HeaderInFile: bool
        :param _HeaderColumns: Header.
        :type HeaderColumns: list of str
        :param _FileInfos: Files in the folder.
        :type FileInfos: list of FileInfo
        """
        self._FileId = None
        self._ProjectId = None
        self._Kind = None
        self._Name = None
        self._Size = None
        self._Type = None
        self._LineCount = None
        self._HeadLines = None
        self._TailLines = None
        self._HeaderInFile = None
        self._HeaderColumns = None
        self._FileInfos = None

    @property
    def FileId(self):
        """File ID. Its value should be the corresponding directory of the file in the COS bucket after it has been uploaded in the previous step.
        :rtype: str
        """
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def ProjectId(self):
        """Project ID.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Kind(self):
        """File type. 1 represents parameter file, 2 represents protocol file, 3 represents request file.
        :rtype: int
        """
        return self._Kind

    @Kind.setter
    def Kind(self, Kind):
        self._Kind = Kind

    @property
    def Name(self):
        """Filename.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Size(self):
        """File size.
        :rtype: int
        """
        return self._Size

    @Size.setter
    def Size(self, Size):
        self._Size = Size

    @property
    def Type(self):
        """File type. The 'folder' represents a folder; if not specified, it represents a file.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def LineCount(self):
        """Number of Rows.
        :rtype: int
        """
        return self._LineCount

    @LineCount.setter
    def LineCount(self, LineCount):
        self._LineCount = LineCount

    @property
    def HeadLines(self):
        """First few rows of file.
        :rtype: list of str
        """
        return self._HeadLines

    @HeadLines.setter
    def HeadLines(self, HeadLines):
        self._HeadLines = HeadLines

    @property
    def TailLines(self):
        """Last few rows of file.
        :rtype: list of str
        """
        return self._TailLines

    @TailLines.setter
    def TailLines(self, TailLines):
        self._TailLines = TailLines

    @property
    def HeaderInFile(self):
        """Whether the header is in the file.
        :rtype: bool
        """
        return self._HeaderInFile

    @HeaderInFile.setter
    def HeaderInFile(self, HeaderInFile):
        self._HeaderInFile = HeaderInFile

    @property
    def HeaderColumns(self):
        """Header.
        :rtype: list of str
        """
        return self._HeaderColumns

    @HeaderColumns.setter
    def HeaderColumns(self, HeaderColumns):
        self._HeaderColumns = HeaderColumns

    @property
    def FileInfos(self):
        """Files in the folder.
        :rtype: list of FileInfo
        """
        return self._FileInfos

    @FileInfos.setter
    def FileInfos(self, FileInfos):
        self._FileInfos = FileInfos


    def _deserialize(self, params):
        self._FileId = params.get("FileId")
        self._ProjectId = params.get("ProjectId")
        self._Kind = params.get("Kind")
        self._Name = params.get("Name")
        self._Size = params.get("Size")
        self._Type = params.get("Type")
        self._LineCount = params.get("LineCount")
        self._HeadLines = params.get("HeadLines")
        self._TailLines = params.get("TailLines")
        self._HeaderInFile = params.get("HeaderInFile")
        self._HeaderColumns = params.get("HeaderColumns")
        if params.get("FileInfos") is not None:
            self._FileInfos = []
            for item in params.get("FileInfos"):
                obj = FileInfo()
                obj._deserialize(item)
                self._FileInfos.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateFileResponse(AbstractModel):
    """CreateFile response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateProjectRequest(AbstractModel):
    """CreateProject request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Project name.
        :type Name: str
        :param _Description: Project description.
        :type Description: str
        :param _Tags: Array of tags.
        :type Tags: list of TagSpec
        """
        self._Name = None
        self._Description = None
        self._Tags = None

    @property
    def Name(self):
        """Project name.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Description(self):
        """Project description.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Tags(self):
        """Array of tags.
        :rtype: list of TagSpec
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Description = params.get("Description")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = TagSpec()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateProjectResponse(AbstractModel):
    """CreateProject response structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID.
        :type ProjectId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ProjectId = None
        self._RequestId = None

    @property
    def ProjectId(self):
        """Project ID.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._RequestId = params.get("RequestId")


class CreateScenarioRequest(AbstractModel):
    """CreateScenario request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Scenario Name.
        :type Name: str
        :param _Type: Mode type of scenario. Valid values: 'pts-http' represents the simple mode, 'pts-js' represents the script mode, 'pts-jmeter' represents the JMeter mode.
        :type Type: str
        :param _ProjectId: Project ID.
        :type ProjectId: str
        :param _Description: Scenario description.
        :type Description: str
        :param _Load: Load configuration.
        :type Load: :class:`tencentcloud.pts.v20210728.models.Load`
        :param _Configs: Deprecated.
        :type Configs: list of str
        :param _Datasets: Test datasets.
        :type Datasets: list of TestData
        :param _Extensions: Deprecated.
        :type Extensions: list of str
        :param _SLAId: Deprecated.
        :type SLAId: str
        :param _CronId: Cron job ID.
        :type CronId: str
        :param _Scripts: Deprecated,
        :type Scripts: list of str
        :param _TestScripts: Test scripts.
        :type TestScripts: list of ScriptInfo
        :param _Protocols: Protocol files.
        :type Protocols: list of ProtocolInfo
        :param _RequestFiles: Request files.
        :type RequestFiles: list of FileInfo
        :param _SLAPolicy: SLA policy.
        :type SLAPolicy: :class:`tencentcloud.pts.v20210728.models.SLAPolicy`
        :param _Plugins: Extension plugin files.
        :type Plugins: list of FileInfo
        :param _DomainNameConfig: Domain name resolution configuration.
        :type DomainNameConfig: :class:`tencentcloud.pts.v20210728.models.DomainNameConfig`
        :param _Owner: Creator name.
        :type Owner: str
        """
        self._Name = None
        self._Type = None
        self._ProjectId = None
        self._Description = None
        self._Load = None
        self._Configs = None
        self._Datasets = None
        self._Extensions = None
        self._SLAId = None
        self._CronId = None
        self._Scripts = None
        self._TestScripts = None
        self._Protocols = None
        self._RequestFiles = None
        self._SLAPolicy = None
        self._Plugins = None
        self._DomainNameConfig = None
        self._Owner = None

    @property
    def Name(self):
        """Scenario Name.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Type(self):
        """Mode type of scenario. Valid values: 'pts-http' represents the simple mode, 'pts-js' represents the script mode, 'pts-jmeter' represents the JMeter mode.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def ProjectId(self):
        """Project ID.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Description(self):
        """Scenario description.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Load(self):
        """Load configuration.
        :rtype: :class:`tencentcloud.pts.v20210728.models.Load`
        """
        return self._Load

    @Load.setter
    def Load(self, Load):
        self._Load = Load

    @property
    def Configs(self):
        """Deprecated.
        :rtype: list of str
        """
        return self._Configs

    @Configs.setter
    def Configs(self, Configs):
        self._Configs = Configs

    @property
    def Datasets(self):
        """Test datasets.
        :rtype: list of TestData
        """
        return self._Datasets

    @Datasets.setter
    def Datasets(self, Datasets):
        self._Datasets = Datasets

    @property
    def Extensions(self):
        """Deprecated.
        :rtype: list of str
        """
        return self._Extensions

    @Extensions.setter
    def Extensions(self, Extensions):
        self._Extensions = Extensions

    @property
    def SLAId(self):
        """Deprecated.
        :rtype: str
        """
        return self._SLAId

    @SLAId.setter
    def SLAId(self, SLAId):
        self._SLAId = SLAId

    @property
    def CronId(self):
        """Cron job ID.
        :rtype: str
        """
        return self._CronId

    @CronId.setter
    def CronId(self, CronId):
        self._CronId = CronId

    @property
    def Scripts(self):
        """Deprecated,
        :rtype: list of str
        """
        return self._Scripts

    @Scripts.setter
    def Scripts(self, Scripts):
        self._Scripts = Scripts

    @property
    def TestScripts(self):
        """Test scripts.
        :rtype: list of ScriptInfo
        """
        return self._TestScripts

    @TestScripts.setter
    def TestScripts(self, TestScripts):
        self._TestScripts = TestScripts

    @property
    def Protocols(self):
        """Protocol files.
        :rtype: list of ProtocolInfo
        """
        return self._Protocols

    @Protocols.setter
    def Protocols(self, Protocols):
        self._Protocols = Protocols

    @property
    def RequestFiles(self):
        """Request files.
        :rtype: list of FileInfo
        """
        return self._RequestFiles

    @RequestFiles.setter
    def RequestFiles(self, RequestFiles):
        self._RequestFiles = RequestFiles

    @property
    def SLAPolicy(self):
        """SLA policy.
        :rtype: :class:`tencentcloud.pts.v20210728.models.SLAPolicy`
        """
        return self._SLAPolicy

    @SLAPolicy.setter
    def SLAPolicy(self, SLAPolicy):
        self._SLAPolicy = SLAPolicy

    @property
    def Plugins(self):
        """Extension plugin files.
        :rtype: list of FileInfo
        """
        return self._Plugins

    @Plugins.setter
    def Plugins(self, Plugins):
        self._Plugins = Plugins

    @property
    def DomainNameConfig(self):
        """Domain name resolution configuration.
        :rtype: :class:`tencentcloud.pts.v20210728.models.DomainNameConfig`
        """
        return self._DomainNameConfig

    @DomainNameConfig.setter
    def DomainNameConfig(self, DomainNameConfig):
        self._DomainNameConfig = DomainNameConfig

    @property
    def Owner(self):
        """Creator name.
        :rtype: str
        """
        return self._Owner

    @Owner.setter
    def Owner(self, Owner):
        self._Owner = Owner


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Type = params.get("Type")
        self._ProjectId = params.get("ProjectId")
        self._Description = params.get("Description")
        if params.get("Load") is not None:
            self._Load = Load()
            self._Load._deserialize(params.get("Load"))
        self._Configs = params.get("Configs")
        if params.get("Datasets") is not None:
            self._Datasets = []
            for item in params.get("Datasets"):
                obj = TestData()
                obj._deserialize(item)
                self._Datasets.append(obj)
        self._Extensions = params.get("Extensions")
        self._SLAId = params.get("SLAId")
        self._CronId = params.get("CronId")
        self._Scripts = params.get("Scripts")
        if params.get("TestScripts") is not None:
            self._TestScripts = []
            for item in params.get("TestScripts"):
                obj = ScriptInfo()
                obj._deserialize(item)
                self._TestScripts.append(obj)
        if params.get("Protocols") is not None:
            self._Protocols = []
            for item in params.get("Protocols"):
                obj = ProtocolInfo()
                obj._deserialize(item)
                self._Protocols.append(obj)
        if params.get("RequestFiles") is not None:
            self._RequestFiles = []
            for item in params.get("RequestFiles"):
                obj = FileInfo()
                obj._deserialize(item)
                self._RequestFiles.append(obj)
        if params.get("SLAPolicy") is not None:
            self._SLAPolicy = SLAPolicy()
            self._SLAPolicy._deserialize(params.get("SLAPolicy"))
        if params.get("Plugins") is not None:
            self._Plugins = []
            for item in params.get("Plugins"):
                obj = FileInfo()
                obj._deserialize(item)
                self._Plugins.append(obj)
        if params.get("DomainNameConfig") is not None:
            self._DomainNameConfig = DomainNameConfig()
            self._DomainNameConfig._deserialize(params.get("DomainNameConfig"))
        self._Owner = params.get("Owner")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateScenarioResponse(AbstractModel):
    """CreateScenario response structure.

    """

    def __init__(self):
        r"""
        :param _ScenarioId: Scenario ID.
        :type ScenarioId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ScenarioId = None
        self._RequestId = None

    @property
    def ScenarioId(self):
        """Scenario ID.
        :rtype: str
        """
        return self._ScenarioId

    @ScenarioId.setter
    def ScenarioId(self, ScenarioId):
        self._ScenarioId = ScenarioId

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ScenarioId = params.get("ScenarioId")
        self._RequestId = params.get("RequestId")


class Credentials(AbstractModel):
    """COS temporary credentials.

    """

    def __init__(self):
        r"""
        :param _TmpSecretId: Temporary secret ID.
        :type TmpSecretId: str
        :param _TmpSecretKey: Temporary secret key.
        :type TmpSecretKey: str
        :param _Token: Temporary token.
        :type Token: str
        """
        self._TmpSecretId = None
        self._TmpSecretKey = None
        self._Token = None

    @property
    def TmpSecretId(self):
        """Temporary secret ID.
        :rtype: str
        """
        return self._TmpSecretId

    @TmpSecretId.setter
    def TmpSecretId(self, TmpSecretId):
        self._TmpSecretId = TmpSecretId

    @property
    def TmpSecretKey(self):
        """Temporary secret key.
        :rtype: str
        """
        return self._TmpSecretKey

    @TmpSecretKey.setter
    def TmpSecretKey(self, TmpSecretKey):
        self._TmpSecretKey = TmpSecretKey

    @property
    def Token(self):
        """Temporary token.
        :rtype: str
        """
        return self._Token

    @Token.setter
    def Token(self, Token):
        self._Token = Token


    def _deserialize(self, params):
        self._TmpSecretId = params.get("TmpSecretId")
        self._TmpSecretKey = params.get("TmpSecretKey")
        self._Token = params.get("Token")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CronJob(AbstractModel):
    """Cron job.

    """

    def __init__(self):
        r"""
        :param _CronJobId: Cron job ID.

Note: This field may return null, indicating that no valid value is found.
        :type CronJobId: str
        :param _Name: Cron job name.

Note: This field may return null, indicating that no valid value is found.
        :type Name: str
        :param _ProjectId: Project ID.

Note: This field may return null, indicating that no valid value is found.
        :type ProjectId: str
        :param _ScenarioId: Scenario ID.

Note: This field may return null, indicating that no valid value is found.
        :type ScenarioId: str
        :param _ScenarioName: Scenario name.

Note: This field may return null, indicating that no valid value is found.
        :type ScenarioName: str
        :param _CronExpression: Cron expression.

Note: This field may return null, indicating that no valid value is found.
        :type CronExpression: str
        :param _EndTime: End time.

Note: This field may return null, indicating that no valid value is found.
        :type EndTime: str
        :param _AbortReason: Abort reason.

Note: This field may return null, indicating that no valid value is found.
        :type AbortReason: int
        :param _Status: Cron job status.

Note: This field may return null, indicating that no valid value is found.
        :type Status: int
        :param _NoticeId: Notice ID.

Note: This field may return null, indicating that no valid value is found.
        :type NoticeId: str
        :param _CreatedAt: Create time.

Note: This field may return null, indicating that no valid value is found.
        :type CreatedAt: str
        :param _UpdatedAt: Update time.

Note: This field may return null, indicating that no valid value is found.
        :type UpdatedAt: str
        :param _FrequencyType: Execution frequency type: 1, execute once only; 2, Daily; 3, Weekly; 4, Advanced mode using cron expression.

Note: This field may return null, indicating that no valid value is found.
        :type FrequencyType: int
        :param _Note: Note.

Note: This field may return null, indicating that no valid value is found.
        :type Note: str
        :param _JobOwner: Cron job initiator.

Note: This field may return null, indicating that no valid value is found.
        :type JobOwner: str
        :param _AppId: App ID.

Note: This field may return null, indicating that no valid value is found.
        :type AppId: int
        :param _Uin: Account uin.

Note: This field may return null, indicating that no valid value is found.
        :type Uin: str
        :param _SubAccountUin: Sub account uin.

Note: This field may return null, indicating that no valid value is found.
        :type SubAccountUin: str
        """
        self._CronJobId = None
        self._Name = None
        self._ProjectId = None
        self._ScenarioId = None
        self._ScenarioName = None
        self._CronExpression = None
        self._EndTime = None
        self._AbortReason = None
        self._Status = None
        self._NoticeId = None
        self._CreatedAt = None
        self._UpdatedAt = None
        self._FrequencyType = None
        self._Note = None
        self._JobOwner = None
        self._AppId = None
        self._Uin = None
        self._SubAccountUin = None

    @property
    def CronJobId(self):
        """Cron job ID.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._CronJobId

    @CronJobId.setter
    def CronJobId(self, CronJobId):
        self._CronJobId = CronJobId

    @property
    def Name(self):
        """Cron job name.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def ProjectId(self):
        """Project ID.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ScenarioId(self):
        """Scenario ID.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._ScenarioId

    @ScenarioId.setter
    def ScenarioId(self, ScenarioId):
        self._ScenarioId = ScenarioId

    @property
    def ScenarioName(self):
        """Scenario name.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._ScenarioName

    @ScenarioName.setter
    def ScenarioName(self, ScenarioName):
        self._ScenarioName = ScenarioName

    @property
    def CronExpression(self):
        """Cron expression.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._CronExpression

    @CronExpression.setter
    def CronExpression(self, CronExpression):
        self._CronExpression = CronExpression

    @property
    def EndTime(self):
        """End time.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def AbortReason(self):
        """Abort reason.

Note: This field may return null, indicating that no valid value is found.
        :rtype: int
        """
        return self._AbortReason

    @AbortReason.setter
    def AbortReason(self, AbortReason):
        self._AbortReason = AbortReason

    @property
    def Status(self):
        """Cron job status.

Note: This field may return null, indicating that no valid value is found.
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def NoticeId(self):
        """Notice ID.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._NoticeId

    @NoticeId.setter
    def NoticeId(self, NoticeId):
        self._NoticeId = NoticeId

    @property
    def CreatedAt(self):
        """Create time.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._CreatedAt

    @CreatedAt.setter
    def CreatedAt(self, CreatedAt):
        self._CreatedAt = CreatedAt

    @property
    def UpdatedAt(self):
        """Update time.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._UpdatedAt

    @UpdatedAt.setter
    def UpdatedAt(self, UpdatedAt):
        self._UpdatedAt = UpdatedAt

    @property
    def FrequencyType(self):
        """Execution frequency type: 1, execute once only; 2, Daily; 3, Weekly; 4, Advanced mode using cron expression.

Note: This field may return null, indicating that no valid value is found.
        :rtype: int
        """
        return self._FrequencyType

    @FrequencyType.setter
    def FrequencyType(self, FrequencyType):
        self._FrequencyType = FrequencyType

    @property
    def Note(self):
        """Note.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Note

    @Note.setter
    def Note(self, Note):
        self._Note = Note

    @property
    def JobOwner(self):
        """Cron job initiator.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._JobOwner

    @JobOwner.setter
    def JobOwner(self, JobOwner):
        self._JobOwner = JobOwner

    @property
    def AppId(self):
        """App ID.

Note: This field may return null, indicating that no valid value is found.
        :rtype: int
        """
        return self._AppId

    @AppId.setter
    def AppId(self, AppId):
        self._AppId = AppId

    @property
    def Uin(self):
        """Account uin.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Uin

    @Uin.setter
    def Uin(self, Uin):
        self._Uin = Uin

    @property
    def SubAccountUin(self):
        """Sub account uin.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._SubAccountUin

    @SubAccountUin.setter
    def SubAccountUin(self, SubAccountUin):
        self._SubAccountUin = SubAccountUin


    def _deserialize(self, params):
        self._CronJobId = params.get("CronJobId")
        self._Name = params.get("Name")
        self._ProjectId = params.get("ProjectId")
        self._ScenarioId = params.get("ScenarioId")
        self._ScenarioName = params.get("ScenarioName")
        self._CronExpression = params.get("CronExpression")
        self._EndTime = params.get("EndTime")
        self._AbortReason = params.get("AbortReason")
        self._Status = params.get("Status")
        self._NoticeId = params.get("NoticeId")
        self._CreatedAt = params.get("CreatedAt")
        self._UpdatedAt = params.get("UpdatedAt")
        self._FrequencyType = params.get("FrequencyType")
        self._Note = params.get("Note")
        self._JobOwner = params.get("JobOwner")
        self._AppId = params.get("AppId")
        self._Uin = params.get("Uin")
        self._SubAccountUin = params.get("SubAccountUin")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CustomSample(AbstractModel):
    """Sample includes metric, aggregation from original metric query statement.

    """

    def __init__(self):
        r"""
        :param _Metric: Metric name.
        :type Metric: str
        :param _Aggregation: Aggregation condition.
        :type Aggregation: str
        :param _Labels: Label filter.

Note: This field may return null, indicating that no valid value is found.
        :type Labels: list of Label
        :param _Value: Value obtained from the query.
        :type Value: float
        :param _Timestamp: Time is the number of milliseconds since the epoch (1970-01-01 00:00 UTC) excluding leap seconds.
        :type Timestamp: int
        :param _Unit: Unit corresponding to the metric, including s(second), bytes, bytes/s, reqs, reqs/s, checks, checks/s, iters, iters/s, VUs, %.
        :type Unit: str
        :param _Name: Metric name in PTS.

Note: This field may return null, indicating that no valid value is found.
        :type Name: str
        """
        self._Metric = None
        self._Aggregation = None
        self._Labels = None
        self._Value = None
        self._Timestamp = None
        self._Unit = None
        self._Name = None

    @property
    def Metric(self):
        """Metric name.
        :rtype: str
        """
        return self._Metric

    @Metric.setter
    def Metric(self, Metric):
        self._Metric = Metric

    @property
    def Aggregation(self):
        """Aggregation condition.
        :rtype: str
        """
        return self._Aggregation

    @Aggregation.setter
    def Aggregation(self, Aggregation):
        self._Aggregation = Aggregation

    @property
    def Labels(self):
        """Label filter.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of Label
        """
        return self._Labels

    @Labels.setter
    def Labels(self, Labels):
        self._Labels = Labels

    @property
    def Value(self):
        """Value obtained from the query.
        :rtype: float
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value

    @property
    def Timestamp(self):
        """Time is the number of milliseconds since the epoch (1970-01-01 00:00 UTC) excluding leap seconds.
        :rtype: int
        """
        return self._Timestamp

    @Timestamp.setter
    def Timestamp(self, Timestamp):
        self._Timestamp = Timestamp

    @property
    def Unit(self):
        """Unit corresponding to the metric, including s(second), bytes, bytes/s, reqs, reqs/s, checks, checks/s, iters, iters/s, VUs, %.
        :rtype: str
        """
        return self._Unit

    @Unit.setter
    def Unit(self, Unit):
        self._Unit = Unit

    @property
    def Name(self):
        """Metric name in PTS.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Metric = params.get("Metric")
        self._Aggregation = params.get("Aggregation")
        if params.get("Labels") is not None:
            self._Labels = []
            for item in params.get("Labels"):
                obj = Label()
                obj._deserialize(item)
                self._Labels.append(obj)
        self._Value = params.get("Value")
        self._Timestamp = params.get("Timestamp")
        self._Unit = params.get("Unit")
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CustomSampleMatrix(AbstractModel):
    """Metric matrix, which contains multiple metric sequence arrays.

    """

    def __init__(self):
        r"""
        :param _Metric: Metric name.
        :type Metric: str
        :param _Aggregation: Aggregation function.
        :type Aggregation: str
        :param _Unit: Metric unit.

Note: This field may return null, indicating that no valid value is found.
        :type Unit: str
        :param _Streams: Metric sequence array.

Note: This field may return null, indicating that no valid value is found.
        :type Streams: list of SampleStream
        """
        self._Metric = None
        self._Aggregation = None
        self._Unit = None
        self._Streams = None

    @property
    def Metric(self):
        """Metric name.
        :rtype: str
        """
        return self._Metric

    @Metric.setter
    def Metric(self, Metric):
        self._Metric = Metric

    @property
    def Aggregation(self):
        """Aggregation function.
        :rtype: str
        """
        return self._Aggregation

    @Aggregation.setter
    def Aggregation(self, Aggregation):
        self._Aggregation = Aggregation

    @property
    def Unit(self):
        """Metric unit.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Unit

    @Unit.setter
    def Unit(self, Unit):
        self._Unit = Unit

    @property
    def Streams(self):
        """Metric sequence array.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of SampleStream
        """
        return self._Streams

    @Streams.setter
    def Streams(self, Streams):
        self._Streams = Streams


    def _deserialize(self, params):
        self._Metric = params.get("Metric")
        self._Aggregation = params.get("Aggregation")
        self._Unit = params.get("Unit")
        if params.get("Streams") is not None:
            self._Streams = []
            for item in params.get("Streams"):
                obj = SampleStream()
                obj._deserialize(item)
                self._Streams.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DNSConfig(AbstractModel):
    """DNS configuration of the pressure machine.

    """

    def __init__(self):
        r"""
        :param _Nameservers: DNS IP list.

Note: This field may return null, indicating that no valid value is found.
        :type Nameservers: list of str
        """
        self._Nameservers = None

    @property
    def Nameservers(self):
        """DNS IP list.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of str
        """
        return self._Nameservers

    @Nameservers.setter
    def Nameservers(self, Nameservers):
        self._Nameservers = Nameservers


    def _deserialize(self, params):
        self._Nameservers = params.get("Nameservers")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAlertChannelRequest(AbstractModel):
    """DeleteAlertChannel request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID.
        :type ProjectId: str
        :param _NoticeId: Notice ID of the notification channel to be deleted.
        :type NoticeId: str
        """
        self._ProjectId = None
        self._NoticeId = None

    @property
    def ProjectId(self):
        """Project ID.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def NoticeId(self):
        """Notice ID of the notification channel to be deleted.
        :rtype: str
        """
        return self._NoticeId

    @NoticeId.setter
    def NoticeId(self, NoticeId):
        self._NoticeId = NoticeId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._NoticeId = params.get("NoticeId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAlertChannelResponse(AbstractModel):
    """DeleteAlertChannel response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteCronJobsRequest(AbstractModel):
    """DeleteCronJobs request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID.
        :type ProjectId: str
        :param _CronJobIds: Array of CronJob ID.
        :type CronJobIds: list of str
        """
        self._ProjectId = None
        self._CronJobIds = None

    @property
    def ProjectId(self):
        """Project ID.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def CronJobIds(self):
        """Array of CronJob ID.
        :rtype: list of str
        """
        return self._CronJobIds

    @CronJobIds.setter
    def CronJobIds(self, CronJobIds):
        self._CronJobIds = CronJobIds


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._CronJobIds = params.get("CronJobIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCronJobsResponse(AbstractModel):
    """DeleteCronJobs response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteEnvironmentsRequest(AbstractModel):
    """DeleteEnvironments request structure.

    """


class DeleteEnvironmentsResponse(AbstractModel):
    """DeleteEnvironments response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteFilesRequest(AbstractModel):
    """DeleteFiles request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID.
        :type ProjectId: str
        :param _FileIds: Array of File ID to be deleted.
        :type FileIds: list of str
        """
        self._ProjectId = None
        self._FileIds = None

    @property
    def ProjectId(self):
        """Project ID.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def FileIds(self):
        """Array of File ID to be deleted.
        :rtype: list of str
        """
        return self._FileIds

    @FileIds.setter
    def FileIds(self, FileIds):
        self._FileIds = FileIds


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._FileIds = params.get("FileIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteFilesResponse(AbstractModel):
    """DeleteFiles response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteJobsRequest(AbstractModel):
    """DeleteJobs request structure.

    """

    def __init__(self):
        r"""
        :param _JobIds: Array of Job ID to be deleted.
        :type JobIds: list of str
        :param _ProjectId: Project ID.
        :type ProjectId: str
        :param _ScenarioIds: Array of Scenario ID.
        :type ScenarioIds: list of str
        """
        self._JobIds = None
        self._ProjectId = None
        self._ScenarioIds = None

    @property
    def JobIds(self):
        """Array of Job ID to be deleted.
        :rtype: list of str
        """
        return self._JobIds

    @JobIds.setter
    def JobIds(self, JobIds):
        self._JobIds = JobIds

    @property
    def ProjectId(self):
        """Project ID.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ScenarioIds(self):
        """Array of Scenario ID.
        :rtype: list of str
        """
        return self._ScenarioIds

    @ScenarioIds.setter
    def ScenarioIds(self, ScenarioIds):
        self._ScenarioIds = ScenarioIds


    def _deserialize(self, params):
        self._JobIds = params.get("JobIds")
        self._ProjectId = params.get("ProjectId")
        self._ScenarioIds = params.get("ScenarioIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteJobsResponse(AbstractModel):
    """DeleteJobs response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteProjectsRequest(AbstractModel):
    """DeleteProjects request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectIds: Array of Project ID to be deleted.
        :type ProjectIds: list of str
        :param _DeleteScenarios: Whether to delete project-related scenarios. The default value is false.
        :type DeleteScenarios: bool
        :param _DeleteJobs: Whether to delete project-related jobs. The default value is false.
        :type DeleteJobs: bool
        """
        self._ProjectIds = None
        self._DeleteScenarios = None
        self._DeleteJobs = None

    @property
    def ProjectIds(self):
        """Array of Project ID to be deleted.
        :rtype: list of str
        """
        return self._ProjectIds

    @ProjectIds.setter
    def ProjectIds(self, ProjectIds):
        self._ProjectIds = ProjectIds

    @property
    def DeleteScenarios(self):
        """Whether to delete project-related scenarios. The default value is false.
        :rtype: bool
        """
        return self._DeleteScenarios

    @DeleteScenarios.setter
    def DeleteScenarios(self, DeleteScenarios):
        self._DeleteScenarios = DeleteScenarios

    @property
    def DeleteJobs(self):
        """Whether to delete project-related jobs. The default value is false.
        :rtype: bool
        """
        return self._DeleteJobs

    @DeleteJobs.setter
    def DeleteJobs(self, DeleteJobs):
        self._DeleteJobs = DeleteJobs


    def _deserialize(self, params):
        self._ProjectIds = params.get("ProjectIds")
        self._DeleteScenarios = params.get("DeleteScenarios")
        self._DeleteJobs = params.get("DeleteJobs")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteProjectsResponse(AbstractModel):
    """DeleteProjects response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteScenariosRequest(AbstractModel):
    """DeleteScenarios request structure.

    """

    def __init__(self):
        r"""
        :param _ScenarioIds: Array of Scenario ID to be deleted.
        :type ScenarioIds: list of str
        :param _ProjectId: Project ID.
        :type ProjectId: str
        :param _DeleteJobs: Whether to delete scene-related jobs. The default value is false.
        :type DeleteJobs: bool
        """
        self._ScenarioIds = None
        self._ProjectId = None
        self._DeleteJobs = None

    @property
    def ScenarioIds(self):
        """Array of Scenario ID to be deleted.
        :rtype: list of str
        """
        return self._ScenarioIds

    @ScenarioIds.setter
    def ScenarioIds(self, ScenarioIds):
        self._ScenarioIds = ScenarioIds

    @property
    def ProjectId(self):
        """Project ID.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def DeleteJobs(self):
        """Whether to delete scene-related jobs. The default value is false.
        :rtype: bool
        """
        return self._DeleteJobs

    @DeleteJobs.setter
    def DeleteJobs(self, DeleteJobs):
        self._DeleteJobs = DeleteJobs


    def _deserialize(self, params):
        self._ScenarioIds = params.get("ScenarioIds")
        self._ProjectId = params.get("ProjectId")
        self._DeleteJobs = params.get("DeleteJobs")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteScenariosResponse(AbstractModel):
    """DeleteScenarios response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DescribeAlertChannelsRequest(AbstractModel):
    """DescribeAlertChannels request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectIds: Array of Project ID.
        :type ProjectIds: list of str
        :param _Offset: Offset. Default value is 0.
        :type Offset: int
        :param _Limit: Number of returns, default is 20, maximum is 100.
        :type Limit: int
        :param _NoticeIds: Array of Notice ID.
        :type NoticeIds: list of str
        :param _OrderBy: Column for sorting.
        :type OrderBy: str
        :param _Ascend: Whether in ascending order.
        :type Ascend: bool
        """
        self._ProjectIds = None
        self._Offset = None
        self._Limit = None
        self._NoticeIds = None
        self._OrderBy = None
        self._Ascend = None

    @property
    def ProjectIds(self):
        """Array of Project ID.
        :rtype: list of str
        """
        return self._ProjectIds

    @ProjectIds.setter
    def ProjectIds(self, ProjectIds):
        self._ProjectIds = ProjectIds

    @property
    def Offset(self):
        """Offset. Default value is 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """Number of returns, default is 20, maximum is 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def NoticeIds(self):
        """Array of Notice ID.
        :rtype: list of str
        """
        return self._NoticeIds

    @NoticeIds.setter
    def NoticeIds(self, NoticeIds):
        self._NoticeIds = NoticeIds

    @property
    def OrderBy(self):
        """Column for sorting.
        :rtype: str
        """
        return self._OrderBy

    @OrderBy.setter
    def OrderBy(self, OrderBy):
        self._OrderBy = OrderBy

    @property
    def Ascend(self):
        """Whether in ascending order.
        :rtype: bool
        """
        return self._Ascend

    @Ascend.setter
    def Ascend(self, Ascend):
        self._Ascend = Ascend


    def _deserialize(self, params):
        self._ProjectIds = params.get("ProjectIds")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._NoticeIds = params.get("NoticeIds")
        self._OrderBy = params.get("OrderBy")
        self._Ascend = params.get("Ascend")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAlertChannelsResponse(AbstractModel):
    """DescribeAlertChannels response structure.

    """

    def __init__(self):
        r"""
        :param _AlertChannelSet: Alarm recipient groups list.

Note: This field may return null, indicating that no valid value is found.
        :type AlertChannelSet: list of AlertChannelRecord
        :param _Total: Number of alarm recipient groups.

Note: This field may return null, indicating that no valid value is found.
        :type Total: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._AlertChannelSet = None
        self._Total = None
        self._RequestId = None

    @property
    def AlertChannelSet(self):
        """Alarm recipient groups list.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of AlertChannelRecord
        """
        return self._AlertChannelSet

    @AlertChannelSet.setter
    def AlertChannelSet(self, AlertChannelSet):
        self._AlertChannelSet = AlertChannelSet

    @property
    def Total(self):
        """Number of alarm recipient groups.

Note: This field may return null, indicating that no valid value is found.
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("AlertChannelSet") is not None:
            self._AlertChannelSet = []
            for item in params.get("AlertChannelSet"):
                obj = AlertChannelRecord()
                obj._deserialize(item)
                self._AlertChannelSet.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeAlertRecordsRequest(AbstractModel):
    """DescribeAlertRecords request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectIds: Array of Project ID.
        :type ProjectIds: list of str
        :param _ScenarioIds: Array of Scenario ID.
        :type ScenarioIds: list of str
        :param _JobIds: Array of Job ID.
        :type JobIds: list of str
        :param _Ascend: Whether in ascending order.
        :type Ascend: bool
        :param _OrderBy: Column for sorting.
        :type OrderBy: str
        :param _Offset: Offset. Default value is 0.
        :type Offset: int
        :param _Limit: Number of returns. Default value is 20, maximum is 100
        :type Limit: int
        :param _ScenarioNames: Filter by Scenario names.
        :type ScenarioNames: list of str
        """
        self._ProjectIds = None
        self._ScenarioIds = None
        self._JobIds = None
        self._Ascend = None
        self._OrderBy = None
        self._Offset = None
        self._Limit = None
        self._ScenarioNames = None

    @property
    def ProjectIds(self):
        """Array of Project ID.
        :rtype: list of str
        """
        return self._ProjectIds

    @ProjectIds.setter
    def ProjectIds(self, ProjectIds):
        self._ProjectIds = ProjectIds

    @property
    def ScenarioIds(self):
        """Array of Scenario ID.
        :rtype: list of str
        """
        return self._ScenarioIds

    @ScenarioIds.setter
    def ScenarioIds(self, ScenarioIds):
        self._ScenarioIds = ScenarioIds

    @property
    def JobIds(self):
        """Array of Job ID.
        :rtype: list of str
        """
        return self._JobIds

    @JobIds.setter
    def JobIds(self, JobIds):
        self._JobIds = JobIds

    @property
    def Ascend(self):
        """Whether in ascending order.
        :rtype: bool
        """
        return self._Ascend

    @Ascend.setter
    def Ascend(self, Ascend):
        self._Ascend = Ascend

    @property
    def OrderBy(self):
        """Column for sorting.
        :rtype: str
        """
        return self._OrderBy

    @OrderBy.setter
    def OrderBy(self, OrderBy):
        self._OrderBy = OrderBy

    @property
    def Offset(self):
        """Offset. Default value is 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """Number of returns. Default value is 20, maximum is 100
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def ScenarioNames(self):
        """Filter by Scenario names.
        :rtype: list of str
        """
        return self._ScenarioNames

    @ScenarioNames.setter
    def ScenarioNames(self, ScenarioNames):
        self._ScenarioNames = ScenarioNames


    def _deserialize(self, params):
        self._ProjectIds = params.get("ProjectIds")
        self._ScenarioIds = params.get("ScenarioIds")
        self._JobIds = params.get("JobIds")
        self._Ascend = params.get("Ascend")
        self._OrderBy = params.get("OrderBy")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._ScenarioNames = params.get("ScenarioNames")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAlertRecordsResponse(AbstractModel):
    """DescribeAlertRecords response structure.

    """

    def __init__(self):
        r"""
        :param _AlertRecordSet: Alert records list.

Note: This field may return null, indicating that no valid value is found.
        :type AlertRecordSet: list of AlertRecord
        :param _Total: Total number of Alert records.

Note: This field may return null, indicating that no valid value is found.
        :type Total: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._AlertRecordSet = None
        self._Total = None
        self._RequestId = None

    @property
    def AlertRecordSet(self):
        """Alert records list.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of AlertRecord
        """
        return self._AlertRecordSet

    @AlertRecordSet.setter
    def AlertRecordSet(self, AlertRecordSet):
        self._AlertRecordSet = AlertRecordSet

    @property
    def Total(self):
        """Total number of Alert records.

Note: This field may return null, indicating that no valid value is found.
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("AlertRecordSet") is not None:
            self._AlertRecordSet = []
            for item in params.get("AlertRecordSet"):
                obj = AlertRecord()
                obj._deserialize(item)
                self._AlertRecordSet.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeAvailableMetricsRequest(AbstractModel):
    """DescribeAvailableMetrics request structure.

    """


class DescribeAvailableMetricsResponse(AbstractModel):
    """DescribeAvailableMetrics response structure.

    """

    def __init__(self):
        r"""
        :param _MetricSet: All supported metrics of the product.
        :type MetricSet: list of MetricInfo
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._MetricSet = None
        self._RequestId = None

    @property
    def MetricSet(self):
        """All supported metrics of the product.
        :rtype: list of MetricInfo
        """
        return self._MetricSet

    @MetricSet.setter
    def MetricSet(self, MetricSet):
        self._MetricSet = MetricSet

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("MetricSet") is not None:
            self._MetricSet = []
            for item in params.get("MetricSet"):
                obj = MetricInfo()
                obj._deserialize(item)
                self._MetricSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCheckSummaryRequest(AbstractModel):
    """DescribeCheckSummary request structure.

    """

    def __init__(self):
        r"""
        :param _JobId: Job ID.
        :type JobId: str
        :param _ScenarioId: Scenario ID.
        :type ScenarioId: str
        :param _ProjectId: Project ID.
        :type ProjectId: str
        """
        self._JobId = None
        self._ScenarioId = None
        self._ProjectId = None

    @property
    def JobId(self):
        """Job ID.
        :rtype: str
        """
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def ScenarioId(self):
        """Scenario ID.
        :rtype: str
        """
        return self._ScenarioId

    @ScenarioId.setter
    def ScenarioId(self, ScenarioId):
        self._ScenarioId = ScenarioId

    @property
    def ProjectId(self):
        """Project ID.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._ScenarioId = params.get("ScenarioId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCheckSummaryResponse(AbstractModel):
    """DescribeCheckSummary response structure.

    """

    def __init__(self):
        r"""
        :param _CheckSummarySet: Checkpoint summary information.

Note: This field may return null, indicating that no valid value is found.
        :type CheckSummarySet: list of CheckSummary
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._CheckSummarySet = None
        self._RequestId = None

    @property
    def CheckSummarySet(self):
        """Checkpoint summary information.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of CheckSummary
        """
        return self._CheckSummarySet

    @CheckSummarySet.setter
    def CheckSummarySet(self, CheckSummarySet):
        self._CheckSummarySet = CheckSummarySet

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("CheckSummarySet") is not None:
            self._CheckSummarySet = []
            for item in params.get("CheckSummarySet"):
                obj = CheckSummary()
                obj._deserialize(item)
                self._CheckSummarySet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCronJobsRequest(AbstractModel):
    """DescribeCronJobs request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectIds: Array of Project ID.
        :type ProjectIds: list of str
        :param _Offset: Offset. Default value is 0.
        :type Offset: int
        :param _Limit: Number of returns.
        :type Limit: int
        :param _CronJobIds: Array of CronJob ID.
        :type CronJobIds: list of str
        :param _CronJobName: CronJob name, fuzzy query.
        :type CronJobName: str
        :param _CronJobStatus: Array of CronJob status.
        :type CronJobStatus: list of int
        :param _OrderBy: Column for sorting.
        :type OrderBy: str
        :param _Ascend: Whether in ascending order.
        :type Ascend: bool
        """
        self._ProjectIds = None
        self._Offset = None
        self._Limit = None
        self._CronJobIds = None
        self._CronJobName = None
        self._CronJobStatus = None
        self._OrderBy = None
        self._Ascend = None

    @property
    def ProjectIds(self):
        """Array of Project ID.
        :rtype: list of str
        """
        return self._ProjectIds

    @ProjectIds.setter
    def ProjectIds(self, ProjectIds):
        self._ProjectIds = ProjectIds

    @property
    def Offset(self):
        """Offset. Default value is 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """Number of returns.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def CronJobIds(self):
        """Array of CronJob ID.
        :rtype: list of str
        """
        return self._CronJobIds

    @CronJobIds.setter
    def CronJobIds(self, CronJobIds):
        self._CronJobIds = CronJobIds

    @property
    def CronJobName(self):
        """CronJob name, fuzzy query.
        :rtype: str
        """
        return self._CronJobName

    @CronJobName.setter
    def CronJobName(self, CronJobName):
        self._CronJobName = CronJobName

    @property
    def CronJobStatus(self):
        """Array of CronJob status.
        :rtype: list of int
        """
        return self._CronJobStatus

    @CronJobStatus.setter
    def CronJobStatus(self, CronJobStatus):
        self._CronJobStatus = CronJobStatus

    @property
    def OrderBy(self):
        """Column for sorting.
        :rtype: str
        """
        return self._OrderBy

    @OrderBy.setter
    def OrderBy(self, OrderBy):
        self._OrderBy = OrderBy

    @property
    def Ascend(self):
        """Whether in ascending order.
        :rtype: bool
        """
        return self._Ascend

    @Ascend.setter
    def Ascend(self, Ascend):
        self._Ascend = Ascend


    def _deserialize(self, params):
        self._ProjectIds = params.get("ProjectIds")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._CronJobIds = params.get("CronJobIds")
        self._CronJobName = params.get("CronJobName")
        self._CronJobStatus = params.get("CronJobStatus")
        self._OrderBy = params.get("OrderBy")
        self._Ascend = params.get("Ascend")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCronJobsResponse(AbstractModel):
    """DescribeCronJobs response structure.

    """

    def __init__(self):
        r"""
        :param _Total: Total number of cron jobs.
        :type Total: int
        :param _CronJobSet: Cron jobs.

Note: This field may return null, indicating that no valid value is found.
        :type CronJobSet: list of CronJob
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Total = None
        self._CronJobSet = None
        self._RequestId = None

    @property
    def Total(self):
        """Total number of cron jobs.
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def CronJobSet(self):
        """Cron jobs.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of CronJob
        """
        return self._CronJobSet

    @CronJobSet.setter
    def CronJobSet(self, CronJobSet):
        self._CronJobSet = CronJobSet

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("CronJobSet") is not None:
            self._CronJobSet = []
            for item in params.get("CronJobSet"):
                obj = CronJob()
                obj._deserialize(item)
                self._CronJobSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeEnvironmentsRequest(AbstractModel):
    """DescribeEnvironments request structure.

    """


class DescribeEnvironmentsResponse(AbstractModel):
    """DescribeEnvironments response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DescribeErrorSummaryRequest(AbstractModel):
    """DescribeErrorSummary request structure.

    """

    def __init__(self):
        r"""
        :param _JobId: Job ID.
        :type JobId: str
        :param _ScenarioId: Scenario ID.
        :type ScenarioId: str
        :param _ProjectId: Project ID.
        :type ProjectId: str
        :param _Filters: Filter parameters.
        :type Filters: list of Filter
        """
        self._JobId = None
        self._ScenarioId = None
        self._ProjectId = None
        self._Filters = None

    @property
    def JobId(self):
        """Job ID.
        :rtype: str
        """
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def ScenarioId(self):
        """Scenario ID.
        :rtype: str
        """
        return self._ScenarioId

    @ScenarioId.setter
    def ScenarioId(self, ScenarioId):
        self._ScenarioId = ScenarioId

    @property
    def ProjectId(self):
        """Project ID.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Filters(self):
        """Filter parameters.
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._ScenarioId = params.get("ScenarioId")
        self._ProjectId = params.get("ProjectId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeErrorSummaryResponse(AbstractModel):
    """DescribeErrorSummary response structure.

    """

    def __init__(self):
        r"""
        :param _ErrorSummarySet: Error summary information.

Note: This field may return null, indicating that no valid value is found.
        :type ErrorSummarySet: list of ErrorSummary
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ErrorSummarySet = None
        self._RequestId = None

    @property
    def ErrorSummarySet(self):
        """Error summary information.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of ErrorSummary
        """
        return self._ErrorSummarySet

    @ErrorSummarySet.setter
    def ErrorSummarySet(self, ErrorSummarySet):
        self._ErrorSummarySet = ErrorSummarySet

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ErrorSummarySet") is not None:
            self._ErrorSummarySet = []
            for item in params.get("ErrorSummarySet"):
                obj = ErrorSummary()
                obj._deserialize(item)
                self._ErrorSummarySet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeFilesRequest(AbstractModel):
    """DescribeFiles request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectIds: Array of Project ID.
        :type ProjectIds: list of str
        :param _FileIds: Array of File ID.
        :type FileIds: list of str
        :param _FileName: Filename
        :type FileName: str
        :param _Offset: Offset. Default value is 0.
        :type Offset: int
        :param _Limit: Number of returns. Default value is 20, maximum is 100
        :type Limit: int
        :param _Kind: File type. 1 represents parameter file, 2 represents protocol file, 3 represents request file.
        :type Kind: int
        """
        self._ProjectIds = None
        self._FileIds = None
        self._FileName = None
        self._Offset = None
        self._Limit = None
        self._Kind = None

    @property
    def ProjectIds(self):
        """Array of Project ID.
        :rtype: list of str
        """
        return self._ProjectIds

    @ProjectIds.setter
    def ProjectIds(self, ProjectIds):
        self._ProjectIds = ProjectIds

    @property
    def FileIds(self):
        """Array of File ID.
        :rtype: list of str
        """
        return self._FileIds

    @FileIds.setter
    def FileIds(self, FileIds):
        self._FileIds = FileIds

    @property
    def FileName(self):
        """Filename
        :rtype: str
        """
        return self._FileName

    @FileName.setter
    def FileName(self, FileName):
        self._FileName = FileName

    @property
    def Offset(self):
        """Offset. Default value is 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """Number of returns. Default value is 20, maximum is 100
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Kind(self):
        """File type. 1 represents parameter file, 2 represents protocol file, 3 represents request file.
        :rtype: int
        """
        return self._Kind

    @Kind.setter
    def Kind(self, Kind):
        self._Kind = Kind


    def _deserialize(self, params):
        self._ProjectIds = params.get("ProjectIds")
        self._FileIds = params.get("FileIds")
        self._FileName = params.get("FileName")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Kind = params.get("Kind")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFilesResponse(AbstractModel):
    """DescribeFiles response structure.

    """

    def __init__(self):
        r"""
        :param _FileSet: File list.

Note: This field may return null, indicating that no valid value is found.
        :type FileSet: list of File
        :param _Total: Total number of files.

Note: This field may return null, indicating that no valid value is found.
        :type Total: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FileSet = None
        self._Total = None
        self._RequestId = None

    @property
    def FileSet(self):
        """File list.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of File
        """
        return self._FileSet

    @FileSet.setter
    def FileSet(self, FileSet):
        self._FileSet = FileSet

    @property
    def Total(self):
        """Total number of files.

Note: This field may return null, indicating that no valid value is found.
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("FileSet") is not None:
            self._FileSet = []
            for item in params.get("FileSet"):
                obj = File()
                obj._deserialize(item)
                self._FileSet.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeJobsRequest(AbstractModel):
    """DescribeJobs request structure.

    """

    def __init__(self):
        r"""
        :param _ScenarioIds: Array of Scenario ID.
        :type ScenarioIds: list of str
        :param _ProjectIds: Array of Project ID.
        :type ProjectIds: list of str
        :param _Offset: Offset. Default value is 0.
        :type Offset: int
        :param _Limit: Number of returns. Default value is 20, maximum is 100
        :type Limit: int
        :param _JobIds: Array of Job ID.
        :type JobIds: list of str
        :param _OrderBy: Column for sorting.
        :type OrderBy: str
        :param _Ascend: Whether in ascending order.
        :type Ascend: bool
        :param _StartTime: Start time of the job.
        :type StartTime: str
        :param _EndTime: End time of the job.
        :type EndTime: str
        :param _Debug: Whether debug jobs.
        :type Debug: bool
        :param _Status: Job status.
        :type Status: list of int
        """
        self._ScenarioIds = None
        self._ProjectIds = None
        self._Offset = None
        self._Limit = None
        self._JobIds = None
        self._OrderBy = None
        self._Ascend = None
        self._StartTime = None
        self._EndTime = None
        self._Debug = None
        self._Status = None

    @property
    def ScenarioIds(self):
        """Array of Scenario ID.
        :rtype: list of str
        """
        return self._ScenarioIds

    @ScenarioIds.setter
    def ScenarioIds(self, ScenarioIds):
        self._ScenarioIds = ScenarioIds

    @property
    def ProjectIds(self):
        """Array of Project ID.
        :rtype: list of str
        """
        return self._ProjectIds

    @ProjectIds.setter
    def ProjectIds(self, ProjectIds):
        self._ProjectIds = ProjectIds

    @property
    def Offset(self):
        """Offset. Default value is 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """Number of returns. Default value is 20, maximum is 100
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def JobIds(self):
        """Array of Job ID.
        :rtype: list of str
        """
        return self._JobIds

    @JobIds.setter
    def JobIds(self, JobIds):
        self._JobIds = JobIds

    @property
    def OrderBy(self):
        """Column for sorting.
        :rtype: str
        """
        return self._OrderBy

    @OrderBy.setter
    def OrderBy(self, OrderBy):
        self._OrderBy = OrderBy

    @property
    def Ascend(self):
        """Whether in ascending order.
        :rtype: bool
        """
        return self._Ascend

    @Ascend.setter
    def Ascend(self, Ascend):
        self._Ascend = Ascend

    @property
    def StartTime(self):
        """Start time of the job.
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """End time of the job.
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Debug(self):
        """Whether debug jobs.
        :rtype: bool
        """
        return self._Debug

    @Debug.setter
    def Debug(self, Debug):
        self._Debug = Debug

    @property
    def Status(self):
        """Job status.
        :rtype: list of int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._ScenarioIds = params.get("ScenarioIds")
        self._ProjectIds = params.get("ProjectIds")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._JobIds = params.get("JobIds")
        self._OrderBy = params.get("OrderBy")
        self._Ascend = params.get("Ascend")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Debug = params.get("Debug")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeJobsResponse(AbstractModel):
    """DescribeJobs response structure.

    """

    def __init__(self):
        r"""
        :param _JobSet: Job list.

Note: This field may return null, indicating that no valid value is found.
        :type JobSet: list of Job
        :param _Total: Total number of Jobs.

Note: This field may return null, indicating that no valid value is found.
        :type Total: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._JobSet = None
        self._Total = None
        self._RequestId = None

    @property
    def JobSet(self):
        """Job list.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of Job
        """
        return self._JobSet

    @JobSet.setter
    def JobSet(self, JobSet):
        self._JobSet = JobSet

    @property
    def Total(self):
        """Total number of Jobs.

Note: This field may return null, indicating that no valid value is found.
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("JobSet") is not None:
            self._JobSet = []
            for item in params.get("JobSet"):
                obj = Job()
                obj._deserialize(item)
                self._JobSet.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeLabelValuesRequest(AbstractModel):
    """DescribeLabelValues request structure.

    """

    def __init__(self):
        r"""
        :param _JobId: Job ID.
        :type JobId: str
        :param _ScenarioId: Scenario ID.
        :type ScenarioId: str
        :param _Metric: Metric name. For the value range, refer to all metric names returned by the DescribeMetricLabelWithValues API.
        :type Metric: str
        :param _LabelName: Label name. For the value range, refer to the metrics and label names returned by the DescribeMetricLabelWithValues API.
        :type LabelName: str
        :param _ProjectId: Project ID.
        :type ProjectId: str
        """
        self._JobId = None
        self._ScenarioId = None
        self._Metric = None
        self._LabelName = None
        self._ProjectId = None

    @property
    def JobId(self):
        """Job ID.
        :rtype: str
        """
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def ScenarioId(self):
        """Scenario ID.
        :rtype: str
        """
        return self._ScenarioId

    @ScenarioId.setter
    def ScenarioId(self, ScenarioId):
        self._ScenarioId = ScenarioId

    @property
    def Metric(self):
        """Metric name. For the value range, refer to all metric names returned by the DescribeMetricLabelWithValues API.
        :rtype: str
        """
        return self._Metric

    @Metric.setter
    def Metric(self, Metric):
        self._Metric = Metric

    @property
    def LabelName(self):
        """Label name. For the value range, refer to the metrics and label names returned by the DescribeMetricLabelWithValues API.
        :rtype: str
        """
        return self._LabelName

    @LabelName.setter
    def LabelName(self, LabelName):
        self._LabelName = LabelName

    @property
    def ProjectId(self):
        """Project ID.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._ScenarioId = params.get("ScenarioId")
        self._Metric = params.get("Metric")
        self._LabelName = params.get("LabelName")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLabelValuesResponse(AbstractModel):
    """DescribeLabelValues response structure.

    """

    def __init__(self):
        r"""
        :param _LabelValueSet: Array of label values.

Note: This field may return null, indicating that no valid value is found.
        :type LabelValueSet: list of str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._LabelValueSet = None
        self._RequestId = None

    @property
    def LabelValueSet(self):
        """Array of label values.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of str
        """
        return self._LabelValueSet

    @LabelValueSet.setter
    def LabelValueSet(self, LabelValueSet):
        self._LabelValueSet = LabelValueSet

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._LabelValueSet = params.get("LabelValueSet")
        self._RequestId = params.get("RequestId")


class DescribeMetricLabelWithValuesRequest(AbstractModel):
    """DescribeMetricLabelWithValues request structure.

    """

    def __init__(self):
        r"""
        :param _JobId: Job ID.
        :type JobId: str
        :param _ProjectId: Project ID.
        :type ProjectId: str
        :param _ScenarioId: Scenario ID.
        :type ScenarioId: str
        """
        self._JobId = None
        self._ProjectId = None
        self._ScenarioId = None

    @property
    def JobId(self):
        """Job ID.
        :rtype: str
        """
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def ProjectId(self):
        """Project ID.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ScenarioId(self):
        """Scenario ID.
        :rtype: str
        """
        return self._ScenarioId

    @ScenarioId.setter
    def ScenarioId(self, ScenarioId):
        self._ScenarioId = ScenarioId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._ProjectId = params.get("ProjectId")
        self._ScenarioId = params.get("ScenarioId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMetricLabelWithValuesResponse(AbstractModel):
    """DescribeMetricLabelWithValues response structure.

    """

    def __init__(self):
        r"""
        :param _MetricLabelWithValuesSet: All labels and values of metrics.

Note: This field may return null, indicating that no valid value is found.
        :type MetricLabelWithValuesSet: list of MetricLabelWithValues
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._MetricLabelWithValuesSet = None
        self._RequestId = None

    @property
    def MetricLabelWithValuesSet(self):
        """All labels and values of metrics.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of MetricLabelWithValues
        """
        return self._MetricLabelWithValuesSet

    @MetricLabelWithValuesSet.setter
    def MetricLabelWithValuesSet(self, MetricLabelWithValuesSet):
        self._MetricLabelWithValuesSet = MetricLabelWithValuesSet

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("MetricLabelWithValuesSet") is not None:
            self._MetricLabelWithValuesSet = []
            for item in params.get("MetricLabelWithValuesSet"):
                obj = MetricLabelWithValues()
                obj._deserialize(item)
                self._MetricLabelWithValuesSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeNormalLogsRequest(AbstractModel):
    """DescribeNormalLogs request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID.
        :type ProjectId: str
        :param _ScenarioId: Scenario ID.
        :type ScenarioId: str
        :param _JobId: Job ID.
        :type JobId: str
        :param _Context: Context is used when loading more logs. Pass through the Context value returned last time to retrieve subsequent log content. The expiration time is 1 hour.
        :type Context: str
        :param _From: Log start time.
        :type From: str
        :param _To: Log end time.
        :type To: str
        :param _SeverityText: Log level, valid values are debug, info, error.
        :type SeverityText: str
        :param _Instance: IP of pressure engine instance.
        :type Instance: str
        :param _InstanceRegion: Region of pressure engine instance, such as ap-shanghai, ap-guangzhou.
        :type InstanceRegion: str
        :param _LogType: Type of log, in which 'console' represents user output, 'engine' represents engine output.
        :type LogType: str
        :param _Limit: Number of returned logs, maximum 100.
        :type Limit: int
        """
        self._ProjectId = None
        self._ScenarioId = None
        self._JobId = None
        self._Context = None
        self._From = None
        self._To = None
        self._SeverityText = None
        self._Instance = None
        self._InstanceRegion = None
        self._LogType = None
        self._Limit = None

    @property
    def ProjectId(self):
        """Project ID.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ScenarioId(self):
        """Scenario ID.
        :rtype: str
        """
        return self._ScenarioId

    @ScenarioId.setter
    def ScenarioId(self, ScenarioId):
        self._ScenarioId = ScenarioId

    @property
    def JobId(self):
        """Job ID.
        :rtype: str
        """
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def Context(self):
        """Context is used when loading more logs. Pass through the Context value returned last time to retrieve subsequent log content. The expiration time is 1 hour.
        :rtype: str
        """
        return self._Context

    @Context.setter
    def Context(self, Context):
        self._Context = Context

    @property
    def From(self):
        """Log start time.
        :rtype: str
        """
        return self._From

    @From.setter
    def From(self, From):
        self._From = From

    @property
    def To(self):
        """Log end time.
        :rtype: str
        """
        return self._To

    @To.setter
    def To(self, To):
        self._To = To

    @property
    def SeverityText(self):
        """Log level, valid values are debug, info, error.
        :rtype: str
        """
        return self._SeverityText

    @SeverityText.setter
    def SeverityText(self, SeverityText):
        self._SeverityText = SeverityText

    @property
    def Instance(self):
        """IP of pressure engine instance.
        :rtype: str
        """
        return self._Instance

    @Instance.setter
    def Instance(self, Instance):
        self._Instance = Instance

    @property
    def InstanceRegion(self):
        """Region of pressure engine instance, such as ap-shanghai, ap-guangzhou.
        :rtype: str
        """
        return self._InstanceRegion

    @InstanceRegion.setter
    def InstanceRegion(self, InstanceRegion):
        self._InstanceRegion = InstanceRegion

    @property
    def LogType(self):
        """Type of log, in which 'console' represents user output, 'engine' represents engine output.
        :rtype: str
        """
        return self._LogType

    @LogType.setter
    def LogType(self, LogType):
        self._LogType = LogType

    @property
    def Limit(self):
        """Number of returned logs, maximum 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._ScenarioId = params.get("ScenarioId")
        self._JobId = params.get("JobId")
        self._Context = params.get("Context")
        self._From = params.get("From")
        self._To = params.get("To")
        self._SeverityText = params.get("SeverityText")
        self._Instance = params.get("Instance")
        self._InstanceRegion = params.get("InstanceRegion")
        self._LogType = params.get("LogType")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNormalLogsResponse(AbstractModel):
    """DescribeNormalLogs response structure.

    """

    def __init__(self):
        r"""
        :param _Context: Log context, used when loading more logs. Pass through the Context value returned last time to retrieve subsequent log content. The expiration time is 1 hour.

Note: This field may return null, indicating that no valid value is found.
        :type Context: str
        :param _NormalLogs: Array of logs.

Note: This field may return null, indicating that no valid value is found.
        :type NormalLogs: list of NormalLog
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Context = None
        self._NormalLogs = None
        self._RequestId = None

    @property
    def Context(self):
        """Log context, used when loading more logs. Pass through the Context value returned last time to retrieve subsequent log content. The expiration time is 1 hour.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Context

    @Context.setter
    def Context(self, Context):
        self._Context = Context

    @property
    def NormalLogs(self):
        """Array of logs.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of NormalLog
        """
        return self._NormalLogs

    @NormalLogs.setter
    def NormalLogs(self, NormalLogs):
        self._NormalLogs = NormalLogs

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Context = params.get("Context")
        if params.get("NormalLogs") is not None:
            self._NormalLogs = []
            for item in params.get("NormalLogs"):
                obj = NormalLog()
                obj._deserialize(item)
                self._NormalLogs.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeProjectsRequest(AbstractModel):
    """DescribeProjects request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Offset. Default value is 0.
        :type Offset: int
        :param _Limit: Number of returns. Default value is 20, maximum is 100
        :type Limit: int
        :param _ProjectIds: Array of Project ID.
        :type ProjectIds: list of str
        :param _ProjectName: Project name.
        :type ProjectName: str
        :param _OrderBy: Column for sorting.
        :type OrderBy: str
        :param _Ascend: Whether in ascending order.
        :type Ascend: bool
        :param _TagFilters: Array of Tags.
        :type TagFilters: list of TagSpec
        """
        self._Offset = None
        self._Limit = None
        self._ProjectIds = None
        self._ProjectName = None
        self._OrderBy = None
        self._Ascend = None
        self._TagFilters = None

    @property
    def Offset(self):
        """Offset. Default value is 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """Number of returns. Default value is 20, maximum is 100
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def ProjectIds(self):
        """Array of Project ID.
        :rtype: list of str
        """
        return self._ProjectIds

    @ProjectIds.setter
    def ProjectIds(self, ProjectIds):
        self._ProjectIds = ProjectIds

    @property
    def ProjectName(self):
        """Project name.
        :rtype: str
        """
        return self._ProjectName

    @ProjectName.setter
    def ProjectName(self, ProjectName):
        self._ProjectName = ProjectName

    @property
    def OrderBy(self):
        """Column for sorting.
        :rtype: str
        """
        return self._OrderBy

    @OrderBy.setter
    def OrderBy(self, OrderBy):
        self._OrderBy = OrderBy

    @property
    def Ascend(self):
        """Whether in ascending order.
        :rtype: bool
        """
        return self._Ascend

    @Ascend.setter
    def Ascend(self, Ascend):
        self._Ascend = Ascend

    @property
    def TagFilters(self):
        """Array of Tags.
        :rtype: list of TagSpec
        """
        return self._TagFilters

    @TagFilters.setter
    def TagFilters(self, TagFilters):
        self._TagFilters = TagFilters


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._ProjectIds = params.get("ProjectIds")
        self._ProjectName = params.get("ProjectName")
        self._OrderBy = params.get("OrderBy")
        self._Ascend = params.get("Ascend")
        if params.get("TagFilters") is not None:
            self._TagFilters = []
            for item in params.get("TagFilters"):
                obj = TagSpec()
                obj._deserialize(item)
                self._TagFilters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeProjectsResponse(AbstractModel):
    """DescribeProjects response structure.

    """

    def __init__(self):
        r"""
        :param _ProjectSet: Project list.

Note: This field may return null, indicating that no valid value is found.
        :type ProjectSet: list of Project
        :param _Total: Total number of projects.
        :type Total: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ProjectSet = None
        self._Total = None
        self._RequestId = None

    @property
    def ProjectSet(self):
        """Project list.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of Project
        """
        return self._ProjectSet

    @ProjectSet.setter
    def ProjectSet(self, ProjectSet):
        self._ProjectSet = ProjectSet

    @property
    def Total(self):
        """Total number of projects.
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ProjectSet") is not None:
            self._ProjectSet = []
            for item in params.get("ProjectSet"):
                obj = Project()
                obj._deserialize(item)
                self._ProjectSet.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeRegionsRequest(AbstractModel):
    """DescribeRegions request structure.

    """


class DescribeRegionsResponse(AbstractModel):
    """DescribeRegions response structure.

    """

    def __init__(self):
        r"""
        :param _RegionSet: Array of regions.

Note: This field may return null, indicating that no valid value is found.
        :type RegionSet: list of RegionDetail
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RegionSet = None
        self._RequestId = None

    @property
    def RegionSet(self):
        """Array of regions.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of RegionDetail
        """
        return self._RegionSet

    @RegionSet.setter
    def RegionSet(self, RegionSet):
        self._RegionSet = RegionSet

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RegionSet") is not None:
            self._RegionSet = []
            for item in params.get("RegionSet"):
                obj = RegionDetail()
                obj._deserialize(item)
                self._RegionSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRequestSummaryRequest(AbstractModel):
    """DescribeRequestSummary request structure.

    """

    def __init__(self):
        r"""
        :param _JobId: Job ID.
        :type JobId: str
        :param _ScenarioId: Scenario ID.
        :type ScenarioId: str
        :param _ProjectId: Project ID.
        :type ProjectId: str
        """
        self._JobId = None
        self._ScenarioId = None
        self._ProjectId = None

    @property
    def JobId(self):
        """Job ID.
        :rtype: str
        """
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def ScenarioId(self):
        """Scenario ID.
        :rtype: str
        """
        return self._ScenarioId

    @ScenarioId.setter
    def ScenarioId(self, ScenarioId):
        self._ScenarioId = ScenarioId

    @property
    def ProjectId(self):
        """Project ID.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._ScenarioId = params.get("ScenarioId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRequestSummaryResponse(AbstractModel):
    """DescribeRequestSummary response structure.

    """

    def __init__(self):
        r"""
        :param _RequestSummarySet: Request summary information.

Note: This field may return null, indicating that no valid value is found.
        :type RequestSummarySet: list of RequestSummary
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestSummarySet = None
        self._RequestId = None

    @property
    def RequestSummarySet(self):
        """Request summary information.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of RequestSummary
        """
        return self._RequestSummarySet

    @RequestSummarySet.setter
    def RequestSummarySet(self, RequestSummarySet):
        self._RequestSummarySet = RequestSummarySet

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RequestSummarySet") is not None:
            self._RequestSummarySet = []
            for item in params.get("RequestSummarySet"):
                obj = RequestSummary()
                obj._deserialize(item)
                self._RequestSummarySet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSampleBatchQueryRequest(AbstractModel):
    """DescribeSampleBatchQuery request structure.

    """

    def __init__(self):
        r"""
        :param _JobId: Job ID.
        :type JobId: str
        :param _ScenarioId: Scenario ID.
        :type ScenarioId: str
        :param _Queries: Array of queries.
        :type Queries: list of InternalMetricQuery
        :param _ProjectId: Project ID.
        :type ProjectId: str
        """
        self._JobId = None
        self._ScenarioId = None
        self._Queries = None
        self._ProjectId = None

    @property
    def JobId(self):
        """Job ID.
        :rtype: str
        """
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def ScenarioId(self):
        """Scenario ID.
        :rtype: str
        """
        return self._ScenarioId

    @ScenarioId.setter
    def ScenarioId(self, ScenarioId):
        self._ScenarioId = ScenarioId

    @property
    def Queries(self):
        """Array of queries.
        :rtype: list of InternalMetricQuery
        """
        return self._Queries

    @Queries.setter
    def Queries(self, Queries):
        self._Queries = Queries

    @property
    def ProjectId(self):
        """Project ID.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._ScenarioId = params.get("ScenarioId")
        if params.get("Queries") is not None:
            self._Queries = []
            for item in params.get("Queries"):
                obj = InternalMetricQuery()
                obj._deserialize(item)
                self._Queries.append(obj)
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSampleBatchQueryResponse(AbstractModel):
    """DescribeSampleBatchQuery response structure.

    """

    def __init__(self):
        r"""
        :param _MetricSampleSet: Returned metric content.

Note: This field may return null, indicating that no valid value is found.
        :type MetricSampleSet: list of CustomSample
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._MetricSampleSet = None
        self._RequestId = None

    @property
    def MetricSampleSet(self):
        """Returned metric content.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of CustomSample
        """
        return self._MetricSampleSet

    @MetricSampleSet.setter
    def MetricSampleSet(self, MetricSampleSet):
        self._MetricSampleSet = MetricSampleSet

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("MetricSampleSet") is not None:
            self._MetricSampleSet = []
            for item in params.get("MetricSampleSet"):
                obj = CustomSample()
                obj._deserialize(item)
                self._MetricSampleSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSampleLogsRequest(AbstractModel):
    """DescribeSampleLogs request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID.
        :type ProjectId: str
        :param _ScenarioId: Scenario ID.
        :type ScenarioId: str
        :param _JobId: Job ID.
        :type JobId: str
        :param _Context: Context is used when loading more logs. Pass through the Context value returned last time to retrieve subsequent log content. The expiration time is 1 hour.
        :type Context: str
        :param _From: Log start time.
        :type From: str
        :param _To: Log end time.
        :type To: str
        :param _SeverityText: Log levels, such as debug, info, error.
        :type SeverityText: str
        :param _InstanceRegion: Region of pressure engine instance, such as ap-shanghai, ap-guangzhou.
        :type InstanceRegion: str
        :param _Instance: IP of pressure engine instance.
        :type Instance: str
        :param _LogType: Type of log, can be left empty. 'Request' represents sampling logs.
        :type LogType: str
        :param _Limit: Number of returned logs, maximum 100.
        :type Limit: int
        :param _ReactionTimeRange: Response time range of sampling logs.
        :type ReactionTimeRange: :class:`tencentcloud.pts.v20210728.models.ReactionTimeRange`
        :param _Status: Status code of sampling logs.
        :type Status: str
        :param _Result: Result code of sampling logs.
        :type Result: str
        :param _Method: Request method of sampling logs.
        :type Method: str
        :param _Service: Request service of sampling logs.
        :type Service: str
        """
        self._ProjectId = None
        self._ScenarioId = None
        self._JobId = None
        self._Context = None
        self._From = None
        self._To = None
        self._SeverityText = None
        self._InstanceRegion = None
        self._Instance = None
        self._LogType = None
        self._Limit = None
        self._ReactionTimeRange = None
        self._Status = None
        self._Result = None
        self._Method = None
        self._Service = None

    @property
    def ProjectId(self):
        """Project ID.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ScenarioId(self):
        """Scenario ID.
        :rtype: str
        """
        return self._ScenarioId

    @ScenarioId.setter
    def ScenarioId(self, ScenarioId):
        self._ScenarioId = ScenarioId

    @property
    def JobId(self):
        """Job ID.
        :rtype: str
        """
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def Context(self):
        """Context is used when loading more logs. Pass through the Context value returned last time to retrieve subsequent log content. The expiration time is 1 hour.
        :rtype: str
        """
        return self._Context

    @Context.setter
    def Context(self, Context):
        self._Context = Context

    @property
    def From(self):
        """Log start time.
        :rtype: str
        """
        return self._From

    @From.setter
    def From(self, From):
        self._From = From

    @property
    def To(self):
        """Log end time.
        :rtype: str
        """
        return self._To

    @To.setter
    def To(self, To):
        self._To = To

    @property
    def SeverityText(self):
        """Log levels, such as debug, info, error.
        :rtype: str
        """
        return self._SeverityText

    @SeverityText.setter
    def SeverityText(self, SeverityText):
        self._SeverityText = SeverityText

    @property
    def InstanceRegion(self):
        """Region of pressure engine instance, such as ap-shanghai, ap-guangzhou.
        :rtype: str
        """
        return self._InstanceRegion

    @InstanceRegion.setter
    def InstanceRegion(self, InstanceRegion):
        self._InstanceRegion = InstanceRegion

    @property
    def Instance(self):
        """IP of pressure engine instance.
        :rtype: str
        """
        return self._Instance

    @Instance.setter
    def Instance(self, Instance):
        self._Instance = Instance

    @property
    def LogType(self):
        """Type of log, can be left empty. 'Request' represents sampling logs.
        :rtype: str
        """
        return self._LogType

    @LogType.setter
    def LogType(self, LogType):
        self._LogType = LogType

    @property
    def Limit(self):
        """Number of returned logs, maximum 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def ReactionTimeRange(self):
        """Response time range of sampling logs.
        :rtype: :class:`tencentcloud.pts.v20210728.models.ReactionTimeRange`
        """
        return self._ReactionTimeRange

    @ReactionTimeRange.setter
    def ReactionTimeRange(self, ReactionTimeRange):
        self._ReactionTimeRange = ReactionTimeRange

    @property
    def Status(self):
        """Status code of sampling logs.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Result(self):
        """Result code of sampling logs.
        :rtype: str
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def Method(self):
        """Request method of sampling logs.
        :rtype: str
        """
        return self._Method

    @Method.setter
    def Method(self, Method):
        self._Method = Method

    @property
    def Service(self):
        """Request service of sampling logs.
        :rtype: str
        """
        return self._Service

    @Service.setter
    def Service(self, Service):
        self._Service = Service


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._ScenarioId = params.get("ScenarioId")
        self._JobId = params.get("JobId")
        self._Context = params.get("Context")
        self._From = params.get("From")
        self._To = params.get("To")
        self._SeverityText = params.get("SeverityText")
        self._InstanceRegion = params.get("InstanceRegion")
        self._Instance = params.get("Instance")
        self._LogType = params.get("LogType")
        self._Limit = params.get("Limit")
        if params.get("ReactionTimeRange") is not None:
            self._ReactionTimeRange = ReactionTimeRange()
            self._ReactionTimeRange._deserialize(params.get("ReactionTimeRange"))
        self._Status = params.get("Status")
        self._Result = params.get("Result")
        self._Method = params.get("Method")
        self._Service = params.get("Service")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSampleLogsResponse(AbstractModel):
    """DescribeSampleLogs response structure.

    """

    def __init__(self):
        r"""
        :param _Total: Total number of logs.
        :type Total: int
        :param _Context: Log context, used when loading more logs. Pass through the Context value returned last time to retrieve subsequent log content. The expiration time is 1 hour.
Note: This field may return null, indicating that no valid value is found.
        :type Context: str
        :param _SampleLogs: Array of request logs.

Note: This field may return null, indicating that no valid value is found.
        :type SampleLogs: list of SampleLog
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Total = None
        self._Context = None
        self._SampleLogs = None
        self._RequestId = None

    @property
    def Total(self):
        """Total number of logs.
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Context(self):
        """Log context, used when loading more logs. Pass through the Context value returned last time to retrieve subsequent log content. The expiration time is 1 hour.
Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Context

    @Context.setter
    def Context(self, Context):
        self._Context = Context

    @property
    def SampleLogs(self):
        """Array of request logs.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of SampleLog
        """
        return self._SampleLogs

    @SampleLogs.setter
    def SampleLogs(self, SampleLogs):
        self._SampleLogs = SampleLogs

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        self._Context = params.get("Context")
        if params.get("SampleLogs") is not None:
            self._SampleLogs = []
            for item in params.get("SampleLogs"):
                obj = SampleLog()
                obj._deserialize(item)
                self._SampleLogs.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSampleMatrixBatchQueryRequest(AbstractModel):
    """DescribeSampleMatrixBatchQuery request structure.

    """

    def __init__(self):
        r"""
        :param _JobId: Job ID.
        :type JobId: str
        :param _ProjectId: Project ID.
        :type ProjectId: str
        :param _ScenarioId: Scenario ID.
        :type ScenarioId: str
        :param _Queries: Query statement.
        :type Queries: list of InternalMetricQuery
        """
        self._JobId = None
        self._ProjectId = None
        self._ScenarioId = None
        self._Queries = None

    @property
    def JobId(self):
        """Job ID.
        :rtype: str
        """
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def ProjectId(self):
        """Project ID.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ScenarioId(self):
        """Scenario ID.
        :rtype: str
        """
        return self._ScenarioId

    @ScenarioId.setter
    def ScenarioId(self, ScenarioId):
        self._ScenarioId = ScenarioId

    @property
    def Queries(self):
        """Query statement.
        :rtype: list of InternalMetricQuery
        """
        return self._Queries

    @Queries.setter
    def Queries(self, Queries):
        self._Queries = Queries


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._ProjectId = params.get("ProjectId")
        self._ScenarioId = params.get("ScenarioId")
        if params.get("Queries") is not None:
            self._Queries = []
            for item in params.get("Queries"):
                obj = InternalMetricQuery()
                obj._deserialize(item)
                self._Queries.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSampleMatrixBatchQueryResponse(AbstractModel):
    """DescribeSampleMatrixBatchQuery response structure.

    """

    def __init__(self):
        r"""
        :param _MetricSampleMatrixSet: Batch metric matrices.

Note: This field may return null, indicating that no valid value is found.
        :type MetricSampleMatrixSet: list of CustomSampleMatrix
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._MetricSampleMatrixSet = None
        self._RequestId = None

    @property
    def MetricSampleMatrixSet(self):
        """Batch metric matrices.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of CustomSampleMatrix
        """
        return self._MetricSampleMatrixSet

    @MetricSampleMatrixSet.setter
    def MetricSampleMatrixSet(self, MetricSampleMatrixSet):
        self._MetricSampleMatrixSet = MetricSampleMatrixSet

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("MetricSampleMatrixSet") is not None:
            self._MetricSampleMatrixSet = []
            for item in params.get("MetricSampleMatrixSet"):
                obj = CustomSampleMatrix()
                obj._deserialize(item)
                self._MetricSampleMatrixSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSampleMatrixQueryRequest(AbstractModel):
    """DescribeSampleMatrixQuery request structure.

    """

    def __init__(self):
        r"""
        :param _JobId: Job ID.
        :type JobId: str
        :param _ProjectId: Project ID.
        :type ProjectId: str
        :param _ScenarioId: Scenario ID.
        :type ScenarioId: str
        :param _Metric: Metric name. For the value range, refer to all metric names returned by the DescribeMetricLabelWithValues API.
        :type Metric: str
        :param _Aggregation: Aggregation function. Range of values: Rate, Count, Avg, P90, P95, P99, Gauge.
        :type Aggregation: str
        :param _Filters: Use label rules to filter metrics. Rules include label name, label value, and operator (0 means equal, 1 means not equal).
        :type Filters: list of Filter
        :param _GroupBy: Labels used for grouping, similar to group by in PromQL.


        :type GroupBy: list of str
        """
        self._JobId = None
        self._ProjectId = None
        self._ScenarioId = None
        self._Metric = None
        self._Aggregation = None
        self._Filters = None
        self._GroupBy = None

    @property
    def JobId(self):
        """Job ID.
        :rtype: str
        """
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def ProjectId(self):
        """Project ID.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ScenarioId(self):
        """Scenario ID.
        :rtype: str
        """
        return self._ScenarioId

    @ScenarioId.setter
    def ScenarioId(self, ScenarioId):
        self._ScenarioId = ScenarioId

    @property
    def Metric(self):
        """Metric name. For the value range, refer to all metric names returned by the DescribeMetricLabelWithValues API.
        :rtype: str
        """
        return self._Metric

    @Metric.setter
    def Metric(self, Metric):
        self._Metric = Metric

    @property
    def Aggregation(self):
        """Aggregation function. Range of values: Rate, Count, Avg, P90, P95, P99, Gauge.
        :rtype: str
        """
        return self._Aggregation

    @Aggregation.setter
    def Aggregation(self, Aggregation):
        self._Aggregation = Aggregation

    @property
    def Filters(self):
        """Use label rules to filter metrics. Rules include label name, label value, and operator (0 means equal, 1 means not equal).
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def GroupBy(self):
        """Labels used for grouping, similar to group by in PromQL.


        :rtype: list of str
        """
        return self._GroupBy

    @GroupBy.setter
    def GroupBy(self, GroupBy):
        self._GroupBy = GroupBy


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._ProjectId = params.get("ProjectId")
        self._ScenarioId = params.get("ScenarioId")
        self._Metric = params.get("Metric")
        self._Aggregation = params.get("Aggregation")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._GroupBy = params.get("GroupBy")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSampleMatrixQueryResponse(AbstractModel):
    """DescribeSampleMatrixQuery response structure.

    """

    def __init__(self):
        r"""
        :param _MetricSampleMatrix: Metric matrix.

Note: This field may return null, indicating that no valid value is found.
        :type MetricSampleMatrix: :class:`tencentcloud.pts.v20210728.models.CustomSampleMatrix`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._MetricSampleMatrix = None
        self._RequestId = None

    @property
    def MetricSampleMatrix(self):
        """Metric matrix.

Note: This field may return null, indicating that no valid value is found.
        :rtype: :class:`tencentcloud.pts.v20210728.models.CustomSampleMatrix`
        """
        return self._MetricSampleMatrix

    @MetricSampleMatrix.setter
    def MetricSampleMatrix(self, MetricSampleMatrix):
        self._MetricSampleMatrix = MetricSampleMatrix

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("MetricSampleMatrix") is not None:
            self._MetricSampleMatrix = CustomSampleMatrix()
            self._MetricSampleMatrix._deserialize(params.get("MetricSampleMatrix"))
        self._RequestId = params.get("RequestId")


class DescribeSampleQueryRequest(AbstractModel):
    """DescribeSampleQuery request structure.

    """

    def __init__(self):
        r"""
        :param _JobId: Job ID.
        :type JobId: str
        :param _ScenarioId: Scenario ID.
        :type ScenarioId: str
        :param _Metric: Metric name. For the value range, refer to all metric names returned by the DescribeMetricLabelWithValues API.
        :type Metric: str
        :param _Aggregation: Aggregation function. Range of values: Rate, Count, Avg, P90, P95, P99, Gauge.
        :type Aggregation: str
        :param _ProjectId: Project ID.
        :type ProjectId: str
        :param _Labels: Label filtering condition. For supported labels, refer to all metrics and labels returned by the DescribeMetricLabelWithValues API.
        :type Labels: list of Label
        """
        self._JobId = None
        self._ScenarioId = None
        self._Metric = None
        self._Aggregation = None
        self._ProjectId = None
        self._Labels = None

    @property
    def JobId(self):
        """Job ID.
        :rtype: str
        """
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def ScenarioId(self):
        """Scenario ID.
        :rtype: str
        """
        return self._ScenarioId

    @ScenarioId.setter
    def ScenarioId(self, ScenarioId):
        self._ScenarioId = ScenarioId

    @property
    def Metric(self):
        """Metric name. For the value range, refer to all metric names returned by the DescribeMetricLabelWithValues API.
        :rtype: str
        """
        return self._Metric

    @Metric.setter
    def Metric(self, Metric):
        self._Metric = Metric

    @property
    def Aggregation(self):
        """Aggregation function. Range of values: Rate, Count, Avg, P90, P95, P99, Gauge.
        :rtype: str
        """
        return self._Aggregation

    @Aggregation.setter
    def Aggregation(self, Aggregation):
        self._Aggregation = Aggregation

    @property
    def ProjectId(self):
        """Project ID.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Labels(self):
        """Label filtering condition. For supported labels, refer to all metrics and labels returned by the DescribeMetricLabelWithValues API.
        :rtype: list of Label
        """
        return self._Labels

    @Labels.setter
    def Labels(self, Labels):
        self._Labels = Labels


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._ScenarioId = params.get("ScenarioId")
        self._Metric = params.get("Metric")
        self._Aggregation = params.get("Aggregation")
        self._ProjectId = params.get("ProjectId")
        if params.get("Labels") is not None:
            self._Labels = []
            for item in params.get("Labels"):
                obj = Label()
                obj._deserialize(item)
                self._Labels.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSampleQueryResponse(AbstractModel):
    """DescribeSampleQuery response structure.

    """

    def __init__(self):
        r"""
        :param _MetricSample: Returned metric.

Note: This field may return null, indicating that no valid value is found.
        :type MetricSample: :class:`tencentcloud.pts.v20210728.models.CustomSample`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._MetricSample = None
        self._RequestId = None

    @property
    def MetricSample(self):
        """Returned metric.

Note: This field may return null, indicating that no valid value is found.
        :rtype: :class:`tencentcloud.pts.v20210728.models.CustomSample`
        """
        return self._MetricSample

    @MetricSample.setter
    def MetricSample(self, MetricSample):
        self._MetricSample = MetricSample

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("MetricSample") is not None:
            self._MetricSample = CustomSample()
            self._MetricSample._deserialize(params.get("MetricSample"))
        self._RequestId = params.get("RequestId")


class DescribeScenarioWithJobsRequest(AbstractModel):
    """DescribeScenarioWithJobs request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Offset. Default value is 0.
        :type Offset: int
        :param _Limit: Number of returns. Default value is 20, maximum is 100.
        :type Limit: int
        :param _ProjectIds: Array of Project ID.
        :type ProjectIds: list of str
        :param _ScenarioIds: Array of Scenario ID.
        :type ScenarioIds: list of str
        :param _ScenarioName: Scenario Name.
        :type ScenarioName: str
        :param _ScenarioStatus: Array of Scenario status.
        :type ScenarioStatus: int
        :param _OrderBy: Column for sorting.
        :type OrderBy: str
        :param _Ascend: Whether in ascending order.
        :type Ascend: bool
        :param _ScenarioRelatedJobsParams: Parameters related to job.
        :type ScenarioRelatedJobsParams: :class:`tencentcloud.pts.v20210728.models.ScenarioRelatedJobsParams`
        :param _IgnoreScript: Whether to return the test script content of the scenario.
        :type IgnoreScript: bool
        :param _IgnoreDataset: Whether to return test data file information of the scenario.
        :type IgnoreDataset: bool
        :param _ScenarioType: Scenario type, such as pts-http, pts-js, pts-jmeter.
        :type ScenarioType: str
        :param _Owner: Creator.
        :type Owner: str
        """
        self._Offset = None
        self._Limit = None
        self._ProjectIds = None
        self._ScenarioIds = None
        self._ScenarioName = None
        self._ScenarioStatus = None
        self._OrderBy = None
        self._Ascend = None
        self._ScenarioRelatedJobsParams = None
        self._IgnoreScript = None
        self._IgnoreDataset = None
        self._ScenarioType = None
        self._Owner = None

    @property
    def Offset(self):
        """Offset. Default value is 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """Number of returns. Default value is 20, maximum is 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def ProjectIds(self):
        """Array of Project ID.
        :rtype: list of str
        """
        return self._ProjectIds

    @ProjectIds.setter
    def ProjectIds(self, ProjectIds):
        self._ProjectIds = ProjectIds

    @property
    def ScenarioIds(self):
        """Array of Scenario ID.
        :rtype: list of str
        """
        return self._ScenarioIds

    @ScenarioIds.setter
    def ScenarioIds(self, ScenarioIds):
        self._ScenarioIds = ScenarioIds

    @property
    def ScenarioName(self):
        """Scenario Name.
        :rtype: str
        """
        return self._ScenarioName

    @ScenarioName.setter
    def ScenarioName(self, ScenarioName):
        self._ScenarioName = ScenarioName

    @property
    def ScenarioStatus(self):
        """Array of Scenario status.
        :rtype: int
        """
        return self._ScenarioStatus

    @ScenarioStatus.setter
    def ScenarioStatus(self, ScenarioStatus):
        self._ScenarioStatus = ScenarioStatus

    @property
    def OrderBy(self):
        """Column for sorting.
        :rtype: str
        """
        return self._OrderBy

    @OrderBy.setter
    def OrderBy(self, OrderBy):
        self._OrderBy = OrderBy

    @property
    def Ascend(self):
        """Whether in ascending order.
        :rtype: bool
        """
        return self._Ascend

    @Ascend.setter
    def Ascend(self, Ascend):
        self._Ascend = Ascend

    @property
    def ScenarioRelatedJobsParams(self):
        """Parameters related to job.
        :rtype: :class:`tencentcloud.pts.v20210728.models.ScenarioRelatedJobsParams`
        """
        return self._ScenarioRelatedJobsParams

    @ScenarioRelatedJobsParams.setter
    def ScenarioRelatedJobsParams(self, ScenarioRelatedJobsParams):
        self._ScenarioRelatedJobsParams = ScenarioRelatedJobsParams

    @property
    def IgnoreScript(self):
        """Whether to return the test script content of the scenario.
        :rtype: bool
        """
        return self._IgnoreScript

    @IgnoreScript.setter
    def IgnoreScript(self, IgnoreScript):
        self._IgnoreScript = IgnoreScript

    @property
    def IgnoreDataset(self):
        """Whether to return test data file information of the scenario.
        :rtype: bool
        """
        return self._IgnoreDataset

    @IgnoreDataset.setter
    def IgnoreDataset(self, IgnoreDataset):
        self._IgnoreDataset = IgnoreDataset

    @property
    def ScenarioType(self):
        """Scenario type, such as pts-http, pts-js, pts-jmeter.
        :rtype: str
        """
        return self._ScenarioType

    @ScenarioType.setter
    def ScenarioType(self, ScenarioType):
        self._ScenarioType = ScenarioType

    @property
    def Owner(self):
        """Creator.
        :rtype: str
        """
        return self._Owner

    @Owner.setter
    def Owner(self, Owner):
        self._Owner = Owner


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._ProjectIds = params.get("ProjectIds")
        self._ScenarioIds = params.get("ScenarioIds")
        self._ScenarioName = params.get("ScenarioName")
        self._ScenarioStatus = params.get("ScenarioStatus")
        self._OrderBy = params.get("OrderBy")
        self._Ascend = params.get("Ascend")
        if params.get("ScenarioRelatedJobsParams") is not None:
            self._ScenarioRelatedJobsParams = ScenarioRelatedJobsParams()
            self._ScenarioRelatedJobsParams._deserialize(params.get("ScenarioRelatedJobsParams"))
        self._IgnoreScript = params.get("IgnoreScript")
        self._IgnoreDataset = params.get("IgnoreDataset")
        self._ScenarioType = params.get("ScenarioType")
        self._Owner = params.get("Owner")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeScenarioWithJobsResponse(AbstractModel):
    """DescribeScenarioWithJobs response structure.

    """

    def __init__(self):
        r"""
        :param _ScenarioWithJobsSet: Scenario configuration with related jobs.

Note: This field may return null, indicating that no valid value is found.
        :type ScenarioWithJobsSet: list of ScenarioWithJobs
        :param _Total: Total Scenarios.
        :type Total: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ScenarioWithJobsSet = None
        self._Total = None
        self._RequestId = None

    @property
    def ScenarioWithJobsSet(self):
        """Scenario configuration with related jobs.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of ScenarioWithJobs
        """
        return self._ScenarioWithJobsSet

    @ScenarioWithJobsSet.setter
    def ScenarioWithJobsSet(self, ScenarioWithJobsSet):
        self._ScenarioWithJobsSet = ScenarioWithJobsSet

    @property
    def Total(self):
        """Total Scenarios.
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ScenarioWithJobsSet") is not None:
            self._ScenarioWithJobsSet = []
            for item in params.get("ScenarioWithJobsSet"):
                obj = ScenarioWithJobs()
                obj._deserialize(item)
                self._ScenarioWithJobsSet.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeScenariosRequest(AbstractModel):
    """DescribeScenarios request structure.

    """

    def __init__(self):
        r"""
        :param _ScenarioIds: Array of Scenario ID.
        :type ScenarioIds: list of str
        :param _ScenarioName: Scenario Name.
        :type ScenarioName: str
        :param _ScenarioStatus: Array of Scenario status.
        :type ScenarioStatus: list of int
        :param _Offset: Offset. Default value is 0.
        :type Offset: int
        :param _Limit: Number of returns. Default value is 20, maximum is 100.
        :type Limit: int
        :param _OrderBy: Column for sorting.
        :type OrderBy: str
        :param _Ascend: Whether in ascending order.
        :type Ascend: bool
        :param _ProjectIds: Array of Project ID.
        :type ProjectIds: list of str
        :param _ScenarioType: Scenario type, such as pts-http, pts-js, pts-jmeter.
        :type ScenarioType: str
        """
        self._ScenarioIds = None
        self._ScenarioName = None
        self._ScenarioStatus = None
        self._Offset = None
        self._Limit = None
        self._OrderBy = None
        self._Ascend = None
        self._ProjectIds = None
        self._ScenarioType = None

    @property
    def ScenarioIds(self):
        """Array of Scenario ID.
        :rtype: list of str
        """
        return self._ScenarioIds

    @ScenarioIds.setter
    def ScenarioIds(self, ScenarioIds):
        self._ScenarioIds = ScenarioIds

    @property
    def ScenarioName(self):
        """Scenario Name.
        :rtype: str
        """
        return self._ScenarioName

    @ScenarioName.setter
    def ScenarioName(self, ScenarioName):
        self._ScenarioName = ScenarioName

    @property
    def ScenarioStatus(self):
        """Array of Scenario status.
        :rtype: list of int
        """
        return self._ScenarioStatus

    @ScenarioStatus.setter
    def ScenarioStatus(self, ScenarioStatus):
        self._ScenarioStatus = ScenarioStatus

    @property
    def Offset(self):
        """Offset. Default value is 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """Number of returns. Default value is 20, maximum is 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def OrderBy(self):
        """Column for sorting.
        :rtype: str
        """
        return self._OrderBy

    @OrderBy.setter
    def OrderBy(self, OrderBy):
        self._OrderBy = OrderBy

    @property
    def Ascend(self):
        """Whether in ascending order.
        :rtype: bool
        """
        return self._Ascend

    @Ascend.setter
    def Ascend(self, Ascend):
        self._Ascend = Ascend

    @property
    def ProjectIds(self):
        """Array of Project ID.
        :rtype: list of str
        """
        return self._ProjectIds

    @ProjectIds.setter
    def ProjectIds(self, ProjectIds):
        self._ProjectIds = ProjectIds

    @property
    def ScenarioType(self):
        """Scenario type, such as pts-http, pts-js, pts-jmeter.
        :rtype: str
        """
        return self._ScenarioType

    @ScenarioType.setter
    def ScenarioType(self, ScenarioType):
        self._ScenarioType = ScenarioType


    def _deserialize(self, params):
        self._ScenarioIds = params.get("ScenarioIds")
        self._ScenarioName = params.get("ScenarioName")
        self._ScenarioStatus = params.get("ScenarioStatus")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._OrderBy = params.get("OrderBy")
        self._Ascend = params.get("Ascend")
        self._ProjectIds = params.get("ProjectIds")
        self._ScenarioType = params.get("ScenarioType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeScenariosResponse(AbstractModel):
    """DescribeScenarios response structure.

    """

    def __init__(self):
        r"""
        :param _ScenarioSet: Scenario list.

Note: This field may return null, indicating that no valid value is found.
        :type ScenarioSet: list of Scenario
        :param _Total: Total number of scenarios.
        :type Total: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ScenarioSet = None
        self._Total = None
        self._RequestId = None

    @property
    def ScenarioSet(self):
        """Scenario list.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of Scenario
        """
        return self._ScenarioSet

    @ScenarioSet.setter
    def ScenarioSet(self, ScenarioSet):
        self._ScenarioSet = ScenarioSet

    @property
    def Total(self):
        """Total number of scenarios.
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ScenarioSet") is not None:
            self._ScenarioSet = []
            for item in params.get("ScenarioSet"):
                obj = Scenario()
                obj._deserialize(item)
                self._ScenarioSet.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DomainNameConfig(AbstractModel):
    """Domain resolution configuration of the pressure machine.

    """

    def __init__(self):
        r"""
        :param _HostAliases: Domain configuration.

Note: This field may return null, indicating that no valid value is found.
        :type HostAliases: list of HostAlias
        :param _DNSConfig: DNS configuration.

Note: This field may return null, indicating that no valid value is found.
        :type DNSConfig: :class:`tencentcloud.pts.v20210728.models.DNSConfig`
        """
        self._HostAliases = None
        self._DNSConfig = None

    @property
    def HostAliases(self):
        """Domain configuration.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of HostAlias
        """
        return self._HostAliases

    @HostAliases.setter
    def HostAliases(self, HostAliases):
        self._HostAliases = HostAliases

    @property
    def DNSConfig(self):
        """DNS configuration.

Note: This field may return null, indicating that no valid value is found.
        :rtype: :class:`tencentcloud.pts.v20210728.models.DNSConfig`
        """
        return self._DNSConfig

    @DNSConfig.setter
    def DNSConfig(self, DNSConfig):
        self._DNSConfig = DNSConfig


    def _deserialize(self, params):
        if params.get("HostAliases") is not None:
            self._HostAliases = []
            for item in params.get("HostAliases"):
                obj = HostAlias()
                obj._deserialize(item)
                self._HostAliases.append(obj)
        if params.get("DNSConfig") is not None:
            self._DNSConfig = DNSConfig()
            self._DNSConfig._deserialize(params.get("DNSConfig"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ErrorSummary(AbstractModel):
    """Error Summary.

    """

    def __init__(self):
        r"""
        :param _Status: Status code.

Note: This field may return null, indicating that no valid value is found.
        :type Status: str
        :param _Result: Result code.

Note: This field may return null, indicating that no valid value is found.
        :type Result: str
        :param _Count: Number of error occurrences.

Note: This field may return null, indicating that no valid value is found.
        :type Count: int
        :param _Rate: Error rate.

Note: This field may return null, indicating that no valid value is found.
        :type Rate: float
        :param _Message: Error message.

Note: This field may return null, indicating that no valid value is found.
        :type Message: str
        :param _Proto: Request protocol type.

Note: This field may return null, indicating that no valid value is found.
        :type Proto: str
        """
        self._Status = None
        self._Result = None
        self._Count = None
        self._Rate = None
        self._Message = None
        self._Proto = None

    @property
    def Status(self):
        """Status code.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Result(self):
        """Result code.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def Count(self):
        """Number of error occurrences.

Note: This field may return null, indicating that no valid value is found.
        :rtype: int
        """
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def Rate(self):
        """Error rate.

Note: This field may return null, indicating that no valid value is found.
        :rtype: float
        """
        return self._Rate

    @Rate.setter
    def Rate(self, Rate):
        self._Rate = Rate

    @property
    def Message(self):
        """Error message.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Proto(self):
        """Request protocol type.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Proto

    @Proto.setter
    def Proto(self, Proto):
        self._Proto = Proto


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._Result = params.get("Result")
        self._Count = params.get("Count")
        self._Rate = params.get("Rate")
        self._Message = params.get("Message")
        self._Proto = params.get("Proto")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class File(AbstractModel):
    """File.

    """

    def __init__(self):
        r"""
        :param _FileId: File ID.
        :type FileId: str
        :param _Kind: File type. 1 represents parameter file, 2 represents protocol file, 3 represents request file.
        :type Kind: int
        :param _Name: Filename.
        :type Name: str
        :param _Size: File size.
        :type Size: int
        :param _Type: File type. The 'folder' represents a folder; if not specified, it represents a normal file.
        :type Type: str
        :param _UpdatedAt: Update time.
        :type UpdatedAt: str
        :param _LineCount: Number of file lines.

Note: This field may return null, indicating that no valid value is found.
        :type LineCount: int
        :param _HeadLines: First few rows of file.

Note: This field may return null, indicating that no valid value is found.
        :type HeadLines: list of str
        :param _TailLines: Last few rows of file.

Note: This field may return null, indicating that no valid value is found.
        :type TailLines: list of str
        :param _HeaderInFile: Whether the header is in the file.

Note: This field may return null, indicating that no valid value is found.
        :type HeaderInFile: bool
        :param _HeaderColumns: Parameter name.

Note: This field may return null, indicating that no valid value is found.
        :type HeaderColumns: list of str
        :param _FileInfos: Files in the folder.

Note: This field may return null, indicating that no valid value is found.
        :type FileInfos: list of FileInfo
        :param _ScenarioSet: Associated scenario.

Note: This field may return null, indicating that no valid value is found.
        :type ScenarioSet: list of Scenario
        :param _Status: File status.

Note: This field may return null, indicating that no valid value is found.
        :type Status: int
        :param _CreatedAt: Create time.

Note: This field may return null, indicating that no valid value is found.
        :type CreatedAt: str
        :param _ProjectId: Project ID.

Note: This field may return null, indicating that no valid value is found.
        :type ProjectId: str
        :param _AppID: Deprecated.

Note: This field may return null, indicating that no valid value is found.
        :type AppID: int
        :param _Uin: Uin.

Note: This field may return null, indicating that no valid value is found.
        :type Uin: str
        :param _SubAccountUin: Sub account uin.

Note: This field may return null, indicating that no valid value is found.
        :type SubAccountUin: str
        :param _AppId: App ID of user account.

Note: This field may return null, indicating that no valid value is found.
        :type AppId: int
        """
        self._FileId = None
        self._Kind = None
        self._Name = None
        self._Size = None
        self._Type = None
        self._UpdatedAt = None
        self._LineCount = None
        self._HeadLines = None
        self._TailLines = None
        self._HeaderInFile = None
        self._HeaderColumns = None
        self._FileInfos = None
        self._ScenarioSet = None
        self._Status = None
        self._CreatedAt = None
        self._ProjectId = None
        self._AppID = None
        self._Uin = None
        self._SubAccountUin = None
        self._AppId = None

    @property
    def FileId(self):
        """File ID.
        :rtype: str
        """
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def Kind(self):
        """File type. 1 represents parameter file, 2 represents protocol file, 3 represents request file.
        :rtype: int
        """
        return self._Kind

    @Kind.setter
    def Kind(self, Kind):
        self._Kind = Kind

    @property
    def Name(self):
        """Filename.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Size(self):
        """File size.
        :rtype: int
        """
        return self._Size

    @Size.setter
    def Size(self, Size):
        self._Size = Size

    @property
    def Type(self):
        """File type. The 'folder' represents a folder; if not specified, it represents a normal file.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def UpdatedAt(self):
        """Update time.
        :rtype: str
        """
        return self._UpdatedAt

    @UpdatedAt.setter
    def UpdatedAt(self, UpdatedAt):
        self._UpdatedAt = UpdatedAt

    @property
    def LineCount(self):
        """Number of file lines.

Note: This field may return null, indicating that no valid value is found.
        :rtype: int
        """
        return self._LineCount

    @LineCount.setter
    def LineCount(self, LineCount):
        self._LineCount = LineCount

    @property
    def HeadLines(self):
        """First few rows of file.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of str
        """
        return self._HeadLines

    @HeadLines.setter
    def HeadLines(self, HeadLines):
        self._HeadLines = HeadLines

    @property
    def TailLines(self):
        """Last few rows of file.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of str
        """
        return self._TailLines

    @TailLines.setter
    def TailLines(self, TailLines):
        self._TailLines = TailLines

    @property
    def HeaderInFile(self):
        """Whether the header is in the file.

Note: This field may return null, indicating that no valid value is found.
        :rtype: bool
        """
        return self._HeaderInFile

    @HeaderInFile.setter
    def HeaderInFile(self, HeaderInFile):
        self._HeaderInFile = HeaderInFile

    @property
    def HeaderColumns(self):
        """Parameter name.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of str
        """
        return self._HeaderColumns

    @HeaderColumns.setter
    def HeaderColumns(self, HeaderColumns):
        self._HeaderColumns = HeaderColumns

    @property
    def FileInfos(self):
        """Files in the folder.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of FileInfo
        """
        return self._FileInfos

    @FileInfos.setter
    def FileInfos(self, FileInfos):
        self._FileInfos = FileInfos

    @property
    def ScenarioSet(self):
        """Associated scenario.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of Scenario
        """
        return self._ScenarioSet

    @ScenarioSet.setter
    def ScenarioSet(self, ScenarioSet):
        self._ScenarioSet = ScenarioSet

    @property
    def Status(self):
        """File status.

Note: This field may return null, indicating that no valid value is found.
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def CreatedAt(self):
        """Create time.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._CreatedAt

    @CreatedAt.setter
    def CreatedAt(self, CreatedAt):
        self._CreatedAt = CreatedAt

    @property
    def ProjectId(self):
        """Project ID.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def AppID(self):
        """Deprecated.

Note: This field may return null, indicating that no valid value is found.
        :rtype: int
        """
        return self._AppID

    @AppID.setter
    def AppID(self, AppID):
        self._AppID = AppID

    @property
    def Uin(self):
        """Uin.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Uin

    @Uin.setter
    def Uin(self, Uin):
        self._Uin = Uin

    @property
    def SubAccountUin(self):
        """Sub account uin.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._SubAccountUin

    @SubAccountUin.setter
    def SubAccountUin(self, SubAccountUin):
        self._SubAccountUin = SubAccountUin

    @property
    def AppId(self):
        """App ID of user account.

Note: This field may return null, indicating that no valid value is found.
        :rtype: int
        """
        return self._AppId

    @AppId.setter
    def AppId(self, AppId):
        self._AppId = AppId


    def _deserialize(self, params):
        self._FileId = params.get("FileId")
        self._Kind = params.get("Kind")
        self._Name = params.get("Name")
        self._Size = params.get("Size")
        self._Type = params.get("Type")
        self._UpdatedAt = params.get("UpdatedAt")
        self._LineCount = params.get("LineCount")
        self._HeadLines = params.get("HeadLines")
        self._TailLines = params.get("TailLines")
        self._HeaderInFile = params.get("HeaderInFile")
        self._HeaderColumns = params.get("HeaderColumns")
        if params.get("FileInfos") is not None:
            self._FileInfos = []
            for item in params.get("FileInfos"):
                obj = FileInfo()
                obj._deserialize(item)
                self._FileInfos.append(obj)
        if params.get("ScenarioSet") is not None:
            self._ScenarioSet = []
            for item in params.get("ScenarioSet"):
                obj = Scenario()
                obj._deserialize(item)
                self._ScenarioSet.append(obj)
        self._Status = params.get("Status")
        self._CreatedAt = params.get("CreatedAt")
        self._ProjectId = params.get("ProjectId")
        self._AppID = params.get("AppID")
        self._Uin = params.get("Uin")
        self._SubAccountUin = params.get("SubAccountUin")
        self._AppId = params.get("AppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FileInfo(AbstractModel):
    """Basic file information

    """

    def __init__(self):
        r"""
        :param _Name: Filename

Note: This field may return null, indicating that no valid value is found.
        :type Name: str
        :param _Size: File size

Note: This field may return null, indicating that no valid value is found.
        :type Size: int
        :param _Type: File type

Note: This field may return null, indicating that no valid value is found.
        :type Type: str
        :param _UpdatedAt: Update time

Note: This field may return null, indicating that no valid value is found.
        :type UpdatedAt: str
        :param _FileId: File ID

Note: This field may return null, indicating that no valid value is found.
        :type FileId: str
        """
        self._Name = None
        self._Size = None
        self._Type = None
        self._UpdatedAt = None
        self._FileId = None

    @property
    def Name(self):
        """Filename

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Size(self):
        """File size

Note: This field may return null, indicating that no valid value is found.
        :rtype: int
        """
        return self._Size

    @Size.setter
    def Size(self, Size):
        self._Size = Size

    @property
    def Type(self):
        """File type

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def UpdatedAt(self):
        """Update time

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._UpdatedAt

    @UpdatedAt.setter
    def UpdatedAt(self, UpdatedAt):
        self._UpdatedAt = UpdatedAt

    @property
    def FileId(self):
        """File ID

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Size = params.get("Size")
        self._Type = params.get("Type")
        self._UpdatedAt = params.get("UpdatedAt")
        self._FileId = params.get("FileId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Filter(AbstractModel):
    """Metric query filter.

    """

    def __init__(self):
        r"""
        :param _Operator: Equals: 0, not equals: 1.
        :type Operator: int
        :param _LabelName: Tag name, optional values include:
1. method, request method name;
2. proto: protocol name;
3. service: service name;
4. status: response status code;
5.result: response details
6.check: check name.
        :type LabelName: str
        :param _LabelValue: Tag value, optional values include:
1.method: request method name, for example, GET, POST, PUT, etc.
2.proto: protocol name, for example, HTTP/1.1, HTTP/2, etc.
3.service: service name, for example, the request URL such as http://httpbin.org/get
4.status: response status code, for example, 200, 404, 500, etc.
5.result: response details, used to determine whether the request was successful or failed; if successful, the result Tag value is ok; if failed, the result Tag carries an error code and description.
6.check: check name, the Tag value is the checkpoint name set by the user.
        :type LabelValue: str
        """
        self._Operator = None
        self._LabelName = None
        self._LabelValue = None

    @property
    def Operator(self):
        """Equals: 0, not equals: 1.
        :rtype: int
        """
        return self._Operator

    @Operator.setter
    def Operator(self, Operator):
        self._Operator = Operator

    @property
    def LabelName(self):
        """Tag name, optional values include:
1. method, request method name;
2. proto: protocol name;
3. service: service name;
4. status: response status code;
5.result: response details
6.check: check name.
        :rtype: str
        """
        return self._LabelName

    @LabelName.setter
    def LabelName(self, LabelName):
        self._LabelName = LabelName

    @property
    def LabelValue(self):
        """Tag value, optional values include:
1.method: request method name, for example, GET, POST, PUT, etc.
2.proto: protocol name, for example, HTTP/1.1, HTTP/2, etc.
3.service: service name, for example, the request URL such as http://httpbin.org/get
4.status: response status code, for example, 200, 404, 500, etc.
5.result: response details, used to determine whether the request was successful or failed; if successful, the result Tag value is ok; if failed, the result Tag carries an error code and description.
6.check: check name, the Tag value is the checkpoint name set by the user.
        :rtype: str
        """
        return self._LabelValue

    @LabelValue.setter
    def LabelValue(self, LabelValue):
        self._LabelValue = LabelValue


    def _deserialize(self, params):
        self._Operator = params.get("Operator")
        self._LabelName = params.get("LabelName")
        self._LabelValue = params.get("LabelValue")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GenerateTmpKeyRequest(AbstractModel):
    """GenerateTmpKey request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID.
        :type ProjectId: str
        :param _ScenarioId: Scenario ID.
        :type ScenarioId: str
        """
        self._ProjectId = None
        self._ScenarioId = None

    @property
    def ProjectId(self):
        """Project ID.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ScenarioId(self):
        """Scenario ID.
        :rtype: str
        """
        return self._ScenarioId

    @ScenarioId.setter
    def ScenarioId(self, ScenarioId):
        self._ScenarioId = ScenarioId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._ScenarioId = params.get("ScenarioId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GenerateTmpKeyResponse(AbstractModel):
    """GenerateTmpKey response structure.

    """

    def __init__(self):
        r"""
        :param _StartTime: Timestamp when the temporary access credentials are obtained (unit: seconds).
        :type StartTime: int
        :param _ExpiredTime: Timestamp when the temporary access credentials expire (unit: seconds).
        :type ExpiredTime: int
        :param _Credentials: Temporary access credentials.
        :type Credentials: :class:`tencentcloud.pts.v20210728.models.Credentials`
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._StartTime = None
        self._ExpiredTime = None
        self._Credentials = None
        self._RequestId = None

    @property
    def StartTime(self):
        """Timestamp when the temporary access credentials are obtained (unit: seconds).
        :rtype: int
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def ExpiredTime(self):
        """Timestamp when the temporary access credentials expire (unit: seconds).
        :rtype: int
        """
        return self._ExpiredTime

    @ExpiredTime.setter
    def ExpiredTime(self, ExpiredTime):
        self._ExpiredTime = ExpiredTime

    @property
    def Credentials(self):
        """Temporary access credentials.
        :rtype: :class:`tencentcloud.pts.v20210728.models.Credentials`
        """
        return self._Credentials

    @Credentials.setter
    def Credentials(self, Credentials):
        self._Credentials = Credentials

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._ExpiredTime = params.get("ExpiredTime")
        if params.get("Credentials") is not None:
            self._Credentials = Credentials()
            self._Credentials._deserialize(params.get("Credentials"))
        self._RequestId = params.get("RequestId")


class GeoRegionsLoadItem(AbstractModel):
    """Load distribution configuration.

    """

    def __init__(self):
        r"""
        :param _RegionId: Region ID.
        :type RegionId: int
        :param _Region: Region.
        :type Region: str
        :param _Percentage: Percentage.
        :type Percentage: int
        """
        self._RegionId = None
        self._Region = None
        self._Percentage = None

    @property
    def RegionId(self):
        """Region ID.
        :rtype: int
        """
        return self._RegionId

    @RegionId.setter
    def RegionId(self, RegionId):
        self._RegionId = RegionId

    @property
    def Region(self):
        """Region.
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Percentage(self):
        """Percentage.
        :rtype: int
        """
        return self._Percentage

    @Percentage.setter
    def Percentage(self, Percentage):
        self._Percentage = Percentage


    def _deserialize(self, params):
        self._RegionId = params.get("RegionId")
        self._Region = params.get("Region")
        self._Percentage = params.get("Percentage")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class HostAlias(AbstractModel):
    """Domain configuration of the pressure machine.

    """

    def __init__(self):
        r"""
        :param _HostNames: Domain list to be bound.

Note: This field may return null, indicating that no valid value is found.
        :type HostNames: list of str
        :param _IP: IP address to be bound.

Note: This field may return null, indicating that no valid value is found.
        :type IP: str
        """
        self._HostNames = None
        self._IP = None

    @property
    def HostNames(self):
        """Domain list to be bound.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of str
        """
        return self._HostNames

    @HostNames.setter
    def HostNames(self, HostNames):
        self._HostNames = HostNames

    @property
    def IP(self):
        """IP address to be bound.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._IP

    @IP.setter
    def IP(self, IP):
        self._IP = IP


    def _deserialize(self, params):
        self._HostNames = params.get("HostNames")
        self._IP = params.get("IP")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InternalMetricQuery(AbstractModel):
    """General metric query structure.

    """

    def __init__(self):
        r"""
        :param _Metric: Metric name.
        :type Metric: str
        :param _Aggregation: Aggregation Function, optional value including Rate, Count, Avg, P90, P95, P99, Gauge.
        :type Aggregation: str
        :param _Labels: Deprecated, please use 'Filters'.
        :type Labels: list of Label
        :param _Filters: Use label filter rules to filter metrics. Rules include LabelName, LabelValue, and Operator (0 means equal, 1 means not equal).
        :type Filters: list of Filter
        :param _GroupBy: Metric group.
        :type GroupBy: list of str
        """
        self._Metric = None
        self._Aggregation = None
        self._Labels = None
        self._Filters = None
        self._GroupBy = None

    @property
    def Metric(self):
        """Metric name.
        :rtype: str
        """
        return self._Metric

    @Metric.setter
    def Metric(self, Metric):
        self._Metric = Metric

    @property
    def Aggregation(self):
        """Aggregation Function, optional value including Rate, Count, Avg, P90, P95, P99, Gauge.
        :rtype: str
        """
        return self._Aggregation

    @Aggregation.setter
    def Aggregation(self, Aggregation):
        self._Aggregation = Aggregation

    @property
    def Labels(self):
        """Deprecated, please use 'Filters'.
        :rtype: list of Label
        """
        return self._Labels

    @Labels.setter
    def Labels(self, Labels):
        self._Labels = Labels

    @property
    def Filters(self):
        """Use label filter rules to filter metrics. Rules include LabelName, LabelValue, and Operator (0 means equal, 1 means not equal).
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def GroupBy(self):
        """Metric group.
        :rtype: list of str
        """
        return self._GroupBy

    @GroupBy.setter
    def GroupBy(self, GroupBy):
        self._GroupBy = GroupBy


    def _deserialize(self, params):
        self._Metric = params.get("Metric")
        self._Aggregation = params.get("Aggregation")
        if params.get("Labels") is not None:
            self._Labels = []
            for item in params.get("Labels"):
                obj = Label()
                obj._deserialize(item)
                self._Labels.append(obj)
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._GroupBy = params.get("GroupBy")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Job(AbstractModel):
    """Performance test job.

    """

    def __init__(self):
        r"""
        :param _JobId: Job ID.

Note: This field may return null, indicating that no valid value is found.
        :type JobId: str
        :param _ScenarioId: Scenario ID.

Note: This field may return null, indicating that no valid value is found.
        :type ScenarioId: str
        :param _Load: Load configuration.

Note: This field may return null, indicating that no valid value is found.
        :type Load: :class:`tencentcloud.pts.v20210728.models.Load`
        :param _Configs: Deprecated.

Note: This field may return null, indicating that no valid value is found.
        :type Configs: list of str
        :param _Datasets: Test datasets.

Note: This field may return null, indicating that no valid value is found.
        :type Datasets: list of TestData
        :param _Extensions: Deprecated.

Note: This field may return null, indicating that no valid value is found.
        :type Extensions: list of str
        :param _Status: Job status, values including:
JobUnknown: 0, JobCreated: 1, JobPending: 2, JobPreparing: 3, JobSelectClustering: 4, JobCreateTasking: 5, JobSyncTasking: 6,
JobRunning:11,JobFinished:12,JobPrepareException:13,JobFinishException:14,JobAborting:15,JobAborted:16,JobAbortException:17,JobDeleted:18,
JobSelectClusterException:19,JobCreateTaskException:20,JobSyncTaskException:21

Note: This field may return null, indicating that no valid value is found.
        :type Status: int
        :param _StartTime: Start time.

Note: This field may return null, indicating that no valid value is found.
        :type StartTime: str
        :param _EndTime: End time.

Note: This field may return null, indicating that no valid value is found.
        :type EndTime: str
        :param _MaxVirtualUserCount: Maximum VU.

Note: This field may return null, indicating that no valid value is found.
        :type MaxVirtualUserCount: int
        :param _Note: Note.

Note: This field may return null, indicating that no valid value is found.
        :type Note: str
        :param _ErrorRate: Error rate percentage.

Note: This field may return null, indicating that no valid value is found.
        :type ErrorRate: float
        :param _JobOwner: Job owner.

Note: This field may return null, indicating that no valid value is found.
        :type JobOwner: str
        :param _LoadSources: Deprecated.

Note: This field may return null, indicating that no valid value is found.
        :type LoadSources: :class:`tencentcloud.pts.v20210728.models.LoadSource`
        :param _Duration: Job duration.

Note: This field may return null, indicating that no valid value is found.
        :type Duration: int
        :param _MaxRequestsPerSecond: Maximum requests per second.

Note: This field may return null, indicating that no valid value is found.
        :type MaxRequestsPerSecond: int
        :param _RequestTotal: Total number of requests.

Note: This field may return null, indicating that no valid value is found.
        :type RequestTotal: float
        :param _RequestsPerSecond: Average requests per second.

Note: This field may return null, indicating that no valid value is found.
        :type RequestsPerSecond: float
        :param _ResponseTimeAverage: Average response time.

Note: This field may return null, indicating that no valid value is found.
        :type ResponseTimeAverage: float
        :param _ResponseTimeP99: 99th percentile response time.

Note: This field may return null, indicating that no valid value is found.
        :type ResponseTimeP99: float
        :param _ResponseTimeP95: 95th percentile response time.

Note: This field may return null, indicating that no valid value is found.
        :type ResponseTimeP95: float
        :param _ResponseTimeP90: 90th percentile response time.

Note: This field may return null, indicating that no valid value is found.
        :type ResponseTimeP90: float
        :param _Scripts: Deprecated.

Note: This field may return null, indicating that no valid value is found.
        :type Scripts: list of str
        :param _ResponseTimeMax: Maximum response time.

Note: This field may return null, indicating that no valid value is found.
        :type ResponseTimeMax: float
        :param _ResponseTimeMin: Minimum response time.

Note: This field may return null, indicating that no valid value is found.
        :type ResponseTimeMin: float
        :param _LoadSourceInfos: Stress machine information.

Note: This field may return null, indicating that no valid value is found.
        :type LoadSourceInfos: list of LoadSource
        :param _TestScripts: Test script information.

Note: This field may return null, indicating that no valid value is found.
        :type TestScripts: list of ScriptInfo
        :param _Protocols: Protocol file information.

Note: This field may return null, indicating that no valid value is found.
        :type Protocols: list of ProtocolInfo
        :param _RequestFiles: Request file information.

Note: This field may return null, indicating that no valid value is found.
        :type RequestFiles: list of FileInfo
        :param _Plugins: Extension file information.

Note: This field may return null, indicating that no valid value is found.
        :type Plugins: list of FileInfo
        :param _CronId: Cron job ID.

Note: This field may return null, indicating that no valid value is found.
        :type CronId: str
        :param _Type: Scenario type.

Note: This field may return null, indicating that no valid value is found.
        :type Type: str
        :param _DomainNameConfig: Domain binding configuration.

Note: This field may return null, indicating that no valid value is found.
        :type DomainNameConfig: :class:`tencentcloud.pts.v20210728.models.DomainNameConfig`
        :param _Debug: Whether the job is a debug job.

Note: This field may return null, indicating that no valid value is found.
        :type Debug: bool
        :param _AbortReason: Abort reason.

Note: This field may return null, indicating that no valid value is found.
        :type AbortReason: int
        :param _CreatedAt: Create Time.

Note: This field may return null, indicating that no valid value is found.
        :type CreatedAt: str
        :param _ProjectId: Project ID.

Note: This field may return null, indicating that no valid value is found.
        :type ProjectId: str
        :param _NotificationHooks: Notification event callback.

Note: This field may return null, indicating that no valid value is found.
        :type NotificationHooks: list of NotificationHook
        :param _NetworkReceiveRate: Bytes received per second.

Note: This field may return null, indicating that no valid value is found.
        :type NetworkReceiveRate: float
        :param _NetworkSendRate: Bytes sent per second.

Note: This field may return null, indicating that no valid value is found.
        :type NetworkSendRate: float
        :param _Message: Job status description.

Note: This field may return null, indicating that no valid value is found.
        :type Message: str
        :param _ProjectName: Project name.

Note: This field may return null, indicating that no valid value is found.
        :type ProjectName: str
        :param _ScenarioName: Scenario name.

Note: This field may return null, indicating that no valid value is found.
        :type ScenarioName: str
        :param _PayMode: Billing type.

Note: This field may return null, indicating that no valid value is found.
        :type PayMode: int
        :param _Usage: Job VUM usage.

Note: This field may return null, indicating that no valid value is found.
        :type Usage: int
        """
        self._JobId = None
        self._ScenarioId = None
        self._Load = None
        self._Configs = None
        self._Datasets = None
        self._Extensions = None
        self._Status = None
        self._StartTime = None
        self._EndTime = None
        self._MaxVirtualUserCount = None
        self._Note = None
        self._ErrorRate = None
        self._JobOwner = None
        self._LoadSources = None
        self._Duration = None
        self._MaxRequestsPerSecond = None
        self._RequestTotal = None
        self._RequestsPerSecond = None
        self._ResponseTimeAverage = None
        self._ResponseTimeP99 = None
        self._ResponseTimeP95 = None
        self._ResponseTimeP90 = None
        self._Scripts = None
        self._ResponseTimeMax = None
        self._ResponseTimeMin = None
        self._LoadSourceInfos = None
        self._TestScripts = None
        self._Protocols = None
        self._RequestFiles = None
        self._Plugins = None
        self._CronId = None
        self._Type = None
        self._DomainNameConfig = None
        self._Debug = None
        self._AbortReason = None
        self._CreatedAt = None
        self._ProjectId = None
        self._NotificationHooks = None
        self._NetworkReceiveRate = None
        self._NetworkSendRate = None
        self._Message = None
        self._ProjectName = None
        self._ScenarioName = None
        self._PayMode = None
        self._Usage = None

    @property
    def JobId(self):
        """Job ID.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def ScenarioId(self):
        """Scenario ID.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._ScenarioId

    @ScenarioId.setter
    def ScenarioId(self, ScenarioId):
        self._ScenarioId = ScenarioId

    @property
    def Load(self):
        """Load configuration.

Note: This field may return null, indicating that no valid value is found.
        :rtype: :class:`tencentcloud.pts.v20210728.models.Load`
        """
        return self._Load

    @Load.setter
    def Load(self, Load):
        self._Load = Load

    @property
    def Configs(self):
        """Deprecated.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of str
        """
        return self._Configs

    @Configs.setter
    def Configs(self, Configs):
        self._Configs = Configs

    @property
    def Datasets(self):
        """Test datasets.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of TestData
        """
        return self._Datasets

    @Datasets.setter
    def Datasets(self, Datasets):
        self._Datasets = Datasets

    @property
    def Extensions(self):
        """Deprecated.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of str
        """
        return self._Extensions

    @Extensions.setter
    def Extensions(self, Extensions):
        self._Extensions = Extensions

    @property
    def Status(self):
        """Job status, values including:
JobUnknown: 0, JobCreated: 1, JobPending: 2, JobPreparing: 3, JobSelectClustering: 4, JobCreateTasking: 5, JobSyncTasking: 6,
JobRunning:11,JobFinished:12,JobPrepareException:13,JobFinishException:14,JobAborting:15,JobAborted:16,JobAbortException:17,JobDeleted:18,
JobSelectClusterException:19,JobCreateTaskException:20,JobSyncTaskException:21

Note: This field may return null, indicating that no valid value is found.
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def StartTime(self):
        """Start time.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """End time.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def MaxVirtualUserCount(self):
        """Maximum VU.

Note: This field may return null, indicating that no valid value is found.
        :rtype: int
        """
        return self._MaxVirtualUserCount

    @MaxVirtualUserCount.setter
    def MaxVirtualUserCount(self, MaxVirtualUserCount):
        self._MaxVirtualUserCount = MaxVirtualUserCount

    @property
    def Note(self):
        """Note.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Note

    @Note.setter
    def Note(self, Note):
        self._Note = Note

    @property
    def ErrorRate(self):
        """Error rate percentage.

Note: This field may return null, indicating that no valid value is found.
        :rtype: float
        """
        return self._ErrorRate

    @ErrorRate.setter
    def ErrorRate(self, ErrorRate):
        self._ErrorRate = ErrorRate

    @property
    def JobOwner(self):
        """Job owner.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._JobOwner

    @JobOwner.setter
    def JobOwner(self, JobOwner):
        self._JobOwner = JobOwner

    @property
    def LoadSources(self):
        """Deprecated.

Note: This field may return null, indicating that no valid value is found.
        :rtype: :class:`tencentcloud.pts.v20210728.models.LoadSource`
        """
        return self._LoadSources

    @LoadSources.setter
    def LoadSources(self, LoadSources):
        self._LoadSources = LoadSources

    @property
    def Duration(self):
        """Job duration.

Note: This field may return null, indicating that no valid value is found.
        :rtype: int
        """
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration

    @property
    def MaxRequestsPerSecond(self):
        """Maximum requests per second.

Note: This field may return null, indicating that no valid value is found.
        :rtype: int
        """
        return self._MaxRequestsPerSecond

    @MaxRequestsPerSecond.setter
    def MaxRequestsPerSecond(self, MaxRequestsPerSecond):
        self._MaxRequestsPerSecond = MaxRequestsPerSecond

    @property
    def RequestTotal(self):
        """Total number of requests.

Note: This field may return null, indicating that no valid value is found.
        :rtype: float
        """
        return self._RequestTotal

    @RequestTotal.setter
    def RequestTotal(self, RequestTotal):
        self._RequestTotal = RequestTotal

    @property
    def RequestsPerSecond(self):
        """Average requests per second.

Note: This field may return null, indicating that no valid value is found.
        :rtype: float
        """
        return self._RequestsPerSecond

    @RequestsPerSecond.setter
    def RequestsPerSecond(self, RequestsPerSecond):
        self._RequestsPerSecond = RequestsPerSecond

    @property
    def ResponseTimeAverage(self):
        """Average response time.

Note: This field may return null, indicating that no valid value is found.
        :rtype: float
        """
        return self._ResponseTimeAverage

    @ResponseTimeAverage.setter
    def ResponseTimeAverage(self, ResponseTimeAverage):
        self._ResponseTimeAverage = ResponseTimeAverage

    @property
    def ResponseTimeP99(self):
        """99th percentile response time.

Note: This field may return null, indicating that no valid value is found.
        :rtype: float
        """
        return self._ResponseTimeP99

    @ResponseTimeP99.setter
    def ResponseTimeP99(self, ResponseTimeP99):
        self._ResponseTimeP99 = ResponseTimeP99

    @property
    def ResponseTimeP95(self):
        """95th percentile response time.

Note: This field may return null, indicating that no valid value is found.
        :rtype: float
        """
        return self._ResponseTimeP95

    @ResponseTimeP95.setter
    def ResponseTimeP95(self, ResponseTimeP95):
        self._ResponseTimeP95 = ResponseTimeP95

    @property
    def ResponseTimeP90(self):
        """90th percentile response time.

Note: This field may return null, indicating that no valid value is found.
        :rtype: float
        """
        return self._ResponseTimeP90

    @ResponseTimeP90.setter
    def ResponseTimeP90(self, ResponseTimeP90):
        self._ResponseTimeP90 = ResponseTimeP90

    @property
    def Scripts(self):
        """Deprecated.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of str
        """
        return self._Scripts

    @Scripts.setter
    def Scripts(self, Scripts):
        self._Scripts = Scripts

    @property
    def ResponseTimeMax(self):
        """Maximum response time.

Note: This field may return null, indicating that no valid value is found.
        :rtype: float
        """
        return self._ResponseTimeMax

    @ResponseTimeMax.setter
    def ResponseTimeMax(self, ResponseTimeMax):
        self._ResponseTimeMax = ResponseTimeMax

    @property
    def ResponseTimeMin(self):
        """Minimum response time.

Note: This field may return null, indicating that no valid value is found.
        :rtype: float
        """
        return self._ResponseTimeMin

    @ResponseTimeMin.setter
    def ResponseTimeMin(self, ResponseTimeMin):
        self._ResponseTimeMin = ResponseTimeMin

    @property
    def LoadSourceInfos(self):
        """Stress machine information.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of LoadSource
        """
        return self._LoadSourceInfos

    @LoadSourceInfos.setter
    def LoadSourceInfos(self, LoadSourceInfos):
        self._LoadSourceInfos = LoadSourceInfos

    @property
    def TestScripts(self):
        """Test script information.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of ScriptInfo
        """
        return self._TestScripts

    @TestScripts.setter
    def TestScripts(self, TestScripts):
        self._TestScripts = TestScripts

    @property
    def Protocols(self):
        """Protocol file information.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of ProtocolInfo
        """
        return self._Protocols

    @Protocols.setter
    def Protocols(self, Protocols):
        self._Protocols = Protocols

    @property
    def RequestFiles(self):
        """Request file information.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of FileInfo
        """
        return self._RequestFiles

    @RequestFiles.setter
    def RequestFiles(self, RequestFiles):
        self._RequestFiles = RequestFiles

    @property
    def Plugins(self):
        """Extension file information.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of FileInfo
        """
        return self._Plugins

    @Plugins.setter
    def Plugins(self, Plugins):
        self._Plugins = Plugins

    @property
    def CronId(self):
        """Cron job ID.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._CronId

    @CronId.setter
    def CronId(self, CronId):
        self._CronId = CronId

    @property
    def Type(self):
        """Scenario type.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def DomainNameConfig(self):
        """Domain binding configuration.

Note: This field may return null, indicating that no valid value is found.
        :rtype: :class:`tencentcloud.pts.v20210728.models.DomainNameConfig`
        """
        return self._DomainNameConfig

    @DomainNameConfig.setter
    def DomainNameConfig(self, DomainNameConfig):
        self._DomainNameConfig = DomainNameConfig

    @property
    def Debug(self):
        """Whether the job is a debug job.

Note: This field may return null, indicating that no valid value is found.
        :rtype: bool
        """
        return self._Debug

    @Debug.setter
    def Debug(self, Debug):
        self._Debug = Debug

    @property
    def AbortReason(self):
        """Abort reason.

Note: This field may return null, indicating that no valid value is found.
        :rtype: int
        """
        return self._AbortReason

    @AbortReason.setter
    def AbortReason(self, AbortReason):
        self._AbortReason = AbortReason

    @property
    def CreatedAt(self):
        """Create Time.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._CreatedAt

    @CreatedAt.setter
    def CreatedAt(self, CreatedAt):
        self._CreatedAt = CreatedAt

    @property
    def ProjectId(self):
        """Project ID.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def NotificationHooks(self):
        """Notification event callback.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of NotificationHook
        """
        return self._NotificationHooks

    @NotificationHooks.setter
    def NotificationHooks(self, NotificationHooks):
        self._NotificationHooks = NotificationHooks

    @property
    def NetworkReceiveRate(self):
        """Bytes received per second.

Note: This field may return null, indicating that no valid value is found.
        :rtype: float
        """
        return self._NetworkReceiveRate

    @NetworkReceiveRate.setter
    def NetworkReceiveRate(self, NetworkReceiveRate):
        self._NetworkReceiveRate = NetworkReceiveRate

    @property
    def NetworkSendRate(self):
        """Bytes sent per second.

Note: This field may return null, indicating that no valid value is found.
        :rtype: float
        """
        return self._NetworkSendRate

    @NetworkSendRate.setter
    def NetworkSendRate(self, NetworkSendRate):
        self._NetworkSendRate = NetworkSendRate

    @property
    def Message(self):
        """Job status description.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def ProjectName(self):
        """Project name.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._ProjectName

    @ProjectName.setter
    def ProjectName(self, ProjectName):
        self._ProjectName = ProjectName

    @property
    def ScenarioName(self):
        """Scenario name.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._ScenarioName

    @ScenarioName.setter
    def ScenarioName(self, ScenarioName):
        self._ScenarioName = ScenarioName

    @property
    def PayMode(self):
        """Billing type.

Note: This field may return null, indicating that no valid value is found.
        :rtype: int
        """
        return self._PayMode

    @PayMode.setter
    def PayMode(self, PayMode):
        self._PayMode = PayMode

    @property
    def Usage(self):
        """Job VUM usage.

Note: This field may return null, indicating that no valid value is found.
        :rtype: int
        """
        return self._Usage

    @Usage.setter
    def Usage(self, Usage):
        self._Usage = Usage


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._ScenarioId = params.get("ScenarioId")
        if params.get("Load") is not None:
            self._Load = Load()
            self._Load._deserialize(params.get("Load"))
        self._Configs = params.get("Configs")
        if params.get("Datasets") is not None:
            self._Datasets = []
            for item in params.get("Datasets"):
                obj = TestData()
                obj._deserialize(item)
                self._Datasets.append(obj)
        self._Extensions = params.get("Extensions")
        self._Status = params.get("Status")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._MaxVirtualUserCount = params.get("MaxVirtualUserCount")
        self._Note = params.get("Note")
        self._ErrorRate = params.get("ErrorRate")
        self._JobOwner = params.get("JobOwner")
        if params.get("LoadSources") is not None:
            self._LoadSources = LoadSource()
            self._LoadSources._deserialize(params.get("LoadSources"))
        self._Duration = params.get("Duration")
        self._MaxRequestsPerSecond = params.get("MaxRequestsPerSecond")
        self._RequestTotal = params.get("RequestTotal")
        self._RequestsPerSecond = params.get("RequestsPerSecond")
        self._ResponseTimeAverage = params.get("ResponseTimeAverage")
        self._ResponseTimeP99 = params.get("ResponseTimeP99")
        self._ResponseTimeP95 = params.get("ResponseTimeP95")
        self._ResponseTimeP90 = params.get("ResponseTimeP90")
        self._Scripts = params.get("Scripts")
        self._ResponseTimeMax = params.get("ResponseTimeMax")
        self._ResponseTimeMin = params.get("ResponseTimeMin")
        if params.get("LoadSourceInfos") is not None:
            self._LoadSourceInfos = []
            for item in params.get("LoadSourceInfos"):
                obj = LoadSource()
                obj._deserialize(item)
                self._LoadSourceInfos.append(obj)
        if params.get("TestScripts") is not None:
            self._TestScripts = []
            for item in params.get("TestScripts"):
                obj = ScriptInfo()
                obj._deserialize(item)
                self._TestScripts.append(obj)
        if params.get("Protocols") is not None:
            self._Protocols = []
            for item in params.get("Protocols"):
                obj = ProtocolInfo()
                obj._deserialize(item)
                self._Protocols.append(obj)
        if params.get("RequestFiles") is not None:
            self._RequestFiles = []
            for item in params.get("RequestFiles"):
                obj = FileInfo()
                obj._deserialize(item)
                self._RequestFiles.append(obj)
        if params.get("Plugins") is not None:
            self._Plugins = []
            for item in params.get("Plugins"):
                obj = FileInfo()
                obj._deserialize(item)
                self._Plugins.append(obj)
        self._CronId = params.get("CronId")
        self._Type = params.get("Type")
        if params.get("DomainNameConfig") is not None:
            self._DomainNameConfig = DomainNameConfig()
            self._DomainNameConfig._deserialize(params.get("DomainNameConfig"))
        self._Debug = params.get("Debug")
        self._AbortReason = params.get("AbortReason")
        self._CreatedAt = params.get("CreatedAt")
        self._ProjectId = params.get("ProjectId")
        if params.get("NotificationHooks") is not None:
            self._NotificationHooks = []
            for item in params.get("NotificationHooks"):
                obj = NotificationHook()
                obj._deserialize(item)
                self._NotificationHooks.append(obj)
        self._NetworkReceiveRate = params.get("NetworkReceiveRate")
        self._NetworkSendRate = params.get("NetworkSendRate")
        self._Message = params.get("Message")
        self._ProjectName = params.get("ProjectName")
        self._ScenarioName = params.get("ScenarioName")
        self._PayMode = params.get("PayMode")
        self._Usage = params.get("Usage")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Label(AbstractModel):
    """Contains label name and label value.

    """

    def __init__(self):
        r"""
        :param _LabelName: Label name.
        :type LabelName: str
        :param _LabelValue: Label value.
        :type LabelValue: str
        """
        self._LabelName = None
        self._LabelValue = None

    @property
    def LabelName(self):
        """Label name.
        :rtype: str
        """
        return self._LabelName

    @LabelName.setter
    def LabelName(self, LabelName):
        self._LabelName = LabelName

    @property
    def LabelValue(self):
        """Label value.
        :rtype: str
        """
        return self._LabelValue

    @LabelValue.setter
    def LabelValue(self, LabelValue):
        self._LabelValue = LabelValue


    def _deserialize(self, params):
        self._LabelName = params.get("LabelName")
        self._LabelValue = params.get("LabelValue")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LabelWithValues(AbstractModel):
    """Label name and value.

    """

    def __init__(self):
        r"""
        :param _LabelName: Label Name.
        :type LabelName: str
        :param _LabelValues: Label values.
        :type LabelValues: list of str
        """
        self._LabelName = None
        self._LabelValues = None

    @property
    def LabelName(self):
        """Label Name.
        :rtype: str
        """
        return self._LabelName

    @LabelName.setter
    def LabelName(self, LabelName):
        self._LabelName = LabelName

    @property
    def LabelValues(self):
        """Label values.
        :rtype: list of str
        """
        return self._LabelValues

    @LabelValues.setter
    def LabelValues(self, LabelValues):
        self._LabelValues = LabelValues


    def _deserialize(self, params):
        self._LabelName = params.get("LabelName")
        self._LabelValues = params.get("LabelValues")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Load(AbstractModel):
    """Load configuration.

    """

    def __init__(self):
        r"""
        :param _LoadSpec: Load configuration.

Note: This field may return null, indicating that no valid value is found.
        :type LoadSpec: :class:`tencentcloud.pts.v20210728.models.LoadSpec`
        :param _VpcLoadDistribution: Stress source from vpc.

Note: This field may return null, indicating that no valid value is found.
        :type VpcLoadDistribution: :class:`tencentcloud.pts.v20210728.models.VpcLoadDistribution`
        :param _GeoRegionsLoadDistribution: Multi-region stress distribution.

Note: This field may return null, indicating that no valid value is found.
        :type GeoRegionsLoadDistribution: list of GeoRegionsLoadItem
        """
        self._LoadSpec = None
        self._VpcLoadDistribution = None
        self._GeoRegionsLoadDistribution = None

    @property
    def LoadSpec(self):
        """Load configuration.

Note: This field may return null, indicating that no valid value is found.
        :rtype: :class:`tencentcloud.pts.v20210728.models.LoadSpec`
        """
        return self._LoadSpec

    @LoadSpec.setter
    def LoadSpec(self, LoadSpec):
        self._LoadSpec = LoadSpec

    @property
    def VpcLoadDistribution(self):
        """Stress source from vpc.

Note: This field may return null, indicating that no valid value is found.
        :rtype: :class:`tencentcloud.pts.v20210728.models.VpcLoadDistribution`
        """
        return self._VpcLoadDistribution

    @VpcLoadDistribution.setter
    def VpcLoadDistribution(self, VpcLoadDistribution):
        self._VpcLoadDistribution = VpcLoadDistribution

    @property
    def GeoRegionsLoadDistribution(self):
        """Multi-region stress distribution.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of GeoRegionsLoadItem
        """
        return self._GeoRegionsLoadDistribution

    @GeoRegionsLoadDistribution.setter
    def GeoRegionsLoadDistribution(self, GeoRegionsLoadDistribution):
        self._GeoRegionsLoadDistribution = GeoRegionsLoadDistribution


    def _deserialize(self, params):
        if params.get("LoadSpec") is not None:
            self._LoadSpec = LoadSpec()
            self._LoadSpec._deserialize(params.get("LoadSpec"))
        if params.get("VpcLoadDistribution") is not None:
            self._VpcLoadDistribution = VpcLoadDistribution()
            self._VpcLoadDistribution._deserialize(params.get("VpcLoadDistribution"))
        if params.get("GeoRegionsLoadDistribution") is not None:
            self._GeoRegionsLoadDistribution = []
            for item in params.get("GeoRegionsLoadDistribution"):
                obj = GeoRegionsLoadItem()
                obj._deserialize(item)
                self._GeoRegionsLoadDistribution.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LoadSource(AbstractModel):
    """Performance test host source.

    """

    def __init__(self):
        r"""
        :param _IP: Pressure machine IP.

Note: This field may return null, indicating that no valid value is found.
        :type IP: str
        :param _PodName: Pressure machine pod.

Note: This field may return null, indicating that no valid value is found.
        :type PodName: str
        :param _Region: Region.

Note: This field may return null, indicating that no valid value is found.
        :type Region: str
        """
        self._IP = None
        self._PodName = None
        self._Region = None

    @property
    def IP(self):
        """Pressure machine IP.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._IP

    @IP.setter
    def IP(self, IP):
        self._IP = IP

    @property
    def PodName(self):
        """Pressure machine pod.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._PodName

    @PodName.setter
    def PodName(self, PodName):
        self._PodName = PodName

    @property
    def Region(self):
        """Region.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region


    def _deserialize(self, params):
        self._IP = params.get("IP")
        self._PodName = params.get("PodName")
        self._Region = params.get("Region")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LoadSpec(AbstractModel):
    """Load configuration.

    """

    def __init__(self):
        r"""
        :param _Concurrency: Configuration for concurrency mode.

Note: This field may return null, indicating that no valid value is found.
        :type Concurrency: :class:`tencentcloud.pts.v20210728.models.Concurrency`
        :param _RequestsPerSecond: Configuration for RPS mode.

Note: This field may return null, indicating that no valid value is found.
        :type RequestsPerSecond: :class:`tencentcloud.pts.v20210728.models.RequestsPerSecond`
        :param _ScriptOrigin: Built-in script mode.

Note: This field may return null, indicating that no valid value is found.
        :type ScriptOrigin: :class:`tencentcloud.pts.v20210728.models.ScriptOrigin`
        """
        self._Concurrency = None
        self._RequestsPerSecond = None
        self._ScriptOrigin = None

    @property
    def Concurrency(self):
        """Configuration for concurrency mode.

Note: This field may return null, indicating that no valid value is found.
        :rtype: :class:`tencentcloud.pts.v20210728.models.Concurrency`
        """
        return self._Concurrency

    @Concurrency.setter
    def Concurrency(self, Concurrency):
        self._Concurrency = Concurrency

    @property
    def RequestsPerSecond(self):
        """Configuration for RPS mode.

Note: This field may return null, indicating that no valid value is found.
        :rtype: :class:`tencentcloud.pts.v20210728.models.RequestsPerSecond`
        """
        return self._RequestsPerSecond

    @RequestsPerSecond.setter
    def RequestsPerSecond(self, RequestsPerSecond):
        self._RequestsPerSecond = RequestsPerSecond

    @property
    def ScriptOrigin(self):
        """Built-in script mode.

Note: This field may return null, indicating that no valid value is found.
        :rtype: :class:`tencentcloud.pts.v20210728.models.ScriptOrigin`
        """
        return self._ScriptOrigin

    @ScriptOrigin.setter
    def ScriptOrigin(self, ScriptOrigin):
        self._ScriptOrigin = ScriptOrigin


    def _deserialize(self, params):
        if params.get("Concurrency") is not None:
            self._Concurrency = Concurrency()
            self._Concurrency._deserialize(params.get("Concurrency"))
        if params.get("RequestsPerSecond") is not None:
            self._RequestsPerSecond = RequestsPerSecond()
            self._RequestsPerSecond._deserialize(params.get("RequestsPerSecond"))
        if params.get("ScriptOrigin") is not None:
            self._ScriptOrigin = ScriptOrigin()
            self._ScriptOrigin._deserialize(params.get("ScriptOrigin"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MetricInfo(AbstractModel):
    """Metric structure.

    """

    def __init__(self):
        r"""
        :param _Metric: Metric name in backend.
        :type Metric: str
        :param _Alias: Metric name displayed in frontend.
        :type Alias: str
        :param _Description: Metric description.

Note: This field may return null, indicating that no valid value is found.
        :type Description: str
        :param _MetricType: Metric type.
        :type MetricType: str
        :param _Unit: Default metric unit.
        :type Unit: str
        :param _Aggregations: Aggregation functions supported by the metric.
        :type Aggregations: list of AggregationLegend
        :param _InnerMetric: Whether it is an internal metric, internal metrics cannot be freely selected by users on the frontend.
        :type InnerMetric: bool
        """
        self._Metric = None
        self._Alias = None
        self._Description = None
        self._MetricType = None
        self._Unit = None
        self._Aggregations = None
        self._InnerMetric = None

    @property
    def Metric(self):
        """Metric name in backend.
        :rtype: str
        """
        return self._Metric

    @Metric.setter
    def Metric(self, Metric):
        self._Metric = Metric

    @property
    def Alias(self):
        """Metric name displayed in frontend.
        :rtype: str
        """
        return self._Alias

    @Alias.setter
    def Alias(self, Alias):
        self._Alias = Alias

    @property
    def Description(self):
        """Metric description.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def MetricType(self):
        """Metric type.
        :rtype: str
        """
        return self._MetricType

    @MetricType.setter
    def MetricType(self, MetricType):
        self._MetricType = MetricType

    @property
    def Unit(self):
        """Default metric unit.
        :rtype: str
        """
        return self._Unit

    @Unit.setter
    def Unit(self, Unit):
        self._Unit = Unit

    @property
    def Aggregations(self):
        """Aggregation functions supported by the metric.
        :rtype: list of AggregationLegend
        """
        return self._Aggregations

    @Aggregations.setter
    def Aggregations(self, Aggregations):
        self._Aggregations = Aggregations

    @property
    def InnerMetric(self):
        """Whether it is an internal metric, internal metrics cannot be freely selected by users on the frontend.
        :rtype: bool
        """
        return self._InnerMetric

    @InnerMetric.setter
    def InnerMetric(self, InnerMetric):
        self._InnerMetric = InnerMetric


    def _deserialize(self, params):
        self._Metric = params.get("Metric")
        self._Alias = params.get("Alias")
        self._Description = params.get("Description")
        self._MetricType = params.get("MetricType")
        self._Unit = params.get("Unit")
        if params.get("Aggregations") is not None:
            self._Aggregations = []
            for item in params.get("Aggregations"):
                obj = AggregationLegend()
                obj._deserialize(item)
                self._Aggregations.append(obj)
        self._InnerMetric = params.get("InnerMetric")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MetricLabelWithValues(AbstractModel):
    """Metric provided by PTS with labels and values.

    """

    def __init__(self):
        r"""
        :param _MetricName: Metric name.
        :type MetricName: str
        :param _LabelValuesSet: Labels and values.
        :type LabelValuesSet: list of LabelWithValues
        """
        self._MetricName = None
        self._LabelValuesSet = None

    @property
    def MetricName(self):
        """Metric name.
        :rtype: str
        """
        return self._MetricName

    @MetricName.setter
    def MetricName(self, MetricName):
        self._MetricName = MetricName

    @property
    def LabelValuesSet(self):
        """Labels and values.
        :rtype: list of LabelWithValues
        """
        return self._LabelValuesSet

    @LabelValuesSet.setter
    def LabelValuesSet(self, LabelValuesSet):
        self._LabelValuesSet = LabelValuesSet


    def _deserialize(self, params):
        self._MetricName = params.get("MetricName")
        if params.get("LabelValuesSet") is not None:
            self._LabelValuesSet = []
            for item in params.get("LabelValuesSet"):
                obj = LabelWithValues()
                obj._deserialize(item)
                self._LabelValuesSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NormalLog(AbstractModel):
    """General log struct.

    """

    def __init__(self):
        r"""
        :param _Timestamp: Timestamp in milliseconds.

Note: This field may return null, indicating that no valid value is found.
        :type Timestamp: str
        :param _SeverityText: Log level.

Note: This field may return null, indicating that no valid value is found.
        :type SeverityText: str
        :param _Body: Log output content.

Note: This field may return null, indicating that no valid value is found.
        :type Body: str
        """
        self._Timestamp = None
        self._SeverityText = None
        self._Body = None

    @property
    def Timestamp(self):
        """Timestamp in milliseconds.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Timestamp

    @Timestamp.setter
    def Timestamp(self, Timestamp):
        self._Timestamp = Timestamp

    @property
    def SeverityText(self):
        """Log level.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._SeverityText

    @SeverityText.setter
    def SeverityText(self, SeverityText):
        self._SeverityText = SeverityText

    @property
    def Body(self):
        """Log output content.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Body

    @Body.setter
    def Body(self, Body):
        self._Body = Body


    def _deserialize(self, params):
        self._Timestamp = params.get("Timestamp")
        self._SeverityText = params.get("SeverityText")
        self._Body = params.get("Body")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Notification(AbstractModel):
    """Message notification before and after job.

    """

    def __init__(self):
        r"""
        :param _Events: Event.
        :type Events: list of str
        :param _URL: Webhook URL.
        :type URL: str
        """
        self._Events = None
        self._URL = None

    @property
    def Events(self):
        """Event.
        :rtype: list of str
        """
        return self._Events

    @Events.setter
    def Events(self, Events):
        self._Events = Events

    @property
    def URL(self):
        """Webhook URL.
        :rtype: str
        """
        return self._URL

    @URL.setter
    def URL(self, URL):
        self._URL = URL


    def _deserialize(self, params):
        self._Events = params.get("Events")
        self._URL = params.get("URL")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NotificationHook(AbstractModel):
    """Event notification callback.

    """

    def __init__(self):
        r"""
        :param _Events: Event.

Note: This field may return null, indicating that no valid value is found.
        :type Events: list of str
        :param _URL: Callback URL.

Note: This field may return null, indicating that no valid value is found.
        :type URL: str
        """
        self._Events = None
        self._URL = None

    @property
    def Events(self):
        """Event.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of str
        """
        return self._Events

    @Events.setter
    def Events(self, Events):
        self._Events = Events

    @property
    def URL(self):
        """Callback URL.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._URL

    @URL.setter
    def URL(self, URL):
        self._URL = URL


    def _deserialize(self, params):
        self._Events = params.get("Events")
        self._URL = params.get("URL")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Project(AbstractModel):
    """Project.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID.
        :type ProjectId: str
        :param _Name: Project name.
        :type Name: str
        :param _Description: Project description.

Note: This field may return null, indicating that no valid value is found.
        :type Description: str
        :param _Tags: Tags.

Note: This field may return null, indicating that no valid value is found.
        :type Tags: list of TagSpec
        :param _Status: Project status.
        :type Status: int
        :param _CreatedAt: Create time.
        :type CreatedAt: str
        :param _UpdatedAt: Update time.
        :type UpdatedAt: str
        :param _AppId: App ID.
        :type AppId: int
        :param _Uin: Uin.
        :type Uin: str
        :param _SubAccountUin: Sub account uin.
        :type SubAccountUin: str
        """
        self._ProjectId = None
        self._Name = None
        self._Description = None
        self._Tags = None
        self._Status = None
        self._CreatedAt = None
        self._UpdatedAt = None
        self._AppId = None
        self._Uin = None
        self._SubAccountUin = None

    @property
    def ProjectId(self):
        """Project ID.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Name(self):
        """Project name.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Description(self):
        """Project description.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Tags(self):
        """Tags.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of TagSpec
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def Status(self):
        """Project status.
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def CreatedAt(self):
        """Create time.
        :rtype: str
        """
        return self._CreatedAt

    @CreatedAt.setter
    def CreatedAt(self, CreatedAt):
        self._CreatedAt = CreatedAt

    @property
    def UpdatedAt(self):
        """Update time.
        :rtype: str
        """
        return self._UpdatedAt

    @UpdatedAt.setter
    def UpdatedAt(self, UpdatedAt):
        self._UpdatedAt = UpdatedAt

    @property
    def AppId(self):
        """App ID.
        :rtype: int
        """
        return self._AppId

    @AppId.setter
    def AppId(self, AppId):
        self._AppId = AppId

    @property
    def Uin(self):
        """Uin.
        :rtype: str
        """
        return self._Uin

    @Uin.setter
    def Uin(self, Uin):
        self._Uin = Uin

    @property
    def SubAccountUin(self):
        """Sub account uin.
        :rtype: str
        """
        return self._SubAccountUin

    @SubAccountUin.setter
    def SubAccountUin(self, SubAccountUin):
        self._SubAccountUin = SubAccountUin


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._Name = params.get("Name")
        self._Description = params.get("Description")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = TagSpec()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._Status = params.get("Status")
        self._CreatedAt = params.get("CreatedAt")
        self._UpdatedAt = params.get("UpdatedAt")
        self._AppId = params.get("AppId")
        self._Uin = params.get("Uin")
        self._SubAccountUin = params.get("SubAccountUin")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ProtocolInfo(AbstractModel):
    """Protocol file information.

    """

    def __init__(self):
        r"""
        :param _Name: Name.

Note: This field may return null, indicating that no valid value is found.
        :type Name: str
        :param _Size: File size.

Note: This field may return null, indicating that no valid value is found.
        :type Size: int
        :param _Type: File type, such as 'proto'.

Note: This field may return null, indicating that no valid value is found.
        :type Type: str
        :param _UpdatedAt: Update time.

Note: This field may return null, indicating that no valid value is found.
        :type UpdatedAt: str
        :param _FileId: File ID.

Note: This field may return null, indicating that no valid value is found.
        :type FileId: str
        """
        self._Name = None
        self._Size = None
        self._Type = None
        self._UpdatedAt = None
        self._FileId = None

    @property
    def Name(self):
        """Name.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Size(self):
        """File size.

Note: This field may return null, indicating that no valid value is found.
        :rtype: int
        """
        return self._Size

    @Size.setter
    def Size(self, Size):
        self._Size = Size

    @property
    def Type(self):
        """File type, such as 'proto'.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def UpdatedAt(self):
        """Update time.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._UpdatedAt

    @UpdatedAt.setter
    def UpdatedAt(self, UpdatedAt):
        self._UpdatedAt = UpdatedAt

    @property
    def FileId(self):
        """File ID.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Size = params.get("Size")
        self._Type = params.get("Type")
        self._UpdatedAt = params.get("UpdatedAt")
        self._FileId = params.get("FileId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ReactionTimeRange(AbstractModel):
    """Log response time RT range.

    """

    def __init__(self):
        r"""
        :param _Min: Minimum response time (ms).
        :type Min: str
        :param _Max: Maximum response time (ms).
        :type Max: str
        """
        self._Min = None
        self._Max = None

    @property
    def Min(self):
        """Minimum response time (ms).
        :rtype: str
        """
        return self._Min

    @Min.setter
    def Min(self, Min):
        self._Min = Min

    @property
    def Max(self):
        """Maximum response time (ms).
        :rtype: str
        """
        return self._Max

    @Max.setter
    def Max(self, Max):
        self._Max = Max


    def _deserialize(self, params):
        self._Min = params.get("Min")
        self._Max = params.get("Max")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RegionDetail(AbstractModel):
    """Region.

    """

    def __init__(self):
        r"""
        :param _Region: Region code.
        :type Region: str
        :param _RegionId: Region ID.
        :type RegionId: int
        :param _Area: Area where the region is located.
        :type Area: str
        :param _RegionName: Region name.
        :type RegionName: str
        :param _RegionState: Region state.
        :type RegionState: int
        :param _RegionShortName: Region abbreviation.
        :type RegionShortName: str
        :param _CreatedAt: Create time.
        :type CreatedAt: str
        :param _UpdatedAt: Update time.
        :type UpdatedAt: str
        """
        self._Region = None
        self._RegionId = None
        self._Area = None
        self._RegionName = None
        self._RegionState = None
        self._RegionShortName = None
        self._CreatedAt = None
        self._UpdatedAt = None

    @property
    def Region(self):
        """Region code.
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def RegionId(self):
        """Region ID.
        :rtype: int
        """
        return self._RegionId

    @RegionId.setter
    def RegionId(self, RegionId):
        self._RegionId = RegionId

    @property
    def Area(self):
        """Area where the region is located.
        :rtype: str
        """
        return self._Area

    @Area.setter
    def Area(self, Area):
        self._Area = Area

    @property
    def RegionName(self):
        """Region name.
        :rtype: str
        """
        return self._RegionName

    @RegionName.setter
    def RegionName(self, RegionName):
        self._RegionName = RegionName

    @property
    def RegionState(self):
        """Region state.
        :rtype: int
        """
        return self._RegionState

    @RegionState.setter
    def RegionState(self, RegionState):
        self._RegionState = RegionState

    @property
    def RegionShortName(self):
        """Region abbreviation.
        :rtype: str
        """
        return self._RegionShortName

    @RegionShortName.setter
    def RegionShortName(self, RegionShortName):
        self._RegionShortName = RegionShortName

    @property
    def CreatedAt(self):
        """Create time.
        :rtype: str
        """
        return self._CreatedAt

    @CreatedAt.setter
    def CreatedAt(self, CreatedAt):
        self._CreatedAt = CreatedAt

    @property
    def UpdatedAt(self):
        """Update time.
        :rtype: str
        """
        return self._UpdatedAt

    @UpdatedAt.setter
    def UpdatedAt(self, UpdatedAt):
        self._UpdatedAt = UpdatedAt


    def _deserialize(self, params):
        self._Region = params.get("Region")
        self._RegionId = params.get("RegionId")
        self._Area = params.get("Area")
        self._RegionName = params.get("RegionName")
        self._RegionState = params.get("RegionState")
        self._RegionShortName = params.get("RegionShortName")
        self._CreatedAt = params.get("CreatedAt")
        self._UpdatedAt = params.get("UpdatedAt")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RequestSummary(AbstractModel):
    """Request details in performance test.

    """

    def __init__(self):
        r"""
        :param _Service: Request URL.
        :type Service: str
        :param _Method: Request method.
        :type Method: str
        :param _Count: Number of requests.
        :type Count: int
        :param _Average: Average request response time (seconds).
        :type Average: float
        :param _P90: Request p90 latency (seconds).
        :type P90: float
        :param _P95: Request p95 latency (seconds).
        :type P95: float
        :param _Min: Minimum request latency (seconds).
        :type Min: float
        :param _Max: Maximum request latency (seconds).
        :type Max: float
        :param _ErrorPercentage: Request error rate.
        :type ErrorPercentage: float
        :param _P99: Request p99 latency (seconds).
        :type P99: float
        :param _Status: Response status code.
        :type Status: str
        :param _Result: Response details.
        :type Result: str
        :param _RPS: Request per seconds, unit req/s.
        :type RPS: float
        """
        self._Service = None
        self._Method = None
        self._Count = None
        self._Average = None
        self._P90 = None
        self._P95 = None
        self._Min = None
        self._Max = None
        self._ErrorPercentage = None
        self._P99 = None
        self._Status = None
        self._Result = None
        self._RPS = None

    @property
    def Service(self):
        """Request URL.
        :rtype: str
        """
        return self._Service

    @Service.setter
    def Service(self, Service):
        self._Service = Service

    @property
    def Method(self):
        """Request method.
        :rtype: str
        """
        return self._Method

    @Method.setter
    def Method(self, Method):
        self._Method = Method

    @property
    def Count(self):
        """Number of requests.
        :rtype: int
        """
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def Average(self):
        """Average request response time (seconds).
        :rtype: float
        """
        return self._Average

    @Average.setter
    def Average(self, Average):
        self._Average = Average

    @property
    def P90(self):
        """Request p90 latency (seconds).
        :rtype: float
        """
        return self._P90

    @P90.setter
    def P90(self, P90):
        self._P90 = P90

    @property
    def P95(self):
        """Request p95 latency (seconds).
        :rtype: float
        """
        return self._P95

    @P95.setter
    def P95(self, P95):
        self._P95 = P95

    @property
    def Min(self):
        """Minimum request latency (seconds).
        :rtype: float
        """
        return self._Min

    @Min.setter
    def Min(self, Min):
        self._Min = Min

    @property
    def Max(self):
        """Maximum request latency (seconds).
        :rtype: float
        """
        return self._Max

    @Max.setter
    def Max(self, Max):
        self._Max = Max

    @property
    def ErrorPercentage(self):
        """Request error rate.
        :rtype: float
        """
        return self._ErrorPercentage

    @ErrorPercentage.setter
    def ErrorPercentage(self, ErrorPercentage):
        self._ErrorPercentage = ErrorPercentage

    @property
    def P99(self):
        """Request p99 latency (seconds).
        :rtype: float
        """
        return self._P99

    @P99.setter
    def P99(self, P99):
        self._P99 = P99

    @property
    def Status(self):
        """Response status code.
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Result(self):
        """Response details.
        :rtype: str
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RPS(self):
        """Request per seconds, unit req/s.
        :rtype: float
        """
        return self._RPS

    @RPS.setter
    def RPS(self, RPS):
        self._RPS = RPS


    def _deserialize(self, params):
        self._Service = params.get("Service")
        self._Method = params.get("Method")
        self._Count = params.get("Count")
        self._Average = params.get("Average")
        self._P90 = params.get("P90")
        self._P95 = params.get("P95")
        self._Min = params.get("Min")
        self._Max = params.get("Max")
        self._ErrorPercentage = params.get("ErrorPercentage")
        self._P99 = params.get("P99")
        self._Status = params.get("Status")
        self._Result = params.get("Result")
        self._RPS = params.get("RPS")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RequestsPerSecond(AbstractModel):
    """Load configuration for RPS mode.

    """

    def __init__(self):
        r"""
        :param _MaxRequestsPerSecond: Maximum rps.

Note: This field may return null, indicating that no valid value is found.
        :type MaxRequestsPerSecond: int
        :param _DurationSeconds: Duration time.

Note: This field may return null, indicating that no valid value is found.
        :type DurationSeconds: int
        :param _TargetVirtualUsers: Deprecated.

Note: This field may return null, indicating that no valid value is found.
        :type TargetVirtualUsers: int
        :param _Resources: Number of resources.

Note: This field may return null, indicating that no valid value is found.
        :type Resources: int
        :param _StartRequestsPerSecond: Initial rps.

Note: This field may return null, indicating that no valid value is found.
        :type StartRequestsPerSecond: int
        :param _TargetRequestsPerSecond: Target rps, invalid as an input parameter.

Note: This field may return null, indicating that no valid value is found.
        :type TargetRequestsPerSecond: int
        :param _GracefulStopSeconds: Graceful shutdown waiting time.

Note: This field may return null, indicating that no valid value is found.
        :type GracefulStopSeconds: int
        """
        self._MaxRequestsPerSecond = None
        self._DurationSeconds = None
        self._TargetVirtualUsers = None
        self._Resources = None
        self._StartRequestsPerSecond = None
        self._TargetRequestsPerSecond = None
        self._GracefulStopSeconds = None

    @property
    def MaxRequestsPerSecond(self):
        """Maximum rps.

Note: This field may return null, indicating that no valid value is found.
        :rtype: int
        """
        return self._MaxRequestsPerSecond

    @MaxRequestsPerSecond.setter
    def MaxRequestsPerSecond(self, MaxRequestsPerSecond):
        self._MaxRequestsPerSecond = MaxRequestsPerSecond

    @property
    def DurationSeconds(self):
        """Duration time.

Note: This field may return null, indicating that no valid value is found.
        :rtype: int
        """
        return self._DurationSeconds

    @DurationSeconds.setter
    def DurationSeconds(self, DurationSeconds):
        self._DurationSeconds = DurationSeconds

    @property
    def TargetVirtualUsers(self):
        """Deprecated.

Note: This field may return null, indicating that no valid value is found.
        :rtype: int
        """
        return self._TargetVirtualUsers

    @TargetVirtualUsers.setter
    def TargetVirtualUsers(self, TargetVirtualUsers):
        self._TargetVirtualUsers = TargetVirtualUsers

    @property
    def Resources(self):
        """Number of resources.

Note: This field may return null, indicating that no valid value is found.
        :rtype: int
        """
        return self._Resources

    @Resources.setter
    def Resources(self, Resources):
        self._Resources = Resources

    @property
    def StartRequestsPerSecond(self):
        """Initial rps.

Note: This field may return null, indicating that no valid value is found.
        :rtype: int
        """
        return self._StartRequestsPerSecond

    @StartRequestsPerSecond.setter
    def StartRequestsPerSecond(self, StartRequestsPerSecond):
        self._StartRequestsPerSecond = StartRequestsPerSecond

    @property
    def TargetRequestsPerSecond(self):
        """Target rps, invalid as an input parameter.

Note: This field may return null, indicating that no valid value is found.
        :rtype: int
        """
        return self._TargetRequestsPerSecond

    @TargetRequestsPerSecond.setter
    def TargetRequestsPerSecond(self, TargetRequestsPerSecond):
        self._TargetRequestsPerSecond = TargetRequestsPerSecond

    @property
    def GracefulStopSeconds(self):
        """Graceful shutdown waiting time.

Note: This field may return null, indicating that no valid value is found.
        :rtype: int
        """
        return self._GracefulStopSeconds

    @GracefulStopSeconds.setter
    def GracefulStopSeconds(self, GracefulStopSeconds):
        self._GracefulStopSeconds = GracefulStopSeconds


    def _deserialize(self, params):
        self._MaxRequestsPerSecond = params.get("MaxRequestsPerSecond")
        self._DurationSeconds = params.get("DurationSeconds")
        self._TargetVirtualUsers = params.get("TargetVirtualUsers")
        self._Resources = params.get("Resources")
        self._StartRequestsPerSecond = params.get("StartRequestsPerSecond")
        self._TargetRequestsPerSecond = params.get("TargetRequestsPerSecond")
        self._GracefulStopSeconds = params.get("GracefulStopSeconds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RestartCronJobsRequest(AbstractModel):
    """RestartCronJobs request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID.
        :type ProjectId: str
        :param _CronJobIds: Array of cron job ID.
        :type CronJobIds: list of str
        """
        self._ProjectId = None
        self._CronJobIds = None

    @property
    def ProjectId(self):
        """Project ID.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def CronJobIds(self):
        """Array of cron job ID.
        :rtype: list of str
        """
        return self._CronJobIds

    @CronJobIds.setter
    def CronJobIds(self, CronJobIds):
        self._CronJobIds = CronJobIds


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._CronJobIds = params.get("CronJobIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RestartCronJobsResponse(AbstractModel):
    """RestartCronJobs response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class SLALabel(AbstractModel):
    """SLA label.

    """

    def __init__(self):
        r"""
        :param _LabelName: Label name.

Note: This field may return null, indicating that no valid value is found.
        :type LabelName: str
        :param _LabelValue: Label value.

Note: This field may return null, indicating that no valid value is found.
        :type LabelValue: str
        """
        self._LabelName = None
        self._LabelValue = None

    @property
    def LabelName(self):
        """Label name.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._LabelName

    @LabelName.setter
    def LabelName(self, LabelName):
        self._LabelName = LabelName

    @property
    def LabelValue(self):
        """Label value.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._LabelValue

    @LabelValue.setter
    def LabelValue(self, LabelValue):
        self._LabelValue = LabelValue


    def _deserialize(self, params):
        self._LabelName = params.get("LabelName")
        self._LabelValue = params.get("LabelValue")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SLAPolicy(AbstractModel):
    """SLA policy.

    """

    def __init__(self):
        r"""
        :param _SLARules: SLA rules.

Note: This field may return null, indicating that no valid value is found.
        :type SLARules: list of SLARule
        :param _AlertChannel: Alert notification channel.

Note: This field may return null, indicating that no valid value is found.
        :type AlertChannel: :class:`tencentcloud.pts.v20210728.models.AlertChannel`
        """
        self._SLARules = None
        self._AlertChannel = None

    @property
    def SLARules(self):
        """SLA rules.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of SLARule
        """
        return self._SLARules

    @SLARules.setter
    def SLARules(self, SLARules):
        self._SLARules = SLARules

    @property
    def AlertChannel(self):
        """Alert notification channel.

Note: This field may return null, indicating that no valid value is found.
        :rtype: :class:`tencentcloud.pts.v20210728.models.AlertChannel`
        """
        return self._AlertChannel

    @AlertChannel.setter
    def AlertChannel(self, AlertChannel):
        self._AlertChannel = AlertChannel


    def _deserialize(self, params):
        if params.get("SLARules") is not None:
            self._SLARules = []
            for item in params.get("SLARules"):
                obj = SLARule()
                obj._deserialize(item)
                self._SLARules.append(obj)
        if params.get("AlertChannel") is not None:
            self._AlertChannel = AlertChannel()
            self._AlertChannel._deserialize(params.get("AlertChannel"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SLARule(AbstractModel):
    """SLA rule.

    """

    def __init__(self):
        r"""
        :param _Metric: Metric.

Note: This field may return null, indicating that no valid value is found.
        :type Metric: str
        :param _Aggregation: Metric aggregation method.

Note: This field may return null, indicating that no valid value is found.
        :type Aggregation: str
        :param _Condition: Condition, such as '==' '!=' '<' '<=' '>' '>='.

Note: This field may return null, indicating that no valid value is found.
        :type Condition: str
        :param _Value: Threshold value.

Note: This field may return null, indicating that no valid value is found.
        :type Value: float
        :param _LabelFilter: Label.

Note: This field may return null, indicating that no valid value is found.
        :type LabelFilter: list of SLALabel
        :param _AbortFlag: Whether to stop performance test job.

Note: This field may return null, indicating that no valid value is found.
        :type AbortFlag: bool
        :param _For: Duration.

Note: This field may return null, indicating that no valid value is found.
        :type For: str
        """
        self._Metric = None
        self._Aggregation = None
        self._Condition = None
        self._Value = None
        self._LabelFilter = None
        self._AbortFlag = None
        self._For = None

    @property
    def Metric(self):
        """Metric.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Metric

    @Metric.setter
    def Metric(self, Metric):
        self._Metric = Metric

    @property
    def Aggregation(self):
        """Metric aggregation method.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Aggregation

    @Aggregation.setter
    def Aggregation(self, Aggregation):
        self._Aggregation = Aggregation

    @property
    def Condition(self):
        """Condition, such as '==' '!=' '<' '<=' '>' '>='.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Condition

    @Condition.setter
    def Condition(self, Condition):
        self._Condition = Condition

    @property
    def Value(self):
        """Threshold value.

Note: This field may return null, indicating that no valid value is found.
        :rtype: float
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value

    @property
    def LabelFilter(self):
        """Label.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of SLALabel
        """
        return self._LabelFilter

    @LabelFilter.setter
    def LabelFilter(self, LabelFilter):
        self._LabelFilter = LabelFilter

    @property
    def AbortFlag(self):
        """Whether to stop performance test job.

Note: This field may return null, indicating that no valid value is found.
        :rtype: bool
        """
        return self._AbortFlag

    @AbortFlag.setter
    def AbortFlag(self, AbortFlag):
        self._AbortFlag = AbortFlag

    @property
    def For(self):
        """Duration.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._For

    @For.setter
    def For(self, For):
        self._For = For


    def _deserialize(self, params):
        self._Metric = params.get("Metric")
        self._Aggregation = params.get("Aggregation")
        self._Condition = params.get("Condition")
        self._Value = params.get("Value")
        if params.get("LabelFilter") is not None:
            self._LabelFilter = []
            for item in params.get("LabelFilter"):
                obj = SLALabel()
                obj._deserialize(item)
                self._LabelFilter.append(obj)
        self._AbortFlag = params.get("AbortFlag")
        self._For = params.get("For")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SampleLog(AbstractModel):
    """Sampled request logs.

    """

    def __init__(self):
        r"""
        :param _Timestamp: Millisecond timestamp.

Note: This field may return null, indicating that no valid value is found.
        :type Timestamp: str
        :param _Attributes: Log attributes.

Note: This field may return null, indicating that no valid value is found.
        :type Attributes: :class:`tencentcloud.pts.v20210728.models.Attributes`
        :param _Body: Request in har format in log.

Note: This field may return null, indicating that no valid value is found.
        :type Body: str
        """
        self._Timestamp = None
        self._Attributes = None
        self._Body = None

    @property
    def Timestamp(self):
        """Millisecond timestamp.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Timestamp

    @Timestamp.setter
    def Timestamp(self, Timestamp):
        self._Timestamp = Timestamp

    @property
    def Attributes(self):
        """Log attributes.

Note: This field may return null, indicating that no valid value is found.
        :rtype: :class:`tencentcloud.pts.v20210728.models.Attributes`
        """
        return self._Attributes

    @Attributes.setter
    def Attributes(self, Attributes):
        self._Attributes = Attributes

    @property
    def Body(self):
        """Request in har format in log.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Body

    @Body.setter
    def Body(self, Body):
        self._Body = Body


    def _deserialize(self, params):
        self._Timestamp = params.get("Timestamp")
        if params.get("Attributes") is not None:
            self._Attributes = Attributes()
            self._Attributes._deserialize(params.get("Attributes"))
        self._Body = params.get("Body")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SamplePair(AbstractModel):
    """Metric sample value with timestamp.

    """

    def __init__(self):
        r"""
        :param _Timestamp: Timestamp. It is the number of milliseconds since the epoch (1970-01-01 00:00 UTC) excluding leap seconds.
        :type Timestamp: int
        :param _Value: Value of a given sample at a given time.
        :type Value: float
        """
        self._Timestamp = None
        self._Value = None

    @property
    def Timestamp(self):
        """Timestamp. It is the number of milliseconds since the epoch (1970-01-01 00:00 UTC) excluding leap seconds.
        :rtype: int
        """
        return self._Timestamp

    @Timestamp.setter
    def Timestamp(self, Timestamp):
        self._Timestamp = Timestamp

    @property
    def Value(self):
        """Value of a given sample at a given time.
        :rtype: float
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value


    def _deserialize(self, params):
        self._Timestamp = params.get("Timestamp")
        self._Value = params.get("Value")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SampleStream(AbstractModel):
    """Stream of values belonging to a metric.

    """

    def __init__(self):
        r"""
        :param _Labels: Metric labels.

Note: This field may return null, indicating that no valid value is found.
        :type Labels: list of Label
        :param _Values: Array of metric values.
        :type Values: list of SamplePair
        :param _Name: Metric name.

Note: This field may return null, indicating that no valid value is found.
        :type Name: str
        """
        self._Labels = None
        self._Values = None
        self._Name = None

    @property
    def Labels(self):
        """Metric labels.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of Label
        """
        return self._Labels

    @Labels.setter
    def Labels(self, Labels):
        self._Labels = Labels

    @property
    def Values(self):
        """Array of metric values.
        :rtype: list of SamplePair
        """
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values

    @property
    def Name(self):
        """Metric name.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        if params.get("Labels") is not None:
            self._Labels = []
            for item in params.get("Labels"):
                obj = Label()
                obj._deserialize(item)
                self._Labels.append(obj)
        if params.get("Values") is not None:
            self._Values = []
            for item in params.get("Values"):
                obj = SamplePair()
                obj._deserialize(item)
                self._Values.append(obj)
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Scenario(AbstractModel):
    """Performance test scenario.

    """

    def __init__(self):
        r"""
        :param _ScenarioId: Scenario ID.
        :type ScenarioId: str
        :param _Name: Scenario name.
        :type Name: str
        :param _Description: Scenario description.

Note: This field may return null, indicating that no valid value is found.
        :type Description: str
        :param _Type: Type of scenario. Valid values: 'pts-http' represents the simple mode, 'pts-js' represents the script mode, 'pts-jmeter' represents the JMeter mode.

Note: This field may return null, indicating that no valid value is found.
        :type Type: str
        :param _Status: Scenario status.

Note: This field may return null, indicating that no valid value is found.
        :type Status: int
        :param _Load: Load configuration.

Note: This field may return null, indicating that no valid value is found.
        :type Load: :class:`tencentcloud.pts.v20210728.models.Load`
        :param _EncodedScripts: Deprecated.

Note: This field may return null, indicating that no valid value is found.
        :type EncodedScripts: str
        :param _Configs: Deprecated.

Note: This field may return null, indicating that no valid value is found.
        :type Configs: list of str
        :param _Extensions: Deprecated.

Note: This field may return null, indicating that no valid value is found.
        :type Extensions: list of str
        :param _Datasets: Test datasets.

Note: This field may return null, indicating that no valid value is found.
        :type Datasets: list of TestData
        :param _SLAId: Deprecated.

Note: This field may return null, indicating that no valid value is found.
        :type SLAId: str
        :param _CronId: CronJob ID.

Note: This field may return null, indicating that no valid value is found.
        :type CronId: str
        :param _CreatedAt: Create time.
        :type CreatedAt: str
        :param _UpdatedAt: Update time.
        :type UpdatedAt: str
        :param _ProjectId: Project ID.

Note: This field may return null, indicating that no valid value is found.
        :type ProjectId: str
        :param _AppId: App ID.

Note: This field may return null, indicating that no valid value is found.
        :type AppId: int
        :param _Uin: Uin.

Note: This field may return null, indicating that no valid value is found.
        :type Uin: str
        :param _SubAccountUin: Sub account uin.

Note: This field may return null, indicating that no valid value is found.
        :type SubAccountUin: str
        :param _TestScripts: Test scripts.

Note: This field may return null, indicating that no valid value is found.
        :type TestScripts: list of ScriptInfo
        :param _Protocols: Protocol files.

Note: This field may return null, indicating that no valid value is found.
        :type Protocols: list of ProtocolInfo
        :param _RequestFiles: Request files.

Note: This field may return null, indicating that no valid value is found.
        :type RequestFiles: list of FileInfo
        :param _SLAPolicy: SLA policy.

Note: This field may return null, indicating that no valid value is found.
        :type SLAPolicy: :class:`tencentcloud.pts.v20210728.models.SLAPolicy`
        :param _Plugins: Extension plugin files.

Note: This field may return null, indicating that no valid value is found.
        :type Plugins: list of FileInfo
        :param _DomainNameConfig: Domain name resolution configuration.

Note: This field may return null, indicating that no valid value is found.
        :type DomainNameConfig: :class:`tencentcloud.pts.v20210728.models.DomainNameConfig`
        :param _NotificationHooks: Notification event hooks.

Note: This field may return null, indicating that no valid value is found.
        :type NotificationHooks: list of NotificationHook
        :param _Owner: Creator name.

Note: This field may return null, indicating that no valid value is found.
        :type Owner: str
        :param _ProjectName: Project name.

Note: This field may return null, indicating that no valid value is found.
        :type ProjectName: str
        """
        self._ScenarioId = None
        self._Name = None
        self._Description = None
        self._Type = None
        self._Status = None
        self._Load = None
        self._EncodedScripts = None
        self._Configs = None
        self._Extensions = None
        self._Datasets = None
        self._SLAId = None
        self._CronId = None
        self._CreatedAt = None
        self._UpdatedAt = None
        self._ProjectId = None
        self._AppId = None
        self._Uin = None
        self._SubAccountUin = None
        self._TestScripts = None
        self._Protocols = None
        self._RequestFiles = None
        self._SLAPolicy = None
        self._Plugins = None
        self._DomainNameConfig = None
        self._NotificationHooks = None
        self._Owner = None
        self._ProjectName = None

    @property
    def ScenarioId(self):
        """Scenario ID.
        :rtype: str
        """
        return self._ScenarioId

    @ScenarioId.setter
    def ScenarioId(self, ScenarioId):
        self._ScenarioId = ScenarioId

    @property
    def Name(self):
        """Scenario name.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Description(self):
        """Scenario description.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Type(self):
        """Type of scenario. Valid values: 'pts-http' represents the simple mode, 'pts-js' represents the script mode, 'pts-jmeter' represents the JMeter mode.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Status(self):
        """Scenario status.

Note: This field may return null, indicating that no valid value is found.
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Load(self):
        """Load configuration.

Note: This field may return null, indicating that no valid value is found.
        :rtype: :class:`tencentcloud.pts.v20210728.models.Load`
        """
        return self._Load

    @Load.setter
    def Load(self, Load):
        self._Load = Load

    @property
    def EncodedScripts(self):
        """Deprecated.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._EncodedScripts

    @EncodedScripts.setter
    def EncodedScripts(self, EncodedScripts):
        self._EncodedScripts = EncodedScripts

    @property
    def Configs(self):
        """Deprecated.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of str
        """
        return self._Configs

    @Configs.setter
    def Configs(self, Configs):
        self._Configs = Configs

    @property
    def Extensions(self):
        """Deprecated.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of str
        """
        return self._Extensions

    @Extensions.setter
    def Extensions(self, Extensions):
        self._Extensions = Extensions

    @property
    def Datasets(self):
        """Test datasets.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of TestData
        """
        return self._Datasets

    @Datasets.setter
    def Datasets(self, Datasets):
        self._Datasets = Datasets

    @property
    def SLAId(self):
        """Deprecated.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._SLAId

    @SLAId.setter
    def SLAId(self, SLAId):
        self._SLAId = SLAId

    @property
    def CronId(self):
        """CronJob ID.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._CronId

    @CronId.setter
    def CronId(self, CronId):
        self._CronId = CronId

    @property
    def CreatedAt(self):
        """Create time.
        :rtype: str
        """
        return self._CreatedAt

    @CreatedAt.setter
    def CreatedAt(self, CreatedAt):
        self._CreatedAt = CreatedAt

    @property
    def UpdatedAt(self):
        """Update time.
        :rtype: str
        """
        return self._UpdatedAt

    @UpdatedAt.setter
    def UpdatedAt(self, UpdatedAt):
        self._UpdatedAt = UpdatedAt

    @property
    def ProjectId(self):
        """Project ID.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def AppId(self):
        """App ID.

Note: This field may return null, indicating that no valid value is found.
        :rtype: int
        """
        return self._AppId

    @AppId.setter
    def AppId(self, AppId):
        self._AppId = AppId

    @property
    def Uin(self):
        """Uin.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Uin

    @Uin.setter
    def Uin(self, Uin):
        self._Uin = Uin

    @property
    def SubAccountUin(self):
        """Sub account uin.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._SubAccountUin

    @SubAccountUin.setter
    def SubAccountUin(self, SubAccountUin):
        self._SubAccountUin = SubAccountUin

    @property
    def TestScripts(self):
        """Test scripts.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of ScriptInfo
        """
        return self._TestScripts

    @TestScripts.setter
    def TestScripts(self, TestScripts):
        self._TestScripts = TestScripts

    @property
    def Protocols(self):
        """Protocol files.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of ProtocolInfo
        """
        return self._Protocols

    @Protocols.setter
    def Protocols(self, Protocols):
        self._Protocols = Protocols

    @property
    def RequestFiles(self):
        """Request files.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of FileInfo
        """
        return self._RequestFiles

    @RequestFiles.setter
    def RequestFiles(self, RequestFiles):
        self._RequestFiles = RequestFiles

    @property
    def SLAPolicy(self):
        """SLA policy.

Note: This field may return null, indicating that no valid value is found.
        :rtype: :class:`tencentcloud.pts.v20210728.models.SLAPolicy`
        """
        return self._SLAPolicy

    @SLAPolicy.setter
    def SLAPolicy(self, SLAPolicy):
        self._SLAPolicy = SLAPolicy

    @property
    def Plugins(self):
        """Extension plugin files.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of FileInfo
        """
        return self._Plugins

    @Plugins.setter
    def Plugins(self, Plugins):
        self._Plugins = Plugins

    @property
    def DomainNameConfig(self):
        """Domain name resolution configuration.

Note: This field may return null, indicating that no valid value is found.
        :rtype: :class:`tencentcloud.pts.v20210728.models.DomainNameConfig`
        """
        return self._DomainNameConfig

    @DomainNameConfig.setter
    def DomainNameConfig(self, DomainNameConfig):
        self._DomainNameConfig = DomainNameConfig

    @property
    def NotificationHooks(self):
        """Notification event hooks.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of NotificationHook
        """
        return self._NotificationHooks

    @NotificationHooks.setter
    def NotificationHooks(self, NotificationHooks):
        self._NotificationHooks = NotificationHooks

    @property
    def Owner(self):
        """Creator name.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Owner

    @Owner.setter
    def Owner(self, Owner):
        self._Owner = Owner

    @property
    def ProjectName(self):
        """Project name.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._ProjectName

    @ProjectName.setter
    def ProjectName(self, ProjectName):
        self._ProjectName = ProjectName


    def _deserialize(self, params):
        self._ScenarioId = params.get("ScenarioId")
        self._Name = params.get("Name")
        self._Description = params.get("Description")
        self._Type = params.get("Type")
        self._Status = params.get("Status")
        if params.get("Load") is not None:
            self._Load = Load()
            self._Load._deserialize(params.get("Load"))
        self._EncodedScripts = params.get("EncodedScripts")
        self._Configs = params.get("Configs")
        self._Extensions = params.get("Extensions")
        if params.get("Datasets") is not None:
            self._Datasets = []
            for item in params.get("Datasets"):
                obj = TestData()
                obj._deserialize(item)
                self._Datasets.append(obj)
        self._SLAId = params.get("SLAId")
        self._CronId = params.get("CronId")
        self._CreatedAt = params.get("CreatedAt")
        self._UpdatedAt = params.get("UpdatedAt")
        self._ProjectId = params.get("ProjectId")
        self._AppId = params.get("AppId")
        self._Uin = params.get("Uin")
        self._SubAccountUin = params.get("SubAccountUin")
        if params.get("TestScripts") is not None:
            self._TestScripts = []
            for item in params.get("TestScripts"):
                obj = ScriptInfo()
                obj._deserialize(item)
                self._TestScripts.append(obj)
        if params.get("Protocols") is not None:
            self._Protocols = []
            for item in params.get("Protocols"):
                obj = ProtocolInfo()
                obj._deserialize(item)
                self._Protocols.append(obj)
        if params.get("RequestFiles") is not None:
            self._RequestFiles = []
            for item in params.get("RequestFiles"):
                obj = FileInfo()
                obj._deserialize(item)
                self._RequestFiles.append(obj)
        if params.get("SLAPolicy") is not None:
            self._SLAPolicy = SLAPolicy()
            self._SLAPolicy._deserialize(params.get("SLAPolicy"))
        if params.get("Plugins") is not None:
            self._Plugins = []
            for item in params.get("Plugins"):
                obj = FileInfo()
                obj._deserialize(item)
                self._Plugins.append(obj)
        if params.get("DomainNameConfig") is not None:
            self._DomainNameConfig = DomainNameConfig()
            self._DomainNameConfig._deserialize(params.get("DomainNameConfig"))
        if params.get("NotificationHooks") is not None:
            self._NotificationHooks = []
            for item in params.get("NotificationHooks"):
                obj = NotificationHook()
                obj._deserialize(item)
                self._NotificationHooks.append(obj)
        self._Owner = params.get("Owner")
        self._ProjectName = params.get("ProjectName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ScenarioRelatedJobsParams(AbstractModel):
    """Parameters for querying jobs associated with a specific scenario.

    """

    def __init__(self):
        r"""
        :param _Offset: Offset, default value is 0.
        :type Offset: int
        :param _Limit: Number of returns. Default value is 20, maximum is 100.
        :type Limit: int
        :param _OrderBy: Field for sorting.
        :type OrderBy: str
        :param _Ascend: Whether in ascending order.
        :type Ascend: bool
        """
        self._Offset = None
        self._Limit = None
        self._OrderBy = None
        self._Ascend = None

    @property
    def Offset(self):
        """Offset, default value is 0.
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """Number of returns. Default value is 20, maximum is 100.
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def OrderBy(self):
        """Field for sorting.
        :rtype: str
        """
        return self._OrderBy

    @OrderBy.setter
    def OrderBy(self, OrderBy):
        self._OrderBy = OrderBy

    @property
    def Ascend(self):
        """Whether in ascending order.
        :rtype: bool
        """
        return self._Ascend

    @Ascend.setter
    def Ascend(self, Ascend):
        self._Ascend = Ascend


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._OrderBy = params.get("OrderBy")
        self._Ascend = params.get("Ascend")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ScenarioWithJobs(AbstractModel):
    """Scenario with jobs.

    """

    def __init__(self):
        r"""
        :param _Scenario: Scenario.

Note: This field may return null, indicating that no valid value is found.
        :type Scenario: :class:`tencentcloud.pts.v20210728.models.Scenario`
        :param _Jobs: Job list.

Note: This field may return null, indicating that no valid value is found.
        :type Jobs: list of Job
        """
        self._Scenario = None
        self._Jobs = None

    @property
    def Scenario(self):
        """Scenario.

Note: This field may return null, indicating that no valid value is found.
        :rtype: :class:`tencentcloud.pts.v20210728.models.Scenario`
        """
        return self._Scenario

    @Scenario.setter
    def Scenario(self, Scenario):
        self._Scenario = Scenario

    @property
    def Jobs(self):
        """Job list.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of Job
        """
        return self._Jobs

    @Jobs.setter
    def Jobs(self, Jobs):
        self._Jobs = Jobs


    def _deserialize(self, params):
        if params.get("Scenario") is not None:
            self._Scenario = Scenario()
            self._Scenario._deserialize(params.get("Scenario"))
        if params.get("Jobs") is not None:
            self._Jobs = []
            for item in params.get("Jobs"):
                obj = Job()
                obj._deserialize(item)
                self._Jobs.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ScriptInfo(AbstractModel):
    """Performance test script information.

    """

    def __init__(self):
        r"""
        :param _Name: Filename.

Note: This field may return null, indicating that no valid value is found.
        :type Name: str
        :param _Size: File size.

Note: This field may return null, indicating that no valid value is found.
        :type Size: int
        :param _Type: File type.

Note: This field may return null, indicating that no valid value is found.
        :type Type: str
        :param _UpdatedAt: Update time.

Note: This field may return null, indicating that no valid value is found.
        :type UpdatedAt: str
        :param _EncodedContent: Base64-encoded file content.

Note: This field may return null, indicating that no valid value is found.
        :type EncodedContent: str
        :param _EncodedHttpArchive: Base64-encoded har structure.

Note: This field may return null, indicating that no valid value is found.
        :type EncodedHttpArchive: str
        :param _LoadWeight: Script weight, range 1-100.

Note: This field may return null, indicating that no valid value is found.
        :type LoadWeight: int
        :param _FileId: File ID.

Note: This field may return null, indicating that no valid value is found.
        :type FileId: str
        """
        self._Name = None
        self._Size = None
        self._Type = None
        self._UpdatedAt = None
        self._EncodedContent = None
        self._EncodedHttpArchive = None
        self._LoadWeight = None
        self._FileId = None

    @property
    def Name(self):
        """Filename.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Size(self):
        """File size.

Note: This field may return null, indicating that no valid value is found.
        :rtype: int
        """
        return self._Size

    @Size.setter
    def Size(self, Size):
        self._Size = Size

    @property
    def Type(self):
        """File type.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def UpdatedAt(self):
        """Update time.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._UpdatedAt

    @UpdatedAt.setter
    def UpdatedAt(self, UpdatedAt):
        self._UpdatedAt = UpdatedAt

    @property
    def EncodedContent(self):
        """Base64-encoded file content.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._EncodedContent

    @EncodedContent.setter
    def EncodedContent(self, EncodedContent):
        self._EncodedContent = EncodedContent

    @property
    def EncodedHttpArchive(self):
        """Base64-encoded har structure.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._EncodedHttpArchive

    @EncodedHttpArchive.setter
    def EncodedHttpArchive(self, EncodedHttpArchive):
        self._EncodedHttpArchive = EncodedHttpArchive

    @property
    def LoadWeight(self):
        """Script weight, range 1-100.

Note: This field may return null, indicating that no valid value is found.
        :rtype: int
        """
        return self._LoadWeight

    @LoadWeight.setter
    def LoadWeight(self, LoadWeight):
        self._LoadWeight = LoadWeight

    @property
    def FileId(self):
        """File ID.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Size = params.get("Size")
        self._Type = params.get("Type")
        self._UpdatedAt = params.get("UpdatedAt")
        self._EncodedContent = params.get("EncodedContent")
        self._EncodedHttpArchive = params.get("EncodedHttpArchive")
        self._LoadWeight = params.get("LoadWeight")
        self._FileId = params.get("FileId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ScriptOrigin(AbstractModel):
    """Built-in script load model, not supported currently.

    """

    def __init__(self):
        r"""
        :param _MachineNumber: Machine number.
        :type MachineNumber: int
        :param _MachineSpecification: Machine specification.
        :type MachineSpecification: str
        :param _DurationSeconds: Duration.
        :type DurationSeconds: int
        """
        self._MachineNumber = None
        self._MachineSpecification = None
        self._DurationSeconds = None

    @property
    def MachineNumber(self):
        """Machine number.
        :rtype: int
        """
        return self._MachineNumber

    @MachineNumber.setter
    def MachineNumber(self, MachineNumber):
        self._MachineNumber = MachineNumber

    @property
    def MachineSpecification(self):
        """Machine specification.
        :rtype: str
        """
        return self._MachineSpecification

    @MachineSpecification.setter
    def MachineSpecification(self, MachineSpecification):
        self._MachineSpecification = MachineSpecification

    @property
    def DurationSeconds(self):
        """Duration.
        :rtype: int
        """
        return self._DurationSeconds

    @DurationSeconds.setter
    def DurationSeconds(self, DurationSeconds):
        self._DurationSeconds = DurationSeconds


    def _deserialize(self, params):
        self._MachineNumber = params.get("MachineNumber")
        self._MachineSpecification = params.get("MachineSpecification")
        self._DurationSeconds = params.get("DurationSeconds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Stage(AbstractModel):
    """Load configuration for a single stage in concurrency mode

    """

    def __init__(self):
        r"""
        :param _DurationSeconds: Duration time of this stage.

Note: This field may return null, indicating that no valid value is found.
        :type DurationSeconds: int
        :param _TargetVirtualUsers: Target number of virtual users.

Note: This field may return null, indicating that no valid value is found.
        :type TargetVirtualUsers: int
        """
        self._DurationSeconds = None
        self._TargetVirtualUsers = None

    @property
    def DurationSeconds(self):
        """Duration time of this stage.

Note: This field may return null, indicating that no valid value is found.
        :rtype: int
        """
        return self._DurationSeconds

    @DurationSeconds.setter
    def DurationSeconds(self, DurationSeconds):
        self._DurationSeconds = DurationSeconds

    @property
    def TargetVirtualUsers(self):
        """Target number of virtual users.

Note: This field may return null, indicating that no valid value is found.
        :rtype: int
        """
        return self._TargetVirtualUsers

    @TargetVirtualUsers.setter
    def TargetVirtualUsers(self, TargetVirtualUsers):
        self._TargetVirtualUsers = TargetVirtualUsers


    def _deserialize(self, params):
        self._DurationSeconds = params.get("DurationSeconds")
        self._TargetVirtualUsers = params.get("TargetVirtualUsers")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class StartJobRequest(AbstractModel):
    """StartJob request structure.

    """

    def __init__(self):
        r"""
        :param _ScenarioId: Scenario ID.
        :type ScenarioId: str
        :param _JobOwner: Job initiator.
        :type JobOwner: str
        :param _ProjectId: Project ID.
        :type ProjectId: str
        :param _Debug: If is debug mode.
        :type Debug: bool
        :param _Note: Note.
        :type Note: str
        """
        self._ScenarioId = None
        self._JobOwner = None
        self._ProjectId = None
        self._Debug = None
        self._Note = None

    @property
    def ScenarioId(self):
        """Scenario ID.
        :rtype: str
        """
        return self._ScenarioId

    @ScenarioId.setter
    def ScenarioId(self, ScenarioId):
        self._ScenarioId = ScenarioId

    @property
    def JobOwner(self):
        """Job initiator.
        :rtype: str
        """
        return self._JobOwner

    @JobOwner.setter
    def JobOwner(self, JobOwner):
        self._JobOwner = JobOwner

    @property
    def ProjectId(self):
        """Project ID.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Debug(self):
        """If is debug mode.
        :rtype: bool
        """
        return self._Debug

    @Debug.setter
    def Debug(self, Debug):
        self._Debug = Debug

    @property
    def Note(self):
        """Note.
        :rtype: str
        """
        return self._Note

    @Note.setter
    def Note(self, Note):
        self._Note = Note


    def _deserialize(self, params):
        self._ScenarioId = params.get("ScenarioId")
        self._JobOwner = params.get("JobOwner")
        self._ProjectId = params.get("ProjectId")
        self._Debug = params.get("Debug")
        self._Note = params.get("Note")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class StartJobResponse(AbstractModel):
    """StartJob response structure.

    """

    def __init__(self):
        r"""
        :param _JobId: Job ID.
        :type JobId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._JobId = None
        self._RequestId = None

    @property
    def JobId(self):
        """Job ID.
        :rtype: str
        """
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class TagSpec(AbstractModel):
    """Tag.

    """

    def __init__(self):
        r"""
        :param _TagKey: Tag key.

Note: This field may return null, indicating that no valid value is found.
        :type TagKey: str
        :param _TagValue: Tag value.

Note: This field may return null, indicating that no valid value is found.
        :type TagValue: str
        """
        self._TagKey = None
        self._TagValue = None

    @property
    def TagKey(self):
        """Tag key.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._TagKey

    @TagKey.setter
    def TagKey(self, TagKey):
        self._TagKey = TagKey

    @property
    def TagValue(self):
        """Tag value.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._TagValue

    @TagValue.setter
    def TagValue(self, TagValue):
        self._TagValue = TagValue


    def _deserialize(self, params):
        self._TagKey = params.get("TagKey")
        self._TagValue = params.get("TagValue")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class TestData(AbstractModel):
    """Test dataset.

    """

    def __init__(self):
        r"""
        :param _Name: File name of the test dataset.

Note: This field may return null, indicating that no valid value is found.
        :type Name: str
        :param _Split: Whether the dataset is sharded.

Note: This field may return null, indicating that no valid value is found.
        :type Split: bool
        :param _HeaderInFile: Whether the first row is parameter name.

Note: This field may return null, indicating that no valid value is found.
        :type HeaderInFile: bool
        :param _HeaderColumns: Array of parameter name.

Note: This field may return null, indicating that no valid value is found.
        :type HeaderColumns: list of str
        :param _LineCount: Number of file lines.

Note: This field may return null, indicating that no valid value is found.
        :type LineCount: int
        :param _UpdatedAt: Update time.

Note: This field may return null, indicating that no valid value is found.
        :type UpdatedAt: str
        :param _Size: File size.

Note: This field may return null, indicating that no valid value is found.
        :type Size: int
        :param _HeadLines: First few rows of dataset.

Note: This field may return null, indicating that no valid value is found.
        :type HeadLines: list of str
        :param _TailLines: Last few rows of dataset.

Note: This field may return null, indicating that no valid value is found.
        :type TailLines: list of str
        :param _Type: File type.

Note: This field may return null, indicating that no valid value is found.
        :type Type: str
        :param _FileId: File ID.

Note: This field may return null, indicating that no valid value is found.
        :type FileId: str
        """
        self._Name = None
        self._Split = None
        self._HeaderInFile = None
        self._HeaderColumns = None
        self._LineCount = None
        self._UpdatedAt = None
        self._Size = None
        self._HeadLines = None
        self._TailLines = None
        self._Type = None
        self._FileId = None

    @property
    def Name(self):
        """File name of the test dataset.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Split(self):
        """Whether the dataset is sharded.

Note: This field may return null, indicating that no valid value is found.
        :rtype: bool
        """
        return self._Split

    @Split.setter
    def Split(self, Split):
        self._Split = Split

    @property
    def HeaderInFile(self):
        """Whether the first row is parameter name.

Note: This field may return null, indicating that no valid value is found.
        :rtype: bool
        """
        return self._HeaderInFile

    @HeaderInFile.setter
    def HeaderInFile(self, HeaderInFile):
        self._HeaderInFile = HeaderInFile

    @property
    def HeaderColumns(self):
        """Array of parameter name.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of str
        """
        return self._HeaderColumns

    @HeaderColumns.setter
    def HeaderColumns(self, HeaderColumns):
        self._HeaderColumns = HeaderColumns

    @property
    def LineCount(self):
        """Number of file lines.

Note: This field may return null, indicating that no valid value is found.
        :rtype: int
        """
        return self._LineCount

    @LineCount.setter
    def LineCount(self, LineCount):
        self._LineCount = LineCount

    @property
    def UpdatedAt(self):
        """Update time.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._UpdatedAt

    @UpdatedAt.setter
    def UpdatedAt(self, UpdatedAt):
        self._UpdatedAt = UpdatedAt

    @property
    def Size(self):
        """File size.

Note: This field may return null, indicating that no valid value is found.
        :rtype: int
        """
        return self._Size

    @Size.setter
    def Size(self, Size):
        self._Size = Size

    @property
    def HeadLines(self):
        """First few rows of dataset.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of str
        """
        return self._HeadLines

    @HeadLines.setter
    def HeadLines(self, HeadLines):
        self._HeadLines = HeadLines

    @property
    def TailLines(self):
        """Last few rows of dataset.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of str
        """
        return self._TailLines

    @TailLines.setter
    def TailLines(self, TailLines):
        self._TailLines = TailLines

    @property
    def Type(self):
        """File type.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def FileId(self):
        """File ID.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Split = params.get("Split")
        self._HeaderInFile = params.get("HeaderInFile")
        self._HeaderColumns = params.get("HeaderColumns")
        self._LineCount = params.get("LineCount")
        self._UpdatedAt = params.get("UpdatedAt")
        self._Size = params.get("Size")
        self._HeadLines = params.get("HeadLines")
        self._TailLines = params.get("TailLines")
        self._Type = params.get("Type")
        self._FileId = params.get("FileId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UpdateCronJobRequest(AbstractModel):
    """UpdateCronJob request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID.
        :type ProjectId: str
        :param _CronJobId: Cron job ID.
        :type CronJobId: str
        :param _Note: Note.
        :type Note: str
        :param _CronExpression: Cron expression.
        :type CronExpression: str
        :param _FrequencyType: Execution frequency type: 1, execute once only; 2, Daily; 3, Weekly; 4, Advanced mode using cron expression.
        :type FrequencyType: int
        :param _Name: Cron job Name.
        :type Name: str
        :param _ScenarioId: Scenario ID.
        :type ScenarioId: str
        :param _ScenarioName: Scenario name.
        :type ScenarioName: str
        :param _JobOwner: Cron job Initiator.
        :type JobOwner: str
        :param _EndTime: End time.
        :type EndTime: str
        :param _NoticeId: Notice ID.
        :type NoticeId: str
        """
        self._ProjectId = None
        self._CronJobId = None
        self._Note = None
        self._CronExpression = None
        self._FrequencyType = None
        self._Name = None
        self._ScenarioId = None
        self._ScenarioName = None
        self._JobOwner = None
        self._EndTime = None
        self._NoticeId = None

    @property
    def ProjectId(self):
        """Project ID.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def CronJobId(self):
        """Cron job ID.
        :rtype: str
        """
        return self._CronJobId

    @CronJobId.setter
    def CronJobId(self, CronJobId):
        self._CronJobId = CronJobId

    @property
    def Note(self):
        """Note.
        :rtype: str
        """
        return self._Note

    @Note.setter
    def Note(self, Note):
        self._Note = Note

    @property
    def CronExpression(self):
        """Cron expression.
        :rtype: str
        """
        return self._CronExpression

    @CronExpression.setter
    def CronExpression(self, CronExpression):
        self._CronExpression = CronExpression

    @property
    def FrequencyType(self):
        """Execution frequency type: 1, execute once only; 2, Daily; 3, Weekly; 4, Advanced mode using cron expression.
        :rtype: int
        """
        return self._FrequencyType

    @FrequencyType.setter
    def FrequencyType(self, FrequencyType):
        self._FrequencyType = FrequencyType

    @property
    def Name(self):
        """Cron job Name.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def ScenarioId(self):
        """Scenario ID.
        :rtype: str
        """
        return self._ScenarioId

    @ScenarioId.setter
    def ScenarioId(self, ScenarioId):
        self._ScenarioId = ScenarioId

    @property
    def ScenarioName(self):
        """Scenario name.
        :rtype: str
        """
        return self._ScenarioName

    @ScenarioName.setter
    def ScenarioName(self, ScenarioName):
        self._ScenarioName = ScenarioName

    @property
    def JobOwner(self):
        """Cron job Initiator.
        :rtype: str
        """
        return self._JobOwner

    @JobOwner.setter
    def JobOwner(self, JobOwner):
        self._JobOwner = JobOwner

    @property
    def EndTime(self):
        """End time.
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def NoticeId(self):
        """Notice ID.
        :rtype: str
        """
        return self._NoticeId

    @NoticeId.setter
    def NoticeId(self, NoticeId):
        self._NoticeId = NoticeId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._CronJobId = params.get("CronJobId")
        self._Note = params.get("Note")
        self._CronExpression = params.get("CronExpression")
        self._FrequencyType = params.get("FrequencyType")
        self._Name = params.get("Name")
        self._ScenarioId = params.get("ScenarioId")
        self._ScenarioName = params.get("ScenarioName")
        self._JobOwner = params.get("JobOwner")
        self._EndTime = params.get("EndTime")
        self._NoticeId = params.get("NoticeId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UpdateCronJobResponse(AbstractModel):
    """UpdateCronJob response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class UpdateEnvironmentRequest(AbstractModel):
    """UpdateEnvironment request structure.

    """


class UpdateEnvironmentResponse(AbstractModel):
    """UpdateEnvironment response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class UpdateFileScenarioRelationRequest(AbstractModel):
    """UpdateFileScenarioRelation request structure.

    """

    def __init__(self):
        r"""
        :param _FileId: File ID. Its value should be the corresponding directory of the file in the COS bucket after it has been uploaded in the previous step.
        :type FileId: str
        :param _ProjectId: Project ID.
        :type ProjectId: str
        :param _ScenarioIds: Array of Scenario ID.
        :type ScenarioIds: list of str
        """
        self._FileId = None
        self._ProjectId = None
        self._ScenarioIds = None

    @property
    def FileId(self):
        """File ID. Its value should be the corresponding directory of the file in the COS bucket after it has been uploaded in the previous step.
        :rtype: str
        """
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def ProjectId(self):
        """Project ID.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ScenarioIds(self):
        """Array of Scenario ID.
        :rtype: list of str
        """
        return self._ScenarioIds

    @ScenarioIds.setter
    def ScenarioIds(self, ScenarioIds):
        self._ScenarioIds = ScenarioIds


    def _deserialize(self, params):
        self._FileId = params.get("FileId")
        self._ProjectId = params.get("ProjectId")
        self._ScenarioIds = params.get("ScenarioIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UpdateFileScenarioRelationResponse(AbstractModel):
    """UpdateFileScenarioRelation response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class UpdateJobRequest(AbstractModel):
    """UpdateJob request structure.

    """

    def __init__(self):
        r"""
        :param _JobId: Job ID.
        :type JobId: str
        :param _ProjectId: Project ID.
        :type ProjectId: str
        :param _ScenarioId: Scenario ID.
        :type ScenarioId: str
        :param _Note: Job note.
        :type Note: str
        """
        self._JobId = None
        self._ProjectId = None
        self._ScenarioId = None
        self._Note = None

    @property
    def JobId(self):
        """Job ID.
        :rtype: str
        """
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def ProjectId(self):
        """Project ID.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ScenarioId(self):
        """Scenario ID.
        :rtype: str
        """
        return self._ScenarioId

    @ScenarioId.setter
    def ScenarioId(self, ScenarioId):
        self._ScenarioId = ScenarioId

    @property
    def Note(self):
        """Job note.
        :rtype: str
        """
        return self._Note

    @Note.setter
    def Note(self, Note):
        self._Note = Note


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._ProjectId = params.get("ProjectId")
        self._ScenarioId = params.get("ScenarioId")
        self._Note = params.get("Note")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UpdateJobResponse(AbstractModel):
    """UpdateJob response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class UpdateProjectRequest(AbstractModel):
    """UpdateProject request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project ID.
        :type ProjectId: str
        :param _Name: Project name.
        :type Name: str
        :param _Description: Project description.
        :type Description: str
        :param _Status: Project status, default value 1
        :type Status: int
        :param _Tags: Tags.
        :type Tags: list of TagSpec
        """
        self._ProjectId = None
        self._Name = None
        self._Description = None
        self._Status = None
        self._Tags = None

    @property
    def ProjectId(self):
        """Project ID.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Name(self):
        """Project name.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Description(self):
        """Project description.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Status(self):
        """Project status, default value 1
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Tags(self):
        """Tags.
        :rtype: list of TagSpec
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._Name = params.get("Name")
        self._Description = params.get("Description")
        self._Status = params.get("Status")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = TagSpec()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UpdateProjectResponse(AbstractModel):
    """UpdateProject response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class UpdateScenarioRequest(AbstractModel):
    """UpdateScenario request structure.

    """

    def __init__(self):
        r"""
        :param _ScenarioId: Scenario ID.
        :type ScenarioId: str
        :param _Name: Scenario name. When calling this API, please include the fields in the Scenario that do not need to be modified as part of the API parameters, otherwise the scenario may become unusable.
        :type Name: str
        :param _Description: Scenario description.
        :type Description: str
        :param _Type: Mode type of scenario. Valid values: 'pts-http' represents the simple mode, 'pts-js' represents the script mode, 'pts-jmeter' represents the JMeter mode.
        :type Type: str
        :param _Load: Load configuration.
        :type Load: :class:`tencentcloud.pts.v20210728.models.Load`
        :param _EncodedScripts: Deprecated.
        :type EncodedScripts: str
        :param _Configs: Deprecated.
        :type Configs: list of str
        :param _Datasets: Test datasets.
        :type Datasets: list of TestData
        :param _Extensions: Deprecated.
        :type Extensions: list of str
        :param _SLAId: SLA rule ID.
        :type SLAId: str
        :param _CronId: Cron job ID.
        :type CronId: str
        :param _Status: Scenario status (Note: This parameter is no longer required).
        :type Status: int
        :param _ProjectId: Project ID.
        :type ProjectId: str
        :param _TestScripts: Test scripts.
        :type TestScripts: list of ScriptInfo
        :param _Protocols: Protocol.
        :type Protocols: list of ProtocolInfo
        :param _RequestFiles: Request files.
        :type RequestFiles: list of FileInfo
        :param _SLAPolicy: SLA policy.
        :type SLAPolicy: :class:`tencentcloud.pts.v20210728.models.SLAPolicy`
        :param _Plugins: Extension plugins.
        :type Plugins: list of FileInfo
        :param _DomainNameConfig: Domain name resolution configuration.
        :type DomainNameConfig: :class:`tencentcloud.pts.v20210728.models.DomainNameConfig`
        :param _NotificationHooks: Notification web hook configuration.
        :type NotificationHooks: list of Notification
        :param _Owner: Creator name.
        :type Owner: str
        :param _EnvId: Environment ID.
        :type EnvId: str
        """
        self._ScenarioId = None
        self._Name = None
        self._Description = None
        self._Type = None
        self._Load = None
        self._EncodedScripts = None
        self._Configs = None
        self._Datasets = None
        self._Extensions = None
        self._SLAId = None
        self._CronId = None
        self._Status = None
        self._ProjectId = None
        self._TestScripts = None
        self._Protocols = None
        self._RequestFiles = None
        self._SLAPolicy = None
        self._Plugins = None
        self._DomainNameConfig = None
        self._NotificationHooks = None
        self._Owner = None
        self._EnvId = None

    @property
    def ScenarioId(self):
        """Scenario ID.
        :rtype: str
        """
        return self._ScenarioId

    @ScenarioId.setter
    def ScenarioId(self, ScenarioId):
        self._ScenarioId = ScenarioId

    @property
    def Name(self):
        """Scenario name. When calling this API, please include the fields in the Scenario that do not need to be modified as part of the API parameters, otherwise the scenario may become unusable.
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Description(self):
        """Scenario description.
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Type(self):
        """Mode type of scenario. Valid values: 'pts-http' represents the simple mode, 'pts-js' represents the script mode, 'pts-jmeter' represents the JMeter mode.
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Load(self):
        """Load configuration.
        :rtype: :class:`tencentcloud.pts.v20210728.models.Load`
        """
        return self._Load

    @Load.setter
    def Load(self, Load):
        self._Load = Load

    @property
    def EncodedScripts(self):
        """Deprecated.
        :rtype: str
        """
        return self._EncodedScripts

    @EncodedScripts.setter
    def EncodedScripts(self, EncodedScripts):
        self._EncodedScripts = EncodedScripts

    @property
    def Configs(self):
        """Deprecated.
        :rtype: list of str
        """
        return self._Configs

    @Configs.setter
    def Configs(self, Configs):
        self._Configs = Configs

    @property
    def Datasets(self):
        """Test datasets.
        :rtype: list of TestData
        """
        return self._Datasets

    @Datasets.setter
    def Datasets(self, Datasets):
        self._Datasets = Datasets

    @property
    def Extensions(self):
        """Deprecated.
        :rtype: list of str
        """
        return self._Extensions

    @Extensions.setter
    def Extensions(self, Extensions):
        self._Extensions = Extensions

    @property
    def SLAId(self):
        """SLA rule ID.
        :rtype: str
        """
        return self._SLAId

    @SLAId.setter
    def SLAId(self, SLAId):
        self._SLAId = SLAId

    @property
    def CronId(self):
        """Cron job ID.
        :rtype: str
        """
        return self._CronId

    @CronId.setter
    def CronId(self, CronId):
        self._CronId = CronId

    @property
    def Status(self):
        """Scenario status (Note: This parameter is no longer required).
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ProjectId(self):
        """Project ID.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TestScripts(self):
        """Test scripts.
        :rtype: list of ScriptInfo
        """
        return self._TestScripts

    @TestScripts.setter
    def TestScripts(self, TestScripts):
        self._TestScripts = TestScripts

    @property
    def Protocols(self):
        """Protocol.
        :rtype: list of ProtocolInfo
        """
        return self._Protocols

    @Protocols.setter
    def Protocols(self, Protocols):
        self._Protocols = Protocols

    @property
    def RequestFiles(self):
        """Request files.
        :rtype: list of FileInfo
        """
        return self._RequestFiles

    @RequestFiles.setter
    def RequestFiles(self, RequestFiles):
        self._RequestFiles = RequestFiles

    @property
    def SLAPolicy(self):
        """SLA policy.
        :rtype: :class:`tencentcloud.pts.v20210728.models.SLAPolicy`
        """
        return self._SLAPolicy

    @SLAPolicy.setter
    def SLAPolicy(self, SLAPolicy):
        self._SLAPolicy = SLAPolicy

    @property
    def Plugins(self):
        """Extension plugins.
        :rtype: list of FileInfo
        """
        return self._Plugins

    @Plugins.setter
    def Plugins(self, Plugins):
        self._Plugins = Plugins

    @property
    def DomainNameConfig(self):
        """Domain name resolution configuration.
        :rtype: :class:`tencentcloud.pts.v20210728.models.DomainNameConfig`
        """
        return self._DomainNameConfig

    @DomainNameConfig.setter
    def DomainNameConfig(self, DomainNameConfig):
        self._DomainNameConfig = DomainNameConfig

    @property
    def NotificationHooks(self):
        """Notification web hook configuration.
        :rtype: list of Notification
        """
        return self._NotificationHooks

    @NotificationHooks.setter
    def NotificationHooks(self, NotificationHooks):
        self._NotificationHooks = NotificationHooks

    @property
    def Owner(self):
        """Creator name.
        :rtype: str
        """
        return self._Owner

    @Owner.setter
    def Owner(self, Owner):
        self._Owner = Owner

    @property
    def EnvId(self):
        """Environment ID.
        :rtype: str
        """
        return self._EnvId

    @EnvId.setter
    def EnvId(self, EnvId):
        self._EnvId = EnvId


    def _deserialize(self, params):
        self._ScenarioId = params.get("ScenarioId")
        self._Name = params.get("Name")
        self._Description = params.get("Description")
        self._Type = params.get("Type")
        if params.get("Load") is not None:
            self._Load = Load()
            self._Load._deserialize(params.get("Load"))
        self._EncodedScripts = params.get("EncodedScripts")
        self._Configs = params.get("Configs")
        if params.get("Datasets") is not None:
            self._Datasets = []
            for item in params.get("Datasets"):
                obj = TestData()
                obj._deserialize(item)
                self._Datasets.append(obj)
        self._Extensions = params.get("Extensions")
        self._SLAId = params.get("SLAId")
        self._CronId = params.get("CronId")
        self._Status = params.get("Status")
        self._ProjectId = params.get("ProjectId")
        if params.get("TestScripts") is not None:
            self._TestScripts = []
            for item in params.get("TestScripts"):
                obj = ScriptInfo()
                obj._deserialize(item)
                self._TestScripts.append(obj)
        if params.get("Protocols") is not None:
            self._Protocols = []
            for item in params.get("Protocols"):
                obj = ProtocolInfo()
                obj._deserialize(item)
                self._Protocols.append(obj)
        if params.get("RequestFiles") is not None:
            self._RequestFiles = []
            for item in params.get("RequestFiles"):
                obj = FileInfo()
                obj._deserialize(item)
                self._RequestFiles.append(obj)
        if params.get("SLAPolicy") is not None:
            self._SLAPolicy = SLAPolicy()
            self._SLAPolicy._deserialize(params.get("SLAPolicy"))
        if params.get("Plugins") is not None:
            self._Plugins = []
            for item in params.get("Plugins"):
                obj = FileInfo()
                obj._deserialize(item)
                self._Plugins.append(obj)
        if params.get("DomainNameConfig") is not None:
            self._DomainNameConfig = DomainNameConfig()
            self._DomainNameConfig._deserialize(params.get("DomainNameConfig"))
        if params.get("NotificationHooks") is not None:
            self._NotificationHooks = []
            for item in params.get("NotificationHooks"):
                obj = Notification()
                obj._deserialize(item)
                self._NotificationHooks.append(obj)
        self._Owner = params.get("Owner")
        self._EnvId = params.get("EnvId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UpdateScenarioResponse(AbstractModel):
    """UpdateScenario response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class VpcLoadDistribution(AbstractModel):
    """Load specification in vpc mode

    """

    def __init__(self):
        r"""
        :param _RegionId: Region ID.
        :type RegionId: int
        :param _Region: Region.
        :type Region: str
        :param _VpcId: VPC ID.

Note: This field may return null, indicating that no valid value is found.
        :type VpcId: str
        :param _SubnetIds: List of subnet IDs.

Note: This field may return null, indicating that no valid value is found.
        :type SubnetIds: list of str
        """
        self._RegionId = None
        self._Region = None
        self._VpcId = None
        self._SubnetIds = None

    @property
    def RegionId(self):
        """Region ID.
        :rtype: int
        """
        return self._RegionId

    @RegionId.setter
    def RegionId(self, RegionId):
        self._RegionId = RegionId

    @property
    def Region(self):
        """Region.
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def VpcId(self):
        """VPC ID.

Note: This field may return null, indicating that no valid value is found.
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetIds(self):
        """List of subnet IDs.

Note: This field may return null, indicating that no valid value is found.
        :rtype: list of str
        """
        return self._SubnetIds

    @SubnetIds.setter
    def SubnetIds(self, SubnetIds):
        self._SubnetIds = SubnetIds


    def _deserialize(self, params):
        self._RegionId = params.get("RegionId")
        self._Region = params.get("Region")
        self._VpcId = params.get("VpcId")
        self._SubnetIds = params.get("SubnetIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        