# -*- coding: utf8 -*-
# Copyright (c) 2017-2025 Tencent. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class BatchDeleteDevicesRequest(AbstractModel):
    """BatchDeleteDevices request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project id of the targeted deleted device.
        :type ProjectId: str
        :param _DeviceIds: Device id array of the targeted deleted device.
        :type DeviceIds: list of str
        """
        self._ProjectId = None
        self._DeviceIds = None

    @property
    def ProjectId(self):
        """Project id of the targeted deleted device.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def DeviceIds(self):
        """Device id array of the targeted deleted device.
        :rtype: list of str
        """
        return self._DeviceIds

    @DeviceIds.setter
    def DeviceIds(self, DeviceIds):
        self._DeviceIds = DeviceIds


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._DeviceIds = params.get("DeviceIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchDeleteDevicesResponse(AbstractModel):
    """BatchDeleteDevices response structure.

    """

    def __init__(self):
        r"""
        :param _FailedDeviceIds: List of device ids with deletion failed.
        :type FailedDeviceIds: list of str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FailedDeviceIds = None
        self._RequestId = None

    @property
    def FailedDeviceIds(self):
        """List of device ids with deletion failed.
        :rtype: list of str
        """
        return self._FailedDeviceIds

    @FailedDeviceIds.setter
    def FailedDeviceIds(self, FailedDeviceIds):
        self._FailedDeviceIds = FailedDeviceIds

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FailedDeviceIds = params.get("FailedDeviceIds")
        self._RequestId = params.get("RequestId")


class BatchDeletePolicyRequest(AbstractModel):
    """BatchDeletePolicy request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project id of the deleted permission configuration.
        :type ProjectId: str
        :param _RemoteDeviceIds: Remote device id list of the deleted permission configuration.
        :type RemoteDeviceIds: list of str
        :param _PolicyMode: Permission mode of the deleted permission configuration, black for blocklist, white for allowlist.
        :type PolicyMode: str
        """
        self._ProjectId = None
        self._RemoteDeviceIds = None
        self._PolicyMode = None

    @property
    def ProjectId(self):
        """Project id of the deleted permission configuration.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def RemoteDeviceIds(self):
        """Remote device id list of the deleted permission configuration.
        :rtype: list of str
        """
        return self._RemoteDeviceIds

    @RemoteDeviceIds.setter
    def RemoteDeviceIds(self, RemoteDeviceIds):
        self._RemoteDeviceIds = RemoteDeviceIds

    @property
    def PolicyMode(self):
        """Permission mode of the deleted permission configuration, black for blocklist, white for allowlist.
        :rtype: str
        """
        return self._PolicyMode

    @PolicyMode.setter
    def PolicyMode(self, PolicyMode):
        self._PolicyMode = PolicyMode


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._RemoteDeviceIds = params.get("RemoteDeviceIds")
        self._PolicyMode = params.get("PolicyMode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchDeletePolicyResponse(AbstractModel):
    """BatchDeletePolicy response structure.

    """

    def __init__(self):
        r"""
        :param _FailedRemoteDeviceIds: Remote device id list with failed permission configuration deletion.
        :type FailedRemoteDeviceIds: list of str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FailedRemoteDeviceIds = None
        self._RequestId = None

    @property
    def FailedRemoteDeviceIds(self):
        """Remote device id list with failed permission configuration deletion.
        :rtype: list of str
        """
        return self._FailedRemoteDeviceIds

    @FailedRemoteDeviceIds.setter
    def FailedRemoteDeviceIds(self, FailedRemoteDeviceIds):
        self._FailedRemoteDeviceIds = FailedRemoteDeviceIds

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FailedRemoteDeviceIds = params.get("FailedRemoteDeviceIds")
        self._RequestId = params.get("RequestId")


class CreateDeviceRequest(AbstractModel):
    """CreateDevice request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Create the project id to which the device belongs.
        :type ProjectId: str
        :param _DeviceId: Create a device id, which must be unique within the project, consisting of lowercase english letters, numbers, and underscores, with a length not exceeding 18.
        :type DeviceId: str
        :param _DeviceName: Create a device name, with a length of less than 24, which can include chinese, numbers, english letters, and underscores.
        :type DeviceName: str
        :param _DeviceType: Device type, field for on-site device (controlled device), remote for remote device (control device), default is field if not specified.
        :type DeviceType: str
        :param _DeviceToken: Device authentication password, consisting of uppercase and lowercase english letters and digits, must be 16 characters.
        :type DeviceToken: str
        """
        self._ProjectId = None
        self._DeviceId = None
        self._DeviceName = None
        self._DeviceType = None
        self._DeviceToken = None

    @property
    def ProjectId(self):
        """Create the project id to which the device belongs.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def DeviceId(self):
        """Create a device id, which must be unique within the project, consisting of lowercase english letters, numbers, and underscores, with a length not exceeding 18.
        :rtype: str
        """
        return self._DeviceId

    @DeviceId.setter
    def DeviceId(self, DeviceId):
        self._DeviceId = DeviceId

    @property
    def DeviceName(self):
        """Create a device name, with a length of less than 24, which can include chinese, numbers, english letters, and underscores.
        :rtype: str
        """
        return self._DeviceName

    @DeviceName.setter
    def DeviceName(self, DeviceName):
        self._DeviceName = DeviceName

    @property
    def DeviceType(self):
        """Device type, field for on-site device (controlled device), remote for remote device (control device), default is field if not specified.
        :rtype: str
        """
        return self._DeviceType

    @DeviceType.setter
    def DeviceType(self, DeviceType):
        self._DeviceType = DeviceType

    @property
    def DeviceToken(self):
        """Device authentication password, consisting of uppercase and lowercase english letters and digits, must be 16 characters.
        :rtype: str
        """
        return self._DeviceToken

    @DeviceToken.setter
    def DeviceToken(self, DeviceToken):
        self._DeviceToken = DeviceToken


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._DeviceId = params.get("DeviceId")
        self._DeviceName = params.get("DeviceName")
        self._DeviceType = params.get("DeviceType")
        self._DeviceToken = params.get("DeviceToken")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDeviceResponse(AbstractModel):
    """CreateDevice response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateProjectRequest(AbstractModel):
    """CreateProject request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectName: Project name, up to 24 characters.
        :type ProjectName: str
        :param _ProjectDescription: Project description, up to 120 characters, default is empty if not filled.
        :type ProjectDescription: str
        :param _PolicyMode: Permission mode, black for blocklist, white for allowlist. defaults to black if not specified.
        :type PolicyMode: str
        """
        self._ProjectName = None
        self._ProjectDescription = None
        self._PolicyMode = None

    @property
    def ProjectName(self):
        """Project name, up to 24 characters.
        :rtype: str
        """
        return self._ProjectName

    @ProjectName.setter
    def ProjectName(self, ProjectName):
        self._ProjectName = ProjectName

    @property
    def ProjectDescription(self):
        """Project description, up to 120 characters, default is empty if not filled.
        :rtype: str
        """
        return self._ProjectDescription

    @ProjectDescription.setter
    def ProjectDescription(self, ProjectDescription):
        self._ProjectDescription = ProjectDescription

    @property
    def PolicyMode(self):
        """Permission mode, black for blocklist, white for allowlist. defaults to black if not specified.
        :rtype: str
        """
        return self._PolicyMode

    @PolicyMode.setter
    def PolicyMode(self, PolicyMode):
        self._PolicyMode = PolicyMode


    def _deserialize(self, params):
        self._ProjectName = params.get("ProjectName")
        self._ProjectDescription = params.get("ProjectDescription")
        self._PolicyMode = params.get("PolicyMode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateProjectResponse(AbstractModel):
    """CreateProject response structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project id, length is 16 characters.
        :type ProjectId: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ProjectId = None
        self._RequestId = None

    @property
    def ProjectId(self):
        """Project id, length is 16 characters.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._RequestId = params.get("RequestId")


class DeleteProjectRequest(AbstractModel):
    """DeleteProject request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project id.
        :type ProjectId: str
        """
        self._ProjectId = None

    @property
    def ProjectId(self):
        """Project id.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteProjectResponse(AbstractModel):
    """DeleteProject response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DescribeDeviceInfoRequest(AbstractModel):
    """DescribeDeviceInfo request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project id to which the target device belongs.
        :type ProjectId: str
        :param _DeviceId: Target device id.
        :type DeviceId: str
        """
        self._ProjectId = None
        self._DeviceId = None

    @property
    def ProjectId(self):
        """Project id to which the target device belongs.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def DeviceId(self):
        """Target device id.
        :rtype: str
        """
        return self._DeviceId

    @DeviceId.setter
    def DeviceId(self, DeviceId):
        self._DeviceId = DeviceId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._DeviceId = params.get("DeviceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDeviceInfoResponse(AbstractModel):
    """DescribeDeviceInfo response structure.

    """

    def __init__(self):
        r"""
        :param _DeviceName: Device name.
        :type DeviceName: str
        :param _DeviceType: Device type: "field" specifies on-site devices (controlled party), and "remote" specifies remote devices (controlling party).
        :type DeviceType: str
        :param _DeviceStatus: Device status: offline means offline, ready means online and ready, connected means in session.
        :type DeviceStatus: str
        :param _LastReportTime: Last updated time of device status.
        :type LastReportTime: str
        :param _ModifyTime: Modification time of device information.
        :type ModifyTime: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DeviceName = None
        self._DeviceType = None
        self._DeviceStatus = None
        self._LastReportTime = None
        self._ModifyTime = None
        self._RequestId = None

    @property
    def DeviceName(self):
        """Device name.
        :rtype: str
        """
        return self._DeviceName

    @DeviceName.setter
    def DeviceName(self, DeviceName):
        self._DeviceName = DeviceName

    @property
    def DeviceType(self):
        """Device type: "field" specifies on-site devices (controlled party), and "remote" specifies remote devices (controlling party).
        :rtype: str
        """
        return self._DeviceType

    @DeviceType.setter
    def DeviceType(self, DeviceType):
        self._DeviceType = DeviceType

    @property
    def DeviceStatus(self):
        """Device status: offline means offline, ready means online and ready, connected means in session.
        :rtype: str
        """
        return self._DeviceStatus

    @DeviceStatus.setter
    def DeviceStatus(self, DeviceStatus):
        self._DeviceStatus = DeviceStatus

    @property
    def LastReportTime(self):
        """Last updated time of device status.
        :rtype: str
        """
        return self._LastReportTime

    @LastReportTime.setter
    def LastReportTime(self, LastReportTime):
        self._LastReportTime = LastReportTime

    @property
    def ModifyTime(self):
        """Modification time of device information.
        :rtype: str
        """
        return self._ModifyTime

    @ModifyTime.setter
    def ModifyTime(self, ModifyTime):
        self._ModifyTime = ModifyTime

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DeviceName = params.get("DeviceName")
        self._DeviceType = params.get("DeviceType")
        self._DeviceStatus = params.get("DeviceStatus")
        self._LastReportTime = params.get("LastReportTime")
        self._ModifyTime = params.get("ModifyTime")
        self._RequestId = params.get("RequestId")


class DescribeDeviceSessionListRequest(AbstractModel):
    """DescribeDeviceSessionList request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project id.
        :type ProjectId: str
        :param _PageNumber: Page number, beginning from 1.
        :type PageNumber: int
        :param _PageSize: Number of entries per page.
        :type PageSize: int
        :param _DeviceId: Device id.
        :type DeviceId: str
        :param _StartTime: Start time.
        :type StartTime: int
        :param _EndTime: End time.
        :type EndTime: int
        """
        self._ProjectId = None
        self._PageNumber = None
        self._PageSize = None
        self._DeviceId = None
        self._StartTime = None
        self._EndTime = None

    @property
    def ProjectId(self):
        """Project id.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PageNumber(self):
        """Page number, beginning from 1.
        :rtype: int
        """
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        """Number of entries per page.
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def DeviceId(self):
        """Device id.
        :rtype: str
        """
        return self._DeviceId

    @DeviceId.setter
    def DeviceId(self, DeviceId):
        self._DeviceId = DeviceId

    @property
    def StartTime(self):
        """Start time.
        :rtype: int
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """End time.
        :rtype: int
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        self._DeviceId = params.get("DeviceId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDeviceSessionListResponse(AbstractModel):
    """DescribeDeviceSessionList response structure.

    """

    def __init__(self):
        r"""
        :param _Total: Total number.
        :type Total: int
        :param _DeviceSessionList: Conversation list.
        :type DeviceSessionList: list of SessionInfo
        :param _Num: Number of items on this page.
        :type Num: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Total = None
        self._DeviceSessionList = None
        self._Num = None
        self._RequestId = None

    @property
    def Total(self):
        """Total number.
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def DeviceSessionList(self):
        """Conversation list.
        :rtype: list of SessionInfo
        """
        return self._DeviceSessionList

    @DeviceSessionList.setter
    def DeviceSessionList(self, DeviceSessionList):
        self._DeviceSessionList = DeviceSessionList

    @property
    def Num(self):
        """Number of items on this page.
        :rtype: int
        """
        return self._Num

    @Num.setter
    def Num(self, Num):
        self._Num = Num

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("DeviceSessionList") is not None:
            self._DeviceSessionList = []
            for item in params.get("DeviceSessionList"):
                obj = SessionInfo()
                obj._deserialize(item)
                self._DeviceSessionList.append(obj)
        self._Num = params.get("Num")
        self._RequestId = params.get("RequestId")


class DescribeProjectInfoRequest(AbstractModel):
    """DescribeProjectInfo request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Target project id. required parameter.
        :type ProjectId: str
        """
        self._ProjectId = None

    @property
    def ProjectId(self):
        """Target project id. required parameter.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeProjectInfoResponse(AbstractModel):
    """DescribeProjectInfo response structure.

    """

    def __init__(self):
        r"""
        :param _ProjectName: Project name.
        :type ProjectName: str
        :param _ProjectDescription: Project description.
        :type ProjectDescription: str
        :param _PolicyMode: Project permission mode, black for blocklist, white for allowlist.
        :type PolicyMode: str
        :param _ModifyTime: Project information modification time.
        :type ModifyTime: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ProjectName = None
        self._ProjectDescription = None
        self._PolicyMode = None
        self._ModifyTime = None
        self._RequestId = None

    @property
    def ProjectName(self):
        """Project name.
        :rtype: str
        """
        return self._ProjectName

    @ProjectName.setter
    def ProjectName(self, ProjectName):
        self._ProjectName = ProjectName

    @property
    def ProjectDescription(self):
        """Project description.
        :rtype: str
        """
        return self._ProjectDescription

    @ProjectDescription.setter
    def ProjectDescription(self, ProjectDescription):
        self._ProjectDescription = ProjectDescription

    @property
    def PolicyMode(self):
        """Project permission mode, black for blocklist, white for allowlist.
        :rtype: str
        """
        return self._PolicyMode

    @PolicyMode.setter
    def PolicyMode(self, PolicyMode):
        self._PolicyMode = PolicyMode

    @property
    def ModifyTime(self):
        """Project information modification time.
        :rtype: str
        """
        return self._ModifyTime

    @ModifyTime.setter
    def ModifyTime(self, ModifyTime):
        self._ModifyTime = ModifyTime

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ProjectName = params.get("ProjectName")
        self._ProjectDescription = params.get("ProjectDescription")
        self._PolicyMode = params.get("PolicyMode")
        self._ModifyTime = params.get("ModifyTime")
        self._RequestId = params.get("RequestId")


class DescribeProjectListRequest(AbstractModel):
    """DescribeProjectList request structure.

    """

    def __init__(self):
        r"""
        :param _PageSize: The maximum number of projects returned per page. the default value is 10 if it is not filled in.
        :type PageSize: int
        :param _PageNumber: The current page number. the default value is 1 (homepage) if it is not filled in.
        :type PageNumber: int
        """
        self._PageSize = None
        self._PageNumber = None

    @property
    def PageSize(self):
        """The maximum number of projects returned per page. the default value is 10 if it is not filled in.
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def PageNumber(self):
        """The current page number. the default value is 1 (homepage) if it is not filled in.
        :rtype: int
        """
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber


    def _deserialize(self, params):
        self._PageSize = params.get("PageSize")
        self._PageNumber = params.get("PageNumber")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeProjectListResponse(AbstractModel):
    """DescribeProjectList response structure.

    """

    def __init__(self):
        r"""
        :param _Projects: Array of project information.
        :type Projects: list of ProjectInfo
        :param _Total: Total number of projects.
        :type Total: int
        :param _Num: Number of projects returned in this request.
        :type Num: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Projects = None
        self._Total = None
        self._Num = None
        self._RequestId = None

    @property
    def Projects(self):
        """Array of project information.
        :rtype: list of ProjectInfo
        """
        return self._Projects

    @Projects.setter
    def Projects(self, Projects):
        self._Projects = Projects

    @property
    def Total(self):
        """Total number of projects.
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Num(self):
        """Number of projects returned in this request.
        :rtype: int
        """
        return self._Num

    @Num.setter
    def Num(self, Num):
        self._Num = Num

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Projects") is not None:
            self._Projects = []
            for item in params.get("Projects"):
                obj = ProjectInfo()
                obj._deserialize(item)
                self._Projects.append(obj)
        self._Total = params.get("Total")
        self._Num = params.get("Num")
        self._RequestId = params.get("RequestId")


class DescribeRecentSessionListRequest(AbstractModel):
    """DescribeRecentSessionList request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project id.
        :type ProjectId: str
        :param _PageNumber: Page number, beginning from 1.
        :type PageNumber: int
        :param _PageSize: Number of entries per page.
        :type PageSize: int
        :param _DeviceId: Device id, supports filtering by remote device or on-site device.
        :type DeviceId: str
        :param _StartTime: Start time of the time range. the maximum time range is the last two hours. if not specified or out of range, the start time is calculated as two hours ago.
        :type StartTime: int
        :param _EndTime: End time of the time range. the maximum time range is the last two hours. if not specified or out of range, the end time is calculated as the current time.
        :type EndTime: int
        """
        self._ProjectId = None
        self._PageNumber = None
        self._PageSize = None
        self._DeviceId = None
        self._StartTime = None
        self._EndTime = None

    @property
    def ProjectId(self):
        """Project id.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PageNumber(self):
        """Page number, beginning from 1.
        :rtype: int
        """
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        """Number of entries per page.
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def DeviceId(self):
        """Device id, supports filtering by remote device or on-site device.
        :rtype: str
        """
        return self._DeviceId

    @DeviceId.setter
    def DeviceId(self, DeviceId):
        self._DeviceId = DeviceId

    @property
    def StartTime(self):
        """Start time of the time range. the maximum time range is the last two hours. if not specified or out of range, the start time is calculated as two hours ago.
        :rtype: int
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """End time of the time range. the maximum time range is the last two hours. if not specified or out of range, the end time is calculated as the current time.
        :rtype: int
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        self._DeviceId = params.get("DeviceId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRecentSessionListResponse(AbstractModel):
    """DescribeRecentSessionList response structure.

    """

    def __init__(self):
        r"""
        :param _Total: Total number.
        :type Total: int
        :param _RecentSessionList: Conversation list.
        :type RecentSessionList: list of RecentSessionInfo
        :param _Num: Number of items on this page.
        :type Num: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Total = None
        self._RecentSessionList = None
        self._Num = None
        self._RequestId = None

    @property
    def Total(self):
        """Total number.
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RecentSessionList(self):
        """Conversation list.
        :rtype: list of RecentSessionInfo
        """
        return self._RecentSessionList

    @RecentSessionList.setter
    def RecentSessionList(self, RecentSessionList):
        self._RecentSessionList = RecentSessionList

    @property
    def Num(self):
        """Number of items on this page.
        :rtype: int
        """
        return self._Num

    @Num.setter
    def Num(self, Num):
        self._Num = Num

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("RecentSessionList") is not None:
            self._RecentSessionList = []
            for item in params.get("RecentSessionList"):
                obj = RecentSessionInfo()
                obj._deserialize(item)
                self._RecentSessionList.append(obj)
        self._Num = params.get("Num")
        self._RequestId = params.get("RequestId")


class DescribeSessionStatisticsByIntervalRequest(AbstractModel):
    """DescribeSessionStatisticsByInterval request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project id.
        :type ProjectId: str
        :param _StatisticInterval: Statistical time interval: hour|day|month.
        :type StatisticInterval: str
        :param _DeviceId: Device id.
        :type DeviceId: str
        :param _StartTime: Start time in seconds.
        :type StartTime: int
        :param _EndTime: End time in seconds.
        :type EndTime: int
        """
        self._ProjectId = None
        self._StatisticInterval = None
        self._DeviceId = None
        self._StartTime = None
        self._EndTime = None

    @property
    def ProjectId(self):
        """Project id.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def StatisticInterval(self):
        """Statistical time interval: hour|day|month.
        :rtype: str
        """
        return self._StatisticInterval

    @StatisticInterval.setter
    def StatisticInterval(self, StatisticInterval):
        self._StatisticInterval = StatisticInterval

    @property
    def DeviceId(self):
        """Device id.
        :rtype: str
        """
        return self._DeviceId

    @DeviceId.setter
    def DeviceId(self, DeviceId):
        self._DeviceId = DeviceId

    @property
    def StartTime(self):
        """Start time in seconds.
        :rtype: int
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """End time in seconds.
        :rtype: int
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._StatisticInterval = params.get("StatisticInterval")
        self._DeviceId = params.get("DeviceId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSessionStatisticsByIntervalResponse(AbstractModel):
    """DescribeSessionStatisticsByInterval response structure.

    """

    def __init__(self):
        r"""
        :param _SessionStatistics: Session statistics for each time period.
        :type SessionStatistics: list of SessionIntervalStatistic
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SessionStatistics = None
        self._RequestId = None

    @property
    def SessionStatistics(self):
        """Session statistics for each time period.
        :rtype: list of SessionIntervalStatistic
        """
        return self._SessionStatistics

    @SessionStatistics.setter
    def SessionStatistics(self, SessionStatistics):
        self._SessionStatistics = SessionStatistics

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SessionStatistics") is not None:
            self._SessionStatistics = []
            for item in params.get("SessionStatistics"):
                obj = SessionIntervalStatistic()
                obj._deserialize(item)
                self._SessionStatistics.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSessionStatisticsRequest(AbstractModel):
    """DescribeSessionStatistics request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project id.
        :type ProjectId: str
        :param _DeviceId: Device id.
        :type DeviceId: str
        :param _StartTime: Start time, unit: seconds.
        :type StartTime: int
        :param _EndTime: End time in seconds.
        :type EndTime: int
        """
        self._ProjectId = None
        self._DeviceId = None
        self._StartTime = None
        self._EndTime = None

    @property
    def ProjectId(self):
        """Project id.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def DeviceId(self):
        """Device id.
        :rtype: str
        """
        return self._DeviceId

    @DeviceId.setter
    def DeviceId(self, DeviceId):
        self._DeviceId = DeviceId

    @property
    def StartTime(self):
        """Start time, unit: seconds.
        :rtype: int
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """End time in seconds.
        :rtype: int
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._DeviceId = params.get("DeviceId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSessionStatisticsResponse(AbstractModel):
    """DescribeSessionStatistics response structure.

    """

    def __init__(self):
        r"""
        :param _SessionNum: Number of sessions.
        :type SessionNum: int
        :param _TotalDuration: Call duration, unit: minutes.
        :type TotalDuration: int
        :param _ActiveFieldDeviceNum: Number of active on-site devices.
        :type ActiveFieldDeviceNum: int
        :param _ActiveRemoteDeviceNum: Number of active remote devices.
        :type ActiveRemoteDeviceNum: int
        :param _NotBadSessionRatio: Proportion of excellent sessions, unit: %.
        :type NotBadSessionRatio: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SessionNum = None
        self._TotalDuration = None
        self._ActiveFieldDeviceNum = None
        self._ActiveRemoteDeviceNum = None
        self._NotBadSessionRatio = None
        self._RequestId = None

    @property
    def SessionNum(self):
        """Number of sessions.
        :rtype: int
        """
        return self._SessionNum

    @SessionNum.setter
    def SessionNum(self, SessionNum):
        self._SessionNum = SessionNum

    @property
    def TotalDuration(self):
        """Call duration, unit: minutes.
        :rtype: int
        """
        return self._TotalDuration

    @TotalDuration.setter
    def TotalDuration(self, TotalDuration):
        self._TotalDuration = TotalDuration

    @property
    def ActiveFieldDeviceNum(self):
        """Number of active on-site devices.
        :rtype: int
        """
        return self._ActiveFieldDeviceNum

    @ActiveFieldDeviceNum.setter
    def ActiveFieldDeviceNum(self, ActiveFieldDeviceNum):
        self._ActiveFieldDeviceNum = ActiveFieldDeviceNum

    @property
    def ActiveRemoteDeviceNum(self):
        """Number of active remote devices.
        :rtype: int
        """
        return self._ActiveRemoteDeviceNum

    @ActiveRemoteDeviceNum.setter
    def ActiveRemoteDeviceNum(self, ActiveRemoteDeviceNum):
        self._ActiveRemoteDeviceNum = ActiveRemoteDeviceNum

    @property
    def NotBadSessionRatio(self):
        """Proportion of excellent sessions, unit: %.
        :rtype: int
        """
        return self._NotBadSessionRatio

    @NotBadSessionRatio.setter
    def NotBadSessionRatio(self, NotBadSessionRatio):
        self._NotBadSessionRatio = NotBadSessionRatio

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SessionNum = params.get("SessionNum")
        self._TotalDuration = params.get("TotalDuration")
        self._ActiveFieldDeviceNum = params.get("ActiveFieldDeviceNum")
        self._ActiveRemoteDeviceNum = params.get("ActiveRemoteDeviceNum")
        self._NotBadSessionRatio = params.get("NotBadSessionRatio")
        self._RequestId = params.get("RequestId")


class Device(AbstractModel):
    """Query the authorization binding status of user devices

    """

    def __init__(self):
        r"""
        :param _DeviceId: Device id.
        :type DeviceId: str
        :param _DeviceName: Device name.
        :type DeviceName: str
        :param _LicenseCount: Number of bound licenses.
        :type LicenseCount: int
        :param _RemainDay: Remaining days: days.
        :type RemainDay: int
        :param _ExpireTime: Expiration time: s.
        :type ExpireTime: str
        :param _Duration: Service duration: s.
        :type Duration: str
        :param _LicenseIds: List of bound license ids.
        :type LicenseIds: list of str
        :param _MonthlyRemainTime: Monthly license duration limit.
        :type MonthlyRemainTime: int
        :param _LimitedTime: Monthly maximum duration (minutes).
        :type LimitedTime: int
        """
        self._DeviceId = None
        self._DeviceName = None
        self._LicenseCount = None
        self._RemainDay = None
        self._ExpireTime = None
        self._Duration = None
        self._LicenseIds = None
        self._MonthlyRemainTime = None
        self._LimitedTime = None

    @property
    def DeviceId(self):
        """Device id.
        :rtype: str
        """
        return self._DeviceId

    @DeviceId.setter
    def DeviceId(self, DeviceId):
        self._DeviceId = DeviceId

    @property
    def DeviceName(self):
        """Device name.
        :rtype: str
        """
        return self._DeviceName

    @DeviceName.setter
    def DeviceName(self, DeviceName):
        self._DeviceName = DeviceName

    @property
    def LicenseCount(self):
        """Number of bound licenses.
        :rtype: int
        """
        return self._LicenseCount

    @LicenseCount.setter
    def LicenseCount(self, LicenseCount):
        self._LicenseCount = LicenseCount

    @property
    def RemainDay(self):
        """Remaining days: days.
        :rtype: int
        """
        return self._RemainDay

    @RemainDay.setter
    def RemainDay(self, RemainDay):
        self._RemainDay = RemainDay

    @property
    def ExpireTime(self):
        """Expiration time: s.
        :rtype: str
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def Duration(self):
        """Service duration: s.
        :rtype: str
        """
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration

    @property
    def LicenseIds(self):
        """List of bound license ids.
        :rtype: list of str
        """
        return self._LicenseIds

    @LicenseIds.setter
    def LicenseIds(self, LicenseIds):
        self._LicenseIds = LicenseIds

    @property
    def MonthlyRemainTime(self):
        """Monthly license duration limit.
        :rtype: int
        """
        return self._MonthlyRemainTime

    @MonthlyRemainTime.setter
    def MonthlyRemainTime(self, MonthlyRemainTime):
        self._MonthlyRemainTime = MonthlyRemainTime

    @property
    def LimitedTime(self):
        """Monthly maximum duration (minutes).
        :rtype: int
        """
        return self._LimitedTime

    @LimitedTime.setter
    def LimitedTime(self, LimitedTime):
        self._LimitedTime = LimitedTime


    def _deserialize(self, params):
        self._DeviceId = params.get("DeviceId")
        self._DeviceName = params.get("DeviceName")
        self._LicenseCount = params.get("LicenseCount")
        self._RemainDay = params.get("RemainDay")
        self._ExpireTime = params.get("ExpireTime")
        self._Duration = params.get("Duration")
        self._LicenseIds = params.get("LicenseIds")
        self._MonthlyRemainTime = params.get("MonthlyRemainTime")
        self._LimitedTime = params.get("LimitedTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetDeviceLicenseRequest(AbstractModel):
    """GetDeviceLicense request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project id to which the target device belongs.
        :type ProjectId: str
        :param _DeviceId: Target device id.
        :type DeviceId: str
        """
        self._ProjectId = None
        self._DeviceId = None

    @property
    def ProjectId(self):
        """Project id to which the target device belongs.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def DeviceId(self):
        """Target device id.
        :rtype: str
        """
        return self._DeviceId

    @DeviceId.setter
    def DeviceId(self, DeviceId):
        self._DeviceId = DeviceId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._DeviceId = params.get("DeviceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetDeviceLicenseResponse(AbstractModel):
    """GetDeviceLicense response structure.

    """

    def __init__(self):
        r"""
        :param _AvailableCount: Specifies the number of available licenses bound to the specified device.
        :type AvailableCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._AvailableCount = None
        self._RequestId = None

    @property
    def AvailableCount(self):
        """Specifies the number of available licenses bound to the specified device.
        :rtype: int
        """
        return self._AvailableCount

    @AvailableCount.setter
    def AvailableCount(self, AvailableCount):
        self._AvailableCount = AvailableCount

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AvailableCount = params.get("AvailableCount")
        self._RequestId = params.get("RequestId")


class GetDevicesRequest(AbstractModel):
    """GetDevices request structure.

    """

    def __init__(self):
        r"""
        :param _PageNum: Page number.
        :type PageNum: int
        :param _PageSize: Number of pages.
        :type PageSize: int
        :param _ProjectId: Project id.
        :type ProjectId: str
        :param _DeviceId: Device id.
        :type DeviceId: str
        """
        self._PageNum = None
        self._PageSize = None
        self._ProjectId = None
        self._DeviceId = None

    @property
    def PageNum(self):
        """Page number.
        :rtype: int
        """
        return self._PageNum

    @PageNum.setter
    def PageNum(self, PageNum):
        self._PageNum = PageNum

    @property
    def PageSize(self):
        """Number of pages.
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def ProjectId(self):
        """Project id.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def DeviceId(self):
        """Device id.
        :rtype: str
        """
        return self._DeviceId

    @DeviceId.setter
    def DeviceId(self, DeviceId):
        self._DeviceId = DeviceId


    def _deserialize(self, params):
        self._PageNum = params.get("PageNum")
        self._PageSize = params.get("PageSize")
        self._ProjectId = params.get("ProjectId")
        self._DeviceId = params.get("DeviceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetDevicesResponse(AbstractModel):
    """GetDevices response structure.

    """

    def __init__(self):
        r"""
        :param _Devices: Device authorization list.
        :type Devices: list of Device
        :param _TotalCount: Number of tables in the list.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Devices = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def Devices(self):
        """Device authorization list.
        :rtype: list of Device
        """
        return self._Devices

    @Devices.setter
    def Devices(self, Devices):
        self._Devices = Devices

    @property
    def TotalCount(self):
        """Number of tables in the list.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Devices") is not None:
            self._Devices = []
            for item in params.get("Devices"):
                obj = Device()
                obj._deserialize(item)
                self._Devices.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class GetLicenseStatRequest(AbstractModel):
    """GetLicenseStat request structure.

    """


class GetLicenseStatResponse(AbstractModel):
    """GetLicenseStat response structure.

    """

    def __init__(self):
        r"""
        :param _Valid: Valid authorization.
        :type Valid: int
        :param _Bound: Bound authorization.
        :type Bound: int
        :param _UnBound: Unbound authorization.
        :type UnBound: int
        :param _Expire: Expired authorization.
        :type Expire: int
        :param _MonthlyExpire: Number of authorization timeouts for the current month.
        :type MonthlyExpire: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Valid = None
        self._Bound = None
        self._UnBound = None
        self._Expire = None
        self._MonthlyExpire = None
        self._RequestId = None

    @property
    def Valid(self):
        """Valid authorization.
        :rtype: int
        """
        return self._Valid

    @Valid.setter
    def Valid(self, Valid):
        self._Valid = Valid

    @property
    def Bound(self):
        """Bound authorization.
        :rtype: int
        """
        return self._Bound

    @Bound.setter
    def Bound(self, Bound):
        self._Bound = Bound

    @property
    def UnBound(self):
        """Unbound authorization.
        :rtype: int
        """
        return self._UnBound

    @UnBound.setter
    def UnBound(self, UnBound):
        self._UnBound = UnBound

    @property
    def Expire(self):
        """Expired authorization.
        :rtype: int
        """
        return self._Expire

    @Expire.setter
    def Expire(self, Expire):
        self._Expire = Expire

    @property
    def MonthlyExpire(self):
        """Number of authorization timeouts for the current month.
        :rtype: int
        """
        return self._MonthlyExpire

    @MonthlyExpire.setter
    def MonthlyExpire(self, MonthlyExpire):
        self._MonthlyExpire = MonthlyExpire

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Valid = params.get("Valid")
        self._Bound = params.get("Bound")
        self._UnBound = params.get("UnBound")
        self._Expire = params.get("Expire")
        self._MonthlyExpire = params.get("MonthlyExpire")
        self._RequestId = params.get("RequestId")


class GetLicensesRequest(AbstractModel):
    """GetLicenses request structure.

    """

    def __init__(self):
        r"""
        :param _PageNum: Page number.
        :type PageNum: int
        :param _PageSize: Number of pages.
        :type PageSize: int
        :param _ProjectId: projectId
        :type ProjectId: str
        :param _DeviceId: DeviceId
        :type DeviceId: str
        :param _Status: License status. 0: unbound; 1: bound; 2: service suspension; 3: refund.
        :type Status: int
        """
        self._PageNum = None
        self._PageSize = None
        self._ProjectId = None
        self._DeviceId = None
        self._Status = None

    @property
    def PageNum(self):
        """Page number.
        :rtype: int
        """
        return self._PageNum

    @PageNum.setter
    def PageNum(self, PageNum):
        self._PageNum = PageNum

    @property
    def PageSize(self):
        """Number of pages.
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def ProjectId(self):
        """projectId
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def DeviceId(self):
        """DeviceId
        :rtype: str
        """
        return self._DeviceId

    @DeviceId.setter
    def DeviceId(self, DeviceId):
        self._DeviceId = DeviceId

    @property
    def Status(self):
        """License status. 0: unbound; 1: bound; 2: service suspension; 3: refund.
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._PageNum = params.get("PageNum")
        self._PageSize = params.get("PageSize")
        self._ProjectId = params.get("ProjectId")
        self._DeviceId = params.get("DeviceId")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetLicensesResponse(AbstractModel):
    """GetLicenses response structure.

    """

    def __init__(self):
        r"""
        :param _Licenses: License list.
        :type Licenses: list of License
        :param _TotalCount: Number of license list items.
        :type TotalCount: int
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Licenses = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def Licenses(self):
        """License list.
        :rtype: list of License
        """
        return self._Licenses

    @Licenses.setter
    def Licenses(self, Licenses):
        self._Licenses = Licenses

    @property
    def TotalCount(self):
        """Number of license list items.
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Licenses") is not None:
            self._Licenses = []
            for item in params.get("Licenses"):
                obj = License()
                obj._deserialize(item)
                self._Licenses.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class License(AbstractModel):
    """License list viewed by authorization

    """

    def __init__(self):
        r"""
        :param _Count: The number of licenses of this type.
        :type Count: int
        :param _Status: License status. 0: unbound; 1: bound; 2: service suspension; 3: refund.
        :type Status: int
        :param _ExpireTime: Expiration timestamp: s.
        :type ExpireTime: str
        :param _Duration: Service duration: s.
        :type Duration: str
        :param _RemainDay: Remaining days: days.
        :type RemainDay: int
        :param _LicenseIds: The list of license ids of this type.
        :type LicenseIds: list of str
        """
        self._Count = None
        self._Status = None
        self._ExpireTime = None
        self._Duration = None
        self._RemainDay = None
        self._LicenseIds = None

    @property
    def Count(self):
        """The number of licenses of this type.
        :rtype: int
        """
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def Status(self):
        """License status. 0: unbound; 1: bound; 2: service suspension; 3: refund.
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ExpireTime(self):
        """Expiration timestamp: s.
        :rtype: str
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def Duration(self):
        """Service duration: s.
        :rtype: str
        """
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration

    @property
    def RemainDay(self):
        """Remaining days: days.
        :rtype: int
        """
        return self._RemainDay

    @RemainDay.setter
    def RemainDay(self, RemainDay):
        self._RemainDay = RemainDay

    @property
    def LicenseIds(self):
        """The list of license ids of this type.
        :rtype: list of str
        """
        return self._LicenseIds

    @LicenseIds.setter
    def LicenseIds(self, LicenseIds):
        self._LicenseIds = LicenseIds


    def _deserialize(self, params):
        self._Count = params.get("Count")
        self._Status = params.get("Status")
        self._ExpireTime = params.get("ExpireTime")
        self._Duration = params.get("Duration")
        self._RemainDay = params.get("RemainDay")
        self._LicenseIds = params.get("LicenseIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyDeviceRequest(AbstractModel):
    """ModifyDevice request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: The target project id to modify the device's affiliated project.
        :type ProjectId: str
        :param _DeviceId: The target device id to modify the device.
        :type DeviceId: str
        :param _DeviceName: The modified device name; if not filled in, no modification will be made.
        :type DeviceName: str
        :param _DeviceToken: The modified device authentication password; if not filled in, no modification will be made.
        :type DeviceToken: str
        """
        self._ProjectId = None
        self._DeviceId = None
        self._DeviceName = None
        self._DeviceToken = None

    @property
    def ProjectId(self):
        """The target project id to modify the device's affiliated project.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def DeviceId(self):
        """The target device id to modify the device.
        :rtype: str
        """
        return self._DeviceId

    @DeviceId.setter
    def DeviceId(self, DeviceId):
        self._DeviceId = DeviceId

    @property
    def DeviceName(self):
        """The modified device name; if not filled in, no modification will be made.
        :rtype: str
        """
        return self._DeviceName

    @DeviceName.setter
    def DeviceName(self, DeviceName):
        self._DeviceName = DeviceName

    @property
    def DeviceToken(self):
        """The modified device authentication password; if not filled in, no modification will be made.
        :rtype: str
        """
        return self._DeviceToken

    @DeviceToken.setter
    def DeviceToken(self, DeviceToken):
        self._DeviceToken = DeviceToken


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._DeviceId = params.get("DeviceId")
        self._DeviceName = params.get("DeviceName")
        self._DeviceToken = params.get("DeviceToken")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyDeviceResponse(AbstractModel):
    """ModifyDevice response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyPolicyRequest(AbstractModel):
    """ModifyPolicy request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project id for modifying permission configuration.
        :type ProjectId: str
        :param _RemoteDeviceId: Remote device id for modifying permission configuration.
        :type RemoteDeviceId: str
        :param _FieldDeviceIds: Array of on-site device ids involved in permission modification.
        :type FieldDeviceIds: list of str
        :param _PolicyMode: The target permission mode to modify, black for blocklist, white for allowlist.
        :type PolicyMode: str
        :param _ModifyMode: Modification mode, add for adding (associating on-site devices), remove for deletion (dissociating on-site devices), set for setting (updating on-site device association).
        :type ModifyMode: str
        """
        self._ProjectId = None
        self._RemoteDeviceId = None
        self._FieldDeviceIds = None
        self._PolicyMode = None
        self._ModifyMode = None

    @property
    def ProjectId(self):
        """Project id for modifying permission configuration.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def RemoteDeviceId(self):
        """Remote device id for modifying permission configuration.
        :rtype: str
        """
        return self._RemoteDeviceId

    @RemoteDeviceId.setter
    def RemoteDeviceId(self, RemoteDeviceId):
        self._RemoteDeviceId = RemoteDeviceId

    @property
    def FieldDeviceIds(self):
        """Array of on-site device ids involved in permission modification.
        :rtype: list of str
        """
        return self._FieldDeviceIds

    @FieldDeviceIds.setter
    def FieldDeviceIds(self, FieldDeviceIds):
        self._FieldDeviceIds = FieldDeviceIds

    @property
    def PolicyMode(self):
        """The target permission mode to modify, black for blocklist, white for allowlist.
        :rtype: str
        """
        return self._PolicyMode

    @PolicyMode.setter
    def PolicyMode(self, PolicyMode):
        self._PolicyMode = PolicyMode

    @property
    def ModifyMode(self):
        """Modification mode, add for adding (associating on-site devices), remove for deletion (dissociating on-site devices), set for setting (updating on-site device association).
        :rtype: str
        """
        return self._ModifyMode

    @ModifyMode.setter
    def ModifyMode(self, ModifyMode):
        self._ModifyMode = ModifyMode


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._RemoteDeviceId = params.get("RemoteDeviceId")
        self._FieldDeviceIds = params.get("FieldDeviceIds")
        self._PolicyMode = params.get("PolicyMode")
        self._ModifyMode = params.get("ModifyMode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyPolicyResponse(AbstractModel):
    """ModifyPolicy response structure.

    """

    def __init__(self):
        r"""
        :param _FailedInsertIds: List of on-site device ids with association failed.
        :type FailedInsertIds: list of str
        :param _FailedDeleteIds: List of on-site device ids with disassociation failed.
        :type FailedDeleteIds: list of str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FailedInsertIds = None
        self._FailedDeleteIds = None
        self._RequestId = None

    @property
    def FailedInsertIds(self):
        """List of on-site device ids with association failed.
        :rtype: list of str
        """
        return self._FailedInsertIds

    @FailedInsertIds.setter
    def FailedInsertIds(self, FailedInsertIds):
        self._FailedInsertIds = FailedInsertIds

    @property
    def FailedDeleteIds(self):
        """List of on-site device ids with disassociation failed.
        :rtype: list of str
        """
        return self._FailedDeleteIds

    @FailedDeleteIds.setter
    def FailedDeleteIds(self, FailedDeleteIds):
        self._FailedDeleteIds = FailedDeleteIds

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FailedInsertIds = params.get("FailedInsertIds")
        self._FailedDeleteIds = params.get("FailedDeleteIds")
        self._RequestId = params.get("RequestId")


class ModifyProjectRequest(AbstractModel):
    """ModifyProject request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project id of the target project to modify.
        :type ProjectId: str
        :param _ProjectName: Modified project name, leave blank if not modifying.
        :type ProjectName: str
        :param _ProjectDescription: Modified project description, leave blank if not modifying.
        :type ProjectDescription: str
        :param _PolicyMode: The modified permission mode, black for blocklist, white for allowlist. if not specified, no modification will be made.
        :type PolicyMode: str
        """
        self._ProjectId = None
        self._ProjectName = None
        self._ProjectDescription = None
        self._PolicyMode = None

    @property
    def ProjectId(self):
        """Project id of the target project to modify.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ProjectName(self):
        """Modified project name, leave blank if not modifying.
        :rtype: str
        """
        return self._ProjectName

    @ProjectName.setter
    def ProjectName(self, ProjectName):
        self._ProjectName = ProjectName

    @property
    def ProjectDescription(self):
        """Modified project description, leave blank if not modifying.
        :rtype: str
        """
        return self._ProjectDescription

    @ProjectDescription.setter
    def ProjectDescription(self, ProjectDescription):
        self._ProjectDescription = ProjectDescription

    @property
    def PolicyMode(self):
        """The modified permission mode, black for blocklist, white for allowlist. if not specified, no modification will be made.
        :rtype: str
        """
        return self._PolicyMode

    @PolicyMode.setter
    def PolicyMode(self, PolicyMode):
        self._PolicyMode = PolicyMode


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._ProjectName = params.get("ProjectName")
        self._ProjectDescription = params.get("ProjectDescription")
        self._PolicyMode = params.get("PolicyMode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyProjectResponse(AbstractModel):
    """ModifyProject response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ProjectInfo(AbstractModel):
    """Project information.

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project id.
        :type ProjectId: str
        :param _ProjectName: Project name.
        :type ProjectName: str
        :param _ProjectDescription: Project description.
        :type ProjectDescription: str
        :param _PolicyMode: Project permission mode, black for blocklist, white for allowlist.
        :type PolicyMode: str
        :param _ModifyTime: Project information modification time.
        :type ModifyTime: str
        """
        self._ProjectId = None
        self._ProjectName = None
        self._ProjectDescription = None
        self._PolicyMode = None
        self._ModifyTime = None

    @property
    def ProjectId(self):
        """Project id.
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ProjectName(self):
        """Project name.
        :rtype: str
        """
        return self._ProjectName

    @ProjectName.setter
    def ProjectName(self, ProjectName):
        self._ProjectName = ProjectName

    @property
    def ProjectDescription(self):
        """Project description.
        :rtype: str
        """
        return self._ProjectDescription

    @ProjectDescription.setter
    def ProjectDescription(self, ProjectDescription):
        self._ProjectDescription = ProjectDescription

    @property
    def PolicyMode(self):
        """Project permission mode, black for blocklist, white for allowlist.
        :rtype: str
        """
        return self._PolicyMode

    @PolicyMode.setter
    def PolicyMode(self, PolicyMode):
        self._PolicyMode = PolicyMode

    @property
    def ModifyTime(self):
        """Project information modification time.
        :rtype: str
        """
        return self._ModifyTime

    @ModifyTime.setter
    def ModifyTime(self, ModifyTime):
        self._ModifyTime = ModifyTime


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._ProjectName = params.get("ProjectName")
        self._ProjectDescription = params.get("ProjectDescription")
        self._PolicyMode = params.get("PolicyMode")
        self._ModifyTime = params.get("ModifyTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RecentSessionInfo(AbstractModel):
    """Latest session information

    """

    def __init__(self):
        r"""
        :param _SessionId: Session id.
        :type SessionId: str
        :param _RemoteDeviceId: Remote device id.
        :type RemoteDeviceId: str
        :param _FieldDeviceId: On-Site device id.
        :type FieldDeviceId: str
        :param _Resolution: Target resolution.
        :type Resolution: str
        :param _StartTime: Session start time.
        :type StartTime: int
        :param _LatestUpdateTime: Last updated time.
        :type LatestUpdateTime: int
        """
        self._SessionId = None
        self._RemoteDeviceId = None
        self._FieldDeviceId = None
        self._Resolution = None
        self._StartTime = None
        self._LatestUpdateTime = None

    @property
    def SessionId(self):
        """Session id.
        :rtype: str
        """
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def RemoteDeviceId(self):
        """Remote device id.
        :rtype: str
        """
        return self._RemoteDeviceId

    @RemoteDeviceId.setter
    def RemoteDeviceId(self, RemoteDeviceId):
        self._RemoteDeviceId = RemoteDeviceId

    @property
    def FieldDeviceId(self):
        """On-Site device id.
        :rtype: str
        """
        return self._FieldDeviceId

    @FieldDeviceId.setter
    def FieldDeviceId(self, FieldDeviceId):
        self._FieldDeviceId = FieldDeviceId

    @property
    def Resolution(self):
        """Target resolution.
        :rtype: str
        """
        return self._Resolution

    @Resolution.setter
    def Resolution(self, Resolution):
        self._Resolution = Resolution

    @property
    def StartTime(self):
        """Session start time.
        :rtype: int
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def LatestUpdateTime(self):
        """Last updated time.
        :rtype: int
        """
        return self._LatestUpdateTime

    @LatestUpdateTime.setter
    def LatestUpdateTime(self, LatestUpdateTime):
        self._LatestUpdateTime = LatestUpdateTime


    def _deserialize(self, params):
        self._SessionId = params.get("SessionId")
        self._RemoteDeviceId = params.get("RemoteDeviceId")
        self._FieldDeviceId = params.get("FieldDeviceId")
        self._Resolution = params.get("Resolution")
        self._StartTime = params.get("StartTime")
        self._LatestUpdateTime = params.get("LatestUpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SessionInfo(AbstractModel):
    """Session information.

    """

    def __init__(self):
        r"""
        :param _SessionId: Session id.
        :type SessionId: str
        :param _RemoteDeviceId: Remote device id.
        :type RemoteDeviceId: str
        :param _FieldDeviceId: On-Site device id.
        :type FieldDeviceId: str
        :param _Resolution: Target resolution.
        :type Resolution: str
        :param _StartTime: Session start time.
        :type StartTime: int
        :param _EndTime: Session end time.
        :type EndTime: int
        :param _Quality: Call quality: good|normal|bad.
        :type Quality: str
        """
        self._SessionId = None
        self._RemoteDeviceId = None
        self._FieldDeviceId = None
        self._Resolution = None
        self._StartTime = None
        self._EndTime = None
        self._Quality = None

    @property
    def SessionId(self):
        """Session id.
        :rtype: str
        """
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def RemoteDeviceId(self):
        """Remote device id.
        :rtype: str
        """
        return self._RemoteDeviceId

    @RemoteDeviceId.setter
    def RemoteDeviceId(self, RemoteDeviceId):
        self._RemoteDeviceId = RemoteDeviceId

    @property
    def FieldDeviceId(self):
        """On-Site device id.
        :rtype: str
        """
        return self._FieldDeviceId

    @FieldDeviceId.setter
    def FieldDeviceId(self, FieldDeviceId):
        self._FieldDeviceId = FieldDeviceId

    @property
    def Resolution(self):
        """Target resolution.
        :rtype: str
        """
        return self._Resolution

    @Resolution.setter
    def Resolution(self, Resolution):
        self._Resolution = Resolution

    @property
    def StartTime(self):
        """Session start time.
        :rtype: int
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """Session end time.
        :rtype: int
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Quality(self):
        """Call quality: good|normal|bad.
        :rtype: str
        """
        return self._Quality

    @Quality.setter
    def Quality(self, Quality):
        self._Quality = Quality


    def _deserialize(self, params):
        self._SessionId = params.get("SessionId")
        self._RemoteDeviceId = params.get("RemoteDeviceId")
        self._FieldDeviceId = params.get("FieldDeviceId")
        self._Resolution = params.get("Resolution")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Quality = params.get("Quality")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SessionIntervalStatistic(AbstractModel):
    """Session statistics data in a unit time interval

    """

    def __init__(self):
        r"""
        :param _ActiveFieldDeviceNum: Number of active on-site devices.
        :type ActiveFieldDeviceNum: int
        :param _ActiveRemoteDeviceNum: Number of active remote devices.
        :type ActiveRemoteDeviceNum: int
        :param _SessionNum: Number of sessions.
        :type SessionNum: int
        :param _TotalDuration: Session age, unit: minutes.
        :type TotalDuration: int
        :param _StartTime: Timestamp in seconds.
        :type StartTime: int
        :param _EndTime: Timestamp in seconds.
        :type EndTime: int
        :param _NotBadSessionRatio: Proportion of excellent sessions, unit: %.
        :type NotBadSessionRatio: int
        """
        self._ActiveFieldDeviceNum = None
        self._ActiveRemoteDeviceNum = None
        self._SessionNum = None
        self._TotalDuration = None
        self._StartTime = None
        self._EndTime = None
        self._NotBadSessionRatio = None

    @property
    def ActiveFieldDeviceNum(self):
        """Number of active on-site devices.
        :rtype: int
        """
        return self._ActiveFieldDeviceNum

    @ActiveFieldDeviceNum.setter
    def ActiveFieldDeviceNum(self, ActiveFieldDeviceNum):
        self._ActiveFieldDeviceNum = ActiveFieldDeviceNum

    @property
    def ActiveRemoteDeviceNum(self):
        """Number of active remote devices.
        :rtype: int
        """
        return self._ActiveRemoteDeviceNum

    @ActiveRemoteDeviceNum.setter
    def ActiveRemoteDeviceNum(self, ActiveRemoteDeviceNum):
        self._ActiveRemoteDeviceNum = ActiveRemoteDeviceNum

    @property
    def SessionNum(self):
        """Number of sessions.
        :rtype: int
        """
        return self._SessionNum

    @SessionNum.setter
    def SessionNum(self, SessionNum):
        self._SessionNum = SessionNum

    @property
    def TotalDuration(self):
        """Session age, unit: minutes.
        :rtype: int
        """
        return self._TotalDuration

    @TotalDuration.setter
    def TotalDuration(self, TotalDuration):
        self._TotalDuration = TotalDuration

    @property
    def StartTime(self):
        """Timestamp in seconds.
        :rtype: int
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """Timestamp in seconds.
        :rtype: int
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def NotBadSessionRatio(self):
        """Proportion of excellent sessions, unit: %.
        :rtype: int
        """
        return self._NotBadSessionRatio

    @NotBadSessionRatio.setter
    def NotBadSessionRatio(self, NotBadSessionRatio):
        self._NotBadSessionRatio = NotBadSessionRatio


    def _deserialize(self, params):
        self._ActiveFieldDeviceNum = params.get("ActiveFieldDeviceNum")
        self._ActiveRemoteDeviceNum = params.get("ActiveRemoteDeviceNum")
        self._SessionNum = params.get("SessionNum")
        self._TotalDuration = params.get("TotalDuration")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._NotBadSessionRatio = params.get("NotBadSessionRatio")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        