# -*- coding: utf8 -*-
# Copyright (c) 2017-2025 Tencent. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class DescribeFabricBlockRequest(AbstractModel):
    """DescribeFabricBlock request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID, which can be obtained from the blockchain cluster details or in the list.
        :type ClusterId: str
        :param _ChannelId: Channel ID, which can be obtained from the channel list or channel detail.
        :type ChannelId: str
        :param _BlockHeight: Block height, starting from 0.
        :type BlockHeight: int
        """
        self._ClusterId = None
        self._ChannelId = None
        self._BlockHeight = None

    @property
    def ClusterId(self):
        """Cluster ID, which can be obtained from the blockchain cluster details or in the list.
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ChannelId(self):
        """Channel ID, which can be obtained from the channel list or channel detail.
        :rtype: str
        """
        return self._ChannelId

    @ChannelId.setter
    def ChannelId(self, ChannelId):
        self._ChannelId = ChannelId

    @property
    def BlockHeight(self):
        """Block height, starting from 0.
        :rtype: int
        """
        return self._BlockHeight

    @BlockHeight.setter
    def BlockHeight(self, BlockHeight):
        self._BlockHeight = BlockHeight


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ChannelId = params.get("ChannelId")
        self._BlockHeight = params.get("BlockHeight")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFabricBlockResponse(AbstractModel):
    """DescribeFabricBlock response structure.

    """

    def __init__(self):
        r"""
        :param _BlockHeight: Block height.
        :type BlockHeight: int
        :param _BlockHash: Block Hash.
        :type BlockHash: str
        :param _PreBlockHash: Pre-Block Hash.
        :type PreBlockHash: str
        :param _TxCount: The number of transactions in a block.
        :type TxCount: int
        :param _TransactionList: Transaction list in the block.
        :type TransactionList: list of Transaction
        :param _CreateTimestamp: Creation Timestamp
        :type CreateTimestamp: str
        :param _ProposerOrg: Proposal organization.
        :type ProposerOrg: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._BlockHeight = None
        self._BlockHash = None
        self._PreBlockHash = None
        self._TxCount = None
        self._TransactionList = None
        self._CreateTimestamp = None
        self._ProposerOrg = None
        self._RequestId = None

    @property
    def BlockHeight(self):
        """Block height.
        :rtype: int
        """
        return self._BlockHeight

    @BlockHeight.setter
    def BlockHeight(self, BlockHeight):
        self._BlockHeight = BlockHeight

    @property
    def BlockHash(self):
        """Block Hash.
        :rtype: str
        """
        return self._BlockHash

    @BlockHash.setter
    def BlockHash(self, BlockHash):
        self._BlockHash = BlockHash

    @property
    def PreBlockHash(self):
        """Pre-Block Hash.
        :rtype: str
        """
        return self._PreBlockHash

    @PreBlockHash.setter
    def PreBlockHash(self, PreBlockHash):
        self._PreBlockHash = PreBlockHash

    @property
    def TxCount(self):
        """The number of transactions in a block.
        :rtype: int
        """
        return self._TxCount

    @TxCount.setter
    def TxCount(self, TxCount):
        self._TxCount = TxCount

    @property
    def TransactionList(self):
        """Transaction list in the block.
        :rtype: list of Transaction
        """
        return self._TransactionList

    @TransactionList.setter
    def TransactionList(self, TransactionList):
        self._TransactionList = TransactionList

    @property
    def CreateTimestamp(self):
        """Creation Timestamp
        :rtype: str
        """
        return self._CreateTimestamp

    @CreateTimestamp.setter
    def CreateTimestamp(self, CreateTimestamp):
        self._CreateTimestamp = CreateTimestamp

    @property
    def ProposerOrg(self):
        """Proposal organization.
        :rtype: str
        """
        return self._ProposerOrg

    @ProposerOrg.setter
    def ProposerOrg(self, ProposerOrg):
        self._ProposerOrg = ProposerOrg

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._BlockHeight = params.get("BlockHeight")
        self._BlockHash = params.get("BlockHash")
        self._PreBlockHash = params.get("PreBlockHash")
        self._TxCount = params.get("TxCount")
        if params.get("TransactionList") is not None:
            self._TransactionList = []
            for item in params.get("TransactionList"):
                obj = Transaction()
                obj._deserialize(item)
                self._TransactionList.append(obj)
        self._CreateTimestamp = params.get("CreateTimestamp")
        self._ProposerOrg = params.get("ProposerOrg")
        self._RequestId = params.get("RequestId")


class DescribeFabricTransactionRequest(AbstractModel):
    """DescribeFabricTransaction request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID, which can be obtained from the blockchain cluster details or in the list.
        :type ClusterId: str
        :param _ChannelId: Channel ID, which can be obtained from the channel list or channel detail.
        :type ChannelId: str
        :param _TxId: Transaction ID
        :type TxId: str
        """
        self._ClusterId = None
        self._ChannelId = None
        self._TxId = None

    @property
    def ClusterId(self):
        """Cluster ID, which can be obtained from the blockchain cluster details or in the list.
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ChannelId(self):
        """Channel ID, which can be obtained from the channel list or channel detail.
        :rtype: str
        """
        return self._ChannelId

    @ChannelId.setter
    def ChannelId(self, ChannelId):
        self._ChannelId = ChannelId

    @property
    def TxId(self):
        """Transaction ID
        :rtype: str
        """
        return self._TxId

    @TxId.setter
    def TxId(self, TxId):
        self._TxId = TxId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ChannelId = params.get("ChannelId")
        self._TxId = params.get("TxId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFabricTransactionResponse(AbstractModel):
    """DescribeFabricTransaction response structure.

    """

    def __init__(self):
        r"""
        :param _TxId: Transaction ID
        :type TxId: str
        :param _TxHash: Transaction Hash.
        :type TxHash: str
        :param _TxStatus: Transaction status.
        :type TxStatus: str
        :param _JoinOrgList: Organization list involved.
        :type JoinOrgList: list of str
        :param _Sender: Transaction sender.
        :type Sender: str
        :param _CreateTime: Creation time
        :type CreateTime: str
        :param _BlockHeight: Block height.
        :type BlockHeight: int
        :param _ChaincodeName: The contract to which the exchange belongs.
        :type ChaincodeName: str
        :param _TransactionData: Transaction data, base64 encoded, decoded as a json string.
        :type TransactionData: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TxId = None
        self._TxHash = None
        self._TxStatus = None
        self._JoinOrgList = None
        self._Sender = None
        self._CreateTime = None
        self._BlockHeight = None
        self._ChaincodeName = None
        self._TransactionData = None
        self._RequestId = None

    @property
    def TxId(self):
        """Transaction ID
        :rtype: str
        """
        return self._TxId

    @TxId.setter
    def TxId(self, TxId):
        self._TxId = TxId

    @property
    def TxHash(self):
        """Transaction Hash.
        :rtype: str
        """
        return self._TxHash

    @TxHash.setter
    def TxHash(self, TxHash):
        self._TxHash = TxHash

    @property
    def TxStatus(self):
        """Transaction status.
        :rtype: str
        """
        return self._TxStatus

    @TxStatus.setter
    def TxStatus(self, TxStatus):
        self._TxStatus = TxStatus

    @property
    def JoinOrgList(self):
        """Organization list involved.
        :rtype: list of str
        """
        return self._JoinOrgList

    @JoinOrgList.setter
    def JoinOrgList(self, JoinOrgList):
        self._JoinOrgList = JoinOrgList

    @property
    def Sender(self):
        """Transaction sender.
        :rtype: str
        """
        return self._Sender

    @Sender.setter
    def Sender(self, Sender):
        self._Sender = Sender

    @property
    def CreateTime(self):
        """Creation time
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def BlockHeight(self):
        """Block height.
        :rtype: int
        """
        return self._BlockHeight

    @BlockHeight.setter
    def BlockHeight(self, BlockHeight):
        self._BlockHeight = BlockHeight

    @property
    def ChaincodeName(self):
        """The contract to which the exchange belongs.
        :rtype: str
        """
        return self._ChaincodeName

    @ChaincodeName.setter
    def ChaincodeName(self, ChaincodeName):
        self._ChaincodeName = ChaincodeName

    @property
    def TransactionData(self):
        """Transaction data, base64 encoded, decoded as a json string.
        :rtype: str
        """
        return self._TransactionData

    @TransactionData.setter
    def TransactionData(self, TransactionData):
        self._TransactionData = TransactionData

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TxId = params.get("TxId")
        self._TxHash = params.get("TxHash")
        self._TxStatus = params.get("TxStatus")
        self._JoinOrgList = params.get("JoinOrgList")
        self._Sender = params.get("Sender")
        self._CreateTime = params.get("CreateTime")
        self._BlockHeight = params.get("BlockHeight")
        self._ChaincodeName = params.get("ChaincodeName")
        self._TransactionData = params.get("TransactionData")
        self._RequestId = params.get("RequestId")


class InvokeFabricChaincodeRequest(AbstractModel):
    """InvokeFabricChaincode request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID, which can be obtained from the blockchain cluster details.
        :type ClusterId: str
        :param _ChannelId: Channel ID, which can be obtained from the channel list or channel detail.
        :type ChannelId: str
        :param _ChaincodeName: Contract name. it can be obtained from the contract list or contract details.
        :type ChaincodeName: str
        :param _FuncName: Contract method.
        :type FuncName: str
        :param _FuncParam: Contract method input parameter.
        :type FuncParam: list of str
        :param _WithAsyncResult: Whether to execute asynchronously. if so, use the transaction TxID in the return value to query the execution result.
        :type WithAsyncResult: bool
        """
        self._ClusterId = None
        self._ChannelId = None
        self._ChaincodeName = None
        self._FuncName = None
        self._FuncParam = None
        self._WithAsyncResult = None

    @property
    def ClusterId(self):
        """Cluster ID, which can be obtained from the blockchain cluster details.
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ChannelId(self):
        """Channel ID, which can be obtained from the channel list or channel detail.
        :rtype: str
        """
        return self._ChannelId

    @ChannelId.setter
    def ChannelId(self, ChannelId):
        self._ChannelId = ChannelId

    @property
    def ChaincodeName(self):
        """Contract name. it can be obtained from the contract list or contract details.
        :rtype: str
        """
        return self._ChaincodeName

    @ChaincodeName.setter
    def ChaincodeName(self, ChaincodeName):
        self._ChaincodeName = ChaincodeName

    @property
    def FuncName(self):
        """Contract method.
        :rtype: str
        """
        return self._FuncName

    @FuncName.setter
    def FuncName(self, FuncName):
        self._FuncName = FuncName

    @property
    def FuncParam(self):
        """Contract method input parameter.
        :rtype: list of str
        """
        return self._FuncParam

    @FuncParam.setter
    def FuncParam(self, FuncParam):
        self._FuncParam = FuncParam

    @property
    def WithAsyncResult(self):
        """Whether to execute asynchronously. if so, use the transaction TxID in the return value to query the execution result.
        :rtype: bool
        """
        return self._WithAsyncResult

    @WithAsyncResult.setter
    def WithAsyncResult(self, WithAsyncResult):
        self._WithAsyncResult = WithAsyncResult


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ChannelId = params.get("ChannelId")
        self._ChaincodeName = params.get("ChaincodeName")
        self._FuncName = params.get("FuncName")
        self._FuncParam = params.get("FuncParam")
        self._WithAsyncResult = params.get("WithAsyncResult")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InvokeFabricChaincodeResponse(AbstractModel):
    """InvokeFabricChaincode response structure.

    """

    def __init__(self):
        r"""
        :param _TxId: Transaction ID
        :type TxId: str
        :param _TxStatus: Transaction status.
        :type TxStatus: str
        :param _TxResult: Transaction result.
        :type TxResult: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TxId = None
        self._TxStatus = None
        self._TxResult = None
        self._RequestId = None

    @property
    def TxId(self):
        """Transaction ID
        :rtype: str
        """
        return self._TxId

    @TxId.setter
    def TxId(self, TxId):
        self._TxId = TxId

    @property
    def TxStatus(self):
        """Transaction status.
        :rtype: str
        """
        return self._TxStatus

    @TxStatus.setter
    def TxStatus(self, TxStatus):
        self._TxStatus = TxStatus

    @property
    def TxResult(self):
        """Transaction result.
        :rtype: str
        """
        return self._TxResult

    @TxResult.setter
    def TxResult(self, TxResult):
        self._TxResult = TxResult

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TxId = params.get("TxId")
        self._TxStatus = params.get("TxStatus")
        self._TxResult = params.get("TxResult")
        self._RequestId = params.get("RequestId")


class QueryFabricChaincodeRequest(AbstractModel):
    """QueryFabricChaincode request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID, which can be obtained from the blockchain cluster details.
        :type ClusterId: str
        :param _ChannelId: Channel ID, which can be obtained from the channel list or channel details.
        :type ChannelId: str
        :param _ChaincodeName: Contract name. it can be obtained from the contract list or contract details.
        :type ChaincodeName: str
        :param _FuncName: Contract method.
        :type FuncName: str
        :param _FuncParam: Contract method input parameter.
        :type FuncParam: list of str
        """
        self._ClusterId = None
        self._ChannelId = None
        self._ChaincodeName = None
        self._FuncName = None
        self._FuncParam = None

    @property
    def ClusterId(self):
        """Cluster ID, which can be obtained from the blockchain cluster details.
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ChannelId(self):
        """Channel ID, which can be obtained from the channel list or channel details.
        :rtype: str
        """
        return self._ChannelId

    @ChannelId.setter
    def ChannelId(self, ChannelId):
        self._ChannelId = ChannelId

    @property
    def ChaincodeName(self):
        """Contract name. it can be obtained from the contract list or contract details.
        :rtype: str
        """
        return self._ChaincodeName

    @ChaincodeName.setter
    def ChaincodeName(self, ChaincodeName):
        self._ChaincodeName = ChaincodeName

    @property
    def FuncName(self):
        """Contract method.
        :rtype: str
        """
        return self._FuncName

    @FuncName.setter
    def FuncName(self, FuncName):
        self._FuncName = FuncName

    @property
    def FuncParam(self):
        """Contract method input parameter.
        :rtype: list of str
        """
        return self._FuncParam

    @FuncParam.setter
    def FuncParam(self, FuncParam):
        self._FuncParam = FuncParam


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ChannelId = params.get("ChannelId")
        self._ChaincodeName = params.get("ChaincodeName")
        self._FuncName = params.get("FuncName")
        self._FuncParam = params.get("FuncParam")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class QueryFabricChaincodeResponse(AbstractModel):
    """QueryFabricChaincode response structure.

    """

    def __init__(self):
        r"""
        :param _TxId: Transaction ID
        :type TxId: str
        :param _TxStatus: Transaction status.
        :type TxStatus: str
        :param _TxResult: Transaction result.
        :type TxResult: str
        :param _RequestId: The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TxId = None
        self._TxStatus = None
        self._TxResult = None
        self._RequestId = None

    @property
    def TxId(self):
        """Transaction ID
        :rtype: str
        """
        return self._TxId

    @TxId.setter
    def TxId(self, TxId):
        self._TxId = TxId

    @property
    def TxStatus(self):
        """Transaction status.
        :rtype: str
        """
        return self._TxStatus

    @TxStatus.setter
    def TxStatus(self, TxStatus):
        self._TxStatus = TxStatus

    @property
    def TxResult(self):
        """Transaction result.
        :rtype: str
        """
        return self._TxResult

    @TxResult.setter
    def TxResult(self, TxResult):
        self._TxResult = TxResult

    @property
    def RequestId(self):
        """The unique request ID, generated by the server, will be returned for every request (if the request fails to reach the server for other reasons, the request will not obtain a RequestId). RequestId is required for locating a problem.
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TxId = params.get("TxId")
        self._TxStatus = params.get("TxStatus")
        self._TxResult = params.get("TxResult")
        self._RequestId = params.get("RequestId")


class Transaction(AbstractModel):
    """Transaction overview information display.

    """

    def __init__(self):
        r"""
        :param _TxId: Transaction ID
        :type TxId: str
        :param _ChaincodeName: Contract name.
        :type ChaincodeName: str
        :param _Sender: Transaction sender.
        :type Sender: str
        :param _CreateTime: Transaction creation time.
        :type CreateTime: str
        :param _BlockHeight: The block height where the trading platform is located.
        :type BlockHeight: int
        :param _TxIndex: The serial number of a transaction in a block.
        :type TxIndex: int
        """
        self._TxId = None
        self._ChaincodeName = None
        self._Sender = None
        self._CreateTime = None
        self._BlockHeight = None
        self._TxIndex = None

    @property
    def TxId(self):
        """Transaction ID
        :rtype: str
        """
        return self._TxId

    @TxId.setter
    def TxId(self, TxId):
        self._TxId = TxId

    @property
    def ChaincodeName(self):
        """Contract name.
        :rtype: str
        """
        return self._ChaincodeName

    @ChaincodeName.setter
    def ChaincodeName(self, ChaincodeName):
        self._ChaincodeName = ChaincodeName

    @property
    def Sender(self):
        """Transaction sender.
        :rtype: str
        """
        return self._Sender

    @Sender.setter
    def Sender(self, Sender):
        self._Sender = Sender

    @property
    def CreateTime(self):
        """Transaction creation time.
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def BlockHeight(self):
        """The block height where the trading platform is located.
        :rtype: int
        """
        return self._BlockHeight

    @BlockHeight.setter
    def BlockHeight(self, BlockHeight):
        self._BlockHeight = BlockHeight

    @property
    def TxIndex(self):
        """The serial number of a transaction in a block.
        :rtype: int
        """
        return self._TxIndex

    @TxIndex.setter
    def TxIndex(self, TxIndex):
        self._TxIndex = TxIndex


    def _deserialize(self, params):
        self._TxId = params.get("TxId")
        self._ChaincodeName = params.get("ChaincodeName")
        self._Sender = params.get("Sender")
        self._CreateTime = params.get("CreateTime")
        self._BlockHeight = params.get("BlockHeight")
        self._TxIndex = params.get("TxIndex")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        