# -*- coding: utf8 -*-
# Copyright (c) 2017-2021 THL A29 Limited, a Tencent company. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.


# Internal error.
INTERNALERROR = 'InternalError'

# An error is returned for the CVM API call.
INTERNALERROR_CALLCVM = 'InternalError.CallCvm'

# The specified filter is not supported.
INVALIDFILTER = 'InvalidFilter'

# Incorrect parameter value.
INVALIDPARAMETERVALUE = 'InvalidParameterValue'

# Incorrect `Filter` parameter.
INVALIDPARAMETERVALUE_INVALIDFILTER = 'InvalidParameterValue.InvalidFilter'

# The availability zone and the region do not match.
INVALIDPARAMETERVALUE_INVALIDZONEMISMATCHREGION = 'InvalidParameterValue.InvalidZoneMismatchRegion'

# The number of filter parameter values exceeds the limit.
INVALIDPARAMETERVALUE_LIMITEXCEEDED = 'InvalidParameterValue.LimitExceeded'

# The model billing type is not supported by BatchCompute.
INVALIDPARAMETERVALUE_UNSUPPORTEDBATCHINSTANCECHARGETYPE = 'InvalidParameterValue.UnsupportedBatchInstanceChargeType'

# The specified zone does not exist.
INVALIDZONE_MISMATCHREGION = 'InvalidZone.MismatchRegion'

# Unsupported operation.
UNSUPPORTEDOPERATION = 'UnsupportedOperation'
