# -*- coding: utf8 -*-
# Copyright (c) 2017-2021 THL A29 Limited, a Tencent company. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class AdhocDetail(AbstractModel):
    """子任务记录

    """

    def __init__(self):
        r"""
        :param _Id: 子任务记录Id
        :type Id: int
        :param _ScriptContent: 脚本内容
        :type ScriptContent: str
        :param _StartTime: 任务启动时间
注意：此字段可能返回 null，表示取不到有效值。
        :type StartTime: str
        :param _EndTime: 任务结束时间
注意：此字段可能返回 null，表示取不到有效值。
        :type EndTime: str
        :param _Status: 当前任务状态
        :type Status: str
        :param _RecordId: 提交任务id
        :type RecordId: int
        """
        self._Id = None
        self._ScriptContent = None
        self._StartTime = None
        self._EndTime = None
        self._Status = None
        self._RecordId = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def ScriptContent(self):
        return self._ScriptContent

    @ScriptContent.setter
    def ScriptContent(self, ScriptContent):
        self._ScriptContent = ScriptContent

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def RecordId(self):
        return self._RecordId

    @RecordId.setter
    def RecordId(self, RecordId):
        self._RecordId = RecordId


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._ScriptContent = params.get("ScriptContent")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Status = params.get("Status")
        self._RecordId = params.get("RecordId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AdhocRecord(AbstractModel):
    """任务提交记录

    """

    def __init__(self):
        r"""
        :param _Id: 任务提交记录id
注意：此字段可能返回 null，表示取不到有效值。
        :type Id: int
        :param _ScriptContent: 脚本内容
注意：此字段可能返回 null，表示取不到有效值。
        :type ScriptContent: str
        :param _CreateTime: 任务提交时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateTime: str
        :param _Status: 任务状态
注意：此字段可能返回 null，表示取不到有效值。
        :type Status: str
        :param _InstanceId: 实例id
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceId: str
        """
        self._Id = None
        self._ScriptContent = None
        self._CreateTime = None
        self._Status = None
        self._InstanceId = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def ScriptContent(self):
        return self._ScriptContent

    @ScriptContent.setter
    def ScriptContent(self, ScriptContent):
        self._ScriptContent = ScriptContent

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._ScriptContent = params.get("ScriptContent")
        self._CreateTime = params.get("CreateTime")
        self._Status = params.get("Status")
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AgentStatus(AbstractModel):
    """Agent采集器状态统计

    """

    def __init__(self):
        r"""
        :param _Running: 运行中的数量
注意：此字段可能返回 null，表示取不到有效值。
        :type Running: int
        :param _Abnormal: 异常的数量
注意：此字段可能返回 null，表示取不到有效值。
        :type Abnormal: int
        :param _InOperation: 操作中的数量
注意：此字段可能返回 null，表示取不到有效值。
        :type InOperation: int
        """
        self._Running = None
        self._Abnormal = None
        self._InOperation = None

    @property
    def Running(self):
        return self._Running

    @Running.setter
    def Running(self, Running):
        self._Running = Running

    @property
    def Abnormal(self):
        return self._Abnormal

    @Abnormal.setter
    def Abnormal(self, Abnormal):
        self._Abnormal = Abnormal

    @property
    def InOperation(self):
        return self._InOperation

    @InOperation.setter
    def InOperation(self, InOperation):
        self._InOperation = InOperation


    def _deserialize(self, params):
        self._Running = params.get("Running")
        self._Abnormal = params.get("Abnormal")
        self._InOperation = params.get("InOperation")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AlarmDsVO(AbstractModel):
    """告警信息

    """

    def __init__(self):
        r"""
        :param _AlarmId: 告警策略id
注意：此字段可能返回 null，表示取不到有效值。
        :type AlarmId: str
        :param _TaskId: 任务id
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskId: str
        :param _Status: 告警是否生效
注意：此字段可能返回 null，表示取不到有效值。
        :type Status: int
        :param _AlarmType: 告警类别，目前支持失败告警，超时告警
注意：此字段可能返回 null，表示取不到有效值。
        :type AlarmType: str
        :param _AlarmWay: 告警方式 ，目前支持email提醒，短信提醒
注意：此字段可能返回 null，表示取不到有效值。
        :type AlarmWay: str
        :param _Creator: 告警创建人
注意：此字段可能返回 null，表示取不到有效值。
        :type Creator: str
        :param _AlarmRecipient: 告警接收人
注意：此字段可能返回 null，表示取不到有效值。
        :type AlarmRecipient: str
        :param _AlarmRecipientId: 告警接收人ID
注意：此字段可能返回 null，表示取不到有效值。
        :type AlarmRecipientId: str
        :param _ModifyTime: 告警修改时间
注意：此字段可能返回 null，表示取不到有效值。
        :type ModifyTime: str
        :param _LastFailTime: 最近失败告警实例数据时间
注意：此字段可能返回 null，表示取不到有效值。
        :type LastFailTime: str
        :param _LastOverTime: 最近超时告警实例数据时间
注意：此字段可能返回 null，表示取不到有效值。
        :type LastOverTime: str
        :param _LastAlarmTime: 最新告警时间
注意：此字段可能返回 null，表示取不到有效值。
        :type LastAlarmTime: str
        :param _AlarmExt: AlarmExt信息
注意：此字段可能返回 null，表示取不到有效值。
        :type AlarmExt: list of AlarmExtDsVO
        :param _CreateTime: 告警创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateTime: str
        """
        self._AlarmId = None
        self._TaskId = None
        self._Status = None
        self._AlarmType = None
        self._AlarmWay = None
        self._Creator = None
        self._AlarmRecipient = None
        self._AlarmRecipientId = None
        self._ModifyTime = None
        self._LastFailTime = None
        self._LastOverTime = None
        self._LastAlarmTime = None
        self._AlarmExt = None
        self._CreateTime = None

    @property
    def AlarmId(self):
        return self._AlarmId

    @AlarmId.setter
    def AlarmId(self, AlarmId):
        self._AlarmId = AlarmId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def AlarmType(self):
        return self._AlarmType

    @AlarmType.setter
    def AlarmType(self, AlarmType):
        self._AlarmType = AlarmType

    @property
    def AlarmWay(self):
        return self._AlarmWay

    @AlarmWay.setter
    def AlarmWay(self, AlarmWay):
        self._AlarmWay = AlarmWay

    @property
    def Creator(self):
        return self._Creator

    @Creator.setter
    def Creator(self, Creator):
        self._Creator = Creator

    @property
    def AlarmRecipient(self):
        return self._AlarmRecipient

    @AlarmRecipient.setter
    def AlarmRecipient(self, AlarmRecipient):
        self._AlarmRecipient = AlarmRecipient

    @property
    def AlarmRecipientId(self):
        return self._AlarmRecipientId

    @AlarmRecipientId.setter
    def AlarmRecipientId(self, AlarmRecipientId):
        self._AlarmRecipientId = AlarmRecipientId

    @property
    def ModifyTime(self):
        return self._ModifyTime

    @ModifyTime.setter
    def ModifyTime(self, ModifyTime):
        self._ModifyTime = ModifyTime

    @property
    def LastFailTime(self):
        return self._LastFailTime

    @LastFailTime.setter
    def LastFailTime(self, LastFailTime):
        self._LastFailTime = LastFailTime

    @property
    def LastOverTime(self):
        return self._LastOverTime

    @LastOverTime.setter
    def LastOverTime(self, LastOverTime):
        self._LastOverTime = LastOverTime

    @property
    def LastAlarmTime(self):
        return self._LastAlarmTime

    @LastAlarmTime.setter
    def LastAlarmTime(self, LastAlarmTime):
        self._LastAlarmTime = LastAlarmTime

    @property
    def AlarmExt(self):
        return self._AlarmExt

    @AlarmExt.setter
    def AlarmExt(self, AlarmExt):
        self._AlarmExt = AlarmExt

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime


    def _deserialize(self, params):
        self._AlarmId = params.get("AlarmId")
        self._TaskId = params.get("TaskId")
        self._Status = params.get("Status")
        self._AlarmType = params.get("AlarmType")
        self._AlarmWay = params.get("AlarmWay")
        self._Creator = params.get("Creator")
        self._AlarmRecipient = params.get("AlarmRecipient")
        self._AlarmRecipientId = params.get("AlarmRecipientId")
        self._ModifyTime = params.get("ModifyTime")
        self._LastFailTime = params.get("LastFailTime")
        self._LastOverTime = params.get("LastOverTime")
        self._LastAlarmTime = params.get("LastAlarmTime")
        if params.get("AlarmExt") is not None:
            self._AlarmExt = []
            for item in params.get("AlarmExt"):
                obj = AlarmExtDsVO()
                obj._deserialize(item)
                self._AlarmExt.append(obj)
        self._CreateTime = params.get("CreateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AlarmEventInfo(AbstractModel):
    """告警事件详情

    """

    def __init__(self):
        r"""
        :param _AlarmId: 告警ID
        :type AlarmId: str
        :param _AlarmTime: 告警时间
        :type AlarmTime: str
        :param _TaskId: 任务ID
        :type TaskId: str
        :param _RegularName: 规则名称
        :type RegularName: str
        :param _AlarmLevel: 告警级别,0表示普通，1表示重要，2表示紧急
        :type AlarmLevel: int
        :param _AlarmWay: 告警方式,多个用逗号隔开（1:邮件，2:短信，3:微信，4:语音，5:代表企业微信，6:http）
        :type AlarmWay: int
        :param _AlarmRecipientId: 告警接收人Id，多个用逗号隔开
        :type AlarmRecipientId: str
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _AlarmIndicator: 告警指标,0表示任务失败，1表示任务运行超时，2表示任务停止，3表示任务暂停
        :type AlarmIndicator: int
        :param _AlarmIndicatorDesc: 告警指标描述
注意：此字段可能返回 null，表示取不到有效值。
        :type AlarmIndicatorDesc: str
        :param _TriggerType: 指标阈值，1表示离线任务第一次运行失败，2表示离线任务所有重试完成后失败
注意：此字段可能返回 null，表示取不到有效值。
        :type TriggerType: int
        :param _EstimatedTime: 预计的超时时间，分钟级别
注意：此字段可能返回 null，表示取不到有效值。
        :type EstimatedTime: int
        :param _InstanceId: 实例ID
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceId: str
        :param _TaskName: 任务名称
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskName: str
        :param _IsSendSuccess: 0：部分成功，1：全部成功，2：全部失败
注意：此字段可能返回 null，表示取不到有效值。
        :type IsSendSuccess: int
        :param _MessageId: 消息ID
注意：此字段可能返回 null，表示取不到有效值。
        :type MessageId: str
        :param _Operator: 阈值计算算子，1 : 大于 2 ：小于
注意：此字段可能返回 null，表示取不到有效值。
        :type Operator: int
        :param _RegularId: 告警规则ID
注意：此字段可能返回 null，表示取不到有效值。
        :type RegularId: str
        :param _AlarmRecipientName: 告警接收人昵称
注意：此字段可能返回 null，表示取不到有效值。
        :type AlarmRecipientName: str
        :param _TaskType: 告警任务类型
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskType: int
        :param _SendResult: 发送结果
注意：此字段可能返回 null，表示取不到有效值。
        :type SendResult: str
        :param _MonitorObjectId: 监控对象id
注意：此字段可能返回 null，表示取不到有效值。
        :type MonitorObjectId: str
        :param _MonitorObjectName: 监控对象名称
注意：此字段可能返回 null，表示取不到有效值。
        :type MonitorObjectName: str
        :param _Threshold: 指标阈值
注意：此字段可能返回 null，表示取不到有效值。
        :type Threshold: float
        """
        self._AlarmId = None
        self._AlarmTime = None
        self._TaskId = None
        self._RegularName = None
        self._AlarmLevel = None
        self._AlarmWay = None
        self._AlarmRecipientId = None
        self._ProjectId = None
        self._AlarmIndicator = None
        self._AlarmIndicatorDesc = None
        self._TriggerType = None
        self._EstimatedTime = None
        self._InstanceId = None
        self._TaskName = None
        self._IsSendSuccess = None
        self._MessageId = None
        self._Operator = None
        self._RegularId = None
        self._AlarmRecipientName = None
        self._TaskType = None
        self._SendResult = None
        self._MonitorObjectId = None
        self._MonitorObjectName = None
        self._Threshold = None

    @property
    def AlarmId(self):
        return self._AlarmId

    @AlarmId.setter
    def AlarmId(self, AlarmId):
        self._AlarmId = AlarmId

    @property
    def AlarmTime(self):
        return self._AlarmTime

    @AlarmTime.setter
    def AlarmTime(self, AlarmTime):
        self._AlarmTime = AlarmTime

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RegularName(self):
        return self._RegularName

    @RegularName.setter
    def RegularName(self, RegularName):
        self._RegularName = RegularName

    @property
    def AlarmLevel(self):
        return self._AlarmLevel

    @AlarmLevel.setter
    def AlarmLevel(self, AlarmLevel):
        self._AlarmLevel = AlarmLevel

    @property
    def AlarmWay(self):
        return self._AlarmWay

    @AlarmWay.setter
    def AlarmWay(self, AlarmWay):
        self._AlarmWay = AlarmWay

    @property
    def AlarmRecipientId(self):
        return self._AlarmRecipientId

    @AlarmRecipientId.setter
    def AlarmRecipientId(self, AlarmRecipientId):
        self._AlarmRecipientId = AlarmRecipientId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def AlarmIndicator(self):
        return self._AlarmIndicator

    @AlarmIndicator.setter
    def AlarmIndicator(self, AlarmIndicator):
        self._AlarmIndicator = AlarmIndicator

    @property
    def AlarmIndicatorDesc(self):
        return self._AlarmIndicatorDesc

    @AlarmIndicatorDesc.setter
    def AlarmIndicatorDesc(self, AlarmIndicatorDesc):
        self._AlarmIndicatorDesc = AlarmIndicatorDesc

    @property
    def TriggerType(self):
        return self._TriggerType

    @TriggerType.setter
    def TriggerType(self, TriggerType):
        self._TriggerType = TriggerType

    @property
    def EstimatedTime(self):
        return self._EstimatedTime

    @EstimatedTime.setter
    def EstimatedTime(self, EstimatedTime):
        self._EstimatedTime = EstimatedTime

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def TaskName(self):
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def IsSendSuccess(self):
        return self._IsSendSuccess

    @IsSendSuccess.setter
    def IsSendSuccess(self, IsSendSuccess):
        self._IsSendSuccess = IsSendSuccess

    @property
    def MessageId(self):
        return self._MessageId

    @MessageId.setter
    def MessageId(self, MessageId):
        self._MessageId = MessageId

    @property
    def Operator(self):
        return self._Operator

    @Operator.setter
    def Operator(self, Operator):
        self._Operator = Operator

    @property
    def RegularId(self):
        return self._RegularId

    @RegularId.setter
    def RegularId(self, RegularId):
        self._RegularId = RegularId

    @property
    def AlarmRecipientName(self):
        return self._AlarmRecipientName

    @AlarmRecipientName.setter
    def AlarmRecipientName(self, AlarmRecipientName):
        self._AlarmRecipientName = AlarmRecipientName

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def SendResult(self):
        return self._SendResult

    @SendResult.setter
    def SendResult(self, SendResult):
        self._SendResult = SendResult

    @property
    def MonitorObjectId(self):
        return self._MonitorObjectId

    @MonitorObjectId.setter
    def MonitorObjectId(self, MonitorObjectId):
        self._MonitorObjectId = MonitorObjectId

    @property
    def MonitorObjectName(self):
        return self._MonitorObjectName

    @MonitorObjectName.setter
    def MonitorObjectName(self, MonitorObjectName):
        self._MonitorObjectName = MonitorObjectName

    @property
    def Threshold(self):
        return self._Threshold

    @Threshold.setter
    def Threshold(self, Threshold):
        self._Threshold = Threshold


    def _deserialize(self, params):
        self._AlarmId = params.get("AlarmId")
        self._AlarmTime = params.get("AlarmTime")
        self._TaskId = params.get("TaskId")
        self._RegularName = params.get("RegularName")
        self._AlarmLevel = params.get("AlarmLevel")
        self._AlarmWay = params.get("AlarmWay")
        self._AlarmRecipientId = params.get("AlarmRecipientId")
        self._ProjectId = params.get("ProjectId")
        self._AlarmIndicator = params.get("AlarmIndicator")
        self._AlarmIndicatorDesc = params.get("AlarmIndicatorDesc")
        self._TriggerType = params.get("TriggerType")
        self._EstimatedTime = params.get("EstimatedTime")
        self._InstanceId = params.get("InstanceId")
        self._TaskName = params.get("TaskName")
        self._IsSendSuccess = params.get("IsSendSuccess")
        self._MessageId = params.get("MessageId")
        self._Operator = params.get("Operator")
        self._RegularId = params.get("RegularId")
        self._AlarmRecipientName = params.get("AlarmRecipientName")
        self._TaskType = params.get("TaskType")
        self._SendResult = params.get("SendResult")
        self._MonitorObjectId = params.get("MonitorObjectId")
        self._MonitorObjectName = params.get("MonitorObjectName")
        self._Threshold = params.get("Threshold")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AlarmExtDsVO(AbstractModel):
    """AlarmExtVO信息

    """

    def __init__(self):
        r"""
        :param _AlarmId: 告警策略ID
注意：此字段可能返回 null，表示取不到有效值。
        :type AlarmId: str
        :param _PropName: 扩展字段key
注意：此字段可能返回 null，表示取不到有效值。
        :type PropName: str
        :param _PropValue: 扩展字段value
注意：此字段可能返回 null，表示取不到有效值。
        :type PropValue: str
        :param _CreateTime: 告警创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateTime: str
        :param _ModifyTime: 修改时间
注意：此字段可能返回 null，表示取不到有效值。
        :type ModifyTime: str
        """
        self._AlarmId = None
        self._PropName = None
        self._PropValue = None
        self._CreateTime = None
        self._ModifyTime = None

    @property
    def AlarmId(self):
        return self._AlarmId

    @AlarmId.setter
    def AlarmId(self, AlarmId):
        self._AlarmId = AlarmId

    @property
    def PropName(self):
        return self._PropName

    @PropName.setter
    def PropName(self, PropName):
        self._PropName = PropName

    @property
    def PropValue(self):
        return self._PropValue

    @PropValue.setter
    def PropValue(self, PropValue):
        self._PropValue = PropValue

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ModifyTime(self):
        return self._ModifyTime

    @ModifyTime.setter
    def ModifyTime(self, ModifyTime):
        self._ModifyTime = ModifyTime


    def _deserialize(self, params):
        self._AlarmId = params.get("AlarmId")
        self._PropName = params.get("PropName")
        self._PropValue = params.get("PropValue")
        self._CreateTime = params.get("CreateTime")
        self._ModifyTime = params.get("ModifyTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AlarmIndicatorInfo(AbstractModel):
    """告警指标

    """

    def __init__(self):
        r"""
        :param _Id: 指标id
注意：此字段可能返回 null，表示取不到有效值。
        :type Id: str
        :param _AlarmIndicator: 告警指标,0任务失败,1任务运行超时,2任务停止,3任务暂停, 4读取速度,5写入速度,6读取吞吐 7写入吞吐, 8脏数据字节数,9脏数据条数,10任务异常,11任务检测异常, 12重启次数, 13任务延时, 14近20分内的重启次数 15传输延迟,16业务延迟, 50离线包CPU使用率, 51离线包内存使用率, 52离线包并行度使用率, 53离线包排队中的实例数, 54实时包资源使用率, 55实时包运行中的任务数
注意：此字段可能返回 null，表示取不到有效值。
        :type AlarmIndicator: int
        :param _AlarmIndicatorDesc: 告警指标描述
注意：此字段可能返回 null，表示取不到有效值。
        :type AlarmIndicatorDesc: str
        :param _TriggerType: 指标阈值，1表示离线任务第一次运行失败，2表示离线任务所有重试完成后失败
注意：此字段可能返回 null，表示取不到有效值。
        :type TriggerType: int
        :param _EstimatedTime: 预计的超时时间，分钟级别
注意：此字段可能返回 null，表示取不到有效值。
        :type EstimatedTime: int
        :param _Operator: 告警阈值的算子,1 大于,2 小于
注意：此字段可能返回 null，表示取不到有效值。
        :type Operator: int
        :param _AlarmIndicatorUnit: 告警指标阈值单位：ms(毫秒)、s(秒)、min(分钟)
注意：此字段可能返回 null，表示取不到有效值。
        :type AlarmIndicatorUnit: str
        :param _Duration: 告警周期
        :type Duration: int
        :param _DurationUnit: 告警周期单位:hour,minute,day
        :type DurationUnit: str
        :param _MaxTimes: 周期内最多告警次数
        :type MaxTimes: int
        :param _Threshold: 指标阈值
注意：此字段可能返回 null，表示取不到有效值。
        :type Threshold: float
        """
        self._Id = None
        self._AlarmIndicator = None
        self._AlarmIndicatorDesc = None
        self._TriggerType = None
        self._EstimatedTime = None
        self._Operator = None
        self._AlarmIndicatorUnit = None
        self._Duration = None
        self._DurationUnit = None
        self._MaxTimes = None
        self._Threshold = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def AlarmIndicator(self):
        return self._AlarmIndicator

    @AlarmIndicator.setter
    def AlarmIndicator(self, AlarmIndicator):
        self._AlarmIndicator = AlarmIndicator

    @property
    def AlarmIndicatorDesc(self):
        return self._AlarmIndicatorDesc

    @AlarmIndicatorDesc.setter
    def AlarmIndicatorDesc(self, AlarmIndicatorDesc):
        self._AlarmIndicatorDesc = AlarmIndicatorDesc

    @property
    def TriggerType(self):
        return self._TriggerType

    @TriggerType.setter
    def TriggerType(self, TriggerType):
        self._TriggerType = TriggerType

    @property
    def EstimatedTime(self):
        return self._EstimatedTime

    @EstimatedTime.setter
    def EstimatedTime(self, EstimatedTime):
        self._EstimatedTime = EstimatedTime

    @property
    def Operator(self):
        return self._Operator

    @Operator.setter
    def Operator(self, Operator):
        self._Operator = Operator

    @property
    def AlarmIndicatorUnit(self):
        return self._AlarmIndicatorUnit

    @AlarmIndicatorUnit.setter
    def AlarmIndicatorUnit(self, AlarmIndicatorUnit):
        self._AlarmIndicatorUnit = AlarmIndicatorUnit

    @property
    def Duration(self):
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration

    @property
    def DurationUnit(self):
        return self._DurationUnit

    @DurationUnit.setter
    def DurationUnit(self, DurationUnit):
        self._DurationUnit = DurationUnit

    @property
    def MaxTimes(self):
        return self._MaxTimes

    @MaxTimes.setter
    def MaxTimes(self, MaxTimes):
        self._MaxTimes = MaxTimes

    @property
    def Threshold(self):
        return self._Threshold

    @Threshold.setter
    def Threshold(self, Threshold):
        self._Threshold = Threshold


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._AlarmIndicator = params.get("AlarmIndicator")
        self._AlarmIndicatorDesc = params.get("AlarmIndicatorDesc")
        self._TriggerType = params.get("TriggerType")
        self._EstimatedTime = params.get("EstimatedTime")
        self._Operator = params.get("Operator")
        self._AlarmIndicatorUnit = params.get("AlarmIndicatorUnit")
        self._Duration = params.get("Duration")
        self._DurationUnit = params.get("DurationUnit")
        self._MaxTimes = params.get("MaxTimes")
        self._Threshold = params.get("Threshold")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AlarmInfo(AbstractModel):
    """任务告警信息

    """

    def __init__(self):
        r"""
        :param _TaskIds: 关联任务id
        :type TaskIds: str
        :param _AlarmType: 告警类别；failure表示失败告警；overtime表示超时告警
        :type AlarmType: str
        :param _AlarmWay: 告警方式；SMS表示短信；Email表示邮件；HTTP 表示接口方式；Wechat表示微信方式
        :type AlarmWay: str
        :param _AlarmRecipient: 告警接收人，多个告警接收人以;分割
        :type AlarmRecipient: str
        :param _AlarmRecipientId: 告警接收人id，多个告警接收人id以;分割
        :type AlarmRecipientId: str
        :param _Hours: 预计运行的小时，取值范围0-23
        :type Hours: int
        :param _Minutes: 预计运行分钟，取值范围0-59
        :type Minutes: int
        :param _TriggerType: 告警出发时机；1表示第一次运行失败；2表示所有重试完成后失败；
        :type TriggerType: int
        :param _AlarmId: 告警信息id
        :type AlarmId: str
        :param _Status: 告警状态设置；1表示可用；0表示不可用，默认可用
        :type Status: int
        """
        self._TaskIds = None
        self._AlarmType = None
        self._AlarmWay = None
        self._AlarmRecipient = None
        self._AlarmRecipientId = None
        self._Hours = None
        self._Minutes = None
        self._TriggerType = None
        self._AlarmId = None
        self._Status = None

    @property
    def TaskIds(self):
        return self._TaskIds

    @TaskIds.setter
    def TaskIds(self, TaskIds):
        self._TaskIds = TaskIds

    @property
    def AlarmType(self):
        return self._AlarmType

    @AlarmType.setter
    def AlarmType(self, AlarmType):
        self._AlarmType = AlarmType

    @property
    def AlarmWay(self):
        return self._AlarmWay

    @AlarmWay.setter
    def AlarmWay(self, AlarmWay):
        self._AlarmWay = AlarmWay

    @property
    def AlarmRecipient(self):
        return self._AlarmRecipient

    @AlarmRecipient.setter
    def AlarmRecipient(self, AlarmRecipient):
        self._AlarmRecipient = AlarmRecipient

    @property
    def AlarmRecipientId(self):
        return self._AlarmRecipientId

    @AlarmRecipientId.setter
    def AlarmRecipientId(self, AlarmRecipientId):
        self._AlarmRecipientId = AlarmRecipientId

    @property
    def Hours(self):
        return self._Hours

    @Hours.setter
    def Hours(self, Hours):
        self._Hours = Hours

    @property
    def Minutes(self):
        return self._Minutes

    @Minutes.setter
    def Minutes(self, Minutes):
        self._Minutes = Minutes

    @property
    def TriggerType(self):
        return self._TriggerType

    @TriggerType.setter
    def TriggerType(self, TriggerType):
        self._TriggerType = TriggerType

    @property
    def AlarmId(self):
        return self._AlarmId

    @AlarmId.setter
    def AlarmId(self, AlarmId):
        self._AlarmId = AlarmId

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._TaskIds = params.get("TaskIds")
        self._AlarmType = params.get("AlarmType")
        self._AlarmWay = params.get("AlarmWay")
        self._AlarmRecipient = params.get("AlarmRecipient")
        self._AlarmRecipientId = params.get("AlarmRecipientId")
        self._Hours = params.get("Hours")
        self._Minutes = params.get("Minutes")
        self._TriggerType = params.get("TriggerType")
        self._AlarmId = params.get("AlarmId")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AlarmReceiverInfo(AbstractModel):
    """告警接收人详情

    """

    def __init__(self):
        r"""
        :param _AlarmId: 告警ID
        :type AlarmId: str
        :param _AlarmReceiver: 告警接收人ID
        :type AlarmReceiver: str
        :param _Email: 邮件，0：未设置，1：成功，2：失败
        :type Email: int
        :param _Sms: 短信，0：未设置，1：成功，2：失败
        :type Sms: int
        :param _Wechat: 微信，0：未设置，1：成功，2：失败
        :type Wechat: int
        :param _Voice: 电话，0：未设置，1：成功，2：失败
        :type Voice: int
        :param _Wecom: 企业微信，0：未设置，1：成功，2：失败
        :type Wecom: int
        :param _Http: http，0：未设置，1：成功，2：失败
        :type Http: int
        :param _WecomGroup: 企业微信群，0：未设置，1：成功，2：失败
注意：此字段可能返回 null，表示取不到有效值。
        :type WecomGroup: int
        :param _LarkGroup: 飞书群，0：未设置，1：成功，2：失败
注意：此字段可能返回 null，表示取不到有效值。
        :type LarkGroup: int
        """
        self._AlarmId = None
        self._AlarmReceiver = None
        self._Email = None
        self._Sms = None
        self._Wechat = None
        self._Voice = None
        self._Wecom = None
        self._Http = None
        self._WecomGroup = None
        self._LarkGroup = None

    @property
    def AlarmId(self):
        return self._AlarmId

    @AlarmId.setter
    def AlarmId(self, AlarmId):
        self._AlarmId = AlarmId

    @property
    def AlarmReceiver(self):
        return self._AlarmReceiver

    @AlarmReceiver.setter
    def AlarmReceiver(self, AlarmReceiver):
        self._AlarmReceiver = AlarmReceiver

    @property
    def Email(self):
        return self._Email

    @Email.setter
    def Email(self, Email):
        self._Email = Email

    @property
    def Sms(self):
        return self._Sms

    @Sms.setter
    def Sms(self, Sms):
        self._Sms = Sms

    @property
    def Wechat(self):
        return self._Wechat

    @Wechat.setter
    def Wechat(self, Wechat):
        self._Wechat = Wechat

    @property
    def Voice(self):
        return self._Voice

    @Voice.setter
    def Voice(self, Voice):
        self._Voice = Voice

    @property
    def Wecom(self):
        return self._Wecom

    @Wecom.setter
    def Wecom(self, Wecom):
        self._Wecom = Wecom

    @property
    def Http(self):
        return self._Http

    @Http.setter
    def Http(self, Http):
        self._Http = Http

    @property
    def WecomGroup(self):
        return self._WecomGroup

    @WecomGroup.setter
    def WecomGroup(self, WecomGroup):
        self._WecomGroup = WecomGroup

    @property
    def LarkGroup(self):
        return self._LarkGroup

    @LarkGroup.setter
    def LarkGroup(self, LarkGroup):
        self._LarkGroup = LarkGroup


    def _deserialize(self, params):
        self._AlarmId = params.get("AlarmId")
        self._AlarmReceiver = params.get("AlarmReceiver")
        self._Email = params.get("Email")
        self._Sms = params.get("Sms")
        self._Wechat = params.get("Wechat")
        self._Voice = params.get("Voice")
        self._Wecom = params.get("Wecom")
        self._Http = params.get("Http")
        self._WecomGroup = params.get("WecomGroup")
        self._LarkGroup = params.get("LarkGroup")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AlarmRuleDto(AbstractModel):
    """告警规则

    """

    def __init__(self):
        r"""
        :param _AlarmRuleId: 告警规则id
        :type AlarmRuleId: str
        :param _AlarmLevelType: 重要;
紧急;
普通
        :type AlarmLevelType: str
        """
        self._AlarmRuleId = None
        self._AlarmLevelType = None

    @property
    def AlarmRuleId(self):
        return self._AlarmRuleId

    @AlarmRuleId.setter
    def AlarmRuleId(self, AlarmRuleId):
        self._AlarmRuleId = AlarmRuleId

    @property
    def AlarmLevelType(self):
        return self._AlarmLevelType

    @AlarmLevelType.setter
    def AlarmLevelType(self, AlarmLevelType):
        self._AlarmLevelType = AlarmLevelType


    def _deserialize(self, params):
        self._AlarmRuleId = params.get("AlarmRuleId")
        self._AlarmLevelType = params.get("AlarmLevelType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Apply(AbstractModel):
    """审批列表信息

    """

    def __init__(self):
        r"""
        :param _ApplicantId: 申请人id
        :type ApplicantId: str
        :param _ApplicantName: 申请人名称
        :type ApplicantName: str
        :param _Remark: 审批备注
注意：此字段可能返回 null，表示取不到有效值。
        :type Remark: str
        :param _ApproveClassification: 审批分类key
        :type ApproveClassification: str
        :param _ApproveId: 审批单id
        :type ApproveId: str
        :param _ApproveType: 审批类型key
        :type ApproveType: str
        :param _Reason: 申请原因
注意：此字段可能返回 null，表示取不到有效值。
        :type Reason: str
        :param _CreateTime: 创建时间
        :type CreateTime: str
        :param _ApproveTime: 审批时间
注意：此字段可能返回 null，表示取不到有效值。
        :type ApproveTime: str
        :param _ApproveClassificationName: 审批分类名称
        :type ApproveClassificationName: str
        :param _Status: 状态
        :type Status: str
        :param _ApproveTypeName: 审批类型名称
        :type ApproveTypeName: str
        :param _ErrorMessage: 审批异常或者失败信息
        :type ErrorMessage: str
        :param _ApplyName: 申请名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ApplyName: str
        :param _ApproverId: 审批人id
注意：此字段可能返回 null，表示取不到有效值。
        :type ApproverId: str
        :param _ApproverName: 审批人名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ApproverName: str
        :param _ApproveProjectName: 审批所属项目
注意：此字段可能返回 null，表示取不到有效值。
        :type ApproveProjectName: str
        """
        self._ApplicantId = None
        self._ApplicantName = None
        self._Remark = None
        self._ApproveClassification = None
        self._ApproveId = None
        self._ApproveType = None
        self._Reason = None
        self._CreateTime = None
        self._ApproveTime = None
        self._ApproveClassificationName = None
        self._Status = None
        self._ApproveTypeName = None
        self._ErrorMessage = None
        self._ApplyName = None
        self._ApproverId = None
        self._ApproverName = None
        self._ApproveProjectName = None

    @property
    def ApplicantId(self):
        return self._ApplicantId

    @ApplicantId.setter
    def ApplicantId(self, ApplicantId):
        self._ApplicantId = ApplicantId

    @property
    def ApplicantName(self):
        return self._ApplicantName

    @ApplicantName.setter
    def ApplicantName(self, ApplicantName):
        self._ApplicantName = ApplicantName

    @property
    def Remark(self):
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def ApproveClassification(self):
        return self._ApproveClassification

    @ApproveClassification.setter
    def ApproveClassification(self, ApproveClassification):
        self._ApproveClassification = ApproveClassification

    @property
    def ApproveId(self):
        return self._ApproveId

    @ApproveId.setter
    def ApproveId(self, ApproveId):
        self._ApproveId = ApproveId

    @property
    def ApproveType(self):
        return self._ApproveType

    @ApproveType.setter
    def ApproveType(self, ApproveType):
        self._ApproveType = ApproveType

    @property
    def Reason(self):
        return self._Reason

    @Reason.setter
    def Reason(self, Reason):
        self._Reason = Reason

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ApproveTime(self):
        return self._ApproveTime

    @ApproveTime.setter
    def ApproveTime(self, ApproveTime):
        self._ApproveTime = ApproveTime

    @property
    def ApproveClassificationName(self):
        return self._ApproveClassificationName

    @ApproveClassificationName.setter
    def ApproveClassificationName(self, ApproveClassificationName):
        self._ApproveClassificationName = ApproveClassificationName

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ApproveTypeName(self):
        return self._ApproveTypeName

    @ApproveTypeName.setter
    def ApproveTypeName(self, ApproveTypeName):
        self._ApproveTypeName = ApproveTypeName

    @property
    def ErrorMessage(self):
        return self._ErrorMessage

    @ErrorMessage.setter
    def ErrorMessage(self, ErrorMessage):
        self._ErrorMessage = ErrorMessage

    @property
    def ApplyName(self):
        return self._ApplyName

    @ApplyName.setter
    def ApplyName(self, ApplyName):
        self._ApplyName = ApplyName

    @property
    def ApproverId(self):
        return self._ApproverId

    @ApproverId.setter
    def ApproverId(self, ApproverId):
        self._ApproverId = ApproverId

    @property
    def ApproverName(self):
        return self._ApproverName

    @ApproverName.setter
    def ApproverName(self, ApproverName):
        self._ApproverName = ApproverName

    @property
    def ApproveProjectName(self):
        return self._ApproveProjectName

    @ApproveProjectName.setter
    def ApproveProjectName(self, ApproveProjectName):
        self._ApproveProjectName = ApproveProjectName


    def _deserialize(self, params):
        self._ApplicantId = params.get("ApplicantId")
        self._ApplicantName = params.get("ApplicantName")
        self._Remark = params.get("Remark")
        self._ApproveClassification = params.get("ApproveClassification")
        self._ApproveId = params.get("ApproveId")
        self._ApproveType = params.get("ApproveType")
        self._Reason = params.get("Reason")
        self._CreateTime = params.get("CreateTime")
        self._ApproveTime = params.get("ApproveTime")
        self._ApproveClassificationName = params.get("ApproveClassificationName")
        self._Status = params.get("Status")
        self._ApproveTypeName = params.get("ApproveTypeName")
        self._ErrorMessage = params.get("ErrorMessage")
        self._ApplyName = params.get("ApplyName")
        self._ApproverId = params.get("ApproverId")
        self._ApproverName = params.get("ApproverName")
        self._ApproveProjectName = params.get("ApproveProjectName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApproveModify(AbstractModel):
    """修改审批单状态

    """

    def __init__(self):
        r"""
        :param _ApproveId: 审批单id
        :type ApproveId: str
        :param _Success: 是否修改成功
        :type Success: bool
        """
        self._ApproveId = None
        self._Success = None

    @property
    def ApproveId(self):
        return self._ApproveId

    @ApproveId.setter
    def ApproveId(self, ApproveId):
        self._ApproveId = ApproveId

    @property
    def Success(self):
        return self._Success

    @Success.setter
    def Success(self, Success):
        self._Success = Success


    def _deserialize(self, params):
        self._ApproveId = params.get("ApproveId")
        self._Success = params.get("Success")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApproveType(AbstractModel):
    """审批分类

    """

    def __init__(self):
        r"""
        :param _Type: 申请分类key
        :type Type: str
        :param _TypeName: 类型名称
        :type TypeName: str
        :param _Classification: 申请类型key
        :type Classification: str
        """
        self._Type = None
        self._TypeName = None
        self._Classification = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def TypeName(self):
        return self._TypeName

    @TypeName.setter
    def TypeName(self, TypeName):
        self._TypeName = TypeName

    @property
    def Classification(self):
        return self._Classification

    @Classification.setter
    def Classification(self, Classification):
        self._Classification = Classification


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._TypeName = params.get("TypeName")
        self._Classification = params.get("Classification")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AttributeItemDTO(AbstractModel):
    """aiops基础信息

    """

    def __init__(self):
        r"""
        :param _Key: key
注意：此字段可能返回 null，表示取不到有效值。
        :type Key: str
        :param _Value: value
注意：此字段可能返回 null，表示取不到有效值。
        :type Value: str
        :param _Description: 描述
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        """
        self._Key = None
        self._Value = None
        self._Description = None

    @property
    def Key(self):
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key

    @property
    def Value(self):
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._Key = params.get("Key")
        self._Value = params.get("Value")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AttributeItemDsVO(AbstractModel):
    """AttributeItemVO参数

    """

    def __init__(self):
        r"""
        :param _Key: Key值
注意：此字段可能返回 null，表示取不到有效值。
        :type Key: str
        :param _Value: Value值
注意：此字段可能返回 null，表示取不到有效值。
        :type Value: str
        :param _Description: 描述
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        """
        self._Key = None
        self._Value = None
        self._Description = None

    @property
    def Key(self):
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key

    @property
    def Value(self):
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._Key = params.get("Key")
        self._Value = params.get("Value")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaselineDetailResponse(AbstractModel):
    """BaselineDetailResponse

    """

    def __init__(self):
        r"""
        :param _BaselineDto: 1
注意：此字段可能返回 null，表示取不到有效值。
        :type BaselineDto: :class:`tencentcloud.wedata.v20210820.models.BaselineDto`
        :param _BaselineCreateAlarmRuleRequest: 1
注意：此字段可能返回 null，表示取不到有效值。
        :type BaselineCreateAlarmRuleRequest: :class:`tencentcloud.wedata.v20210820.models.CreateAlarmRuleRequest`
        :param _IsNewAlarm: 无
注意：此字段可能返回 null，表示取不到有效值。
        :type IsNewAlarm: bool
        """
        self._BaselineDto = None
        self._BaselineCreateAlarmRuleRequest = None
        self._IsNewAlarm = None

    @property
    def BaselineDto(self):
        return self._BaselineDto

    @BaselineDto.setter
    def BaselineDto(self, BaselineDto):
        self._BaselineDto = BaselineDto

    @property
    def BaselineCreateAlarmRuleRequest(self):
        return self._BaselineCreateAlarmRuleRequest

    @BaselineCreateAlarmRuleRequest.setter
    def BaselineCreateAlarmRuleRequest(self, BaselineCreateAlarmRuleRequest):
        self._BaselineCreateAlarmRuleRequest = BaselineCreateAlarmRuleRequest

    @property
    def IsNewAlarm(self):
        return self._IsNewAlarm

    @IsNewAlarm.setter
    def IsNewAlarm(self, IsNewAlarm):
        self._IsNewAlarm = IsNewAlarm


    def _deserialize(self, params):
        if params.get("BaselineDto") is not None:
            self._BaselineDto = BaselineDto()
            self._BaselineDto._deserialize(params.get("BaselineDto"))
        if params.get("BaselineCreateAlarmRuleRequest") is not None:
            self._BaselineCreateAlarmRuleRequest = CreateAlarmRuleRequest()
            self._BaselineCreateAlarmRuleRequest._deserialize(params.get("BaselineCreateAlarmRuleRequest"))
        self._IsNewAlarm = params.get("IsNewAlarm")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaselineDto(AbstractModel):
    """基线实例

    """

    def __init__(self):
        r"""
        :param _Id: 基线id
        :type Id: int
        :param _BaselineName: 基线名称
        :type BaselineName: str
        :param _BaselineType: 天基线/小时基线
        :type BaselineType: str
        :param _CreateTime: 基线创建时间
        :type CreateTime: str
        :param _PromiseTasks: 保障任务
注意：此字段可能返回 null，表示取不到有效值。
        :type PromiseTasks: list of BaselineTaskDto
        :param _AlarmRule: 告警规则
        :type AlarmRule: :class:`tencentcloud.wedata.v20210820.models.AlarmRuleDto`
        :param _BaselineStatus: 基线状态，待提交, 运行中，停止
        :type BaselineStatus: str
        :param _LatestBaselineInstanceStatus: 最新基线实例运行状态
注意：此字段可能返回 null，表示取不到有效值。
        :type LatestBaselineInstanceStatus: str
        :param _WarningMargin: 预警余量/单位分钟
        :type WarningMargin: int
        :param _PromiseTime: 承诺时间
        :type PromiseTime: str
        :param _InChargeUin: 责任人uin
        :type InChargeUin: str
        :param _InChargeName: 责任人名称
        :type InChargeName: str
        :param _UserUin: 当前用户uin
        :type UserUin: str
        :param _UserName: 当前用户名字
注意：此字段可能返回 null，表示取不到有效值。
        :type UserName: str
        :param _OwnerUin: 主账号uin
        :type OwnerUin: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _AppId: 租户id
        :type AppId: str
        :param _UpdateTime: 更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: str
        """
        self._Id = None
        self._BaselineName = None
        self._BaselineType = None
        self._CreateTime = None
        self._PromiseTasks = None
        self._AlarmRule = None
        self._BaselineStatus = None
        self._LatestBaselineInstanceStatus = None
        self._WarningMargin = None
        self._PromiseTime = None
        self._InChargeUin = None
        self._InChargeName = None
        self._UserUin = None
        self._UserName = None
        self._OwnerUin = None
        self._ProjectId = None
        self._AppId = None
        self._UpdateTime = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def BaselineName(self):
        return self._BaselineName

    @BaselineName.setter
    def BaselineName(self, BaselineName):
        self._BaselineName = BaselineName

    @property
    def BaselineType(self):
        return self._BaselineType

    @BaselineType.setter
    def BaselineType(self, BaselineType):
        self._BaselineType = BaselineType

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def PromiseTasks(self):
        return self._PromiseTasks

    @PromiseTasks.setter
    def PromiseTasks(self, PromiseTasks):
        self._PromiseTasks = PromiseTasks

    @property
    def AlarmRule(self):
        return self._AlarmRule

    @AlarmRule.setter
    def AlarmRule(self, AlarmRule):
        self._AlarmRule = AlarmRule

    @property
    def BaselineStatus(self):
        return self._BaselineStatus

    @BaselineStatus.setter
    def BaselineStatus(self, BaselineStatus):
        self._BaselineStatus = BaselineStatus

    @property
    def LatestBaselineInstanceStatus(self):
        return self._LatestBaselineInstanceStatus

    @LatestBaselineInstanceStatus.setter
    def LatestBaselineInstanceStatus(self, LatestBaselineInstanceStatus):
        self._LatestBaselineInstanceStatus = LatestBaselineInstanceStatus

    @property
    def WarningMargin(self):
        return self._WarningMargin

    @WarningMargin.setter
    def WarningMargin(self, WarningMargin):
        self._WarningMargin = WarningMargin

    @property
    def PromiseTime(self):
        return self._PromiseTime

    @PromiseTime.setter
    def PromiseTime(self, PromiseTime):
        self._PromiseTime = PromiseTime

    @property
    def InChargeUin(self):
        return self._InChargeUin

    @InChargeUin.setter
    def InChargeUin(self, InChargeUin):
        self._InChargeUin = InChargeUin

    @property
    def InChargeName(self):
        return self._InChargeName

    @InChargeName.setter
    def InChargeName(self, InChargeName):
        self._InChargeName = InChargeName

    @property
    def UserUin(self):
        return self._UserUin

    @UserUin.setter
    def UserUin(self, UserUin):
        self._UserUin = UserUin

    @property
    def UserName(self):
        return self._UserName

    @UserName.setter
    def UserName(self, UserName):
        self._UserName = UserName

    @property
    def OwnerUin(self):
        return self._OwnerUin

    @OwnerUin.setter
    def OwnerUin(self, OwnerUin):
        self._OwnerUin = OwnerUin

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def AppId(self):
        return self._AppId

    @AppId.setter
    def AppId(self, AppId):
        self._AppId = AppId

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._BaselineName = params.get("BaselineName")
        self._BaselineType = params.get("BaselineType")
        self._CreateTime = params.get("CreateTime")
        if params.get("PromiseTasks") is not None:
            self._PromiseTasks = []
            for item in params.get("PromiseTasks"):
                obj = BaselineTaskDto()
                obj._deserialize(item)
                self._PromiseTasks.append(obj)
        if params.get("AlarmRule") is not None:
            self._AlarmRule = AlarmRuleDto()
            self._AlarmRule._deserialize(params.get("AlarmRule"))
        self._BaselineStatus = params.get("BaselineStatus")
        self._LatestBaselineInstanceStatus = params.get("LatestBaselineInstanceStatus")
        self._WarningMargin = params.get("WarningMargin")
        self._PromiseTime = params.get("PromiseTime")
        self._InChargeUin = params.get("InChargeUin")
        self._InChargeName = params.get("InChargeName")
        self._UserUin = params.get("UserUin")
        self._UserName = params.get("UserName")
        self._OwnerUin = params.get("OwnerUin")
        self._ProjectId = params.get("ProjectId")
        self._AppId = params.get("AppId")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaselineInstanceVo(AbstractModel):
    """基线实例

    """

    def __init__(self):
        r"""
        :param _Id: 基线实例id
注意：此字段可能返回 null，表示取不到有效值。
        :type Id: int
        :param _BaselineId: 基线id
注意：此字段可能返回 null，表示取不到有效值。
        :type BaselineId: int
        :param _BaselineName: 基线名称
注意：此字段可能返回 null，表示取不到有效值。
        :type BaselineName: str
        :param _BaselineType: 基线类型，D: 天基线 / H 小时基线
注意：此字段可能返回 null，表示取不到有效值。
        :type BaselineType: str
        :param _BaselineDataTime: 基线实例数据时间
注意：此字段可能返回 null，表示取不到有效值。
        :type BaselineDataTime: str
        :param _CreateTime: 基线实例生成时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateTime: str
        :param _EstimatedEndTime: 基线实例预计完成时间
注意：此字段可能返回 null，表示取不到有效值。
        :type EstimatedEndTime: str
        :param _BaselineInstanceStatus: 基线实例状态，P:暂停/ SF:安全/ WN:预警/ BL:破线 / TF:任务失败
注意：此字段可能返回 null，表示取不到有效值。
        :type BaselineInstanceStatus: str
        :param _InChargeUin: 责任人uin
注意：此字段可能返回 null，表示取不到有效值。
        :type InChargeUin: str
        :param _InChargeName: 责任人名称
注意：此字段可能返回 null，表示取不到有效值。
        :type InChargeName: str
        :param _WarningMargin: 预警余量/单位分钟
注意：此字段可能返回 null，表示取不到有效值。
        :type WarningMargin: int
        :param _PromiseTime: 承诺时间
注意：此字段可能返回 null，表示取不到有效值。
        :type PromiseTime: str
        :param _AlarmLevel: 告警级别 N: 普通 / I重要 / E: 紧急
注意：此字段可能返回 null，表示取不到有效值。
        :type AlarmLevel: str
        :param _ProjectId: 项目id
注意：此字段可能返回 null，表示取不到有效值。
        :type ProjectId: str
        :param _IsReady: 基线实例ready状态。NEW_GENERATED_INSTANCE:产生实例/RENDER_DAG:渲染DAG/CALCULATE_PATH:计算路径/COMPLETE:完成
注意：此字段可能返回 null，表示取不到有效值。
        :type IsReady: str
        :param _ShardKey: 该基线由哪个机器处理
注意：此字段可能返回 null，表示取不到有效值。
        :type ShardKey: str
        :param _ExceptionalTaskInstances: 异常任务实例
注意：此字段可能返回 null，表示取不到有效值。
        :type ExceptionalTaskInstances: list of BaselineTaskInstanceDto
        :param _TaskInstances: 关联的所有任务实例
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskInstances: list of BaselineTaskInstanceDto
        :param _CriticalStartTime: 任务实例DAG整体启动时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CriticalStartTime: str
        :param _CriticalTaskInstances: 基线实例上的关键任务实例
注意：此字段可能返回 null，表示取不到有效值。
        :type CriticalTaskInstances: list of BaselineTaskInstanceDto
        :param _UpdateTime: 更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: str
        :param _BaselineTaskInstances: 基线实例与保障任务实例映射
注意：此字段可能返回 null，表示取不到有效值。
        :type BaselineTaskInstances: list of BaselineTaskInstanceDto
        :param _AppId: 租户id
注意：此字段可能返回 null，表示取不到有效值。
        :type AppId: str
        :param _OwnerUin: 主账号uin
注意：此字段可能返回 null，表示取不到有效值。
        :type OwnerUin: str
        :param _UserUin: 当前用户uin
注意：此字段可能返回 null，表示取不到有效值。
        :type UserUin: str
        """
        self._Id = None
        self._BaselineId = None
        self._BaselineName = None
        self._BaselineType = None
        self._BaselineDataTime = None
        self._CreateTime = None
        self._EstimatedEndTime = None
        self._BaselineInstanceStatus = None
        self._InChargeUin = None
        self._InChargeName = None
        self._WarningMargin = None
        self._PromiseTime = None
        self._AlarmLevel = None
        self._ProjectId = None
        self._IsReady = None
        self._ShardKey = None
        self._ExceptionalTaskInstances = None
        self._TaskInstances = None
        self._CriticalStartTime = None
        self._CriticalTaskInstances = None
        self._UpdateTime = None
        self._BaselineTaskInstances = None
        self._AppId = None
        self._OwnerUin = None
        self._UserUin = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def BaselineId(self):
        return self._BaselineId

    @BaselineId.setter
    def BaselineId(self, BaselineId):
        self._BaselineId = BaselineId

    @property
    def BaselineName(self):
        return self._BaselineName

    @BaselineName.setter
    def BaselineName(self, BaselineName):
        self._BaselineName = BaselineName

    @property
    def BaselineType(self):
        return self._BaselineType

    @BaselineType.setter
    def BaselineType(self, BaselineType):
        self._BaselineType = BaselineType

    @property
    def BaselineDataTime(self):
        return self._BaselineDataTime

    @BaselineDataTime.setter
    def BaselineDataTime(self, BaselineDataTime):
        self._BaselineDataTime = BaselineDataTime

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def EstimatedEndTime(self):
        return self._EstimatedEndTime

    @EstimatedEndTime.setter
    def EstimatedEndTime(self, EstimatedEndTime):
        self._EstimatedEndTime = EstimatedEndTime

    @property
    def BaselineInstanceStatus(self):
        return self._BaselineInstanceStatus

    @BaselineInstanceStatus.setter
    def BaselineInstanceStatus(self, BaselineInstanceStatus):
        self._BaselineInstanceStatus = BaselineInstanceStatus

    @property
    def InChargeUin(self):
        return self._InChargeUin

    @InChargeUin.setter
    def InChargeUin(self, InChargeUin):
        self._InChargeUin = InChargeUin

    @property
    def InChargeName(self):
        return self._InChargeName

    @InChargeName.setter
    def InChargeName(self, InChargeName):
        self._InChargeName = InChargeName

    @property
    def WarningMargin(self):
        return self._WarningMargin

    @WarningMargin.setter
    def WarningMargin(self, WarningMargin):
        self._WarningMargin = WarningMargin

    @property
    def PromiseTime(self):
        return self._PromiseTime

    @PromiseTime.setter
    def PromiseTime(self, PromiseTime):
        self._PromiseTime = PromiseTime

    @property
    def AlarmLevel(self):
        return self._AlarmLevel

    @AlarmLevel.setter
    def AlarmLevel(self, AlarmLevel):
        self._AlarmLevel = AlarmLevel

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def IsReady(self):
        return self._IsReady

    @IsReady.setter
    def IsReady(self, IsReady):
        self._IsReady = IsReady

    @property
    def ShardKey(self):
        return self._ShardKey

    @ShardKey.setter
    def ShardKey(self, ShardKey):
        self._ShardKey = ShardKey

    @property
    def ExceptionalTaskInstances(self):
        return self._ExceptionalTaskInstances

    @ExceptionalTaskInstances.setter
    def ExceptionalTaskInstances(self, ExceptionalTaskInstances):
        self._ExceptionalTaskInstances = ExceptionalTaskInstances

    @property
    def TaskInstances(self):
        return self._TaskInstances

    @TaskInstances.setter
    def TaskInstances(self, TaskInstances):
        self._TaskInstances = TaskInstances

    @property
    def CriticalStartTime(self):
        return self._CriticalStartTime

    @CriticalStartTime.setter
    def CriticalStartTime(self, CriticalStartTime):
        self._CriticalStartTime = CriticalStartTime

    @property
    def CriticalTaskInstances(self):
        return self._CriticalTaskInstances

    @CriticalTaskInstances.setter
    def CriticalTaskInstances(self, CriticalTaskInstances):
        self._CriticalTaskInstances = CriticalTaskInstances

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def BaselineTaskInstances(self):
        return self._BaselineTaskInstances

    @BaselineTaskInstances.setter
    def BaselineTaskInstances(self, BaselineTaskInstances):
        self._BaselineTaskInstances = BaselineTaskInstances

    @property
    def AppId(self):
        return self._AppId

    @AppId.setter
    def AppId(self, AppId):
        self._AppId = AppId

    @property
    def OwnerUin(self):
        return self._OwnerUin

    @OwnerUin.setter
    def OwnerUin(self, OwnerUin):
        self._OwnerUin = OwnerUin

    @property
    def UserUin(self):
        return self._UserUin

    @UserUin.setter
    def UserUin(self, UserUin):
        self._UserUin = UserUin


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._BaselineId = params.get("BaselineId")
        self._BaselineName = params.get("BaselineName")
        self._BaselineType = params.get("BaselineType")
        self._BaselineDataTime = params.get("BaselineDataTime")
        self._CreateTime = params.get("CreateTime")
        self._EstimatedEndTime = params.get("EstimatedEndTime")
        self._BaselineInstanceStatus = params.get("BaselineInstanceStatus")
        self._InChargeUin = params.get("InChargeUin")
        self._InChargeName = params.get("InChargeName")
        self._WarningMargin = params.get("WarningMargin")
        self._PromiseTime = params.get("PromiseTime")
        self._AlarmLevel = params.get("AlarmLevel")
        self._ProjectId = params.get("ProjectId")
        self._IsReady = params.get("IsReady")
        self._ShardKey = params.get("ShardKey")
        if params.get("ExceptionalTaskInstances") is not None:
            self._ExceptionalTaskInstances = []
            for item in params.get("ExceptionalTaskInstances"):
                obj = BaselineTaskInstanceDto()
                obj._deserialize(item)
                self._ExceptionalTaskInstances.append(obj)
        if params.get("TaskInstances") is not None:
            self._TaskInstances = []
            for item in params.get("TaskInstances"):
                obj = BaselineTaskInstanceDto()
                obj._deserialize(item)
                self._TaskInstances.append(obj)
        self._CriticalStartTime = params.get("CriticalStartTime")
        if params.get("CriticalTaskInstances") is not None:
            self._CriticalTaskInstances = []
            for item in params.get("CriticalTaskInstances"):
                obj = BaselineTaskInstanceDto()
                obj._deserialize(item)
                self._CriticalTaskInstances.append(obj)
        self._UpdateTime = params.get("UpdateTime")
        if params.get("BaselineTaskInstances") is not None:
            self._BaselineTaskInstances = []
            for item in params.get("BaselineTaskInstances"):
                obj = BaselineTaskInstanceDto()
                obj._deserialize(item)
                self._BaselineTaskInstances.append(obj)
        self._AppId = params.get("AppId")
        self._OwnerUin = params.get("OwnerUin")
        self._UserUin = params.get("UserUin")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaselineTaskDto(AbstractModel):
    """基线关联任务

    """

    def __init__(self):
        r"""
        :param _Id: 变更记录id
注意：此字段可能返回 null，表示取不到有效值。
        :type Id: int
        :param _BaselineId: 基线id
注意：此字段可能返回 null，表示取不到有效值。
        :type BaselineId: int
        :param _TaskId: 任务id
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskId: str
        :param _TaskName: 任务名称
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskName: str
        :param _EstimatedCostTime: 任务运行平均时间/单位秒
注意：此字段可能返回 null，表示取不到有效值。
        :type EstimatedCostTime: int
        :param _UpstreamTaskIds: 上游实例id,多个实例用,分开
注意：此字段可能返回 null，表示取不到有效值。
        :type UpstreamTaskIds: :class:`tencentcloud.wedata.v20210820.models.StringListNode`
        :param _DownstreamTaskIds: 下游实例id,多个实例用,分开
注意：此字段可能返回 null，表示取不到有效值。
        :type DownstreamTaskIds: :class:`tencentcloud.wedata.v20210820.models.StringListNode`
        :param _IsPromiseTask: 否是保障任务
注意：此字段可能返回 null，表示取不到有效值。
        :type IsPromiseTask: bool
        :param _UserUin: 当前用户uin
注意：此字段可能返回 null，表示取不到有效值。
        :type UserUin: str
        :param _OwnerUin: 主账号uin
注意：此字段可能返回 null，表示取不到有效值。
        :type OwnerUin: str
        :param _ProjectId: 项目id
注意：此字段可能返回 null，表示取不到有效值。
        :type ProjectId: str
        :param _AppId: 租户id
注意：此字段可能返回 null，表示取不到有效值。
        :type AppId: str
        :param _WorkflowName: 工作流名称
注意：此字段可能返回 null，表示取不到有效值。
        :type WorkflowName: str
        :param _WorkflowId: 工作流id
注意：此字段可能返回 null，表示取不到有效值。
        :type WorkflowId: str
        :param _TaskCycle: 任务周期类型
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskCycle: str
        :param _TaskInChargeUin: 任务负责人名字
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskInChargeUin: str
        :param _TaskInChargeName: 任务负责人uin
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskInChargeName: str
        :param _AccessBenchmark: 任务准入基准
注意：此字段可能返回 null，表示取不到有效值。
        :type AccessBenchmark: str
        :param _AccessBenchmarkDesc: 任务准入基准诊断信息
注意：此字段可能返回 null，表示取不到有效值。
        :type AccessBenchmarkDesc: str
        :param _CreateTime: 创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateTime: str
        :param _UpdateTime: 更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: str
        """
        self._Id = None
        self._BaselineId = None
        self._TaskId = None
        self._TaskName = None
        self._EstimatedCostTime = None
        self._UpstreamTaskIds = None
        self._DownstreamTaskIds = None
        self._IsPromiseTask = None
        self._UserUin = None
        self._OwnerUin = None
        self._ProjectId = None
        self._AppId = None
        self._WorkflowName = None
        self._WorkflowId = None
        self._TaskCycle = None
        self._TaskInChargeUin = None
        self._TaskInChargeName = None
        self._AccessBenchmark = None
        self._AccessBenchmarkDesc = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def BaselineId(self):
        return self._BaselineId

    @BaselineId.setter
    def BaselineId(self, BaselineId):
        self._BaselineId = BaselineId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TaskName(self):
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def EstimatedCostTime(self):
        return self._EstimatedCostTime

    @EstimatedCostTime.setter
    def EstimatedCostTime(self, EstimatedCostTime):
        self._EstimatedCostTime = EstimatedCostTime

    @property
    def UpstreamTaskIds(self):
        return self._UpstreamTaskIds

    @UpstreamTaskIds.setter
    def UpstreamTaskIds(self, UpstreamTaskIds):
        self._UpstreamTaskIds = UpstreamTaskIds

    @property
    def DownstreamTaskIds(self):
        return self._DownstreamTaskIds

    @DownstreamTaskIds.setter
    def DownstreamTaskIds(self, DownstreamTaskIds):
        self._DownstreamTaskIds = DownstreamTaskIds

    @property
    def IsPromiseTask(self):
        return self._IsPromiseTask

    @IsPromiseTask.setter
    def IsPromiseTask(self, IsPromiseTask):
        self._IsPromiseTask = IsPromiseTask

    @property
    def UserUin(self):
        return self._UserUin

    @UserUin.setter
    def UserUin(self, UserUin):
        self._UserUin = UserUin

    @property
    def OwnerUin(self):
        return self._OwnerUin

    @OwnerUin.setter
    def OwnerUin(self, OwnerUin):
        self._OwnerUin = OwnerUin

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def AppId(self):
        return self._AppId

    @AppId.setter
    def AppId(self, AppId):
        self._AppId = AppId

    @property
    def WorkflowName(self):
        return self._WorkflowName

    @WorkflowName.setter
    def WorkflowName(self, WorkflowName):
        self._WorkflowName = WorkflowName

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId

    @property
    def TaskCycle(self):
        return self._TaskCycle

    @TaskCycle.setter
    def TaskCycle(self, TaskCycle):
        self._TaskCycle = TaskCycle

    @property
    def TaskInChargeUin(self):
        return self._TaskInChargeUin

    @TaskInChargeUin.setter
    def TaskInChargeUin(self, TaskInChargeUin):
        self._TaskInChargeUin = TaskInChargeUin

    @property
    def TaskInChargeName(self):
        return self._TaskInChargeName

    @TaskInChargeName.setter
    def TaskInChargeName(self, TaskInChargeName):
        self._TaskInChargeName = TaskInChargeName

    @property
    def AccessBenchmark(self):
        return self._AccessBenchmark

    @AccessBenchmark.setter
    def AccessBenchmark(self, AccessBenchmark):
        self._AccessBenchmark = AccessBenchmark

    @property
    def AccessBenchmarkDesc(self):
        return self._AccessBenchmarkDesc

    @AccessBenchmarkDesc.setter
    def AccessBenchmarkDesc(self, AccessBenchmarkDesc):
        self._AccessBenchmarkDesc = AccessBenchmarkDesc

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._BaselineId = params.get("BaselineId")
        self._TaskId = params.get("TaskId")
        self._TaskName = params.get("TaskName")
        self._EstimatedCostTime = params.get("EstimatedCostTime")
        if params.get("UpstreamTaskIds") is not None:
            self._UpstreamTaskIds = StringListNode()
            self._UpstreamTaskIds._deserialize(params.get("UpstreamTaskIds"))
        if params.get("DownstreamTaskIds") is not None:
            self._DownstreamTaskIds = StringListNode()
            self._DownstreamTaskIds._deserialize(params.get("DownstreamTaskIds"))
        self._IsPromiseTask = params.get("IsPromiseTask")
        self._UserUin = params.get("UserUin")
        self._OwnerUin = params.get("OwnerUin")
        self._ProjectId = params.get("ProjectId")
        self._AppId = params.get("AppId")
        self._WorkflowName = params.get("WorkflowName")
        self._WorkflowId = params.get("WorkflowId")
        self._TaskCycle = params.get("TaskCycle")
        self._TaskInChargeUin = params.get("TaskInChargeUin")
        self._TaskInChargeName = params.get("TaskInChargeName")
        self._AccessBenchmark = params.get("AccessBenchmark")
        self._AccessBenchmarkDesc = params.get("AccessBenchmarkDesc")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaselineTaskInfo(AbstractModel):
    """BaselineTaskInfo

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _TaskName: 任务名称
        :type TaskName: str
        :param _TaskId: 任务id
        :type TaskId: str
        :param _TaskCycle: 任务调度周期
        :type TaskCycle: str
        :param _WorkflowName: 工作流名称
        :type WorkflowName: str
        :param _WorkflowId: 工作流id
        :type WorkflowId: str
        :param _TaskInChargeName: 任务责任人名称
        :type TaskInChargeName: str
        :param _TaskInChargeUin: 任务责任人id
        :type TaskInChargeUin: str
        """
        self._ProjectId = None
        self._TaskName = None
        self._TaskId = None
        self._TaskCycle = None
        self._WorkflowName = None
        self._WorkflowId = None
        self._TaskInChargeName = None
        self._TaskInChargeUin = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskName(self):
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TaskCycle(self):
        return self._TaskCycle

    @TaskCycle.setter
    def TaskCycle(self, TaskCycle):
        self._TaskCycle = TaskCycle

    @property
    def WorkflowName(self):
        return self._WorkflowName

    @WorkflowName.setter
    def WorkflowName(self, WorkflowName):
        self._WorkflowName = WorkflowName

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId

    @property
    def TaskInChargeName(self):
        return self._TaskInChargeName

    @TaskInChargeName.setter
    def TaskInChargeName(self, TaskInChargeName):
        self._TaskInChargeName = TaskInChargeName

    @property
    def TaskInChargeUin(self):
        return self._TaskInChargeUin

    @TaskInChargeUin.setter
    def TaskInChargeUin(self, TaskInChargeUin):
        self._TaskInChargeUin = TaskInChargeUin


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TaskName = params.get("TaskName")
        self._TaskId = params.get("TaskId")
        self._TaskCycle = params.get("TaskCycle")
        self._WorkflowName = params.get("WorkflowName")
        self._WorkflowId = params.get("WorkflowId")
        self._TaskInChargeName = params.get("TaskInChargeName")
        self._TaskInChargeUin = params.get("TaskInChargeUin")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaselineTaskInstanceDto(AbstractModel):
    """基线实例

    """

    def __init__(self):
        r"""
        :param _Id: 任务实例变更记录id
注意：此字段可能返回 null，表示取不到有效值。
        :type Id: int
        :param _BaselineInstanceId: 基线实例id
注意：此字段可能返回 null，表示取不到有效值。
        :type BaselineInstanceId: int
        :param _BaselineType: 基线周期, D: 天 / H: 小时
注意：此字段可能返回 null，表示取不到有效值。
        :type BaselineType: str
        :param _BaselineDataTime: 数据时间/基线实例应该应该生成的时间
注意：此字段可能返回 null，表示取不到有效值。
        :type BaselineDataTime: str
        :param _UpstreamInstanceIds: 上游实例id,多个实例用,分开.格式为taskId_curRunDate
注意：此字段可能返回 null，表示取不到有效值。
        :type UpstreamInstanceIds: str
        :param _DownstreamInstanceIds: 下游实例id,多个实例用,分开.格式为taskId_curRunDate
注意：此字段可能返回 null，表示取不到有效值。
        :type DownstreamInstanceIds: str
        :param _IsPromiseTask: 是否是保障任务的实例
注意：此字段可能返回 null，表示取不到有效值。
        :type IsPromiseTask: bool
        :param _TaskId: 任务id
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskId: str
        :param _CurRunDate: 任务实例的数据时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CurRunDate: str
        :param _TaskName: 任务名称
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskName: str
        :param _InCriticalPath: 是否在关键路径上，1表示在，0表示不在
注意：此字段可能返回 null，表示取不到有效值。
        :type InCriticalPath: int
        :param _InFirstLevel: 是否在DAG首层
注意：此字段可能返回 null，表示取不到有效值。
        :type InFirstLevel: bool
        :param _EstimatedCostTime: 实例预计耗时/单位秒
注意：此字段可能返回 null，表示取不到有效值。
        :type EstimatedCostTime: int
        :param _ActualCostTime: 实例实际耗时/单位秒
注意：此字段可能返回 null，表示取不到有效值。
        :type ActualCostTime: int
        :param _LatestStartTime: 预计最晚开始时间
注意：此字段可能返回 null，表示取不到有效值。
        :type LatestStartTime: str
        :param _ActualStartTime: 实际开始时间
注意：此字段可能返回 null，表示取不到有效值。
        :type ActualStartTime: str
        :param _EstimatedEndTime: 预计完成时间
注意：此字段可能返回 null，表示取不到有效值。
        :type EstimatedEndTime: str
        :param _LatestEndTime: 最晚完成时间
注意：此字段可能返回 null，表示取不到有效值。
        :type LatestEndTime: str
        :param _ActualEndTime: 实际完成时间
注意：此字段可能返回 null，表示取不到有效值。
        :type ActualEndTime: str
        :param _TaskInstanceStatus: 实例运行状态
WAITINT_TO_RUN:等待运行 / RUNNING: 正在运行 / COMPLETED: 执行成功 / FAILED: 执行失败
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskInstanceStatus: str
        :param _ProjectId: 项目id
注意：此字段可能返回 null，表示取不到有效值。
        :type ProjectId: str
        :param _ShardKey: 该基线由哪个机器处理
注意：此字段可能返回 null，表示取不到有效值。
        :type ShardKey: str
        :param _CreateTime: 创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateTime: str
        :param _UpdateTime: 更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: str
        :param _UserUin: 当前用户uin
注意：此字段可能返回 null，表示取不到有效值。
        :type UserUin: str
        :param _OwnerUin: 主账号uin
注意：此字段可能返回 null，表示取不到有效值。
        :type OwnerUin: str
        :param _AppId: 租户id
注意：此字段可能返回 null，表示取不到有效值。
        :type AppId: str
        :param _CriticalDependency: 关键路径依赖
注意：此字段可能返回 null，表示取不到有效值。
        :type CriticalDependency: str
        """
        self._Id = None
        self._BaselineInstanceId = None
        self._BaselineType = None
        self._BaselineDataTime = None
        self._UpstreamInstanceIds = None
        self._DownstreamInstanceIds = None
        self._IsPromiseTask = None
        self._TaskId = None
        self._CurRunDate = None
        self._TaskName = None
        self._InCriticalPath = None
        self._InFirstLevel = None
        self._EstimatedCostTime = None
        self._ActualCostTime = None
        self._LatestStartTime = None
        self._ActualStartTime = None
        self._EstimatedEndTime = None
        self._LatestEndTime = None
        self._ActualEndTime = None
        self._TaskInstanceStatus = None
        self._ProjectId = None
        self._ShardKey = None
        self._CreateTime = None
        self._UpdateTime = None
        self._UserUin = None
        self._OwnerUin = None
        self._AppId = None
        self._CriticalDependency = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def BaselineInstanceId(self):
        return self._BaselineInstanceId

    @BaselineInstanceId.setter
    def BaselineInstanceId(self, BaselineInstanceId):
        self._BaselineInstanceId = BaselineInstanceId

    @property
    def BaselineType(self):
        return self._BaselineType

    @BaselineType.setter
    def BaselineType(self, BaselineType):
        self._BaselineType = BaselineType

    @property
    def BaselineDataTime(self):
        return self._BaselineDataTime

    @BaselineDataTime.setter
    def BaselineDataTime(self, BaselineDataTime):
        self._BaselineDataTime = BaselineDataTime

    @property
    def UpstreamInstanceIds(self):
        return self._UpstreamInstanceIds

    @UpstreamInstanceIds.setter
    def UpstreamInstanceIds(self, UpstreamInstanceIds):
        self._UpstreamInstanceIds = UpstreamInstanceIds

    @property
    def DownstreamInstanceIds(self):
        return self._DownstreamInstanceIds

    @DownstreamInstanceIds.setter
    def DownstreamInstanceIds(self, DownstreamInstanceIds):
        self._DownstreamInstanceIds = DownstreamInstanceIds

    @property
    def IsPromiseTask(self):
        return self._IsPromiseTask

    @IsPromiseTask.setter
    def IsPromiseTask(self, IsPromiseTask):
        self._IsPromiseTask = IsPromiseTask

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def CurRunDate(self):
        return self._CurRunDate

    @CurRunDate.setter
    def CurRunDate(self, CurRunDate):
        self._CurRunDate = CurRunDate

    @property
    def TaskName(self):
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def InCriticalPath(self):
        return self._InCriticalPath

    @InCriticalPath.setter
    def InCriticalPath(self, InCriticalPath):
        self._InCriticalPath = InCriticalPath

    @property
    def InFirstLevel(self):
        return self._InFirstLevel

    @InFirstLevel.setter
    def InFirstLevel(self, InFirstLevel):
        self._InFirstLevel = InFirstLevel

    @property
    def EstimatedCostTime(self):
        return self._EstimatedCostTime

    @EstimatedCostTime.setter
    def EstimatedCostTime(self, EstimatedCostTime):
        self._EstimatedCostTime = EstimatedCostTime

    @property
    def ActualCostTime(self):
        return self._ActualCostTime

    @ActualCostTime.setter
    def ActualCostTime(self, ActualCostTime):
        self._ActualCostTime = ActualCostTime

    @property
    def LatestStartTime(self):
        return self._LatestStartTime

    @LatestStartTime.setter
    def LatestStartTime(self, LatestStartTime):
        self._LatestStartTime = LatestStartTime

    @property
    def ActualStartTime(self):
        return self._ActualStartTime

    @ActualStartTime.setter
    def ActualStartTime(self, ActualStartTime):
        self._ActualStartTime = ActualStartTime

    @property
    def EstimatedEndTime(self):
        return self._EstimatedEndTime

    @EstimatedEndTime.setter
    def EstimatedEndTime(self, EstimatedEndTime):
        self._EstimatedEndTime = EstimatedEndTime

    @property
    def LatestEndTime(self):
        return self._LatestEndTime

    @LatestEndTime.setter
    def LatestEndTime(self, LatestEndTime):
        self._LatestEndTime = LatestEndTime

    @property
    def ActualEndTime(self):
        return self._ActualEndTime

    @ActualEndTime.setter
    def ActualEndTime(self, ActualEndTime):
        self._ActualEndTime = ActualEndTime

    @property
    def TaskInstanceStatus(self):
        return self._TaskInstanceStatus

    @TaskInstanceStatus.setter
    def TaskInstanceStatus(self, TaskInstanceStatus):
        self._TaskInstanceStatus = TaskInstanceStatus

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ShardKey(self):
        return self._ShardKey

    @ShardKey.setter
    def ShardKey(self, ShardKey):
        self._ShardKey = ShardKey

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def UserUin(self):
        return self._UserUin

    @UserUin.setter
    def UserUin(self, UserUin):
        self._UserUin = UserUin

    @property
    def OwnerUin(self):
        return self._OwnerUin

    @OwnerUin.setter
    def OwnerUin(self, OwnerUin):
        self._OwnerUin = OwnerUin

    @property
    def AppId(self):
        return self._AppId

    @AppId.setter
    def AppId(self, AppId):
        self._AppId = AppId

    @property
    def CriticalDependency(self):
        return self._CriticalDependency

    @CriticalDependency.setter
    def CriticalDependency(self, CriticalDependency):
        self._CriticalDependency = CriticalDependency


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._BaselineInstanceId = params.get("BaselineInstanceId")
        self._BaselineType = params.get("BaselineType")
        self._BaselineDataTime = params.get("BaselineDataTime")
        self._UpstreamInstanceIds = params.get("UpstreamInstanceIds")
        self._DownstreamInstanceIds = params.get("DownstreamInstanceIds")
        self._IsPromiseTask = params.get("IsPromiseTask")
        self._TaskId = params.get("TaskId")
        self._CurRunDate = params.get("CurRunDate")
        self._TaskName = params.get("TaskName")
        self._InCriticalPath = params.get("InCriticalPath")
        self._InFirstLevel = params.get("InFirstLevel")
        self._EstimatedCostTime = params.get("EstimatedCostTime")
        self._ActualCostTime = params.get("ActualCostTime")
        self._LatestStartTime = params.get("LatestStartTime")
        self._ActualStartTime = params.get("ActualStartTime")
        self._EstimatedEndTime = params.get("EstimatedEndTime")
        self._LatestEndTime = params.get("LatestEndTime")
        self._ActualEndTime = params.get("ActualEndTime")
        self._TaskInstanceStatus = params.get("TaskInstanceStatus")
        self._ProjectId = params.get("ProjectId")
        self._ShardKey = params.get("ShardKey")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._UserUin = params.get("UserUin")
        self._OwnerUin = params.get("OwnerUin")
        self._AppId = params.get("AppId")
        self._CriticalDependency = params.get("CriticalDependency")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchCreateIntegrationTaskAlarmsRequest(AbstractModel):
    """BatchCreateIntegrationTaskAlarms请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskIds: 任务id
        :type TaskIds: list of str
        :param _TaskAlarmInfo: 告警配置信息
        :type TaskAlarmInfo: :class:`tencentcloud.wedata.v20210820.models.TaskAlarmInfo`
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._TaskIds = None
        self._TaskAlarmInfo = None
        self._ProjectId = None

    @property
    def TaskIds(self):
        return self._TaskIds

    @TaskIds.setter
    def TaskIds(self, TaskIds):
        self._TaskIds = TaskIds

    @property
    def TaskAlarmInfo(self):
        return self._TaskAlarmInfo

    @TaskAlarmInfo.setter
    def TaskAlarmInfo(self, TaskAlarmInfo):
        self._TaskAlarmInfo = TaskAlarmInfo

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskIds = params.get("TaskIds")
        if params.get("TaskAlarmInfo") is not None:
            self._TaskAlarmInfo = TaskAlarmInfo()
            self._TaskAlarmInfo._deserialize(params.get("TaskAlarmInfo"))
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchCreateIntegrationTaskAlarmsResponse(AbstractModel):
    """BatchCreateIntegrationTaskAlarms返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SuccessCount: 操作成功的任务数
注意：此字段可能返回 null，表示取不到有效值。
        :type SuccessCount: int
        :param _FailedCount: 操作失败的任务数
注意：此字段可能返回 null，表示取不到有效值。
        :type FailedCount: int
        :param _TotalCount: 任务总数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SuccessCount(self):
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class BatchCreateTaskVersionDTO(AbstractModel):
    """BatchCreateTaskVersion使用，描述任务信息

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskId: str
        :param _VersionRemark: VersionRemark
注意：此字段可能返回 null，表示取不到有效值。
        :type VersionRemark: str
        :param _FolderId: 文件夹ID
注意：此字段可能返回 null，表示取不到有效值。
        :type FolderId: str
        """
        self._TaskId = None
        self._VersionRemark = None
        self._FolderId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def VersionRemark(self):
        return self._VersionRemark

    @VersionRemark.setter
    def VersionRemark(self, VersionRemark):
        self._VersionRemark = VersionRemark

    @property
    def FolderId(self):
        return self._FolderId

    @FolderId.setter
    def FolderId(self, FolderId):
        self._FolderId = FolderId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._VersionRemark = params.get("VersionRemark")
        self._FolderId = params.get("FolderId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchCreateTaskVersionDsDTOLite(AbstractModel):
    """BatchCreateTaskVersionDs使用的TaskVersionDsDTO

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskId: str
        :param _VersionRemark: 版本备注
注意：此字段可能返回 null，表示取不到有效值。
        :type VersionRemark: str
        :param _TaskInfo: 任务信息
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskInfo: :class:`tencentcloud.wedata.v20210820.models.TaskDsDTOLiteV2`
        """
        self._TaskId = None
        self._VersionRemark = None
        self._TaskInfo = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def VersionRemark(self):
        return self._VersionRemark

    @VersionRemark.setter
    def VersionRemark(self, VersionRemark):
        self._VersionRemark = VersionRemark

    @property
    def TaskInfo(self):
        return self._TaskInfo

    @TaskInfo.setter
    def TaskInfo(self, TaskInfo):
        self._TaskInfo = TaskInfo


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._VersionRemark = params.get("VersionRemark")
        if params.get("TaskInfo") is not None:
            self._TaskInfo = TaskDsDTOLiteV2()
            self._TaskInfo._deserialize(params.get("TaskInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchCreateTaskVersionDsRequest(AbstractModel):
    """BatchCreateTaskVersionDs请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskVersionDTOs: 任务版本信息
        :type TaskVersionDTOs: list of BatchCreateTaskVersionDsDTOLite
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _AutoRun: 是否自动运行
        :type AutoRun: bool
        :param _AlarmWays: 告警方式:email-邮件;sms-短信;wecom-企业微信
        :type AlarmWays: str
        :param _AlarmRecipientTypes: 告警对象:1-项目管理员，2-任务责任人
        :type AlarmRecipientTypes: str
        :param _NeedCheckParentSubmitted: 是否需要校验父任务已经提交到调度	
        :type NeedCheckParentSubmitted: bool
        """
        self._TaskVersionDTOs = None
        self._ProjectId = None
        self._AutoRun = None
        self._AlarmWays = None
        self._AlarmRecipientTypes = None
        self._NeedCheckParentSubmitted = None

    @property
    def TaskVersionDTOs(self):
        return self._TaskVersionDTOs

    @TaskVersionDTOs.setter
    def TaskVersionDTOs(self, TaskVersionDTOs):
        self._TaskVersionDTOs = TaskVersionDTOs

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def AutoRun(self):
        return self._AutoRun

    @AutoRun.setter
    def AutoRun(self, AutoRun):
        self._AutoRun = AutoRun

    @property
    def AlarmWays(self):
        return self._AlarmWays

    @AlarmWays.setter
    def AlarmWays(self, AlarmWays):
        self._AlarmWays = AlarmWays

    @property
    def AlarmRecipientTypes(self):
        return self._AlarmRecipientTypes

    @AlarmRecipientTypes.setter
    def AlarmRecipientTypes(self, AlarmRecipientTypes):
        self._AlarmRecipientTypes = AlarmRecipientTypes

    @property
    def NeedCheckParentSubmitted(self):
        return self._NeedCheckParentSubmitted

    @NeedCheckParentSubmitted.setter
    def NeedCheckParentSubmitted(self, NeedCheckParentSubmitted):
        self._NeedCheckParentSubmitted = NeedCheckParentSubmitted


    def _deserialize(self, params):
        if params.get("TaskVersionDTOs") is not None:
            self._TaskVersionDTOs = []
            for item in params.get("TaskVersionDTOs"):
                obj = BatchCreateTaskVersionDsDTOLite()
                obj._deserialize(item)
                self._TaskVersionDTOs.append(obj)
        self._ProjectId = params.get("ProjectId")
        self._AutoRun = params.get("AutoRun")
        self._AlarmWays = params.get("AlarmWays")
        self._AlarmRecipientTypes = params.get("AlarmRecipientTypes")
        self._NeedCheckParentSubmitted = params.get("NeedCheckParentSubmitted")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchCreateTaskVersionDsResponse(AbstractModel):
    """BatchCreateTaskVersionDs返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 1
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.BatchOperateResultDs`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BatchOperateResultDs()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class BatchDeleteIntegrationTasksRequest(AbstractModel):
    """BatchDeleteIntegrationTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskIds: 任务id
        :type TaskIds: list of str
        :param _TaskType: 任务类型
        :type TaskType: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _DeleteKFFlag: 是否删除开发态任务。默认不删除开发态，为 0 不删除 , 为 1 删除
        :type DeleteKFFlag: int
        :param _Name: 操作名称
        :type Name: str
        :param _TaskNames: 本次批量操作涉及任务，用于审计
        :type TaskNames: list of str
        """
        self._TaskIds = None
        self._TaskType = None
        self._ProjectId = None
        self._DeleteKFFlag = None
        self._Name = None
        self._TaskNames = None

    @property
    def TaskIds(self):
        return self._TaskIds

    @TaskIds.setter
    def TaskIds(self, TaskIds):
        self._TaskIds = TaskIds

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def DeleteKFFlag(self):
        return self._DeleteKFFlag

    @DeleteKFFlag.setter
    def DeleteKFFlag(self, DeleteKFFlag):
        self._DeleteKFFlag = DeleteKFFlag

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def TaskNames(self):
        return self._TaskNames

    @TaskNames.setter
    def TaskNames(self, TaskNames):
        self._TaskNames = TaskNames


    def _deserialize(self, params):
        self._TaskIds = params.get("TaskIds")
        self._TaskType = params.get("TaskType")
        self._ProjectId = params.get("ProjectId")
        self._DeleteKFFlag = params.get("DeleteKFFlag")
        self._Name = params.get("Name")
        self._TaskNames = params.get("TaskNames")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchDeleteIntegrationTasksResponse(AbstractModel):
    """BatchDeleteIntegrationTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SuccessCount: 操作成功的任务数
注意：此字段可能返回 null，表示取不到有效值。
        :type SuccessCount: int
        :param _FailedCount: 操作失败的任务数
注意：此字段可能返回 null，表示取不到有效值。
        :type FailedCount: int
        :param _TotalCount: 任务总数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SuccessCount(self):
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class BatchDeleteOpsTasksRequest(AbstractModel):
    """BatchDeleteOpsTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskIdList: 批量删除的任务TaskId
        :type TaskIdList: list of str
        :param _DeleteMode: true : 删除后下游任务可正常运行
false：删除后下游任务不可运行
        :type DeleteMode: bool
        :param _EnableNotify: true：通知下游任务责任人
false:  不通知下游任务责任人
        :type EnableNotify: bool
        :param _ProjectId: 项目Id
        :type ProjectId: str
        """
        self._TaskIdList = None
        self._DeleteMode = None
        self._EnableNotify = None
        self._ProjectId = None

    @property
    def TaskIdList(self):
        return self._TaskIdList

    @TaskIdList.setter
    def TaskIdList(self, TaskIdList):
        self._TaskIdList = TaskIdList

    @property
    def DeleteMode(self):
        return self._DeleteMode

    @DeleteMode.setter
    def DeleteMode(self, DeleteMode):
        self._DeleteMode = DeleteMode

    @property
    def EnableNotify(self):
        return self._EnableNotify

    @EnableNotify.setter
    def EnableNotify(self, EnableNotify):
        self._EnableNotify = EnableNotify

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskIdList = params.get("TaskIdList")
        self._DeleteMode = params.get("DeleteMode")
        self._EnableNotify = params.get("EnableNotify")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchDeleteOpsTasksResponse(AbstractModel):
    """BatchDeleteOpsTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 返回批量操作成功个数、失败个数、操作总数
        :type Data: :class:`tencentcloud.wedata.v20210820.models.BatchOperationOpsDto`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BatchOperationOpsDto()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class BatchDeleteTasksDsRequest(AbstractModel):
    """BatchDeleteTasksDs请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskIdList: 批量删除的任务TaskId
        :type TaskIdList: list of str
        :param _DeleteMode: true : 删除后下游任务可正常运行
false：删除后下游任务不可运行
        :type DeleteMode: bool
        :param _OperateInform: true：通知下游任务责任人
false:  不通知下游任务责任人
        :type OperateInform: bool
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _DeleteScript: true: 删除任务引用的脚本
false: 不删除任务引用的脚本
        :type DeleteScript: bool
        """
        self._TaskIdList = None
        self._DeleteMode = None
        self._OperateInform = None
        self._ProjectId = None
        self._DeleteScript = None

    @property
    def TaskIdList(self):
        return self._TaskIdList

    @TaskIdList.setter
    def TaskIdList(self, TaskIdList):
        self._TaskIdList = TaskIdList

    @property
    def DeleteMode(self):
        return self._DeleteMode

    @DeleteMode.setter
    def DeleteMode(self, DeleteMode):
        self._DeleteMode = DeleteMode

    @property
    def OperateInform(self):
        return self._OperateInform

    @OperateInform.setter
    def OperateInform(self, OperateInform):
        self._OperateInform = OperateInform

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def DeleteScript(self):
        return self._DeleteScript

    @DeleteScript.setter
    def DeleteScript(self, DeleteScript):
        self._DeleteScript = DeleteScript


    def _deserialize(self, params):
        self._TaskIdList = params.get("TaskIdList")
        self._DeleteMode = params.get("DeleteMode")
        self._OperateInform = params.get("OperateInform")
        self._ProjectId = params.get("ProjectId")
        self._DeleteScript = params.get("DeleteScript")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchDeleteTasksDsResponse(AbstractModel):
    """BatchDeleteTasksDs返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 返回批量操作成功个数、失败个数、操作总数
        :type Data: :class:`tencentcloud.wedata.v20210820.models.BatchOperateResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BatchOperateResult()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class BatchDeleteTasksNewRequest(AbstractModel):
    """BatchDeleteTasksNew请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskIdList: 批量删除的任务TaskId
        :type TaskIdList: list of str
        :param _DeleteMode: true : 删除后下游任务可正常运行
false：删除后下游任务不可运行
        :type DeleteMode: bool
        :param _EnableNotify: true：通知下游任务责任人
false:  不通知下游任务责任人
        :type EnableNotify: bool
        :param _ProjectId: 项目Id
        :type ProjectId: str
        """
        self._TaskIdList = None
        self._DeleteMode = None
        self._EnableNotify = None
        self._ProjectId = None

    @property
    def TaskIdList(self):
        return self._TaskIdList

    @TaskIdList.setter
    def TaskIdList(self, TaskIdList):
        self._TaskIdList = TaskIdList

    @property
    def DeleteMode(self):
        return self._DeleteMode

    @DeleteMode.setter
    def DeleteMode(self, DeleteMode):
        self._DeleteMode = DeleteMode

    @property
    def EnableNotify(self):
        return self._EnableNotify

    @EnableNotify.setter
    def EnableNotify(self, EnableNotify):
        self._EnableNotify = EnableNotify

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskIdList = params.get("TaskIdList")
        self._DeleteMode = params.get("DeleteMode")
        self._EnableNotify = params.get("EnableNotify")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchDeleteTasksNewResponse(AbstractModel):
    """BatchDeleteTasksNew返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 返回批量操作成功个数、失败个数、操作总数
        :type Data: :class:`tencentcloud.wedata.v20210820.models.BatchOperateResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BatchOperateResult()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class BatchForceSuccessIntegrationTaskInstancesRequest(AbstractModel):
    """BatchForceSuccessIntegrationTaskInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Instances: 实例信息
        :type Instances: list of SchedulerTaskInstanceInfo
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._Instances = None
        self._ProjectId = None

    @property
    def Instances(self):
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = SchedulerTaskInstanceInfo()
                obj._deserialize(item)
                self._Instances.append(obj)
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchForceSuccessIntegrationTaskInstancesResponse(AbstractModel):
    """BatchForceSuccessIntegrationTaskInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SuccessCount: 操作成功的任务数
        :type SuccessCount: int
        :param _FailedCount: 操作失败的任务数
        :type FailedCount: int
        :param _TotalCount: 任务总数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SuccessCount(self):
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class BatchKillIntegrationTaskInstancesRequest(AbstractModel):
    """BatchKillIntegrationTaskInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Instances: 实例信息
        :type Instances: list of SchedulerTaskInstanceInfo
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._Instances = None
        self._ProjectId = None

    @property
    def Instances(self):
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = SchedulerTaskInstanceInfo()
                obj._deserialize(item)
                self._Instances.append(obj)
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchKillIntegrationTaskInstancesResponse(AbstractModel):
    """BatchKillIntegrationTaskInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SuccessCount: 操作成功的任务数
        :type SuccessCount: int
        :param _FailedCount: 操作失败的任务数
        :type FailedCount: int
        :param _TotalCount: 任务总数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SuccessCount(self):
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class BatchMakeUpIntegrationTasksRequest(AbstractModel):
    """BatchMakeUpIntegrationTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskIds: 任务id
        :type TaskIds: list of str
        :param _TaskType: 任务类型
        :type TaskType: int
        :param _StartTime: 补数据开始时间
        :type StartTime: str
        :param _EndTime: 补数据结束时间
        :type EndTime: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._TaskIds = None
        self._TaskType = None
        self._StartTime = None
        self._EndTime = None
        self._ProjectId = None

    @property
    def TaskIds(self):
        return self._TaskIds

    @TaskIds.setter
    def TaskIds(self, TaskIds):
        self._TaskIds = TaskIds

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskIds = params.get("TaskIds")
        self._TaskType = params.get("TaskType")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchMakeUpIntegrationTasksResponse(AbstractModel):
    """BatchMakeUpIntegrationTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SuccessCount: 操作成功的任务数
        :type SuccessCount: int
        :param _FailedCount: 操作失败的任务数
        :type FailedCount: int
        :param _TotalCount: 任务总数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SuccessCount(self):
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class BatchModifyOpsOwnersRequest(AbstractModel):
    """BatchModifyOpsOwners请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskIdList: 需要更新责任人的TaskId数组
        :type TaskIdList: list of str
        :param _Owners: 需要更新的责任人
        :type Owners: str
        :param _ProjectId: 项目Id
        :type ProjectId: str
        """
        self._TaskIdList = None
        self._Owners = None
        self._ProjectId = None

    @property
    def TaskIdList(self):
        return self._TaskIdList

    @TaskIdList.setter
    def TaskIdList(self, TaskIdList):
        self._TaskIdList = TaskIdList

    @property
    def Owners(self):
        return self._Owners

    @Owners.setter
    def Owners(self, Owners):
        self._Owners = Owners

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskIdList = params.get("TaskIdList")
        self._Owners = params.get("Owners")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchModifyOpsOwnersResponse(AbstractModel):
    """BatchModifyOpsOwners返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 返回批量操作成功个数、失败个数、操作总数
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.BatchOperationOpsDto`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BatchOperationOpsDto()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class BatchModifyOwnersNewRequest(AbstractModel):
    """BatchModifyOwnersNew请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskIdList: 需要更新责任人的TaskId数组
        :type TaskIdList: list of str
        :param _Owners: 需要更新的责任人
        :type Owners: str
        :param _ProjectId: 项目Id
        :type ProjectId: str
        """
        self._TaskIdList = None
        self._Owners = None
        self._ProjectId = None

    @property
    def TaskIdList(self):
        return self._TaskIdList

    @TaskIdList.setter
    def TaskIdList(self, TaskIdList):
        self._TaskIdList = TaskIdList

    @property
    def Owners(self):
        return self._Owners

    @Owners.setter
    def Owners(self, Owners):
        self._Owners = Owners

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskIdList = params.get("TaskIdList")
        self._Owners = params.get("Owners")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchModifyOwnersNewResponse(AbstractModel):
    """BatchModifyOwnersNew返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 返回批量操作成功个数、失败个数、操作总数
        :type Data: :class:`tencentcloud.wedata.v20210820.models.BatchOperateResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BatchOperateResult()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class BatchOperateResult(AbstractModel):
    """批量操作的结果返回

    """

    def __init__(self):
        r"""
        :param _SuccessCount: 批量操作成功数
        :type SuccessCount: int
        :param _FailedCount: 批量操作失败数
        :type FailedCount: int
        :param _TotalCount: 批量操作的总数
        :type TotalCount: int
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None

    @property
    def SuccessCount(self):
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchOperateResultDs(AbstractModel):
    """BatchOperateResultDs

    """

    def __init__(self):
        r"""
        :param _Result: result
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: bool
        :param _ErrorId: errorId
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrorId: str
        :param _ErrorDesc: errorDesc
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrorDesc: str
        """
        self._Result = None
        self._ErrorId = None
        self._ErrorDesc = None

    @property
    def Result(self):
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def ErrorId(self):
        return self._ErrorId

    @ErrorId.setter
    def ErrorId(self, ErrorId):
        self._ErrorId = ErrorId

    @property
    def ErrorDesc(self):
        return self._ErrorDesc

    @ErrorDesc.setter
    def ErrorDesc(self, ErrorDesc):
        self._ErrorDesc = ErrorDesc


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._ErrorId = params.get("ErrorId")
        self._ErrorDesc = params.get("ErrorDesc")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchOperateResultOpsDto(AbstractModel):
    """实例批量操作结果类

    """

    def __init__(self):
        r"""
        :param _Result: 结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: bool
        :param _ErrorId: 错误id
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrorId: str
        :param _ErrorDesc: 错误说明
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrorDesc: str
        """
        self._Result = None
        self._ErrorId = None
        self._ErrorDesc = None

    @property
    def Result(self):
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def ErrorId(self):
        return self._ErrorId

    @ErrorId.setter
    def ErrorId(self, ErrorId):
        self._ErrorId = ErrorId

    @property
    def ErrorDesc(self):
        return self._ErrorDesc

    @ErrorDesc.setter
    def ErrorDesc(self, ErrorDesc):
        self._ErrorDesc = ErrorDesc


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._ErrorId = params.get("ErrorId")
        self._ErrorDesc = params.get("ErrorDesc")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchOperationOpsDto(AbstractModel):
    """批量操作的结果返回

    """

    def __init__(self):
        r"""
        :param _SuccessCount: 批量操作成功数
注意：此字段可能返回 null，表示取不到有效值。
        :type SuccessCount: int
        :param _FailedCount: 批量操作失败数
注意：此字段可能返回 null，表示取不到有效值。
        :type FailedCount: int
        :param _TotalCount: 批量操作的总数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None

    @property
    def SuccessCount(self):
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchOpsDTO(AbstractModel):
    """批量操作结果，带失败原因

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总数量
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _SuccessCount: 成功数量
注意：此字段可能返回 null，表示取不到有效值。
        :type SuccessCount: int
        :param _FailCount: 失败数量
注意：此字段可能返回 null，表示取不到有效值。
        :type FailCount: int
        :param _FailMessageList: 失败原因
注意：此字段可能返回 null，表示取不到有效值。
        :type FailMessageList: list of FailMessage
        """
        self._TotalCount = None
        self._SuccessCount = None
        self._FailCount = None
        self._FailMessageList = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def SuccessCount(self):
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailCount(self):
        return self._FailCount

    @FailCount.setter
    def FailCount(self, FailCount):
        self._FailCount = FailCount

    @property
    def FailMessageList(self):
        return self._FailMessageList

    @FailMessageList.setter
    def FailMessageList(self, FailMessageList):
        self._FailMessageList = FailMessageList


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        self._SuccessCount = params.get("SuccessCount")
        self._FailCount = params.get("FailCount")
        if params.get("FailMessageList") is not None:
            self._FailMessageList = []
            for item in params.get("FailMessageList"):
                obj = FailMessage()
                obj._deserialize(item)
                self._FailMessageList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchRerunIntegrationTaskInstancesRequest(AbstractModel):
    """BatchRerunIntegrationTaskInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Instances: 实例信息
        :type Instances: list of SchedulerTaskInstanceInfo
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._Instances = None
        self._ProjectId = None

    @property
    def Instances(self):
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = SchedulerTaskInstanceInfo()
                obj._deserialize(item)
                self._Instances.append(obj)
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchRerunIntegrationTaskInstancesResponse(AbstractModel):
    """BatchRerunIntegrationTaskInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SuccessCount: 操作成功的任务数
        :type SuccessCount: int
        :param _FailedCount: 操作失败的任务数
        :type FailedCount: int
        :param _TotalCount: 任务总数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SuccessCount(self):
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class BatchResult(AbstractModel):
    """批量操作结果

    """

    def __init__(self):
        r"""
        :param _Running: 正在运行的任务数
        :type Running: int
        :param _Success: 执行成功的任务数
        :type Success: int
        :param _Failed: 执行失败的任务数
        :type Failed: int
        :param _Total: 总任务数
        :type Total: int
        """
        self._Running = None
        self._Success = None
        self._Failed = None
        self._Total = None

    @property
    def Running(self):
        return self._Running

    @Running.setter
    def Running(self, Running):
        self._Running = Running

    @property
    def Success(self):
        return self._Success

    @Success.setter
    def Success(self, Success):
        self._Success = Success

    @property
    def Failed(self):
        return self._Failed

    @Failed.setter
    def Failed(self, Failed):
        self._Failed = Failed

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total


    def _deserialize(self, params):
        self._Running = params.get("Running")
        self._Success = params.get("Success")
        self._Failed = params.get("Failed")
        self._Total = params.get("Total")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchResumeIntegrationTasksRequest(AbstractModel):
    """BatchResumeIntegrationTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskIds: 任务id
        :type TaskIds: list of str
        :param _TaskType: 任务类型, 201为实时任务，202为离线任务
        :type TaskType: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._TaskIds = None
        self._TaskType = None
        self._ProjectId = None

    @property
    def TaskIds(self):
        return self._TaskIds

    @TaskIds.setter
    def TaskIds(self, TaskIds):
        self._TaskIds = TaskIds

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskIds = params.get("TaskIds")
        self._TaskType = params.get("TaskType")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchResumeIntegrationTasksResponse(AbstractModel):
    """BatchResumeIntegrationTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SuccessCount: 操作成功的任务数
        :type SuccessCount: int
        :param _FailedCount: 操作失败的任务数
        :type FailedCount: int
        :param _TotalCount: 任务总数
        :type TotalCount: int
        :param _TaskNames: 本次批量操作涉及任务，用于审计
        :type TaskNames: list of str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None
        self._TaskNames = None
        self._RequestId = None

    @property
    def SuccessCount(self):
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TaskNames(self):
        return self._TaskNames

    @TaskNames.setter
    def TaskNames(self, TaskNames):
        self._TaskNames = TaskNames

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        self._TaskNames = params.get("TaskNames")
        self._RequestId = params.get("RequestId")


class BatchReturn(AbstractModel):
    """操作结果

    """

    def __init__(self):
        r"""
        :param _Result: 执行结果
        :type Result: bool
        :param _ErrorDesc: 执行情况备注
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrorDesc: str
        :param _ErrorId: 执行情况id
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrorId: str
        """
        self._Result = None
        self._ErrorDesc = None
        self._ErrorId = None

    @property
    def Result(self):
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def ErrorDesc(self):
        return self._ErrorDesc

    @ErrorDesc.setter
    def ErrorDesc(self, ErrorDesc):
        self._ErrorDesc = ErrorDesc

    @property
    def ErrorId(self):
        return self._ErrorId

    @ErrorId.setter
    def ErrorId(self, ErrorId):
        self._ErrorId = ErrorId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._ErrorDesc = params.get("ErrorDesc")
        self._ErrorId = params.get("ErrorId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchRunOpsTaskRequest(AbstractModel):
    """BatchRunOpsTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _EnableMakeUp: 是否补录中间实例,0不补录;1补录
        :type EnableMakeUp: int
        :param _Tasks: 任务id列表
        :type Tasks: list of str
        """
        self._ProjectId = None
        self._EnableMakeUp = None
        self._Tasks = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def EnableMakeUp(self):
        return self._EnableMakeUp

    @EnableMakeUp.setter
    def EnableMakeUp(self, EnableMakeUp):
        self._EnableMakeUp = EnableMakeUp

    @property
    def Tasks(self):
        return self._Tasks

    @Tasks.setter
    def Tasks(self, Tasks):
        self._Tasks = Tasks


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._EnableMakeUp = params.get("EnableMakeUp")
        self._Tasks = params.get("Tasks")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchRunOpsTaskResponse(AbstractModel):
    """BatchRunOpsTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 操作结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class BatchStartIntegrationTasksRequest(AbstractModel):
    """BatchStartIntegrationTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskType: 任务类型
        :type TaskType: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _TaskIds: 任务id
        :type TaskIds: list of str
        :param _StartTaskInfoSet: 批量运行集成任务，目前仅实时集成用到了这个参数
        :type StartTaskInfoSet: list of StartTaskInfo
        """
        self._TaskType = None
        self._ProjectId = None
        self._TaskIds = None
        self._StartTaskInfoSet = None

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskIds(self):
        return self._TaskIds

    @TaskIds.setter
    def TaskIds(self, TaskIds):
        self._TaskIds = TaskIds

    @property
    def StartTaskInfoSet(self):
        return self._StartTaskInfoSet

    @StartTaskInfoSet.setter
    def StartTaskInfoSet(self, StartTaskInfoSet):
        self._StartTaskInfoSet = StartTaskInfoSet


    def _deserialize(self, params):
        self._TaskType = params.get("TaskType")
        self._ProjectId = params.get("ProjectId")
        self._TaskIds = params.get("TaskIds")
        if params.get("StartTaskInfoSet") is not None:
            self._StartTaskInfoSet = []
            for item in params.get("StartTaskInfoSet"):
                obj = StartTaskInfo()
                obj._deserialize(item)
                self._StartTaskInfoSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchStartIntegrationTasksResponse(AbstractModel):
    """BatchStartIntegrationTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SuccessCount: 操作成功的任务数
        :type SuccessCount: int
        :param _FailedCount: 操作失败的任务数
        :type FailedCount: int
        :param _TotalCount: 任务总数
        :type TotalCount: int
        :param _TaskNames: 本次批量操作成功任务id，用于审计
        :type TaskNames: list of str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None
        self._TaskNames = None
        self._RequestId = None

    @property
    def SuccessCount(self):
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TaskNames(self):
        return self._TaskNames

    @TaskNames.setter
    def TaskNames(self, TaskNames):
        self._TaskNames = TaskNames

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        self._TaskNames = params.get("TaskNames")
        self._RequestId = params.get("RequestId")


class BatchStopIntegrationTasksRequest(AbstractModel):
    """BatchStopIntegrationTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskIds: 任务id
        :type TaskIds: list of str
        :param _TaskType: 任务类型
        :type TaskType: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._TaskIds = None
        self._TaskType = None
        self._ProjectId = None

    @property
    def TaskIds(self):
        return self._TaskIds

    @TaskIds.setter
    def TaskIds(self, TaskIds):
        self._TaskIds = TaskIds

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskIds = params.get("TaskIds")
        self._TaskType = params.get("TaskType")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchStopIntegrationTasksResponse(AbstractModel):
    """BatchStopIntegrationTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SuccessCount: 操作成功的任务数
        :type SuccessCount: int
        :param _FailedCount: 操作失败的任务数
        :type FailedCount: int
        :param _TotalCount: 任务总数
        :type TotalCount: int
        :param _TaskNames: 本次批量操作涉及成功任务，用于审计
        :type TaskNames: list of str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None
        self._TaskNames = None
        self._RequestId = None

    @property
    def SuccessCount(self):
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TaskNames(self):
        return self._TaskNames

    @TaskNames.setter
    def TaskNames(self, TaskNames):
        self._TaskNames = TaskNames

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        self._TaskNames = params.get("TaskNames")
        self._RequestId = params.get("RequestId")


class BatchStopOpsTasksRequest(AbstractModel):
    """BatchStopOpsTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskIdList: 批量停止任务的TaskId
        :type TaskIdList: list of str
        :param _ProjectId: 项目Id
        :type ProjectId: str
        """
        self._TaskIdList = None
        self._ProjectId = None

    @property
    def TaskIdList(self):
        return self._TaskIdList

    @TaskIdList.setter
    def TaskIdList(self, TaskIdList):
        self._TaskIdList = TaskIdList

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskIdList = params.get("TaskIdList")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchStopOpsTasksResponse(AbstractModel):
    """BatchStopOpsTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 返回批量操作成功个数、失败个数、操作总数
        :type Data: :class:`tencentcloud.wedata.v20210820.models.BatchOperationOpsDto`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BatchOperationOpsDto()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class BatchStopTasksNewRequest(AbstractModel):
    """BatchStopTasksNew请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskIdList: 批量停止任务的TaskId
        :type TaskIdList: list of str
        :param _ProjectId: 项目Id
        :type ProjectId: str
        """
        self._TaskIdList = None
        self._ProjectId = None

    @property
    def TaskIdList(self):
        return self._TaskIdList

    @TaskIdList.setter
    def TaskIdList(self, TaskIdList):
        self._TaskIdList = TaskIdList

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskIdList = params.get("TaskIdList")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchStopTasksNewResponse(AbstractModel):
    """BatchStopTasksNew返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 返回批量操作成功个数、失败个数、操作总数
        :type Data: :class:`tencentcloud.wedata.v20210820.models.BatchOperateResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BatchOperateResult()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class BatchStopWorkflowsByIdsRequest(AbstractModel):
    """BatchStopWorkflowsByIds请求参数结构体

    """

    def __init__(self):
        r"""
        :param _WorkflowIds: 工作流id列表
        :type WorkflowIds: list of str
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._WorkflowIds = None
        self._ProjectId = None

    @property
    def WorkflowIds(self):
        return self._WorkflowIds

    @WorkflowIds.setter
    def WorkflowIds(self, WorkflowIds):
        self._WorkflowIds = WorkflowIds

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._WorkflowIds = params.get("WorkflowIds")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchStopWorkflowsByIdsResponse(AbstractModel):
    """BatchStopWorkflowsByIds返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 操作返回结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.OperationOpsDto`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = OperationOpsDto()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class BatchSuspendIntegrationTasksRequest(AbstractModel):
    """BatchSuspendIntegrationTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskIds: 任务id
        :type TaskIds: list of str
        :param _TaskType: 任务类型
        :type TaskType: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _Event: 事件类型(START, STOP, SUSPEND, SUSPEND_WITHOUT_SP,RESUME, COMMIT, TIMESTAMP)	
        :type Event: str
        :param _TaskNames: 本次批量操作涉及任务，用于审计
        :type TaskNames: list of str
        """
        self._TaskIds = None
        self._TaskType = None
        self._ProjectId = None
        self._Event = None
        self._TaskNames = None

    @property
    def TaskIds(self):
        return self._TaskIds

    @TaskIds.setter
    def TaskIds(self, TaskIds):
        self._TaskIds = TaskIds

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Event(self):
        return self._Event

    @Event.setter
    def Event(self, Event):
        self._Event = Event

    @property
    def TaskNames(self):
        return self._TaskNames

    @TaskNames.setter
    def TaskNames(self, TaskNames):
        self._TaskNames = TaskNames


    def _deserialize(self, params):
        self._TaskIds = params.get("TaskIds")
        self._TaskType = params.get("TaskType")
        self._ProjectId = params.get("ProjectId")
        self._Event = params.get("Event")
        self._TaskNames = params.get("TaskNames")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchSuspendIntegrationTasksResponse(AbstractModel):
    """BatchSuspendIntegrationTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SuccessCount: 操作成功的任务数
        :type SuccessCount: int
        :param _FailedCount: 操作失败的任务数
        :type FailedCount: int
        :param _TotalCount: 任务总数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SuccessCount(self):
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class BatchUpdateIntegrationTasksRequest(AbstractModel):
    """BatchUpdateIntegrationTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskIds: 任务id
        :type TaskIds: list of str
        :param _Incharge: 责任人（多个责任人用小写分号隔开；离线任务传入的是账号名，实时任务传入的是账号id）
        :type Incharge: str
        :param _TaskType: 任务类型
        :type TaskType: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _InchargeIds: 责任人Id（多个责任人用小写分号隔开）
        :type InchargeIds: str
        :param _TaskNames: 本次批量操作涉及任务，用于审计
        :type TaskNames: list of str
        """
        self._TaskIds = None
        self._Incharge = None
        self._TaskType = None
        self._ProjectId = None
        self._InchargeIds = None
        self._TaskNames = None

    @property
    def TaskIds(self):
        return self._TaskIds

    @TaskIds.setter
    def TaskIds(self, TaskIds):
        self._TaskIds = TaskIds

    @property
    def Incharge(self):
        return self._Incharge

    @Incharge.setter
    def Incharge(self, Incharge):
        self._Incharge = Incharge

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def InchargeIds(self):
        return self._InchargeIds

    @InchargeIds.setter
    def InchargeIds(self, InchargeIds):
        self._InchargeIds = InchargeIds

    @property
    def TaskNames(self):
        return self._TaskNames

    @TaskNames.setter
    def TaskNames(self, TaskNames):
        self._TaskNames = TaskNames


    def _deserialize(self, params):
        self._TaskIds = params.get("TaskIds")
        self._Incharge = params.get("Incharge")
        self._TaskType = params.get("TaskType")
        self._ProjectId = params.get("ProjectId")
        self._InchargeIds = params.get("InchargeIds")
        self._TaskNames = params.get("TaskNames")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchUpdateIntegrationTasksResponse(AbstractModel):
    """BatchUpdateIntegrationTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SuccessCount: 操作成功的任务数
        :type SuccessCount: int
        :param _FailedCount: 操作失败的任务数
        :type FailedCount: int
        :param _TotalCount: 任务总数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SuccessCount = None
        self._FailedCount = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SuccessCount(self):
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class BooleanResponse(AbstractModel):
    """BooleanResponse

    """

    def __init__(self):
        r"""
        :param _Success: 是否成功
        :type Success: bool
        :param _Message: 失败返回提示信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Message: str
        :param _BaselineId: 基线Id
注意：此字段可能返回 null，表示取不到有效值。
        :type BaselineId: int
        :param _Code: 错误码
注意：此字段可能返回 null，表示取不到有效值。
        :type Code: str
        """
        self._Success = None
        self._Message = None
        self._BaselineId = None
        self._Code = None

    @property
    def Success(self):
        return self._Success

    @Success.setter
    def Success(self, Success):
        self._Success = Success

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def BaselineId(self):
        return self._BaselineId

    @BaselineId.setter
    def BaselineId(self, BaselineId):
        self._BaselineId = BaselineId

    @property
    def Code(self):
        return self._Code

    @Code.setter
    def Code(self, Code):
        self._Code = Code


    def _deserialize(self, params):
        self._Success = params.get("Success")
        self._Message = params.get("Message")
        self._BaselineId = params.get("BaselineId")
        self._Code = params.get("Code")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BytesSpeed(AbstractModel):
    """实时任务同步速度 字节/s

    """

    def __init__(self):
        r"""
        :param _NodeType: 节点类型
注意：此字段可能返回 null，表示取不到有效值。
        :type NodeType: str
        :param _NodeName: 节点名称
注意：此字段可能返回 null，表示取不到有效值。
        :type NodeName: str
        :param _Values: 速度值列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Values: list of SpeedValue
        """
        self._NodeType = None
        self._NodeName = None
        self._Values = None

    @property
    def NodeType(self):
        return self._NodeType

    @NodeType.setter
    def NodeType(self, NodeType):
        self._NodeType = NodeType

    @property
    def NodeName(self):
        return self._NodeName

    @NodeName.setter
    def NodeName(self, NodeName):
        self._NodeName = NodeName

    @property
    def Values(self):
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values


    def _deserialize(self, params):
        self._NodeType = params.get("NodeType")
        self._NodeName = params.get("NodeName")
        if params.get("Values") is not None:
            self._Values = []
            for item in params.get("Values"):
                obj = SpeedValue()
                obj._deserialize(item)
                self._Values.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CandidateDsDTo(AbstractModel):
    """CandidateDsDTo

    """

    def __init__(self):
        r"""
        :param _Value: 取值
注意：此字段可能返回 null，表示取不到有效值。
        :type Value: str
        :param _ValueDesc: 取值描述
注意：此字段可能返回 null，表示取不到有效值。
        :type ValueDesc: str
        """
        self._Value = None
        self._ValueDesc = None

    @property
    def Value(self):
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value

    @property
    def ValueDesc(self):
        return self._ValueDesc

    @ValueDesc.setter
    def ValueDesc(self, ValueDesc):
        self._ValueDesc = ValueDesc


    def _deserialize(self, params):
        self._Value = params.get("Value")
        self._ValueDesc = params.get("ValueDesc")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CanvasInfo(AbstractModel):
    """画布所需的信息

    """

    def __init__(self):
        r"""
        :param _TasksList: 画布任务信息
        :type TasksList: list of TaskCanvasInfo
        :param _LinksList: 画布任务链接信息
        :type LinksList: list of TaskLinkInfo
        """
        self._TasksList = None
        self._LinksList = None

    @property
    def TasksList(self):
        return self._TasksList

    @TasksList.setter
    def TasksList(self, TasksList):
        self._TasksList = TasksList

    @property
    def LinksList(self):
        return self._LinksList

    @LinksList.setter
    def LinksList(self, LinksList):
        self._LinksList = LinksList


    def _deserialize(self, params):
        if params.get("TasksList") is not None:
            self._TasksList = []
            for item in params.get("TasksList"):
                obj = TaskCanvasInfo()
                obj._deserialize(item)
                self._TasksList.append(obj)
        if params.get("LinksList") is not None:
            self._LinksList = []
            for item in params.get("LinksList"):
                obj = TaskLinkInfo()
                obj._deserialize(item)
                self._LinksList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckAlarmRegularNameExistRequest(AbstractModel):
    """CheckAlarmRegularNameExist请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目名称
        :type ProjectId: str
        :param _AlarmRegularName: 规则名称
        :type AlarmRegularName: str
        :param _TaskId: 任务ID
        :type TaskId: str
        :param _Id: 主键ID
        :type Id: str
        :param _TaskType: 任务类型:201.实时,202.离线
        :type TaskType: int
        :param _MonitorType: 监控对象类型(1:所有任务,2:指定任务,3:指定责任人,4:指定资源组)
        :type MonitorType: int
        """
        self._ProjectId = None
        self._AlarmRegularName = None
        self._TaskId = None
        self._Id = None
        self._TaskType = None
        self._MonitorType = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def AlarmRegularName(self):
        return self._AlarmRegularName

    @AlarmRegularName.setter
    def AlarmRegularName(self, AlarmRegularName):
        self._AlarmRegularName = AlarmRegularName

    @property
    def TaskId(self):
        warnings.warn("parameter `TaskId` is deprecated", DeprecationWarning) 

        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        warnings.warn("parameter `TaskId` is deprecated", DeprecationWarning) 

        self._TaskId = TaskId

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def MonitorType(self):
        return self._MonitorType

    @MonitorType.setter
    def MonitorType(self, MonitorType):
        self._MonitorType = MonitorType


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._AlarmRegularName = params.get("AlarmRegularName")
        self._TaskId = params.get("TaskId")
        self._Id = params.get("Id")
        self._TaskType = params.get("TaskType")
        self._MonitorType = params.get("MonitorType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckAlarmRegularNameExistResponse(AbstractModel):
    """CheckAlarmRegularNameExist返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 是否重名
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CheckDuplicateRuleNameRequest(AbstractModel):
    """CheckDuplicateRuleName请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _RuleGroupId: 规则组Id
        :type RuleGroupId: int
        :param _Name: 规则名称
        :type Name: str
        :param _RuleId: 规则Id
        :type RuleId: int
        """
        self._ProjectId = None
        self._RuleGroupId = None
        self._Name = None
        self._RuleId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def RuleGroupId(self):
        return self._RuleGroupId

    @RuleGroupId.setter
    def RuleGroupId(self, RuleGroupId):
        self._RuleGroupId = RuleGroupId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._RuleGroupId = params.get("RuleGroupId")
        self._Name = params.get("Name")
        self._RuleId = params.get("RuleId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckDuplicateRuleNameResponse(AbstractModel):
    """CheckDuplicateRuleName返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则名称是否重复
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CheckDuplicateTemplateNameRequest(AbstractModel):
    """CheckDuplicateTemplateName请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TemplateId: 规则模板ID
        :type TemplateId: int
        :param _Name: 模板名称
        :type Name: str
        :param _ProjectId: 项目Id
        :type ProjectId: str
        """
        self._TemplateId = None
        self._Name = None
        self._ProjectId = None

    @property
    def TemplateId(self):
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        self._Name = params.get("Name")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckDuplicateTemplateNameResponse(AbstractModel):
    """CheckDuplicateTemplateName返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 是否重名
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CheckIntegrationNodeNameExistsRequest(AbstractModel):
    """CheckIntegrationNodeNameExists请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务ID
        :type TaskId: str
        :param _Name: 节点名称
        :type Name: str
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _Id: 节点ID
        :type Id: int
        """
        self._TaskId = None
        self._Name = None
        self._ProjectId = None
        self._Id = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Name = params.get("Name")
        self._ProjectId = params.get("ProjectId")
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckIntegrationNodeNameExistsResponse(AbstractModel):
    """CheckIntegrationNodeNameExists返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 返回true代表存在，返回false代表不存在
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CheckIntegrationTaskNameExistsRequest(AbstractModel):
    """CheckIntegrationTaskNameExists请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskName: 任务名称
        :type TaskName: str
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _TaskId: 任务ID
        :type TaskId: str
        :param _SyncType: 同步类型1.单表同步，2.解决方案
        :type SyncType: int
        """
        self._TaskName = None
        self._ProjectId = None
        self._TaskId = None
        self._SyncType = None

    @property
    def TaskName(self):
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def SyncType(self):
        return self._SyncType

    @SyncType.setter
    def SyncType(self, SyncType):
        self._SyncType = SyncType


    def _deserialize(self, params):
        self._TaskName = params.get("TaskName")
        self._ProjectId = params.get("ProjectId")
        self._TaskId = params.get("TaskId")
        self._SyncType = params.get("SyncType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckIntegrationTaskNameExistsResponse(AbstractModel):
    """CheckIntegrationTaskNameExists返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: true表示存在，false表示不存在
        :type Data: bool
        :param _ExistsType: 任务名重复类型（0:未重复, 1:开发态重复, 2:生产态重复）
        :type ExistsType: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._ExistsType = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def ExistsType(self):
        return self._ExistsType

    @ExistsType.setter
    def ExistsType(self, ExistsType):
        self._ExistsType = ExistsType

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._ExistsType = params.get("ExistsType")
        self._RequestId = params.get("RequestId")


class CheckTaskNameExistRequest(AbstractModel):
    """CheckTaskNameExist请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id/工作空间id
        :type ProjectId: str
        :param _TypeId: 任务类型（跟调度传参保持一致27）
        :type TypeId: int
        :param _TaskName: 任务名
        :type TaskName: str
        """
        self._ProjectId = None
        self._TypeId = None
        self._TaskName = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TypeId(self):
        return self._TypeId

    @TypeId.setter
    def TypeId(self, TypeId):
        self._TypeId = TypeId

    @property
    def TaskName(self):
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TypeId = params.get("TypeId")
        self._TaskName = params.get("TaskName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckTaskNameExistResponse(AbstractModel):
    """CheckTaskNameExist返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 结果
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CollectionFolderOpsDto(AbstractModel):
    """文件夹列表

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _TotalPage: 总页面数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalPage: int
        :param _PageCount: 当前页面数量
注意：此字段可能返回 null，表示取不到有效值。
        :type PageCount: int
        :param _PageNumber: 页码
注意：此字段可能返回 null，表示取不到有效值。
        :type PageNumber: int
        :param _PageSize: 每页数量
注意：此字段可能返回 null，表示取不到有效值。
        :type PageSize: int
        :param _Items: 任务信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Items: list of FolderOpsDto
        """
        self._TotalCount = None
        self._TotalPage = None
        self._PageCount = None
        self._PageNumber = None
        self._PageSize = None
        self._Items = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TotalPage(self):
        return self._TotalPage

    @TotalPage.setter
    def TotalPage(self, TotalPage):
        self._TotalPage = TotalPage

    @property
    def PageCount(self):
        return self._PageCount

    @PageCount.setter
    def PageCount(self, PageCount):
        self._PageCount = PageCount

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        self._TotalPage = params.get("TotalPage")
        self._PageCount = params.get("PageCount")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = FolderOpsDto()
                obj._deserialize(item)
                self._Items.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CollectionInstanceOpsDto(AbstractModel):
    """实例列表结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _TotalPage: 总页面数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalPage: int
        :param _PageCount: 当前页面数量
注意：此字段可能返回 null，表示取不到有效值。
        :type PageCount: int
        :param _PageNumber: 页码
注意：此字段可能返回 null，表示取不到有效值。
        :type PageNumber: int
        :param _PageSize: 每页数量
注意：此字段可能返回 null，表示取不到有效值。
        :type PageSize: int
        :param _Items: 实例信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Items: list of InstanceOpsDto
        """
        self._TotalCount = None
        self._TotalPage = None
        self._PageCount = None
        self._PageNumber = None
        self._PageSize = None
        self._Items = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TotalPage(self):
        return self._TotalPage

    @TotalPage.setter
    def TotalPage(self, TotalPage):
        self._TotalPage = TotalPage

    @property
    def PageCount(self):
        return self._PageCount

    @PageCount.setter
    def PageCount(self, PageCount):
        self._PageCount = PageCount

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        self._TotalPage = params.get("TotalPage")
        self._PageCount = params.get("PageCount")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = InstanceOpsDto()
                obj._deserialize(item)
                self._Items.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CollectionTaskOpsDto(AbstractModel):
    """任务实例集合

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _TotalPage: 总页面数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalPage: int
        :param _PageCount: 当前页面数量
注意：此字段可能返回 null，表示取不到有效值。
        :type PageCount: int
        :param _PageNumber: 页码
注意：此字段可能返回 null，表示取不到有效值。
        :type PageNumber: int
        :param _PageSize: 每页数量
注意：此字段可能返回 null，表示取不到有效值。
        :type PageSize: int
        :param _Items: 任务信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Items: list of TaskOpsDto
        """
        self._TotalCount = None
        self._TotalPage = None
        self._PageCount = None
        self._PageNumber = None
        self._PageSize = None
        self._Items = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TotalPage(self):
        return self._TotalPage

    @TotalPage.setter
    def TotalPage(self, TotalPage):
        self._TotalPage = TotalPage

    @property
    def PageCount(self):
        return self._PageCount

    @PageCount.setter
    def PageCount(self, PageCount):
        self._PageCount = PageCount

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        self._TotalPage = params.get("TotalPage")
        self._PageCount = params.get("PageCount")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = TaskOpsDto()
                obj._deserialize(item)
                self._Items.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ColumnAggregationLineage(AbstractModel):
    """列血缘聚合信息

    """

    def __init__(self):
        r"""
        :param _TableName: 表名
注意：此字段可能返回 null，表示取不到有效值。
        :type TableName: str
        :param _ParentId: 父节点ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ParentId: str
        :param _MetastoreType: 元数据类型
注意：此字段可能返回 null，表示取不到有效值。
        :type MetastoreType: str
        :param _ParentSet: 字符串类型的父节点集合
注意：此字段可能返回 null，表示取不到有效值。
        :type ParentSet: str
        :param _ChildSet: 字符串类型的子节点集合
注意：此字段可能返回 null，表示取不到有效值。
        :type ChildSet: str
        :param _ColumnInfoSet: 列信息集合
注意：此字段可能返回 null，表示取不到有效值。
        :type ColumnInfoSet: list of SimpleColumnInfo
        """
        self._TableName = None
        self._ParentId = None
        self._MetastoreType = None
        self._ParentSet = None
        self._ChildSet = None
        self._ColumnInfoSet = None

    @property
    def TableName(self):
        return self._TableName

    @TableName.setter
    def TableName(self, TableName):
        self._TableName = TableName

    @property
    def ParentId(self):
        return self._ParentId

    @ParentId.setter
    def ParentId(self, ParentId):
        self._ParentId = ParentId

    @property
    def MetastoreType(self):
        return self._MetastoreType

    @MetastoreType.setter
    def MetastoreType(self, MetastoreType):
        self._MetastoreType = MetastoreType

    @property
    def ParentSet(self):
        return self._ParentSet

    @ParentSet.setter
    def ParentSet(self, ParentSet):
        self._ParentSet = ParentSet

    @property
    def ChildSet(self):
        return self._ChildSet

    @ChildSet.setter
    def ChildSet(self, ChildSet):
        self._ChildSet = ChildSet

    @property
    def ColumnInfoSet(self):
        return self._ColumnInfoSet

    @ColumnInfoSet.setter
    def ColumnInfoSet(self, ColumnInfoSet):
        self._ColumnInfoSet = ColumnInfoSet


    def _deserialize(self, params):
        self._TableName = params.get("TableName")
        self._ParentId = params.get("ParentId")
        self._MetastoreType = params.get("MetastoreType")
        self._ParentSet = params.get("ParentSet")
        self._ChildSet = params.get("ChildSet")
        if params.get("ColumnInfoSet") is not None:
            self._ColumnInfoSet = []
            for item in params.get("ColumnInfoSet"):
                obj = SimpleColumnInfo()
                obj._deserialize(item)
                self._ColumnInfoSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ColumnBasicInfo(AbstractModel):
    """表的元数据信息

    """

    def __init__(self):
        r"""
        :param _TableId: 表的全局唯一ID
注意：此字段可能返回 null，表示取不到有效值。
        :type TableId: str
        :param _DatasourceId: 数据源全局唯一ID
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasourceId: str
        :param _DatasourceName: 数据源名
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasourceName: str
        :param _DatabaseId: 数据库ID
注意：此字段可能返回 null，表示取不到有效值。
        :type DatabaseId: str
        :param _DatabaseName: 数据库名
注意：此字段可能返回 null，表示取不到有效值。
        :type DatabaseName: str
        :param _TableName: 表名称
注意：此字段可能返回 null，表示取不到有效值。
        :type TableName: str
        :param _ColumnName: 字段名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ColumnName: str
        :param _DataType: 数据类型,string/int等
注意：此字段可能返回 null，表示取不到有效值。
        :type DataType: str
        :param _ColumnType: 字段类型, varchar(32)/int(10)等
注意：此字段可能返回 null，表示取不到有效值。
        :type ColumnType: str
        :param _ColumnDefault: 字段默认值
注意：此字段可能返回 null，表示取不到有效值。
        :type ColumnDefault: str
        :param _ColumnKey: 索引类型, PRI/MUL/PARTITION等,普通字段该值为空串
注意：此字段可能返回 null，表示取不到有效值。
        :type ColumnKey: str
        :param _ColumnPosition: 字段顺序标识
注意：此字段可能返回 null，表示取不到有效值。
        :type ColumnPosition: int
        :param _ColumnComment: 字段注释
注意：此字段可能返回 null，表示取不到有效值。
        :type ColumnComment: str
        :param _StoreType: 数据类型
注意：此字段可能返回 null，表示取不到有效值。
        :type StoreType: str
        :param _ProjectId: 所属项目ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ProjectId: str
        :param _ProjectName: 所属项目英文名
注意：此字段可能返回 null，表示取不到有效值。
        :type ProjectName: str
        :param _ProjectDisplayName: 所属项目中文名
注意：此字段可能返回 null，表示取不到有效值。
        :type ProjectDisplayName: str
        :param _CreateTime: 创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateTime: str
        :param _UpdateTime: 更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: str
        :param _Scale: 精度
注意：此字段可能返回 null，表示取不到有效值。
        :type Scale: int
        """
        self._TableId = None
        self._DatasourceId = None
        self._DatasourceName = None
        self._DatabaseId = None
        self._DatabaseName = None
        self._TableName = None
        self._ColumnName = None
        self._DataType = None
        self._ColumnType = None
        self._ColumnDefault = None
        self._ColumnKey = None
        self._ColumnPosition = None
        self._ColumnComment = None
        self._StoreType = None
        self._ProjectId = None
        self._ProjectName = None
        self._ProjectDisplayName = None
        self._CreateTime = None
        self._UpdateTime = None
        self._Scale = None

    @property
    def TableId(self):
        return self._TableId

    @TableId.setter
    def TableId(self, TableId):
        self._TableId = TableId

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def DatasourceName(self):
        return self._DatasourceName

    @DatasourceName.setter
    def DatasourceName(self, DatasourceName):
        self._DatasourceName = DatasourceName

    @property
    def DatabaseId(self):
        return self._DatabaseId

    @DatabaseId.setter
    def DatabaseId(self, DatabaseId):
        self._DatabaseId = DatabaseId

    @property
    def DatabaseName(self):
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def TableName(self):
        return self._TableName

    @TableName.setter
    def TableName(self, TableName):
        self._TableName = TableName

    @property
    def ColumnName(self):
        return self._ColumnName

    @ColumnName.setter
    def ColumnName(self, ColumnName):
        self._ColumnName = ColumnName

    @property
    def DataType(self):
        return self._DataType

    @DataType.setter
    def DataType(self, DataType):
        self._DataType = DataType

    @property
    def ColumnType(self):
        return self._ColumnType

    @ColumnType.setter
    def ColumnType(self, ColumnType):
        self._ColumnType = ColumnType

    @property
    def ColumnDefault(self):
        return self._ColumnDefault

    @ColumnDefault.setter
    def ColumnDefault(self, ColumnDefault):
        self._ColumnDefault = ColumnDefault

    @property
    def ColumnKey(self):
        return self._ColumnKey

    @ColumnKey.setter
    def ColumnKey(self, ColumnKey):
        self._ColumnKey = ColumnKey

    @property
    def ColumnPosition(self):
        return self._ColumnPosition

    @ColumnPosition.setter
    def ColumnPosition(self, ColumnPosition):
        self._ColumnPosition = ColumnPosition

    @property
    def ColumnComment(self):
        return self._ColumnComment

    @ColumnComment.setter
    def ColumnComment(self, ColumnComment):
        self._ColumnComment = ColumnComment

    @property
    def StoreType(self):
        return self._StoreType

    @StoreType.setter
    def StoreType(self, StoreType):
        self._StoreType = StoreType

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ProjectName(self):
        return self._ProjectName

    @ProjectName.setter
    def ProjectName(self, ProjectName):
        self._ProjectName = ProjectName

    @property
    def ProjectDisplayName(self):
        return self._ProjectDisplayName

    @ProjectDisplayName.setter
    def ProjectDisplayName(self, ProjectDisplayName):
        self._ProjectDisplayName = ProjectDisplayName

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def Scale(self):
        return self._Scale

    @Scale.setter
    def Scale(self, Scale):
        self._Scale = Scale


    def _deserialize(self, params):
        self._TableId = params.get("TableId")
        self._DatasourceId = params.get("DatasourceId")
        self._DatasourceName = params.get("DatasourceName")
        self._DatabaseId = params.get("DatabaseId")
        self._DatabaseName = params.get("DatabaseName")
        self._TableName = params.get("TableName")
        self._ColumnName = params.get("ColumnName")
        self._DataType = params.get("DataType")
        self._ColumnType = params.get("ColumnType")
        self._ColumnDefault = params.get("ColumnDefault")
        self._ColumnKey = params.get("ColumnKey")
        self._ColumnPosition = params.get("ColumnPosition")
        self._ColumnComment = params.get("ColumnComment")
        self._StoreType = params.get("StoreType")
        self._ProjectId = params.get("ProjectId")
        self._ProjectName = params.get("ProjectName")
        self._ProjectDisplayName = params.get("ProjectDisplayName")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._Scale = params.get("Scale")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ColumnLineageInfo(AbstractModel):
    """血缘字段信息

    """

    def __init__(self):
        r"""
        :param _Id: 血缘id
注意：此字段可能返回 null，表示取不到有效值。
        :type Id: str
        :param _DatasourceId: 数据源ID
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasourceId: str
        :param _ColumnName: 字段名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ColumnName: str
        :param _ColumnNameCn: 字段中文名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ColumnNameCn: str
        :param _ColumnType: 字段类型
注意：此字段可能返回 null，表示取不到有效值。
        :type ColumnType: str
        :param _RelationParams: 关系参数
注意：此字段可能返回 null，表示取不到有效值。
        :type RelationParams: str
        :param _Params: 参数
注意：此字段可能返回 null，表示取不到有效值。
        :type Params: str
        :param _ParentId: 父id
注意：此字段可能返回 null，表示取不到有效值。
        :type ParentId: str
        :param _MetastoreType: 元数据类型
注意：此字段可能返回 null，表示取不到有效值。
        :type MetastoreType: str
        :param _MetastoreTypeName: 元数据类型名称
注意：此字段可能返回 null，表示取不到有效值。
        :type MetastoreTypeName: str
        :param _TableName: 表名称
注意：此字段可能返回 null，表示取不到有效值。
        :type TableName: str
        :param _QualifiedName: 字段全名称
注意：此字段可能返回 null，表示取不到有效值。
        :type QualifiedName: str
        :param _DownStreamCount: 下游节点数
注意：此字段可能返回 null，表示取不到有效值。
        :type DownStreamCount: int
        :param _UpStreamCount: 上游节点数
注意：此字段可能返回 null，表示取不到有效值。
        :type UpStreamCount: int
        :param _Description: 描述信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        :param _PrefixPath: 由中心节点出发的路径信息
注意：此字段可能返回 null，表示取不到有效值。
        :type PrefixPath: str
        :param _CreateTime: 创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateTime: str
        :param _ModifyTime: 更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type ModifyTime: str
        :param _Tasks: 任务id列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Tasks: list of str
        :param _ParentSet: 父节点列表字符串
注意：此字段可能返回 null，表示取不到有效值。
        :type ParentSet: str
        :param _ChildSet: 子节点列表字符串
注意：此字段可能返回 null，表示取不到有效值。
        :type ChildSet: str
        :param _ExtParams: 额外参数
注意：此字段可能返回 null，表示取不到有效值。
        :type ExtParams: list of LineageParamRecord
        :param _TableId: 表ID
注意：此字段可能返回 null，表示取不到有效值。
        :type TableId: str
        """
        self._Id = None
        self._DatasourceId = None
        self._ColumnName = None
        self._ColumnNameCn = None
        self._ColumnType = None
        self._RelationParams = None
        self._Params = None
        self._ParentId = None
        self._MetastoreType = None
        self._MetastoreTypeName = None
        self._TableName = None
        self._QualifiedName = None
        self._DownStreamCount = None
        self._UpStreamCount = None
        self._Description = None
        self._PrefixPath = None
        self._CreateTime = None
        self._ModifyTime = None
        self._Tasks = None
        self._ParentSet = None
        self._ChildSet = None
        self._ExtParams = None
        self._TableId = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def ColumnName(self):
        return self._ColumnName

    @ColumnName.setter
    def ColumnName(self, ColumnName):
        self._ColumnName = ColumnName

    @property
    def ColumnNameCn(self):
        return self._ColumnNameCn

    @ColumnNameCn.setter
    def ColumnNameCn(self, ColumnNameCn):
        self._ColumnNameCn = ColumnNameCn

    @property
    def ColumnType(self):
        return self._ColumnType

    @ColumnType.setter
    def ColumnType(self, ColumnType):
        self._ColumnType = ColumnType

    @property
    def RelationParams(self):
        return self._RelationParams

    @RelationParams.setter
    def RelationParams(self, RelationParams):
        self._RelationParams = RelationParams

    @property
    def Params(self):
        return self._Params

    @Params.setter
    def Params(self, Params):
        self._Params = Params

    @property
    def ParentId(self):
        return self._ParentId

    @ParentId.setter
    def ParentId(self, ParentId):
        self._ParentId = ParentId

    @property
    def MetastoreType(self):
        return self._MetastoreType

    @MetastoreType.setter
    def MetastoreType(self, MetastoreType):
        self._MetastoreType = MetastoreType

    @property
    def MetastoreTypeName(self):
        return self._MetastoreTypeName

    @MetastoreTypeName.setter
    def MetastoreTypeName(self, MetastoreTypeName):
        self._MetastoreTypeName = MetastoreTypeName

    @property
    def TableName(self):
        return self._TableName

    @TableName.setter
    def TableName(self, TableName):
        self._TableName = TableName

    @property
    def QualifiedName(self):
        return self._QualifiedName

    @QualifiedName.setter
    def QualifiedName(self, QualifiedName):
        self._QualifiedName = QualifiedName

    @property
    def DownStreamCount(self):
        return self._DownStreamCount

    @DownStreamCount.setter
    def DownStreamCount(self, DownStreamCount):
        self._DownStreamCount = DownStreamCount

    @property
    def UpStreamCount(self):
        return self._UpStreamCount

    @UpStreamCount.setter
    def UpStreamCount(self, UpStreamCount):
        self._UpStreamCount = UpStreamCount

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def PrefixPath(self):
        return self._PrefixPath

    @PrefixPath.setter
    def PrefixPath(self, PrefixPath):
        self._PrefixPath = PrefixPath

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ModifyTime(self):
        return self._ModifyTime

    @ModifyTime.setter
    def ModifyTime(self, ModifyTime):
        self._ModifyTime = ModifyTime

    @property
    def Tasks(self):
        return self._Tasks

    @Tasks.setter
    def Tasks(self, Tasks):
        self._Tasks = Tasks

    @property
    def ParentSet(self):
        return self._ParentSet

    @ParentSet.setter
    def ParentSet(self, ParentSet):
        self._ParentSet = ParentSet

    @property
    def ChildSet(self):
        return self._ChildSet

    @ChildSet.setter
    def ChildSet(self, ChildSet):
        self._ChildSet = ChildSet

    @property
    def ExtParams(self):
        return self._ExtParams

    @ExtParams.setter
    def ExtParams(self, ExtParams):
        self._ExtParams = ExtParams

    @property
    def TableId(self):
        return self._TableId

    @TableId.setter
    def TableId(self, TableId):
        self._TableId = TableId


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._DatasourceId = params.get("DatasourceId")
        self._ColumnName = params.get("ColumnName")
        self._ColumnNameCn = params.get("ColumnNameCn")
        self._ColumnType = params.get("ColumnType")
        self._RelationParams = params.get("RelationParams")
        self._Params = params.get("Params")
        self._ParentId = params.get("ParentId")
        self._MetastoreType = params.get("MetastoreType")
        self._MetastoreTypeName = params.get("MetastoreTypeName")
        self._TableName = params.get("TableName")
        self._QualifiedName = params.get("QualifiedName")
        self._DownStreamCount = params.get("DownStreamCount")
        self._UpStreamCount = params.get("UpStreamCount")
        self._Description = params.get("Description")
        self._PrefixPath = params.get("PrefixPath")
        self._CreateTime = params.get("CreateTime")
        self._ModifyTime = params.get("ModifyTime")
        self._Tasks = params.get("Tasks")
        self._ParentSet = params.get("ParentSet")
        self._ChildSet = params.get("ChildSet")
        if params.get("ExtParams") is not None:
            self._ExtParams = []
            for item in params.get("ExtParams"):
                obj = LineageParamRecord()
                obj._deserialize(item)
                self._ExtParams.append(obj)
        self._TableId = params.get("TableId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ColumnMeta(AbstractModel):
    """列的元数据

    """

    def __init__(self):
        r"""
        :param _NameEn: 字段英文名称
注意：此字段可能返回 null，表示取不到有效值。
        :type NameEn: str
        :param _NameCn: 字段中文名称
注意：此字段可能返回 null，表示取不到有效值。
        :type NameCn: str
        :param _Type: 字段类型
注意：此字段可能返回 null，表示取不到有效值。
        :type Type: str
        :param _Description: 字段描述
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        :param _Position: 字段序号
注意：此字段可能返回 null，表示取不到有效值。
        :type Position: int
        :param _IsPartition: 是否为分区字段
注意：此字段可能返回 null，表示取不到有效值。
        :type IsPartition: bool
        :param _Name: 字段名
注意：此字段可能返回 null，表示取不到有效值。
        :type Name: str
        :param _ColumnFamiliesFieldSet: HBase列簇属性集合
注意：此字段可能返回 null，表示取不到有效值。
        :type ColumnFamiliesFieldSet: list of Pair
        :param _DictionaryId: 对应码表字典ID
注意：此字段可能返回 null，表示取不到有效值。
        :type DictionaryId: str
        :param _DictionaryName: 对应码表字典名称
注意：此字段可能返回 null，表示取不到有效值。
        :type DictionaryName: str
        :param _LevelName: 安全等级：名称
注意：此字段可能返回 null，表示取不到有效值。
        :type LevelName: str
        :param _LevelRank: 安全等级：值范围1-10
注意：此字段可能返回 null，表示取不到有效值。
        :type LevelRank: int
        """
        self._NameEn = None
        self._NameCn = None
        self._Type = None
        self._Description = None
        self._Position = None
        self._IsPartition = None
        self._Name = None
        self._ColumnFamiliesFieldSet = None
        self._DictionaryId = None
        self._DictionaryName = None
        self._LevelName = None
        self._LevelRank = None

    @property
    def NameEn(self):
        return self._NameEn

    @NameEn.setter
    def NameEn(self, NameEn):
        self._NameEn = NameEn

    @property
    def NameCn(self):
        return self._NameCn

    @NameCn.setter
    def NameCn(self, NameCn):
        self._NameCn = NameCn

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Position(self):
        return self._Position

    @Position.setter
    def Position(self, Position):
        self._Position = Position

    @property
    def IsPartition(self):
        return self._IsPartition

    @IsPartition.setter
    def IsPartition(self, IsPartition):
        self._IsPartition = IsPartition

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def ColumnFamiliesFieldSet(self):
        return self._ColumnFamiliesFieldSet

    @ColumnFamiliesFieldSet.setter
    def ColumnFamiliesFieldSet(self, ColumnFamiliesFieldSet):
        self._ColumnFamiliesFieldSet = ColumnFamiliesFieldSet

    @property
    def DictionaryId(self):
        return self._DictionaryId

    @DictionaryId.setter
    def DictionaryId(self, DictionaryId):
        self._DictionaryId = DictionaryId

    @property
    def DictionaryName(self):
        return self._DictionaryName

    @DictionaryName.setter
    def DictionaryName(self, DictionaryName):
        self._DictionaryName = DictionaryName

    @property
    def LevelName(self):
        return self._LevelName

    @LevelName.setter
    def LevelName(self, LevelName):
        self._LevelName = LevelName

    @property
    def LevelRank(self):
        return self._LevelRank

    @LevelRank.setter
    def LevelRank(self, LevelRank):
        self._LevelRank = LevelRank


    def _deserialize(self, params):
        self._NameEn = params.get("NameEn")
        self._NameCn = params.get("NameCn")
        self._Type = params.get("Type")
        self._Description = params.get("Description")
        self._Position = params.get("Position")
        self._IsPartition = params.get("IsPartition")
        self._Name = params.get("Name")
        if params.get("ColumnFamiliesFieldSet") is not None:
            self._ColumnFamiliesFieldSet = []
            for item in params.get("ColumnFamiliesFieldSet"):
                obj = Pair()
                obj._deserialize(item)
                self._ColumnFamiliesFieldSet.append(obj)
        self._DictionaryId = params.get("DictionaryId")
        self._DictionaryName = params.get("DictionaryName")
        self._LevelName = params.get("LevelName")
        self._LevelRank = params.get("LevelRank")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CommitExportTaskRequest(AbstractModel):
    """CommitExportTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _RuleExecId: 规则执行Id
        :type RuleExecId: int
        :param _ExportType: 导出类型(1.全部,2.触发行,3.通过行)
        :type ExportType: int
        :param _ExecutorGroupId: 执行资源组id
        :type ExecutorGroupId: str
        :param _QueueName: 计算资源队列
        :type QueueName: str
        """
        self._ProjectId = None
        self._RuleExecId = None
        self._ExportType = None
        self._ExecutorGroupId = None
        self._QueueName = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def RuleExecId(self):
        return self._RuleExecId

    @RuleExecId.setter
    def RuleExecId(self, RuleExecId):
        self._RuleExecId = RuleExecId

    @property
    def ExportType(self):
        return self._ExportType

    @ExportType.setter
    def ExportType(self, ExportType):
        self._ExportType = ExportType

    @property
    def ExecutorGroupId(self):
        return self._ExecutorGroupId

    @ExecutorGroupId.setter
    def ExecutorGroupId(self, ExecutorGroupId):
        self._ExecutorGroupId = ExecutorGroupId

    @property
    def QueueName(self):
        return self._QueueName

    @QueueName.setter
    def QueueName(self, QueueName):
        self._QueueName = QueueName


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._RuleExecId = params.get("RuleExecId")
        self._ExportType = params.get("ExportType")
        self._ExecutorGroupId = params.get("ExecutorGroupId")
        self._QueueName = params.get("QueueName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CommitExportTaskResponse(AbstractModel):
    """CommitExportTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 提交结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CommitIntegrationTaskRequest(AbstractModel):
    """CommitIntegrationTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _CommitType: 0.仅提交，1.立即启动，2.停止线上作业，丢弃作业状态数据，重新启动运行，3.暂停线上作业，保留作业状态数据，继续运行，4.保留作业状态数据，继续运行
        :type CommitType: int
        :param _TaskType: 实时任务 201   离线任务 202  默认实时任务
        :type TaskType: int
        :param _ExtConfig: 额外参数
        :type ExtConfig: list of RecordField
        :param _VersionDesc: 提交版本描述
        :type VersionDesc: str
        :param _InstanceVersion: 提交版本号
        :type InstanceVersion: int
        :param _EventDesc: 前端操作类型描述
        :type EventDesc: str
        """
        self._TaskId = None
        self._ProjectId = None
        self._CommitType = None
        self._TaskType = None
        self._ExtConfig = None
        self._VersionDesc = None
        self._InstanceVersion = None
        self._EventDesc = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def CommitType(self):
        return self._CommitType

    @CommitType.setter
    def CommitType(self, CommitType):
        self._CommitType = CommitType

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ExtConfig(self):
        return self._ExtConfig

    @ExtConfig.setter
    def ExtConfig(self, ExtConfig):
        self._ExtConfig = ExtConfig

    @property
    def VersionDesc(self):
        return self._VersionDesc

    @VersionDesc.setter
    def VersionDesc(self, VersionDesc):
        self._VersionDesc = VersionDesc

    @property
    def InstanceVersion(self):
        return self._InstanceVersion

    @InstanceVersion.setter
    def InstanceVersion(self, InstanceVersion):
        self._InstanceVersion = InstanceVersion

    @property
    def EventDesc(self):
        return self._EventDesc

    @EventDesc.setter
    def EventDesc(self, EventDesc):
        self._EventDesc = EventDesc


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ProjectId = params.get("ProjectId")
        self._CommitType = params.get("CommitType")
        self._TaskType = params.get("TaskType")
        if params.get("ExtConfig") is not None:
            self._ExtConfig = []
            for item in params.get("ExtConfig"):
                obj = RecordField()
                obj._deserialize(item)
                self._ExtConfig.append(obj)
        self._VersionDesc = params.get("VersionDesc")
        self._InstanceVersion = params.get("InstanceVersion")
        self._EventDesc = params.get("EventDesc")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CommitIntegrationTaskResponse(AbstractModel):
    """CommitIntegrationTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 操作成功与否标识
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CommitRuleGroupExecResultRequest(AbstractModel):
    """CommitRuleGroupExecResult请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _RuleGroupExecId: 规则组执行ID
        :type RuleGroupExecId: int
        :param _RuleGroupState: 规则组执行状态
        :type RuleGroupState: str
        :param _RuleExecResults: 规则执行结果集合
        :type RuleExecResults: list of RunnerRuleExecResult
        """
        self._ProjectId = None
        self._RuleGroupExecId = None
        self._RuleGroupState = None
        self._RuleExecResults = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def RuleGroupExecId(self):
        return self._RuleGroupExecId

    @RuleGroupExecId.setter
    def RuleGroupExecId(self, RuleGroupExecId):
        self._RuleGroupExecId = RuleGroupExecId

    @property
    def RuleGroupState(self):
        return self._RuleGroupState

    @RuleGroupState.setter
    def RuleGroupState(self, RuleGroupState):
        self._RuleGroupState = RuleGroupState

    @property
    def RuleExecResults(self):
        return self._RuleExecResults

    @RuleExecResults.setter
    def RuleExecResults(self, RuleExecResults):
        self._RuleExecResults = RuleExecResults


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._RuleGroupExecId = params.get("RuleGroupExecId")
        self._RuleGroupState = params.get("RuleGroupState")
        if params.get("RuleExecResults") is not None:
            self._RuleExecResults = []
            for item in params.get("RuleExecResults"):
                obj = RunnerRuleExecResult()
                obj._deserialize(item)
                self._RuleExecResults.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CommitRuleGroupExecResultResponse(AbstractModel):
    """CommitRuleGroupExecResult返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 无
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CommitRuleGroupTaskRequest(AbstractModel):
    """CommitRuleGroupTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleGroupId: 规则组ID
        :type RuleGroupId: int
        :param _TriggerType: 触发类型 1.手动触发 2.调度事中触发 3.周期调度触发
        :type TriggerType: int
        :param _ExecRuleConfig: 规则配置列表
        :type ExecRuleConfig: list of RuleConfig
        :param _ExecConfig: 执行配置
        :type ExecConfig: :class:`tencentcloud.wedata.v20210820.models.RuleExecConfig`
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _EngineType: 该规则运行的执行引擎，不传时会请求该数据源下默认的执行引擎
        :type EngineType: str
        """
        self._RuleGroupId = None
        self._TriggerType = None
        self._ExecRuleConfig = None
        self._ExecConfig = None
        self._ProjectId = None
        self._EngineType = None

    @property
    def RuleGroupId(self):
        return self._RuleGroupId

    @RuleGroupId.setter
    def RuleGroupId(self, RuleGroupId):
        self._RuleGroupId = RuleGroupId

    @property
    def TriggerType(self):
        return self._TriggerType

    @TriggerType.setter
    def TriggerType(self, TriggerType):
        self._TriggerType = TriggerType

    @property
    def ExecRuleConfig(self):
        return self._ExecRuleConfig

    @ExecRuleConfig.setter
    def ExecRuleConfig(self, ExecRuleConfig):
        self._ExecRuleConfig = ExecRuleConfig

    @property
    def ExecConfig(self):
        return self._ExecConfig

    @ExecConfig.setter
    def ExecConfig(self, ExecConfig):
        self._ExecConfig = ExecConfig

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def EngineType(self):
        return self._EngineType

    @EngineType.setter
    def EngineType(self, EngineType):
        self._EngineType = EngineType


    def _deserialize(self, params):
        self._RuleGroupId = params.get("RuleGroupId")
        self._TriggerType = params.get("TriggerType")
        if params.get("ExecRuleConfig") is not None:
            self._ExecRuleConfig = []
            for item in params.get("ExecRuleConfig"):
                obj = RuleConfig()
                obj._deserialize(item)
                self._ExecRuleConfig.append(obj)
        if params.get("ExecConfig") is not None:
            self._ExecConfig = RuleExecConfig()
            self._ExecConfig._deserialize(params.get("ExecConfig"))
        self._ProjectId = params.get("ProjectId")
        self._EngineType = params.get("EngineType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CommitRuleGroupTaskResponse(AbstractModel):
    """CommitRuleGroupTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则组执行id
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleGroupExecResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleGroupExecResult()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CommonContent(AbstractModel):
    """内容详情

    """

    def __init__(self):
        r"""
        :param _Content: 详情内容
注意：此字段可能返回 null，表示取不到有效值。
        :type Content: str
        """
        self._Content = None

    @property
    def Content(self):
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content


    def _deserialize(self, params):
        self._Content = params.get("Content")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CommonId(AbstractModel):
    """Id包装对象

    """

    def __init__(self):
        r"""
        :param _Id: Id值
注意：此字段可能返回 null，表示取不到有效值。
        :type Id: str
        """
        self._Id = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CommonIdOpsDto(AbstractModel):
    """返回命令id

    """

    def __init__(self):
        r"""
        :param _Id: 返回命令id
注意：此字段可能返回 null，表示取不到有效值。
        :type Id: str
        """
        self._Id = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CompareResult(AbstractModel):
    """质量检查对比结果

    """

    def __init__(self):
        r"""
        :param _Items: 对比结果项列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Items: list of CompareResultItem
        :param _TotalRows: 检测总行数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalRows: int
        :param _PassRows: 检测通过行数
注意：此字段可能返回 null，表示取不到有效值。
        :type PassRows: int
        :param _TriggerRows: 检测不通过行数
注意：此字段可能返回 null，表示取不到有效值。
        :type TriggerRows: int
        """
        self._Items = None
        self._TotalRows = None
        self._PassRows = None
        self._TriggerRows = None

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def TotalRows(self):
        return self._TotalRows

    @TotalRows.setter
    def TotalRows(self, TotalRows):
        self._TotalRows = TotalRows

    @property
    def PassRows(self):
        return self._PassRows

    @PassRows.setter
    def PassRows(self, PassRows):
        self._PassRows = PassRows

    @property
    def TriggerRows(self):
        return self._TriggerRows

    @TriggerRows.setter
    def TriggerRows(self, TriggerRows):
        self._TriggerRows = TriggerRows


    def _deserialize(self, params):
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = CompareResultItem()
                obj._deserialize(item)
                self._Items.append(obj)
        self._TotalRows = params.get("TotalRows")
        self._PassRows = params.get("PassRows")
        self._TriggerRows = params.get("TriggerRows")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CompareResultItem(AbstractModel):
    """对比结果项

    """

    def __init__(self):
        r"""
        :param _FixResult: 对比结果， 1为真 2为假
注意：此字段可能返回 null，表示取不到有效值。
        :type FixResult: int
        :param _ResultValue: 质量sql执行结果
注意：此字段可能返回 null，表示取不到有效值。
        :type ResultValue: str
        :param _Values: 阈值列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Values: list of ThresholdValue
        :param _Operator: 比较操作类型
注意：此字段可能返回 null，表示取不到有效值。
        :type Operator: str
        :param _CompareType: 比较类型
注意：此字段可能返回 null，表示取不到有效值。
        :type CompareType: int
        :param _ValueComputeType: 值比较类型
注意：此字段可能返回 null，表示取不到有效值。
        :type ValueComputeType: int
        """
        self._FixResult = None
        self._ResultValue = None
        self._Values = None
        self._Operator = None
        self._CompareType = None
        self._ValueComputeType = None

    @property
    def FixResult(self):
        return self._FixResult

    @FixResult.setter
    def FixResult(self, FixResult):
        self._FixResult = FixResult

    @property
    def ResultValue(self):
        return self._ResultValue

    @ResultValue.setter
    def ResultValue(self, ResultValue):
        self._ResultValue = ResultValue

    @property
    def Values(self):
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values

    @property
    def Operator(self):
        return self._Operator

    @Operator.setter
    def Operator(self, Operator):
        self._Operator = Operator

    @property
    def CompareType(self):
        return self._CompareType

    @CompareType.setter
    def CompareType(self, CompareType):
        self._CompareType = CompareType

    @property
    def ValueComputeType(self):
        return self._ValueComputeType

    @ValueComputeType.setter
    def ValueComputeType(self, ValueComputeType):
        self._ValueComputeType = ValueComputeType


    def _deserialize(self, params):
        self._FixResult = params.get("FixResult")
        self._ResultValue = params.get("ResultValue")
        if params.get("Values") is not None:
            self._Values = []
            for item in params.get("Values"):
                obj = ThresholdValue()
                obj._deserialize(item)
                self._Values.append(obj)
        self._Operator = params.get("Operator")
        self._CompareType = params.get("CompareType")
        self._ValueComputeType = params.get("ValueComputeType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CompareRule(AbstractModel):
    """对比规则

    """

    def __init__(self):
        r"""
        :param _Items: 比较条件列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Items: list of CompareRuleItem
        :param _CycleStep: 周期性模板默认周期，单位秒
注意：此字段可能返回 null，表示取不到有效值。
        :type CycleStep: int
        :param _ComputeExpression: o 表示 或，a 表示 且，数字表示items下标
注意：此字段可能返回 null，表示取不到有效值。
        :type ComputeExpression: str
        """
        self._Items = None
        self._CycleStep = None
        self._ComputeExpression = None

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def CycleStep(self):
        return self._CycleStep

    @CycleStep.setter
    def CycleStep(self, CycleStep):
        self._CycleStep = CycleStep

    @property
    def ComputeExpression(self):
        return self._ComputeExpression

    @ComputeExpression.setter
    def ComputeExpression(self, ComputeExpression):
        self._ComputeExpression = ComputeExpression


    def _deserialize(self, params):
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = CompareRuleItem()
                obj._deserialize(item)
                self._Items.append(obj)
        self._CycleStep = params.get("CycleStep")
        self._ComputeExpression = params.get("ComputeExpression")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CompareRuleItem(AbstractModel):
    """比较条件

    """

    def __init__(self):
        r"""
        :param _CompareType: 比较类型 1.固定值  2.波动值  3.数值范围比较  4.枚举范围比较  5.不用比较
注意：此字段可能返回 null，表示取不到有效值。
        :type CompareType: int
        :param _Operator: 比较操作类型
<  <=  ==  =>  > !=
IRLCRO:在区间内(左闭右开)
IRLORC:在区间内(左开右闭)
IRLCRC:在区间内(左闭右闭)
IRLORO:在区间内(左开右开)
NRLCRO:不在区间内(左闭右开)
NRLORC:不在区间内(左开右闭)
NRLCRC:不在在区间内(左闭右闭)
NRLORO:不在在区间内(左开右开)
注意：此字段可能返回 null，表示取不到有效值。
        :type Operator: str
        :param _ValueComputeType: 质量统计值类型 1.绝对值  2.上升 3. 下降  4._C包含   5. N_C不包含
注意：此字段可能返回 null，表示取不到有效值。
        :type ValueComputeType: int
        :param _ValueList: 比较阈值列表
注意：此字段可能返回 null，表示取不到有效值。
        :type ValueList: list of ThresholdValue
        """
        self._CompareType = None
        self._Operator = None
        self._ValueComputeType = None
        self._ValueList = None

    @property
    def CompareType(self):
        return self._CompareType

    @CompareType.setter
    def CompareType(self, CompareType):
        self._CompareType = CompareType

    @property
    def Operator(self):
        return self._Operator

    @Operator.setter
    def Operator(self, Operator):
        self._Operator = Operator

    @property
    def ValueComputeType(self):
        return self._ValueComputeType

    @ValueComputeType.setter
    def ValueComputeType(self, ValueComputeType):
        self._ValueComputeType = ValueComputeType

    @property
    def ValueList(self):
        return self._ValueList

    @ValueList.setter
    def ValueList(self, ValueList):
        self._ValueList = ValueList


    def _deserialize(self, params):
        self._CompareType = params.get("CompareType")
        self._Operator = params.get("Operator")
        self._ValueComputeType = params.get("ValueComputeType")
        if params.get("ValueList") is not None:
            self._ValueList = []
            for item in params.get("ValueList"):
                obj = ThresholdValue()
                obj._deserialize(item)
                self._ValueList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CountOpsInstanceStateRequest(AbstractModel):
    """CountOpsInstanceState请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _ProjectId: 项目Id
        :type ProjectId: str
        """
        self._TaskId = None
        self._ProjectId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CountOpsInstanceStateResponse(AbstractModel):
    """CountOpsInstanceState返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 任务对应实例的状态统计
        :type Data: :class:`tencentcloud.wedata.v20210820.models.TaskInstanceCountDto`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = TaskInstanceCountDto()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CreateAlarmRuleRequest(AbstractModel):
    """CreateAlarmRuleRequest

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ProjectId: str
        :param _CreatorId: 创建人名字
注意：此字段可能返回 null，表示取不到有效值。
        :type CreatorId: str
        :param _Creator: 创建人uin
注意：此字段可能返回 null，表示取不到有效值。
        :type Creator: str
        :param _RuleName: 规则名字
注意：此字段可能返回 null，表示取不到有效值。
        :type RuleName: str
        :param _MonitorType: 监控类型,1.task、2.workflow、3.project、4.baseline（默认为1.任务）
注意：此字段可能返回 null，表示取不到有效值。
        :type MonitorType: int
        :param _MonitorObjectIds: 监控对象
注意：此字段可能返回 null，表示取不到有效值。
        :type MonitorObjectIds: list of str
        :param _AlarmTypes: 告警类型，1.失败告警、2.超时告警、3.成功告警、4.基线破线、5.基线预警、6.基线任务失败（默认1.失败告警）
注意：此字段可能返回 null，表示取不到有效值。
        :type AlarmTypes: list of str
        :param _AlarmLevel: 告警级别，1.普通、2.重要、3.紧急（默认1.普通）
注意：此字段可能返回 null，表示取不到有效值。
        :type AlarmLevel: int
        :param _AlarmWays: 告警方式,1.邮件，2.短信，3.微信，4.语音，5.企业微信，6.Http，7.企业微信群；告警方式code列表（默认1.邮件）
注意：此字段可能返回 null，表示取不到有效值。
        :type AlarmWays: list of str
        :param _AlarmRecipientType: 告警接收人类型：1.指定人员，2.任务责任人，3.值班表（默认1.指定人员）
注意：此字段可能返回 null，表示取不到有效值。
        :type AlarmRecipientType: int
        :param _AlarmRecipients: 告警接收人
注意：此字段可能返回 null，表示取不到有效值。
        :type AlarmRecipients: list of str
        :param _AlarmRecipientIds: 告警接收人ID
注意：此字段可能返回 null，表示取不到有效值。
        :type AlarmRecipientIds: list of str
        :param _ExtInfo: 扩展信息, 1.预计运行耗时（默认），2.预计完成时间，3.预计调度时间，4.周期内未完成；取值类型：1.指定指，2.历史均值（默认1.指定指）
注意：此字段可能返回 null，表示取不到有效值。
        :type ExtInfo: str
        """
        self._ProjectId = None
        self._CreatorId = None
        self._Creator = None
        self._RuleName = None
        self._MonitorType = None
        self._MonitorObjectIds = None
        self._AlarmTypes = None
        self._AlarmLevel = None
        self._AlarmWays = None
        self._AlarmRecipientType = None
        self._AlarmRecipients = None
        self._AlarmRecipientIds = None
        self._ExtInfo = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def CreatorId(self):
        return self._CreatorId

    @CreatorId.setter
    def CreatorId(self, CreatorId):
        self._CreatorId = CreatorId

    @property
    def Creator(self):
        return self._Creator

    @Creator.setter
    def Creator(self, Creator):
        self._Creator = Creator

    @property
    def RuleName(self):
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName

    @property
    def MonitorType(self):
        return self._MonitorType

    @MonitorType.setter
    def MonitorType(self, MonitorType):
        self._MonitorType = MonitorType

    @property
    def MonitorObjectIds(self):
        return self._MonitorObjectIds

    @MonitorObjectIds.setter
    def MonitorObjectIds(self, MonitorObjectIds):
        self._MonitorObjectIds = MonitorObjectIds

    @property
    def AlarmTypes(self):
        return self._AlarmTypes

    @AlarmTypes.setter
    def AlarmTypes(self, AlarmTypes):
        self._AlarmTypes = AlarmTypes

    @property
    def AlarmLevel(self):
        return self._AlarmLevel

    @AlarmLevel.setter
    def AlarmLevel(self, AlarmLevel):
        self._AlarmLevel = AlarmLevel

    @property
    def AlarmWays(self):
        return self._AlarmWays

    @AlarmWays.setter
    def AlarmWays(self, AlarmWays):
        self._AlarmWays = AlarmWays

    @property
    def AlarmRecipientType(self):
        return self._AlarmRecipientType

    @AlarmRecipientType.setter
    def AlarmRecipientType(self, AlarmRecipientType):
        self._AlarmRecipientType = AlarmRecipientType

    @property
    def AlarmRecipients(self):
        return self._AlarmRecipients

    @AlarmRecipients.setter
    def AlarmRecipients(self, AlarmRecipients):
        self._AlarmRecipients = AlarmRecipients

    @property
    def AlarmRecipientIds(self):
        return self._AlarmRecipientIds

    @AlarmRecipientIds.setter
    def AlarmRecipientIds(self, AlarmRecipientIds):
        self._AlarmRecipientIds = AlarmRecipientIds

    @property
    def ExtInfo(self):
        return self._ExtInfo

    @ExtInfo.setter
    def ExtInfo(self, ExtInfo):
        self._ExtInfo = ExtInfo


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._CreatorId = params.get("CreatorId")
        self._Creator = params.get("Creator")
        self._RuleName = params.get("RuleName")
        self._MonitorType = params.get("MonitorType")
        self._MonitorObjectIds = params.get("MonitorObjectIds")
        self._AlarmTypes = params.get("AlarmTypes")
        self._AlarmLevel = params.get("AlarmLevel")
        self._AlarmWays = params.get("AlarmWays")
        self._AlarmRecipientType = params.get("AlarmRecipientType")
        self._AlarmRecipients = params.get("AlarmRecipients")
        self._AlarmRecipientIds = params.get("AlarmRecipientIds")
        self._ExtInfo = params.get("ExtInfo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateBaselineRequest(AbstractModel):
    """CreateBaseline请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _BaselineName: 基线名称
        :type BaselineName: str
        :param _BaselineType: D或者H；分别表示天基线和小时基线
        :type BaselineType: str
        :param _CreateUin: 创建人id
        :type CreateUin: str
        :param _CreateName: 创建人名称
        :type CreateName: str
        :param _InChargeUin: 基线负责人id
        :type InChargeUin: str
        :param _InChargeName: 基线负责人名称
        :type InChargeName: str
        :param _PromiseTasks: 保障任务
        :type PromiseTasks: list of BaselineTaskInfo
        :param _PromiseTime: 保障时间
        :type PromiseTime: str
        :param _WarningMargin: 告警余量/分钟
        :type WarningMargin: int
        :param _IsNewAlarm: 1
        :type IsNewAlarm: bool
        :param _AlarmRuleDto: 现有告警规则信息
        :type AlarmRuleDto: :class:`tencentcloud.wedata.v20210820.models.AlarmRuleDto`
        :param _BaselineCreateAlarmRuleRequest: 新增告警规则描述
        :type BaselineCreateAlarmRuleRequest: :class:`tencentcloud.wedata.v20210820.models.CreateAlarmRuleRequest`
        """
        self._ProjectId = None
        self._BaselineName = None
        self._BaselineType = None
        self._CreateUin = None
        self._CreateName = None
        self._InChargeUin = None
        self._InChargeName = None
        self._PromiseTasks = None
        self._PromiseTime = None
        self._WarningMargin = None
        self._IsNewAlarm = None
        self._AlarmRuleDto = None
        self._BaselineCreateAlarmRuleRequest = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def BaselineName(self):
        return self._BaselineName

    @BaselineName.setter
    def BaselineName(self, BaselineName):
        self._BaselineName = BaselineName

    @property
    def BaselineType(self):
        return self._BaselineType

    @BaselineType.setter
    def BaselineType(self, BaselineType):
        self._BaselineType = BaselineType

    @property
    def CreateUin(self):
        return self._CreateUin

    @CreateUin.setter
    def CreateUin(self, CreateUin):
        self._CreateUin = CreateUin

    @property
    def CreateName(self):
        return self._CreateName

    @CreateName.setter
    def CreateName(self, CreateName):
        self._CreateName = CreateName

    @property
    def InChargeUin(self):
        return self._InChargeUin

    @InChargeUin.setter
    def InChargeUin(self, InChargeUin):
        self._InChargeUin = InChargeUin

    @property
    def InChargeName(self):
        return self._InChargeName

    @InChargeName.setter
    def InChargeName(self, InChargeName):
        self._InChargeName = InChargeName

    @property
    def PromiseTasks(self):
        return self._PromiseTasks

    @PromiseTasks.setter
    def PromiseTasks(self, PromiseTasks):
        self._PromiseTasks = PromiseTasks

    @property
    def PromiseTime(self):
        return self._PromiseTime

    @PromiseTime.setter
    def PromiseTime(self, PromiseTime):
        self._PromiseTime = PromiseTime

    @property
    def WarningMargin(self):
        return self._WarningMargin

    @WarningMargin.setter
    def WarningMargin(self, WarningMargin):
        self._WarningMargin = WarningMargin

    @property
    def IsNewAlarm(self):
        return self._IsNewAlarm

    @IsNewAlarm.setter
    def IsNewAlarm(self, IsNewAlarm):
        self._IsNewAlarm = IsNewAlarm

    @property
    def AlarmRuleDto(self):
        return self._AlarmRuleDto

    @AlarmRuleDto.setter
    def AlarmRuleDto(self, AlarmRuleDto):
        self._AlarmRuleDto = AlarmRuleDto

    @property
    def BaselineCreateAlarmRuleRequest(self):
        return self._BaselineCreateAlarmRuleRequest

    @BaselineCreateAlarmRuleRequest.setter
    def BaselineCreateAlarmRuleRequest(self, BaselineCreateAlarmRuleRequest):
        self._BaselineCreateAlarmRuleRequest = BaselineCreateAlarmRuleRequest


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._BaselineName = params.get("BaselineName")
        self._BaselineType = params.get("BaselineType")
        self._CreateUin = params.get("CreateUin")
        self._CreateName = params.get("CreateName")
        self._InChargeUin = params.get("InChargeUin")
        self._InChargeName = params.get("InChargeName")
        if params.get("PromiseTasks") is not None:
            self._PromiseTasks = []
            for item in params.get("PromiseTasks"):
                obj = BaselineTaskInfo()
                obj._deserialize(item)
                self._PromiseTasks.append(obj)
        self._PromiseTime = params.get("PromiseTime")
        self._WarningMargin = params.get("WarningMargin")
        self._IsNewAlarm = params.get("IsNewAlarm")
        if params.get("AlarmRuleDto") is not None:
            self._AlarmRuleDto = AlarmRuleDto()
            self._AlarmRuleDto._deserialize(params.get("AlarmRuleDto"))
        if params.get("BaselineCreateAlarmRuleRequest") is not None:
            self._BaselineCreateAlarmRuleRequest = CreateAlarmRuleRequest()
            self._BaselineCreateAlarmRuleRequest._deserialize(params.get("BaselineCreateAlarmRuleRequest"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateBaselineResponse(AbstractModel):
    """CreateBaseline返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 是否成功
        :type Data: :class:`tencentcloud.wedata.v20210820.models.BooleanResponse`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanResponse()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CreateCustomFunctionRequest(AbstractModel):
    """CreateCustomFunction请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Type: 枚举值：HIVE、SPARK、DLC
        :type Type: str
        :param _Kind: 枚举值：ANALYSIS(函数)、ENCRYPTION(加密函数)、AGGREGATE(聚合函数)、LOGIC(逻辑函数)、DATE_AND_TIME(日期与时间函数)、MATH(数学函数)、CONVERSION(转换函数)、STRING(字符串函数)、IP_AND_DOMAIN(IP和域名函数)、WINDOW(窗口函数)、OTHER(其他函数)
        :type Kind: str
        :param _Name: 函数名称
        :type Name: str
        :param _ClusterIdentifier: 集群实例引擎 ID
        :type ClusterIdentifier: str
        :param _DbName: 数据库名称
        :type DbName: str
        :param _ProjectId: 项目ID
        :type ProjectId: str
        """
        self._Type = None
        self._Kind = None
        self._Name = None
        self._ClusterIdentifier = None
        self._DbName = None
        self._ProjectId = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Kind(self):
        return self._Kind

    @Kind.setter
    def Kind(self, Kind):
        self._Kind = Kind

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def ClusterIdentifier(self):
        return self._ClusterIdentifier

    @ClusterIdentifier.setter
    def ClusterIdentifier(self, ClusterIdentifier):
        self._ClusterIdentifier = ClusterIdentifier

    @property
    def DbName(self):
        return self._DbName

    @DbName.setter
    def DbName(self, DbName):
        self._DbName = DbName

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Kind = params.get("Kind")
        self._Name = params.get("Name")
        self._ClusterIdentifier = params.get("ClusterIdentifier")
        self._DbName = params.get("DbName")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateCustomFunctionResponse(AbstractModel):
    """CreateCustomFunction返回参数结构体

    """

    def __init__(self):
        r"""
        :param _FunctionId: 函数唯一标识
注意：此字段可能返回 null，表示取不到有效值。
        :type FunctionId: str
        :param _ErrorMessage: 无
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrorMessage: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._FunctionId = None
        self._ErrorMessage = None
        self._RequestId = None

    @property
    def FunctionId(self):
        return self._FunctionId

    @FunctionId.setter
    def FunctionId(self, FunctionId):
        self._FunctionId = FunctionId

    @property
    def ErrorMessage(self):
        return self._ErrorMessage

    @ErrorMessage.setter
    def ErrorMessage(self, ErrorMessage):
        self._ErrorMessage = ErrorMessage

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FunctionId = params.get("FunctionId")
        self._ErrorMessage = params.get("ErrorMessage")
        self._RequestId = params.get("RequestId")


class CreateDataSourceRequest(AbstractModel):
    """CreateDataSource请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 数据源名称，在相同SpaceName下，数据源名称不能为空
        :type Name: str
        :param _Category: 数据源类别：绑定引擎、绑定数据库
        :type Category: str
        :param _Type: 数据源类型:枚举值
        :type Type: str
        :param _OwnerProjectId: 归属项目ID
        :type OwnerProjectId: str
        :param _OwnerProjectName: 归属项目Name
        :type OwnerProjectName: str
        :param _OwnerProjectIdent: 归属项目Name中文
        :type OwnerProjectIdent: str
        :param _BizParams: 业务侧数据源的配置信息扩展
        :type BizParams: str
        :param _Params: 数据源的配置信息，以JSON KV存储，根据每个数据源类型不同，而KV存储信息不同
        :type Params: str
        :param _Description: 数据源描述信息
        :type Description: str
        :param _Display: 数据源展示名，为了可视化查看
        :type Display: str
        :param _DatabaseName: 若数据源列表为绑定数据库，则为db名称
        :type DatabaseName: str
        :param _Instance: 数据源引擎的实例ID，如CDB实例ID
        :type Instance: str
        :param _Status: 数据源数据源的可见性，1为可见、0为不可见。默认为1
        :type Status: int
        :param _ClusterId: 数据源所属的业务空间名称
        :type ClusterId: str
        :param _Collect: 是否采集
        :type Collect: str
        :param _COSBucket: cos桶信息
        :type COSBucket: str
        :param _COSRegion: cos region
        :type COSRegion: str
        :param _ConnectResult: 连接测试结果
        :type ConnectResult: str
        """
        self._Name = None
        self._Category = None
        self._Type = None
        self._OwnerProjectId = None
        self._OwnerProjectName = None
        self._OwnerProjectIdent = None
        self._BizParams = None
        self._Params = None
        self._Description = None
        self._Display = None
        self._DatabaseName = None
        self._Instance = None
        self._Status = None
        self._ClusterId = None
        self._Collect = None
        self._COSBucket = None
        self._COSRegion = None
        self._ConnectResult = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Category(self):
        return self._Category

    @Category.setter
    def Category(self, Category):
        self._Category = Category

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def OwnerProjectId(self):
        return self._OwnerProjectId

    @OwnerProjectId.setter
    def OwnerProjectId(self, OwnerProjectId):
        self._OwnerProjectId = OwnerProjectId

    @property
    def OwnerProjectName(self):
        return self._OwnerProjectName

    @OwnerProjectName.setter
    def OwnerProjectName(self, OwnerProjectName):
        self._OwnerProjectName = OwnerProjectName

    @property
    def OwnerProjectIdent(self):
        return self._OwnerProjectIdent

    @OwnerProjectIdent.setter
    def OwnerProjectIdent(self, OwnerProjectIdent):
        self._OwnerProjectIdent = OwnerProjectIdent

    @property
    def BizParams(self):
        return self._BizParams

    @BizParams.setter
    def BizParams(self, BizParams):
        self._BizParams = BizParams

    @property
    def Params(self):
        return self._Params

    @Params.setter
    def Params(self, Params):
        self._Params = Params

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Display(self):
        return self._Display

    @Display.setter
    def Display(self, Display):
        self._Display = Display

    @property
    def DatabaseName(self):
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def Instance(self):
        return self._Instance

    @Instance.setter
    def Instance(self, Instance):
        self._Instance = Instance

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Collect(self):
        return self._Collect

    @Collect.setter
    def Collect(self, Collect):
        self._Collect = Collect

    @property
    def COSBucket(self):
        return self._COSBucket

    @COSBucket.setter
    def COSBucket(self, COSBucket):
        self._COSBucket = COSBucket

    @property
    def COSRegion(self):
        return self._COSRegion

    @COSRegion.setter
    def COSRegion(self, COSRegion):
        self._COSRegion = COSRegion

    @property
    def ConnectResult(self):
        return self._ConnectResult

    @ConnectResult.setter
    def ConnectResult(self, ConnectResult):
        self._ConnectResult = ConnectResult


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Category = params.get("Category")
        self._Type = params.get("Type")
        self._OwnerProjectId = params.get("OwnerProjectId")
        self._OwnerProjectName = params.get("OwnerProjectName")
        self._OwnerProjectIdent = params.get("OwnerProjectIdent")
        self._BizParams = params.get("BizParams")
        self._Params = params.get("Params")
        self._Description = params.get("Description")
        self._Display = params.get("Display")
        self._DatabaseName = params.get("DatabaseName")
        self._Instance = params.get("Instance")
        self._Status = params.get("Status")
        self._ClusterId = params.get("ClusterId")
        self._Collect = params.get("Collect")
        self._COSBucket = params.get("COSBucket")
        self._COSRegion = params.get("COSRegion")
        self._ConnectResult = params.get("ConnectResult")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDataSourceResponse(AbstractModel):
    """CreateDataSource返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 主键ID
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CreateDsFolderRequest(AbstractModel):
    """CreateDsFolder请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _FolderName: 文件夹名称
        :type FolderName: str
        :param _ParentsFolderId: 父文件夹ID
        :type ParentsFolderId: str
        """
        self._ProjectId = None
        self._FolderName = None
        self._ParentsFolderId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def FolderName(self):
        return self._FolderName

    @FolderName.setter
    def FolderName(self, FolderName):
        self._FolderName = FolderName

    @property
    def ParentsFolderId(self):
        return self._ParentsFolderId

    @ParentsFolderId.setter
    def ParentsFolderId(self, ParentsFolderId):
        self._ParentsFolderId = ParentsFolderId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._FolderName = params.get("FolderName")
        self._ParentsFolderId = params.get("ParentsFolderId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDsFolderResponse(AbstractModel):
    """CreateDsFolder返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 文件夹Id，null则创建失败
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CreateFolderRequest(AbstractModel):
    """CreateFolder请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _FolderName: 文件夹名称
        :type FolderName: str
        :param _ParentsFolderId: 父文件夹ID
        :type ParentsFolderId: str
        """
        self._ProjectId = None
        self._FolderName = None
        self._ParentsFolderId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def FolderName(self):
        return self._FolderName

    @FolderName.setter
    def FolderName(self, FolderName):
        self._FolderName = FolderName

    @property
    def ParentsFolderId(self):
        return self._ParentsFolderId

    @ParentsFolderId.setter
    def ParentsFolderId(self, ParentsFolderId):
        self._ParentsFolderId = ParentsFolderId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._FolderName = params.get("FolderName")
        self._ParentsFolderId = params.get("ParentsFolderId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateFolderResponse(AbstractModel):
    """CreateFolder返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 文件夹Id，null则创建失败
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.CommonId`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = CommonId()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CreateHiveTableByDDLRequest(AbstractModel):
    """CreateHiveTableByDDL请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DatasourceId: 数据源ID
        :type DatasourceId: str
        :param _Database: 数据库
        :type Database: str
        :param _DDLSql: 建hive表ddl
        :type DDLSql: str
        :param _Privilege: 表权限 ，默认为0:项目共享;1:仅个人与管理员
        :type Privilege: int
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _Type: 目标表类型(HIVE或GBASE)
        :type Type: str
        :param _Incharge: 责任人
        :type Incharge: str
        """
        self._DatasourceId = None
        self._Database = None
        self._DDLSql = None
        self._Privilege = None
        self._ProjectId = None
        self._Type = None
        self._Incharge = None

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def Database(self):
        return self._Database

    @Database.setter
    def Database(self, Database):
        self._Database = Database

    @property
    def DDLSql(self):
        return self._DDLSql

    @DDLSql.setter
    def DDLSql(self, DDLSql):
        self._DDLSql = DDLSql

    @property
    def Privilege(self):
        return self._Privilege

    @Privilege.setter
    def Privilege(self, Privilege):
        self._Privilege = Privilege

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Incharge(self):
        return self._Incharge

    @Incharge.setter
    def Incharge(self, Incharge):
        self._Incharge = Incharge


    def _deserialize(self, params):
        self._DatasourceId = params.get("DatasourceId")
        self._Database = params.get("Database")
        self._DDLSql = params.get("DDLSql")
        self._Privilege = params.get("Privilege")
        self._ProjectId = params.get("ProjectId")
        self._Type = params.get("Type")
        self._Incharge = params.get("Incharge")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateHiveTableByDDLResponse(AbstractModel):
    """CreateHiveTableByDDL返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 表名称
        :type Data: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CreateHiveTableRequest(AbstractModel):
    """CreateHiveTable请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DatasourceId: 数据源id
        :type DatasourceId: str
        :param _Database: 数据库名称
        :type Database: str
        :param _DDLSql: base64转码之后的建表语句
        :type DDLSql: str
        :param _Privilege: 表权限 ，默认为0:项目共享;1:仅个人与管理员
        :type Privilege: int
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _Incharge: 责任人
        :type Incharge: str
        """
        self._DatasourceId = None
        self._Database = None
        self._DDLSql = None
        self._Privilege = None
        self._ProjectId = None
        self._Incharge = None

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def Database(self):
        return self._Database

    @Database.setter
    def Database(self, Database):
        self._Database = Database

    @property
    def DDLSql(self):
        return self._DDLSql

    @DDLSql.setter
    def DDLSql(self, DDLSql):
        self._DDLSql = DDLSql

    @property
    def Privilege(self):
        return self._Privilege

    @Privilege.setter
    def Privilege(self, Privilege):
        self._Privilege = Privilege

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Incharge(self):
        return self._Incharge

    @Incharge.setter
    def Incharge(self, Incharge):
        self._Incharge = Incharge


    def _deserialize(self, params):
        self._DatasourceId = params.get("DatasourceId")
        self._Database = params.get("Database")
        self._DDLSql = params.get("DDLSql")
        self._Privilege = params.get("Privilege")
        self._ProjectId = params.get("ProjectId")
        self._Incharge = params.get("Incharge")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateHiveTableResponse(AbstractModel):
    """CreateHiveTable返回参数结构体

    """

    def __init__(self):
        r"""
        :param _IsSuccess: 建表是否成功
        :type IsSuccess: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._IsSuccess = None
        self._RequestId = None

    @property
    def IsSuccess(self):
        return self._IsSuccess

    @IsSuccess.setter
    def IsSuccess(self, IsSuccess):
        self._IsSuccess = IsSuccess

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._IsSuccess = params.get("IsSuccess")
        self._RequestId = params.get("RequestId")


class CreateInLongAgentRequest(AbstractModel):
    """CreateInLongAgent请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AgentType: 采集器类型，1：TKE Agent，2：BOSS SDK，默认：1
        :type AgentType: int
        :param _AgentName: 采集器名称
        :type AgentName: str
        :param _ExecutorGroupId: 集成资源组id
        :type ExecutorGroupId: str
        :param _ProjectId: WeData项目ID
        :type ProjectId: str
        :param _TkeRegion: TKE集群的地域
        :type TkeRegion: str
        :param _ClusterId: 当AgentType为1时，必填。当AgentType为2时，不用填
        :type ClusterId: str
        """
        self._AgentType = None
        self._AgentName = None
        self._ExecutorGroupId = None
        self._ProjectId = None
        self._TkeRegion = None
        self._ClusterId = None

    @property
    def AgentType(self):
        return self._AgentType

    @AgentType.setter
    def AgentType(self, AgentType):
        self._AgentType = AgentType

    @property
    def AgentName(self):
        return self._AgentName

    @AgentName.setter
    def AgentName(self, AgentName):
        self._AgentName = AgentName

    @property
    def ExecutorGroupId(self):
        return self._ExecutorGroupId

    @ExecutorGroupId.setter
    def ExecutorGroupId(self, ExecutorGroupId):
        self._ExecutorGroupId = ExecutorGroupId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TkeRegion(self):
        return self._TkeRegion

    @TkeRegion.setter
    def TkeRegion(self, TkeRegion):
        self._TkeRegion = TkeRegion

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._AgentType = params.get("AgentType")
        self._AgentName = params.get("AgentName")
        self._ExecutorGroupId = params.get("ExecutorGroupId")
        self._ProjectId = params.get("ProjectId")
        self._TkeRegion = params.get("TkeRegion")
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateInLongAgentResponse(AbstractModel):
    """CreateInLongAgent返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AgentId: 采集器ID
        :type AgentId: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AgentId = None
        self._RequestId = None

    @property
    def AgentId(self):
        return self._AgentId

    @AgentId.setter
    def AgentId(self, AgentId):
        self._AgentId = AgentId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AgentId = params.get("AgentId")
        self._RequestId = params.get("RequestId")


class CreateIntegrationNodeRequest(AbstractModel):
    """CreateIntegrationNode请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NodeInfo: 集成节点信息
        :type NodeInfo: :class:`tencentcloud.wedata.v20210820.models.IntegrationNodeInfo`
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _TaskType: 任务类型，201为实时任务，202为离线任务
        :type TaskType: int
        """
        self._NodeInfo = None
        self._ProjectId = None
        self._TaskType = None

    @property
    def NodeInfo(self):
        return self._NodeInfo

    @NodeInfo.setter
    def NodeInfo(self, NodeInfo):
        self._NodeInfo = NodeInfo

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType


    def _deserialize(self, params):
        if params.get("NodeInfo") is not None:
            self._NodeInfo = IntegrationNodeInfo()
            self._NodeInfo._deserialize(params.get("NodeInfo"))
        self._ProjectId = params.get("ProjectId")
        self._TaskType = params.get("TaskType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateIntegrationNodeResponse(AbstractModel):
    """CreateIntegrationNode返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 节点
        :type Id: str
        :param _TaskId: 当前任务id
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Id = None
        self._TaskId = None
        self._RequestId = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class CreateIntegrationTaskRequest(AbstractModel):
    """CreateIntegrationTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskInfo: 任务信息
        :type TaskInfo: :class:`tencentcloud.wedata.v20210820.models.IntegrationTaskInfo`
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._TaskInfo = None
        self._ProjectId = None

    @property
    def TaskInfo(self):
        return self._TaskInfo

    @TaskInfo.setter
    def TaskInfo(self, TaskInfo):
        self._TaskInfo = TaskInfo

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        if params.get("TaskInfo") is not None:
            self._TaskInfo = IntegrationTaskInfo()
            self._TaskInfo._deserialize(params.get("TaskInfo"))
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateIntegrationTaskResponse(AbstractModel):
    """CreateIntegrationTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class CreateMakeDatetimeInfo(AbstractModel):
    """补录计划日期范围

    """

    def __init__(self):
        r"""
        :param _StartDate: 开始日期
注意：此字段可能返回 null，表示取不到有效值。
        :type StartDate: str
        :param _EndDate: 结束日期
注意：此字段可能返回 null，表示取不到有效值。
        :type EndDate: str
        :param _StartTime: 开始时间
注意：此字段可能返回 null，表示取不到有效值。
        :type StartTime: str
        :param _EndTime: 结束时间
注意：此字段可能返回 null，表示取不到有效值。
        :type EndTime: str
        """
        self._StartDate = None
        self._EndDate = None
        self._StartTime = None
        self._EndTime = None

    @property
    def StartDate(self):
        return self._StartDate

    @StartDate.setter
    def StartDate(self, StartDate):
        self._StartDate = StartDate

    @property
    def EndDate(self):
        return self._EndDate

    @EndDate.setter
    def EndDate(self, EndDate):
        self._EndDate = EndDate

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._StartDate = params.get("StartDate")
        self._EndDate = params.get("EndDate")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOfflineTaskRequest(AbstractModel):
    """CreateOfflineTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目/工作
        :type ProjectId: str
        :param _CycleStep: 1
        :type CycleStep: int
        :param _DelayTime: 0
        :type DelayTime: int
        :param _EndTime: 2099-12-31 00:00:00
        :type EndTime: str
        :param _Notes: 备注
        :type Notes: str
        :param _StartTime: 当前日期
        :type StartTime: str
        :param _TaskName: 任务名称
        :type TaskName: str
        :param _TypeId: 跟之前调用调度接口保持一致27
        :type TypeId: int
        :param _TaskAction: 默认 ""
        :type TaskAction: str
        :param _TaskMode: 区分画布和表单
        :type TaskMode: str
        """
        self._ProjectId = None
        self._CycleStep = None
        self._DelayTime = None
        self._EndTime = None
        self._Notes = None
        self._StartTime = None
        self._TaskName = None
        self._TypeId = None
        self._TaskAction = None
        self._TaskMode = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def CycleStep(self):
        return self._CycleStep

    @CycleStep.setter
    def CycleStep(self, CycleStep):
        self._CycleStep = CycleStep

    @property
    def DelayTime(self):
        return self._DelayTime

    @DelayTime.setter
    def DelayTime(self, DelayTime):
        self._DelayTime = DelayTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Notes(self):
        return self._Notes

    @Notes.setter
    def Notes(self, Notes):
        self._Notes = Notes

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def TaskName(self):
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def TypeId(self):
        return self._TypeId

    @TypeId.setter
    def TypeId(self, TypeId):
        self._TypeId = TypeId

    @property
    def TaskAction(self):
        return self._TaskAction

    @TaskAction.setter
    def TaskAction(self, TaskAction):
        self._TaskAction = TaskAction

    @property
    def TaskMode(self):
        return self._TaskMode

    @TaskMode.setter
    def TaskMode(self, TaskMode):
        self._TaskMode = TaskMode


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._CycleStep = params.get("CycleStep")
        self._DelayTime = params.get("DelayTime")
        self._EndTime = params.get("EndTime")
        self._Notes = params.get("Notes")
        self._StartTime = params.get("StartTime")
        self._TaskName = params.get("TaskName")
        self._TypeId = params.get("TypeId")
        self._TaskAction = params.get("TaskAction")
        self._TaskMode = params.get("TaskMode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOfflineTaskResponse(AbstractModel):
    """CreateOfflineTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskId: str
        :param _Data: 结果
        :type Data: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._Data = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CreateOpsMakePlanRequest(AbstractModel):
    """CreateOpsMakePlan请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _MakeName: 补录计划名称
        :type MakeName: str
        :param _TaskIdList: 补录任务集合
        :type TaskIdList: list of str
        :param _MakeDatetimeList: 补录计划日期范围
        :type MakeDatetimeList: list of CreateMakeDatetimeInfo
        :param _ProjectIdent: 项目标识
        :type ProjectIdent: str
        :param _CheckParent: 补录是否检查父任务状态，默认不检查。不推荐使用，后续会废弃，推荐使用 CheckParentType。
        :type CheckParent: bool
        :param _CheckParentType: 补录检查父任务类型。取值范围：
<li> NONE: 全部不检查 </li>
<li> ALL: 检查全部上游父任务 </li>
<li> MAKE_SCOPE: 只在（当前补录计划）选中任务中检查 </li>
        :type CheckParentType: str
        :param _ProjectName: 项目名称
        :type ProjectName: str
        :param _SelfDependence: 已弃用。任务自依赖类型：parallel（并行），serial（无序串行），orderly（有序串行）
        :type SelfDependence: str
        :param _ParallelNum: 并行度
        :type ParallelNum: int
        :param _SameCycle: 补录实例生成周期是否和原周期相同，默认为true
        :type SameCycle: bool
        :param _TargetTaskCycle: 补录实例目标周期类型
        :type TargetTaskCycle: str
        :param _TargetTaskAction: 补录实例目标周期类型指定时间
        :type TargetTaskAction: int
        :param _MapParamList: 补录实例自定义参数
        :type MapParamList: list of StrToStrMap
        :param _CreatorId: 创建人id
        :type CreatorId: str
        :param _Creator: 创建人
        :type Creator: str
        :param _Remark: 补录计划说明
        :type Remark: str
        :param _SameSelfDependType: 是否使用任务原有自依赖配置，默认为true
        :type SameSelfDependType: bool
        :param _SourceTaskCycle: 补录实例原始周期类型
        :type SourceTaskCycle: str
        :param _SchedulerResourceGroup: 重新指定的调度资源组ID
        :type SchedulerResourceGroup: str
        :param _IntegrationResourceGroup: 重新指定的集成资源组ID
        :type IntegrationResourceGroup: str
        :param _SchedulerResourceGroupName: 重新指定的调度资源组名称
        :type SchedulerResourceGroupName: str
        :param _IntegrationResourceGroupName: 重新指定的集成资源组名称
        :type IntegrationResourceGroupName: str
        """
        self._ProjectId = None
        self._MakeName = None
        self._TaskIdList = None
        self._MakeDatetimeList = None
        self._ProjectIdent = None
        self._CheckParent = None
        self._CheckParentType = None
        self._ProjectName = None
        self._SelfDependence = None
        self._ParallelNum = None
        self._SameCycle = None
        self._TargetTaskCycle = None
        self._TargetTaskAction = None
        self._MapParamList = None
        self._CreatorId = None
        self._Creator = None
        self._Remark = None
        self._SameSelfDependType = None
        self._SourceTaskCycle = None
        self._SchedulerResourceGroup = None
        self._IntegrationResourceGroup = None
        self._SchedulerResourceGroupName = None
        self._IntegrationResourceGroupName = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def MakeName(self):
        return self._MakeName

    @MakeName.setter
    def MakeName(self, MakeName):
        self._MakeName = MakeName

    @property
    def TaskIdList(self):
        return self._TaskIdList

    @TaskIdList.setter
    def TaskIdList(self, TaskIdList):
        self._TaskIdList = TaskIdList

    @property
    def MakeDatetimeList(self):
        return self._MakeDatetimeList

    @MakeDatetimeList.setter
    def MakeDatetimeList(self, MakeDatetimeList):
        self._MakeDatetimeList = MakeDatetimeList

    @property
    def ProjectIdent(self):
        return self._ProjectIdent

    @ProjectIdent.setter
    def ProjectIdent(self, ProjectIdent):
        self._ProjectIdent = ProjectIdent

    @property
    def CheckParent(self):
        return self._CheckParent

    @CheckParent.setter
    def CheckParent(self, CheckParent):
        self._CheckParent = CheckParent

    @property
    def CheckParentType(self):
        return self._CheckParentType

    @CheckParentType.setter
    def CheckParentType(self, CheckParentType):
        self._CheckParentType = CheckParentType

    @property
    def ProjectName(self):
        return self._ProjectName

    @ProjectName.setter
    def ProjectName(self, ProjectName):
        self._ProjectName = ProjectName

    @property
    def SelfDependence(self):
        return self._SelfDependence

    @SelfDependence.setter
    def SelfDependence(self, SelfDependence):
        self._SelfDependence = SelfDependence

    @property
    def ParallelNum(self):
        return self._ParallelNum

    @ParallelNum.setter
    def ParallelNum(self, ParallelNum):
        self._ParallelNum = ParallelNum

    @property
    def SameCycle(self):
        return self._SameCycle

    @SameCycle.setter
    def SameCycle(self, SameCycle):
        self._SameCycle = SameCycle

    @property
    def TargetTaskCycle(self):
        return self._TargetTaskCycle

    @TargetTaskCycle.setter
    def TargetTaskCycle(self, TargetTaskCycle):
        self._TargetTaskCycle = TargetTaskCycle

    @property
    def TargetTaskAction(self):
        return self._TargetTaskAction

    @TargetTaskAction.setter
    def TargetTaskAction(self, TargetTaskAction):
        self._TargetTaskAction = TargetTaskAction

    @property
    def MapParamList(self):
        return self._MapParamList

    @MapParamList.setter
    def MapParamList(self, MapParamList):
        self._MapParamList = MapParamList

    @property
    def CreatorId(self):
        return self._CreatorId

    @CreatorId.setter
    def CreatorId(self, CreatorId):
        self._CreatorId = CreatorId

    @property
    def Creator(self):
        return self._Creator

    @Creator.setter
    def Creator(self, Creator):
        self._Creator = Creator

    @property
    def Remark(self):
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def SameSelfDependType(self):
        return self._SameSelfDependType

    @SameSelfDependType.setter
    def SameSelfDependType(self, SameSelfDependType):
        self._SameSelfDependType = SameSelfDependType

    @property
    def SourceTaskCycle(self):
        return self._SourceTaskCycle

    @SourceTaskCycle.setter
    def SourceTaskCycle(self, SourceTaskCycle):
        self._SourceTaskCycle = SourceTaskCycle

    @property
    def SchedulerResourceGroup(self):
        return self._SchedulerResourceGroup

    @SchedulerResourceGroup.setter
    def SchedulerResourceGroup(self, SchedulerResourceGroup):
        self._SchedulerResourceGroup = SchedulerResourceGroup

    @property
    def IntegrationResourceGroup(self):
        return self._IntegrationResourceGroup

    @IntegrationResourceGroup.setter
    def IntegrationResourceGroup(self, IntegrationResourceGroup):
        self._IntegrationResourceGroup = IntegrationResourceGroup

    @property
    def SchedulerResourceGroupName(self):
        return self._SchedulerResourceGroupName

    @SchedulerResourceGroupName.setter
    def SchedulerResourceGroupName(self, SchedulerResourceGroupName):
        self._SchedulerResourceGroupName = SchedulerResourceGroupName

    @property
    def IntegrationResourceGroupName(self):
        return self._IntegrationResourceGroupName

    @IntegrationResourceGroupName.setter
    def IntegrationResourceGroupName(self, IntegrationResourceGroupName):
        self._IntegrationResourceGroupName = IntegrationResourceGroupName


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._MakeName = params.get("MakeName")
        self._TaskIdList = params.get("TaskIdList")
        if params.get("MakeDatetimeList") is not None:
            self._MakeDatetimeList = []
            for item in params.get("MakeDatetimeList"):
                obj = CreateMakeDatetimeInfo()
                obj._deserialize(item)
                self._MakeDatetimeList.append(obj)
        self._ProjectIdent = params.get("ProjectIdent")
        self._CheckParent = params.get("CheckParent")
        self._CheckParentType = params.get("CheckParentType")
        self._ProjectName = params.get("ProjectName")
        self._SelfDependence = params.get("SelfDependence")
        self._ParallelNum = params.get("ParallelNum")
        self._SameCycle = params.get("SameCycle")
        self._TargetTaskCycle = params.get("TargetTaskCycle")
        self._TargetTaskAction = params.get("TargetTaskAction")
        if params.get("MapParamList") is not None:
            self._MapParamList = []
            for item in params.get("MapParamList"):
                obj = StrToStrMap()
                obj._deserialize(item)
                self._MapParamList.append(obj)
        self._CreatorId = params.get("CreatorId")
        self._Creator = params.get("Creator")
        self._Remark = params.get("Remark")
        self._SameSelfDependType = params.get("SameSelfDependType")
        self._SourceTaskCycle = params.get("SourceTaskCycle")
        self._SchedulerResourceGroup = params.get("SchedulerResourceGroup")
        self._IntegrationResourceGroup = params.get("IntegrationResourceGroup")
        self._SchedulerResourceGroupName = params.get("SchedulerResourceGroupName")
        self._IntegrationResourceGroupName = params.get("IntegrationResourceGroupName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOpsMakePlanResponse(AbstractModel):
    """CreateOpsMakePlan返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 结果
        :type Data: :class:`tencentcloud.wedata.v20210820.models.CommonIdOpsDto`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = CommonIdOpsDto()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CreateOrUpdateResourceRequest(AbstractModel):
    """CreateOrUpdateResource请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID，必填项
        :type ProjectId: str
        :param _Files: 文件名，必填项
        :type Files: list of str
        :param _FilePath: 必填项，文件所属路径，资源管理根路径为 /datastudio/resource/项目ID/文件夹名
        :type FilePath: str
        :param _CosBucketName: cos存储桶名字
        :type CosBucketName: str
        :param _CosRegion: cos所属地域
        :type CosRegion: str
        :param _NewFile: 是否为新文件，新增为 true，更新为 false
        :type NewFile: bool
        :param _FilesSize: 必填项，文件大小，与 Files 字段对应
        :type FilesSize: list of str
        """
        self._ProjectId = None
        self._Files = None
        self._FilePath = None
        self._CosBucketName = None
        self._CosRegion = None
        self._NewFile = None
        self._FilesSize = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Files(self):
        return self._Files

    @Files.setter
    def Files(self, Files):
        self._Files = Files

    @property
    def FilePath(self):
        return self._FilePath

    @FilePath.setter
    def FilePath(self, FilePath):
        self._FilePath = FilePath

    @property
    def CosBucketName(self):
        return self._CosBucketName

    @CosBucketName.setter
    def CosBucketName(self, CosBucketName):
        self._CosBucketName = CosBucketName

    @property
    def CosRegion(self):
        return self._CosRegion

    @CosRegion.setter
    def CosRegion(self, CosRegion):
        self._CosRegion = CosRegion

    @property
    def NewFile(self):
        return self._NewFile

    @NewFile.setter
    def NewFile(self, NewFile):
        self._NewFile = NewFile

    @property
    def FilesSize(self):
        return self._FilesSize

    @FilesSize.setter
    def FilesSize(self, FilesSize):
        self._FilesSize = FilesSize


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._Files = params.get("Files")
        self._FilePath = params.get("FilePath")
        self._CosBucketName = params.get("CosBucketName")
        self._CosRegion = params.get("CosRegion")
        self._NewFile = params.get("NewFile")
        self._FilesSize = params.get("FilesSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOrUpdateResourceResponse(AbstractModel):
    """CreateOrUpdateResource返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 响应数据
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of UserFileDTO
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = UserFileDTO()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class CreateResourcePathRequest(AbstractModel):
    """CreateResourcePath请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 文件夹名称，如 aaa
        :type Name: str
        :param _FilePath: 文件夹所属父目录，请注意，根目录为 /datastudio/resource
        :type FilePath: str
        :param _ProjectId: 项目ID
        :type ProjectId: str
        """
        self._Name = None
        self._FilePath = None
        self._ProjectId = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def FilePath(self):
        return self._FilePath

    @FilePath.setter
    def FilePath(self, FilePath):
        self._FilePath = FilePath

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._FilePath = params.get("FilePath")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateResourcePathResponse(AbstractModel):
    """CreateResourcePath返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 新建成功
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CreateRuleRequest(AbstractModel):
    """CreateRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _RuleGroupId: 规则组Id
        :type RuleGroupId: int
        :param _Name: 规则名称
        :type Name: str
        :param _TableId: 数据表ID
        :type TableId: str
        :param _RuleTemplateId: 规则模板列表
        :type RuleTemplateId: int
        :param _Type: 规则类型 1.系统模版, 2.自定义模版, 3.自定义SQL
        :type Type: int
        :param _QualityDim: 规则所属质量维度（1：准确性，2：唯一性，3：完整性，4：一致性，5：及时性，6：有效性
        :type QualityDim: int
        :param _SourceObjectDataTypeName: 源字段详细类型，int、string
        :type SourceObjectDataTypeName: str
        :param _SourceObjectValue: 源字段名称
        :type SourceObjectValue: str
        :param _ConditionType: 检测范围 1.全表   2.条件扫描
        :type ConditionType: int
        :param _ConditionExpression: 条件扫描WHERE条件表达式
        :type ConditionExpression: str
        :param _CustomSql: 自定义SQL
        :type CustomSql: str
        :param _CompareRule: 报警触发条件
        :type CompareRule: :class:`tencentcloud.wedata.v20210820.models.CompareRule`
        :param _AlarmLevel: 报警触发级别 1.低, 2.中, 3.高
        :type AlarmLevel: int
        :param _Description: 规则描述
        :type Description: str
        :param _DatasourceId: 数据源Id
        :type DatasourceId: str
        :param _DatabaseId: 数据库Id
        :type DatabaseId: str
        :param _TargetDatabaseId: 目标库Id
        :type TargetDatabaseId: str
        :param _TargetTableId: 目标表Id
        :type TargetTableId: str
        :param _TargetConditionExpr: 目标过滤条件表达式
        :type TargetConditionExpr: str
        :param _RelConditionExpr: 源字段与目标字段关联条件on表达式
        :type RelConditionExpr: str
        :param _FieldConfig: 自定义模版sql表达式字段替换参数
        :type FieldConfig: :class:`tencentcloud.wedata.v20210820.models.RuleFieldConfig`
        :param _TargetObjectValue: 目标字段名称  CITY
        :type TargetObjectValue: str
        :param _SourceEngineTypes: 该规则支持的执行引擎列表
        :type SourceEngineTypes: list of int non-negative
        """
        self._ProjectId = None
        self._RuleGroupId = None
        self._Name = None
        self._TableId = None
        self._RuleTemplateId = None
        self._Type = None
        self._QualityDim = None
        self._SourceObjectDataTypeName = None
        self._SourceObjectValue = None
        self._ConditionType = None
        self._ConditionExpression = None
        self._CustomSql = None
        self._CompareRule = None
        self._AlarmLevel = None
        self._Description = None
        self._DatasourceId = None
        self._DatabaseId = None
        self._TargetDatabaseId = None
        self._TargetTableId = None
        self._TargetConditionExpr = None
        self._RelConditionExpr = None
        self._FieldConfig = None
        self._TargetObjectValue = None
        self._SourceEngineTypes = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def RuleGroupId(self):
        return self._RuleGroupId

    @RuleGroupId.setter
    def RuleGroupId(self, RuleGroupId):
        self._RuleGroupId = RuleGroupId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def TableId(self):
        return self._TableId

    @TableId.setter
    def TableId(self, TableId):
        self._TableId = TableId

    @property
    def RuleTemplateId(self):
        return self._RuleTemplateId

    @RuleTemplateId.setter
    def RuleTemplateId(self, RuleTemplateId):
        self._RuleTemplateId = RuleTemplateId

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def QualityDim(self):
        return self._QualityDim

    @QualityDim.setter
    def QualityDim(self, QualityDim):
        self._QualityDim = QualityDim

    @property
    def SourceObjectDataTypeName(self):
        return self._SourceObjectDataTypeName

    @SourceObjectDataTypeName.setter
    def SourceObjectDataTypeName(self, SourceObjectDataTypeName):
        self._SourceObjectDataTypeName = SourceObjectDataTypeName

    @property
    def SourceObjectValue(self):
        return self._SourceObjectValue

    @SourceObjectValue.setter
    def SourceObjectValue(self, SourceObjectValue):
        self._SourceObjectValue = SourceObjectValue

    @property
    def ConditionType(self):
        return self._ConditionType

    @ConditionType.setter
    def ConditionType(self, ConditionType):
        self._ConditionType = ConditionType

    @property
    def ConditionExpression(self):
        return self._ConditionExpression

    @ConditionExpression.setter
    def ConditionExpression(self, ConditionExpression):
        self._ConditionExpression = ConditionExpression

    @property
    def CustomSql(self):
        return self._CustomSql

    @CustomSql.setter
    def CustomSql(self, CustomSql):
        self._CustomSql = CustomSql

    @property
    def CompareRule(self):
        return self._CompareRule

    @CompareRule.setter
    def CompareRule(self, CompareRule):
        self._CompareRule = CompareRule

    @property
    def AlarmLevel(self):
        return self._AlarmLevel

    @AlarmLevel.setter
    def AlarmLevel(self, AlarmLevel):
        self._AlarmLevel = AlarmLevel

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def DatabaseId(self):
        return self._DatabaseId

    @DatabaseId.setter
    def DatabaseId(self, DatabaseId):
        self._DatabaseId = DatabaseId

    @property
    def TargetDatabaseId(self):
        return self._TargetDatabaseId

    @TargetDatabaseId.setter
    def TargetDatabaseId(self, TargetDatabaseId):
        self._TargetDatabaseId = TargetDatabaseId

    @property
    def TargetTableId(self):
        return self._TargetTableId

    @TargetTableId.setter
    def TargetTableId(self, TargetTableId):
        self._TargetTableId = TargetTableId

    @property
    def TargetConditionExpr(self):
        return self._TargetConditionExpr

    @TargetConditionExpr.setter
    def TargetConditionExpr(self, TargetConditionExpr):
        self._TargetConditionExpr = TargetConditionExpr

    @property
    def RelConditionExpr(self):
        return self._RelConditionExpr

    @RelConditionExpr.setter
    def RelConditionExpr(self, RelConditionExpr):
        self._RelConditionExpr = RelConditionExpr

    @property
    def FieldConfig(self):
        return self._FieldConfig

    @FieldConfig.setter
    def FieldConfig(self, FieldConfig):
        self._FieldConfig = FieldConfig

    @property
    def TargetObjectValue(self):
        return self._TargetObjectValue

    @TargetObjectValue.setter
    def TargetObjectValue(self, TargetObjectValue):
        self._TargetObjectValue = TargetObjectValue

    @property
    def SourceEngineTypes(self):
        return self._SourceEngineTypes

    @SourceEngineTypes.setter
    def SourceEngineTypes(self, SourceEngineTypes):
        self._SourceEngineTypes = SourceEngineTypes


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._RuleGroupId = params.get("RuleGroupId")
        self._Name = params.get("Name")
        self._TableId = params.get("TableId")
        self._RuleTemplateId = params.get("RuleTemplateId")
        self._Type = params.get("Type")
        self._QualityDim = params.get("QualityDim")
        self._SourceObjectDataTypeName = params.get("SourceObjectDataTypeName")
        self._SourceObjectValue = params.get("SourceObjectValue")
        self._ConditionType = params.get("ConditionType")
        self._ConditionExpression = params.get("ConditionExpression")
        self._CustomSql = params.get("CustomSql")
        if params.get("CompareRule") is not None:
            self._CompareRule = CompareRule()
            self._CompareRule._deserialize(params.get("CompareRule"))
        self._AlarmLevel = params.get("AlarmLevel")
        self._Description = params.get("Description")
        self._DatasourceId = params.get("DatasourceId")
        self._DatabaseId = params.get("DatabaseId")
        self._TargetDatabaseId = params.get("TargetDatabaseId")
        self._TargetTableId = params.get("TargetTableId")
        self._TargetConditionExpr = params.get("TargetConditionExpr")
        self._RelConditionExpr = params.get("RelConditionExpr")
        if params.get("FieldConfig") is not None:
            self._FieldConfig = RuleFieldConfig()
            self._FieldConfig._deserialize(params.get("FieldConfig"))
        self._TargetObjectValue = params.get("TargetObjectValue")
        self._SourceEngineTypes = params.get("SourceEngineTypes")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRuleResponse(AbstractModel):
    """CreateRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.Rule`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = Rule()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CreateRuleTemplateRequest(AbstractModel):
    """CreateRuleTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Type: 模版类型  1.系统模版   2.自定义模版
        :type Type: int
        :param _Name: 模版名称
        :type Name: str
        :param _QualityDim: 质量检测维度 1.准确性 2.唯一性 3.完整性 4.一致性 5.及时性 6.有效性
        :type QualityDim: int
        :param _SourceObjectType: 源端数据对象类型 1.常量  2.离线表级   2.离线字段级
        :type SourceObjectType: int
        :param _Description: 模板描述
        :type Description: str
        :param _SourceEngineTypes: 源端对应的引擎类型
        :type SourceEngineTypes: list of int non-negative
        :param _MultiSourceFlag: 是否关联其它库表
        :type MultiSourceFlag: bool
        :param _SqlExpression: SQL 表达式
        :type SqlExpression: str
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _WhereFlag: 是否添加where参数
        :type WhereFlag: bool
        """
        self._Type = None
        self._Name = None
        self._QualityDim = None
        self._SourceObjectType = None
        self._Description = None
        self._SourceEngineTypes = None
        self._MultiSourceFlag = None
        self._SqlExpression = None
        self._ProjectId = None
        self._WhereFlag = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def QualityDim(self):
        return self._QualityDim

    @QualityDim.setter
    def QualityDim(self, QualityDim):
        self._QualityDim = QualityDim

    @property
    def SourceObjectType(self):
        return self._SourceObjectType

    @SourceObjectType.setter
    def SourceObjectType(self, SourceObjectType):
        self._SourceObjectType = SourceObjectType

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def SourceEngineTypes(self):
        return self._SourceEngineTypes

    @SourceEngineTypes.setter
    def SourceEngineTypes(self, SourceEngineTypes):
        self._SourceEngineTypes = SourceEngineTypes

    @property
    def MultiSourceFlag(self):
        return self._MultiSourceFlag

    @MultiSourceFlag.setter
    def MultiSourceFlag(self, MultiSourceFlag):
        self._MultiSourceFlag = MultiSourceFlag

    @property
    def SqlExpression(self):
        return self._SqlExpression

    @SqlExpression.setter
    def SqlExpression(self, SqlExpression):
        self._SqlExpression = SqlExpression

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def WhereFlag(self):
        return self._WhereFlag

    @WhereFlag.setter
    def WhereFlag(self, WhereFlag):
        self._WhereFlag = WhereFlag


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        self._QualityDim = params.get("QualityDim")
        self._SourceObjectType = params.get("SourceObjectType")
        self._Description = params.get("Description")
        self._SourceEngineTypes = params.get("SourceEngineTypes")
        self._MultiSourceFlag = params.get("MultiSourceFlag")
        self._SqlExpression = params.get("SqlExpression")
        self._ProjectId = params.get("ProjectId")
        self._WhereFlag = params.get("WhereFlag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRuleTemplateResponse(AbstractModel):
    """CreateRuleTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 模板Id
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CreateTaskAlarmRegularRequest(AbstractModel):
    """CreateTaskAlarmRegular请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskAlarmInfo: 告警配置信息
        :type TaskAlarmInfo: :class:`tencentcloud.wedata.v20210820.models.TaskAlarmInfo`
        :param _ProjectId: 项目ID
        :type ProjectId: str
        """
        self._TaskAlarmInfo = None
        self._ProjectId = None

    @property
    def TaskAlarmInfo(self):
        return self._TaskAlarmInfo

    @TaskAlarmInfo.setter
    def TaskAlarmInfo(self, TaskAlarmInfo):
        self._TaskAlarmInfo = TaskAlarmInfo

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        if params.get("TaskAlarmInfo") is not None:
            self._TaskAlarmInfo = TaskAlarmInfo()
            self._TaskAlarmInfo._deserialize(params.get("TaskAlarmInfo"))
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateTaskAlarmRegularResponse(AbstractModel):
    """CreateTaskAlarmRegular返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AlarmId: 告警ID
        :type AlarmId: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AlarmId = None
        self._RequestId = None

    @property
    def AlarmId(self):
        return self._AlarmId

    @AlarmId.setter
    def AlarmId(self, AlarmId):
        self._AlarmId = AlarmId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AlarmId = params.get("AlarmId")
        self._RequestId = params.get("RequestId")


class CreateTaskRequest(AbstractModel):
    """CreateTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _WorkflowId: 工作流id
        :type WorkflowId: str
        :param _TaskName: 任务名
        :type TaskName: str
        :param _TaskType: 26离线同步，30Python，31PySpark，32DLC，33Impala，34Hive SQL，35Shell，36Spark SQL，39Spark，40CDW PG，92MapReduce
        :type TaskType: int
        :param _TaskExt: 扩展属性
        :type TaskExt: list of TaskExtInfo
        """
        self._ProjectId = None
        self._WorkflowId = None
        self._TaskName = None
        self._TaskType = None
        self._TaskExt = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId

    @property
    def TaskName(self):
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def TaskExt(self):
        return self._TaskExt

    @TaskExt.setter
    def TaskExt(self, TaskExt):
        self._TaskExt = TaskExt


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._WorkflowId = params.get("WorkflowId")
        self._TaskName = params.get("TaskName")
        self._TaskType = params.get("TaskType")
        if params.get("TaskExt") is not None:
            self._TaskExt = []
            for item in params.get("TaskExt"):
                obj = TaskExtInfo()
                obj._deserialize(item)
                self._TaskExt.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateTaskResponse(AbstractModel):
    """CreateTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 返回任务Id
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.CommonId`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = CommonId()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CreateTaskVersionDsRequest(AbstractModel):
    """CreateTaskVersionDs请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Task: 任务id
        :type Task: :class:`tencentcloud.wedata.v20210820.models.BatchCreateTaskVersionDTO`
        :param _NeedCheckParentSubmitted: 是否需要校验父任务已经提交到调度
        :type NeedCheckParentSubmitted: bool
        :param _AutoRun: 是否自动运行
        :type AutoRun: bool
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _RequestFromSource: 请求来源，WEB 前端；CLIENT 客户端
        :type RequestFromSource: str
        :param _AlarmWays: 告警方式:email-邮件;sms-短信;wecom-企业微信
        :type AlarmWays: str
        :param _AlarmRecipientTypes: 告警对象:1-项目管理员，2-任务责任人
        :type AlarmRecipientTypes: str
        """
        self._Task = None
        self._NeedCheckParentSubmitted = None
        self._AutoRun = None
        self._ProjectId = None
        self._RequestFromSource = None
        self._AlarmWays = None
        self._AlarmRecipientTypes = None

    @property
    def Task(self):
        return self._Task

    @Task.setter
    def Task(self, Task):
        self._Task = Task

    @property
    def NeedCheckParentSubmitted(self):
        return self._NeedCheckParentSubmitted

    @NeedCheckParentSubmitted.setter
    def NeedCheckParentSubmitted(self, NeedCheckParentSubmitted):
        self._NeedCheckParentSubmitted = NeedCheckParentSubmitted

    @property
    def AutoRun(self):
        return self._AutoRun

    @AutoRun.setter
    def AutoRun(self, AutoRun):
        self._AutoRun = AutoRun

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def RequestFromSource(self):
        return self._RequestFromSource

    @RequestFromSource.setter
    def RequestFromSource(self, RequestFromSource):
        self._RequestFromSource = RequestFromSource

    @property
    def AlarmWays(self):
        return self._AlarmWays

    @AlarmWays.setter
    def AlarmWays(self, AlarmWays):
        self._AlarmWays = AlarmWays

    @property
    def AlarmRecipientTypes(self):
        return self._AlarmRecipientTypes

    @AlarmRecipientTypes.setter
    def AlarmRecipientTypes(self, AlarmRecipientTypes):
        self._AlarmRecipientTypes = AlarmRecipientTypes


    def _deserialize(self, params):
        if params.get("Task") is not None:
            self._Task = BatchCreateTaskVersionDTO()
            self._Task._deserialize(params.get("Task"))
        self._NeedCheckParentSubmitted = params.get("NeedCheckParentSubmitted")
        self._AutoRun = params.get("AutoRun")
        self._ProjectId = params.get("ProjectId")
        self._RequestFromSource = params.get("RequestFromSource")
        self._AlarmWays = params.get("AlarmWays")
        self._AlarmRecipientTypes = params.get("AlarmRecipientTypes")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateTaskVersionDsResponse(AbstractModel):
    """CreateTaskVersionDs返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 1
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class CreateWorkflowRequest(AbstractModel):
    """CreateWorkflow请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _WorkflowName: 工作流名称
        :type WorkflowName: str
        :param _FolderId: 所属文件夹id
        :type FolderId: str
        """
        self._ProjectId = None
        self._WorkflowName = None
        self._FolderId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def WorkflowName(self):
        return self._WorkflowName

    @WorkflowName.setter
    def WorkflowName(self, WorkflowName):
        self._WorkflowName = WorkflowName

    @property
    def FolderId(self):
        return self._FolderId

    @FolderId.setter
    def FolderId(self, FolderId):
        self._FolderId = FolderId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._WorkflowName = params.get("WorkflowName")
        self._FolderId = params.get("FolderId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateWorkflowResponse(AbstractModel):
    """CreateWorkflow返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 返回工作流Id
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.CommonId`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = CommonId()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class CvmAgentStatus(AbstractModel):
    """采集器状态统计

    """

    def __init__(self):
        r"""
        :param _Status: agent状态
注意：此字段可能返回 null，表示取不到有效值。
        :type Status: str
        :param _Count: 对应状态的agent总数
注意：此字段可能返回 null，表示取不到有效值。
        :type Count: int
        """
        self._Status = None
        self._Count = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Count(self):
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._Count = params.get("Count")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DagInstancesRequest(AbstractModel):
    """DagInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Instances: 实例列表
        :type Instances: list of InstanceOpsDto
        :param _CheckFather: 检查父任务类型, true: 检查父任务; false: 不检查父任务 
        :type CheckFather: bool
        :param _RerunType: 重跑类型, 1: 自身; 3: 孩子; 2: 自身以及孩子 
        :type RerunType: str
        :param _DependentWay: 实例依赖方式, 1: 自依赖; 2: 任务依赖; 3: 自依赖及父子依赖 
        :type DependentWay: str
        :param _SkipEventListening: 重跑忽略事件监听与否 
        :type SkipEventListening: bool
        :param _SonInstanceType: 下游实例范围 1: 所在工作流 2: 所在项目 3: 所有跨工作流依赖的项目
        :type SonInstanceType: str
        :param _SearchCondition: 查询条件
        :type SearchCondition: :class:`tencentcloud.wedata.v20210820.models.InstanceApiOpsRequest`
        :param _OptType: 访问类型
        :type OptType: str
        :param _OperatorName: 操作者名称
        :type OperatorName: str
        :param _OperatorId: 操作者id
        :type OperatorId: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _ProjectIdent: 项目标志
        :type ProjectIdent: str
        :param _ProjectName: 项目名称
        :type ProjectName: str
        :param _PageIndex: 索引页码
        :type PageIndex: int
        :param _PageSize: 页面大小
        :type PageSize: int
        :param _Count: 数据总数
        :type Count: int
        :param _RequestBaseInfo: 基础请求信息
        :type RequestBaseInfo: :class:`tencentcloud.wedata.v20210820.models.ProjectBaseInfoOpsRequest`
        :param _IsCount: 是否计算总数
        :type IsCount: bool
        """
        self._Instances = None
        self._CheckFather = None
        self._RerunType = None
        self._DependentWay = None
        self._SkipEventListening = None
        self._SonInstanceType = None
        self._SearchCondition = None
        self._OptType = None
        self._OperatorName = None
        self._OperatorId = None
        self._ProjectId = None
        self._ProjectIdent = None
        self._ProjectName = None
        self._PageIndex = None
        self._PageSize = None
        self._Count = None
        self._RequestBaseInfo = None
        self._IsCount = None

    @property
    def Instances(self):
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances

    @property
    def CheckFather(self):
        return self._CheckFather

    @CheckFather.setter
    def CheckFather(self, CheckFather):
        self._CheckFather = CheckFather

    @property
    def RerunType(self):
        return self._RerunType

    @RerunType.setter
    def RerunType(self, RerunType):
        self._RerunType = RerunType

    @property
    def DependentWay(self):
        return self._DependentWay

    @DependentWay.setter
    def DependentWay(self, DependentWay):
        self._DependentWay = DependentWay

    @property
    def SkipEventListening(self):
        return self._SkipEventListening

    @SkipEventListening.setter
    def SkipEventListening(self, SkipEventListening):
        self._SkipEventListening = SkipEventListening

    @property
    def SonInstanceType(self):
        return self._SonInstanceType

    @SonInstanceType.setter
    def SonInstanceType(self, SonInstanceType):
        self._SonInstanceType = SonInstanceType

    @property
    def SearchCondition(self):
        return self._SearchCondition

    @SearchCondition.setter
    def SearchCondition(self, SearchCondition):
        self._SearchCondition = SearchCondition

    @property
    def OptType(self):
        return self._OptType

    @OptType.setter
    def OptType(self, OptType):
        self._OptType = OptType

    @property
    def OperatorName(self):
        return self._OperatorName

    @OperatorName.setter
    def OperatorName(self, OperatorName):
        self._OperatorName = OperatorName

    @property
    def OperatorId(self):
        return self._OperatorId

    @OperatorId.setter
    def OperatorId(self, OperatorId):
        self._OperatorId = OperatorId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ProjectIdent(self):
        return self._ProjectIdent

    @ProjectIdent.setter
    def ProjectIdent(self, ProjectIdent):
        self._ProjectIdent = ProjectIdent

    @property
    def ProjectName(self):
        return self._ProjectName

    @ProjectName.setter
    def ProjectName(self, ProjectName):
        self._ProjectName = ProjectName

    @property
    def PageIndex(self):
        return self._PageIndex

    @PageIndex.setter
    def PageIndex(self, PageIndex):
        self._PageIndex = PageIndex

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Count(self):
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def RequestBaseInfo(self):
        return self._RequestBaseInfo

    @RequestBaseInfo.setter
    def RequestBaseInfo(self, RequestBaseInfo):
        self._RequestBaseInfo = RequestBaseInfo

    @property
    def IsCount(self):
        return self._IsCount

    @IsCount.setter
    def IsCount(self, IsCount):
        self._IsCount = IsCount


    def _deserialize(self, params):
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = InstanceOpsDto()
                obj._deserialize(item)
                self._Instances.append(obj)
        self._CheckFather = params.get("CheckFather")
        self._RerunType = params.get("RerunType")
        self._DependentWay = params.get("DependentWay")
        self._SkipEventListening = params.get("SkipEventListening")
        self._SonInstanceType = params.get("SonInstanceType")
        if params.get("SearchCondition") is not None:
            self._SearchCondition = InstanceApiOpsRequest()
            self._SearchCondition._deserialize(params.get("SearchCondition"))
        self._OptType = params.get("OptType")
        self._OperatorName = params.get("OperatorName")
        self._OperatorId = params.get("OperatorId")
        self._ProjectId = params.get("ProjectId")
        self._ProjectIdent = params.get("ProjectIdent")
        self._ProjectName = params.get("ProjectName")
        self._PageIndex = params.get("PageIndex")
        self._PageSize = params.get("PageSize")
        self._Count = params.get("Count")
        if params.get("RequestBaseInfo") is not None:
            self._RequestBaseInfo = ProjectBaseInfoOpsRequest()
            self._RequestBaseInfo._deserialize(params.get("RequestBaseInfo"))
        self._IsCount = params.get("IsCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DagInstancesResponse(AbstractModel):
    """DagInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 结果
        :type Data: :class:`tencentcloud.wedata.v20210820.models.CollectionInstanceOpsDto`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = CollectionInstanceOpsDto()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DailyScoreInfo(AbstractModel):
    """日评分信息

    """

    def __init__(self):
        r"""
        :param _StatisticsDate: 统计日期 时间戳
注意：此字段可能返回 null，表示取不到有效值。
        :type StatisticsDate: int
        :param _Score: 评分
注意：此字段可能返回 null，表示取不到有效值。
        :type Score: float
        """
        self._StatisticsDate = None
        self._Score = None

    @property
    def StatisticsDate(self):
        return self._StatisticsDate

    @StatisticsDate.setter
    def StatisticsDate(self, StatisticsDate):
        self._StatisticsDate = StatisticsDate

    @property
    def Score(self):
        return self._Score

    @Score.setter
    def Score(self, Score):
        self._Score = Score


    def _deserialize(self, params):
        self._StatisticsDate = params.get("StatisticsDate")
        self._Score = params.get("Score")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataCheckStat(AbstractModel):
    """数据监测情况结果

    """

    def __init__(self):
        r"""
        :param _TableTotal: 表总数
        :type TableTotal: int
        :param _ColumnTotal: 字段总数
        :type ColumnTotal: int
        :param _TableConfig: 表配置检测数
        :type TableConfig: int
        :param _ColumnConfig: 字段配置检测数
        :type ColumnConfig: int
        :param _TableExec: 表实际检测数
        :type TableExec: int
        :param _ColumnExec: 字段实际检测数
        :type ColumnExec: int
        """
        self._TableTotal = None
        self._ColumnTotal = None
        self._TableConfig = None
        self._ColumnConfig = None
        self._TableExec = None
        self._ColumnExec = None

    @property
    def TableTotal(self):
        return self._TableTotal

    @TableTotal.setter
    def TableTotal(self, TableTotal):
        self._TableTotal = TableTotal

    @property
    def ColumnTotal(self):
        return self._ColumnTotal

    @ColumnTotal.setter
    def ColumnTotal(self, ColumnTotal):
        self._ColumnTotal = ColumnTotal

    @property
    def TableConfig(self):
        return self._TableConfig

    @TableConfig.setter
    def TableConfig(self, TableConfig):
        self._TableConfig = TableConfig

    @property
    def ColumnConfig(self):
        return self._ColumnConfig

    @ColumnConfig.setter
    def ColumnConfig(self, ColumnConfig):
        self._ColumnConfig = ColumnConfig

    @property
    def TableExec(self):
        return self._TableExec

    @TableExec.setter
    def TableExec(self, TableExec):
        self._TableExec = TableExec

    @property
    def ColumnExec(self):
        return self._ColumnExec

    @ColumnExec.setter
    def ColumnExec(self, ColumnExec):
        self._ColumnExec = ColumnExec


    def _deserialize(self, params):
        self._TableTotal = params.get("TableTotal")
        self._ColumnTotal = params.get("ColumnTotal")
        self._TableConfig = params.get("TableConfig")
        self._ColumnConfig = params.get("ColumnConfig")
        self._TableExec = params.get("TableExec")
        self._ColumnExec = params.get("ColumnExec")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataSourceInfo(AbstractModel):
    """数据源对象

    """

    def __init__(self):
        r"""
        :param _DatabaseName: 若数据源列表为绑定数据库，则为db名称
注意：此字段可能返回 null，表示取不到有效值。
        :type DatabaseName: str
        :param _Description: 数据源描述信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        :param _ID: 数据源ID
注意：此字段可能返回 null，表示取不到有效值。
        :type ID: int
        :param _Instance: 数据源引擎的实例ID，如CDB实例ID
注意：此字段可能返回 null，表示取不到有效值。
        :type Instance: str
        :param _Name: 数据源名称，在相同SpaceName下，数据源名称不能为空
注意：此字段可能返回 null，表示取不到有效值。
        :type Name: str
        :param _Region: 数据源引擎所属区域
注意：此字段可能返回 null，表示取不到有效值。
        :type Region: str
        :param _Type: 数据源类型:枚举值
注意：此字段可能返回 null，表示取不到有效值。
        :type Type: str
        :param _ClusterId: 数据源所属的集群id
注意：此字段可能返回 null，表示取不到有效值。
        :type ClusterId: str
        :param _AppId: 应用ID AppId
注意：此字段可能返回 null，表示取不到有效值。
        :type AppId: int
        :param _BizParams: 业务侧数据源的配置信息扩展
注意：此字段可能返回 null，表示取不到有效值。
        :type BizParams: str
        :param _Category: 数据源类别：绑定引擎、绑定数据库
注意：此字段可能返回 null，表示取不到有效值。
        :type Category: str
        :param _Display: 数据源展示名，为了可视化查看
注意：此字段可能返回 null，表示取不到有效值。
        :type Display: str
        :param _OwnerAccount: 数据源责任人账号ID
注意：此字段可能返回 null，表示取不到有效值。
        :type OwnerAccount: str
        :param _Params: 数据源的配置信息，以JSON KV存储，根据每个数据源类型不同，而KV存储信息不同
注意：此字段可能返回 null，表示取不到有效值。
        :type Params: str
        :param _Status: 数据源数据源的可见性，1为可见、0为不可见。默认为1
注意：此字段可能返回 null，表示取不到有效值。
        :type Status: int
        :param _OwnerAccountName: 数据源责任人账号名称
注意：此字段可能返回 null，表示取不到有效值。
        :type OwnerAccountName: str
        :param _ClusterName: 集群名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ClusterName: str
        :param _OwnerProjectId: 归属项目ID
注意：此字段可能返回 null，表示取不到有效值。
        :type OwnerProjectId: str
        :param _OwnerProjectName: 归属项目Name
注意：此字段可能返回 null，表示取不到有效值。
        :type OwnerProjectName: str
        :param _OwnerProjectIdent: 归属项目标识
注意：此字段可能返回 null，表示取不到有效值。
        :type OwnerProjectIdent: str
        :param _AuthorityProjectName: 授权项目
注意：此字段可能返回 null，表示取不到有效值。
        :type AuthorityProjectName: str
        :param _AuthorityUserName: 授权用户
注意：此字段可能返回 null，表示取不到有效值。
        :type AuthorityUserName: str
        :param _Edit: 是否有编辑权限
注意：此字段可能返回 null，表示取不到有效值。
        :type Edit: bool
        :param _Author: 是否有授权权限
注意：此字段可能返回 null，表示取不到有效值。
        :type Author: bool
        :param _Deliver: 是否有转交权限
注意：此字段可能返回 null，表示取不到有效值。
        :type Deliver: bool
        :param _DataSourceStatus: 数据源状态
注意：此字段可能返回 null，表示取不到有效值。
        :type DataSourceStatus: str
        :param _CreateTime: 时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateTime: int
        :param _ParamsString: Params json字符串
注意：此字段可能返回 null，表示取不到有效值。
        :type ParamsString: str
        :param _BizParamsString: BizParams json字符串
注意：此字段可能返回 null，表示取不到有效值。
        :type BizParamsString: str
        :param _ModifiedTime: 修改时间
注意：此字段可能返回 null，表示取不到有效值。
        :type ModifiedTime: int
        :param _ShowType: 数据源页面展示类型，与Type对应
注意：此字段可能返回 null，表示取不到有效值。
        :type ShowType: str
        """
        self._DatabaseName = None
        self._Description = None
        self._ID = None
        self._Instance = None
        self._Name = None
        self._Region = None
        self._Type = None
        self._ClusterId = None
        self._AppId = None
        self._BizParams = None
        self._Category = None
        self._Display = None
        self._OwnerAccount = None
        self._Params = None
        self._Status = None
        self._OwnerAccountName = None
        self._ClusterName = None
        self._OwnerProjectId = None
        self._OwnerProjectName = None
        self._OwnerProjectIdent = None
        self._AuthorityProjectName = None
        self._AuthorityUserName = None
        self._Edit = None
        self._Author = None
        self._Deliver = None
        self._DataSourceStatus = None
        self._CreateTime = None
        self._ParamsString = None
        self._BizParamsString = None
        self._ModifiedTime = None
        self._ShowType = None

    @property
    def DatabaseName(self):
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def ID(self):
        return self._ID

    @ID.setter
    def ID(self, ID):
        self._ID = ID

    @property
    def Instance(self):
        return self._Instance

    @Instance.setter
    def Instance(self, Instance):
        self._Instance = Instance

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def AppId(self):
        return self._AppId

    @AppId.setter
    def AppId(self, AppId):
        self._AppId = AppId

    @property
    def BizParams(self):
        return self._BizParams

    @BizParams.setter
    def BizParams(self, BizParams):
        self._BizParams = BizParams

    @property
    def Category(self):
        return self._Category

    @Category.setter
    def Category(self, Category):
        self._Category = Category

    @property
    def Display(self):
        return self._Display

    @Display.setter
    def Display(self, Display):
        self._Display = Display

    @property
    def OwnerAccount(self):
        return self._OwnerAccount

    @OwnerAccount.setter
    def OwnerAccount(self, OwnerAccount):
        self._OwnerAccount = OwnerAccount

    @property
    def Params(self):
        return self._Params

    @Params.setter
    def Params(self, Params):
        self._Params = Params

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def OwnerAccountName(self):
        return self._OwnerAccountName

    @OwnerAccountName.setter
    def OwnerAccountName(self, OwnerAccountName):
        self._OwnerAccountName = OwnerAccountName

    @property
    def ClusterName(self):
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def OwnerProjectId(self):
        return self._OwnerProjectId

    @OwnerProjectId.setter
    def OwnerProjectId(self, OwnerProjectId):
        self._OwnerProjectId = OwnerProjectId

    @property
    def OwnerProjectName(self):
        return self._OwnerProjectName

    @OwnerProjectName.setter
    def OwnerProjectName(self, OwnerProjectName):
        self._OwnerProjectName = OwnerProjectName

    @property
    def OwnerProjectIdent(self):
        return self._OwnerProjectIdent

    @OwnerProjectIdent.setter
    def OwnerProjectIdent(self, OwnerProjectIdent):
        self._OwnerProjectIdent = OwnerProjectIdent

    @property
    def AuthorityProjectName(self):
        return self._AuthorityProjectName

    @AuthorityProjectName.setter
    def AuthorityProjectName(self, AuthorityProjectName):
        self._AuthorityProjectName = AuthorityProjectName

    @property
    def AuthorityUserName(self):
        return self._AuthorityUserName

    @AuthorityUserName.setter
    def AuthorityUserName(self, AuthorityUserName):
        self._AuthorityUserName = AuthorityUserName

    @property
    def Edit(self):
        return self._Edit

    @Edit.setter
    def Edit(self, Edit):
        self._Edit = Edit

    @property
    def Author(self):
        return self._Author

    @Author.setter
    def Author(self, Author):
        self._Author = Author

    @property
    def Deliver(self):
        return self._Deliver

    @Deliver.setter
    def Deliver(self, Deliver):
        self._Deliver = Deliver

    @property
    def DataSourceStatus(self):
        return self._DataSourceStatus

    @DataSourceStatus.setter
    def DataSourceStatus(self, DataSourceStatus):
        self._DataSourceStatus = DataSourceStatus

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ParamsString(self):
        return self._ParamsString

    @ParamsString.setter
    def ParamsString(self, ParamsString):
        self._ParamsString = ParamsString

    @property
    def BizParamsString(self):
        return self._BizParamsString

    @BizParamsString.setter
    def BizParamsString(self, BizParamsString):
        self._BizParamsString = BizParamsString

    @property
    def ModifiedTime(self):
        return self._ModifiedTime

    @ModifiedTime.setter
    def ModifiedTime(self, ModifiedTime):
        self._ModifiedTime = ModifiedTime

    @property
    def ShowType(self):
        return self._ShowType

    @ShowType.setter
    def ShowType(self, ShowType):
        self._ShowType = ShowType


    def _deserialize(self, params):
        self._DatabaseName = params.get("DatabaseName")
        self._Description = params.get("Description")
        self._ID = params.get("ID")
        self._Instance = params.get("Instance")
        self._Name = params.get("Name")
        self._Region = params.get("Region")
        self._Type = params.get("Type")
        self._ClusterId = params.get("ClusterId")
        self._AppId = params.get("AppId")
        self._BizParams = params.get("BizParams")
        self._Category = params.get("Category")
        self._Display = params.get("Display")
        self._OwnerAccount = params.get("OwnerAccount")
        self._Params = params.get("Params")
        self._Status = params.get("Status")
        self._OwnerAccountName = params.get("OwnerAccountName")
        self._ClusterName = params.get("ClusterName")
        self._OwnerProjectId = params.get("OwnerProjectId")
        self._OwnerProjectName = params.get("OwnerProjectName")
        self._OwnerProjectIdent = params.get("OwnerProjectIdent")
        self._AuthorityProjectName = params.get("AuthorityProjectName")
        self._AuthorityUserName = params.get("AuthorityUserName")
        self._Edit = params.get("Edit")
        self._Author = params.get("Author")
        self._Deliver = params.get("Deliver")
        self._DataSourceStatus = params.get("DataSourceStatus")
        self._CreateTime = params.get("CreateTime")
        self._ParamsString = params.get("ParamsString")
        self._BizParamsString = params.get("BizParamsString")
        self._ModifiedTime = params.get("ModifiedTime")
        self._ShowType = params.get("ShowType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataSourceInfoPage(AbstractModel):
    """查询数据源分页列表

    """

    def __init__(self):
        r"""
        :param _PageNumber: 分页页码
注意：此字段可能返回 null，表示取不到有效值。
        :type PageNumber: int
        :param _PageSize: 分页大小
注意：此字段可能返回 null，表示取不到有效值。
        :type PageSize: int
        :param _Rows: 数据源列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Rows: list of DataSourceInfo
        :param _TotalCount: 总数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _TotalPageNumber: 总分页页码
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalPageNumber: int
        """
        self._PageNumber = None
        self._PageSize = None
        self._Rows = None
        self._TotalCount = None
        self._TotalPageNumber = None

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Rows(self):
        return self._Rows

    @Rows.setter
    def Rows(self, Rows):
        self._Rows = Rows

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TotalPageNumber(self):
        return self._TotalPageNumber

    @TotalPageNumber.setter
    def TotalPageNumber(self, TotalPageNumber):
        self._TotalPageNumber = TotalPageNumber


    def _deserialize(self, params):
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Rows") is not None:
            self._Rows = []
            for item in params.get("Rows"):
                obj = DataSourceInfo()
                obj._deserialize(item)
                self._Rows.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._TotalPageNumber = params.get("TotalPageNumber")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DatabaseInfo(AbstractModel):
    """数据质量数据来源数据库

    """

    def __init__(self):
        r"""
        :param _DatasourceName: 数据源名称
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasourceName: str
        :param _DatasourceId: 数据源Id
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasourceId: str
        :param _DatabaseName: 数据库名称
注意：此字段可能返回 null，表示取不到有效值。
        :type DatabaseName: str
        :param _DatabaseId: 数据库id
注意：此字段可能返回 null，表示取不到有效值。
        :type DatabaseId: str
        :param _InstanceId: 实例Id
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceId: str
        :param _DatasourceType: 数据源类型
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasourceType: int
        :param _OriginDatabaseName: 数据库原始名称
注意：此字段可能返回 null，表示取不到有效值。
        :type OriginDatabaseName: str
        :param _OriginSchemaName: schema名称
注意：此字段可能返回 null，表示取不到有效值。
        :type OriginSchemaName: str
        """
        self._DatasourceName = None
        self._DatasourceId = None
        self._DatabaseName = None
        self._DatabaseId = None
        self._InstanceId = None
        self._DatasourceType = None
        self._OriginDatabaseName = None
        self._OriginSchemaName = None

    @property
    def DatasourceName(self):
        return self._DatasourceName

    @DatasourceName.setter
    def DatasourceName(self, DatasourceName):
        self._DatasourceName = DatasourceName

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def DatabaseName(self):
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def DatabaseId(self):
        return self._DatabaseId

    @DatabaseId.setter
    def DatabaseId(self, DatabaseId):
        self._DatabaseId = DatabaseId

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def DatasourceType(self):
        return self._DatasourceType

    @DatasourceType.setter
    def DatasourceType(self, DatasourceType):
        self._DatasourceType = DatasourceType

    @property
    def OriginDatabaseName(self):
        return self._OriginDatabaseName

    @OriginDatabaseName.setter
    def OriginDatabaseName(self, OriginDatabaseName):
        self._OriginDatabaseName = OriginDatabaseName

    @property
    def OriginSchemaName(self):
        return self._OriginSchemaName

    @OriginSchemaName.setter
    def OriginSchemaName(self, OriginSchemaName):
        self._OriginSchemaName = OriginSchemaName


    def _deserialize(self, params):
        self._DatasourceName = params.get("DatasourceName")
        self._DatasourceId = params.get("DatasourceId")
        self._DatabaseName = params.get("DatabaseName")
        self._DatabaseId = params.get("DatabaseId")
        self._InstanceId = params.get("InstanceId")
        self._DatasourceType = params.get("DatasourceType")
        self._OriginDatabaseName = params.get("OriginDatabaseName")
        self._OriginSchemaName = params.get("OriginSchemaName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DatabaseMeta(AbstractModel):
    """数据源元数据

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
注意：此字段可能返回 null，表示取不到有效值。
        :type ProjectId: str
        :param _MetastoreType: 技术类型
注意：此字段可能返回 null，表示取不到有效值。
        :type MetastoreType: str
        :param _DatasourceName: 数据源名称
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasourceName: str
        :param _DatasourceId: 数据源Id
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasourceId: int
        :param _ProjectName: 项目英文名
注意：此字段可能返回 null，表示取不到有效值。
        :type ProjectName: str
        :param _Category: 数据源类别：绑定引擎、绑定数据库,可用值:DB,ENGINE
注意：此字段可能返回 null，表示取不到有效值。
        :type Category: str
        :param _Description: 数据源描述信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        :param _Instance: 数据源引擎的实例ID，如CDB实例ID
注意：此字段可能返回 null，表示取不到有效值。
        :type Instance: str
        :param _Region: 数据源引擎所属区域
注意：此字段可能返回 null，表示取不到有效值。
        :type Region: str
        :param _Status: 数据源数据源的可见性，1为可见、0为不可见。默认为1
注意：此字段可能返回 null，表示取不到有效值。
        :type Status: int
        :param _DatabaseName: db名称
注意：此字段可能返回 null，表示取不到有效值。
        :type DatabaseName: str
        :param _ProjectDisplayName: 项目中文名
注意：此字段可能返回 null，表示取不到有效值。
        :type ProjectDisplayName: str
        :param _OwnerAccountName: 责任人名称
注意：此字段可能返回 null，表示取不到有效值。
        :type OwnerAccountName: str
        :param _DisplayName: 数据来源展示名称
注意：此字段可能返回 null，表示取不到有效值。
        :type DisplayName: str
        :param _DatabaseId: 数据库ID
注意：此字段可能返回 null，表示取不到有效值。
        :type DatabaseId: str
        :param _Catalog: 数据来源类型：hive/mysql/hbase等
注意：此字段可能返回 null，表示取不到有效值。
        :type Catalog: str
        :param _StorageSize: 存储量大小,单位为 byte
注意：此字段可能返回 null，表示取不到有效值。
        :type StorageSize: int
        :param _StorageSizeWithUnit: 格式化后的存储量大小，带单位，如 12B
注意：此字段可能返回 null，表示取不到有效值。
        :type StorageSizeWithUnit: str
        :param _CreateTime: 创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateTime: str
        """
        self._ProjectId = None
        self._MetastoreType = None
        self._DatasourceName = None
        self._DatasourceId = None
        self._ProjectName = None
        self._Category = None
        self._Description = None
        self._Instance = None
        self._Region = None
        self._Status = None
        self._DatabaseName = None
        self._ProjectDisplayName = None
        self._OwnerAccountName = None
        self._DisplayName = None
        self._DatabaseId = None
        self._Catalog = None
        self._StorageSize = None
        self._StorageSizeWithUnit = None
        self._CreateTime = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def MetastoreType(self):
        return self._MetastoreType

    @MetastoreType.setter
    def MetastoreType(self, MetastoreType):
        self._MetastoreType = MetastoreType

    @property
    def DatasourceName(self):
        return self._DatasourceName

    @DatasourceName.setter
    def DatasourceName(self, DatasourceName):
        self._DatasourceName = DatasourceName

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def ProjectName(self):
        return self._ProjectName

    @ProjectName.setter
    def ProjectName(self, ProjectName):
        self._ProjectName = ProjectName

    @property
    def Category(self):
        return self._Category

    @Category.setter
    def Category(self, Category):
        self._Category = Category

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Instance(self):
        return self._Instance

    @Instance.setter
    def Instance(self, Instance):
        self._Instance = Instance

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def DatabaseName(self):
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def ProjectDisplayName(self):
        return self._ProjectDisplayName

    @ProjectDisplayName.setter
    def ProjectDisplayName(self, ProjectDisplayName):
        self._ProjectDisplayName = ProjectDisplayName

    @property
    def OwnerAccountName(self):
        return self._OwnerAccountName

    @OwnerAccountName.setter
    def OwnerAccountName(self, OwnerAccountName):
        self._OwnerAccountName = OwnerAccountName

    @property
    def DisplayName(self):
        return self._DisplayName

    @DisplayName.setter
    def DisplayName(self, DisplayName):
        self._DisplayName = DisplayName

    @property
    def DatabaseId(self):
        return self._DatabaseId

    @DatabaseId.setter
    def DatabaseId(self, DatabaseId):
        self._DatabaseId = DatabaseId

    @property
    def Catalog(self):
        return self._Catalog

    @Catalog.setter
    def Catalog(self, Catalog):
        self._Catalog = Catalog

    @property
    def StorageSize(self):
        return self._StorageSize

    @StorageSize.setter
    def StorageSize(self, StorageSize):
        self._StorageSize = StorageSize

    @property
    def StorageSizeWithUnit(self):
        return self._StorageSizeWithUnit

    @StorageSizeWithUnit.setter
    def StorageSizeWithUnit(self, StorageSizeWithUnit):
        self._StorageSizeWithUnit = StorageSizeWithUnit

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._MetastoreType = params.get("MetastoreType")
        self._DatasourceName = params.get("DatasourceName")
        self._DatasourceId = params.get("DatasourceId")
        self._ProjectName = params.get("ProjectName")
        self._Category = params.get("Category")
        self._Description = params.get("Description")
        self._Instance = params.get("Instance")
        self._Region = params.get("Region")
        self._Status = params.get("Status")
        self._DatabaseName = params.get("DatabaseName")
        self._ProjectDisplayName = params.get("ProjectDisplayName")
        self._OwnerAccountName = params.get("OwnerAccountName")
        self._DisplayName = params.get("DisplayName")
        self._DatabaseId = params.get("DatabaseId")
        self._Catalog = params.get("Catalog")
        self._StorageSize = params.get("StorageSize")
        self._StorageSizeWithUnit = params.get("StorageSizeWithUnit")
        self._CreateTime = params.get("CreateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DatasourceBaseInfo(AbstractModel):
    """数据源对象

    """

    def __init__(self):
        r"""
        :param _DatabaseNames: 若数据源列表为绑定数据库，则为db名称
注意：此字段可能返回 null，表示取不到有效值。
        :type DatabaseNames: list of str
        :param _Description: 数据源描述信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        :param _ID: 数据源ID
        :type ID: int
        :param _Instance: 数据源引擎的实例ID，如CDB实例ID
注意：此字段可能返回 null，表示取不到有效值。
        :type Instance: str
        :param _Name: 数据源名称，在相同SpaceName下，数据源名称不能为空
        :type Name: str
        :param _Region: 数据源引擎所属区域
注意：此字段可能返回 null，表示取不到有效值。
        :type Region: str
        :param _Type: 数据源类型:枚举值
注意：此字段可能返回 null，表示取不到有效值。
        :type Type: str
        :param _ClusterId: 数据源所属的集群id
注意：此字段可能返回 null，表示取不到有效值。
        :type ClusterId: str
        :param _Version: 数据源版本信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Version: str
        """
        self._DatabaseNames = None
        self._Description = None
        self._ID = None
        self._Instance = None
        self._Name = None
        self._Region = None
        self._Type = None
        self._ClusterId = None
        self._Version = None

    @property
    def DatabaseNames(self):
        return self._DatabaseNames

    @DatabaseNames.setter
    def DatabaseNames(self, DatabaseNames):
        self._DatabaseNames = DatabaseNames

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def ID(self):
        return self._ID

    @ID.setter
    def ID(self, ID):
        self._ID = ID

    @property
    def Instance(self):
        return self._Instance

    @Instance.setter
    def Instance(self, Instance):
        self._Instance = Instance

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Version(self):
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version


    def _deserialize(self, params):
        self._DatabaseNames = params.get("DatabaseNames")
        self._Description = params.get("Description")
        self._ID = params.get("ID")
        self._Instance = params.get("Instance")
        self._Name = params.get("Name")
        self._Region = params.get("Region")
        self._Type = params.get("Type")
        self._ClusterId = params.get("ClusterId")
        self._Version = params.get("Version")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DatasourceTypeByTaskType(AbstractModel):
    """任务运维数据源类型信息

    """

    def __init__(self):
        r"""
        :param _TypeId: 类型id
注意：此字段可能返回 null，表示取不到有效值。
        :type TypeId: int
        :param _CandidateTexts: 可选数据源列表文本
注意：此字段可能返回 null，表示取不到有效值。
        :type CandidateTexts: str
        :param _CandidateValues: 可选数据源列表取值
注意：此字段可能返回 null，表示取不到有效值。
        :type CandidateValues: str
        """
        self._TypeId = None
        self._CandidateTexts = None
        self._CandidateValues = None

    @property
    def TypeId(self):
        return self._TypeId

    @TypeId.setter
    def TypeId(self, TypeId):
        self._TypeId = TypeId

    @property
    def CandidateTexts(self):
        return self._CandidateTexts

    @CandidateTexts.setter
    def CandidateTexts(self, CandidateTexts):
        self._CandidateTexts = CandidateTexts

    @property
    def CandidateValues(self):
        return self._CandidateValues

    @CandidateValues.setter
    def CandidateValues(self, CandidateValues):
        self._CandidateValues = CandidateValues


    def _deserialize(self, params):
        self._TypeId = params.get("TypeId")
        self._CandidateTexts = params.get("CandidateTexts")
        self._CandidateValues = params.get("CandidateValues")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteBaselineRequest(AbstractModel):
    """DeleteBaseline请求参数结构体

    """

    def __init__(self):
        r"""
        :param _BaselineId: 基线id
        :type BaselineId: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._BaselineId = None
        self._ProjectId = None

    @property
    def BaselineId(self):
        return self._BaselineId

    @BaselineId.setter
    def BaselineId(self, BaselineId):
        self._BaselineId = BaselineId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._BaselineId = params.get("BaselineId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteBaselineResponse(AbstractModel):
    """DeleteBaseline返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 无
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.BooleanResponse`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BooleanResponse()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DeleteCustomFunctionRequest(AbstractModel):
    """DeleteCustomFunction请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterIdentifier: 集群实例 ID
        :type ClusterIdentifier: str
        :param _FunctionId: 函数 ID
        :type FunctionId: str
        :param _ProjectId: 项目ID，必须填
        :type ProjectId: str
        :param _FunctionName: 函数名称
        :type FunctionName: str
        :param _FunctionType: 函数类型，HIVE，SPARK，DLC，CDW_POSTGRESQL
        :type FunctionType: str
        :param _DatabaseName: 数据库名
        :type DatabaseName: str
        :param _SchemaName: 模式名
        :type SchemaName: str
        :param _CommandFormat: 函数命令格式
        :type CommandFormat: str
        """
        self._ClusterIdentifier = None
        self._FunctionId = None
        self._ProjectId = None
        self._FunctionName = None
        self._FunctionType = None
        self._DatabaseName = None
        self._SchemaName = None
        self._CommandFormat = None

    @property
    def ClusterIdentifier(self):
        return self._ClusterIdentifier

    @ClusterIdentifier.setter
    def ClusterIdentifier(self, ClusterIdentifier):
        self._ClusterIdentifier = ClusterIdentifier

    @property
    def FunctionId(self):
        return self._FunctionId

    @FunctionId.setter
    def FunctionId(self, FunctionId):
        self._FunctionId = FunctionId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def FunctionName(self):
        return self._FunctionName

    @FunctionName.setter
    def FunctionName(self, FunctionName):
        self._FunctionName = FunctionName

    @property
    def FunctionType(self):
        return self._FunctionType

    @FunctionType.setter
    def FunctionType(self, FunctionType):
        self._FunctionType = FunctionType

    @property
    def DatabaseName(self):
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def SchemaName(self):
        return self._SchemaName

    @SchemaName.setter
    def SchemaName(self, SchemaName):
        self._SchemaName = SchemaName

    @property
    def CommandFormat(self):
        return self._CommandFormat

    @CommandFormat.setter
    def CommandFormat(self, CommandFormat):
        self._CommandFormat = CommandFormat


    def _deserialize(self, params):
        self._ClusterIdentifier = params.get("ClusterIdentifier")
        self._FunctionId = params.get("FunctionId")
        self._ProjectId = params.get("ProjectId")
        self._FunctionName = params.get("FunctionName")
        self._FunctionType = params.get("FunctionType")
        self._DatabaseName = params.get("DatabaseName")
        self._SchemaName = params.get("SchemaName")
        self._CommandFormat = params.get("CommandFormat")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCustomFunctionResponse(AbstractModel):
    """DeleteCustomFunction返回参数结构体

    """

    def __init__(self):
        r"""
        :param _FunctionId: 函数 ID
注意：此字段可能返回 null，表示取不到有效值。
        :type FunctionId: str
        :param _ErrorMessage: 无
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrorMessage: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._FunctionId = None
        self._ErrorMessage = None
        self._RequestId = None

    @property
    def FunctionId(self):
        return self._FunctionId

    @FunctionId.setter
    def FunctionId(self, FunctionId):
        self._FunctionId = FunctionId

    @property
    def ErrorMessage(self):
        return self._ErrorMessage

    @ErrorMessage.setter
    def ErrorMessage(self, ErrorMessage):
        self._ErrorMessage = ErrorMessage

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FunctionId = params.get("FunctionId")
        self._ErrorMessage = params.get("ErrorMessage")
        self._RequestId = params.get("RequestId")


class DeleteDataSourcesRequest(AbstractModel):
    """DeleteDataSources请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Ids: id列表
        :type Ids: list of int non-negative
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._Ids = None
        self._ProjectId = None

    @property
    def Ids(self):
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._Ids = params.get("Ids")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteDataSourcesResponse(AbstractModel):
    """DeleteDataSources返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 是否删除成功
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteDsFolderRequest(AbstractModel):
    """DeleteDsFolder请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _FolderId: 文件夹ID
        :type FolderId: str
        """
        self._ProjectId = None
        self._FolderId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def FolderId(self):
        return self._FolderId

    @FolderId.setter
    def FolderId(self, FolderId):
        self._FolderId = FolderId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._FolderId = params.get("FolderId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteDsFolderResponse(AbstractModel):
    """DeleteDsFolder返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: true代表删除成功，false代表删除失败
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteFilePathRequest(AbstractModel):
    """DeleteFilePath请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _ResourceIds: 资源ID
        :type ResourceIds: list of str
        :param _UseStatus: 使用状态
        :type UseStatus: str
        :param _FilePaths: 文件路径
        :type FilePaths: list of str
        """
        self._ProjectId = None
        self._ResourceIds = None
        self._UseStatus = None
        self._FilePaths = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ResourceIds(self):
        return self._ResourceIds

    @ResourceIds.setter
    def ResourceIds(self, ResourceIds):
        self._ResourceIds = ResourceIds

    @property
    def UseStatus(self):
        return self._UseStatus

    @UseStatus.setter
    def UseStatus(self, UseStatus):
        self._UseStatus = UseStatus

    @property
    def FilePaths(self):
        return self._FilePaths

    @FilePaths.setter
    def FilePaths(self, FilePaths):
        self._FilePaths = FilePaths


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._ResourceIds = params.get("ResourceIds")
        self._UseStatus = params.get("UseStatus")
        self._FilePaths = params.get("FilePaths")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteFilePathResponse(AbstractModel):
    """DeleteFilePath返回参数结构体

    """

    def __init__(self):
        r"""
        :param _UserFileList: 文件列表
注意：此字段可能返回 null，表示取不到有效值。
        :type UserFileList: list of UserFileInfo
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._UserFileList = None
        self._RequestId = None

    @property
    def UserFileList(self):
        return self._UserFileList

    @UserFileList.setter
    def UserFileList(self, UserFileList):
        self._UserFileList = UserFileList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("UserFileList") is not None:
            self._UserFileList = []
            for item in params.get("UserFileList"):
                obj = UserFileInfo()
                obj._deserialize(item)
                self._UserFileList.append(obj)
        self._RequestId = params.get("RequestId")


class DeleteFileRequest(AbstractModel):
    """DeleteFile请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _ResourceId: 资源id
        :type ResourceId: str
        """
        self._ProjectId = None
        self._ResourceId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ResourceId(self):
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._ResourceId = params.get("ResourceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteFileResponse(AbstractModel):
    """DeleteFile返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 删除结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class DeleteFolderRequest(AbstractModel):
    """DeleteFolder请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _FolderId: 文件夹ID
        :type FolderId: str
        """
        self._ProjectId = None
        self._FolderId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def FolderId(self):
        return self._FolderId

    @FolderId.setter
    def FolderId(self, FolderId):
        self._FolderId = FolderId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._FolderId = params.get("FolderId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteFolderResponse(AbstractModel):
    """DeleteFolder返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: true代表删除成功，false代表删除失败
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteInLongAgentRequest(AbstractModel):
    """DeleteInLongAgent请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AgentId: 采集器ID
        :type AgentId: str
        :param _ProjectId: WeData项目ID
        :type ProjectId: str
        """
        self._AgentId = None
        self._ProjectId = None

    @property
    def AgentId(self):
        return self._AgentId

    @AgentId.setter
    def AgentId(self, AgentId):
        self._AgentId = AgentId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._AgentId = params.get("AgentId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteInLongAgentResponse(AbstractModel):
    """DeleteInLongAgent返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteIntegrationNodeRequest(AbstractModel):
    """DeleteIntegrationNode请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 节点id
        :type Id: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._Id = None
        self._ProjectId = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteIntegrationNodeResponse(AbstractModel):
    """DeleteIntegrationNode返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 删除返回是否成功标识
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteIntegrationTaskRequest(AbstractModel):
    """DeleteIntegrationTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._TaskId = None
        self._ProjectId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteIntegrationTaskResponse(AbstractModel):
    """DeleteIntegrationTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 任务删除成功与否标识
        :type Data: bool
        :param _DeleteFlag: 任务删除成功与否标识
0表示删除成功
1 表示失败，失败原因见 DeleteErrInfo
100 表示running or suspend task can't be deleted失败，失败原因也会写到DeleteErrInfo里面
注意：此字段可能返回 null，表示取不到有效值。
        :type DeleteFlag: int
        :param _DeleteErrInfo: 删除失败原因
注意：此字段可能返回 null，表示取不到有效值。
        :type DeleteErrInfo: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._DeleteFlag = None
        self._DeleteErrInfo = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def DeleteFlag(self):
        return self._DeleteFlag

    @DeleteFlag.setter
    def DeleteFlag(self, DeleteFlag):
        self._DeleteFlag = DeleteFlag

    @property
    def DeleteErrInfo(self):
        return self._DeleteErrInfo

    @DeleteErrInfo.setter
    def DeleteErrInfo(self, DeleteErrInfo):
        self._DeleteErrInfo = DeleteErrInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._DeleteFlag = params.get("DeleteFlag")
        self._DeleteErrInfo = params.get("DeleteErrInfo")
        self._RequestId = params.get("RequestId")


class DeleteOfflineTaskRequest(AbstractModel):
    """DeleteOfflineTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _OperatorName: 操作者name
        :type OperatorName: str
        :param _ProjectId: 项目/工作空间id
        :type ProjectId: str
        :param _TaskId: 任务id
        :type TaskId: str
        :param _VirtualFlag: 虚拟任务标记(跟之前调度接口保持一致默认false)
        :type VirtualFlag: bool
        """
        self._OperatorName = None
        self._ProjectId = None
        self._TaskId = None
        self._VirtualFlag = None

    @property
    def OperatorName(self):
        return self._OperatorName

    @OperatorName.setter
    def OperatorName(self, OperatorName):
        self._OperatorName = OperatorName

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def VirtualFlag(self):
        return self._VirtualFlag

    @VirtualFlag.setter
    def VirtualFlag(self, VirtualFlag):
        self._VirtualFlag = VirtualFlag


    def _deserialize(self, params):
        self._OperatorName = params.get("OperatorName")
        self._ProjectId = params.get("ProjectId")
        self._TaskId = params.get("TaskId")
        self._VirtualFlag = params.get("VirtualFlag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteOfflineTaskResponse(AbstractModel):
    """DeleteOfflineTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 结果
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteProjectParamDsRequest(AbstractModel):
    """DeleteProjectParamDs请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ParamKey: 参数名
        :type ParamKey: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._ParamKey = None
        self._ProjectId = None

    @property
    def ParamKey(self):
        return self._ParamKey

    @ParamKey.setter
    def ParamKey(self, ParamKey):
        self._ParamKey = ParamKey

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._ParamKey = params.get("ParamKey")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteProjectParamDsResponse(AbstractModel):
    """DeleteProjectParamDs返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 结果 true 删除成功
false 删除失败
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteProjectUsersRequest(AbstractModel):
    """DeleteProjectUsers请求参数结构体

    """


class DeleteProjectUsersResponse(AbstractModel):
    """DeleteProjectUsers返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteResourceFileRequest(AbstractModel):
    """DeleteResourceFile请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _ResourceId: 资源id
        :type ResourceId: str
        """
        self._ProjectId = None
        self._ResourceId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ResourceId(self):
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._ResourceId = params.get("ResourceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteResourceFileResponse(AbstractModel):
    """DeleteResourceFile返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 资源删除结果
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteResourceFilesRequest(AbstractModel):
    """DeleteResourceFiles请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _UseStatus: 使用状态
        :type UseStatus: bool
        :param _ResourceIds: 资源id列表
        :type ResourceIds: list of str
        :param _FilePaths: 资源路径列表
        :type FilePaths: list of str
        """
        self._ProjectId = None
        self._UseStatus = None
        self._ResourceIds = None
        self._FilePaths = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def UseStatus(self):
        return self._UseStatus

    @UseStatus.setter
    def UseStatus(self, UseStatus):
        self._UseStatus = UseStatus

    @property
    def ResourceIds(self):
        return self._ResourceIds

    @ResourceIds.setter
    def ResourceIds(self, ResourceIds):
        self._ResourceIds = ResourceIds

    @property
    def FilePaths(self):
        return self._FilePaths

    @FilePaths.setter
    def FilePaths(self, FilePaths):
        self._FilePaths = FilePaths


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._UseStatus = params.get("UseStatus")
        self._ResourceIds = params.get("ResourceIds")
        self._FilePaths = params.get("FilePaths")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteResourceFilesResponse(AbstractModel):
    """DeleteResourceFiles返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 资源批量删除结果
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteResourceRequest(AbstractModel):
    """DeleteResource请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _ResourceId: 资源ID
        :type ResourceId: str
        """
        self._ProjectId = None
        self._ResourceId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ResourceId(self):
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._ResourceId = params.get("ResourceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteResourceResponse(AbstractModel):
    """DeleteResource返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 是否成功
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteRuleRequest(AbstractModel):
    """DeleteRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleId: 质量规则ID
        :type RuleId: int
        :param _ProjectId: 项目ID
        :type ProjectId: str
        """
        self._RuleId = None
        self._ProjectId = None

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRuleResponse(AbstractModel):
    """DeleteRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 是否删除成功
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteRuleTemplateRequest(AbstractModel):
    """DeleteRuleTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _Ids: 模版Id列表
        :type Ids: list of int non-negative
        """
        self._ProjectId = None
        self._Ids = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Ids(self):
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._Ids = params.get("Ids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRuleTemplateResponse(AbstractModel):
    """DeleteRuleTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 删除成功
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteTaskAlarmRegularRequest(AbstractModel):
    """DeleteTaskAlarmRegular请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 主键ID
        :type Id: str
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _TaskId: 任务ID
        :type TaskId: str
        :param _TaskType: 任务类型(201表示实时任务，202表示离线任务)
        :type TaskType: int
        """
        self._Id = None
        self._ProjectId = None
        self._TaskId = None
        self._TaskType = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._ProjectId = params.get("ProjectId")
        self._TaskId = params.get("TaskId")
        self._TaskType = params.get("TaskType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteTaskAlarmRegularResponse(AbstractModel):
    """DeleteTaskAlarmRegular返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 删除结果(true表示删除成功，false表示删除失败)
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteTaskDsRequest(AbstractModel):
    """DeleteTaskDs请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _DeleteScript: 是否删除脚本
true：删除
false：不删除
不传默认false
        :type DeleteScript: bool
        :param _OperateInform: 任务操作是否消息通知下游任务责任人true：通知
false：不通知
不传默认false
        :type OperateInform: bool
        :param _TaskId: 任务ID
和VirtualTaskId选填一个
        :type TaskId: str
        :param _VirtualTaskId: 虚拟任务id
和TaskId选填一个

        :type VirtualTaskId: str
        :param _VirtualFlag: 虚拟任务标记
true：是虚拟任务
false：不是虚拟任务
不传默认false
        :type VirtualFlag: bool
        :param _DeleteMode: 任务删除方式
true：不针对下游任务实例进行强制失败
false：针对下游任务实例进行强制失败
不传默认false

        :type DeleteMode: bool
        """
        self._ProjectId = None
        self._DeleteScript = None
        self._OperateInform = None
        self._TaskId = None
        self._VirtualTaskId = None
        self._VirtualFlag = None
        self._DeleteMode = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def DeleteScript(self):
        return self._DeleteScript

    @DeleteScript.setter
    def DeleteScript(self, DeleteScript):
        self._DeleteScript = DeleteScript

    @property
    def OperateInform(self):
        return self._OperateInform

    @OperateInform.setter
    def OperateInform(self, OperateInform):
        self._OperateInform = OperateInform

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def VirtualTaskId(self):
        return self._VirtualTaskId

    @VirtualTaskId.setter
    def VirtualTaskId(self, VirtualTaskId):
        self._VirtualTaskId = VirtualTaskId

    @property
    def VirtualFlag(self):
        return self._VirtualFlag

    @VirtualFlag.setter
    def VirtualFlag(self, VirtualFlag):
        self._VirtualFlag = VirtualFlag

    @property
    def DeleteMode(self):
        return self._DeleteMode

    @DeleteMode.setter
    def DeleteMode(self, DeleteMode):
        self._DeleteMode = DeleteMode


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._DeleteScript = params.get("DeleteScript")
        self._OperateInform = params.get("OperateInform")
        self._TaskId = params.get("TaskId")
        self._VirtualTaskId = params.get("VirtualTaskId")
        self._VirtualFlag = params.get("VirtualFlag")
        self._DeleteMode = params.get("DeleteMode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteTaskDsResponse(AbstractModel):
    """DeleteTaskDs返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 是否删除成功
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DeleteWorkflowByIdRequest(AbstractModel):
    """DeleteWorkflowById请求参数结构体

    """

    def __init__(self):
        r"""
        :param _WorkflowId: 工作流id
        :type WorkflowId: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _DeleteMode: 删除后下游任务的处理方式，true:下游任务均正常运行 false:下游任务均运行失败
        :type DeleteMode: bool
        :param _EnableNotify: 删除任务后是否通知下游任务责任人, true:通知 false:不通知
        :type EnableNotify: bool
        """
        self._WorkflowId = None
        self._ProjectId = None
        self._DeleteMode = None
        self._EnableNotify = None

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def DeleteMode(self):
        return self._DeleteMode

    @DeleteMode.setter
    def DeleteMode(self, DeleteMode):
        self._DeleteMode = DeleteMode

    @property
    def EnableNotify(self):
        return self._EnableNotify

    @EnableNotify.setter
    def EnableNotify(self, EnableNotify):
        self._EnableNotify = EnableNotify


    def _deserialize(self, params):
        self._WorkflowId = params.get("WorkflowId")
        self._ProjectId = params.get("ProjectId")
        self._DeleteMode = params.get("DeleteMode")
        self._EnableNotify = params.get("EnableNotify")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteWorkflowByIdResponse(AbstractModel):
    """DeleteWorkflowById返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 删除结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.OperationOpsDto`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = OperationOpsDto()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DeleteWorkflowNewRequest(AbstractModel):
    """DeleteWorkflowNew请求参数结构体

    """

    def __init__(self):
        r"""
        :param _WorkFlowId: 工作流id
        :type WorkFlowId: str
        :param _DeleteMode: true : 删除后下游任务可正常运行
false：删除后下游任务不可运行
        :type DeleteMode: bool
        :param _EnableNotify: true：通知下游任务责任人
false:  不通知下游任务责任人
        :type EnableNotify: bool
        :param _ProjectId: 项目Id
        :type ProjectId: str
        """
        self._WorkFlowId = None
        self._DeleteMode = None
        self._EnableNotify = None
        self._ProjectId = None

    @property
    def WorkFlowId(self):
        return self._WorkFlowId

    @WorkFlowId.setter
    def WorkFlowId(self, WorkFlowId):
        self._WorkFlowId = WorkFlowId

    @property
    def DeleteMode(self):
        return self._DeleteMode

    @DeleteMode.setter
    def DeleteMode(self, DeleteMode):
        self._DeleteMode = DeleteMode

    @property
    def EnableNotify(self):
        return self._EnableNotify

    @EnableNotify.setter
    def EnableNotify(self, EnableNotify):
        self._EnableNotify = EnableNotify

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._WorkFlowId = params.get("WorkFlowId")
        self._DeleteMode = params.get("DeleteMode")
        self._EnableNotify = params.get("EnableNotify")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteWorkflowNewResponse(AbstractModel):
    """DeleteWorkflowNew返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 返回删除结果
        :type Data: :class:`tencentcloud.wedata.v20210820.models.OperateResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = OperateResult()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DependencyConfig(AbstractModel):
    """依赖配置

    """

    def __init__(self):
        r"""
        :param _DependConfType: 仅五种周期运行依赖配置： HOUR,DAY,WEEK,MONTH,YEAR,CRONTAB,MINUTE
        :type DependConfType: str
        :param _SubordinateCyclicType: 依赖配置从属周期类型，CURRENT_HOUR，PREVIOUS_HOUR，CURRENT_DAY，PREVIOUS_DAY，PREVIOUS_WEEK，PREVIOUS_FRIDAY，PREVIOUS_WEEKEND，CURRENT_MONTH，PREVIOUS_MONTH，PREVIOUS_END_OF_MONTH
     * PREVIOUS_BEGIN_OF_MONTH，ALL_MONTH_OF_YEAR，ALL_DAY_OF_YEAR，CURRENT_YEAR，CURRENT，CURRENT_MINUTE，PREVIOUS_MINUTE_CYCLE，PREVIOUS_HOUR_CYCLE
        :type SubordinateCyclicType: str
        :param _DependencyStrategy: WAITING，等待（默认策略）EXECUTING:执行
        :type DependencyStrategy: str
        :param _ParentTask: 父任务信息
注意：此字段可能返回 null，表示取不到有效值。
        :type ParentTask: :class:`tencentcloud.wedata.v20210820.models.TaskInnerInfo`
        :param _SonTask: 子任务信息
注意：此字段可能返回 null，表示取不到有效值。
        :type SonTask: :class:`tencentcloud.wedata.v20210820.models.TaskInnerInfo`
        """
        self._DependConfType = None
        self._SubordinateCyclicType = None
        self._DependencyStrategy = None
        self._ParentTask = None
        self._SonTask = None

    @property
    def DependConfType(self):
        return self._DependConfType

    @DependConfType.setter
    def DependConfType(self, DependConfType):
        self._DependConfType = DependConfType

    @property
    def SubordinateCyclicType(self):
        return self._SubordinateCyclicType

    @SubordinateCyclicType.setter
    def SubordinateCyclicType(self, SubordinateCyclicType):
        self._SubordinateCyclicType = SubordinateCyclicType

    @property
    def DependencyStrategy(self):
        return self._DependencyStrategy

    @DependencyStrategy.setter
    def DependencyStrategy(self, DependencyStrategy):
        self._DependencyStrategy = DependencyStrategy

    @property
    def ParentTask(self):
        return self._ParentTask

    @ParentTask.setter
    def ParentTask(self, ParentTask):
        self._ParentTask = ParentTask

    @property
    def SonTask(self):
        return self._SonTask

    @SonTask.setter
    def SonTask(self, SonTask):
        self._SonTask = SonTask


    def _deserialize(self, params):
        self._DependConfType = params.get("DependConfType")
        self._SubordinateCyclicType = params.get("SubordinateCyclicType")
        self._DependencyStrategy = params.get("DependencyStrategy")
        if params.get("ParentTask") is not None:
            self._ParentTask = TaskInnerInfo()
            self._ParentTask._deserialize(params.get("ParentTask"))
        if params.get("SonTask") is not None:
            self._SonTask = TaskInnerInfo()
            self._SonTask._deserialize(params.get("SonTask"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DependencyConfigDsDTONoRecurV2(AbstractModel):
    """依赖配置无循环递归属性

    """

    def __init__(self):
        r"""
        :param _ParentTask: ParentTask任务
注意：此字段可能返回 null，表示取不到有效值。
        :type ParentTask: :class:`tencentcloud.wedata.v20210820.models.TaskDsDTONoRecurV2`
        :param _SonTask: SonTask任务
注意：此字段可能返回 null，表示取不到有效值。
        :type SonTask: :class:`tencentcloud.wedata.v20210820.models.TaskDsDTONoRecurV2`
        :param _MainCyclicConfig: the dependency config
注意：此字段可能返回 null，表示取不到有效值。
        :type MainCyclicConfig: str
        :param _SubordinateCyclicConfig: SubordinateCyclicConfig配置
注意：此字段可能返回 null，表示取不到有效值。
        :type SubordinateCyclicConfig: str
        :param _DependencyStrategy: DependencyStrategy策略
注意：此字段可能返回 null，表示取不到有效值。
        :type DependencyStrategy: :class:`tencentcloud.wedata.v20210820.models.DependencyStrategyDs`
        """
        self._ParentTask = None
        self._SonTask = None
        self._MainCyclicConfig = None
        self._SubordinateCyclicConfig = None
        self._DependencyStrategy = None

    @property
    def ParentTask(self):
        return self._ParentTask

    @ParentTask.setter
    def ParentTask(self, ParentTask):
        self._ParentTask = ParentTask

    @property
    def SonTask(self):
        return self._SonTask

    @SonTask.setter
    def SonTask(self, SonTask):
        self._SonTask = SonTask

    @property
    def MainCyclicConfig(self):
        return self._MainCyclicConfig

    @MainCyclicConfig.setter
    def MainCyclicConfig(self, MainCyclicConfig):
        self._MainCyclicConfig = MainCyclicConfig

    @property
    def SubordinateCyclicConfig(self):
        return self._SubordinateCyclicConfig

    @SubordinateCyclicConfig.setter
    def SubordinateCyclicConfig(self, SubordinateCyclicConfig):
        self._SubordinateCyclicConfig = SubordinateCyclicConfig

    @property
    def DependencyStrategy(self):
        return self._DependencyStrategy

    @DependencyStrategy.setter
    def DependencyStrategy(self, DependencyStrategy):
        self._DependencyStrategy = DependencyStrategy


    def _deserialize(self, params):
        if params.get("ParentTask") is not None:
            self._ParentTask = TaskDsDTONoRecurV2()
            self._ParentTask._deserialize(params.get("ParentTask"))
        if params.get("SonTask") is not None:
            self._SonTask = TaskDsDTONoRecurV2()
            self._SonTask._deserialize(params.get("SonTask"))
        self._MainCyclicConfig = params.get("MainCyclicConfig")
        self._SubordinateCyclicConfig = params.get("SubordinateCyclicConfig")
        if params.get("DependencyStrategy") is not None:
            self._DependencyStrategy = DependencyStrategyDs()
            self._DependencyStrategy._deserialize(params.get("DependencyStrategy"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DependencyStrategyDs(AbstractModel):
    """依赖配置策略

    """

    def __init__(self):
        r"""
        :param _PollingNullStrategy: 等待（默认策略）或 执行
注意：此字段可能返回 null，表示取不到有效值。
        :type PollingNullStrategy: str
        """
        self._PollingNullStrategy = None

    @property
    def PollingNullStrategy(self):
        return self._PollingNullStrategy

    @PollingNullStrategy.setter
    def PollingNullStrategy(self, PollingNullStrategy):
        self._PollingNullStrategy = PollingNullStrategy


    def _deserialize(self, params):
        self._PollingNullStrategy = params.get("PollingNullStrategy")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAlarmEventsRequest(AbstractModel):
    """DescribeAlarmEvents请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _PageNumber: 当前页
        :type PageNumber: int
        :param _PageSize: 每页记录数
        :type PageSize: int
        :param _Filters: 过滤条件(key可以是：AlarmLevel,AlarmIndicator,KeyWord)
        :type Filters: list of Filter
        :param _OrderFields: 排序字段（AlarmTime）
        :type OrderFields: list of OrderField
        :param _TaskType: 类型(201表示实时，202表示离线)
        :type TaskType: int
        :param _StartTime: 开始时间
        :type StartTime: str
        :param _EndTime: 结束时间
        :type EndTime: str
        :param _MonitorType: 监控对象类型(1:所有任务,2:指定任务,3:指定责任人,4:指定资源组)
        :type MonitorType: int
        """
        self._ProjectId = None
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None
        self._OrderFields = None
        self._TaskType = None
        self._StartTime = None
        self._EndTime = None
        self._MonitorType = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def MonitorType(self):
        return self._MonitorType

    @MonitorType.setter
    def MonitorType(self, MonitorType):
        self._MonitorType = MonitorType


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        self._TaskType = params.get("TaskType")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._MonitorType = params.get("MonitorType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAlarmEventsResponse(AbstractModel):
    """DescribeAlarmEvents返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AlarmEventInfoList: 告警事件列表
注意：此字段可能返回 null，表示取不到有效值。
        :type AlarmEventInfoList: list of AlarmEventInfo
        :param _TotalCount: 总记录数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AlarmEventInfoList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def AlarmEventInfoList(self):
        return self._AlarmEventInfoList

    @AlarmEventInfoList.setter
    def AlarmEventInfoList(self, AlarmEventInfoList):
        self._AlarmEventInfoList = AlarmEventInfoList

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("AlarmEventInfoList") is not None:
            self._AlarmEventInfoList = []
            for item in params.get("AlarmEventInfoList"):
                obj = AlarmEventInfo()
                obj._deserialize(item)
                self._AlarmEventInfoList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAlarmReceiverRequest(AbstractModel):
    """DescribeAlarmReceiver请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AlarmId: 告警ID
        :type AlarmId: str
        :param _PageNumber: 当前页
        :type PageNumber: int
        :param _PageSize: 每页记录数
        :type PageSize: int
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _MessageId: 消息ID
        :type MessageId: str
        :param _TaskType: 类型
        :type TaskType: int
        :param _AlarmRecipient: 告警接收人ID(逗号分隔)
        :type AlarmRecipient: str
        :param _AlarmRecipientName: 告警接收人姓名(逗号分隔)
        :type AlarmRecipientName: str
        :param _AlarmTime: 告警时间
        :type AlarmTime: str
        :param _MonitorType: 监控对象类型(1:所有任务,2:指定任务,3:指定责任人,4:指定资源组)
        :type MonitorType: int
        """
        self._AlarmId = None
        self._PageNumber = None
        self._PageSize = None
        self._ProjectId = None
        self._MessageId = None
        self._TaskType = None
        self._AlarmRecipient = None
        self._AlarmRecipientName = None
        self._AlarmTime = None
        self._MonitorType = None

    @property
    def AlarmId(self):
        return self._AlarmId

    @AlarmId.setter
    def AlarmId(self, AlarmId):
        self._AlarmId = AlarmId

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def MessageId(self):
        return self._MessageId

    @MessageId.setter
    def MessageId(self, MessageId):
        self._MessageId = MessageId

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def AlarmRecipient(self):
        return self._AlarmRecipient

    @AlarmRecipient.setter
    def AlarmRecipient(self, AlarmRecipient):
        self._AlarmRecipient = AlarmRecipient

    @property
    def AlarmRecipientName(self):
        return self._AlarmRecipientName

    @AlarmRecipientName.setter
    def AlarmRecipientName(self, AlarmRecipientName):
        self._AlarmRecipientName = AlarmRecipientName

    @property
    def AlarmTime(self):
        return self._AlarmTime

    @AlarmTime.setter
    def AlarmTime(self, AlarmTime):
        self._AlarmTime = AlarmTime

    @property
    def MonitorType(self):
        return self._MonitorType

    @MonitorType.setter
    def MonitorType(self, MonitorType):
        self._MonitorType = MonitorType


    def _deserialize(self, params):
        self._AlarmId = params.get("AlarmId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        self._ProjectId = params.get("ProjectId")
        self._MessageId = params.get("MessageId")
        self._TaskType = params.get("TaskType")
        self._AlarmRecipient = params.get("AlarmRecipient")
        self._AlarmRecipientName = params.get("AlarmRecipientName")
        self._AlarmTime = params.get("AlarmTime")
        self._MonitorType = params.get("MonitorType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAlarmReceiverResponse(AbstractModel):
    """DescribeAlarmReceiver返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AlarmReceiverInfoList: 告警接收人列表
注意：此字段可能返回 null，表示取不到有效值。
        :type AlarmReceiverInfoList: list of AlarmReceiverInfo
        :param _TotalCount: 总记录数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AlarmReceiverInfoList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def AlarmReceiverInfoList(self):
        return self._AlarmReceiverInfoList

    @AlarmReceiverInfoList.setter
    def AlarmReceiverInfoList(self, AlarmReceiverInfoList):
        self._AlarmReceiverInfoList = AlarmReceiverInfoList

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("AlarmReceiverInfoList") is not None:
            self._AlarmReceiverInfoList = []
            for item in params.get("AlarmReceiverInfoList"):
                obj = AlarmReceiverInfo()
                obj._deserialize(item)
                self._AlarmReceiverInfoList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAllByFolderNewRequest(AbstractModel):
    """DescribeAllByFolderNew请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Folder: 文件夹属性
        :type Folder: :class:`tencentcloud.wedata.v20210820.models.FolderOpsDto`
        :param _Workflows: 工作流列表
        :type Workflows: list of WorkflowCanvasOpsDto
        :param _TargetFolderId: 目标文件id
        :type TargetFolderId: str
        :param _KeyWords: 关键字
        :type KeyWords: str
        :param _ParentsFolderId: 父文件id
        :type ParentsFolderId: str
        :param _IsAddWorkflow: 拉取文件夹列表
        :type IsAddWorkflow: str
        :param _TaskStates: 任务状态
        :type TaskStates: list of str
        :param _FindType: 搜索类型
        :type FindType: str
        :param _OptType: 访问类型
        :type OptType: str
        :param _OperatorName: 操作者名称
        :type OperatorName: str
        :param _OperatorId: 操作者id
        :type OperatorId: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _ProjectIdent: 项目标志
        :type ProjectIdent: str
        :param _ProjectName: 项目名称
        :type ProjectName: str
        :param _PageIndex: 索引页码
        :type PageIndex: int
        :param _PageSize: 页面大小
        :type PageSize: int
        :param _Count: 数据总数
        :type Count: int
        :param _RequestBaseInfo: 基础请求信息
        :type RequestBaseInfo: :class:`tencentcloud.wedata.v20210820.models.ProjectBaseInfoOpsRequest`
        :param _IsCount: 是否计算总数
        :type IsCount: bool
        """
        self._Folder = None
        self._Workflows = None
        self._TargetFolderId = None
        self._KeyWords = None
        self._ParentsFolderId = None
        self._IsAddWorkflow = None
        self._TaskStates = None
        self._FindType = None
        self._OptType = None
        self._OperatorName = None
        self._OperatorId = None
        self._ProjectId = None
        self._ProjectIdent = None
        self._ProjectName = None
        self._PageIndex = None
        self._PageSize = None
        self._Count = None
        self._RequestBaseInfo = None
        self._IsCount = None

    @property
    def Folder(self):
        return self._Folder

    @Folder.setter
    def Folder(self, Folder):
        self._Folder = Folder

    @property
    def Workflows(self):
        return self._Workflows

    @Workflows.setter
    def Workflows(self, Workflows):
        self._Workflows = Workflows

    @property
    def TargetFolderId(self):
        return self._TargetFolderId

    @TargetFolderId.setter
    def TargetFolderId(self, TargetFolderId):
        self._TargetFolderId = TargetFolderId

    @property
    def KeyWords(self):
        return self._KeyWords

    @KeyWords.setter
    def KeyWords(self, KeyWords):
        self._KeyWords = KeyWords

    @property
    def ParentsFolderId(self):
        return self._ParentsFolderId

    @ParentsFolderId.setter
    def ParentsFolderId(self, ParentsFolderId):
        self._ParentsFolderId = ParentsFolderId

    @property
    def IsAddWorkflow(self):
        return self._IsAddWorkflow

    @IsAddWorkflow.setter
    def IsAddWorkflow(self, IsAddWorkflow):
        self._IsAddWorkflow = IsAddWorkflow

    @property
    def TaskStates(self):
        return self._TaskStates

    @TaskStates.setter
    def TaskStates(self, TaskStates):
        self._TaskStates = TaskStates

    @property
    def FindType(self):
        return self._FindType

    @FindType.setter
    def FindType(self, FindType):
        self._FindType = FindType

    @property
    def OptType(self):
        return self._OptType

    @OptType.setter
    def OptType(self, OptType):
        self._OptType = OptType

    @property
    def OperatorName(self):
        return self._OperatorName

    @OperatorName.setter
    def OperatorName(self, OperatorName):
        self._OperatorName = OperatorName

    @property
    def OperatorId(self):
        return self._OperatorId

    @OperatorId.setter
    def OperatorId(self, OperatorId):
        self._OperatorId = OperatorId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ProjectIdent(self):
        return self._ProjectIdent

    @ProjectIdent.setter
    def ProjectIdent(self, ProjectIdent):
        self._ProjectIdent = ProjectIdent

    @property
    def ProjectName(self):
        return self._ProjectName

    @ProjectName.setter
    def ProjectName(self, ProjectName):
        self._ProjectName = ProjectName

    @property
    def PageIndex(self):
        return self._PageIndex

    @PageIndex.setter
    def PageIndex(self, PageIndex):
        self._PageIndex = PageIndex

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Count(self):
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def RequestBaseInfo(self):
        return self._RequestBaseInfo

    @RequestBaseInfo.setter
    def RequestBaseInfo(self, RequestBaseInfo):
        self._RequestBaseInfo = RequestBaseInfo

    @property
    def IsCount(self):
        return self._IsCount

    @IsCount.setter
    def IsCount(self, IsCount):
        self._IsCount = IsCount


    def _deserialize(self, params):
        if params.get("Folder") is not None:
            self._Folder = FolderOpsDto()
            self._Folder._deserialize(params.get("Folder"))
        if params.get("Workflows") is not None:
            self._Workflows = []
            for item in params.get("Workflows"):
                obj = WorkflowCanvasOpsDto()
                obj._deserialize(item)
                self._Workflows.append(obj)
        self._TargetFolderId = params.get("TargetFolderId")
        self._KeyWords = params.get("KeyWords")
        self._ParentsFolderId = params.get("ParentsFolderId")
        self._IsAddWorkflow = params.get("IsAddWorkflow")
        self._TaskStates = params.get("TaskStates")
        self._FindType = params.get("FindType")
        self._OptType = params.get("OptType")
        self._OperatorName = params.get("OperatorName")
        self._OperatorId = params.get("OperatorId")
        self._ProjectId = params.get("ProjectId")
        self._ProjectIdent = params.get("ProjectIdent")
        self._ProjectName = params.get("ProjectName")
        self._PageIndex = params.get("PageIndex")
        self._PageSize = params.get("PageSize")
        self._Count = params.get("Count")
        if params.get("RequestBaseInfo") is not None:
            self._RequestBaseInfo = ProjectBaseInfoOpsRequest()
            self._RequestBaseInfo._deserialize(params.get("RequestBaseInfo"))
        self._IsCount = params.get("IsCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAllByFolderNewResponse(AbstractModel):
    """DescribeAllByFolderNew返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 结果集
        :type Data: :class:`tencentcloud.wedata.v20210820.models.CollectionFolderOpsDto`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = CollectionFolderOpsDto()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeAllTaskTypeRequest(AbstractModel):
    """DescribeAllTaskType请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        """
        self._ProjectId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAllTaskTypeResponse(AbstractModel):
    """DescribeAllTaskType返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 任务类型
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of TaskTypeOpsDto
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = TaskTypeOpsDto()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAllUsedVersionSonRequest(AbstractModel):
    """DescribeAllUsedVersionSon请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SearchCondition: 搜索条件
        :type SearchCondition: :class:`tencentcloud.wedata.v20210820.models.InstanceSearchCondition`
        :param _PageNumber: 页码
        :type PageNumber: int
        :param _PageSize: 分页大小
        :type PageSize: int
        """
        self._SearchCondition = None
        self._PageNumber = None
        self._PageSize = None

    @property
    def SearchCondition(self):
        return self._SearchCondition

    @SearchCondition.setter
    def SearchCondition(self, SearchCondition):
        self._SearchCondition = SearchCondition

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        if params.get("SearchCondition") is not None:
            self._SearchCondition = InstanceSearchCondition()
            self._SearchCondition._deserialize(params.get("SearchCondition"))
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAllUsedVersionSonResponse(AbstractModel):
    """DescribeAllUsedVersionSon返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 结果
        :type Data: :class:`tencentcloud.wedata.v20210820.models.CollectionTaskOpsDto`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = CollectionTaskOpsDto()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeApply(AbstractModel):
    """申请列表

    """

    def __init__(self):
        r"""
        :param _Rows: 申请列表详情
        :type Rows: list of Apply
        :param _TotalPageNumber: 总分页页码
        :type TotalPageNumber: int
        :param _TotalCount: 总个数
        :type TotalCount: int
        :param _PageNumber: 分页页码
        :type PageNumber: int
        :param _PageSize: 分页大小
        :type PageSize: int
        """
        self._Rows = None
        self._TotalPageNumber = None
        self._TotalCount = None
        self._PageNumber = None
        self._PageSize = None

    @property
    def Rows(self):
        return self._Rows

    @Rows.setter
    def Rows(self, Rows):
        self._Rows = Rows

    @property
    def TotalPageNumber(self):
        return self._TotalPageNumber

    @TotalPageNumber.setter
    def TotalPageNumber(self, TotalPageNumber):
        self._TotalPageNumber = TotalPageNumber

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        if params.get("Rows") is not None:
            self._Rows = []
            for item in params.get("Rows"):
                obj = Apply()
                obj._deserialize(item)
                self._Rows.append(obj)
        self._TotalPageNumber = params.get("TotalPageNumber")
        self._TotalCount = params.get("TotalCount")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeApproveListRequest(AbstractModel):
    """DescribeApproveList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ApproveClassification: 审批分类key
        :type ApproveClassification: str
        :param _PageSize: 分页大小
        :type PageSize: int
        :param _PageNumber: 分页数
        :type PageNumber: int
        :param _Filters: 自定义条件查询
        :type Filters: list of FilterOptional
        :param _OrderFields: 排序字段
        :type OrderFields: list of OrderFieldOptional
        """
        self._ApproveClassification = None
        self._PageSize = None
        self._PageNumber = None
        self._Filters = None
        self._OrderFields = None

    @property
    def ApproveClassification(self):
        return self._ApproveClassification

    @ApproveClassification.setter
    def ApproveClassification(self, ApproveClassification):
        self._ApproveClassification = ApproveClassification

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields


    def _deserialize(self, params):
        self._ApproveClassification = params.get("ApproveClassification")
        self._PageSize = params.get("PageSize")
        self._PageNumber = params.get("PageNumber")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = FilterOptional()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderFieldOptional()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeApproveListResponse(AbstractModel):
    """DescribeApproveList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 待审批列表详情
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.DescribeApply`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeApply()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeApproveTypeListRequest(AbstractModel):
    """DescribeApproveTypeList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Classification: 类型key
        :type Classification: str
        """
        self._Classification = None

    @property
    def Classification(self):
        return self._Classification

    @Classification.setter
    def Classification(self, Classification):
        self._Classification = Classification


    def _deserialize(self, params):
        self._Classification = params.get("Classification")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeApproveTypeListResponse(AbstractModel):
    """DescribeApproveTypeList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 获取审批分类列表
        :type Data: list of ApproveType
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = ApproveType()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBaselineAllTaskDagRequest(AbstractModel):
    """DescribeBaselineAllTaskDag请求参数结构体

    """

    def __init__(self):
        r"""
        :param _BaselineId: 基线id
        :type BaselineId: str
        :param _ProjectId: 1
        :type ProjectId: str
        :param _BaselineTaskId: 1
        :type BaselineTaskId: str
        """
        self._BaselineId = None
        self._ProjectId = None
        self._BaselineTaskId = None

    @property
    def BaselineId(self):
        return self._BaselineId

    @BaselineId.setter
    def BaselineId(self, BaselineId):
        self._BaselineId = BaselineId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def BaselineTaskId(self):
        return self._BaselineTaskId

    @BaselineTaskId.setter
    def BaselineTaskId(self, BaselineTaskId):
        self._BaselineTaskId = BaselineTaskId


    def _deserialize(self, params):
        self._BaselineId = params.get("BaselineId")
        self._ProjectId = params.get("ProjectId")
        self._BaselineTaskId = params.get("BaselineTaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselineAllTaskDagResponse(AbstractModel):
    """DescribeBaselineAllTaskDag返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 基线
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.DescribeBaselineTaskDagResponse`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeBaselineTaskDagResponse()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeBaselineByIdRequest(AbstractModel):
    """DescribeBaselineById请求参数结构体

    """

    def __init__(self):
        r"""
        :param _BaselineId: 无
        :type BaselineId: str
        :param _ProjectId: 1
        :type ProjectId: str
        """
        self._BaselineId = None
        self._ProjectId = None

    @property
    def BaselineId(self):
        return self._BaselineId

    @BaselineId.setter
    def BaselineId(self, BaselineId):
        self._BaselineId = BaselineId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._BaselineId = params.get("BaselineId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselineByIdResponse(AbstractModel):
    """DescribeBaselineById返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 租户id
        :type Data: :class:`tencentcloud.wedata.v20210820.models.BaselineDetailResponse`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BaselineDetailResponse()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeBaselineInstanceDagRequest(AbstractModel):
    """DescribeBaselineInstanceDag请求参数结构体

    """

    def __init__(self):
        r"""
        :param _BaselineInstanceId: 基线实例id
        :type BaselineInstanceId: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _UpstreamInstanceIds: 要展开的上游实例id，格式为 taskIdA_curRunDate1,taskIdB_curRunDate2
        :type UpstreamInstanceIds: str
        :param _Level: 向上展开层级
        :type Level: int
        :param _PromiseTaskId: 保障任务id
        :type PromiseTaskId: str
        """
        self._BaselineInstanceId = None
        self._ProjectId = None
        self._UpstreamInstanceIds = None
        self._Level = None
        self._PromiseTaskId = None

    @property
    def BaselineInstanceId(self):
        return self._BaselineInstanceId

    @BaselineInstanceId.setter
    def BaselineInstanceId(self, BaselineInstanceId):
        self._BaselineInstanceId = BaselineInstanceId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def UpstreamInstanceIds(self):
        return self._UpstreamInstanceIds

    @UpstreamInstanceIds.setter
    def UpstreamInstanceIds(self, UpstreamInstanceIds):
        self._UpstreamInstanceIds = UpstreamInstanceIds

    @property
    def Level(self):
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level

    @property
    def PromiseTaskId(self):
        return self._PromiseTaskId

    @PromiseTaskId.setter
    def PromiseTaskId(self, PromiseTaskId):
        self._PromiseTaskId = PromiseTaskId


    def _deserialize(self, params):
        self._BaselineInstanceId = params.get("BaselineInstanceId")
        self._ProjectId = params.get("ProjectId")
        self._UpstreamInstanceIds = params.get("UpstreamInstanceIds")
        self._Level = params.get("Level")
        self._PromiseTaskId = params.get("PromiseTaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselineInstanceDagResponse(AbstractModel):
    """DescribeBaselineInstanceDag返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 基线实例dag
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.BaselineInstanceVo`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BaselineInstanceVo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeBaselineInstanceGanttRequest(AbstractModel):
    """DescribeBaselineInstanceGantt请求参数结构体

    """

    def __init__(self):
        r"""
        :param _BaselineInstanceId: 基线实例id
        :type BaselineInstanceId: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _PromiseTaskId: 保障任务id
        :type PromiseTaskId: str
        """
        self._BaselineInstanceId = None
        self._ProjectId = None
        self._PromiseTaskId = None

    @property
    def BaselineInstanceId(self):
        return self._BaselineInstanceId

    @BaselineInstanceId.setter
    def BaselineInstanceId(self, BaselineInstanceId):
        self._BaselineInstanceId = BaselineInstanceId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PromiseTaskId(self):
        return self._PromiseTaskId

    @PromiseTaskId.setter
    def PromiseTaskId(self, PromiseTaskId):
        self._PromiseTaskId = PromiseTaskId


    def _deserialize(self, params):
        self._BaselineInstanceId = params.get("BaselineInstanceId")
        self._ProjectId = params.get("ProjectId")
        self._PromiseTaskId = params.get("PromiseTaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselineInstanceGanttResponse(AbstractModel):
    """DescribeBaselineInstanceGantt返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 基线实例，带有关键任务实例信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.BaselineInstanceVo`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = BaselineInstanceVo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeBaselineInstancesRequest(AbstractModel):
    """DescribeBaselineInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PageNumber: 分页页码
        :type PageNumber: int
        :param _PageSize: 分页大小
        :type PageSize: int
        :param _Filters: 过滤字段
        :type Filters: list of Filter
        """
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselineInstancesResponse(AbstractModel):
    """分页查询实例响应

    """

    def __init__(self):
        r"""
        :param _BaselineInstances: 基线实例数组
注意：此字段可能返回 null，表示取不到有效值。
        :type BaselineInstances: list of BaselineInstanceVo
        :param _TotalCount: 总数量
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        """
        self._BaselineInstances = None
        self._TotalCount = None

    @property
    def BaselineInstances(self):
        return self._BaselineInstances

    @BaselineInstances.setter
    def BaselineInstances(self, BaselineInstances):
        self._BaselineInstances = BaselineInstances

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount


    def _deserialize(self, params):
        if params.get("BaselineInstances") is not None:
            self._BaselineInstances = []
            for item in params.get("BaselineInstances"):
                obj = BaselineInstanceVo()
                obj._deserialize(item)
                self._BaselineInstances.append(obj)
        self._TotalCount = params.get("TotalCount")


class DescribeBaselineResponse(AbstractModel):
    """DescribeBaselineResponse

    """

    def __init__(self):
        r"""
        :param _Baselines: 1
注意：此字段可能返回 null，表示取不到有效值。
        :type Baselines: list of BaselineDto
        :param _TotalCount: 1
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        """
        self._Baselines = None
        self._TotalCount = None

    @property
    def Baselines(self):
        return self._Baselines

    @Baselines.setter
    def Baselines(self, Baselines):
        self._Baselines = Baselines

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount


    def _deserialize(self, params):
        if params.get("Baselines") is not None:
            self._Baselines = []
            for item in params.get("Baselines"):
                obj = BaselineDto()
                obj._deserialize(item)
                self._Baselines.append(obj)
        self._TotalCount = params.get("TotalCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselineTaskDagResponse(AbstractModel):
    """DescribeBaselineTaskDagResponse

    """

    def __init__(self):
        r"""
        :param _Baseline: 基线
注意：此字段可能返回 null，表示取不到有效值。
        :type Baseline: :class:`tencentcloud.wedata.v20210820.models.BaselineDto`
        :param _BaselineTaskDag: 基线任务dag
注意：此字段可能返回 null，表示取不到有效值。
        :type BaselineTaskDag: list of BaselineTaskDto
        """
        self._Baseline = None
        self._BaselineTaskDag = None

    @property
    def Baseline(self):
        return self._Baseline

    @Baseline.setter
    def Baseline(self, Baseline):
        self._Baseline = Baseline

    @property
    def BaselineTaskDag(self):
        return self._BaselineTaskDag

    @BaselineTaskDag.setter
    def BaselineTaskDag(self, BaselineTaskDag):
        self._BaselineTaskDag = BaselineTaskDag


    def _deserialize(self, params):
        if params.get("Baseline") is not None:
            self._Baseline = BaselineDto()
            self._Baseline._deserialize(params.get("Baseline"))
        if params.get("BaselineTaskDag") is not None:
            self._BaselineTaskDag = []
            for item in params.get("BaselineTaskDag"):
                obj = BaselineTaskDto()
                obj._deserialize(item)
                self._BaselineTaskDag.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselinesRequest(AbstractModel):
    """DescribeBaselines请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 无
        :type Filters: list of Filter
        :param _PageNumber: 页面下标
        :type PageNumber: int
        :param _PageSize: 页面大小
        :type PageSize: int
        """
        self._Filters = None
        self._PageNumber = None
        self._PageSize = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselinesResponse(AbstractModel):
    """DescribeBaselines返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 基线列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.DescribeBaselineResponse`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeBaselineResponse()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeBatchOperateTaskDTO(AbstractModel):
    """批量操作任务列表

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskId: str
        :param _TaskName: 任务名
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskName: str
        :param _WorkflowId: 工作流Id
注意：此字段可能返回 null，表示取不到有效值。
        :type WorkflowId: str
        :param _WorkflowName: 工作流名
注意：此字段可能返回 null，表示取不到有效值。
        :type WorkflowName: str
        :param _Status: 状态
注意：此字段可能返回 null，表示取不到有效值。
        :type Status: str
        :param _TaskTypeId: 任务ID
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskTypeId: int
        :param _TaskTypeDesc: 任务类型
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskTypeDesc: str
        :param _FolderName: 文件夹名
注意：此字段可能返回 null，表示取不到有效值。
        :type FolderName: str
        :param _FolderId: 文件夹ID
注意：此字段可能返回 null，表示取不到有效值。
        :type FolderId: str
        :param _InCharge: 负责人
注意：此字段可能返回 null，表示取不到有效值。
        :type InCharge: str
        :param _Submit: 是否提交
注意：此字段可能返回 null，表示取不到有效值。
        :type Submit: int
        :param _DataEngine: 引擎：
presto\SparkJob\SparkSql
注意：此字段可能返回 null，表示取不到有效值。
        :type DataEngine: str
        :param _UpdateTime: 更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: str
        :param _CreateTime: 创造时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateTime: str
        :param _CycleUnit: 周期类型
注意：此字段可能返回 null，表示取不到有效值。
        :type CycleUnit: str
        :param _ScheduleDesc: 调度计划
注意：此字段可能返回 null，表示取不到有效值。
        :type ScheduleDesc: str
        :param _DatasourceId: 数据源ID
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasourceId: str
        :param _DatasourceType: 数据源类型
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasourceType: str
        """
        self._TaskId = None
        self._TaskName = None
        self._WorkflowId = None
        self._WorkflowName = None
        self._Status = None
        self._TaskTypeId = None
        self._TaskTypeDesc = None
        self._FolderName = None
        self._FolderId = None
        self._InCharge = None
        self._Submit = None
        self._DataEngine = None
        self._UpdateTime = None
        self._CreateTime = None
        self._CycleUnit = None
        self._ScheduleDesc = None
        self._DatasourceId = None
        self._DatasourceType = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TaskName(self):
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId

    @property
    def WorkflowName(self):
        return self._WorkflowName

    @WorkflowName.setter
    def WorkflowName(self, WorkflowName):
        self._WorkflowName = WorkflowName

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def TaskTypeId(self):
        return self._TaskTypeId

    @TaskTypeId.setter
    def TaskTypeId(self, TaskTypeId):
        self._TaskTypeId = TaskTypeId

    @property
    def TaskTypeDesc(self):
        return self._TaskTypeDesc

    @TaskTypeDesc.setter
    def TaskTypeDesc(self, TaskTypeDesc):
        self._TaskTypeDesc = TaskTypeDesc

    @property
    def FolderName(self):
        return self._FolderName

    @FolderName.setter
    def FolderName(self, FolderName):
        self._FolderName = FolderName

    @property
    def FolderId(self):
        return self._FolderId

    @FolderId.setter
    def FolderId(self, FolderId):
        self._FolderId = FolderId

    @property
    def InCharge(self):
        return self._InCharge

    @InCharge.setter
    def InCharge(self, InCharge):
        self._InCharge = InCharge

    @property
    def Submit(self):
        return self._Submit

    @Submit.setter
    def Submit(self, Submit):
        self._Submit = Submit

    @property
    def DataEngine(self):
        return self._DataEngine

    @DataEngine.setter
    def DataEngine(self, DataEngine):
        self._DataEngine = DataEngine

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def CycleUnit(self):
        return self._CycleUnit

    @CycleUnit.setter
    def CycleUnit(self, CycleUnit):
        self._CycleUnit = CycleUnit

    @property
    def ScheduleDesc(self):
        return self._ScheduleDesc

    @ScheduleDesc.setter
    def ScheduleDesc(self, ScheduleDesc):
        self._ScheduleDesc = ScheduleDesc

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def DatasourceType(self):
        return self._DatasourceType

    @DatasourceType.setter
    def DatasourceType(self, DatasourceType):
        self._DatasourceType = DatasourceType


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._TaskName = params.get("TaskName")
        self._WorkflowId = params.get("WorkflowId")
        self._WorkflowName = params.get("WorkflowName")
        self._Status = params.get("Status")
        self._TaskTypeId = params.get("TaskTypeId")
        self._TaskTypeDesc = params.get("TaskTypeDesc")
        self._FolderName = params.get("FolderName")
        self._FolderId = params.get("FolderId")
        self._InCharge = params.get("InCharge")
        self._Submit = params.get("Submit")
        self._DataEngine = params.get("DataEngine")
        self._UpdateTime = params.get("UpdateTime")
        self._CreateTime = params.get("CreateTime")
        self._CycleUnit = params.get("CycleUnit")
        self._ScheduleDesc = params.get("ScheduleDesc")
        self._DatasourceId = params.get("DatasourceId")
        self._DatasourceType = params.get("DatasourceType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBatchOperateTaskPage(AbstractModel):
    """批量操作任务列表分页

    """

    def __init__(self):
        r"""
        :param _PageCount: 总页码数
注意：此字段可能返回 null，表示取不到有效值。
        :type PageCount: int
        :param _Items: 内容
注意：此字段可能返回 null，表示取不到有效值。
        :type Items: list of DescribeBatchOperateTaskDTO
        :param _TotalCount: 总个数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        """
        self._PageCount = None
        self._Items = None
        self._TotalCount = None

    @property
    def PageCount(self):
        return self._PageCount

    @PageCount.setter
    def PageCount(self, PageCount):
        self._PageCount = PageCount

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount


    def _deserialize(self, params):
        self._PageCount = params.get("PageCount")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = DescribeBatchOperateTaskDTO()
                obj._deserialize(item)
                self._Items.append(obj)
        self._TotalCount = params.get("TotalCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBatchOperateTaskRequest(AbstractModel):
    """DescribeBatchOperateTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _Page: 页码
        :type Page: str
        :param _Size: 页号
        :type Size: str
        :param _StatusList: 状态列表
草稿：'NS'，'N','P','R'
运行：''Y'
停止：'F'
冻结：'O'
停止中：'T'
        :type StatusList: list of str
        :param _OwnerNameList: 责任人名列表
        :type OwnerNameList: list of str
        :param _WorkflowIdList: 工作流列表
        :type WorkflowIdList: list of str
        :param _TaskNameFilter: 任务名称搜索
        :type TaskNameFilter: str
        :param _TaskTypeList: 任务类型列表
        :type TaskTypeList: list of str
        :param _FordIdList: 文件夹列表
        :type FordIdList: list of str
        :param _TaskIdFilter: 任务Id搜索
        :type TaskIdFilter: str
        :param _OwnerNameFilter: 责任人搜索
        :type OwnerNameFilter: str
        :param _SortItem: 排序字段：
UpdateTime
CreateTime
        :type SortItem: str
        :param _SortType: asc:升序
desc:降序
        :type SortType: str
        :param _DataEngineList: 引擎类型列表：三种
SparkJob
SparkSql
presto
        :type DataEngineList: list of str
        :param _UserId: 操作人名
        :type UserId: str
        :param _OwnerId: 1
        :type OwnerId: str
        :param _TenantId: 1
        :type TenantId: str
        :param _DatasourceIdList: 数据源ID列表
        :type DatasourceIdList: list of str
        :param _DatasourceTypeList: 数据源类型列表
        :type DatasourceTypeList: list of str
        :param _CycleUnitList: 调度单位类型列表
        :type CycleUnitList: list of str
        :param _CanSubmit: 是否筛选出可提交的任务
        :type CanSubmit: bool
        """
        self._ProjectId = None
        self._Page = None
        self._Size = None
        self._StatusList = None
        self._OwnerNameList = None
        self._WorkflowIdList = None
        self._TaskNameFilter = None
        self._TaskTypeList = None
        self._FordIdList = None
        self._TaskIdFilter = None
        self._OwnerNameFilter = None
        self._SortItem = None
        self._SortType = None
        self._DataEngineList = None
        self._UserId = None
        self._OwnerId = None
        self._TenantId = None
        self._DatasourceIdList = None
        self._DatasourceTypeList = None
        self._CycleUnitList = None
        self._CanSubmit = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Page(self):
        return self._Page

    @Page.setter
    def Page(self, Page):
        self._Page = Page

    @property
    def Size(self):
        return self._Size

    @Size.setter
    def Size(self, Size):
        self._Size = Size

    @property
    def StatusList(self):
        return self._StatusList

    @StatusList.setter
    def StatusList(self, StatusList):
        self._StatusList = StatusList

    @property
    def OwnerNameList(self):
        return self._OwnerNameList

    @OwnerNameList.setter
    def OwnerNameList(self, OwnerNameList):
        self._OwnerNameList = OwnerNameList

    @property
    def WorkflowIdList(self):
        return self._WorkflowIdList

    @WorkflowIdList.setter
    def WorkflowIdList(self, WorkflowIdList):
        self._WorkflowIdList = WorkflowIdList

    @property
    def TaskNameFilter(self):
        return self._TaskNameFilter

    @TaskNameFilter.setter
    def TaskNameFilter(self, TaskNameFilter):
        self._TaskNameFilter = TaskNameFilter

    @property
    def TaskTypeList(self):
        return self._TaskTypeList

    @TaskTypeList.setter
    def TaskTypeList(self, TaskTypeList):
        self._TaskTypeList = TaskTypeList

    @property
    def FordIdList(self):
        return self._FordIdList

    @FordIdList.setter
    def FordIdList(self, FordIdList):
        self._FordIdList = FordIdList

    @property
    def TaskIdFilter(self):
        return self._TaskIdFilter

    @TaskIdFilter.setter
    def TaskIdFilter(self, TaskIdFilter):
        self._TaskIdFilter = TaskIdFilter

    @property
    def OwnerNameFilter(self):
        return self._OwnerNameFilter

    @OwnerNameFilter.setter
    def OwnerNameFilter(self, OwnerNameFilter):
        self._OwnerNameFilter = OwnerNameFilter

    @property
    def SortItem(self):
        return self._SortItem

    @SortItem.setter
    def SortItem(self, SortItem):
        self._SortItem = SortItem

    @property
    def SortType(self):
        return self._SortType

    @SortType.setter
    def SortType(self, SortType):
        self._SortType = SortType

    @property
    def DataEngineList(self):
        return self._DataEngineList

    @DataEngineList.setter
    def DataEngineList(self, DataEngineList):
        self._DataEngineList = DataEngineList

    @property
    def UserId(self):
        return self._UserId

    @UserId.setter
    def UserId(self, UserId):
        self._UserId = UserId

    @property
    def OwnerId(self):
        return self._OwnerId

    @OwnerId.setter
    def OwnerId(self, OwnerId):
        self._OwnerId = OwnerId

    @property
    def TenantId(self):
        return self._TenantId

    @TenantId.setter
    def TenantId(self, TenantId):
        self._TenantId = TenantId

    @property
    def DatasourceIdList(self):
        return self._DatasourceIdList

    @DatasourceIdList.setter
    def DatasourceIdList(self, DatasourceIdList):
        self._DatasourceIdList = DatasourceIdList

    @property
    def DatasourceTypeList(self):
        return self._DatasourceTypeList

    @DatasourceTypeList.setter
    def DatasourceTypeList(self, DatasourceTypeList):
        self._DatasourceTypeList = DatasourceTypeList

    @property
    def CycleUnitList(self):
        return self._CycleUnitList

    @CycleUnitList.setter
    def CycleUnitList(self, CycleUnitList):
        self._CycleUnitList = CycleUnitList

    @property
    def CanSubmit(self):
        return self._CanSubmit

    @CanSubmit.setter
    def CanSubmit(self, CanSubmit):
        self._CanSubmit = CanSubmit


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._Page = params.get("Page")
        self._Size = params.get("Size")
        self._StatusList = params.get("StatusList")
        self._OwnerNameList = params.get("OwnerNameList")
        self._WorkflowIdList = params.get("WorkflowIdList")
        self._TaskNameFilter = params.get("TaskNameFilter")
        self._TaskTypeList = params.get("TaskTypeList")
        self._FordIdList = params.get("FordIdList")
        self._TaskIdFilter = params.get("TaskIdFilter")
        self._OwnerNameFilter = params.get("OwnerNameFilter")
        self._SortItem = params.get("SortItem")
        self._SortType = params.get("SortType")
        self._DataEngineList = params.get("DataEngineList")
        self._UserId = params.get("UserId")
        self._OwnerId = params.get("OwnerId")
        self._TenantId = params.get("TenantId")
        self._DatasourceIdList = params.get("DatasourceIdList")
        self._DatasourceTypeList = params.get("DatasourceTypeList")
        self._CycleUnitList = params.get("CycleUnitList")
        self._CanSubmit = params.get("CanSubmit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBatchOperateTaskResponse(AbstractModel):
    """DescribeBatchOperateTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 无
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.DescribeBatchOperateTaskPage`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeBatchOperateTaskPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeBelongToRequest(AbstractModel):
    """DescribeBelongTo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._ProjectId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBelongToResponse(AbstractModel):
    """DescribeBelongTo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 所属任务/基线
        :type Data: list of str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DescribeClusterNamespaceListRequest(AbstractModel):
    """DescribeClusterNamespaceList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _ProjectId: WeData项目ID
        :type ProjectId: str
        """
        self._ClusterId = None
        self._ProjectId = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClusterNamespaceListResponse(AbstractModel):
    """DescribeClusterNamespaceList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Namespaces: 命名空间
        :type Namespaces: list of Namespace
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Namespaces = None
        self._RequestId = None

    @property
    def Namespaces(self):
        return self._Namespaces

    @Namespaces.setter
    def Namespaces(self, Namespaces):
        self._Namespaces = Namespaces

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Namespaces") is not None:
            self._Namespaces = []
            for item in params.get("Namespaces"):
                obj = Namespace()
                obj._deserialize(item)
                self._Namespaces.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeColumnLineageRequest(AbstractModel):
    """DescribeColumnLineage请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Direction: 查询方向，INPUT,OUTPUT,BOTH枚举值
        :type Direction: str
        :param _Data: 字段信息
        :type Data: :class:`tencentcloud.wedata.v20210820.models.ColumnLineageInfo`
        :param _InputDepth: 单次查询入度
        :type InputDepth: int
        :param _OutputDepth: 单次查询出度
        :type OutputDepth: int
        :param _ExtParams: 额外参数（传递调用方信息）
        :type ExtParams: list of RecordField
        :param _IgnoreTemp: 是否过滤临时表 默认值为true
        :type IgnoreTemp: bool
        """
        self._Direction = None
        self._Data = None
        self._InputDepth = None
        self._OutputDepth = None
        self._ExtParams = None
        self._IgnoreTemp = None

    @property
    def Direction(self):
        return self._Direction

    @Direction.setter
    def Direction(self, Direction):
        self._Direction = Direction

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def InputDepth(self):
        return self._InputDepth

    @InputDepth.setter
    def InputDepth(self, InputDepth):
        self._InputDepth = InputDepth

    @property
    def OutputDepth(self):
        return self._OutputDepth

    @OutputDepth.setter
    def OutputDepth(self, OutputDepth):
        self._OutputDepth = OutputDepth

    @property
    def ExtParams(self):
        return self._ExtParams

    @ExtParams.setter
    def ExtParams(self, ExtParams):
        self._ExtParams = ExtParams

    @property
    def IgnoreTemp(self):
        return self._IgnoreTemp

    @IgnoreTemp.setter
    def IgnoreTemp(self, IgnoreTemp):
        self._IgnoreTemp = IgnoreTemp


    def _deserialize(self, params):
        self._Direction = params.get("Direction")
        if params.get("Data") is not None:
            self._Data = ColumnLineageInfo()
            self._Data._deserialize(params.get("Data"))
        self._InputDepth = params.get("InputDepth")
        self._OutputDepth = params.get("OutputDepth")
        if params.get("ExtParams") is not None:
            self._ExtParams = []
            for item in params.get("ExtParams"):
                obj = RecordField()
                obj._deserialize(item)
                self._ExtParams.append(obj)
        self._IgnoreTemp = params.get("IgnoreTemp")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeColumnLineageResponse(AbstractModel):
    """DescribeColumnLineage返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ColumnAggregationLineage: 字段血缘信息
注意：此字段可能返回 null，表示取不到有效值。
        :type ColumnAggregationLineage: :class:`tencentcloud.wedata.v20210820.models.ColumnAggregationLineage`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ColumnAggregationLineage = None
        self._RequestId = None

    @property
    def ColumnAggregationLineage(self):
        return self._ColumnAggregationLineage

    @ColumnAggregationLineage.setter
    def ColumnAggregationLineage(self, ColumnAggregationLineage):
        self._ColumnAggregationLineage = ColumnAggregationLineage

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ColumnAggregationLineage") is not None:
            self._ColumnAggregationLineage = ColumnAggregationLineage()
            self._ColumnAggregationLineage._deserialize(params.get("ColumnAggregationLineage"))
        self._RequestId = params.get("RequestId")


class DescribeColumnsMetaRequest(AbstractModel):
    """DescribeColumnsMeta请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TableId: 表ID
        :type TableId: str
        :param _PageNumber: 页码
        :type PageNumber: int
        :param _PageSize: 每页大小
        :type PageSize: int
        :param _FilterSet: 过滤器
        :type FilterSet: list of Filter
        :param _OrderFieldSet: 排序字段
        :type OrderFieldSet: list of OrderField
        :param _IsPartitionQuery: 是否查询分区字段，默认false
        :type IsPartitionQuery: bool
        :param _ComplianceId: 合规组ID
        :type ComplianceId: int
        """
        self._TableId = None
        self._PageNumber = None
        self._PageSize = None
        self._FilterSet = None
        self._OrderFieldSet = None
        self._IsPartitionQuery = None
        self._ComplianceId = None

    @property
    def TableId(self):
        return self._TableId

    @TableId.setter
    def TableId(self, TableId):
        self._TableId = TableId

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def FilterSet(self):
        return self._FilterSet

    @FilterSet.setter
    def FilterSet(self, FilterSet):
        self._FilterSet = FilterSet

    @property
    def OrderFieldSet(self):
        return self._OrderFieldSet

    @OrderFieldSet.setter
    def OrderFieldSet(self, OrderFieldSet):
        self._OrderFieldSet = OrderFieldSet

    @property
    def IsPartitionQuery(self):
        return self._IsPartitionQuery

    @IsPartitionQuery.setter
    def IsPartitionQuery(self, IsPartitionQuery):
        self._IsPartitionQuery = IsPartitionQuery

    @property
    def ComplianceId(self):
        return self._ComplianceId

    @ComplianceId.setter
    def ComplianceId(self, ComplianceId):
        self._ComplianceId = ComplianceId


    def _deserialize(self, params):
        self._TableId = params.get("TableId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("FilterSet") is not None:
            self._FilterSet = []
            for item in params.get("FilterSet"):
                obj = Filter()
                obj._deserialize(item)
                self._FilterSet.append(obj)
        if params.get("OrderFieldSet") is not None:
            self._OrderFieldSet = []
            for item in params.get("OrderFieldSet"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFieldSet.append(obj)
        self._IsPartitionQuery = params.get("IsPartitionQuery")
        self._ComplianceId = params.get("ComplianceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeColumnsMetaResponse(AbstractModel):
    """DescribeColumnsMeta返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ColumnMetaSet: 分页返回的
注意：此字段可能返回 null，表示取不到有效值。
        :type ColumnMetaSet: list of ColumnMeta
        :param _TotalCount: 总记录数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ColumnMetaSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def ColumnMetaSet(self):
        return self._ColumnMetaSet

    @ColumnMetaSet.setter
    def ColumnMetaSet(self, ColumnMetaSet):
        self._ColumnMetaSet = ColumnMetaSet

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ColumnMetaSet") is not None:
            self._ColumnMetaSet = []
            for item in params.get("ColumnMetaSet"):
                obj = ColumnMeta()
                obj._deserialize(item)
                self._ColumnMetaSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeDataBasesRequest(AbstractModel):
    """DescribeDataBases请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _DatasourceId: 数据源id
        :type DatasourceId: str
        :param _DsTypes: 数据源类型
        :type DsTypes: list of int non-negative
        """
        self._ProjectId = None
        self._DatasourceId = None
        self._DsTypes = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def DsTypes(self):
        return self._DsTypes

    @DsTypes.setter
    def DsTypes(self, DsTypes):
        self._DsTypes = DsTypes


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._DatasourceId = params.get("DatasourceId")
        self._DsTypes = params.get("DsTypes")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDataBasesResponse(AbstractModel):
    """DescribeDataBases返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 数据来源数据数据库列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of DatabaseInfo
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = DatabaseInfo()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDataCheckStatRequest(AbstractModel):
    """DescribeDataCheckStat请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project id
        :type ProjectId: str
        :param _BeginDate: 开始时间，时间戳到秒
        :type BeginDate: str
        :param _EndDate: 结束时间，时间戳到秒
        :type EndDate: str
        """
        self._ProjectId = None
        self._BeginDate = None
        self._EndDate = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def BeginDate(self):
        return self._BeginDate

    @BeginDate.setter
    def BeginDate(self, BeginDate):
        self._BeginDate = BeginDate

    @property
    def EndDate(self):
        return self._EndDate

    @EndDate.setter
    def EndDate(self, EndDate):
        self._EndDate = EndDate


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._BeginDate = params.get("BeginDate")
        self._EndDate = params.get("EndDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDataCheckStatResponse(AbstractModel):
    """DescribeDataCheckStat返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 结果
        :type Data: :class:`tencentcloud.wedata.v20210820.models.DataCheckStat`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DataCheckStat()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeDataObjectsRequest(AbstractModel):
    """DescribeDataObjects请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DatasourceId: 数据来源ID
        :type DatasourceId: str
        :param _TableId: 数据表ID
        :type TableId: str
        :param _RuleGroupId: 质量规则组ID
        :type RuleGroupId: int
        :param _ProjectId: 项目ID
        :type ProjectId: str
        """
        self._DatasourceId = None
        self._TableId = None
        self._RuleGroupId = None
        self._ProjectId = None

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def TableId(self):
        return self._TableId

    @TableId.setter
    def TableId(self, TableId):
        self._TableId = TableId

    @property
    def RuleGroupId(self):
        return self._RuleGroupId

    @RuleGroupId.setter
    def RuleGroupId(self, RuleGroupId):
        self._RuleGroupId = RuleGroupId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._DatasourceId = params.get("DatasourceId")
        self._TableId = params.get("TableId")
        self._RuleGroupId = params.get("RuleGroupId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDataObjectsResponse(AbstractModel):
    """DescribeDataObjects返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 数据对象列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of SourceObject
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = SourceObject()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDataSourceInfoListRequest(AbstractModel):
    """DescribeDataSourceInfoList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _PageNumber: 页码
        :type PageNumber: int
        :param _PageSize: 页数
        :type PageSize: int
        :param _Filters: 过滤条件（暂不支持）
        :type Filters: :class:`tencentcloud.wedata.v20210820.models.Filter`
        :param _OrderFields: 排序配置
        :type OrderFields: :class:`tencentcloud.wedata.v20210820.models.OrderField`
        :param _Type: 数据源类型，必选（如MYSQL、DLC等）
        :type Type: str
        :param _DatasourceName: 数据源名称过滤
        :type DatasourceName: str
        """
        self._ProjectId = None
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None
        self._OrderFields = None
        self._Type = None
        self._DatasourceName = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def DatasourceName(self):
        return self._DatasourceName

    @DatasourceName.setter
    def DatasourceName(self, DatasourceName):
        self._DatasourceName = DatasourceName


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = Filter()
            self._Filters._deserialize(params.get("Filters"))
        if params.get("OrderFields") is not None:
            self._OrderFields = OrderField()
            self._OrderFields._deserialize(params.get("OrderFields"))
        self._Type = params.get("Type")
        self._DatasourceName = params.get("DatasourceName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDataSourceInfoListResponse(AbstractModel):
    """DescribeDataSourceInfoList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总条数。
        :type TotalCount: int
        :param _DatasourceSet: 数据源信息列表。
注意：此字段可能返回 null，表示取不到有效值。
        :type DatasourceSet: list of DatasourceBaseInfo
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._DatasourceSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DatasourceSet(self):
        return self._DatasourceSet

    @DatasourceSet.setter
    def DatasourceSet(self, DatasourceSet):
        self._DatasourceSet = DatasourceSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DatasourceSet") is not None:
            self._DatasourceSet = []
            for item in params.get("DatasourceSet"):
                obj = DatasourceBaseInfo()
                obj._deserialize(item)
                self._DatasourceSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDataSourceListRequest(AbstractModel):
    """DescribeDataSourceList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PageNumber: 页码
        :type PageNumber: int
        :param _PageSize: 返回数量
        :type PageSize: int
        :param _OrderFields: 排序配置
        :type OrderFields: list of OrderField
        :param _Filters: 可选过滤条件，Filter可选配置(参考): "Name": { "type": "string", "description": "数据源名称" }, "Type": { "type": "string", "description": "类型" }, "ClusterId": { "type": "string", "description": "集群id" }, "CategoryId": { "type": "string", "description": "分类，项目或空间id" }
        :type Filters: list of Filter
        """
        self._PageNumber = None
        self._PageSize = None
        self._OrderFields = None
        self._Filters = None

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDataSourceListResponse(AbstractModel):
    """DescribeDataSourceList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 数据源列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.DataSourceInfoPage`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DataSourceInfoPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeDataSourceWithoutInfoRequest(AbstractModel):
    """DescribeDataSourceWithoutInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _OrderFields: 1
        :type OrderFields: list of OrderField
        :param _Filters: 1
        :type Filters: list of Filter
        """
        self._OrderFields = None
        self._Filters = None

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDataSourceWithoutInfoResponse(AbstractModel):
    """DescribeDataSourceWithoutInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 1
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of DataSourceInfo
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = DataSourceInfo()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDataTypesRequest(AbstractModel):
    """DescribeDataTypes请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DatasourceType: 数据源类型，MYSQL|HIVE|KAFKA|POSTGRE|CDW|ORACLE|SQLSERVER|FTP|HDFS|ICEBERG|HBASE|TDSQL|TDSQLC|SPARK|VIRTUAL|TBASE|DB2|DM|GAUSSDB|GBASE|IMPALA|ES|S3_DATAINSIGHT|GREENPLUM|PHOENIX|SAP_HANA|SFTP|OCEANBASE|CLICKHOUSE|KUDU|VERTICA|REDIS|COS|DLC|DORIS|CKAFKA|MONGODB|FTP_FILE|HDFS_FILE|DTS_KAFKA|REST_API|FILE|TIDB|SYBASE|TCHOUSE_X 等
        :type DatasourceType: str
        :param _ProjectId: 项目ID。
        :type ProjectId: str
        """
        self._DatasourceType = None
        self._ProjectId = None

    @property
    def DatasourceType(self):
        return self._DatasourceType

    @DatasourceType.setter
    def DatasourceType(self, DatasourceType):
        self._DatasourceType = DatasourceType

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._DatasourceType = params.get("DatasourceType")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDataTypesResponse(AbstractModel):
    """DescribeDataTypes返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TypeInfoSet: 字段类型列表。
        :type TypeInfoSet: list of Label
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TypeInfoSet = None
        self._RequestId = None

    @property
    def TypeInfoSet(self):
        return self._TypeInfoSet

    @TypeInfoSet.setter
    def TypeInfoSet(self, TypeInfoSet):
        self._TypeInfoSet = TypeInfoSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TypeInfoSet") is not None:
            self._TypeInfoSet = []
            for item in params.get("TypeInfoSet"):
                obj = Label()
                obj._deserialize(item)
                self._TypeInfoSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDatabaseInfoListRequest(AbstractModel):
    """DescribeDatabaseInfoList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤参数
        :type Filters: list of Filter
        :param _ConnectionType: 连接类型
        :type ConnectionType: str
        """
        self._Filters = None
        self._ConnectionType = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def ConnectionType(self):
        return self._ConnectionType

    @ConnectionType.setter
    def ConnectionType(self, ConnectionType):
        self._ConnectionType = ConnectionType


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._ConnectionType = params.get("ConnectionType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDatabaseInfoListResponse(AbstractModel):
    """DescribeDatabaseInfoList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DatabaseInfo: 数据库列表
        :type DatabaseInfo: list of DatabaseInfo
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DatabaseInfo = None
        self._RequestId = None

    @property
    def DatabaseInfo(self):
        return self._DatabaseInfo

    @DatabaseInfo.setter
    def DatabaseInfo(self, DatabaseInfo):
        self._DatabaseInfo = DatabaseInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DatabaseInfo") is not None:
            self._DatabaseInfo = []
            for item in params.get("DatabaseInfo"):
                obj = DatabaseInfo()
                obj._deserialize(item)
                self._DatabaseInfo.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDatabaseMetasRequest(AbstractModel):
    """DescribeDatabaseMetas请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤字段，projectIds/msTypes/createTime/modifiedTime
        :type Filters: list of Filter
        :param _OrderFields: 排序字段，如name
        :type OrderFields: list of OrderField
        """
        self._Filters = None
        self._OrderFields = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDatabaseMetasResponse(AbstractModel):
    """DescribeDatabaseMetas返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DatabaseMeta: 无
注意：此字段可能返回 null，表示取不到有效值。
        :type DatabaseMeta: list of DatabaseMeta
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DatabaseMeta = None
        self._RequestId = None

    @property
    def DatabaseMeta(self):
        return self._DatabaseMeta

    @DatabaseMeta.setter
    def DatabaseMeta(self, DatabaseMeta):
        self._DatabaseMeta = DatabaseMeta

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DatabaseMeta") is not None:
            self._DatabaseMeta = []
            for item in params.get("DatabaseMeta"):
                obj = DatabaseMeta()
                obj._deserialize(item)
                self._DatabaseMeta.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDatasourceRequest(AbstractModel):
    """DescribeDatasource请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 对象唯一ID
        :type Id: int
        """
        self._Id = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDatasourceResponse(AbstractModel):
    """DescribeDatasource返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 数据源对象
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.DataSourceInfo`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DataSourceInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeDependOpsTaskListRequest(AbstractModel):
    """DescribeDependOpsTaskList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._TaskId = None
        self._ProjectId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDependOpsTaskListResponse(AbstractModel):
    """DescribeDependOpsTaskList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 任务列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of TaskOpsDto
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = TaskOpsDto()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDependOpsTasksRequest(AbstractModel):
    """DescribeDependOpsTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务Id
        :type TaskId: str
        :param _Deep: 上游/下游层级1-6级
        :type Deep: int
        :param _Up: 1: 表示查询上游节点；0:表示查询下游节点；2：表示查询上游和下游节点
        :type Up: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _WorkflowId: 任务工作流id
        :type WorkflowId: str
        """
        self._TaskId = None
        self._Deep = None
        self._Up = None
        self._ProjectId = None
        self._WorkflowId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Deep(self):
        return self._Deep

    @Deep.setter
    def Deep(self, Deep):
        self._Deep = Deep

    @property
    def Up(self):
        return self._Up

    @Up.setter
    def Up(self, Up):
        self._Up = Up

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Deep = params.get("Deep")
        self._Up = params.get("Up")
        self._ProjectId = params.get("ProjectId")
        self._WorkflowId = params.get("WorkflowId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDependOpsTasksResponse(AbstractModel):
    """DescribeDependOpsTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 画布任务和链接信息
        :type Data: :class:`tencentcloud.wedata.v20210820.models.OpsTaskCanvasInfoList`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = OpsTaskCanvasInfoList()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeDependTaskListsRequest(AbstractModel):
    """DescribeDependTaskLists请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskIds: 任务Id列表
        :type TaskIds: list of str
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._TaskIds = None
        self._ProjectId = None

    @property
    def TaskIds(self):
        return self._TaskIds

    @TaskIds.setter
    def TaskIds(self, TaskIds):
        self._TaskIds = TaskIds

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskIds = params.get("TaskIds")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDependTaskListsResponse(AbstractModel):
    """DescribeDependTaskLists返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 删除结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of TaskOpsDto
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = TaskOpsDto()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDependTasksNewRequest(AbstractModel):
    """DescribeDependTasksNew请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务Id
        :type TaskId: str
        :param _Deep: 上游/下游层级1-6级
        :type Deep: int
        :param _Up: 1: 表示查询上游节点；0:表示查询下游节点；2：表示查询上游和下游节点
        :type Up: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _WorkflowId: 任务工作流id
        :type WorkflowId: str
        """
        self._TaskId = None
        self._Deep = None
        self._Up = None
        self._ProjectId = None
        self._WorkflowId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Deep(self):
        return self._Deep

    @Deep.setter
    def Deep(self, Deep):
        self._Deep = Deep

    @property
    def Up(self):
        return self._Up

    @Up.setter
    def Up(self, Up):
        self._Up = Up

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Deep = params.get("Deep")
        self._Up = params.get("Up")
        self._ProjectId = params.get("ProjectId")
        self._WorkflowId = params.get("WorkflowId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDependTasksNewResponse(AbstractModel):
    """DescribeDependTasksNew返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 画布任务和链接信息
        :type Data: :class:`tencentcloud.wedata.v20210820.models.CanvasInfo`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = CanvasInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeDiagnosticInfoByBaselineIdRequest(AbstractModel):
    """DescribeDiagnosticInfoByBaselineId请求参数结构体

    """

    def __init__(self):
        r"""
        :param _BaselineId: 基线id
        :type BaselineId: str
        :param _ProjectId: 1
        :type ProjectId: str
        """
        self._BaselineId = None
        self._ProjectId = None

    @property
    def BaselineId(self):
        return self._BaselineId

    @BaselineId.setter
    def BaselineId(self, BaselineId):
        self._BaselineId = BaselineId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._BaselineId = params.get("BaselineId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDiagnosticInfoByBaselineIdResponse(AbstractModel):
    """DescribeDiagnosticInfoByBaselineId返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 基线任务dag
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.DescribeDiagnosticInfoResponse`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeDiagnosticInfoResponse()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeDiagnosticInfoResponse(AbstractModel):
    """DescribeDiagnosticInfoResponse

    """

    def __init__(self):
        r"""
        :param _BaselineTasks: 1
注意：此字段可能返回 null，表示取不到有效值。
        :type BaselineTasks: list of BaselineTaskDto
        """
        self._BaselineTasks = None

    @property
    def BaselineTasks(self):
        return self._BaselineTasks

    @BaselineTasks.setter
    def BaselineTasks(self, BaselineTasks):
        self._BaselineTasks = BaselineTasks


    def _deserialize(self, params):
        if params.get("BaselineTasks") is not None:
            self._BaselineTasks = []
            for item in params.get("BaselineTasks"):
                obj = BaselineTaskDto()
                obj._deserialize(item)
                self._BaselineTasks.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDimensionScoreRequest(AbstractModel):
    """DescribeDimensionScore请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StatisticsDate: 统计日期 时间戳
        :type StatisticsDate: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _DatasourceId: 数据来源id
        :type DatasourceId: str
        :param _Filters: 过滤参数
        :type Filters: list of Filter
        """
        self._StatisticsDate = None
        self._ProjectId = None
        self._DatasourceId = None
        self._Filters = None

    @property
    def StatisticsDate(self):
        return self._StatisticsDate

    @StatisticsDate.setter
    def StatisticsDate(self, StatisticsDate):
        self._StatisticsDate = StatisticsDate

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._StatisticsDate = params.get("StatisticsDate")
        self._ProjectId = params.get("ProjectId")
        self._DatasourceId = params.get("DatasourceId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDimensionScoreResponse(AbstractModel):
    """DescribeDimensionScore返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 维度评分
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.DimensionScore`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DimensionScore()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeDrInstancePageRequest(AbstractModel):
    """DescribeDrInstancePage请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _TaskSource: 任务来源 ADHOC || WORKFLOW
        :type TaskSource: str
        :param _PageIndex: 索引页码
        :type PageIndex: int
        :param _PageSize: 页面大小
        :type PageSize: int
        :param _TaskName: 任务名称
        :type TaskName: str
        :param _StartTime: 提交开始时间 yyyy-MM-dd HH:mm:ss
        :type StartTime: str
        :param _EndTime: 提交结束时间 yyyy-MM-dd HH:mm:ss
        :type EndTime: str
        :param _FolderIds: 文件夹id
        :type FolderIds: list of str
        :param _WorkflowIds: 工作流id
        :type WorkflowIds: list of str
        :param _JustMe: 只看我的
        :type JustMe: bool
        :param _TaskTypes: 任务类型
        :type TaskTypes: list of str
        :param _SubmitUsers: 试运行提交人userId列表
        :type SubmitUsers: list of str
        :param _StatusList: 试运行状态
        :type StatusList: list of str
        """
        self._ProjectId = None
        self._TaskSource = None
        self._PageIndex = None
        self._PageSize = None
        self._TaskName = None
        self._StartTime = None
        self._EndTime = None
        self._FolderIds = None
        self._WorkflowIds = None
        self._JustMe = None
        self._TaskTypes = None
        self._SubmitUsers = None
        self._StatusList = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskSource(self):
        return self._TaskSource

    @TaskSource.setter
    def TaskSource(self, TaskSource):
        self._TaskSource = TaskSource

    @property
    def PageIndex(self):
        return self._PageIndex

    @PageIndex.setter
    def PageIndex(self, PageIndex):
        self._PageIndex = PageIndex

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def TaskName(self):
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def FolderIds(self):
        return self._FolderIds

    @FolderIds.setter
    def FolderIds(self, FolderIds):
        self._FolderIds = FolderIds

    @property
    def WorkflowIds(self):
        return self._WorkflowIds

    @WorkflowIds.setter
    def WorkflowIds(self, WorkflowIds):
        self._WorkflowIds = WorkflowIds

    @property
    def JustMe(self):
        return self._JustMe

    @JustMe.setter
    def JustMe(self, JustMe):
        self._JustMe = JustMe

    @property
    def TaskTypes(self):
        return self._TaskTypes

    @TaskTypes.setter
    def TaskTypes(self, TaskTypes):
        self._TaskTypes = TaskTypes

    @property
    def SubmitUsers(self):
        return self._SubmitUsers

    @SubmitUsers.setter
    def SubmitUsers(self, SubmitUsers):
        self._SubmitUsers = SubmitUsers

    @property
    def StatusList(self):
        return self._StatusList

    @StatusList.setter
    def StatusList(self, StatusList):
        self._StatusList = StatusList


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TaskSource = params.get("TaskSource")
        self._PageIndex = params.get("PageIndex")
        self._PageSize = params.get("PageSize")
        self._TaskName = params.get("TaskName")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._FolderIds = params.get("FolderIds")
        self._WorkflowIds = params.get("WorkflowIds")
        self._JustMe = params.get("JustMe")
        self._TaskTypes = params.get("TaskTypes")
        self._SubmitUsers = params.get("SubmitUsers")
        self._StatusList = params.get("StatusList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDrInstancePageResponse(AbstractModel):
    """DescribeDrInstancePage返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 结果集
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.DrInstanceOpsDtoPage`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DrInstanceOpsDtoPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeDrInstanceScriptContentRequest(AbstractModel):
    """DescribeDrInstanceScriptContent请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _TaskSource: 任务来源 ADHOC || WORKFLOW
        :type TaskSource: str
        :param _RecordId: 试运行记录id
        :type RecordId: int
        :param _SonRecordId: 试运行子记录id
        :type SonRecordId: int
        """
        self._ProjectId = None
        self._TaskSource = None
        self._RecordId = None
        self._SonRecordId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskSource(self):
        return self._TaskSource

    @TaskSource.setter
    def TaskSource(self, TaskSource):
        self._TaskSource = TaskSource

    @property
    def RecordId(self):
        return self._RecordId

    @RecordId.setter
    def RecordId(self, RecordId):
        self._RecordId = RecordId

    @property
    def SonRecordId(self):
        return self._SonRecordId

    @SonRecordId.setter
    def SonRecordId(self, SonRecordId):
        self._SonRecordId = SonRecordId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TaskSource = params.get("TaskSource")
        self._RecordId = params.get("RecordId")
        self._SonRecordId = params.get("SonRecordId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDrInstanceScriptContentResponse(AbstractModel):
    """DescribeDrInstanceScriptContent返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 结果集
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.DrInstanceOpsDto`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DrInstanceOpsDto()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeDrSonInstanceRequest(AbstractModel):
    """DescribeDrSonInstance请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _TaskSource: 任务来源 ADHOC || WORKFLOW
        :type TaskSource: str
        :param _RecordId: 试运行记录id
        :type RecordId: int
        """
        self._ProjectId = None
        self._TaskSource = None
        self._RecordId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskSource(self):
        return self._TaskSource

    @TaskSource.setter
    def TaskSource(self, TaskSource):
        self._TaskSource = TaskSource

    @property
    def RecordId(self):
        return self._RecordId

    @RecordId.setter
    def RecordId(self, RecordId):
        self._RecordId = RecordId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TaskSource = params.get("TaskSource")
        self._RecordId = params.get("RecordId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDrSonInstanceResponse(AbstractModel):
    """DescribeDrSonInstance返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 结果集
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of DrInstanceOpsDto
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = DrInstanceOpsDto()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDsFolderTreeRequest(AbstractModel):
    """DescribeDsFolderTree请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _FirstLevelPull: 是否一级拉取 true 是 
false 否
        :type FirstLevelPull: bool
        :param _FolderId: 文件夹ID
        :type FolderId: str
        :param _WorkflowId: 工作流ID
        :type WorkflowId: str
        :param _Keyword: 关键字搜索
        :type Keyword: str
        :param _IncludeWorkflow: 是否包含工作流 true 是 
false 否
        :type IncludeWorkflow: bool
        :param _IncludeTask: 是否包含任务 true 是 
false 否
        :type IncludeTask: bool
        :param _IncludeVirtualTask: 是否包含虚拟任务，当 IncludeTask 为 true 的时候，该参数才生效，默认为 true
        :type IncludeVirtualTask: bool
        :param _TaskFolderId: 任务目录id
        :type TaskFolderId: str
        :param _DisplayType: classification.分类展示  catalog.目录展示
        :type DisplayType: str
        :param _IncludeTaskFolder: 是否包含任务目录 true 是 
false 否
        :type IncludeTaskFolder: bool
        """
        self._ProjectId = None
        self._FirstLevelPull = None
        self._FolderId = None
        self._WorkflowId = None
        self._Keyword = None
        self._IncludeWorkflow = None
        self._IncludeTask = None
        self._IncludeVirtualTask = None
        self._TaskFolderId = None
        self._DisplayType = None
        self._IncludeTaskFolder = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def FirstLevelPull(self):
        return self._FirstLevelPull

    @FirstLevelPull.setter
    def FirstLevelPull(self, FirstLevelPull):
        self._FirstLevelPull = FirstLevelPull

    @property
    def FolderId(self):
        return self._FolderId

    @FolderId.setter
    def FolderId(self, FolderId):
        self._FolderId = FolderId

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId

    @property
    def Keyword(self):
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword

    @property
    def IncludeWorkflow(self):
        return self._IncludeWorkflow

    @IncludeWorkflow.setter
    def IncludeWorkflow(self, IncludeWorkflow):
        self._IncludeWorkflow = IncludeWorkflow

    @property
    def IncludeTask(self):
        return self._IncludeTask

    @IncludeTask.setter
    def IncludeTask(self, IncludeTask):
        self._IncludeTask = IncludeTask

    @property
    def IncludeVirtualTask(self):
        return self._IncludeVirtualTask

    @IncludeVirtualTask.setter
    def IncludeVirtualTask(self, IncludeVirtualTask):
        self._IncludeVirtualTask = IncludeVirtualTask

    @property
    def TaskFolderId(self):
        return self._TaskFolderId

    @TaskFolderId.setter
    def TaskFolderId(self, TaskFolderId):
        self._TaskFolderId = TaskFolderId

    @property
    def DisplayType(self):
        return self._DisplayType

    @DisplayType.setter
    def DisplayType(self, DisplayType):
        self._DisplayType = DisplayType

    @property
    def IncludeTaskFolder(self):
        return self._IncludeTaskFolder

    @IncludeTaskFolder.setter
    def IncludeTaskFolder(self, IncludeTaskFolder):
        self._IncludeTaskFolder = IncludeTaskFolder


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._FirstLevelPull = params.get("FirstLevelPull")
        self._FolderId = params.get("FolderId")
        self._WorkflowId = params.get("WorkflowId")
        self._Keyword = params.get("Keyword")
        self._IncludeWorkflow = params.get("IncludeWorkflow")
        self._IncludeTask = params.get("IncludeTask")
        self._IncludeVirtualTask = params.get("IncludeVirtualTask")
        self._TaskFolderId = params.get("TaskFolderId")
        self._DisplayType = params.get("DisplayType")
        self._IncludeTaskFolder = params.get("IncludeTaskFolder")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDsFolderTreeResponse(AbstractModel):
    """DescribeDsFolderTree返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 统一树结构返回属性列表
        :type Data: list of PathNodeDsVO
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = PathNodeDsVO()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDsParentFolderTreeRequest(AbstractModel):
    """DescribeDsParentFolderTree请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _FolderId: 文件夹ID
        :type FolderId: str
        :param _WorkflowId: 工作流ID
        :type WorkflowId: str
        :param _TaskId: 任务id
        :type TaskId: str
        :param _DisplayType:  classification:分类展示  catalog:目录展示
        :type DisplayType: str
        """
        self._ProjectId = None
        self._FolderId = None
        self._WorkflowId = None
        self._TaskId = None
        self._DisplayType = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def FolderId(self):
        return self._FolderId

    @FolderId.setter
    def FolderId(self, FolderId):
        self._FolderId = FolderId

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def DisplayType(self):
        return self._DisplayType

    @DisplayType.setter
    def DisplayType(self, DisplayType):
        self._DisplayType = DisplayType


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._FolderId = params.get("FolderId")
        self._WorkflowId = params.get("WorkflowId")
        self._TaskId = params.get("TaskId")
        self._DisplayType = params.get("DisplayType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDsParentFolderTreeResponse(AbstractModel):
    """DescribeDsParentFolderTree返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 统一树结构返回属性列表
        :type Data: list of PathNodeDsVO
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = PathNodeDsVO()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeEventCasesRequest(AbstractModel):
    """DescribeEventCases请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _Category: 事件实例目录,示例取值:
- 已过期: expired
- 未过期: consuming
- 全部: all

        :type Category: str
        :param _PageNumber: 页码
        :type PageNumber: int
        :param _PageSize: 每页数目
        :type PageSize: int
        :param _EventName: 事件名称
        :type EventName: str
        :param _EventType: 事件类型
        :type EventType: str
        :param _EventSubType: 事件分割类型
        :type EventSubType: str
        :param _EventBroadcastType: 事件广播类型
        :type EventBroadcastType: str
        :param _Status: 事件实例状态,示例取值:
- 已消费: COMSUMED
- 已过期: EXPIRED
- 待消费: ACTIVE
- 消费中: CONSUMING
        :type Status: str
        :param _CreationTimeStart: 事件实例最小创建时间
        :type CreationTimeStart: str
        :param _CreationTimeEnd: 事件实例最大创建时间
        :type CreationTimeEnd: str
        :param _EventTriggeredTimeStart: 事件实例最小触发时间
        :type EventTriggeredTimeStart: str
        :param _EventTriggeredTimeEnd: 事件实例最大触发时间
        :type EventTriggeredTimeEnd: str
        :param _LogTimeStart: 事件实例最小消费时间
        :type LogTimeStart: str
        :param _LogTimeEnd: 事件实例最大消费时间
        :type LogTimeEnd: str
        :param _Dimension: 事件实例数据时间
        :type Dimension: str
        :param _TimeToLive: 事件实例有效时间
        :type TimeToLive: str
        :param _SortItem: 排序字段
        :type SortItem: str
        :param _SortType: 排序顺序
        :type SortType: str
        """
        self._ProjectId = None
        self._Category = None
        self._PageNumber = None
        self._PageSize = None
        self._EventName = None
        self._EventType = None
        self._EventSubType = None
        self._EventBroadcastType = None
        self._Status = None
        self._CreationTimeStart = None
        self._CreationTimeEnd = None
        self._EventTriggeredTimeStart = None
        self._EventTriggeredTimeEnd = None
        self._LogTimeStart = None
        self._LogTimeEnd = None
        self._Dimension = None
        self._TimeToLive = None
        self._SortItem = None
        self._SortType = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Category(self):
        return self._Category

    @Category.setter
    def Category(self, Category):
        self._Category = Category

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def EventName(self):
        return self._EventName

    @EventName.setter
    def EventName(self, EventName):
        self._EventName = EventName

    @property
    def EventType(self):
        warnings.warn("parameter `EventType` is deprecated", DeprecationWarning) 

        return self._EventType

    @EventType.setter
    def EventType(self, EventType):
        warnings.warn("parameter `EventType` is deprecated", DeprecationWarning) 

        self._EventType = EventType

    @property
    def EventSubType(self):
        return self._EventSubType

    @EventSubType.setter
    def EventSubType(self, EventSubType):
        self._EventSubType = EventSubType

    @property
    def EventBroadcastType(self):
        warnings.warn("parameter `EventBroadcastType` is deprecated", DeprecationWarning) 

        return self._EventBroadcastType

    @EventBroadcastType.setter
    def EventBroadcastType(self, EventBroadcastType):
        warnings.warn("parameter `EventBroadcastType` is deprecated", DeprecationWarning) 

        self._EventBroadcastType = EventBroadcastType

    @property
    def Status(self):
        warnings.warn("parameter `Status` is deprecated", DeprecationWarning) 

        return self._Status

    @Status.setter
    def Status(self, Status):
        warnings.warn("parameter `Status` is deprecated", DeprecationWarning) 

        self._Status = Status

    @property
    def CreationTimeStart(self):
        return self._CreationTimeStart

    @CreationTimeStart.setter
    def CreationTimeStart(self, CreationTimeStart):
        self._CreationTimeStart = CreationTimeStart

    @property
    def CreationTimeEnd(self):
        return self._CreationTimeEnd

    @CreationTimeEnd.setter
    def CreationTimeEnd(self, CreationTimeEnd):
        self._CreationTimeEnd = CreationTimeEnd

    @property
    def EventTriggeredTimeStart(self):
        return self._EventTriggeredTimeStart

    @EventTriggeredTimeStart.setter
    def EventTriggeredTimeStart(self, EventTriggeredTimeStart):
        self._EventTriggeredTimeStart = EventTriggeredTimeStart

    @property
    def EventTriggeredTimeEnd(self):
        return self._EventTriggeredTimeEnd

    @EventTriggeredTimeEnd.setter
    def EventTriggeredTimeEnd(self, EventTriggeredTimeEnd):
        self._EventTriggeredTimeEnd = EventTriggeredTimeEnd

    @property
    def LogTimeStart(self):
        return self._LogTimeStart

    @LogTimeStart.setter
    def LogTimeStart(self, LogTimeStart):
        self._LogTimeStart = LogTimeStart

    @property
    def LogTimeEnd(self):
        return self._LogTimeEnd

    @LogTimeEnd.setter
    def LogTimeEnd(self, LogTimeEnd):
        self._LogTimeEnd = LogTimeEnd

    @property
    def Dimension(self):
        return self._Dimension

    @Dimension.setter
    def Dimension(self, Dimension):
        self._Dimension = Dimension

    @property
    def TimeToLive(self):
        return self._TimeToLive

    @TimeToLive.setter
    def TimeToLive(self, TimeToLive):
        self._TimeToLive = TimeToLive

    @property
    def SortItem(self):
        return self._SortItem

    @SortItem.setter
    def SortItem(self, SortItem):
        self._SortItem = SortItem

    @property
    def SortType(self):
        return self._SortType

    @SortType.setter
    def SortType(self, SortType):
        self._SortType = SortType


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._Category = params.get("Category")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        self._EventName = params.get("EventName")
        self._EventType = params.get("EventType")
        self._EventSubType = params.get("EventSubType")
        self._EventBroadcastType = params.get("EventBroadcastType")
        self._Status = params.get("Status")
        self._CreationTimeStart = params.get("CreationTimeStart")
        self._CreationTimeEnd = params.get("CreationTimeEnd")
        self._EventTriggeredTimeStart = params.get("EventTriggeredTimeStart")
        self._EventTriggeredTimeEnd = params.get("EventTriggeredTimeEnd")
        self._LogTimeStart = params.get("LogTimeStart")
        self._LogTimeEnd = params.get("LogTimeEnd")
        self._Dimension = params.get("Dimension")
        self._TimeToLive = params.get("TimeToLive")
        self._SortItem = params.get("SortItem")
        self._SortType = params.get("SortType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEventCasesResponse(AbstractModel):
    """DescribeEventCases返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 事件实例分页查询结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.EventCaseAuditLogVOCollection`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = EventCaseAuditLogVOCollection()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeEventConsumeTasksRequest(AbstractModel):
    """DescribeEventConsumeTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _EventCaseId: 事件实例ID
        :type EventCaseId: str
        :param _PageNumber: 页码
        :type PageNumber: int
        :param _PageSize: 每页数目
        :type PageSize: int
        """
        self._EventCaseId = None
        self._PageNumber = None
        self._PageSize = None

    @property
    def EventCaseId(self):
        return self._EventCaseId

    @EventCaseId.setter
    def EventCaseId(self, EventCaseId):
        self._EventCaseId = EventCaseId

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        self._EventCaseId = params.get("EventCaseId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEventConsumeTasksResponse(AbstractModel):
    """DescribeEventConsumeTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 事件消费任务记录列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.EventCaseConsumeLogOptDtoCollection`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = EventCaseConsumeLogOptDtoCollection()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeEventDetailRequest(AbstractModel):
    """DescribeEventDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _EventId: 事件id
        :type EventId: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._EventId = None
        self._ProjectId = None

    @property
    def EventId(self):
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._EventId = params.get("EventId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEventDetailResponse(AbstractModel):
    """DescribeEventDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 事件详情
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.EventDto`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = EventDto()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeEventIsAlarmTypesRequest(AbstractModel):
    """DescribeEventIsAlarmTypes请求参数结构体

    """


class DescribeEventIsAlarmTypesResponse(AbstractModel):
    """DescribeEventIsAlarmTypes返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 是否告警.取值范围

- yes : 表示告警

- no : 表示不告警
        :type Data: list of str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DescribeEventRequest(AbstractModel):
    """DescribeEvent请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _EventName: 事件名称
        :type EventName: str
        """
        self._ProjectId = None
        self._EventName = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def EventName(self):
        return self._EventName

    @EventName.setter
    def EventName(self, EventName):
        self._EventName = EventName


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._EventName = params.get("EventName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEventResponse(AbstractModel):
    """DescribeEvent返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 事件
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.EventOpsDto`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = EventOpsDto()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeEventTypesRequest(AbstractModel):
    """DescribeEventTypes请求参数结构体

    """


class DescribeEventTypesResponse(AbstractModel):
    """DescribeEventTypes返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 事件类型
        :type Data: list of str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DescribeEventsRequest(AbstractModel):
    """DescribeEvents请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PageNumber: 分页页码
        :type PageNumber: int
        :param _PageSize: 分页大小
        :type PageSize: int
        :param _Filters: 过滤字段
        :type Filters: list of Filter
        :param _OrderFields: 排序字段
        :type OrderFields: list of OrderField
        """
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None
        self._OrderFields = None

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields


    def _deserialize(self, params):
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEventsResponse(AbstractModel):
    """DescribeEvents返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 事件列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.EventPage`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = EventPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeExecStrategyRequest(AbstractModel):
    """DescribeExecStrategy请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleGroupId: 规则组Id
        :type RuleGroupId: int
        :param _ProjectId: 项目Id
        :type ProjectId: str
        """
        self._RuleGroupId = None
        self._ProjectId = None

    @property
    def RuleGroupId(self):
        return self._RuleGroupId

    @RuleGroupId.setter
    def RuleGroupId(self, RuleGroupId):
        self._RuleGroupId = RuleGroupId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._RuleGroupId = params.get("RuleGroupId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeExecStrategyResponse(AbstractModel):
    """DescribeExecStrategy返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则组执行策略
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleGroupExecStrategy`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleGroupExecStrategy()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeFathersRequest(AbstractModel):
    """DescribeFathers请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Instances: 实例列表
        :type Instances: list of InstanceOpsDto
        :param _CheckFather: 检查父任务类型, true: 检查父任务; false: 不检查父任务 
        :type CheckFather: bool
        :param _RerunType: 重跑类型, 1: 自身; 3: 孩子; 2: 自身以及孩子 
        :type RerunType: str
        :param _DependentWay: 实例依赖方式, 1: 自依赖; 2: 任务依赖; 3: 自依赖及父子依赖 
        :type DependentWay: str
        :param _SkipEventListening: 重跑忽略事件监听与否 
        :type SkipEventListening: bool
        :param _SonInstanceType: 下游实例范围 1: 所在工作流 2: 所在项目 3: 所有跨工作流依赖的项目
        :type SonInstanceType: str
        :param _SearchCondition: 查询条件
        :type SearchCondition: :class:`tencentcloud.wedata.v20210820.models.InstanceApiOpsRequest`
        :param _OptType: 访问类型
        :type OptType: str
        :param _OperatorName: 操作者名称
        :type OperatorName: str
        :param _OperatorId: 操作者id
        :type OperatorId: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _ProjectIdent: 项目标志
        :type ProjectIdent: str
        :param _ProjectName: 项目名称
        :type ProjectName: str
        :param _PageIndex: 索引页码
        :type PageIndex: int
        :param _PageSize: 页面大小
        :type PageSize: int
        :param _Count: 数据总数
        :type Count: int
        :param _RequestBaseInfo: 基础请求信息
        :type RequestBaseInfo: :class:`tencentcloud.wedata.v20210820.models.ProjectBaseInfoOpsRequest`
        :param _IsCount: 是否计算总数
        :type IsCount: bool
        """
        self._Instances = None
        self._CheckFather = None
        self._RerunType = None
        self._DependentWay = None
        self._SkipEventListening = None
        self._SonInstanceType = None
        self._SearchCondition = None
        self._OptType = None
        self._OperatorName = None
        self._OperatorId = None
        self._ProjectId = None
        self._ProjectIdent = None
        self._ProjectName = None
        self._PageIndex = None
        self._PageSize = None
        self._Count = None
        self._RequestBaseInfo = None
        self._IsCount = None

    @property
    def Instances(self):
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances

    @property
    def CheckFather(self):
        return self._CheckFather

    @CheckFather.setter
    def CheckFather(self, CheckFather):
        self._CheckFather = CheckFather

    @property
    def RerunType(self):
        return self._RerunType

    @RerunType.setter
    def RerunType(self, RerunType):
        self._RerunType = RerunType

    @property
    def DependentWay(self):
        return self._DependentWay

    @DependentWay.setter
    def DependentWay(self, DependentWay):
        self._DependentWay = DependentWay

    @property
    def SkipEventListening(self):
        return self._SkipEventListening

    @SkipEventListening.setter
    def SkipEventListening(self, SkipEventListening):
        self._SkipEventListening = SkipEventListening

    @property
    def SonInstanceType(self):
        return self._SonInstanceType

    @SonInstanceType.setter
    def SonInstanceType(self, SonInstanceType):
        self._SonInstanceType = SonInstanceType

    @property
    def SearchCondition(self):
        return self._SearchCondition

    @SearchCondition.setter
    def SearchCondition(self, SearchCondition):
        self._SearchCondition = SearchCondition

    @property
    def OptType(self):
        return self._OptType

    @OptType.setter
    def OptType(self, OptType):
        self._OptType = OptType

    @property
    def OperatorName(self):
        return self._OperatorName

    @OperatorName.setter
    def OperatorName(self, OperatorName):
        self._OperatorName = OperatorName

    @property
    def OperatorId(self):
        return self._OperatorId

    @OperatorId.setter
    def OperatorId(self, OperatorId):
        self._OperatorId = OperatorId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ProjectIdent(self):
        return self._ProjectIdent

    @ProjectIdent.setter
    def ProjectIdent(self, ProjectIdent):
        self._ProjectIdent = ProjectIdent

    @property
    def ProjectName(self):
        return self._ProjectName

    @ProjectName.setter
    def ProjectName(self, ProjectName):
        self._ProjectName = ProjectName

    @property
    def PageIndex(self):
        return self._PageIndex

    @PageIndex.setter
    def PageIndex(self, PageIndex):
        self._PageIndex = PageIndex

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Count(self):
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def RequestBaseInfo(self):
        return self._RequestBaseInfo

    @RequestBaseInfo.setter
    def RequestBaseInfo(self, RequestBaseInfo):
        self._RequestBaseInfo = RequestBaseInfo

    @property
    def IsCount(self):
        return self._IsCount

    @IsCount.setter
    def IsCount(self, IsCount):
        self._IsCount = IsCount


    def _deserialize(self, params):
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = InstanceOpsDto()
                obj._deserialize(item)
                self._Instances.append(obj)
        self._CheckFather = params.get("CheckFather")
        self._RerunType = params.get("RerunType")
        self._DependentWay = params.get("DependentWay")
        self._SkipEventListening = params.get("SkipEventListening")
        self._SonInstanceType = params.get("SonInstanceType")
        if params.get("SearchCondition") is not None:
            self._SearchCondition = InstanceApiOpsRequest()
            self._SearchCondition._deserialize(params.get("SearchCondition"))
        self._OptType = params.get("OptType")
        self._OperatorName = params.get("OperatorName")
        self._OperatorId = params.get("OperatorId")
        self._ProjectId = params.get("ProjectId")
        self._ProjectIdent = params.get("ProjectIdent")
        self._ProjectName = params.get("ProjectName")
        self._PageIndex = params.get("PageIndex")
        self._PageSize = params.get("PageSize")
        self._Count = params.get("Count")
        if params.get("RequestBaseInfo") is not None:
            self._RequestBaseInfo = ProjectBaseInfoOpsRequest()
            self._RequestBaseInfo._deserialize(params.get("RequestBaseInfo"))
        self._IsCount = params.get("IsCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFathersResponse(AbstractModel):
    """DescribeFathers返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 结果集
        :type Data: :class:`tencentcloud.wedata.v20210820.models.CollectionInstanceOpsDto`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = CollectionInstanceOpsDto()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeFieldBasicInfoRequest(AbstractModel):
    """DescribeFieldBasicInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PageNumber: 分页页码
        :type PageNumber: int
        :param _PageSize: 分页大小
        :type PageSize: int
        :param _Filters: 过滤字段
        :type Filters: list of Filter
        :param _OrderFields: 排序字段
        :type OrderFields: list of OrderField
        """
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None
        self._OrderFields = None

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields


    def _deserialize(self, params):
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFieldBasicInfoResponse(AbstractModel):
    """DescribeFieldBasicInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ColumnBasicInfoList: 字段元数据
注意：此字段可能返回 null，表示取不到有效值。
        :type ColumnBasicInfoList: list of ColumnBasicInfo
        :param _TotalCount: 总条数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ColumnBasicInfoList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def ColumnBasicInfoList(self):
        return self._ColumnBasicInfoList

    @ColumnBasicInfoList.setter
    def ColumnBasicInfoList(self, ColumnBasicInfoList):
        self._ColumnBasicInfoList = ColumnBasicInfoList

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ColumnBasicInfoList") is not None:
            self._ColumnBasicInfoList = []
            for item in params.get("ColumnBasicInfoList"):
                obj = ColumnBasicInfo()
                obj._deserialize(item)
                self._ColumnBasicInfoList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeFolderListData(AbstractModel):
    """文件夹分页信息

    """

    def __init__(self):
        r"""
        :param _Items: 文件夹信息列表
        :type Items: list of Folder
        :param _TotalCount: 总条数
        :type TotalCount: int
        :param _PageNumber: 页号
        :type PageNumber: int
        :param _PageSize: 页大小
        :type PageSize: int
        """
        self._Items = None
        self._TotalCount = None
        self._PageNumber = None
        self._PageSize = None

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = Folder()
                obj._deserialize(item)
                self._Items.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFolderListRequest(AbstractModel):
    """DescribeFolderList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _ParentsFolderId: 文件夹ID
        :type ParentsFolderId: str
        :param _KeyWords: 关键字
        :type KeyWords: str
        :param _PageNumber: 页码，默认1
        :type PageNumber: int
        :param _PageSize: 页大小，默认10
        :type PageSize: int
        """
        self._ProjectId = None
        self._ParentsFolderId = None
        self._KeyWords = None
        self._PageNumber = None
        self._PageSize = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ParentsFolderId(self):
        return self._ParentsFolderId

    @ParentsFolderId.setter
    def ParentsFolderId(self, ParentsFolderId):
        self._ParentsFolderId = ParentsFolderId

    @property
    def KeyWords(self):
        return self._KeyWords

    @KeyWords.setter
    def KeyWords(self, KeyWords):
        self._KeyWords = KeyWords

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._ParentsFolderId = params.get("ParentsFolderId")
        self._KeyWords = params.get("KeyWords")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFolderListResponse(AbstractModel):
    """DescribeFolderList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 无
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.DescribeFolderListData`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeFolderListData()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeFolderWorkflowListData(AbstractModel):
    """文件夹分页信息

    """

    def __init__(self):
        r"""
        :param _Items: 工作流信息列表
        :type Items: list of Workflow
        :param _TotalCount: 总条数
        :type TotalCount: int
        :param _PageNumber: 页号
        :type PageNumber: int
        :param _PageSize: 页大小
        :type PageSize: int
        """
        self._Items = None
        self._TotalCount = None
        self._PageNumber = None
        self._PageSize = None

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = Workflow()
                obj._deserialize(item)
                self._Items.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFolderWorkflowListRequest(AbstractModel):
    """DescribeFolderWorkflowList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _ParentsFolderId: 父文件夹ID
        :type ParentsFolderId: str
        :param _KeyWords: 关键字
        :type KeyWords: str
        :param _PageNumber: 页码，默认1
        :type PageNumber: int
        :param _PageSize: 页大小，默认10
        :type PageSize: int
        """
        self._ProjectId = None
        self._ParentsFolderId = None
        self._KeyWords = None
        self._PageNumber = None
        self._PageSize = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ParentsFolderId(self):
        return self._ParentsFolderId

    @ParentsFolderId.setter
    def ParentsFolderId(self, ParentsFolderId):
        self._ParentsFolderId = ParentsFolderId

    @property
    def KeyWords(self):
        return self._KeyWords

    @KeyWords.setter
    def KeyWords(self, KeyWords):
        self._KeyWords = KeyWords

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._ParentsFolderId = params.get("ParentsFolderId")
        self._KeyWords = params.get("KeyWords")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFolderWorkflowListResponse(AbstractModel):
    """DescribeFolderWorkflowList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 无
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.DescribeFolderWorkflowListData`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeFolderWorkflowListData()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeFunctionKindsRequest(AbstractModel):
    """DescribeFunctionKinds请求参数结构体

    """


class DescribeFunctionKindsResponse(AbstractModel):
    """DescribeFunctionKinds返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Kinds: 无
注意：此字段可能返回 null，表示取不到有效值。
        :type Kinds: list of FunctionTypeOrKind
        :param _ErrorMessage: 无
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrorMessage: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Kinds = None
        self._ErrorMessage = None
        self._RequestId = None

    @property
    def Kinds(self):
        return self._Kinds

    @Kinds.setter
    def Kinds(self, Kinds):
        self._Kinds = Kinds

    @property
    def ErrorMessage(self):
        return self._ErrorMessage

    @ErrorMessage.setter
    def ErrorMessage(self, ErrorMessage):
        self._ErrorMessage = ErrorMessage

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Kinds") is not None:
            self._Kinds = []
            for item in params.get("Kinds"):
                obj = FunctionTypeOrKind()
                obj._deserialize(item)
                self._Kinds.append(obj)
        self._ErrorMessage = params.get("ErrorMessage")
        self._RequestId = params.get("RequestId")


class DescribeFunctionTypesRequest(AbstractModel):
    """DescribeFunctionTypes请求参数结构体

    """


class DescribeFunctionTypesResponse(AbstractModel):
    """DescribeFunctionTypes返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Types: 无
注意：此字段可能返回 null，表示取不到有效值。
        :type Types: list of FunctionTypeOrKind
        :param _ErrorMessage: 无
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrorMessage: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Types = None
        self._ErrorMessage = None
        self._RequestId = None

    @property
    def Types(self):
        return self._Types

    @Types.setter
    def Types(self, Types):
        self._Types = Types

    @property
    def ErrorMessage(self):
        return self._ErrorMessage

    @ErrorMessage.setter
    def ErrorMessage(self, ErrorMessage):
        self._ErrorMessage = ErrorMessage

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Types") is not None:
            self._Types = []
            for item in params.get("Types"):
                obj = FunctionTypeOrKind()
                obj._deserialize(item)
                self._Types.append(obj)
        self._ErrorMessage = params.get("ErrorMessage")
        self._RequestId = params.get("RequestId")


class DescribeInLongAgentListRequest(AbstractModel):
    """DescribeInLongAgentList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: WeData项目ID
        :type ProjectId: str
        :param _AgentId: 采集器ID
        :type AgentId: str
        :param _AgentName: Agent Name
        :type AgentName: str
        :param _AgentType: 集群类型，1：TKE Agent，2：BOSS SDK，默认：1，3：CVM，4：自建服务器 【传多个用逗号分割】
        :type AgentType: int
        :param _Status: Agent状态(running运行中，initializing 操作中，failed心跳异常)
        :type Status: str
        :param _VpcId: Vpc Id
        :type VpcId: str
        :param _PageIndex: 分页页码，从1开始，默认：1
        :type PageIndex: int
        :param _PageSize: 分页每页记录数，默认10
        :type PageSize: int
        :param _Like: 名称搜索是否开启模糊匹配，1：开启，0：不开启（精确匹配）
        :type Like: int
        :param _AgentTypes: agent类型【多个用逗号分隔】
        :type AgentTypes: str
        """
        self._ProjectId = None
        self._AgentId = None
        self._AgentName = None
        self._AgentType = None
        self._Status = None
        self._VpcId = None
        self._PageIndex = None
        self._PageSize = None
        self._Like = None
        self._AgentTypes = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def AgentId(self):
        return self._AgentId

    @AgentId.setter
    def AgentId(self, AgentId):
        self._AgentId = AgentId

    @property
    def AgentName(self):
        return self._AgentName

    @AgentName.setter
    def AgentName(self, AgentName):
        self._AgentName = AgentName

    @property
    def AgentType(self):
        return self._AgentType

    @AgentType.setter
    def AgentType(self, AgentType):
        self._AgentType = AgentType

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def PageIndex(self):
        return self._PageIndex

    @PageIndex.setter
    def PageIndex(self, PageIndex):
        self._PageIndex = PageIndex

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Like(self):
        return self._Like

    @Like.setter
    def Like(self, Like):
        self._Like = Like

    @property
    def AgentTypes(self):
        return self._AgentTypes

    @AgentTypes.setter
    def AgentTypes(self, AgentTypes):
        self._AgentTypes = AgentTypes


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._AgentId = params.get("AgentId")
        self._AgentName = params.get("AgentName")
        self._AgentType = params.get("AgentType")
        self._Status = params.get("Status")
        self._VpcId = params.get("VpcId")
        self._PageIndex = params.get("PageIndex")
        self._PageSize = params.get("PageSize")
        self._Like = params.get("Like")
        self._AgentTypes = params.get("AgentTypes")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInLongAgentListResponse(AbstractModel):
    """DescribeInLongAgentList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Items: 采集器信息列表
        :type Items: list of InLongAgentDetail
        :param _PageIndex: 页码
        :type PageIndex: int
        :param _PageSize: 每页记录数
        :type PageSize: int
        :param _TotalCount: 总记录数
        :type TotalCount: int
        :param _TotalPage: 总页数
        :type TotalPage: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Items = None
        self._PageIndex = None
        self._PageSize = None
        self._TotalCount = None
        self._TotalPage = None
        self._RequestId = None

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def PageIndex(self):
        return self._PageIndex

    @PageIndex.setter
    def PageIndex(self, PageIndex):
        self._PageIndex = PageIndex

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TotalPage(self):
        return self._TotalPage

    @TotalPage.setter
    def TotalPage(self, TotalPage):
        self._TotalPage = TotalPage

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = InLongAgentDetail()
                obj._deserialize(item)
                self._Items.append(obj)
        self._PageIndex = params.get("PageIndex")
        self._PageSize = params.get("PageSize")
        self._TotalCount = params.get("TotalCount")
        self._TotalPage = params.get("TotalPage")
        self._RequestId = params.get("RequestId")


class DescribeInLongAgentTaskListRequest(AbstractModel):
    """DescribeInLongAgentTaskList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AgentId: 采集器ID
        :type AgentId: str
        :param _ProjectId: WeData项目ID
        :type ProjectId: str
        """
        self._AgentId = None
        self._ProjectId = None

    @property
    def AgentId(self):
        return self._AgentId

    @AgentId.setter
    def AgentId(self, AgentId):
        self._AgentId = AgentId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._AgentId = params.get("AgentId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInLongAgentTaskListResponse(AbstractModel):
    """DescribeInLongAgentTaskList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Items: 采集器关联的集成任务列表
        :type Items: list of InLongAgentTask
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Items = None
        self._RequestId = None

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = InLongAgentTask()
                obj._deserialize(item)
                self._Items.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeInLongAgentVpcListRequest(AbstractModel):
    """DescribeInLongAgentVpcList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: WeData项目ID
        :type ProjectId: str
        """
        self._ProjectId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInLongAgentVpcListResponse(AbstractModel):
    """DescribeInLongAgentVpcList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _VpcList: VPC列表
        :type VpcList: list of str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._VpcList = None
        self._RequestId = None

    @property
    def VpcList(self):
        return self._VpcList

    @VpcList.setter
    def VpcList(self, VpcList):
        self._VpcList = VpcList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._VpcList = params.get("VpcList")
        self._RequestId = params.get("RequestId")


class DescribeInLongTkeClusterListRequest(AbstractModel):
    """DescribeInLongTkeClusterList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: WeData项目ID
        :type ProjectId: str
        :param _TkeRegion: TKE集群地域
        :type TkeRegion: str
        :param _ClusterName: 集群名称。
多个名称用逗号连接。
        :type ClusterName: str
        :param _Status: TKE集群状态 (Running 运行中 Creating 创建中 Idling 闲置中 Abnormal 异常 Failed 失败 Deleting 删除中 Scaling 规模调整中 Upgrading 升级中 Isolated 欠费隔离中 NodeUpgrading 节点升级中 Recovering 唤醒中 Activating 激活中 MasterScaling Master扩缩容中 Waiting 等待注册 ClusterLevelUpgrading 调整规格中 ResourceIsolate 隔离中 ResourceIsolated 已隔离 ResourceReverse 冲正中 Trading 集群开通中 ResourceReversal 集群冲正 ClusterLevelTrading 集群变配交易中)
多个状态用逗号连接。
        :type Status: str
        :param _HasAgent: 是否安装Agent，true: 是，false: 否
        :type HasAgent: bool
        :param _ClusterType: 集群类型，托管集群：MANAGED_CLUSTER，独立集群：INDEPENDENT_CLUSTER。
多个集群用逗号连接。
        :type ClusterType: str
        :param _PageIndex: 分页页码，从1开始，默认：1
        :type PageIndex: int
        :param _PageSize: 分页每页记录数，默认10
        :type PageSize: int
        """
        self._ProjectId = None
        self._TkeRegion = None
        self._ClusterName = None
        self._Status = None
        self._HasAgent = None
        self._ClusterType = None
        self._PageIndex = None
        self._PageSize = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TkeRegion(self):
        return self._TkeRegion

    @TkeRegion.setter
    def TkeRegion(self, TkeRegion):
        self._TkeRegion = TkeRegion

    @property
    def ClusterName(self):
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def HasAgent(self):
        return self._HasAgent

    @HasAgent.setter
    def HasAgent(self, HasAgent):
        self._HasAgent = HasAgent

    @property
    def ClusterType(self):
        return self._ClusterType

    @ClusterType.setter
    def ClusterType(self, ClusterType):
        self._ClusterType = ClusterType

    @property
    def PageIndex(self):
        return self._PageIndex

    @PageIndex.setter
    def PageIndex(self, PageIndex):
        self._PageIndex = PageIndex

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TkeRegion = params.get("TkeRegion")
        self._ClusterName = params.get("ClusterName")
        self._Status = params.get("Status")
        self._HasAgent = params.get("HasAgent")
        self._ClusterType = params.get("ClusterType")
        self._PageIndex = params.get("PageIndex")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInLongTkeClusterListResponse(AbstractModel):
    """DescribeInLongTkeClusterList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Items: TKE集群信息
        :type Items: list of InLongTkeDetail
        :param _PageIndex: 页码
        :type PageIndex: int
        :param _PageSize: 每页记录数
        :type PageSize: int
        :param _TotalCount: 总记录数
        :type TotalCount: int
        :param _TotalPage: 总页数
        :type TotalPage: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Items = None
        self._PageIndex = None
        self._PageSize = None
        self._TotalCount = None
        self._TotalPage = None
        self._RequestId = None

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def PageIndex(self):
        return self._PageIndex

    @PageIndex.setter
    def PageIndex(self, PageIndex):
        self._PageIndex = PageIndex

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TotalPage(self):
        return self._TotalPage

    @TotalPage.setter
    def TotalPage(self, TotalPage):
        self._TotalPage = TotalPage

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = InLongTkeDetail()
                obj._deserialize(item)
                self._Items.append(obj)
        self._PageIndex = params.get("PageIndex")
        self._PageSize = params.get("PageSize")
        self._TotalCount = params.get("TotalCount")
        self._TotalPage = params.get("TotalPage")
        self._RequestId = params.get("RequestId")


class DescribeInstanceByCycleReportRequest(AbstractModel):
    """DescribeInstanceByCycleReport请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Type: 周期类型
        :type Type: str
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _StartTime: 开始日期
        :type StartTime: str
        :param _EndTime: 结束日期
        :type EndTime: str
        """
        self._Type = None
        self._ProjectId = None
        self._StartTime = None
        self._EndTime = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._ProjectId = params.get("ProjectId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInstanceByCycleReportResponse(AbstractModel):
    """DescribeInstanceByCycleReport返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 实例周期统计
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of TaskByStatus
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = TaskByStatus()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeInstanceByCycleRequest(AbstractModel):
    """DescribeInstanceByCycle请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 1
        :type ProjectId: str
        :param _TenantId: 1
        :type TenantId: str
        """
        self._ProjectId = None
        self._TenantId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TenantId(self):
        return self._TenantId

    @TenantId.setter
    def TenantId(self, TenantId):
        self._TenantId = TenantId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TenantId = params.get("TenantId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInstanceByCycleResponse(AbstractModel):
    """DescribeInstanceByCycle返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 统计结果
        :type Data: list of TaskByCycle
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = TaskByCycle()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeInstanceLastLogRequest(AbstractModel):
    """DescribeInstanceLastLog请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _CurRunDate: 数据时间
        :type CurRunDate: str
        """
        self._TaskId = None
        self._CurRunDate = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def CurRunDate(self):
        return self._CurRunDate

    @CurRunDate.setter
    def CurRunDate(self, CurRunDate):
        self._CurRunDate = CurRunDate


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._CurRunDate = params.get("CurRunDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInstanceLastLogResponse(AbstractModel):
    """DescribeInstanceLastLog返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 日志
        :type Data: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DescribeInstanceListRequest(AbstractModel):
    """DescribeInstanceList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目/工作空间id
        :type ProjectId: str
        :param _PageIndex: 页码
        :type PageIndex: int
        :param _PageSize: 一页展示的条数
        :type PageSize: int
        :param _CycleList: 周期列表（如天，一次性），可选
        :type CycleList: list of str
        :param _OwnerList: 责任人
        :type OwnerList: list of str
        :param _InstanceType: 跟之前保持一致
        :type InstanceType: str
        :param _Sort: 排序顺序（asc，desc）
        :type Sort: str
        :param _SortCol: 排序列（costTime 运行耗时，startTime 开始时间，state 实例状态，curRunDate 数据时间）
        :type SortCol: str
        :param _TaskTypeList: 类型列表（如python任务类型：30
pyspark任务类型：31
hivesql任务类型：34
shell任务类型：35
sparksql任务类型：36 jdbcsql任务类型：21 dlc任务类型：32），可选
        :type TaskTypeList: list of int
        :param _StateList: 状态列表（如成功 2，正在执行 1），可选
        :type StateList: list of int
        :param _Keyword: 任务名称
        :type Keyword: str
        """
        self._ProjectId = None
        self._PageIndex = None
        self._PageSize = None
        self._CycleList = None
        self._OwnerList = None
        self._InstanceType = None
        self._Sort = None
        self._SortCol = None
        self._TaskTypeList = None
        self._StateList = None
        self._Keyword = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PageIndex(self):
        return self._PageIndex

    @PageIndex.setter
    def PageIndex(self, PageIndex):
        self._PageIndex = PageIndex

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def CycleList(self):
        return self._CycleList

    @CycleList.setter
    def CycleList(self, CycleList):
        self._CycleList = CycleList

    @property
    def OwnerList(self):
        return self._OwnerList

    @OwnerList.setter
    def OwnerList(self, OwnerList):
        self._OwnerList = OwnerList

    @property
    def InstanceType(self):
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def Sort(self):
        return self._Sort

    @Sort.setter
    def Sort(self, Sort):
        self._Sort = Sort

    @property
    def SortCol(self):
        return self._SortCol

    @SortCol.setter
    def SortCol(self, SortCol):
        self._SortCol = SortCol

    @property
    def TaskTypeList(self):
        return self._TaskTypeList

    @TaskTypeList.setter
    def TaskTypeList(self, TaskTypeList):
        self._TaskTypeList = TaskTypeList

    @property
    def StateList(self):
        return self._StateList

    @StateList.setter
    def StateList(self, StateList):
        self._StateList = StateList

    @property
    def Keyword(self):
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._PageIndex = params.get("PageIndex")
        self._PageSize = params.get("PageSize")
        self._CycleList = params.get("CycleList")
        self._OwnerList = params.get("OwnerList")
        self._InstanceType = params.get("InstanceType")
        self._Sort = params.get("Sort")
        self._SortCol = params.get("SortCol")
        self._TaskTypeList = params.get("TaskTypeList")
        self._StateList = params.get("StateList")
        self._Keyword = params.get("Keyword")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInstanceListResponse(AbstractModel):
    """DescribeInstanceList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 结果
        :type Data: str
        :param _InstanceList: 实例列表
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceList: list of InstanceList
        :param _TotalCount: 总条数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._InstanceList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def InstanceList(self):
        return self._InstanceList

    @InstanceList.setter
    def InstanceList(self, InstanceList):
        self._InstanceList = InstanceList

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        if params.get("InstanceList") is not None:
            self._InstanceList = []
            for item in params.get("InstanceList"):
                obj = InstanceList()
                obj._deserialize(item)
                self._InstanceList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeInstanceLogDetailRequest(AbstractModel):
    """DescribeInstanceLogDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _TaskId: 任务id
        :type TaskId: str
        :param _CurRunDate: 数据时间
        :type CurRunDate: str
        :param _BrokerIp: 服务器Ip
        :type BrokerIp: str
        :param _OriginFileName: 文件Name
        :type OriginFileName: str
        :param _StartCount: 起始行
        :type StartCount: int
        :param _LineCount: 每次查询行数
        :type LineCount: int
        """
        self._ProjectId = None
        self._TaskId = None
        self._CurRunDate = None
        self._BrokerIp = None
        self._OriginFileName = None
        self._StartCount = None
        self._LineCount = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def CurRunDate(self):
        return self._CurRunDate

    @CurRunDate.setter
    def CurRunDate(self, CurRunDate):
        self._CurRunDate = CurRunDate

    @property
    def BrokerIp(self):
        return self._BrokerIp

    @BrokerIp.setter
    def BrokerIp(self, BrokerIp):
        self._BrokerIp = BrokerIp

    @property
    def OriginFileName(self):
        return self._OriginFileName

    @OriginFileName.setter
    def OriginFileName(self, OriginFileName):
        self._OriginFileName = OriginFileName

    @property
    def StartCount(self):
        return self._StartCount

    @StartCount.setter
    def StartCount(self, StartCount):
        self._StartCount = StartCount

    @property
    def LineCount(self):
        return self._LineCount

    @LineCount.setter
    def LineCount(self, LineCount):
        self._LineCount = LineCount


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TaskId = params.get("TaskId")
        self._CurRunDate = params.get("CurRunDate")
        self._BrokerIp = params.get("BrokerIp")
        self._OriginFileName = params.get("OriginFileName")
        self._StartCount = params.get("StartCount")
        self._LineCount = params.get("LineCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInstanceLogDetailResponse(AbstractModel):
    """DescribeInstanceLogDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 日志结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.InstanceLogInfoOpsDto`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = InstanceLogInfoOpsDto()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeInstanceLogFileRequest(AbstractModel):
    """DescribeInstanceLogFile请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _TaskId: 任务ID
        :type TaskId: str
        :param _CurRunDate: 实例数据时间
        :type CurRunDate: str
        :param _BrokerIp: 执行机IP
        :type BrokerIp: str
        :param _OriginFileName: 日志文件名
        :type OriginFileName: str
        """
        self._ProjectId = None
        self._TaskId = None
        self._CurRunDate = None
        self._BrokerIp = None
        self._OriginFileName = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def CurRunDate(self):
        return self._CurRunDate

    @CurRunDate.setter
    def CurRunDate(self, CurRunDate):
        self._CurRunDate = CurRunDate

    @property
    def BrokerIp(self):
        return self._BrokerIp

    @BrokerIp.setter
    def BrokerIp(self, BrokerIp):
        self._BrokerIp = BrokerIp

    @property
    def OriginFileName(self):
        return self._OriginFileName

    @OriginFileName.setter
    def OriginFileName(self, OriginFileName):
        self._OriginFileName = OriginFileName


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TaskId = params.get("TaskId")
        self._CurRunDate = params.get("CurRunDate")
        self._BrokerIp = params.get("BrokerIp")
        self._OriginFileName = params.get("OriginFileName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInstanceLogFileResponse(AbstractModel):
    """DescribeInstanceLogFile返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 下载文件详情
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.InstanceDownloadLogInfo`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = InstanceDownloadLogInfo()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeInstanceLogListRequest(AbstractModel):
    """DescribeInstanceLogList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _CurRunDate: 数据时间
        :type CurRunDate: str
        """
        self._TaskId = None
        self._CurRunDate = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def CurRunDate(self):
        return self._CurRunDate

    @CurRunDate.setter
    def CurRunDate(self, CurRunDate):
        self._CurRunDate = CurRunDate


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._CurRunDate = params.get("CurRunDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInstanceLogListResponse(AbstractModel):
    """DescribeInstanceLogList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 日志列表
        :type Data: str
        :param _InstanceLogList: 日志列表
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceLogList: list of InstanceLogList
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._InstanceLogList = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def InstanceLogList(self):
        return self._InstanceLogList

    @InstanceLogList.setter
    def InstanceLogList(self, InstanceLogList):
        self._InstanceLogList = InstanceLogList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        if params.get("InstanceLogList") is not None:
            self._InstanceLogList = []
            for item in params.get("InstanceLogList"):
                obj = InstanceLogList()
                obj._deserialize(item)
                self._InstanceLogList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeInstanceLogRequest(AbstractModel):
    """DescribeInstanceLog请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _CurRunDate: 数据时间
        :type CurRunDate: str
        :param _BrokerIp: 服务器Ip
        :type BrokerIp: str
        :param _OriginFileName: 文件Name
        :type OriginFileName: str
        """
        self._TaskId = None
        self._CurRunDate = None
        self._BrokerIp = None
        self._OriginFileName = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def CurRunDate(self):
        return self._CurRunDate

    @CurRunDate.setter
    def CurRunDate(self, CurRunDate):
        self._CurRunDate = CurRunDate

    @property
    def BrokerIp(self):
        return self._BrokerIp

    @BrokerIp.setter
    def BrokerIp(self, BrokerIp):
        self._BrokerIp = BrokerIp

    @property
    def OriginFileName(self):
        return self._OriginFileName

    @OriginFileName.setter
    def OriginFileName(self, OriginFileName):
        self._OriginFileName = OriginFileName


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._CurRunDate = params.get("CurRunDate")
        self._BrokerIp = params.get("BrokerIp")
        self._OriginFileName = params.get("OriginFileName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInstanceLogResponse(AbstractModel):
    """DescribeInstanceLog返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 返回结果
        :type Data: str
        :param _InstanceLogInfo: 返回结果
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceLogInfo: :class:`tencentcloud.wedata.v20210820.models.IntegrationInstanceLog`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._InstanceLogInfo = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def InstanceLogInfo(self):
        return self._InstanceLogInfo

    @InstanceLogInfo.setter
    def InstanceLogInfo(self, InstanceLogInfo):
        self._InstanceLogInfo = InstanceLogInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        if params.get("InstanceLogInfo") is not None:
            self._InstanceLogInfo = IntegrationInstanceLog()
            self._InstanceLogInfo._deserialize(params.get("InstanceLogInfo"))
        self._RequestId = params.get("RequestId")


class DescribeInstanceLogsRequest(AbstractModel):
    """DescribeInstanceLogs请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _TaskId: 任务ID
        :type TaskId: str
        :param _CurRunDate: 数据时间
        :type CurRunDate: str
        """
        self._ProjectId = None
        self._TaskId = None
        self._CurRunDate = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def CurRunDate(self):
        return self._CurRunDate

    @CurRunDate.setter
    def CurRunDate(self, CurRunDate):
        self._CurRunDate = CurRunDate


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TaskId = params.get("TaskId")
        self._CurRunDate = params.get("CurRunDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInstanceLogsResponse(AbstractModel):
    """DescribeInstanceLogs返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 返回日志列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of InstanceLog
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = InstanceLog()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeInstancesInfoWithTaskInfoRequest(AbstractModel):
    """DescribeInstancesInfoWithTaskInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Instances: 实例列表
        :type Instances: list of InstanceOpsDto
        :param _CheckFather: 检查父任务类型, true: 检查父任务; false: 不检查父任务 
        :type CheckFather: bool
        :param _RerunType: 重跑类型, 1: 自身; 3: 孩子; 2: 自身以及孩子 
        :type RerunType: str
        :param _DependentWay: 实例依赖方式, 1: 自依赖; 2: 任务依赖; 3: 自依赖及父子依赖 
        :type DependentWay: str
        :param _SkipEventListening: 重跑忽略事件监听与否 
        :type SkipEventListening: bool
        :param _SonInstanceType: 下游实例范围 1: 所在工作流 2: 所在项目 3: 所有跨工作流依赖的项目
        :type SonInstanceType: str
        :param _SearchCondition: 查询条件
        :type SearchCondition: :class:`tencentcloud.wedata.v20210820.models.InstanceApiOpsRequest`
        :param _OptType: 访问类型
        :type OptType: str
        :param _OperatorName: 操作者名称
        :type OperatorName: str
        :param _OperatorId: 操作者id
        :type OperatorId: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _ProjectIdent: 项目标志
        :type ProjectIdent: str
        :param _ProjectName: 项目名称
        :type ProjectName: str
        :param _PageIndex: 索引页码
        :type PageIndex: int
        :param _PageSize: 页面大小
        :type PageSize: int
        :param _Count: 数据总数
        :type Count: int
        :param _RequestBaseInfo: 基础请求信息
        :type RequestBaseInfo: :class:`tencentcloud.wedata.v20210820.models.ProjectBaseInfoOpsRequest`
        :param _IsCount: 是否计算总数
        :type IsCount: bool
        """
        self._Instances = None
        self._CheckFather = None
        self._RerunType = None
        self._DependentWay = None
        self._SkipEventListening = None
        self._SonInstanceType = None
        self._SearchCondition = None
        self._OptType = None
        self._OperatorName = None
        self._OperatorId = None
        self._ProjectId = None
        self._ProjectIdent = None
        self._ProjectName = None
        self._PageIndex = None
        self._PageSize = None
        self._Count = None
        self._RequestBaseInfo = None
        self._IsCount = None

    @property
    def Instances(self):
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances

    @property
    def CheckFather(self):
        return self._CheckFather

    @CheckFather.setter
    def CheckFather(self, CheckFather):
        self._CheckFather = CheckFather

    @property
    def RerunType(self):
        return self._RerunType

    @RerunType.setter
    def RerunType(self, RerunType):
        self._RerunType = RerunType

    @property
    def DependentWay(self):
        return self._DependentWay

    @DependentWay.setter
    def DependentWay(self, DependentWay):
        self._DependentWay = DependentWay

    @property
    def SkipEventListening(self):
        return self._SkipEventListening

    @SkipEventListening.setter
    def SkipEventListening(self, SkipEventListening):
        self._SkipEventListening = SkipEventListening

    @property
    def SonInstanceType(self):
        return self._SonInstanceType

    @SonInstanceType.setter
    def SonInstanceType(self, SonInstanceType):
        self._SonInstanceType = SonInstanceType

    @property
    def SearchCondition(self):
        return self._SearchCondition

    @SearchCondition.setter
    def SearchCondition(self, SearchCondition):
        self._SearchCondition = SearchCondition

    @property
    def OptType(self):
        return self._OptType

    @OptType.setter
    def OptType(self, OptType):
        self._OptType = OptType

    @property
    def OperatorName(self):
        return self._OperatorName

    @OperatorName.setter
    def OperatorName(self, OperatorName):
        self._OperatorName = OperatorName

    @property
    def OperatorId(self):
        return self._OperatorId

    @OperatorId.setter
    def OperatorId(self, OperatorId):
        self._OperatorId = OperatorId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ProjectIdent(self):
        return self._ProjectIdent

    @ProjectIdent.setter
    def ProjectIdent(self, ProjectIdent):
        self._ProjectIdent = ProjectIdent

    @property
    def ProjectName(self):
        return self._ProjectName

    @ProjectName.setter
    def ProjectName(self, ProjectName):
        self._ProjectName = ProjectName

    @property
    def PageIndex(self):
        return self._PageIndex

    @PageIndex.setter
    def PageIndex(self, PageIndex):
        self._PageIndex = PageIndex

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Count(self):
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def RequestBaseInfo(self):
        return self._RequestBaseInfo

    @RequestBaseInfo.setter
    def RequestBaseInfo(self, RequestBaseInfo):
        self._RequestBaseInfo = RequestBaseInfo

    @property
    def IsCount(self):
        return self._IsCount

    @IsCount.setter
    def IsCount(self, IsCount):
        self._IsCount = IsCount


    def _deserialize(self, params):
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = InstanceOpsDto()
                obj._deserialize(item)
                self._Instances.append(obj)
        self._CheckFather = params.get("CheckFather")
        self._RerunType = params.get("RerunType")
        self._DependentWay = params.get("DependentWay")
        self._SkipEventListening = params.get("SkipEventListening")
        self._SonInstanceType = params.get("SonInstanceType")
        if params.get("SearchCondition") is not None:
            self._SearchCondition = InstanceApiOpsRequest()
            self._SearchCondition._deserialize(params.get("SearchCondition"))
        self._OptType = params.get("OptType")
        self._OperatorName = params.get("OperatorName")
        self._OperatorId = params.get("OperatorId")
        self._ProjectId = params.get("ProjectId")
        self._ProjectIdent = params.get("ProjectIdent")
        self._ProjectName = params.get("ProjectName")
        self._PageIndex = params.get("PageIndex")
        self._PageSize = params.get("PageSize")
        self._Count = params.get("Count")
        if params.get("RequestBaseInfo") is not None:
            self._RequestBaseInfo = ProjectBaseInfoOpsRequest()
            self._RequestBaseInfo._deserialize(params.get("RequestBaseInfo"))
        self._IsCount = params.get("IsCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInstancesInfoWithTaskInfoResponse(AbstractModel):
    """DescribeInstancesInfoWithTaskInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 结果集
        :type Data: list of InstanceOpsDto
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = InstanceOpsDto()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeInstancesRequest(AbstractModel):
    """DescribeInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _PageNumber: 页数
        :type PageNumber: int
        :param _PageSize: 分页大小
        :type PageSize: int
        :param _Filters: 过滤条件
        :type Filters: list of Filter
        """
        self._ProjectId = None
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInstancesResponse(AbstractModel):
    """DescribeInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: Json 结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DescribeIntegrationNodeRequest(AbstractModel):
    """DescribeIntegrationNode请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 节点id
        :type Id: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _TaskType: 任务类型
        :type TaskType: int
        """
        self._Id = None
        self._ProjectId = None
        self._TaskType = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._ProjectId = params.get("ProjectId")
        self._TaskType = params.get("TaskType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIntegrationNodeResponse(AbstractModel):
    """DescribeIntegrationNode返回参数结构体

    """

    def __init__(self):
        r"""
        :param _NodeInfo: 节点信息
注意：此字段可能返回 null，表示取不到有效值。
        :type NodeInfo: :class:`tencentcloud.wedata.v20210820.models.IntegrationNodeInfo`
        :param _SourceCheckFlag: 上游节点是否已经修改。true 已修改，需要提示；false 没有修改
注意：此字段可能返回 null，表示取不到有效值。
        :type SourceCheckFlag: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._NodeInfo = None
        self._SourceCheckFlag = None
        self._RequestId = None

    @property
    def NodeInfo(self):
        return self._NodeInfo

    @NodeInfo.setter
    def NodeInfo(self, NodeInfo):
        self._NodeInfo = NodeInfo

    @property
    def SourceCheckFlag(self):
        return self._SourceCheckFlag

    @SourceCheckFlag.setter
    def SourceCheckFlag(self, SourceCheckFlag):
        self._SourceCheckFlag = SourceCheckFlag

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NodeInfo") is not None:
            self._NodeInfo = IntegrationNodeInfo()
            self._NodeInfo._deserialize(params.get("NodeInfo"))
        self._SourceCheckFlag = params.get("SourceCheckFlag")
        self._RequestId = params.get("RequestId")


class DescribeIntegrationStatisticsAgentStatusRequest(AbstractModel):
    """DescribeIntegrationStatisticsAgentStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskType: 任务类型（实时：201，离线：202）
        :type TaskType: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _QueryDate: 查询日期
        :type QueryDate: str
        :param _ExecutorGroupId: 资源组id
        :type ExecutorGroupId: str
        """
        self._TaskType = None
        self._ProjectId = None
        self._QueryDate = None
        self._ExecutorGroupId = None

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def QueryDate(self):
        return self._QueryDate

    @QueryDate.setter
    def QueryDate(self, QueryDate):
        self._QueryDate = QueryDate

    @property
    def ExecutorGroupId(self):
        return self._ExecutorGroupId

    @ExecutorGroupId.setter
    def ExecutorGroupId(self, ExecutorGroupId):
        self._ExecutorGroupId = ExecutorGroupId


    def _deserialize(self, params):
        self._TaskType = params.get("TaskType")
        self._ProjectId = params.get("ProjectId")
        self._QueryDate = params.get("QueryDate")
        self._ExecutorGroupId = params.get("ExecutorGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIntegrationStatisticsAgentStatusResponse(AbstractModel):
    """DescribeIntegrationStatisticsAgentStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _StatusData: 统计结果
注意：此字段可能返回 null，表示取不到有效值。
        :type StatusData: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._StatusData = None
        self._RequestId = None

    @property
    def StatusData(self):
        return self._StatusData

    @StatusData.setter
    def StatusData(self, StatusData):
        self._StatusData = StatusData

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._StatusData = params.get("StatusData")
        self._RequestId = params.get("RequestId")


class DescribeIntegrationStatisticsInstanceTrendRequest(AbstractModel):
    """DescribeIntegrationStatisticsInstanceTrend请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskType: 任务类型（实时：201，离线：202）
        :type TaskType: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _QueryDate: 查询日期
        :type QueryDate: str
        :param _ExecutorGroupId: 资源组id
        :type ExecutorGroupId: str
        """
        self._TaskType = None
        self._ProjectId = None
        self._QueryDate = None
        self._ExecutorGroupId = None

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def QueryDate(self):
        return self._QueryDate

    @QueryDate.setter
    def QueryDate(self, QueryDate):
        self._QueryDate = QueryDate

    @property
    def ExecutorGroupId(self):
        return self._ExecutorGroupId

    @ExecutorGroupId.setter
    def ExecutorGroupId(self, ExecutorGroupId):
        self._ExecutorGroupId = ExecutorGroupId


    def _deserialize(self, params):
        self._TaskType = params.get("TaskType")
        self._ProjectId = params.get("ProjectId")
        self._QueryDate = params.get("QueryDate")
        self._ExecutorGroupId = params.get("ExecutorGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIntegrationStatisticsInstanceTrendResponse(AbstractModel):
    """DescribeIntegrationStatisticsInstanceTrend返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TrendsData: 统计结果
注意：此字段可能返回 null，表示取不到有效值。
        :type TrendsData: list of IntegrationStatisticsTrendResult
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TrendsData = None
        self._RequestId = None

    @property
    def TrendsData(self):
        return self._TrendsData

    @TrendsData.setter
    def TrendsData(self, TrendsData):
        self._TrendsData = TrendsData

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TrendsData") is not None:
            self._TrendsData = []
            for item in params.get("TrendsData"):
                obj = IntegrationStatisticsTrendResult()
                obj._deserialize(item)
                self._TrendsData.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeIntegrationStatisticsRecordsTrendRequest(AbstractModel):
    """DescribeIntegrationStatisticsRecordsTrend请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskType: 任务类型（实时：201，离线：202）
        :type TaskType: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _QueryDate: 查询日期
        :type QueryDate: str
        """
        self._TaskType = None
        self._ProjectId = None
        self._QueryDate = None

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def QueryDate(self):
        return self._QueryDate

    @QueryDate.setter
    def QueryDate(self, QueryDate):
        self._QueryDate = QueryDate


    def _deserialize(self, params):
        self._TaskType = params.get("TaskType")
        self._ProjectId = params.get("ProjectId")
        self._QueryDate = params.get("QueryDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIntegrationStatisticsRecordsTrendResponse(AbstractModel):
    """DescribeIntegrationStatisticsRecordsTrend返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TrendsData: 统计结果
注意：此字段可能返回 null，表示取不到有效值。
        :type TrendsData: list of IntegrationStatisticsTrendResult
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TrendsData = None
        self._RequestId = None

    @property
    def TrendsData(self):
        return self._TrendsData

    @TrendsData.setter
    def TrendsData(self, TrendsData):
        self._TrendsData = TrendsData

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TrendsData") is not None:
            self._TrendsData = []
            for item in params.get("TrendsData"):
                obj = IntegrationStatisticsTrendResult()
                obj._deserialize(item)
                self._TrendsData.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeIntegrationStatisticsRequest(AbstractModel):
    """DescribeIntegrationStatistics请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskType: 任务类型（实时：201，离线：202）
        :type TaskType: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _QueryDate: 查询日期
        :type QueryDate: str
        """
        self._TaskType = None
        self._ProjectId = None
        self._QueryDate = None

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def QueryDate(self):
        return self._QueryDate

    @QueryDate.setter
    def QueryDate(self, QueryDate):
        self._QueryDate = QueryDate


    def _deserialize(self, params):
        self._TaskType = params.get("TaskType")
        self._ProjectId = params.get("ProjectId")
        self._QueryDate = params.get("QueryDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIntegrationStatisticsResponse(AbstractModel):
    """DescribeIntegrationStatistics返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalTask: 总任务数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalTask: int
        :param _ProdTask: 生产态任务数
注意：此字段可能返回 null，表示取不到有效值。
        :type ProdTask: int
        :param _DevTask: 开发态任务数
注意：此字段可能返回 null，表示取不到有效值。
        :type DevTask: int
        :param _TotalReadRecords: 总读取条数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalReadRecords: int
        :param _TotalWriteRecords: 总写入条数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalWriteRecords: int
        :param _TotalErrorRecords: 总脏数据条数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalErrorRecords: int
        :param _TotalAlarmEvent: 总告警事件数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalAlarmEvent: int
        :param _IncreaseReadRecords: 当天读取增长条数
注意：此字段可能返回 null，表示取不到有效值。
        :type IncreaseReadRecords: int
        :param _IncreaseWriteRecords: 当天写入增长条数
注意：此字段可能返回 null，表示取不到有效值。
        :type IncreaseWriteRecords: int
        :param _IncreaseErrorRecords: 当天脏数据增长条数
注意：此字段可能返回 null，表示取不到有效值。
        :type IncreaseErrorRecords: int
        :param _IncreaseAlarmEvent: 当天告警事件增长数
注意：此字段可能返回 null，表示取不到有效值。
        :type IncreaseAlarmEvent: int
        :param _AlarmEvent: 告警事件统计
注意：此字段可能返回 null，表示取不到有效值。
        :type AlarmEvent: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalTask = None
        self._ProdTask = None
        self._DevTask = None
        self._TotalReadRecords = None
        self._TotalWriteRecords = None
        self._TotalErrorRecords = None
        self._TotalAlarmEvent = None
        self._IncreaseReadRecords = None
        self._IncreaseWriteRecords = None
        self._IncreaseErrorRecords = None
        self._IncreaseAlarmEvent = None
        self._AlarmEvent = None
        self._RequestId = None

    @property
    def TotalTask(self):
        return self._TotalTask

    @TotalTask.setter
    def TotalTask(self, TotalTask):
        self._TotalTask = TotalTask

    @property
    def ProdTask(self):
        return self._ProdTask

    @ProdTask.setter
    def ProdTask(self, ProdTask):
        self._ProdTask = ProdTask

    @property
    def DevTask(self):
        return self._DevTask

    @DevTask.setter
    def DevTask(self, DevTask):
        self._DevTask = DevTask

    @property
    def TotalReadRecords(self):
        return self._TotalReadRecords

    @TotalReadRecords.setter
    def TotalReadRecords(self, TotalReadRecords):
        self._TotalReadRecords = TotalReadRecords

    @property
    def TotalWriteRecords(self):
        return self._TotalWriteRecords

    @TotalWriteRecords.setter
    def TotalWriteRecords(self, TotalWriteRecords):
        self._TotalWriteRecords = TotalWriteRecords

    @property
    def TotalErrorRecords(self):
        return self._TotalErrorRecords

    @TotalErrorRecords.setter
    def TotalErrorRecords(self, TotalErrorRecords):
        self._TotalErrorRecords = TotalErrorRecords

    @property
    def TotalAlarmEvent(self):
        return self._TotalAlarmEvent

    @TotalAlarmEvent.setter
    def TotalAlarmEvent(self, TotalAlarmEvent):
        self._TotalAlarmEvent = TotalAlarmEvent

    @property
    def IncreaseReadRecords(self):
        return self._IncreaseReadRecords

    @IncreaseReadRecords.setter
    def IncreaseReadRecords(self, IncreaseReadRecords):
        self._IncreaseReadRecords = IncreaseReadRecords

    @property
    def IncreaseWriteRecords(self):
        return self._IncreaseWriteRecords

    @IncreaseWriteRecords.setter
    def IncreaseWriteRecords(self, IncreaseWriteRecords):
        self._IncreaseWriteRecords = IncreaseWriteRecords

    @property
    def IncreaseErrorRecords(self):
        return self._IncreaseErrorRecords

    @IncreaseErrorRecords.setter
    def IncreaseErrorRecords(self, IncreaseErrorRecords):
        self._IncreaseErrorRecords = IncreaseErrorRecords

    @property
    def IncreaseAlarmEvent(self):
        return self._IncreaseAlarmEvent

    @IncreaseAlarmEvent.setter
    def IncreaseAlarmEvent(self, IncreaseAlarmEvent):
        self._IncreaseAlarmEvent = IncreaseAlarmEvent

    @property
    def AlarmEvent(self):
        return self._AlarmEvent

    @AlarmEvent.setter
    def AlarmEvent(self, AlarmEvent):
        self._AlarmEvent = AlarmEvent

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalTask = params.get("TotalTask")
        self._ProdTask = params.get("ProdTask")
        self._DevTask = params.get("DevTask")
        self._TotalReadRecords = params.get("TotalReadRecords")
        self._TotalWriteRecords = params.get("TotalWriteRecords")
        self._TotalErrorRecords = params.get("TotalErrorRecords")
        self._TotalAlarmEvent = params.get("TotalAlarmEvent")
        self._IncreaseReadRecords = params.get("IncreaseReadRecords")
        self._IncreaseWriteRecords = params.get("IncreaseWriteRecords")
        self._IncreaseErrorRecords = params.get("IncreaseErrorRecords")
        self._IncreaseAlarmEvent = params.get("IncreaseAlarmEvent")
        self._AlarmEvent = params.get("AlarmEvent")
        self._RequestId = params.get("RequestId")


class DescribeIntegrationStatisticsTaskStatusRequest(AbstractModel):
    """DescribeIntegrationStatisticsTaskStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskType: 任务类型（实时：201，离线：202）
        :type TaskType: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _QueryDate: 查询日期
        :type QueryDate: str
        :param _ExecutorGroupId: 资源组id
        :type ExecutorGroupId: str
        """
        self._TaskType = None
        self._ProjectId = None
        self._QueryDate = None
        self._ExecutorGroupId = None

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def QueryDate(self):
        return self._QueryDate

    @QueryDate.setter
    def QueryDate(self, QueryDate):
        self._QueryDate = QueryDate

    @property
    def ExecutorGroupId(self):
        return self._ExecutorGroupId

    @ExecutorGroupId.setter
    def ExecutorGroupId(self, ExecutorGroupId):
        self._ExecutorGroupId = ExecutorGroupId


    def _deserialize(self, params):
        self._TaskType = params.get("TaskType")
        self._ProjectId = params.get("ProjectId")
        self._QueryDate = params.get("QueryDate")
        self._ExecutorGroupId = params.get("ExecutorGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIntegrationStatisticsTaskStatusResponse(AbstractModel):
    """DescribeIntegrationStatisticsTaskStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _StatusData: 统计结果
注意：此字段可能返回 null，表示取不到有效值。
        :type StatusData: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._StatusData = None
        self._RequestId = None

    @property
    def StatusData(self):
        return self._StatusData

    @StatusData.setter
    def StatusData(self, StatusData):
        self._StatusData = StatusData

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._StatusData = params.get("StatusData")
        self._RequestId = params.get("RequestId")


class DescribeIntegrationStatisticsTaskStatusTrendRequest(AbstractModel):
    """DescribeIntegrationStatisticsTaskStatusTrend请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskType: 任务类型（实时：201，离线：202）
        :type TaskType: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _QueryDate: 查询日期
        :type QueryDate: str
        :param _ExecutorGroupId: 资源组id
        :type ExecutorGroupId: str
        """
        self._TaskType = None
        self._ProjectId = None
        self._QueryDate = None
        self._ExecutorGroupId = None

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def QueryDate(self):
        return self._QueryDate

    @QueryDate.setter
    def QueryDate(self, QueryDate):
        self._QueryDate = QueryDate

    @property
    def ExecutorGroupId(self):
        return self._ExecutorGroupId

    @ExecutorGroupId.setter
    def ExecutorGroupId(self, ExecutorGroupId):
        self._ExecutorGroupId = ExecutorGroupId


    def _deserialize(self, params):
        self._TaskType = params.get("TaskType")
        self._ProjectId = params.get("ProjectId")
        self._QueryDate = params.get("QueryDate")
        self._ExecutorGroupId = params.get("ExecutorGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIntegrationStatisticsTaskStatusTrendResponse(AbstractModel):
    """DescribeIntegrationStatisticsTaskStatusTrend返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TrendsData: 统计结果
注意：此字段可能返回 null，表示取不到有效值。
        :type TrendsData: list of IntegrationStatisticsTrendResult
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TrendsData = None
        self._RequestId = None

    @property
    def TrendsData(self):
        return self._TrendsData

    @TrendsData.setter
    def TrendsData(self, TrendsData):
        self._TrendsData = TrendsData

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TrendsData") is not None:
            self._TrendsData = []
            for item in params.get("TrendsData"):
                obj = IntegrationStatisticsTrendResult()
                obj._deserialize(item)
                self._TrendsData.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeIntegrationTaskRequest(AbstractModel):
    """DescribeIntegrationTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _TaskType: 任务类型，201: 实时集成任务,   202：离线集成任务，不传默认值为201 实时任务类型
        :type TaskType: int
        :param _InstanceVersion: 提交版本号
        :type InstanceVersion: int
        """
        self._TaskId = None
        self._ProjectId = None
        self._TaskType = None
        self._InstanceVersion = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def InstanceVersion(self):
        return self._InstanceVersion

    @InstanceVersion.setter
    def InstanceVersion(self, InstanceVersion):
        self._InstanceVersion = InstanceVersion


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ProjectId = params.get("ProjectId")
        self._TaskType = params.get("TaskType")
        self._InstanceVersion = params.get("InstanceVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIntegrationTaskResponse(AbstractModel):
    """DescribeIntegrationTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskInfo: 任务信息
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskInfo: :class:`tencentcloud.wedata.v20210820.models.IntegrationTaskInfo`
        :param _AgentStatus: 采集器统计信息
注意：此字段可能返回 null，表示取不到有效值。
        :type AgentStatus: :class:`tencentcloud.wedata.v20210820.models.AgentStatus`
        :param _TaskVersion: 任务版本信息
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskVersion: :class:`tencentcloud.wedata.v20210820.models.TaskVersionInstance`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskInfo = None
        self._AgentStatus = None
        self._TaskVersion = None
        self._RequestId = None

    @property
    def TaskInfo(self):
        return self._TaskInfo

    @TaskInfo.setter
    def TaskInfo(self, TaskInfo):
        self._TaskInfo = TaskInfo

    @property
    def AgentStatus(self):
        return self._AgentStatus

    @AgentStatus.setter
    def AgentStatus(self, AgentStatus):
        self._AgentStatus = AgentStatus

    @property
    def TaskVersion(self):
        return self._TaskVersion

    @TaskVersion.setter
    def TaskVersion(self, TaskVersion):
        self._TaskVersion = TaskVersion

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TaskInfo") is not None:
            self._TaskInfo = IntegrationTaskInfo()
            self._TaskInfo._deserialize(params.get("TaskInfo"))
        if params.get("AgentStatus") is not None:
            self._AgentStatus = AgentStatus()
            self._AgentStatus._deserialize(params.get("AgentStatus"))
        if params.get("TaskVersion") is not None:
            self._TaskVersion = TaskVersionInstance()
            self._TaskVersion._deserialize(params.get("TaskVersion"))
        self._RequestId = params.get("RequestId")


class DescribeIntegrationTasksRequest(AbstractModel):
    """DescribeIntegrationTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _PageNumber: 分页第n页
        :type PageNumber: int
        :param _PageSize: 分页大小
        :type PageSize: int
        :param _Filters: 查询filter
        :type Filters: list of Filter
        :param _OrderFields: 排序字段信息
        :type OrderFields: list of OrderField
        :param _StartTime: 开始时间
        :type StartTime: str
        :param _EndTime: 结束时间
        :type EndTime: str
        :param _TaskType: 201. stream, 202. offline 默认实时
        :type TaskType: int
        """
        self._ProjectId = None
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None
        self._OrderFields = None
        self._StartTime = None
        self._EndTime = None
        self._TaskType = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._TaskType = params.get("TaskType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIntegrationTasksResponse(AbstractModel):
    """DescribeIntegrationTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskInfoSet: 任务列表
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskInfoSet: list of IntegrationTaskInfo
        :param _TotalCount: 任务总数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskInfoSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def TaskInfoSet(self):
        return self._TaskInfoSet

    @TaskInfoSet.setter
    def TaskInfoSet(self, TaskInfoSet):
        self._TaskInfoSet = TaskInfoSet

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TaskInfoSet") is not None:
            self._TaskInfoSet = []
            for item in params.get("TaskInfoSet"):
                obj = IntegrationTaskInfo()
                obj._deserialize(item)
                self._TaskInfoSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeIntegrationVersionNodesInfoRequest(AbstractModel):
    """DescribeIntegrationVersionNodesInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _TaskVersionPath: 该任务选定版本的存储路径：
DescribeDsTaskVersionList 或者 DescribeDsTaskVersionInfo 返回的对应的 TaskInfo.TaskExt.Properties 下 Base64.encode($region | $bucket | $ftp.file.name) 值
        :type TaskVersionPath: str
        :param _TaskVersion: 该任务选定版本id：
DescribeDsTaskVersionList 或者 DescribeDsTaskVersionInfo 返回的对应的 VersionId 取值
        :type TaskVersion: str
        """
        self._TaskId = None
        self._ProjectId = None
        self._TaskVersionPath = None
        self._TaskVersion = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskVersionPath(self):
        return self._TaskVersionPath

    @TaskVersionPath.setter
    def TaskVersionPath(self, TaskVersionPath):
        self._TaskVersionPath = TaskVersionPath

    @property
    def TaskVersion(self):
        return self._TaskVersion

    @TaskVersion.setter
    def TaskVersion(self, TaskVersion):
        self._TaskVersion = TaskVersion


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ProjectId = params.get("ProjectId")
        self._TaskVersionPath = params.get("TaskVersionPath")
        self._TaskVersion = params.get("TaskVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIntegrationVersionNodesInfoResponse(AbstractModel):
    """DescribeIntegrationVersionNodesInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Nodes: 任务节点信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Nodes: list of IntegrationNodeInfo
        :param _Mappings: 任务映射信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Mappings: list of IntegrationNodeMapping
        :param _TaskId: 任务id
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Nodes = None
        self._Mappings = None
        self._TaskId = None
        self._RequestId = None

    @property
    def Nodes(self):
        return self._Nodes

    @Nodes.setter
    def Nodes(self, Nodes):
        self._Nodes = Nodes

    @property
    def Mappings(self):
        return self._Mappings

    @Mappings.setter
    def Mappings(self, Mappings):
        self._Mappings = Mappings

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Nodes") is not None:
            self._Nodes = []
            for item in params.get("Nodes"):
                obj = IntegrationNodeInfo()
                obj._deserialize(item)
                self._Nodes.append(obj)
        if params.get("Mappings") is not None:
            self._Mappings = []
            for item in params.get("Mappings"):
                obj = IntegrationNodeMapping()
                obj._deserialize(item)
                self._Mappings.append(obj)
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class DescribeMonitorsByPageRequest(AbstractModel):
    """DescribeMonitorsByPage请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _PageSize: 分页大小
        :type PageSize: int
        :param _Filters: 过滤条件
        :type Filters: list of Filter
        :param _OrderFields: 排序条件
        :type OrderFields: list of OrderField
        :param _PageNumber: 分页序号
        :type PageNumber: int
        """
        self._ProjectId = None
        self._PageSize = None
        self._Filters = None
        self._OrderFields = None
        self._PageNumber = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        self._PageNumber = params.get("PageNumber")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMonitorsByPageResponse(AbstractModel):
    """DescribeMonitorsByPage返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 分页查询结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleGroupMonitorPage`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleGroupMonitorPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeOfflineTaskTokenRequest(AbstractModel):
    """DescribeOfflineTaskToken请求参数结构体

    """


class DescribeOfflineTaskTokenResponse(AbstractModel):
    """DescribeOfflineTaskToken返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Token: 长连接临时token
        :type Token: str
        :param _Data: 长连接临时token。与Token相同含义，优先取Data，Data为空时，取Token。
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Token = None
        self._Data = None
        self._RequestId = None

    @property
    def Token(self):
        return self._Token

    @Token.setter
    def Token(self, Token):
        self._Token = Token

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Token = params.get("Token")
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DescribeOperateOpsTaskDatasourceRequest(AbstractModel):
    """DescribeOperateOpsTaskDatasource请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _TaskType: 任务类型ID
        :type TaskType: int
        :param _ServiceKind: 数据源来源/去向
        :type ServiceKind: str
        :param _ServiceType: 数据源类型
        :type ServiceType: str
        """
        self._ProjectId = None
        self._TaskType = None
        self._ServiceKind = None
        self._ServiceType = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ServiceKind(self):
        return self._ServiceKind

    @ServiceKind.setter
    def ServiceKind(self, ServiceKind):
        self._ServiceKind = ServiceKind

    @property
    def ServiceType(self):
        return self._ServiceType

    @ServiceType.setter
    def ServiceType(self, ServiceType):
        self._ServiceType = ServiceType


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TaskType = params.get("TaskType")
        self._ServiceKind = params.get("ServiceKind")
        self._ServiceType = params.get("ServiceType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOperateOpsTaskDatasourceResponse(AbstractModel):
    """DescribeOperateOpsTaskDatasource返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 数据源信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of SimpleDataSourceInfo
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = SimpleDataSourceInfo()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeOperateOpsTaskDatasourceTypeRequest(AbstractModel):
    """DescribeOperateOpsTaskDatasourceType请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _TaskType: 任务类型ID
        :type TaskType: int
        :param _ServiceKind: 数据源来源/去向
        :type ServiceKind: str
        """
        self._ProjectId = None
        self._TaskType = None
        self._ServiceKind = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def ServiceKind(self):
        return self._ServiceKind

    @ServiceKind.setter
    def ServiceKind(self, ServiceKind):
        self._ServiceKind = ServiceKind


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TaskType = params.get("TaskType")
        self._ServiceKind = params.get("ServiceKind")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOperateOpsTaskDatasourceTypeResponse(AbstractModel):
    """DescribeOperateOpsTaskDatasourceType返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 数据源信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of DatasourceTypeByTaskType
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = DatasourceTypeByTaskType()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeOperateOpsTasksRequest(AbstractModel):
    """DescribeOperateOpsTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _FolderIdList: 文件夹id，多个文件夹以逗号分隔
        :type FolderIdList: str
        :param _WorkFlowIdList: 工作流id，多个工作流id之间以英文字符逗号分隔
        :type WorkFlowIdList: str
        :param _WorkFlowNameList: 工作流名称，多个工作流名称之间以英文字符逗号分隔
        :type WorkFlowNameList: str
        :param _TaskNameList: 任务名称，多个任务名称之间以英文字符逗号分隔
        :type TaskNameList: str
        :param _TaskIdList: 任务id，多个任务id之间以英文字符逗号分隔
        :type TaskIdList: str
        :param _PageNumber: 页号
        :type PageNumber: str
        :param _PageSize: 分页大小
        :type PageSize: str
        :param _SortItem: 排序字段，支持字段为FirstSubmitTime和FirstRunTime，标识最近提交和首次执行事件
        :type SortItem: str
        :param _SortType: 排序类型。两种取值 DESC、ASC
        :type SortType: str
        :param _InChargeList: 责任人，多个责任人之间以英文字符逗号分隔
        :type InChargeList: str
        :param _TaskTypeIdList: 任务类型Id字符串，多个任务类型id之间以英文字符逗号分隔
        :type TaskTypeIdList: str
        :param _StatusList: 任务状态字符串，多个任务状态之间以英文字符逗号分隔
        :type StatusList: str
        :param _TaskCycleUnitList: 任务周期类型字符串，多个任务周期之间以英文字符逗号分隔
        :type TaskCycleUnitList: str
        :param _ProductNameList: 任务所属产品类型
        :type ProductNameList: str
        :param _SourceServiceId: 数据源id或（仅针对离线同步任务）来源数据源id
        :type SourceServiceId: str
        :param _SourceServiceType: 数据源类型或（仅针对离线同步任务）来源数据源类型
        :type SourceServiceType: str
        :param _TargetServiceId: （仅针对离线同步任务）目标数据源id
        :type TargetServiceId: str
        :param _TargetServiceType: （仅针对离线同步任务）目标数据源类型
        :type TargetServiceType: str
        :param _AlarmType: 告警类型，多个类型以逗号分隔
        :type AlarmType: str
        :param _ExecutorGroupIdList: 资源组id,多个资源组id之间以英文字符逗号分隔
        :type ExecutorGroupIdList: str
        :param _TaskTags: 任务标签
        :type TaskTags: list of TaskTag
        """
        self._ProjectId = None
        self._FolderIdList = None
        self._WorkFlowIdList = None
        self._WorkFlowNameList = None
        self._TaskNameList = None
        self._TaskIdList = None
        self._PageNumber = None
        self._PageSize = None
        self._SortItem = None
        self._SortType = None
        self._InChargeList = None
        self._TaskTypeIdList = None
        self._StatusList = None
        self._TaskCycleUnitList = None
        self._ProductNameList = None
        self._SourceServiceId = None
        self._SourceServiceType = None
        self._TargetServiceId = None
        self._TargetServiceType = None
        self._AlarmType = None
        self._ExecutorGroupIdList = None
        self._TaskTags = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def FolderIdList(self):
        return self._FolderIdList

    @FolderIdList.setter
    def FolderIdList(self, FolderIdList):
        self._FolderIdList = FolderIdList

    @property
    def WorkFlowIdList(self):
        return self._WorkFlowIdList

    @WorkFlowIdList.setter
    def WorkFlowIdList(self, WorkFlowIdList):
        self._WorkFlowIdList = WorkFlowIdList

    @property
    def WorkFlowNameList(self):
        return self._WorkFlowNameList

    @WorkFlowNameList.setter
    def WorkFlowNameList(self, WorkFlowNameList):
        self._WorkFlowNameList = WorkFlowNameList

    @property
    def TaskNameList(self):
        return self._TaskNameList

    @TaskNameList.setter
    def TaskNameList(self, TaskNameList):
        self._TaskNameList = TaskNameList

    @property
    def TaskIdList(self):
        return self._TaskIdList

    @TaskIdList.setter
    def TaskIdList(self, TaskIdList):
        self._TaskIdList = TaskIdList

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def SortItem(self):
        return self._SortItem

    @SortItem.setter
    def SortItem(self, SortItem):
        self._SortItem = SortItem

    @property
    def SortType(self):
        return self._SortType

    @SortType.setter
    def SortType(self, SortType):
        self._SortType = SortType

    @property
    def InChargeList(self):
        return self._InChargeList

    @InChargeList.setter
    def InChargeList(self, InChargeList):
        self._InChargeList = InChargeList

    @property
    def TaskTypeIdList(self):
        return self._TaskTypeIdList

    @TaskTypeIdList.setter
    def TaskTypeIdList(self, TaskTypeIdList):
        self._TaskTypeIdList = TaskTypeIdList

    @property
    def StatusList(self):
        return self._StatusList

    @StatusList.setter
    def StatusList(self, StatusList):
        self._StatusList = StatusList

    @property
    def TaskCycleUnitList(self):
        return self._TaskCycleUnitList

    @TaskCycleUnitList.setter
    def TaskCycleUnitList(self, TaskCycleUnitList):
        self._TaskCycleUnitList = TaskCycleUnitList

    @property
    def ProductNameList(self):
        return self._ProductNameList

    @ProductNameList.setter
    def ProductNameList(self, ProductNameList):
        self._ProductNameList = ProductNameList

    @property
    def SourceServiceId(self):
        return self._SourceServiceId

    @SourceServiceId.setter
    def SourceServiceId(self, SourceServiceId):
        self._SourceServiceId = SourceServiceId

    @property
    def SourceServiceType(self):
        return self._SourceServiceType

    @SourceServiceType.setter
    def SourceServiceType(self, SourceServiceType):
        self._SourceServiceType = SourceServiceType

    @property
    def TargetServiceId(self):
        return self._TargetServiceId

    @TargetServiceId.setter
    def TargetServiceId(self, TargetServiceId):
        self._TargetServiceId = TargetServiceId

    @property
    def TargetServiceType(self):
        return self._TargetServiceType

    @TargetServiceType.setter
    def TargetServiceType(self, TargetServiceType):
        self._TargetServiceType = TargetServiceType

    @property
    def AlarmType(self):
        return self._AlarmType

    @AlarmType.setter
    def AlarmType(self, AlarmType):
        self._AlarmType = AlarmType

    @property
    def ExecutorGroupIdList(self):
        return self._ExecutorGroupIdList

    @ExecutorGroupIdList.setter
    def ExecutorGroupIdList(self, ExecutorGroupIdList):
        self._ExecutorGroupIdList = ExecutorGroupIdList

    @property
    def TaskTags(self):
        return self._TaskTags

    @TaskTags.setter
    def TaskTags(self, TaskTags):
        self._TaskTags = TaskTags


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._FolderIdList = params.get("FolderIdList")
        self._WorkFlowIdList = params.get("WorkFlowIdList")
        self._WorkFlowNameList = params.get("WorkFlowNameList")
        self._TaskNameList = params.get("TaskNameList")
        self._TaskIdList = params.get("TaskIdList")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        self._SortItem = params.get("SortItem")
        self._SortType = params.get("SortType")
        self._InChargeList = params.get("InChargeList")
        self._TaskTypeIdList = params.get("TaskTypeIdList")
        self._StatusList = params.get("StatusList")
        self._TaskCycleUnitList = params.get("TaskCycleUnitList")
        self._ProductNameList = params.get("ProductNameList")
        self._SourceServiceId = params.get("SourceServiceId")
        self._SourceServiceType = params.get("SourceServiceType")
        self._TargetServiceId = params.get("TargetServiceId")
        self._TargetServiceType = params.get("TargetServiceType")
        self._AlarmType = params.get("AlarmType")
        self._ExecutorGroupIdList = params.get("ExecutorGroupIdList")
        if params.get("TaskTags") is not None:
            self._TaskTags = []
            for item in params.get("TaskTags"):
                obj = TaskTag()
                obj._deserialize(item)
                self._TaskTags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOperateOpsTasksResponse(AbstractModel):
    """DescribeOperateOpsTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 任务列表信息
        :type Data: :class:`tencentcloud.wedata.v20210820.models.OpsTaskInfoPage`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = OpsTaskInfoPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeOperateTasksRequest(AbstractModel):
    """DescribeOperateTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _FolderIdList: 文件夹id，多个文件夹以逗号分隔
        :type FolderIdList: str
        :param _WorkFlowIdList: 工作流id，多个工作流id之间以英文字符逗号分隔
        :type WorkFlowIdList: str
        :param _WorkFlowNameList: 工作流名称，多个工作流名称之间以英文字符逗号分隔
        :type WorkFlowNameList: str
        :param _TaskNameList: 任务名称，多个任务名称之间以英文字符逗号分隔
        :type TaskNameList: str
        :param _TaskIdList: 任务id，多个任务id之间以英文字符逗号分隔
        :type TaskIdList: str
        :param _PageNumber: 页号
        :type PageNumber: str
        :param _PageSize: 分页大小
        :type PageSize: str
        :param _SortItem: 排序字段，支持字段为FirstSubmitTime和FirstRunTime，标识最近提交和首次执行事件
        :type SortItem: str
        :param _SortType: 排序类型。两种取值 DESC、ASC
        :type SortType: str
        :param _InChargeList: 责任人，多个责任人之间以英文字符逗号分隔
        :type InChargeList: str
        :param _TaskTypeIdList: 任务类型Id字符串，多个任务类型id之间以英文字符逗号分隔
        :type TaskTypeIdList: str
        :param _StatusList: 任务状态字符串，多个任务状态之间以英文字符逗号分隔
        :type StatusList: str
        :param _TaskCycleUnitList: 任务周期类型字符串，多个任务周期之间以英文字符逗号分隔
        :type TaskCycleUnitList: str
        :param _ProductNameList: 任务所属产品类型
        :type ProductNameList: str
        :param _SourceServiceId: 数据源id或（仅针对离线同步任务）来源数据源id
        :type SourceServiceId: str
        :param _SourceServiceType: 数据源类型或（仅针对离线同步任务）来源数据源类型
        :type SourceServiceType: str
        :param _TargetServiceId: （仅针对离线同步任务）目标数据源id
        :type TargetServiceId: str
        :param _TargetServiceType: （仅针对离线同步任务）目标数据源类型
        :type TargetServiceType: str
        :param _AlarmType: 告警类型，多个类型以逗号分隔
        :type AlarmType: str
        """
        self._ProjectId = None
        self._FolderIdList = None
        self._WorkFlowIdList = None
        self._WorkFlowNameList = None
        self._TaskNameList = None
        self._TaskIdList = None
        self._PageNumber = None
        self._PageSize = None
        self._SortItem = None
        self._SortType = None
        self._InChargeList = None
        self._TaskTypeIdList = None
        self._StatusList = None
        self._TaskCycleUnitList = None
        self._ProductNameList = None
        self._SourceServiceId = None
        self._SourceServiceType = None
        self._TargetServiceId = None
        self._TargetServiceType = None
        self._AlarmType = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def FolderIdList(self):
        return self._FolderIdList

    @FolderIdList.setter
    def FolderIdList(self, FolderIdList):
        self._FolderIdList = FolderIdList

    @property
    def WorkFlowIdList(self):
        return self._WorkFlowIdList

    @WorkFlowIdList.setter
    def WorkFlowIdList(self, WorkFlowIdList):
        self._WorkFlowIdList = WorkFlowIdList

    @property
    def WorkFlowNameList(self):
        return self._WorkFlowNameList

    @WorkFlowNameList.setter
    def WorkFlowNameList(self, WorkFlowNameList):
        self._WorkFlowNameList = WorkFlowNameList

    @property
    def TaskNameList(self):
        return self._TaskNameList

    @TaskNameList.setter
    def TaskNameList(self, TaskNameList):
        self._TaskNameList = TaskNameList

    @property
    def TaskIdList(self):
        return self._TaskIdList

    @TaskIdList.setter
    def TaskIdList(self, TaskIdList):
        self._TaskIdList = TaskIdList

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def SortItem(self):
        return self._SortItem

    @SortItem.setter
    def SortItem(self, SortItem):
        self._SortItem = SortItem

    @property
    def SortType(self):
        return self._SortType

    @SortType.setter
    def SortType(self, SortType):
        self._SortType = SortType

    @property
    def InChargeList(self):
        return self._InChargeList

    @InChargeList.setter
    def InChargeList(self, InChargeList):
        self._InChargeList = InChargeList

    @property
    def TaskTypeIdList(self):
        return self._TaskTypeIdList

    @TaskTypeIdList.setter
    def TaskTypeIdList(self, TaskTypeIdList):
        self._TaskTypeIdList = TaskTypeIdList

    @property
    def StatusList(self):
        return self._StatusList

    @StatusList.setter
    def StatusList(self, StatusList):
        self._StatusList = StatusList

    @property
    def TaskCycleUnitList(self):
        return self._TaskCycleUnitList

    @TaskCycleUnitList.setter
    def TaskCycleUnitList(self, TaskCycleUnitList):
        self._TaskCycleUnitList = TaskCycleUnitList

    @property
    def ProductNameList(self):
        return self._ProductNameList

    @ProductNameList.setter
    def ProductNameList(self, ProductNameList):
        self._ProductNameList = ProductNameList

    @property
    def SourceServiceId(self):
        return self._SourceServiceId

    @SourceServiceId.setter
    def SourceServiceId(self, SourceServiceId):
        self._SourceServiceId = SourceServiceId

    @property
    def SourceServiceType(self):
        return self._SourceServiceType

    @SourceServiceType.setter
    def SourceServiceType(self, SourceServiceType):
        self._SourceServiceType = SourceServiceType

    @property
    def TargetServiceId(self):
        return self._TargetServiceId

    @TargetServiceId.setter
    def TargetServiceId(self, TargetServiceId):
        self._TargetServiceId = TargetServiceId

    @property
    def TargetServiceType(self):
        return self._TargetServiceType

    @TargetServiceType.setter
    def TargetServiceType(self, TargetServiceType):
        self._TargetServiceType = TargetServiceType

    @property
    def AlarmType(self):
        return self._AlarmType

    @AlarmType.setter
    def AlarmType(self, AlarmType):
        self._AlarmType = AlarmType


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._FolderIdList = params.get("FolderIdList")
        self._WorkFlowIdList = params.get("WorkFlowIdList")
        self._WorkFlowNameList = params.get("WorkFlowNameList")
        self._TaskNameList = params.get("TaskNameList")
        self._TaskIdList = params.get("TaskIdList")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        self._SortItem = params.get("SortItem")
        self._SortType = params.get("SortType")
        self._InChargeList = params.get("InChargeList")
        self._TaskTypeIdList = params.get("TaskTypeIdList")
        self._StatusList = params.get("StatusList")
        self._TaskCycleUnitList = params.get("TaskCycleUnitList")
        self._ProductNameList = params.get("ProductNameList")
        self._SourceServiceId = params.get("SourceServiceId")
        self._SourceServiceType = params.get("SourceServiceType")
        self._TargetServiceId = params.get("TargetServiceId")
        self._TargetServiceType = params.get("TargetServiceType")
        self._AlarmType = params.get("AlarmType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOperateTasksResponse(AbstractModel):
    """DescribeOperateTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 任务列表信息
        :type Data: :class:`tencentcloud.wedata.v20210820.models.TaskInfoPage`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = TaskInfoPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeOpsInstanceLogListRequest(AbstractModel):
    """DescribeOpsInstanceLogList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _CurRunDate: 数据时间
        :type CurRunDate: str
        """
        self._TaskId = None
        self._CurRunDate = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def CurRunDate(self):
        return self._CurRunDate

    @CurRunDate.setter
    def CurRunDate(self, CurRunDate):
        self._CurRunDate = CurRunDate


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._CurRunDate = params.get("CurRunDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOpsInstanceLogListResponse(AbstractModel):
    """DescribeOpsInstanceLogList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 实例日志列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of InstanceLogInfo
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = InstanceLogInfo()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeOpsMakePlanInstancesRequest(AbstractModel):
    """DescribeOpsMakePlanInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _PlanId: 补录计划ID
        :type PlanId: str
        :param _TaskId: 补录任务ID
        :type TaskId: str
        :param _PageNumber: 分页页码，默认值1
        :type PageNumber: int
        :param _PageSize: 分页大小，默认值10
        :type PageSize: int
        """
        self._ProjectId = None
        self._PlanId = None
        self._TaskId = None
        self._PageNumber = None
        self._PageSize = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PlanId(self):
        return self._PlanId

    @PlanId.setter
    def PlanId(self, PlanId):
        self._PlanId = PlanId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._PlanId = params.get("PlanId")
        self._TaskId = params.get("TaskId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOpsMakePlanInstancesResponse(AbstractModel):
    """DescribeOpsMakePlanInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 补录计划实例分页查询结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.MakePlanInstanceOpsDtoCollection`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = MakePlanInstanceOpsDtoCollection()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeOpsMakePlanTasksRequest(AbstractModel):
    """DescribeOpsMakePlanTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _PlanId: 补录计划ID
        :type PlanId: str
        :param _PageNumber: 分页页码，默认值1
        :type PageNumber: int
        :param _PageSize: 分页大小，默认值10
        :type PageSize: int
        """
        self._ProjectId = None
        self._PlanId = None
        self._PageNumber = None
        self._PageSize = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PlanId(self):
        return self._PlanId

    @PlanId.setter
    def PlanId(self, PlanId):
        self._PlanId = PlanId

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._PlanId = params.get("PlanId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOpsMakePlanTasksResponse(AbstractModel):
    """DescribeOpsMakePlanTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 补录计划任务分页查询结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.MakePlanTaskOpsDtoCollection`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = MakePlanTaskOpsDtoCollection()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeOpsMakePlansRequest(AbstractModel):
    """DescribeOpsMakePlans请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _PageNumber: 分页数，默认值1
        :type PageNumber: int
        :param _PageSize: 分页大小，默认值10
        :type PageSize: int
        :param _PlanId: 补录计划ID
        :type PlanId: str
        :param _PlanName: 补录计划名称
        :type PlanName: str
        :param _TaskName: 补录任务名称
        :type TaskName: str
        :param _TaskId: 补录任务ID
        :type TaskId: str
        :param _Creator: 补录计划创建者
        :type Creator: str
        :param _MinCreateTime: 补录计划最小创建时间
        :type MinCreateTime: str
        :param _MaxCreateTime: 补录计划最大创建时间
        :type MaxCreateTime: str
        """
        self._ProjectId = None
        self._PageNumber = None
        self._PageSize = None
        self._PlanId = None
        self._PlanName = None
        self._TaskName = None
        self._TaskId = None
        self._Creator = None
        self._MinCreateTime = None
        self._MaxCreateTime = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def PlanId(self):
        return self._PlanId

    @PlanId.setter
    def PlanId(self, PlanId):
        self._PlanId = PlanId

    @property
    def PlanName(self):
        return self._PlanName

    @PlanName.setter
    def PlanName(self, PlanName):
        self._PlanName = PlanName

    @property
    def TaskName(self):
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Creator(self):
        return self._Creator

    @Creator.setter
    def Creator(self, Creator):
        self._Creator = Creator

    @property
    def MinCreateTime(self):
        return self._MinCreateTime

    @MinCreateTime.setter
    def MinCreateTime(self, MinCreateTime):
        self._MinCreateTime = MinCreateTime

    @property
    def MaxCreateTime(self):
        return self._MaxCreateTime

    @MaxCreateTime.setter
    def MaxCreateTime(self, MaxCreateTime):
        self._MaxCreateTime = MaxCreateTime


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        self._PlanId = params.get("PlanId")
        self._PlanName = params.get("PlanName")
        self._TaskName = params.get("TaskName")
        self._TaskId = params.get("TaskId")
        self._Creator = params.get("Creator")
        self._MinCreateTime = params.get("MinCreateTime")
        self._MaxCreateTime = params.get("MaxCreateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOpsMakePlansResponse(AbstractModel):
    """DescribeOpsMakePlans返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 补录计划分页查询结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.MakePlanOpsDtoCollection`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = MakePlanOpsDtoCollection()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeOpsWorkflowsRequest(AbstractModel):
    """DescribeOpsWorkflows请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _ProductNameList: 任务产品类型名称列表，以 ',' 号分割
        :type ProductNameList: str
        :param _FolderIdList: 文件id列表，以 ',' 号分割
        :type FolderIdList: str
        :param _WorkFlowIdList: 工作流id，以 ',' 号分割
        :type WorkFlowIdList: str
        :param _WorkFlowNameList: 工作流名称列表，以 ',' 号分割
        :type WorkFlowNameList: str
        :param _TaskNameList: 任务名称列表，以 ',' 号分割
        :type TaskNameList: str
        :param _TaskIdList: 任务id列表，以 ',' 号分割
        :type TaskIdList: str
        :param _StatusList: 状态列表，以 ',' 号分割
        :type StatusList: str
        :param _InChargeList: 负责人列表，以 ',' 号分割
        :type InChargeList: str
        :param _PageNumber: 分页页码
        :type PageNumber: int
        :param _PageSize: 分页大小
        :type PageSize: int
        :param _SortItem: 排序项
        :type SortItem: str
        :param _SortType: 排序方式，DESC或ASC
        :type SortType: str
        """
        self._ProjectId = None
        self._ProductNameList = None
        self._FolderIdList = None
        self._WorkFlowIdList = None
        self._WorkFlowNameList = None
        self._TaskNameList = None
        self._TaskIdList = None
        self._StatusList = None
        self._InChargeList = None
        self._PageNumber = None
        self._PageSize = None
        self._SortItem = None
        self._SortType = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ProductNameList(self):
        return self._ProductNameList

    @ProductNameList.setter
    def ProductNameList(self, ProductNameList):
        self._ProductNameList = ProductNameList

    @property
    def FolderIdList(self):
        return self._FolderIdList

    @FolderIdList.setter
    def FolderIdList(self, FolderIdList):
        self._FolderIdList = FolderIdList

    @property
    def WorkFlowIdList(self):
        return self._WorkFlowIdList

    @WorkFlowIdList.setter
    def WorkFlowIdList(self, WorkFlowIdList):
        self._WorkFlowIdList = WorkFlowIdList

    @property
    def WorkFlowNameList(self):
        return self._WorkFlowNameList

    @WorkFlowNameList.setter
    def WorkFlowNameList(self, WorkFlowNameList):
        self._WorkFlowNameList = WorkFlowNameList

    @property
    def TaskNameList(self):
        return self._TaskNameList

    @TaskNameList.setter
    def TaskNameList(self, TaskNameList):
        self._TaskNameList = TaskNameList

    @property
    def TaskIdList(self):
        return self._TaskIdList

    @TaskIdList.setter
    def TaskIdList(self, TaskIdList):
        self._TaskIdList = TaskIdList

    @property
    def StatusList(self):
        return self._StatusList

    @StatusList.setter
    def StatusList(self, StatusList):
        self._StatusList = StatusList

    @property
    def InChargeList(self):
        return self._InChargeList

    @InChargeList.setter
    def InChargeList(self, InChargeList):
        self._InChargeList = InChargeList

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def SortItem(self):
        return self._SortItem

    @SortItem.setter
    def SortItem(self, SortItem):
        self._SortItem = SortItem

    @property
    def SortType(self):
        return self._SortType

    @SortType.setter
    def SortType(self, SortType):
        self._SortType = SortType


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._ProductNameList = params.get("ProductNameList")
        self._FolderIdList = params.get("FolderIdList")
        self._WorkFlowIdList = params.get("WorkFlowIdList")
        self._WorkFlowNameList = params.get("WorkFlowNameList")
        self._TaskNameList = params.get("TaskNameList")
        self._TaskIdList = params.get("TaskIdList")
        self._StatusList = params.get("StatusList")
        self._InChargeList = params.get("InChargeList")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        self._SortItem = params.get("SortItem")
        self._SortType = params.get("SortType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOpsWorkflowsResponse(AbstractModel):
    """DescribeOpsWorkflows返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 工作流列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.WorkflowExtOpsDtoPage`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = WorkflowExtOpsDtoPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeOrganizationalFunctionsRequest(AbstractModel):
    """DescribeOrganizationalFunctions请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Type: 场景类型：开发、使用
        :type Type: str
        :param _ProjectId: 项目 ID
        :type ProjectId: str
        :param _Name: 函数名称
        :type Name: str
        :param _DisplayName: 展示名称
        :type DisplayName: str
        """
        self._Type = None
        self._ProjectId = None
        self._Name = None
        self._DisplayName = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def DisplayName(self):
        return self._DisplayName

    @DisplayName.setter
    def DisplayName(self, DisplayName):
        self._DisplayName = DisplayName


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._ProjectId = params.get("ProjectId")
        self._Name = params.get("Name")
        self._DisplayName = params.get("DisplayName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOrganizationalFunctionsResponse(AbstractModel):
    """DescribeOrganizationalFunctions返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Content: 无
注意：此字段可能返回 null，表示取不到有效值。
        :type Content: list of OrganizationalFunction
        :param _ErrorMessage: 无
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrorMessage: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Content = None
        self._ErrorMessage = None
        self._RequestId = None

    @property
    def Content(self):
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content

    @property
    def ErrorMessage(self):
        return self._ErrorMessage

    @ErrorMessage.setter
    def ErrorMessage(self, ErrorMessage):
        self._ErrorMessage = ErrorMessage

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Content") is not None:
            self._Content = []
            for item in params.get("Content"):
                obj = OrganizationalFunction()
                obj._deserialize(item)
                self._Content.append(obj)
        self._ErrorMessage = params.get("ErrorMessage")
        self._RequestId = params.get("RequestId")


class DescribeProdTasksRequest(AbstractModel):
    """DescribeProdTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _PageSize: 页面大小
        :type PageSize: int
        :param _PageNumber: 分页序号
        :type PageNumber: int
        :param _Filters: 过滤条件
        :type Filters: list of Filter
        """
        self._ProjectId = None
        self._PageSize = None
        self._PageNumber = None
        self._Filters = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._PageSize = params.get("PageSize")
        self._PageNumber = params.get("PageNumber")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeProdTasksResponse(AbstractModel):
    """DescribeProdTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 生产调度任务列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of ProdSchedulerTask
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = ProdSchedulerTask()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeProjectRequest(AbstractModel):
    """DescribeProject请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id。一般使用项目Id来查询，与projectName必须存在一个。
        :type ProjectId: str
        :param _DescribeClusters: 是否展示关联集群信息
        :type DescribeClusters: bool
        :param _DescribeExecutors: 是否展示关联执行组的信息，仅部分信息。
        :type DescribeExecutors: bool
        :param _DescribeAdminUsers: 默认不展示项目管理员信息
        :type DescribeAdminUsers: bool
        :param _DescribeMemberCount: 默认不统计项目人员数量
        :type DescribeMemberCount: bool
        :param _DescribeCreator: 默认不查询创建者的信息
        :type DescribeCreator: bool
        :param _ProjectName: 项目名只在租户内唯一，一般用来转化为项目ID。
        :type ProjectName: str
        """
        self._ProjectId = None
        self._DescribeClusters = None
        self._DescribeExecutors = None
        self._DescribeAdminUsers = None
        self._DescribeMemberCount = None
        self._DescribeCreator = None
        self._ProjectName = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def DescribeClusters(self):
        return self._DescribeClusters

    @DescribeClusters.setter
    def DescribeClusters(self, DescribeClusters):
        self._DescribeClusters = DescribeClusters

    @property
    def DescribeExecutors(self):
        return self._DescribeExecutors

    @DescribeExecutors.setter
    def DescribeExecutors(self, DescribeExecutors):
        self._DescribeExecutors = DescribeExecutors

    @property
    def DescribeAdminUsers(self):
        return self._DescribeAdminUsers

    @DescribeAdminUsers.setter
    def DescribeAdminUsers(self, DescribeAdminUsers):
        self._DescribeAdminUsers = DescribeAdminUsers

    @property
    def DescribeMemberCount(self):
        return self._DescribeMemberCount

    @DescribeMemberCount.setter
    def DescribeMemberCount(self, DescribeMemberCount):
        self._DescribeMemberCount = DescribeMemberCount

    @property
    def DescribeCreator(self):
        return self._DescribeCreator

    @DescribeCreator.setter
    def DescribeCreator(self, DescribeCreator):
        self._DescribeCreator = DescribeCreator

    @property
    def ProjectName(self):
        return self._ProjectName

    @ProjectName.setter
    def ProjectName(self, ProjectName):
        self._ProjectName = ProjectName


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._DescribeClusters = params.get("DescribeClusters")
        self._DescribeExecutors = params.get("DescribeExecutors")
        self._DescribeAdminUsers = params.get("DescribeAdminUsers")
        self._DescribeMemberCount = params.get("DescribeMemberCount")
        self._DescribeCreator = params.get("DescribeCreator")
        self._ProjectName = params.get("ProjectName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeProjectResponse(AbstractModel):
    """DescribeProject返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DescribeQualityScoreRequest(AbstractModel):
    """DescribeQualityScore请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StatisticsDate: 统计日期
        :type StatisticsDate: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _DatasourceId: 数据来源id
        :type DatasourceId: str
        :param _ScoreType: 1:按全维度权重计算,2:按已配置维度权重计算,3:不按维度权重计算,默认1
        :type ScoreType: str
        :param _Filters: 过滤参数
        :type Filters: list of Filter
        """
        self._StatisticsDate = None
        self._ProjectId = None
        self._DatasourceId = None
        self._ScoreType = None
        self._Filters = None

    @property
    def StatisticsDate(self):
        return self._StatisticsDate

    @StatisticsDate.setter
    def StatisticsDate(self, StatisticsDate):
        self._StatisticsDate = StatisticsDate

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def ScoreType(self):
        return self._ScoreType

    @ScoreType.setter
    def ScoreType(self, ScoreType):
        self._ScoreType = ScoreType

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._StatisticsDate = params.get("StatisticsDate")
        self._ProjectId = params.get("ProjectId")
        self._DatasourceId = params.get("DatasourceId")
        self._ScoreType = params.get("ScoreType")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeQualityScoreResponse(AbstractModel):
    """DescribeQualityScore返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 质量评分
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.QualityScore`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = QualityScore()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeQualityScoreTrendRequest(AbstractModel):
    """DescribeQualityScoreTrend请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StatisticsStartDate: 统计开始日期
        :type StatisticsStartDate: int
        :param _StatisticsEndDate: 统计结束日期
        :type StatisticsEndDate: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _DatasourceId: 数据来源id
        :type DatasourceId: str
        :param _ScoreType: 1:按全维度权重计算,2:按已配置维度权重计算,3:不按维度权重计算,默认1
        :type ScoreType: str
        :param _Filters: 过滤参数
        :type Filters: list of Filter
        """
        self._StatisticsStartDate = None
        self._StatisticsEndDate = None
        self._ProjectId = None
        self._DatasourceId = None
        self._ScoreType = None
        self._Filters = None

    @property
    def StatisticsStartDate(self):
        return self._StatisticsStartDate

    @StatisticsStartDate.setter
    def StatisticsStartDate(self, StatisticsStartDate):
        self._StatisticsStartDate = StatisticsStartDate

    @property
    def StatisticsEndDate(self):
        return self._StatisticsEndDate

    @StatisticsEndDate.setter
    def StatisticsEndDate(self, StatisticsEndDate):
        self._StatisticsEndDate = StatisticsEndDate

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def ScoreType(self):
        return self._ScoreType

    @ScoreType.setter
    def ScoreType(self, ScoreType):
        self._ScoreType = ScoreType

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._StatisticsStartDate = params.get("StatisticsStartDate")
        self._StatisticsEndDate = params.get("StatisticsEndDate")
        self._ProjectId = params.get("ProjectId")
        self._DatasourceId = params.get("DatasourceId")
        self._ScoreType = params.get("ScoreType")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeQualityScoreTrendResponse(AbstractModel):
    """DescribeQualityScoreTrend返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 质量评分趋势视图
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.QualityScoreTrend`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = QualityScoreTrend()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRealTimeTaskInstanceNodeInfoRequest(AbstractModel):
    """DescribeRealTimeTaskInstanceNodeInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 实时任务id
        :type TaskId: str
        :param _ProjectId: 工程id
        :type ProjectId: str
        """
        self._TaskId = None
        self._ProjectId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRealTimeTaskInstanceNodeInfoResponse(AbstractModel):
    """DescribeRealTimeTaskInstanceNodeInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RealTimeTaskInstanceNodeInfo: 实时任务实例节点相关信息
注意：此字段可能返回 null，表示取不到有效值。
        :type RealTimeTaskInstanceNodeInfo: :class:`tencentcloud.wedata.v20210820.models.RealTimeTaskInstanceNodeInfo`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RealTimeTaskInstanceNodeInfo = None
        self._RequestId = None

    @property
    def RealTimeTaskInstanceNodeInfo(self):
        return self._RealTimeTaskInstanceNodeInfo

    @RealTimeTaskInstanceNodeInfo.setter
    def RealTimeTaskInstanceNodeInfo(self, RealTimeTaskInstanceNodeInfo):
        self._RealTimeTaskInstanceNodeInfo = RealTimeTaskInstanceNodeInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RealTimeTaskInstanceNodeInfo") is not None:
            self._RealTimeTaskInstanceNodeInfo = RealTimeTaskInstanceNodeInfo()
            self._RealTimeTaskInstanceNodeInfo._deserialize(params.get("RealTimeTaskInstanceNodeInfo"))
        self._RequestId = params.get("RequestId")


class DescribeRealTimeTaskMetricOverviewRequest(AbstractModel):
    """DescribeRealTimeTaskMetricOverview请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 要查看的实时任务的任务ID，可在任务列表页面中获得
        :type TaskId: str
        :param _ProjectId: 要查看的项目ID
        :type ProjectId: str
        :param _StartTime: 开始时间
        :type StartTime: int
        :param _EndTime: 结束时间
        :type EndTime: int
        """
        self._TaskId = None
        self._ProjectId = None
        self._StartTime = None
        self._EndTime = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ProjectId = params.get("ProjectId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRealTimeTaskMetricOverviewResponse(AbstractModel):
    """DescribeRealTimeTaskMetricOverview返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalRecordNumOfRead: 总读取记录数
        :type TotalRecordNumOfRead: int
        :param _TotalRecordByteNumOfRead: 总读取字节数
        :type TotalRecordByteNumOfRead: int
        :param _TotalRecordNumOfWrite: 总写入记录数
        :type TotalRecordNumOfWrite: int
        :param _TotalRecordByteNumOfWrite: 总写入字节数 单位字节
        :type TotalRecordByteNumOfWrite: int
        :param _TotalDirtyRecordNum: 总的脏记录数据
        :type TotalDirtyRecordNum: int
        :param _TotalDirtyRecordByte: 总的脏字节数 单位字节
        :type TotalDirtyRecordByte: int
        :param _TotalDuration: 运行时长 单位s
        :type TotalDuration: int
        :param _BeginRunTime: 开始运行时间
        :type BeginRunTime: str
        :param _EndRunTime: 目前运行到的时间
        :type EndRunTime: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalRecordNumOfRead = None
        self._TotalRecordByteNumOfRead = None
        self._TotalRecordNumOfWrite = None
        self._TotalRecordByteNumOfWrite = None
        self._TotalDirtyRecordNum = None
        self._TotalDirtyRecordByte = None
        self._TotalDuration = None
        self._BeginRunTime = None
        self._EndRunTime = None
        self._RequestId = None

    @property
    def TotalRecordNumOfRead(self):
        return self._TotalRecordNumOfRead

    @TotalRecordNumOfRead.setter
    def TotalRecordNumOfRead(self, TotalRecordNumOfRead):
        self._TotalRecordNumOfRead = TotalRecordNumOfRead

    @property
    def TotalRecordByteNumOfRead(self):
        return self._TotalRecordByteNumOfRead

    @TotalRecordByteNumOfRead.setter
    def TotalRecordByteNumOfRead(self, TotalRecordByteNumOfRead):
        self._TotalRecordByteNumOfRead = TotalRecordByteNumOfRead

    @property
    def TotalRecordNumOfWrite(self):
        return self._TotalRecordNumOfWrite

    @TotalRecordNumOfWrite.setter
    def TotalRecordNumOfWrite(self, TotalRecordNumOfWrite):
        self._TotalRecordNumOfWrite = TotalRecordNumOfWrite

    @property
    def TotalRecordByteNumOfWrite(self):
        return self._TotalRecordByteNumOfWrite

    @TotalRecordByteNumOfWrite.setter
    def TotalRecordByteNumOfWrite(self, TotalRecordByteNumOfWrite):
        self._TotalRecordByteNumOfWrite = TotalRecordByteNumOfWrite

    @property
    def TotalDirtyRecordNum(self):
        return self._TotalDirtyRecordNum

    @TotalDirtyRecordNum.setter
    def TotalDirtyRecordNum(self, TotalDirtyRecordNum):
        self._TotalDirtyRecordNum = TotalDirtyRecordNum

    @property
    def TotalDirtyRecordByte(self):
        return self._TotalDirtyRecordByte

    @TotalDirtyRecordByte.setter
    def TotalDirtyRecordByte(self, TotalDirtyRecordByte):
        self._TotalDirtyRecordByte = TotalDirtyRecordByte

    @property
    def TotalDuration(self):
        return self._TotalDuration

    @TotalDuration.setter
    def TotalDuration(self, TotalDuration):
        self._TotalDuration = TotalDuration

    @property
    def BeginRunTime(self):
        return self._BeginRunTime

    @BeginRunTime.setter
    def BeginRunTime(self, BeginRunTime):
        self._BeginRunTime = BeginRunTime

    @property
    def EndRunTime(self):
        return self._EndRunTime

    @EndRunTime.setter
    def EndRunTime(self, EndRunTime):
        self._EndRunTime = EndRunTime

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalRecordNumOfRead = params.get("TotalRecordNumOfRead")
        self._TotalRecordByteNumOfRead = params.get("TotalRecordByteNumOfRead")
        self._TotalRecordNumOfWrite = params.get("TotalRecordNumOfWrite")
        self._TotalRecordByteNumOfWrite = params.get("TotalRecordByteNumOfWrite")
        self._TotalDirtyRecordNum = params.get("TotalDirtyRecordNum")
        self._TotalDirtyRecordByte = params.get("TotalDirtyRecordByte")
        self._TotalDuration = params.get("TotalDuration")
        self._BeginRunTime = params.get("BeginRunTime")
        self._EndRunTime = params.get("EndRunTime")
        self._RequestId = params.get("RequestId")


class DescribeRealTimeTaskSpeedRequest(AbstractModel):
    """DescribeRealTimeTaskSpeed请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 无
        :type TaskId: str
        :param _StartTime: 带毫秒的时间戳
        :type StartTime: int
        :param _EndTime: 带毫秒的时间戳
        :type EndTime: int
        :param _Granularity: 粒度，1或者5
        :type Granularity: int
        :param _ProjectId: 无
        :type ProjectId: str
        """
        self._TaskId = None
        self._StartTime = None
        self._EndTime = None
        self._Granularity = None
        self._ProjectId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Granularity(self):
        return self._Granularity

    @Granularity.setter
    def Granularity(self, Granularity):
        self._Granularity = Granularity

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Granularity = params.get("Granularity")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRealTimeTaskSpeedResponse(AbstractModel):
    """DescribeRealTimeTaskSpeed返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RecordsSpeedList: 同步速度条/s列表
        :type RecordsSpeedList: list of RecordsSpeed
        :param _BytesSpeedList: 同步速度字节/s列表
        :type BytesSpeedList: list of BytesSpeed
        :param _Data: 同步速度，包括了RecordsSpeedList和BytesSpeedList
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RealTimeTaskSpeed`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RecordsSpeedList = None
        self._BytesSpeedList = None
        self._Data = None
        self._RequestId = None

    @property
    def RecordsSpeedList(self):
        return self._RecordsSpeedList

    @RecordsSpeedList.setter
    def RecordsSpeedList(self, RecordsSpeedList):
        self._RecordsSpeedList = RecordsSpeedList

    @property
    def BytesSpeedList(self):
        return self._BytesSpeedList

    @BytesSpeedList.setter
    def BytesSpeedList(self, BytesSpeedList):
        self._BytesSpeedList = BytesSpeedList

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RecordsSpeedList") is not None:
            self._RecordsSpeedList = []
            for item in params.get("RecordsSpeedList"):
                obj = RecordsSpeed()
                obj._deserialize(item)
                self._RecordsSpeedList.append(obj)
        if params.get("BytesSpeedList") is not None:
            self._BytesSpeedList = []
            for item in params.get("BytesSpeedList"):
                obj = BytesSpeed()
                obj._deserialize(item)
                self._BytesSpeedList.append(obj)
        if params.get("Data") is not None:
            self._Data = RealTimeTaskSpeed()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRelatedInstancesRequest(AbstractModel):
    """DescribeRelatedInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _CurRunDate: 数据时间，格式yyyy-MM-dd HH:mm:ss
        :type CurRunDate: str
        :param _TaskId: 任务id
        :type TaskId: int
        :param _Depth: 距离当前任务的层级距离，-1表示取父节点，1表示子节点
        :type Depth: int
        :param _PageNumber: 页号，默认为1
        :type PageNumber: int
        :param _PageSize: 页大小，默认为10，最大不超过200
        :type PageSize: int
        """
        self._ProjectId = None
        self._CurRunDate = None
        self._TaskId = None
        self._Depth = None
        self._PageNumber = None
        self._PageSize = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def CurRunDate(self):
        return self._CurRunDate

    @CurRunDate.setter
    def CurRunDate(self, CurRunDate):
        self._CurRunDate = CurRunDate

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Depth(self):
        return self._Depth

    @Depth.setter
    def Depth(self, Depth):
        self._Depth = Depth

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._CurRunDate = params.get("CurRunDate")
        self._TaskId = params.get("TaskId")
        self._Depth = params.get("Depth")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRelatedInstancesResponse(AbstractModel):
    """DescribeRelatedInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 无
        :type Data: :class:`tencentcloud.wedata.v20210820.models.DescribeTaskInstancesData`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeTaskInstancesData()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeResourceManagePathTreesRequest(AbstractModel):
    """DescribeResourceManagePathTrees请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _Name: 名字，供搜索
        :type Name: str
        :param _FileType: 文件类型
        :type FileType: str
        :param _FilePath: 文件路径
        :type FilePath: str
        :param _DirType: 文件夹类型
personal 个人
project 项目
resource 资源
        :type DirType: str
        """
        self._ProjectId = None
        self._Name = None
        self._FileType = None
        self._FilePath = None
        self._DirType = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def FileType(self):
        return self._FileType

    @FileType.setter
    def FileType(self, FileType):
        self._FileType = FileType

    @property
    def FilePath(self):
        return self._FilePath

    @FilePath.setter
    def FilePath(self, FilePath):
        self._FilePath = FilePath

    @property
    def DirType(self):
        return self._DirType

    @DirType.setter
    def DirType(self, DirType):
        self._DirType = DirType


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._Name = params.get("Name")
        self._FileType = params.get("FileType")
        self._FilePath = params.get("FilePath")
        self._DirType = params.get("DirType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeResourceManagePathTreesResponse(AbstractModel):
    """DescribeResourceManagePathTrees返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 响应数据
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of ResourcePathTree
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = ResourcePathTree()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRuleDataSourcesRequest(AbstractModel):
    """DescribeRuleDataSources请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _DatasourceId: 数据来源Id
        :type DatasourceId: str
        :param _DsTypes: 数据源类型
        :type DsTypes: list of int non-negative
        """
        self._ProjectId = None
        self._DatasourceId = None
        self._DsTypes = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def DsTypes(self):
        return self._DsTypes

    @DsTypes.setter
    def DsTypes(self, DsTypes):
        self._DsTypes = DsTypes


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._DatasourceId = params.get("DatasourceId")
        self._DsTypes = params.get("DsTypes")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleDataSourcesResponse(AbstractModel):
    """DescribeRuleDataSources返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 数据源列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of DatabaseInfo
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = DatabaseInfo()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRuleDimStatRequest(AbstractModel):
    """DescribeRuleDimStat请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: Project Id
        :type ProjectId: str
        :param _BeginDate: 开始时间，时间戳到秒
        :type BeginDate: str
        :param _EndDate: 结束时间，时间戳到秒
        :type EndDate: str
        """
        self._ProjectId = None
        self._BeginDate = None
        self._EndDate = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def BeginDate(self):
        return self._BeginDate

    @BeginDate.setter
    def BeginDate(self, BeginDate):
        self._BeginDate = BeginDate

    @property
    def EndDate(self):
        return self._EndDate

    @EndDate.setter
    def EndDate(self, EndDate):
        self._EndDate = EndDate


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._BeginDate = params.get("BeginDate")
        self._EndDate = params.get("EndDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleDimStatResponse(AbstractModel):
    """DescribeRuleDimStat返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 结果
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleDimStat`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleDimStat()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleExecDetailRequest(AbstractModel):
    """DescribeRuleExecDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _RuleExecId: 规则执行id
        :type RuleExecId: int
        """
        self._ProjectId = None
        self._RuleExecId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def RuleExecId(self):
        return self._RuleExecId

    @RuleExecId.setter
    def RuleExecId(self, RuleExecId):
        self._RuleExecId = RuleExecId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._RuleExecId = params.get("RuleExecId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleExecDetailResponse(AbstractModel):
    """DescribeRuleExecDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则执行结果详情
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleExecResultDetail`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleExecResultDetail()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleExecExportResultRequest(AbstractModel):
    """DescribeRuleExecExportResult请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _RuleExecId: 规则执行id
        :type RuleExecId: int
        """
        self._ProjectId = None
        self._RuleExecId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def RuleExecId(self):
        return self._RuleExecId

    @RuleExecId.setter
    def RuleExecId(self, RuleExecId):
        self._RuleExecId = RuleExecId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._RuleExecId = params.get("RuleExecId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleExecExportResultResponse(AbstractModel):
    """DescribeRuleExecExportResult返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 导出结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleExecExportResult`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleExecExportResult()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleExecHistoryRequest(AbstractModel):
    """DescribeRuleExecHistory请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleId: 规则Id
        :type RuleId: int
        :param _ProjectId: 项目Id
        :type ProjectId: str
        """
        self._RuleId = None
        self._ProjectId = None

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleExecHistoryResponse(AbstractModel):
    """DescribeRuleExecHistory返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则执行结果列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of RuleExecResult
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = RuleExecResult()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRuleExecLogRequest(AbstractModel):
    """DescribeRuleExecLog请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleExecId: 规则执行Id
        :type RuleExecId: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _RuleGroupExecId: 规则组执行id
        :type RuleGroupExecId: int
        """
        self._RuleExecId = None
        self._ProjectId = None
        self._RuleGroupExecId = None

    @property
    def RuleExecId(self):
        return self._RuleExecId

    @RuleExecId.setter
    def RuleExecId(self, RuleExecId):
        self._RuleExecId = RuleExecId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def RuleGroupExecId(self):
        return self._RuleGroupExecId

    @RuleGroupExecId.setter
    def RuleGroupExecId(self, RuleGroupExecId):
        self._RuleGroupExecId = RuleGroupExecId


    def _deserialize(self, params):
        self._RuleExecId = params.get("RuleExecId")
        self._ProjectId = params.get("ProjectId")
        self._RuleGroupExecId = params.get("RuleGroupExecId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleExecLogResponse(AbstractModel):
    """DescribeRuleExecLog返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则执行日志
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleExecLog`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleExecLog()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleExecResultsByPageRequest(AbstractModel):
    """DescribeRuleExecResultsByPage请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleGroupExecId: 执行规则组ID
        :type RuleGroupExecId: int
        :param _PageNumber: page number
        :type PageNumber: int
        :param _PageSize: page size
        :type PageSize: int
        """
        self._RuleGroupExecId = None
        self._PageNumber = None
        self._PageSize = None

    @property
    def RuleGroupExecId(self):
        return self._RuleGroupExecId

    @RuleGroupExecId.setter
    def RuleGroupExecId(self, RuleGroupExecId):
        self._RuleGroupExecId = RuleGroupExecId

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        self._RuleGroupExecId = params.get("RuleGroupExecId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleExecResultsByPageResponse(AbstractModel):
    """DescribeRuleExecResultsByPage返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: results
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleExecResultPage`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleExecResultPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleExecResultsRequest(AbstractModel):
    """DescribeRuleExecResults请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleGroupExecId: 规则组执行Id
        :type RuleGroupExecId: int
        :param _ProjectId: 项目Id
        :type ProjectId: str
        """
        self._RuleGroupExecId = None
        self._ProjectId = None

    @property
    def RuleGroupExecId(self):
        return self._RuleGroupExecId

    @RuleGroupExecId.setter
    def RuleGroupExecId(self, RuleGroupExecId):
        self._RuleGroupExecId = RuleGroupExecId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._RuleGroupExecId = params.get("RuleGroupExecId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleExecResultsResponse(AbstractModel):
    """DescribeRuleExecResults返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则执行结果列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleExecResultPage`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleExecResultPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleExecStatRequest(AbstractModel):
    """DescribeRuleExecStat请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: ProjectId 值
        :type ProjectId: str
        :param _BeginDate: 开始时间，时间戳到秒
        :type BeginDate: str
        :param _EndDate: 结束时间，时间戳到秒
        :type EndDate: str
        """
        self._ProjectId = None
        self._BeginDate = None
        self._EndDate = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def BeginDate(self):
        return self._BeginDate

    @BeginDate.setter
    def BeginDate(self, BeginDate):
        self._BeginDate = BeginDate

    @property
    def EndDate(self):
        return self._EndDate

    @EndDate.setter
    def EndDate(self, EndDate):
        self._EndDate = EndDate


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._BeginDate = params.get("BeginDate")
        self._EndDate = params.get("EndDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleExecStatResponse(AbstractModel):
    """DescribeRuleExecStat返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 结果
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleExecStat`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleExecStat()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleGroupExecResultsByPageRequest(AbstractModel):
    """DescribeRuleGroupExecResultsByPage请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PageNumber: 分页序号
        :type PageNumber: int
        :param _PageSize: 分页大小
        :type PageSize: int
        :param _Filters: 过滤条件
        :type Filters: list of Filter
        :param _OrderFields: 排序字段
        :type OrderFields: list of OrderField
        :param _ProjectId: 项目ID
        :type ProjectId: str
        """
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None
        self._OrderFields = None
        self._ProjectId = None

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleGroupExecResultsByPageResponse(AbstractModel):
    """DescribeRuleGroupExecResultsByPage返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则组执行结果列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleGroupExecResultPage`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleGroupExecResultPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleGroupExecResultsByPageWithoutAuthRequest(AbstractModel):
    """DescribeRuleGroupExecResultsByPageWithoutAuth请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PageNumber: 分页序号
        :type PageNumber: int
        :param _PageSize: 分页大小
        :type PageSize: int
        :param _Filters: 过滤条件，指定表ID过滤字段为 TableIds
        :type Filters: list of Filter
        :param _OrderFields: 排序字段
        :type OrderFields: list of OrderField
        :param _ProjectId: 项目ID
        :type ProjectId: str
        """
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None
        self._OrderFields = None
        self._ProjectId = None

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleGroupExecResultsByPageWithoutAuthResponse(AbstractModel):
    """DescribeRuleGroupExecResultsByPageWithoutAuth返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则组执行结果列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleGroupExecResultPage`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleGroupExecResultPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleGroupRequest(AbstractModel):
    """DescribeRuleGroup请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleGroupId: 规则组ID
        :type RuleGroupId: int
        :param _DatasourceId: 数据来源ID
        :type DatasourceId: str
        :param _TableId: 数据表Id
        :type TableId: str
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _DatabaseId: 数据库ID
        :type DatabaseId: str
        """
        self._RuleGroupId = None
        self._DatasourceId = None
        self._TableId = None
        self._ProjectId = None
        self._DatabaseId = None

    @property
    def RuleGroupId(self):
        return self._RuleGroupId

    @RuleGroupId.setter
    def RuleGroupId(self, RuleGroupId):
        self._RuleGroupId = RuleGroupId

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def TableId(self):
        return self._TableId

    @TableId.setter
    def TableId(self, TableId):
        self._TableId = TableId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def DatabaseId(self):
        return self._DatabaseId

    @DatabaseId.setter
    def DatabaseId(self, DatabaseId):
        self._DatabaseId = DatabaseId


    def _deserialize(self, params):
        self._RuleGroupId = params.get("RuleGroupId")
        self._DatasourceId = params.get("DatasourceId")
        self._TableId = params.get("TableId")
        self._ProjectId = params.get("ProjectId")
        self._DatabaseId = params.get("DatabaseId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleGroupResponse(AbstractModel):
    """DescribeRuleGroup返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 数据质量规则组详情
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleGroup`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleGroup()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleGroupSubscriptionRequest(AbstractModel):
    """DescribeRuleGroupSubscription请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleGroupId: 规则组ID
        :type RuleGroupId: int
        :param _ProjectId: 项目ID
        :type ProjectId: str
        """
        self._RuleGroupId = None
        self._ProjectId = None

    @property
    def RuleGroupId(self):
        return self._RuleGroupId

    @RuleGroupId.setter
    def RuleGroupId(self, RuleGroupId):
        self._RuleGroupId = RuleGroupId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._RuleGroupId = params.get("RuleGroupId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleGroupSubscriptionResponse(AbstractModel):
    """DescribeRuleGroupSubscription返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则组订阅信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleGroupSubscribe`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleGroupSubscribe()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleGroupTableRequest(AbstractModel):
    """DescribeRuleGroupTable请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TableId: 表ID
        :type TableId: str
        """
        self._TableId = None

    @property
    def TableId(self):
        return self._TableId

    @TableId.setter
    def TableId(self, TableId):
        self._TableId = TableId


    def _deserialize(self, params):
        self._TableId = params.get("TableId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleGroupTableResponse(AbstractModel):
    """DescribeRuleGroupTable返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 数据
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleGroupTable`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleGroupTable()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleGroupsByPageRequest(AbstractModel):
    """DescribeRuleGroupsByPage请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PageNumber: 分页序号
        :type PageNumber: int
        :param _PageSize: 分页大小
        :type PageSize: int
        :param _Filters: 过滤条件,每次请求的Filters的上限为10，Filter.Values的上限为5
        :type Filters: list of Filter
        :param _OrderFields: 排序方式
        :type OrderFields: list of OrderField
        :param _ProjectId: 项目Id
        :type ProjectId: str
        """
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None
        self._OrderFields = None
        self._ProjectId = None

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleGroupsByPageResponse(AbstractModel):
    """DescribeRuleGroupsByPage返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则组列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleGroupPage`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleGroupPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleHistoryByPageRequest(AbstractModel):
    """DescribeRuleHistoryByPage请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _PageNumber: 分页序号
        :type PageNumber: int
        :param _PageSize: 分页大小
        :type PageSize: int
        :param _Filters: 过滤条件
        :type Filters: list of Filter
        """
        self._ProjectId = None
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleHistoryByPageResponse(AbstractModel):
    """DescribeRuleHistoryByPage返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则组操作历史列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleHistoryPage`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleHistoryPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleRequest(AbstractModel):
    """DescribeRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleId: 质量规则ID
        :type RuleId: int
        :param _ProjectId: 项目ID
        :type ProjectId: str
        """
        self._RuleId = None
        self._ProjectId = None

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleResponse(AbstractModel):
    """DescribeRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则详情
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.Rule`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = Rule()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleTablesByPageRequest(AbstractModel):
    """DescribeRuleTablesByPage请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _PageSize: 分页序号
        :type PageSize: int
        :param _PageNumber: 分页大小
        :type PageNumber: int
        :param _Filters: 过滤条件
        :type Filters: list of Filter
        :param _OrderFields: 排序条件
        :type OrderFields: list of OrderField
        """
        self._ProjectId = None
        self._PageSize = None
        self._PageNumber = None
        self._Filters = None
        self._OrderFields = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._PageSize = params.get("PageSize")
        self._PageNumber = params.get("PageNumber")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleTablesByPageResponse(AbstractModel):
    """DescribeRuleTablesByPage返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 表列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleGroupPage`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleGroupPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleTemplateRequest(AbstractModel):
    """DescribeRuleTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _TemplateId: 规则模板Id
        :type TemplateId: int
        """
        self._ProjectId = None
        self._TemplateId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TemplateId(self):
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TemplateId = params.get("TemplateId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleTemplateResponse(AbstractModel):
    """DescribeRuleTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 模板详情
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleTemplate`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleTemplate()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleTemplatesByPageRequest(AbstractModel):
    """DescribeRuleTemplatesByPage请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PageNumber: 当前页
        :type PageNumber: int
        :param _PageSize: 每页记录数
        :type PageSize: int
        :param _ProjectId: 工作空间ID
        :type ProjectId: str
        :param _OrderFields: 通用排序字段
        :type OrderFields: list of OrderField
        :param _Filters: 通用过滤条件
        :type Filters: list of Filter
        """
        self._PageNumber = None
        self._PageSize = None
        self._ProjectId = None
        self._OrderFields = None
        self._Filters = None

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        self._ProjectId = params.get("ProjectId")
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleTemplatesByPageResponse(AbstractModel):
    """DescribeRuleTemplatesByPage返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 结果
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RuleTemplatePage`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RuleTemplatePage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRuleTemplatesRequest(AbstractModel):
    """DescribeRuleTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Type: 模版类型 1.系统模版 2.自定义模版
        :type Type: int
        :param _SourceObjectType: 1.常量 2.离线表级 2.离线字段级
        :type SourceObjectType: int
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _SourceEngineTypes: 源端对应的引擎类型
        :type SourceEngineTypes: list of int non-negative
        """
        self._Type = None
        self._SourceObjectType = None
        self._ProjectId = None
        self._SourceEngineTypes = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def SourceObjectType(self):
        return self._SourceObjectType

    @SourceObjectType.setter
    def SourceObjectType(self, SourceObjectType):
        self._SourceObjectType = SourceObjectType

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def SourceEngineTypes(self):
        return self._SourceEngineTypes

    @SourceEngineTypes.setter
    def SourceEngineTypes(self, SourceEngineTypes):
        self._SourceEngineTypes = SourceEngineTypes


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._SourceObjectType = params.get("SourceObjectType")
        self._ProjectId = params.get("ProjectId")
        self._SourceEngineTypes = params.get("SourceEngineTypes")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRuleTemplatesResponse(AbstractModel):
    """DescribeRuleTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则模版列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of RuleTemplate
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = RuleTemplate()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRulesByPageRequest(AbstractModel):
    """DescribeRulesByPage请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PageNumber: 分页序号
        :type PageNumber: int
        :param _PageSize: 分页大小
        :type PageSize: int
        :param _Filters: 过滤条件
        :type Filters: list of Filter
        :param _OrderFields: 排序字段
        :type OrderFields: list of OrderField
        :param _ProjectId: 项目ID
        :type ProjectId: str
        """
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None
        self._OrderFields = None
        self._ProjectId = None

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRulesByPageResponse(AbstractModel):
    """DescribeRulesByPage返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则质量列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.RulePage`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = RulePage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeRulesRequest(AbstractModel):
    """DescribeRules请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _RuleGroupId: 规则组id
        :type RuleGroupId: int
        :param _EngineType: 该规则运行的执行引擎，不传时会请求该数据源下默认的执行引擎
        :type EngineType: str
        """
        self._ProjectId = None
        self._RuleGroupId = None
        self._EngineType = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def RuleGroupId(self):
        return self._RuleGroupId

    @RuleGroupId.setter
    def RuleGroupId(self, RuleGroupId):
        self._RuleGroupId = RuleGroupId

    @property
    def EngineType(self):
        return self._EngineType

    @EngineType.setter
    def EngineType(self, EngineType):
        self._EngineType = EngineType


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._RuleGroupId = params.get("RuleGroupId")
        self._EngineType = params.get("EngineType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRulesResponse(AbstractModel):
    """DescribeRules返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 规则列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of Rule
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = Rule()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeScheduleInstanceRequest(AbstractModel):
    """DescribeScheduleInstance请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 基线id
        :type TaskId: str
        :param _CurRunDate: 任务实例数据时间
        :type CurRunDate: str
        """
        self._TaskId = None
        self._CurRunDate = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def CurRunDate(self):
        return self._CurRunDate

    @CurRunDate.setter
    def CurRunDate(self, CurRunDate):
        self._CurRunDate = CurRunDate


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._CurRunDate = params.get("CurRunDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeScheduleInstanceResponse(AbstractModel):
    """DescribeScheduleInstance返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 基线实例中的调度任务实例信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.InstanceOpsDto`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = InstanceOpsDto()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeScheduleInstancesRequest(AbstractModel):
    """DescribeScheduleInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Instances: 实例列表
        :type Instances: list of InstanceOpsDto
        :param _CheckFather: 检查父任务类型, true: 检查父任务; false: 不检查父任务 
        :type CheckFather: bool
        :param _RerunType: 重跑类型, 1: 自身; 3: 孩子; 2: 自身以及孩子 
        :type RerunType: str
        :param _DependentWay: 实例依赖方式, 1: 自依赖; 2: 任务依赖; 3: 自依赖及父子依赖 
        :type DependentWay: str
        :param _SkipEventListening: 重跑忽略事件监听与否 
        :type SkipEventListening: bool
        :param _SonInstanceType: 下游实例范围 1: 所在工作流 2: 所在项目 3: 所有跨工作流依赖的项目
        :type SonInstanceType: str
        :param _SearchCondition: 查询条件
        :type SearchCondition: :class:`tencentcloud.wedata.v20210820.models.InstanceApiOpsRequest`
        :param _OptType: 访问类型
        :type OptType: str
        :param _OperatorName: 操作者名称
        :type OperatorName: str
        :param _OperatorId: 操作者id
        :type OperatorId: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _ProjectIdent: 项目标志
        :type ProjectIdent: str
        :param _ProjectName: 项目名称
        :type ProjectName: str
        :param _PageIndex: 索引页码
        :type PageIndex: int
        :param _PageSize: 页面大小
        :type PageSize: int
        :param _Count: 数据总数
        :type Count: int
        :param _RequestBaseInfo: 基础请求信息
        :type RequestBaseInfo: :class:`tencentcloud.wedata.v20210820.models.ProjectBaseInfoOpsRequest`
        :param _IsCount: 是否计算总数
        :type IsCount: bool
        """
        self._Instances = None
        self._CheckFather = None
        self._RerunType = None
        self._DependentWay = None
        self._SkipEventListening = None
        self._SonInstanceType = None
        self._SearchCondition = None
        self._OptType = None
        self._OperatorName = None
        self._OperatorId = None
        self._ProjectId = None
        self._ProjectIdent = None
        self._ProjectName = None
        self._PageIndex = None
        self._PageSize = None
        self._Count = None
        self._RequestBaseInfo = None
        self._IsCount = None

    @property
    def Instances(self):
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances

    @property
    def CheckFather(self):
        return self._CheckFather

    @CheckFather.setter
    def CheckFather(self, CheckFather):
        self._CheckFather = CheckFather

    @property
    def RerunType(self):
        return self._RerunType

    @RerunType.setter
    def RerunType(self, RerunType):
        self._RerunType = RerunType

    @property
    def DependentWay(self):
        return self._DependentWay

    @DependentWay.setter
    def DependentWay(self, DependentWay):
        self._DependentWay = DependentWay

    @property
    def SkipEventListening(self):
        return self._SkipEventListening

    @SkipEventListening.setter
    def SkipEventListening(self, SkipEventListening):
        self._SkipEventListening = SkipEventListening

    @property
    def SonInstanceType(self):
        return self._SonInstanceType

    @SonInstanceType.setter
    def SonInstanceType(self, SonInstanceType):
        self._SonInstanceType = SonInstanceType

    @property
    def SearchCondition(self):
        return self._SearchCondition

    @SearchCondition.setter
    def SearchCondition(self, SearchCondition):
        self._SearchCondition = SearchCondition

    @property
    def OptType(self):
        return self._OptType

    @OptType.setter
    def OptType(self, OptType):
        self._OptType = OptType

    @property
    def OperatorName(self):
        return self._OperatorName

    @OperatorName.setter
    def OperatorName(self, OperatorName):
        self._OperatorName = OperatorName

    @property
    def OperatorId(self):
        return self._OperatorId

    @OperatorId.setter
    def OperatorId(self, OperatorId):
        self._OperatorId = OperatorId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ProjectIdent(self):
        return self._ProjectIdent

    @ProjectIdent.setter
    def ProjectIdent(self, ProjectIdent):
        self._ProjectIdent = ProjectIdent

    @property
    def ProjectName(self):
        return self._ProjectName

    @ProjectName.setter
    def ProjectName(self, ProjectName):
        self._ProjectName = ProjectName

    @property
    def PageIndex(self):
        return self._PageIndex

    @PageIndex.setter
    def PageIndex(self, PageIndex):
        self._PageIndex = PageIndex

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Count(self):
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def RequestBaseInfo(self):
        return self._RequestBaseInfo

    @RequestBaseInfo.setter
    def RequestBaseInfo(self, RequestBaseInfo):
        self._RequestBaseInfo = RequestBaseInfo

    @property
    def IsCount(self):
        return self._IsCount

    @IsCount.setter
    def IsCount(self, IsCount):
        self._IsCount = IsCount


    def _deserialize(self, params):
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = InstanceOpsDto()
                obj._deserialize(item)
                self._Instances.append(obj)
        self._CheckFather = params.get("CheckFather")
        self._RerunType = params.get("RerunType")
        self._DependentWay = params.get("DependentWay")
        self._SkipEventListening = params.get("SkipEventListening")
        self._SonInstanceType = params.get("SonInstanceType")
        if params.get("SearchCondition") is not None:
            self._SearchCondition = InstanceApiOpsRequest()
            self._SearchCondition._deserialize(params.get("SearchCondition"))
        self._OptType = params.get("OptType")
        self._OperatorName = params.get("OperatorName")
        self._OperatorId = params.get("OperatorId")
        self._ProjectId = params.get("ProjectId")
        self._ProjectIdent = params.get("ProjectIdent")
        self._ProjectName = params.get("ProjectName")
        self._PageIndex = params.get("PageIndex")
        self._PageSize = params.get("PageSize")
        self._Count = params.get("Count")
        if params.get("RequestBaseInfo") is not None:
            self._RequestBaseInfo = ProjectBaseInfoOpsRequest()
            self._RequestBaseInfo._deserialize(params.get("RequestBaseInfo"))
        self._IsCount = params.get("IsCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeScheduleInstancesResponse(AbstractModel):
    """DescribeScheduleInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 实例结果集
        :type Data: :class:`tencentcloud.wedata.v20210820.models.CollectionInstanceOpsDto`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = CollectionInstanceOpsDto()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeSchedulerInstanceStatusRequest(AbstractModel):
    """DescribeSchedulerInstanceStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _TaskTypeId: 任务类型ID
        :type TaskTypeId: str
        :param _ExecutionGroupId: 执行资源组ID
        :type ExecutionGroupId: str
        :param _ExecutionGroupName: 执行资源组名字
        :type ExecutionGroupName: str
        :param _StartTime: 开始时间
        :type StartTime: str
        :param _EndTime: 结束时间
        :type EndTime: str
        :param _InCharge: 责任人
        :type InCharge: str
        :param _WorkflowId: 工作流ID
        :type WorkflowId: str
        """
        self._ProjectId = None
        self._TaskTypeId = None
        self._ExecutionGroupId = None
        self._ExecutionGroupName = None
        self._StartTime = None
        self._EndTime = None
        self._InCharge = None
        self._WorkflowId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskTypeId(self):
        return self._TaskTypeId

    @TaskTypeId.setter
    def TaskTypeId(self, TaskTypeId):
        self._TaskTypeId = TaskTypeId

    @property
    def ExecutionGroupId(self):
        return self._ExecutionGroupId

    @ExecutionGroupId.setter
    def ExecutionGroupId(self, ExecutionGroupId):
        self._ExecutionGroupId = ExecutionGroupId

    @property
    def ExecutionGroupName(self):
        return self._ExecutionGroupName

    @ExecutionGroupName.setter
    def ExecutionGroupName(self, ExecutionGroupName):
        self._ExecutionGroupName = ExecutionGroupName

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def InCharge(self):
        return self._InCharge

    @InCharge.setter
    def InCharge(self, InCharge):
        self._InCharge = InCharge

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TaskTypeId = params.get("TaskTypeId")
        self._ExecutionGroupId = params.get("ExecutionGroupId")
        self._ExecutionGroupName = params.get("ExecutionGroupName")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._InCharge = params.get("InCharge")
        self._WorkflowId = params.get("WorkflowId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSchedulerInstanceStatusResponse(AbstractModel):
    """DescribeSchedulerInstanceStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 响应数据
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of ScreenInstanceInfo
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = ScreenInstanceInfo()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSchedulerRunTimeInstanceCntByStatusRequest(AbstractModel):
    """DescribeSchedulerRunTimeInstanceCntByStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _CycleUnit: 周期类型
        :type CycleUnit: str
        :param _TimeUnit: 时间单元 eg: 12h
        :type TimeUnit: str
        :param _StartTime: 开始日期：2023-03-02
        :type StartTime: str
        :param _EndTime: 结束日前：2023-03-20
        :type EndTime: str
        :param _TaskType: 1
        :type TaskType: int
        :param _InCharge: 1
        :type InCharge: str
        :param _WorkflowId: 工作流ID
        :type WorkflowId: str
        :param _SortItem: 排序字段
        :type SortItem: str
        :param _SortType: 升序降序
        :type SortType: str
        """
        self._ProjectId = None
        self._CycleUnit = None
        self._TimeUnit = None
        self._StartTime = None
        self._EndTime = None
        self._TaskType = None
        self._InCharge = None
        self._WorkflowId = None
        self._SortItem = None
        self._SortType = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def CycleUnit(self):
        return self._CycleUnit

    @CycleUnit.setter
    def CycleUnit(self, CycleUnit):
        self._CycleUnit = CycleUnit

    @property
    def TimeUnit(self):
        return self._TimeUnit

    @TimeUnit.setter
    def TimeUnit(self, TimeUnit):
        self._TimeUnit = TimeUnit

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def InCharge(self):
        return self._InCharge

    @InCharge.setter
    def InCharge(self, InCharge):
        self._InCharge = InCharge

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId

    @property
    def SortItem(self):
        return self._SortItem

    @SortItem.setter
    def SortItem(self, SortItem):
        self._SortItem = SortItem

    @property
    def SortType(self):
        return self._SortType

    @SortType.setter
    def SortType(self, SortType):
        self._SortType = SortType


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._CycleUnit = params.get("CycleUnit")
        self._TimeUnit = params.get("TimeUnit")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._TaskType = params.get("TaskType")
        self._InCharge = params.get("InCharge")
        self._WorkflowId = params.get("WorkflowId")
        self._SortItem = params.get("SortItem")
        self._SortType = params.get("SortType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSchedulerRunTimeInstanceCntByStatusResponse(AbstractModel):
    """DescribeSchedulerRunTimeInstanceCntByStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 响应数据
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of RuntimeInstanceCntTop
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = RuntimeInstanceCntTop()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSchedulerTaskCntByStatusRequest(AbstractModel):
    """DescribeSchedulerTaskCntByStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskType: 1
        :type TaskType: int
        :param _TypeName: Y
        :type TypeName: str
        :param _ProjectId: 111
        :type ProjectId: str
        :param _InCharge: 1
        :type InCharge: str
        :param _WorkflowId: 工作流ID
        :type WorkflowId: str
        """
        self._TaskType = None
        self._TypeName = None
        self._ProjectId = None
        self._InCharge = None
        self._WorkflowId = None

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def TypeName(self):
        return self._TypeName

    @TypeName.setter
    def TypeName(self, TypeName):
        self._TypeName = TypeName

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def InCharge(self):
        return self._InCharge

    @InCharge.setter
    def InCharge(self, InCharge):
        self._InCharge = InCharge

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId


    def _deserialize(self, params):
        self._TaskType = params.get("TaskType")
        self._TypeName = params.get("TypeName")
        self._ProjectId = params.get("ProjectId")
        self._InCharge = params.get("InCharge")
        self._WorkflowId = params.get("WorkflowId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSchedulerTaskCntByStatusResponse(AbstractModel):
    """DescribeSchedulerTaskCntByStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 统计结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of ScreenTaskInfo
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = ScreenTaskInfo()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSchedulerTaskTypeCntRequest(AbstractModel):
    """DescribeSchedulerTaskTypeCnt请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _InCharge: 1
        :type InCharge: str
        """
        self._ProjectId = None
        self._InCharge = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def InCharge(self):
        return self._InCharge

    @InCharge.setter
    def InCharge(self, InCharge):
        self._InCharge = InCharge


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._InCharge = params.get("InCharge")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSchedulerTaskTypeCntResponse(AbstractModel):
    """DescribeSchedulerTaskTypeCnt返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: data
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of TaskTypeCnt
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = TaskTypeCnt()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSonInstancesRequest(AbstractModel):
    """DescribeSonInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Instances: 实例列表
        :type Instances: list of InstanceOpsDto
        :param _CheckFather: 检查父任务类型, true: 检查父任务; false: 不检查父任务 
        :type CheckFather: bool
        :param _RerunType: 重跑类型, 1: 自身; 3: 孩子; 2: 自身以及孩子 
        :type RerunType: str
        :param _DependentWay: 实例依赖方式, 1: 自依赖; 2: 任务依赖; 3: 自依赖及父子依赖 
        :type DependentWay: str
        :param _SkipEventListening: 重跑忽略事件监听与否 
        :type SkipEventListening: bool
        :param _SonInstanceType: 下游实例范围 1: 所在工作流 2: 所在项目 3: 所有跨工作流依赖的项目
        :type SonInstanceType: str
        :param _SearchCondition: 查询条件
        :type SearchCondition: :class:`tencentcloud.wedata.v20210820.models.InstanceApiOpsRequest`
        :param _OptType: 访问类型
        :type OptType: str
        :param _OperatorName: 操作者名称
        :type OperatorName: str
        :param _OperatorId: 操作者id
        :type OperatorId: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _ProjectIdent: 项目标志
        :type ProjectIdent: str
        :param _ProjectName: 项目名称
        :type ProjectName: str
        :param _PageIndex: 索引页码
        :type PageIndex: int
        :param _PageSize: 页面大小
        :type PageSize: int
        :param _Count: 数据总数
        :type Count: int
        :param _RequestBaseInfo: 基础请求信息
        :type RequestBaseInfo: :class:`tencentcloud.wedata.v20210820.models.ProjectBaseInfoOpsRequest`
        :param _IsCount: 是否计算总数
        :type IsCount: bool
        """
        self._Instances = None
        self._CheckFather = None
        self._RerunType = None
        self._DependentWay = None
        self._SkipEventListening = None
        self._SonInstanceType = None
        self._SearchCondition = None
        self._OptType = None
        self._OperatorName = None
        self._OperatorId = None
        self._ProjectId = None
        self._ProjectIdent = None
        self._ProjectName = None
        self._PageIndex = None
        self._PageSize = None
        self._Count = None
        self._RequestBaseInfo = None
        self._IsCount = None

    @property
    def Instances(self):
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances

    @property
    def CheckFather(self):
        return self._CheckFather

    @CheckFather.setter
    def CheckFather(self, CheckFather):
        self._CheckFather = CheckFather

    @property
    def RerunType(self):
        return self._RerunType

    @RerunType.setter
    def RerunType(self, RerunType):
        self._RerunType = RerunType

    @property
    def DependentWay(self):
        return self._DependentWay

    @DependentWay.setter
    def DependentWay(self, DependentWay):
        self._DependentWay = DependentWay

    @property
    def SkipEventListening(self):
        return self._SkipEventListening

    @SkipEventListening.setter
    def SkipEventListening(self, SkipEventListening):
        self._SkipEventListening = SkipEventListening

    @property
    def SonInstanceType(self):
        return self._SonInstanceType

    @SonInstanceType.setter
    def SonInstanceType(self, SonInstanceType):
        self._SonInstanceType = SonInstanceType

    @property
    def SearchCondition(self):
        return self._SearchCondition

    @SearchCondition.setter
    def SearchCondition(self, SearchCondition):
        self._SearchCondition = SearchCondition

    @property
    def OptType(self):
        return self._OptType

    @OptType.setter
    def OptType(self, OptType):
        self._OptType = OptType

    @property
    def OperatorName(self):
        return self._OperatorName

    @OperatorName.setter
    def OperatorName(self, OperatorName):
        self._OperatorName = OperatorName

    @property
    def OperatorId(self):
        return self._OperatorId

    @OperatorId.setter
    def OperatorId(self, OperatorId):
        self._OperatorId = OperatorId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ProjectIdent(self):
        return self._ProjectIdent

    @ProjectIdent.setter
    def ProjectIdent(self, ProjectIdent):
        self._ProjectIdent = ProjectIdent

    @property
    def ProjectName(self):
        return self._ProjectName

    @ProjectName.setter
    def ProjectName(self, ProjectName):
        self._ProjectName = ProjectName

    @property
    def PageIndex(self):
        return self._PageIndex

    @PageIndex.setter
    def PageIndex(self, PageIndex):
        self._PageIndex = PageIndex

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Count(self):
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def RequestBaseInfo(self):
        return self._RequestBaseInfo

    @RequestBaseInfo.setter
    def RequestBaseInfo(self, RequestBaseInfo):
        self._RequestBaseInfo = RequestBaseInfo

    @property
    def IsCount(self):
        return self._IsCount

    @IsCount.setter
    def IsCount(self, IsCount):
        self._IsCount = IsCount


    def _deserialize(self, params):
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = InstanceOpsDto()
                obj._deserialize(item)
                self._Instances.append(obj)
        self._CheckFather = params.get("CheckFather")
        self._RerunType = params.get("RerunType")
        self._DependentWay = params.get("DependentWay")
        self._SkipEventListening = params.get("SkipEventListening")
        self._SonInstanceType = params.get("SonInstanceType")
        if params.get("SearchCondition") is not None:
            self._SearchCondition = InstanceApiOpsRequest()
            self._SearchCondition._deserialize(params.get("SearchCondition"))
        self._OptType = params.get("OptType")
        self._OperatorName = params.get("OperatorName")
        self._OperatorId = params.get("OperatorId")
        self._ProjectId = params.get("ProjectId")
        self._ProjectIdent = params.get("ProjectIdent")
        self._ProjectName = params.get("ProjectName")
        self._PageIndex = params.get("PageIndex")
        self._PageSize = params.get("PageSize")
        self._Count = params.get("Count")
        if params.get("RequestBaseInfo") is not None:
            self._RequestBaseInfo = ProjectBaseInfoOpsRequest()
            self._RequestBaseInfo._deserialize(params.get("RequestBaseInfo"))
        self._IsCount = params.get("IsCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSonInstancesResponse(AbstractModel):
    """DescribeSonInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 结果集
        :type Data: :class:`tencentcloud.wedata.v20210820.models.CollectionInstanceOpsDto`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = CollectionInstanceOpsDto()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeStandardRuleDetailInfoListRequest(AbstractModel):
    """DescribeStandardRuleDetailInfoList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 空间、项目id
        :type ProjectId: str
        :param _Type: 标准分类11编码映射 12数据过滤 13字符串转换 14数据元定义 15正则表达 16术语词典
        :type Type: int
        """
        self._ProjectId = None
        self._Type = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeStandardRuleDetailInfoListResponse(AbstractModel):
    """DescribeStandardRuleDetailInfoList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _StandardRuleDetailList: 返回值
注意：此字段可能返回 null，表示取不到有效值。
        :type StandardRuleDetailList: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._StandardRuleDetailList = None
        self._RequestId = None

    @property
    def StandardRuleDetailList(self):
        return self._StandardRuleDetailList

    @StandardRuleDetailList.setter
    def StandardRuleDetailList(self, StandardRuleDetailList):
        self._StandardRuleDetailList = StandardRuleDetailList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._StandardRuleDetailList = params.get("StandardRuleDetailList")
        self._RequestId = params.get("RequestId")


class DescribeStatisticInstanceStatusTrendOpsRequest(AbstractModel):
    """DescribeStatisticInstanceStatusTrendOps请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _TaskTypeId: 任务类型Id
        :type TaskTypeId: str
        :param _TimeType: 时间类型
        :type TimeType: str
        :param _TypeName: 任务类型名称
        :type TypeName: str
        :param _StartTime: 开始时间
        :type StartTime: str
        :param _EndTime: 结束时间
        :type EndTime: str
        :param _ExecutionGroupId: 资源组ID
        :type ExecutionGroupId: str
        :param _ExecutionGroupName: 资源组名称
        :type ExecutionGroupName: str
        :param _InCharge: 1
        :type InCharge: str
        :param _TaskType: 1
        :type TaskType: int
        :param _StateList: 1
        :type StateList: list of int
        :param _AggregationUnit: D代表天，H代表小时
        :type AggregationUnit: str
        :param _AverageWindowSize: 1
        :type AverageWindowSize: int
        :param _WorkflowId: 工作流ID
        :type WorkflowId: str
        """
        self._ProjectId = None
        self._TaskTypeId = None
        self._TimeType = None
        self._TypeName = None
        self._StartTime = None
        self._EndTime = None
        self._ExecutionGroupId = None
        self._ExecutionGroupName = None
        self._InCharge = None
        self._TaskType = None
        self._StateList = None
        self._AggregationUnit = None
        self._AverageWindowSize = None
        self._WorkflowId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskTypeId(self):
        return self._TaskTypeId

    @TaskTypeId.setter
    def TaskTypeId(self, TaskTypeId):
        self._TaskTypeId = TaskTypeId

    @property
    def TimeType(self):
        return self._TimeType

    @TimeType.setter
    def TimeType(self, TimeType):
        self._TimeType = TimeType

    @property
    def TypeName(self):
        return self._TypeName

    @TypeName.setter
    def TypeName(self, TypeName):
        self._TypeName = TypeName

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def ExecutionGroupId(self):
        return self._ExecutionGroupId

    @ExecutionGroupId.setter
    def ExecutionGroupId(self, ExecutionGroupId):
        self._ExecutionGroupId = ExecutionGroupId

    @property
    def ExecutionGroupName(self):
        return self._ExecutionGroupName

    @ExecutionGroupName.setter
    def ExecutionGroupName(self, ExecutionGroupName):
        self._ExecutionGroupName = ExecutionGroupName

    @property
    def InCharge(self):
        return self._InCharge

    @InCharge.setter
    def InCharge(self, InCharge):
        self._InCharge = InCharge

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def StateList(self):
        return self._StateList

    @StateList.setter
    def StateList(self, StateList):
        self._StateList = StateList

    @property
    def AggregationUnit(self):
        return self._AggregationUnit

    @AggregationUnit.setter
    def AggregationUnit(self, AggregationUnit):
        self._AggregationUnit = AggregationUnit

    @property
    def AverageWindowSize(self):
        return self._AverageWindowSize

    @AverageWindowSize.setter
    def AverageWindowSize(self, AverageWindowSize):
        self._AverageWindowSize = AverageWindowSize

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TaskTypeId = params.get("TaskTypeId")
        self._TimeType = params.get("TimeType")
        self._TypeName = params.get("TypeName")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._ExecutionGroupId = params.get("ExecutionGroupId")
        self._ExecutionGroupName = params.get("ExecutionGroupName")
        self._InCharge = params.get("InCharge")
        self._TaskType = params.get("TaskType")
        self._StateList = params.get("StateList")
        self._AggregationUnit = params.get("AggregationUnit")
        self._AverageWindowSize = params.get("AverageWindowSize")
        self._WorkflowId = params.get("WorkflowId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeStatisticInstanceStatusTrendOpsResponse(AbstractModel):
    """DescribeStatisticInstanceStatusTrendOps返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 实例状态统计结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of InstanceStatisticInfo
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = InstanceStatisticInfo()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeStreamTaskLogListRequest(AbstractModel):
    """DescribeStreamTaskLogList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _TaskId: 任务ID
        :type TaskId: str
        :param _JobId: 作业ID
        :type JobId: str
        :param _EndTime: 结束时间
        :type EndTime: int
        :param _StartTime: 开始时间
        :type StartTime: int
        :param _Container: container名字
        :type Container: str
        :param _Limit: 条数
        :type Limit: int
        :param _OrderType: 排序类型 desc asc
        :type OrderType: str
        :param _RunningOrderId: 作业运行的实例ID
        :type RunningOrderId: int
        :param _Keyword: 关键字
        :type Keyword: str
        """
        self._ProjectId = None
        self._TaskId = None
        self._JobId = None
        self._EndTime = None
        self._StartTime = None
        self._Container = None
        self._Limit = None
        self._OrderType = None
        self._RunningOrderId = None
        self._Keyword = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def Container(self):
        return self._Container

    @Container.setter
    def Container(self, Container):
        self._Container = Container

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def OrderType(self):
        return self._OrderType

    @OrderType.setter
    def OrderType(self, OrderType):
        self._OrderType = OrderType

    @property
    def RunningOrderId(self):
        return self._RunningOrderId

    @RunningOrderId.setter
    def RunningOrderId(self, RunningOrderId):
        self._RunningOrderId = RunningOrderId

    @property
    def Keyword(self):
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TaskId = params.get("TaskId")
        self._JobId = params.get("JobId")
        self._EndTime = params.get("EndTime")
        self._StartTime = params.get("StartTime")
        self._Container = params.get("Container")
        self._Limit = params.get("Limit")
        self._OrderType = params.get("OrderType")
        self._RunningOrderId = params.get("RunningOrderId")
        self._Keyword = params.get("Keyword")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeStreamTaskLogListResponse(AbstractModel):
    """DescribeStreamTaskLogList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ListOver: 是否是全量
注意：此字段可能返回 null，表示取不到有效值。
        :type ListOver: bool
        :param _LogContentList: 日志集合
注意：此字段可能返回 null，表示取不到有效值。
        :type LogContentList: list of LogContentInfo
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ListOver = None
        self._LogContentList = None
        self._RequestId = None

    @property
    def ListOver(self):
        return self._ListOver

    @ListOver.setter
    def ListOver(self, ListOver):
        self._ListOver = ListOver

    @property
    def LogContentList(self):
        return self._LogContentList

    @LogContentList.setter
    def LogContentList(self, LogContentList):
        self._LogContentList = LogContentList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ListOver = params.get("ListOver")
        if params.get("LogContentList") is not None:
            self._LogContentList = []
            for item in params.get("LogContentList"):
                obj = LogContentInfo()
                obj._deserialize(item)
                self._LogContentList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSuccessorOpsTaskInfosRequest(AbstractModel):
    """DescribeSuccessorOpsTaskInfos请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        """
        self._TaskId = None
        self._ProjectId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSuccessorOpsTaskInfosResponse(AbstractModel):
    """DescribeSuccessorOpsTaskInfos返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 下游任务列表
        :type Data: list of TaskOpsDto
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = TaskOpsDto()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTableBasicInfoRequest(AbstractModel):
    """DescribeTableBasicInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PageNumber: 分页页码
        :type PageNumber: int
        :param _PageSize: 分页大小
        :type PageSize: int
        :param _Filters: 过滤字段
        :type Filters: list of Filter
        :param _OrderFields: 排序字段
        :type OrderFields: list of OrderField
        """
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None
        self._OrderFields = None

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields


    def _deserialize(self, params):
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTableBasicInfoResponse(AbstractModel):
    """DescribeTableBasicInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TableBasicInfoList: 表元数据
注意：此字段可能返回 null，表示取不到有效值。
        :type TableBasicInfoList: list of TableBasicInfo
        :param _TotalCount: 总条数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TableBasicInfoList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def TableBasicInfoList(self):
        return self._TableBasicInfoList

    @TableBasicInfoList.setter
    def TableBasicInfoList(self, TableBasicInfoList):
        self._TableBasicInfoList = TableBasicInfoList

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TableBasicInfoList") is not None:
            self._TableBasicInfoList = []
            for item in params.get("TableBasicInfoList"):
                obj = TableBasicInfo()
                obj._deserialize(item)
                self._TableBasicInfoList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeTableInfoListRequest(AbstractModel):
    """DescribeTableInfoList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 表名
        :type Filters: list of Filter
        :param _ConnectionType: 如果是hive这里写rpc，如果是其他类型不传
        :type ConnectionType: str
        :param _Catalog: 数据库源类型
        :type Catalog: str
        """
        self._Filters = None
        self._ConnectionType = None
        self._Catalog = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def ConnectionType(self):
        return self._ConnectionType

    @ConnectionType.setter
    def ConnectionType(self, ConnectionType):
        self._ConnectionType = ConnectionType

    @property
    def Catalog(self):
        return self._Catalog

    @Catalog.setter
    def Catalog(self, Catalog):
        self._Catalog = Catalog


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._ConnectionType = params.get("ConnectionType")
        self._Catalog = params.get("Catalog")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTableInfoListResponse(AbstractModel):
    """DescribeTableInfoList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TableInfo: 表信息
注意：此字段可能返回 null，表示取不到有效值。
        :type TableInfo: list of TableInfo
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TableInfo = None
        self._RequestId = None

    @property
    def TableInfo(self):
        return self._TableInfo

    @TableInfo.setter
    def TableInfo(self, TableInfo):
        self._TableInfo = TableInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TableInfo") is not None:
            self._TableInfo = []
            for item in params.get("TableInfo"):
                obj = TableInfo()
                obj._deserialize(item)
                self._TableInfo.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTableLineageInfoRequest(AbstractModel):
    """DescribeTableLineageInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Direction: 查询方向，INPUT,OUTPUT,BOTH枚举值
        :type Direction: str
        :param _Data: 表信息
        :type Data: :class:`tencentcloud.wedata.v20210820.models.TableLineageInfo`
        :param _InputDepth: 单次查询入度,默认 1
        :type InputDepth: int
        :param _OutputDepth: 单次查询出度,默认 1
        :type OutputDepth: int
        :param _ExtParams: 额外参数（传递调用方信息）
        :type ExtParams: list of LineageParamRecord
        :param _IgnoreTemp: 是否过滤临时表,默认true
        :type IgnoreTemp: bool
        :param _RecursiveSecond: 是否递归查询二级节点数目，默认为true
        :type RecursiveSecond: bool
        """
        self._Direction = None
        self._Data = None
        self._InputDepth = None
        self._OutputDepth = None
        self._ExtParams = None
        self._IgnoreTemp = None
        self._RecursiveSecond = None

    @property
    def Direction(self):
        return self._Direction

    @Direction.setter
    def Direction(self, Direction):
        self._Direction = Direction

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def InputDepth(self):
        return self._InputDepth

    @InputDepth.setter
    def InputDepth(self, InputDepth):
        self._InputDepth = InputDepth

    @property
    def OutputDepth(self):
        return self._OutputDepth

    @OutputDepth.setter
    def OutputDepth(self, OutputDepth):
        self._OutputDepth = OutputDepth

    @property
    def ExtParams(self):
        return self._ExtParams

    @ExtParams.setter
    def ExtParams(self, ExtParams):
        self._ExtParams = ExtParams

    @property
    def IgnoreTemp(self):
        return self._IgnoreTemp

    @IgnoreTemp.setter
    def IgnoreTemp(self, IgnoreTemp):
        self._IgnoreTemp = IgnoreTemp

    @property
    def RecursiveSecond(self):
        return self._RecursiveSecond

    @RecursiveSecond.setter
    def RecursiveSecond(self, RecursiveSecond):
        self._RecursiveSecond = RecursiveSecond


    def _deserialize(self, params):
        self._Direction = params.get("Direction")
        if params.get("Data") is not None:
            self._Data = TableLineageInfo()
            self._Data._deserialize(params.get("Data"))
        self._InputDepth = params.get("InputDepth")
        self._OutputDepth = params.get("OutputDepth")
        if params.get("ExtParams") is not None:
            self._ExtParams = []
            for item in params.get("ExtParams"):
                obj = LineageParamRecord()
                obj._deserialize(item)
                self._ExtParams.append(obj)
        self._IgnoreTemp = params.get("IgnoreTemp")
        self._RecursiveSecond = params.get("RecursiveSecond")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTableLineageInfoResponse(AbstractModel):
    """DescribeTableLineageInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TableLineageBasicInfo: 表血缘信息
注意：此字段可能返回 null，表示取不到有效值。
        :type TableLineageBasicInfo: :class:`tencentcloud.wedata.v20210820.models.TableLineageBaseInfo`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TableLineageBasicInfo = None
        self._RequestId = None

    @property
    def TableLineageBasicInfo(self):
        return self._TableLineageBasicInfo

    @TableLineageBasicInfo.setter
    def TableLineageBasicInfo(self, TableLineageBasicInfo):
        self._TableLineageBasicInfo = TableLineageBasicInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TableLineageBasicInfo") is not None:
            self._TableLineageBasicInfo = TableLineageBaseInfo()
            self._TableLineageBasicInfo._deserialize(params.get("TableLineageBasicInfo"))
        self._RequestId = params.get("RequestId")


class DescribeTableLineageRequest(AbstractModel):
    """DescribeTableLineage请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Direction: 查询方向，INPUT,OUTPUT,BOTH枚举值
        :type Direction: str
        :param _Data: 表信息
        :type Data: :class:`tencentcloud.wedata.v20210820.models.TableLineageInfo`
        :param _InputDepth: 单次查询入度,默认 1
        :type InputDepth: int
        :param _OutputDepth: 单次查询出度,默认 1
        :type OutputDepth: int
        :param _ExtParams: 额外参数（传递调用方信息）
        :type ExtParams: list of LineageParamRecord
        :param _IgnoreTemp: 是否过滤临时表,默认true
        :type IgnoreTemp: bool
        :param _RecursiveSecond: 是否递归查询二级节点数目，默认为true
        :type RecursiveSecond: bool
        """
        self._Direction = None
        self._Data = None
        self._InputDepth = None
        self._OutputDepth = None
        self._ExtParams = None
        self._IgnoreTemp = None
        self._RecursiveSecond = None

    @property
    def Direction(self):
        return self._Direction

    @Direction.setter
    def Direction(self, Direction):
        self._Direction = Direction

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def InputDepth(self):
        return self._InputDepth

    @InputDepth.setter
    def InputDepth(self, InputDepth):
        self._InputDepth = InputDepth

    @property
    def OutputDepth(self):
        return self._OutputDepth

    @OutputDepth.setter
    def OutputDepth(self, OutputDepth):
        self._OutputDepth = OutputDepth

    @property
    def ExtParams(self):
        return self._ExtParams

    @ExtParams.setter
    def ExtParams(self, ExtParams):
        self._ExtParams = ExtParams

    @property
    def IgnoreTemp(self):
        return self._IgnoreTemp

    @IgnoreTemp.setter
    def IgnoreTemp(self, IgnoreTemp):
        self._IgnoreTemp = IgnoreTemp

    @property
    def RecursiveSecond(self):
        return self._RecursiveSecond

    @RecursiveSecond.setter
    def RecursiveSecond(self, RecursiveSecond):
        self._RecursiveSecond = RecursiveSecond


    def _deserialize(self, params):
        self._Direction = params.get("Direction")
        if params.get("Data") is not None:
            self._Data = TableLineageInfo()
            self._Data._deserialize(params.get("Data"))
        self._InputDepth = params.get("InputDepth")
        self._OutputDepth = params.get("OutputDepth")
        if params.get("ExtParams") is not None:
            self._ExtParams = []
            for item in params.get("ExtParams"):
                obj = LineageParamRecord()
                obj._deserialize(item)
                self._ExtParams.append(obj)
        self._IgnoreTemp = params.get("IgnoreTemp")
        self._RecursiveSecond = params.get("RecursiveSecond")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTableLineageResponse(AbstractModel):
    """DescribeTableLineage返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TableLineage: 表血缘信息
注意：此字段可能返回 null，表示取不到有效值。
        :type TableLineage: :class:`tencentcloud.wedata.v20210820.models.TableLineageInfo`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TableLineage = None
        self._RequestId = None

    @property
    def TableLineage(self):
        return self._TableLineage

    @TableLineage.setter
    def TableLineage(self, TableLineage):
        self._TableLineage = TableLineage

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TableLineage") is not None:
            self._TableLineage = TableLineageInfo()
            self._TableLineage._deserialize(params.get("TableLineage"))
        self._RequestId = params.get("RequestId")


class DescribeTableMetaRequest(AbstractModel):
    """DescribeTableMeta请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TableId: 表唯一id
        :type TableId: str
        """
        self._TableId = None

    @property
    def TableId(self):
        return self._TableId

    @TableId.setter
    def TableId(self, TableId):
        self._TableId = TableId


    def _deserialize(self, params):
        self._TableId = params.get("TableId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTableMetaResponse(AbstractModel):
    """DescribeTableMeta返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TableMeta: 表的元数据信息
注意：此字段可能返回 null，表示取不到有效值。
        :type TableMeta: :class:`tencentcloud.wedata.v20210820.models.TableMeta`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TableMeta = None
        self._RequestId = None

    @property
    def TableMeta(self):
        return self._TableMeta

    @TableMeta.setter
    def TableMeta(self, TableMeta):
        self._TableMeta = TableMeta

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TableMeta") is not None:
            self._TableMeta = TableMeta()
            self._TableMeta._deserialize(params.get("TableMeta"))
        self._RequestId = params.get("RequestId")


class DescribeTableMetasRequest(AbstractModel):
    """DescribeTableMetas请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PageNumber: 分页页码
        :type PageNumber: int
        :param _PageSize: 分页大小
        :type PageSize: int
        :param _Filters: 过滤字段
        :type Filters: list of Filter
        :param _OrderFields: 排序字段
        :type OrderFields: list of OrderField
        """
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None
        self._OrderFields = None

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields


    def _deserialize(self, params):
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTableMetasResponse(AbstractModel):
    """DescribeTableMetas返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TableMetas: 表元数据
注意：此字段可能返回 null，表示取不到有效值。
        :type TableMetas: list of TableMeta
        :param _TotalCount: 总条数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TableMetas = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def TableMetas(self):
        return self._TableMetas

    @TableMetas.setter
    def TableMetas(self, TableMetas):
        self._TableMetas = TableMetas

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TableMetas") is not None:
            self._TableMetas = []
            for item in params.get("TableMetas"):
                obj = TableMeta()
                obj._deserialize(item)
                self._TableMetas.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeTableQualityDetailsRequest(AbstractModel):
    """DescribeTableQualityDetails请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StatisticsDate: 统计日期
        :type StatisticsDate: int
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _PageNumber: 分页序号
        :type PageNumber: int
        :param _PageSize: 分页大小
        :type PageSize: int
        :param _Filters: 过滤参数TableName、DatabaseId 、DatabaseName、OwnerUserName
        :type Filters: list of Filter
        :param _OrderFields: 排序参数 排序方式 DESC 或者 ASC，表得分排序 TableScore
        :type OrderFields: list of OrderField
        :param _DatasourceId: 数据来源id
        :type DatasourceId: str
        :param _ScoreType: 1:按全维度权重计算,2:按已配置维度权重计算,3:不按维度权重计算,默认1
        :type ScoreType: str
        """
        self._StatisticsDate = None
        self._ProjectId = None
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None
        self._OrderFields = None
        self._DatasourceId = None
        self._ScoreType = None

    @property
    def StatisticsDate(self):
        return self._StatisticsDate

    @StatisticsDate.setter
    def StatisticsDate(self, StatisticsDate):
        self._StatisticsDate = StatisticsDate

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def ScoreType(self):
        return self._ScoreType

    @ScoreType.setter
    def ScoreType(self, ScoreType):
        self._ScoreType = ScoreType


    def _deserialize(self, params):
        self._StatisticsDate = params.get("StatisticsDate")
        self._ProjectId = params.get("ProjectId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        self._DatasourceId = params.get("DatasourceId")
        self._ScoreType = params.get("ScoreType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTableQualityDetailsResponse(AbstractModel):
    """DescribeTableQualityDetails返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 表质量分详情结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.TableQualityDetailPage`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = TableQualityDetailPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeTableSchemaInfoRequest(AbstractModel):
    """DescribeTableSchemaInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 表名称
        :type Name: str
        :param _DatabaseName: 数据库名称
        :type DatabaseName: str
        :param _MsType: 数据源的类型（例如MYSQL、HIVE、KAFKA等）
        :type MsType: str
        :param _DatasourceId: 数据源id
        :type DatasourceId: str
        :param _ConnectionType: 连接类型（示例值rpc）
        :type ConnectionType: str
        :param _SchemaName: 元数据Database下的Schema名称
        :type SchemaName: str
        """
        self._Name = None
        self._DatabaseName = None
        self._MsType = None
        self._DatasourceId = None
        self._ConnectionType = None
        self._SchemaName = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def DatabaseName(self):
        return self._DatabaseName

    @DatabaseName.setter
    def DatabaseName(self, DatabaseName):
        self._DatabaseName = DatabaseName

    @property
    def MsType(self):
        return self._MsType

    @MsType.setter
    def MsType(self, MsType):
        self._MsType = MsType

    @property
    def DatasourceId(self):
        return self._DatasourceId

    @DatasourceId.setter
    def DatasourceId(self, DatasourceId):
        self._DatasourceId = DatasourceId

    @property
    def ConnectionType(self):
        return self._ConnectionType

    @ConnectionType.setter
    def ConnectionType(self, ConnectionType):
        self._ConnectionType = ConnectionType

    @property
    def SchemaName(self):
        return self._SchemaName

    @SchemaName.setter
    def SchemaName(self, SchemaName):
        self._SchemaName = SchemaName


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._DatabaseName = params.get("DatabaseName")
        self._MsType = params.get("MsType")
        self._DatasourceId = params.get("DatasourceId")
        self._ConnectionType = params.get("ConnectionType")
        self._SchemaName = params.get("SchemaName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTableSchemaInfoResponse(AbstractModel):
    """DescribeTableSchemaInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SchemaInfoList: 123
注意：此字段可能返回 null，表示取不到有效值。
        :type SchemaInfoList: list of SchemaDetail
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SchemaInfoList = None
        self._RequestId = None

    @property
    def SchemaInfoList(self):
        return self._SchemaInfoList

    @SchemaInfoList.setter
    def SchemaInfoList(self, SchemaInfoList):
        self._SchemaInfoList = SchemaInfoList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SchemaInfoList") is not None:
            self._SchemaInfoList = []
            for item in params.get("SchemaInfoList"):
                obj = SchemaDetail()
                obj._deserialize(item)
                self._SchemaInfoList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTableScoreTrendRequest(AbstractModel):
    """DescribeTableScoreTrend请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _StatisticsStartDate: 开始时间 秒级时间戳
        :type StatisticsStartDate: int
        :param _StatisticsEndDate: 结束时间 秒级时间戳
        :type StatisticsEndDate: int
        :param _TableId: 表id
        :type TableId: str
        :param _ScoreType: 1:按全维度权重计算,2:按已配置维度权重计算,3:不按维度权重计算,默认1
        :type ScoreType: str
        """
        self._ProjectId = None
        self._StatisticsStartDate = None
        self._StatisticsEndDate = None
        self._TableId = None
        self._ScoreType = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def StatisticsStartDate(self):
        return self._StatisticsStartDate

    @StatisticsStartDate.setter
    def StatisticsStartDate(self, StatisticsStartDate):
        self._StatisticsStartDate = StatisticsStartDate

    @property
    def StatisticsEndDate(self):
        return self._StatisticsEndDate

    @StatisticsEndDate.setter
    def StatisticsEndDate(self, StatisticsEndDate):
        self._StatisticsEndDate = StatisticsEndDate

    @property
    def TableId(self):
        return self._TableId

    @TableId.setter
    def TableId(self, TableId):
        self._TableId = TableId

    @property
    def ScoreType(self):
        return self._ScoreType

    @ScoreType.setter
    def ScoreType(self, ScoreType):
        self._ScoreType = ScoreType


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._StatisticsStartDate = params.get("StatisticsStartDate")
        self._StatisticsEndDate = params.get("StatisticsEndDate")
        self._TableId = params.get("TableId")
        self._ScoreType = params.get("ScoreType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTableScoreTrendResponse(AbstractModel):
    """DescribeTableScoreTrend返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 表得分趋势
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.QualityScoreTrend`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = QualityScoreTrend()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeTaskAlarmRegulationsRequest(AbstractModel):
    """DescribeTaskAlarmRegulations请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _PageNumber: 当前页
        :type PageNumber: int
        :param _PageSize: 每页记录数
        :type PageSize: int
        :param _Filters: 过滤条件(name有RegularStatus、AlarmLevel、AlarmIndicator、RegularName)
        :type Filters: list of Filter
        :param _OrderFields: 排序条件(RegularId)
        :type OrderFields: list of OrderField
        :param _TaskId: 任务ID
        :type TaskId: str
        :param _TaskType: 任务类型(201代表实时任务，202代表离线任务)
        :type TaskType: int
        """
        self._ProjectId = None
        self._PageNumber = None
        self._PageSize = None
        self._Filters = None
        self._OrderFields = None
        self._TaskId = None
        self._TaskType = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        self._TaskId = params.get("TaskId")
        self._TaskType = params.get("TaskType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskAlarmRegulationsResponse(AbstractModel):
    """DescribeTaskAlarmRegulations返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskAlarmInfos: 告警规则信息
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskAlarmInfos: list of TaskAlarmInfo
        :param _TotalCount: 总记录数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskAlarmInfos = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def TaskAlarmInfos(self):
        return self._TaskAlarmInfos

    @TaskAlarmInfos.setter
    def TaskAlarmInfos(self, TaskAlarmInfos):
        self._TaskAlarmInfos = TaskAlarmInfos

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TaskAlarmInfos") is not None:
            self._TaskAlarmInfos = []
            for item in params.get("TaskAlarmInfos"):
                obj = TaskAlarmInfo()
                obj._deserialize(item)
                self._TaskAlarmInfos.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeTaskByCycleReportRequest(AbstractModel):
    """DescribeTaskByCycleReport请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _Type: 任务周期类型
        :type Type: str
        :param _StartTime: 开始时间
        :type StartTime: str
        :param _EndTime: 结束时间
        :type EndTime: str
        """
        self._ProjectId = None
        self._Type = None
        self._StartTime = None
        self._EndTime = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._Type = params.get("Type")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskByCycleReportResponse(AbstractModel):
    """DescribeTaskByCycleReport返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 任务周期增长趋势统计
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of TaskByStatus
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = TaskByStatus()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTaskByCycleRequest(AbstractModel):
    """DescribeTaskByCycle请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _InCharge: 1
        :type InCharge: str
        :param _WorkflowId: 工作流ID
        :type WorkflowId: str
        """
        self._ProjectId = None
        self._InCharge = None
        self._WorkflowId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def InCharge(self):
        return self._InCharge

    @InCharge.setter
    def InCharge(self, InCharge):
        self._InCharge = InCharge

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._InCharge = params.get("InCharge")
        self._WorkflowId = params.get("WorkflowId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskByCycleResponse(AbstractModel):
    """DescribeTaskByCycle返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 周期任务统计值
        :type Data: list of TaskByCycle
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = TaskByCycle()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTaskByStatusReportRequest(AbstractModel):
    """DescribeTaskByStatusReport请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID
        :type ProjectId: str
        :param _Type: 时间类型
        :type Type: str
        :param _TaskType: 类型
        :type TaskType: str
        :param _TypeName: 类型名称
        :type TypeName: str
        :param _StartTime: 开始时间
        :type StartTime: str
        :param _EndTime: 结束时间
        :type EndTime: str
        :param _AggregationUnit: 无
        :type AggregationUnit: str
        :param _CycleUnit: 无
        :type CycleUnit: str
        :param _Status: 无
        :type Status: str
        :param _InCharge: 无
        :type InCharge: str
        :param _WorkflowId: 工作流ID
        :type WorkflowId: str
        """
        self._ProjectId = None
        self._Type = None
        self._TaskType = None
        self._TypeName = None
        self._StartTime = None
        self._EndTime = None
        self._AggregationUnit = None
        self._CycleUnit = None
        self._Status = None
        self._InCharge = None
        self._WorkflowId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def TypeName(self):
        return self._TypeName

    @TypeName.setter
    def TypeName(self, TypeName):
        self._TypeName = TypeName

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def AggregationUnit(self):
        return self._AggregationUnit

    @AggregationUnit.setter
    def AggregationUnit(self, AggregationUnit):
        self._AggregationUnit = AggregationUnit

    @property
    def CycleUnit(self):
        return self._CycleUnit

    @CycleUnit.setter
    def CycleUnit(self, CycleUnit):
        self._CycleUnit = CycleUnit

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def InCharge(self):
        return self._InCharge

    @InCharge.setter
    def InCharge(self, InCharge):
        self._InCharge = InCharge

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._Type = params.get("Type")
        self._TaskType = params.get("TaskType")
        self._TypeName = params.get("TypeName")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._AggregationUnit = params.get("AggregationUnit")
        self._CycleUnit = params.get("CycleUnit")
        self._Status = params.get("Status")
        self._InCharge = params.get("InCharge")
        self._WorkflowId = params.get("WorkflowId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskByStatusReportResponse(AbstractModel):
    """DescribeTaskByStatusReport返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 任务上报趋势指标
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: list of TaskByStatus
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = TaskByStatus()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTaskDetailRequest(AbstractModel):
    """DescribeTaskDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _TaskId: 任务ID
        :type TaskId: str
        :param _TaskAlarmStatus: 任务告警状态
        :type TaskAlarmStatus: int
        """
        self._ProjectId = None
        self._TaskId = None
        self._TaskAlarmStatus = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TaskAlarmStatus(self):
        return self._TaskAlarmStatus

    @TaskAlarmStatus.setter
    def TaskAlarmStatus(self, TaskAlarmStatus):
        self._TaskAlarmStatus = TaskAlarmStatus


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TaskId = params.get("TaskId")
        self._TaskAlarmStatus = params.get("TaskAlarmStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskDetailResponse(AbstractModel):
    """DescribeTaskDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 任务详情1
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.TaskInfoData`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = TaskInfoData()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeTaskInstanceReportDetailRequest(AbstractModel):
    """DescribeTaskInstanceReportDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: WeData项目ID
        :type ProjectId: str
        :param _TaskId: 任务ID
        :type TaskId: str
        :param _CurRunDate: 任务实例数据时间
        :type CurRunDate: str
        :param _IssueDate: 任务实例运行时间
        :type IssueDate: str
        """
        self._ProjectId = None
        self._TaskId = None
        self._CurRunDate = None
        self._IssueDate = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def CurRunDate(self):
        return self._CurRunDate

    @CurRunDate.setter
    def CurRunDate(self, CurRunDate):
        self._CurRunDate = CurRunDate

    @property
    def IssueDate(self):
        return self._IssueDate

    @IssueDate.setter
    def IssueDate(self, IssueDate):
        self._IssueDate = IssueDate


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TaskId = params.get("TaskId")
        self._CurRunDate = params.get("CurRunDate")
        self._IssueDate = params.get("IssueDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskInstanceReportDetailResponse(AbstractModel):
    """DescribeTaskInstanceReportDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Summary: 任务实例运行指标概览
        :type Summary: :class:`tencentcloud.wedata.v20210820.models.InstanceReportSummary`
        :param _ReadNode: 任务实例读取节点运行指标
        :type ReadNode: :class:`tencentcloud.wedata.v20210820.models.InstanceReportReadNode`
        :param _WriteNode: 任务实例写入节点运行指标
        :type WriteNode: :class:`tencentcloud.wedata.v20210820.models.InstanceReportWriteNode`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Summary = None
        self._ReadNode = None
        self._WriteNode = None
        self._RequestId = None

    @property
    def Summary(self):
        return self._Summary

    @Summary.setter
    def Summary(self, Summary):
        self._Summary = Summary

    @property
    def ReadNode(self):
        return self._ReadNode

    @ReadNode.setter
    def ReadNode(self, ReadNode):
        self._ReadNode = ReadNode

    @property
    def WriteNode(self):
        return self._WriteNode

    @WriteNode.setter
    def WriteNode(self, WriteNode):
        self._WriteNode = WriteNode

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Summary") is not None:
            self._Summary = InstanceReportSummary()
            self._Summary._deserialize(params.get("Summary"))
        if params.get("ReadNode") is not None:
            self._ReadNode = InstanceReportReadNode()
            self._ReadNode._deserialize(params.get("ReadNode"))
        if params.get("WriteNode") is not None:
            self._WriteNode = InstanceReportWriteNode()
            self._WriteNode._deserialize(params.get("WriteNode"))
        self._RequestId = params.get("RequestId")


class DescribeTaskInstanceRequest(AbstractModel):
    """DescribeTaskInstance请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: WeData项目ID
        :type ProjectId: str
        :param _TaskId: 任务ID
        :type TaskId: str
        :param _CurRunDate: 任务实例数据时间
        :type CurRunDate: str
        :param _IssueDate: 任务实例运行时间
        :type IssueDate: str
        """
        self._ProjectId = None
        self._TaskId = None
        self._CurRunDate = None
        self._IssueDate = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def CurRunDate(self):
        return self._CurRunDate

    @CurRunDate.setter
    def CurRunDate(self, CurRunDate):
        self._CurRunDate = CurRunDate

    @property
    def IssueDate(self):
        return self._IssueDate

    @IssueDate.setter
    def IssueDate(self, IssueDate):
        self._IssueDate = IssueDate


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TaskId = params.get("TaskId")
        self._CurRunDate = params.get("CurRunDate")
        self._IssueDate = params.get("IssueDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskInstanceResponse(AbstractModel):
    """DescribeTaskInstance返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskInstanceDetail: 任务实例详情
        :type TaskInstanceDetail: :class:`tencentcloud.wedata.v20210820.models.TaskInstanceDetail`
        :param _Data: 任务实例详情。与TaskInstanceDetail相同含义，优先取Data，Data为空时，取TaskInstanceDetail
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.TaskInstanceDetail`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskInstanceDetail = None
        self._Data = None
        self._RequestId = None

    @property
    def TaskInstanceDetail(self):
        return self._TaskInstanceDetail

    @TaskInstanceDetail.setter
    def TaskInstanceDetail(self, TaskInstanceDetail):
        self._TaskInstanceDetail = TaskInstanceDetail

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TaskInstanceDetail") is not None:
            self._TaskInstanceDetail = TaskInstanceDetail()
            self._TaskInstanceDetail._deserialize(params.get("TaskInstanceDetail"))
        if params.get("Data") is not None:
            self._Data = TaskInstanceDetail()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeTaskInstancesData(AbstractModel):
    """查询任务实例列表

    """

    def __init__(self):
        r"""
        :param _Items: 实例列表
        :type Items: list of TaskInstanceInfo
        :param _TotalCount: 总条数
        :type TotalCount: int
        :param _PageNumber: 页号
        :type PageNumber: int
        :param _PageSize: 页大小
        :type PageSize: int
        """
        self._Items = None
        self._TotalCount = None
        self._PageNumber = None
        self._PageSize = None

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = TaskInstanceInfo()
                obj._deserialize(item)
                self._Items.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskInstancesRequest(AbstractModel):
    """DescribeTaskInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _PageNumber: 页号，默认为1
        :type PageNumber: int
        :param _PageSize: 页大小，默认为10，最大不超过200
        :type PageSize: int
        :param _WorkflowIdList: 工作流id列表
        :type WorkflowIdList: list of str
        :param _WorkflowNameList: 工作流名称列表，支持模糊搜索
        :type WorkflowNameList: list of str
        :param _DateFrom: 起始数据时间，格式yyyy-MM-dd HH:mm:ss
        :type DateFrom: str
        :param _DateTo: 结束数据时间，格式yyyy-MM-dd HH:mm:ss
        :type DateTo: str
        :param _TaskIdList: 任务id列表
        :type TaskIdList: list of str
        :param _TaskNameList: 任务名称列表，支持模糊搜索
        :type TaskNameList: list of str
        :param _InChargeList: 责任人名称列表
        :type InChargeList: list of str
        :param _TaskTypeIdList: 任务类型码列表，26离线同步，30Python，31PySpark，32DLC，33Impala，34Hive SQL，35Shell，36Spark SQL，39Spark，40CDW PG，92MapReduce
        :type TaskTypeIdList: list of int
        :param _StateList: 实例状态列表，0等待事件，1等待上游，2等待运行，3运行中，4正在终止，5失败重试，6失败，7成功
        :type StateList: list of str
        :param _TaskCycleUnitList: 周期类型列表，I分钟，H小时，D天，W周，M月，Y年，O一次性，C crontab
        :type TaskCycleUnitList: list of str
        :param _InstanceType: 实例类型，0补录实例，1周期实例，2非周期实例
        :type InstanceType: int
        :param _OrderFields: 排序字段信息列表，ScheduleDateTime / CostTime / StartTime / EndTime
        :type OrderFields: list of OrderField
        """
        self._ProjectId = None
        self._PageNumber = None
        self._PageSize = None
        self._WorkflowIdList = None
        self._WorkflowNameList = None
        self._DateFrom = None
        self._DateTo = None
        self._TaskIdList = None
        self._TaskNameList = None
        self._InChargeList = None
        self._TaskTypeIdList = None
        self._StateList = None
        self._TaskCycleUnitList = None
        self._InstanceType = None
        self._OrderFields = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def WorkflowIdList(self):
        return self._WorkflowIdList

    @WorkflowIdList.setter
    def WorkflowIdList(self, WorkflowIdList):
        self._WorkflowIdList = WorkflowIdList

    @property
    def WorkflowNameList(self):
        return self._WorkflowNameList

    @WorkflowNameList.setter
    def WorkflowNameList(self, WorkflowNameList):
        self._WorkflowNameList = WorkflowNameList

    @property
    def DateFrom(self):
        return self._DateFrom

    @DateFrom.setter
    def DateFrom(self, DateFrom):
        self._DateFrom = DateFrom

    @property
    def DateTo(self):
        return self._DateTo

    @DateTo.setter
    def DateTo(self, DateTo):
        self._DateTo = DateTo

    @property
    def TaskIdList(self):
        return self._TaskIdList

    @TaskIdList.setter
    def TaskIdList(self, TaskIdList):
        self._TaskIdList = TaskIdList

    @property
    def TaskNameList(self):
        return self._TaskNameList

    @TaskNameList.setter
    def TaskNameList(self, TaskNameList):
        self._TaskNameList = TaskNameList

    @property
    def InChargeList(self):
        return self._InChargeList

    @InChargeList.setter
    def InChargeList(self, InChargeList):
        self._InChargeList = InChargeList

    @property
    def TaskTypeIdList(self):
        return self._TaskTypeIdList

    @TaskTypeIdList.setter
    def TaskTypeIdList(self, TaskTypeIdList):
        self._TaskTypeIdList = TaskTypeIdList

    @property
    def StateList(self):
        return self._StateList

    @StateList.setter
    def StateList(self, StateList):
        self._StateList = StateList

    @property
    def TaskCycleUnitList(self):
        return self._TaskCycleUnitList

    @TaskCycleUnitList.setter
    def TaskCycleUnitList(self, TaskCycleUnitList):
        self._TaskCycleUnitList = TaskCycleUnitList

    @property
    def InstanceType(self):
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def OrderFields(self):
        return self._OrderFields

    @OrderFields.setter
    def OrderFields(self, OrderFields):
        self._OrderFields = OrderFields


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._PageNumber = params.get("PageNumber")
        self._PageSize = params.get("PageSize")
        self._WorkflowIdList = params.get("WorkflowIdList")
        self._WorkflowNameList = params.get("WorkflowNameList")
        self._DateFrom = params.get("DateFrom")
        self._DateTo = params.get("DateTo")
        self._TaskIdList = params.get("TaskIdList")
        self._TaskNameList = params.get("TaskNameList")
        self._InChargeList = params.get("InChargeList")
        self._TaskTypeIdList = params.get("TaskTypeIdList")
        self._StateList = params.get("StateList")
        self._TaskCycleUnitList = params.get("TaskCycleUnitList")
        self._InstanceType = params.get("InstanceType")
        if params.get("OrderFields") is not None:
            self._OrderFields = []
            for item in params.get("OrderFields"):
                obj = OrderField()
                obj._deserialize(item)
                self._OrderFields.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskInstancesResponse(AbstractModel):
    """DescribeTaskInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 无
        :type Data: :class:`tencentcloud.wedata.v20210820.models.DescribeTaskInstancesData`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = DescribeTaskInstancesData()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeTaskLockStatusRequest(AbstractModel):
    """DescribeTaskLockStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _TaskType: 任务类型：201. stream,   202. offline
        :type TaskType: int
        """
        self._TaskId = None
        self._ProjectId = None
        self._TaskType = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ProjectId = params.get("ProjectId")
        self._TaskType = params.get("TaskType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskLockStatusResponse(AbstractModel):
    """DescribeTaskLockStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskLockStatus: 任务锁状态信息
        :type TaskLockStatus: :class:`tencentcloud.wedata.v20210820.models.TaskLockStatus`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskLockStatus = None
        self._RequestId = None

    @property
    def TaskLockStatus(self):
        return self._TaskLockStatus

    @TaskLockStatus.setter
    def TaskLockStatus(self, TaskLockStatus):
        self._TaskLockStatus = TaskLockStatus

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TaskLockStatus") is not None:
            self._TaskLockStatus = TaskLockStatus()
            self._TaskLockStatus._deserialize(params.get("TaskLockStatus"))
        self._RequestId = params.get("RequestId")


class DescribeTaskReportDetailListRequest(AbstractModel):
    """DescribeTaskReportDetailList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: WeData项目id
        :type ProjectId: str
        :param _TaskId: 任务Id
        :type TaskId: str
        :param _BeginDate: 统计周期的开始日期，格式为 yyyy-MM-dd
        :type BeginDate: str
        :param _EndDate: 统计周期的结束日期，格式为 yyyy-MM-dd
        :type EndDate: str
        :param _StateList: 任务状态，多个状态用逗号连接
        :type StateList: str
        :param _SortItem: 排序字段名
        :type SortItem: str
        :param _SortType: 升序或降序，传ASC或DESC
        :type SortType: str
        :param _PageIndex: 页数，从1开始
        :type PageIndex: int
        :param _PageSize: 每页的记录条数，默认10条
        :type PageSize: int
        """
        self._ProjectId = None
        self._TaskId = None
        self._BeginDate = None
        self._EndDate = None
        self._StateList = None
        self._SortItem = None
        self._SortType = None
        self._PageIndex = None
        self._PageSize = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def BeginDate(self):
        return self._BeginDate

    @BeginDate.setter
    def BeginDate(self, BeginDate):
        self._BeginDate = BeginDate

    @property
    def EndDate(self):
        return self._EndDate

    @EndDate.setter
    def EndDate(self, EndDate):
        self._EndDate = EndDate

    @property
    def StateList(self):
        return self._StateList

    @StateList.setter
    def StateList(self, StateList):
        self._StateList = StateList

    @property
    def SortItem(self):
        return self._SortItem

    @SortItem.setter
    def SortItem(self, SortItem):
        self._SortItem = SortItem

    @property
    def SortType(self):
        return self._SortType

    @SortType.setter
    def SortType(self, SortType):
        self._SortType = SortType

    @property
    def PageIndex(self):
        return self._PageIndex

    @PageIndex.setter
    def PageIndex(self, PageIndex):
        self._PageIndex = PageIndex

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._TaskId = params.get("TaskId")
        self._BeginDate = params.get("BeginDate")
        self._EndDate = params.get("EndDate")
        self._StateList = params.get("StateList")
        self._SortItem = params.get("SortItem")
        self._SortType = params.get("SortType")
        self._PageIndex = params.get("PageIndex")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskReportDetailListResponse(AbstractModel):
    """DescribeTaskReportDetailList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _PageIndex: 页码，从1开始
        :type PageIndex: int
        :param _PageSize: 每页的记录数
        :type PageSize: int
        :param _TotalCount: 总记录数
        :type TotalCount: int
        :param _TotalPage: 总页数
        :type TotalPage: int
        :param _Items: 任务运行指标
        :type Items: list of TaskReportDetail
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._PageIndex = None
        self._PageSize = None
        self._TotalCount = None
        self._TotalPage = None
        self._Items = None
        self._RequestId = None

    @property
    def PageIndex(self):
        return self._PageIndex

    @PageIndex.setter
    def PageIndex(self, PageIndex):
        self._PageIndex = PageIndex

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TotalPage(self):
        return self._TotalPage

    @TotalPage.setter
    def TotalPage(self, TotalPage):
        self._TotalPage = TotalPage

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._PageIndex = params.get("PageIndex")
        self._PageSize = params.get("PageSize")
        self._TotalCount = params.get("TotalCount")
        self._TotalPage = params.get("TotalPage")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = TaskReportDetail()
                obj._deserialize(item)
                self._Items.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTaskReportRequest(AbstractModel):
    """DescribeTaskReport请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务Id
        :type TaskId: str
        :param _BeginDate: 统计周期的开始日期，格式为 yyyy-MM-dd
        :type BeginDate: str
        :param _EndDate: 统计周期的结束日期，格式为 yyyy-MM-dd
        :type EndDate: str
        :param _ProjectId: WeData项目id
        :type ProjectId: str
        """
        self._TaskId = None
        self._BeginDate = None
        self._EndDate = None
        self._ProjectId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def BeginDate(self):
        return self._BeginDate

    @BeginDate.setter
    def BeginDate(self, BeginDate):
        self._BeginDate = BeginDate

    @property
    def EndDate(self):
        return self._EndDate

    @EndDate.setter
    def EndDate(self, EndDate):
        self._EndDate = EndDate

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._BeginDate = params.get("BeginDate")
        self._EndDate = params.get("EndDate")
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskReportResponse(AbstractModel):
    """DescribeTaskReport返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalReadRecords: 总读取条数
        :type TotalReadRecords: int
        :param _TotalReadBytes: 总读取字节数，单位为Byte
        :type TotalReadBytes: int
        :param _TotalWriteRecords: 总写入条数
        :type TotalWriteRecords: int
        :param _TotalWriteBytes: 总写入字节数，单位为Byte
        :type TotalWriteBytes: int
        :param _TotalErrorRecords: 总脏数据条数
        :type TotalErrorRecords: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalReadRecords = None
        self._TotalReadBytes = None
        self._TotalWriteRecords = None
        self._TotalWriteBytes = None
        self._TotalErrorRecords = None
        self._RequestId = None

    @property
    def TotalReadRecords(self):
        return self._TotalReadRecords

    @TotalReadRecords.setter
    def TotalReadRecords(self, TotalReadRecords):
        self._TotalReadRecords = TotalReadRecords

    @property
    def TotalReadBytes(self):
        return self._TotalReadBytes

    @TotalReadBytes.setter
    def TotalReadBytes(self, TotalReadBytes):
        self._TotalReadBytes = TotalReadBytes

    @property
    def TotalWriteRecords(self):
        return self._TotalWriteRecords

    @TotalWriteRecords.setter
    def TotalWriteRecords(self, TotalWriteRecords):
        self._TotalWriteRecords = TotalWriteRecords

    @property
    def TotalWriteBytes(self):
        return self._TotalWriteBytes

    @TotalWriteBytes.setter
    def TotalWriteBytes(self, TotalWriteBytes):
        self._TotalWriteBytes = TotalWriteBytes

    @property
    def TotalErrorRecords(self):
        return self._TotalErrorRecords

    @TotalErrorRecords.setter
    def TotalErrorRecords(self, TotalErrorRecords):
        self._TotalErrorRecords = TotalErrorRecords

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalReadRecords = params.get("TotalReadRecords")
        self._TotalReadBytes = params.get("TotalReadBytes")
        self._TotalWriteRecords = params.get("TotalWriteRecords")
        self._TotalWriteBytes = params.get("TotalWriteBytes")
        self._TotalErrorRecords = params.get("TotalErrorRecords")
        self._RequestId = params.get("RequestId")


class DescribeTaskRunHistoryRequest(AbstractModel):
    """DescribeTaskRunHistory请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目id
        :type ProjectId: str
        :param _SearchCondition: 检索条件
        :type SearchCondition: :class:`tencentcloud.wedata.v20210820.models.InstanceSearchCondition`
        :param _PageSize: 分页大小
        :type PageSize: int
        :param _PageNumber: 分页页码
        :type PageNumber: int
        """
        self._ProjectId = None
        self._SearchCondition = None
        self._PageSize = None
        self._PageNumber = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def SearchCondition(self):
        return self._SearchCondition

    @SearchCondition.setter
    def SearchCondition(self, SearchCondition):
        self._SearchCondition = SearchCondition

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def PageNumber(self):
        return self._PageNumber

    @PageNumber.setter
    def PageNumber(self, PageNumber):
        self._PageNumber = PageNumber


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        if params.get("SearchCondition") is not None:
            self._SearchCondition = InstanceSearchCondition()
            self._SearchCondition._deserialize(params.get("SearchCondition"))
        self._PageSize = params.get("PageSize")
        self._PageNumber = params.get("PageNumber")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskRunHistoryResponse(AbstractModel):
    """DescribeTaskRunHistory返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 分页查询任务运行历史结果
注意：此字段可能返回 null，表示取不到有效值。
        :type Data: :class:`tencentcloud.wedata.v20210820.models.InstanceOpsInfoPage`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = InstanceOpsInfoPage()
            self._Data._deserialize(params.get("Data"))
        self._RequestId = params.get("RequestId")


class DescribeTaskScriptRequest(AbstractModel):
    """DescribeTaskScript请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目Id
        :type ProjectId: str
        :param _TaskId: 任务ID
        :type TaskId: str
        """
        self._ProjectId = None
        self._TaskId = None

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TaskId(self):
  