# -*- coding: utf8 -*-
# Copyright (c) 2017-2021 THL A29 Limited, a Tencent company. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class AIAnalysisTemplateItem(AbstractModel):
    """AI 智能分析模板详情

    """

    def __init__(self):
        r"""
        :param _Definition: 智能分析模板唯一标识。
        :type Definition: int
        :param _Name: 智能分析模板名称。
        :type Name: str
        :param _Comment: 智能分析模板描述信息。
        :type Comment: str
        :param _ClassificationConfigure: 智能分类任务控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :type ClassificationConfigure: :class:`tencentcloud.mps.v20190612.models.ClassificationConfigureInfo`
        :param _TagConfigure: 智能标签任务控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :type TagConfigure: :class:`tencentcloud.mps.v20190612.models.TagConfigureInfo`
        :param _CoverConfigure: 智能封面任务控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :type CoverConfigure: :class:`tencentcloud.mps.v20190612.models.CoverConfigureInfo`
        :param _FrameTagConfigure: 智能按帧标签任务控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :type FrameTagConfigure: :class:`tencentcloud.mps.v20190612.models.FrameTagConfigureInfo`
        :param _CreateTime: 模板创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :type CreateTime: str
        :param _UpdateTime: 模板最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :type UpdateTime: str
        :param _Type: 模板类型，取值范围：
* Preset：系统预置模板；
* Custom：用户自定义模板。
注意：此字段可能返回 null，表示取不到有效值。
        :type Type: str
        """
        self._Definition = None
        self._Name = None
        self._Comment = None
        self._ClassificationConfigure = None
        self._TagConfigure = None
        self._CoverConfigure = None
        self._FrameTagConfigure = None
        self._CreateTime = None
        self._UpdateTime = None
        self._Type = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def ClassificationConfigure(self):
        return self._ClassificationConfigure

    @ClassificationConfigure.setter
    def ClassificationConfigure(self, ClassificationConfigure):
        self._ClassificationConfigure = ClassificationConfigure

    @property
    def TagConfigure(self):
        return self._TagConfigure

    @TagConfigure.setter
    def TagConfigure(self, TagConfigure):
        self._TagConfigure = TagConfigure

    @property
    def CoverConfigure(self):
        return self._CoverConfigure

    @CoverConfigure.setter
    def CoverConfigure(self, CoverConfigure):
        self._CoverConfigure = CoverConfigure

    @property
    def FrameTagConfigure(self):
        return self._FrameTagConfigure

    @FrameTagConfigure.setter
    def FrameTagConfigure(self, FrameTagConfigure):
        self._FrameTagConfigure = FrameTagConfigure

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("ClassificationConfigure") is not None:
            self._ClassificationConfigure = ClassificationConfigureInfo()
            self._ClassificationConfigure._deserialize(params.get("ClassificationConfigure"))
        if params.get("TagConfigure") is not None:
            self._TagConfigure = TagConfigureInfo()
            self._TagConfigure._deserialize(params.get("TagConfigure"))
        if params.get("CoverConfigure") is not None:
            self._CoverConfigure = CoverConfigureInfo()
            self._CoverConfigure._deserialize(params.get("CoverConfigure"))
        if params.get("FrameTagConfigure") is not None:
            self._FrameTagConfigure = FrameTagConfigureInfo()
            self._FrameTagConfigure._deserialize(params.get("FrameTagConfigure"))
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AIRecognitionTemplateItem(AbstractModel):
    """视频内容识别模板详情

    """

    def __init__(self):
        r"""
        :param _Definition: 视频内容识别模板唯一标识。
        :type Definition: int
        :param _Name: 视频内容识别模板名称。
        :type Name: str
        :param _Comment: 视频内容识别模板描述信息。
        :type Comment: str
        :param _FaceConfigure: 人脸识别控制参数。
        :type FaceConfigure: :class:`tencentcloud.mps.v20190612.models.FaceConfigureInfo`
        :param _OcrFullTextConfigure: 文本全文识别控制参数。
        :type OcrFullTextConfigure: :class:`tencentcloud.mps.v20190612.models.OcrFullTextConfigureInfo`
        :param _OcrWordsConfigure: 文本关键词识别控制参数。
        :type OcrWordsConfigure: :class:`tencentcloud.mps.v20190612.models.OcrWordsConfigureInfo`
        :param _AsrFullTextConfigure: 语音全文识别控制参数。
        :type AsrFullTextConfigure: :class:`tencentcloud.mps.v20190612.models.AsrFullTextConfigureInfo`
        :param _AsrWordsConfigure: 语音关键词识别控制参数。
        :type AsrWordsConfigure: :class:`tencentcloud.mps.v20190612.models.AsrWordsConfigureInfo`
        :param _TranslateConfigure: 语音翻译控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :type TranslateConfigure: :class:`tencentcloud.mps.v20190612.models.TranslateConfigureInfo`
        :param _CreateTime: 模板创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :type CreateTime: str
        :param _UpdateTime: 模板最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :type UpdateTime: str
        :param _Type: 模板类型，取值范围：
* Preset：系统预置模板；
* Custom：用户自定义模板。
注意：此字段可能返回 null，表示取不到有效值。
        :type Type: str
        """
        self._Definition = None
        self._Name = None
        self._Comment = None
        self._FaceConfigure = None
        self._OcrFullTextConfigure = None
        self._OcrWordsConfigure = None
        self._AsrFullTextConfigure = None
        self._AsrWordsConfigure = None
        self._TranslateConfigure = None
        self._CreateTime = None
        self._UpdateTime = None
        self._Type = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def FaceConfigure(self):
        return self._FaceConfigure

    @FaceConfigure.setter
    def FaceConfigure(self, FaceConfigure):
        self._FaceConfigure = FaceConfigure

    @property
    def OcrFullTextConfigure(self):
        return self._OcrFullTextConfigure

    @OcrFullTextConfigure.setter
    def OcrFullTextConfigure(self, OcrFullTextConfigure):
        self._OcrFullTextConfigure = OcrFullTextConfigure

    @property
    def OcrWordsConfigure(self):
        return self._OcrWordsConfigure

    @OcrWordsConfigure.setter
    def OcrWordsConfigure(self, OcrWordsConfigure):
        self._OcrWordsConfigure = OcrWordsConfigure

    @property
    def AsrFullTextConfigure(self):
        return self._AsrFullTextConfigure

    @AsrFullTextConfigure.setter
    def AsrFullTextConfigure(self, AsrFullTextConfigure):
        self._AsrFullTextConfigure = AsrFullTextConfigure

    @property
    def AsrWordsConfigure(self):
        return self._AsrWordsConfigure

    @AsrWordsConfigure.setter
    def AsrWordsConfigure(self, AsrWordsConfigure):
        self._AsrWordsConfigure = AsrWordsConfigure

    @property
    def TranslateConfigure(self):
        return self._TranslateConfigure

    @TranslateConfigure.setter
    def TranslateConfigure(self, TranslateConfigure):
        self._TranslateConfigure = TranslateConfigure

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("FaceConfigure") is not None:
            self._FaceConfigure = FaceConfigureInfo()
            self._FaceConfigure._deserialize(params.get("FaceConfigure"))
        if params.get("OcrFullTextConfigure") is not None:
            self._OcrFullTextConfigure = OcrFullTextConfigureInfo()
            self._OcrFullTextConfigure._deserialize(params.get("OcrFullTextConfigure"))
        if params.get("OcrWordsConfigure") is not None:
            self._OcrWordsConfigure = OcrWordsConfigureInfo()
            self._OcrWordsConfigure._deserialize(params.get("OcrWordsConfigure"))
        if params.get("AsrFullTextConfigure") is not None:
            self._AsrFullTextConfigure = AsrFullTextConfigureInfo()
            self._AsrFullTextConfigure._deserialize(params.get("AsrFullTextConfigure"))
        if params.get("AsrWordsConfigure") is not None:
            self._AsrWordsConfigure = AsrWordsConfigureInfo()
            self._AsrWordsConfigure._deserialize(params.get("AsrWordsConfigure"))
        if params.get("TranslateConfigure") is not None:
            self._TranslateConfigure = TranslateConfigureInfo()
            self._TranslateConfigure._deserialize(params.get("TranslateConfigure"))
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ActionConfigInfo(AbstractModel):
    """动作识别参数配置

    """

    def __init__(self):
        r"""
        :param _Switch: 动作识别任务开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Activity(AbstractModel):
    """编排原子任务

    """

    def __init__(self):
        r"""
        :param _ActivityType: 原子任务类型：
<li>input: 起始节点</li>
<li>output：终止节点</li>
<li>action-trans：转码</li>
<li>action-samplesnapshot：采样截图</li>
<li>action-AIAnalysis: 分析</li>
<li>action-AIRecognition：识别</li>
<li>action-aiReview：审核</li>
<li>action-animated-graphics：转动图</li>
<li>action-image-sprite：雪碧图</li>
<li>action-snapshotByTimeOffset: 时间点截图</li>
<li>action-adaptive-substream：自适应码流</li>
<li>action-AIQualityControl：媒体质检</li>



注意：此字段可能返回 null，表示取不到有效值。
        :type ActivityType: str
        :param _ReardriveIndex: 后驱节点索引数组
注意：此字段可能返回 null，表示取不到有效值。
        :type ReardriveIndex: list of int
        :param _ActivityPara: 原子任务参数
注意：此字段可能返回 null，表示取不到有效值。
        :type ActivityPara: :class:`tencentcloud.mps.v20190612.models.ActivityPara`
        """
        self._ActivityType = None
        self._ReardriveIndex = None
        self._ActivityPara = None

    @property
    def ActivityType(self):
        return self._ActivityType

    @ActivityType.setter
    def ActivityType(self, ActivityType):
        self._ActivityType = ActivityType

    @property
    def ReardriveIndex(self):
        return self._ReardriveIndex

    @ReardriveIndex.setter
    def ReardriveIndex(self, ReardriveIndex):
        self._ReardriveIndex = ReardriveIndex

    @property
    def ActivityPara(self):
        return self._ActivityPara

    @ActivityPara.setter
    def ActivityPara(self, ActivityPara):
        self._ActivityPara = ActivityPara


    def _deserialize(self, params):
        self._ActivityType = params.get("ActivityType")
        self._ReardriveIndex = params.get("ReardriveIndex")
        if params.get("ActivityPara") is not None:
            self._ActivityPara = ActivityPara()
            self._ActivityPara._deserialize(params.get("ActivityPara"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ActivityPara(AbstractModel):
    """编排原子任务

    """

    def __init__(self):
        r"""
        :param _TranscodeTask: 视频转码任务
注意：此字段可能返回 null，表示取不到有效值。
        :type TranscodeTask: :class:`tencentcloud.mps.v20190612.models.TranscodeTaskInput`
        :param _AnimatedGraphicTask: 视频转动图任务
注意：此字段可能返回 null，表示取不到有效值。
        :type AnimatedGraphicTask: :class:`tencentcloud.mps.v20190612.models.AnimatedGraphicTaskInput`
        :param _SnapshotByTimeOffsetTask: 视频按时间点截图任务
注意：此字段可能返回 null，表示取不到有效值。
        :type SnapshotByTimeOffsetTask: :class:`tencentcloud.mps.v20190612.models.SnapshotByTimeOffsetTaskInput`
        :param _SampleSnapshotTask: 视频采样截图任务
注意：此字段可能返回 null，表示取不到有效值。
        :type SampleSnapshotTask: :class:`tencentcloud.mps.v20190612.models.SampleSnapshotTaskInput`
        :param _ImageSpriteTask: 视频截雪碧图任务
注意：此字段可能返回 null，表示取不到有效值。
        :type ImageSpriteTask: :class:`tencentcloud.mps.v20190612.models.ImageSpriteTaskInput`
        :param _AdaptiveDynamicStreamingTask: 转自适应码流任务
注意：此字段可能返回 null，表示取不到有效值。
        :type AdaptiveDynamicStreamingTask: :class:`tencentcloud.mps.v20190612.models.AdaptiveDynamicStreamingTaskInput`
        :param _AiContentReviewTask: 视频内容审核类型任务
注意：此字段可能返回 null，表示取不到有效值。
        :type AiContentReviewTask: :class:`tencentcloud.mps.v20190612.models.AiContentReviewTaskInput`
        :param _AiAnalysisTask: 视频内容分析类型任务
注意：此字段可能返回 null，表示取不到有效值。
        :type AiAnalysisTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskInput`
        :param _AiRecognitionTask: 视频内容识别类型任务
注意：此字段可能返回 null，表示取不到有效值。
        :type AiRecognitionTask: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskInput`
        :param _QualityControlTask: 媒体质检任务
注意：此字段可能返回 null，表示取不到有效值。
        :type QualityControlTask: :class:`tencentcloud.mps.v20190612.models.AiQualityControlTaskInput`
        """
        self._TranscodeTask = None
        self._AnimatedGraphicTask = None
        self._SnapshotByTimeOffsetTask = None
        self._SampleSnapshotTask = None
        self._ImageSpriteTask = None
        self._AdaptiveDynamicStreamingTask = None
        self._AiContentReviewTask = None
        self._AiAnalysisTask = None
        self._AiRecognitionTask = None
        self._QualityControlTask = None

    @property
    def TranscodeTask(self):
        return self._TranscodeTask

    @TranscodeTask.setter
    def TranscodeTask(self, TranscodeTask):
        self._TranscodeTask = TranscodeTask

    @property
    def AnimatedGraphicTask(self):
        return self._AnimatedGraphicTask

    @AnimatedGraphicTask.setter
    def AnimatedGraphicTask(self, AnimatedGraphicTask):
        self._AnimatedGraphicTask = AnimatedGraphicTask

    @property
    def SnapshotByTimeOffsetTask(self):
        return self._SnapshotByTimeOffsetTask

    @SnapshotByTimeOffsetTask.setter
    def SnapshotByTimeOffsetTask(self, SnapshotByTimeOffsetTask):
        self._SnapshotByTimeOffsetTask = SnapshotByTimeOffsetTask

    @property
    def SampleSnapshotTask(self):
        return self._SampleSnapshotTask

    @SampleSnapshotTask.setter
    def SampleSnapshotTask(self, SampleSnapshotTask):
        self._SampleSnapshotTask = SampleSnapshotTask

    @property
    def ImageSpriteTask(self):
        return self._ImageSpriteTask

    @ImageSpriteTask.setter
    def ImageSpriteTask(self, ImageSpriteTask):
        self._ImageSpriteTask = ImageSpriteTask

    @property
    def AdaptiveDynamicStreamingTask(self):
        return self._AdaptiveDynamicStreamingTask

    @AdaptiveDynamicStreamingTask.setter
    def AdaptiveDynamicStreamingTask(self, AdaptiveDynamicStreamingTask):
        self._AdaptiveDynamicStreamingTask = AdaptiveDynamicStreamingTask

    @property
    def AiContentReviewTask(self):
        return self._AiContentReviewTask

    @AiContentReviewTask.setter
    def AiContentReviewTask(self, AiContentReviewTask):
        self._AiContentReviewTask = AiContentReviewTask

    @property
    def AiAnalysisTask(self):
        return self._AiAnalysisTask

    @AiAnalysisTask.setter
    def AiAnalysisTask(self, AiAnalysisTask):
        self._AiAnalysisTask = AiAnalysisTask

    @property
    def AiRecognitionTask(self):
        return self._AiRecognitionTask

    @AiRecognitionTask.setter
    def AiRecognitionTask(self, AiRecognitionTask):
        self._AiRecognitionTask = AiRecognitionTask

    @property
    def QualityControlTask(self):
        return self._QualityControlTask

    @QualityControlTask.setter
    def QualityControlTask(self, QualityControlTask):
        self._QualityControlTask = QualityControlTask


    def _deserialize(self, params):
        if params.get("TranscodeTask") is not None:
            self._TranscodeTask = TranscodeTaskInput()
            self._TranscodeTask._deserialize(params.get("TranscodeTask"))
        if params.get("AnimatedGraphicTask") is not None:
            self._AnimatedGraphicTask = AnimatedGraphicTaskInput()
            self._AnimatedGraphicTask._deserialize(params.get("AnimatedGraphicTask"))
        if params.get("SnapshotByTimeOffsetTask") is not None:
            self._SnapshotByTimeOffsetTask = SnapshotByTimeOffsetTaskInput()
            self._SnapshotByTimeOffsetTask._deserialize(params.get("SnapshotByTimeOffsetTask"))
        if params.get("SampleSnapshotTask") is not None:
            self._SampleSnapshotTask = SampleSnapshotTaskInput()
            self._SampleSnapshotTask._deserialize(params.get("SampleSnapshotTask"))
        if params.get("ImageSpriteTask") is not None:
            self._ImageSpriteTask = ImageSpriteTaskInput()
            self._ImageSpriteTask._deserialize(params.get("ImageSpriteTask"))
        if params.get("AdaptiveDynamicStreamingTask") is not None:
            self._AdaptiveDynamicStreamingTask = AdaptiveDynamicStreamingTaskInput()
            self._AdaptiveDynamicStreamingTask._deserialize(params.get("AdaptiveDynamicStreamingTask"))
        if params.get("AiContentReviewTask") is not None:
            self._AiContentReviewTask = AiContentReviewTaskInput()
            self._AiContentReviewTask._deserialize(params.get("AiContentReviewTask"))
        if params.get("AiAnalysisTask") is not None:
            self._AiAnalysisTask = AiAnalysisTaskInput()
            self._AiAnalysisTask._deserialize(params.get("AiAnalysisTask"))
        if params.get("AiRecognitionTask") is not None:
            self._AiRecognitionTask = AiRecognitionTaskInput()
            self._AiRecognitionTask._deserialize(params.get("AiRecognitionTask"))
        if params.get("QualityControlTask") is not None:
            self._QualityControlTask = AiQualityControlTaskInput()
            self._QualityControlTask._deserialize(params.get("QualityControlTask"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ActivityResItem(AbstractModel):
    """编排子任务输出

    """

    def __init__(self):
        r"""
        :param _TranscodeTask: 转码任务输出
注意：此字段可能返回 null，表示取不到有效值。
        :type TranscodeTask: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskTranscodeResult`
        :param _AnimatedGraphicTask: 转动图任务输出
注意：此字段可能返回 null，表示取不到有效值。
        :type AnimatedGraphicTask: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskAnimatedGraphicResult`
        :param _SnapshotByTimeOffsetTask: 时间点截图任务输出
注意：此字段可能返回 null，表示取不到有效值。
        :type SnapshotByTimeOffsetTask: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskSnapshotByTimeOffsetResult`
        :param _SampleSnapshotTask: 采样截图任务输出
注意：此字段可能返回 null，表示取不到有效值。
        :type SampleSnapshotTask: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskSampleSnapshotResult`
        :param _ImageSpriteTask: 雪碧图任务输出
注意：此字段可能返回 null，表示取不到有效值。
        :type ImageSpriteTask: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskImageSpriteResult`
        :param _AdaptiveDynamicStreamingTask: 自适应码流任务输出
注意：此字段可能返回 null，表示取不到有效值。
        :type AdaptiveDynamicStreamingTask: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskAdaptiveDynamicStreamingResult`
        :param _RecognitionTask: 识别任务输出
注意：此字段可能返回 null，表示取不到有效值。
        :type RecognitionTask: :class:`tencentcloud.mps.v20190612.models.ScheduleRecognitionTaskResult`
        :param _ReviewTask: 审核任务输出
注意：此字段可能返回 null，表示取不到有效值。
        :type ReviewTask: :class:`tencentcloud.mps.v20190612.models.ScheduleReviewTaskResult`
        :param _AnalysisTask: 分析任务输出
注意：此字段可能返回 null，表示取不到有效值。
        :type AnalysisTask: :class:`tencentcloud.mps.v20190612.models.ScheduleAnalysisTaskResult`
        :param _QualityControlTask: 媒体质检任务输出
注意：此字段可能返回 null，表示取不到有效值。
        :type QualityControlTask: :class:`tencentcloud.mps.v20190612.models.ScheduleQualityControlTaskResult`
        """
        self._TranscodeTask = None
        self._AnimatedGraphicTask = None
        self._SnapshotByTimeOffsetTask = None
        self._SampleSnapshotTask = None
        self._ImageSpriteTask = None
        self._AdaptiveDynamicStreamingTask = None
        self._RecognitionTask = None
        self._ReviewTask = None
        self._AnalysisTask = None
        self._QualityControlTask = None

    @property
    def TranscodeTask(self):
        return self._TranscodeTask

    @TranscodeTask.setter
    def TranscodeTask(self, TranscodeTask):
        self._TranscodeTask = TranscodeTask

    @property
    def AnimatedGraphicTask(self):
        return self._AnimatedGraphicTask

    @AnimatedGraphicTask.setter
    def AnimatedGraphicTask(self, AnimatedGraphicTask):
        self._AnimatedGraphicTask = AnimatedGraphicTask

    @property
    def SnapshotByTimeOffsetTask(self):
        return self._SnapshotByTimeOffsetTask

    @SnapshotByTimeOffsetTask.setter
    def SnapshotByTimeOffsetTask(self, SnapshotByTimeOffsetTask):
        self._SnapshotByTimeOffsetTask = SnapshotByTimeOffsetTask

    @property
    def SampleSnapshotTask(self):
        return self._SampleSnapshotTask

    @SampleSnapshotTask.setter
    def SampleSnapshotTask(self, SampleSnapshotTask):
        self._SampleSnapshotTask = SampleSnapshotTask

    @property
    def ImageSpriteTask(self):
        return self._ImageSpriteTask

    @ImageSpriteTask.setter
    def ImageSpriteTask(self, ImageSpriteTask):
        self._ImageSpriteTask = ImageSpriteTask

    @property
    def AdaptiveDynamicStreamingTask(self):
        return self._AdaptiveDynamicStreamingTask

    @AdaptiveDynamicStreamingTask.setter
    def AdaptiveDynamicStreamingTask(self, AdaptiveDynamicStreamingTask):
        self._AdaptiveDynamicStreamingTask = AdaptiveDynamicStreamingTask

    @property
    def RecognitionTask(self):
        return self._RecognitionTask

    @RecognitionTask.setter
    def RecognitionTask(self, RecognitionTask):
        self._RecognitionTask = RecognitionTask

    @property
    def ReviewTask(self):
        return self._ReviewTask

    @ReviewTask.setter
    def ReviewTask(self, ReviewTask):
        self._ReviewTask = ReviewTask

    @property
    def AnalysisTask(self):
        return self._AnalysisTask

    @AnalysisTask.setter
    def AnalysisTask(self, AnalysisTask):
        self._AnalysisTask = AnalysisTask

    @property
    def QualityControlTask(self):
        return self._QualityControlTask

    @QualityControlTask.setter
    def QualityControlTask(self, QualityControlTask):
        self._QualityControlTask = QualityControlTask


    def _deserialize(self, params):
        if params.get("TranscodeTask") is not None:
            self._TranscodeTask = MediaProcessTaskTranscodeResult()
            self._TranscodeTask._deserialize(params.get("TranscodeTask"))
        if params.get("AnimatedGraphicTask") is not None:
            self._AnimatedGraphicTask = MediaProcessTaskAnimatedGraphicResult()
            self._AnimatedGraphicTask._deserialize(params.get("AnimatedGraphicTask"))
        if params.get("SnapshotByTimeOffsetTask") is not None:
            self._SnapshotByTimeOffsetTask = MediaProcessTaskSnapshotByTimeOffsetResult()
            self._SnapshotByTimeOffsetTask._deserialize(params.get("SnapshotByTimeOffsetTask"))
        if params.get("SampleSnapshotTask") is not None:
            self._SampleSnapshotTask = MediaProcessTaskSampleSnapshotResult()
            self._SampleSnapshotTask._deserialize(params.get("SampleSnapshotTask"))
        if params.get("ImageSpriteTask") is not None:
            self._ImageSpriteTask = MediaProcessTaskImageSpriteResult()
            self._ImageSpriteTask._deserialize(params.get("ImageSpriteTask"))
        if params.get("AdaptiveDynamicStreamingTask") is not None:
            self._AdaptiveDynamicStreamingTask = MediaProcessTaskAdaptiveDynamicStreamingResult()
            self._AdaptiveDynamicStreamingTask._deserialize(params.get("AdaptiveDynamicStreamingTask"))
        if params.get("RecognitionTask") is not None:
            self._RecognitionTask = ScheduleRecognitionTaskResult()
            self._RecognitionTask._deserialize(params.get("RecognitionTask"))
        if params.get("ReviewTask") is not None:
            self._ReviewTask = ScheduleReviewTaskResult()
            self._ReviewTask._deserialize(params.get("ReviewTask"))
        if params.get("AnalysisTask") is not None:
            self._AnalysisTask = ScheduleAnalysisTaskResult()
            self._AnalysisTask._deserialize(params.get("AnalysisTask"))
        if params.get("QualityControlTask") is not None:
            self._QualityControlTask = ScheduleQualityControlTaskResult()
            self._QualityControlTask._deserialize(params.get("QualityControlTask"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ActivityResult(AbstractModel):
    """编排任务输出

    """

    def __init__(self):
        r"""
        :param _ActivityType: 原子任务类型。
<li>Transcode：转码。</li>
<li>SampleSnapshot：采样截图。</li>
<li>AnimatedGraphics：转动图。</li>
<li>SnapshotByTimeOffset：时间点截图。</li>
<li>ImageSprites：雪碧图。</li>
<li>AdaptiveDynamicStreaming：自适应码流。</li>
<li>AiContentReview：内容审核。</li>
<li>AIRecognition：智能识别。</li>
<li>AIAnalysis：智能分析。</li>
<li>AiQualityControl：媒体质检。</li>
        :type ActivityType: str
        :param _ActivityResItem: 原子任务输出。
        :type ActivityResItem: :class:`tencentcloud.mps.v20190612.models.ActivityResItem`
        """
        self._ActivityType = None
        self._ActivityResItem = None

    @property
    def ActivityType(self):
        return self._ActivityType

    @ActivityType.setter
    def ActivityType(self, ActivityType):
        self._ActivityType = ActivityType

    @property
    def ActivityResItem(self):
        return self._ActivityResItem

    @ActivityResItem.setter
    def ActivityResItem(self, ActivityResItem):
        self._ActivityResItem = ActivityResItem


    def _deserialize(self, params):
        self._ActivityType = params.get("ActivityType")
        if params.get("ActivityResItem") is not None:
            self._ActivityResItem = ActivityResItem()
            self._ActivityResItem._deserialize(params.get("ActivityResItem"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AdaptiveDynamicStreamingInfoItem(AbstractModel):
    """转自适应码流信息

    """

    def __init__(self):
        r"""
        :param _Definition: 转自适应码流规格。
        :type Definition: int
        :param _Package: 打包格式，可能为 HLS和 MPEG-DASH 两种。
        :type Package: str
        :param _Path: 播放路径。
        :type Path: str
        :param _Storage: 自适应码流文件的存储位置。
        :type Storage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        self._Definition = None
        self._Package = None
        self._Path = None
        self._Storage = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Package(self):
        return self._Package

    @Package.setter
    def Package(self, Package):
        self._Package = Package

    @property
    def Path(self):
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def Storage(self):
        return self._Storage

    @Storage.setter
    def Storage(self, Storage):
        self._Storage = Storage


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Package = params.get("Package")
        self._Path = params.get("Path")
        if params.get("Storage") is not None:
            self._Storage = TaskOutputStorage()
            self._Storage._deserialize(params.get("Storage"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AdaptiveDynamicStreamingTaskInput(AbstractModel):
    """对视频转自适应码流的输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 转自适应码流模板 ID。
        :type Definition: int
        :param _WatermarkSet: 水印列表，支持多张图片或文字水印，最大可支持 10 张。
        :type WatermarkSet: list of WatermarkInput
        :param _OutputStorage: 转自适应码流后文件的目标存储，不填则继承上层的 OutputStorage 值。
注意：此字段可能返回 null，表示取不到有效值。
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _OutputObjectPath: 转自适应码流后，manifest 文件的输出路径，可以为相对路径或者绝对路径。
若需定义输出路径，路径需以`.{format}`结尾。变量名请参考 [文件名变量说明](https://cloud.tencent.com/document/product/862/37039)。
相对路径示例：
<li>文件名_{变量名}.{format}</li>
<li>文件名.{format}</li>
绝对路径示例：
<li>/自定义路径/文件名_{变量名}.{format}</li>
如果不填，则默认为相对路径：{inputName}_adaptiveDynamicStreaming_{definition}.{format}。
        :type OutputObjectPath: str
        :param _SubStreamObjectName: 转自适应码流后，子流文件的输出路径，只能为相对路径。如果不填，则默认为相对路径：`{inputName}_adaptiveDynamicStreaming_{definition}_{subStreamNumber}.{format}`。
        :type SubStreamObjectName: str
        :param _SegmentObjectName: 转自适应码流（仅 HLS）后，分片文件的输出路径，只能为相对路径。如果不填，则默认为相对路径：`{inputName}_adaptiveDynamicStreaming_{definition}_{subStreamNumber}_{segmentNumber}.{format}`。
        :type SegmentObjectName: str
        :param _AddOnSubtitles: 要插入的字幕文件。
注意：此字段可能返回 null，表示取不到有效值。
        :type AddOnSubtitles: list of AddOnSubtitle
        :param _DrmInfo: Drm信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type DrmInfo: :class:`tencentcloud.mps.v20190612.models.DrmInfo`
        :param _DefinitionType: 自适应转码模板类型：
Common：音视频类型
PureAudio：纯音频类型
注意：此字段可能返回 null，表示取不到有效值。
        :type DefinitionType: str
        """
        self._Definition = None
        self._WatermarkSet = None
        self._OutputStorage = None
        self._OutputObjectPath = None
        self._SubStreamObjectName = None
        self._SegmentObjectName = None
        self._AddOnSubtitles = None
        self._DrmInfo = None
        self._DefinitionType = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def WatermarkSet(self):
        return self._WatermarkSet

    @WatermarkSet.setter
    def WatermarkSet(self, WatermarkSet):
        self._WatermarkSet = WatermarkSet

    @property
    def OutputStorage(self):
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage

    @property
    def OutputObjectPath(self):
        return self._OutputObjectPath

    @OutputObjectPath.setter
    def OutputObjectPath(self, OutputObjectPath):
        self._OutputObjectPath = OutputObjectPath

    @property
    def SubStreamObjectName(self):
        return self._SubStreamObjectName

    @SubStreamObjectName.setter
    def SubStreamObjectName(self, SubStreamObjectName):
        self._SubStreamObjectName = SubStreamObjectName

    @property
    def SegmentObjectName(self):
        return self._SegmentObjectName

    @SegmentObjectName.setter
    def SegmentObjectName(self, SegmentObjectName):
        self._SegmentObjectName = SegmentObjectName

    @property
    def AddOnSubtitles(self):
        return self._AddOnSubtitles

    @AddOnSubtitles.setter
    def AddOnSubtitles(self, AddOnSubtitles):
        self._AddOnSubtitles = AddOnSubtitles

    @property
    def DrmInfo(self):
        return self._DrmInfo

    @DrmInfo.setter
    def DrmInfo(self, DrmInfo):
        self._DrmInfo = DrmInfo

    @property
    def DefinitionType(self):
        return self._DefinitionType

    @DefinitionType.setter
    def DefinitionType(self, DefinitionType):
        self._DefinitionType = DefinitionType


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        if params.get("WatermarkSet") is not None:
            self._WatermarkSet = []
            for item in params.get("WatermarkSet"):
                obj = WatermarkInput()
                obj._deserialize(item)
                self._WatermarkSet.append(obj)
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        self._OutputObjectPath = params.get("OutputObjectPath")
        self._SubStreamObjectName = params.get("SubStreamObjectName")
        self._SegmentObjectName = params.get("SegmentObjectName")
        if params.get("AddOnSubtitles") is not None:
            self._AddOnSubtitles = []
            for item in params.get("AddOnSubtitles"):
                obj = AddOnSubtitle()
                obj._deserialize(item)
                self._AddOnSubtitles.append(obj)
        if params.get("DrmInfo") is not None:
            self._DrmInfo = DrmInfo()
            self._DrmInfo._deserialize(params.get("DrmInfo"))
        self._DefinitionType = params.get("DefinitionType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AdaptiveDynamicStreamingTemplate(AbstractModel):
    """转自适应码流模板详情

    """

    def __init__(self):
        r"""
        :param _Definition: 转自适应码流模板唯一标识。
        :type Definition: int
        :param _Type: 模板类型，取值范围：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :type Type: str
        :param _Name: 转自适应码流模板名称。
        :type Name: str
        :param _Comment: 转自适应码流模板描述信息。
        :type Comment: str
        :param _Format: 转自适应码流格式，取值范围：
<li>HLS，</li>
<li>MPEG-DASH。</li>
        :type Format: str
        :param _StreamInfos: 转自适应码流输入流参数信息，最多输入10路流。
        :type StreamInfos: list of AdaptiveStreamTemplate
        :param _DisableHigherVideoBitrate: 是否禁止视频低码率转高码率，取值范围：
<li>0：否，</li>
<li>1：是。</li>
        :type DisableHigherVideoBitrate: int
        :param _DisableHigherVideoResolution: 是否禁止视频分辨率转高分辨率，取值范围：
<li>0：否，</li>
<li>1：是。</li>
        :type DisableHigherVideoResolution: int
        :param _CreateTime: 模板创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type CreateTime: str
        :param _UpdateTime: 模板最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/266/11732#I)。
        :type UpdateTime: str
        :param _PureAudio: 是否为纯音频，0表示视频，1表示纯音频
注意：此字段可能返回 null，表示取不到有效值。
        :type PureAudio: int
        :param _SegmentType: hls 分片类型，可选值：
<li>ts-segment：HLS+TS 切片</li>
<li>ts-byterange：HLS+TS byte range</li>
<li>mp4-segment：HLS+MP4 切片</li>
<li>mp4-byterange：HLS+MP4 byte range</li>
<li>ts-packed-audio：TS+Packed Audio</li>
<li>mp4-packed-audio：MP4+Packed Audio</li>
默认值：ts-segment

注：自适应码流的hls分片格式已此字段为准
注意：此字段可能返回 null，表示取不到有效值。
        :type SegmentType: str
        """
        self._Definition = None
        self._Type = None
        self._Name = None
        self._Comment = None
        self._Format = None
        self._StreamInfos = None
        self._DisableHigherVideoBitrate = None
        self._DisableHigherVideoResolution = None
        self._CreateTime = None
        self._UpdateTime = None
        self._PureAudio = None
        self._SegmentType = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def Format(self):
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def StreamInfos(self):
        return self._StreamInfos

    @StreamInfos.setter
    def StreamInfos(self, StreamInfos):
        self._StreamInfos = StreamInfos

    @property
    def DisableHigherVideoBitrate(self):
        return self._DisableHigherVideoBitrate

    @DisableHigherVideoBitrate.setter
    def DisableHigherVideoBitrate(self, DisableHigherVideoBitrate):
        self._DisableHigherVideoBitrate = DisableHigherVideoBitrate

    @property
    def DisableHigherVideoResolution(self):
        return self._DisableHigherVideoResolution

    @DisableHigherVideoResolution.setter
    def DisableHigherVideoResolution(self, DisableHigherVideoResolution):
        self._DisableHigherVideoResolution = DisableHigherVideoResolution

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def PureAudio(self):
        return self._PureAudio

    @PureAudio.setter
    def PureAudio(self, PureAudio):
        self._PureAudio = PureAudio

    @property
    def SegmentType(self):
        return self._SegmentType

    @SegmentType.setter
    def SegmentType(self, SegmentType):
        self._SegmentType = SegmentType


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        self._Format = params.get("Format")
        if params.get("StreamInfos") is not None:
            self._StreamInfos = []
            for item in params.get("StreamInfos"):
                obj = AdaptiveStreamTemplate()
                obj._deserialize(item)
                self._StreamInfos.append(obj)
        self._DisableHigherVideoBitrate = params.get("DisableHigherVideoBitrate")
        self._DisableHigherVideoResolution = params.get("DisableHigherVideoResolution")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._PureAudio = params.get("PureAudio")
        self._SegmentType = params.get("SegmentType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AdaptiveStreamTemplate(AbstractModel):
    """自适应转码流参数模板

    """

    def __init__(self):
        r"""
        :param _Audio: 音频参数信息。
        :type Audio: :class:`tencentcloud.mps.v20190612.models.AudioTemplateInfo`
        :param _Video: 视频参数信息。
        :type Video: :class:`tencentcloud.mps.v20190612.models.VideoTemplateInfo`
        :param _RemoveAudio: 是否移除音频流，取值范围：
<li>0：否，</li>
<li>1：是。</li>
        :type RemoveAudio: int
        :param _RemoveVideo: 是否移除视频流，取值范围：
<li>0：否，</li>
<li>1：是。</li>
        :type RemoveVideo: int
        """
        self._Audio = None
        self._Video = None
        self._RemoveAudio = None
        self._RemoveVideo = None

    @property
    def Audio(self):
        return self._Audio

    @Audio.setter
    def Audio(self, Audio):
        self._Audio = Audio

    @property
    def Video(self):
        return self._Video

    @Video.setter
    def Video(self, Video):
        self._Video = Video

    @property
    def RemoveAudio(self):
        return self._RemoveAudio

    @RemoveAudio.setter
    def RemoveAudio(self, RemoveAudio):
        self._RemoveAudio = RemoveAudio

    @property
    def RemoveVideo(self):
        return self._RemoveVideo

    @RemoveVideo.setter
    def RemoveVideo(self, RemoveVideo):
        self._RemoveVideo = RemoveVideo


    def _deserialize(self, params):
        if params.get("Audio") is not None:
            self._Audio = AudioTemplateInfo()
            self._Audio._deserialize(params.get("Audio"))
        if params.get("Video") is not None:
            self._Video = VideoTemplateInfo()
            self._Video._deserialize(params.get("Video"))
        self._RemoveAudio = params.get("RemoveAudio")
        self._RemoveVideo = params.get("RemoveVideo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddOnSubtitle(AbstractModel):
    """外挂字幕。

    """

    def __init__(self):
        r"""
        :param _Type: 插入形式，可选值：
<li>subtitle-stream：插入字幕轨道</li>
<li>close-caption-708：CEA-708字幕编码到SEI帧</li>
<li>close-caption-608：CEA-608字幕编码到SEI帧</li>
注意：此字段可能返回 null，表示取不到有效值。
        :type Type: str
        :param _Subtitle: 字幕文件。
注意：此字段可能返回 null，表示取不到有效值。
        :type Subtitle: :class:`tencentcloud.mps.v20190612.models.MediaInputInfo`
        """
        self._Type = None
        self._Subtitle = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Subtitle(self):
        return self._Subtitle

    @Subtitle.setter
    def Subtitle(self, Subtitle):
        self._Subtitle = Subtitle


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("Subtitle") is not None:
            self._Subtitle = MediaInputInfo()
            self._Subtitle._deserialize(params.get("Subtitle"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisResult(AbstractModel):
    """智能分析结果

    """

    def __init__(self):
        r"""
        :param _Type: 任务的类型，可以取的值有：
<li>Classification：智能分类</li>
<li>Cover：智能封面</li>
<li>Tag：智能标签</li>
<li>FrameTag：智能按帧标签</li>
<li>Highlight：智能精彩集锦</li>
<li>DeLogo：智能擦除</li>
<li>Description：大模型摘要</li>
        :type Type: str
        :param _ClassificationTask: 视频内容分析智能分类任务的查询结果，当任务类型为 Classification 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type ClassificationTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskClassificationResult`
        :param _CoverTask: 视频内容分析智能封面任务的查询结果，当任务类型为 Cover 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type CoverTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskCoverResult`
        :param _TagTask: 视频内容分析智能标签任务的查询结果，当任务类型为 Tag 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type TagTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskTagResult`
        :param _FrameTagTask: 视频内容分析智能按帧标签任务的查询结果，当任务类型为 FrameTag 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type FrameTagTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskFrameTagResult`
        :param _HighlightTask: 视频内容分析集锦任务的查询结果，当任务类型为 Highlight时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type HighlightTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskHighlightResult`
        :param _DeLogoTask: 视频内容分析智能擦除任务的查询结果，当任务类型为 DeLogo 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type DeLogoTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskDelLogoResult`
        :param _SegmentTask: 视频内容分析拆条任务的查询结果，当任务类型为 SegmentRecognition 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type SegmentTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskSegmentResult`
        :param _HeadTailTask: 视频内容分析片头片尾任务的查询结果，当任务类型为 HeadTailRecognition 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type HeadTailTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskHeadTailResult`
        :param _DescriptionTask: 视频内容分析摘要任务的查询结果，当任务类型为 Description 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type DescriptionTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskDescriptionResult`
        """
        self._Type = None
        self._ClassificationTask = None
        self._CoverTask = None
        self._TagTask = None
        self._FrameTagTask = None
        self._HighlightTask = None
        self._DeLogoTask = None
        self._SegmentTask = None
        self._HeadTailTask = None
        self._DescriptionTask = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def ClassificationTask(self):
        return self._ClassificationTask

    @ClassificationTask.setter
    def ClassificationTask(self, ClassificationTask):
        self._ClassificationTask = ClassificationTask

    @property
    def CoverTask(self):
        return self._CoverTask

    @CoverTask.setter
    def CoverTask(self, CoverTask):
        self._CoverTask = CoverTask

    @property
    def TagTask(self):
        return self._TagTask

    @TagTask.setter
    def TagTask(self, TagTask):
        self._TagTask = TagTask

    @property
    def FrameTagTask(self):
        return self._FrameTagTask

    @FrameTagTask.setter
    def FrameTagTask(self, FrameTagTask):
        self._FrameTagTask = FrameTagTask

    @property
    def HighlightTask(self):
        return self._HighlightTask

    @HighlightTask.setter
    def HighlightTask(self, HighlightTask):
        self._HighlightTask = HighlightTask

    @property
    def DeLogoTask(self):
        return self._DeLogoTask

    @DeLogoTask.setter
    def DeLogoTask(self, DeLogoTask):
        self._DeLogoTask = DeLogoTask

    @property
    def SegmentTask(self):
        return self._SegmentTask

    @SegmentTask.setter
    def SegmentTask(self, SegmentTask):
        self._SegmentTask = SegmentTask

    @property
    def HeadTailTask(self):
        return self._HeadTailTask

    @HeadTailTask.setter
    def HeadTailTask(self, HeadTailTask):
        self._HeadTailTask = HeadTailTask

    @property
    def DescriptionTask(self):
        return self._DescriptionTask

    @DescriptionTask.setter
    def DescriptionTask(self, DescriptionTask):
        self._DescriptionTask = DescriptionTask


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("ClassificationTask") is not None:
            self._ClassificationTask = AiAnalysisTaskClassificationResult()
            self._ClassificationTask._deserialize(params.get("ClassificationTask"))
        if params.get("CoverTask") is not None:
            self._CoverTask = AiAnalysisTaskCoverResult()
            self._CoverTask._deserialize(params.get("CoverTask"))
        if params.get("TagTask") is not None:
            self._TagTask = AiAnalysisTaskTagResult()
            self._TagTask._deserialize(params.get("TagTask"))
        if params.get("FrameTagTask") is not None:
            self._FrameTagTask = AiAnalysisTaskFrameTagResult()
            self._FrameTagTask._deserialize(params.get("FrameTagTask"))
        if params.get("HighlightTask") is not None:
            self._HighlightTask = AiAnalysisTaskHighlightResult()
            self._HighlightTask._deserialize(params.get("HighlightTask"))
        if params.get("DeLogoTask") is not None:
            self._DeLogoTask = AiAnalysisTaskDelLogoResult()
            self._DeLogoTask._deserialize(params.get("DeLogoTask"))
        if params.get("SegmentTask") is not None:
            self._SegmentTask = AiAnalysisTaskSegmentResult()
            self._SegmentTask._deserialize(params.get("SegmentTask"))
        if params.get("HeadTailTask") is not None:
            self._HeadTailTask = AiAnalysisTaskHeadTailResult()
            self._HeadTailTask._deserialize(params.get("HeadTailTask"))
        if params.get("DescriptionTask") is not None:
            self._DescriptionTask = AiAnalysisTaskDescriptionResult()
            self._DescriptionTask._deserialize(params.get("DescriptionTask"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskClassificationInput(AbstractModel):
    """智能分类任务输入类型

    """

    def __init__(self):
        r"""
        :param _Definition: 视频智能分类模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskClassificationOutput(AbstractModel):
    """智能分类结果信息

    """

    def __init__(self):
        r"""
        :param _ClassificationSet: 视频智能分类列表。
        :type ClassificationSet: list of MediaAiAnalysisClassificationItem
        """
        self._ClassificationSet = None

    @property
    def ClassificationSet(self):
        return self._ClassificationSet

    @ClassificationSet.setter
    def ClassificationSet(self, ClassificationSet):
        self._ClassificationSet = ClassificationSet


    def _deserialize(self, params):
        if params.get("ClassificationSet") is not None:
            self._ClassificationSet = []
            for item in params.get("ClassificationSet"):
                obj = MediaAiAnalysisClassificationItem()
                obj._deserialize(item)
                self._ClassificationSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskClassificationResult(AbstractModel):
    """智能分类任务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 智能分类任务输入。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskClassificationInput`
        :param _Output: 智能分类任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskClassificationOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskClassificationInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskClassificationOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskCoverInput(AbstractModel):
    """智能分类任务输入类型

    """

    def __init__(self):
        r"""
        :param _Definition: 视频智能封面模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskCoverOutput(AbstractModel):
    """智能封面结果信息

    """

    def __init__(self):
        r"""
        :param _CoverSet: 智能封面列表。
        :type CoverSet: list of MediaAiAnalysisCoverItem
        :param _OutputStorage: 智能封面的存储位置。
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        self._CoverSet = None
        self._OutputStorage = None

    @property
    def CoverSet(self):
        return self._CoverSet

    @CoverSet.setter
    def CoverSet(self, CoverSet):
        self._CoverSet = CoverSet

    @property
    def OutputStorage(self):
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage


    def _deserialize(self, params):
        if params.get("CoverSet") is not None:
            self._CoverSet = []
            for item in params.get("CoverSet"):
                obj = MediaAiAnalysisCoverItem()
                obj._deserialize(item)
                self._CoverSet.append(obj)
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskCoverResult(AbstractModel):
    """智能封面结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 智能封面任务输入。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskCoverInput`
        :param _Output: 智能封面任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskCoverOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskCoverInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskCoverOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskDelLogoInput(AbstractModel):
    """智能擦除任务输入类型

    """

    def __init__(self):
        r"""
        :param _Definition: 视频智能擦除模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskDelLogoOutput(AbstractModel):
    """智能擦除结果信息

    """

    def __init__(self):
        r"""
        :param _Path: 擦除后文件的路径。
        :type Path: str
        :param _OutputStorage: 擦除后文件的存储位置。
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _OriginSubtitlePath: 基于画面提取的字幕文件路径。
注意：此字段可能返回 null，表示取不到有效值。
        :type OriginSubtitlePath: str
        :param _TranslateSubtitlePath: 基于画面提取的字幕翻译文件路径。
注意：此字段可能返回 null，表示取不到有效值。
        :type TranslateSubtitlePath: str
        """
        self._Path = None
        self._OutputStorage = None
        self._OriginSubtitlePath = None
        self._TranslateSubtitlePath = None

    @property
    def Path(self):
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def OutputStorage(self):
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage

    @property
    def OriginSubtitlePath(self):
        return self._OriginSubtitlePath

    @OriginSubtitlePath.setter
    def OriginSubtitlePath(self, OriginSubtitlePath):
        self._OriginSubtitlePath = OriginSubtitlePath

    @property
    def TranslateSubtitlePath(self):
        return self._TranslateSubtitlePath

    @TranslateSubtitlePath.setter
    def TranslateSubtitlePath(self, TranslateSubtitlePath):
        self._TranslateSubtitlePath = TranslateSubtitlePath


    def _deserialize(self, params):
        self._Path = params.get("Path")
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        self._OriginSubtitlePath = params.get("OriginSubtitlePath")
        self._TranslateSubtitlePath = params.get("TranslateSubtitlePath")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskDelLogoResult(AbstractModel):
    """智能擦除结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCode: 错误码，0：成功，其他值：失败。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 智能擦除任务输入。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskDelLogoInput`
        :param _Output: 智能擦除任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskDelLogoOutput`
        """
        self._Status = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskDelLogoInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskDelLogoOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskDescriptionInput(AbstractModel):
    """智能分类任务输入类型

    """

    def __init__(self):
        r"""
        :param _Definition: 视频智能描述模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskDescriptionOutput(AbstractModel):
    """智能描述结果信息

    """

    def __init__(self):
        r"""
        :param _DescriptionSet: 视频智能描述列表。
        :type DescriptionSet: list of MediaAiAnalysisDescriptionItem
        """
        self._DescriptionSet = None

    @property
    def DescriptionSet(self):
        return self._DescriptionSet

    @DescriptionSet.setter
    def DescriptionSet(self, DescriptionSet):
        self._DescriptionSet = DescriptionSet


    def _deserialize(self, params):
        if params.get("DescriptionSet") is not None:
            self._DescriptionSet = []
            for item in params.get("DescriptionSet"):
                obj = MediaAiAnalysisDescriptionItem()
                obj._deserialize(item)
                self._DescriptionSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskDescriptionResult(AbstractModel):
    """智能描述结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCode: 错误码，0：成功，其他值：失败。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 智能描述任务输入。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskDescriptionInput`
        :param _Output: 智能描述任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskDescriptionOutput`
        """
        self._Status = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskDescriptionInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskDescriptionOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskFrameTagInput(AbstractModel):
    """智能按帧标签任务输入类型

    """

    def __init__(self):
        r"""
        :param _Definition: 视频智能按帧标签模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskFrameTagOutput(AbstractModel):
    """智能按帧标签结果信息

    """

    def __init__(self):
        r"""
        :param _SegmentSet: 视频按帧标签列表。
        :type SegmentSet: list of MediaAiAnalysisFrameTagSegmentItem
        """
        self._SegmentSet = None

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaAiAnalysisFrameTagSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskFrameTagResult(AbstractModel):
    """智能按帧标签结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 智能按帧标签任务输入。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskFrameTagInput`
        :param _Output: 智能按帧标签任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskFrameTagOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskFrameTagInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskFrameTagOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskHeadTailInput(AbstractModel):
    """片头片尾任务输入类型

    """

    def __init__(self):
        r"""
        :param _Definition: 片头片尾识别模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskHeadTailOutput(AbstractModel):
    """片头片尾结果信息

    """

    def __init__(self):
        r"""
        :param _HeadTimeOffset: 片头pts。
注意：此字段可能返回 null，表示取不到有效值。
        :type HeadTimeOffset: float
        :param _TailTimeOffset: 片尾pts。
注意：此字段可能返回 null，表示取不到有效值。
        :type TailTimeOffset: float
        """
        self._HeadTimeOffset = None
        self._TailTimeOffset = None

    @property
    def HeadTimeOffset(self):
        return self._HeadTimeOffset

    @HeadTimeOffset.setter
    def HeadTimeOffset(self, HeadTimeOffset):
        self._HeadTimeOffset = HeadTimeOffset

    @property
    def TailTimeOffset(self):
        return self._TailTimeOffset

    @TailTimeOffset.setter
    def TailTimeOffset(self, TailTimeOffset):
        self._TailTimeOffset = TailTimeOffset


    def _deserialize(self, params):
        self._HeadTimeOffset = params.get("HeadTimeOffset")
        self._TailTimeOffset = params.get("TailTimeOffset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskHeadTailResult(AbstractModel):
    """片头片尾结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCode: 错误码，0：成功，其他值：失败。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 片头片尾任务输入。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskHeadTailInput`
        :param _Output: 片头片尾任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskHeadTailOutput`
        """
        self._Status = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskHeadTailInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskHeadTailOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskHighlightInput(AbstractModel):
    """智能精彩片段任务输入类型

    """

    def __init__(self):
        r"""
        :param _Definition: 视频智能精彩片段模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskHighlightOutput(AbstractModel):
    """智能精彩片段结果信息

    """

    def __init__(self):
        r"""
        :param _HighlightSet: 视频智能精彩片段列表。
        :type HighlightSet: list of MediaAiAnalysisHighlightItem
        :param _OutputStorage: 精彩片段的存储位置。
注意：此字段可能返回 null，表示取不到有效值。
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        self._HighlightSet = None
        self._OutputStorage = None

    @property
    def HighlightSet(self):
        return self._HighlightSet

    @HighlightSet.setter
    def HighlightSet(self, HighlightSet):
        self._HighlightSet = HighlightSet

    @property
    def OutputStorage(self):
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage


    def _deserialize(self, params):
        if params.get("HighlightSet") is not None:
            self._HighlightSet = []
            for item in params.get("HighlightSet"):
                obj = MediaAiAnalysisHighlightItem()
                obj._deserialize(item)
                self._HighlightSet.append(obj)
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskHighlightResult(AbstractModel):
    """智能精彩片段结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCode: 错误码，0：成功，其他值：失败。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 智能精彩片段任务输入。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskHighlightInput`
        :param _Output: 智能精彩片段任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskHighlightOutput`
        """
        self._Status = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskHighlightInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskHighlightOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskInput(AbstractModel):
    """AI 视频智能分析输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 视频内容分析模板 ID。
        :type Definition: int
        :param _ExtendedParameter: 扩展参数，其值为序列化的 json字符串。
注意：此参数为定制需求参数，需要线下对接。
注意：此字段可能返回 null，表示取不到有效值。
        :type ExtendedParameter: str
        """
        self._Definition = None
        self._ExtendedParameter = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def ExtendedParameter(self):
        return self._ExtendedParameter

    @ExtendedParameter.setter
    def ExtendedParameter(self, ExtendedParameter):
        self._ExtendedParameter = ExtendedParameter


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._ExtendedParameter = params.get("ExtendedParameter")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskSegmentInput(AbstractModel):
    """拆条任务输入类型

    """

    def __init__(self):
        r"""
        :param _Definition: 拆条任务模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskSegmentOutput(AbstractModel):
    """智能拆条结果信息

    """

    def __init__(self):
        r"""
        :param _SegmentSet: 智能拆条子片段列表。
        :type SegmentSet: list of SegmentRecognitionItem
        """
        self._SegmentSet = None

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = SegmentRecognitionItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskSegmentResult(AbstractModel):
    """拆条结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCode: 错误码，0：成功，其他值：失败。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 拆条任务输入。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskSegmentInput`
        :param _Output: 拆条任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskSegmentOutput`
        """
        self._Status = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskSegmentInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskSegmentOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskTagInput(AbstractModel):
    """智能标签任务输入类型

    """

    def __init__(self):
        r"""
        :param _Definition: 视频智能标签模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskTagOutput(AbstractModel):
    """智能标签结果信息

    """

    def __init__(self):
        r"""
        :param _TagSet: 视频智能标签列表。
        :type TagSet: list of MediaAiAnalysisTagItem
        """
        self._TagSet = None

    @property
    def TagSet(self):
        return self._TagSet

    @TagSet.setter
    def TagSet(self, TagSet):
        self._TagSet = TagSet


    def _deserialize(self, params):
        if params.get("TagSet") is not None:
            self._TagSet = []
            for item in params.get("TagSet"):
                obj = MediaAiAnalysisTagItem()
                obj._deserialize(item)
                self._TagSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskTagResult(AbstractModel):
    """智能标签结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 智能标签任务输入。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskTagInput`
        :param _Output: 智能标签任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskTagOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskTagInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskTagOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiContentReviewResult(AbstractModel):
    """内容审核结果

    """

    def __init__(self):
        r"""
        :param _Type: 任务的类型，可以取的值有：
<li>Porn：图片鉴黄</li>
<li>Terrorism：图片敏感</li>
<li>Political：图片敏感</li>
<li>Porn.Asr：Asr 文字鉴黄</li>
<li>Porn.Ocr：Ocr 文字鉴黄</li>
<li>Political.Asr：Asr 文字敏感</li>
<li>Political.Ocr：Ocr 文字敏感</li>
<li>Terrorism.Ocr：Ocr 文字敏感</li>
<li>Prohibited.Asr：Asr 文字鉴违禁</li>
<li>Prohibited.Ocr：Ocr 文字鉴违禁</li>
        :type Type: str
        :param _SampleRate: 采样频率，即对视频每秒截取进行审核的帧数。
        :type SampleRate: float
        :param _Duration: 审核的视频时长，单位：秒。
        :type Duration: float
        :param _PornTask: 视频内容审核智能画面鉴黄任务的查询结果，当任务类型为 Porn 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type PornTask: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskPornResult`
        :param _TerrorismTask: 视频内容审核智能画面敏感任务的查询结果，当任务类型为 Terrorism 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type TerrorismTask: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskTerrorismResult`
        :param _PoliticalTask: 视频内容审核智能画面敏感任务的查询结果，当任务类型为 Political 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type PoliticalTask: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskPoliticalResult`
        :param _PornAsrTask: 视频内容审核 Asr 文字鉴黄任务的查询结果，当任务类型为 Porn.Asr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type PornAsrTask: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskPornAsrResult`
        :param _PornOcrTask: 视频内容审核 Ocr 文字鉴黄任务的查询结果，当任务类型为 Porn.Ocr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type PornOcrTask: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskPornOcrResult`
        :param _PoliticalAsrTask: 视频内容审核 Asr 文字敏感任务的查询结果，当任务类型为 Political.Asr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type PoliticalAsrTask: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskPoliticalAsrResult`
        :param _PoliticalOcrTask: 视频内容审核 Ocr 文字敏感任务的查询结果，当任务类型为 Political.Ocr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type PoliticalOcrTask: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskPoliticalOcrResult`
        :param _TerrorismOcrTask: 视频内容审核 Ocr 文字敏感任务的查询结果，当任务类型为 Terrorism.Ocr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type TerrorismOcrTask: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskTerrorismOcrResult`
        :param _ProhibitedAsrTask: 视频内容审核 Asr 文字鉴违禁任务的查询结果，当任务类型为 Prohibited.Asr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type ProhibitedAsrTask: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskProhibitedAsrResult`
        :param _ProhibitedOcrTask: 视频内容审核 Ocr 文字鉴违禁任务的查询结果，当任务类型为 Prohibited.Ocr 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type ProhibitedOcrTask: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskProhibitedOcrResult`
        """
        self._Type = None
        self._SampleRate = None
        self._Duration = None
        self._PornTask = None
        self._TerrorismTask = None
        self._PoliticalTask = None
        self._PornAsrTask = None
        self._PornOcrTask = None
        self._PoliticalAsrTask = None
        self._PoliticalOcrTask = None
        self._TerrorismOcrTask = None
        self._ProhibitedAsrTask = None
        self._ProhibitedOcrTask = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def SampleRate(self):
        return self._SampleRate

    @SampleRate.setter
    def SampleRate(self, SampleRate):
        self._SampleRate = SampleRate

    @property
    def Duration(self):
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration

    @property
    def PornTask(self):
        return self._PornTask

    @PornTask.setter
    def PornTask(self, PornTask):
        self._PornTask = PornTask

    @property
    def TerrorismTask(self):
        return self._TerrorismTask

    @TerrorismTask.setter
    def TerrorismTask(self, TerrorismTask):
        self._TerrorismTask = TerrorismTask

    @property
    def PoliticalTask(self):
        return self._PoliticalTask

    @PoliticalTask.setter
    def PoliticalTask(self, PoliticalTask):
        self._PoliticalTask = PoliticalTask

    @property
    def PornAsrTask(self):
        return self._PornAsrTask

    @PornAsrTask.setter
    def PornAsrTask(self, PornAsrTask):
        self._PornAsrTask = PornAsrTask

    @property
    def PornOcrTask(self):
        return self._PornOcrTask

    @PornOcrTask.setter
    def PornOcrTask(self, PornOcrTask):
        self._PornOcrTask = PornOcrTask

    @property
    def PoliticalAsrTask(self):
        return self._PoliticalAsrTask

    @PoliticalAsrTask.setter
    def PoliticalAsrTask(self, PoliticalAsrTask):
        self._PoliticalAsrTask = PoliticalAsrTask

    @property
    def PoliticalOcrTask(self):
        return self._PoliticalOcrTask

    @PoliticalOcrTask.setter
    def PoliticalOcrTask(self, PoliticalOcrTask):
        self._PoliticalOcrTask = PoliticalOcrTask

    @property
    def TerrorismOcrTask(self):
        return self._TerrorismOcrTask

    @TerrorismOcrTask.setter
    def TerrorismOcrTask(self, TerrorismOcrTask):
        self._TerrorismOcrTask = TerrorismOcrTask

    @property
    def ProhibitedAsrTask(self):
        return self._ProhibitedAsrTask

    @ProhibitedAsrTask.setter
    def ProhibitedAsrTask(self, ProhibitedAsrTask):
        self._ProhibitedAsrTask = ProhibitedAsrTask

    @property
    def ProhibitedOcrTask(self):
        return self._ProhibitedOcrTask

    @ProhibitedOcrTask.setter
    def ProhibitedOcrTask(self, ProhibitedOcrTask):
        self._ProhibitedOcrTask = ProhibitedOcrTask


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._SampleRate = params.get("SampleRate")
        self._Duration = params.get("Duration")
        if params.get("PornTask") is not None:
            self._PornTask = AiReviewTaskPornResult()
            self._PornTask._deserialize(params.get("PornTask"))
        if params.get("TerrorismTask") is not None:
            self._TerrorismTask = AiReviewTaskTerrorismResult()
            self._TerrorismTask._deserialize(params.get("TerrorismTask"))
        if params.get("PoliticalTask") is not None:
            self._PoliticalTask = AiReviewTaskPoliticalResult()
            self._PoliticalTask._deserialize(params.get("PoliticalTask"))
        if params.get("PornAsrTask") is not None:
            self._PornAsrTask = AiReviewTaskPornAsrResult()
            self._PornAsrTask._deserialize(params.get("PornAsrTask"))
        if params.get("PornOcrTask") is not None:
            self._PornOcrTask = AiReviewTaskPornOcrResult()
            self._PornOcrTask._deserialize(params.get("PornOcrTask"))
        if params.get("PoliticalAsrTask") is not None:
            self._PoliticalAsrTask = AiReviewTaskPoliticalAsrResult()
            self._PoliticalAsrTask._deserialize(params.get("PoliticalAsrTask"))
        if params.get("PoliticalOcrTask") is not None:
            self._PoliticalOcrTask = AiReviewTaskPoliticalOcrResult()
            self._PoliticalOcrTask._deserialize(params.get("PoliticalOcrTask"))
        if params.get("TerrorismOcrTask") is not None:
            self._TerrorismOcrTask = AiReviewTaskTerrorismOcrResult()
            self._TerrorismOcrTask._deserialize(params.get("TerrorismOcrTask"))
        if params.get("ProhibitedAsrTask") is not None:
            self._ProhibitedAsrTask = AiReviewTaskProhibitedAsrResult()
            self._ProhibitedAsrTask._deserialize(params.get("ProhibitedAsrTask"))
        if params.get("ProhibitedOcrTask") is not None:
            self._ProhibitedOcrTask = AiReviewTaskProhibitedOcrResult()
            self._ProhibitedOcrTask._deserialize(params.get("ProhibitedOcrTask"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiContentReviewTaskInput(AbstractModel):
    """智能内容审核任务类型

    """

    def __init__(self):
        r"""
        :param _Definition: 视频内容审核模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiParagraphInfo(AbstractModel):
    """分段信息。

    """

    def __init__(self):
        r"""
        :param _Summary: 分段摘要
注意：此字段可能返回 null，表示取不到有效值。
        :type Summary: str
        :param _StartTimeOffset: 分段起始时间点，秒
注意：此字段可能返回 null，表示取不到有效值。
        :type StartTimeOffset: float
        :param _EndTimeOffset: 分段结束时间点，秒
注意：此字段可能返回 null，表示取不到有效值。
        :type EndTimeOffset: float
        """
        self._Summary = None
        self._StartTimeOffset = None
        self._EndTimeOffset = None

    @property
    def Summary(self):
        return self._Summary

    @Summary.setter
    def Summary(self, Summary):
        self._Summary = Summary

    @property
    def StartTimeOffset(self):
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset


    def _deserialize(self, params):
        self._Summary = params.get("Summary")
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiQualityControlTaskInput(AbstractModel):
    """视频质检输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 媒体质检模板 ID 。暂时可以直接使用 预设模板ID 10，后面控制台支持用户配置自定义模板。
注意：此字段可能返回 null，表示取不到有效值。
        :type Definition: int
        :param _ChannelExtPara: 渠道扩展参数json序列化字符串。
注意：此字段可能返回 null，表示取不到有效值。
        :type ChannelExtPara: str
        """
        self._Definition = None
        self._ChannelExtPara = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def ChannelExtPara(self):
        return self._ChannelExtPara

    @ChannelExtPara.setter
    def ChannelExtPara(self, ChannelExtPara):
        self._ChannelExtPara = ChannelExtPara


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._ChannelExtPara = params.get("ChannelExtPara")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionResult(AbstractModel):
    """智能识别结果。

    """

    def __init__(self):
        r"""
        :param _Type: 任务的类型，取值范围：
<li>FaceRecognition：人脸识别，</li>
<li>AsrWordsRecognition：语音关键词识别，</li>
<li>OcrWordsRecognition：文本关键词识别，</li>
<li>AsrFullTextRecognition：语音全文识别，</li>
<li>OcrFullTextRecognition：文本全文识别。</li>
<li>TransTextRecognition：语音翻译。</li>
        :type Type: str
        :param _FaceTask: 人脸识别结果，当 Type 为 
 FaceRecognition 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type FaceTask: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskFaceResult`
        :param _AsrWordsTask: 语音关键词识别结果，当 Type 为
 AsrWordsRecognition 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type AsrWordsTask: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskAsrWordsResult`
        :param _AsrFullTextTask: 语音全文识别结果，当 Type 为
 AsrFullTextRecognition 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type AsrFullTextTask: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskAsrFullTextResult`
        :param _OcrWordsTask: 文本关键词识别结果，当 Type 为
 OcrWordsRecognition 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type OcrWordsTask: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskOcrWordsResult`
        :param _OcrFullTextTask: 文本全文识别结果，当 Type 为
 OcrFullTextRecognition 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type OcrFullTextTask: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskOcrFullTextResult`
        :param _TransTextTask: 翻译结果，当 Type 为

TransTextRecognition 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type TransTextTask: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskTransTextResult`
        :param _ObjectTask: 物体识别结果，当Type 为

ObjectRecognition 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type ObjectTask: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskObjectResult`
        """
        self._Type = None
        self._FaceTask = None
        self._AsrWordsTask = None
        self._AsrFullTextTask = None
        self._OcrWordsTask = None
        self._OcrFullTextTask = None
        self._TransTextTask = None
        self._ObjectTask = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def FaceTask(self):
        return self._FaceTask

    @FaceTask.setter
    def FaceTask(self, FaceTask):
        self._FaceTask = FaceTask

    @property
    def AsrWordsTask(self):
        return self._AsrWordsTask

    @AsrWordsTask.setter
    def AsrWordsTask(self, AsrWordsTask):
        self._AsrWordsTask = AsrWordsTask

    @property
    def AsrFullTextTask(self):
        return self._AsrFullTextTask

    @AsrFullTextTask.setter
    def AsrFullTextTask(self, AsrFullTextTask):
        self._AsrFullTextTask = AsrFullTextTask

    @property
    def OcrWordsTask(self):
        return self._OcrWordsTask

    @OcrWordsTask.setter
    def OcrWordsTask(self, OcrWordsTask):
        self._OcrWordsTask = OcrWordsTask

    @property
    def OcrFullTextTask(self):
        return self._OcrFullTextTask

    @OcrFullTextTask.setter
    def OcrFullTextTask(self, OcrFullTextTask):
        self._OcrFullTextTask = OcrFullTextTask

    @property
    def TransTextTask(self):
        return self._TransTextTask

    @TransTextTask.setter
    def TransTextTask(self, TransTextTask):
        self._TransTextTask = TransTextTask

    @property
    def ObjectTask(self):
        return self._ObjectTask

    @ObjectTask.setter
    def ObjectTask(self, ObjectTask):
        self._ObjectTask = ObjectTask


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("FaceTask") is not None:
            self._FaceTask = AiRecognitionTaskFaceResult()
            self._FaceTask._deserialize(params.get("FaceTask"))
        if params.get("AsrWordsTask") is not None:
            self._AsrWordsTask = AiRecognitionTaskAsrWordsResult()
            self._AsrWordsTask._deserialize(params.get("AsrWordsTask"))
        if params.get("AsrFullTextTask") is not None:
            self._AsrFullTextTask = AiRecognitionTaskAsrFullTextResult()
            self._AsrFullTextTask._deserialize(params.get("AsrFullTextTask"))
        if params.get("OcrWordsTask") is not None:
            self._OcrWordsTask = AiRecognitionTaskOcrWordsResult()
            self._OcrWordsTask._deserialize(params.get("OcrWordsTask"))
        if params.get("OcrFullTextTask") is not None:
            self._OcrFullTextTask = AiRecognitionTaskOcrFullTextResult()
            self._OcrFullTextTask._deserialize(params.get("OcrFullTextTask"))
        if params.get("TransTextTask") is not None:
            self._TransTextTask = AiRecognitionTaskTransTextResult()
            self._TransTextTask._deserialize(params.get("TransTextTask"))
        if params.get("ObjectTask") is not None:
            self._ObjectTask = AiRecognitionTaskObjectResult()
            self._ObjectTask._deserialize(params.get("ObjectTask"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrFullTextResult(AbstractModel):
    """语音全文识别结果。

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 语音全文识别任务输入信息。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskAsrFullTextResultInput`
        :param _Output: 语音全文识别任务输出信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskAsrFullTextResultOutput`
        :param _Progress: 任务进度。
注意：此字段可能返回 null，表示取不到有效值。
        :type Progress: int
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskAsrFullTextResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskAsrFullTextResultOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrFullTextResultInput(AbstractModel):
    """语音全文识别的输入。

    """

    def __init__(self):
        r"""
        :param _Definition: 语音全文识别模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrFullTextResultOutput(AbstractModel):
    """语音全文识别结果。

    """

    def __init__(self):
        r"""
        :param _SegmentSet: 语音全文识别片段列表。
        :type SegmentSet: list of AiRecognitionTaskAsrFullTextSegmentItem
        :param _SubtitlePath: 字幕文件地址。
        :type SubtitlePath: str
        :param _OutputStorage: 字幕文件存储位置。
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        self._SegmentSet = None
        self._SubtitlePath = None
        self._OutputStorage = None

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SubtitlePath(self):
        return self._SubtitlePath

    @SubtitlePath.setter
    def SubtitlePath(self, SubtitlePath):
        self._SubtitlePath = SubtitlePath

    @property
    def OutputStorage(self):
        warnings.warn("parameter `OutputStorage` is deprecated", DeprecationWarning) 

        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        warnings.warn("parameter `OutputStorage` is deprecated", DeprecationWarning) 

        self._OutputStorage = OutputStorage


    def _deserialize(self, params):
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskAsrFullTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SubtitlePath = params.get("SubtitlePath")
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrFullTextSegmentItem(AbstractModel):
    """语音全文识别片段。

    """

    def __init__(self):
        r"""
        :param _Confidence: 识别片段置信度。取值：0~100。
        :type Confidence: float
        :param _StartTimeOffset: 识别片段起始的偏移时间，单位：秒。
        :type StartTimeOffset: float
        :param _EndTimeOffset: 识别片段终止的偏移时间，单位：秒。
        :type EndTimeOffset: float
        :param _Text: 识别文本。
        :type Text: str
        """
        self._Confidence = None
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Text = None

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def StartTimeOffset(self):
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Text(self):
        return self._Text

    @Text.setter
    def Text(self, Text):
        self._Text = Text


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Text = params.get("Text")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrWordsResult(AbstractModel):
    """语音关键词识别结果。

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 语音关键词识别任务输入信息。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskAsrWordsResultInput`
        :param _Output: 语音关键词识别任务输出信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskAsrWordsResultOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskAsrWordsResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskAsrWordsResultOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrWordsResultInput(AbstractModel):
    """语音关键词识别输入。

    """

    def __init__(self):
        r"""
        :param _Definition: 语音关键词识别模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrWordsResultItem(AbstractModel):
    """语音关键词识别结果。

    """

    def __init__(self):
        r"""
        :param _Word: 语音关键词。
        :type Word: str
        :param _SegmentSet: 语音关键词出现的时间片段列表。
        :type SegmentSet: list of AiRecognitionTaskAsrWordsSegmentItem
        """
        self._Word = None
        self._SegmentSet = None

    @property
    def Word(self):
        return self._Word

    @Word.setter
    def Word(self, Word):
        self._Word = Word

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Word = params.get("Word")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskAsrWordsSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrWordsResultOutput(AbstractModel):
    """语音关键词识别输出。

    """

    def __init__(self):
        r"""
        :param _ResultSet: 语音关键词识别结果集。
        :type ResultSet: list of AiRecognitionTaskAsrWordsResultItem
        """
        self._ResultSet = None

    @property
    def ResultSet(self):
        return self._ResultSet

    @ResultSet.setter
    def ResultSet(self, ResultSet):
        self._ResultSet = ResultSet


    def _deserialize(self, params):
        if params.get("ResultSet") is not None:
            self._ResultSet = []
            for item in params.get("ResultSet"):
                obj = AiRecognitionTaskAsrWordsResultItem()
                obj._deserialize(item)
                self._ResultSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrWordsSegmentItem(AbstractModel):
    """语音识别片段。

    """

    def __init__(self):
        r"""
        :param _StartTimeOffset: 识别片段起始的偏移时间，单位：秒。
        :type StartTimeOffset: float
        :param _EndTimeOffset: 识别片段终止的偏移时间，单位：秒。
        :type EndTimeOffset: float
        :param _Confidence: 识别片段置信度。取值：0~100。
        :type Confidence: float
        """
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Confidence = None

    @property
    def StartTimeOffset(self):
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence


    def _deserialize(self, params):
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Confidence = params.get("Confidence")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskFaceResult(AbstractModel):
    """人脸识别结果。

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 人脸识别任务输入信息。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskFaceResultInput`
        :param _Output: 人脸识别任务输出信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskFaceResultOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskFaceResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskFaceResultOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskFaceResultInput(AbstractModel):
    """人脸识别输入。

    """

    def __init__(self):
        r"""
        :param _Definition: 人脸识别模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskFaceResultItem(AbstractModel):
    """人脸识别结果

    """

    def __init__(self):
        r"""
        :param _Id: 人物唯一标识 ID。
        :type Id: str
        :param _Type: 人物库类型，表示识别出的人物来自哪个人物库：
<li>Default：默认人物库；</li>
<li>UserDefine：用户自定义人物库。</li>
        :type Type: str
        :param _Name: 人物名称。
        :type Name: str
        :param _SegmentSet: 人物出现的片段结果集。
        :type SegmentSet: list of AiRecognitionTaskFaceSegmentItem
        :param _Gender: 人物性别：
<li>Male：男性；</li>
<li>Female：女性。</li>
注意：此字段可能返回 null，表示取不到有效值。
        :type Gender: str
        :param _Birthday: 人物出生日期。
注意：此字段可能返回 null，表示取不到有效值。
        :type Birthday: str
        :param _Profession: 人物职业或者职务。
注意：此字段可能返回 null，表示取不到有效值。
        :type Profession: str
        :param _SchoolOfGraduation: 人物毕业院校。
注意：此字段可能返回 null，表示取不到有效值。
        :type SchoolOfGraduation: str
        :param _Abstract: 人物简介。
注意：此字段可能返回 null，表示取不到有效值。
        :type Abstract: str
        :param _PlaceOfBirth: 人物出生地或者籍贯。
注意：此字段可能返回 null，表示取不到有效值。
        :type PlaceOfBirth: str
        :param _PersonType: 人物类型：
<li>Politician：官员；</li>
<li>Artist：艺人。</li>
注意：此字段可能返回 null，表示取不到有效值。
        :type PersonType: str
        :param _Remark: 敏感度标注：
<li>Normal：正常；</li>
<li>Sensitive：敏感。</li>
注意：此字段可能返回 null，表示取不到有效值。
        :type Remark: str
        :param _Url: 截图链接
注意：此字段可能返回 null，表示取不到有效值。
        :type Url: str
        """
        self._Id = None
        self._Type = None
        self._Name = None
        self._SegmentSet = None
        self._Gender = None
        self._Birthday = None
        self._Profession = None
        self._SchoolOfGraduation = None
        self._Abstract = None
        self._PlaceOfBirth = None
        self._PersonType = None
        self._Remark = None
        self._Url = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def Gender(self):
        return self._Gender

    @Gender.setter
    def Gender(self, Gender):
        self._Gender = Gender

    @property
    def Birthday(self):
        return self._Birthday

    @Birthday.setter
    def Birthday(self, Birthday):
        self._Birthday = Birthday

    @property
    def Profession(self):
        return self._Profession

    @Profession.setter
    def Profession(self, Profession):
        self._Profession = Profession

    @property
    def SchoolOfGraduation(self):
        return self._SchoolOfGraduation

    @SchoolOfGraduation.setter
    def SchoolOfGraduation(self, SchoolOfGraduation):
        self._SchoolOfGraduation = SchoolOfGraduation

    @property
    def Abstract(self):
        return self._Abstract

    @Abstract.setter
    def Abstract(self, Abstract):
        self._Abstract = Abstract

    @property
    def PlaceOfBirth(self):
        return self._PlaceOfBirth

    @PlaceOfBirth.setter
    def PlaceOfBirth(self, PlaceOfBirth):
        self._PlaceOfBirth = PlaceOfBirth

    @property
    def PersonType(self):
        return self._PersonType

    @PersonType.setter
    def PersonType(self, PersonType):
        self._PersonType = PersonType

    @property
    def Remark(self):
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def Url(self):
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskFaceSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._Gender = params.get("Gender")
        self._Birthday = params.get("Birthday")
        self._Profession = params.get("Profession")
        self._SchoolOfGraduation = params.get("SchoolOfGraduation")
        self._Abstract = params.get("Abstract")
        self._PlaceOfBirth = params.get("PlaceOfBirth")
        self._PersonType = params.get("PersonType")
        self._Remark = params.get("Remark")
        self._Url = params.get("Url")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskFaceResultOutput(AbstractModel):
    """智能人脸识别输出。

    """

    def __init__(self):
        r"""
        :param _ResultSet: 智能人脸识别结果集。
        :type ResultSet: list of AiRecognitionTaskFaceResultItem
        """
        self._ResultSet = None

    @property
    def ResultSet(self):
        return self._ResultSet

    @ResultSet.setter
    def ResultSet(self, ResultSet):
        self._ResultSet = ResultSet


    def _deserialize(self, params):
        if params.get("ResultSet") is not None:
            self._ResultSet = []
            for item in params.get("ResultSet"):
                obj = AiRecognitionTaskFaceResultItem()
                obj._deserialize(item)
                self._ResultSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskFaceSegmentItem(AbstractModel):
    """人脸识别结果片段

    """

    def __init__(self):
        r"""
        :param _StartTimeOffset: 识别片段起始的偏移时间，单位：秒。
        :type StartTimeOffset: float
        :param _EndTimeOffset: 识别片段终止的偏移时间，单位：秒。
        :type EndTimeOffset: float
        :param _Confidence: 识别片段置信度。取值：0~100。
        :type Confidence: float
        :param _AreaCoordSet: 识别结果的区域坐标。数组包含 4 个元素 [x1,y1,x2,y2]，依次表示区域左上点、右下点的横纵坐标。
        :type AreaCoordSet: list of int
        """
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Confidence = None
        self._AreaCoordSet = None

    @property
    def StartTimeOffset(self):
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def AreaCoordSet(self):
        return self._AreaCoordSet

    @AreaCoordSet.setter
    def AreaCoordSet(self, AreaCoordSet):
        self._AreaCoordSet = AreaCoordSet


    def _deserialize(self, params):
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Confidence = params.get("Confidence")
        self._AreaCoordSet = params.get("AreaCoordSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskInput(AbstractModel):
    """视频内容识别输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 视频智能识别模板 ID 。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskObjectResult(AbstractModel):
    """物体识别结果。

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCode: 错误码，0：成功，其他值：失败。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 物体识别任务输入信息。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskObjectResultInput`
        :param _Output: 物体识别任务输出信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskObjectResultOutput`
        """
        self._Status = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskObjectResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskObjectResultOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskObjectResultInput(AbstractModel):
    """物体识别任务输入类型。

    """

    def __init__(self):
        r"""
        :param _Definition: 物体识别模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskObjectResultItem(AbstractModel):
    """单个物体识别结果。

    """

    def __init__(self):
        r"""
        :param _Name: 识别的物体名称。
        :type Name: str
        :param _SegmentSet: 物体出现的片段列表。
        :type SegmentSet: list of AiRecognitionTaskObjectSeqmentItem
        """
        self._Name = None
        self._SegmentSet = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Name = params.get("Name")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskObjectSeqmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskObjectResultOutput(AbstractModel):
    """智能物体识别输出。

    """

    def __init__(self):
        r"""
        :param _ResultSet: 智能物体识别结果集。
        :type ResultSet: list of AiRecognitionTaskObjectResultItem
        """
        self._ResultSet = None

    @property
    def ResultSet(self):
        return self._ResultSet

    @ResultSet.setter
    def ResultSet(self, ResultSet):
        self._ResultSet = ResultSet


    def _deserialize(self, params):
        if params.get("ResultSet") is not None:
            self._ResultSet = []
            for item in params.get("ResultSet"):
                obj = AiRecognitionTaskObjectResultItem()
                obj._deserialize(item)
                self._ResultSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskObjectSeqmentItem(AbstractModel):
    """物体识别结果片段。

    """

    def __init__(self):
        r"""
        :param _StartTimeOffset: 识别片段起始的偏移时间，单位：秒。
        :type StartTimeOffset: float
        :param _EndTimeOffset: 识别片段终止的偏移时间，单位：秒。
        :type EndTimeOffset: float
        :param _Confidence: 识别片段置信度。取值：0~100。
        :type Confidence: float
        :param _AreaCoordSet: 识别结果的区域坐标。数组包含 4 个元素 [x1,y1,x2,y2]，依次表示区域左上点、右下点的横纵坐标。
        :type AreaCoordSet: list of int
        """
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Confidence = None
        self._AreaCoordSet = None

    @property
    def StartTimeOffset(self):
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def AreaCoordSet(self):
        return self._AreaCoordSet

    @AreaCoordSet.setter
    def AreaCoordSet(self, AreaCoordSet):
        self._AreaCoordSet = AreaCoordSet


    def _deserialize(self, params):
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Confidence = params.get("Confidence")
        self._AreaCoordSet = params.get("AreaCoordSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrFullTextResult(AbstractModel):
    """文本全文识别结果。

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 文本全文识别任务输入信息。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskOcrFullTextResultInput`
        :param _Output: 文本全文识别任务输出信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskOcrFullTextResultOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskOcrFullTextResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskOcrFullTextResultOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrFullTextResultInput(AbstractModel):
    """文本全文识别输入。

    """

    def __init__(self):
        r"""
        :param _Definition: 文本全文识别模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrFullTextResultOutput(AbstractModel):
    """文本全文识别输出。

    """

    def __init__(self):
        r"""
        :param _SegmentSet: 文本全文识别结果集。
        :type SegmentSet: list of AiRecognitionTaskOcrFullTextSegmentItem
        """
        self._SegmentSet = None

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskOcrFullTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrFullTextSegmentItem(AbstractModel):
    """文本全文识别片段。

    """

    def __init__(self):
        r"""
        :param _StartTimeOffset: 识别片段起始的偏移时间，单位：秒。
        :type StartTimeOffset: float
        :param _EndTimeOffset: 识别片段终止的偏移时间，单位：秒。
        :type EndTimeOffset: float
        :param _TextSet: 识别片段结果集。
        :type TextSet: list of AiRecognitionTaskOcrFullTextSegmentTextItem
        """
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._TextSet = None

    @property
    def StartTimeOffset(self):
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def TextSet(self):
        return self._TextSet

    @TextSet.setter
    def TextSet(self, TextSet):
        self._TextSet = TextSet


    def _deserialize(self, params):
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        if params.get("TextSet") is not None:
            self._TextSet = []
            for item in params.get("TextSet"):
                obj = AiRecognitionTaskOcrFullTextSegmentTextItem()
                obj._deserialize(item)
                self._TextSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrFullTextSegmentTextItem(AbstractModel):
    """文本全文识别片段。

    """

    def __init__(self):
        r"""
        :param _Confidence: 识别片段置信度。取值：0~100。
        :type Confidence: float
        :param _AreaCoordSet: 识别结果的区域坐标。数组包含 4 个元素 [x1,y1,x2,y2]，依次表示区域左上点、右下点的横纵坐标。
        :type AreaCoordSet: list of int
        :param _Text: 识别文本。
        :type Text: str
        """
        self._Confidence = None
        self._AreaCoordSet = None
        self._Text = None

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def AreaCoordSet(self):
        return self._AreaCoordSet

    @AreaCoordSet.setter
    def AreaCoordSet(self, AreaCoordSet):
        self._AreaCoordSet = AreaCoordSet

    @property
    def Text(self):
        return self._Text

    @Text.setter
    def Text(self, Text):
        self._Text = Text


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._AreaCoordSet = params.get("AreaCoordSet")
        self._Text = params.get("Text")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrWordsResult(AbstractModel):
    """文本关键识别结果。

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 文本关键词识别任务输入信息。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskOcrWordsResultInput`
        :param _Output: 文本关键词识别任务输出信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskOcrWordsResultOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskOcrWordsResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskOcrWordsResultOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrWordsResultInput(AbstractModel):
    """文本关键词识别输入。

    """

    def __init__(self):
        r"""
        :param _Definition: 文本关键词识别模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrWordsResultItem(AbstractModel):
    """文本关键词识别结果。

    """

    def __init__(self):
        r"""
        :param _Word: 文本关键词。
        :type Word: str
        :param _SegmentSet: 文本关键出现的片段列表。
        :type SegmentSet: list of AiRecognitionTaskOcrWordsSegmentItem
        """
        self._Word = None
        self._SegmentSet = None

    @property
    def Word(self):
        return self._Word

    @Word.setter
    def Word(self, Word):
        self._Word = Word

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Word = params.get("Word")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskOcrWordsSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrWordsResultOutput(AbstractModel):
    """文本关键词识别输出。

    """

    def __init__(self):
        r"""
        :param _ResultSet: 文本关键词识别结果集。
        :type ResultSet: list of AiRecognitionTaskOcrWordsResultItem
        """
        self._ResultSet = None

    @property
    def ResultSet(self):
        return self._ResultSet

    @ResultSet.setter
    def ResultSet(self, ResultSet):
        self._ResultSet = ResultSet


    def _deserialize(self, params):
        if params.get("ResultSet") is not None:
            self._ResultSet = []
            for item in params.get("ResultSet"):
                obj = AiRecognitionTaskOcrWordsResultItem()
                obj._deserialize(item)
                self._ResultSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrWordsSegmentItem(AbstractModel):
    """文本识别片段。

    """

    def __init__(self):
        r"""
        :param _StartTimeOffset: 识别片段起始的偏移时间，单位：秒。
        :type StartTimeOffset: float
        :param _EndTimeOffset: 识别片段终止的偏移时间，单位：秒。
        :type EndTimeOffset: float
        :param _Confidence: 识别片段置信度。取值：0~100。
        :type Confidence: float
        :param _AreaCoordSet: 识别结果的区域坐标。数组包含 4 个元素 [x1,y1,x2,y2]，依次表示区域左上点、右下点的横纵坐标。
        :type AreaCoordSet: list of int
        """
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Confidence = None
        self._AreaCoordSet = None

    @property
    def StartTimeOffset(self):
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def AreaCoordSet(self):
        return self._AreaCoordSet

    @AreaCoordSet.setter
    def AreaCoordSet(self, AreaCoordSet):
        self._AreaCoordSet = AreaCoordSet


    def _deserialize(self, params):
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Confidence = params.get("Confidence")
        self._AreaCoordSet = params.get("AreaCoordSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskTransTextResult(AbstractModel):
    """翻译结果。

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 翻译任务输入信息。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskTransTextResultInput`
        :param _Output: 翻译任务输出信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskTransTextResultOutput`
        :param _Progress: 任务进度。
注意：此字段可能返回 null，表示取不到有效值。
        :type Progress: int
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskTransTextResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskTransTextResultOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskTransTextResultInput(AbstractModel):
    """翻译的输入。

    """

    def __init__(self):
        r"""
        :param _Definition: 翻译模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskTransTextResultOutput(AbstractModel):
    """翻译结果。

    """

    def __init__(self):
        r"""
        :param _SegmentSet: 翻译片段列表。
        :type SegmentSet: list of AiRecognitionTaskTransTextSegmentItem
        :param _SubtitlePath: 字幕文件地址。
        :type SubtitlePath: str
        """
        self._SegmentSet = None
        self._SubtitlePath = None

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SubtitlePath(self):
        return self._SubtitlePath

    @SubtitlePath.setter
    def SubtitlePath(self, SubtitlePath):
        self._SubtitlePath = SubtitlePath


    def _deserialize(self, params):
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskTransTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SubtitlePath = params.get("SubtitlePath")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskTransTextSegmentItem(AbstractModel):
    """翻译片段。

    """

    def __init__(self):
        r"""
        :param _Confidence: 识别片段置信度。取值：0~100。
        :type Confidence: float
        :param _StartTimeOffset: 识别片段起始的偏移时间，单位：秒。
        :type StartTimeOffset: float
        :param _EndTimeOffset: 识别片段终止的偏移时间，单位：秒。
        :type EndTimeOffset: float
        :param _Text: 识别文本。
        :type Text: str
        :param _Trans: 翻译文本。
        :type Trans: str
        """
        self._Confidence = None
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Text = None
        self._Trans = None

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def StartTimeOffset(self):
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Text(self):
        return self._Text

    @Text.setter
    def Text(self, Text):
        self._Text = Text

    @property
    def Trans(self):
        return self._Trans

    @Trans.setter
    def Trans(self, Trans):
        self._Trans = Trans


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Text = params.get("Text")
        self._Trans = params.get("Trans")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPoliticalAsrTaskInput(AbstractModel):
    """内容审核 Asr 文字敏感任务输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPoliticalAsrTaskOutput(AbstractModel):
    """Asr 文字敏感信息

    """

    def __init__(self):
        r"""
        :param _Confidence: Asr 文字敏感评分，分值为0到100。
        :type Confidence: float
        :param _Suggestion: Asr 文字敏感结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :type Suggestion: str
        :param _SegmentSet: Asr 文字敏感嫌疑的视频片段列表。
        :type SegmentSet: list of MediaContentReviewAsrTextSegmentItem
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewAsrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPoliticalOcrTaskInput(AbstractModel):
    """内容审核 Ocr 文字敏感任务输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPoliticalOcrTaskOutput(AbstractModel):
    """Ocr 文字敏感信息

    """

    def __init__(self):
        r"""
        :param _Confidence: Ocr 文字敏感评分，分值为0到100。
        :type Confidence: float
        :param _Suggestion: Ocr 文字敏感结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :type Suggestion: str
        :param _SegmentSet: Ocr 文字有敏感嫌疑的视频片段列表。
        :type SegmentSet: list of MediaContentReviewOcrTextSegmentItem
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewOcrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPoliticalTaskInput(AbstractModel):
    """内容审核敏感任务输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPoliticalTaskOutput(AbstractModel):
    """涉敏信息

    """

    def __init__(self):
        r"""
        :param _Confidence: 视频涉敏评分，分值为0到100。
        :type Confidence: float
        :param _Suggestion: 涉敏结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :type Suggestion: str
        :param _Label: 视频涉敏结果标签。内容审核模板[画面涉敏任务控制参数](https://cloud.tencent.com/document/api/862/37615#AiReviewPoliticalTaskOutput)里 LabelSet 参数与此参数取值范围的对应关系：
violation_photo：
<li>violation_photo：违规图标。</li>
其他（即 politician/entertainment/sport/entrepreneur/scholar/celebrity/military）：
<li>politician：涉敏人物。</li>
        :type Label: str
        :param _SegmentSet: 有涉敏嫌疑的视频片段列表。
        :type SegmentSet: list of MediaContentReviewPoliticalSegmentItem
        """
        self._Confidence = None
        self._Suggestion = None
        self._Label = None
        self._SegmentSet = None

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def Label(self):
        return self._Label

    @Label.setter
    def Label(self, Label):
        self._Label = Label

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        self._Label = params.get("Label")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewPoliticalSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPornAsrTaskInput(AbstractModel):
    """内容审核 Asr 文字鉴黄任务输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 鉴黄模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPornAsrTaskOutput(AbstractModel):
    """Asr 文字涉黄信息

    """

    def __init__(self):
        r"""
        :param _Confidence: Asr 文字涉黄评分，分值为0到100。
        :type Confidence: float
        :param _Suggestion: Asr 文字涉黄结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :type Suggestion: str
        :param _SegmentSet: Asr 文字有涉黄嫌疑的视频片段列表。
        :type SegmentSet: list of MediaContentReviewAsrTextSegmentItem
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewAsrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPornOcrTaskInput(AbstractModel):
    """内容审核 Ocr 文字鉴黄任务输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 鉴黄模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPornOcrTaskOutput(AbstractModel):
    """Ocr 文字涉黄信息

    """

    def __init__(self):
        r"""
        :param _Confidence: Ocr 文字涉黄评分，分值为0到100。
        :type Confidence: float
        :param _Suggestion: Ocr 文字涉黄结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :type Suggestion: str
        :param _SegmentSet: Ocr 文字有涉黄嫌疑的视频片段列表。
        :type SegmentSet: list of MediaContentReviewOcrTextSegmentItem
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewOcrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPornTaskInput(AbstractModel):
    """内容审核鉴黄任务输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 鉴黄模板 ID。
注意：此字段可能返回 null，表示取不到有效值。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPornTaskOutput(AbstractModel):
    """鉴黄结果信息

    """

    def __init__(self):
        r"""
        :param _Confidence: 视频鉴黄评分，分值为0到100。
        :type Confidence: float
        :param _Suggestion: 鉴黄结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :type Suggestion: str
        :param _Label: 视频鉴黄结果标签，取值范围：
<li>porn：色情。</li>
<li>sexy：性感。</li>
<li>vulgar：低俗。</li>
<li>intimacy：亲密行为。</li>
        :type Label: str
        :param _SegmentSet: 有涉黄嫌疑的视频片段列表。
        :type SegmentSet: list of MediaContentReviewSegmentItem
        """
        self._Confidence = None
        self._Suggestion = None
        self._Label = None
        self._SegmentSet = None

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def Label(self):
        return self._Label

    @Label.setter
    def Label(self, Label):
        self._Label = Label

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        self._Label = params.get("Label")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewProhibitedAsrTaskInput(AbstractModel):
    """内容审核 Asr 文字鉴违禁任务输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 鉴违禁模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewProhibitedAsrTaskOutput(AbstractModel):
    """Asr 文字涉违禁信息

    """

    def __init__(self):
        r"""
        :param _Confidence: Asr 文字涉违禁评分，分值为0到100。
        :type Confidence: float
        :param _Suggestion: Asr 文字涉违禁结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :type Suggestion: str
        :param _SegmentSet: Asr 文字有涉违禁嫌疑的视频片段列表。
        :type SegmentSet: list of MediaContentReviewAsrTextSegmentItem
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewAsrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewProhibitedOcrTaskInput(AbstractModel):
    """内容审核 Ocr 文字鉴违禁任务输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 鉴违禁模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewProhibitedOcrTaskOutput(AbstractModel):
    """Ocr 文字涉违禁信息

    """

    def __init__(self):
        r"""
        :param _Confidence: Ocr 文字涉违禁评分，分值为0到100。
        :type Confidence: float
        :param _Suggestion: Ocr 文字涉违禁结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :type Suggestion: str
        :param _SegmentSet: Ocr 文字有涉违禁嫌疑的视频片段列表。
        :type SegmentSet: list of MediaContentReviewOcrTextSegmentItem
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewOcrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskPoliticalAsrResult(AbstractModel):
    """内容审核 Asr 文字敏感任务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 内容审核 Asr 文字敏感任务输入。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiReviewPoliticalAsrTaskInput`
        :param _Output: 内容审核 Asr 文字敏感任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiReviewPoliticalAsrTaskOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewPoliticalAsrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewPoliticalAsrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskPoliticalOcrResult(AbstractModel):
    """内容审核 Ocr 文字敏感任务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS，FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 内容审核 Ocr 文字敏感任务输入。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiReviewPoliticalOcrTaskInput`
        :param _Output: 内容审核 Ocr 文字敏感任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiReviewPoliticalOcrTaskOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewPoliticalOcrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewPoliticalOcrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskPoliticalResult(AbstractModel):
    """内容审核涉敏任务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 内容审核涉敏任务输入。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiReviewPoliticalTaskInput`
        :param _Output: 内容审核涉敏任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiReviewPoliticalTaskOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewPoliticalTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewPoliticalTaskOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskPornAsrResult(AbstractModel):
    """内容审核 Asr 文字鉴黄任务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 内容审核 Asr 文字鉴黄任务输入。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiReviewPornAsrTaskInput`
        :param _Output: 内容审核 Asr 文字鉴黄任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiReviewPornAsrTaskOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewPornAsrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewPornAsrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskPornOcrResult(AbstractModel):
    """内容审核 Ocr 文字鉴黄任务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 内容审核 Ocr 文字鉴黄任务输入。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiReviewPornOcrTaskInput`
        :param _Output: 内容审核 Ocr 文字鉴黄任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiReviewPornOcrTaskOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewPornOcrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewPornOcrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskPornResult(AbstractModel):
    """内容审核鉴黄任务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 内容审核鉴黄任务输入。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiReviewPornTaskInput`
        :param _Output: 内容审核鉴黄任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiReviewPornTaskOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewPornTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewPornTaskOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskProhibitedAsrResult(AbstractModel):
    """内容审核 Asr 文字鉴任违禁务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 内容审核 Asr 文字鉴违禁任务输入。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiReviewProhibitedAsrTaskInput`
        :param _Output: 内容审核 Asr 文字鉴违禁任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiReviewProhibitedAsrTaskOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewProhibitedAsrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewProhibitedAsrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskProhibitedOcrResult(AbstractModel):
    """内容审核 Ocr 文字鉴任违禁务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 内容审核 Ocr 文字鉴违禁任务输入。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiReviewProhibitedOcrTaskInput`
        :param _Output: 内容审核 Ocr 文字鉴违禁任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiReviewProhibitedOcrTaskOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewProhibitedOcrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewProhibitedOcrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskTerrorismOcrResult(AbstractModel):
    """内容审核 Ocr 文字敏感任务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 内容审核 Ocr 文字敏感任务输入。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiReviewTerrorismOcrTaskInput`
        :param _Output: 内容审核 Ocr 文字敏感任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiReviewTerrorismOcrTaskOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewTerrorismOcrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewTerrorismOcrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskTerrorismResult(AbstractModel):
    """内容审核涉敏任务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 内容审核涉敏任务输入。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiReviewTerrorismTaskInput`
        :param _Output: 内容审核涉敏任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiReviewTerrorismTaskOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewTerrorismTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewTerrorismTaskOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTerrorismOcrTaskInput(AbstractModel):
    """内容审核 Ocr 文字敏感任务输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTerrorismOcrTaskOutput(AbstractModel):
    """Ocr 文字涉敏信息

    """

    def __init__(self):
        r"""
        :param _Confidence: Ocr 文字涉敏评分，分值为0到100。
        :type Confidence: float
        :param _Suggestion: Ocr 文字涉敏结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :type Suggestion: str
        :param _SegmentSet: Ocr 文字有涉敏嫌疑的视频片段列表。
        :type SegmentSet: list of MediaContentReviewOcrTextSegmentItem
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewOcrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTerrorismTaskInput(AbstractModel):
    """内容审核涉敏任务输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 模板 ID。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTerrorismTaskOutput(AbstractModel):
    """涉敏信息

    """

    def __init__(self):
        r"""
        :param _Confidence: 视频涉敏评分，分值为0到100。
        :type Confidence: float
        :param _Suggestion: 涉敏结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :type Suggestion: str
        :param _Label: 视频涉敏结果标签，取值范围：
<li>guns：武器枪支。</li>
<li>crowd：人群聚集。</li>
<li>police：警察部队。</li>
<li>bloody：血腥画面。</li>
<li>banners：涉敏旗帜。</li>
<li>militant：武装分子。</li>
<li>explosion：爆炸火灾。</li>
<li>terrorists：涉敏人物。</li>
<li>scenario：涉敏画面。</li>
        :type Label: str
        :param _SegmentSet: 有涉敏嫌疑的视频片段列表。
        :type SegmentSet: list of MediaContentReviewSegmentItem
        """
        self._Confidence = None
        self._Suggestion = None
        self._Label = None
        self._SegmentSet = None

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def Label(self):
        return self._Label

    @Label.setter
    def Label(self, Label):
        self._Label = Label

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        self._Label = params.get("Label")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSampleFaceInfo(AbstractModel):
    """AI 样本管理，人脸信息。

    """

    def __init__(self):
        r"""
        :param _FaceId: 人脸图片 ID。
        :type FaceId: str
        :param _Url: 人脸图片地址。
        :type Url: str
        """
        self._FaceId = None
        self._Url = None

    @property
    def FaceId(self):
        return self._FaceId

    @FaceId.setter
    def FaceId(self, FaceId):
        self._FaceId = FaceId

    @property
    def Url(self):
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url


    def _deserialize(self, params):
        self._FaceId = params.get("FaceId")
        self._Url = params.get("Url")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSampleFaceOperation(AbstractModel):
    """AI 样本管理，人脸数据操作。

    """

    def __init__(self):
        r"""
        :param _Type: 操作类型，可选值：add（添加）、delete（删除）、reset（重置）。重置操作将清空该人物已有人脸数据，并添加 FaceContents 指定人脸数据。
        :type Type: str
        :param _FaceIds: 人脸 ID 集合，当 Type为delete 时，该字段必填。
        :type FaceIds: list of str
        :param _FaceContents: 人脸图片 [Base64](https://tools.ietf.org/html/rfc4648) 编码后的字符串集合。
<li>当 Type为add 或 reset 时，该字段必填；</li>
<li>数组长度限制：5 张图片。</li>
注意：图片必须是单人像正面人脸较清晰的照片，像素不低于 200*200。
        :type FaceContents: list of str
        """
        self._Type = None
        self._FaceIds = None
        self._FaceContents = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def FaceIds(self):
        return self._FaceIds

    @FaceIds.setter
    def FaceIds(self, FaceIds):
        self._FaceIds = FaceIds

    @property
    def FaceContents(self):
        return self._FaceContents

    @FaceContents.setter
    def FaceContents(self, FaceContents):
        self._FaceContents = FaceContents


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._FaceIds = params.get("FaceIds")
        self._FaceContents = params.get("FaceContents")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSampleFailFaceInfo(AbstractModel):
    """AI 样本管理，处理失败的人脸信息

    """

    def __init__(self):
        r"""
        :param _Index: 对应入参 FaceContents 中错误图片下标，从 0 开始。
        :type Index: int
        :param _ErrCode: 错误码，取值：
<li>0：成功；</li>
<li>其他：失败。</li>
        :type ErrCode: int
        :param _Message: 错误描述。
        :type Message: str
        """
        self._Index = None
        self._ErrCode = None
        self._Message = None

    @property
    def Index(self):
        return self._Index

    @Index.setter
    def Index(self, Index):
        self._Index = Index

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message


    def _deserialize(self, params):
        self._Index = params.get("Index")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSamplePerson(AbstractModel):
    """AI 样本管理，人物信息。

    """

    def __init__(self):
        r"""
        :param _PersonId: 人物 ID。
        :type PersonId: str
        :param _Name: 人物名称。
        :type Name: str
        :param _Description: 人物描述。
        :type Description: str
        :param _FaceInfoSet: 人脸信息。
        :type FaceInfoSet: list of AiSampleFaceInfo
        :param _TagSet: 人物标签。
        :type TagSet: list of str
        :param _UsageSet: 应用场景。
        :type UsageSet: list of str
        :param _CreateTime: 创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :type CreateTime: str
        :param _UpdateTime: 最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :type UpdateTime: str
        """
        self._PersonId = None
        self._Name = None
        self._Description = None
        self._FaceInfoSet = None
        self._TagSet = None
        self._UsageSet = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def PersonId(self):
        return self._PersonId

    @PersonId.setter
    def PersonId(self, PersonId):
        self._PersonId = PersonId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def FaceInfoSet(self):
        return self._FaceInfoSet

    @FaceInfoSet.setter
    def FaceInfoSet(self, FaceInfoSet):
        self._FaceInfoSet = FaceInfoSet

    @property
    def TagSet(self):
        return self._TagSet

    @TagSet.setter
    def TagSet(self, TagSet):
        self._TagSet = TagSet

    @property
    def UsageSet(self):
        return self._UsageSet

    @UsageSet.setter
    def UsageSet(self, UsageSet):
        self._UsageSet = UsageSet

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._PersonId = params.get("PersonId")
        self._Name = params.get("Name")
        self._Description = params.get("Description")
        if params.get("FaceInfoSet") is not None:
            self._FaceInfoSet = []
            for item in params.get("FaceInfoSet"):
                obj = AiSampleFaceInfo()
                obj._deserialize(item)
                self._FaceInfoSet.append(obj)
        self._TagSet = params.get("TagSet")
        self._UsageSet = params.get("UsageSet")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSampleTagOperation(AbstractModel):
    """AI 样本管理，标签操作。

    """

    def __init__(self):
        r"""
        :param _Type: 操作类型，可选值：add（添加）、delete（删除）、reset（重置）。
        :type Type: str
        :param _Tags: 标签，长度限制：128 个字符。
        :type Tags: list of str
        """
        self._Type = None
        self._Tags = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Tags = params.get("Tags")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSampleWord(AbstractModel):
    """AI 样本管理，关键词输出信息。

    """

    def __init__(self):
        r"""
        :param _Keyword: 关键词。
        :type Keyword: str
        :param _TagSet: 关键词标签。
        :type TagSet: list of str
        :param _UsageSet: 关键词应用场景。
        :type UsageSet: list of str
        :param _CreateTime: 创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :type CreateTime: str
        :param _UpdateTime: 最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :type UpdateTime: str
        """
        self._Keyword = None
        self._TagSet = None
        self._UsageSet = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def Keyword(self):
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword

    @property
    def TagSet(self):
        return self._TagSet

    @TagSet.setter
    def TagSet(self, TagSet):
        self._TagSet = TagSet

    @property
    def UsageSet(self):
        return self._UsageSet

    @UsageSet.setter
    def UsageSet(self, UsageSet):
        self._UsageSet = UsageSet

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._Keyword = params.get("Keyword")
        self._TagSet = params.get("TagSet")
        self._UsageSet = params.get("UsageSet")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSampleWordInfo(AbstractModel):
    """AI 样本管理，关键词输入信息。

    """

    def __init__(self):
        r"""
        :param _Keyword: 关键词，长度限制：20 个字符。
        :type Keyword: str
        :param _Tags: 关键词标签
<li>数组长度限制：20 个标签；</li>
<li>单个标签长度限制：128 个字符。</li>
        :type Tags: list of str
        """
        self._Keyword = None
        self._Tags = None

    @property
    def Keyword(self):
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._Keyword = params.get("Keyword")
        self._Tags = params.get("Tags")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AnimatedGraphicTaskInput(AbstractModel):
    """转动图任务类型。

    """

    def __init__(self):
        r"""
        :param _Definition: 视频转动图模板 ID。
        :type Definition: int
        :param _StartTimeOffset: 动图在视频中的开始时间，单位为秒。
        :type StartTimeOffset: float
        :param _EndTimeOffset: 动图在视频中的结束时间，单位为秒。
        :type EndTimeOffset: float
        :param _OutputStorage: 转动图后文件的目标存储，不填则继承上层的 OutputStorage 值。
注意：此字段可能返回 null，表示取不到有效值。
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _OutputObjectPath: 转动图后文件的输出路径，可以为相对路径或者绝对路径。
若需定义输出路径，路径需以`.{format}`结尾。变量名请参考 [文件名变量说明](https://cloud.tencent.com/document/product/862/37039)。
相对路径示例：
<li>文件名_{变量名}.{format}</li>
<li>文件名.{format}</li>
绝对路径示例：
<li>/自定义路径/文件名_{变量名}.{format}</li>
如果不填，则默认为相对路径：`{inputName}_animatedGraphic_{definition}.{format}`。
        :type OutputObjectPath: str
        """
        self._Definition = None
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._OutputStorage = None
        self._OutputObjectPath = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def StartTimeOffset(self):
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def OutputStorage(self):
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage

    @property
    def OutputObjectPath(self):
        return self._OutputObjectPath

    @OutputObjectPath.setter
    def OutputObjectPath(self, OutputObjectPath):
        self._OutputObjectPath = OutputObjectPath


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        self._OutputObjectPath = params.get("OutputObjectPath")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AnimatedGraphicsTemplate(AbstractModel):
    """转动图模板详情。

    """

    def __init__(self):
        r"""
        :param _Definition: 转动图模板唯一标识。
        :type Definition: int
        :param _Type: 模板类型，取值范围：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :type Type: str
        :param _Name: 转动图模板名称。
        :type Name: str
        :param _Comment: 转动图模板描述。
        :type Comment: str
        :param _Width: 动图宽度（或长边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :type Width: int
        :param _Height: 动图高度（或短边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :type Height: int
        :param _ResolutionAdaptive: 分辨率自适应，可选值：
<li>open：开启，此时，Width 代表视频的长边，Height 表示视频的短边；</li>
<li>close：关闭，此时，Width 代表视频的宽度，Height 表示视频的高度。</li>
默认值：open。
        :type ResolutionAdaptive: str
        :param _Format: 动图格式。
        :type Format: str
        :param _Fps: 帧率。
        :type Fps: int
        :param _Quality: 图片质量。
        :type Quality: float
        :param _CreateTime: 模板创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :type CreateTime: str
        :param _UpdateTime: 模板最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :type UpdateTime: str
        """
        self._Definition = None
        self._Type = None
        self._Name = None
        self._Comment = None
        self._Width = None
        self._Height = None
        self._ResolutionAdaptive = None
        self._Format = None
        self._Fps = None
        self._Quality = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ResolutionAdaptive(self):
        return self._ResolutionAdaptive

    @ResolutionAdaptive.setter
    def ResolutionAdaptive(self, ResolutionAdaptive):
        self._ResolutionAdaptive = ResolutionAdaptive

    @property
    def Format(self):
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def Fps(self):
        return self._Fps

    @Fps.setter
    def Fps(self, Fps):
        self._Fps = Fps

    @property
    def Quality(self):
        return self._Quality

    @Quality.setter
    def Quality(self, Quality):
        self._Quality = Quality

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._ResolutionAdaptive = params.get("ResolutionAdaptive")
        self._Format = params.get("Format")
        self._Fps = params.get("Fps")
        self._Quality = params.get("Quality")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ArtifactRepairConfig(AbstractModel):
    """去伪影（毛刺）配置

    """

    def __init__(self):
        r"""
        :param _Switch: 能力配置开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
默认值：ON。
        :type Switch: str
        :param _Type: 类型，可选值：
<li>weak</li>
<li>strong</li>
默认值：weak。
注意：此字段可能返回 null，表示取不到有效值。
        :type Type: str
        """
        self._Switch = None
        self._Type = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AsrFullTextConfigureInfo(AbstractModel):
    """语音全文识别任务控制参数

    """

    def __init__(self):
        r"""
        :param _Switch: 语音全文识别任务开关，可选值：
<li>ON：开启智能语音全文识别任务；</li>
<li>OFF：关闭智能语音全文识别任务。</li>
        :type Switch: str
        :param _SubtitleFormat: 生成的字幕文件格式，不填或者填空字符串表示不生成字幕文件，可选值：
<li>vtt：生成 WebVTT 字幕文件。</li>
        :type SubtitleFormat: str
        :param _SourceLanguage: 视频源语言。
        :type SourceLanguage: str
        """
        self._Switch = None
        self._SubtitleFormat = None
        self._SourceLanguage = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def SubtitleFormat(self):
        return self._SubtitleFormat

    @SubtitleFormat.setter
    def SubtitleFormat(self, SubtitleFormat):
        self._SubtitleFormat = SubtitleFormat

    @property
    def SourceLanguage(self):
        return self._SourceLanguage

    @SourceLanguage.setter
    def SourceLanguage(self, SourceLanguage):
        self._SourceLanguage = SourceLanguage


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._SubtitleFormat = params.get("SubtitleFormat")
        self._SourceLanguage = params.get("SourceLanguage")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AsrFullTextConfigureInfoForUpdate(AbstractModel):
    """语音全文识别任务控制参数

    """

    def __init__(self):
        r"""
        :param _Switch: 语音全文识别任务开关，可选值：
<li>ON：开启智能语音全文识别任务；</li>
<li>OFF：关闭智能语音全文识别任务。</li>
        :type Switch: str
        :param _SubtitleFormat: 生成的字幕文件格式，填空字符串表示不生成字幕文件，可选值：
<li>vtt：生成 WebVTT 字幕文件。</li>
        :type SubtitleFormat: str
        :param _SourceLanguage: 视频源语言。
        :type SourceLanguage: str
        """
        self._Switch = None
        self._SubtitleFormat = None
        self._SourceLanguage = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def SubtitleFormat(self):
        return self._SubtitleFormat

    @SubtitleFormat.setter
    def SubtitleFormat(self, SubtitleFormat):
        self._SubtitleFormat = SubtitleFormat

    @property
    def SourceLanguage(self):
        return self._SourceLanguage

    @SourceLanguage.setter
    def SourceLanguage(self, SourceLanguage):
        self._SourceLanguage = SourceLanguage


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._SubtitleFormat = params.get("SubtitleFormat")
        self._SourceLanguage = params.get("SourceLanguage")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AsrWordsConfigureInfo(AbstractModel):
    """语音关键词识别控制参数。

    """

    def __init__(self):
        r"""
        :param _Switch: 语音关键词识别任务开关，可选值：
<li>ON：开启语音关键词识别任务；</li>
<li>OFF：关闭语音关键词识别任务。</li>
        :type Switch: str
        :param _LabelSet: 关键词过滤标签，指定需要返回的关键词的标签。如果未填或者为空，则全部结果都返回。
标签个数最多 10 个，每个标签长度最多 16 个字符。
        :type LabelSet: list of str
        """
        self._Switch = None
        self._LabelSet = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def LabelSet(self):
        return self._LabelSet

    @LabelSet.setter
    def LabelSet(self, LabelSet):
        self._LabelSet = LabelSet


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._LabelSet = params.get("LabelSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AsrWordsConfigureInfoForUpdate(AbstractModel):
    """语音关键词识别控制参数。

    """

    def __init__(self):
        r"""
        :param _Switch: 语音关键词识别任务开关，可选值：
<li>ON：开启语音关键词识别任务；</li>
<li>OFF：关闭语音关键词识别任务。</li>
        :type Switch: str
        :param _LabelSet: 关键词过滤标签，指定需要返回的关键词的标签。如果未填或者为空，则全部结果都返回。
标签个数最多 10 个，每个标签长度最多 16 个字符。
        :type LabelSet: list of str
        """
        self._Switch = None
        self._LabelSet = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def LabelSet(self):
        return self._LabelSet

    @LabelSet.setter
    def LabelSet(self, LabelSet):
        self._LabelSet = LabelSet


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._LabelSet = params.get("LabelSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioBeautifyConfig(AbstractModel):
    """音量美化配置

    """

    def __init__(self):
        r"""
        :param _Switch: 能力配置开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
默认值：ON。
        :type Switch: str
        :param _Types: 类型，可多选，可选值：
<li>declick：杂音去除</li>
<li>deesser：齿音压制</li>
默认值：declick。
注意：此字段可能返回 null，表示取不到有效值。
        :type Types: list of str
        """
        self._Switch = None
        self._Types = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Types(self):
        return self._Types

    @Types.setter
    def Types(self, Types):
        self._Types = Types


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Types = params.get("Types")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioDenoiseConfig(AbstractModel):
    """音频降噪配置

    """

    def __init__(self):
        r"""
        :param _Switch: 能力配置开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
默认值：ON。
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioEnhanceConfig(AbstractModel):
    """音频增强配置

    """

    def __init__(self):
        r"""
        :param _Denoise: 音频降噪配置。
注意：此字段可能返回 null，表示取不到有效值。
        :type Denoise: :class:`tencentcloud.mps.v20190612.models.AudioDenoiseConfig`
        :param _Separate: 音频分离配置。
注意：此字段可能返回 null，表示取不到有效值。
        :type Separate: :class:`tencentcloud.mps.v20190612.models.AudioSeparateConfig`
        :param _VolumeBalance: 音量均衡配置。
注意：此字段可能返回 null，表示取不到有效值。
        :type VolumeBalance: :class:`tencentcloud.mps.v20190612.models.VolumeBalanceConfig`
        :param _Beautify: 音频美化配置。
注意：此字段可能返回 null，表示取不到有效值。
        :type Beautify: :class:`tencentcloud.mps.v20190612.models.AudioBeautifyConfig`
        """
        self._Denoise = None
        self._Separate = None
        self._VolumeBalance = None
        self._Beautify = None

    @property
    def Denoise(self):
        return self._Denoise

    @Denoise.setter
    def Denoise(self, Denoise):
        self._Denoise = Denoise

    @property
    def Separate(self):
        return self._Separate

    @Separate.setter
    def Separate(self, Separate):
        self._Separate = Separate

    @property
    def VolumeBalance(self):
        return self._VolumeBalance

    @VolumeBalance.setter
    def VolumeBalance(self, VolumeBalance):
        self._VolumeBalance = VolumeBalance

    @property
    def Beautify(self):
        return self._Beautify

    @Beautify.setter
    def Beautify(self, Beautify):
        self._Beautify = Beautify


    def _deserialize(self, params):
        if params.get("Denoise") is not None:
            self._Denoise = AudioDenoiseConfig()
            self._Denoise._deserialize(params.get("Denoise"))
        if params.get("Separate") is not None:
            self._Separate = AudioSeparateConfig()
            self._Separate._deserialize(params.get("Separate"))
        if params.get("VolumeBalance") is not None:
            self._VolumeBalance = VolumeBalanceConfig()
            self._VolumeBalance._deserialize(params.get("VolumeBalance"))
        if params.get("Beautify") is not None:
            self._Beautify = AudioBeautifyConfig()
            self._Beautify._deserialize(params.get("Beautify"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioSeparateConfig(AbstractModel):
    """音频分离配置

    """

    def __init__(self):
        r"""
        :param _Switch: 能力配置开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
默认值：ON。
        :type Switch: str
        :param _Type: 场景类型，可选值：
<li>normal：人声背景声场景</li>
<li>music：演唱伴奏场景</li>
默认值：normal。
注意：此字段可能返回 null，表示取不到有效值。
        :type Type: str
        :param _Track: 输出音轨，可选值：
<li>vocal：输出人声</li>
<li>background：应用场景为normal时输出背景声，应用场景为music时输出伴奏</li>
默认值：vocal。
注意：此字段可能返回 null，表示取不到有效值。
        :type Track: str
        """
        self._Switch = None
        self._Type = None
        self._Track = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Track(self):
        return self._Track

    @Track.setter
    def Track(self, Track):
        self._Track = Track


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Type = params.get("Type")
        self._Track = params.get("Track")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioTemplateInfo(AbstractModel):
    """音频流配置参数

    """

    def __init__(self):
        r"""
        :param _Codec: 音频流的编码格式。
当不需要对音频进行转码时，可选值为：
<li>copy。</li>
当外层参数 Container 为 mp3 时，可选值为：
<li>mp3。</li>
当外层参数 Container 为 ogg 或 flac 时，可选值为：
<li>flac。</li>
当外层参数 Container 为 m4a 时，可选值为：
<li>aac；</li>
<li>ac3。</li>
当外层参数 Container 为 mp4 或 flv 时，可选值为：
<li>aac：更适合 mp4；</li>
<li>mp3：更适合 flv；</li>
<li>mp2。</li>
当外层参数 Container 为 hls 时，可选值为：
<li>aac；</li>
<li>mp3。</li>
        :type Codec: str
        :param _Bitrate: 音频流的码率，取值范围：0 和 [26, 256]，单位：kbps。
当取值为 0，表示音频码率和原始音频保持一致。
        :type Bitrate: int
        :param _SampleRate: 音频流的采样率，可选值：
<li>32000</li>
<li>44100</li>
<li>48000</li>
单位：Hz。
        :type SampleRate: int
        :param _AudioChannel: 音频通道方式，可选值：
<li>1：单通道</li>
<li>2：双通道</li>
<li>6：5.1声道</li>
当媒体的封装格式是音频格式时（flac，ogg，mp3，m4a）时，声道数不允许设为5.1声道。
默认值：2。
        :type AudioChannel: int
        """
        self._Codec = None
        self._Bitrate = None
        self._SampleRate = None
        self._AudioChannel = None

    @property
    def Codec(self):
        return self._Codec

    @Codec.setter
    def Codec(self, Codec):
        self._Codec = Codec

    @property
    def Bitrate(self):
        return self._Bitrate

    @Bitrate.setter
    def Bitrate(self, Bitrate):
        self._Bitrate = Bitrate

    @property
    def SampleRate(self):
        return self._SampleRate

    @SampleRate.setter
    def SampleRate(self, SampleRate):
        self._SampleRate = SampleRate

    @property
    def AudioChannel(self):
        return self._AudioChannel

    @AudioChannel.setter
    def AudioChannel(self, AudioChannel):
        self._AudioChannel = AudioChannel


    def _deserialize(self, params):
        self._Codec = params.get("Codec")
        self._Bitrate = params.get("Bitrate")
        self._SampleRate = params.get("SampleRate")
        self._AudioChannel = params.get("AudioChannel")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioTemplateInfoForUpdate(AbstractModel):
    """音频流配置参数

    """

    def __init__(self):
        r"""
        :param _Codec: 音频流的编码格式。
当不需要对音频进行转码时，可选值为：
<li>copy。</li>
当外层参数 Container 为 mp3 时，可选值为：
<li>mp3。</li>
当外层参数 Container 为 ogg 或 flac 时，可选值为：
<li>flac。</li>
当外层参数 Container 为 m4a 时，可选值为：
<li>aac；</li>
<li>ac3。</li>
当外层参数 Container 为 mp4 或 flv 时，可选值为：
<li>aac：更适合 mp4；</li>
<li>mp3：更适合 flv；</li>
<li>mp2。</li>
当外层参数 Container 为 hls 时，可选值为：
<li>aac；</li>
<li>mp3。</li>
注意：此字段可能返回 null，表示取不到有效值。
        :type Codec: str
        :param _Bitrate: 音频流的码率，取值范围：0 和 [26, 256]，单位：kbps。 当取值为 0，表示音频码率和原始音频保持一致。
注意：此字段可能返回 null，表示取不到有效值。
        :type Bitrate: int
        :param _SampleRate: 音频流的采样率，可选值：
<li>32000</li>
<li>44100</li>
<li>48000</li>
单位：Hz。
注意：此字段可能返回 null，表示取不到有效值。
        :type SampleRate: int
        :param _AudioChannel: 音频通道方式，可选值：
<li>1：单通道</li>
<li>2：双通道</li>
<li>6：5.1声道</li>
当媒体的封装格式是音频格式时（flac，ogg，mp3，m4a）时，声道数不允许设为5.1声道。
注意：此字段可能返回 null，表示取不到有效值。
        :type AudioChannel: int
        :param _StreamSelects: 指定输出要保留的音频轨道。默认是全部保留源的。
注意：此字段可能返回 null，表示取不到有效值。
        :type StreamSelects: list of int
        """
        self._Codec = None
        self._Bitrate = None
        self._SampleRate = None
        self._AudioChannel = None
        self._StreamSelects = None

    @property
    def Codec(self):
        return self._Codec

    @Codec.setter
    def Codec(self, Codec):
        self._Codec = Codec

    @property
    def Bitrate(self):
        return self._Bitrate

    @Bitrate.setter
    def Bitrate(self, Bitrate):
        self._Bitrate = Bitrate

    @property
    def SampleRate(self):
        return self._SampleRate

    @SampleRate.setter
    def SampleRate(self, SampleRate):
        self._SampleRate = SampleRate

    @property
    def AudioChannel(self):
        return self._AudioChannel

    @AudioChannel.setter
    def AudioChannel(self, AudioChannel):
        self._AudioChannel = AudioChannel

    @property
    def StreamSelects(self):
        return self._StreamSelects

    @StreamSelects.setter
    def StreamSelects(self, StreamSelects):
        self._StreamSelects = StreamSelects


    def _deserialize(self, params):
        self._Codec = params.get("Codec")
        self._Bitrate = params.get("Bitrate")
        self._SampleRate = params.get("SampleRate")
        self._AudioChannel = params.get("AudioChannel")
        self._StreamSelects = params.get("StreamSelects")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AwsS3FileUploadTrigger(AbstractModel):
    """AWS S3 文件是上传触发器。

    """

    def __init__(self):
        r"""
        :param _S3Bucket: 绑定的 AWS S3 存储桶。
        :type S3Bucket: str
        :param _S3Region: 绑定的桶所在 AWS 区域，目前支持：  
us-east-1  
eu-west-3
        :type S3Region: str
        :param _Dir: 绑定的输入路径目录，必须为绝对路径，即以 `/` 开头和结尾。如`/movie/201907/`，不填代表根目录`/`。	
        :type Dir: str
        :param _Formats: 允许触发的文件格式列表，如 ["mp4", "flv", "mov"]。不填代表所有格式的文件都可以触发工作流。	
        :type Formats: list of str
        :param _S3SecretId: 绑定的 AWS S3 存储桶的秘钥ID。
注意：此字段可能返回 null，表示取不到有效值。
        :type S3SecretId: str
        :param _S3SecretKey: 绑定的 AWS S3 存储桶的秘钥Key。
注意：此字段可能返回 null，表示取不到有效值。
        :type S3SecretKey: str
        :param _AwsSQS: 绑定的 AWS S3 存储桶对应的 SQS事件队列。
注意：队列和桶需要在同一区域。
注意：此字段可能返回 null，表示取不到有效值。
        :type AwsSQS: :class:`tencentcloud.mps.v20190612.models.AwsSQS`
        """
        self._S3Bucket = None
        self._S3Region = None
        self._Dir = None
        self._Formats = None
        self._S3SecretId = None
        self._S3SecretKey = None
        self._AwsSQS = None

    @property
    def S3Bucket(self):
        return self._S3Bucket

    @S3Bucket.setter
    def S3Bucket(self, S3Bucket):
        self._S3Bucket = S3Bucket

    @property
    def S3Region(self):
        return self._S3Region

    @S3Region.setter
    def S3Region(self, S3Region):
        self._S3Region = S3Region

    @property
    def Dir(self):
        return self._Dir

    @Dir.setter
    def Dir(self, Dir):
        self._Dir = Dir

    @property
    def Formats(self):
        return self._Formats

    @Formats.setter
    def Formats(self, Formats):
        self._Formats = Formats

    @property
    def S3SecretId(self):
        return self._S3SecretId

    @S3SecretId.setter
    def S3SecretId(self, S3SecretId):
        self._S3SecretId = S3SecretId

    @property
    def S3SecretKey(self):
        return self._S3SecretKey

    @S3SecretKey.setter
    def S3SecretKey(self, S3SecretKey):
        self._S3SecretKey = S3SecretKey

    @property
    def AwsSQS(self):
        return self._AwsSQS

    @AwsSQS.setter
    def AwsSQS(self, AwsSQS):
        self._AwsSQS = AwsSQS


    def _deserialize(self, params):
        self._S3Bucket = params.get("S3Bucket")
        self._S3Region = params.get("S3Region")
        self._Dir = params.get("Dir")
        self._Formats = params.get("Formats")
        self._S3SecretId = params.get("S3SecretId")
        self._S3SecretKey = params.get("S3SecretKey")
        if params.get("AwsSQS") is not None:
            self._AwsSQS = AwsSQS()
            self._AwsSQS._deserialize(params.get("AwsSQS"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AwsSQS(AbstractModel):
    """Aws SQS 队列信息

    """

    def __init__(self):
        r"""
        :param _SQSRegion: SQS 队列区域。
注意：此字段可能返回 null，表示取不到有效值。
        :type SQSRegion: str
        :param _SQSQueueName: SQS 队列名称。
注意：此字段可能返回 null，表示取不到有效值。
        :type SQSQueueName: str
        :param _S3SecretId: 读写SQS的秘钥id。
注意：此字段可能返回 null，表示取不到有效值。
        :type S3SecretId: str
        :param _S3SecretKey: 读写SQS的秘钥key。
注意：此字段可能返回 null，表示取不到有效值。
        :type S3SecretKey: str
        """
        self._SQSRegion = None
        self._SQSQueueName = None
        self._S3SecretId = None
        self._S3SecretKey = None

    @property
    def SQSRegion(self):
        return self._SQSRegion

    @SQSRegion.setter
    def SQSRegion(self, SQSRegion):
        self._SQSRegion = SQSRegion

    @property
    def SQSQueueName(self):
        return self._SQSQueueName

    @SQSQueueName.setter
    def SQSQueueName(self, SQSQueueName):
        self._SQSQueueName = SQSQueueName

    @property
    def S3SecretId(self):
        return self._S3SecretId

    @S3SecretId.setter
    def S3SecretId(self, S3SecretId):
        self._S3SecretId = S3SecretId

    @property
    def S3SecretKey(self):
        return self._S3SecretKey

    @S3SecretKey.setter
    def S3SecretKey(self, S3SecretKey):
        self._S3SecretKey = S3SecretKey


    def _deserialize(self, params):
        self._SQSRegion = params.get("SQSRegion")
        self._SQSQueueName = params.get("SQSQueueName")
        self._S3SecretId = params.get("S3SecretId")
        self._S3SecretKey = params.get("S3SecretKey")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchDeleteStreamLinkFlowRequest(AbstractModel):
    """BatchDeleteStreamLinkFlow请求参数结构体

    """

    def __init__(self):
        r"""
        :param _EventId: EventId。
        :type EventId: str
        :param _FlowIds: Event关联的流Id数组，如果不传默认删除Event下面的所有媒体传输流。
        :type FlowIds: list of str
        """
        self._EventId = None
        self._FlowIds = None

    @property
    def EventId(self):
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId

    @property
    def FlowIds(self):
        return self._FlowIds

    @FlowIds.setter
    def FlowIds(self, FlowIds):
        self._FlowIds = FlowIds


    def _deserialize(self, params):
        self._EventId = params.get("EventId")
        self._FlowIds = params.get("FlowIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchDeleteStreamLinkFlowResponse(AbstractModel):
    """BatchDeleteStreamLinkFlow返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class BatchStartStreamLinkFlowRequest(AbstractModel):
    """BatchStartStreamLinkFlow请求参数结构体

    """

    def __init__(self):
        r"""
        :param _EventId: EventId。
        :type EventId: str
        :param _FlowIds: Event关联的流Id数组，如果不传默认启动Event下面的所有媒体传输流。
        :type FlowIds: list of str
        """
        self._EventId = None
        self._FlowIds = None

    @property
    def EventId(self):
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId

    @property
    def FlowIds(self):
        return self._FlowIds

    @FlowIds.setter
    def FlowIds(self, FlowIds):
        self._FlowIds = FlowIds


    def _deserialize(self, params):
        self._EventId = params.get("EventId")
        self._FlowIds = params.get("FlowIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchStartStreamLinkFlowResponse(AbstractModel):
    """BatchStartStreamLinkFlow返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class BatchStopStreamLinkFlowRequest(AbstractModel):
    """BatchStopStreamLinkFlow请求参数结构体

    """

    def __init__(self):
        r"""
        :param _EventId: EventId。
        :type EventId: str
        :param _FlowIds: 流Id，如果不传默认停止Event下所有的媒体传输流。
        :type FlowIds: list of str
        """
        self._EventId = None
        self._FlowIds = None

    @property
    def EventId(self):
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId

    @property
    def FlowIds(self):
        return self._FlowIds

    @FlowIds.setter
    def FlowIds(self, FlowIds):
        self._FlowIds = FlowIds


    def _deserialize(self, params):
        self._EventId = params.get("EventId")
        self._FlowIds = params.get("FlowIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchStopStreamLinkFlowResponse(AbstractModel):
    """BatchStopStreamLinkFlow返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ClassificationConfigureInfo(AbstractModel):
    """智能分类任务控制参数

    """

    def __init__(self):
        r"""
        :param _Switch: 智能分类任务开关，可选值：
<li>ON：开启智能分类任务；</li>
<li>OFF：关闭智能分类任务。</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClassificationConfigureInfoForUpdate(AbstractModel):
    """智能分类任务控制参数

    """

    def __init__(self):
        r"""
        :param _Switch: 智能分类任务开关，可选值：
<li>ON：开启智能分类任务；</li>
<li>OFF：关闭智能分类任务。</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ColorEnhanceConfig(AbstractModel):
    """色彩增强配置

    """

    def __init__(self):
        r"""
        :param _Switch: 能力配置开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
默认值：ON。
        :type Switch: str
        :param _Type: 类型，可选值：
<li>weak</li>
<li>normal</li>
<li>strong</li>
默认值：weak。
注意：此字段可能返回 null，表示取不到有效值。
        :type Type: str
        """
        self._Switch = None
        self._Type = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeAudioItem(AbstractModel):
    """视频编辑/合成任务 音频元素信息。

    """

    def __init__(self):
        r"""
        :param _SourceMedia: 元素对应媒体信息。
        :type SourceMedia: :class:`tencentcloud.mps.v20190612.models.ComposeSourceMedia`
        :param _TrackTime: 元素在轨道时间轴上的时间信息，不填则紧跟上一个元素。
        :type TrackTime: :class:`tencentcloud.mps.v20190612.models.ComposeTrackTime`
        :param _AudioOperations: 对音频进行操作，如静音等。
        :type AudioOperations: list of ComposeAudioOperation
        """
        self._SourceMedia = None
        self._TrackTime = None
        self._AudioOperations = None

    @property
    def SourceMedia(self):
        return self._SourceMedia

    @SourceMedia.setter
    def SourceMedia(self, SourceMedia):
        self._SourceMedia = SourceMedia

    @property
    def TrackTime(self):
        return self._TrackTime

    @TrackTime.setter
    def TrackTime(self, TrackTime):
        self._TrackTime = TrackTime

    @property
    def AudioOperations(self):
        return self._AudioOperations

    @AudioOperations.setter
    def AudioOperations(self, AudioOperations):
        self._AudioOperations = AudioOperations


    def _deserialize(self, params):
        if params.get("SourceMedia") is not None:
            self._SourceMedia = ComposeSourceMedia()
            self._SourceMedia._deserialize(params.get("SourceMedia"))
        if params.get("TrackTime") is not None:
            self._TrackTime = ComposeTrackTime()
            self._TrackTime._deserialize(params.get("TrackTime"))
        if params.get("AudioOperations") is not None:
            self._AudioOperations = []
            for item in params.get("AudioOperations"):
                obj = ComposeAudioOperation()
                obj._deserialize(item)
                self._AudioOperations.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeAudioOperation(AbstractModel):
    """视频编辑/合成任务 音频操作。

    """

    def __init__(self):
        r"""
        :param _Type: 音频操作类型，取值有：
<li>Volume：音量调节。</li>
        :type Type: str
        :param _Volume:  当 Type = Volume 时有效。音量调节参数，取值范围: 0~5。 
<li>0 表示静音。</li>
<li>小于1 表示降低音量。</li>
<li>1 表示不变。</li>
<li>大于1表示升高音量。</li>
        :type Volume: float
        """
        self._Type = None
        self._Volume = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Volume(self):
        return self._Volume

    @Volume.setter
    def Volume(self, Volume):
        self._Volume = Volume


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Volume = params.get("Volume")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeAudioStream(AbstractModel):
    """视频编辑/合成任务 音频流信息。

    """

    def __init__(self):
        r"""
        :param _Codec: 音频流的编码方式，可选值：
<li>AAC：AAC 编码（默认），用于容器为 mp4。</li>
<li>MP3：mp3 编码，用于容器为 mp3。</li>
        :type Codec: str
        :param _SampleRate: 音频流的采样率，单位：Hz，可选值：
<li>16000（默认）</li>
<li>32000</li>
<li>44100</li>
<li>48000</li>
        :type SampleRate: int
        :param _AudioChannel: 声道数，可选值：
<li>1：单声道 。</li>
<li>2：双声道（默认）。</li>
        :type AudioChannel: int
        :param _Bitrate: 参考码率，单位 kbps，范围：26~10000。
如果设置，编码时会尽量按该码率进行编码。
如果不设置，服务将根据音频参数自动采用合适的码率。
        :type Bitrate: int
        """
        self._Codec = None
        self._SampleRate = None
        self._AudioChannel = None
        self._Bitrate = None

    @property
    def Codec(self):
        return self._Codec

    @Codec.setter
    def Codec(self, Codec):
        self._Codec = Codec

    @property
    def SampleRate(self):
        return self._SampleRate

    @SampleRate.setter
    def SampleRate(self, SampleRate):
        self._SampleRate = SampleRate

    @property
    def AudioChannel(self):
        return self._AudioChannel

    @AudioChannel.setter
    def AudioChannel(self, AudioChannel):
        self._AudioChannel = AudioChannel

    @property
    def Bitrate(self):
        return self._Bitrate

    @Bitrate.setter
    def Bitrate(self, Bitrate):
        self._Bitrate = Bitrate


    def _deserialize(self, params):
        self._Codec = params.get("Codec")
        self._SampleRate = params.get("SampleRate")
        self._AudioChannel = params.get("AudioChannel")
        self._Bitrate = params.get("Bitrate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeCanvas(AbstractModel):
    """视频编辑/合成任务画布信息。

    """

    def __init__(self):
        r"""
        :param _Color: 背景颜色对应的 RGB 参考值，取值格式： #RRGGBB，如 #F0F0F0 。 
默认值：#000000（黑色）。
        :type Color: str
        :param _Width: 画布宽度，即输出视频的宽度，取值范围：0~ 3840，单位：px。  
默认值：0，表示和第一个视频宽度一致。
        :type Width: int
        :param _Height: 画布高度，即输出视频的高度，取值范围：0~ 3840，单位：px。  
默认值：0，表示和第一个视频高度一致。
        :type Height: int
        """
        self._Color = None
        self._Width = None
        self._Height = None

    @property
    def Color(self):
        return self._Color

    @Color.setter
    def Color(self, Color):
        self._Color = Color

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height


    def _deserialize(self, params):
        self._Color = params.get("Color")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeEmptyItem(AbstractModel):
    """视频编辑/合成任务 空白占位元素信息。

    """

    def __init__(self):
        r"""
        :param _Duration: 元素时长，时间支持：
<li>以 s 结尾，表示时间点单位为秒，如 3.5s 表示时间点为第3.5秒。</li>
        :type Duration: str
        """
        self._Duration = None

    @property
    def Duration(self):
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration


    def _deserialize(self, params):
        self._Duration = params.get("Duration")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeImageItem(AbstractModel):
    """视频编辑/合成任务 图片元素信息。

    """

    def __init__(self):
        r"""
        :param _SourceMedia: 元素对应媒体信息。
        :type SourceMedia: :class:`tencentcloud.mps.v20190612.models.ComposeSourceMedia`
        :param _TrackTime: 元素在轨道时间轴上的时间信息，不填则紧跟上一个元素。
        :type TrackTime: :class:`tencentcloud.mps.v20190612.models.ComposeTrackTime`
        :param _XPos: 元素中心点距离画布原点的水平位置。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示元素 XPos 为画布宽度指定百分比的位置，如 10% 表示 XPos 为画布宽度的 10%。</li>
<li>当字符串以 px 结尾，表示元素 XPos 单位为像素，如 100px 表示 XPos 为100像素。</li>
默认：50%。
        :type XPos: str
        :param _YPos: 元素中心点距离画布原点的垂直位置。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示元素 YPos 为画布高度指定百分比的位置，如 10% 表示 YPos 为画布高度的 10%。</li>
<li>当字符串以 px 结尾，表示元素 YPos 单位为像素，如 100px 表示 YPos 为100像素。</li>
默认：50%。
        :type YPos: str
        :param _Width: 视频片段的宽度。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示元素 Width 为画布宽度的百分比大小，如 10% 表示 Width 为画布宽度的 10%。</li>
<li>当字符串以 px 结尾，表示元素 Width 单位为像素，如 100px 表示 Width 为100像素。</li>
为空（或0） 的场景：
<li>当 Width、Height 均为空，则 Width 和 Height 取源素材本身的 Width、Height。</li>
<li>当 Width 为空，Height 非空，则 Width 按源素材比例缩放。</li>
<li>当 Width 非空，Height 为空，则 Height 按源素材比例缩放。</li>
        :type Width: str
        :param _Height: 元素的高度。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示元素 Height 为画布高度的百分比大小，如 10% 表示 Height 为画布高度的 10%。</li>
<li>当字符串以 px 结尾，表示元素 Height 单位为像素，如 100px 表示 Height 为100像素。</li>
为空（或0） 的场景：
<li>当 Width、Height 均为空，则 Width 和 Height 取源素材本身的 Width、Height。</li>
<li>当 Width 为空，Height 非空，则 Width 按源素材比例缩放。</li>
<li>当 Width 非空，Height 为空，则 Height 按源素材比例缩放。</li>
        :type Height: str
        :param _ImageOperations: 对图像画面进行的操作，如图像旋转等。
        :type ImageOperations: list of ComposeImageOperation
        """
        self._SourceMedia = None
        self._TrackTime = None
        self._XPos = None
        self._YPos = None
        self._Width = None
        self._Height = None
        self._ImageOperations = None

    @property
    def SourceMedia(self):
        return self._SourceMedia

    @SourceMedia.setter
    def SourceMedia(self, SourceMedia):
        self._SourceMedia = SourceMedia

    @property
    def TrackTime(self):
        return self._TrackTime

    @TrackTime.setter
    def TrackTime(self, TrackTime):
        self._TrackTime = TrackTime

    @property
    def XPos(self):
        return self._XPos

    @XPos.setter
    def XPos(self, XPos):
        self._XPos = XPos

    @property
    def YPos(self):
        return self._YPos

    @YPos.setter
    def YPos(self, YPos):
        self._YPos = YPos

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ImageOperations(self):
        return self._ImageOperations

    @ImageOperations.setter
    def ImageOperations(self, ImageOperations):
        self._ImageOperations = ImageOperations


    def _deserialize(self, params):
        if params.get("SourceMedia") is not None:
            self._SourceMedia = ComposeSourceMedia()
            self._SourceMedia._deserialize(params.get("SourceMedia"))
        if params.get("TrackTime") is not None:
            self._TrackTime = ComposeTrackTime()
            self._TrackTime._deserialize(params.get("TrackTime"))
        self._XPos = params.get("XPos")
        self._YPos = params.get("YPos")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        if params.get("ImageOperations") is not None:
            self._ImageOperations = []
            for item in params.get("ImageOperations"):
                obj = ComposeImageOperation()
                obj._deserialize(item)
                self._ImageOperations.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeImageOperation(AbstractModel):
    """视频编辑/合成任务 视频图像转换操作。

    """

    def __init__(self):
        r"""
        :param _Type: 类型，取值有：
<li>Rotate：图像旋转。</li>
<li>Flip：图像翻转。</li>
        :type Type: str
        :param _RotateAngle: 当 Type = Rotate 时有效。图像以中心点为原点进行旋转的角度，取值范围0~360。
        :type RotateAngle: float
        :param _FlipType: 当 Type = Flip 时有效。图像翻转动作，取值有： 
<li>Horizental：水平翻转，即左右镜像。</li>
<li>Vertical：垂直翻转，即上下镜像。</li>
        :type FlipType: str
        """
        self._Type = None
        self._RotateAngle = None
        self._FlipType = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def RotateAngle(self):
        return self._RotateAngle

    @RotateAngle.setter
    def RotateAngle(self, RotateAngle):
        self._RotateAngle = RotateAngle

    @property
    def FlipType(self):
        return self._FlipType

    @FlipType.setter
    def FlipType(self, FlipType):
        self._FlipType = FlipType


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._RotateAngle = params.get("RotateAngle")
        self._FlipType = params.get("FlipType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeMediaConfig(AbstractModel):
    """视频编辑/合成任务 信息。

    关于 轨道、元素、时间轴 关系示意图：

    ![image](https://ie-mps-1258344699.cos.ap-nanjing.tencentcos.cn/common/cloud/EditMedia-Compose-Track-Item.png)

    """

    def __init__(self):
        r"""
        :param _TargetInfo: 合成目标视频信息。
        :type TargetInfo: :class:`tencentcloud.mps.v20190612.models.ComposeTargetInfo`
        :param _Canvas: 合成目标视频的画布信息。
        :type Canvas: :class:`tencentcloud.mps.v20190612.models.ComposeCanvas`
        :param _Styles: 全局样式，和轨道 Tracks 配合使用，用于定于样式，如字幕样式。
        :type Styles: list of ComposeStyles
        :param _Tracks: 用于描述合成视频的轨道列表，包括：视频、音频、图片、文字等元素组成的多个轨道信息。关于轨道和时间：
<ul><li>轨道时间轴即为目标视频时间轴。</li><li>时间轴上相同时间点的不同轨道上的元素会重叠：</li><ul><li>视频、图片、文字：按轨道顺序进行图像的叠加，轨道顺序靠前的在上面。</li><li>音频 ：进行混音。</li></ul></ul>注意：同一轨道中各个元素（除字幕元素外）的轨道时间不能重叠。
        :type Tracks: list of ComposeMediaTrack
        """
        self._TargetInfo = None
        self._Canvas = None
        self._Styles = None
        self._Tracks = None

    @property
    def TargetInfo(self):
        return self._TargetInfo

    @TargetInfo.setter
    def TargetInfo(self, TargetInfo):
        self._TargetInfo = TargetInfo

    @property
    def Canvas(self):
        return self._Canvas

    @Canvas.setter
    def Canvas(self, Canvas):
        self._Canvas = Canvas

    @property
    def Styles(self):
        return self._Styles

    @Styles.setter
    def Styles(self, Styles):
        self._Styles = Styles

    @property
    def Tracks(self):
        return self._Tracks

    @Tracks.setter
    def Tracks(self, Tracks):
        self._Tracks = Tracks


    def _deserialize(self, params):
        if params.get("TargetInfo") is not None:
            self._TargetInfo = ComposeTargetInfo()
            self._TargetInfo._deserialize(params.get("TargetInfo"))
        if params.get("Canvas") is not None:
            self._Canvas = ComposeCanvas()
            self._Canvas._deserialize(params.get("Canvas"))
        if params.get("Styles") is not None:
            self._Styles = []
            for item in params.get("Styles"):
                obj = ComposeStyles()
                obj._deserialize(item)
                self._Styles.append(obj)
        if params.get("Tracks") is not None:
            self._Tracks = []
            for item in params.get("Tracks"):
                obj = ComposeMediaTrack()
                obj._deserialize(item)
                self._Tracks.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeMediaItem(AbstractModel):
    """视频编辑/合成任务 轨道元素信息。

    """

    def __init__(self):
        r"""
        :param _Type: 元素类型。取值有：
<li>Video：视频元素。</li>
<li>Audio：音频元素。</li>
<li>Image：图片元素。</li>
<li>Transition：转场元素。</li>
<li>Subtitle：字幕元素。</li>
<li>Empty：空白元素。</li>
        :type Type: str
        :param _Video: 视频元素，当 Type = Video 时有效。
        :type Video: :class:`tencentcloud.mps.v20190612.models.ComposeVideoItem`
        :param _Audio: 音频元素，当 Type = Audio 时有效。
        :type Audio: :class:`tencentcloud.mps.v20190612.models.ComposeAudioItem`
        :param _Image: 图片元素，当 Type = Image 时有效。
        :type Image: :class:`tencentcloud.mps.v20190612.models.ComposeImageItem`
        :param _Transition: 转场元素，当 Type = Transition 时有效。
        :type Transition: :class:`tencentcloud.mps.v20190612.models.ComposeTransitionItem`
        :param _Subtitle: 字幕元素，当 Type = Subtitle 是有效。
        :type Subtitle: :class:`tencentcloud.mps.v20190612.models.ComposeSubtitleItem`
        :param _Empty: 空白元素，当 Type = Empty 时有效。用于时间轴的占位。
        :type Empty: :class:`tencentcloud.mps.v20190612.models.ComposeEmptyItem`
        """
        self._Type = None
        self._Video = None
        self._Audio = None
        self._Image = None
        self._Transition = None
        self._Subtitle = None
        self._Empty = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Video(self):
        return self._Video

    @Video.setter
    def Video(self, Video):
        self._Video = Video

    @property
    def Audio(self):
        return self._Audio

    @Audio.setter
    def Audio(self, Audio):
        self._Audio = Audio

    @property
    def Image(self):
        return self._Image

    @Image.setter
    def Image(self, Image):
        self._Image = Image

    @property
    def Transition(self):
        return self._Transition

    @Transition.setter
    def Transition(self, Transition):
        self._Transition = Transition

    @property
    def Subtitle(self):
        return self._Subtitle

    @Subtitle.setter
    def Subtitle(self, Subtitle):
        self._Subtitle = Subtitle

    @property
    def Empty(self):
        return self._Empty

    @Empty.setter
    def Empty(self, Empty):
        self._Empty = Empty


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("Video") is not None:
            self._Video = ComposeVideoItem()
            self._Video._deserialize(params.get("Video"))
        if params.get("Audio") is not None:
            self._Audio = ComposeAudioItem()
            self._Audio._deserialize(params.get("Audio"))
        if params.get("Image") is not None:
            self._Image = ComposeImageItem()
            self._Image._deserialize(params.get("Image"))
        if params.get("Transition") is not None:
            self._Transition = ComposeTransitionItem()
            self._Transition._deserialize(params.get("Transition"))
        if params.get("Subtitle") is not None:
            self._Subtitle = ComposeSubtitleItem()
            self._Subtitle._deserialize(params.get("Subtitle"))
        if params.get("Empty") is not None:
            self._Empty = ComposeEmptyItem()
            self._Empty._deserialize(params.get("Empty"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeMediaTrack(AbstractModel):
    """视频编辑/合成任务 轨道信息。

    """

    def __init__(self):
        r"""
        :param _Type: 轨道类型，取值有：<ul><li>Video ：视频轨道。视频轨道可由以下元素组成：</li><ul><li>Video 元素</li><li>Image 元素</li><li>Transition 元素</li><li>Empty 元素</li></ul><li>Audio ：音频轨道。音频轨道可由以下元素组成：</li><ul><li>Audio 元素</li><li>Transition 元素</li><li>Empty 元素</li></ul><li>Title：文字轨道。文字轨道可由以下元素组成：</li><ul><li>Subtitle 元素</li></ul>
        :type Type: str
        :param _Items: 轨道上的元素列表。
        :type Items: list of ComposeMediaItem
        """
        self._Type = None
        self._Items = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = ComposeMediaItem()
                obj._deserialize(item)
                self._Items.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeSourceMedia(AbstractModel):
    """视频编辑/合成任务  媒体素材源信息。

    """

    def __init__(self):
        r"""
        :param _FileId: 媒体对应的素材ID，即 FileInfos 列表中对应素材的 ID。
        :type FileId: str
        :param _StartTime: 媒体位于素材的起始时间，时间点支持 s、% 两种格式：
<li>当字符串以 s 结尾，表示时间点单位为秒，如 3.5s 表示时间点为第3.5秒；</li>
<li>当字符串以 % 结尾，表示时间点为素材时长的百分比大小，如10%表示时间点为素材第10% 的时刻。</li>
默认：0s
        :type StartTime: str
        :param _EndTime: 媒体位于素材的结束时间，和 StartTime 构成媒体在源素材的时间区间，时间点支持 s、% 两种格式：
<li>当字符串以 s 结尾，表示时间点单位为秒，如 3.5s 表示时间点为第3.5秒；</li>
<li>当字符串以 % 结尾，表示时间点为素材时长的百分比大小，如10%表示时间点为素材第10%的时间。</li>
默认：如果对应轨道时长有设置，则默认轨道时长，否则为素材时长，无时长的素材默认为 1 秒。
注意：至少需要大于 StartTime 0.02 秒。

        :type EndTime: str
        """
        self._FileId = None
        self._StartTime = None
        self._EndTime = None

    @property
    def FileId(self):
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._FileId = params.get("FileId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeStyles(AbstractModel):
    """视频编辑/合成任务 样式信息。

    """

    def __init__(self):
        r"""
        :param _Id: 样式 Id，用于和轨道元素中的样式关联。
注意：允许字母、数字、-、_ 组合，最长 32 字符。
        :type Id: str
        :param _Type: 样式类型，取值有：
<li>Subtitle：字幕样式。</li>
        :type Type: str
        :param _Subtitle: 字幕样式信息，当 Type = Subtitle 时有效。
        :type Subtitle: :class:`tencentcloud.mps.v20190612.models.ComposeSubtitleStyle`
        """
        self._Id = None
        self._Type = None
        self._Subtitle = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Subtitle(self):
        return self._Subtitle

    @Subtitle.setter
    def Subtitle(self, Subtitle):
        self._Subtitle = Subtitle


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Type = params.get("Type")
        if params.get("Subtitle") is not None:
            self._Subtitle = ComposeSubtitleStyle()
            self._Subtitle._deserialize(params.get("Subtitle"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeSubtitleItem(AbstractModel):
    """视频编辑/合成任务 字幕元素信息。

    """

    def __init__(self):
        r"""
        :param _StyleId: 字幕样式，Styles 列表中对应的 Subtitle样式的 ID。
        :type StyleId: str
        :param _Text: 字幕文本。
        :type Text: str
        :param _TrackTime: 元素在轨道时间轴上的时间信息，不填则紧跟上一个元素。	
        :type TrackTime: :class:`tencentcloud.mps.v20190612.models.ComposeTrackTime`
        """
        self._StyleId = None
        self._Text = None
        self._TrackTime = None

    @property
    def StyleId(self):
        return self._StyleId

    @StyleId.setter
    def StyleId(self, StyleId):
        self._StyleId = StyleId

    @property
    def Text(self):
        return self._Text

    @Text.setter
    def Text(self, Text):
        self._Text = Text

    @property
    def TrackTime(self):
        return self._TrackTime

    @TrackTime.setter
    def TrackTime(self, TrackTime):
        self._TrackTime = TrackTime


    def _deserialize(self, params):
        self._StyleId = params.get("StyleId")
        self._Text = params.get("Text")
        if params.get("TrackTime") is not None:
            self._TrackTime = ComposeTrackTime()
            self._TrackTime._deserialize(params.get("TrackTime"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeSubtitleStyle(AbstractModel):
    """视频编辑/合成任务 字幕样式。

    """

    def __init__(self):
        r"""
        :param _Height: 字幕高度。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示为画布高度的百分比大小，如 10% 表示为画布高度的 10%。</li>
<li>当字符串以 px 结尾，表示单位为像素，如 100px 表示为100像素。</li>
默认为 FontSize 大小。
        :type Height: str
        :param _MarginBottom: 字幕距离下边框距离，支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示为画布高度的百分比大小，如 10% 表示为画布高度的 10%。</li>
<li>当字符串以 px 结尾，表示单位为像素，如 100px 表示为100像素。</li>
默认：0px
        :type MarginBottom: str
        :param _FontType: 字体类型，支持：
<li>SimHei：黑体（默认）。</li>
<li>SimSun：宋体。</li>
        :type FontType: str
        :param _FontSize: 字体大小，支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示为画布高度的百分比大小，如 10% 表示为画布高度的 10%。</li>
<li>当字符串以 px 结尾，表示单位为像素，如 100px 表示为100像素。</li>
默认：2%
        :type FontSize: str
        :param _FontBold: 是否使用粗体，和字体相关，可选值：
<li>0：否（默认）。</li>
<li>1：是。</li>
        :type FontBold: int
        :param _FontItalic: 是否使用斜体，和字体相关，可选值：
<li>0：否（默认）。</li>
<li>1：是。</li>
        :type FontItalic: int
        :param _FontColor: 字体颜色，格式：#RRGGBBAA。  
默认值：0x000000FF（黑色）。  
注意：其中 AA 部分指的是透明度，为可选。

        :type FontColor: str
        :param _FontAlign: 文字对齐方式：
<li>Center：居中（默认）。</li>
<li>Left：左对齐。</li>
<li>Right：右对齐。</li>
        :type FontAlign: str
        :param _FontAlignMargin: 用于字幕对齐留白：
<li>FontAlign=Left 时，表示距离左边距离。</li>
<li>FontAlign=Right时，表示距离右边距离。</li>
支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示为画布宽度的百分比大小，如 10% 表示为画布宽度的 10%。</li>
<li>当字符串以 px 结尾，表示单位为像素，如 100px 表示为100像素。</li>
        :type FontAlignMargin: str
        :param _BorderWidth: 字体边框宽度，支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示为画布高度的百分比大小，如 10% 表示为画布高度的 10%。</li>
<li>当字符串以 px 结尾，表示单位为像素，如 100px 表示为100像素。</li>
默认： 0，表示不需要边框。
        :type BorderWidth: str
        :param _BorderColor: 边框颜色，当 BorderWidth 不为 0 时生效，其值格式和 FontColor 一致。
        :type BorderColor: str
        :param _BottomColor: 文字底色，其值格式和 FontColor 一致。  
默认为空， 表示不使用底色。
        :type BottomColor: str
        """
        self._Height = None
        self._MarginBottom = None
        self._FontType = None
        self._FontSize = None
        self._FontBold = None
        self._FontItalic = None
        self._FontColor = None
        self._FontAlign = None
        self._FontAlignMargin = None
        self._BorderWidth = None
        self._BorderColor = None
        self._BottomColor = None

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def MarginBottom(self):
        return self._MarginBottom

    @MarginBottom.setter
    def MarginBottom(self, MarginBottom):
        self._MarginBottom = MarginBottom

    @property
    def FontType(self):
        return self._FontType

    @FontType.setter
    def FontType(self, FontType):
        self._FontType = FontType

    @property
    def FontSize(self):
        return self._FontSize

    @FontSize.setter
    def FontSize(self, FontSize):
        self._FontSize = FontSize

    @property
    def FontBold(self):
        return self._FontBold

    @FontBold.setter
    def FontBold(self, FontBold):
        self._FontBold = FontBold

    @property
    def FontItalic(self):
        return self._FontItalic

    @FontItalic.setter
    def FontItalic(self, FontItalic):
        self._FontItalic = FontItalic

    @property
    def FontColor(self):
        return self._FontColor

    @FontColor.setter
    def FontColor(self, FontColor):
        self._FontColor = FontColor

    @property
    def FontAlign(self):
        return self._FontAlign

    @FontAlign.setter
    def FontAlign(self, FontAlign):
        self._FontAlign = FontAlign

    @property
    def FontAlignMargin(self):
        return self._FontAlignMargin

    @FontAlignMargin.setter
    def FontAlignMargin(self, FontAlignMargin):
        self._FontAlignMargin = FontAlignMargin

    @property
    def BorderWidth(self):
        return self._BorderWidth

    @BorderWidth.setter
    def BorderWidth(self, BorderWidth):
        self._BorderWidth = BorderWidth

    @property
    def BorderColor(self):
        return self._BorderColor

    @BorderColor.setter
    def BorderColor(self, BorderColor):
        self._BorderColor = BorderColor

    @property
    def BottomColor(self):
        return self._BottomColor

    @BottomColor.setter
    def BottomColor(self, BottomColor):
        self._BottomColor = BottomColor


    def _deserialize(self, params):
        self._Height = params.get("Height")
        self._MarginBottom = params.get("MarginBottom")
        self._FontType = params.get("FontType")
        self._FontSize = params.get("FontSize")
        self._FontBold = params.get("FontBold")
        self._FontItalic = params.get("FontItalic")
        self._FontColor = params.get("FontColor")
        self._FontAlign = params.get("FontAlign")
        self._FontAlignMargin = params.get("FontAlignMargin")
        self._BorderWidth = params.get("BorderWidth")
        self._BorderColor = params.get("BorderColor")
        self._BottomColor = params.get("BottomColor")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeTargetInfo(AbstractModel):
    """视频编辑/合成任务 目标视频信息。

    """

    def __init__(self):
        r"""
        :param _Container: 封装容器格式，可选值：
<li>mp4：视频文件（默认）。</li>
<li>mp3：纯音频文件。</li>
        :type Container: str
        :param _RemoveVideo: 是否去除视频数据，可选值：
<li>0：保留（默认）。</li>
<li>1：去除。</li>
        :type RemoveVideo: int
        :param _RemoveAudio: 是否去除音频数据，可选值：
<li>0：保留（默认）。</li>
<li>1：去除。</li>
        :type RemoveAudio: int
        :param _VideoStream: 输出视频流信息。
        :type VideoStream: :class:`tencentcloud.mps.v20190612.models.ComposeVideoStream`
        :param _AudioStream: 输出音频流信息。
        :type AudioStream: :class:`tencentcloud.mps.v20190612.models.ComposeAudioStream`
        """
        self._Container = None
        self._RemoveVideo = None
        self._RemoveAudio = None
        self._VideoStream = None
        self._AudioStream = None

    @property
    def Container(self):
        return self._Container

    @Container.setter
    def Container(self, Container):
        self._Container = Container

    @property
    def RemoveVideo(self):
        return self._RemoveVideo

    @RemoveVideo.setter
    def RemoveVideo(self, RemoveVideo):
        self._RemoveVideo = RemoveVideo

    @property
    def RemoveAudio(self):
        return self._RemoveAudio

    @RemoveAudio.setter
    def RemoveAudio(self, RemoveAudio):
        self._RemoveAudio = RemoveAudio

    @property
    def VideoStream(self):
        return self._VideoStream

    @VideoStream.setter
    def VideoStream(self, VideoStream):
        self._VideoStream = VideoStream

    @property
    def AudioStream(self):
        return self._AudioStream

    @AudioStream.setter
    def AudioStream(self, AudioStream):
        self._AudioStream = AudioStream


    def _deserialize(self, params):
        self._Container = params.get("Container")
        self._RemoveVideo = params.get("RemoveVideo")
        self._RemoveAudio = params.get("RemoveAudio")
        if params.get("VideoStream") is not None:
            self._VideoStream = ComposeVideoStream()
            self._VideoStream._deserialize(params.get("VideoStream"))
        if params.get("AudioStream") is not None:
            self._AudioStream = ComposeAudioStream()
            self._AudioStream._deserialize(params.get("AudioStream"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeTrackTime(AbstractModel):
    """视频编辑/合成任务 对应元素在目标视频轨道上的时间信息。

    """

    def __init__(self):
        r"""
        :param _Start: 元素在轨道上的起始时间，时间点支持：
<li>以 s 结尾，表示时间点单位为秒，如 3.5s 表示时间点为第3.5秒；</li>
注意：不填则默认为前一个元素的结束时间，此时可以通过 ComposeEmptyItem 元素来进行占位，实现轨道起始时间设置。
        :type Start: str
        :param _Duration: 元素时长，时间支持：
<li>以 s 结尾，表示时间点单位为秒，如 3.5s 表示时间点为第3.5秒；</li>
默认：取对应 ComposeSourceMedia 媒体的有效时长（即 EndTime-StartTime），没有 ComposeSourceMedia 则默认为 1 秒。
        :type Duration: str
        """
        self._Start = None
        self._Duration = None

    @property
    def Start(self):
        return self._Start

    @Start.setter
    def Start(self, Start):
        self._Start = Start

    @property
    def Duration(self):
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration


    def _deserialize(self, params):
        self._Start = params.get("Start")
        self._Duration = params.get("Duration")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeTransitionItem(AbstractModel):
    """视频编辑/合成任务 转场元素信息。

    """

    def __init__(self):
        r"""
        :param _Duration: 元素时长，时间支持：<li>以 s 结尾，表示时间点单位为秒，如 3s 表示时间点为第3秒。</li>
默认：1s
注意：
<li>必须是整数s，否则向下取整。</li>
<li>转场 前后必须紧挨着两个不为 Empty 的元素。</li>
<li>转场 Duration 必须小于前一个元素的 Duration，同时必须小于后一个元素的 Duration。</li>
<li>进行转场处理的两个元素，第二个元素在轨道上的起始时间会自动调整为前一个元素的结束时间减去转场的 Duration。</li>
        :type Duration: str
        :param _Transitions: 转场操作列表。
默认：淡入淡出。
注意：图像转场操作和音频转场操作各自最多支持一个。
        :type Transitions: list of ComposeTransitionOperation
        """
        self._Duration = None
        self._Transitions = None

    @property
    def Duration(self):
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration

    @property
    def Transitions(self):
        return self._Transitions

    @Transitions.setter
    def Transitions(self, Transitions):
        self._Transitions = Transitions


    def _deserialize(self, params):
        self._Duration = params.get("Duration")
        if params.get("Transitions") is not None:
            self._Transitions = []
            for item in params.get("Transitions"):
                obj = ComposeTransitionOperation()
                obj._deserialize(item)
                self._Transitions.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeTransitionOperation(AbstractModel):
    """视频编辑/合成任务 元素转场信息。

    """

    def __init__(self):
        r"""
        :param _Type: 转场类型。

图像的转场操作，用于两个视频片段图像间的转场处理：
<li>ImageFadeInFadeOut：图像淡入淡出。</li>
<li>BowTieHorizontal：水平蝴蝶结。</li>
<li>BowTieVertical：垂直蝴蝶结。</li>
<li>ButterflyWaveScrawler：晃动。</li>
<li>Cannabisleaf：枫叶。</li>
<li>Circle：弧形收放。</li>
<li>CircleCrop：圆环聚拢。</li>
<li>Circleopen：椭圆聚拢。</li>
<li>Crosswarp：横向翘曲。</li>
<li>Cube：立方体。</li>
<li>DoomScreenTransition：幕布。</li>
<li>Doorway：门廊。</li>
<li>Dreamy：波浪。</li>
<li>DreamyZoom：水平聚拢。</li>
<li>FilmBurn：火烧云。</li>
<li>GlitchMemories：抖动。</li>
<li>Heart：心形。</li>
<li>InvertedPageCurl：翻页。</li>
<li>Luma：腐蚀。</li>
<li>Mosaic：九宫格。</li>
<li>Pinwheel：风车。</li>
<li>PolarFunction：椭圆扩散。</li>
<li>PolkaDotsCurtain：弧形扩散。</li>
<li>Radial：雷达扫描。</li>
<li>RotateScaleFade：上下收放。</li>
<li>Squeeze：上下聚拢。</li>
<li>Swap：放大切换。</li>
<li>Swirl：螺旋。</li>
<li>UndulatingBurnOutSwirl：水流蔓延。</li>
<li>Windowblinds：百叶窗。</li>
<li>WipeDown：向下收起。</li>
<li>WipeLeft：向左收起。</li>
<li>WipeRight：向右收起。</li>
<li>WipeUp：向上收起。</li>
<li>ZoomInCircles：水波纹。</li> 
音频的转场操作，用于两个音频片段间的转场处理：
<li>AudioFadeInFadeOut：声音淡入淡出。</li>
        :type Type: str
        """
        self._Type = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeVideoItem(AbstractModel):
    """视频编辑/合成任务 视频元素信息。

    """

    def __init__(self):
        r"""
        :param _SourceMedia: 元素对应媒体信息。
        :type SourceMedia: :class:`tencentcloud.mps.v20190612.models.ComposeSourceMedia`
        :param _TrackTime: 元素在轨道时间轴上的时间信息，不填则紧跟上一个元素。
        :type TrackTime: :class:`tencentcloud.mps.v20190612.models.ComposeTrackTime`
        :param _XPos: 元素中心点距离画布原点的水平位置。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示元素 XPos 为画布宽度指定百分比的位置，如 10% 表示 XPos 为画布宽度的 10%。</li>
<li>当字符串以 px 结尾，表示元素 XPos 单位为像素，如 100px 表示 XPos 为100像素。</li>
默认：50%。
        :type XPos: str
        :param _YPos: 元素中心点距离画布原点的垂直位置。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示元素 YPos 为画布高度指定百分比的位置，如 10% 表示 YPos 为画布高度的 10%。</li>
<li>当字符串以 px 结尾，表示元素 YPos 单位为像素，如 100px 表示 YPos 为100像素。</li>
默认：50%。
        :type YPos: str
        :param _Width: 视频片段的宽度。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示元素 Width 为画布宽度的百分比大小，如 10% 表示 Width 为画布宽度的 10%。</li>
<li>当字符串以 px 结尾，表示元素 Width 单位为像素，如 100px 表示 Width 为100像素。</li>
为空（或0） 的场景：
<li>当 Width、Height 均为空，则 Width 和 Height 取源素材本身的 Width、Height。</li>
<li>当 Width 为空，Height 非空，则 Width 按源素材比例缩放。</li>
<li>当 Width 非空，Height 为空，则 Height 按源素材比例缩放。</li>
        :type Width: str
        :param _Height: 元素的高度。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示元素 Height 为画布高度的百分比大小，如 10% 表示 Height 为画布高度的 10%。</li>
<li>当字符串以 px 结尾，表示元素 Height 单位为像素，如 100px 表示 Height 为100像素。</li>
为空（或0） 的场景：
<li>当 Width、Height 均为空，则 Width 和 Height 取源素材本身的 Width、Height。</li>
<li>当 Width 为空，Height 非空，则 Width 按源素材比例缩放。</li>
<li>当 Width 非空，Height 为空，则 Height 按源素材比例缩放。</li>
        :type Height: str
        :param _ImageOperations: 对图像画面进行的操作，如图像旋转等。
        :type ImageOperations: list of ComposeImageOperation
        :param _AudioOperations: 对音频进行操作，如静音等。
        :type AudioOperations: list of ComposeAudioOperation
        """
        self._SourceMedia = None
        self._TrackTime = None
        self._XPos = None
        self._YPos = None
        self._Width = None
        self._Height = None
        self._ImageOperations = None
        self._AudioOperations = None

    @property
    def SourceMedia(self):
        return self._SourceMedia

    @SourceMedia.setter
    def SourceMedia(self, SourceMedia):
        self._SourceMedia = SourceMedia

    @property
    def TrackTime(self):
        return self._TrackTime

    @TrackTime.setter
    def TrackTime(self, TrackTime):
        self._TrackTime = TrackTime

    @property
    def XPos(self):
        return self._XPos

    @XPos.setter
    def XPos(self, XPos):
        self._XPos = XPos

    @property
    def YPos(self):
        return self._YPos

    @YPos.setter
    def YPos(self, YPos):
        self._YPos = YPos

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ImageOperations(self):
        return self._ImageOperations

    @ImageOperations.setter
    def ImageOperations(self, ImageOperations):
        self._ImageOperations = ImageOperations

    @property
    def AudioOperations(self):
        return self._AudioOperations

    @AudioOperations.setter
    def AudioOperations(self, AudioOperations):
        self._AudioOperations = AudioOperations


    def _deserialize(self, params):
        if params.get("SourceMedia") is not None:
            self._SourceMedia = ComposeSourceMedia()
            self._SourceMedia._deserialize(params.get("SourceMedia"))
        if params.get("TrackTime") is not None:
            self._TrackTime = ComposeTrackTime()
            self._TrackTime._deserialize(params.get("TrackTime"))
        self._XPos = params.get("XPos")
        self._YPos = params.get("YPos")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        if params.get("ImageOperations") is not None:
            self._ImageOperations = []
            for item in params.get("ImageOperations"):
                obj = ComposeImageOperation()
                obj._deserialize(item)
                self._ImageOperations.append(obj)
        if params.get("AudioOperations") is not None:
            self._AudioOperations = []
            for item in params.get("AudioOperations"):
                obj = ComposeAudioOperation()
                obj._deserialize(item)
                self._AudioOperations.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeVideoStream(AbstractModel):
    """视频编辑/合成任务 视频流信息。

    """

    def __init__(self):
        r"""
        :param _Codec: 视频流的编码方式，可选值：
<li>H.264：H.264 编码（默认）。</li>
        :type Codec: str
        :param _Fps: 视频帧率，取值范围：[0, 60]，单位：Hz。  
默认值：0，表示和第一个视频帧率一致。
        :type Fps: int
        :param _Bitrate: 参考码率，单位 kbps，范围：50~35000。
如果设置，编码时会尽量按该码率进行编码。
如果不设置，服务将通过画面复杂度自动采用合适的码率。
        :type Bitrate: int
        """
        self._Codec = None
        self._Fps = None
        self._Bitrate = None

    @property
    def Codec(self):
        return self._Codec

    @Codec.setter
    def Codec(self, Codec):
        self._Codec = Codec

    @property
    def Fps(self):
        return self._Fps

    @Fps.setter
    def Fps(self, Fps):
        self._Fps = Fps

    @property
    def Bitrate(self):
        return self._Bitrate

    @Bitrate.setter
    def Bitrate(self, Bitrate):
        self._Bitrate = Bitrate


    def _deserialize(self, params):
        self._Codec = params.get("Codec")
        self._Fps = params.get("Fps")
        self._Bitrate = params.get("Bitrate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ContainerDiagnoseResultItem(AbstractModel):
    """容器格式诊断结果

    """

    def __init__(self):
        r"""
        :param _Category: 诊断出的异常类别，取值范围：
DecodeParamException：解码参数异常
TimeStampException：时间戳异常
FrameException： 帧率异常
StreamStatusException：流状态异常
StreamInfo：流信息异常
StreamAbnormalCharacteristics：流特征异常
DecodeException：解码异常
HLSRequirements：HLS 格式异常
注意：此字段可能返回 null，表示取不到有效值。
        :type Category: str
        :param _Type: 诊断出的具体异常类型，取值如下：

VideoResolutionChanged：视频分辨率变化
AudioSampleRateChanged：音频采样率变化
AudioChannelsChanged：音频通道数变化
ParameterSetsChanged：流参数集信息发生变化
DarOrSarInvalid：视频的宽高比异常
TimestampFallback：DTS时间戳回退
DtsJitter：DTS抖动过大
PtsJitter：PTS抖动过大
AACDurationDeviation：AAC帧时间戳间隔不合理
AudioDroppingFrames：音频丢帧
VideoDroppingFrames：视频丢帧
AVTimestampInterleave：音视频交织不合理
PtsLessThanDts：媒体流的 pts 小于 dts
ReceiveFpsJitter：网络接收帧率抖动过大
ReceiveFpsTooSmall：网络接收视频帧率过小
FpsJitter：通过PTS计算得到的流帧率抖动过大
StreamOpenFailed：流打开失败
StreamEnd：流结束
StreamParseFailed：流解析失败
VideoFirstFrameNotIdr：首帧不是IDR帧
StreamNALUError：NALU起始码错误
TsStreamNoAud：mpegts的H26x流缺失 AUD NALU
AudioStreamLack：无音频流
VideoStreamLack：无视频流
LackAudioRecover：缺失音频流恢复
LackVideoRecover：缺失视频流恢复
VideoBitrateOutofRange：视频流码率(kbps)超出范围
AudioBitrateOutofRange：音频流码率(kbps)超出范围
VideoDecodeFailed：视频解码错误
AudioDecodeFailed：音频解码错误
AudioOutOfPhase：双通道音频相位相反
VideoDuplicatedFrame：视频流中存在重复帧
AudioDuplicatedFrame：音频流中存在重复帧
VideoRotation：视频画面旋转
TsMultiPrograms：MPEG2-TS流有多个program
Mp4InvalidCodecFourcc：MP4中codec fourcc不符合Apple HLS要求
HLSBadM3u8Format：无效的m3u8文件
HLSInvalidMasterM3u8：无效的main m3u8文件
HLSInvalidMediaM3u8：无效的media m3u8文件
HLSMasterM3u8Recommended：main m3u8缺少标准推荐的参数
HLSMediaM3u8Recommended：media m3u8缺少标准推荐的参数
HLSMediaM3u8DiscontinuityExist：media m3u8存在EXT-X-DISCONTINUITY
HLSMediaSegmentsStreamNumChange：切片的流数目发生变化
HLSMediaSegmentsPTSJitterDeviation：切片间PTS跳变且没有EXT-X-DISCONTINUITY
HLSMediaSegmentsDTSJitterDeviation：切片间DTS跳变且没有EXT-X-DISCONTINUITY
TimecodeTrackExist：MP4存在tmcd轨道
注意：此字段可能返回 null，表示取不到有效值。
        :type Type: str
        :param _SeverityLevel: 诊断出的异常级别，取值范围：
Fatal：影响后续播放和解析，
Error： 可能会影响播放，
Warning： 可能会有潜在风险，但不一定会影响播放，
Notice：比较重要的流信息，
Info：一般性的流信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type SeverityLevel: str
        :param _DateTimeSet: 警告出现的时间点，形式如 “2022-12-25T13:14:16Z”
注意：此字段可能返回 null，表示取不到有效值。
        :type DateTimeSet: list of str
        :param _TimestampSet: 时间戳
注意：此字段可能返回 null，表示取不到有效值。
        :type TimestampSet: list of float
        """
        self._Category = None
        self._Type = None
        self._SeverityLevel = None
        self._DateTimeSet = None
        self._TimestampSet = None

    @property
    def Category(self):
        return self._Category

    @Category.setter
    def Category(self, Category):
        self._Category = Category

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def SeverityLevel(self):
        return self._SeverityLevel

    @SeverityLevel.setter
    def SeverityLevel(self, SeverityLevel):
        self._SeverityLevel = SeverityLevel

    @property
    def DateTimeSet(self):
        return self._DateTimeSet

    @DateTimeSet.setter
    def DateTimeSet(self, DateTimeSet):
        self._DateTimeSet = DateTimeSet

    @property
    def TimestampSet(self):
        return self._TimestampSet

    @TimestampSet.setter
    def TimestampSet(self, TimestampSet):
        self._TimestampSet = TimestampSet


    def _deserialize(self, params):
        self._Category = params.get("Category")
        self._Type = params.get("Type")
        self._SeverityLevel = params.get("SeverityLevel")
        self._DateTimeSet = params.get("DateTimeSet")
        self._TimestampSet = params.get("TimestampSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ContentReviewTemplateItem(AbstractModel):
    """内容审核模板详情

    """

    def __init__(self):
        r"""
        :param _Definition: 内容审核模板唯一标识。
        :type Definition: int
        :param _Name: 内容审核模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Comment: 内容审核模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _PornConfigure: 鉴黄控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :type PornConfigure: :class:`tencentcloud.mps.v20190612.models.PornConfigureInfo`
        :param _TerrorismConfigure: 涉敏控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :type TerrorismConfigure: :class:`tencentcloud.mps.v20190612.models.TerrorismConfigureInfo`
        :param _PoliticalConfigure: 涉敏控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :type PoliticalConfigure: :class:`tencentcloud.mps.v20190612.models.PoliticalConfigureInfo`
        :param _ProhibitedConfigure: 违禁控制参数。违禁内容包括：
<li>谩骂；</li>
<li>涉毒违法。</li>
注意：此字段可能返回 null，表示取不到有效值。
        :type ProhibitedConfigure: :class:`tencentcloud.mps.v20190612.models.ProhibitedConfigureInfo`
        :param _UserDefineConfigure: 用户自定义内容审核控制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :type UserDefineConfigure: :class:`tencentcloud.mps.v20190612.models.UserDefineConfigureInfo`
        :param _CreateTime: 模板创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :type CreateTime: str
        :param _UpdateTime: 模板最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :type UpdateTime: str
        :param _Type: 模板类型，取值范围：
* Preset：系统预置模板；
* Custom：用户自定义模板。
注意：此字段可能返回 null，表示取不到有效值。
        :type Type: str
        """
        self._Definition = None
        self._Name = None
        self._Comment = None
        self._PornConfigure = None
        self._TerrorismConfigure = None
        self._PoliticalConfigure = None
        self._ProhibitedConfigure = None
        self._UserDefineConfigure = None
        self._CreateTime = None
        self._UpdateTime = None
        self._Type = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def PornConfigure(self):
        return self._PornConfigure

    @PornConfigure.setter
    def PornConfigure(self, PornConfigure):
        self._PornConfigure = PornConfigure

    @property
    def TerrorismConfigure(self):
        return self._TerrorismConfigure

    @TerrorismConfigure.setter
    def TerrorismConfigure(self, TerrorismConfigure):
        self._TerrorismConfigure = TerrorismConfigure

    @property
    def PoliticalConfigure(self):
        return self._PoliticalConfigure

    @PoliticalConfigure.setter
    def PoliticalConfigure(self, PoliticalConfigure):
        self._PoliticalConfigure = PoliticalConfigure

    @property
    def ProhibitedConfigure(self):
        return self._ProhibitedConfigure

    @ProhibitedConfigure.setter
    def ProhibitedConfigure(self, ProhibitedConfigure):
        self._ProhibitedConfigure = ProhibitedConfigure

    @property
    def UserDefineConfigure(self):
        return self._UserDefineConfigure

    @UserDefineConfigure.setter
    def UserDefineConfigure(self, UserDefineConfigure):
        self._UserDefineConfigure = UserDefineConfigure

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("PornConfigure") is not None:
            self._PornConfigure = PornConfigureInfo()
            self._PornConfigure._deserialize(params.get("PornConfigure"))
        if params.get("TerrorismConfigure") is not None:
            self._TerrorismConfigure = TerrorismConfigureInfo()
            self._TerrorismConfigure._deserialize(params.get("TerrorismConfigure"))
        if params.get("PoliticalConfigure") is not None:
            self._PoliticalConfigure = PoliticalConfigureInfo()
            self._PoliticalConfigure._deserialize(params.get("PoliticalConfigure"))
        if params.get("ProhibitedConfigure") is not None:
            self._ProhibitedConfigure = ProhibitedConfigureInfo()
            self._ProhibitedConfigure._deserialize(params.get("ProhibitedConfigure"))
        if params.get("UserDefineConfigure") is not None:
            self._UserDefineConfigure = UserDefineConfigureInfo()
            self._UserDefineConfigure._deserialize(params.get("UserDefineConfigure"))
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CosFileUploadTrigger(AbstractModel):
    """绑定到 COS 的输入规则。

    """

    def __init__(self):
        r"""
        :param _Bucket: 工作流绑定的 COS Bucket 名，如 TopRankVideo-125xxx88。
        :type Bucket: str
        :param _Region: 工作流绑定的 COS Bucket 所属园区，如 ap-chongiqng。
        :type Region: str
        :param _Dir: 工作流绑定的输入路径目录，必须为绝对路径，即以 `/` 开头和结尾。如`/movie/201907/`，不填代表根目录`/`。
        :type Dir: str
        :param _Formats: 工作流允许触发的文件格式列表，如 ["mp4", "flv", "mov"]。不填代表所有格式的文件都可以触发工作流。
        :type Formats: list of str
        """
        self._Bucket = None
        self._Region = None
        self._Dir = None
        self._Formats = None

    @property
    def Bucket(self):
        return self._Bucket

    @Bucket.setter
    def Bucket(self, Bucket):
        self._Bucket = Bucket

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Dir(self):
        return self._Dir

    @Dir.setter
    def Dir(self, Dir):
        self._Dir = Dir

    @property
    def Formats(self):
        return self._Formats

    @Formats.setter
    def Formats(self, Formats):
        self._Formats = Formats


    def _deserialize(self, params):
        self._Bucket = params.get("Bucket")
        self._Region = params.get("Region")
        self._Dir = params.get("Dir")
        self._Formats = params.get("Formats")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CosInputInfo(AbstractModel):
    """媒体处理 COS 对象信息。

    """

    def __init__(self):
        r"""
        :param _Bucket: 媒体处理对象文件所在的 COS Bucket 名，如 TopRankVideo-125xxx88。
        :type Bucket: str
        :param _Region: 媒体处理对象文件所在的 COS Bucket 所属园区，如 ap-chongqing。
        :type Region: str
        :param _Object: 媒体处理对象文件的输入路径，如`/movie/201907/WildAnimal.mov`。
        :type Object: str
        """
        self._Bucket = None
        self._Region = None
        self._Object = None

    @property
    def Bucket(self):
        return self._Bucket

    @Bucket.setter
    def Bucket(self, Bucket):
        self._Bucket = Bucket

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Object(self):
        return self._Object

    @Object.setter
    def Object(self, Object):
        self._Object = Object


    def _deserialize(self, params):
        self._Bucket = params.get("Bucket")
        self._Region = params.get("Region")
        self._Object = params.get("Object")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CosOutputStorage(AbstractModel):
    """媒体处理 COS 输出对象信息。

    """

    def __init__(self):
        r"""
        :param _Bucket: 媒体处理生成的文件输出的目标 Bucket 名，如 TopRankVideo-125xxx88。如果不填，表示继承上层。
        :type Bucket: str
        :param _Region: 媒体处理生成的文件输出的目标 Bucket 的园区，如 ap-chongqing。如果不填，表示继承上层。
        :type Region: str
        """
        self._Bucket = None
        self._Region = None

    @property
    def Bucket(self):
        return self._Bucket

    @Bucket.setter
    def Bucket(self, Bucket):
        self._Bucket = Bucket

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region


    def _deserialize(self, params):
        self._Bucket = params.get("Bucket")
        self._Region = params.get("Region")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CoverConfigureInfo(AbstractModel):
    """智能封面任务控制参数

    """

    def __init__(self):
        r"""
        :param _Switch: 智能封面任务开关，可选值：
<li>ON：开启智能封面任务；</li>
<li>OFF：关闭智能封面任务。</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CoverConfigureInfoForUpdate(AbstractModel):
    """智能封面任务控制参数

    """

    def __init__(self):
        r"""
        :param _Switch: 智能封面任务开关，可选值：
<li>ON：开启智能封面任务；</li>
<li>OFF：关闭智能封面任务。</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAIAnalysisTemplateRequest(AbstractModel):
    """CreateAIAnalysisTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 视频内容分析模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Comment: 视频内容分析模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _ClassificationConfigure: 智能分类任务控制参数。
        :type ClassificationConfigure: :class:`tencentcloud.mps.v20190612.models.ClassificationConfigureInfo`
        :param _TagConfigure: 智能标签任务控制参数。
        :type TagConfigure: :class:`tencentcloud.mps.v20190612.models.TagConfigureInfo`
        :param _CoverConfigure: 智能封面任务控制参数。
        :type CoverConfigure: :class:`tencentcloud.mps.v20190612.models.CoverConfigureInfo`
        :param _FrameTagConfigure: 智能按帧标签任务控制参数。
        :type FrameTagConfigure: :class:`tencentcloud.mps.v20190612.models.FrameTagConfigureInfo`
        """
        self._Name = None
        self._Comment = None
        self._ClassificationConfigure = None
        self._TagConfigure = None
        self._CoverConfigure = None
        self._FrameTagConfigure = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def ClassificationConfigure(self):
        return self._ClassificationConfigure

    @ClassificationConfigure.setter
    def ClassificationConfigure(self, ClassificationConfigure):
        self._ClassificationConfigure = ClassificationConfigure

    @property
    def TagConfigure(self):
        return self._TagConfigure

    @TagConfigure.setter
    def TagConfigure(self, TagConfigure):
        self._TagConfigure = TagConfigure

    @property
    def CoverConfigure(self):
        return self._CoverConfigure

    @CoverConfigure.setter
    def CoverConfigure(self, CoverConfigure):
        self._CoverConfigure = CoverConfigure

    @property
    def FrameTagConfigure(self):
        return self._FrameTagConfigure

    @FrameTagConfigure.setter
    def FrameTagConfigure(self, FrameTagConfigure):
        self._FrameTagConfigure = FrameTagConfigure


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("ClassificationConfigure") is not None:
            self._ClassificationConfigure = ClassificationConfigureInfo()
            self._ClassificationConfigure._deserialize(params.get("ClassificationConfigure"))
        if params.get("TagConfigure") is not None:
            self._TagConfigure = TagConfigureInfo()
            self._TagConfigure._deserialize(params.get("TagConfigure"))
        if params.get("CoverConfigure") is not None:
            self._CoverConfigure = CoverConfigureInfo()
            self._CoverConfigure._deserialize(params.get("CoverConfigure"))
        if params.get("FrameTagConfigure") is not None:
            self._FrameTagConfigure = FrameTagConfigureInfo()
            self._FrameTagConfigure._deserialize(params.get("FrameTagConfigure"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAIAnalysisTemplateResponse(AbstractModel):
    """CreateAIAnalysisTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 视频内容分析模板唯一标识。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateAIRecognitionTemplateRequest(AbstractModel):
    """CreateAIRecognitionTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 视频内容识别模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Comment: 视频内容识别模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _FaceConfigure: 人脸识别控制参数。
        :type FaceConfigure: :class:`tencentcloud.mps.v20190612.models.FaceConfigureInfo`
        :param _OcrFullTextConfigure: 文本全文识别控制参数。
        :type OcrFullTextConfigure: :class:`tencentcloud.mps.v20190612.models.OcrFullTextConfigureInfo`
        :param _OcrWordsConfigure: 文本关键词识别控制参数。
        :type OcrWordsConfigure: :class:`tencentcloud.mps.v20190612.models.OcrWordsConfigureInfo`
        :param _AsrFullTextConfigure: 语音全文识别控制参数。
        :type AsrFullTextConfigure: :class:`tencentcloud.mps.v20190612.models.AsrFullTextConfigureInfo`
        :param _AsrWordsConfigure: 语音关键词识别控制参数。
        :type AsrWordsConfigure: :class:`tencentcloud.mps.v20190612.models.AsrWordsConfigureInfo`
        :param _TranslateConfigure: 语音翻译控制参数。
        :type TranslateConfigure: :class:`tencentcloud.mps.v20190612.models.TranslateConfigureInfo`
        """
        self._Name = None
        self._Comment = None
        self._FaceConfigure = None
        self._OcrFullTextConfigure = None
        self._OcrWordsConfigure = None
        self._AsrFullTextConfigure = None
        self._AsrWordsConfigure = None
        self._TranslateConfigure = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def FaceConfigure(self):
        return self._FaceConfigure

    @FaceConfigure.setter
    def FaceConfigure(self, FaceConfigure):
        self._FaceConfigure = FaceConfigure

    @property
    def OcrFullTextConfigure(self):
        return self._OcrFullTextConfigure

    @OcrFullTextConfigure.setter
    def OcrFullTextConfigure(self, OcrFullTextConfigure):
        self._OcrFullTextConfigure = OcrFullTextConfigure

    @property
    def OcrWordsConfigure(self):
        return self._OcrWordsConfigure

    @OcrWordsConfigure.setter
    def OcrWordsConfigure(self, OcrWordsConfigure):
        self._OcrWordsConfigure = OcrWordsConfigure

    @property
    def AsrFullTextConfigure(self):
        return self._AsrFullTextConfigure

    @AsrFullTextConfigure.setter
    def AsrFullTextConfigure(self, AsrFullTextConfigure):
        self._AsrFullTextConfigure = AsrFullTextConfigure

    @property
    def AsrWordsConfigure(self):
        return self._AsrWordsConfigure

    @AsrWordsConfigure.setter
    def AsrWordsConfigure(self, AsrWordsConfigure):
        self._AsrWordsConfigure = AsrWordsConfigure

    @property
    def TranslateConfigure(self):
        return self._TranslateConfigure

    @TranslateConfigure.setter
    def TranslateConfigure(self, TranslateConfigure):
        self._TranslateConfigure = TranslateConfigure


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("FaceConfigure") is not None:
            self._FaceConfigure = FaceConfigureInfo()
            self._FaceConfigure._deserialize(params.get("FaceConfigure"))
        if params.get("OcrFullTextConfigure") is not None:
            self._OcrFullTextConfigure = OcrFullTextConfigureInfo()
            self._OcrFullTextConfigure._deserialize(params.get("OcrFullTextConfigure"))
        if params.get("OcrWordsConfigure") is not None:
            self._OcrWordsConfigure = OcrWordsConfigureInfo()
            self._OcrWordsConfigure._deserialize(params.get("OcrWordsConfigure"))
        if params.get("AsrFullTextConfigure") is not None:
            self._AsrFullTextConfigure = AsrFullTextConfigureInfo()
            self._AsrFullTextConfigure._deserialize(params.get("AsrFullTextConfigure"))
        if params.get("AsrWordsConfigure") is not None:
            self._AsrWordsConfigure = AsrWordsConfigureInfo()
            self._AsrWordsConfigure._deserialize(params.get("AsrWordsConfigure"))
        if params.get("TranslateConfigure") is not None:
            self._TranslateConfigure = TranslateConfigureInfo()
            self._TranslateConfigure._deserialize(params.get("TranslateConfigure"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAIRecognitionTemplateResponse(AbstractModel):
    """CreateAIRecognitionTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 视频内容识别模板唯一标识。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateAdaptiveDynamicStreamingTemplateRequest(AbstractModel):
    """CreateAdaptiveDynamicStreamingTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Format: 自适应转码格式，取值范围：
<li>HLS，</li>
<li>MPEG-DASH。</li>
        :type Format: str
        :param _StreamInfos: 转自适应码流输出子流参数信息，最多输出10路子流。
注意：各个子流的帧率必须保持一致；如果不一致，采用第一个子流的帧率作为输出帧率。
        :type StreamInfos: list of AdaptiveStreamTemplate
        :param _Name: 模板名称，长度限制：64 个字符。
        :type Name: str
        :param _DisableHigherVideoBitrate: 是否禁止视频低码率转高码率，取值范围：
<li>0：否，</li>
<li>1：是。</li>
默认为否。
        :type DisableHigherVideoBitrate: int
        :param _DisableHigherVideoResolution: 是否禁止视频分辨率转高分辨率，取值范围：
<li>0：否，</li>
<li>1：是。</li>
默认为否。
        :type DisableHigherVideoResolution: int
        :param _Comment: 模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _PureAudio: 是否为纯音频，0表示视频模版，1表示纯音频模版
当值为1：
1. StreamInfos.N.RemoveVideo=1
2. StreamInfos.N.RemoveAudio=0
3. StreamInfos.N.Video.Codec=copy

当值为0：

1. StreamInfos.N.Video.Codec不能为copy
2. StreamInfos.N.Video.Fps不能为null
        :type PureAudio: int
        :param _SegmentType: hls 分片类型，可选值： <li>ts-segment：HLS+TS 切片</li> <li>ts-byterange：HLS+TS byte range</li> <li>mp4-segment：HLS+MP4 切片</li> <li>mp4-byterange：HLS+MP4 byte range</li> <li>ts-packed-audio：TS+Packed Audio</li> <li>mp4-packed-audio：MP4+Packed Audio</li> 默认值：ts-segment 
注：自适应码流的hls分片格式已此字段为准
        :type SegmentType: str
        """
        self._Format = None
        self._StreamInfos = None
        self._Name = None
        self._DisableHigherVideoBitrate = None
        self._DisableHigherVideoResolution = None
        self._Comment = None
        self._PureAudio = None
        self._SegmentType = None

    @property
    def Format(self):
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def StreamInfos(self):
        return self._StreamInfos

    @StreamInfos.setter
    def StreamInfos(self, StreamInfos):
        self._StreamInfos = StreamInfos

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def DisableHigherVideoBitrate(self):
        return self._DisableHigherVideoBitrate

    @DisableHigherVideoBitrate.setter
    def DisableHigherVideoBitrate(self, DisableHigherVideoBitrate):
        self._DisableHigherVideoBitrate = DisableHigherVideoBitrate

    @property
    def DisableHigherVideoResolution(self):
        return self._DisableHigherVideoResolution

    @DisableHigherVideoResolution.setter
    def DisableHigherVideoResolution(self, DisableHigherVideoResolution):
        self._DisableHigherVideoResolution = DisableHigherVideoResolution

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def PureAudio(self):
        return self._PureAudio

    @PureAudio.setter
    def PureAudio(self, PureAudio):
        self._PureAudio = PureAudio

    @property
    def SegmentType(self):
        return self._SegmentType

    @SegmentType.setter
    def SegmentType(self, SegmentType):
        self._SegmentType = SegmentType


    def _deserialize(self, params):
        self._Format = params.get("Format")
        if params.get("StreamInfos") is not None:
            self._StreamInfos = []
            for item in params.get("StreamInfos"):
                obj = AdaptiveStreamTemplate()
                obj._deserialize(item)
                self._StreamInfos.append(obj)
        self._Name = params.get("Name")
        self._DisableHigherVideoBitrate = params.get("DisableHigherVideoBitrate")
        self._DisableHigherVideoResolution = params.get("DisableHigherVideoResolution")
        self._Comment = params.get("Comment")
        self._PureAudio = params.get("PureAudio")
        self._SegmentType = params.get("SegmentType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAdaptiveDynamicStreamingTemplateResponse(AbstractModel):
    """CreateAdaptiveDynamicStreamingTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 自适应转码模板唯一标识。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateAnimatedGraphicsTemplateRequest(AbstractModel):
    """CreateAnimatedGraphicsTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Fps: 帧率，取值范围：[1, 30]，单位：Hz。
        :type Fps: int
        :param _Width: 动图宽度（或长边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :type Width: int
        :param _Height: 动图高度（或短边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :type Height: int
        :param _ResolutionAdaptive: 分辨率自适应，可选值：
<li>open：开启，此时，Width 代表视频的长边，Height 表示视频的短边；</li>
<li>close：关闭，此时，Width 代表视频的宽度，Height 表示视频的高度。</li>
默认值：open。
        :type ResolutionAdaptive: str
        :param _Format: 动图格式，取值为 gif 和 webp。默认为 gif。
        :type Format: str
        :param _Quality: 图片质量，取值范围：[1, 100]，默认值为 75。
        :type Quality: float
        :param _Name: 转动图模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Comment: 模板描述信息，长度限制：256 个字符。
        :type Comment: str
        """
        self._Fps = None
        self._Width = None
        self._Height = None
        self._ResolutionAdaptive = None
        self._Format = None
        self._Quality = None
        self._Name = None
        self._Comment = None

    @property
    def Fps(self):
        return self._Fps

    @Fps.setter
    def Fps(self, Fps):
        self._Fps = Fps

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ResolutionAdaptive(self):
        return self._ResolutionAdaptive

    @ResolutionAdaptive.setter
    def ResolutionAdaptive(self, ResolutionAdaptive):
        self._ResolutionAdaptive = ResolutionAdaptive

    @property
    def Format(self):
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def Quality(self):
        return self._Quality

    @Quality.setter
    def Quality(self, Quality):
        self._Quality = Quality

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment


    def _deserialize(self, params):
        self._Fps = params.get("Fps")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._ResolutionAdaptive = params.get("ResolutionAdaptive")
        self._Format = params.get("Format")
        self._Quality = params.get("Quality")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAnimatedGraphicsTemplateResponse(AbstractModel):
    """CreateAnimatedGraphicsTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 转动图模板唯一标识。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateContentReviewTemplateRequest(AbstractModel):
    """CreateContentReviewTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 内容审核模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Comment: 内容审核模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _PornConfigure: 令人反感的信息的控制参数。
        :type PornConfigure: :class:`tencentcloud.mps.v20190612.models.PornConfigureInfo`
        :param _TerrorismConfigure: 令人不安全的信息的控制参数。
        :type TerrorismConfigure: :class:`tencentcloud.mps.v20190612.models.TerrorismConfigureInfo`
        :param _PoliticalConfigure: 令人不适宜的信息的控制参数。
        :type PoliticalConfigure: :class:`tencentcloud.mps.v20190612.models.PoliticalConfigureInfo`
        :param _ProhibitedConfigure: 违禁控制参数。违禁内容包括：
<li>谩骂；</li>
<li>涉毒违法。</li>
注意：此参数尚未支持。
        :type ProhibitedConfigure: :class:`tencentcloud.mps.v20190612.models.ProhibitedConfigureInfo`
        :param _UserDefineConfigure: 用户自定义内容审核控制参数。
        :type UserDefineConfigure: :class:`tencentcloud.mps.v20190612.models.UserDefineConfigureInfo`
        """
        self._Name = None
        self._Comment = None
        self._PornConfigure = None
        self._TerrorismConfigure = None
        self._PoliticalConfigure = None
        self._ProhibitedConfigure = None
        self._UserDefineConfigure = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def PornConfigure(self):
        return self._PornConfigure

    @PornConfigure.setter
    def PornConfigure(self, PornConfigure):
        self._PornConfigure = PornConfigure

    @property
    def TerrorismConfigure(self):
        return self._TerrorismConfigure

    @TerrorismConfigure.setter
    def TerrorismConfigure(self, TerrorismConfigure):
        self._TerrorismConfigure = TerrorismConfigure

    @property
    def PoliticalConfigure(self):
        return self._PoliticalConfigure

    @PoliticalConfigure.setter
    def PoliticalConfigure(self, PoliticalConfigure):
        self._PoliticalConfigure = PoliticalConfigure

    @property
    def ProhibitedConfigure(self):
        return self._ProhibitedConfigure

    @ProhibitedConfigure.setter
    def ProhibitedConfigure(self, ProhibitedConfigure):
        self._ProhibitedConfigure = ProhibitedConfigure

    @property
    def UserDefineConfigure(self):
        return self._UserDefineConfigure

    @UserDefineConfigure.setter
    def UserDefineConfigure(self, UserDefineConfigure):
        self._UserDefineConfigure = UserDefineConfigure


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("PornConfigure") is not None:
            self._PornConfigure = PornConfigureInfo()
            self._PornConfigure._deserialize(params.get("PornConfigure"))
        if params.get("TerrorismConfigure") is not None:
            self._TerrorismConfigure = TerrorismConfigureInfo()
            self._TerrorismConfigure._deserialize(params.get("TerrorismConfigure"))
        if params.get("PoliticalConfigure") is not None:
            self._PoliticalConfigure = PoliticalConfigureInfo()
            self._PoliticalConfigure._deserialize(params.get("PoliticalConfigure"))
        if params.get("ProhibitedConfigure") is not None:
            self._ProhibitedConfigure = ProhibitedConfigureInfo()
            self._ProhibitedConfigure._deserialize(params.get("ProhibitedConfigure"))
        if params.get("UserDefineConfigure") is not None:
            self._UserDefineConfigure = UserDefineConfigureInfo()
            self._UserDefineConfigure._deserialize(params.get("UserDefineConfigure"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateContentReviewTemplateResponse(AbstractModel):
    """CreateContentReviewTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 内容审核模板唯一标识。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateImageSpriteTemplateRequest(AbstractModel):
    """CreateImageSpriteTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SampleType: 采样类型，取值：
<li>Percent：按百分比。</li>
<li>Time：按时间间隔。</li>
        :type SampleType: str
        :param _SampleInterval: 采样间隔。
<li>当 SampleType 为 Percent 时，指定采样间隔的百分比。</li>
<li>当 SampleType 为 Time 时，指定采样间隔的时间，单位为秒。</li>
        :type SampleInterval: int
        :param _RowCount: 雪碧图中小图的行数。
        :type RowCount: int
        :param _ColumnCount: 雪碧图中小图的列数。
        :type ColumnCount: int
        :param _Name: 雪碧图模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Width: 雪碧图中小图的宽度（或长边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :type Width: int
        :param _Height: 雪碧图中小图的高度（或短边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :type Height: int
        :param _ResolutionAdaptive: 分辨率自适应，可选值：
<li>open：开启，此时，Width 代表视频的长边，Height 表示视频的短边；</li>
<li>close：关闭，此时，Width 代表视频的宽度，Height 表示视频的高度。</li>
默认值：open。
        :type ResolutionAdaptive: str
        :param _FillType: 填充方式，当视频流配置宽高参数与原始视频的宽高比不一致时，对转码的处理方式，即为“填充”。可选填充方式：
<li> stretch：拉伸，对每一帧进行拉伸，填满整个画面，可能导致转码后的视频被“压扁“或者“拉长“；</li>
<li>black：留黑，保持视频宽高比不变，边缘剩余部分使用黑色填充。</li>
默认值：black 。
        :type FillType: str
        :param _Comment: 模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _Format: 图片格式，取值为 jpg、png、webp。默认为 jpg。
        :type Format: str
        """
        self._SampleType = None
        self._SampleInterval = None
        self._RowCount = None
        self._ColumnCount = None
        self._Name = None
        self._Width = None
        self._Height = None
        self._ResolutionAdaptive = None
        self._FillType = None
        self._Comment = None
        self._Format = None

    @property
    def SampleType(self):
        return self._SampleType

    @SampleType.setter
    def SampleType(self, SampleType):
        self._SampleType = SampleType

    @property
    def SampleInterval(self):
        return self._SampleInterval

    @SampleInterval.setter
    def SampleInterval(self, SampleInterval):
        self._SampleInterval = SampleInterval

    @property
    def RowCount(self):
        return self._RowCount

    @RowCount.setter
    def RowCount(self, RowCount):
        self._RowCount = RowCount

    @property
    def ColumnCount(self):
        return self._ColumnCount

    @ColumnCount.setter
    def ColumnCount(self, ColumnCount):
        self._ColumnCount = ColumnCount

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ResolutionAdaptive(self):
        return self._ResolutionAdaptive

    @ResolutionAdaptive.setter
    def ResolutionAdaptive(self, ResolutionAdaptive):
        self._ResolutionAdaptive = ResolutionAdaptive

    @property
    def FillType(self):
        return self._FillType

    @FillType.setter
    def FillType(self, FillType):
        self._FillType = FillType

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def Format(self):
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format


    def _deserialize(self, params):
        self._SampleType = params.get("SampleType")
        self._SampleInterval = params.get("SampleInterval")
        self._RowCount = params.get("RowCount")
        self._ColumnCount = params.get("ColumnCount")
        self._Name = params.get("Name")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._ResolutionAdaptive = params.get("ResolutionAdaptive")
        self._FillType = params.get("FillType")
        self._Comment = params.get("Comment")
        self._Format = params.get("Format")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateImageSpriteTemplateResponse(AbstractModel):
    """CreateImageSpriteTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 雪碧图模板唯一标识。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateInput(AbstractModel):
    """创建输入的配置信息。

    """

    def __init__(self):
        r"""
        :param _InputName: 输入名称，可填大小写、数字和下划线，长度为[1, 32]。
        :type InputName: str
        :param _Protocol: 输入的协议，可选[SRT|RTP|RTMP|RTMP_PULL]。
        :type Protocol: str
        :param _Description: 输入描述，长度为[0, 255]。
        :type Description: str
        :param _AllowIpList: 输入的IP白名单，格式为CIDR。
        :type AllowIpList: list of str
        :param _SRTSettings: 输入的SRT配置信息。
        :type SRTSettings: :class:`tencentcloud.mps.v20190612.models.CreateInputSRTSettings`
        :param _RTPSettings: 输入的RTP配置信息。
        :type RTPSettings: :class:`tencentcloud.mps.v20190612.models.CreateInputRTPSettings`
        :param _FailOver: 输入的主备开关，可选[OPEN|CLOSE]，默认为CLOSE。
        :type FailOver: str
        :param _RTMPPullSettings: 输入的RTMP_PULL配置信息。
        :type RTMPPullSettings: :class:`tencentcloud.mps.v20190612.models.CreateInputRTMPPullSettings`
        :param _RTSPPullSettings: 输入的RTSP_PULL配置信息。
        :type RTSPPullSettings: :class:`tencentcloud.mps.v20190612.models.CreateInputRTSPPullSettings`
        :param _HLSPullSettings: 输入的HLS_PULL配置信息。
        :type HLSPullSettings: :class:`tencentcloud.mps.v20190612.models.CreateInputHLSPullSettings`
        :param _ResilientStream: 延播平滑吐流配置信息。
        :type ResilientStream: :class:`tencentcloud.mps.v20190612.models.ResilientStreamConf`
        :param _SecurityGroupIds: 绑定的输入安全组 ID。 
        :type SecurityGroupIds: list of str
        :param _Zones: 可用区，非必填，如果开启容灾必须输入两个不同的可用区，否则最多只允许输入一个可用区。	
        :type Zones: list of str
        """
        self._InputName = None
        self._Protocol = None
        self._Description = None
        self._AllowIpList = None
        self._SRTSettings = None
        self._RTPSettings = None
        self._FailOver = None
        self._RTMPPullSettings = None
        self._RTSPPullSettings = None
        self._HLSPullSettings = None
        self._ResilientStream = None
        self._SecurityGroupIds = None
        self._Zones = None

    @property
    def InputName(self):
        return self._InputName

    @InputName.setter
    def InputName(self, InputName):
        self._InputName = InputName

    @property
    def Protocol(self):
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def AllowIpList(self):
        return self._AllowIpList

    @AllowIpList.setter
    def AllowIpList(self, AllowIpList):
        self._AllowIpList = AllowIpList

    @property
    def SRTSettings(self):
        return self._SRTSettings

    @SRTSettings.setter
    def SRTSettings(self, SRTSettings):
        self._SRTSettings = SRTSettings

    @property
    def RTPSettings(self):
        return self._RTPSettings

    @RTPSettings.setter
    def RTPSettings(self, RTPSettings):
        self._RTPSettings = RTPSettings

    @property
    def FailOver(self):
        return self._FailOver

    @FailOver.setter
    def FailOver(self, FailOver):
        self._FailOver = FailOver

    @property
    def RTMPPullSettings(self):
        return self._RTMPPullSettings

    @RTMPPullSettings.setter
    def RTMPPullSettings(self, RTMPPullSettings):
        self._RTMPPullSettings = RTMPPullSettings

    @property
    def RTSPPullSettings(self):
        return self._RTSPPullSettings

    @RTSPPullSettings.setter
    def RTSPPullSettings(self, RTSPPullSettings):
        self._RTSPPullSettings = RTSPPullSettings

    @property
    def HLSPullSettings(self):
        return self._HLSPullSettings

    @HLSPullSettings.setter
    def HLSPullSettings(self, HLSPullSettings):
        self._HLSPullSettings = HLSPullSettings

    @property
    def ResilientStream(self):
        return self._ResilientStream

    @ResilientStream.setter
    def ResilientStream(self, ResilientStream):
        self._ResilientStream = ResilientStream

    @property
    def SecurityGroupIds(self):
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds

    @property
    def Zones(self):
        return self._Zones

    @Zones.setter
    def Zones(self, Zones):
        self._Zones = Zones


    def _deserialize(self, params):
        self._InputName = params.get("InputName")
        self._Protocol = params.get("Protocol")
        self._Description = params.get("Description")
        self._AllowIpList = params.get("AllowIpList")
        if params.get("SRTSettings") is not None:
            self._SRTSettings = CreateInputSRTSettings()
            self._SRTSettings._deserialize(params.get("SRTSettings"))
        if params.get("RTPSettings") is not None:
            self._RTPSettings = CreateInputRTPSettings()
            self._RTPSettings._deserialize(params.get("RTPSettings"))
        self._FailOver = params.get("FailOver")
        if params.get("RTMPPullSettings") is not None:
            self._RTMPPullSettings = CreateInputRTMPPullSettings()
            self._RTMPPullSettings._deserialize(params.get("RTMPPullSettings"))
        if params.get("RTSPPullSettings") is not None:
            self._RTSPPullSettings = CreateInputRTSPPullSettings()
            self._RTSPPullSettings._deserialize(params.get("RTSPPullSettings"))
        if params.get("HLSPullSettings") is not None:
            self._HLSPullSettings = CreateInputHLSPullSettings()
            self._HLSPullSettings._deserialize(params.get("HLSPullSettings"))
        if params.get("ResilientStream") is not None:
            self._ResilientStream = ResilientStreamConf()
            self._ResilientStream._deserialize(params.get("ResilientStream"))
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        self._Zones = params.get("Zones")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateInputHLSPullSettings(AbstractModel):
    """创建的输入HLS拉流的配置信息。

    """

    def __init__(self):
        r"""
        :param _SourceAddresses: HLS源站的源站地址，有且只能有一个。
        :type SourceAddresses: list of HLSPullSourceAddress
        """
        self._SourceAddresses = None

    @property
    def SourceAddresses(self):
        return self._SourceAddresses

    @SourceAddresses.setter
    def SourceAddresses(self, SourceAddresses):
        self._SourceAddresses = SourceAddresses


    def _deserialize(self, params):
        if params.get("SourceAddresses") is not None:
            self._SourceAddresses = []
            for item in params.get("SourceAddresses"):
                obj = HLSPullSourceAddress()
                obj._deserialize(item)
                self._SourceAddresses.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateInputRTMPPullSettings(AbstractModel):
    """创建的输入RTMP拉流的配置信息。

    """

    def __init__(self):
        r"""
        :param _SourceAddresses: RTMP源站的源站地址，有且只能有一个。
        :type SourceAddresses: list of RTMPPullSourceAddress
        """
        self._SourceAddresses = None

    @property
    def SourceAddresses(self):
        return self._SourceAddresses

    @SourceAddresses.setter
    def SourceAddresses(self, SourceAddresses):
        self._SourceAddresses = SourceAddresses


    def _deserialize(self, params):
        if params.get("SourceAddresses") is not None:
            self._SourceAddresses = []
            for item in params.get("SourceAddresses"):
                obj = RTMPPullSourceAddress()
                obj._deserialize(item)
                self._SourceAddresses.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateInputRTPSettings(AbstractModel):
    """创建输入的RTP配置信息。

    """

    def __init__(self):
        r"""
        :param _FEC: 默认为“none”，可选值['none']。
        :type FEC: str
        :param _IdleTimeout: 空闲超时时间，默认5000，单位ms，范围为[1000, 10000]。
        :type IdleTimeout: int
        """
        self._FEC = None
        self._IdleTimeout = None

    @property
    def FEC(self):
        return self._FEC

    @FEC.setter
    def FEC(self, FEC):
        self._FEC = FEC

    @property
    def IdleTimeout(self):
        return self._IdleTimeout

    @IdleTimeout.setter
    def IdleTimeout(self, IdleTimeout):
        self._IdleTimeout = IdleTimeout


    def _deserialize(self, params):
        self._FEC = params.get("FEC")
        self._IdleTimeout = params.get("IdleTimeout")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateInputRTSPPullSettings(AbstractModel):
    """创建的输入RTSP拉流的配置信息。

    """

    def __init__(self):
        r"""
        :param _SourceAddresses: RTSP源站的源站地址，有且只能有一个。
        :type SourceAddresses: list of RTSPPullSourceAddress
        """
        self._SourceAddresses = None

    @property
    def SourceAddresses(self):
        return self._SourceAddresses

    @SourceAddresses.setter
    def SourceAddresses(self, SourceAddresses):
        self._SourceAddresses = SourceAddresses


    def _deserialize(self, params):
        if params.get("SourceAddresses") is not None:
            self._SourceAddresses = []
            for item in params.get("SourceAddresses"):
                obj = RTSPPullSourceAddress()
                obj._deserialize(item)
                self._SourceAddresses.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateInputSRTSettings(AbstractModel):
    """创建的输入SRT的配置信息。

    """

    def __init__(self):
        r"""
        :param _Mode: SRT模式，可选[LISTENER|CALLER]，默认为LISTENER。
        :type Mode: str
        :param _StreamId: 流Id，可选大小写字母、数字和特殊字符（.#!:&,=_-），长度为0~512。具体格式可以参考：https://github.com/Haivision/srt/blob/master/docs/features/access-control.md#standard-keys。
        :type StreamId: str
        :param _Latency: 延迟，默认0，单位ms，范围为[0, 3000]。
        :type Latency: int
        :param _RecvLatency: 接收延迟，默认120，单位ms，范围为[0, 3000]。
        :type RecvLatency: int
        :param _PeerLatency: 对端延迟，默认0，单位ms，范围为[0, 3000]。
        :type PeerLatency: int
        :param _PeerIdleTimeout: 对端超时时间，默认5000，单位ms，范围为[1000, 10000]。
        :type PeerIdleTimeout: int
        :param _Passphrase: 解密密钥，默认为空，表示不加密。只可填ascii码值，长度为[10, 79]。
        :type Passphrase: str
        :param _PbKeyLen: 密钥长度，默认为0，可选[0|16|24|32]。
        :type PbKeyLen: int
        :param _SourceAddresses: SRT对端地址，当Mode为CALLER时必填，且只能填1组。
        :type SourceAddresses: list of SRTSourceAddressReq
        """
        self._Mode = None
        self._StreamId = None
        self._Latency = None
        self._RecvLatency = None
        self._PeerLatency = None
        self._PeerIdleTimeout = None
        self._Passphrase = None
        self._PbKeyLen = None
        self._SourceAddresses = None

    @property
    def Mode(self):
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def StreamId(self):
        return self._StreamId

    @StreamId.setter
    def StreamId(self, StreamId):
        self._StreamId = StreamId

    @property
    def Latency(self):
        return self._Latency

    @Latency.setter
    def Latency(self, Latency):
        self._Latency = Latency

    @property
    def RecvLatency(self):
        return self._RecvLatency

    @RecvLatency.setter
    def RecvLatency(self, RecvLatency):
        self._RecvLatency = RecvLatency

    @property
    def PeerLatency(self):
        return self._PeerLatency

    @PeerLatency.setter
    def PeerLatency(self, PeerLatency):
        self._PeerLatency = PeerLatency

    @property
    def PeerIdleTimeout(self):
        return self._PeerIdleTimeout

    @PeerIdleTimeout.setter
    def PeerIdleTimeout(self, PeerIdleTimeout):
        self._PeerIdleTimeout = PeerIdleTimeout

    @property
    def Passphrase(self):
        return self._Passphrase

    @Passphrase.setter
    def Passphrase(self, Passphrase):
        self._Passphrase = Passphrase

    @property
    def PbKeyLen(self):
        return self._PbKeyLen

    @PbKeyLen.setter
    def PbKeyLen(self, PbKeyLen):
        self._PbKeyLen = PbKeyLen

    @property
    def SourceAddresses(self):
        return self._SourceAddresses

    @SourceAddresses.setter
    def SourceAddresses(self, SourceAddresses):
        self._SourceAddresses = SourceAddresses


    def _deserialize(self, params):
        self._Mode = params.get("Mode")
        self._StreamId = params.get("StreamId")
        self._Latency = params.get("Latency")
        self._RecvLatency = params.get("RecvLatency")
        self._PeerLatency = params.get("PeerLatency")
        self._PeerIdleTimeout = params.get("PeerIdleTimeout")
        self._Passphrase = params.get("Passphrase")
        self._PbKeyLen = params.get("PbKeyLen")
        if params.get("SourceAddresses") is not None:
            self._SourceAddresses = []
            for item in params.get("SourceAddresses"):
                obj = SRTSourceAddressReq()
                obj._deserialize(item)
                self._SourceAddresses.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOutputInfo(AbstractModel):
    """创建输出的配置信息。

    """

    def __init__(self):
        r"""
        :param _OutputName: 输出的名称。
        :type OutputName: str
        :param _Description: 输出描述。
        :type Description: str
        :param _Protocol: 输出协议，可选[SRT|RTP|RTMP|RTMP_PULL]。
        :type Protocol: str
        :param _OutputRegion: 输出地区。
        :type OutputRegion: str
        :param _SRTSettings: 输出的SRT的配置。
        :type SRTSettings: :class:`tencentcloud.mps.v20190612.models.CreateOutputSRTSettings`
        :param _RTMPSettings: 输出的RTMP的配置。
        :type RTMPSettings: :class:`tencentcloud.mps.v20190612.models.CreateOutputRTMPSettings`
        :param _RTPSettings: 输出的RTP的配置。
        :type RTPSettings: :class:`tencentcloud.mps.v20190612.models.CreateOutputInfoRTPSettings`
        :param _AllowIpList: IP白名单列表，格式为CIDR，如0.0.0.0/0。
当Protocol为RTMP_PULL有效，为空代表不限制客户端IP。
        :type AllowIpList: list of str
        :param _MaxConcurrent: 最大拉流并发数，最大4，默认4。
        :type MaxConcurrent: int
        :param _SecurityGroupIds: 绑定的输入安全组 ID。 
        :type SecurityGroupIds: list of str
        :param _Zones: 可用区，output最多只支持输入一个可用区。	
        :type Zones: list of str
        """
        self._OutputName = None
        self._Description = None
        self._Protocol = None
        self._OutputRegion = None
        self._SRTSettings = None
        self._RTMPSettings = None
        self._RTPSettings = None
        self._AllowIpList = None
        self._MaxConcurrent = None
        self._SecurityGroupIds = None
        self._Zones = None

    @property
    def OutputName(self):
        return self._OutputName

    @OutputName.setter
    def OutputName(self, OutputName):
        self._OutputName = OutputName

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Protocol(self):
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def OutputRegion(self):
        return self._OutputRegion

    @OutputRegion.setter
    def OutputRegion(self, OutputRegion):
        self._OutputRegion = OutputRegion

    @property
    def SRTSettings(self):
        return self._SRTSettings

    @SRTSettings.setter
    def SRTSettings(self, SRTSettings):
        self._SRTSettings = SRTSettings

    @property
    def RTMPSettings(self):
        return self._RTMPSettings

    @RTMPSettings.setter
    def RTMPSettings(self, RTMPSettings):
        self._RTMPSettings = RTMPSettings

    @property
    def RTPSettings(self):
        return self._RTPSettings

    @RTPSettings.setter
    def RTPSettings(self, RTPSettings):
        self._RTPSettings = RTPSettings

    @property
    def AllowIpList(self):
        return self._AllowIpList

    @AllowIpList.setter
    def AllowIpList(self, AllowIpList):
        self._AllowIpList = AllowIpList

    @property
    def MaxConcurrent(self):
        return self._MaxConcurrent

    @MaxConcurrent.setter
    def MaxConcurrent(self, MaxConcurrent):
        self._MaxConcurrent = MaxConcurrent

    @property
    def SecurityGroupIds(self):
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds

    @property
    def Zones(self):
        return self._Zones

    @Zones.setter
    def Zones(self, Zones):
        self._Zones = Zones


    def _deserialize(self, params):
        self._OutputName = params.get("OutputName")
        self._Description = params.get("Description")
        self._Protocol = params.get("Protocol")
        self._OutputRegion = params.get("OutputRegion")
        if params.get("SRTSettings") is not None:
            self._SRTSettings = CreateOutputSRTSettings()
            self._SRTSettings._deserialize(params.get("SRTSettings"))
        if params.get("RTMPSettings") is not None:
            self._RTMPSettings = CreateOutputRTMPSettings()
            self._RTMPSettings._deserialize(params.get("RTMPSettings"))
        if params.get("RTPSettings") is not None:
            self._RTPSettings = CreateOutputInfoRTPSettings()
            self._RTPSettings._deserialize(params.get("RTPSettings"))
        self._AllowIpList = params.get("AllowIpList")
        self._MaxConcurrent = params.get("MaxConcurrent")
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        self._Zones = params.get("Zones")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOutputInfoRTPSettings(AbstractModel):
    """创建媒体传输流的输出的RTP配置。

    """

    def __init__(self):
        r"""
        :param _Destinations: 转推的目标地址，可填1~2个。
        :type Destinations: list of CreateOutputRTPSettingsDestinations
        :param _FEC: 只能填none。
        :type FEC: str
        :param _IdleTimeout: 空闲超时时间，单位ms。
        :type IdleTimeout: int
        """
        self._Destinations = None
        self._FEC = None
        self._IdleTimeout = None

    @property
    def Destinations(self):
        return self._Destinations

    @Destinations.setter
    def Destinations(self, Destinations):
        self._Destinations = Destinations

    @property
    def FEC(self):
        return self._FEC

    @FEC.setter
    def FEC(self, FEC):
        self._FEC = FEC

    @property
    def IdleTimeout(self):
        return self._IdleTimeout

    @IdleTimeout.setter
    def IdleTimeout(self, IdleTimeout):
        self._IdleTimeout = IdleTimeout


    def _deserialize(self, params):
        if params.get("Destinations") is not None:
            self._Destinations = []
            for item in params.get("Destinations"):
                obj = CreateOutputRTPSettingsDestinations()
                obj._deserialize(item)
                self._Destinations.append(obj)
        self._FEC = params.get("FEC")
        self._IdleTimeout = params.get("IdleTimeout")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOutputRTMPSettings(AbstractModel):
    """创建媒体传输流的输出的RTMP配置。

    """

    def __init__(self):
        r"""
        :param _Destinations: 转推的目标地址，可填1~2个。
        :type Destinations: list of CreateOutputRtmpSettingsDestinations
        :param _ChunkSize: RTMP的Chunk大小，范围为[4096, 40960]。
        :type ChunkSize: int
        """
        self._Destinations = None
        self._ChunkSize = None

    @property
    def Destinations(self):
        return self._Destinations

    @Destinations.setter
    def Destinations(self, Destinations):
        self._Destinations = Destinations

    @property
    def ChunkSize(self):
        return self._ChunkSize

    @ChunkSize.setter
    def ChunkSize(self, ChunkSize):
        self._ChunkSize = ChunkSize


    def _deserialize(self, params):
        if params.get("Destinations") is not None:
            self._Destinations = []
            for item in params.get("Destinations"):
                obj = CreateOutputRtmpSettingsDestinations()
                obj._deserialize(item)
                self._Destinations.append(obj)
        self._ChunkSize = params.get("ChunkSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOutputRTPSettingsDestinations(AbstractModel):
    """创建媒体传输流的输出的RTP的目标地址。

    """

    def __init__(self):
        r"""
        :param _Ip: 转推的目标IP。
        :type Ip: str
        :param _Port: 转推的目标端口。
        :type Port: int
        """
        self._Ip = None
        self._Port = None

    @property
    def Ip(self):
        return self._Ip

    @Ip.setter
    def Ip(self, Ip):
        self._Ip = Ip

    @property
    def Port(self):
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port


    def _deserialize(self, params):
        self._Ip = params.get("Ip")
        self._Port = params.get("Port")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOutputRtmpSettingsDestinations(AbstractModel):
    """创建媒体传输流的输出的RTMP的目标地址。

    """

    def __init__(self):
        r"""
        :param _Url: 转推的URL，格式如：rtmp://domain/live。
        :type Url: str
        :param _StreamKey: 转推的StreamKey，格式如：stream?key=value。
        :type StreamKey: str
        """
        self._Url = None
        self._StreamKey = None

    @property
    def Url(self):
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def StreamKey(self):
        return self._StreamKey

    @StreamKey.setter
    def StreamKey(self, StreamKey):
        self._StreamKey = StreamKey


    def _deserialize(self, params):
        self._Url = params.get("Url")
        self._StreamKey = params.get("StreamKey")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOutputSRTSettings(AbstractModel):
    """创建媒体传输流的输出的SRT配置。

    """

    def __init__(self):
        r"""
        :param _Destinations: 转推的目标地址，当Mode为CALLER时必填，且只能填1组。
        :type Destinations: list of CreateOutputSRTSettingsDestinations
        :param _StreamId: 转推SRT的流Id，可选大小写字母、数字和特殊字符（.#!:&,=_-），长度为0~512。
        :type StreamId: str
        :param _Latency: 转推SRT的总延迟，默认0，单位ms，范围为[0, 3000]。
        :type Latency: int
        :param _RecvLatency: 转推SRT的接收延迟，默认120，单位ms，范围为[0, 3000]。
        :type RecvLatency: int
        :param _PeerLatency: 转推SRT的对端延迟，默认0，单位ms，范围为[0, 3000]。
        :type PeerLatency: int
        :param _PeerIdleTimeout: 转推SRT的对端空闲超时时间，默认5000，单位ms，范围为[1000, 10000]。
        :type PeerIdleTimeout: int
        :param _Passphrase: 转推SRT的加密密钥，默认为空，表示不加密。只可填ascii码值，长度为[10, 79]。
        :type Passphrase: str
        :param _PbKeyLen: 转推SRT的密钥长度，默认为0，可选[0|16|24|32]。
        :type PbKeyLen: int
        :param _Mode: SRT模式，可选[LISTENER|CALLER]，默认为CALLER。
        :type Mode: str
        """
        self._Destinations = None
        self._StreamId = None
        self._Latency = None
        self._RecvLatency = None
        self._PeerLatency = None
        self._PeerIdleTimeout = None
        self._Passphrase = None
        self._PbKeyLen = None
        self._Mode = None

    @property
    def Destinations(self):
        return self._Destinations

    @Destinations.setter
    def Destinations(self, Destinations):
        self._Destinations = Destinations

    @property
    def StreamId(self):
        return self._StreamId

    @StreamId.setter
    def StreamId(self, StreamId):
        self._StreamId = StreamId

    @property
    def Latency(self):
        return self._Latency

    @Latency.setter
    def Latency(self, Latency):
        self._Latency = Latency

    @property
    def RecvLatency(self):
        return self._RecvLatency

    @RecvLatency.setter
    def RecvLatency(self, RecvLatency):
        self._RecvLatency = RecvLatency

    @property
    def PeerLatency(self):
        return self._PeerLatency

    @PeerLatency.setter
    def PeerLatency(self, PeerLatency):
        self._PeerLatency = PeerLatency

    @property
    def PeerIdleTimeout(self):
        return self._PeerIdleTimeout

    @PeerIdleTimeout.setter
    def PeerIdleTimeout(self, PeerIdleTimeout):
        self._PeerIdleTimeout = PeerIdleTimeout

    @property
    def Passphrase(self):
        return self._Passphrase

    @Passphrase.setter
    def Passphrase(self, Passphrase):
        self._Passphrase = Passphrase

    @property
    def PbKeyLen(self):
        return self._PbKeyLen

    @PbKeyLen.setter
    def PbKeyLen(self, PbKeyLen):
        self._PbKeyLen = PbKeyLen

    @property
    def Mode(self):
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode


    def _deserialize(self, params):
        if params.get("Destinations") is not None:
            self._Destinations = []
            for item in params.get("Destinations"):
                obj = CreateOutputSRTSettingsDestinations()
                obj._deserialize(item)
                self._Destinations.append(obj)
        self._StreamId = params.get("StreamId")
        self._Latency = params.get("Latency")
        self._RecvLatency = params.get("RecvLatency")
        self._PeerLatency = params.get("PeerLatency")
        self._PeerIdleTimeout = params.get("PeerIdleTimeout")
        self._Passphrase = params.get("Passphrase")
        self._PbKeyLen = params.get("PbKeyLen")
        self._Mode = params.get("Mode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOutputSRTSettingsDestinations(AbstractModel):
    """创建媒体传输流的输出SRT的目标地址。

    """

    def __init__(self):
        r"""
        :param _Ip: 输出的IP。
        :type Ip: str
        :param _Port: 输出的端口。
        :type Port: int
        """
        self._Ip = None
        self._Port = None

    @property
    def Ip(self):
        return self._Ip

    @Ip.setter
    def Ip(self, Ip):
        self._Ip = Ip

    @property
    def Port(self):
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port


    def _deserialize(self, params):
        self._Ip = params.get("Ip")
        self._Port = params.get("Port")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreatePersonSampleRequest(AbstractModel):
    """CreatePersonSample请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 素材名称，长度限制：20 个字符。
        :type Name: str
        :param _Usages: 素材应用场景，可选值：
1. Recognition：用于内容识别，等价于 Recognition.Face。
2. Review：用于不适宜内容识别，等价于 Review.Face。
3. All：包含以上全部，等价于 1+2。
        :type Usages: list of str
        :param _Description: 素材描述，长度限制：1024 个字符。
        :type Description: str
        :param _FaceContents: 素材图片 [Base64](https://tools.ietf.org/html/rfc4648) 编码后的字符串，仅支持 jpeg、png 图片格式。数组长度限制：5 张图片。
注意：图片必须是单人像五官较清晰的照片，像素不低于 200*200。
        :type FaceContents: list of str
        :param _Tags: 素材标签
<li>数组长度限制：20 个标签；</li>
<li>单个标签长度限制：128 个字符。</li>
        :type Tags: list of str
        """
        self._Name = None
        self._Usages = None
        self._Description = None
        self._FaceContents = None
        self._Tags = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Usages(self):
        return self._Usages

    @Usages.setter
    def Usages(self, Usages):
        self._Usages = Usages

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def FaceContents(self):
        return self._FaceContents

    @FaceContents.setter
    def FaceContents(self, FaceContents):
        self._FaceContents = FaceContents

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Usages = params.get("Usages")
        self._Description = params.get("Description")
        self._FaceContents = params.get("FaceContents")
        self._Tags = params.get("Tags")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreatePersonSampleResponse(AbstractModel):
    """CreatePersonSample返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Person: 素材信息。
        :type Person: :class:`tencentcloud.mps.v20190612.models.AiSamplePerson`
        :param _FailFaceInfoSet: 处理失败的五官定位信息。
        :type FailFaceInfoSet: list of AiSampleFailFaceInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Person = None
        self._FailFaceInfoSet = None
        self._RequestId = None

    @property
    def Person(self):
        return self._Person

    @Person.setter
    def Person(self, Person):
        self._Person = Person

    @property
    def FailFaceInfoSet(self):
        return self._FailFaceInfoSet

    @FailFaceInfoSet.setter
    def FailFaceInfoSet(self, FailFaceInfoSet):
        self._FailFaceInfoSet = FailFaceInfoSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Person") is not None:
            self._Person = AiSamplePerson()
            self._Person._deserialize(params.get("Person"))
        if params.get("FailFaceInfoSet") is not None:
            self._FailFaceInfoSet = []
            for item in params.get("FailFaceInfoSet"):
                obj = AiSampleFailFaceInfo()
                obj._deserialize(item)
                self._FailFaceInfoSet.append(obj)
        self._RequestId = params.get("RequestId")


class CreateQualityControlTemplateRequest(AbstractModel):
    """CreateQualityControlTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 媒体质检模板名称，长度限制：64 个字符。
        :type Name: str
        :param _QualityControlItemSet: 媒体质检控制参数。
        :type QualityControlItemSet: list of QualityControlItemConfig
        :param _Comment: 媒体质检模板描述信息，长度限制：256 个字符。
        :type Comment: str
        """
        self._Name = None
        self._QualityControlItemSet = None
        self._Comment = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def QualityControlItemSet(self):
        return self._QualityControlItemSet

    @QualityControlItemSet.setter
    def QualityControlItemSet(self, QualityControlItemSet):
        self._QualityControlItemSet = QualityControlItemSet

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment


    def _deserialize(self, params):
        self._Name = params.get("Name")
        if params.get("QualityControlItemSet") is not None:
            self._QualityControlItemSet = []
            for item in params.get("QualityControlItemSet"):
                obj = QualityControlItemConfig()
                obj._deserialize(item)
                self._QualityControlItemSet.append(obj)
        self._Comment = params.get("Comment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateQualityControlTemplateResponse(AbstractModel):
    """CreateQualityControlTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 媒体质检模板唯一标识。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateSampleSnapshotTemplateRequest(AbstractModel):
    """CreateSampleSnapshotTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SampleType: 采样截图类型，取值：
<li>Percent：按百分比。</li>
<li>Time：按时间间隔。</li>
        :type SampleType: str
        :param _SampleInterval: 采样间隔。
<li>当 SampleType 为 Percent 时，指定采样间隔的百分比。</li>
<li>当 SampleType 为 Time 时，指定采样间隔的时间，单位为秒。</li>
        :type SampleInterval: int
        :param _Name: 采样截图模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Width: 截图宽度（或长边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :type Width: int
        :param _Height: 截图高度（或短边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :type Height: int
        :param _ResolutionAdaptive: 分辨率自适应，可选值：
<li>open：开启，此时，Width 代表视频的长边，Height 表示视频的短边；</li>
<li>close：关闭，此时，Width 代表视频的宽度，Height 表示视频的高度。</li>
默认值：open。
        :type ResolutionAdaptive: str
        :param _Format: 图片格式，取值为 jpg、png、webp。默认为 jpg。
        :type Format: str
        :param _Comment: 模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _FillType: 填充方式，当视频流配置宽高参数与原始视频的宽高比不一致时，对转码的处理方式，即为“填充”。可选填充方式：
<li> stretch：拉伸，对每一帧进行拉伸，填满整个画面，可能导致转码后的视频被“压扁“或者“拉长“；</li>
<li>black：留黑，保持视频宽高比不变，边缘剩余部分使用黑色填充。</li>
<li>white：留白，保持视频宽高比不变，边缘剩余部分使用白色填充。</li>
<li>gauss：高斯模糊，保持视频宽高比不变，边缘剩余部分使用高斯模糊。</li>
默认值：black 。
        :type FillType: str
        """
        self._SampleType = None
        self._SampleInterval = None
        self._Name = None
        self._Width = None
        self._Height = None
        self._ResolutionAdaptive = None
        self._Format = None
        self._Comment = None
        self._FillType = None

    @property
    def SampleType(self):
        return self._SampleType

    @SampleType.setter
    def SampleType(self, SampleType):
        self._SampleType = SampleType

    @property
    def SampleInterval(self):
        return self._SampleInterval

    @SampleInterval.setter
    def SampleInterval(self, SampleInterval):
        self._SampleInterval = SampleInterval

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ResolutionAdaptive(self):
        return self._ResolutionAdaptive

    @ResolutionAdaptive.setter
    def ResolutionAdaptive(self, ResolutionAdaptive):
        self._ResolutionAdaptive = ResolutionAdaptive

    @property
    def Format(self):
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def FillType(self):
        return self._FillType

    @FillType.setter
    def FillType(self, FillType):
        self._FillType = FillType


    def _deserialize(self, params):
        self._SampleType = params.get("SampleType")
        self._SampleInterval = params.get("SampleInterval")
        self._Name = params.get("Name")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._ResolutionAdaptive = params.get("ResolutionAdaptive")
        self._Format = params.get("Format")
        self._Comment = params.get("Comment")
        self._FillType = params.get("FillType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSampleSnapshotTemplateResponse(AbstractModel):
    """CreateSampleSnapshotTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 采样截图模板唯一标识。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateScheduleRequest(AbstractModel):
    """CreateSchedule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ScheduleName: 编排名称，最多128字符。同一个用户该名称唯一。
        :type ScheduleName: str
        :param _Trigger: 编排绑定的触发规则，当上传视频命中该规则到该对象时即触发编排。
        :type Trigger: :class:`tencentcloud.mps.v20190612.models.WorkflowTrigger`
        :param _Activities: 编排任务列表。
        :type Activities: list of Activity
        :param _OutputStorage: 媒体处理的文件输出存储位置。不填则继承 Trigger 中的存储位置。
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _OutputDir: 媒体处理生成的文件输出的目标目录，必选以 / 开头和结尾，如`/movie/201907/`。
如果不填，表示与触发文件所在的目录一致。
        :type OutputDir: str
        :param _TaskNotifyConfig: 任务的事件通知配置，不填代表不获取事件通知。
        :type TaskNotifyConfig: :class:`tencentcloud.mps.v20190612.models.TaskNotifyConfig`
        :param _ResourceId: 资源ID，需要保证对应资源是开启状态。默认为帐号主资源ID。
        :type ResourceId: str
        """
        self._ScheduleName = None
        self._Trigger = None
        self._Activities = None
        self._OutputStorage = None
        self._OutputDir = None
        self._TaskNotifyConfig = None
        self._ResourceId = None

    @property
    def ScheduleName(self):
        return self._ScheduleName

    @ScheduleName.setter
    def ScheduleName(self, ScheduleName):
        self._ScheduleName = ScheduleName

    @property
    def Trigger(self):
        return self._Trigger

    @Trigger.setter
    def Trigger(self, Trigger):
        self._Trigger = Trigger

    @property
    def Activities(self):
        return self._Activities

    @Activities.setter
    def Activities(self, Activities):
        self._Activities = Activities

    @property
    def OutputStorage(self):
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage

    @property
    def OutputDir(self):
        return self._OutputDir

    @OutputDir.setter
    def OutputDir(self, OutputDir):
        self._OutputDir = OutputDir

    @property
    def TaskNotifyConfig(self):
        return self._TaskNotifyConfig

    @TaskNotifyConfig.setter
    def TaskNotifyConfig(self, TaskNotifyConfig):
        self._TaskNotifyConfig = TaskNotifyConfig

    @property
    def ResourceId(self):
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId


    def _deserialize(self, params):
        self._ScheduleName = params.get("ScheduleName")
        if params.get("Trigger") is not None:
            self._Trigger = WorkflowTrigger()
            self._Trigger._deserialize(params.get("Trigger"))
        if params.get("Activities") is not None:
            self._Activities = []
            for item in params.get("Activities"):
                obj = Activity()
                obj._deserialize(item)
                self._Activities.append(obj)
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        self._OutputDir = params.get("OutputDir")
        if params.get("TaskNotifyConfig") is not None:
            self._TaskNotifyConfig = TaskNotifyConfig()
            self._TaskNotifyConfig._deserialize(params.get("TaskNotifyConfig"))
        self._ResourceId = params.get("ResourceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateScheduleResponse(AbstractModel):
    """CreateSchedule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ScheduleId: 编排 ID。
        :type ScheduleId: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ScheduleId = None
        self._RequestId = None

    @property
    def ScheduleId(self):
        return self._ScheduleId

    @ScheduleId.setter
    def ScheduleId(self, ScheduleId):
        self._ScheduleId = ScheduleId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ScheduleId = params.get("ScheduleId")
        self._RequestId = params.get("RequestId")


class CreateSnapshotByTimeOffsetTemplateRequest(AbstractModel):
    """CreateSnapshotByTimeOffsetTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 指定时间点截图模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Width: 截图宽度（或长边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :type Width: int
        :param _Height: 截图高度（或短边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :type Height: int
        :param _ResolutionAdaptive: 分辨率自适应，可选值：
<li>open：开启，此时，Width 代表视频的长边，Height 表示视频的短边；</li>
<li>close：关闭，此时，Width 代表视频的宽度，Height 表示视频的高度。</li>
默认值：open。
        :type ResolutionAdaptive: str
        :param _Format: 图片格式，取值可以为 jpg、png、webp。默认为 jpg。
        :type Format: str
        :param _Comment: 模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _FillType: 填充方式，当视频流配置宽高参数与原始视频的宽高比不一致时，对转码的处理方式，即为“填充”。可选填充方式：
<li> stretch：拉伸，对每一帧进行拉伸，填满整个画面，可能导致转码后的视频被“压扁“或者“拉长“；</li>
<li>black：留黑，保持视频宽高比不变，边缘剩余部分使用黑色填充。</li>
<li>white：留白，保持视频宽高比不变，边缘剩余部分使用白色填充。</li>
<li>gauss：高斯模糊，保持视频宽高比不变，边缘剩余部分使用高斯模糊。</li>
默认值：black 。
        :type FillType: str
        """
        self._Name = None
        self._Width = None
        self._Height = None
        self._ResolutionAdaptive = None
        self._Format = None
        self._Comment = None
        self._FillType = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ResolutionAdaptive(self):
        return self._ResolutionAdaptive

    @ResolutionAdaptive.setter
    def ResolutionAdaptive(self, ResolutionAdaptive):
        self._ResolutionAdaptive = ResolutionAdaptive

    @property
    def Format(self):
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def FillType(self):
        return self._FillType

    @FillType.setter
    def FillType(self, FillType):
        self._FillType = FillType


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._ResolutionAdaptive = params.get("ResolutionAdaptive")
        self._Format = params.get("Format")
        self._Comment = params.get("Comment")
        self._FillType = params.get("FillType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSnapshotByTimeOffsetTemplateResponse(AbstractModel):
    """CreateSnapshotByTimeOffsetTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 时间点截图模板唯一标识。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateStreamLinkEventRequest(AbstractModel):
    """CreateStreamLinkEvent请求参数结构体

    """

    def __init__(self):
        r"""
        :param _EventName: 事件名称。
        :type EventName: str
        :param _Description: 事件描述。
        :type Description: str
        """
        self._EventName = None
        self._Description = None

    @property
    def EventName(self):
        return self._EventName

    @EventName.setter
    def EventName(self, EventName):
        self._EventName = EventName

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._EventName = params.get("EventName")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateStreamLinkEventResponse(AbstractModel):
    """CreateStreamLinkEvent返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Info: 创建的Event信息。
        :type Info: :class:`tencentcloud.mps.v20190612.models.DescribeEvent`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Info = None
        self._RequestId = None

    @property
    def Info(self):
        return self._Info

    @Info.setter
    def Info(self, Info):
        self._Info = Info

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Info") is not None:
            self._Info = DescribeEvent()
            self._Info._deserialize(params.get("Info"))
        self._RequestId = params.get("RequestId")


class CreateStreamLinkFlowRequest(AbstractModel):
    """CreateStreamLinkFlow请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FlowName: 流名称。
        :type FlowName: str
        :param _MaxBandwidth: 最大带宽，单位bps，可选[10000000, 20000000, 50000000]。
        :type MaxBandwidth: int
        :param _InputGroup: 流的输入组。
        :type InputGroup: list of CreateInput
        :param _EventId: 该Flow关联的媒体传输事件ID，每个flow只能关联一个Event。
        :type EventId: str
        """
        self._FlowName = None
        self._MaxBandwidth = None
        self._InputGroup = None
        self._EventId = None

    @property
    def FlowName(self):
        return self._FlowName

    @FlowName.setter
    def FlowName(self, FlowName):
        self._FlowName = FlowName

    @property
    def MaxBandwidth(self):
        return self._MaxBandwidth

    @MaxBandwidth.setter
    def MaxBandwidth(self, MaxBandwidth):
        self._MaxBandwidth = MaxBandwidth

    @property
    def InputGroup(self):
        return self._InputGroup

    @InputGroup.setter
    def InputGroup(self, InputGroup):
        self._InputGroup = InputGroup

    @property
    def EventId(self):
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId


    def _deserialize(self, params):
        self._FlowName = params.get("FlowName")
        self._MaxBandwidth = params.get("MaxBandwidth")
        if params.get("InputGroup") is not None:
            self._InputGroup = []
            for item in params.get("InputGroup"):
                obj = CreateInput()
                obj._deserialize(item)
                self._InputGroup.append(obj)
        self._EventId = params.get("EventId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateStreamLinkFlowResponse(AbstractModel):
    """CreateStreamLinkFlow返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Info: 创建的Flow信息。
        :type Info: :class:`tencentcloud.mps.v20190612.models.DescribeFlow`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Info = None
        self._RequestId = None

    @property
    def Info(self):
        return self._Info

    @Info.setter
    def Info(self, Info):
        self._Info = Info

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Info") is not None:
            self._Info = DescribeFlow()
            self._Info._deserialize(params.get("Info"))
        self._RequestId = params.get("RequestId")


class CreateStreamLinkInputRequest(AbstractModel):
    """CreateStreamLinkInput请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FlowId: 媒体传输流ID。
        :type FlowId: str
        :param _InputGroup: 流的输入组。
        :type InputGroup: list of CreateInput
        """
        self._FlowId = None
        self._InputGroup = None

    @property
    def FlowId(self):
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def InputGroup(self):
        return self._InputGroup

    @InputGroup.setter
    def InputGroup(self, InputGroup):
        self._InputGroup = InputGroup


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        if params.get("InputGroup") is not None:
            self._InputGroup = []
            for item in params.get("InputGroup"):
                obj = CreateInput()
                obj._deserialize(item)
                self._InputGroup.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateStreamLinkInputResponse(AbstractModel):
    """CreateStreamLinkInput返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Info: 创建的Flow信息。
        :type Info: :class:`tencentcloud.mps.v20190612.models.DescribeFlow`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Info = None
        self._RequestId = None

    @property
    def Info(self):
        return self._Info

    @Info.setter
    def Info(self, Info):
        self._Info = Info

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Info") is not None:
            self._Info = DescribeFlow()
            self._Info._deserialize(params.get("Info"))
        self._RequestId = params.get("RequestId")


class CreateStreamLinkOutputInfoRequest(AbstractModel):
    """CreateStreamLinkOutputInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FlowId: 传输流Id。
        :type FlowId: str
        :param _Output: 传输流的Output配置。
        :type Output: :class:`tencentcloud.mps.v20190612.models.CreateOutputInfo`
        """
        self._FlowId = None
        self._Output = None

    @property
    def FlowId(self):
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        if params.get("Output") is not None:
            self._Output = CreateOutputInfo()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateStreamLinkOutputInfoResponse(AbstractModel):
    """CreateStreamLinkOutputInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Info: 创建后的Output信息。
        :type Info: :class:`tencentcloud.mps.v20190612.models.DescribeOutput`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Info = None
        self._RequestId = None

    @property
    def Info(self):
        return self._Info

    @Info.setter
    def Info(self, Info):
        self._Info = Info

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Info") is not None:
            self._Info = DescribeOutput()
            self._Info._deserialize(params.get("Info"))
        self._RequestId = params.get("RequestId")


class CreateTranscodeTemplateRequest(AbstractModel):
    """CreateTranscodeTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Container: 封装格式，可选值：mp4、flv、hls、ts、webm、mkv、mxf、mov、mp3、flac、ogg、m4a。其中，mp3、flac、ogg、m4a 为纯音频文件。
        :type Container: str
        :param _Name: 转码模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Comment: 模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _RemoveVideo: 是否去除视频数据，可选值：
<li>0：保留</li>
<li>1：去除</li>
默认值：0。
        :type RemoveVideo: int
        :param _RemoveAudio: 是否去除音频数据，可选值：
<li>0：保留</li>
<li>1：去除</li>
默认值：0。
        :type RemoveAudio: int
        :param _VideoTemplate: 视频流配置参数，当 RemoveVideo 为 0，该字段必填。
        :type VideoTemplate: :class:`tencentcloud.mps.v20190612.models.VideoTemplateInfo`
        :param _AudioTemplate: 音频流配置参数，当 RemoveAudio 为 0，该字段必填。
        :type AudioTemplate: :class:`tencentcloud.mps.v20190612.models.AudioTemplateInfo`
        :param _TEHDConfig: 极速高清转码参数。
        :type TEHDConfig: :class:`tencentcloud.mps.v20190612.models.TEHDConfig`
        :param _EnhanceConfig: 音视频增强配置。
        :type EnhanceConfig: :class:`tencentcloud.mps.v20190612.models.EnhanceConfig`
        """
        self._Container = None
        self._Name = None
        self._Comment = None
        self._RemoveVideo = None
        self._RemoveAudio = None
        self._VideoTemplate = None
        self._AudioTemplate = None
        self._TEHDConfig = None
        self._EnhanceConfig = None

    @property
    def Container(self):
        return self._Container

    @Container.setter
    def Container(self, Container):
        self._Container = Container

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def RemoveVideo(self):
        return self._RemoveVideo

    @RemoveVideo.setter
    def RemoveVideo(self, RemoveVideo):
        self._RemoveVideo = RemoveVideo

    @property
    def RemoveAudio(self):
        return self._RemoveAudio

    @RemoveAudio.setter
    def RemoveAudio(self, RemoveAudio):
        self._RemoveAudio = RemoveAudio

    @property
    def VideoTemplate(self):
        return self._VideoTemplate

    @VideoTemplate.setter
    def VideoTemplate(self, VideoTemplate):
        self._VideoTemplate = VideoTemplate

    @property
    def AudioTemplate(self):
        return self._AudioTemplate

    @AudioTemplate.setter
    def AudioTemplate(self, AudioTemplate):
        self._AudioTemplate = AudioTemplate

    @property
    def TEHDConfig(self):
        return self._TEHDConfig

    @TEHDConfig.setter
    def TEHDConfig(self, TEHDConfig):
        self._TEHDConfig = TEHDConfig

    @property
    def EnhanceConfig(self):
        return self._EnhanceConfig

    @EnhanceConfig.setter
    def EnhanceConfig(self, EnhanceConfig):
        self._EnhanceConfig = EnhanceConfig


    def _deserialize(self, params):
        self._Container = params.get("Container")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        self._RemoveVideo = params.get("RemoveVideo")
        self._RemoveAudio = params.get("RemoveAudio")
        if params.get("VideoTemplate") is not None:
            self._VideoTemplate = VideoTemplateInfo()
            self._VideoTemplate._deserialize(params.get("VideoTemplate"))
        if params.get("AudioTemplate") is not None:
            self._AudioTemplate = AudioTemplateInfo()
            self._AudioTemplate._deserialize(params.get("AudioTemplate"))
        if params.get("TEHDConfig") is not None:
            self._TEHDConfig = TEHDConfig()
            self._TEHDConfig._deserialize(params.get("TEHDConfig"))
        if params.get("EnhanceConfig") is not None:
            self._EnhanceConfig = EnhanceConfig()
            self._EnhanceConfig._deserialize(params.get("EnhanceConfig"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateTranscodeTemplateResponse(AbstractModel):
    """CreateTranscodeTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 转码模板唯一标识。
        :type Definition: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateWatermarkTemplateRequest(AbstractModel):
    """CreateWatermarkTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Type: 水印类型，可选值：
<li>image：图片水印；</li>
<li>text：文字水印；</li>
<li>svg：SVG 水印。</li>
        :type Type: str
        :param _Name: 水印模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Comment: 模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _CoordinateOrigin: 原点位置，可选值：
<li>TopLeft：表示坐标原点位于视频图像左上角，水印原点为图片或文字的左上角；</li>
<li>TopRight：表示坐标原点位于视频图像的右上角，水印原点为图片或文字的右上角；</li>
<li>BottomLeft：表示坐标原点位于视频图像的左下角，水印原点为图片或文字的左下角；</li>
<li>BottomRight：表示坐标原点位于视频图像的右下角，水印原点为图片或文字的右下角。</li>
默认值：TopLeft。
        :type CoordinateOrigin: str
        :param _XPos: 水印原点距离视频图像坐标原点的水平位置。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示水印 XPos 为视频宽度指定百分比，如 10% 表示 XPos 为视频宽度的 10%；</li>
<li>当字符串以 px 结尾，表示水印 XPos 为指定像素，如 100px 表示 XPos 为 100 像素。</li>
默认值：0px。
        :type XPos: str
        :param _YPos: 水印原点距离视频图像坐标原点的垂直位置。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示水印 YPos 为视频高度指定百分比，如 10% 表示 YPos 为视频高度的 10%；</li>
<li>当字符串以 px 结尾，表示水印 YPos 为指定像素，如 100px 表示 YPos 为 100 像素。</li>
默认值：0px。
        :type YPos: str
        :param _ImageTemplate: 图片水印模板，仅当 Type 为 image，该字段必填且有效。
        :type ImageTemplate: :class:`tencentcloud.mps.v20190612.models.ImageWatermarkInput`
        :param _TextTemplate: 文字水印模板，仅当 Type 为 text，该字段必填且有效。
        :type TextTemplate: :class:`tencentcloud.mps.v20190612.models.TextWatermarkTemplateInput`
        :param _SvgTemplate: SVG 水印模板，仅当 Type 为 svg，该字段必填且有效。
        :type SvgTemplate: :class:`tencentcloud.mps.v20190612.models.SvgWatermarkInput`
        """
        self._Type = None
        self._Name = None
        self._Comment = None
        self._CoordinateOrigin = None
        self._XPos = None
        self._YPos = None
        self._ImageTemplate = None
        self._TextTemplate = None
        self._SvgTemplate = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def CoordinateOrigin(self):
        return self._CoordinateOrigin

    @CoordinateOrigin.setter
    def CoordinateOrigin(self, CoordinateOrigin):
        self._CoordinateOrigin = CoordinateOrigin

    @property
    def XPos(self):
        return self._XPos

    @XPos.setter
    def XPos(self, XPos):
        self._XPos = XPos

    @property
    def YPos(self):
        return self._YPos

    @YPos.setter
    def YPos(self, YPos):
        self._YPos = YPos

    @property
    def ImageTemplate(self):
        return self._ImageTemplate

    @ImageTemplate.setter
    def ImageTemplate(self, ImageTemplate):
        self._ImageTemplate = ImageTemplate

    @property
    def TextTemplate(self):
        return self._TextTemplate

    @TextTemplate.setter
    def TextTemplate(self, TextTemplate):
        self._TextTemplate = TextTemplate

    @property
    def SvgTemplate(self):
        return self._SvgTemplate

    @SvgTemplate.setter
    def SvgTemplate(self, SvgTemplate):
        self._SvgTemplate = SvgTemplate


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        self._CoordinateOrigin = params.get("CoordinateOrigin")
        self._XPos = params.get("XPos")
        self._YPos = params.get("YPos")
        if params.get("ImageTemplate") is not None:
            self._ImageTemplate = ImageWatermarkInput()
            self._ImageTemplate._deserialize(params.get("ImageTemplate"))
        if params.get("TextTemplate") is not None:
            self._TextTemplate = TextWatermarkTemplateInput()
            self._TextTemplate._deserialize(params.get("TextTemplate"))
        if params.get("SvgTemplate") is not None:
            self._SvgTemplate = SvgWatermarkInput()
            self._SvgTemplate._deserialize(params.get("SvgTemplate"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateWatermarkTemplateResponse(AbstractModel):
    """CreateWatermarkTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 水印模板唯一标识。
        :type Definition: int
        :param _ImageUrl: 水印图片地址，仅当 Type 为 image，该字段有效。
        :type ImageUrl: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Definition = None
        self._ImageUrl = None
        self._RequestId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def ImageUrl(self):
        return self._ImageUrl

    @ImageUrl.setter
    def ImageUrl(self, ImageUrl):
        self._ImageUrl = ImageUrl

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._ImageUrl = params.get("ImageUrl")
        self._RequestId = params.get("RequestId")


class CreateWordSamplesRequest(AbstractModel):
    """CreateWordSamples请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Usages: <b>关键词应用场景，可选值：</b>
1. Recognition.Ocr：通过光学字符识别技术，进行内容识别；
2. Recognition.Asr：通过音频识别技术，进行内容识别；
3. Review.Ocr：通过光学字符识别技术，进行不适宜内容识别；
4. Review.Asr：通过音频识别技术，进行不适宜内容识别；
<b>可合并简写为：</b>
5. Recognition：通过光学字符识别技术、音频识别技术，进行内容识别，等价于 1+2；
6. Review：通过光学字符识别技术、音频识别技术，进行不适宜内容识别，等价于 3+4；
7. All：通过光学字符识别技术、音频识别技术，进行内容识别、不适宜内容识别，等价于 1+2+3+4。
        :type Usages: list of str
        :param _Words: 关键词，数组长度限制：100。
        :type Words: list of AiSampleWordInfo
        """
        self._Usages = None
        self._Words = None

    @property
    def Usages(self):
        return self._Usages

    @Usages.setter
    def Usages(self, Usages):
        self._Usages = Usages

    @property
    def Words(self):
        return self._Words

    @Words.setter
    def Words(self, Words):
        self._Words = Words


    def _deserialize(self, params):
        self._Usages = params.get("Usages")
        if params.get("Words") is not None:
            self._Words = []
            for item in params.get("Words"):
                obj = AiSampleWordInfo()
                obj._deserialize(item)
                self._Words.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateWordSamplesResponse(AbstractModel):
    """CreateWordSamples返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateWorkflowRequest(AbstractModel):
    """CreateWorkflow请求参数结构体

    """

    def __init__(self):
        r"""
        :param _WorkflowName: 工作流名称，最多128字符。同一个用户该名称唯一。
        :type WorkflowName: str
        :param _Trigger: 工作流绑定的触发规则，当上传视频命中该规则到该对象时即触发工作流。
        :type Trigger: :class:`tencentcloud.mps.v20190612.models.WorkflowTrigger`
        :param _OutputStorage: 媒体处理的文件输出存储位置。不填则继承 Trigger 中的存储位置。
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _OutputDir: 媒体处理生成的文件输出的目标目录，必选以 / 开头和结尾，如`/movie/201907/`。
如果不填，表示与触发文件所在的目录一致。
        :type OutputDir: str
        :param _MediaProcessTask: 媒体处理类型任务参数。
        :type MediaProcessTask: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskInput`
        :param _AiContentReviewTask: 视频内容审核类型任务参数。
        :type AiContentReviewTask: :class:`tencentcloud.mps.v20190612.models.AiContentReviewTaskInput`
        :param _AiAnalysisTask: 视频内容分析类型任务参数。
        :type AiAnalysisTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskInput`
        :param _AiRecognitionTask: 视频内容识别类型任务参数。
        :type AiRecognitionTask: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskInput`
        :param _TaskNotifyConfig: 任务的事件通知配置，不填代表不获取事件通知。
        :type TaskNotifyConfig: :class:`tencentcloud.mps.v20190612.models.TaskNotifyConfig`
        :param _TaskPriority: 工作流的优先级，数值越大优先级越高，取值范围是 -10 到 10，不填代表 0。
        :type TaskPriority: int
        """
        self._WorkflowName = None
        self._Trigger = None
        self._OutputStorage = None
        self._OutputDir = None
        self._MediaProcessTask = None
        self._AiContentReviewTask = None
        self._AiAnalysisTask = None
        self._AiRecognitionTask = None
        self._TaskNotifyConfig = None
        self._TaskPriority = None

    @property
    def WorkflowName(self):
        return self._WorkflowName

    @WorkflowName.setter
    def WorkflowName(self, WorkflowName):
        self._WorkflowName = WorkflowName

    @property
    def Trigger(self):
        return self._Trigger

    @Trigger.setter
    def Trigger(self, Trigger):
        self._Trigger = Trigger

    @property
    def OutputStorage(self):
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage

    @property
    def OutputDir(self):
        return self._OutputDir

    @OutputDir.setter
    def OutputDir(self, OutputDir):
        self._OutputDir = OutputDir

    @property
    def MediaProcessTask(self):
        return self._MediaProcessTask

    @MediaProcessTask.setter
    def MediaProcessTask(self, MediaProcessTask):
        self._MediaProcessTask = MediaProcessTask

    @property
    def AiContentReviewTask(self):
        return self._AiContentReviewTask

    @AiContentReviewTask.setter
    def AiContentReviewTask(self, AiContentReviewTask):
        self._AiContentReviewTask = AiContentReviewTask

    @property
    def AiAnalysisTask(self):
        return self._AiAnalysisTask

    @AiAnalysisTask.setter
    def AiAnalysisTask(self, AiAnalysisTask):
        self._AiAnalysisTask = AiAnalysisTask

    @property
    def AiRecognitionTask(self):
        return self._AiRecognitionTask

    @AiRecognitionTask.setter
    def AiRecognitionTask(self, AiRecognitionTask):
        self._AiRecognitionTask = AiRecognitionTask

    @property
    def TaskNotifyConfig(self):
        return self._TaskNotifyConfig

    @TaskNotifyConfig.setter
    def TaskNotifyConfig(self, TaskNotifyConfig):
        self._TaskNotifyConfig = TaskNotifyConfig

    @property
    def TaskPriority(self):
        return self._TaskPriority

    @TaskPriority.setter
    def TaskPriority(self, TaskPriority):
        self._TaskPriority = TaskPriority


    def _deserialize(self, params):
        self._WorkflowName = params.get("WorkflowName")
        if params.get("Trigger") is not None:
            self._Trigger = WorkflowTrigger()
            self._Trigger._deserialize(params.get("Trigger"))
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        self._OutputDir = params.get("OutputDir")
        if params.get("MediaProcessTask") is not None:
            self._MediaProcessTask = MediaProcessTaskInput()
            self._MediaProcessTask._deserialize(params.get("MediaProcessTask"))
        if params.get("AiContentReviewTask") is not None:
            self._AiContentReviewTask = AiContentReviewTaskInput()
            self._AiContentReviewTask._deserialize(params.get("AiContentReviewTask"))
        if params.get("AiAnalysisTask") is not None:
            self._AiAnalysisTask = AiAnalysisTaskInput()
            self._AiAnalysisTask._deserialize(params.get("AiAnalysisTask"))
        if params.get("AiRecognitionTask") is not None:
            self._AiRecognitionTask = AiRecognitionTaskInput()
            self._AiRecognitionTask._deserialize(params.get("AiRecognitionTask"))
        if params.get("TaskNotifyConfig") is not None:
            self._TaskNotifyConfig = TaskNotifyConfig()
            self._TaskNotifyConfig._deserialize(params.get("TaskNotifyConfig"))
        self._TaskPriority = params.get("TaskPriority")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateWorkflowResponse(AbstractModel):
    """CreateWorkflow返回参数结构体

    """

    def __init__(self):
        r"""
        :param _WorkflowId: 工作流 ID。
        :type WorkflowId: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._WorkflowId = None
        self._RequestId = None

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._WorkflowId = params.get("WorkflowId")
        self._RequestId = params.get("RequestId")


class DeleteAIAnalysisTemplateRequest(AbstractModel):
    """DeleteAIAnalysisTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 视频内容分析模板唯一标识。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAIAnalysisTemplateResponse(AbstractModel):
    """DeleteAIAnalysisTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteAIRecognitionTemplateRequest(AbstractModel):
    """DeleteAIRecognitionTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 视频内容识别模板唯一标识。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAIRecognitionTemplateResponse(AbstractModel):
    """DeleteAIRecognitionTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteAdaptiveDynamicStreamingTemplateRequest(AbstractModel):
    """DeleteAdaptiveDynamicStreamingTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 自适应转码模板唯一标识。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAdaptiveDynamicStreamingTemplateResponse(AbstractModel):
    """DeleteAdaptiveDynamicStreamingTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteAnimatedGraphicsTemplateRequest(AbstractModel):
    """DeleteAnimatedGraphicsTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 转动图模板唯一标识。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAnimatedGraphicsTemplateResponse(AbstractModel):
    """DeleteAnimatedGraphicsTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteContentReviewTemplateRequest(AbstractModel):
    """DeleteContentReviewTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 内容审核模板唯一标识。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteContentReviewTemplateResponse(AbstractModel):
    """DeleteContentReviewTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteImageSpriteTemplateRequest(AbstractModel):
    """DeleteImageSpriteTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 雪碧图模板唯一标识。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteImageSpriteTemplateResponse(AbstractModel):
    """DeleteImageSpriteTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeletePersonSampleRequest(AbstractModel):
    """DeletePersonSample请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PersonId: 素材 ID。
        :type PersonId: str
        """
        self._PersonId = None

    @property
    def PersonId(self):
        return self._PersonId

    @PersonId.setter
    def PersonId(self, PersonId):
        self._PersonId = PersonId


    def _deserialize(self, params):
        self._PersonId = params.get("PersonId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeletePersonSampleResponse(AbstractModel):
    """DeletePersonSample返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteQualityControlTemplateRequest(AbstractModel):
    """DeleteQualityControlTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 媒体质检模板唯一标识。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteQualityControlTemplateResponse(AbstractModel):
    """DeleteQualityControlTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteSampleSnapshotTemplateRequest(AbstractModel):
    """DeleteSampleSnapshotTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 采样截图模板唯一标识。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSampleSnapshotTemplateResponse(AbstractModel):
    """DeleteSampleSnapshotTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteScheduleRequest(AbstractModel):
    """DeleteSchedule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ScheduleId: 编排唯一标识。
        :type ScheduleId: int
        """
        self._ScheduleId = None

    @property
    def ScheduleId(self):
        return self._ScheduleId

    @ScheduleId.setter
    def ScheduleId(self, ScheduleId):
        self._ScheduleId = ScheduleId


    def _deserialize(self, params):
        self._ScheduleId = params.get("ScheduleId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteScheduleResponse(AbstractModel):
    """DeleteSchedule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteSnapshotByTimeOffsetTemplateRequest(AbstractModel):
    """DeleteSnapshotByTimeOffsetTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 指定时间点截图模板唯一标识。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSnapshotByTimeOffsetTemplateResponse(AbstractModel):
    """DeleteSnapshotByTimeOffsetTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteStreamLinkEventRequest(AbstractModel):
    """DeleteStreamLinkEvent请求参数结构体

    """

    def __init__(self):
        r"""
        :param _EventId: 媒体传输事件Id，删除前需要保证该Event关联的所有Flow都已经删除。
        :type EventId: str
        """
        self._EventId = None

    @property
    def EventId(self):
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId


    def _deserialize(self, params):
        self._EventId = params.get("EventId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteStreamLinkEventResponse(AbstractModel):
    """DeleteStreamLinkEvent返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteStreamLinkFlowRequest(AbstractModel):
    """DeleteStreamLinkFlow请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FlowId: 传输流Id。
        :type FlowId: str
        """
        self._FlowId = None

    @property
    def FlowId(self):
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteStreamLinkFlowResponse(AbstractModel):
    """DeleteStreamLinkFlow返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteStreamLinkOutputRequest(AbstractModel):
    """DeleteStreamLinkOutput请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FlowId: 流Id。
        :type FlowId: str
        :param _OutputId: 输出Id。
        :type OutputId: str
        """
        self._FlowId = None
        self._OutputId = None

    @property
    def FlowId(self):
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def OutputId(self):
        return self._OutputId

    @OutputId.setter
    def OutputId(self, OutputId):
        self._OutputId = OutputId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._OutputId = params.get("OutputId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteStreamLinkOutputResponse(AbstractModel):
    """DeleteStreamLinkOutput返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteTranscodeTemplateRequest(AbstractModel):
    """DeleteTranscodeTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 转码模板唯一标识。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteTranscodeTemplateResponse(AbstractModel):
    """DeleteTranscodeTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteWatermarkTemplateRequest(AbstractModel):
    """DeleteWatermarkTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 水印模板唯一标识。
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteWatermarkTemplateResponse(AbstractModel):
    """DeleteWatermarkTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteWordSamplesRequest(AbstractModel):
    """DeleteWordSamples请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Keywords: 关键词，数组长度限制：100 个词。
        :type Keywords: list of str
        """
        self._Keywords = None

    @property
    def Keywords(self):
        return self._Keywords

    @Keywords.setter
    def Keywords(self, Keywords):
        self._Keywords = Keywords


    def _deserialize(self, params):
        self._Keywords = params.get("Keywords")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteWordSamplesResponse(AbstractModel):
    """DeleteWordSamples返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteWorkflowRequest(AbstractModel):
    """DeleteWorkflow请求参数结构体

    """

    def __init__(self):
        r"""
        :param _WorkflowId: 工作流 ID。
        :type WorkflowId: int
        """
        self._WorkflowId = None

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId


    def _deserialize(self, params):
        self._WorkflowId = params.get("WorkflowId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteWorkflowResponse(AbstractModel):
    """DeleteWorkflow返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DescribeAIAnalysisTemplatesRequest(AbstractModel):
    """DescribeAIAnalysisTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definitions: 视频内容分析模板唯一标识过滤条件，数组长度限制：10。
        :type Definitions: list of int
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        :param _Type: 模板类型过滤条件，不填则返回所有，可选值：
* Preset：系统预置模板；
* Custom：用户自定义模板。
        :type Type: str
        """
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None

    @property
    def Definitions(self):
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAIAnalysisTemplatesResponse(AbstractModel):
    """DescribeAIAnalysisTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _AIAnalysisTemplateSet: 视频内容分析模板详情列表。
        :type AIAnalysisTemplateSet: list of AIAnalysisTemplateItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._AIAnalysisTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AIAnalysisTemplateSet(self):
        return self._AIAnalysisTemplateSet

    @AIAnalysisTemplateSet.setter
    def AIAnalysisTemplateSet(self, AIAnalysisTemplateSet):
        self._AIAnalysisTemplateSet = AIAnalysisTemplateSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AIAnalysisTemplateSet") is not None:
            self._AIAnalysisTemplateSet = []
            for item in params.get("AIAnalysisTemplateSet"):
                obj = AIAnalysisTemplateItem()
                obj._deserialize(item)
                self._AIAnalysisTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAIRecognitionTemplatesRequest(AbstractModel):
    """DescribeAIRecognitionTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definitions: 视频内容识别模板唯一标识过滤条件，数组长度限制：10。
        :type Definitions: list of int
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：50。
        :type Limit: int
        :param _Type: 模板类型过滤条件，不填则返回所有，可选值：
* Preset：系统预置模板；
* Custom：用户自定义模板。
        :type Type: str
        """
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None

    @property
    def Definitions(self):
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAIRecognitionTemplatesResponse(AbstractModel):
    """DescribeAIRecognitionTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _AIRecognitionTemplateSet: 视频内容识别模板详情列表。
        :type AIRecognitionTemplateSet: list of AIRecognitionTemplateItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._AIRecognitionTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AIRecognitionTemplateSet(self):
        return self._AIRecognitionTemplateSet

    @AIRecognitionTemplateSet.setter
    def AIRecognitionTemplateSet(self, AIRecognitionTemplateSet):
        self._AIRecognitionTemplateSet = AIRecognitionTemplateSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AIRecognitionTemplateSet") is not None:
            self._AIRecognitionTemplateSet = []
            for item in params.get("AIRecognitionTemplateSet"):
                obj = AIRecognitionTemplateItem()
                obj._deserialize(item)
                self._AIRecognitionTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAdaptiveDynamicStreamingTemplatesRequest(AbstractModel):
    """DescribeAdaptiveDynamicStreamingTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definitions: 转自适应码流模板唯一标识过滤条件，数组长度限制：100。
        :type Definitions: list of int non-negative
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        :param _Type: 模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :type Type: str
        :param _PureAudio: 是否为纯音频，0表示视频，1表示纯音频
        :type PureAudio: int
        """
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None
        self._PureAudio = None

    @property
    def Definitions(self):
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def PureAudio(self):
        return self._PureAudio

    @PureAudio.setter
    def PureAudio(self, PureAudio):
        self._PureAudio = PureAudio


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        self._PureAudio = params.get("PureAudio")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAdaptiveDynamicStreamingTemplatesResponse(AbstractModel):
    """DescribeAdaptiveDynamicStreamingTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _AdaptiveDynamicStreamingTemplateSet: 转自适应码流模板详情列表。
        :type AdaptiveDynamicStreamingTemplateSet: list of AdaptiveDynamicStreamingTemplate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._AdaptiveDynamicStreamingTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AdaptiveDynamicStreamingTemplateSet(self):
        return self._AdaptiveDynamicStreamingTemplateSet

    @AdaptiveDynamicStreamingTemplateSet.setter
    def AdaptiveDynamicStreamingTemplateSet(self, AdaptiveDynamicStreamingTemplateSet):
        self._AdaptiveDynamicStreamingTemplateSet = AdaptiveDynamicStreamingTemplateSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AdaptiveDynamicStreamingTemplateSet") is not None:
            self._AdaptiveDynamicStreamingTemplateSet = []
            for item in params.get("AdaptiveDynamicStreamingTemplateSet"):
                obj = AdaptiveDynamicStreamingTemplate()
                obj._deserialize(item)
                self._AdaptiveDynamicStreamingTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAnimatedGraphicsTemplatesRequest(AbstractModel):
    """DescribeAnimatedGraphicsTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definitions: 转动图模板唯一标识过滤条件，数组长度限制：100。
        :type Definitions: list of int non-negative
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        :param _Type: 模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :type Type: str
        """
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None

    @property
    def Definitions(self):
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAnimatedGraphicsTemplatesResponse(AbstractModel):
    """DescribeAnimatedGraphicsTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _AnimatedGraphicsTemplateSet: 转动图模板详情列表。
        :type AnimatedGraphicsTemplateSet: list of AnimatedGraphicsTemplate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._AnimatedGraphicsTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AnimatedGraphicsTemplateSet(self):
        return self._AnimatedGraphicsTemplateSet

    @AnimatedGraphicsTemplateSet.setter
    def AnimatedGraphicsTemplateSet(self, AnimatedGraphicsTemplateSet):
        self._AnimatedGraphicsTemplateSet = AnimatedGraphicsTemplateSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AnimatedGraphicsTemplateSet") is not None:
            self._AnimatedGraphicsTemplateSet = []
            for item in params.get("AnimatedGraphicsTemplateSet"):
                obj = AnimatedGraphicsTemplate()
                obj._deserialize(item)
                self._AnimatedGraphicsTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeContentReviewTemplatesRequest(AbstractModel):
    """DescribeContentReviewTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definitions: 智能审核模板唯一标识过滤条件，数组长度限制：50。
        :type Definitions: list of int
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：50。
        :type Limit: int
        :param _Type: 模板类型过滤条件，不填则返回所有，可选值：
* Preset：系统预置模板；
* Custom：用户自定义模板。
        :type Type: str
        """
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None

    @property
    def Definitions(self):
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeContentReviewTemplatesResponse(AbstractModel):
    """DescribeContentReviewTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _ContentReviewTemplateSet: 内容审核模板详情列表。
        :type ContentReviewTemplateSet: list of ContentReviewTemplateItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._ContentReviewTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ContentReviewTemplateSet(self):
        return self._ContentReviewTemplateSet

    @ContentReviewTemplateSet.setter
    def ContentReviewTemplateSet(self, ContentReviewTemplateSet):
        self._ContentReviewTemplateSet = ContentReviewTemplateSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ContentReviewTemplateSet") is not None:
            self._ContentReviewTemplateSet = []
            for item in params.get("ContentReviewTemplateSet"):
                obj = ContentReviewTemplateItem()
                obj._deserialize(item)
                self._ContentReviewTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeEvent(AbstractModel):
    """查询Event的配置信息。

    """

    def __init__(self):
        r"""
        :param _EventName: Event的名称。
        :type EventName: str
        :param _EventId: Event的Id，唯一标识一个event。
        :type EventId: str
        :param _CreateTime: Event创建时间，格式为yyyy-MM-ddTHH:mm:ssZ。
        :type CreateTime: str
        :param _Description: Event的描述。
        :type Description: str
        :param _Status: Event的状态信息
0：未运行
1：运行中
        :type Status: int
        :param _AttachedFlowGroup: Event关联的Flow列表。
注意：此字段可能返回 null，表示取不到有效值。
        :type AttachedFlowGroup: list of DescribeFlowId
        """
        self._EventName = None
        self._EventId = None
        self._CreateTime = None
        self._Description = None
        self._Status = None
        self._AttachedFlowGroup = None

    @property
    def EventName(self):
        return self._EventName

    @EventName.setter
    def EventName(self, EventName):
        self._EventName = EventName

    @property
    def EventId(self):
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def AttachedFlowGroup(self):
        return self._AttachedFlowGroup

    @AttachedFlowGroup.setter
    def AttachedFlowGroup(self, AttachedFlowGroup):
        self._AttachedFlowGroup = AttachedFlowGroup


    def _deserialize(self, params):
        self._EventName = params.get("EventName")
        self._EventId = params.get("EventId")
        self._CreateTime = params.get("CreateTime")
        self._Description = params.get("Description")
        self._Status = params.get("Status")
        if params.get("AttachedFlowGroup") is not None:
            self._AttachedFlowGroup = []
            for item in params.get("AttachedFlowGroup"):
                obj = DescribeFlowId()
                obj._deserialize(item)
                self._AttachedFlowGroup.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFlow(AbstractModel):
    """查询Flow的配置信息。

    """

    def __init__(self):
        r"""
        :param _FlowId: 流Id。
        :type FlowId: str
        :param _FlowName: 流名称。
        :type FlowName: str
        :param _State: 流状态，目前有IDLE/RUNNING。
        :type State: str
        :param _MaxBandwidth: 最大带宽值。
        :type MaxBandwidth: int
        :param _InputGroup: 输入组。
        :type InputGroup: list of DescribeInput
        :param _OutputGroup: 输出组。
注意：此字段可能返回 null，表示取不到有效值。
        :type OutputGroup: list of DescribeOutput
        :param _EventId: 该Flow关联的媒体传输事件EventId。
        :type EventId: str
        :param _Region: 媒体传输输入流所属的区域，取值和InputRegion相同。
        :type Region: str
        """
        self._FlowId = None
        self._FlowName = None
        self._State = None
        self._MaxBandwidth = None
        self._InputGroup = None
        self._OutputGroup = None
        self._EventId = None
        self._Region = None

    @property
    def FlowId(self):
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def FlowName(self):
        return self._FlowName

    @FlowName.setter
    def FlowName(self, FlowName):
        self._FlowName = FlowName

    @property
    def State(self):
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def MaxBandwidth(self):
        return self._MaxBandwidth

    @MaxBandwidth.setter
    def MaxBandwidth(self, MaxBandwidth):
        self._MaxBandwidth = MaxBandwidth

    @property
    def InputGroup(self):
        return self._InputGroup

    @InputGroup.setter
    def InputGroup(self, InputGroup):
        self._InputGroup = InputGroup

    @property
    def OutputGroup(self):
        return self._OutputGroup

    @OutputGroup.setter
    def OutputGroup(self, OutputGroup):
        self._OutputGroup = OutputGroup

    @property
    def EventId(self):
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._FlowName = params.get("FlowName")
        self._State = params.get("State")
        self._MaxBandwidth = params.get("MaxBandwidth")
        if params.get("InputGroup") is not None:
            self._InputGroup = []
            for item in params.get("InputGroup"):
                obj = DescribeInput()
                obj._deserialize(item)
                self._InputGroup.append(obj)
        if params.get("OutputGroup") is not None:
            self._OutputGroup = []
            for item in params.get("OutputGroup"):
                obj = DescribeOutput()
                obj._deserialize(item)
                self._OutputGroup.append(obj)
        self._EventId = params.get("EventId")
        self._Region = params.get("Region")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFlowId(AbstractModel):
    """Event管理的Flow列表

    """

    def __init__(self):
        r"""
        :param _FlowId: FlowId，唯一标识一个flow。
        :type FlowId: str
        :param _Region: flow所在的区域名称。
        :type Region: str
        """
        self._FlowId = None
        self._Region = None

    @property
    def FlowId(self):
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._Region = params.get("Region")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeHLSPullSourceAddress(AbstractModel):
    """查询输入的HLS配置信息。

    """

    def __init__(self):
        r"""
        :param _Url: HLS源站的Url地址。
注意：此字段可能返回 null，表示取不到有效值。
        :type Url: str
        """
        self._Url = None

    @property
    def Url(self):
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url


    def _deserialize(self, params):
        self._Url = params.get("Url")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeImageSpriteTemplatesRequest(AbstractModel):
    """DescribeImageSpriteTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definitions: 雪碧图模板唯一标识过滤条件，数组长度限制：100。
        :type Definitions: list of int non-negative
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        :param _Type: 模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :type Type: str
        """
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None

    @property
    def Definitions(self):
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeImageSpriteTemplatesResponse(AbstractModel):
    """DescribeImageSpriteTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _ImageSpriteTemplateSet: 雪碧图模板详情列表。
        :type ImageSpriteTemplateSet: list of ImageSpriteTemplate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._ImageSpriteTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ImageSpriteTemplateSet(self):
        return self._ImageSpriteTemplateSet

    @ImageSpriteTemplateSet.setter
    def ImageSpriteTemplateSet(self, ImageSpriteTemplateSet):
        self._ImageSpriteTemplateSet = ImageSpriteTemplateSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ImageSpriteTemplateSet") is not None:
            self._ImageSpriteTemplateSet = []
            for item in params.get("ImageSpriteTemplateSet"):
                obj = ImageSpriteTemplate()
                obj._deserialize(item)
                self._ImageSpriteTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeInput(AbstractModel):
    """查询输入配置信息。

    """

    def __init__(self):
        r"""
        :param _InputId: 输入Id。
        :type InputId: str
        :param _InputName: 输入名称。
        :type InputName: str
        :param _Description: 输入描述。
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        :param _Protocol: 输入协议。
        :type Protocol: str
        :param _InputAddressList: 输入地址列表。
        :type InputAddressList: list of InputAddress
        :param _AllowIpList: 输入IP白名单列表。
        :type AllowIpList: list of str
        :param _SRTSettings: 输入的SRT配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type SRTSettings: :class:`tencentcloud.mps.v20190612.models.DescribeInputSRTSettings`
        :param _RTPSettings: 输入的RTP配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type RTPSettings: :class:`tencentcloud.mps.v20190612.models.DescribeInputRTPSettings`
        :param _InputRegion: 输入的地区。
        :type InputRegion: str
        :param _RTMPSettings: 输入的RTMP配置信息。
        :type RTMPSettings: :class:`tencentcloud.mps.v20190612.models.DescribeInputRTMPSettings`
        :param _FailOver: 输入的主备开关。
注意：此字段可能返回 null，表示取不到有效值。
        :type FailOver: str
        :param _RTMPPullSettings: 输入的RTMP_PULL配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type RTMPPullSettings: :class:`tencentcloud.mps.v20190612.models.DescribeInputRTMPPullSettings`
        :param _RTSPPullSettings: 输入的RTSP_PULL配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type RTSPPullSettings: :class:`tencentcloud.mps.v20190612.models.DescribeInputRTSPPullSettings`
        :param _HLSPullSettings: 输入的HLS_PULL配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type HLSPullSettings: :class:`tencentcloud.mps.v20190612.models.DescribeInputHLSPullSettings`
        :param _ResilientStream: 延播平滑吐流配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type ResilientStream: :class:`tencentcloud.mps.v20190612.models.ResilientStreamConf`
        :param _SecurityGroupIds: 绑定的输入安全组 ID。	
注意：此字段可能返回 null，表示取不到有效值。
        :type SecurityGroupIds: list of str
        :param _Zones: 可用区配置，开启容灾情况下最多有两个，顺序和pipeline 0、1对应，否则最多只有一个可用区。	
        :type Zones: list of str
        """
        self._InputId = None
        self._InputName = None
        self._Description = None
        self._Protocol = None
        self._InputAddressList = None
        self._AllowIpList = None
        self._SRTSettings = None
        self._RTPSettings = None
        self._InputRegion = None
        self._RTMPSettings = None
        self._FailOver = None
        self._RTMPPullSettings = None
        self._RTSPPullSettings = None
        self._HLSPullSettings = None
        self._ResilientStream = None
        self._SecurityGroupIds = None
        self._Zones = None

    @property
    def InputId(self):
        return self._InputId

    @InputId.setter
    def InputId(self, InputId):
        self._InputId = InputId

    @property
    def InputName(self):
        return self._InputName

    @InputName.setter
    def InputName(self, InputName):
        self._InputName = InputName

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Protocol(self):
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def InputAddressList(self):
        return self._InputAddressList

    @InputAddressList.setter
    def InputAddressList(self, InputAddressList):
        self._InputAddressList = InputAddressList

    @property
    def AllowIpList(self):
        return self._AllowIpList

    @AllowIpList.setter
    def AllowIpList(self, AllowIpList):
        self._AllowIpList = AllowIpList

    @property
    def SRTSettings(self):
        return self._SRTSettings

    @SRTSettings.setter
    def SRTSettings(self, SRTSettings):
        self._SRTSettings = SRTSettings

    @property
    def RTPSettings(self):
        return self._RTPSettings

    @RTPSettings.setter
    def RTPSettings(self, RTPSettings):
        self._RTPSettings = RTPSettings

    @property
    def InputRegion(self):
        return self._InputRegion

    @InputRegion.setter
    def InputRegion(self, InputRegion):
        self._InputRegion = InputRegion

    @property
    def RTMPSettings(self):
        return self._RTMPSettings

    @RTMPSettings.setter
    def RTMPSettings(self, RTMPSettings):
        self._RTMPSettings = RTMPSettings

    @property
    def FailOver(self):
        return self._FailOver

    @FailOver.setter
    def FailOver(self, FailOver):
        self._FailOver = FailOver

    @property
    def RTMPPullSettings(self):
        return self._RTMPPullSettings

    @RTMPPullSettings.setter
    def RTMPPullSettings(self, RTMPPullSettings):
        self._RTMPPullSettings = RTMPPullSettings

    @property
    def RTSPPullSettings(self):
        return self._RTSPPullSettings

    @RTSPPullSettings.setter
    def RTSPPullSettings(self, RTSPPullSettings):
        self._RTSPPullSettings = RTSPPullSettings

    @property
    def HLSPullSettings(self):
        return self._HLSPullSettings

    @HLSPullSettings.setter
    def HLSPullSettings(self, HLSPullSettings):
        self._HLSPullSettings = HLSPullSettings

    @property
    def ResilientStream(self):
        return self._ResilientStream

    @ResilientStream.setter
    def ResilientStream(self, ResilientStream):
        self._ResilientStream = ResilientStream

    @property
    def SecurityGroupIds(self):
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds

    @property
    def Zones(self):
        return self._Zones

    @Zones.setter
    def Zones(self, Zones):
        self._Zones = Zones


    def _deserialize(self, params):
        self._InputId = params.get("InputId")
        self._InputName = params.get("InputName")
        self._Description = params.get("Description")
        self._Protocol = params.get("Protocol")
        if params.get("InputAddressList") is not None:
            self._InputAddressList = []
            for item in params.get("InputAddressList"):
                obj = InputAddress()
                obj._deserialize(item)
                self._InputAddressList.append(obj)
        self._AllowIpList = params.get("AllowIpList")
        if params.get("SRTSettings") is not None:
            self._SRTSettings = DescribeInputSRTSettings()
            self._SRTSettings._deserialize(params.get("SRTSettings"))
        if params.get("RTPSettings") is not None:
            self._RTPSettings = DescribeInputRTPSettings()
            self._RTPSettings._deserialize(params.get("RTPSettings"))
        self._InputRegion = params.get("InputRegion")
        if params.get("RTMPSettings") is not None:
            self._RTMPSettings = DescribeInputRTMPSettings()
            self._RTMPSettings._deserialize(params.get("RTMPSettings"))
        self._FailOver = params.get("FailOver")
        if params.get("RTMPPullSettings") is not None:
            self._RTMPPullSettings = DescribeInputRTMPPullSettings()
            self._RTMPPullSettings._deserialize(params.get("RTMPPullSettings"))
        if params.get("RTSPPullSettings") is not None:
            self._RTSPPullSettings = DescribeInputRTSPPullSettings()
            self._RTSPPullSettings._deserialize(params.get("RTSPPullSettings"))
        if params.get("HLSPullSettings") is not None:
            self._HLSPullSettings = DescribeInputHLSPullSettings()
            self._HLSPullSettings._deserialize(params.get("HLSPullSettings"))
        if params.get("ResilientStream") is not None:
            self._ResilientStream = ResilientStreamConf()
            self._ResilientStream._deserialize(params.get("ResilientStream"))
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        self._Zones = params.get("Zones")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInputHLSPullSettings(AbstractModel):
    """查询输入的HLS配置信息。

    """

    def __init__(self):
        r"""
        :param _SourceAddresses: HLS源站地址信息。
        :type SourceAddresses: list of DescribeHLSPullSourceAddress
        """
        self._SourceAddresses = None

    @property
    def SourceAddresses(self):
        return self._SourceAddresses

    @SourceAddresses.setter
    def SourceAddresses(self, SourceAddresses):
        self._SourceAddresses = SourceAddresses


    def _deserialize(self, params):
        if params.get("SourceAddresses") is not None:
            self._SourceAddresses = []
            for item in params.get("SourceAddresses"):
                obj = DescribeHLSPullSourceAddress()
                obj._deserialize(item)
                self._SourceAddresses.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInputRTMPPullSettings(AbstractModel):
    """查询输入的RTMP配置信息。

    """

    def __init__(self):
        r"""
        :param _SourceAddresses: RTMP源站地址信息。
        :type SourceAddresses: list of DescribeRTMPPullSourceAddress
        """
        self._SourceAddresses = None

    @property
    def SourceAddresses(self):
        return self._SourceAddresses

    @SourceAddresses.setter
    def SourceAddresses(self, SourceAddresses):
        self._SourceAddresses = SourceAddresses


    def _deserialize(self, params):
        if params.get("SourceAddresses") is not None:
            self._SourceAddresses = []
            for item in params.get("SourceAddresses"):
                obj = DescribeRTMPPullSourceAddress()
                obj._deserialize(item)
                self._SourceAddresses.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInputRTMPSettings(AbstractModel):
    """查询输入的RTMP配置信息。

    """

    def __init__(self):
        r"""
        :param _AppName: RTMP的推流路径。
注意：此字段可能返回 null，表示取不到有效值。
        :type AppName: str
        :param _StreamKey: RTMP的推流StreamKey。
RTMP的推流地址拼接规则为：rtmp://Ip:1935/AppName/StreamKey
        :type StreamKey: str
        """
        self._AppName = None
        self._StreamKey = None

    @property
    def AppName(self):
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def StreamKey(self):
        return self._StreamKey

    @StreamKey.setter
    def StreamKey(self, StreamKey):
        self._StreamKey = StreamKey


    def _deserialize(self, params):
        self._AppName = params.get("AppName")
        self._StreamKey = params.get("StreamKey")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInputRTPSettings(AbstractModel):
    """查询输入的RTP配置信息。

    """

    def __init__(self):
        r"""
        :param _FEC: 是否FEC。
        :type FEC: str
        :param _IdleTimeout: 空闲超时时间。
        :type IdleTimeout: int
        """
        self._FEC = None
        self._IdleTimeout = None

    @property
    def FEC(self):
        return self._FEC

    @FEC.setter
    def FEC(self, FEC):
        self._FEC = FEC

    @property
    def IdleTimeout(self):
        return self._IdleTimeout

    @IdleTimeout.setter
    def IdleTimeout(self, IdleTimeout):
        self._IdleTimeout = IdleTimeout


    def _deserialize(self, params):
        self._FEC = params.get("FEC")
        self._IdleTimeout = params.get("IdleTimeout")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInputRTSPPullSettings(AbstractModel):
    """查询输入的RTSP配置信息。

    """

    def __init__(self):
        r"""
        :param _SourceAddresses: RTSP源站地址信息。
        :type SourceAddresses: list of DescribeRTSPPullSourceAddress
        """
        self._SourceAddresses = None

    @property
    def SourceAddresses(self):
        return self._SourceAddresses

    @SourceAddresses.setter
    def SourceAddresses(self, SourceAddresses):
        self._SourceAddresses = SourceAddresses


    def _deserialize(self, params):
        if params.get("SourceAddresses") is not None:
            self._SourceAddresses = []
            for item in params.get("SourceAddresses"):
                obj = DescribeRTSPPullSourceAddress()
                obj._deserialize(item)
                self._SourceAddresses.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeInputSRTSettings(AbstractModel):
    """查询输入的SRT配置信息。

    """

    def __init__(self):
        r"""
        :param _Mode: SRT模式。
注意：此字段可能返回 null，表示取不到有效值。
        :type Mode: str
        :param _StreamId: 流Id。
        :type StreamId: str
        :param _Latency: 延迟。
        :type Latency: int
        :param _RecvLatency: 接收延迟。
        :type RecvLatency: int
        :param _PeerLatency: 对端延迟。
        :type PeerLatency: int
        :param _PeerIdleTimeout: 对端空闲超时时间。
        :type PeerIdleTimeout: int
        :param _Passphrase: 解密密钥。
        :type Passphrase: str
        :param _PbKeyLen: 密钥长度。
        :type PbKeyLen: int
        :param _SourceAddresses: SRT对端地址。
注意：此字段可能返回 null，表示取不到有效值。
        :type SourceAddresses: list of SRTSourceAddressResp
        """
        self._Mode = None
        self._StreamId = None
        self._Latency = None
        self._RecvLatency = None
        self._PeerLatency = None
        self._PeerIdleTimeout = None
        self._Passphrase = None
        self._PbKeyLen = None
        self._SourceAddresses = None

    @property
    def Mode(self):
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def StreamId(self):
        return self._StreamId

    @StreamId.setter
    def StreamId(self, StreamId):
        self._StreamId = StreamId

    @property
    def Latency(self):
        return self._Latency

    @Latency.setter
    def Latency(self, Latency):
        self._Latency = Latency

    @property
    def RecvLatency(self):
        return self._RecvLatency

    @RecvLatency.setter
    def RecvLatency(self, RecvLatency):
        self._RecvLatency = RecvLatency

    @property
    def PeerLatency(self):
        return self._PeerLatency

    @PeerLatency.setter
    def PeerLatency(self, PeerLatency):
        self._PeerLatency = PeerLatency

    @property
    def PeerIdleTimeout(self):
        return self._PeerIdleTimeout

    @PeerIdleTimeout.setter
    def PeerIdleTimeout(self, PeerIdleTimeout):
        self._PeerIdleTimeout = PeerIdleTimeout

    @property
    def Passphrase(self):
        return self._Passphrase

    @Passphrase.setter
    def Passphrase(self, Passphrase):
        self._Passphrase = Passphrase

    @property
    def PbKeyLen(self):
        return self._PbKeyLen

    @PbKeyLen.setter
    def PbKeyLen(self, PbKeyLen):
        self._PbKeyLen = PbKeyLen

    @property
    def SourceAddresses(self):
        return self._SourceAddresses

    @SourceAddresses.setter
    def SourceAddresses(self, SourceAddresses):
        self._SourceAddresses = SourceAddresses


    def _deserialize(self, params):
        self._Mode = params.get("Mode")
        self._StreamId = params.get("StreamId")
        self._Latency = params.get("Latency")
        self._RecvLatency = params.get("RecvLatency")
        self._PeerLatency = params.get("PeerLatency")
        self._PeerIdleTimeout = params.get("PeerIdleTimeout")
        self._Passphrase = params.get("Passphrase")
        self._PbKeyLen = params.get("PbKeyLen")
        if params.get("SourceAddresses") is not None:
            self._SourceAddresses = []
            for item in params.get("SourceAddresses"):
                obj = SRTSourceAddressResp()
                obj._deserialize(item)
                self._SourceAddresses.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMediaMetaDataRequest(AbstractModel):
    """DescribeMediaMetaData请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InputInfo: 需要获取元信息的文件输入信息。
        :type InputInfo: :class:`tencentcloud.mps.v20190612.models.MediaInputInfo`
        """
        self._InputInfo = None

    @property
    def InputInfo(self):
        return self._InputInfo

    @InputInfo.setter
    def InputInfo(self, InputInfo):
        self._InputInfo = InputInfo


    def _deserialize(self, params):
        if params.get("InputInfo") is not None:
            self._InputInfo = MediaInputInfo()
            self._InputInfo._deserialize(params.get("InputInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMediaMetaDataResponse(AbstractModel):
    """DescribeMediaMetaData返回参数结构体

    """

    def __init__(self):
        r"""
        :param _MetaData: 媒体元信息。
        :type MetaData: :class:`tencentcloud.mps.v20190612.models.MediaMetaData`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._MetaData = None
        self._RequestId = None

    @property
    def MetaData(self):
        return self._MetaData

    @MetaData.setter
    def MetaData(self, MetaData):
        self._MetaData = MetaData

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("MetaData") is not None:
            self._MetaData = MediaMetaData()
            self._MetaData._deserialize(params.get("MetaData"))
        self._RequestId = params.get("RequestId")


class DescribeOutput(AbstractModel):
    """查询输出的配置信息。

    """

    def __init__(self):
        r"""
        :param _OutputId: 输出Id。
        :type OutputId: str
        :param _OutputName: 输出名称。
        :type OutputName: str
        :param _OutputType: 输出类型。
        :type OutputType: str
        :param _Description: 输出描述。
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        :param _Protocol: 输出协议。
        :type Protocol: str
        :param _OutputAddressList: 输出的出口地址信息列表。
        :type OutputAddressList: list of OutputAddress
        :param _OutputRegion: 输出的地区。
注意：此字段可能返回 null，表示取不到有效值。
        :type OutputRegion: str
        :param _SRTSettings: 输出的SRT配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type SRTSettings: :class:`tencentcloud.mps.v20190612.models.DescribeOutputSRTSettings`
        :param _RTPSettings: 输出的RTP配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type RTPSettings: :class:`tencentcloud.mps.v20190612.models.DescribeOutputRTPSettings`
        :param _RTMPSettings: 输出的RTMP配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type RTMPSettings: :class:`tencentcloud.mps.v20190612.models.DescribeOutputRTMPSettings`
        :param _RTMPPullSettings: 输出的RTMP拉流配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type RTMPPullSettings: :class:`tencentcloud.mps.v20190612.models.DescribeOutputRTMPPullSettings`
        :param _AllowIpList: CIDR白名单列表。
当Protocol为RTMP_PULL有效，为空代表不限制客户端IP。
注意：此字段可能返回 null，表示取不到有效值。
        :type AllowIpList: list of str
        :param _RTSPPullSettings: 输出的RTSP拉流配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type RTSPPullSettings: :class:`tencentcloud.mps.v20190612.models.DescribeOutputRTSPPullSettings`
        :param _HLSPullSettings: 输出的HLS拉流配置信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type HLSPullSettings: :class:`tencentcloud.mps.v20190612.models.DescribeOutputHLSPullSettings`
        :param _MaxConcurrent: 最大拉流并发数，最大为4，默认4。
        :type MaxConcurrent: int
        :param _SecurityGroupIds: 绑定的安全组 ID。
注意：此字段可能返回 null，表示取不到有效值。
        :type SecurityGroupIds: list of str
        :param _Zones: 可用区，output目前最多只支持一个。	
        :type Zones: list of str
        """
        self._OutputId = None
        self._OutputName = None
        self._OutputType = None
        self._Description = None
        self._Protocol = None
        self._OutputAddressList = None
        self._OutputRegion = None
        self._SRTSettings = None
        self._RTPSettings = None
        self._RTMPSettings = None
        self._RTMPPullSettings = None
        self._AllowIpList = None
        self._RTSPPullSettings = None
        self._HLSPullSettings = None
        self._MaxConcurrent = None
        self._SecurityGroupIds = None
        self._Zones = None

    @property
    def OutputId(self):
        return self._OutputId

    @OutputId.setter
    def OutputId(self, OutputId):
        self._OutputId = OutputId

    @property
    def OutputName(self):
        return self._OutputName

    @OutputName.setter
    def OutputName(self, OutputName):
        self._OutputName = OutputName

    @property
    def OutputType(self):
        return self._OutputType

    @OutputType.setter
    def OutputType(self, OutputType):
        self._OutputType = OutputType

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Protocol(self):
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def OutputAddressList(self):
        return self._OutputAddressList

    @OutputAddressList.setter
    def OutputAddressList(self, OutputAddressList):
        self._OutputAddressList = OutputAddressList

    @property
    def OutputRegion(self):
        return self._OutputRegion

    @OutputRegion.setter
    def OutputRegion(self, OutputRegion):
        self._OutputRegion = OutputRegion

    @property
    def SRTSettings(self):
        return self._SRTSettings

    @SRTSettings.setter
    def SRTSettings(self, SRTSettings):
        self._SRTSettings = SRTSettings

    @property
    def RTPSettings(self):
        return self._RTPSettings

    @RTPSettings.setter
    def RTPSettings(self, RTPSettings):
        self._RTPSettings = RTPSettings

    @property
    def RTMPSettings(self):
        return self._RTMPSettings

    @RTMPSettings.setter
    def RTMPSettings(self, RTMPSettings):
        self._RTMPSettings = RTMPSettings

    @property
    def RTMPPullSettings(self):
        return self._RTMPPullSettings

    @RTMPPullSettings.setter
    def RTMPPullSettings(self, RTMPPullSettings):
        self._RTMPPullSettings = RTMPPullSettings

    @property
    def AllowIpList(self):
        return self._AllowIpList

    @AllowIpList.setter
    def AllowIpList(self, AllowIpList):
        self._AllowIpList = AllowIpList

    @property
    def RTSPPullSettings(self):
        return self._RTSPPullSettings

    @RTSPPullSettings.setter
    def RTSPPullSettings(self, RTSPPullSettings):
        self._RTSPPullSettings = RTSPPullSettings

    @property
    def HLSPullSettings(self):
        return self._HLSPullSettings

    @HLSPullSettings.setter
    def HLSPullSettings(self, HLSPullSettings):
        self._HLSPullSettings = HLSPullSettings

    @property
    def MaxConcurrent(self):
        return self._MaxConcurrent

    @MaxConcurrent.setter
    def MaxConcurrent(self, MaxConcurrent):
        self._MaxConcurrent = MaxConcurrent

    @property
    def SecurityGroupIds(self):
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds

    @property
    def Zones(self):
        return self._Zones

    @Zones.setter
    def Zones(self, Zones):
        self._Zones = Zones


    def _deserialize(self, params):
        self._OutputId = params.get("OutputId")
        self._OutputName = params.get("OutputName")
        self._OutputType = params.get("OutputType")
        self._Description = params.get("Description")
        self._Protocol = params.get("Protocol")
        if params.get("OutputAddressList") is not None:
            self._OutputAddressList = []
            for item in params.get("OutputAddressList"):
                obj = OutputAddress()
                obj._deserialize(item)
                self._OutputAddressList.append(obj)
        self._OutputRegion = params.get("OutputRegion")
        if params.get("SRTSettings") is not None:
            self._SRTSettings = DescribeOutputSRTSettings()
            self._SRTSettings._deserialize(params.get("SRTSettings"))
        if params.get("RTPSettings") is not None:
            self._RTPSettings = DescribeOutputRTPSettings()
            self._RTPSettings._deserialize(params.get("RTPSettings"))
        if params.get("RTMPSettings") is not None:
            self._RTMPSettings = DescribeOutputRTMPSettings()
            self._RTMPSettings._deserialize(params.get("RTMPSettings"))
        if params.get("RTMPPullSettings") is not None:
            self._RTMPPullSettings = DescribeOutputRTMPPullSettings()
            self._RTMPPullSettings._deserialize(params.get("RTMPPullSettings"))
        self._AllowIpList = params.get("AllowIpList")
        if params.get("RTSPPullSettings") is not None:
            self._RTSPPullSettings = DescribeOutputRTSPPullSettings()
            self._RTSPPullSettings._deserialize(params.get("RTSPPullSettings"))
        if params.get("HLSPullSettings") is not None:
            self._HLSPullSettings = DescribeOutputHLSPullSettings()
            self._HLSPullSettings._deserialize(params.get("HLSPullSettings"))
        self._MaxConcurrent = params.get("MaxConcurrent")
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        self._Zones = params.get("Zones")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOutputHLSPullServerUrl(AbstractModel):
    """查询输出的HLS拉流URL信息。

    """

    def __init__(self):
        r"""
        :param _Url: HLS拉流地址的Url。
        :type Url: str
        """
        self._Url = None

    @property
    def Url(self):
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url


    def _deserialize(self, params):
        self._Url = params.get("Url")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOutputHLSPullSettings(AbstractModel):
    """查询输出的HLS拉流配置信息。

    """

    def __init__(self):
        r"""
        :param _ServerUrls: HLS拉流地址列表。
注意：此字段可能返回 null，表示取不到有效值。
        :type ServerUrls: list of DescribeOutputHLSPullServerUrl
        """
        self._ServerUrls = None

    @property
    def ServerUrls(self):
        return self._ServerUrls

    @ServerUrls.setter
    def ServerUrls(self, ServerUrls):
        self._ServerUrls = ServerUrls


    def _deserialize(self, params):
        if params.get("ServerUrls") is not None:
            self._ServerUrls = []
            for item in params.get("ServerUrls"):
                obj = DescribeOutputHLSPullServerUrl()
                obj._deserialize(item)
                self._ServerUrls.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOutputRTMPPullServerUrl(AbstractModel):
    """查询输出的RTMP拉流URL信息。

    """

    def __init__(self):
        r"""
        :param _TcUrl: RTMP拉流地址的tcUrl。
        :type TcUrl: str
        :param _StreamKey: RTMP拉流地址的流key。
        :type StreamKey: str
        """
        self._TcUrl = None
        self._StreamKey = None

    @property
    def TcUrl(self):
        return self._TcUrl

    @TcUrl.setter
    def TcUrl(self, TcUrl):
        self._TcUrl = TcUrl

    @property
    def StreamKey(self):
        return self._StreamKey

    @StreamKey.setter
    def StreamKey(self, StreamKey):
        self._StreamKey = StreamKey


    def _deserialize(self, params):
        self._TcUrl = params.get("TcUrl")
        self._StreamKey = params.get("StreamKey")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOutputRTMPPullSettings(AbstractModel):
    """查询输出的RTMP拉流配置信息。

    """

    def __init__(self):
        r"""
        :param _ServerUrls: 拉流地址列表。
注意：此字段可能返回 null，表示取不到有效值。
        :type ServerUrls: list of DescribeOutputRTMPPullServerUrl
        """
        self._ServerUrls = None

    @property
    def ServerUrls(self):
        return self._ServerUrls

    @ServerUrls.setter
    def ServerUrls(self, ServerUrls):
        self._ServerUrls = ServerUrls


    def _deserialize(self, params):
        if params.get("ServerUrls") is not None:
            self._ServerUrls = []
            for item in params.get("ServerUrls"):
                obj = DescribeOutputRTMPPullServerUrl()
                obj._deserialize(item)
                self._ServerUrls.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOutputRTMPSettings(AbstractModel):
    """查询输出的RTMP配置信息。

    """

    def __init__(self):
        r"""
        :param _IdleTimeout: 空闲超时时间。
注意：此字段可能返回 null，表示取不到有效值。
        :type IdleTimeout: int
        :param _ChunkSize: Chunk大小。
注意：此字段可能返回 null，表示取不到有效值。
        :type ChunkSize: int
        :param _Destinations: 转推RTMP的目标地址信息列表。
注意：此字段可能返回 null，表示取不到有效值。
        :type Destinations: list of RTMPAddressDestination
        """
        self._IdleTimeout = None
        self._ChunkSize = None
        self._Destinations = None

    @property
    def IdleTimeout(self):
        return self._IdleTimeout

    @IdleTimeout.setter
    def IdleTimeout(self, IdleTimeout):
        self._IdleTimeout = IdleTimeout

    @property
    def ChunkSize(self):
        return self._ChunkSize

    @ChunkSize.setter
    def ChunkSize(self, ChunkSize):
        self._ChunkSize = ChunkSize

    @property
    def Destinations(self):
        return self._Destinations

    @Destinations.setter
    def Destinations(self, Destinations):
        self._Destinations = Destinations


    def _deserialize(self, params):
        self._IdleTimeout = params.get("IdleTimeout")
        self._ChunkSize = params.get("ChunkSize")
        if params.get("Destinations") is not None:
            self._Destinations = []
            for item in params.get("Destinations"):
                obj = RTMPAddressDestination()
                obj._deserialize(item)
                self._Destinations.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOutputRTPSettings(AbstractModel):
    """查询输出的RTP配置信息。

    """

    def __init__(self):
        r"""
        :param _Destinations: 转推RTP的目标地址信息列表。
注意：此字段可能返回 null，表示取不到有效值。
        :type Destinations: list of RTPAddressDestination
        :param _FEC: 是否FEC。
注意：此字段可能返回 null，表示取不到有效值。
        :type FEC: str
        :param _IdleTimeout: 空闲超时时间。
注意：此字段可能返回 null，表示取不到有效值。
        :type IdleTimeout: int
        """
        self._Destinations = None
        self._FEC = None
        self._IdleTimeout = None

    @property
    def Destinations(self):
        return self._Destinations

    @Destinations.setter
    def Destinations(self, Destinations):
        self._Destinations = Destinations

    @property
    def FEC(self):
        return self._FEC

    @FEC.setter
    def FEC(self, FEC):
        self._FEC = FEC

    @property
    def IdleTimeout(self):
        return self._IdleTimeout

    @IdleTimeout.setter
    def IdleTimeout(self, IdleTimeout):
        self._IdleTimeout = IdleTimeout


    def _deserialize(self, params):
        if params.get("Destinations") is not None:
            self._Destinations = []
            for item in params.get("Destinations"):
                obj = RTPAddressDestination()
                obj._deserialize(item)
                self._Destinations.append(obj)
        self._FEC = params.get("FEC")
        self._IdleTimeout = params.get("IdleTimeout")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOutputRTSPPullServerUrl(AbstractModel):
    """查询输出的RTSP拉流URL信息。

    """

    def __init__(self):
        r"""
        :param _Url: RTSP拉流地址的Url。
        :type Url: str
        """
        self._Url = None

    @property
    def Url(self):
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url


    def _deserialize(self, params):
        self._Url = params.get("Url")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOutputRTSPPullSettings(AbstractModel):
    """查询输出的RTSP拉流配置信息。

    """

    def __init__(self):
        r"""
        :param _ServerUrls: RTSP拉流地址列表。
注意：此字段可能返回 null，表示取不到有效值。
        :type ServerUrls: list of DescribeOutputRTSPPullServerUrl
        """
        self._ServerUrls = None

    @property
    def ServerUrls(self):
        return self._ServerUrls

    @ServerUrls.setter
    def ServerUrls(self, ServerUrls):
        self._ServerUrls = ServerUrls


    def _deserialize(self, params):
        if params.get("ServerUrls") is not None:
            self._ServerUrls = []
            for item in params.get("ServerUrls"):
                obj = DescribeOutputRTSPPullServerUrl()
                obj._deserialize(item)
                self._ServerUrls.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOutputSRTSettings(AbstractModel):
    """查询输出的SRT配置信息。

    """

    def __init__(self):
        r"""
        :param _Destinations: 转推的目标的地址信息列表，SRT模式为CALLER时使用。
注意：此字段可能返回 null，表示取不到有效值。
        :type Destinations: list of SRTAddressDestination
        :param _StreamId: 流Id。
注意：此字段可能返回 null，表示取不到有效值。
        :type StreamId: str
        :param _Latency: 延迟。
注意：此字段可能返回 null，表示取不到有效值。
        :type Latency: int
        :param _RecvLatency: 接收延迟。
注意：此字段可能返回 null，表示取不到有效值。
        :type RecvLatency: int
        :param _PeerLatency: 对端延迟。
注意：此字段可能返回 null，表示取不到有效值。
        :type PeerLatency: int
        :param _PeerIdleTimeout: 对端空闲超时时间。
注意：此字段可能返回 null，表示取不到有效值。
        :type PeerIdleTimeout: int
        :param _Passphrase: 加密密钥。
注意：此字段可能返回 null，表示取不到有效值。
        :type Passphrase: str
        :param _PbKeyLen: 加密密钥长度。
注意：此字段可能返回 null，表示取不到有效值。
        :type PbKeyLen: int
        :param _Mode: SRT模式。
注意：此字段可能返回 null，表示取不到有效值。
        :type Mode: str
        :param _SourceAddresses: 服务器监听地址，SRT模式为LISTENER时使用。
注意：此字段可能返回 null，表示取不到有效值。
        :type SourceAddresses: list of OutputSRTSourceAddressResp
        """
        self._Destinations = None
        self._StreamId = None
        self._Latency = None
        self._RecvLatency = None
        self._PeerLatency = None
        self._PeerIdleTimeout = None
        self._Passphrase = None
        self._PbKeyLen = None
        self._Mode = None
        self._SourceAddresses = None

    @property
    def Destinations(self):
        return self._Destinations

    @Destinations.setter
    def Destinations(self, Destinations):
        self._Destinations = Destinations

    @property
    def StreamId(self):
        return self._StreamId

    @StreamId.setter
    def StreamId(self, StreamId):
        self._StreamId = StreamId

    @property
    def Latency(self):
        return self._Latency

    @Latency.setter
    def Latency(self, Latency):
        self._Latency = Latency

    @property
    def RecvLatency(self):
        return self._RecvLatency

    @RecvLatency.setter
    def RecvLatency(self, RecvLatency):
        self._RecvLatency = RecvLatency

    @property
    def PeerLatency(self):
        return self._PeerLatency

    @PeerLatency.setter
    def PeerLatency(self, PeerLatency):
        self._PeerLatency = PeerLatency

    @property
    def PeerIdleTimeout(self):
        return self._PeerIdleTimeout

    @PeerIdleTimeout.setter
    def PeerIdleTimeout(self, PeerIdleTimeout):
        self._PeerIdleTimeout = PeerIdleTimeout

    @property
    def Passphrase(self):
        return self._Passphrase

    @Passphrase.setter
    def Passphrase(self, Passphrase):
        self._Passphrase = Passphrase

    @property
    def PbKeyLen(self):
        return self._PbKeyLen

    @PbKeyLen.setter
    def PbKeyLen(self, PbKeyLen):
        self._PbKeyLen = PbKeyLen

    @property
    def Mode(self):
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def SourceAddresses(self):
        return self._SourceAddresses

    @SourceAddresses.setter
    def SourceAddresses(self, SourceAddresses):
        self._SourceAddresses = SourceAddresses


    def _deserialize(self, params):
        if params.get("Destinations") is not None:
            self._Destinations = []
            for item in params.get("Destinations"):
                obj = SRTAddressDestination()
                obj._deserialize(item)
                self._Destinations.append(obj)
        self._StreamId = params.get("StreamId")
        self._Latency = params.get("Latency")
        self._RecvLatency = params.get("RecvLatency")
        self._PeerLatency = params.get("PeerLatency")
        self._PeerIdleTimeout = params.get("PeerIdleTimeout")
        self._Passphrase = params.get("Passphrase")
        self._PbKeyLen = params.get("PbKeyLen")
        self._Mode = params.get("Mode")
        if params.get("SourceAddresses") is not None:
            self._SourceAddresses = []
            for item in params.get("SourceAddresses"):
                obj = OutputSRTSourceAddressResp()
                obj._deserialize(item)
                self._SourceAddresses.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePersonSamplesRequest(AbstractModel):
    """DescribePersonSamples请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Type: 拉取的素材类型，可选值：
<li>UserDefine：用户自定义素材库；</li>
<li>Default：系统默认素材库。</li>

默认值：UserDefine，拉取用户自定义素材库素材。
说明：如果是拉取系统默认素材库，只能使用素材名字或者素材 ID + 素材名字的方式进行拉取，且人脸图片只返回一张。
        :type Type: str
        :param _PersonIds: 素材 ID，数组长度限制：100。
        :type PersonIds: list of str
        :param _Names: 素材名称，数组长度限制：20。
        :type Names: list of str
        :param _Tags: 素材标签，数组长度限制：20。
        :type Tags: list of str
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：100，最大值：100。
        :type Limit: int
        """
        self._Type = None
        self._PersonIds = None
        self._Names = None
        self._Tags = None
        self._Offset = None
        self._Limit = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def PersonIds(self):
        return self._PersonIds

    @PersonIds.setter
    def PersonIds(self, PersonIds):
        self._PersonIds = PersonIds

    @property
    def Names(self):
        return self._Names

    @Names.setter
    def Names(self, Names):
        self._Names = Names

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._PersonIds = params.get("PersonIds")
        self._Names = params.get("Names")
        self._Tags = params.get("Tags")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePersonSamplesResponse(AbstractModel):
    """DescribePersonSamples返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合条件的记录总数。
        :type TotalCount: int
        :param _PersonSet: 素材信息。
        :type PersonSet: list of AiSamplePerson
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._PersonSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def PersonSet(self):
        return self._PersonSet

    @PersonSet.setter
    def PersonSet(self, PersonSet):
        self._PersonSet = PersonSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("PersonSet") is not None:
            self._PersonSet = []
            for item in params.get("PersonSet"):
                obj = AiSamplePerson()
                obj._deserialize(item)
                self._PersonSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeQualityControlTemplatesRequest(AbstractModel):
    """DescribeQualityControlTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definitions: 媒体质检模板唯一标识过滤条件，数组长度限制：100。
        :type Definitions: list of int
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数
<li>默认值：10；</li>
<li>最大值：100。</li>
        :type Limit: int
        :param _Type: "Preset"：预设，Custom":客户魔板
        :type Type: str
        """
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None

    @property
    def Definitions(self):
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeQualityControlTemplatesResponse(AbstractModel):
    """DescribeQualityControlTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _QualityControlTemplateSet: 媒体质检模板详情列表。
注意：此字段可能返回 null，表示取不到有效值。
        :type QualityControlTemplateSet: list of QualityControlTemplate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._QualityControlTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def QualityControlTemplateSet(self):
        return self._QualityControlTemplateSet

    @QualityControlTemplateSet.setter
    def QualityControlTemplateSet(self, QualityControlTemplateSet):
        self._QualityControlTemplateSet = QualityControlTemplateSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("QualityControlTemplateSet") is not None:
            self._QualityControlTemplateSet = []
            for item in params.get("QualityControlTemplateSet"):
                obj = QualityControlTemplate()
                obj._deserialize(item)
                self._QualityControlTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRTMPPullSourceAddress(AbstractModel):
    """查询输入的RTMP配置信息。

    """

    def __init__(self):
        r"""
        :param _TcUrl: RTMP源站的TcUrl地址。
注意：此字段可能返回 null，表示取不到有效值。
        :type TcUrl: str
        :param _StreamKey: RTMP源站的StreamKey。
RTMP源站地址拼接规则为：$TcUrl/$StreamKey。
        :type StreamKey: str
        """
        self._TcUrl = None
        self._StreamKey = None

    @property
    def TcUrl(self):
        return self._TcUrl

    @TcUrl.setter
    def TcUrl(self, TcUrl):
        self._TcUrl = TcUrl

    @property
    def StreamKey(self):
        return self._StreamKey

    @StreamKey.setter
    def StreamKey(self, StreamKey):
        self._StreamKey = StreamKey


    def _deserialize(self, params):
        self._TcUrl = params.get("TcUrl")
        self._StreamKey = params.get("StreamKey")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRTSPPullSourceAddress(AbstractModel):
    """查询输入的RTSP配置信息。

    """

    def __init__(self):
        r"""
        :param _Url: RTSP源站的Url地址。
注意：此字段可能返回 null，表示取不到有效值。
        :type Url: str
        """
        self._Url = None

    @property
    def Url(self):
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url


    def _deserialize(self, params):
        self._Url = params.get("Url")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSampleSnapshotTemplatesRequest(AbstractModel):
    """DescribeSampleSnapshotTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definitions: 采样截图模板唯一标识过滤条件，数组长度限制：100。
        :type Definitions: list of int non-negative
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        :param _Type: 模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :type Type: str
        """
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None

    @property
    def Definitions(self):
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSampleSnapshotTemplatesResponse(AbstractModel):
    """DescribeSampleSnapshotTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _SampleSnapshotTemplateSet: 采样截图模板详情列表。
        :type SampleSnapshotTemplateSet: list of SampleSnapshotTemplate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._SampleSnapshotTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def SampleSnapshotTemplateSet(self):
        return self._SampleSnapshotTemplateSet

    @SampleSnapshotTemplateSet.setter
    def SampleSnapshotTemplateSet(self, SampleSnapshotTemplateSet):
        self._SampleSnapshotTemplateSet = SampleSnapshotTemplateSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("SampleSnapshotTemplateSet") is not None:
            self._SampleSnapshotTemplateSet = []
            for item in params.get("SampleSnapshotTemplateSet"):
                obj = SampleSnapshotTemplate()
                obj._deserialize(item)
                self._SampleSnapshotTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSchedulesRequest(AbstractModel):
    """DescribeSchedules请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ScheduleIds: 编排 ID 过滤条件，数组长度限制：100。
        :type ScheduleIds: list of int
        :param _TriggerType: 编排触发类型，可选值：
<li>CosFileUpload： 腾讯云 COS 文件上传触发</li>
<li>AwsS3FileUpload：Aws S3 文件上传触发。</li>
不填或者为空表示全部。
        :type TriggerType: str
        :param _Status: 状态，取值范围：
<li>Enabled：已启用，</li>
<li>Disabled：已禁用。</li>
不填此参数，则不区编排状态。
        :type Status: str
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        """
        self._ScheduleIds = None
        self._TriggerType = None
        self._Status = None
        self._Offset = None
        self._Limit = None

    @property
    def ScheduleIds(self):
        return self._ScheduleIds

    @ScheduleIds.setter
    def ScheduleIds(self, ScheduleIds):
        self._ScheduleIds = ScheduleIds

    @property
    def TriggerType(self):
        return self._TriggerType

    @TriggerType.setter
    def TriggerType(self, TriggerType):
        self._TriggerType = TriggerType

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._ScheduleIds = params.get("ScheduleIds")
        self._TriggerType = params.get("TriggerType")
        self._Status = params.get("Status")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSchedulesResponse(AbstractModel):
    """DescribeSchedules返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _ScheduleInfoSet: 编排信息数组。
        :type ScheduleInfoSet: list of SchedulesInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._ScheduleInfoSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ScheduleInfoSet(self):
        return self._ScheduleInfoSet

    @ScheduleInfoSet.setter
    def ScheduleInfoSet(self, ScheduleInfoSet):
        self._ScheduleInfoSet = ScheduleInfoSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ScheduleInfoSet") is not None:
            self._ScheduleInfoSet = []
            for item in params.get("ScheduleInfoSet"):
                obj = SchedulesInfo()
                obj._deserialize(item)
                self._ScheduleInfoSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSnapshotByTimeOffsetTemplatesRequest(AbstractModel):
    """DescribeSnapshotByTimeOffsetTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definitions: 指定时间点截图模板唯一标识过滤条件，数组长度限制：100。
        :type Definitions: list of int non-negative
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        :param _Type: 模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :type Type: str
        """
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None

    @property
    def Definitions(self):
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSnapshotByTimeOffsetTemplatesResponse(AbstractModel):
    """DescribeSnapshotByTimeOffsetTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _SnapshotByTimeOffsetTemplateSet: 指定时间点截图模板详情列表。
        :type SnapshotByTimeOffsetTemplateSet: list of SnapshotByTimeOffsetTemplate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._SnapshotByTimeOffsetTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def SnapshotByTimeOffsetTemplateSet(self):
        return self._SnapshotByTimeOffsetTemplateSet

    @SnapshotByTimeOffsetTemplateSet.setter
    def SnapshotByTimeOffsetTemplateSet(self, SnapshotByTimeOffsetTemplateSet):
        self._SnapshotByTimeOffsetTemplateSet = SnapshotByTimeOffsetTemplateSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("SnapshotByTimeOffsetTemplateSet") is not None:
            self._SnapshotByTimeOffsetTemplateSet = []
            for item in params.get("SnapshotByTimeOffsetTemplateSet"):
                obj = SnapshotByTimeOffsetTemplate()
                obj._deserialize(item)
                self._SnapshotByTimeOffsetTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeStreamLinkActivateStateRequest(AbstractModel):
    """DescribeStreamLinkActivateState请求参数结构体

    """


class DescribeStreamLinkActivateStateResponse(AbstractModel):
    """DescribeStreamLinkActivateState返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Status: 用户已激活为0，否则为非0。
        :type Status: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Status = None
        self._RequestId = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._RequestId = params.get("RequestId")


class DescribeStreamLinkEventAttachedFlowsRequest(AbstractModel):
    """DescribeStreamLinkEventAttachedFlows请求参数结构体

    """

    def __init__(self):
        r"""
        :param _EventId: EventId。
        :type EventId: str
        :param _PageNum: 当前页数，默认1。
        :type PageNum: int
        :param _PageSize: 每页大小，默认1000。
        :type PageSize: int
        """
        self._EventId = None
        self._PageNum = None
        self._PageSize = None

    @property
    def EventId(self):
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId

    @property
    def PageNum(self):
        return self._PageNum

    @PageNum.setter
    def PageNum(self, PageNum):
        self._PageNum = PageNum

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        self._EventId = params.get("EventId")
        self._PageNum = params.get("PageNum")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeStreamLinkEventAttachedFlowsResponse(AbstractModel):
    """DescribeStreamLinkEventAttachedFlows返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Infos: 流的配置信息列表。
        :type Infos: list of DescribeFlow
        :param _TotalNum: 总数量。
        :type TotalNum: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Infos = None
        self._TotalNum = None
        self._RequestId = None

    @property
    def Infos(self):
        return self._Infos

    @Infos.setter
    def Infos(self, Infos):
        self._Infos = Infos

    @property
    def TotalNum(self):
        return self._TotalNum

    @TotalNum.setter
    def TotalNum(self, TotalNum):
        self._TotalNum = TotalNum

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Infos") is not None:
            self._Infos = []
            for item in params.get("Infos"):
                obj = DescribeFlow()
                obj._deserialize(item)
                self._Infos.append(obj)
        self._TotalNum = params.get("TotalNum")
        self._RequestId = params.get("RequestId")


class DescribeStreamLinkEventRequest(AbstractModel):
    """DescribeStreamLinkEvent请求参数结构体

    """

    def __init__(self):
        r"""
        :param _EventId: 媒体传输事件ID。
        :type EventId: str
        """
        self._EventId = None

    @property
    def EventId(self):
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId


    def _deserialize(self, params):
        self._EventId = params.get("EventId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeStreamLinkEventResponse(AbstractModel):
    """DescribeStreamLinkEvent返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Info: 媒体传输事件的配置信息。
        :type Info: :class:`tencentcloud.mps.v20190612.models.DescribeEvent`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Info = None
        self._RequestId = None

    @property
    def Info(self):
        return self._Info

    @Info.setter
    def Info(self, Info):
        self._Info = Info

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Info") is not None:
            self._Info = DescribeEvent()
            self._Info._deserialize(params.get("Info"))
        self._RequestId = params.get("RequestId")


class DescribeStreamLinkEventsRequest(AbstractModel):
    """DescribeStreamLinkEvents请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PageNum: 当前页数，默认1。
        :type PageNum: int
        :param _PageSize: 每页大小，默认10。
        :type PageSize: int
        """
        self._PageNum = None
        self._PageSize = None

    @property
    def PageNum(self):
        return self._PageNum

    @PageNum.setter
    def PageNum(self, PageNum):
        self._PageNum = PageNum

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        self._PageNum = params.get("PageNum")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeStreamLinkEventsResponse(AbstractModel):
    """DescribeStreamLinkEvents返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Infos: 媒体传输事件的配置信息列表。
        :type Infos: list of DescribeEvent
        :param _PageNum: 当前页数。
        :type PageNum: int
        :param _PageSize: 每页大小。
        :type PageSize: int
        :param _TotalNum: 总数量。
        :type TotalNum: int
        :param _TotalPage: 总页数。
        :type TotalPage: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Infos = None
        self._PageNum = None
        self._PageSize = None
        self._TotalNum = None
        self._TotalPage = None
        self._RequestId = None

    @property
    def Infos(self):
        return self._Infos

    @Infos.setter
    def Infos(self, Infos):
        self._Infos = Infos

    @property
    def PageNum(self):
        return self._PageNum

    @PageNum.setter
    def PageNum(self, PageNum):
        self._PageNum = PageNum

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def TotalNum(self):
        return self._TotalNum

    @TotalNum.setter
    def TotalNum(self, TotalNum):
        self._TotalNum = TotalNum

    @property
    def TotalPage(self):
        return self._TotalPage

    @TotalPage.setter
    def TotalPage(self, TotalPage):
        self._TotalPage = TotalPage

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Infos") is not None:
            self._Infos = []
            for item in params.get("Infos"):
                obj = DescribeEvent()
                obj._deserialize(item)
                self._Infos.append(obj)
        self._PageNum = params.get("PageNum")
        self._PageSize = params.get("PageSize")
        self._TotalNum = params.get("TotalNum")
        self._TotalPage = params.get("TotalPage")
        self._RequestId = params.get("RequestId")


class DescribeStreamLinkFlowLogsRequest(AbstractModel):
    """DescribeStreamLinkFlowLogs请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FlowId: 传输流Id。
        :type FlowId: str
        :param _StartTime: 统计的开始时间，默认为前一小时，最多支持查询近7天。
UTC时间，如'2020-01-01T12:00:00Z'。
        :type StartTime: str
        :param _EndTime: 统计的结束时间，默认为StartTime后一小时，最多支持查询24小时的数据。
UTC时间，如'2020-01-01T12:00:00Z'。
        :type EndTime: str
        :param _Type: 输入或输出类型，可选[input|output]。
        :type Type: list of str
        :param _Pipeline: 主通道或备通道，可选[0|1]。
        :type Pipeline: list of str
        :param _PageSize: 每页大小，默认100，范围为[1, 1000]。
        :type PageSize: int
        :param _SortType: 按Timestamp升序或降序排序，默认降序，可选[desc|asc]。
        :type SortType: str
        :param _PageNum: 页码，默认1，范围为[1, 1000]。
        :type PageNum: int
        """
        self._FlowId = None
        self._StartTime = None
        self._EndTime = None
        self._Type = None
        self._Pipeline = None
        self._PageSize = None
        self._SortType = None
        self._PageNum = None

    @property
    def FlowId(self):
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Pipeline(self):
        return self._Pipeline

    @Pipeline.setter
    def Pipeline(self, Pipeline):
        self._Pipeline = Pipeline

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def SortType(self):
        return self._SortType

    @SortType.setter
    def SortType(self, SortType):
        self._SortType = SortType

    @property
    def PageNum(self):
        return self._PageNum

    @PageNum.setter
    def PageNum(self, PageNum):
        self._PageNum = PageNum


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Type = params.get("Type")
        self._Pipeline = params.get("Pipeline")
        self._PageSize = params.get("PageSize")
        self._SortType = params.get("SortType")
        self._PageNum = params.get("PageNum")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeStreamLinkFlowLogsResponse(AbstractModel):
    """DescribeStreamLinkFlowLogs返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Infos: 日志信息列表。
        :type Infos: list of FlowLogInfo
        :param _PageNum: 当前页码。
        :type PageNum: int
        :param _PageSize: 每页大小。
        :type PageSize: int
        :param _TotalNum: 总数量。
        :type TotalNum: int
        :param _TotalPage: 总页数。
        :type TotalPage: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Infos = None
        self._PageNum = None
        self._PageSize = None
        self._TotalNum = None
        self._TotalPage = None
        self._RequestId = None

    @property
    def Infos(self):
        return self._Infos

    @Infos.setter
    def Infos(self, Infos):
        self._Infos = Infos

    @property
    def PageNum(self):
        return self._PageNum

    @PageNum.setter
    def PageNum(self, PageNum):
        self._PageNum = PageNum

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def TotalNum(self):
        return self._TotalNum

    @TotalNum.setter
    def TotalNum(self, TotalNum):
        self._TotalNum = TotalNum

    @property
    def TotalPage(self):
        return self._TotalPage

    @TotalPage.setter
    def TotalPage(self, TotalPage):
        self._TotalPage = TotalPage

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Infos") is not None:
            self._Infos = []
            for item in params.get("Infos"):
                obj = FlowLogInfo()
                obj._deserialize(item)
                self._Infos.append(obj)
        self._PageNum = params.get("PageNum")
        self._PageSize = params.get("PageSize")
        self._TotalNum = params.get("TotalNum")
        self._TotalPage = params.get("TotalPage")
        self._RequestId = params.get("RequestId")


class DescribeStreamLinkFlowMediaStatisticsRequest(AbstractModel):
    """DescribeStreamLinkFlowMediaStatistics请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FlowId: 传输流ID。
        :type FlowId: str
        :param _Type: 输入或输出类型，可选[input|output]。
        :type Type: str
        :param _InputOutputId: 输入或输出Id。
        :type InputOutputId: str
        :param _Pipeline: 主通道或备通道，可选[0|1]。
        :type Pipeline: str
        :param _Period: 查询间隔，可选[5s|1min|5min|15min]。
        :type Period: str
        :param _StartTime: 统计的开始时间，默认为前一小时，最多支持查询近7天。
UTC时间，如'2020-01-01T12:00:00Z'。
        :type StartTime: str
        :param _EndTime: 统计的结束时间，默认为StartTime后一小时，最多支持查询24小时的数据。
UTC时间，如'2020-01-01T12:00:00Z'。
        :type EndTime: str
        """
        self._FlowId = None
        self._Type = None
        self._InputOutputId = None
        self._Pipeline = None
        self._Period = None
        self._StartTime = None
        self._EndTime = None

    @property
    def FlowId(self):
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def InputOutputId(self):
        return self._InputOutputId

    @InputOutputId.setter
    def InputOutputId(self, InputOutputId):
        self._InputOutputId = InputOutputId

    @property
    def Pipeline(self):
        return self._Pipeline

    @Pipeline.setter
    def Pipeline(self, Pipeline):
        self._Pipeline = Pipeline

    @property
    def Period(self):
        return self._Period

    @Period.setter
    def Period(self, Period):
        self._Period = Period

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._Type = params.get("Type")
        self._InputOutputId = params.get("InputOutputId")
        self._Pipeline = params.get("Pipeline")
        self._Period = params.get("Period")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeStreamLinkFlowMediaStatisticsResponse(AbstractModel):
    """DescribeStreamLinkFlowMediaStatistics返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Infos: 传输流的媒体数据列表。
        :type Infos: list of FlowMediaInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Infos = None
        self._RequestId = None

    @property
    def Infos(self):
        return self._Infos

    @Infos.setter
    def Infos(self, Infos):
        self._Infos = Infos

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Infos") is not None:
            self._Infos = []
            for item in params.get("Infos"):
                obj = FlowMediaInfo()
                obj._deserialize(item)
                self._Infos.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeStreamLinkFlowRealtimeStatusRequest(AbstractModel):
    """DescribeStreamLinkFlowRealtimeStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FlowId: 流ID。
        :type FlowId: str
        :param _InputIds: 输入id数组，如果输入输出数组都为空，则代表全量查询。
        :type InputIds: list of str
        :param _OutputIds: 输出id数组，如果输入输出数组都为空，则代表全量查询。
        :type OutputIds: list of str
        """
        self._FlowId = None
        self._InputIds = None
        self._OutputIds = None

    @property
    def FlowId(self):
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def InputIds(self):
        return self._InputIds

    @InputIds.setter
    def InputIds(self, InputIds):
        self._InputIds = InputIds

    @property
    def OutputIds(self):
        return self._OutputIds

    @OutputIds.setter
    def OutputIds(self, OutputIds):
        self._OutputIds = OutputIds


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._InputIds = params.get("InputIds")
        self._OutputIds = params.get("OutputIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeStreamLinkFlowRealtimeStatusResponse(AbstractModel):
    """DescribeStreamLinkFlowRealtimeStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Timestamp: 查询时间，单位s。
        :type Timestamp: int
        :param _Datas: 实时数据信息列表。
        :type Datas: list of FlowRealtimeStatusItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Timestamp = None
        self._Datas = None
        self._RequestId = None

    @property
    def Timestamp(self):
        return self._Timestamp

    @Timestamp.setter
    def Timestamp(self, Timestamp):
        self._Timestamp = Timestamp

    @property
    def Datas(self):
        return self._Datas

    @Datas.setter
    def Datas(self, Datas):
        self._Datas = Datas

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Timestamp = params.get("Timestamp")
        if params.get("Datas") is not None:
            self._Datas = []
            for item in params.get("Datas"):
                obj = FlowRealtimeStatusItem()
                obj._deserialize(item)
                self._Datas.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeStreamLinkFlowRequest(AbstractModel):
    """DescribeStreamLinkFlow请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FlowId: 流Id。
        :type FlowId: str
        """
        self._FlowId = None

    @property
    def FlowId(self):
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeStreamLinkFlowResponse(AbstractModel):
    """DescribeStreamLinkFlow返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Info: 流的配置信息。
        :type Info: :class:`tencentcloud.mps.v20190612.models.DescribeFlow`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Info = None
        self._RequestId = None

    @property
    def Info(self):
        return self._Info

    @Info.setter
    def Info(self, Info):
        self._Info = Info

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Info") is not None:
            self._Info = DescribeFlow()
            self._Info._deserialize(params.get("Info"))
        self._RequestId = params.get("RequestId")


class DescribeStreamLinkFlowSRTStatisticsRequest(AbstractModel):
    """DescribeStreamLinkFlowSRTStatistics请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FlowId: 传输流ID。
        :type FlowId: str
        :param _Type: 输入或输出类型，可选[input|output]。
        :type Type: str
        :param _InputOutputId: 输入或输出Id。
        :type InputOutputId: str
        :param _Pipeline: 主通道或备通道，可选[0|1]。
        :type Pipeline: str
        :param _StartTime: 统计的开始时间，默认为前一小时，最多支持查询近7天。
UTC时间，如'2020-01-01T12:00:00Z'。
        :type StartTime: str
        :param _EndTime: 统计的结束时间，默认为StartTime后一小时，最多支持查询24小时的数据。
UTC时间，如'2020-01-01T12:00:00Z'。
        :type EndTime: str
        :param _Period: 查询间隔，可选[5s|1min|5min|15min]。
        :type Period: str
        """
        self._FlowId = None
        self._Type = None
        self._InputOutputId = None
        self._Pipeline = None
        self._StartTime = None
        self._EndTime = None
        self._Period = None

    @property
    def FlowId(self):
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def InputOutputId(self):
        return self._InputOutputId

    @InputOutputId.setter
    def InputOutputId(self, InputOutputId):
        self._InputOutputId = InputOutputId

    @property
    def Pipeline(self):
        return self._Pipeline

    @Pipeline.setter
    def Pipeline(self, Pipeline):
        self._Pipeline = Pipeline

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Period(self):
        return self._Period

    @Period.setter
    def Period(self, Period):
        self._Period = Period


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._Type = params.get("Type")
        self._InputOutputId = params.get("InputOutputId")
        self._Pipeline = params.get("Pipeline")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Period = params.get("Period")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeStreamLinkFlowSRTStatisticsResponse(AbstractModel):
    """DescribeStreamLinkFlowSRTStatistics返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Infos: 传输流的SRT质量数据列表。
        :type Infos: list of FlowSRTInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Infos = None
        self._RequestId = None

    @property
    def Infos(self):
        return self._Infos

    @Infos.setter
    def Infos(self, Infos):
        self._Infos = Infos

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Infos") is not None:
            self._Infos = []
            for item in params.get("Infos"):
                obj = FlowSRTInfo()
                obj._deserialize(item)
                self._Infos.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeStreamLinkFlowStatisticsRequest(AbstractModel):
    """DescribeStreamLinkFlowStatistics请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FlowId: 传输流ID。
        :type FlowId: str
        :param _Type: 输入或输出类型，可选[input|output]。
        :type Type: str
        :param _InputOutputId: 输入或输出Id。
        :type InputOutputId: str
        :param _Pipeline: 主通道或备通道，可选[0|1]。
        :type Pipeline: str
        :param _Period: 查询间隔，可选[5s|1min|5min|15min]。
        :type Period: str
        :param _StartTime: 统计的开始时间，默认为前一小时，最多支持查询近7天。
UTC时间，如'2020-01-01T12:00:00Z'。
        :type StartTime: str
        :param _EndTime: 统计的结束时间，默认为StartTime后一小时，最多支持查询24小时的数据。
UTC时间，如'2020-01-01T12:00:00Z'。
        :type EndTime: str
        """
        self._FlowId = None
        self._Type = None
        self._InputOutputId = None
        self._Pipeline = None
        self._Period = None
        self._StartTime = None
        self._EndTime = None

    @property
    def FlowId(self):
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def InputOutputId(self):
        return self._InputOutputId

    @InputOutputId.setter
    def InputOutputId(self, InputOutputId):
        self._InputOutputId = InputOutputId

    @property
    def Pipeline(self):
        return self._Pipeline

    @Pipeline.setter
    def Pipeline(self, Pipeline):
        self._Pipeline = Pipeline

    @property
    def Period(self):
        return self._Period

    @Period.setter
    def Period(self, Period):
        self._Period = Period

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._Type = params.get("Type")
        self._InputOutputId = params.get("InputOutputId")
        self._Pipeline = params.get("Pipeline")
        self._Period = params.get("Period")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeStreamLinkFlowStatisticsResponse(AbstractModel):
    """DescribeStreamLinkFlowStatistics返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Infos: 传输流的媒体数据列表。
        :type Infos: list of FlowStatisticsArray
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Infos = None
        self._RequestId = None

    @property
    def Infos(self):
        return self._Infos

    @Infos.setter
    def Infos(self, Infos):
        self._Infos = Infos

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Infos") is not None:
            self._Infos = []
            for item in params.get("Infos"):
                obj = FlowStatisticsArray()
                obj._deserialize(item)
                self._Infos.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeStreamLinkFlowsRequest(AbstractModel):
    """DescribeStreamLinkFlows请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PageNum: 当前页数，默认1。
        :type PageNum: int
        :param _PageSize: 每页大小，默认10。
        :type PageSize: int
        """
        self._PageNum = None
        self._PageSize = None

    @property
    def PageNum(self):
        return self._PageNum

    @PageNum.setter
    def PageNum(self, PageNum):
        self._PageNum = PageNum

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        self._PageNum = params.get("PageNum")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeStreamLinkFlowsResponse(AbstractModel):
    """DescribeStreamLinkFlows返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Infos: 流的配置信息列表。
        :type Infos: list of DescribeFlow
        :param _PageNum: 当前页数。
        :type PageNum: int
        :param _PageSize: 每页大小。
        :type PageSize: int
        :param _TotalNum: 总数量。
        :type TotalNum: int
        :param _TotalPage: 总页数。
        :type TotalPage: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Infos = None
        self._PageNum = None
        self._PageSize = None
        self._TotalNum = None
        self._TotalPage = None
        self._RequestId = None

    @property
    def Infos(self):
        return self._Infos

    @Infos.setter
    def Infos(self, Infos):
        self._Infos = Infos

    @property
    def PageNum(self):
        return self._PageNum

    @PageNum.setter
    def PageNum(self, PageNum):
        self._PageNum = PageNum

    @property
    def PageSize(self):
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def TotalNum(self):
        return self._TotalNum

    @TotalNum.setter
    def TotalNum(self, TotalNum):
        self._TotalNum = TotalNum

    @property
    def TotalPage(self):
        return self._TotalPage

    @TotalPage.setter
    def TotalPage(self, TotalPage):
        self._TotalPage = TotalPage

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Infos") is not None:
            self._Infos = []
            for item in params.get("Infos"):
                obj = DescribeFlow()
                obj._deserialize(item)
                self._Infos.append(obj)
        self._PageNum = params.get("PageNum")
        self._PageSize = params.get("PageSize")
        self._TotalNum = params.get("TotalNum")
        self._TotalPage = params.get("TotalPage")
        self._RequestId = params.get("RequestId")


class DescribeStreamLinkRegionsRequest(AbstractModel):
    """DescribeStreamLinkRegions请求参数结构体

    """


class DescribeStreamLinkRegionsResponse(AbstractModel):
    """DescribeStreamLinkRegions返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Info: 媒体传输地区信息。
        :type Info: :class:`tencentcloud.mps.v20190612.models.StreamLinkRegionInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Info = None
        self._RequestId = None

    @property
    def Info(self):
        return self._Info

    @Info.setter
    def Info(self, Info):
        self._Info = Info

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Info") is not None:
            self._Info = StreamLinkRegionInfo()
            self._Info._deserialize(params.get("Info"))
        self._RequestId = params.get("RequestId")


class DescribeTaskDetailRequest(AbstractModel):
    """DescribeTaskDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 视频处理任务的任务 ID。
        :type TaskId: str
        """
        self._TaskId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskDetailResponse(AbstractModel):
    """DescribeTaskDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskType: 任务类型，目前取值有：<li>WorkflowTask：视频工作流处理任务。</li><li>EditMediaTask：视频编辑任务。</li><li>LiveStreamProcessTask：直播流处理任务。</li><li>ScheduleTask：编排处理任务。</li><li>EvaluationTask：评测任务。</li>
        :type TaskType: str
        :param _Status: 任务状态，取值：
<li>WAITING：等待中；</li>
<li>PROCESSING：处理中；</li>
<li>FINISH：已完成。</li>
        :type Status: str
        :param _CreateTime: 任务的创建时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :type CreateTime: str
        :param _BeginProcessTime: 任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :type BeginProcessTime: str
        :param _FinishTime: 任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :type FinishTime: str
        :param _EditMediaTask: 视频编辑任务信息，仅当 TaskType 为 EditMediaTask，该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :type EditMediaTask: :class:`tencentcloud.mps.v20190612.models.EditMediaTask`
        :param _WorkflowTask: 视频处理任务信息，仅当 TaskType 为 WorkflowTask，该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :type WorkflowTask: :class:`tencentcloud.mps.v20190612.models.WorkflowTask`
        :param _LiveStreamProcessTask: 直播流处理任务信息，仅当 TaskType 为 LiveStreamProcessTask，该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :type LiveStreamProcessTask: :class:`tencentcloud.mps.v20190612.models.LiveStreamProcessTask`
        :param _TaskNotifyConfig: 任务的事件通知信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskNotifyConfig: :class:`tencentcloud.mps.v20190612.models.TaskNotifyConfig`
        :param _TasksPriority: 任务流的优先级，取值范围为 [-10, 10]。
        :type TasksPriority: int
        :param _SessionId: 用于去重的识别码，如果七天内曾有过相同的识别码的请求，则本次的请求会返回错误。最长50个字符，不带或者带空字符串表示不做去重。
        :type SessionId: str
        :param _SessionContext: 来源上下文，用于透传用户请求信息，任务流状态变更回调将返回该字段值，最长1000个字符。
        :type SessionContext: str
        :param _ExtInfo: 扩展信息字段，仅用于特定场景。
        :type ExtInfo: str
        :param _ScheduleTask: 编排处理任务信息，仅当 TaskType 为 ScheduleTask，该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :type ScheduleTask: :class:`tencentcloud.mps.v20190612.models.ScheduleTask`
        :param _LiveScheduleTask: 直播编排处理任务信息，仅当 TaskType 为 LiveScheduleTask，该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :type LiveScheduleTask: :class:`tencentcloud.mps.v20190612.models.LiveScheduleTask`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskType = None
        self._Status = None
        self._CreateTime = None
        self._BeginProcessTime = None
        self._FinishTime = None
        self._EditMediaTask = None
        self._WorkflowTask = None
        self._LiveStreamProcessTask = None
        self._TaskNotifyConfig = None
        self._TasksPriority = None
        self._SessionId = None
        self._SessionContext = None
        self._ExtInfo = None
        self._ScheduleTask = None
        self._LiveScheduleTask = None
        self._RequestId = None

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def BeginProcessTime(self):
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime

    @property
    def EditMediaTask(self):
        return self._EditMediaTask

    @EditMediaTask.setter
    def EditMediaTask(self, EditMediaTask):
        self._EditMediaTask = EditMediaTask

    @property
    def WorkflowTask(self):
        return self._WorkflowTask

    @WorkflowTask.setter
    def WorkflowTask(self, WorkflowTask):
        self._WorkflowTask = WorkflowTask

    @property
    def LiveStreamProcessTask(self):
        return self._LiveStreamProcessTask

    @LiveStreamProcessTask.setter
    def LiveStreamProcessTask(self, LiveStreamProcessTask):
        self._LiveStreamProcessTask = LiveStreamProcessTask

    @property
    def TaskNotifyConfig(self):
        return self._TaskNotifyConfig

    @TaskNotifyConfig.setter
    def TaskNotifyConfig(self, TaskNotifyConfig):
        self._TaskNotifyConfig = TaskNotifyConfig

    @property
    def TasksPriority(self):
        return self._TasksPriority

    @TasksPriority.setter
    def TasksPriority(self, TasksPriority):
        self._TasksPriority = TasksPriority

    @property
    def SessionId(self):
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def SessionContext(self):
        return self._SessionContext

    @SessionContext.setter
    def SessionContext(self, SessionContext):
        self._SessionContext = SessionContext

    @property
    def ExtInfo(self):
        return self._ExtInfo

    @ExtInfo.setter
    def ExtInfo(self, ExtInfo):
        self._ExtInfo = ExtInfo

    @property
    def ScheduleTask(self):
        return self._ScheduleTask

    @ScheduleTask.setter
    def ScheduleTask(self, ScheduleTask):
        self._ScheduleTask = ScheduleTask

    @property
    def LiveScheduleTask(self):
        return self._LiveScheduleTask

    @LiveScheduleTask.setter
    def LiveScheduleTask(self, LiveScheduleTask):
        self._LiveScheduleTask = LiveScheduleTask

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskType = params.get("TaskType")
        self._Status = params.get("Status")
        self._CreateTime = params.get("CreateTime")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        if params.get("EditMediaTask") is not None:
            self._EditMediaTask = EditMediaTask()
            self._EditMediaTask._deserialize(params.get("EditMediaTask"))
        if params.get("WorkflowTask") is not None:
            self._WorkflowTask = WorkflowTask()
            self._WorkflowTask._deserialize(params.get("WorkflowTask"))
        if params.get("LiveStreamProcessTask") is not None:
            self._LiveStreamProcessTask = LiveStreamProcessTask()
            self._LiveStreamProcessTask._deserialize(params.get("LiveStreamProcessTask"))
        if params.get("TaskNotifyConfig") is not None:
            self._TaskNotifyConfig = TaskNotifyConfig()
            self._TaskNotifyConfig._deserialize(params.get("TaskNotifyConfig"))
        self._TasksPriority = params.get("TasksPriority")
        self._SessionId = params.get("SessionId")
        self._SessionContext = params.get("SessionContext")
        self._ExtInfo = params.get("ExtInfo")
        if params.get("ScheduleTask") is not None:
            self._ScheduleTask = ScheduleTask()
            self._ScheduleTask._deserialize(params.get("ScheduleTask"))
        if params.get("LiveScheduleTask") is not None:
            self._LiveScheduleTask = LiveScheduleTask()
            self._LiveScheduleTask._deserialize(params.get("LiveScheduleTask"))
        self._RequestId = params.get("RequestId")


class DescribeTasksRequest(AbstractModel):
    """DescribeTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Status: 过滤条件：任务状态，可选值：WAITING（等待中）、PROCESSING（处理中）、FINISH（已完成）。
        :type Status: str
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        :param _ScrollToken: 翻页标识，分批拉取时使用：当单次请求无法拉取所有数据，接口将会返回 ScrollToken，下一次请求携带该 Token，将会从下一条记录开始获取。
        :type ScrollToken: str
        """
        self._Status = None
        self._Limit = None
        self._ScrollToken = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def ScrollToken(self):
        return self._ScrollToken

    @ScrollToken.setter
    def ScrollToken(self, ScrollToken):
        self._ScrollToken = ScrollToken


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._Limit = params.get("Limit")
        self._ScrollToken = params.get("ScrollToken")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTasksResponse(AbstractModel):
    """DescribeTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskSet: 任务概要列表。
        :type TaskSet: list of TaskSimpleInfo
        :param _ScrollToken: 翻页标识，当请求未返回所有数据，该字段表示下一条记录的 ID。当该字段为空字符串，说明已无更多数据。
        :type ScrollToken: str
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskSet = None
        self._ScrollToken = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def TaskSet(self):
        return self._TaskSet

    @TaskSet.setter
    def TaskSet(self, TaskSet):
        self._TaskSet = TaskSet

    @property
    def ScrollToken(self):
        return self._ScrollToken

    @ScrollToken.setter
    def ScrollToken(self, ScrollToken):
        self._ScrollToken = ScrollToken

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TaskSet") is not None:
            self._TaskSet = []
            for item in params.get("TaskSet"):
                obj = TaskSimpleInfo()
                obj._deserialize(item)
                self._TaskSet.append(obj)
        self._ScrollToken = params.get("ScrollToken")
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeTranscodeTemplatesRequest(AbstractModel):
    """DescribeTranscodeTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definitions: 转码模板唯一标识过滤条件，数组长度限制：100。
        :type Definitions: list of int
        :param _Type: 模板类型过滤条件，可选值：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :type Type: str
        :param _ContainerType: 封装格式过滤条件，可选值：
<li>Video：视频格式，可以同时包含视频流和音频流的封装格式板；</li>
<li>PureAudio：纯音频格式，只能包含音频流的封装格式。</li>
        :type ContainerType: str
        :param _TEHDType: （建议使用TranscodeType代替）极速高清过滤条件，用于过滤普通转码或极速高清转码模板，可选值：
<li>Common：普通转码模板；</li>
<li>TEHD：极速高清模板。</li>
        :type TEHDType: str
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        :param _TranscodeType: 模板类型（替换旧版本 TEHDType），可选值：
<li>Common：普通转码模板；</li>
<li>TEHD：视频极速高清，老的类型（建议使用 TEHD-100） 。</li>
<li>TEHD-100：视频极速高清</li>
<li>TEHD-200：音频极速高清</li>
<li>Enhance：音视频增强模板。</li>
默认空，不限制类型。

        :type TranscodeType: str
        """
        self._Definitions = None
        self._Type = None
        self._ContainerType = None
        self._TEHDType = None
        self._Offset = None
        self._Limit = None
        self._TranscodeType = None

    @property
    def Definitions(self):
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def ContainerType(self):
        return self._ContainerType

    @ContainerType.setter
    def ContainerType(self, ContainerType):
        self._ContainerType = ContainerType

    @property
    def TEHDType(self):
        return self._TEHDType

    @TEHDType.setter
    def TEHDType(self, TEHDType):
        self._TEHDType = TEHDType

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def TranscodeType(self):
        return self._TranscodeType

    @TranscodeType.setter
    def TranscodeType(self, TranscodeType):
        self._TranscodeType = TranscodeType


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Type = params.get("Type")
        self._ContainerType = params.get("ContainerType")
        self._TEHDType = params.get("TEHDType")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._TranscodeType = params.get("TranscodeType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTranscodeTemplatesResponse(AbstractModel):
    """DescribeTranscodeTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _TranscodeTemplateSet: 转码模板详情列表。
        :type TranscodeTemplateSet: list of TranscodeTemplate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._TranscodeTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TranscodeTemplateSet(self):
        return self._TranscodeTemplateSet

    @TranscodeTemplateSet.setter
    def TranscodeTemplateSet(self, TranscodeTemplateSet):
        self._TranscodeTemplateSet = TranscodeTemplateSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("TranscodeTemplateSet") is not None:
            self._TranscodeTemplateSet = []
            for item in params.get("TranscodeTemplateSet"):
                obj = TranscodeTemplate()
                obj._deserialize(item)
                self._TranscodeTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeWatermarkTemplatesRequest(AbstractModel):
    """DescribeWatermarkTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definitions: 水印模板唯一标识过滤条件，数组长度限制：100。
        :type Definitions: list of int
        :param _Type: 水印类型过滤条件，可选值：
<li>image：图片水印；</li>
<li>text：文字水印。</li>
        :type Type: str
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数
<li>默认值：10；</li>
<li>最大值：100。</li>
        :type Limit: int
        """
        self._Definitions = None
        self._Type = None
        self._Offset = None
        self._Limit = None

    @property
    def Definitions(self):
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Type = params.get("Type")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeWatermarkTemplatesResponse(AbstractModel):
    """DescribeWatermarkTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _WatermarkTemplateSet: 水印模板详情列表。
        :type WatermarkTemplateSet: list of WatermarkTemplate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._WatermarkTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def WatermarkTemplateSet(self):
        return self._WatermarkTemplateSet

    @WatermarkTemplateSet.setter
    def WatermarkTemplateSet(self, WatermarkTemplateSet):
        self._WatermarkTemplateSet = WatermarkTemplateSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("WatermarkTemplateSet") is not None:
            self._WatermarkTemplateSet = []
            for item in params.get("WatermarkTemplateSet"):
                obj = WatermarkTemplate()
                obj._deserialize(item)
                self._WatermarkTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeWordSamplesRequest(AbstractModel):
    """DescribeWordSamples请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Keywords: 关键词过滤条件，数组长度限制：100 个词。
        :type Keywords: list of str
        :param _Usages: <b>关键词应用场景过滤条件，可选值：</b>
1. Recognition.Ocr：通过光学字符识别技术，进行内容识别；
2. Recognition.Asr：通过音频识别技术，进行内容识别；
3. Review.Ocr：通过光学字符识别技术，进行不适宜内容的识别；
4. Review.Asr：通过音频识别技术，进行不适宜内容的识别；
<b>可合并简写为：</b>
5. Recognition：通过光学字符识别技术、音频识别技术，进行内容识别，等价于 1+2；
6. Review：通过光学字符识别技术、音频识别技术，进行不适宜内容的识别，等价于 3+4；
可多选，元素间关系为 or，即关键词的应用场景包含该字段集合中任意元素的记录，均符合该条件。
        :type Usages: list of str
        :param _Tags: 标签过滤条件，数组长度限制：20 个词。
        :type Tags: list of str
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：100，最大值：100。
        :type Limit: int
        """
        self._Keywords = None
        self._Usages = None
        self._Tags = None
        self._Offset = None
        self._Limit = None

    @property
    def Keywords(self):
        return self._Keywords

    @Keywords.setter
    def Keywords(self, Keywords):
        self._Keywords = Keywords

    @property
    def Usages(self):
        return self._Usages

    @Usages.setter
    def Usages(self, Usages):
        self._Usages = Usages

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._Keywords = params.get("Keywords")
        self._Usages = params.get("Usages")
        self._Tags = params.get("Tags")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeWordSamplesResponse(AbstractModel):
    """DescribeWordSamples返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合条件的记录总数。
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _WordSet: 关键词信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type WordSet: list of AiSampleWord
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._WordSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def WordSet(self):
        return self._WordSet

    @WordSet.setter
    def WordSet(self, WordSet):
        self._WordSet = WordSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("WordSet") is not None:
            self._WordSet = []
            for item in params.get("WordSet"):
                obj = AiSampleWord()
                obj._deserialize(item)
                self._WordSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeWorkflowsRequest(AbstractModel):
    """DescribeWorkflows请求参数结构体

    """

    def __init__(self):
        r"""
        :param _WorkflowIds: 工作流 ID 过滤条件，数组长度限制：100。
        :type WorkflowIds: list of int
        :param _Status: 工作流状态，取值范围：
<li>Enabled：已启用，</li>
<li>Disabled：已禁用。</li>
不填此参数，则不区分工作流状态。
        :type Status: str
        :param _Offset: 分页偏移量，默认值：0。
        :type Offset: int
        :param _Limit: 返回记录条数，默认值：10，最大值：100。
        :type Limit: int
        """
        self._WorkflowIds = None
        self._Status = None
        self._Offset = None
        self._Limit = None

    @property
    def WorkflowIds(self):
        return self._WorkflowIds

    @WorkflowIds.setter
    def WorkflowIds(self, WorkflowIds):
        self._WorkflowIds = WorkflowIds

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._WorkflowIds = params.get("WorkflowIds")
        self._Status = params.get("Status")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeWorkflowsResponse(AbstractModel):
    """DescribeWorkflows返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的记录总数。
        :type TotalCount: int
        :param _WorkflowInfoSet: 工作流信息数组。
        :type WorkflowInfoSet: list of WorkflowInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._WorkflowInfoSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def WorkflowInfoSet(self):
        return self._WorkflowInfoSet

    @WorkflowInfoSet.setter
    def WorkflowInfoSet(self, WorkflowInfoSet):
        self._WorkflowInfoSet = WorkflowInfoSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("WorkflowInfoSet") is not None:
            self._WorkflowInfoSet = []
            for item in params.get("WorkflowInfoSet"):
                obj = WorkflowInfo()
                obj._deserialize(item)
                self._WorkflowInfoSet.append(obj)
        self._RequestId = params.get("RequestId")


class DiagnoseResult(AbstractModel):
    """诊断结果项。

    """

    def __init__(self):
        r"""
        :param _Category: 诊断出的异常类别。
注意：此字段可能返回 null，表示取不到有效值。
        :type Category: str
        :param _Type: 诊断出的具体异常类型。
注意：此字段可能返回 null，表示取不到有效值。
        :type Type: str
        :param _Timestamp: 诊断出异常开始的PTS时间戳。
注意：此字段可能返回 null，表示取不到有效值。
        :type Timestamp: float
        :param _Description: 诊断出的异常描述。
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        :param _DateTime: 诊断到异常的北京时间，采用 ISO 日期格式。
注意：此字段可能返回 null，表示取不到有效值。
        :type DateTime: str
        :param _SeverityLevel: 诊断出的异常级别。
注意：此字段可能返回 null，表示取不到有效值。
        :type SeverityLevel: str
        """
        self._Category = None
        self._Type = None
        self._Timestamp = None
        self._Description = None
        self._DateTime = None
        self._SeverityLevel = None

    @property
    def Category(self):
        return self._Category

    @Category.setter
    def Category(self, Category):
        self._Category = Category

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Timestamp(self):
        return self._Timestamp

    @Timestamp.setter
    def Timestamp(self, Timestamp):
        self._Timestamp = Timestamp

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def DateTime(self):
        return self._DateTime

    @DateTime.setter
    def DateTime(self, DateTime):
        self._DateTime = DateTime

    @property
    def SeverityLevel(self):
        return self._SeverityLevel

    @SeverityLevel.setter
    def SeverityLevel(self, SeverityLevel):
        self._SeverityLevel = SeverityLevel


    def _deserialize(self, params):
        self._Category = params.get("Category")
        self._Type = params.get("Type")
        self._Timestamp = params.get("Timestamp")
        self._Description = params.get("Description")
        self._DateTime = params.get("DateTime")
        self._SeverityLevel = params.get("SeverityLevel")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisableScheduleRequest(AbstractModel):
    """DisableSchedule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ScheduleId: 编排唯一表示。
        :type ScheduleId: int
        """
        self._ScheduleId = None

    @property
    def ScheduleId(self):
        return self._ScheduleId

    @ScheduleId.setter
    def ScheduleId(self, ScheduleId):
        self._ScheduleId = ScheduleId


    def _deserialize(self, params):
        self._ScheduleId = params.get("ScheduleId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisableScheduleResponse(AbstractModel):
    """DisableSchedule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DisableWorkflowRequest(AbstractModel):
    """DisableWorkflow请求参数结构体

    """

    def __init__(self):
        r"""
        :param _WorkflowId: 工作流 ID。
        :type WorkflowId: int
        """
        self._WorkflowId = None

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId


    def _deserialize(self, params):
        self._WorkflowId = params.get("WorkflowId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisableWorkflowResponse(AbstractModel):
    """DisableWorkflow返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DrmInfo(AbstractModel):
    """Drm 加密信息。

    """

    def __init__(self):
        r"""
        :param _Type: 加密类型：
<li> simpleaes: aes-128 加密</li>
注意：此字段可能返回 null，表示取不到有效值。
        :type Type: str
        :param _SimpleAesDrm: SimpleAes 加密信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type SimpleAesDrm: :class:`tencentcloud.mps.v20190612.models.SimpleAesDrm`
        """
        self._Type = None
        self._SimpleAesDrm = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def SimpleAesDrm(self):
        return self._SimpleAesDrm

    @SimpleAesDrm.setter
    def SimpleAesDrm(self, SimpleAesDrm):
        self._SimpleAesDrm = SimpleAesDrm


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("SimpleAesDrm") is not None:
            self._SimpleAesDrm = SimpleAesDrm()
            self._SimpleAesDrm._deserialize(params.get("SimpleAesDrm"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EditMediaFileInfo(AbstractModel):
    """编辑点播视频文件信息

    """

    def __init__(self):
        r"""
        :param _InputInfo: 视频的输入信息。
        :type InputInfo: :class:`tencentcloud.mps.v20190612.models.MediaInputInfo`
        :param _StartTimeOffset: 【剪辑】任务生效，视频剪辑的起始时间偏移，单位：秒。
        :type StartTimeOffset: float
        :param _EndTimeOffset: 【剪辑】任务生效，视频剪辑的结束时间偏移，单位：秒。
        :type EndTimeOffset: float
        :param _Id: 【合成】任务必选，用于轨道元素中媒体关联源素材 ID。

注意：允许字母、数字、-、_ ，最长 32 字符
注意：此字段可能返回 null，表示取不到有效值。
        :type Id: str
        """
        self._InputInfo = None
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Id = None

    @property
    def InputInfo(self):
        return self._InputInfo

    @InputInfo.setter
    def InputInfo(self, InputInfo):
        self._InputInfo = InputInfo

    @property
    def StartTimeOffset(self):
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        if params.get("InputInfo") is not None:
            self._InputInfo = MediaInputInfo()
            self._InputInfo._deserialize(params.get("InputInfo"))
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EditMediaOutputConfig(AbstractModel):
    """编辑视频的结果文件输出配置。

    """

    def __init__(self):
        r"""
        :param _Container: 封装格式，可选值：mp4、hls、mov、flv、avi。默认是 mp4。
注意：此字段可能返回 null，表示取不到有效值。
        :type Container: str
        :param _Type: 剪辑模式，可选值 normal、fast。默认是精确剪辑 normal
注意：此字段可能返回 null，表示取不到有效值。
        :type Type: str
        """
        self._Container = None
        self._Type = None

    @property
    def Container(self):
        return self._Container

    @Container.setter
    def Container(self, Container):
        self._Container = Container

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Container = params.get("Container")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EditMediaRequest(AbstractModel):
    """EditMedia请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FileInfos: 输入的视频文件信息。
        :type FileInfos: list of EditMediaFileInfo
        :param _OutputStorage: 媒体处理输出文件的目标存储。
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _OutputObjectPath: 媒体处理输出文件的目标路径。

注意：对于复杂合成任务，路径中的文件名只可为数字、字母、-、_ 的组合，最长 64 个字符。

        :type OutputObjectPath: str
        :param _OutputConfig: 【剪辑】任务生成的文件配置。
        :type OutputConfig: :class:`tencentcloud.mps.v20190612.models.EditMediaOutputConfig`
        :param _ComposeConfig: 【合成】任务配置。

注意：当其不为空时，认为是合成任务，否则按剪辑任务处理。
        :type ComposeConfig: :class:`tencentcloud.mps.v20190612.models.ComposeMediaConfig`
        :param _TaskNotifyConfig: 任务的事件通知信息，不填代表不获取事件通知。
        :type TaskNotifyConfig: :class:`tencentcloud.mps.v20190612.models.TaskNotifyConfig`
        :param _TasksPriority: 任务优先级，数值越大优先级越高，取值范围是-10到 10，不填代表0。
        :type TasksPriority: int
        :param _SessionId: 用于去重的识别码，如果三天内曾有过相同的识别码的请求，则本次的请求会返回错误。最长 50 个字符，不带或者带空字符串表示不做去重。
        :type SessionId: str
        :param _SessionContext: 来源上下文，用于透传用户请求信息，任务流状态变更回调将返回该字段值，最长 1000 个字符。
        :type SessionContext: str
        """
        self._FileInfos = None
        self._OutputStorage = None
        self._OutputObjectPath = None
        self._OutputConfig = None
        self._ComposeConfig = None
        self._TaskNotifyConfig = None
        self._TasksPriority = None
        self._SessionId = None
        self._SessionContext = None

    @property
    def FileInfos(self):
        return self._FileInfos

    @FileInfos.setter
    def FileInfos(self, FileInfos):
        self._FileInfos = FileInfos

    @property
    def OutputStorage(self):
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage

    @property
    def OutputObjectPath(self):
        return self._OutputObjectPath

    @OutputObjectPath.setter
    def OutputObjectPath(self, OutputObjectPath):
        self._OutputObjectPath = OutputObjectPath

    @property
    def OutputConfig(self):
        return self._OutputConfig

    @OutputConfig.setter
    def OutputConfig(self, OutputConfig):
        self._OutputConfig = OutputConfig

    @property
    def ComposeConfig(self):
        return self._ComposeConfig

    @ComposeConfig.setter
    def ComposeConfig(self, ComposeConfig):
        self._ComposeConfig = ComposeConfig

    @property
    def TaskNotifyConfig(self):
        return self._TaskNotifyConfig

    @TaskNotifyConfig.setter
    def TaskNotifyConfig(self, TaskNotifyConfig):
        self._TaskNotifyConfig = TaskNotifyConfig

    @property
    def TasksPriority(self):
        return self._TasksPriority

    @TasksPriority.setter
    def TasksPriority(self, TasksPriority):
        self._TasksPriority = TasksPriority

    @property
    def SessionId(self):
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def SessionContext(self):
        return self._SessionContext

    @SessionContext.setter
    def SessionContext(self, SessionContext):
        self._SessionContext = SessionContext


    def _deserialize(self, params):
        if params.get("FileInfos") is not None:
            self._FileInfos = []
            for item in params.get("FileInfos"):
                obj = EditMediaFileInfo()
                obj._deserialize(item)
                self._FileInfos.append(obj)
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        self._OutputObjectPath = params.get("OutputObjectPath")
        if params.get("OutputConfig") is not None:
            self._OutputConfig = EditMediaOutputConfig()
            self._OutputConfig._deserialize(params.get("OutputConfig"))
        if params.get("ComposeConfig") is not None:
            self._ComposeConfig = ComposeMediaConfig()
            self._ComposeConfig._deserialize(params.get("ComposeConfig"))
        if params.get("TaskNotifyConfig") is not None:
            self._TaskNotifyConfig = TaskNotifyConfig()
            self._TaskNotifyConfig._deserialize(params.get("TaskNotifyConfig"))
        self._TasksPriority = params.get("TasksPriority")
        self._SessionId = params.get("SessionId")
        self._SessionContext = params.get("SessionContext")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EditMediaResponse(AbstractModel):
    """EditMedia返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 编辑视频的任务 ID，可以通过该 ID 查询编辑任务的状态。
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class EditMediaTask(AbstractModel):
    """编辑视频任务信息

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务 ID。
        :type TaskId: str
        :param _Status: 任务状态，取值：
<li>PROCESSING：处理中；</li>
<li>FINISH：已完成。</li>
        :type Status: str
        :param _ErrCode: 错误码
<li>0：成功；</li>
<li>其他值：失败。</li>
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 视频编辑任务的输入。
        :type Input: :class:`tencentcloud.mps.v20190612.models.EditMediaTaskInput`
        :param _Output: 视频编辑任务的输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.EditMediaTaskOutput`
        """
        self._TaskId = None
        self._Status = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Status = params.get("Status")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = EditMediaTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = EditMediaTaskOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EditMediaTaskInput(AbstractModel):
    """编辑视频任务的输入。

    """

    def __init__(self):
        r"""
        :param _FileInfoSet: 输入的视频文件信息。
        :type FileInfoSet: list of EditMediaFileInfo
        """
        self._FileInfoSet = None

    @property
    def FileInfoSet(self):
        return self._FileInfoSet

    @FileInfoSet.setter
    def FileInfoSet(self, FileInfoSet):
        self._FileInfoSet = FileInfoSet


    def _deserialize(self, params):
        if params.get("FileInfoSet") is not None:
            self._FileInfoSet = []
            for item in params.get("FileInfoSet"):
                obj = EditMediaFileInfo()
                obj._deserialize(item)
                self._FileInfoSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EditMediaTaskOutput(AbstractModel):
    """编辑视频任务的输出

    """

    def __init__(self):
        r"""
        :param _OutputStorage: 编辑后文件的目标存储。
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _Path: 编辑后的视频文件路径。
        :type Path: str
        :param _MetaData: 编辑后的视频文件元信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type MetaData: :class:`tencentcloud.mps.v20190612.models.MediaMetaData`
        """
        self._OutputStorage = None
        self._Path = None
        self._MetaData = None

    @property
    def OutputStorage(self):
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage

    @property
    def Path(self):
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def MetaData(self):
        return self._MetaData

    @MetaData.setter
    def MetaData(self, MetaData):
        self._MetaData = MetaData


    def _deserialize(self, params):
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        self._Path = params.get("Path")
        if params.get("MetaData") is not None:
            self._MetaData = MediaMetaData()
            self._MetaData._deserialize(params.get("MetaData"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EnableScheduleRequest(AbstractModel):
    """EnableSchedule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ScheduleId: 编排唯一标识。
        :type ScheduleId: int
        """
        self._ScheduleId = None

    @property
    def ScheduleId(self):
        return self._ScheduleId

    @ScheduleId.setter
    def ScheduleId(self, ScheduleId):
        self._ScheduleId = ScheduleId


    def _deserialize(self, params):
        self._ScheduleId = params.get("ScheduleId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EnableScheduleResponse(AbstractModel):
    """EnableSchedule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class EnableWorkflowRequest(AbstractModel):
    """EnableWorkflow请求参数结构体

    """

    def __init__(self):
        r"""
        :param _WorkflowId: 工作流 ID。
        :type WorkflowId: int
        """
        self._WorkflowId = None

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId


    def _deserialize(self, params):
        self._WorkflowId = params.get("WorkflowId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EnableWorkflowResponse(AbstractModel):
    """EnableWorkflow返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class EnhanceConfig(AbstractModel):
    """音视频增强配置

    """

    def __init__(self):
        r"""
        :param _VideoEnhance: 视频增强配置。
注意：此字段可能返回 null，表示取不到有效值。
        :type VideoEnhance: :class:`tencentcloud.mps.v20190612.models.VideoEnhanceConfig`
        :param _AudioEnhance: 音频增强配置。
注意：此字段可能返回 null，表示取不到有效值。
        :type AudioEnhance: :class:`tencentcloud.mps.v20190612.models.AudioEnhanceConfig`
        """
        self._VideoEnhance = None
        self._AudioEnhance = None

    @property
    def VideoEnhance(self):
        return self._VideoEnhance

    @VideoEnhance.setter
    def VideoEnhance(self, VideoEnhance):
        self._VideoEnhance = VideoEnhance

    @property
    def AudioEnhance(self):
        return self._AudioEnhance

    @AudioEnhance.setter
    def AudioEnhance(self, AudioEnhance):
        self._AudioEnhance = AudioEnhance


    def _deserialize(self, params):
        if params.get("VideoEnhance") is not None:
            self._VideoEnhance = VideoEnhanceConfig()
            self._VideoEnhance._deserialize(params.get("VideoEnhance"))
        if params.get("AudioEnhance") is not None:
            self._AudioEnhance = AudioEnhanceConfig()
            self._AudioEnhance._deserialize(params.get("AudioEnhance"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExecuteFunctionRequest(AbstractModel):
    """ExecuteFunction请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FunctionName: 调用后端接口名称。
        :type FunctionName: str
        :param _FunctionArg: 接口参数，具体参数格式调用时与后端协调。
        :type FunctionArg: str
        """
        self._FunctionName = None
        self._FunctionArg = None

    @property
    def FunctionName(self):
        return self._FunctionName

    @FunctionName.setter
    def FunctionName(self, FunctionName):
        self._FunctionName = FunctionName

    @property
    def FunctionArg(self):
        return self._FunctionArg

    @FunctionArg.setter
    def FunctionArg(self, FunctionArg):
        self._FunctionArg = FunctionArg


    def _deserialize(self, params):
        self._FunctionName = params.get("FunctionName")
        self._FunctionArg = params.get("FunctionArg")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExecuteFunctionResponse(AbstractModel):
    """ExecuteFunction返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 处理结果打包后的字符串，具体与后台一同协调。
        :type Result: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class ExpressionConfigInfo(AbstractModel):
    """表情识别参数配置

    """

    def __init__(self):
        r"""
        :param _Switch: 表情识别任务开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FaceConfigureInfo(AbstractModel):
    """人脸识别任务控制参数

    """

    def __init__(self):
        r"""
        :param _Switch: 人脸识别任务开关，可选值：
<li>ON：开启智能人脸识别任务；</li>
<li>OFF：关闭智能人脸识别任务。</li>
        :type Switch: str
        :param _Score: 人脸识别过滤分数，当识别结果达到该分数以上，返回识别结果。默认 95 分。取值范围：0 - 100。
        :type Score: float
        :param _DefaultLibraryLabelSet: 默认人物过滤标签，指定需要返回的默认人物的标签。如果未填或者为空，则全部默认人物结果都返回。标签可选值：
<li>entertainment：娱乐明星；</li>
<li>sport：体育明星；</li>
<li>politician：敏感人物。</li>
        :type DefaultLibraryLabelSet: list of str
        :param _UserDefineLibraryLabelSet: 用户自定义人物过滤标签，指定需要返回的用户自定义人物的标签。如果未填或者为空，则全部自定义人物结果都返回。
标签个数最多 100 个，每个标签长度最多 16 个字符。
        :type UserDefineLibraryLabelSet: list of str
        :param _FaceLibrary: 人物库选择，可选值：
<li>Default：使用默认人物库；</li>
<li>UserDefine：使用用户自定义人物库。</li>
<li>All：同时使用默认人物库和用户自定义人物库。</li>
默认值：All，使用系统默认人物库及用户自定义人物库。
        :type FaceLibrary: str
        """
        self._Switch = None
        self._Score = None
        self._DefaultLibraryLabelSet = None
        self._UserDefineLibraryLabelSet = None
        self._FaceLibrary = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Score(self):
        return self._Score

    @Score.setter
    def Score(self, Score):
        self._Score = Score

    @property
    def DefaultLibraryLabelSet(self):
        return self._DefaultLibraryLabelSet

    @DefaultLibraryLabelSet.setter
    def DefaultLibraryLabelSet(self, DefaultLibraryLabelSet):
        self._DefaultLibraryLabelSet = DefaultLibraryLabelSet

    @property
    def UserDefineLibraryLabelSet(self):
        return self._UserDefineLibraryLabelSet

    @UserDefineLibraryLabelSet.setter
    def UserDefineLibraryLabelSet(self, UserDefineLibraryLabelSet):
        self._UserDefineLibraryLabelSet = UserDefineLibraryLabelSet

    @property
    def FaceLibrary(self):
        return self._FaceLibrary

    @FaceLibrary.setter
    def FaceLibrary(self, FaceLibrary):
        self._FaceLibrary = FaceLibrary


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Score = params.get("Score")
        self._DefaultLibraryLabelSet = params.get("DefaultLibraryLabelSet")
        self._UserDefineLibraryLabelSet = params.get("UserDefineLibraryLabelSet")
        self._FaceLibrary = params.get("FaceLibrary")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FaceConfigureInfoForUpdate(AbstractModel):
    """人脸识别任务控制参数

    """

    def __init__(self):
        r"""
        :param _Switch: 人脸识别任务开关，可选值：
<li>ON：开启智能人脸识别任务；</li>
<li>OFF：关闭智能人脸识别任务。</li>
        :type Switch: str
        :param _Score: 人脸识别过滤分数，当识别结果达到该分数以上，返回识别结果。取值范围：0-100。
        :type Score: float
        :param _DefaultLibraryLabelSet: 默认人物过滤标签，指定需要返回的默认人物的标签。如果未填或者为空，则全部默认人物结果都返回。标签可选值：
<li>entertainment：娱乐明星；</li>
<li>sport：体育明星；</li>
<li>politician：敏感人物。</li>
        :type DefaultLibraryLabelSet: list of str
        :param _UserDefineLibraryLabelSet: 用户自定义人物过滤标签，指定需要返回的用户自定义人物的标签。如果未填或者为空，则全部自定义人物结果都返回。
标签个数最多 100 个，每个标签长度最多 16 个字符。
        :type UserDefineLibraryLabelSet: list of str
        :param _FaceLibrary: 人物库选择，可选值：
<li>Default：使用默认人物库；</li>
<li>UserDefine：使用用户自定义人物库。</li>
<li>All：同时使用默认人物库和用户自定义人物库。</li>
        :type FaceLibrary: str
        """
        self._Switch = None
        self._Score = None
        self._DefaultLibraryLabelSet = None
        self._UserDefineLibraryLabelSet = None
        self._FaceLibrary = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Score(self):
        return self._Score

    @Score.setter
    def Score(self, Score):
        self._Score = Score

    @property
    def DefaultLibraryLabelSet(self):
        return self._DefaultLibraryLabelSet

    @DefaultLibraryLabelSet.setter
    def DefaultLibraryLabelSet(self, DefaultLibraryLabelSet):
        self._DefaultLibraryLabelSet = DefaultLibraryLabelSet

    @property
    def UserDefineLibraryLabelSet(self):
        return self._UserDefineLibraryLabelSet

    @UserDefineLibraryLabelSet.setter
    def UserDefineLibraryLabelSet(self, UserDefineLibraryLabelSet):
        self._UserDefineLibraryLabelSet = UserDefineLibraryLabelSet

    @property
    def FaceLibrary(self):
        return self._FaceLibrary

    @FaceLibrary.setter
    def FaceLibrary(self, FaceLibrary):
        self._FaceLibrary = FaceLibrary


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Score = params.get("Score")
        self._DefaultLibraryLabelSet = params.get("DefaultLibraryLabelSet")
        self._UserDefineLibraryLabelSet = params.get("UserDefineLibraryLabelSet")
        self._FaceLibrary = params.get("FaceLibrary")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FaceEnhanceConfig(AbstractModel):
    """人脸增强配置

    """

    def __init__(self):
        r"""
        :param _Switch: 能力配置开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
默认值：ON。
        :type Switch: str
        :param _Intensity: 强度，取值范围：0.0~1.0。
默认：0.0。
注意：此字段可能返回 null，表示取不到有效值。
        :type Intensity: float
        """
        self._Switch = None
        self._Intensity = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Intensity(self):
        return self._Intensity

    @Intensity.setter
    def Intensity(self, Intensity):
        self._Intensity = Intensity


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Intensity = params.get("Intensity")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FlowAudio(AbstractModel):
    """流的音频数据。

    """

    def __init__(self):
        r"""
        :param _Fps: 帧率。
        :type Fps: int
        :param _Rate: 码率，单位是bps。
        :type Rate: int
        :param _Pid: 音频Pid。
        :type Pid: int
        """
        self._Fps = None
        self._Rate = None
        self._Pid = None

    @property
    def Fps(self):
        return self._Fps

    @Fps.setter
    def Fps(self, Fps):
        self._Fps = Fps

    @property
    def Rate(self):
        return self._Rate

    @Rate.setter
    def Rate(self, Rate):
        self._Rate = Rate

    @property
    def Pid(self):
        return self._Pid

    @Pid.setter
    def Pid(self, Pid):
        self._Pid = Pid


    def _deserialize(self, params):
        self._Fps = params.get("Fps")
        self._Rate = params.get("Rate")
        self._Pid = params.get("Pid")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FlowLogInfo(AbstractModel):
    """传输流日志信息。

    """

    def __init__(self):
        r"""
        :param _Timestamp: 时间戳，单位为秒。
        :type Timestamp: int
        :param _Type: 输入输出类型（input/output）。
        :type Type: str
        :param _InputOutputId: 输入或输出Id。
        :type InputOutputId: str
        :param _Protocol: 协议。
        :type Protocol: str
        :param _EventCode: 事件代码。
        :type EventCode: str
        :param _EventMessage: 事件信息。
        :type EventMessage: str
        :param _RemoteIp: 对端IP。
        :type RemoteIp: str
        :param _RemotePort: 对端端口。
        :type RemotePort: str
        :param _Pipeline: 主备通道，0为主通道，1为备通道。
        :type Pipeline: str
        :param _InputOutputName: 输入或输出的名称。
        :type InputOutputName: str
        """
        self._Timestamp = None
        self._Type = None
        self._InputOutputId = None
        self._Protocol = None
        self._EventCode = None
        self._EventMessage = None
        self._RemoteIp = None
        self._RemotePort = None
        self._Pipeline = None
        self._InputOutputName = None

    @property
    def Timestamp(self):
        return self._Timestamp

    @Timestamp.setter
    def Timestamp(self, Timestamp):
        self._Timestamp = Timestamp

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def InputOutputId(self):
        return self._InputOutputId

    @InputOutputId.setter
    def InputOutputId(self, InputOutputId):
        self._InputOutputId = InputOutputId

    @property
    def Protocol(self):
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def EventCode(self):
        return self._EventCode

    @EventCode.setter
    def EventCode(self, EventCode):
        self._EventCode = EventCode

    @property
    def EventMessage(self):
        return self._EventMessage

    @EventMessage.setter
    def EventMessage(self, EventMessage):
        self._EventMessage = EventMessage

    @property
    def RemoteIp(self):
        return self._RemoteIp

    @RemoteIp.setter
    def RemoteIp(self, RemoteIp):
        self._RemoteIp = RemoteIp

    @property
    def RemotePort(self):
        return self._RemotePort

    @RemotePort.setter
    def RemotePort(self, RemotePort):
        self._RemotePort = RemotePort

    @property
    def Pipeline(self):
        return self._Pipeline

    @Pipeline.setter
    def Pipeline(self, Pipeline):
        self._Pipeline = Pipeline

    @property
    def InputOutputName(self):
        return self._InputOutputName

    @InputOutputName.setter
    def InputOutputName(self, InputOutputName):
        self._InputOutputName = InputOutputName


    def _deserialize(self, params):
        self._Timestamp = params.get("Timestamp")
        self._Type = params.get("Type")
        self._InputOutputId = params.get("InputOutputId")
        self._Protocol = params.get("Protocol")
        self._EventCode = params.get("EventCode")
        self._EventMessage = params.get("EventMessage")
        self._RemoteIp = params.get("RemoteIp")
        self._RemotePort = params.get("RemotePort")
        self._Pipeline = params.get("Pipeline")
        self._InputOutputName = params.get("InputOutputName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FlowMediaAudio(AbstractModel):
    """传输流媒体的音频数据。

    """

    def __init__(self):
        r"""
        :param _Fps: 帧率。
        :type Fps: int
        :param _Rate: 码率，单位是bps。
        :type Rate: int
        :param _Pid: 音频Pid。
        :type Pid: int
        :param _SessionId: 标志同一次推流。
        :type SessionId: str
        """
        self._Fps = None
        self._Rate = None
        self._Pid = None
        self._SessionId = None

    @property
    def Fps(self):
        return self._Fps

    @Fps.setter
    def Fps(self, Fps):
        self._Fps = Fps

    @property
    def Rate(self):
        return self._Rate

    @Rate.setter
    def Rate(self, Rate):
        self._Rate = Rate

    @property
    def Pid(self):
        return self._Pid

    @Pid.setter
    def Pid(self, Pid):
        self._Pid = Pid

    @property
    def SessionId(self):
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId


    def _deserialize(self, params):
        self._Fps = params.get("Fps")
        self._Rate = params.get("Rate")
        self._Pid = params.get("Pid")
        self._SessionId = params.get("SessionId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FlowMediaInfo(AbstractModel):
    """传输流的媒体数据。

    """

    def __init__(self):
        r"""
        :param _Timestamp: 时间戳，单位是秒。
        :type Timestamp: int
        :param _Network: 总带宽。
        :type Network: int
        :param _Video: 传输流的视频数据。
        :type Video: list of FlowMediaVideo
        :param _Audio: 传输流的音频数据。
        :type Audio: list of FlowMediaAudio
        :param _SessionId: 标志同一次推流。
        :type SessionId: str
        :param _ClientIp: 客户端IP。
        :type ClientIp: str
        """
        self._Timestamp = None
        self._Network = None
        self._Video = None
        self._Audio = None
        self._SessionId = None
        self._ClientIp = None

    @property
    def Timestamp(self):
        return self._Timestamp

    @Timestamp.setter
    def Timestamp(self, Timestamp):
        self._Timestamp = Timestamp

    @property
    def Network(self):
        return self._Network

    @Network.setter
    def Network(self, Network):
        self._Network = Network

    @property
    def Video(self):
        return self._Video

    @Video.setter
    def Video(self, Video):
        self._Video = Video

    @property
    def Audio(self):
        return self._Audio

    @Audio.setter
    def Audio(self, Audio):
        self._Audio = Audio

    @property
    def SessionId(self):
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def ClientIp(self):
        return self._ClientIp

    @ClientIp.setter
    def ClientIp(self, ClientIp):
        self._ClientIp = ClientIp


    def _deserialize(self, params):
        self._Timestamp = params.get("Timestamp")
        self._Network = params.get("Network")
        if params.get("Video") is not None:
            self._Video = []
            for item in params.get("Video"):
                obj = FlowMediaVideo()
                obj._deserialize(item)
                self._Video.append(obj)
        if params.get("Audio") is not None:
            self._Audio = []
            for item in params.get("Audio"):
                obj = FlowMediaAudio()
                obj._deserialize(item)
                self._Audio.append(obj)
        self._SessionId = params.get("SessionId")
        self._ClientIp = params.get("ClientIp")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FlowMediaVideo(AbstractModel):
    """传输流媒体的视频数据。

    """

    def __init__(self):
        r"""
        :param _Fps: 帧率。
        :type Fps: int
        :param _Rate: 码率，单位是bps。
        :type Rate: int
        :param _Pid: 视频Pid。
        :type Pid: int
        :param _SessionId: 标志同一次推流。
        :type SessionId: str
        """
        self._Fps = None
        self._Rate = None
        self._Pid = None
        self._SessionId = None

    @property
    def Fps(self):
        return self._Fps

    @Fps.setter
    def Fps(self, Fps):
        self._Fps = Fps

    @property
    def Rate(self):
        return self._Rate

    @Rate.setter
    def Rate(self, Rate):
        self._Rate = Rate

    @property
    def Pid(self):
        return self._Pid

    @Pid.setter
    def Pid(self, Pid):
        self._Pid = Pid

    @property
    def SessionId(self):
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId


    def _deserialize(self, params):
        self._Fps = params.get("Fps")
        self._Rate = params.get("Rate")
        self._Pid = params.get("Pid")
        self._SessionId = params.get("SessionId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FlowRealtimeStatusCommon(AbstractModel):
    """实时流状态查询的通用状态信息。

    """

    def __init__(self):
        r"""
        :param _State: 当前连接状态，Connected|Waiting|Idle。
        :type State: str
        :param _Mode: 连接模式，Listener|Caller。
        :type Mode: str
        :param _ConnectedTime: 已连接时长，单位为ms。
        :type ConnectedTime: int
        :param _Bitrate: 实时码率，单位为bps。
        :type Bitrate: int
        :param _Reconnections: 重试次数。
        :type Reconnections: int
        """
        self._State = None
        self._Mode = None
        self._ConnectedTime = None
        self._Bitrate = None
        self._Reconnections = None

    @property
    def State(self):
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def Mode(self):
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def ConnectedTime(self):
        return self._ConnectedTime

    @ConnectedTime.setter
    def ConnectedTime(self, ConnectedTime):
        self._ConnectedTime = ConnectedTime

    @property
    def Bitrate(self):
        return self._Bitrate

    @Bitrate.setter
    def Bitrate(self, Bitrate):
        self._Bitrate = Bitrate

    @property
    def Reconnections(self):
        return self._Reconnections

    @Reconnections.setter
    def Reconnections(self, Reconnections):
        self._Reconnections = Reconnections


    def _deserialize(self, params):
        self._State = params.get("State")
        self._Mode = params.get("Mode")
        self._ConnectedTime = params.get("ConnectedTime")
        self._Bitrate = params.get("Bitrate")
        self._Reconnections = params.get("Reconnections")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FlowRealtimeStatusItem(AbstractModel):
    """流状态实时查询接口的流状态信息

    """

    def __init__(self):
        r"""
        :param _Type: 类型，Input|Output。
        :type Type: str
        :param _InputId: 输入Id，如果Type为Input，此字段不为空。
        :type InputId: str
        :param _OutputId: 输出Id，如果Type为Output，此字段不为空。
        :type OutputId: str
        :param _FlowId: 流Id。
        :type FlowId: str
        :param _Protocol: 协议， SRT | RTMP。
        :type Protocol: str
        :param _CommonStatus: 共同状态信息。
        :type CommonStatus: :class:`tencentcloud.mps.v20190612.models.FlowRealtimeStatusCommon`
        :param _SRTStatus: 如果是SRT协议则有此字段。
注意：此字段可能返回 null，表示取不到有效值。
        :type SRTStatus: :class:`tencentcloud.mps.v20190612.models.FlowRealtimeStatusSRT`
        :param _RTMPStatus: 如果是RTMP协议则有此字段。
注意：此字段可能返回 null，表示取不到有效值。
        :type RTMPStatus: :class:`tencentcloud.mps.v20190612.models.FlowRealtimeStatusRTMP`
        :param _ConnectServerIP: 服务器IP。
        :type ConnectServerIP: str
        :param _RTPStatus: 如果是RTP协议则有此字段。
注意：此字段可能返回 null，表示取不到有效值。
        :type RTPStatus: :class:`tencentcloud.mps.v20190612.models.FlowRealtimeStatusRTP`
        """
        self._Type = None
        self._InputId = None
        self._OutputId = None
        self._FlowId = None
        self._Protocol = None
        self._CommonStatus = None
        self._SRTStatus = None
        self._RTMPStatus = None
        self._ConnectServerIP = None
        self._RTPStatus = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def InputId(self):
        return self._InputId

    @InputId.setter
    def InputId(self, InputId):
        self._InputId = InputId

    @property
    def OutputId(self):
        return self._OutputId

    @OutputId.setter
    def OutputId(self, OutputId):
        self._OutputId = OutputId

    @property
    def FlowId(self):
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def Protocol(self):
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def CommonStatus(self):
        return self._CommonStatus

    @CommonStatus.setter
    def CommonStatus(self, CommonStatus):
        self._CommonStatus = CommonStatus

    @property
    def SRTStatus(self):
        return self._SRTStatus

    @SRTStatus.setter
    def SRTStatus(self, SRTStatus):
        self._SRTStatus = SRTStatus

    @property
    def RTMPStatus(self):
        return self._RTMPStatus

    @RTMPStatus.setter
    def RTMPStatus(self, RTMPStatus):
        self._RTMPStatus = RTMPStatus

    @property
    def ConnectServerIP(self):
        return self._ConnectServerIP

    @ConnectServerIP.setter
    def ConnectServerIP(self, ConnectServerIP):
        self._ConnectServerIP = ConnectServerIP

    @property
    def RTPStatus(self):
        return self._RTPStatus

    @RTPStatus.setter
    def RTPStatus(self, RTPStatus):
        self._RTPStatus = RTPStatus


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._InputId = params.get("InputId")
        self._OutputId = params.get("OutputId")
        self._FlowId = params.get("FlowId")
        self._Protocol = params.get("Protocol")
        if params.get("CommonStatus") is not None:
            self._CommonStatus = FlowRealtimeStatusCommon()
            self._CommonStatus._deserialize(params.get("CommonStatus"))
        if params.get("SRTStatus") is not None:
            self._SRTStatus = FlowRealtimeStatusSRT()
            self._SRTStatus._deserialize(params.get("SRTStatus"))
        if params.get("RTMPStatus") is not None:
            self._RTMPStatus = FlowRealtimeStatusRTMP()
            self._RTMPStatus._deserialize(params.get("RTMPStatus"))
        self._ConnectServerIP = params.get("ConnectServerIP")
        if params.get("RTPStatus") is not None:
            self._RTPStatus = FlowRealtimeStatusRTP()
            self._RTPStatus._deserialize(params.get("RTPStatus"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FlowRealtimeStatusRTMP(AbstractModel):
    """流状态实时查询接口的RTMP信息。

    """

    def __init__(self):
        r"""
        :param _VideoFPS: 视频帧率。
        :type VideoFPS: int
        :param _AudioFPS: 音频帧率。
        :type AudioFPS: int
        """
        self._VideoFPS = None
        self._AudioFPS = None

    @property
    def VideoFPS(self):
        return self._VideoFPS

    @VideoFPS.setter
    def VideoFPS(self, VideoFPS):
        self._VideoFPS = VideoFPS

    @property
    def AudioFPS(self):
        return self._AudioFPS

    @AudioFPS.setter
    def AudioFPS(self, AudioFPS):
        self._AudioFPS = AudioFPS


    def _deserialize(self, params):
        self._VideoFPS = params.get("VideoFPS")
        self._AudioFPS = params.get("AudioFPS")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FlowRealtimeStatusRTP(AbstractModel):
    """流状态实时查询接口的RTP流状态信息

    """

    def __init__(self):
        r"""
        :param _Packets: 传输的包个数
        :type Packets: int
        """
        self._Packets = None

    @property
    def Packets(self):
        return self._Packets

    @Packets.setter
    def Packets(self, Packets):
        self._Packets = Packets


    def _deserialize(self, params):
        self._Packets = params.get("Packets")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FlowRealtimeStatusSRT(AbstractModel):
    """流状态实时查询接口的SRT信息。

    """

    def __init__(self):
        r"""
        :param _Latency: 延迟，单位为ms。
        :type Latency: int
        :param _RTT: RTT，单位为ms。
        :type RTT: int
        :param _Packets: 实时发包数或者收包数。
        :type Packets: int
        :param _PacketLossRate: 丢包率。
        :type PacketLossRate: float
        :param _RetransmitRate: 重传率。
        :type RetransmitRate: float
        :param _DroppedPackets: 实时丢包数。
        :type DroppedPackets: int
        :param _Encryption: 是否加密，On|Off。
        :type Encryption: str
        """
        self._Latency = None
        self._RTT = None
        self._Packets = None
        self._PacketLossRate = None
        self._RetransmitRate = None
        self._DroppedPackets = None
        self._Encryption = None

    @property
    def Latency(self):
        return self._Latency

    @Latency.setter
    def Latency(self, Latency):
        self._Latency = Latency

    @property
    def RTT(self):
        return self._RTT

    @RTT.setter
    def RTT(self, RTT):
        self._RTT = RTT

    @property
    def Packets(self):
        return self._Packets

    @Packets.setter
    def Packets(self, Packets):
        self._Packets = Packets

    @property
    def PacketLossRate(self):
        return self._PacketLossRate

    @PacketLossRate.setter
    def PacketLossRate(self, PacketLossRate):
        self._PacketLossRate = PacketLossRate

    @property
    def RetransmitRate(self):
        return self._RetransmitRate

    @RetransmitRate.setter
    def RetransmitRate(self, RetransmitRate):
        self._RetransmitRate = RetransmitRate

    @property
    def DroppedPackets(self):
        return self._DroppedPackets

    @DroppedPackets.setter
    def DroppedPackets(self, DroppedPackets):
        self._DroppedPackets = DroppedPackets

    @property
    def Encryption(self):
        return self._Encryption

    @Encryption.setter
    def Encryption(self, Encryption):
        self._Encryption = Encryption


    def _deserialize(self, params):
        self._Latency = params.get("Latency")
        self._RTT = params.get("RTT")
        self._Packets = params.get("Packets")
        self._PacketLossRate = params.get("PacketLossRate")
        self._RetransmitRate = params.get("RetransmitRate")
        self._DroppedPackets = params.get("DroppedPackets")
        self._Encryption = params.get("Encryption")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FlowSRTInfo(AbstractModel):
    """传输流的SRT质量数据。

    """

    def __init__(self):
        r"""
        :param _Timestamp: 时间戳，单位是秒。
        :type Timestamp: int
        :param _SendPacketLossRate: 发送丢包率。
        :type SendPacketLossRate: int
        :param _SendRetransmissionRate: 发送重传率。
        :type SendRetransmissionRate: int
        :param _RecvPacketLossRate: 接收丢包率。
        :type RecvPacketLossRate: int
        :param _RecvRetransmissionRate: 接收重传率。
        :type RecvRetransmissionRate: int
        :param _RTT: 与对端的RTT时延。
        :type RTT: int
        :param _SessionId: 标志同一次推流。
        :type SessionId: str
        :param _SendPacketDropNumber: 发送弃包数。
        :type SendPacketDropNumber: int
        :param _RecvPacketDropNumber: 接收弃包数。
        :type RecvPacketDropNumber: int
        """
        self._Timestamp = None
        self._SendPacketLossRate = None
        self._SendRetransmissionRate = None
        self._RecvPacketLossRate = None
        self._RecvRetransmissionRate = None
        self._RTT = None
        self._SessionId = None
        self._SendPacketDropNumber = None
        self._RecvPacketDropNumber = None

    @property
    def Timestamp(self):
        return self._Timestamp

    @Timestamp.setter
    def Timestamp(self, Timestamp):
        self._Timestamp = Timestamp

    @property
    def SendPacketLossRate(self):
        return self._SendPacketLossRate

    @SendPacketLossRate.setter
    def SendPacketLossRate(self, SendPacketLossRate):
        self._SendPacketLossRate = SendPacketLossRate

    @property
    def SendRetransmissionRate(self):
        return self._SendRetransmissionRate

    @SendRetransmissionRate.setter
    def SendRetransmissionRate(self, SendRetransmissionRate):
        self._SendRetransmissionRate = SendRetransmissionRate

    @property
    def RecvPacketLossRate(self):
        return self._RecvPacketLossRate

    @RecvPacketLossRate.setter
    def RecvPacketLossRate(self, RecvPacketLossRate):
        self._RecvPacketLossRate = RecvPacketLossRate

    @property
    def RecvRetransmissionRate(self):
        return self._RecvRetransmissionRate

    @RecvRetransmissionRate.setter
    def RecvRetransmissionRate(self, RecvRetransmissionRate):
        self._RecvRetransmissionRate = RecvRetransmissionRate

    @property
    def RTT(self):
        return self._RTT

    @RTT.setter
    def RTT(self, RTT):
        self._RTT = RTT

    @property
    def SessionId(self):
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def SendPacketDropNumber(self):
        return self._SendPacketDropNumber

    @SendPacketDropNumber.setter
    def SendPacketDropNumber(self, SendPacketDropNumber):
        self._SendPacketDropNumber = SendPacketDropNumber

    @property
    def RecvPacketDropNumber(self):
        return self._RecvPacketDropNumber

    @RecvPacketDropNumber.setter
    def RecvPacketDropNumber(self, RecvPacketDropNumber):
        self._RecvPacketDropNumber = RecvPacketDropNumber


    def _deserialize(self, params):
        self._Timestamp = params.get("Timestamp")
        self._SendPacketLossRate = params.get("SendPacketLossRate")
        self._SendRetransmissionRate = params.get("SendRetransmissionRate")
        self._RecvPacketLossRate = params.get("RecvPacketLossRate")
        self._RecvRetransmissionRate = params.get("RecvRetransmissionRate")
        self._RTT = params.get("RTT")
        self._SessionId = params.get("SessionId")
        self._SendPacketDropNumber = params.get("SendPacketDropNumber")
        self._RecvPacketDropNumber = params.get("RecvPacketDropNumber")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FlowStatistics(AbstractModel):
    """流的统计数据。

    """

    def __init__(self):
        r"""
        :param _SessionId: 会话Id。
        :type SessionId: str
        :param _ClientIp: 对端IP。
        :type ClientIp: str
        :param _Network: 总带宽。
        :type Network: int
        :param _Video: 视频数据。
        :type Video: list of FlowVideo
        :param _Audio: 音频数据。
        :type Audio: list of FlowAudio
        """
        self._SessionId = None
        self._ClientIp = None
        self._Network = None
        self._Video = None
        self._Audio = None

    @property
    def SessionId(self):
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def ClientIp(self):
        return self._ClientIp

    @ClientIp.setter
    def ClientIp(self, ClientIp):
        self._ClientIp = ClientIp

    @property
    def Network(self):
        return self._Network

    @Network.setter
    def Network(self, Network):
        self._Network = Network

    @property
    def Video(self):
        return self._Video

    @Video.setter
    def Video(self, Video):
        self._Video = Video

    @property
    def Audio(self):
        return self._Audio

    @Audio.setter
    def Audio(self, Audio):
        self._Audio = Audio


    def _deserialize(self, params):
        self._SessionId = params.get("SessionId")
        self._ClientIp = params.get("ClientIp")
        self._Network = params.get("Network")
        if params.get("Video") is not None:
            self._Video = []
            for item in params.get("Video"):
                obj = FlowVideo()
                obj._deserialize(item)
                self._Video.append(obj)
        if params.get("Audio") is not None:
            self._Audio = []
            for item in params.get("Audio"):
                obj = FlowAudio()
                obj._deserialize(item)
                self._Audio.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FlowStatisticsArray(AbstractModel):
    """流的统计数据列表。

    """

    def __init__(self):
        r"""
        :param _Timestamp: 时间戳。
        :type Timestamp: int
        :param _FlowStatistics: 每个会话的统计数据。
        :type FlowStatistics: list of FlowStatistics
        """
        self._Timestamp = None
        self._FlowStatistics = None

    @property
    def Timestamp(self):
        return self._Timestamp

    @Timestamp.setter
    def Timestamp(self, Timestamp):
        self._Timestamp = Timestamp

    @property
    def FlowStatistics(self):
        return self._FlowStatistics

    @FlowStatistics.setter
    def FlowStatistics(self, FlowStatistics):
        self._FlowStatistics = FlowStatistics


    def _deserialize(self, params):
        self._Timestamp = params.get("Timestamp")
        if params.get("FlowStatistics") is not None:
            self._FlowStatistics = []
            for item in params.get("FlowStatistics"):
                obj = FlowStatistics()
                obj._deserialize(item)
                self._FlowStatistics.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FlowVideo(AbstractModel):
    """流的视频数据。

    """

    def __init__(self):
        r"""
        :param _Fps: 帧率。
        :type Fps: int
        :param _Rate: 码率，单位是bps。
        :type Rate: int
        :param _Pid: 音频Pid。
        :type Pid: int
        """
        self._Fps = None
        self._Rate = None
        self._Pid = None

    @property
    def Fps(self):
        return self._Fps

    @Fps.setter
    def Fps(self, Fps):
        self._Fps = Fps

    @property
    def Rate(self):
        return self._Rate

    @Rate.setter
    def Rate(self, Rate):
        self._Rate = Rate

    @property
    def Pid(self):
        return self._Pid

    @Pid.setter
    def Pid(self, Pid):
        self._Pid = Pid


    def _deserialize(self, params):
        self._Fps = params.get("Fps")
        self._Rate = params.get("Rate")
        self._Pid = params.get("Pid")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FrameRateConfig(AbstractModel):
    """插帧帧率配置

    """

    def __init__(self):
        r"""
        :param _Switch: 能力配置开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
默认值：ON。
        :type Switch: str
        :param _Fps: 帧率，取值范围：[0, 100]，单位：Hz。
默认值 0。
注意：对于转码，该参数会覆盖 VideoTemplate 内部的 Fps。
注意：此字段可能返回 null，表示取不到有效值。
        :type Fps: int
        """
        self._Switch = None
        self._Fps = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Fps(self):
        return self._Fps

    @Fps.setter
    def Fps(self, Fps):
        self._Fps = Fps


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Fps = params.get("Fps")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FrameTagConfigureInfo(AbstractModel):
    """智能按帧标签任务控制参数

    """

    def __init__(self):
        r"""
        :param _Switch: 智能按帧标签任务开关，可选值：
<li>ON：开启智能按帧标签任务；</li>
<li>OFF：关闭智能按帧标签任务。</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FrameTagConfigureInfoForUpdate(AbstractModel):
    """智能按帧标签任务控制参数

    """

    def __init__(self):
        r"""
        :param _Switch: 智能按帧标签任务开关，可选值：
<li>ON：开启智能按帧标签任务；</li>
<li>OFF：关闭智能按帧标签任务。</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class HLSPullSourceAddress(AbstractModel):
    """创建的输入HLS拉流源站配置信息。

    """

    def __init__(self):
        r"""
        :param _Url: HLS源站的Url地址。
        :type Url: str
        """
        self._Url = None

    @property
    def Url(self):
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url


    def _deserialize(self, params):
        self._Url = params.get("Url")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class HdrConfig(AbstractModel):
    """HDR配置

    """

    def __init__(self):
        r"""
        :param _Switch: 能力配置开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
默认值：ON。
        :type Switch: str
        :param _Type: 类型，可选值：
<li>HDR10</li>
<li>HLG</li>
默认值：HDR10。
注意：video的编码方式需要为h265；
注意：视频编码位深为10。
注意：此字段可能返回 null，表示取不到有效值。
        :type Type: str
        """
        self._Switch = None
        self._Type = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class HeadTailParameter(AbstractModel):
    """片头片尾参数

    """

    def __init__(self):
        r"""
        :param _HeadSet: 片头列表。
注意：此字段可能返回 null，表示取不到有效值。
        :type HeadSet: list of MediaInputInfo
        :param _TailSet: 片尾列表。
注意：此字段可能返回 null，表示取不到有效值。
        :type TailSet: list of MediaInputInfo
        """
        self._HeadSet = None
        self._TailSet = None

    @property
    def HeadSet(self):
        return self._HeadSet

    @HeadSet.setter
    def HeadSet(self, HeadSet):
        self._HeadSet = HeadSet

    @property
    def TailSet(self):
        return self._TailSet

    @TailSet.setter
    def TailSet(self, TailSet):
        self._TailSet = TailSet


    def _deserialize(self, params):
        if params.get("HeadSet") is not None:
            self._HeadSet = []
            for item in params.get("HeadSet"):
                obj = MediaInputInfo()
                obj._deserialize(item)
                self._HeadSet.append(obj)
        if params.get("TailSet") is not None:
            self._TailSet = []
            for item in params.get("TailSet"):
                obj = MediaInputInfo()
                obj._deserialize(item)
                self._TailSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class HighlightSegmentItem(AbstractModel):
    """智能精彩集锦片段列表。

    """

    def __init__(self):
        r"""
        :param _Confidence: 置信度。
        :type Confidence: float
        :param _StartTimeOffset: 片段起始时间偏移。
        :type StartTimeOffset: float
        :param _EndTimeOffset: 片段结束时间偏移。
        :type EndTimeOffset: float
        """
        self._Confidence = None
        self._StartTimeOffset = None
        self._EndTimeOffset = None

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def StartTimeOffset(self):
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ImageQualityEnhanceConfig(AbstractModel):
    """综合增强配置

    """

    def __init__(self):
        r"""
        :param _Switch: 能力配置开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
默认值：ON。
        :type Switch: str
        :param _Type: 类型，可选值：
<li>weak</li>
<li>normal</li>
<li>strong</li>
默认值：weak。
注意：此字段可能返回 null，表示取不到有效值。
        :type Type: str
        """
        self._Switch = None
        self._Type = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ImageSpriteTaskInput(AbstractModel):
    """对视频截雪碧图任务输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 雪碧图模板 ID。
        :type Definition: int
        :param _OutputStorage: 截取雪碧图后文件的目标存储，不填则继承上层的 OutputStorage 值。
注意：此字段可能返回 null，表示取不到有效值。
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _OutputObjectPath: 截取雪碧图后，雪碧图图片文件的输出路径，可以为相对路径或者绝对路径。
若需定义输出路径，路径需以`.{format}`结尾。变量名请参考 [文件名变量说明](https://cloud.tencent.com/document/product/862/37039)。
相对路径示例：
<li>文件名_{变量名}.{format}</li>
<li>文件名.{format}</li>
绝对路径示例：
<li>/自定义路径/文件名_{变量名}.{format}</li>
如果不填，则默认为相对路径：`{inputName}_imageSprite_{definition}_{number}.{format}`。
        :type OutputObjectPath: str
        :param _WebVttObjectName: 截取雪碧图后，Web VTT 文件的输出路径，只能为相对路径。如果不填，则默认为相对路径：`{inputName}_imageSprite_{definition}.{format}`。
        :type WebVttObjectName: str
        :param _ObjectNumberFormat: 截取雪碧图后输出路径中的`{number}`变量的规则。
注意：此字段可能返回 null，表示取不到有效值。
        :type ObjectNumberFormat: :class:`tencentcloud.mps.v20190612.models.NumberFormat`
        """
        self._Definition = None
        self._OutputStorage = None
        self._OutputObjectPath = None
        self._WebVttObjectName = None
        self._ObjectNumberFormat = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def OutputStorage(self):
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage

    @property
    def OutputObjectPath(self):
        return self._OutputObjectPath

    @OutputObjectPath.setter
    def OutputObjectPath(self, OutputObjectPath):
        self._OutputObjectPath = OutputObjectPath

    @property
    def WebVttObjectName(self):
        return self._WebVttObjectName

    @WebVttObjectName.setter
    def WebVttObjectName(self, WebVttObjectName):
        self._WebVttObjectName = WebVttObjectName

    @property
    def ObjectNumberFormat(self):
        return self._ObjectNumberFormat

    @ObjectNumberFormat.setter
    def ObjectNumberFormat(self, ObjectNumberFormat):
        self._ObjectNumberFormat = ObjectNumberFormat


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        self._OutputObjectPath = params.get("OutputObjectPath")
        self._WebVttObjectName = params.get("WebVttObjectName")
        if params.get("ObjectNumberFormat") is not None:
            self._ObjectNumberFormat = NumberFormat()
            self._ObjectNumberFormat._deserialize(params.get("ObjectNumberFormat"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ImageSpriteTemplate(AbstractModel):
    """雪碧图模板详情

    """

    def __init__(self):
        r"""
        :param _Definition: 雪碧图模板唯一标识。
        :type Definition: int
        :param _Type: 模板类型，取值范围：
<li>Preset：系统预置模板；</li>
<li>Custom：用户自定义模板。</li>
        :type Type: str
        :param _Name: 雪碧图模板名称。
        :type Name: str
        :param _Width: 雪碧图中小图的宽度（或长边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :type Width: int
        :param _Height: 雪碧图中小图的高度（或短边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :type Height: int
        :param _ResolutionAdaptive: 分辨率自适应，可选值：
<li>open：开启，此时，Width 代表视频的长边，Height 表示视频的短边；</li>
<li>close：关闭，此时，Width 代表视频的宽度，Height 表示视频的高度。</li>
默认值：open。
        :type ResolutionAdaptive: str
        :param _SampleType: 采样类型。
        :type SampleType: str
        :param _SampleInterval: 采样间隔。
        :type SampleInterval: int
        :param _RowCount: 雪碧图中小图的行数。
        :type RowCount: int
        :param _ColumnCount: 雪碧图中小图的列数。
        :type ColumnCount: int
        :param _CreateTime: 模板创建时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :type CreateTime: str
        :param _UpdateTime: 模板最后修改时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :type UpdateTime: str
        :param _FillType: 填充方式，当视频流配置宽高参数与原始视频的宽高比不一致时，对转码的处理方式，即为“填充”。可选填充方式：
<li> stretch：拉伸，对每一帧进行拉伸，填满整个画面，可能导致转码后的视频被“压扁“或者“拉长“；</li>
<li>black：留黑，保持视频宽高比不变，边缘剩余部分使用黑色填充。</li>
默认值：black 。
        :type FillType: str
        :param _Comment: 模板描述信息。
        :type Comment: str
        :param _Format: 图片格式。
        :type Format: str
        """
        self._Definition = None
        self._Type = None
        self._Name = None
        self._Width = None
        self._Height = None
        self._ResolutionAdaptive = None
        self._SampleType = None
        self._SampleInterval = None
        self._RowCount = None
        self._ColumnCount = None
        self._CreateTime = None
        self._UpdateTime = None
        self._FillType = None
        self._Comment = None
        self._Format = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ResolutionAdaptive(self):
        return self._ResolutionAdaptive

    @ResolutionAdaptive.setter
    def ResolutionAdaptive(self, ResolutionAdaptive):
        self._ResolutionAdaptive = ResolutionAdaptive

    @property
    def SampleType(self):
        return self._SampleType

    @SampleType.setter
    def SampleType(self, SampleType):
        self._SampleType = SampleType

    @property
    def SampleInterval(self):
        return self._SampleInterval

    @SampleInterval.setter
    def SampleInterval(self, SampleInterval):
        self._SampleInterval = SampleInterval

    @property
    def RowCount(self):
        return self._RowCount

    @RowCount.setter
    def RowCount(self, RowCount):
        self._RowCount = RowCount

    @property
    def ColumnCount(self):
        return self._ColumnCount

    @ColumnCount.setter
    def ColumnCount(self, ColumnCount):
        self._ColumnCount = ColumnCount

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def FillType(self):
        return self._FillType

    @FillType.setter
    def FillType(self, FillType):
        self._FillType = FillType

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def Format(self):
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._ResolutionAdaptive = params.get("ResolutionAdaptive")
        self._SampleType = params.get("SampleType")
        self._SampleInterval = params.get("SampleInterval")
        self._RowCount = params.get("RowCount")
        self._ColumnCount = params.get("ColumnCount")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._FillType = params.get("FillType")
        self._Comment = params.get("Comment")
        self._Format = params.get("Format")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ImageWatermarkInput(AbstractModel):
    """图片水印模板输入参数

    """

    def __init__(self):
        r"""
        :param _ImageContent: 水印图片 [Base64](https://tools.ietf.org/html/rfc4648) 编码后的字符串。支持 jpeg、png 图片格式。
        :type ImageContent: str
        :param _Width: 水印的宽度。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示水印 Width 为视频宽度的百分比大小，如 10% 表示 Width 为视频宽度的 10%；</li>
<li>当字符串以 px 结尾，表示水印 Width 单位为像素，如 100px 表示 Width 为 100 像素。取值范围为[8, 4096]。</li>
当宽高都不填或者为0时，默认为 10%。
        :type Width: str
        :param _Height: 水印的高度。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示水印 Height 为视频高度的百分比大小，如 10% 表示 Height 为视频高度的 10%；</li>
<li>当字符串以 px 结尾，表示水印 Height 单位为像素，如 100px 表示 Height 为 100 像素。取值范围为0或[8, 4096]。</li>
默认值：0px，表示 Height 按照原始水印图片的宽高比缩放。
        :type Height: str
        :param _RepeatType: 水印重复类型。使用场景：水印为动态图像。取值范围：
<li>once：动态水印播放完后，不再出现；</li>
<li>repeat_last_frame：水印播放完后，停留在最后一帧；</li>
<li>repeat：水印循环播放，直到视频结束（默认值）。</li>
        :type RepeatType: str
        """
        self._ImageContent = None
        self._Width = None
        self._Height = None
        self._RepeatType = None

    @property
    def ImageContent(self):
        return self._ImageContent

    @ImageContent.setter
    def ImageContent(self, ImageContent):
        self._ImageContent = ImageContent

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def RepeatType(self):
        return self._RepeatType

    @RepeatType.setter
    def RepeatType(self, RepeatType):
        self._RepeatType = RepeatType


    def _deserialize(self, params):
        self._ImageContent = params.get("ImageContent")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._RepeatType = params.get("RepeatType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ImageWatermarkInputForUpdate(AbstractModel):
    """图片水印模板输入参数

    """

    def __init__(self):
        r"""
        :param _ImageContent: 水印图片 [Base64](https://tools.ietf.org/html/rfc4648) 编码后的字符串。支持 jpeg、png 图片格式。
        :type ImageContent: str
        :param _Width: 水印的宽度。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示水印 Width 为视频宽度的百分比大小，如 10% 表示 Width 为视频宽度的 10%；</li>
<li>当字符串以 px 结尾，表示水印 Width 单位为像素，如 100px 表示 Width 为 100 像素。取值范围为[8, 4096]。</li>
        :type Width: str
        :param _Height: 水印的高度。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示水印 Height 为视频高度的百分比大小，如 10% 表示 Height 为视频高度的 10%；</li>
<li>当字符串以 px 结尾，表示水印 Height 单位为像素，如 100px 表示 Height 为 100 像素。取值范围为0或[8, 4096]。</li>

        :type Height: str
        :param _RepeatType: 水印重复类型。使用场景：水印为动态图像。取值范围：
<li>once：动态水印播放完后，不再出现；</li>
<li>repeat_last_frame：水印播放完后，停留在最后一帧；</li>
<li>repeat：水印循环播放，直到视频结束。</li>
        :type RepeatType: str
        """
        self._ImageContent = None
        self._Width = None
        self._Height = None
        self._RepeatType = None

    @property
    def ImageContent(self):
        return self._ImageContent

    @ImageContent.setter
    def ImageContent(self, ImageContent):
        self._ImageContent = ImageContent

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def RepeatType(self):
        return self._RepeatType

    @RepeatType.setter
    def RepeatType(self, RepeatType):
        self._RepeatType = RepeatType


    def _deserialize(self, params):
        self._ImageContent = params.get("ImageContent")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._RepeatType = params.get("RepeatType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ImageWatermarkTemplate(AbstractModel):
    """图片水印模板

    """

    def __init__(self):
        r"""
        :param _ImageUrl: 水印图片地址。
        :type ImageUrl: str
        :param _Width: 水印的宽度。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示水印 Width 为视频宽度的百分比大小，如 10% 表示 Width 为视频宽度的 10%；</li>
<li>当字符串以 px 结尾，表示水印 Width 单位为像素，如 100px 表示 Width 为 100 像素。</li>
        :type Width: str
        :param _Height: 水印的高度。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示水印 Height 为视频高度的百分比大小，如 10% 表示 Height 为视频高度的 10%；</li>
<li>当字符串以 px 结尾，表示水印 Height 单位为像素，如 100px 表示 Height 为 100 像素；</li>
0px：表示 Height 按照 Width 对视频宽度的比例缩放。
        :type Height: str
        :param _RepeatType: 水印重复类型。使用场景：水印为动态图像。取值范围：
<li>once：动态水印播放完后，不再出现；</li>
<li>repeat_last_frame：水印播放完后，停留在最后一帧；</li>
<li>repeat：水印循环播放，直到视频结束。</li>
        :type RepeatType: str
        """
        self._ImageUrl = None
        self._Width = None
        self._Height = None
        self._RepeatType = None

    @property
    def ImageUrl(self):
        return self._ImageUrl

    @ImageUrl.setter
    def ImageUrl(self, ImageUrl):
        self._ImageUrl = ImageUrl

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def RepeatType(self):
        return self._RepeatType

    @RepeatType.setter
    def RepeatType(self, RepeatType):
        self._RepeatType = RepeatType


    def _deserialize(self, params):
        self._ImageUrl = params.get("ImageUrl")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._RepeatType = params.get("RepeatType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InputAddress(AbstractModel):
    """输入地址信息。

    """

    def __init__(self):
        r"""
        :param _Ip: 输入地址的IP。
        :type Ip: str
        :param _Port: 输入地址的端口。
        :type Port: int
        """
        self._Ip = None
        self._Port = None

    @property
    def Ip(self):
        return self._Ip

    @Ip.setter
    def Ip(self, Ip):
        self._Ip = Ip

    @property
    def Port(self):
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port


    def _deserialize(self, params):
        self._Ip = params.get("Ip")
        self._Port = params.get("Port")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveActivityResItem(AbstractModel):
    """直播编排子任务输出

    """

    def __init__(self):
        r"""
        :param _LiveRecordTask: 直播录制任务输出
注意：此字段可能返回 null，表示取不到有效值。
        :type LiveRecordTask: :class:`tencentcloud.mps.v20190612.models.LiveScheduleLiveRecordTaskResult`
        :param _LiveQualityControlTask: 媒体质检任务输出
注意：此字段可能返回 null，表示取不到有效值。
        :type LiveQualityControlTask: :class:`tencentcloud.mps.v20190612.models.ScheduleQualityControlTaskResult`
        """
        self._LiveRecordTask = None
        self._LiveQualityControlTask = None

    @property
    def LiveRecordTask(self):
        return self._LiveRecordTask

    @LiveRecordTask.setter
    def LiveRecordTask(self, LiveRecordTask):
        self._LiveRecordTask = LiveRecordTask

    @property
    def LiveQualityControlTask(self):
        return self._LiveQualityControlTask

    @LiveQualityControlTask.setter
    def LiveQualityControlTask(self, LiveQualityControlTask):
        self._LiveQualityControlTask = LiveQualityControlTask


    def _deserialize(self, params):
        if params.get("LiveRecordTask") is not None:
            self._LiveRecordTask = LiveScheduleLiveRecordTaskResult()
            self._LiveRecordTask._deserialize(params.get("LiveRecordTask"))
        if params.get("LiveQualityControlTask") is not None:
            self._LiveQualityControlTask = ScheduleQualityControlTaskResult()
            self._LiveQualityControlTask._deserialize(params.get("LiveQualityControlTask"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveActivityResult(AbstractModel):
    """直播编排任务输出

    """

    def __init__(self):
        r"""
        :param _ActivityType: 原子任务类型。
<li>LiveRecord：直播录制。</li>
<li>AiQualityControl：媒体质检。</li>
注意：此字段可能返回 null，表示取不到有效值。
        :type ActivityType: str
        :param _LiveActivityResItem: 原子任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type LiveActivityResItem: :class:`tencentcloud.mps.v20190612.models.LiveActivityResItem`
        """
        self._ActivityType = None
        self._LiveActivityResItem = None

    @property
    def ActivityType(self):
        return self._ActivityType

    @ActivityType.setter
    def ActivityType(self, ActivityType):
        self._ActivityType = ActivityType

    @property
    def LiveActivityResItem(self):
        return self._LiveActivityResItem

    @LiveActivityResItem.setter
    def LiveActivityResItem(self, LiveActivityResItem):
        self._LiveActivityResItem = LiveActivityResItem


    def _deserialize(self, params):
        self._ActivityType = params.get("ActivityType")
        if params.get("LiveActivityResItem") is not None:
            self._LiveActivityResItem = LiveActivityResItem()
            self._LiveActivityResItem._deserialize(params.get("LiveActivityResItem"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveRecordFile(AbstractModel):
    """直播录制输出文件信息

    """

    def __init__(self):
        r"""
        :param _Url: 直播录制文件地址
注意：此字段可能返回 null，表示取不到有效值。
        :type Url: str
        :param _Size: 直播录制文件大小
注意：此字段可能返回 null，表示取不到有效值。
        :type Size: int
        :param _Duration: 直播录制文件时长
注意：此字段可能返回 null，表示取不到有效值。
        :type Duration: int
        :param _StartTime: 直播录制文件开始时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
注意：此字段可能返回 null，表示取不到有效值。
        :type StartTime: str
        :param _EndTime: 直播录制文件结束时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
注意：此字段可能返回 null，表示取不到有效值。
        :type EndTime: str
        """
        self._Url = None
        self._Size = None
        self._Duration = None
        self._StartTime = None
        self._EndTime = None

    @property
    def Url(self):
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def Size(self):
        return self._Size

    @Size.setter
    def Size(self, Size):
        self._Size = Size

    @property
    def Duration(self):
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._Url = params.get("Url")
        self._Size = params.get("Size")
        self._Duration = params.get("Duration")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveRecordResult(AbstractModel):
    """直播录制结果

    """

    def __init__(self):
        r"""
        :param _OutputStorage: 直播录制文件的目标存储。
注意：此字段可能返回 null，表示取不到有效值。
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _FileList: 直播录制文件列表
注意：此字段可能返回 null，表示取不到有效值。
        :type FileList: list of LiveRecordFile
        """
        self._OutputStorage = None
        self._FileList = None

    @property
    def OutputStorage(self):
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage

    @property
    def FileList(self):
        return self._FileList

    @FileList.setter
    def FileList(self, FileList):
        self._FileList = FileList


    def _deserialize(self, params):
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        if params.get("FileList") is not None:
            self._FileList = []
            for item in params.get("FileList"):
                obj = LiveRecordFile()
                obj._deserialize(item)
                self._FileList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveRecordTaskInput(AbstractModel):
    """直播录制任务输入参数类型

    """

    def __init__(self):
        r"""
        :param _Definition: 直播录制模板 ID。
        :type Definition: int
        :param _OutputStorage: 直播录制后文件的目标存储，不填则继承上层的 OutputStorage 值。
注意：此字段可能返回 null，表示取不到有效值。
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _OutputObjectPath: 直播录制后文件的输出路径。
注意：此字段可能返回 null，表示取不到有效值。
        :type OutputObjectPath: str
        """
        self._Definition = None
        self._OutputStorage = None
        self._OutputObjectPath = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def OutputStorage(self):
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage

    @property
    def OutputObjectPath(self):
        return self._OutputObjectPath

    @OutputObjectPath.setter
    def OutputObjectPath(self, OutputObjectPath):
        self._OutputObjectPath = OutputObjectPath


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        self._OutputObjectPath = params.get("OutputObjectPath")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveScheduleLiveRecordTaskResult(AbstractModel):
    """直播编排直播录制任务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrCode: int
        :param _Message: 错误信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type Message: str
        :param _Input: 直播录制任务的输入。
注意：此字段可能返回 null，表示取不到有效值。
        :type Input: :class:`tencentcloud.mps.v20190612.models.LiveRecordTaskInput`
        :param _Output: 直播录制任务的输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.LiveRecordResult`
        :param _BeginProcessTime: 任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
注意：此字段可能返回 null，表示取不到有效值。
        :type BeginProcessTime: str
        :param _FinishTime: 任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
注意：此字段可能返回 null，表示取不到有效值。
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def BeginProcessTime(self):
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = LiveRecordTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = LiveRecordResult()
            self._Output._deserialize(params.get("Output"))
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveScheduleTask(AbstractModel):
    """直播编排任务信息

    """

    def __init__(self):
        r"""
        :param _TaskId: 直播编排任务 ID。
注意：此字段可能返回 null，表示取不到有效值。
        :type TaskId: str
        :param _Status: 任务流状态，取值：
<li>PROCESSING：处理中；</li>
<li>FINISH：已完成。</li>
注意：此字段可能返回 null，表示取不到有效值。
        :type Status: str
        :param _ErrCode: 源异常时返回非0错误码，返回0 时请使用各个具体任务的 ErrCode。
注意：此字段可能返回 null，表示取不到有效值。
        :type ErrCode: int
        :param _Message: 源异常时返回对应异常Message，否则请使用各个具体任务的 Message。
注意：此字段可能返回 null，表示取不到有效值。
        :type Message: str
        :param _Url: 直播流 URL。
注意：此字段可能返回 null，表示取不到有效值。
        :type Url: str
        :param _LiveActivityResultSet: 直播编排任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type LiveActivityResultSet: list of LiveActivityResult
        """
        self._TaskId = None
        self._Status = None
        self._ErrCode = None
        self._Message = None
        self._Url = None
        self._LiveActivityResultSet = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Url(self):
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def LiveActivityResultSet(self):
        return self._LiveActivityResultSet

    @LiveActivityResultSet.setter
    def LiveActivityResultSet(self, LiveActivityResultSet):
        self._LiveActivityResultSet = LiveActivityResultSet


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Status = params.get("Status")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        self._Url = params.get("Url")
        if params.get("LiveActivityResultSet") is not None:
            self._LiveActivityResultSet = []
            for item in params.get("LiveActivityResultSet"):
                obj = LiveActivityResult()
                obj._deserialize(item)
                self._LiveActivityResultSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveStreamAiAnalysisResultInfo(AbstractModel):
    """直播流分析结果

    """

    def __init__(self):
        r"""
        :param _ResultSet: 直播分析子任务结果，暂时只支持直播拆条。
注意：此字段可能返回 null，表示取不到有效值。
        :type ResultSet: list of LiveStreamAiAnalysisResultItem
        """
        self._ResultSet = None

    @property
    def ResultSet(self):
        return self._ResultSet

    @ResultSet.setter
    def ResultSet(self, ResultSet):
        self._ResultSet = ResultSet


    def _deserialize(self, params):
        if params.get("ResultSet") is not None:
            self._ResultSet = []
            for item in params.get("ResultSet"):
                obj = LiveStreamAiAnalysisResultItem()
                obj._deserialize(item)
                self._ResultSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveStreamAiAnalysisResultItem(AbstractModel):
    """直播流 AI 分析结果

    """

    def __init__(self):
        r"""
        :param _Type: 结果的类型，取值范围：
<li>SegmentRecognition：拆条。</li>
        :type Type: str
        :param _SegmentResultSet: 拆条结果，当 Type 为
SegmentRecognition 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type SegmentResultSet: list of SegmentRecognitionItem
        """
        self._Type = None
        self._SegmentResultSet = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def SegmentResultSet(self):
        return self._SegmentResultSet

    @SegmentResultSet.setter
    def SegmentResultSet(self, SegmentResultSet):
        self._SegmentResultSet = SegmentResultSet


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("SegmentResultSet") is not None:
            self._SegmentResultSet = []
            for item in params.get("SegmentResultSet"):
                obj = SegmentRecognitionItem()
                obj._deserialize(item)
                self._SegmentResultSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveStreamAiQualityControlResultInfo(AbstractModel):
    """直播流质检结果

    """

    def __init__(self):
        r"""
        :param _QualityControlResults: 质检结果列表。
注意：此字段可能返回 null，表示取不到有效值。
        :type QualityControlResults: list of QualityControlResult
        :param _DiagnoseResults: 格式诊断结果列表。
注意：此字段可能返回 null，表示取不到有效值。
        :type DiagnoseResults: list of DiagnoseResult
        """
        self._QualityControlResults = None
        self._DiagnoseResults = None

    @property
    def QualityControlResults(self):
        return self._QualityControlResults

    @QualityControlResults.setter
    def QualityControlResults(self, QualityControlResults):
        self._QualityControlResults = QualityControlResults

    @property
    def DiagnoseResults(self):
        return self._DiagnoseResults

    @DiagnoseResults.setter
    def DiagnoseResults(self, DiagnoseResults):
        self._DiagnoseResults = DiagnoseResults


    def _deserialize(self, params):
        if params.get("QualityControlResults") is not None:
            self._QualityControlResults = []
            for item in params.get("QualityControlResults"):
                obj = QualityControlResult()
                obj._deserialize(item)
                self._QualityControlResults.append(obj)
        if params.get("DiagnoseResults") is not None:
            self._DiagnoseResults = []
            for item in params.get("DiagnoseResults"):
                obj = DiagnoseResult()
                obj._deserialize(item)
                self._DiagnoseResults.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveStreamAiRecognitionResultInfo(AbstractModel):
    """直播流 AI 识别结果

    """

    def __init__(self):
        r"""
        :param _ResultSet: 内容识别结果列表。
        :type ResultSet: list of LiveStreamAiRecognitionResultItem
        """
        self._ResultSet = None

    @property
    def ResultSet(self):
        return self._ResultSet

    @ResultSet.setter
    def ResultSet(self, ResultSet):
        self._ResultSet = ResultSet


    def _deserialize(self, params):
        if params.get("ResultSet") is not None:
            self._ResultSet = []
            for item in params.get("ResultSet"):
                obj = LiveStreamAiRecognitionResultItem()
                obj._deserialize(item)
                self._ResultSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveStreamAiRecognitionResultItem(AbstractModel):
    """直播流 AI 识别结果

    """

    def __init__(self):
        r"""
        :param _Type: 结果的类型，取值范围：
<li>FaceRecognition：人脸识别，</li>
<li>AsrWordsRecognition：语音关键词识别，</li>
<li>OcrWordsRecognition：文本关键词识别，</li>
<li>AsrFullTextRecognition：语音全文识别，</li>
<li>OcrFullTextRecognition：文本全文识别。</li>
<li>TransTextRecognition：语音翻译。</li>
<li>ObjectRecognition：目标检测。</li>
<li>TagRecognition：精彩打点。</li>
        :type Type: str
        :param _FaceRecognitionResultSet: 人脸识别结果，当 Type 为
FaceRecognition 时有效。
        :type FaceRecognitionResultSet: list of LiveStreamFaceRecognitionResult
        :param _AsrWordsRecognitionResultSet: 语音关键词识别结果，当 Type 为
AsrWordsRecognition 时有效。
        :type AsrWordsRecognitionResultSet: list of LiveStreamAsrWordsRecognitionResult
        :param _OcrWordsRecognitionResultSet: 文本关键词识别结果，当 Type 为
OcrWordsRecognition 时有效。
        :type OcrWordsRecognitionResultSet: list of LiveStreamOcrWordsRecognitionResult
        :param _AsrFullTextRecognitionResultSet: 语音全文识别结果，当 Type 为
AsrFullTextRecognition 时有效。
        :type AsrFullTextRecognitionResultSet: list of LiveStreamAsrFullTextRecognitionResult
        :param _OcrFullTextRecognitionResultSet: 文本全文识别结果，当 Type 为
OcrFullTextRecognition 时有效。
        :type OcrFullTextRecognitionResultSet: list of LiveStreamOcrFullTextRecognitionResult
        :param _TransTextRecognitionResultSet: 翻译结果，当Type 为 TransTextRecognition 时有效。
        :type TransTextRecognitionResultSet: list of LiveStreamTransTextRecognitionResult
        :param _ObjectRecognitionResultSet: 目标检测结果，当Type为 ObjectRecognition 时有效。
        :type ObjectRecognitionResultSet: list of LiveStreamObjectRecognitionResult
        :param _TagRecognitionResultSet: 打点结果，当Type 为 TagRecognition 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type TagRecognitionResultSet: list of LiveStreamTagRecognitionResult
        """
        self._Type = None
        self._FaceRecognitionResultSet = None
        self._AsrWordsRecognitionResultSet = None
        self._OcrWordsRecognitionResultSet = None
        self._AsrFullTextRecognitionResultSet = None
        self._OcrFullTextRecognitionResultSet = None
        self._TransTextRecognitionResultSet = None
        self._ObjectRecognitionResultSet = None
        self._TagRecognitionResultSet = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def FaceRecognitionResultSet(self):
        return self._FaceRecognitionResultSet

    @FaceRecognitionResultSet.setter
    def FaceRecognitionResultSet(self, FaceRecognitionResultSet):
        self._FaceRecognitionResultSet = FaceRecognitionResultSet

    @property
    def AsrWordsRecognitionResultSet(self):
        return self._AsrWordsRecognitionResultSet

    @AsrWordsRecognitionResultSet.setter
    def AsrWordsRecognitionResultSet(self, AsrWordsRecognitionResultSet):
        self._AsrWordsRecognitionResultSet = AsrWordsRecognitionResultSet

    @property
    def OcrWordsRecognitionResultSet(self):
        return self._OcrWordsRecognitionResultSet

    @OcrWordsRecognitionResultSet.setter
    def OcrWordsRecognitionResultSet(self, OcrWordsRecognitionResultSet):
        self._OcrWordsRecognitionResultSet = OcrWordsRecognitionResultSet

    @property
    def AsrFullTextRecognitionResultSet(self):
        return self._AsrFullTextRecognitionResultSet

    @AsrFullTextRecognitionResultSet.setter
    def AsrFullTextRecognitionResultSet(self, AsrFullTextRecognitionResultSet):
        self._AsrFullTextRecognitionResultSet = AsrFullTextRecognitionResultSet

    @property
    def OcrFullTextRecognitionResultSet(self):
        return self._OcrFullTextRecognitionResultSet

    @OcrFullTextRecognitionResultSet.setter
    def OcrFullTextRecognitionResultSet(self, OcrFullTextRecognitionResultSet):
        self._OcrFullTextRecognitionResultSet = OcrFullTextRecognitionResultSet

    @property
    def TransTextRecognitionResultSet(self):
        return self._TransTextRecognitionResultSet

    @TransTextRecognitionResultSet.setter
    def TransTextRecognitionResultSet(self, TransTextRecognitionResultSet):
        self._TransTextRecognitionResultSet = TransTextRecognitionResultSet

    @property
    def ObjectRecognitionResultSet(self):
        return self._ObjectRecognitionResultSet

    @ObjectRecognitionResultSet.setter
    def ObjectRecognitionResultSet(self, ObjectRecognitionResultSet):
        self._ObjectRecognitionResultSet = ObjectRecognitionResultSet

    @property
    def TagRecognitionResultSet(self):
        return self._TagRecognitionResultSet

    @TagRecognitionResultSet.setter
    def TagRecognitionResultSet(self, TagRecognitionResultSet):
        self._TagRecognitionResultSet = TagRecognitionResultSet


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("FaceRecognitionResultSet") is not None:
            self._FaceRecognitionResultSet = []
            for item in params.get("FaceRecognitionResultSet"):
                obj = LiveStreamFaceRecognitionResult()
                obj._deserialize(item)
                self._FaceRecognitionResultSet.append(obj)
        if params.get("AsrWordsRecognitionResultSet") is not None:
            self._AsrWordsRecognitionResultSet = []
            for item in params.get("AsrWordsRecognitionResultSet"):
                obj = LiveStreamAsrWordsRecognitionResult()
                obj._deserialize(item)
                self._AsrWordsRecognitionResultSet.append(obj)
        if params.get("OcrWordsRecognitionResultSet") is not None:
            self._OcrWordsRecognitionResultSet = []
            for item in params.get("OcrWordsRecognitionResultSet"):
                obj = LiveStreamOcrWordsRecognitionResult()
                obj._deserialize(item)
                self._OcrWordsRecognitionResultSet.append(obj)
        if params.get("AsrFullTextRecognitionResultSet") is not None:
            self._AsrFullTextRecognitionResultSet = []
            for item in params.get("AsrFullTextRecognitionResultSet"):
                obj = LiveStreamAsrFullTextRecognitionResult()
                obj._deserialize(item)
                self._AsrFullTextRecognitionResultSet.append(obj)
        if params.get("OcrFullTextRecognitionResultSet") is not None:
            self._OcrFullTextRecognitionResultSet = []
            for item in params.get("OcrFullTextRecognitionResultSet"):
                obj = LiveStreamOcrFullTextRecognitionResult()
                obj._deserialize(item)
                self._OcrFullTextRecognitionResultSet.append(obj)
        if params.get("TransTextRecognitionResultSet") is not None:
            self._TransTextRecognitionResultSet = []
            for item in params.get("TransTextRecognitionResultSet"):
                obj = LiveStreamTransTextRecognitionResult()
                obj._deserialize(item)
                self._TransTextRecognitionResultSet.append(obj)
        if params.get("ObjectRecognitionResultSet") is not None:
            self._ObjectRecognitionResultSet = []
            for item in params.get("ObjectRecognitionResultSet"):
                obj = LiveStreamObjectRecognitionResult()
                obj._deserialize(item)
                self._ObjectRecognitionResultSet.append(obj)
        if params.get("TagRecognitionResultSet") is not None:
            self._TagRecognitionResultSet = []
            for item in params.get("TagRecognitionResultSet"):
                obj = LiveStreamTagRecognitionResult()
                obj._deserialize(item)
                self._TagRecognitionResultSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveStreamAiReviewImagePoliticalResult(AbstractModel):
    """直播 AI 内容审核图片敏感结果

    """

    def __init__(self):
        r"""
        :param _StartPtsTime: 嫌疑片段起始的 PTS 时间，单位：秒。
        :type StartPtsTime: float
        :param _EndPtsTime: 嫌疑片段结束的 PTS 时间，单位：秒。
        :type EndPtsTime: float
        :param _Confidence: 嫌疑片段敏感分数。
        :type Confidence: float
        :param _Suggestion: 嫌疑片段鉴黄结果建议，取值范围：
<li>pass</li>
<li>review</li>
<li>block</li>
        :type Suggestion: str
        :param _Label: 视频敏感结果标签，取值范围：
<li>politician：敏感人物。</li>
<li>violation_photo：违规图标。</li>
        :type Label: str
        :param _Name: 敏感人物、违规图标名字。
        :type Name: str
        :param _AreaCoordSet: 敏感人物、违规图标出现的区域坐标 (像素级)，[x1, y1, x2, y2]，即左上角坐标、右下角坐标。
        :type AreaCoordSet: list of int
        :param _Url: 嫌疑图片 URL （图片不会永久存储，到达
PicUrlExpireTime 时间点后图片将被删除）。
        :type Url: str
        :param _PicUrlExpireTime: 嫌疑图片 URL 失效时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :type PicUrlExpireTime: str
        """
        self._StartPtsTime = None
        self._EndPtsTime = None
        self._Confidence = None
        self._Suggestion = None
        self._Label = None
        self._Name = None
        self._AreaCoordSet = None
        self._Url = None
        self._PicUrlExpireTime = None

    @property
    def StartPtsTime(self):
        return self._StartPtsTime

    @StartPtsTime.setter
    def StartPtsTime(self, StartPtsTime):
        self._StartPtsTime = StartPtsTime

    @property
    def EndPtsTime(self):
        return self._EndPtsTime

    @EndPtsTime.setter
    def EndPtsTime(self, EndPtsTime):
        self._EndPtsTime = EndPtsTime

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def Label(self):
        return self._Label

    @Label.setter
    def Label(self, Label):
        self._Label = Label

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def AreaCoordSet(self):
        return self._AreaCoordSet

    @AreaCoordSet.setter
    def AreaCoordSet(self, AreaCoordSet):
        self._AreaCoordSet = AreaCoordSet

    @property
    def Url(self):
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def PicUrlExpireTime(self):
        return self._PicUrlExpireTime

    @PicUrlExpireTime.setter
    def PicUrlExpireTime(self, PicUrlExpireTime):
        self._PicUrlExpireTime = PicUrlExpireTime


    def _deserialize(self, params):
        self._StartPtsTime = params.get("StartPtsTime")
        self._EndPtsTime = params.get("EndPtsTime")
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        self._Label = params.get("Label")
        self._Name = params.get("Name")
        self._AreaCoordSet = params.get("AreaCoordSet")
        self._Url = params.get("Url")
        self._PicUrlExpireTime = params.get("PicUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveStreamAiReviewImagePornResult(AbstractModel):
    """直播 AI 内容审核图片鉴黄结果

    """

    def __init__(self):
        r"""
        :param _StartPtsTime: 嫌疑片段起始的 PTS 时间，单位：秒。
        :type StartPtsTime: float
        :param _EndPtsTime: 嫌疑片段结束的 PTS 时间，单位：秒。
        :type EndPtsTime: float
        :param _Confidence: 嫌疑片段涉黄分数。
        :type Confidence: float
        :param _Suggestion: 嫌疑片段鉴黄结果建议，取值范围：
<li>pass</li>
<li>review</li>
<li>block</li>
        :type Suggestion: str
        :param _Label: 视频鉴黄结果标签，取值范围：
<li>porn：色情。</li>
<li>sexy：性感。</li>
<li>vulgar：低俗。</li>
<li>intimacy：亲密行为。</li>
        :type Label: str
        :param _Url: 嫌疑图片 URL （图片不会永久存储，到达
PicUrlExpireTime 时间点后图片将被删除）。
        :type Url: str
        :param _PicUrlExpireTime: 嫌疑图片 URL 失效时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :type PicUrlExpireTime: str
        """
        self._StartPtsTime = None
        self._EndPtsTime = None
        self._Confidence = None
        self._Suggestion = None
        self._Label = None
        self._Url = None
        self._PicUrlExpireTime = None

    @property
    def StartPtsTime(self):
        return self._StartPtsTime

    @StartPtsTime.setter
    def StartPtsTime(self, StartPtsTime):
        self._StartPtsTime = StartPtsTime

    @property
    def EndPtsTime(self):
        return self._EndPtsTime

    @EndPtsTime.setter
    def EndPtsTime(self, EndPtsTime):
        self._EndPtsTime = EndPtsTime

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def Label(self):
        return self._Label

    @Label.setter
    def Label(self, Label):
        self._Label = Label

    @property
    def Url(self):
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def PicUrlExpireTime(self):
        return self._PicUrlExpireTime

    @PicUrlExpireTime.setter
    def PicUrlExpireTime(self, PicUrlExpireTime):
        self._PicUrlExpireTime = PicUrlExpireTime


    def _deserialize(self, params):
        self._StartPtsTime = params.get("StartPtsTime")
        self._EndPtsTime = params.get("EndPtsTime")
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        self._Label = params.get("Label")
        self._Url = params.get("Url")
        self._PicUrlExpireTime = params.get("PicUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveStreamAiReviewImageTerrorismResult(AbstractModel):
    """直播 AI 内容审核图片涉敏结果

    """

    def __init__(self):
        r"""
        :param _StartPtsTime: 嫌疑片段起始的 PTS 时间，单位：秒。
        :type StartPtsTime: float
        :param _EndPtsTime: 嫌疑片段结束的 PTS 时间，单位：秒。
        :type EndPtsTime: float
        :param _Confidence: 嫌疑片段涉敏分数。
        :type Confidence: float
        :param _Suggestion: 嫌疑片段涉敏结果建议，取值范围：
<li>pass</li>
<li>review</li>
<li>block</li>
        :type Suggestion: str
        :param _Label: 视频涉敏结果标签，取值范围：
<li>guns：武器枪支。</li>
<li>crowd：人群聚集。</li>
<li>police：警察部队。</li>
<li>bloody：血腥画面。</li>
<li>banners：涉敏旗帜。</li>
<li>militant：武装分子。</li>
<li>explosion：爆炸火灾。</li>
<li>terrorists：涉敏人物。</li>
        :type Label: str
        :param _Url: 嫌疑图片 URL （图片不会永久存储，到达
PicUrlExpireTime 时间点后图片将被删除）。
        :type Url: str
        :param _PicUrlExpireTime: 嫌疑图片 URL 失效时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :type PicUrlExpireTime: str
        """
        self._StartPtsTime = None
        self._EndPtsTime = None
        self._Confidence = None
        self._Suggestion = None
        self._Label = None
        self._Url = None
        self._PicUrlExpireTime = None

    @property
    def StartPtsTime(self):
        return self._StartPtsTime

    @StartPtsTime.setter
    def StartPtsTime(self, StartPtsTime):
        self._StartPtsTime = StartPtsTime

    @property
    def EndPtsTime(self):
        return self._EndPtsTime

    @EndPtsTime.setter
    def EndPtsTime(self, EndPtsTime):
        self._EndPtsTime = EndPtsTime

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def Label(self):
        return self._Label

    @Label.setter
    def Label(self, Label):
        self._Label = Label

    @property
    def Url(self):
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def PicUrlExpireTime(self):
        return self._PicUrlExpireTime

    @PicUrlExpireTime.setter
    def PicUrlExpireTime(self, PicUrlExpireTime):
        self._PicUrlExpireTime = PicUrlExpireTime


    def _deserialize(self, params):
        self._StartPtsTime = params.get("StartPtsTime")
        self._EndPtsTime = params.get("EndPtsTime")
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        self._Label = params.get("Label")
        self._Url = params.get("Url")
        self._PicUrlExpireTime = params.get("PicUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveStreamAiReviewResultInfo(AbstractModel):
    """直播流 AI 审核结果

    """

    def __init__(self):
        r"""
        :param _ResultSet: 内容审核结果列表。
        :type ResultSet: list of LiveStreamAiReviewResultItem
        """
        self._ResultSet = None

    @property
    def ResultSet(self):
        return self._ResultSet

    @ResultSet.setter
    def ResultSet(self, ResultSet):
        self._ResultSet = ResultSet


    def _deserialize(self, params):
        if params.get("ResultSet") is not None:
            self._ResultSet = []
            for item in params.get("ResultSet"):
                obj = LiveStreamAiReviewResultItem()
                obj._deserialize(item)
                self._ResultSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveStreamAiReviewResultItem(AbstractModel):
    """直播流 AI 审核结果

    """

    def __init__(self):
        r"""
        :param _Type: 审核结果的类型，可以取的值有：
<li>ImagePorn：图片鉴黄</li>
<li>ImageTerrorism：图片涉敏</li>
<li>ImagePolitical：图片涉敏</li>
<li>VoicePorn：声音违规</li>
        :type Type: str
        :param _ImagePornResultSet: 图片鉴黄的结果，当 Type 为 ImagePorn 时有效。
        :type ImagePornResultSet: list of LiveStreamAiReviewImagePornResult
        :param _ImageTerrorismResultSet: 图片涉敏的结果，当 Type 为 ImageTerrorism 时有效。
        :type ImageTerrorismResultSet: list of LiveStreamAiReviewImageTerrorismResult
        :param _ImagePoliticalResultSet: 图片涉敏的结果，当 Type 为 ImagePolitical 时有效。
        :type ImagePoliticalResultSet: list of LiveStreamAiReviewImagePoliticalResult
        :param _VoicePornResultSet: 声音违规的结果，当 Type 为 VoicePorn 时有效。
        :type VoicePornResultSet: list of LiveStreamAiReviewVoicePornResult
        """
        self._Type = None
        self._ImagePornResultSet = None
        self._ImageTerrorismResultSet = None
        self._ImagePoliticalResultSet = None
        self._VoicePornResultSet = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def ImagePornResultSet(self):
        return self._ImagePornResultSet

    @ImagePornResultSet.setter
    def ImagePornResultSet(self, ImagePornResultSet):
        self._ImagePornResultSet = ImagePornResultSet

    @property
    def ImageTerrorismResultSet(self):
        return self._ImageTerrorismResultSet

    @ImageTerrorismResultSet.setter
    def ImageTerrorismResultSet(self, ImageTerrorismResultSet):
        self._ImageTerrorismResultSet = ImageTerrorismResultSet

    @property
    def ImagePoliticalResultSet(self):
        return self._ImagePoliticalResultSet

    @ImagePoliticalResultSet.setter
    def ImagePoliticalResultSet(self, ImagePoliticalResultSet):
        self._ImagePoliticalResultSet = ImagePoliticalResultSet

    @property
    def VoicePornResultSet(self):
        return self._VoicePornResultSet

    @VoicePornResultSet.setter
    def VoicePornResultSet(self, VoicePornResultSet):
        self._VoicePornResultSet = VoicePornResultSet


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("ImagePornResultSet") is not None:
            self._ImagePornResultSet = []
            for item in params.get("ImagePornResultSet"):
                obj = LiveStreamAiReviewImagePornResult()
                obj._deserialize(item)
                self._ImagePornResultSet.append(obj)
        if params.get("ImageTerrorismResultSet") is not None:
            self._ImageTerrorismResultSet = []
            for item in params.get("ImageTerrorismResultSet"):
                obj = LiveStreamAiReviewImageTerrorismResult()
                obj._deserialize(item)
                self._ImageTerrorismResultSet.append(obj)
        if params.get("ImagePoliticalResultSet") is not None:
            self._ImagePoliticalResultSet = []
            for item in params.get("ImagePoliticalResultSet"):
                obj = LiveStreamAiReviewImagePoliticalResult()
                obj._deserialize(item)
                self._ImagePoliticalResultSet.append(obj)
        if params.get("VoicePornResultSet") is not None:
            self._VoicePornResultSet = []
            for item in params.get("VoicePornResultSet"):
                obj = LiveStreamAiReviewVoicePornResult()
                obj._deserialize(item)
                self._VoicePornResultSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveStreamAiReviewVoicePornResult(AbstractModel):
    """直播 AI 内容审核声音鉴黄结果

    """

    def __init__(self):
        r"""
        :param _StartPtsTime: 嫌疑片段起始的 PTS 时间，单位：秒。
        :type StartPtsTime: float
        :param _EndPtsTime: 嫌疑片段结束的 PTS 时间，单位：秒。
        :type EndPtsTime: float
        :param _Confidence: 嫌疑片段涉黄分数。
        :type Confidence: float
        :param _Suggestion: 嫌疑片段鉴黄结果建议，取值范围：
<li>pass</li>
<li>review</li>
<li>block</li>
        :type Suggestion: str
        :param _Label: 视频鉴黄结果标签，取值范围：
<li>sexual_moan：呻吟。</li>
        :type Label: str
        """
        self._StartPtsTime = None
        self._EndPtsTime = None
        self._Confidence = None
        self._Suggestion = None
        self._Label = None

    @property
    def StartPtsTime(self):
        return self._StartPtsTime

    @StartPtsTime.setter
    def StartPtsTime(self, StartPtsTime):
        self._StartPtsTime = StartPtsTime

    @property
    def EndPtsTime(self):
        return self._EndPtsTime

    @EndPtsTime.setter
    def EndPtsTime(self, EndPtsTime):
        self._EndPtsTime = EndPtsTime

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def Label(self):
        return self._Label

    @Label.setter
    def Label(self, Label):
        self._Label = Label


    def _deserialize(self, params):
        self._StartPtsTime = params.get("StartPtsTime")
        self._EndPtsTime = params.get("EndPtsTime")
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        self._Label = params.get("Label")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveStreamAsrFullTextRecognitionResult(AbstractModel):
    """直播识别 Asr 全文识别

    """

    def __init__(self):
        r"""
        :param _Text: 识别文本。
        :type Text: str
        :param _StartPtsTime: 识别片段起始的 PTS 时间，单位：秒。
        :type StartPtsTime: float
        :param _EndPtsTime: 识别片段终止的 PTS 时间，单位：秒。
        :type EndPtsTime: float
        :param _Confidence: 识别片段置信度。取值：0~100。
        :type Confidence: float
        :param _StartTime: 识别开始UTC时间。
注意：此字段可能返回 null，表示取不到有效值。
        :type StartTime: str
        :param _EndTime: 识别结束UTC时间。
注意：此字段可能返回 null，表示取不到有效值。
        :type EndTime: str
        :param _SteadyState: 稳态标记。
注意：此字段可能返回 null，表示取不到有效值。
        :type SteadyState: bool
        """
        self._Text = None
        self._StartPtsTime = None
        self._EndPtsTime = None
        self._Confidence = None
        self._StartTime = None
        self._EndTime = None
        self._SteadyState = None

    @property
    def Text(self):
        return self._Text

    @Text.setter
    def Text(self, Text):
        self._Text = Text

    @property
    def StartPtsTime(self):
        return self._StartPtsTime

    @StartPtsTime.setter
    def StartPtsTime(self, StartPtsTime):
        self._StartPtsTime = StartPtsTime

    @property
    def EndPtsTime(self):
        return self._EndPtsTime

    @EndPtsTime.setter
    def EndPtsTime(self, EndPtsTime):
        self._EndPtsTime = EndPtsTime

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def SteadyState(self):
        return self._SteadyState

    @SteadyState.setter
    def SteadyState(self, SteadyState):
        self._SteadyState = SteadyState


    def _deserialize(self, params):
        self._Text = params.get("Text")
        self._StartPtsTime = params.get("StartPtsTime")
        self._EndPtsTime = params.get("EndPtsTime")
        self._Confidence = params.get("Confidence")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._SteadyState = params.get("SteadyState")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveStreamAsrWordsRecognitionResult(AbstractModel):
    """直播 AI Asr 单词识别结果

    """

    def __init__(self):
        r"""
        :param _Word: 语音关键词。
        :type Word: str
        :param _StartPtsTime: 识别片段起始的 PTS 时间，单位：秒。
        :type StartPtsTime: float
        :param _EndPtsTime: 识别片段终止的 PTS 时间，单位：秒。
        :type EndPtsTime: float
        :param _Confidence: 识别片段置信度。取值：0~100。
        :type Confidence: float
        """
        self._Word = None
        self._StartPtsTime = None
        self._EndPtsTime = None
        self._Confidence = None

    @property
    def Word(self):
        return self._Word

    @Word.setter
    def Word(self, Word):
        self._Word = Word

    @property
    def StartPtsTime(self):
        return self._StartPtsTime

    @StartPtsTime.setter
    def StartPtsTime(self, StartPtsTime):
        self._StartPtsTime = StartPtsTime

    @property
    def EndPtsTime(self):
        return self._EndPtsTime

    @EndPtsTime.setter
    def EndPtsTime(self, EndPtsTime):
        self._EndPtsTime = EndPtsTime

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence


    def _deserialize(self, params):
        self._Word = params.get("Word")
        self._StartPtsTime = params.get("StartPtsTime")
        self._EndPtsTime = params.get("EndPtsTime")
        self._Confidence = params.get("Confidence")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveStreamFaceRecognitionResult(AbstractModel):
    """直播 AI 人脸识别结果

    """

    def __init__(self):
        r"""
        :param _Id: 人物唯一标识 ID。
        :type Id: str
        :param _Name: 人物名称。
        :type Name: str
        :param _Type: 人物库类型，表示识别出的人物来自哪个人物库：
<li>Default：默认人物库；</li><li>UserDefine：用户自定义人物库。</li>
        :type Type: str
        :param _StartPtsTime: 识别片段起始的 PTS 时间，单位：秒。
        :type StartPtsTime: float
        :param _EndPtsTime: 识别片段终止的 PTS 时间，单位：秒。
        :type EndPtsTime: float
        :param _Confidence: 识别片段置信度。取值：0~100。
        :type Confidence: float
        :param _AreaCoordSet: 识别结果的区域坐标。数组包含 4 个元素 [x1,y1,x2,y2]，依次表示区域左上点、右下点的横纵坐标。
        :type AreaCoordSet: list of int
        """
        self._Id = None
        self._Name = None
        self._Type = None
        self._StartPtsTime = None
        self._EndPtsTime = None
        self._Confidence = None
        self._AreaCoordSet = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def StartPtsTime(self):
        return self._StartPtsTime

    @StartPtsTime.setter
    def StartPtsTime(self, StartPtsTime):
        self._StartPtsTime = StartPtsTime

    @property
    def EndPtsTime(self):
        return self._EndPtsTime

    @EndPtsTime.setter
    def EndPtsTime(self, EndPtsTime):
        self._EndPtsTime = EndPtsTime

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def AreaCoordSet(self):
        return self._AreaCoordSet

    @AreaCoordSet.setter
    def AreaCoordSet(self, AreaCoordSet):
        self._AreaCoordSet = AreaCoordSet


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Name = params.get("Name")
        self._Type = params.get("Type")
        self._StartPtsTime = params.get("StartPtsTime")
        self._EndPtsTime = params.get("EndPtsTime")
        self._Confidence = params.get("Confidence")
        self._AreaCoordSet = params.get("AreaCoordSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveStreamObjectRecognitionResult(AbstractModel):
    """直播 AI 物体识别结果

    """

    def __init__(self):
        r"""
        :param _Name: 识别的物体名称。
        :type Name: str
        :param _StartPtsOffset: 识别片段起始的 PTS 时间，单位：秒。
        :type StartPtsOffset: float
        :param _EndPtsOffset: 识别片段终止的 PTS 时间，单位：秒。
        :type EndPtsOffset: float
        :param _Confidence: 识别片段置信度。取值：0~100。
        :type Confidence: float
        :param _AreaCoordSet: 识别结果的区域坐标。数组包含 4 个元素 [x1,y1,x2,y2]，依次表示区域左上点、右下点的横纵坐标。
        :type AreaCoordSet: list of int
        :param _Url: 截图链接。
注意：此字段可能返回 null，表示取不到有效值。
        :type Url: str
        """
        self._Name = None
        self._StartPtsOffset = None
        self._EndPtsOffset = None
        self._Confidence = None
        self._AreaCoordSet = None
        self._Url = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def StartPtsOffset(self):
        return self._StartPtsOffset

    @StartPtsOffset.setter
    def StartPtsOffset(self, StartPtsOffset):
        self._StartPtsOffset = StartPtsOffset

    @property
    def EndPtsOffset(self):
        return self._EndPtsOffset

    @EndPtsOffset.setter
    def EndPtsOffset(self, EndPtsOffset):
        self._EndPtsOffset = EndPtsOffset

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def AreaCoordSet(self):
        return self._AreaCoordSet

    @AreaCoordSet.setter
    def AreaCoordSet(self, AreaCoordSet):
        self._AreaCoordSet = AreaCoordSet

    @property
    def Url(self):
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._StartPtsOffset = params.get("StartPtsOffset")
        self._EndPtsOffset = params.get("EndPtsOffset")
        self._Confidence = params.get("Confidence")
        self._AreaCoordSet = params.get("AreaCoordSet")
        self._Url = params.get("Url")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveStreamOcrFullTextRecognitionResult(AbstractModel):
    """直播识别 Ocr 全文识别

    """

    def __init__(self):
        r"""
        :param _Text: 语音文本。
        :type Text: str
        :param _StartPtsTime: 识别片段起始的 PTS 时间，单位：秒。
        :type StartPtsTime: float
        :param _EndPtsTime: 识别片段终止的 PTS 时间，单位：秒。
        :type EndPtsTime: float
        :param _Confidence: 识别片段置信度。取值：0~100。
        :type Confidence: float
        :param _AreaCoordSet: 识别结果的区域坐标。数组包含 4 个元素 [x1,y1,x2,y2]，依次表示区域左上点、右下点的横纵坐标。
        :type AreaCoordSet: list of int
        """
        self._Text = None
        self._StartPtsTime = None
        self._EndPtsTime = None
        self._Confidence = None
        self._AreaCoordSet = None

    @property
    def Text(self):
        return self._Text

    @Text.setter
    def Text(self, Text):
        self._Text = Text

    @property
    def StartPtsTime(self):
        return self._StartPtsTime

    @StartPtsTime.setter
    def StartPtsTime(self, StartPtsTime):
        self._StartPtsTime = StartPtsTime

    @property
    def EndPtsTime(self):
        return self._EndPtsTime

    @EndPtsTime.setter
    def EndPtsTime(self, EndPtsTime):
        self._EndPtsTime = EndPtsTime

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def AreaCoordSet(self):
        return self._AreaCoordSet

    @AreaCoordSet.setter
    def AreaCoordSet(self, AreaCoordSet):
        self._AreaCoordSet = AreaCoordSet


    def _deserialize(self, params):
        self._Text = params.get("Text")
        self._StartPtsTime = params.get("StartPtsTime")
        self._EndPtsTime = params.get("EndPtsTime")
        self._Confidence = params.get("Confidence")
        self._AreaCoordSet = params.get("AreaCoordSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveStreamOcrWordsRecognitionResult(AbstractModel):
    """直播 AI Ocr 单词识别结果

    """

    def __init__(self):
        r"""
        :param _Word: 文本关键词。
        :type Word: str
        :param _StartPtsTime: 识别片段起始的 PTS 时间，单位：秒。
        :type StartPtsTime: float
        :param _EndPtsTime: 识别片段终止的 PTS 时间，单位：秒。
        :type EndPtsTime: float
        :param _Confidence: 识别片段置信度。取值：0~100。
        :type Confidence: float
        :param _AreaCoords: 识别结果的区域坐标。数组包含 4 个元素 [x1,y1,x2,y2]，依次表示区域左上点、右下点的横纵坐标。
        :type AreaCoords: list of int
        """
        self._Word = None
        self._StartPtsTime = None
        self._EndPtsTime = None
        self._Confidence = None
        self._AreaCoords = None

    @property
    def Word(self):
        return self._Word

    @Word.setter
    def Word(self, Word):
        self._Word = Word

    @property
    def StartPtsTime(self):
        return self._StartPtsTime

    @StartPtsTime.setter
    def StartPtsTime(self, StartPtsTime):
        self._StartPtsTime = StartPtsTime

    @property
    def EndPtsTime(self):
        return self._EndPtsTime

    @EndPtsTime.setter
    def EndPtsTime(self, EndPtsTime):
        self._EndPtsTime = EndPtsTime

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def AreaCoords(self):
        return self._AreaCoords

    @AreaCoords.setter
    def AreaCoords(self, AreaCoords):
        self._AreaCoords = AreaCoords


    def _deserialize(self, params):
        self._Word = params.get("Word")
        self._StartPtsTime = params.get("StartPtsTime")
        self._EndPtsTime = params.get("EndPtsTime")
        self._Confidence = params.get("Confidence")
        self._AreaCoords = params.get("AreaCoords")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveStreamProcessErrorInfo(AbstractModel):
    """直播流处理错误信息

    """

    def __init__(self):
        r"""
        :param _ErrCode: 错误码：
<li>0表示没有错误；</li>
<li>非0表示错误，请参考 Message 错误信息。</li>
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        """
        self._ErrCode = None
        self._Message = None

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message


    def _deserialize(self, params):
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveStreamProcessTask(AbstractModel):
    """直播处理任务信息

    """

    def __init__(self):
        r"""
        :param _TaskId: 媒体处理任务 ID。
        :type TaskId: str
        :param _Status: 任务流状态，取值：
<li>PROCESSING：处理中；</li>
<li>FINISH：已完成。</li>
        :type Status: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Url: 直播流 URL。
        :type Url: str
        """
        self._TaskId = None
        self._Status = None
        self._ErrCode = None
        self._Message = None
        self._Url = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Url(self):
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Status = params.get("Status")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        self._Url = params.get("Url")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveStreamRecordResultInfo(AbstractModel):
    """直播流录制结果

    """

    def __init__(self):
        r"""
        :param _RecordOver: 录制是否结束。
0：录制未结束，返回单个文件结果
1：录制结束，返回所有录制文件结果
注意：此字段可能返回 null，表示取不到有效值。
        :type RecordOver: int
        :param _FileResults: 文件列表
注意：此字段可能返回 null，表示取不到有效值。
        :type FileResults: list of LiveRecordFile
        """
        self._RecordOver = None
        self._FileResults = None

    @property
    def RecordOver(self):
        return self._RecordOver

    @RecordOver.setter
    def RecordOver(self, RecordOver):
        self._RecordOver = RecordOver

    @property
    def FileResults(self):
        return self._FileResults

    @FileResults.setter
    def FileResults(self, FileResults):
        self._FileResults = FileResults


    def _deserialize(self, params):
        self._RecordOver = params.get("RecordOver")
        if params.get("FileResults") is not None:
            self._FileResults = []
            for item in params.get("FileResults"):
                obj = LiveRecordFile()
                obj._deserialize(item)
                self._FileResults.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveStreamTagRecognitionResult(AbstractModel):
    """直播 AI 打点识别结果

    """

    def __init__(self):
        r"""
        :param _Id: 打点事件。
        :type Id: str
        :param _StartPtsTime: 识别片段起始的 PTS 时间，单位：秒。
        :type StartPtsTime: float
        :param _EndPtsTime: 识别片段终止的 PTS 时间，单位：秒。
        :type EndPtsTime: float
        :param _Confidence: 识别片段置信度。取值：0~100。
        :type Confidence: float
        """
        self._Id = None
        self._StartPtsTime = None
        self._EndPtsTime = None
        self._Confidence = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def StartPtsTime(self):
        return self._StartPtsTime

    @StartPtsTime.setter
    def StartPtsTime(self, StartPtsTime):
        self._StartPtsTime = StartPtsTime

    @property
    def EndPtsTime(self):
        return self._EndPtsTime

    @EndPtsTime.setter
    def EndPtsTime(self, EndPtsTime):
        self._EndPtsTime = EndPtsTime

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._StartPtsTime = params.get("StartPtsTime")
        self._EndPtsTime = params.get("EndPtsTime")
        self._Confidence = params.get("Confidence")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveStreamTaskNotifyConfig(AbstractModel):
    """任务处理的事件通知配置。

    """

    def __init__(self):
        r"""
        :param _NotifyType: 通知类型，默认CMQ，指定URL时HTTP回调推送到 NotifyUrl 指定的地址。

<font color="red"> 注：不填或为空时默认 CMQ，如需采用其他类型需填写对应类型值。 </font>
        :type NotifyType: str
        :param _CmqModel: CMQ 的模型，有 Queue 和 Topic 两种，目前仅支持 Queue。
        :type CmqModel: str
        :param _CmqRegion: CMQ 的园区，如 sh，bj 等。
        :type CmqRegion: str
        :param _QueueName: 当模型为 Queue 时有效，表示接收事件通知的 CMQ 的队列名。
        :type QueueName: str
        :param _TopicName: 当模型为 Topic 时有效，表示接收事件通知的 CMQ 的主题名。
        :type TopicName: str
        :param _NotifyUrl: HTTP回调地址，NotifyType为URL时必填。
        :type NotifyUrl: str
        :param _NotifyKey: 用于生成回调签名的 Key。
注意：此字段可能返回 null，表示取不到有效值。
        :type NotifyKey: str
        """
        self._NotifyType = None
        self._CmqModel = None
        self._CmqRegion = None
        self._QueueName = None
        self._TopicName = None
        self._NotifyUrl = None
        self._NotifyKey = None

    @property
    def NotifyType(self):
        return self._NotifyType

    @NotifyType.setter
    def NotifyType(self, NotifyType):
        self._NotifyType = NotifyType

    @property
    def CmqModel(self):
        return self._CmqModel

    @CmqModel.setter
    def CmqModel(self, CmqModel):
        self._CmqModel = CmqModel

    @property
    def CmqRegion(self):
        return self._CmqRegion

    @CmqRegion.setter
    def CmqRegion(self, CmqRegion):
        self._CmqRegion = CmqRegion

    @property
    def QueueName(self):
        return self._QueueName

    @QueueName.setter
    def QueueName(self, QueueName):
        self._QueueName = QueueName

    @property
    def TopicName(self):
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName

    @property
    def NotifyUrl(self):
        return self._NotifyUrl

    @NotifyUrl.setter
    def NotifyUrl(self, NotifyUrl):
        self._NotifyUrl = NotifyUrl

    @property
    def NotifyKey(self):
        return self._NotifyKey

    @NotifyKey.setter
    def NotifyKey(self, NotifyKey):
        self._NotifyKey = NotifyKey


    def _deserialize(self, params):
        self._NotifyType = params.get("NotifyType")
        self._CmqModel = params.get("CmqModel")
        self._CmqRegion = params.get("CmqRegion")
        self._QueueName = params.get("QueueName")
        self._TopicName = params.get("TopicName")
        self._NotifyUrl = params.get("NotifyUrl")
        self._NotifyKey = params.get("NotifyKey")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveStreamTransTextRecognitionResult(AbstractModel):
    """直播实时翻译结果

    """

    def __init__(self):
        r"""
        :param _Text: 识别文本。
        :type Text: str
        :param _StartPtsTime: 翻译片段起始的 PTS 时间，单位：秒。
        :type StartPtsTime: float
        :param _EndPtsTime: 翻译片段终止的 PTS 时间，单位：秒。
        :type EndPtsTime: float
        :param _Confidence: 翻译片段置信度。取值：0~100。
        :type Confidence: float
        :param _Trans: 翻译文本。
        :type Trans: str
        :param _StartTime: 翻译开始UTC时间。
注意：此字段可能返回 null，表示取不到有效值。
        :type StartTime: str
        :param _EndTime: 翻译结束UTC时间。
注意：此字段可能返回 null，表示取不到有效值。
        :type EndTime: str
        :param _SteadyState: 稳态标记。
注意：此字段可能返回 null，表示取不到有效值。
        :type SteadyState: bool
        """
        self._Text = None
        self._StartPtsTime = None
        self._EndPtsTime = None
        self._Confidence = None
        self._Trans = None
        self._StartTime = None
        self._EndTime = None
        self._SteadyState = None

    @property
    def Text(self):
        return self._Text

    @Text.setter
    def Text(self, Text):
        self._Text = Text

    @property
    def StartPtsTime(self):
        return self._StartPtsTime

    @StartPtsTime.setter
    def StartPtsTime(self, StartPtsTime):
        self._StartPtsTime = StartPtsTime

    @property
    def EndPtsTime(self):
        return self._EndPtsTime

    @EndPtsTime.setter
    def EndPtsTime(self, EndPtsTime):
        self._EndPtsTime = EndPtsTime

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Trans(self):
        return self._Trans

    @Trans.setter
    def Trans(self, Trans):
        self._Trans = Trans

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def SteadyState(self):
        return self._SteadyState

    @SteadyState.setter
    def SteadyState(self, SteadyState):
        self._SteadyState = SteadyState


    def _deserialize(self, params):
        self._Text = params.get("Text")
        self._StartPtsTime = params.get("StartPtsTime")
        self._EndPtsTime = params.get("EndPtsTime")
        self._Confidence = params.get("Confidence")
        self._Trans = params.get("Trans")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._SteadyState = params.get("SteadyState")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LowLightEnhanceConfig(AbstractModel):
    """低光照增强配置

    """

    def __init__(self):
        r"""
        :param _Switch: 能力配置开关，可选值：
<li>ON：开启；</li>
<li>OFF：关闭。</li>
默认值：ON。
        :type Switch: str
        :param _Type: 类型，可选值：
<li>normal</li>
默认值：normal。
注意：此字段可能返回 null，表示取不到有效值。
        :type Type: str
        """
        self._Switch = None
        self._Type = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ManageTaskRequest(AbstractModel):
    """ManageTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _OperationType: 操作类型，取值范围：
<ul>
<li>Abort：终止任务。使用说明：
<ul><li>若 [任务类型](/document/product/862/37614#3.-.E8.BE.93.E5.87.BA.E5.8F.82.E6.95.B0) 为直播流处理任务（LiveStreamProcessTask），支持终止 [任务状态](/document/product/862/37614#3.-.E8.BE.93.E5.87.BA.E5.8F.82.E6.95.B0) 为等待中（WAITING）或处理中（PROCESSING）的任务；</li>
<li>否则，对于其他 [任务类型](/document/product/862/37614#3.-.E8.BE.93.E5.87.BA.E5.8F.82.E6.95.B0)，只支持终止 [任务状态](/document/product/862/37614#3.-.E8.BE.93.E5.87.BA.E5.8F.82.E6.95.B0) 为等待中（WAITING）的任务。</li></ul>
</li></ul>
        :type OperationType: str
        :param _TaskId: 视频处理的任务 ID。
        :type TaskId: str
        """
        self._OperationType = None
        self._TaskId = None

    @property
    def OperationType(self):
        return self._OperationType

    @OperationType.setter
    def OperationType(self, OperationType):
        self._OperationType = OperationType

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._OperationType = params.get("OperationType")
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ManageTaskResponse(AbstractModel):
    """ManageTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class MediaAiAnalysisClassificationItem(AbstractModel):
    """智能分类结果

    """

    def __init__(self):
        r"""
        :param _Classification: 智能分类的类别名称。
        :type Classification: str
        :param _Confidence: 智能分类的可信度，取值范围是 0 到 100。
        :type Confidence: float
        """
        self._Classification = None
        self._Confidence = None

    @property
    def Classification(self):
        return self._Classification

    @Classification.setter
    def Classification(self, Classification):
        self._Classification = Classification

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence


    def _deserialize(self, params):
        self._Classification = params.get("Classification")
        self._Confidence = params.get("Confidence")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaAiAnalysisCoverItem(AbstractModel):
    """智能封面信息

    """

    def __init__(self):
        r"""
        :param _CoverPath: 智能封面存储路径。
        :type CoverPath: str
        :param _Confidence: 智能封面的可信度，取值范围是 0 到 100。
        :type Confidence: float
        """
        self._CoverPath = None
        self._Confidence = None

    @property
    def CoverPath(self):
        return self._CoverPath

    @CoverPath.setter
    def CoverPath(self, CoverPath):
        self._CoverPath = CoverPath

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence


    def _deserialize(self, params):
        self._CoverPath = params.get("CoverPath")
        self._Confidence = params.get("Confidence")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaAiAnalysisDescriptionItem(AbstractModel):
    """智能描述信息

    """

    def __init__(self):
        r"""
        :param _Description: 智能描述。
        :type Description: str
        :param _Confidence: 智能描述的可信度，取值范围是 0 到 100。
        :type Confidence: float
        :param _Paragraphs: 分段结果。
注意：此字段可能返回 null，表示取不到有效值。
        :type Paragraphs: list of AiParagraphInfo
        """
        self._Description = None
        self._Confidence = None
        self._Paragraphs = None

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Paragraphs(self):
        return self._Paragraphs

    @Paragraphs.setter
    def Paragraphs(self, Paragraphs):
        self._Paragraphs = Paragraphs


    def _deserialize(self, params):
        self._Description = params.get("Description")
        self._Confidence = params.get("Confidence")
        if params.get("Paragraphs") is not None:
            self._Paragraphs = []
            for item in params.get("Paragraphs"):
                obj = AiParagraphInfo()
                obj._deserialize(item)
                self._Paragraphs.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaAiAnalysisFrameTagItem(AbstractModel):
    """智能按帧标签结果信息

    """

    def __init__(self):
        r"""
        :param _Tag: 按帧标签名称。
        :type Tag: str
        :param _CategorySet: 按帧标签名称的分类列表，CategorySet.N 表示第 N+1级分类。
比如 Tag 为“塔楼”时，CategorySet 包含两个元素：CategorySet.0 为“场景”，CategorySet.1为 “建筑”，表示按帧标签为“塔楼”，且第1级分类是“场景”，第2级分类是“建筑”。
        :type CategorySet: list of str
        :param _Confidence: 按帧标签的可信度，取值范围是 0 到 100。
        :type Confidence: float
        """
        self._Tag = None
        self._CategorySet = None
        self._Confidence = None

    @property
    def Tag(self):
        return self._Tag

    @Tag.setter
    def Tag(self, Tag):
        self._Tag = Tag

    @property
    def CategorySet(self):
        return self._CategorySet

    @CategorySet.setter
    def CategorySet(self, CategorySet):
        self._CategorySet = CategorySet

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence


    def _deserialize(self, params):
        self._Tag = params.get("Tag")
        self._CategorySet = params.get("CategorySet")
        self._Confidence = params.get("Confidence")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaAiAnalysisFrameTagSegmentItem(AbstractModel):
    """按帧标签片段列表

    """

    def __init__(self):
        r"""
        :param _StartTimeOffset: 按帧标签起始的偏移时间。
        :type StartTimeOffset: float
        :param _EndTimeOffset: 按帧标签结束的偏移时间。
        :type EndTimeOffset: float
        :param _TagSet: 时间片段内的标签列表。
        :type TagSet: list of MediaAiAnalysisFrameTagItem
        """
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._TagSet = None

    @property
    def StartTimeOffset(self):
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def TagSet(self):
        return self._TagSet

    @TagSet.setter
    def TagSet(self, TagSet):
        self._TagSet = TagSet


    def _deserialize(self, params):
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        if params.get("TagSet") is not None:
            self._TagSet = []
            for item in params.get("TagSet"):
                obj = MediaAiAnalysisFrameTagItem()
                obj._deserialize(item)
                self._TagSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaAiAnalysisHighlightItem(AbstractModel):
    """智能精彩片段信息

    """

    def __init__(self):
        r"""
        :param _HighlightPath: 智能精彩集锦地址。
        :type HighlightPath: str
        :param _CovImgPath: 智能精彩集锦封面地址。
        :type CovImgPath: str
        :param _Confidence: 智能精彩集锦的可信度，取值范围是 0 到 100。
        :type Confidence: float
        :param _Duration: 智能精彩集锦持续时间。
        :type Duration: float
        :param _SegmentSet: 智能精彩集锦子片段列表。
        :type SegmentSet: list of HighlightSegmentItem
        """
        self._HighlightPath = None
        self._CovImgPath = None
        self._Confidence = None
        self._Duration = None
        self._SegmentSet = None

    @property
    def HighlightPath(self):
        return self._HighlightPath

    @HighlightPath.setter
    def HighlightPath(self, HighlightPath):
        self._HighlightPath = HighlightPath

    @property
    def CovImgPath(self):
        return self._CovImgPath

    @CovImgPath.setter
    def CovImgPath(self, CovImgPath):
        self._CovImgPath = CovImgPath

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Duration(self):
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._HighlightPath = params.get("HighlightPath")
        self._CovImgPath = params.get("CovImgPath")
        self._Confidence = params.get("Confidence")
        self._Duration = params.get("Duration")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = HighlightSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaAiAnalysisTagItem(AbstractModel):
    """智能标签结果信息

    """

    def __init__(self):
        r"""
        :param _Tag: 标签名称。
        :type Tag: str
        :param _Confidence: 标签的可信度，取值范围是 0 到 100。
        :type Confidence: float
        """
        self._Tag = None
        self._Confidence = None

    @property
    def Tag(self):
        return self._Tag

    @Tag.setter
    def Tag(self, Tag):
        self._Tag = Tag

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence


    def _deserialize(self, params):
        self._Tag = params.get("Tag")
        self._Confidence = params.get("Confidence")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaAnimatedGraphicsItem(AbstractModel):
    """视频转动图结果信息

    """

    def __init__(self):
        r"""
        :param _Storage: 转动图文件的存储位置。
        :type Storage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _Path: 转动图的文件路径。
        :type Path: str
        :param _Definition: 转动图模板 ID，参见[转动图参数模板](https://cloud.tencent.com/document/product/862/37042#.E9.A2.84.E7.BD.AE.E8.BD.AC.E5.8A.A8.E5.9B.BE.E6.A8.A1.E6.9D.BF)。
        :type Definition: int
        :param _Container: 动图格式，如 gif。
        :type Container: str
        :param _Height: 动图的高度，单位：px。
        :type Height: int
        :param _Width: 动图的宽度，单位：px。
        :type Width: int
        :param _Bitrate: 动图码率，单位：bps。
        :type Bitrate: int
        :param _Size: 动图大小，单位：字节。
        :type Size: int
        :param _Md5: 动图的md5值。
        :type Md5: str
        :param _StartTimeOffset: 动图在视频中的起始时间偏移，单位：秒。
        :type StartTimeOffset: float
        :param _EndTimeOffset: 动图在视频中的结束时间偏移，单位：秒。
        :type EndTimeOffset: float
        """
        self._Storage = None
        self._Path = None
        self._Definition = None
        self._Container = None
        self._Height = None
        self._Width = None
        self._Bitrate = None
        self._Size = None
        self._Md5 = None
        self._StartTimeOffset = None
        self._EndTimeOffset = None

    @property
    def Storage(self):
        return self._Storage

    @Storage.setter
    def Storage(self, Storage):
        self._Storage = Storage

    @property
    def Path(self):
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Container(self):
        return self._Container

    @Container.setter
    def Container(self, Container):
        self._Container = Container

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Bitrate(self):
        return self._Bitrate

    @Bitrate.setter
    def Bitrate(self, Bitrate):
        self._Bitrate = Bitrate

    @property
    def Size(self):
        return self._Size

    @Size.setter
    def Size(self, Size):
        self._Size = Size

    @property
    def Md5(self):
        return self._Md5

    @Md5.setter
    def Md5(self, Md5):
        self._Md5 = Md5

    @property
    def StartTimeOffset(self):
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset


    def _deserialize(self, params):
        if params.get("Storage") is not None:
            self._Storage = TaskOutputStorage()
            self._Storage._deserialize(params.get("Storage"))
        self._Path = params.get("Path")
        self._Definition = params.get("Definition")
        self._Container = params.get("Container")
        self._Height = params.get("Height")
        self._Width = params.get("Width")
        self._Bitrate = params.get("Bitrate")
        self._Size = params.get("Size")
        self._Md5 = params.get("Md5")
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaAudioStreamItem(AbstractModel):
    """点播文件音频流信息

    """

    def __init__(self):
        r"""
        :param _Bitrate: 音频流的码率，单位：bps。
        :type Bitrate: int
        :param _SamplingRate: 音频流的采样率，单位：hz。
        :type SamplingRate: int
        :param _Codec: 音频流的编码格式，例如 aac。
        :type Codec: str
        :param _Channel: 音频声道数，例如 2。
注意：此字段可能返回 null，表示取不到有效值。
        :type Channel: int
        :param _Codecs: 音频Codecs。
注意：此字段可能返回 null，表示取不到有效值。
        :type Codecs: str
        :param _Loudness: 音频响度。
注意：此字段可能返回 null，表示取不到有效值。
        :type Loudness: float
        """
        self._Bitrate = None
        self._SamplingRate = None
        self._Codec = None
        self._Channel = None
        self._Codecs = None
        self._Loudness = None

    @property
    def Bitrate(self):
        return self._Bitrate

    @Bitrate.setter
    def Bitrate(self, Bitrate):
        self._Bitrate = Bitrate

    @property
    def SamplingRate(self):
        return self._SamplingRate

    @SamplingRate.setter
    def SamplingRate(self, SamplingRate):
        self._SamplingRate = SamplingRate

    @property
    def Codec(self):
        return self._Codec

    @Codec.setter
    def Codec(self, Codec):
        self._Codec = Codec

    @property
    def Channel(self):
        return self._Channel

    @Channel.setter
    def Channel(self, Channel):
        self._Channel = Channel

    @property
    def Codecs(self):
        return self._Codecs

    @Codecs.setter
    def Codecs(self, Codecs):
        self._Codecs = Codecs

    @property
    def Loudness(self):
        return self._Loudness

    @Loudness.setter
    def Loudness(self, Loudness):
        self._Loudness = Loudness


    def _deserialize(self, params):
        self._Bitrate = params.get("Bitrate")
        self._SamplingRate = params.get("SamplingRate")
        self._Codec = params.get("Codec")
        self._Channel = params.get("Channel")
        self._Codecs = params.get("Codecs")
        self._Loudness = params.get("Loudness")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaContentReviewAsrTextSegmentItem(AbstractModel):
    """内容审核 Asr 文字审核嫌疑片段

    """

    def __init__(self):
        r"""
        :param _StartTimeOffset: 嫌疑片段起始的偏移时间，单位：秒。
        :type StartTimeOffset: float
        :param _EndTimeOffset: 嫌疑片段结束的偏移时间，单位：秒。
        :type EndTimeOffset: float
        :param _Confidence: 嫌疑片段置信度。
        :type Confidence: float
        :param _Suggestion: 嫌疑片段审核结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :type Suggestion: str
        :param _KeywordSet: 嫌疑关键词列表。
        :type KeywordSet: list of str
        """
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Confidence = None
        self._Suggestion = None
        self._KeywordSet = None

    @property
    def StartTimeOffset(self):
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def KeywordSet(self):
        return self._KeywordSet

    @KeywordSet.setter
    def KeywordSet(self, KeywordSet):
        self._KeywordSet = KeywordSet


    def _deserialize(self, params):
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        self._KeywordSet = params.get("KeywordSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaContentReviewOcrTextSegmentItem(AbstractModel):
    """内容审核 Ocr 文字审核嫌疑片段

    """

    def __init__(self):
        r"""
        :param _StartTimeOffset: 嫌疑片段起始的偏移时间，单位：秒。
        :type StartTimeOffset: float
        :param _EndTimeOffset: 嫌疑片段结束的偏移时间，单位：秒。
        :type EndTimeOffset: float
        :param _Confidence: 嫌疑片段置信度。
        :type Confidence: float
        :param _Suggestion: 嫌疑片段审核结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :type Suggestion: str
        :param _KeywordSet: 嫌疑关键词列表。
        :type KeywordSet: list of str
        :param _AreaCoordSet: 嫌疑文字出现的区域坐标 (像素级)，[x1, y1, x2, y2]，即左上角坐标、右下角坐标。
        :type AreaCoordSet: list of int
        :param _Url: 嫌疑图片 URL （图片不会永久存储，到达
PicUrlExpireTime 时间点后图片将被删除）。
        :type Url: str
        :param _PicUrlExpireTime: 嫌疑图片 URL 失效时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :type PicUrlExpireTime: str
        """
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Confidence = None
        self._Suggestion = None
        self._KeywordSet = None
        self._AreaCoordSet = None
        self._Url = None
        self._PicUrlExpireTime = None

    @property
    def StartTimeOffset(self):
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def KeywordSet(self):
        return self._KeywordSet

    @KeywordSet.setter
    def KeywordSet(self, KeywordSet):
        self._KeywordSet = KeywordSet

    @property
    def AreaCoordSet(self):
        return self._AreaCoordSet

    @AreaCoordSet.setter
    def AreaCoordSet(self, AreaCoordSet):
        self._AreaCoordSet = AreaCoordSet

    @property
    def Url(self):
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def PicUrlExpireTime(self):
        return self._PicUrlExpireTime

    @PicUrlExpireTime.setter
    def PicUrlExpireTime(self, PicUrlExpireTime):
        self._PicUrlExpireTime = PicUrlExpireTime


    def _deserialize(self, params):
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        self._KeywordSet = params.get("KeywordSet")
        self._AreaCoordSet = params.get("AreaCoordSet")
        self._Url = params.get("Url")
        self._PicUrlExpireTime = params.get("PicUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaContentReviewPoliticalSegmentItem(AbstractModel):
    """内容审核涉敏嫌疑片段

    """

    def __init__(self):
        r"""
        :param _StartTimeOffset: 嫌疑片段起始的偏移时间，单位：秒。
        :type StartTimeOffset: float
        :param _EndTimeOffset: 嫌疑片段结束的偏移时间，单位：秒。
        :type EndTimeOffset: float
        :param _Confidence: 嫌疑片段涉敏分数。
        :type Confidence: float
        :param _Suggestion: 嫌疑片段涉敏结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :type Suggestion: str
        :param _Name: 涉敏人物、违规图标名字。
        :type Name: str
        :param _Label: 嫌疑片段涉敏结果标签。内容审核模板[画面涉敏任务控制参数](https://cloud.tencent.com/document/api/862/37615#PoliticalImgReviewTemplateInfo)里 LabelSet 参数与此参数取值范围的对应关系：
violation_photo：
<li>violation_photo：违规图标。</li>
politician：
<li>nation_politician：国家领导人；</li>
<li>province_politician: 省部级领导人；</li>
<li>bureau_politician：厅局级领导人；</li>
<li>county_politician：县处级领导人；</li>
<li>rural_politician：乡科级领导人；</li>
<li>sensitive_politician：涉敏人物；</li>
<li>foreign_politician：国外领导人。</li>
entertainment：
<li>sensitive_entertainment：敏感娱乐人物。</li>
sport：
<li>sensitive_sport：敏感体育人物。</li>
entrepreneur：
<li>sensitive_entrepreneur：敏感商业人物。</li>
scholar：
<li>sensitive_scholar：敏感教育学者。</li>
celebrity：
<li>sensitive_celebrity：敏感知名人物；</li>
<li>historical_celebrity：历史知名人物。</li>
military：
<li>sensitive_military：敏感军事人物。</li>
        :type Label: str
        :param _Url: 嫌疑图片 URL （图片不会永久存储，到达
 PicUrlExpireTime 时间点后图片将被删除）。
        :type Url: str
        :param _AreaCoordSet: 涉敏人物、违规图标出现的区域坐标 (像素级)，[x1, y1, x2, y2]，即左上角坐标、右下角坐标。
        :type AreaCoordSet: list of int
        :param _PicUrlExpireTime: 嫌疑图片 URL 失效时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :type PicUrlExpireTime: str
        """
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Confidence = None
        self._Suggestion = None
        self._Name = None
        self._Label = None
        self._Url = None
        self._AreaCoordSet = None
        self._PicUrlExpireTime = None

    @property
    def StartTimeOffset(self):
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Label(self):
        return self._Label

    @Label.setter
    def Label(self, Label):
        self._Label = Label

    @property
    def Url(self):
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def AreaCoordSet(self):
        return self._AreaCoordSet

    @AreaCoordSet.setter
    def AreaCoordSet(self, AreaCoordSet):
        self._AreaCoordSet = AreaCoordSet

    @property
    def PicUrlExpireTime(self):
        return self._PicUrlExpireTime

    @PicUrlExpireTime.setter
    def PicUrlExpireTime(self, PicUrlExpireTime):
        self._PicUrlExpireTime = PicUrlExpireTime


    def _deserialize(self, params):
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        self._Name = params.get("Name")
        self._Label = params.get("Label")
        self._Url = params.get("Url")
        self._AreaCoordSet = params.get("AreaCoordSet")
        self._PicUrlExpireTime = params.get("PicUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaContentReviewSegmentItem(AbstractModel):
    """内容审核涉黄/涉敏嫌疑片段

    """

    def __init__(self):
        r"""
        :param _StartTimeOffset: 嫌疑片段起始的偏移时间，单位：秒。
        :type StartTimeOffset: float
        :param _EndTimeOffset: 嫌疑片段结束的偏移时间，单位：秒。
        :type EndTimeOffset: float
        :param _Confidence: 嫌疑片段涉黄分数。
        :type Confidence: float
        :param _Label: 嫌疑片段鉴黄结果标签。
        :type Label: str
        :param _Suggestion: 嫌疑片段鉴黄结果建议，取值范围：
<li>pass。</li>
<li>review。</li>
<li>block。</li>
        :type Suggestion: str
        :param _Url: 嫌疑图片 URL （图片不会永久存储，到达
 PicUrlExpireTime 时间点后图片将被删除）。
        :type Url: str
        :param _PicUrlExpireTime: 嫌疑图片 URL 失效时间，使用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
        :type PicUrlExpireTime: str
        """
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Confidence = None
        self._Label = None
        self._Suggestion = None
        self._Url = None
        self._PicUrlExpireTime = None

    @property
    def StartTimeOffset(self):
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Label(self):
        return self._Label

    @Label.setter
    def Label(self, Label):
        self._Label = Label

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def Url(self):
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def PicUrlExpireTime(self):
        return self._PicUrlExpireTime

    @PicUrlExpireTime.setter
    def PicUrlExpireTime(self, PicUrlExpireTime):
        self._PicUrlExpireTime = PicUrlExpireTime


    def _deserialize(self, params):
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Confidence = params.get("Confidence")
        self._Label = params.get("Label")
        self._Suggestion = params.get("Suggestion")
        self._Url = params.get("Url")
        self._PicUrlExpireTime = params.get("PicUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaImageSpriteItem(AbstractModel):
    """雪碧图信息

    """

    def __init__(self):
        r"""
        :param _Definition: 雪碧图规格，参见[雪碧图参数模板](https://cloud.tencent.com/document/product/266/33480#.E9.9B.AA.E7.A2.A7.E5.9B.BE.E6.A8.A1.E6.9D.BF)。
        :type Definition: int
        :param _Height: 雪碧图小图的高度。
        :type Height: int
        :param _Width: 雪碧图小图的宽度。
        :type Width: int
        :param _TotalCount: 每一张雪碧图大图里小图的数量。
        :type TotalCount: int
        :param _ImagePathSet: 每一张雪碧图大图的路径。
        :type ImagePathSet: list of str
        :param _WebVttPath: 雪碧图子图位置与时间关系的 WebVtt 文件路径。WebVtt 文件表明了各个雪碧图小图对应的时间点，以及在雪碧大图里的坐标位置，一般被播放器用于实现预览。
        :type WebVttPath: str
        :param _Storage: 雪碧图文件的存储位置。
        :type Storage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        self._Definition = None
        self._Height = None
        self._Width = None
        self._TotalCount = None
        self._ImagePathSet = None
        self._WebVttPath = None
        self._Storage = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ImagePathSet(self):
        return self._ImagePathSet

    @ImagePathSet.setter
    def ImagePathSet(self, ImagePathSet):
        self._ImagePathSet = ImagePathSet

    @property
    def WebVttPath(self):
        return self._WebVttPath

    @WebVttPath.setter
    def WebVttPath(self, WebVttPath):
        self._WebVttPath = WebVttPath

    @property
    def Storage(self):
        return self._Storage

    @Storage.setter
    def Storage(self, Storage):
        self._Storage = Storage


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Height = params.get("Height")
        self._Width = params.get("Width")
        self._TotalCount = params.get("TotalCount")
        self._ImagePathSet = params.get("ImagePathSet")
        self._WebVttPath = params.get("WebVttPath")
        if params.get("Storage") is not None:
            self._Storage = TaskOutputStorage()
            self._Storage._deserialize(params.get("Storage"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaInputInfo(AbstractModel):
    """媒体处理的输入对象信息。

    """

    def __init__(self):
        r"""
        :param _Type: 输入来源对象的类型，支持：
<li> COS：COS源</li>
<li> URL：URL源</li>
<li> AWS-S3：AWS 源，目前只支持转码任务 </li>
        :type Type: str
        :param _CosInputInfo: 当 Type 为 COS 时有效，则该项为必填，表示媒体处理 COS 对象信息。
        :type CosInputInfo: :class:`tencentcloud.mps.v20190612.models.CosInputInfo`
        :param _UrlInputInfo: 当 Type 为 URL 时有效，则该项为必填，表示媒体处理 URL 对象信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type UrlInputInfo: :class:`tencentcloud.mps.v20190612.models.UrlInputInfo`
        :param _S3InputInfo: 当 Type 为 AWS-S3 时有效，则该项为必填，表示媒体处理 AWS S3 对象信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type S3InputInfo: :class:`tencentcloud.mps.v20190612.models.S3InputInfo`
        """
        self._Type = None
        self._CosInputInfo = None
        self._UrlInputInfo = None
        self._S3InputInfo = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def CosInputInfo(self):
        return self._CosInputInfo

    @CosInputInfo.setter
    def CosInputInfo(self, CosInputInfo):
        self._CosInputInfo = CosInputInfo

    @property
    def UrlInputInfo(self):
        return self._UrlInputInfo

    @UrlInputInfo.setter
    def UrlInputInfo(self, UrlInputInfo):
        self._UrlInputInfo = UrlInputInfo

    @property
    def S3InputInfo(self):
        return self._S3InputInfo

    @S3InputInfo.setter
    def S3InputInfo(self, S3InputInfo):
        self._S3InputInfo = S3InputInfo


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("CosInputInfo") is not None:
            self._CosInputInfo = CosInputInfo()
            self._CosInputInfo._deserialize(params.get("CosInputInfo"))
        if params.get("UrlInputInfo") is not None:
            self._UrlInputInfo = UrlInputInfo()
            self._UrlInputInfo._deserialize(params.get("UrlInputInfo"))
        if params.get("S3InputInfo") is not None:
            self._S3InputInfo = S3InputInfo()
            self._S3InputInfo._deserialize(params.get("S3InputInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaMetaData(AbstractModel):
    """点播媒体文件元信息

    """

    def __init__(self):
        r"""
        :param _Size: 上传的媒体文件大小（视频为 HLS 时，大小是 m3u8 和 ts 文件大小的总和），单位：字节。
        :type Size: int
        :param _Container: 容器类型，例如 m4a，mp4 等。
        :type Container: str
        :param _Bitrate: 视频流码率平均值与音频流码率平均值之和，单位：bps。
        :type Bitrate: int
        :param _Height: 视频流高度的最大值，单位：px。
        :type Height: int
        :param _Width: 视频流宽度的最大值，单位：px。
        :type Width: int
        :param _Duration: 视频时长，单位：秒。
        :type Duration: float
        :param _Rotate: 视频拍摄时的选择角度，单位：度。
        :type Rotate: int
        :param _VideoStreamSet: 视频流信息。
        :type VideoStreamSet: list of MediaVideoStreamItem
        :param _AudioStreamSet: 音频流信息。
        :type AudioStreamSet: list of MediaAudioStreamItem
        :param _VideoDuration: 视频时长，单位：秒。
        :type VideoDuration: float
        :param _AudioDuration: 音频时长，单位：秒。
        :type AudioDuration: float
        """
        self._Size = None
        self._Container = None
        self._Bitrate = None
        self._Height = None
        self._Width = None
        self._Duration = None
        self._Rotate = None
        self._VideoStreamSet = None
        self._AudioStreamSet = None
        self._VideoDuration = None
        self._AudioDuration = None

    @property
    def Size(self):
        return self._Size

    @Size.setter
    def Size(self, Size):
        self._Size = Size

    @property
    def Container(self):
        return self._Container

    @Container.setter
    def Container(self, Container):
        self._Container = Container

    @property
    def Bitrate(self):
        return self._Bitrate

    @Bitrate.setter
    def Bitrate(self, Bitrate):
        self._Bitrate = Bitrate

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Duration(self):
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration

    @property
    def Rotate(self):
        return self._Rotate

    @Rotate.setter
    def Rotate(self, Rotate):
        self._Rotate = Rotate

    @property
    def VideoStreamSet(self):
        return self._VideoStreamSet

    @VideoStreamSet.setter
    def VideoStreamSet(self, VideoStreamSet):
        self._VideoStreamSet = VideoStreamSet

    @property
    def AudioStreamSet(self):
        return self._AudioStreamSet

    @AudioStreamSet.setter
    def AudioStreamSet(self, AudioStreamSet):
        self._AudioStreamSet = AudioStreamSet

    @property
    def VideoDuration(self):
        return self._VideoDuration

    @VideoDuration.setter
    def VideoDuration(self, VideoDuration):
        self._VideoDuration = VideoDuration

    @property
    def AudioDuration(self):
        return self._AudioDuration

    @AudioDuration.setter
    def AudioDuration(self, AudioDuration):
        self._AudioDuration = AudioDuration


    def _deserialize(self, params):
        self._Size = params.get("Size")
        self._Container = params.get("Container")
        self._Bitrate = params.get("Bitrate")
        self._Height = params.get("Height")
        self._Width = params.get("Width")
        self._Duration = params.get("Duration")
        self._Rotate = params.get("Rotate")
        if params.get("VideoStreamSet") is not None:
            self._VideoStreamSet = []
            for item in params.get("VideoStreamSet"):
                obj = MediaVideoStreamItem()
                obj._deserialize(item)
                self._VideoStreamSet.append(obj)
        if params.get("AudioStreamSet") is not None:
            self._AudioStreamSet = []
            for item in params.get("AudioStreamSet"):
                obj = MediaAudioStreamItem()
                obj._deserialize(item)
                self._AudioStreamSet.append(obj)
        self._VideoDuration = params.get("VideoDuration")
        self._AudioDuration = params.get("AudioDuration")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaProcessTaskAdaptiveDynamicStreamingResult(AbstractModel):
    """对视频转自适应码流任务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 对视频转自适应码流任务的输入。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AdaptiveDynamicStreamingTaskInput`
        :param _Output: 对视频转自适应码流任务的输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.AdaptiveDynamicStreamingInfoItem`
        :param _BeginProcessTime: 任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
注意：此字段可能返回 null，表示取不到有效值。
        :type BeginProcessTime: str
        :param _FinishTime: 任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
注意：此字段可能返回 null，表示取不到有效值。
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def BeginProcessTime(self):
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AdaptiveDynamicStreamingTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AdaptiveDynamicStreamingInfoItem()
            self._Output._deserialize(params.get("Output"))
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaProcessTaskAnimatedGraphicResult(AbstractModel):
    """转动图任务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 转动图任务的输入。
        :type Input: :class:`tencentcloud.mps.v20190612.models.AnimatedGraphicTaskInput`
        :param _Output: 转动图任务的输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.MediaAnimatedGraphicsItem`
        :param _BeginProcessTime: 任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
注意：此字段可能返回 null，表示取不到有效值。
        :type BeginProcessTime: str
        :param _FinishTime: 任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
注意：此字段可能返回 null，表示取不到有效值。
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def BeginProcessTime(self):
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AnimatedGraphicTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = MediaAnimatedGraphicsItem()
            self._Output._deserialize(params.get("Output"))
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaProcessTaskImageSpriteResult(AbstractModel):
    """对视频截雪碧图任务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 对视频截雪碧图任务的输入。
        :type Input: :class:`tencentcloud.mps.v20190612.models.ImageSpriteTaskInput`
        :param _Output: 对视频截雪碧图任务的输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.MediaImageSpriteItem`
        :param _BeginProcessTime: 任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
注意：此字段可能返回 null，表示取不到有效值。
        :type BeginProcessTime: str
        :param _FinishTime: 任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
注意：此字段可能返回 null，表示取不到有效值。
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def BeginProcessTime(self):
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = ImageSpriteTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = MediaImageSpriteItem()
            self._Output._deserialize(params.get("Output"))
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaProcessTaskInput(AbstractModel):
    """媒体处理任务类型

    """

    def __init__(self):
        r"""
        :param _TranscodeTaskSet: 视频转码任务列表。
        :type TranscodeTaskSet: list of TranscodeTaskInput
        :param _AnimatedGraphicTaskSet: 视频转动图任务列表。
        :type AnimatedGraphicTaskSet: list of AnimatedGraphicTaskInput
        :param _SnapshotByTimeOffsetTaskSet: 对视频按时间点截图任务列表。
        :type SnapshotByTimeOffsetTaskSet: list of SnapshotByTimeOffsetTaskInput
        :param _SampleSnapshotTaskSet: 对视频采样截图任务列表。
        :type SampleSnapshotTaskSet: list of SampleSnapshotTaskInput
        :param _ImageSpriteTaskSet: 对视频截雪碧图任务列表。
        :type ImageSpriteTaskSet: list of ImageSpriteTaskInput
        :param _AdaptiveDynamicStreamingTaskSet: 转自适应码流任务列表。
        :type AdaptiveDynamicStreamingTaskSet: list of AdaptiveDynamicStreamingTaskInput
        """
        self._TranscodeTaskSet = None
        self._AnimatedGraphicTaskSet = None
        self._SnapshotByTimeOffsetTaskSet = None
        self._SampleSnapshotTaskSet = None
        self._ImageSpriteTaskSet = None
        self._AdaptiveDynamicStreamingTaskSet = None

    @property
    def TranscodeTaskSet(self):
        return self._TranscodeTaskSet

    @TranscodeTaskSet.setter
    def TranscodeTaskSet(self, TranscodeTaskSet):
        self._TranscodeTaskSet = TranscodeTaskSet

    @property
    def AnimatedGraphicTaskSet(self):
        return self._AnimatedGraphicTaskSet

    @AnimatedGraphicTaskSet.setter
    def AnimatedGraphicTaskSet(self, AnimatedGraphicTaskSet):
        self._AnimatedGraphicTaskSet = AnimatedGraphicTaskSet

    @property
    def SnapshotByTimeOffsetTaskSet(self):
        return self._SnapshotByTimeOffsetTaskSet

    @SnapshotByTimeOffsetTaskSet.setter
    def SnapshotByTimeOffsetTaskSet(self, SnapshotByTimeOffsetTaskSet):
        self._SnapshotByTimeOffsetTaskSet = SnapshotByTimeOffsetTaskSet

    @property
    def SampleSnapshotTaskSet(self):
        return self._SampleSnapshotTaskSet

    @SampleSnapshotTaskSet.setter
    def SampleSnapshotTaskSet(self, SampleSnapshotTaskSet):
        self._SampleSnapshotTaskSet = SampleSnapshotTaskSet

    @property
    def ImageSpriteTaskSet(self):
        return self._ImageSpriteTaskSet

    @ImageSpriteTaskSet.setter
    def ImageSpriteTaskSet(self, ImageSpriteTaskSet):
        self._ImageSpriteTaskSet = ImageSpriteTaskSet

    @property
    def AdaptiveDynamicStreamingTaskSet(self):
        return self._AdaptiveDynamicStreamingTaskSet

    @AdaptiveDynamicStreamingTaskSet.setter
    def AdaptiveDynamicStreamingTaskSet(self, AdaptiveDynamicStreamingTaskSet):
        self._AdaptiveDynamicStreamingTaskSet = AdaptiveDynamicStreamingTaskSet


    def _deserialize(self, params):
        if params.get("TranscodeTaskSet") is not None:
            self._TranscodeTaskSet = []
            for item in params.get("TranscodeTaskSet"):
                obj = TranscodeTaskInput()
                obj._deserialize(item)
                self._TranscodeTaskSet.append(obj)
        if params.get("AnimatedGraphicTaskSet") is not None:
            self._AnimatedGraphicTaskSet = []
            for item in params.get("AnimatedGraphicTaskSet"):
                obj = AnimatedGraphicTaskInput()
                obj._deserialize(item)
                self._AnimatedGraphicTaskSet.append(obj)
        if params.get("SnapshotByTimeOffsetTaskSet") is not None:
            self._SnapshotByTimeOffsetTaskSet = []
            for item in params.get("SnapshotByTimeOffsetTaskSet"):
                obj = SnapshotByTimeOffsetTaskInput()
                obj._deserialize(item)
                self._SnapshotByTimeOffsetTaskSet.append(obj)
        if params.get("SampleSnapshotTaskSet") is not None:
            self._SampleSnapshotTaskSet = []
            for item in params.get("SampleSnapshotTaskSet"):
                obj = SampleSnapshotTaskInput()
                obj._deserialize(item)
                self._SampleSnapshotTaskSet.append(obj)
        if params.get("ImageSpriteTaskSet") is not None:
            self._ImageSpriteTaskSet = []
            for item in params.get("ImageSpriteTaskSet"):
                obj = ImageSpriteTaskInput()
                obj._deserialize(item)
                self._ImageSpriteTaskSet.append(obj)
        if params.get("AdaptiveDynamicStreamingTaskSet") is not None:
            self._AdaptiveDynamicStreamingTaskSet = []
            for item in params.get("AdaptiveDynamicStreamingTaskSet"):
                obj = AdaptiveDynamicStreamingTaskInput()
                obj._deserialize(item)
                self._AdaptiveDynamicStreamingTaskSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaProcessTaskResult(AbstractModel):
    """任务查询结果类型

    """

    def __init__(self):
        r"""
        :param _Type: 任务的类型，可以取的值有：
<li>Transcode：转码</li>
<li>AnimatedGraphics：转动图</li>
<li>SnapshotByTimeOffset：时间点截图</li>
<li>SampleSnapshot：采样截图</li>
<li>ImageSprites：雪碧图</li>
<li>CoverBySnapshot：截图做封面</li>
<li>AdaptiveDynamicStreaming：自适应码流</li>
        :type Type: str
        :param _TranscodeTask: 视频转码任务的查询结果，当任务类型为 Transcode 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type TranscodeTask: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskTranscodeResult`
        :param _AnimatedGraphicTask: 视频转动图任务的查询结果，当任务类型为 AnimatedGraphics 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type AnimatedGraphicTask: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskAnimatedGraphicResult`
        :param _SnapshotByTimeOffsetTask: 对视频按时间点截图任务的查询结果，当任务类型为 SnapshotByTimeOffset 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type SnapshotByTimeOffsetTask: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskSnapshotByTimeOffsetResult`
        :param _SampleSnapshotTask: 对视频采样截图任务的查询结果，当任务类型为 SampleSnapshot 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type SampleSnapshotTask: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskSampleSnapshotResult`
        :param _ImageSpriteTask: 对视频截雪碧图任务的查询结果，当任务类型为 ImageSprite 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type ImageSpriteTask: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskImageSpriteResult`
        :param _AdaptiveDynamicStreamingTask: 转自适应码流任务查询结果，当任务类型为 AdaptiveDynamicStreaming 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type AdaptiveDynamicStreamingTask: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskAdaptiveDynamicStreamingResult`
        """
        self._Type = None
        self._TranscodeTask = None
        self._AnimatedGraphicTask = None
        self._SnapshotByTimeOffsetTask = None
        self._SampleSnapshotTask = None
        self._ImageSpriteTask = None
        self._AdaptiveDynamicStreamingTask = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def TranscodeTask(self):
        return self._TranscodeTask

    @TranscodeTask.setter
    def TranscodeTask(self, TranscodeTask):
        self._TranscodeTask = TranscodeTask

    @property
    def AnimatedGraphicTask(self):
        return self._AnimatedGraphicTask

    @AnimatedGraphicTask.setter
    def AnimatedGraphicTask(self, AnimatedGraphicTask):
        self._AnimatedGraphicTask = AnimatedGraphicTask

    @property
    def SnapshotByTimeOffsetTask(self):
        return self._SnapshotByTimeOffsetTask

    @SnapshotByTimeOffsetTask.setter
    def SnapshotByTimeOffsetTask(self, SnapshotByTimeOffsetTask):
        self._SnapshotByTimeOffsetTask = SnapshotByTimeOffsetTask

    @property
    def SampleSnapshotTask(self):
        return self._SampleSnapshotTask

    @SampleSnapshotTask.setter
    def SampleSnapshotTask(self, SampleSnapshotTask):
        self._SampleSnapshotTask = SampleSnapshotTask

    @property
    def ImageSpriteTask(self):
        return self._ImageSpriteTask

    @ImageSpriteTask.setter
    def ImageSpriteTask(self, ImageSpriteTask):
        self._ImageSpriteTask = ImageSpriteTask

    @property
    def AdaptiveDynamicStreamingTask(self):
        return self._AdaptiveDynamicStreamingTask

    @AdaptiveDynamicStreamingTask.setter
    def AdaptiveDynamicStreamingTask(self, AdaptiveDynamicStreamingTask):
        self._AdaptiveDynamicStreamingTask = AdaptiveDynamicStreamingTask


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("TranscodeTask") is not None:
            self._TranscodeTask = MediaProcessTaskTranscodeResult()
            self._TranscodeTask._deserialize(params.get("TranscodeTask"))
        if params.get("AnimatedGraphicTask") is not None:
            self._AnimatedGraphicTask = MediaProcessTaskAnimatedGraphicResult()
            self._AnimatedGraphicTask._deserialize(params.get("AnimatedGraphicTask"))
        if params.get("SnapshotByTimeOffsetTask") is not None:
            self._SnapshotByTimeOffsetTask = MediaProcessTaskSnapshotByTimeOffsetResult()
            self._SnapshotByTimeOffsetTask._deserialize(params.get("SnapshotByTimeOffsetTask"))
        if params.get("SampleSnapshotTask") is not None:
            self._SampleSnapshotTask = MediaProcessTaskSampleSnapshotResult()
            self._SampleSnapshotTask._deserialize(params.get("SampleSnapshotTask"))
        if params.get("ImageSpriteTask") is not None:
            self._ImageSpriteTask = MediaProcessTaskImageSpriteResult()
            self._ImageSpriteTask._deserialize(params.get("ImageSpriteTask"))
        if params.get("AdaptiveDynamicStreamingTask") is not None:
            self._AdaptiveDynamicStreamingTask = MediaProcessTaskAdaptiveDynamicStreamingResult()
            self._AdaptiveDynamicStreamingTask._deserialize(params.get("AdaptiveDynamicStreamingTask"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaProcessTaskSampleSnapshotResult(AbstractModel):
    """对视频做采样截图任务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 对视频做采样截图任务输入。
        :type Input: :class:`tencentcloud.mps.v20190612.models.SampleSnapshotTaskInput`
        :param _Output: 对视频做采样截图任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.MediaSampleSnapshotItem`
        :param _BeginProcessTime: 任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
注意：此字段可能返回 null，表示取不到有效值。
        :type BeginProcessTime: str
        :param _FinishTime: 任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
注意：此字段可能返回 null，表示取不到有效值。
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def BeginProcessTime(self):
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = SampleSnapshotTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = MediaSampleSnapshotItem()
            self._Output._deserialize(params.get("Output"))
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaProcessTaskSnapshotByTimeOffsetResult(AbstractModel):
    """对视频按指定时间点截图任务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 对视频按指定时间点截图任务输入。
        :type Input: :class:`tencentcloud.mps.v20190612.models.SnapshotByTimeOffsetTaskInput`
        :param _Output: 对视频按指定时间点截图任务输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.MediaSnapshotByTimeOffsetItem`
        :param _BeginProcessTime: 任务开始执行的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
注意：此字段可能返回 null，表示取不到有效值。
        :type BeginProcessTime: str
        :param _FinishTime: 任务执行完毕的时间，采用 [ISO 日期格式](https://cloud.tencent.com/document/product/862/37710#52)。
注意：此字段可能返回 null，表示取不到有效值。
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def BeginProcessTime(self):
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = SnapshotByTimeOffsetTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = MediaSnapshotByTimeOffsetItem()
            self._Output._deserialize(params.get("Output"))
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaProcessTaskTranscodeResult(AbstractModel):
    """转码任务结果类型

    """

    def __init__(self):
        r"""
        :param _Status: 任务状态，有 PROCESSING，SUCCESS 和 FAIL 三种。
        :type Status: str
        :param _ErrCodeExt: 错误码，空字符串表示成功，其他值表示失败，取值请参考 [媒体处理类错误码](https://cloud.tencent.com/document/product/862/50369#.E8.A7.86.E9.A2.91.E5.A4.84.E7.90.86.E7.B1.BB.E9.94.99.E8.AF.AF.E7.A0.81) 列表。
        :type ErrCodeExt: str
        :param _ErrCode: 错误码，0 表示成功，其他值表示失败（该字段已不推荐使用，建议使用新的错误码字段 ErrCodeExt）。
        :type ErrCode: int
        :param _Message: 错误信息。
        :type Message: str
        :param _Input: 转码任务的输入。
        :type Input: :class:`tencentcloud.mps.v20190612.models.TranscodeTaskInput`
        :param _Output: 转码任务的输出。
注意：此字段可能返回 null，表示取不到有效值。
        :type Output: :class:`tencentcloud.mps.v20190612.models.MediaTranscodeItem`
        :param _Progress: 转码进度，取值范围 [0-100]
注意：此字段可能返回 null，表示取不到有效值。
        :type Progress: int
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = TranscodeTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = MediaTranscodeItem()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaSampleSnapshotItem(AbstractModel):
    """采样截图信息

    """

    def __init__(self):
        r"""
        :param _Definition: 采样截图规格 ID，参见[采样截图参数模板](https://cloud.tencent.com/document/product/266/33480#.E9.87.87.E6.A0.B7.E6.88.AA.E5.9B.BE.E6.A8.A1.E6.9D.BF)。
        :type Definition: int
        :param _SampleType: 采样方式，取值范围：
<li>Percent：根据百分比间隔采样。</li>
<li>Time：根据时间间隔采样。</li>
        :type SampleType: str
        :param _Interval: 采样间隔
<li>当 SampleType 为 Percent 时，该值表示多少百分比一张图。</li>
<li>当 SampleType 为 Time 时，该值表示多少时间间隔一张图，单位秒， 第一张图均为视频首帧。</li>
        :type Interval: int
        :param _Storage: 截图后文件的存储位置。
        :type Storage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _ImagePathSet: 生成的截图 path 列表。
        :type ImagePathSet: list of str
        :param _WaterMarkDefinition: 截图如果被打上了水印，被打水印的模板 ID 列表。
        :type WaterMarkDefinition: list of int
        """
        self._Definition = None
        self._SampleType = None
        self._Interval = None
        self._Storage = None
        self._ImagePathSet = None
        self._WaterMarkDefinition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SampleType(self):
        return self._SampleType

    @SampleType.setter
    def SampleType(self, SampleType):
        self._SampleType = SampleType

    @property
    def Interval(self):
        return self._Interval

    @Interval.setter
    def Interval(self, Interval):
        self._Interval = Interval

    @property
    def Storage(self):
        return self._Storage

    @Storage.setter
    def Storage(self, Storage):
        self._Storage = Storage

    @property
    def ImagePathSet(self):
        return self._ImagePathSet

    @ImagePathSet.setter
    def ImagePathSet(self, ImagePathSet):
        self._ImagePathSet = ImagePathSet

    @property
    def WaterMarkDefinition(self):
        return self._WaterMarkDefinition

    @WaterMarkDefinition.setter
    def WaterMarkDefinition(self, WaterMarkDefinition):
        self._WaterMarkDefinition = WaterMarkDefinition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SampleType = params.get("SampleType")
        self._Interval = params.get("Interval")
        if params.get("Storage") is not None:
            self._Storage = TaskOutputStorage()
            self._Storage._deserialize(params.get("Storage"))
        self._ImagePathSet = params.get("ImagePathSet")
        self._WaterMarkDefinition = params.get("WaterMarkDefinition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaSnapshotByTimeOffsetItem(AbstractModel):
    """点播文件指定时间点截图信息

    """

    def __init__(self):
        r"""
        :param _Definition: 指定时间点截图规格，参见[指定时间点截图参数模板](https://cloud.tencent.com/document/product/266/33480#.E6.97.B6.E9.97.B4.E7.82.B9.E6.88.AA.E5.9B.BE.E6.A8.A1.E6.9D.BF)。
        :type Definition: int
        :param _PicInfoSet: 同一规格的截图信息集合，每个元素代表一张截图。
        :type PicInfoSet: list of MediaSnapshotByTimePicInfoItem
        :param _Storage: 指定时间点截图文件的存储位置。
        :type Storage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        self._Definition = None
        self._PicInfoSet = None
        self._Storage = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def PicInfoSet(self):
        return self._PicInfoSet

    @PicInfoSet.setter
    def PicInfoSet(self, PicInfoSet):
        self._PicInfoSet = PicInfoSet

    @property
    def Storage(self):
        return self._Storage

    @Storage.setter
    def Storage(self, Storage):
        self._Storage = Storage


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        if params.get("PicInfoSet") is not None:
            self._PicInfoSet = []
            for item in params.get("PicInfoSet"):
                obj = MediaSnapshotByTimePicInfoItem()
                obj._deserialize(item)
                self._PicInfoSet.append(obj)
        if params.get("Storage") is not None:
            self._Storage = TaskOutputStorage()
            self._Storage._deserialize(params.get("Storage"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaSnapshotByTimePicInfoItem(AbstractModel):
    """指定时间点截图信息

    """

    def __init__(self):
        r"""
        :param _TimeOffset: 该张截图对应视频文件中的时间偏移，单位为秒。
        :type TimeOffset: float
        :param _Path: 该张截图的路径。
        :type Path: str
        :param _WaterMarkDefinition: 截图如果被打上了水印，被打水印的模板 ID 列表。
        :type WaterMarkDefinition: list of int
        """
        self._TimeOffset = None
        self._Path = None
        self._WaterMarkDefinition = None

    @property
    def TimeOffset(self):
        return self._TimeOffset

    @TimeOffset.setter
    def TimeOffset(self, TimeOffset):
        self._TimeOffset = TimeOffset

    @property
    def Path(self):
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def WaterMarkDefinition(self):
        return self._WaterMarkDefinition

    @WaterMarkDefinition.setter
    def WaterMarkDefinition(self, WaterMarkDefinition):
        self._WaterMarkDefinition = WaterMarkDefinition


    def _deserialize(self, params):
        self._TimeOffset = params.get("TimeOffset")
        self._Path = params.get("Path")
        self._WaterMarkDefinition = params.get("WaterMarkDefinition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaTranscodeItem(AbstractModel):
    """转码信息

    """

    def __init__(self):
        r"""
        :param _OutputStorage: 转码后文件的目标存储。
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _Path: 转码后的视频文件路径。
        :type Path: str
        :param _Definition: 转码规格 ID，参见[转码参数模板](https://cloud.tencent.com/document/product/862/37042)。
        :type Definition: int
        :param _Bitrate: 视频流码率平均值与音频流码率平均值之和， 单位：bps。
        :type Bitrate: int
        :param _Height: 视频流高度的最大值，单位：px。
        :type Height: int
        :param _Width: 视频流宽度的最大值，单位：px。
        :type Width: int
        :param _Size: 媒体文件总大小（视频为 HLS 时，大小是 m3u8 和 ts 文件大小的总和），单位：字节。
        :type Size: int
        :param _Duration: 视频时长，单位：秒。
        :type Duration: float
        :param _Container: 容器类型，例如 m4a，mp4 等。
        :type Container: str
        :param _Md5: 视频的 md5 值。
        :type Md5: str
        :param _AudioStreamSet: 音频流信息。
        :type AudioStreamSet: list of MediaAudioStreamItem
        :param _VideoStreamSet: 视频流信息。
        :type VideoStreamSet: list of MediaVideoStreamItem
        """
        self._OutputStorage = None
        self._Path = None
        self._Definition = None
        self._Bitrate = None
        self._Height = None
        self._Width = None
        self._Size = None
        self._Duration = None
        self._Container = None
        self._Md5 = None
        self._AudioStreamSet = None
        self._VideoStreamSet = None

    @property
    def OutputStorage(self):
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage

    @property
    def Path(self):
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Bitrate(self):
        return self._Bitrate

    @Bitrate.setter
    def Bitrate(self, Bitrate):
        self._Bitrate = Bitrate

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Size(self):
        return self._Size

    @Size.setter
    def Size(self, Size):
        self._Size = Size

    @property
    def Duration(self):
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration

    @property
    def Container(self):
        return self._Container

    @Container.setter
    def Container(self, Container):
        self._Container = Container

    @property
    def Md5(self):
        return self._Md5

    @Md5.setter
    def Md5(self, Md5):
        self._Md5 = Md5

    @property
    def AudioStreamSet(self):
        return self._AudioStreamSet

    @AudioStreamSet.setter
    def AudioStreamSet(self, AudioStreamSet):
        self._AudioStreamSet = AudioStreamSet

    @property
    def VideoStreamSet(self):
        return self._VideoStreamSet

    @VideoStreamSet.setter
    def VideoStreamSet(self, VideoStreamSet):
        self._VideoStreamSet = VideoStreamSet


    def _deserialize(self, params):
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        self._Path = params.get("Path")
        self._Definition = params.get("Definition")
        self._Bitrate = params.get("Bitrate")
        self._Height = params.get("Height")
        self._Width = params.get("Width")
        self._Size = params.get("Size")
        self._Duration = params.get("Duration")
        self._Container = params.get("Container")
        self._Md5 = params.get("Md5")
        if params.get("AudioStreamSet") is not None:
            self._AudioStreamSet = []
            for item in params.get("AudioStreamSet"):
                obj = MediaAudioStreamItem()
                obj._deserialize(item)
                self._AudioStreamSet.append(obj)
        if params.get("VideoStreamSet") is not None:
            self._VideoStreamSet = []
            for item in params.get("VideoStreamSet"):
                obj = MediaVideoStreamItem()
                obj._deserialize(item)
                self._VideoStreamSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaVideoStreamItem(AbstractModel):
    """点播文件视频流信息

    """

    def __init__(self):
        r"""
        :param _Bitrate: 视频流的码率，单位：bps。
        :type Bitrate: int
        :param _Height: 视频流的高度，单位：px。
        :type Height: int
        :param _Width: 视频流的宽度，单位：px。
        :type Width: int
        :param _Codec: 视频流的编码格式，例如 h264。
        :type Codec: str
        :param _Fps: 帧率，单位：hz。
        :type Fps: int
        :param _ColorPrimaries: 色彩空间。
注意：此字段可能返回 null，表示取不到有效值。
        :type ColorPrimaries: str
        :param _ColorSpace: 色彩空间。
注意：此字段可能返回 null，表示取不到有效值。
        :type ColorSpace: str
        :param _ColorTransfer: 色彩空间。
注意：此字段可能返回 null，表示取不到有效值。
        :type ColorTransfer: str
        :param _HdrType: HDR类型。
注意：此字段可能返回 null，表示取不到有效值。
        :type HdrType: str
        :param _Codecs: 视频Codecs。
注意：此字段可能返回 null，表示取不到有效值。
        :type Codecs: str
        """
        self._Bitrate = None
        self._Height = None
        self._Width = None
        self._Codec = None
        self._Fps = None
        self._ColorPrimaries = None
        self._ColorSpace = None
        self._ColorTransfer = None
        self._HdrType = None
        self._Codecs = None

    @property
    def Bitrate(self):
        return self._Bitrate

    @Bitrate.setter
    def Bitrate(self, Bitrate):
        self._Bitrate = Bitrate

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Codec(self):
        return self._Codec

    @Codec.setter
    def Codec(self, Codec):
        self._Codec = Codec

    @property
    def Fps(self):
        return self._Fps

    @Fps.setter
    def Fps(self, Fps):
        self._Fps = Fps

    @property
    def ColorPrimaries(self):
        return self._ColorPrimaries

    @ColorPrimaries.setter
    def ColorPrimaries(self, ColorPrimaries):
        self._ColorPrimaries = ColorPrimaries

    @property
    def ColorSpace(self):
        return self._ColorSpace

    @ColorSpace.setter
    def ColorSpace(self, ColorSpace):
        self._ColorSpace = ColorSpace

    @property
    def ColorTransfer(self):
        return self._ColorTransfer

    @ColorTransfer.setter
    def ColorTransfer(self, ColorTransfer):
        self._ColorTransfer = ColorTransfer

    @property
    def HdrType(self):
        return self._HdrType

    @HdrType.setter
    def HdrType(self, HdrType):
        self._HdrType = HdrType

    @property
    def Codecs(self):
        return self._Codecs

    @Codecs.setter
    def Codecs(self, Codecs):
        self._Codecs = Codecs


    def _deserialize(self, params):
        self._Bitrate = params.get("Bitrate")
        self._Height = params.get("Height")
        self._Width = params.get("Width")
        self._Codec = params.get("Codec")
        self._Fps = params.get("Fps")
        self._ColorPrimaries = params.get("ColorPrimaries")
        self._ColorSpace = params.get("ColorSpace")
        self._ColorTransfer = params.get("ColorTransfer")
        self._HdrType = params.get("HdrType")
        self._Codecs = params.get("Codecs")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAIAnalysisTemplateRequest(AbstractModel):
    """ModifyAIAnalysisTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 视频内容分析模板唯一标识。
        :type Definition: int
        :param _Name: 视频内容分析模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Comment: 视频内容分析模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _ClassificationConfigure: 智能分类任务控制参数。
        :type ClassificationConfigure: :class:`tencentcloud.mps.v20190612.models.ClassificationConfigureInfoForUpdate`
        :param _TagConfigure: 智能标签任务控制参数。
        :type TagConfigure: :class:`tencentcloud.mps.v20190612.models.TagConfigureInfoForUpdate`
        :param _CoverConfigure: 智能封面任务控制参数。
        :type CoverConfigure: :class:`tencentcloud.mps.v20190612.models.CoverConfigureInfoForUpdate`
        :param _FrameTagConfigure: 智能按帧标签任务控制参数。
        :type FrameTagConfigure: :class:`tencentcloud.mps.v20190612.models.FrameTagConfigureInfoForUpdate`
        """
        self._Definition = None
        self._Name = None
        self._Comment = None
        self._ClassificationConfigure = None
        self._TagConfigure = None
        self._CoverConfigure = None
        self._FrameTagConfigure = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def ClassificationConfigure(self):
        return self._ClassificationConfigure

    @ClassificationConfigure.setter
    def ClassificationConfigure(self, ClassificationConfigure):
        self._ClassificationConfigure = ClassificationConfigure

    @property
    def TagConfigure(self):
        return self._TagConfigure

    @TagConfigure.setter
    def TagConfigure(self, TagConfigure):
        self._TagConfigure = TagConfigure

    @property
    def CoverConfigure(self):
        return self._CoverConfigure

    @CoverConfigure.setter
    def CoverConfigure(self, CoverConfigure):
        self._CoverConfigure = CoverConfigure

    @property
    def FrameTagConfigure(self):
        return self._FrameTagConfigure

    @FrameTagConfigure.setter
    def FrameTagConfigure(self, FrameTagConfigure):
        self._FrameTagConfigure = FrameTagConfigure


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("ClassificationConfigure") is not None:
            self._ClassificationConfigure = ClassificationConfigureInfoForUpdate()
            self._ClassificationConfigure._deserialize(params.get("ClassificationConfigure"))
        if params.get("TagConfigure") is not None:
            self._TagConfigure = TagConfigureInfoForUpdate()
            self._TagConfigure._deserialize(params.get("TagConfigure"))
        if params.get("CoverConfigure") is not None:
            self._CoverConfigure = CoverConfigureInfoForUpdate()
            self._CoverConfigure._deserialize(params.get("CoverConfigure"))
        if params.get("FrameTagConfigure") is not None:
            self._FrameTagConfigure = FrameTagConfigureInfoForUpdate()
            self._FrameTagConfigure._deserialize(params.get("FrameTagConfigure"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAIAnalysisTemplateResponse(AbstractModel):
    """ModifyAIAnalysisTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyAIRecognitionTemplateRequest(AbstractModel):
    """ModifyAIRecognitionTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 视频内容识别模板唯一标识。
        :type Definition: int
        :param _Name: 视频内容识别模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Comment: 视频内容识别模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _FaceConfigure: 人脸识别控制参数。
        :type FaceConfigure: :class:`tencentcloud.mps.v20190612.models.FaceConfigureInfoForUpdate`
        :param _OcrFullTextConfigure: 文本全文识别控制参数。
        :type OcrFullTextConfigure: :class:`tencentcloud.mps.v20190612.models.OcrFullTextConfigureInfoForUpdate`
        :param _OcrWordsConfigure: 文本关键词识别控制参数。
        :type OcrWordsConfigure: :class:`tencentcloud.mps.v20190612.models.OcrWordsConfigureInfoForUpdate`
        :param _AsrFullTextConfigure: 语音全文识别控制参数。
        :type AsrFullTextConfigure: :class:`tencentcloud.mps.v20190612.models.AsrFullTextConfigureInfoForUpdate`
        :param _AsrWordsConfigure: 语音关键词识别控制参数。
        :type AsrWordsConfigure: :class:`tencentcloud.mps.v20190612.models.AsrWordsConfigureInfoForUpdate`
        :param _TranslateConfigure: 语音翻译控制参数。
        :type TranslateConfigure: :class:`tencentcloud.mps.v20190612.models.TranslateConfigureInfoForUpdate`
        """
        self._Definition = None
        self._Name = None
        self._Comment = None
        self._FaceConfigure = None
        self._OcrFullTextConfigure = None
        self._OcrWordsConfigure = None
        self._AsrFullTextConfigure = None
        self._AsrWordsConfigure = None
        self._TranslateConfigure = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def FaceConfigure(self):
        return self._FaceConfigure

    @FaceConfigure.setter
    def FaceConfigure(self, FaceConfigure):
        self._FaceConfigure = FaceConfigure

    @property
    def OcrFullTextConfigure(self):
        return self._OcrFullTextConfigure

    @OcrFullTextConfigure.setter
    def OcrFullTextConfigure(self, OcrFullTextConfigure):
        self._OcrFullTextConfigure = OcrFullTextConfigure

    @property
    def OcrWordsConfigure(self):
        return self._OcrWordsConfigure

    @OcrWordsConfigure.setter
    def OcrWordsConfigure(self, OcrWordsConfigure):
        self._OcrWordsConfigure = OcrWordsConfigure

    @property
    def AsrFullTextConfigure(self):
        return self._AsrFullTextConfigure

    @AsrFullTextConfigure.setter
    def AsrFullTextConfigure(self, AsrFullTextConfigure):
        self._AsrFullTextConfigure = AsrFullTextConfigure

    @property
    def AsrWordsConfigure(self):
        return self._AsrWordsConfigure

    @AsrWordsConfigure.setter
    def AsrWordsConfigure(self, AsrWordsConfigure):
        self._AsrWordsConfigure = AsrWordsConfigure

    @property
    def TranslateConfigure(self):
        return self._TranslateConfigure

    @TranslateConfigure.setter
    def TranslateConfigure(self, TranslateConfigure):
        self._TranslateConfigure = TranslateConfigure


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("FaceConfigure") is not None:
            self._FaceConfigure = FaceConfigureInfoForUpdate()
            self._FaceConfigure._deserialize(params.get("FaceConfigure"))
        if params.get("OcrFullTextConfigure") is not None:
            self._OcrFullTextConfigure = OcrFullTextConfigureInfoForUpdate()
            self._OcrFullTextConfigure._deserialize(params.get("OcrFullTextConfigure"))
        if params.get("OcrWordsConfigure") is not None:
            self._OcrWordsConfigure = OcrWordsConfigureInfoForUpdate()
            self._OcrWordsConfigure._deserialize(params.get("OcrWordsConfigure"))
        if params.get("AsrFullTextConfigure") is not None:
            self._AsrFullTextConfigure = AsrFullTextConfigureInfoForUpdate()
            self._AsrFullTextConfigure._deserialize(params.get("AsrFullTextConfigure"))
        if params.get("AsrWordsConfigure") is not None:
            self._AsrWordsConfigure = AsrWordsConfigureInfoForUpdate()
            self._AsrWordsConfigure._deserialize(params.get("AsrWordsConfigure"))
        if params.get("TranslateConfigure") is not None:
            self._TranslateConfigure = TranslateConfigureInfoForUpdate()
            self._TranslateConfigure._deserialize(params.get("TranslateConfigure"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAIRecognitionTemplateResponse(AbstractModel):
    """ModifyAIRecognitionTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyAdaptiveDynamicStreamingTemplateRequest(AbstractModel):
    """ModifyAdaptiveDynamicStreamingTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 转自适应码流模板唯一标识。
        :type Definition: int
        :param _Name: 模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Format: 转自适应码流格式，取值范围：
<li>HLS，</li>
<li>MPEG-DASH。</li>
        :type Format: str
        :param _DisableHigherVideoBitrate: 是否禁止视频低码率转高码率，取值范围：
<li>0：否，</li>
<li>1：是。</li>
        :type DisableHigherVideoBitrate: int
        :param _DisableHigherVideoResolution: 是否禁止视频分辨率转高分辨率，取值范围：
<li>0：否，</li>
<li>1：是。</li>
        :type DisableHigherVideoResolution: int
        :param _StreamInfos: 转自适应码流输入流参数信息，最多输入10路流。
注意：各个流的帧率必须保持一致；如果不一致，采用第一个流的帧率作为输出帧率。
        :type StreamInfos: list of AdaptiveStreamTemplate
        :param _Comment: 模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _PureAudio: 是否为纯音频，0表示视频模版，1表示纯音频模版
当值为1：
1. StreamInfos.N.RemoveVideo=1
2. StreamInfos.N.RemoveAudio=0
3. StreamInfos.N.Video.Codec=copy

当值为0：

1. StreamInfos.N.Video.Codec不能为copy
2. StreamInfos.N.Video.Fps不能为null
        :type PureAudio: int
        :param _SegmentType: hls 分片类型，可选值： <li>ts-segment：HLS+TS 切片</li> <li>ts-byterange：HLS+TS byte range</li> <li>mp4-segment：HLS+MP4 切片</li> <li>mp4-byterange：HLS+MP4 byte range</li> <li>ts-packed-audio：TS+Packed Audio</li> <li>mp4-packed-audio：MP4+Packed Audio</li> 默认值：ts-segment 
注：自适应码流的hls分片格式已此字段为准
        :type SegmentType: str
        """
        self._Definition = None
        self._Name = None
        self._Format = None
        self._DisableHigherVideoBitrate = None
        self._DisableHigherVideoResolution = None
        self._StreamInfos = None
        self._Comment = None
        self._PureAudio = None
        self._SegmentType = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Format(self):
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def DisableHigherVideoBitrate(self):
        return self._DisableHigherVideoBitrate

    @DisableHigherVideoBitrate.setter
    def DisableHigherVideoBitrate(self, DisableHigherVideoBitrate):
        self._DisableHigherVideoBitrate = DisableHigherVideoBitrate

    @property
    def DisableHigherVideoResolution(self):
        return self._DisableHigherVideoResolution

    @DisableHigherVideoResolution.setter
    def DisableHigherVideoResolution(self, DisableHigherVideoResolution):
        self._DisableHigherVideoResolution = DisableHigherVideoResolution

    @property
    def StreamInfos(self):
        return self._StreamInfos

    @StreamInfos.setter
    def StreamInfos(self, StreamInfos):
        self._StreamInfos = StreamInfos

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def PureAudio(self):
        return self._PureAudio

    @PureAudio.setter
    def PureAudio(self, PureAudio):
        self._PureAudio = PureAudio

    @property
    def SegmentType(self):
        return self._SegmentType

    @SegmentType.setter
    def SegmentType(self, SegmentType):
        self._SegmentType = SegmentType


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Name = params.get("Name")
        self._Format = params.get("Format")
        self._DisableHigherVideoBitrate = params.get("DisableHigherVideoBitrate")
        self._DisableHigherVideoResolution = params.get("DisableHigherVideoResolution")
        if params.get("StreamInfos") is not None:
            self._StreamInfos = []
            for item in params.get("StreamInfos"):
                obj = AdaptiveStreamTemplate()
                obj._deserialize(item)
                self._StreamInfos.append(obj)
        self._Comment = params.get("Comment")
        self._PureAudio = params.get("PureAudio")
        self._SegmentType = params.get("SegmentType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAdaptiveDynamicStreamingTemplateResponse(AbstractModel):
    """ModifyAdaptiveDynamicStreamingTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyAnimatedGraphicsTemplateRequest(AbstractModel):
    """ModifyAnimatedGraphicsTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 转动图模板唯一标识。
        :type Definition: int
        :param _Name: 转动图模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Width: 动图宽度（或长边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :type Width: int
        :param _Height: 动图高度（或短边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :type Height: int
        :param _ResolutionAdaptive: 分辨率自适应，可选值：
<li>open：开启，此时，Width 代表视频的长边，Height 表示视频的短边；</li>
<li>close：关闭，此时，Width 代表视频的宽度，Height 表示视频的高度。</li>
默认值：open。
        :type ResolutionAdaptive: str
        :param _Format: 动图格式，取值为 gif 和 webp。
        :type Format: str
        :param _Fps: 帧率，取值范围：[1, 30]，单位：Hz。
        :type Fps: int
        :param _Quality: 图片质量，取值范围：[1, 100]，默认值为 75。
        :type Quality: float
        :param _Comment: 模板描述信息，长度限制：256 个字符。
        :type Comment: str
        """
        self._Definition = None
        self._Name = None
        self._Width = None
        self._Height = None
        self._ResolutionAdaptive = None
        self._Format = None
        self._Fps = None
        self._Quality = None
        self._Comment = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ResolutionAdaptive(self):
        return self._ResolutionAdaptive

    @ResolutionAdaptive.setter
    def ResolutionAdaptive(self, ResolutionAdaptive):
        self._ResolutionAdaptive = ResolutionAdaptive

    @property
    def Format(self):
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def Fps(self):
        return self._Fps

    @Fps.setter
    def Fps(self, Fps):
        self._Fps = Fps

    @property
    def Quality(self):
        return self._Quality

    @Quality.setter
    def Quality(self, Quality):
        self._Quality = Quality

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Name = params.get("Name")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._ResolutionAdaptive = params.get("ResolutionAdaptive")
        self._Format = params.get("Format")
        self._Fps = params.get("Fps")
        self._Quality = params.get("Quality")
        self._Comment = params.get("Comment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAnimatedGraphicsTemplateResponse(AbstractModel):
    """ModifyAnimatedGraphicsTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyContentReviewTemplateRequest(AbstractModel):
    """ModifyContentReviewTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 内容审核模板唯一标识。
        :type Definition: int
        :param _Name: 内容审核模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Comment: 内容审核模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _PornConfigure: 令人反感的信息的控制参数。
        :type PornConfigure: :class:`tencentcloud.mps.v20190612.models.PornConfigureInfoForUpdate`
        :param _TerrorismConfigure: 令人不安全的信息的控制参数。
        :type TerrorismConfigure: :class:`tencentcloud.mps.v20190612.models.TerrorismConfigureInfoForUpdate`
        :param _PoliticalConfigure: 令人不适宜的控制参数。
        :type PoliticalConfigure: :class:`tencentcloud.mps.v20190612.models.PoliticalConfigureInfoForUpdate`
        :param _ProhibitedConfigure: 违禁控制参数。违禁内容包括：
<li>谩骂；</li>
<li>涉毒违法。</li>
注意：此参数尚未支持。
        :type ProhibitedConfigure: :class:`tencentcloud.mps.v20190612.models.ProhibitedConfigureInfoForUpdate`
        :param _UserDefineConfigure: 用户自定义内容审核控制参数。
        :type UserDefineConfigure: :class:`tencentcloud.mps.v20190612.models.UserDefineConfigureInfoForUpdate`
        """
        self._Definition = None
        self._Name = None
        self._Comment = None
        self._PornConfigure = None
        self._TerrorismConfigure = None
        self._PoliticalConfigure = None
        self._ProhibitedConfigure = None
        self._UserDefineConfigure = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def PornConfigure(self):
        return self._PornConfigure

    @PornConfigure.setter
    def PornConfigure(self, PornConfigure):
        self._PornConfigure = PornConfigure

    @property
    def TerrorismConfigure(self):
        return self._TerrorismConfigure

    @TerrorismConfigure.setter
    def TerrorismConfigure(self, TerrorismConfigure):
        self._TerrorismConfigure = TerrorismConfigure

    @property
    def PoliticalConfigure(self):
        return self._PoliticalConfigure

    @PoliticalConfigure.setter
    def PoliticalConfigure(self, PoliticalConfigure):
        self._PoliticalConfigure = PoliticalConfigure

    @property
    def ProhibitedConfigure(self):
        return self._ProhibitedConfigure

    @ProhibitedConfigure.setter
    def ProhibitedConfigure(self, ProhibitedConfigure):
        self._ProhibitedConfigure = ProhibitedConfigure

    @property
    def UserDefineConfigure(self):
        return self._UserDefineConfigure

    @UserDefineConfigure.setter
    def UserDefineConfigure(self, UserDefineConfigure):
        self._UserDefineConfigure = UserDefineConfigure


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("PornConfigure") is not None:
            self._PornConfigure = PornConfigureInfoForUpdate()
            self._PornConfigure._deserialize(params.get("PornConfigure"))
        if params.get("TerrorismConfigure") is not None:
            self._TerrorismConfigure = TerrorismConfigureInfoForUpdate()
            self._TerrorismConfigure._deserialize(params.get("TerrorismConfigure"))
        if params.get("PoliticalConfigure") is not None:
            self._PoliticalConfigure = PoliticalConfigureInfoForUpdate()
            self._PoliticalConfigure._deserialize(params.get("PoliticalConfigure"))
        if params.get("ProhibitedConfigure") is not None:
            self._ProhibitedConfigure = ProhibitedConfigureInfoForUpdate()
            self._ProhibitedConfigure._deserialize(params.get("ProhibitedConfigure"))
        if params.get("UserDefineConfigure") is not None:
            self._UserDefineConfigure = UserDefineConfigureInfoForUpdate()
            self._UserDefineConfigure._deserialize(params.get("UserDefineConfigure"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyContentReviewTemplateResponse(AbstractModel):
    """ModifyContentReviewTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyImageSpriteTemplateRequest(AbstractModel):
    """ModifyImageSpriteTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 雪碧图模板唯一标识。
        :type Definition: int
        :param _Name: 雪碧图模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Width: 雪碧图中小图的宽度（或长边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :type Width: int
        :param _Height: 雪碧图中小图的高度（或短边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :type Height: int
        :param _ResolutionAdaptive: 分辨率自适应，可选值：
<li>open：开启，此时，Width 代表视频的长边，Height 表示视频的短边；</li>
<li>close：关闭，此时，Width 代表视频的宽度，Height 表示视频的高度。</li>
默认值：open。
        :type ResolutionAdaptive: str
        :param _SampleType: 采样类型，取值：
<li>Percent：按百分比。</li>
<li>Time：按时间间隔。</li>
        :type SampleType: str
        :param _SampleInterval: 采样间隔。
<li>当 SampleType 为 Percent 时，指定采样间隔的百分比。</li>
<li>当 SampleType 为 Time 时，指定采样间隔的时间，单位为秒。</li>
        :type SampleInterval: int
        :param _RowCount: 雪碧图中小图的行数。
        :type RowCount: int
        :param _ColumnCount: 雪碧图中小图的列数。
        :type ColumnCount: int
        :param _FillType: 填充方式，当视频流配置宽高参数与原始视频的宽高比不一致时，对转码的处理方式，即为“填充”。可选填充方式：
<li> stretch：拉伸，对每一帧进行拉伸，填满整个画面，可能导致转码后的视频被“压扁“或者“拉长“；</li>
<li>black：留黑，保持视频宽高比不变，边缘剩余部分使用黑色填充。</li>
默认值：black 。
        :type FillType: str
        :param _Comment: 模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _Format: 图片格式，取值可以为 jpg、png、webp。
        :type Format: str
        """
        self._Definition = None
        self._Name = None
        self._Width = None
        self._Height = None
        self._ResolutionAdaptive = None
        self._SampleType = None
        self._SampleInterval = None
        self._RowCount = None
        self._ColumnCount = None
        self._FillType = None
        self._Comment = None
        self._Format = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ResolutionAdaptive(self):
        return self._ResolutionAdaptive

    @ResolutionAdaptive.setter
    def ResolutionAdaptive(self, ResolutionAdaptive):
        self._ResolutionAdaptive = ResolutionAdaptive

    @property
    def SampleType(self):
        return self._SampleType

    @SampleType.setter
    def SampleType(self, SampleType):
        self._SampleType = SampleType

    @property
    def SampleInterval(self):
        return self._SampleInterval

    @SampleInterval.setter
    def SampleInterval(self, SampleInterval):
        self._SampleInterval = SampleInterval

    @property
    def RowCount(self):
        return self._RowCount

    @RowCount.setter
    def RowCount(self, RowCount):
        self._RowCount = RowCount

    @property
    def ColumnCount(self):
        return self._ColumnCount

    @ColumnCount.setter
    def ColumnCount(self, ColumnCount):
        self._ColumnCount = ColumnCount

    @property
    def FillType(self):
        return self._FillType

    @FillType.setter
    def FillType(self, FillType):
        self._FillType = FillType

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def Format(self):
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Name = params.get("Name")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._ResolutionAdaptive = params.get("ResolutionAdaptive")
        self._SampleType = params.get("SampleType")
        self._SampleInterval = params.get("SampleInterval")
        self._RowCount = params.get("RowCount")
        self._ColumnCount = params.get("ColumnCount")
        self._FillType = params.get("FillType")
        self._Comment = params.get("Comment")
        self._Format = params.get("Format")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyImageSpriteTemplateResponse(AbstractModel):
    """ModifyImageSpriteTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyInput(AbstractModel):
    """修改输入信息的参数。

    """

    def __init__(self):
        r"""
        :param _InputId: 输入Id。
        :type InputId: str
        :param _InputName: 输入名称。
        :type InputName: str
        :param _Description: 输入描述。
        :type Description: str
        :param _AllowIpList: 允许的推流的IP，CIDR格式。
        :type AllowIpList: list of str
        :param _SRTSettings: SRT的配置信息。
        :type SRTSettings: :class:`tencentcloud.mps.v20190612.models.CreateInputSRTSettings`
        :param _RTPSettings: RTP的配置信息。
        :type RTPSettings: :class:`tencentcloud.mps.v20190612.models.CreateInputRTPSettings`
        :param _Protocol: 输入的协议，可选[SRT|RTP|RTMP]。
当输出包含RTP时，输入只能是RTP。
当输出包含RTMP时，输入可以是SRT/RTMP。
当输出包含SRT时，输入只能是SRT。
        :type Protocol: str
        :param _FailOver: 输入的主备开关，可选[OPEN|CLOSE]。
        :type FailOver: str
        :param _RTMPPullSettings: RTMP_PULL的配置信息。
        :type RTMPPullSettings: :class:`tencentcloud.mps.v20190612.models.CreateInputRTMPPullSettings`
        :param _RTSPPullSettings: RTSP_PULL的配置信息。
        :type RTSPPullSettings: :class:`tencentcloud.mps.v20190612.models.CreateInputRTSPPullSettings`
        :param _HLSPullSettings: HLS_PULL的配置信息。
        :type HLSPullSettings: :class:`tencentcloud.mps.v20190612.models.CreateInputHLSPullSettings`
        :param _ResilientStream: 延播平滑吐流配置信息。
        :type ResilientStream: :class:`tencentcloud.mps.v20190612.models.ResilientStreamConf`
        :param _SecurityGroupIds: 绑定的输入安全组 ID。 仅支持关联一组安全组。
        :type SecurityGroupIds: list of str
        :param _Zones: 可用区，非必填，最多支持输入两个可用区，对于需改接口，只要第二个可用区会参与到资源分配。如果input开启容灾或者涉及RTSP_PULL协议切换时有效(会重新分配地址)。	
        :type Zones: list of str
        """
        self._InputId = None
        self._InputName = None
        self._Description = None
        self._AllowIpList = None
        self._SRTSettings = None
        self._RTPSettings = None
        self._Protocol = None
        self._FailOver = None
        self._RTMPPullSettings = None
        self._RTSPPullSettings = None
        self._HLSPullSettings = None
        self._ResilientStream = None
        self._SecurityGroupIds = None
        self._Zones = None

    @property
    def InputId(self):
        return self._InputId

    @InputId.setter
    def InputId(self, InputId):
        self._InputId = InputId

    @property
    def InputName(self):
        return self._InputName

    @InputName.setter
    def InputName(self, InputName):
        self._InputName = InputName

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def AllowIpList(self):
        return self._AllowIpList

    @AllowIpList.setter
    def AllowIpList(self, AllowIpList):
        self._AllowIpList = AllowIpList

    @property
    def SRTSettings(self):
        return self._SRTSettings

    @SRTSettings.setter
    def SRTSettings(self, SRTSettings):
        self._SRTSettings = SRTSettings

    @property
    def RTPSettings(self):
        return self._RTPSettings

    @RTPSettings.setter
    def RTPSettings(self, RTPSettings):
        self._RTPSettings = RTPSettings

    @property
    def Protocol(self):
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def FailOver(self):
        return self._FailOver

    @FailOver.setter
    def FailOver(self, FailOver):
        self._FailOver = FailOver

    @property
    def RTMPPullSettings(self):
        return self._RTMPPullSettings

    @RTMPPullSettings.setter
    def RTMPPullSettings(self, RTMPPullSettings):
        self._RTMPPullSettings = RTMPPullSettings

    @property
    def RTSPPullSettings(self):
        return self._RTSPPullSettings

    @RTSPPullSettings.setter
    def RTSPPullSettings(self, RTSPPullSettings):
        self._RTSPPullSettings = RTSPPullSettings

    @property
    def HLSPullSettings(self):
        return self._HLSPullSettings

    @HLSPullSettings.setter
    def HLSPullSettings(self, HLSPullSettings):
        self._HLSPullSettings = HLSPullSettings

    @property
    def ResilientStream(self):
        return self._ResilientStream

    @ResilientStream.setter
    def ResilientStream(self, ResilientStream):
        self._ResilientStream = ResilientStream

    @property
    def SecurityGroupIds(self):
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds

    @property
    def Zones(self):
        return self._Zones

    @Zones.setter
    def Zones(self, Zones):
        self._Zones = Zones


    def _deserialize(self, params):
        self._InputId = params.get("InputId")
        self._InputName = params.get("InputName")
        self._Description = params.get("Description")
        self._AllowIpList = params.get("AllowIpList")
        if params.get("SRTSettings") is not None:
            self._SRTSettings = CreateInputSRTSettings()
            self._SRTSettings._deserialize(params.get("SRTSettings"))
        if params.get("RTPSettings") is not None:
            self._RTPSettings = CreateInputRTPSettings()
            self._RTPSettings._deserialize(params.get("RTPSettings"))
        self._Protocol = params.get("Protocol")
        self._FailOver = params.get("FailOver")
        if params.get("RTMPPullSettings") is not None:
            self._RTMPPullSettings = CreateInputRTMPPullSettings()
            self._RTMPPullSettings._deserialize(params.get("RTMPPullSettings"))
        if params.get("RTSPPullSettings") is not None:
            self._RTSPPullSettings = CreateInputRTSPPullSettings()
            self._RTSPPullSettings._deserialize(params.get("RTSPPullSettings"))
        if params.get("HLSPullSettings") is not None:
            self._HLSPullSettings = CreateInputHLSPullSettings()
            self._HLSPullSettings._deserialize(params.get("HLSPullSettings"))
        if params.get("ResilientStream") is not None:
            self._ResilientStream = ResilientStreamConf()
            self._ResilientStream._deserialize(params.get("ResilientStream"))
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        self._Zones = params.get("Zones")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyOutputInfo(AbstractModel):
    """修改Output配置。

    """

    def __init__(self):
        r"""
        :param _OutputId: 需要修改的Output的Id。
        :type OutputId: str
        :param _OutputName: 输出的名称。
        :type OutputName: str
        :param _Description: 输出的描述。
        :type Description: str
        :param _Protocol: 输出的转推协议，支持SRT|RTP|RTMP。
        :type Protocol: str
        :param _SRTSettings: 转推SRT的配置。
        :type SRTSettings: :class:`tencentcloud.mps.v20190612.models.CreateOutputSRTSettings`
        :param _RTPSettings: 转推RTP的配置。
        :type RTPSettings: :class:`tencentcloud.mps.v20190612.models.CreateOutputInfoRTPSettings`
        :param _RTMPSettings: 转推RTMP的配置。
        :type RTMPSettings: :class:`tencentcloud.mps.v20190612.models.CreateOutputRTMPSettings`
        :param _AllowIpList: IP白名单列表，格式为CIDR，如0.0.0.0/0。
当Protocol为RTMP_PULL有效，为空代表不限制客户端IP。
        :type AllowIpList: list of str
        :param _MaxConcurrent: 最大拉流并发数，最大4，默认4。
        :type MaxConcurrent: int
        :param _SecurityGroupIds: 绑定的安全组 ID。 仅支持关联一组安全组。	
        :type SecurityGroupIds: list of str
        """
        self._OutputId = None
        self._OutputName = None
        self._Description = None
        self._Protocol = None
        self._SRTSettings = None
        self._RTPSettings = None
        self._RTMPSettings = None
        self._AllowIpList = None
        self._MaxConcurrent = None
        self._SecurityGroupIds = None

    @property
    def OutputId(self):
        return self._OutputId

    @OutputId.setter
    def OutputId(self, OutputId):
        self._OutputId = OutputId

    @property
    def OutputName(self):
        return self._OutputName

    @OutputName.setter
    def OutputName(self, OutputName):
        self._OutputName = OutputName

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Protocol(self):
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def SRTSettings(self):
        return self._SRTSettings

    @SRTSettings.setter
    def SRTSettings(self, SRTSettings):
        self._SRTSettings = SRTSettings

    @property
    def RTPSettings(self):
        return self._RTPSettings

    @RTPSettings.setter
    def RTPSettings(self, RTPSettings):
        self._RTPSettings = RTPSettings

    @property
    def RTMPSettings(self):
        return self._RTMPSettings

    @RTMPSettings.setter
    def RTMPSettings(self, RTMPSettings):
        self._RTMPSettings = RTMPSettings

    @property
    def AllowIpList(self):
        return self._AllowIpList

    @AllowIpList.setter
    def AllowIpList(self, AllowIpList):
        self._AllowIpList = AllowIpList

    @property
    def MaxConcurrent(self):
        return self._MaxConcurrent

    @MaxConcurrent.setter
    def MaxConcurrent(self, MaxConcurrent):
        self._MaxConcurrent = MaxConcurrent

    @property
    def SecurityGroupIds(self):
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds


    def _deserialize(self, params):
        self._OutputId = params.get("OutputId")
        self._OutputName = params.get("OutputName")
        self._Description = params.get("Description")
        self._Protocol = params.get("Protocol")
        if params.get("SRTSettings") is not None:
            self._SRTSettings = CreateOutputSRTSettings()
            self._SRTSettings._deserialize(params.get("SRTSettings"))
        if params.get("RTPSettings") is not None:
            self._RTPSettings = CreateOutputInfoRTPSettings()
            self._RTPSettings._deserialize(params.get("RTPSettings"))
        if params.get("RTMPSettings") is not None:
            self._RTMPSettings = CreateOutputRTMPSettings()
            self._RTMPSettings._deserialize(params.get("RTMPSettings"))
        self._AllowIpList = params.get("AllowIpList")
        self._MaxConcurrent = params.get("MaxConcurrent")
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyPersonSampleRequest(AbstractModel):
    """ModifyPersonSample请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PersonId: 素材 ID。
        :type PersonId: str
        :param _Name: 名称，长度限制：128 个字符。
        :type Name: str
        :param _Description: 描述，长度限制：1024 个字符。
        :type Description: str
        :param _Usages: 素材应用场景，可选值：
1. Recognition：用于内容识别，等价于 Recognition.Face。
2. Review：用于不适宜的内容识别，等价于 Review.Face。
3. All：用于内容识别、不适宜的内容识别，等价于 1+2。
        :type Usages: list of str
        :param _FaceOperationInfo: 五官操作信息。
        :type FaceOperationInfo: :class:`tencentcloud.mps.v20190612.models.AiSampleFaceOperation`
        :param _TagOperationInfo: 标签操作信息。
        :type TagOperationInfo: :class:`tencentcloud.mps.v20190612.models.AiSampleTagOperation`
        """
        self._PersonId = None
        self._Name = None
        self._Description = None
        self._Usages = None
        self._FaceOperationInfo = None
        self._TagOperationInfo = None

    @property
    def PersonId(self):
        return self._PersonId

    @PersonId.setter
    def PersonId(self, PersonId):
        self._PersonId = PersonId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Usages(self):
        return self._Usages

    @Usages.setter
    def Usages(self, Usages):
        self._Usages = Usages

    @property
    def FaceOperationInfo(self):
        return self._FaceOperationInfo

    @FaceOperationInfo.setter
    def FaceOperationInfo(self, FaceOperationInfo):
        self._FaceOperationInfo = FaceOperationInfo

    @property
    def TagOperationInfo(self):
        return self._TagOperationInfo

    @TagOperationInfo.setter
    def TagOperationInfo(self, TagOperationInfo):
        self._TagOperationInfo = TagOperationInfo


    def _deserialize(self, params):
        self._PersonId = params.get("PersonId")
        self._Name = params.get("Name")
        self._Description = params.get("Description")
        self._Usages = params.get("Usages")
        if params.get("FaceOperationInfo") is not None:
            self._FaceOperationInfo = AiSampleFaceOperation()
            self._FaceOperationInfo._deserialize(params.get("FaceOperationInfo"))
        if params.get("TagOperationInfo") is not None:
            self._TagOperationInfo = AiSampleTagOperation()
            self._TagOperationInfo._deserialize(params.get("TagOperationInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyPersonSampleResponse(AbstractModel):
    """ModifyPersonSample返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Person: 素材信息。
        :type Person: :class:`tencentcloud.mps.v20190612.models.AiSamplePerson`
        :param _FailFaceInfoSet: 处理失败的五官信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type FailFaceInfoSet: list of AiSampleFailFaceInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Person = None
        self._FailFaceInfoSet = None
        self._RequestId = None

    @property
    def Person(self):
        return self._Person

    @Person.setter
    def Person(self, Person):
        self._Person = Person

    @property
    def FailFaceInfoSet(self):
        return self._FailFaceInfoSet

    @FailFaceInfoSet.setter
    def FailFaceInfoSet(self, FailFaceInfoSet):
        self._FailFaceInfoSet = FailFaceInfoSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Person") is not None:
            self._Person = AiSamplePerson()
            self._Person._deserialize(params.get("Person"))
        if params.get("FailFaceInfoSet") is not None:
            self._FailFaceInfoSet = []
            for item in params.get("FailFaceInfoSet"):
                obj = AiSampleFailFaceInfo()
                obj._deserialize(item)
                self._FailFaceInfoSet.append(obj)
        self._RequestId = params.get("RequestId")


class ModifyQualityControlTemplateRequest(AbstractModel):
    """ModifyQualityControlTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 媒体质检模板唯一标识。
        :type Definition: int
        :param _Name: 媒体质检模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Comment: 模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _QualityControlItemSet: 媒体质检配置参数。
        :type QualityControlItemSet: list of QualityControlItemConfig
        """
        self._Definition = None
        self._Name = None
        self._Comment = None
        self._QualityControlItemSet = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def QualityControlItemSet(self):
        return self._QualityControlItemSet

    @QualityControlItemSet.setter
    def QualityControlItemSet(self, QualityControlItemSet):
        self._QualityControlItemSet = QualityControlItemSet


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("QualityControlItemSet") is not None:
            self._QualityControlItemSet = []
            for item in params.get("QualityControlItemSet"):
                obj = QualityControlItemConfig()
                obj._deserialize(item)
                self._QualityControlItemSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyQualityControlTemplateResponse(AbstractModel):
    """ModifyQualityControlTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifySampleSnapshotTemplateRequest(AbstractModel):
    """ModifySampleSnapshotTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 采样截图模板唯一标识。
        :type Definition: int
        :param _Name: 采样截图模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Width: 截图宽度（或长边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :type Width: int
        :param _Height: 截图高度（或短边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :type Height: int
        :param _ResolutionAdaptive: 分辨率自适应，可选值：
<li>open：开启，此时，Width 代表视频的长边，Height 表示视频的短边；</li>
<li>close：关闭，此时，Width 代表视频的宽度，Height 表示视频的高度。</li>
默认值：open。
        :type ResolutionAdaptive: str
        :param _SampleType: 采样截图类型，取值：
<li>Percent：按百分比。</li>
<li>Time：按时间间隔。</li>
        :type SampleType: str
        :param _SampleInterval: 采样间隔。
<li>当 SampleType 为 Percent 时，指定采样间隔的百分比。</li>
<li>当 SampleType 为 Time 时，指定采样间隔的时间，单位为秒。</li>
        :type SampleInterval: int
        :param _Format: 图片格式，取值为 jpg、png、webp。
        :type Format: str
        :param _Comment: 模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _FillType: 填充方式，当视频流配置宽高参数与原始视频的宽高比不一致时，对转码的处理方式，即为“填充”。可选填充方式：
<li> stretch：拉伸，对每一帧进行拉伸，填满整个画面，可能导致转码后的视频被“压扁“或者“拉长“；</li>
<li>black：留黑，保持视频宽高比不变，边缘剩余部分使用黑色填充。</li>
<li>white：留白，保持视频宽高比不变，边缘剩余部分使用白色填充。</li>
<li>gauss：高斯模糊，保持视频宽高比不变，边缘剩余部分使用高斯模糊。</li>
默认值：black 。
        :type FillType: str
        """
        self._Definition = None
        self._Name = None
        self._Width = None
        self._Height = None
        self._ResolutionAdaptive = None
        self._SampleType = None
        self._SampleInterval = None
        self._Format = None
        self._Comment = None
        self._FillType = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ResolutionAdaptive(self):
        return self._ResolutionAdaptive

    @ResolutionAdaptive.setter
    def ResolutionAdaptive(self, ResolutionAdaptive):
        self._ResolutionAdaptive = ResolutionAdaptive

    @property
    def SampleType(self):
        return self._SampleType

    @SampleType.setter
    def SampleType(self, SampleType):
        self._SampleType = SampleType

    @property
    def SampleInterval(self):
        return self._SampleInterval

    @SampleInterval.setter
    def SampleInterval(self, SampleInterval):
        self._SampleInterval = SampleInterval

    @property
    def Format(self):
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def FillType(self):
        return self._FillType

    @FillType.setter
    def FillType(self, FillType):
        self._FillType = FillType


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Name = params.get("Name")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._ResolutionAdaptive = params.get("ResolutionAdaptive")
        self._SampleType = params.get("SampleType")
        self._SampleInterval = params.get("SampleInterval")
        self._Format = params.get("Format")
        self._Comment = params.get("Comment")
        self._FillType = params.get("FillType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifySampleSnapshotTemplateResponse(AbstractModel):
    """ModifySampleSnapshotTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyScheduleRequest(AbstractModel):
    """ModifySchedule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ScheduleId: 编排唯一标识。
        :type ScheduleId: int
        :param _ScheduleName: 编排名称。
        :type ScheduleName: str
        :param _Trigger: 编排绑定的触发规则。
        :type Trigger: :class:`tencentcloud.mps.v20190612.models.WorkflowTrigger`
        :param _Activities: 编排任务列表。
注意：内部不允许部分更新，如果需要更新需全量提交编排任务列表。
        :type Activities: list of Activity
        :param _OutputStorage: 媒体处理的文件输出存储位置。
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _OutputDir: 媒体处理生成的文件输出的目标目录，必选以 / 开头和结尾。
注意：如果设置为空，则表示取消老配置的OutputDir值。
        :type OutputDir: str
        :param _TaskNotifyConfig: 任务的事件通知配置。
        :type TaskNotifyConfig: :class:`tencentcloud.mps.v20190612.models.TaskNotifyConfig`
        :param _ResourceId: 资源ID，需要保证对应资源是开启状态。
        :type ResourceId: str
        """
        self._ScheduleId = None
        self._ScheduleName = None
        self._Trigger = None
        self._Activities = None
        self._OutputStorage = None
        self._OutputDir = None
        self._TaskNotifyConfig = None
        self._ResourceId = None

    @property
    def ScheduleId(self):
        return self._ScheduleId

    @ScheduleId.setter
    def ScheduleId(self, ScheduleId):
        self._ScheduleId = ScheduleId

    @property
    def ScheduleName(self):
        return self._ScheduleName

    @ScheduleName.setter
    def ScheduleName(self, ScheduleName):
        self._ScheduleName = ScheduleName

    @property
    def Trigger(self):
        return self._Trigger

    @Trigger.setter
    def Trigger(self, Trigger):
        self._Trigger = Trigger

    @property
    def Activities(self):
        return self._Activities

    @Activities.setter
    def Activities(self, Activities):
        self._Activities = Activities

    @property
    def OutputStorage(self):
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage

    @property
    def OutputDir(self):
        return self._OutputDir

    @OutputDir.setter
    def OutputDir(self, OutputDir):
        self._OutputDir = OutputDir

    @property
    def TaskNotifyConfig(self):
        return self._TaskNotifyConfig

    @TaskNotifyConfig.setter
    def TaskNotifyConfig(self, TaskNotifyConfig):
        self._TaskNotifyConfig = TaskNotifyConfig

    @property
    def ResourceId(self):
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId


    def _deserialize(self, params):
        self._ScheduleId = params.get("ScheduleId")
        self._ScheduleName = params.get("ScheduleName")
        if params.get("Trigger") is not None:
            self._Trigger = WorkflowTrigger()
            self._Trigger._deserialize(params.get("Trigger"))
        if params.get("Activities") is not None:
            self._Activities = []
            for item in params.get("Activities"):
                obj = Activity()
                obj._deserialize(item)
                self._Activities.append(obj)
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        self._OutputDir = params.get("OutputDir")
        if params.get("TaskNotifyConfig") is not None:
            self._TaskNotifyConfig = TaskNotifyConfig()
            self._TaskNotifyConfig._deserialize(params.get("TaskNotifyConfig"))
        self._ResourceId = params.get("ResourceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyScheduleResponse(AbstractModel):
    """ModifySchedule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifySnapshotByTimeOffsetTemplateRequest(AbstractModel):
    """ModifySnapshotByTimeOffsetTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 指定时间点截图模板唯一标识。
        :type Definition: int
        :param _Name: 指定时间点截图模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Width: 截图宽度（或长边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :type Width: int
        :param _Height: 截图高度（或短边）的最大值，取值范围：0 和 [128, 4096]，单位：px。
<li>当 Width、Height 均为 0，则分辨率同源；</li>
<li>当 Width 为 0，Height 非 0，则 Width 按比例缩放；</li>
<li>当 Width 非 0，Height 为 0，则 Height 按比例缩放；</li>
<li>当 Width、Height 均非 0，则分辨率按用户指定。</li>
默认值：0。
        :type Height: int
        :param _ResolutionAdaptive: 分辨率自适应，可选值：
<li>open：开启，此时，Width 代表视频的长边，Height 表示视频的短边；</li>
<li>close：关闭，此时，Width 代表视频的宽度，Height 表示视频的高度。</li>
默认值：open。
        :type ResolutionAdaptive: str
        :param _Format: 图片格式，取值可以为 jpg、png、webp。
        :type Format: str
        :param _Comment: 模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _FillType: 填充方式，当视频流配置宽高参数与原始视频的宽高比不一致时，对转码的处理方式，即为“填充”。可选填充方式：
<li> stretch：拉伸，对每一帧进行拉伸，填满整个画面，可能导致转码后的视频被“压扁“或者“拉长“；</li>
<li>black：留黑，保持视频宽高比不变，边缘剩余部分使用黑色填充。</li>
<li>white：留白，保持视频宽高比不变，边缘剩余部分使用白色填充。</li>
<li>gauss：高斯模糊，保持视频宽高比不变，边缘剩余部分使用高斯模糊。</li>
默认值：black 。
        :type FillType: str
        """
        self._Definition = None
        self._Name = None
        self._Width = None
        self._Height = None
        self._ResolutionAdaptive = None
        self._Format = None
        self._Comment = None
        self._FillType = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ResolutionAdaptive(self):
        return self._ResolutionAdaptive

    @ResolutionAdaptive.setter
    def ResolutionAdaptive(self, ResolutionAdaptive):
        self._ResolutionAdaptive = ResolutionAdaptive

    @property
    def Format(self):
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def FillType(self):
        return self._FillType

    @FillType.setter
    def FillType(self, FillType):
        self._FillType = FillType


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Name = params.get("Name")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._ResolutionAdaptive = params.get("ResolutionAdaptive")
        self._Format = params.get("Format")
        self._Comment = params.get("Comment")
        self._FillType = params.get("FillType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifySnapshotByTimeOffsetTemplateResponse(AbstractModel):
    """ModifySnapshotByTimeOffsetTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyStreamLinkEventRequest(AbstractModel):
    """ModifyStreamLinkEvent请求参数结构体

    """

    def __init__(self):
        r"""
        :param _EventId: 媒体传输事件Event Id。
        :type EventId: str
        :param _EventName: 需要修改的事件名称。
        :type EventName: str
        :param _Description: Event的描述信息。
        :type Description: str
        """
        self._EventId = None
        self._EventName = None
        self._Description = None

    @property
    def EventId(self):
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId

    @property
    def EventName(self):
        return self._EventName

    @EventName.setter
    def EventName(self, EventName):
        self._EventName = EventName

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._EventId = params.get("EventId")
        self._EventName = params.get("EventName")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyStreamLinkEventResponse(AbstractModel):
    """ModifyStreamLinkEvent返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyStreamLinkFlowRequest(AbstractModel):
    """ModifyStreamLinkFlow请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FlowId: 流Id。
        :type FlowId: str
        :param _FlowName: 需要修改的流名称。
        :type FlowName: str
        """
        self._FlowId = None
        self._FlowName = None

    @property
    def FlowId(self):
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def FlowName(self):
        return self._FlowName

    @FlowName.setter
    def FlowName(self, FlowName):
        self._FlowName = FlowName


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        self._FlowName = params.get("FlowName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyStreamLinkFlowResponse(AbstractModel):
    """ModifyStreamLinkFlow返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyStreamLinkInputRequest(AbstractModel):
    """ModifyStreamLinkInput请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FlowId: 流Id。
        :type FlowId: str
        :param _Input: 需要修改的Input信息。
        :type Input: :class:`tencentcloud.mps.v20190612.models.ModifyInput`
        """
        self._FlowId = None
        self._Input = None

    @property
    def FlowId(self):
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        if params.get("Input") is not None:
            self._Input = ModifyInput()
            self._Input._deserialize(params.get("Input"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyStreamLinkInputResponse(AbstractModel):
    """ModifyStreamLinkInput返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Info: 修改后的Input信息。
        :type Info: :class:`tencentcloud.mps.v20190612.models.DescribeInput`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Info = None
        self._RequestId = None

    @property
    def Info(self):
        return self._Info

    @Info.setter
    def Info(self, Info):
        self._Info = Info

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Info") is not None:
            self._Info = DescribeInput()
            self._Info._deserialize(params.get("Info"))
        self._RequestId = params.get("RequestId")


class ModifyStreamLinkOutputInfoRequest(AbstractModel):
    """ModifyStreamLinkOutputInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FlowId: 流Id。
        :type FlowId: str
        :param _Output: 需要修改的Output配置。
        :type Output: :class:`tencentcloud.mps.v20190612.models.ModifyOutputInfo`
        """
        self._FlowId = None
        self._Output = None

    @property
    def FlowId(self):
        return self._FlowId

    @FlowId.setter
    def FlowId(self, FlowId):
        self._FlowId = FlowId

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._FlowId = params.get("FlowId")
        if params.get("Output") is not None:
            self._Output = ModifyOutputInfo()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyStreamLinkOutputInfoResponse(AbstractModel):
    """ModifyStreamLinkOutputInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Info: 修改后的Output配置。
        :type Info: :class:`tencentcloud.mps.v20190612.models.DescribeOutput`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Info = None
        self._RequestId = None

    @property
    def Info(self):
        return self._Info

    @Info.setter
    def Info(self, Info):
        self._Info = Info

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Info") is not None:
            self._Info = DescribeOutput()
            self._Info._deserialize(params.get("Info"))
        self._RequestId = params.get("RequestId")


class ModifyTranscodeTemplateRequest(AbstractModel):
    """ModifyTranscodeTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 转码模板唯一标识。
        :type Definition: int
        :param _Container: 封装格式，可选值：mp4、flv、hls、mp3、flac、ogg、m4a。其中，mp3、flac、ogg、m4a 为纯音频文件。
        :type Container: str
        :param _Name: 转码模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Comment: 模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _RemoveVideo: 是否去除视频数据，可选值：
<li>0：保留</li>
<li>1：去除</li>
        :type RemoveVideo: int
        :param _RemoveAudio: 是否去除音频数据，可选值：
<li>0：保留</li>
<li>1：去除</li>
        :type RemoveAudio: int
        :param _VideoTemplate: 视频流配置参数。
        :type VideoTemplate: :class:`tencentcloud.mps.v20190612.models.VideoTemplateInfoForUpdate`
        :param _AudioTemplate: 音频流配置参数。
        :type AudioTemplate: :class:`tencentcloud.mps.v20190612.models.AudioTemplateInfoForUpdate`
        :param _TEHDConfig: 极速高清转码参数。
        :type TEHDConfig: :class:`tencentcloud.mps.v20190612.models.TEHDConfigForUpdate`
        :param _EnhanceConfig: 音视频增强参数。
        :type EnhanceConfig: :class:`tencentcloud.mps.v20190612.models.EnhanceConfig`
        """
        self._Definition = None
        self._Container = None
        self._Name = None
        self._Comment = None
        self._RemoveVideo = None
        self._RemoveAudio = None
        self._VideoTemplate = None
        self._AudioTemplate = None
        self._TEHDConfig = None
        self._EnhanceConfig = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Container(self):
        return self._Container

    @Container.setter
    def Container(self, Container):
        self._Container = Container

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def RemoveVideo(self):
        return self._RemoveVideo

    @RemoveVideo.setter
    def RemoveVideo(self, RemoveVideo):
        self._RemoveVideo = RemoveVideo

    @property
    def RemoveAudio(self):
        return self._RemoveAudio

    @RemoveAudio.setter
    def RemoveAudio(self, RemoveAudio):
        self._RemoveAudio = RemoveAudio

    @property
    def VideoTemplate(self):
        return self._VideoTemplate

    @VideoTemplate.setter
    def VideoTemplate(self, VideoTemplate):
        self._VideoTemplate = VideoTemplate

    @property
    def AudioTemplate(self):
        return self._AudioTemplate

    @AudioTemplate.setter
    def AudioTemplate(self, AudioTemplate):
        self._AudioTemplate = AudioTemplate

    @property
    def TEHDConfig(self):
        return self._TEHDConfig

    @TEHDConfig.setter
    def TEHDConfig(self, TEHDConfig):
        self._TEHDConfig = TEHDConfig

    @property
    def EnhanceConfig(self):
        return self._EnhanceConfig

    @EnhanceConfig.setter
    def EnhanceConfig(self, EnhanceConfig):
        self._EnhanceConfig = EnhanceConfig


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Container = params.get("Container")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        self._RemoveVideo = params.get("RemoveVideo")
        self._RemoveAudio = params.get("RemoveAudio")
        if params.get("VideoTemplate") is not None:
            self._VideoTemplate = VideoTemplateInfoForUpdate()
            self._VideoTemplate._deserialize(params.get("VideoTemplate"))
        if params.get("AudioTemplate") is not None:
            self._AudioTemplate = AudioTemplateInfoForUpdate()
            self._AudioTemplate._deserialize(params.get("AudioTemplate"))
        if params.get("TEHDConfig") is not None:
            self._TEHDConfig = TEHDConfigForUpdate()
            self._TEHDConfig._deserialize(params.get("TEHDConfig"))
        if params.get("EnhanceConfig") is not None:
            self._EnhanceConfig = EnhanceConfig()
            self._EnhanceConfig._deserialize(params.get("EnhanceConfig"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyTranscodeTemplateResponse(AbstractModel):
    """ModifyTranscodeTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyWatermarkTemplateRequest(AbstractModel):
    """ModifyWatermarkTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Definition: 水印模板唯一标识。
        :type Definition: int
        :param _Name: 水印模板名称，长度限制：64 个字符。
        :type Name: str
        :param _Comment: 模板描述信息，长度限制：256 个字符。
        :type Comment: str
        :param _CoordinateOrigin: 原点位置，可选值：
<li>TopLeft：表示坐标原点位于视频图像左上角，水印原点为图片或文字的左上角；</li>
<li>TopRight：表示坐标原点位于视频图像的右上角，水印原点为图片或文字的右上角；</li>
<li>BottomLeft：表示坐标原点位于视频图像的左下角，水印原点为图片或文字的左下角；</li>
<li>BottomRight：表示坐标原点位于视频图像的右下角，水印原点为图片或文字的右下角。</li>
        :type CoordinateOrigin: str
        :param _XPos: 水印原点距离视频图像坐标原点的水平位置。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示水印 XPos 为视频宽度指定百分比，如 10% 表示 XPos 为视频宽度的 10%；</li>
<li>当字符串以 px 结尾，表示水印 XPos 为指定像素，如 100px 表示 XPos 为 100 像素。</li>
        :type XPos: str
        :param _YPos: 水印原点距离视频图像坐标原点的垂直位置。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示水印 YPos 为视频高度指定百分比，如 10% 表示 YPos 为视频高度的 10%；</li>
<li>当字符串以 px 结尾，表示水印 YPos 为指定像素，如 100px 表示 YPos 为 100 像素。</li>
        :type YPos: str
        :param _ImageTemplate: 图片水印模板，该字段仅对图片水印模板有效。
        :type ImageTemplate: :class:`tencentcloud.mps.v20190612.models.ImageWatermarkInputForUpdate`
        :param _TextTemplate: 文字水印模板，该字段仅对文字水印模板有效。
        :type TextTemplate: :class:`tencentcloud.mps.v20190612.models.TextWatermarkTemplateInputForUpdate`
        :param _SvgTemplate: SVG水印模板，当 Type 为 svg，该字段必填。当 Type 为 image 或 text，该字段无效。
        :type SvgTemplate: :class:`tencentcloud.mps.v20190612.models.SvgWatermarkInputForUpdate`
        """
        self._Definition = None
        self._Name = None
        self._Comment = None
        self._CoordinateOrigin = None
        self._XPos = None
        self._YPos = None
        self._ImageTemplate = None
        self._TextTemplate = None
        self._SvgTemplate = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def CoordinateOrigin(self):
        return self._CoordinateOrigin

    @CoordinateOrigin.setter
    def CoordinateOrigin(self, CoordinateOrigin):
        self._CoordinateOrigin = CoordinateOrigin

    @property
    def XPos(self):
        return self._XPos

    @XPos.setter
    def XPos(self, XPos):
        self._XPos = XPos

    @property
    def YPos(self):
        return self._YPos

    @YPos.setter
    def YPos(self, YPos):
        self._YPos = YPos

    @property
    def ImageTemplate(self):
        return self._ImageTemplate

    @ImageTemplate.setter
    def ImageTemplate(self, ImageTemplate):
        self._ImageTemplate = ImageTemplate

    @property
    def TextTemplate(self):
        return self._TextTemplate

    @TextTemplate.setter
    def TextTemplate(self, TextTemplate):
        self._TextTemplate = TextTemplate

    @property
    def SvgTemplate(self):
        return self._SvgTemplate

    @SvgTemplate.setter
    def SvgTemplate(self, SvgTemplate):
        self._SvgTemplate = SvgTemplate


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        self._CoordinateOrigin = params.get("CoordinateOrigin")
        self._XPos = params.get("XPos")
        self._YPos = params.get("YPos")
        if params.get("ImageTemplate") is not None:
            self._ImageTemplate = ImageWatermarkInputForUpdate()
            self._ImageTemplate._deserialize(params.get("ImageTemplate"))
        if params.get("TextTemplate") is not None:
            self._TextTemplate = TextWatermarkTemplateInputForUpdate()
            self._TextTemplate._deserialize(params.get("TextTemplate"))
        if params.get("SvgTemplate") is not None:
            self._SvgTemplate = SvgWatermarkInputForUpdate()
            self._SvgTemplate._deserialize(params.get("SvgTemplate"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyWatermarkTemplateResponse(AbstractModel):
    """ModifyWatermarkTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ImageUrl: 图片水印地址，仅当 ImageTemplate.ImageContent 非空，该字段有效。
        :type ImageUrl: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ImageUrl = None
        self._RequestId = None

    @property
    def ImageUrl(self):
        return self._ImageUrl

    @ImageUrl.setter
    def ImageUrl(self, ImageUrl):
        self._ImageUrl = ImageUrl

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ImageUrl = params.get("ImageUrl")
        self._RequestId = params.get("RequestId")


class ModifyWordSampleRequest(AbstractModel):
    """ModifyWordSample请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Keyword: 关键词，长度限制：128 个字符。
        :type Keyword: str
        :param _Usages: <b>关键词应用场景，可选值：</b>
1. Recognition.Ocr：通过光学字符识别技术，进行内容识别；
2. Recognition.Asr：通过音频识别技术，进行内容识别；
3. Review.Ocr：通过光学字符识别技术，进行不适宜的内容识别；
4. Review.Asr：通过音频识别技术，进行不适宜的音频识别；
<b>可合并简写为：</b>
5. Recognition：通过光学字符识别技术、音频识别技术，进行内容识别，等价于 1+2；
6. Review：通过光学字符识别技术、音频识别技术，进行不适宜的内容识别，等价于 3+4；
7. All：包含以上全部，等价于 1+2+3+4。
        :type Usages: list of str
        :param _TagOperationInfo: 标签操作信息。
        :type TagOperationInfo: :class:`tencentcloud.mps.v20190612.models.AiSampleTagOperation`
        """
        self._Keyword = None
        self._Usages = None
        self._TagOperationInfo = None

    @property
    def Keyword(self):
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword

    @property
    def Usages(self):
        return self._Usages

    @Usages.setter
    def Usages(self, Usages):
        self._Usages = Usages

    @property
    def TagOperationInfo(self):
        return self._TagOperationInfo

    @TagOperationInfo.setter
    def TagOperationInfo(self, TagOperationInfo):
        self._TagOperationInfo = TagOperationInfo


    def _deserialize(self, params):
        self._Keyword = params.get("Keyword")
        self._Usages = params.get("Usages")
        if params.get("TagOperationInfo") is not None:
            self._TagOperationInfo = AiSampleTagOperation()
            self._TagOperationInfo._deserialize(params.get("TagOperationInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyWordSampleResponse(AbstractModel):
    """ModifyWordSample返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class MosaicInput(AbstractModel):
    """媒体处理任务中的马赛克参数类型

    """

    def __init__(self):
        r"""
        :param _CoordinateOrigin: 原点位置，目前仅支持：
<li>TopLeft：表示坐标原点位于视频图像左上角，马赛克原点为图片或文字的左上角。</li>
默认值：TopLeft。
        :type CoordinateOrigin: str
        :param _XPos: 马赛克原点距离视频图像坐标原点的水平位置。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示马赛克 XPos 为视频宽度指定百分比，如 10% 表示 XPos 为视频宽度的 10%；</li>
<li>当字符串以 px 结尾，表示马赛克 XPos 为指定像素，如 100px 表示 XPos 为 100 像素。</li>
默认值：0px。
        :type XPos: str
        :param _YPos: 马赛克原点距离视频图像坐标原点的垂直位置。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示马赛克 YPos 为视频高度指定百分比，如 10% 表示 YPos 为视频高度的 10%；</li>
<li>当字符串以 px 结尾，表示马赛克 YPos 为指定像素，如 100px 表示 YPos 为 100 像素。</li>
默认值：0px。
        :type YPos: str
        :param _Width: 马赛克的宽度。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示马赛克 Width 为视频宽度的百分比大小，如 10% 表示 Width 为视频宽度的 10%；</li>
<li>当字符串以 px 结尾，表示马赛克 Width 单位为像素，如 100px 表示 Width 为 100 像素。</li>
默认值：10%。
        :type Width: str
        :param _Height: 马赛克的高度。支持 %、px 两种格式：
<li>当字符串以 % 结尾，表示马赛克 Height 为视频高度的百分比大小，如 10% 表示 Height 为视频高度的 10%；</li>
<li>当字符串以 px 结尾，表示马赛克 Height 单位为像素，如 100px 表示 Height 为 100 像素。</li>
默认值：10%。
        :type Height: str
        :param _StartTimeOffset: 马赛克的起始时间偏移，单位：秒。不填或填0，表示马赛克从画面出现时开始显现。
<li>不填或填0，表示马赛克从画面开始就出现；</li>
<li>当数值大于0时（假设为 n），表示马赛克从画面开始的第 n 秒出现；</li>
<li>当数值小于0时（假设为 -n），表示马赛克从离画面结束 n 秒前开始出现。</li>
        :type StartTimeOffset: float
        :param _EndTimeOffset: 马赛克的结束时间偏移，单位：秒。
<li>不填或填0，表示马赛克持续到画面结束；</li>
<li>当数值大于0时（假设为 n），表示马赛克持续到第 n 秒时消失；</li>
<li>当数值小于0时（假设为 -n），表示马赛克持续到离画面结束 n 秒前消失。</li>
        :type EndTimeOffset: float
        """
        self._CoordinateOrigin = None
        self._XPos = None
        self._YPos = None
        self._Width = None
        self._Height = None
        self._StartTimeOffset = None
        self._EndTimeOffset = None

    @property
    def CoordinateOrigin(self):
        return self._CoordinateOrigin

    @CoordinateOrigin.setter
    def CoordinateOrigin(self, CoordinateOrigin):
        self._CoordinateOrigin = CoordinateOrigin

    @property
    def XPos(self):
        return self._XPos

    @XPos.setter
    def XPos(self, XPos):
        self._XPos = XPos

    @property
    def YPos(self):
        return self._YPos

    @YPos.setter
    def YPos(self, YPos):
        self._YPos = YPos

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def StartTimeOffset(self):
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset


    def _deserialize(self, params):
        self._CoordinateOrigin = params.get("CoordinateOrigin")
        self._XPos = params.get("XPos")
        self._YPos = params.get("YPos")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NumberFormat(AbstractModel):
    """输出文件名的`{number}`变量的规则。

    """

    def __init__(self):
        r"""
        :param _InitialValue: `{number}`变量的起始值，默认为0。
        :type InitialValue: int
        :param _Increment: `{number}`变量的增长步长，默认为1。
        :type Increment: int
        :param _MinLength: `{number}`变量的最小长度，不足时补占位符。默认为1。
        :type MinLength: int
        :param _PlaceHolder: `{number}`变量的长度不足时，补充的占位符。默认为"0"。
        :type PlaceHolder: str
        """
        self._InitialValue = None
        self._Increment = None
        self._MinLength = None
        self._PlaceHolder = None

    @property
    def InitialValue(self):
        return self._InitialValue

    @InitialValue.setter
    def InitialValue(self, InitialValue):
        self._InitialValue = InitialValue

    @property
    def Increment(self):
        return self._Increment

    @Increment.setter
    def Increment(self, Increment):
        self._Increment = Increment

    @property
    def MinLength(self):
        return self._MinLength

    @MinLength.setter
    def MinLength(self, MinLength):
        self._MinLength = MinLength

    @property
    def PlaceHolder(self):
        return self._PlaceHolder

    @PlaceHolder.setter
    def PlaceHolder(self, PlaceHolder):
        self._PlaceHolder = PlaceHolder


    def _deserialize(self, params):
        self._InitialValue = params.get("InitialValue")
        self._Increment = params.get("Increment")
        self._MinLength = params.get("MinLength")
        self._PlaceHolder = params.get("PlaceHolder")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OcrFullTextConfigureInfo(AbstractModel):
    """文本全文本识别任务控制参数

    """

    def __init__(self):
        r"""
        :param _Switch: 文本全文识别任务开关，可选值：
<li>ON：开启智能文本全文识别任务；</li>
<li>OFF：关闭智能文本全文识别任务。</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OcrFullTextConfigureInfoForUpdate(AbstractModel):
    """文本全文本识别任务控制参数

    """

    def __init__(self):
        r"""
        :param _Switch: 文本全文识别任务开关，可选值：
<li>ON：开启智能文本全文识别任务；</li>
<li>OFF：关闭智能文本全文识别任务。</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OcrWordsConfigureInfo(AbstractModel):
    """文本关键词识别控制参数。

    """

    def __init__(self):
        r"""
        :param _Switch: 文本关键词识别任务开关，可选值：
<li>ON：开启文本关键词识别任务；</li>
<li>OFF：关闭文本关键词识别任务。</li>
        :type Switch: str
        :param _LabelSet: 关键词过滤标签，指定需要返回的关键词的标签。如果未填或者为空，则全部结果都返回。
标签个数最多 10 个，每个标签长度最多 16 个字符。
        :type LabelSet: list of str
        """
        self._Switch = None
        self._LabelSet = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def LabelSet(self):
        return self._LabelSet

    @LabelSet.setter
    def LabelSet(self, LabelSet):
        self._LabelSet = LabelSet


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._LabelSet = params.get("LabelSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OcrWordsConfigureInfoForUpdate(AbstractModel):
    """文本关键词识别控制参数。

    """

    def __init__(self):
        r"""
        :param _Switch: 文本关键词识别任务开关，可选值：
<li>ON：开启文本关键词识别任务；</li>
<li>OFF：关闭文本关键词识别任务。</li>
        :type Switch: str
        :param _LabelSet: 关键词过滤标签，指定需要返回的关键词的标签。如果未填或者为空，则全部结果都返回。
标签个数最多 10 个，每个标签长度最多 16 个字符。
        :type LabelSet: list of str
        """
        self._Switch = None
        self._LabelSet = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def LabelSet(self):
        return self._LabelSet

    @LabelSet.setter
    def LabelSet(self, LabelSet):
        self._LabelSet = LabelSet


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._LabelSet = params.get("LabelSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OutputAddress(AbstractModel):
    """输出的出口的地址。

    """

    def __init__(self):
        r"""
        :param _Ip: 出口IP。
        :type Ip: str
        """
        self._Ip = None

    @property
    def Ip(self):
        return self._Ip

    @Ip.setter
    def Ip(self, Ip):
        self._Ip = Ip


    def _deserialize(self, params):
        self._Ip = params.get("Ip")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OutputSRTSourceAddressResp(AbstractModel):
    """SRT输出的监听地址。

    """

    def __init__(self):
        r"""
        :param _Ip: 监听IP。
注意：此字段可能返回 null，表示取不到有效值。
        :type Ip: str
        :param _Port: 监听端口。
注意：此字段可能返回 null，表示取不到有效值。
        :type Port: int
        """
        self._Ip = None
        self._Port = None

    @property
    def Ip(self):
        return self._Ip

    @Ip.setter
    def Ip(self, Ip):
        self._Ip = Ip

    @property
    def Port(self):
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port


    def _deserialize(self, params):
        self._Ip = params.get("Ip")
        self._Port = params.get("Port")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OverrideTranscodeParameter(AbstractModel):
    """自定义转码的规格参数。用于覆盖模板中对应参数值。

    """

    def __init__(self):
        r"""
        :param _Container: 封装格式，可选值：mp4、flv、hls、mp3、flac、ogg、m4a。其中，mp3、flac、ogg、m4a 为纯音频文件。
        :type Container: str
        :param _RemoveVideo: 是否去除视频数据，取值：
<li>0：保留；</li>
<li>1：去除。</li>
        :type RemoveVideo: int
        :param _RemoveAudio: 是否去除音频数据，取值：
<li>0：保留；</li>
<li>1：去除。</li>
        :type RemoveAudio: int
        :param _VideoTemplate: 视频流配置参数。
        :type VideoTemplate: :class:`tencentcloud.mps.v20190612.models.VideoTemplateInfoForUpdate`
        :param _AudioTemplate: 音频流配置参数。
        :type AudioTemplate: :class:`tencentcloud.mps.v20190612.models.AudioTemplateInfoForUpdate`
        :param _TEHDConfig: 极速高清转码参数。
注意：此字段可能返回 null，表示取不到有效值。
        :type TEHDConfig: :class:`tencentcloud.mps.v20190612.models.TEHDConfigForUpdate`
        :param _SubtitleTemplate: 字幕流配置参数。
注意：此字段可能返回 null，表示取不到有效值。
        :type SubtitleTemplate: :class:`tencentcloud.mps.v20190612.models.SubtitleTemplate`
        :param _AddonAudioStream: 外挂音轨参数。
注意：此字段可能返回 null，表示取不到有效值。
        :type AddonAudioStream: list of MediaInputInfo
        :param _StdExtInfo: 转码扩展字段。
注意：此字段可能返回 null，表示取不到有效值。
        :type StdExtInfo: str
        :param _AddOnSubtitles: 要插入的字幕文件。
注意：此字段可能返回 null，表示取不到有效值。
        :type AddOnSubtitles: list of AddOnSubtitle
        """
        self._Container = None
        self._RemoveVideo = None
        self._RemoveAudio = None
        self._VideoTemplate = None
        self._AudioTemplate = None
        self._TEHDConfig = None
        self._SubtitleTemplate = None
        self._AddonAudioStream = None
        self._StdExtInfo = None
        self._AddOnSubtitles = None

    @property
    def Container(self):
        return self._Container

    @Container.setter
    def Container(self, Container):
        self._Container = Container

    @property
    def RemoveVideo(self):
        return self._RemoveVideo

    @RemoveVideo.setter
    def RemoveVideo(self, RemoveVideo):
        self._RemoveVideo = RemoveVideo

    @property
    def RemoveAudio(self):
        return self._RemoveAudio

    @RemoveAudio.setter
    def RemoveAudio(self, RemoveAudio):
        self._RemoveAudio = RemoveAudio

    @property
    def VideoTemplate(self):
        return self._VideoTemplate

    @VideoTemplate.setter
    def VideoTemplate(self, VideoTemplate):
        self._VideoTemplate = VideoTemplate

    @property
    def AudioTemplate(self):
        return self._AudioTemplate

    @AudioTemplate.setter
    def AudioTemplate(self, AudioTemplate):
        self._AudioTemplate = AudioTemplate

    @property
    def TEHDConfig(self):
        return self._TEHDConfig

    @TEHDConfig.setter
    def TEHDConfig(self, TEHDConfig):
        self._TEHDConfig = TEHDConfig

    @property
    def SubtitleTemplate(self):
        return self._SubtitleTemplate

    @SubtitleTemplate.setter
    def SubtitleTemplate(self, SubtitleTemplate):
        self._SubtitleTemplate = SubtitleTemplate

    @property
    def AddonAudioStream(self):
        return self._AddonAudioStream

    @AddonAudioStream.setter
    def AddonAudioStream(self, AddonAudioStream):
        self._AddonAudioStream = AddonAudioStream

    @property
    def StdExtInfo(self):
        return self._StdExtInfo

    @StdExtInfo.setter
    def StdExtInfo(self, StdExtInfo):
        self._StdExtInfo = StdExtInfo

    @property
    def AddOnSubtitles(self):
        return self._AddOnSubtitles

    @AddOnSubtitles.setter
    def AddOnSubtitles(self, AddOnSubtitles):
        self._AddOnSubtitles = AddOnSubtitles


    def _deserialize(self, params):
        self._Container = params.get("Container")
        self._RemoveVideo = params.get("RemoveVideo")
        self._RemoveAudio = params.get("RemoveAudio")
        if params.get("VideoTemplate") is not None:
            self._VideoTemplate = VideoTemplateInfoForUpdate()
            self._VideoTemplate._deserialize(params.get("VideoTemplate"))
        if params.get("AudioTemplate") is not None:
            self._AudioTemplate = AudioTemplateInfoForUpdate()
            self._AudioTemplate._deserialize(params.get("AudioTemplate"))
        if params.get("TEHDConfig") is not None:
            self._TEHDConfig = TEHDConfigForUpdate()
            self._TEHDConfig._deserialize(params.get("TEHDConfig"))
        if params.get("SubtitleTemplate") is not None:
            self._SubtitleTemplate = SubtitleTemplate()
            self._SubtitleTemplate._deserialize(params.get("SubtitleTemplate"))
        if params.get("AddonAudioStream") is not None:
            self._AddonAudioStream = []
            for item in params.get("AddonAudioStream"):
                obj = MediaInputInfo()
                obj._deserialize(item)
                self._AddonAudioStream.append(obj)
        self._StdExtInfo = params.get("StdExtInfo")
        if params.get("AddOnSubtitles") is not None:
            self._AddOnSubtitles = []
            for item in params.get("AddOnSubtitles"):
                obj = AddOnSubtitle()
                obj._deserialize(item)
                self._AddOnSubtitles.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ParseLiveStreamProcessNotificationRequest(AbstractModel):
    """ParseLiveStreamProcessNotification请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Content: 从 CMQ 获取到的直播流事件通知内容。
        :type Content: str
        """
        self._Content = None

    @property
    def Content(self):
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content


    def _deserialize(self, params):
        self._Content = params.get("Content")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ParseLiveStreamProcessNotificationResponse(AbstractModel):
    """ParseLiveStreamProcessNotification返回参数结构体

    """

    def __init__(self):
        r"""
        :param _NotificationType: 直播流处理结果类型，包含：
<li>AiReviewResult：内容审核结果；</li>
<li>AiRecognitionResult：内容识别结果；</li>
<li>LiveRecordResult：直播录制结果；</li>
<li>ProcessEof：直播流处理结束。</li>
        :type NotificationType: str
        :param _TaskId: 视频处理任务 ID。
        :type TaskId: str
        :param _ProcessEofInfo: 直播流处理错误信息，当 NotificationType 为 ProcessEof 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type ProcessEofInfo: :class:`tencentcloud.mps.v20190612.models.LiveStreamProcessErrorInfo`
        :param _AiReviewResultInfo: 内容审核结果，当 NotificationType 为 AiReviewResult 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type AiReviewResultInfo: :class:`tencentcloud.mps.v20190612.models.LiveStreamAiReviewResultInfo`
        :param _AiRecognitionResultInfo: 内容识别结果，当 NotificationType 为 AiRecognitionResult 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type AiRecognitionResultInfo: :class:`tencentcloud.mps.v20190612.models.LiveStreamAiRecognitionResultInfo`
        :param _AiAnalysisResultInfo: 内容分析结果，当 NotificationType 为 AiAnalysisResult 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type AiAnalysisResultInfo: :class:`tencentcloud.mps.v20190612.models.LiveStreamAiAnalysisResultInfo`
        :param _AiQualityControlResultInfo: 媒体质检结果，当 NotificationType 为 AiQualityControlResult 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type AiQualityControlResultInfo: :class:`tencentcloud.mps.v20190612.models.LiveStreamAiQualityControlResultInfo`
        :param _LiveRecordResultInfo: 直播录制结果，当 NotificationType 为 LiveRecordResult 时有效。
注意：此字段可能返回 null，表示取不到有效值。
        :type LiveRecordResultInfo: :class:`tencentcloud.mps.v20190612.models.LiveStreamRecordResultInfo`
        :param _SessionId: 用于去重的识别码，如果七天内曾有过相同的识别码的请求，则本次的请求会返回错误。最长50个字符，不带或者带空字符串表示不做去重。
        :type SessionId: str
        :param _SessionContext: 来源上下文，用于透传用户请求信息，任务流状态变更回调将返回该字段值，最长1000个字符。
        :type SessionContext: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._NotificationType = None
        self._TaskId = None
        self._ProcessEofInfo = None
        self._AiReviewResultInfo = None
        self._AiRecognitionResultInfo = None
        self._AiAnalysisResultInfo = None
        self._AiQualityControlResultInfo = None
        self._LiveRecordResultInfo = None
        self._SessionId = None
        self._SessionContext = None
        self._RequestId = None

    @property
    def NotificationType(self):
        return self._NotificationType

    @NotificationType.setter
    def NotificationType(self, NotificationType):
        self._NotificationType = NotificationType

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ProcessEofInfo(self):
        return self._ProcessEofInfo

    @ProcessEofInfo.setter
    def ProcessEofInfo(self, ProcessEofInfo):
        self._ProcessEofInfo = ProcessEofInfo

    @property
    def AiReviewResultInfo(self):
        return self._AiReviewResultInfo

    @AiReviewResultInfo.setter
    def AiReviewResultInfo(self, AiReviewResultInfo):
        self._AiReviewResultInfo = AiReviewResultInfo

    @property
    def AiRecognitionResultInfo(self):
        return self._AiRecognitionResultInfo

    @AiRecognitionResultInfo.setter
    def AiRecognitionResultInfo(self, AiRecognitionResultInfo):
        self._AiRecognitionResultInfo = AiRecognitionResultInfo

    @property
    def AiAnalysisResultInfo(self):
        return self._AiAnalysisResultInfo

    @AiAnalysisResultInfo.setter
    def AiAnalysisResultInfo(self, AiAnalysisResultInfo):
        self._AiAnalysisResultInfo = AiAnalysisResultInfo

    @property
    def AiQualityControlResultInfo(self):
        return self._AiQualityControlResultInfo

    @AiQualityControlResultInfo.setter
    def AiQualityControlResultInfo(self, AiQualityControlResultInfo):
        self._AiQualityControlResultInfo = AiQualityControlResultInfo

    @property
    def LiveRecordResultInfo(self):
        return self._LiveRecordResultInfo

    @LiveRecordResultInfo.setter
    def LiveRecordResultInfo(self, LiveRecordResultInfo):
        self._LiveRecordResultInfo = LiveRecordResultInfo

    @property
    def SessionId(self):
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def SessionContext(self):
        return self._SessionContext

    @SessionContext.setter
    def SessionContext(self, SessionContext):
        self._SessionContext = SessionContext

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._NotificationType = params.get("NotificationType")
        self._TaskId = params.get("TaskId")
        if params.get("ProcessEofInfo") is not None:
            self._ProcessEofInfo = LiveStreamProcessErrorInfo()
            self._ProcessEofInfo._deserialize(params.get("ProcessEofInfo"))
        if params.get("AiReviewResultInfo") is not None:
            self._AiReviewResultInfo = LiveStreamAiReviewResultInfo()
            self._AiReviewResultInfo._deserialize(params.get("AiReviewResultInfo"))
        if params.get("AiRecognitionResultInfo") is not None:
            self._AiRecognitionResultInfo = LiveStreamAiRecognitionResultInfo()
            self._AiRecognitionResultInfo._deserialize(params.get("AiRecognitionResultInfo"))
        if params.get("AiAnalysisResultInfo") is not None:
            self._AiAnalysisResultInfo = LiveStreamAiAnalysisResultInfo()
            self._AiAnalysisResultInfo._deserialize(params.get("AiAnalysisResultInfo"))
        if params.get("AiQualityControlResultInfo") is not None:
            self._AiQualityControlResultInfo = LiveStreamAiQualityControlResultInfo()
            self._AiQualityControlResultInfo._deserialize(params.get("AiQualityControlResultInfo"))
        if params.get("LiveRecordResultInfo") is not None:
            self._LiveRecordResultInfo = LiveStreamRecordResultInfo()
            self._LiveRecordResultInfo._deserialize(params.get("LiveRecordResultInfo"))
        self._SessionId = params.get("SessionId")
        self._SessionContext = params.get("SessionContext")
        self._RequestId = params.get("RequestId")


class ParseNotificationRequest(AbstractModel):
    """ParseNotification请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Content: 从 CMQ 获取到的事件通知内容。
        :type Content: str
        """
        self._Content = None

    @property
    def Content(self):
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content


    def _deserialize(self, params):
        self._Content = params.get("Content")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ParseNotificationResponse(AbstractModel):
    """ParseNotification返回参数结构体

    """

    def __init__(self):
        r"""
        :param _EventType: 支持事件类型，目前取值有：
<li>WorkflowTask：视频工作流处理任务。</li>
<li>EditMediaTask：视频编辑任务。</li>
<li>ScheduleTask：编排任务。</li>
        :type EventType: str
        :param _WorkflowTaskEvent: 视频处理任务信息，仅当 EventType 为 WorkflowTask，该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :type WorkflowTaskEvent: :class:`tencentcloud.mps.v20190612.models.WorkflowTask`
        :param _EditMediaTaskEvent: 视频编辑任务信息，仅当 EventType 为 EditMediaTask，该字段有值。
注意：此字段可能返回 null，表示取不到有效值。
        :type EditMediaTaskEvent: :class:`tencentcloud.mps.v20190612.models.EditMediaTask`
        :param _SessionId: 用于去重的识别码，如果七天内曾有过相同的识别码的请求，则本次的请求会返回错误。最长50个字符，不带或者带空字符串表示不做去重。
        :type SessionId: str
        :param _SessionContext: 来源上下文，用于透传用户请求信息，任务流状态变更回调将返回该字段值，最长1000个字符。
        :type SessionContext: str
        :param 