# -*- coding: utf8 -*-
# Copyright (c) 2017-2021 THL A29 Limited, a Tencent company. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class AcceptAttachCcnInstancesRequest(AbstractModel):
    """AcceptAttachCcnInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CcnId: CCN实例ID。形如：ccn-f49l6u0z。
        :type CcnId: str
        :param _Instances: 接受关联实例列表。
        :type Instances: list of CcnInstance
        """
        self._CcnId = None
        self._Instances = None

    @property
    def CcnId(self):
        """CCN实例ID。形如：ccn-f49l6u0z。
        :rtype: str
        """
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId

    @property
    def Instances(self):
        """接受关联实例列表。
        :rtype: list of CcnInstance
        """
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances


    def _deserialize(self, params):
        self._CcnId = params.get("CcnId")
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = CcnInstance()
                obj._deserialize(item)
                self._Instances.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AcceptAttachCcnInstancesResponse(AbstractModel):
    """AcceptAttachCcnInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AcceptVpcPeeringConnectionRequest(AbstractModel):
    """AcceptVpcPeeringConnection请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PeeringConnectionId: 对等连接唯一ID。
        :type PeeringConnectionId: str
        """
        self._PeeringConnectionId = None

    @property
    def PeeringConnectionId(self):
        """对等连接唯一ID。
        :rtype: str
        """
        return self._PeeringConnectionId

    @PeeringConnectionId.setter
    def PeeringConnectionId(self, PeeringConnectionId):
        self._PeeringConnectionId = PeeringConnectionId


    def _deserialize(self, params):
        self._PeeringConnectionId = params.get("PeeringConnectionId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AcceptVpcPeeringConnectionResponse(AbstractModel):
    """AcceptVpcPeeringConnection返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AccessPolicy(AbstractModel):
    """策略信息

    """

    def __init__(self):
        r"""
        :param _TargetCidr: 目的CIDR
        :type TargetCidr: str
        :param _VpnGatewayIdSslAccessPolicyId: 策略ID
        :type VpnGatewayIdSslAccessPolicyId: str
        :param _ForAllClient: 是否对所有用户都生效。1 生效 0不生效
        :type ForAllClient: int
        :param _UserGroupIds: 用户组ID
        :type UserGroupIds: list of str
        :param _UpdateTime: 更新时间
        :type UpdateTime: str
        :param _Remark: Remark
注意：此字段可能返回 null，表示取不到有效值。
        :type Remark: str
        """
        self._TargetCidr = None
        self._VpnGatewayIdSslAccessPolicyId = None
        self._ForAllClient = None
        self._UserGroupIds = None
        self._UpdateTime = None
        self._Remark = None

    @property
    def TargetCidr(self):
        """目的CIDR
        :rtype: str
        """
        return self._TargetCidr

    @TargetCidr.setter
    def TargetCidr(self, TargetCidr):
        self._TargetCidr = TargetCidr

    @property
    def VpnGatewayIdSslAccessPolicyId(self):
        """策略ID
        :rtype: str
        """
        return self._VpnGatewayIdSslAccessPolicyId

    @VpnGatewayIdSslAccessPolicyId.setter
    def VpnGatewayIdSslAccessPolicyId(self, VpnGatewayIdSslAccessPolicyId):
        self._VpnGatewayIdSslAccessPolicyId = VpnGatewayIdSslAccessPolicyId

    @property
    def ForAllClient(self):
        """是否对所有用户都生效。1 生效 0不生效
        :rtype: int
        """
        return self._ForAllClient

    @ForAllClient.setter
    def ForAllClient(self, ForAllClient):
        self._ForAllClient = ForAllClient

    @property
    def UserGroupIds(self):
        """用户组ID
        :rtype: list of str
        """
        return self._UserGroupIds

    @UserGroupIds.setter
    def UserGroupIds(self, UserGroupIds):
        self._UserGroupIds = UserGroupIds

    @property
    def UpdateTime(self):
        """更新时间
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def Remark(self):
        """Remark
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark


    def _deserialize(self, params):
        self._TargetCidr = params.get("TargetCidr")
        self._VpnGatewayIdSslAccessPolicyId = params.get("VpnGatewayIdSslAccessPolicyId")
        self._ForAllClient = params.get("ForAllClient")
        self._UserGroupIds = params.get("UserGroupIds")
        self._UpdateTime = params.get("UpdateTime")
        self._Remark = params.get("Remark")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AccountAttribute(AbstractModel):
    """账户属性对象

    """

    def __init__(self):
        r"""
        :param _AttributeName: 属性名
        :type AttributeName: str
        :param _AttributeValues: 属性值
        :type AttributeValues: list of str
        """
        self._AttributeName = None
        self._AttributeValues = None

    @property
    def AttributeName(self):
        """属性名
        :rtype: str
        """
        return self._AttributeName

    @AttributeName.setter
    def AttributeName(self, AttributeName):
        self._AttributeName = AttributeName

    @property
    def AttributeValues(self):
        """属性值
        :rtype: list of str
        """
        return self._AttributeValues

    @AttributeValues.setter
    def AttributeValues(self, AttributeValues):
        self._AttributeValues = AttributeValues


    def _deserialize(self, params):
        self._AttributeName = params.get("AttributeName")
        self._AttributeValues = params.get("AttributeValues")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddBandwidthPackageResourcesRequest(AbstractModel):
    """AddBandwidthPackageResources请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ResourceIds: 资源唯一ID，当前支持EIP资源和LB资源，形如'eip-xxxx', 'lb-xxxx'
        :type ResourceIds: list of str
        :param _BandwidthPackageId: 带宽包唯一标识ID，形如'bwp-xxxx'
        :type BandwidthPackageId: str
        :param _NetworkType: 带宽包类型，当前支持'BGP'、'HIGH_QUALITY_BGP'、'ANYCAST'、'SINGLEISP_CUCC'、'SINGLEISP_CMCC'、'SINGLEISP_CTCC'等类型。
        :type NetworkType: str
        :param _ResourceType: 资源类型，包括'Address', 'LoadBalance'
        :type ResourceType: str
        :param _Protocol: 带宽包协议类型。当前支持'ipv4'和'ipv6'协议类型。
        :type Protocol: str
        """
        self._ResourceIds = None
        self._BandwidthPackageId = None
        self._NetworkType = None
        self._ResourceType = None
        self._Protocol = None

    @property
    def ResourceIds(self):
        """资源唯一ID，当前支持EIP资源和LB资源，形如'eip-xxxx', 'lb-xxxx'
        :rtype: list of str
        """
        return self._ResourceIds

    @ResourceIds.setter
    def ResourceIds(self, ResourceIds):
        self._ResourceIds = ResourceIds

    @property
    def BandwidthPackageId(self):
        """带宽包唯一标识ID，形如'bwp-xxxx'
        :rtype: str
        """
        return self._BandwidthPackageId

    @BandwidthPackageId.setter
    def BandwidthPackageId(self, BandwidthPackageId):
        self._BandwidthPackageId = BandwidthPackageId

    @property
    def NetworkType(self):
        """带宽包类型，当前支持'BGP'、'HIGH_QUALITY_BGP'、'ANYCAST'、'SINGLEISP_CUCC'、'SINGLEISP_CMCC'、'SINGLEISP_CTCC'等类型。
        :rtype: str
        """
        return self._NetworkType

    @NetworkType.setter
    def NetworkType(self, NetworkType):
        self._NetworkType = NetworkType

    @property
    def ResourceType(self):
        """资源类型，包括'Address', 'LoadBalance'
        :rtype: str
        """
        return self._ResourceType

    @ResourceType.setter
    def ResourceType(self, ResourceType):
        self._ResourceType = ResourceType

    @property
    def Protocol(self):
        """带宽包协议类型。当前支持'ipv4'和'ipv6'协议类型。
        :rtype: str
        """
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol


    def _deserialize(self, params):
        self._ResourceIds = params.get("ResourceIds")
        self._BandwidthPackageId = params.get("BandwidthPackageId")
        self._NetworkType = params.get("NetworkType")
        self._ResourceType = params.get("ResourceType")
        self._Protocol = params.get("Protocol")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddBandwidthPackageResourcesResponse(AbstractModel):
    """AddBandwidthPackageResources返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AddIp6RulesRequest(AbstractModel):
    """AddIp6Rules请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Ip6TranslatorId: IPV6转换实例唯一ID，形如ip6-xxxxxxxx
        :type Ip6TranslatorId: str
        :param _Ip6RuleInfos: IPV6转换规则信息
        :type Ip6RuleInfos: list of Ip6RuleInfo
        :param _Ip6RuleName: IPV6转换规则名称
        :type Ip6RuleName: str
        """
        self._Ip6TranslatorId = None
        self._Ip6RuleInfos = None
        self._Ip6RuleName = None

    @property
    def Ip6TranslatorId(self):
        """IPV6转换实例唯一ID，形如ip6-xxxxxxxx
        :rtype: str
        """
        return self._Ip6TranslatorId

    @Ip6TranslatorId.setter
    def Ip6TranslatorId(self, Ip6TranslatorId):
        self._Ip6TranslatorId = Ip6TranslatorId

    @property
    def Ip6RuleInfos(self):
        """IPV6转换规则信息
        :rtype: list of Ip6RuleInfo
        """
        return self._Ip6RuleInfos

    @Ip6RuleInfos.setter
    def Ip6RuleInfos(self, Ip6RuleInfos):
        self._Ip6RuleInfos = Ip6RuleInfos

    @property
    def Ip6RuleName(self):
        """IPV6转换规则名称
        :rtype: str
        """
        return self._Ip6RuleName

    @Ip6RuleName.setter
    def Ip6RuleName(self, Ip6RuleName):
        self._Ip6RuleName = Ip6RuleName


    def _deserialize(self, params):
        self._Ip6TranslatorId = params.get("Ip6TranslatorId")
        if params.get("Ip6RuleInfos") is not None:
            self._Ip6RuleInfos = []
            for item in params.get("Ip6RuleInfos"):
                obj = Ip6RuleInfo()
                obj._deserialize(item)
                self._Ip6RuleInfos.append(obj)
        self._Ip6RuleName = params.get("Ip6RuleName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddIp6RulesResponse(AbstractModel):
    """AddIp6Rules返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Ip6RuleSet: IPV6转换规则唯一ID数组，形如rule6-xxxxxxxx
        :type Ip6RuleSet: list of str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Ip6RuleSet = None
        self._RequestId = None

    @property
    def Ip6RuleSet(self):
        """IPV6转换规则唯一ID数组，形如rule6-xxxxxxxx
        :rtype: list of str
        """
        return self._Ip6RuleSet

    @Ip6RuleSet.setter
    def Ip6RuleSet(self, Ip6RuleSet):
        self._Ip6RuleSet = Ip6RuleSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Ip6RuleSet = params.get("Ip6RuleSet")
        self._RequestId = params.get("RequestId")


class AddTemplateMemberRequest(AbstractModel):
    """AddTemplateMember请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TemplateId: 参数模板实例ID，支持IP地址、协议端口、IP地址组、协议端口组四种参数模板的实例ID。
        :type TemplateId: str
        :param _TemplateMember: 需要添加的参数模板成员信息，支持IP地址、协议端口、IP地址组、协议端口组四种类型，类型需要与TemplateId参数类型一致。
        :type TemplateMember: list of MemberInfo
        """
        self._TemplateId = None
        self._TemplateMember = None

    @property
    def TemplateId(self):
        """参数模板实例ID，支持IP地址、协议端口、IP地址组、协议端口组四种参数模板的实例ID。
        :rtype: str
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId

    @property
    def TemplateMember(self):
        """需要添加的参数模板成员信息，支持IP地址、协议端口、IP地址组、协议端口组四种类型，类型需要与TemplateId参数类型一致。
        :rtype: list of MemberInfo
        """
        return self._TemplateMember

    @TemplateMember.setter
    def TemplateMember(self, TemplateMember):
        self._TemplateMember = TemplateMember


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        if params.get("TemplateMember") is not None:
            self._TemplateMember = []
            for item in params.get("TemplateMember"):
                obj = MemberInfo()
                obj._deserialize(item)
                self._TemplateMember.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddTemplateMemberResponse(AbstractModel):
    """AddTemplateMember返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class Address(AbstractModel):
    """描述 EIP 信息

    """

    def __init__(self):
        r"""
        :param _AddressId: `EIP`的`ID`，是`EIP`的唯一标识。
        :type AddressId: str
        :param _AddressName: `EIP`名称。
        :type AddressName: str
        :param _AddressStatus: `EIP`状态，包含'CREATING'(创建中),'BINDING'(绑定中),'BIND'(已绑定),'UNBINDING'(解绑中),'UNBIND'(已解绑),'OFFLINING'(释放中),'BIND_ENI'(绑定悬空弹性网卡)
        :type AddressStatus: str
        :param _AddressIp: 外网IP地址
        :type AddressIp: str
        :param _InstanceId: 绑定的资源实例`ID`。可能是一个`CVM`，`NAT`。
        :type InstanceId: str
        :param _CreatedTime: 创建时间。按照`ISO8601`标准表示，并且使用`UTC`时间。格式为：`YYYY-MM-DDThh:mm:ssZ`。
        :type CreatedTime: str
        :param _NetworkInterfaceId: 绑定的弹性网卡ID
        :type NetworkInterfaceId: str
        :param _PrivateAddressIp: 绑定的资源内网ip
        :type PrivateAddressIp: str
        :param _IsArrears: 资源隔离状态。true表示eip处于隔离状态，false表示资源处于未隔离状态
        :type IsArrears: bool
        :param _IsBlocked: 资源封堵状态。true表示eip处于封堵状态，false表示eip处于未封堵状态
        :type IsBlocked: bool
        :param _IsEipDirectConnection: eip是否支持直通模式。true表示eip支持直通模式，false表示资源不支持直通模式
        :type IsEipDirectConnection: bool
        :param _AddressType: EIP 资源类型，包括CalcIP、WanIP、EIP和AnycastEIP、高防EIP。其中：`CalcIP` 表示设备 IP，`WanIP` 表示普通公网 IP，`EIP` 表示弹性公网 IP，`AnycastEIP` 表示加速 EIP，`AntiDDoSEIP`表示高防EIP。
        :type AddressType: str
        :param _CascadeRelease: eip是否在解绑后自动释放。true表示eip将会在解绑后自动释放，false表示eip在解绑后不会自动释放
        :type CascadeRelease: bool
        :param _EipAlgType: EIP ALG开启的协议类型。
        :type EipAlgType: :class:`tencentcloud.vpc.v20170312.models.AlgType`
        :param _InternetServiceProvider: 弹性公网IP的运营商信息，当前可能返回值包括"CMCC","CTCC","CUCC","BGP"
        :type InternetServiceProvider: str
        :param _LocalBgp: 是否本地带宽EIP
        :type LocalBgp: bool
        :param _Bandwidth: 弹性公网IP的带宽值。注意，传统账户类型账户的弹性公网IP没有带宽属性，值为空。
注意：此字段可能返回 null，表示取不到有效值。
        :type Bandwidth: int
        :param _InternetChargeType: 弹性公网IP的网络计费模式。注意，传统账户类型账户的弹性公网IP没有网络计费模式属性，值为空。
注意：此字段可能返回 null，表示取不到有效值。
包括：
<li><strong>BANDWIDTH_PREPAID_BY_MONTH</strong></li>
<p style="padding-left: 30px;">表示包月带宽预付费。</p>
<li><strong>TRAFFIC_POSTPAID_BY_HOUR</strong></li>
<p style="padding-left: 30px;">表示按小时流量后付费。</p>
<li><strong>BANDWIDTH_POSTPAID_BY_HOUR</strong></li>
<p style="padding-left: 30px;">表示按小时带宽后付费。</p>
<li><strong>BANDWIDTH_PACKAGE</strong></li>
<p style="padding-left: 30px;">表示共享带宽包。</p>
注意：此字段可能返回 null，表示取不到有效值。
        :type InternetChargeType: str
        :param _TagSet: 弹性公网IP关联的标签列表。
注意：此字段可能返回 null，表示取不到有效值。
        :type TagSet: list of Tag
        :param _DeadlineDate: 到期时间。
注意：此字段可能返回 null，表示取不到有效值。
        :type DeadlineDate: str
        :param _InstanceType: EIP绑定的实例类型。
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceType: str
        :param _Egress: 静态单线IP网络出口
注意：此字段可能返回 null，表示取不到有效值。
        :type Egress: str
        :param _AntiDDoSPackageId: 高防包ID,当EIP类型为高防EIP时，返回EIP绑定的高防包ID.
        :type AntiDDoSPackageId: str
        :param _RenewFlag: 当前EIP是否自动续费，只有按月带宽预付费的EIP才会显示该字段，具体值示例如下:
<li>NOTIFY_AND_MANUAL_RENEW:正常续费</li><li>NOTIFY_AND_AUTO_RENEW:自动续费</li><li>DISABLE_NOTIFY_AND_MANUAL_RENEW:到期不续费 </li>

        :type RenewFlag: str
        :param _BandwidthPackageId: 当前公网IP所关联的带宽包ID，如果该公网IP未使用带宽包计费，则返回为空
注意：此字段可能返回 null，表示取不到有效值。
        :type BandwidthPackageId: str
        :param _UnVpcId: 传统弹性公网IPv6所属vpc唯一ID
注意：此字段可能返回 null，表示取不到有效值。
        :type UnVpcId: str
        :param _DedicatedClusterId: CDC唯一ID
注意：此字段可能返回 null，表示取不到有效值。
        :type DedicatedClusterId: str
        """
        self._AddressId = None
        self._AddressName = None
        self._AddressStatus = None
        self._AddressIp = None
        self._InstanceId = None
        self._CreatedTime = None
        self._NetworkInterfaceId = None
        self._PrivateAddressIp = None
        self._IsArrears = None
        self._IsBlocked = None
        self._IsEipDirectConnection = None
        self._AddressType = None
        self._CascadeRelease = None
        self._EipAlgType = None
        self._InternetServiceProvider = None
        self._LocalBgp = None
        self._Bandwidth = None
        self._InternetChargeType = None
        self._TagSet = None
        self._DeadlineDate = None
        self._InstanceType = None
        self._Egress = None
        self._AntiDDoSPackageId = None
        self._RenewFlag = None
        self._BandwidthPackageId = None
        self._UnVpcId = None
        self._DedicatedClusterId = None

    @property
    def AddressId(self):
        """`EIP`的`ID`，是`EIP`的唯一标识。
        :rtype: str
        """
        return self._AddressId

    @AddressId.setter
    def AddressId(self, AddressId):
        self._AddressId = AddressId

    @property
    def AddressName(self):
        """`EIP`名称。
        :rtype: str
        """
        return self._AddressName

    @AddressName.setter
    def AddressName(self, AddressName):
        self._AddressName = AddressName

    @property
    def AddressStatus(self):
        """`EIP`状态，包含'CREATING'(创建中),'BINDING'(绑定中),'BIND'(已绑定),'UNBINDING'(解绑中),'UNBIND'(已解绑),'OFFLINING'(释放中),'BIND_ENI'(绑定悬空弹性网卡)
        :rtype: str
        """
        return self._AddressStatus

    @AddressStatus.setter
    def AddressStatus(self, AddressStatus):
        self._AddressStatus = AddressStatus

    @property
    def AddressIp(self):
        """外网IP地址
        :rtype: str
        """
        return self._AddressIp

    @AddressIp.setter
    def AddressIp(self, AddressIp):
        self._AddressIp = AddressIp

    @property
    def InstanceId(self):
        """绑定的资源实例`ID`。可能是一个`CVM`，`NAT`。
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def CreatedTime(self):
        """创建时间。按照`ISO8601`标准表示，并且使用`UTC`时间。格式为：`YYYY-MM-DDThh:mm:ssZ`。
        :rtype: str
        """
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime

    @property
    def NetworkInterfaceId(self):
        """绑定的弹性网卡ID
        :rtype: str
        """
        return self._NetworkInterfaceId

    @NetworkInterfaceId.setter
    def NetworkInterfaceId(self, NetworkInterfaceId):
        self._NetworkInterfaceId = NetworkInterfaceId

    @property
    def PrivateAddressIp(self):
        """绑定的资源内网ip
        :rtype: str
        """
        return self._PrivateAddressIp

    @PrivateAddressIp.setter
    def PrivateAddressIp(self, PrivateAddressIp):
        self._PrivateAddressIp = PrivateAddressIp

    @property
    def IsArrears(self):
        """资源隔离状态。true表示eip处于隔离状态，false表示资源处于未隔离状态
        :rtype: bool
        """
        return self._IsArrears

    @IsArrears.setter
    def IsArrears(self, IsArrears):
        self._IsArrears = IsArrears

    @property
    def IsBlocked(self):
        """资源封堵状态。true表示eip处于封堵状态，false表示eip处于未封堵状态
        :rtype: bool
        """
        return self._IsBlocked

    @IsBlocked.setter
    def IsBlocked(self, IsBlocked):
        self._IsBlocked = IsBlocked

    @property
    def IsEipDirectConnection(self):
        """eip是否支持直通模式。true表示eip支持直通模式，false表示资源不支持直通模式
        :rtype: bool
        """
        return self._IsEipDirectConnection

    @IsEipDirectConnection.setter
    def IsEipDirectConnection(self, IsEipDirectConnection):
        self._IsEipDirectConnection = IsEipDirectConnection

    @property
    def AddressType(self):
        """EIP 资源类型，包括CalcIP、WanIP、EIP和AnycastEIP、高防EIP。其中：`CalcIP` 表示设备 IP，`WanIP` 表示普通公网 IP，`EIP` 表示弹性公网 IP，`AnycastEIP` 表示加速 EIP，`AntiDDoSEIP`表示高防EIP。
        :rtype: str
        """
        return self._AddressType

    @AddressType.setter
    def AddressType(self, AddressType):
        self._AddressType = AddressType

    @property
    def CascadeRelease(self):
        """eip是否在解绑后自动释放。true表示eip将会在解绑后自动释放，false表示eip在解绑后不会自动释放
        :rtype: bool
        """
        return self._CascadeRelease

    @CascadeRelease.setter
    def CascadeRelease(self, CascadeRelease):
        self._CascadeRelease = CascadeRelease

    @property
    def EipAlgType(self):
        """EIP ALG开启的协议类型。
        :rtype: :class:`tencentcloud.vpc.v20170312.models.AlgType`
        """
        return self._EipAlgType

    @EipAlgType.setter
    def EipAlgType(self, EipAlgType):
        self._EipAlgType = EipAlgType

    @property
    def InternetServiceProvider(self):
        """弹性公网IP的运营商信息，当前可能返回值包括"CMCC","CTCC","CUCC","BGP"
        :rtype: str
        """
        return self._InternetServiceProvider

    @InternetServiceProvider.setter
    def InternetServiceProvider(self, InternetServiceProvider):
        self._InternetServiceProvider = InternetServiceProvider

    @property
    def LocalBgp(self):
        """是否本地带宽EIP
        :rtype: bool
        """
        return self._LocalBgp

    @LocalBgp.setter
    def LocalBgp(self, LocalBgp):
        self._LocalBgp = LocalBgp

    @property
    def Bandwidth(self):
        """弹性公网IP的带宽值。注意，传统账户类型账户的弹性公网IP没有带宽属性，值为空。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Bandwidth

    @Bandwidth.setter
    def Bandwidth(self, Bandwidth):
        self._Bandwidth = Bandwidth

    @property
    def InternetChargeType(self):
        """弹性公网IP的网络计费模式。注意，传统账户类型账户的弹性公网IP没有网络计费模式属性，值为空。
注意：此字段可能返回 null，表示取不到有效值。
包括：
<li><strong>BANDWIDTH_PREPAID_BY_MONTH</strong></li>
<p style="padding-left: 30px;">表示包月带宽预付费。</p>
<li><strong>TRAFFIC_POSTPAID_BY_HOUR</strong></li>
<p style="padding-left: 30px;">表示按小时流量后付费。</p>
<li><strong>BANDWIDTH_POSTPAID_BY_HOUR</strong></li>
<p style="padding-left: 30px;">表示按小时带宽后付费。</p>
<li><strong>BANDWIDTH_PACKAGE</strong></li>
<p style="padding-left: 30px;">表示共享带宽包。</p>
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._InternetChargeType

    @InternetChargeType.setter
    def InternetChargeType(self, InternetChargeType):
        self._InternetChargeType = InternetChargeType

    @property
    def TagSet(self):
        """弹性公网IP关联的标签列表。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of Tag
        """
        return self._TagSet

    @TagSet.setter
    def TagSet(self, TagSet):
        self._TagSet = TagSet

    @property
    def DeadlineDate(self):
        """到期时间。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DeadlineDate

    @DeadlineDate.setter
    def DeadlineDate(self, DeadlineDate):
        self._DeadlineDate = DeadlineDate

    @property
    def InstanceType(self):
        """EIP绑定的实例类型。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def Egress(self):
        """静态单线IP网络出口
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Egress

    @Egress.setter
    def Egress(self, Egress):
        self._Egress = Egress

    @property
    def AntiDDoSPackageId(self):
        """高防包ID,当EIP类型为高防EIP时，返回EIP绑定的高防包ID.
        :rtype: str
        """
        return self._AntiDDoSPackageId

    @AntiDDoSPackageId.setter
    def AntiDDoSPackageId(self, AntiDDoSPackageId):
        self._AntiDDoSPackageId = AntiDDoSPackageId

    @property
    def RenewFlag(self):
        """当前EIP是否自动续费，只有按月带宽预付费的EIP才会显示该字段，具体值示例如下:
<li>NOTIFY_AND_MANUAL_RENEW:正常续费</li><li>NOTIFY_AND_AUTO_RENEW:自动续费</li><li>DISABLE_NOTIFY_AND_MANUAL_RENEW:到期不续费 </li>

        :rtype: str
        """
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag

    @property
    def BandwidthPackageId(self):
        """当前公网IP所关联的带宽包ID，如果该公网IP未使用带宽包计费，则返回为空
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._BandwidthPackageId

    @BandwidthPackageId.setter
    def BandwidthPackageId(self, BandwidthPackageId):
        self._BandwidthPackageId = BandwidthPackageId

    @property
    def UnVpcId(self):
        """传统弹性公网IPv6所属vpc唯一ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._UnVpcId

    @UnVpcId.setter
    def UnVpcId(self, UnVpcId):
        self._UnVpcId = UnVpcId

    @property
    def DedicatedClusterId(self):
        """CDC唯一ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DedicatedClusterId

    @DedicatedClusterId.setter
    def DedicatedClusterId(self, DedicatedClusterId):
        self._DedicatedClusterId = DedicatedClusterId


    def _deserialize(self, params):
        self._AddressId = params.get("AddressId")
        self._AddressName = params.get("AddressName")
        self._AddressStatus = params.get("AddressStatus")
        self._AddressIp = params.get("AddressIp")
        self._InstanceId = params.get("InstanceId")
        self._CreatedTime = params.get("CreatedTime")
        self._NetworkInterfaceId = params.get("NetworkInterfaceId")
        self._PrivateAddressIp = params.get("PrivateAddressIp")
        self._IsArrears = params.get("IsArrears")
        self._IsBlocked = params.get("IsBlocked")
        self._IsEipDirectConnection = params.get("IsEipDirectConnection")
        self._AddressType = params.get("AddressType")
        self._CascadeRelease = params.get("CascadeRelease")
        if params.get("EipAlgType") is not None:
            self._EipAlgType = AlgType()
            self._EipAlgType._deserialize(params.get("EipAlgType"))
        self._InternetServiceProvider = params.get("InternetServiceProvider")
        self._LocalBgp = params.get("LocalBgp")
        self._Bandwidth = params.get("Bandwidth")
        self._InternetChargeType = params.get("InternetChargeType")
        if params.get("TagSet") is not None:
            self._TagSet = []
            for item in params.get("TagSet"):
                obj = Tag()
                obj._deserialize(item)
                self._TagSet.append(obj)
        self._DeadlineDate = params.get("DeadlineDate")
        self._InstanceType = params.get("InstanceType")
        self._Egress = params.get("Egress")
        self._AntiDDoSPackageId = params.get("AntiDDoSPackageId")
        self._RenewFlag = params.get("RenewFlag")
        self._BandwidthPackageId = params.get("BandwidthPackageId")
        self._UnVpcId = params.get("UnVpcId")
        self._DedicatedClusterId = params.get("DedicatedClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddressChargePrepaid(AbstractModel):
    """用于描述弹性公网IP的费用对象

    """

    def __init__(self):
        r"""
        :param _Period: 购买实例的时长，单位是月。可支持时长：1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 24, 36
        :type Period: int
        :param _AutoRenewFlag: 自动续费标志。0表示手动续费，1表示自动续费，2表示到期不续费。默认缺省为0即手动续费
        :type AutoRenewFlag: int
        """
        self._Period = None
        self._AutoRenewFlag = None

    @property
    def Period(self):
        """购买实例的时长，单位是月。可支持时长：1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 24, 36
        :rtype: int
        """
        return self._Period

    @Period.setter
    def Period(self, Period):
        self._Period = Period

    @property
    def AutoRenewFlag(self):
        """自动续费标志。0表示手动续费，1表示自动续费，2表示到期不续费。默认缺省为0即手动续费
        :rtype: int
        """
        return self._AutoRenewFlag

    @AutoRenewFlag.setter
    def AutoRenewFlag(self, AutoRenewFlag):
        self._AutoRenewFlag = AutoRenewFlag


    def _deserialize(self, params):
        self._Period = params.get("Period")
        self._AutoRenewFlag = params.get("AutoRenewFlag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddressInfo(AbstractModel):
    """IP地址模板信息

    """

    def __init__(self):
        r"""
        :param _Address: ip地址。
        :type Address: str
        :param _Description: 备注。
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        """
        self._Address = None
        self._Description = None

    @property
    def Address(self):
        """ip地址。
        :rtype: str
        """
        return self._Address

    @Address.setter
    def Address(self, Address):
        self._Address = Address

    @property
    def Description(self):
        """备注。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._Address = params.get("Address")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddressTemplate(AbstractModel):
    """IP地址模板

    """

    def __init__(self):
        r"""
        :param _AddressTemplateName: IP地址模板名称。
        :type AddressTemplateName: str
        :param _AddressTemplateId: IP地址模板实例唯一ID。
        :type AddressTemplateId: str
        :param _AddressSet: IP地址信息。
        :type AddressSet: list of str
        :param _CreatedTime: 创建时间。
        :type CreatedTime: str
        :param _AddressExtraSet: 带备注的IP地址信息。
        :type AddressExtraSet: list of AddressInfo
        :param _TagSet: 标签键值对。	
注意：此字段可能返回 null，表示取不到有效值。
        :type TagSet: list of Tag
        """
        self._AddressTemplateName = None
        self._AddressTemplateId = None
        self._AddressSet = None
        self._CreatedTime = None
        self._AddressExtraSet = None
        self._TagSet = None

    @property
    def AddressTemplateName(self):
        """IP地址模板名称。
        :rtype: str
        """
        return self._AddressTemplateName

    @AddressTemplateName.setter
    def AddressTemplateName(self, AddressTemplateName):
        self._AddressTemplateName = AddressTemplateName

    @property
    def AddressTemplateId(self):
        """IP地址模板实例唯一ID。
        :rtype: str
        """
        return self._AddressTemplateId

    @AddressTemplateId.setter
    def AddressTemplateId(self, AddressTemplateId):
        self._AddressTemplateId = AddressTemplateId

    @property
    def AddressSet(self):
        """IP地址信息。
        :rtype: list of str
        """
        return self._AddressSet

    @AddressSet.setter
    def AddressSet(self, AddressSet):
        self._AddressSet = AddressSet

    @property
    def CreatedTime(self):
        """创建时间。
        :rtype: str
        """
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime

    @property
    def AddressExtraSet(self):
        """带备注的IP地址信息。
        :rtype: list of AddressInfo
        """
        return self._AddressExtraSet

    @AddressExtraSet.setter
    def AddressExtraSet(self, AddressExtraSet):
        self._AddressExtraSet = AddressExtraSet

    @property
    def TagSet(self):
        """标签键值对。	
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of Tag
        """
        return self._TagSet

    @TagSet.setter
    def TagSet(self, TagSet):
        self._TagSet = TagSet


    def _deserialize(self, params):
        self._AddressTemplateName = params.get("AddressTemplateName")
        self._AddressTemplateId = params.get("AddressTemplateId")
        self._AddressSet = params.get("AddressSet")
        self._CreatedTime = params.get("CreatedTime")
        if params.get("AddressExtraSet") is not None:
            self._AddressExtraSet = []
            for item in params.get("AddressExtraSet"):
                obj = AddressInfo()
                obj._deserialize(item)
                self._AddressExtraSet.append(obj)
        if params.get("TagSet") is not None:
            self._TagSet = []
            for item in params.get("TagSet"):
                obj = Tag()
                obj._deserialize(item)
                self._TagSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddressTemplateGroup(AbstractModel):
    """IP地址模板集合

    """

    def __init__(self):
        r"""
        :param _AddressTemplateGroupName: IP地址模板集合名称。
        :type AddressTemplateGroupName: str
        :param _AddressTemplateGroupId: IP地址模板集合实例ID，例如：ipmg-dih8xdbq。
        :type AddressTemplateGroupId: str
        :param _AddressTemplateIdSet: IP地址模板ID。
        :type AddressTemplateIdSet: list of str
        :param _CreatedTime: 创建时间。
        :type CreatedTime: str
        :param _AddressTemplateSet: IP地址模板实例。
        :type AddressTemplateSet: list of AddressTemplateItem
        :param _TagSet: 标签键值对。	
注意：此字段可能返回 null，表示取不到有效值。
        :type TagSet: list of Tag
        """
        self._AddressTemplateGroupName = None
        self._AddressTemplateGroupId = None
        self._AddressTemplateIdSet = None
        self._CreatedTime = None
        self._AddressTemplateSet = None
        self._TagSet = None

    @property
    def AddressTemplateGroupName(self):
        """IP地址模板集合名称。
        :rtype: str
        """
        return self._AddressTemplateGroupName

    @AddressTemplateGroupName.setter
    def AddressTemplateGroupName(self, AddressTemplateGroupName):
        self._AddressTemplateGroupName = AddressTemplateGroupName

    @property
    def AddressTemplateGroupId(self):
        """IP地址模板集合实例ID，例如：ipmg-dih8xdbq。
        :rtype: str
        """
        return self._AddressTemplateGroupId

    @AddressTemplateGroupId.setter
    def AddressTemplateGroupId(self, AddressTemplateGroupId):
        self._AddressTemplateGroupId = AddressTemplateGroupId

    @property
    def AddressTemplateIdSet(self):
        """IP地址模板ID。
        :rtype: list of str
        """
        return self._AddressTemplateIdSet

    @AddressTemplateIdSet.setter
    def AddressTemplateIdSet(self, AddressTemplateIdSet):
        self._AddressTemplateIdSet = AddressTemplateIdSet

    @property
    def CreatedTime(self):
        """创建时间。
        :rtype: str
        """
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime

    @property
    def AddressTemplateSet(self):
        """IP地址模板实例。
        :rtype: list of AddressTemplateItem
        """
        return self._AddressTemplateSet

    @AddressTemplateSet.setter
    def AddressTemplateSet(self, AddressTemplateSet):
        self._AddressTemplateSet = AddressTemplateSet

    @property
    def TagSet(self):
        """标签键值对。	
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of Tag
        """
        return self._TagSet

    @TagSet.setter
    def TagSet(self, TagSet):
        self._TagSet = TagSet


    def _deserialize(self, params):
        self._AddressTemplateGroupName = params.get("AddressTemplateGroupName")
        self._AddressTemplateGroupId = params.get("AddressTemplateGroupId")
        self._AddressTemplateIdSet = params.get("AddressTemplateIdSet")
        self._CreatedTime = params.get("CreatedTime")
        if params.get("AddressTemplateSet") is not None:
            self._AddressTemplateSet = []
            for item in params.get("AddressTemplateSet"):
                obj = AddressTemplateItem()
                obj._deserialize(item)
                self._AddressTemplateSet.append(obj)
        if params.get("TagSet") is not None:
            self._TagSet = []
            for item in params.get("TagSet"):
                obj = Tag()
                obj._deserialize(item)
                self._TagSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddressTemplateItem(AbstractModel):
    """地址信息

    """

    def __init__(self):
        r"""
        :param _AddressTemplateId: IP地址模板ID
        :type AddressTemplateId: str
        :param _AddressTemplateName: IP模板名称
        :type AddressTemplateName: str
        :param _From: 废弃字段
        :type From: str
        :param _To: 废弃字段
        :type To: str
        """
        self._AddressTemplateId = None
        self._AddressTemplateName = None
        self._From = None
        self._To = None

    @property
    def AddressTemplateId(self):
        """IP地址模板ID
        :rtype: str
        """
        return self._AddressTemplateId

    @AddressTemplateId.setter
    def AddressTemplateId(self, AddressTemplateId):
        self._AddressTemplateId = AddressTemplateId

    @property
    def AddressTemplateName(self):
        """IP模板名称
        :rtype: str
        """
        return self._AddressTemplateName

    @AddressTemplateName.setter
    def AddressTemplateName(self, AddressTemplateName):
        self._AddressTemplateName = AddressTemplateName

    @property
    def From(self):
        """废弃字段
        :rtype: str
        """
        return self._From

    @From.setter
    def From(self, From):
        self._From = From

    @property
    def To(self):
        """废弃字段
        :rtype: str
        """
        return self._To

    @To.setter
    def To(self, To):
        self._To = To


    def _deserialize(self, params):
        self._AddressTemplateId = params.get("AddressTemplateId")
        self._AddressTemplateName = params.get("AddressTemplateName")
        self._From = params.get("From")
        self._To = params.get("To")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddressTemplateSpecification(AbstractModel):
    """IP地址模板

    """

    def __init__(self):
        r"""
        :param _AddressId: IP地址ID，例如：ipm-2uw6ujo6。
        :type AddressId: str
        :param _AddressGroupId: IP地址组ID，例如：ipmg-2uw6ujo6。
        :type AddressGroupId: str
        """
        self._AddressId = None
        self._AddressGroupId = None

    @property
    def AddressId(self):
        """IP地址ID，例如：ipm-2uw6ujo6。
        :rtype: str
        """
        return self._AddressId

    @AddressId.setter
    def AddressId(self, AddressId):
        self._AddressId = AddressId

    @property
    def AddressGroupId(self):
        """IP地址组ID，例如：ipmg-2uw6ujo6。
        :rtype: str
        """
        return self._AddressGroupId

    @AddressGroupId.setter
    def AddressGroupId(self, AddressGroupId):
        self._AddressGroupId = AddressGroupId


    def _deserialize(self, params):
        self._AddressId = params.get("AddressId")
        self._AddressGroupId = params.get("AddressGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AdjustPublicAddressRequest(AbstractModel):
    """AdjustPublicAddress请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceId: 标识CVM实例的唯一 ID。CVM 唯一 ID 形如：`ins-11112222`。
        :type InstanceId: str
        :param _AddressId: 标识EIP实例的唯一 ID。EIP 唯一 ID 形如：`eip-11112222`。
        :type AddressId: str
        """
        self._InstanceId = None
        self._AddressId = None

    @property
    def InstanceId(self):
        """标识CVM实例的唯一 ID。CVM 唯一 ID 形如：`ins-11112222`。
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def AddressId(self):
        """标识EIP实例的唯一 ID。EIP 唯一 ID 形如：`eip-11112222`。
        :rtype: str
        """
        return self._AddressId

    @AddressId.setter
    def AddressId(self, AddressId):
        self._AddressId = AddressId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._AddressId = params.get("AddressId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AdjustPublicAddressResponse(AbstractModel):
    """AdjustPublicAddress返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 异步任务TaskId。可以使用[DescribeTaskResult](https://cloud.tencent.com/document/api/215/36271)接口查询任务状态。
        :type TaskId: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        """异步任务TaskId。可以使用[DescribeTaskResult](https://cloud.tencent.com/document/api/215/36271)接口查询任务状态。
        :rtype: int
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class AlgType(AbstractModel):
    """ALG协议类型

    """

    def __init__(self):
        r"""
        :param _Ftp: Ftp协议Alg功能是否开启
        :type Ftp: bool
        :param _Sip: Sip协议Alg功能是否开启
        :type Sip: bool
        """
        self._Ftp = None
        self._Sip = None

    @property
    def Ftp(self):
        """Ftp协议Alg功能是否开启
        :rtype: bool
        """
        return self._Ftp

    @Ftp.setter
    def Ftp(self, Ftp):
        self._Ftp = Ftp

    @property
    def Sip(self):
        """Sip协议Alg功能是否开启
        :rtype: bool
        """
        return self._Sip

    @Sip.setter
    def Sip(self, Sip):
        self._Sip = Sip


    def _deserialize(self, params):
        self._Ftp = params.get("Ftp")
        self._Sip = params.get("Sip")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AllocateAddressesRequest(AbstractModel):
    """AllocateAddresses请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AddressCount: EIP数量。默认值：1。
        :type AddressCount: int
        :param _InternetServiceProvider: EIP线路类型。默认值：BGP。
<ul style="margin:0"><li>已开通静态单线IP白名单的用户，可选值：<ul><li>CMCC：中国移动</li>
<li>CTCC：中国电信</li>
<li>CUCC：中国联通</li></ul>注意：仅部分地域支持静态单线IP。</li></ul>
        :type InternetServiceProvider: str
        :param _InternetChargeType: EIP计费方式。
<ul style="margin:0"><li>已开通标准账户类型白名单的用户，可选值：<ul><li>BANDWIDTH_PACKAGE：[共享带宽包](https://cloud.tencent.com/document/product/684/15255)付费（需额外开通共享带宽包白名单）</li>
<li>BANDWIDTH_POSTPAID_BY_HOUR：带宽按小时后付费</li>
<li>BANDWIDTH_PREPAID_BY_MONTH：包月按带宽预付费</li>
<li>TRAFFIC_POSTPAID_BY_HOUR：流量按小时后付费</li></ul>默认值：TRAFFIC_POSTPAID_BY_HOUR。</li>
<li>未开通标准账户类型白名单的用户，EIP计费方式与其绑定的实例的计费方式一致，无需传递此参数。</li></ul>
        :type InternetChargeType: str
        :param _InternetMaxBandwidthOut: EIP出带宽上限，单位：Mbps。
<ul style="margin:0"><li>已开通标准账户类型白名单的用户，可选值范围取决于EIP计费方式：<ul><li>BANDWIDTH_PACKAGE：1 Mbps 至 2000 Mbps</li>
<li>BANDWIDTH_POSTPAID_BY_HOUR：1 Mbps 至 100 Mbps</li>
<li>BANDWIDTH_PREPAID_BY_MONTH：1 Mbps 至 200 Mbps</li>
<li>TRAFFIC_POSTPAID_BY_HOUR：1 Mbps 至 100 Mbps</li></ul>默认值：1 Mbps。</li>
<li>未开通标准账户类型白名单的用户，EIP出带宽上限取决于与其绑定的实例的公网出带宽上限，无需传递此参数。</li></ul>
        :type InternetMaxBandwidthOut: int
        :param _AddressChargePrepaid: 包月按带宽预付费EIP的计费参数。EIP为包月按带宽预付费时，该参数必传，其余场景不需传递
        :type AddressChargePrepaid: :class:`tencentcloud.vpc.v20170312.models.AddressChargePrepaid`
        :param _AddressType: EIP类型。默认值：EIP。
<ul style="margin:0"><li>已开通Anycast公网加速白名单的用户，可选值：<ul><li>AnycastEIP：加速IP，可参见 [Anycast 公网加速](https://cloud.tencent.com/document/product/644)</li></ul>注意：仅部分地域支持加速IP。</li></ul>
<ul style="margin:0"><li>已开通精品IP白名单的用户，可选值：<ul><li>HighQualityEIP：精品IP</li></ul>注意：仅部分地域支持精品IP。</li></ul>
<ul style="margin:0"><li>已开高防IP白名单的用户，可选值：<ul><li>AntiDDoSEIP：高防IP</li></ul>注意：仅部分地域支持高防IP。</li></ul>
        :type AddressType: str
        :param _AnycastZone: Anycast发布域。
<ul style="margin:0"><li>已开通Anycast公网加速白名单的用户，可选值：<ul><li>ANYCAST_ZONE_GLOBAL：全球发布域（需要额外开通Anycast全球加速白名单）</li><li>ANYCAST_ZONE_OVERSEAS：境外发布域</li><li><b>[已废弃]</b> ANYCAST_ZONE_A：发布域A（已更新为全球发布域）</li><li><b>[已废弃]</b> ANYCAST_ZONE_B：发布域B（已更新为全球发布域）</li></ul>默认值：ANYCAST_ZONE_OVERSEAS。</li></ul>
        :type AnycastZone: str
        :param _VipCluster: 指定IP地址申请EIP，每个账户每个月只有三次配额
        :type VipCluster: list of str
        :param _ApplicableForCLB: <b>[已废弃]</b> AnycastEIP不再区分是否负载均衡。原参数说明如下：
AnycastEIP是否用于绑定负载均衡。
<ul style="margin:0"><li>已开通Anycast公网加速白名单的用户，可选值：<ul><li>TRUE：AnycastEIP可绑定对象为负载均衡</li>
<li>FALSE：AnycastEIP可绑定对象为云服务器、NAT网关、高可用虚拟IP等</li></ul>默认值：FALSE。</li></ul>
        :type ApplicableForCLB: bool
        :param _Tags: 需要关联的标签列表。
        :type Tags: list of Tag
        :param _BandwidthPackageId: BGP带宽包唯一ID参数。设定该参数且InternetChargeType为BANDWIDTH_PACKAGE，则表示创建的EIP加入该BGP带宽包并采用带宽包计费
        :type BandwidthPackageId: str
        :param _AddressName: EIP名称，用于申请EIP时用户自定义该EIP的个性化名称，默认值：未命名
        :type AddressName: str
        :param _DedicatedClusterId: CDC唯一ID
        :type DedicatedClusterId: str
        :param _Egress: 网络出口，当前仅支持精品BGP、静态单线，这2种IP 地址类型的指定出口传入，默认值：center_egress1，其它可选值：center_egress2、center_egress3
        :type Egress: str
        :param _AntiDDoSPackageId: 高防包ID， 申请高防IP时，该字段必传。
        :type AntiDDoSPackageId: str
        :param _ClientToken: 保证请求幂等性。从您的客户端生成一个参数值，确保不同请求间该参数值唯一。ClientToken只支持ASCII字符，且不能超过64个字符。
        :type ClientToken: str
        """
        self._AddressCount = None
        self._InternetServiceProvider = None
        self._InternetChargeType = None
        self._InternetMaxBandwidthOut = None
        self._AddressChargePrepaid = None
        self._AddressType = None
        self._AnycastZone = None
        self._VipCluster = None
        self._ApplicableForCLB = None
        self._Tags = None
        self._BandwidthPackageId = None
        self._AddressName = None
        self._DedicatedClusterId = None
        self._Egress = None
        self._AntiDDoSPackageId = None
        self._ClientToken = None

    @property
    def AddressCount(self):
        """EIP数量。默认值：1。
        :rtype: int
        """
        return self._AddressCount

    @AddressCount.setter
    def AddressCount(self, AddressCount):
        self._AddressCount = AddressCount

    @property
    def InternetServiceProvider(self):
        """EIP线路类型。默认值：BGP。
<ul style="margin:0"><li>已开通静态单线IP白名单的用户，可选值：<ul><li>CMCC：中国移动</li>
<li>CTCC：中国电信</li>
<li>CUCC：中国联通</li></ul>注意：仅部分地域支持静态单线IP。</li></ul>
        :rtype: str
        """
        return self._InternetServiceProvider

    @InternetServiceProvider.setter
    def InternetServiceProvider(self, InternetServiceProvider):
        self._InternetServiceProvider = InternetServiceProvider

    @property
    def InternetChargeType(self):
        """EIP计费方式。
<ul style="margin:0"><li>已开通标准账户类型白名单的用户，可选值：<ul><li>BANDWIDTH_PACKAGE：[共享带宽包](https://cloud.tencent.com/document/product/684/15255)付费（需额外开通共享带宽包白名单）</li>
<li>BANDWIDTH_POSTPAID_BY_HOUR：带宽按小时后付费</li>
<li>BANDWIDTH_PREPAID_BY_MONTH：包月按带宽预付费</li>
<li>TRAFFIC_POSTPAID_BY_HOUR：流量按小时后付费</li></ul>默认值：TRAFFIC_POSTPAID_BY_HOUR。</li>
<li>未开通标准账户类型白名单的用户，EIP计费方式与其绑定的实例的计费方式一致，无需传递此参数。</li></ul>
        :rtype: str
        """
        return self._InternetChargeType

    @InternetChargeType.setter
    def InternetChargeType(self, InternetChargeType):
        self._InternetChargeType = InternetChargeType

    @property
    def InternetMaxBandwidthOut(self):
        """EIP出带宽上限，单位：Mbps。
<ul style="margin:0"><li>已开通标准账户类型白名单的用户，可选值范围取决于EIP计费方式：<ul><li>BANDWIDTH_PACKAGE：1 Mbps 至 2000 Mbps</li>
<li>BANDWIDTH_POSTPAID_BY_HOUR：1 Mbps 至 100 Mbps</li>
<li>BANDWIDTH_PREPAID_BY_MONTH：1 Mbps 至 200 Mbps</li>
<li>TRAFFIC_POSTPAID_BY_HOUR：1 Mbps 至 100 Mbps</li></ul>默认值：1 Mbps。</li>
<li>未开通标准账户类型白名单的用户，EIP出带宽上限取决于与其绑定的实例的公网出带宽上限，无需传递此参数。</li></ul>
        :rtype: int
        """
        return self._InternetMaxBandwidthOut

    @InternetMaxBandwidthOut.setter
    def InternetMaxBandwidthOut(self, InternetMaxBandwidthOut):
        self._InternetMaxBandwidthOut = InternetMaxBandwidthOut

    @property
    def AddressChargePrepaid(self):
        """包月按带宽预付费EIP的计费参数。EIP为包月按带宽预付费时，该参数必传，其余场景不需传递
        :rtype: :class:`tencentcloud.vpc.v20170312.models.AddressChargePrepaid`
        """
        return self._AddressChargePrepaid

    @AddressChargePrepaid.setter
    def AddressChargePrepaid(self, AddressChargePrepaid):
        self._AddressChargePrepaid = AddressChargePrepaid

    @property
    def AddressType(self):
        """EIP类型。默认值：EIP。
<ul style="margin:0"><li>已开通Anycast公网加速白名单的用户，可选值：<ul><li>AnycastEIP：加速IP，可参见 [Anycast 公网加速](https://cloud.tencent.com/document/product/644)</li></ul>注意：仅部分地域支持加速IP。</li></ul>
<ul style="margin:0"><li>已开通精品IP白名单的用户，可选值：<ul><li>HighQualityEIP：精品IP</li></ul>注意：仅部分地域支持精品IP。</li></ul>
<ul style="margin:0"><li>已开高防IP白名单的用户，可选值：<ul><li>AntiDDoSEIP：高防IP</li></ul>注意：仅部分地域支持高防IP。</li></ul>
        :rtype: str
        """
        return self._AddressType

    @AddressType.setter
    def AddressType(self, AddressType):
        self._AddressType = AddressType

    @property
    def AnycastZone(self):
        """Anycast发布域。
<ul style="margin:0"><li>已开通Anycast公网加速白名单的用户，可选值：<ul><li>ANYCAST_ZONE_GLOBAL：全球发布域（需要额外开通Anycast全球加速白名单）</li><li>ANYCAST_ZONE_OVERSEAS：境外发布域</li><li><b>[已废弃]</b> ANYCAST_ZONE_A：发布域A（已更新为全球发布域）</li><li><b>[已废弃]</b> ANYCAST_ZONE_B：发布域B（已更新为全球发布域）</li></ul>默认值：ANYCAST_ZONE_OVERSEAS。</li></ul>
        :rtype: str
        """
        return self._AnycastZone

    @AnycastZone.setter
    def AnycastZone(self, AnycastZone):
        self._AnycastZone = AnycastZone

    @property
    def VipCluster(self):
        """指定IP地址申请EIP，每个账户每个月只有三次配额
        :rtype: list of str
        """
        return self._VipCluster

    @VipCluster.setter
    def VipCluster(self, VipCluster):
        self._VipCluster = VipCluster

    @property
    def ApplicableForCLB(self):
        """<b>[已废弃]</b> AnycastEIP不再区分是否负载均衡。原参数说明如下：
AnycastEIP是否用于绑定负载均衡。
<ul style="margin:0"><li>已开通Anycast公网加速白名单的用户，可选值：<ul><li>TRUE：AnycastEIP可绑定对象为负载均衡</li>
<li>FALSE：AnycastEIP可绑定对象为云服务器、NAT网关、高可用虚拟IP等</li></ul>默认值：FALSE。</li></ul>
        :rtype: bool
        """
        return self._ApplicableForCLB

    @ApplicableForCLB.setter
    def ApplicableForCLB(self, ApplicableForCLB):
        self._ApplicableForCLB = ApplicableForCLB

    @property
    def Tags(self):
        """需要关联的标签列表。
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def BandwidthPackageId(self):
        """BGP带宽包唯一ID参数。设定该参数且InternetChargeType为BANDWIDTH_PACKAGE，则表示创建的EIP加入该BGP带宽包并采用带宽包计费
        :rtype: str
        """
        return self._BandwidthPackageId

    @BandwidthPackageId.setter
    def BandwidthPackageId(self, BandwidthPackageId):
        self._BandwidthPackageId = BandwidthPackageId

    @property
    def AddressName(self):
        """EIP名称，用于申请EIP时用户自定义该EIP的个性化名称，默认值：未命名
        :rtype: str
        """
        return self._AddressName

    @AddressName.setter
    def AddressName(self, AddressName):
        self._AddressName = AddressName

    @property
    def DedicatedClusterId(self):
        """CDC唯一ID
        :rtype: str
        """
        return self._DedicatedClusterId

    @DedicatedClusterId.setter
    def DedicatedClusterId(self, DedicatedClusterId):
        self._DedicatedClusterId = DedicatedClusterId

    @property
    def Egress(self):
        """网络出口，当前仅支持精品BGP、静态单线，这2种IP 地址类型的指定出口传入，默认值：center_egress1，其它可选值：center_egress2、center_egress3
        :rtype: str
        """
        return self._Egress

    @Egress.setter
    def Egress(self, Egress):
        self._Egress = Egress

    @property
    def AntiDDoSPackageId(self):
        """高防包ID， 申请高防IP时，该字段必传。
        :rtype: str
        """
        return self._AntiDDoSPackageId

    @AntiDDoSPackageId.setter
    def AntiDDoSPackageId(self, AntiDDoSPackageId):
        self._AntiDDoSPackageId = AntiDDoSPackageId

    @property
    def ClientToken(self):
        """保证请求幂等性。从您的客户端生成一个参数值，确保不同请求间该参数值唯一。ClientToken只支持ASCII字符，且不能超过64个字符。
        :rtype: str
        """
        return self._ClientToken

    @ClientToken.setter
    def ClientToken(self, ClientToken):
        self._ClientToken = ClientToken


    def _deserialize(self, params):
        self._AddressCount = params.get("AddressCount")
        self._InternetServiceProvider = params.get("InternetServiceProvider")
        self._InternetChargeType = params.get("InternetChargeType")
        self._InternetMaxBandwidthOut = params.get("InternetMaxBandwidthOut")
        if params.get("AddressChargePrepaid") is not None:
            self._AddressChargePrepaid = AddressChargePrepaid()
            self._AddressChargePrepaid._deserialize(params.get("AddressChargePrepaid"))
        self._AddressType = params.get("AddressType")
        self._AnycastZone = params.get("AnycastZone")
        self._VipCluster = params.get("VipCluster")
        self._ApplicableForCLB = params.get("ApplicableForCLB")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._BandwidthPackageId = params.get("BandwidthPackageId")
        self._AddressName = params.get("AddressName")
        self._DedicatedClusterId = params.get("DedicatedClusterId")
        self._Egress = params.get("Egress")
        self._AntiDDoSPackageId = params.get("AntiDDoSPackageId")
        self._ClientToken = params.get("ClientToken")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AllocateAddressesResponse(AbstractModel):
    """AllocateAddresses返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AddressSet: 申请到的 EIP 的唯一 ID 列表。
        :type AddressSet: list of str
        :param _TaskId: 异步任务TaskId。可以使用[DescribeTaskResult](https://cloud.tencent.com/document/api/215/36271)接口查询任务状态。
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AddressSet = None
        self._TaskId = None
        self._RequestId = None

    @property
    def AddressSet(self):
        """申请到的 EIP 的唯一 ID 列表。
        :rtype: list of str
        """
        return self._AddressSet

    @AddressSet.setter
    def AddressSet(self, AddressSet):
        self._AddressSet = AddressSet

    @property
    def TaskId(self):
        """异步任务TaskId。可以使用[DescribeTaskResult](https://cloud.tencent.com/document/api/215/36271)接口查询任务状态。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AddressSet = params.get("AddressSet")
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class AllocateIp6AddressesBandwidthRequest(AbstractModel):
    """AllocateIp6AddressesBandwidth请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Ip6Addresses: 需要开通公网访问能力的IPV6地址
        :type Ip6Addresses: list of str
        :param _InternetMaxBandwidthOut: 带宽，单位Mbps。默认是1Mbps
        :type InternetMaxBandwidthOut: int
        :param _InternetChargeType: 网络计费模式。IPV6当前支持"TRAFFIC_POSTPAID_BY_HOUR"，"BANDWIDTH_PACKAGE"。默认网络计费模式是"TRAFFIC_POSTPAID_BY_HOUR"。
        :type InternetChargeType: str
        :param _BandwidthPackageId: 带宽包id，上移账号，申请带宽包计费模式的ipv6地址需要传入.
        :type BandwidthPackageId: str
        """
        self._Ip6Addresses = None
        self._InternetMaxBandwidthOut = None
        self._InternetChargeType = None
        self._BandwidthPackageId = None

    @property
    def Ip6Addresses(self):
        """需要开通公网访问能力的IPV6地址
        :rtype: list of str
        """
        return self._Ip6Addresses

    @Ip6Addresses.setter
    def Ip6Addresses(self, Ip6Addresses):
        self._Ip6Addresses = Ip6Addresses

    @property
    def InternetMaxBandwidthOut(self):
        """带宽，单位Mbps。默认是1Mbps
        :rtype: int
        """
        return self._InternetMaxBandwidthOut

    @InternetMaxBandwidthOut.setter
    def InternetMaxBandwidthOut(self, InternetMaxBandwidthOut):
        self._InternetMaxBandwidthOut = InternetMaxBandwidthOut

    @property
    def InternetChargeType(self):
        """网络计费模式。IPV6当前支持"TRAFFIC_POSTPAID_BY_HOUR"，"BANDWIDTH_PACKAGE"。默认网络计费模式是"TRAFFIC_POSTPAID_BY_HOUR"。
        :rtype: str
        """
        return self._InternetChargeType

    @InternetChargeType.setter
    def InternetChargeType(self, InternetChargeType):
        self._InternetChargeType = InternetChargeType

    @property
    def BandwidthPackageId(self):
        """带宽包id，上移账号，申请带宽包计费模式的ipv6地址需要传入.
        :rtype: str
        """
        return self._BandwidthPackageId

    @BandwidthPackageId.setter
    def BandwidthPackageId(self, BandwidthPackageId):
        self._BandwidthPackageId = BandwidthPackageId


    def _deserialize(self, params):
        self._Ip6Addresses = params.get("Ip6Addresses")
        self._InternetMaxBandwidthOut = params.get("InternetMaxBandwidthOut")
        self._InternetChargeType = params.get("InternetChargeType")
        self._BandwidthPackageId = params.get("BandwidthPackageId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AllocateIp6AddressesBandwidthResponse(AbstractModel):
    """AllocateIp6AddressesBandwidth返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AddressSet: 弹性公网 IPV6 的唯一 ID 列表。
        :type AddressSet: list of str
        :param _TaskId: 异步任务TaskId。可以使用[DescribeTaskResult](https://cloud.tencent.com/document/api/215/36271)接口查询任务状态。
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AddressSet = None
        self._TaskId = None
        self._RequestId = None

    @property
    def AddressSet(self):
        """弹性公网 IPV6 的唯一 ID 列表。
        :rtype: list of str
        """
        return self._AddressSet

    @AddressSet.setter
    def AddressSet(self, AddressSet):
        self._AddressSet = AddressSet

    @property
    def TaskId(self):
        """异步任务TaskId。可以使用[DescribeTaskResult](https://cloud.tencent.com/document/api/215/36271)接口查询任务状态。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AddressSet = params.get("AddressSet")
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class AssignIpv6AddressesRequest(AbstractModel):
    """AssignIpv6Addresses请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NetworkInterfaceId: 弹性网卡实例`ID`，形如：`eni-m6dyj72l`。
        :type NetworkInterfaceId: str
        :param _Ipv6Addresses: 指定的`IPv6`地址列表，单次最多指定10个。与入参`Ipv6AddressCount`合并计算配额。与Ipv6AddressCount必填一个。
        :type Ipv6Addresses: list of Ipv6Address
        :param _Ipv6AddressCount: 自动分配`IPv6`地址个数，内网IP地址个数总和不能超过配额数。与入参`Ipv6Addresses`合并计算配额。与Ipv6Addresses必填一个。
        :type Ipv6AddressCount: int
        :param _ClientToken: 用于保证请求幂等性的字符串。该字符串由客户生成，需保证不同请求之间唯一，最大值不超过64个ASCII字符。若不指定该参数，则无法保证请求的幂等性。
        :type ClientToken: str
        """
        self._NetworkInterfaceId = None
        self._Ipv6Addresses = None
        self._Ipv6AddressCount = None
        self._ClientToken = None

    @property
    def NetworkInterfaceId(self):
        """弹性网卡实例`ID`，形如：`eni-m6dyj72l`。
        :rtype: str
        """
        return self._NetworkInterfaceId

    @NetworkInterfaceId.setter
    def NetworkInterfaceId(self, NetworkInterfaceId):
        self._NetworkInterfaceId = NetworkInterfaceId

    @property
    def Ipv6Addresses(self):
        """指定的`IPv6`地址列表，单次最多指定10个。与入参`Ipv6AddressCount`合并计算配额。与Ipv6AddressCount必填一个。
        :rtype: list of Ipv6Address
        """
        return self._Ipv6Addresses

    @Ipv6Addresses.setter
    def Ipv6Addresses(self, Ipv6Addresses):
        self._Ipv6Addresses = Ipv6Addresses

    @property
    def Ipv6AddressCount(self):
        """自动分配`IPv6`地址个数，内网IP地址个数总和不能超过配额数。与入参`Ipv6Addresses`合并计算配额。与Ipv6Addresses必填一个。
        :rtype: int
        """
        return self._Ipv6AddressCount

    @Ipv6AddressCount.setter
    def Ipv6AddressCount(self, Ipv6AddressCount):
        self._Ipv6AddressCount = Ipv6AddressCount

    @property
    def ClientToken(self):
        """用于保证请求幂等性的字符串。该字符串由客户生成，需保证不同请求之间唯一，最大值不超过64个ASCII字符。若不指定该参数，则无法保证请求的幂等性。
        :rtype: str
        """
        return self._ClientToken

    @ClientToken.setter
    def ClientToken(self, ClientToken):
        self._ClientToken = ClientToken


    def _deserialize(self, params):
        self._NetworkInterfaceId = params.get("NetworkInterfaceId")
        if params.get("Ipv6Addresses") is not None:
            self._Ipv6Addresses = []
            for item in params.get("Ipv6Addresses"):
                obj = Ipv6Address()
                obj._deserialize(item)
                self._Ipv6Addresses.append(obj)
        self._Ipv6AddressCount = params.get("Ipv6AddressCount")
        self._ClientToken = params.get("ClientToken")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssignIpv6AddressesResponse(AbstractModel):
    """AssignIpv6Addresses返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Ipv6AddressSet: 分配给弹性网卡的`IPv6`地址列表。
        :type Ipv6AddressSet: list of Ipv6Address
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Ipv6AddressSet = None
        self._RequestId = None

    @property
    def Ipv6AddressSet(self):
        """分配给弹性网卡的`IPv6`地址列表。
        :rtype: list of Ipv6Address
        """
        return self._Ipv6AddressSet

    @Ipv6AddressSet.setter
    def Ipv6AddressSet(self, Ipv6AddressSet):
        self._Ipv6AddressSet = Ipv6AddressSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Ipv6AddressSet") is not None:
            self._Ipv6AddressSet = []
            for item in params.get("Ipv6AddressSet"):
                obj = Ipv6Address()
                obj._deserialize(item)
                self._Ipv6AddressSet.append(obj)
        self._RequestId = params.get("RequestId")


class AssignIpv6CidrBlockRequest(AbstractModel):
    """AssignIpv6CidrBlock请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VpcId: `VPC`实例`ID`，形如：`vpc-f49l6u0z`。
        :type VpcId: str
        """
        self._VpcId = None

    @property
    def VpcId(self):
        """`VPC`实例`ID`，形如：`vpc-f49l6u0z`。
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssignIpv6CidrBlockResponse(AbstractModel):
    """AssignIpv6CidrBlock返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Ipv6CidrBlock: 分配的 `IPv6` 网段。形如：`3402:4e00:20:1000::/56`。
        :type Ipv6CidrBlock: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Ipv6CidrBlock = None
        self._RequestId = None

    @property
    def Ipv6CidrBlock(self):
        """分配的 `IPv6` 网段。形如：`3402:4e00:20:1000::/56`。
        :rtype: str
        """
        return self._Ipv6CidrBlock

    @Ipv6CidrBlock.setter
    def Ipv6CidrBlock(self, Ipv6CidrBlock):
        self._Ipv6CidrBlock = Ipv6CidrBlock

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Ipv6CidrBlock = params.get("Ipv6CidrBlock")
        self._RequestId = params.get("RequestId")


class AssignIpv6SubnetCidrBlockRequest(AbstractModel):
    """AssignIpv6SubnetCidrBlock请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VpcId: 子网所在私有网络`ID`。形如：`vpc-f49l6u0z`。
        :type VpcId: str
        :param _Ipv6SubnetCidrBlocks: 分配 `IPv6` 子网段列表。
        :type Ipv6SubnetCidrBlocks: list of Ipv6SubnetCidrBlock
        :param _ClientToken: 用于保证请求幂等性的字符串。该字符串由客户生成，需保证不同请求之间唯一，最大值不超过64个ASCII字符。若不指定该参数，则无法保证请求的幂等性。
        :type ClientToken: str
        """
        self._VpcId = None
        self._Ipv6SubnetCidrBlocks = None
        self._ClientToken = None

    @property
    def VpcId(self):
        """子网所在私有网络`ID`。形如：`vpc-f49l6u0z`。
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def Ipv6SubnetCidrBlocks(self):
        """分配 `IPv6` 子网段列表。
        :rtype: list of Ipv6SubnetCidrBlock
        """
        return self._Ipv6SubnetCidrBlocks

    @Ipv6SubnetCidrBlocks.setter
    def Ipv6SubnetCidrBlocks(self, Ipv6SubnetCidrBlocks):
        self._Ipv6SubnetCidrBlocks = Ipv6SubnetCidrBlocks

    @property
    def ClientToken(self):
        """用于保证请求幂等性的字符串。该字符串由客户生成，需保证不同请求之间唯一，最大值不超过64个ASCII字符。若不指定该参数，则无法保证请求的幂等性。
        :rtype: str
        """
        return self._ClientToken

    @ClientToken.setter
    def ClientToken(self, ClientToken):
        self._ClientToken = ClientToken


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        if params.get("Ipv6SubnetCidrBlocks") is not None:
            self._Ipv6SubnetCidrBlocks = []
            for item in params.get("Ipv6SubnetCidrBlocks"):
                obj = Ipv6SubnetCidrBlock()
                obj._deserialize(item)
                self._Ipv6SubnetCidrBlocks.append(obj)
        self._ClientToken = params.get("ClientToken")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssignIpv6SubnetCidrBlockResponse(AbstractModel):
    """AssignIpv6SubnetCidrBlock返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Ipv6SubnetCidrBlockSet: 分配 `IPv6` 子网段列表。
        :type Ipv6SubnetCidrBlockSet: list of Ipv6SubnetCidrBlock
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Ipv6SubnetCidrBlockSet = None
        self._RequestId = None

    @property
    def Ipv6SubnetCidrBlockSet(self):
        """分配 `IPv6` 子网段列表。
        :rtype: list of Ipv6SubnetCidrBlock
        """
        return self._Ipv6SubnetCidrBlockSet

    @Ipv6SubnetCidrBlockSet.setter
    def Ipv6SubnetCidrBlockSet(self, Ipv6SubnetCidrBlockSet):
        self._Ipv6SubnetCidrBlockSet = Ipv6SubnetCidrBlockSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Ipv6SubnetCidrBlockSet") is not None:
            self._Ipv6SubnetCidrBlockSet = []
            for item in params.get("Ipv6SubnetCidrBlockSet"):
                obj = Ipv6SubnetCidrBlock()
                obj._deserialize(item)
                self._Ipv6SubnetCidrBlockSet.append(obj)
        self._RequestId = params.get("RequestId")


class AssignPrivateIpAddressesRequest(AbstractModel):
    """AssignPrivateIpAddresses请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NetworkInterfaceId: 弹性网卡实例ID，例如：eni-m6dyj72l。
        :type NetworkInterfaceId: str
        :param _PrivateIpAddresses: 指定的内网IP信息，单次最多指定10个。与SecondaryPrivateIpAddressCount至少提供一个。
        :type PrivateIpAddresses: list of PrivateIpAddressSpecification
        :param _SecondaryPrivateIpAddressCount: 新申请的内网IP地址个数，与PrivateIpAddresses至少提供一个。内网IP地址个数总和不能超过配额数，详见<a href="/document/product/576/18527">弹性网卡使用限制</a>。
        :type SecondaryPrivateIpAddressCount: int
        :param _QosLevel: IP服务质量等级，和SecondaryPrivateIpAddressCount配合使用，可选值：PT、AU、AG、DEFAULT，分别代表云金、云银、云铜、默认四个等级。
        :type QosLevel: str
        :param _ClientToken: 用于保证请求幂等性的字符串。该字符串由客户生成，需保证不同请求之间唯一，最大值不超过64个ASCII字符。若不指定该参数，则无法保证请求的幂等性。
        :type ClientToken: str
        """
        self._NetworkInterfaceId = None
        self._PrivateIpAddresses = None
        self._SecondaryPrivateIpAddressCount = None
        self._QosLevel = None
        self._ClientToken = None

    @property
    def NetworkInterfaceId(self):
        """弹性网卡实例ID，例如：eni-m6dyj72l。
        :rtype: str
        """
        return self._NetworkInterfaceId

    @NetworkInterfaceId.setter
    def NetworkInterfaceId(self, NetworkInterfaceId):
        self._NetworkInterfaceId = NetworkInterfaceId

    @property
    def PrivateIpAddresses(self):
        """指定的内网IP信息，单次最多指定10个。与SecondaryPrivateIpAddressCount至少提供一个。
        :rtype: list of PrivateIpAddressSpecification
        """
        return self._PrivateIpAddresses

    @PrivateIpAddresses.setter
    def PrivateIpAddresses(self, PrivateIpAddresses):
        self._PrivateIpAddresses = PrivateIpAddresses

    @property
    def SecondaryPrivateIpAddressCount(self):
        """新申请的内网IP地址个数，与PrivateIpAddresses至少提供一个。内网IP地址个数总和不能超过配额数，详见<a href="/document/product/576/18527">弹性网卡使用限制</a>。
        :rtype: int
        """
        return self._SecondaryPrivateIpAddressCount

    @SecondaryPrivateIpAddressCount.setter
    def SecondaryPrivateIpAddressCount(self, SecondaryPrivateIpAddressCount):
        self._SecondaryPrivateIpAddressCount = SecondaryPrivateIpAddressCount

    @property
    def QosLevel(self):
        """IP服务质量等级，和SecondaryPrivateIpAddressCount配合使用，可选值：PT、AU、AG、DEFAULT，分别代表云金、云银、云铜、默认四个等级。
        :rtype: str
        """
        return self._QosLevel

    @QosLevel.setter
    def QosLevel(self, QosLevel):
        self._QosLevel = QosLevel

    @property
    def ClientToken(self):
        """用于保证请求幂等性的字符串。该字符串由客户生成，需保证不同请求之间唯一，最大值不超过64个ASCII字符。若不指定该参数，则无法保证请求的幂等性。
        :rtype: str
        """
        return self._ClientToken

    @ClientToken.setter
    def ClientToken(self, ClientToken):
        self._ClientToken = ClientToken


    def _deserialize(self, params):
        self._NetworkInterfaceId = params.get("NetworkInterfaceId")
        if params.get("PrivateIpAddresses") is not None:
            self._PrivateIpAddresses = []
            for item in params.get("PrivateIpAddresses"):
                obj = PrivateIpAddressSpecification()
                obj._deserialize(item)
                self._PrivateIpAddresses.append(obj)
        self._SecondaryPrivateIpAddressCount = params.get("SecondaryPrivateIpAddressCount")
        self._QosLevel = params.get("QosLevel")
        self._ClientToken = params.get("ClientToken")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssignPrivateIpAddressesResponse(AbstractModel):
    """AssignPrivateIpAddresses返回参数结构体

    """

    def __init__(self):
        r"""
        :param _PrivateIpAddressSet: 内网IP详细信息。
        :type PrivateIpAddressSet: list of PrivateIpAddressSpecification
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._PrivateIpAddressSet = None
        self._RequestId = None

    @property
    def PrivateIpAddressSet(self):
        """内网IP详细信息。
        :rtype: list of PrivateIpAddressSpecification
        """
        return self._PrivateIpAddressSet

    @PrivateIpAddressSet.setter
    def PrivateIpAddressSet(self, PrivateIpAddressSet):
        self._PrivateIpAddressSet = PrivateIpAddressSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("PrivateIpAddressSet") is not None:
            self._PrivateIpAddressSet = []
            for item in params.get("PrivateIpAddressSet"):
                obj = PrivateIpAddressSpecification()
                obj._deserialize(item)
                self._PrivateIpAddressSet.append(obj)
        self._RequestId = params.get("RequestId")


class AssistantCidr(AbstractModel):
    """VPC辅助CIDR信息。

    """

    def __init__(self):
        r"""
        :param _VpcId: `VPC`实例`ID`。形如：`vpc-6v2ht8q5`
        :type VpcId: str
        :param _CidrBlock: 辅助CIDR。形如：`172.16.0.0/16`
        :type CidrBlock: str
        :param _AssistantType: 辅助CIDR类型（0：普通辅助CIDR，1：容器辅助CIDR），默认都是0。
        :type AssistantType: int
        :param _SubnetSet: 辅助CIDR拆分的子网。
注意：此字段可能返回 null，表示取不到有效值。
        :type SubnetSet: list of Subnet
        """
        self._VpcId = None
        self._CidrBlock = None
        self._AssistantType = None
        self._SubnetSet = None

    @property
    def VpcId(self):
        """`VPC`实例`ID`。形如：`vpc-6v2ht8q5`
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def CidrBlock(self):
        """辅助CIDR。形如：`172.16.0.0/16`
        :rtype: str
        """
        return self._CidrBlock

    @CidrBlock.setter
    def CidrBlock(self, CidrBlock):
        self._CidrBlock = CidrBlock

    @property
    def AssistantType(self):
        """辅助CIDR类型（0：普通辅助CIDR，1：容器辅助CIDR），默认都是0。
        :rtype: int
        """
        return self._AssistantType

    @AssistantType.setter
    def AssistantType(self, AssistantType):
        self._AssistantType = AssistantType

    @property
    def SubnetSet(self):
        """辅助CIDR拆分的子网。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of Subnet
        """
        return self._SubnetSet

    @SubnetSet.setter
    def SubnetSet(self, SubnetSet):
        self._SubnetSet = SubnetSet


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._CidrBlock = params.get("CidrBlock")
        self._AssistantType = params.get("AssistantType")
        if params.get("SubnetSet") is not None:
            self._SubnetSet = []
            for item in params.get("SubnetSet"):
                obj = Subnet()
                obj._deserialize(item)
                self._SubnetSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssociateAddressRequest(AbstractModel):
    """AssociateAddress请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AddressId: 标识 EIP 的唯一 ID。EIP 唯一 ID 形如：`eip-11112222`。
        :type AddressId: str
        :param _InstanceId: 要绑定的实例 ID。实例 ID 形如：`ins-11112222`、`lb-11112222`。可通过登录[控制台](https://console.cloud.tencent.com/cvm)查询，也可通过 [DescribeInstances](https://cloud.tencent.com/document/api/213/15728) 接口返回值中的`InstanceId`获取。
        :type InstanceId: str
        :param _NetworkInterfaceId: 要绑定的弹性网卡 ID。 弹性网卡 ID 形如：`eni-11112222`。`NetworkInterfaceId` 与 `InstanceId` 不可同时指定。弹性网卡 ID 可通过登录[控制台](https://console.cloud.tencent.com/vpc/eni)查询，也可通过[DescribeNetworkInterfaces](https://cloud.tencent.com/document/api/215/15817)接口返回值中的`networkInterfaceId`获取。
        :type NetworkInterfaceId: str
        :param _PrivateIpAddress: 要绑定的内网 IP。如果指定了 `NetworkInterfaceId` 则也必须指定 `PrivateIpAddress` ，表示将 EIP 绑定到指定弹性网卡的指定内网 IP 上。同时要确保指定的 `PrivateIpAddress` 是指定的 `NetworkInterfaceId` 上的一个内网 IP。指定弹性网卡的内网 IP 可通过登录[控制台](https://console.cloud.tencent.com/vpc/eni)查询，也可通过[DescribeNetworkInterfaces](https://cloud.tencent.com/document/api/215/15817)接口返回值中的`privateIpAddress`获取。
        :type PrivateIpAddress: str
        :param _EipDirectConnection: 指定绑定时是否设置直通。弹性公网 IP 直通请参见 [EIP 直通](https://cloud.tencent.com/document/product/1199/41709)。取值：True、False，默认值为 False。当绑定 CVM 实例、EKS 弹性集群时，可设定此参数为 True。此参数目前处于内测中，如需使用，请提交 [工单申请](https://console.cloud.tencent.com/workorder/category?level1_id=6&level2_id=163&source=0&data_title=%E8%B4%9F%E8%BD%BD%E5%9D%87%E8%A1%A1%20CLB&level3_id=1071&queue=96&scene_code=34639&step=2)。
        :type EipDirectConnection: bool
        :param _InstanceRegion: 要绑定的实例所在的地域
        :type InstanceRegion: str
        """
        self._AddressId = None
        self._InstanceId = None
        self._NetworkInterfaceId = None
        self._PrivateIpAddress = None
        self._EipDirectConnection = None
        self._InstanceRegion = None

    @property
    def AddressId(self):
        """标识 EIP 的唯一 ID。EIP 唯一 ID 形如：`eip-11112222`。
        :rtype: str
        """
        return self._AddressId

    @AddressId.setter
    def AddressId(self, AddressId):
        self._AddressId = AddressId

    @property
    def InstanceId(self):
        """要绑定的实例 ID。实例 ID 形如：`ins-11112222`、`lb-11112222`。可通过登录[控制台](https://console.cloud.tencent.com/cvm)查询，也可通过 [DescribeInstances](https://cloud.tencent.com/document/api/213/15728) 接口返回值中的`InstanceId`获取。
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def NetworkInterfaceId(self):
        """要绑定的弹性网卡 ID。 弹性网卡 ID 形如：`eni-11112222`。`NetworkInterfaceId` 与 `InstanceId` 不可同时指定。弹性网卡 ID 可通过登录[控制台](https://console.cloud.tencent.com/vpc/eni)查询，也可通过[DescribeNetworkInterfaces](https://cloud.tencent.com/document/api/215/15817)接口返回值中的`networkInterfaceId`获取。
        :rtype: str
        """
        return self._NetworkInterfaceId

    @NetworkInterfaceId.setter
    def NetworkInterfaceId(self, NetworkInterfaceId):
        self._NetworkInterfaceId = NetworkInterfaceId

    @property
    def PrivateIpAddress(self):
        """要绑定的内网 IP。如果指定了 `NetworkInterfaceId` 则也必须指定 `PrivateIpAddress` ，表示将 EIP 绑定到指定弹性网卡的指定内网 IP 上。同时要确保指定的 `PrivateIpAddress` 是指定的 `NetworkInterfaceId` 上的一个内网 IP。指定弹性网卡的内网 IP 可通过登录[控制台](https://console.cloud.tencent.com/vpc/eni)查询，也可通过[DescribeNetworkInterfaces](https://cloud.tencent.com/document/api/215/15817)接口返回值中的`privateIpAddress`获取。
        :rtype: str
        """
        return self._PrivateIpAddress

    @PrivateIpAddress.setter
    def PrivateIpAddress(self, PrivateIpAddress):
        self._PrivateIpAddress = PrivateIpAddress

    @property
    def EipDirectConnection(self):
        """指定绑定时是否设置直通。弹性公网 IP 直通请参见 [EIP 直通](https://cloud.tencent.com/document/product/1199/41709)。取值：True、False，默认值为 False。当绑定 CVM 实例、EKS 弹性集群时，可设定此参数为 True。此参数目前处于内测中，如需使用，请提交 [工单申请](https://console.cloud.tencent.com/workorder/category?level1_id=6&level2_id=163&source=0&data_title=%E8%B4%9F%E8%BD%BD%E5%9D%87%E8%A1%A1%20CLB&level3_id=1071&queue=96&scene_code=34639&step=2)。
        :rtype: bool
        """
        return self._EipDirectConnection

    @EipDirectConnection.setter
    def EipDirectConnection(self, EipDirectConnection):
        self._EipDirectConnection = EipDirectConnection

    @property
    def InstanceRegion(self):
        """要绑定的实例所在的地域
        :rtype: str
        """
        return self._InstanceRegion

    @InstanceRegion.setter
    def InstanceRegion(self, InstanceRegion):
        self._InstanceRegion = InstanceRegion


    def _deserialize(self, params):
        self._AddressId = params.get("AddressId")
        self._InstanceId = params.get("InstanceId")
        self._NetworkInterfaceId = params.get("NetworkInterfaceId")
        self._PrivateIpAddress = params.get("PrivateIpAddress")
        self._EipDirectConnection = params.get("EipDirectConnection")
        self._InstanceRegion = params.get("InstanceRegion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssociateAddressResponse(AbstractModel):
    """AssociateAddress返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 异步任务TaskId。可以使用[DescribeTaskResult](https://cloud.tencent.com/document/api/215/36271)接口查询任务状态。
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        """异步任务TaskId。可以使用[DescribeTaskResult](https://cloud.tencent.com/document/api/215/36271)接口查询任务状态。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class AssociateDhcpIpWithAddressIpRequest(AbstractModel):
    """AssociateDhcpIpWithAddressIp请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DhcpIpId: `DhcpIp`唯一`ID`，形如：`dhcpip-9o233uri`。必须是没有绑定`EIP`的`DhcpIp`
        :type DhcpIpId: str
        :param _AddressIp: 弹性公网`IP`。必须是没有绑定`DhcpIp`的`EIP`
        :type AddressIp: str
        """
        self._DhcpIpId = None
        self._AddressIp = None

    @property
    def DhcpIpId(self):
        """`DhcpIp`唯一`ID`，形如：`dhcpip-9o233uri`。必须是没有绑定`EIP`的`DhcpIp`
        :rtype: str
        """
        return self._DhcpIpId

    @DhcpIpId.setter
    def DhcpIpId(self, DhcpIpId):
        self._DhcpIpId = DhcpIpId

    @property
    def AddressIp(self):
        """弹性公网`IP`。必须是没有绑定`DhcpIp`的`EIP`
        :rtype: str
        """
        return self._AddressIp

    @AddressIp.setter
    def AddressIp(self, AddressIp):
        self._AddressIp = AddressIp


    def _deserialize(self, params):
        self._DhcpIpId = params.get("DhcpIpId")
        self._AddressIp = params.get("AddressIp")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssociateDhcpIpWithAddressIpResponse(AbstractModel):
    """AssociateDhcpIpWithAddressIp返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AssociateDirectConnectGatewayNatGatewayRequest(AbstractModel):
    """AssociateDirectConnectGatewayNatGateway请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VpcId: VPC实例ID。形如：vpc-xxx。
        :type VpcId: str
        :param _NatGatewayId: NAT网关ID。形如：nat-xxx
        :type NatGatewayId: str
        :param _DirectConnectGatewayId: 专线网关ID。形如：dcg-xxx
        :type DirectConnectGatewayId: str
        """
        self._VpcId = None
        self._NatGatewayId = None
        self._DirectConnectGatewayId = None

    @property
    def VpcId(self):
        """VPC实例ID。形如：vpc-xxx。
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def NatGatewayId(self):
        """NAT网关ID。形如：nat-xxx
        :rtype: str
        """
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId

    @property
    def DirectConnectGatewayId(self):
        """专线网关ID。形如：dcg-xxx
        :rtype: str
        """
        return self._DirectConnectGatewayId

    @DirectConnectGatewayId.setter
    def DirectConnectGatewayId(self, DirectConnectGatewayId):
        self._DirectConnectGatewayId = DirectConnectGatewayId


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._NatGatewayId = params.get("NatGatewayId")
        self._DirectConnectGatewayId = params.get("DirectConnectGatewayId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssociateDirectConnectGatewayNatGatewayResponse(AbstractModel):
    """AssociateDirectConnectGatewayNatGateway返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AssociateInstancesToCcnRouteTableRequest(AbstractModel):
    """AssociateInstancesToCcnRouteTable请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CcnId: 云联网ID。
        :type CcnId: str
        :param _RouteTableId: 路由表ID。
        :type RouteTableId: str
        :param _Instances: 实例列表。
        :type Instances: list of CcnInstanceWithoutRegion
        """
        self._CcnId = None
        self._RouteTableId = None
        self._Instances = None

    @property
    def CcnId(self):
        """云联网ID。
        :rtype: str
        """
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId

    @property
    def RouteTableId(self):
        """路由表ID。
        :rtype: str
        """
        return self._RouteTableId

    @RouteTableId.setter
    def RouteTableId(self, RouteTableId):
        self._RouteTableId = RouteTableId

    @property
    def Instances(self):
        """实例列表。
        :rtype: list of CcnInstanceWithoutRegion
        """
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances


    def _deserialize(self, params):
        self._CcnId = params.get("CcnId")
        self._RouteTableId = params.get("RouteTableId")
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = CcnInstanceWithoutRegion()
                obj._deserialize(item)
                self._Instances.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssociateInstancesToCcnRouteTableResponse(AbstractModel):
    """AssociateInstancesToCcnRouteTable返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AssociateNatGatewayAddressRequest(AbstractModel):
    """AssociateNatGatewayAddress请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NatGatewayId: NAT网关的ID，形如：`nat-df45454`。
        :type NatGatewayId: str
        :param _AddressCount: 需要申请的弹性IP个数，系统会按您的要求生产N个弹性IP, 其中AddressCount和PublicAddresses至少传递一个。
        :type AddressCount: int
        :param _PublicIpAddresses: 绑定NAT网关的弹性IP数组，其中AddressCount和PublicAddresses至少传递一个。
        :type PublicIpAddresses: list of str
        :param _Zone: 弹性IP可用区，自动分配弹性IP时传递。
        :type Zone: str
        :param _StockPublicIpAddressesBandwidthOut: 绑定NAT网关的弹性IP带宽大小（单位Mbps），默认为当前用户类型所能使用的最大值。
        :type StockPublicIpAddressesBandwidthOut: int
        :param _PublicIpAddressesBandwidthOut: 需要申请公网IP带宽大小（单位Mbps），默认为当前用户类型所能使用的最大值。
        :type PublicIpAddressesBandwidthOut: int
        :param _PublicIpFromSameZone: 公网IP是否强制与NAT网关来自同可用区，true表示需要与NAT网关同可用区；false表示可与NAT网关不是同一个可用区。此参数只有当参数Zone存在时才能生效。
        :type PublicIpFromSameZone: bool
        """
        self._NatGatewayId = None
        self._AddressCount = None
        self._PublicIpAddresses = None
        self._Zone = None
        self._StockPublicIpAddressesBandwidthOut = None
        self._PublicIpAddressesBandwidthOut = None
        self._PublicIpFromSameZone = None

    @property
    def NatGatewayId(self):
        """NAT网关的ID，形如：`nat-df45454`。
        :rtype: str
        """
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId

    @property
    def AddressCount(self):
        """需要申请的弹性IP个数，系统会按您的要求生产N个弹性IP, 其中AddressCount和PublicAddresses至少传递一个。
        :rtype: int
        """
        return self._AddressCount

    @AddressCount.setter
    def AddressCount(self, AddressCount):
        self._AddressCount = AddressCount

    @property
    def PublicIpAddresses(self):
        """绑定NAT网关的弹性IP数组，其中AddressCount和PublicAddresses至少传递一个。
        :rtype: list of str
        """
        return self._PublicIpAddresses

    @PublicIpAddresses.setter
    def PublicIpAddresses(self, PublicIpAddresses):
        self._PublicIpAddresses = PublicIpAddresses

    @property
    def Zone(self):
        """弹性IP可用区，自动分配弹性IP时传递。
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def StockPublicIpAddressesBandwidthOut(self):
        """绑定NAT网关的弹性IP带宽大小（单位Mbps），默认为当前用户类型所能使用的最大值。
        :rtype: int
        """
        return self._StockPublicIpAddressesBandwidthOut

    @StockPublicIpAddressesBandwidthOut.setter
    def StockPublicIpAddressesBandwidthOut(self, StockPublicIpAddressesBandwidthOut):
        self._StockPublicIpAddressesBandwidthOut = StockPublicIpAddressesBandwidthOut

    @property
    def PublicIpAddressesBandwidthOut(self):
        """需要申请公网IP带宽大小（单位Mbps），默认为当前用户类型所能使用的最大值。
        :rtype: int
        """
        return self._PublicIpAddressesBandwidthOut

    @PublicIpAddressesBandwidthOut.setter
    def PublicIpAddressesBandwidthOut(self, PublicIpAddressesBandwidthOut):
        self._PublicIpAddressesBandwidthOut = PublicIpAddressesBandwidthOut

    @property
    def PublicIpFromSameZone(self):
        """公网IP是否强制与NAT网关来自同可用区，true表示需要与NAT网关同可用区；false表示可与NAT网关不是同一个可用区。此参数只有当参数Zone存在时才能生效。
        :rtype: bool
        """
        return self._PublicIpFromSameZone

    @PublicIpFromSameZone.setter
    def PublicIpFromSameZone(self, PublicIpFromSameZone):
        self._PublicIpFromSameZone = PublicIpFromSameZone


    def _deserialize(self, params):
        self._NatGatewayId = params.get("NatGatewayId")
        self._AddressCount = params.get("AddressCount")
        self._PublicIpAddresses = params.get("PublicIpAddresses")
        self._Zone = params.get("Zone")
        self._StockPublicIpAddressesBandwidthOut = params.get("StockPublicIpAddressesBandwidthOut")
        self._PublicIpAddressesBandwidthOut = params.get("PublicIpAddressesBandwidthOut")
        self._PublicIpFromSameZone = params.get("PublicIpFromSameZone")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssociateNatGatewayAddressResponse(AbstractModel):
    """AssociateNatGatewayAddress返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AssociateNetworkAclSubnetsRequest(AbstractModel):
    """AssociateNetworkAclSubnets请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NetworkAclId: 网络ACL实例ID。例如：acl-12345678。
        :type NetworkAclId: str
        :param _SubnetIds: 子网实例ID数组。例如：[subnet-12345678]。
        :type SubnetIds: list of str
        """
        self._NetworkAclId = None
        self._SubnetIds = None

    @property
    def NetworkAclId(self):
        """网络ACL实例ID。例如：acl-12345678。
        :rtype: str
        """
        return self._NetworkAclId

    @NetworkAclId.setter
    def NetworkAclId(self, NetworkAclId):
        self._NetworkAclId = NetworkAclId

    @property
    def SubnetIds(self):
        """子网实例ID数组。例如：[subnet-12345678]。
        :rtype: list of str
        """
        return self._SubnetIds

    @SubnetIds.setter
    def SubnetIds(self, SubnetIds):
        self._SubnetIds = SubnetIds


    def _deserialize(self, params):
        self._NetworkAclId = params.get("NetworkAclId")
        self._SubnetIds = params.get("SubnetIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssociateNetworkAclSubnetsResponse(AbstractModel):
    """AssociateNetworkAclSubnets返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AssociateNetworkInterfaceSecurityGroupsRequest(AbstractModel):
    """AssociateNetworkInterfaceSecurityGroups请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NetworkInterfaceIds: 弹性网卡实例ID。形如：eni-pxir56ns。每次请求的实例的上限为100。本接口不支持主网卡绑定安全组。
        :type NetworkInterfaceIds: list of str
        :param _SecurityGroupIds: 安全组实例ID，例如：sg-33ocnj9n，可通过DescribeSecurityGroups获取。每次请求的实例的上限为100。
        :type SecurityGroupIds: list of str
        """
        self._NetworkInterfaceIds = None
        self._SecurityGroupIds = None

    @property
    def NetworkInterfaceIds(self):
        """弹性网卡实例ID。形如：eni-pxir56ns。每次请求的实例的上限为100。本接口不支持主网卡绑定安全组。
        :rtype: list of str
        """
        return self._NetworkInterfaceIds

    @NetworkInterfaceIds.setter
    def NetworkInterfaceIds(self, NetworkInterfaceIds):
        self._NetworkInterfaceIds = NetworkInterfaceIds

    @property
    def SecurityGroupIds(self):
        """安全组实例ID，例如：sg-33ocnj9n，可通过DescribeSecurityGroups获取。每次请求的实例的上限为100。
        :rtype: list of str
        """
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds


    def _deserialize(self, params):
        self._NetworkInterfaceIds = params.get("NetworkInterfaceIds")
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssociateNetworkInterfaceSecurityGroupsResponse(AbstractModel):
    """AssociateNetworkInterfaceSecurityGroups返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AttachCcnInstancesRequest(AbstractModel):
    """AttachCcnInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CcnId: CCN实例ID。形如：ccn-f49l6u0z。
        :type CcnId: str
        :param _Instances: 关联网络实例列表
        :type Instances: list of CcnInstance
        :param _CcnUin: CCN所属UIN（根账号），默认当前账号所属UIN
        :type CcnUin: str
        """
        self._CcnId = None
        self._Instances = None
        self._CcnUin = None

    @property
    def CcnId(self):
        """CCN实例ID。形如：ccn-f49l6u0z。
        :rtype: str
        """
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId

    @property
    def Instances(self):
        """关联网络实例列表
        :rtype: list of CcnInstance
        """
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances

    @property
    def CcnUin(self):
        """CCN所属UIN（根账号），默认当前账号所属UIN
        :rtype: str
        """
        return self._CcnUin

    @CcnUin.setter
    def CcnUin(self, CcnUin):
        self._CcnUin = CcnUin


    def _deserialize(self, params):
        self._CcnId = params.get("CcnId")
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = CcnInstance()
                obj._deserialize(item)
                self._Instances.append(obj)
        self._CcnUin = params.get("CcnUin")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AttachCcnInstancesResponse(AbstractModel):
    """AttachCcnInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AttachClassicLinkVpcRequest(AbstractModel):
    """AttachClassicLinkVpc请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VpcId: VPC实例ID
        :type VpcId: str
        :param _InstanceIds: CVM实例ID
        :type InstanceIds: list of str
        """
        self._VpcId = None
        self._InstanceIds = None

    @property
    def VpcId(self):
        """VPC实例ID
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def InstanceIds(self):
        """CVM实例ID
        :rtype: list of str
        """
        return self._InstanceIds

    @InstanceIds.setter
    def InstanceIds(self, InstanceIds):
        self._InstanceIds = InstanceIds


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._InstanceIds = params.get("InstanceIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AttachClassicLinkVpcResponse(AbstractModel):
    """AttachClassicLinkVpc返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AttachNetworkInterfaceRequest(AbstractModel):
    """AttachNetworkInterface请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NetworkInterfaceId: 弹性网卡实例ID，例如：eni-m6dyj72l。
        :type NetworkInterfaceId: str
        :param _InstanceId: CVM实例ID。形如：ins-r8hr2upy。
        :type InstanceId: str
        :param _AttachType: 网卡的挂载类型：0 标准型，1扩展型，默认值0。
        :type AttachType: int
        :param _ClientToken: 用于保证请求幂等性的字符串。该字符串由客户生成，需保证不同请求之间唯一，最大值不超过64个ASCII字符。若不指定该参数，则无法保证请求的幂等性。	
        :type ClientToken: str
        """
        self._NetworkInterfaceId = None
        self._InstanceId = None
        self._AttachType = None
        self._ClientToken = None

    @property
    def NetworkInterfaceId(self):
        """弹性网卡实例ID，例如：eni-m6dyj72l。
        :rtype: str
        """
        return self._NetworkInterfaceId

    @NetworkInterfaceId.setter
    def NetworkInterfaceId(self, NetworkInterfaceId):
        self._NetworkInterfaceId = NetworkInterfaceId

    @property
    def InstanceId(self):
        """CVM实例ID。形如：ins-r8hr2upy。
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def AttachType(self):
        """网卡的挂载类型：0 标准型，1扩展型，默认值0。
        :rtype: int
        """
        return self._AttachType

    @AttachType.setter
    def AttachType(self, AttachType):
        self._AttachType = AttachType

    @property
    def ClientToken(self):
        """用于保证请求幂等性的字符串。该字符串由客户生成，需保证不同请求之间唯一，最大值不超过64个ASCII字符。若不指定该参数，则无法保证请求的幂等性。	
        :rtype: str
        """
        return self._ClientToken

    @ClientToken.setter
    def ClientToken(self, ClientToken):
        self._ClientToken = ClientToken


    def _deserialize(self, params):
        self._NetworkInterfaceId = params.get("NetworkInterfaceId")
        self._InstanceId = params.get("InstanceId")
        self._AttachType = params.get("AttachType")
        self._ClientToken = params.get("ClientToken")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AttachNetworkInterfaceResponse(AbstractModel):
    """AttachNetworkInterface返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AttachSnapshotInstancesRequest(AbstractModel):
    """AttachSnapshotInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SnapshotPolicyId: 快照策略Id。
        :type SnapshotPolicyId: str
        :param _Instances: 关联实例信息。
        :type Instances: list of SnapshotInstance
        """
        self._SnapshotPolicyId = None
        self._Instances = None

    @property
    def SnapshotPolicyId(self):
        """快照策略Id。
        :rtype: str
        """
        return self._SnapshotPolicyId

    @SnapshotPolicyId.setter
    def SnapshotPolicyId(self, SnapshotPolicyId):
        self._SnapshotPolicyId = SnapshotPolicyId

    @property
    def Instances(self):
        """关联实例信息。
        :rtype: list of SnapshotInstance
        """
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances


    def _deserialize(self, params):
        self._SnapshotPolicyId = params.get("SnapshotPolicyId")
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = SnapshotInstance()
                obj._deserialize(item)
                self._Instances.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AttachSnapshotInstancesResponse(AbstractModel):
    """AttachSnapshotInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AuditCrossBorderComplianceRequest(AbstractModel):
    """AuditCrossBorderCompliance请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ServiceProvider: 服务商, 可选值：`UNICOM`。
        :type ServiceProvider: str
        :param _ComplianceId: 表单唯一`ID`。可通过[DescribeCrossBorderCompliance](https://cloud.tencent.com/document/product/215/47838)接口查询ComplianceId信息
        :type ComplianceId: int
        :param _AuditBehavior: 通过：`APPROVED `，拒绝：`DENY`。
        :type AuditBehavior: str
        """
        self._ServiceProvider = None
        self._ComplianceId = None
        self._AuditBehavior = None

    @property
    def ServiceProvider(self):
        """服务商, 可选值：`UNICOM`。
        :rtype: str
        """
        return self._ServiceProvider

    @ServiceProvider.setter
    def ServiceProvider(self, ServiceProvider):
        self._ServiceProvider = ServiceProvider

    @property
    def ComplianceId(self):
        """表单唯一`ID`。可通过[DescribeCrossBorderCompliance](https://cloud.tencent.com/document/product/215/47838)接口查询ComplianceId信息
        :rtype: int
        """
        return self._ComplianceId

    @ComplianceId.setter
    def ComplianceId(self, ComplianceId):
        self._ComplianceId = ComplianceId

    @property
    def AuditBehavior(self):
        """通过：`APPROVED `，拒绝：`DENY`。
        :rtype: str
        """
        return self._AuditBehavior

    @AuditBehavior.setter
    def AuditBehavior(self, AuditBehavior):
        self._AuditBehavior = AuditBehavior


    def _deserialize(self, params):
        self._ServiceProvider = params.get("ServiceProvider")
        self._ComplianceId = params.get("ComplianceId")
        self._AuditBehavior = params.get("AuditBehavior")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AuditCrossBorderComplianceResponse(AbstractModel):
    """AuditCrossBorderCompliance返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class BackupPolicy(AbstractModel):
    """时间备份策略详情

    """

    def __init__(self):
        r"""
        :param _BackupDay: 备份周期时间，取值为monday, tuesday, wednesday, thursday, friday, saturday, sunday。
        :type BackupDay: str
        :param _BackupTime: 备份时间点，格式：HH:mm:ss。
        :type BackupTime: str
        """
        self._BackupDay = None
        self._BackupTime = None

    @property
    def BackupDay(self):
        """备份周期时间，取值为monday, tuesday, wednesday, thursday, friday, saturday, sunday。
        :rtype: str
        """
        return self._BackupDay

    @BackupDay.setter
    def BackupDay(self, BackupDay):
        self._BackupDay = BackupDay

    @property
    def BackupTime(self):
        """备份时间点，格式：HH:mm:ss。
        :rtype: str
        """
        return self._BackupTime

    @BackupTime.setter
    def BackupTime(self, BackupTime):
        self._BackupTime = BackupTime


    def _deserialize(self, params):
        self._BackupDay = params.get("BackupDay")
        self._BackupTime = params.get("BackupTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BandwidthPackage(AbstractModel):
    """描述带宽包信息的结构

    """

    def __init__(self):
        r"""
        :param _BandwidthPackageId: 带宽包唯一标识Id
        :type BandwidthPackageId: str
        :param _NetworkType: 带宽包类型，包括'BGP','SINGLEISP','ANYCAST','SINGLEISP_CMCC','SINGLEISP_CTCC','SINGLEISP_CUCC'
        :type NetworkType: str
        :param _ChargeType: 带宽包计费类型，包括:<li>'TOP5_POSTPAID_BY_MONTH':按月后付费TOP5计费</li><li> 'PERCENT95_POSTPAID_BY_MONTH':按月后付费月95计费</li><li>'ENHANCED95_POSTPAID_BY_MONTH':按月后付费增强型95计费</li><li>'FIXED_PREPAID_BY_MONTH':包月预付费计费</li><li>‘PEAK_BANDWIDTH_POSTPAID_BY_DAY’: 后付费日结按带宽计费</li>

        :type ChargeType: str
        :param _BandwidthPackageName: 带宽包名称
        :type BandwidthPackageName: str
        :param _CreatedTime: 带宽包创建时间。按照`ISO8601`标准表示，并且使用`UTC`时间。格式为：`YYYY-MM-DDThh:mm:ssZ`。
        :type CreatedTime: str
        :param _Status: 带宽包状态，包括'CREATING','CREATED','DELETING','DELETED'
        :type Status: str
        :param _ResourceSet: 带宽包资源信息
        :type ResourceSet: list of Resource
        :param _Bandwidth: 带宽包限速大小。单位：Mbps，-1表示不限速。
        :type Bandwidth: int
        :param _Egress: 网络出口
注意：此字段可能返回 null，表示取不到有效值。
        :type Egress: str
        :param _Deadline: 带宽包到期时间，只有预付费会返回，按量计费返回为null
注意：此字段可能返回 null，表示取不到有效值。
        :type Deadline: str
        """
        self._BandwidthPackageId = None
        self._NetworkType = None
        self._ChargeType = None
        self._BandwidthPackageName = None
        self._CreatedTime = None
        self._Status = None
        self._ResourceSet = None
        self._Bandwidth = None
        self._Egress = None
        self._Deadline = None

    @property
    def BandwidthPackageId(self):
        """带宽包唯一标识Id
        :rtype: str
        """
        return self._BandwidthPackageId

    @BandwidthPackageId.setter
    def BandwidthPackageId(self, BandwidthPackageId):
        self._BandwidthPackageId = BandwidthPackageId

    @property
    def NetworkType(self):
        """带宽包类型，包括'BGP','SINGLEISP','ANYCAST','SINGLEISP_CMCC','SINGLEISP_CTCC','SINGLEISP_CUCC'
        :rtype: str
        """
        return self._NetworkType

    @NetworkType.setter
    def NetworkType(self, NetworkType):
        self._NetworkType = NetworkType

    @property
    def ChargeType(self):
        """带宽包计费类型，包括:<li>'TOP5_POSTPAID_BY_MONTH':按月后付费TOP5计费</li><li> 'PERCENT95_POSTPAID_BY_MONTH':按月后付费月95计费</li><li>'ENHANCED95_POSTPAID_BY_MONTH':按月后付费增强型95计费</li><li>'FIXED_PREPAID_BY_MONTH':包月预付费计费</li><li>‘PEAK_BANDWIDTH_POSTPAID_BY_DAY’: 后付费日结按带宽计费</li>

        :rtype: str
        """
        return self._ChargeType

    @ChargeType.setter
    def ChargeType(self, ChargeType):
        self._ChargeType = ChargeType

    @property
    def BandwidthPackageName(self):
        """带宽包名称
        :rtype: str
        """
        return self._BandwidthPackageName

    @BandwidthPackageName.setter
    def BandwidthPackageName(self, BandwidthPackageName):
        self._BandwidthPackageName = BandwidthPackageName

    @property
    def CreatedTime(self):
        """带宽包创建时间。按照`ISO8601`标准表示，并且使用`UTC`时间。格式为：`YYYY-MM-DDThh:mm:ssZ`。
        :rtype: str
        """
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime

    @property
    def Status(self):
        """带宽包状态，包括'CREATING','CREATED','DELETING','DELETED'
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ResourceSet(self):
        """带宽包资源信息
        :rtype: list of Resource
        """
        return self._ResourceSet

    @ResourceSet.setter
    def ResourceSet(self, ResourceSet):
        self._ResourceSet = ResourceSet

    @property
    def Bandwidth(self):
        """带宽包限速大小。单位：Mbps，-1表示不限速。
        :rtype: int
        """
        return self._Bandwidth

    @Bandwidth.setter
    def Bandwidth(self, Bandwidth):
        self._Bandwidth = Bandwidth

    @property
    def Egress(self):
        """网络出口
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Egress

    @Egress.setter
    def Egress(self, Egress):
        self._Egress = Egress

    @property
    def Deadline(self):
        """带宽包到期时间，只有预付费会返回，按量计费返回为null
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Deadline

    @Deadline.setter
    def Deadline(self, Deadline):
        self._Deadline = Deadline


    def _deserialize(self, params):
        self._BandwidthPackageId = params.get("BandwidthPackageId")
        self._NetworkType = params.get("NetworkType")
        self._ChargeType = params.get("ChargeType")
        self._BandwidthPackageName = params.get("BandwidthPackageName")
        self._CreatedTime = params.get("CreatedTime")
        self._Status = params.get("Status")
        if params.get("ResourceSet") is not None:
            self._ResourceSet = []
            for item in params.get("ResourceSet"):
                obj = Resource()
                obj._deserialize(item)
                self._ResourceSet.append(obj)
        self._Bandwidth = params.get("Bandwidth")
        self._Egress = params.get("Egress")
        self._Deadline = params.get("Deadline")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BandwidthPackageBillBandwidth(AbstractModel):
    """后付费共享带宽包的当前计费用量

    """

    def __init__(self):
        r"""
        :param _BandwidthUsage: 当前计费用量，单位为 Mbps
        :type BandwidthUsage: float
        """
        self._BandwidthUsage = None

    @property
    def BandwidthUsage(self):
        """当前计费用量，单位为 Mbps
        :rtype: float
        """
        return self._BandwidthUsage

    @BandwidthUsage.setter
    def BandwidthUsage(self, BandwidthUsage):
        self._BandwidthUsage = BandwidthUsage


    def _deserialize(self, params):
        self._BandwidthUsage = params.get("BandwidthUsage")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchModifySnapshotPolicy(AbstractModel):
    """批量修改快照策略信息

    """

    def __init__(self):
        r"""
        :param _SnapshotPolicyId: 快照策略Id。
        :type SnapshotPolicyId: str
        :param _SnapshotPolicyName: 快照策略名称。
        :type SnapshotPolicyName: str
        :param _BackupPolicies: 备份策略。
        :type BackupPolicies: list of BackupPolicy
        :param _KeepTime: 快照保留时间，支持1～365天。
        :type KeepTime: int
        """
        self._SnapshotPolicyId = None
        self._SnapshotPolicyName = None
        self._BackupPolicies = None
        self._KeepTime = None

    @property
    def SnapshotPolicyId(self):
        """快照策略Id。
        :rtype: str
        """
        return self._SnapshotPolicyId

    @SnapshotPolicyId.setter
    def SnapshotPolicyId(self, SnapshotPolicyId):
        self._SnapshotPolicyId = SnapshotPolicyId

    @property
    def SnapshotPolicyName(self):
        """快照策略名称。
        :rtype: str
        """
        return self._SnapshotPolicyName

    @SnapshotPolicyName.setter
    def SnapshotPolicyName(self, SnapshotPolicyName):
        self._SnapshotPolicyName = SnapshotPolicyName

    @property
    def BackupPolicies(self):
        """备份策略。
        :rtype: list of BackupPolicy
        """
        return self._BackupPolicies

    @BackupPolicies.setter
    def BackupPolicies(self, BackupPolicies):
        self._BackupPolicies = BackupPolicies

    @property
    def KeepTime(self):
        """快照保留时间，支持1～365天。
        :rtype: int
        """
        return self._KeepTime

    @KeepTime.setter
    def KeepTime(self, KeepTime):
        self._KeepTime = KeepTime


    def _deserialize(self, params):
        self._SnapshotPolicyId = params.get("SnapshotPolicyId")
        self._SnapshotPolicyName = params.get("SnapshotPolicyName")
        if params.get("BackupPolicies") is not None:
            self._BackupPolicies = []
            for item in params.get("BackupPolicies"):
                obj = BackupPolicy()
                obj._deserialize(item)
                self._BackupPolicies.append(obj)
        self._KeepTime = params.get("KeepTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BgpConfig(AbstractModel):
    """BgpConfig

    """

    def __init__(self):
        r"""
        :param _TunnelCidr: BGP隧道网段。
        :type TunnelCidr: str
        :param _LocalBgpIp: 云端BGP地址。必须从BGP隧道网段内分配。
        :type LocalBgpIp: str
        :param _RemoteBgpIp: 用户端BGP地址。必须从BGP隧道网段内分配。
        :type RemoteBgpIp: str
        """
        self._TunnelCidr = None
        self._LocalBgpIp = None
        self._RemoteBgpIp = None

    @property
    def TunnelCidr(self):
        """BGP隧道网段。
        :rtype: str
        """
        return self._TunnelCidr

    @TunnelCidr.setter
    def TunnelCidr(self, TunnelCidr):
        self._TunnelCidr = TunnelCidr

    @property
    def LocalBgpIp(self):
        """云端BGP地址。必须从BGP隧道网段内分配。
        :rtype: str
        """
        return self._LocalBgpIp

    @LocalBgpIp.setter
    def LocalBgpIp(self, LocalBgpIp):
        self._LocalBgpIp = LocalBgpIp

    @property
    def RemoteBgpIp(self):
        """用户端BGP地址。必须从BGP隧道网段内分配。
        :rtype: str
        """
        return self._RemoteBgpIp

    @RemoteBgpIp.setter
    def RemoteBgpIp(self, RemoteBgpIp):
        self._RemoteBgpIp = RemoteBgpIp


    def _deserialize(self, params):
        self._TunnelCidr = params.get("TunnelCidr")
        self._LocalBgpIp = params.get("LocalBgpIp")
        self._RemoteBgpIp = params.get("RemoteBgpIp")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BgpConfigAndAsn(AbstractModel):
    """VPN通道BGP配置

    """

    def __init__(self):
        r"""
        :param _TunnelCidr: BGP通道CIDR
注意：此字段可能返回 null，表示取不到有效值。
        :type TunnelCidr: str
        :param _LocalBgpIp: 本端BGP IP
注意：此字段可能返回 null，表示取不到有效值。
        :type LocalBgpIp: str
        :param _RemoteBgpIp: 对端BGP IP
注意：此字段可能返回 null，表示取不到有效值。
        :type RemoteBgpIp: str
        :param _LocalBgpAsn: 本端BGP ASN号
注意：此字段可能返回 null，表示取不到有效值。
        :type LocalBgpAsn: str
        :param _RemoteBgpAsn: 对端BGP ASN号
注意：此字段可能返回 null，表示取不到有效值。
        :type RemoteBgpAsn: str
        """
        self._TunnelCidr = None
        self._LocalBgpIp = None
        self._RemoteBgpIp = None
        self._LocalBgpAsn = None
        self._RemoteBgpAsn = None

    @property
    def TunnelCidr(self):
        """BGP通道CIDR
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._TunnelCidr

    @TunnelCidr.setter
    def TunnelCidr(self, TunnelCidr):
        self._TunnelCidr = TunnelCidr

    @property
    def LocalBgpIp(self):
        """本端BGP IP
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._LocalBgpIp

    @LocalBgpIp.setter
    def LocalBgpIp(self, LocalBgpIp):
        self._LocalBgpIp = LocalBgpIp

    @property
    def RemoteBgpIp(self):
        """对端BGP IP
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._RemoteBgpIp

    @RemoteBgpIp.setter
    def RemoteBgpIp(self, RemoteBgpIp):
        self._RemoteBgpIp = RemoteBgpIp

    @property
    def LocalBgpAsn(self):
        """本端BGP ASN号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._LocalBgpAsn

    @LocalBgpAsn.setter
    def LocalBgpAsn(self, LocalBgpAsn):
        self._LocalBgpAsn = LocalBgpAsn

    @property
    def RemoteBgpAsn(self):
        """对端BGP ASN号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._RemoteBgpAsn

    @RemoteBgpAsn.setter
    def RemoteBgpAsn(self, RemoteBgpAsn):
        self._RemoteBgpAsn = RemoteBgpAsn


    def _deserialize(self, params):
        self._TunnelCidr = params.get("TunnelCidr")
        self._LocalBgpIp = params.get("LocalBgpIp")
        self._RemoteBgpIp = params.get("RemoteBgpIp")
        self._LocalBgpAsn = params.get("LocalBgpAsn")
        self._RemoteBgpAsn = params.get("RemoteBgpAsn")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CCN(AbstractModel):
    """云联网（CCN）对象

    """

    def __init__(self):
        r"""
        :param _CcnId: 云联网唯一ID
        :type CcnId: str
        :param _CcnName: 云联网名称
        :type CcnName: str
        :param _CcnDescription: 云联网描述信息
        :type CcnDescription: str
        :param _InstanceCount: 关联实例数量
        :type InstanceCount: int
        :param _CreateTime: 创建时间
        :type CreateTime: str
        :param _State: 实例状态， 'ISOLATED': 隔离中（欠费停服），'AVAILABLE'：运行中。
        :type State: str
        :param _QosLevel: 实例服务质量，’PT’：白金，'AU'：金，'AG'：银。
        :type QosLevel: str
        :param _InstanceChargeType: 付费类型，PREPAID为预付费，POSTPAID为后付费。
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceChargeType: str
        :param _BandwidthLimitType: 限速类型，`INTER_REGION_LIMIT` 为地域间限速；`OUTER_REGION_LIMIT` 为地域出口限速。
注意：此字段可能返回 null，表示取不到有效值。
        :type BandwidthLimitType: str
        :param _TagSet: 标签键值对。
        :type TagSet: list of Tag
        :param _RoutePriorityFlag: 是否支持云联网路由优先级的功能。`False`：不支持，`True`：支持。
        :type RoutePriorityFlag: bool
        :param _RouteTableCount: 实例关联的路由表个数。
注意：此字段可能返回 null，表示取不到有效值。
        :type RouteTableCount: int
        :param _RouteTableFlag: 是否开启云联网多路由表特性。`False`：未开启，`True`：开启。
注意：此字段可能返回 null，表示取不到有效值。
        :type RouteTableFlag: bool
        :param _IsSecurityLock: `true`：实例已被封禁，流量不通，`false`:解封禁。
注意：此字段可能返回 null，表示取不到有效值。
        :type IsSecurityLock: bool
        :param _RouteBroadcastPolicyFlag: 是否开启云联网路由传播策略。`False` 未开启，`True` 开启。
注意：此字段可能返回 null，表示取不到有效值。
        :type RouteBroadcastPolicyFlag: bool
        :param _RouteECMPFlag: 是否开启等价路由功能。`False` 未开启，`True` 开启。
注意：此字段可能返回 null，表示取不到有效值。
        :type RouteECMPFlag: bool
        :param _RouteOverlapFlag: 是否开启路由重叠功能。`False` 未开启，`True` 开启。
注意：此字段可能返回 null，表示取不到有效值。
        :type RouteOverlapFlag: bool
        :param _TrafficMarkingPolicyFlag: 是否开启QOS。
注意：此字段可能返回 null，表示取不到有效值。
        :type TrafficMarkingPolicyFlag: bool
        :param _RouteSelectPolicyFlag: 是否开启路由表选择策略。
注意：此字段可能返回 null，表示取不到有效值。
        :type RouteSelectPolicyFlag: bool
        :param _DirectConnectAccelerateChannelFlag: 是否开启二层云联网通道。
注意：此字段可能返回 null，表示取不到有效值。
        :type DirectConnectAccelerateChannelFlag: bool
        :param _Ipv6Flag: 是否支持ipv6路由表
注意：此字段可能返回 null，表示取不到有效值。
        :type Ipv6Flag: bool
        :param _MrtbAggregatePolicyFlag: 是否支持路由表聚合策略
注意：此字段可能返回 null，表示取不到有效值。
        :type MrtbAggregatePolicyFlag: bool
        :param _MrtbPolicyValueFlag: 是否支持策略值
注意：此字段可能返回 null，表示取不到有效值。
        :type MrtbPolicyValueFlag: bool
        """
        self._CcnId = None
        self._CcnName = None
        self._CcnDescription = None
        self._InstanceCount = None
        self._CreateTime = None
        self._State = None
        self._QosLevel = None
        self._InstanceChargeType = None
        self._BandwidthLimitType = None
        self._TagSet = None
        self._RoutePriorityFlag = None
        self._RouteTableCount = None
        self._RouteTableFlag = None
        self._IsSecurityLock = None
        self._RouteBroadcastPolicyFlag = None
        self._RouteECMPFlag = None
        self._RouteOverlapFlag = None
        self._TrafficMarkingPolicyFlag = None
        self._RouteSelectPolicyFlag = None
        self._DirectConnectAccelerateChannelFlag = None
        self._Ipv6Flag = None
        self._MrtbAggregatePolicyFlag = None
        self._MrtbPolicyValueFlag = None

    @property
    def CcnId(self):
        """云联网唯一ID
        :rtype: str
        """
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId

    @property
    def CcnName(self):
        """云联网名称
        :rtype: str
        """
        return self._CcnName

    @CcnName.setter
    def CcnName(self, CcnName):
        self._CcnName = CcnName

    @property
    def CcnDescription(self):
        """云联网描述信息
        :rtype: str
        """
        return self._CcnDescription

    @CcnDescription.setter
    def CcnDescription(self, CcnDescription):
        self._CcnDescription = CcnDescription

    @property
    def InstanceCount(self):
        """关联实例数量
        :rtype: int
        """
        return self._InstanceCount

    @InstanceCount.setter
    def InstanceCount(self, InstanceCount):
        self._InstanceCount = InstanceCount

    @property
    def CreateTime(self):
        """创建时间
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def State(self):
        """实例状态， 'ISOLATED': 隔离中（欠费停服），'AVAILABLE'：运行中。
        :rtype: str
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def QosLevel(self):
        """实例服务质量，’PT’：白金，'AU'：金，'AG'：银。
        :rtype: str
        """
        return self._QosLevel

    @QosLevel.setter
    def QosLevel(self, QosLevel):
        self._QosLevel = QosLevel

    @property
    def InstanceChargeType(self):
        """付费类型，PREPAID为预付费，POSTPAID为后付费。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._InstanceChargeType

    @InstanceChargeType.setter
    def InstanceChargeType(self, InstanceChargeType):
        self._InstanceChargeType = InstanceChargeType

    @property
    def BandwidthLimitType(self):
        """限速类型，`INTER_REGION_LIMIT` 为地域间限速；`OUTER_REGION_LIMIT` 为地域出口限速。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._BandwidthLimitType

    @BandwidthLimitType.setter
    def BandwidthLimitType(self, BandwidthLimitType):
        self._BandwidthLimitType = BandwidthLimitType

    @property
    def TagSet(self):
        """标签键值对。
        :rtype: list of Tag
        """
        return self._TagSet

    @TagSet.setter
    def TagSet(self, TagSet):
        self._TagSet = TagSet

    @property
    def RoutePriorityFlag(self):
        """是否支持云联网路由优先级的功能。`False`：不支持，`True`：支持。
        :rtype: bool
        """
        return self._RoutePriorityFlag

    @RoutePriorityFlag.setter
    def RoutePriorityFlag(self, RoutePriorityFlag):
        self._RoutePriorityFlag = RoutePriorityFlag

    @property
    def RouteTableCount(self):
        """实例关联的路由表个数。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._RouteTableCount

    @RouteTableCount.setter
    def RouteTableCount(self, RouteTableCount):
        self._RouteTableCount = RouteTableCount

    @property
    def RouteTableFlag(self):
        """是否开启云联网多路由表特性。`False`：未开启，`True`：开启。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._RouteTableFlag

    @RouteTableFlag.setter
    def RouteTableFlag(self, RouteTableFlag):
        self._RouteTableFlag = RouteTableFlag

    @property
    def IsSecurityLock(self):
        """`true`：实例已被封禁，流量不通，`false`:解封禁。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._IsSecurityLock

    @IsSecurityLock.setter
    def IsSecurityLock(self, IsSecurityLock):
        self._IsSecurityLock = IsSecurityLock

    @property
    def RouteBroadcastPolicyFlag(self):
        """是否开启云联网路由传播策略。`False` 未开启，`True` 开启。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._RouteBroadcastPolicyFlag

    @RouteBroadcastPolicyFlag.setter
    def RouteBroadcastPolicyFlag(self, RouteBroadcastPolicyFlag):
        self._RouteBroadcastPolicyFlag = RouteBroadcastPolicyFlag

    @property
    def RouteECMPFlag(self):
        """是否开启等价路由功能。`False` 未开启，`True` 开启。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._RouteECMPFlag

    @RouteECMPFlag.setter
    def RouteECMPFlag(self, RouteECMPFlag):
        self._RouteECMPFlag = RouteECMPFlag

    @property
    def RouteOverlapFlag(self):
        """是否开启路由重叠功能。`False` 未开启，`True` 开启。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._RouteOverlapFlag

    @RouteOverlapFlag.setter
    def RouteOverlapFlag(self, RouteOverlapFlag):
        self._RouteOverlapFlag = RouteOverlapFlag

    @property
    def TrafficMarkingPolicyFlag(self):
        """是否开启QOS。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._TrafficMarkingPolicyFlag

    @TrafficMarkingPolicyFlag.setter
    def TrafficMarkingPolicyFlag(self, TrafficMarkingPolicyFlag):
        self._TrafficMarkingPolicyFlag = TrafficMarkingPolicyFlag

    @property
    def RouteSelectPolicyFlag(self):
        """是否开启路由表选择策略。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._RouteSelectPolicyFlag

    @RouteSelectPolicyFlag.setter
    def RouteSelectPolicyFlag(self, RouteSelectPolicyFlag):
        self._RouteSelectPolicyFlag = RouteSelectPolicyFlag

    @property
    def DirectConnectAccelerateChannelFlag(self):
        """是否开启二层云联网通道。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._DirectConnectAccelerateChannelFlag

    @DirectConnectAccelerateChannelFlag.setter
    def DirectConnectAccelerateChannelFlag(self, DirectConnectAccelerateChannelFlag):
        self._DirectConnectAccelerateChannelFlag = DirectConnectAccelerateChannelFlag

    @property
    def Ipv6Flag(self):
        """是否支持ipv6路由表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._Ipv6Flag

    @Ipv6Flag.setter
    def Ipv6Flag(self, Ipv6Flag):
        self._Ipv6Flag = Ipv6Flag

    @property
    def MrtbAggregatePolicyFlag(self):
        """是否支持路由表聚合策略
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._MrtbAggregatePolicyFlag

    @MrtbAggregatePolicyFlag.setter
    def MrtbAggregatePolicyFlag(self, MrtbAggregatePolicyFlag):
        self._MrtbAggregatePolicyFlag = MrtbAggregatePolicyFlag

    @property
    def MrtbPolicyValueFlag(self):
        """是否支持策略值
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._MrtbPolicyValueFlag

    @MrtbPolicyValueFlag.setter
    def MrtbPolicyValueFlag(self, MrtbPolicyValueFlag):
        self._MrtbPolicyValueFlag = MrtbPolicyValueFlag


    def _deserialize(self, params):
        self._CcnId = params.get("CcnId")
        self._CcnName = params.get("CcnName")
        self._CcnDescription = params.get("CcnDescription")
        self._InstanceCount = params.get("InstanceCount")
        self._CreateTime = params.get("CreateTime")
        self._State = params.get("State")
        self._QosLevel = params.get("QosLevel")
        self._InstanceChargeType = params.get("InstanceChargeType")
        self._BandwidthLimitType = params.get("BandwidthLimitType")
        if params.get("TagSet") is not None:
            self._TagSet = []
            for item in params.get("TagSet"):
                obj = Tag()
                obj._deserialize(item)
                self._TagSet.append(obj)
        self._RoutePriorityFlag = params.get("RoutePriorityFlag")
        self._RouteTableCount = params.get("RouteTableCount")
        self._RouteTableFlag = params.get("RouteTableFlag")
        self._IsSecurityLock = params.get("IsSecurityLock")
        self._RouteBroadcastPolicyFlag = params.get("RouteBroadcastPolicyFlag")
        self._RouteECMPFlag = params.get("RouteECMPFlag")
        self._RouteOverlapFlag = params.get("RouteOverlapFlag")
        self._TrafficMarkingPolicyFlag = params.get("TrafficMarkingPolicyFlag")
        self._RouteSelectPolicyFlag = params.get("RouteSelectPolicyFlag")
        self._DirectConnectAccelerateChannelFlag = params.get("DirectConnectAccelerateChannelFlag")
        self._Ipv6Flag = params.get("Ipv6Flag")
        self._MrtbAggregatePolicyFlag = params.get("MrtbAggregatePolicyFlag")
        self._MrtbPolicyValueFlag = params.get("MrtbPolicyValueFlag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CcnAttachedInstance(AbstractModel):
    """云联网（CCN）关联实例（Instance）对象

    """

    def __init__(self):
        r"""
        :param _CcnId: 云联网实例ID。
        :type CcnId: str
        :param _InstanceType: 关联实例类型：
<li>`VPC`：私有网络</li>
<li>`DIRECTCONNECT`：专线网关</li>
<li>`BMVPC`：黑石私有网络</li>
        :type InstanceType: str
        :param _InstanceId: 关联实例ID。
        :type InstanceId: str
        :param _InstanceName: 关联实例名称。
        :type InstanceName: str
        :param _InstanceRegion: 关联实例所属大区，例如：ap-guangzhou。
        :type InstanceRegion: str
        :param _InstanceUin: 关联实例所属UIN（根账号）。
        :type InstanceUin: str
        :param _CidrBlock: 关联实例CIDR。
        :type CidrBlock: list of str
        :param _State: 关联实例状态：
<li>`PENDING`：申请中</li>
<li>`ACTIVE`：已连接</li>
<li>`EXPIRED`：已过期</li>
<li>`REJECTED`：已拒绝</li>
<li>`DELETED`：已删除</li>
<li>`FAILED`：失败的（2小时后将异步强制解关联）</li>
<li>`ATTACHING`：关联中</li>
<li>`DETACHING`：解关联中</li>
<li>`DETACHFAILED`：解关联失败（2小时后将异步强制解关联）</li>
        :type State: str
        :param _AttachedTime: 关联时间。
        :type AttachedTime: str
        :param _CcnUin: 云联网所属UIN（根账号）。
        :type CcnUin: str
        :param _InstanceArea: 关联实例所属的大地域，如: CHINA_MAINLAND
        :type InstanceArea: str
        :param _Description: 备注
        :type Description: str
        :param _RouteTableId: 路由表ID
注意：此字段可能返回 null，表示取不到有效值。
        :type RouteTableId: str
        :param _RouteTableName: 路由表名称
注意：此字段可能返回 null，表示取不到有效值。
        :type RouteTableName: str
        """
        self._CcnId = None
        self._InstanceType = None
        self._InstanceId = None
        self._InstanceName = None
        self._InstanceRegion = None
        self._InstanceUin = None
        self._CidrBlock = None
        self._State = None
        self._AttachedTime = None
        self._CcnUin = None
        self._InstanceArea = None
        self._Description = None
        self._RouteTableId = None
        self._RouteTableName = None

    @property
    def CcnId(self):
        """云联网实例ID。
        :rtype: str
        """
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId

    @property
    def InstanceType(self):
        """关联实例类型：
<li>`VPC`：私有网络</li>
<li>`DIRECTCONNECT`：专线网关</li>
<li>`BMVPC`：黑石私有网络</li>
        :rtype: str
        """
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def InstanceId(self):
        """关联实例ID。
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def InstanceName(self):
        """关联实例名称。
        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def InstanceRegion(self):
        """关联实例所属大区，例如：ap-guangzhou。
        :rtype: str
        """
        return self._InstanceRegion

    @InstanceRegion.setter
    def InstanceRegion(self, InstanceRegion):
        self._InstanceRegion = InstanceRegion

    @property
    def InstanceUin(self):
        """关联实例所属UIN（根账号）。
        :rtype: str
        """
        return self._InstanceUin

    @InstanceUin.setter
    def InstanceUin(self, InstanceUin):
        self._InstanceUin = InstanceUin

    @property
    def CidrBlock(self):
        """关联实例CIDR。
        :rtype: list of str
        """
        return self._CidrBlock

    @CidrBlock.setter
    def CidrBlock(self, CidrBlock):
        self._CidrBlock = CidrBlock

    @property
    def State(self):
        """关联实例状态：
<li>`PENDING`：申请中</li>
<li>`ACTIVE`：已连接</li>
<li>`EXPIRED`：已过期</li>
<li>`REJECTED`：已拒绝</li>
<li>`DELETED`：已删除</li>
<li>`FAILED`：失败的（2小时后将异步强制解关联）</li>
<li>`ATTACHING`：关联中</li>
<li>`DETACHING`：解关联中</li>
<li>`DETACHFAILED`：解关联失败（2小时后将异步强制解关联）</li>
        :rtype: str
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def AttachedTime(self):
        """关联时间。
        :rtype: str
        """
        return self._AttachedTime

    @AttachedTime.setter
    def AttachedTime(self, AttachedTime):
        self._AttachedTime = AttachedTime

    @property
    def CcnUin(self):
        """云联网所属UIN（根账号）。
        :rtype: str
        """
        return self._CcnUin

    @CcnUin.setter
    def CcnUin(self, CcnUin):
        self._CcnUin = CcnUin

    @property
    def InstanceArea(self):
        """关联实例所属的大地域，如: CHINA_MAINLAND
        :rtype: str
        """
        return self._InstanceArea

    @InstanceArea.setter
    def InstanceArea(self, InstanceArea):
        self._InstanceArea = InstanceArea

    @property
    def Description(self):
        """备注
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def RouteTableId(self):
        """路由表ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._RouteTableId

    @RouteTableId.setter
    def RouteTableId(self, RouteTableId):
        self._RouteTableId = RouteTableId

    @property
    def RouteTableName(self):
        """路由表名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._RouteTableName

    @RouteTableName.setter
    def RouteTableName(self, RouteTableName):
        self._RouteTableName = RouteTableName


    def _deserialize(self, params):
        self._CcnId = params.get("CcnId")
        self._InstanceType = params.get("InstanceType")
        self._InstanceId = params.get("InstanceId")
        self._InstanceName = params.get("InstanceName")
        self._InstanceRegion = params.get("InstanceRegion")
        self._InstanceUin = params.get("InstanceUin")
        self._CidrBlock = params.get("CidrBlock")
        self._State = params.get("State")
        self._AttachedTime = params.get("AttachedTime")
        self._CcnUin = params.get("CcnUin")
        self._InstanceArea = params.get("InstanceArea")
        self._Description = params.get("Description")
        self._RouteTableId = params.get("RouteTableId")
        self._RouteTableName = params.get("RouteTableName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CcnBandwidth(AbstractModel):
    """用于描述云联网地域间限速带宽实例的信息。

    """

    def __init__(self):
        r"""
        :param _CcnId: 带宽所属的云联网ID。
        :type CcnId: str
        :param _CreatedTime: 实例的创建时间。
注意：此字段可能返回 null，表示取不到有效值。
        :type CreatedTime: str
        :param _ExpiredTime: 实例的过期时间
注意：此字段可能返回 null，表示取不到有效值。
        :type ExpiredTime: str
        :param _RegionFlowControlId: 带宽实例的唯一ID。
注意：此字段可能返回 null，表示取不到有效值。
        :type RegionFlowControlId: str
        :param _RenewFlag: 带宽是否自动续费的标记。
注意：此字段可能返回 null，表示取不到有效值。
        :type RenewFlag: str
        :param _CcnRegionBandwidthLimit: 描述带宽的地域和限速上限信息。在地域间限速的情况下才会返回参数，出口限速模式不返回。
注意：此字段可能返回 null，表示取不到有效值。
        :type CcnRegionBandwidthLimit: :class:`tencentcloud.vpc.v20170312.models.CcnRegionBandwidthLimitInfo`
        :param _MarketId: 云市场实例ID。
注意：此字段可能返回 null，表示取不到有效值。
        :type MarketId: str
        :param _UserAccountID: 实例所属用户主账号ID。
注意：此字段可能返回 null，表示取不到有效值。
        :type UserAccountID: str
        :param _IsCrossBorder: 是否跨境，`true`表示跨境，反之不跨境。
注意：此字段可能返回 null，表示取不到有效值。
        :type IsCrossBorder: bool
        :param _IsSecurityLock: `true`表示封禁，地域间流量不通，`false`解禁，地域间流量正常
注意：此字段可能返回 null，表示取不到有效值。
        :type IsSecurityLock: bool
        :param _InstanceChargeType: `POSTPAID`表示后付费，`PREPAID`表示预付费。
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceChargeType: str
        :param _UpdateTime: 实例更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: str
        """
        self._CcnId = None
        self._CreatedTime = None
        self._ExpiredTime = None
        self._RegionFlowControlId = None
        self._RenewFlag = None
        self._CcnRegionBandwidthLimit = None
        self._MarketId = None
        self._UserAccountID = None
        self._IsCrossBorder = None
        self._IsSecurityLock = None
        self._InstanceChargeType = None
        self._UpdateTime = None

    @property
    def CcnId(self):
        """带宽所属的云联网ID。
        :rtype: str
        """
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId

    @property
    def CreatedTime(self):
        """实例的创建时间。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime

    @property
    def ExpiredTime(self):
        """实例的过期时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ExpiredTime

    @ExpiredTime.setter
    def ExpiredTime(self, ExpiredTime):
        self._ExpiredTime = ExpiredTime

    @property
    def RegionFlowControlId(self):
        """带宽实例的唯一ID。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._RegionFlowControlId

    @RegionFlowControlId.setter
    def RegionFlowControlId(self, RegionFlowControlId):
        self._RegionFlowControlId = RegionFlowControlId

    @property
    def RenewFlag(self):
        """带宽是否自动续费的标记。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag

    @property
    def CcnRegionBandwidthLimit(self):
        """描述带宽的地域和限速上限信息。在地域间限速的情况下才会返回参数，出口限速模式不返回。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vpc.v20170312.models.CcnRegionBandwidthLimitInfo`
        """
        return self._CcnRegionBandwidthLimit

    @CcnRegionBandwidthLimit.setter
    def CcnRegionBandwidthLimit(self, CcnRegionBandwidthLimit):
        self._CcnRegionBandwidthLimit = CcnRegionBandwidthLimit

    @property
    def MarketId(self):
        """云市场实例ID。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._MarketId

    @MarketId.setter
    def MarketId(self, MarketId):
        self._MarketId = MarketId

    @property
    def UserAccountID(self):
        """实例所属用户主账号ID。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._UserAccountID

    @UserAccountID.setter
    def UserAccountID(self, UserAccountID):
        self._UserAccountID = UserAccountID

    @property
    def IsCrossBorder(self):
        """是否跨境，`true`表示跨境，反之不跨境。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._IsCrossBorder

    @IsCrossBorder.setter
    def IsCrossBorder(self, IsCrossBorder):
        self._IsCrossBorder = IsCrossBorder

    @property
    def IsSecurityLock(self):
        """`true`表示封禁，地域间流量不通，`false`解禁，地域间流量正常
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._IsSecurityLock

    @IsSecurityLock.setter
    def IsSecurityLock(self, IsSecurityLock):
        self._IsSecurityLock = IsSecurityLock

    @property
    def InstanceChargeType(self):
        """`POSTPAID`表示后付费，`PREPAID`表示预付费。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._InstanceChargeType

    @InstanceChargeType.setter
    def InstanceChargeType(self, InstanceChargeType):
        self._InstanceChargeType = InstanceChargeType

    @property
    def UpdateTime(self):
        """实例更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._CcnId = params.get("CcnId")
        self._CreatedTime = params.get("CreatedTime")
        self._ExpiredTime = params.get("ExpiredTime")
        self._RegionFlowControlId = params.get("RegionFlowControlId")
        self._RenewFlag = params.get("RenewFlag")
        if params.get("CcnRegionBandwidthLimit") is not None:
            self._CcnRegionBandwidthLimit = CcnRegionBandwidthLimitInfo()
            self._CcnRegionBandwidthLimit._deserialize(params.get("CcnRegionBandwidthLimit"))
        self._MarketId = params.get("MarketId")
        self._UserAccountID = params.get("UserAccountID")
        self._IsCrossBorder = params.get("IsCrossBorder")
        self._IsSecurityLock = params.get("IsSecurityLock")
        self._InstanceChargeType = params.get("InstanceChargeType")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CcnBandwidthInfo(AbstractModel):
    """用于描述云联网地域间限速带宽实例的信息。

    """

    def __init__(self):
        r"""
        :param _CcnId: 带宽所属的云联网ID。
注意：此字段可能返回 null，表示取不到有效值。
        :type CcnId: str
        :param _CreatedTime: 实例的创建时间。
注意：此字段可能返回 null，表示取不到有效值。
        :type CreatedTime: str
        :param _ExpiredTime: 实例的过期时间
注意：此字段可能返回 null，表示取不到有效值。
        :type ExpiredTime: str
        :param _RegionFlowControlId: 带宽实例的唯一ID。
注意：此字段可能返回 null，表示取不到有效值。
        :type RegionFlowControlId: str
        :param _RenewFlag: 带宽是否自动续费的标记。
注意：此字段可能返回 null，表示取不到有效值。
        :type RenewFlag: str
        :param _CcnRegionBandwidthLimit: 描述带宽的地域和限速上限信息。在地域间限速的情况下才会返回参数，出口限速模式不返回。
注意：此字段可能返回 null，表示取不到有效值。
        :type CcnRegionBandwidthLimit: :class:`tencentcloud.vpc.v20170312.models.CcnRegionBandwidthLimit`
        :param _MarketId: 云市场实例ID。
注意：此字段可能返回 null，表示取不到有效值。
        :type MarketId: str
        :param _TagSet: 资源绑定的标签列表
注意：此字段可能返回 null，表示取不到有效值。
        :type TagSet: list of Tag
        """
        self._CcnId = None
        self._CreatedTime = None
        self._ExpiredTime = None
        self._RegionFlowControlId = None
        self._RenewFlag = None
        self._CcnRegionBandwidthLimit = None
        self._MarketId = None
        self._TagSet = None

    @property
    def CcnId(self):
        """带宽所属的云联网ID。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId

    @property
    def CreatedTime(self):
        """实例的创建时间。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime

    @property
    def ExpiredTime(self):
        """实例的过期时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ExpiredTime

    @ExpiredTime.setter
    def ExpiredTime(self, ExpiredTime):
        self._ExpiredTime = ExpiredTime

    @property
    def RegionFlowControlId(self):
        """带宽实例的唯一ID。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._RegionFlowControlId

    @RegionFlowControlId.setter
    def RegionFlowControlId(self, RegionFlowControlId):
        self._RegionFlowControlId = RegionFlowControlId

    @property
    def RenewFlag(self):
        """带宽是否自动续费的标记。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag

    @property
    def CcnRegionBandwidthLimit(self):
        """描述带宽的地域和限速上限信息。在地域间限速的情况下才会返回参数，出口限速模式不返回。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.vpc.v20170312.models.CcnRegionBandwidthLimit`
        """
        return self._CcnRegionBandwidthLimit

    @CcnRegionBandwidthLimit.setter
    def CcnRegionBandwidthLimit(self, CcnRegionBandwidthLimit):
        self._CcnRegionBandwidthLimit = CcnRegionBandwidthLimit

    @property
    def MarketId(self):
        """云市场实例ID。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._MarketId

    @MarketId.setter
    def MarketId(self, MarketId):
        self._MarketId = MarketId

    @property
    def TagSet(self):
        """资源绑定的标签列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of Tag
        """
        return self._TagSet

    @TagSet.setter
    def TagSet(self, TagSet):
        self._TagSet = TagSet


    def _deserialize(self, params):
        self._CcnId = params.get("CcnId")
        self._CreatedTime = params.get("CreatedTime")
        self._ExpiredTime = params.get("ExpiredTime")
        self._RegionFlowControlId = params.get("RegionFlowControlId")
        self._RenewFlag = params.get("RenewFlag")
        if params.get("CcnRegionBandwidthLimit") is not None:
            self._CcnRegionBandwidthLimit = CcnRegionBandwidthLimit()
            self._CcnRegionBandwidthLimit._deserialize(params.get("CcnRegionBandwidthLimit"))
        self._MarketId = params.get("MarketId")
        if params.get("TagSet") is not None:
            self._TagSet = []
            for item in params.get("TagSet"):
                obj = Tag()
                obj._deserialize(item)
                self._TagSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CcnBatchRouteTable(AbstractModel):
    """云联网路由表信息

    """

    def __init__(self):
        r"""
        :param _CcnId: 云联网ID。
        :type CcnId: str
        :param _Name: 云联网路由表名称。
        :type Name: str
        :param _Description: 云联网路由表描述。
        :type Description: str
        """
        self._CcnId = None
        self._Name = None
        self._Description = None

    @property
    def CcnId(self):
        """云联网ID。
        :rtype: str
        """
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId

    @property
    def Name(self):
        """云联网路由表名称。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Description(self):
        """云联网路由表描述。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._CcnId = params.get("CcnId")
        self._Name = params.get("Name")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CcnFlowLock(AbstractModel):
    """云联网限速实例锁对象，该对象特用于运营端使用，用于封禁实例流量。

    """

    def __init__(self):
        r"""
        :param _CcnId: 带宽所属的云联网ID。
        :type CcnId: str
        :param _UserAccountID: 实例所属用户主账号ID。
        :type UserAccountID: str
        :param _RegionFlowControlId: 带宽实例的唯一ID。作为`UnlockCcnBandwidths`接口和`LockCcnBandwidths`接口的入参时，该字段必传。
        :type RegionFlowControlId: str
        """
        self._CcnId = None
        self._UserAccountID = None
        self._RegionFlowControlId = None

    @property
    def CcnId(self):
        """带宽所属的云联网ID。
        :rtype: str
        """
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId

    @property
    def UserAccountID(self):
        """实例所属用户主账号ID。
        :rtype: str
        """
        return self._UserAccountID

    @UserAccountID.setter
    def UserAccountID(self, UserAccountID):
        self._UserAccountID = UserAccountID

    @property
    def RegionFlowControlId(self):
        """带宽实例的唯一ID。作为`UnlockCcnBandwidths`接口和`LockCcnBandwidths`接口的入参时，该字段必传。
        :rtype: str
        """
        return self._RegionFlowControlId

    @RegionFlowControlId.setter
    def RegionFlowControlId(self, RegionFlowControlId):
        self._RegionFlowControlId = RegionFlowControlId


    def _deserialize(self, params):
        self._CcnId = params.get("CcnId")
        self._UserAccountID = params.get("UserAccountID")
        self._RegionFlowControlId = params.get("RegionFlowControlId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CcnInstance(AbstractModel):
    """云联网（CCN）关联实例（Instance）对象。

    """

    def __init__(self):
        r"""
        :param _InstanceId: 关联实例ID。
        :type InstanceId: str
        :param _InstanceRegion: 关联实例ID所属大区，例如：ap-guangzhou。
        :type InstanceRegion: str
        :param _InstanceType: 关联实例类型，可选值：
<li>`VPC`：私有网络</li>
<li>`DIRECTCONNECT`：专线网关</li>
<li>`BMVPC`：黑石私有网络</li>
<li>`VPNGW`：VPNGW类型</li>
        :type InstanceType: str
        :param _Description: 备注
        :type Description: str
        :param _RouteTableId: 实例关联的路由表ID。
注意：此字段可能返回 null，表示取不到有效值。
        :type RouteTableId: str
        :param _OrderType: 实例付费方式
注意：此字段可能返回 null，表示取不到有效值。
        :type OrderType: str
        """
        self._InstanceId = None
        self._InstanceRegion = None
        self._InstanceType = None
        self._Description = None
        self._RouteTableId = None
        self._OrderType = None

    @property
    def InstanceId(self):
        """关联实例ID。
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def InstanceRegion(self):
        """关联实例ID所属大区，例如：ap-guangzhou。
        :rtype: str
        """
        return self._InstanceRegion

    @InstanceRegion.setter
    def InstanceRegion(self, InstanceRegion):
        self._InstanceRegion = InstanceRegion

    @property
    def InstanceType(self):
        """关联实例类型，可选值：
<li>`VPC`：私有网络</li>
<li>`DIRECTCONNECT`：专线网关</li>
<li>`BMVPC`：黑石私有网络</li>
<li>`VPNGW`：VPNGW类型</li>
        :rtype: str
        """
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def Description(self):
        """备注
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def RouteTableId(self):
        """实例关联的路由表ID。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._RouteTableId

    @RouteTableId.setter
    def RouteTableId(self, RouteTableId):
        self._RouteTableId = RouteTableId

    @property
    def OrderType(self):
        """实例付费方式
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._OrderType

    @OrderType.setter
    def OrderType(self, OrderType):
        self._OrderType = OrderType


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._InstanceRegion = params.get("InstanceRegion")
        self._InstanceType = params.get("InstanceType")
        self._Description = params.get("Description")
        self._RouteTableId = params.get("RouteTableId")
        self._OrderType = params.get("OrderType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CcnInstanceInfo(AbstractModel):
    """云联网实例对象，该对象特用于运营端使用，不建议给租户的接口中提供该复杂类型。

    """


class CcnInstanceWithoutRegion(AbstractModel):
    """ccn实例信息（不带地域属性）

    """

    def __init__(self):
        r"""
        :param _InstanceType: 云联网支持的实例类型：
`VPC`
`DIRECTCONNECT`
`BMVPC` 
`EDGE`
`EDGE_TUNNEL`
`EDGE_VPNGW`
`VPNGW`
        :type InstanceType: str
        :param _InstanceId: 实例ID。
        :type InstanceId: str
        """
        self._InstanceType = None
        self._InstanceId = None

    @property
    def InstanceType(self):
        """云联网支持的实例类型：
`VPC`
`DIRECTCONNECT`
`BMVPC` 
`EDGE`
`EDGE_TUNNEL`
`EDGE_VPNGW`
`VPNGW`
        :rtype: str
        """
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def InstanceId(self):
        """实例ID。
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._InstanceType = params.get("InstanceType")
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CcnRegionBandwidthLimit(AbstractModel):
    """云联网（CCN）地域出带宽上限

    """

    def __init__(self):
        r"""
        :param _Region: 地域，例如：ap-guangzhou
        :type Region: str
        :param _BandwidthLimit: 出带宽上限，单位：Mbps
        :type BandwidthLimit: int
        :param _IsBm: 是否黑石地域，默认`false`。
        :type IsBm: bool
        :param _DstRegion: 目的地域，例如：ap-shanghai
注意：此字段可能返回 null，表示取不到有效值。
        :type DstRegion: str
        :param _DstIsBm: 目的地域是否为黑石地域，默认`false`。
        :type DstIsBm: bool
        """
        self._Region = None
        self._BandwidthLimit = None
        self._IsBm = None
        self._DstRegion = None
        self._DstIsBm = None

    @property
    def Region(self):
        """地域，例如：ap-guangzhou
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def BandwidthLimit(self):
        """出带宽上限，单位：Mbps
        :rtype: int
        """
        return self._BandwidthLimit

    @BandwidthLimit.setter
    def BandwidthLimit(self, BandwidthLimit):
        self._BandwidthLimit = BandwidthLimit

    @property
    def IsBm(self):
        """是否黑石地域，默认`false`。
        :rtype: bool
        """
        return self._IsBm

    @IsBm.setter
    def IsBm(self, IsBm):
        self._IsBm = IsBm

    @property
    def DstRegion(self):
        """目的地域，例如：ap-shanghai
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DstRegion

    @DstRegion.setter
    def DstRegion(self, DstRegion):
        self._DstRegion = DstRegion

    @property
    def DstIsBm(self):
        """目的地域是否为黑石地域，默认`false`。
        :rtype: bool
        """
        return self._DstIsBm

    @DstIsBm.setter
    def DstIsBm(self, DstIsBm):
        self._DstIsBm = DstIsBm


    def _deserialize(self, params):
        self._Region = params.get("Region")
        self._BandwidthLimit = params.get("BandwidthLimit")
        self._IsBm = params.get("IsBm")
        self._DstRegion = params.get("DstRegion")
        self._DstIsBm = params.get("DstIsBm")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CcnRegionBandwidthLimitInfo(AbstractModel):
    """云联网（CCN）地域出带宽上限。

    """

    def __init__(self):
        r"""
        :param _SourceRegion: 源地域，例如：ap-shanghai
注意：此字段可能返回 null，表示取不到有效值。
        :type SourceRegion: str
        :param _DestinationRegion: 目的地域， 例如：ap-shanghai
注意：此字段可能返回 null，表示取不到有效值。
        :type DestinationRegion: str
        :param _BandwidthLimit: 出带宽上限，单位：Mbps。
注意：此字段可能返回 null，表示取不到有效值。
        :type BandwidthLimit: int
        """
        self._SourceRegion = None
        self._DestinationRegion = None
        self._BandwidthLimit = None

    @property
    def SourceRegion(self):
        """源地域，例如：ap-shanghai
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SourceRegion

    @SourceRegion.setter
    def SourceRegion(self, SourceRegion):
        self._SourceRegion = SourceRegion

    @property
    def DestinationRegion(self):
        """目的地域， 例如：ap-shanghai
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DestinationRegion

    @DestinationRegion.setter
    def DestinationRegion(self, DestinationRegion):
        self._DestinationRegion = DestinationRegion

    @property
    def BandwidthLimit(self):
        """出带宽上限，单位：Mbps。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._BandwidthLimit

    @BandwidthLimit.setter
    def BandwidthLimit(self, BandwidthLimit):
        self._BandwidthLimit = BandwidthLimit


    def _deserialize(self, params):
        self._SourceRegion = params.get("SourceRegion")
        self._DestinationRegion = params.get("DestinationRegion")
        self._BandwidthLimit = params.get("BandwidthLimit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CcnRoute(AbstractModel):
    """CCN路由策略对象

    """

    def __init__(self):
        r"""
        :param _RouteId: 路由策略ID
        :type RouteId: str
        :param _DestinationCidrBlock: 目的端
        :type DestinationCidrBlock: str
        :param _InstanceType: 下一跳类型（关联实例类型），所有类型：VPC、DIRECTCONNECT
        :type InstanceType: str
        :param _InstanceId: 下一跳（关联实例）
        :type InstanceId: str
        :param _InstanceName: 下一跳名称（关联实例名称）
        :type InstanceName: str
        :param _InstanceRegion: 下一跳所属地域（关联实例所属地域）
        :type InstanceRegion: str
        :param _UpdateTime: 更新时间
        :type UpdateTime: str
        :param _Enabled: 路由是否启用
        :type Enabled: bool
        :param _InstanceUin: 关联实例所属UIN（根账号）
        :type InstanceUin: str
        :param _ExtraState: 路由的扩展状态
        :type ExtraState: str
        :param _IsBgp: 是否动态路由
        :type IsBgp: bool
        :param _RoutePriority: 路由优先级
        :type RoutePriority: int
        :param _InstanceExtraName: 下一跳扩展名称（关联实例的扩展名称）
        :type InstanceExtraName: str
        :param _AliasType: 实例类型
注意：此字段可能返回 null，表示取不到有效值。
        :type AliasType: str
        :param _AliasInstanceId: 实例id
注意：此字段可能返回 null，表示取不到有效值。
        :type AliasInstanceId: str
        """
        self._RouteId = None
        self._DestinationCidrBlock = None
        self._InstanceType = None
        self._InstanceId = None
        self._InstanceName = None
        self._InstanceRegion = None
        self._UpdateTime = None
        self._Enabled = None
        self._InstanceUin = None
        self._ExtraState = None
        self._IsBgp = None
        self._RoutePriority = None
        self._InstanceExtraName = None
        self._AliasType = None
        self._AliasInstanceId = None

    @property
    def RouteId(self):
        """路由策略ID
        :rtype: str
        """
        return self._RouteId

    @RouteId.setter
    def RouteId(self, RouteId):
        self._RouteId = RouteId

    @property
    def DestinationCidrBlock(self):
        """目的端
        :rtype: str
        """
        return self._DestinationCidrBlock

    @DestinationCidrBlock.setter
    def DestinationCidrBlock(self, DestinationCidrBlock):
        self._DestinationCidrBlock = DestinationCidrBlock

    @property
    def InstanceType(self):
        """下一跳类型（关联实例类型），所有类型：VPC、DIRECTCONNECT
        :rtype: str
        """
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def InstanceId(self):
        """下一跳（关联实例）
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def InstanceName(self):
        """下一跳名称（关联实例名称）
        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def InstanceRegion(self):
        """下一跳所属地域（关联实例所属地域）
        :rtype: str
        """
        return self._InstanceRegion

    @InstanceRegion.setter
    def InstanceRegion(self, InstanceRegion):
        self._InstanceRegion = InstanceRegion

    @property
    def UpdateTime(self):
        """更新时间
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def Enabled(self):
        """路由是否启用
        :rtype: bool
        """
        return self._Enabled

    @Enabled.setter
    def Enabled(self, Enabled):
        self._Enabled = Enabled

    @property
    def InstanceUin(self):
        """关联实例所属UIN（根账号）
        :rtype: str
        """
        return self._InstanceUin

    @InstanceUin.setter
    def InstanceUin(self, InstanceUin):
        self._InstanceUin = InstanceUin

    @property
    def ExtraState(self):
        """路由的扩展状态
        :rtype: str
        """
        return self._ExtraState

    @ExtraState.setter
    def ExtraState(self, ExtraState):
        self._ExtraState = ExtraState

    @property
    def IsBgp(self):
        """是否动态路由
        :rtype: bool
        """
        return self._IsBgp

    @IsBgp.setter
    def IsBgp(self, IsBgp):
        self._IsBgp = IsBgp

    @property
    def RoutePriority(self):
        """路由优先级
        :rtype: int
        """
        return self._RoutePriority

    @RoutePriority.setter
    def RoutePriority(self, RoutePriority):
        self._RoutePriority = RoutePriority

    @property
    def InstanceExtraName(self):
        """下一跳扩展名称（关联实例的扩展名称）
        :rtype: str
        """
        return self._InstanceExtraName

    @InstanceExtraName.setter
    def InstanceExtraName(self, InstanceExtraName):
        self._InstanceExtraName = InstanceExtraName

    @property
    def AliasType(self):
        """实例类型
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AliasType

    @AliasType.setter
    def AliasType(self, AliasType):
        self._AliasType = AliasType

    @property
    def AliasInstanceId(self):
        """实例id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AliasInstanceId

    @AliasInstanceId.setter
    def AliasInstanceId(self, AliasInstanceId):
        self._AliasInstanceId = AliasInstanceId


    def _deserialize(self, params):
        self._RouteId = params.get("RouteId")
        self._DestinationCidrBlock = params.get("DestinationCidrBlock")
        self._InstanceType = params.get("InstanceType")
        self._InstanceId = params.get("InstanceId")
        self._InstanceName = params.get("InstanceName")
        self._InstanceRegion = params.get("InstanceRegion")
        self._UpdateTime = params.get("UpdateTime")
        self._Enabled = params.get("Enabled")
        self._InstanceUin = params.get("InstanceUin")
        self._ExtraState = params.get("ExtraState")
        self._IsBgp = params.get("IsBgp")
        self._RoutePriority = params.get("RoutePriority")
        self._InstanceExtraName = params.get("InstanceExtraName")
        self._AliasType = params.get("AliasType")
        self._AliasInstanceId = params.get("AliasInstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CcnRouteBroadcastPolicyRouteCondition(AbstractModel):
    """云联网路由传播策略之路由条件

    """

    def __init__(self):
        r"""
        :param _Name: 条件类型
        :type Name: str
        :param _Values: 条件值列表
        :type Values: list of str
        :param _MatchPattern: 匹配模式，`1` 精确匹配，`0` 模糊匹配
        :type MatchPattern: int
        """
        self._Name = None
        self._Values = None
        self._MatchPattern = None

    @property
    def Name(self):
        """条件类型
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Values(self):
        """条件值列表
        :rtype: list of str
        """
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values

    @property
    def MatchPattern(self):
        """匹配模式，`1` 精确匹配，`0` 模糊匹配
        :rtype: int
        """
        return self._MatchPattern

    @MatchPattern.setter
    def MatchPattern(self, MatchPattern):
        self._MatchPattern = MatchPattern


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Values = params.get("Values")
        self._MatchPattern = params.get("MatchPattern")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CcnRouteTable(AbstractModel):
    """云联网路由表信息

    """

    def __init__(self):
        r"""
        :param _CcnId: 云联网ID。
        :type CcnId: str
        :param _CcnRouteTableId: 云联网路由表ID。
        :type CcnRouteTableId: str
        :param _RouteTableName: 云联网路由表名称。
        :type RouteTableName: str
        :param _RouteTableDescription: 云联网路由表描述。
        :type RouteTableDescription: str
        :param _IsDefaultTable: True：是默认路由表 False：非默认路由表。
        :type IsDefaultTable: bool
        :param _CreateTime: 创建时间。
        :type CreateTime: str
        """
        self._CcnId = None
        self._CcnRouteTableId = None
        self._RouteTableName = None
        self._RouteTableDescription = None
        self._IsDefaultTable = None
        self._CreateTime = None

    @property
    def CcnId(self):
        """云联网ID。
        :rtype: str
        """
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId

    @property
    def CcnRouteTableId(self):
        """云联网路由表ID。
        :rtype: str
        """
        return self._CcnRouteTableId

    @CcnRouteTableId.setter
    def CcnRouteTableId(self, CcnRouteTableId):
        self._CcnRouteTableId = CcnRouteTableId

    @property
    def RouteTableName(self):
        """云联网路由表名称。
        :rtype: str
        """
        return self._RouteTableName

    @RouteTableName.setter
    def RouteTableName(self, RouteTableName):
        self._RouteTableName = RouteTableName

    @property
    def RouteTableDescription(self):
        """云联网路由表描述。
        :rtype: str
        """
        return self._RouteTableDescription

    @RouteTableDescription.setter
    def RouteTableDescription(self, RouteTableDescription):
        self._RouteTableDescription = RouteTableDescription

    @property
    def IsDefaultTable(self):
        """True：是默认路由表 False：非默认路由表。
        :rtype: bool
        """
        return self._IsDefaultTable

    @IsDefaultTable.setter
    def IsDefaultTable(self, IsDefaultTable):
        self._IsDefaultTable = IsDefaultTable

    @property
    def CreateTime(self):
        """创建时间。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime


    def _deserialize(self, params):
        self._CcnId = params.get("CcnId")
        self._CcnRouteTableId = params.get("CcnRouteTableId")
        self._RouteTableName = params.get("RouteTableName")
        self._RouteTableDescription = params.get("RouteTableDescription")
        self._IsDefaultTable = params.get("IsDefaultTable")
        self._CreateTime = params.get("CreateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CcnRouteTableBroadcastPolicy(AbstractModel):
    """云联网路由传播策略

    """

    def __init__(self):
        r"""
        :param _RouteConditions: 路由条件
        :type RouteConditions: list of CcnRouteBroadcastPolicyRouteCondition
        :param _BroadcastConditions: 传播条件
        :type BroadcastConditions: list of CcnRouteBroadcastPolicyRouteCondition
        :param _Action: 路由行为，`accept` 允许，`drop` 拒绝
        :type Action: str
        :param _Description: 策略描述
        :type Description: str
        :param _OperateAsPath: as-path操作
注意：此字段可能返回 null，表示取不到有效值。
        :type OperateAsPath: str
        :param _AsPathOperateMode: as-path操作模式
注意：此字段可能返回 null，表示取不到有效值。
        :type AsPathOperateMode: str
        :param _OperateCommunitySet: community操作
注意：此字段可能返回 null，表示取不到有效值。
        :type OperateCommunitySet: list of str
        :param _CommunityOperateMode: community操作模式
注意：此字段可能返回 null，表示取不到有效值。
        :type CommunityOperateMode: str
        """
        self._RouteConditions = None
        self._BroadcastConditions = None
        self._Action = None
        self._Description = None
        self._OperateAsPath = None
        self._AsPathOperateMode = None
        self._OperateCommunitySet = None
        self._CommunityOperateMode = None

    @property
    def RouteConditions(self):
        """路由条件
        :rtype: list of CcnRouteBroadcastPolicyRouteCondition
        """
        return self._RouteConditions

    @RouteConditions.setter
    def RouteConditions(self, RouteConditions):
        self._RouteConditions = RouteConditions

    @property
    def BroadcastConditions(self):
        """传播条件
        :rtype: list of CcnRouteBroadcastPolicyRouteCondition
        """
        return self._BroadcastConditions

    @BroadcastConditions.setter
    def BroadcastConditions(self, BroadcastConditions):
        self._BroadcastConditions = BroadcastConditions

    @property
    def Action(self):
        """路由行为，`accept` 允许，`drop` 拒绝
        :rtype: str
        """
        return self._Action

    @Action.setter
    def Action(self, Action):
        self._Action = Action

    @property
    def Description(self):
        """策略描述
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def OperateAsPath(self):
        """as-path操作
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._OperateAsPath

    @OperateAsPath.setter
    def OperateAsPath(self, OperateAsPath):
        self._OperateAsPath = OperateAsPath

    @property
    def AsPathOperateMode(self):
        """as-path操作模式
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AsPathOperateMode

    @AsPathOperateMode.setter
    def AsPathOperateMode(self, AsPathOperateMode):
        self._AsPathOperateMode = AsPathOperateMode

    @property
    def OperateCommunitySet(self):
        """community操作
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._OperateCommunitySet

    @OperateCommunitySet.setter
    def OperateCommunitySet(self, OperateCommunitySet):
        self._OperateCommunitySet = OperateCommunitySet

    @property
    def CommunityOperateMode(self):
        """community操作模式
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CommunityOperateMode

    @CommunityOperateMode.setter
    def CommunityOperateMode(self, CommunityOperateMode):
        self._CommunityOperateMode = CommunityOperateMode


    def _deserialize(self, params):
        if params.get("RouteConditions") is not None:
            self._RouteConditions = []
            for item in params.get("RouteConditions"):
                obj = CcnRouteBroadcastPolicyRouteCondition()
                obj._deserialize(item)
                self._RouteConditions.append(obj)
        if params.get("BroadcastConditions") is not None:
            self._BroadcastConditions = []
            for item in params.get("BroadcastConditions"):
                obj = CcnRouteBroadcastPolicyRouteCondition()
                obj._deserialize(item)
                self._BroadcastConditions.append(obj)
        self._Action = params.get("Action")
        self._Description = params.get("Description")
        self._OperateAsPath = params.get("OperateAsPath")
        self._AsPathOperateMode = params.get("AsPathOperateMode")
        self._OperateCommunitySet = params.get("OperateCommunitySet")
        self._CommunityOperateMode = params.get("CommunityOperateMode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CcnRouteTableBroadcastPolicys(AbstractModel):
    """云联网路由传播策略列表

    """

    def __init__(self):
        r"""
        :param _Policys: 策略列表
        :type Policys: list of CcnRouteTableBroadcastPolicy
        :param _PolicyVersion: 版本号
        :type PolicyVersion: int
        :param _CreateTime: 创建时间
        :type CreateTime: str
        """
        self._Policys = None
        self._PolicyVersion = None
        self._CreateTime = None

    @property
    def Policys(self):
        """策略列表
        :rtype: list of CcnRouteTableBroadcastPolicy
        """
        return self._Policys

    @Policys.setter
    def Policys(self, Policys):
        self._Policys = Policys

    @property
    def PolicyVersion(self):
        """版本号
        :rtype: int
        """
        return self._PolicyVersion

    @PolicyVersion.setter
    def PolicyVersion(self, PolicyVersion):
        self._PolicyVersion = PolicyVersion

    @property
    def CreateTime(self):
        """创建时间
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime


    def _deserialize(self, params):
        if params.get("Policys") is not None:
            self._Policys = []
            for item in params.get("Policys"):
                obj = CcnRouteTableBroadcastPolicy()
                obj._deserialize(item)
                self._Policys.append(obj)
        self._PolicyVersion = params.get("PolicyVersion")
        self._CreateTime = params.get("CreateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CcnRouteTableInputPolicy(AbstractModel):
    """云联网路由接收策略

    """

    def __init__(self):
        r"""
        :param _RouteConditions: 路由条件。
        :type RouteConditions: list of CcnRouteBroadcastPolicyRouteCondition
        :param _Action: 路由行为，`accept` 允许，`drop` 拒绝。
        :type Action: str
        :param _Description: 策略描述。
        :type Description: str
        :param _OperateAsPath: as-path操作
注意：此字段可能返回 null，表示取不到有效值。
        :type OperateAsPath: str
        :param _AsPathOperateMode: as-path操作模式
注意：此字段可能返回 null，表示取不到有效值。
        :type AsPathOperateMode: str
        """
        self._RouteConditions = None
        self._Action = None
        self._Description = None
        self._OperateAsPath = None
        self._AsPathOperateMode = None

    @property
    def RouteConditions(self):
        """路由条件。
        :rtype: list of CcnRouteBroadcastPolicyRouteCondition
        """
        return self._RouteConditions

    @RouteConditions.setter
    def RouteConditions(self, RouteConditions):
        self._RouteConditions = RouteConditions

    @property
    def Action(self):
        """路由行为，`accept` 允许，`drop` 拒绝。
        :rtype: str
        """
        return self._Action

    @Action.setter
    def Action(self, Action):
        self._Action = Action

    @property
    def Description(self):
        """策略描述。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def OperateAsPath(self):
        """as-path操作
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._OperateAsPath

    @OperateAsPath.setter
    def OperateAsPath(self, OperateAsPath):
        self._OperateAsPath = OperateAsPath

    @property
    def AsPathOperateMode(self):
        """as-path操作模式
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AsPathOperateMode

    @AsPathOperateMode.setter
    def AsPathOperateMode(self, AsPathOperateMode):
        self._AsPathOperateMode = AsPathOperateMode


    def _deserialize(self, params):
        if params.get("RouteConditions") is not None:
            self._RouteConditions = []
            for item in params.get("RouteConditions"):
                obj = CcnRouteBroadcastPolicyRouteCondition()
                obj._deserialize(item)
                self._RouteConditions.append(obj)
        self._Action = params.get("Action")
        self._Description = params.get("Description")
        self._OperateAsPath = params.get("OperateAsPath")
        self._AsPathOperateMode = params.get("AsPathOperateMode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CcnRouteTableInputPolicys(AbstractModel):
    """云联网路由接收策略列表

    """

    def __init__(self):
        r"""
        :param _Policys: 策略列表。
注意：此字段可能返回 null，表示取不到有效值。
        :type Policys: list of CcnRouteTableInputPolicy
        :param _PolicyVersion: 版本号。
注意：此字段可能返回 null，表示取不到有效值。
        :type PolicyVersion: int
        :param _CreateTime: 创建时间。
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateTime: str
        """
        self._Policys = None
        self._PolicyVersion = None
        self._CreateTime = None

    @property
    def Policys(self):
        """策略列表。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of CcnRouteTableInputPolicy
        """
        return self._Policys

    @Policys.setter
    def Policys(self, Policys):
        self._Policys = Policys

    @property
    def PolicyVersion(self):
        """版本号。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._PolicyVersion

    @PolicyVersion.setter
    def PolicyVersion(self, PolicyVersion):
        self._PolicyVersion = PolicyVersion

    @property
    def CreateTime(self):
        """创建时间。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime


    def _deserialize(self, params):
        if params.get("Policys") is not None:
            self._Policys = []
            for item in params.get("Policys"):
                obj = CcnRouteTableInputPolicy()
                obj._deserialize(item)
                self._Policys.append(obj)
        self._PolicyVersion = params.get("PolicyVersion")
        self._CreateTime = params.get("CreateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CcnRouteTableSelectPolicy(AbstractModel):
    """路由表选择策略信息

    """

    def __init__(self):
        r"""
        :param _InstanceType: 实例类型：
私有网络: `VPC`
专线网关: `DIRECTCONNECT`
黑石私有网络: `BMVPC`
EDGE设备: `EDGE`
EDGE隧道: `EDGE_TUNNEL`
EDGE网关: `EDGE_VPNGW`
VPN网关：`VPNGW`
        :type InstanceType: str
        :param _InstanceId: 实例ID。
        :type InstanceId: str
        :param _SourceCidrBlock: 源端CIDR。
        :type SourceCidrBlock: str
        :param _RouteTableId: 路由表ID。
        :type RouteTableId: str
        :param _Description: 路由表备注。
        :type Description: str
        """
        self._InstanceType = None
        self._InstanceId = None
        self._SourceCidrBlock = None
        self._RouteTableId = None
        self._Description = None

    @property
    def InstanceType(self):
        """实例类型：
私有网络: `VPC`
专线网关: `DIRECTCONNECT`
黑石私有网络: `BMVPC`
EDGE设备: `EDGE`
EDGE隧道: `EDGE_TUNNEL`
EDGE网关: `EDGE_VPNGW`
VPN网关：`VPNGW`
        :rtype: str
        """
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def InstanceId(self):
        """实例ID。
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def SourceCidrBlock(self):
        """源端CIDR。
        :rtype: str
        """
        return self._SourceCidrBlock

    @SourceCidrBlock.setter
    def SourceCidrBlock(self, SourceCidrBlock):
        self._SourceCidrBlock = SourceCidrBlock

    @property
    def RouteTableId(self):
        """路由表ID。
        :rtype: str
        """
        return self._RouteTableId

    @RouteTableId.setter
    def RouteTableId(self, RouteTableId):
        self._RouteTableId = RouteTableId

    @property
    def Description(self):
        """路由表备注。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._InstanceType = params.get("InstanceType")
        self._InstanceId = params.get("InstanceId")
        self._SourceCidrBlock = params.get("SourceCidrBlock")
        self._RouteTableId = params.get("RouteTableId")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckAssistantCidrRequest(AbstractModel):
    """CheckAssistantCidr请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VpcId: `VPC`实例`ID`。形如：`vpc-6v2ht8q5`
        :type VpcId: str
        :param _NewCidrBlocks: 待添加的辅助CIDR。CIDR数组，格式如["10.0.0.0/16", "172.16.0.0/16"]。入参NewCidrBlocks和OldCidrBlocks至少需要其一。
        :type NewCidrBlocks: list of str
        :param _OldCidrBlocks: 待删除的辅助CIDR。CIDR数组，格式如["10.0.0.0/16", "172.16.0.0/16"]。入参NewCidrBlocks和OldCidrBlocks至少需要其一。
        :type OldCidrBlocks: list of str
        """
        self._VpcId = None
        self._NewCidrBlocks = None
        self._OldCidrBlocks = None

    @property
    def VpcId(self):
        """`VPC`实例`ID`。形如：`vpc-6v2ht8q5`
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def NewCidrBlocks(self):
        """待添加的辅助CIDR。CIDR数组，格式如["10.0.0.0/16", "172.16.0.0/16"]。入参NewCidrBlocks和OldCidrBlocks至少需要其一。
        :rtype: list of str
        """
        return self._NewCidrBlocks

    @NewCidrBlocks.setter
    def NewCidrBlocks(self, NewCidrBlocks):
        self._NewCidrBlocks = NewCidrBlocks

    @property
    def OldCidrBlocks(self):
        """待删除的辅助CIDR。CIDR数组，格式如["10.0.0.0/16", "172.16.0.0/16"]。入参NewCidrBlocks和OldCidrBlocks至少需要其一。
        :rtype: list of str
        """
        return self._OldCidrBlocks

    @OldCidrBlocks.setter
    def OldCidrBlocks(self, OldCidrBlocks):
        self._OldCidrBlocks = OldCidrBlocks


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._NewCidrBlocks = params.get("NewCidrBlocks")
        self._OldCidrBlocks = params.get("OldCidrBlocks")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckAssistantCidrResponse(AbstractModel):
    """CheckAssistantCidr返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ConflictSourceSet: 冲突资源信息数组。
        :type ConflictSourceSet: list of ConflictSource
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ConflictSourceSet = None
        self._RequestId = None

    @property
    def ConflictSourceSet(self):
        """冲突资源信息数组。
        :rtype: list of ConflictSource
        """
        return self._ConflictSourceSet

    @ConflictSourceSet.setter
    def ConflictSourceSet(self, ConflictSourceSet):
        self._ConflictSourceSet = ConflictSourceSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ConflictSourceSet") is not None:
            self._ConflictSourceSet = []
            for item in params.get("ConflictSourceSet"):
                obj = ConflictSource()
                obj._deserialize(item)
                self._ConflictSourceSet.append(obj)
        self._RequestId = params.get("RequestId")


class CheckDefaultSubnetRequest(AbstractModel):
    """CheckDefaultSubnet请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Zone: 子网所在的可用区ID，不同子网选择不同可用区可以做跨可用区灾备。
        :type Zone: str
        """
        self._Zone = None

    @property
    def Zone(self):
        """子网所在的可用区ID，不同子网选择不同可用区可以做跨可用区灾备。
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone


    def _deserialize(self, params):
        self._Zone = params.get("Zone")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckDefaultSubnetResponse(AbstractModel):
    """CheckDefaultSubnet返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Result: 检查结果。true为可以创建默认子网，false为不可以创建默认子网。
        :type Result: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        """检查结果。true为可以创建默认子网，false为不可以创建默认子网。
        :rtype: bool
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class CheckNetDetectStateRequest(AbstractModel):
    """CheckNetDetectState请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DetectDestinationIp: 探测目的IPv4地址数组，最多两个。
        :type DetectDestinationIp: list of str
        :param _NetDetectId: 网络探测实例ID。形如：netd-12345678。该参数与（VpcId，SubnetId，NetDetectName），至少要有一个。当NetDetectId存在时，使用NetDetectId。
        :type NetDetectId: str
        :param _VpcId: `VPC`实例`ID`。形如：`vpc-12345678`。该参数与（SubnetId，NetDetectName）配合使用，与NetDetectId至少要有一个。当NetDetectId存在时，使用NetDetectId。
        :type VpcId: str
        :param _SubnetId: 子网实例ID。形如：subnet-12345678。该参数与（VpcId，NetDetectName）配合使用，与NetDetectId至少要有一个。当NetDetectId存在时，使用NetDetectId。
        :type SubnetId: str
        :param _NetDetectName: 网络探测名称，最大长度不能超过60个字节。该参数与（VpcId，SubnetId）配合使用，与NetDetectId至少要有一个。当NetDetectId存在时，使用NetDetectId。
        :type NetDetectName: str
        :param _NextHopType: 下一跳类型，目前我们支持的类型有：
VPN：VPN网关；
DIRECTCONNECT：专线网关；
PEERCONNECTION：对等连接；
NAT：NAT网关；
NORMAL_CVM：普通云服务器；
CCN：云联网网关；
NONEXTHOP：无下一跳；
        :type NextHopType: str
        :param _NextHopDestination: 下一跳目的网关，取值与“下一跳类型”相关：
下一跳类型为VPN，取值VPN网关ID，形如：vpngw-12345678；
下一跳类型为DIRECTCONNECT，取值专线网关ID，形如：dcg-12345678；
下一跳类型为PEERCONNECTION，取值对等连接ID，形如：pcx-12345678；
下一跳类型为NAT，取值Nat网关，形如：nat-12345678；
下一跳类型为NORMAL_CVM，取值云服务器IPv4地址，形如：10.0.0.12；
下一跳类型为CCN，取值云联网ID，形如：ccn-12345678；
下一跳类型为NONEXTHOP，指定网络探测为无下一跳的网络探测；
        :type NextHopDestination: str
        """
        self._DetectDestinationIp = None
        self._NetDetectId = None
        self._VpcId = None
        self._SubnetId = None
        self._NetDetectName = None
        self._NextHopType = None
        self._NextHopDestination = None

    @property
    def DetectDestinationIp(self):
        """探测目的IPv4地址数组，最多两个。
        :rtype: list of str
        """
        return self._DetectDestinationIp

    @DetectDestinationIp.setter
    def DetectDestinationIp(self, DetectDestinationIp):
        self._DetectDestinationIp = DetectDestinationIp

    @property
    def NetDetectId(self):
        """网络探测实例ID。形如：netd-12345678。该参数与（VpcId，SubnetId，NetDetectName），至少要有一个。当NetDetectId存在时，使用NetDetectId。
        :rtype: str
        """
        return self._NetDetectId

    @NetDetectId.setter
    def NetDetectId(self, NetDetectId):
        self._NetDetectId = NetDetectId

    @property
    def VpcId(self):
        """`VPC`实例`ID`。形如：`vpc-12345678`。该参数与（SubnetId，NetDetectName）配合使用，与NetDetectId至少要有一个。当NetDetectId存在时，使用NetDetectId。
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        """子网实例ID。形如：subnet-12345678。该参数与（VpcId，NetDetectName）配合使用，与NetDetectId至少要有一个。当NetDetectId存在时，使用NetDetectId。
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def NetDetectName(self):
        """网络探测名称，最大长度不能超过60个字节。该参数与（VpcId，SubnetId）配合使用，与NetDetectId至少要有一个。当NetDetectId存在时，使用NetDetectId。
        :rtype: str
        """
        return self._NetDetectName

    @NetDetectName.setter
    def NetDetectName(self, NetDetectName):
        self._NetDetectName = NetDetectName

    @property
    def NextHopType(self):
        """下一跳类型，目前我们支持的类型有：
VPN：VPN网关；
DIRECTCONNECT：专线网关；
PEERCONNECTION：对等连接；
NAT：NAT网关；
NORMAL_CVM：普通云服务器；
CCN：云联网网关；
NONEXTHOP：无下一跳；
        :rtype: str
        """
        return self._NextHopType

    @NextHopType.setter
    def NextHopType(self, NextHopType):
        self._NextHopType = NextHopType

    @property
    def NextHopDestination(self):
        """下一跳目的网关，取值与“下一跳类型”相关：
下一跳类型为VPN，取值VPN网关ID，形如：vpngw-12345678；
下一跳类型为DIRECTCONNECT，取值专线网关ID，形如：dcg-12345678；
下一跳类型为PEERCONNECTION，取值对等连接ID，形如：pcx-12345678；
下一跳类型为NAT，取值Nat网关，形如：nat-12345678；
下一跳类型为NORMAL_CVM，取值云服务器IPv4地址，形如：10.0.0.12；
下一跳类型为CCN，取值云联网ID，形如：ccn-12345678；
下一跳类型为NONEXTHOP，指定网络探测为无下一跳的网络探测；
        :rtype: str
        """
        return self._NextHopDestination

    @NextHopDestination.setter
    def NextHopDestination(self, NextHopDestination):
        self._NextHopDestination = NextHopDestination


    def _deserialize(self, params):
        self._DetectDestinationIp = params.get("DetectDestinationIp")
        self._NetDetectId = params.get("NetDetectId")
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._NetDetectName = params.get("NetDetectName")
        self._NextHopType = params.get("NextHopType")
        self._NextHopDestination = params.get("NextHopDestination")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckNetDetectStateResponse(AbstractModel):
    """CheckNetDetectState返回参数结构体

    """

    def __init__(self):
        r"""
        :param _NetDetectIpStateSet: 网络探测验证结果对象数组。
        :type NetDetectIpStateSet: list of NetDetectIpState
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._NetDetectIpStateSet = None
        self._RequestId = None

    @property
    def NetDetectIpStateSet(self):
        """网络探测验证结果对象数组。
        :rtype: list of NetDetectIpState
        """
        return self._NetDetectIpStateSet

    @NetDetectIpStateSet.setter
    def NetDetectIpStateSet(self, NetDetectIpStateSet):
        self._NetDetectIpStateSet = NetDetectIpStateSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NetDetectIpStateSet") is not None:
            self._NetDetectIpStateSet = []
            for item in params.get("NetDetectIpStateSet"):
                obj = NetDetectIpState()
                obj._deserialize(item)
                self._NetDetectIpStateSet.append(obj)
        self._RequestId = params.get("RequestId")


class CidrForCcn(AbstractModel):
    """用于发布云联网的cidr信息

    """

    def __init__(self):
        r"""
        :param _Cidr: local cidr值。
注意：此字段可能返回 null，表示取不到有效值。
        :type Cidr: str
        :param _PublishedToVbc: 是否发布到了云联网。
注意：此字段可能返回 null，表示取不到有效值。
        :type PublishedToVbc: bool
        """
        self._Cidr = None
        self._PublishedToVbc = None

    @property
    def Cidr(self):
        """local cidr值。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Cidr

    @Cidr.setter
    def Cidr(self, Cidr):
        self._Cidr = Cidr

    @property
    def PublishedToVbc(self):
        """是否发布到了云联网。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._PublishedToVbc

    @PublishedToVbc.setter
    def PublishedToVbc(self, PublishedToVbc):
        self._PublishedToVbc = PublishedToVbc


    def _deserialize(self, params):
        self._Cidr = params.get("Cidr")
        self._PublishedToVbc = params.get("PublishedToVbc")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClassicLinkInstance(AbstractModel):
    """私有网络和基础网络互通设备

    """

    def __init__(self):
        r"""
        :param _VpcId: VPC实例ID
注意：此字段可能返回 null，表示取不到有效值。
        :type VpcId: str
        :param _InstanceId: 云服务器实例唯一ID
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceId: str
        """
        self._VpcId = None
        self._InstanceId = None

    @property
    def VpcId(self):
        """VPC实例ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def InstanceId(self):
        """云服务器实例唯一ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClearRouteTableSelectionPoliciesRequest(AbstractModel):
    """ClearRouteTableSelectionPolicies请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CcnId: 云联网ID。
        :type CcnId: str
        """
        self._CcnId = None

    @property
    def CcnId(self):
        """云联网ID。
        :rtype: str
        """
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId


    def _deserialize(self, params):
        self._CcnId = params.get("CcnId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClearRouteTableSelectionPoliciesResponse(AbstractModel):
    """ClearRouteTableSelectionPolicies返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CloneSecurityGroupRequest(AbstractModel):
    """CloneSecurityGroup请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SecurityGroupId: 安全组实例ID，例如sg-33ocnj9n，可通过<a href="https://cloud.tencent.com/document/product/215/15808">DescribeSecurityGroups</a>获取。
        :type SecurityGroupId: str
        :param _GroupName: 安全组名称，可任意命名，但不得超过60个字符。未提供参数时，克隆后的安全组名称和SecurityGroupId对应的安全组名称相同。
        :type GroupName: str
        :param _GroupDescription: 安全组备注，最多100个字符。未提供参数时，克隆后的安全组备注和SecurityGroupId对应的安全组备注相同。
        :type GroupDescription: str
        :param _ProjectId: 项目ID，默认0。可在<a href="https://console.cloud.tencent.com/project">qcloud控制台项目管理页面</a>查询到。
        :type ProjectId: str
        :param _RemoteRegion: 源Region,跨地域克隆安全组时，需要传入源安全组所属地域信息，例如：克隆广州的安全组到上海，则这里需要传入广州安全的地域信息：ap-guangzhou。
        :type RemoteRegion: str
        :param _Tags: 指定绑定的标签列表，例如：[{"Key": "city", "Value": "shanghai"}]。
若指定Tags入参且指定IsCloneTags为true，会合并源安全组的标签和新增的标签。
        :type Tags: :class:`tencentcloud.vpc.v20170312.models.Tag`
        """
        self._SecurityGroupId = None
        self._GroupName = None
        self._GroupDescription = None
        self._ProjectId = None
        self._RemoteRegion = None
        self._Tags = None

    @property
    def SecurityGroupId(self):
        """安全组实例ID，例如sg-33ocnj9n，可通过<a href="https://cloud.tencent.com/document/product/215/15808">DescribeSecurityGroups</a>获取。
        :rtype: str
        """
        return self._SecurityGroupId

    @SecurityGroupId.setter
    def SecurityGroupId(self, SecurityGroupId):
        self._SecurityGroupId = SecurityGroupId

    @property
    def GroupName(self):
        """安全组名称，可任意命名，但不得超过60个字符。未提供参数时，克隆后的安全组名称和SecurityGroupId对应的安全组名称相同。
        :rtype: str
        """
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName

    @property
    def GroupDescription(self):
        """安全组备注，最多100个字符。未提供参数时，克隆后的安全组备注和SecurityGroupId对应的安全组备注相同。
        :rtype: str
        """
        return self._GroupDescription

    @GroupDescription.setter
    def GroupDescription(self, GroupDescription):
        self._GroupDescription = GroupDescription

    @property
    def ProjectId(self):
        """项目ID，默认0。可在<a href="https://console.cloud.tencent.com/project">qcloud控制台项目管理页面</a>查询到。
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def RemoteRegion(self):
        """源Region,跨地域克隆安全组时，需要传入源安全组所属地域信息，例如：克隆广州的安全组到上海，则这里需要传入广州安全的地域信息：ap-guangzhou。
        :rtype: str
        """
        return self._RemoteRegion

    @RemoteRegion.setter
    def RemoteRegion(self, RemoteRegion):
        self._RemoteRegion = RemoteRegion

    @property
    def Tags(self):
        """指定绑定的标签列表，例如：[{"Key": "city", "Value": "shanghai"}]。
若指定Tags入参且指定IsCloneTags为true，会合并源安全组的标签和新增的标签。
        :rtype: :class:`tencentcloud.vpc.v20170312.models.Tag`
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._SecurityGroupId = params.get("SecurityGroupId")
        self._GroupName = params.get("GroupName")
        self._GroupDescription = params.get("GroupDescription")
        self._ProjectId = params.get("ProjectId")
        self._RemoteRegion = params.get("RemoteRegion")
        if params.get("Tags") is not None:
            self._Tags = Tag()
            self._Tags._deserialize(params.get("Tags"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CloneSecurityGroupResponse(AbstractModel):
    """CloneSecurityGroup返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SecurityGroup: 安全组对象。
        :type SecurityGroup: :class:`tencentcloud.vpc.v20170312.models.SecurityGroup`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SecurityGroup = None
        self._RequestId = None

    @property
    def SecurityGroup(self):
        """安全组对象。
        :rtype: :class:`tencentcloud.vpc.v20170312.models.SecurityGroup`
        """
        return self._SecurityGroup

    @SecurityGroup.setter
    def SecurityGroup(self, SecurityGroup):
        self._SecurityGroup = SecurityGroup

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SecurityGroup") is not None:
            self._SecurityGroup = SecurityGroup()
            self._SecurityGroup._deserialize(params.get("SecurityGroup"))
        self._RequestId = params.get("RequestId")


class ConflictItem(AbstractModel):
    """冲突资源条目信息。

    """

    def __init__(self):
        r"""
        :param _ConfilctId: 冲突资源的ID。已废弃
        :type ConfilctId: str
        :param _DestinationItem: 冲突目的资源
        :type DestinationItem: str
        :param _ConflictId: 冲突资源的ID
        :type ConflictId: str
        """
        self._ConfilctId = None
        self._DestinationItem = None
        self._ConflictId = None

    @property
    def ConfilctId(self):
        """冲突资源的ID。已废弃
        :rtype: str
        """
        return self._ConfilctId

    @ConfilctId.setter
    def ConfilctId(self, ConfilctId):
        self._ConfilctId = ConfilctId

    @property
    def DestinationItem(self):
        """冲突目的资源
        :rtype: str
        """
        return self._DestinationItem

    @DestinationItem.setter
    def DestinationItem(self, DestinationItem):
        self._DestinationItem = DestinationItem

    @property
    def ConflictId(self):
        """冲突资源的ID
        :rtype: str
        """
        return self._ConflictId

    @ConflictId.setter
    def ConflictId(self, ConflictId):
        self._ConflictId = ConflictId


    def _deserialize(self, params):
        self._ConfilctId = params.get("ConfilctId")
        self._DestinationItem = params.get("DestinationItem")
        self._ConflictId = params.get("ConflictId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ConflictSource(AbstractModel):
    """冲突资源信息。

    """

    def __init__(self):
        r"""
        :param _ConflictSourceId: 冲突资源ID
        :type ConflictSourceId: str
        :param _SourceItem: 冲突资源
        :type SourceItem: str
        :param _ConflictItemSet: 冲突资源条目信息
        :type ConflictItemSet: list of ConflictItem
        """
        self._ConflictSourceId = None
        self._SourceItem = None
        self._ConflictItemSet = None

    @property
    def ConflictSourceId(self):
        """冲突资源ID
        :rtype: str
        """
        return self._ConflictSourceId

    @ConflictSourceId.setter
    def ConflictSourceId(self, ConflictSourceId):
        self._ConflictSourceId = ConflictSourceId

    @property
    def SourceItem(self):
        """冲突资源
        :rtype: str
        """
        return self._SourceItem

    @SourceItem.setter
    def SourceItem(self, SourceItem):
        self._SourceItem = SourceItem

    @property
    def ConflictItemSet(self):
        """冲突资源条目信息
        :rtype: list of ConflictItem
        """
        return self._ConflictItemSet

    @ConflictItemSet.setter
    def ConflictItemSet(self, ConflictItemSet):
        self._ConflictItemSet = ConflictItemSet


    def _deserialize(self, params):
        self._ConflictSourceId = params.get("ConflictSourceId")
        self._SourceItem = params.get("SourceItem")
        if params.get("ConflictItemSet") is not None:
            self._ConflictItemSet = []
            for item in params.get("ConflictItemSet"):
                obj = ConflictItem()
                obj._deserialize(item)
                self._ConflictItemSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAddressTemplateGroupRequest(AbstractModel):
    """CreateAddressTemplateGroup请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AddressTemplateGroupName: IP地址模板集合名称。
        :type AddressTemplateGroupName: str
        :param _AddressTemplateIds: IP地址模板实例ID，例如：ipm-mdunqeb6。
        :type AddressTemplateIds: list of str
        """
        self._AddressTemplateGroupName = None
        self._AddressTemplateIds = None

    @property
    def AddressTemplateGroupName(self):
        """IP地址模板集合名称。
        :rtype: str
        """
        return self._AddressTemplateGroupName

    @AddressTemplateGroupName.setter
    def AddressTemplateGroupName(self, AddressTemplateGroupName):
        self._AddressTemplateGroupName = AddressTemplateGroupName

    @property
    def AddressTemplateIds(self):
        """IP地址模板实例ID，例如：ipm-mdunqeb6。
        :rtype: list of str
        """
        return self._AddressTemplateIds

    @AddressTemplateIds.setter
    def AddressTemplateIds(self, AddressTemplateIds):
        self._AddressTemplateIds = AddressTemplateIds


    def _deserialize(self, params):
        self._AddressTemplateGroupName = params.get("AddressTemplateGroupName")
        self._AddressTemplateIds = params.get("AddressTemplateIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAddressTemplateGroupResponse(AbstractModel):
    """CreateAddressTemplateGroup返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AddressTemplateGroup: IP地址模板集合对象。
        :type AddressTemplateGroup: :class:`tencentcloud.vpc.v20170312.models.AddressTemplateGroup`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AddressTemplateGroup = None
        self._RequestId = None

    @property
    def AddressTemplateGroup(self):
        """IP地址模板集合对象。
        :rtype: :class:`tencentcloud.vpc.v20170312.models.AddressTemplateGroup`
        """
        return self._AddressTemplateGroup

    @AddressTemplateGroup.setter
    def AddressTemplateGroup(self, AddressTemplateGroup):
        self._AddressTemplateGroup = AddressTemplateGroup

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("AddressTemplateGroup") is not None:
            self._AddressTemplateGroup = AddressTemplateGroup()
            self._AddressTemplateGroup._deserialize(params.get("AddressTemplateGroup"))
        self._RequestId = params.get("RequestId")


class CreateAddressTemplateRequest(AbstractModel):
    """CreateAddressTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AddressTemplateName: IP地址模板名称。
        :type AddressTemplateName: str
        :param _Addresses: 地址信息，支持 IP、CIDR、IP 范围。Addresses与AddressesExtra必填其一。
        :type Addresses: list of str
        :param _AddressesExtra: 地址信息，支持携带备注，支持 IP、CIDR、IP 范围。Addresses与AddressesExtra必填其一。
        :type AddressesExtra: list of AddressInfo
        """
        self._AddressTemplateName = None
        self._Addresses = None
        self._AddressesExtra = None

    @property
    def AddressTemplateName(self):
        """IP地址模板名称。
        :rtype: str
        """
        return self._AddressTemplateName

    @AddressTemplateName.setter
    def AddressTemplateName(self, AddressTemplateName):
        self._AddressTemplateName = AddressTemplateName

    @property
    def Addresses(self):
        """地址信息，支持 IP、CIDR、IP 范围。Addresses与AddressesExtra必填其一。
        :rtype: list of str
        """
        return self._Addresses

    @Addresses.setter
    def Addresses(self, Addresses):
        self._Addresses = Addresses

    @property
    def AddressesExtra(self):
        """地址信息，支持携带备注，支持 IP、CIDR、IP 范围。Addresses与AddressesExtra必填其一。
        :rtype: list of AddressInfo
        """
        return self._AddressesExtra

    @AddressesExtra.setter
    def AddressesExtra(self, AddressesExtra):
        self._AddressesExtra = AddressesExtra


    def _deserialize(self, params):
        self._AddressTemplateName = params.get("AddressTemplateName")
        self._Addresses = params.get("Addresses")
        if params.get("AddressesExtra") is not None:
            self._AddressesExtra = []
            for item in params.get("AddressesExtra"):
                obj = AddressInfo()
                obj._deserialize(item)
                self._AddressesExtra.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAddressTemplateResponse(AbstractModel):
    """CreateAddressTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AddressTemplate: IP地址模板对象。
        :type AddressTemplate: :class:`tencentcloud.vpc.v20170312.models.AddressTemplate`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AddressTemplate = None
        self._RequestId = None

    @property
    def AddressTemplate(self):
        """IP地址模板对象。
        :rtype: :class:`tencentcloud.vpc.v20170312.models.AddressTemplate`
        """
        return self._AddressTemplate

    @AddressTemplate.setter
    def AddressTemplate(self, AddressTemplate):
        self._AddressTemplate = AddressTemplate

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("AddressTemplate") is not None:
            self._AddressTemplate = AddressTemplate()
            self._AddressTemplate._deserialize(params.get("AddressTemplate"))
        self._RequestId = params.get("RequestId")


class CreateAndAttachNetworkInterfaceRequest(AbstractModel):
    """CreateAndAttachNetworkInterface请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VpcId: VPC实例ID。可通过DescribeVpcs接口返回值中的VpcId获取。
        :type VpcId: str
        :param _NetworkInterfaceName: 弹性网卡名称，最大长度不能超过60个字节。
        :type NetworkInterfaceName: str
        :param _SubnetId: 弹性网卡所在的子网实例ID，例如：subnet-0ap8nwca。
        :type SubnetId: str
        :param _InstanceId: 云服务器实例ID。
        :type InstanceId: str
        :param _PrivateIpAddresses: 指定的内网IP信息，单次最多指定10个。
        :type PrivateIpAddresses: list of PrivateIpAddressSpecification
        :param _SecondaryPrivateIpAddressCount: 新申请的内网IP地址个数，内网IP地址个数总和不能超过配额数。
        :type SecondaryPrivateIpAddressCount: int
        :param _QosLevel: IP服务质量等级，和SecondaryPrivateIpAddressCount配合使用，可选值：PT、AU、AG、DEFAULT，分别代表云金、云银、云铜、默认四个等级。
        :type QosLevel: str
        :param _SecurityGroupIds: 指定绑定的安全组，例如：['sg-1dd51d']。
        :type SecurityGroupIds: list of str
        :param _NetworkInterfaceDescription: 弹性网卡描述，可任意命名，但不得超过60个字符。
        :type NetworkInterfaceDescription: str
        :param _Tags: 指定绑定的标签列表，例如：[{"Key": "city", "Value": "shanghai"}]。
        :type Tags: list of Tag
        :param _AttachType: 绑定类型：0 标准型 1 扩展型。
        :type AttachType: int
        :param _ClientToken: 用于保证请求幂等性的字符串。该字符串由客户生成，需保证不同请求之间唯一，最大值不超过64个ASCII字符。若不指定该参数，则无法保证请求的幂等性。	
        :type ClientToken: str
        """
        self._VpcId = None
        self._NetworkInterfaceName = None
        self._SubnetId = None
        self._InstanceId = None
        self._PrivateIpAddresses = None
        self._SecondaryPrivateIpAddressCount = None
        self._QosLevel = None
        self._SecurityGroupIds = None
        self._NetworkInterfaceDescription = None
        self._Tags = None
        self._AttachType = None
        self._ClientToken = None

    @property
    def VpcId(self):
        """VPC实例ID。可通过DescribeVpcs接口返回值中的VpcId获取。
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def NetworkInterfaceName(self):
        """弹性网卡名称，最大长度不能超过60个字节。
        :rtype: str
        """
        return self._NetworkInterfaceName

    @NetworkInterfaceName.setter
    def NetworkInterfaceName(self, NetworkInterfaceName):
        self._NetworkInterfaceName = NetworkInterfaceName

    @property
    def SubnetId(self):
        """弹性网卡所在的子网实例ID，例如：subnet-0ap8nwca。
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def InstanceId(self):
        """云服务器实例ID。
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def PrivateIpAddresses(self):
        """指定的内网IP信息，单次最多指定10个。
        :rtype: list of PrivateIpAddressSpecification
        """
        return self._PrivateIpAddresses

    @PrivateIpAddresses.setter
    def PrivateIpAddresses(self, PrivateIpAddresses):
        self._PrivateIpAddresses = PrivateIpAddresses

    @property
    def SecondaryPrivateIpAddressCount(self):
        """新申请的内网IP地址个数，内网IP地址个数总和不能超过配额数。
        :rtype: int
        """
        return self._SecondaryPrivateIpAddressCount

    @SecondaryPrivateIpAddressCount.setter
    def SecondaryPrivateIpAddressCount(self, SecondaryPrivateIpAddressCount):
        self._SecondaryPrivateIpAddressCount = SecondaryPrivateIpAddressCount

    @property
    def QosLevel(self):
        """IP服务质量等级，和SecondaryPrivateIpAddressCount配合使用，可选值：PT、AU、AG、DEFAULT，分别代表云金、云银、云铜、默认四个等级。
        :rtype: str
        """
        return self._QosLevel

    @QosLevel.setter
    def QosLevel(self, QosLevel):
        self._QosLevel = QosLevel

    @property
    def SecurityGroupIds(self):
        """指定绑定的安全组，例如：['sg-1dd51d']。
        :rtype: list of str
        """
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds

    @property
    def NetworkInterfaceDescription(self):
        """弹性网卡描述，可任意命名，但不得超过60个字符。
        :rtype: str
        """
        return self._NetworkInterfaceDescription

    @NetworkInterfaceDescription.setter
    def NetworkInterfaceDescription(self, NetworkInterfaceDescription):
        self._NetworkInterfaceDescription = NetworkInterfaceDescription

    @property
    def Tags(self):
        """指定绑定的标签列表，例如：[{"Key": "city", "Value": "shanghai"}]。
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def AttachType(self):
        """绑定类型：0 标准型 1 扩展型。
        :rtype: int
        """
        return self._AttachType

    @AttachType.setter
    def AttachType(self, AttachType):
        self._AttachType = AttachType

    @property
    def ClientToken(self):
        """用于保证请求幂等性的字符串。该字符串由客户生成，需保证不同请求之间唯一，最大值不超过64个ASCII字符。若不指定该参数，则无法保证请求的幂等性。	
        :rtype: str
        """
        return self._ClientToken

    @ClientToken.setter
    def ClientToken(self, ClientToken):
        self._ClientToken = ClientToken


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._NetworkInterfaceName = params.get("NetworkInterfaceName")
        self._SubnetId = params.get("SubnetId")
        self._InstanceId = params.get("InstanceId")
        if params.get("PrivateIpAddresses") is not None:
            self._PrivateIpAddresses = []
            for item in params.get("PrivateIpAddresses"):
                obj = PrivateIpAddressSpecification()
                obj._deserialize(item)
                self._PrivateIpAddresses.append(obj)
        self._SecondaryPrivateIpAddressCount = params.get("SecondaryPrivateIpAddressCount")
        self._QosLevel = params.get("QosLevel")
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        self._NetworkInterfaceDescription = params.get("NetworkInterfaceDescription")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._AttachType = params.get("AttachType")
        self._ClientToken = params.get("ClientToken")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAndAttachNetworkInterfaceResponse(AbstractModel):
    """CreateAndAttachNetworkInterface返回参数结构体

    """

    def __init__(self):
        r"""
        :param _NetworkInterface: 弹性网卡实例。
        :type NetworkInterface: :class:`tencentcloud.vpc.v20170312.models.NetworkInterface`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._NetworkInterface = None
        self._RequestId = None

    @property
    def NetworkInterface(self):
        """弹性网卡实例。
        :rtype: :class:`tencentcloud.vpc.v20170312.models.NetworkInterface`
        """
        return self._NetworkInterface

    @NetworkInterface.setter
    def NetworkInterface(self, NetworkInterface):
        self._NetworkInterface = NetworkInterface

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NetworkInterface") is not None:
            self._NetworkInterface = NetworkInterface()
            self._NetworkInterface._deserialize(params.get("NetworkInterface"))
        self._RequestId = params.get("RequestId")


class CreateAssistantCidrRequest(AbstractModel):
    """CreateAssistantCidr请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VpcId: `VPC`实例`ID`。形如：`vpc-6v2ht8q5`
        :type VpcId: str
        :param _CidrBlocks: CIDR数组，格式如["10.0.0.0/16", "172.16.0.0/16"]
        :type CidrBlocks: list of str
        """
        self._VpcId = None
        self._CidrBlocks = None

    @property
    def VpcId(self):
        """`VPC`实例`ID`。形如：`vpc-6v2ht8q5`
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def CidrBlocks(self):
        """CIDR数组，格式如["10.0.0.0/16", "172.16.0.0/16"]
        :rtype: list of str
        """
        return self._CidrBlocks

    @CidrBlocks.setter
    def CidrBlocks(self, CidrBlocks):
        self._CidrBlocks = CidrBlocks


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._CidrBlocks = params.get("CidrBlocks")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAssistantCidrResponse(AbstractModel):
    """CreateAssistantCidr返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AssistantCidrSet: 辅助CIDR数组。
        :type AssistantCidrSet: list of AssistantCidr
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AssistantCidrSet = None
        self._RequestId = None

    @property
    def AssistantCidrSet(self):
        """辅助CIDR数组。
        :rtype: list of AssistantCidr
        """
        return self._AssistantCidrSet

    @AssistantCidrSet.setter
    def AssistantCidrSet(self, AssistantCidrSet):
        self._AssistantCidrSet = AssistantCidrSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("AssistantCidrSet") is not None:
            self._AssistantCidrSet = []
            for item in params.get("AssistantCidrSet"):
                obj = AssistantCidr()
                obj._deserialize(item)
                self._AssistantCidrSet.append(obj)
        self._RequestId = params.get("RequestId")


class CreateBandwidthPackageRequest(AbstractModel):
    """CreateBandwidthPackage请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NetworkType: 带宽包类型, 默认值: BGP, 可选值:
<li>BGP: 普通BGP共享带宽包</li>
<li>HIGH_QUALITY_BGP: 精品BGP共享带宽包</li>
<li>SINGLEISP_CMCC: 中国移动共享带宽包</li>
<li>SINGLEISP_CTCC: 中国电信共享带宽包</li>
<li>SINGLEISP_CUCC: 中国联通共享带宽包</li>
        :type NetworkType: str
        :param _ChargeType: 带宽包计费类型, 默认为: ENHANCED95_POSTPAID_BY_MONTH, 可选值:
<li>TOP5_POSTPAID_BY_MONTH: 按月后付费TOP5计费</li>
<li>PERCENT95_POSTPAID_BY_MONTH: 按月后付费月95计费</li>
<li>FIXED_PREPAID_BY_MONTH: 包月预付费计费</li>
<li>ENHANCED95_POSTPAID_BY_MONTH: 按月后付费增强型95计费</li>
<li>PEAK_BANDWIDTH_POSTPAID_BY_DAY: 后付费日结按带宽计费</li>
<li>PRIMARY_TRAFFIC_POSTPAID_BY_HOUR: 后付费按主流量计费</li>

        :type ChargeType: str
        :param _BandwidthPackageName: 带宽包名称。
        :type BandwidthPackageName: str
        :param _BandwidthPackageCount: 带宽包数量(传统账户类型只能填1), 标准账户类型取值范围为1~20。
        :type BandwidthPackageCount: int
        :param _InternetMaxBandwidth: 带宽包限速大小。单位：Mbps，-1表示不限速。不同计费类型的带宽包对应不同的带宽上下限。
        :type InternetMaxBandwidth: int
        :param _Tags: 需要关联的标签列表。
        :type Tags: list of Tag
        :param _Protocol: 带宽包协议类型。当前支持'ipv4'和'ipv6'协议带宽包，默认值是'ipv4'。
        :type Protocol: str
        :param _TimeSpan: 预付费包月带宽包的购买时长，单位: 月，取值范围: 1~60。
        :type TimeSpan: int
        :param _Egress: 网络出口，默认值：center_egress1
        :type Egress: str
        """
        self._NetworkType = None
        self._ChargeType = None
        self._BandwidthPackageName = None
        self._BandwidthPackageCount = None
        self._InternetMaxBandwidth = None
        self._Tags = None
        self._Protocol = None
        self._TimeSpan = None
        self._Egress = None

    @property
    def NetworkType(self):
        """带宽包类型, 默认值: BGP, 可选值:
<li>BGP: 普通BGP共享带宽包</li>
<li>HIGH_QUALITY_BGP: 精品BGP共享带宽包</li>
<li>SINGLEISP_CMCC: 中国移动共享带宽包</li>
<li>SINGLEISP_CTCC: 中国电信共享带宽包</li>
<li>SINGLEISP_CUCC: 中国联通共享带宽包</li>
        :rtype: str
        """
        return self._NetworkType

    @NetworkType.setter
    def NetworkType(self, NetworkType):
        self._NetworkType = NetworkType

    @property
    def ChargeType(self):
        """带宽包计费类型, 默认为: ENHANCED95_POSTPAID_BY_MONTH, 可选值:
<li>TOP5_POSTPAID_BY_MONTH: 按月后付费TOP5计费</li>
<li>PERCENT95_POSTPAID_BY_MONTH: 按月后付费月95计费</li>
<li>FIXED_PREPAID_BY_MONTH: 包月预付费计费</li>
<li>ENHANCED95_POSTPAID_BY_MONTH: 按月后付费增强型95计费</li>
<li>PEAK_BANDWIDTH_POSTPAID_BY_DAY: 后付费日结按带宽计费</li>
<li>PRIMARY_TRAFFIC_POSTPAID_BY_HOUR: 后付费按主流量计费</li>

        :rtype: str
        """
        return self._ChargeType

    @ChargeType.setter
    def ChargeType(self, ChargeType):
        self._ChargeType = ChargeType

    @property
    def BandwidthPackageName(self):
        """带宽包名称。
        :rtype: str
        """
        return self._BandwidthPackageName

    @BandwidthPackageName.setter
    def BandwidthPackageName(self, BandwidthPackageName):
        self._BandwidthPackageName = BandwidthPackageName

    @property
    def BandwidthPackageCount(self):
        """带宽包数量(传统账户类型只能填1), 标准账户类型取值范围为1~20。
        :rtype: int
        """
        return self._BandwidthPackageCount

    @BandwidthPackageCount.setter
    def BandwidthPackageCount(self, BandwidthPackageCount):
        self._BandwidthPackageCount = BandwidthPackageCount

    @property
    def InternetMaxBandwidth(self):
        """带宽包限速大小。单位：Mbps，-1表示不限速。不同计费类型的带宽包对应不同的带宽上下限。
        :rtype: int
        """
        return self._InternetMaxBandwidth

    @InternetMaxBandwidth.setter
    def InternetMaxBandwidth(self, InternetMaxBandwidth):
        self._InternetMaxBandwidth = InternetMaxBandwidth

    @property
    def Tags(self):
        """需要关联的标签列表。
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def Protocol(self):
        """带宽包协议类型。当前支持'ipv4'和'ipv6'协议带宽包，默认值是'ipv4'。
        :rtype: str
        """
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def TimeSpan(self):
        """预付费包月带宽包的购买时长，单位: 月，取值范围: 1~60。
        :rtype: int
        """
        return self._TimeSpan

    @TimeSpan.setter
    def TimeSpan(self, TimeSpan):
        self._TimeSpan = TimeSpan

    @property
    def Egress(self):
        """网络出口，默认值：center_egress1
        :rtype: str
        """
        return self._Egress

    @Egress.setter
    def Egress(self, Egress):
        self._Egress = Egress


    def _deserialize(self, params):
        self._NetworkType = params.get("NetworkType")
        self._ChargeType = params.get("ChargeType")
        self._BandwidthPackageName = params.get("BandwidthPackageName")
        self._BandwidthPackageCount = params.get("BandwidthPackageCount")
        self._InternetMaxBandwidth = params.get("InternetMaxBandwidth")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._Protocol = params.get("Protocol")
        self._TimeSpan = params.get("TimeSpan")
        self._Egress = params.get("Egress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateBandwidthPackageResponse(AbstractModel):
    """CreateBandwidthPackage返回参数结构体

    """

    def __init__(self):
        r"""
        :param _BandwidthPackageId: 带宽包唯一ID。
        :type BandwidthPackageId: str
        :param _BandwidthPackageIds: 带宽包唯一ID列表(申请数量大于1时有效)。
        :type BandwidthPackageIds: list of str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._BandwidthPackageId = None
        self._BandwidthPackageIds = None
        self._RequestId = None

    @property
    def BandwidthPackageId(self):
        """带宽包唯一ID。
        :rtype: str
        """
        return self._BandwidthPackageId

    @BandwidthPackageId.setter
    def BandwidthPackageId(self, BandwidthPackageId):
        self._BandwidthPackageId = BandwidthPackageId

    @property
    def BandwidthPackageIds(self):
        """带宽包唯一ID列表(申请数量大于1时有效)。
        :rtype: list of str
        """
        return self._BandwidthPackageIds

    @BandwidthPackageIds.setter
    def BandwidthPackageIds(self, BandwidthPackageIds):
        self._BandwidthPackageIds = BandwidthPackageIds

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._BandwidthPackageId = params.get("BandwidthPackageId")
        self._BandwidthPackageIds = params.get("BandwidthPackageIds")
        self._RequestId = params.get("RequestId")


class CreateCcnRequest(AbstractModel):
    """CreateCcn请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CcnName: CCN名称，最大长度不能超过60个字节。
        :type CcnName: str
        :param _CcnDescription: CCN描述信息，最大长度不能超过100个字节。
        :type CcnDescription: str
        :param _QosLevel: CCN服务质量，`PT`：白金，`AU`：金，`AG`：银，默认为`AU`。
        :type QosLevel: str
        :param _InstanceChargeType: 计费模式，`PREPAID`：表示预付费，即包年包月，`POSTPAID`：表示后付费，即按量计费。默认：`POSTPAID`。
        :type InstanceChargeType: str
        :param _BandwidthLimitType: 限速类型，`OUTER_REGION_LIMIT`表示地域出口限速，`INTER_REGION_LIMIT`为地域间限速，默认为`OUTER_REGION_LIMIT`。预付费模式仅支持地域间限速，后付费模式支持地域间限速和地域出口限速。
        :type BandwidthLimitType: str
        :param _Tags: 指定绑定的标签列表，例如：[{"Key": "city", "Value": "shanghai"}]
        :type Tags: list of Tag
        """
        self._CcnName = None
        self._CcnDescription = None
        self._QosLevel = None
        self._InstanceChargeType = None
        self._BandwidthLimitType = None
        self._Tags = None

    @property
    def CcnName(self):
        """CCN名称，最大长度不能超过60个字节。
        :rtype: str
        """
        return self._CcnName

    @CcnName.setter
    def CcnName(self, CcnName):
        self._CcnName = CcnName

    @property
    def CcnDescription(self):
        """CCN描述信息，最大长度不能超过100个字节。
        :rtype: str
        """
        return self._CcnDescription

    @CcnDescription.setter
    def CcnDescription(self, CcnDescription):
        self._CcnDescription = CcnDescription

    @property
    def QosLevel(self):
        """CCN服务质量，`PT`：白金，`AU`：金，`AG`：银，默认为`AU`。
        :rtype: str
        """
        return self._QosLevel

    @QosLevel.setter
    def QosLevel(self, QosLevel):
        self._QosLevel = QosLevel

    @property
    def InstanceChargeType(self):
        """计费模式，`PREPAID`：表示预付费，即包年包月，`POSTPAID`：表示后付费，即按量计费。默认：`POSTPAID`。
        :rtype: str
        """
        return self._InstanceChargeType

    @InstanceChargeType.setter
    def InstanceChargeType(self, InstanceChargeType):
        self._InstanceChargeType = InstanceChargeType

    @property
    def BandwidthLimitType(self):
        """限速类型，`OUTER_REGION_LIMIT`表示地域出口限速，`INTER_REGION_LIMIT`为地域间限速，默认为`OUTER_REGION_LIMIT`。预付费模式仅支持地域间限速，后付费模式支持地域间限速和地域出口限速。
        :rtype: str
        """
        return self._BandwidthLimitType

    @BandwidthLimitType.setter
    def BandwidthLimitType(self, BandwidthLimitType):
        self._BandwidthLimitType = BandwidthLimitType

    @property
    def Tags(self):
        """指定绑定的标签列表，例如：[{"Key": "city", "Value": "shanghai"}]
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._CcnName = params.get("CcnName")
        self._CcnDescription = params.get("CcnDescription")
        self._QosLevel = params.get("QosLevel")
        self._InstanceChargeType = params.get("InstanceChargeType")
        self._BandwidthLimitType = params.get("BandwidthLimitType")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateCcnResponse(AbstractModel):
    """CreateCcn返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Ccn: 云联网（CCN）对象。
        :type Ccn: :class:`tencentcloud.vpc.v20170312.models.CCN`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Ccn = None
        self._RequestId = None

    @property
    def Ccn(self):
        """云联网（CCN）对象。
        :rtype: :class:`tencentcloud.vpc.v20170312.models.CCN`
        """
        return self._Ccn

    @Ccn.setter
    def Ccn(self, Ccn):
        self._Ccn = Ccn

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Ccn") is not None:
            self._Ccn = CCN()
            self._Ccn._deserialize(params.get("Ccn"))
        self._RequestId = params.get("RequestId")


class CreateCcnRouteTablesRequest(AbstractModel):
    """CreateCcnRouteTables请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RouteTable: 需要创建的路由表列表。
        :type RouteTable: list of CcnBatchRouteTable
        """
        self._RouteTable = None

    @property
    def RouteTable(self):
        """需要创建的路由表列表。
        :rtype: list of CcnBatchRouteTable
        """
        return self._RouteTable

    @RouteTable.setter
    def RouteTable(self, RouteTable):
        self._RouteTable = RouteTable


    def _deserialize(self, params):
        if params.get("RouteTable") is not None:
            self._RouteTable = []
            for item in params.get("RouteTable"):
                obj = CcnBatchRouteTable()
                obj._deserialize(item)
                self._RouteTable.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateCcnRouteTablesResponse(AbstractModel):
    """CreateCcnRouteTables返回参数结构体

    """

    def __init__(self):
        r"""
        :param _CcnRouteTableSet: 路由表信息列表。
        :type CcnRouteTableSet: list of CcnRouteTable
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._CcnRouteTableSet = None
        self._RequestId = None

    @property
    def CcnRouteTableSet(self):
        """路由表信息列表。
        :rtype: list of CcnRouteTable
        """
        return self._CcnRouteTableSet

    @CcnRouteTableSet.setter
    def CcnRouteTableSet(self, CcnRouteTableSet):
        self._CcnRouteTableSet = CcnRouteTableSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("CcnRouteTableSet") is not None:
            self._CcnRouteTableSet = []
            for item in params.get("CcnRouteTableSet"):
                obj = CcnRouteTable()
                obj._deserialize(item)
                self._CcnRouteTableSet.append(obj)
        self._RequestId = params.get("RequestId")


class CreateCdcLDCXListRequest(AbstractModel):
    """CreateCdcLDCXList请求参数结构体

    """


class CreateCdcLDCXListResponse(AbstractModel):
    """CreateCdcLDCXList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateCdcNetPlanesRequest(AbstractModel):
    """CreateCdcNetPlanes请求参数结构体

    """


class CreateCdcNetPlanesResponse(AbstractModel):
    """CreateCdcNetPlanes返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateCustomerGatewayRequest(AbstractModel):
    """CreateCustomerGateway请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CustomerGatewayName: 对端网关名称，可任意命名，但不得超过60个字符。
        :type CustomerGatewayName: str
        :param _IpAddress: 对端网关公网IP。
        :type IpAddress: str
        :param _Tags: 指定绑定的标签列表，例如：[{"Key": "city", "Value": "shanghai"}]
        :type Tags: list of Tag
        :param _BgpAsn: BGP ASN。ASN取值范围为1- 4294967295，其中139341、45090和58835不可用。
        :type BgpAsn: int
        """
        self._CustomerGatewayName = None
        self._IpAddress = None
        self._Tags = None
        self._BgpAsn = None

    @property
    def CustomerGatewayName(self):
        """对端网关名称，可任意命名，但不得超过60个字符。
        :rtype: str
        """
        return self._CustomerGatewayName

    @CustomerGatewayName.setter
    def CustomerGatewayName(self, CustomerGatewayName):
        self._CustomerGatewayName = CustomerGatewayName

    @property
    def IpAddress(self):
        """对端网关公网IP。
        :rtype: str
        """
        return self._IpAddress

    @IpAddress.setter
    def IpAddress(self, IpAddress):
        self._IpAddress = IpAddress

    @property
    def Tags(self):
        """指定绑定的标签列表，例如：[{"Key": "city", "Value": "shanghai"}]
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def BgpAsn(self):
        """BGP ASN。ASN取值范围为1- 4294967295，其中139341、45090和58835不可用。
        :rtype: int
        """
        return self._BgpAsn

    @BgpAsn.setter
    def BgpAsn(self, BgpAsn):
        self._BgpAsn = BgpAsn


    def _deserialize(self, params):
        self._CustomerGatewayName = params.get("CustomerGatewayName")
        self._IpAddress = params.get("IpAddress")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._BgpAsn = params.get("BgpAsn")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateCustomerGatewayResponse(AbstractModel):
    """CreateCustomerGateway返回参数结构体

    """

    def __init__(self):
        r"""
        :param _CustomerGateway: 对端网关对象
        :type CustomerGateway: :class:`tencentcloud.vpc.v20170312.models.CustomerGateway`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._CustomerGateway = None
        self._RequestId = None

    @property
    def CustomerGateway(self):
        """对端网关对象
        :rtype: :class:`tencentcloud.vpc.v20170312.models.CustomerGateway`
        """
        return self._CustomerGateway

    @CustomerGateway.setter
    def CustomerGateway(self, CustomerGateway):
        self._CustomerGateway = CustomerGateway

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("CustomerGateway") is not None:
            self._CustomerGateway = CustomerGateway()
            self._CustomerGateway._deserialize(params.get("CustomerGateway"))
        self._RequestId = params.get("RequestId")


class CreateDefaultSecurityGroupRequest(AbstractModel):
    """CreateDefaultSecurityGroup请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 项目ID，默认0。可在<a href="https://console.cloud.tencent.com/project">qcloud控制台项目管理页面</a>查询到。
        :type ProjectId: str
        """
        self._ProjectId = None

    @property
    def ProjectId(self):
        """项目ID，默认0。可在<a href="https://console.cloud.tencent.com/project">qcloud控制台项目管理页面</a>查询到。
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDefaultSecurityGroupResponse(AbstractModel):
    """CreateDefaultSecurityGroup返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SecurityGroup: 安全组对象。
        :type SecurityGroup: :class:`tencentcloud.vpc.v20170312.models.SecurityGroup`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SecurityGroup = None
        self._RequestId = None

    @property
    def SecurityGroup(self):
        """安全组对象。
        :rtype: :class:`tencentcloud.vpc.v20170312.models.SecurityGroup`
        """
        return self._SecurityGroup

    @SecurityGroup.setter
    def SecurityGroup(self, SecurityGroup):
        self._SecurityGroup = SecurityGroup

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SecurityGroup") is not None:
            self._SecurityGroup = SecurityGroup()
            self._SecurityGroup._deserialize(params.get("SecurityGroup"))
        self._RequestId = params.get("RequestId")


class CreateDefaultVpcRequest(AbstractModel):
    """CreateDefaultVpc请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Zone: 子网所在的可用区，该参数可通过[DescribeZones](https://cloud.tencent.com/document/product/213/15707)接口获取，例如ap-guangzhou-1，不指定时将随机选择可用区。
        :type Zone: str
        :param _Force: 是否强制返回默认VPC。
        :type Force: bool
        """
        self._Zone = None
        self._Force = None

    @property
    def Zone(self):
        """子网所在的可用区，该参数可通过[DescribeZones](https://cloud.tencent.com/document/product/213/15707)接口获取，例如ap-guangzhou-1，不指定时将随机选择可用区。
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def Force(self):
        """是否强制返回默认VPC。
        :rtype: bool
        """
        return self._Force

    @Force.setter
    def Force(self, Force):
        self._Force = Force


    def _deserialize(self, params):
        self._Zone = params.get("Zone")
        self._Force = params.get("Force")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDefaultVpcResponse(AbstractModel):
    """CreateDefaultVpc返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Vpc: 默认VPC和子网ID。
        :type Vpc: :class:`tencentcloud.vpc.v20170312.models.DefaultVpcSubnet`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Vpc = None
        self._RequestId = None

    @property
    def Vpc(self):
        """默认VPC和子网ID。
        :rtype: :class:`tencentcloud.vpc.v20170312.models.DefaultVpcSubnet`
        """
        return self._Vpc

    @Vpc.setter
    def Vpc(self, Vpc):
        self._Vpc = Vpc

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Vpc") is not None:
            self._Vpc = DefaultVpcSubnet()
            self._Vpc._deserialize(params.get("Vpc"))
        self._RequestId = params.get("RequestId")


class CreateDhcpIpRequest(AbstractModel):
    """CreateDhcpIp请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VpcId: 私有网络`ID`。
        :type VpcId: str
        :param _SubnetId: 子网`ID`。
        :type SubnetId: str
        :param _DhcpIpName: `DhcpIp`名称。
        :type DhcpIpName: str
        :param _SecondaryPrivateIpAddressCount: 新申请的内网IP地址个数。总数不能超过64个，为了兼容性，当前参数必填。
        :type SecondaryPrivateIpAddressCount: int
        :param _Tags: 指定绑定的标签列表，例如：[{"Key": "city", "Value": "shanghai"}]。
        :type Tags: list of Tag
        """
        self._VpcId = None
        self._SubnetId = None
        self._DhcpIpName = None
        self._SecondaryPrivateIpAddressCount = None
        self._Tags = None

    @property
    def VpcId(self):
        """私有网络`ID`。
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        """子网`ID`。
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def DhcpIpName(self):
        """`DhcpIp`名称。
        :rtype: str
        """
        return self._DhcpIpName

    @DhcpIpName.setter
    def DhcpIpName(self, DhcpIpName):
        self._DhcpIpName = DhcpIpName

    @property
    def SecondaryPrivateIpAddressCount(self):
        """新申请的内网IP地址个数。总数不能超过64个，为了兼容性，当前参数必填。
        :rtype: int
        """
        return self._SecondaryPrivateIpAddressCount

    @SecondaryPrivateIpAddressCount.setter
    def SecondaryPrivateIpAddressCount(self, SecondaryPrivateIpAddressCount):
        self._SecondaryPrivateIpAddressCount = SecondaryPrivateIpAddressCount

    @property
    def Tags(self):
        """指定绑定的标签列表，例如：[{"Key": "city", "Value": "shanghai"}]。
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._DhcpIpName = params.get("DhcpIpName")
        self._SecondaryPrivateIpAddressCount = params.get("SecondaryPrivateIpAddressCount")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDhcpIpResponse(AbstractModel):
    """CreateDhcpIp返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DhcpIpSet: 新创建的`DhcpIp`信息。
        :type DhcpIpSet: list of DhcpIp
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DhcpIpSet = None
        self._RequestId = None

    @property
    def DhcpIpSet(self):
        """新创建的`DhcpIp`信息。
        :rtype: list of DhcpIp
        """
        return self._DhcpIpSet

    @DhcpIpSet.setter
    def DhcpIpSet(self, DhcpIpSet):
        self._DhcpIpSet = DhcpIpSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DhcpIpSet") is not None:
            self._DhcpIpSet = []
            for item in params.get("DhcpIpSet"):
                obj = DhcpIp()
                obj._deserialize(item)
                self._DhcpIpSet.append(obj)
        self._RequestId = params.get("RequestId")


class CreateDirectConnectGatewayCcnRoutesRequest(AbstractModel):
    """CreateDirectConnectGatewayCcnRoutes请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DirectConnectGatewayId: 专线网关ID，形如：dcg-prpqlmg1
        :type DirectConnectGatewayId: str
        :param _Routes: 需要连通的IDC网段列表
        :type Routes: list of DirectConnectGatewayCcnRoute
        """
        self._DirectConnectGatewayId = None
        self._Routes = None

    @property
    def DirectConnectGatewayId(self):
        """专线网关ID，形如：dcg-prpqlmg1
        :rtype: str
        """
        return self._DirectConnectGatewayId

    @DirectConnectGatewayId.setter
    def DirectConnectGatewayId(self, DirectConnectGatewayId):
        self._DirectConnectGatewayId = DirectConnectGatewayId

    @property
    def Routes(self):
        """需要连通的IDC网段列表
        :rtype: list of DirectConnectGatewayCcnRoute
        """
        return self._Routes

    @Routes.setter
    def Routes(self, Routes):
        self._Routes = Routes


    def _deserialize(self, params):
        self._DirectConnectGatewayId = params.get("DirectConnectGatewayId")
        if params.get("Routes") is not None:
            self._Routes = []
            for item in params.get("Routes"):
                obj = DirectConnectGatewayCcnRoute()
                obj._deserialize(item)
                self._Routes.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDirectConnectGatewayCcnRoutesResponse(AbstractModel):
    """CreateDirectConnectGatewayCcnRoutes返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateDirectConnectGatewayRequest(AbstractModel):
    """CreateDirectConnectGateway请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DirectConnectGatewayName: 专线网关名称
        :type DirectConnectGatewayName: str
        :param _NetworkType: 关联网络类型，可选值：
<li>VPC - 私有网络</li>
<li>CCN - 云联网</li>
        :type NetworkType: str
        :param _NetworkInstanceId: <li>NetworkType 为 VPC 时，这里传值为私有网络实例ID</li>
<li>NetworkType 为 CCN 时，这里传值为云联网实例ID</li>
        :type NetworkInstanceId: str
        :param _GatewayType: 网关类型，可选值：
<li>NORMAL - （默认）标准型，注：云联网只支持标准型</li>
<li>NAT - NAT型</li>NAT类型支持网络地址转换配置，类型确定后不能修改；一个私有网络可以创建一个NAT类型的专线网关和一个非NAT类型的专线网关
        :type GatewayType: str
        :param _ModeType: 云联网路由发布模式，可选值：`standard`（标准模式）、`exquisite`（精细模式）。只有云联网类型专线网关才支持`ModeType`。
        :type ModeType: str
        :param _Zone: 专线网关可用区
        :type Zone: str
        :param _HaZoneGroupId: 专线网关高可用区容灾组ID
        :type HaZoneGroupId: str
        """
        self._DirectConnectGatewayName = None
        self._NetworkType = None
        self._NetworkInstanceId = None
        self._GatewayType = None
        self._ModeType = None
        self._Zone = None
        self._HaZoneGroupId = None

    @property
    def DirectConnectGatewayName(self):
        """专线网关名称
        :rtype: str
        """
        return self._DirectConnectGatewayName

    @DirectConnectGatewayName.setter
    def DirectConnectGatewayName(self, DirectConnectGatewayName):
        self._DirectConnectGatewayName = DirectConnectGatewayName

    @property
    def NetworkType(self):
        """关联网络类型，可选值：
<li>VPC - 私有网络</li>
<li>CCN - 云联网</li>
        :rtype: str
        """
        return self._NetworkType

    @NetworkType.setter
    def NetworkType(self, NetworkType):
        self._NetworkType = NetworkType

    @property
    def NetworkInstanceId(self):
        """<li>NetworkType 为 VPC 时，这里传值为私有网络实例ID</li>
<li>NetworkType 为 CCN 时，这里传值为云联网实例ID</li>
        :rtype: str
        """
        return self._NetworkInstanceId

    @NetworkInstanceId.setter
    def NetworkInstanceId(self, NetworkInstanceId):
        self._NetworkInstanceId = NetworkInstanceId

    @property
    def GatewayType(self):
        """网关类型，可选值：
<li>NORMAL - （默认）标准型，注：云联网只支持标准型</li>
<li>NAT - NAT型</li>NAT类型支持网络地址转换配置，类型确定后不能修改；一个私有网络可以创建一个NAT类型的专线网关和一个非NAT类型的专线网关
        :rtype: str
        """
        return self._GatewayType

    @GatewayType.setter
    def GatewayType(self, GatewayType):
        self._GatewayType = GatewayType

    @property
    def ModeType(self):
        """云联网路由发布模式，可选值：`standard`（标准模式）、`exquisite`（精细模式）。只有云联网类型专线网关才支持`ModeType`。
        :rtype: str
        """
        return self._ModeType

    @ModeType.setter
    def ModeType(self, ModeType):
        self._ModeType = ModeType

    @property
    def Zone(self):
        """专线网关可用区
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def HaZoneGroupId(self):
        """专线网关高可用区容灾组ID
        :rtype: str
        """
        return self._HaZoneGroupId

    @HaZoneGroupId.setter
    def HaZoneGroupId(self, HaZoneGroupId):
        self._HaZoneGroupId = HaZoneGroupId


    def _deserialize(self, params):
        self._DirectConnectGatewayName = params.get("DirectConnectGatewayName")
        self._NetworkType = params.get("NetworkType")
        self._NetworkInstanceId = params.get("NetworkInstanceId")
        self._GatewayType = params.get("GatewayType")
        self._ModeType = params.get("ModeType")
        self._Zone = params.get("Zone")
        self._HaZoneGroupId = params.get("HaZoneGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDirectConnectGatewayResponse(AbstractModel):
    """CreateDirectConnectGateway返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DirectConnectGateway: 专线网关对象。
        :type DirectConnectGateway: :class:`tencentcloud.vpc.v20170312.models.DirectConnectGateway`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DirectConnectGateway = None
        self._RequestId = None

    @property
    def DirectConnectGateway(self):
        """专线网关对象。
        :rtype: :class:`tencentcloud.vpc.v20170312.models.DirectConnectGateway`
        """
        return self._DirectConnectGateway

    @DirectConnectGateway.setter
    def DirectConnectGateway(self, DirectConnectGateway):
        self._DirectConnectGateway = DirectConnectGateway

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DirectConnectGateway") is not None:
            self._DirectConnectGateway = DirectConnectGateway()
            self._DirectConnectGateway._deserialize(params.get("DirectConnectGateway"))
        self._RequestId = params.get("RequestId")


class CreateFlowLogRequest(AbstractModel):
    """CreateFlowLog请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FlowLogName: 流日志实例名字。
        :type FlowLogName: str
        :param _ResourceType: 流日志所属资源类型，VPC|SUBNET|NETWORKINTERFACE|CCN|NAT|DCG。
        :type ResourceType: str
        :param _ResourceId: 资源唯一ID。
        :type ResourceId: str
        :param _TrafficType: 流日志采集类型，ACCEPT|REJECT|ALL。
        :type TrafficType: str
        :param _VpcId: 私用网络ID或者统一ID，建议使用统一ID，当ResourceType为CCN时不填，其他类型必填。
        :type VpcId: str
        :param _FlowLogDescription: 流日志实例描述。
        :type FlowLogDescription: str
        :param _CloudLogId: 流日志存储ID。
        :type CloudLogId: str
        :param _Tags: 指定绑定的标签列表，例如：[{"Key": "city", "Value": "shanghai"}]。
        :type Tags: list of Tag
        :param _StorageType: 消费端类型：cls、ckafka。默认值cls。
        :type StorageType: str
        :param _FlowLogStorage: 流日志消费端信息，当消费端类型为ckafka时，必填。
        :type FlowLogStorage: :class:`tencentcloud.vpc.v20170312.models.FlowLogStorage`
        :param _CloudLogRegion: 流日志存储ID对应的地域，不传递默认为本地域。
        :type CloudLogRegion: str
        """
        self._FlowLogName = None
        self._ResourceType = None
        self._ResourceId = None
        self._TrafficType = None
        self._VpcId = None
        self._FlowLogDescription = None
        self._CloudLogId = None
        self._Tags = None
        self._StorageType = None
        self._FlowLogStorage = None
        self._CloudLogRegion = None

    @property
    def FlowLogName(self):
        """流日志实例名字。
        :rtype: str
        """
        return self._FlowLogName

    @FlowLogName.setter
    def FlowLogName(self, FlowLogName):
        self._FlowLogName = FlowLogName

    @property
    def ResourceType(self):
        """流日志所属资源类型，VPC|SUBNET|NETWORKINTERFACE|CCN|NAT|DCG。
        :rtype: str
        """
        return self._ResourceType

    @ResourceType.setter
    def ResourceType(self, ResourceType):
        self._ResourceType = ResourceType

    @property
    def ResourceId(self):
        """资源唯一ID。
        :rtype: str
        """
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId

    @property
    def TrafficType(self):
        """流日志采集类型，ACCEPT|REJECT|ALL。
        :rtype: str
        """
        return self._TrafficType

    @TrafficType.setter
    def TrafficType(self, TrafficType):
        self._TrafficType = TrafficType

    @property
    def VpcId(self):
        """私用网络ID或者统一ID，建议使用统一ID，当ResourceType为CCN时不填，其他类型必填。
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def FlowLogDescription(self):
        """流日志实例描述。
        :rtype: str
        """
        return self._FlowLogDescription

    @FlowLogDescription.setter
    def FlowLogDescription(self, FlowLogDescription):
        self._FlowLogDescription = FlowLogDescription

    @property
    def CloudLogId(self):
        """流日志存储ID。
        :rtype: str
        """
        return self._CloudLogId

    @CloudLogId.setter
    def CloudLogId(self, CloudLogId):
        self._CloudLogId = CloudLogId

    @property
    def Tags(self):
        """指定绑定的标签列表，例如：[{"Key": "city", "Value": "shanghai"}]。
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def StorageType(self):
        """消费端类型：cls、ckafka。默认值cls。
        :rtype: str
        """
        return self._StorageType

    @StorageType.setter
    def StorageType(self, StorageType):
        self._StorageType = StorageType

    @property
    def FlowLogStorage(self):
        """流日志消费端信息，当消费端类型为ckafka时，必填。
        :rtype: :class:`tencentcloud.vpc.v20170312.models.FlowLogStorage`
        """
        return self._FlowLogStorage

    @FlowLogStorage.setter
    def FlowLogStorage(self, FlowLogStorage):
        self._FlowLogStorage = FlowLogStorage

    @property
    def CloudLogRegion(self):
        """流日志存储ID对应的地域，不传递默认为本地域。
        :rtype: str
        """
        return self._CloudLogRegion

    @CloudLogRegion.setter
    def CloudLogRegion(self, CloudLogRegion):
        self._CloudLogRegion = CloudLogRegion


    def _deserialize(self, params):
        self._FlowLogName = params.get("FlowLogName")
        self._ResourceType = params.get("ResourceType")
        self._ResourceId = params.get("ResourceId")
        self._TrafficType = params.get("TrafficType")
        self._VpcId = params.get("VpcId")
        self._FlowLogDescription = params.get("FlowLogDescription")
        self._CloudLogId = params.get("CloudLogId")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._StorageType = params.get("StorageType")
        if params.get("FlowLogStorage") is not None:
            self._FlowLogStorage = FlowLogStorage()
            self._FlowLogStorage._deserialize(params.get("FlowLogStorage"))
        self._CloudLogRegion = params.get("CloudLogRegion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateFlowLogResponse(AbstractModel):
    """CreateFlowLog返回参数结构体

    """

    def __init__(self):
        r"""
        :param _FlowLog: 创建的流日志信息。
        :type FlowLog: list of FlowLog
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._FlowLog = None
        self._RequestId = None

    @property
    def FlowLog(self):
        """创建的流日志信息。
        :rtype: list of FlowLog
        """
        return self._FlowLog

    @FlowLog.setter
    def FlowLog(self, FlowLog):
        self._FlowLog = FlowLog

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("FlowLog") is not None:
            self._FlowLog = []
            for item in params.get("FlowLog"):
                obj = FlowLog()
                obj._deserialize(item)
                self._FlowLog.append(obj)
        self._RequestId = params.get("RequestId")


class CreateHaVipRequest(AbstractModel):
    """CreateHaVip请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VpcId: `HAVIP`所在私有网络`ID`。
        :type VpcId: str
        :param _HaVipName: `HAVIP`名称。
        :type HaVipName: str
        :param _SubnetId: `HAVIP`所在子网`ID`。
        :type SubnetId: str
        :param _Vip: 指定虚拟IP地址，必须在`VPC`网段内且未被占用。不指定则自动分配。
        :type Vip: str
        :param _NetworkInterfaceId: `HAVIP`所在弹性网卡`ID`。
        :type NetworkInterfaceId: str
        :param _CheckAssociate: 是否开启`HAVIP`漂移时子机或网卡范围的校验。默认不开启。
        :type CheckAssociate: bool
        :param _Tags: 指定绑定的标签列表，例如：[{"Key": "city", "Value": "shanghai"}]。
        :type Tags: list of Tag
        """
        self._VpcId = None
        self._HaVipName = None
        self._SubnetId = None
        self._Vip = None
        self._NetworkInterfaceId = None
        self._CheckAssociate = None
        self._Tags = None

    @property
    def VpcId(self):
        """`HAVIP`所在私有网络`ID`。
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def HaVipName(self):
        """`HAVIP`名称。
        :rtype: str
        """
        return self._HaVipName

    @HaVipName.setter
    def HaVipName(self, HaVipName):
        self._HaVipName = HaVipName

    @property
    def SubnetId(self):
        """`HAVIP`所在子网`ID`。
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def Vip(self):
        """指定虚拟IP地址，必须在`VPC`网段内且未被占用。不指定则自动分配。
        :rtype: str
        """
        return self._Vip

    @Vip.setter
    def Vip(self, Vip):
        self._Vip = Vip

    @property
    def NetworkInterfaceId(self):
        """`HAVIP`所在弹性网卡`ID`。
        :rtype: str
        """
        return self._NetworkInterfaceId

    @NetworkInterfaceId.setter
    def NetworkInterfaceId(self, NetworkInterfaceId):
        self._NetworkInterfaceId = NetworkInterfaceId

    @property
    def CheckAssociate(self):
        """是否开启`HAVIP`漂移时子机或网卡范围的校验。默认不开启。
        :rtype: bool
        """
        return self._CheckAssociate

    @CheckAssociate.setter
    def CheckAssociate(self, CheckAssociate):
        self._CheckAssociate = CheckAssociate

    @property
    def Tags(self):
        """指定绑定的标签列表，例如：[{"Key": "city", "Value": "shanghai"}]。
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._HaVipName = params.get("HaVipName")
        self._SubnetId = params.get("SubnetId")
        self._Vip = params.get("Vip")
        self._NetworkInterfaceId = params.get("NetworkInterfaceId")
        self._CheckAssociate = params.get("CheckAssociate")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateHaVipResponse(AbstractModel):
    """CreateHaVip返回参数结构体

    """

    def __init__(self):
        r"""
        :param _HaVip: `HAVIP`对象。
        :type HaVip: :class:`tencentcloud.vpc.v20170312.models.HaVip`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._HaVip = None
        self._RequestId = None

    @property
    def HaVip(self):
        """`HAVIP`对象。
        :rtype: :class:`tencentcloud.vpc.v20170312.models.HaVip`
        """
        return self._HaVip

    @HaVip.setter
    def HaVip(self, HaVip):
        self._HaVip = HaVip

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("HaVip") is not None:
            self._HaVip = HaVip()
            self._HaVip._deserialize(params.get("HaVip"))
        self._RequestId = params.get("RequestId")


class CreateHighPriorityRouteTableRequest(AbstractModel):
    """CreateHighPriorityRouteTable请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VpcId: 待操作的VPC实例ID。可通过DescribeVpcs接口返回值中的VpcId获取。
        :type VpcId: str
        :param _Name: 高优路由表名称，最大长度不能超过60个字节。
        :type Name: str
        :param _Tags: 指定绑定的标签列表，例如：[{"Key": "city", "Value": "shanghai"}]
        :type Tags: list of Tag
        """
        self._VpcId = None
        self._Name = None
        self._Tags = None

    @property
    def VpcId(self):
        """待操作的VPC实例ID。可通过DescribeVpcs接口返回值中的VpcId获取。
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def Name(self):
        """高优路由表名称，最大长度不能超过60个字节。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Tags(self):
        """指定绑定的标签列表，例如：[{"Key": "city", "Value": "shanghai"}]
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._Name = params.get("Name")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateHighPriorityRouteTableResponse(AbstractModel):
    """CreateHighPriorityRouteTable返回参数结构体

    """

    def __init__(self):
        r"""
        :param _HighPriorityRouteTable: 高优路由表信息
        :type HighPriorityRouteTable: :class:`tencentcloud.vpc.v20170312.models.HighPriorityRouteTable`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._HighPriorityRouteTable = None
        self._RequestId = None

    @property
    def HighPriorityRouteTable(self):
        """高优路由表信息
        :rtype: :class:`tencentcloud.vpc.v20170312.models.HighPriorityRouteTable`
        """
        return self._HighPriorityRouteTable

    @HighPriorityRouteTable.setter
    def HighPriorityRouteTable(self, HighPriorityRouteTable):
        self._HighPriorityRouteTable = HighPriorityRouteTable

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("HighPriorityRouteTable") is not None:
            self._HighPriorityRouteTable = HighPriorityRouteTable()
            self._HighPriorityRouteTable._deserialize(params.get("HighPriorityRouteTable"))
        self._RequestId = params.get("RequestId")


class CreateHighPriorityRoutesRequest(AbstractModel):
    """CreateHighPriorityRoutes请求参数结构体

    """

    def __init__(self):
        r"""
        :param _HighPriorityRouteTableId: 高优路由表唯一 ID。
        :type HighPriorityRouteTableId: str
        :param _HighPriorityRoutes: 高优路由表条目信息。
        :type HighPriorityRoutes: list of HighPriorityRoute
        """
        self._HighPriorityRouteTableId = None
        self._HighPriorityRoutes = None

    @property
    def HighPriorityRouteTableId(self):
        """高优路由表唯一 ID。
        :rtype: str
        """
        return self._HighPriorityRouteTableId

    @HighPriorityRouteTableId.setter
    def HighPriorityRouteTableId(self, HighPriorityRouteTableId):
        self._HighPriorityRouteTableId = HighPriorityRouteTableId

    @property
    def HighPriorityRoutes(self):
        """高优路由表条目信息。
        :rtype: list of HighPriorityRoute
        """
        return self._HighPriorityRoutes

    @HighPriorityRoutes.setter
    def HighPriorityRoutes(self, HighPriorityRoutes):
        self._HighPriorityRoutes = HighPriorityRoutes


    def _deserialize(self, params):
        self._HighPriorityRouteTableId = params.get("HighPriorityRouteTableId")
        if params.get("HighPriorityRoutes") is not None:
            self._HighPriorityRoutes = []
            for item in params.get("HighPriorityRoutes"):
                obj = HighPriorityRoute()
                obj._deserialize(item)
                self._HighPriorityRoutes.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateHighPriorityRoutesResponse(AbstractModel):
    """CreateHighPriorityRoutes返回参数结构体

    """

    def __init__(self):
        r"""
        :param _HighPriorityRouteSet: 高优路由表信息。
        :type HighPriorityRouteSet: list of HighPriorityRoute
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._HighPriorityRouteSet = None
        self._RequestId = None

    @property
    def HighPriorityRouteSet(self):
        """高优路由表信息。
        :rtype: list of HighPriorityRoute
        """
        return self._HighPriorityRouteSet

    @HighPriorityRouteSet.setter
    def HighPriorityRouteSet(self, HighPriorityRouteSet):
        self._HighPriorityRouteSet = HighPriorityRouteSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("HighPriorityRouteSet") is not None:
            self._HighPriorityRouteSet = []
            for item in params.get("HighPriorityRouteSet"):
                obj = HighPriorityRoute()
                obj._deserialize(item)
                self._HighPriorityRouteSet.append(obj)
        self._RequestId = params.get("RequestId")


class CreateIp6TranslatorsRequest(AbstractModel):
    """CreateIp6Translators请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Ip6TranslatorName: 转换实例名称
        :type Ip6TranslatorName: str
        :param _Ip6TranslatorCount: 创建转换实例数量，默认是1个
        :type Ip6TranslatorCount: int
        :param _Ip6InternetServiceProvider: 转换实例运营商属性，可取"CMCC","CTCC","CUCC","BGP"
        :type Ip6InternetServiceProvider: str
        """
        self._Ip6TranslatorName = None
        self._Ip6TranslatorCount = None
        self._Ip6InternetServiceProvider = None

    @property
    def Ip6TranslatorName(self):
        """转换实例名称
        :rtype: str
        """
        return self._Ip6TranslatorName

    @Ip6TranslatorName.setter
    def Ip6TranslatorName(self, Ip6TranslatorName):
        self._Ip6TranslatorName = Ip6TranslatorName

    @property
    def Ip6TranslatorCount(self):
        """创建转换实例数量，默认是1个
        :rtype: int
        """
        return self._Ip6TranslatorCount

    @Ip6TranslatorCount.setter
    def Ip6TranslatorCount(self, Ip6TranslatorCount):
        self._Ip6TranslatorCount = Ip6TranslatorCount

    @property
    def Ip6InternetServiceProvider(self):
        """转换实例运营商属性，可取"CMCC","CTCC","CUCC","BGP"
        :rtype: str
        """
        return self._Ip6InternetServiceProvider

    @Ip6InternetServiceProvider.setter
    def Ip6InternetServiceProvider(self, Ip6InternetServiceProvider):
        self._Ip6InternetServiceProvider = Ip6InternetServiceProvider


    def _deserialize(self, params):
        self._Ip6TranslatorName = params.get("Ip6TranslatorName")
        self._Ip6TranslatorCount = params.get("Ip6TranslatorCount")
        self._Ip6InternetServiceProvider = params.get("Ip6InternetServiceProvider")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateIp6TranslatorsResponse(AbstractModel):
    """CreateIp6Translators返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Ip6TranslatorSet: 转换实例的唯一ID数组，形如"ip6-xxxxxxxx"
        :type Ip6TranslatorSet: list of str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Ip6TranslatorSet = None
        self._RequestId = None

    @property
    def Ip6TranslatorSet(self):
        """转换实例的唯一ID数组，形如"ip6-xxxxxxxx"
        :rtype: list of str
        """
        return self._Ip6TranslatorSet

    @Ip6TranslatorSet.setter
    def Ip6TranslatorSet(self, Ip6TranslatorSet):
        self._Ip6TranslatorSet = Ip6TranslatorSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Ip6TranslatorSet = params.get("Ip6TranslatorSet")
        self._RequestId = params.get("RequestId")


class CreateLocalGatewayRequest(AbstractModel):
    """CreateLocalGateway请求参数结构体

    """

    def __init__(self):
        r"""
        :param _LocalGatewayName: 本地网关名称。
        :type LocalGatewayName: str
        :param _VpcId: VPC实例ID。
        :type VpcId: str
        :param _CdcId: CDC实例ID。
        :type CdcId: str
        :param _Tags: 指定绑定的标签列表，例如：[{"Key": "city", "Value": "shanghai"}]。
        :type Tags: list of Tag
        """
        self._LocalGatewayName = None
        self._VpcId = None
        self._CdcId = None
        self._Tags = None

    @property
    def LocalGatewayName(self):
        """本地网关名称。
        :rtype: str
        """
        return self._LocalGatewayName

    @LocalGatewayName.setter
    def LocalGatewayName(self, LocalGatewayName):
        self._LocalGatewayName = LocalGatewayName

    @property
    def VpcId(self):
        """VPC实例ID。
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def CdcId(self):
        """CDC实例ID。
        :rtype: str
        """
        return self._CdcId

    @CdcId.setter
    def CdcId(self, CdcId):
        self._CdcId = CdcId

    @property
    def Tags(self):
        """指定绑定的标签列表，例如：[{"Key": "city", "Value": "shanghai"}]。
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._LocalGatewayName = params.get("LocalGatewayName")
        self._VpcId = params.get("VpcId")
        self._CdcId = params.get("CdcId")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateLocalGatewayResponse(AbstractModel):
    """CreateLocalGateway返回参数结构体

    """

    def __init__(self):
        r"""
        :param _LocalGateway: 本地网关信息。
        :type LocalGateway: :class:`tencentcloud.vpc.v20170312.models.LocalGateway`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._LocalGateway = None
        self._RequestId = None

    @property
    def LocalGateway(self):
        """本地网关信息。
        :rtype: :class:`tencentcloud.vpc.v20170312.models.LocalGateway`
        """
        return self._LocalGateway

    @LocalGateway.setter
    def LocalGateway(self, LocalGateway):
        self._LocalGateway = LocalGateway

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("LocalGateway") is not None:
            self._LocalGateway = LocalGateway()
            self._LocalGateway._deserialize(params.get("LocalGateway"))
        self._RequestId = params.get("RequestId")


class CreateNatGatewayDestinationIpPortTranslationNatRuleRequest(AbstractModel):
    """CreateNatGatewayDestinationIpPortTranslationNatRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NatGatewayId: NAT网关的ID，形如：`nat-df45454`。
        :type NatGatewayId: str
        :param _DestinationIpPortTranslationNatRules: NAT网关的端口转换规则。
        :type DestinationIpPortTranslationNatRules: list of DestinationIpPortTranslationNatRule
        """
        self._NatGatewayId = None
        self._DestinationIpPortTranslationNatRules = None

    @property
    def NatGatewayId(self):
        """NAT网关的ID，形如：`nat-df45454`。
        :rtype: str
        """
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId

    @property
    def DestinationIpPortTranslationNatRules(self):
        """NAT网关的端口转换规则。
        :rtype: list of DestinationIpPortTranslationNatRule
        """
        return self._DestinationIpPortTranslationNatRules

    @DestinationIpPortTranslationNatRules.setter
    def DestinationIpPortTranslationNatRules(self, DestinationIpPortTranslationNatRules):
        self._DestinationIpPortTranslationNatRules = DestinationIpPortTranslationNatRules


    def _deserialize(self, params):
        self._NatGatewayId = params.get("NatGatewayId")
        if params.get("DestinationIpPortTranslationNatRules") is not None:
            self._DestinationIpPortTranslationNatRules = []
            for item in params.get("DestinationIpPortTranslationNatRules"):
                obj = DestinationIpPortTranslationNatRule()
                obj._deserialize(item)
                self._DestinationIpPortTranslationNatRules.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateNatGatewayDestinationIpPortTranslationNatRuleResponse(AbstractModel):
    """CreateNatGatewayDestinationIpPortTranslationNatRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateNatGatewayRequest(AbstractModel):
    """CreateNatGateway请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NatGatewayName: NAT网关名称
        :type NatGatewayName: str
        :param _VpcId: VPC实例ID。可通过DescribeVpcs接口返回值中的VpcId获取。
        :type VpcId: str
        :param _InternetMaxBandwidthOut: NAT网关最大外网出带宽(单位：Mbps)，支持的参数值：20, 50, 100, 200, 500, 1000, 2000, 5000，默认: 100Mbps。  当以下NatProductVersion参数值为2即标准型时，此参数无需填写，默认为5000Mbps。
        :type InternetMaxBandwidthOut: int
        :param _MaxConcurrentConnection: NAT网关并发连接数上限，支持参数值：1000000、3000000、10000000，默认值为100000。  当以下NatProductVersion参数值为2即标准型时，此参数无需填写，默认为2000000。
        :type MaxConcurrentConnection: int
        :param _AddressCount: 新建弹性公网IP个数，系统会按您的要求创建对应数量的弹性公网IP，其中AddressCount和PublicAddresses两个参数至少填写一个。
        :type AddressCount: int
        :param _PublicIpAddresses: 绑定NAT网关的已有弹性公网IP数组，其中AddressCount和PublicAddresses两个参数至少填写一个。 示例值：["139.199.232.119"]
        :type PublicIpAddresses: list of str
        :param _Zone: 可用区，形如：`ap-guangzhou-1`。
        :type Zone: str
        :param _Tags: 指定绑定的标签列表，例如：[{"Key": "city", "Value": "shanghai"}]
        :type Tags: list of Tag
        :param _SubnetId: NAT网关所属子网，已废弃
        :type SubnetId: str
        :param _StockPublicIpAddressesBandwidthOut: 绑定NAT网关的弹性公网IP带宽值（单位：Mbps）。不填写此参数时：则该参数默认为弹性公网IP的带宽值，部分用户默认为该用户类型的弹性公网IP的带宽上限。
        :type StockPublicIpAddressesBandwidthOut: int
        :param _PublicIpAddressesBandwidthOut: 需要申请公网IP带宽大小（单位Mbps），默认为当前用户类型所能使用的最大值。
        :type PublicIpAddressesBandwidthOut: int
        :param _PublicIpFromSameZone: 公网IP是否强制与NAT网关来自同可用区，true表示需要与NAT网关同可用区；false表示可与NAT网关不是同一个可用区。此参数只有当参数Zone存在时才能生效。
        :type PublicIpFromSameZone: bool
        :param _NatProductVersion: NAT网关类型，1表示传统型NAT网关，2表示标准型NAT网关，默认值是1。
        :type NatProductVersion: int
        """
        self._NatGatewayName = None
        self._VpcId = None
        self._InternetMaxBandwidthOut = None
        self._MaxConcurrentConnection = None
        self._AddressCount = None
        self._PublicIpAddresses = None
        self._Zone = None
        self._Tags = None
        self._SubnetId = None
        self._StockPublicIpAddressesBandwidthOut = None
        self._PublicIpAddressesBandwidthOut = None
        self._PublicIpFromSameZone = None
        self._NatProductVersion = None

    @property
    def NatGatewayName(self):
        """NAT网关名称
        :rtype: str
        """
        return self._NatGatewayName

    @NatGatewayName.setter
    def NatGatewayName(self, NatGatewayName):
        self._NatGatewayName = NatGatewayName

    @property
    def VpcId(self):
        """VPC实例ID。可通过DescribeVpcs接口返回值中的VpcId获取。
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def InternetMaxBandwidthOut(self):
        """NAT网关最大外网出带宽(单位：Mbps)，支持的参数值：20, 50, 100, 200, 500, 1000, 2000, 5000，默认: 100Mbps。  当以下NatProductVersion参数值为2即标准型时，此参数无需填写，默认为5000Mbps。
        :rtype: int
        """
        return self._InternetMaxBandwidthOut

    @InternetMaxBandwidthOut.setter
    def InternetMaxBandwidthOut(self, InternetMaxBandwidthOut):
        self._InternetMaxBandwidthOut = InternetMaxBandwidthOut

    @property
    def MaxConcurrentConnection(self):
        """NAT网关并发连接数上限，支持参数值：1000000、3000000、10000000，默认值为100000。  当以下NatProductVersion参数值为2即标准型时，此参数无需填写，默认为2000000。
        :rtype: int
        """
        return self._MaxConcurrentConnection

    @MaxConcurrentConnection.setter
    def MaxConcurrentConnection(self, MaxConcurrentConnection):
        self._MaxConcurrentConnection = MaxConcurrentConnection

    @property
    def AddressCount(self):
        """新建弹性公网IP个数，系统会按您的要求创建对应数量的弹性公网IP，其中AddressCount和PublicAddresses两个参数至少填写一个。
        :rtype: int
        """
        return self._AddressCount

    @AddressCount.setter
    def AddressCount(self, AddressCount):
        self._AddressCount = AddressCount

    @property
    def PublicIpAddresses(self):
        """绑定NAT网关的已有弹性公网IP数组，其中AddressCount和PublicAddresses两个参数至少填写一个。 示例值：["139.199.232.119"]
        :rtype: list of str
        """
        return self._PublicIpAddresses

    @PublicIpAddresses.setter
    def PublicIpAddresses(self, PublicIpAddresses):
        self._PublicIpAddresses = PublicIpAddresses

    @property
    def Zone(self):
        """可用区，形如：`ap-guangzhou-1`。
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def Tags(self):
        """指定绑定的标签列表，例如：[{"Key": "city", "Value": "shanghai"}]
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def SubnetId(self):
        warnings.warn("parameter `SubnetId` is deprecated", DeprecationWarning) 

        """NAT网关所属子网，已废弃
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        warnings.warn("parameter `SubnetId` is deprecated", DeprecationWarning) 

        self._SubnetId = SubnetId

    @property
    def StockPublicIpAddressesBandwidthOut(self):
        """绑定NAT网关的弹性公网IP带宽值（单位：Mbps）。不填写此参数时：则该参数默认为弹性公网IP的带宽值，部分用户默认为该用户类型的弹性公网IP的带宽上限。
        :rtype: int
        """
        return self._StockPublicIpAddressesBandwidthOut

    @StockPublicIpAddressesBandwidthOut.setter
    def StockPublicIpAddressesBandwidthOut(self, StockPublicIpAddressesBandwidthOut):
        self._StockPublicIpAddressesBandwidthOut = StockPublicIpAddressesBandwidthOut

    @property
    def PublicIpAddressesBandwidthOut(self):
        """需要申请公网IP带宽大小（单位Mbps），默认为当前用户类型所能使用的最大值。
        :rtype: int
        """
        return self._PublicIpAddressesBandwidthOut

    @PublicIpAddressesBandwidthOut.setter
    def PublicIpAddressesBandwidthOut(self, PublicIpAddressesBandwidthOut):
        self._PublicIpAddressesBandwidthOut = PublicIpAddressesBandwidthOut

    @property
    def PublicIpFromSameZone(self):
        """公网IP是否强制与NAT网关来自同可用区，true表示需要与NAT网关同可用区；false表示可与NAT网关不是同一个可用区。此参数只有当参数Zone存在时才能生效。
        :rtype: bool
        """
        return self._PublicIpFromSameZone

    @PublicIpFromSameZone.setter
    def PublicIpFromSameZone(self, PublicIpFromSameZone):
        self._PublicIpFromSameZone = PublicIpFromSameZone

    @property
    def NatProductVersion(self):
        """NAT网关类型，1表示传统型NAT网关，2表示标准型NAT网关，默认值是1。
        :rtype: int
        """
        return self._NatProductVersion

    @NatProductVersion.setter
    def NatProductVersion(self, NatProductVersion):
        self._NatProductVersion = NatProductVersion


    def _deserialize(self, params):
        self._NatGatewayName = params.get("NatGatewayName")
        self._VpcId = params.get("VpcId")
        self._InternetMaxBandwidthOut = params.get("InternetMaxBandwidthOut")
        self._MaxConcurrentConnection = params.get("MaxConcurrentConnection")
        self._AddressCount = params.get("AddressCount")
        self._PublicIpAddresses = params.get("PublicIpAddresses")
        self._Zone = params.get("Zone")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._SubnetId = params.get("SubnetId")
        self._StockPublicIpAddressesBandwidthOut = params.get("StockPublicIpAddressesBandwidthOut")
        self._PublicIpAddressesBandwidthOut = params.get("PublicIpAddressesBandwidthOut")
        self._PublicIpFromSameZone = params.get("PublicIpFromSameZone")
        self._NatProductVersion = params.get("NatProductVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateNatGatewayResponse(AbstractModel):
    """CreateNatGateway返回参数结构体

    """

    def __init__(self):
        r"""
        :param _NatGatewaySet: NAT网关对象数组。
        :type NatGatewaySet: list of NatGateway
        :param _TotalCount: 符合条件的 NAT网关对象数量。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._NatGatewaySet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def NatGatewaySet(self):
        """NAT网关对象数组。
        :rtype: list of NatGateway
        """
        return self._NatGatewaySet

    @NatGatewaySet.setter
    def NatGatewaySet(self, NatGatewaySet):
        self._NatGatewaySet = NatGatewaySet

    @property
    def TotalCount(self):
        """符合条件的 NAT网关对象数量。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NatGatewaySet") is not None:
            self._NatGatewaySet = []
            for item in params.get("NatGatewaySet"):
                obj = NatGateway()
                obj._deserialize(item)
                self._NatGatewaySet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class CreateNatGatewaySourceIpTranslationNatRuleRequest(AbstractModel):
    """CreateNatGatewaySourceIpTranslationNatRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NatGatewayId: NAT网关的ID，形如："nat-df45454"
        :type NatGatewayId: str
        :param _SourceIpTranslationNatRules: NAT网关的SNAT转换规则
        :type SourceIpTranslationNatRules: list of SourceIpTranslationNatRule
        """
        self._NatGatewayId = None
        self._SourceIpTranslationNatRules = None

    @property
    def NatGatewayId(self):
        """NAT网关的ID，形如："nat-df45454"
        :rtype: str
        """
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId

    @property
    def SourceIpTranslationNatRules(self):
        """NAT网关的SNAT转换规则
        :rtype: list of SourceIpTranslationNatRule
        """
        return self._SourceIpTranslationNatRules

    @SourceIpTranslationNatRules.setter
    def SourceIpTranslationNatRules(self, SourceIpTranslationNatRules):
        self._SourceIpTranslationNatRules = SourceIpTranslationNatRules


    def _deserialize(self, params):
        self._NatGatewayId = params.get("NatGatewayId")
        if params.get("SourceIpTranslationNatRules") is not None:
            self._SourceIpTranslationNatRules = []
            for item in params.get("SourceIpTranslationNatRules"):
                obj = SourceIpTranslationNatRule()
                obj._deserialize(item)
                self._SourceIpTranslationNatRules.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateNatGatewaySourceIpTranslationNatRuleResponse(AbstractModel):
    """CreateNatGatewaySourceIpTranslationNatRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateNetDetectRequest(AbstractModel):
    """CreateNetDetect请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VpcId: `VPC`实例`ID`。形如：`vpc-12345678`。
        :type VpcId: str
        :param _SubnetId: 子网实例ID。形如：subnet-12345678。
        :type SubnetId: str
        :param _NetDetectName: 网络探测名称，最大长度不能超过60个字节。
        :type NetDetectName: str
        :param _DetectDestinationIp: 探测目的IPv4地址数组。最多两个。
        :type DetectDestinationIp: list of str
        :param _NextHopType: 下一跳类型，目前我们支持的类型有：
VPN：VPN网关；
DIRECTCONNECT：专线网关；
PEERCONNECTION：对等连接；
NAT：NAT网关；
NORMAL_CVM：普通云服务器；
CCN：云联网网关；
NONEXTHOP：无下一跳；
        :type NextHopType: str
        :param _NextHopDestination: 下一跳目的网关，取值与“下一跳类型”相关：
下一跳类型为VPN，取值VPN网关ID，形如：vpngw-12345678；
下一跳类型为DIRECTCONNECT，取值专线网关ID，形如：dcg-12345678；
下一跳类型为PEERCONNECTION，取值对等连接ID，形如：pcx-12345678；
下一跳类型为NAT，取值Nat网关，形如：nat-12345678；
下一跳类型为NORMAL_CVM，取值云服务器IPv4地址，形如：10.0.0.12；
下一跳类型为CCN，取值云联网ID，形如：ccn-12345678；
下一跳类型为NONEXTHOP，指定网络探测为无下一跳的网络探测；
        :type NextHopDestination: str
        :param _NetDetectDescription: 网络探测描述。
        :type NetDetectDescription: str
        :param _Tags: 指定绑定的标签列表，例如：[{"Key": "city", "Value": "shanghai"}]。
        :type Tags: list of Tag
        """
        self._VpcId = None
        self._SubnetId = None
        self._NetDetectName = None
        self._DetectDestinationIp = None
        self._NextHopType = None
        self._NextHopDestination = None
        self._NetDetectDescription = None
        self._Tags = None

    @property
    def VpcId(self):
        """`VPC`实例`ID`。形如：`vpc-12345678`。
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        """子网实例ID。形如：subnet-12345678。
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def NetDetectName(self):
        """网络探测名称，最大长度不能超过60个字节。
        :rtype: str
        """
        return self._NetDetectName

    @NetDetectName.setter
    def NetDetectName(self, NetDetectName):
        self._NetDetectName = NetDetectName

    @property
    def DetectDestinationIp(self):
        """探测目的IPv4地址数组。最多两个。
        :rtype: list of str
        """
        return self._DetectDestinationIp

    @DetectDestinationIp.setter
    def DetectDestinationIp(self, DetectDestinationIp):
        self._DetectDestinationIp = DetectDestinationIp

    @property
    def NextHopType(self):
        """下一跳类型，目前我们支持的类型有：
VPN：VPN网关；
DIRECTCONNECT：专线网关；
PEERCONNECTION：对等连接；
NAT：NAT网关；
NORMAL_CVM：普通云服务器；
CCN：云联网网关；
NONEXTHOP：无下一跳；
        :rtype: str
        """
        return self._NextHopType

    @NextHopType.setter
    def NextHopType(self, NextHopType):
        self._NextHopType = NextHopType

    @property
    def NextHopDestination(self):
        """下一跳目的网关，取值与“下一跳类型”相关：
下一跳类型为VPN，取值VPN网关ID，形如：vpngw-12345678；
下一跳类型为DIRECTCONNECT，取值专线网关ID，形如：dcg-12345678；
下一跳类型为PEERCONNECTION，取值对等连接ID，形如：pcx-12345678；
下一跳类型为NAT，取值Nat网关，形如：nat-12345678；
下一跳类型为NORMAL_CVM，取值云服务器IPv4地址，形如：10.0.0.12；
下一跳类型为CCN，取值云联网ID，形如：ccn-12345678；
下一跳类型为NONEXTHOP，指定网络探测为无下一跳的网络探测；
        :rtype: str
        """
        return self._NextHopDestination

    @NextHopDestination.setter
    def NextHopDestination(self, NextHopDestination):
        self._NextHopDestination = NextHopDestination

    @property
    def NetDetectDescription(self):
        """网络探测描述。
        :rtype: str
        """
        return self._NetDetectDescription

    @NetDetectDescription.setter
    def NetDetectDescription(self, NetDetectDescription):
        self._NetDetectDescription = NetDetectDescription

    @property
    def Tags(self):
        """指定绑定的标签列表，例如：[{"Key": "city", "Value": "shanghai"}]。
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._NetDetectName = params.get("NetDetectName")
        self._DetectDestinationIp = params.get("DetectDestinationIp")
        self._NextHopType = params.get("NextHopType")
        self._NextHopDestination = params.get("NextHopDestination")
        self._NetDetectDescription = params.get("NetDetectDescription")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateNetDetectResponse(AbstractModel):
    """CreateNetDetect返回参数结构体

    """

    def __init__(self):
        r"""
        :param _NetDetect: 网络探测（NetDetect）对象。
        :type NetDetect: :class:`tencentcloud.vpc.v20170312.models.NetDetect`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._NetDetect = None
        self._RequestId = None

    @property
    def NetDetect(self):
        """网络探测（NetDetect）对象。
        :rtype: :class:`tencentcloud.vpc.v20170312.models.NetDetect`
        """
        return self._NetDetect

    @NetDetect.setter
    def NetDetect(self, NetDetect):
        self._NetDetect = NetDetect

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NetDetect") is not None:
            self._NetDetect = NetDetect()
            self._NetDetect._deserialize(params.get("NetDetect"))
        self._RequestId = params.get("RequestId")


class CreateNetworkAclEntriesRequest(AbstractModel):
    """CreateNetworkAclEntries请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NetworkAclId: 网络ACL实例ID。例如：acl-12345678。
        :type NetworkAclId: str
        :param _NetworkAclEntrySet: 网络三元组ACL规则集。
        :type NetworkAclEntrySet: :class:`tencentcloud.vpc.v20170312.models.NetworkAclEntrySet`
        """
        self._NetworkAclId = None
        self._NetworkAclEntrySet = None

    @property
    def NetworkAclId(self):
        """网络ACL实例ID。例如：acl-12345678。
        :rtype: str
        """
        return self._NetworkAclId

    @NetworkAclId.setter
    def NetworkAclId(self, NetworkAclId):
        self._NetworkAclId = NetworkAclId

    @property
    def NetworkAclEntrySet(self):
        """网络三元组ACL规则集。
        :rtype: :class:`tencentcloud.vpc.v20170312.models.NetworkAclEntrySet`
        """
        return self._NetworkAclEntrySet

    @NetworkAclEntrySet.setter
    def NetworkAclEntrySet(self, NetworkAclEntrySet):
        self._NetworkAclEntrySet = NetworkAclEntrySet


    def _deserialize(self, params):
        self._NetworkAclId = params.get("NetworkAclId")
        if params.get("NetworkAclEntrySet") is not None:
            self._NetworkAclEntrySet = NetworkAclEntrySet()
            self._NetworkAclEntrySet._deserialize(params.get("NetworkAclEntrySet"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateNetworkAclEntriesResponse(AbstractModel):
    """CreateNetworkAclEntries返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateNetworkAclQuintupleEntriesRequest(AbstractModel):
    """CreateNetworkAclQuintupleEntries请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NetworkAclId: 网络ACL实例ID。例如：acl-12345678。
        :type NetworkAclId: str
        :param _NetworkAclQuintupleSet: 网络五元组ACL规则集。
        :type NetworkAclQuintupleSet: :class:`tencentcloud.vpc.v20170312.models.NetworkAclQuintupleEntries`
        """
        self._NetworkAclId = None
        self._NetworkAclQuintupleSet = None

    @property
    def NetworkAclId(self):
        """网络ACL实例ID。例如：acl-12345678。
        :rtype: str
        """
        return self._NetworkAclId

    @NetworkAclId.setter
    def NetworkAclId(self, NetworkAclId):
        self._NetworkAclId = NetworkAclId

    @property
    def NetworkAclQuintupleSet(self):
        """网络五元组ACL规则集。
        :rtype: :class:`tencentcloud.vpc.v20170312.models.NetworkAclQuintupleEntries`
        """
        return self._NetworkAclQuintupleSet

    @NetworkAclQuintupleSet.setter
    def NetworkAclQuintupleSet(self, NetworkAclQuintupleSet):
        self._NetworkAclQuintupleSet = NetworkAclQuintupleSet


    def _deserialize(self, params):
        self._NetworkAclId = params.get("NetworkAclId")
        if params.get("NetworkAclQuintupleSet") is not None:
            self._NetworkAclQuintupleSet = NetworkAclQuintupleEntries()
            self._NetworkAclQuintupleSet._deserialize(params.get("NetworkAclQuintupleSet"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateNetworkAclQuintupleEntriesResponse(AbstractModel):
    """CreateNetworkAclQuintupleEntries返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateNetworkAclRequest(AbstractModel):
    """CreateNetworkAcl请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VpcId: VPC实例ID。可通过<a href="https://cloud.tencent.com/document/product/215/15778">DescribeVpcs</a>接口返回值中的VpcId获取。
        :type VpcId: str
        :param _NetworkAclName: 网络ACL名称，最大长度不能超过60个字节。
        :type NetworkAclName: str
        :param _NetworkAclType: 网络ACL类型，三元组(TRIPLE)或五元组(QUINTUPLE)。默认值三元组(TRIPLE)。
        :type NetworkAclType: str
        :param _Tags: 指定绑定的标签列表，例如：[{"Key": "city", "Value": "shanghai"}]。
        :type Tags: list of Tag
        """
        self._VpcId = None
        self._NetworkAclName = None
        self._NetworkAclType = None
        self._Tags = None

    @property
    def VpcId(self):
        """VPC实例ID。可通过<a href="https://cloud.tencent.com/document/product/215/15778">DescribeVpcs</a>接口返回值中的VpcId获取。
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def NetworkAclName(self):
        """网络ACL名称，最大长度不能超过60个字节。
        :rtype: str
        """
        return self._NetworkAclName

    @NetworkAclName.setter
    def NetworkAclName(self, NetworkAclName):
        self._NetworkAclName = NetworkAclName

    @property
    def NetworkAclType(self):
        """网络ACL类型，三元组(TRIPLE)或五元组(QUINTUPLE)。默认值三元组(TRIPLE)。
        :rtype: str
        """
        return self._NetworkAclType

    @NetworkAclType.setter
    def NetworkAclType(self, NetworkAclType):
        self._NetworkAclType = NetworkAclType

    @property
    def Tags(self):
        """指定绑定的标签列表，例如：[{"Key": "city", "Value": "shanghai"}]。
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._NetworkAclName = params.get("NetworkAclName")
        self._NetworkAclType = params.get("NetworkAclType")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateNetworkAclResponse(AbstractModel):
    """CreateNetworkAcl返回参数结构体

    """

    def __init__(self):
        r"""
        :param _NetworkAcl: 网络ACL实例。
        :type NetworkAcl: :class:`tencentcloud.vpc.v20170312.models.NetworkAcl`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._NetworkAcl = None
        self._RequestId = None

    @property
    def NetworkAcl(self):
        """网络ACL实例。
        :rtype: :class:`tencentcloud.vpc.v20170312.models.NetworkAcl`
        """
        return self._NetworkAcl

    @NetworkAcl.setter
    def NetworkAcl(self, NetworkAcl):
        self._NetworkAcl = NetworkAcl

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NetworkAcl") is not None:
            self._NetworkAcl = NetworkAcl()
            self._NetworkAcl._deserialize(params.get("NetworkAcl"))
        self._RequestId = params.get("RequestId")


class CreateNetworkInterfaceRequest(AbstractModel):
    """CreateNetworkInterface请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VpcId: VPC实例ID。可通过DescribeVpcs接口返回值中的VpcId获取。
        :type VpcId: str
        :param _NetworkInterfaceName: 弹性网卡名称，最大长度不能超过60个字节。
        :type NetworkInterfaceName: str
        :param _SubnetId: 弹性网卡所在的子网实例ID，例如：subnet-0ap8nwca。
        :type SubnetId: str
        :param _NetworkInterfaceDescription: 弹性网卡描述，可任意命名，但不得超过60个字符。
        :type NetworkInterfaceDescription: str
        :param _SecondaryPrivateIpAddressCount: 新申请的内网IP地址个数，内网IP地址个数总和不能超过配额数。
配额数查询：[DescribeVpcLimits](https://cloud.tencent.com/document/api/215/42942)。
        :type SecondaryPrivateIpAddressCount: int
        :param _QosLevel: IP服务质量等级，和SecondaryPrivateIpAddressCount配合使用，可选值：PT、AU、AG、DEFAULT，分别代表云金、云银、云铜、默认四个等级。
        :type QosLevel: str
        :param _SecurityGroupIds: 指定绑定的安全组，例如：['sg-1dd51d']。
        :type SecurityGroupIds: list of str
        :param _PrivateIpAddresses: 指定的内网IP信息，单次最多指定10个。
        :type PrivateIpAddresses: list of PrivateIpAddressSpecification
        :param _Tags: 指定绑定的标签列表，例如：[{"Key": "city", "Value": "shanghai"}]
        :type Tags: list of Tag
        :param _TrunkingFlag: 网卡trunking模式设置，Enable-开启，Disable--关闭，默认关闭。
        :type TrunkingFlag: str
        :param _ClientToken: 用于保证请求幂等性的字符串。该字符串由客户生成，需保证不同请求之间唯一，最大值不超过64个ASCII字符。若不指定该参数，则无法保证请求的幂等性。	
        :type ClientToken: str
        """
        self._VpcId = None
        self._NetworkInterfaceName = None
        self._SubnetId = None
        self._NetworkInterfaceDescription = None
        self._SecondaryPrivateIpAddressCount = None
        self._QosLevel = None
        self._SecurityGroupIds = None
        self._PrivateIpAddresses = None
        self._Tags = None
        self._TrunkingFlag = None
        self._ClientToken = None

    @property
    def VpcId(self):
        """VPC实例ID。可通过DescribeVpcs接口返回值中的VpcId获取。
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def NetworkInterfaceName(self):
        """弹性网卡名称，最大长度不能超过60个字节。
        :rtype: str
        """
        return self._NetworkInterfaceName

    @NetworkInterfaceName.setter
    def NetworkInterfaceName(self, NetworkInterfaceName):
        self._NetworkInterfaceName = NetworkInterfaceName

    @property
    def SubnetId(self):
        """弹性网卡所在的子网实例ID，例如：subnet-0ap8nwca。
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def NetworkInterfaceDescription(self):
        """弹性网卡描述，可任意命名，但不得超过60个字符。
        :rtype: str
        """
        return self._NetworkInterfaceDescription

    @NetworkInterfaceDescription.setter
    def NetworkInterfaceDescription(self, NetworkInterfaceDescription):
        self._NetworkInterfaceDescription = NetworkInterfaceDescription

    @property
    def SecondaryPrivateIpAddressCount(self):
        """新申请的内网IP地址个数，内网IP地址个数总和不能超过配额数。
配额数查询：[DescribeVpcLimits](https://cloud.tencent.com/document/api/215/42942)。
        :rtype: int
        """
        return self._SecondaryPrivateIpAddressCount

    @SecondaryPrivateIpAddressCount.setter
    def SecondaryPrivateIpAddressCount(self, SecondaryPrivateIpAddressCount):
        self._SecondaryPrivateIpAddressCount = SecondaryPrivateIpAddressCount

    @property
    def QosLevel(self):
        """IP服务质量等级，和SecondaryPrivateIpAddressCount配合使用，可选值：PT、AU、AG、DEFAULT，分别代表云金、云银、云铜、默认四个等级。
        :rtype: str
        """
        return self._QosLevel

    @QosLevel.setter
    def QosLevel(self, QosLevel):
        self._QosLevel = QosLevel

    @property
    def SecurityGroupIds(self):
        """指定绑定的安全组，例如：['sg-1dd51d']。
        :rtype: list of str
        """
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds

    @property
    def PrivateIpAddresses(self):
        """指定的内网IP信息，单次最多指定10个。
        :rtype: list of PrivateIpAddressSpecification
        """
        return self._PrivateIpAddresses

    @PrivateIpAddresses.setter
    def PrivateIpAddresses(self, PrivateIpAddresses):
        self._PrivateIpAddresses = PrivateIpAddresses

    @property
    def Tags(self):
        """指定绑定的标签列表，例如：[{"Key": "city", "Value": "shanghai"}]
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def TrunkingFlag(self):
        """网卡trunking模式设置，Enable-开启，Disable--关闭，默认关闭。
        :rtype: str
        """
        return self._TrunkingFlag

    @TrunkingFlag.setter
    def TrunkingFlag(self, TrunkingFlag):
        self._TrunkingFlag = TrunkingFlag

    @property
    def ClientToken(self):
        """用于保证请求幂等性的字符串。该字符串由客户生成，需保证不同请求之间唯一，最大值不超过64个ASCII字符。若不指定该参数，则无法保证请求的幂等性。	
        :rtype: str
        """
        return self._ClientToken

    @ClientToken.setter
    def ClientToken(self, ClientToken):
        self._ClientToken = ClientToken


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._NetworkInterfaceName = params.get("NetworkInterfaceName")
        self._SubnetId = params.get("SubnetId")
        self._NetworkInterfaceDescription = params.get("NetworkInterfaceDescription")
        self._SecondaryPrivateIpAddressCount = params.get("SecondaryPrivateIpAddressCount")
        self._QosLevel = params.get("QosLevel")
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        if params.get("PrivateIpAddresses") is not None:
            self._PrivateIpAddresses = []
            for item in params.get("PrivateIpAddresses"):
                obj = PrivateIpAddressSpecification()
                obj._deserialize(item)
                self._PrivateIpAddresses.append(obj)
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._TrunkingFlag = params.get("TrunkingFlag")
        self._ClientToken = params.get("ClientToken")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateNetworkInterfaceResponse(AbstractModel):
    """CreateNetworkInterface返回参数结构体

    """

    def __init__(self):
        r"""
        :param _NetworkInterface: 弹性网卡实例。
        :type NetworkInterface: :class:`tencentcloud.vpc.v20170312.models.NetworkInterface`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._NetworkInterface = None
        self._RequestId = None

    @property
    def NetworkInterface(self):
        """弹性网卡实例。
        :rtype: :class:`tencentcloud.vpc.v20170312.models.NetworkInterface`
        """
        return self._NetworkInterface

    @NetworkInterface.setter
    def NetworkInterface(self, NetworkInterface):
        self._NetworkInterface = NetworkInterface

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NetworkInterface") is not None:
            self._NetworkInterface = NetworkInterface()
            self._NetworkInterface._deserialize(params.get("NetworkInterface"))
        self._RequestId = params.get("RequestId")


class CreatePrivateNatGatewayDestinationIpPortTranslationNatRuleRequest(AbstractModel):
    """CreatePrivateNatGatewayDestinationIpPortTranslationNatRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NatGatewayId: 私网网关唯一`ID`，形如：`intranat-xxxxxxxx`。
        :type NatGatewayId: str
        :param _LocalDestinationIpPortTranslationNatRules: 目的端口转换规则列表。
        :type LocalDestinationIpPortTranslationNatRules: list of LocalDestinationIpPortTranslationNatRule
        """
        self._NatGatewayId = None
        self._LocalDestinationIpPortTranslationNatRules = None

    @property
    def NatGatewayId(self):
        """私网网关唯一`ID`，形如：`intranat-xxxxxxxx`。
        :rtype: str
        """
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId

    @property
    def LocalDestinationIpPortTranslationNatRules(self):
        """目的端口转换规则列表。
        :rtype: list of LocalDestinationIpPortTranslationNatRule
        """
        return self._LocalDestinationIpPortTranslationNatRules

    @LocalDestinationIpPortTranslationNatRules.setter
    def LocalDestinationIpPortTranslationNatRules(self, LocalDestinationIpPortTranslationNatRules):
        self._LocalDestinationIpPortTranslationNatRules = LocalDestinationIpPortTranslationNatRules


    def _deserialize(self, params):
        self._NatGatewayId = params.get("NatGatewayId")
        if params.get("LocalDestinationIpPortTranslationNatRules") is not None:
            self._LocalDestinationIpPortTranslationNatRules = []
            for item in params.get("LocalDestinationIpPortTranslationNatRules"):
                obj = LocalDestinationIpPortTranslationNatRule()
                obj._deserialize(item)
                self._LocalDestinationIpPortTranslationNatRules.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreatePrivateNatGatewayDestinationIpPortTranslationNatRuleResponse(AbstractModel):
    """CreatePrivateNatGatewayDestinationIpPortTranslationNatRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreatePrivateNatGatewayRequest(AbstractModel):
    """CreatePrivateNatGateway请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NatGatewayName: 私网网关名称
        :type NatGatewayName: str
        :param _VpcId: 私有网络实例ID。当创建VPC类型私网NAT网关或者专线网关类型私网NAT网关时，此参数必填。
        :type VpcId: str
        :param _CrossDomain: 跨域参数。仅当取值为True时，才会支持跨域绑定VPC。
        :type CrossDomain: bool
        :param _Tags: 实例标签
        :type Tags: list of Tag
        :param _VpcType: VPC类型私网NAT网关。仅当取值为True时，才会创建VPC类型私网NAT网关。
        :type VpcType: bool
        :param _CcnId: 云联网类型私网NAT网关需要绑定的云联网实例ID。
        :type CcnId: str
        """
        self._NatGatewayName = None
        self._VpcId = None
        self._CrossDomain = None
        self._Tags = None
        self._VpcType = None
        self._CcnId = None

    @property
    def NatGatewayName(self):
        """私网网关名称
        :rtype: str
        """
        return self._NatGatewayName

    @NatGatewayName.setter
    def NatGatewayName(self, NatGatewayName):
        self._NatGatewayName = NatGatewayName

    @property
    def VpcId(self):
        """私有网络实例ID。当创建VPC类型私网NAT网关或者专线网关类型私网NAT网关时，此参数必填。
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def CrossDomain(self):
        """跨域参数。仅当取值为True时，才会支持跨域绑定VPC。
        :rtype: bool
        """
        return self._CrossDomain

    @CrossDomain.setter
    def CrossDomain(self, CrossDomain):
        self._CrossDomain = CrossDomain

    @property
    def Tags(self):
        """实例标签
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def VpcType(self):
        """VPC类型私网NAT网关。仅当取值为True时，才会创建VPC类型私网NAT网关。
        :rtype: bool
        """
        return self._VpcType

    @VpcType.setter
    def VpcType(self, VpcType):
        self._VpcType = VpcType

    @property
    def CcnId(self):
        """云联网类型私网NAT网关需要绑定的云联网实例ID。
        :rtype: str
        """
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId


    def _deserialize(self, params):
        self._NatGatewayName = params.get("NatGatewayName")
        self._VpcId = params.get("VpcId")
        self._CrossDomain = params.get("CrossDomain")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._VpcType = params.get("VpcType")
        self._CcnId = params.get("CcnId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreatePrivateNatGatewayResponse(AbstractModel):
    """CreatePrivateNatGateway返回参数结构体

    """

    def __init__(self):
        r"""
        :param _PrivateNatGatewaySet: 私网网关对象。
        :type PrivateNatGatewaySet: list of PrivateNatGateway
        :param _TotalCount: 创建实例个数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._PrivateNatGatewaySet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def PrivateNatGatewaySet(self):
        """私网网关对象。
        :rtype: list of PrivateNatGateway
        """
        return self._PrivateNatGatewaySet

    @PrivateNatGatewaySet.setter
    def PrivateNatGatewaySet(self, PrivateNatGatewaySet):
        self._PrivateNatGatewaySet = PrivateNatGatewaySet

    @property
    def TotalCount(self):
        """创建实例个数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("PrivateNatGatewaySet") is not None:
            self._PrivateNatGatewaySet = []
            for item in params.get("PrivateNatGatewaySet"):
                obj = PrivateNatGateway()
                obj._deserialize(item)
                self._PrivateNatGatewaySet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class CreatePrivateNatGatewayTranslationAclRuleRequest(AbstractModel):
    """CreatePrivateNatGatewayTranslationAclRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NatGatewayId: 私网网关唯一`ID`，形如：`intranat-xxxxxxxx`。
        :type NatGatewayId: str
        :param _TranslationDirection: 转换规则目标，可选值"LOCAL"。
        :type TranslationDirection: str
        :param _TranslationType: 转换规则类型，可选值"NETWORK_LAYER","TRANSPORT_LAYER"。
        :type TranslationType: str
        :param _TranslationIp: 转换`IP`,当转换规则类型为四层时为`IP`池。
        :type TranslationIp: str
        :param _TranslationAclRules: 访问控制列表。
        :type TranslationAclRules: list of TranslationAclRule
        :param _OriginalIp: 源`IP`,当转换规则类型为三层时有效。
        :type OriginalIp: str
        """
        self._NatGatewayId = None
        self._TranslationDirection = None
        self._TranslationType = None
        self._TranslationIp = None
        self._TranslationAclRules = None
        self._OriginalIp = None

    @property
    def NatGatewayId(self):
        """私网网关唯一`ID`，形如：`intranat-xxxxxxxx`。
        :rtype: str
        """
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId

    @property
    def TranslationDirection(self):
        """转换规则目标，可选值"LOCAL"。
        :rtype: str
        """
        return self._TranslationDirection

    @TranslationDirection.setter
    def TranslationDirection(self, TranslationDirection):
        self._TranslationDirection = TranslationDirection

    @property
    def TranslationType(self):
        """转换规则类型，可选值"NETWORK_LAYER","TRANSPORT_LAYER"。
        :rtype: str
        """
        return self._TranslationType

    @TranslationType.setter
    def TranslationType(self, TranslationType):
        self._TranslationType = TranslationType

    @property
    def TranslationIp(self):
        """转换`IP`,当转换规则类型为四层时为`IP`池。
        :rtype: str
        """
        return self._TranslationIp

    @TranslationIp.setter
    def TranslationIp(self, TranslationIp):
        self._TranslationIp = TranslationIp

    @property
    def TranslationAclRules(self):
        """访问控制列表。
        :rtype: list of TranslationAclRule
        """
        return self._TranslationAclRules

    @TranslationAclRules.setter
    def TranslationAclRules(self, TranslationAclRules):
        self._TranslationAclRules = TranslationAclRules

    @property
    def OriginalIp(self):
        """源`IP`,当转换规则类型为三层时有效。
        :rtype: str
        """
        return self._OriginalIp

    @OriginalIp.setter
    def OriginalIp(self, OriginalIp):
        self._OriginalIp = OriginalIp


    def _deserialize(self, params):
        self._NatGatewayId = params.get("NatGatewayId")
        self._TranslationDirection = params.get("TranslationDirection")
        self._TranslationType = params.get("TranslationType")
        self._TranslationIp = params.get("TranslationIp")
        if params.get("TranslationAclRules") is not None:
            self._TranslationAclRules = []
            for item in params.get("TranslationAclRules"):
                obj = TranslationAclRule()
                obj._deserialize(item)
                self._TranslationAclRules.append(obj)
        self._OriginalIp = params.get("OriginalIp")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreatePrivateNatGatewayTranslationAclRuleResponse(AbstractModel):
    """CreatePrivateNatGatewayTranslationAclRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreatePrivateNatGatewayTranslationNatRuleRequest(AbstractModel):
    """CreatePrivateNatGatewayTranslationNatRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NatGatewayId: 私网网关唯一`ID`，形如：`intranat-xxxxxxxx`。
        :type NatGatewayId: str
        :param _TranslationNatRules: 转换规则对象数组。
        :type TranslationNatRules: list of TranslationNatRuleInput
        :param _CrossDomain: 跨域参数，当VPC为跨域时填写为True。
        :type CrossDomain: bool
        """
        self._NatGatewayId = None
        self._TranslationNatRules = None
        self._CrossDomain = None

    @property
    def NatGatewayId(self):
        """私网网关唯一`ID`，形如：`intranat-xxxxxxxx`。
        :rtype: str
        """
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId

    @property
    def TranslationNatRules(self):
        """转换规则对象数组。
        :rtype: list of TranslationNatRuleInput
        """
        return self._TranslationNatRules

    @TranslationNatRules.setter
    def TranslationNatRules(self, TranslationNatRules):
        self._TranslationNatRules = TranslationNatRules

    @property
    def CrossDomain(self):
        """跨域参数，当VPC为跨域时填写为True。
        :rtype: bool
        """
        return self._CrossDomain

    @CrossDomain.setter
    def CrossDomain(self, CrossDomain):
        self._CrossDomain = CrossDomain


    def _deserialize(self, params):
        self._NatGatewayId = params.get("NatGatewayId")
        if params.get("TranslationNatRules") is not None:
            self._TranslationNatRules = []
            for item in params.get("TranslationNatRules"):
                obj = TranslationNatRuleInput()
                obj._deserialize(item)
                self._TranslationNatRules.append(obj)
        self._CrossDomain = params.get("CrossDomain")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreatePrivateNatGatewayTranslationNatRuleResponse(AbstractModel):
    """CreatePrivateNatGatewayTranslationNatRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _NatGatewayId: 私网网关唯一`ID`。
        :type NatGatewayId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._NatGatewayId = None
        self._RequestId = None

    @property
    def NatGatewayId(self):
        """私网网关唯一`ID`。
        :rtype: str
        """
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._NatGatewayId = params.get("NatGatewayId")
        self._RequestId = params.get("RequestId")


class CreateReserveIpAddressesRequest(AbstractModel):
    """CreateReserveIpAddresses请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VpcId: VPC唯一 ID。
        :type VpcId: str
        :param _IpAddresses: 指定IP申请的内网保留IP地址。
        :type IpAddresses: list of str
        :param _IpAddressCount: 不指定IP地址，指定个数自动分配保留内网IP。
        :type IpAddressCount: int
        :param _SubnetId: 子网唯一 ID。
        :type SubnetId: str
        :param _Name: 内网保留 IP名称。
        :type Name: str
        :param _Description: 内网保留 IP描述。
        :type Description: str
        :param _Tags: 指定绑定的标签列表，例如：[{"Key": "city", "Value": "shanghai"}]。
        :type Tags: list of Tag
        :param _ClientToken: 用于保证请求幂等性的字符串。该字符串由客户生成，需保证不同请求之间唯一，最大值不超过64个ASCII字符。若不指定该参数，则无法保证请求的幂等性。
        :type ClientToken: str
        """
        self._VpcId = None
        self._IpAddresses = None
        self._IpAddressCount = None
        self._SubnetId = None
        self._Name = None
        self._Description = None
        self._Tags = None
        self._ClientToken = None

    @property
    def VpcId(self):
        """VPC唯一 ID。
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def IpAddresses(self):
        """指定IP申请的内网保留IP地址。
        :rtype: list of str
        """
        return self._IpAddresses

    @IpAddresses.setter
    def IpAddresses(self, IpAddresses):
        self._IpAddresses = IpAddresses

    @property
    def IpAddressCount(self):
        """不指定IP地址，指定个数自动分配保留内网IP。
        :rtype: int
        """
        return self._IpAddressCount

    @IpAddressCount.setter
    def IpAddressCount(self, IpAddressCount):
        self._IpAddressCount = IpAddressCount

    @property
    def SubnetId(self):
        """子网唯一 ID。
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def Name(self):
        """内网保留 IP名称。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Description(self):
        """内网保留 IP描述。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Tags(self):
        """指定绑定的标签列表，例如：[{"Key": "city", "Value": "shanghai"}]。
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def ClientToken(self):
        """用于保证请求幂等性的字符串。该字符串由客户生成，需保证不同请求之间唯一，最大值不超过64个ASCII字符。若不指定该参数，则无法保证请求的幂等性。
        :rtype: str
        """
        return self._ClientToken

    @ClientToken.setter
    def ClientToken(self, ClientToken):
        self._ClientToken = ClientToken


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._IpAddresses = params.get("IpAddresses")
        self._IpAddressCount = params.get("IpAddressCount")
        self._SubnetId = params.get("SubnetId")
        self._Name = params.get("Name")
        self._Description = params.get("Description")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._ClientToken = params.get("ClientToken")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateReserveIpAddressesResponse(AbstractModel):
    """CreateReserveIpAddresses返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ReserveIpAddressSet: 内网保留 IP返回信息
        :type ReserveIpAddressSet: list of ReserveIpAddressInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ReserveIpAddressSet = None
        self._RequestId = None

    @property
    def ReserveIpAddressSet(self):
        """内网保留 IP返回信息
        :rtype: list of ReserveIpAddressInfo
        """
        return self._ReserveIpAddressSet

    @ReserveIpAddressSet.setter
    def ReserveIpAddressSet(self, ReserveIpAddressSet):
        self._ReserveIpAddressSet = ReserveIpAddressSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ReserveIpAddressSet") is not None:
            self._ReserveIpAddressSet = []
            for item in params.get("ReserveIpAddressSet"):
                obj = ReserveIpAddressInfo()
                obj._deserialize(item)
                self._ReserveIpAddressSet.append(obj)
        self._RequestId = params.get("RequestId")


class CreateRouteTableRequest(AbstractModel):
    """CreateRouteTable请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VpcId: 待操作的VPC实例ID。可通过DescribeVpcs接口返回值中的VpcId获取。
        :type VpcId: str
        :param _RouteTableName: 路由表名称，最大长度不能超过60个字节。
        :type RouteTableName: str
        :param _Tags: 指定绑定的标签列表，例如：[{"Key": "city", "Value": "shanghai"}]
        :type Tags: list of Tag
        """
        self._VpcId = None
        self._RouteTableName = None
        self._Tags = None

    @property
    def VpcId(self):
        """待操作的VPC实例ID。可通过DescribeVpcs接口返回值中的VpcId获取。
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def RouteTableName(self):
        """路由表名称，最大长度不能超过60个字节。
        :rtype: str
        """
        return self._RouteTableName

    @RouteTableName.setter
    def RouteTableName(self, RouteTableName):
        self._RouteTableName = RouteTableName

    @property
    def Tags(self):
        """指定绑定的标签列表，例如：[{"Key": "city", "Value": "shanghai"}]
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._RouteTableName = params.get("RouteTableName")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRouteTableResponse(AbstractModel):
    """CreateRouteTable返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RouteTable: 路由表对象。
        :type RouteTable: :class:`tencentcloud.vpc.v20170312.models.RouteTable`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RouteTable = None
        self._RequestId = None

    @property
    def RouteTable(self):
        """路由表对象。
        :rtype: :class:`tencentcloud.vpc.v20170312.models.RouteTable`
        """
        return self._RouteTable

    @RouteTable.setter
    def RouteTable(self, RouteTable):
        self._RouteTable = RouteTable

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RouteTable") is not None:
            self._RouteTable = RouteTable()
            self._RouteTable._deserialize(params.get("RouteTable"))
        self._RequestId = params.get("RequestId")


class CreateRoutesRequest(AbstractModel):
    """CreateRoutes请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RouteTableId: 路由表实例ID。
        :type RouteTableId: str
        :param _Routes: 路由策略对象。
        :type Routes: list of Route
        """
        self._RouteTableId = None
        self._Routes = None

    @property
    def RouteTableId(self):
        """路由表实例ID。
        :rtype: str
        """
        return self._RouteTableId

    @RouteTableId.setter
    def RouteTableId(self, RouteTableId):
        self._RouteTableId = RouteTableId

    @property
    def Routes(self):
        """路由策略对象。
        :rtype: list of Route
        """
        return self._Routes

    @Routes.setter
    def Routes(self, Routes):
        self._Routes = Routes


    def _deserialize(self, params):
        self._RouteTableId = params.get("RouteTableId")
        if params.get("Routes") is not None:
            self._Routes = []
            for item in params.get("Routes"):
                obj = Route()
                obj._deserialize(item)
                self._Routes.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRoutesResponse(AbstractModel):
    """CreateRoutes返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 新增的实例个数。
        :type TotalCount: int
        :param _RouteTableSet: 路由表对象。
        :type RouteTableSet: list of RouteTable
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._RouteTableSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """新增的实例个数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RouteTableSet(self):
        """路由表对象。
        :rtype: list of RouteTable
        """
        return self._RouteTableSet

    @RouteTableSet.setter
    def RouteTableSet(self, RouteTableSet):
        self._RouteTableSet = RouteTableSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("RouteTableSet") is not None:
            self._RouteTableSet = []
            for item in params.get("RouteTableSet"):
                obj = RouteTable()
                obj._deserialize(item)
                self._RouteTableSet.append(obj)
        self._RequestId = params.get("RequestId")


class CreateSecurityGroupPoliciesRequest(AbstractModel):
    """CreateSecurityGroupPolicies请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SecurityGroupId: 安全组实例ID，例如sg-33ocnj9n，可通过<a href="https://cloud.tencent.com/document/product/215/15808">DescribeSecurityGroups</a>获取。
        :type SecurityGroupId: str
        :param _SecurityGroupPolicySet: 安全组规则集合。
        :type SecurityGroupPolicySet: :class:`tencentcloud.vpc.v20170312.models.SecurityGroupPolicySet`
        """
        self._SecurityGroupId = None
        self._SecurityGroupPolicySet = None

    @property
    def SecurityGroupId(self):
        """安全组实例ID，例如sg-33ocnj9n，可通过<a href="https://cloud.tencent.com/document/product/215/15808">DescribeSecurityGroups</a>获取。
        :rtype: str
        """
        return self._SecurityGroupId

    @SecurityGroupId.setter
    def SecurityGroupId(self, SecurityGroupId):
        self._SecurityGroupId = SecurityGroupId

    @property
    def SecurityGroupPolicySet(self):
        """安全组规则集合。
        :rtype: :class:`tencentcloud.vpc.v20170312.models.SecurityGroupPolicySet`
        """
        return self._SecurityGroupPolicySet

    @SecurityGroupPolicySet.setter
    def SecurityGroupPolicySet(self, SecurityGroupPolicySet):
        self._SecurityGroupPolicySet = SecurityGroupPolicySet


    def _deserialize(self, params):
        self._SecurityGroupId = params.get("SecurityGroupId")
        if params.get("SecurityGroupPolicySet") is not None:
            self._SecurityGroupPolicySet = SecurityGroupPolicySet()
            self._SecurityGroupPolicySet._deserialize(params.get("SecurityGroupPolicySet"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSecurityGroupPoliciesResponse(AbstractModel):
    """CreateSecurityGroupPolicies返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateSecurityGroupRequest(AbstractModel):
    """CreateSecurityGroup请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GroupName: 安全组名称，可任意命名，但不得超过60个字符。
        :type GroupName: str
        :param _GroupDescription: 安全组备注，最多100个字符。
        :type GroupDescription: str
        :param _ProjectId: 项目ID，默认0。可在<a href="https://console.cloud.tencent.com/project">控制台项目管理页面</a>查询到。
        :type ProjectId: str
        :param _Tags: 指定绑定的标签列表，例如：[{"Key": "city", "Value": "shanghai"}]。
        :type Tags: list of Tag
        """
        self._GroupName = None
        self._GroupDescription = None
        self._ProjectId = None
        self._Tags = None

    @property
    def GroupName(self):
        """安全组名称，可任意命名，但不得超过60个字符。
        :rtype: str
        """
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName

    @property
    def GroupDescription(self):
        """安全组备注，最多100个字符。
        :rtype: str
        """
        return self._GroupDescription

    @GroupDescription.setter
    def GroupDescription(self, GroupDescription):
        self._GroupDescription = GroupDescription

    @property
    def ProjectId(self):
        """项目ID，默认0。可在<a href="https://console.cloud.tencent.com/project">控制台项目管理页面</a>查询到。
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Tags(self):
        """指定绑定的标签列表，例如：[{"Key": "city", "Value": "shanghai"}]。
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._GroupName = params.get("GroupName")
        self._GroupDescription = params.get("GroupDescription")
        self._ProjectId = params.get("ProjectId")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSecurityGroupResponse(AbstractModel):
    """CreateSecurityGroup返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SecurityGroup: 安全组对象。
        :type SecurityGroup: :class:`tencentcloud.vpc.v20170312.models.SecurityGroup`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SecurityGroup = None
        self._RequestId = None

    @property
    def SecurityGroup(self):
        """安全组对象。
        :rtype: :class:`tencentcloud.vpc.v20170312.models.SecurityGroup`
        """
        return self._SecurityGroup

    @SecurityGroup.setter
    def SecurityGroup(self, SecurityGroup):
        self._SecurityGroup = SecurityGroup

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SecurityGroup") is not None:
            self._SecurityGroup = SecurityGroup()
            self._SecurityGroup._deserialize(params.get("SecurityGroup"))
        self._RequestId = params.get("RequestId")


class CreateSecurityGroupWithPoliciesRequest(AbstractModel):
    """CreateSecurityGroupWithPolicies请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GroupName: 安全组名称，可任意命名，但不得超过60个字符。
        :type GroupName: str
        :param _GroupDescription: 安全组备注，最多100个字符。
        :type GroupDescription: str
        :param _ProjectId: 项目ID，默认0。可在<a href="https://console.cloud.tencent.com/project">控制台项目管理页面</a>查询到。
        :type ProjectId: str
        :param _SecurityGroupPolicySet: 安全组规则集合。
        :type SecurityGroupPolicySet: :class:`tencentcloud.vpc.v20170312.models.SecurityGroupPolicySet`
        :param _Tags: 指定绑定的标签列表，例如：[{"Key": "city", "Value": "shanghai"}]。
        :type Tags: list of Tag
        """
        self._GroupName = None
        self._GroupDescription = None
        self._ProjectId = None
        self._SecurityGroupPolicySet = None
        self._Tags = None

    @property
    def GroupName(self):
        """安全组名称，可任意命名，但不得超过60个字符。
        :rtype: str
        """
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName

    @property
    def GroupDescription(self):
        """安全组备注，最多100个字符。
        :rtype: str
        """
        return self._GroupDescription

    @GroupDescription.setter
    def GroupDescription(self, GroupDescription):
        self._GroupDescription = GroupDescription

    @property
    def ProjectId(self):
        """项目ID，默认0。可在<a href="https://console.cloud.tencent.com/project">控制台项目管理页面</a>查询到。
        :rtype: str
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def SecurityGroupPolicySet(self):
        """安全组规则集合。
        :rtype: :class:`tencentcloud.vpc.v20170312.models.SecurityGroupPolicySet`
        """
        return self._SecurityGroupPolicySet

    @SecurityGroupPolicySet.setter
    def SecurityGroupPolicySet(self, SecurityGroupPolicySet):
        self._SecurityGroupPolicySet = SecurityGroupPolicySet

    @property
    def Tags(self):
        """指定绑定的标签列表，例如：[{"Key": "city", "Value": "shanghai"}]。
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._GroupName = params.get("GroupName")
        self._GroupDescription = params.get("GroupDescription")
        self._ProjectId = params.get("ProjectId")
        if params.get("SecurityGroupPolicySet") is not None:
            self._SecurityGroupPolicySet = SecurityGroupPolicySet()
            self._SecurityGroupPolicySet._deserialize(params.get("SecurityGroupPolicySet"))
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSecurityGroupWithPoliciesResponse(AbstractModel):
    """CreateSecurityGroupWithPolicies返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SecurityGroup: 安全组对象。
        :type SecurityGroup: :class:`tencentcloud.vpc.v20170312.models.SecurityGroup`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SecurityGroup = None
        self._RequestId = None

    @property
    def SecurityGroup(self):
        """安全组对象。
        :rtype: :class:`tencentcloud.vpc.v20170312.models.SecurityGroup`
        """
        return self._SecurityGroup

    @SecurityGroup.setter
    def SecurityGroup(self, SecurityGroup):
        self._SecurityGroup = SecurityGroup

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SecurityGroup") is not None:
            self._SecurityGroup = SecurityGroup()
            self._SecurityGroup._deserialize(params.get("SecurityGroup"))
        self._RequestId = params.get("RequestId")


class CreateServiceTemplateGroupRequest(AbstractModel):
    """CreateServiceTemplateGroup请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ServiceTemplateGroupName: 协议端口模板集合名称。
        :type ServiceTemplateGroupName: str
        :param _ServiceTemplateIds: 协议端口模板实例ID，例如：ppm-4dw6agho。
        :type ServiceTemplateIds: list of str
        """
        self._ServiceTemplateGroupName = None
        self._ServiceTemplateIds = None

    @property
    def ServiceTemplateGroupName(self):
        """协议端口模板集合名称。
        :rtype: str
        """
        return self._ServiceTemplateGroupName

    @ServiceTemplateGroupName.setter
    def ServiceTemplateGroupName(self, ServiceTemplateGroupName):
        self._ServiceTemplateGroupName = ServiceTemplateGroupName

    @property
    def ServiceTemplateIds(self):
        """协议端口模板实例ID，例如：ppm-4dw6agho。
        :rtype: list of str
        """
        return self._ServiceTemplateIds

    @ServiceTemplateIds.setter
    def ServiceTemplateIds(self, ServiceTemplateIds):
        self._ServiceTemplateIds = ServiceTemplateIds


    def _deserialize(self, params):
        self._ServiceTemplateGroupName = params.get("ServiceTemplateGroupName")
        self._ServiceTemplateIds = params.get("ServiceTemplateIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateServiceTemplateGroupResponse(AbstractModel):
    """CreateServiceTemplateGroup返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ServiceTemplateGroup: 协议端口模板集合对象。
        :type ServiceTemplateGroup: :class:`tencentcloud.vpc.v20170312.models.ServiceTemplateGroup`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ServiceTemplateGroup = None
        self._RequestId = None

    @property
    def ServiceTemplateGroup(self):
        """协议端口模板集合对象。
        :rtype: :class:`tencentcloud.vpc.v20170312.models.ServiceTemplateGroup`
        """
        return self._ServiceTemplateGroup

    @ServiceTemplateGroup.setter
    def ServiceTemplateGroup(self, ServiceTemplateGroup):
        self._ServiceTemplateGroup = ServiceTemplateGroup

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ServiceTemplateGroup") is not None:
            self._ServiceTemplateGroup = ServiceTemplateGroup()
            self._ServiceTemplateGroup._deserialize(params.get("ServiceTemplateGroup"))
        self._RequestId = params.get("RequestId")


class CreateServiceTemplateRequest(AbstractModel):
    """CreateServiceTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ServiceTemplateName: 协议端口模板名称。
        :type ServiceTemplateName: str
        :param _Services: 支持单个端口、多个端口、连续端口及所有端口，协议支持：TCP、UDP、ICMP、GRE 协议。Services与ServicesExtra必填其一。
        :type Services: list of str
        :param _ServicesExtra: 支持添加备注，单个端口、多个端口、连续端口及所有端口，协议支持：TCP、UDP、ICMP、GRE 协议。Services与ServicesExtra必填其一。
        :type ServicesExtra: list of ServicesInfo
        """
        self._ServiceTemplateName = None
        self._Services = None
        self._ServicesExtra = None

    @property
    def ServiceTemplateName(self):
        """协议端口模板名称。
        :rtype: str
        """
        return self._ServiceTemplateName

    @ServiceTemplateName.setter
    def ServiceTemplateName(self, ServiceTemplateName):
        self._ServiceTemplateName = ServiceTemplateName

    @property
    def Services(self):
        """支持单个端口、多个端口、连续端口及所有端口，协议支持：TCP、UDP、ICMP、GRE 协议。Services与ServicesExtra必填其一。
        :rtype: list of str
        """
        return self._Services

    @Services.setter
    def Services(self, Services):
        self._Services = Services

    @property
    def ServicesExtra(self):
        """支持添加备注，单个端口、多个端口、连续端口及所有端口，协议支持：TCP、UDP、ICMP、GRE 协议。Services与ServicesExtra必填其一。
        :rtype: list of ServicesInfo
        """
        return self._ServicesExtra

    @ServicesExtra.setter
    def ServicesExtra(self, ServicesExtra):
        self._ServicesExtra = ServicesExtra


    def _deserialize(self, params):
        self._ServiceTemplateName = params.get("ServiceTemplateName")
        self._Services = params.get("Services")
        if params.get("ServicesExtra") is not None:
            self._ServicesExtra = []
            for item in params.get("ServicesExtra"):
                obj = ServicesInfo()
                obj._deserialize(item)
                self._ServicesExtra.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateServiceTemplateResponse(AbstractModel):
    """CreateServiceTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ServiceTemplate: 协议端口模板对象。
        :type ServiceTemplate: :class:`tencentcloud.vpc.v20170312.models.ServiceTemplate`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ServiceTemplate = None
        self._RequestId = None

    @property
    def ServiceTemplate(self):
        """协议端口模板对象。
        :rtype: :class:`tencentcloud.vpc.v20170312.models.ServiceTemplate`
        """
        return self._ServiceTemplate

    @ServiceTemplate.setter
    def ServiceTemplate(self, ServiceTemplate):
        self._ServiceTemplate = ServiceTemplate

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ServiceTemplate") is not None:
            self._ServiceTemplate = ServiceTemplate()
            self._ServiceTemplate._deserialize(params.get("ServiceTemplate"))
        self._RequestId = params.get("RequestId")


class CreateSnapshotPoliciesRequest(AbstractModel):
    """CreateSnapshotPolicies请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SnapshotPolicies: 快照策略详情。
        :type SnapshotPolicies: list of SnapshotPolicy
        """
        self._SnapshotPolicies = None

    @property
    def SnapshotPolicies(self):
        """快照策略详情。
        :rtype: list of SnapshotPolicy
        """
        return self._SnapshotPolicies

    @SnapshotPolicies.setter
    def SnapshotPolicies(self, SnapshotPolicies):
        self._SnapshotPolicies = SnapshotPolicies


    def _deserialize(self, params):
        if params.get("SnapshotPolicies") is not None:
            self._SnapshotPolicies = []
            for item in params.get("SnapshotPolicies"):
                obj = SnapshotPolicy()
                obj._deserialize(item)
                self._SnapshotPolicies.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSnapshotPoliciesResponse(AbstractModel):
    """CreateSnapshotPolicies返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SnapshotPolicies: 快照策略。
        :type SnapshotPolicies: list of SnapshotPolicy
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SnapshotPolicies = None
        self._RequestId = None

    @property
    def SnapshotPolicies(self):
        """快照策略。
        :rtype: list of SnapshotPolicy
        """
        return self._SnapshotPolicies

    @SnapshotPolicies.setter
    def SnapshotPolicies(self, SnapshotPolicies):
        self._SnapshotPolicies = SnapshotPolicies

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SnapshotPolicies") is not None:
            self._SnapshotPolicies = []
            for item in params.get("SnapshotPolicies"):
                obj = SnapshotPolicy()
                obj._deserialize(item)
                self._SnapshotPolicies.append(obj)
        self._RequestId = params.get("RequestId")


class CreateSubnetRequest(AbstractModel):
    """CreateSubnet请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VpcId: 待操作的VPC实例ID。可通过DescribeVpcs接口返回值中的VpcId获取。
        :type VpcId: str
        :param _SubnetName: 子网名称，最大长度不能超过60个字节。
        :type SubnetName: str
        :param _CidrBlock: 子网网段，子网网段必须在VPC网段内，相同VPC内子网网段不能重叠。
        :type CidrBlock: str
        :param _Zone: 子网所在的可用区ID，不同子网选择不同可用区可以做跨可用区灾备。
        :type Zone: str
        :param _Tags: 指定绑定的标签列表，例如：[{"Key": "city", "Value": "shanghai"}]
        :type Tags: list of Tag
        :param _CdcId: CDC实例ID。
        :type CdcId: str
        """
        self._VpcId = None
        self._SubnetName = None
        self._CidrBlock = None
        self._Zone = None
        self._Tags = None
        self._CdcId = None

    @property
    def VpcId(self):
        """待操作的VPC实例ID。可通过DescribeVpcs接口返回值中的VpcId获取。
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetName(self):
        """子网名称，最大长度不能超过60个字节。
        :rtype: str
        """
        return self._SubnetName

    @SubnetName.setter
    def SubnetName(self, SubnetName):
        self._SubnetName = SubnetName

    @property
    def CidrBlock(self):
        """子网网段，子网网段必须在VPC网段内，相同VPC内子网网段不能重叠。
        :rtype: str
        """
        return self._CidrBlock

    @CidrBlock.setter
    def CidrBlock(self, CidrBlock):
        self._CidrBlock = CidrBlock

    @property
    def Zone(self):
        """子网所在的可用区ID，不同子网选择不同可用区可以做跨可用区灾备。
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def Tags(self):
        """指定绑定的标签列表，例如：[{"Key": "city", "Value": "shanghai"}]
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def CdcId(self):
        """CDC实例ID。
        :rtype: str
        """
        return self._CdcId

    @CdcId.setter
    def CdcId(self, CdcId):
        self._CdcId = CdcId


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._SubnetName = params.get("SubnetName")
        self._CidrBlock = params.get("CidrBlock")
        self._Zone = params.get("Zone")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._CdcId = params.get("CdcId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSubnetResponse(AbstractModel):
    """CreateSubnet返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Subnet: 子网对象。
        :type Subnet: :class:`tencentcloud.vpc.v20170312.models.Subnet`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Subnet = None
        self._RequestId = None

    @property
    def Subnet(self):
        """子网对象。
        :rtype: :class:`tencentcloud.vpc.v20170312.models.Subnet`
        """
        return self._Subnet

    @Subnet.setter
    def Subnet(self, Subnet):
        self._Subnet = Subnet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Subnet") is not None:
            self._Subnet = Subnet()
            self._Subnet._deserialize(params.get("Subnet"))
        self._RequestId = params.get("RequestId")


class CreateSubnetsRequest(AbstractModel):
    """CreateSubnets请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VpcId: `VPC`实例`ID`。形如：`vpc-6v2ht8q5`。
        :type VpcId: str
        :param _Subnets: 子网对象列表。
        :type Subnets: list of SubnetInput
        :param _Tags: 指定绑定的标签列表，注意这里的标签集合为列表中所有子网对象所共享，不能为每个子网对象单独指定标签，例如：[{"Key": "city", "Value": "shanghai"}]。
        :type Tags: list of Tag
        :param _CdcId: 需要增加到的CDC实例ID。
        :type CdcId: str
        """
        self._VpcId = None
        self._Subnets = None
        self._Tags = None
        self._CdcId = None

    @property
    def VpcId(self):
        """`VPC`实例`ID`。形如：`vpc-6v2ht8q5`。
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def Subnets(self):
        """子网对象列表。
        :rtype: list of SubnetInput
        """
        return self._Subnets

    @Subnets.setter
    def Subnets(self, Subnets):
        self._Subnets = Subnets

    @property
    def Tags(self):
        """指定绑定的标签列表，注意这里的标签集合为列表中所有子网对象所共享，不能为每个子网对象单独指定标签，例如：[{"Key": "city", "Value": "shanghai"}]。
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def CdcId(self):
        """需要增加到的CDC实例ID。
        :rtype: str
        """
        return self._CdcId

    @CdcId.setter
    def CdcId(self, CdcId):
        self._CdcId = CdcId


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        if params.get("Subnets") is not None:
            self._Subnets = []
            for item in params.get("Subnets"):
                obj = SubnetInput()
                obj._deserialize(item)
                self._Subnets.append(obj)
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._CdcId = params.get("CdcId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSubnetsResponse(AbstractModel):
    """CreateSubnets返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SubnetSet: 新创建的子网列表。
        :type SubnetSet: list of Subnet
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SubnetSet = None
        self._RequestId = None

    @property
    def SubnetSet(self):
        """新创建的子网列表。
        :rtype: list of Subnet
        """
        return self._SubnetSet

    @SubnetSet.setter
    def SubnetSet(self, SubnetSet):
        self._SubnetSet = SubnetSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SubnetSet") is not None:
            self._SubnetSet = []
            for item in params.get("SubnetSet"):
                obj = Subnet()
                obj._deserialize(item)
                self._SubnetSet.append(obj)
        self._RequestId = params.get("RequestId")


class CreateTrafficPackagesRequest(AbstractModel):
    """CreateTrafficPackages请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TrafficAmount: 流量包规格。可选值:
<li>10: 10GB流量，有效期一个月</li>
<li>50: 50GB流量，有效期一个月</li>
<li>512: 512GB流量，有效期一个月</li>
<li>1024: 1TB流量，有效期一个月</li>
<li>5120: 5TB流量，有效期一个月</li>
<li>51200: 50TB流量，有效期一个月</li>
<li>60: 60GB流量，有效期半年</li>
<li>300: 300GB流量，有效期半年</li>
<li>600: 600GB流量，有效期半年</li>
<li>3072: 3TB流量，有效期半年</li>
<li>6144: 6TB流量，有效期半年</li>
<li>30720: 30TB流量，有效期半年</li>
<li>61440: 60TB流量，有效期半年</li>
<li>307200: 300TB流量，有效期半年</li>
        :type TrafficAmount: int
        :param _TrafficPackageCount: 流量包数量，可选范围 1~20。
        :type TrafficPackageCount: int
        """
        self._TrafficAmount = None
        self._TrafficPackageCount = None

    @property
    def TrafficAmount(self):
        """流量包规格。可选值:
<li>10: 10GB流量，有效期一个月</li>
<li>50: 50GB流量，有效期一个月</li>
<li>512: 512GB流量，有效期一个月</li>
<li>1024: 1TB流量，有效期一个月</li>
<li>5120: 5TB流量，有效期一个月</li>
<li>51200: 50TB流量，有效期一个月</li>
<li>60: 60GB流量，有效期半年</li>
<li>300: 300GB流量，有效期半年</li>
<li>600: 600GB流量，有效期半年</li>
<li>3072: 3TB流量，有效期半年</li>
<li>6144: 6TB流量，有效期半年</li>
<li>30720: 30TB流量，有效期半年</li>
<li>61440: 60TB流量，有效期半年</li>
<li>307200: 300TB流量，有效期半年</li>
        :rtype: int
        """
        return self._TrafficAmount

    @TrafficAmount.setter
    def TrafficAmount(self, TrafficAmount):
        self._TrafficAmount = TrafficAmount

    @property
    def TrafficPackageCount(self):
        """流量包数量，可选范围 1~20。
        :rtype: int
        """
        return self._TrafficPackageCount

    @TrafficPackageCount.setter
    def TrafficPackageCount(self, TrafficPackageCount):
        self._TrafficPackageCount = TrafficPackageCount


    def _deserialize(self, params):
        self._TrafficAmount = params.get("TrafficAmount")
        self._TrafficPackageCount = params.get("TrafficPackageCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateTrafficPackagesResponse(AbstractModel):
    """CreateTrafficPackages返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TrafficPackageSet: 创建的流量包ID列表。
        :type TrafficPackageSet: list of str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TrafficPackageSet = None
        self._RequestId = None

    @property
    def TrafficPackageSet(self):
        """创建的流量包ID列表。
        :rtype: list of str
        """
        return self._TrafficPackageSet

    @TrafficPackageSet.setter
    def TrafficPackageSet(self, TrafficPackageSet):
        self._TrafficPackageSet = TrafficPackageSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TrafficPackageSet = params.get("TrafficPackageSet")
        self._RequestId = params.get("RequestId")


class CreateVpcEndPointRequest(AbstractModel):
    """CreateVpcEndPoint请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VpcId: VPC实例ID。
        :type VpcId: str
        :param _SubnetId: 子网实例ID。
        :type SubnetId: str
        :param _EndPointName: 终端节点名称。
        :type EndPointName: str
        :param _EndPointServiceId: 终端节点服务ID。
        :type EndPointServiceId: str
        :param _EndPointVip: 终端节点VIP，可以指定IP申请。
        :type EndPointVip: str
        :param _SecurityGroupId: 安全组ID。
        :type SecurityGroupId: str
        :param _Tags: 指定绑定的标签列表，例如：[{"Key": "city", "Value": "shanghai"}]。
        :type Tags: list of Tag
        """
        self._VpcId = None
        self._SubnetId = None
        self._EndPointName = None
        self._EndPointServiceId = None
        self._EndPointVip = None
        self._SecurityGroupId = None
        self._Tags = None

    @property
    def VpcId(self):
        """VPC实例ID。
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        """子网实例ID。
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def EndPointName(self):
        """终端节点名称。
        :rtype: str
        """
        return self._EndPointName

    @EndPointName.setter
    def EndPointName(self, EndPointName):
        self._EndPointName = EndPointName

    @property
    def EndPointServiceId(self):
        """终端节点服务ID。
        :rtype: str
        """
        return self._EndPointServiceId

    @EndPointServiceId.setter
    def EndPointServiceId(self, EndPointServiceId):
        self._EndPointServiceId = EndPointServiceId

    @property
    def EndPointVip(self):
        """终端节点VIP，可以指定IP申请。
        :rtype: str
        """
        return self._EndPointVip

    @EndPointVip.setter
    def EndPointVip(self, EndPointVip):
        self._EndPointVip = EndPointVip

    @property
    def SecurityGroupId(self):
        """安全组ID。
        :rtype: str
        """
        return self._SecurityGroupId

    @SecurityGroupId.setter
    def SecurityGroupId(self, SecurityGroupId):
        self._SecurityGroupId = SecurityGroupId

    @property
    def Tags(self):
        """指定绑定的标签列表，例如：[{"Key": "city", "Value": "shanghai"}]。
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._EndPointName = params.get("EndPointName")
        self._EndPointServiceId = params.get("EndPointServiceId")
        self._EndPointVip = params.get("EndPointVip")
        self._SecurityGroupId = params.get("SecurityGroupId")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVpcEndPointResponse(AbstractModel):
    """CreateVpcEndPoint返回参数结构体

    """

    def __init__(self):
        r"""
        :param _EndPoint: 终端节点对象详细信息。
        :type EndPoint: :class:`tencentcloud.vpc.v20170312.models.EndPoint`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._EndPoint = None
        self._RequestId = None

    @property
    def EndPoint(self):
        """终端节点对象详细信息。
        :rtype: :class:`tencentcloud.vpc.v20170312.models.EndPoint`
        """
        return self._EndPoint

    @EndPoint.setter
    def EndPoint(self, EndPoint):
        self._EndPoint = EndPoint

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("EndPoint") is not None:
            self._EndPoint = EndPoint()
            self._EndPoint._deserialize(params.get("EndPoint"))
        self._RequestId = params.get("RequestId")


class CreateVpcEndPointServiceRequest(AbstractModel):
    """CreateVpcEndPointService请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VpcId: VPC实例ID。
        :type VpcId: str
        :param _EndPointServiceName: 终端节点服务名称。
        :type EndPointServiceName: str
        :param _AutoAcceptFlag: 是否自动接受。
        :type AutoAcceptFlag: bool
        :param _ServiceInstanceId: 后端服务ID，比如lb-xxx。
        :type ServiceInstanceId: str
        :param _IsPassService: ~~是否是PassService类型。该字段已废弃，请不要使用该字段。~~
        :type IsPassService: bool
        :param _ServiceType: 挂载的PAAS服务类型，CLB,CDB,CRS，不填默认挂载为CLB。
        :type ServiceType: str
        """
        self._VpcId = None
        self._EndPointServiceName = None
        self._AutoAcceptFlag = None
        self._ServiceInstanceId = None
        self._IsPassService = None
        self._ServiceType = None

    @property
    def VpcId(self):
        """VPC实例ID。
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def EndPointServiceName(self):
        """终端节点服务名称。
        :rtype: str
        """
        return self._EndPointServiceName

    @EndPointServiceName.setter
    def EndPointServiceName(self, EndPointServiceName):
        self._EndPointServiceName = EndPointServiceName

    @property
    def AutoAcceptFlag(self):
        """是否自动接受。
        :rtype: bool
        """
        return self._AutoAcceptFlag

    @AutoAcceptFlag.setter
    def AutoAcceptFlag(self, AutoAcceptFlag):
        self._AutoAcceptFlag = AutoAcceptFlag

    @property
    def ServiceInstanceId(self):
        """后端服务ID，比如lb-xxx。
        :rtype: str
        """
        return self._ServiceInstanceId

    @ServiceInstanceId.setter
    def ServiceInstanceId(self, ServiceInstanceId):
        self._ServiceInstanceId = ServiceInstanceId

    @property
    def IsPassService(self):
        """~~是否是PassService类型。该字段已废弃，请不要使用该字段。~~
        :rtype: bool
        """
        return self._IsPassService

    @IsPassService.setter
    def IsPassService(self, IsPassService):
        self._IsPassService = IsPassService

    @property
    def ServiceType(self):
        """挂载的PAAS服务类型，CLB,CDB,CRS，不填默认挂载为CLB。
        :rtype: str
        """
        return self._ServiceType

    @ServiceType.setter
    def ServiceType(self, ServiceType):
        self._ServiceType = ServiceType


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._EndPointServiceName = params.get("EndPointServiceName")
        self._AutoAcceptFlag = params.get("AutoAcceptFlag")
        self._ServiceInstanceId = params.get("ServiceInstanceId")
        self._IsPassService = params.get("IsPassService")
        self._ServiceType = params.get("ServiceType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVpcEndPointServiceResponse(AbstractModel):
    """CreateVpcEndPointService返回参数结构体

    """

    def __init__(self):
        r"""
        :param _EndPointService: 终端节点服务对象详细信息。
        :type EndPointService: :class:`tencentcloud.vpc.v20170312.models.EndPointService`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._EndPointService = None
        self._RequestId = None

    @property
    def EndPointService(self):
        """终端节点服务对象详细信息。
        :rtype: :class:`tencentcloud.vpc.v20170312.models.EndPointService`
        """
        return self._EndPointService

    @EndPointService.setter
    def EndPointService(self, EndPointService):
        self._EndPointService = EndPointService

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("EndPointService") is not None:
            self._EndPointService = EndPointService()
            self._EndPointService._deserialize(params.get("EndPointService"))
        self._RequestId = params.get("RequestId")


class CreateVpcEndPointServiceWhiteListRequest(AbstractModel):
    """CreateVpcEndPointServiceWhiteList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _UserUin: UIN。
        :type UserUin: str
        :param _EndPointServiceId: 终端节点服务ID。
        :type EndPointServiceId: str
        :param _Description: 白名单描述。
        :type Description: str
        """
        self._UserUin = None
        self._EndPointServiceId = None
        self._Description = None

    @property
    def UserUin(self):
        """UIN。
        :rtype: str
        """
        return self._UserUin

    @UserUin.setter
    def UserUin(self, UserUin):
        self._UserUin = UserUin

    @property
    def EndPointServiceId(self):
        """终端节点服务ID。
        :rtype: str
        """
        return self._EndPointServiceId

    @EndPointServiceId.setter
    def EndPointServiceId(self, EndPointServiceId):
        self._EndPointServiceId = EndPointServiceId

    @property
    def Description(self):
        """白名单描述。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._UserUin = params.get("UserUin")
        self._EndPointServiceId = params.get("EndPointServiceId")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVpcEndPointServiceWhiteListResponse(AbstractModel):
    """CreateVpcEndPointServiceWhiteList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateVpcPeeringConnectionRequest(AbstractModel):
    """CreateVpcPeeringConnection请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SourceVpcId: 本端VPC唯一ID。
        :type SourceVpcId: str
        :param _PeeringConnectionName: 对等连接名称。
        :type PeeringConnectionName: str
        :param _DestinationVpcId: 对端VPC唯一ID。
        :type DestinationVpcId: str
        :param _DestinationUin: 对端用户UIN。
        :type DestinationUin: str
        :param _DestinationRegion: 对端地域。
        :type DestinationRegion: str
        :param _Bandwidth: 带宽上限，单位Mbps。
        :type Bandwidth: int
        :param _Type: 互通类型，VPC_PEER：VPC间互通；VPC_BM_PEER：VPC与黑石网络互通。
        :type Type: str
        :param _ChargeType: 计费模式，日峰值POSTPAID_BY_DAY_MAX，月95POSTPAID_BY_MONTH_95。
        :type ChargeType: str
        :param _QosLevel: 服务分级：PT、AU、AG。
        :type QosLevel: str
        :param _Tags: 标签键值对
        :type Tags: list of Tags
        """
        self._SourceVpcId = None
        self._PeeringConnectionName = None
        self._DestinationVpcId = None
        self._DestinationUin = None
        self._DestinationRegion = None
        self._Bandwidth = None
        self._Type = None
        self._ChargeType = None
        self._QosLevel = None
        self._Tags = None

    @property
    def SourceVpcId(self):
        """本端VPC唯一ID。
        :rtype: str
        """
        return self._SourceVpcId

    @SourceVpcId.setter
    def SourceVpcId(self, SourceVpcId):
        self._SourceVpcId = SourceVpcId

    @property
    def PeeringConnectionName(self):
        """对等连接名称。
        :rtype: str
        """
        return self._PeeringConnectionName

    @PeeringConnectionName.setter
    def PeeringConnectionName(self, PeeringConnectionName):
        self._PeeringConnectionName = PeeringConnectionName

    @property
    def DestinationVpcId(self):
        """对端VPC唯一ID。
        :rtype: str
        """
        return self._DestinationVpcId

    @DestinationVpcId.setter
    def DestinationVpcId(self, DestinationVpcId):
        self._DestinationVpcId = DestinationVpcId

    @property
    def DestinationUin(self):
        """对端用户UIN。
        :rtype: str
        """
        return self._DestinationUin

    @DestinationUin.setter
    def DestinationUin(self, DestinationUin):
        self._DestinationUin = DestinationUin

    @property
    def DestinationRegion(self):
        """对端地域。
        :rtype: str
        """
        return self._DestinationRegion

    @DestinationRegion.setter
    def DestinationRegion(self, DestinationRegion):
        self._DestinationRegion = DestinationRegion

    @property
    def Bandwidth(self):
        """带宽上限，单位Mbps。
        :rtype: int
        """
        return self._Bandwidth

    @Bandwidth.setter
    def Bandwidth(self, Bandwidth):
        self._Bandwidth = Bandwidth

    @property
    def Type(self):
        """互通类型，VPC_PEER：VPC间互通；VPC_BM_PEER：VPC与黑石网络互通。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def ChargeType(self):
        """计费模式，日峰值POSTPAID_BY_DAY_MAX，月95POSTPAID_BY_MONTH_95。
        :rtype: str
        """
        return self._ChargeType

    @ChargeType.setter
    def ChargeType(self, ChargeType):
        self._ChargeType = ChargeType

    @property
    def QosLevel(self):
        """服务分级：PT、AU、AG。
        :rtype: str
        """
        return self._QosLevel

    @QosLevel.setter
    def QosLevel(self, QosLevel):
        self._QosLevel = QosLevel

    @property
    def Tags(self):
        """标签键值对
        :rtype: list of Tags
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._SourceVpcId = params.get("SourceVpcId")
        self._PeeringConnectionName = params.get("PeeringConnectionName")
        self._DestinationVpcId = params.get("DestinationVpcId")
        self._DestinationUin = params.get("DestinationUin")
        self._DestinationRegion = params.get("DestinationRegion")
        self._Bandwidth = params.get("Bandwidth")
        self._Type = params.get("Type")
        self._ChargeType = params.get("ChargeType")
        self._QosLevel = params.get("QosLevel")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tags()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVpcPeeringConnectionResponse(AbstractModel):
    """CreateVpcPeeringConnection返回参数结构体

    """

    def __init__(self):
        r"""
        :param _PeeringConnectionId: 对等连接ID
注意：此字段可能返回 null，表示取不到有效值。
        :type PeeringConnectionId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._PeeringConnectionId = None
        self._RequestId = None

    @property
    def PeeringConnectionId(self):
        """对等连接ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PeeringConnectionId

    @PeeringConnectionId.setter
    def PeeringConnectionId(self, PeeringConnectionId):
        self._PeeringConnectionId = PeeringConnectionId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._PeeringConnectionId = params.get("PeeringConnectionId")
        self._RequestId = params.get("RequestId")


class CreateVpcRequest(AbstractModel):
    """CreateVpc请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VpcName: vpc名称，最大长度不能超过60个字节。
        :type VpcName: str
        :param _CidrBlock: vpc的cidr，仅能在10.0.0.0/12，172.16.0.0/12，192.168.0.0/16这三个内网网段内。
        :type CidrBlock: str
        :param _EnableMulticast: 是否开启组播。true: 开启, false: 不开启。
        :type EnableMulticast: str
        :param _DnsServers: DNS地址，最多支持4个。
        :type DnsServers: list of str
        :param _DomainName: DHCP使用的域名。
        :type DomainName: str
        :param _Tags: 指定绑定的标签列表，例如：[{"Key": "city", "Value": "shanghai"}]。
        :type Tags: list of Tag
        """
        self._VpcName = None
        self._CidrBlock = None
        self._EnableMulticast = None
        self._DnsServers = None
        self._DomainName = None
        self._Tags = None

    @property
    def VpcName(self):
        """vpc名称，最大长度不能超过60个字节。
        :rtype: str
        """
        return self._VpcName

    @VpcName.setter
    def VpcName(self, VpcName):
        self._VpcName = VpcName

    @property
    def CidrBlock(self):
        """vpc的cidr，仅能在10.0.0.0/12，172.16.0.0/12，192.168.0.0/16这三个内网网段内。
        :rtype: str
        """
        return self._CidrBlock

    @CidrBlock.setter
    def CidrBlock(self, CidrBlock):
        self._CidrBlock = CidrBlock

    @property
    def EnableMulticast(self):
        """是否开启组播。true: 开启, false: 不开启。
        :rtype: str
        """
        return self._EnableMulticast

    @EnableMulticast.setter
    def EnableMulticast(self, EnableMulticast):
        self._EnableMulticast = EnableMulticast

    @property
    def DnsServers(self):
        """DNS地址，最多支持4个。
        :rtype: list of str
        """
        return self._DnsServers

    @DnsServers.setter
    def DnsServers(self, DnsServers):
        self._DnsServers = DnsServers

    @property
    def DomainName(self):
        """DHCP使用的域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def Tags(self):
        """指定绑定的标签列表，例如：[{"Key": "city", "Value": "shanghai"}]。
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._VpcName = params.get("VpcName")
        self._CidrBlock = params.get("CidrBlock")
        self._EnableMulticast = params.get("EnableMulticast")
        self._DnsServers = params.get("DnsServers")
        self._DomainName = params.get("DomainName")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVpcResponse(AbstractModel):
    """CreateVpc返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Vpc: Vpc对象。
        :type Vpc: :class:`tencentcloud.vpc.v20170312.models.Vpc`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Vpc = None
        self._RequestId = None

    @property
    def Vpc(self):
        """Vpc对象。
        :rtype: :class:`tencentcloud.vpc.v20170312.models.Vpc`
        """
        return self._Vpc

    @Vpc.setter
    def Vpc(self, Vpc):
        self._Vpc = Vpc

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Vpc") is not None:
            self._Vpc = Vpc()
            self._Vpc._deserialize(params.get("Vpc"))
        self._RequestId = params.get("RequestId")


class CreateVpnConnRoute(AbstractModel):
    """创建路由添加的指向此通道的路由

    """

    def __init__(self):
        r"""
        :param _DestinationCidrBlock: 目的端IDC网段
        :type DestinationCidrBlock: str
        :param _Priority: 优先级；可选值0，100。
        :type Priority: int
        """
        self._DestinationCidrBlock = None
        self._Priority = None

    @property
    def DestinationCidrBlock(self):
        """目的端IDC网段
        :rtype: str
        """
        return self._DestinationCidrBlock

    @DestinationCidrBlock.setter
    def DestinationCidrBlock(self, DestinationCidrBlock):
        self._DestinationCidrBlock = DestinationCidrBlock

    @property
    def Priority(self):
        """优先级；可选值0，100。
        :rtype: int
        """
        return self._Priority

    @Priority.setter
    def Priority(self, Priority):
        self._Priority = Priority


    def _deserialize(self, params):
        self._DestinationCidrBlock = params.get("DestinationCidrBlock")
        self._Priority = params.get("Priority")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVpnConnectionRequest(AbstractModel):
    """CreateVpnConnection请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VpnGatewayId: VPN网关实例ID。
        :type VpnGatewayId: str
        :param _CustomerGatewayId: 对端网关ID。例如：cgw-2wqq41m9，可通过[DescribeCustomerGateways](https://cloud.tencent.com/document/product/215/17516)接口查询对端网关。
        :type CustomerGatewayId: str
        :param _VpnConnectionName: 通道名称，可任意命名，但不得超过60个字符。
        :type VpnConnectionName: str
        :param _PreShareKey: 预共享密钥。
        :type PreShareKey: str
        :param _VpcId: VPC实例ID。可通过[DescribeVpcs](https://cloud.tencent.com/document/product/215/15778)接口返回值中的VpcId获取。
CCN VPN 形的通道 可以不传VPCID
        :type VpcId: str
        :param _SecurityPolicyDatabases: SPD策略组，例如：{"10.0.0.5/24":["172.123.10.5/16"]}，10.0.0.5/24是vpc内网段172.123.10.5/16是IDC网段。用户指定VPC内哪些网段可以和您IDC中哪些网段通信。
        :type SecurityPolicyDatabases: list of SecurityPolicyDatabase
        :param _IKEOptionsSpecification: IKE配置（Internet Key Exchange，因特网密钥交换），IKE具有一套自我保护机制，用户配置网络安全协议
        :type IKEOptionsSpecification: :class:`tencentcloud.vpc.v20170312.models.IKEOptionsSpecification`
        :param _IPSECOptionsSpecification: IPSec配置，腾讯云提供IPSec安全会话设置
        :type IPSECOptionsSpecification: :class:`tencentcloud.vpc.v20170312.models.IPSECOptionsSpecification`
        :param _Tags: 指定绑定的标签列表，例如：[{"Key": "city", "Value": "shanghai"}]
        :type Tags: list of Tag
        :param _EnableHealthCheck: 是否支持隧道内健康检查，默认为False。
        :type EnableHealthCheck: bool
        :param _HealthCheckLocalIp: 健康检查本端地址，默认值为随机在169.254.128.0/17分配一个IP。
        :type HealthCheckLocalIp: str
        :param _HealthCheckRemoteIp: 健康检查对端地址，默认值为随机在169.254.128.0/17分配一个IP。
        :type HealthCheckRemoteIp: str
        :param _RouteType: 通道类型, 例如:["STATIC", "StaticRoute", "Policy"]
        :type RouteType: str
        :param _NegotiationType: 协商类型，默认为active（主动协商）。可选值：active（主动协商），passive（被动协商），flowTrigger（流量协商）
        :type NegotiationType: str
        :param _DpdEnable: DPD探测开关。默认为0，表示关闭DPD探测。可选值：0（关闭），1（开启）
        :type DpdEnable: int
        :param _DpdTimeout: DPD超时时间。即探测确认对端不存在需要的时间。dpdEnable为1（开启）时有效。默认30，单位为秒
        :type DpdTimeout: str
        :param _DpdAction: DPD超时后的动作。默认为clear。dpdEnable为1（开启）时有效。可取值为clear（断开）和restart（重试）
        :type DpdAction: str
        :param _Route: 创建通道路由信息。
        :type Route: :class:`tencentcloud.vpc.v20170312.models.CreateVpnConnRoute`
        :param _BgpConfig: BGP配置。
        :type BgpConfig: :class:`tencentcloud.vpc.v20170312.models.BgpConfig`
        :param _HealthCheckConfig: 健康检查NQA配置。
        :type HealthCheckConfig: :class:`tencentcloud.vpc.v20170312.models.HealthCheckConfig`
        """
        self._VpnGatewayId = None
        self._CustomerGatewayId = None
        self._VpnConnectionName = None
        self._PreShareKey = None
        self._VpcId = None
        self._SecurityPolicyDatabases = None
        self._IKEOptionsSpecification = None
        self._IPSECOptionsSpecification = None
        self._Tags = None
        self._EnableHealthCheck = None
        self._HealthCheckLocalIp = None
        self._HealthCheckRemoteIp = None
        self._RouteType = None
        self._NegotiationType = None
        self._DpdEnable = None
        self._DpdTimeout = None
        self._DpdAction = None
        self._Route = None
        self._BgpConfig = None
        self._HealthCheckConfig = None

    @property
    def VpnGatewayId(self):
        """VPN网关实例ID。
        :rtype: str
        """
        return self._VpnGatewayId

    @VpnGatewayId.setter
    def VpnGatewayId(self, VpnGatewayId):
        self._VpnGatewayId = VpnGatewayId

    @property
    def CustomerGatewayId(self):
        """对端网关ID。例如：cgw-2wqq41m9，可通过[DescribeCustomerGateways](https://cloud.tencent.com/document/product/215/17516)接口查询对端网关。
        :rtype: str
        """
        return self._CustomerGatewayId

    @CustomerGatewayId.setter
    def CustomerGatewayId(self, CustomerGatewayId):
        self._CustomerGatewayId = CustomerGatewayId

    @property
    def VpnConnectionName(self):
        """通道名称，可任意命名，但不得超过60个字符。
        :rtype: str
        """
        return self._VpnConnectionName

    @VpnConnectionName.setter
    def VpnConnectionName(self, VpnConnectionName):
        self._VpnConnectionName = VpnConnectionName

    @property
    def PreShareKey(self):
        """预共享密钥。
        :rtype: str
        """
        return self._PreShareKey

    @PreShareKey.setter
    def PreShareKey(self, PreShareKey):
        self._PreShareKey = PreShareKey

    @property
    def VpcId(self):
        """VPC实例ID。可通过[DescribeVpcs](https://cloud.tencent.com/document/product/215/15778)接口返回值中的VpcId获取。
CCN VPN 形的通道 可以不传VPCID
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SecurityPolicyDatabases(self):
        """SPD策略组，例如：{"10.0.0.5/24":["172.123.10.5/16"]}，10.0.0.5/24是vpc内网段172.123.10.5/16是IDC网段。用户指定VPC内哪些网段可以和您IDC中哪些网段通信。
        :rtype: list of SecurityPolicyDatabase
        """
        return self._SecurityPolicyDatabases

    @SecurityPolicyDatabases.setter
    def SecurityPolicyDatabases(self, SecurityPolicyDatabases):
        self._SecurityPolicyDatabases = SecurityPolicyDatabases

    @property
    def IKEOptionsSpecification(self):
        """IKE配置（Internet Key Exchange，因特网密钥交换），IKE具有一套自我保护机制，用户配置网络安全协议
        :rtype: :class:`tencentcloud.vpc.v20170312.models.IKEOptionsSpecification`
        """
        return self._IKEOptionsSpecification

    @IKEOptionsSpecification.setter
    def IKEOptionsSpecification(self, IKEOptionsSpecification):
        self._IKEOptionsSpecification = IKEOptionsSpecification

    @property
    def IPSECOptionsSpecification(self):
        """IPSec配置，腾讯云提供IPSec安全会话设置
        :rtype: :class:`tencentcloud.vpc.v20170312.models.IPSECOptionsSpecification`
        """
        return self._IPSECOptionsSpecification

    @IPSECOptionsSpecification.setter
    def IPSECOptionsSpecification(self, IPSECOptionsSpecification):
        self._IPSECOptionsSpecification = IPSECOptionsSpecification

    @property
    def Tags(self):
        """指定绑定的标签列表，例如：[{"Key": "city", "Value": "shanghai"}]
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def EnableHealthCheck(self):
        """是否支持隧道内健康检查，默认为False。
        :rtype: bool
        """
        return self._EnableHealthCheck

    @EnableHealthCheck.setter
    def EnableHealthCheck(self, EnableHealthCheck):
        self._EnableHealthCheck = EnableHealthCheck

    @property
    def HealthCheckLocalIp(self):
        """健康检查本端地址，默认值为随机在169.254.128.0/17分配一个IP。
        :rtype: str
        """
        return self._HealthCheckLocalIp

    @HealthCheckLocalIp.setter
    def HealthCheckLocalIp(self, HealthCheckLocalIp):
        self._HealthCheckLocalIp = HealthCheckLocalIp

    @property
    def HealthCheckRemoteIp(self):
        """健康检查对端地址，默认值为随机在169.254.128.0/17分配一个IP。
        :rtype: str
        """
        return self._HealthCheckRemoteIp

    @HealthCheckRemoteIp.setter
    def HealthCheckRemoteIp(self, HealthCheckRemoteIp):
        self._HealthCheckRemoteIp = HealthCheckRemoteIp

    @property
    def RouteType(self):
        """通道类型, 例如:["STATIC", "StaticRoute", "Policy"]
        :rtype: str
        """
        return self._RouteType

    @RouteType.setter
    def RouteType(self, RouteType):
        self._RouteType = RouteType

    @property
    def NegotiationType(self):
        """协商类型，默认为active（主动协商）。可选值：active（主动协商），passive（被动协商），flowTrigger（流量协商）
        :rtype: str
        """
        return self._NegotiationType

    @NegotiationType.setter
    def NegotiationType(self, NegotiationType):
        self._NegotiationType = NegotiationType

    @property
    def DpdEnable(self):
        """DPD探测开关。默认为0，表示关闭DPD探测。可选值：0（关闭），1（开启）
        :rtype: int
        """
        return self._DpdEnable

    @DpdEnable.setter
    def DpdEnable(self, DpdEnable):
        self._DpdEnable = DpdEnable

    @property
    def DpdTimeout(self):
        """DPD超时时间。即探测确认对端不存在需要的时间。dpdEnable为1（开启）时有效。默认30，单位为秒
        :rtype: str
        """
        return self._DpdTimeout

    @DpdTimeout.setter
    def DpdTimeout(self, DpdTimeout):
        self._DpdTimeout = DpdTimeout

    @property
    def DpdAction(self):
        """DPD超时后的动作。默认为clear。dpdEnable为1（开启）时有效。可取值为clear（断开）和restart（重试）
        :rtype: str
        """
        return self._DpdAction

    @DpdAction.setter
    def DpdAction(self, DpdAction):
        self._DpdAction = DpdAction

    @property
    def Route(self):
        """创建通道路由信息。
        :rtype: :class:`tencentcloud.vpc.v20170312.models.CreateVpnConnRoute`
        """
        return self._Route

    @Route.setter
    def Route(self, Route):
        self._Route = Route

    @property
    def BgpConfig(self):
        """BGP配置。
        :rtype: :class:`tencentcloud.vpc.v20170312.models.BgpConfig`
        """
        return self._BgpConfig

    @BgpConfig.setter
    def BgpConfig(self, BgpConfig):
        self._BgpConfig = BgpConfig

    @property
    def HealthCheckConfig(self):
        """健康检查NQA配置。
        :rtype: :class:`tencentcloud.vpc.v20170312.models.HealthCheckConfig`
        """
        return self._HealthCheckConfig

    @HealthCheckConfig.setter
    def HealthCheckConfig(self, HealthCheckConfig):
        self._HealthCheckConfig = HealthCheckConfig


    def _deserialize(self, params):
        self._VpnGatewayId = params.get("VpnGatewayId")
        self._CustomerGatewayId = params.get("CustomerGatewayId")
        self._VpnConnectionName = params.get("VpnConnectionName")
        self._PreShareKey = params.get("PreShareKey")
        self._VpcId = params.get("VpcId")
        if params.get("SecurityPolicyDatabases") is not None:
            self._SecurityPolicyDatabases = []
            for item in params.get("SecurityPolicyDatabases"):
                obj = SecurityPolicyDatabase()
                obj._deserialize(item)
                self._SecurityPolicyDatabases.append(obj)
        if params.get("IKEOptionsSpecification") is not None:
            self._IKEOptionsSpecification = IKEOptionsSpecification()
            self._IKEOptionsSpecification._deserialize(params.get("IKEOptionsSpecification"))
        if params.get("IPSECOptionsSpecification") is not None:
            self._IPSECOptionsSpecification = IPSECOptionsSpecification()
            self._IPSECOptionsSpecification._deserialize(params.get("IPSECOptionsSpecification"))
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._EnableHealthCheck = params.get("EnableHealthCheck")
        self._HealthCheckLocalIp = params.get("HealthCheckLocalIp")
        self._HealthCheckRemoteIp = params.get("HealthCheckRemoteIp")
        self._RouteType = params.get("RouteType")
        self._NegotiationType = params.get("NegotiationType")
        self._DpdEnable = params.get("DpdEnable")
        self._DpdTimeout = params.get("DpdTimeout")
        self._DpdAction = params.get("DpdAction")
        if params.get("Route") is not None:
            self._Route = CreateVpnConnRoute()
            self._Route._deserialize(params.get("Route"))
        if params.get("BgpConfig") is not None:
            self._BgpConfig = BgpConfig()
            self._BgpConfig._deserialize(params.get("BgpConfig"))
        if params.get("HealthCheckConfig") is not None:
            self._HealthCheckConfig = HealthCheckConfig()
            self._HealthCheckConfig._deserialize(params.get("HealthCheckConfig"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVpnConnectionResponse(AbstractModel):
    """CreateVpnConnection返回参数结构体

    """

    def __init__(self):
        r"""
        :param _VpnConnection: 通道实例对象。
        :type VpnConnection: :class:`tencentcloud.vpc.v20170312.models.VpnConnection`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._VpnConnection = None
        self._RequestId = None

    @property
    def VpnConnection(self):
        """通道实例对象。
        :rtype: :class:`tencentcloud.vpc.v20170312.models.VpnConnection`
        """
        return self._VpnConnection

    @VpnConnection.setter
    def VpnConnection(self, VpnConnection):
        self._VpnConnection = VpnConnection

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("VpnConnection") is not None:
            self._VpnConnection = VpnConnection()
            self._VpnConnection._deserialize(params.get("VpnConnection"))
        self._RequestId = params.get("RequestId")


class CreateVpnGatewayRequest(AbstractModel):
    """CreateVpnGateway请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VpcId: VPC实例ID。可通过[DescribeVpcs](https://cloud.tencent.com/document/product/215/15778)接口返回值中的VpcId获取。
        :type VpcId: str
        :param _VpnGatewayName: VPN网关名称，最大长度不能超过60个字节。
        :type VpnGatewayName: str
        :param _InternetMaxBandwidthOut: 公网带宽设置。可选带宽规格：5, 10, 20, 50, 100, 200, 500, 1000, 3000；单位：Mbps。
        :type InternetMaxBandwidthOut: int
        :param _InstanceChargeType: VPN网关计费模式，PREPAID：表示预付费，即包年包月，POSTPAID_BY_HOUR：表示后付费，即按量计费。默认：POSTPAID_BY_HOUR，如果指定预付费模式，参数InstanceChargePrepaid必填。
        :type InstanceChargeType: str
        :param _InstanceChargePrepaid: 预付费模式，即包年包月相关参数设置。通过该参数可以指定包年包月实例的购买时长、是否设置自动续费等属性。若指定实例的付费模式为预付费则该参数必传。
        :type InstanceChargePrepaid: :class:`tencentcloud.vpc.v20170312.models.InstanceChargePrepaid`
        :param _Zone: 可用区，如：ap-guangzhou-2。
        :type Zone: str
        :param _Type: VPN网关类型，默认为IPSEC。值“IPSEC”为VPC型IPSEC VPN网关，值“SSL”为VPC型SSL VPN网关，值“CCN”为云联网型IPSEC VPN网关，值“SSL_CCN”为云联网型SSL VPN网关。
        :type Type: str
        :param _Tags: 指定绑定的标签列表，例如：[{"Key": "city", "Value": "shanghai"}]。
        :type Tags: list of Tag
        :param _CdcId: CDC实例ID。
        :type CdcId: str
        :param _MaxConnection: SSL VPN连接数设置，可选规格：5, 10, 20, 50, 100, 200, 500, 1000；单位：个。仅 SSL / SSL_CCN 类型需要选这个参数。
        :type MaxConnection: int
        """
        self._VpcId = None
        self._VpnGatewayName = None
        self._InternetMaxBandwidthOut = None
        self._InstanceChargeType = None
        self._InstanceChargePrepaid = None
        self._Zone = None
        self._Type = None
        self._Tags = None
        self._CdcId = None
        self._MaxConnection = None

    @property
    def VpcId(self):
        """VPC实例ID。可通过[DescribeVpcs](https://cloud.tencent.com/document/product/215/15778)接口返回值中的VpcId获取。
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def VpnGatewayName(self):
        """VPN网关名称，最大长度不能超过60个字节。
        :rtype: str
        """
        return self._VpnGatewayName

    @VpnGatewayName.setter
    def VpnGatewayName(self, VpnGatewayName):
        self._VpnGatewayName = VpnGatewayName

    @property
    def InternetMaxBandwidthOut(self):
        """公网带宽设置。可选带宽规格：5, 10, 20, 50, 100, 200, 500, 1000, 3000；单位：Mbps。
        :rtype: int
        """
        return self._InternetMaxBandwidthOut

    @InternetMaxBandwidthOut.setter
    def InternetMaxBandwidthOut(self, InternetMaxBandwidthOut):
        self._InternetMaxBandwidthOut = InternetMaxBandwidthOut

    @property
    def InstanceChargeType(self):
        """VPN网关计费模式，PREPAID：表示预付费，即包年包月，POSTPAID_BY_HOUR：表示后付费，即按量计费。默认：POSTPAID_BY_HOUR，如果指定预付费模式，参数InstanceChargePrepaid必填。
        :rtype: str
        """
        return self._InstanceChargeType

    @InstanceChargeType.setter
    def InstanceChargeType(self, InstanceChargeType):
        self._InstanceChargeType = InstanceChargeType

    @property
    def InstanceChargePrepaid(self):
        """预付费模式，即包年包月相关参数设置。通过该参数可以指定包年包月实例的购买时长、是否设置自动续费等属性。若指定实例的付费模式为预付费则该参数必传。
        :rtype: :class:`tencentcloud.vpc.v20170312.models.InstanceChargePrepaid`
        """
        return self._InstanceChargePrepaid

    @InstanceChargePrepaid.setter
    def InstanceChargePrepaid(self, InstanceChargePrepaid):
        self._InstanceChargePrepaid = InstanceChargePrepaid

    @property
    def Zone(self):
        """可用区，如：ap-guangzhou-2。
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def Type(self):
        """VPN网关类型，默认为IPSEC。值“IPSEC”为VPC型IPSEC VPN网关，值“SSL”为VPC型SSL VPN网关，值“CCN”为云联网型IPSEC VPN网关，值“SSL_CCN”为云联网型SSL VPN网关。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Tags(self):
        """指定绑定的标签列表，例如：[{"Key": "city", "Value": "shanghai"}]。
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def CdcId(self):
        """CDC实例ID。
        :rtype: str
        """
        return self._CdcId

    @CdcId.setter
    def CdcId(self, CdcId):
        self._CdcId = CdcId

    @property
    def MaxConnection(self):
        """SSL VPN连接数设置，可选规格：5, 10, 20, 50, 100, 200, 500, 1000；单位：个。仅 SSL / SSL_CCN 类型需要选这个参数。
        :rtype: int
        """
        return self._MaxConnection

    @MaxConnection.setter
    def MaxConnection(self, MaxConnection):
        self._MaxConnection = MaxConnection


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._VpnGatewayName = params.get("VpnGatewayName")
        self._InternetMaxBandwidthOut = params.get("InternetMaxBandwidthOut")
        self._InstanceChargeType = params.get("InstanceChargeType")
        if params.get("InstanceChargePrepaid") is not None:
            self._InstanceChargePrepaid = InstanceChargePrepaid()
            self._InstanceChargePrepaid._deserialize(params.get("InstanceChargePrepaid"))
        self._Zone = params.get("Zone")
        self._Type = params.get("Type")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._CdcId = params.get("CdcId")
        self._MaxConnection = params.get("MaxConnection")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVpnGatewayResponse(AbstractModel):
    """CreateVpnGateway返回参数结构体

    """

    def __init__(self):
        r"""
        :param _VpnGateway: VPN网关对象
        :type VpnGateway: :class:`tencentcloud.vpc.v20170312.models.VpnGateway`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._VpnGateway = None
        self._RequestId = None

    @property
    def VpnGateway(self):
        """VPN网关对象
        :rtype: :class:`tencentcloud.vpc.v20170312.models.VpnGateway`
        """
        return self._VpnGateway

    @VpnGateway.setter
    def VpnGateway(self, VpnGateway):
        self._VpnGateway = VpnGateway

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("VpnGateway") is not None:
            self._VpnGateway = VpnGateway()
            self._VpnGateway._deserialize(params.get("VpnGateway"))
        self._RequestId = params.get("RequestId")


class CreateVpnGatewayRoutesRequest(AbstractModel):
    """CreateVpnGatewayRoutes请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VpnGatewayId: VPN网关的ID
        :type VpnGatewayId: str
        :param _Routes: VPN网关目的路由列表
        :type Routes: list of VpnGatewayRoute
        """
        self._VpnGatewayId = None
        self._Routes = None

    @property
    def VpnGatewayId(self):
        """VPN网关的ID
        :rtype: str
        """
        return self._VpnGatewayId

    @VpnGatewayId.setter
    def VpnGatewayId(self, VpnGatewayId):
        self._VpnGatewayId = VpnGatewayId

    @property
    def Routes(self):
        """VPN网关目的路由列表
        :rtype: list of VpnGatewayRoute
        """
        return self._Routes

    @Routes.setter
    def Routes(self, Routes):
        self._Routes = Routes


    def _deserialize(self, params):
        self._VpnGatewayId = params.get("VpnGatewayId")
        if params.get("Routes") is not None:
            self._Routes = []
            for item in params.get("Routes"):
                obj = VpnGatewayRoute()
                obj._deserialize(item)
                self._Routes.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVpnGatewayRoutesResponse(AbstractModel):
    """CreateVpnGatewayRoutes返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Routes: VPN网关目的路由
        :type Routes: list of VpnGatewayRoute
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Routes = None
        self._RequestId = None

    @property
    def Routes(self):
        """VPN网关目的路由
        :rtype: list of VpnGatewayRoute
        """
        return self._Routes

    @Routes.setter
    def Routes(self, Routes):
        self._Routes = Routes

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Routes") is not None:
            self._Routes = []
            for item in params.get("Routes"):
                obj = VpnGatewayRoute()
                obj._deserialize(item)
                self._Routes.append(obj)
        self._RequestId = params.get("RequestId")


class CreateVpnGatewaySslClientRequest(AbstractModel):
    """CreateVpnGatewaySslClient请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SslVpnServerId: SSL-VPN-SERVER 实例ID。
        :type SslVpnServerId: str
        :param _SslVpnClientName: SSL-VPN-CLIENT实例Name。不可和SslVpnClientNames同时使用。
        :type SslVpnClientName: str
        :param _SslVpnClientNames: SSL-VPN-CLIENT实例Name数字。批量创建时使用。不可和SslVpnClientName同时使用。
        :type SslVpnClientNames: list of str
        :param _Tags: 指定绑定的标签列表
        :type Tags: list of Tag
        """
        self._SslVpnServerId = None
        self._SslVpnClientName = None
        self._SslVpnClientNames = None
        self._Tags = None

    @property
    def SslVpnServerId(self):
        """SSL-VPN-SERVER 实例ID。
        :rtype: str
        """
        return self._SslVpnServerId

    @SslVpnServerId.setter
    def SslVpnServerId(self, SslVpnServerId):
        self._SslVpnServerId = SslVpnServerId

    @property
    def SslVpnClientName(self):
        """SSL-VPN-CLIENT实例Name。不可和SslVpnClientNames同时使用。
        :rtype: str
        """
        return self._SslVpnClientName

    @SslVpnClientName.setter
    def SslVpnClientName(self, SslVpnClientName):
        self._SslVpnClientName = SslVpnClientName

    @property
    def SslVpnClientNames(self):
        """SSL-VPN-CLIENT实例Name数字。批量创建时使用。不可和SslVpnClientName同时使用。
        :rtype: list of str
        """
        return self._SslVpnClientNames

    @SslVpnClientNames.setter
    def SslVpnClientNames(self, SslVpnClientNames):
        self._SslVpnClientNames = SslVpnClientNames

    @property
    def Tags(self):
        """指定绑定的标签列表
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._SslVpnServerId = params.get("SslVpnServerId")
        self._SslVpnClientName = params.get("SslVpnClientName")
        self._SslVpnClientNames = params.get("SslVpnClientNames")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVpnGatewaySslClientResponse(AbstractModel):
    """CreateVpnGatewaySslClient返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 异步任务ID。
        :type TaskId: int
        :param _SslVpnClientId: SSL-VPN client 唯一ID
        :type SslVpnClientId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._SslVpnClientId = None
        self._RequestId = None

    @property
    def TaskId(self):
        """异步任务ID。
        :rtype: int
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def SslVpnClientId(self):
        """SSL-VPN client 唯一ID
        :rtype: str
        """
        return self._SslVpnClientId

    @SslVpnClientId.setter
    def SslVpnClientId(self, SslVpnClientId):
        self._SslVpnClientId = SslVpnClientId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._SslVpnClientId = params.get("SslVpnClientId")
        self._RequestId = params.get("RequestId")


class CreateVpnGatewaySslServerRequest(AbstractModel):
    """CreateVpnGatewaySslServer请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VpnGatewayId: VPN网关实例ID。
        :type VpnGatewayId: str
        :param _SslVpnServerName: SSL-VPN-SERVER 实例名称，长度不超过60个字节。
        :type SslVpnServerName: str
        :param _RemoteAddress: 客户端地址网段。
        :type RemoteAddress: str
        :param _LocalAddress: 云端地址（CIDR）列表。
        :type LocalAddress: list of str
        :param _SslVpnProtocol: SSL VPN服务端监听协议。当前仅支持 UDP，默认UDP。
        :type SslVpnProtocol: str
        :param _SslVpnPort: SSL VPN服务端监听协议端口，默认1194。
        :type SslVpnPort: int
        :param _IntegrityAlgorithm: 认证算法。可选 'SHA1', 'MD5', 'NONE'，默认NONE。
        :type IntegrityAlgorithm: str
        :param _EncryptAlgorithm: 加密算法。可选 'AES-128-CBC','AES-192-CBC', 'AES-256-CBC', 'NONE'，默认NONE。
        :type EncryptAlgorithm: str
        :param _Compress: 是否支持压缩。当前不支持压缩，默认False。
        :type Compress: bool
        :param _SsoEnabled: 是否开启SSO认证。默认为False。该功能当前需要申请开白使用。
        :type SsoEnabled: bool
        :param _AccessPolicyEnabled: 是否开启策略访问控制。默认为False
        :type AccessPolicyEnabled: bool
        :param _SamlData: SAML-DATA，开启SSO时传。
        :type SamlData: str
        :param _Tags: 指定绑定的标签列表
        :type Tags: list of Tag
        """
        self._VpnGatewayId = None
        self._SslVpnServerName = None
        self._RemoteAddress = None
        self._LocalAddress = None
        self._SslVpnProtocol = None
        self._SslVpnPort = None
        self._IntegrityAlgorithm = None
        self._EncryptAlgorithm = None
        self._Compress = None
        self._SsoEnabled = None
        self._AccessPolicyEnabled = None
        self._SamlData = None
        self._Tags = None

    @property
    def VpnGatewayId(self):
        """VPN网关实例ID。
        :rtype: str
        """
        return self._VpnGatewayId

    @VpnGatewayId.setter
    def VpnGatewayId(self, VpnGatewayId):
        self._VpnGatewayId = VpnGatewayId

    @property
    def SslVpnServerName(self):
        """SSL-VPN-SERVER 实例名称，长度不超过60个字节。
        :rtype: str
        """
        return self._SslVpnServerName

    @SslVpnServerName.setter
    def SslVpnServerName(self, SslVpnServerName):
        self._SslVpnServerName = SslVpnServerName

    @property
    def RemoteAddress(self):
        """客户端地址网段。
        :rtype: str
        """
        return self._RemoteAddress

    @RemoteAddress.setter
    def RemoteAddress(self, RemoteAddress):
        self._RemoteAddress = RemoteAddress

    @property
    def LocalAddress(self):
        """云端地址（CIDR）列表。
        :rtype: list of str
        """
        return self._LocalAddress

    @LocalAddress.setter
    def LocalAddress(self, LocalAddress):
        self._LocalAddress = LocalAddress

    @property
    def SslVpnProtocol(self):
        """SSL VPN服务端监听协议。当前仅支持 UDP，默认UDP。
        :rtype: str
        """
        return self._SslVpnProtocol

    @SslVpnProtocol.setter
    def SslVpnProtocol(self, SslVpnProtocol):
        self._SslVpnProtocol = SslVpnProtocol

    @property
    def SslVpnPort(self):
        """SSL VPN服务端监听协议端口，默认1194。
        :rtype: int
        """
        return self._SslVpnPort

    @SslVpnPort.setter
    def SslVpnPort(self, SslVpnPort):
        self._SslVpnPort = SslVpnPort

    @property
    def IntegrityAlgorithm(self):
        """认证算法。可选 'SHA1', 'MD5', 'NONE'，默认NONE。
        :rtype: str
        """
        return self._IntegrityAlgorithm

    @IntegrityAlgorithm.setter
    def IntegrityAlgorithm(self, IntegrityAlgorithm):
        self._IntegrityAlgorithm = IntegrityAlgorithm

    @property
    def EncryptAlgorithm(self):
        """加密算法。可选 'AES-128-CBC','AES-192-CBC', 'AES-256-CBC', 'NONE'，默认NONE。
        :rtype: str
        """
        return self._EncryptAlgorithm

    @EncryptAlgorithm.setter
    def EncryptAlgorithm(self, EncryptAlgorithm):
        self._EncryptAlgorithm = EncryptAlgorithm

    @property
    def Compress(self):
        """是否支持压缩。当前不支持压缩，默认False。
        :rtype: bool
        """
        return self._Compress

    @Compress.setter
    def Compress(self, Compress):
        self._Compress = Compress

    @property
    def SsoEnabled(self):
        """是否开启SSO认证。默认为False。该功能当前需要申请开白使用。
        :rtype: bool
        """
        return self._SsoEnabled

    @SsoEnabled.setter
    def SsoEnabled(self, SsoEnabled):
        self._SsoEnabled = SsoEnabled

    @property
    def AccessPolicyEnabled(self):
        """是否开启策略访问控制。默认为False
        :rtype: bool
        """
        return self._AccessPolicyEnabled

    @AccessPolicyEnabled.setter
    def AccessPolicyEnabled(self, AccessPolicyEnabled):
        self._AccessPolicyEnabled = AccessPolicyEnabled

    @property
    def SamlData(self):
        """SAML-DATA，开启SSO时传。
        :rtype: str
        """
        return self._SamlData

    @SamlData.setter
    def SamlData(self, SamlData):
        self._SamlData = SamlData

    @property
    def Tags(self):
        """指定绑定的标签列表
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._VpnGatewayId = params.get("VpnGatewayId")
        self._SslVpnServerName = params.get("SslVpnServerName")
        self._RemoteAddress = params.get("RemoteAddress")
        self._LocalAddress = params.get("LocalAddress")
        self._SslVpnProtocol = params.get("SslVpnProtocol")
        self._SslVpnPort = params.get("SslVpnPort")
        self._IntegrityAlgorithm = params.get("IntegrityAlgorithm")
        self._EncryptAlgorithm = params.get("EncryptAlgorithm")
        self._Compress = params.get("Compress")
        self._SsoEnabled = params.get("SsoEnabled")
        self._AccessPolicyEnabled = params.get("AccessPolicyEnabled")
        self._SamlData = params.get("SamlData")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVpnGatewaySslServerResponse(AbstractModel):
    """CreateVpnGatewaySslServer返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 创建SSL-VPN server 异步任务ID。
        :type TaskId: int
        :param _SslVpnServerId: SSL-VPN-SERVER 唯一ID。
        :type SslVpnServerId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._SslVpnServerId = None
        self._RequestId = None

    @property
    def TaskId(self):
        """创建SSL-VPN server 异步任务ID。
        :rtype: int
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def SslVpnServerId(self):
        """SSL-VPN-SERVER 唯一ID。
        :rtype: str
        """
        return self._SslVpnServerId

    @SslVpnServerId.setter
    def SslVpnServerId(self, SslVpnServerId):
        self._SslVpnServerId = SslVpnServerId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._SslVpnServerId = params.get("SslVpnServerId")
        self._RequestId = params.get("RequestId")


class CrossBorderCompliance(AbstractModel):
    """合规化审批单

    """

    def __init__(self):
        r"""
        :param _ServiceProvider: 服务商，可选值：`UNICOM`。
        :type ServiceProvider: str
        :param _ComplianceId: 合规化审批单`ID`。
        :type ComplianceId: int
        :param _Company: 公司全称。
        :type Company: str
        :param _UniformSocialCreditCode: 统一社会信用代码。
        :type UniformSocialCreditCode: str
        :param _LegalPerson: 法定代表人。
        :type LegalPerson: str
        :param _IssuingAuthority: 发证机关。
        :type IssuingAuthority: str
        :param _BusinessLicense: 营业执照。
        :type BusinessLicense: str
        :param _BusinessAddress: 营业执照住所。
        :type BusinessAddress: str
        :param _PostCode: 邮编。
        :type PostCode: int
        :param _Manager: 经办人。
        :type Manager: str
        :param _ManagerId: 经办人身份证号。
        :type ManagerId: str
        :param _ManagerIdCard: 经办人身份证。
        :type ManagerIdCard: str
        :param _ManagerAddress: 经办人身份证地址。
        :type ManagerAddress: str
        :param _ManagerTelephone: 经办人联系电话。
        :type ManagerTelephone: str
        :param _Email: 电子邮箱。
        :type Email: str
        :param _ServiceHandlingForm: 服务受理单。
        :type ServiceHandlingForm: str
        :param _AuthorizationLetter: 授权函。
        :type AuthorizationLetter: str
        :param _SafetyCommitment: 信息安全承诺书。
        :type SafetyCommitment: str
        :param _ServiceStartDate: 服务开始时间。
        :type ServiceStartDate: str
        :param _ServiceEndDate: 服务截止时间。
        :type ServiceEndDate: str
        :param _State: 状态。待审批：`PENDING`，已通过：`APPROVED`，已拒绝：`DENY`。
        :type State: str
        :param _CreatedTime: 审批单创建时间。
        :type CreatedTime: str
        :param _LegalPersonId: 法定代表人身份证号。
注意：此字段可能返回 null，表示取不到有效值。
        :type LegalPersonId: str
        :param _LegalPersonIdCard: 法定代表人身份证。
注意：此字段可能返回 null，表示取不到有效值。
        :type LegalPersonIdCard: str
        """
        self._ServiceProvider = None
        self._ComplianceId = None
        self._Company = None
        self._UniformSocialCreditCode = None
        self._LegalPerson = None
        self._IssuingAuthority = None
        self._BusinessLicense = None
        self._BusinessAddress = None
        self._PostCode = None
        self._Manager = None
        self._ManagerId = None
        self._ManagerIdCard = None
        self._ManagerAddress = None
        self._ManagerTelephone = None
        self._Email = None
        self._ServiceHandlingForm = None
        self._AuthorizationLetter = None
        self._SafetyCommitment = None
        self._ServiceStartDate = None
        self._ServiceEndDate = None
        self._State = None
        self._CreatedTime = None
        self._LegalPersonId = None
        self._LegalPersonIdCard = None

    @property
    def ServiceProvider(self):
        """服务商，可选值：`UNICOM`。
        :rtype: str
        """
        return self._ServiceProvider

    @ServiceProvider.setter
    def ServiceProvider(self, ServiceProvider):
        self._ServiceProvider = ServiceProvider

    @property
    def ComplianceId(self):
        """合规化审批单`ID`。
        :rtype: int
        """
        return self._ComplianceId

    @ComplianceId.setter
    def ComplianceId(self, ComplianceId):
        self._ComplianceId = ComplianceId

    @property
    def Company(self):
        """公司全称。
        :rtype: str
        """
        return self._Company

    @Company.setter
    def Company(self, Company):
        self._Company = Company

    @property
    def UniformSocialCreditCode(self):
        """统一社会信用代码。
        :rtype: str
        """
        return self._UniformSocialCreditCode

    @UniformSocialCreditCode.setter
    def UniformSocialCreditCode(self, UniformSocialCreditCode):
        self._UniformSocialCreditCode = UniformSocialCreditCode

    @property
    def LegalPerson(self):
        """法定代表人。
        :rtype: str
        """
        return self._LegalPerson

    @LegalPerson.setter
    def LegalPerson(self, LegalPerson):
        self._LegalPerson = LegalPerson

    @property
    def IssuingAuthority(self):
        """发证机关。
        :rtype: str
        """
        return self._IssuingAuthority

    @IssuingAuthority.setter
    def IssuingAuthority(self, IssuingAuthority):
        self._IssuingAuthority = IssuingAuthority

    @property
    def BusinessLicense(self):
        """营业执照。
        :rtype: str
        """
        return self._BusinessLicense

    @BusinessLicense.setter
    def BusinessLicense(self, BusinessLicense):
        self._BusinessLicense = BusinessLicense

    @property
    def BusinessAddress(self):
        """营业执照住所。
        :rtype: str
        """
        return self._BusinessAddress

    @BusinessAddress.setter
    def BusinessAddress(self, BusinessAddress):
        self._BusinessAddress = BusinessAddress

    @property
    def PostCode(self):
        """邮编。
        :rtype: int
        """
        return self._PostCode

    @PostCode.setter
    def PostCode(self, PostCode):
        self._PostCode = PostCode

    @property
    def Manager(self):
        """经办人。
        :rtype: str
        """
        return self._Manager

    @Manager.setter
    def Manager(self, Manager):
        self._Manager = Manager

    @property
    def ManagerId(self):
        """经办人身份证号。
        :rtype: str
        """
        return self._ManagerId

    @ManagerId.setter
    def ManagerId(self, ManagerId):
        self._ManagerId = ManagerId

    @property
    def ManagerIdCard(self):
        """经办人身份证。
        :rtype: str
        """
        return self._ManagerIdCard

    @ManagerIdCard.setter
    def ManagerIdCard(self, ManagerIdCard):
        self._ManagerIdCard = ManagerIdCard

    @property
    def ManagerAddress(self):
        """经办人身份证地址。
        :rtype: str
        """
        return self._ManagerAddress

    @ManagerAddress.setter
    def ManagerAddress(self, ManagerAddress):
        self._ManagerAddress = ManagerAddress

    @property
    def ManagerTelephone(self):
        """经办人联系电话。
        :rtype: str
        """
        return self._ManagerTelephone

    @ManagerTelephone.setter
    def ManagerTelephone(self, ManagerTelephone):
        self._ManagerTelephone = ManagerTelephone

    @property
    def Email(self):
        """电子邮箱。
        :rtype: str
        """
        return self._Email

    @Email.setter
    def Email(self, Email):
        self._Email = Email

    @property
    def ServiceHandlingForm(self):
        """服务受理单。
        :rtype: str
        """
        return self._ServiceHandlingForm

    @ServiceHandlingForm.setter
    def ServiceHandlingForm(self, ServiceHandlingForm):
        self._ServiceHandlingForm = ServiceHandlingForm

    @property
    def AuthorizationLetter(self):
        """授权函。
        :rtype: str
        """
        return self._AuthorizationLetter

    @AuthorizationLetter.setter
    def AuthorizationLetter(self, AuthorizationLetter):
        self._AuthorizationLetter = AuthorizationLetter

    @property
    def SafetyCommitment(self):
        """信息安全承诺书。
        :rtype: str
        """
        return self._SafetyCommitment

    @SafetyCommitment.setter
    def SafetyCommitment(self, SafetyCommitment):
        self._SafetyCommitment = SafetyCommitment

    @property
    def ServiceStartDate(self):
        """服务开始时间。
        :rtype: str
        """
        return self._ServiceStartDate

    @ServiceStartDate.setter
    def ServiceStartDate(self, ServiceStartDate):
        self._ServiceStartDate = ServiceStartDate

    @property
    def ServiceEndDate(self):
        """服务截止时间。
        :rtype: str
        """
        return self._ServiceEndDate

    @ServiceEndDate.setter
    def ServiceEndDate(self, ServiceEndDate):
        self._ServiceEndDate = ServiceEndDate

    @property
    def State(self):
        """状态。待审批：`PENDING`，已通过：`APPROVED`，已拒绝：`DENY`。
        :rtype: str
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def CreatedTime(self):
        """审批单创建时间。
        :rtype: str
        """
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime

    @property
    def LegalPersonId(self):
        """法定代表人身份证号。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._LegalPersonId

    @LegalPersonId.setter
    def LegalPersonId(self, LegalPersonId):
        self._LegalPersonId = LegalPersonId

    @property
    def LegalPersonIdCard(self):
        """法定代表人身份证。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._LegalPersonIdCard

    @LegalPersonIdCard.setter
    def LegalPersonIdCard(self, LegalPersonIdCard):
        self._LegalPersonIdCard = LegalPersonIdCard


    def _deserialize(self, params):
        self._ServiceProvider = params.get("ServiceProvider")
        self._ComplianceId = params.get("ComplianceId")
        self._Company = params.get("Company")
        self._UniformSocialCreditCode = params.get("UniformSocialCreditCode")
        self._LegalPerson = params.get("LegalPerson")
        self._IssuingAuthority = params.get("IssuingAuthority")
        self._BusinessLicense = params.get("BusinessLicense")
        self._BusinessAddress = params.get("BusinessAddress")
        self._PostCode = params.get("PostCode")
        self._Manager = params.get("Manager")
        self._ManagerId = params.get("ManagerId")
        self._ManagerIdCard = params.get("ManagerIdCard")
        self._ManagerAddress = params.get("ManagerAddress")
        self._ManagerTelephone = params.get("ManagerTelephone")
        self._Email = params.get("Email")
        self._ServiceHandlingForm = params.get("ServiceHandlingForm")
        self._AuthorizationLetter = params.get("AuthorizationLetter")
        self._SafetyCommitment = params.get("SafetyCommitment")
        self._ServiceStartDate = params.get("ServiceStartDate")
        self._ServiceEndDate = params.get("ServiceEndDate")
        self._State = params.get("State")
        self._CreatedTime = params.get("CreatedTime")
        self._LegalPersonId = params.get("LegalPersonId")
        self._LegalPersonIdCard = params.get("LegalPersonIdCard")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CrossBorderFlowMonitorData(AbstractModel):
    """跨境带宽监控数据

    """

    def __init__(self):
        r"""
        :param _InBandwidth: 入带宽，单位：`bps`。
        :type InBandwidth: list of int
        :param _OutBandwidth: 出带宽，单位：`bps`。
        :type OutBandwidth: list of int
        :param _InPkg: 入包，单位：`pps`。
        :type InPkg: list of int
        :param _OutPkg: 出包，单位：`pps`。
        :type OutPkg: list of int
        """
        self._InBandwidth = None
        self._OutBandwidth = None
        self._InPkg = None
        self._OutPkg = None

    @property
    def InBandwidth(self):
        """入带宽，单位：`bps`。
        :rtype: list of int
        """
        return self._InBandwidth

    @InBandwidth.setter
    def InBandwidth(self, InBandwidth):
        self._InBandwidth = InBandwidth

    @property
    def OutBandwidth(self):
        """出带宽，单位：`bps`。
        :rtype: list of int
        """
        return self._OutBandwidth

    @OutBandwidth.setter
    def OutBandwidth(self, OutBandwidth):
        self._OutBandwidth = OutBandwidth

    @property
    def InPkg(self):
        """入包，单位：`pps`。
        :rtype: list of int
        """
        return self._InPkg

    @InPkg.setter
    def InPkg(self, InPkg):
        self._InPkg = InPkg

    @property
    def OutPkg(self):
        """出包，单位：`pps`。
        :rtype: list of int
        """
        return self._OutPkg

    @OutPkg.setter
    def OutPkg(self, OutPkg):
        self._OutPkg = OutPkg


    def _deserialize(self, params):
        self._InBandwidth = params.get("InBandwidth")
        self._OutBandwidth = params.get("OutBandwidth")
        self._InPkg = params.get("InPkg")
        self._OutPkg = params.get("OutPkg")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CustomerGateway(AbstractModel):
    """对端网关

    """

    def __init__(self):
        r"""
        :param _CustomerGatewayId: 用户网关唯一ID
        :type CustomerGatewayId: str
        :param _CustomerGatewayName: 网关名称
        :type CustomerGatewayName: str
        :param _IpAddress: 公网地址
        :type IpAddress: str
        :param _CreatedTime: 创建时间
        :type CreatedTime: str
        :param _BgpAsn: BGP ASN。
        :type BgpAsn: int
        """
        self._CustomerGatewayId = None
        self._CustomerGatewayName = None
        self._IpAddress = None
        self._CreatedTime = None
        self._BgpAsn = None

    @property
    def CustomerGatewayId(self):
        """用户网关唯一ID
        :rtype: str
        """
        return self._CustomerGatewayId

    @CustomerGatewayId.setter
    def CustomerGatewayId(self, CustomerGatewayId):
        self._CustomerGatewayId = CustomerGatewayId

    @property
    def CustomerGatewayName(self):
        """网关名称
        :rtype: str
        """
        return self._CustomerGatewayName

    @CustomerGatewayName.setter
    def CustomerGatewayName(self, CustomerGatewayName):
        self._CustomerGatewayName = CustomerGatewayName

    @property
    def IpAddress(self):
        """公网地址
        :rtype: str
        """
        return self._IpAddress

    @IpAddress.setter
    def IpAddress(self, IpAddress):
        self._IpAddress = IpAddress

    @property
    def CreatedTime(self):
        """创建时间
        :rtype: str
        """
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime

    @property
    def BgpAsn(self):
        """BGP ASN。
        :rtype: int
        """
        return self._BgpAsn

    @BgpAsn.setter
    def BgpAsn(self, BgpAsn):
        self._BgpAsn = BgpAsn


    def _deserialize(self, params):
        self._CustomerGatewayId = params.get("CustomerGatewayId")
        self._CustomerGatewayName = params.get("CustomerGatewayName")
        self._IpAddress = params.get("IpAddress")
        self._CreatedTime = params.get("CreatedTime")
        self._BgpAsn = params.get("BgpAsn")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CustomerGatewayVendor(AbstractModel):
    """对端网关厂商信息对象。

    """

    def __init__(self):
        r"""
        :param _Platform: 平台。
        :type Platform: str
        :param _SoftwareVersion: 软件版本。
        :type SoftwareVersion: str
        :param _VendorName: 供应商名称。
        :type VendorName: str
        """
        self._Platform = None
        self._SoftwareVersion = None
        self._VendorName = None

    @property
    def Platform(self):
        """平台。
        :rtype: str
        """
        return self._Platform

    @Platform.setter
    def Platform(self, Platform):
        self._Platform = Platform

    @property
    def SoftwareVersion(self):
        """软件版本。
        :rtype: str
        """
        return self._SoftwareVersion

    @SoftwareVersion.setter
    def SoftwareVersion(self, SoftwareVersion):
        self._SoftwareVersion = SoftwareVersion

    @property
    def VendorName(self):
        """供应商名称。
        :rtype: str
        """
        return self._VendorName

    @VendorName.setter
    def VendorName(self, VendorName):
        self._VendorName = VendorName


    def _deserialize(self, params):
        self._Platform = params.get("Platform")
        self._SoftwareVersion = params.get("SoftwareVersion")
        self._VendorName = params.get("VendorName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CvmInstance(AbstractModel):
    """云主机实例信息。

    """

    def __init__(self):
        r"""
        :param _VpcId: VPC实例ID。
        :type VpcId: str
        :param _SubnetId: 子网实例ID。
        :type SubnetId: str
        :param _InstanceId: 云主机实例ID
        :type InstanceId: str
        :param _InstanceName: 云主机名称。
        :type InstanceName: str
        :param _InstanceState: 云主机状态。
        :type InstanceState: str
        :param _CPU: 实例的CPU核数，单位：核。
        :type CPU: int
        :param _Memory: 实例内存容量，单位：GB。
        :type Memory: int
        :param _CreatedTime: 创建时间。
        :type CreatedTime: str
        :param _InstanceType: 实例机型。
        :type InstanceType: str
        :param _EniLimit: 实例弹性网卡配额（包含主网卡）。
        :type EniLimit: int
        :param _EniIpLimit: 实例弹性网卡内网IP配额（包含主网卡）。
        :type EniIpLimit: int
        :param _InstanceEniCount: 实例已绑定弹性网卡的个数（包含主网卡）。
        :type InstanceEniCount: int
        """
        self._VpcId = None
        self._SubnetId = None
        self._InstanceId = None
        self._InstanceName = None
        self._InstanceState = None
        self._CPU = None
        self._Memory = None
        self._CreatedTime = None
        self._InstanceType = None
        self._EniLimit = None
        self._EniIpLimit = None
        self._InstanceEniCount = None

    @property
    def VpcId(self):
        """VPC实例ID。
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        """子网实例ID。
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def InstanceId(self):
        """云主机实例ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def InstanceName(self):
        """云主机名称。
        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def InstanceState(self):
        """云主机状态。
        :rtype: str
        """
        return self._InstanceState

    @InstanceState.setter
    def InstanceState(self, InstanceState):
        self._InstanceState = InstanceState

    @property
    def CPU(self):
        """实例的CPU核数，单位：核。
        :rtype: int
        """
        return self._CPU

    @CPU.setter
    def CPU(self, CPU):
        self._CPU = CPU

    @property
    def Memory(self):
        """实例内存容量，单位：GB。
        :rtype: int
        """
        return self._Memory

    @Memory.setter
    def Memory(self, Memory):
        self._Memory = Memory

    @property
    def CreatedTime(self):
        """创建时间。
        :rtype: str
        """
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime

    @property
    def InstanceType(self):
        """实例机型。
        :rtype: str
        """
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def EniLimit(self):
        """实例弹性网卡配额（包含主网卡）。
        :rtype: int
        """
        return self._EniLimit

    @EniLimit.setter
    def EniLimit(self, EniLimit):
        self._EniLimit = EniLimit

    @property
    def EniIpLimit(self):
        """实例弹性网卡内网IP配额（包含主网卡）。
        :rtype: int
        """
        return self._EniIpLimit

    @EniIpLimit.setter
    def EniIpLimit(self, EniIpLimit):
        self._EniIpLimit = EniIpLimit

    @property
    def InstanceEniCount(self):
        """实例已绑定弹性网卡的个数（包含主网卡）。
        :rtype: int
        """
        return self._InstanceEniCount

    @InstanceEniCount.setter
    def InstanceEniCount(self, InstanceEniCount):
        self._InstanceEniCount = InstanceEniCount


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._InstanceId = params.get("InstanceId")
        self._InstanceName = params.get("InstanceName")
        self._InstanceState = params.get("InstanceState")
        self._CPU = params.get("CPU")
        self._Memory = params.get("Memory")
        self._CreatedTime = params.get("CreatedTime")
        self._InstanceType = params.get("InstanceType")
        self._EniLimit = params.get("EniLimit")
        self._EniIpLimit = params.get("EniIpLimit")
        self._InstanceEniCount = params.get("InstanceEniCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DefaultVpcSubnet(AbstractModel):
    """默认VPC和子网

    """

    def __init__(self):
        r"""
        :param _VpcId: 默认VpcId。
        :type VpcId: str
        :param _SubnetId: 默认SubnetId。
        :type SubnetId: str
        :param _VpcName: 默认Vpc名字。
        :type VpcName: str
        :param _SubnetName: 默认Subnet名字。
        :type SubnetName: str
        :param _CidrBlock: 默认子网网段。
        :type CidrBlock: str
        """
        self._VpcId = None
        self._SubnetId = None
        self._VpcName = None
        self._SubnetName = None
        self._CidrBlock = None

    @property
    def VpcId(self):
        """默认VpcId。
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        """默认SubnetId。
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def VpcName(self):
        """默认Vpc名字。
        :rtype: str
        """
        return self._VpcName

    @VpcName.setter
    def VpcName(self, VpcName):
        self._VpcName = VpcName

    @property
    def SubnetName(self):
        """默认Subnet名字。
        :rtype: str
        """
        return self._SubnetName

    @SubnetName.setter
    def SubnetName(self, SubnetName):
        self._SubnetName = SubnetName

    @property
    def CidrBlock(self):
        """默认子网网段。
        :rtype: str
        """
        return self._CidrBlock

    @CidrBlock.setter
    def CidrBlock(self, CidrBlock):
        self._CidrBlock = CidrBlock


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._VpcName = params.get("VpcName")
        self._SubnetName = params.get("SubnetName")
        self._CidrBlock = params.get("CidrBlock")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAddressTemplateGroupRequest(AbstractModel):
    """DeleteAddressTemplateGroup请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AddressTemplateGroupId: IP地址模板集合实例ID，例如：ipmg-90cex8mq。
        :type AddressTemplateGroupId: str
        """
        self._AddressTemplateGroupId = None

    @property
    def AddressTemplateGroupId(self):
        """IP地址模板集合实例ID，例如：ipmg-90cex8mq。
        :rtype: str
        """
        return self._AddressTemplateGroupId

    @AddressTemplateGroupId.setter
    def AddressTemplateGroupId(self, AddressTemplateGroupId):
        self._AddressTemplateGroupId = AddressTemplateGroupId


    def _deserialize(self, params):
        self._AddressTemplateGroupId = params.get("AddressTemplateGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAddressTemplateGroupResponse(AbstractModel):
    """DeleteAddressTemplateGroup返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteAddressTemplateRequest(AbstractModel):
    """DeleteAddressTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AddressTemplateId: IP地址模板实例ID，例如：ipm-09o5m8kc。
        :type AddressTemplateId: str
        """
        self._AddressTemplateId = None

    @property
    def AddressTemplateId(self):
        """IP地址模板实例ID，例如：ipm-09o5m8kc。
        :rtype: str
        """
        return self._AddressTemplateId

    @AddressTemplateId.setter
    def AddressTemplateId(self, AddressTemplateId):
        self._AddressTemplateId = AddressTemplateId


    def _deserialize(self, params):
        self._AddressTemplateId = params.get("AddressTemplateId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAddressTemplateResponse(AbstractModel):
    """DeleteAddressTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteAssistantCidrRequest(AbstractModel):
    """DeleteAssistantCidr请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VpcId: `VPC`实例`ID`。形如：`vpc-6v2ht8q5`。
        :type VpcId: str
        :param _CidrBlocks: CIDR数组，格式如["10.0.0.0/16", "172.16.0.0/16"]。
        :type CidrBlocks: list of str
        """
        self._VpcId = None
        self._CidrBlocks = None

    @property
    def VpcId(self):
        """`VPC`实例`ID`。形如：`vpc-6v2ht8q5`。
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def CidrBlocks(self):
        """CIDR数组，格式如["10.0.0.0/16", "172.16.0.0/16"]。
        :rtype: list of str
        """
        return self._CidrBlocks

    @CidrBlocks.setter
    def CidrBlocks(self, CidrBlocks):
        self._CidrBlocks = CidrBlocks


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._CidrBlocks = params.get("CidrBlocks")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAssistantCidrResponse(AbstractModel):
    """DeleteAssistantCidr返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteBandwidthPackageRequest(AbstractModel):
    """DeleteBandwidthPackage请求参数结构体

    """

    def __init__(self):
        r"""
        :param _BandwidthPackageId: 待删除带宽包唯一ID
        :type BandwidthPackageId: str
        """
        self._BandwidthPackageId = None

    @property
    def BandwidthPackageId(self):
        """待删除带宽包唯一ID
        :rtype: str
        """
        return self._BandwidthPackageId

    @BandwidthPackageId.setter
    def BandwidthPackageId(self, BandwidthPackageId):
        self._BandwidthPackageId = BandwidthPackageId


    def _deserialize(self, params):
        self._BandwidthPackageId = params.get("BandwidthPackageId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteBandwidthPackageResponse(AbstractModel):
    """DeleteBandwidthPackage返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteCcnRequest(AbstractModel):
    """DeleteCcn请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CcnId: CCN实例ID。形如：ccn-f49l6u0z。
        :type CcnId: str
        """
        self._CcnId = None

    @property
    def CcnId(self):
        """CCN实例ID。形如：ccn-f49l6u0z。
        :rtype: str
        """
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId


    def _deserialize(self, params):
        self._CcnId = params.get("CcnId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCcnResponse(AbstractModel):
    """DeleteCcn返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteCcnRouteTablesRequest(AbstractModel):
    """DeleteCcnRouteTables请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RouteTableId: 需要删除的路由表列表。
        :type RouteTableId: list of str
        """
        self._RouteTableId = None

    @property
    def RouteTableId(self):
        """需要删除的路由表列表。
        :rtype: list of str
        """
        return self._RouteTableId

    @RouteTableId.setter
    def RouteTableId(self, RouteTableId):
        self._RouteTableId = RouteTableId


    def _deserialize(self, params):
        self._RouteTableId = params.get("RouteTableId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCcnRouteTablesResponse(AbstractModel):
    """DeleteCcnRouteTables返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteCdcLDCXListRequest(AbstractModel):
    """DeleteCdcLDCXList请求参数结构体

    """


class DeleteCdcLDCXListResponse(AbstractModel):
    """DeleteCdcLDCXList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteCdcNetPlanesRequest(AbstractModel):
    """DeleteCdcNetPlanes请求参数结构体

    """


class DeleteCdcNetPlanesResponse(AbstractModel):
    """DeleteCdcNetPlanes返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteCustomerGatewayRequest(AbstractModel):
    """DeleteCustomerGateway请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CustomerGatewayId: 对端网关ID，例如：cgw-2wqq41m9，可通过[DescribeCustomerGateways](https://cloud.tencent.com/document/api/215/17516)接口查询对端网关。
        :type CustomerGatewayId: str
        """
        self._CustomerGatewayId = None

    @property
    def CustomerGatewayId(self):
        """对端网关ID，例如：cgw-2wqq41m9，可通过[DescribeCustomerGateways](https://cloud.tencent.com/document/api/215/17516)接口查询对端网关。
        :rtype: str
        """
        return self._CustomerGatewayId

    @CustomerGatewayId.setter
    def CustomerGatewayId(self, CustomerGatewayId):
        self._CustomerGatewayId = CustomerGatewayId


    def _deserialize(self, params):
        self._CustomerGatewayId = params.get("CustomerGatewayId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCustomerGatewayResponse(AbstractModel):
    """DeleteCustomerGateway返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteDhcpIpRequest(AbstractModel):
    """DeleteDhcpIp请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DhcpIpId: `DhcpIp`的`ID`，是`DhcpIp`的唯一标识。
        :type DhcpIpId: str
        """
        self._DhcpIpId = None

    @property
    def DhcpIpId(self):
        """`DhcpIp`的`ID`，是`DhcpIp`的唯一标识。
        :rtype: str
        """
        return self._DhcpIpId

    @DhcpIpId.setter
    def DhcpIpId(self, DhcpIpId):
        self._DhcpIpId = DhcpIpId


    def _deserialize(self, params):
        self._DhcpIpId = params.get("DhcpIpId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteDhcpIpResponse(AbstractModel):
    """DeleteDhcpIp返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteDirectConnectGatewayCcnRoutesRequest(AbstractModel):
    """DeleteDirectConnectGatewayCcnRoutes请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DirectConnectGatewayId: 专线网关ID，形如：dcg-prpqlmg1
        :type DirectConnectGatewayId: str
        :param _RouteIds: 路由ID。形如：ccnr-f49l6u0z。
        :type RouteIds: list of str
        :param _AddressType: 地址类型，支持：IPv4、IPv6。默认IPv4。
        :type AddressType: str
        """
        self._DirectConnectGatewayId = None
        self._RouteIds = None
        self._AddressType = None

    @property
    def DirectConnectGatewayId(self):
        """专线网关ID，形如：dcg-prpqlmg1
        :rtype: str
        """
        return self._DirectConnectGatewayId

    @DirectConnectGatewayId.setter
    def DirectConnectGatewayId(self, DirectConnectGatewayId):
        self._DirectConnectGatewayId = DirectConnectGatewayId

    @property
    def RouteIds(self):
        """路由ID。形如：ccnr-f49l6u0z。
        :rtype: list of str
        """
        return self._RouteIds

    @RouteIds.setter
    def RouteIds(self, RouteIds):
        self._RouteIds = RouteIds

    @property
    def AddressType(self):
        """地址类型，支持：IPv4、IPv6。默认IPv4。
        :rtype: str
        """
        return self._AddressType

    @AddressType.setter
    def AddressType(self, AddressType):
        self._AddressType = AddressType


    def _deserialize(self, params):
        self._DirectConnectGatewayId = params.get("DirectConnectGatewayId")
        self._RouteIds = params.get("RouteIds")
        self._AddressType = params.get("AddressType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteDirectConnectGatewayCcnRoutesResponse(AbstractModel):
    """DeleteDirectConnectGatewayCcnRoutes返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteDirectConnectGatewayRequest(AbstractModel):
    """DeleteDirectConnectGateway请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DirectConnectGatewayId: 专线网关唯一`ID`，形如：`dcg-9o233uri`。
        :type DirectConnectGatewayId: str
        """
        self._DirectConnectGatewayId = None

    @property
    def DirectConnectGatewayId(self):
        """专线网关唯一`ID`，形如：`dcg-9o233uri`。
        :rtype: str
        """
        return self._DirectConnectGatewayId

    @DirectConnectGatewayId.setter
    def DirectConnectGatewayId(self, DirectConnectGatewayId):
        self._DirectConnectGatewayId = DirectConnectGatewayId


    def _deserialize(self, params):
        self._DirectConnectGatewayId = params.get("DirectConnectGatewayId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteDirectConnectGatewayResponse(AbstractModel):
    """DeleteDirectConnectGateway返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteFlowLogRequest(AbstractModel):
    """DeleteFlowLog请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FlowLogId: 流日志唯一ID。
        :type FlowLogId: str
        :param _VpcId: 私用网络ID或者统一ID，建议使用统一ID，删除云联网流日志时，可不填，其他流日志类型必填。
        :type VpcId: str
        """
        self._FlowLogId = None
        self._VpcId = None

    @property
    def FlowLogId(self):
        """流日志唯一ID。
        :rtype: str
        """
        return self._FlowLogId

    @FlowLogId.setter
    def FlowLogId(self, FlowLogId):
        self._FlowLogId = FlowLogId

    @property
    def VpcId(self):
        """私用网络ID或者统一ID，建议使用统一ID，删除云联网流日志时，可不填，其他流日志类型必填。
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId


    def _deserialize(self, params):
        self._FlowLogId = params.get("FlowLogId")
        self._VpcId = params.get("VpcId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteFlowLogResponse(AbstractModel):
    """DeleteFlowLog返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteHaVipRequest(AbstractModel):
    """DeleteHaVip请求参数结构体

    """

    def __init__(self):
        r"""
        :param _HaVipId: `HAVIP`唯一`ID`，形如：`havip-9o233uri`。
        :type HaVipId: str
        """
        self._HaVipId = None

    @property
    def HaVipId(self):
        """`HAVIP`唯一`ID`，形如：`havip-9o233uri`。
        :rtype: str
        """
        return self._HaVipId

    @HaVipId.setter
    def HaVipId(self, HaVipId):
        self._HaVipId = HaVipId


    def _deserialize(self, params):
        self._HaVipId = params.get("HaVipId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteHaVipResponse(AbstractModel):
    """DeleteHaVip返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteHighPriorityRouteTablesRequest(AbstractModel):
    """DeleteHighPriorityRouteTables请求参数结构体

    """

    def __init__(self):
        r"""
        :param _HighPriorityRouteTableIds: 高优路由表表唯一ID 列表。
        :type HighPriorityRouteTableIds: list of str
        """
        self._HighPriorityRouteTableIds = None

    @property
    def HighPriorityRouteTableIds(self):
        """高优路由表表唯一ID 列表。
        :rtype: list of str
        """
        return self._HighPriorityRouteTableIds

    @HighPriorityRouteTableIds.setter
    def HighPriorityRouteTableIds(self, HighPriorityRouteTableIds):
        self._HighPriorityRouteTableIds = HighPriorityRouteTableIds


    def _deserialize(self, params):
        self._HighPriorityRouteTableIds = params.get("HighPriorityRouteTableIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteHighPriorityRouteTablesResponse(AbstractModel):
    """DeleteHighPriorityRouteTables返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteHighPriorityRoutesRequest(AbstractModel):
    """DeleteHighPriorityRoutes请求参数结构体

    """

    def __init__(self):
        r"""
        :param _HighPriorityRouteTableId: 高优路由表唯一 ID。
        :type HighPriorityRouteTableId: str
        :param _HighPriorityRouteIds: 高优路由表条目唯一 ID 列表。
        :type HighPriorityRouteIds: list of str
        """
        self._HighPriorityRouteTableId = None
        self._HighPriorityRouteIds = None

    @property
    def HighPriorityRouteTableId(self):
        """高优路由表唯一 ID。
        :rtype: str
        """
        return self._HighPriorityRouteTableId

    @HighPriorityRouteTableId.setter
    def HighPriorityRouteTableId(self, HighPriorityRouteTableId):
        self._HighPriorityRouteTableId = HighPriorityRouteTableId

    @property
    def HighPriorityRouteIds(self):
        """高优路由表条目唯一 ID 列表。
        :rtype: list of str
        """
        return self._HighPriorityRouteIds

    @HighPriorityRouteIds.setter
    def HighPriorityRouteIds(self, HighPriorityRouteIds):
        self._HighPriorityRouteIds = HighPriorityRouteIds


    def _deserialize(self, params):
        self._HighPriorityRouteTableId = params.get("HighPriorityRouteTableId")
        self._HighPriorityRouteIds = params.get("HighPriorityRouteIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteHighPriorityRoutesResponse(AbstractModel):
    """DeleteHighPriorityRoutes返回参数结构体

    """

    def __init__(self):
        r"""
        :param _HighPriorityRouteSet: 高优路由表条目信息。
        :type HighPriorityRouteSet: list of HighPriorityRoute
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._HighPriorityRouteSet = None
        self._RequestId = None

    @property
    def HighPriorityRouteSet(self):
        """高优路由表条目信息。
        :rtype: list of HighPriorityRoute
        """
        return self._HighPriorityRouteSet

    @HighPriorityRouteSet.setter
    def HighPriorityRouteSet(self, HighPriorityRouteSet):
        self._HighPriorityRouteSet = HighPriorityRouteSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("HighPriorityRouteSet") is not None:
            self._HighPriorityRouteSet = []
            for item in params.get("HighPriorityRouteSet"):
                obj = HighPriorityRoute()
                obj._deserialize(item)
                self._HighPriorityRouteSet.append(obj)
        self._RequestId = params.get("RequestId")


class DeleteIp6TranslatorsRequest(AbstractModel):
    """DeleteIp6Translators请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Ip6TranslatorIds: 待释放的IPV6转换实例的唯一ID，形如‘ip6-xxxxxxxx’
        :type Ip6TranslatorIds: list of str
        """
        self._Ip6TranslatorIds = None

    @property
    def Ip6TranslatorIds(self):
        """待释放的IPV6转换实例的唯一ID，形如‘ip6-xxxxxxxx’
        :rtype: list of str
        """
        return self._Ip6TranslatorIds

    @Ip6TranslatorIds.setter
    def Ip6TranslatorIds(self, Ip6TranslatorIds):
        self._Ip6TranslatorIds = Ip6TranslatorIds


    def _deserialize(self, params):
        self._Ip6TranslatorIds = params.get("Ip6TranslatorIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteIp6TranslatorsResponse(AbstractModel):
    """DeleteIp6Translators返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteLocalGatewayRequest(AbstractModel):
    """DeleteLocalGateway请求参数结构体

    """

    def __init__(self):
        r"""
        :param _LocalGatewayId: 本地网关实例ID。
        :type LocalGatewayId: str
        :param _CdcId: CDC实例ID。
        :type CdcId: str
        :param _VpcId: VPC实例ID。
        :type VpcId: str
        """
        self._LocalGatewayId = None
        self._CdcId = None
        self._VpcId = None

    @property
    def LocalGatewayId(self):
        """本地网关实例ID。
        :rtype: str
        """
        return self._LocalGatewayId

    @LocalGatewayId.setter
    def LocalGatewayId(self, LocalGatewayId):
        self._LocalGatewayId = LocalGatewayId

    @property
    def CdcId(self):
        """CDC实例ID。
        :rtype: str
        """
        return self._CdcId

    @CdcId.setter
    def CdcId(self, CdcId):
        self._CdcId = CdcId

    @property
    def VpcId(self):
        """VPC实例ID。
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId


    def _deserialize(self, params):
        self._LocalGatewayId = params.get("LocalGatewayId")
        self._CdcId = params.get("CdcId")
        self._VpcId = params.get("VpcId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteLocalGatewayResponse(AbstractModel):
    """DeleteLocalGateway返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteNatGatewayDestinationIpPortTranslationNatRuleRequest(AbstractModel):
    """DeleteNatGatewayDestinationIpPortTranslationNatRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NatGatewayId: NAT网关的ID，形如：`nat-df45454`。
        :type NatGatewayId: str
        :param _DestinationIpPortTranslationNatRules: NAT网关的端口转换规则。
        :type DestinationIpPortTranslationNatRules: list of DestinationIpPortTranslationNatRule
        """
        self._NatGatewayId = None
        self._DestinationIpPortTranslationNatRules = None

    @property
    def NatGatewayId(self):
        """NAT网关的ID，形如：`nat-df45454`。
        :rtype: str
        """
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId

    @property
    def DestinationIpPortTranslationNatRules(self):
        """NAT网关的端口转换规则。
        :rtype: list of DestinationIpPortTranslationNatRule
        """
        return self._DestinationIpPortTranslationNatRules

    @DestinationIpPortTranslationNatRules.setter
    def DestinationIpPortTranslationNatRules(self, DestinationIpPortTranslationNatRules):
        self._DestinationIpPortTranslationNatRules = DestinationIpPortTranslationNatRules


    def _deserialize(self, params):
        self._NatGatewayId = params.get("NatGatewayId")
        if params.get("DestinationIpPortTranslationNatRules") is not None:
            self._DestinationIpPortTranslationNatRules = []
            for item in params.get("DestinationIpPortTranslationNatRules"):
                obj = DestinationIpPortTranslationNatRule()
                obj._deserialize(item)
                self._DestinationIpPortTranslationNatRules.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteNatGatewayDestinationIpPortTranslationNatRuleResponse(AbstractModel):
    """DeleteNatGatewayDestinationIpPortTranslationNatRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteNatGatewayRequest(AbstractModel):
    """DeleteNatGateway请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NatGatewayId: NAT网关的ID，形如：`nat-df45454`。
        :type NatGatewayId: str
        """
        self._NatGatewayId = None

    @property
    def NatGatewayId(self):
        """NAT网关的ID，形如：`nat-df45454`。
        :rtype: str
        """
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId


    def _deserialize(self, params):
        self._NatGatewayId = params.get("NatGatewayId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteNatGatewayResponse(AbstractModel):
    """DeleteNatGateway返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteNatGatewaySourceIpTranslationNatRuleRequest(AbstractModel):
    """DeleteNatGatewaySourceIpTranslationNatRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NatGatewayId: NAT网关的ID，形如：`nat-df45454`。
        :type NatGatewayId: str
        :param _NatGatewaySnatIds: NAT网关的SNAT ID列表，形如：`snat-df43254`。
        :type NatGatewaySnatIds: list of str
        """
        self._NatGatewayId = None
        self._NatGatewaySnatIds = None

    @property
    def NatGatewayId(self):
        """NAT网关的ID，形如：`nat-df45454`。
        :rtype: str
        """
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId

    @property
    def NatGatewaySnatIds(self):
        """NAT网关的SNAT ID列表，形如：`snat-df43254`。
        :rtype: list of str
        """
        return self._NatGatewaySnatIds

    @NatGatewaySnatIds.setter
    def NatGatewaySnatIds(self, NatGatewaySnatIds):
        self._NatGatewaySnatIds = NatGatewaySnatIds


    def _deserialize(self, params):
        self._NatGatewayId = params.get("NatGatewayId")
        self._NatGatewaySnatIds = params.get("NatGatewaySnatIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteNatGatewaySourceIpTranslationNatRuleResponse(AbstractModel):
    """DeleteNatGatewaySourceIpTranslationNatRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteNetDetectRequest(AbstractModel):
    """DeleteNetDetect请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NetDetectId: 网络探测实例`ID`。形如：`netd-12345678`。
        :type NetDetectId: str
        """
        self._NetDetectId = None

    @property
    def NetDetectId(self):
        """网络探测实例`ID`。形如：`netd-12345678`。
        :rtype: str
        """
        return self._NetDetectId

    @NetDetectId.setter
    def NetDetectId(self, NetDetectId):
        self._NetDetectId = NetDetectId


    def _deserialize(self, params):
        self._NetDetectId = params.get("NetDetectId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteNetDetectResponse(AbstractModel):
    """DeleteNetDetect返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteNetworkAclEntriesRequest(AbstractModel):
    """DeleteNetworkAclEntries请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NetworkAclId: 三元组网络ACL实例ID。例如：acl-12345678。
        :type NetworkAclId: str
        :param _NetworkAclEntrySet: 三元组网络ACL规则集。
        :type NetworkAclEntrySet: :class:`tencentcloud.vpc.v20170312.models.NetworkAclEntrySet`
        """
        self._NetworkAclId = None
        self._NetworkAclEntrySet = None

    @property
    def NetworkAclId(self):
        """三元组网络ACL实例ID。例如：acl-12345678。
        :rtype: str
        """
        return self._NetworkAclId

    @NetworkAclId.setter
    def NetworkAclId(self, NetworkAclId):
        self._NetworkAclId = NetworkAclId

    @property
    def NetworkAclEntrySet(self):
        """三元组网络ACL规则集。
        :rtype: :class:`tencentcloud.vpc.v20170312.models.NetworkAclEntrySet`
        """
        return self._NetworkAclEntrySet

    @NetworkAclEntrySet.setter
    def NetworkAclEntrySet(self, NetworkAclEntrySet):
        self._NetworkAclEntrySet = NetworkAclEntrySet


    def _deserialize(self, params):
        self._NetworkAclId = params.get("NetworkAclId")
        if params.get("NetworkAclEntrySet") is not None:
            self._NetworkAclEntrySet = NetworkAclEntrySet()
            self._NetworkAclEntrySet._deserialize(params.get("NetworkAclEntrySet"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteNetworkAclEntriesResponse(AbstractModel):
    """DeleteNetworkAclEntries返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteNetworkAclQuintupleEntriesRequest(AbstractModel):
    """DeleteNetworkAclQuintupleEntries请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NetworkAclId: 网络ACL实例ID。例如：acl-12345678。
        :type NetworkAclId: str
        :param _NetworkAclQuintupleSet: 网络五元组ACL规则集。
        :type NetworkAclQuintupleSet: :class:`tencentcloud.vpc.v20170312.models.NetworkAclQuintupleEntries`
        """
        self._NetworkAclId = None
        self._NetworkAclQuintupleSet = None

    @property
    def NetworkAclId(self):
        """网络ACL实例ID。例如：acl-12345678。
        :rtype: str
        """
        return self._NetworkAclId

    @NetworkAclId.setter
    def NetworkAclId(self, NetworkAclId):
        self._NetworkAclId = NetworkAclId

    @property
    def NetworkAclQuintupleSet(self):
        """网络五元组ACL规则集。
        :rtype: :class:`tencentcloud.vpc.v20170312.models.NetworkAclQuintupleEntries`
        """
        return self._NetworkAclQuintupleSet

    @NetworkAclQuintupleSet.setter
    def NetworkAclQuintupleSet(self, NetworkAclQuintupleSet):
        self._NetworkAclQuintupleSet = NetworkAclQuintupleSet


    def _deserialize(self, params):
        self._NetworkAclId = params.get("NetworkAclId")
        if params.get("NetworkAclQuintupleSet") is not None:
            self._NetworkAclQuintupleSet = NetworkAclQuintupleEntries()
            self._NetworkAclQuintupleSet._deserialize(params.get("NetworkAclQuintupleSet"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteNetworkAclQuintupleEntriesResponse(AbstractModel):
    """DeleteNetworkAclQuintupleEntries返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteNetworkAclRequest(AbstractModel):
    """DeleteNetworkAcl请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NetworkAclId: 网络ACL实例ID。例如：acl-12345678。
        :type NetworkAclId: str
        """
        self._NetworkAclId = None

    @property
    def NetworkAclId(self):
        """网络ACL实例ID。例如：acl-12345678。
        :rtype: str
        """
        return self._NetworkAclId

    @NetworkAclId.setter
    def NetworkAclId(self, NetworkAclId):
        self._NetworkAclId = NetworkAclId


    def _deserialize(self, params):
        self._NetworkAclId = params.get("NetworkAclId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteNetworkAclResponse(AbstractModel):
    """DeleteNetworkAcl返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteNetworkInterfaceRequest(AbstractModel):
    """DeleteNetworkInterface请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NetworkInterfaceId: 弹性网卡实例ID，例如：eni-m6dyj72l。
        :type NetworkInterfaceId: str
        """
        self._NetworkInterfaceId = None

    @property
    def NetworkInterfaceId(self):
        """弹性网卡实例ID，例如：eni-m6dyj72l。
        :rtype: str
        """
        return self._NetworkInterfaceId

    @NetworkInterfaceId.setter
    def NetworkInterfaceId(self, NetworkInterfaceId):
        self._NetworkInterfaceId = NetworkInterfaceId


    def _deserialize(self, params):
        self._NetworkInterfaceId = params.get("NetworkInterfaceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteNetworkInterfaceResponse(AbstractModel):
    """DeleteNetworkInterface返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeletePrivateNatGatewayDestinationIpPortTranslationNatRuleRequest(AbstractModel):
    """DeletePrivateNatGatewayDestinationIpPortTranslationNatRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NatGatewayId: 私网网关唯一`ID`，形如：`intranat-xxxxxxxx`。
        :type NatGatewayId: str
        :param _LocalDestinationIpPortTranslationNatRules: 目的端口转换规则数组。
        :type LocalDestinationIpPortTranslationNatRules: list of LocalDestinationIpPortTranslationNatRule
        """
        self._NatGatewayId = None
        self._LocalDestinationIpPortTranslationNatRules = None

    @property
    def NatGatewayId(self):
        """私网网关唯一`ID`，形如：`intranat-xxxxxxxx`。
        :rtype: str
        """
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId

    @property
    def LocalDestinationIpPortTranslationNatRules(self):
        """目的端口转换规则数组。
        :rtype: list of LocalDestinationIpPortTranslationNatRule
        """
        return self._LocalDestinationIpPortTranslationNatRules

    @LocalDestinationIpPortTranslationNatRules.setter
    def LocalDestinationIpPortTranslationNatRules(self, LocalDestinationIpPortTranslationNatRules):
        self._LocalDestinationIpPortTranslationNatRules = LocalDestinationIpPortTranslationNatRules


    def _deserialize(self, params):
        self._NatGatewayId = params.get("NatGatewayId")
        if params.get("LocalDestinationIpPortTranslationNatRules") is not None:
            self._LocalDestinationIpPortTranslationNatRules = []
            for item in params.get("LocalDestinationIpPortTranslationNatRules"):
                obj = LocalDestinationIpPortTranslationNatRule()
                obj._deserialize(item)
                self._LocalDestinationIpPortTranslationNatRules.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeletePrivateNatGatewayDestinationIpPortTranslationNatRuleResponse(AbstractModel):
    """DeletePrivateNatGatewayDestinationIpPortTranslationNatRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeletePrivateNatGatewayRequest(AbstractModel):
    """DeletePrivateNatGateway请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NatGatewayId: 私网网关唯一`ID`，形如"intranat-xxxxxxxx"。
        :type NatGatewayId: str
        """
        self._NatGatewayId = None

    @property
    def NatGatewayId(self):
        """私网网关唯一`ID`，形如"intranat-xxxxxxxx"。
        :rtype: str
        """
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId


    def _deserialize(self, params):
        self._NatGatewayId = params.get("NatGatewayId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeletePrivateNatGatewayResponse(AbstractModel):
    """DeletePrivateNatGateway返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeletePrivateNatGatewayTranslationAclRuleRequest(AbstractModel):
    """DeletePrivateNatGatewayTranslationAclRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NatGatewayId: 私网网关唯一`ID`，形如：`intranat-xxxxxxxx`。
        :type NatGatewayId: str
        :param _TranslationDirection: 转换规则目标，可选值"LOCAL"。
        :type TranslationDirection: str
        :param _TranslationType: 转换规则类型，可选值"NETWORK_LAYER","TRANSPORT_LAYER"。
        :type TranslationType: str
        :param _TranslationIp: 转换`IP`,当转换规则类型为四层时为`IP`池
        :type TranslationIp: str
        :param _AclRuleIds: 访问控制规则对应`ID`
        :type AclRuleIds: list of int non-negative
        :param _OriginalIp: 源`IP`,当转换规则类型为三层时有效
        :type OriginalIp: str
        """
        self._NatGatewayId = None
        self._TranslationDirection = None
        self._TranslationType = None
        self._TranslationIp = None
        self._AclRuleIds = None
        self._OriginalIp = None

    @property
    def NatGatewayId(self):
        """私网网关唯一`ID`，形如：`intranat-xxxxxxxx`。
        :rtype: str
        """
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId

    @property
    def TranslationDirection(self):
        """转换规则目标，可选值"LOCAL"。
        :rtype: str
        """
        return self._TranslationDirection

    @TranslationDirection.setter
    def TranslationDirection(self, TranslationDirection):
        self._TranslationDirection = TranslationDirection

    @property
    def TranslationType(self):
        """转换规则类型，可选值"NETWORK_LAYER","TRANSPORT_LAYER"。
        :rtype: str
        """
        return self._TranslationType

    @TranslationType.setter
    def TranslationType(self, TranslationType):
        self._TranslationType = TranslationType

    @property
    def TranslationIp(self):
        """转换`IP`,当转换规则类型为四层时为`IP`池
        :rtype: str
        """
        return self._TranslationIp

    @TranslationIp.setter
    def TranslationIp(self, TranslationIp):
        self._TranslationIp = TranslationIp

    @property
    def AclRuleIds(self):
        """访问控制规则对应`ID`
        :rtype: list of int non-negative
        """
        return self._AclRuleIds

    @AclRuleIds.setter
    def AclRuleIds(self, AclRuleIds):
        self._AclRuleIds = AclRuleIds

    @property
    def OriginalIp(self):
        """源`IP`,当转换规则类型为三层时有效
        :rtype: str
        """
        return self._OriginalIp

    @OriginalIp.setter
    def OriginalIp(self, OriginalIp):
        self._OriginalIp = OriginalIp


    def _deserialize(self, params):
        self._NatGatewayId = params.get("NatGatewayId")
        self._TranslationDirection = params.get("TranslationDirection")
        self._TranslationType = params.get("TranslationType")
        self._TranslationIp = params.get("TranslationIp")
        self._AclRuleIds = params.get("AclRuleIds")
        self._OriginalIp = params.get("OriginalIp")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeletePrivateNatGatewayTranslationAclRuleResponse(AbstractModel):
    """DeletePrivateNatGatewayTranslationAclRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeletePrivateNatGatewayTranslationNatRuleRequest(AbstractModel):
    """DeletePrivateNatGatewayTranslationNatRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NatGatewayId: 私网网关唯一`ID`，形如：`intranat-xxxxxxxx`。
        :type NatGatewayId: str
        :param _TranslationNatRules: 转换规则对象数组。
        :type TranslationNatRules: list of TranslationNatRule
        :param _CrossDomain: 跨域参数，当VPC为跨域时填写为True。
        :type CrossDomain: bool
        """
        self._NatGatewayId = None
        self._TranslationNatRules = None
        self._CrossDomain = None

    @property
    def NatGatewayId(self):
        """私网网关唯一`ID`，形如：`intranat-xxxxxxxx`。
        :rtype: str
        """
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId

    @property
    def TranslationNatRules(self):
        """转换规则对象数组。
        :rtype: list of TranslationNatRule
        """
        return self._TranslationNatRules

    @TranslationNatRules.setter
    def TranslationNatRules(self, TranslationNatRules):
        self._TranslationNatRules = TranslationNatRules

    @property
    def CrossDomain(self):
        """跨域参数，当VPC为跨域时填写为True。
        :rtype: bool
        """
        return self._CrossDomain

    @CrossDomain.setter
    def CrossDomain(self, CrossDomain):
        self._CrossDomain = CrossDomain


    def _deserialize(self, params):
        self._NatGatewayId = params.get("NatGatewayId")
        if params.get("TranslationNatRules") is not None:
            self._TranslationNatRules = []
            for item in params.get("TranslationNatRules"):
                obj = TranslationNatRule()
                obj._deserialize(item)
                self._TranslationNatRules.append(obj)
        self._CrossDomain = params.get("CrossDomain")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeletePrivateNatGatewayTranslationNatRuleResponse(AbstractModel):
    """DeletePrivateNatGatewayTranslationNatRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _NatGatewayId: 私网网关唯一`ID`，形如：`intranat-xxxxxxxx`。
        :type NatGatewayId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._NatGatewayId = None
        self._RequestId = None

    @property
    def NatGatewayId(self):
        """私网网关唯一`ID`，形如：`intranat-xxxxxxxx`。
        :rtype: str
        """
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._NatGatewayId = params.get("NatGatewayId")
        self._RequestId = params.get("RequestId")


class DeleteReserveIpAddressesRequest(AbstractModel):
    """DeleteReserveIpAddresses请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VpcId: VPC唯一 ID。
        :type VpcId: str
        :param _ReserveIpIds: 内网保留IP地址列表。
        :type ReserveIpIds: list of str
        """
        self._VpcId = None
        self._ReserveIpIds = None

    @property
    def VpcId(self):
        """VPC唯一 ID。
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def ReserveIpIds(self):
        """内网保留IP地址列表。
        :rtype: list of str
        """
        return self._ReserveIpIds

    @ReserveIpIds.setter
    def ReserveIpIds(self, ReserveIpIds):
        self._ReserveIpIds = ReserveIpIds


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._ReserveIpIds = params.get("ReserveIpIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteReserveIpAddressesResponse(AbstractModel):
    """DeleteReserveIpAddresses返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteRouteTableRequest(AbstractModel):
    """DeleteRouteTable请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RouteTableId: 路由表实例ID，例如：rtb-azd4dt1c。
        :type RouteTableId: str
        """
        self._RouteTableId = None

    @property
    def RouteTableId(self):
        """路由表实例ID，例如：rtb-azd4dt1c。
        :rtype: str
        """
        return self._RouteTableId

    @RouteTableId.setter
    def RouteTableId(self, RouteTableId):
        self._RouteTableId = RouteTableId


    def _deserialize(self, params):
        self._RouteTableId = params.get("RouteTableId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRouteTableResponse(AbstractModel):
    """DeleteRouteTable返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteRoutesRequest(AbstractModel):
    """DeleteRoutes请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RouteTableId: 路由表实例ID。
        :type RouteTableId: str
        :param _Routes: 路由策略对象，删除路由策略时，仅需使用Route的RouteId字段。
        :type Routes: list of Route
        """
        self._RouteTableId = None
        self._Routes = None

    @property
    def RouteTableId(self):
        """路由表实例ID。
        :rtype: str
        """
        return self._RouteTableId

    @RouteTableId.setter
    def RouteTableId(self, RouteTableId):
        self._RouteTableId = RouteTableId

    @property
    def Routes(self):
        """路由策略对象，删除路由策略时，仅需使用Route的RouteId字段。
        :rtype: list of Route
        """
        return self._Routes

    @Routes.setter
    def Routes(self, Routes):
        self._Routes = Routes


    def _deserialize(self, params):
        self._RouteTableId = params.get("RouteTableId")
        if params.get("Routes") is not None:
            self._Routes = []
            for item in params.get("Routes"):
                obj = Route()
                obj._deserialize(item)
                self._Routes.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRoutesResponse(AbstractModel):
    """DeleteRoutes返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RouteSet: 已删除的路由策略详情。
        :type RouteSet: list of Route
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RouteSet = None
        self._RequestId = None

    @property
    def RouteSet(self):
        """已删除的路由策略详情。
        :rtype: list of Route
        """
        return self._RouteSet

    @RouteSet.setter
    def RouteSet(self, RouteSet):
        self._RouteSet = RouteSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RouteSet") is not None:
            self._RouteSet = []
            for item in params.get("RouteSet"):
                obj = Route()
                obj._deserialize(item)
                self._RouteSet.append(obj)
        self._RequestId = params.get("RequestId")


class DeleteSecurityGroupPoliciesRequest(AbstractModel):
    """DeleteSecurityGroupPolicies请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SecurityGroupId: 安全组实例ID，例如sg-33ocnj9n，可通过<a href="https://cloud.tencent.com/document/product/215/15808">DescribeSecurityGroups</a>获取。
        :type SecurityGroupId: str
        :param _SecurityGroupPolicySet: 安全组规则集合。一个请求中只能删除单个方向的一条或多条规则。支持指定索引（PolicyIndex） 匹配删除和安全组规则匹配删除两种方式，一个请求中只能使用一种匹配方式。
        :type SecurityGroupPolicySet: :class:`tencentcloud.vpc.v20170312.models.SecurityGroupPolicySet`
        """
        self._SecurityGroupId = None
        self._SecurityGroupPolicySet = None

    @property
    def SecurityGroupId(self):
        """安全组实例ID，例如sg-33ocnj9n，可通过<a href="https://cloud.tencent.com/document/product/215/15808">DescribeSecurityGroups</a>获取。
        :rtype: str
        """
        return self._SecurityGroupId

    @SecurityGroupId.setter
    def SecurityGroupId(self, SecurityGroupId):
        self._SecurityGroupId = SecurityGroupId

    @property
    def SecurityGroupPolicySet(self):
        """安全组规则集合。一个请求中只能删除单个方向的一条或多条规则。支持指定索引（PolicyIndex） 匹配删除和安全组规则匹配删除两种方式，一个请求中只能使用一种匹配方式。
        :rtype: :class:`tencentcloud.vpc.v20170312.models.SecurityGroupPolicySet`
        """
        return self._SecurityGroupPolicySet

    @SecurityGroupPolicySet.setter
    def SecurityGroupPolicySet(self, SecurityGroupPolicySet):
        self._SecurityGroupPolicySet = SecurityGroupPolicySet


    def _deserialize(self, params):
        self._SecurityGroupId = params.get("SecurityGroupId")
        if params.get("SecurityGroupPolicySet") is not None:
            self._SecurityGroupPolicySet = SecurityGroupPolicySet()
            self._SecurityGroupPolicySet._deserialize(params.get("SecurityGroupPolicySet"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSecurityGroupPoliciesResponse(AbstractModel):
    """DeleteSecurityGroupPolicies返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteSecurityGroupRequest(AbstractModel):
    """DeleteSecurityGroup请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SecurityGroupId: 安全组实例ID，例如sg-33ocnj9n，可通过<a href="https://cloud.tencent.com/document/product/215/15808">DescribeSecurityGroups</a>获取。
        :type SecurityGroupId: str
        """
        self._SecurityGroupId = None

    @property
    def SecurityGroupId(self):
        """安全组实例ID，例如sg-33ocnj9n，可通过<a href="https://cloud.tencent.com/document/product/215/15808">DescribeSecurityGroups</a>获取。
        :rtype: str
        """
        return self._SecurityGroupId

    @SecurityGroupId.setter
    def SecurityGroupId(self, SecurityGroupId):
        self._SecurityGroupId = SecurityGroupId


    def _deserialize(self, params):
        self._SecurityGroupId = params.get("SecurityGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSecurityGroupResponse(AbstractModel):
    """DeleteSecurityGroup返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteServiceTemplateGroupRequest(AbstractModel):
    """DeleteServiceTemplateGroup请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ServiceTemplateGroupId: 协议端口模板集合实例ID，例如：ppmg-n17uxvve。
        :type ServiceTemplateGroupId: str
        """
        self._ServiceTemplateGroupId = None

    @property
    def ServiceTemplateGroupId(self):
        """协议端口模板集合实例ID，例如：ppmg-n17uxvve。
        :rtype: str
        """
        return self._ServiceTemplateGroupId

    @ServiceTemplateGroupId.setter
    def ServiceTemplateGroupId(self, ServiceTemplateGroupId):
        self._ServiceTemplateGroupId = ServiceTemplateGroupId


    def _deserialize(self, params):
        self._ServiceTemplateGroupId = params.get("ServiceTemplateGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteServiceTemplateGroupResponse(AbstractModel):
    """DeleteServiceTemplateGroup返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteServiceTemplateRequest(AbstractModel):
    """DeleteServiceTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ServiceTemplateId: 协议端口模板实例ID，例如：ppm-e6dy460g。
        :type ServiceTemplateId: str
        """
        self._ServiceTemplateId = None

    @property
    def ServiceTemplateId(self):
        """协议端口模板实例ID，例如：ppm-e6dy460g。
        :rtype: str
        """
        return self._ServiceTemplateId

    @ServiceTemplateId.setter
    def ServiceTemplateId(self, ServiceTemplateId):
        self._ServiceTemplateId = ServiceTemplateId


    def _deserialize(self, params):
        self._ServiceTemplateId = params.get("ServiceTemplateId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteServiceTemplateResponse(AbstractModel):
    """DeleteServiceTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteSnapshotPoliciesRequest(AbstractModel):
    """DeleteSnapshotPolicies请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SnapshotPolicyIds: 快照策略Id。
        :type SnapshotPolicyIds: list of str
        """
        self._SnapshotPolicyIds = None

    @property
    def SnapshotPolicyIds(self):
        """快照策略Id。
        :rtype: list of str
        """
        return self._SnapshotPolicyIds

    @SnapshotPolicyIds.setter
    def SnapshotPolicyIds(self, SnapshotPolicyIds):
        self._SnapshotPolicyIds = SnapshotPolicyIds


    def _deserialize(self, params):
        self._SnapshotPolicyIds = params.get("SnapshotPolicyIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSnapshotPoliciesResponse(AbstractModel):
    """DeleteSnapshotPolicies返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteSubnetRequest(AbstractModel):
    """DeleteSubnet请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubnetId: 子网实例ID。可通过DescribeSubnets接口返回值中的SubnetId获取。
        :type SubnetId: str
        """
        self._SubnetId = None

    @property
    def SubnetId(self):
        """子网实例ID。可通过DescribeSubnets接口返回值中的SubnetId获取。
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId


    def _deserialize(self, params):
        self._SubnetId = params.get("SubnetId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSubnetResponse(AbstractModel):
    """DeleteSubnet返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteTemplateMemberRequest(AbstractModel):
    """DeleteTemplateMember请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TemplateId: 参数模板实例ID，支持IP地址、协议端口、IP地址组、协议端口组四种参数模板的实例ID。
        :type TemplateId: str
        :param _TemplateMember: 需要添加的参数模板成员信息，支持IP地址、协议端口、IP地址组、协议端口组四种类型，类型需要与TemplateId参数类型一致。
        :type TemplateMember: list of MemberInfo
        """
        self._TemplateId = None
        self._TemplateMember = None

    @property
    def TemplateId(self):
        """参数模板实例ID，支持IP地址、协议端口、IP地址组、协议端口组四种参数模板的实例ID。
        :rtype: str
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId

    @property
    def TemplateMember(self):
        """需要添加的参数模板成员信息，支持IP地址、协议端口、IP地址组、协议端口组四种类型，类型需要与TemplateId参数类型一致。
        :rtype: list of MemberInfo
        """
        return self._TemplateMember

    @TemplateMember.setter
    def TemplateMember(self, TemplateMember):
        self._TemplateMember = TemplateMember


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        if params.get("TemplateMember") is not None:
            self._TemplateMember = []
            for item in params.get("TemplateMember"):
                obj = MemberInfo()
                obj._deserialize(item)
                self._TemplateMember.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteTemplateMemberResponse(AbstractModel):
    """DeleteTemplateMember返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteTrafficPackagesRequest(AbstractModel):
    """DeleteTrafficPackages请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TrafficPackageIds: 待删除的流量包唯一ID数组
        :type TrafficPackageIds: list of str
        """
        self._TrafficPackageIds = None

    @property
    def TrafficPackageIds(self):
        """待删除的流量包唯一ID数组
        :rtype: list of str
        """
        return self._TrafficPackageIds

    @TrafficPackageIds.setter
    def TrafficPackageIds(self, TrafficPackageIds):
        self._TrafficPackageIds = TrafficPackageIds


    def _deserialize(self, params):
        self._TrafficPackageIds = params.get("TrafficPackageIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteTrafficPackagesResponse(AbstractModel):
    """DeleteTrafficPackages返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteVpcEndPointRequest(AbstractModel):
    """DeleteVpcEndPoint请求参数结构体

    """

    def __init__(self):
        r"""
        :param _EndPointId: 终端节点ID。
        :type EndPointId: str
        """
        self._EndPointId = None

    @property
    def EndPointId(self):
        """终端节点ID。
        :rtype: str
        """
        return self._EndPointId

    @EndPointId.setter
    def EndPointId(self, EndPointId):
        self._EndPointId = EndPointId


    def _deserialize(self, params):
        self._EndPointId = params.get("EndPointId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteVpcEndPointResponse(AbstractModel):
    """DeleteVpcEndPoint返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteVpcEndPointServiceRequest(AbstractModel):
    """DeleteVpcEndPointService请求参数结构体

    """

    def __init__(self):
        r"""
        :param _EndPointServiceId: 终端节点ID。
        :type EndPointServiceId: str
        """
        self._EndPointServiceId = None

    @property
    def EndPointServiceId(self):
        """终端节点ID。
        :rtype: str
        """
        return self._EndPointServiceId

    @EndPointServiceId.setter
    def EndPointServiceId(self, EndPointServiceId):
        self._EndPointServiceId = EndPointServiceId


    def _deserialize(self, params):
        self._EndPointServiceId = params.get("EndPointServiceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteVpcEndPointServiceResponse(AbstractModel):
    """DeleteVpcEndPointService返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteVpcEndPointServiceWhiteListRequest(AbstractModel):
    """DeleteVpcEndPointServiceWhiteList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _UserUin: 用户UIN数组。
        :type UserUin: list of str
        :param _EndPointServiceId: 终端节点服务ID。
        :type EndPointServiceId: str
        """
        self._UserUin = None
        self._EndPointServiceId = None

    @property
    def UserUin(self):
        """用户UIN数组。
        :rtype: list of str
        """
        return self._UserUin

    @UserUin.setter
    def UserUin(self, UserUin):
        self._UserUin = UserUin

    @property
    def EndPointServiceId(self):
        """终端节点服务ID。
        :rtype: str
        """
        return self._EndPointServiceId

    @EndPointServiceId.setter
    def EndPointServiceId(self, EndPointServiceId):
        self._EndPointServiceId = EndPointServiceId


    def _deserialize(self, params):
        self._UserUin = params.get("UserUin")
        self._EndPointServiceId = params.get("EndPointServiceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteVpcEndPointServiceWhiteListResponse(AbstractModel):
    """DeleteVpcEndPointServiceWhiteList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteVpcPeeringConnectionRequest(AbstractModel):
    """DeleteVpcPeeringConnection请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PeeringConnectionId: 对等连接唯一ID。
        :type PeeringConnectionId: str
        """
        self._PeeringConnectionId = None

    @property
    def PeeringConnectionId(self):
        """对等连接唯一ID。
        :rtype: str
        """
        return self._PeeringConnectionId

    @PeeringConnectionId.setter
    def PeeringConnectionId(self, PeeringConnectionId):
        self._PeeringConnectionId = PeeringConnectionId


    def _deserialize(self, params):
        self._PeeringConnectionId = params.get("PeeringConnectionId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteVpcPeeringConnectionResponse(AbstractModel):
    """DeleteVpcPeeringConnection返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteVpcRequest(AbstractModel):
    """DeleteVpc请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VpcId: VPC实例ID。可通过DescribeVpcs接口返回值中的VpcId获取。
        :type VpcId: str
        """
        self._VpcId = None

    @property
    def VpcId(self):
        """VPC实例ID。可通过DescribeVpcs接口返回值中的VpcId获取。
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteVpcResponse(AbstractModel):
    """DeleteVpc返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteVpnConnectionRequest(AbstractModel):
    """DeleteVpnConnection请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VpnGatewayId: VPN网关实例ID。
        :type VpnGatewayId: str
        :param _VpnConnectionId: VPN通道实例ID。形如：vpnx-f49l6u0z。
        :type VpnConnectionId: str
        """
        self._VpnGatewayId = None
        self._VpnConnectionId = None

    @property
    def VpnGatewayId(self):
        """VPN网关实例ID。
        :rtype: str
        """
        return self._VpnGatewayId

    @VpnGatewayId.setter
    def VpnGatewayId(self, VpnGatewayId):
        self._VpnGatewayId = VpnGatewayId

    @property
    def VpnConnectionId(self):
        """VPN通道实例ID。形如：vpnx-f49l6u0z。
        :rtype: str
        """
        return self._VpnConnectionId

    @VpnConnectionId.setter
    def VpnConnectionId(self, VpnConnectionId):
        self._VpnConnectionId = VpnConnectionId


    def _deserialize(self, params):
        self._VpnGatewayId = params.get("VpnGatewayId")
        self._VpnConnectionId = params.get("VpnConnectionId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteVpnConnectionResponse(AbstractModel):
    """DeleteVpnConnection返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteVpnGatewayRequest(AbstractModel):
    """DeleteVpnGateway请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VpnGatewayId: VPN网关实例ID。
        :type VpnGatewayId: str
        """
        self._VpnGatewayId = None

    @property
    def VpnGatewayId(self):
        """VPN网关实例ID。
        :rtype: str
        """
        return self._VpnGatewayId

    @VpnGatewayId.setter
    def VpnGatewayId(self, VpnGatewayId):
        self._VpnGatewayId = VpnGatewayId


    def _deserialize(self, params):
        self._VpnGatewayId = params.get("VpnGatewayId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteVpnGatewayResponse(AbstractModel):
    """DeleteVpnGateway返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteVpnGatewayRoutesRequest(AbstractModel):
    """DeleteVpnGatewayRoutes请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VpnGatewayId: VPN网关实例ID
        :type VpnGatewayId: str
        :param _RouteIds: 路由ID信息列表，可以通过[DescribeVpnGatewayRoutes](https://cloud.tencent.com/document/api/215/57676)接口查询。
        :type RouteIds: list of str
        """
        self._VpnGatewayId = None
        self._RouteIds = None

    @property
    def VpnGatewayId(self):
        """VPN网关实例ID
        :rtype: str
        """
        return self._VpnGatewayId

    @VpnGatewayId.setter
    def VpnGatewayId(self, VpnGatewayId):
        self._VpnGatewayId = VpnGatewayId

    @property
    def RouteIds(self):
        """路由ID信息列表，可以通过[DescribeVpnGatewayRoutes](https://cloud.tencent.com/document/api/215/57676)接口查询。
        :rtype: list of str
        """
        return self._RouteIds

    @RouteIds.setter
    def RouteIds(self, RouteIds):
        self._RouteIds = RouteIds


    def _deserialize(self, params):
        self._VpnGatewayId = params.get("VpnGatewayId")
        self._RouteIds = params.get("RouteIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteVpnGatewayRoutesResponse(AbstractModel):
    """DeleteVpnGatewayRoutes返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteVpnGatewaySslClientRequest(AbstractModel):
    """DeleteVpnGatewaySslClient请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SslVpnClientId: SSL-VPN-CLIENT 实例ID。不可和SslVpnClientIds同时使用。
        :type SslVpnClientId: str
        :param _SslVpnClientIds: SSL-VPN-CLIENT 实例ID列表。批量删除时使用。不可和SslVpnClientId同时使用。
        :type SslVpnClientIds: list of str
        """
        self._SslVpnClientId = None
        self._SslVpnClientIds = None

    @property
    def SslVpnClientId(self):
        """SSL-VPN-CLIENT 实例ID。不可和SslVpnClientIds同时使用。
        :rtype: str
        """
        return self._SslVpnClientId

    @SslVpnClientId.setter
    def SslVpnClientId(self, SslVpnClientId):
        self._SslVpnClientId = SslVpnClientId

    @property
    def SslVpnClientIds(self):
        """SSL-VPN-CLIENT 实例ID列表。批量删除时使用。不可和SslVpnClientId同时使用。
        :rtype: list of str
        """
        return self._SslVpnClientIds

    @SslVpnClientIds.setter
    def SslVpnClientIds(self, SslVpnClientIds):
        self._SslVpnClientIds = SslVpnClientIds


    def _deserialize(self, params):
        self._SslVpnClientId = params.get("SslVpnClientId")
        self._SslVpnClientIds = params.get("SslVpnClientIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteVpnGatewaySslClientResponse(AbstractModel):
    """DeleteVpnGatewaySslClient返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 异步任务ID。
        :type TaskId: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        """异步任务ID。
        :rtype: int
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class DeleteVpnGatewaySslServerRequest(AbstractModel):
    """DeleteVpnGatewaySslServer请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SslVpnServerId: SSL-VPN-SERVER 实例ID。
        :type SslVpnServerId: str
        """
        self._SslVpnServerId = None

    @property
    def SslVpnServerId(self):
        """SSL-VPN-SERVER 实例ID。
        :rtype: str
        """
        return self._SslVpnServerId

    @SslVpnServerId.setter
    def SslVpnServerId(self, SslVpnServerId):
        self._SslVpnServerId = SslVpnServerId


    def _deserialize(self, params):
        self._SslVpnServerId = params.get("SslVpnServerId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteVpnGatewaySslServerResponse(AbstractModel):
    """DeleteVpnGatewaySslServer返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 异步任务ID。
        :type TaskId: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        """异步任务ID。
        :rtype: int
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class DescribeAccountAttributesRequest(AbstractModel):
    """DescribeAccountAttributes请求参数结构体

    """


class DescribeAccountAttributesResponse(AbstractModel):
    """DescribeAccountAttributes返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AccountAttributeSet: 用户账号属性对象。
        :type AccountAttributeSet: list of AccountAttribute
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AccountAttributeSet = None
        self._RequestId = None

    @property
    def AccountAttributeSet(self):
        """用户账号属性对象。
        :rtype: list of AccountAttribute
        """
        return self._AccountAttributeSet

    @AccountAttributeSet.setter
    def AccountAttributeSet(self, AccountAttributeSet):
        self._AccountAttributeSet = AccountAttributeSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("AccountAttributeSet") is not None:
            self._AccountAttributeSet = []
            for item in params.get("AccountAttributeSet"):
                obj = AccountAttribute()
                obj._deserialize(item)
                self._AccountAttributeSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAddressQuotaRequest(AbstractModel):
    """DescribeAddressQuota请求参数结构体

    """


class DescribeAddressQuotaResponse(AbstractModel):
    """DescribeAddressQuota返回参数结构体

    """

    def __init__(self):
        r"""
        :param _QuotaSet: 账户 EIP 配额信息。
        :type QuotaSet: list of Quota
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._QuotaSet = None
        self._RequestId = None

    @property
    def QuotaSet(self):
        """账户 EIP 配额信息。
        :rtype: list of Quota
        """
        return self._QuotaSet

    @QuotaSet.setter
    def QuotaSet(self, QuotaSet):
        self._QuotaSet = QuotaSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("QuotaSet") is not None:
            self._QuotaSet = []
            for item in params.get("QuotaSet"):
                obj = Quota()
                obj._deserialize(item)
                self._QuotaSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAddressTemplateGroupsRequest(AbstractModel):
    """DescribeAddressTemplateGroups请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤条件。
<li>address-template-group-name - String - （过滤条件）IP地址模板集合名称。</li>
<li>address-template-group-id - String - （过滤条件）IP地址模板实集合例ID，例如：ipmg-mdunqeb6。</li>
        :type Filters: list of Filter
        :param _Offset: 偏移量，默认为0。
        :type Offset: str
        :param _Limit: 返回数量，默认为20，最大值为100。
        :type Limit: str
        :param _NeedMemberInfo: 是否查询IP地址模板成员标识。
        :type NeedMemberInfo: bool
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._NeedMemberInfo = None

    @property
    def Filters(self):
        """过滤条件。
<li>address-template-group-name - String - （过滤条件）IP地址模板集合名称。</li>
<li>address-template-group-id - String - （过滤条件）IP地址模板实集合例ID，例如：ipmg-mdunqeb6。</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量，默认为0。
        :rtype: str
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量，默认为20，最大值为100。
        :rtype: str
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def NeedMemberInfo(self):
        """是否查询IP地址模板成员标识。
        :rtype: bool
        """
        return self._NeedMemberInfo

    @NeedMemberInfo.setter
    def NeedMemberInfo(self, NeedMemberInfo):
        self._NeedMemberInfo = NeedMemberInfo


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._NeedMemberInfo = params.get("NeedMemberInfo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAddressTemplateGroupsResponse(AbstractModel):
    """DescribeAddressTemplateGroups返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合条件的实例数量。
        :type TotalCount: int
        :param _AddressTemplateGroupSet: IP地址模板。
        :type AddressTemplateGroupSet: list of AddressTemplateGroup
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._AddressTemplateGroupSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """符合条件的实例数量。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AddressTemplateGroupSet(self):
        """IP地址模板。
        :rtype: list of AddressTemplateGroup
        """
        return self._AddressTemplateGroupSet

    @AddressTemplateGroupSet.setter
    def AddressTemplateGroupSet(self, AddressTemplateGroupSet):
        self._AddressTemplateGroupSet = AddressTemplateGroupSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AddressTemplateGroupSet") is not None:
            self._AddressTemplateGroupSet = []
            for item in params.get("AddressTemplateGroupSet"):
                obj = AddressTemplateGroup()
                obj._deserialize(item)
                self._AddressTemplateGroupSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAddressTemplatesRequest(AbstractModel):
    """DescribeAddressTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤条件。
<li>address-template-name - IP地址模板名称。</li>
<li>address-template-id - IP地址模板实例ID，例如：ipm-mdunqeb6。</li>
<li>address-ip - IP地址。</li>
        :type Filters: list of Filter
        :param _Offset: 偏移量，默认为0。
        :type Offset: str
        :param _Limit: 返回数量，默认为20，最大值为100。
        :type Limit: str
        :param _NeedMemberInfo: 是否获取IP地址模板成员标识。
        :type NeedMemberInfo: bool
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._NeedMemberInfo = None

    @property
    def Filters(self):
        """过滤条件。
<li>address-template-name - IP地址模板名称。</li>
<li>address-template-id - IP地址模板实例ID，例如：ipm-mdunqeb6。</li>
<li>address-ip - IP地址。</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量，默认为0。
        :rtype: str
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量，默认为20，最大值为100。
        :rtype: str
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def NeedMemberInfo(self):
        """是否获取IP地址模板成员标识。
        :rtype: bool
        """
        return self._NeedMemberInfo

    @NeedMemberInfo.setter
    def NeedMemberInfo(self, NeedMemberInfo):
        self._NeedMemberInfo = NeedMemberInfo


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._NeedMemberInfo = params.get("NeedMemberInfo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAddressTemplatesResponse(AbstractModel):
    """DescribeAddressTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合条件的实例数量。
        :type TotalCount: int
        :param _AddressTemplateSet: IP地址模板。
        :type AddressTemplateSet: list of AddressTemplate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._AddressTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """符合条件的实例数量。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AddressTemplateSet(self):
        """IP地址模板。
        :rtype: list of AddressTemplate
        """
        return self._AddressTemplateSet

    @AddressTemplateSet.setter
    def AddressTemplateSet(self, AddressTemplateSet):
        self._AddressTemplateSet = AddressTemplateSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AddressTemplateSet") is not None:
            self._AddressTemplateSet = []
            for item in params.get("AddressTemplateSet"):
                obj = AddressTemplate()
                obj._deserialize(item)
                self._AddressTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAddressesRequest(AbstractModel):
    """DescribeAddresses请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AddressIds: 标识 EIP 的唯一 ID 列表。EIP 唯一 ID 形如：`eip-11112222`。参数不支持同时指定`AddressIds`和`Filters.address-id`。
        :type AddressIds: list of str
        :param _Filters: 每次请求的`Filters`的上限为10，`Filter.Values`的上限为100。详细的过滤条件如下：
<li> address-id - String - 是否必填：否 - （过滤条件）按照 EIP 的唯一 ID 过滤。EIP 唯一 ID 形如：eip-11112222。</li>
<li> address-name - String - 是否必填：否 - （过滤条件）按照 EIP 名称过滤。不支持模糊过滤。</li>
<li> address-ip - String - 是否必填：否 - （过滤条件）按照 EIP 的 IP 地址过滤。</li>
<li> address-status - String - 是否必填：否 - （过滤条件）按照 EIP 的状态过滤。状态包含：'CREATING'，'BINDING'，'BIND'，'UNBINDING'，'UNBIND'，'OFFLINING'，'BIND_ENI'。</li>
<li> instance-id - String - 是否必填：否 - （过滤条件）按照 EIP 绑定的实例 ID 过滤。实例 ID 形如：ins-11112222。</li>
<li> private-ip-address - String - 是否必填：否 - （过滤条件）按照 EIP 绑定的内网 IP 过滤。</li>
<li> network-interface-id - String - 是否必填：否 - （过滤条件）按照 EIP 绑定的弹性网卡 ID 过滤。弹性网卡 ID 形如：eni-11112222。</li>
<li> is-arrears - String - 是否必填：否 - （过滤条件）按照 EIP 是否欠费进行过滤。（TRUE：EIP 处于欠费状态|FALSE：EIP 费用状态正常）</li>
<li> address-type - String - 是否必填：否 - （过滤条件）按照 IP类型 进行过滤。可选值：'WanIP', 'EIP'，'AnycastEIP'，'HighQualityEIP'， 'AntiDDoSEIP'。默认值是'EIP'。</li>
<li> address-isp - String - 是否必填：否 - （过滤条件）按照 运营商类型 进行过滤。可选值：'BGP'，'CMCC'，'CUCC', 'CTCC'</li>
<li> dedicated-cluster-id - String - 是否必填：否 - （过滤条件）按照 CDC 的唯一 ID 过滤。CDC 唯一 ID 形如：cluster-11112222。</li>
<li> tag-key - String - 是否必填：否 - （过滤条件）按照标签键进行过滤。</li>
<li> tag-value - String - 是否必填：否 - （过滤条件）按照标签值进行过滤。</li>
<li> tag:tag-key - String - 是否必填：否 - （过滤条件）按照标签键值对进行过滤。tag-key使用具体的标签键进行替换。</li>
        :type Filters: list of Filter
        :param _Offset: 偏移量，默认为0。关于`Offset`的更进一步介绍请参考 API 中的相关小节。
        :type Offset: int
        :param _Limit: 返回数量，默认为20，最大值为100。关于`Limit`的更进一步介绍请参考 API 中的相关小节。
        :type Limit: int
        """
        self._AddressIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def AddressIds(self):
        """标识 EIP 的唯一 ID 列表。EIP 唯一 ID 形如：`eip-11112222`。参数不支持同时指定`AddressIds`和`Filters.address-id`。
        :rtype: list of str
        """
        return self._AddressIds

    @AddressIds.setter
    def AddressIds(self, AddressIds):
        self._AddressIds = AddressIds

    @property
    def Filters(self):
        """每次请求的`Filters`的上限为10，`Filter.Values`的上限为100。详细的过滤条件如下：
<li> address-id - String - 是否必填：否 - （过滤条件）按照 EIP 的唯一 ID 过滤。EIP 唯一 ID 形如：eip-11112222。</li>
<li> address-name - String - 是否必填：否 - （过滤条件）按照 EIP 名称过滤。不支持模糊过滤。</li>
<li> address-ip - String - 是否必填：否 - （过滤条件）按照 EIP 的 IP 地址过滤。</li>
<li> address-status - String - 是否必填：否 - （过滤条件）按照 EIP 的状态过滤。状态包含：'CREATING'，'BINDING'，'BIND'，'UNBINDING'，'UNBIND'，'OFFLINING'，'BIND_ENI'。</li>
<li> instance-id - String - 是否必填：否 - （过滤条件）按照 EIP 绑定的实例 ID 过滤。实例 ID 形如：ins-11112222。</li>
<li> private-ip-address - String - 是否必填：否 - （过滤条件）按照 EIP 绑定的内网 IP 过滤。</li>
<li> network-interface-id - String - 是否必填：否 - （过滤条件）按照 EIP 绑定的弹性网卡 ID 过滤。弹性网卡 ID 形如：eni-11112222。</li>
<li> is-arrears - String - 是否必填：否 - （过滤条件）按照 EIP 是否欠费进行过滤。（TRUE：EIP 处于欠费状态|FALSE：EIP 费用状态正常）</li>
<li> address-type - String - 是否必填：否 - （过滤条件）按照 IP类型 进行过滤。可选值：'WanIP', 'EIP'，'AnycastEIP'，'HighQualityEIP'， 'AntiDDoSEIP'。默认值是'EIP'。</li>
<li> address-isp - String - 是否必填：否 - （过滤条件）按照 运营商类型 进行过滤。可选值：'BGP'，'CMCC'，'CUCC', 'CTCC'</li>
<li> dedicated-cluster-id - String - 是否必填：否 - （过滤条件）按照 CDC 的唯一 ID 过滤。CDC 唯一 ID 形如：cluster-11112222。</li>
<li> tag-key - String - 是否必填：否 - （过滤条件）按照标签键进行过滤。</li>
<li> tag-value - String - 是否必填：否 - （过滤条件）按照标签值进行过滤。</li>
<li> tag:tag-key - String - 是否必填：否 - （过滤条件）按照标签键值对进行过滤。tag-key使用具体的标签键进行替换。</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量，默认为0。关于`Offset`的更进一步介绍请参考 API 中的相关小节。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量，默认为20，最大值为100。关于`Limit`的更进一步介绍请参考 API 中的相关小节。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._AddressIds = params.get("AddressIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAddressesResponse(AbstractModel):
    """DescribeAddresses返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合条件的 EIP 数量。
        :type TotalCount: int
        :param _AddressSet: EIP 详细信息列表。
        :type AddressSet: list of Address
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._AddressSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """符合条件的 EIP 数量。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AddressSet(self):
        """EIP 详细信息列表。
        :rtype: list of Address
        """
        return self._AddressSet

    @AddressSet.setter
    def AddressSet(self, AddressSet):
        self._AddressSet = AddressSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AddressSet") is not None:
            self._AddressSet = []
            for item in params.get("AddressSet"):
                obj = Address()
                obj._deserialize(item)
                self._AddressSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAssistantCidrRequest(AbstractModel):
    """DescribeAssistantCidr请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VpcIds: `VPC`实例`ID`数组。形如：[`vpc-6v2ht8q5`]
        :type VpcIds: list of str
        :param _Filters: 过滤条件，参数不支持同时指定VpcIds和Filters。
<li>vpc-id - String - （过滤条件）VPC实例ID，形如：vpc-f49l6u0z。</li>
        :type Filters: list of Filter
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Limit: 返回数量，默认为20，最大值为100。
        :type Limit: int
        """
        self._VpcIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def VpcIds(self):
        """`VPC`实例`ID`数组。形如：[`vpc-6v2ht8q5`]
        :rtype: list of str
        """
        return self._VpcIds

    @VpcIds.setter
    def VpcIds(self, VpcIds):
        self._VpcIds = VpcIds

    @property
    def Filters(self):
        """过滤条件，参数不支持同时指定VpcIds和Filters。
<li>vpc-id - String - （过滤条件）VPC实例ID，形如：vpc-f49l6u0z。</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量，默认为0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量，默认为20，最大值为100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._VpcIds = params.get("VpcIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssistantCidrResponse(AbstractModel):
    """DescribeAssistantCidr返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AssistantCidrSet: 符合条件的辅助CIDR数组。
        :type AssistantCidrSet: list of AssistantCidr
        :param _TotalCount: 符合条件的实例数量。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AssistantCidrSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def AssistantCidrSet(self):
        """符合条件的辅助CIDR数组。
        :rtype: list of AssistantCidr
        """
        return self._AssistantCidrSet

    @AssistantCidrSet.setter
    def AssistantCidrSet(self, AssistantCidrSet):
        self._AssistantCidrSet = AssistantCidrSet

    @property
    def TotalCount(self):
        """符合条件的实例数量。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("AssistantCidrSet") is not None:
            self._AssistantCidrSet = []
            for item in params.get("AssistantCidrSet"):
                obj = AssistantCidr()
                obj._deserialize(item)
                self._AssistantCidrSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeBandwidthPackageBillUsageRequest(AbstractModel):
    """DescribeBandwidthPackageBillUsage请求参数结构体

    """

    def __init__(self):
        r"""
        :param _BandwidthPackageId: 后付费共享带宽包的唯一ID
        :type BandwidthPackageId: str
        """
        self._BandwidthPackageId = None

    @property
    def BandwidthPackageId(self):
        """后付费共享带宽包的唯一ID
        :rtype: str
        """
        return self._BandwidthPackageId

    @BandwidthPackageId.setter
    def BandwidthPackageId(self, BandwidthPackageId):
        self._BandwidthPackageId = BandwidthPackageId


    def _deserialize(self, params):
        self._BandwidthPackageId = params.get("BandwidthPackageId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBandwidthPackageBillUsageResponse(AbstractModel):
    """DescribeBandwidthPackageBillUsage返回参数结构体

    """

    def __init__(self):
        r"""
        :param _BandwidthPackageBillBandwidthSet: 当前计费用量
        :type BandwidthPackageBillBandwidthSet: list of BandwidthPackageBillBandwidth
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._BandwidthPackageBillBandwidthSet = None
        self._RequestId = None

    @property
    def BandwidthPackageBillBandwidthSet(self):
        """当前计费用量
        :rtype: list of BandwidthPackageBillBandwidth
        """
        return self._BandwidthPackageBillBandwidthSet

    @BandwidthPackageBillBandwidthSet.setter
    def BandwidthPackageBillBandwidthSet(self, BandwidthPackageBillBandwidthSet):
        self._BandwidthPackageBillBandwidthSet = BandwidthPackageBillBandwidthSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("BandwidthPackageBillBandwidthSet") is not None:
            self._BandwidthPackageBillBandwidthSet = []
            for item in params.get("BandwidthPackageBillBandwidthSet"):
                obj = BandwidthPackageBillBandwidth()
                obj._deserialize(item)
                self._BandwidthPackageBillBandwidthSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBandwidthPackageQuotaRequest(AbstractModel):
    """DescribeBandwidthPackageQuota请求参数结构体

    """


class DescribeBandwidthPackageQuotaResponse(AbstractModel):
    """DescribeBandwidthPackageQuota返回参数结构体

    """

    def __init__(self):
        r"""
        :param _QuotaSet: 带宽包配额详细信息
        :type QuotaSet: list of Quota
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._QuotaSet = None
        self._RequestId = None

    @property
    def QuotaSet(self):
        """带宽包配额详细信息
        :rtype: list of Quota
        """
        return self._QuotaSet

    @QuotaSet.setter
    def QuotaSet(self, QuotaSet):
        self._QuotaSet = QuotaSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("QuotaSet") is not None:
            self._QuotaSet = []
            for item in params.get("QuotaSet"):
                obj = Quota()
                obj._deserialize(item)
                self._QuotaSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBandwidthPackageResourcesRequest(AbstractModel):
    """DescribeBandwidthPackageResources请求参数结构体

    """

    def __init__(self):
        r"""
        :param _BandwidthPackageId: 标识 共享带宽包 的唯一 ID 列表。共享带宽包 唯一 ID 形如：`bwp-11112222`。
        :type BandwidthPackageId: str
        :param _Filters: 每次请求的`Filters`的上限为10，`Filter.Values`的上限为5。参数不支持同时指定`AddressIds`和`Filters`。详细的过滤条件如下：
<li> resource-id - String - 是否必填：否 - （过滤条件）按照 共享带宽包内资源 的唯一 ID 过滤。共享带宽包内资源 唯一 ID 形如：eip-11112222。</li>
<li> resource-type - String - 是否必填：否 - （过滤条件）按照 共享带宽包内资源 类型过滤，目前仅支持 弹性IP 和 负载均衡 两种类型，可选值为 Address 和 LoadBalance。</li>
        :type Filters: list of Filter
        :param _Offset: 偏移量，默认为0。关于`Offset`的更进一步介绍请参考 API [简介](https://cloud.tencent.com/document/api/213/11646)中的相关小节。
        :type Offset: int
        :param _Limit: 返回数量，默认为20，最大值为100。关于`Limit`的更进一步介绍请参考 API [简介](https://cloud.tencent.com/document/api/213/11646)中的相关小节。
        :type Limit: int
        """
        self._BandwidthPackageId = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def BandwidthPackageId(self):
        """标识 共享带宽包 的唯一 ID 列表。共享带宽包 唯一 ID 形如：`bwp-11112222`。
        :rtype: str
        """
        return self._BandwidthPackageId

    @BandwidthPackageId.setter
    def BandwidthPackageId(self, BandwidthPackageId):
        self._BandwidthPackageId = BandwidthPackageId

    @property
    def Filters(self):
        """每次请求的`Filters`的上限为10，`Filter.Values`的上限为5。参数不支持同时指定`AddressIds`和`Filters`。详细的过滤条件如下：
<li> resource-id - String - 是否必填：否 - （过滤条件）按照 共享带宽包内资源 的唯一 ID 过滤。共享带宽包内资源 唯一 ID 形如：eip-11112222。</li>
<li> resource-type - String - 是否必填：否 - （过滤条件）按照 共享带宽包内资源 类型过滤，目前仅支持 弹性IP 和 负载均衡 两种类型，可选值为 Address 和 LoadBalance。</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量，默认为0。关于`Offset`的更进一步介绍请参考 API [简介](https://cloud.tencent.com/document/api/213/11646)中的相关小节。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量，默认为20，最大值为100。关于`Limit`的更进一步介绍请参考 API [简介](https://cloud.tencent.com/document/api/213/11646)中的相关小节。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._BandwidthPackageId = params.get("BandwidthPackageId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBandwidthPackageResourcesResponse(AbstractModel):
    """DescribeBandwidthPackageResources返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合条件的 共享带宽包内资源 数量。
        :type TotalCount: int
        :param _ResourceSet: 共享带宽包内资源 详细信息列表。
        :type ResourceSet: list of Resource
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._ResourceSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """符合条件的 共享带宽包内资源 数量。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ResourceSet(self):
        """共享带宽包内资源 详细信息列表。
        :rtype: list of Resource
        """
        return self._ResourceSet

    @ResourceSet.setter
    def ResourceSet(self, ResourceSet):
        self._ResourceSet = ResourceSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ResourceSet") is not None:
            self._ResourceSet = []
            for item in params.get("ResourceSet"):
                obj = Resource()
                obj._deserialize(item)
                self._ResourceSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBandwidthPackagesRequest(AbstractModel):
    """DescribeBandwidthPackages请求参数结构体

    """

    def __init__(self):
        r"""
        :param _BandwidthPackageIds: 带宽包唯一ID列表
        :type BandwidthPackageIds: list of str
        :param _Filters: 每次请求的`Filters`的上限为10。参数不支持同时指定`BandwidthPackageIds`和`Filters`。详细的过滤条件如下：
<li> bandwidth-package-id - String - 是否必填：否 - （过滤条件）按照带宽包的唯一标识ID过滤。</li>
<li> bandwidth-package-name - String - 是否必填：否 - （过滤条件）按照 带宽包名称过滤。不支持模糊过滤。</li>
<li> network-type - String - 是否必填：否 - （过滤条件）按照带宽包的类型过滤。类型包括'HIGH_QUALITY_BGP','BGP','SINGLEISP'和'ANYCAST'。</li>
<li> charge-type - String - 是否必填：否 - （过滤条件）按照带宽包的计费类型过滤。计费类型包括: <li>'TOP5_POSTPAID_BY_MONTH':按月后付费TOP5计费</li><li> 'PERCENT95_POSTPAID_BY_MONTH':按月后付费月95计费</li><li>'ENHANCED95_POSTPAID_BY_MONTH':按月后付费增强型95计费</li><li>'FIXED_PREPAID_BY_MONTH':包月预付费计费</li><li>‘PEAK_BANDWIDTH_POSTPAID_BY_DAY’: 后付费日结按带宽计费</li>
<li> resource.resource-type - String - 是否必填：否 - （过滤条件）按照带宽包资源类型过滤。资源类型包括'Address'和'LoadBalance'</li>
<li> resource.resource-id - String - 是否必填：否 - （过滤条件）按照带宽包资源Id过滤。资源Id形如'eip-xxxx','lb-xxxx'</li>
<li> resource.address-ip - String - 是否必填：否 - （过滤条件）按照带宽包资源Ip过滤。</li>
<li> tag-key - String - 是否必填：否 - （过滤条件）按照标签键进行过滤。</li>
<li> tag-value - String - 是否必填：否 - （过滤条件）按照标签值进行过滤。</li>
<li> tag:tag-key - String - 是否必填：否 - （过滤条件）按照标签键值对进行过滤。tag-key使用具体的标签键进行替换。</li>
        :type Filters: list of Filter
        :param _Offset: 查询带宽包偏移量，默认为0。关于Offset的更进一步介绍请参考 API [简介](https://cloud.tencent.com/document/api/213/15688)中的相关小结。
        :type Offset: int
        :param _Limit: 查询带宽包返回数量，默认为20，最大值为100。关于Limit的更进一步介绍请参考 API [简介](https://cloud.tencent.com/document/api/213/15688)中的相关小结。
        :type Limit: int
        """
        self._BandwidthPackageIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def BandwidthPackageIds(self):
        """带宽包唯一ID列表
        :rtype: list of str
        """
        return self._BandwidthPackageIds

    @BandwidthPackageIds.setter
    def BandwidthPackageIds(self, BandwidthPackageIds):
        self._BandwidthPackageIds = BandwidthPackageIds

    @property
    def Filters(self):
        """每次请求的`Filters`的上限为10。参数不支持同时指定`BandwidthPackageIds`和`Filters`。详细的过滤条件如下：
<li> bandwidth-package-id - String - 是否必填：否 - （过滤条件）按照带宽包的唯一标识ID过滤。</li>
<li> bandwidth-package-name - String - 是否必填：否 - （过滤条件）按照 带宽包名称过滤。不支持模糊过滤。</li>
<li> network-type - String - 是否必填：否 - （过滤条件）按照带宽包的类型过滤。类型包括'HIGH_QUALITY_BGP','BGP','SINGLEISP'和'ANYCAST'。</li>
<li> charge-type - String - 是否必填：否 - （过滤条件）按照带宽包的计费类型过滤。计费类型包括: <li>'TOP5_POSTPAID_BY_MONTH':按月后付费TOP5计费</li><li> 'PERCENT95_POSTPAID_BY_MONTH':按月后付费月95计费</li><li>'ENHANCED95_POSTPAID_BY_MONTH':按月后付费增强型95计费</li><li>'FIXED_PREPAID_BY_MONTH':包月预付费计费</li><li>‘PEAK_BANDWIDTH_POSTPAID_BY_DAY’: 后付费日结按带宽计费</li>
<li> resource.resource-type - String - 是否必填：否 - （过滤条件）按照带宽包资源类型过滤。资源类型包括'Address'和'LoadBalance'</li>
<li> resource.resource-id - String - 是否必填：否 - （过滤条件）按照带宽包资源Id过滤。资源Id形如'eip-xxxx','lb-xxxx'</li>
<li> resource.address-ip - String - 是否必填：否 - （过滤条件）按照带宽包资源Ip过滤。</li>
<li> tag-key - String - 是否必填：否 - （过滤条件）按照标签键进行过滤。</li>
<li> tag-value - String - 是否必填：否 - （过滤条件）按照标签值进行过滤。</li>
<li> tag:tag-key - String - 是否必填：否 - （过滤条件）按照标签键值对进行过滤。tag-key使用具体的标签键进行替换。</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """查询带宽包偏移量，默认为0。关于Offset的更进一步介绍请参考 API [简介](https://cloud.tencent.com/document/api/213/15688)中的相关小结。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """查询带宽包返回数量，默认为20，最大值为100。关于Limit的更进一步介绍请参考 API [简介](https://cloud.tencent.com/document/api/213/15688)中的相关小结。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._BandwidthPackageIds = params.get("BandwidthPackageIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBandwidthPackagesResponse(AbstractModel):
    """DescribeBandwidthPackages返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合条件的带宽包数量
        :type TotalCount: int
        :param _BandwidthPackageSet: 描述带宽包详细信息
        :type BandwidthPackageSet: list of BandwidthPackage
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._BandwidthPackageSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """符合条件的带宽包数量
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def BandwidthPackageSet(self):
        """描述带宽包详细信息
        :rtype: list of BandwidthPackage
        """
        return self._BandwidthPackageSet

    @BandwidthPackageSet.setter
    def BandwidthPackageSet(self, BandwidthPackageSet):
        self._BandwidthPackageSet = BandwidthPackageSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("BandwidthPackageSet") is not None:
            self._BandwidthPackageSet = []
            for item in params.get("BandwidthPackageSet"):
                obj = BandwidthPackage()
                obj._deserialize(item)
                self._BandwidthPackageSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCcnAttachedInstancesRequest(AbstractModel):
    """DescribeCcnAttachedInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Offset: 偏移量
        :type Offset: int
        :param _Limit: 返回数量
        :type Limit: int
        :param _Filters: 过滤条件：
<li>ccn-id - String -（过滤条件）CCN实例ID。</li>
<li>instance-type - String -（过滤条件）关联实例类型。</li>
<li>instance-region - String -（过滤条件）关联实例所属地域。</li>
<li>instance-id - String -（过滤条件）关联实例ID。</li>
        :type Filters: list of Filter
        :param _CcnId: 云联网实例ID
        :type CcnId: str
        :param _OrderField: 排序字段。支持：`CcnId` `InstanceType` `InstanceId` `InstanceName` `InstanceRegion` `AttachedTime` `State`。默认值：`AttachedTime`
        :type OrderField: str
        :param _OrderDirection: 排序方法。升序：`ASC`，倒序：`DESC`。默认值：`ASC`
        :type OrderDirection: str
        """
        self._Offset = None
        self._Limit = None
        self._Filters = None
        self._CcnId = None
        self._OrderField = None
        self._OrderDirection = None

    @property
    def Offset(self):
        """偏移量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        """过滤条件：
<li>ccn-id - String -（过滤条件）CCN实例ID。</li>
<li>instance-type - String -（过滤条件）关联实例类型。</li>
<li>instance-region - String -（过滤条件）关联实例所属地域。</li>
<li>instance-id - String -（过滤条件）关联实例ID。</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def CcnId(self):
        """云联网实例ID
        :rtype: str
        """
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId

    @property
    def OrderField(self):
        """排序字段。支持：`CcnId` `InstanceType` `InstanceId` `InstanceName` `InstanceRegion` `AttachedTime` `State`。默认值：`AttachedTime`
        :rtype: str
        """
        return self._OrderField

    @OrderField.setter
    def OrderField(self, OrderField):
        self._OrderField = OrderField

    @property
    def OrderDirection(self):
        """排序方法。升序：`ASC`，倒序：`DESC`。默认值：`ASC`
        :rtype: str
        """
        return self._OrderDirection

    @OrderDirection.setter
    def OrderDirection(self, OrderDirection):
        self._OrderDirection = OrderDirection


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._CcnId = params.get("CcnId")
        self._OrderField = params.get("OrderField")
        self._OrderDirection = params.get("OrderDirection")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCcnAttachedInstancesResponse(AbstractModel):
    """DescribeCcnAttachedInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合条件的对象数。
        :type TotalCount: int
        :param _InstanceSet: 关联实例列表。
        :type InstanceSet: list of CcnAttachedInstance
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._InstanceSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """符合条件的对象数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def InstanceSet(self):
        """关联实例列表。
        :rtype: list of CcnAttachedInstance
        """
        return self._InstanceSet

    @InstanceSet.setter
    def InstanceSet(self, InstanceSet):
        self._InstanceSet = InstanceSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("InstanceSet") is not None:
            self._InstanceSet = []
            for item in params.get("InstanceSet"):
                obj = CcnAttachedInstance()
                obj._deserialize(item)
                self._InstanceSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCcnRegionBandwidthLimitsRequest(AbstractModel):
    """DescribeCcnRegionBandwidthLimits请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CcnId: CCN实例ID，形如：ccn-f49l6u0z。
        :type CcnId: str
        """
        self._CcnId = None

    @property
    def CcnId(self):
        """CCN实例ID，形如：ccn-f49l6u0z。
        :rtype: str
        """
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId


    def _deserialize(self, params):
        self._CcnId = params.get("CcnId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCcnRegionBandwidthLimitsResponse(AbstractModel):
    """DescribeCcnRegionBandwidthLimits返回参数结构体

    """

    def __init__(self):
        r"""
        :param _CcnRegionBandwidthLimitSet: 云联网（CCN）各地域出带宽上限
        :type CcnRegionBandwidthLimitSet: list of CcnRegionBandwidthLimit
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._CcnRegionBandwidthLimitSet = None
        self._RequestId = None

    @property
    def CcnRegionBandwidthLimitSet(self):
        """云联网（CCN）各地域出带宽上限
        :rtype: list of CcnRegionBandwidthLimit
        """
        return self._CcnRegionBandwidthLimitSet

    @CcnRegionBandwidthLimitSet.setter
    def CcnRegionBandwidthLimitSet(self, CcnRegionBandwidthLimitSet):
        self._CcnRegionBandwidthLimitSet = CcnRegionBandwidthLimitSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("CcnRegionBandwidthLimitSet") is not None:
            self._CcnRegionBandwidthLimitSet = []
            for item in params.get("CcnRegionBandwidthLimitSet"):
                obj = CcnRegionBandwidthLimit()
                obj._deserialize(item)
                self._CcnRegionBandwidthLimitSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCcnRouteTableBroadcastPolicysRequest(AbstractModel):
    """DescribeCcnRouteTableBroadcastPolicys请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CcnId: 云联网ID
        :type CcnId: str
        :param _RouteTableId: 云联网路由表ID
        :type RouteTableId: str
        :param _PolicyVersion: 路由传播策略版本号
        :type PolicyVersion: int
        """
        self._CcnId = None
        self._RouteTableId = None
        self._PolicyVersion = None

    @property
    def CcnId(self):
        """云联网ID
        :rtype: str
        """
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId

    @property
    def RouteTableId(self):
        """云联网路由表ID
        :rtype: str
        """
        return self._RouteTableId

    @RouteTableId.setter
    def RouteTableId(self, RouteTableId):
        self._RouteTableId = RouteTableId

    @property
    def PolicyVersion(self):
        """路由传播策略版本号
        :rtype: int
        """
        return self._PolicyVersion

    @PolicyVersion.setter
    def PolicyVersion(self, PolicyVersion):
        self._PolicyVersion = PolicyVersion


    def _deserialize(self, params):
        self._CcnId = params.get("CcnId")
        self._RouteTableId = params.get("RouteTableId")
        self._PolicyVersion = params.get("PolicyVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCcnRouteTableBroadcastPolicysResponse(AbstractModel):
    """DescribeCcnRouteTableBroadcastPolicys返回参数结构体

    """

    def __init__(self):
        r"""
        :param _PolicySet: 路由表传播策略。
        :type PolicySet: list of CcnRouteTableBroadcastPolicys
        :param _TotalCount: 符合条件的对象数。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._PolicySet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def PolicySet(self):
        """路由表传播策略。
        :rtype: list of CcnRouteTableBroadcastPolicys
        """
        return self._PolicySet

    @PolicySet.setter
    def PolicySet(self, PolicySet):
        self._PolicySet = PolicySet

    @property
    def TotalCount(self):
        """符合条件的对象数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("PolicySet") is not None:
            self._PolicySet = []
            for item in params.get("PolicySet"):
                obj = CcnRouteTableBroadcastPolicys()
                obj._deserialize(item)
                self._PolicySet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeCcnRouteTableInputPolicysRequest(AbstractModel):
    """DescribeCcnRouteTableInputPolicys请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CcnId: 云联网ID。
        :type CcnId: str
        :param _RouteTableId: 云联网路由表ID。
        :type RouteTableId: str
        :param _PolicyVersion: 路由接收策略版本号。
        :type PolicyVersion: int
        """
        self._CcnId = None
        self._RouteTableId = None
        self._PolicyVersion = None

    @property
    def CcnId(self):
        """云联网ID。
        :rtype: str
        """
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId

    @property
    def RouteTableId(self):
        """云联网路由表ID。
        :rtype: str
        """
        return self._RouteTableId

    @RouteTableId.setter
    def RouteTableId(self, RouteTableId):
        self._RouteTableId = RouteTableId

    @property
    def PolicyVersion(self):
        """路由接收策略版本号。
        :rtype: int
        """
        return self._PolicyVersion

    @PolicyVersion.setter
    def PolicyVersion(self, PolicyVersion):
        self._PolicyVersion = PolicyVersion


    def _deserialize(self, params):
        self._CcnId = params.get("CcnId")
        self._RouteTableId = params.get("RouteTableId")
        self._PolicyVersion = params.get("PolicyVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCcnRouteTableInputPolicysResponse(AbstractModel):
    """DescribeCcnRouteTableInputPolicys返回参数结构体

    """

    def __init__(self):
        r"""
        :param _PolicySet: 路由表接收策略。
        :type PolicySet: list of CcnRouteTableInputPolicys
        :param _TotalCount: 符合条件的对象数。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._PolicySet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def PolicySet(self):
        """路由表接收策略。
        :rtype: list of CcnRouteTableInputPolicys
        """
        return self._PolicySet

    @PolicySet.setter
    def PolicySet(self, PolicySet):
        self._PolicySet = PolicySet

    @property
    def TotalCount(self):
        """符合条件的对象数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("PolicySet") is not None:
            self._PolicySet = []
            for item in params.get("PolicySet"):
                obj = CcnRouteTableInputPolicys()
                obj._deserialize(item)
                self._PolicySet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeCcnRouteTablesRequest(AbstractModel):
    """DescribeCcnRouteTables请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤条件：
<li>ccn-id - String -（过滤条件）CCN实例ID。</li>
<li>route-table-id - String -（过滤条件）路由表ID。</li>
<li>route-table-name - String -（过滤条件）路由表名称。</li>
<li>route-table-description- String -（过滤条件）路由表备注。</li>
        :type Filters: list of Filter
        :param _Offset: 偏移量。
        :type Offset: int
        :param _Limit: 一次查询最大返回的数量。
        :type Limit: int
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def Filters(self):
        """过滤条件：
<li>ccn-id - String -（过滤条件）CCN实例ID。</li>
<li>route-table-id - String -（过滤条件）路由表ID。</li>
<li>route-table-name - String -（过滤条件）路由表名称。</li>
<li>route-table-description- String -（过滤条件）路由表备注。</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """一次查询最大返回的数量。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCcnRouteTablesResponse(AbstractModel):
    """DescribeCcnRouteTables返回参数结构体

    """

    def __init__(self):
        r"""
        :param _CcnRouteTableSet: 路由表信息列表。
        :type CcnRouteTableSet: list of CcnRouteTable
        :param _TotalCount: 查询到的路由表数量。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._CcnRouteTableSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def CcnRouteTableSet(self):
        """路由表信息列表。
        :rtype: list of CcnRouteTable
        """
        return self._CcnRouteTableSet

    @CcnRouteTableSet.setter
    def CcnRouteTableSet(self, CcnRouteTableSet):
        self._CcnRouteTableSet = CcnRouteTableSet

    @property
    def TotalCount(self):
        """查询到的路由表数量。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("CcnRouteTableSet") is not None:
            self._CcnRouteTableSet = []
            for item in params.get("CcnRouteTableSet"):
                obj = CcnRouteTable()
                obj._deserialize(item)
                self._CcnRouteTableSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeCcnRoutesRequest(AbstractModel):
    """DescribeCcnRoutes请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CcnId: CCN实例ID，形如：`ccn-gree226l`。
        :type CcnId: str
        :param _RouteIds: CCN路由策略唯一ID，形如：`ccnr-f49l6u0z`。
        :type RouteIds: list of str
        :param _Filters: 过滤条件，参数不支持同时指定RouteIds和Filters。
<li>route-id - String -（过滤条件）路由策略ID。</li>
<li>cidr-block - String -（过滤条件）目的端。</li>
<li>instance-type - String -（过滤条件）下一跳类型。</li>
<li>instance-region - String -（过滤条件）下一跳所属地域。</li>
<li>instance-id - String -（过滤条件）下一跳实例ID。</li>
<li>route-table-id - String -（过滤条件）路由表ID列表，形如ccntr-1234edfr，可以根据路由表ID 过滤。</li>
        :type Filters: list of Filter
        :param _Offset: 偏移量
        :type Offset: int
        :param _Limit: 返回数量
        :type Limit: int
        """
        self._CcnId = None
        self._RouteIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def CcnId(self):
        """CCN实例ID，形如：`ccn-gree226l`。
        :rtype: str
        """
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId

    @property
    def RouteIds(self):
        """CCN路由策略唯一ID，形如：`ccnr-f49l6u0z`。
        :rtype: list of str
        """
        return self._RouteIds

    @RouteIds.setter
    def RouteIds(self, RouteIds):
        self._RouteIds = RouteIds

    @property
    def Filters(self):
        """过滤条件，参数不支持同时指定RouteIds和Filters。
<li>route-id - String -（过滤条件）路由策略ID。</li>
<li>cidr-block - String -（过滤条件）目的端。</li>
<li>instance-type - String -（过滤条件）下一跳类型。</li>
<li>instance-region - String -（过滤条件）下一跳所属地域。</li>
<li>instance-id - String -（过滤条件）下一跳实例ID。</li>
<li>route-table-id - String -（过滤条件）路由表ID列表，形如ccntr-1234edfr，可以根据路由表ID 过滤。</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._CcnId = params.get("CcnId")
        self._RouteIds = params.get("RouteIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCcnRoutesResponse(AbstractModel):
    """DescribeCcnRoutes返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合条件的对象数。
        :type TotalCount: int
        :param _RouteSet: CCN路由策略对象。
        :type RouteSet: list of CcnRoute
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._RouteSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """符合条件的对象数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RouteSet(self):
        """CCN路由策略对象。
        :rtype: list of CcnRoute
        """
        return self._RouteSet

    @RouteSet.setter
    def RouteSet(self, RouteSet):
        self._RouteSet = RouteSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("RouteSet") is not None:
            self._RouteSet = []
            for item in params.get("RouteSet"):
                obj = CcnRoute()
                obj._deserialize(item)
                self._RouteSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCcnsRequest(AbstractModel):
    """DescribeCcns请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CcnIds: CCN实例ID。形如：ccn-f49l6u0z。每次请求的实例的上限为100。参数不支持同时指定CcnIds和Filters。
        :type CcnIds: list of str
        :param _Filters: 过滤条件，参数不支持同时指定CcnIds和Filters。
<li>ccn-id - String - （过滤条件）CCN唯一ID，形如：`ccn-f49l6u0z`。</li>
<li>ccn-name - String - （过滤条件）CCN名称。</li>
<li>ccn-description - String - （过滤条件）CCN描述。</li>
<li>state - String - （过滤条件）实例状态， 'ISOLATED': 隔离中（欠费停服），'AVAILABLE'：运行中。</li>
<li>tag-key - String -是否必填：否- （过滤条件）按照标签键进行过滤。</li>
<li>tag:tag-key - String - 是否必填：否 - （过滤条件）按照标签键值对进行过滤。 tag-key使用具体的标签键进行替换。使用请参考示例：查询绑定了标签的CCN列表。</li>
        :type Filters: list of Filter
        :param _Offset: 偏移量
        :type Offset: int
        :param _Limit: 返回数量
        :type Limit: int
        :param _OrderField: 排序字段。支持：`CcnId` `CcnName` `CreateTime` `State` `QosLevel`。默认值: `CreateTime`
        :type OrderField: str
        :param _OrderDirection: 排序方法。升序：`ASC`，倒序：`DESC`。默认值：`ASC`
        :type OrderDirection: str
        """
        self._CcnIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._OrderField = None
        self._OrderDirection = None

    @property
    def CcnIds(self):
        """CCN实例ID。形如：ccn-f49l6u0z。每次请求的实例的上限为100。参数不支持同时指定CcnIds和Filters。
        :rtype: list of str
        """
        return self._CcnIds

    @CcnIds.setter
    def CcnIds(self, CcnIds):
        self._CcnIds = CcnIds

    @property
    def Filters(self):
        """过滤条件，参数不支持同时指定CcnIds和Filters。
<li>ccn-id - String - （过滤条件）CCN唯一ID，形如：`ccn-f49l6u0z`。</li>
<li>ccn-name - String - （过滤条件）CCN名称。</li>
<li>ccn-description - String - （过滤条件）CCN描述。</li>
<li>state - String - （过滤条件）实例状态， 'ISOLATED': 隔离中（欠费停服），'AVAILABLE'：运行中。</li>
<li>tag-key - String -是否必填：否- （过滤条件）按照标签键进行过滤。</li>
<li>tag:tag-key - String - 是否必填：否 - （过滤条件）按照标签键值对进行过滤。 tag-key使用具体的标签键进行替换。使用请参考示例：查询绑定了标签的CCN列表。</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def OrderField(self):
        """排序字段。支持：`CcnId` `CcnName` `CreateTime` `State` `QosLevel`。默认值: `CreateTime`
        :rtype: str
        """
        return self._OrderField

    @OrderField.setter
    def OrderField(self, OrderField):
        self._OrderField = OrderField

    @property
    def OrderDirection(self):
        """排序方法。升序：`ASC`，倒序：`DESC`。默认值：`ASC`
        :rtype: str
        """
        return self._OrderDirection

    @OrderDirection.setter
    def OrderDirection(self, OrderDirection):
        self._OrderDirection = OrderDirection


    def _deserialize(self, params):
        self._CcnIds = params.get("CcnIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._OrderField = params.get("OrderField")
        self._OrderDirection = params.get("OrderDirection")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCcnsResponse(AbstractModel):
    """DescribeCcns返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合条件的对象数。
        :type TotalCount: int
        :param _CcnSet: CCN对象。
        :type CcnSet: list of CCN
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._CcnSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """符合条件的对象数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def CcnSet(self):
        """CCN对象。
        :rtype: list of CCN
        """
        return self._CcnSet

    @CcnSet.setter
    def CcnSet(self, CcnSet):
        self._CcnSet = CcnSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("CcnSet") is not None:
            self._CcnSet = []
            for item in params.get("CcnSet"):
                obj = CCN()
                obj._deserialize(item)
                self._CcnSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCdcLDCXListRequest(AbstractModel):
    """DescribeCdcLDCXList请求参数结构体

    """


class DescribeCdcLDCXListResponse(AbstractModel):
    """DescribeCdcLDCXList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DescribeCdcNetPlanesRequest(AbstractModel):
    """DescribeCdcNetPlanes请求参数结构体

    """


class DescribeCdcNetPlanesResponse(AbstractModel):
    """DescribeCdcNetPlanes返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DescribeCdcUsedIdcVlanRequest(AbstractModel):
    """DescribeCdcUsedIdcVlan请求参数结构体

    """


class DescribeCdcUsedIdcVlanResponse(AbstractModel):
    """DescribeCdcUsedIdcVlan返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DescribeClassicLinkInstancesRequest(AbstractModel):
    """DescribeClassicLinkInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤条件。
<li>vpc-id - String - （过滤条件）VPC实例ID。</li>
<li>vm-ip - String - （过滤条件）基础网络云服务器IP。</li>
        :type Filters: list of FilterObject
        :param _Offset: 偏移量，默认值0。
        :type Offset: str
        :param _Limit: 返回数量，默认为20，最大值为100。
        :type Limit: str
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def Filters(self):
        """过滤条件。
<li>vpc-id - String - （过滤条件）VPC实例ID。</li>
<li>vm-ip - String - （过滤条件）基础网络云服务器IP。</li>
        :rtype: list of FilterObject
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量，默认值0。
        :rtype: str
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量，默认为20，最大值为100。
        :rtype: str
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = FilterObject()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClassicLinkInstancesResponse(AbstractModel):
    """DescribeClassicLinkInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合条件的实例数量。
        :type TotalCount: int
        :param _ClassicLinkInstanceSet: 私有网络和基础网络互通设备。
        :type ClassicLinkInstanceSet: list of ClassicLinkInstance
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._ClassicLinkInstanceSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """符合条件的实例数量。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ClassicLinkInstanceSet(self):
        """私有网络和基础网络互通设备。
        :rtype: list of ClassicLinkInstance
        """
        return self._ClassicLinkInstanceSet

    @ClassicLinkInstanceSet.setter
    def ClassicLinkInstanceSet(self, ClassicLinkInstanceSet):
        self._ClassicLinkInstanceSet = ClassicLinkInstanceSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ClassicLinkInstanceSet") is not None:
            self._ClassicLinkInstanceSet = []
            for item in params.get("ClassicLinkInstanceSet"):
                obj = ClassicLinkInstance()
                obj._deserialize(item)
                self._ClassicLinkInstanceSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCrossBorderCcnRegionBandwidthLimitsRequest(AbstractModel):
    """DescribeCrossBorderCcnRegionBandwidthLimits请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤条件，目前`value`值个数只支持一个，可支持的字段有：
<li>`source-region` 源地域，值形如：`["ap-guangzhou"]`</li> <li>`destination-region` 目的地域，值形如：`["ap-shanghai"]`</li> <li>`ccn-ids` 云联网ID数组，值形如：`["ccn-12345678"]`</li> <li>`user-account-id` 用户账号ID，值形如`["12345678"]`</li>
        :type Filters: list of Filter
        :param _Offset: 偏移量，默认0。
        :type Offset: int
        :param _Limit: 单页返回数据量可选值0到100之间的整数，默认20。
        :type Limit: int
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def Filters(self):
        """过滤条件，目前`value`值个数只支持一个，可支持的字段有：
<li>`source-region` 源地域，值形如：`["ap-guangzhou"]`</li> <li>`destination-region` 目的地域，值形如：`["ap-shanghai"]`</li> <li>`ccn-ids` 云联网ID数组，值形如：`["ccn-12345678"]`</li> <li>`user-account-id` 用户账号ID，值形如`["12345678"]`</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量，默认0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """单页返回数据量可选值0到100之间的整数，默认20。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCrossBorderCcnRegionBandwidthLimitsResponse(AbstractModel):
    """DescribeCrossBorderCcnRegionBandwidthLimits返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合条件的对象总数。
        :type TotalCount: int
        :param _CcnBandwidthSet: 云联网地域间限速带宽实例的信息。
        :type CcnBandwidthSet: list of CcnBandwidth
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._CcnBandwidthSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """符合条件的对象总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def CcnBandwidthSet(self):
        """云联网地域间限速带宽实例的信息。
        :rtype: list of CcnBandwidth
        """
        return self._CcnBandwidthSet

    @CcnBandwidthSet.setter
    def CcnBandwidthSet(self, CcnBandwidthSet):
        self._CcnBandwidthSet = CcnBandwidthSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("CcnBandwidthSet") is not None:
            self._CcnBandwidthSet = []
            for item in params.get("CcnBandwidthSet"):
                obj = CcnBandwidth()
                obj._deserialize(item)
                self._CcnBandwidthSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCrossBorderComplianceRequest(AbstractModel):
    """DescribeCrossBorderCompliance请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ServiceProvider: （精确匹配）服务商，可选值：`UNICOM`。
        :type ServiceProvider: str
        :param _ComplianceId: （精确匹配）合规化审批单`ID`。
        :type ComplianceId: int
        :param _Company: （模糊查询）公司名称。
        :type Company: str
        :param _UniformSocialCreditCode: （精确匹配）统一社会信用代码。
        :type UniformSocialCreditCode: str
        :param _LegalPerson: （模糊查询）法定代表人。
        :type LegalPerson: str
        :param _LegalPersonId: （精确查询）法人身份证号。
        :type LegalPersonId: str
        :param _IssuingAuthority: （模糊查询）发证机关。
        :type IssuingAuthority: str
        :param _BusinessAddress: （模糊查询）营业执照住所。
        :type BusinessAddress: str
        :param _PostCode: （精确匹配）邮编。
        :type PostCode: int
        :param _Manager: （模糊查询）经办人。
        :type Manager: str
        :param _ManagerId: （精确查询）经办人身份证号。
        :type ManagerId: str
        :param _ManagerAddress: （模糊查询）经办人身份证地址。
        :type ManagerAddress: str
        :param _ManagerTelephone: （精确匹配）经办人联系电话。
        :type ManagerTelephone: str
        :param _Email: （精确匹配）电子邮箱。
        :type Email: str
        :param _ServiceStartDate: （精确匹配）服务开始日期，如：`2020-07-28`。
        :type ServiceStartDate: str
        :param _ServiceEndDate: （精确匹配）服务结束日期，如：`2021-07-28`。
        :type ServiceEndDate: str
        :param _State: （精确匹配）状态。待审批：`PENDING`，通过：`APPROVED `，拒绝：`DENY`。
        :type State: str
        :param _Offset: 偏移量
        :type Offset: int
        :param _Limit: 返回数量
        :type Limit: int
        """
        self._ServiceProvider = None
        self._ComplianceId = None
        self._Company = None
        self._UniformSocialCreditCode = None
        self._LegalPerson = None
        self._LegalPersonId = None
        self._IssuingAuthority = None
        self._BusinessAddress = None
        self._PostCode = None
        self._Manager = None
        self._ManagerId = None
        self._ManagerAddress = None
        self._ManagerTelephone = None
        self._Email = None
        self._ServiceStartDate = None
        self._ServiceEndDate = None
        self._State = None
        self._Offset = None
        self._Limit = None

    @property
    def ServiceProvider(self):
        """（精确匹配）服务商，可选值：`UNICOM`。
        :rtype: str
        """
        return self._ServiceProvider

    @ServiceProvider.setter
    def ServiceProvider(self, ServiceProvider):
        self._ServiceProvider = ServiceProvider

    @property
    def ComplianceId(self):
        """（精确匹配）合规化审批单`ID`。
        :rtype: int
        """
        return self._ComplianceId

    @ComplianceId.setter
    def ComplianceId(self, ComplianceId):
        self._ComplianceId = ComplianceId

    @property
    def Company(self):
        """（模糊查询）公司名称。
        :rtype: str
        """
        return self._Company

    @Company.setter
    def Company(self, Company):
        self._Company = Company

    @property
    def UniformSocialCreditCode(self):
        """（精确匹配）统一社会信用代码。
        :rtype: str
        """
        return self._UniformSocialCreditCode

    @UniformSocialCreditCode.setter
    def UniformSocialCreditCode(self, UniformSocialCreditCode):
        self._UniformSocialCreditCode = UniformSocialCreditCode

    @property
    def LegalPerson(self):
        """（模糊查询）法定代表人。
        :rtype: str
        """
        return self._LegalPerson

    @LegalPerson.setter
    def LegalPerson(self, LegalPerson):
        self._LegalPerson = LegalPerson

    @property
    def LegalPersonId(self):
        """（精确查询）法人身份证号。
        :rtype: str
        """
        return self._LegalPersonId

    @LegalPersonId.setter
    def LegalPersonId(self, LegalPersonId):
        self._LegalPersonId = LegalPersonId

    @property
    def IssuingAuthority(self):
        """（模糊查询）发证机关。
        :rtype: str
        """
        return self._IssuingAuthority

    @IssuingAuthority.setter
    def IssuingAuthority(self, IssuingAuthority):
        self._IssuingAuthority = IssuingAuthority

    @property
    def BusinessAddress(self):
        """（模糊查询）营业执照住所。
        :rtype: str
        """
        return self._BusinessAddress

    @BusinessAddress.setter
    def BusinessAddress(self, BusinessAddress):
        self._BusinessAddress = BusinessAddress

    @property
    def PostCode(self):
        """（精确匹配）邮编。
        :rtype: int
        """
        return self._PostCode

    @PostCode.setter
    def PostCode(self, PostCode):
        self._PostCode = PostCode

    @property
    def Manager(self):
        """（模糊查询）经办人。
        :rtype: str
        """
        return self._Manager

    @Manager.setter
    def Manager(self, Manager):
        self._Manager = Manager

    @property
    def ManagerId(self):
        """（精确查询）经办人身份证号。
        :rtype: str
        """
        return self._ManagerId

    @ManagerId.setter
    def ManagerId(self, ManagerId):
        self._ManagerId = ManagerId

    @property
    def ManagerAddress(self):
        """（模糊查询）经办人身份证地址。
        :rtype: str
        """
        return self._ManagerAddress

    @ManagerAddress.setter
    def ManagerAddress(self, ManagerAddress):
        self._ManagerAddress = ManagerAddress

    @property
    def ManagerTelephone(self):
        """（精确匹配）经办人联系电话。
        :rtype: str
        """
        return self._ManagerTelephone

    @ManagerTelephone.setter
    def ManagerTelephone(self, ManagerTelephone):
        self._ManagerTelephone = ManagerTelephone

    @property
    def Email(self):
        """（精确匹配）电子邮箱。
        :rtype: str
        """
        return self._Email

    @Email.setter
    def Email(self, Email):
        self._Email = Email

    @property
    def ServiceStartDate(self):
        """（精确匹配）服务开始日期，如：`2020-07-28`。
        :rtype: str
        """
        return self._ServiceStartDate

    @ServiceStartDate.setter
    def ServiceStartDate(self, ServiceStartDate):
        self._ServiceStartDate = ServiceStartDate

    @property
    def ServiceEndDate(self):
        """（精确匹配）服务结束日期，如：`2021-07-28`。
        :rtype: str
        """
        return self._ServiceEndDate

    @ServiceEndDate.setter
    def ServiceEndDate(self, ServiceEndDate):
        self._ServiceEndDate = ServiceEndDate

    @property
    def State(self):
        """（精确匹配）状态。待审批：`PENDING`，通过：`APPROVED `，拒绝：`DENY`。
        :rtype: str
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def Offset(self):
        """偏移量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._ServiceProvider = params.get("ServiceProvider")
        self._ComplianceId = params.get("ComplianceId")
        self._Company = params.get("Company")
        self._UniformSocialCreditCode = params.get("UniformSocialCreditCode")
        self._LegalPerson = params.get("LegalPerson")
        self._LegalPersonId = params.get("LegalPersonId")
        self._IssuingAuthority = params.get("IssuingAuthority")
        self._BusinessAddress = params.get("BusinessAddress")
        self._PostCode = params.get("PostCode")
        self._Manager = params.get("Manager")
        self._ManagerId = params.get("ManagerId")
        self._ManagerAddress = params.get("ManagerAddress")
        self._ManagerTelephone = params.get("ManagerTelephone")
        self._Email = params.get("Email")
        self._ServiceStartDate = params.get("ServiceStartDate")
        self._ServiceEndDate = params.get("ServiceEndDate")
        self._State = params.get("State")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCrossBorderComplianceResponse(AbstractModel):
    """DescribeCrossBorderCompliance返回参数结构体

    """

    def __init__(self):
        r"""
        :param _CrossBorderComplianceSet: 合规化审批单列表。
        :type CrossBorderComplianceSet: list of CrossBorderCompliance
        :param _TotalCount: 合规化审批单总数。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._CrossBorderComplianceSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def CrossBorderComplianceSet(self):
        """合规化审批单列表。
        :rtype: list of CrossBorderCompliance
        """
        return self._CrossBorderComplianceSet

    @CrossBorderComplianceSet.setter
    def CrossBorderComplianceSet(self, CrossBorderComplianceSet):
        self._CrossBorderComplianceSet = CrossBorderComplianceSet

    @property
    def TotalCount(self):
        """合规化审批单总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("CrossBorderComplianceSet") is not None:
            self._CrossBorderComplianceSet = []
            for item in params.get("CrossBorderComplianceSet"):
                obj = CrossBorderCompliance()
                obj._deserialize(item)
                self._CrossBorderComplianceSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeCrossBorderFlowMonitorRequest(AbstractModel):
    """DescribeCrossBorderFlowMonitor请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SourceRegion: 源地域。
        :type SourceRegion: str
        :param _DestinationRegion: 目的地域。
        :type DestinationRegion: str
        :param _CcnId: 云联网ID。
        :type CcnId: str
        :param _CcnUin: 云联网所属账号。
        :type CcnUin: str
        :param _Period: 时间粒度。单位为:秒，如60为60s的时间粒度
        :type Period: int
        :param _StartTime: 开始时间。
        :type StartTime: str
        :param _EndTime: 结束时间。
        :type EndTime: str
        """
        self._SourceRegion = None
        self._DestinationRegion = None
        self._CcnId = None
        self._CcnUin = None
        self._Period = None
        self._StartTime = None
        self._EndTime = None

    @property
    def SourceRegion(self):
        """源地域。
        :rtype: str
        """
        return self._SourceRegion

    @SourceRegion.setter
    def SourceRegion(self, SourceRegion):
        self._SourceRegion = SourceRegion

    @property
    def DestinationRegion(self):
        """目的地域。
        :rtype: str
        """
        return self._DestinationRegion

    @DestinationRegion.setter
    def DestinationRegion(self, DestinationRegion):
        self._DestinationRegion = DestinationRegion

    @property
    def CcnId(self):
        """云联网ID。
        :rtype: str
        """
        return self._CcnId

    @CcnId.setter
    def CcnId(self, CcnId):
        self._CcnId = CcnId

    @property
    def CcnUin(self):
        """云联网所属账号。
        :rtype: str
        """
        return self._CcnUin

    @CcnUin.setter
    def CcnUin(self, CcnUin):
        self._CcnUin = CcnUin

    @property
    def Period(self):
        """时间粒度。单位为:秒，如60为60s的时间粒度
        :rtype: int
        """
        return self._Period

    @Period.setter
    def Period(self, Period):
        self._Period = Period

    @property
    def StartTime(self):
        """开始时间。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束时间。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._SourceRegion = params.get("SourceRegion")
        self._DestinationRegion = params.get("DestinationRegion")
        self._CcnId = params.get("CcnId")
        self._CcnUin = params.get("CcnUin")
        self._Period = params.get("Period")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCrossBorderFlowMonitorResponse(AbstractModel):
    """DescribeCrossBorderFlowMonitor返回参数结构体

    """

    def __init__(self):
        r"""
        :param _CrossBorderFlowMonitorData: 云联网跨境带宽监控数据
注意：此字段可能返回 null，表示取不到有效值。
        :type CrossBorderFlowMonitorData: list of CrossBorderFlowMonitorData
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._CrossBorderFlowMonitorData = None
        self._RequestId = None

    @property
    def CrossBorderFlowMonitorData(self):
        """云联网跨境带宽监控数据
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of CrossBorderFlowMonitorData
        """
        return self._CrossBorderFlowMonitorData

    @CrossBorderFlowMonitorData.setter
    def CrossBorderFlowMonitorData(self, CrossBorderFlowMonitorData):
        self._CrossBorderFlowMonitorData = CrossBorderFlowMonitorData

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("CrossBorderFlowMonitorData") is not None:
            self._CrossBorderFlowMonitorData = []
            for item in params.get("CrossBorderFlowMonitorData"):
                obj = CrossBorderFlowMonitorData()
                obj._deserialize(item)
                self._CrossBorderFlowMonitorData.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCustomerGatewayVendorsRequest(AbstractModel):
    """DescribeCustomerGatewayVendors请求参数结构体

    """


class DescribeCustomerGatewayVendorsResponse(AbstractModel):
    """DescribeCustomerGatewayVendors返回参数结构体

    """

    def __init__(self):
        r"""
        :param _CustomerGatewayVendorSet: 对端网关厂商信息对象。
        :type CustomerGatewayVendorSet: list of CustomerGatewayVendor
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._CustomerGatewayVendorSet = None
        self._RequestId = None

    @property
    def CustomerGatewayVendorSet(self):
        """对端网关厂商信息对象。
        :rtype: list of CustomerGatewayVendor
        """
        return self._CustomerGatewayVendorSet

    @CustomerGatewayVendorSet.setter
    def CustomerGatewayVendorSet(self, CustomerGatewayVendorSet):
        self._CustomerGatewayVendorSet = CustomerGatewayVendorSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("CustomerGatewayVendorSet") is not None:
            self._CustomerGatewayVendorSet = []
            for item in params.get("CustomerGatewayVendorSet"):
                obj = CustomerGatewayVendor()
                obj._deserialize(item)
                self._CustomerGatewayVendorSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCustomerGatewaysRequest(AbstractModel):
    """DescribeCustomerGateways请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CustomerGatewayIds: 对端网关ID，例如：cgw-2wqq41m9。每次请求的实例的上限为100。参数不支持同时指定CustomerGatewayIds和Filters。
        :type CustomerGatewayIds: list of str
        :param _Filters: 过滤条件，详见下表：实例过滤条件表。每次请求的Filters的上限为10，Filter.Values的上限为5。参数不支持同时指定CustomerGatewayIds和Filters。
<li>customer-gateway-id - String - （过滤条件）用户网关唯一ID形如：`cgw-mgp33pll`。</li>
<li>customer-gateway-name - String - （过滤条件）用户网关名称形如：`test-cgw`。</li>
<li>ip-address - String - （过滤条件）公网地址形如：`58.211.1.12`。</li>
        :type Filters: list of Filter
        :param _Offset: 偏移量，默认为0。关于Offset的更进一步介绍请参考 API [简介](https://cloud.tencent.com/document/api/213/11646)中的相关小节。
        :type Offset: int
        :param _Limit: 返回数量，默认为20，最大值为100。
        :type Limit: int
        """
        self._CustomerGatewayIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def CustomerGatewayIds(self):
        """对端网关ID，例如：cgw-2wqq41m9。每次请求的实例的上限为100。参数不支持同时指定CustomerGatewayIds和Filters。
        :rtype: list of str
        """
        return self._CustomerGatewayIds

    @CustomerGatewayIds.setter
    def CustomerGatewayIds(self, CustomerGatewayIds):
        self._CustomerGatewayIds = CustomerGatewayIds

    @property
    def Filters(self):
        """过滤条件，详见下表：实例过滤条件表。每次请求的Filters的上限为10，Filter.Values的上限为5。参数不支持同时指定CustomerGatewayIds和Filters。
<li>customer-gateway-id - String - （过滤条件）用户网关唯一ID形如：`cgw-mgp33pll`。</li>
<li>customer-gateway-name - String - （过滤条件）用户网关名称形如：`test-cgw`。</li>
<li>ip-address - String - （过滤条件）公网地址形如：`58.211.1.12`。</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量，默认为0。关于Offset的更进一步介绍请参考 API [简介](https://cloud.tencent.com/document/api/213/11646)中的相关小节。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量，默认为20，最大值为100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._CustomerGatewayIds = params.get("CustomerGatewayIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCustomerGatewaysResponse(AbstractModel):
    """DescribeCustomerGateways返回参数结构体

    """

    def __init__(self):
        r"""
        :param _CustomerGatewaySet: 对端网关对象列表。
        :type CustomerGatewaySet: list of CustomerGateway
        :param _TotalCount: 符合条件的实例数量。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._CustomerGatewaySet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def CustomerGatewaySet(self):
        """对端网关对象列表。
        :rtype: list of CustomerGateway
        """
        return self._CustomerGatewaySet

    @CustomerGatewaySet.setter
    def CustomerGatewaySet(self, CustomerGatewaySet):
        self._CustomerGatewaySet = CustomerGatewaySet

    @property
    def TotalCount(self):
        """符合条件的实例数量。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("CustomerGatewaySet") is not None:
            self._CustomerGatewaySet = []
            for item in params.get("CustomerGatewaySet"):
                obj = CustomerGateway()
                obj._deserialize(item)
                self._CustomerGatewaySet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeDhcpIpsRequest(AbstractModel):
    """DescribeDhcpIps请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DhcpIpIds: DhcpIp实例ID。形如：dhcpip-pxir56ns。每次请求的实例的上限为100。参数不支持同时指定DhcpIpIds和Filters。
        :type DhcpIpIds: list of str
        :param _Filters: 过滤条件，参数不支持同时指定DhcpIpIds和Filters。
<li>vpc-id - String - （过滤条件）VPC实例ID，形如：vpc-f49l6u0z。</li>
<li>subnet-id - String - （过滤条件）所属子网实例ID，形如：subnet-f49l6u0z。</li>
<li>dhcpip-id - String - （过滤条件）DhcpIp实例ID，形如：dhcpip-pxir56ns。</li>
<li>dhcpip-name - String - （过滤条件）DhcpIp实例名称。</li>
<li>address-ip - String - （过滤条件）DhcpIp实例的IP，根据IP精确查找。</li>
        :type Filters: list of Filter
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Limit: 返回数量，默认为20，最大值为100。
        :type Limit: int
        """
        self._DhcpIpIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def DhcpIpIds(self):
        """DhcpIp实例ID。形如：dhcpip-pxir56ns。每次请求的实例的上限为100。参数不支持同时指定DhcpIpIds和Filters。
        :rtype: list of str
        """
        return self._DhcpIpIds

    @DhcpIpIds.setter
    def DhcpIpIds(self, DhcpIpIds):
        self._DhcpIpIds = DhcpIpIds

    @property
    def Filters(self):
        """过滤条件，参数不支持同时指定DhcpIpIds和Filters。
<li>vpc-id - String - （过滤条件）VPC实例ID，形如：vpc-f49l6u0z。</li>
<li>subnet-id - String - （过滤条件）所属子网实例ID，形如：subnet-f49l6u0z。</li>
<li>dhcpip-id - String - （过滤条件）DhcpIp实例ID，形如：dhcpip-pxir56ns。</li>
<li>dhcpip-name - String - （过滤条件）DhcpIp实例名称。</li>
<li>address-ip - String - （过滤条件）DhcpIp实例的IP，根据IP精确查找。</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量，默认为0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量，默认为20，最大值为100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._DhcpIpIds = params.get("DhcpIpIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDhcpIpsResponse(AbstractModel):
    """DescribeDhcpIps返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DhcpIpSet: 实例详细信息列表。
        :type DhcpIpSet: list of DhcpIp
        :param _TotalCount: 符合条件的实例数量。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DhcpIpSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def DhcpIpSet(self):
        """实例详细信息列表。
        :rtype: list of DhcpIp
        """
        return self._DhcpIpSet

    @DhcpIpSet.setter
    def DhcpIpSet(self, DhcpIpSet):
        self._DhcpIpSet = DhcpIpSet

    @property
    def TotalCount(self):
        """符合条件的实例数量。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DhcpIpSet") is not None:
            self._DhcpIpSet = []
            for item in params.get("DhcpIpSet"):
                obj = DhcpIp()
                obj._deserialize(item)
                self._DhcpIpSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeDirectConnectGatewayCcnRoutesRequest(AbstractModel):
    """DescribeDirectConnectGatewayCcnRoutes请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DirectConnectGatewayId: 专线网关ID，形如：`dcg-prpqlmg1`。
        :type DirectConnectGatewayId: str
        :param _CcnRouteType: 云联网路由学习类型，可选值：
<li>`BGP` - 自动学习。</li>
<li>`STATIC` - 静态，即用户配置，默认值。</li>
        :type CcnRouteType: str
        :param _AddressType: 地址类型，支持：IPv4、IPv6。默认IPv4。
        :type AddressType: str
        :param _Offset: 偏移量。
        :type Offset: int
        :param _Limit: 返回数量。
        :type Limit: int
        """
        self._DirectConnectGatewayId = None
        self._CcnRouteType = None
        self._AddressType = None
        self._Offset = None
        self._Limit = None

    @property
    def DirectConnectGatewayId(self):
        """专线网关ID，形如：`dcg-prpqlmg1`。
        :rtype: str
        """
        return self._DirectConnectGatewayId

    @DirectConnectGatewayId.setter
    def DirectConnectGatewayId(self, DirectConnectGatewayId):
        self._DirectConnectGatewayId = DirectConnectGatewayId

    @property
    def CcnRouteType(self):
        """云联网路由学习类型，可选值：
<li>`BGP` - 自动学习。</li>
<li>`STATIC` - 静态，即用户配置，默认值。</li>
        :rtype: str
        """
        return self._CcnRouteType

    @CcnRouteType.setter
    def CcnRouteType(self, CcnRouteType):
        self._CcnRouteType = CcnRouteType

    @property
    def AddressType(self):
        """地址类型，支持：IPv4、IPv6。默认IPv4。
        :rtype: str
        """
        return self._AddressType

    @AddressType.setter
    def AddressType(self, AddressType):
        self._AddressType = AddressType

    @property
    def Offset(self):
        """偏移量。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._DirectConnectGatewayId = params.get("DirectConnectGatewayId")
        self._CcnRouteType = params.get("CcnRouteType")
        self._AddressType = params.get("AddressType")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDirectConnectGatewayCcnRoutesResponse(AbstractModel):
    """DescribeDirectConnectGatewayCcnRoutes返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合条件的对象数。
        :type TotalCount: int
        :param _RouteSet: 云联网路由（IDC网段）列表。
        :type RouteSet: list of DirectConnectGatewayCcnRoute
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._RouteSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """符合条件的对象数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RouteSet(self):
        """云联网路由（IDC网段）列表。
        :rtype: list of DirectConnectGatewayCcnRoute
        """
        return self._RouteSet

    @RouteSet.setter
    def RouteSet(self, RouteSet):
        self._RouteSet = RouteSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("RouteSet") is not None:
            self._RouteSet = []
            for item in params.get("RouteSet"):
                obj = DirectConnectGatewayCcnRoute()
                obj._deserialize(item)
                self._RouteSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDirectConnectGatewaysRequest(AbstractModel):
    """DescribeDirectConnectGateways请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DirectConnectGatewayIds: 专线网关唯一`ID`，形如：`dcg-9o233uri`。
        :type DirectConnectGatewayIds: list of str
        :param _Filters: 过滤条件，参数不支持同时指定`DirectConnectGatewayIds`和`Filters`。
<li>direct-connect-gateway-id - String - 专线网关唯一`ID`，形如：`dcg-9o233uri`。</li>
<li>direct-connect-gateway-name - String - 专线网关名称，默认模糊查询。</li>
<li>direct-connect-gateway-ip - String - 专线网关`IP`。</li>
<li>gateway-type - String - 网关类型，可选值：`NORMAL`（普通型）、`NAT`（NAT型）。</li>
<li>network-type- String - 网络类型，可选值：`VPC`（私有网络类型）、`CCN`（云联网类型）。</li>
<li>ccn-id - String - 专线网关所在云联网`ID`。</li>
<li>vpc-id - String - 专线网关所在私有网络`ID`。</li>
        :type Filters: list of Filter
        :param _Offset: 偏移量。
        :type Offset: int
        :param _Limit: 返回数量。
        :type Limit: int
        """
        self._DirectConnectGatewayIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def DirectConnectGatewayIds(self):
        """专线网关唯一`ID`，形如：`dcg-9o233uri`。
        :rtype: list of str
        """
        return self._DirectConnectGatewayIds

    @DirectConnectGatewayIds.setter
    def DirectConnectGatewayIds(self, DirectConnectGatewayIds):
        self._DirectConnectGatewayIds = DirectConnectGatewayIds

    @property
    def Filters(self):
        """过滤条件，参数不支持同时指定`DirectConnectGatewayIds`和`Filters`。
<li>direct-connect-gateway-id - String - 专线网关唯一`ID`，形如：`dcg-9o233uri`。</li>
<li>direct-connect-gateway-name - String - 专线网关名称，默认模糊查询。</li>
<li>direct-connect-gateway-ip - String - 专线网关`IP`。</li>
<li>gateway-type - String - 网关类型，可选值：`NORMAL`（普通型）、`NAT`（NAT型）。</li>
<li>network-type- String - 网络类型，可选值：`VPC`（私有网络类型）、`CCN`（云联网类型）。</li>
<li>ccn-id - String - 专线网关所在云联网`ID`。</li>
<li>vpc-id - String - 专线网关所在私有网络`ID`。</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._DirectConnectGatewayIds = params.get("DirectConnectGatewayIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDirectConnectGatewaysResponse(AbstractModel):
    """DescribeDirectConnectGateways返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合条件的对象数。
        :type TotalCount: int
        :param _DirectConnectGatewaySet: 专线网关对象数组。
        :type DirectConnectGatewaySet: list of DirectConnectGateway
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._DirectConnectGatewaySet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """符合条件的对象数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DirectConnectGatewaySet(self):
        """专线网关对象数组。
        :rtype: list of DirectConnectGateway
        """
        return self._DirectConnectGatewaySet

    @DirectConnectGatewaySet.setter
    def DirectConnectGatewaySet(self, DirectConnectGatewaySet):
        self._DirectConnectGatewaySet = DirectConnectGatewaySet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DirectConnectGatewaySet") is not None:
            self._DirectConnectGatewaySet = []
            for item in params.get("DirectConnectGatewaySet"):
                obj = DirectConnectGateway()
                obj._deserialize(item)
                self._DirectConnectGatewaySet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeFlowLogRequest(AbstractModel):
    """DescribeFlowLog请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VpcId: 私用网络ID或者统一ID，建议使用统一ID。
        :type VpcId: str
        :param _FlowLogId: 流日志唯一ID。
        :type FlowLogId: str
        """
        self._VpcId = None
        self._FlowLogId = None

    @property
    def VpcId(self):
        """私用网络ID或者统一ID，建议使用统一ID。
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def FlowLogId(self):
        """流日志唯一ID。
        :rtype: str
        """
        return self._FlowLogId

    @FlowLogId.setter
    def FlowLogId(self, FlowLogId):
        self._FlowLogId = FlowLogId


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._FlowLogId = params.get("FlowLogId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFlowLogResponse(AbstractModel):
    """DescribeFlowLog返回参数结构体

    """

    def __init__(self):
        r"""
        :param _FlowLog: 流日志信息。
        :type FlowLog: list of FlowLog
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._FlowLog = None
        self._RequestId = None

    @property
    def FlowLog(self):
        """流日志信息。
        :rtype: list of FlowLog
        """
        return self._FlowLog

    @FlowLog.setter
    def FlowLog(self, FlowLog):
        self._FlowLog = FlowLog

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("FlowLog") is not None:
            self._FlowLog = []
            for item in params.get("FlowLog"):
                obj = FlowLog()
                obj._deserialize(item)
                self._FlowLog.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeFlowLogsRequest(AbstractModel):
    """DescribeFlowLogs请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VpcId: 私用网络ID或者统一ID，建议使用统一ID。
        :type VpcId: str
        :param _FlowLogId: 流日志唯一ID。
        :type FlowLogId: str
        :param _FlowLogName: 流日志实例名字。
        :type FlowLogName: str
        :param _ResourceType: 流日志所属资源类型，VPC|SUBNET|NETWORKINTERFACE。
        :type ResourceType: str
        :param _ResourceId: 资源唯一ID。
        :type ResourceId: str
        :param _TrafficType: 流日志采集类型，ACCEPT|REJECT|ALL。
        :type TrafficType: str
        :param _CloudLogId: 流日志存储ID。
        :type CloudLogId: str
        :param _CloudLogState: 流日志存储ID状态。
        :type CloudLogState: str
        :param _OrderField: 按某个字段排序,支持字段：flowLogName,createTime，默认按CreatedTime。
        :type OrderField: str
        :param _OrderDirection: 升序（ASC）还是降序（DESC）,默认：DESC。
        :type OrderDirection: str
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Limit: 每页行数，默认为10。
        :type Limit: int
        :param _Filters: 过滤条件，参数不支持同时指定FlowLogId和Filters。
<li>tag-key - String -是否必填：否- （过滤条件）按照标签键进行过滤。</li>
<li>tag:tag-key - String - 是否必填：否 - （过滤条件）按照标签键值对进行过滤。 tag-key使用具体的标签键进行替换。</li>
        :type Filters: :class:`tencentcloud.vpc.v20170312.models.Filter`
        :param _CloudLogRegion: 流日志存储ID对应的地域信息。
        :type CloudLogRegion: str
        """
        self._VpcId = None
        self._FlowLogId = None
        self._FlowLogName = None
        self._ResourceType = None
        self._ResourceId = None
        self._TrafficType = None
        self._CloudLogId = None
        self._CloudLogState = None
        self._OrderField = None
        self._OrderDirection = None
        self._Offset = None
        self._Limit = None
        self._Filters = None
        self._CloudLogRegion = None

    @property
    def VpcId(self):
        """私用网络ID或者统一ID，建议使用统一ID。
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def FlowLogId(self):
        """流日志唯一ID。
        :rtype: str
        """
        return self._FlowLogId

    @FlowLogId.setter
    def FlowLogId(self, FlowLogId):
        self._FlowLogId = FlowLogId

    @property
    def FlowLogName(self):
        """流日志实例名字。
        :rtype: str
        """
        return self._FlowLogName

    @FlowLogName.setter
    def FlowLogName(self, FlowLogName):
        self._FlowLogName = FlowLogName

    @property
    def ResourceType(self):
        """流日志所属资源类型，VPC|SUBNET|NETWORKINTERFACE。
        :rtype: str
        """
        return self._ResourceType

    @ResourceType.setter
    def ResourceType(self, ResourceType):
        self._ResourceType = ResourceType

    @property
    def ResourceId(self):
        """资源唯一ID。
        :rtype: str
        """
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId

    @property
    def TrafficType(self):
        """流日志采集类型，ACCEPT|REJECT|ALL。
        :rtype: str
        """
        return self._TrafficType

    @TrafficType.setter
    def TrafficType(self, TrafficType):
        self._TrafficType = TrafficType

    @property
    def CloudLogId(self):
        """流日志存储ID。
        :rtype: str
        """
        return self._CloudLogId

    @CloudLogId.setter
    def CloudLogId(self, CloudLogId):
        self._CloudLogId = CloudLogId

    @property
    def CloudLogState(self):
        """流日志存储ID状态。
        :rtype: str
        """
        return self._CloudLogState

    @CloudLogState.setter
    def CloudLogState(self, CloudLogState):
        self._CloudLogState = CloudLogState

    @property
    def OrderField(self):
        """按某个字段排序,支持字段：flowLogName,createTime，默认按CreatedTime。
        :rtype: str
        """
        return self._OrderField

    @OrderField.setter
    def OrderField(self, OrderField):
        self._OrderField = OrderField

    @property
    def OrderDirection(self):
        """升序（ASC）还是降序（DESC）,默认：DESC。
        :rtype: str
        """
        return self._OrderDirection

    @OrderDirection.setter
    def OrderDirection(self, OrderDirection):
        self._OrderDirection = OrderDirection

    @property
    def Offset(self):
        """偏移量，默认为0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """每页行数，默认为10。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        """过滤条件，参数不支持同时指定FlowLogId和Filters。
<li>tag-key - String -是否必填：否- （过滤条件）按照标签键进行过滤。</li>
<li>tag:tag-key - String - 是否必填：否 - （过滤条件）按照标签键值对进行过滤。 tag-key使用具体的标签键进行替换。</li>
        :rtype: :class:`tencentcloud.vpc.v20170312.models.Filter`
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def CloudLogRegion(self):
        """流日志存储ID对应的地域信息。
        :rtype: str
        """
        return self._CloudLogRegion

    @CloudLogRegion.setter
    def CloudLogRegion(self, CloudLogRegion):
        self._CloudLogRegion = CloudLogRegion


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._FlowLogId = params.get("FlowLogId")
        self._FlowLogName = params.get("FlowLogName")
        self._ResourceType = params.get("ResourceType")
        self._ResourceId = params.get("ResourceId")
        self._TrafficType = params.get("TrafficType")
        self._CloudLogId = params.get("CloudLogId")
        self._CloudLogState = params.get("CloudLogState")
        self._OrderField = params.get("OrderField")
        self._OrderDirection = params.get("OrderDirection")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = Filter()
            self._Filters._deserialize(params.get("Filters"))
        self._CloudLogRegion = params.get("CloudLogRegion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFlowLogsResponse(AbstractModel):
    """DescribeFlowLogs返回参数结构体

    """

    def __init__(self):
        r"""
        :param _FlowLog: 流日志实例集合。
        :type FlowLog: list of FlowLog
        :param _TotalNum: 流日志总数目。
        :type TotalNum: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._FlowLog = None
        self._TotalNum = None
        self._RequestId = None

    @property
    def FlowLog(self):
        """流日志实例集合。
        :rtype: list of FlowLog
        """
        return self._FlowLog

    @FlowLog.setter
    def FlowLog(self, FlowLog):
        self._FlowLog = FlowLog

    @property
    def TotalNum(self):
        """流日志总数目。
        :rtype: int
        """
        return self._TotalNum

    @TotalNum.setter
    def TotalNum(self, TotalNum):
        self._TotalNum = TotalNum

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("FlowLog") is not None:
            self._FlowLog = []
            for item in params.get("FlowLog"):
                obj = FlowLog()
                obj._deserialize(item)
                self._FlowLog.append(obj)
        self._TotalNum = params.get("TotalNum")
        self._RequestId = params.get("RequestId")


class DescribeGatewayFlowMonitorDetailRequest(AbstractModel):
    """DescribeGatewayFlowMonitorDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TimePoint: 时间点。表示要查询这分钟内的明细。如：`2019-02-28 18:15:20`，将查询 `18:15` 这一分钟内的明细。
        :type TimePoint: str
        :param _VpnId: VPN网关实例ID，形如：`vpn-ltjahce6`。
        :type VpnId: str
        :param _DirectConnectGatewayId: 专线网关实例ID，形如：`dcg-ltjahce6`。
        :type DirectConnectGatewayId: str
        :param _PeeringConnectionId: 对等连接实例ID，形如：`pcx-ltjahce6`。
        :type PeeringConnectionId: str
        :param _NatId: NAT网关实例ID，形如：`nat-ltjahce6`。
        :type NatId: str
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Limit: 返回数量，默认为20，最大值为100。
        :type Limit: int
        :param _OrderField: 排序字段。支持 `InPkg` `OutPkg` `InTraffic` `OutTraffic`，标准型nat额外支持 并发连接数`ConcurrentConnectionCount` 、新建连接速率`NewConnectionRate`。默认值`OutTraffic`。
        :type OrderField: str
        :param _OrderDirection: 排序方法。顺序：`ASC`，倒序：`DESC`。默认值`DESC`。
        :type OrderDirection: str
        :param _PrivateIpAddress: VPC内部IPv4地址，精确匹配
        :type PrivateIpAddress: str
        """
        self._TimePoint = None
        self._VpnId = None
        self._DirectConnectGatewayId = None
        self._PeeringConnectionId = None
        self._NatId = None
        self._Offset = None
        self._Limit = None
        self._OrderField = None
        self._OrderDirection = None
        self._PrivateIpAddress = None

    @property
    def TimePoint(self):
        """时间点。表示要查询这分钟内的明细。如：`2019-02-28 18:15:20`，将查询 `18:15` 这一分钟内的明细。
        :rtype: str
        """
        return self._TimePoint

    @TimePoint.setter
    def TimePoint(self, TimePoint):
        self._TimePoint = TimePoint

    @property
    def VpnId(self):
        """VPN网关实例ID，形如：`vpn-ltjahce6`。
        :rtype: str
        """
        return self._VpnId

    @VpnId.setter
    def VpnId(self, VpnId):
        self._VpnId = VpnId

    @property
    def DirectConnectGatewayId(self):
        """专线网关实例ID，形如：`dcg-ltjahce6`。
        :rtype: str
        """
        return self._DirectConnectGatewayId

    @DirectConnectGatewayId.setter
    def DirectConnectGatewayId(self, DirectConnectGatewayId):
        self._DirectConnectGatewayId = DirectConnectGatewayId

    @property
    def PeeringConnectionId(self):
        """对等连接实例ID，形如：`pcx-ltjahce6`。
        :rtype: str
        """
        return self._PeeringConnectionId

    @PeeringConnectionId.setter
    def PeeringConnectionId(self, PeeringConnectionId):
        self._PeeringConnectionId = PeeringConnectionId

    @property
    def NatId(self):
        """NAT网关实例ID，形如：`nat-ltjahce6`。
        :rtype: str
        """
        return self._NatId

    @NatId.setter
    def NatId(self, NatId):
        self._NatId = NatId

    @property
    def Offset(self):
        """偏移量，默认为0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量，默认为20，最大值为100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def OrderField(self):
        """排序字段。支持 `InPkg` `OutPkg` `InTraffic` `OutTraffic`，标准型nat额外支持 并发连接数`ConcurrentConnectionCount` 、新建连接速率`NewConnectionRate`。默认值`OutTraffic`。
        :rtype: str
        """
        return self._OrderField

    @OrderField.setter
    def OrderField(self, OrderField):
        self._OrderField = OrderField

    @property
    def OrderDirection(self):
        """排序方法。顺序：`ASC`，倒序：`DESC`。默认值`DESC`。
        :rtype: str
        """
        return self._OrderDirection

    @OrderDirection.setter
    def OrderDirection(self, OrderDirection):
        self._OrderDirection = OrderDirection

    @property
    def PrivateIpAddress(self):
        """VPC内部IPv4地址，精确匹配
        :rtype: str
        """
        return self._PrivateIpAddress

    @PrivateIpAddress.setter
    def PrivateIpAddress(self, PrivateIpAddress):
        self._PrivateIpAddress = PrivateIpAddress


    def _deserialize(self, params):
        self._TimePoint = params.get("TimePoint")
        self._VpnId = params.get("VpnId")
        self._DirectConnectGatewayId = params.get("DirectConnectGatewayId")
        self._PeeringConnectionId = params.get("PeeringConnectionId")
        self._NatId = params.get("NatId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._OrderField = params.get("OrderField")
        self._OrderDirection = params.get("OrderDirection")
        self._PrivateIpAddress = params.get("PrivateIpAddress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeGatewayFlowMonitorDetailResponse(AbstractModel):
    """DescribeGatewayFlowMonitorDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合条件的对象数。
        :type TotalCount: int
        :param _GatewayFlowMonitorDetailSet: 网关流量监控明细。
        :type GatewayFlowMonitorDetailSet: list of GatewayFlowMonitorDetail
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._GatewayFlowMonitorDetailSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """符合条件的对象数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def GatewayFlowMonitorDetailSet(self):
        """网关流量监控明细。
        :rtype: list of GatewayFlowMonitorDetail
        """
        return self._GatewayFlowMonitorDetailSet

    @GatewayFlowMonitorDetailSet.setter
    def GatewayFlowMonitorDetailSet(self, GatewayFlowMonitorDetailSet):
        self._GatewayFlowMonitorDetailSet = GatewayFlowMonitorDetailSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("GatewayFlowMonitorDetailSet") is not None:
            self._GatewayFlowMonitorDetailSet = []
            for item in params.get("GatewayFlowMonitorDetailSet"):
                obj = GatewayFlowMonitorDetail()
                obj._deserialize(item)
                self._GatewayFlowMonitorDetailSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeGatewayFlowQosRequest(AbstractModel):
    """DescribeGatewayFlowQos请求参数结构体

    """

    def __init__(self):
        r"""
        :param _GatewayId: 网关实例ID，目前我们支持的网关实例类型有，
专线网关实例ID，形如，`dcg-ltjahce6`；
Nat网关实例ID，形如，`nat-ltjahce6`；
VPN网关实例ID，形如，`vpn-ltjahce6`。
        :type GatewayId: str
        :param _IpAddresses: 限流的云服务器内网IP。
        :type IpAddresses: list of str
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Limit: 返回数量，默认为20，最大值为100。
        :type Limit: int
        """
        self._GatewayId = None
        self._IpAddresses = None
        self._Offset = None
        self._Limit = None

    @property
    def GatewayId(self):
        """网关实例ID，目前我们支持的网关实例类型有，
专线网关实例ID，形如，`dcg-ltjahce6`；
Nat网关实例ID，形如，`nat-ltjahce6`；
VPN网关实例ID，形如，`vpn-ltjahce6`。
        :rtype: str
        """
        return self._GatewayId

    @GatewayId.setter
    def GatewayId(self, GatewayId):
        self._GatewayId = GatewayId

    @property
    def IpAddresses(self):
        """限流的云服务器内网IP。
        :rtype: list of str
        """
        return self._IpAddresses

    @IpAddresses.setter
    def IpAddresses(self, IpAddresses):
        self._IpAddresses = IpAddresses

    @property
    def Offset(self):
        """偏移量，默认为0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量，默认为20，最大值为100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._GatewayId = params.get("GatewayId")
        self._IpAddresses = params.get("IpAddresses")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeGatewayFlowQosResponse(AbstractModel):
    """DescribeGatewayFlowQos返回参数结构体

    """

    def __init__(self):
        r"""
        :param _GatewayQosSet: 实例详细信息列表。
        :type GatewayQosSet: list of GatewayQos
        :param _TotalCount: 符合条件的实例数量。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._GatewayQosSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def GatewayQosSet(self):
        """实例详细信息列表。
        :rtype: list of GatewayQos
        """
        return self._GatewayQosSet

    @GatewayQosSet.setter
    def GatewayQosSet(self, GatewayQosSet):
        self._GatewayQosSet = GatewayQosSet

    @property
    def TotalCount(self):
        """符合条件的实例数量。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("GatewayQosSet") is not None:
            self._GatewayQosSet = []
            for item in params.get("GatewayQosSet"):
                obj = GatewayQos()
                obj._deserialize(item)
                self._GatewayQosSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeHaVipsRequest(AbstractModel):
    """DescribeHaVips请求参数结构体

    """

    def __init__(self):
        r"""
        :param _HaVipIds: `HAVIP`唯一`ID`，形如：`havip-9o233uri`。
        :type HaVipIds: list of str
        :param _Filters: 过滤条件，参数不支持同时指定`HaVipIds`和`Filters`。<li>havip-id - String - `HAVIP`唯一`ID`，形如：`havip-9o233uri`。</li><li>havip-name - String - `HAVIP`名称。</li><li>vpc-id - String - `HAVIP`所在私有网络`ID`。</li><li>subnet-id - String - `HAVIP`所在子网`ID`。</li><li>vip - String - `HAVIP`的地址`VIP`。</li><li>address-ip - String - `HAVIP`绑定的弹性公网`IP`。</li><li>havip-association.instance-id - String - `HAVIP`绑定的子机或网卡。</li><li>havip-association.instance-type - String - `HAVIP`绑定的类型，取值:CVM, ENI。</li><li>check-associate - Bool - 是否开启HaVip飘移时校验绑定的子机或网卡。</li><li>cdc-id - String - CDC实例ID。</li>
        :type Filters: list of Filter
        :param _Offset: 偏移量，默认为0。

        :type Offset: int
        :param _Limit: 返回数量，默认为20，最大值为100。

        :type Limit: int
        """
        self._HaVipIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def HaVipIds(self):
        """`HAVIP`唯一`ID`，形如：`havip-9o233uri`。
        :rtype: list of str
        """
        return self._HaVipIds

    @HaVipIds.setter
    def HaVipIds(self, HaVipIds):
        self._HaVipIds = HaVipIds

    @property
    def Filters(self):
        """过滤条件，参数不支持同时指定`HaVipIds`和`Filters`。<li>havip-id - String - `HAVIP`唯一`ID`，形如：`havip-9o233uri`。</li><li>havip-name - String - `HAVIP`名称。</li><li>vpc-id - String - `HAVIP`所在私有网络`ID`。</li><li>subnet-id - String - `HAVIP`所在子网`ID`。</li><li>vip - String - `HAVIP`的地址`VIP`。</li><li>address-ip - String - `HAVIP`绑定的弹性公网`IP`。</li><li>havip-association.instance-id - String - `HAVIP`绑定的子机或网卡。</li><li>havip-association.instance-type - String - `HAVIP`绑定的类型，取值:CVM, ENI。</li><li>check-associate - Bool - 是否开启HaVip飘移时校验绑定的子机或网卡。</li><li>cdc-id - String - CDC实例ID。</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量，默认为0。

        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量，默认为20，最大值为100。

        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._HaVipIds = params.get("HaVipIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeHaVipsResponse(AbstractModel):
    """DescribeHaVips返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合条件的对象数。
        :type TotalCount: int
        :param _HaVipSet: `HAVIP`对象数组。
        :type HaVipSet: list of HaVip
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._HaVipSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """符合条件的对象数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def HaVipSet(self):
        """`HAVIP`对象数组。
        :rtype: list of HaVip
        """
        return self._HaVipSet

    @HaVipSet.setter
    def HaVipSet(self, HaVipSet):
        self._HaVipSet = HaVipSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("HaVipSet") is not None:
            self._HaVipSet = []
            for item in params.get("HaVipSet"):
                obj = HaVip()
                obj._deserialize(item)
                self._HaVipSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeHighPriorityRouteTablesRequest(AbstractModel):
    """DescribeHighPriorityRouteTables请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤条件，参数不支持同时指定HighPriorityRouteTableIds和Filters。
<li>high-priority-route-table-id - String - （过滤条件）高优路由表实例ID。</li>
<li>name - String - （过滤条件）高优路由表名称。</li>
<li>vpc-id - String - （过滤条件）VPC实例ID，形如：vpc-f49l6u0z。</li>
<li>tag-key - String -是否必填：否 - （过滤条件）按照标签键进行过滤。</li>
<li>next-hop-type - String - 是否必填：否 - （过滤条件）按下一跳类型进行过滤。使用next-hop-type进行过滤时，必须同时携带route-table-id与vpc-id。
目前我们支持的类型有：
HAVIP：高可用虚拟IP；
NORMAL_CVM：普通云服务器；
</li>
        :type Filters: list of Filter
        :param _HighPriorityRouteTableIds: 高优路由表实例ID，例如：hprtb-18mot1fm。
        :type HighPriorityRouteTableIds: list of str
        :param _Offset: 偏移量。
        :type Offset: str
        :param _Limit: 返回数量，默认为20，最大值为100。
        :type Limit: str
        :param _NeedRouterInfo: 是否需要获取路由策略信息，默认获取，当控制台不需要拉取路由策略信息时，改为False。
        :type NeedRouterInfo: bool
        """
        self._Filters = None
        self._HighPriorityRouteTableIds = None
        self._Offset = None
        self._Limit = None
        self._NeedRouterInfo = None

    @property
    def Filters(self):
        """过滤条件，参数不支持同时指定HighPriorityRouteTableIds和Filters。
<li>high-priority-route-table-id - String - （过滤条件）高优路由表实例ID。</li>
<li>name - String - （过滤条件）高优路由表名称。</li>
<li>vpc-id - String - （过滤条件）VPC实例ID，形如：vpc-f49l6u0z。</li>
<li>tag-key - String -是否必填：否 - （过滤条件）按照标签键进行过滤。</li>
<li>next-hop-type - String - 是否必填：否 - （过滤条件）按下一跳类型进行过滤。使用next-hop-type进行过滤时，必须同时携带route-table-id与vpc-id。
目前我们支持的类型有：
HAVIP：高可用虚拟IP；
NORMAL_CVM：普通云服务器；
</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def HighPriorityRouteTableIds(self):
        """高优路由表实例ID，例如：hprtb-18mot1fm。
        :rtype: list of str
        """
        return self._HighPriorityRouteTableIds

    @HighPriorityRouteTableIds.setter
    def HighPriorityRouteTableIds(self, HighPriorityRouteTableIds):
        self._HighPriorityRouteTableIds = HighPriorityRouteTableIds

    @property
    def Offset(self):
        """偏移量。
        :rtype: str
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量，默认为20，最大值为100。
        :rtype: str
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def NeedRouterInfo(self):
        """是否需要获取路由策略信息，默认获取，当控制台不需要拉取路由策略信息时，改为False。
        :rtype: bool
        """
        return self._NeedRouterInfo

    @NeedRouterInfo.setter
    def NeedRouterInfo(self, NeedRouterInfo):
        self._NeedRouterInfo = NeedRouterInfo


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._HighPriorityRouteTableIds = params.get("HighPriorityRouteTableIds")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._NeedRouterInfo = params.get("NeedRouterInfo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeHighPriorityRouteTablesResponse(AbstractModel):
    """DescribeHighPriorityRouteTables返回参数结构体

    """

    def __init__(self):
        r"""
        :param _HighPriorityRouteTableSet: 高优路由表对象。
        :type HighPriorityRouteTableSet: list of HighPriorityRouteTable
        :param _TotalCount: 符合条件的实例数量。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._HighPriorityRouteTableSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def HighPriorityRouteTableSet(self):
        """高优路由表对象。
        :rtype: list of HighPriorityRouteTable
        """
        return self._HighPriorityRouteTableSet

    @HighPriorityRouteTableSet.setter
    def HighPriorityRouteTableSet(self, HighPriorityRouteTableSet):
        self._HighPriorityRouteTableSet = HighPriorityRouteTableSet

    @property
    def TotalCount(self):
        """符合条件的实例数量。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("HighPriorityRouteTableSet") is not None:
            self._HighPriorityRouteTableSet = []
            for item in params.get("HighPriorityRouteTableSet"):
                obj = HighPriorityRouteTable()
                obj._deserialize(item)
                self._HighPriorityRouteTableSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeHighPriorityRoutesRequest(AbstractModel):
    """DescribeHighPriorityRoutes请求参数结构体

    """

    def __init__(self):
        r"""
        :param _HighPriorityRouteTableId: 高优路由表唯一 ID。
        :type HighPriorityRouteTableId: str
        :param _Filters: <li>gateway-id - String - （过滤条件）网关ID。</li>
<li>description - String - （过滤条件）路由描述。</li>
<li>dest-cidr - String - （过滤条件）目的端地址，支持模糊左匹配。</li>
<li>subnet-route-algorithm - String - （过滤条件）现在支持的算法有：ECMP_QUINTUPLE_HASH：五元组hash，ECMP_SOURCE_DESTINATION_IP_HASH：源和目的IP hash，ECMP_DESTINATION_IP_HASH：目的IP hash，ECMP_SOURCE_IP_HASH：源IP hash。</li>
<li>is-cdc - String - （过滤条件）CDC属性高优路由表。</li>
<li>cdc-id - String - （过滤条件）CDC 集群唯一 ID 。</li>

        :type Filters: list of Filter
        :param _Offset: 偏移量。
        :type Offset: int
        :param _Limit: 请求对象个数。
        :type Limit: int
        """
        self._HighPriorityRouteTableId = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def HighPriorityRouteTableId(self):
        """高优路由表唯一 ID。
        :rtype: str
        """
        return self._HighPriorityRouteTableId

    @HighPriorityRouteTableId.setter
    def HighPriorityRouteTableId(self, HighPriorityRouteTableId):
        self._HighPriorityRouteTableId = HighPriorityRouteTableId

    @property
    def Filters(self):
        """<li>gateway-id - String - （过滤条件）网关ID。</li>
<li>description - String - （过滤条件）路由描述。</li>
<li>dest-cidr - String - （过滤条件）目的端地址，支持模糊左匹配。</li>
<li>subnet-route-algorithm - String - （过滤条件）现在支持的算法有：ECMP_QUINTUPLE_HASH：五元组hash，ECMP_SOURCE_DESTINATION_IP_HASH：源和目的IP hash，ECMP_DESTINATION_IP_HASH：目的IP hash，ECMP_SOURCE_IP_HASH：源IP hash。</li>
<li>is-cdc - String - （过滤条件）CDC属性高优路由表。</li>
<li>cdc-id - String - （过滤条件）CDC 集群唯一 ID 。</li>

        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """请求对象个数。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._HighPriorityRouteTableId = params.get("HighPriorityRouteTableId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeHighPriorityRoutesResponse(AbstractModel):
    """DescribeHighPriorityRoutes返回参数结构体

    """

    def __init__(self):
        r"""
        :param _HighPriorityRouteSet: 高优路由表条目信息。
        :type HighPriorityRouteSet: list of HighPriorityRoute
        :param _TotalCount: 高优路由表条目个数。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._HighPriorityRouteSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def HighPriorityRouteSet(self):
        """高优路由表条目信息。
        :rtype: list of HighPriorityRoute
        """
        return self._HighPriorityRouteSet

    @HighPriorityRouteSet.setter
    def HighPriorityRouteSet(self, HighPriorityRouteSet):
        self._HighPriorityRouteSet = HighPriorityRouteSet

    @property
    def TotalCount(self):
        """高优路由表条目个数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("HighPriorityRouteSet") is not None:
            self._HighPriorityRouteSet = []
            for item in params.get("HighPriorityRouteSet"):
                obj = HighPriorityRoute()
                obj._deserialize(item)
                self._HighPriorityRouteSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeIp6AddressesRequest(AbstractModel):
    """DescribeIp6Addresses请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Ip6AddressIds: 标识 IPV6 的唯一 ID 列表。IPV6 唯一 ID 形如：`eip-11112222`。参数不支持同时指定`Ip6AddressIds`和`Filters`。
        :type Ip6AddressIds: list of str
        :param _Filters: 每次请求的`Filters`的上限为10，`Filter.Values`的上限为100。参数不支持同时指定`AddressIds`和`Filters`。详细的过滤条件如下：
<li> address-ip - String - 是否必填：否 - （过滤条件）按照 IPV6 的 IP 地址过滤。</li>
<li> network-interface-id - String - 是否必填：否 - （过滤条件）按照弹性网卡的唯一ID过滤。</li>
        :type Filters: list of Filter
        :param _Offset: 偏移量，默认为0。关于`Offset`的更进一步介绍请参考 API [简介](https://cloud.tencent.com/document/api/213/11646)中的相关小节。
        :type Offset: int
        :param _Limit: 返回数量，默认为20，最大值为100。关于`Limit`的更进一步介绍请参考 API [简介](https://cloud.tencent.com/document/api/213/11646)中的相关小节。
        :type Limit: int
        """
        self._Ip6AddressIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def Ip6AddressIds(self):
        """标识 IPV6 的唯一 ID 列表。IPV6 唯一 ID 形如：`eip-11112222`。参数不支持同时指定`Ip6AddressIds`和`Filters`。
        :rtype: list of str
        """
        return self._Ip6AddressIds

    @Ip6AddressIds.setter
    def Ip6AddressIds(self, Ip6AddressIds):
        self._Ip6AddressIds = Ip6AddressIds

    @property
    def Filters(self):
        """每次请求的`Filters`的上限为10，`Filter.Values`的上限为100。参数不支持同时指定`AddressIds`和`Filters`。详细的过滤条件如下：
<li> address-ip - String - 是否必填：否 - （过滤条件）按照 IPV6 的 IP 地址过滤。</li>
<li> network-interface-id - String - 是否必填：否 - （过滤条件）按照弹性网卡的唯一ID过滤。</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量，默认为0。关于`Offset`的更进一步介绍请参考 API [简介](https://cloud.tencent.com/document/api/213/11646)中的相关小节。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量，默认为20，最大值为100。关于`Limit`的更进一步介绍请参考 API [简介](https://cloud.tencent.com/document/api/213/11646)中的相关小节。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._Ip6AddressIds = params.get("Ip6AddressIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIp6AddressesResponse(AbstractModel):
    """DescribeIp6Addresses返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合条件的 IPV6 数量。
        :type TotalCount: int
        :param _AddressSet: IPV6 详细信息列表。
        :type AddressSet: list of Address
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._AddressSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """符合条件的 IPV6 数量。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AddressSet(self):
        """IPV6 详细信息列表。
        :rtype: list of Address
        """
        return self._AddressSet

    @AddressSet.setter
    def AddressSet(self, AddressSet):
        self._AddressSet = AddressSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AddressSet") is not None:
            self._AddressSet = []
            for item in params.get("AddressSet"):
                obj = Address()
                obj._deserialize(item)
                self._AddressSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeIp6TranslatorQuotaRequest(AbstractModel):
    """DescribeIp6TranslatorQuota请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Ip6TranslatorIds: 待查询IPV6转换实例的唯一ID列表，形如ip6-xxxxxxxx
        :type Ip6TranslatorIds: list of str
        """
        self._Ip6TranslatorIds = None

    @property
    def Ip6TranslatorIds(self):
        """待查询IPV6转换实例的唯一ID列表，形如ip6-xxxxxxxx
        :rtype: list of str
        """
        return self._Ip6TranslatorIds

    @Ip6TranslatorIds.setter
    def Ip6TranslatorIds(self, Ip6TranslatorIds):
        self._Ip6TranslatorIds = Ip6TranslatorIds


    def _deserialize(self, params):
        self._Ip6TranslatorIds = params.get("Ip6TranslatorIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIp6TranslatorQuotaResponse(AbstractModel):
    """DescribeIp6TranslatorQuota返回参数结构体

    """

    def __init__(self):
        r"""
        :param _QuotaSet: 账户在指定地域的IPV6转换实例及规则配额信息
QUOTAID属性是TOTAL_TRANSLATOR_QUOTA，表示账户在指定地域的IPV6转换实例配额信息；QUOTAID属性是IPV6转换实例唯一ID（形如ip6-xxxxxxxx），表示账户在该转换实例允许创建的转换规则配额
        :type QuotaSet: list of Quota
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._QuotaSet = None
        self._RequestId = None

    @property
    def QuotaSet(self):
        """账户在指定地域的IPV6转换实例及规则配额信息
QUOTAID属性是TOTAL_TRANSLATOR_QUOTA，表示账户在指定地域的IPV6转换实例配额信息；QUOTAID属性是IPV6转换实例唯一ID（形如ip6-xxxxxxxx），表示账户在该转换实例允许创建的转换规则配额
        :rtype: list of Quota
        """
        return self._QuotaSet

    @QuotaSet.setter
    def QuotaSet(self, QuotaSet):
        self._QuotaSet = QuotaSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("QuotaSet") is not None:
            self._QuotaSet = []
            for item in params.get("QuotaSet"):
                obj = Quota()
                obj._deserialize(item)
                self._QuotaSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeIp6TranslatorsRequest(AbstractModel):
    """DescribeIp6Translators请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Ip6TranslatorIds: IPV6转换实例唯一ID数组，形如ip6-xxxxxxxx
        :type Ip6TranslatorIds: list of str
        :param _Filters: 每次请求的`Filters`的上限为10，`Filter.Values`的上限为5。参数不支持同时指定`Ip6TranslatorIds`和`Filters`。详细的过滤条件如下：
<li> ip6-translator-id - String - 是否必填：否 - （过滤条件）按照IPV6转换实例的唯一ID过滤,形如ip6-xxxxxxx。</li>
<li> ip6-translator-vip6 - String - 是否必填：否 - （过滤条件）按照IPV6地址过滤。不支持模糊过滤。</li>
<li> ip6-translator-name - String - 是否必填：否 - （过滤条件）按照IPV6转换实例名称过滤。不支持模糊过滤。</li>
<li> ip6-translator-status - String - 是否必填：否 - （过滤条件）按照IPV6转换实例的状态过滤。状态取值范围为"CREATING","RUNNING","DELETING","MODIFYING"。</li>
        :type Filters: list of Filter
        :param _Offset: 偏移量，默认为0。关于`Offset`的更进一步介绍请参考 API [简介](https://cloud.tencent.com/document/api/213/11646)中的相关小节。
        :type Offset: int
        :param _Limit: 返回数量，默认为20，最大值为100。关于`Limit`的更进一步介绍请参考 API [简介](https://cloud.tencent.com/document/api/213/11646)中的相关小节。
        :type Limit: int
        """
        self._Ip6TranslatorIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def Ip6TranslatorIds(self):
        """IPV6转换实例唯一ID数组，形如ip6-xxxxxxxx
        :rtype: list of str
        """
        return self._Ip6TranslatorIds

    @Ip6TranslatorIds.setter
    def Ip6TranslatorIds(self, Ip6TranslatorIds):
        self._Ip6TranslatorIds = Ip6TranslatorIds

    @property
    def Filters(self):
        """每次请求的`Filters`的上限为10，`Filter.Values`的上限为5。参数不支持同时指定`Ip6TranslatorIds`和`Filters`。详细的过滤条件如下：
<li> ip6-translator-id - String - 是否必填：否 - （过滤条件）按照IPV6转换实例的唯一ID过滤,形如ip6-xxxxxxx。</li>
<li> ip6-translator-vip6 - String - 是否必填：否 - （过滤条件）按照IPV6地址过滤。不支持模糊过滤。</li>
<li> ip6-translator-name - String - 是否必填：否 - （过滤条件）按照IPV6转换实例名称过滤。不支持模糊过滤。</li>
<li> ip6-translator-status - String - 是否必填：否 - （过滤条件）按照IPV6转换实例的状态过滤。状态取值范围为"CREATING","RUNNING","DELETING","MODIFYING"。</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量，默认为0。关于`Offset`的更进一步介绍请参考 API [简介](https://cloud.tencent.com/document/api/213/11646)中的相关小节。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量，默认为20，最大值为100。关于`Limit`的更进一步介绍请参考 API [简介](https://cloud.tencent.com/document/api/213/11646)中的相关小节。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._Ip6TranslatorIds = params.get("Ip6TranslatorIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIp6TranslatorsResponse(AbstractModel):
    """DescribeIp6Translators返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合过滤条件的IPV6转换实例数量。
        :type TotalCount: int
        :param _Ip6TranslatorSet: 符合过滤条件的IPV6转换实例详细信息
        :type Ip6TranslatorSet: list of Ip6Translator
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._Ip6TranslatorSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """符合过滤条件的IPV6转换实例数量。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Ip6TranslatorSet(self):
        """符合过滤条件的IPV6转换实例详细信息
        :rtype: list of Ip6Translator
        """
        return self._Ip6TranslatorSet

    @Ip6TranslatorSet.setter
    def Ip6TranslatorSet(self, Ip6TranslatorSet):
        self._Ip6TranslatorSet = Ip6TranslatorSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Ip6TranslatorSet") is not None:
            self._Ip6TranslatorSet = []
            for item in params.get("Ip6TranslatorSet"):
                obj = Ip6Translator()
                obj._deserialize(item)
                self._Ip6TranslatorSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeIpGeolocationDatabaseUrlRequest(AbstractModel):
    """DescribeIpGeolocationDatabaseUrl请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Type: IP地理位置库协议类型，目前仅支持"ipv4"。
        :type Type: str
        """
        self._Type = None

    @property
    def Type(self):
        """IP地理位置库协议类型，目前仅支持"ipv4"。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIpGeolocationDatabaseUrlResponse(AbstractModel):
    """DescribeIpGeolocationDatabaseUrl返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DownLoadUrl: IP地理位置库下载链接地址。
        :type DownLoadUrl: str
        :param _ExpiredAt: 链接到期时间。按照`ISO8601`标准表示，并且使用`UTC`时间。
        :type ExpiredAt: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DownLoadUrl = None
        self._ExpiredAt = None
        self._RequestId = None

    @property
    def DownLoadUrl(self):
        """IP地理位置库下载链接地址。
        :rtype: str
        """
        return self._DownLoadUrl

    @DownLoadUrl.setter
    def DownLoadUrl(self, DownLoadUrl):
        self._DownLoadUrl = DownLoadUrl

    @property
    def ExpiredAt(self):
        """链接到期时间。按照`ISO8601`标准表示，并且使用`UTC`时间。
        :rtype: str
        """
        return self._ExpiredAt

    @ExpiredAt.setter
    def ExpiredAt(self, ExpiredAt):
        self._ExpiredAt = ExpiredAt

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownLoadUrl = params.get("DownLoadUrl")
        self._ExpiredAt = params.get("ExpiredAt")
        self._RequestId = params.get("RequestId")


class DescribeIpGeolocationInfosRequest(AbstractModel):
    """DescribeIpGeolocationInfos请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AddressIps: 需查询的IP地址列表，目前仅支持IPv4地址。查询的IP地址数量上限为100个。
        :type AddressIps: list of str
        :param _Fields: 需查询的IP地址的字段信息。
        :type Fields: :class:`tencentcloud.vpc.v20170312.models.IpField`
        """
        self._AddressIps = None
        self._Fields = None

    @property
    def AddressIps(self):
        """需查询的IP地址列表，目前仅支持IPv4地址。查询的IP地址数量上限为100个。
        :rtype: list of str
        """
        return self._AddressIps

    @AddressIps.setter
    def AddressIps(self, AddressIps):
        self._AddressIps = AddressIps

    @property
    def Fields(self):
        """需查询的IP地址的字段信息。
        :rtype: :class:`tencentcloud.vpc.v20170312.models.IpField`
        """
        return self._Fields

    @Fields.setter
    def Fields(self, Fields):
        self._Fields = Fields


    def _deserialize(self, params):
        self._AddressIps = params.get("AddressIps")
        if params.get("Fields") is not None:
            self._Fields = IpField()
            self._Fields._deserialize(params.get("Fields"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIpGeolocationInfosResponse(AbstractModel):
    """DescribeIpGeolocationInfos返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AddressInfo: IP地址信息列表。
        :type AddressInfo: list of IpGeolocationInfo
        :param _Total: IP地址信息个数。
        :type Total: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AddressInfo = None
        self._Total = None
        self._RequestId = None

    @property
    def AddressInfo(self):
        """IP地址信息列表。
        :rtype: list of IpGeolocationInfo
        """
        return self._AddressInfo

    @AddressInfo.setter
    def AddressInfo(self, AddressInfo):
        self._AddressInfo = AddressInfo

    @property
    def Total(self):
        """IP地址信息个数。
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("AddressInfo") is not None:
            self._AddressInfo = []
            for item in params.get("AddressInfo"):
                obj = IpGeolocationInfo()
                obj._deserialize(item)
                self._AddressInfo.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeLocalGatewayRequest(AbstractModel):
    """DescribeLocalGateway请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 查询条件：
vpc-id：按照VPCID过滤，local-gateway-name：按照本地网关名称过滤，名称支持模糊搜索，local-gateway-id：按照本地网关实例ID过滤，cdc-id：按照cdc实例ID过滤查询。
        :type Filters: list of Filter
        :param _Offset: 偏移量，默认为0。关于`Offset`的更进一步介绍请参考 API [简介](https://cloud.tencent.com/document/api/213/11646)中的相关小节。
        :type Offset: int
        :param _Limit: 返回数量，默认为20，最大值为100。关于`Limit`的更进一步介绍请参考 API [简介](https://cloud.tencent.com/document/api/213/11646)中的相关小节。
        :type Limit: int
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def Filters(self):
        """查询条件：
vpc-id：按照VPCID过滤，local-gateway-name：按照本地网关名称过滤，名称支持模糊搜索，local-gateway-id：按照本地网关实例ID过滤，cdc-id：按照cdc实例ID过滤查询。
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量，默认为0。关于`Offset`的更进一步介绍请参考 API [简介](https://cloud.tencent.com/document/api/213/11646)中的相关小节。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量，默认为20，最大值为100。关于`Limit`的更进一步介绍请参考 API [简介](https://cloud.tencent.com/document/api/213/11646)中的相关小节。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLocalGatewayResponse(AbstractModel):
    """DescribeLocalGateway返回参数结构体

    """

    def __init__(self):
        r"""
        :param _LocalGatewaySet: 本地网关信息集合。
        :type LocalGatewaySet: list of LocalGateway
        :param _TotalCount: 本地网关总数。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._LocalGatewaySet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def LocalGatewaySet(self):
        """本地网关信息集合。
        :rtype: list of LocalGateway
        """
        return self._LocalGatewaySet

    @LocalGatewaySet.setter
    def LocalGatewaySet(self, LocalGatewaySet):
        self._LocalGatewaySet = LocalGatewaySet

    @property
    def TotalCount(self):
        """本地网关总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("LocalGatewaySet") is not None:
            self._LocalGatewaySet = []
            for item in params.get("LocalGatewaySet"):
                obj = LocalGateway()
                obj._deserialize(item)
                self._LocalGatewaySet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeNatGatewayDestinationIpPortTranslationNatRulesRequest(AbstractModel):
    """DescribeNatGatewayDestinationIpPortTranslationNatRules请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NatGatewayIds: NAT网关ID。
        :type NatGatewayIds: list of str
        :param _Filters: 过滤条件:
参数不支持同时指定NatGatewayIds和Filters。每次请求的Filters的上限为10，Filter.Values的上限为5
<li> nat-gateway-id，NAT网关的ID，如`nat-0yi4hekt`</li>
<li> vpc-id，私有网络VPC的ID，如`vpc-0yi4hekt`</li>
<li> public-ip-address， 弹性IP，如`139.199.232.238`。</li>
<li>public-port， 公网端口。</li>
<li>private-ip-address， 内网IP，如`10.0.0.1`。</li>
<li>private-port， 内网端口。</li>
<li>description，规则描述。</li>
        :type Filters: list of Filter
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Limit: 返回数量，默认为20，最大值为100。
        :type Limit: int
        """
        self._NatGatewayIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def NatGatewayIds(self):
        """NAT网关ID。
        :rtype: list of str
        """
        return self._NatGatewayIds

    @NatGatewayIds.setter
    def NatGatewayIds(self, NatGatewayIds):
        self._NatGatewayIds = NatGatewayIds

    @property
    def Filters(self):
        """过滤条件:
参数不支持同时指定NatGatewayIds和Filters。每次请求的Filters的上限为10，Filter.Values的上限为5
<li> nat-gateway-id，NAT网关的ID，如`nat-0yi4hekt`</li>
<li> vpc-id，私有网络VPC的ID，如`vpc-0yi4hekt`</li>
<li> public-ip-address， 弹性IP，如`139.199.232.238`。</li>
<li>public-port， 公网端口。</li>
<li>private-ip-address， 内网IP，如`10.0.0.1`。</li>
<li>private-port， 内网端口。</li>
<li>description，规则描述。</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量，默认为0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量，默认为20，最大值为100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._NatGatewayIds = params.get("NatGatewayIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNatGatewayDestinationIpPortTranslationNatRulesResponse(AbstractModel):
    """DescribeNatGatewayDestinationIpPortTranslationNatRules返回参数结构体

    """

    def __init__(self):
        r"""
        :param _NatGatewayDestinationIpPortTranslationNatRuleSet: NAT网关端口转发规则对象数组。
        :type NatGatewayDestinationIpPortTranslationNatRuleSet: list of NatGatewayDestinationIpPortTranslationNatRule
        :param _TotalCount: 符合条件的NAT网关端口转发规则对象数目。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._NatGatewayDestinationIpPortTranslationNatRuleSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def NatGatewayDestinationIpPortTranslationNatRuleSet(self):
        """NAT网关端口转发规则对象数组。
        :rtype: list of NatGatewayDestinationIpPortTranslationNatRule
        """
        return self._NatGatewayDestinationIpPortTranslationNatRuleSet

    @NatGatewayDestinationIpPortTranslationNatRuleSet.setter
    def NatGatewayDestinationIpPortTranslationNatRuleSet(self, NatGatewayDestinationIpPortTranslationNatRuleSet):
        self._NatGatewayDestinationIpPortTranslationNatRuleSet = NatGatewayDestinationIpPortTranslationNatRuleSet

    @property
    def TotalCount(self):
        """符合条件的NAT网关端口转发规则对象数目。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NatGatewayDestinationIpPortTranslationNatRuleSet") is not None:
            self._NatGatewayDestinationIpPortTranslationNatRuleSet = []
            for item in params.get("NatGatewayDestinationIpPortTranslationNatRuleSet"):
                obj = NatGatewayDestinationIpPortTranslationNatRule()
                obj._deserialize(item)
                self._NatGatewayDestinationIpPortTranslationNatRuleSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeNatGatewayDirectConnectGatewayRouteRequest(AbstractModel):
    """DescribeNatGatewayDirectConnectGatewayRoute请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NatGatewayId: nat的唯一标识
        :type NatGatewayId: str
        :param _VpcId: vpc的唯一标识
        :type VpcId: str
        :param _Limit: 0到200之间
        :type Limit: int
        :param _Offset: 大于0
        :type Offset: int
        """
        self._NatGatewayId = None
        self._VpcId = None
        self._Limit = None
        self._Offset = None

    @property
    def NatGatewayId(self):
        """nat的唯一标识
        :rtype: str
        """
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId

    @property
    def VpcId(self):
        """vpc的唯一标识
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def Limit(self):
        """0到200之间
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        """大于0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._NatGatewayId = params.get("NatGatewayId")
        self._VpcId = params.get("VpcId")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNatGatewayDirectConnectGatewayRouteResponse(AbstractModel):
    """DescribeNatGatewayDirectConnectGatewayRoute返回参数结构体

    """

    def __init__(self):
        r"""
        :param _NatDirectConnectGatewayRouteSet: 路由数据
        :type NatDirectConnectGatewayRouteSet: list of NatDirectConnectGatewayRoute
        :param _Total: 路由总数
        :type Total: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._NatDirectConnectGatewayRouteSet = None
        self._Total = None
        self._RequestId = None

    @property
    def NatDirectConnectGatewayRouteSet(self):
        """路由数据
        :rtype: list of NatDirectConnectGatewayRoute
        """
        return self._NatDirectConnectGatewayRouteSet

    @NatDirectConnectGatewayRouteSet.setter
    def NatDirectConnectGatewayRouteSet(self, NatDirectConnectGatewayRouteSet):
        self._NatDirectConnectGatewayRouteSet = NatDirectConnectGatewayRouteSet

    @property
    def Total(self):
        """路由总数
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NatDirectConnectGatewayRouteSet") is not None:
            self._NatDirectConnectGatewayRouteSet = []
            for item in params.get("NatDirectConnectGatewayRouteSet"):
                obj = NatDirectConnectGatewayRoute()
                obj._deserialize(item)
                self._NatDirectConnectGatewayRouteSet.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeNatGatewaySourceIpTranslationNatRulesRequest(AbstractModel):
    """DescribeNatGatewaySourceIpTranslationNatRules请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NatGatewayId: NAT网关统一 ID，形如：`nat-123xx454`。
        :type NatGatewayId: str
        :param _Filters: 过滤条件:
<li> resource-id，Subnet的ID或者Cvm ID，如`subnet-0yi4hekt`</li>
<li> public-ip-address，弹性IP，如`139.199.232.238`</li>
<li>description，规则描述。</li>
        :type Filters: list of Filter
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Limit: 返回数量，默认为20，最大值为100。
        :type Limit: int
        """
        self._NatGatewayId = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def NatGatewayId(self):
        """NAT网关统一 ID，形如：`nat-123xx454`。
        :rtype: str
        """
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId

    @property
    def Filters(self):
        """过滤条件:
<li> resource-id，Subnet的ID或者Cvm ID，如`subnet-0yi4hekt`</li>
<li> public-ip-address，弹性IP，如`139.199.232.238`</li>
<li>description，规则描述。</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量，默认为0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量，默认为20，最大值为100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._NatGatewayId = params.get("NatGatewayId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNatGatewaySourceIpTranslationNatRulesResponse(AbstractModel):
    """DescribeNatGatewaySourceIpTranslationNatRules返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SourceIpTranslationNatRuleSet: NAT网关SNAT规则对象数组。
注意：此字段可能返回 null，表示取不到有效值。
        :type SourceIpTranslationNatRuleSet: list of SourceIpTranslationNatRule
        :param _TotalCount: 符合条件的NAT网关端口转发规则对象数目。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SourceIpTranslationNatRuleSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SourceIpTranslationNatRuleSet(self):
        """NAT网关SNAT规则对象数组。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of SourceIpTranslationNatRule
        """
        return self._SourceIpTranslationNatRuleSet

    @SourceIpTranslationNatRuleSet.setter
    def SourceIpTranslationNatRuleSet(self, SourceIpTranslationNatRuleSet):
        self._SourceIpTranslationNatRuleSet = SourceIpTranslationNatRuleSet

    @property
    def TotalCount(self):
        """符合条件的NAT网关端口转发规则对象数目。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SourceIpTranslationNatRuleSet") is not None:
            self._SourceIpTranslationNatRuleSet = []
            for item in params.get("SourceIpTranslationNatRuleSet"):
                obj = SourceIpTranslationNatRule()
                obj._deserialize(item)
                self._SourceIpTranslationNatRuleSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeNatGatewaysRequest(AbstractModel):
    """DescribeNatGateways请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NatGatewayIds: NAT网关统一 ID，形如：`nat-123xx454`。每次请求的实例上限为100。参数不支持同时指定NatGatewayIds和Filters。
        :type NatGatewayIds: list of str
        :param _Filters: 过滤条件，参数不支持同时指定NatGatewayIds和Filters。每次请求的Filters的上限为10，Filter.Values的上限为5。
<li>nat-gateway-id - String - （过滤条件）协议端口模板实例ID，形如：`nat-123xx454`。</li>
<li>vpc-id - String - （过滤条件）私有网络 唯一ID，形如：`vpc-123xx454`。</li>
<li>nat-gateway-name - String - （过滤条件）协议端口模板实例ID，形如：`test_nat`。</li>
<li>tag-key - String - （过滤条件）标签键，形如：`test-key`。</li>
        :type Filters: list of Filter
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Limit: 返回数量，默认为20，最大值为100。
        :type Limit: int
        """
        self._NatGatewayIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def NatGatewayIds(self):
        """NAT网关统一 ID，形如：`nat-123xx454`。每次请求的实例上限为100。参数不支持同时指定NatGatewayIds和Filters。
        :rtype: list of str
        """
        return self._NatGatewayIds

    @NatGatewayIds.setter
    def NatGatewayIds(self, NatGatewayIds):
        self._NatGatewayIds = NatGatewayIds

    @property
    def Filters(self):
        """过滤条件，参数不支持同时指定NatGatewayIds和Filters。每次请求的Filters的上限为10，Filter.Values的上限为5。
<li>nat-gateway-id - String - （过滤条件）协议端口模板实例ID，形如：`nat-123xx454`。</li>
<li>vpc-id - String - （过滤条件）私有网络 唯一ID，形如：`vpc-123xx454`。</li>
<li>nat-gateway-name - String - （过滤条件）协议端口模板实例ID，形如：`test_nat`。</li>
<li>tag-key - String - （过滤条件）标签键，形如：`test-key`。</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量，默认为0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量，默认为20，最大值为100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._NatGatewayIds = params.get("NatGatewayIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNatGatewaysResponse(AbstractModel):
    """DescribeNatGateways返回参数结构体

    """

    def __init__(self):
        r"""
        :param _NatGatewaySet: NAT网关对象数组。
        :type NatGatewaySet: list of NatGateway
        :param _TotalCount: 符合条件的NAT网关对象个数。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._NatGatewaySet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def NatGatewaySet(self):
        """NAT网关对象数组。
        :rtype: list of NatGateway
        """
        return self._NatGatewaySet

    @NatGatewaySet.setter
    def NatGatewaySet(self, NatGatewaySet):
        self._NatGatewaySet = NatGatewaySet

    @property
    def TotalCount(self):
        """符合条件的NAT网关对象个数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NatGatewaySet") is not None:
            self._NatGatewaySet = []
            for item in params.get("NatGatewaySet"):
                obj = NatGateway()
                obj._deserialize(item)
                self._NatGatewaySet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeNetDetectStatesRequest(AbstractModel):
    """DescribeNetDetectStates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NetDetectIds: 网络探测实例`ID`数组。形如：[`netd-12345678`]。
        :type NetDetectIds: list of str
        :param _Filters: 过滤条件，参数不支持同时指定NetDetectIds和Filters。
<li>net-detect-id - String - （过滤条件）网络探测实例ID，形如：netd-12345678。</li>
        :type Filters: list of Filter
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Limit: 返回数量，默认为20，最大值为100。
        :type Limit: int
        """
        self._NetDetectIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def NetDetectIds(self):
        """网络探测实例`ID`数组。形如：[`netd-12345678`]。
        :rtype: list of str
        """
        return self._NetDetectIds

    @NetDetectIds.setter
    def NetDetectIds(self, NetDetectIds):
        self._NetDetectIds = NetDetectIds

    @property
    def Filters(self):
        """过滤条件，参数不支持同时指定NetDetectIds和Filters。
<li>net-detect-id - String - （过滤条件）网络探测实例ID，形如：netd-12345678。</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量，默认为0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量，默认为20，最大值为100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._NetDetectIds = params.get("NetDetectIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetDetectStatesResponse(AbstractModel):
    """DescribeNetDetectStates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _NetDetectStateSet: 符合条件的网络探测验证结果对象数组。
        :type NetDetectStateSet: list of NetDetectState
        :param _TotalCount: 符合条件的网络探测验证结果对象数量。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._NetDetectStateSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def NetDetectStateSet(self):
        """符合条件的网络探测验证结果对象数组。
        :rtype: list of NetDetectState
        """
        return self._NetDetectStateSet

    @NetDetectStateSet.setter
    def NetDetectStateSet(self, NetDetectStateSet):
        self._NetDetectStateSet = NetDetectStateSet

    @property
    def TotalCount(self):
        """符合条件的网络探测验证结果对象数量。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NetDetectStateSet") is not None:
            self._NetDetectStateSet = []
            for item in params.get("NetDetectStateSet"):
                obj = NetDetectState()
                obj._deserialize(item)
                self._NetDetectStateSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeNetDetectsRequest(AbstractModel):
    """DescribeNetDetects请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NetDetectIds: 网络探测实例`ID`数组。形如：[`netd-12345678`]。
        :type NetDetectIds: list of str
        :param _Filters: 过滤条件，参数不支持同时指定NetDetectIds和Filters。
<li>vpc-id - String - （过滤条件）VPC实例ID，形如：vpc-12345678</li>
<li>net-detect-id - String - （过滤条件）网络探测实例ID，形如：netd-12345678</li>
<li>subnet-id - String - （过滤条件）子网实例ID，形如：subnet-12345678</li>
<li>net-detect-name - String - （过滤条件）网络探测名称</li>
        :type Filters: list of Filter
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Limit: 返回数量，默认为20，最大值为100。
        :type Limit: int
        """
        self._NetDetectIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def NetDetectIds(self):
        """网络探测实例`ID`数组。形如：[`netd-12345678`]。
        :rtype: list of str
        """
        return self._NetDetectIds

    @NetDetectIds.setter
    def NetDetectIds(self, NetDetectIds):
        self._NetDetectIds = NetDetectIds

    @property
    def Filters(self):
        """过滤条件，参数不支持同时指定NetDetectIds和Filters。
<li>vpc-id - String - （过滤条件）VPC实例ID，形如：vpc-12345678</li>
<li>net-detect-id - String - （过滤条件）网络探测实例ID，形如：netd-12345678</li>
<li>subnet-id - String - （过滤条件）子网实例ID，形如：subnet-12345678</li>
<li>net-detect-name - String - （过滤条件）网络探测名称</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量，默认为0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量，默认为20，最大值为100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._NetDetectIds = params.get("NetDetectIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetDetectsResponse(AbstractModel):
    """DescribeNetDetects返回参数结构体

    """

    def __init__(self):
        r"""
        :param _NetDetectSet: 符合条件的网络探测对象数组。
        :type NetDetectSet: list of NetDetect
        :param _TotalCount: 符合条件的网络探测对象数量。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._NetDetectSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def NetDetectSet(self):
        """符合条件的网络探测对象数组。
        :rtype: list of NetDetect
        """
        return self._NetDetectSet

    @NetDetectSet.setter
    def NetDetectSet(self, NetDetectSet):
        self._NetDetectSet = NetDetectSet

    @property
    def TotalCount(self):
        """符合条件的网络探测对象数量。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NetDetectSet") is not None:
            self._NetDetectSet = []
            for item in params.get("NetDetectSet"):
                obj = NetDetect()
                obj._deserialize(item)
                self._NetDetectSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeNetworkAccountTypeRequest(AbstractModel):
    """DescribeNetworkAccountType请求参数结构体

    """


class DescribeNetworkAccountTypeResponse(AbstractModel):
    """DescribeNetworkAccountType返回参数结构体

    """

    def __init__(self):
        r"""
        :param _NetworkAccountType: 用户账号的网络类型，STANDARD为标准用户，LEGACY为传统用户
        :type NetworkAccountType: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._NetworkAccountType = None
        self._RequestId = None

    @property
    def NetworkAccountType(self):
        """用户账号的网络类型，STANDARD为标准用户，LEGACY为传统用户
        :rtype: str
        """
        return self._NetworkAccountType

    @NetworkAccountType.setter
    def NetworkAccountType(self, NetworkAccountType):
        self._NetworkAccountType = NetworkAccountType

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._NetworkAccountType = params.get("NetworkAccountType")
        self._RequestId = params.get("RequestId")


class DescribeNetworkAclQuintupleEntriesRequest(AbstractModel):
    """DescribeNetworkAclQuintupleEntries请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NetworkAclId: 网络ACL实例ID。形如：acl-12345678。
        :type NetworkAclId: str
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Limit: 返回数量，默认为20，最小值为1，最大值为100。
        :type Limit: int
        :param _Filters: 过滤条件，参数不支持同时指定`NetworkAclId`和`Filters`。
<li>protocol - String - 协议，形如：`TCP`。</li>
<li>description - String - 描述。</li>
<li>destination-cidr - String - 目的CIDR， 形如：'192.168.0.0/24'。</li>
<li>source-cidr- String - 源CIDR， 形如：'192.168.0.0/24'。</li>
<li>action - String - 动作，形如ACCEPT或DROP。</li>
<li>network-acl-quintuple-entry-id - String - 五元组唯一ID，形如：'acli45-ahnu4rv5'。</li>
<li>network-acl-direction - String - 方向，形如：'INGRESS'或'EGRESS'。</li>
        :type Filters: list of Filter
        """
        self._NetworkAclId = None
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def NetworkAclId(self):
        """网络ACL实例ID。形如：acl-12345678。
        :rtype: str
        """
        return self._NetworkAclId

    @NetworkAclId.setter
    def NetworkAclId(self, NetworkAclId):
        self._NetworkAclId = NetworkAclId

    @property
    def Offset(self):
        """偏移量，默认为0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量，默认为20，最小值为1，最大值为100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        """过滤条件，参数不支持同时指定`NetworkAclId`和`Filters`。
<li>protocol - String - 协议，形如：`TCP`。</li>
<li>description - String - 描述。</li>
<li>destination-cidr - String - 目的CIDR， 形如：'192.168.0.0/24'。</li>
<li>source-cidr- String - 源CIDR， 形如：'192.168.0.0/24'。</li>
<li>action - String - 动作，形如ACCEPT或DROP。</li>
<li>network-acl-quintuple-entry-id - String - 五元组唯一ID，形如：'acli45-ahnu4rv5'。</li>
<li>network-acl-direction - String - 方向，形如：'INGRESS'或'EGRESS'。</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._NetworkAclId = params.get("NetworkAclId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetworkAclQuintupleEntriesResponse(AbstractModel):
    """DescribeNetworkAclQuintupleEntries返回参数结构体

    """

    def __init__(self):
        r"""
        :param _NetworkAclQuintupleSet: 网络ACL条目列表（NetworkAclTuple5Entry）
        :type NetworkAclQuintupleSet: list of NetworkAclQuintupleEntry
        :param _TotalCount: 符合条件的实例数量。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._NetworkAclQuintupleSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def NetworkAclQuintupleSet(self):
        """网络ACL条目列表（NetworkAclTuple5Entry）
        :rtype: list of NetworkAclQuintupleEntry
        """
        return self._NetworkAclQuintupleSet

    @NetworkAclQuintupleSet.setter
    def NetworkAclQuintupleSet(self, NetworkAclQuintupleSet):
        self._NetworkAclQuintupleSet = NetworkAclQuintupleSet

    @property
    def TotalCount(self):
        """符合条件的实例数量。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NetworkAclQuintupleSet") is not None:
            self._NetworkAclQuintupleSet = []
            for item in params.get("NetworkAclQuintupleSet"):
                obj = NetworkAclQuintupleEntry()
                obj._deserialize(item)
                self._NetworkAclQuintupleSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeNetworkAclsRequest(AbstractModel):
    """DescribeNetworkAcls请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤条件，参数不支持同时指定NetworkAclIds和Filters。
<li>vpc-id - String - （过滤条件）VPC实例ID，形如：vpc-12345678。</li>
<li>network-acl-id - String - （过滤条件）网络ACL实例ID，形如：acl-12345678。</li>
<li>network-acl-name - String - （过滤条件）网络ACL实例名称。</li>
        :type Filters: list of Filter
        :param _NetworkAclIds: 网络ACL实例ID数组。形如：[acl-12345678]。每次请求的实例的上限为100。参数不支持同时指定NetworkAclIds和Filters。
        :type NetworkAclIds: list of str
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Limit: 返回数量，默认为20，最小值为1，最大值为100。
        :type Limit: int
        :param _OrderField: 排序字段。支持：NetworkAclId,NetworkAclName,CreatedTime
        :type OrderField: str
        :param _OrderDirection: 排序方法。顺序：ASC，倒序：DESC。
        :type OrderDirection: str
        """
        self._Filters = None
        self._NetworkAclIds = None
        self._Offset = None
        self._Limit = None
        self._OrderField = None
        self._OrderDirection = None

    @property
    def Filters(self):
        """过滤条件，参数不支持同时指定NetworkAclIds和Filters。
<li>vpc-id - String - （过滤条件）VPC实例ID，形如：vpc-12345678。</li>
<li>network-acl-id - String - （过滤条件）网络ACL实例ID，形如：acl-12345678。</li>
<li>network-acl-name - String - （过滤条件）网络ACL实例名称。</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def NetworkAclIds(self):
        """网络ACL实例ID数组。形如：[acl-12345678]。每次请求的实例的上限为100。参数不支持同时指定NetworkAclIds和Filters。
        :rtype: list of str
        """
        return self._NetworkAclIds

    @NetworkAclIds.setter
    def NetworkAclIds(self, NetworkAclIds):
        self._NetworkAclIds = NetworkAclIds

    @property
    def Offset(self):
        """偏移量，默认为0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量，默认为20，最小值为1，最大值为100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def OrderField(self):
        """排序字段。支持：NetworkAclId,NetworkAclName,CreatedTime
        :rtype: str
        """
        return self._OrderField

    @OrderField.setter
    def OrderField(self, OrderField):
        self._OrderField = OrderField

    @property
    def OrderDirection(self):
        """排序方法。顺序：ASC，倒序：DESC。
        :rtype: str
        """
        return self._OrderDirection

    @OrderDirection.setter
    def OrderDirection(self, OrderDirection):
        self._OrderDirection = OrderDirection


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._NetworkAclIds = params.get("NetworkAclIds")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._OrderField = params.get("OrderField")
        self._OrderDirection = params.get("OrderDirection")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetworkAclsResponse(AbstractModel):
    """DescribeNetworkAcls返回参数结构体

    """

    def __init__(self):
        r"""
        :param _NetworkAclSet: 实例详细信息列表。
        :type NetworkAclSet: list of NetworkAcl
        :param _TotalCount: 符合条件的实例数量。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._NetworkAclSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def NetworkAclSet(self):
        """实例详细信息列表。
        :rtype: list of NetworkAcl
        """
        return self._NetworkAclSet

    @NetworkAclSet.setter
    def NetworkAclSet(self, NetworkAclSet):
        self._NetworkAclSet = NetworkAclSet

    @property
    def TotalCount(self):
        """符合条件的实例数量。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NetworkAclSet") is not None:
            self._NetworkAclSet = []
            for item in params.get("NetworkAclSet"):
                obj = NetworkAcl()
                obj._deserialize(item)
                self._NetworkAclSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeNetworkInterfaceLimitRequest(AbstractModel):
    """DescribeNetworkInterfaceLimit请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceId: 要查询的CVM实例ID或弹性网卡ID。
        :type InstanceId: str
        """
        self._InstanceId = None

    @property
    def InstanceId(self):
        """要查询的CVM实例ID或弹性网卡ID。
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetworkInterfaceLimitResponse(AbstractModel):
    """DescribeNetworkInterfaceLimit返回参数结构体

    """

    def __init__(self):
        r"""
        :param _EniQuantity: 标准型弹性网卡配额。
        :type EniQuantity: int
        :param _EniPrivateIpAddressQuantity: 每个标准型弹性网卡可以分配的IP配额。
        :type EniPrivateIpAddressQuantity: int
        :param _ExtendEniQuantity: 扩展型网卡配额。
        :type ExtendEniQuantity: int
        :param _ExtendEniPrivateIpAddressQuantity: 每个扩展型弹性网卡可以分配的IP配额。
        :type ExtendEniPrivateIpAddressQuantity: int
        :param _SubEniQuantity: 中继网卡配额。
        :type SubEniQuantity: int
        :param _SubEniPrivateIpAddressQuantity: 每个中继网卡可以分配的IP配额。
        :type SubEniPrivateIpAddressQuantity: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._EniQuantity = None
        self._EniPrivateIpAddressQuantity = None
        self._ExtendEniQuantity = None
        self._ExtendEniPrivateIpAddressQuantity = None
        self._SubEniQuantity = None
        self._SubEniPrivateIpAddressQuantity = None
        self._RequestId = None

    @property
    def EniQuantity(self):
        """标准型弹性网卡配额。
        :rtype: int
        """
        return self._EniQuantity

    @EniQuantity.setter
    def EniQuantity(self, EniQuantity):
        self._EniQuantity = EniQuantity

    @property
    def EniPrivateIpAddressQuantity(self):
        """每个标准型弹性网卡可以分配的IP配额。
        :rtype: int
        """
        return self._EniPrivateIpAddressQuantity

    @EniPrivateIpAddressQuantity.setter
    def EniPrivateIpAddressQuantity(self, EniPrivateIpAddressQuantity):
        self._EniPrivateIpAddressQuantity = EniPrivateIpAddressQuantity

    @property
    def ExtendEniQuantity(self):
        """扩展型网卡配额。
        :rtype: int
        """
        return self._ExtendEniQuantity

    @ExtendEniQuantity.setter
    def ExtendEniQuantity(self, ExtendEniQuantity):
        self._ExtendEniQuantity = ExtendEniQuantity

    @property
    def ExtendEniPrivateIpAddressQuantity(self):
        """每个扩展型弹性网卡可以分配的IP配额。
        :rtype: int
        """
        return self._ExtendEniPrivateIpAddressQuantity

    @ExtendEniPrivateIpAddressQuantity.setter
    def ExtendEniPrivateIpAddressQuantity(self, ExtendEniPrivateIpAddressQuantity):
        self._ExtendEniPrivateIpAddressQuantity = ExtendEniPrivateIpAddressQuantity

    @property
    def SubEniQuantity(self):
        """中继网卡配额。
        :rtype: int
        """
        return self._SubEniQuantity

    @SubEniQuantity.setter
    def SubEniQuantity(self, SubEniQuantity):
        self._SubEniQuantity = SubEniQuantity

    @property
    def SubEniPrivateIpAddressQuantity(self):
        """每个中继网卡可以分配的IP配额。
        :rtype: int
        """
        return self._SubEniPrivateIpAddressQuantity

    @SubEniPrivateIpAddressQuantity.setter
    def SubEniPrivateIpAddressQuantity(self, SubEniPrivateIpAddressQuantity):
        self._SubEniPrivateIpAddressQuantity = SubEniPrivateIpAddressQuantity

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._EniQuantity = params.get("EniQuantity")
        self._EniPrivateIpAddressQuantity = params.get("EniPrivateIpAddressQuantity")
        self._ExtendEniQuantity = params.get("ExtendEniQuantity")
        self._ExtendEniPrivateIpAddressQuantity = params.get("ExtendEniPrivateIpAddressQuantity")
        self._SubEniQuantity = params.get("SubEniQuantity")
        self._SubEniPrivateIpAddressQuantity = params.get("SubEniPrivateIpAddressQuantity")
        self._RequestId = params.get("RequestId")


class DescribeNetworkInterfacesRequest(AbstractModel):
    """DescribeNetworkInterfaces请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NetworkInterfaceIds: 弹性网卡实例ID查询。形如：eni-pxir56ns。每次请求的实例的上限为100。参数不支持同时指定NetworkInterfaceIds和Filters。
        :type NetworkInterfaceIds: list of str
        :param _Filters: 过滤条件，参数不支持同时指定NetworkInterfaceIds和Filters。
<li>vpc-id - String - （过滤条件）VPC实例ID，形如：vpc-f49l6u0z。</li>
<li>subnet-id - String - （过滤条件）所属子网实例ID，形如：subnet-f49l6u0z。</li>
<li>network-interface-id - String - （过滤条件）弹性网卡实例ID，形如：eni-5k56k7k7。</li>
<li>attachment.instance-id - String - （过滤条件）绑定的云服务器实例ID，形如：ins-3nqpdn3i。</li>
<li>groups.security-group-id - String - （过滤条件）绑定的安全组实例ID，例如：sg-f9ekbxeq。</li>
<li>network-interface-name - String - （过滤条件）网卡实例名称。</li>
<li>network-interface-description - String - （过滤条件）网卡实例描述。</li>
<li>address-ip - String - （过滤条件）内网IPv4地址，单IP后缀模糊匹配，多IP精确匹配。可以与`ip-exact-match`配合做单IP的精确匹配查询。</li>
<li>ip-exact-match - Boolean - （过滤条件）内网IPv4精确匹配查询，存在多值情况，只取第一个。</li>
<li>tag-key - String -是否必填：否- （过滤条件）按照标签键进行过滤。使用请参考示例2</li>
<li>tag:tag-key - String - 是否必填：否 - （过滤条件）按照标签键值对进行过滤。 tag-key使用具体的标签键进行替换。使用请参考示例2。</li>
<li>is-primary - Boolean - 是否必填：否 - （过滤条件）按照是否主网卡进行过滤。值为true时，仅过滤主网卡；值为false时，仅过滤辅助网卡；此过滤参数未提供时，同时过滤主网卡和辅助网卡。</li>
<li>eni-type - String -是否必填：否- （过滤条件）按照网卡类型进行过滤。“0”-辅助网卡，“1”-主网卡，“2”：中继网卡。</li>
<li>eni-qos - String -是否必填：否- （过滤条件）按照网卡服务质量进行过滤。“AG”-服务质量为云铜，“AU”-服务质量为云银。</li>
<li>address-ipv6 - String - 是否必填：否 -（过滤条件）内网IPv6地址过滤，支持多ipv6地址查询，如果和address-ip一起使用取交集。</li>
<li>public-address-ip - String - （过滤条件）公网IPv4地址，精确匹配。</li>
        :type Filters: list of Filter
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Limit: 返回数量，默认为20，最大值为100。
        :type Limit: int
        """
        self._NetworkInterfaceIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def NetworkInterfaceIds(self):
        """弹性网卡实例ID查询。形如：eni-pxir56ns。每次请求的实例的上限为100。参数不支持同时指定NetworkInterfaceIds和Filters。
        :rtype: list of str
        """
        return self._NetworkInterfaceIds

    @NetworkInterfaceIds.setter
    def NetworkInterfaceIds(self, NetworkInterfaceIds):
        self._NetworkInterfaceIds = NetworkInterfaceIds

    @property
    def Filters(self):
        """过滤条件，参数不支持同时指定NetworkInterfaceIds和Filters。
<li>vpc-id - String - （过滤条件）VPC实例ID，形如：vpc-f49l6u0z。</li>
<li>subnet-id - String - （过滤条件）所属子网实例ID，形如：subnet-f49l6u0z。</li>
<li>network-interface-id - String - （过滤条件）弹性网卡实例ID，形如：eni-5k56k7k7。</li>
<li>attachment.instance-id - String - （过滤条件）绑定的云服务器实例ID，形如：ins-3nqpdn3i。</li>
<li>groups.security-group-id - String - （过滤条件）绑定的安全组实例ID，例如：sg-f9ekbxeq。</li>
<li>network-interface-name - String - （过滤条件）网卡实例名称。</li>
<li>network-interface-description - String - （过滤条件）网卡实例描述。</li>
<li>address-ip - String - （过滤条件）内网IPv4地址，单IP后缀模糊匹配，多IP精确匹配。可以与`ip-exact-match`配合做单IP的精确匹配查询。</li>
<li>ip-exact-match - Boolean - （过滤条件）内网IPv4精确匹配查询，存在多值情况，只取第一个。</li>
<li>tag-key - String -是否必填：否- （过滤条件）按照标签键进行过滤。使用请参考示例2</li>
<li>tag:tag-key - String - 是否必填：否 - （过滤条件）按照标签键值对进行过滤。 tag-key使用具体的标签键进行替换。使用请参考示例2。</li>
<li>is-primary - Boolean - 是否必填：否 - （过滤条件）按照是否主网卡进行过滤。值为true时，仅过滤主网卡；值为false时，仅过滤辅助网卡；此过滤参数未提供时，同时过滤主网卡和辅助网卡。</li>
<li>eni-type - String -是否必填：否- （过滤条件）按照网卡类型进行过滤。“0”-辅助网卡，“1”-主网卡，“2”：中继网卡。</li>
<li>eni-qos - String -是否必填：否- （过滤条件）按照网卡服务质量进行过滤。“AG”-服务质量为云铜，“AU”-服务质量为云银。</li>
<li>address-ipv6 - String - 是否必填：否 -（过滤条件）内网IPv6地址过滤，支持多ipv6地址查询，如果和address-ip一起使用取交集。</li>
<li>public-address-ip - String - （过滤条件）公网IPv4地址，精确匹配。</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量，默认为0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量，默认为20，最大值为100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._NetworkInterfaceIds = params.get("NetworkInterfaceIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetworkInterfacesResponse(AbstractModel):
    """DescribeNetworkInterfaces返回参数结构体

    """

    def __init__(self):
        r"""
        :param _NetworkInterfaceSet: 实例详细信息列表。
        :type NetworkInterfaceSet: list of NetworkInterface
        :param _TotalCount: 符合条件的实例数量。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._NetworkInterfaceSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def NetworkInterfaceSet(self):
        """实例详细信息列表。
        :rtype: list of NetworkInterface
        """
        return self._NetworkInterfaceSet

    @NetworkInterfaceSet.setter
    def NetworkInterfaceSet(self, NetworkInterfaceSet):
        self._NetworkInterfaceSet = NetworkInterfaceSet

    @property
    def TotalCount(self):
        """符合条件的实例数量。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NetworkInterfaceSet") is not None:
            self._NetworkInterfaceSet = []
            for item in params.get("NetworkInterfaceSet"):
                obj = NetworkInterface()
                obj._deserialize(item)
                self._NetworkInterfaceSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribePrivateNatGatewayDestinationIpPortTranslationNatRulesRequest(AbstractModel):
    """DescribePrivateNatGatewayDestinationIpPortTranslationNatRules请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NatGatewayId: 私网网关唯一`ID`，形如"intranat-xxxxxxxx)
        :type NatGatewayId: str
        :param _Filters: 过滤条件，Name可选值"OriginalIp",  "TranslationIp", "OriginalPort","TranslationPort",  "Protocol", "Description"
        :type Filters: list of Filter
        :param _Offset: 偏移量，默认值为0。
        :type Offset: int
        :param _Limit: 返回数目，默认值为20。
        :type Limit: int
        """
        self._NatGatewayId = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def NatGatewayId(self):
        """私网网关唯一`ID`，形如"intranat-xxxxxxxx)
        :rtype: str
        """
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId

    @property
    def Filters(self):
        """过滤条件，Name可选值"OriginalIp",  "TranslationIp", "OriginalPort","TranslationPort",  "Protocol", "Description"
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量，默认值为0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数目，默认值为20。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._NatGatewayId = params.get("NatGatewayId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePrivateNatGatewayDestinationIpPortTranslationNatRulesResponse(AbstractModel):
    """DescribePrivateNatGatewayDestinationIpPortTranslationNatRules返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总规则数目。
        :type TotalCount: int
        :param _LocalDestinationIpPortTranslationNatRuleSet: 目的端口转换规则数组。
        :type LocalDestinationIpPortTranslationNatRuleSet: list of PrivateNatDestinationIpPortTranslationNatRule
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._LocalDestinationIpPortTranslationNatRuleSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """总规则数目。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def LocalDestinationIpPortTranslationNatRuleSet(self):
        """目的端口转换规则数组。
        :rtype: list of PrivateNatDestinationIpPortTranslationNatRule
        """
        return self._LocalDestinationIpPortTranslationNatRuleSet

    @LocalDestinationIpPortTranslationNatRuleSet.setter
    def LocalDestinationIpPortTranslationNatRuleSet(self, LocalDestinationIpPortTranslationNatRuleSet):
        self._LocalDestinationIpPortTranslationNatRuleSet = LocalDestinationIpPortTranslationNatRuleSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("LocalDestinationIpPortTranslationNatRuleSet") is not None:
            self._LocalDestinationIpPortTranslationNatRuleSet = []
            for item in params.get("LocalDestinationIpPortTranslationNatRuleSet"):
                obj = PrivateNatDestinationIpPortTranslationNatRule()
                obj._deserialize(item)
                self._LocalDestinationIpPortTranslationNatRuleSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribePrivateNatGatewayLimitsRequest(AbstractModel):
    """DescribePrivateNatGatewayLimits请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 查询VPC下可创建的私网网关配额数量，可选值：
<li>VpcId - String - 所在VpcId</li>
        :type Filters: list of Filter
        :param _Offset: 偏移量，默认值为0。
        :type Offset: int
        :param _Limit: 返回数目，默认值为20。
        :type Limit: int
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def Filters(self):
        """查询VPC下可创建的私网网关配额数量，可选值：
<li>VpcId - String - 所在VpcId</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量，默认值为0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数目，默认值为20。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePrivateNatGatewayLimitsResponse(AbstractModel):
    """DescribePrivateNatGatewayLimits返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 查询返回结果个数。
        :type TotalCount: int
        :param _PrivateNatGatewayLimitSet: 私网网关配额。
        :type PrivateNatGatewayLimitSet: list of PrivateNatGatewayLimit
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._PrivateNatGatewayLimitSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """查询返回结果个数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def PrivateNatGatewayLimitSet(self):
        """私网网关配额。
        :rtype: list of PrivateNatGatewayLimit
        """
        return self._PrivateNatGatewayLimitSet

    @PrivateNatGatewayLimitSet.setter
    def PrivateNatGatewayLimitSet(self, PrivateNatGatewayLimitSet):
        self._PrivateNatGatewayLimitSet = PrivateNatGatewayLimitSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("PrivateNatGatewayLimitSet") is not None:
            self._PrivateNatGatewayLimitSet = []
            for item in params.get("PrivateNatGatewayLimitSet"):
                obj = PrivateNatGatewayLimit()
                obj._deserialize(item)
                self._PrivateNatGatewayLimitSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribePrivateNatGatewayRegionsRequest(AbstractModel):
    """DescribePrivateNatGatewayRegions请求参数结构体

    """


class DescribePrivateNatGatewayRegionsResponse(AbstractModel):
    """DescribePrivateNatGatewayRegions返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RegionSet: 地域对象
        :type RegionSet: list of NatRegionInfoWithArea
        :param _TotalCount: 返回可支持地域总数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RegionSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def RegionSet(self):
        """地域对象
        :rtype: list of NatRegionInfoWithArea
        """
        return self._RegionSet

    @RegionSet.setter
    def RegionSet(self, RegionSet):
        self._RegionSet = RegionSet

    @property
    def TotalCount(self):
        """返回可支持地域总数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RegionSet") is not None:
            self._RegionSet = []
            for item in params.get("RegionSet"):
                obj = NatRegionInfoWithArea()
                obj._deserialize(item)
                self._RegionSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribePrivateNatGatewayTranslationAclRulesRequest(AbstractModel):
    """DescribePrivateNatGatewayTranslationAclRules请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NatGatewayId: 私网网关唯一`ID`，形如：`intranat-xxxxxxxx`。
        :type NatGatewayId: str
        :param _TranslationDirection: 转换规则目标，可选值"LOCAL"。
        :type TranslationDirection: str
        :param _TranslationType: 转换规则类型，可选值"NETWORK_LAYER","TRANSPORT_LAYER"。
        :type TranslationType: str
        :param _TranslationIp: 转换`IP`,当转换规则类型为四层时为`IP`池。
        :type TranslationIp: str
        :param _OriginalIp: 源`IP`,当转换规则类型为三层时有效。
        :type OriginalIp: str
        :param _Offset: 偏移量。默认值为0。
        :type Offset: int
        :param _Limit: 返回数目，默认值为20。
        :type Limit: int
        """
        self._NatGatewayId = None
        self._TranslationDirection = None
        self._TranslationType = None
        self._TranslationIp = None
        self._OriginalIp = None
        self._Offset = None
        self._Limit = None

    @property
    def NatGatewayId(self):
        """私网网关唯一`ID`，形如：`intranat-xxxxxxxx`。
        :rtype: str
        """
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId

    @property
    def TranslationDirection(self):
        """转换规则目标，可选值"LOCAL"。
        :rtype: str
        """
        return self._TranslationDirection

    @TranslationDirection.setter
    def TranslationDirection(self, TranslationDirection):
        self._TranslationDirection = TranslationDirection

    @property
    def TranslationType(self):
        """转换规则类型，可选值"NETWORK_LAYER","TRANSPORT_LAYER"。
        :rtype: str
        """
        return self._TranslationType

    @TranslationType.setter
    def TranslationType(self, TranslationType):
        self._TranslationType = TranslationType

    @property
    def TranslationIp(self):
        """转换`IP`,当转换规则类型为四层时为`IP`池。
        :rtype: str
        """
        return self._TranslationIp

    @TranslationIp.setter
    def TranslationIp(self, TranslationIp):
        self._TranslationIp = TranslationIp

    @property
    def OriginalIp(self):
        """源`IP`,当转换规则类型为三层时有效。
        :rtype: str
        """
        return self._OriginalIp

    @OriginalIp.setter
    def OriginalIp(self, OriginalIp):
        self._OriginalIp = OriginalIp

    @property
    def Offset(self):
        """偏移量。默认值为0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数目，默认值为20。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._NatGatewayId = params.get("NatGatewayId")
        self._TranslationDirection = params.get("TranslationDirection")
        self._TranslationType = params.get("TranslationType")
        self._TranslationIp = params.get("TranslationIp")
        self._OriginalIp = params.get("OriginalIp")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePrivateNatGatewayTranslationAclRulesResponse(AbstractModel):
    """DescribePrivateNatGatewayTranslationAclRules返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 返回个数。
        :type TotalCount: int
        :param _TranslationAclRuleSet: 访问控制规则列表。
        :type TranslationAclRuleSet: list of TranslationAclRule
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._TranslationAclRuleSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """返回个数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TranslationAclRuleSet(self):
        """访问控制规则列表。
        :rtype: list of TranslationAclRule
        """
        return self._TranslationAclRuleSet

    @TranslationAclRuleSet.setter
    def TranslationAclRuleSet(self, TranslationAclRuleSet):
        self._TranslationAclRuleSet = TranslationAclRuleSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("TranslationAclRuleSet") is not None:
            self._TranslationAclRuleSet = []
            for item in params.get("TranslationAclRuleSet"):
                obj = TranslationAclRule()
                obj._deserialize(item)
                self._TranslationAclRuleSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribePrivateNatGatewayTranslationNatRulesRequest(AbstractModel):
    """DescribePrivateNatGatewayTranslationNatRules请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NatGatewayId: 私网网关唯一`ID`，形如：`intranat-xxxxxxxx`。
        :type NatGatewayId: str
        :param _Filters: 过滤条件。
<li>OriginalIp - String - 转换规则源`IP`。</li>
<li>TranslationIp - String - 转换`IP`。</li>
<li>VpcId - String - 私网网关所在`VpcId`。</li>
<li>Description - String - 转换规则描述</li>
        :type Filters: list of Filter
        :param _Offset: 偏移量。默认值为0。
        :type Offset: int
        :param _Limit: 返回数量。默认值为20。
        :type Limit: int
        """
        self._NatGatewayId = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def NatGatewayId(self):
        """私网网关唯一`ID`，形如：`intranat-xxxxxxxx`。
        :rtype: str
        """
        return self._NatGatewayId

    @NatGatewayId.setter
    def NatGatewayId(self, NatGatewayId):
        self._NatGatewayId = NatGatewayId

    @property
    def Filters(self):
        """过滤条件。
<li>OriginalIp - String - 转换规则源`IP`。</li>
<li>TranslationIp - String - 转换`IP`。</li>
<li>VpcId - String - 私网网关所在`VpcId`。</li>
<li>Description - String - 转换规则描述</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量。默认值为0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量。默认值为20。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._NatGatewayId = params.get("NatGatewayId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePrivateNatGatewayTranslationNatRulesResponse(AbstractModel):
    """DescribePrivateNatGatewayTranslationNatRules返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 对象数目。
        :type TotalCount: int
        :param _TranslationNatRuleSet: 转换规则详情数组。
        :type TranslationNatRuleSet: list of TranslationNatRule
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._TranslationNatRuleSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """对象数目。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TranslationNatRuleSet(self):
        """转换规则详情数组。
        :rtype: list of TranslationNatRule
        """
        return self._TranslationNatRuleSet

    @TranslationNatRuleSet.setter
    def TranslationNatRuleSet(self, TranslationNatRuleSet):
        self._TranslationNatRuleSet = TranslationNatRuleSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("TranslationNatRuleSet") is not None:
            self._TranslationNatRuleSet = []
            for item in params.get("TranslationNatRuleSet"):
                obj = TranslationNatRule()
                obj._deserialize(item)
                self._TranslationNatRuleSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribePrivateNatGatewaysRequest(AbstractModel):
    """DescribePrivateNatGateways请求参数结构体

    """

    def __init__(self):
        r"""
        :param _NatGatewayIds: 私网网关唯一`ID`，形如：`intranat-0g3blj80`。
        :type NatGatewayIds: list of str
        :param _Filters: 过滤条件。
<li>NatGatewayId - String - 私网网关唯一`ID`，形如：`intranat-0g3blj80`。</li>
<li>NatGatewayName - String - 专线网关名称，默认模糊查询。</li>
<li>VpcId - String - 私网网关所在`VpcId`。</li>
<li>TagKey - Tag数组 - 私网网关标签键值对数组</li>
        :type Filters: list of Filter
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Limit: 返回数量，默认为20。
        :type Limit: int
        :param _OrderField: 排序字段。可选值："NatGatewayId"、"NatGatewayName"、"CreatedTime"
        :type OrderField: str
        :param _OrderDirection: 排序方式。可选值："ASC"、"DESC"。
        :type OrderDirection: str
        """
        self._NatGatewayIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._OrderField = None
        self._OrderDirection = None

    @property
    def NatGatewayIds(self):
        """私网网关唯一`ID`，形如：`intranat-0g3blj80`。
        :rtype: list of str
        """
        return self._NatGatewayIds

    @NatGatewayIds.setter
    def NatGatewayIds(self, NatGatewayIds):
        self._NatGatewayIds = NatGatewayIds

    @property
    def Filters(self):
        """过滤条件。
<li>NatGatewayId - String - 私网网关唯一`ID`，形如：`intranat-0g3blj80`。</li>
<li>NatGatewayName - String - 专线网关名称，默认模糊查询。</li>
<li>VpcId - String - 私网网关所在`VpcId`。</li>
<li>TagKey - Tag数组 - 私网网关标签键值对数组</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量，默认为0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量，默认为20。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def OrderField(self):
        """排序字段。可选值："NatGatewayId"、"NatGatewayName"、"CreatedTime"
        :rtype: str
        """
        return self._OrderField

    @OrderField.setter
    def OrderField(self, OrderField):
        self._OrderField = OrderField

    @property
    def OrderDirection(self):
        """排序方式。可选值："ASC"、"DESC"。
        :rtype: str
        """
        return self._OrderDirection

    @OrderDirection.setter
    def OrderDirection(self, OrderDirection):
        self._OrderDirection = OrderDirection


    def _deserialize(self, params):
        self._NatGatewayIds = params.get("NatGatewayIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._OrderField = params.get("OrderField")
        self._OrderDirection = params.get("OrderDirection")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePrivateNatGatewaysResponse(AbstractModel):
    """DescribePrivateNatGateways返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合条件的对象数。
        :type TotalCount: int
        :param _PrivateNatGatewaySet: 私网网关对象数组。
        :type PrivateNatGatewaySet: list of PrivateNatGateway
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._PrivateNatGatewaySet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """符合条件的对象数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def PrivateNatGatewaySet(self):
        """私网网关对象数组。
        :rtype: list of PrivateNatGateway
        """
        return self._PrivateNatGatewaySet

    @PrivateNatGatewaySet.setter
    def PrivateNatGatewaySet(self, PrivateNatGatewaySet):
        self._PrivateNatGatewaySet = PrivateNatGatewaySet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("PrivateNatGatewaySet") is not None:
            self._PrivateNatGatewaySet = []
            for item in params.get("PrivateNatGatewaySet"):
                obj = PrivateNatGateway()
                obj._deserialize(item)
                self._PrivateNatGatewaySet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeProductQuotaRequest(AbstractModel):
    """DescribeProductQuota请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Product: 查询的网络产品名称，可查询的产品有：vpc、ccn、vpn、dc、dfw、clb、eip。
        :type Product: str
        """
        self._Product = None

    @property
    def Product(self):
        """查询的网络产品名称，可查询的产品有：vpc、ccn、vpn、dc、dfw、clb、eip。
        :rtype: str
        """
        return self._Product

    @Product.setter
    def Product(self, Product):
        self._Product = Product


    def _deserialize(self, params):
        self._Product = params.get("Product")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeProductQuotaResponse(AbstractModel):
    """DescribeProductQuota返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ProductQuotaSet: ProductQuota对象数组。
        :type ProductQuotaSet: list of ProductQuota
        :param _TotalCount: 符合条件的产品类型个数。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ProductQuotaSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def ProductQuotaSet(self):
        """ProductQuota对象数组。
        :rtype: list of ProductQuota
        """
        return self._ProductQuotaSet

    @ProductQuotaSet.setter
    def ProductQuotaSet(self, ProductQuotaSet):
        self._ProductQuotaSet = ProductQuotaSet

    @property
    def TotalCount(self):
        """符合条件的产品类型个数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ProductQuotaSet") is not None:
            self._ProductQuotaSet = []
            for item in params.get("ProductQuotaSet"):
                obj = ProductQuota()
                obj._deserialize(item)
                self._ProductQuotaSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeReserveIpAddressesRequest(AbstractModel):
    """DescribeReserveIpAddresses请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ReserveIpIds: 内网保留IP唯一ID 列表
        :type ReserveIpIds: list of str
        :param _Filters: 过滤条件，参数不支持同时指定ReserveIpIds和Filters。

reserve-ip-id  - String - （过滤条件）内网保留 IP唯一 ID，形如：rsvip-pvqgv9vi。
vpc-id - String - （过滤条件）VPC实例ID，形如：vpc-f49l6u0z。
subnet-id - String - （过滤条件）所属子网实例ID，形如：subnet-f49l6u0z。
address-ip - String - （过滤条件）内网保留 IP 地址，形如：192.168.0.10。
ip-type - String - （过滤条件）业务类型 ipType，0。
name - String - （过滤条件）名称。
state - String - （过滤条件）状态，可选值：Bind， UnBind。
resource-id - String - （过滤条件）绑定的实例资源，形如：eni-059qmnif。
tag-key - String -（过滤条件）按照标签键进行过滤。
tag:tag-key - String - （过滤条件）按照标签键值对进行过滤。 tag-key使用具体的标签键进行替换。

        :type Filters: list of Filter
        :param _Offset: 偏移量。
        :type Offset: int
        :param _Limit: 请求对象个数。
        :type Limit: int
        """
        self._ReserveIpIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def ReserveIpIds(self):
        """内网保留IP唯一ID 列表
        :rtype: list of str
        """
        return self._ReserveIpIds

    @ReserveIpIds.setter
    def ReserveIpIds(self, ReserveIpIds):
        self._ReserveIpIds = ReserveIpIds

    @property
    def Filters(self):
        """过滤条件，参数不支持同时指定ReserveIpIds和Filters。

reserve-ip-id  - String - （过滤条件）内网保留 IP唯一 ID，形如：rsvip-pvqgv9vi。
vpc-id - String - （过滤条件）VPC实例ID，形如：vpc-f49l6u0z。
subnet-id - String - （过滤条件）所属子网实例ID，形如：subnet-f49l6u0z。
address-ip - String - （过滤条件）内网保留 IP 地址，形如：192.168.0.10。
ip-type - String - （过滤条件）业务类型 ipType，0。
name - String - （过滤条件）名称。
state - String - （过滤条件）状态，可选值：Bind， UnBind。
resource-id - String - （过滤条件）绑定的实例资源，形如：eni-059qmnif。
tag-key - String -（过滤条件）按照标签键进行过滤。
tag:tag-key - String - （过滤条件）按照标签键值对进行过滤。 tag-key使用具体的标签键进行替换。

        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """请求对象个数。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._ReserveIpIds = params.get("ReserveIpIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeReserveIpAddressesResponse(AbstractModel):
    """DescribeReserveIpAddresses返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ReserveIpAddressSet: 内网保留 IP返回信息。
        :type ReserveIpAddressSet: list of ReserveIpAddressInfo
        :param _TotalCount: 返回内网保留IP的个数。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ReserveIpAddressSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def ReserveIpAddressSet(self):
        """内网保留 IP返回信息。
        :rtype: list of ReserveIpAddressInfo
        """
        return self._ReserveIpAddressSet

    @ReserveIpAddressSet.setter
    def ReserveIpAddressSet(self, ReserveIpAddressSet):
        self._ReserveIpAddressSet = ReserveIpAddressSet

    @property
    def TotalCount(self):
        """返回内网保留IP的个数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ReserveIpAddressSet") is not None:
            self._ReserveIpAddressSet = []
            for item in params.get("ReserveIpAddressSet"):
                obj = ReserveIpAddressInfo()
                obj._deserialize(item)
                self._ReserveIpAddressSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeRouteConflictsRequest(AbstractModel):
    """DescribeRouteConflicts请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RouteTableId: 路由表实例ID，例如：rtb-azd4dt1c。
        :type RouteTableId: str
        :param _DestinationCidrBlocks: 要检查的与之冲突的目的端列表。
        :type DestinationCidrBlocks: list of str
        """
        self._RouteTableId = None
        self._DestinationCidrBlocks = None

    @property
    def RouteTableId(self):
        """路由表实例ID，例如：rtb-azd4dt1c。
        :rtype: str
        """
        return self._RouteTableId

    @RouteTableId.setter
    def RouteTableId(self, RouteTableId):
        self._RouteTableId = RouteTableId

    @property
    def DestinationCidrBlocks(self):
        """要检查的与之冲突的目的端列表。
        :rtype: list of str
        """
        return self._DestinationCidrBlocks

    @DestinationCidrBlocks.setter
    def DestinationCidrBlocks(self, DestinationCidrBlocks):
        self._DestinationCidrBlocks = DestinationCidrBlocks


    def _deserialize(self, params):
        self._RouteTableId = params.get("RouteTableId")
        self._DestinationCidrBlocks = params.get("DestinationCidrBlocks")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRouteConflictsResponse(AbstractModel):
    """DescribeRouteConflicts返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RouteConflictSet: 路由策略冲突列表。
        :type RouteConflictSet: list of RouteConflict
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RouteConflictSet = None
        self._RequestId = None

    @property
    def RouteConflictSet(self):
        """路由策略冲突列表。
        :rtype: list of RouteConflict
        """
        return self._RouteConflictSet

    @RouteConflictSet.setter
    def RouteConflictSet(self, RouteConflictSet):
        self._RouteConflictSet = RouteConflictSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RouteConflictSet") is not None:
            self._RouteConflictSet = []
            for item in params.get("RouteConflictSet"):
                obj = RouteConflict()
                obj._deserialize(item)
                self._RouteConflictSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRouteTableAssociatedInstancesRequest(AbstractModel):
    """DescribeRouteTableAssociatedInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤条件：
<li>ccn-id - String -（过滤条件）CCN实例ID。</li>
<li>ccn-route-table-id - String -（过滤条件）路由表ID。</li>
<li>instance-type - String -（过滤条件）实例类型：
私有网络: `VPC`
专线网关: `DIRECTCONNECT`
黑石私有网络: `BMVPC`
EDGE设备: `EDGE`
EDGE隧道: `EDGE_TUNNEL`
EDGE网关: `EDGE_VPNGW`
VPN网关：`VPNGW`</li>
<li>instance-id- String -（过滤条件）实例ID。</li>
        :type Filters: list of Filter
        :param _Offset: 偏移量。
        :type Offset: int
        :param _Limit: 一次查询最大返回的数量。
        :type Limit: int
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def Filters(self):
        """过滤条件：
<li>ccn-id - String -（过滤条件）CCN实例ID。</li>
<li>ccn-route-table-id - String -（过滤条件）路由表ID。</li>
<li>instance-type - String -（过滤条件）实例类型：
私有网络: `VPC`
专线网关: `DIRECTCONNECT`
黑石私有网络: `BMVPC`
EDGE设备: `EDGE`
EDGE隧道: `EDGE_TUNNEL`
EDGE网关: `EDGE_VPNGW`
VPN网关：`VPNGW`</li>
<li>instance-id- String -（过滤条件）实例ID。</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """一次查询最大返回的数量。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRouteTableAssociatedInstancesResponse(AbstractModel):
    """DescribeRouteTableAssociatedInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 查询到的绑定路由表的实例数量。
        :type TotalCount: int
        :param _InstanceBindSet: 绑定信息。
        :type InstanceBindSet: list of InstanceBind
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._InstanceBindSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """查询到的绑定路由表的实例数量。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def InstanceBindSet(self):
        """绑定信息。
        :rtype: list of InstanceBind
        """
        return self._InstanceBindSet

    @InstanceBindSet.setter
    def InstanceBindSet(self, InstanceBindSet):
        self._InstanceBindSet = InstanceBindSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("InstanceBindSet") is not None:
            self._InstanceBindSet = []
            for item in params.get("InstanceBindSet"):
                obj = InstanceBind()
                obj._deserialize(item)
                self._InstanceBindSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRouteTableSelectionPoliciesRequest(AbstractModel):
    """DescribeRouteTableSelectionPolicies请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Offset: 偏移量
        :type Offset: int
        :param _Limit: 返回数量
        :type Limit: int
        :param _Filters: 过滤条件：
<li>ccn-id - String -（过滤条件）CCN实例ID。</li>
<li>instance-type - String -（过滤条件）关联实例类型:
私有网络: `VPC`
专线网关: `DIRECTCONNECT`
黑石私有网络: `BMVPC`
EDGE设备: `EDGE`
EDGE隧道: `EDGE_TUNNEL`
EDGE网关: `EDGE_VPNGW`
VPN网关：`VPNGW`</li>
<li>ccn-route-table-id - String -（过滤条件）路由表ID。</li>
<li>instance-id - String -（过滤条件）关联的实例ID。</li>
<li>route-table-name - String -（过滤条件）路由表名称。</li>
        :type Filters: list of Filter
        """
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def Offset(self):
        """偏移量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        """过滤条件：
<li>ccn-id - String -（过滤条件）CCN实例ID。</li>
<li>instance-type - String -（过滤条件）关联实例类型:
私有网络: `VPC`
专线网关: `DIRECTCONNECT`
黑石私有网络: `BMVPC`
EDGE设备: `EDGE`
EDGE隧道: `EDGE_TUNNEL`
EDGE网关: `EDGE_VPNGW`
VPN网关：`VPNGW`</li>
<li>ccn-route-table-id - String -（过滤条件）路由表ID。</li>
<li>instance-id - String -（过滤条件）关联的实例ID。</li>
<li>route-table-name - String -（过滤条件）路由表名称。</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRouteTableSelectionPoliciesResponse(AbstractModel):
    """DescribeRouteTableSelectionPolicies返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合条件的对象数。
        :type TotalCount: int
        :param _RouteSelectionPolicySet: 路由表选择策略信息集合。
        :type RouteSelectionPolicySet: list of RouteSelectionPolicy
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._RouteSelectionPolicySet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """符合条件的对象数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RouteSelectionPolicySet(self):
        """路由表选择策略信息集合。
        :rtype: list of RouteSelectionPolicy
        """
        return self._RouteSelectionPolicySet

    @RouteSelectionPolicySet.setter
    def RouteSelectionPolicySet(self, RouteSelectionPolicySet):
        self._RouteSelectionPolicySet = RouteSelectionPolicySet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("RouteSelectionPolicySet") is not None:
            self._RouteSelectionPolicySet = []
            for item in params.get("RouteSelectionPolicySet"):
                obj = RouteSelectionPolicy()
                obj._deserialize(item)
                self._RouteSelectionPolicySet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRouteTablesRequest(AbstractModel):
    """DescribeRouteTables请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤条件，参数不支持同时指定RouteTableIds和Filters。
<li>route-table-id - String - （过滤条件）路由表实例ID。</li>
<li>route-table-name - String - （过滤条件）路由表名称。</li>
<li>vpc-id - String - （过滤条件）VPC实例ID，形如：vpc-f49l6u0z。</li>
<li>association.main - String - （过滤条件）是否主路由表。</li>
<li>tag-key - String -是否必填：否 - （过滤条件）按照标签键进行过滤。</li>
<li>tag:tag-key - String - 是否必填：否 - （过滤条件）按照标签键值对进行过滤。 tag-key使用具体的标签键进行替换。使用请参考示例2。</li>
<li>next-hop-type - String - 是否必填：否 - （过滤条件）按下一跳类型进行过滤。使用next-hop-type进行过滤时，必须同时携带route-table-id与vpc-id。
目前我们支持的类型有：
LOCAL: 本地路由
CVM：公网网关类型的云服务器；
VPN：VPN网关；
DIRECTCONNECT：专线网关；
PEERCONNECTION：对等连接；
HAVIP：高可用虚拟IP；
NAT：NAT网关; 
NORMAL_CVM：普通云服务器；
EIP：云服务器的公网IP；
CCN：云联网；
LOCAL_GATEWAY：本地网关。
</li>
        :type Filters: list of Filter
        :param _RouteTableIds: 路由表实例ID，例如：rtb-azd4dt1c。
        :type RouteTableIds: list of str
        :param _Offset: 偏移量。
        :type Offset: str
        :param _Limit: 返回数量，默认为20，最大值为100。
        :type Limit: str
        :param _NeedRouterInfo: 是否需要获取路由策略信息，默认获取，当控制台不需要拉取路由策略信息时，改为False。
        :type NeedRouterInfo: bool
        """
        self._Filters = None
        self._RouteTableIds = None
        self._Offset = None
        self._Limit = None
        self._NeedRouterInfo = None

    @property
    def Filters(self):
        """过滤条件，参数不支持同时指定RouteTableIds和Filters。
<li>route-table-id - String - （过滤条件）路由表实例ID。</li>
<li>route-table-name - String - （过滤条件）路由表名称。</li>
<li>vpc-id - String - （过滤条件）VPC实例ID，形如：vpc-f49l6u0z。</li>
<li>association.main - String - （过滤条件）是否主路由表。</li>
<li>tag-key - String -是否必填：否 - （过滤条件）按照标签键进行过滤。</li>
<li>tag:tag-key - String - 是否必填：否 - （过滤条件）按照标签键值对进行过滤。 tag-key使用具体的标签键进行替换。使用请参考示例2。</li>
<li>next-hop-type - String - 是否必填：否 - （过滤条件）按下一跳类型进行过滤。使用next-hop-type进行过滤时，必须同时携带route-table-id与vpc-id。
目前我们支持的类型有：
LOCAL: 本地路由
CVM：公网网关类型的云服务器；
VPN：VPN网关；
DIRECTCONNECT：专线网关；
PEERCONNECTION：对等连接；
HAVIP：高可用虚拟IP；
NAT：NAT网关; 
NORMAL_CVM：普通云服务器；
EIP：云服务器的公网IP；
CCN：云联网；
LOCAL_GATEWAY：本地网关。
</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def RouteTableIds(self):
        """路由表实例ID，例如：rtb-azd4dt1c。
        :rtype: list of str
        """
        return self._RouteTableIds

    @RouteTableIds.setter
    def RouteTableIds(self, RouteTableIds):
        self._RouteTableIds = RouteTableIds

    @property
    def Offset(self):
        """偏移量。
        :rtype: str
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量，默认为20，最大值为100。
        :rtype: str
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def NeedRouterInfo(self):
        """是否需要获取路由策略信息，默认获取，当控制台不需要拉取路由策略信息时，改为False。
        :rtype: bool
        """
        return self._NeedRouterInfo

    @NeedRouterInfo.setter
    def NeedRouterInfo(self, NeedRouterInfo):
        self._NeedRouterInfo = NeedRouterInfo


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._RouteTableIds = params.get("RouteTableIds")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._NeedRouterInfo = params.get("NeedRouterInfo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRouteTablesResponse(AbstractModel):
    """DescribeRouteTables返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合条件的实例数量。
        :type TotalCount: int
        :param _RouteTableSet: 路由表对象。
        :type RouteTableSet: list of RouteTable
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._RouteTableSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """符合条件的实例数量。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RouteTableSet(self):
        """路由表对象。
        :rtype: list of RouteTable
        """
        return self._RouteTableSet

    @RouteTableSet.setter
    def RouteTableSet(self, RouteTableSet):
        self._RouteTableSet = RouteTableSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("RouteTableSet") is not None:
            self._RouteTableSet = []
            for item in params.get("RouteTableSet"):
                obj = RouteTable()
                obj._deserialize(item)
                self._RouteTableSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRoutesRequest(AbstractModel):
    """DescribeRoutes请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: <li>vpc-id - String - （过滤条件）VPC实例ID，形如：vpc-f49l6u0z。</li>
<li>gateway-id - String - （过滤条件）网关ID。</li>
<li>description - String - （过滤条件）路由描述。</li>
<li>route-table-id - String - （过滤条件）路由表实例ID。</li>
<li>dest-cidr - String - （过滤条件）目的端地址，支持模糊左匹配。</li>
        :type Filters: list of Filter
        :param _Offset: 偏移量。
        :type Offset: int
        :param _Limit: 请求对象个数。
        :type Limit: int
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def Filters(self):
        """<li>vpc-id - String - （过滤条件）VPC实例ID，形如：vpc-f49l6u0z。</li>
<li>gateway-id - String - （过滤条件）网关ID。</li>
<li>description - String - （过滤条件）路由描述。</li>
<li>route-table-id - String - （过滤条件）路由表实例ID。</li>
<li>dest-cidr - String - （过滤条件）目的端地址，支持模糊左匹配。</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """请求对象个数。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRoutesResponse(AbstractModel):
    """DescribeRoutes返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RouteSet: 路由对象。
        :type RouteSet: list of Route
        :param _TotalCount: 符合条件的实例数量。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RouteSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def RouteSet(self):
        """路由对象。
        :rtype: list of Route
        """
        return self._RouteSet

    @RouteSet.setter
    def RouteSet(self, RouteSet):
        self._RouteSet = RouteSet

    @property
    def TotalCount(self):
        """符合条件的实例数量。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RouteSet") is not None:
            self._RouteSet = []
            for item in params.get("RouteSet"):
                obj = Route()
                obj._deserialize(item)
                self._RouteSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeSecurityGroupAssociationStatisticsRequest(AbstractModel):
    """DescribeSecurityGroupAssociationStatistics请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SecurityGroupIds: 安全实例ID，例如sg-33ocnj9n，可通过<a href="https://cloud.tencent.com/document/product/215/15808">DescribeSecurityGroups</a>获取。
        :type SecurityGroupIds: list of str
        """
        self._SecurityGroupIds = None

    @property
    def SecurityGroupIds(self):
        """安全实例ID，例如sg-33ocnj9n，可通过<a href="https://cloud.tencent.com/document/product/215/15808">DescribeSecurityGroups</a>获取。
        :rtype: list of str
        """
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds


    def _deserialize(self, params):
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSecurityGroupAssociationStatisticsResponse(AbstractModel):
    """DescribeSecurityGroupAssociationStatistics返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SecurityGroupAssociationStatisticsSet: 安全组关联实例统计。
        :type SecurityGroupAssociationStatisticsSet: list of SecurityGroupAssociationStatistics
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SecurityGroupAssociationStatisticsSet = None
        self._RequestId = None

    @property
    def SecurityGroupAssociationStatisticsSet(self):
        """安全组关联实例统计。
        :rtype: list of SecurityGroupAssociationStatistics
        """
        return self._SecurityGroupAssociationStatisticsSet

    @SecurityGroupAssociationStatisticsSet.setter
    def SecurityGroupAssociationStatisticsSet(self, SecurityGroupAssociationStatisticsSet):
        self._SecurityGroupAssociationStatisticsSet = SecurityGroupAssociationStatisticsSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SecurityGroupAssociationStatisticsSet") is not None:
            self._SecurityGroupAssociationStatisticsSet = []
            for item in params.get("SecurityGroupAssociationStatisticsSet"):
                obj = SecurityGroupAssociationStatistics()
                obj._deserialize(item)
                self._SecurityGroupAssociationStatisticsSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSecurityGroupLimitsRequest(AbstractModel):
    """DescribeSecurityGroupLimits请求参数结构体

    """


class DescribeSecurityGroupLimitsResponse(AbstractModel):
    """DescribeSecurityGroupLimits返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SecurityGroupLimitSet: 用户安全组配额限制。
        :type SecurityGroupLimitSet: :class:`tencentcloud.vpc.v20170312.models.SecurityGroupLimitSet`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SecurityGroupLimitSet = None
        self._RequestId = None

    @property
    def SecurityGroupLimitSet(self):
        """用户安全组配额限制。
        :rtype: :class:`tencentcloud.vpc.v20170312.models.SecurityGroupLimitSet`
        """
        return self._SecurityGroupLimitSet

    @SecurityGroupLimitSet.setter
    def SecurityGroupLimitSet(self, SecurityGroupLimitSet):
        self._SecurityGroupLimitSet = SecurityGroupLimitSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SecurityGroupLimitSet") is not None:
            self._SecurityGroupLimitSet = SecurityGroupLimitSet()
            self._SecurityGroupLimitSet._deserialize(params.get("SecurityGroupLimitSet"))
        self._RequestId = params.get("RequestId")


class DescribeSecurityGroupPoliciesRequest(AbstractModel):
    """DescribeSecurityGroupPolicies请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SecurityGroupId: 安全组实例ID，例如：sg-33ocnj9n，可通过<a href="https://cloud.tencent.com/document/product/215/15808">DescribeSecurityGroups</a>获取。
        :type SecurityGroupId: str
        :param _Filters: 过滤条件。
<li>security-group-id - String - 规则中的安全组ID。</li>
<li>ip - String - IP，支持IPV4和IPV6模糊匹配。</li>
<li>address-module - String - IP地址模板或IP地址组模板ID。</li>
<li>service-module - String - 协议端口模板或协议端口组模板ID。</li>
<li>protocol-type - String - 安全组策略支持的协议，可选值：`TCP`, `UDP`, `ICMP`, `ICMPV6`, `GRE`, `ALL`。</li>
<li>port - String - 是否必填：否 -协议端口，支持模糊匹配，值为`ALL`时，查询所有的端口。</li>
<li>poly - String - 协议策略，可选值：`ALL`，所有策略；`ACCEPT`，允许；`DROP`，拒绝。</li>
<li>direction - String - 协议规则，可选值：`ALL`，所有策略；`INBOUND`，入站规则；`OUTBOUND`，出站规则。</li>
<li>description - String - 协议描述，该过滤条件支持模糊匹配。</li>
        :type Filters: list of Filter
        """
        self._SecurityGroupId = None
        self._Filters = None

    @property
    def SecurityGroupId(self):
        """安全组实例ID，例如：sg-33ocnj9n，可通过<a href="https://cloud.tencent.com/document/product/215/15808">DescribeSecurityGroups</a>获取。
        :rtype: str
        """
        return self._SecurityGroupId

    @SecurityGroupId.setter
    def SecurityGroupId(self, SecurityGroupId):
        self._SecurityGroupId = SecurityGroupId

    @property
    def Filters(self):
        """过滤条件。
<li>security-group-id - String - 规则中的安全组ID。</li>
<li>ip - String - IP，支持IPV4和IPV6模糊匹配。</li>
<li>address-module - String - IP地址模板或IP地址组模板ID。</li>
<li>service-module - String - 协议端口模板或协议端口组模板ID。</li>
<li>protocol-type - String - 安全组策略支持的协议，可选值：`TCP`, `UDP`, `ICMP`, `ICMPV6`, `GRE`, `ALL`。</li>
<li>port - String - 是否必填：否 -协议端口，支持模糊匹配，值为`ALL`时，查询所有的端口。</li>
<li>poly - String - 协议策略，可选值：`ALL`，所有策略；`ACCEPT`，允许；`DROP`，拒绝。</li>
<li>direction - String - 协议规则，可选值：`ALL`，所有策略；`INBOUND`，入站规则；`OUTBOUND`，出站规则。</li>
<li>description - String - 协议描述，该过滤条件支持模糊匹配。</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._SecurityGroupId = params.get("SecurityGroupId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSecurityGroupPoliciesResponse(AbstractModel):
    """DescribeSecurityGroupPolicies返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SecurityGroupPolicySet: 安全组规则集合。
        :type SecurityGroupPolicySet: :class:`tencentcloud.vpc.v20170312.models.SecurityGroupPolicySet`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SecurityGroupPolicySet = None
        self._RequestId = None

    @property
    def SecurityGroupPolicySet(self):
        """安全组规则集合。
        :rtype: :class:`tencentcloud.vpc.v20170312.models.SecurityGroupPolicySet`
        """
        return self._SecurityGroupPolicySet

    @SecurityGroupPolicySet.setter
    def SecurityGroupPolicySet(self, SecurityGroupPolicySet):
        self._SecurityGroupPolicySet = SecurityGroupPolicySet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SecurityGroupPolicySet") is not None:
            self._SecurityGroupPolicySet = SecurityGroupPolicySet()
            self._SecurityGroupPolicySet._deserialize(params.get("SecurityGroupPolicySet"))
        self._RequestId = params.get("RequestId")


class DescribeSecurityGroupReferencesRequest(AbstractModel):
    """DescribeSecurityGroupReferences请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SecurityGroupIds: 安全组实例ID数组。格式如：['sg-12345678']。
        :type SecurityGroupIds: list of str
        """
        self._SecurityGroupIds = None

    @property
    def SecurityGroupIds(self):
        """安全组实例ID数组。格式如：['sg-12345678']。
        :rtype: list of str
        """
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds


    def _deserialize(self, params):
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSecurityGroupReferencesResponse(AbstractModel):
    """DescribeSecurityGroupReferences返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ReferredSecurityGroupSet: 安全组被引用信息。
        :type ReferredSecurityGroupSet: list of ReferredSecurityGroup
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ReferredSecurityGroupSet = None
        self._RequestId = None

    @property
    def ReferredSecurityGroupSet(self):
        """安全组被引用信息。
        :rtype: list of ReferredSecurityGroup
        """
        return self._ReferredSecurityGroupSet

    @ReferredSecurityGroupSet.setter
    def ReferredSecurityGroupSet(self, ReferredSecurityGroupSet):
        self._ReferredSecurityGroupSet = ReferredSecurityGroupSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ReferredSecurityGroupSet") is not None:
            self._ReferredSecurityGroupSet = []
            for item in params.get("ReferredSecurityGroupSet"):
                obj = ReferredSecurityGroup()
                obj._deserialize(item)
                self._ReferredSecurityGroupSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSecurityGroupsRequest(AbstractModel):
    """DescribeSecurityGroups请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SecurityGroupIds: 安全组实例ID，例如：sg-33ocnj9n。每次请求的实例的上限为100。参数不支持同时指定SecurityGroupIds和Filters。
        :type SecurityGroupIds: list of str
        :param _Filters: 过滤条件，参数不支持同时指定SecurityGroupIds和Filters。
<li>security-group-id - String - （过滤条件）安全组ID。</li>
<li>project-id - Integer - （过滤条件）项目ID。</li>
<li>security-group-name - String - （过滤条件）安全组名称。</li>
<li>tag-key - String -是否必填：否- （过滤条件）按照标签键进行过滤。</li>
<li>tag:tag-key - String - 是否必填：否 - （过滤条件）按照标签键值对进行过滤。 其中 tag-key 请使用具体的标签键进行替换。</li>
        :type Filters: list of Filter
        :param _Offset: 偏移量，默认为0。
        :type Offset: str
        :param _Limit: 返回数量，默认为20，最大值为100。
        :type Limit: str
        :param _OrderField: 排序字段。支持：`CreatedTime` `UpdateTime`。注意：该字段没有默认值。
        :type OrderField: str
        :param _OrderDirection: 排序方法。升序：`ASC`，倒序：`DESC`。默认值：`ASC`
        :type OrderDirection: str
        """
        self._SecurityGroupIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._OrderField = None
        self._OrderDirection = None

    @property
    def SecurityGroupIds(self):
        """安全组实例ID，例如：sg-33ocnj9n。每次请求的实例的上限为100。参数不支持同时指定SecurityGroupIds和Filters。
        :rtype: list of str
        """
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds

    @property
    def Filters(self):
        """过滤条件，参数不支持同时指定SecurityGroupIds和Filters。
<li>security-group-id - String - （过滤条件）安全组ID。</li>
<li>project-id - Integer - （过滤条件）项目ID。</li>
<li>security-group-name - String - （过滤条件）安全组名称。</li>
<li>tag-key - String -是否必填：否- （过滤条件）按照标签键进行过滤。</li>
<li>tag:tag-key - String - 是否必填：否 - （过滤条件）按照标签键值对进行过滤。 其中 tag-key 请使用具体的标签键进行替换。</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量，默认为0。
        :rtype: str
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量，默认为20，最大值为100。
        :rtype: str
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def OrderField(self):
        """排序字段。支持：`CreatedTime` `UpdateTime`。注意：该字段没有默认值。
        :rtype: str
        """
        return self._OrderField

    @OrderField.setter
    def OrderField(self, OrderField):
        self._OrderField = OrderField

    @property
    def OrderDirection(self):
        """排序方法。升序：`ASC`，倒序：`DESC`。默认值：`ASC`
        :rtype: str
        """
        return self._OrderDirection

    @OrderDirection.setter
    def OrderDirection(self, OrderDirection):
        self._OrderDirection = OrderDirection


    def _deserialize(self, params):
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._OrderField = params.get("OrderField")
        self._OrderDirection = params.get("OrderDirection")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSecurityGroupsResponse(AbstractModel):
    """DescribeSecurityGroups返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SecurityGroupSet: 安全组对象。
        :type SecurityGroupSet: list of SecurityGroup
        :param _TotalCount: 符合条件的实例数量。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SecurityGroupSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SecurityGroupSet(self):
        """安全组对象。
        :rtype: list of SecurityGroup
        """
        return self._SecurityGroupSet

    @SecurityGroupSet.setter
    def SecurityGroupSet(self, SecurityGroupSet):
        self._SecurityGroupSet = SecurityGroupSet

    @property
    def TotalCount(self):
        """符合条件的实例数量。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SecurityGroupSet") is not None:
            self._SecurityGroupSet = []
            for item in params.get("SecurityGroupSet"):
                obj = SecurityGroup()
                obj._deserialize(item)
                self._SecurityGroupSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeServiceTemplateGroupsRequest(AbstractModel):
    """DescribeServiceTemplateGroups请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤条件。
<li>service-template-group-name - String - （过滤条件）协议端口模板集合名称。</li>
<li>service-template-group-id - String - （过滤条件）协议端口模板集合实例ID，例如：ppmg-e6dy460g。</li>
        :type Filters: list of Filter
        :param _Offset: 偏移量，默认为0。
        :type Offset: str
        :param _Limit: 返回数量，默认为20，最大值为100。
        :type Limit: str
        :param _NeedMemberInfo: 是否获取协议端口模板成员标识。
        :type NeedMemberInfo: bool
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._NeedMemberInfo = None

    @property
    def Filters(self):
        """过滤条件。
<li>service-template-group-name - String - （过滤条件）协议端口模板集合名称。</li>
<li>service-template-group-id - String - （过滤条件）协议端口模板集合实例ID，例如：ppmg-e6dy460g。</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量，默认为0。
        :rtype: str
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量，默认为20，最大值为100。
        :rtype: str
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def NeedMemberInfo(self):
        """是否获取协议端口模板成员标识。
        :rtype: bool
        """
        return self._NeedMemberInfo

    @NeedMemberInfo.setter
    def NeedMemberInfo(self, NeedMemberInfo):
        self._NeedMemberInfo = NeedMemberInfo


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._NeedMemberInfo = params.get("NeedMemberInfo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeServiceTemplateGroupsResponse(AbstractModel):
    """DescribeServiceTemplateGroups返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合条件的实例数量。
        :type TotalCount: int
        :param _ServiceTemplateGroupSet: 协议端口模板集合。
        :type ServiceTemplateGroupSet: list of ServiceTemplateGroup
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._ServiceTemplateGroupSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """符合条件的实例数量。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ServiceTemplateGroupSet(self):
        """协议端口模板集合。
        :rtype: list of ServiceTemplateGroup
        """
        return self._ServiceTemplateGroupSet

    @ServiceTemplateGroupSet.setter
    def ServiceTemplateGroupSet(self, ServiceTemplateGroupSet):
        self._ServiceTemplateGroupSet = ServiceTemplateGroupSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ServiceTemplateGroupSet") is not None:
            self._ServiceTemplateGroupSet = []
            for item in params.get("ServiceTemplateGroupSet"):
                obj = ServiceTemplateGroup()
                obj._deserialize(item)
                self._ServiceTemplateGroupSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeServiceTemplatesRequest(AbstractModel):
    """DescribeServiceTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤条件。
<li>service-template-name - 协议端口模板名称。</li>
<li>service-template-id - 协议端口模板实例ID，例如：ppm-e6dy460g。</li>
<li>service-port- 协议端口。</li>
        :type Filters: list of Filter
        :param _Offset: 偏移量，默认为0。
        :type Offset: str
        :param _Limit: 返回数量，默认为20，最大值为100。
        :type Limit: str
        :param _NeedMemberInfo: 是否获取协议端口成员标识。
        :type NeedMemberInfo: bool
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._NeedMemberInfo = None

    @property
    def Filters(self):
        """过滤条件。
<li>service-template-name - 协议端口模板名称。</li>
<li>service-template-id - 协议端口模板实例ID，例如：ppm-e6dy460g。</li>
<li>service-port- 协议端口。</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量，默认为0。
        :rtype: str
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量，默认为20，最大值为100。
        :rtype: str
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def NeedMemberInfo(self):
        """是否获取协议端口成员标识。
        :rtype: bool
        """
        return self._NeedMemberInfo

    @NeedMemberInfo.setter
    def NeedMemberInfo(self, NeedMemberInfo):
        self._NeedMemberInfo = NeedMemberInfo


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._NeedMemberInfo = params.get("NeedMemberInfo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeServiceTemplatesResponse(AbstractModel):
    """DescribeServiceTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合条件的实例数量。
        :type TotalCount: int
        :param _ServiceTemplateSet: 协议端口模板对象。
        :type ServiceTemplateSet: list of ServiceTemplate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._ServiceTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """符合条件的实例数量。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ServiceTemplateSet(self):
        """协议端口模板对象。
        :rtype: list of ServiceTemplate
        """
        return self._ServiceTemplateSet

    @ServiceTemplateSet.setter
    def ServiceTemplateSet(self, ServiceTemplateSet):
        self._ServiceTemplateSet = ServiceTemplateSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ServiceTemplateSet") is not None:
            self._ServiceTemplateSet = []
            for item in params.get("ServiceTemplateSet"):
                obj = ServiceTemplate()
                obj._deserialize(item)
                self._ServiceTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSgSnapshotFileContentRequest(AbstractModel):
    """DescribeSgSnapshotFileContent请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SnapshotPolicyId: 快照策略Id。
        :type SnapshotPolicyId: str
        :param _SnapshotFileId: 快照文件Id。
        :type SnapshotFileId: str
        :param _SecurityGroupId: 安全组Id。
        :type SecurityGroupId: str
        """
        self._SnapshotPolicyId = None
        self._SnapshotFileId = None
        self._SecurityGroupId = None

    @property
    def SnapshotPolicyId(self):
        """快照策略Id。
        :rtype: str
        """
        return self._SnapshotPolicyId

    @SnapshotPolicyId.setter
    def SnapshotPolicyId(self, SnapshotPolicyId):
        self._SnapshotPolicyId = SnapshotPolicyId

    @property
    def SnapshotFileId(self):
        """快照文件Id。
        :rtype: str
        """
        return self._SnapshotFileId

    @SnapshotFileId.setter
    def SnapshotFileId(self, SnapshotFileId):
        self._SnapshotFileId = SnapshotFileId

    @property
    def SecurityGroupId(self):
        """安全组Id。
        :rtype: str
        """
        return self._SecurityGroupId

    @SecurityGroupId.setter
    def SecurityGroupId(self, SecurityGroupId):
        self._SecurityGroupId = SecurityGroupId


    def _deserialize(self, params):
        self._SnapshotPolicyId = params.get("SnapshotPolicyId")
        self._SnapshotFileId = params.get("SnapshotFileId")
        self._SecurityGroupId = params.get("SecurityGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSgSnapshotFileContentResponse(AbstractModel):
    """DescribeSgSnapshotFileContent返回参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceId: 实例Id，即安全组Id。
        :type InstanceId: str
        :param _SnapshotPolicyId: 快照策略Id。
        :type SnapshotPolicyId: str
        :param _SnapshotFileId: 快照文件Id。
        :type SnapshotFileId: str
        :param _BackupTime: 备份时间。
        :type BackupTime: str
        :param _Operator: 操作者。
        :type Operator: str
        :param _OriginalData: 原始数据。
        :type OriginalData: list of SecurityGroupPolicy
        :param _BackupData: 备份数据。
        :type BackupData: list of SecurityGroupPolicy
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._InstanceId = None
        self._SnapshotPolicyId = None
        self._SnapshotFileId = None
        self._BackupTime = None
        self._Operator = None
        self._OriginalData = None
        self._BackupData = None
        self._RequestId = None

    @property
    def InstanceId(self):
        """实例Id，即安全组Id。
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def SnapshotPolicyId(self):
        """快照策略Id。
        :rtype: str
        """
        return self._SnapshotPolicyId

    @SnapshotPolicyId.setter
    def SnapshotPolicyId(self, SnapshotPolicyId):
        self._SnapshotPolicyId = SnapshotPolicyId

    @property
    def SnapshotFileId(self):
        """快照文件Id。
        :rtype: str
        """
        return self._SnapshotFileId

    @SnapshotFileId.setter
    def SnapshotFileId(self, SnapshotFileId):
        self._SnapshotFileId = SnapshotFileId

    @property
    def BackupTime(self):
        """备份时间。
        :rtype: str
        """
        return self._BackupTime

    @BackupTime.setter
    def BackupTime(self, BackupTime):
        self._BackupTime = BackupTime

    @property
    def Operator(self):
        """操作者。
        :rtype: str
        """
        return self._Operator

    @Operator.setter
    def Operator(self, Operator):
        self._Operator = Operator

    @property
    def OriginalData(self):
        """原始数据。
        :rtype: list of SecurityGroupPolicy
        """
        return self._OriginalData

    @OriginalData.setter
    def OriginalData(self, OriginalData):
        self._OriginalData = OriginalData

    @property
    def BackupData(self):
        """备份数据。
        :rtype: list of SecurityGroupPolicy
        """
        return self._BackupData

    @BackupData.setter
    def BackupData(self, BackupData):
        self._BackupData = BackupData

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._SnapshotPolicyId = params.get("SnapshotPolicyId")
        self._SnapshotFileId = params.get("SnapshotFileId")
        self._BackupTime = params.get("BackupTime")
        self._Operator = params.get("Operator")
        if params.get("OriginalData") is not None:
            self._OriginalData = []
            for item in params.get("OriginalData"):
                obj = SecurityGroupPolicy()
                obj._deserialize(item)
                self._OriginalData.append(obj)
        if params.get("BackupData") is not None:
            self._BackupData = []
            for item in params.get("BackupData"):
                obj = SecurityGroupPolicy()
                obj._deserialize(item)
                self._BackupData.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSnapshotAttachedInstancesRequest(AbstractModel):
    """DescribeSnapshotAttachedInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SnapshotPolicyId: 快照策略Id。
        :type SnapshotPolicyId: str
        :param _Filters: 过滤条件。
支持的过滤条件如下：
<li>instance-id：实例ID。</li>
<li>instance-region：实例所在地域。</li>
        :type Filters: list of Filter
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Limit: 返回数量，默认为20，最大为200。
        :type Limit: int
        """
        self._SnapshotPolicyId = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def SnapshotPolicyId(self):
        """快照策略Id。
        :rtype: str
        """
        return self._SnapshotPolicyId

    @SnapshotPolicyId.setter
    def SnapshotPolicyId(self, SnapshotPolicyId):
        self._SnapshotPolicyId = SnapshotPolicyId

    @property
    def Filters(self):
        """过滤条件。
支持的过滤条件如下：
<li>instance-id：实例ID。</li>
<li>instance-region：实例所在地域。</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量，默认为0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量，默认为20，最大为200。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SnapshotPolicyId = params.get("SnapshotPolicyId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSnapshotAttachedInstancesResponse(AbstractModel):
    """DescribeSnapshotAttachedInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceSet: 实例列表
        :type InstanceSet: list of SnapshotInstance
        :param _TotalCount: 符合条件的对象数。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._InstanceSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def InstanceSet(self):
        """实例列表
        :rtype: list of SnapshotInstance
        """
        return self._InstanceSet

    @InstanceSet.setter
    def InstanceSet(self, InstanceSet):
        self._InstanceSet = InstanceSet

    @property
    def TotalCount(self):
        """符合条件的对象数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("InstanceSet") is not None:
            self._InstanceSet = []
            for item in params.get("InstanceSet"):
                obj = SnapshotInstance()
                obj._deserialize(item)
                self._InstanceSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeSnapshotFilesRequest(AbstractModel):
    """DescribeSnapshotFiles请求参数结构体

    """

    def __init__(self):
        r"""
        :param _BusinessType: 业务类型，目前支持安全组：securitygroup。
        :type BusinessType: str
        :param _InstanceId: 业务实例Id，和BusinessType对应。
        :type InstanceId: str
        :param _StartDate: 开始日期，格式%Y-%m-%d %H:%M:%S。
        :type StartDate: str
        :param _EndDate: 结束日期，格式%Y-%m-%d %H:%M:%S。
        :type EndDate: str
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Limit: 返回数量，默认为20，最大为100。
        :type Limit: int
        """
        self._BusinessType = None
        self._InstanceId = None
        self._StartDate = None
        self._EndDate = None
        self._Offset = None
        self._Limit = None

    @property
    def BusinessType(self):
        """业务类型，目前支持安全组：securitygroup。
        :rtype: str
        """
        return self._BusinessType

    @BusinessType.setter
    def BusinessType(self, BusinessType):
        self._BusinessType = BusinessType

    @property
    def InstanceId(self):
        """业务实例Id，和BusinessType对应。
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def StartDate(self):
        """开始日期，格式%Y-%m-%d %H:%M:%S。
        :rtype: str
        """
        return self._StartDate

    @StartDate.setter
    def StartDate(self, StartDate):
        self._StartDate = StartDate

    @property
    def EndDate(self):
        """结束日期，格式%Y-%m-%d %H:%M:%S。
        :rtype: str
        """
        return self._EndDate

    @EndDate.setter
    def EndDate(self, EndDate):
        self._EndDate = EndDate

    @property
    def Offset(self):
        """偏移量，默认为0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量，默认为20，最大为100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._BusinessType = params.get("BusinessType")
        self._InstanceId = params.get("InstanceId")
        self._StartDate = params.get("StartDate")
        self._EndDate = params.get("EndDate")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSnapshotFilesResponse(AbstractModel):
    """DescribeSnapshotFiles返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SnapshotFileSet: 快照文件集合。
        :type SnapshotFileSet: list of SnapshotFileInfo
        :param _TotalCount: 符合条件的对象数。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SnapshotFileSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SnapshotFileSet(self):
        """快照文件集合。
        :rtype: list of SnapshotFileInfo
        """
        return self._SnapshotFileSet

    @SnapshotFileSet.setter
    def SnapshotFileSet(self, SnapshotFileSet):
        self._SnapshotFileSet = SnapshotFileSet

    @property
    def TotalCount(self):
        """符合条件的对象数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SnapshotFileSet") is not None:
            self._SnapshotFileSet = []
            for item in params.get("SnapshotFileSet"):
                obj = SnapshotFileInfo()
                obj._deserialize(item)
                self._SnapshotFileSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeSnapshotPoliciesRequest(AbstractModel):
    """DescribeSnapshotPolicies请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SnapshotPolicyIds: 快照策略Id。
        :type SnapshotPolicyIds: list of str
        :param _Filters: 过滤条件，参数不支持同时指定SnapshotPolicyIds和Filters。
<li>snapshot-policy-id - String -（过滤条件）快照策略ID。</li>
<li>snapshot-policy-name - String -（过滤条件）快照策略名称。</li>
        :type Filters: list of Filter
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Limit: 返回数量，默认为20，最大为200。
        :type Limit: int
        """
        self._SnapshotPolicyIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def SnapshotPolicyIds(self):
        """快照策略Id。
        :rtype: list of str
        """
        return self._SnapshotPolicyIds

    @SnapshotPolicyIds.setter
    def SnapshotPolicyIds(self, SnapshotPolicyIds):
        self._SnapshotPolicyIds = SnapshotPolicyIds

    @property
    def Filters(self):
        """过滤条件，参数不支持同时指定SnapshotPolicyIds和Filters。
<li>snapshot-policy-id - String -（过滤条件）快照策略ID。</li>
<li>snapshot-policy-name - String -（过滤条件）快照策略名称。</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量，默认为0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量，默认为20，最大为200。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SnapshotPolicyIds = params.get("SnapshotPolicyIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSnapshotPoliciesResponse(AbstractModel):
    """DescribeSnapshotPolicies返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SnapshotPolicySet: 快照策略。
        :type SnapshotPolicySet: list of SnapshotPolicy
        :param _TotalCount: 符合条件的对象数。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SnapshotPolicySet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SnapshotPolicySet(self):
        """快照策略。
        :rtype: list of SnapshotPolicy
        """
        return self._SnapshotPolicySet

    @SnapshotPolicySet.setter
    def SnapshotPolicySet(self, SnapshotPolicySet):
        self._SnapshotPolicySet = SnapshotPolicySet

    @property
    def TotalCount(self):
        """符合条件的对象数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SnapshotPolicySet") is not None:
            self._SnapshotPolicySet = []
            for item in params.get("SnapshotPolicySet"):
                obj = SnapshotPolicy()
                obj._deserialize(item)
                self._SnapshotPolicySet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeSpecificTrafficPackageUsedDetailsRequest(AbstractModel):
    """DescribeSpecificTrafficPackageUsedDetails请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TrafficPackageId: 共享流量包唯一ID
        :type TrafficPackageId: str
        :param _Filters: 每次请求的`Filters`的上限为10，`Filter.Values`的上限为5。详细的过滤条件如下：<li> resource-id - String - 是否必填：否 - （过滤条件）按照抵扣流量资源的唯一 ID 过滤。</li><li> resource-type - String - 是否必填：否 - （过滤条件）按照资源类型过滤，资源类型包括 CVM 和 EIP </li>
        :type Filters: list of Filter
        :param _OrderField: 排序条件。该参数仅支持根据抵扣量排序，传值为 deduction
        :type OrderField: str
        :param _OrderType: 排序类型，仅支持0和1，0-降序，1-升序。不传默认为0
        :type OrderType: int
        :param _StartTime: 开始时间。不传默认为当前时间往前推30天
        :type StartTime: str
        :param _EndTime: 结束时间。不传默认为当前时间
        :type EndTime: str
        :param _Offset: 偏移量，默认为0。关于Offset的更进一步介绍请参考 API 中的相关小节
        :type Offset: int
        :param _Limit: 返回数量，默认为20。关于Limit的更进一步介绍请参考 API 中的相关小节。
        :type Limit: int
        """
        self._TrafficPackageId = None
        self._Filters = None
        self._OrderField = None
        self._OrderType = None
        self._StartTime = None
        self._EndTime = None
        self._Offset = None
        self._Limit = None

    @property
    def TrafficPackageId(self):
        """共享流量包唯一ID
        :rtype: str
        """
        return self._TrafficPackageId

    @TrafficPackageId.setter
    def TrafficPackageId(self, TrafficPackageId):
        self._TrafficPackageId = TrafficPackageId

    @property
    def Filters(self):
        """每次请求的`Filters`的上限为10，`Filter.Values`的上限为5。详细的过滤条件如下：<li> resource-id - String - 是否必填：否 - （过滤条件）按照抵扣流量资源的唯一 ID 过滤。</li><li> resource-type - String - 是否必填：否 - （过滤条件）按照资源类型过滤，资源类型包括 CVM 和 EIP </li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderField(self):
        """排序条件。该参数仅支持根据抵扣量排序，传值为 deduction
        :rtype: str
        """
        return self._OrderField

    @OrderField.setter
    def OrderField(self, OrderField):
        self._OrderField = OrderField

    @property
    def OrderType(self):
        """排序类型，仅支持0和1，0-降序，1-升序。不传默认为0
        :rtype: int
        """
        return self._OrderType

    @OrderType.setter
    def OrderType(self, OrderType):
        self._OrderType = OrderType

    @property
    def StartTime(self):
        """开始时间。不传默认为当前时间往前推30天
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束时间。不传默认为当前时间
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Offset(self):
        """偏移量，默认为0。关于Offset的更进一步介绍请参考 API 中的相关小节
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量，默认为20。关于Limit的更进一步介绍请参考 API 中的相关小节。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._TrafficPackageId = params.get("TrafficPackageId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._OrderField = params.get("OrderField")
        self._OrderType = params.get("OrderType")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSpecificTrafficPackageUsedDetailsResponse(AbstractModel):
    """DescribeSpecificTrafficPackageUsedDetails返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合查询条件的共享流量包用量明细的总数
        :type TotalCount: int
        :param _UsedDetailSet: 共享流量包用量明细列表
        :type UsedDetailSet: list of UsedDetail
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._UsedDetailSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """符合查询条件的共享流量包用量明细的总数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def UsedDetailSet(self):
        """共享流量包用量明细列表
        :rtype: list of UsedDetail
        """
        return self._UsedDetailSet

    @UsedDetailSet.setter
    def UsedDetailSet(self, UsedDetailSet):
        self._UsedDetailSet = UsedDetailSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("UsedDetailSet") is not None:
            self._UsedDetailSet = []
            for item in params.get("UsedDetailSet"):
                obj = UsedDetail()
                obj._deserialize(item)
                self._UsedDetailSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSubnetResourceDashboardRequest(AbstractModel):
    """DescribeSubnetResourceDashboard请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubnetIds: Subnet实例ID，例如：subnet-f1xjkw1b。
        :type SubnetIds: list of str
        """
        self._SubnetIds = None

    @property
    def SubnetIds(self):
        """Subnet实例ID，例如：subnet-f1xjkw1b。
        :rtype: list of str
        """
        return self._SubnetIds

    @SubnetIds.setter
    def SubnetIds(self, SubnetIds):
        self._SubnetIds = SubnetIds


    def _deserialize(self, params):
        self._SubnetIds = params.get("SubnetIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSubnetResourceDashboardResponse(AbstractModel):
    """DescribeSubnetResourceDashboard返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ResourceStatisticsSet: 资源统计结果。
        :type ResourceStatisticsSet: list of ResourceStatistics
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ResourceStatisticsSet = None
        self._RequestId = None

    @property
    def ResourceStatisticsSet(self):
        """资源统计结果。
        :rtype: list of ResourceStatistics
        """
        return self._ResourceStatisticsSet

    @ResourceStatisticsSet.setter
    def ResourceStatisticsSet(self, ResourceStatisticsSet):
        self._ResourceStatisticsSet = ResourceStatisticsSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ResourceStatisticsSet") is not None:
            self._ResourceStatisticsSet = []
            for item in params.get("ResourceStatisticsSet"):
                obj = ResourceStatistics()
                obj._deserialize(item)
                self._ResourceStatisticsSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSubnetsRequest(AbstractModel):
    """DescribeSubnets请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SubnetIds: 子网实例ID查询。形如：subnet-pxir56ns。每次请求的实例的上限为100。参数不支持同时指定SubnetIds和Filters。
        :type SubnetIds: list of str
        :param _Filters: 过滤条件，参数不支持同时指定SubnetIds和Filters。
<li>subnet-id - String - （过滤条件）Subnet实例名称。</li>
<li>vpc-id - String - （过滤条件）VPC实例ID，形如：vpc-f49l6u0z。</li>
<li>cidr-block - String - （过滤条件）子网网段，形如: 192.168.1.0 。</li>
<li>is-default - Boolean - （过滤条件）是否是默认子网。</li>
<li>is-remote-vpc-snat - Boolean - （过滤条件）是否为VPC SNAT地址池子网。</li>
<li>subnet-name - String - （过滤条件）子网名称。</li>
<li>zone - String - （过滤条件）可用区。</li>
<li>tag-key - String -是否必填：否- （过滤条件）按照标签键进行过滤。</li>
<li>tag:tag-key - String - 是否必填：否 - （过滤条件）按照标签键值对进行过滤。 tag-key使用具体的标签键进行替换。使用请参考示例2。</li>
<li>cdc-id - String - 是否必填：否 - （过滤条件）按照cdc信息进行过滤。过滤出来制定cdc下的子网。</li>
<li>is-cdc-subnet - String - 是否必填：否 - （过滤条件）按照是否是cdc子网进行过滤。取值：“0”-非cdc子网，“1”--cdc子网</li>
<li>ipv6-cidr-block - String - （过滤条件）IPv6子网网段，形如: 2402:4e00:1717:8700::/64 。</li>
<li>isp-type  - String - （过滤条件）运营商类型，形如: BGP 。</li>
        :type Filters: list of Filter
        :param _Offset: 偏移量，默认为0。
        :type Offset: str
        :param _Limit: 返回数量，默认为20，最大值为100。
        :type Limit: str
        """
        self._SubnetIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def SubnetIds(self):
        """子网实例ID查询。形如：subnet-pxir56ns。每次请求的实例的上限为100。参数不支持同时指定SubnetIds和Filters。
        :rtype: list of str
        """
        return self._SubnetIds

    @SubnetIds.setter
    def SubnetIds(self, SubnetIds):
        self._SubnetIds = SubnetIds

    @property
    def Filters(self):
        """过滤条件，参数不支持同时指定SubnetIds和Filters。
<li>subnet-id - String - （过滤条件）Subnet实例名称。</li>
<li>vpc-id - String - （过滤条件）VPC实例ID，形如：vpc-f49l6u0z。</li>
<li>cidr-block - String - （过滤条件）子网网段，形如: 192.168.1.0 。</li>
<li>is-default - Boolean - （过滤条件）是否是默认子网。</li>
<li>is-remote-vpc-snat - Boolean - （过滤条件）是否为VPC SNAT地址池子网。</li>
<li>subnet-name - String - （过滤条件）子网名称。</li>
<li>zone - String - （过滤条件）可用区。</li>
<li>tag-key - String -是否必填：否- （过滤条件）按照标签键进行过滤。</li>
<li>tag:tag-key - String - 是否必填：否 - （过滤条件）按照标签键值对进行过滤。 tag-key使用具体的标签键进行替换。使用请参考示例2。</li>
<li>cdc-id - String - 是否必填：否 - （过滤条件）按照cdc信息进行过滤。过滤出来制定cdc下的子网。</li>
<li>is-cdc-subnet - String - 是否必填：否 - （过滤条件）按照是否是cdc子网进行过滤。取值：“0”-非cdc子网，“1”--cdc子网</li>
<li>ipv6-cidr-block - String - （过滤条件）IPv6子网网段，形如: 2402:4e00:1717:8700::/64 。</li>
<li>isp-type  - String - （过滤条件）运营商类型，形如: BGP 。</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量，默认为0。
        :rtype: str
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量，默认为20，最大值为100。
        :rtype: str
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SubnetIds = params.get("SubnetIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSubnetsResponse(AbstractModel):
    """DescribeSubnets返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合条件的实例数量。
        :type TotalCount: int
        :param _SubnetSet: 子网对象。
        :type SubnetSet: list of Subnet
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._SubnetSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """符合条件的实例数量。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def SubnetSet(self):
        """子网对象。
        :rtype: list of Subnet
        """
        return self._SubnetSet

    @SubnetSet.setter
    def SubnetSet(self, SubnetSet):
        self._SubnetSet = SubnetSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("SubnetSet") is not None:
            self._SubnetSet = []
            for item in params.get("SubnetSet"):
                obj = Subnet()
                obj._deserialize(item)
                self._SubnetSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTaskResultRequest(AbstractModel):
    """DescribeTaskResult请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 异步任务ID。TaskId和DealName必填一个参数
        :type TaskId: int
        :param _DealName: 计费订单号。TaskId和DealName必填一个参数
        :type DealName: str
        """
        self._TaskId = None
        self._DealName = None

    @property
    def TaskId(self):
        """异步任务ID。TaskId和DealName必填一个参数
        :rtype: int
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def DealName(self):
        """计费订单号。TaskId和DealName必填一个参数
        :rtype: str
        """
        return self._DealName

    @DealName.setter
    def DealName(self, DealName):
        self._DealName = DealName


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._DealName = params.get("DealName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskResultResponse(AbstractModel):
    """DescribeTaskResult返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务ID
        :type TaskId: int
        :param _Result: 执行结果，包括"SUCCESS", "FAILED", "RUNNING"
        :type Result: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._Result = None
        self._RequestId = None

    @property
    def TaskId(self):
        """任务ID
        :rtype: int
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Result(self):
        """执行结果，包括"SUCCESS", "FAILED", "RUNNING"
        :rtype: str
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class DescribeTemplateLimitsRequest(AbstractModel):
    """DescribeTemplateLimits请求参数结构体

    """


class DescribeTemplateLimitsResponse(AbstractModel):
    """DescribeTemplateLimits返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TemplateLimit: 参数模板配额对象。
        :type TemplateLimit: :class:`tencentcloud.vpc.v20170312.models.TemplateLimit`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TemplateLimit = None
        self._RequestId = None

    @property
    def TemplateLimit(self):
        """参数模板配额对象。
        :rtype: :class:`tencentcloud.vpc.v20170312.models.TemplateLimit`
        """
        return self._TemplateLimit

    @TemplateLimit.setter
    def TemplateLimit(self, TemplateLimit):
        self._TemplateLimit = TemplateLimit

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TemplateLimit") is not None:
            self._TemplateLimit = TemplateLimit()
            self._TemplateLimit._deserialize(params.get("TemplateLimit"))
        self._RequestId = params.get("RequestId")


class DescribeTenantCcnsRequest(AbstractModel):
    """DescribeTenantCcns请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤条件，目前`value`值个数只支持一个，允许可支持的字段有：
<li>`ccn-ids` 云联网ID数组，值形如：`["ccn-12345678"]`</li> 
<li>`user-account-id` 用户账号ID，值形如：`["12345678"]`</li><li>`is-security-lock` 是否锁定，值形如：`["true"]`</li>
        :type Filters: list of Filter
        :param _Offset: 偏移量，默认0。
        :type Offset: int
        :param _Limit: 单页返回数据量，可选值0到100之间的整数，默认20。
        :type Limit: int
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def Filters(self):
        """过滤条件，目前`value`值个数只支持一个，允许可支持的字段有：
<li>`ccn-ids` 云联网ID数组，值形如：`["ccn-12345678"]`</li> 
<li>`user-account-id` 用户账号ID，值形如：`["12345678"]`</li><li>`is-security-lock` 是否锁定，值形如：`["true"]`</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量，默认0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """单页返回数据量，可选值0到100之间的整数，默认20。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTenantCcnsResponse(AbstractModel):
    """DescribeTenantCcns返回参数结构体

    """

    def __init__(self):
        r"""
        :param _CcnSet: 云联网（CCN）对象。
注意：此字段可能返回 null，表示取不到有效值。
        :type CcnSet: list of CcnInstanceInfo
        :param _TotalCount: 符合条件的对象总数。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._CcnSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def CcnSet(self):
        """云联网（CCN）对象。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of CcnInstanceInfo
        """
        return self._CcnSet

    @CcnSet.setter
    def CcnSet(self, CcnSet):
        self._CcnSet = CcnSet

    @property
    def TotalCount(self):
        """符合条件的对象总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("CcnSet") is not None:
            self._CcnSet = []
            for item in params.get("CcnSet"):
                obj = CcnInstanceInfo()
                obj._deserialize(item)
                self._CcnSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeTrafficPackagesRequest(AbstractModel):
    """DescribeTrafficPackages请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TrafficPackageIds: 共享流量包ID，支持批量
        :type TrafficPackageIds: list of str
        :param _Filters: 每次请求的`Filters`的上限为10。参数不支持同时指定`TrafficPackageIds`和`Filters`。详细的过滤条件如下：<li> traffic-package_id - String - 是否必填：否 - （过滤条件）按照共享流量包的唯一标识ID过滤。</li><li> traffic-package-name - String - 是否必填：否 - （过滤条件）按照共享流量包名称过滤。不支持模糊过滤。</li><li> status - String - 是否必填：否 - （过滤条件）按照共享流量包状态过滤。可选状态：[AVAILABLE|EXPIRED|EXHAUSTED]</li>
        :type Filters: list of Filter
        :param _Offset: 分页参数
        :type Offset: int
        :param _Limit: 分页参数
        :type Limit: int
        """
        self._TrafficPackageIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def TrafficPackageIds(self):
        """共享流量包ID，支持批量
        :rtype: list of str
        """
        return self._TrafficPackageIds

    @TrafficPackageIds.setter
    def TrafficPackageIds(self, TrafficPackageIds):
        self._TrafficPackageIds = TrafficPackageIds

    @property
    def Filters(self):
        """每次请求的`Filters`的上限为10。参数不支持同时指定`TrafficPackageIds`和`Filters`。详细的过滤条件如下：<li> traffic-package_id - String - 是否必填：否 - （过滤条件）按照共享流量包的唯一标识ID过滤。</li><li> traffic-package-name - String - 是否必填：否 - （过滤条件）按照共享流量包名称过滤。不支持模糊过滤。</li><li> status - String - 是否必填：否 - （过滤条件）按照共享流量包状态过滤。可选状态：[AVAILABLE|EXPIRED|EXHAUSTED]</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """分页参数
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """分页参数
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._TrafficPackageIds = params.get("TrafficPackageIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTrafficPackagesResponse(AbstractModel):
    """DescribeTrafficPackages返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 按照条件查询出来的流量包数量
        :type TotalCount: int
        :param _TrafficPackageSet: 流量包信息
        :type TrafficPackageSet: list of TrafficPackage
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._TrafficPackageSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """按照条件查询出来的流量包数量
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TrafficPackageSet(self):
        """流量包信息
        :rtype: list of TrafficPackage
        """
        return self._TrafficPackageSet

    @TrafficPackageSet.setter
    def TrafficPackageSet(self, TrafficPackageSet):
        self._TrafficPackageSet = TrafficPackageSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("TrafficPackageSet") is not None:
            self._TrafficPackageSet = []
            for item in params.get("TrafficPackageSet"):
                obj = TrafficPackage()
                obj._deserialize(item)
                self._TrafficPackageSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeUsedIpAddressRequest(AbstractModel):
    """DescribeUsedIpAddress请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VpcId: VPC实例ID。
        :type VpcId: str
        :param _SubnetId: 子网实例ID。
        :type SubnetId: str
        :param _IpAddresses: 查询是否占用的ip列表，ip需要在vpc或子网内。最多允许一次查询100个IP。
        :type IpAddresses: list of str
        :param _Filters: 过滤条件，不支持同时指定IpAddresses和Filters参数。 支持的过滤条件如下： <li>ip-addresses：IP地址。</li> <li>resource-id：资源ID。</li>
        :type Filters: list of Filter
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Limit: 返回数量，默认为20，最大值为100。
        :type Limit: int
        """
        self._VpcId = None
        self._SubnetId = None
        self._IpAddresses = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def VpcId(self):
        """VPC实例ID。
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        """子网实例ID。
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def IpAddresses(self):
        """查询是否占用的ip列表，ip需要在vpc或子网内。最多允许一次查询100个IP。
        :rtype: list of str
        """
        return self._IpAddresses

    @IpAddresses.setter
    def IpAddresses(self, IpAddresses):
        self._IpAddresses = IpAddresses

    @property
    def Filters(self):
        """过滤条件，不支持同时指定IpAddresses和Filters参数。 支持的过滤条件如下： <li>ip-addresses：IP地址。</li> <li>resource-id：资源ID。</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量，默认为0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量，默认为20，最大值为100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._IpAddresses = params.get("IpAddresses")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeUsedIpAddressResponse(AbstractModel):
    """DescribeUsedIpAddress返回参数结构体

    """

    def __init__(self):
        r"""
        :param _IpAddressStates: 占用ip地址的资源信息
        :type IpAddressStates: list of IpAddressStates
        :param _TotalCount: 返回占用资源的个数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._IpAddressStates = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def IpAddressStates(self):
        """占用ip地址的资源信息
        :rtype: list of IpAddressStates
        """
        return self._IpAddressStates

    @IpAddressStates.setter
    def IpAddressStates(self, IpAddressStates):
        self._IpAddressStates = IpAddressStates

    @property
    def TotalCount(self):
        """返回占用资源的个数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("IpAddressStates") is not None:
            self._IpAddressStates = []
            for item in params.get("IpAddressStates"):
                obj = IpAddressStates()
                obj._deserialize(item)
                self._IpAddressStates.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeVpcEndPointRequest(AbstractModel):
    """DescribeVpcEndPoint请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤条件。
<li> end-point-service-id- String - （过滤条件）终端节点服务ID。</li>
<li>end-point-name - String - （过滤条件）终端节点实例名称。</li>
<li> end-point-id- String - （过滤条件）终端节点实例ID。</li>
<li> vpc-id- String - （过滤条件）VPC实例ID。</li>
        :type Filters: list of Filter
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Limit: 单页返回数量，默认为20，最大值为100。
        :type Limit: int
        :param _EndPointId: 终端节点ID列表。
        :type EndPointId: list of str
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._EndPointId = None

    @property
    def Filters(self):
        """过滤条件。
<li> end-point-service-id- String - （过滤条件）终端节点服务ID。</li>
<li>end-point-name - String - （过滤条件）终端节点实例名称。</li>
<li> end-point-id- String - （过滤条件）终端节点实例ID。</li>
<li> vpc-id- String - （过滤条件）VPC实例ID。</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量，默认为0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """单页返回数量，默认为20，最大值为100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def EndPointId(self):
        """终端节点ID列表。
        :rtype: list of str
        """
        return self._EndPointId

    @EndPointId.setter
    def EndPointId(self, EndPointId):
        self._EndPointId = EndPointId


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._EndPointId = params.get("EndPointId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVpcEndPointResponse(AbstractModel):
    """DescribeVpcEndPoint返回参数结构体

    """

    def __init__(self):
        r"""
        :param _EndPointSet: 终端节点对象。
        :type EndPointSet: list of EndPoint
        :param _TotalCount: 符合查询条件的终端节点个数。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._EndPointSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def EndPointSet(self):
        """终端节点对象。
        :rtype: list of EndPoint
        """
        return self._EndPointSet

    @EndPointSet.setter
    def EndPointSet(self, EndPointSet):
        self._EndPointSet = EndPointSet

    @property
    def TotalCount(self):
        """符合查询条件的终端节点个数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("EndPointSet") is not None:
            self._EndPointSet = []
            for item in params.get("EndPointSet"):
                obj = EndPoint()
                obj._deserialize(item)
                self._EndPointSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeVpcEndPointServiceRequest(AbstractModel):
    """DescribeVpcEndPointService请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤条件。不支持同时传入参数 EndPointServiceIds and Filters。
<li> service-id - String - （过滤条件）终端节点服务唯一ID。</li>
<li>service-name - String - （过滤条件）终端节点实例名称。</li>
<li>service-instance-id - String - （过滤条件）后端服务的唯一ID，比如lb-xxx。</li>
<li>service-type - String - （过滤条件）后端PAAS服务类型，CLB,CDB,CRS，不填默认查询类型为CLB。</li>
        :type Filters: list of Filter
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Limit: 单页返回数量，默认为20，最大值为100。
        :type Limit: int
        :param _EndPointServiceIds: 终端节点服务ID。不支持同时传入参数 EndPointServiceIds and Filters。
        :type EndPointServiceIds: list of str
        :param _IsListAuthorizedEndPointService: <li>不支持同时传入参数 Filters 。</li> <li>列出授权给当前账号的终端节点服务信息。可以配合EndPointServiceIds参数进行过滤，哪些终端节点服务授权了该账户。</li>
        :type IsListAuthorizedEndPointService: bool
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._EndPointServiceIds = None
        self._IsListAuthorizedEndPointService = None

    @property
    def Filters(self):
        """过滤条件。不支持同时传入参数 EndPointServiceIds and Filters。
<li> service-id - String - （过滤条件）终端节点服务唯一ID。</li>
<li>service-name - String - （过滤条件）终端节点实例名称。</li>
<li>service-instance-id - String - （过滤条件）后端服务的唯一ID，比如lb-xxx。</li>
<li>service-type - String - （过滤条件）后端PAAS服务类型，CLB,CDB,CRS，不填默认查询类型为CLB。</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量，默认为0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """单页返回数量，默认为20，最大值为100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def EndPointServiceIds(self):
        """终端节点服务ID。不支持同时传入参数 EndPointServiceIds and Filters。
        :rtype: list of str
        """
        return self._EndPointServiceIds

    @EndPointServiceIds.setter
    def EndPointServiceIds(self, EndPointServiceIds):
        self._EndPointServiceIds = EndPointServiceIds

    @property
    def IsListAuthorizedEndPointService(self):
        """<li>不支持同时传入参数 Filters 。</li> <li>列出授权给当前账号的终端节点服务信息。可以配合EndPointServiceIds参数进行过滤，哪些终端节点服务授权了该账户。</li>
        :rtype: bool
        """
        return self._IsListAuthorizedEndPointService

    @IsListAuthorizedEndPointService.setter
    def IsListAuthorizedEndPointService(self, IsListAuthorizedEndPointService):
        self._IsListAuthorizedEndPointService = IsListAuthorizedEndPointService


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._EndPointServiceIds = params.get("EndPointServiceIds")
        self._IsListAuthorizedEndPointService = params.get("IsListAuthorizedEndPointService")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVpcEndPointServiceResponse(AbstractModel):
    """DescribeVpcEndPointService返回参数结构体

    """

    def __init__(self):
        r"""
        :param _EndPointServiceSet: 终端节点服务对象数组。
        :type EndPointServiceSet: list of EndPointService
        :param _TotalCount: 符合查询条件的个数。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._EndPointServiceSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def EndPointServiceSet(self):
        """终端节点服务对象数组。
        :rtype: list of EndPointService
        """
        return self._EndPointServiceSet

    @EndPointServiceSet.setter
    def EndPointServiceSet(self, EndPointServiceSet):
        self._EndPointServiceSet = EndPointServiceSet

    @property
    def TotalCount(self):
        """符合查询条件的个数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("EndPointServiceSet") is not None:
            self._EndPointServiceSet = []
            for item in params.get("EndPointServiceSet"):
                obj = EndPointService()
                obj._deserialize(item)
                self._EndPointServiceSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeVpcEndPointServiceWhiteListRequest(AbstractModel):
    """DescribeVpcEndPointServiceWhiteList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Limit: 单页返回数量，默认为20，最大值为100。
        :type Limit: int
        :param _Filters: 过滤条件。
<li> user-uin String - （过滤条件）用户UIN。</li>
<li> end-point-service-id String - （过滤条件）终端节点服务ID。</li>
        :type Filters: list of Filter
        """
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def Offset(self):
        """偏移量，默认为0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """单页返回数量，默认为20，最大值为100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        """过滤条件。
<li> user-uin String - （过滤条件）用户UIN。</li>
<li> end-point-service-id String - （过滤条件）终端节点服务ID。</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVpcEndPointServiceWhiteListResponse(AbstractModel):
    """DescribeVpcEndPointServiceWhiteList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _VpcEndpointServiceUserSet: 白名单对象数组。已废弃
        :type VpcEndpointServiceUserSet: list of VpcEndPointServiceUser
        :param _VpcEndPointServiceUserSet: 白名单对象数组。
        :type VpcEndPointServiceUserSet: list of VpcEndPointServiceUser
        :param _TotalCount: 符合条件的白名单个数。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._VpcEndpointServiceUserSet = None
        self._VpcEndPointServiceUserSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def VpcEndpointServiceUserSet(self):
        """白名单对象数组。已废弃
        :rtype: list of VpcEndPointServiceUser
        """
        return self._VpcEndpointServiceUserSet

    @VpcEndpointServiceUserSet.setter
    def VpcEndpointServiceUserSet(self, VpcEndpointServiceUserSet):
        self._VpcEndpointServiceUserSet = VpcEndpointServiceUserSet

    @property
    def VpcEndPointServiceUserSet(self):
        """白名单对象数组。
        :rtype: list of VpcEndPointServiceUser
        """
        return self._VpcEndPointServiceUserSet

    @VpcEndPointServiceUserSet.setter
    def VpcEndPointServiceUserSet(self, VpcEndPointServiceUserSet):
        self._VpcEndPointServiceUserSet = VpcEndPointServiceUserSet

    @property
    def TotalCount(self):
        """符合条件的白名单个数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("VpcEndpointServiceUserSet") is not None:
            self._VpcEndpointServiceUserSet = []
            for item in params.get("VpcEndpointServiceUserSet"):
                obj = VpcEndPointServiceUser()
                obj._deserialize(item)
                self._VpcEndpointServiceUserSet.append(obj)
        if params.get("VpcEndPointServiceUserSet") is not None:
            self._VpcEndPointServiceUserSet = []
            for item in params.get("VpcEndPointServiceUserSet"):
                obj = VpcEndPointServiceUser()
                obj._deserialize(item)
                self._VpcEndPointServiceUserSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeVpcInstancesRequest(AbstractModel):
    """DescribeVpcInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: <li>vpc-id - String - （过滤条件）VPC实例ID，形如：vpc-f49l6u0z。</li>
<li>instance-id - String - （过滤条件）云主机实例ID。</li>
<li>instance-name - String - （过滤条件）云主机名称。</li>
        :type Filters: list of Filter
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Limit: 返回数量，默认为20，最大值为100。
        :type Limit: int
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def Filters(self):
        """<li>vpc-id - String - （过滤条件）VPC实例ID，形如：vpc-f49l6u0z。</li>
<li>instance-id - String - （过滤条件）云主机实例ID。</li>
<li>instance-name - String - （过滤条件）云主机名称。</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量，默认为0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量，默认为20，最大值为100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVpcInstancesResponse(AbstractModel):
    """DescribeVpcInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceSet: 云主机实例列表。
        :type InstanceSet: list of CvmInstance
        :param _TotalCount: 满足条件的云主机实例个数。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._InstanceSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def InstanceSet(self):
        """云主机实例列表。
        :rtype: list of CvmInstance
        """
        return self._InstanceSet

    @InstanceSet.setter
    def InstanceSet(self, InstanceSet):
        self._InstanceSet = InstanceSet

    @property
    def TotalCount(self):
        """满足条件的云主机实例个数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("InstanceSet") is not None:
            self._InstanceSet = []
            for item in params.get("InstanceSet"):
                obj = CvmInstance()
                obj._deserialize(item)
                self._InstanceSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeVpcIpv6AddressesRequest(AbstractModel):
    """DescribeVpcIpv6Addresses请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VpcId: `VPC`实例`ID`，形如：`vpc-f49l6u0z`。
        :type VpcId: str
        :param _Ipv6Addresses: `IP`地址列表，批量查询单次请求最多支持`10`个。
        :type Ipv6Addresses: list of str
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Limit: 返回数量，默认为20，最大值为100。
        :type Limit: int
        :param _SubnetId: VPC下的子网ID。
        :type SubnetId: str
        """
        self._VpcId = None
        self._Ipv6Addresses = None
        self._Offset = None
        self._Limit = None
        self._SubnetId = None

    @property
    def VpcId(self):
        """`VPC`实例`ID`，形如：`vpc-f49l6u0z`。
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def Ipv6Addresses(self):
        """`IP`地址列表，批量查询单次请求最多支持`10`个。
        :rtype: list of str
        """
        return self._Ipv6Addresses

    @Ipv6Addresses.setter
    def Ipv6Addresses(self, Ipv6Addresses):
        self._Ipv6Addresses = Ipv6Addresses

    @property
    def Offset(self):
        """偏移量，默认为0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量，默认为20，最大值为100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def SubnetId(self):
        """VPC下的子网ID。
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._Ipv6Addresses = params.get("Ipv6Addresses")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._SubnetId = params.get("SubnetId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVpcIpv6AddressesResponse(AbstractModel):
    """DescribeVpcIpv6Addresses返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Ipv6AddressSet: `IPv6`地址列表。
        :type Ipv6AddressSet: list of VpcIpv6Address
        :param _TotalCount: `IPv6`地址总数。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Ipv6AddressSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def Ipv6AddressSet(self):
        """`IPv6`地址列表。
        :rtype: list of VpcIpv6Address
        """
        return self._Ipv6AddressSet

    @Ipv6AddressSet.setter
    def Ipv6AddressSet(self, Ipv6AddressSet):
        self._Ipv6AddressSet = Ipv6AddressSet

    @property
    def TotalCount(self):
        """`IPv6`地址总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Ipv6AddressSet") is not None:
            self._Ipv6AddressSet = []
            for item in params.get("Ipv6AddressSet"):
                obj = VpcIpv6Address()
                obj._deserialize(item)
                self._Ipv6AddressSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeVpcLimitsRequest(AbstractModel):
    """DescribeVpcLimits请求参数结构体

    """

    def __init__(self):
        r"""
        :param _LimitTypes: 配额名称。每次最大查询100个配额类型。
        :type LimitTypes: list of str
        """
        self._LimitTypes = None

    @property
    def LimitTypes(self):
        """配额名称。每次最大查询100个配额类型。
        :rtype: list of str
        """
        return self._LimitTypes

    @LimitTypes.setter
    def LimitTypes(self, LimitTypes):
        self._LimitTypes = LimitTypes


    def _deserialize(self, params):
        self._LimitTypes = params.get("LimitTypes")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVpcLimitsResponse(AbstractModel):
    """DescribeVpcLimits返回参数结构体

    """

    def __init__(self):
        r"""
        :param _VpcLimitSet: 私有网络配额
        :type VpcLimitSet: list of VpcLimit
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._VpcLimitSet = None
        self._RequestId = None

    @property
    def VpcLimitSet(self):
        """私有网络配额
        :rtype: list of VpcLimit
        """
        return self._VpcLimitSet

    @VpcLimitSet.setter
    def VpcLimitSet(self, VpcLimitSet):
        self._VpcLimitSet = VpcLimitSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("VpcLimitSet") is not None:
            self._VpcLimitSet = []
            for item in params.get("VpcLimitSet"):
                obj = VpcLimit()
                obj._deserialize(item)
                self._VpcLimitSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeVpcPeeringConnectionsRequest(AbstractModel):
    """DescribeVpcPeeringConnections请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PeeringConnectionIds: 对等连接唯一ID数组。
        :type PeeringConnectionIds: list of str
        :param _Filters: 过滤条件，参数不支持同时指定PeeringConnectionIds和Filters。
<li>vpc-id - String - （过滤条件）VPC实例ID，形如：vpc-f49l6u0z。</li>
<li>state String - （过滤条件）对等连接状态，可选值有：PENDING，投放中；ACTIVE，使用中；EXPIRED，已过期；REJECTED，拒绝。</li>
<li>peering-connection-name - String - （过滤条件）对等连接名称。</li>
        :type Filters: list of Filter
        :param _Offset: 偏移量。
        :type Offset: int
        :param _Limit: 请求对象个数。
        :type Limit: int
        :param _OrderField: 排序字段，可选值有：CreatedTime，PeeringConnectionName。
        :type OrderField: str
        :param _OrderDirection: 排序方式：DESC，降序；ASC，升序。
        :type OrderDirection: str
        """
        self._PeeringConnectionIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._OrderField = None
        self._OrderDirection = None

    @property
    def PeeringConnectionIds(self):
        """对等连接唯一ID数组。
        :rtype: list of str
        """
        return self._PeeringConnectionIds

    @PeeringConnectionIds.setter
    def PeeringConnectionIds(self, PeeringConnectionIds):
        self._PeeringConnectionIds = PeeringConnectionIds

    @property
    def Filters(self):
        """过滤条件，参数不支持同时指定PeeringConnectionIds和Filters。
<li>vpc-id - String - （过滤条件）VPC实例ID，形如：vpc-f49l6u0z。</li>
<li>state String - （过滤条件）对等连接状态，可选值有：PENDING，投放中；ACTIVE，使用中；EXPIRED，已过期；REJECTED，拒绝。</li>
<li>peering-connection-name - String - （过滤条件）对等连接名称。</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """请求对象个数。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def OrderField(self):
        """排序字段，可选值有：CreatedTime，PeeringConnectionName。
        :rtype: str
        """
        return self._OrderField

    @OrderField.setter
    def OrderField(self, OrderField):
        self._OrderField = OrderField

    @property
    def OrderDirection(self):
        """排序方式：DESC，降序；ASC，升序。
        :rtype: str
        """
        return self._OrderDirection

    @OrderDirection.setter
    def OrderDirection(self, OrderDirection):
        self._OrderDirection = OrderDirection


    def _deserialize(self, params):
        self._PeeringConnectionIds = params.get("PeeringConnectionIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._OrderField = params.get("OrderField")
        self._OrderDirection = params.get("OrderDirection")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVpcPeeringConnectionsResponse(AbstractModel):
    """DescribeVpcPeeringConnections返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 满足条件的对等连接实例个数。
        :type TotalCount: int
        :param _PeerConnectionSet: 对等连接实例列表。
        :type PeerConnectionSet: list of PeerConnection
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._PeerConnectionSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """满足条件的对等连接实例个数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def PeerConnectionSet(self):
        """对等连接实例列表。
        :rtype: list of PeerConnection
        """
        return self._PeerConnectionSet

    @PeerConnectionSet.setter
    def PeerConnectionSet(self, PeerConnectionSet):
        self._PeerConnectionSet = PeerConnectionSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("PeerConnectionSet") is not None:
            self._PeerConnectionSet = []
            for item in params.get("PeerConnectionSet"):
                obj = PeerConnection()
                obj._deserialize(item)
                self._PeerConnectionSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeVpcPrivateIpAddressesRequest(AbstractModel):
    """DescribeVpcPrivateIpAddresses请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VpcId: `VPC`实例`ID`，形如：`vpc-f49l6u0z`。
        :type VpcId: str
        :param _PrivateIpAddresses: 内网`IP`地址列表，批量查询单次请求最多支持`10`个。
        :type PrivateIpAddresses: list of str
        """
        self._VpcId = None
        self._PrivateIpAddresses = None

    @property
    def VpcId(self):
        """`VPC`实例`ID`，形如：`vpc-f49l6u0z`。
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def PrivateIpAddresses(self):
        """内网`IP`地址列表，批量查询单次请求最多支持`10`个。
        :rtype: list of str
        """
        return self._PrivateIpAddresses

    @PrivateIpAddresses.setter
    def PrivateIpAddresses(self, PrivateIpAddresses):
        self._PrivateIpAddresses = PrivateIpAddresses


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._PrivateIpAddresses = params.get("PrivateIpAddresses")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVpcPrivateIpAddressesResponse(AbstractModel):
    """DescribeVpcPrivateIpAddresses返回参数结构体

    """

    def __init__(self):
        r"""
        :param _VpcPrivateIpAddressSet: 内网`IP`地址信息列表。
        :type VpcPrivateIpAddressSet: list of VpcPrivateIpAddress
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._VpcPrivateIpAddressSet = None
        self._RequestId = None

    @property
    def VpcPrivateIpAddressSet(self):
        """内网`IP`地址信息列表。
        :rtype: list of VpcPrivateIpAddress
        """
        return self._VpcPrivateIpAddressSet

    @VpcPrivateIpAddressSet.setter
    def VpcPrivateIpAddressSet(self, VpcPrivateIpAddressSet):
        self._VpcPrivateIpAddressSet = VpcPrivateIpAddressSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("VpcPrivateIpAddressSet") is not None:
            self._VpcPrivateIpAddressSet = []
            for item in params.get("VpcPrivateIpAddressSet"):
                obj = VpcPrivateIpAddress()
                obj._deserialize(item)
                self._VpcPrivateIpAddressSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeVpcResourceDashboardRequest(AbstractModel):
    """DescribeVpcResourceDashboard请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VpcIds: Vpc实例ID，例如：vpc-f1xjkw1b。
        :type VpcIds: list of str
        """
        self._VpcIds = None

    @property
    def VpcIds(self):
        """Vpc实例ID，例如：vpc-f1xjkw1b。
        :rtype: list of str
        """
        return self._VpcIds

    @VpcIds.setter
    def VpcIds(self, VpcIds):
        self._VpcIds = VpcIds


    def _deserialize(self, params):
        self._VpcIds = params.get("VpcIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVpcResourceDashboardResponse(AbstractModel):
    """DescribeVpcResourceDashboard返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ResourceDashboardSet: 资源对象列表。
        :type ResourceDashboardSet: list of ResourceDashboard
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ResourceDashboardSet = None
        self._RequestId = None

    @property
    def ResourceDashboardSet(self):
        """资源对象列表。
        :rtype: list of ResourceDashboard
        """
        return self._ResourceDashboardSet

    @ResourceDashboardSet.setter
    def ResourceDashboardSet(self, ResourceDashboardSet):
        self._ResourceDashboardSet = ResourceDashboardSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ResourceDashboardSet") is not None:
            self._ResourceDashboardSet = []
            for item in params.get("ResourceDashboardSet"):
                obj = ResourceDashboard()
                obj._deserialize(item)
                self._ResourceDashboardSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeVpcTaskResultRequest(AbstractModel):
    """DescribeVpcTaskResult请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 异步任务请求返回的RequestId。
        :type TaskId: str
        """
        self._TaskId = None

    @property
    def TaskId(self):
        """异步任务请求返回的RequestId。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVpcTaskResultResponse(AbstractModel):
    """DescribeVpcTaskResult返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Status: 异步任务执行结果。结果：SUCCESS、FAILED、RUNNING。3者其中之一。其中SUCCESS表示任务执行成功，FAILED表示任务执行失败，RUNNING表示任务执行中。
        :type Status: str
        :param _Output: 异步任务执行输出。
        :type Output: str
        :param _Result: 异步任务详细结果。只用于特殊场景，如批量删除弹性网卡时查询成功的网卡列表和失败的列表。
注意：此字段可能返回 null，表示取不到有效值。
        :type Result: list of VpcTaskResultDetailInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Status = None
        self._Output = None
        self._Result = None
        self._RequestId = None

    @property
    def Status(self):
        """异步任务执行结果。结果：SUCCESS、FAILED、RUNNING。3者其中之一。其中SUCCESS表示任务执行成功，FAILED表示任务执行失败，RUNNING表示任务执行中。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Output(self):
        """异步任务执行输出。
        :rtype: str
        """
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Result(self):
        """异步任务详细结果。只用于特殊场景，如批量删除弹性网卡时查询成功的网卡列表和失败的列表。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of VpcTaskResultDetailInfo
        """
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._Output = params.get("Output")
        if params.get("Result") is not None:
            self._Result = []
            for item in params.get("Result"):
                obj = VpcTaskResultDetailInfo()
                obj._deserialize(item)
                self._Result.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeVpcsRequest(AbstractModel):
    """DescribeVpcs请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VpcIds: VPC实例ID。形如：vpc-f49l6u0z。每次请求的实例的上限为100。参数不支持同时指定VpcIds和Filters。
        :type VpcIds: list of str
        :param _Filters: 过滤条件，不支持同时指定VpcIds和Filters参数。
支持的过滤条件如下：
<li>vpc-name：VPC实例名称，支持模糊查询。</li>
<li>is-default ：是否默认VPC。</li>
<li>vpc-id ：VPC实例ID，例如：vpc-f49l6u0z。</li>
<li>cidr-block：VPC的CIDR。</li>
<li>tag-key ：按照标签键进行过滤，非必填参数。</li>
<li>tag:tag-key：按照标签键值对进行过滤，非必填参数。 其中 tag-key 请使用具体的标签键进行替换，可参考示例2。</li>
  **说明：**若同一个过滤条件（Filter）存在多个Values，则同一Filter下Values间的关系为逻辑或（OR）关系；若存在多个过滤条件（Filter），Filter之间的关系为逻辑与（AND）关系。
<li>ipv6-cidr-block - String - （过滤条件）IPv6子网网段，形如: 2402:4e00:1717:8700::/64 。</li>
<li>isp-type  - String - （过滤条件）运营商类型，形如: BGP 取值范围：'BGP'-默认, 'CMCC'-中国移动, 'CTCC'-中国电信, 'CUCC'-中国联通。</li>
        :type Filters: list of Filter
        :param _Offset: 偏移量，默认为0。
        :type Offset: str
        :param _Limit: 返回数量，默认为20，最大值为100。
        :type Limit: str
        """
        self._VpcIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def VpcIds(self):
        """VPC实例ID。形如：vpc-f49l6u0z。每次请求的实例的上限为100。参数不支持同时指定VpcIds和Filters。
        :rtype: list of str
        """
        return self._VpcIds

    @VpcIds.setter
    def VpcIds(self, VpcIds):
        self._VpcIds = VpcIds

    @property
    def Filters(self):
        """过滤条件，不支持同时指定VpcIds和Filters参数。
支持的过滤条件如下：
<li>vpc-name：VPC实例名称，支持模糊查询。</li>
<li>is-default ：是否默认VPC。</li>
<li>vpc-id ：VPC实例ID，例如：vpc-f49l6u0z。</li>
<li>cidr-block：VPC的CIDR。</li>
<li>tag-key ：按照标签键进行过滤，非必填参数。</li>
<li>tag:tag-key：按照标签键值对进行过滤，非必填参数。 其中 tag-key 请使用具体的标签键进行替换，可参考示例2。</li>
  **说明：**若同一个过滤条件（Filter）存在多个Values，则同一Filter下Values间的关系为逻辑或（OR）关系；若存在多个过滤条件（Filter），Filter之间的关系为逻辑与（AND）关系。
<li>ipv6-cidr-block - String - （过滤条件）IPv6子网网段，形如: 2402:4e00:1717:8700::/64 。</li>
<li>isp-type  - String - （过滤条件）运营商类型，形如: BGP 取值范围：'BGP'-默认, 'CMCC'-中国移动, 'CTCC'-中国电信, 'CUCC'-中国联通。</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量，默认为0。
        :rtype: str
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量，默认为20，最大值为100。
        :rtype: str
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._VpcIds = params.get("VpcIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVpcsResponse(AbstractModel):
    """DescribeVpcs返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合条件的对象数。
        :type TotalCount: int
        :param _VpcSet: VPC对象。
        :type VpcSet: list of Vpc
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._VpcSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """符合条件的对象数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def VpcSet(self):
        """VPC对象。
        :rtype: list of Vpc
        """
        return self._VpcSet

    @VpcSet.setter
    def VpcSet(self, VpcSet):
        self._VpcSet = VpcSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("VpcSet") is not None:
            self._VpcSet = []
            for item in params.get("VpcSet"):
                obj = Vpc()
                obj._deserialize(item)
                self._VpcSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeVpnConnectionsRequest(AbstractModel):
    """DescribeVpnConnections请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VpnConnectionIds: VPN通道实例ID。形如：vpnx-f49l6u0z。每次请求的实例的上限为100。参数不支持同时指定VpnConnectionIds和Filters。
        :type VpnConnectionIds: list of str
        :param _Filters: 过滤条件。每次请求的Filters的上限为10，Filter.Values的上限为5。参数不支持同时指定VpnConnectionIds和Filters。
<li>vpc-id - String - VPC实例ID，形如：`vpc-0a36uwkr`。</li>
<li>vpn-gateway-id - String - VPN网关实例ID，形如：`vpngw-p4lmqawn`。</li>
<li>customer-gateway-id - String - 对端网关实例ID，形如：`cgw-l4rblw63`。</li>
<li>vpn-connection-name - String - 通道名称，形如：`test-vpn`。</li>
<li>vpn-connection-id - String - 通道实例ID，形如：`vpnx-5p7vkch8"`。</li>
        :type Filters: list of Filter
        :param _Offset: 偏移量，默认为0。关于Offset的更进一步介绍请参考 API 简介中的相关小节。
        :type Offset: int
        :param _Limit: 返回数量，默认为20，最大值为100。
        :type Limit: int
        """
        self._VpnConnectionIds = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def VpnConnectionIds(self):
        """VPN通道实例ID。形如：vpnx-f49l6u0z。每次请求的实例的上限为100。参数不支持同时指定VpnConnectionIds和Filters。
        :rtype: list of str
        """
        return self._VpnConnectionIds

    @VpnConnectionIds.setter
    def VpnConnectionIds(self, VpnConnectionIds):
        self._VpnConnectionIds = VpnConnectionIds

    @property
    def Filters(self):
        """过滤条件。每次请求的Filters的上限为10，Filter.Values的上限为5。参数不支持同时指定VpnConnectionIds和Filters。
<li>vpc-id - String - VPC实例ID，形如：`vpc-0a36uwkr`。</li>
<li>vpn-gateway-id - String - VPN网关实例ID，形如：`vpngw-p4lmqawn`。</li>
<li>customer-gateway-id - String - 对端网关实例ID，形如：`cgw-l4rblw63`。</li>
<li>vpn-connection-name - String - 通道名称，形如：`test-vpn`。</li>
<li>vpn-connection-id - String - 通道实例ID，形如：`vpnx-5p7vkch8"`。</li>
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量，默认为0。关于Offset的更进一步介绍请参考 API 简介中的相关小节。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量，默认为20，最大值为100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._VpnConnectionIds = params.get("VpnConnectionIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVpnConnectionsResponse(AbstractModel):
    """DescribeVpnConnections返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合条件的实例数量。
        :type TotalCount: int
        :param _VpnConnectionSet: VPN通道实例。
        :type VpnConnectionSet: list of VpnConnection
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._VpnConnectionSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        """符合条件的实例数量。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def VpnConnectionSet(self):
        """VPN通道实例。
        :rtype: list of VpnConnection
        """
        return self._VpnConnectionSet

    @VpnConnectionSet.setter
    def VpnConnectionSet(self, VpnConnectionSet):
        self._VpnConnectionSet = VpnConnectionSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("VpnConnectionSet") is not None:
            self._VpnConnectionSet = []
            for item in params.get("VpnConnectionSet"):
                obj = VpnConnection()
                obj._deserialize(item)
                self._VpnConnectionSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeVpnGatewayCcnRoutesRequest(AbstractModel):
    """DescribeVpnGatewayCcnRoutes请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VpnGatewayId: VPN网关实例ID。
        :type VpnGatewayId: str
        :param _Offset: 偏移量。默认值：0
        :type Offset: int
        :param _Limit: 返回数量。默认值：20
        :type Limit: int
        """
        self._VpnGatewayId = None
        self._Offset = None
        self._Limit = None

    @property
    def VpnGatewayId(self):
        """VPN网关实例ID。
        :rtype: str
        """
        return self._VpnGatewayId

    @VpnGatewayId.setter
    def VpnGatewayId(self, VpnGatewayId):
        self._VpnGatewayId = VpnGatewayId

    @property
    def Offset(self):
        """偏移量。默认值：0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """返回数量。默认值：20
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._VpnGatewayId = params.get("VpnGatewayId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVpnGatewayCcnRoutesResponse(AbstractModel):
    """DescribeVpnGatewayCcnRoutes返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RouteSet: 云联网路由（IDC网段）列表。
        :type RouteSet: list of VpngwCcnRoutes
        :param _TotalCount: 符合条件的对象数。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RouteSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def RouteSet(self):
        """云联网路由（IDC网段）列表。
        :rtype: list of VpngwCcnRoutes
        """
        return self._RouteSet

    @RouteSet.setter
    def RouteSet(self, RouteSet):
        self._RouteSet = RouteSet

    @property
    def TotalCount(self):
        """符合条件的对象数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RouteSet") is not None:
            self._RouteSet = []
            for item in params.get("RouteSet"):
                obj = VpngwCcnRoutes()
                obj._deserialize(item)
                self._RouteSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeVpnGatewayRoutesRequest(AbstractModel):
    """DescribeVpnGatewayRoutes请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VpnGatewayId: VPN网关实例ID。
        :type VpnGatewayId: str
        :param _Filters: 过滤条件,  条件包括(DestinationCidr, InstanceId,InstanceType)。
        :type Filters: list of Filter
        :param _Offset: 偏移量, 默认0。
        :type Offset: int
        :param _Limit: 单页个数, 默认20, 最大值100。
        :type Limit: int
        """
        self._VpnGatewayId = None
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def VpnGatewayId(self):
        """VPN网关实例ID。
        :rtype: str
        """
        return self._VpnGatewayId

    @VpnGatewayId.setter
    def VpnGatewayId(self, VpnGatewayId):
        self._VpnGatewayId = VpnGatewayId

    @property
    def Filters(self):
        """过滤条件,  条件包括(DestinationCidr, InstanceId,InstanceType)。
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        """偏移量, 默认0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        """单页个数, 默认20, 最大值100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._VpnGatew