# -*- coding: utf8 -*-
# Copyright (c) 2017-2021 THL A29 Limited, a Tencent company. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class AddCasterInputInfoRequest(AbstractModel):
    """AddCasterInputInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CasterId: 导播台ID。
        :type CasterId: int
        :param _InputInfo: 导播台输入源详细信息。
        :type InputInfo: :class:`tencentcloud.live.v20180801.models.CasterInputInfo`
        """
        self._CasterId = None
        self._InputInfo = None

    @property
    def CasterId(self):
        """导播台ID。
        :rtype: int
        """
        return self._CasterId

    @CasterId.setter
    def CasterId(self, CasterId):
        self._CasterId = CasterId

    @property
    def InputInfo(self):
        """导播台输入源详细信息。
        :rtype: :class:`tencentcloud.live.v20180801.models.CasterInputInfo`
        """
        return self._InputInfo

    @InputInfo.setter
    def InputInfo(self, InputInfo):
        self._InputInfo = InputInfo


    def _deserialize(self, params):
        self._CasterId = params.get("CasterId")
        if params.get("InputInfo") is not None:
            self._InputInfo = CasterInputInfo()
            self._InputInfo._deserialize(params.get("InputInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddCasterInputInfoResponse(AbstractModel):
    """AddCasterInputInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _InputPlayUrl: rtmp协议输入源播放地址。
注：仅可作为预览使用，不可分发。
        :type InputPlayUrl: str
        :param _InputWebRTCPlayUrl: webrtc协议播放地址。
注：
1. 需配合使用腾讯云快直播播放SDK使用才可正常播放。
2. 仅作为预览使用，不可分发。
        :type InputWebRTCPlayUrl: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._InputPlayUrl = None
        self._InputWebRTCPlayUrl = None
        self._RequestId = None

    @property
    def InputPlayUrl(self):
        """rtmp协议输入源播放地址。
注：仅可作为预览使用，不可分发。
        :rtype: str
        """
        return self._InputPlayUrl

    @InputPlayUrl.setter
    def InputPlayUrl(self, InputPlayUrl):
        self._InputPlayUrl = InputPlayUrl

    @property
    def InputWebRTCPlayUrl(self):
        """webrtc协议播放地址。
注：
1. 需配合使用腾讯云快直播播放SDK使用才可正常播放。
2. 仅作为预览使用，不可分发。
        :rtype: str
        """
        return self._InputWebRTCPlayUrl

    @InputWebRTCPlayUrl.setter
    def InputWebRTCPlayUrl(self, InputWebRTCPlayUrl):
        self._InputWebRTCPlayUrl = InputWebRTCPlayUrl

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._InputPlayUrl = params.get("InputPlayUrl")
        self._InputWebRTCPlayUrl = params.get("InputWebRTCPlayUrl")
        self._RequestId = params.get("RequestId")


class AddCasterLayoutInfoRequest(AbstractModel):
    """AddCasterLayoutInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CasterId: 导播台ID
        :type CasterId: int
        :param _LayoutInfo: 导播台布局参数信息。
        :type LayoutInfo: :class:`tencentcloud.live.v20180801.models.CasterLayoutInfo`
        """
        self._CasterId = None
        self._LayoutInfo = None

    @property
    def CasterId(self):
        """导播台ID
        :rtype: int
        """
        return self._CasterId

    @CasterId.setter
    def CasterId(self, CasterId):
        self._CasterId = CasterId

    @property
    def LayoutInfo(self):
        """导播台布局参数信息。
        :rtype: :class:`tencentcloud.live.v20180801.models.CasterLayoutInfo`
        """
        return self._LayoutInfo

    @LayoutInfo.setter
    def LayoutInfo(self, LayoutInfo):
        self._LayoutInfo = LayoutInfo


    def _deserialize(self, params):
        self._CasterId = params.get("CasterId")
        if params.get("LayoutInfo") is not None:
            self._LayoutInfo = CasterLayoutInfo()
            self._LayoutInfo._deserialize(params.get("LayoutInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddCasterLayoutInfoResponse(AbstractModel):
    """AddCasterLayoutInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AddCasterMarkPicInfoRequest(AbstractModel):
    """AddCasterMarkPicInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CasterId: 导播台ID
        :type CasterId: int
        :param _MarkPicInfo: 图片水印详细参数。
        :type MarkPicInfo: :class:`tencentcloud.live.v20180801.models.CasterMarkPicInfo`
        """
        self._CasterId = None
        self._MarkPicInfo = None

    @property
    def CasterId(self):
        """导播台ID
        :rtype: int
        """
        return self._CasterId

    @CasterId.setter
    def CasterId(self, CasterId):
        self._CasterId = CasterId

    @property
    def MarkPicInfo(self):
        """图片水印详细参数。
        :rtype: :class:`tencentcloud.live.v20180801.models.CasterMarkPicInfo`
        """
        return self._MarkPicInfo

    @MarkPicInfo.setter
    def MarkPicInfo(self, MarkPicInfo):
        self._MarkPicInfo = MarkPicInfo


    def _deserialize(self, params):
        self._CasterId = params.get("CasterId")
        if params.get("MarkPicInfo") is not None:
            self._MarkPicInfo = CasterMarkPicInfo()
            self._MarkPicInfo._deserialize(params.get("MarkPicInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddCasterMarkPicInfoResponse(AbstractModel):
    """AddCasterMarkPicInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AddCasterMarkWordInfoRequest(AbstractModel):
    """AddCasterMarkWordInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CasterId: 导播台ID。
        :type CasterId: int
        :param _MarkWordInfo: 文本的详细配置。
        :type MarkWordInfo: :class:`tencentcloud.live.v20180801.models.CasterMarkWordInfo`
        """
        self._CasterId = None
        self._MarkWordInfo = None

    @property
    def CasterId(self):
        """导播台ID。
        :rtype: int
        """
        return self._CasterId

    @CasterId.setter
    def CasterId(self, CasterId):
        self._CasterId = CasterId

    @property
    def MarkWordInfo(self):
        """文本的详细配置。
        :rtype: :class:`tencentcloud.live.v20180801.models.CasterMarkWordInfo`
        """
        return self._MarkWordInfo

    @MarkWordInfo.setter
    def MarkWordInfo(self, MarkWordInfo):
        self._MarkWordInfo = MarkWordInfo


    def _deserialize(self, params):
        self._CasterId = params.get("CasterId")
        if params.get("MarkWordInfo") is not None:
            self._MarkWordInfo = CasterMarkWordInfo()
            self._MarkWordInfo._deserialize(params.get("MarkWordInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddCasterMarkWordInfoResponse(AbstractModel):
    """AddCasterMarkWordInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AddCasterOutputInfoRequest(AbstractModel):
    """AddCasterOutputInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CasterId: 导播台ID
        :type CasterId: int
        :param _OutputInfo: 导播台推流参数信息。
        :type OutputInfo: :class:`tencentcloud.live.v20180801.models.CasterOutputInfo`
        """
        self._CasterId = None
        self._OutputInfo = None

    @property
    def CasterId(self):
        """导播台ID
        :rtype: int
        """
        return self._CasterId

    @CasterId.setter
    def CasterId(self, CasterId):
        self._CasterId = CasterId

    @property
    def OutputInfo(self):
        """导播台推流参数信息。
        :rtype: :class:`tencentcloud.live.v20180801.models.CasterOutputInfo`
        """
        return self._OutputInfo

    @OutputInfo.setter
    def OutputInfo(self, OutputInfo):
        self._OutputInfo = OutputInfo


    def _deserialize(self, params):
        self._CasterId = params.get("CasterId")
        if params.get("OutputInfo") is not None:
            self._OutputInfo = CasterOutputInfo()
            self._OutputInfo._deserialize(params.get("OutputInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddCasterOutputInfoResponse(AbstractModel):
    """AddCasterOutputInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AddDelayLiveStreamRequest(AbstractModel):
    """AddDelayLiveStream请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AppName: 推流路径，与推流和播放地址中的 AppName 保持一致，默认为 live。
        :type AppName: str
        :param _DomainName: 推流域名。
        :type DomainName: str
        :param _StreamName: 流名称。
        :type StreamName: str
        :param _DelayTime: 延播时间，单位：秒，上限：600秒。
        :type DelayTime: int
        :param _ExpireTime: 延播设置的过期时间。UTC 格式，例如：2018-11-29T19:00:00Z。
注意：
1. 默认7天后过期，且最长支持7天内生效。
2. 北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#I)。
        :type ExpireTime: str
        """
        self._AppName = None
        self._DomainName = None
        self._StreamName = None
        self._DelayTime = None
        self._ExpireTime = None

    @property
    def AppName(self):
        """推流路径，与推流和播放地址中的 AppName 保持一致，默认为 live。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def DomainName(self):
        """推流域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def StreamName(self):
        """流名称。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName

    @property
    def DelayTime(self):
        """延播时间，单位：秒，上限：600秒。
        :rtype: int
        """
        return self._DelayTime

    @DelayTime.setter
    def DelayTime(self, DelayTime):
        self._DelayTime = DelayTime

    @property
    def ExpireTime(self):
        """延播设置的过期时间。UTC 格式，例如：2018-11-29T19:00:00Z。
注意：
1. 默认7天后过期，且最长支持7天内生效。
2. 北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#I)。
        :rtype: str
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime


    def _deserialize(self, params):
        self._AppName = params.get("AppName")
        self._DomainName = params.get("DomainName")
        self._StreamName = params.get("StreamName")
        self._DelayTime = params.get("DelayTime")
        self._ExpireTime = params.get("ExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddDelayLiveStreamResponse(AbstractModel):
    """AddDelayLiveStream返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AddLiveDomainRequest(AbstractModel):
    """AddLiveDomain请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DomainName: 域名名称。
        :type DomainName: str
        :param _DomainType: 域名类型，
0：推流域名，
1：播放域名。
        :type DomainType: int
        :param _PlayType: 拉流域名类型：
1：国内，
2：全球，
3：境外。
默认值：1。
        :type PlayType: int
        :param _IsDelayLive: 是否是慢直播：
0： 普通直播，
1 ：慢直播 。
默认值： 0。
        :type IsDelayLive: int
        :param _IsMiniProgramLive: 是否是小程序直播：
0： 标准直播，
1 ：小程序直播 。
默认值： 0。
        :type IsMiniProgramLive: int
        :param _VerifyOwnerType: 域名归属校验类型。
可取值（与 AuthenticateDomainOwner 接口的 VerifyType 参数一致。）：
dnsCheck ：立即验证配置 dns 的解析记录是否与待验证内容一致，成功则保存记录。
fileCheck ：立即验证 web 文件是否与待验证内容一致，成功则保存记录。
dbCheck :  检查是否已经验证成功过。
若不传默认为 dbCheck 。
        :type VerifyOwnerType: str
        """
        self._DomainName = None
        self._DomainType = None
        self._PlayType = None
        self._IsDelayLive = None
        self._IsMiniProgramLive = None
        self._VerifyOwnerType = None

    @property
    def DomainName(self):
        """域名名称。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def DomainType(self):
        """域名类型，
0：推流域名，
1：播放域名。
        :rtype: int
        """
        return self._DomainType

    @DomainType.setter
    def DomainType(self, DomainType):
        self._DomainType = DomainType

    @property
    def PlayType(self):
        """拉流域名类型：
1：国内，
2：全球，
3：境外。
默认值：1。
        :rtype: int
        """
        return self._PlayType

    @PlayType.setter
    def PlayType(self, PlayType):
        self._PlayType = PlayType

    @property
    def IsDelayLive(self):
        """是否是慢直播：
0： 普通直播，
1 ：慢直播 。
默认值： 0。
        :rtype: int
        """
        return self._IsDelayLive

    @IsDelayLive.setter
    def IsDelayLive(self, IsDelayLive):
        self._IsDelayLive = IsDelayLive

    @property
    def IsMiniProgramLive(self):
        """是否是小程序直播：
0： 标准直播，
1 ：小程序直播 。
默认值： 0。
        :rtype: int
        """
        return self._IsMiniProgramLive

    @IsMiniProgramLive.setter
    def IsMiniProgramLive(self, IsMiniProgramLive):
        self._IsMiniProgramLive = IsMiniProgramLive

    @property
    def VerifyOwnerType(self):
        """域名归属校验类型。
可取值（与 AuthenticateDomainOwner 接口的 VerifyType 参数一致。）：
dnsCheck ：立即验证配置 dns 的解析记录是否与待验证内容一致，成功则保存记录。
fileCheck ：立即验证 web 文件是否与待验证内容一致，成功则保存记录。
dbCheck :  检查是否已经验证成功过。
若不传默认为 dbCheck 。
        :rtype: str
        """
        return self._VerifyOwnerType

    @VerifyOwnerType.setter
    def VerifyOwnerType(self, VerifyOwnerType):
        self._VerifyOwnerType = VerifyOwnerType


    def _deserialize(self, params):
        self._DomainName = params.get("DomainName")
        self._DomainType = params.get("DomainType")
        self._PlayType = params.get("PlayType")
        self._IsDelayLive = params.get("IsDelayLive")
        self._IsMiniProgramLive = params.get("IsMiniProgramLive")
        self._VerifyOwnerType = params.get("VerifyOwnerType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddLiveDomainResponse(AbstractModel):
    """AddLiveDomain返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AddLiveWatermarkRequest(AbstractModel):
    """AddLiveWatermark请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PictureUrl: 水印图片 URL。
URL中禁止包含的字符：
 ;(){}$>`#"\'|
        :type PictureUrl: str
        :param _WatermarkName: 水印名称。
最长30字节。
        :type WatermarkName: str
        :param _XPosition: 显示位置，X轴偏移，单位是百分比，默认 0。
        :type XPosition: int
        :param _YPosition: 显示位置，Y轴偏移，单位是百分比，默认 0。
        :type YPosition: int
        :param _Width: 水印宽度，占直播原始画面宽度百分比，建议高宽只设置一项，另外一项会自适应缩放，避免变形。默认原始宽度。
        :type Width: int
        :param _Height: 水印高度，占直播原始画面高度百分比，建议高宽只设置一项，另外一项会自适应缩放，避免变形。默认原始高度。
        :type Height: int
        :param _BackgroundWidth: 背景水印宽度。默认宽度1920。
        :type BackgroundWidth: int
        :param _BackgroundHeight: 背景水印高度。默认高度1080。
        :type BackgroundHeight: int
        """
        self._PictureUrl = None
        self._WatermarkName = None
        self._XPosition = None
        self._YPosition = None
        self._Width = None
        self._Height = None
        self._BackgroundWidth = None
        self._BackgroundHeight = None

    @property
    def PictureUrl(self):
        """水印图片 URL。
URL中禁止包含的字符：
 ;(){}$>`#"\'|
        :rtype: str
        """
        return self._PictureUrl

    @PictureUrl.setter
    def PictureUrl(self, PictureUrl):
        self._PictureUrl = PictureUrl

    @property
    def WatermarkName(self):
        """水印名称。
最长30字节。
        :rtype: str
        """
        return self._WatermarkName

    @WatermarkName.setter
    def WatermarkName(self, WatermarkName):
        self._WatermarkName = WatermarkName

    @property
    def XPosition(self):
        """显示位置，X轴偏移，单位是百分比，默认 0。
        :rtype: int
        """
        return self._XPosition

    @XPosition.setter
    def XPosition(self, XPosition):
        self._XPosition = XPosition

    @property
    def YPosition(self):
        """显示位置，Y轴偏移，单位是百分比，默认 0。
        :rtype: int
        """
        return self._YPosition

    @YPosition.setter
    def YPosition(self, YPosition):
        self._YPosition = YPosition

    @property
    def Width(self):
        """水印宽度，占直播原始画面宽度百分比，建议高宽只设置一项，另外一项会自适应缩放，避免变形。默认原始宽度。
        :rtype: int
        """
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        """水印高度，占直播原始画面高度百分比，建议高宽只设置一项，另外一项会自适应缩放，避免变形。默认原始高度。
        :rtype: int
        """
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def BackgroundWidth(self):
        """背景水印宽度。默认宽度1920。
        :rtype: int
        """
        return self._BackgroundWidth

    @BackgroundWidth.setter
    def BackgroundWidth(self, BackgroundWidth):
        self._BackgroundWidth = BackgroundWidth

    @property
    def BackgroundHeight(self):
        """背景水印高度。默认高度1080。
        :rtype: int
        """
        return self._BackgroundHeight

    @BackgroundHeight.setter
    def BackgroundHeight(self, BackgroundHeight):
        self._BackgroundHeight = BackgroundHeight


    def _deserialize(self, params):
        self._PictureUrl = params.get("PictureUrl")
        self._WatermarkName = params.get("WatermarkName")
        self._XPosition = params.get("XPosition")
        self._YPosition = params.get("YPosition")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._BackgroundWidth = params.get("BackgroundWidth")
        self._BackgroundHeight = params.get("BackgroundHeight")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddLiveWatermarkResponse(AbstractModel):
    """AddLiveWatermark返回参数结构体

    """

    def __init__(self):
        r"""
        :param _WatermarkId: 水印ID。
        :type WatermarkId: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._WatermarkId = None
        self._RequestId = None

    @property
    def WatermarkId(self):
        """水印ID。
        :rtype: int
        """
        return self._WatermarkId

    @WatermarkId.setter
    def WatermarkId(self, WatermarkId):
        self._WatermarkId = WatermarkId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._WatermarkId = params.get("WatermarkId")
        self._RequestId = params.get("RequestId")


class AuthenticateDomainOwnerRequest(AbstractModel):
    """AuthenticateDomainOwner请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DomainName: 要验证的域名。
        :type DomainName: str
        :param _VerifyType: 验证类型。可取值：
dnsCheck ：立即验证配置 dns 的解析记录是否与待验证内容一致，成功则保存记录。
fileCheck ：立即验证 web 文件是否与待验证内容一致，成功则保存记录。
dbCheck :  检查是否已经验证成功过。
        :type VerifyType: str
        """
        self._DomainName = None
        self._VerifyType = None

    @property
    def DomainName(self):
        """要验证的域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def VerifyType(self):
        """验证类型。可取值：
dnsCheck ：立即验证配置 dns 的解析记录是否与待验证内容一致，成功则保存记录。
fileCheck ：立即验证 web 文件是否与待验证内容一致，成功则保存记录。
dbCheck :  检查是否已经验证成功过。
        :rtype: str
        """
        return self._VerifyType

    @VerifyType.setter
    def VerifyType(self, VerifyType):
        self._VerifyType = VerifyType


    def _deserialize(self, params):
        self._DomainName = params.get("DomainName")
        self._VerifyType = params.get("VerifyType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AuthenticateDomainOwnerResponse(AbstractModel):
    """AuthenticateDomainOwner返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Content: 验证内容。
VerifyType 传 dnsCheck 时，为要配的 TXT 记录值。
VerifyType 传 fileCheck 时，为文件内容。
        :type Content: str
        :param _Status: 域名验证状态。
>=0 为已验证归属。
<0 未验证归属权。
        :type Status: int
        :param _MainDomain: DomainName 对应的主域名。
同一主域名下的所有域名只需成功验证一次，后续均无需再验证。
        :type MainDomain: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Content = None
        self._Status = None
        self._MainDomain = None
        self._RequestId = None

    @property
    def Content(self):
        """验证内容。
VerifyType 传 dnsCheck 时，为要配的 TXT 记录值。
VerifyType 传 fileCheck 时，为文件内容。
        :rtype: str
        """
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content

    @property
    def Status(self):
        """域名验证状态。
>=0 为已验证归属。
<0 未验证归属权。
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def MainDomain(self):
        """DomainName 对应的主域名。
同一主域名下的所有域名只需成功验证一次，后续均无需再验证。
        :rtype: str
        """
        return self._MainDomain

    @MainDomain.setter
    def MainDomain(self, MainDomain):
        self._MainDomain = MainDomain

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Content = params.get("Content")
        self._Status = params.get("Status")
        self._MainDomain = params.get("MainDomain")
        self._RequestId = params.get("RequestId")


class BackupStreamDetailData(AbstractModel):
    """主备流详细信息。

    """

    def __init__(self):
        r"""
        :param _DomainName: 推流域名。
        :type DomainName: str
        :param _AppName: 推流路径。
        :type AppName: str
        :param _PublishTime:  UTC 格式，例如：2018-06-29T19:00:00Z。
注意：和北京时间相差8小时。
        :type PublishTime: str
        :param _UpstreamSequence: 推流唯一标识。
        :type UpstreamSequence: str
        :param _SourceFrom: 推流来源。示例：
直推流；
拉流转推(1234)；
注意：拉流转推来源括号中为拉流转推的任务 
 ID。
        :type SourceFrom: str
        :param _MasterFlag: 主备标识。
当前流为主流：1，
当前流为备流: 0。
        :type MasterFlag: int
        """
        self._DomainName = None
        self._AppName = None
        self._PublishTime = None
        self._UpstreamSequence = None
        self._SourceFrom = None
        self._MasterFlag = None

    @property
    def DomainName(self):
        """推流域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def AppName(self):
        """推流路径。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def PublishTime(self):
        """ UTC 格式，例如：2018-06-29T19:00:00Z。
注意：和北京时间相差8小时。
        :rtype: str
        """
        return self._PublishTime

    @PublishTime.setter
    def PublishTime(self, PublishTime):
        self._PublishTime = PublishTime

    @property
    def UpstreamSequence(self):
        """推流唯一标识。
        :rtype: str
        """
        return self._UpstreamSequence

    @UpstreamSequence.setter
    def UpstreamSequence(self, UpstreamSequence):
        self._UpstreamSequence = UpstreamSequence

    @property
    def SourceFrom(self):
        """推流来源。示例：
直推流；
拉流转推(1234)；
注意：拉流转推来源括号中为拉流转推的任务 
 ID。
        :rtype: str
        """
        return self._SourceFrom

    @SourceFrom.setter
    def SourceFrom(self, SourceFrom):
        self._SourceFrom = SourceFrom

    @property
    def MasterFlag(self):
        """主备标识。
当前流为主流：1，
当前流为备流: 0。
        :rtype: int
        """
        return self._MasterFlag

    @MasterFlag.setter
    def MasterFlag(self, MasterFlag):
        self._MasterFlag = MasterFlag


    def _deserialize(self, params):
        self._DomainName = params.get("DomainName")
        self._AppName = params.get("AppName")
        self._PublishTime = params.get("PublishTime")
        self._UpstreamSequence = params.get("UpstreamSequence")
        self._SourceFrom = params.get("SourceFrom")
        self._MasterFlag = params.get("MasterFlag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BackupStreamGroupInfo(AbstractModel):
    """主备流分组信息。

    """

    def __init__(self):
        r"""
        :param _StreamName: 流名称。
        :type StreamName: str
        :param _BackupList: 主备流信息。
        :type BackupList: list of BackupStreamDetailData
        :param _OptimalEnable: 是否对该流开启了择优调度。
0 - 未开启。
1 - 已开启。
        :type OptimalEnable: int
        :param _HostGroupName: 域名分组的分组名称。
        :type HostGroupName: str
        """
        self._StreamName = None
        self._BackupList = None
        self._OptimalEnable = None
        self._HostGroupName = None

    @property
    def StreamName(self):
        """流名称。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName

    @property
    def BackupList(self):
        """主备流信息。
        :rtype: list of BackupStreamDetailData
        """
        return self._BackupList

    @BackupList.setter
    def BackupList(self, BackupList):
        self._BackupList = BackupList

    @property
    def OptimalEnable(self):
        """是否对该流开启了择优调度。
0 - 未开启。
1 - 已开启。
        :rtype: int
        """
        return self._OptimalEnable

    @OptimalEnable.setter
    def OptimalEnable(self, OptimalEnable):
        self._OptimalEnable = OptimalEnable

    @property
    def HostGroupName(self):
        """域名分组的分组名称。
        :rtype: str
        """
        return self._HostGroupName

    @HostGroupName.setter
    def HostGroupName(self, HostGroupName):
        self._HostGroupName = HostGroupName


    def _deserialize(self, params):
        self._StreamName = params.get("StreamName")
        if params.get("BackupList") is not None:
            self._BackupList = []
            for item in params.get("BackupList"):
                obj = BackupStreamDetailData()
                obj._deserialize(item)
                self._BackupList.append(obj)
        self._OptimalEnable = params.get("OptimalEnable")
        self._HostGroupName = params.get("HostGroupName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BandwidthInfo(AbstractModel):
    """带宽信息

    """

    def __init__(self):
        r"""
        :param _Time: 返回格式：
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#:~:text=I-,ISO,-%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F)。
根据粒度会有不同程度的缩减。
        :type Time: str
        :param _Bandwidth: 带宽。
        :type Bandwidth: float
        """
        self._Time = None
        self._Bandwidth = None

    @property
    def Time(self):
        """返回格式：
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#:~:text=I-,ISO,-%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F)。
根据粒度会有不同程度的缩减。
        :rtype: str
        """
        return self._Time

    @Time.setter
    def Time(self, Time):
        self._Time = Time

    @property
    def Bandwidth(self):
        """带宽。
        :rtype: float
        """
        return self._Bandwidth

    @Bandwidth.setter
    def Bandwidth(self, Bandwidth):
        self._Bandwidth = Bandwidth


    def _deserialize(self, params):
        self._Time = params.get("Time")
        self._Bandwidth = params.get("Bandwidth")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BatchDomainOperateErrors(AbstractModel):
    """批量操作域名相关接口，若其中个别域名操作失败将会跳过，相应的域名错误信息将统一汇总在此类型中

    """

    def __init__(self):
        r"""
        :param _DomainName: 操作失败的域名。
        :type DomainName: str
        :param _Code: API3.0错误码。
        :type Code: str
        :param _Message: API3.0错误信息。
        :type Message: str
        """
        self._DomainName = None
        self._Code = None
        self._Message = None

    @property
    def DomainName(self):
        """操作失败的域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def Code(self):
        """API3.0错误码。
        :rtype: str
        """
        return self._Code

    @Code.setter
    def Code(self, Code):
        self._Code = Code

    @property
    def Message(self):
        """API3.0错误信息。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message


    def _deserialize(self, params):
        self._DomainName = params.get("DomainName")
        self._Code = params.get("Code")
        self._Message = params.get("Message")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BillAreaInfo(AbstractModel):
    """海外分区直播带宽出参，分区信息

    """

    def __init__(self):
        r"""
        :param _Name: 大区名称。
        :type Name: str
        :param _Countrys: 国家或地区明细数据。
        :type Countrys: list of BillCountryInfo
        """
        self._Name = None
        self._Countrys = None

    @property
    def Name(self):
        """大区名称。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Countrys(self):
        """国家或地区明细数据。
        :rtype: list of BillCountryInfo
        """
        return self._Countrys

    @Countrys.setter
    def Countrys(self, Countrys):
        self._Countrys = Countrys


    def _deserialize(self, params):
        self._Name = params.get("Name")
        if params.get("Countrys") is not None:
            self._Countrys = []
            for item in params.get("Countrys"):
                obj = BillCountryInfo()
                obj._deserialize(item)
                self._Countrys.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BillCountryInfo(AbstractModel):
    """海外分区直播带宽出参国家带宽信息

    """

    def __init__(self):
        r"""
        :param _Name: 国家名称
        :type Name: str
        :param _BandInfoList: 带宽明细数据信息。
        :type BandInfoList: list of BillDataInfo
        """
        self._Name = None
        self._BandInfoList = None

    @property
    def Name(self):
        """国家名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def BandInfoList(self):
        """带宽明细数据信息。
        :rtype: list of BillDataInfo
        """
        return self._BandInfoList

    @BandInfoList.setter
    def BandInfoList(self, BandInfoList):
        self._BandInfoList = BandInfoList


    def _deserialize(self, params):
        self._Name = params.get("Name")
        if params.get("BandInfoList") is not None:
            self._BandInfoList = []
            for item in params.get("BandInfoList"):
                obj = BillDataInfo()
                obj._deserialize(item)
                self._BandInfoList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BillDataInfo(AbstractModel):
    """带宽和流量信息。

    """

    def __init__(self):
        r"""
        :param _Time: 时间点，
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :type Time: str
        :param _Bandwidth: 带宽，单位是 Mbps。
        :type Bandwidth: float
        :param _Flux: 流量，单位是 MB。
        :type Flux: float
        :param _PeakTime: 峰值时间点，
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
原始数据为5分钟粒度，如果查询小时和天粒度数据，则返回对应粒度内的带宽峰值时间点。
        :type PeakTime: str
        """
        self._Time = None
        self._Bandwidth = None
        self._Flux = None
        self._PeakTime = None

    @property
    def Time(self):
        """时间点，
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._Time

    @Time.setter
    def Time(self, Time):
        self._Time = Time

    @property
    def Bandwidth(self):
        """带宽，单位是 Mbps。
        :rtype: float
        """
        return self._Bandwidth

    @Bandwidth.setter
    def Bandwidth(self, Bandwidth):
        self._Bandwidth = Bandwidth

    @property
    def Flux(self):
        """流量，单位是 MB。
        :rtype: float
        """
        return self._Flux

    @Flux.setter
    def Flux(self, Flux):
        self._Flux = Flux

    @property
    def PeakTime(self):
        """峰值时间点，
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
原始数据为5分钟粒度，如果查询小时和天粒度数据，则返回对应粒度内的带宽峰值时间点。
        :rtype: str
        """
        return self._PeakTime

    @PeakTime.setter
    def PeakTime(self, PeakTime):
        self._PeakTime = PeakTime


    def _deserialize(self, params):
        self._Time = params.get("Time")
        self._Bandwidth = params.get("Bandwidth")
        self._Flux = params.get("Flux")
        self._PeakTime = params.get("PeakTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CallBackRuleInfo(AbstractModel):
    """规则信息

    """

    def __init__(self):
        r"""
        :param _CreateTime: 规则创建时间。
注：此字段为北京时间（UTC+8时区）。
        :type CreateTime: str
        :param _UpdateTime: 规则更新时间。
注：此字段为北京时间（UTC+8时区）。
        :type UpdateTime: str
        :param _TemplateId: 模板 ID。
        :type TemplateId: int
        :param _DomainName: 推流域名。
        :type DomainName: str
        :param _AppName: 推流路径。
        :type AppName: str
        """
        self._CreateTime = None
        self._UpdateTime = None
        self._TemplateId = None
        self._DomainName = None
        self._AppName = None

    @property
    def CreateTime(self):
        """规则创建时间。
注：此字段为北京时间（UTC+8时区）。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        """规则更新时间。
注：此字段为北京时间（UTC+8时区）。
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def TemplateId(self):
        """模板 ID。
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId

    @property
    def DomainName(self):
        """推流域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def AppName(self):
        """推流路径。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName


    def _deserialize(self, params):
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._TemplateId = params.get("TemplateId")
        self._DomainName = params.get("DomainName")
        self._AppName = params.get("AppName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CallBackTemplateInfo(AbstractModel):
    """回调模板信息。

    """

    def __init__(self):
        r"""
        :param _TemplateId: 模板 ID。
        :type TemplateId: int
        :param _TemplateName: 模板名称。
        :type TemplateName: str
        :param _Description: 描述信息。
        :type Description: str
        :param _StreamBeginNotifyUrl: 开播回调 URL。
        :type StreamBeginNotifyUrl: str
        :param _StreamMixNotifyUrl: 混流回调 URL。(参数已弃用)。
        :type StreamMixNotifyUrl: str
        :param _StreamEndNotifyUrl: 断流回调 URL。
        :type StreamEndNotifyUrl: str
        :param _RecordNotifyUrl: 录制文件回调 URL。
        :type RecordNotifyUrl: str
        :param _SnapshotNotifyUrl: 截图回调 URL。
        :type SnapshotNotifyUrl: str
        :param _PornCensorshipNotifyUrl: 鉴黄回调 URL。
        :type PornCensorshipNotifyUrl: str
        :param _CallbackKey: 回调的鉴权 key。
        :type CallbackKey: str
        :param _PushExceptionNotifyUrl: 推流异常回调 URL。
注意：此字段可能返回 null，表示取不到有效值。
        :type PushExceptionNotifyUrl: str
        :param _AudioAuditNotifyUrl: 音频审核回调 URL。
注意：此字段可能返回 null，表示取不到有效值。
        :type AudioAuditNotifyUrl: str
        :param _RecordExceptionNotifyUrl: 录制异常回调 URL。
        :type RecordExceptionNotifyUrl: str
        :param _RecordExceptionLevels: 录制异常回调级别，可选择：error: 错误。alarm: 告警。
        :type RecordExceptionLevels: list of str
        """
        self._TemplateId = None
        self._TemplateName = None
        self._Description = None
        self._StreamBeginNotifyUrl = None
        self._StreamMixNotifyUrl = None
        self._StreamEndNotifyUrl = None
        self._RecordNotifyUrl = None
        self._SnapshotNotifyUrl = None
        self._PornCensorshipNotifyUrl = None
        self._CallbackKey = None
        self._PushExceptionNotifyUrl = None
        self._AudioAuditNotifyUrl = None
        self._RecordExceptionNotifyUrl = None
        self._RecordExceptionLevels = None

    @property
    def TemplateId(self):
        """模板 ID。
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId

    @property
    def TemplateName(self):
        """模板名称。
        :rtype: str
        """
        return self._TemplateName

    @TemplateName.setter
    def TemplateName(self, TemplateName):
        self._TemplateName = TemplateName

    @property
    def Description(self):
        """描述信息。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def StreamBeginNotifyUrl(self):
        """开播回调 URL。
        :rtype: str
        """
        return self._StreamBeginNotifyUrl

    @StreamBeginNotifyUrl.setter
    def StreamBeginNotifyUrl(self, StreamBeginNotifyUrl):
        self._StreamBeginNotifyUrl = StreamBeginNotifyUrl

    @property
    def StreamMixNotifyUrl(self):
        """混流回调 URL。(参数已弃用)。
        :rtype: str
        """
        return self._StreamMixNotifyUrl

    @StreamMixNotifyUrl.setter
    def StreamMixNotifyUrl(self, StreamMixNotifyUrl):
        self._StreamMixNotifyUrl = StreamMixNotifyUrl

    @property
    def StreamEndNotifyUrl(self):
        """断流回调 URL。
        :rtype: str
        """
        return self._StreamEndNotifyUrl

    @StreamEndNotifyUrl.setter
    def StreamEndNotifyUrl(self, StreamEndNotifyUrl):
        self._StreamEndNotifyUrl = StreamEndNotifyUrl

    @property
    def RecordNotifyUrl(self):
        """录制文件回调 URL。
        :rtype: str
        """
        return self._RecordNotifyUrl

    @RecordNotifyUrl.setter
    def RecordNotifyUrl(self, RecordNotifyUrl):
        self._RecordNotifyUrl = RecordNotifyUrl

    @property
    def SnapshotNotifyUrl(self):
        """截图回调 URL。
        :rtype: str
        """
        return self._SnapshotNotifyUrl

    @SnapshotNotifyUrl.setter
    def SnapshotNotifyUrl(self, SnapshotNotifyUrl):
        self._SnapshotNotifyUrl = SnapshotNotifyUrl

    @property
    def PornCensorshipNotifyUrl(self):
        """鉴黄回调 URL。
        :rtype: str
        """
        return self._PornCensorshipNotifyUrl

    @PornCensorshipNotifyUrl.setter
    def PornCensorshipNotifyUrl(self, PornCensorshipNotifyUrl):
        self._PornCensorshipNotifyUrl = PornCensorshipNotifyUrl

    @property
    def CallbackKey(self):
        """回调的鉴权 key。
        :rtype: str
        """
        return self._CallbackKey

    @CallbackKey.setter
    def CallbackKey(self, CallbackKey):
        self._CallbackKey = CallbackKey

    @property
    def PushExceptionNotifyUrl(self):
        """推流异常回调 URL。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PushExceptionNotifyUrl

    @PushExceptionNotifyUrl.setter
    def PushExceptionNotifyUrl(self, PushExceptionNotifyUrl):
        self._PushExceptionNotifyUrl = PushExceptionNotifyUrl

    @property
    def AudioAuditNotifyUrl(self):
        """音频审核回调 URL。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AudioAuditNotifyUrl

    @AudioAuditNotifyUrl.setter
    def AudioAuditNotifyUrl(self, AudioAuditNotifyUrl):
        self._AudioAuditNotifyUrl = AudioAuditNotifyUrl

    @property
    def RecordExceptionNotifyUrl(self):
        """录制异常回调 URL。
        :rtype: str
        """
        return self._RecordExceptionNotifyUrl

    @RecordExceptionNotifyUrl.setter
    def RecordExceptionNotifyUrl(self, RecordExceptionNotifyUrl):
        self._RecordExceptionNotifyUrl = RecordExceptionNotifyUrl

    @property
    def RecordExceptionLevels(self):
        """录制异常回调级别，可选择：error: 错误。alarm: 告警。
        :rtype: list of str
        """
        return self._RecordExceptionLevels

    @RecordExceptionLevels.setter
    def RecordExceptionLevels(self, RecordExceptionLevels):
        self._RecordExceptionLevels = RecordExceptionLevels


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        self._TemplateName = params.get("TemplateName")
        self._Description = params.get("Description")
        self._StreamBeginNotifyUrl = params.get("StreamBeginNotifyUrl")
        self._StreamMixNotifyUrl = params.get("StreamMixNotifyUrl")
        self._StreamEndNotifyUrl = params.get("StreamEndNotifyUrl")
        self._RecordNotifyUrl = params.get("RecordNotifyUrl")
        self._SnapshotNotifyUrl = params.get("SnapshotNotifyUrl")
        self._PornCensorshipNotifyUrl = params.get("PornCensorshipNotifyUrl")
        self._CallbackKey = params.get("CallbackKey")
        self._PushExceptionNotifyUrl = params.get("PushExceptionNotifyUrl")
        self._AudioAuditNotifyUrl = params.get("AudioAuditNotifyUrl")
        self._RecordExceptionNotifyUrl = params.get("RecordExceptionNotifyUrl")
        self._RecordExceptionLevels = params.get("RecordExceptionLevels")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CallbackEventInfo(AbstractModel):
    """回调事件信息

    """

    def __init__(self):
        r"""
        :param _EventTime: 事件时间。
接口返回支持两种时间格式：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)
2）yyyy-MM-dd HH:mm:ss：使用此格式时，默认代表北京时间。
接口返回的时间格式和查询请求传入的时间格式一致。
        :type EventTime: str
        :param _EventType: 事件类型。
        :type EventType: int
        :param _Request: 回调请求。
        :type Request: str
        :param _Response: 回调响应。
        :type Response: str
        :param _ResponseTime: 客户接口响应时间。
接口返回支持两种时间格式：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)
2）yyyy-MM-dd HH:mm:ss：使用此格式时，默认代表北京时间。
接口返回的时间格式和查询请求传入的时间格式一致。
        :type ResponseTime: str
        :param _ResultCode: 回调结果。
        :type ResultCode: int
        :param _StreamId: 流名称。
        :type StreamId: str
        """
        self._EventTime = None
        self._EventType = None
        self._Request = None
        self._Response = None
        self._ResponseTime = None
        self._ResultCode = None
        self._StreamId = None

    @property
    def EventTime(self):
        """事件时间。
接口返回支持两种时间格式：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)
2）yyyy-MM-dd HH:mm:ss：使用此格式时，默认代表北京时间。
接口返回的时间格式和查询请求传入的时间格式一致。
        :rtype: str
        """
        return self._EventTime

    @EventTime.setter
    def EventTime(self, EventTime):
        self._EventTime = EventTime

    @property
    def EventType(self):
        """事件类型。
        :rtype: int
        """
        return self._EventType

    @EventType.setter
    def EventType(self, EventType):
        self._EventType = EventType

    @property
    def Request(self):
        """回调请求。
        :rtype: str
        """
        return self._Request

    @Request.setter
    def Request(self, Request):
        self._Request = Request

    @property
    def Response(self):
        """回调响应。
        :rtype: str
        """
        return self._Response

    @Response.setter
    def Response(self, Response):
        self._Response = Response

    @property
    def ResponseTime(self):
        """客户接口响应时间。
接口返回支持两种时间格式：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)
2）yyyy-MM-dd HH:mm:ss：使用此格式时，默认代表北京时间。
接口返回的时间格式和查询请求传入的时间格式一致。
        :rtype: str
        """
        return self._ResponseTime

    @ResponseTime.setter
    def ResponseTime(self, ResponseTime):
        self._ResponseTime = ResponseTime

    @property
    def ResultCode(self):
        """回调结果。
        :rtype: int
        """
        return self._ResultCode

    @ResultCode.setter
    def ResultCode(self, ResultCode):
        self._ResultCode = ResultCode

    @property
    def StreamId(self):
        """流名称。
        :rtype: str
        """
        return self._StreamId

    @StreamId.setter
    def StreamId(self, StreamId):
        self._StreamId = StreamId


    def _deserialize(self, params):
        self._EventTime = params.get("EventTime")
        self._EventType = params.get("EventType")
        self._Request = params.get("Request")
        self._Response = params.get("Response")
        self._ResponseTime = params.get("ResponseTime")
        self._ResultCode = params.get("ResultCode")
        self._StreamId = params.get("StreamId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CancelCommonMixStreamRequest(AbstractModel):
    """CancelCommonMixStream请求参数结构体

    """

    def __init__(self):
        r"""
        :param _MixStreamSessionId: 混流会话（申请混流开始到取消混流结束）标识 ID。
该值与CreateCommonMixStream中的MixStreamSessionId保持一致。
        :type MixStreamSessionId: str
        """
        self._MixStreamSessionId = None

    @property
    def MixStreamSessionId(self):
        """混流会话（申请混流开始到取消混流结束）标识 ID。
该值与CreateCommonMixStream中的MixStreamSessionId保持一致。
        :rtype: str
        """
        return self._MixStreamSessionId

    @MixStreamSessionId.setter
    def MixStreamSessionId(self, MixStreamSessionId):
        self._MixStreamSessionId = MixStreamSessionId


    def _deserialize(self, params):
        self._MixStreamSessionId = params.get("MixStreamSessionId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CancelCommonMixStreamResponse(AbstractModel):
    """CancelCommonMixStream返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CasterBriefInfo(AbstractModel):
    """导播台简略信息

    """

    def __init__(self):
        r"""
        :param _CasterId: 导播台ID
        :type CasterId: int
        :param _CasterName: 导播台名称
        :type CasterName: str
        :param _Description: 导播台的描述
        :type Description: str
        :param _StartBillingTime: 开始计费时间，值为unix时间戳
        :type StartBillingTime: int
        :param _StopBillingTime: 结束计费时间，值为unix时间戳
        :type StopBillingTime: int
        :param _CreateTime: 创建时间，值为unix时间戳
        :type CreateTime: int
        :param _Status: 导播台状态
0：停止状态，无预监，无主监
1：无预监，有主监
2：有预监，无主监
3：有预监，有主监
        :type Status: int
        :param _ExpireTime: 导播台的过期时间，值为-1或unix时间戳。
当值为-1时，代表永不过期。
当值为特定unix时间戳时，代表过期时间为对应的时间，导播台在该时间自动停止。
        :type ExpireTime: int
        :param _FeeType: 计费字段，该字段暂无作用
        :type FeeType: int
        """
        self._CasterId = None
        self._CasterName = None
        self._Description = None
        self._StartBillingTime = None
        self._StopBillingTime = None
        self._CreateTime = None
        self._Status = None
        self._ExpireTime = None
        self._FeeType = None

    @property
    def CasterId(self):
        """导播台ID
        :rtype: int
        """
        return self._CasterId

    @CasterId.setter
    def CasterId(self, CasterId):
        self._CasterId = CasterId

    @property
    def CasterName(self):
        """导播台名称
        :rtype: str
        """
        return self._CasterName

    @CasterName.setter
    def CasterName(self, CasterName):
        self._CasterName = CasterName

    @property
    def Description(self):
        """导播台的描述
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def StartBillingTime(self):
        """开始计费时间，值为unix时间戳
        :rtype: int
        """
        return self._StartBillingTime

    @StartBillingTime.setter
    def StartBillingTime(self, StartBillingTime):
        self._StartBillingTime = StartBillingTime

    @property
    def StopBillingTime(self):
        """结束计费时间，值为unix时间戳
        :rtype: int
        """
        return self._StopBillingTime

    @StopBillingTime.setter
    def StopBillingTime(self, StopBillingTime):
        self._StopBillingTime = StopBillingTime

    @property
    def CreateTime(self):
        """创建时间，值为unix时间戳
        :rtype: int
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def Status(self):
        """导播台状态
0：停止状态，无预监，无主监
1：无预监，有主监
2：有预监，无主监
3：有预监，有主监
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ExpireTime(self):
        """导播台的过期时间，值为-1或unix时间戳。
当值为-1时，代表永不过期。
当值为特定unix时间戳时，代表过期时间为对应的时间，导播台在该时间自动停止。
        :rtype: int
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def FeeType(self):
        """计费字段，该字段暂无作用
        :rtype: int
        """
        return self._FeeType

    @FeeType.setter
    def FeeType(self, FeeType):
        self._FeeType = FeeType


    def _deserialize(self, params):
        self._CasterId = params.get("CasterId")
        self._CasterName = params.get("CasterName")
        self._Description = params.get("Description")
        self._StartBillingTime = params.get("StartBillingTime")
        self._StopBillingTime = params.get("StopBillingTime")
        self._CreateTime = params.get("CreateTime")
        self._Status = params.get("Status")
        self._ExpireTime = params.get("ExpireTime")
        self._FeeType = params.get("FeeType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CasterDisplayInfo(AbstractModel):
    """导播台展示信息，包括使用的布局、水印、字幕、转场、音频等信息

    """

    def __init__(self):
        r"""
        :param _LayoutIndex: 布局Index。
如果使用自定义布局，为自定义布局下标。
如果使用单输入布局，如使用输入1，则LayoutIndexType=1， 且LayoutIndex=1，以此类推。
        :type LayoutIndex: int
        :param _MarkPicIndexList: 使用的水印Index列表。
注：当作为入参使用时，列表中的水印Index需要已经存在。
        :type MarkPicIndexList: list of int non-negative
        :param _MarkWordIndexList: 使用的文字水印Index列表。
注：作为入参使用时，列表中的Index需要已经存在。
        :type MarkWordIndexList: list of int non-negative
        :param _TransitionType: 使用的转场类型。
注：支持的转场类型可通过DescribeCasterTransitionTypes接口获取。
        :type TransitionType: str
        :param _AudioIndexList: 使用的音频输入Index列表。
注：当该字段非空时，表示使用布局中对应的输入源的视频，AudioIndexList中对应的输入源的音频。且这些输入源需已存在。
        :type AudioIndexList: list of int non-negative
        :param _InputStartType: 作为入参时，表示使用点播输入源，单画面输入时，点播文件是否从头开始播放。
默认为0。
有效值，0,1。
0代表不从头播放
1代表从头播放
        :type InputStartType: int
        :param _LayoutIndexType: LayoutIndex类型，
默认值:0
可选值[0,1]
0:默认类型，代表普通布局
1:单输入类型，代表单输入布局
        :type LayoutIndexType: int
        """
        self._LayoutIndex = None
        self._MarkPicIndexList = None
        self._MarkWordIndexList = None
        self._TransitionType = None
        self._AudioIndexList = None
        self._InputStartType = None
        self._LayoutIndexType = None

    @property
    def LayoutIndex(self):
        """布局Index。
如果使用自定义布局，为自定义布局下标。
如果使用单输入布局，如使用输入1，则LayoutIndexType=1， 且LayoutIndex=1，以此类推。
        :rtype: int
        """
        return self._LayoutIndex

    @LayoutIndex.setter
    def LayoutIndex(self, LayoutIndex):
        self._LayoutIndex = LayoutIndex

    @property
    def MarkPicIndexList(self):
        """使用的水印Index列表。
注：当作为入参使用时，列表中的水印Index需要已经存在。
        :rtype: list of int non-negative
        """
        return self._MarkPicIndexList

    @MarkPicIndexList.setter
    def MarkPicIndexList(self, MarkPicIndexList):
        self._MarkPicIndexList = MarkPicIndexList

    @property
    def MarkWordIndexList(self):
        """使用的文字水印Index列表。
注：作为入参使用时，列表中的Index需要已经存在。
        :rtype: list of int non-negative
        """
        return self._MarkWordIndexList

    @MarkWordIndexList.setter
    def MarkWordIndexList(self, MarkWordIndexList):
        self._MarkWordIndexList = MarkWordIndexList

    @property
    def TransitionType(self):
        """使用的转场类型。
注：支持的转场类型可通过DescribeCasterTransitionTypes接口获取。
        :rtype: str
        """
        return self._TransitionType

    @TransitionType.setter
    def TransitionType(self, TransitionType):
        self._TransitionType = TransitionType

    @property
    def AudioIndexList(self):
        """使用的音频输入Index列表。
注：当该字段非空时，表示使用布局中对应的输入源的视频，AudioIndexList中对应的输入源的音频。且这些输入源需已存在。
        :rtype: list of int non-negative
        """
        return self._AudioIndexList

    @AudioIndexList.setter
    def AudioIndexList(self, AudioIndexList):
        self._AudioIndexList = AudioIndexList

    @property
    def InputStartType(self):
        """作为入参时，表示使用点播输入源，单画面输入时，点播文件是否从头开始播放。
默认为0。
有效值，0,1。
0代表不从头播放
1代表从头播放
        :rtype: int
        """
        return self._InputStartType

    @InputStartType.setter
    def InputStartType(self, InputStartType):
        self._InputStartType = InputStartType

    @property
    def LayoutIndexType(self):
        """LayoutIndex类型，
默认值:0
可选值[0,1]
0:默认类型，代表普通布局
1:单输入类型，代表单输入布局
        :rtype: int
        """
        return self._LayoutIndexType

    @LayoutIndexType.setter
    def LayoutIndexType(self, LayoutIndexType):
        self._LayoutIndexType = LayoutIndexType


    def _deserialize(self, params):
        self._LayoutIndex = params.get("LayoutIndex")
        self._MarkPicIndexList = params.get("MarkPicIndexList")
        self._MarkWordIndexList = params.get("MarkWordIndexList")
        self._TransitionType = params.get("TransitionType")
        self._AudioIndexList = params.get("AudioIndexList")
        self._InputStartType = params.get("InputStartType")
        self._LayoutIndexType = params.get("LayoutIndexType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CasterInfo(AbstractModel):
    """导播台信息

    """

    def __init__(self):
        r"""
        :param _CasterId: 导播台ID
        :type CasterId: int
        :param _CasterName: 导播台名称
        :type CasterName: str
        :param _StartLiveTime: 导播台上一次启动pgm的时间，值为unix时间戳。
        :type StartLiveTime: int
        :param _Description: 导播台的描述
        :type Description: str
        :param _CreateTime: 导播台创建时间，值为unix时间戳。
        :type CreateTime: int
        :param _Status: 导播台状态 
0：停止状态，无预监，无主监
1：无预监，有主监
2：有预监，无主监
3：有预监，有主监
        :type Status: int
        :param _ExpireTime: 导播台的过期时间戳。值为-1或unix时间戳。 
默认值为-1。 当值为-1时，表示该导播台永不过期。 
当值为正常unix时间戳时，导播台将在该时间过期。 
导播台过期后，预监与主监画面将自动停止，转推自动停止。 
点播、直播url将停止转拉，推流url需自行停止推流。
        :type ExpireTime: int
        :param _DelayTime: 导播台延时播放时间，单位为秒。 
        :type DelayTime: int
        :param _PgmWidth: 导播台主监输出的宽度，单位为像素。
        :type PgmWidth: int
        :param _PgmHeight: 导播台主监输出的高度，单位为像素。
        :type PgmHeight: int
        :param _PgmFps: 导播台主监输出的帧率。
        :type PgmFps: int
        :param _PgmBitRate: 导播台主监输出的码率，单位为kbps
        :type PgmBitRate: int
        :param _PgmAudioBitRate: 导播台主监输出的音频码率，单位为kbps。
        :type PgmAudioBitRate: int
        :param _FeeType: 导播台的计费类型。 
0 通用型 1 播单型。
注： 本参数暂无作用。
        :type FeeType: int
        :param _RecordTemplateId: 录制模板id。
        :type RecordTemplateId: int
        :param _RecordStatus: 录制状态。 
0：未录制 
1：录制中
        :type RecordStatus: int
        :param _RecordTaskId: 录制接口返回的taskid
        :type RecordTaskId: str
        """
        self._CasterId = None
        self._CasterName = None
        self._StartLiveTime = None
        self._Description = None
        self._CreateTime = None
        self._Status = None
        self._ExpireTime = None
        self._DelayTime = None
        self._PgmWidth = None
        self._PgmHeight = None
        self._PgmFps = None
        self._PgmBitRate = None
        self._PgmAudioBitRate = None
        self._FeeType = None
        self._RecordTemplateId = None
        self._RecordStatus = None
        self._RecordTaskId = None

    @property
    def CasterId(self):
        """导播台ID
        :rtype: int
        """
        return self._CasterId

    @CasterId.setter
    def CasterId(self, CasterId):
        self._CasterId = CasterId

    @property
    def CasterName(self):
        """导播台名称
        :rtype: str
        """
        return self._CasterName

    @CasterName.setter
    def CasterName(self, CasterName):
        self._CasterName = CasterName

    @property
    def StartLiveTime(self):
        """导播台上一次启动pgm的时间，值为unix时间戳。
        :rtype: int
        """
        return self._StartLiveTime

    @StartLiveTime.setter
    def StartLiveTime(self, StartLiveTime):
        self._StartLiveTime = StartLiveTime

    @property
    def Description(self):
        """导播台的描述
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def CreateTime(self):
        """导播台创建时间，值为unix时间戳。
        :rtype: int
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def Status(self):
        """导播台状态 
0：停止状态，无预监，无主监
1：无预监，有主监
2：有预监，无主监
3：有预监，有主监
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ExpireTime(self):
        """导播台的过期时间戳。值为-1或unix时间戳。 
默认值为-1。 当值为-1时，表示该导播台永不过期。 
当值为正常unix时间戳时，导播台将在该时间过期。 
导播台过期后，预监与主监画面将自动停止，转推自动停止。 
点播、直播url将停止转拉，推流url需自行停止推流。
        :rtype: int
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def DelayTime(self):
        """导播台延时播放时间，单位为秒。 
        :rtype: int
        """
        return self._DelayTime

    @DelayTime.setter
    def DelayTime(self, DelayTime):
        self._DelayTime = DelayTime

    @property
    def PgmWidth(self):
        """导播台主监输出的宽度，单位为像素。
        :rtype: int
        """
        return self._PgmWidth

    @PgmWidth.setter
    def PgmWidth(self, PgmWidth):
        self._PgmWidth = PgmWidth

    @property
    def PgmHeight(self):
        """导播台主监输出的高度，单位为像素。
        :rtype: int
        """
        return self._PgmHeight

    @PgmHeight.setter
    def PgmHeight(self, PgmHeight):
        self._PgmHeight = PgmHeight

    @property
    def PgmFps(self):
        """导播台主监输出的帧率。
        :rtype: int
        """
        return self._PgmFps

    @PgmFps.setter
    def PgmFps(self, PgmFps):
        self._PgmFps = PgmFps

    @property
    def PgmBitRate(self):
        """导播台主监输出的码率，单位为kbps
        :rtype: int
        """
        return self._PgmBitRate

    @PgmBitRate.setter
    def PgmBitRate(self, PgmBitRate):
        self._PgmBitRate = PgmBitRate

    @property
    def PgmAudioBitRate(self):
        """导播台主监输出的音频码率，单位为kbps。
        :rtype: int
        """
        return self._PgmAudioBitRate

    @PgmAudioBitRate.setter
    def PgmAudioBitRate(self, PgmAudioBitRate):
        self._PgmAudioBitRate = PgmAudioBitRate

    @property
    def FeeType(self):
        """导播台的计费类型。 
0 通用型 1 播单型。
注： 本参数暂无作用。
        :rtype: int
        """
        return self._FeeType

    @FeeType.setter
    def FeeType(self, FeeType):
        self._FeeType = FeeType

    @property
    def RecordTemplateId(self):
        """录制模板id。
        :rtype: int
        """
        return self._RecordTemplateId

    @RecordTemplateId.setter
    def RecordTemplateId(self, RecordTemplateId):
        self._RecordTemplateId = RecordTemplateId

    @property
    def RecordStatus(self):
        """录制状态。 
0：未录制 
1：录制中
        :rtype: int
        """
        return self._RecordStatus

    @RecordStatus.setter
    def RecordStatus(self, RecordStatus):
        self._RecordStatus = RecordStatus

    @property
    def RecordTaskId(self):
        """录制接口返回的taskid
        :rtype: str
        """
        return self._RecordTaskId

    @RecordTaskId.setter
    def RecordTaskId(self, RecordTaskId):
        self._RecordTaskId = RecordTaskId


    def _deserialize(self, params):
        self._CasterId = params.get("CasterId")
        self._CasterName = params.get("CasterName")
        self._StartLiveTime = params.get("StartLiveTime")
        self._Description = params.get("Description")
        self._CreateTime = params.get("CreateTime")
        self._Status = params.get("Status")
        self._ExpireTime = params.get("ExpireTime")
        self._DelayTime = params.get("DelayTime")
        self._PgmWidth = params.get("PgmWidth")
        self._PgmHeight = params.get("PgmHeight")
        self._PgmFps = params.get("PgmFps")
        self._PgmBitRate = params.get("PgmBitRate")
        self._PgmAudioBitRate = params.get("PgmAudioBitRate")
        self._FeeType = params.get("FeeType")
        self._RecordTemplateId = params.get("RecordTemplateId")
        self._RecordStatus = params.get("RecordStatus")
        self._RecordTaskId = params.get("RecordTaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CasterInputInfo(AbstractModel):
    """导播台输入信息参数

    """

    def __init__(self):
        r"""
        :param _InputIndex: 输入源Index。
范围[1, 24]
        :type InputIndex: int
        :param _InputType: 输入源类型。
范围[0,1,2,3,4]。
0：推流地址。
1：点播文件地址。
2：直播拉流地址。
3：图片地址。
4：webrtc协议推流地址。
        :type InputType: int
        :param _InputUrl: 输入源的源地址。
最大允许长度512。
当InputType为0（推流地址），2（直播拉流地址），3（图片地址）,4（webrtc推流地址）这几种类型时，URL需填入该字段。

        :type InputUrl: str
        :param _Description: 输入源描述。
最大允许长度256字符。
        :type Description: str
        :param _InputUrls: 点播地址列表。仅当input type为1（点播地址）时，将一个或多个点播地址，填入该字段。
单个地址最大允许长度512字符。
最多允许同时填入5个地址。
注：此时需保持InputUrl字段为空。
        :type InputUrls: list of str
        :param _LoopEnable: 是否启用点播无限循环播放。
注：当前该字段未生效，默认为True。
        :type LoopEnable: bool
        :param _LoopNumber: 点播循环次数。
允许值-1或正整数。
当值为-1时，表示无限循环。
当值为其他正整数时，表示循环对应次数。
注：该字段暂未生效。
        :type LoopNumber: int
        :param _PullPushEnable: 是否启用拉取到导播台。
注：该字段默认强制为true。
        :type PullPushEnable: bool
        :param _Volume: 输入源音量百分比。
默认为100。表示音量为原始大小。
允许值[0,200]。
        :type Volume: int
        """
        self._InputIndex = None
        self._InputType = None
        self._InputUrl = None
        self._Description = None
        self._InputUrls = None
        self._LoopEnable = None
        self._LoopNumber = None
        self._PullPushEnable = None
        self._Volume = None

    @property
    def InputIndex(self):
        """输入源Index。
范围[1, 24]
        :rtype: int
        """
        return self._InputIndex

    @InputIndex.setter
    def InputIndex(self, InputIndex):
        self._InputIndex = InputIndex

    @property
    def InputType(self):
        """输入源类型。
范围[0,1,2,3,4]。
0：推流地址。
1：点播文件地址。
2：直播拉流地址。
3：图片地址。
4：webrtc协议推流地址。
        :rtype: int
        """
        return self._InputType

    @InputType.setter
    def InputType(self, InputType):
        self._InputType = InputType

    @property
    def InputUrl(self):
        """输入源的源地址。
最大允许长度512。
当InputType为0（推流地址），2（直播拉流地址），3（图片地址）,4（webrtc推流地址）这几种类型时，URL需填入该字段。

        :rtype: str
        """
        return self._InputUrl

    @InputUrl.setter
    def InputUrl(self, InputUrl):
        self._InputUrl = InputUrl

    @property
    def Description(self):
        """输入源描述。
最大允许长度256字符。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def InputUrls(self):
        """点播地址列表。仅当input type为1（点播地址）时，将一个或多个点播地址，填入该字段。
单个地址最大允许长度512字符。
最多允许同时填入5个地址。
注：此时需保持InputUrl字段为空。
        :rtype: list of str
        """
        return self._InputUrls

    @InputUrls.setter
    def InputUrls(self, InputUrls):
        self._InputUrls = InputUrls

    @property
    def LoopEnable(self):
        """是否启用点播无限循环播放。
注：当前该字段未生效，默认为True。
        :rtype: bool
        """
        return self._LoopEnable

    @LoopEnable.setter
    def LoopEnable(self, LoopEnable):
        self._LoopEnable = LoopEnable

    @property
    def LoopNumber(self):
        """点播循环次数。
允许值-1或正整数。
当值为-1时，表示无限循环。
当值为其他正整数时，表示循环对应次数。
注：该字段暂未生效。
        :rtype: int
        """
        return self._LoopNumber

    @LoopNumber.setter
    def LoopNumber(self, LoopNumber):
        self._LoopNumber = LoopNumber

    @property
    def PullPushEnable(self):
        """是否启用拉取到导播台。
注：该字段默认强制为true。
        :rtype: bool
        """
        return self._PullPushEnable

    @PullPushEnable.setter
    def PullPushEnable(self, PullPushEnable):
        self._PullPushEnable = PullPushEnable

    @property
    def Volume(self):
        """输入源音量百分比。
默认为100。表示音量为原始大小。
允许值[0,200]。
        :rtype: int
        """
        return self._Volume

    @Volume.setter
    def Volume(self, Volume):
        self._Volume = Volume


    def _deserialize(self, params):
        self._InputIndex = params.get("InputIndex")
        self._InputType = params.get("InputType")
        self._InputUrl = params.get("InputUrl")
        self._Description = params.get("Description")
        self._InputUrls = params.get("InputUrls")
        self._LoopEnable = params.get("LoopEnable")
        self._LoopNumber = params.get("LoopNumber")
        self._PullPushEnable = params.get("PullPushEnable")
        self._Volume = params.get("Volume")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CasterLayoutInfo(AbstractModel):
    """导播台布局参数。

    """

    def __init__(self):
        r"""
        :param _LayoutIndex: 布局Index。
        :type LayoutIndex: int
        :param _LayoutTemplateId: 布局模板Id。
有效值[1，20，21，31，32，41]
当使用布局模版时，无需LayoutParams参数，导播台将使用模版布局参数。

        :type LayoutTemplateId: int
        :param _InputIndexList: 布局绑定的输入列表。按布局LayerId从小到大，按顺序排列。
已有两个画面的布局为例，输入1对应LayerId为1，输入2对应的LayerId为2，该字段应该填入"1|2"。
        :type InputIndexList: str
        :param _LayoutParams: 详细的布局参数列表。
        :type LayoutParams: list of CasterLayoutParam
        :param _LayoutWidth: 布局输出的宽度，单位为像素。
默认为1280像素。
注：该值仅在画中画布局，且未设置PgmWidth时生效。
        :type LayoutWidth: int
        :param _LayoutHeight: 布局输出的高度，单位为像素。
注：该参数仅在画中画布局，且未设置PgmHeight时生效。
        :type LayoutHeight: int
        """
        self._LayoutIndex = None
        self._LayoutTemplateId = None
        self._InputIndexList = None
        self._LayoutParams = None
        self._LayoutWidth = None
        self._LayoutHeight = None

    @property
    def LayoutIndex(self):
        """布局Index。
        :rtype: int
        """
        return self._LayoutIndex

    @LayoutIndex.setter
    def LayoutIndex(self, LayoutIndex):
        self._LayoutIndex = LayoutIndex

    @property
    def LayoutTemplateId(self):
        """布局模板Id。
有效值[1，20，21，31，32，41]
当使用布局模版时，无需LayoutParams参数，导播台将使用模版布局参数。

        :rtype: int
        """
        return self._LayoutTemplateId

    @LayoutTemplateId.setter
    def LayoutTemplateId(self, LayoutTemplateId):
        self._LayoutTemplateId = LayoutTemplateId

    @property
    def InputIndexList(self):
        """布局绑定的输入列表。按布局LayerId从小到大，按顺序排列。
已有两个画面的布局为例，输入1对应LayerId为1，输入2对应的LayerId为2，该字段应该填入"1|2"。
        :rtype: str
        """
        return self._InputIndexList

    @InputIndexList.setter
    def InputIndexList(self, InputIndexList):
        self._InputIndexList = InputIndexList

    @property
    def LayoutParams(self):
        """详细的布局参数列表。
        :rtype: list of CasterLayoutParam
        """
        return self._LayoutParams

    @LayoutParams.setter
    def LayoutParams(self, LayoutParams):
        self._LayoutParams = LayoutParams

    @property
    def LayoutWidth(self):
        """布局输出的宽度，单位为像素。
默认为1280像素。
注：该值仅在画中画布局，且未设置PgmWidth时生效。
        :rtype: int
        """
        return self._LayoutWidth

    @LayoutWidth.setter
    def LayoutWidth(self, LayoutWidth):
        self._LayoutWidth = LayoutWidth

    @property
    def LayoutHeight(self):
        """布局输出的高度，单位为像素。
注：该参数仅在画中画布局，且未设置PgmHeight时生效。
        :rtype: int
        """
        return self._LayoutHeight

    @LayoutHeight.setter
    def LayoutHeight(self, LayoutHeight):
        self._LayoutHeight = LayoutHeight


    def _deserialize(self, params):
        self._LayoutIndex = params.get("LayoutIndex")
        self._LayoutTemplateId = params.get("LayoutTemplateId")
        self._InputIndexList = params.get("InputIndexList")
        if params.get("LayoutParams") is not None:
            self._LayoutParams = []
            for item in params.get("LayoutParams"):
                obj = CasterLayoutParam()
                obj._deserialize(item)
                self._LayoutParams.append(obj)
        self._LayoutWidth = params.get("LayoutWidth")
        self._LayoutHeight = params.get("LayoutHeight")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CasterLayoutParam(AbstractModel):
    """导播台布局详细参数。

    """

    def __init__(self):
        r"""
        :param _LayerId: 布局层ID。
在画面最终渲染时，将按ID从小到大的顺序，由下至上渲染。
        :type LayerId: int
        :param _LayerWidth: 布局层宽度。单位为百分比，范围[0.0,1.0]，表示该层在最终画面上所占的比例值。
        :type LayerWidth: float
        :param _LayerHeight: 布局层高度。单位为百分比，范围[0.0,1.0]， 表示该层在最终画面上所占的比例值。
        :type LayerHeight: float
        :param _LayerLocationX: 布局层位置x坐标。单位为百分比，范围[0.0,1.0]，表示该层在最终画面上x坐标所占的比例值。
        :type LayerLocationX: float
        :param _LayerLocationY: 布局层位置Y坐标。单位为百分比，范围[0.0,1.0]， 表示该层在最终画面Y坐标上所占的比例值。
        :type LayerLocationY: float
        :param _UsePortraitSegment: 是否启用抠图。
        :type UsePortraitSegment: bool
        """
        self._LayerId = None
        self._LayerWidth = None
        self._LayerHeight = None
        self._LayerLocationX = None
        self._LayerLocationY = None
        self._UsePortraitSegment = None

    @property
    def LayerId(self):
        """布局层ID。
在画面最终渲染时，将按ID从小到大的顺序，由下至上渲染。
        :rtype: int
        """
        return self._LayerId

    @LayerId.setter
    def LayerId(self, LayerId):
        self._LayerId = LayerId

    @property
    def LayerWidth(self):
        """布局层宽度。单位为百分比，范围[0.0,1.0]，表示该层在最终画面上所占的比例值。
        :rtype: float
        """
        return self._LayerWidth

    @LayerWidth.setter
    def LayerWidth(self, LayerWidth):
        self._LayerWidth = LayerWidth

    @property
    def LayerHeight(self):
        """布局层高度。单位为百分比，范围[0.0,1.0]， 表示该层在最终画面上所占的比例值。
        :rtype: float
        """
        return self._LayerHeight

    @LayerHeight.setter
    def LayerHeight(self, LayerHeight):
        self._LayerHeight = LayerHeight

    @property
    def LayerLocationX(self):
        """布局层位置x坐标。单位为百分比，范围[0.0,1.0]，表示该层在最终画面上x坐标所占的比例值。
        :rtype: float
        """
        return self._LayerLocationX

    @LayerLocationX.setter
    def LayerLocationX(self, LayerLocationX):
        self._LayerLocationX = LayerLocationX

    @property
    def LayerLocationY(self):
        """布局层位置Y坐标。单位为百分比，范围[0.0,1.0]， 表示该层在最终画面Y坐标上所占的比例值。
        :rtype: float
        """
        return self._LayerLocationY

    @LayerLocationY.setter
    def LayerLocationY(self, LayerLocationY):
        self._LayerLocationY = LayerLocationY

    @property
    def UsePortraitSegment(self):
        """是否启用抠图。
        :rtype: bool
        """
        return self._UsePortraitSegment

    @UsePortraitSegment.setter
    def UsePortraitSegment(self, UsePortraitSegment):
        self._UsePortraitSegment = UsePortraitSegment


    def _deserialize(self, params):
        self._LayerId = params.get("LayerId")
        self._LayerWidth = params.get("LayerWidth")
        self._LayerHeight = params.get("LayerHeight")
        self._LayerLocationX = params.get("LayerLocationX")
        self._LayerLocationY = params.get("LayerLocationY")
        self._UsePortraitSegment = params.get("UsePortraitSegment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CasterMarkPicInfo(AbstractModel):
    """导播台水印信息。

    """

    def __init__(self):
        r"""
        :param _MarkPicIndex: 水印图片Index。
        :type MarkPicIndex: int
        :param _MarkPicId: 注：该字段已废弃。
        :type MarkPicId: int
        :param _MarkPicWidth: 水印图片在输出时的宽度。
当该值为大于1的整数值时，单位为像素，允许范围[1,1920]。 
当该值为小于1大于0的小数时，单位为百分比，表示水印在最终画面上所占的比例值。
        :type MarkPicWidth: float
        :param _MarkPicHeight: 水印图片在输出时的高度。
当该值为大于1的整数值时，单位为像素，允许范围[1,1080]。 
当该值为小于1大于0的小数时，单位为百分比，表示水印在输出上所占的比例值。
        :type MarkPicHeight: float
        :param _MarkPicLocationX: 水印图片在输出时的X轴坐标。
当该值为大于1的整数值时，单位为像素，允许范围[1,1920]。 
当该值为小于1大于0的小数时，单位为百分比，表示水印在最终画面上x坐标所占的比例值。
        :type MarkPicLocationX: float
        :param _MarkPicLocationY: 水印图片在输出时的Y坐标。
当该值为大于1的整数值时，单位为像素，允许范围[1,1080]。 
当该值为小于1大于0的小数时，单位为百分比，表示水印在最终画面Y坐标上所占的比例值。
        :type MarkPicLocationY: float
        :param _MarkPicUrl: 水印地址。
最大长度256字符，且url需以jpg、jpeg、png、bmp、gif后缀结尾。
        :type MarkPicUrl: str
        :param _Description: 水印描述。
最大允许长度为256。
        :type Description: str
        :param _IsEqualProportion: 是否启用了等比例缩放。
注：该字段仅做状态保存，无实际效果。
        :type IsEqualProportion: bool
        """
        self._MarkPicIndex = None
        self._MarkPicId = None
        self._MarkPicWidth = None
        self._MarkPicHeight = None
        self._MarkPicLocationX = None
        self._MarkPicLocationY = None
        self._MarkPicUrl = None
        self._Description = None
        self._IsEqualProportion = None

    @property
    def MarkPicIndex(self):
        """水印图片Index。
        :rtype: int
        """
        return self._MarkPicIndex

    @MarkPicIndex.setter
    def MarkPicIndex(self, MarkPicIndex):
        self._MarkPicIndex = MarkPicIndex

    @property
    def MarkPicId(self):
        """注：该字段已废弃。
        :rtype: int
        """
        return self._MarkPicId

    @MarkPicId.setter
    def MarkPicId(self, MarkPicId):
        self._MarkPicId = MarkPicId

    @property
    def MarkPicWidth(self):
        """水印图片在输出时的宽度。
当该值为大于1的整数值时，单位为像素，允许范围[1,1920]。 
当该值为小于1大于0的小数时，单位为百分比，表示水印在最终画面上所占的比例值。
        :rtype: float
        """
        return self._MarkPicWidth

    @MarkPicWidth.setter
    def MarkPicWidth(self, MarkPicWidth):
        self._MarkPicWidth = MarkPicWidth

    @property
    def MarkPicHeight(self):
        """水印图片在输出时的高度。
当该值为大于1的整数值时，单位为像素，允许范围[1,1080]。 
当该值为小于1大于0的小数时，单位为百分比，表示水印在输出上所占的比例值。
        :rtype: float
        """
        return self._MarkPicHeight

    @MarkPicHeight.setter
    def MarkPicHeight(self, MarkPicHeight):
        self._MarkPicHeight = MarkPicHeight

    @property
    def MarkPicLocationX(self):
        """水印图片在输出时的X轴坐标。
当该值为大于1的整数值时，单位为像素，允许范围[1,1920]。 
当该值为小于1大于0的小数时，单位为百分比，表示水印在最终画面上x坐标所占的比例值。
        :rtype: float
        """
        return self._MarkPicLocationX

    @MarkPicLocationX.setter
    def MarkPicLocationX(self, MarkPicLocationX):
        self._MarkPicLocationX = MarkPicLocationX

    @property
    def MarkPicLocationY(self):
        """水印图片在输出时的Y坐标。
当该值为大于1的整数值时，单位为像素，允许范围[1,1080]。 
当该值为小于1大于0的小数时，单位为百分比，表示水印在最终画面Y坐标上所占的比例值。
        :rtype: float
        """
        return self._MarkPicLocationY

    @MarkPicLocationY.setter
    def MarkPicLocationY(self, MarkPicLocationY):
        self._MarkPicLocationY = MarkPicLocationY

    @property
    def MarkPicUrl(self):
        """水印地址。
最大长度256字符，且url需以jpg、jpeg、png、bmp、gif后缀结尾。
        :rtype: str
        """
        return self._MarkPicUrl

    @MarkPicUrl.setter
    def MarkPicUrl(self, MarkPicUrl):
        self._MarkPicUrl = MarkPicUrl

    @property
    def Description(self):
        """水印描述。
最大允许长度为256。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def IsEqualProportion(self):
        """是否启用了等比例缩放。
注：该字段仅做状态保存，无实际效果。
        :rtype: bool
        """
        return self._IsEqualProportion

    @IsEqualProportion.setter
    def IsEqualProportion(self, IsEqualProportion):
        self._IsEqualProportion = IsEqualProportion


    def _deserialize(self, params):
        self._MarkPicIndex = params.get("MarkPicIndex")
        self._MarkPicId = params.get("MarkPicId")
        self._MarkPicWidth = params.get("MarkPicWidth")
        self._MarkPicHeight = params.get("MarkPicHeight")
        self._MarkPicLocationX = params.get("MarkPicLocationX")
        self._MarkPicLocationY = params.get("MarkPicLocationY")
        self._MarkPicUrl = params.get("MarkPicUrl")
        self._Description = params.get("Description")
        self._IsEqualProportion = params.get("IsEqualProportion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CasterMarkWordInfo(AbstractModel):
    """导播台文字水印配置。

    """

    def __init__(self):
        r"""
        :param _MarkWordIndex: 文字水印Index。
        :type MarkWordIndex: int
        :param _MarkWordText: 文字水印内容。
        :type MarkWordText: str
        :param _MarkWordFontSize: 文字水印的字号。
范围[16, 60]
        :type MarkWordFontSize: int
        :param _MarkWordFontColor: 文字水印的颜色，值为HEX颜色代码
        :type MarkWordFontColor: str
        :param _MarkWordFontType: 文字水印的字体类型。
范围[1,2]。
1. 宋体
2. 黑体
        :type MarkWordFontType: int
        :param _MarkWordLocationX: 文字水印的x坐标位置，单位百分比。
范围[0.0, 1.0]

        :type MarkWordLocationX: float
        :param _MarkWordLocationY: 文字水印的Y坐标位置，单位百分比。
范围[0.0, 1.0]

        :type MarkWordLocationY: float
        :param _MarkWordRollEnable: 是否开启文字跑马灯功能。
默认为false。
        :type MarkWordRollEnable: bool
        :param _MarkWordRollOnceTime: 跑马灯文字显示一遍的时间，单位为秒。
默认为5s。
范围[5, 600]。
        :type MarkWordRollOnceTime: int
        :param _MarkWordRollDirection: 跑马灯文字的方向。
默认值为0。
范围[0,1]。
0 从左到右
1 从右到左
        :type MarkWordRollDirection: int
        :param _MarkWordRollStartLocationX: 跑马灯文字显示的起始x坐标，单位百分比。
范围[0.0, 1.0]
        :type MarkWordRollStartLocationX: float
        :param _MarkWordRollEndLocationX: 跑马灯文字显示的截止x坐标，单位百分比。
范围[0.0, 1.0]
        :type MarkWordRollEndLocationX: float
        """
        self._MarkWordIndex = None
        self._MarkWordText = None
        self._MarkWordFontSize = None
        self._MarkWordFontColor = None
        self._MarkWordFontType = None
        self._MarkWordLocationX = None
        self._MarkWordLocationY = None
        self._MarkWordRollEnable = None
        self._MarkWordRollOnceTime = None
        self._MarkWordRollDirection = None
        self._MarkWordRollStartLocationX = None
        self._MarkWordRollEndLocationX = None

    @property
    def MarkWordIndex(self):
        """文字水印Index。
        :rtype: int
        """
        return self._MarkWordIndex

    @MarkWordIndex.setter
    def MarkWordIndex(self, MarkWordIndex):
        self._MarkWordIndex = MarkWordIndex

    @property
    def MarkWordText(self):
        """文字水印内容。
        :rtype: str
        """
        return self._MarkWordText

    @MarkWordText.setter
    def MarkWordText(self, MarkWordText):
        self._MarkWordText = MarkWordText

    @property
    def MarkWordFontSize(self):
        """文字水印的字号。
范围[16, 60]
        :rtype: int
        """
        return self._MarkWordFontSize

    @MarkWordFontSize.setter
    def MarkWordFontSize(self, MarkWordFontSize):
        self._MarkWordFontSize = MarkWordFontSize

    @property
    def MarkWordFontColor(self):
        """文字水印的颜色，值为HEX颜色代码
        :rtype: str
        """
        return self._MarkWordFontColor

    @MarkWordFontColor.setter
    def MarkWordFontColor(self, MarkWordFontColor):
        self._MarkWordFontColor = MarkWordFontColor

    @property
    def MarkWordFontType(self):
        """文字水印的字体类型。
范围[1,2]。
1. 宋体
2. 黑体
        :rtype: int
        """
        return self._MarkWordFontType

    @MarkWordFontType.setter
    def MarkWordFontType(self, MarkWordFontType):
        self._MarkWordFontType = MarkWordFontType

    @property
    def MarkWordLocationX(self):
        """文字水印的x坐标位置，单位百分比。
范围[0.0, 1.0]

        :rtype: float
        """
        return self._MarkWordLocationX

    @MarkWordLocationX.setter
    def MarkWordLocationX(self, MarkWordLocationX):
        self._MarkWordLocationX = MarkWordLocationX

    @property
    def MarkWordLocationY(self):
        """文字水印的Y坐标位置，单位百分比。
范围[0.0, 1.0]

        :rtype: float
        """
        return self._MarkWordLocationY

    @MarkWordLocationY.setter
    def MarkWordLocationY(self, MarkWordLocationY):
        self._MarkWordLocationY = MarkWordLocationY

    @property
    def MarkWordRollEnable(self):
        """是否开启文字跑马灯功能。
默认为false。
        :rtype: bool
        """
        return self._MarkWordRollEnable

    @MarkWordRollEnable.setter
    def MarkWordRollEnable(self, MarkWordRollEnable):
        self._MarkWordRollEnable = MarkWordRollEnable

    @property
    def MarkWordRollOnceTime(self):
        """跑马灯文字显示一遍的时间，单位为秒。
默认为5s。
范围[5, 600]。
        :rtype: int
        """
        return self._MarkWordRollOnceTime

    @MarkWordRollOnceTime.setter
    def MarkWordRollOnceTime(self, MarkWordRollOnceTime):
        self._MarkWordRollOnceTime = MarkWordRollOnceTime

    @property
    def MarkWordRollDirection(self):
        """跑马灯文字的方向。
默认值为0。
范围[0,1]。
0 从左到右
1 从右到左
        :rtype: int
        """
        return self._MarkWordRollDirection

    @MarkWordRollDirection.setter
    def MarkWordRollDirection(self, MarkWordRollDirection):
        self._MarkWordRollDirection = MarkWordRollDirection

    @property
    def MarkWordRollStartLocationX(self):
        """跑马灯文字显示的起始x坐标，单位百分比。
范围[0.0, 1.0]
        :rtype: float
        """
        return self._MarkWordRollStartLocationX

    @MarkWordRollStartLocationX.setter
    def MarkWordRollStartLocationX(self, MarkWordRollStartLocationX):
        self._MarkWordRollStartLocationX = MarkWordRollStartLocationX

    @property
    def MarkWordRollEndLocationX(self):
        """跑马灯文字显示的截止x坐标，单位百分比。
范围[0.0, 1.0]
        :rtype: float
        """
        return self._MarkWordRollEndLocationX

    @MarkWordRollEndLocationX.setter
    def MarkWordRollEndLocationX(self, MarkWordRollEndLocationX):
        self._MarkWordRollEndLocationX = MarkWordRollEndLocationX


    def _deserialize(self, params):
        self._MarkWordIndex = params.get("MarkWordIndex")
        self._MarkWordText = params.get("MarkWordText")
        self._MarkWordFontSize = params.get("MarkWordFontSize")
        self._MarkWordFontColor = params.get("MarkWordFontColor")
        self._MarkWordFontType = params.get("MarkWordFontType")
        self._MarkWordLocationX = params.get("MarkWordLocationX")
        self._MarkWordLocationY = params.get("MarkWordLocationY")
        self._MarkWordRollEnable = params.get("MarkWordRollEnable")
        self._MarkWordRollOnceTime = params.get("MarkWordRollOnceTime")
        self._MarkWordRollDirection = params.get("MarkWordRollDirection")
        self._MarkWordRollStartLocationX = params.get("MarkWordRollStartLocationX")
        self._MarkWordRollEndLocationX = params.get("MarkWordRollEndLocationX")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CasterOutputInfo(AbstractModel):
    """导播台推流信息。
    当导播台主监启动后，系统将自动将主监推流到腾讯云和其他第三方平台。

    """

    def __init__(self):
        r"""
        :param _OutputIndex: 推流信息Index。
当OutputType为1（表示推流到腾讯云直播）时，该值固定为0。
范围[0,10]。
        :type OutputIndex: int
        :param _OutputUrl: rtmp协议推流地址。
最大允许长度512字符。
        :type OutputUrl: str
        :param _Description: 描述信息。
        :type Description: str
        :param _OutputStreamId: 推流到腾讯云直播源站时，使用的流ID。
仅当OutputType为1时生效。
最大允许128字符。
        :type OutputStreamId: str
        :param _OutputType: 推流类型。
范围[1,2]
1. 推送到腾讯云直播源站。
2. 推送到第三方源站。
        :type OutputType: int
        :param _OutputDomainName: 推到腾讯云直播源站时，使用的域名。
最大允许128字符，且域名需属于当前账号绑定的云直播推流域名。
仅在OutputType为1时生效。
        :type OutputDomainName: str
        :param _OutputAppName: 推到腾讯云直播源站时，使用的AppName。
最大允许64字符。
仅在OutputType为1时生效。
        :type OutputAppName: str
        :param _OutputParam: 推到腾讯云直播源站时需要添加的推流参数。
最大允许长度256字符。
仅在OutputType为1时生效。
        :type OutputParam: str
        """
        self._OutputIndex = None
        self._OutputUrl = None
        self._Description = None
        self._OutputStreamId = None
        self._OutputType = None
        self._OutputDomainName = None
        self._OutputAppName = None
        self._OutputParam = None

    @property
    def OutputIndex(self):
        """推流信息Index。
当OutputType为1（表示推流到腾讯云直播）时，该值固定为0。
范围[0,10]。
        :rtype: int
        """
        return self._OutputIndex

    @OutputIndex.setter
    def OutputIndex(self, OutputIndex):
        self._OutputIndex = OutputIndex

    @property
    def OutputUrl(self):
        """rtmp协议推流地址。
最大允许长度512字符。
        :rtype: str
        """
        return self._OutputUrl

    @OutputUrl.setter
    def OutputUrl(self, OutputUrl):
        self._OutputUrl = OutputUrl

    @property
    def Description(self):
        """描述信息。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def OutputStreamId(self):
        """推流到腾讯云直播源站时，使用的流ID。
仅当OutputType为1时生效。
最大允许128字符。
        :rtype: str
        """
        return self._OutputStreamId

    @OutputStreamId.setter
    def OutputStreamId(self, OutputStreamId):
        self._OutputStreamId = OutputStreamId

    @property
    def OutputType(self):
        """推流类型。
范围[1,2]
1. 推送到腾讯云直播源站。
2. 推送到第三方源站。
        :rtype: int
        """
        return self._OutputType

    @OutputType.setter
    def OutputType(self, OutputType):
        self._OutputType = OutputType

    @property
    def OutputDomainName(self):
        """推到腾讯云直播源站时，使用的域名。
最大允许128字符，且域名需属于当前账号绑定的云直播推流域名。
仅在OutputType为1时生效。
        :rtype: str
        """
        return self._OutputDomainName

    @OutputDomainName.setter
    def OutputDomainName(self, OutputDomainName):
        self._OutputDomainName = OutputDomainName

    @property
    def OutputAppName(self):
        """推到腾讯云直播源站时，使用的AppName。
最大允许64字符。
仅在OutputType为1时生效。
        :rtype: str
        """
        return self._OutputAppName

    @OutputAppName.setter
    def OutputAppName(self, OutputAppName):
        self._OutputAppName = OutputAppName

    @property
    def OutputParam(self):
        """推到腾讯云直播源站时需要添加的推流参数。
最大允许长度256字符。
仅在OutputType为1时生效。
        :rtype: str
        """
        return self._OutputParam

    @OutputParam.setter
    def OutputParam(self, OutputParam):
        self._OutputParam = OutputParam


    def _deserialize(self, params):
        self._OutputIndex = params.get("OutputIndex")
        self._OutputUrl = params.get("OutputUrl")
        self._Description = params.get("Description")
        self._OutputStreamId = params.get("OutputStreamId")
        self._OutputType = params.get("OutputType")
        self._OutputDomainName = params.get("OutputDomainName")
        self._OutputAppName = params.get("OutputAppName")
        self._OutputParam = params.get("OutputParam")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CdnPlayStatData(AbstractModel):
    """下行播放统计指标

    """

    def __init__(self):
        r"""
        :param _Time: 时间点，
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :type Time: str
        :param _Bandwidth: 带宽，单位: Mbps。
        :type Bandwidth: float
        :param _Flux: 流量，单位: MB。
        :type Flux: float
        :param _Request: 新增请求数。
        :type Request: int
        :param _Online: 并发连接数。
        :type Online: int
        """
        self._Time = None
        self._Bandwidth = None
        self._Flux = None
        self._Request = None
        self._Online = None

    @property
    def Time(self):
        """时间点，
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._Time

    @Time.setter
    def Time(self, Time):
        self._Time = Time

    @property
    def Bandwidth(self):
        """带宽，单位: Mbps。
        :rtype: float
        """
        return self._Bandwidth

    @Bandwidth.setter
    def Bandwidth(self, Bandwidth):
        self._Bandwidth = Bandwidth

    @property
    def Flux(self):
        """流量，单位: MB。
        :rtype: float
        """
        return self._Flux

    @Flux.setter
    def Flux(self, Flux):
        self._Flux = Flux

    @property
    def Request(self):
        """新增请求数。
        :rtype: int
        """
        return self._Request

    @Request.setter
    def Request(self, Request):
        self._Request = Request

    @property
    def Online(self):
        """并发连接数。
        :rtype: int
        """
        return self._Online

    @Online.setter
    def Online(self, Online):
        self._Online = Online


    def _deserialize(self, params):
        self._Time = params.get("Time")
        self._Bandwidth = params.get("Bandwidth")
        self._Flux = params.get("Flux")
        self._Request = params.get("Request")
        self._Online = params.get("Online")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CertInfo(AbstractModel):
    """证书信息。

    """

    def __init__(self):
        r"""
        :param _CertId: 证书 ID。
        :type CertId: int
        :param _CertName: 证书名称。
        :type CertName: str
        :param _Description: 描述信息。
        :type Description: str
        :param _CreateTime: 创建时间，UTC 格式。
注：此字段为北京时间（UTC+8时区）。
        :type CreateTime: str
        :param _HttpsCrt: 证书内容。
        :type HttpsCrt: str
        :param _CertType: 证书类型。
0：用户添加证书，
1：腾讯云托管证书。
        :type CertType: int
        :param _CertExpireTime: 证书过期时间，UTC 格式。
注：此字段为北京时间（UTC+8时区）。
        :type CertExpireTime: str
        :param _DomainList: 使用此证书的域名列表。
        :type DomainList: list of str
        """
        self._CertId = None
        self._CertName = None
        self._Description = None
        self._CreateTime = None
        self._HttpsCrt = None
        self._CertType = None
        self._CertExpireTime = None
        self._DomainList = None

    @property
    def CertId(self):
        """证书 ID。
        :rtype: int
        """
        return self._CertId

    @CertId.setter
    def CertId(self, CertId):
        self._CertId = CertId

    @property
    def CertName(self):
        """证书名称。
        :rtype: str
        """
        return self._CertName

    @CertName.setter
    def CertName(self, CertName):
        self._CertName = CertName

    @property
    def Description(self):
        """描述信息。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def CreateTime(self):
        """创建时间，UTC 格式。
注：此字段为北京时间（UTC+8时区）。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def HttpsCrt(self):
        """证书内容。
        :rtype: str
        """
        return self._HttpsCrt

    @HttpsCrt.setter
    def HttpsCrt(self, HttpsCrt):
        self._HttpsCrt = HttpsCrt

    @property
    def CertType(self):
        """证书类型。
0：用户添加证书，
1：腾讯云托管证书。
        :rtype: int
        """
        return self._CertType

    @CertType.setter
    def CertType(self, CertType):
        self._CertType = CertType

    @property
    def CertExpireTime(self):
        """证书过期时间，UTC 格式。
注：此字段为北京时间（UTC+8时区）。
        :rtype: str
        """
        return self._CertExpireTime

    @CertExpireTime.setter
    def CertExpireTime(self, CertExpireTime):
        self._CertExpireTime = CertExpireTime

    @property
    def DomainList(self):
        """使用此证书的域名列表。
        :rtype: list of str
        """
        return self._DomainList

    @DomainList.setter
    def DomainList(self, DomainList):
        self._DomainList = DomainList


    def _deserialize(self, params):
        self._CertId = params.get("CertId")
        self._CertName = params.get("CertName")
        self._Description = params.get("Description")
        self._CreateTime = params.get("CreateTime")
        self._HttpsCrt = params.get("HttpsCrt")
        self._CertType = params.get("CertType")
        self._CertExpireTime = params.get("CertExpireTime")
        self._DomainList = params.get("DomainList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClientIpPlaySumInfo(AbstractModel):
    """客户端ip播放汇总信息。

    """

    def __init__(self):
        r"""
        :param _ClientIp: 客户端 IP，点分型。
        :type ClientIp: str
        :param _Province: 客户端所在省份。
        :type Province: str
        :param _TotalFlux: 总流量。
        :type TotalFlux: float
        :param _TotalRequest: 总请求数。
        :type TotalRequest: int
        :param _TotalFailedRequest: 总失败请求数。
        :type TotalFailedRequest: int
        :param _CountryArea: 客户端所在国家。
        :type CountryArea: str
        """
        self._ClientIp = None
        self._Province = None
        self._TotalFlux = None
        self._TotalRequest = None
        self._TotalFailedRequest = None
        self._CountryArea = None

    @property
    def ClientIp(self):
        """客户端 IP，点分型。
        :rtype: str
        """
        return self._ClientIp

    @ClientIp.setter
    def ClientIp(self, ClientIp):
        self._ClientIp = ClientIp

    @property
    def Province(self):
        """客户端所在省份。
        :rtype: str
        """
        return self._Province

    @Province.setter
    def Province(self, Province):
        self._Province = Province

    @property
    def TotalFlux(self):
        """总流量。
        :rtype: float
        """
        return self._TotalFlux

    @TotalFlux.setter
    def TotalFlux(self, TotalFlux):
        self._TotalFlux = TotalFlux

    @property
    def TotalRequest(self):
        """总请求数。
        :rtype: int
        """
        return self._TotalRequest

    @TotalRequest.setter
    def TotalRequest(self, TotalRequest):
        self._TotalRequest = TotalRequest

    @property
    def TotalFailedRequest(self):
        """总失败请求数。
        :rtype: int
        """
        return self._TotalFailedRequest

    @TotalFailedRequest.setter
    def TotalFailedRequest(self, TotalFailedRequest):
        self._TotalFailedRequest = TotalFailedRequest

    @property
    def CountryArea(self):
        """客户端所在国家。
        :rtype: str
        """
        return self._CountryArea

    @CountryArea.setter
    def CountryArea(self, CountryArea):
        self._CountryArea = CountryArea


    def _deserialize(self, params):
        self._ClientIp = params.get("ClientIp")
        self._Province = params.get("Province")
        self._TotalFlux = params.get("TotalFlux")
        self._TotalRequest = params.get("TotalRequest")
        self._TotalFailedRequest = params.get("TotalFailedRequest")
        self._CountryArea = params.get("CountryArea")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CloudEffectInfo(AbstractModel):
    """云端特效信息。

    """

    def __init__(self):
        r"""
        :param _Id: 云端特效 ID。
        :type Id: str
        :param _Prompt: 云端特效描述词。
        :type Prompt: str
        :param _Flag: 云端特效标签。
        :type Flag: str
        :param _PreviewImageUrl: 云端特效预览图片。
        :type PreviewImageUrl: str
        :param _Type: 云端特效类型。
PGC : 官方精品特效。
AIGC : AI生成的特效。
UGC : 用户上传特效。
        :type Type: str
        :param _CreateTime: 云端特效创建时间。
        :type CreateTime: str
        :param _UpdateTime: 云端特效更新时间。
        :type UpdateTime: str
        """
        self._Id = None
        self._Prompt = None
        self._Flag = None
        self._PreviewImageUrl = None
        self._Type = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def Id(self):
        """云端特效 ID。
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Prompt(self):
        """云端特效描述词。
        :rtype: str
        """
        return self._Prompt

    @Prompt.setter
    def Prompt(self, Prompt):
        self._Prompt = Prompt

    @property
    def Flag(self):
        """云端特效标签。
        :rtype: str
        """
        return self._Flag

    @Flag.setter
    def Flag(self, Flag):
        self._Flag = Flag

    @property
    def PreviewImageUrl(self):
        """云端特效预览图片。
        :rtype: str
        """
        return self._PreviewImageUrl

    @PreviewImageUrl.setter
    def PreviewImageUrl(self, PreviewImageUrl):
        self._PreviewImageUrl = PreviewImageUrl

    @property
    def Type(self):
        """云端特效类型。
PGC : 官方精品特效。
AIGC : AI生成的特效。
UGC : 用户上传特效。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def CreateTime(self):
        """云端特效创建时间。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        """云端特效更新时间。
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Prompt = params.get("Prompt")
        self._Flag = params.get("Flag")
        self._PreviewImageUrl = params.get("PreviewImageUrl")
        self._Type = params.get("Type")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CommonMixControlParams(AbstractModel):
    """通用混流控制参数

    """

    def __init__(self):
        r"""
        :param _UseMixCropCenter: 取值范围[0,1]。
填1时，当参数中图层分辨率参数与视频实际分辨率不一致时，自动从视频中按图层设置的分辨率比例进行裁剪。
        :type UseMixCropCenter: int
        :param _AllowCopy: 取值范围[0,1]
填1时，当InputStreamList中个数为1时，且OutputParams.OutputStreamType为1时，不执行取消操作，执行拷贝流操作
        :type AllowCopy: int
        :param _PassInputSei: 取值范围[0,1]
填1时，透传原始流的sei
        :type PassInputSei: int
        :param _UsePictureTransparent: 取值范围[0,1]
填1时，图片输入中的透明通道生效。
        :type UsePictureTransparent: int
        """
        self._UseMixCropCenter = None
        self._AllowCopy = None
        self._PassInputSei = None
        self._UsePictureTransparent = None

    @property
    def UseMixCropCenter(self):
        """取值范围[0,1]。
填1时，当参数中图层分辨率参数与视频实际分辨率不一致时，自动从视频中按图层设置的分辨率比例进行裁剪。
        :rtype: int
        """
        return self._UseMixCropCenter

    @UseMixCropCenter.setter
    def UseMixCropCenter(self, UseMixCropCenter):
        self._UseMixCropCenter = UseMixCropCenter

    @property
    def AllowCopy(self):
        """取值范围[0,1]
填1时，当InputStreamList中个数为1时，且OutputParams.OutputStreamType为1时，不执行取消操作，执行拷贝流操作
        :rtype: int
        """
        return self._AllowCopy

    @AllowCopy.setter
    def AllowCopy(self, AllowCopy):
        self._AllowCopy = AllowCopy

    @property
    def PassInputSei(self):
        """取值范围[0,1]
填1时，透传原始流的sei
        :rtype: int
        """
        return self._PassInputSei

    @PassInputSei.setter
    def PassInputSei(self, PassInputSei):
        self._PassInputSei = PassInputSei

    @property
    def UsePictureTransparent(self):
        """取值范围[0,1]
填1时，图片输入中的透明通道生效。
        :rtype: int
        """
        return self._UsePictureTransparent

    @UsePictureTransparent.setter
    def UsePictureTransparent(self, UsePictureTransparent):
        self._UsePictureTransparent = UsePictureTransparent


    def _deserialize(self, params):
        self._UseMixCropCenter = params.get("UseMixCropCenter")
        self._AllowCopy = params.get("AllowCopy")
        self._PassInputSei = params.get("PassInputSei")
        self._UsePictureTransparent = params.get("UsePictureTransparent")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CommonMixCropParams(AbstractModel):
    """通用混流输入裁剪参数。

    """

    def __init__(self):
        r"""
        :param _CropWidth: 裁剪的宽度。取值范围[0，2000]。
        :type CropWidth: float
        :param _CropHeight: 裁剪的高度。取值范围[0，2000]。
        :type CropHeight: float
        :param _CropStartLocationX: 裁剪的起始X坐标。取值范围[0，2000]。
        :type CropStartLocationX: float
        :param _CropStartLocationY: 裁剪的起始Y坐标。取值范围[0，2000]。
        :type CropStartLocationY: float
        """
        self._CropWidth = None
        self._CropHeight = None
        self._CropStartLocationX = None
        self._CropStartLocationY = None

    @property
    def CropWidth(self):
        """裁剪的宽度。取值范围[0，2000]。
        :rtype: float
        """
        return self._CropWidth

    @CropWidth.setter
    def CropWidth(self, CropWidth):
        self._CropWidth = CropWidth

    @property
    def CropHeight(self):
        """裁剪的高度。取值范围[0，2000]。
        :rtype: float
        """
        return self._CropHeight

    @CropHeight.setter
    def CropHeight(self, CropHeight):
        self._CropHeight = CropHeight

    @property
    def CropStartLocationX(self):
        """裁剪的起始X坐标。取值范围[0，2000]。
        :rtype: float
        """
        return self._CropStartLocationX

    @CropStartLocationX.setter
    def CropStartLocationX(self, CropStartLocationX):
        self._CropStartLocationX = CropStartLocationX

    @property
    def CropStartLocationY(self):
        """裁剪的起始Y坐标。取值范围[0，2000]。
        :rtype: float
        """
        return self._CropStartLocationY

    @CropStartLocationY.setter
    def CropStartLocationY(self, CropStartLocationY):
        self._CropStartLocationY = CropStartLocationY


    def _deserialize(self, params):
        self._CropWidth = params.get("CropWidth")
        self._CropHeight = params.get("CropHeight")
        self._CropStartLocationX = params.get("CropStartLocationX")
        self._CropStartLocationY = params.get("CropStartLocationY")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CommonMixInputParam(AbstractModel):
    """通用混流输入参数。

    """

    def __init__(self):
        r"""
        :param _InputStreamName: 输入流名称。80字节以内，仅含字母、数字以及下划线的字符串。
当LayoutParams.InputType=0(音视频)/4(纯音频)/5(纯视频)时，该值为需要混流的流名称。
当LayoutParams.InputType=2(图片)/3(画布)时，该值仅用作标识输入，可用类似Canvas1、Pictrue1的名称。
        :type InputStreamName: str
        :param _LayoutParams: 输入流布局参数。
        :type LayoutParams: :class:`tencentcloud.live.v20180801.models.CommonMixLayoutParams`
        :param _CropParams: 输入流裁剪参数。
        :type CropParams: :class:`tencentcloud.live.v20180801.models.CommonMixCropParams`
        :param _PortraitSegmentParams: 抠图参数。
        :type PortraitSegmentParams: :class:`tencentcloud.live.v20180801.models.MixPortraitSegmentParams`
        """
        self._InputStreamName = None
        self._LayoutParams = None
        self._CropParams = None
        self._PortraitSegmentParams = None

    @property
    def InputStreamName(self):
        """输入流名称。80字节以内，仅含字母、数字以及下划线的字符串。
当LayoutParams.InputType=0(音视频)/4(纯音频)/5(纯视频)时，该值为需要混流的流名称。
当LayoutParams.InputType=2(图片)/3(画布)时，该值仅用作标识输入，可用类似Canvas1、Pictrue1的名称。
        :rtype: str
        """
        return self._InputStreamName

    @InputStreamName.setter
    def InputStreamName(self, InputStreamName):
        self._InputStreamName = InputStreamName

    @property
    def LayoutParams(self):
        """输入流布局参数。
        :rtype: :class:`tencentcloud.live.v20180801.models.CommonMixLayoutParams`
        """
        return self._LayoutParams

    @LayoutParams.setter
    def LayoutParams(self, LayoutParams):
        self._LayoutParams = LayoutParams

    @property
    def CropParams(self):
        """输入流裁剪参数。
        :rtype: :class:`tencentcloud.live.v20180801.models.CommonMixCropParams`
        """
        return self._CropParams

    @CropParams.setter
    def CropParams(self, CropParams):
        self._CropParams = CropParams

    @property
    def PortraitSegmentParams(self):
        """抠图参数。
        :rtype: :class:`tencentcloud.live.v20180801.models.MixPortraitSegmentParams`
        """
        return self._PortraitSegmentParams

    @PortraitSegmentParams.setter
    def PortraitSegmentParams(self, PortraitSegmentParams):
        self._PortraitSegmentParams = PortraitSegmentParams


    def _deserialize(self, params):
        self._InputStreamName = params.get("InputStreamName")
        if params.get("LayoutParams") is not None:
            self._LayoutParams = CommonMixLayoutParams()
            self._LayoutParams._deserialize(params.get("LayoutParams"))
        if params.get("CropParams") is not None:
            self._CropParams = CommonMixCropParams()
            self._CropParams._deserialize(params.get("CropParams"))
        if params.get("PortraitSegmentParams") is not None:
            self._PortraitSegmentParams = MixPortraitSegmentParams()
            self._PortraitSegmentParams._deserialize(params.get("PortraitSegmentParams"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CommonMixLayoutParams(AbstractModel):
    """通用混流布局参数。

    """

    def __init__(self):
        r"""
        :param _ImageLayer: 输入图层。取值范围[1，16]。
1)背景流（即大主播画面或画布）的 image_layer 填1。
2)纯音频混流，该参数也需填。
注意：不同输入，该值不可重复
        :type ImageLayer: int
        :param _InputType: 输入类型。取值范围[0，5]。
不填默认为0。
0表示输入流为音视频。
2表示输入流为图片。
3表示输入流为画布。 
4表示输入流为音频。
5表示输入流为纯视频。
        :type InputType: int
        :param _ImageHeight: 输入画面在输出时的高度。取值范围：
像素：[0，2000]
百分比：[0.01，0.99]
不填默认为输入流的高度。
使用百分比时，期望输出为（百分比 * 背景高）。
        :type ImageHeight: float
        :param _ImageWidth: 输入画面在输出时的宽度。取值范围：
像素：[0，2000]
百分比：[0.01，0.99]
不填默认为输入流的宽度。
使用百分比时，期望输出为（百分比 * 背景宽）。
        :type ImageWidth: float
        :param _LocationX: 输入在输出画面的X偏移。取值范围：
像素：[0，2000]
百分比：[0.01，0.99]
不填默认为0。
相对于大主播背景画面左上角的横向偏移。 
使用百分比时，期望输出为（百分比 * 背景宽）。
        :type LocationX: float
        :param _LocationY: 输入在输出画面的Y偏移。取值范围：
像素：[0，2000]
百分比：[0.01，0.99]
不填默认为0。
相对于大主播背景画面左上角的纵向偏移。 
使用百分比时，期望输出为（百分比 * 背景宽）
        :type LocationY: float
        :param _Color: 当InputType为3(画布)时，该值表示画布的颜色。
常用的颜色有：
红色：0xCC0033。
黄色：0xCC9900。
绿色：0xCCCC33。
蓝色：0x99CCFF。
黑色：0x000000。
白色：0xFFFFFF。
灰色：0x999999。
        :type Color: str
        :param _WatermarkId: 当InputType为2(图片)时，该值是水印ID。
        :type WatermarkId: int
        """
        self._ImageLayer = None
        self._InputType = None
        self._ImageHeight = None
        self._ImageWidth = None
        self._LocationX = None
        self._LocationY = None
        self._Color = None
        self._WatermarkId = None

    @property
    def ImageLayer(self):
        """输入图层。取值范围[1，16]。
1)背景流（即大主播画面或画布）的 image_layer 填1。
2)纯音频混流，该参数也需填。
注意：不同输入，该值不可重复
        :rtype: int
        """
        return self._ImageLayer

    @ImageLayer.setter
    def ImageLayer(self, ImageLayer):
        self._ImageLayer = ImageLayer

    @property
    def InputType(self):
        """输入类型。取值范围[0，5]。
不填默认为0。
0表示输入流为音视频。
2表示输入流为图片。
3表示输入流为画布。 
4表示输入流为音频。
5表示输入流为纯视频。
        :rtype: int
        """
        return self._InputType

    @InputType.setter
    def InputType(self, InputType):
        self._InputType = InputType

    @property
    def ImageHeight(self):
        """输入画面在输出时的高度。取值范围：
像素：[0，2000]
百分比：[0.01，0.99]
不填默认为输入流的高度。
使用百分比时，期望输出为（百分比 * 背景高）。
        :rtype: float
        """
        return self._ImageHeight

    @ImageHeight.setter
    def ImageHeight(self, ImageHeight):
        self._ImageHeight = ImageHeight

    @property
    def ImageWidth(self):
        """输入画面在输出时的宽度。取值范围：
像素：[0，2000]
百分比：[0.01，0.99]
不填默认为输入流的宽度。
使用百分比时，期望输出为（百分比 * 背景宽）。
        :rtype: float
        """
        return self._ImageWidth

    @ImageWidth.setter
    def ImageWidth(self, ImageWidth):
        self._ImageWidth = ImageWidth

    @property
    def LocationX(self):
        """输入在输出画面的X偏移。取值范围：
像素：[0，2000]
百分比：[0.01，0.99]
不填默认为0。
相对于大主播背景画面左上角的横向偏移。 
使用百分比时，期望输出为（百分比 * 背景宽）。
        :rtype: float
        """
        return self._LocationX

    @LocationX.setter
    def LocationX(self, LocationX):
        self._LocationX = LocationX

    @property
    def LocationY(self):
        """输入在输出画面的Y偏移。取值范围：
像素：[0，2000]
百分比：[0.01，0.99]
不填默认为0。
相对于大主播背景画面左上角的纵向偏移。 
使用百分比时，期望输出为（百分比 * 背景宽）
        :rtype: float
        """
        return self._LocationY

    @LocationY.setter
    def LocationY(self, LocationY):
        self._LocationY = LocationY

    @property
    def Color(self):
        """当InputType为3(画布)时，该值表示画布的颜色。
常用的颜色有：
红色：0xCC0033。
黄色：0xCC9900。
绿色：0xCCCC33。
蓝色：0x99CCFF。
黑色：0x000000。
白色：0xFFFFFF。
灰色：0x999999。
        :rtype: str
        """
        return self._Color

    @Color.setter
    def Color(self, Color):
        self._Color = Color

    @property
    def WatermarkId(self):
        """当InputType为2(图片)时，该值是水印ID。
        :rtype: int
        """
        return self._WatermarkId

    @WatermarkId.setter
    def WatermarkId(self, WatermarkId):
        self._WatermarkId = WatermarkId


    def _deserialize(self, params):
        self._ImageLayer = params.get("ImageLayer")
        self._InputType = params.get("InputType")
        self._ImageHeight = params.get("ImageHeight")
        self._ImageWidth = params.get("ImageWidth")
        self._LocationX = params.get("LocationX")
        self._LocationY = params.get("LocationY")
        self._Color = params.get("Color")
        self._WatermarkId = params.get("WatermarkId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CommonMixOutputParams(AbstractModel):
    """通用混流输出参数。

    """

    def __init__(self):
        r"""
        :param _OutputStreamName: 输出流名称。
        :type OutputStreamName: str
        :param _OutputStreamType: 输出流类型，取值范围[0,1]。
不填默认为0。
当输出流为输入流 list 中的一条时，填写0。
当期望生成的混流结果成为一条新流时，该值填为1。
该值为1时，output_stream_id 不能出现在 input_stram_list 中，且直播后台中，不能存在相同 ID 的流。
        :type OutputStreamType: int
        :param _OutputStreamBitRate: 输出流比特率。取值范围[1，10000]。
不填的情况下，系统会自动判断。
        :type OutputStreamBitRate: int
        :param _OutputStreamGop: 输出流GOP大小。取值范围[1,10]。
不填的情况下，系统会自动判断。
        :type OutputStreamGop: int
        :param _OutputStreamFrameRate: 输出流帧率大小。取值范围[1,60]。
不填的情况下，系统会自动判断。
        :type OutputStreamFrameRate: int
        :param _OutputAudioBitRate: 输出流音频比特率。取值范围[1,500]
不填的情况下，系统会自动判断。
        :type OutputAudioBitRate: int
        :param _OutputAudioSampleRate: 输出流音频采样率。取值范围[96000, 88200, 64000, 48000, 44100, 32000,24000, 22050, 16000, 12000, 11025, 8000]。
不填的情况下，系统会自动判断。
        :type OutputAudioSampleRate: int
        :param _OutputAudioChannels: 输出流音频声道数。取值范围[1,2]。
不填的情况下，系统会自动判断。
        :type OutputAudioChannels: int
        :param _MixSei: 输出流中的sei信息。如果无特殊需要，不填。
        :type MixSei: str
        """
        self._OutputStreamName = None
        self._OutputStreamType = None
        self._OutputStreamBitRate = None
        self._OutputStreamGop = None
        self._OutputStreamFrameRate = None
        self._OutputAudioBitRate = None
        self._OutputAudioSampleRate = None
        self._OutputAudioChannels = None
        self._MixSei = None

    @property
    def OutputStreamName(self):
        """输出流名称。
        :rtype: str
        """
        return self._OutputStreamName

    @OutputStreamName.setter
    def OutputStreamName(self, OutputStreamName):
        self._OutputStreamName = OutputStreamName

    @property
    def OutputStreamType(self):
        """输出流类型，取值范围[0,1]。
不填默认为0。
当输出流为输入流 list 中的一条时，填写0。
当期望生成的混流结果成为一条新流时，该值填为1。
该值为1时，output_stream_id 不能出现在 input_stram_list 中，且直播后台中，不能存在相同 ID 的流。
        :rtype: int
        """
        return self._OutputStreamType

    @OutputStreamType.setter
    def OutputStreamType(self, OutputStreamType):
        self._OutputStreamType = OutputStreamType

    @property
    def OutputStreamBitRate(self):
        """输出流比特率。取值范围[1，10000]。
不填的情况下，系统会自动判断。
        :rtype: int
        """
        return self._OutputStreamBitRate

    @OutputStreamBitRate.setter
    def OutputStreamBitRate(self, OutputStreamBitRate):
        self._OutputStreamBitRate = OutputStreamBitRate

    @property
    def OutputStreamGop(self):
        """输出流GOP大小。取值范围[1,10]。
不填的情况下，系统会自动判断。
        :rtype: int
        """
        return self._OutputStreamGop

    @OutputStreamGop.setter
    def OutputStreamGop(self, OutputStreamGop):
        self._OutputStreamGop = OutputStreamGop

    @property
    def OutputStreamFrameRate(self):
        """输出流帧率大小。取值范围[1,60]。
不填的情况下，系统会自动判断。
        :rtype: int
        """
        return self._OutputStreamFrameRate

    @OutputStreamFrameRate.setter
    def OutputStreamFrameRate(self, OutputStreamFrameRate):
        self._OutputStreamFrameRate = OutputStreamFrameRate

    @property
    def OutputAudioBitRate(self):
        """输出流音频比特率。取值范围[1,500]
不填的情况下，系统会自动判断。
        :rtype: int
        """
        return self._OutputAudioBitRate

    @OutputAudioBitRate.setter
    def OutputAudioBitRate(self, OutputAudioBitRate):
        self._OutputAudioBitRate = OutputAudioBitRate

    @property
    def OutputAudioSampleRate(self):
        """输出流音频采样率。取值范围[96000, 88200, 64000, 48000, 44100, 32000,24000, 22050, 16000, 12000, 11025, 8000]。
不填的情况下，系统会自动判断。
        :rtype: int
        """
        return self._OutputAudioSampleRate

    @OutputAudioSampleRate.setter
    def OutputAudioSampleRate(self, OutputAudioSampleRate):
        self._OutputAudioSampleRate = OutputAudioSampleRate

    @property
    def OutputAudioChannels(self):
        """输出流音频声道数。取值范围[1,2]。
不填的情况下，系统会自动判断。
        :rtype: int
        """
        return self._OutputAudioChannels

    @OutputAudioChannels.setter
    def OutputAudioChannels(self, OutputAudioChannels):
        self._OutputAudioChannels = OutputAudioChannels

    @property
    def MixSei(self):
        """输出流中的sei信息。如果无特殊需要，不填。
        :rtype: str
        """
        return self._MixSei

    @MixSei.setter
    def MixSei(self, MixSei):
        self._MixSei = MixSei


    def _deserialize(self, params):
        self._OutputStreamName = params.get("OutputStreamName")
        self._OutputStreamType = params.get("OutputStreamType")
        self._OutputStreamBitRate = params.get("OutputStreamBitRate")
        self._OutputStreamGop = params.get("OutputStreamGop")
        self._OutputStreamFrameRate = params.get("OutputStreamFrameRate")
        self._OutputAudioBitRate = params.get("OutputAudioBitRate")
        self._OutputAudioSampleRate = params.get("OutputAudioSampleRate")
        self._OutputAudioChannels = params.get("OutputAudioChannels")
        self._MixSei = params.get("MixSei")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ConcurrentRecordStreamNum(AbstractModel):
    """并发录制路数

    """

    def __init__(self):
        r"""
        :param _Time: 时间点。
        :type Time: str
        :param _Num: 路数。
        :type Num: int
        """
        self._Time = None
        self._Num = None

    @property
    def Time(self):
        """时间点。
        :rtype: str
        """
        return self._Time

    @Time.setter
    def Time(self, Time):
        self._Time = Time

    @property
    def Num(self):
        """路数。
        :rtype: int
        """
        return self._Num

    @Num.setter
    def Num(self, Num):
        self._Num = Num


    def _deserialize(self, params):
        self._Time = params.get("Time")
        self._Num = params.get("Num")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CopyCasterRequest(AbstractModel):
    """CopyCaster请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CasterId: 源导播台的ID
        :type CasterId: int
        :param _CasterName: 复制产生的新导播台名称
        :type CasterName: str
        :param _OutputStreamId: 复制产生的导播台推送到云直播的流id
注意：该流id不能与云直播中的流id重复
        :type OutputStreamId: str
        """
        self._CasterId = None
        self._CasterName = None
        self._OutputStreamId = None

    @property
    def CasterId(self):
        """源导播台的ID
        :rtype: int
        """
        return self._CasterId

    @CasterId.setter
    def CasterId(self, CasterId):
        self._CasterId = CasterId

    @property
    def CasterName(self):
        """复制产生的新导播台名称
        :rtype: str
        """
        return self._CasterName

    @CasterName.setter
    def CasterName(self, CasterName):
        self._CasterName = CasterName

    @property
    def OutputStreamId(self):
        """复制产生的导播台推送到云直播的流id
注意：该流id不能与云直播中的流id重复
        :rtype: str
        """
        return self._OutputStreamId

    @OutputStreamId.setter
    def OutputStreamId(self, OutputStreamId):
        self._OutputStreamId = OutputStreamId


    def _deserialize(self, params):
        self._CasterId = params.get("CasterId")
        self._CasterName = params.get("CasterName")
        self._OutputStreamId = params.get("OutputStreamId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CopyCasterResponse(AbstractModel):
    """CopyCaster返回参数结构体

    """

    def __init__(self):
        r"""
        :param _CasterId: 复制生成的导播台ID
        :type CasterId: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._CasterId = None
        self._RequestId = None

    @property
    def CasterId(self):
        """复制生成的导播台ID
        :rtype: int
        """
        return self._CasterId

    @CasterId.setter
    def CasterId(self, CasterId):
        self._CasterId = CasterId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._CasterId = params.get("CasterId")
        self._RequestId = params.get("RequestId")


class CreateCasterInputPushUrlRequest(AbstractModel):
    """CreateCasterInputPushUrl请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CasterId: 导播台ID
        :type CasterId: int
        :param _InputIndex: 请求生成推流地址的输入Index。
允许范围[1,24]。
        :type InputIndex: int
        :param _Protocol: 生成推流地址协议。
范围[rtmp,webrtc]。
注：获取webrtc推流地址时，需配合腾讯云快直播推流sdk才可成功推流。
        :type Protocol: str
        """
        self._CasterId = None
        self._InputIndex = None
        self._Protocol = None

    @property
    def CasterId(self):
        """导播台ID
        :rtype: int
        """
        return self._CasterId

    @CasterId.setter
    def CasterId(self, CasterId):
        self._CasterId = CasterId

    @property
    def InputIndex(self):
        """请求生成推流地址的输入Index。
允许范围[1,24]。
        :rtype: int
        """
        return self._InputIndex

    @InputIndex.setter
    def InputIndex(self, InputIndex):
        self._InputIndex = InputIndex

    @property
    def Protocol(self):
        """生成推流地址协议。
范围[rtmp,webrtc]。
注：获取webrtc推流地址时，需配合腾讯云快直播推流sdk才可成功推流。
        :rtype: str
        """
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol


    def _deserialize(self, params):
        self._CasterId = params.get("CasterId")
        self._InputIndex = params.get("InputIndex")
        self._Protocol = params.get("Protocol")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateCasterInputPushUrlResponse(AbstractModel):
    """CreateCasterInputPushUrl返回参数结构体

    """

    def __init__(self):
        r"""
        :param _PushUrl: 生成可使用的推流地址。
        :type PushUrl: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._PushUrl = None
        self._RequestId = None

    @property
    def PushUrl(self):
        """生成可使用的推流地址。
        :rtype: str
        """
        return self._PushUrl

    @PushUrl.setter
    def PushUrl(self, PushUrl):
        self._PushUrl = PushUrl

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._PushUrl = params.get("PushUrl")
        self._RequestId = params.get("RequestId")


class CreateCasterPgmFromPvwRequest(AbstractModel):
    """CreateCasterPgmFromPvw请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CasterId: 导播台ID。
        :type CasterId: int
        """
        self._CasterId = None

    @property
    def CasterId(self):
        """导播台ID。
        :rtype: int
        """
        return self._CasterId

    @CasterId.setter
    def CasterId(self, CasterId):
        self._CasterId = CasterId


    def _deserialize(self, params):
        self._CasterId = params.get("CasterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateCasterPgmFromPvwResponse(AbstractModel):
    """CreateCasterPgmFromPvw返回参数结构体

    """

    def __init__(self):
        r"""
        :param _PgmPlayUrl: 主监任务的rtmp协议预览地址。 
注：该地址仅供预览，不可分发。
        :type PgmPlayUrl: str
        :param _CdnPlayUrl: 注：该字段已废弃，请结合腾讯云直播播放地址生成策略生成cdn播放地址
        :type CdnPlayUrl: str
        :param _CdnStreamId: 主监任务在腾讯云直播侧的流ID。
        :type CdnStreamId: str
        :param _PgmWebRTCPlayUrl: 主监任务的webrtc协议播放地址。 
注：
1.该预览地址仅作为预览，不可分发。
2.webrtc播放地址需配合腾讯云快直播播放sdk使用。
        :type PgmWebRTCPlayUrl: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._PgmPlayUrl = None
        self._CdnPlayUrl = None
        self._CdnStreamId = None
        self._PgmWebRTCPlayUrl = None
        self._RequestId = None

    @property
    def PgmPlayUrl(self):
        """主监任务的rtmp协议预览地址。 
注：该地址仅供预览，不可分发。
        :rtype: str
        """
        return self._PgmPlayUrl

    @PgmPlayUrl.setter
    def PgmPlayUrl(self, PgmPlayUrl):
        self._PgmPlayUrl = PgmPlayUrl

    @property
    def CdnPlayUrl(self):
        """注：该字段已废弃，请结合腾讯云直播播放地址生成策略生成cdn播放地址
        :rtype: str
        """
        return self._CdnPlayUrl

    @CdnPlayUrl.setter
    def CdnPlayUrl(self, CdnPlayUrl):
        self._CdnPlayUrl = CdnPlayUrl

    @property
    def CdnStreamId(self):
        """主监任务在腾讯云直播侧的流ID。
        :rtype: str
        """
        return self._CdnStreamId

    @CdnStreamId.setter
    def CdnStreamId(self, CdnStreamId):
        self._CdnStreamId = CdnStreamId

    @property
    def PgmWebRTCPlayUrl(self):
        """主监任务的webrtc协议播放地址。 
注：
1.该预览地址仅作为预览，不可分发。
2.webrtc播放地址需配合腾讯云快直播播放sdk使用。
        :rtype: str
        """
        return self._PgmWebRTCPlayUrl

    @PgmWebRTCPlayUrl.setter
    def PgmWebRTCPlayUrl(self, PgmWebRTCPlayUrl):
        self._PgmWebRTCPlayUrl = PgmWebRTCPlayUrl

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._PgmPlayUrl = params.get("PgmPlayUrl")
        self._CdnPlayUrl = params.get("CdnPlayUrl")
        self._CdnStreamId = params.get("CdnStreamId")
        self._PgmWebRTCPlayUrl = params.get("PgmWebRTCPlayUrl")
        self._RequestId = params.get("RequestId")


class CreateCasterPgmRequest(AbstractModel):
    """CreateCasterPgm请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PgmDisplayInfo: 导播台展示信息参数。
        :type PgmDisplayInfo: :class:`tencentcloud.live.v20180801.models.CasterDisplayInfo`
        :param _CasterId: 导播台ID。
        :type CasterId: int
        """
        self._PgmDisplayInfo = None
        self._CasterId = None

    @property
    def PgmDisplayInfo(self):
        """导播台展示信息参数。
        :rtype: :class:`tencentcloud.live.v20180801.models.CasterDisplayInfo`
        """
        return self._PgmDisplayInfo

    @PgmDisplayInfo.setter
    def PgmDisplayInfo(self, PgmDisplayInfo):
        self._PgmDisplayInfo = PgmDisplayInfo

    @property
    def CasterId(self):
        """导播台ID。
        :rtype: int
        """
        return self._CasterId

    @CasterId.setter
    def CasterId(self, CasterId):
        self._CasterId = CasterId


    def _deserialize(self, params):
        if params.get("PgmDisplayInfo") is not None:
            self._PgmDisplayInfo = CasterDisplayInfo()
            self._PgmDisplayInfo._deserialize(params.get("PgmDisplayInfo"))
        self._CasterId = params.get("CasterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateCasterPgmResponse(AbstractModel):
    """CreateCasterPgm返回参数结构体

    """

    def __init__(self):
        r"""
        :param _PgmPlayUrl: 主监任务的rtmp协议预览地址。
注：该地址仅供预览，不可分发。
        :type PgmPlayUrl: str
        :param _CdnPlayUrl: 注：该字段已废弃，请结合腾讯云直播播放地址生成策略生成cdn播放地址。
        :type CdnPlayUrl: str
        :param _CdnStreamId: 主监任务在腾讯云直播侧的流ID。
        :type CdnStreamId: str
        :param _PgmWebRTCPlayUrl: 主监任务的webrtc协议播放地址。
注：
1. 该预览地址仅作为预览，不可分发。
2. webrtc播放地址需配合腾讯云快直播播放sdk使用。
        :type PgmWebRTCPlayUrl: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._PgmPlayUrl = None
        self._CdnPlayUrl = None
        self._CdnStreamId = None
        self._PgmWebRTCPlayUrl = None
        self._RequestId = None

    @property
    def PgmPlayUrl(self):
        """主监任务的rtmp协议预览地址。
注：该地址仅供预览，不可分发。
        :rtype: str
        """
        return self._PgmPlayUrl

    @PgmPlayUrl.setter
    def PgmPlayUrl(self, PgmPlayUrl):
        self._PgmPlayUrl = PgmPlayUrl

    @property
    def CdnPlayUrl(self):
        """注：该字段已废弃，请结合腾讯云直播播放地址生成策略生成cdn播放地址。
        :rtype: str
        """
        return self._CdnPlayUrl

    @CdnPlayUrl.setter
    def CdnPlayUrl(self, CdnPlayUrl):
        self._CdnPlayUrl = CdnPlayUrl

    @property
    def CdnStreamId(self):
        """主监任务在腾讯云直播侧的流ID。
        :rtype: str
        """
        return self._CdnStreamId

    @CdnStreamId.setter
    def CdnStreamId(self, CdnStreamId):
        self._CdnStreamId = CdnStreamId

    @property
    def PgmWebRTCPlayUrl(self):
        """主监任务的webrtc协议播放地址。
注：
1. 该预览地址仅作为预览，不可分发。
2. webrtc播放地址需配合腾讯云快直播播放sdk使用。
        :rtype: str
        """
        return self._PgmWebRTCPlayUrl

    @PgmWebRTCPlayUrl.setter
    def PgmWebRTCPlayUrl(self, PgmWebRTCPlayUrl):
        self._PgmWebRTCPlayUrl = PgmWebRTCPlayUrl

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._PgmPlayUrl = params.get("PgmPlayUrl")
        self._CdnPlayUrl = params.get("CdnPlayUrl")
        self._CdnStreamId = params.get("CdnStreamId")
        self._PgmWebRTCPlayUrl = params.get("PgmWebRTCPlayUrl")
        self._RequestId = params.get("RequestId")


class CreateCasterPvwRequest(AbstractModel):
    """CreateCasterPvw请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PvwDisplayInfo: 导播台预监展示信息参数
        :type PvwDisplayInfo: :class:`tencentcloud.live.v20180801.models.CasterDisplayInfo`
        :param _CasterId: 导播台ID。
        :type CasterId: int
        """
        self._PvwDisplayInfo = None
        self._CasterId = None

    @property
    def PvwDisplayInfo(self):
        """导播台预监展示信息参数
        :rtype: :class:`tencentcloud.live.v20180801.models.CasterDisplayInfo`
        """
        return self._PvwDisplayInfo

    @PvwDisplayInfo.setter
    def PvwDisplayInfo(self, PvwDisplayInfo):
        self._PvwDisplayInfo = PvwDisplayInfo

    @property
    def CasterId(self):
        """导播台ID。
        :rtype: int
        """
        return self._CasterId

    @CasterId.setter
    def CasterId(self, CasterId):
        self._CasterId = CasterId


    def _deserialize(self, params):
        if params.get("PvwDisplayInfo") is not None:
            self._PvwDisplayInfo = CasterDisplayInfo()
            self._PvwDisplayInfo._deserialize(params.get("PvwDisplayInfo"))
        self._CasterId = params.get("CasterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateCasterPvwResponse(AbstractModel):
    """CreateCasterPvw返回参数结构体

    """

    def __init__(self):
        r"""
        :param _PvwPlayUrl: 预监任务的画面rtmp协议预览地址。
注：该预览地址仅供画面预览，不可分发。
        :type PvwPlayUrl: str
        :param _PvwWebRTCPlayUrl: 预监任务的webrtc协议预览画面。
注：
1. 该预览地址仅供预览，不可分发。
2. webrtc播放地址，需配合腾讯云快直播播放sdk使用

        :type PvwWebRTCPlayUrl: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._PvwPlayUrl = None
        self._PvwWebRTCPlayUrl = None
        self._RequestId = None

    @property
    def PvwPlayUrl(self):
        """预监任务的画面rtmp协议预览地址。
注：该预览地址仅供画面预览，不可分发。
        :rtype: str
        """
        return self._PvwPlayUrl

    @PvwPlayUrl.setter
    def PvwPlayUrl(self, PvwPlayUrl):
        self._PvwPlayUrl = PvwPlayUrl

    @property
    def PvwWebRTCPlayUrl(self):
        """预监任务的webrtc协议预览画面。
注：
1. 该预览地址仅供预览，不可分发。
2. webrtc播放地址，需配合腾讯云快直播播放sdk使用

        :rtype: str
        """
        return self._PvwWebRTCPlayUrl

    @PvwWebRTCPlayUrl.setter
    def PvwWebRTCPlayUrl(self, PvwWebRTCPlayUrl):
        self._PvwWebRTCPlayUrl = PvwWebRTCPlayUrl

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._PvwPlayUrl = params.get("PvwPlayUrl")
        self._PvwWebRTCPlayUrl = params.get("PvwWebRTCPlayUrl")
        self._RequestId = params.get("RequestId")


class CreateCasterRequest(AbstractModel):
    """CreateCaster请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CasterName: 导播台名称
        :type CasterName: str
        :param _Description: 导播台的描述
最大允许长度256
        :type Description: str
        :param _ExpireTime: 导播台的过期时间戳。值为-1或unix时间戳。
默认值为-1。
当值为-1时，表示该导播台永不过期。
当值为正常unix时间戳时，导播台将在该时间过期。
导播台过期后，预监与主监画面将自动停止，转推自动停止。
点播、直播url将停止转拉，推流url需自行停止推流。
        :type ExpireTime: int
        :param _DelayTime: 导播台延时播放时间，单位为秒。
默认为0，最大支持300秒
        :type DelayTime: int
        :param _TransitionType: 导播台转场类型。
默认为空。
允许使用通过DescribeCasterTransitionTypes接口中查询到的转场类型。
        :type TransitionType: str
        :param _PgmWidth: 导播台主监输出的宽度，单位为像素。
默认为1280，最大允许4096。
        :type PgmWidth: int
        :param _PgmHeight: 导播台主监输出的高度，单位为像素。
默认为720，最大允许2160。
        :type PgmHeight: int
        :param _PgmFps: 导播台主监输出的帧率。
默认为0，表示随源输出。
最大支持60。
        :type PgmFps: int
        :param _PgmBitRate: 导播台主监输出的码率，单位为kbps。
默认为0，表示随源的码率输出。
最大允许10000kbps。
        :type PgmBitRate: int
        :param _FeeType: 导播台的计费类型。
0 通用型 
1 播单型。
注： 本参数暂无作用。
        :type FeeType: int
        :param _PgmAudioBitRate: 导播台主监输出的音频码率，单位为kbps。
可选项：[0, 128, 192, 256]
默认值为0，表示随源的音频码率输出。
        :type PgmAudioBitRate: int
        """
        self._CasterName = None
        self._Description = None
        self._ExpireTime = None
        self._DelayTime = None
        self._TransitionType = None
        self._PgmWidth = None
        self._PgmHeight = None
        self._PgmFps = None
        self._PgmBitRate = None
        self._FeeType = None
        self._PgmAudioBitRate = None

    @property
    def CasterName(self):
        """导播台名称
        :rtype: str
        """
        return self._CasterName

    @CasterName.setter
    def CasterName(self, CasterName):
        self._CasterName = CasterName

    @property
    def Description(self):
        """导播台的描述
最大允许长度256
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def ExpireTime(self):
        """导播台的过期时间戳。值为-1或unix时间戳。
默认值为-1。
当值为-1时，表示该导播台永不过期。
当值为正常unix时间戳时，导播台将在该时间过期。
导播台过期后，预监与主监画面将自动停止，转推自动停止。
点播、直播url将停止转拉，推流url需自行停止推流。
        :rtype: int
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def DelayTime(self):
        """导播台延时播放时间，单位为秒。
默认为0，最大支持300秒
        :rtype: int
        """
        return self._DelayTime

    @DelayTime.setter
    def DelayTime(self, DelayTime):
        self._DelayTime = DelayTime

    @property
    def TransitionType(self):
        """导播台转场类型。
默认为空。
允许使用通过DescribeCasterTransitionTypes接口中查询到的转场类型。
        :rtype: str
        """
        return self._TransitionType

    @TransitionType.setter
    def TransitionType(self, TransitionType):
        self._TransitionType = TransitionType

    @property
    def PgmWidth(self):
        """导播台主监输出的宽度，单位为像素。
默认为1280，最大允许4096。
        :rtype: int
        """
        return self._PgmWidth

    @PgmWidth.setter
    def PgmWidth(self, PgmWidth):
        self._PgmWidth = PgmWidth

    @property
    def PgmHeight(self):
        """导播台主监输出的高度，单位为像素。
默认为720，最大允许2160。
        :rtype: int
        """
        return self._PgmHeight

    @PgmHeight.setter
    def PgmHeight(self, PgmHeight):
        self._PgmHeight = PgmHeight

    @property
    def PgmFps(self):
        """导播台主监输出的帧率。
默认为0，表示随源输出。
最大支持60。
        :rtype: int
        """
        return self._PgmFps

    @PgmFps.setter
    def PgmFps(self, PgmFps):
        self._PgmFps = PgmFps

    @property
    def PgmBitRate(self):
        """导播台主监输出的码率，单位为kbps。
默认为0，表示随源的码率输出。
最大允许10000kbps。
        :rtype: int
        """
        return self._PgmBitRate

    @PgmBitRate.setter
    def PgmBitRate(self, PgmBitRate):
        self._PgmBitRate = PgmBitRate

    @property
    def FeeType(self):
        """导播台的计费类型。
0 通用型 
1 播单型。
注： 本参数暂无作用。
        :rtype: int
        """
        return self._FeeType

    @FeeType.setter
    def FeeType(self, FeeType):
        self._FeeType = FeeType

    @property
    def PgmAudioBitRate(self):
        """导播台主监输出的音频码率，单位为kbps。
可选项：[0, 128, 192, 256]
默认值为0，表示随源的音频码率输出。
        :rtype: int
        """
        return self._PgmAudioBitRate

    @PgmAudioBitRate.setter
    def PgmAudioBitRate(self, PgmAudioBitRate):
        self._PgmAudioBitRate = PgmAudioBitRate


    def _deserialize(self, params):
        self._CasterName = params.get("CasterName")
        self._Description = params.get("Description")
        self._ExpireTime = params.get("ExpireTime")
        self._DelayTime = params.get("DelayTime")
        self._TransitionType = params.get("TransitionType")
        self._PgmWidth = params.get("PgmWidth")
        self._PgmHeight = params.get("PgmHeight")
        self._PgmFps = params.get("PgmFps")
        self._PgmBitRate = params.get("PgmBitRate")
        self._FeeType = params.get("FeeType")
        self._PgmAudioBitRate = params.get("PgmAudioBitRate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateCasterResponse(AbstractModel):
    """CreateCaster返回参数结构体

    """

    def __init__(self):
        r"""
        :param _CasterId: 导播台ID
        :type CasterId: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._CasterId = None
        self._RequestId = None

    @property
    def CasterId(self):
        """导播台ID
        :rtype: int
        """
        return self._CasterId

    @CasterId.setter
    def CasterId(self, CasterId):
        self._CasterId = CasterId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._CasterId = params.get("CasterId")
        self._RequestId = params.get("RequestId")


class CreateCommonMixStreamRequest(AbstractModel):
    """CreateCommonMixStream请求参数结构体

    """

    def __init__(self):
        r"""
        :param _MixStreamSessionId: 混流会话（申请混流开始到取消混流结束）标识 ID。80字节以内，仅含字母、数字以及下划线的字符串。
        :type MixStreamSessionId: str
        :param _InputStreamList: 混流输入流列表。
        :type InputStreamList: list of CommonMixInputParam
        :param _OutputParams: 混流输出流参数。
        :type OutputParams: :class:`tencentcloud.live.v20180801.models.CommonMixOutputParams`
        :param _MixStreamTemplateId: 输入模板 ID，若设置该参数，将按默认模板布局输出，无需填入自定义位置参数。
不填默认为0。
两输入源支持10，20，30，40，50。
三输入源支持310，390，391。
四输入源支持410。
五输入源支持510，590。
六输入源支持610。
        :type MixStreamTemplateId: int
        :param _ControlParams: 混流的特殊控制参数。如无特殊需求，无需填写。
        :type ControlParams: :class:`tencentcloud.live.v20180801.models.CommonMixControlParams`
        """
        self._MixStreamSessionId = None
        self._InputStreamList = None
        self._OutputParams = None
        self._MixStreamTemplateId = None
        self._ControlParams = None

    @property
    def MixStreamSessionId(self):
        """混流会话（申请混流开始到取消混流结束）标识 ID。80字节以内，仅含字母、数字以及下划线的字符串。
        :rtype: str
        """
        return self._MixStreamSessionId

    @MixStreamSessionId.setter
    def MixStreamSessionId(self, MixStreamSessionId):
        self._MixStreamSessionId = MixStreamSessionId

    @property
    def InputStreamList(self):
        """混流输入流列表。
        :rtype: list of CommonMixInputParam
        """
        return self._InputStreamList

    @InputStreamList.setter
    def InputStreamList(self, InputStreamList):
        self._InputStreamList = InputStreamList

    @property
    def OutputParams(self):
        """混流输出流参数。
        :rtype: :class:`tencentcloud.live.v20180801.models.CommonMixOutputParams`
        """
        return self._OutputParams

    @OutputParams.setter
    def OutputParams(self, OutputParams):
        self._OutputParams = OutputParams

    @property
    def MixStreamTemplateId(self):
        """输入模板 ID，若设置该参数，将按默认模板布局输出，无需填入自定义位置参数。
不填默认为0。
两输入源支持10，20，30，40，50。
三输入源支持310，390，391。
四输入源支持410。
五输入源支持510，590。
六输入源支持610。
        :rtype: int
        """
        return self._MixStreamTemplateId

    @MixStreamTemplateId.setter
    def MixStreamTemplateId(self, MixStreamTemplateId):
        self._MixStreamTemplateId = MixStreamTemplateId

    @property
    def ControlParams(self):
        """混流的特殊控制参数。如无特殊需求，无需填写。
        :rtype: :class:`tencentcloud.live.v20180801.models.CommonMixControlParams`
        """
        return self._ControlParams

    @ControlParams.setter
    def ControlParams(self, ControlParams):
        self._ControlParams = ControlParams


    def _deserialize(self, params):
        self._MixStreamSessionId = params.get("MixStreamSessionId")
        if params.get("InputStreamList") is not None:
            self._InputStreamList = []
            for item in params.get("InputStreamList"):
                obj = CommonMixInputParam()
                obj._deserialize(item)
                self._InputStreamList.append(obj)
        if params.get("OutputParams") is not None:
            self._OutputParams = CommonMixOutputParams()
            self._OutputParams._deserialize(params.get("OutputParams"))
        self._MixStreamTemplateId = params.get("MixStreamTemplateId")
        if params.get("ControlParams") is not None:
            self._ControlParams = CommonMixControlParams()
            self._ControlParams._deserialize(params.get("ControlParams"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateCommonMixStreamResponse(AbstractModel):
    """CreateCommonMixStream返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateLiveCallbackRuleRequest(AbstractModel):
    """CreateLiveCallbackRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DomainName: 推流域名。
        :type DomainName: str
        :param _AppName: 推流路径，与推流和播放地址中的AppName保持一致，默认为live。
        :type AppName: str
        :param _TemplateId: 模板ID。
        :type TemplateId: int
        """
        self._DomainName = None
        self._AppName = None
        self._TemplateId = None

    @property
    def DomainName(self):
        """推流域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def AppName(self):
        """推流路径，与推流和播放地址中的AppName保持一致，默认为live。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def TemplateId(self):
        """模板ID。
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId


    def _deserialize(self, params):
        self._DomainName = params.get("DomainName")
        self._AppName = params.get("AppName")
        self._TemplateId = params.get("TemplateId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateLiveCallbackRuleResponse(AbstractModel):
    """CreateLiveCallbackRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateLiveCallbackTemplateRequest(AbstractModel):
    """CreateLiveCallbackTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TemplateName: 模板名称。
长度上限：255字节。
仅支持中文、英文、数字、_、-。
        :type TemplateName: str
        :param _Description: 描述信息。
长度上限：1024字节。
仅支持中文、英文、数字、_、-。
        :type Description: str
        :param _StreamBeginNotifyUrl: 开播回调 URL，
相关协议文档：[事件消息通知](/document/product/267/32744)。
        :type StreamBeginNotifyUrl: str
        :param _StreamEndNotifyUrl: 断流回调 URL，
相关协议文档：[事件消息通知](/document/product/267/32744)。
        :type StreamEndNotifyUrl: str
        :param _RecordNotifyUrl: 录制文件回调 URL，
相关协议文档：[事件消息通知](/document/product/267/32744)。
        :type RecordNotifyUrl: str
        :param _RecordStatusNotifyUrl: 录制状态回调 URL ，
相关协议文档：[事件消息通知](/document/product/267/32744)。
        :type RecordStatusNotifyUrl: str
        :param _SnapshotNotifyUrl: 截图回调 URL，
相关协议文档：[事件消息通知](/document/product/267/32744)。
        :type SnapshotNotifyUrl: str
        :param _PornCensorshipNotifyUrl: 鉴黄回调 URL ，
相关协议文档：[事件消息通知](/document/product/267/32741)。
        :type PornCensorshipNotifyUrl: str
        :param _CallbackKey: 回调 Key，回调 URL 公用，回调签名详见事件消息通知文档。
[事件消息通知](/document/product/267/32744)。
        :type CallbackKey: str
        :param _StreamMixNotifyUrl: 参数已弃用。
        :type StreamMixNotifyUrl: str
        :param _PushExceptionNotifyUrl: 推流异常回调 URL。
        :type PushExceptionNotifyUrl: str
        :param _AudioAuditNotifyUrl: 音频审核回调 URL。
        :type AudioAuditNotifyUrl: str
        :param _RecordExceptionNotifyUrl: 录制异常回调 URL。
        :type RecordExceptionNotifyUrl: str
        :param _RecordExceptionLevels: 录制异常回调级别，可选择：error、warning、info。
        :type RecordExceptionLevels: list of str
        """
        self._TemplateName = None
        self._Description = None
        self._StreamBeginNotifyUrl = None
        self._StreamEndNotifyUrl = None
        self._RecordNotifyUrl = None
        self._RecordStatusNotifyUrl = None
        self._SnapshotNotifyUrl = None
        self._PornCensorshipNotifyUrl = None
        self._CallbackKey = None
        self._StreamMixNotifyUrl = None
        self._PushExceptionNotifyUrl = None
        self._AudioAuditNotifyUrl = None
        self._RecordExceptionNotifyUrl = None
        self._RecordExceptionLevels = None

    @property
    def TemplateName(self):
        """模板名称。
长度上限：255字节。
仅支持中文、英文、数字、_、-。
        :rtype: str
        """
        return self._TemplateName

    @TemplateName.setter
    def TemplateName(self, TemplateName):
        self._TemplateName = TemplateName

    @property
    def Description(self):
        """描述信息。
长度上限：1024字节。
仅支持中文、英文、数字、_、-。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def StreamBeginNotifyUrl(self):
        """开播回调 URL，
相关协议文档：[事件消息通知](/document/product/267/32744)。
        :rtype: str
        """
        return self._StreamBeginNotifyUrl

    @StreamBeginNotifyUrl.setter
    def StreamBeginNotifyUrl(self, StreamBeginNotifyUrl):
        self._StreamBeginNotifyUrl = StreamBeginNotifyUrl

    @property
    def StreamEndNotifyUrl(self):
        """断流回调 URL，
相关协议文档：[事件消息通知](/document/product/267/32744)。
        :rtype: str
        """
        return self._StreamEndNotifyUrl

    @StreamEndNotifyUrl.setter
    def StreamEndNotifyUrl(self, StreamEndNotifyUrl):
        self._StreamEndNotifyUrl = StreamEndNotifyUrl

    @property
    def RecordNotifyUrl(self):
        """录制文件回调 URL，
相关协议文档：[事件消息通知](/document/product/267/32744)。
        :rtype: str
        """
        return self._RecordNotifyUrl

    @RecordNotifyUrl.setter
    def RecordNotifyUrl(self, RecordNotifyUrl):
        self._RecordNotifyUrl = RecordNotifyUrl

    @property
    def RecordStatusNotifyUrl(self):
        """录制状态回调 URL ，
相关协议文档：[事件消息通知](/document/product/267/32744)。
        :rtype: str
        """
        return self._RecordStatusNotifyUrl

    @RecordStatusNotifyUrl.setter
    def RecordStatusNotifyUrl(self, RecordStatusNotifyUrl):
        self._RecordStatusNotifyUrl = RecordStatusNotifyUrl

    @property
    def SnapshotNotifyUrl(self):
        """截图回调 URL，
相关协议文档：[事件消息通知](/document/product/267/32744)。
        :rtype: str
        """
        return self._SnapshotNotifyUrl

    @SnapshotNotifyUrl.setter
    def SnapshotNotifyUrl(self, SnapshotNotifyUrl):
        self._SnapshotNotifyUrl = SnapshotNotifyUrl

    @property
    def PornCensorshipNotifyUrl(self):
        """鉴黄回调 URL ，
相关协议文档：[事件消息通知](/document/product/267/32741)。
        :rtype: str
        """
        return self._PornCensorshipNotifyUrl

    @PornCensorshipNotifyUrl.setter
    def PornCensorshipNotifyUrl(self, PornCensorshipNotifyUrl):
        self._PornCensorshipNotifyUrl = PornCensorshipNotifyUrl

    @property
    def CallbackKey(self):
        """回调 Key，回调 URL 公用，回调签名详见事件消息通知文档。
[事件消息通知](/document/product/267/32744)。
        :rtype: str
        """
        return self._CallbackKey

    @CallbackKey.setter
    def CallbackKey(self, CallbackKey):
        self._CallbackKey = CallbackKey

    @property
    def StreamMixNotifyUrl(self):
        """参数已弃用。
        :rtype: str
        """
        return self._StreamMixNotifyUrl

    @StreamMixNotifyUrl.setter
    def StreamMixNotifyUrl(self, StreamMixNotifyUrl):
        self._StreamMixNotifyUrl = StreamMixNotifyUrl

    @property
    def PushExceptionNotifyUrl(self):
        """推流异常回调 URL。
        :rtype: str
        """
        return self._PushExceptionNotifyUrl

    @PushExceptionNotifyUrl.setter
    def PushExceptionNotifyUrl(self, PushExceptionNotifyUrl):
        self._PushExceptionNotifyUrl = PushExceptionNotifyUrl

    @property
    def AudioAuditNotifyUrl(self):
        """音频审核回调 URL。
        :rtype: str
        """
        return self._AudioAuditNotifyUrl

    @AudioAuditNotifyUrl.setter
    def AudioAuditNotifyUrl(self, AudioAuditNotifyUrl):
        self._AudioAuditNotifyUrl = AudioAuditNotifyUrl

    @property
    def RecordExceptionNotifyUrl(self):
        """录制异常回调 URL。
        :rtype: str
        """
        return self._RecordExceptionNotifyUrl

    @RecordExceptionNotifyUrl.setter
    def RecordExceptionNotifyUrl(self, RecordExceptionNotifyUrl):
        self._RecordExceptionNotifyUrl = RecordExceptionNotifyUrl

    @property
    def RecordExceptionLevels(self):
        """录制异常回调级别，可选择：error、warning、info。
        :rtype: list of str
        """
        return self._RecordExceptionLevels

    @RecordExceptionLevels.setter
    def RecordExceptionLevels(self, RecordExceptionLevels):
        self._RecordExceptionLevels = RecordExceptionLevels


    def _deserialize(self, params):
        self._TemplateName = params.get("TemplateName")
        self._Description = params.get("Description")
        self._StreamBeginNotifyUrl = params.get("StreamBeginNotifyUrl")
        self._StreamEndNotifyUrl = params.get("StreamEndNotifyUrl")
        self._RecordNotifyUrl = params.get("RecordNotifyUrl")
        self._RecordStatusNotifyUrl = params.get("RecordStatusNotifyUrl")
        self._SnapshotNotifyUrl = params.get("SnapshotNotifyUrl")
        self._PornCensorshipNotifyUrl = params.get("PornCensorshipNotifyUrl")
        self._CallbackKey = params.get("CallbackKey")
        self._StreamMixNotifyUrl = params.get("StreamMixNotifyUrl")
        self._PushExceptionNotifyUrl = params.get("PushExceptionNotifyUrl")
        self._AudioAuditNotifyUrl = params.get("AudioAuditNotifyUrl")
        self._RecordExceptionNotifyUrl = params.get("RecordExceptionNotifyUrl")
        self._RecordExceptionLevels = params.get("RecordExceptionLevels")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateLiveCallbackTemplateResponse(AbstractModel):
    """CreateLiveCallbackTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TemplateId: 模板ID。
        :type TemplateId: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TemplateId = None
        self._RequestId = None

    @property
    def TemplateId(self):
        """模板ID。
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        self._RequestId = params.get("RequestId")


class CreateLivePadRuleRequest(AbstractModel):
    """CreateLivePadRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DomainName: 推流域名。
        :type DomainName: str
        :param _TemplateId: 模板 ID。
        :type TemplateId: int
        :param _AppName: 推流路径，与推流和播放地址中的AppName保持一致，默认为 live。
        :type AppName: str
        :param _StreamName: 流名称。
注：如果本参数设置为非空字符串，规则将只对此推流起作用。
        :type StreamName: str
        """
        self._DomainName = None
        self._TemplateId = None
        self._AppName = None
        self._StreamName = None

    @property
    def DomainName(self):
        """推流域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def TemplateId(self):
        """模板 ID。
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId

    @property
    def AppName(self):
        """推流路径，与推流和播放地址中的AppName保持一致，默认为 live。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def StreamName(self):
        """流名称。
注：如果本参数设置为非空字符串，规则将只对此推流起作用。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName


    def _deserialize(self, params):
        self._DomainName = params.get("DomainName")
        self._TemplateId = params.get("TemplateId")
        self._AppName = params.get("AppName")
        self._StreamName = params.get("StreamName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateLivePadRuleResponse(AbstractModel):
    """CreateLivePadRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateLivePadTemplateRequest(AbstractModel):
    """CreateLivePadTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TemplateName: 模板名称。
长度上限：255字节。
仅支持中文、英文、数字、_、-。
        :type TemplateName: str
        :param _Url: 垫片内容。
        :type Url: str
        :param _Description: 描述信息。
长度上限：1024字节。
仅支持中文、英文、数字、_、-。
        :type Description: str
        :param _WaitDuration: 断流等待时间。
取值范围：0-30000。
单位：ms。
        :type WaitDuration: int
        :param _MaxDuration: 最大垫片时长。
取值范围：0 - 正无穷。
单位：ms。
        :type MaxDuration: int
        :param _Type: 垫片内容类型：
1：图片，2：视频。
默认值：1。
        :type Type: int
        """
        self._TemplateName = None
        self._Url = None
        self._Description = None
        self._WaitDuration = None
        self._MaxDuration = None
        self._Type = None

    @property
    def TemplateName(self):
        """模板名称。
长度上限：255字节。
仅支持中文、英文、数字、_、-。
        :rtype: str
        """
        return self._TemplateName

    @TemplateName.setter
    def TemplateName(self, TemplateName):
        self._TemplateName = TemplateName

    @property
    def Url(self):
        """垫片内容。
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def Description(self):
        """描述信息。
长度上限：1024字节。
仅支持中文、英文、数字、_、-。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def WaitDuration(self):
        """断流等待时间。
取值范围：0-30000。
单位：ms。
        :rtype: int
        """
        return self._WaitDuration

    @WaitDuration.setter
    def WaitDuration(self, WaitDuration):
        self._WaitDuration = WaitDuration

    @property
    def MaxDuration(self):
        """最大垫片时长。
取值范围：0 - 正无穷。
单位：ms。
        :rtype: int
        """
        return self._MaxDuration

    @MaxDuration.setter
    def MaxDuration(self, MaxDuration):
        self._MaxDuration = MaxDuration

    @property
    def Type(self):
        """垫片内容类型：
1：图片，2：视频。
默认值：1。
        :rtype: int
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._TemplateName = params.get("TemplateName")
        self._Url = params.get("Url")
        self._Description = params.get("Description")
        self._WaitDuration = params.get("WaitDuration")
        self._MaxDuration = params.get("MaxDuration")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateLivePadTemplateResponse(AbstractModel):
    """CreateLivePadTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TemplateId: 模板Id。
        :type TemplateId: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TemplateId = None
        self._RequestId = None

    @property
    def TemplateId(self):
        """模板Id。
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        self._RequestId = params.get("RequestId")


class CreateLivePullStreamTaskRequest(AbstractModel):
    """CreateLivePullStreamTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SourceType: 拉流源的类型：
PullLivePushLive -直播，
PullVodPushLive -点播，
PullPicPushLive -图片。
        :type SourceType: str
        :param _SourceUrls: 拉流源 url 列表。
SourceType 为直播（PullLivePushLive）只可以填1个，
SourceType 为点播（PullVodPushLive）可以填多个，上限30个。
当前支持的文件格式：flv，mp4，hls。
当前支持的拉流协议：http，https，rtmp，rtmps，rtsp，srt。
注意：
1. 建议优先使用 flv 文件，对于 mp4 未交织好的文件轮播推流易产生卡顿以及因为频繁拉取导致源产生大量源出口带宽成本，可通过点播转码进行重新交织后再轮播，或提前创建任务并开启本地模式。
2. 拒绝内网域名等攻击性拉流地址，如有使用，则做账号封禁处理。
3. 源文件请保持时间戳正常交织递增，避免因源文件异常影响推流及播放。
4. 视频编码格式仅支持: H264, H265。
5. 音频编码格式仅支持: AAC。
6. 点播源请使用小文件，尽量时长保持在1小时内，较大文件打开和续播耗时较久，耗时超过15秒会有无法正常转推风险。
7. 避免使用低频存储的文件，该类文件因低频存储，拉取时容易出现慢速，影响拉转推质量。
        :type SourceUrls: list of str
        :param _DomainName: 推流域名。
将拉取过来的流推到该域名。
注意：如果目标地址为非云直播，且样式不同于云直播，请使用 ToUrl 传入完整推流地址，详细用法请参考 ToUrl 参数说明。
        :type DomainName: str
        :param _AppName: 推流路径。
将拉取过来的流推到该路径。
        :type AppName: str
        :param _StreamName: 推流名称。
将拉取过来的流推到该流名称。
        :type StreamName: str
        :param _StartTime: 开始时间。
使用 UTC 格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时。
        :type StartTime: str
        :param _EndTime: 结束时间，注意：1. 结束时间必须大于开始时间；2. 结束时间必须大于当前时间；3. 结束时间 和 开始时间 间隔必须小于30天。使用 UTC 格式时间，例如：2019-01-08T10:00:00Z。注意：北京时间值为 UTC 时间值 + 8 小时。
        :type EndTime: str
        :param _Operator: 任务操作人备注。
        :type Operator: str
        :param _PushArgs: 推流参数。
推流时携带自定义参数。
示例：
bak=1&test=2 。
        :type PushArgs: str
        :param _CallbackEvents: 选择需要回调的事件（不填则回调全部）：
TaskStart：任务启动回调，
TaskExit：任务停止回调，
VodSourceFileStart：从点播源文件开始拉流回调，
VodSourceFileFinish：从点播源文件拉流结束回调，
ResetTaskConfig：任务更新回调。

TaskAlarm: 用于告警事件通知，AlarmType 示例:
PullFileUnstable - 文件拉取不稳定，
PushStreamUnstable - 推流不稳定，
PullFileFailed - 文件拉取出错，
PushStreamFailed - 推流出现失败，
FileEndEarly - 文件提前结束。
        :type CallbackEvents: list of str
        :param _VodLoopTimes: 点播拉流转推循环次数。默认：-1。
-1：无限循环，直到任务结束。
0：不循环。
>0：具体循环次数。次数和时间以先结束的为准。
注意：该配置仅对拉流源为点播时生效。
        :type VodLoopTimes: str
        :param _VodRefreshType: 点播更新SourceUrls后的播放方式：
ImmediateNewSource：立即播放新的拉流源内容；
ContinueBreakPoint：播放完当前正在播放的点播 url 后再使用新的拉流源播放。（旧拉流源未播放的点播 url 不会再播放）

注意：该配置生效仅对变更前拉流源为点播时生效。
        :type VodRefreshType: str
        :param _CallbackUrl: 自定义回调地址。
拉流转推任务相关事件会回调到该地址。
回调事件使用方法请查看：
https://cloud.tencent.com/document/product/267/32744
https://cloud.tencent.com/document/product/267/56208
        :type CallbackUrl: str
        :param _ExtraCmd: 其他参数。
示例: ignore_region  用于忽略传入地域, 内部按负载分配。
        :type ExtraCmd: str
        :param _SpecifyTaskId: 自定义任务 ID。
注：
1. 该自定义 ID 为可选参数，如果传入，请确保该账号下传入的 ID 唯一。
2. 该自定义 ID 用于防止重复发起请求时产生重复任务。后面也可以用 SpecifyTaskId 来修改或删除任务。
        :type SpecifyTaskId: str
        :param _Comment: 任务描述，限制 512 字节。
        :type Comment: str
        :param _ToUrl: 完整目标 URL 地址。
用法注意：如果使用该参数来传完整目标地址，则 DomainName, AppName, StreamName 需要传入空字符串，任务将会使用该 ToUrl 参数指定的目标地址。

使用该方式传入目标地址支持的协议有：
rtmp、rtmps、rtsp、rtp、srt。

注意：签名时间需要超过任务结束时间，避免因签名过期造成任务失败。
        :type ToUrl: str
        :param _FileIndex: 指定播放文件索引。
注意： 1. 从1开始，不大于SourceUrls中文件个数。
2. 该偏移仅在首次轮播时有效。
3. 提前创建的任务指定的偏移最长有效期为24小时，24小时后未开始的任务偏移失效。
        :type FileIndex: int
        :param _OffsetTime: 指定播放文件偏移。
注意：
1. 单位：秒，配合FileIndex使用。
        :type OffsetTime: int
        :param _BackupSourceType: 备源的类型：
PullLivePushLive -直播，
PullVodPushLive -点播。
注意：
1. 仅当主源类型为直播源时，备源才会生效。
2. 主直播源拉流中断时，自动使用备源进行拉流。
3. 如果备源为点播文件时，则每次轮播完点播文件就检查主源是否恢复，如果主源恢复则自动切回到主源，否则继续拉备源。
        :type BackupSourceType: str
        :param _BackupSourceUrl: 备源 URL。
只允许填一个备源 URL
        :type BackupSourceUrl: str
        :param _WatermarkList: 水印信息列表。
注意：
1. 最多支持4个不同位置的水印。
2. 水印图片 URL 请使用合法外网可访问地址。
3. 支持的水印图片格式：png，jpg，gif 等。
        :type WatermarkList: list of PullPushWatermarkInfo
        :param _VodLocalMode: 点播源是否启用本地推流模式，默认0，不启用。
0 - 不启用。
1 - 启用。
注意：启用本地模式后，会将源列表中的 MP4 文件进行本地下载，优先使用本地已下载文件进行推流，提高点播源推流稳定性。使用本地下载文件推流时，会产生增值费用。
        :type VodLocalMode: int
        :param _RecordTemplateId: 录制模板 ID。
        :type RecordTemplateId: str
        :param _BackupToUrl: 新的目标地址，用于任务同时推两路场景。
        :type BackupToUrl: str
        :param _TranscodeTemplateName: 直播转码模板，使用云直播的转码功能进行转码后再转推出去。转码模板需在云直播控制台创建。
        :type TranscodeTemplateName: str
        """
        self._SourceType = None
        self._SourceUrls = None
        self._DomainName = None
        self._AppName = None
        self._StreamName = None
        self._StartTime = None
        self._EndTime = None
        self._Operator = None
        self._PushArgs = None
        self._CallbackEvents = None
        self._VodLoopTimes = None
        self._VodRefreshType = None
        self._CallbackUrl = None
        self._ExtraCmd = None
        self._SpecifyTaskId = None
        self._Comment = None
        self._ToUrl = None
        self._FileIndex = None
        self._OffsetTime = None
        self._BackupSourceType = None
        self._BackupSourceUrl = None
        self._WatermarkList = None
        self._VodLocalMode = None
        self._RecordTemplateId = None
        self._BackupToUrl = None
        self._TranscodeTemplateName = None

    @property
    def SourceType(self):
        """拉流源的类型：
PullLivePushLive -直播，
PullVodPushLive -点播，
PullPicPushLive -图片。
        :rtype: str
        """
        return self._SourceType

    @SourceType.setter
    def SourceType(self, SourceType):
        self._SourceType = SourceType

    @property
    def SourceUrls(self):
        """拉流源 url 列表。
SourceType 为直播（PullLivePushLive）只可以填1个，
SourceType 为点播（PullVodPushLive）可以填多个，上限30个。
当前支持的文件格式：flv，mp4，hls。
当前支持的拉流协议：http，https，rtmp，rtmps，rtsp，srt。
注意：
1. 建议优先使用 flv 文件，对于 mp4 未交织好的文件轮播推流易产生卡顿以及因为频繁拉取导致源产生大量源出口带宽成本，可通过点播转码进行重新交织后再轮播，或提前创建任务并开启本地模式。
2. 拒绝内网域名等攻击性拉流地址，如有使用，则做账号封禁处理。
3. 源文件请保持时间戳正常交织递增，避免因源文件异常影响推流及播放。
4. 视频编码格式仅支持: H264, H265。
5. 音频编码格式仅支持: AAC。
6. 点播源请使用小文件，尽量时长保持在1小时内，较大文件打开和续播耗时较久，耗时超过15秒会有无法正常转推风险。
7. 避免使用低频存储的文件，该类文件因低频存储，拉取时容易出现慢速，影响拉转推质量。
        :rtype: list of str
        """
        return self._SourceUrls

    @SourceUrls.setter
    def SourceUrls(self, SourceUrls):
        self._SourceUrls = SourceUrls

    @property
    def DomainName(self):
        """推流域名。
将拉取过来的流推到该域名。
注意：如果目标地址为非云直播，且样式不同于云直播，请使用 ToUrl 传入完整推流地址，详细用法请参考 ToUrl 参数说明。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def AppName(self):
        """推流路径。
将拉取过来的流推到该路径。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def StreamName(self):
        """推流名称。
将拉取过来的流推到该流名称。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName

    @property
    def StartTime(self):
        """开始时间。
使用 UTC 格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束时间，注意：1. 结束时间必须大于开始时间；2. 结束时间必须大于当前时间；3. 结束时间 和 开始时间 间隔必须小于30天。使用 UTC 格式时间，例如：2019-01-08T10:00:00Z。注意：北京时间值为 UTC 时间值 + 8 小时。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Operator(self):
        """任务操作人备注。
        :rtype: str
        """
        return self._Operator

    @Operator.setter
    def Operator(self, Operator):
        self._Operator = Operator

    @property
    def PushArgs(self):
        """推流参数。
推流时携带自定义参数。
示例：
bak=1&test=2 。
        :rtype: str
        """
        return self._PushArgs

    @PushArgs.setter
    def PushArgs(self, PushArgs):
        self._PushArgs = PushArgs

    @property
    def CallbackEvents(self):
        """选择需要回调的事件（不填则回调全部）：
TaskStart：任务启动回调，
TaskExit：任务停止回调，
VodSourceFileStart：从点播源文件开始拉流回调，
VodSourceFileFinish：从点播源文件拉流结束回调，
ResetTaskConfig：任务更新回调。

TaskAlarm: 用于告警事件通知，AlarmType 示例:
PullFileUnstable - 文件拉取不稳定，
PushStreamUnstable - 推流不稳定，
PullFileFailed - 文件拉取出错，
PushStreamFailed - 推流出现失败，
FileEndEarly - 文件提前结束。
        :rtype: list of str
        """
        return self._CallbackEvents

    @CallbackEvents.setter
    def CallbackEvents(self, CallbackEvents):
        self._CallbackEvents = CallbackEvents

    @property
    def VodLoopTimes(self):
        """点播拉流转推循环次数。默认：-1。
-1：无限循环，直到任务结束。
0：不循环。
>0：具体循环次数。次数和时间以先结束的为准。
注意：该配置仅对拉流源为点播时生效。
        :rtype: str
        """
        return self._VodLoopTimes

    @VodLoopTimes.setter
    def VodLoopTimes(self, VodLoopTimes):
        self._VodLoopTimes = VodLoopTimes

    @property
    def VodRefreshType(self):
        """点播更新SourceUrls后的播放方式：
ImmediateNewSource：立即播放新的拉流源内容；
ContinueBreakPoint：播放完当前正在播放的点播 url 后再使用新的拉流源播放。（旧拉流源未播放的点播 url 不会再播放）

注意：该配置生效仅对变更前拉流源为点播时生效。
        :rtype: str
        """
        return self._VodRefreshType

    @VodRefreshType.setter
    def VodRefreshType(self, VodRefreshType):
        self._VodRefreshType = VodRefreshType

    @property
    def CallbackUrl(self):
        """自定义回调地址。
拉流转推任务相关事件会回调到该地址。
回调事件使用方法请查看：
https://cloud.tencent.com/document/product/267/32744
https://cloud.tencent.com/document/product/267/56208
        :rtype: str
        """
        return self._CallbackUrl

    @CallbackUrl.setter
    def CallbackUrl(self, CallbackUrl):
        self._CallbackUrl = CallbackUrl

    @property
    def ExtraCmd(self):
        """其他参数。
示例: ignore_region  用于忽略传入地域, 内部按负载分配。
        :rtype: str
        """
        return self._ExtraCmd

    @ExtraCmd.setter
    def ExtraCmd(self, ExtraCmd):
        self._ExtraCmd = ExtraCmd

    @property
    def SpecifyTaskId(self):
        """自定义任务 ID。
注：
1. 该自定义 ID 为可选参数，如果传入，请确保该账号下传入的 ID 唯一。
2. 该自定义 ID 用于防止重复发起请求时产生重复任务。后面也可以用 SpecifyTaskId 来修改或删除任务。
        :rtype: str
        """
        return self._SpecifyTaskId

    @SpecifyTaskId.setter
    def SpecifyTaskId(self, SpecifyTaskId):
        self._SpecifyTaskId = SpecifyTaskId

    @property
    def Comment(self):
        """任务描述，限制 512 字节。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def ToUrl(self):
        """完整目标 URL 地址。
用法注意：如果使用该参数来传完整目标地址，则 DomainName, AppName, StreamName 需要传入空字符串，任务将会使用该 ToUrl 参数指定的目标地址。

使用该方式传入目标地址支持的协议有：
rtmp、rtmps、rtsp、rtp、srt。

注意：签名时间需要超过任务结束时间，避免因签名过期造成任务失败。
        :rtype: str
        """
        return self._ToUrl

    @ToUrl.setter
    def ToUrl(self, ToUrl):
        self._ToUrl = ToUrl

    @property
    def FileIndex(self):
        """指定播放文件索引。
注意： 1. 从1开始，不大于SourceUrls中文件个数。
2. 该偏移仅在首次轮播时有效。
3. 提前创建的任务指定的偏移最长有效期为24小时，24小时后未开始的任务偏移失效。
        :rtype: int
        """
        return self._FileIndex

    @FileIndex.setter
    def FileIndex(self, FileIndex):
        self._FileIndex = FileIndex

    @property
    def OffsetTime(self):
        """指定播放文件偏移。
注意：
1. 单位：秒，配合FileIndex使用。
        :rtype: int
        """
        return self._OffsetTime

    @OffsetTime.setter
    def OffsetTime(self, OffsetTime):
        self._OffsetTime = OffsetTime

    @property
    def BackupSourceType(self):
        """备源的类型：
PullLivePushLive -直播，
PullVodPushLive -点播。
注意：
1. 仅当主源类型为直播源时，备源才会生效。
2. 主直播源拉流中断时，自动使用备源进行拉流。
3. 如果备源为点播文件时，则每次轮播完点播文件就检查主源是否恢复，如果主源恢复则自动切回到主源，否则继续拉备源。
        :rtype: str
        """
        return self._BackupSourceType

    @BackupSourceType.setter
    def BackupSourceType(self, BackupSourceType):
        self._BackupSourceType = BackupSourceType

    @property
    def BackupSourceUrl(self):
        """备源 URL。
只允许填一个备源 URL
        :rtype: str
        """
        return self._BackupSourceUrl

    @BackupSourceUrl.setter
    def BackupSourceUrl(self, BackupSourceUrl):
        self._BackupSourceUrl = BackupSourceUrl

    @property
    def WatermarkList(self):
        """水印信息列表。
注意：
1. 最多支持4个不同位置的水印。
2. 水印图片 URL 请使用合法外网可访问地址。
3. 支持的水印图片格式：png，jpg，gif 等。
        :rtype: list of PullPushWatermarkInfo
        """
        return self._WatermarkList

    @WatermarkList.setter
    def WatermarkList(self, WatermarkList):
        self._WatermarkList = WatermarkList

    @property
    def VodLocalMode(self):
        """点播源是否启用本地推流模式，默认0，不启用。
0 - 不启用。
1 - 启用。
注意：启用本地模式后，会将源列表中的 MP4 文件进行本地下载，优先使用本地已下载文件进行推流，提高点播源推流稳定性。使用本地下载文件推流时，会产生增值费用。
        :rtype: int
        """
        return self._VodLocalMode

    @VodLocalMode.setter
    def VodLocalMode(self, VodLocalMode):
        self._VodLocalMode = VodLocalMode

    @property
    def RecordTemplateId(self):
        """录制模板 ID。
        :rtype: str
        """
        return self._RecordTemplateId

    @RecordTemplateId.setter
    def RecordTemplateId(self, RecordTemplateId):
        self._RecordTemplateId = RecordTemplateId

    @property
    def BackupToUrl(self):
        """新的目标地址，用于任务同时推两路场景。
        :rtype: str
        """
        return self._BackupToUrl

    @BackupToUrl.setter
    def BackupToUrl(self, BackupToUrl):
        self._BackupToUrl = BackupToUrl

    @property
    def TranscodeTemplateName(self):
        """直播转码模板，使用云直播的转码功能进行转码后再转推出去。转码模板需在云直播控制台创建。
        :rtype: str
        """
        return self._TranscodeTemplateName

    @TranscodeTemplateName.setter
    def TranscodeTemplateName(self, TranscodeTemplateName):
        self._TranscodeTemplateName = TranscodeTemplateName


    def _deserialize(self, params):
        self._SourceType = params.get("SourceType")
        self._SourceUrls = params.get("SourceUrls")
        self._DomainName = params.get("DomainName")
        self._AppName = params.get("AppName")
        self._StreamName = params.get("StreamName")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Operator = params.get("Operator")
        self._PushArgs = params.get("PushArgs")
        self._CallbackEvents = params.get("CallbackEvents")
        self._VodLoopTimes = params.get("VodLoopTimes")
        self._VodRefreshType = params.get("VodRefreshType")
        self._CallbackUrl = params.get("CallbackUrl")
        self._ExtraCmd = params.get("ExtraCmd")
        self._SpecifyTaskId = params.get("SpecifyTaskId")
        self._Comment = params.get("Comment")
        self._ToUrl = params.get("ToUrl")
        self._FileIndex = params.get("FileIndex")
        self._OffsetTime = params.get("OffsetTime")
        self._BackupSourceType = params.get("BackupSourceType")
        self._BackupSourceUrl = params.get("BackupSourceUrl")
        if params.get("WatermarkList") is not None:
            self._WatermarkList = []
            for item in params.get("WatermarkList"):
                obj = PullPushWatermarkInfo()
                obj._deserialize(item)
                self._WatermarkList.append(obj)
        self._VodLocalMode = params.get("VodLocalMode")
        self._RecordTemplateId = params.get("RecordTemplateId")
        self._BackupToUrl = params.get("BackupToUrl")
        self._TranscodeTemplateName = params.get("TranscodeTemplateName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateLivePullStreamTaskResponse(AbstractModel):
    """CreateLivePullStreamTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务 Id 。
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        """任务 Id 。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class CreateLiveRecordRequest(AbstractModel):
    """CreateLiveRecord请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StreamName: 流名称。
        :type StreamName: str
        :param _AppName: 推流路径，与推流和播放地址中的 AppName保持一致，默认为 live。
        :type AppName: str
        :param _DomainName: 推流域名。多域名推流必须设置。
        :type DomainName: str
        :param _StartTime: 录制开始时间。中国标准时间，需要 URLEncode(rfc3986)。如 2017-01-01 10:10:01，编码为：2017-01-01+10%3a10%3a01。
定时录制模式，必须设置该字段；实时视频录制模式，忽略该字段。
        :type StartTime: str
        :param _EndTime: 录制结束时间。中国标准时间，需要 URLEncode(rfc3986)。如 2017-01-01 10:30:01，编码为：2017-01-01+10%3a30%3a01。
定时录制模式，必须设置该字段；实时录制模式，为可选字段。如果通过Highlight参数，设置录制为实时视频录制模式，其设置的结束时间不应超过当前时间+30分钟，如果设置的结束时间超过当前时间+30分钟或者小于当前时间或者不设置该参数，则实际结束时间为当前时间+30分钟。
        :type EndTime: str
        :param _RecordType: 录制类型。
“video” : 音视频录制【默认】。
“audio” : 纯音频录制。
在定时录制模式或实时视频录制模式下，该参数均有效，不区分大小写。
        :type RecordType: str
        :param _FileFormat: 录制文件格式。其值为：
“flv”【默认】,“hls”,”mp4”,“aac”,”mp3”。
在定时录制模式或实时视频录制模式下，该参数均有效，不区分大小写。
        :type FileFormat: str
        :param _Highlight: 开启实时视频录制模式标志。
0：不开启实时视频录制模式，即定时录制模式【默认】。见[示例一](#.E7.A4.BA.E4.BE.8B1-.E5.88.9B.E5.BB.BA.E5.AE.9A.E6.97.B6.E5.BD.95.E5.88.B6.E4.BB.BB.E5.8A.A1)。
1：开启实时视频录制模式。见[示例二](#.E7.A4.BA.E4.BE.8B2-.E5.88.9B.E5.BB.BA.E5.AE.9E.E6.97.B6.E5.BD.95.E5.88.B6.E4.BB.BB.E5.8A.A1)。
        :type Highlight: int
        :param _MixStream: 开启 A+B=C混流C流录制标志。
0：不开启 A+B=C混流C流录制【默认】。
1：开启 A+B=C混流C流录制。
在定时录制模式或实时视频录制模式下，该参数均有效。
        :type MixStream: int
        :param _StreamParam: 录制流参数。当前支持以下参数：
record_interval - 录制分片时长，单位 秒，1800 - 7200。
storage_time - 录制文件存储时长，单位 秒。
eg. record_interval=3600&storage_time=2592000。
注：参数需要url encode。
在定时录制模式或实时视频录制模式下，该参数均有效。
        :type StreamParam: str
        """
        self._StreamName = None
        self._AppName = None
        self._DomainName = None
        self._StartTime = None
        self._EndTime = None
        self._RecordType = None
        self._FileFormat = None
        self._Highlight = None
        self._MixStream = None
        self._StreamParam = None

    @property
    def StreamName(self):
        """流名称。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName

    @property
    def AppName(self):
        """推流路径，与推流和播放地址中的 AppName保持一致，默认为 live。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def DomainName(self):
        """推流域名。多域名推流必须设置。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def StartTime(self):
        """录制开始时间。中国标准时间，需要 URLEncode(rfc3986)。如 2017-01-01 10:10:01，编码为：2017-01-01+10%3a10%3a01。
定时录制模式，必须设置该字段；实时视频录制模式，忽略该字段。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """录制结束时间。中国标准时间，需要 URLEncode(rfc3986)。如 2017-01-01 10:30:01，编码为：2017-01-01+10%3a30%3a01。
定时录制模式，必须设置该字段；实时录制模式，为可选字段。如果通过Highlight参数，设置录制为实时视频录制模式，其设置的结束时间不应超过当前时间+30分钟，如果设置的结束时间超过当前时间+30分钟或者小于当前时间或者不设置该参数，则实际结束时间为当前时间+30分钟。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def RecordType(self):
        """录制类型。
“video” : 音视频录制【默认】。
“audio” : 纯音频录制。
在定时录制模式或实时视频录制模式下，该参数均有效，不区分大小写。
        :rtype: str
        """
        return self._RecordType

    @RecordType.setter
    def RecordType(self, RecordType):
        self._RecordType = RecordType

    @property
    def FileFormat(self):
        """录制文件格式。其值为：
“flv”【默认】,“hls”,”mp4”,“aac”,”mp3”。
在定时录制模式或实时视频录制模式下，该参数均有效，不区分大小写。
        :rtype: str
        """
        return self._FileFormat

    @FileFormat.setter
    def FileFormat(self, FileFormat):
        self._FileFormat = FileFormat

    @property
    def Highlight(self):
        """开启实时视频录制模式标志。
0：不开启实时视频录制模式，即定时录制模式【默认】。见[示例一](#.E7.A4.BA.E4.BE.8B1-.E5.88.9B.E5.BB.BA.E5.AE.9A.E6.97.B6.E5.BD.95.E5.88.B6.E4.BB.BB.E5.8A.A1)。
1：开启实时视频录制模式。见[示例二](#.E7.A4.BA.E4.BE.8B2-.E5.88.9B.E5.BB.BA.E5.AE.9E.E6.97.B6.E5.BD.95.E5.88.B6.E4.BB.BB.E5.8A.A1)。
        :rtype: int
        """
        return self._Highlight

    @Highlight.setter
    def Highlight(self, Highlight):
        self._Highlight = Highlight

    @property
    def MixStream(self):
        """开启 A+B=C混流C流录制标志。
0：不开启 A+B=C混流C流录制【默认】。
1：开启 A+B=C混流C流录制。
在定时录制模式或实时视频录制模式下，该参数均有效。
        :rtype: int
        """
        return self._MixStream

    @MixStream.setter
    def MixStream(self, MixStream):
        self._MixStream = MixStream

    @property
    def StreamParam(self):
        """录制流参数。当前支持以下参数：
record_interval - 录制分片时长，单位 秒，1800 - 7200。
storage_time - 录制文件存储时长，单位 秒。
eg. record_interval=3600&storage_time=2592000。
注：参数需要url encode。
在定时录制模式或实时视频录制模式下，该参数均有效。
        :rtype: str
        """
        return self._StreamParam

    @StreamParam.setter
    def StreamParam(self, StreamParam):
        self._StreamParam = StreamParam


    def _deserialize(self, params):
        self._StreamName = params.get("StreamName")
        self._AppName = params.get("AppName")
        self._DomainName = params.get("DomainName")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._RecordType = params.get("RecordType")
        self._FileFormat = params.get("FileFormat")
        self._Highlight = params.get("Highlight")
        self._MixStream = params.get("MixStream")
        self._StreamParam = params.get("StreamParam")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateLiveRecordResponse(AbstractModel):
    """CreateLiveRecord返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务 ID，全局唯一标识录制任务。
        :type TaskId: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        """任务 ID，全局唯一标识录制任务。
        :rtype: int
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class CreateLiveRecordRuleRequest(AbstractModel):
    """CreateLiveRecordRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DomainName: 推流域名。
        :type DomainName: str
        :param _TemplateId: 模板 ID。
        :type TemplateId: int
        :param _AppName: 推流路径，与推流和播放地址中的AppName保持一致，默认为 live。
        :type AppName: str
        :param _StreamName: 流名称。
注：如果本参数设置为非空字符串，规则将只对此推流起作用。
        :type StreamName: str
        """
        self._DomainName = None
        self._TemplateId = None
        self._AppName = None
        self._StreamName = None

    @property
    def DomainName(self):
        """推流域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def TemplateId(self):
        """模板 ID。
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId

    @property
    def AppName(self):
        """推流路径，与推流和播放地址中的AppName保持一致，默认为 live。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def StreamName(self):
        """流名称。
注：如果本参数设置为非空字符串，规则将只对此推流起作用。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName


    def _deserialize(self, params):
        self._DomainName = params.get("DomainName")
        self._TemplateId = params.get("TemplateId")
        self._AppName = params.get("AppName")
        self._StreamName = params.get("StreamName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateLiveRecordRuleResponse(AbstractModel):
    """CreateLiveRecordRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateLiveRecordTemplateRequest(AbstractModel):
    """CreateLiveRecordTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TemplateName: 模板名。仅支持中文、英文、数字、_、-。
        :type TemplateName: str
        :param _Description: 描述信息。
        :type Description: str
        :param _FlvParam: Flv录制参数，开启Flv录制时设置。
        :type FlvParam: :class:`tencentcloud.live.v20180801.models.RecordParam`
        :param _HlsParam: Hls录制参数，开启hls录制时设置。
        :type HlsParam: :class:`tencentcloud.live.v20180801.models.RecordParam`
        :param _Mp4Param: Mp4录制参数，开启Mp4录制时设置。
        :type Mp4Param: :class:`tencentcloud.live.v20180801.models.RecordParam`
        :param _AacParam: Aac录制参数，开启Aac录制时设置。
        :type AacParam: :class:`tencentcloud.live.v20180801.models.RecordParam`
        :param _IsDelayLive: 直播类型，默认 0。
0：普通直播，
1：慢直播。
        :type IsDelayLive: int
        :param _HlsSpecialParam: HLS专属录制参数。
        :type HlsSpecialParam: :class:`tencentcloud.live.v20180801.models.HlsSpecialParam`
        :param _Mp3Param: Mp3录制参数，开启Mp3录制时设置。
        :type Mp3Param: :class:`tencentcloud.live.v20180801.models.RecordParam`
        :param _CosStore: 是否存储至 cos，值为 1 时表示存储至 cos。
        :type CosStore: int
        :param _RemoveWatermark: 是否去除水印，类型为慢直播时此参数无效。
如果为false，则录制水印流或转码流；如果为true，则录制原始流。
        :type RemoveWatermark: bool
        :param _FlvSpecialParam: FLV 录制特殊参数。
        :type FlvSpecialParam: :class:`tencentcloud.live.v20180801.models.FlvSpecialParam`
        """
        self._TemplateName = None
        self._Description = None
        self._FlvParam = None
        self._HlsParam = None
        self._Mp4Param = None
        self._AacParam = None
        self._IsDelayLive = None
        self._HlsSpecialParam = None
        self._Mp3Param = None
        self._CosStore = None
        self._RemoveWatermark = None
        self._FlvSpecialParam = None

    @property
    def TemplateName(self):
        """模板名。仅支持中文、英文、数字、_、-。
        :rtype: str
        """
        return self._TemplateName

    @TemplateName.setter
    def TemplateName(self, TemplateName):
        self._TemplateName = TemplateName

    @property
    def Description(self):
        """描述信息。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def FlvParam(self):
        """Flv录制参数，开启Flv录制时设置。
        :rtype: :class:`tencentcloud.live.v20180801.models.RecordParam`
        """
        return self._FlvParam

    @FlvParam.setter
    def FlvParam(self, FlvParam):
        self._FlvParam = FlvParam

    @property
    def HlsParam(self):
        """Hls录制参数，开启hls录制时设置。
        :rtype: :class:`tencentcloud.live.v20180801.models.RecordParam`
        """
        return self._HlsParam

    @HlsParam.setter
    def HlsParam(self, HlsParam):
        self._HlsParam = HlsParam

    @property
    def Mp4Param(self):
        """Mp4录制参数，开启Mp4录制时设置。
        :rtype: :class:`tencentcloud.live.v20180801.models.RecordParam`
        """
        return self._Mp4Param

    @Mp4Param.setter
    def Mp4Param(self, Mp4Param):
        self._Mp4Param = Mp4Param

    @property
    def AacParam(self):
        """Aac录制参数，开启Aac录制时设置。
        :rtype: :class:`tencentcloud.live.v20180801.models.RecordParam`
        """
        return self._AacParam

    @AacParam.setter
    def AacParam(self, AacParam):
        self._AacParam = AacParam

    @property
    def IsDelayLive(self):
        """直播类型，默认 0。
0：普通直播，
1：慢直播。
        :rtype: int
        """
        return self._IsDelayLive

    @IsDelayLive.setter
    def IsDelayLive(self, IsDelayLive):
        self._IsDelayLive = IsDelayLive

    @property
    def HlsSpecialParam(self):
        """HLS专属录制参数。
        :rtype: :class:`tencentcloud.live.v20180801.models.HlsSpecialParam`
        """
        return self._HlsSpecialParam

    @HlsSpecialParam.setter
    def HlsSpecialParam(self, HlsSpecialParam):
        self._HlsSpecialParam = HlsSpecialParam

    @property
    def Mp3Param(self):
        """Mp3录制参数，开启Mp3录制时设置。
        :rtype: :class:`tencentcloud.live.v20180801.models.RecordParam`
        """
        return self._Mp3Param

    @Mp3Param.setter
    def Mp3Param(self, Mp3Param):
        self._Mp3Param = Mp3Param

    @property
    def CosStore(self):
        """是否存储至 cos，值为 1 时表示存储至 cos。
        :rtype: int
        """
        return self._CosStore

    @CosStore.setter
    def CosStore(self, CosStore):
        self._CosStore = CosStore

    @property
    def RemoveWatermark(self):
        """是否去除水印，类型为慢直播时此参数无效。
如果为false，则录制水印流或转码流；如果为true，则录制原始流。
        :rtype: bool
        """
        return self._RemoveWatermark

    @RemoveWatermark.setter
    def RemoveWatermark(self, RemoveWatermark):
        self._RemoveWatermark = RemoveWatermark

    @property
    def FlvSpecialParam(self):
        """FLV 录制特殊参数。
        :rtype: :class:`tencentcloud.live.v20180801.models.FlvSpecialParam`
        """
        return self._FlvSpecialParam

    @FlvSpecialParam.setter
    def FlvSpecialParam(self, FlvSpecialParam):
        self._FlvSpecialParam = FlvSpecialParam


    def _deserialize(self, params):
        self._TemplateName = params.get("TemplateName")
        self._Description = params.get("Description")
        if params.get("FlvParam") is not None:
            self._FlvParam = RecordParam()
            self._FlvParam._deserialize(params.get("FlvParam"))
        if params.get("HlsParam") is not None:
            self._HlsParam = RecordParam()
            self._HlsParam._deserialize(params.get("HlsParam"))
        if params.get("Mp4Param") is not None:
            self._Mp4Param = RecordParam()
            self._Mp4Param._deserialize(params.get("Mp4Param"))
        if params.get("AacParam") is not None:
            self._AacParam = RecordParam()
            self._AacParam._deserialize(params.get("AacParam"))
        self._IsDelayLive = params.get("IsDelayLive")
        if params.get("HlsSpecialParam") is not None:
            self._HlsSpecialParam = HlsSpecialParam()
            self._HlsSpecialParam._deserialize(params.get("HlsSpecialParam"))
        if params.get("Mp3Param") is not None:
            self._Mp3Param = RecordParam()
            self._Mp3Param._deserialize(params.get("Mp3Param"))
        self._CosStore = params.get("CosStore")
        self._RemoveWatermark = params.get("RemoveWatermark")
        if params.get("FlvSpecialParam") is not None:
            self._FlvSpecialParam = FlvSpecialParam()
            self._FlvSpecialParam._deserialize(params.get("FlvSpecialParam"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateLiveRecordTemplateResponse(AbstractModel):
    """CreateLiveRecordTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TemplateId: 模板Id。
        :type TemplateId: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TemplateId = None
        self._RequestId = None

    @property
    def TemplateId(self):
        """模板Id。
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        self._RequestId = params.get("RequestId")


class CreateLiveSnapshotRuleRequest(AbstractModel):
    """CreateLiveSnapshotRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DomainName: 推流域名。
        :type DomainName: str
        :param _TemplateId: 模板 ID。
        :type TemplateId: int
        :param _AppName: 推流路径，与推流和播放地址中的 AppName 保持一致，默认为 live。
        :type AppName: str
        :param _StreamName: 流名称。
注：如果本参数设置为非空字符串，规则将只对此推流起作用。
        :type StreamName: str
        """
        self._DomainName = None
        self._TemplateId = None
        self._AppName = None
        self._StreamName = None

    @property
    def DomainName(self):
        """推流域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def TemplateId(self):
        """模板 ID。
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId

    @property
    def AppName(self):
        """推流路径，与推流和播放地址中的 AppName 保持一致，默认为 live。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def StreamName(self):
        """流名称。
注：如果本参数设置为非空字符串，规则将只对此推流起作用。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName


    def _deserialize(self, params):
        self._DomainName = params.get("DomainName")
        self._TemplateId = params.get("TemplateId")
        self._AppName = params.get("AppName")
        self._StreamName = params.get("StreamName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateLiveSnapshotRuleResponse(AbstractModel):
    """CreateLiveSnapshotRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateLiveSnapshotTemplateRequest(AbstractModel):
    """CreateLiveSnapshotTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TemplateName: 模板名称。
长度上限：255字节。
仅支持中文、英文、数字、_、-。
        :type TemplateName: str
        :param _CosAppId: Cos 应用 ID。
        :type CosAppId: int
        :param _CosBucket: Cos Bucket名称。
注：CosBucket参数值不能包含-[appid] 部分。
        :type CosBucket: str
        :param _CosRegion: Cos地区。
        :type CosRegion: str
        :param _Description: 描述信息。
长度上限：1024字节。
仅支持中文、英文、数字、_、-。
        :type Description: str
        :param _SnapshotInterval: 截图间隔，单位s，默认10s。
范围： 2s ~ 300s。
        :type SnapshotInterval: int
        :param _Width: 截图宽度。默认：0（原始宽）。
范围：0-3000 。
        :type Width: int
        :param _Height: 截图高度。默认：0（原始高）。
范围：0-2000 。
        :type Height: int
        :param _PornFlag: 是否开启鉴黄，0：不开启，1：开启。默认：0。
        :type PornFlag: int
        :param _CosPrefix: Cos Bucket文件夹前缀。
如不传，实际按默认值
/{Year}-{Month}-{Day}
生效
        :type CosPrefix: str
        :param _CosFileName: Cos 文件名称。
如不传，实际按默认值
{StreamID}-screenshot-{Hour}-{Minute}-{Second}-{Width}x{Height}{Ext}
生效
        :type CosFileName: str
        """
        self._TemplateName = None
        self._CosAppId = None
        self._CosBucket = None
        self._CosRegion = None
        self._Description = None
        self._SnapshotInterval = None
        self._Width = None
        self._Height = None
        self._PornFlag = None
        self._CosPrefix = None
        self._CosFileName = None

    @property
    def TemplateName(self):
        """模板名称。
长度上限：255字节。
仅支持中文、英文、数字、_、-。
        :rtype: str
        """
        return self._TemplateName

    @TemplateName.setter
    def TemplateName(self, TemplateName):
        self._TemplateName = TemplateName

    @property
    def CosAppId(self):
        """Cos 应用 ID。
        :rtype: int
        """
        return self._CosAppId

    @CosAppId.setter
    def CosAppId(self, CosAppId):
        self._CosAppId = CosAppId

    @property
    def CosBucket(self):
        """Cos Bucket名称。
注：CosBucket参数值不能包含-[appid] 部分。
        :rtype: str
        """
        return self._CosBucket

    @CosBucket.setter
    def CosBucket(self, CosBucket):
        self._CosBucket = CosBucket

    @property
    def CosRegion(self):
        """Cos地区。
        :rtype: str
        """
        return self._CosRegion

    @CosRegion.setter
    def CosRegion(self, CosRegion):
        self._CosRegion = CosRegion

    @property
    def Description(self):
        """描述信息。
长度上限：1024字节。
仅支持中文、英文、数字、_、-。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def SnapshotInterval(self):
        """截图间隔，单位s，默认10s。
范围： 2s ~ 300s。
        :rtype: int
        """
        return self._SnapshotInterval

    @SnapshotInterval.setter
    def SnapshotInterval(self, SnapshotInterval):
        self._SnapshotInterval = SnapshotInterval

    @property
    def Width(self):
        """截图宽度。默认：0（原始宽）。
范围：0-3000 。
        :rtype: int
        """
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        """截图高度。默认：0（原始高）。
范围：0-2000 。
        :rtype: int
        """
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def PornFlag(self):
        """是否开启鉴黄，0：不开启，1：开启。默认：0。
        :rtype: int
        """
        return self._PornFlag

    @PornFlag.setter
    def PornFlag(self, PornFlag):
        self._PornFlag = PornFlag

    @property
    def CosPrefix(self):
        """Cos Bucket文件夹前缀。
如不传，实际按默认值
/{Year}-{Month}-{Day}
生效
        :rtype: str
        """
        return self._CosPrefix

    @CosPrefix.setter
    def CosPrefix(self, CosPrefix):
        self._CosPrefix = CosPrefix

    @property
    def CosFileName(self):
        """Cos 文件名称。
如不传，实际按默认值
{StreamID}-screenshot-{Hour}-{Minute}-{Second}-{Width}x{Height}{Ext}
生效
        :rtype: str
        """
        return self._CosFileName

    @CosFileName.setter
    def CosFileName(self, CosFileName):
        self._CosFileName = CosFileName


    def _deserialize(self, params):
        self._TemplateName = params.get("TemplateName")
        self._CosAppId = params.get("CosAppId")
        self._CosBucket = params.get("CosBucket")
        self._CosRegion = params.get("CosRegion")
        self._Description = params.get("Description")
        self._SnapshotInterval = params.get("SnapshotInterval")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._PornFlag = params.get("PornFlag")
        self._CosPrefix = params.get("CosPrefix")
        self._CosFileName = params.get("CosFileName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateLiveSnapshotTemplateResponse(AbstractModel):
    """CreateLiveSnapshotTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TemplateId: 模板Id。
        :type TemplateId: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TemplateId = None
        self._RequestId = None

    @property
    def TemplateId(self):
        """模板Id。
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        self._RequestId = params.get("RequestId")


class CreateLiveStreamMonitorRequest(AbstractModel):
    """CreateLiveStreamMonitor请求参数结构体

    """

    def __init__(self):
        r"""
        :param _OutputInfo: 监播任务的输出信息。
        :type OutputInfo: :class:`tencentcloud.live.v20180801.models.LiveStreamMonitorOutputInfo`
        :param _InputList: 待监播的输入流信息列表。
        :type InputList: list of LiveStreamMonitorInputInfo
        :param _MonitorName: 监播任务名称。字段长度小于128字节（一个汉字两个字节）。
        :type MonitorName: str
        :param _NotifyPolicy: 监播事件通知策略。
不填默认为没有任何通知。
        :type NotifyPolicy: :class:`tencentcloud.live.v20180801.models.LiveStreamMonitorNotifyPolicy`
        :param _AsrLanguage: 智能语音识别语种设置：
0 关闭 1 中文 2 英文 3 日文 4 韩文。
        :type AsrLanguage: int
        :param _OcrLanguage: 智能文字识别语种设置：
0 关闭 1 中、英文。
        :type OcrLanguage: int
        :param _AiAsrInputIndexList: 智能语音识别的输入列表，若开启语音识别则必填。
（第1条输入流index为1）
        :type AiAsrInputIndexList: list of int non-negative
        :param _AiOcrInputIndexList: 智能文字识别的输入列表，若开启文字识别则必填。
（第1条输入流index为1）
        :type AiOcrInputIndexList: list of int non-negative
        :param _CheckStreamBroken: 是否开启断流检测。
        :type CheckStreamBroken: int
        :param _CheckStreamLowFrameRate: 是否开启低帧率检测。
        :type CheckStreamLowFrameRate: int
        :param _AllowMonitorReport: 是否存储监播事件到监播报告，以及是否允许查询监播报告。
        :type AllowMonitorReport: int
        :param _AiFormatDiagnose: 是否开启格式诊断。
        :type AiFormatDiagnose: int
        :param _AiQualityControl: 是否开启内容质检。
        :type AiQualityControl: int
        :param _CasterId: 导播台监播对应的导播台场次id。
        :type CasterId: str
        :param _PullPushTaskId: 拉流转推监播任务对应的拉流转推场次id
        :type PullPushTaskId: str
        """
        self._OutputInfo = None
        self._InputList = None
        self._MonitorName = None
        self._NotifyPolicy = None
        self._AsrLanguage = None
        self._OcrLanguage = None
        self._AiAsrInputIndexList = None
        self._AiOcrInputIndexList = None
        self._CheckStreamBroken = None
        self._CheckStreamLowFrameRate = None
        self._AllowMonitorReport = None
        self._AiFormatDiagnose = None
        self._AiQualityControl = None
        self._CasterId = None
        self._PullPushTaskId = None

    @property
    def OutputInfo(self):
        """监播任务的输出信息。
        :rtype: :class:`tencentcloud.live.v20180801.models.LiveStreamMonitorOutputInfo`
        """
        return self._OutputInfo

    @OutputInfo.setter
    def OutputInfo(self, OutputInfo):
        self._OutputInfo = OutputInfo

    @property
    def InputList(self):
        """待监播的输入流信息列表。
        :rtype: list of LiveStreamMonitorInputInfo
        """
        return self._InputList

    @InputList.setter
    def InputList(self, InputList):
        self._InputList = InputList

    @property
    def MonitorName(self):
        """监播任务名称。字段长度小于128字节（一个汉字两个字节）。
        :rtype: str
        """
        return self._MonitorName

    @MonitorName.setter
    def MonitorName(self, MonitorName):
        self._MonitorName = MonitorName

    @property
    def NotifyPolicy(self):
        """监播事件通知策略。
不填默认为没有任何通知。
        :rtype: :class:`tencentcloud.live.v20180801.models.LiveStreamMonitorNotifyPolicy`
        """
        return self._NotifyPolicy

    @NotifyPolicy.setter
    def NotifyPolicy(self, NotifyPolicy):
        self._NotifyPolicy = NotifyPolicy

    @property
    def AsrLanguage(self):
        """智能语音识别语种设置：
0 关闭 1 中文 2 英文 3 日文 4 韩文。
        :rtype: int
        """
        return self._AsrLanguage

    @AsrLanguage.setter
    def AsrLanguage(self, AsrLanguage):
        self._AsrLanguage = AsrLanguage

    @property
    def OcrLanguage(self):
        """智能文字识别语种设置：
0 关闭 1 中、英文。
        :rtype: int
        """
        return self._OcrLanguage

    @OcrLanguage.setter
    def OcrLanguage(self, OcrLanguage):
        self._OcrLanguage = OcrLanguage

    @property
    def AiAsrInputIndexList(self):
        """智能语音识别的输入列表，若开启语音识别则必填。
（第1条输入流index为1）
        :rtype: list of int non-negative
        """
        return self._AiAsrInputIndexList

    @AiAsrInputIndexList.setter
    def AiAsrInputIndexList(self, AiAsrInputIndexList):
        self._AiAsrInputIndexList = AiAsrInputIndexList

    @property
    def AiOcrInputIndexList(self):
        """智能文字识别的输入列表，若开启文字识别则必填。
（第1条输入流index为1）
        :rtype: list of int non-negative
        """
        return self._AiOcrInputIndexList

    @AiOcrInputIndexList.setter
    def AiOcrInputIndexList(self, AiOcrInputIndexList):
        self._AiOcrInputIndexList = AiOcrInputIndexList

    @property
    def CheckStreamBroken(self):
        """是否开启断流检测。
        :rtype: int
        """
        return self._CheckStreamBroken

    @CheckStreamBroken.setter
    def CheckStreamBroken(self, CheckStreamBroken):
        self._CheckStreamBroken = CheckStreamBroken

    @property
    def CheckStreamLowFrameRate(self):
        """是否开启低帧率检测。
        :rtype: int
        """
        return self._CheckStreamLowFrameRate

    @CheckStreamLowFrameRate.setter
    def CheckStreamLowFrameRate(self, CheckStreamLowFrameRate):
        self._CheckStreamLowFrameRate = CheckStreamLowFrameRate

    @property
    def AllowMonitorReport(self):
        """是否存储监播事件到监播报告，以及是否允许查询监播报告。
        :rtype: int
        """
        return self._AllowMonitorReport

    @AllowMonitorReport.setter
    def AllowMonitorReport(self, AllowMonitorReport):
        self._AllowMonitorReport = AllowMonitorReport

    @property
    def AiFormatDiagnose(self):
        """是否开启格式诊断。
        :rtype: int
        """
        return self._AiFormatDiagnose

    @AiFormatDiagnose.setter
    def AiFormatDiagnose(self, AiFormatDiagnose):
        self._AiFormatDiagnose = AiFormatDiagnose

    @property
    def AiQualityControl(self):
        """是否开启内容质检。
        :rtype: int
        """
        return self._AiQualityControl

    @AiQualityControl.setter
    def AiQualityControl(self, AiQualityControl):
        self._AiQualityControl = AiQualityControl

    @property
    def CasterId(self):
        """导播台监播对应的导播台场次id。
        :rtype: str
        """
        return self._CasterId

    @CasterId.setter
    def CasterId(self, CasterId):
        self._CasterId = CasterId

    @property
    def PullPushTaskId(self):
        """拉流转推监播任务对应的拉流转推场次id
        :rtype: str
        """
        return self._PullPushTaskId

    @PullPushTaskId.setter
    def PullPushTaskId(self, PullPushTaskId):
        self._PullPushTaskId = PullPushTaskId


    def _deserialize(self, params):
        if params.get("OutputInfo") is not None:
            self._OutputInfo = LiveStreamMonitorOutputInfo()
            self._OutputInfo._deserialize(params.get("OutputInfo"))
        if params.get("InputList") is not None:
            self._InputList = []
            for item in params.get("InputList"):
                obj = LiveStreamMonitorInputInfo()
                obj._deserialize(item)
                self._InputList.append(obj)
        self._MonitorName = params.get("MonitorName")
        if params.get("NotifyPolicy") is not None:
            self._NotifyPolicy = LiveStreamMonitorNotifyPolicy()
            self._NotifyPolicy._deserialize(params.get("NotifyPolicy"))
        self._AsrLanguage = params.get("AsrLanguage")
        self._OcrLanguage = params.get("OcrLanguage")
        self._AiAsrInputIndexList = params.get("AiAsrInputIndexList")
        self._AiOcrInputIndexList = params.get("AiOcrInputIndexList")
        self._CheckStreamBroken = params.get("CheckStreamBroken")
        self._CheckStreamLowFrameRate = params.get("CheckStreamLowFrameRate")
        self._AllowMonitorReport = params.get("AllowMonitorReport")
        self._AiFormatDiagnose = params.get("AiFormatDiagnose")
        self._AiQualityControl = params.get("AiQualityControl")
        self._CasterId = params.get("CasterId")
        self._PullPushTaskId = params.get("PullPushTaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateLiveStreamMonitorResponse(AbstractModel):
    """CreateLiveStreamMonitor返回参数结构体

    """

    def __init__(self):
        r"""
        :param _MonitorId: 监播任务ID。
        :type MonitorId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._MonitorId = None
        self._RequestId = None

    @property
    def MonitorId(self):
        """监播任务ID。
        :rtype: str
        """
        return self._MonitorId

    @MonitorId.setter
    def MonitorId(self, MonitorId):
        self._MonitorId = MonitorId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._MonitorId = params.get("MonitorId")
        self._RequestId = params.get("RequestId")


class CreateLiveTimeShiftRuleRequest(AbstractModel):
    """CreateLiveTimeShiftRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DomainName: 推流域名。
        :type DomainName: str
        :param _AppName: 推流路径，与推流和播放地址中的AppName保持一致，默认为 live。注：如果需要对所有AppName生效，可填写“*”。
        :type AppName: str
        :param _StreamName: 流名称。注：如果本参数设置为非空字符串，规则将只对此推流起作用。如果需要对所有StreamName生效，可填写“*”。
        :type StreamName: str
        :param _TemplateId: 模板 ID。
        :type TemplateId: int
        """
        self._DomainName = None
        self._AppName = None
        self._StreamName = None
        self._TemplateId = None

    @property
    def DomainName(self):
        """推流域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def AppName(self):
        """推流路径，与推流和播放地址中的AppName保持一致，默认为 live。注：如果需要对所有AppName生效，可填写“*”。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def StreamName(self):
        """流名称。注：如果本参数设置为非空字符串，规则将只对此推流起作用。如果需要对所有StreamName生效，可填写“*”。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName

    @property
    def TemplateId(self):
        """模板 ID。
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId


    def _deserialize(self, params):
        self._DomainName = params.get("DomainName")
        self._AppName = params.get("AppName")
        self._StreamName = params.get("StreamName")
        self._TemplateId = params.get("TemplateId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateLiveTimeShiftRuleResponse(AbstractModel):
    """CreateLiveTimeShiftRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateLiveTimeShiftTemplateRequest(AbstractModel):
    """CreateLiveTimeShiftTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TemplateName: 模板名称。
长度上限：255字节。
仅支持中文、英文、数字、_、-。
        :type TemplateName: str
        :param _Duration: 时移时长。
单位：s。
        :type Duration: int
        :param _Description: 描述信息。
仅支持中文、英文、数字、_、-。
        :type Description: str
        :param _Area: 地域。
Mainland：中国大陆。
Overseas：海外及港澳台地区。
默认值：Mainland。
        :type Area: str
        :param _ItemDuration: 分片时长。
可取3-10。
单位：s。
默认值：5。
        :type ItemDuration: int
        :param _RemoveWatermark: 是否去除水印。
传true则将录制原始流。
默认值：false。
        :type RemoveWatermark: bool
        :param _TranscodeTemplateIds: 转码流id列表。
此参数仅在 RemoveWatermark为false时生效。
        :type TranscodeTemplateIds: list of int
        """
        self._TemplateName = None
        self._Duration = None
        self._Description = None
        self._Area = None
        self._ItemDuration = None
        self._RemoveWatermark = None
        self._TranscodeTemplateIds = None

    @property
    def TemplateName(self):
        """模板名称。
长度上限：255字节。
仅支持中文、英文、数字、_、-。
        :rtype: str
        """
        return self._TemplateName

    @TemplateName.setter
    def TemplateName(self, TemplateName):
        self._TemplateName = TemplateName

    @property
    def Duration(self):
        """时移时长。
单位：s。
        :rtype: int
        """
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration

    @property
    def Description(self):
        """描述信息。
仅支持中文、英文、数字、_、-。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Area(self):
        """地域。
Mainland：中国大陆。
Overseas：海外及港澳台地区。
默认值：Mainland。
        :rtype: str
        """
        return self._Area

    @Area.setter
    def Area(self, Area):
        self._Area = Area

    @property
    def ItemDuration(self):
        """分片时长。
可取3-10。
单位：s。
默认值：5。
        :rtype: int
        """
        return self._ItemDuration

    @ItemDuration.setter
    def ItemDuration(self, ItemDuration):
        self._ItemDuration = ItemDuration

    @property
    def RemoveWatermark(self):
        """是否去除水印。
传true则将录制原始流。
默认值：false。
        :rtype: bool
        """
        return self._RemoveWatermark

    @RemoveWatermark.setter
    def RemoveWatermark(self, RemoveWatermark):
        self._RemoveWatermark = RemoveWatermark

    @property
    def TranscodeTemplateIds(self):
        """转码流id列表。
此参数仅在 RemoveWatermark为false时生效。
        :rtype: list of int
        """
        return self._TranscodeTemplateIds

    @TranscodeTemplateIds.setter
    def TranscodeTemplateIds(self, TranscodeTemplateIds):
        self._TranscodeTemplateIds = TranscodeTemplateIds


    def _deserialize(self, params):
        self._TemplateName = params.get("TemplateName")
        self._Duration = params.get("Duration")
        self._Description = params.get("Description")
        self._Area = params.get("Area")
        self._ItemDuration = params.get("ItemDuration")
        self._RemoveWatermark = params.get("RemoveWatermark")
        self._TranscodeTemplateIds = params.get("TranscodeTemplateIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateLiveTimeShiftTemplateResponse(AbstractModel):
    """CreateLiveTimeShiftTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TemplateId: 模板Id。
        :type TemplateId: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TemplateId = None
        self._RequestId = None

    @property
    def TemplateId(self):
        """模板Id。
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        self._RequestId = params.get("RequestId")


class CreateLiveTranscodeRuleRequest(AbstractModel):
    """CreateLiveTranscodeRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DomainName: 播放域名。
        :type DomainName: str
        :param _AppName: 推流路径，与推流和播放地址中的AppName保持一致。如果只绑定域名，则此处填""。
        :type AppName: str
        :param _StreamName: 流名称。已废弃该字段，请传入空字符串。
        :type StreamName: str
        :param _TemplateId: 指定已有的模板Id。
        :type TemplateId: int
        """
        self._DomainName = None
        self._AppName = None
        self._StreamName = None
        self._TemplateId = None

    @property
    def DomainName(self):
        """播放域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def AppName(self):
        """推流路径，与推流和播放地址中的AppName保持一致。如果只绑定域名，则此处填""。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def StreamName(self):
        """流名称。已废弃该字段，请传入空字符串。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName

    @property
    def TemplateId(self):
        """指定已有的模板Id。
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId


    def _deserialize(self, params):
        self._DomainName = params.get("DomainName")
        self._AppName = params.get("AppName")
        self._StreamName = params.get("StreamName")
        self._TemplateId = params.get("TemplateId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateLiveTranscodeRuleResponse(AbstractModel):
    """CreateLiveTranscodeRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateLiveTranscodeTemplateRequest(AbstractModel):
    """CreateLiveTranscodeTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TemplateName: 模板名称，例： 900p 仅支持字母和数字的组合。
长度限制：
  标准转码：1-10个字符
  极速高清转码：3-10个字符
        :type TemplateName: str
        :param _VideoBitrate: 视频码率。范围：0kbps - 8000kbps。
0为保持原始码率。
注: 转码模板有码率唯一要求，最终保存的码率可能与输入码率有所差别。
        :type VideoBitrate: int
        :param _Acodec: 音频编码：aac，默认aac。
注意：当前该参数未生效，待后续支持！
        :type Acodec: str
        :param _AudioBitrate: 音频码率，默认0。
范围：0-500。
        :type AudioBitrate: int
        :param _Vcodec: 视频编码：h264/h265/origin，默认origin。

origin: 保持原始编码格式
        :type Vcodec: str
        :param _Description: 模板描述。
        :type Description: str
        :param _NeedVideo: 是否保留视频，0：否，1：是。默认1。
        :type NeedVideo: int
        :param _Width: 宽，默认0。
范围[0-3000]
数值必须是2的倍数，0是原始宽度
        :type Width: int
        :param _NeedAudio: 是否保留音频，0：否，1：是。默认1。
        :type NeedAudio: int
        :param _Height: 高，默认0。
范围[0-3000]
数值必须是2的倍数，0是原始高度。
极速高清模板（AiTransCode = 1 的时候）必须传。
        :type Height: int
        :param _Fps: 帧率，默认0。
范围0-60fps
        :type Fps: int
        :param _Gop: 关键帧间隔，单位：秒。
默认原始的间隔
范围2-6
        :type Gop: int
        :param _Rotate: 旋转角度，默认0。
可取值：0，90，180，270
        :type Rotate: int
        :param _Profile: 编码质量：
baseline/main/high。默认baseline
        :type Profile: str
        :param _BitrateToOrig: 当设置的码率>原始码率时，是否以原始码率为准。
0：否， 1：是
默认 0。
        :type BitrateToOrig: int
        :param _HeightToOrig: 当设置的高度>原始高度时，是否以原始高度为准。
0：否， 1：是
默认 0。
        :type HeightToOrig: int
        :param _FpsToOrig: 当设置的帧率>原始帧率时，是否以原始帧率为准。
0：否， 1：是
默认 0。
        :type FpsToOrig: int
        :param _AiTransCode: 是否是极速高清模板，0：否，1：是。默认0。
        :type AiTransCode: int
        :param _AdaptBitratePercent: 极速高清视频码率压缩比。
极速高清目标码率=VideoBitrate * (1-AdaptBitratePercent)

取值范围：0.0到0.5
        :type AdaptBitratePercent: float
        :param _ShortEdgeAsHeight: 是否以短边作为高度，0：否，1：是。默认0。
        :type ShortEdgeAsHeight: int
        :param _DRMType: DRM 加密类型，可选值：fairplay、normalaes、widevine。
不传递或者为空字符串，清空之前的DRM配置。
        :type DRMType: str
        :param _DRMTracks: DRM 加密项，可选值：AUDIO、SD、HD、UHD1、UHD2，后四个为一组，同组中的内容只能选一个。
不传递或者为空字符串，清空之前的DRM配置。
        :type DRMTracks: str
        """
        self._TemplateName = None
        self._VideoBitrate = None
        self._Acodec = None
        self._AudioBitrate = None
        self._Vcodec = None
        self._Description = None
        self._NeedVideo = None
        self._Width = None
        self._NeedAudio = None
        self._Height = None
        self._Fps = None
        self._Gop = None
        self._Rotate = None
        self._Profile = None
        self._BitrateToOrig = None
        self._HeightToOrig = None
        self._FpsToOrig = None
        self._AiTransCode = None
        self._AdaptBitratePercent = None
        self._ShortEdgeAsHeight = None
        self._DRMType = None
        self._DRMTracks = None

    @property
    def TemplateName(self):
        """模板名称，例： 900p 仅支持字母和数字的组合。
长度限制：
  标准转码：1-10个字符
  极速高清转码：3-10个字符
        :rtype: str
        """
        return self._TemplateName

    @TemplateName.setter
    def TemplateName(self, TemplateName):
        self._TemplateName = TemplateName

    @property
    def VideoBitrate(self):
        """视频码率。范围：0kbps - 8000kbps。
0为保持原始码率。
注: 转码模板有码率唯一要求，最终保存的码率可能与输入码率有所差别。
        :rtype: int
        """
        return self._VideoBitrate

    @VideoBitrate.setter
    def VideoBitrate(self, VideoBitrate):
        self._VideoBitrate = VideoBitrate

    @property
    def Acodec(self):
        """音频编码：aac，默认aac。
注意：当前该参数未生效，待后续支持！
        :rtype: str
        """
        return self._Acodec

    @Acodec.setter
    def Acodec(self, Acodec):
        self._Acodec = Acodec

    @property
    def AudioBitrate(self):
        """音频码率，默认0。
范围：0-500。
        :rtype: int
        """
        return self._AudioBitrate

    @AudioBitrate.setter
    def AudioBitrate(self, AudioBitrate):
        self._AudioBitrate = AudioBitrate

    @property
    def Vcodec(self):
        """视频编码：h264/h265/origin，默认origin。

origin: 保持原始编码格式
        :rtype: str
        """
        return self._Vcodec

    @Vcodec.setter
    def Vcodec(self, Vcodec):
        self._Vcodec = Vcodec

    @property
    def Description(self):
        """模板描述。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def NeedVideo(self):
        """是否保留视频，0：否，1：是。默认1。
        :rtype: int
        """
        return self._NeedVideo

    @NeedVideo.setter
    def NeedVideo(self, NeedVideo):
        self._NeedVideo = NeedVideo

    @property
    def Width(self):
        """宽，默认0。
范围[0-3000]
数值必须是2的倍数，0是原始宽度
        :rtype: int
        """
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def NeedAudio(self):
        """是否保留音频，0：否，1：是。默认1。
        :rtype: int
        """
        return self._NeedAudio

    @NeedAudio.setter
    def NeedAudio(self, NeedAudio):
        self._NeedAudio = NeedAudio

    @property
    def Height(self):
        """高，默认0。
范围[0-3000]
数值必须是2的倍数，0是原始高度。
极速高清模板（AiTransCode = 1 的时候）必须传。
        :rtype: int
        """
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def Fps(self):
        """帧率，默认0。
范围0-60fps
        :rtype: int
        """
        return self._Fps

    @Fps.setter
    def Fps(self, Fps):
        self._Fps = Fps

    @property
    def Gop(self):
        """关键帧间隔，单位：秒。
默认原始的间隔
范围2-6
        :rtype: int
        """
        return self._Gop

    @Gop.setter
    def Gop(self, Gop):
        self._Gop = Gop

    @property
    def Rotate(self):
        """旋转角度，默认0。
可取值：0，90，180，270
        :rtype: int
        """
        return self._Rotate

    @Rotate.setter
    def Rotate(self, Rotate):
        self._Rotate = Rotate

    @property
    def Profile(self):
        """编码质量：
baseline/main/high。默认baseline
        :rtype: str
        """
        return self._Profile

    @Profile.setter
    def Profile(self, Profile):
        self._Profile = Profile

    @property
    def BitrateToOrig(self):
        """当设置的码率>原始码率时，是否以原始码率为准。
0：否， 1：是
默认 0。
        :rtype: int
        """
        return self._BitrateToOrig

    @BitrateToOrig.setter
    def BitrateToOrig(self, BitrateToOrig):
        self._BitrateToOrig = BitrateToOrig

    @property
    def HeightToOrig(self):
        """当设置的高度>原始高度时，是否以原始高度为准。
0：否， 1：是
默认 0。
        :rtype: int
        """
        return self._HeightToOrig

    @HeightToOrig.setter
    def HeightToOrig(self, HeightToOrig):
        self._HeightToOrig = HeightToOrig

    @property
    def FpsToOrig(self):
        """当设置的帧率>原始帧率时，是否以原始帧率为准。
0：否， 1：是
默认 0。
        :rtype: int
        """
        return self._FpsToOrig

    @FpsToOrig.setter
    def FpsToOrig(self, FpsToOrig):
        self._FpsToOrig = FpsToOrig

    @property
    def AiTransCode(self):
        """是否是极速高清模板，0：否，1：是。默认0。
        :rtype: int
        """
        return self._AiTransCode

    @AiTransCode.setter
    def AiTransCode(self, AiTransCode):
        self._AiTransCode = AiTransCode

    @property
    def AdaptBitratePercent(self):
        """极速高清视频码率压缩比。
极速高清目标码率=VideoBitrate * (1-AdaptBitratePercent)

取值范围：0.0到0.5
        :rtype: float
        """
        return self._AdaptBitratePercent

    @AdaptBitratePercent.setter
    def AdaptBitratePercent(self, AdaptBitratePercent):
        self._AdaptBitratePercent = AdaptBitratePercent

    @property
    def ShortEdgeAsHeight(self):
        """是否以短边作为高度，0：否，1：是。默认0。
        :rtype: int
        """
        return self._ShortEdgeAsHeight

    @ShortEdgeAsHeight.setter
    def ShortEdgeAsHeight(self, ShortEdgeAsHeight):
        self._ShortEdgeAsHeight = ShortEdgeAsHeight

    @property
    def DRMType(self):
        """DRM 加密类型，可选值：fairplay、normalaes、widevine。
不传递或者为空字符串，清空之前的DRM配置。
        :rtype: str
        """
        return self._DRMType

    @DRMType.setter
    def DRMType(self, DRMType):
        self._DRMType = DRMType

    @property
    def DRMTracks(self):
        """DRM 加密项，可选值：AUDIO、SD、HD、UHD1、UHD2，后四个为一组，同组中的内容只能选一个。
不传递或者为空字符串，清空之前的DRM配置。
        :rtype: str
        """
        return self._DRMTracks

    @DRMTracks.setter
    def DRMTracks(self, DRMTracks):
        self._DRMTracks = DRMTracks


    def _deserialize(self, params):
        self._TemplateName = params.get("TemplateName")
        self._VideoBitrate = params.get("VideoBitrate")
        self._Acodec = params.get("Acodec")
        self._AudioBitrate = params.get("AudioBitrate")
        self._Vcodec = params.get("Vcodec")
        self._Description = params.get("Description")
        self._NeedVideo = params.get("NeedVideo")
        self._Width = params.get("Width")
        self._NeedAudio = params.get("NeedAudio")
        self._Height = params.get("Height")
        self._Fps = params.get("Fps")
        self._Gop = params.get("Gop")
        self._Rotate = params.get("Rotate")
        self._Profile = params.get("Profile")
        self._BitrateToOrig = params.get("BitrateToOrig")
        self._HeightToOrig = params.get("HeightToOrig")
        self._FpsToOrig = params.get("FpsToOrig")
        self._AiTransCode = params.get("AiTransCode")
        self._AdaptBitratePercent = params.get("AdaptBitratePercent")
        self._ShortEdgeAsHeight = params.get("ShortEdgeAsHeight")
        self._DRMType = params.get("DRMType")
        self._DRMTracks = params.get("DRMTracks")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateLiveTranscodeTemplateResponse(AbstractModel):
    """CreateLiveTranscodeTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TemplateId: 模板Id。
        :type TemplateId: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TemplateId = None
        self._RequestId = None

    @property
    def TemplateId(self):
        """模板Id。
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        self._RequestId = params.get("RequestId")


class CreateLiveWatermarkRuleRequest(AbstractModel):
    """CreateLiveWatermarkRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DomainName: 推流域名。
        :type DomainName: str
        :param _AppName: 推流路径，与推流和播放地址中的AppName保持一致，默认为live。
        :type AppName: str
        :param _StreamName: 流名称。
        :type StreamName: str
        :param _TemplateId: 水印Id，即调用[AddLiveWatermark](/document/product/267/30154)接口返回的WatermarkId。
        :type TemplateId: int
        """
        self._DomainName = None
        self._AppName = None
        self._StreamName = None
        self._TemplateId = None

    @property
    def DomainName(self):
        """推流域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def AppName(self):
        """推流路径，与推流和播放地址中的AppName保持一致，默认为live。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def StreamName(self):
        """流名称。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName

    @property
    def TemplateId(self):
        """水印Id，即调用[AddLiveWatermark](/document/product/267/30154)接口返回的WatermarkId。
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId


    def _deserialize(self, params):
        self._DomainName = params.get("DomainName")
        self._AppName = params.get("AppName")
        self._StreamName = params.get("StreamName")
        self._TemplateId = params.get("TemplateId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateLiveWatermarkRuleResponse(AbstractModel):
    """CreateLiveWatermarkRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreatePullStreamConfigRequest(AbstractModel):
    """CreatePullStreamConfig请求参数结构体

    """

    def __init__(self):
        r"""
        :param _FromUrl: 源 Url ，用于拉流的地址。目前可支持直播流及点播文件。
注意：
1. 多个点播url之间使用空格拼接。
2. 目前上限支持10个url。
3. 目前不支持https协议。
4. 支持拉流文件格式：flv，rtmp，hls，mp4。
        :type FromUrl: str
        :param _ToUrl: 目的 Url ，用于推流的地址，目前限制该目标地址为腾讯域名。
仅支持：rtmp 协议。
        :type ToUrl: str
        :param _AreaId: 选择完成转拉推的服务所在区域:
1-深圳，
2-上海，
3-天津，
4-中国香港。
        :type AreaId: int
        :param _IspId: 选择完成转拉推服务使用的运营商网络：
1-电信，
2-移动，
3-联通，
4-其他。
注：AreaId 为4的时候，IspId 只能为其他。
        :type IspId: int
        :param _StartTime: 开始时间。
使用 UTC 格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :type StartTime: str
        :param _EndTime: 结束时间，注意：
1. 结束时间必须大于开始时间；
2. 结束时间和开始时间必须大于当前时间；
3. 结束时间 和 开始时间 间隔必须小于七天。
使用 UTC 格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :type EndTime: str
        """
        self._FromUrl = None
        self._ToUrl = None
        self._AreaId = None
        self._IspId = None
        self._StartTime = None
        self._EndTime = None

    @property
    def FromUrl(self):
        """源 Url ，用于拉流的地址。目前可支持直播流及点播文件。
注意：
1. 多个点播url之间使用空格拼接。
2. 目前上限支持10个url。
3. 目前不支持https协议。
4. 支持拉流文件格式：flv，rtmp，hls，mp4。
        :rtype: str
        """
        return self._FromUrl

    @FromUrl.setter
    def FromUrl(self, FromUrl):
        self._FromUrl = FromUrl

    @property
    def ToUrl(self):
        """目的 Url ，用于推流的地址，目前限制该目标地址为腾讯域名。
仅支持：rtmp 协议。
        :rtype: str
        """
        return self._ToUrl

    @ToUrl.setter
    def ToUrl(self, ToUrl):
        self._ToUrl = ToUrl

    @property
    def AreaId(self):
        """选择完成转拉推的服务所在区域:
1-深圳，
2-上海，
3-天津，
4-中国香港。
        :rtype: int
        """
        return self._AreaId

    @AreaId.setter
    def AreaId(self, AreaId):
        self._AreaId = AreaId

    @property
    def IspId(self):
        """选择完成转拉推服务使用的运营商网络：
1-电信，
2-移动，
3-联通，
4-其他。
注：AreaId 为4的时候，IspId 只能为其他。
        :rtype: int
        """
        return self._IspId

    @IspId.setter
    def IspId(self, IspId):
        self._IspId = IspId

    @property
    def StartTime(self):
        """开始时间。
使用 UTC 格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束时间，注意：
1. 结束时间必须大于开始时间；
2. 结束时间和开始时间必须大于当前时间；
3. 结束时间 和 开始时间 间隔必须小于七天。
使用 UTC 格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._FromUrl = params.get("FromUrl")
        self._ToUrl = params.get("ToUrl")
        self._AreaId = params.get("AreaId")
        self._IspId = params.get("IspId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreatePullStreamConfigResponse(AbstractModel):
    """CreatePullStreamConfig返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ConfigId: 配置成功后的 ID。
        :type ConfigId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ConfigId = None
        self._RequestId = None

    @property
    def ConfigId(self):
        """配置成功后的 ID。
        :rtype: str
        """
        return self._ConfigId

    @ConfigId.setter
    def ConfigId(self, ConfigId):
        self._ConfigId = ConfigId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ConfigId = params.get("ConfigId")
        self._RequestId = params.get("RequestId")


class CreateRecordTaskRequest(AbstractModel):
    """CreateRecordTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StreamName: 流名称。
        :type StreamName: str
        :param _DomainName: 推流域名。
        :type DomainName: str
        :param _AppName: 推流路径。
        :type AppName: str
        :param _EndTime: 录制任务结束时间，Unix时间戳。设置时间必须大于StartTime及当前时间，且小于当前时间+7天。
        :type EndTime: int
        :param _StartTime: 录制任务开始时间，Unix时间戳。如果不填表示立即启动录制。EndTime - StartTime不能超过24小时。
        :type StartTime: int
        :param _StreamType: 推流类型，默认0。取值：
0-直播推流。
1-合成流，即 A+B=C 类型混流。
        :type StreamType: int
        :param _TemplateId: 录制模板ID，CreateLiveRecordTemplate 返回值。如果不填或者传入错误ID，则默认录制HLS格式、永久存储。
        :type TemplateId: int
        :param _Extension: 扩展字段，暂无定义。默认为空。
        :type Extension: str
        """
        self._StreamName = None
        self._DomainName = None
        self._AppName = None
        self._EndTime = None
        self._StartTime = None
        self._StreamType = None
        self._TemplateId = None
        self._Extension = None

    @property
    def StreamName(self):
        """流名称。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName

    @property
    def DomainName(self):
        """推流域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def AppName(self):
        """推流路径。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def EndTime(self):
        """录制任务结束时间，Unix时间戳。设置时间必须大于StartTime及当前时间，且小于当前时间+7天。
        :rtype: int
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def StartTime(self):
        """录制任务开始时间，Unix时间戳。如果不填表示立即启动录制。EndTime - StartTime不能超过24小时。
        :rtype: int
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def StreamType(self):
        """推流类型，默认0。取值：
0-直播推流。
1-合成流，即 A+B=C 类型混流。
        :rtype: int
        """
        return self._StreamType

    @StreamType.setter
    def StreamType(self, StreamType):
        self._StreamType = StreamType

    @property
    def TemplateId(self):
        """录制模板ID，CreateLiveRecordTemplate 返回值。如果不填或者传入错误ID，则默认录制HLS格式、永久存储。
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId

    @property
    def Extension(self):
        """扩展字段，暂无定义。默认为空。
        :rtype: str
        """
        return self._Extension

    @Extension.setter
    def Extension(self, Extension):
        self._Extension = Extension


    def _deserialize(self, params):
        self._StreamName = params.get("StreamName")
        self._DomainName = params.get("DomainName")
        self._AppName = params.get("AppName")
        self._EndTime = params.get("EndTime")
        self._StartTime = params.get("StartTime")
        self._StreamType = params.get("StreamType")
        self._TemplateId = params.get("TemplateId")
        self._Extension = params.get("Extension")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRecordTaskResponse(AbstractModel):
    """CreateRecordTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务ID，全局唯一标识录制任务。返回TaskId字段说明录制任务创建成功。
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        """任务ID，全局唯一标识录制任务。返回TaskId字段说明录制任务创建成功。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class CreateScreenshotTaskRequest(AbstractModel):
    """CreateScreenshotTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StreamName: 流名称。
        :type StreamName: str
        :param _DomainName: 推流域名。
        :type DomainName: str
        :param _AppName: 推流路径。
        :type AppName: str
        :param _EndTime: 截图任务结束时间，Unix时间戳。设置时间必须大于StartTime及当前时间，且小于当前时间+7天。
        :type EndTime: int
        :param _TemplateId: 截图模板ID，CreateLiveSnapshotTemplate 返回值。如果传入错误ID，则不拉起截图。
        :type TemplateId: int
        :param _StartTime: 截图任务开始时间，Unix时间戳。如果不填表示立即启动截图。EndTime - StartTime不能超过24小时。
        :type StartTime: int
        :param _StreamType: 推流类型，默认0。取值：
0-直播推流。
1-合成流，即 A+B=C 类型混流。
        :type StreamType: int
        :param _Extension: 扩展字段，暂无定义。默认为空。
        :type Extension: str
        """
        self._StreamName = None
        self._DomainName = None
        self._AppName = None
        self._EndTime = None
        self._TemplateId = None
        self._StartTime = None
        self._StreamType = None
        self._Extension = None

    @property
    def StreamName(self):
        """流名称。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName

    @property
    def DomainName(self):
        """推流域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def AppName(self):
        """推流路径。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def EndTime(self):
        """截图任务结束时间，Unix时间戳。设置时间必须大于StartTime及当前时间，且小于当前时间+7天。
        :rtype: int
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def TemplateId(self):
        """截图模板ID，CreateLiveSnapshotTemplate 返回值。如果传入错误ID，则不拉起截图。
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId

    @property
    def StartTime(self):
        """截图任务开始时间，Unix时间戳。如果不填表示立即启动截图。EndTime - StartTime不能超过24小时。
        :rtype: int
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def StreamType(self):
        """推流类型，默认0。取值：
0-直播推流。
1-合成流，即 A+B=C 类型混流。
        :rtype: int
        """
        return self._StreamType

    @StreamType.setter
    def StreamType(self, StreamType):
        self._StreamType = StreamType

    @property
    def Extension(self):
        """扩展字段，暂无定义。默认为空。
        :rtype: str
        """
        return self._Extension

    @Extension.setter
    def Extension(self, Extension):
        self._Extension = Extension


    def _deserialize(self, params):
        self._StreamName = params.get("StreamName")
        self._DomainName = params.get("DomainName")
        self._AppName = params.get("AppName")
        self._EndTime = params.get("EndTime")
        self._TemplateId = params.get("TemplateId")
        self._StartTime = params.get("StartTime")
        self._StreamType = params.get("StreamType")
        self._Extension = params.get("Extension")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateScreenshotTaskResponse(AbstractModel):
    """CreateScreenshotTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务ID，全局唯一标识截图任务。返回TaskId字段说明截图任务创建成功。
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        """任务ID，全局唯一标识截图任务。返回TaskId字段说明截图任务创建成功。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class DayStreamPlayInfo(AbstractModel):
    """流播放信息

    """

    def __init__(self):
        r"""
        :param _Time: 数据时间点，接口返回支持两种时间格式：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见ISO日期格式说明文档: https://cloud.tencent.com/document/product/266/11732#I
2）yyyy-MM-dd HH:mm:ss：使用此格式时，默认代表北京时间。
接口返回的时间格式和查询请求传入的时间格式一致。
        :type Time: str
        :param _Bandwidth: 带宽（单位Mbps）。
        :type Bandwidth: float
        :param _Flux: 流量 （单位MB）。
        :type Flux: float
        :param _Request: 请求数。
        :type Request: int
        :param _Online: 在线人数。当前后端接口数据的统计方式与客户端侧不同，该数据仅供参考，具体数据请以业务客户端侧统计数据为准。
        :type Online: int
        """
        self._Time = None
        self._Bandwidth = None
        self._Flux = None
        self._Request = None
        self._Online = None

    @property
    def Time(self):
        """数据时间点，接口返回支持两种时间格式：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见ISO日期格式说明文档: https://cloud.tencent.com/document/product/266/11732#I
2）yyyy-MM-dd HH:mm:ss：使用此格式时，默认代表北京时间。
接口返回的时间格式和查询请求传入的时间格式一致。
        :rtype: str
        """
        return self._Time

    @Time.setter
    def Time(self, Time):
        self._Time = Time

    @property
    def Bandwidth(self):
        """带宽（单位Mbps）。
        :rtype: float
        """
        return self._Bandwidth

    @Bandwidth.setter
    def Bandwidth(self, Bandwidth):
        self._Bandwidth = Bandwidth

    @property
    def Flux(self):
        """流量 （单位MB）。
        :rtype: float
        """
        return self._Flux

    @Flux.setter
    def Flux(self, Flux):
        self._Flux = Flux

    @property
    def Request(self):
        """请求数。
        :rtype: int
        """
        return self._Request

    @Request.setter
    def Request(self, Request):
        self._Request = Request

    @property
    def Online(self):
        """在线人数。当前后端接口数据的统计方式与客户端侧不同，该数据仅供参考，具体数据请以业务客户端侧统计数据为准。
        :rtype: int
        """
        return self._Online

    @Online.setter
    def Online(self, Online):
        self._Online = Online


    def _deserialize(self, params):
        self._Time = params.get("Time")
        self._Bandwidth = params.get("Bandwidth")
        self._Flux = params.get("Flux")
        self._Request = params.get("Request")
        self._Online = params.get("Online")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DelayInfo(AbstractModel):
    """延播信息。

    """

    def __init__(self):
        r"""
        :param _DomainName: 推流域名。
        :type DomainName: str
        :param _AppName: 推流路径，与推流和播放地址中的 
 AppName 保持一致，默认为 live。
        :type AppName: str
        :param _StreamName: 流名称。
        :type StreamName: str
        :param _DelayInterval: 延播时间，单位：秒。
        :type DelayInterval: int
        :param _CreateTime: 创建时间，UTC 时间。
注意：UTC时间和北京时间相差8小时。
例如：2019-06-18T12:00:00Z（为北京时间 2019 年 6 月 18 日 20 点 0 分 0 秒）。
        :type CreateTime: str
        :param _ExpireTime: 过期时间，UTC 时间。
注意：UTC时间和北京时间相差8小时。
例如：2019-06-18T12:00:00Z（为北京时间 2019 年 6 月 18 日 20 点 0 分 0 秒）。
        :type ExpireTime: str
        :param _Status: 当前状态:
-1：已过期。
1： 生效中。
        :type Status: int
        """
        self._DomainName = None
        self._AppName = None
        self._StreamName = None
        self._DelayInterval = None
        self._CreateTime = None
        self._ExpireTime = None
        self._Status = None

    @property
    def DomainName(self):
        """推流域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def AppName(self):
        """推流路径，与推流和播放地址中的 
 AppName 保持一致，默认为 live。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def StreamName(self):
        """流名称。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName

    @property
    def DelayInterval(self):
        """延播时间，单位：秒。
        :rtype: int
        """
        return self._DelayInterval

    @DelayInterval.setter
    def DelayInterval(self, DelayInterval):
        self._DelayInterval = DelayInterval

    @property
    def CreateTime(self):
        """创建时间，UTC 时间。
注意：UTC时间和北京时间相差8小时。
例如：2019-06-18T12:00:00Z（为北京时间 2019 年 6 月 18 日 20 点 0 分 0 秒）。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ExpireTime(self):
        """过期时间，UTC 时间。
注意：UTC时间和北京时间相差8小时。
例如：2019-06-18T12:00:00Z（为北京时间 2019 年 6 月 18 日 20 点 0 分 0 秒）。
        :rtype: str
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def Status(self):
        """当前状态:
-1：已过期。
1： 生效中。
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._DomainName = params.get("DomainName")
        self._AppName = params.get("AppName")
        self._StreamName = params.get("StreamName")
        self._DelayInterval = params.get("DelayInterval")
        self._CreateTime = params.get("CreateTime")
        self._ExpireTime = params.get("ExpireTime")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCasterInputInfoRequest(AbstractModel):
    """DeleteCasterInputInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CasterId: 导播台ID
        :type CasterId: int
        :param _InputIndex: 导播台输入Index。
范围[0,20]
注：该Index对应的输入源需存在。
        :type InputIndex: int
        """
        self._CasterId = None
        self._InputIndex = None

    @property
    def CasterId(self):
        """导播台ID
        :rtype: int
        """
        return self._CasterId

    @CasterId.setter
    def CasterId(self, CasterId):
        self._CasterId = CasterId

    @property
    def InputIndex(self):
        """导播台输入Index。
范围[0,20]
注：该Index对应的输入源需存在。
        :rtype: int
        """
        return self._InputIndex

    @InputIndex.setter
    def InputIndex(self, InputIndex):
        self._InputIndex = InputIndex


    def _deserialize(self, params):
        self._CasterId = params.get("CasterId")
        self._InputIndex = params.get("InputIndex")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCasterInputInfoResponse(AbstractModel):
    """DeleteCasterInputInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteCasterLayoutInfoRequest(AbstractModel):
    """DeleteCasterLayoutInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CasterId: 导播台ID。
        :type CasterId: int
        :param _LayoutIndex: 要删除的布局Index。
注：待删除的Index对应的布局需存在。
        :type LayoutIndex: int
        """
        self._CasterId = None
        self._LayoutIndex = None

    @property
    def CasterId(self):
        """导播台ID。
        :rtype: int
        """
        return self._CasterId

    @CasterId.setter
    def CasterId(self, CasterId):
        self._CasterId = CasterId

    @property
    def LayoutIndex(self):
        """要删除的布局Index。
注：待删除的Index对应的布局需存在。
        :rtype: int
        """
        return self._LayoutIndex

    @LayoutIndex.setter
    def LayoutIndex(self, LayoutIndex):
        self._LayoutIndex = LayoutIndex


    def _deserialize(self, params):
        self._CasterId = params.get("CasterId")
        self._LayoutIndex = params.get("LayoutIndex")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCasterLayoutInfoResponse(AbstractModel):
    """DeleteCasterLayoutInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteCasterMarkPicInfoRequest(AbstractModel):
    """DeleteCasterMarkPicInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CasterId: 导播台ID。
        :type CasterId: int
        :param _MarkPicIndex: 需要删除的水印Index。
        :type MarkPicIndex: int
        """
        self._CasterId = None
        self._MarkPicIndex = None

    @property
    def CasterId(self):
        """导播台ID。
        :rtype: int
        """
        return self._CasterId

    @CasterId.setter
    def CasterId(self, CasterId):
        self._CasterId = CasterId

    @property
    def MarkPicIndex(self):
        """需要删除的水印Index。
        :rtype: int
        """
        return self._MarkPicIndex

    @MarkPicIndex.setter
    def MarkPicIndex(self, MarkPicIndex):
        self._MarkPicIndex = MarkPicIndex


    def _deserialize(self, params):
        self._CasterId = params.get("CasterId")
        self._MarkPicIndex = params.get("MarkPicIndex")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCasterMarkPicInfoResponse(AbstractModel):
    """DeleteCasterMarkPicInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteCasterMarkWordInfoRequest(AbstractModel):
    """DeleteCasterMarkWordInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CasterId: 导播台ID。
        :type CasterId: int
        :param _MarkWordIndex: 需要删除的文字水印Index。
        :type MarkWordIndex: int
        """
        self._CasterId = None
        self._MarkWordIndex = None

    @property
    def CasterId(self):
        """导播台ID。
        :rtype: int
        """
        return self._CasterId

    @CasterId.setter
    def CasterId(self, CasterId):
        self._CasterId = CasterId

    @property
    def MarkWordIndex(self):
        """需要删除的文字水印Index。
        :rtype: int
        """
        return self._MarkWordIndex

    @MarkWordIndex.setter
    def MarkWordIndex(self, MarkWordIndex):
        self._MarkWordIndex = MarkWordIndex


    def _deserialize(self, params):
        self._CasterId = params.get("CasterId")
        self._MarkWordIndex = params.get("MarkWordIndex")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCasterMarkWordInfoResponse(AbstractModel):
    """DeleteCasterMarkWordInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteCasterOutputInfoRequest(AbstractModel):
    """DeleteCasterOutputInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CasterId: 导播台ID。
        :type CasterId: int
        :param _OutputIndex: 待删除的推流信息Index。
注：删除时，该Index对应的配置需要存在。
        :type OutputIndex: int
        """
        self._CasterId = None
        self._OutputIndex = None

    @property
    def CasterId(self):
        """导播台ID。
        :rtype: int
        """
        return self._CasterId

    @CasterId.setter
    def CasterId(self, CasterId):
        self._CasterId = CasterId

    @property
    def OutputIndex(self):
        """待删除的推流信息Index。
注：删除时，该Index对应的配置需要存在。
        :rtype: int
        """
        return self._OutputIndex

    @OutputIndex.setter
    def OutputIndex(self, OutputIndex):
        self._OutputIndex = OutputIndex


    def _deserialize(self, params):
        self._CasterId = params.get("CasterId")
        self._OutputIndex = params.get("OutputIndex")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCasterOutputInfoResponse(AbstractModel):
    """DeleteCasterOutputInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteCasterRequest(AbstractModel):
    """DeleteCaster请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CasterId: 待删除的导播台ID
        :type CasterId: int
        """
        self._CasterId = None

    @property
    def CasterId(self):
        """待删除的导播台ID
        :rtype: int
        """
        return self._CasterId

    @CasterId.setter
    def CasterId(self, CasterId):
        self._CasterId = CasterId


    def _deserialize(self, params):
        self._CasterId = params.get("CasterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCasterResponse(AbstractModel):
    """DeleteCaster返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteLiveCallbackRuleRequest(AbstractModel):
    """DeleteLiveCallbackRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DomainName: 推流域名。
        :type DomainName: str
        :param _AppName: 推流路径，与推流和播放地址中的 AppName 保持一致，默认为 live。
        :type AppName: str
        """
        self._DomainName = None
        self._AppName = None

    @property
    def DomainName(self):
        """推流域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def AppName(self):
        """推流路径，与推流和播放地址中的 AppName 保持一致，默认为 live。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName


    def _deserialize(self, params):
        self._DomainName = params.get("DomainName")
        self._AppName = params.get("AppName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteLiveCallbackRuleResponse(AbstractModel):
    """DeleteLiveCallbackRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteLiveCallbackTemplateRequest(AbstractModel):
    """DeleteLiveCallbackTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TemplateId: 模板 ID。
1. 在创建回调模板接口 [CreateLiveCallbackTemplate](/document/product/267/32637) 调用的返回值中获取模板 ID。
2. 可以从接口 [DescribeLiveCallbackTemplates](/document/product/267/32632) 查询已经创建的过的模板列表。
        :type TemplateId: int
        """
        self._TemplateId = None

    @property
    def TemplateId(self):
        """模板 ID。
1. 在创建回调模板接口 [CreateLiveCallbackTemplate](/document/product/267/32637) 调用的返回值中获取模板 ID。
2. 可以从接口 [DescribeLiveCallbackTemplates](/document/product/267/32632) 查询已经创建的过的模板列表。
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteLiveCallbackTemplateResponse(AbstractModel):
    """DeleteLiveCallbackTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteLiveDomainRequest(AbstractModel):
    """DeleteLiveDomain请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DomainName: 要删除的域名
        :type DomainName: str
        :param _DomainType: 类型。0-推流，1-播放
        :type DomainType: int
        """
        self._DomainName = None
        self._DomainType = None

    @property
    def DomainName(self):
        """要删除的域名
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def DomainType(self):
        """类型。0-推流，1-播放
        :rtype: int
        """
        return self._DomainType

    @DomainType.setter
    def DomainType(self, DomainType):
        self._DomainType = DomainType


    def _deserialize(self, params):
        self._DomainName = params.get("DomainName")
        self._DomainType = params.get("DomainType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteLiveDomainResponse(AbstractModel):
    """DeleteLiveDomain返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteLivePadRuleRequest(AbstractModel):
    """DeleteLivePadRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DomainName: 推流域名。
域名+AppName+StreamName唯一标识单个转码规则，如需删除需要强匹配，例如AppName为空也需要传空字符串进行强匹配。
        :type DomainName: str
        :param _AppName: 推流路径，与推流和播放地址中的AppName保持一致，默认为 live。
域名+AppName+StreamName唯一标识单个转码规则，如需删除需要强匹配，例如AppName为空也需要传空字符串进行强匹配。
        :type AppName: str
        :param _StreamName: 流名称。
域名+AppName+StreamName唯一标识单个转码规则，如需删除需要强匹配，例如AppName为空也需要传空字符串进行强匹配。
        :type StreamName: str
        :param _TemplateId: 直播垫片模板id。
        :type TemplateId: int
        """
        self._DomainName = None
        self._AppName = None
        self._StreamName = None
        self._TemplateId = None

    @property
    def DomainName(self):
        """推流域名。
域名+AppName+StreamName唯一标识单个转码规则，如需删除需要强匹配，例如AppName为空也需要传空字符串进行强匹配。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def AppName(self):
        """推流路径，与推流和播放地址中的AppName保持一致，默认为 live。
域名+AppName+StreamName唯一标识单个转码规则，如需删除需要强匹配，例如AppName为空也需要传空字符串进行强匹配。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def StreamName(self):
        """流名称。
域名+AppName+StreamName唯一标识单个转码规则，如需删除需要强匹配，例如AppName为空也需要传空字符串进行强匹配。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName

    @property
    def TemplateId(self):
        """直播垫片模板id。
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId


    def _deserialize(self, params):
        self._DomainName = params.get("DomainName")
        self._AppName = params.get("AppName")
        self._StreamName = params.get("StreamName")
        self._TemplateId = params.get("TemplateId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteLivePadRuleResponse(AbstractModel):
    """DeleteLivePadRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteLivePadTemplateRequest(AbstractModel):
    """DeleteLivePadTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TemplateId: 模板 ID。
        :type TemplateId: int
        """
        self._TemplateId = None

    @property
    def TemplateId(self):
        """模板 ID。
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteLivePadTemplateResponse(AbstractModel):
    """DeleteLivePadTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteLivePullStreamTaskRequest(AbstractModel):
    """DeleteLivePullStreamTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务 Id。
        :type TaskId: str
        :param _Operator: 操作人姓名。
        :type Operator: str
        :param _SpecifyTaskId: 指定任务 ID。注意：用于删除使用自定义任务 ID 创建的任务。
        :type SpecifyTaskId: str
        """
        self._TaskId = None
        self._Operator = None
        self._SpecifyTaskId = None

    @property
    def TaskId(self):
        """任务 Id。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Operator(self):
        """操作人姓名。
        :rtype: str
        """
        return self._Operator

    @Operator.setter
    def Operator(self, Operator):
        self._Operator = Operator

    @property
    def SpecifyTaskId(self):
        """指定任务 ID。注意：用于删除使用自定义任务 ID 创建的任务。
        :rtype: str
        """
        return self._SpecifyTaskId

    @SpecifyTaskId.setter
    def SpecifyTaskId(self, SpecifyTaskId):
        self._SpecifyTaskId = SpecifyTaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Operator = params.get("Operator")
        self._SpecifyTaskId = params.get("SpecifyTaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteLivePullStreamTaskResponse(AbstractModel):
    """DeleteLivePullStreamTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteLiveRecordRequest(AbstractModel):
    """DeleteLiveRecord请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StreamName: 流名称。
        :type StreamName: str
        :param _TaskId: 任务ID，由CreateLiveRecord接口返回。
        :type TaskId: int
        """
        self._StreamName = None
        self._TaskId = None

    @property
    def StreamName(self):
        """流名称。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName

    @property
    def TaskId(self):
        """任务ID，由CreateLiveRecord接口返回。
        :rtype: int
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._StreamName = params.get("StreamName")
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteLiveRecordResponse(AbstractModel):
    """DeleteLiveRecord返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteLiveRecordRuleRequest(AbstractModel):
    """DeleteLiveRecordRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DomainName: 推流域名。
域名+AppName+StreamName唯一标识单个转码规则，如需删除需要强匹配，例如AppName为空也需要传空字符串进行强匹配。
        :type DomainName: str
        :param _AppName: 推流路径，与推流和播放地址中的AppName保持一致，默认为 live。
域名+AppName+StreamName唯一标识单个转码规则，如需删除需要强匹配，例如AppName为空也需要传空字符串进行强匹配。
        :type AppName: str
        :param _StreamName: 流名称。
域名+AppName+StreamName唯一标识单个转码规则，如需删除需要强匹配，例如AppName为空也需要传空字符串进行强匹配。
        :type StreamName: str
        """
        self._DomainName = None
        self._AppName = None
        self._StreamName = None

    @property
    def DomainName(self):
        """推流域名。
域名+AppName+StreamName唯一标识单个转码规则，如需删除需要强匹配，例如AppName为空也需要传空字符串进行强匹配。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def AppName(self):
        """推流路径，与推流和播放地址中的AppName保持一致，默认为 live。
域名+AppName+StreamName唯一标识单个转码规则，如需删除需要强匹配，例如AppName为空也需要传空字符串进行强匹配。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def StreamName(self):
        """流名称。
域名+AppName+StreamName唯一标识单个转码规则，如需删除需要强匹配，例如AppName为空也需要传空字符串进行强匹配。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName


    def _deserialize(self, params):
        self._DomainName = params.get("DomainName")
        self._AppName = params.get("AppName")
        self._StreamName = params.get("StreamName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteLiveRecordRuleResponse(AbstractModel):
    """DeleteLiveRecordRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteLiveRecordTemplateRequest(AbstractModel):
    """DeleteLiveRecordTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TemplateId: DescribeRecordTemplates接口获取到的模板 ID。
        :type TemplateId: int
        """
        self._TemplateId = None

    @property
    def TemplateId(self):
        """DescribeRecordTemplates接口获取到的模板 ID。
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteLiveRecordTemplateResponse(AbstractModel):
    """DeleteLiveRecordTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteLiveSnapshotRuleRequest(AbstractModel):
    """DeleteLiveSnapshotRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DomainName: 推流域名。
        :type DomainName: str
        :param _AppName: 推流路径，与推流和播放地址中的 AppName 保持一致，默认为 live。
        :type AppName: str
        :param _StreamName: 流名称。
        :type StreamName: str
        """
        self._DomainName = None
        self._AppName = None
        self._StreamName = None

    @property
    def DomainName(self):
        """推流域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def AppName(self):
        """推流路径，与推流和播放地址中的 AppName 保持一致，默认为 live。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def StreamName(self):
        """流名称。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName


    def _deserialize(self, params):
        self._DomainName = params.get("DomainName")
        self._AppName = params.get("AppName")
        self._StreamName = params.get("StreamName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteLiveSnapshotRuleResponse(AbstractModel):
    """DeleteLiveSnapshotRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteLiveSnapshotTemplateRequest(AbstractModel):
    """DeleteLiveSnapshotTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TemplateId: 模板 ID。
1. 在创建截图模板接口 [CreateLiveSnapshotTemplate](/document/product/267/32624) 调用的返回值中获取。
2. 可以从接口 [DescribeLiveSnapshotTemplates](/document/product/267/32619) 中查询已创建的截图模板列表。
        :type TemplateId: int
        """
        self._TemplateId = None

    @property
    def TemplateId(self):
        """模板 ID。
1. 在创建截图模板接口 [CreateLiveSnapshotTemplate](/document/product/267/32624) 调用的返回值中获取。
2. 可以从接口 [DescribeLiveSnapshotTemplates](/document/product/267/32619) 中查询已创建的截图模板列表。
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteLiveSnapshotTemplateResponse(AbstractModel):
    """DeleteLiveSnapshotTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteLiveStreamMonitorRequest(AbstractModel):
    """DeleteLiveStreamMonitor请求参数结构体

    """

    def __init__(self):
        r"""
        :param _MonitorId: 监播任务ID
        :type MonitorId: str
        """
        self._MonitorId = None

    @property
    def MonitorId(self):
        """监播任务ID
        :rtype: str
        """
        return self._MonitorId

    @MonitorId.setter
    def MonitorId(self, MonitorId):
        self._MonitorId = MonitorId


    def _deserialize(self, params):
        self._MonitorId = params.get("MonitorId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteLiveStreamMonitorResponse(AbstractModel):
    """DeleteLiveStreamMonitor返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteLiveTimeShiftRuleRequest(AbstractModel):
    """DeleteLiveTimeShiftRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DomainName: 推流域名。
域名+AppName+StreamName唯一标识单个时移规则，如需删除需要强匹配，例如AppName为空也需要传空字符串进行强匹配。
        :type DomainName: str
        :param _AppName: 推流路径，与推流和播放地址中的AppName保持一致，默认为 live。
域名+AppName+StreamName唯一标识单个时移规则，如需删除需要强匹配，例如AppName为空也需要传空字符串进行强匹配。
        :type AppName: str
        :param _StreamName: 流名称。
域名+AppName+StreamName唯一标识单个时移规则，如需删除需要强匹配，例如AppName为空也需要传空字符串进行强匹配。
        :type StreamName: str
        """
        self._DomainName = None
        self._AppName = None
        self._StreamName = None

    @property
    def DomainName(self):
        """推流域名。
域名+AppName+StreamName唯一标识单个时移规则，如需删除需要强匹配，例如AppName为空也需要传空字符串进行强匹配。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def AppName(self):
        """推流路径，与推流和播放地址中的AppName保持一致，默认为 live。
域名+AppName+StreamName唯一标识单个时移规则，如需删除需要强匹配，例如AppName为空也需要传空字符串进行强匹配。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def StreamName(self):
        """流名称。
域名+AppName+StreamName唯一标识单个时移规则，如需删除需要强匹配，例如AppName为空也需要传空字符串进行强匹配。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName


    def _deserialize(self, params):
        self._DomainName = params.get("DomainName")
        self._AppName = params.get("AppName")
        self._StreamName = params.get("StreamName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteLiveTimeShiftRuleResponse(AbstractModel):
    """DeleteLiveTimeShiftRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteLiveTimeShiftTemplateRequest(AbstractModel):
    """DeleteLiveTimeShiftTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TemplateId: 模板 ID。
        :type TemplateId: int
        """
        self._TemplateId = None

    @property
    def TemplateId(self):
        """模板 ID。
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteLiveTimeShiftTemplateResponse(AbstractModel):
    """DeleteLiveTimeShiftTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteLiveTranscodeRuleRequest(AbstractModel):
    """DeleteLiveTranscodeRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DomainName: 播放域名。
        :type DomainName: str
        :param _AppName: 推流路径，与推流和播放地址中的AppName保持一致，默认为 live。
        :type AppName: str
        :param _StreamName: 流名称。
        :type StreamName: str
        :param _TemplateId: 模板ID。
        :type TemplateId: int
        """
        self._DomainName = None
        self._AppName = None
        self._StreamName = None
        self._TemplateId = None

    @property
    def DomainName(self):
        """播放域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def AppName(self):
        """推流路径，与推流和播放地址中的AppName保持一致，默认为 live。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def StreamName(self):
        """流名称。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName

    @property
    def TemplateId(self):
        """模板ID。
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId


    def _deserialize(self, params):
        self._DomainName = params.get("DomainName")
        self._AppName = params.get("AppName")
        self._StreamName = params.get("StreamName")
        self._TemplateId = params.get("TemplateId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteLiveTranscodeRuleResponse(AbstractModel):
    """DeleteLiveTranscodeRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteLiveTranscodeTemplateRequest(AbstractModel):
    """DeleteLiveTranscodeTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TemplateId: 模板 ID。
1. 在创建转码模板接口 [CreateLiveTranscodeTemplate](/document/product/267/32646) 调用的返回值中获取模板 ID。
2. 可以从接口 [DescribeLiveTranscodeTemplates](/document/product/267/32641) 查询已经创建过的模板列表。
        :type TemplateId: int
        """
        self._TemplateId = None

    @property
    def TemplateId(self):
        """模板 ID。
1. 在创建转码模板接口 [CreateLiveTranscodeTemplate](/document/product/267/32646) 调用的返回值中获取模板 ID。
2. 可以从接口 [DescribeLiveTranscodeTemplates](/document/product/267/32641) 查询已经创建过的模板列表。
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteLiveTranscodeTemplateResponse(AbstractModel):
    """DeleteLiveTranscodeTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteLiveWatermarkRequest(AbstractModel):
    """DeleteLiveWatermark请求参数结构体

    """

    def __init__(self):
        r"""
        :param _WatermarkId: 水印 ID。
在添加水印接口 [AddLiveWatermark](/document/product/267/30154) 调用返回值中获取水印 ID。
或DescribeLiveWatermarks接口返回的水印ID。
        :type WatermarkId: int
        """
        self._WatermarkId = None

    @property
    def WatermarkId(self):
        """水印 ID。
在添加水印接口 [AddLiveWatermark](/document/product/267/30154) 调用返回值中获取水印 ID。
或DescribeLiveWatermarks接口返回的水印ID。
        :rtype: int
        """
        return self._WatermarkId

    @WatermarkId.setter
    def WatermarkId(self, WatermarkId):
        self._WatermarkId = WatermarkId


    def _deserialize(self, params):
        self._WatermarkId = params.get("WatermarkId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteLiveWatermarkResponse(AbstractModel):
    """DeleteLiveWatermark返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteLiveWatermarkRuleRequest(AbstractModel):
    """DeleteLiveWatermarkRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DomainName: 推流域名。
        :type DomainName: str
        :param _AppName: 推流路径。与推流和播放地址中的 AppName 保持一致，默认为live。
        :type AppName: str
        :param _StreamName: 流名称。
        :type StreamName: str
        """
        self._DomainName = None
        self._AppName = None
        self._StreamName = None

    @property
    def DomainName(self):
        """推流域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def AppName(self):
        """推流路径。与推流和播放地址中的 AppName 保持一致，默认为live。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def StreamName(self):
        """流名称。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName


    def _deserialize(self, params):
        self._DomainName = params.get("DomainName")
        self._AppName = params.get("AppName")
        self._StreamName = params.get("StreamName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteLiveWatermarkRuleResponse(AbstractModel):
    """DeleteLiveWatermarkRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeletePullStreamConfigRequest(AbstractModel):
    """DeletePullStreamConfig请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ConfigId: 配置 ID。
1. 在添加拉流配置接口 [CreatePullStreamConfig](/document/api/267/30159) 调用返回值中获取配置 ID。
2. 可以从接口 [DescribePullStreamConfigs](/document/api/267/30158) 中查询已创建过的拉流配置列表。
        :type ConfigId: str
        """
        self._ConfigId = None

    @property
    def ConfigId(self):
        """配置 ID。
1. 在添加拉流配置接口 [CreatePullStreamConfig](/document/api/267/30159) 调用返回值中获取配置 ID。
2. 可以从接口 [DescribePullStreamConfigs](/document/api/267/30158) 中查询已创建过的拉流配置列表。
        :rtype: str
        """
        return self._ConfigId

    @ConfigId.setter
    def ConfigId(self, ConfigId):
        self._ConfigId = ConfigId


    def _deserialize(self, params):
        self._ConfigId = params.get("ConfigId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeletePullStreamConfigResponse(AbstractModel):
    """DeletePullStreamConfig返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteRecordTaskRequest(AbstractModel):
    """DeleteRecordTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务ID，CreateRecordTask返回。删除TaskId指定的录制任务。
        :type TaskId: str
        """
        self._TaskId = None

    @property
    def TaskId(self):
        """任务ID，CreateRecordTask返回。删除TaskId指定的录制任务。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRecordTaskResponse(AbstractModel):
    """DeleteRecordTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteScreenshotTaskRequest(AbstractModel):
    """DeleteScreenshotTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务ID，CreateScreenshotTask返回。删除TaskId指定的截图任务。
        :type TaskId: str
        """
        self._TaskId = None

    @property
    def TaskId(self):
        """任务ID，CreateScreenshotTask返回。删除TaskId指定的截图任务。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteScreenshotTaskResponse(AbstractModel):
    """DeleteScreenshotTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DescribeAllStreamPlayInfoListRequest(AbstractModel):
    """DescribeAllStreamPlayInfoList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _QueryTime: 查询时间点，精确到分钟粒度，接口查询支持两种时间格式：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#:~:text=I-,ISO%20%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F,-ISO%20%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F)。
2）YYYY-MM-DD hh:mm:ss：使用此格式时，默认代表北京时间。
支持最近1个月的数据查询，数据延迟为5分钟左右，如果要查询实时的数据，建议传递5分钟前的整点时间点。
        :type QueryTime: str
        :param _PlayDomains: 播放域名列表，若不填，表示总体数据。
        :type PlayDomains: list of str
        """
        self._QueryTime = None
        self._PlayDomains = None

    @property
    def QueryTime(self):
        """查询时间点，精确到分钟粒度，接口查询支持两种时间格式：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#:~:text=I-,ISO%20%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F,-ISO%20%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F)。
2）YYYY-MM-DD hh:mm:ss：使用此格式时，默认代表北京时间。
支持最近1个月的数据查询，数据延迟为5分钟左右，如果要查询实时的数据，建议传递5分钟前的整点时间点。
        :rtype: str
        """
        return self._QueryTime

    @QueryTime.setter
    def QueryTime(self, QueryTime):
        self._QueryTime = QueryTime

    @property
    def PlayDomains(self):
        """播放域名列表，若不填，表示总体数据。
        :rtype: list of str
        """
        return self._PlayDomains

    @PlayDomains.setter
    def PlayDomains(self, PlayDomains):
        self._PlayDomains = PlayDomains


    def _deserialize(self, params):
        self._QueryTime = params.get("QueryTime")
        self._PlayDomains = params.get("PlayDomains")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAllStreamPlayInfoListResponse(AbstractModel):
    """DescribeAllStreamPlayInfoList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _QueryTime: 查询时间点，回传的输入参数中的查询时间。
        :type QueryTime: str
        :param _DataInfoList: 数据信息列表。
        :type DataInfoList: list of MonitorStreamPlayInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._QueryTime = None
        self._DataInfoList = None
        self._RequestId = None

    @property
    def QueryTime(self):
        """查询时间点，回传的输入参数中的查询时间。
        :rtype: str
        """
        return self._QueryTime

    @QueryTime.setter
    def QueryTime(self, QueryTime):
        self._QueryTime = QueryTime

    @property
    def DataInfoList(self):
        """数据信息列表。
        :rtype: list of MonitorStreamPlayInfo
        """
        return self._DataInfoList

    @DataInfoList.setter
    def DataInfoList(self, DataInfoList):
        self._DataInfoList = DataInfoList

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._QueryTime = params.get("QueryTime")
        if params.get("DataInfoList") is not None:
            self._DataInfoList = []
            for item in params.get("DataInfoList"):
                obj = MonitorStreamPlayInfo()
                obj._deserialize(item)
                self._DataInfoList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAreaBillBandwidthAndFluxListRequest(AbstractModel):
    """DescribeAreaBillBandwidthAndFluxList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 起始时间点，格式为yyyy-mm-dd HH:MM:SS。
        :type StartTime: str
        :param _EndTime: 结束时间点，格式为yyyy-mm-dd HH:MM:SS，起始和结束时间跨度不支持超过1天。
        :type EndTime: str
        :param _PlayDomains: 直播播放域名，若不填，表示总体数据。
        :type PlayDomains: list of str
        """
        self._StartTime = None
        self._EndTime = None
        self._PlayDomains = None

    @property
    def StartTime(self):
        """起始时间点，格式为yyyy-mm-dd HH:MM:SS。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束时间点，格式为yyyy-mm-dd HH:MM:SS，起始和结束时间跨度不支持超过1天。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def PlayDomains(self):
        """直播播放域名，若不填，表示总体数据。
        :rtype: list of str
        """
        return self._PlayDomains

    @PlayDomains.setter
    def PlayDomains(self, PlayDomains):
        self._PlayDomains = PlayDomains


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._PlayDomains = params.get("PlayDomains")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAreaBillBandwidthAndFluxListResponse(AbstractModel):
    """DescribeAreaBillBandwidthAndFluxList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DataInfoList: 明细数据信息。
        :type DataInfoList: list of BillAreaInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DataInfoList = None
        self._RequestId = None

    @property
    def DataInfoList(self):
        """明细数据信息。
        :rtype: list of BillAreaInfo
        """
        return self._DataInfoList

    @DataInfoList.setter
    def DataInfoList(self, DataInfoList):
        self._DataInfoList = DataInfoList

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DataInfoList") is not None:
            self._DataInfoList = []
            for item in params.get("DataInfoList"):
                obj = BillAreaInfo()
                obj._deserialize(item)
                self._DataInfoList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBackupStreamListRequest(AbstractModel):
    """DescribeBackupStreamList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StreamName: 流名称，用于精确查询。
        :type StreamName: str
        """
        self._StreamName = None

    @property
    def StreamName(self):
        """流名称，用于精确查询。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName


    def _deserialize(self, params):
        self._StreamName = params.get("StreamName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBackupStreamListResponse(AbstractModel):
    """DescribeBackupStreamList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _StreamInfoList: 主备流分组信息列表。
        :type StreamInfoList: list of BackupStreamGroupInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._StreamInfoList = None
        self._RequestId = None

    @property
    def StreamInfoList(self):
        """主备流分组信息列表。
        :rtype: list of BackupStreamGroupInfo
        """
        return self._StreamInfoList

    @StreamInfoList.setter
    def StreamInfoList(self, StreamInfoList):
        self._StreamInfoList = StreamInfoList

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("StreamInfoList") is not None:
            self._StreamInfoList = []
            for item in params.get("StreamInfoList"):
                obj = BackupStreamGroupInfo()
                obj._deserialize(item)
                self._StreamInfoList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBillBandwidthAndFluxListRequest(AbstractModel):
    """DescribeBillBandwidthAndFluxList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 起始时间点，接口查询支持两种时间格式：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见IOS日期格式说明文档: https://cloud.tencent.com/document/product/266/11732#I
2）YYYY-MM-DD hh:mm:ss：使用此格式时，默认代表北京时间。
        :type StartTime: str
        :param _EndTime: 结束时间点，接口查询支持两种时间格式：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见IOS日期格式说明文档: https://cloud.tencent.com/document/product/266/11732#I
2）YYYY-MM-DD hh:mm:ss：使用此格式时，默认代表北京时间。
起始和结束时间跨度不支持超过31天。支持最近3年的数据查询
        :type EndTime: str
        :param _PlayDomains: 直播播放域名，若不填，表示总体数据。
        :type PlayDomains: list of str
        :param _MainlandOrOversea: 可选值：
Mainland：查询国内数据，
Oversea：则查询国外数据，
默认：查询国内+国外的数据。
注：LEB（快直播）只支持国内+国外数据查询。
        :type MainlandOrOversea: str
        :param _Granularity: 数据粒度，支持如下粒度：
5：5分钟粒度，（跨度不支持超过1天），
60：1小时粒度（跨度不支持超过一个月），
1440：天粒度（跨度不支持超过一个月）。
默认值：5。
        :type Granularity: int
        :param _ServiceName: 服务名称，可选值包括LVB(标准直播)，LEB(快直播)，不填则查LVB+LEB总值。
        :type ServiceName: str
        :param _RegionNames: 大区，映射表如下：
China Mainland 中国大陆
Asia Pacific I 亚太一区
Asia Pacific II 亚太二区
Asia Pacific III 亚太三区
Europe 欧洲
North America 北美
South America 南美
Middle East 中东
Africa 非洲。
        :type RegionNames: list of str
        """
        self._StartTime = None
        self._EndTime = None
        self._PlayDomains = None
        self._MainlandOrOversea = None
        self._Granularity = None
        self._ServiceName = None
        self._RegionNames = None

    @property
    def StartTime(self):
        """起始时间点，接口查询支持两种时间格式：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见IOS日期格式说明文档: https://cloud.tencent.com/document/product/266/11732#I
2）YYYY-MM-DD hh:mm:ss：使用此格式时，默认代表北京时间。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束时间点，接口查询支持两种时间格式：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见IOS日期格式说明文档: https://cloud.tencent.com/document/product/266/11732#I
2）YYYY-MM-DD hh:mm:ss：使用此格式时，默认代表北京时间。
起始和结束时间跨度不支持超过31天。支持最近3年的数据查询
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def PlayDomains(self):
        """直播播放域名，若不填，表示总体数据。
        :rtype: list of str
        """
        return self._PlayDomains

    @PlayDomains.setter
    def PlayDomains(self, PlayDomains):
        self._PlayDomains = PlayDomains

    @property
    def MainlandOrOversea(self):
        """可选值：
Mainland：查询国内数据，
Oversea：则查询国外数据，
默认：查询国内+国外的数据。
注：LEB（快直播）只支持国内+国外数据查询。
        :rtype: str
        """
        return self._MainlandOrOversea

    @MainlandOrOversea.setter
    def MainlandOrOversea(self, MainlandOrOversea):
        self._MainlandOrOversea = MainlandOrOversea

    @property
    def Granularity(self):
        """数据粒度，支持如下粒度：
5：5分钟粒度，（跨度不支持超过1天），
60：1小时粒度（跨度不支持超过一个月），
1440：天粒度（跨度不支持超过一个月）。
默认值：5。
        :rtype: int
        """
        return self._Granularity

    @Granularity.setter
    def Granularity(self, Granularity):
        self._Granularity = Granularity

    @property
    def ServiceName(self):
        """服务名称，可选值包括LVB(标准直播)，LEB(快直播)，不填则查LVB+LEB总值。
        :rtype: str
        """
        return self._ServiceName

    @ServiceName.setter
    def ServiceName(self, ServiceName):
        self._ServiceName = ServiceName

    @property
    def RegionNames(self):
        """大区，映射表如下：
China Mainland 中国大陆
Asia Pacific I 亚太一区
Asia Pacific II 亚太二区
Asia Pacific III 亚太三区
Europe 欧洲
North America 北美
South America 南美
Middle East 中东
Africa 非洲。
        :rtype: list of str
        """
        return self._RegionNames

    @RegionNames.setter
    def RegionNames(self, RegionNames):
        self._RegionNames = RegionNames


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._PlayDomains = params.get("PlayDomains")
        self._MainlandOrOversea = params.get("MainlandOrOversea")
        self._Granularity = params.get("Granularity")
        self._ServiceName = params.get("ServiceName")
        self._RegionNames = params.get("RegionNames")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBillBandwidthAndFluxListResponse(AbstractModel):
    """DescribeBillBandwidthAndFluxList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _PeakBandwidthTime: 峰值带宽所在时间点，接口返回支持两种时间格式(与接口请求传递的时间格式一致)：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见IOS日期格式说明文档: https://cloud.tencent.com/document/product/266/11732#I
2）YYYY-MM-DD hh:mm:ss：使用此格式时，默认代表北京时间。
        :type PeakBandwidthTime: str
        :param _PeakBandwidth: 峰值带宽，单位是Mbps。
        :type PeakBandwidth: float
        :param _P95PeakBandwidthTime: 95峰值带宽所在时间点，接口返回支持两种时间格式(与接口请求传递的时间格式一致)：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见IOS日期格式说明文档: https://cloud.tencent.com/document/product/266/11732#I
2）YYYY-MM-DD hh:mm:ss：使用此格式时，默认代表北京时间。
        :type P95PeakBandwidthTime: str
        :param _P95PeakBandwidth: 95峰值带宽，单位是Mbps。
        :type P95PeakBandwidth: float
        :param _SumFlux: 总流量，单位是MB。
        :type SumFlux: float
        :param _DataInfoList: 明细数据信息。
        :type DataInfoList: list of BillDataInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._PeakBandwidthTime = None
        self._PeakBandwidth = None
        self._P95PeakBandwidthTime = None
        self._P95PeakBandwidth = None
        self._SumFlux = None
        self._DataInfoList = None
        self._RequestId = None

    @property
    def PeakBandwidthTime(self):
        """峰值带宽所在时间点，接口返回支持两种时间格式(与接口请求传递的时间格式一致)：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见IOS日期格式说明文档: https://cloud.tencent.com/document/product/266/11732#I
2）YYYY-MM-DD hh:mm:ss：使用此格式时，默认代表北京时间。
        :rtype: str
        """
        return self._PeakBandwidthTime

    @PeakBandwidthTime.setter
    def PeakBandwidthTime(self, PeakBandwidthTime):
        self._PeakBandwidthTime = PeakBandwidthTime

    @property
    def PeakBandwidth(self):
        """峰值带宽，单位是Mbps。
        :rtype: float
        """
        return self._PeakBandwidth

    @PeakBandwidth.setter
    def PeakBandwidth(self, PeakBandwidth):
        self._PeakBandwidth = PeakBandwidth

    @property
    def P95PeakBandwidthTime(self):
        """95峰值带宽所在时间点，接口返回支持两种时间格式(与接口请求传递的时间格式一致)：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见IOS日期格式说明文档: https://cloud.tencent.com/document/product/266/11732#I
2）YYYY-MM-DD hh:mm:ss：使用此格式时，默认代表北京时间。
        :rtype: str
        """
        return self._P95PeakBandwidthTime

    @P95PeakBandwidthTime.setter
    def P95PeakBandwidthTime(self, P95PeakBandwidthTime):
        self._P95PeakBandwidthTime = P95PeakBandwidthTime

    @property
    def P95PeakBandwidth(self):
        """95峰值带宽，单位是Mbps。
        :rtype: float
        """
        return self._P95PeakBandwidth

    @P95PeakBandwidth.setter
    def P95PeakBandwidth(self, P95PeakBandwidth):
        self._P95PeakBandwidth = P95PeakBandwidth

    @property
    def SumFlux(self):
        """总流量，单位是MB。
        :rtype: float
        """
        return self._SumFlux

    @SumFlux.setter
    def SumFlux(self, SumFlux):
        self._SumFlux = SumFlux

    @property
    def DataInfoList(self):
        """明细数据信息。
        :rtype: list of BillDataInfo
        """
        return self._DataInfoList

    @DataInfoList.setter
    def DataInfoList(self, DataInfoList):
        self._DataInfoList = DataInfoList

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._PeakBandwidthTime = params.get("PeakBandwidthTime")
        self._PeakBandwidth = params.get("PeakBandwidth")
        self._P95PeakBandwidthTime = params.get("P95PeakBandwidthTime")
        self._P95PeakBandwidth = params.get("P95PeakBandwidth")
        self._SumFlux = params.get("SumFlux")
        if params.get("DataInfoList") is not None:
            self._DataInfoList = []
            for item in params.get("DataInfoList"):
                obj = BillDataInfo()
                obj._deserialize(item)
                self._DataInfoList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCallbackRecordsListRequest(AbstractModel):
    """DescribeCallbackRecordsList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 起始时间点，接口查询支持两种时间格式：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#:~:text=I-,ISO,-%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F)
2）YYYY-MM-DD hh:mm:ss：使用此格式时，默认代表北京时间。
        :type StartTime: str
        :param _EndTime: 结束时间点，接口查询支持两种时间格式：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#:~:text=I-,ISO,-%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F)
2）YYYY-MM-DD hh:mm:ss：使用此格式时，默认代表北京时间。

查询的起始和结束时间跨度不支持超过1天。仅支持查询最近14天的数据。
        :type EndTime: str
        :param _StreamName: 流名称，精确匹配。
        :type StreamName: str
        :param _PageNum: 页码。
        :type PageNum: int
        :param _PageSize: 每页条数。
        :type PageSize: int
        :param _EventType: 事件类型。
0: "断流",
1: "推流",
100: "录制"
200: "截图回调"。
        :type EventType: int
        :param _ResultCode: 回调结果。
0为成功，其他为失败。
        :type ResultCode: int
        """
        self._StartTime = None
        self._EndTime = None
        self._StreamName = None
        self._PageNum = None
        self._PageSize = None
        self._EventType = None
        self._ResultCode = None

    @property
    def StartTime(self):
        """起始时间点，接口查询支持两种时间格式：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#:~:text=I-,ISO,-%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F)
2）YYYY-MM-DD hh:mm:ss：使用此格式时，默认代表北京时间。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束时间点，接口查询支持两种时间格式：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#:~:text=I-,ISO,-%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F)
2）YYYY-MM-DD hh:mm:ss：使用此格式时，默认代表北京时间。

查询的起始和结束时间跨度不支持超过1天。仅支持查询最近14天的数据。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def StreamName(self):
        """流名称，精确匹配。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName

    @property
    def PageNum(self):
        """页码。
        :rtype: int
        """
        return self._PageNum

    @PageNum.setter
    def PageNum(self, PageNum):
        self._PageNum = PageNum

    @property
    def PageSize(self):
        """每页条数。
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def EventType(self):
        """事件类型。
0: "断流",
1: "推流",
100: "录制"
200: "截图回调"。
        :rtype: int
        """
        return self._EventType

    @EventType.setter
    def EventType(self, EventType):
        self._EventType = EventType

    @property
    def ResultCode(self):
        """回调结果。
0为成功，其他为失败。
        :rtype: int
        """
        return self._ResultCode

    @ResultCode.setter
    def ResultCode(self, ResultCode):
        self._ResultCode = ResultCode


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._StreamName = params.get("StreamName")
        self._PageNum = params.get("PageNum")
        self._PageSize = params.get("PageSize")
        self._EventType = params.get("EventType")
        self._ResultCode = params.get("ResultCode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCallbackRecordsListResponse(AbstractModel):
    """DescribeCallbackRecordsList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DataInfoList: 回调事件列表。
        :type DataInfoList: list of CallbackEventInfo
        :param _PageNum: 页码。
        :type PageNum: int
        :param _PageSize: 每页条数。
        :type PageSize: int
        :param _TotalNum: 总条数。
        :type TotalNum: int
        :param _TotalPage: 总页数。
        :type TotalPage: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DataInfoList = None
        self._PageNum = None
        self._PageSize = None
        self._TotalNum = None
        self._TotalPage = None
        self._RequestId = None

    @property
    def DataInfoList(self):
        """回调事件列表。
        :rtype: list of CallbackEventInfo
        """
        return self._DataInfoList

    @DataInfoList.setter
    def DataInfoList(self, DataInfoList):
        self._DataInfoList = DataInfoList

    @property
    def PageNum(self):
        """页码。
        :rtype: int
        """
        return self._PageNum

    @PageNum.setter
    def PageNum(self, PageNum):
        self._PageNum = PageNum

    @property
    def PageSize(self):
        """每页条数。
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def TotalNum(self):
        """总条数。
        :rtype: int
        """
        return self._TotalNum

    @TotalNum.setter
    def TotalNum(self, TotalNum):
        self._TotalNum = TotalNum

    @property
    def TotalPage(self):
        """总页数。
        :rtype: int
        """
        return self._TotalPage

    @TotalPage.setter
    def TotalPage(self, TotalPage):
        self._TotalPage = TotalPage

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DataInfoList") is not None:
            self._DataInfoList = []
            for item in params.get("DataInfoList"):
                obj = CallbackEventInfo()
                obj._deserialize(item)
                self._DataInfoList.append(obj)
        self._PageNum = params.get("PageNum")
        self._PageSize = params.get("PageSize")
        self._TotalNum = params.get("TotalNum")
        self._TotalPage = params.get("TotalPage")
        self._RequestId = params.get("RequestId")


class DescribeCasterDisplayInfoRequest(AbstractModel):
    """DescribeCasterDisplayInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CasterId: 导播台ID
        :type CasterId: int
        """
        self._CasterId = None

    @property
    def CasterId(self):
        """导播台ID
        :rtype: int
        """
        return self._CasterId

    @CasterId.setter
    def CasterId(self, CasterId):
        self._CasterId = CasterId


    def _deserialize(self, params):
        self._CasterId = params.get("CasterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCasterDisplayInfoResponse(AbstractModel):
    """DescribeCasterDisplayInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Status: 导播台状态
0：停止状态，无预监，无主监 
1：无预监，有主监 
2：有预监，无主监 
3：有预监，有主监
        :type Status: int
        :param _PvwDisplayInfo: 预监使用的展示参数。
        :type PvwDisplayInfo: :class:`tencentcloud.live.v20180801.models.CasterDisplayInfo`
        :param _PgmDisplayInfo: 主监使用的展示参数。
        :type PgmDisplayInfo: :class:`tencentcloud.live.v20180801.models.CasterDisplayInfo`
        :param _StartLiveTime: 启动直播的时间，值为unix时间戳。
        :type StartLiveTime: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Status = None
        self._PvwDisplayInfo = None
        self._PgmDisplayInfo = None
        self._StartLiveTime = None
        self._RequestId = None

    @property
    def Status(self):
        """导播台状态
0：停止状态，无预监，无主监 
1：无预监，有主监 
2：有预监，无主监 
3：有预监，有主监
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def PvwDisplayInfo(self):
        """预监使用的展示参数。
        :rtype: :class:`tencentcloud.live.v20180801.models.CasterDisplayInfo`
        """
        return self._PvwDisplayInfo

    @PvwDisplayInfo.setter
    def PvwDisplayInfo(self, PvwDisplayInfo):
        self._PvwDisplayInfo = PvwDisplayInfo

    @property
    def PgmDisplayInfo(self):
        """主监使用的展示参数。
        :rtype: :class:`tencentcloud.live.v20180801.models.CasterDisplayInfo`
        """
        return self._PgmDisplayInfo

    @PgmDisplayInfo.setter
    def PgmDisplayInfo(self, PgmDisplayInfo):
        self._PgmDisplayInfo = PgmDisplayInfo

    @property
    def StartLiveTime(self):
        """启动直播的时间，值为unix时间戳。
        :rtype: int
        """
        return self._StartLiveTime

    @StartLiveTime.setter
    def StartLiveTime(self, StartLiveTime):
        self._StartLiveTime = StartLiveTime

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Status = params.get("Status")
        if params.get("PvwDisplayInfo") is not None:
            self._PvwDisplayInfo = CasterDisplayInfo()
            self._PvwDisplayInfo._deserialize(params.get("PvwDisplayInfo"))
        if params.get("PgmDisplayInfo") is not None:
            self._PgmDisplayInfo = CasterDisplayInfo()
            self._PgmDisplayInfo._deserialize(params.get("PgmDisplayInfo"))
        self._StartLiveTime = params.get("StartLiveTime")
        self._RequestId = params.get("RequestId")


class DescribeCasterInputInfosRequest(AbstractModel):
    """DescribeCasterInputInfos请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CasterId: 导播台ID
        :type CasterId: int
        """
        self._CasterId = None

    @property
    def CasterId(self):
        """导播台ID
        :rtype: int
        """
        return self._CasterId

    @CasterId.setter
    def CasterId(self, CasterId):
        self._CasterId = CasterId


    def _deserialize(self, params):
        self._CasterId = params.get("CasterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCasterInputInfosResponse(AbstractModel):
    """DescribeCasterInputInfos返回参数结构体

    """

    def __init__(self):
        r"""
        :param _InputInfos: 导播台输入源信息列表。
        :type InputInfos: list of CasterInputInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._InputInfos = None
        self._RequestId = None

    @property
    def InputInfos(self):
        """导播台输入源信息列表。
        :rtype: list of CasterInputInfo
        """
        return self._InputInfos

    @InputInfos.setter
    def InputInfos(self, InputInfos):
        self._InputInfos = InputInfos

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("InputInfos") is not None:
            self._InputInfos = []
            for item in params.get("InputInfos"):
                obj = CasterInputInfo()
                obj._deserialize(item)
                self._InputInfos.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCasterLayoutInfosRequest(AbstractModel):
    """DescribeCasterLayoutInfos请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CasterId: 导播台ID。
        :type CasterId: int
        """
        self._CasterId = None

    @property
    def CasterId(self):
        """导播台ID。
        :rtype: int
        """
        return self._CasterId

    @CasterId.setter
    def CasterId(self, CasterId):
        self._CasterId = CasterId


    def _deserialize(self, params):
        self._CasterId = params.get("CasterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCasterLayoutInfosResponse(AbstractModel):
    """DescribeCasterLayoutInfos返回参数结构体

    """

    def __init__(self):
        r"""
        :param _LayoutInfos: 导播台的布局列表。
        :type LayoutInfos: list of CasterLayoutInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._LayoutInfos = None
        self._RequestId = None

    @property
    def LayoutInfos(self):
        """导播台的布局列表。
        :rtype: list of CasterLayoutInfo
        """
        return self._LayoutInfos

    @LayoutInfos.setter
    def LayoutInfos(self, LayoutInfos):
        self._LayoutInfos = LayoutInfos

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("LayoutInfos") is not None:
            self._LayoutInfos = []
            for item in params.get("LayoutInfos"):
                obj = CasterLayoutInfo()
                obj._deserialize(item)
                self._LayoutInfos.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCasterListRequest(AbstractModel):
    """DescribeCasterList请求参数结构体

    """


class DescribeCasterListResponse(AbstractModel):
    """DescribeCasterList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _CasterList: 用户对应的导播台简要信息列表
        :type CasterList: list of CasterBriefInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._CasterList = None
        self._RequestId = None

    @property
    def CasterList(self):
        """用户对应的导播台简要信息列表
        :rtype: list of CasterBriefInfo
        """
        return self._CasterList

    @CasterList.setter
    def CasterList(self, CasterList):
        self._CasterList = CasterList

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("CasterList") is not None:
            self._CasterList = []
            for item in params.get("CasterList"):
                obj = CasterBriefInfo()
                obj._deserialize(item)
                self._CasterList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCasterMarkPicInfosRequest(AbstractModel):
    """DescribeCasterMarkPicInfos请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CasterId: 导播台ID。
        :type CasterId: int
        """
        self._CasterId = None

    @property
    def CasterId(self):
        """导播台ID。
        :rtype: int
        """
        return self._CasterId

    @CasterId.setter
    def CasterId(self, CasterId):
        self._CasterId = CasterId


    def _deserialize(self, params):
        self._CasterId = params.get("CasterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCasterMarkPicInfosResponse(AbstractModel):
    """DescribeCasterMarkPicInfos返回参数结构体

    """

    def __init__(self):
        r"""
        :param _MarkPicInfos: 导播台的水印信息列表。
        :type MarkPicInfos: list of CasterMarkPicInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._MarkPicInfos = None
        self._RequestId = None

    @property
    def MarkPicInfos(self):
        """导播台的水印信息列表。
        :rtype: list of CasterMarkPicInfo
        """
        return self._MarkPicInfos

    @MarkPicInfos.setter
    def MarkPicInfos(self, MarkPicInfos):
        self._MarkPicInfos = MarkPicInfos

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("MarkPicInfos") is not None:
            self._MarkPicInfos = []
            for item in params.get("MarkPicInfos"):
                obj = CasterMarkPicInfo()
                obj._deserialize(item)
                self._MarkPicInfos.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCasterMarkWordInfosRequest(AbstractModel):
    """DescribeCasterMarkWordInfos请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CasterId: 导播台ID。
        :type CasterId: int
        """
        self._CasterId = None

    @property
    def CasterId(self):
        """导播台ID。
        :rtype: int
        """
        return self._CasterId

    @CasterId.setter
    def CasterId(self, CasterId):
        self._CasterId = CasterId


    def _deserialize(self, params):
        self._CasterId = params.get("CasterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCasterMarkWordInfosResponse(AbstractModel):
    """DescribeCasterMarkWordInfos返回参数结构体

    """

    def __init__(self):
        r"""
        :param _MarkWordInfos: 导播台的文本信息列表。
        :type MarkWordInfos: list of CasterMarkWordInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._MarkWordInfos = None
        self._RequestId = None

    @property
    def MarkWordInfos(self):
        """导播台的文本信息列表。
        :rtype: list of CasterMarkWordInfo
        """
        return self._MarkWordInfos

    @MarkWordInfos.setter
    def MarkWordInfos(self, MarkWordInfos):
        self._MarkWordInfos = MarkWordInfos

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("MarkWordInfos") is not None:
            self._MarkWordInfos = []
            for item in params.get("MarkWordInfos"):
                obj = CasterMarkWordInfo()
                obj._deserialize(item)
                self._MarkWordInfos.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCasterOutputInfosRequest(AbstractModel):
    """DescribeCasterOutputInfos请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CasterId: 导播台ID。
        :type CasterId: int
        """
        self._CasterId = None

    @property
    def CasterId(self):
        """导播台ID。
        :rtype: int
        """
        return self._CasterId

    @CasterId.setter
    def CasterId(self, CasterId):
        self._CasterId = CasterId


    def _deserialize(self, params):
        self._CasterId = params.get("CasterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCasterOutputInfosResponse(AbstractModel):
    """DescribeCasterOutputInfos返回参数结构体

    """

    def __init__(self):
        r"""
        :param _OutputInfos: 导播台的推流信息列表。
        :type OutputInfos: list of CasterOutputInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._OutputInfos = None
        self._RequestId = None

    @property
    def OutputInfos(self):
        """导播台的推流信息列表。
        :rtype: list of CasterOutputInfo
        """
        return self._OutputInfos

    @OutputInfos.setter
    def OutputInfos(self, OutputInfos):
        self._OutputInfos = OutputInfos

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("OutputInfos") is not None:
            self._OutputInfos = []
            for item in params.get("OutputInfos"):
                obj = CasterOutputInfo()
                obj._deserialize(item)
                self._OutputInfos.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCasterPlayUrlRequest(AbstractModel):
    """DescribeCasterPlayUrl请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CasterId: 导播台ID
        :type CasterId: int
        :param _PlayUrlType: 请求播放url的类型。
取值范围[1，2，3]
1：获取输入源的播放url
2：获取pvw的播放url
3：获取pgm的播放url
        :type PlayUrlType: int
        :param _PlayUrlIndex: 仅在PlayUrlType为1时生效，此时该参数表示请求的输入源Index。
注：对应的输入源必须存在。
        :type PlayUrlIndex: int
        """
        self._CasterId = None
        self._PlayUrlType = None
        self._PlayUrlIndex = None

    @property
    def CasterId(self):
        """导播台ID
        :rtype: int
        """
        return self._CasterId

    @CasterId.setter
    def CasterId(self, CasterId):
        self._CasterId = CasterId

    @property
    def PlayUrlType(self):
        """请求播放url的类型。
取值范围[1，2，3]
1：获取输入源的播放url
2：获取pvw的播放url
3：获取pgm的播放url
        :rtype: int
        """
        return self._PlayUrlType

    @PlayUrlType.setter
    def PlayUrlType(self, PlayUrlType):
        self._PlayUrlType = PlayUrlType

    @property
    def PlayUrlIndex(self):
        """仅在PlayUrlType为1时生效，此时该参数表示请求的输入源Index。
注：对应的输入源必须存在。
        :rtype: int
        """
        return self._PlayUrlIndex

    @PlayUrlIndex.setter
    def PlayUrlIndex(self, PlayUrlIndex):
        self._PlayUrlIndex = PlayUrlIndex


    def _deserialize(self, params):
        self._CasterId = params.get("CasterId")
        self._PlayUrlType = params.get("PlayUrlType")
        self._PlayUrlIndex = params.get("PlayUrlIndex")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCasterPlayUrlResponse(AbstractModel):
    """DescribeCasterPlayUrl返回参数结构体

    """

    def __init__(self):
        r"""
        :param _PlayUrl: 播放url。
当导播台不存在预监或主监时，若请求预监或主监的播放地址，该字段为空。
        :type PlayUrl: str
        :param _WebRTCPlayUrl: webrtc协议播放地址。
当导播台不存在预监或主监时，若请求预监或主监的webrtc播放地址，该字段为空。
注：webrtc协议播放地址需配合腾讯云快直播播放sdk方可使用。
        :type WebRTCPlayUrl: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._PlayUrl = None
        self._WebRTCPlayUrl = None
        self._RequestId = None

    @property
    def PlayUrl(self):
        """播放url。
当导播台不存在预监或主监时，若请求预监或主监的播放地址，该字段为空。
        :rtype: str
        """
        return self._PlayUrl

    @PlayUrl.setter
    def PlayUrl(self, PlayUrl):
        self._PlayUrl = PlayUrl

    @property
    def WebRTCPlayUrl(self):
        """webrtc协议播放地址。
当导播台不存在预监或主监时，若请求预监或主监的webrtc播放地址，该字段为空。
注：webrtc协议播放地址需配合腾讯云快直播播放sdk方可使用。
        :rtype: str
        """
        return self._WebRTCPlayUrl

    @WebRTCPlayUrl.setter
    def WebRTCPlayUrl(self, WebRTCPlayUrl):
        self._WebRTCPlayUrl = WebRTCPlayUrl

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._PlayUrl = params.get("PlayUrl")
        self._WebRTCPlayUrl = params.get("WebRTCPlayUrl")
        self._RequestId = params.get("RequestId")


class DescribeCasterRequest(AbstractModel):
    """DescribeCaster请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CasterId: 需查询的导播台ID
        :type CasterId: int
        """
        self._CasterId = None

    @property
    def CasterId(self):
        """需查询的导播台ID
        :rtype: int
        """
        return self._CasterId

    @CasterId.setter
    def CasterId(self, CasterId):
        self._CasterId = CasterId


    def _deserialize(self, params):
        self._CasterId = params.get("CasterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCasterResponse(AbstractModel):
    """DescribeCaster返回参数结构体

    """

    def __init__(self):
        r"""
        :param _CasterInfo: 导播台信息
        :type CasterInfo: :class:`tencentcloud.live.v20180801.models.CasterInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._CasterInfo = None
        self._RequestId = None

    @property
    def CasterInfo(self):
        """导播台信息
        :rtype: :class:`tencentcloud.live.v20180801.models.CasterInfo`
        """
        return self._CasterInfo

    @CasterInfo.setter
    def CasterInfo(self, CasterInfo):
        self._CasterInfo = CasterInfo

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("CasterInfo") is not None:
            self._CasterInfo = CasterInfo()
            self._CasterInfo._deserialize(params.get("CasterInfo"))
        self._RequestId = params.get("RequestId")


class DescribeCasterTransitionTypesRequest(AbstractModel):
    """DescribeCasterTransitionTypes请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CasterId: 导播台ID
        :type CasterId: int
        """
        self._CasterId = None

    @property
    def CasterId(self):
        """导播台ID
        :rtype: int
        """
        return self._CasterId

    @CasterId.setter
    def CasterId(self, CasterId):
        self._CasterId = CasterId


    def _deserialize(self, params):
        self._CasterId = params.get("CasterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCasterTransitionTypesResponse(AbstractModel):
    """DescribeCasterTransitionTypes返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TransitionTypes: 转场信息列表
        :type TransitionTypes: list of TransitionTypeInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TransitionTypes = None
        self._RequestId = None

    @property
    def TransitionTypes(self):
        """转场信息列表
        :rtype: list of TransitionTypeInfo
        """
        return self._TransitionTypes

    @TransitionTypes.setter
    def TransitionTypes(self, TransitionTypes):
        self._TransitionTypes = TransitionTypes

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TransitionTypes") is not None:
            self._TransitionTypes = []
            for item in params.get("TransitionTypes"):
                obj = TransitionTypeInfo()
                obj._deserialize(item)
                self._TransitionTypes.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCasterUserStatusRequest(AbstractModel):
    """DescribeCasterUserStatus请求参数结构体

    """


class DescribeCasterUserStatusResponse(AbstractModel):
    """DescribeCasterUserStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _UserStatus: 0: 未开通导播台
1:开通了导播台，且处于正常状态
2:开通了导播台，但处于欠费状态
3:开通了导播台，但处于封禁状态
        :type UserStatus: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._UserStatus = None
        self._RequestId = None

    @property
    def UserStatus(self):
        """0: 未开通导播台
1:开通了导播台，且处于正常状态
2:开通了导播台，但处于欠费状态
3:开通了导播台，但处于封禁状态
        :rtype: int
        """
        return self._UserStatus

    @UserStatus.setter
    def UserStatus(self, UserStatus):
        self._UserStatus = UserStatus

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._UserStatus = params.get("UserStatus")
        self._RequestId = params.get("RequestId")


class DescribeConcurrentRecordStreamNumRequest(AbstractModel):
    """DescribeConcurrentRecordStreamNum请求参数结构体

    """

    def __init__(self):
        r"""
        :param _LiveType: 直播类型，SlowLive：慢直播。
NormalLive：普通直播。
        :type LiveType: str
        :param _StartTime: 起始时间点，接口查询支持两种时间格式：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见IOS日期格式说明文档: https://cloud.tencent.com/document/product/266/11732#I
2）YYYY-MM-DD hh:mm:ss：使用此格式时，默认代表北京时间。
可以查询最近180天的数据。
        :type StartTime: str
        :param _EndTime: 结束时间点，接口查询支持两种时间格式：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见IOS日期格式说明文档: https://cloud.tencent.com/document/product/266/11732#I
2）YYYY-MM-DD hh:mm:ss：使用此格式时，默认代表北京时间。
时间跨度最大支持31天。
        :type EndTime: str
        :param _MainlandOrOversea: 如果为空，查询所有地区数据；如果为“Mainland”，查询国内数据；如果为“Oversea”，则查询国外数据。
        :type MainlandOrOversea: str
        :param _PushDomains: 推流域名列表，不填表示总体数据。
        :type PushDomains: list of str
        """
        self._LiveType = None
        self._StartTime = None
        self._EndTime = None
        self._MainlandOrOversea = None
        self._PushDomains = None

    @property
    def LiveType(self):
        """直播类型，SlowLive：慢直播。
NormalLive：普通直播。
        :rtype: str
        """
        return self._LiveType

    @LiveType.setter
    def LiveType(self, LiveType):
        self._LiveType = LiveType

    @property
    def StartTime(self):
        """起始时间点，接口查询支持两种时间格式：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见IOS日期格式说明文档: https://cloud.tencent.com/document/product/266/11732#I
2）YYYY-MM-DD hh:mm:ss：使用此格式时，默认代表北京时间。
可以查询最近180天的数据。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束时间点，接口查询支持两种时间格式：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见IOS日期格式说明文档: https://cloud.tencent.com/document/product/266/11732#I
2）YYYY-MM-DD hh:mm:ss：使用此格式时，默认代表北京时间。
时间跨度最大支持31天。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def MainlandOrOversea(self):
        """如果为空，查询所有地区数据；如果为“Mainland”，查询国内数据；如果为“Oversea”，则查询国外数据。
        :rtype: str
        """
        return self._MainlandOrOversea

    @MainlandOrOversea.setter
    def MainlandOrOversea(self, MainlandOrOversea):
        self._MainlandOrOversea = MainlandOrOversea

    @property
    def PushDomains(self):
        """推流域名列表，不填表示总体数据。
        :rtype: list of str
        """
        return self._PushDomains

    @PushDomains.setter
    def PushDomains(self, PushDomains):
        self._PushDomains = PushDomains


    def _deserialize(self, params):
        self._LiveType = params.get("LiveType")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._MainlandOrOversea = params.get("MainlandOrOversea")
        self._PushDomains = params.get("PushDomains")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeConcurrentRecordStreamNumResponse(AbstractModel):
    """DescribeConcurrentRecordStreamNum返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DataInfoList: 统计信息列表。
        :type DataInfoList: list of ConcurrentRecordStreamNum
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DataInfoList = None
        self._RequestId = None

    @property
    def DataInfoList(self):
        """统计信息列表。
        :rtype: list of ConcurrentRecordStreamNum
        """
        return self._DataInfoList

    @DataInfoList.setter
    def DataInfoList(self, DataInfoList):
        self._DataInfoList = DataInfoList

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DataInfoList") is not None:
            self._DataInfoList = []
            for item in params.get("DataInfoList"):
                obj = ConcurrentRecordStreamNum()
                obj._deserialize(item)
                self._DataInfoList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDeliverBandwidthListRequest(AbstractModel):
    """DescribeDeliverBandwidthList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 起始时间点，接口查询支持两种时间格式：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见IOS日期格式说明文档: https://cloud.tencent.com/document/product/266/11732#I
2）YYYY-MM-DD hh:mm:ss：使用此格式时，默认代表北京时间。
        :type StartTime: str
        :param _EndTime: 结束时间点，接口查询支持两种时间格式：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见IOS日期格式说明文档: https://cloud.tencent.com/document/product/266/11732#I
2）YYYY-MM-DD hh:mm:ss：使用此格式时，默认代表北京时间。
支持最近三个月的数据查询，时间跨度最大是1个月。
        :type EndTime: str
        """
        self._StartTime = None
        self._EndTime = None

    @property
    def StartTime(self):
        """起始时间点，接口查询支持两种时间格式：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见IOS日期格式说明文档: https://cloud.tencent.com/document/product/266/11732#I
2）YYYY-MM-DD hh:mm:ss：使用此格式时，默认代表北京时间。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束时间点，接口查询支持两种时间格式：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见IOS日期格式说明文档: https://cloud.tencent.com/document/product/266/11732#I
2）YYYY-MM-DD hh:mm:ss：使用此格式时，默认代表北京时间。
支持最近三个月的数据查询，时间跨度最大是1个月。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDeliverBandwidthListResponse(AbstractModel):
    """DescribeDeliverBandwidthList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DataInfoList: 转推计费带宽数据
        :type DataInfoList: list of BandwidthInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DataInfoList = None
        self._RequestId = None

    @property
    def DataInfoList(self):
        """转推计费带宽数据
        :rtype: list of BandwidthInfo
        """
        return self._DataInfoList

    @DataInfoList.setter
    def DataInfoList(self, DataInfoList):
        self._DataInfoList = DataInfoList

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DataInfoList") is not None:
            self._DataInfoList = []
            for item in params.get("DataInfoList"):
                obj = BandwidthInfo()
                obj._deserialize(item)
                self._DataInfoList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDeliverLogDownListRequest(AbstractModel):
    """DescribeDeliverLogDownList请求参数结构体

    """


class DescribeDeliverLogDownListResponse(AbstractModel):
    """DescribeDeliverLogDownList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _LogInfoList: 日志信息列表。
        :type LogInfoList: list of PushLogInfo
        :param _TotalNum: 总条数。
        :type TotalNum: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._LogInfoList = None
        self._TotalNum = None
        self._RequestId = None

    @property
    def LogInfoList(self):
        """日志信息列表。
        :rtype: list of PushLogInfo
        """
        return self._LogInfoList

    @LogInfoList.setter
    def LogInfoList(self, LogInfoList):
        self._LogInfoList = LogInfoList

    @property
    def TotalNum(self):
        """总条数。
        :rtype: int
        """
        return self._TotalNum

    @TotalNum.setter
    def TotalNum(self, TotalNum):
        self._TotalNum = TotalNum

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("LogInfoList") is not None:
            self._LogInfoList = []
            for item in params.get("LogInfoList"):
                obj = PushLogInfo()
                obj._deserialize(item)
                self._LogInfoList.append(obj)
        self._TotalNum = params.get("TotalNum")
        self._RequestId = params.get("RequestId")


class DescribeGroupProIspPlayInfoListRequest(AbstractModel):
    """DescribeGroupProIspPlayInfoList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 起始时间点，
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#:~:text=I-,ISO,-%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F)。
        :type StartTime: str
        :param _EndTime: 结束时间点，
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#:~:text=I-,ISO,-%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F)。
时间跨度在（0,3小时]，支持最近1个月数据查询。
        :type EndTime: str
        :param _PlayDomains: 播放域名，默认为不填，表示求总体数据。
        :type PlayDomains: list of str
        :param _ProvinceNames: 省份列表，默认不填，则返回各省份的数据。
        :type ProvinceNames: list of str
        :param _IspNames: 运营商列表，默认不填，则返回整个运营商的数据。
        :type IspNames: list of str
        :param _MainlandOrOversea: 国内还是国外，如果为空，查询所有地区数据；如果为“Mainland”，查询国内数据；如果为“Oversea”，则查询国外数据。
        :type MainlandOrOversea: str
        """
        self._StartTime = None
        self._EndTime = None
        self._PlayDomains = None
        self._ProvinceNames = None
        self._IspNames = None
        self._MainlandOrOversea = None

    @property
    def StartTime(self):
        """起始时间点，
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#:~:text=I-,ISO,-%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F)。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束时间点，
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#:~:text=I-,ISO,-%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F)。
时间跨度在（0,3小时]，支持最近1个月数据查询。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def PlayDomains(self):
        """播放域名，默认为不填，表示求总体数据。
        :rtype: list of str
        """
        return self._PlayDomains

    @PlayDomains.setter
    def PlayDomains(self, PlayDomains):
        self._PlayDomains = PlayDomains

    @property
    def ProvinceNames(self):
        """省份列表，默认不填，则返回各省份的数据。
        :rtype: list of str
        """
        return self._ProvinceNames

    @ProvinceNames.setter
    def ProvinceNames(self, ProvinceNames):
        self._ProvinceNames = ProvinceNames

    @property
    def IspNames(self):
        """运营商列表，默认不填，则返回整个运营商的数据。
        :rtype: list of str
        """
        return self._IspNames

    @IspNames.setter
    def IspNames(self, IspNames):
        self._IspNames = IspNames

    @property
    def MainlandOrOversea(self):
        """国内还是国外，如果为空，查询所有地区数据；如果为“Mainland”，查询国内数据；如果为“Oversea”，则查询国外数据。
        :rtype: str
        """
        return self._MainlandOrOversea

    @MainlandOrOversea.setter
    def MainlandOrOversea(self, MainlandOrOversea):
        self._MainlandOrOversea = MainlandOrOversea


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._PlayDomains = params.get("PlayDomains")
        self._ProvinceNames = params.get("ProvinceNames")
        self._IspNames = params.get("IspNames")
        self._MainlandOrOversea = params.get("MainlandOrOversea")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeGroupProIspPlayInfoListResponse(AbstractModel):
    """DescribeGroupProIspPlayInfoList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DataInfoList: 数据内容。
        :type DataInfoList: list of GroupProIspDataInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DataInfoList = None
        self._RequestId = None

    @property
    def DataInfoList(self):
        """数据内容。
        :rtype: list of GroupProIspDataInfo
        """
        return self._DataInfoList

    @DataInfoList.setter
    def DataInfoList(self, DataInfoList):
        self._DataInfoList = DataInfoList

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DataInfoList") is not None:
            self._DataInfoList = []
            for item in params.get("DataInfoList"):
                obj = GroupProIspDataInfo()
                obj._deserialize(item)
                self._DataInfoList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeHttpStatusInfoListRequest(AbstractModel):
    """DescribeHttpStatusInfoList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 起始时间，
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#:~:text=I-,ISO,-%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F)。
        :type StartTime: str
        :param _EndTime: 结束时间，
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#:~:text=I-,ISO,-%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F)。
        :type EndTime: str
        :param _PlayDomains: 播放域名列表。
        :type PlayDomains: list of str
        """
        self._StartTime = None
        self._EndTime = None
        self._PlayDomains = None

    @property
    def StartTime(self):
        """起始时间，
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#:~:text=I-,ISO,-%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F)。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束时间，
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#:~:text=I-,ISO,-%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F)。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def PlayDomains(self):
        """播放域名列表。
        :rtype: list of str
        """
        return self._PlayDomains

    @PlayDomains.setter
    def PlayDomains(self, PlayDomains):
        self._PlayDomains = PlayDomains


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._PlayDomains = params.get("PlayDomains")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeHttpStatusInfoListResponse(AbstractModel):
    """DescribeHttpStatusInfoList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DataInfoList: 播放状态码列表。
        :type DataInfoList: list of HttpStatusData
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DataInfoList = None
        self._RequestId = None

    @property
    def DataInfoList(self):
        """播放状态码列表。
        :rtype: list of HttpStatusData
        """
        return self._DataInfoList

    @DataInfoList.setter
    def DataInfoList(self, DataInfoList):
        self._DataInfoList = DataInfoList

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DataInfoList") is not None:
            self._DataInfoList = []
            for item in params.get("DataInfoList"):
                obj = HttpStatusData()
                obj._deserialize(item)
                self._DataInfoList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLiveCallbackRulesRequest(AbstractModel):
    """DescribeLiveCallbackRules请求参数结构体

    """


class DescribeLiveCallbackRulesResponse(AbstractModel):
    """DescribeLiveCallbackRules返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Rules: 规则信息列表。
        :type Rules: list of CallBackRuleInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Rules = None
        self._RequestId = None

    @property
    def Rules(self):
        """规则信息列表。
        :rtype: list of CallBackRuleInfo
        """
        return self._Rules

    @Rules.setter
    def Rules(self, Rules):
        self._Rules = Rules

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Rules") is not None:
            self._Rules = []
            for item in params.get("Rules"):
                obj = CallBackRuleInfo()
                obj._deserialize(item)
                self._Rules.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLiveCallbackTemplateRequest(AbstractModel):
    """DescribeLiveCallbackTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TemplateId: 模板 ID。
1. 在创建回调模板接口 [CreateLiveCallbackTemplate](/document/product/267/32637) 调用的返回值中获取模板 ID。
2. 可以从接口 [DescribeLiveCallbackTemplates](/document/product/267/32632) 查询已经创建的过的模板列表。
        :type TemplateId: int
        """
        self._TemplateId = None

    @property
    def TemplateId(self):
        """模板 ID。
1. 在创建回调模板接口 [CreateLiveCallbackTemplate](/document/product/267/32637) 调用的返回值中获取模板 ID。
2. 可以从接口 [DescribeLiveCallbackTemplates](/document/product/267/32632) 查询已经创建的过的模板列表。
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLiveCallbackTemplateResponse(AbstractModel):
    """DescribeLiveCallbackTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Template: 回调模板信息。
        :type Template: :class:`tencentcloud.live.v20180801.models.CallBackTemplateInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Template = None
        self._RequestId = None

    @property
    def Template(self):
        """回调模板信息。
        :rtype: :class:`tencentcloud.live.v20180801.models.CallBackTemplateInfo`
        """
        return self._Template

    @Template.setter
    def Template(self, Template):
        self._Template = Template

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Template") is not None:
            self._Template = CallBackTemplateInfo()
            self._Template._deserialize(params.get("Template"))
        self._RequestId = params.get("RequestId")


class DescribeLiveCallbackTemplatesRequest(AbstractModel):
    """DescribeLiveCallbackTemplates请求参数结构体

    """


class DescribeLiveCallbackTemplatesResponse(AbstractModel):
    """DescribeLiveCallbackTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Templates: 模板信息列表。
        :type Templates: list of CallBackTemplateInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Templates = None
        self._RequestId = None

    @property
    def Templates(self):
        """模板信息列表。
        :rtype: list of CallBackTemplateInfo
        """
        return self._Templates

    @Templates.setter
    def Templates(self, Templates):
        self._Templates = Templates

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Templates") is not None:
            self._Templates = []
            for item in params.get("Templates"):
                obj = CallBackTemplateInfo()
                obj._deserialize(item)
                self._Templates.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLiveCertRequest(AbstractModel):
    """DescribeLiveCert请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CertId: DescribeLiveCerts接口获取到的证书Id。
        :type CertId: int
        """
        self._CertId = None

    @property
    def CertId(self):
        """DescribeLiveCerts接口获取到的证书Id。
        :rtype: int
        """
        return self._CertId

    @CertId.setter
    def CertId(self, CertId):
        self._CertId = CertId


    def _deserialize(self, params):
        self._CertId = params.get("CertId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLiveCertResponse(AbstractModel):
    """DescribeLiveCert返回参数结构体

    """

    def __init__(self):
        r"""
        :param _CertInfo: 证书信息。
        :type CertInfo: :class:`tencentcloud.live.v20180801.models.CertInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._CertInfo = None
        self._RequestId = None

    @property
    def CertInfo(self):
        """证书信息。
        :rtype: :class:`tencentcloud.live.v20180801.models.CertInfo`
        """
        return self._CertInfo

    @CertInfo.setter
    def CertInfo(self, CertInfo):
        self._CertInfo = CertInfo

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("CertInfo") is not None:
            self._CertInfo = CertInfo()
            self._CertInfo._deserialize(params.get("CertInfo"))
        self._RequestId = params.get("RequestId")


class DescribeLiveCertsRequest(AbstractModel):
    """DescribeLiveCerts请求参数结构体

    """


class DescribeLiveCertsResponse(AbstractModel):
    """DescribeLiveCerts返回参数结构体

    """

    def __init__(self):
        r"""
        :param _CertInfoSet: 证书信息列表。
        :type CertInfoSet: list of CertInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._CertInfoSet = None
        self._RequestId = None

    @property
    def CertInfoSet(self):
        """证书信息列表。
        :rtype: list of CertInfo
        """
        return self._CertInfoSet

    @CertInfoSet.setter
    def CertInfoSet(self, CertInfoSet):
        self._CertInfoSet = CertInfoSet

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("CertInfoSet") is not None:
            self._CertInfoSet = []
            for item in params.get("CertInfoSet"):
                obj = CertInfo()
                obj._deserialize(item)
                self._CertInfoSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLiveCloudEffectListRequest(AbstractModel):
    """DescribeLiveCloudEffectList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 云端特效ID。
        :type Id: str
        :param _Prompt: 云端特效描述词。由用户原始输入的描述词。
        :type Prompt: str
        :param _Flag: 云端特效标签。对云端特效进行分类标签，可用于分类搜索。
        :type Flag: str
        :param _Type: 云端特效类型, 默认不填，返回全部。PGC: 特效库中的特效；AICG : AI生成的特效；UGC：用户自定义上传的特效；
        :type Type: str
        """
        self._Id = None
        self._Prompt = None
        self._Flag = None
        self._Type = None

    @property
    def Id(self):
        """云端特效ID。
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Prompt(self):
        """云端特效描述词。由用户原始输入的描述词。
        :rtype: str
        """
        return self._Prompt

    @Prompt.setter
    def Prompt(self, Prompt):
        self._Prompt = Prompt

    @property
    def Flag(self):
        """云端特效标签。对云端特效进行分类标签，可用于分类搜索。
        :rtype: str
        """
        return self._Flag

    @Flag.setter
    def Flag(self, Flag):
        self._Flag = Flag

    @property
    def Type(self):
        """云端特效类型, 默认不填，返回全部。PGC: 特效库中的特效；AICG : AI生成的特效；UGC：用户自定义上传的特效；
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Prompt = params.get("Prompt")
        self._Flag = params.get("Flag")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLiveCloudEffectListResponse(AbstractModel):
    """DescribeLiveCloudEffectList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _InfoList: 云端特效信息列表。
        :type InfoList: list of CloudEffectInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._InfoList = None
        self._RequestId = None

    @property
    def InfoList(self):
        """云端特效信息列表。
        :rtype: list of CloudEffectInfo
        """
        return self._InfoList

    @InfoList.setter
    def InfoList(self, InfoList):
        self._InfoList = InfoList

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("InfoList") is not None:
            self._InfoList = []
            for item in params.get("InfoList"):
                obj = CloudEffectInfo()
                obj._deserialize(item)
                self._InfoList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLiveDelayInfoListRequest(AbstractModel):
    """DescribeLiveDelayInfoList请求参数结构体

    """


class DescribeLiveDelayInfoListResponse(AbstractModel):
    """DescribeLiveDelayInfoList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DelayInfoList: 延播信息列表。
        :type DelayInfoList: list of DelayInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DelayInfoList = None
        self._RequestId = None

    @property
    def DelayInfoList(self):
        """延播信息列表。
        :rtype: list of DelayInfo
        """
        return self._DelayInfoList

    @DelayInfoList.setter
    def DelayInfoList(self, DelayInfoList):
        self._DelayInfoList = DelayInfoList

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DelayInfoList") is not None:
            self._DelayInfoList = []
            for item in params.get("DelayInfoList"):
                obj = DelayInfo()
                obj._deserialize(item)
                self._DelayInfoList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLiveDomainCertBindingsRequest(AbstractModel):
    """DescribeLiveDomainCertBindings请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DomainSearch: 要搜索的域名字符串。
        :type DomainSearch: str
        :param _Offset: 记录行的位置，从0开始。默认0。
        :type Offset: int
        :param _Length: 记录行的最大数目。默认50。
若不传，则最多返回50条数据。
        :type Length: int
        :param _DomainName: 要查询的单个域名。
        :type DomainName: str
        :param _OrderBy: 可取值：
ExpireTimeAsc：证书过期时间升序。
ExpireTimeDesc：证书过期时间降序。
        :type OrderBy: str
        """
        self._DomainSearch = None
        self._Offset = None
        self._Length = None
        self._DomainName = None
        self._OrderBy = None

    @property
    def DomainSearch(self):
        """要搜索的域名字符串。
        :rtype: str
        """
        return self._DomainSearch

    @DomainSearch.setter
    def DomainSearch(self, DomainSearch):
        self._DomainSearch = DomainSearch

    @property
    def Offset(self):
        """记录行的位置，从0开始。默认0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Length(self):
        """记录行的最大数目。默认50。
若不传，则最多返回50条数据。
        :rtype: int
        """
        return self._Length

    @Length.setter
    def Length(self, Length):
        self._Length = Length

    @property
    def DomainName(self):
        """要查询的单个域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def OrderBy(self):
        """可取值：
ExpireTimeAsc：证书过期时间升序。
ExpireTimeDesc：证书过期时间降序。
        :rtype: str
        """
        return self._OrderBy

    @OrderBy.setter
    def OrderBy(self, OrderBy):
        self._OrderBy = OrderBy


    def _deserialize(self, params):
        self._DomainSearch = params.get("DomainSearch")
        self._Offset = params.get("Offset")
        self._Length = params.get("Length")
        self._DomainName = params.get("DomainName")
        self._OrderBy = params.get("OrderBy")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLiveDomainCertBindingsResponse(AbstractModel):
    """DescribeLiveDomainCertBindings返回参数结构体

    """

    def __init__(self):
        r"""
        :param _LiveDomainCertBindings: 有绑定证书的域名信息数组。
        :type LiveDomainCertBindings: list of LiveDomainCertBindings
        :param _TotalNum: 总的记录行数，便于分页。
        :type TotalNum: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._LiveDomainCertBindings = None
        self._TotalNum = None
        self._RequestId = None

    @property
    def LiveDomainCertBindings(self):
        """有绑定证书的域名信息数组。
        :rtype: list of LiveDomainCertBindings
        """
        return self._LiveDomainCertBindings

    @LiveDomainCertBindings.setter
    def LiveDomainCertBindings(self, LiveDomainCertBindings):
        self._LiveDomainCertBindings = LiveDomainCertBindings

    @property
    def TotalNum(self):
        """总的记录行数，便于分页。
        :rtype: int
        """
        return self._TotalNum

    @TotalNum.setter
    def TotalNum(self, TotalNum):
        self._TotalNum = TotalNum

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("LiveDomainCertBindings") is not None:
            self._LiveDomainCertBindings = []
            for item in params.get("LiveDomainCertBindings"):
                obj = LiveDomainCertBindings()
                obj._deserialize(item)
                self._LiveDomainCertBindings.append(obj)
        self._TotalNum = params.get("TotalNum")
        self._RequestId = params.get("RequestId")


class DescribeLiveDomainCertRequest(AbstractModel):
    """DescribeLiveDomainCert请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DomainName: 播放域名。
        :type DomainName: str
        """
        self._DomainName = None

    @property
    def DomainName(self):
        """播放域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName


    def _deserialize(self, params):
        self._DomainName = params.get("DomainName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLiveDomainCertResponse(AbstractModel):
    """DescribeLiveDomainCert返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DomainCertInfo: 证书信息。
        :type DomainCertInfo: :class:`tencentcloud.live.v20180801.models.DomainCertInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DomainCertInfo = None
        self._RequestId = None

    @property
    def DomainCertInfo(self):
        """证书信息。
        :rtype: :class:`tencentcloud.live.v20180801.models.DomainCertInfo`
        """
        return self._DomainCertInfo

    @DomainCertInfo.setter
    def DomainCertInfo(self, DomainCertInfo):
        self._DomainCertInfo = DomainCertInfo

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DomainCertInfo") is not None:
            self._DomainCertInfo = DomainCertInfo()
            self._DomainCertInfo._deserialize(params.get("DomainCertInfo"))
        self._RequestId = params.get("RequestId")


class DescribeLiveDomainPlayInfoListRequest(AbstractModel):
    """DescribeLiveDomainPlayInfoList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PlayDomains: 播放域名列表。
        :type PlayDomains: list of str
        """
        self._PlayDomains = None

    @property
    def PlayDomains(self):
        """播放域名列表。
        :rtype: list of str
        """
        return self._PlayDomains

    @PlayDomains.setter
    def PlayDomains(self, PlayDomains):
        self._PlayDomains = PlayDomains


    def _deserialize(self, params):
        self._PlayDomains = params.get("PlayDomains")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLiveDomainPlayInfoListResponse(AbstractModel):
    """DescribeLiveDomainPlayInfoList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Time: 数据时间，格式为yyyy-mm-dd HH:MM:SS。
        :type Time: str
        :param _TotalBandwidth: 实时总带宽。
        :type TotalBandwidth: float
        :param _TotalFlux: 实时总流量。
        :type TotalFlux: float
        :param _TotalRequest: 总请求数。
        :type TotalRequest: int
        :param _TotalOnline: 实时总连接数。
        :type TotalOnline: int
        :param _DomainInfoList: 分域名的数据情况。
        :type DomainInfoList: list of DomainInfoList
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Time = None
        self._TotalBandwidth = None
        self._TotalFlux = None
        self._TotalRequest = None
        self._TotalOnline = None
        self._DomainInfoList = None
        self._RequestId = None

    @property
    def Time(self):
        """数据时间，格式为yyyy-mm-dd HH:MM:SS。
        :rtype: str
        """
        return self._Time

    @Time.setter
    def Time(self, Time):
        self._Time = Time

    @property
    def TotalBandwidth(self):
        """实时总带宽。
        :rtype: float
        """
        return self._TotalBandwidth

    @TotalBandwidth.setter
    def TotalBandwidth(self, TotalBandwidth):
        self._TotalBandwidth = TotalBandwidth

    @property
    def TotalFlux(self):
        """实时总流量。
        :rtype: float
        """
        return self._TotalFlux

    @TotalFlux.setter
    def TotalFlux(self, TotalFlux):
        self._TotalFlux = TotalFlux

    @property
    def TotalRequest(self):
        """总请求数。
        :rtype: int
        """
        return self._TotalRequest

    @TotalRequest.setter
    def TotalRequest(self, TotalRequest):
        self._TotalRequest = TotalRequest

    @property
    def TotalOnline(self):
        """实时总连接数。
        :rtype: int
        """
        return self._TotalOnline

    @TotalOnline.setter
    def TotalOnline(self, TotalOnline):
        self._TotalOnline = TotalOnline

    @property
    def DomainInfoList(self):
        """分域名的数据情况。
        :rtype: list of DomainInfoList
        """
        return self._DomainInfoList

    @DomainInfoList.setter
    def DomainInfoList(self, DomainInfoList):
        self._DomainInfoList = DomainInfoList

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Time = params.get("Time")
        self._TotalBandwidth = params.get("TotalBandwidth")
        self._TotalFlux = params.get("TotalFlux")
        self._TotalRequest = params.get("TotalRequest")
        self._TotalOnline = params.get("TotalOnline")
        if params.get("DomainInfoList") is not None:
            self._DomainInfoList = []
            for item in params.get("DomainInfoList"):
                obj = DomainInfoList()
                obj._deserialize(item)
                self._DomainInfoList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLiveDomainRefererRequest(AbstractModel):
    """DescribeLiveDomainReferer请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DomainName: 播放域名。
        :type DomainName: str
        """
        self._DomainName = None

    @property
    def DomainName(self):
        """播放域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName


    def _deserialize(self, params):
        self._DomainName = params.get("DomainName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLiveDomainRefererResponse(AbstractModel):
    """DescribeLiveDomainReferer返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RefererAuthConfig: 域名 Referer 黑白名单配置。
        :type RefererAuthConfig: :class:`tencentcloud.live.v20180801.models.RefererAuthConfig`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RefererAuthConfig = None
        self._RequestId = None

    @property
    def RefererAuthConfig(self):
        """域名 Referer 黑白名单配置。
        :rtype: :class:`tencentcloud.live.v20180801.models.RefererAuthConfig`
        """
        return self._RefererAuthConfig

    @RefererAuthConfig.setter
    def RefererAuthConfig(self, RefererAuthConfig):
        self._RefererAuthConfig = RefererAuthConfig

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RefererAuthConfig") is not None:
            self._RefererAuthConfig = RefererAuthConfig()
            self._RefererAuthConfig._deserialize(params.get("RefererAuthConfig"))
        self._RequestId = params.get("RequestId")


class DescribeLiveDomainRequest(AbstractModel):
    """DescribeLiveDomain请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DomainName: 域名。
        :type DomainName: str
        """
        self._DomainName = None

    @property
    def DomainName(self):
        """域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName


    def _deserialize(self, params):
        self._DomainName = params.get("DomainName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLiveDomainResponse(AbstractModel):
    """DescribeLiveDomain返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DomainInfo: 域名信息。
        :type DomainInfo: :class:`tencentcloud.live.v20180801.models.DomainInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DomainInfo = None
        self._RequestId = None

    @property
    def DomainInfo(self):
        """域名信息。
        :rtype: :class:`tencentcloud.live.v20180801.models.DomainInfo`
        """
        return self._DomainInfo

    @DomainInfo.setter
    def DomainInfo(self, DomainInfo):
        self._DomainInfo = DomainInfo

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DomainInfo") is not None:
            self._DomainInfo = DomainInfo()
            self._DomainInfo._deserialize(params.get("DomainInfo"))
        self._RequestId = params.get("RequestId")


class DescribeLiveDomainsRequest(AbstractModel):
    """DescribeLiveDomains请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DomainStatus: 域名状态过滤。0-停用，1-启用。
        :type DomainStatus: int
        :param _DomainType: 域名类型过滤。0-推流，1-播放。
        :type DomainType: int
        :param _PageSize: 分页大小，范围：10~100。默认10。
        :type PageSize: int
        :param _PageNum: 取第几页，范围：1~100000。默认1。
        :type PageNum: int
        :param _IsDelayLive: 0 普通直播 1慢直播 默认0。
        :type IsDelayLive: int
        :param _DomainPrefix: 域名前缀。
        :type DomainPrefix: str
        :param _PlayType: 播放区域，只在 DomainType=1 时该参数有意义。
1: 国内。
2: 全球。
3: 海外。
        :type PlayType: int
        """
        self._DomainStatus = None
        self._DomainType = None
        self._PageSize = None
        self._PageNum = None
        self._IsDelayLive = None
        self._DomainPrefix = None
        self._PlayType = None

    @property
    def DomainStatus(self):
        """域名状态过滤。0-停用，1-启用。
        :rtype: int
        """
        return self._DomainStatus

    @DomainStatus.setter
    def DomainStatus(self, DomainStatus):
        self._DomainStatus = DomainStatus

    @property
    def DomainType(self):
        """域名类型过滤。0-推流，1-播放。
        :rtype: int
        """
        return self._DomainType

    @DomainType.setter
    def DomainType(self, DomainType):
        self._DomainType = DomainType

    @property
    def PageSize(self):
        """分页大小，范围：10~100。默认10。
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def PageNum(self):
        """取第几页，范围：1~100000。默认1。
        :rtype: int
        """
        return self._PageNum

    @PageNum.setter
    def PageNum(self, PageNum):
        self._PageNum = PageNum

    @property
    def IsDelayLive(self):
        """0 普通直播 1慢直播 默认0。
        :rtype: int
        """
        return self._IsDelayLive

    @IsDelayLive.setter
    def IsDelayLive(self, IsDelayLive):
        self._IsDelayLive = IsDelayLive

    @property
    def DomainPrefix(self):
        """域名前缀。
        :rtype: str
        """
        return self._DomainPrefix

    @DomainPrefix.setter
    def DomainPrefix(self, DomainPrefix):
        self._DomainPrefix = DomainPrefix

    @property
    def PlayType(self):
        """播放区域，只在 DomainType=1 时该参数有意义。
1: 国内。
2: 全球。
3: 海外。
        :rtype: int
        """
        return self._PlayType

    @PlayType.setter
    def PlayType(self, PlayType):
        self._PlayType = PlayType


    def _deserialize(self, params):
        self._DomainStatus = params.get("DomainStatus")
        self._DomainType = params.get("DomainType")
        self._PageSize = params.get("PageSize")
        self._PageNum = params.get("PageNum")
        self._IsDelayLive = params.get("IsDelayLive")
        self._DomainPrefix = params.get("DomainPrefix")
        self._PlayType = params.get("PlayType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLiveDomainsResponse(AbstractModel):
    """DescribeLiveDomains返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AllCount: 总记录数。
        :type AllCount: int
        :param _DomainList: 域名详细信息列表。
        :type DomainList: list of DomainInfo
        :param _CreateLimitCount: 可继续添加域名数量。
        :type CreateLimitCount: int
        :param _PlayTypeCount: 启用的播放域名加速区域统计，数组元素分别为：中国大陆（境内），全球地区，国际/港澳台（境外）域名数量。
        :type PlayTypeCount: list of int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AllCount = None
        self._DomainList = None
        self._CreateLimitCount = None
        self._PlayTypeCount = None
        self._RequestId = None

    @property
    def AllCount(self):
        """总记录数。
        :rtype: int
        """
        return self._AllCount

    @AllCount.setter
    def AllCount(self, AllCount):
        self._AllCount = AllCount

    @property
    def DomainList(self):
        """域名详细信息列表。
        :rtype: list of DomainInfo
        """
        return self._DomainList

    @DomainList.setter
    def DomainList(self, DomainList):
        self._DomainList = DomainList

    @property
    def CreateLimitCount(self):
        """可继续添加域名数量。
        :rtype: int
        """
        return self._CreateLimitCount

    @CreateLimitCount.setter
    def CreateLimitCount(self, CreateLimitCount):
        self._CreateLimitCount = CreateLimitCount

    @property
    def PlayTypeCount(self):
        """启用的播放域名加速区域统计，数组元素分别为：中国大陆（境内），全球地区，国际/港澳台（境外）域名数量。
        :rtype: list of int
        """
        return self._PlayTypeCount

    @PlayTypeCount.setter
    def PlayTypeCount(self, PlayTypeCount):
        self._PlayTypeCount = PlayTypeCount

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AllCount = params.get("AllCount")
        if params.get("DomainList") is not None:
            self._DomainList = []
            for item in params.get("DomainList"):
                obj = DomainInfo()
                obj._deserialize(item)
                self._DomainList.append(obj)
        self._CreateLimitCount = params.get("CreateLimitCount")
        self._PlayTypeCount = params.get("PlayTypeCount")
        self._RequestId = params.get("RequestId")


class DescribeLiveEnhanceInfoListRequest(AbstractModel):
    """DescribeLiveEnhanceInfoList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 起始时间点，使用ISO格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见[ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#:~:text=I-,ISO,-%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F)。
接口支持最近三个月的查询，开始时间和结束时间查询跨度不能超过三十天。
        :type StartTime: str
        :param _EndTime: 结束时间点，使用ISO格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见[ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#:~:text=I-,ISO,-%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F)。
接口支持最近三个月的查询，开始时间和结束时间查询跨度不能超过三十天。
        :type EndTime: str
        :param _Granularity: 查询粒度，支持5，60分钟。
        :type Granularity: int
        :param _DomainNames: 查询域名，如果不填则默认查全部的数据。
        :type DomainNames: list of str
        :param _Type: 增强服务类型，如果不填则默认查全部的数据。
        :type Type: list of str
        :param _Resolution: 分辨率，如果不填则默认查全部的数据。
        :type Resolution: list of str
        :param _Fps: 帧率，如果不填则默认查全部的数据。
        :type Fps: list of str
        """
        self._StartTime = None
        self._EndTime = None
        self._Granularity = None
        self._DomainNames = None
        self._Type = None
        self._Resolution = None
        self._Fps = None

    @property
    def StartTime(self):
        """起始时间点，使用ISO格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见[ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#:~:text=I-,ISO,-%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F)。
接口支持最近三个月的查询，开始时间和结束时间查询跨度不能超过三十天。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束时间点，使用ISO格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见[ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#:~:text=I-,ISO,-%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F)。
接口支持最近三个月的查询，开始时间和结束时间查询跨度不能超过三十天。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Granularity(self):
        """查询粒度，支持5，60分钟。
        :rtype: int
        """
        return self._Granularity

    @Granularity.setter
    def Granularity(self, Granularity):
        self._Granularity = Granularity

    @property
    def DomainNames(self):
        """查询域名，如果不填则默认查全部的数据。
        :rtype: list of str
        """
        return self._DomainNames

    @DomainNames.setter
    def DomainNames(self, DomainNames):
        self._DomainNames = DomainNames

    @property
    def Type(self):
        """增强服务类型，如果不填则默认查全部的数据。
        :rtype: list of str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Resolution(self):
        """分辨率，如果不填则默认查全部的数据。
        :rtype: list of str
        """
        return self._Resolution

    @Resolution.setter
    def Resolution(self, Resolution):
        self._Resolution = Resolution

    @property
    def Fps(self):
        """帧率，如果不填则默认查全部的数据。
        :rtype: list of str
        """
        return self._Fps

    @Fps.setter
    def Fps(self, Fps):
        self._Fps = Fps


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Granularity = params.get("Granularity")
        self._DomainNames = params.get("DomainNames")
        self._Type = params.get("Type")
        self._Resolution = params.get("Resolution")
        self._Fps = params.get("Fps")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLiveEnhanceInfoListResponse(AbstractModel):
    """DescribeLiveEnhanceInfoList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DataInfoList: 直播增强统计信息列表。
        :type DataInfoList: list of LiveEnhanceInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DataInfoList = None
        self._RequestId = None

    @property
    def DataInfoList(self):
        """直播增强统计信息列表。
        :rtype: list of LiveEnhanceInfo
        """
        return self._DataInfoList

    @DataInfoList.setter
    def DataInfoList(self, DataInfoList):
        self._DataInfoList = DataInfoList

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DataInfoList") is not None:
            self._DataInfoList = []
            for item in params.get("DataInfoList"):
                obj = LiveEnhanceInfo()
                obj._deserialize(item)
                self._DataInfoList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLiveForbidStreamListRequest(AbstractModel):
    """DescribeLiveForbidStreamList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PageNum: 取得第几页，默认1。
        :type PageNum: int
        :param _PageSize: 每页大小，最大100。 
取值：1~100之前的任意整数。
默认值：10。
        :type PageSize: int
        :param _StreamName: 按流名称查询。
        :type StreamName: str
        """
        self._PageNum = None
        self._PageSize = None
        self._StreamName = None

    @property
    def PageNum(self):
        """取得第几页，默认1。
        :rtype: int
        """
        return self._PageNum

    @PageNum.setter
    def PageNum(self, PageNum):
        self._PageNum = PageNum

    @property
    def PageSize(self):
        """每页大小，最大100。 
取值：1~100之前的任意整数。
默认值：10。
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def StreamName(self):
        """按流名称查询。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName


    def _deserialize(self, params):
        self._PageNum = params.get("PageNum")
        self._PageSize = params.get("PageSize")
        self._StreamName = params.get("StreamName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLiveForbidStreamListResponse(AbstractModel):
    """DescribeLiveForbidStreamList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalNum: 符合条件的总个数。
        :type TotalNum: int
        :param _TotalPage: 总页数。
        :type TotalPage: int
        :param _PageNum: 分页的页码。
        :type PageNum: int
        :param _PageSize: 每页显示的条数。
        :type PageSize: int
        :param _ForbidStreamList: 禁推流列表。
        :type ForbidStreamList: list of ForbidStreamInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalNum = None
        self._TotalPage = None
        self._PageNum = None
        self._PageSize = None
        self._ForbidStreamList = None
        self._RequestId = None

    @property
    def TotalNum(self):
        """符合条件的总个数。
        :rtype: int
        """
        return self._TotalNum

    @TotalNum.setter
    def TotalNum(self, TotalNum):
        self._TotalNum = TotalNum

    @property
    def TotalPage(self):
        """总页数。
        :rtype: int
        """
        return self._TotalPage

    @TotalPage.setter
    def TotalPage(self, TotalPage):
        self._TotalPage = TotalPage

    @property
    def PageNum(self):
        """分页的页码。
        :rtype: int
        """
        return self._PageNum

    @PageNum.setter
    def PageNum(self, PageNum):
        self._PageNum = PageNum

    @property
    def PageSize(self):
        """每页显示的条数。
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def ForbidStreamList(self):
        """禁推流列表。
        :rtype: list of ForbidStreamInfo
        """
        return self._ForbidStreamList

    @ForbidStreamList.setter
    def ForbidStreamList(self, ForbidStreamList):
        self._ForbidStreamList = ForbidStreamList

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalNum = params.get("TotalNum")
        self._TotalPage = params.get("TotalPage")
        self._PageNum = params.get("PageNum")
        self._PageSize = params.get("PageSize")
        if params.get("ForbidStreamList") is not None:
            self._ForbidStreamList = []
            for item in params.get("ForbidStreamList"):
                obj = ForbidStreamInfo()
                obj._deserialize(item)
                self._ForbidStreamList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLivePackageInfoRequest(AbstractModel):
    """DescribeLivePackageInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PackageType: 包类型，可选值：
0：流量包
1：转码包
2: 连麦包。
        :type PackageType: int
        :param _OrderBy: 排序规则:
1. BuyTimeDesc： 最新购买的排在最前面
2. BuyTimeAsc： 最老购买的排在最前面
3. ExpireTimeDesc： 最后过期的排在最前面
4. ExpireTimeAsc：最先过期的排在最前面。

注意：
1. PackageType 为 2（连麦包） 的时候，不支持 3、4 排序。
        :type OrderBy: str
        :param _PageNum: 取得第几页的数据，和 PageSize 同时传递才会生效。
        :type PageNum: int
        :param _PageSize: 分页大小，和 PageNum 同时传递才会生效。
取值：10 ～ 100 之间的任意整数。
        :type PageSize: int
        """
        self._PackageType = None
        self._OrderBy = None
        self._PageNum = None
        self._PageSize = None

    @property
    def PackageType(self):
        """包类型，可选值：
0：流量包
1：转码包
2: 连麦包。
        :rtype: int
        """
        return self._PackageType

    @PackageType.setter
    def PackageType(self, PackageType):
        self._PackageType = PackageType

    @property
    def OrderBy(self):
        """排序规则:
1. BuyTimeDesc： 最新购买的排在最前面
2. BuyTimeAsc： 最老购买的排在最前面
3. ExpireTimeDesc： 最后过期的排在最前面
4. ExpireTimeAsc：最先过期的排在最前面。

注意：
1. PackageType 为 2（连麦包） 的时候，不支持 3、4 排序。
        :rtype: str
        """
        return self._OrderBy

    @OrderBy.setter
    def OrderBy(self, OrderBy):
        self._OrderBy = OrderBy

    @property
    def PageNum(self):
        """取得第几页的数据，和 PageSize 同时传递才会生效。
        :rtype: int
        """
        return self._PageNum

    @PageNum.setter
    def PageNum(self, PageNum):
        self._PageNum = PageNum

    @property
    def PageSize(self):
        """分页大小，和 PageNum 同时传递才会生效。
取值：10 ～ 100 之间的任意整数。
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        self._PackageType = params.get("PackageType")
        self._OrderBy = params.get("OrderBy")
        self._PageNum = params.get("PageNum")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLivePackageInfoResponse(AbstractModel):
    """DescribeLivePackageInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _LivePackageInfoList: 套餐包信息。
        :type LivePackageInfoList: list of LivePackageInfo
        :param _PackageBillMode: 套餐包当前计费方式:
-1: 无计费方式或获取失败
0: 无计费方式
201: 月结带宽
202: 月结流量
203: 日结带宽
204: 日结流量
205: 日结时长
206: 月结时长
304: 日结流量。
        :type PackageBillMode: int
        :param _TotalPage: 总页数。
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalPage: int
        :param _TotalNum: 数据总条数。
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalNum: int
        :param _PageNum: 当前页数。
注意：此字段可能返回 null，表示取不到有效值。
        :type PageNum: int
        :param _PageSize: 当前每页数量。
注意：此字段可能返回 null，表示取不到有效值。
        :type PageSize: int
        :param _FluxPackageBillMode: 当请求参数 PackageType = 0 时生效，逗号分隔，从第一个到最后一个分别表示：
标准直播，中国大陆（境内全地区）计费方式。
标准直播，国际/港澳台（境外多地区）计费方式。
快直播，中国大陆（境内全地区）计费方式。
快直播，国际/港澳台（境外多地区）计费方式。
        :type FluxPackageBillMode: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._LivePackageInfoList = None
        self._PackageBillMode = None
        self._TotalPage = None
        self._TotalNum = None
        self._PageNum = None
        self._PageSize = None
        self._FluxPackageBillMode = None
        self._RequestId = None

    @property
    def LivePackageInfoList(self):
        """套餐包信息。
        :rtype: list of LivePackageInfo
        """
        return self._LivePackageInfoList

    @LivePackageInfoList.setter
    def LivePackageInfoList(self, LivePackageInfoList):
        self._LivePackageInfoList = LivePackageInfoList

    @property
    def PackageBillMode(self):
        """套餐包当前计费方式:
-1: 无计费方式或获取失败
0: 无计费方式
201: 月结带宽
202: 月结流量
203: 日结带宽
204: 日结流量
205: 日结时长
206: 月结时长
304: 日结流量。
        :rtype: int
        """
        return self._PackageBillMode

    @PackageBillMode.setter
    def PackageBillMode(self, PackageBillMode):
        self._PackageBillMode = PackageBillMode

    @property
    def TotalPage(self):
        """总页数。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TotalPage

    @TotalPage.setter
    def TotalPage(self, TotalPage):
        self._TotalPage = TotalPage

    @property
    def TotalNum(self):
        """数据总条数。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._TotalNum

    @TotalNum.setter
    def TotalNum(self, TotalNum):
        self._TotalNum = TotalNum

    @property
    def PageNum(self):
        """当前页数。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._PageNum

    @PageNum.setter
    def PageNum(self, PageNum):
        self._PageNum = PageNum

    @property
    def PageSize(self):
        """当前每页数量。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def FluxPackageBillMode(self):
        """当请求参数 PackageType = 0 时生效，逗号分隔，从第一个到最后一个分别表示：
标准直播，中国大陆（境内全地区）计费方式。
标准直播，国际/港澳台（境外多地区）计费方式。
快直播，中国大陆（境内全地区）计费方式。
快直播，国际/港澳台（境外多地区）计费方式。
        :rtype: str
        """
        return self._FluxPackageBillMode

    @FluxPackageBillMode.setter
    def FluxPackageBillMode(self, FluxPackageBillMode):
        self._FluxPackageBillMode = FluxPackageBillMode

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("LivePackageInfoList") is not None:
            self._LivePackageInfoList = []
            for item in params.get("LivePackageInfoList"):
                obj = LivePackageInfo()
                obj._deserialize(item)
                self._LivePackageInfoList.append(obj)
        self._PackageBillMode = params.get("PackageBillMode")
        self._TotalPage = params.get("TotalPage")
        self._TotalNum = params.get("TotalNum")
        self._PageNum = params.get("PageNum")
        self._PageSize = params.get("PageSize")
        self._FluxPackageBillMode = params.get("FluxPackageBillMode")
        self._RequestId = params.get("RequestId")


class DescribeLivePadRulesRequest(AbstractModel):
    """DescribeLivePadRules请求参数结构体

    """


class DescribeLivePadRulesResponse(AbstractModel):
    """DescribeLivePadRules返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Rules: 规则信息列表。
        :type Rules: list of RuleInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Rules = None
        self._RequestId = None

    @property
    def Rules(self):
        """规则信息列表。
        :rtype: list of RuleInfo
        """
        return self._Rules

    @Rules.setter
    def Rules(self, Rules):
        self._Rules = Rules

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Rules") is not None:
            self._Rules = []
            for item in params.get("Rules"):
                obj = RuleInfo()
                obj._deserialize(item)
                self._Rules.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLivePadStreamListRequest(AbstractModel):
    """DescribeLivePadStreamList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AppName: 推流路径，与推流和播放地址中的AppName保持一致，默认为 live。
        :type AppName: str
        :param _DomainName: 您的推流域名。
        :type DomainName: str
        :param _StreamName: 流名称。
        :type StreamName: str
        :param _PageNum: 分页页数。
        :type PageNum: int
        :param _PageSize: 每页个数。
        :type PageSize: int
        """
        self._AppName = None
        self._DomainName = None
        self._StreamName = None
        self._PageNum = None
        self._PageSize = None

    @property
    def AppName(self):
        """推流路径，与推流和播放地址中的AppName保持一致，默认为 live。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def DomainName(self):
        """您的推流域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def StreamName(self):
        """流名称。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName

    @property
    def PageNum(self):
        """分页页数。
        :rtype: int
        """
        return self._PageNum

    @PageNum.setter
    def PageNum(self, PageNum):
        self._PageNum = PageNum

    @property
    def PageSize(self):
        """每页个数。
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        self._AppName = params.get("AppName")
        self._DomainName = params.get("DomainName")
        self._StreamName = params.get("StreamName")
        self._PageNum = params.get("PageNum")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLivePadStreamListResponse(AbstractModel):
    """DescribeLivePadStreamList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _StreamInfoList: 当前正在拉取垫片的流信息列表。
        :type StreamInfoList: list of PadStreamInfo
        :param _PageNum: 传入的分页页数。
        :type PageNum: int
        :param _PageSize: 传入的分页个数。
        :type PageSize: int
        :param _TotalNum: 查询到的总个数。
        :type TotalNum: int
        :param _TotalPage: 可以分的总页数。
        :type TotalPage: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._StreamInfoList = None
        self._PageNum = None
        self._PageSize = None
        self._TotalNum = None
        self._TotalPage = None
        self._RequestId = None

    @property
    def StreamInfoList(self):
        """当前正在拉取垫片的流信息列表。
        :rtype: list of PadStreamInfo
        """
        return self._StreamInfoList

    @StreamInfoList.setter
    def StreamInfoList(self, StreamInfoList):
        self._StreamInfoList = StreamInfoList

    @property
    def PageNum(self):
        """传入的分页页数。
        :rtype: int
        """
        return self._PageNum

    @PageNum.setter
    def PageNum(self, PageNum):
        self._PageNum = PageNum

    @property
    def PageSize(self):
        """传入的分页个数。
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def TotalNum(self):
        """查询到的总个数。
        :rtype: int
        """
        return self._TotalNum

    @TotalNum.setter
    def TotalNum(self, TotalNum):
        self._TotalNum = TotalNum

    @property
    def TotalPage(self):
        """可以分的总页数。
        :rtype: int
        """
        return self._TotalPage

    @TotalPage.setter
    def TotalPage(self, TotalPage):
        self._TotalPage = TotalPage

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("StreamInfoList") is not None:
            self._StreamInfoList = []
            for item in params.get("StreamInfoList"):
                obj = PadStreamInfo()
                obj._deserialize(item)
                self._StreamInfoList.append(obj)
        self._PageNum = params.get("PageNum")
        self._PageSize = params.get("PageSize")
        self._TotalNum = params.get("TotalNum")
        self._TotalPage = params.get("TotalPage")
        self._RequestId = params.get("RequestId")


class DescribeLivePadTemplateRequest(AbstractModel):
    """DescribeLivePadTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TemplateId: 模板id。
        :type TemplateId: int
        """
        self._TemplateId = None

    @property
    def TemplateId(self):
        """模板id。
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLivePadTemplateResponse(AbstractModel):
    """DescribeLivePadTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Template: 直播垫片模板信息。
        :type Template: :class:`tencentcloud.live.v20180801.models.PadTemplate`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Template = None
        self._RequestId = None

    @property
    def Template(self):
        """直播垫片模板信息。
        :rtype: :class:`tencentcloud.live.v20180801.models.PadTemplate`
        """
        return self._Template

    @Template.setter
    def Template(self, Template):
        self._Template = Template

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Template") is not None:
            self._Template = PadTemplate()
            self._Template._deserialize(params.get("Template"))
        self._RequestId = params.get("RequestId")


class DescribeLivePadTemplatesRequest(AbstractModel):
    """DescribeLivePadTemplates请求参数结构体

    """


class DescribeLivePadTemplatesResponse(AbstractModel):
    """DescribeLivePadTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Templates: 直播垫片模板信息。
        :type Templates: list of PadTemplate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Templates = None
        self._RequestId = None

    @property
    def Templates(self):
        """直播垫片模板信息。
        :rtype: list of PadTemplate
        """
        return self._Templates

    @Templates.setter
    def Templates(self, Templates):
        self._Templates = Templates

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Templates") is not None:
            self._Templates = []
            for item in params.get("Templates"):
                obj = PadTemplate()
                obj._deserialize(item)
                self._Templates.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLivePlayAuthKeyRequest(AbstractModel):
    """DescribeLivePlayAuthKey请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DomainName: 域名。
        :type DomainName: str
        """
        self._DomainName = None

    @property
    def DomainName(self):
        """域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName


    def _deserialize(self, params):
        self._DomainName = params.get("DomainName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLivePlayAuthKeyResponse(AbstractModel):
    """DescribeLivePlayAuthKey返回参数结构体

    """

    def __init__(self):
        r"""
        :param _PlayAuthKeyInfo: 播放鉴权key信息。
        :type PlayAuthKeyInfo: :class:`tencentcloud.live.v20180801.models.PlayAuthKeyInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._PlayAuthKeyInfo = None
        self._RequestId = None

    @property
    def PlayAuthKeyInfo(self):
        """播放鉴权key信息。
        :rtype: :class:`tencentcloud.live.v20180801.models.PlayAuthKeyInfo`
        """
        return self._PlayAuthKeyInfo

    @PlayAuthKeyInfo.setter
    def PlayAuthKeyInfo(self, PlayAuthKeyInfo):
        self._PlayAuthKeyInfo = PlayAuthKeyInfo

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("PlayAuthKeyInfo") is not None:
            self._PlayAuthKeyInfo = PlayAuthKeyInfo()
            self._PlayAuthKeyInfo._deserialize(params.get("PlayAuthKeyInfo"))
        self._RequestId = params.get("RequestId")


class DescribeLivePullStreamTaskStatusRequest(AbstractModel):
    """DescribeLivePullStreamTaskStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务 ID。
        :type TaskId: str
        """
        self._TaskId = None

    @property
    def TaskId(self):
        """任务 ID。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLivePullStreamTaskStatusResponse(AbstractModel):
    """DescribeLivePullStreamTaskStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskStatusInfo: 任务状态信息。
        :type TaskStatusInfo: :class:`tencentcloud.live.v20180801.models.TaskStatusInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskStatusInfo = None
        self._RequestId = None

    @property
    def TaskStatusInfo(self):
        """任务状态信息。
        :rtype: :class:`tencentcloud.live.v20180801.models.TaskStatusInfo`
        """
        return self._TaskStatusInfo

    @TaskStatusInfo.setter
    def TaskStatusInfo(self, TaskStatusInfo):
        self._TaskStatusInfo = TaskStatusInfo

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TaskStatusInfo") is not None:
            self._TaskStatusInfo = TaskStatusInfo()
            self._TaskStatusInfo._deserialize(params.get("TaskStatusInfo"))
        self._RequestId = params.get("RequestId")


class DescribeLivePullStreamTasksRequest(AbstractModel):
    """DescribeLivePullStreamTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务 ID。 
来源：调用 CreateLivePullStreamTask 接口时返回。
不填默认查询所有任务，按更新时间倒序排序。
        :type TaskId: str
        :param _PageNum: 取得第几页，默认值：1。
        :type PageNum: int
        :param _PageSize: 分页大小，默认值：10。
取值范围：1~20 之前的任意整数。
        :type PageSize: int
        :param _SpecifyTaskId: 使用指定任务 ID 查询任务信息。
注意：仅供使用指定 ID 创建的任务查询。
        :type SpecifyTaskId: str
        """
        self._TaskId = None
        self._PageNum = None
        self._PageSize = None
        self._SpecifyTaskId = None

    @property
    def TaskId(self):
        """任务 ID。 
来源：调用 CreateLivePullStreamTask 接口时返回。
不填默认查询所有任务，按更新时间倒序排序。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def PageNum(self):
        """取得第几页，默认值：1。
        :rtype: int
        """
        return self._PageNum

    @PageNum.setter
    def PageNum(self, PageNum):
        self._PageNum = PageNum

    @property
    def PageSize(self):
        """分页大小，默认值：10。
取值范围：1~20 之前的任意整数。
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def SpecifyTaskId(self):
        """使用指定任务 ID 查询任务信息。
注意：仅供使用指定 ID 创建的任务查询。
        :rtype: str
        """
        return self._SpecifyTaskId

    @SpecifyTaskId.setter
    def SpecifyTaskId(self, SpecifyTaskId):
        self._SpecifyTaskId = SpecifyTaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._PageNum = params.get("PageNum")
        self._PageSize = params.get("PageSize")
        self._SpecifyTaskId = params.get("SpecifyTaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLivePullStreamTasksResponse(AbstractModel):
    """DescribeLivePullStreamTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskInfos: 直播拉流任务信息列表。
        :type TaskInfos: list of PullStreamTaskInfo
        :param _PageNum: 分页的页码。
        :type PageNum: int
        :param _PageSize: 每页大小。
        :type PageSize: int
        :param _TotalNum: 符合条件的总个数。
        :type TotalNum: int
        :param _TotalPage: 总页数。
        :type TotalPage: int
        :param _LimitTaskNum: 限制可创建的最大任务数。
        :type LimitTaskNum: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskInfos = None
        self._PageNum = None
        self._PageSize = None
        self._TotalNum = None
        self._TotalPage = None
        self._LimitTaskNum = None
        self._RequestId = None

    @property
    def TaskInfos(self):
        """直播拉流任务信息列表。
        :rtype: list of PullStreamTaskInfo
        """
        return self._TaskInfos

    @TaskInfos.setter
    def TaskInfos(self, TaskInfos):
        self._TaskInfos = TaskInfos

    @property
    def PageNum(self):
        """分页的页码。
        :rtype: int
        """
        return self._PageNum

    @PageNum.setter
    def PageNum(self, PageNum):
        self._PageNum = PageNum

    @property
    def PageSize(self):
        """每页大小。
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def TotalNum(self):
        """符合条件的总个数。
        :rtype: int
        """
        return self._TotalNum

    @TotalNum.setter
    def TotalNum(self, TotalNum):
        self._TotalNum = TotalNum

    @property
    def TotalPage(self):
        """总页数。
        :rtype: int
        """
        return self._TotalPage

    @TotalPage.setter
    def TotalPage(self, TotalPage):
        self._TotalPage = TotalPage

    @property
    def LimitTaskNum(self):
        """限制可创建的最大任务数。
        :rtype: int
        """
        return self._LimitTaskNum

    @LimitTaskNum.setter
    def LimitTaskNum(self, LimitTaskNum):
        self._LimitTaskNum = LimitTaskNum

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TaskInfos") is not None:
            self._TaskInfos = []
            for item in params.get("TaskInfos"):
                obj = PullStreamTaskInfo()
                obj._deserialize(item)
                self._TaskInfos.append(obj)
        self._PageNum = params.get("PageNum")
        self._PageSize = params.get("PageSize")
        self._TotalNum = params.get("TotalNum")
        self._TotalPage = params.get("TotalPage")
        self._LimitTaskNum = params.get("LimitTaskNum")
        self._RequestId = params.get("RequestId")


class DescribeLivePushAuthKeyRequest(AbstractModel):
    """DescribeLivePushAuthKey请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DomainName: 推流域名。
        :type DomainName: str
        """
        self._DomainName = None

    @property
    def DomainName(self):
        """推流域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName


    def _deserialize(self, params):
        self._DomainName = params.get("DomainName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLivePushAuthKeyResponse(AbstractModel):
    """DescribeLivePushAuthKey返回参数结构体

    """

    def __init__(self):
        r"""
        :param _PushAuthKeyInfo: 推流鉴权key信息。
        :type PushAuthKeyInfo: :class:`tencentcloud.live.v20180801.models.PushAuthKeyInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._PushAuthKeyInfo = None
        self._RequestId = None

    @property
    def PushAuthKeyInfo(self):
        """推流鉴权key信息。
        :rtype: :class:`tencentcloud.live.v20180801.models.PushAuthKeyInfo`
        """
        return self._PushAuthKeyInfo

    @PushAuthKeyInfo.setter
    def PushAuthKeyInfo(self, PushAuthKeyInfo):
        self._PushAuthKeyInfo = PushAuthKeyInfo

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("PushAuthKeyInfo") is not None:
            self._PushAuthKeyInfo = PushAuthKeyInfo()
            self._PushAuthKeyInfo._deserialize(params.get("PushAuthKeyInfo"))
        self._RequestId = params.get("RequestId")


class DescribeLiveRecordRulesRequest(AbstractModel):
    """DescribeLiveRecordRules请求参数结构体

    """


class DescribeLiveRecordRulesResponse(AbstractModel):
    """DescribeLiveRecordRules返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Rules: 规则列表。
        :type Rules: list of RuleInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Rules = None
        self._RequestId = None

    @property
    def Rules(self):
        """规则列表。
        :rtype: list of RuleInfo
        """
        return self._Rules

    @Rules.setter
    def Rules(self, Rules):
        self._Rules = Rules

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Rules") is not None:
            self._Rules = []
            for item in params.get("Rules"):
                obj = RuleInfo()
                obj._deserialize(item)
                self._Rules.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLiveRecordTemplateRequest(AbstractModel):
    """DescribeLiveRecordTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TemplateId: [DescribeLiveRecordTemplates](/document/product/267/32609)接口获取到的模板 ID。
        :type TemplateId: int
        """
        self._TemplateId = None

    @property
    def TemplateId(self):
        """[DescribeLiveRecordTemplates](/document/product/267/32609)接口获取到的模板 ID。
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLiveRecordTemplateResponse(AbstractModel):
    """DescribeLiveRecordTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Template: 录制模板信息。
        :type Template: :class:`tencentcloud.live.v20180801.models.RecordTemplateInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Template = None
        self._RequestId = None

    @property
    def Template(self):
        """录制模板信息。
        :rtype: :class:`tencentcloud.live.v20180801.models.RecordTemplateInfo`
        """
        return self._Template

    @Template.setter
    def Template(self, Template):
        self._Template = Template

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Template") is not None:
            self._Template = RecordTemplateInfo()
            self._Template._deserialize(params.get("Template"))
        self._RequestId = params.get("RequestId")


class DescribeLiveRecordTemplatesRequest(AbstractModel):
    """DescribeLiveRecordTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _IsDelayLive: 是否属于慢直播模板，默认：0。
0： 标准直播。
1：慢直播。
        :type IsDelayLive: int
        """
        self._IsDelayLive = None

    @property
    def IsDelayLive(self):
        """是否属于慢直播模板，默认：0。
0： 标准直播。
1：慢直播。
        :rtype: int
        """
        return self._IsDelayLive

    @IsDelayLive.setter
    def IsDelayLive(self, IsDelayLive):
        self._IsDelayLive = IsDelayLive


    def _deserialize(self, params):
        self._IsDelayLive = params.get("IsDelayLive")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLiveRecordTemplatesResponse(AbstractModel):
    """DescribeLiveRecordTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Templates: 录制模板信息列表。
        :type Templates: list of RecordTemplateInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Templates = None
        self._RequestId = None

    @property
    def Templates(self):
        """录制模板信息列表。
        :rtype: list of RecordTemplateInfo
        """
        return self._Templates

    @Templates.setter
    def Templates(self, Templates):
        self._Templates = Templates

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Templates") is not None:
            self._Templates = []
            for item in params.get("Templates"):
                obj = RecordTemplateInfo()
                obj._deserialize(item)
                self._Templates.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLiveSnapshotRulesRequest(AbstractModel):
    """DescribeLiveSnapshotRules请求参数结构体

    """


class DescribeLiveSnapshotRulesResponse(AbstractModel):
    """DescribeLiveSnapshotRules返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Rules: 规则列表。
        :type Rules: list of RuleInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Rules = None
        self._RequestId = None

    @property
    def Rules(self):
        """规则列表。
        :rtype: list of RuleInfo
        """
        return self._Rules

    @Rules.setter
    def Rules(self, Rules):
        self._Rules = Rules

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Rules") is not None:
            self._Rules = []
            for item in params.get("Rules"):
                obj = RuleInfo()
                obj._deserialize(item)
                self._Rules.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLiveSnapshotTemplateRequest(AbstractModel):
    """DescribeLiveSnapshotTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TemplateId: 模板 ID。
调用 [CreateLiveSnapshotTemplate](/document/product/267/32624) 时返回的模板 ID。
        :type TemplateId: int
        """
        self._TemplateId = None

    @property
    def TemplateId(self):
        """模板 ID。
调用 [CreateLiveSnapshotTemplate](/document/product/267/32624) 时返回的模板 ID。
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLiveSnapshotTemplateResponse(AbstractModel):
    """DescribeLiveSnapshotTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Template: 截图模板信息。
        :type Template: :class:`tencentcloud.live.v20180801.models.SnapshotTemplateInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Template = None
        self._RequestId = None

    @property
    def Template(self):
        """截图模板信息。
        :rtype: :class:`tencentcloud.live.v20180801.models.SnapshotTemplateInfo`
        """
        return self._Template

    @Template.setter
    def Template(self, Template):
        self._Template = Template

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Template") is not None:
            self._Template = SnapshotTemplateInfo()
            self._Template._deserialize(params.get("Template"))
        self._RequestId = params.get("RequestId")


class DescribeLiveSnapshotTemplatesRequest(AbstractModel):
    """DescribeLiveSnapshotTemplates请求参数结构体

    """


class DescribeLiveSnapshotTemplatesResponse(AbstractModel):
    """DescribeLiveSnapshotTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Templates: 截图模板列表。
        :type Templates: list of SnapshotTemplateInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Templates = None
        self._RequestId = None

    @property
    def Templates(self):
        """截图模板列表。
        :rtype: list of SnapshotTemplateInfo
        """
        return self._Templates

    @Templates.setter
    def Templates(self, Templates):
        self._Templates = Templates

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Templates") is not None:
            self._Templates = []
            for item in params.get("Templates"):
                obj = SnapshotTemplateInfo()
                obj._deserialize(item)
                self._Templates.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLiveStreamEventListRequest(AbstractModel):
    """DescribeLiveStreamEventList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 起始时间。 UTC 格式，例如：2018-12-29T19:00:00Z。支持查询2个月内的历史记录。
        :type StartTime: str
        :param _EndTime: 结束时间。UTC 格式，例如：2018-12-29T20:00:00Z。不超过当前时间，且和起始时间相差不得超过1个月。
        :type EndTime: str
        :param _AppName: 推流路径，与推流和播放地址中的AppName保持一致，默认为 live。
        :type AppName: str
        :param _DomainName: 推流域名。
        :type DomainName: str
        :param _StreamName: 流名称，不支持通配符（*）查询，默认模糊匹配。
可使用IsStrict字段改为精确查询。
        :type StreamName: str
        :param _PageNum: 取得第几页。
默认值：1。
注： 目前只支持10000条内的查询。
        :type PageNum: int
        :param _PageSize: 分页大小。
最大值：100。
取值范围：1~100 之间的任意整数。
默认值：10。
注： 目前只支持10000条内的查询。
        :type PageSize: int
        :param _IsFilter: 是否过滤，默认不过滤。
0：不进行任何过滤。
1：过滤掉开播失败的，只返回开播成功的。
        :type IsFilter: int
        :param _IsStrict: 是否精确查询，默认模糊匹配。
0：模糊匹配。
1：精确查询。
注：使用StreamName时该参数生效。
        :type IsStrict: int
        :param _IsAsc: 是否按结束时间正序显示，默认逆序。
0：逆序。
1：正序。
        :type IsAsc: int
        """
        self._StartTime = None
        self._EndTime = None
        self._AppName = None
        self._DomainName = None
        self._StreamName = None
        self._PageNum = None
        self._PageSize = None
        self._IsFilter = None
        self._IsStrict = None
        self._IsAsc = None

    @property
    def StartTime(self):
        """起始时间。 UTC 格式，例如：2018-12-29T19:00:00Z。支持查询2个月内的历史记录。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束时间。UTC 格式，例如：2018-12-29T20:00:00Z。不超过当前时间，且和起始时间相差不得超过1个月。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def AppName(self):
        """推流路径，与推流和播放地址中的AppName保持一致，默认为 live。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def DomainName(self):
        """推流域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def StreamName(self):
        """流名称，不支持通配符（*）查询，默认模糊匹配。
可使用IsStrict字段改为精确查询。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName

    @property
    def PageNum(self):
        """取得第几页。
默认值：1。
注： 目前只支持10000条内的查询。
        :rtype: int
        """
        return self._PageNum

    @PageNum.setter
    def PageNum(self, PageNum):
        self._PageNum = PageNum

    @property
    def PageSize(self):
        """分页大小。
最大值：100。
取值范围：1~100 之间的任意整数。
默认值：10。
注： 目前只支持10000条内的查询。
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def IsFilter(self):
        """是否过滤，默认不过滤。
0：不进行任何过滤。
1：过滤掉开播失败的，只返回开播成功的。
        :rtype: int
        """
        return self._IsFilter

    @IsFilter.setter
    def IsFilter(self, IsFilter):
        self._IsFilter = IsFilter

    @property
    def IsStrict(self):
        """是否精确查询，默认模糊匹配。
0：模糊匹配。
1：精确查询。
注：使用StreamName时该参数生效。
        :rtype: int
        """
        return self._IsStrict

    @IsStrict.setter
    def IsStrict(self, IsStrict):
        self._IsStrict = IsStrict

    @property
    def IsAsc(self):
        """是否按结束时间正序显示，默认逆序。
0：逆序。
1：正序。
        :rtype: int
        """
        return self._IsAsc

    @IsAsc.setter
    def IsAsc(self, IsAsc):
        self._IsAsc = IsAsc


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._AppName = params.get("AppName")
        self._DomainName = params.get("DomainName")
        self._StreamName = params.get("StreamName")
        self._PageNum = params.get("PageNum")
        self._PageSize = params.get("PageSize")
        self._IsFilter = params.get("IsFilter")
        self._IsStrict = params.get("IsStrict")
        self._IsAsc = params.get("IsAsc")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLiveStreamEventListResponse(AbstractModel):
    """DescribeLiveStreamEventList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _EventList: 推断流事件列表。
        :type EventList: list of StreamEventInfo
        :param _PageNum: 分页的页码。
        :type PageNum: int
        :param _PageSize: 每页大小。
        :type PageSize: int
        :param _TotalNum: 符合条件的总个数。
        :type TotalNum: int
        :param _TotalPage: 总页数。
        :type TotalPage: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._EventList = None
        self._PageNum = None
        self._PageSize = None
        self._TotalNum = None
        self._TotalPage = None
        self._RequestId = None

    @property
    def EventList(self):
        """推断流事件列表。
        :rtype: list of StreamEventInfo
        """
        return self._EventList

    @EventList.setter
    def EventList(self, EventList):
        self._EventList = EventList

    @property
    def PageNum(self):
        """分页的页码。
        :rtype: int
        """
        return self._PageNum

    @PageNum.setter
    def PageNum(self, PageNum):
        self._PageNum = PageNum

    @property
    def PageSize(self):
        """每页大小。
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def TotalNum(self):
        """符合条件的总个数。
        :rtype: int
        """
        return self._TotalNum

    @TotalNum.setter
    def TotalNum(self, TotalNum):
        self._TotalNum = TotalNum

    @property
    def TotalPage(self):
        """总页数。
        :rtype: int
        """
        return self._TotalPage

    @TotalPage.setter
    def TotalPage(self, TotalPage):
        self._TotalPage = TotalPage

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("EventList") is not None:
            self._EventList = []
            for item in params.get("EventList"):
                obj = StreamEventInfo()
                obj._deserialize(item)
                self._EventList.append(obj)
        self._PageNum = params.get("PageNum")
        self._PageSize = params.get("PageSize")
        self._TotalNum = params.get("TotalNum")
        self._TotalPage = params.get("TotalPage")
        self._RequestId = params.get("RequestId")


class DescribeLiveStreamMonitorListRequest(AbstractModel):
    """DescribeLiveStreamMonitorList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Index: 查询列表时的起始偏移。
        :type Index: int
        :param _Count: 本次查询的记录个数。最小值为1。
        :type Count: int
        """
        self._Index = None
        self._Count = None

    @property
    def Index(self):
        """查询列表时的起始偏移。
        :rtype: int
        """
        return self._Index

    @Index.setter
    def Index(self, Index):
        self._Index = Index

    @property
    def Count(self):
        """本次查询的记录个数。最小值为1。
        :rtype: int
        """
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count


    def _deserialize(self, params):
        self._Index = params.get("Index")
        self._Count = params.get("Count")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLiveStreamMonitorListResponse(AbstractModel):
    """DescribeLiveStreamMonitorList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalNum: 账号下的直播流监播任务个数。
        :type TotalNum: int
        :param _LiveStreamMonitors: 直播流监播任务列表
        :type LiveStreamMonitors: list of LiveStreamMonitorInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalNum = None
        self._LiveStreamMonitors = None
        self._RequestId = None

    @property
    def TotalNum(self):
        """账号下的直播流监播任务个数。
        :rtype: int
        """
        return self._TotalNum

    @TotalNum.setter
    def TotalNum(self, TotalNum):
        self._TotalNum = TotalNum

    @property
    def LiveStreamMonitors(self):
        """直播流监播任务列表
        :rtype: list of LiveStreamMonitorInfo
        """
        return self._LiveStreamMonitors

    @LiveStreamMonitors.setter
    def LiveStreamMonitors(self, LiveStreamMonitors):
        self._LiveStreamMonitors = LiveStreamMonitors

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalNum = params.get("TotalNum")
        if params.get("LiveStreamMonitors") is not None:
            self._LiveStreamMonitors = []
            for item in params.get("LiveStreamMonitors"):
                obj = LiveStreamMonitorInfo()
                obj._deserialize(item)
                self._LiveStreamMonitors.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLiveStreamMonitorRequest(AbstractModel):
    """DescribeLiveStreamMonitor请求参数结构体

    """

    def __init__(self):
        r"""
        :param _MonitorId: 监播任务ID。
        :type MonitorId: str
        """
        self._MonitorId = None

    @property
    def MonitorId(self):
        """监播任务ID。
        :rtype: str
        """
        return self._MonitorId

    @MonitorId.setter
    def MonitorId(self, MonitorId):
        self._MonitorId = MonitorId


    def _deserialize(self, params):
        self._MonitorId = params.get("MonitorId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLiveStreamMonitorResponse(AbstractModel):
    """DescribeLiveStreamMonitor返回参数结构体

    """

    def __init__(self):
        r"""
        :param _LiveStreamMonitor: 直播监播任务相关信息。
        :type LiveStreamMonitor: :class:`tencentcloud.live.v20180801.models.LiveStreamMonitorInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._LiveStreamMonitor = None
        self._RequestId = None

    @property
    def LiveStreamMonitor(self):
        """直播监播任务相关信息。
        :rtype: :class:`tencentcloud.live.v20180801.models.LiveStreamMonitorInfo`
        """
        return self._LiveStreamMonitor

    @LiveStreamMonitor.setter
    def LiveStreamMonitor(self, LiveStreamMonitor):
        self._LiveStreamMonitor = LiveStreamMonitor

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("LiveStreamMonitor") is not None:
            self._LiveStreamMonitor = LiveStreamMonitorInfo()
            self._LiveStreamMonitor._deserialize(params.get("LiveStreamMonitor"))
        self._RequestId = params.get("RequestId")


class DescribeLiveStreamOnlineListRequest(AbstractModel):
    """DescribeLiveStreamOnlineList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DomainName: 推流域名。多域名用户需要填写 DomainName。
        :type DomainName: str
        :param _AppName: 推流路径，与推流和播放地址中的 AppName 保持一致，默认为 live。多路径用户需要填写 AppName。
        :type AppName: str
        :param _PageNum: 取得第几页，默认1。
        :type PageNum: int
        :param _PageSize: 每页大小，最大100。 
取值：10~100之间的任意整数。
默认值：10。
        :type PageSize: int
        :param _StreamName: 流名称，用于精确查询。
        :type StreamName: str
        """
        self._DomainName = None
        self._AppName = None
        self._PageNum = None
        self._PageSize = None
        self._StreamName = None

    @property
    def DomainName(self):
        """推流域名。多域名用户需要填写 DomainName。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def AppName(self):
        """推流路径，与推流和播放地址中的 AppName 保持一致，默认为 live。多路径用户需要填写 AppName。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def PageNum(self):
        """取得第几页，默认1。
        :rtype: int
        """
        return self._PageNum

    @PageNum.setter
    def PageNum(self, PageNum):
        self._PageNum = PageNum

    @property
    def PageSize(self):
        """每页大小，最大100。 
取值：10~100之间的任意整数。
默认值：10。
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def StreamName(self):
        """流名称，用于精确查询。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName


    def _deserialize(self, params):
        self._DomainName = params.get("DomainName")
        self._AppName = params.get("AppName")
        self._PageNum = params.get("PageNum")
        self._PageSize = params.get("PageSize")
        self._StreamName = params.get("StreamName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLiveStreamOnlineListResponse(AbstractModel):
    """DescribeLiveStreamOnlineList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalNum: 符合条件的总个数。
        :type TotalNum: int
        :param _TotalPage: 总页数。
        :type TotalPage: int
        :param _PageNum: 分页的页码。
        :type PageNum: int
        :param _PageSize: 每页显示的条数。
        :type PageSize: int
        :param _OnlineInfo: 正在推送流的信息列表。
        :type OnlineInfo: list of StreamOnlineInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalNum = None
        self._TotalPage = None
        self._PageNum = None
        self._PageSize = None
        self._OnlineInfo = None
        self._RequestId = None

    @property
    def TotalNum(self):
        """符合条件的总个数。
        :rtype: int
        """
        return self._TotalNum

    @TotalNum.setter
    def TotalNum(self, TotalNum):
        self._TotalNum = TotalNum

    @property
    def TotalPage(self):
        """总页数。
        :rtype: int
        """
        return self._TotalPage

    @TotalPage.setter
    def TotalPage(self, TotalPage):
        self._TotalPage = TotalPage

    @property
    def PageNum(self):
        """分页的页码。
        :rtype: int
        """
        return self._PageNum

    @PageNum.setter
    def PageNum(self, PageNum):
        self._PageNum = PageNum

    @property
    def PageSize(self):
        """每页显示的条数。
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def OnlineInfo(self):
        """正在推送流的信息列表。
        :rtype: list of StreamOnlineInfo
        """
        return self._OnlineInfo

    @OnlineInfo.setter
    def OnlineInfo(self, OnlineInfo):
        self._OnlineInfo = OnlineInfo

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalNum = params.get("TotalNum")
        self._TotalPage = params.get("TotalPage")
        self._PageNum = params.get("PageNum")
        self._PageSize = params.get("PageSize")
        if params.get("OnlineInfo") is not None:
            self._OnlineInfo = []
            for item in params.get("OnlineInfo"):
                obj = StreamOnlineInfo()
                obj._deserialize(item)
                self._OnlineInfo.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLiveStreamPublishedListRequest(AbstractModel):
    """DescribeLiveStreamPublishedList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DomainName: 您的推流域名。
        :type DomainName: str
        :param _EndTime: 结束时间。UTC 格式，例如：2016-06-30T19:00:00Z。不超过当前时间。注意：EndTime和StartTime相差不可超过1个月。
        :type EndTime: str
        :param _StartTime: 起始时间。 UTC 格式，例如：2016-06-29T19:00:00Z。最长支持查询2个月内数据。
        :type StartTime: str
        :param _AppName: 推流路径，与推流和播放地址中的 AppName 保持一致，默认为 live。不支持模糊匹配。
        :type AppName: str
        :param _PageNum: 取得第几页。
默认值：1。
        :type PageNum: int
        :param _PageSize: 分页大小。
最大值：100。
取值范围：10~100 之前的任意整数。
默认值：10。
        :type PageSize: int
        :param _StreamName: 流名称，支持模糊匹配。
        :type StreamName: str
        """
        self._DomainName = None
        self._EndTime = None
        self._StartTime = None
        self._AppName = None
        self._PageNum = None
        self._PageSize = None
        self._StreamName = None

    @property
    def DomainName(self):
        """您的推流域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def EndTime(self):
        """结束时间。UTC 格式，例如：2016-06-30T19:00:00Z。不超过当前时间。注意：EndTime和StartTime相差不可超过1个月。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def StartTime(self):
        """起始时间。 UTC 格式，例如：2016-06-29T19:00:00Z。最长支持查询2个月内数据。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def AppName(self):
        """推流路径，与推流和播放地址中的 AppName 保持一致，默认为 live。不支持模糊匹配。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def PageNum(self):
        """取得第几页。
默认值：1。
        :rtype: int
        """
        return self._PageNum

    @PageNum.setter
    def PageNum(self, PageNum):
        self._PageNum = PageNum

    @property
    def PageSize(self):
        """分页大小。
最大值：100。
取值范围：10~100 之前的任意整数。
默认值：10。
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def StreamName(self):
        """流名称，支持模糊匹配。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName


    def _deserialize(self, params):
        self._DomainName = params.get("DomainName")
        self._EndTime = params.get("EndTime")
        self._StartTime = params.get("StartTime")
        self._AppName = params.get("AppName")
        self._PageNum = params.get("PageNum")
        self._PageSize = params.get("PageSize")
        self._StreamName = params.get("StreamName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLiveStreamPublishedListResponse(AbstractModel):
    """DescribeLiveStreamPublishedList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _PublishInfo: 推流记录信息。
        :type PublishInfo: list of StreamName
        :param _PageNum: 分页的页码。
        :type PageNum: int
        :param _PageSize: 每页大小
        :type PageSize: int
        :param _TotalNum: 符合条件的总个数。
        :type TotalNum: int
        :param _TotalPage: 总页数。
        :type TotalPage: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._PublishInfo = None
        self._PageNum = None
        self._PageSize = None
        self._TotalNum = None
        self._TotalPage = None
        self._RequestId = None

    @property
    def PublishInfo(self):
        """推流记录信息。
        :rtype: list of StreamName
        """
        return self._PublishInfo

    @PublishInfo.setter
    def PublishInfo(self, PublishInfo):
        self._PublishInfo = PublishInfo

    @property
    def PageNum(self):
        """分页的页码。
        :rtype: int
        """
        return self._PageNum

    @PageNum.setter
    def PageNum(self, PageNum):
        self._PageNum = PageNum

    @property
    def PageSize(self):
        """每页大小
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def TotalNum(self):
        """符合条件的总个数。
        :rtype: int
        """
        return self._TotalNum

    @TotalNum.setter
    def TotalNum(self, TotalNum):
        self._TotalNum = TotalNum

    @property
    def TotalPage(self):
        """总页数。
        :rtype: int
        """
        return self._TotalPage

    @TotalPage.setter
    def TotalPage(self, TotalPage):
        self._TotalPage = TotalPage

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("PublishInfo") is not None:
            self._PublishInfo = []
            for item in params.get("PublishInfo"):
                obj = StreamName()
                obj._deserialize(item)
                self._PublishInfo.append(obj)
        self._PageNum = params.get("PageNum")
        self._PageSize = params.get("PageSize")
        self._TotalNum = params.get("TotalNum")
        self._TotalPage = params.get("TotalPage")
        self._RequestId = params.get("RequestId")


class DescribeLiveStreamPushInfoListRequest(AbstractModel):
    """DescribeLiveStreamPushInfoList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PushDomain: 推流域名。
        :type PushDomain: str
        :param _AppName: 推流路径，与推流和播放地址中的AppName保持一致，默认为live。
        :type AppName: str
        :param _PageNum: 页数，
范围[1,10000]，
默认值：1。
        :type PageNum: int
        :param _PageSize: 每页个数，
范围：[1,1000]，
默认值： 200。
        :type PageSize: int
        """
        self._PushDomain = None
        self._AppName = None
        self._PageNum = None
        self._PageSize = None

    @property
    def PushDomain(self):
        """推流域名。
        :rtype: str
        """
        return self._PushDomain

    @PushDomain.setter
    def PushDomain(self, PushDomain):
        self._PushDomain = PushDomain

    @property
    def AppName(self):
        """推流路径，与推流和播放地址中的AppName保持一致，默认为live。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def PageNum(self):
        """页数，
范围[1,10000]，
默认值：1。
        :rtype: int
        """
        return self._PageNum

    @PageNum.setter
    def PageNum(self, PageNum):
        self._PageNum = PageNum

    @property
    def PageSize(self):
        """每页个数，
范围：[1,1000]，
默认值： 200。
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        self._PushDomain = params.get("PushDomain")
        self._AppName = params.get("AppName")
        self._PageNum = params.get("PageNum")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLiveStreamPushInfoListResponse(AbstractModel):
    """DescribeLiveStreamPushInfoList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DataInfoList: 直播流的统计信息列表。
        :type DataInfoList: list of PushDataInfo
        :param _TotalNum: 所有在线流的总数量。
        :type TotalNum: int
        :param _TotalPage: 总页数。
        :type TotalPage: int
        :param _PageNum: 当前数据所在页码。
        :type PageNum: int
        :param _PageSize: 每页的在线流的个数。
        :type PageSize: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DataInfoList = None
        self._TotalNum = None
        self._TotalPage = None
        self._PageNum = None
        self._PageSize = None
        self._RequestId = None

    @property
    def DataInfoList(self):
        """直播流的统计信息列表。
        :rtype: list of PushDataInfo
        """
        return self._DataInfoList

    @DataInfoList.setter
    def DataInfoList(self, DataInfoList):
        self._DataInfoList = DataInfoList

    @property
    def TotalNum(self):
        """所有在线流的总数量。
        :rtype: int
        """
        return self._TotalNum

    @TotalNum.setter
    def TotalNum(self, TotalNum):
        self._TotalNum = TotalNum

    @property
    def TotalPage(self):
        """总页数。
        :rtype: int
        """
        return self._TotalPage

    @TotalPage.setter
    def TotalPage(self, TotalPage):
        self._TotalPage = TotalPage

    @property
    def PageNum(self):
        """当前数据所在页码。
        :rtype: int
        """
        return self._PageNum

    @PageNum.setter
    def PageNum(self, PageNum):
        self._PageNum = PageNum

    @property
    def PageSize(self):
        """每页的在线流的个数。
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DataInfoList") is not None:
            self._DataInfoList = []
            for item in params.get("DataInfoList"):
                obj = PushDataInfo()
                obj._deserialize(item)
                self._DataInfoList.append(obj)
        self._TotalNum = params.get("TotalNum")
        self._TotalPage = params.get("TotalPage")
        self._PageNum = params.get("PageNum")
        self._PageSize = params.get("PageSize")
        self._RequestId = params.get("RequestId")


class DescribeLiveStreamStateRequest(AbstractModel):
    """DescribeLiveStreamState请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AppName: 推流路径，与推流和播放地址中的AppName保持一致，默认为 live。
        :type AppName: str
        :param _DomainName: 您的推流域名。
        :type DomainName: str
        :param _StreamName: 流名称。
        :type StreamName: str
        """
        self._AppName = None
        self._DomainName = None
        self._StreamName = None

    @property
    def AppName(self):
        """推流路径，与推流和播放地址中的AppName保持一致，默认为 live。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def DomainName(self):
        """您的推流域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def StreamName(self):
        """流名称。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName


    def _deserialize(self, params):
        self._AppName = params.get("AppName")
        self._DomainName = params.get("DomainName")
        self._StreamName = params.get("StreamName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLiveStreamStateResponse(AbstractModel):
    """DescribeLiveStreamState返回参数结构体

    """

    def __init__(self):
        r"""
        :param _StreamState: 流状态，
active：活跃，
inactive：非活跃，
forbid：禁播。
        :type StreamState: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._StreamState = None
        self._RequestId = None

    @property
    def StreamState(self):
        """流状态，
active：活跃，
inactive：非活跃，
forbid：禁播。
        :rtype: str
        """
        return self._StreamState

    @StreamState.setter
    def StreamState(self, StreamState):
        self._StreamState = StreamState

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._StreamState = params.get("StreamState")
        self._RequestId = params.get("RequestId")


class DescribeLiveTimeShiftBillInfoListRequest(AbstractModel):
    """DescribeLiveTimeShiftBillInfoList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: UTC开始时间，支持最近三个月的查询，查询时间最长跨度为一天。使用 UTC 格式时间，例如：2019-01-08T10:00:00Z。注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#:~:text=I-,ISO,-%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F)。
        :type StartTime: str
        :param _EndTime: UTC结束时间，支持最近三个月的查询，查询时间最长跨度为一天。使用 UTC 格式时间，例如：2019-01-08T10:00:00Z。注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#:~:text=I-,ISO,-%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F)。
        :type EndTime: str
        :param _PushDomains: 推流域名列表，若不传递此参数，则表示查询总体数据。
        :type PushDomains: list of str
        """
        self._StartTime = None
        self._EndTime = None
        self._PushDomains = None

    @property
    def StartTime(self):
        """UTC开始时间，支持最近三个月的查询，查询时间最长跨度为一天。使用 UTC 格式时间，例如：2019-01-08T10:00:00Z。注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#:~:text=I-,ISO,-%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F)。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """UTC结束时间，支持最近三个月的查询，查询时间最长跨度为一天。使用 UTC 格式时间，例如：2019-01-08T10:00:00Z。注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#:~:text=I-,ISO,-%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F)。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def PushDomains(self):
        """推流域名列表，若不传递此参数，则表示查询总体数据。
        :rtype: list of str
        """
        return self._PushDomains

    @PushDomains.setter
    def PushDomains(self, PushDomains):
        self._PushDomains = PushDomains


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._PushDomains = params.get("PushDomains")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLiveTimeShiftBillInfoListResponse(AbstractModel):
    """DescribeLiveTimeShiftBillInfoList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DataInfoList: 时移计费明细数据。
        :type DataInfoList: list of TimeShiftBillData
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DataInfoList = None
        self._RequestId = None

    @property
    def DataInfoList(self):
        """时移计费明细数据。
        :rtype: list of TimeShiftBillData
        """
        return self._DataInfoList

    @DataInfoList.setter
    def DataInfoList(self, DataInfoList):
        self._DataInfoList = DataInfoList

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DataInfoList") is not None:
            self._DataInfoList = []
            for item in params.get("DataInfoList"):
                obj = TimeShiftBillData()
                obj._deserialize(item)
                self._DataInfoList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLiveTimeShiftRulesRequest(AbstractModel):
    """DescribeLiveTimeShiftRules请求参数结构体

    """


class DescribeLiveTimeShiftRulesResponse(AbstractModel):
    """DescribeLiveTimeShiftRules返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Rules: 规则信息列表。
        :type Rules: list of RuleInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Rules = None
        self._RequestId = None

    @property
    def Rules(self):
        """规则信息列表。
        :rtype: list of RuleInfo
        """
        return self._Rules

    @Rules.setter
    def Rules(self, Rules):
        self._Rules = Rules

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Rules") is not None:
            self._Rules = []
            for item in params.get("Rules"):
                obj = RuleInfo()
                obj._deserialize(item)
                self._Rules.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLiveTimeShiftTemplatesRequest(AbstractModel):
    """DescribeLiveTimeShiftTemplates请求参数结构体

    """


class DescribeLiveTimeShiftTemplatesResponse(AbstractModel):
    """DescribeLiveTimeShiftTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Templates: 直播时移模板信息。
        :type Templates: list of TimeShiftTemplate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Templates = None
        self._RequestId = None

    @property
    def Templates(self):
        """直播时移模板信息。
        :rtype: list of TimeShiftTemplate
        """
        return self._Templates

    @Templates.setter
    def Templates(self, Templates):
        self._Templates = Templates

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Templates") is not None:
            self._Templates = []
            for item in params.get("Templates"):
                obj = TimeShiftTemplate()
                obj._deserialize(item)
                self._Templates.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLiveTimeShiftWriteSizeInfoListRequest(AbstractModel):
    """DescribeLiveTimeShiftWriteSizeInfoList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 起始时间点，
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
支持最近六个月的查询，查询开始和结束时间跨度不支持超过31天。
        :type StartTime: str
        :param _EndTime: 结束时间点，
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
支持最近六个月的查询，查询开始和结束时间跨度不支持超过31天。
        :type EndTime: str
        :param _DomainNames: 域名。
        :type DomainNames: list of str
        :param _Dimensions: 维度
Area地区、Domain 域名、StorageDays 时移天数
        :type Dimensions: list of str
        :param _StorageDays: 时移天数。
        :type StorageDays: list of int
        :param _Granularity: 时间跨度（分钟）
默认5，可选 5、60或者1440。
        :type Granularity: int
        :param _MainlandOrOversea: 区域
可选Mainland、Oversea。
        :type MainlandOrOversea: str
        """
        self._StartTime = None
        self._EndTime = None
        self._DomainNames = None
        self._Dimensions = None
        self._StorageDays = None
        self._Granularity = None
        self._MainlandOrOversea = None

    @property
    def StartTime(self):
        """起始时间点，
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
支持最近六个月的查询，查询开始和结束时间跨度不支持超过31天。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束时间点，
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
支持最近六个月的查询，查询开始和结束时间跨度不支持超过31天。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def DomainNames(self):
        """域名。
        :rtype: list of str
        """
        return self._DomainNames

    @DomainNames.setter
    def DomainNames(self, DomainNames):
        self._DomainNames = DomainNames

    @property
    def Dimensions(self):
        """维度
Area地区、Domain 域名、StorageDays 时移天数
        :rtype: list of str
        """
        return self._Dimensions

    @Dimensions.setter
    def Dimensions(self, Dimensions):
        self._Dimensions = Dimensions

    @property
    def StorageDays(self):
        """时移天数。
        :rtype: list of int
        """
        return self._StorageDays

    @StorageDays.setter
    def StorageDays(self, StorageDays):
        self._StorageDays = StorageDays

    @property
    def Granularity(self):
        """时间跨度（分钟）
默认5，可选 5、60或者1440。
        :rtype: int
        """
        return self._Granularity

    @Granularity.setter
    def Granularity(self, Granularity):
        self._Granularity = Granularity

    @property
    def MainlandOrOversea(self):
        """区域
可选Mainland、Oversea。
        :rtype: str
        """
        return self._MainlandOrOversea

    @MainlandOrOversea.setter
    def MainlandOrOversea(self, MainlandOrOversea):
        self._MainlandOrOversea = MainlandOrOversea


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._DomainNames = params.get("DomainNames")
        self._Dimensions = params.get("Dimensions")
        self._StorageDays = params.get("StorageDays")
        self._Granularity = params.get("Granularity")
        self._MainlandOrOversea = params.get("MainlandOrOversea")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLiveTimeShiftWriteSizeInfoListResponse(AbstractModel):
    """DescribeLiveTimeShiftWriteSizeInfoList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DataInfoList: 直播时移写入量数据明细。
        :type DataInfoList: list of TimeShiftWriteSizeData
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DataInfoList = None
        self._RequestId = None

    @property
    def DataInfoList(self):
        """直播时移写入量数据明细。
        :rtype: list of TimeShiftWriteSizeData
        """
        return self._DataInfoList

    @DataInfoList.setter
    def DataInfoList(self, DataInfoList):
        self._DataInfoList = DataInfoList

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DataInfoList") is not None:
            self._DataInfoList = []
            for item in params.get("DataInfoList"):
                obj = TimeShiftWriteSizeData()
                obj._deserialize(item)
                self._DataInfoList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLiveTranscodeDetailInfoRequest(AbstractModel):
    """DescribeLiveTranscodeDetailInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PushDomain: 推流域名。
        :type PushDomain: str
        :param _StreamName: 流名称。
        :type StreamName: str
        :param _DayTime: 查询时间，北京时间，
格式：yyyymmdd。
注意：支持查询近1个月内某天的详细数据，截止到昨天。
        :type DayTime: str
        :param _PageNum: 页数，默认1，
不超过100页。
        :type PageNum: int
        :param _PageSize: 每页个数，默认20，
范围：[10,1000]。
        :type PageSize: int
        :param _StartDayTime: 起始天时间，北京时间，
格式：yyyymmdd。
注意：支持查询近1个月内的详细数据。
        :type StartDayTime: str
        :param _EndDayTime: 结束天时间，北京时间，
格式：yyyymmdd。
注意：支持查询近1个月内的详细数据，截止到昨天，注意DayTime 与（StartDayTime，EndDayTime）必须要传一个，如果都传，会以DayTime为准 。
        :type EndDayTime: str
        """
        self._PushDomain = None
        self._StreamName = None
        self._DayTime = None
        self._PageNum = None
        self._PageSize = None
        self._StartDayTime = None
        self._EndDayTime = None

    @property
    def PushDomain(self):
        """推流域名。
        :rtype: str
        """
        return self._PushDomain

    @PushDomain.setter
    def PushDomain(self, PushDomain):
        self._PushDomain = PushDomain

    @property
    def StreamName(self):
        """流名称。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName

    @property
    def DayTime(self):
        """查询时间，北京时间，
格式：yyyymmdd。
注意：支持查询近1个月内某天的详细数据，截止到昨天。
        :rtype: str
        """
        return self._DayTime

    @DayTime.setter
    def DayTime(self, DayTime):
        self._DayTime = DayTime

    @property
    def PageNum(self):
        """页数，默认1，
不超过100页。
        :rtype: int
        """
        return self._PageNum

    @PageNum.setter
    def PageNum(self, PageNum):
        self._PageNum = PageNum

    @property
    def PageSize(self):
        """每页个数，默认20，
范围：[10,1000]。
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def StartDayTime(self):
        """起始天时间，北京时间，
格式：yyyymmdd。
注意：支持查询近1个月内的详细数据。
        :rtype: str
        """
        return self._StartDayTime

    @StartDayTime.setter
    def StartDayTime(self, StartDayTime):
        self._StartDayTime = StartDayTime

    @property
    def EndDayTime(self):
        """结束天时间，北京时间，
格式：yyyymmdd。
注意：支持查询近1个月内的详细数据，截止到昨天，注意DayTime 与（StartDayTime，EndDayTime）必须要传一个，如果都传，会以DayTime为准 。
        :rtype: str
        """
        return self._EndDayTime

    @EndDayTime.setter
    def EndDayTime(self, EndDayTime):
        self._EndDayTime = EndDayTime


    def _deserialize(self, params):
        self._PushDomain = params.get("PushDomain")
        self._StreamName = params.get("StreamName")
        self._DayTime = params.get("DayTime")
        self._PageNum = params.get("PageNum")
        self._PageSize = params.get("PageSize")
        self._StartDayTime = params.get("StartDayTime")
        self._EndDayTime = params.get("EndDayTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLiveTranscodeDetailInfoResponse(AbstractModel):
    """DescribeLiveTranscodeDetailInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DataInfoList: 统计数据列表。
        :type DataInfoList: list of TranscodeDetailInfo
        :param _PageNum: 页码。
        :type PageNum: int
        :param _PageSize: 每页个数。
        :type PageSize: int
        :param _TotalNum: 总个数。
        :type TotalNum: int
        :param _TotalPage: 总页数。
        :type TotalPage: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DataInfoList = None
        self._PageNum = None
        self._PageSize = None
        self._TotalNum = None
        self._TotalPage = None
        self._RequestId = None

    @property
    def DataInfoList(self):
        """统计数据列表。
        :rtype: list of TranscodeDetailInfo
        """
        return self._DataInfoList

    @DataInfoList.setter
    def DataInfoList(self, DataInfoList):
        self._DataInfoList = DataInfoList

    @property
    def PageNum(self):
        """页码。
        :rtype: int
        """
        return self._PageNum

    @PageNum.setter
    def PageNum(self, PageNum):
        self._PageNum = PageNum

    @property
    def PageSize(self):
        """每页个数。
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def TotalNum(self):
        """总个数。
        :rtype: int
        """
        return self._TotalNum

    @TotalNum.setter
    def TotalNum(self, TotalNum):
        self._TotalNum = TotalNum

    @property
    def TotalPage(self):
        """总页数。
        :rtype: int
        """
        return self._TotalPage

    @TotalPage.setter
    def TotalPage(self, TotalPage):
        self._TotalPage = TotalPage

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DataInfoList") is not None:
            self._DataInfoList = []
            for item in params.get("DataInfoList"):
                obj = TranscodeDetailInfo()
                obj._deserialize(item)
                self._DataInfoList.append(obj)
        self._PageNum = params.get("PageNum")
        self._PageSize = params.get("PageSize")
        self._TotalNum = params.get("TotalNum")
        self._TotalPage = params.get("TotalPage")
        self._RequestId = params.get("RequestId")


class DescribeLiveTranscodeRulesRequest(AbstractModel):
    """DescribeLiveTranscodeRules请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TemplateIds: 要筛选的模板ID数组。
        :type TemplateIds: list of int
        :param _DomainNames: 要筛选的域名数组。
        :type DomainNames: list of str
        """
        self._TemplateIds = None
        self._DomainNames = None

    @property
    def TemplateIds(self):
        """要筛选的模板ID数组。
        :rtype: list of int
        """
        return self._TemplateIds

    @TemplateIds.setter
    def TemplateIds(self, TemplateIds):
        self._TemplateIds = TemplateIds

    @property
    def DomainNames(self):
        """要筛选的域名数组。
        :rtype: list of str
        """
        return self._DomainNames

    @DomainNames.setter
    def DomainNames(self, DomainNames):
        self._DomainNames = DomainNames


    def _deserialize(self, params):
        self._TemplateIds = params.get("TemplateIds")
        self._DomainNames = params.get("DomainNames")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLiveTranscodeRulesResponse(AbstractModel):
    """DescribeLiveTranscodeRules返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Rules: 转码规则列表。
        :type Rules: list of RuleInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Rules = None
        self._RequestId = None

    @property
    def Rules(self):
        """转码规则列表。
        :rtype: list of RuleInfo
        """
        return self._Rules

    @Rules.setter
    def Rules(self, Rules):
        self._Rules = Rules

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Rules") is not None:
            self._Rules = []
            for item in params.get("Rules"):
                obj = RuleInfo()
                obj._deserialize(item)
                self._Rules.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLiveTranscodeTemplateRequest(AbstractModel):
    """DescribeLiveTranscodeTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TemplateId: 模板 ID。
注意：在创建转码模板接口 [CreateLiveTranscodeTemplate](/document/product/267/32646) 调用的返回值中获取模板 ID。
        :type TemplateId: int
        """
        self._TemplateId = None

    @property
    def TemplateId(self):
        """模板 ID。
注意：在创建转码模板接口 [CreateLiveTranscodeTemplate](/document/product/267/32646) 调用的返回值中获取模板 ID。
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLiveTranscodeTemplateResponse(AbstractModel):
    """DescribeLiveTranscodeTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Template: 模板信息。
        :type Template: :class:`tencentcloud.live.v20180801.models.TemplateInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Template = None
        self._RequestId = None

    @property
    def Template(self):
        """模板信息。
        :rtype: :class:`tencentcloud.live.v20180801.models.TemplateInfo`
        """
        return self._Template

    @Template.setter
    def Template(self, Template):
        self._Template = Template

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Template") is not None:
            self._Template = TemplateInfo()
            self._Template._deserialize(params.get("Template"))
        self._RequestId = params.get("RequestId")


class DescribeLiveTranscodeTemplatesRequest(AbstractModel):
    """DescribeLiveTranscodeTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TemplateType: 转码模板类型，默认0。
0：普通转码模板。
1：自适应码率转码模板。
        :type TemplateType: int
        """
        self._TemplateType = None

    @property
    def TemplateType(self):
        """转码模板类型，默认0。
0：普通转码模板。
1：自适应码率转码模板。
        :rtype: int
        """
        return self._TemplateType

    @TemplateType.setter
    def TemplateType(self, TemplateType):
        self._TemplateType = TemplateType


    def _deserialize(self, params):
        self._TemplateType = params.get("TemplateType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLiveTranscodeTemplatesResponse(AbstractModel):
    """DescribeLiveTranscodeTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Templates: 转码模板列表。
        :type Templates: list of TemplateInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Templates = None
        self._RequestId = None

    @property
    def Templates(self):
        """转码模板列表。
        :rtype: list of TemplateInfo
        """
        return self._Templates

    @Templates.setter
    def Templates(self, Templates):
        self._Templates = Templates

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Templates") is not None:
            self._Templates = []
            for item in params.get("Templates"):
                obj = TemplateInfo()
                obj._deserialize(item)
                self._Templates.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLiveTranscodeTotalInfoRequest(AbstractModel):
    """DescribeLiveTranscodeTotalInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 开始时间，支持最近三个月的数据查询，起始时间和结束时间跨度不能超过三个月。接口查询支持两种时间格式：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#:~:text=I-,ISO,-%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F)
2）YYYY-MM-DD hh:mm:ss：使用此格式时，默认代表北京时间。
        :type StartTime: str
        :param _EndTime: 结束时间，支持最近三个月的数据查询，起始时间和结束时间跨度不能超过三个月。接口查询支持两种时间格式：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#:~:text=I-,ISO,-%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F)
2）YYYY-MM-DD hh:mm:ss：使用此格式时，默认代表北京时间。
        :type EndTime: str
        :param _PushDomains: 推流域名列表，若不填，表示查询所有域名总体数据。
指定域名时返回1小时粒度数据。
        :type PushDomains: list of str
        :param _MainlandOrOversea: 可选值：
Mainland：查询中国大陆（境内）数据，
Oversea：则查询国际/港澳台（境外）数据，
默认：查询全球地区（境内+境外）的数据。
        :type MainlandOrOversea: str
        """
        self._StartTime = None
        self._EndTime = None
        self._PushDomains = None
        self._MainlandOrOversea = None

    @property
    def StartTime(self):
        """开始时间，支持最近三个月的数据查询，起始时间和结束时间跨度不能超过三个月。接口查询支持两种时间格式：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#:~:text=I-,ISO,-%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F)
2）YYYY-MM-DD hh:mm:ss：使用此格式时，默认代表北京时间。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束时间，支持最近三个月的数据查询，起始时间和结束时间跨度不能超过三个月。接口查询支持两种时间格式：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#:~:text=I-,ISO,-%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F)
2）YYYY-MM-DD hh:mm:ss：使用此格式时，默认代表北京时间。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def PushDomains(self):
        """推流域名列表，若不填，表示查询所有域名总体数据。
指定域名时返回1小时粒度数据。
        :rtype: list of str
        """
        return self._PushDomains

    @PushDomains.setter
    def PushDomains(self, PushDomains):
        self._PushDomains = PushDomains

    @property
    def MainlandOrOversea(self):
        """可选值：
Mainland：查询中国大陆（境内）数据，
Oversea：则查询国际/港澳台（境外）数据，
默认：查询全球地区（境内+境外）的数据。
        :rtype: str
        """
        return self._MainlandOrOversea

    @MainlandOrOversea.setter
    def MainlandOrOversea(self, MainlandOrOversea):
        self._MainlandOrOversea = MainlandOrOversea


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._PushDomains = params.get("PushDomains")
        self._MainlandOrOversea = params.get("MainlandOrOversea")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLiveTranscodeTotalInfoResponse(AbstractModel):
    """DescribeLiveTranscodeTotalInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DataInfoList: 统计数据列表。
        :type DataInfoList: list of TranscodeTotalInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DataInfoList = None
        self._RequestId = None

    @property
    def DataInfoList(self):
        """统计数据列表。
        :rtype: list of TranscodeTotalInfo
        """
        return self._DataInfoList

    @DataInfoList.setter
    def DataInfoList(self, DataInfoList):
        self._DataInfoList = DataInfoList

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DataInfoList") is not None:
            self._DataInfoList = []
            for item in params.get("DataInfoList"):
                obj = TranscodeTotalInfo()
                obj._deserialize(item)
                self._DataInfoList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLiveWatermarkRequest(AbstractModel):
    """DescribeLiveWatermark请求参数结构体

    """

    def __init__(self):
        r"""
        :param _WatermarkId: DescribeLiveWatermarks接口返回的水印 ID。
        :type WatermarkId: int
        """
        self._WatermarkId = None

    @property
    def WatermarkId(self):
        """DescribeLiveWatermarks接口返回的水印 ID。
        :rtype: int
        """
        return self._WatermarkId

    @WatermarkId.setter
    def WatermarkId(self, WatermarkId):
        self._WatermarkId = WatermarkId


    def _deserialize(self, params):
        self._WatermarkId = params.get("WatermarkId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLiveWatermarkResponse(AbstractModel):
    """DescribeLiveWatermark返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Watermark: 水印信息。
        :type Watermark: :class:`tencentcloud.live.v20180801.models.WatermarkInfo`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Watermark = None
        self._RequestId = None

    @property
    def Watermark(self):
        """水印信息。
        :rtype: :class:`tencentcloud.live.v20180801.models.WatermarkInfo`
        """
        return self._Watermark

    @Watermark.setter
    def Watermark(self, Watermark):
        self._Watermark = Watermark

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Watermark") is not None:
            self._Watermark = WatermarkInfo()
            self._Watermark._deserialize(params.get("Watermark"))
        self._RequestId = params.get("RequestId")


class DescribeLiveWatermarkRulesRequest(AbstractModel):
    """DescribeLiveWatermarkRules请求参数结构体

    """


class DescribeLiveWatermarkRulesResponse(AbstractModel):
    """DescribeLiveWatermarkRules返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Rules: 水印规则列表。
        :type Rules: list of RuleInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Rules = None
        self._RequestId = None

    @property
    def Rules(self):
        """水印规则列表。
        :rtype: list of RuleInfo
        """
        return self._Rules

    @Rules.setter
    def Rules(self, Rules):
        self._Rules = Rules

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Rules") is not None:
            self._Rules = []
            for item in params.get("Rules"):
                obj = RuleInfo()
                obj._deserialize(item)
                self._Rules.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLiveWatermarksRequest(AbstractModel):
    """DescribeLiveWatermarks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 水印名称
        :type Name: str
        :param _PageNo: 分页的索引参数，从1开始
        :type PageNo: int
        :param _PageSize: 分页的大小参数，默认值500
        :type PageSize: int
        """
        self._Name = None
        self._PageNo = None
        self._PageSize = None

    @property
    def Name(self):
        """水印名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def PageNo(self):
        """分页的索引参数，从1开始
        :rtype: int
        """
        return self._PageNo

    @PageNo.setter
    def PageNo(self, PageNo):
        self._PageNo = PageNo

    @property
    def PageSize(self):
        """分页的大小参数，默认值500
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._PageNo = params.get("PageNo")
        self._PageSize = params.get("PageSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLiveWatermarksResponse(AbstractModel):
    """DescribeLiveWatermarks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalNum: 水印总个数。
        :type TotalNum: int
        :param _WatermarkList: 水印信息列表。
        :type WatermarkList: list of WatermarkInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalNum = None
        self._WatermarkList = None
        self._RequestId = None

    @property
    def TotalNum(self):
        """水印总个数。
        :rtype: int
        """
        return self._TotalNum

    @TotalNum.setter
    def TotalNum(self, TotalNum):
        self._TotalNum = TotalNum

    @property
    def WatermarkList(self):
        """水印信息列表。
        :rtype: list of WatermarkInfo
        """
        return self._WatermarkList

    @WatermarkList.setter
    def WatermarkList(self, WatermarkList):
        self._WatermarkList = WatermarkList

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalNum = params.get("TotalNum")
        if params.get("WatermarkList") is not None:
            self._WatermarkList = []
            for item in params.get("WatermarkList"):
                obj = WatermarkInfo()
                obj._deserialize(item)
                self._WatermarkList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLiveXP2PDetailInfoListRequest(AbstractModel):
    """DescribeLiveXP2PDetailInfoList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _QueryTime: utc分钟粒度查询时间，查询某一分钟的用量数据，格式为：yyyy-mm-ddTHH:MM:00Z，参考https://cloud.tencent.com/document/product/266/11732#I，
例如：北京时间2019-01-08 10:00:00，对应utc时间为：2019-01-08T10:00:00+08:00。

支持最近六个月的查询。
        :type QueryTime: str
        :param _Type: 类型数组，分直播live和点播vod，不传默认查全部。
        :type Type: list of str
        :param _StreamNames: 查询流数组，不传默认查所有流。
        :type StreamNames: list of str
        :param _Dimension: 查询维度，不传该参数则默认查询流维度的数据，传递该参数则只查对应维度的数据，和返回值的字段相关，目前支持AppId维度查询。
        :type Dimension: list of str
        """
        self._QueryTime = None
        self._Type = None
        self._StreamNames = None
        self._Dimension = None

    @property
    def QueryTime(self):
        """utc分钟粒度查询时间，查询某一分钟的用量数据，格式为：yyyy-mm-ddTHH:MM:00Z，参考https://cloud.tencent.com/document/product/266/11732#I，
例如：北京时间2019-01-08 10:00:00，对应utc时间为：2019-01-08T10:00:00+08:00。

支持最近六个月的查询。
        :rtype: str
        """
        return self._QueryTime

    @QueryTime.setter
    def QueryTime(self, QueryTime):
        self._QueryTime = QueryTime

    @property
    def Type(self):
        """类型数组，分直播live和点播vod，不传默认查全部。
        :rtype: list of str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def StreamNames(self):
        """查询流数组，不传默认查所有流。
        :rtype: list of str
        """
        return self._StreamNames

    @StreamNames.setter
    def StreamNames(self, StreamNames):
        self._StreamNames = StreamNames

    @property
    def Dimension(self):
        """查询维度，不传该参数则默认查询流维度的数据，传递该参数则只查对应维度的数据，和返回值的字段相关，目前支持AppId维度查询。
        :rtype: list of str
        """
        return self._Dimension

    @Dimension.setter
    def Dimension(self, Dimension):
        self._Dimension = Dimension


    def _deserialize(self, params):
        self._QueryTime = params.get("QueryTime")
        self._Type = params.get("Type")
        self._StreamNames = params.get("StreamNames")
        self._Dimension = params.get("Dimension")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLiveXP2PDetailInfoListResponse(AbstractModel):
    """DescribeLiveXP2PDetailInfoList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DataInfoList: P2P流统计信息。
        :type DataInfoList: list of XP2PDetailInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DataInfoList = None
        self._RequestId = None

    @property
    def DataInfoList(self):
        """P2P流统计信息。
        :rtype: list of XP2PDetailInfo
        """
        return self._DataInfoList

    @DataInfoList.setter
    def DataInfoList(self, DataInfoList):
        self._DataInfoList = DataInfoList

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DataInfoList") is not None:
            self._DataInfoList = []
            for item in params.get("DataInfoList"):
                obj = XP2PDetailInfo()
                obj._deserialize(item)
                self._DataInfoList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLogDownloadListRequest(AbstractModel):
    """DescribeLogDownloadList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 开始时间，北京时间。
格式：yyyy-mm-dd HH:MM:SS。
注：此字段为北京时间（UTC+8时区）。
        :type StartTime: str
        :param _EndTime: 结束时间，北京时间。
格式：yyyy-mm-dd HH:MM:SS。
注意：结束时间 - 开始时间 <=7天。
注：此字段为北京时间（UTC+8时区）。
        :type EndTime: str
        :param _PlayDomains: 域名列表。
        :type PlayDomains: list of str
        :param _IsFastLive: 快直播还是标准直播，0：标准直播，1：快直播。默认为0。
        :type IsFastLive: int
        """
        self._StartTime = None
        self._EndTime = None
        self._PlayDomains = None
        self._IsFastLive = None

    @property
    def StartTime(self):
        """开始时间，北京时间。
格式：yyyy-mm-dd HH:MM:SS。
注：此字段为北京时间（UTC+8时区）。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束时间，北京时间。
格式：yyyy-mm-dd HH:MM:SS。
注意：结束时间 - 开始时间 <=7天。
注：此字段为北京时间（UTC+8时区）。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def PlayDomains(self):
        """域名列表。
        :rtype: list of str
        """
        return self._PlayDomains

    @PlayDomains.setter
    def PlayDomains(self, PlayDomains):
        self._PlayDomains = PlayDomains

    @property
    def IsFastLive(self):
        """快直播还是标准直播，0：标准直播，1：快直播。默认为0。
        :rtype: int
        """
        return self._IsFastLive

    @IsFastLive.setter
    def IsFastLive(self, IsFastLive):
        self._IsFastLive = IsFastLive


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._PlayDomains = params.get("PlayDomains")
        self._IsFastLive = params.get("IsFastLive")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLogDownloadListResponse(AbstractModel):
    """DescribeLogDownloadList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _LogInfoList: 日志信息列表。
        :type LogInfoList: list of LogInfo
        :param _TotalNum: 总条数。
        :type TotalNum: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._LogInfoList = None
        self._TotalNum = None
        self._RequestId = None

    @property
    def LogInfoList(self):
        """日志信息列表。
        :rtype: list of LogInfo
        """
        return self._LogInfoList

    @LogInfoList.setter
    def LogInfoList(self, LogInfoList):
        self._LogInfoList = LogInfoList

    @property
    def TotalNum(self):
        """总条数。
        :rtype: int
        """
        return self._TotalNum

    @TotalNum.setter
    def TotalNum(self, TotalNum):
        self._TotalNum = TotalNum

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("LogInfoList") is not None:
            self._LogInfoList = []
            for item in params.get("LogInfoList"):
                obj = LogInfo()
                obj._deserialize(item)
                self._LogInfoList.append(obj)
        self._TotalNum = params.get("TotalNum")
        self._RequestId = params.get("RequestId")


class DescribeMonitorReportRequest(AbstractModel):
    """DescribeMonitorReport请求参数结构体

    """

    def __init__(self):
        r"""
        :param _MonitorId: 监播任务ID。
        :type MonitorId: str
        """
        self._MonitorId = None

    @property
    def MonitorId(self):
        """监播任务ID。
        :rtype: str
        """
        return self._MonitorId

    @MonitorId.setter
    def MonitorId(self, MonitorId):
        self._MonitorId = MonitorId


    def _deserialize(self, params):
        self._MonitorId = params.get("MonitorId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMonitorReportResponse(AbstractModel):
    """DescribeMonitorReport返回参数结构体

    """

    def __init__(self):
        r"""
        :param _MPSResult: 媒体处理结果信息。
        :type MPSResult: :class:`tencentcloud.live.v20180801.models.MPSResult`
        :param _DiagnoseResult: 媒体诊断结果信息。
        :type DiagnoseResult: :class:`tencentcloud.live.v20180801.models.DiagnoseResult`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._MPSResult = None
        self._DiagnoseResult = None
        self._RequestId = None

    @property
    def MPSResult(self):
        """媒体处理结果信息。
        :rtype: :class:`tencentcloud.live.v20180801.models.MPSResult`
        """
        return self._MPSResult

    @MPSResult.setter
    def MPSResult(self, MPSResult):
        self._MPSResult = MPSResult

    @property
    def DiagnoseResult(self):
        """媒体诊断结果信息。
        :rtype: :class:`tencentcloud.live.v20180801.models.DiagnoseResult`
        """
        return self._DiagnoseResult

    @DiagnoseResult.setter
    def DiagnoseResult(self, DiagnoseResult):
        self._DiagnoseResult = DiagnoseResult

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("MPSResult") is not None:
            self._MPSResult = MPSResult()
            self._MPSResult._deserialize(params.get("MPSResult"))
        if params.get("DiagnoseResult") is not None:
            self._DiagnoseResult = DiagnoseResult()
            self._DiagnoseResult._deserialize(params.get("DiagnoseResult"))
        self._RequestId = params.get("RequestId")


class DescribePlayErrorCodeDetailInfoListRequest(AbstractModel):
    """DescribePlayErrorCodeDetailInfoList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 起始时间，
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#:~:text=I-,ISO,-%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F)。
        :type StartTime: str
        :param _EndTime: 结束时间，
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#:~:text=I-,ISO,-%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F)。
注：EndTime 和 StartTime 只支持最近1天的数据查询。
        :type EndTime: str
        :param _Granularity: 查询粒度：
1-1分钟粒度。
        :type Granularity: int
        :param _StatType: 是，可选值包括”4xx”,”5xx”，支持”4xx,5xx”等这种混合模式。
        :type StatType: str
        :param _PlayDomains: 播放域名列表。
        :type PlayDomains: list of str
        :param _MainlandOrOversea: 地域，可选值：Mainland，Oversea，China，Foreign，Global（默认值）；如果为空，查询总的数据；如果为“Mainland”，查询中国大陆的数据；如果为“Oversea”，则查询中国大陆以外的数据；如果为China，查询中国的数据（包括港澳台）；如果为Foreign，查询国外的数据（不包括港澳台）。
        :type MainlandOrOversea: str
        """
        self._StartTime = None
        self._EndTime = None
        self._Granularity = None
        self._StatType = None
        self._PlayDomains = None
        self._MainlandOrOversea = None

    @property
    def StartTime(self):
        """起始时间，
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#:~:text=I-,ISO,-%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F)。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束时间，
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#:~:text=I-,ISO,-%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F)。
注：EndTime 和 StartTime 只支持最近1天的数据查询。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Granularity(self):
        """查询粒度：
1-1分钟粒度。
        :rtype: int
        """
        return self._Granularity

    @Granularity.setter
    def Granularity(self, Granularity):
        self._Granularity = Granularity

    @property
    def StatType(self):
        """是，可选值包括”4xx”,”5xx”，支持”4xx,5xx”等这种混合模式。
        :rtype: str
        """
        return self._StatType

    @StatType.setter
    def StatType(self, StatType):
        self._StatType = StatType

    @property
    def PlayDomains(self):
        """播放域名列表。
        :rtype: list of str
        """
        return self._PlayDomains

    @PlayDomains.setter
    def PlayDomains(self, PlayDomains):
        self._PlayDomains = PlayDomains

    @property
    def MainlandOrOversea(self):
        """地域，可选值：Mainland，Oversea，China，Foreign，Global（默认值）；如果为空，查询总的数据；如果为“Mainland”，查询中国大陆的数据；如果为“Oversea”，则查询中国大陆以外的数据；如果为China，查询中国的数据（包括港澳台）；如果为Foreign，查询国外的数据（不包括港澳台）。
        :rtype: str
        """
        return self._MainlandOrOversea

    @MainlandOrOversea.setter
    def MainlandOrOversea(self, MainlandOrOversea):
        self._MainlandOrOversea = MainlandOrOversea


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Granularity = params.get("Granularity")
        self._StatType = params.get("StatType")
        self._PlayDomains = params.get("PlayDomains")
        self._MainlandOrOversea = params.get("MainlandOrOversea")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePlayErrorCodeDetailInfoListResponse(AbstractModel):
    """DescribePlayErrorCodeDetailInfoList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _HttpCodeList: 统计信息列表。
        :type HttpCodeList: list of HttpCodeInfo
        :param _StatType: 统计类型。
        :type StatType: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._HttpCodeList = None
        self._StatType = None
        self._RequestId = None

    @property
    def HttpCodeList(self):
        """统计信息列表。
        :rtype: list of HttpCodeInfo
        """
        return self._HttpCodeList

    @HttpCodeList.setter
    def HttpCodeList(self, HttpCodeList):
        self._HttpCodeList = HttpCodeList

    @property
    def StatType(self):
        """统计类型。
        :rtype: str
        """
        return self._StatType

    @StatType.setter
    def StatType(self, StatType):
        self._StatType = StatType

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("HttpCodeList") is not None:
            self._HttpCodeList = []
            for item in params.get("HttpCodeList"):
                obj = HttpCodeInfo()
                obj._deserialize(item)
                self._HttpCodeList.append(obj)
        self._StatType = params.get("StatType")
        self._RequestId = params.get("RequestId")


class DescribePlayErrorCodeSumInfoListRequest(AbstractModel):
    """DescribePlayErrorCodeSumInfoList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 起始时间点，北京时间。
格式：yyyy-mm-dd HH:MM:SS。
        :type StartTime: str
        :param _EndTime: 结束时间点，北京时间。
格式：yyyy-mm-dd HH:MM:SS。
注：EndTime 和 StartTime 只支持最近1天的数据查询。
        :type EndTime: str
        :param _PlayDomains: 播放域名列表，不填表示总体数据。
        :type PlayDomains: list of str
        :param _PageNum: 页数，范围[1,1000]，默认值是1。
        :type PageNum: int
        :param _PageSize: 每页个数，范围：[1,1000]，默认值是20。
        :type PageSize: int
        :param _MainlandOrOversea: 地域，可选值：Mainland，Oversea，China，Foreign，Global（默认值）；如果为空，查询总的数据；如果为“Mainland”，查询中国大陆的数据；如果为“Oversea”，则查询中国大陆以外的数据；如果为China，查询中国的数据（包括港澳台）；如果为Foreign，查询国外的数据（不包括港澳台）。
        :type MainlandOrOversea: str
        :param _GroupType: 分组参数，可选值：CountryProIsp（默认值），Country（国家），默认是按照国家+省份+运营商来进行分组；目前国外的省份和运营商暂时无法识别。
        :type GroupType: str
        :param _OutLanguage: 输出字段使用的语言，可选值：Chinese（默认值），English，目前国家，省份和运营商支持多语言。
        :type OutLanguage: str
        """
        self._StartTime = None
        self._EndTime = None
        self._PlayDomains = None
        self._PageNum = None
        self._PageSize = None
        self._MainlandOrOversea = None
        self._GroupType = None
        self._OutLanguage = None

    @property
    def StartTime(self):
        """起始时间点，北京时间。
格式：yyyy-mm-dd HH:MM:SS。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束时间点，北京时间。
格式：yyyy-mm-dd HH:MM:SS。
注：EndTime 和 StartTime 只支持最近1天的数据查询。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def PlayDomains(self):
        """播放域名列表，不填表示总体数据。
        :rtype: list of str
        """
        return self._PlayDomains

    @PlayDomains.setter
    def PlayDomains(self, PlayDomains):
        self._PlayDomains = PlayDomains

    @property
    def PageNum(self):
        """页数，范围[1,1000]，默认值是1。
        :rtype: int
        """
        return self._PageNum

    @PageNum.setter
    def PageNum(self, PageNum):
        self._PageNum = PageNum

    @property
    def PageSize(self):
        """每页个数，范围：[1,1000]，默认值是20。
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def MainlandOrOversea(self):
        """地域，可选值：Mainland，Oversea，China，Foreign，Global（默认值）；如果为空，查询总的数据；如果为“Mainland”，查询中国大陆的数据；如果为“Oversea”，则查询中国大陆以外的数据；如果为China，查询中国的数据（包括港澳台）；如果为Foreign，查询国外的数据（不包括港澳台）。
        :rtype: str
        """
        return self._MainlandOrOversea

    @MainlandOrOversea.setter
    def MainlandOrOversea(self, MainlandOrOversea):
        self._MainlandOrOversea = MainlandOrOversea

    @property
    def GroupType(self):
        """分组参数，可选值：CountryProIsp（默认值），Country（国家），默认是按照国家+省份+运营商来进行分组；目前国外的省份和运营商暂时无法识别。
        :rtype: str
        """
        return self._GroupType

    @GroupType.setter
    def GroupType(self, GroupType):
        self._GroupType = GroupType

    @property
    def OutLanguage(self):
        """输出字段使用的语言，可选值：Chinese（默认值），English，目前国家，省份和运营商支持多语言。
        :rtype: str
        """
        return self._OutLanguage

    @OutLanguage.setter
    def OutLanguage(self, OutLanguage):
        self._OutLanguage = OutLanguage


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._PlayDomains = params.get("PlayDomains")
        self._PageNum = params.get("PageNum")
        self._PageSize = params.get("PageSize")
        self._MainlandOrOversea = params.get("MainlandOrOversea")
        self._GroupType = params.get("GroupType")
        self._OutLanguage = params.get("OutLanguage")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePlayErrorCodeSumInfoListResponse(AbstractModel):
    """DescribePlayErrorCodeSumInfoList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ProIspInfoList: 分省份分运营商错误码为2或3或4或5开头的状态码数据信息。
        :type ProIspInfoList: list of ProIspPlayCodeDataInfo
        :param _TotalCodeAll: 所有状态码的加和的次数。
        :type TotalCodeAll: int
        :param _TotalCode4xx: 状态码为4开头的总次数。
        :type TotalCode4xx: int
        :param _TotalCode5xx: 状态码为5开头的总次数。
        :type TotalCode5xx: int
        :param _TotalCodeList: 各状态码的总次数。
        :type TotalCodeList: list of PlayCodeTotalInfo
        :param _PageNum: 页号。
        :type PageNum: int
        :param _PageSize: 每页大小。
        :type PageSize: int
        :param _TotalPage: 总页数。
        :type TotalPage: int
        :param _TotalNum: 总记录数。
        :type TotalNum: int
        :param _TotalCode2xx: 状态码为2开头的总次数。
        :type TotalCode2xx: int
        :param _TotalCode3xx: 状态码为3开头的总次数。
        :type TotalCode3xx: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ProIspInfoList = None
        self._TotalCodeAll = None
        self._TotalCode4xx = None
        self._TotalCode5xx = None
        self._TotalCodeList = None
        self._PageNum = None
        self._PageSize = None
        self._TotalPage = None
        self._TotalNum = None
        self._TotalCode2xx = None
        self._TotalCode3xx = None
        self._RequestId = None

    @property
    def ProIspInfoList(self):
        """分省份分运营商错误码为2或3或4或5开头的状态码数据信息。
        :rtype: list of ProIspPlayCodeDataInfo
        """
        return self._ProIspInfoList

    @ProIspInfoList.setter
    def ProIspInfoList(self, ProIspInfoList):
        self._ProIspInfoList = ProIspInfoList

    @property
    def TotalCodeAll(self):
        """所有状态码的加和的次数。
        :rtype: int
        """
        return self._TotalCodeAll

    @TotalCodeAll.setter
    def TotalCodeAll(self, TotalCodeAll):
        self._TotalCodeAll = TotalCodeAll

    @property
    def TotalCode4xx(self):
        """状态码为4开头的总次数。
        :rtype: int
        """
        return self._TotalCode4xx

    @TotalCode4xx.setter
    def TotalCode4xx(self, TotalCode4xx):
        self._TotalCode4xx = TotalCode4xx

    @property
    def TotalCode5xx(self):
        """状态码为5开头的总次数。
        :rtype: int
        """
        return self._TotalCode5xx

    @TotalCode5xx.setter
    def TotalCode5xx(self, TotalCode5xx):
        self._TotalCode5xx = TotalCode5xx

    @property
    def TotalCodeList(self):
        """各状态码的总次数。
        :rtype: list of PlayCodeTotalInfo
        """
        return self._TotalCodeList

    @TotalCodeList.setter
    def TotalCodeList(self, TotalCodeList):
        self._TotalCodeList = TotalCodeList

    @property
    def PageNum(self):
        """页号。
        :rtype: int
        """
        return self._PageNum

    @PageNum.setter
    def PageNum(self, PageNum):
        self._PageNum = PageNum

    @property
    def PageSize(self):
        """每页大小。
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def TotalPage(self):
        """总页数。
        :rtype: int
        """
        return self._TotalPage

    @TotalPage.setter
    def TotalPage(self, TotalPage):
        self._TotalPage = TotalPage

    @property
    def TotalNum(self):
        """总记录数。
        :rtype: int
        """
        return self._TotalNum

    @TotalNum.setter
    def TotalNum(self, TotalNum):
        self._TotalNum = TotalNum

    @property
    def TotalCode2xx(self):
        """状态码为2开头的总次数。
        :rtype: int
        """
        return self._TotalCode2xx

    @TotalCode2xx.setter
    def TotalCode2xx(self, TotalCode2xx):
        self._TotalCode2xx = TotalCode2xx

    @property
    def TotalCode3xx(self):
        """状态码为3开头的总次数。
        :rtype: int
        """
        return self._TotalCode3xx

    @TotalCode3xx.setter
    def TotalCode3xx(self, TotalCode3xx):
        self._TotalCode3xx = TotalCode3xx

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ProIspInfoList") is not None:
            self._ProIspInfoList = []
            for item in params.get("ProIspInfoList"):
                obj = ProIspPlayCodeDataInfo()
                obj._deserialize(item)
                self._ProIspInfoList.append(obj)
        self._TotalCodeAll = params.get("TotalCodeAll")
        self._TotalCode4xx = params.get("TotalCode4xx")
        self._TotalCode5xx = params.get("TotalCode5xx")
        if params.get("TotalCodeList") is not None:
            self._TotalCodeList = []
            for item in params.get("TotalCodeList"):
                obj = PlayCodeTotalInfo()
                obj._deserialize(item)
                self._TotalCodeList.append(obj)
        self._PageNum = params.get("PageNum")
        self._PageSize = params.get("PageSize")
        self._TotalPage = params.get("TotalPage")
        self._TotalNum = params.get("TotalNum")
        self._TotalCode2xx = params.get("TotalCode2xx")
        self._TotalCode3xx = params.get("TotalCode3xx")
        self._RequestId = params.get("RequestId")


class DescribeProIspPlaySumInfoListRequest(AbstractModel):
    """DescribeProIspPlaySumInfoList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 起始时间，
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#:~:text=I-,ISO,-%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F)。
        :type StartTime: str
        :param _EndTime: 结束时间，
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#:~:text=I-,ISO,-%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F)。
注：EndTime 和 StartTime 只支持最近1天的数据查询。
        :type EndTime: str
        :param _StatType: 统计的类型，可选值：”Province”(省份)，”Isp”(运营商)，“CountryOrArea”(国家或地区)。
        :type StatType: str
        :param _PlayDomains: 播放域名列表，不填则为全部。
        :type PlayDomains: list of str
        :param _PageNum: 页号，范围是[1,1000]，默认值是1。
        :type PageNum: int
        :param _PageSize: 每页个数，范围是[1,1000]，默认值是20。
        :type PageSize: int
        :param _MainlandOrOversea: 地域，可选值：Mainland，Oversea，China，Foreign，Global（默认值）；如果为空，查询总的数据；如果为“Mainland”，查询中国大陆的数据；如果为“Oversea”，则查询中国大陆以外的数据；如果为China，查询中国的数据（包括港澳台）；如果为Foreign，查询国外的数据（不包括港澳台）。
        :type MainlandOrOversea: str
        :param _OutLanguage: 输出字段使用的语言，可选值：Chinese（默认值），English；目前国家，省份和运营商支持多语言。
        :type OutLanguage: str
        """
        self._StartTime = None
        self._EndTime = None
        self._StatType = None
        self._PlayDomains = None
        self._PageNum = None
        self._PageSize = None
        self._MainlandOrOversea = None
        self._OutLanguage = None

    @property
    def StartTime(self):
        """起始时间，
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#:~:text=I-,ISO,-%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F)。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束时间，
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#:~:text=I-,ISO,-%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F)。
注：EndTime 和 StartTime 只支持最近1天的数据查询。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def StatType(self):
        """统计的类型，可选值：”Province”(省份)，”Isp”(运营商)，“CountryOrArea”(国家或地区)。
        :rtype: str
        """
        return self._StatType

    @StatType.setter
    def StatType(self, StatType):
        self._StatType = StatType

    @property
    def PlayDomains(self):
        """播放域名列表，不填则为全部。
        :rtype: list of str
        """
        return self._PlayDomains

    @PlayDomains.setter
    def PlayDomains(self, PlayDomains):
        self._PlayDomains = PlayDomains

    @property
    def PageNum(self):
        """页号，范围是[1,1000]，默认值是1。
        :rtype: int
        """
        return self._PageNum

    @PageNum.setter
    def PageNum(self, PageNum):
        self._PageNum = PageNum

    @property
    def PageSize(self):
        """每页个数，范围是[1,1000]，默认值是20。
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def MainlandOrOversea(self):
        """地域，可选值：Mainland，Oversea，China，Foreign，Global（默认值）；如果为空，查询总的数据；如果为“Mainland”，查询中国大陆的数据；如果为“Oversea”，则查询中国大陆以外的数据；如果为China，查询中国的数据（包括港澳台）；如果为Foreign，查询国外的数据（不包括港澳台）。
        :rtype: str
        """
        return self._MainlandOrOversea

    @MainlandOrOversea.setter
    def MainlandOrOversea(self, MainlandOrOversea):
        self._MainlandOrOversea = MainlandOrOversea

    @property
    def OutLanguage(self):
        """输出字段使用的语言，可选值：Chinese（默认值），English；目前国家，省份和运营商支持多语言。
        :rtype: str
        """
        return self._OutLanguage

    @OutLanguage.setter
    def OutLanguage(self, OutLanguage):
        self._OutLanguage = OutLanguage


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._StatType = params.get("StatType")
        self._PlayDomains = params.get("PlayDomains")
        self._PageNum = params.get("PageNum")
        self._PageSize = params.get("PageSize")
        self._MainlandOrOversea = params.get("MainlandOrOversea")
        self._OutLanguage = params.get("OutLanguage")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeProIspPlaySumInfoListResponse(AbstractModel):
    """DescribeProIspPlaySumInfoList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalFlux: 总流量。
        :type TotalFlux: float
        :param _TotalRequest: 总请求数。
        :type TotalRequest: int
        :param _StatType: 统计的类型。
        :type StatType: str
        :param _PageSize: 每页的记录数。
        :type PageSize: int
        :param _PageNum: 页号。
        :type PageNum: int
        :param _TotalNum: 总记录数。
        :type TotalNum: int
        :param _TotalPage: 总页数。
        :type TotalPage: int
        :param _DataInfoList: 省份，运营商，国家或地区汇总数据列表。
        :type DataInfoList: list of ProIspPlaySumInfo
        :param _AvgFluxPerSecond: 下载速度，单位：MB/s，计算方式：总流量/总时长。
        :type AvgFluxPerSecond: float
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalFlux = None
        self._TotalRequest = None
        self._StatType = None
        self._PageSize = None
        self._PageNum = None
        self._TotalNum = None
        self._TotalPage = None
        self._DataInfoList = None
        self._AvgFluxPerSecond = None
        self._RequestId = None

    @property
    def TotalFlux(self):
        """总流量。
        :rtype: float
        """
        return self._TotalFlux

    @TotalFlux.setter
    def TotalFlux(self, TotalFlux):
        self._TotalFlux = TotalFlux

    @property
    def TotalRequest(self):
        """总请求数。
        :rtype: int
        """
        return self._TotalRequest

    @TotalRequest.setter
    def TotalRequest(self, TotalRequest):
        self._TotalRequest = TotalRequest

    @property
    def StatType(self):
        """统计的类型。
        :rtype: str
        """
        return self._StatType

    @StatType.setter
    def StatType(self, StatType):
        self._StatType = StatType

    @property
    def PageSize(self):
        """每页的记录数。
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def PageNum(self):
        """页号。
        :rtype: int
        """
        return self._PageNum

    @PageNum.setter
    def PageNum(self, PageNum):
        self._PageNum = PageNum

    @property
    def TotalNum(self):
        """总记录数。
        :rtype: int
        """
        return self._TotalNum

    @TotalNum.setter
    def TotalNum(self, TotalNum):
        self._TotalNum = TotalNum

    @property
    def TotalPage(self):
        """总页数。
        :rtype: int
        """
        return self._TotalPage

    @TotalPage.setter
    def TotalPage(self, TotalPage):
        self._TotalPage = TotalPage

    @property
    def DataInfoList(self):
        """省份，运营商，国家或地区汇总数据列表。
        :rtype: list of ProIspPlaySumInfo
        """
        return self._DataInfoList

    @DataInfoList.setter
    def DataInfoList(self, DataInfoList):
        self._DataInfoList = DataInfoList

    @property
    def AvgFluxPerSecond(self):
        """下载速度，单位：MB/s，计算方式：总流量/总时长。
        :rtype: float
        """
        return self._AvgFluxPerSecond

    @AvgFluxPerSecond.setter
    def AvgFluxPerSecond(self, AvgFluxPerSecond):
        self._AvgFluxPerSecond = AvgFluxPerSecond

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalFlux = params.get("TotalFlux")
        self._TotalRequest = params.get("TotalRequest")
        self._StatType = params.get("StatType")
        self._PageSize = params.get("PageSize")
        self._PageNum = params.get("PageNum")
        self._TotalNum = params.get("TotalNum")
        self._TotalPage = params.get("TotalPage")
        if params.get("DataInfoList") is not None:
            self._DataInfoList = []
            for item in params.get("DataInfoList"):
                obj = ProIspPlaySumInfo()
                obj._deserialize(item)
                self._DataInfoList.append(obj)
        self._AvgFluxPerSecond = params.get("AvgFluxPerSecond")
        self._RequestId = params.get("RequestId")


class DescribeProvinceIspPlayInfoListRequest(AbstractModel):
    """DescribeProvinceIspPlayInfoList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 起始时间点，
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#:~:text=I-,ISO,-%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F)。
        :type StartTime: str
        :param _EndTime: 结束时间点，
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#:~:text=I-,ISO,-%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F)。
注：EndTime 和 StartTime 只支持最近1天的数据查询。
        :type EndTime: str
        :param _Granularity: 支持如下粒度：
1：1分钟粒度（跨度不支持超过1天）
        :type Granularity: int
        :param _StatType: 统计指标类型：
“Bandwidth”：带宽
“FluxPerSecond”：平均流量
“Flux”：流量
“Request”：请求数
“Online”：并发连接数
        :type StatType: str
        :param _PlayDomains: 播放域名列表。
        :type PlayDomains: list of str
        :param _ProvinceNames: 要查询的省份（地区）英文名称列表，如 Beijing。
        :type ProvinceNames: list of str
        :param _IspNames: 要查询的运营商英文名称列表，如 China Mobile ，如果为空，查询所有运营商的数据。
        :type IspNames: list of str
        :param _MainlandOrOversea: 地域，可选值：Mainland，Oversea，China，Foreign，Global（默认值）；如果为空，查询总的数据；如果为“Mainland”，查询中国大陆的数据；如果为“Oversea”，则查询中国大陆以外的数据；如果为China，查询中国的数据（包括港澳台）；如果为Foreign，查询国外的数据（不包括港澳台）。
        :type MainlandOrOversea: str
        :param _IpType: ip类型：
“Ipv6”：Ipv6数据
如果为空，查询总的数据；
        :type IpType: str
        """
        self._StartTime = None
        self._EndTime = None
        self._Granularity = None
        self._StatType = None
        self._PlayDomains = None
        self._ProvinceNames = None
        self._IspNames = None
        self._MainlandOrOversea = None
        self._IpType = None

    @property
    def StartTime(self):
        """起始时间点，
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#:~:text=I-,ISO,-%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F)。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束时间点，
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#:~:text=I-,ISO,-%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F)。
注：EndTime 和 StartTime 只支持最近1天的数据查询。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Granularity(self):
        """支持如下粒度：
1：1分钟粒度（跨度不支持超过1天）
        :rtype: int
        """
        return self._Granularity

    @Granularity.setter
    def Granularity(self, Granularity):
        self._Granularity = Granularity

    @property
    def StatType(self):
        """统计指标类型：
“Bandwidth”：带宽
“FluxPerSecond”：平均流量
“Flux”：流量
“Request”：请求数
“Online”：并发连接数
        :rtype: str
        """
        return self._StatType

    @StatType.setter
    def StatType(self, StatType):
        self._StatType = StatType

    @property
    def PlayDomains(self):
        """播放域名列表。
        :rtype: list of str
        """
        return self._PlayDomains

    @PlayDomains.setter
    def PlayDomains(self, PlayDomains):
        self._PlayDomains = PlayDomains

    @property
    def ProvinceNames(self):
        """要查询的省份（地区）英文名称列表，如 Beijing。
        :rtype: list of str
        """
        return self._ProvinceNames

    @ProvinceNames.setter
    def ProvinceNames(self, ProvinceNames):
        self._ProvinceNames = ProvinceNames

    @property
    def IspNames(self):
        """要查询的运营商英文名称列表，如 China Mobile ，如果为空，查询所有运营商的数据。
        :rtype: list of str
        """
        return self._IspNames

    @IspNames.setter
    def IspNames(self, IspNames):
        self._IspNames = IspNames

    @property
    def MainlandOrOversea(self):
        """地域，可选值：Mainland，Oversea，China，Foreign，Global（默认值）；如果为空，查询总的数据；如果为“Mainland”，查询中国大陆的数据；如果为“Oversea”，则查询中国大陆以外的数据；如果为China，查询中国的数据（包括港澳台）；如果为Foreign，查询国外的数据（不包括港澳台）。
        :rtype: str
        """
        return self._MainlandOrOversea

    @MainlandOrOversea.setter
    def MainlandOrOversea(self, MainlandOrOversea):
        self._MainlandOrOversea = MainlandOrOversea

    @property
    def IpType(self):
        """ip类型：
“Ipv6”：Ipv6数据
如果为空，查询总的数据；
        :rtype: str
        """
        return self._IpType

    @IpType.setter
    def IpType(self, IpType):
        self._IpType = IpType


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Granularity = params.get("Granularity")
        self._StatType = params.get("StatType")
        self._PlayDomains = params.get("PlayDomains")
        self._ProvinceNames = params.get("ProvinceNames")
        self._IspNames = params.get("IspNames")
        self._MainlandOrOversea = params.get("MainlandOrOversea")
        self._IpType = params.get("IpType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeProvinceIspPlayInfoListResponse(AbstractModel):
    """DescribeProvinceIspPlayInfoList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DataInfoList: 播放信息列表。
        :type DataInfoList: list of PlayStatInfo
        :param _StatType: 统计的类型，和输入参数保持一致。
        :type StatType: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DataInfoList = None
        self._StatType = None
        self._RequestId = None

    @property
    def DataInfoList(self):
        """播放信息列表。
        :rtype: list of PlayStatInfo
        """
        return self._DataInfoList

    @DataInfoList.setter
    def DataInfoList(self, DataInfoList):
        self._DataInfoList = DataInfoList

    @property
    def StatType(self):
        """统计的类型，和输入参数保持一致。
        :rtype: str
        """
        return self._StatType

    @StatType.setter
    def StatType(self, StatType):
        self._StatType = StatType

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DataInfoList") is not None:
            self._DataInfoList = []
            for item in params.get("DataInfoList"):
                obj = PlayStatInfo()
                obj._deserialize(item)
                self._DataInfoList.append(obj)
        self._StatType = params.get("StatType")
        self._RequestId = params.get("RequestId")


class DescribePullStreamConfigsRequest(AbstractModel):
    """DescribePullStreamConfigs请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ConfigId: 配置 ID。
获取途径：从 CreatePullStreamConfig 接口返回值获取。
        :type ConfigId: str
        """
        self._ConfigId = None

    @property
    def ConfigId(self):
        """配置 ID。
获取途径：从 CreatePullStreamConfig 接口返回值获取。
        :rtype: str
        """
        return self._ConfigId

    @ConfigId.setter
    def ConfigId(self, ConfigId):
        self._ConfigId = ConfigId


    def _deserialize(self, params):
        self._ConfigId = params.get("ConfigId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePullStreamConfigsResponse(AbstractModel):
    """DescribePullStreamConfigs返回参数结构体

    """

    def __init__(self):
        r"""
        :param _PullStreamConfigs: 拉流配置。
        :type PullStreamConfigs: list of PullStreamConfig
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._PullStreamConfigs = None
        self._RequestId = None

    @property
    def PullStreamConfigs(self):
        """拉流配置。
        :rtype: list of PullStreamConfig
        """
        return self._PullStreamConfigs

    @PullStreamConfigs.setter
    def PullStreamConfigs(self, PullStreamConfigs):
        self._PullStreamConfigs = PullStreamConfigs

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("PullStreamConfigs") is not None:
            self._PullStreamConfigs = []
            for item in params.get("PullStreamConfigs"):
                obj = PullStreamConfig()
                obj._deserialize(item)
                self._PullStreamConfigs.append(obj)
        self._RequestId = params.get("RequestId")


class DescribePullTransformPushInfoRequest(AbstractModel):
    """DescribePullTransformPushInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 起始时间点，接口查询支持两种时间格式：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见IOS日期格式说明文档: https://cloud.tencent.com/document/product/266/11732#I
2）YYYY-MM-DD hh:mm:ss：使用此格式时，默认代表北京时间。
        :type StartTime: str
        :param _EndTime: 结束时间点，接口查询支持两种时间格式：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见IOS日期格式说明文档: https://cloud.tencent.com/document/product/266/11732#I
2）YYYY-MM-DD hh:mm:ss：使用此格式时，默认代表北京时间。
支持最近三年的查询，查询开始和结束时间跨度不支持超过31天。
        :type EndTime: str
        :param _MainlandOrOversea: 可选值：
Mainland：查询国内数据，
Oversea：则查询国外数据，
默认：查询国内+国外的数据。
        :type MainlandOrOversea: str
        :param _SourceType: 可选值：  PullLivePushLive：拉流源类型为直播  PullVodPushLive：拉流源类型为点播  PullPicPushLive：拉流源类型为图片  默认：查询全部拉流源类型
        :type SourceType: str
        """
        self._StartTime = None
        self._EndTime = None
        self._MainlandOrOversea = None
        self._SourceType = None

    @property
    def StartTime(self):
        """起始时间点，接口查询支持两种时间格式：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见IOS日期格式说明文档: https://cloud.tencent.com/document/product/266/11732#I
2）YYYY-MM-DD hh:mm:ss：使用此格式时，默认代表北京时间。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束时间点，接口查询支持两种时间格式：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见IOS日期格式说明文档: https://cloud.tencent.com/document/product/266/11732#I
2）YYYY-MM-DD hh:mm:ss：使用此格式时，默认代表北京时间。
支持最近三年的查询，查询开始和结束时间跨度不支持超过31天。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def MainlandOrOversea(self):
        """可选值：
Mainland：查询国内数据，
Oversea：则查询国外数据，
默认：查询国内+国外的数据。
        :rtype: str
        """
        return self._MainlandOrOversea

    @MainlandOrOversea.setter
    def MainlandOrOversea(self, MainlandOrOversea):
        self._MainlandOrOversea = MainlandOrOversea

    @property
    def SourceType(self):
        """可选值：  PullLivePushLive：拉流源类型为直播  PullVodPushLive：拉流源类型为点播  PullPicPushLive：拉流源类型为图片  默认：查询全部拉流源类型
        :rtype: str
        """
        return self._SourceType

    @SourceType.setter
    def SourceType(self, SourceType):
        self._SourceType = SourceType


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._MainlandOrOversea = params.get("MainlandOrOversea")
        self._SourceType = params.get("SourceType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePullTransformPushInfoResponse(AbstractModel):
    """DescribePullTransformPushInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DataInfoList: 时长统计数据列表
        :type DataInfoList: list of TaskDurationInfo
        :param _TotalDuration: 拉流转推得总时长
        :type TotalDuration: int
        :param _TotalDurationSecond: 拉流转推得总时长（秒）
        :type TotalDurationSecond: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DataInfoList = None
        self._TotalDuration = None
        self._TotalDurationSecond = None
        self._RequestId = None

    @property
    def DataInfoList(self):
        """时长统计数据列表
        :rtype: list of TaskDurationInfo
        """
        return self._DataInfoList

    @DataInfoList.setter
    def DataInfoList(self, DataInfoList):
        self._DataInfoList = DataInfoList

    @property
    def TotalDuration(self):
        """拉流转推得总时长
        :rtype: int
        """
        return self._TotalDuration

    @TotalDuration.setter
    def TotalDuration(self, TotalDuration):
        self._TotalDuration = TotalDuration

    @property
    def TotalDurationSecond(self):
        """拉流转推得总时长（秒）
        :rtype: int
        """
        return self._TotalDurationSecond

    @TotalDurationSecond.setter
    def TotalDurationSecond(self, TotalDurationSecond):
        self._TotalDurationSecond = TotalDurationSecond

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DataInfoList") is not None:
            self._DataInfoList = []
            for item in params.get("DataInfoList"):
                obj = TaskDurationInfo()
                obj._deserialize(item)
                self._DataInfoList.append(obj)
        self._TotalDuration = params.get("TotalDuration")
        self._TotalDurationSecond = params.get("TotalDurationSecond")
        self._RequestId = params.get("RequestId")


class DescribePushBandwidthAndFluxListRequest(AbstractModel):
    """DescribePushBandwidthAndFluxList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 查询开始时间点，精确到分钟粒度，接口查询支持两种时间格式：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#52)。
2）YYYY-MM-DD hh:mm:ss：使用此格式时，默认代表北京时间。
支持最近两个月的查询，查询开始和结束时间跨度不支持超过31天。
        :type StartTime: str
        :param _EndTime: 查询结束时间点，精确到分钟粒度，接口查询支持两种时间格式：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#52)。
2）YYYY-MM-DD hh:mm:ss：使用此格式时，默认代表北京时间。
支持最近两个月的查询，查询开始和结束时间跨度不支持超过31天。
        :type EndTime: str
        :param _PushDomains: 域名，可以填多个，若不填，表示总体数据。
        :type PushDomains: list of str
        :param _MainlandOrOversea: 可选值：
Mainland：查询中国大陆（境内）数据，
Oversea：则查询国际/港澳台（境外）数据，
不填则默认查询全球地区（境内+境外）的数据。
        :type MainlandOrOversea: str
        :param _Granularity: 数据粒度，支持如下粒度：
5：5分钟粒度，（跨度不支持超过1天），
60：1小时粒度（跨度不支持超过一个月），
1440：天粒度（跨度不支持超过一个月）。
默认值：5。
        :type Granularity: int
        :param _RegionNames: 大区，映射表如下：
China Mainland 中国大陆
Asia Pacific I 亚太一区
Asia Pacific II 亚太二区
Asia Pacific III 亚太三区
Europe 欧洲
North America 北美
South America 南美
Middle East 中东
Africa 非洲。
        :type RegionNames: list of str
        :param _CountryNames: 国家，映射表参照如下文档：
https://cloud.tencent.com/document/product/267/34019。
        :type CountryNames: list of str
        """
        self._StartTime = None
        self._EndTime = None
        self._PushDomains = None
        self._MainlandOrOversea = None
        self._Granularity = None
        self._RegionNames = None
        self._CountryNames = None

    @property
    def StartTime(self):
        """查询开始时间点，精确到分钟粒度，接口查询支持两种时间格式：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#52)。
2）YYYY-MM-DD hh:mm:ss：使用此格式时，默认代表北京时间。
支持最近两个月的查询，查询开始和结束时间跨度不支持超过31天。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """查询结束时间点，精确到分钟粒度，接口查询支持两种时间格式：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#52)。
2）YYYY-MM-DD hh:mm:ss：使用此格式时，默认代表北京时间。
支持最近两个月的查询，查询开始和结束时间跨度不支持超过31天。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def PushDomains(self):
        """域名，可以填多个，若不填，表示总体数据。
        :rtype: list of str
        """
        return self._PushDomains

    @PushDomains.setter
    def PushDomains(self, PushDomains):
        self._PushDomains = PushDomains

    @property
    def MainlandOrOversea(self):
        """可选值：
Mainland：查询中国大陆（境内）数据，
Oversea：则查询国际/港澳台（境外）数据，
不填则默认查询全球地区（境内+境外）的数据。
        :rtype: str
        """
        return self._MainlandOrOversea

    @MainlandOrOversea.setter
    def MainlandOrOversea(self, MainlandOrOversea):
        self._MainlandOrOversea = MainlandOrOversea

    @property
    def Granularity(self):
        """数据粒度，支持如下粒度：
5：5分钟粒度，（跨度不支持超过1天），
60：1小时粒度（跨度不支持超过一个月），
1440：天粒度（跨度不支持超过一个月）。
默认值：5。
        :rtype: int
        """
        return self._Granularity

    @Granularity.setter
    def Granularity(self, Granularity):
        self._Granularity = Granularity

    @property
    def RegionNames(self):
        """大区，映射表如下：
China Mainland 中国大陆
Asia Pacific I 亚太一区
Asia Pacific II 亚太二区
Asia Pacific III 亚太三区
Europe 欧洲
North America 北美
South America 南美
Middle East 中东
Africa 非洲。
        :rtype: list of str
        """
        return self._RegionNames

    @RegionNames.setter
    def RegionNames(self, RegionNames):
        self._RegionNames = RegionNames

    @property
    def CountryNames(self):
        """国家，映射表参照如下文档：
https://cloud.tencent.com/document/product/267/34019。
        :rtype: list of str
        """
        return self._CountryNames

    @CountryNames.setter
    def CountryNames(self, CountryNames):
        self._CountryNames = CountryNames


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._PushDomains = params.get("PushDomains")
        self._MainlandOrOversea = params.get("MainlandOrOversea")
        self._Granularity = params.get("Granularity")
        self._RegionNames = params.get("RegionNames")
        self._CountryNames = params.get("CountryNames")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePushBandwidthAndFluxListResponse(AbstractModel):
    """DescribePushBandwidthAndFluxList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _PeakBandwidthTime: 峰值带宽所在时间点，
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :type PeakBandwidthTime: str
        :param _PeakBandwidth: 峰值带宽，单位是 Mbps。
        :type PeakBandwidth: float
        :param _P95PeakBandwidthTime: 95峰值带宽所在时间点，
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :type P95PeakBandwidthTime: str
        :param _P95PeakBandwidth: 95峰值带宽，单位是 Mbps。
        :type P95PeakBandwidth: float
        :param _SumFlux: 总流量，单位是 MB。
        :type SumFlux: float
        :param _DataInfoList: 明细数据信息。
        :type DataInfoList: list of BillDataInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._PeakBandwidthTime = None
        self._PeakBandwidth = None
        self._P95PeakBandwidthTime = None
        self._P95PeakBandwidth = None
        self._SumFlux = None
        self._DataInfoList = None
        self._RequestId = None

    @property
    def PeakBandwidthTime(self):
        """峰值带宽所在时间点，
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._PeakBandwidthTime

    @PeakBandwidthTime.setter
    def PeakBandwidthTime(self, PeakBandwidthTime):
        self._PeakBandwidthTime = PeakBandwidthTime

    @property
    def PeakBandwidth(self):
        """峰值带宽，单位是 Mbps。
        :rtype: float
        """
        return self._PeakBandwidth

    @PeakBandwidth.setter
    def PeakBandwidth(self, PeakBandwidth):
        self._PeakBandwidth = PeakBandwidth

    @property
    def P95PeakBandwidthTime(self):
        """95峰值带宽所在时间点，
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._P95PeakBandwidthTime

    @P95PeakBandwidthTime.setter
    def P95PeakBandwidthTime(self, P95PeakBandwidthTime):
        self._P95PeakBandwidthTime = P95PeakBandwidthTime

    @property
    def P95PeakBandwidth(self):
        """95峰值带宽，单位是 Mbps。
        :rtype: float
        """
        return self._P95PeakBandwidth

    @P95PeakBandwidth.setter
    def P95PeakBandwidth(self, P95PeakBandwidth):
        self._P95PeakBandwidth = P95PeakBandwidth

    @property
    def SumFlux(self):
        """总流量，单位是 MB。
        :rtype: float
        """
        return self._SumFlux

    @SumFlux.setter
    def SumFlux(self, SumFlux):
        self._SumFlux = SumFlux

    @property
    def DataInfoList(self):
        """明细数据信息。
        :rtype: list of BillDataInfo
        """
        return self._DataInfoList

    @DataInfoList.setter
    def DataInfoList(self, DataInfoList):
        self._DataInfoList = DataInfoList

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._PeakBandwidthTime = params.get("PeakBandwidthTime")
        self._PeakBandwidth = params.get("PeakBandwidth")
        self._P95PeakBandwidthTime = params.get("P95PeakBandwidthTime")
        self._P95PeakBandwidth = params.get("P95PeakBandwidth")
        self._SumFlux = params.get("SumFlux")
        if params.get("DataInfoList") is not None:
            self._DataInfoList = []
            for item in params.get("DataInfoList"):
                obj = BillDataInfo()
                obj._deserialize(item)
                self._DataInfoList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRecordTaskRequest(AbstractModel):
    """DescribeRecordTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 查询任务开始时间，Unix 时间戳。设置时间不早于当前时间之前90天的时间，且查询时间跨度不超过一周。
        :type StartTime: int
        :param _EndTime: 查询任务结束时间，Unix 时间戳。EndTime 必须大于 StartTime，设置时间不早于当前时间之前90天的时间，且查询时间跨度不超过一周。（注意：任务开始结束时间必须在查询时间范围内）。
        :type EndTime: int
        :param _StreamName: 流名称。
        :type StreamName: str
        :param _DomainName: 推流域名。
        :type DomainName: str
        :param _AppName: 推流路径。
        :type AppName: str
        :param _ScrollToken: 翻页标识，分批拉取时使用：当单次请求无法拉取所有数据，接口将会返回 ScrollToken，下一次请求携带该 Token，将会从下一条记录开始获取。
        :type ScrollToken: str
        """
        self._StartTime = None
        self._EndTime = None
        self._StreamName = None
        self._DomainName = None
        self._AppName = None
        self._ScrollToken = None

    @property
    def StartTime(self):
        """查询任务开始时间，Unix 时间戳。设置时间不早于当前时间之前90天的时间，且查询时间跨度不超过一周。
        :rtype: int
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """查询任务结束时间，Unix 时间戳。EndTime 必须大于 StartTime，设置时间不早于当前时间之前90天的时间，且查询时间跨度不超过一周。（注意：任务开始结束时间必须在查询时间范围内）。
        :rtype: int
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def StreamName(self):
        """流名称。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName

    @property
    def DomainName(self):
        """推流域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def AppName(self):
        """推流路径。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def ScrollToken(self):
        """翻页标识，分批拉取时使用：当单次请求无法拉取所有数据，接口将会返回 ScrollToken，下一次请求携带该 Token，将会从下一条记录开始获取。
        :rtype: str
        """
        return self._ScrollToken

    @ScrollToken.setter
    def ScrollToken(self, ScrollToken):
        self._ScrollToken = ScrollToken


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._StreamName = params.get("StreamName")
        self._DomainName = params.get("DomainName")
        self._AppName = params.get("AppName")
        self._ScrollToken = params.get("ScrollToken")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRecordTaskResponse(AbstractModel):
    """DescribeRecordTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ScrollToken: 翻页标识，当请求未返回所有数据，该字段表示下一条记录的 Token。当该字段为空，说明已无更多数据。
        :type ScrollToken: str
        :param _TaskList: 录制任务列表。当该字段为空，说明已返回所有数据。
        :type TaskList: list of RecordTask
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ScrollToken = None
        self._TaskList = None
        self._RequestId = None

    @property
    def ScrollToken(self):
        """翻页标识，当请求未返回所有数据，该字段表示下一条记录的 Token。当该字段为空，说明已无更多数据。
        :rtype: str
        """
        return self._ScrollToken

    @ScrollToken.setter
    def ScrollToken(self, ScrollToken):
        self._ScrollToken = ScrollToken

    @property
    def TaskList(self):
        """录制任务列表。当该字段为空，说明已返回所有数据。
        :rtype: list of RecordTask
        """
        return self._TaskList

    @TaskList.setter
    def TaskList(self, TaskList):
        self._TaskList = TaskList

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ScrollToken = params.get("ScrollToken")
        if params.get("TaskList") is not None:
            self._TaskList = []
            for item in params.get("TaskList"):
                obj = RecordTask()
                obj._deserialize(item)
                self._TaskList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeScreenShotSheetNumListRequest(AbstractModel):
    """DescribeScreenShotSheetNumList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 起始时间点，接口查询支持两种时间格式：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见IOS日期格式说明文档: https://cloud.tencent.com/document/product/266/11732#I
2）YYYY-MM-DD hh:mm:ss：使用此格式时，默认代表北京时间。
        :type StartTime: str
        :param _EndTime: 结束时间点，接口查询支持两种时间格式：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见IOS日期格式说明文档: https://cloud.tencent.com/document/product/266/11732#I
2）YYYY-MM-DD hh:mm:ss：使用此格式时，默认代表北京时间。
支持最近三个月的查询，查询开始和结束时间跨度不支持超过31天。
        :type EndTime: str
        :param _Zone: 地域信息，可选值包括Mainland，Oversea，前者是查询中国大陆范围内的数据，后者是除中国大陆范围之外的数据，若不传该参数，则查询所有地区的数据。
        :type Zone: str
        :param _PushDomains: 推流域名（支持查询2019年11 月1日之后的域名维度数据）。
        :type PushDomains: list of str
        :param _Granularity: 数据维度，数据延迟1个半小时，可选值包括：1、Minute（5分钟粒度，最大支持查询时间范围是31天），2、Day（天粒度，默认值，按照北京时间做跨天处理，最大支持查询时间范围是186天当天）。
        :type Granularity: str
        """
        self._StartTime = None
        self._EndTime = None
        self._Zone = None
        self._PushDomains = None
        self._Granularity = None

    @property
    def StartTime(self):
        """起始时间点，接口查询支持两种时间格式：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见IOS日期格式说明文档: https://cloud.tencent.com/document/product/266/11732#I
2）YYYY-MM-DD hh:mm:ss：使用此格式时，默认代表北京时间。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束时间点，接口查询支持两种时间格式：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见IOS日期格式说明文档: https://cloud.tencent.com/document/product/266/11732#I
2）YYYY-MM-DD hh:mm:ss：使用此格式时，默认代表北京时间。
支持最近三个月的查询，查询开始和结束时间跨度不支持超过31天。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Zone(self):
        """地域信息，可选值包括Mainland，Oversea，前者是查询中国大陆范围内的数据，后者是除中国大陆范围之外的数据，若不传该参数，则查询所有地区的数据。
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def PushDomains(self):
        """推流域名（支持查询2019年11 月1日之后的域名维度数据）。
        :rtype: list of str
        """
        return self._PushDomains

    @PushDomains.setter
    def PushDomains(self, PushDomains):
        self._PushDomains = PushDomains

    @property
    def Granularity(self):
        """数据维度，数据延迟1个半小时，可选值包括：1、Minute（5分钟粒度，最大支持查询时间范围是31天），2、Day（天粒度，默认值，按照北京时间做跨天处理，最大支持查询时间范围是186天当天）。
        :rtype: str
        """
        return self._Granularity

    @Granularity.setter
    def Granularity(self, Granularity):
        self._Granularity = Granularity


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Zone = params.get("Zone")
        self._PushDomains = params.get("PushDomains")
        self._Granularity = params.get("Granularity")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeScreenShotSheetNumListResponse(AbstractModel):
    """DescribeScreenShotSheetNumList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DataInfoList: 数据信息列表。
        :type DataInfoList: list of TimeValue
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DataInfoList = None
        self._RequestId = None

    @property
    def DataInfoList(self):
        """数据信息列表。
        :rtype: list of TimeValue
        """
        return self._DataInfoList

    @DataInfoList.setter
    def DataInfoList(self, DataInfoList):
        self._DataInfoList = DataInfoList

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DataInfoList") is not None:
            self._DataInfoList = []
            for item in params.get("DataInfoList"):
                obj = TimeValue()
                obj._deserialize(item)
                self._DataInfoList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeScreenshotTaskRequest(AbstractModel):
    """DescribeScreenshotTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 查询任务开始时间，Unix 时间戳。设置时间不早于当前时间之前90天的时间，且查询时间跨度不超过一周。
        :type StartTime: int
        :param _EndTime: 查询任务结束时间，Unix 时间戳。EndTime 必须大于 StartTime，设置时间不早于当前时间之前90天的时间，且查询时间跨度不超过一周。（注意：任务开始结束时间必须在查询时间范围内）。
        :type EndTime: int
        :param _StreamName: 流名称。
        :type StreamName: str
        :param _DomainName: 推流域名。
        :type DomainName: str
        :param _AppName: 推流路径。
        :type AppName: str
        :param _ScrollToken: 翻页标识，分批拉取时使用：当单次请求无法拉取所有数据，接口将会返回 ScrollToken，下一次请求携带该 Token，将会从下一条记录开始获取。
        :type ScrollToken: str
        """
        self._StartTime = None
        self._EndTime = None
        self._StreamName = None
        self._DomainName = None
        self._AppName = None
        self._ScrollToken = None

    @property
    def StartTime(self):
        """查询任务开始时间，Unix 时间戳。设置时间不早于当前时间之前90天的时间，且查询时间跨度不超过一周。
        :rtype: int
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """查询任务结束时间，Unix 时间戳。EndTime 必须大于 StartTime，设置时间不早于当前时间之前90天的时间，且查询时间跨度不超过一周。（注意：任务开始结束时间必须在查询时间范围内）。
        :rtype: int
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def StreamName(self):
        """流名称。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName

    @property
    def DomainName(self):
        """推流域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def AppName(self):
        """推流路径。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def ScrollToken(self):
        """翻页标识，分批拉取时使用：当单次请求无法拉取所有数据，接口将会返回 ScrollToken，下一次请求携带该 Token，将会从下一条记录开始获取。
        :rtype: str
        """
        return self._ScrollToken

    @ScrollToken.setter
    def ScrollToken(self, ScrollToken):
        self._ScrollToken = ScrollToken


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._StreamName = params.get("StreamName")
        self._DomainName = params.get("DomainName")
        self._AppName = params.get("AppName")
        self._ScrollToken = params.get("ScrollToken")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeScreenshotTaskResponse(AbstractModel):
    """DescribeScreenshotTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ScrollToken: 翻页标识，当请求未返回所有数据，该字段表示下一条记录的 Token。当该字段为空，说明已无更多数据。
        :type ScrollToken: str
        :param _TaskList: 截图任务列表。当该字段为空，说明已返回所有数据。
        :type TaskList: list of ScreenshotTask
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ScrollToken = None
        self._TaskList = None
        self._RequestId = None

    @property
    def ScrollToken(self):
        """翻页标识，当请求未返回所有数据，该字段表示下一条记录的 Token。当该字段为空，说明已无更多数据。
        :rtype: str
        """
        return self._ScrollToken

    @ScrollToken.setter
    def ScrollToken(self, ScrollToken):
        self._ScrollToken = ScrollToken

    @property
    def TaskList(self):
        """截图任务列表。当该字段为空，说明已返回所有数据。
        :rtype: list of ScreenshotTask
        """
        return self._TaskList

    @TaskList.setter
    def TaskList(self, TaskList):
        self._TaskList = TaskList

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ScrollToken = params.get("ScrollToken")
        if params.get("TaskList") is not None:
            self._TaskList = []
            for item in params.get("TaskList"):
                obj = ScreenshotTask()
                obj._deserialize(item)
                self._TaskList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeStreamDayPlayInfoListRequest(AbstractModel):
    """DescribeStreamDayPlayInfoList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DayTime: 日期，格式：YYYY-mm-dd。
第二天凌晨3点出昨天的数据，建议在这个时间点之后查询最新数据。支持最近3个月的数据查询。
        :type DayTime: str
        :param _PlayDomain: 播放域名。
        :type PlayDomain: str
        :param _PageNum: 页号，范围[1,1000]，默认值是1。
        :type PageNum: int
        :param _PageSize: 每页个数，范围[100,1000]，默认值是1000。
        :type PageSize: int
        :param _MainlandOrOversea: 可选值：
Mainland：查询国内数据，
Oversea：则查询国外数据，
默认：查询国内+国外的数据。
        :type MainlandOrOversea: str
        :param _ServiceName: 服务名称，可选值包括LVB(标准直播)，LEB(快直播)，不填则查LVB+LEB总值。
        :type ServiceName: str
        """
        self._DayTime = None
        self._PlayDomain = None
        self._PageNum = None
        self._PageSize = None
        self._MainlandOrOversea = None
        self._ServiceName = None

    @property
    def DayTime(self):
        """日期，格式：YYYY-mm-dd。
第二天凌晨3点出昨天的数据，建议在这个时间点之后查询最新数据。支持最近3个月的数据查询。
        :rtype: str
        """
        return self._DayTime

    @DayTime.setter
    def DayTime(self, DayTime):
        self._DayTime = DayTime

    @property
    def PlayDomain(self):
        """播放域名。
        :rtype: str
        """
        return self._PlayDomain

    @PlayDomain.setter
    def PlayDomain(self, PlayDomain):
        self._PlayDomain = PlayDomain

    @property
    def PageNum(self):
        """页号，范围[1,1000]，默认值是1。
        :rtype: int
        """
        return self._PageNum

    @PageNum.setter
    def PageNum(self, PageNum):
        self._PageNum = PageNum

    @property
    def PageSize(self):
        """每页个数，范围[100,1000]，默认值是1000。
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def MainlandOrOversea(self):
        """可选值：
Mainland：查询国内数据，
Oversea：则查询国外数据，
默认：查询国内+国外的数据。
        :rtype: str
        """
        return self._MainlandOrOversea

    @MainlandOrOversea.setter
    def MainlandOrOversea(self, MainlandOrOversea):
        self._MainlandOrOversea = MainlandOrOversea

    @property
    def ServiceName(self):
        """服务名称，可选值包括LVB(标准直播)，LEB(快直播)，不填则查LVB+LEB总值。
        :rtype: str
        """
        return self._ServiceName

    @ServiceName.setter
    def ServiceName(self, ServiceName):
        self._ServiceName = ServiceName


    def _deserialize(self, params):
        self._DayTime = params.get("DayTime")
        self._PlayDomain = params.get("PlayDomain")
        self._PageNum = params.get("PageNum")
        self._PageSize = params.get("PageSize")
        self._MainlandOrOversea = params.get("MainlandOrOversea")
        self._ServiceName = params.get("ServiceName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeStreamDayPlayInfoListResponse(AbstractModel):
    """DescribeStreamDayPlayInfoList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DataInfoList: 播放数据信息列表。
        :type DataInfoList: list of PlayDataInfoByStream
        :param _TotalNum: 总数量。
        :type TotalNum: int
        :param _TotalPage: 总页数。
        :type TotalPage: int
        :param _PageNum: 当前数据所处页码。
        :type PageNum: int
        :param _PageSize: 每页个数。
        :type PageSize: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DataInfoList = None
        self._TotalNum = None
        self._TotalPage = None
        self._PageNum = None
        self._PageSize = None
        self._RequestId = None

    @property
    def DataInfoList(self):
        """播放数据信息列表。
        :rtype: list of PlayDataInfoByStream
        """
        return self._DataInfoList

    @DataInfoList.setter
    def DataInfoList(self, DataInfoList):
        self._DataInfoList = DataInfoList

    @property
    def TotalNum(self):
        """总数量。
        :rtype: int
        """
        return self._TotalNum

    @TotalNum.setter
    def TotalNum(self, TotalNum):
        self._TotalNum = TotalNum

    @property
    def TotalPage(self):
        """总页数。
        :rtype: int
        """
        return self._TotalPage

    @TotalPage.setter
    def TotalPage(self, TotalPage):
        self._TotalPage = TotalPage

    @property
    def PageNum(self):
        """当前数据所处页码。
        :rtype: int
        """
        return self._PageNum

    @PageNum.setter
    def PageNum(self, PageNum):
        self._PageNum = PageNum

    @property
    def PageSize(self):
        """每页个数。
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DataInfoList") is not None:
            self._DataInfoList = []
            for item in params.get("DataInfoList"):
                obj = PlayDataInfoByStream()
                obj._deserialize(item)
                self._DataInfoList.append(obj)
        self._TotalNum = params.get("TotalNum")
        self._TotalPage = params.get("TotalPage")
        self._PageNum = params.get("PageNum")
        self._PageSize = params.get("PageSize")
        self._RequestId = params.get("RequestId")


class DescribeStreamPlayInfoListRequest(AbstractModel):
    """DescribeStreamPlayInfoList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 起始时间点，接口查询支持两种时间格式：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见IOS日期格式说明文档: https://cloud.tencent.com/document/product/266/11732#I
2）yyyy-MM-dd HH:mm:ss：使用此格式时，默认代表北京时间。
开始时间和结束时间的格式需要保持一致。
        :type StartTime: str
        :param _EndTime: 结束时间点，接口查询支持两种时间格式：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见IOS日期格式说明文档: https://cloud.tencent.com/document/product/266/11732#I
2）yyyy-MM-dd HH:mm:ss：使用此格式时，默认代表北京时间。
开始时间和结束时间的格式需要保持一致。结束时间和开始时间跨度不支持超过24小时，支持距当前时间一个月内的数据查询。
        :type EndTime: str
        :param _PlayDomain: 播放域名，
若不填，则为查询所有播放域名的在线流数据。
        :type PlayDomain: str
        :param _StreamName: 流名称，精确匹配。
若不填，则为查询总体播放数据。
        :type StreamName: str
        :param _AppName: 推流路径，与播放地址中的AppName保持一致，会精确匹配，在同时传递了StreamName时生效。
若不填，则为查询总体播放数据。
        :type AppName: str
        :param _ServiceName: 服务名称，可选值包括LVB(标准直播)，LEB(快直播)，不填则查LVB+LEB总值。
        :type ServiceName: str
        """
        self._StartTime = None
        self._EndTime = None
        self._PlayDomain = None
        self._StreamName = None
        self._AppName = None
        self._ServiceName = None

    @property
    def StartTime(self):
        """起始时间点，接口查询支持两种时间格式：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见IOS日期格式说明文档: https://cloud.tencent.com/document/product/266/11732#I
2）yyyy-MM-dd HH:mm:ss：使用此格式时，默认代表北京时间。
开始时间和结束时间的格式需要保持一致。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束时间点，接口查询支持两种时间格式：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见IOS日期格式说明文档: https://cloud.tencent.com/document/product/266/11732#I
2）yyyy-MM-dd HH:mm:ss：使用此格式时，默认代表北京时间。
开始时间和结束时间的格式需要保持一致。结束时间和开始时间跨度不支持超过24小时，支持距当前时间一个月内的数据查询。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def PlayDomain(self):
        """播放域名，
若不填，则为查询所有播放域名的在线流数据。
        :rtype: str
        """
        return self._PlayDomain

    @PlayDomain.setter
    def PlayDomain(self, PlayDomain):
        self._PlayDomain = PlayDomain

    @property
    def StreamName(self):
        """流名称，精确匹配。
若不填，则为查询总体播放数据。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName

    @property
    def AppName(self):
        """推流路径，与播放地址中的AppName保持一致，会精确匹配，在同时传递了StreamName时生效。
若不填，则为查询总体播放数据。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def ServiceName(self):
        """服务名称，可选值包括LVB(标准直播)，LEB(快直播)，不填则查LVB+LEB总值。
        :rtype: str
        """
        return self._ServiceName

    @ServiceName.setter
    def ServiceName(self, ServiceName):
        self._ServiceName = ServiceName


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._PlayDomain = params.get("PlayDomain")
        self._StreamName = params.get("StreamName")
        self._AppName = params.get("AppName")
        self._ServiceName = params.get("ServiceName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeStreamPlayInfoListResponse(AbstractModel):
    """DescribeStreamPlayInfoList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DataInfoList: 统计信息列表，时间粒度是1分钟。
        :type DataInfoList: list of DayStreamPlayInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DataInfoList = None
        self._RequestId = None

    @property
    def DataInfoList(self):
        """统计信息列表，时间粒度是1分钟。
        :rtype: list of DayStreamPlayInfo
        """
        return self._DataInfoList

    @DataInfoList.setter
    def DataInfoList(self, DataInfoList):
        self._DataInfoList = DataInfoList

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DataInfoList") is not None:
            self._DataInfoList = []
            for item in params.get("DataInfoList"):
                obj = DayStreamPlayInfo()
                obj._deserialize(item)
                self._DataInfoList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeStreamPushInfoListRequest(AbstractModel):
    """DescribeStreamPushInfoList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StreamName: 流名称。
        :type StreamName: str
        :param _StartTime: 起始时间点，
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#:~:text=I-,ISO,-%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F)。
        :type StartTime: str
        :param _EndTime: 结束时间点，
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#:~:text=I-,ISO,-%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F)。
支持查询最近7天数据，建议查询时间跨度在3小时之内。
        :type EndTime: str
        :param _PushDomain: 推流域名。
        :type PushDomain: str
        :param _AppName: 推流路径，与推流和播放地址中的AppName保持一致，默认为 live。
        :type AppName: str
        """
        self._StreamName = None
        self._StartTime = None
        self._EndTime = None
        self._PushDomain = None
        self._AppName = None

    @property
    def StreamName(self):
        """流名称。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName

    @property
    def StartTime(self):
        """起始时间点，
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#:~:text=I-,ISO,-%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F)。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束时间点，
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#:~:text=I-,ISO,-%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F)。
支持查询最近7天数据，建议查询时间跨度在3小时之内。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def PushDomain(self):
        """推流域名。
        :rtype: str
        """
        return self._PushDomain

    @PushDomain.setter
    def PushDomain(self, PushDomain):
        self._PushDomain = PushDomain

    @property
    def AppName(self):
        """推流路径，与推流和播放地址中的AppName保持一致，默认为 live。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName


    def _deserialize(self, params):
        self._StreamName = params.get("StreamName")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._PushDomain = params.get("PushDomain")
        self._AppName = params.get("AppName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeStreamPushInfoListResponse(AbstractModel):
    """DescribeStreamPushInfoList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DataInfoList: 返回的数据列表。
        :type DataInfoList: list of PushQualityData
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DataInfoList = None
        self._RequestId = None

    @property
    def DataInfoList(self):
        """返回的数据列表。
        :rtype: list of PushQualityData
        """
        return self._DataInfoList

    @DataInfoList.setter
    def DataInfoList(self, DataInfoList):
        self._DataInfoList = DataInfoList

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DataInfoList") is not None:
            self._DataInfoList = []
            for item in params.get("DataInfoList"):
                obj = PushQualityData()
                obj._deserialize(item)
                self._DataInfoList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTimeShiftRecordDetailRequest(AbstractModel):
    """DescribeTimeShiftRecordDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Domain: 推流域名。
        :type Domain: str
        :param _AppName: 推流路径。
        :type AppName: str
        :param _StreamName: 流名称。
        :type StreamName: str
        :param _StartTime: 查询范围起始时间，Unix 时间戳。
        :type StartTime: int
        :param _EndTime: 查询范围终止时间，Unix 时间戳。 
        :type EndTime: int
        :param _DomainGroup: 推流域名所属组，没有域名组或者域名组为空字符串可不填。
        :type DomainGroup: str
        :param _TransCodeId: 转码模板ID，转码模板ID为0可不填。
        :type TransCodeId: int
        """
        self._Domain = None
        self._AppName = None
        self._StreamName = None
        self._StartTime = None
        self._EndTime = None
        self._DomainGroup = None
        self._TransCodeId = None

    @property
    def Domain(self):
        """推流域名。
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def AppName(self):
        """推流路径。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def StreamName(self):
        """流名称。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName

    @property
    def StartTime(self):
        """查询范围起始时间，Unix 时间戳。
        :rtype: int
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """查询范围终止时间，Unix 时间戳。 
        :rtype: int
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def DomainGroup(self):
        """推流域名所属组，没有域名组或者域名组为空字符串可不填。
        :rtype: str
        """
        return self._DomainGroup

    @DomainGroup.setter
    def DomainGroup(self, DomainGroup):
        self._DomainGroup = DomainGroup

    @property
    def TransCodeId(self):
        """转码模板ID，转码模板ID为0可不填。
        :rtype: int
        """
        return self._TransCodeId

    @TransCodeId.setter
    def TransCodeId(self, TransCodeId):
        self._TransCodeId = TransCodeId


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._AppName = params.get("AppName")
        self._StreamName = params.get("StreamName")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._DomainGroup = params.get("DomainGroup")
        self._TransCodeId = params.get("TransCodeId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTimeShiftRecordDetailResponse(AbstractModel):
    """DescribeTimeShiftRecordDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RecordList: 时移录制会话数组。
        :type RecordList: list of TimeShiftRecord
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RecordList = None
        self._RequestId = None

    @property
    def RecordList(self):
        """时移录制会话数组。
        :rtype: list of TimeShiftRecord
        """
        return self._RecordList

    @RecordList.setter
    def RecordList(self, RecordList):
        self._RecordList = RecordList

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RecordList") is not None:
            self._RecordList = []
            for item in params.get("RecordList"):
                obj = TimeShiftRecord()
                obj._deserialize(item)
                self._RecordList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTimeShiftStreamListRequest(AbstractModel):
    """DescribeTimeShiftStreamList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 查询范围起始时间，Unix 时间戳。
        :type StartTime: int
        :param _EndTime: 查询范围结束时间，Unix 时间戳。
        :type EndTime: int
        :param _StreamName: 流名称。
        :type StreamName: str
        :param _Domain: 推流域名。
        :type Domain: str
        :param _DomainGroup: 推流域名所属域名组。
        :type DomainGroup: str
        :param _PageSize: 用户指定要返回的最大结果数，取值范围[0,100]，不指定或者指定为0时，API 
默认值为100。指定超过100时，API 强制使用100。指定值为负数时，接口返回错误。
        :type PageSize: int
        :param _PageNum: 指定拉取的页码，不传时默认为1。
        :type PageNum: int
        """
        self._StartTime = None
        self._EndTime = None
        self._StreamName = None
        self._Domain = None
        self._DomainGroup = None
        self._PageSize = None
        self._PageNum = None

    @property
    def StartTime(self):
        """查询范围起始时间，Unix 时间戳。
        :rtype: int
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """查询范围结束时间，Unix 时间戳。
        :rtype: int
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def StreamName(self):
        """流名称。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName

    @property
    def Domain(self):
        """推流域名。
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def DomainGroup(self):
        """推流域名所属域名组。
        :rtype: str
        """
        return self._DomainGroup

    @DomainGroup.setter
    def DomainGroup(self, DomainGroup):
        self._DomainGroup = DomainGroup

    @property
    def PageSize(self):
        """用户指定要返回的最大结果数，取值范围[0,100]，不指定或者指定为0时，API 
默认值为100。指定超过100时，API 强制使用100。指定值为负数时，接口返回错误。
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def PageNum(self):
        """指定拉取的页码，不传时默认为1。
        :rtype: int
        """
        return self._PageNum

    @PageNum.setter
    def PageNum(self, PageNum):
        self._PageNum = PageNum


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._StreamName = params.get("StreamName")
        self._Domain = params.get("Domain")
        self._DomainGroup = params.get("DomainGroup")
        self._PageSize = params.get("PageSize")
        self._PageNum = params.get("PageNum")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTimeShiftStreamListResponse(AbstractModel):
    """DescribeTimeShiftStreamList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalSize: 时间段内所有的数据量。
        :type TotalSize: int
        :param _StreamList: 流列表。
        :type StreamList: list of TimeShiftStreamInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalSize = None
        self._StreamList = None
        self._RequestId = None

    @property
    def TotalSize(self):
        """时间段内所有的数据量。
        :rtype: int
        """
        return self._TotalSize

    @TotalSize.setter
    def TotalSize(self, TotalSize):
        self._TotalSize = TotalSize

    @property
    def StreamList(self):
        """流列表。
        :rtype: list of TimeShiftStreamInfo
        """
        return self._StreamList

    @StreamList.setter
    def StreamList(self, StreamList):
        self._StreamList = StreamList

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalSize = params.get("TotalSize")
        if params.get("StreamList") is not None:
            self._StreamList = []
            for item in params.get("StreamList"):
                obj = TimeShiftStreamInfo()
                obj._deserialize(item)
                self._StreamList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTopClientIpSumInfoListRequest(AbstractModel):
    """DescribeTopClientIpSumInfoList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 起始时间点，
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#:~:text=I-,ISO,-%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F)。
        :type StartTime: str
        :param _EndTime: 结束时间点，
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#:~:text=I-,ISO,-%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F)。
时间跨度在[0,4小时]，支持最近1天数据查询。
        :type EndTime: str
        :param _PlayDomains: 播放域名，默认为不填，表示求总体数据。
        :type PlayDomains: list of str
        :param _PageNum: 页号，范围是[1,1000]，默认值是1。
        :type PageNum: int
        :param _PageSize: 每页个数，范围是[1,1000]，默认值是20。
        :type PageSize: int
        :param _OrderParam: 排序指标，可选值包括TotalRequest（默认值），FailedRequest,TotalFlux。
        :type OrderParam: str
        :param _MainlandOrOversea: 地域，可选值：Mainland，Oversea，China，Foreign，Global（默认值）；如果为空，查询总的数据；如果为“Mainland”，查询中国大陆的数据；如果为“Oversea”，则查询中国大陆以外的数据；如果为China，查询中国的数据（包括港澳台）；如果为Foreign，查询国外的数据（不包括港澳台）。
        :type MainlandOrOversea: str
        :param _OutLanguage: 输出字段使用的语言，可选值：Chinese（默认值），English；目前国家，省份和运营商支持多语言。
        :type OutLanguage: str
        """
        self._StartTime = None
        self._EndTime = None
        self._PlayDomains = None
        self._PageNum = None
        self._PageSize = None
        self._OrderParam = None
        self._MainlandOrOversea = None
        self._OutLanguage = None

    @property
    def StartTime(self):
        """起始时间点，
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#:~:text=I-,ISO,-%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F)。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束时间点，
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#:~:text=I-,ISO,-%E6%97%A5%E6%9C%9F%E6%A0%BC%E5%BC%8F)。
时间跨度在[0,4小时]，支持最近1天数据查询。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def PlayDomains(self):
        """播放域名，默认为不填，表示求总体数据。
        :rtype: list of str
        """
        return self._PlayDomains

    @PlayDomains.setter
    def PlayDomains(self, PlayDomains):
        self._PlayDomains = PlayDomains

    @property
    def PageNum(self):
        """页号，范围是[1,1000]，默认值是1。
        :rtype: int
        """
        return self._PageNum

    @PageNum.setter
    def PageNum(self, PageNum):
        self._PageNum = PageNum

    @property
    def PageSize(self):
        """每页个数，范围是[1,1000]，默认值是20。
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def OrderParam(self):
        """排序指标，可选值包括TotalRequest（默认值），FailedRequest,TotalFlux。
        :rtype: str
        """
        return self._OrderParam

    @OrderParam.setter
    def OrderParam(self, OrderParam):
        self._OrderParam = OrderParam

    @property
    def MainlandOrOversea(self):
        """地域，可选值：Mainland，Oversea，China，Foreign，Global（默认值）；如果为空，查询总的数据；如果为“Mainland”，查询中国大陆的数据；如果为“Oversea”，则查询中国大陆以外的数据；如果为China，查询中国的数据（包括港澳台）；如果为Foreign，查询国外的数据（不包括港澳台）。
        :rtype: str
        """
        return self._MainlandOrOversea

    @MainlandOrOversea.setter
    def MainlandOrOversea(self, MainlandOrOversea):
        self._MainlandOrOversea = MainlandOrOversea

    @property
    def OutLanguage(self):
        """输出字段使用的语言，可选值：Chinese（默认值），English；目前国家，省份和运营商支持多语言。
        :rtype: str
        """
        return self._OutLanguage

    @OutLanguage.setter
    def OutLanguage(self, OutLanguage):
        self._OutLanguage = OutLanguage


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._PlayDomains = params.get("PlayDomains")
        self._PageNum = params.get("PageNum")
        self._PageSize = params.get("PageSize")
        self._OrderParam = params.get("OrderParam")
        self._MainlandOrOversea = params.get("MainlandOrOversea")
        self._OutLanguage = params.get("OutLanguage")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTopClientIpSumInfoListResponse(AbstractModel):
    """DescribeTopClientIpSumInfoList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _PageNum: 页号，范围是[1,1000]，默认值是1。
        :type PageNum: int
        :param _PageSize: 每页个数，范围是[1,1000]，默认值是20。
        :type PageSize: int
        :param _OrderParam: 排序指标，可选值包括”TotalRequest”，”FailedRequest”,“TotalFlux”。
        :type OrderParam: str
        :param _TotalNum: 记录总数。
        :type TotalNum: int
        :param _TotalPage: 记录总页数。
        :type TotalPage: int
        :param _DataInfoList: 数据内容。
        :type DataInfoList: list of ClientIpPlaySumInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._PageNum = None
        self._PageSize = None
        self._OrderParam = None
        self._TotalNum = None
        self._TotalPage = None
        self._DataInfoList = None
        self._RequestId = None

    @property
    def PageNum(self):
        """页号，范围是[1,1000]，默认值是1。
        :rtype: int
        """
        return self._PageNum

    @PageNum.setter
    def PageNum(self, PageNum):
        self._PageNum = PageNum

    @property
    def PageSize(self):
        """每页个数，范围是[1,1000]，默认值是20。
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def OrderParam(self):
        """排序指标，可选值包括”TotalRequest”，”FailedRequest”,“TotalFlux”。
        :rtype: str
        """
        return self._OrderParam

    @OrderParam.setter
    def OrderParam(self, OrderParam):
        self._OrderParam = OrderParam

    @property
    def TotalNum(self):
        """记录总数。
        :rtype: int
        """
        return self._TotalNum

    @TotalNum.setter
    def TotalNum(self, TotalNum):
        self._TotalNum = TotalNum

    @property
    def TotalPage(self):
        """记录总页数。
        :rtype: int
        """
        return self._TotalPage

    @TotalPage.setter
    def TotalPage(self, TotalPage):
        self._TotalPage = TotalPage

    @property
    def DataInfoList(self):
        """数据内容。
        :rtype: list of ClientIpPlaySumInfo
        """
        return self._DataInfoList

    @DataInfoList.setter
    def DataInfoList(self, DataInfoList):
        self._DataInfoList = DataInfoList

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._PageNum = params.get("PageNum")
        self._PageSize = params.get("PageSize")
        self._OrderParam = params.get("OrderParam")
        self._TotalNum = params.get("TotalNum")
        self._TotalPage = params.get("TotalPage")
        if params.get("DataInfoList") is not None:
            self._DataInfoList = []
            for item in params.get("DataInfoList"):
                obj = ClientIpPlaySumInfo()
                obj._deserialize(item)
                self._DataInfoList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTranscodeTaskNumRequest(AbstractModel):
    """DescribeTranscodeTaskNum请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 起始时间，格式：yyyy-mm-dd HH:MM:SS。
        :type StartTime: str
        :param _EndTime: 结束时间，格式：yyyy-mm-dd HH:MM:SS。
        :type EndTime: str
        :param _PushDomains: 推流域名列表，不填表示总体数据。
        :type PushDomains: list of str
        """
        self._StartTime = None
        self._EndTime = None
        self._PushDomains = None

    @property
    def StartTime(self):
        """起始时间，格式：yyyy-mm-dd HH:MM:SS。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束时间，格式：yyyy-mm-dd HH:MM:SS。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def PushDomains(self):
        """推流域名列表，不填表示总体数据。
        :rtype: list of str
        """
        return self._PushDomains

    @PushDomains.setter
    def PushDomains(self, PushDomains):
        self._PushDomains = PushDomains


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._PushDomains = params.get("PushDomains")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTranscodeTaskNumResponse(AbstractModel):
    """DescribeTranscodeTaskNum返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DataInfoList: 任务数列表。
        :type DataInfoList: list of TranscodeTaskNum
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DataInfoList = None
        self._RequestId = None

    @property
    def DataInfoList(self):
        """任务数列表。
        :rtype: list of TranscodeTaskNum
        """
        return self._DataInfoList

    @DataInfoList.setter
    def DataInfoList(self, DataInfoList):
        self._DataInfoList = DataInfoList

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DataInfoList") is not None:
            self._DataInfoList = []
            for item in params.get("DataInfoList"):
                obj = TranscodeTaskNum()
                obj._deserialize(item)
                self._DataInfoList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeUploadStreamNumsRequest(AbstractModel):
    """DescribeUploadStreamNums请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 起始时间点，接口查询支持两种时间格式：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见IOS日期格式说明文档: https://cloud.tencent.com/document/product/266/11732#I
2）YYYY-MM-DD hh:mm:ss：使用此格式时，默认代表北京时间。
        :type StartTime: str
        :param _EndTime: 结束时间点，接口查询支持两种时间格式：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见IOS日期格式说明文档: https://cloud.tencent.com/document/product/266/11732#I
2）YYYY-MM-DD hh:mm:ss：使用此格式时，默认代表北京时间。
起始和结束时间跨度不支持超过31天。支持最近31天的数据查询
        :type EndTime: str
        :param _Domains: 直播域名，若不填，表示总体数据。
        :type Domains: list of str
        :param _Granularity: 数据粒度，支持如下粒度：
5：5分钟粒度，（跨度不支持超过1天），
1440：天粒度（跨度不支持超过一个月）。
默认值：5。
        :type Granularity: int
        """
        self._StartTime = None
        self._EndTime = None
        self._Domains = None
        self._Granularity = None

    @property
    def StartTime(self):
        """起始时间点，接口查询支持两种时间格式：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见IOS日期格式说明文档: https://cloud.tencent.com/document/product/266/11732#I
2）YYYY-MM-DD hh:mm:ss：使用此格式时，默认代表北京时间。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束时间点，接口查询支持两种时间格式：
1）YYYY-MM-DDThh:mm:ssZ：UTC时间格式，详见IOS日期格式说明文档: https://cloud.tencent.com/document/product/266/11732#I
2）YYYY-MM-DD hh:mm:ss：使用此格式时，默认代表北京时间。
起始和结束时间跨度不支持超过31天。支持最近31天的数据查询
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Domains(self):
        """直播域名，若不填，表示总体数据。
        :rtype: list of str
        """
        return self._Domains

    @Domains.setter
    def Domains(self, Domains):
        self._Domains = Domains

    @property
    def Granularity(self):
        """数据粒度，支持如下粒度：
5：5分钟粒度，（跨度不支持超过1天），
1440：天粒度（跨度不支持超过一个月）。
默认值：5。
        :rtype: int
        """
        return self._Granularity

    @Granularity.setter
    def Granularity(self, Granularity):
        self._Granularity = Granularity


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Domains = params.get("Domains")
        self._Granularity = params.get("Granularity")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeUploadStreamNumsResponse(AbstractModel):
    """DescribeUploadStreamNums返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DataInfoList: 明细数据信息
        :type DataInfoList: list of ConcurrentRecordStreamNum
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DataInfoList = None
        self._RequestId = None

    @property
    def DataInfoList(self):
        """明细数据信息
        :rtype: list of ConcurrentRecordStreamNum
        """
        return self._DataInfoList

    @DataInfoList.setter
    def DataInfoList(self, DataInfoList):
        self._DataInfoList = DataInfoList

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DataInfoList") is not None:
            self._DataInfoList = []
            for item in params.get("DataInfoList"):
                obj = ConcurrentRecordStreamNum()
                obj._deserialize(item)
                self._DataInfoList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeVisitTopSumInfoListRequest(AbstractModel):
    """DescribeVisitTopSumInfoList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StartTime: 起始时间点，格式为yyyy-mm-dd HH:MM:SS。
        :type StartTime: str
        :param _EndTime: 结束时间点，格式为yyyy-mm-dd HH:MM:SS
时间跨度在(0,4小时]，支持最近1天数据查询。
        :type EndTime: str
        :param _TopIndex: 峰值指标，可选值包括”Domain”，”StreamId”。
        :type TopIndex: str
        :param _PlayDomains: 播放域名，默认为不填，表示求总体数据。
        :type PlayDomains: list of str
        :param _PageNum: 页号，
范围是[1,1000]，
默认值是1。
        :type PageNum: int
        :param _PageSize: 每页个数，范围是[1,1000]，
默认值是20。
        :type PageSize: int
        :param _OrderParam: 排序指标，可选值包括” AvgFluxPerSecond”，”TotalRequest”（默认）,“TotalFlux”。
        :type OrderParam: str
        """
        self._StartTime = None
        self._EndTime = None
        self._TopIndex = None
        self._PlayDomains = None
        self._PageNum = None
        self._PageSize = None
        self._OrderParam = None

    @property
    def StartTime(self):
        """起始时间点，格式为yyyy-mm-dd HH:MM:SS。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束时间点，格式为yyyy-mm-dd HH:MM:SS
时间跨度在(0,4小时]，支持最近1天数据查询。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def TopIndex(self):
        """峰值指标，可选值包括”Domain”，”StreamId”。
        :rtype: str
        """
        return self._TopIndex

    @TopIndex.setter
    def TopIndex(self, TopIndex):
        self._TopIndex = TopIndex

    @property
    def PlayDomains(self):
        """播放域名，默认为不填，表示求总体数据。
        :rtype: list of str
        """
        return self._PlayDomains

    @PlayDomains.setter
    def PlayDomains(self, PlayDomains):
        self._PlayDomains = PlayDomains

    @property
    def PageNum(self):
        """页号，
范围是[1,1000]，
默认值是1。
        :rtype: int
        """
        return self._PageNum

    @PageNum.setter
    def PageNum(self, PageNum):
        self._PageNum = PageNum

    @property
    def PageSize(self):
        """每页个数，范围是[1,1000]，
默认值是20。
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def OrderParam(self):
        """排序指标，可选值包括” AvgFluxPerSecond”，”TotalRequest”（默认）,“TotalFlux”。
        :rtype: str
        """
        return self._OrderParam

    @OrderParam.setter
    def OrderParam(self, OrderParam):
        self._OrderParam = OrderParam


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._TopIndex = params.get("TopIndex")
        self._PlayDomains = params.get("PlayDomains")
        self._PageNum = params.get("PageNum")
        self._PageSize = params.get("PageSize")
        self._OrderParam = params.get("OrderParam")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVisitTopSumInfoListResponse(AbstractModel):
    """DescribeVisitTopSumInfoList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _PageNum: 页号，
范围是[1,1000]，
默认值是1。
        :type PageNum: int
        :param _PageSize: 每页个数，范围是[1,1000]，
默认值是20。
        :type PageSize: int
        :param _TopIndex: 峰值指标，可选值包括”Domain”，”StreamId”。
        :type TopIndex: str
        :param _OrderParam: 排序指标，可选值包括” AvgFluxPerSecond”(按每秒平均流量排序)，”TotalRequest”（默认，按总请求数排序）,“TotalFlux”（按总流量排序）。
        :type OrderParam: str
        :param _TotalNum: 记录总数。
        :type TotalNum: int
        :param _TotalPage: 记录总页数。
        :type TotalPage: int
        :param _DataInfoList: 数据内容。
        :type DataInfoList: list of PlaySumStatInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._PageNum = None
        self._PageSize = None
        self._TopIndex = None
        self._OrderParam = None
        self._TotalNum = None
        self._TotalPage = None
        self._DataInfoList = None
        self._RequestId = None

    @property
    def PageNum(self):
        """页号，
范围是[1,1000]，
默认值是1。
        :rtype: int
        """
        return self._PageNum

    @PageNum.setter
    def PageNum(self, PageNum):
        self._PageNum = PageNum

    @property
    def PageSize(self):
        """每页个数，范围是[1,1000]，
默认值是20。
        :rtype: int
        """
        return self._PageSize

    @PageSize.setter
    def PageSize(self, PageSize):
        self._PageSize = PageSize

    @property
    def TopIndex(self):
        """峰值指标，可选值包括”Domain”，”StreamId”。
        :rtype: str
        """
        return self._TopIndex

    @TopIndex.setter
    def TopIndex(self, TopIndex):
        self._TopIndex = TopIndex

    @property
    def OrderParam(self):
        """排序指标，可选值包括” AvgFluxPerSecond”(按每秒平均流量排序)，”TotalRequest”（默认，按总请求数排序）,“TotalFlux”（按总流量排序）。
        :rtype: str
        """
        return self._OrderParam

    @OrderParam.setter
    def OrderParam(self, OrderParam):
        self._OrderParam = OrderParam

    @property
    def TotalNum(self):
        """记录总数。
        :rtype: int
        """
        return self._TotalNum

    @TotalNum.setter
    def TotalNum(self, TotalNum):
        self._TotalNum = TotalNum

    @property
    def TotalPage(self):
        """记录总页数。
        :rtype: int
        """
        return self._TotalPage

    @TotalPage.setter
    def TotalPage(self, TotalPage):
        self._TotalPage = TotalPage

    @property
    def DataInfoList(self):
        """数据内容。
        :rtype: list of PlaySumStatInfo
        """
        return self._DataInfoList

    @DataInfoList.setter
    def DataInfoList(self, DataInfoList):
        self._DataInfoList = DataInfoList

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._PageNum = params.get("PageNum")
        self._PageSize = params.get("PageSize")
        self._TopIndex = params.get("TopIndex")
        self._OrderParam = params.get("OrderParam")
        self._TotalNum = params.get("TotalNum")
        self._TotalPage = params.get("TotalPage")
        if params.get("DataInfoList") is not None:
            self._DataInfoList = []
            for item in params.get("DataInfoList"):
                obj = PlaySumStatInfo()
                obj._deserialize(item)
                self._DataInfoList.append(obj)
        self._RequestId = params.get("RequestId")


class DiagnoseResult(AbstractModel):
    """媒体诊断结果，包含断流信息、低帧率信息等

    """

    def __init__(self):
        r"""
        :param _StreamBrokenResults: 断流信息
        :type StreamBrokenResults: list of str
        :param _LowFrameRateResults: 低帧率信息
        :type LowFrameRateResults: list of str
        :param _StreamFormatResults: 流格式诊断信息
        :type StreamFormatResults: list of str
        """
        self._StreamBrokenResults = None
        self._LowFrameRateResults = None
        self._StreamFormatResults = None

    @property
    def StreamBrokenResults(self):
        """断流信息
        :rtype: list of str
        """
        return self._StreamBrokenResults

    @StreamBrokenResults.setter
    def StreamBrokenResults(self, StreamBrokenResults):
        self._StreamBrokenResults = StreamBrokenResults

    @property
    def LowFrameRateResults(self):
        """低帧率信息
        :rtype: list of str
        """
        return self._LowFrameRateResults

    @LowFrameRateResults.setter
    def LowFrameRateResults(self, LowFrameRateResults):
        self._LowFrameRateResults = LowFrameRateResults

    @property
    def StreamFormatResults(self):
        """流格式诊断信息
        :rtype: list of str
        """
        return self._StreamFormatResults

    @StreamFormatResults.setter
    def StreamFormatResults(self, StreamFormatResults):
        self._StreamFormatResults = StreamFormatResults


    def _deserialize(self, params):
        self._StreamBrokenResults = params.get("StreamBrokenResults")
        self._LowFrameRateResults = params.get("LowFrameRateResults")
        self._StreamFormatResults = params.get("StreamFormatResults")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DomainCertInfo(AbstractModel):
    """域名证书信息

    """

    def __init__(self):
        r"""
        :param _CertId: 证书Id。
        :type CertId: int
        :param _CertName: 证书名称。
        :type CertName: str
        :param _Description: 描述信息。
        :type Description: str
        :param _CreateTime: 创建时间，UTC格式。
注：此字段为北京时间（UTC+8时区）。
        :type CreateTime: str
        :param _HttpsCrt: 证书内容。
        :type HttpsCrt: str
        :param _CertType: 证书类型。
0：用户添加证书，
1：腾讯云托管证书。
        :type CertType: int
        :param _CertExpireTime: 证书过期时间，UTC格式。
注：此字段为北京时间（UTC+8时区）。
        :type CertExpireTime: str
        :param _DomainName: 使用此证书的域名名称。
        :type DomainName: str
        :param _Status: 证书状态。
        :type Status: int
        :param _CertDomains: 证书本身标识的域名列表。
比如: ["*.x.com"]
        :type CertDomains: list of str
        :param _CloudCertId: 腾讯云ssl的证书Id
        :type CloudCertId: str
        """
        self._CertId = None
        self._CertName = None
        self._Description = None
        self._CreateTime = None
        self._HttpsCrt = None
        self._CertType = None
        self._CertExpireTime = None
        self._DomainName = None
        self._Status = None
        self._CertDomains = None
        self._CloudCertId = None

    @property
    def CertId(self):
        """证书Id。
        :rtype: int
        """
        return self._CertId

    @CertId.setter
    def CertId(self, CertId):
        self._CertId = CertId

    @property
    def CertName(self):
        """证书名称。
        :rtype: str
        """
        return self._CertName

    @CertName.setter
    def CertName(self, CertName):
        self._CertName = CertName

    @property
    def Description(self):
        """描述信息。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def CreateTime(self):
        """创建时间，UTC格式。
注：此字段为北京时间（UTC+8时区）。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def HttpsCrt(self):
        """证书内容。
        :rtype: str
        """
        return self._HttpsCrt

    @HttpsCrt.setter
    def HttpsCrt(self, HttpsCrt):
        self._HttpsCrt = HttpsCrt

    @property
    def CertType(self):
        """证书类型。
0：用户添加证书，
1：腾讯云托管证书。
        :rtype: int
        """
        return self._CertType

    @CertType.setter
    def CertType(self, CertType):
        self._CertType = CertType

    @property
    def CertExpireTime(self):
        """证书过期时间，UTC格式。
注：此字段为北京时间（UTC+8时区）。
        :rtype: str
        """
        return self._CertExpireTime

    @CertExpireTime.setter
    def CertExpireTime(self, CertExpireTime):
        self._CertExpireTime = CertExpireTime

    @property
    def DomainName(self):
        """使用此证书的域名名称。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def Status(self):
        """证书状态。
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def CertDomains(self):
        """证书本身标识的域名列表。
比如: ["*.x.com"]
        :rtype: list of str
        """
        return self._CertDomains

    @CertDomains.setter
    def CertDomains(self, CertDomains):
        self._CertDomains = CertDomains

    @property
    def CloudCertId(self):
        """腾讯云ssl的证书Id
        :rtype: str
        """
        return self._CloudCertId

    @CloudCertId.setter
    def CloudCertId(self, CloudCertId):
        self._CloudCertId = CloudCertId


    def _deserialize(self, params):
        self._CertId = params.get("CertId")
        self._CertName = params.get("CertName")
        self._Description = params.get("Description")
        self._CreateTime = params.get("CreateTime")
        self._HttpsCrt = params.get("HttpsCrt")
        self._CertType = params.get("CertType")
        self._CertExpireTime = params.get("CertExpireTime")
        self._DomainName = params.get("DomainName")
        self._Status = params.get("Status")
        self._CertDomains = params.get("CertDomains")
        self._CloudCertId = params.get("CloudCertId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DomainDetailInfo(AbstractModel):
    """每个域名的统计信息。

    """

    def __init__(self):
        r"""
        :param _MainlandOrOversea: 国内还是国外:
Mainland: 表示国内数据。
Oversea: 表示国外数据。
        :type MainlandOrOversea: str
        :param _Bandwidth: 带宽，单位: Mbps。
        :type Bandwidth: float
        :param _Flux: 流量，单位: MB。
        :type Flux: float
        :param _Online: 人数。
        :type Online: int
        :param _Request: 请求数。
        :type Request: int
        """
        self._MainlandOrOversea = None
        self._Bandwidth = None
        self._Flux = None
        self._Online = None
        self._Request = None

    @property
    def MainlandOrOversea(self):
        """国内还是国外:
Mainland: 表示国内数据。
Oversea: 表示国外数据。
        :rtype: str
        """
        return self._MainlandOrOversea

    @MainlandOrOversea.setter
    def MainlandOrOversea(self, MainlandOrOversea):
        self._MainlandOrOversea = MainlandOrOversea

    @property
    def Bandwidth(self):
        """带宽，单位: Mbps。
        :rtype: float
        """
        return self._Bandwidth

    @Bandwidth.setter
    def Bandwidth(self, Bandwidth):
        self._Bandwidth = Bandwidth

    @property
    def Flux(self):
        """流量，单位: MB。
        :rtype: float
        """
        return self._Flux

    @Flux.setter
    def Flux(self, Flux):
        self._Flux = Flux

    @property
    def Online(self):
        """人数。
        :rtype: int
        """
        return self._Online

    @Online.setter
    def Online(self, Online):
        self._Online = Online

    @property
    def Request(self):
        """请求数。
        :rtype: int
        """
        return self._Request

    @Request.setter
    def Request(self, Request):
        self._Request = Request


    def _deserialize(self, params):
        self._MainlandOrOversea = params.get("MainlandOrOversea")
        self._Bandwidth = params.get("Bandwidth")
        self._Flux = params.get("Flux")
        self._Online = params.get("Online")
        self._Request = params.get("Request")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DomainInfo(AbstractModel):
    """直播域名信息

    """

    def __init__(self):
        r"""
        :param _Name: 直播域名。
        :type Name: str
        :param _Type: 域名类型:
0: 推流。
1: 播放。
        :type Type: int
        :param _Status: 域名状态:
0: 停用。
1: 启用。
        :type Status: int
        :param _CreateTime: 添加时间。
注：此字段为北京时间（UTC+8时区）。
        :type CreateTime: str
        :param _BCName: 是否有 CName 到固定规则域名:
0: 否。
1: 是。
        :type BCName: int
        :param _TargetDomain: cname 对应的域名。
        :type TargetDomain: str
        :param _PlayType: 播放区域，只在 Type=1 时该参数有意义。
1: 国内。
2: 全球。
3: 海外。
        :type PlayType: int
        :param _IsDelayLive: 是否慢直播:
0: 普通直播。
1: 慢直播。
        :type IsDelayLive: int
        :param _CurrentCName: 当前客户使用的 cname 信息。
        :type CurrentCName: str
        :param _RentTag: 失效参数，可忽略。
        :type RentTag: int
        :param _RentExpireTime: 失效参数，可忽略。
注：此字段为北京时间（UTC+8时区）。
        :type RentExpireTime: str
        :param _IsMiniProgramLive: 0: 标准直播。
1: 小程序直播。
        :type IsMiniProgramLive: int
        """
        self._Name = None
        self._Type = None
        self._Status = None
        self._CreateTime = None
        self._BCName = None
        self._TargetDomain = None
        self._PlayType = None
        self._IsDelayLive = None
        self._CurrentCName = None
        self._RentTag = None
        self._RentExpireTime = None
        self._IsMiniProgramLive = None

    @property
    def Name(self):
        """直播域名。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Type(self):
        """域名类型:
0: 推流。
1: 播放。
        :rtype: int
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Status(self):
        """域名状态:
0: 停用。
1: 启用。
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def CreateTime(self):
        """添加时间。
注：此字段为北京时间（UTC+8时区）。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def BCName(self):
        """是否有 CName 到固定规则域名:
0: 否。
1: 是。
        :rtype: int
        """
        return self._BCName

    @BCName.setter
    def BCName(self, BCName):
        self._BCName = BCName

    @property
    def TargetDomain(self):
        """cname 对应的域名。
        :rtype: str
        """
        return self._TargetDomain

    @TargetDomain.setter
    def TargetDomain(self, TargetDomain):
        self._TargetDomain = TargetDomain

    @property
    def PlayType(self):
        """播放区域，只在 Type=1 时该参数有意义。
1: 国内。
2: 全球。
3: 海外。
        :rtype: int
        """
        return self._PlayType

    @PlayType.setter
    def PlayType(self, PlayType):
        self._PlayType = PlayType

    @property
    def IsDelayLive(self):
        """是否慢直播:
0: 普通直播。
1: 慢直播。
        :rtype: int
        """
        return self._IsDelayLive

    @IsDelayLive.setter
    def IsDelayLive(self, IsDelayLive):
        self._IsDelayLive = IsDelayLive

    @property
    def CurrentCName(self):
        """当前客户使用的 cname 信息。
        :rtype: str
        """
        return self._CurrentCName

    @CurrentCName.setter
    def CurrentCName(self, CurrentCName):
        self._CurrentCName = CurrentCName

    @property
    def RentTag(self):
        """失效参数，可忽略。
        :rtype: int
        """
        return self._RentTag

    @RentTag.setter
    def RentTag(self, RentTag):
        self._RentTag = RentTag

    @property
    def RentExpireTime(self):
        """失效参数，可忽略。
注：此字段为北京时间（UTC+8时区）。
        :rtype: str
        """
        return self._RentExpireTime

    @RentExpireTime.setter
    def RentExpireTime(self, RentExpireTime):
        self._RentExpireTime = RentExpireTime

    @property
    def IsMiniProgramLive(self):
        """0: 标准直播。
1: 小程序直播。
        :rtype: int
        """
        return self._IsMiniProgramLive

    @IsMiniProgramLive.setter
    def IsMiniProgramLive(self, IsMiniProgramLive):
        self._IsMiniProgramLive = IsMiniProgramLive


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Type = params.get("Type")
        self._Status = params.get("Status")
        self._CreateTime = params.get("CreateTime")
        self._BCName = params.get("BCName")
        self._TargetDomain = params.get("TargetDomain")
        self._PlayType = params.get("PlayType")
        self._IsDelayLive = params.get("IsDelayLive")
        self._CurrentCName = params.get("CurrentCName")
        self._RentTag = params.get("RentTag")
        self._RentExpireTime = params.get("RentExpireTime")
        self._IsMiniProgramLive = params.get("IsMiniProgramLive")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DomainInfoList(AbstractModel):
    """多个域名信息列表

    """

    def __init__(self):
        r"""
        :param _Domain: 域名。
        :type Domain: str
        :param _DetailInfoList: 明细信息。
        :type DetailInfoList: list of DomainDetailInfo
        """
        self._Domain = None
        self._DetailInfoList = None

    @property
    def Domain(self):
        """域名。
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def DetailInfoList(self):
        """明细信息。
        :rtype: list of DomainDetailInfo
        """
        return self._DetailInfoList

    @DetailInfoList.setter
    def DetailInfoList(self, DetailInfoList):
        self._DetailInfoList = DetailInfoList


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        if params.get("DetailInfoList") is not None:
            self._DetailInfoList = []
            for item in params.get("DetailInfoList"):
                obj = DomainDetailInfo()
                obj._deserialize(item)
                self._DetailInfoList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DropLiveStreamRequest(AbstractModel):
    """DropLiveStream请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StreamName: 流名称。
        :type StreamName: str
        :param _DomainName: 您的推流域名。
        :type DomainName: str
        :param _AppName: 推流路径，与推流和播放地址中的AppName保持一致，默认为 live。
        :type AppName: str
        """
        self._StreamName = None
        self._DomainName = None
        self._AppName = None

    @property
    def StreamName(self):
        """流名称。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName

    @property
    def DomainName(self):
        """您的推流域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def AppName(self):
        """推流路径，与推流和播放地址中的AppName保持一致，默认为 live。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName


    def _deserialize(self, params):
        self._StreamName = params.get("StreamName")
        self._DomainName = params.get("DomainName")
        self._AppName = params.get("AppName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DropLiveStreamResponse(AbstractModel):
    """DropLiveStream返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class EnableLiveDomainRequest(AbstractModel):
    """EnableLiveDomain请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DomainName: 待启用的直播域名。
        :type DomainName: str
        """
        self._DomainName = None

    @property
    def DomainName(self):
        """待启用的直播域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName


    def _deserialize(self, params):
        self._DomainName = params.get("DomainName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EnableLiveDomainResponse(AbstractModel):
    """EnableLiveDomain返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class EnableOptimalSwitchingRequest(AbstractModel):
    """EnableOptimalSwitching请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StreamName: 针对该流 ID 启用择优调度。
        :type StreamName: str
        :param _EnableSwitch: 启用开关，默认为启用。
0 - 禁用。
1 - 启用。
        :type EnableSwitch: int
        :param _HostGroupName: 要启用自动择优的流所属的域名分组名称。
        :type HostGroupName: str
        """
        self._StreamName = None
        self._EnableSwitch = None
        self._HostGroupName = None

    @property
    def StreamName(self):
        """针对该流 ID 启用择优调度。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName

    @property
    def EnableSwitch(self):
        """启用开关，默认为启用。
0 - 禁用。
1 - 启用。
        :rtype: int
        """
        return self._EnableSwitch

    @EnableSwitch.setter
    def EnableSwitch(self, EnableSwitch):
        self._EnableSwitch = EnableSwitch

    @property
    def HostGroupName(self):
        """要启用自动择优的流所属的域名分组名称。
        :rtype: str
        """
        return self._HostGroupName

    @HostGroupName.setter
    def HostGroupName(self, HostGroupName):
        self._HostGroupName = HostGroupName


    def _deserialize(self, params):
        self._StreamName = params.get("StreamName")
        self._EnableSwitch = params.get("EnableSwitch")
        self._HostGroupName = params.get("HostGroupName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EnableOptimalSwitchingResponse(AbstractModel):
    """EnableOptimalSwitching返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class FlvSpecialParam(AbstractModel):
    """flv格式特殊配置

    """

    def __init__(self):
        r"""
        :param _UploadInRecording: 是否开启边录边传，仅flv格式有效。
        :type UploadInRecording: bool
        """
        self._UploadInRecording = None

    @property
    def UploadInRecording(self):
        """是否开启边录边传，仅flv格式有效。
        :rtype: bool
        """
        return self._UploadInRecording

    @UploadInRecording.setter
    def UploadInRecording(self, UploadInRecording):
        self._UploadInRecording = UploadInRecording


    def _deserialize(self, params):
        self._UploadInRecording = params.get("UploadInRecording")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ForbidLiveDomainRequest(AbstractModel):
    """ForbidLiveDomain请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DomainName: 待停用的直播域名。
        :type DomainName: str
        """
        self._DomainName = None

    @property
    def DomainName(self):
        """待停用的直播域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName


    def _deserialize(self, params):
        self._DomainName = params.get("DomainName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ForbidLiveDomainResponse(AbstractModel):
    """ForbidLiveDomain返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ForbidLiveStreamRequest(AbstractModel):
    """ForbidLiveStream请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AppName: 推流路径，与推流和播放地址中的AppName保持一致，默认为 live。
        :type AppName: str
        :param _DomainName: 您的推流域名。
        :type DomainName: str
        :param _StreamName: 流名称。
        :type StreamName: str
        :param _ResumeTime: 恢复流的时间。UTC 格式，例如：2018-11-29T19:00:00Z。
注意：
1. 默认禁推7天，且最长支持禁推90天。
2. 北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#I)。
        :type ResumeTime: str
        :param _Reason: 禁推原因。
注明：请务必填写禁推原因，防止误操作。
长度限制：2048字节。
        :type Reason: str
        """
        self._AppName = None
        self._DomainName = None
        self._StreamName = None
        self._ResumeTime = None
        self._Reason = None

    @property
    def AppName(self):
        """推流路径，与推流和播放地址中的AppName保持一致，默认为 live。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def DomainName(self):
        """您的推流域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def StreamName(self):
        """流名称。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName

    @property
    def ResumeTime(self):
        """恢复流的时间。UTC 格式，例如：2018-11-29T19:00:00Z。
注意：
1. 默认禁推7天，且最长支持禁推90天。
2. 北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#I)。
        :rtype: str
        """
        return self._ResumeTime

    @ResumeTime.setter
    def ResumeTime(self, ResumeTime):
        self._ResumeTime = ResumeTime

    @property
    def Reason(self):
        """禁推原因。
注明：请务必填写禁推原因，防止误操作。
长度限制：2048字节。
        :rtype: str
        """
        return self._Reason

    @Reason.setter
    def Reason(self, Reason):
        self._Reason = Reason


    def _deserialize(self, params):
        self._AppName = params.get("AppName")
        self._DomainName = params.get("DomainName")
        self._StreamName = params.get("StreamName")
        self._ResumeTime = params.get("ResumeTime")
        self._Reason = params.get("Reason")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ForbidLiveStreamResponse(AbstractModel):
    """ForbidLiveStream返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ForbidStreamInfo(AbstractModel):
    """禁推流列表

    """

    def __init__(self):
        r"""
        :param _StreamName: 流名称。
        :type StreamName: str
        :param _CreateTime: 创建时间。
注：此字段为北京时间（UTC+8时区）。
        :type CreateTime: str
        :param _ExpireTime: 禁推过期时间。
注：此字段为北京时间（UTC+8时区）。
        :type ExpireTime: str
        :param _AppName: 推流路径。
注意：此字段可能返回 null，表示取不到有效值。
        :type AppName: str
        :param _DomainName: 推流域名。
注意：此字段可能返回 null，表示取不到有效值。
        :type DomainName: str
        """
        self._StreamName = None
        self._CreateTime = None
        self._ExpireTime = None
        self._AppName = None
        self._DomainName = None

    @property
    def StreamName(self):
        """流名称。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName

    @property
    def CreateTime(self):
        """创建时间。
注：此字段为北京时间（UTC+8时区）。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ExpireTime(self):
        """禁推过期时间。
注：此字段为北京时间（UTC+8时区）。
        :rtype: str
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def AppName(self):
        """推流路径。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def DomainName(self):
        """推流域名。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName


    def _deserialize(self, params):
        self._StreamName = params.get("StreamName")
        self._CreateTime = params.get("CreateTime")
        self._ExpireTime = params.get("ExpireTime")
        self._AppName = params.get("AppName")
        self._DomainName = params.get("DomainName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GroupProIspDataInfo(AbstractModel):
    """某省份某运营商在某段时间内的带宽，流量，请求数和并发数

    """

    def __init__(self):
        r"""
        :param _ProvinceName: 省份。
        :type ProvinceName: str
        :param _IspName: 运营商。
        :type IspName: str
        :param _DetailInfoList: 分钟维度的明细数据。
        :type DetailInfoList: list of CdnPlayStatData
        """
        self._ProvinceName = None
        self._IspName = None
        self._DetailInfoList = None

    @property
    def ProvinceName(self):
        """省份。
        :rtype: str
        """
        return self._ProvinceName

    @ProvinceName.setter
    def ProvinceName(self, ProvinceName):
        self._ProvinceName = ProvinceName

    @property
    def IspName(self):
        """运营商。
        :rtype: str
        """
        return self._IspName

    @IspName.setter
    def IspName(self, IspName):
        self._IspName = IspName

    @property
    def DetailInfoList(self):
        """分钟维度的明细数据。
        :rtype: list of CdnPlayStatData
        """
        return self._DetailInfoList

    @DetailInfoList.setter
    def DetailInfoList(self, DetailInfoList):
        self._DetailInfoList = DetailInfoList


    def _deserialize(self, params):
        self._ProvinceName = params.get("ProvinceName")
        self._IspName = params.get("IspName")
        if params.get("DetailInfoList") is not None:
            self._DetailInfoList = []
            for item in params.get("DetailInfoList"):
                obj = CdnPlayStatData()
                obj._deserialize(item)
                self._DetailInfoList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class HlsSpecialParam(AbstractModel):
    """HLS专属录制参数

    """

    def __init__(self):
        r"""
        :param _FlowContinueDuration: HLS续流超时时间。
取值范围[0，1800]。
注意：此字段可能返回 null，表示取不到有效值。
        :type FlowContinueDuration: int
        """
        self._FlowContinueDuration = None

    @property
    def FlowContinueDuration(self):
        """HLS续流超时时间。
取值范围[0，1800]。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._FlowContinueDuration

    @FlowContinueDuration.setter
    def FlowContinueDuration(self, FlowContinueDuration):
        self._FlowContinueDuration = FlowContinueDuration


    def _deserialize(self, params):
        self._FlowContinueDuration = params.get("FlowContinueDuration")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class HttpCodeInfo(AbstractModel):
    """HTTP返回码和统计数据

    """

    def __init__(self):
        r"""
        :param _HttpCode: HTTP协议返回码。
例："2xx", "3xx", "4xx", "5xx"。
        :type HttpCode: str
        :param _ValueList: 统计信息，对于无数据的时间点，会补0。
        :type ValueList: list of HttpCodeValue
        """
        self._HttpCode = None
        self._ValueList = None

    @property
    def HttpCode(self):
        """HTTP协议返回码。
例："2xx", "3xx", "4xx", "5xx"。
        :rtype: str
        """
        return self._HttpCode

    @HttpCode.setter
    def HttpCode(self, HttpCode):
        self._HttpCode = HttpCode

    @property
    def ValueList(self):
        """统计信息，对于无数据的时间点，会补0。
        :rtype: list of HttpCodeValue
        """
        return self._ValueList

    @ValueList.setter
    def ValueList(self, ValueList):
        self._ValueList = ValueList


    def _deserialize(self, params):
        self._HttpCode = params.get("HttpCode")
        if params.get("ValueList") is not None:
            self._ValueList = []
            for item in params.get("ValueList"):
                obj = HttpCodeValue()
                obj._deserialize(item)
                self._ValueList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class HttpCodeValue(AbstractModel):
    """HTTP返回码数据信息

    """

    def __init__(self):
        r"""
        :param _Time: 时间，
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :type Time: str
        :param _Numbers: 次数。
        :type Numbers: int
        :param _Percentage: 占比。
        :type Percentage: float
        """
        self._Time = None
        self._Numbers = None
        self._Percentage = None

    @property
    def Time(self):
        """时间，
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._Time

    @Time.setter
    def Time(self, Time):
        self._Time = Time

    @property
    def Numbers(self):
        """次数。
        :rtype: int
        """
        return self._Numbers

    @Numbers.setter
    def Numbers(self, Numbers):
        self._Numbers = Numbers

    @property
    def Percentage(self):
        """占比。
        :rtype: float
        """
        return self._Percentage

    @Percentage.setter
    def Percentage(self, Percentage):
        self._Percentage = Percentage


    def _deserialize(self, params):
        self._Time = params.get("Time")
        self._Numbers = params.get("Numbers")
        self._Percentage = params.get("Percentage")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class HttpStatusData(AbstractModel):
    """播放错误码信息

    """

    def __init__(self):
        r"""
        :param _Time: 数据时间点，
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :type Time: str
        :param _HttpStatusInfoList: 播放状态码详细信息。
        :type HttpStatusInfoList: list of HttpStatusInfo
        """
        self._Time = None
        self._HttpStatusInfoList = None

    @property
    def Time(self):
        """数据时间点，
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._Time

    @Time.setter
    def Time(self, Time):
        self._Time = Time

    @property
    def HttpStatusInfoList(self):
        """播放状态码详细信息。
        :rtype: list of HttpStatusInfo
        """
        return self._HttpStatusInfoList

    @HttpStatusInfoList.setter
    def HttpStatusInfoList(self, HttpStatusInfoList):
        self._HttpStatusInfoList = HttpStatusInfoList


    def _deserialize(self, params):
        self._Time = params.get("Time")
        if params.get("HttpStatusInfoList") is not None:
            self._HttpStatusInfoList = []
            for item in params.get("HttpStatusInfoList"):
                obj = HttpStatusInfo()
                obj._deserialize(item)
                self._HttpStatusInfoList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class HttpStatusInfo(AbstractModel):
    """播放错误码信息

    """

    def __init__(self):
        r"""
        :param _HttpStatus: 播放HTTP状态码。
        :type HttpStatus: str
        :param _Num: 个数。
        :type Num: int
        """
        self._HttpStatus = None
        self._Num = None

    @property
    def HttpStatus(self):
        """播放HTTP状态码。
        :rtype: str
        """
        return self._HttpStatus

    @HttpStatus.setter
    def HttpStatus(self, HttpStatus):
        self._HttpStatus = HttpStatus

    @property
    def Num(self):
        """个数。
        :rtype: int
        """
        return self._Num

    @Num.setter
    def Num(self, Num):
        self._Num = Num


    def _deserialize(self, params):
        self._HttpStatus = params.get("HttpStatus")
        self._Num = params.get("Num")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveCertDomainInfo(AbstractModel):
    """用作批量绑定域名和证书。

    """

    def __init__(self):
        r"""
        :param _DomainName: 域名。
        :type DomainName: str
        :param _Status: 是否启用域名的https规则。
1：启用
0：禁用
-1：保持不变
        :type Status: int
        """
        self._DomainName = None
        self._Status = None

    @property
    def DomainName(self):
        """域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def Status(self):
        """是否启用域名的https规则。
1：启用
0：禁用
-1：保持不变
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._DomainName = params.get("DomainName")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveDomainCertBindings(AbstractModel):
    """DescribeLiveDomainCertBindings, DescribeLiveDomainCertBindingsGray接口返回的域名证书信息

    """

    def __init__(self):
        r"""
        :param _DomainName: 域名。
        :type DomainName: str
        :param _CertificateAlias: 证书备注。与CertName同义。
        :type CertificateAlias: str
        :param _CertType: 证书类型。
0：自有证书
1：腾讯云ssl托管证书
        :type CertType: int
        :param _Status: https状态。
1：已开启。
0：已关闭。
        :type Status: int
        :param _CertExpireTime: 证书过期时间。
注：此字段为北京时间（UTC+8时区）。
        :type CertExpireTime: str
        :param _CertId: 证书Id。
        :type CertId: int
        :param _CloudCertId: 腾讯云ssl的证书Id。
        :type CloudCertId: str
        :param _UpdateTime: 规则最后更新时间。
注：此字段为北京时间（UTC+8时区）。
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: str
        """
        self._DomainName = None
        self._CertificateAlias = None
        self._CertType = None
        self._Status = None
        self._CertExpireTime = None
        self._CertId = None
        self._CloudCertId = None
        self._UpdateTime = None

    @property
    def DomainName(self):
        """域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def CertificateAlias(self):
        """证书备注。与CertName同义。
        :rtype: str
        """
        return self._CertificateAlias

    @CertificateAlias.setter
    def CertificateAlias(self, CertificateAlias):
        self._CertificateAlias = CertificateAlias

    @property
    def CertType(self):
        """证书类型。
0：自有证书
1：腾讯云ssl托管证书
        :rtype: int
        """
        return self._CertType

    @CertType.setter
    def CertType(self, CertType):
        self._CertType = CertType

    @property
    def Status(self):
        """https状态。
1：已开启。
0：已关闭。
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def CertExpireTime(self):
        """证书过期时间。
注：此字段为北京时间（UTC+8时区）。
        :rtype: str
        """
        return self._CertExpireTime

    @CertExpireTime.setter
    def CertExpireTime(self, CertExpireTime):
        self._CertExpireTime = CertExpireTime

    @property
    def CertId(self):
        """证书Id。
        :rtype: int
        """
        return self._CertId

    @CertId.setter
    def CertId(self, CertId):
        self._CertId = CertId

    @property
    def CloudCertId(self):
        """腾讯云ssl的证书Id。
        :rtype: str
        """
        return self._CloudCertId

    @CloudCertId.setter
    def CloudCertId(self, CloudCertId):
        self._CloudCertId = CloudCertId

    @property
    def UpdateTime(self):
        """规则最后更新时间。
注：此字段为北京时间（UTC+8时区）。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._DomainName = params.get("DomainName")
        self._CertificateAlias = params.get("CertificateAlias")
        self._CertType = params.get("CertType")
        self._Status = params.get("Status")
        self._CertExpireTime = params.get("CertExpireTime")
        self._CertId = params.get("CertId")
        self._CloudCertId = params.get("CloudCertId")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveEnhanceInfo(AbstractModel):
    """直播增强计费信息。

    """

    def __init__(self):
        r"""
        :param _Domain: 域名。
        :type Domain: str
        :param _Time: 时间。
        :type Time: str
        :param _Duration: 计费时长，单位分钟。
        :type Duration: int
        :param _Fps: 帧率。
        :type Fps: str
        :param _Resolution: 分辨率。
        :type Resolution: str
        :param _Type: 增强服务类型。
        :type Type: str
        """
        self._Domain = None
        self._Time = None
        self._Duration = None
        self._Fps = None
        self._Resolution = None
        self._Type = None

    @property
    def Domain(self):
        """域名。
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Time(self):
        """时间。
        :rtype: str
        """
        return self._Time

    @Time.setter
    def Time(self, Time):
        self._Time = Time

    @property
    def Duration(self):
        """计费时长，单位分钟。
        :rtype: int
        """
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration

    @property
    def Fps(self):
        """帧率。
        :rtype: str
        """
        return self._Fps

    @Fps.setter
    def Fps(self, Fps):
        self._Fps = Fps

    @property
    def Resolution(self):
        """分辨率。
        :rtype: str
        """
        return self._Resolution

    @Resolution.setter
    def Resolution(self, Resolution):
        self._Resolution = Resolution

    @property
    def Type(self):
        """增强服务类型。
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._Time = params.get("Time")
        self._Duration = params.get("Duration")
        self._Fps = params.get("Fps")
        self._Resolution = params.get("Resolution")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LivePackageInfo(AbstractModel):
    """直播包信息。

    """

    def __init__(self):
        r"""
        :param _Id: 包 ID。
        :type Id: str
        :param _Total: 总量。
注意：当为流量包时单位为字节。
当为转码包时单位为分钟。
        :type Total: int
        :param _Used: 使用量。
注意：当为流量包时单位为字节。
当为转码包时单位为分钟。
当为连麦包时单位为小时。
        :type Used: int
        :param _Left: 剩余量。
注意：当为流量包时单位为字节。
当为转码包时单位为分钟。
当为连麦包时单位为小时。
        :type Left: int
        :param _BuyTime: 购买时间。
注：此字段为北京时间（UTC+8时区）。
        :type BuyTime: str
        :param _ExpireTime: 过期时间。
注：此字段为北京时间（UTC+8时区）。
        :type ExpireTime: str
        :param _Type: 包类型，可选值:
0: 流量包。
1: 普通转码包。
2: 极速高清包。
3: 连麦包。
        :type Type: int
        :param _Status: 包状态，可选值:
0: 未使用。
1: 使用中。
2: 已过期。
3: 已冻结。
4: 已耗尽。
5: 已退款
        :type Status: int
        :param _WillRenew: 是否自动续购。
注意：此字段可能返回 null，表示取不到有效值。
        :type WillRenew: int
        :param _RenewalResult: 续购状态。
1 ：续购成功。
0 ：尚未续购。
<0  : 续购失败。
注意：此字段可能返回 null，表示取不到有效值。
        :type RenewalResult: int
        """
        self._Id = None
        self._Total = None
        self._Used = None
        self._Left = None
        self._BuyTime = None
        self._ExpireTime = None
        self._Type = None
        self._Status = None
        self._WillRenew = None
        self._RenewalResult = None

    @property
    def Id(self):
        """包 ID。
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Total(self):
        """总量。
注意：当为流量包时单位为字节。
当为转码包时单位为分钟。
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Used(self):
        """使用量。
注意：当为流量包时单位为字节。
当为转码包时单位为分钟。
当为连麦包时单位为小时。
        :rtype: int
        """
        return self._Used

    @Used.setter
    def Used(self, Used):
        self._Used = Used

    @property
    def Left(self):
        """剩余量。
注意：当为流量包时单位为字节。
当为转码包时单位为分钟。
当为连麦包时单位为小时。
        :rtype: int
        """
        return self._Left

    @Left.setter
    def Left(self, Left):
        self._Left = Left

    @property
    def BuyTime(self):
        """购买时间。
注：此字段为北京时间（UTC+8时区）。
        :rtype: str
        """
        return self._BuyTime

    @BuyTime.setter
    def BuyTime(self, BuyTime):
        self._BuyTime = BuyTime

    @property
    def ExpireTime(self):
        """过期时间。
注：此字段为北京时间（UTC+8时区）。
        :rtype: str
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def Type(self):
        """包类型，可选值:
0: 流量包。
1: 普通转码包。
2: 极速高清包。
3: 连麦包。
        :rtype: int
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Status(self):
        """包状态，可选值:
0: 未使用。
1: 使用中。
2: 已过期。
3: 已冻结。
4: 已耗尽。
5: 已退款
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def WillRenew(self):
        """是否自动续购。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._WillRenew

    @WillRenew.setter
    def WillRenew(self, WillRenew):
        self._WillRenew = WillRenew

    @property
    def RenewalResult(self):
        """续购状态。
1 ：续购成功。
0 ：尚未续购。
<0  : 续购失败。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._RenewalResult

    @RenewalResult.setter
    def RenewalResult(self, RenewalResult):
        self._RenewalResult = RenewalResult


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Total = params.get("Total")
        self._Used = params.get("Used")
        self._Left = params.get("Left")
        self._BuyTime = params.get("BuyTime")
        self._ExpireTime = params.get("ExpireTime")
        self._Type = params.get("Type")
        self._Status = params.get("Status")
        self._WillRenew = params.get("WillRenew")
        self._RenewalResult = params.get("RenewalResult")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveStreamMonitorInfo(AbstractModel):
    """直播监播任务信息。

    """

    def __init__(self):
        r"""
        :param _MonitorId: 监播任务ID。
        :type MonitorId: str
        :param _MonitorName: 监播任务名称。128字节以内。
        :type MonitorName: str
        :param _OutputInfo: 监播任务输出信息。
        :type OutputInfo: :class:`tencentcloud.live.v20180801.models.LiveStreamMonitorOutputInfo`
        :param _InputList: 待监播的输入流信息。
        :type InputList: list of LiveStreamMonitorInputInfo
        :param _Status: 监播任务状态。
0： 代表空闲
1： 代表监播中。
        :type Status: int
        :param _StartTime: 上一次的启动时间，unix时间戳。
        :type StartTime: int
        :param _StopTime: 上一次的停止时间，unix时间戳。
        :type StopTime: int
        :param _CreateTime: 监播任务创建时间，unix时间戳
        :type CreateTime: int
        :param _UpdateTime: 监播任务更新时间，unix时间戳
        :type UpdateTime: int
        :param _NotifyPolicy: 监播事件通知策略。
        :type NotifyPolicy: :class:`tencentcloud.live.v20180801.models.LiveStreamMonitorNotifyPolicy`
        :param _AudibleInputIndexList: 输出音频的输入Index列表。
        :type AudibleInputIndexList: list of int non-negative
        :param _AiAsrInputIndexList: 开启智能语音识别的输入Index列表
        :type AiAsrInputIndexList: list of int non-negative
        :param _CheckStreamBroken: 是否开启断流检测
        :type CheckStreamBroken: int
        :param _CheckStreamLowFrameRate: 是否开启低帧率检测
        :type CheckStreamLowFrameRate: int
        :param _AsrLanguage: 智能语音识别语种：
0 关闭 1 中文 2 英文 3日文 4 韩文
        :type AsrLanguage: int
        :param _OcrLanguage: 智能文字识别语种：
0 关闭 1 中、英文
        :type OcrLanguage: int
        :param _AiOcrInputIndexList: 开启智能文字识别的输入Index列表
        :type AiOcrInputIndexList: list of int non-negative
        :param _AllowMonitorReport: 是否存储监播事件到监播报告，以及是否允许查询监播报告
        :type AllowMonitorReport: int
        :param _AiFormatDiagnose: 是否开启格式诊断
        :type AiFormatDiagnose: int
        :param _AiQualityControl: 是否开启内容质检。
        :type AiQualityControl: int
        :param _CasterId: 导播台监播对应的导播台场次id
        :type CasterId: str
        :param _PullPushTaskId: 拉流转推监播对应的拉流转推任务id
        :type PullPushTaskId: str
        """
        self._MonitorId = None
        self._MonitorName = None
        self._OutputInfo = None
        self._InputList = None
        self._Status = None
        self._StartTime = None
        self._StopTime = None
        self._CreateTime = None
        self._UpdateTime = None
        self._NotifyPolicy = None
        self._AudibleInputIndexList = None
        self._AiAsrInputIndexList = None
        self._CheckStreamBroken = None
        self._CheckStreamLowFrameRate = None
        self._AsrLanguage = None
        self._OcrLanguage = None
        self._AiOcrInputIndexList = None
        self._AllowMonitorReport = None
        self._AiFormatDiagnose = None
        self._AiQualityControl = None
        self._CasterId = None
        self._PullPushTaskId = None

    @property
    def MonitorId(self):
        """监播任务ID。
        :rtype: str
        """
        return self._MonitorId

    @MonitorId.setter
    def MonitorId(self, MonitorId):
        self._MonitorId = MonitorId

    @property
    def MonitorName(self):
        """监播任务名称。128字节以内。
        :rtype: str
        """
        return self._MonitorName

    @MonitorName.setter
    def MonitorName(self, MonitorName):
        self._MonitorName = MonitorName

    @property
    def OutputInfo(self):
        """监播任务输出信息。
        :rtype: :class:`tencentcloud.live.v20180801.models.LiveStreamMonitorOutputInfo`
        """
        return self._OutputInfo

    @OutputInfo.setter
    def OutputInfo(self, OutputInfo):
        self._OutputInfo = OutputInfo

    @property
    def InputList(self):
        """待监播的输入流信息。
        :rtype: list of LiveStreamMonitorInputInfo
        """
        return self._InputList

    @InputList.setter
    def InputList(self, InputList):
        self._InputList = InputList

    @property
    def Status(self):
        """监播任务状态。
0： 代表空闲
1： 代表监播中。
        :rtype: int
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def StartTime(self):
        """上一次的启动时间，unix时间戳。
        :rtype: int
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def StopTime(self):
        """上一次的停止时间，unix时间戳。
        :rtype: int
        """
        return self._StopTime

    @StopTime.setter
    def StopTime(self, StopTime):
        self._StopTime = StopTime

    @property
    def CreateTime(self):
        """监播任务创建时间，unix时间戳
        :rtype: int
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        """监播任务更新时间，unix时间戳
        :rtype: int
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def NotifyPolicy(self):
        """监播事件通知策略。
        :rtype: :class:`tencentcloud.live.v20180801.models.LiveStreamMonitorNotifyPolicy`
        """
        return self._NotifyPolicy

    @NotifyPolicy.setter
    def NotifyPolicy(self, NotifyPolicy):
        self._NotifyPolicy = NotifyPolicy

    @property
    def AudibleInputIndexList(self):
        """输出音频的输入Index列表。
        :rtype: list of int non-negative
        """
        return self._AudibleInputIndexList

    @AudibleInputIndexList.setter
    def AudibleInputIndexList(self, AudibleInputIndexList):
        self._AudibleInputIndexList = AudibleInputIndexList

    @property
    def AiAsrInputIndexList(self):
        """开启智能语音识别的输入Index列表
        :rtype: list of int non-negative
        """
        return self._AiAsrInputIndexList

    @AiAsrInputIndexList.setter
    def AiAsrInputIndexList(self, AiAsrInputIndexList):
        self._AiAsrInputIndexList = AiAsrInputIndexList

    @property
    def CheckStreamBroken(self):
        """是否开启断流检测
        :rtype: int
        """
        return self._CheckStreamBroken

    @CheckStreamBroken.setter
    def CheckStreamBroken(self, CheckStreamBroken):
        self._CheckStreamBroken = CheckStreamBroken

    @property
    def CheckStreamLowFrameRate(self):
        """是否开启低帧率检测
        :rtype: int
        """
        return self._CheckStreamLowFrameRate

    @CheckStreamLowFrameRate.setter
    def CheckStreamLowFrameRate(self, CheckStreamLowFrameRate):
        self._CheckStreamLowFrameRate = CheckStreamLowFrameRate

    @property
    def AsrLanguage(self):
        """智能语音识别语种：
0 关闭 1 中文 2 英文 3日文 4 韩文
        :rtype: int
        """
        return self._AsrLanguage

    @AsrLanguage.setter
    def AsrLanguage(self, AsrLanguage):
        self._AsrLanguage = AsrLanguage

    @property
    def OcrLanguage(self):
        """智能文字识别语种：
0 关闭 1 中、英文
        :rtype: int
        """
        return self._OcrLanguage

    @OcrLanguage.setter
    def OcrLanguage(self, OcrLanguage):
        self._OcrLanguage = OcrLanguage

    @property
    def AiOcrInputIndexList(self):
        """开启智能文字识别的输入Index列表
        :rtype: list of int non-negative
        """
        return self._AiOcrInputIndexList

    @AiOcrInputIndexList.setter
    def AiOcrInputIndexList(self, AiOcrInputIndexList):
        self._AiOcrInputIndexList = AiOcrInputIndexList

    @property
    def AllowMonitorReport(self):
        """是否存储监播事件到监播报告，以及是否允许查询监播报告
        :rtype: int
        """
        return self._AllowMonitorReport

    @AllowMonitorReport.setter
    def AllowMonitorReport(self, AllowMonitorReport):
        self._AllowMonitorReport = AllowMonitorReport

    @property
    def AiFormatDiagnose(self):
        """是否开启格式诊断
        :rtype: int
        """
        return self._AiFormatDiagnose

    @AiFormatDiagnose.setter
    def AiFormatDiagnose(self, AiFormatDiagnose):
        self._AiFormatDiagnose = AiFormatDiagnose

    @property
    def AiQualityControl(self):
        """是否开启内容质检。
        :rtype: int
        """
        return self._AiQualityControl

    @AiQualityControl.setter
    def AiQualityControl(self, AiQualityControl):
        self._AiQualityControl = AiQualityControl

    @property
    def CasterId(self):
        """导播台监播对应的导播台场次id
        :rtype: str
        """
        return self._CasterId

    @CasterId.setter
    def CasterId(self, CasterId):
        self._CasterId = CasterId

    @property
    def PullPushTaskId(self):
        """拉流转推监播对应的拉流转推任务id
        :rtype: str
        """
        return self._PullPushTaskId

    @PullPushTaskId.setter
    def PullPushTaskId(self, PullPushTaskId):
        self._PullPushTaskId = PullPushTaskId


    def _deserialize(self, params):
        self._MonitorId = params.get("MonitorId")
        self._MonitorName = params.get("MonitorName")
        if params.get("OutputInfo") is not None:
            self._OutputInfo = LiveStreamMonitorOutputInfo()
            self._OutputInfo._deserialize(params.get("OutputInfo"))
        if params.get("InputList") is not None:
            self._InputList = []
            for item in params.get("InputList"):
                obj = LiveStreamMonitorInputInfo()
                obj._deserialize(item)
                self._InputList.append(obj)
        self._Status = params.get("Status")
        self._StartTime = params.get("StartTime")
        self._StopTime = params.get("StopTime")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        if params.get("NotifyPolicy") is not None:
            self._NotifyPolicy = LiveStreamMonitorNotifyPolicy()
            self._NotifyPolicy._deserialize(params.get("NotifyPolicy"))
        self._AudibleInputIndexList = params.get("AudibleInputIndexList")
        self._AiAsrInputIndexList = params.get("AiAsrInputIndexList")
        self._CheckStreamBroken = params.get("CheckStreamBroken")
        self._CheckStreamLowFrameRate = params.get("CheckStreamLowFrameRate")
        self._AsrLanguage = params.get("AsrLanguage")
        self._OcrLanguage = params.get("OcrLanguage")
        self._AiOcrInputIndexList = params.get("AiOcrInputIndexList")
        self._AllowMonitorReport = params.get("AllowMonitorReport")
        self._AiFormatDiagnose = params.get("AiFormatDiagnose")
        self._AiQualityControl = params.get("AiQualityControl")
        self._CasterId = params.get("CasterId")
        self._PullPushTaskId = params.get("PullPushTaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveStreamMonitorInputInfo(AbstractModel):
    """直播监播功能输入流信息

    """

    def __init__(self):
        r"""
        :param _InputStreamName: 待监播的输入流名称。256字节以内，只允许包含字母、数字、‘-’，‘_’，'.'字符。
        :type InputStreamName: str
        :param _InputDomain: 待监播的输入流推流域名。128字节以内，只允许填处于启用状态的推流域名。
        :type InputDomain: str
        :param _InputApp: 待监播的输入流推流路径。32字节以内，只允许包含字母、数字、‘-’，‘_’，'.'字符。
        :type InputApp: str
        :param _InputUrl: 待监播的输入流推流url。一般场景下，无需该参数。
        :type InputUrl: str
        :param _Description: 描述。256字节以内。
        :type Description: str
        :param _CasterInputIndex: 导播台输入源索引（10000 pvw， 10001 pgm， 其余代表输入下标）
        :type CasterInputIndex: int
        :param _NeedMonitor: 该输入源是否正在监播
        :type NeedMonitor: bool
        :param _CdnStreamId: 导播台pvw pgm的cdn流id
        :type CdnStreamId: str
        """
        self._InputStreamName = None
        self._InputDomain = None
        self._InputApp = None
        self._InputUrl = None
        self._Description = None
        self._CasterInputIndex = None
        self._NeedMonitor = None
        self._CdnStreamId = None

    @property
    def InputStreamName(self):
        """待监播的输入流名称。256字节以内，只允许包含字母、数字、‘-’，‘_’，'.'字符。
        :rtype: str
        """
        return self._InputStreamName

    @InputStreamName.setter
    def InputStreamName(self, InputStreamName):
        self._InputStreamName = InputStreamName

    @property
    def InputDomain(self):
        """待监播的输入流推流域名。128字节以内，只允许填处于启用状态的推流域名。
        :rtype: str
        """
        return self._InputDomain

    @InputDomain.setter
    def InputDomain(self, InputDomain):
        self._InputDomain = InputDomain

    @property
    def InputApp(self):
        """待监播的输入流推流路径。32字节以内，只允许包含字母、数字、‘-’，‘_’，'.'字符。
        :rtype: str
        """
        return self._InputApp

    @InputApp.setter
    def InputApp(self, InputApp):
        self._InputApp = InputApp

    @property
    def InputUrl(self):
        """待监播的输入流推流url。一般场景下，无需该参数。
        :rtype: str
        """
        return self._InputUrl

    @InputUrl.setter
    def InputUrl(self, InputUrl):
        self._InputUrl = InputUrl

    @property
    def Description(self):
        """描述。256字节以内。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def CasterInputIndex(self):
        """导播台输入源索引（10000 pvw， 10001 pgm， 其余代表输入下标）
        :rtype: int
        """
        return self._CasterInputIndex

    @CasterInputIndex.setter
    def CasterInputIndex(self, CasterInputIndex):
        self._CasterInputIndex = CasterInputIndex

    @property
    def NeedMonitor(self):
        """该输入源是否正在监播
        :rtype: bool
        """
        return self._NeedMonitor

    @NeedMonitor.setter
    def NeedMonitor(self, NeedMonitor):
        self._NeedMonitor = NeedMonitor

    @property
    def CdnStreamId(self):
        """导播台pvw pgm的cdn流id
        :rtype: str
        """
        return self._CdnStreamId

    @CdnStreamId.setter
    def CdnStreamId(self, CdnStreamId):
        self._CdnStreamId = CdnStreamId


    def _deserialize(self, params):
        self._InputStreamName = params.get("InputStreamName")
        self._InputDomain = params.get("InputDomain")
        self._InputApp = params.get("InputApp")
        self._InputUrl = params.get("InputUrl")
        self._Description = params.get("Description")
        self._CasterInputIndex = params.get("CasterInputIndex")
        self._NeedMonitor = params.get("NeedMonitor")
        self._CdnStreamId = params.get("CdnStreamId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveStreamMonitorNotifyPolicy(AbstractModel):
    """直播流监播通知策略

    """

    def __init__(self):
        r"""
        :param _NotifyPolicyType: 通知策略类型：范围[0,1]
0:代表不使用任何通知策略
1:代表使用全局回调策略，所有事件通知到CallbackUrl。
        :type NotifyPolicyType: int
        :param _CallbackUrl: 回调URL：长度[0,512]
只支持http和https类型的url。
        :type CallbackUrl: str
        """
        self._NotifyPolicyType = None
        self._CallbackUrl = None

    @property
    def NotifyPolicyType(self):
        """通知策略类型：范围[0,1]
0:代表不使用任何通知策略
1:代表使用全局回调策略，所有事件通知到CallbackUrl。
        :rtype: int
        """
        return self._NotifyPolicyType

    @NotifyPolicyType.setter
    def NotifyPolicyType(self, NotifyPolicyType):
        self._NotifyPolicyType = NotifyPolicyType

    @property
    def CallbackUrl(self):
        """回调URL：长度[0,512]
只支持http和https类型的url。
        :rtype: str
        """
        return self._CallbackUrl

    @CallbackUrl.setter
    def CallbackUrl(self, CallbackUrl):
        self._CallbackUrl = CallbackUrl


    def _deserialize(self, params):
        self._NotifyPolicyType = params.get("NotifyPolicyType")
        self._CallbackUrl = params.get("CallbackUrl")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveStreamMonitorOutputInfo(AbstractModel):
    """直播流监播输出流信息

    """

    def __init__(self):
        r"""
        :param _OutputStreamWidth: 监播任务输出流宽度像素。范围[1,1920]。建议至少大于100像素。
        :type OutputStreamWidth: int
        :param _OutputStreamHeight: 监播任务输出流长度像素。范围[1,1080]，建议至少大于100像素。
        :type OutputStreamHeight: int
        :param _OutputStreamName: 监播任务输出流名称。
不填时，系统会自动生成。
256字节以内，只允许包含字母、数字、‘-’，‘_’，'.'字符。
        :type OutputStreamName: str
        :param _OutputDomain: 监播任务播放域名。128字节以内，只允许填处于启用状态的播放域名。
        :type OutputDomain: str
        :param _OutputApp: 监播任务播放路径。32字节以内，只允许包含字母、数字、‘-’，‘_’，'.'字符。
        :type OutputApp: str
        """
        self._OutputStreamWidth = None
        self._OutputStreamHeight = None
        self._OutputStreamName = None
        self._OutputDomain = None
        self._OutputApp = None

    @property
    def OutputStreamWidth(self):
        """监播任务输出流宽度像素。范围[1,1920]。建议至少大于100像素。
        :rtype: int
        """
        return self._OutputStreamWidth

    @OutputStreamWidth.setter
    def OutputStreamWidth(self, OutputStreamWidth):
        self._OutputStreamWidth = OutputStreamWidth

    @property
    def OutputStreamHeight(self):
        """监播任务输出流长度像素。范围[1,1080]，建议至少大于100像素。
        :rtype: int
        """
        return self._OutputStreamHeight

    @OutputStreamHeight.setter
    def OutputStreamHeight(self, OutputStreamHeight):
        self._OutputStreamHeight = OutputStreamHeight

    @property
    def OutputStreamName(self):
        """监播任务输出流名称。
不填时，系统会自动生成。
256字节以内，只允许包含字母、数字、‘-’，‘_’，'.'字符。
        :rtype: str
        """
        return self._OutputStreamName

    @OutputStreamName.setter
    def OutputStreamName(self, OutputStreamName):
        self._OutputStreamName = OutputStreamName

    @property
    def OutputDomain(self):
        """监播任务播放域名。128字节以内，只允许填处于启用状态的播放域名。
        :rtype: str
        """
        return self._OutputDomain

    @OutputDomain.setter
    def OutputDomain(self, OutputDomain):
        self._OutputDomain = OutputDomain

    @property
    def OutputApp(self):
        """监播任务播放路径。32字节以内，只允许包含字母、数字、‘-’，‘_’，'.'字符。
        :rtype: str
        """
        return self._OutputApp

    @OutputApp.setter
    def OutputApp(self, OutputApp):
        self._OutputApp = OutputApp


    def _deserialize(self, params):
        self._OutputStreamWidth = params.get("OutputStreamWidth")
        self._OutputStreamHeight = params.get("OutputStreamHeight")
        self._OutputStreamName = params.get("OutputStreamName")
        self._OutputDomain = params.get("OutputDomain")
        self._OutputApp = params.get("OutputApp")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LogInfo(AbstractModel):
    """日志url信息。

    """

    def __init__(self):
        r"""
        :param _LogName: 日志名称。
        :type LogName: str
        :param _LogUrl: 日志 URL。
        :type LogUrl: str
        :param _LogTime: 日志生成时间。
注：此字段为北京时间（UTC+8时区）。
        :type LogTime: str
        :param _FileSize: 文件大小。
        :type FileSize: int
        """
        self._LogName = None
        self._LogUrl = None
        self._LogTime = None
        self._FileSize = None

    @property
    def LogName(self):
        """日志名称。
        :rtype: str
        """
        return self._LogName

    @LogName.setter
    def LogName(self, LogName):
        self._LogName = LogName

    @property
    def LogUrl(self):
        """日志 URL。
        :rtype: str
        """
        return self._LogUrl

    @LogUrl.setter
    def LogUrl(self, LogUrl):
        self._LogUrl = LogUrl

    @property
    def LogTime(self):
        """日志生成时间。
注：此字段为北京时间（UTC+8时区）。
        :rtype: str
        """
        return self._LogTime

    @LogTime.setter
    def LogTime(self, LogTime):
        self._LogTime = LogTime

    @property
    def FileSize(self):
        """文件大小。
        :rtype: int
        """
        return self._FileSize

    @FileSize.setter
    def FileSize(self, FileSize):
        self._FileSize = FileSize


    def _deserialize(self, params):
        self._LogName = params.get("LogName")
        self._LogUrl = params.get("LogUrl")
        self._LogTime = params.get("LogTime")
        self._FileSize = params.get("FileSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MPSResult(AbstractModel):
    """媒体处理结果，包含智能语音识别、智能文字识别结果

    """

    def __init__(self):
        r"""
        :param _AiAsrResults: 智能语音识别结果。
        :type AiAsrResults: list of str
        :param _AiOcrResults: 智能文字识别结果。
        :type AiOcrResults: list of str
        :param _StreamQuaCtrlResults: 内容质检结果。
        :type StreamQuaCtrlResults: list of str
        """
        self._AiAsrResults = None
        self._AiOcrResults = None
        self._StreamQuaCtrlResults = None

    @property
    def AiAsrResults(self):
        """智能语音识别结果。
        :rtype: list of str
        """
        return self._AiAsrResults

    @AiAsrResults.setter
    def AiAsrResults(self, AiAsrResults):
        self._AiAsrResults = AiAsrResults

    @property
    def AiOcrResults(self):
        """智能文字识别结果。
        :rtype: list of str
        """
        return self._AiOcrResults

    @AiOcrResults.setter
    def AiOcrResults(self, AiOcrResults):
        self._AiOcrResults = AiOcrResults

    @property
    def StreamQuaCtrlResults(self):
        """内容质检结果。
        :rtype: list of str
        """
        return self._StreamQuaCtrlResults

    @StreamQuaCtrlResults.setter
    def StreamQuaCtrlResults(self, StreamQuaCtrlResults):
        self._StreamQuaCtrlResults = StreamQuaCtrlResults


    def _deserialize(self, params):
        self._AiAsrResults = params.get("AiAsrResults")
        self._AiOcrResults = params.get("AiOcrResults")
        self._StreamQuaCtrlResults = params.get("StreamQuaCtrlResults")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MixPortraitSegmentParams(AbstractModel):
    """混流抠图参数

    """

    def __init__(self):
        r"""
        :param _Color: 抠图背景颜色，
常用的颜色有：
红色：0xcc0033。
黄色：0xcc9900。
绿色：0xcccc33。
蓝色：0x99CCFF。
黑色：0x000000。
白色：0xFFFFFF。
灰色：0x999999。
        :type Color: str
        """
        self._Color = None

    @property
    def Color(self):
        """抠图背景颜色，
常用的颜色有：
红色：0xcc0033。
黄色：0xcc9900。
绿色：0xcccc33。
蓝色：0x99CCFF。
黑色：0x000000。
白色：0xFFFFFF。
灰色：0x999999。
        :rtype: str
        """
        return self._Color

    @Color.setter
    def Color(self, Color):
        self._Color = Color


    def _deserialize(self, params):
        self._Color = params.get("Color")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyCasterInputInfoRequest(AbstractModel):
    """ModifyCasterInputInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CasterId: 导播台ID。
        :type CasterId: int
        :param _InputInfo: 修改的导播台输入源信息
        :type InputInfo: :class:`tencentcloud.live.v20180801.models.CasterInputInfo`
        """
        self._CasterId = None
        self._InputInfo = None

    @property
    def CasterId(self):
        """导播台ID。
        :rtype: int
        """
        return self._CasterId

    @CasterId.setter
    def CasterId(self, CasterId):
        self._CasterId = CasterId

    @property
    def InputInfo(self):
        """修改的导播台输入源信息
        :rtype: :class:`tencentcloud.live.v20180801.models.CasterInputInfo`
        """
        return self._InputInfo

    @InputInfo.setter
    def InputInfo(self, InputInfo):
        self._InputInfo = InputInfo


    def _deserialize(self, params):
        self._CasterId = params.get("CasterId")
        if params.get("InputInfo") is not None:
            self._InputInfo = CasterInputInfo()
            self._InputInfo._deserialize(params.get("InputInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyCasterInputInfoResponse(AbstractModel):
    """ModifyCasterInputInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _InputPlayUrl: 修改输入源后的预览地址。
注：该地址仅作为预览使用，不可分发。
        :type InputPlayUrl: str
        :param _InputWebRTCPlayUrl: 修改后的输入源webrtc预览地址。
该地址需配合腾讯云快直播播放SDK使用。
注：该地址仅做预览使用，不可分发。
        :type InputWebRTCPlayUrl: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._InputPlayUrl = None
        self._InputWebRTCPlayUrl = None
        self._RequestId = None

    @property
    def InputPlayUrl(self):
        """修改输入源后的预览地址。
注：该地址仅作为预览使用，不可分发。
        :rtype: str
        """
        return self._InputPlayUrl

    @InputPlayUrl.setter
    def InputPlayUrl(self, InputPlayUrl):
        self._InputPlayUrl = InputPlayUrl

    @property
    def InputWebRTCPlayUrl(self):
        """修改后的输入源webrtc预览地址。
该地址需配合腾讯云快直播播放SDK使用。
注：该地址仅做预览使用，不可分发。
        :rtype: str
        """
        return self._InputWebRTCPlayUrl

    @InputWebRTCPlayUrl.setter
    def InputWebRTCPlayUrl(self, InputWebRTCPlayUrl):
        self._InputWebRTCPlayUrl = InputWebRTCPlayUrl

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._InputPlayUrl = params.get("InputPlayUrl")
        self._InputWebRTCPlayUrl = params.get("InputWebRTCPlayUrl")
        self._RequestId = params.get("RequestId")


class ModifyCasterLayoutInfoRequest(AbstractModel):
    """ModifyCasterLayoutInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CasterId: 导播台ID。
        :type CasterId: int
        :param _LayoutInfo: 导播台布局参数信息。
        :type LayoutInfo: :class:`tencentcloud.live.v20180801.models.CasterLayoutInfo`
        """
        self._CasterId = None
        self._LayoutInfo = None

    @property
    def CasterId(self):
        """导播台ID。
        :rtype: int
        """
        return self._CasterId

    @CasterId.setter
    def CasterId(self, CasterId):
        self._CasterId = CasterId

    @property
    def LayoutInfo(self):
        """导播台布局参数信息。
        :rtype: :class:`tencentcloud.live.v20180801.models.CasterLayoutInfo`
        """
        return self._LayoutInfo

    @LayoutInfo.setter
    def LayoutInfo(self, LayoutInfo):
        self._LayoutInfo = LayoutInfo


    def _deserialize(self, params):
        self._CasterId = params.get("CasterId")
        if params.get("LayoutInfo") is not None:
            self._LayoutInfo = CasterLayoutInfo()
            self._LayoutInfo._deserialize(params.get("LayoutInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyCasterLayoutInfoResponse(AbstractModel):
    """ModifyCasterLayoutInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyCasterMarkPicInfoRequest(AbstractModel):
    """ModifyCasterMarkPicInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CasterId: 导播台ID。
        :type CasterId: int
        :param _MarkPicInfo: 新的水印信息。
        :type MarkPicInfo: :class:`tencentcloud.live.v20180801.models.CasterMarkPicInfo`
        """
        self._CasterId = None
        self._MarkPicInfo = None

    @property
    def CasterId(self):
        """导播台ID。
        :rtype: int
        """
        return self._CasterId

    @CasterId.setter
    def CasterId(self, CasterId):
        self._CasterId = CasterId

    @property
    def MarkPicInfo(self):
        """新的水印信息。
        :rtype: :class:`tencentcloud.live.v20180801.models.CasterMarkPicInfo`
        """
        return self._MarkPicInfo

    @MarkPicInfo.setter
    def MarkPicInfo(self, MarkPicInfo):
        self._MarkPicInfo = MarkPicInfo


    def _deserialize(self, params):
        self._CasterId = params.get("CasterId")
        if params.get("MarkPicInfo") is not None:
            self._MarkPicInfo = CasterMarkPicInfo()
            self._MarkPicInfo._deserialize(params.get("MarkPicInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyCasterMarkPicInfoResponse(AbstractModel):
    """ModifyCasterMarkPicInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyCasterMarkWordInfoRequest(AbstractModel):
    """ModifyCasterMarkWordInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CasterId: 导播台ID。
        :type CasterId: int
        :param _MarkWordInfo: 修改的文本配置。
        :type MarkWordInfo: :class:`tencentcloud.live.v20180801.models.CasterMarkWordInfo`
        """
        self._CasterId = None
        self._MarkWordInfo = None

    @property
    def CasterId(self):
        """导播台ID。
        :rtype: int
        """
        return self._CasterId

    @CasterId.setter
    def CasterId(self, CasterId):
        self._CasterId = CasterId

    @property
    def MarkWordInfo(self):
        """修改的文本配置。
        :rtype: :class:`tencentcloud.live.v20180801.models.CasterMarkWordInfo`
        """
        return self._MarkWordInfo

    @MarkWordInfo.setter
    def MarkWordInfo(self, MarkWordInfo):
        self._MarkWordInfo = MarkWordInfo


    def _deserialize(self, params):
        self._CasterId = params.get("CasterId")
        if params.get("MarkWordInfo") is not None:
            self._MarkWordInfo = CasterMarkWordInfo()
            self._MarkWordInfo._deserialize(params.get("MarkWordInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyCasterMarkWordInfoResponse(AbstractModel):
    """ModifyCasterMarkWordInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyCasterOutputInfoRequest(AbstractModel):
    """ModifyCasterOutputInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CasterId: 导播台ID。
        :type CasterId: int
        :param _OutputInfo: 导播台推流参数信息。
        :type OutputInfo: :class:`tencentcloud.live.v20180801.models.CasterOutputInfo`
        """
        self._CasterId = None
        self._OutputInfo = None

    @property
    def CasterId(self):
        """导播台ID。
        :rtype: int
        """
        return self._CasterId

    @CasterId.setter
    def CasterId(self, CasterId):
        self._CasterId = CasterId

    @property
    def OutputInfo(self):
        """导播台推流参数信息。
        :rtype: :class:`tencentcloud.live.v20180801.models.CasterOutputInfo`
        """
        return self._OutputInfo

    @OutputInfo.setter
    def OutputInfo(self, OutputInfo):
        self._OutputInfo = OutputInfo


    def _deserialize(self, params):
        self._CasterId = params.get("CasterId")
        if params.get("OutputInfo") is not None:
            self._OutputInfo = CasterOutputInfo()
            self._OutputInfo._deserialize(params.get("OutputInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyCasterOutputInfoResponse(AbstractModel):
    """ModifyCasterOutputInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyCasterRequest(AbstractModel):
    """ModifyCaster请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CasterId: 导播台ID
        :type CasterId: int
        :param _CasterName: 导播台名称
        :type CasterName: str
        :param _Description: 导播台的描述
最大允许长度256
        :type Description: str
        :param _RecordTemplateId: 录制模板id。
默认为0。
当使用直播录制功能时，可将使用的录制模版填入。
该接口仅保存字段，不涉及任何录制功能。
        :type RecordTemplateId: int
        :param _RecordStatus: 录制状态，当调用录制接口后，可通过该字段保存录制状态。
0：未录制 
1：录制中
该接口仅保存字段，不涉及任何录制处理。
        :type RecordStatus: int
        :param _ExpireTime: 导播台的过期时间戳。值为-1或unix时间戳。
默认值为-1。 
当值为-1时，表示该导播台永不过期。 
当值为正常unix时间戳时，导播台将在该时间过期。
导播台过期后，预监与主监画面将自动停止，转推自动停止。 
点播、直播url将停止转拉，推流url需自行停止推流。
        :type ExpireTime: int
        :param _DelayTime: 导播台延时播放时间，单位为秒。 
默认为0，最大支持300秒
        :type DelayTime: int
        :param _TransitionType: 导播台转场类型。 
默认为空。 
允许使用通过DescribeCasterTransitionTypes接口中查询到的转场类型。
        :type TransitionType: str
        :param _PgmWidth: 导播台主监输出的宽度，单位为像素。 
默认为1280，最大允许4096。
        :type PgmWidth: int
        :param _PgmHeight: 导播台主监输出的高度，单位为像素。 
默认为720，最大允许2160。
        :type PgmHeight: int
        :param _PgmFps: 导播台主监输出的帧率。 
默认为0，表示随源输出。 最大支持60。
        :type PgmFps: int
        :param _PgmBitRate: 导播台主监输出的码率，单位为kbps。 
默认为0，表示随源的码率输出。 
最大允许10000kbps。
        :type PgmBitRate: int
        :param _FeeType: 导播台的计费类型。 
0 通用型 
1 播单型。 
注： 本参数暂无作用。
        :type FeeType: int
        :param _RecordTaskId: 录制接口返回的taskid
注：该接口只做字段保存，不涉及录制操作。
        :type RecordTaskId: str
        :param _PgmAudioBitRate: 导播台主监输出的音频码率，单位为kbps。 
可选项：[0, 128, 192, 256] 
默认值为0，表示随源的音频码率输出。
        :type PgmAudioBitRate: int
        """
        self._CasterId = None
        self._CasterName = None
        self._Description = None
        self._RecordTemplateId = None
        self._RecordStatus = None
        self._ExpireTime = None
        self._DelayTime = None
        self._TransitionType = None
        self._PgmWidth = None
        self._PgmHeight = None
        self._PgmFps = None
        self._PgmBitRate = None
        self._FeeType = None
        self._RecordTaskId = None
        self._PgmAudioBitRate = None

    @property
    def CasterId(self):
        """导播台ID
        :rtype: int
        """
        return self._CasterId

    @CasterId.setter
    def CasterId(self, CasterId):
        self._CasterId = CasterId

    @property
    def CasterName(self):
        """导播台名称
        :rtype: str
        """
        return self._CasterName

    @CasterName.setter
    def CasterName(self, CasterName):
        self._CasterName = CasterName

    @property
    def Description(self):
        """导播台的描述
最大允许长度256
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def RecordTemplateId(self):
        """录制模板id。
默认为0。
当使用直播录制功能时，可将使用的录制模版填入。
该接口仅保存字段，不涉及任何录制功能。
        :rtype: int
        """
        return self._RecordTemplateId

    @RecordTemplateId.setter
    def RecordTemplateId(self, RecordTemplateId):
        self._RecordTemplateId = RecordTemplateId

    @property
    def RecordStatus(self):
        """录制状态，当调用录制接口后，可通过该字段保存录制状态。
0：未录制 
1：录制中
该接口仅保存字段，不涉及任何录制处理。
        :rtype: int
        """
        return self._RecordStatus

    @RecordStatus.setter
    def RecordStatus(self, RecordStatus):
        self._RecordStatus = RecordStatus

    @property
    def ExpireTime(self):
        """导播台的过期时间戳。值为-1或unix时间戳。
默认值为-1。 
当值为-1时，表示该导播台永不过期。 
当值为正常unix时间戳时，导播台将在该时间过期。
导播台过期后，预监与主监画面将自动停止，转推自动停止。 
点播、直播url将停止转拉，推流url需自行停止推流。
        :rtype: int
        """
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def DelayTime(self):
        """导播台延时播放时间，单位为秒。 
默认为0，最大支持300秒
        :rtype: int
        """
        return self._DelayTime

    @DelayTime.setter
    def DelayTime(self, DelayTime):
        self._DelayTime = DelayTime

    @property
    def TransitionType(self):
        """导播台转场类型。 
默认为空。 
允许使用通过DescribeCasterTransitionTypes接口中查询到的转场类型。
        :rtype: str
        """
        return self._TransitionType

    @TransitionType.setter
    def TransitionType(self, TransitionType):
        self._TransitionType = TransitionType

    @property
    def PgmWidth(self):
        """导播台主监输出的宽度，单位为像素。 
默认为1280，最大允许4096。
        :rtype: int
        """
        return self._PgmWidth

    @PgmWidth.setter
    def PgmWidth(self, PgmWidth):
        self._PgmWidth = PgmWidth

    @property
    def PgmHeight(self):
        """导播台主监输出的高度，单位为像素。 
默认为720，最大允许2160。
        :rtype: int
        """
        return self._PgmHeight

    @PgmHeight.setter
    def PgmHeight(self, PgmHeight):
        self._PgmHeight = PgmHeight

    @property
    def PgmFps(self):
        """导播台主监输出的帧率。 
默认为0，表示随源输出。 最大支持60。
        :rtype: int
        """
        return self._PgmFps

    @PgmFps.setter
    def PgmFps(self, PgmFps):
        self._PgmFps = PgmFps

    @property
    def PgmBitRate(self):
        """导播台主监输出的码率，单位为kbps。 
默认为0，表示随源的码率输出。 
最大允许10000kbps。
        :rtype: int
        """
        return self._PgmBitRate

    @PgmBitRate.setter
    def PgmBitRate(self, PgmBitRate):
        self._PgmBitRate = PgmBitRate

    @property
    def FeeType(self):
        """导播台的计费类型。 
0 通用型 
1 播单型。 
注： 本参数暂无作用。
        :rtype: int
        """
        return self._FeeType

    @FeeType.setter
    def FeeType(self, FeeType):
        self._FeeType = FeeType

    @property
    def RecordTaskId(self):
        """录制接口返回的taskid
注：该接口只做字段保存，不涉及录制操作。
        :rtype: str
        """
        return self._RecordTaskId

    @RecordTaskId.setter
    def RecordTaskId(self, RecordTaskId):
        self._RecordTaskId = RecordTaskId

    @property
    def PgmAudioBitRate(self):
        """导播台主监输出的音频码率，单位为kbps。 
可选项：[0, 128, 192, 256] 
默认值为0，表示随源的音频码率输出。
        :rtype: int
        """
        return self._PgmAudioBitRate

    @PgmAudioBitRate.setter
    def PgmAudioBitRate(self, PgmAudioBitRate):
        self._PgmAudioBitRate = PgmAudioBitRate


    def _deserialize(self, params):
        self._CasterId = params.get("CasterId")
        self._CasterName = params.get("CasterName")
        self._Description = params.get("Description")
        self._RecordTemplateId = params.get("RecordTemplateId")
        self._RecordStatus = params.get("RecordStatus")
        self._ExpireTime = params.get("ExpireTime")
        self._DelayTime = params.get("DelayTime")
        self._TransitionType = params.get("TransitionType")
        self._PgmWidth = params.get("PgmWidth")
        self._PgmHeight = params.get("PgmHeight")
        self._PgmFps = params.get("PgmFps")
        self._PgmBitRate = params.get("PgmBitRate")
        self._FeeType = params.get("FeeType")
        self._RecordTaskId = params.get("RecordTaskId")
        self._PgmAudioBitRate = params.get("PgmAudioBitRate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyCasterResponse(AbstractModel):
    """ModifyCaster返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyLiveCallbackTemplateRequest(AbstractModel):
    """ModifyLiveCallbackTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TemplateId: DescribeLiveCallbackTemplates接口返回的模板 ID。
        :type TemplateId: int
        :param _TemplateName: 模板名称。
        :type TemplateName: str
        :param _Description: 描述信息。
        :type Description: str
        :param _StreamBeginNotifyUrl: 开播回调 URL。
        :type StreamBeginNotifyUrl: str
        :param _StreamEndNotifyUrl: 断流回调 URL。
        :type StreamEndNotifyUrl: str
        :param _RecordNotifyUrl: 录制文件回调 URL。
        :type RecordNotifyUrl: str
        :param _RecordStatusNotifyUrl: 录制状态回调 URL 。
        :type RecordStatusNotifyUrl: str
        :param _SnapshotNotifyUrl: 截图回调 URL。
        :type SnapshotNotifyUrl: str
        :param _PornCensorshipNotifyUrl: 鉴黄回调 URL。
        :type PornCensorshipNotifyUrl: str
        :param _CallbackKey: 回调 Key，回调 URL 公用，回调签名详见事件消息通知文档。
[事件消息通知](/document/product/267/32744)。
        :type CallbackKey: str
        :param _PushExceptionNotifyUrl: 推流异常回调 URL。
        :type PushExceptionNotifyUrl: str
        :param _AudioAuditNotifyUrl: 音频审核回调 URL。
        :type AudioAuditNotifyUrl: str
        :param _RecordExceptionNotifyUrl: 录制异常回调 URL。	
        :type RecordExceptionNotifyUrl: str
        :param _RecordExceptionLevels: 录制异常回调级别，可选择：error、warning、info。
        :type RecordExceptionLevels: list of str
        """
        self._TemplateId = None
        self._TemplateName = None
        self._Description = None
        self._StreamBeginNotifyUrl = None
        self._StreamEndNotifyUrl = None
        self._RecordNotifyUrl = None
        self._RecordStatusNotifyUrl = None
        self._SnapshotNotifyUrl = None
        self._PornCensorshipNotifyUrl = None
        self._CallbackKey = None
        self._PushExceptionNotifyUrl = None
        self._AudioAuditNotifyUrl = None
        self._RecordExceptionNotifyUrl = None
        self._RecordExceptionLevels = None

    @property
    def TemplateId(self):
        """DescribeLiveCallbackTemplates接口返回的模板 ID。
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId

    @property
    def TemplateName(self):
        """模板名称。
        :rtype: str
        """
        return self._TemplateName

    @TemplateName.setter
    def TemplateName(self, TemplateName):
        self._TemplateName = TemplateName

    @property
    def Description(self):
        """描述信息。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def StreamBeginNotifyUrl(self):
        """开播回调 URL。
        :rtype: str
        """
        return self._StreamBeginNotifyUrl

    @StreamBeginNotifyUrl.setter
    def StreamBeginNotifyUrl(self, StreamBeginNotifyUrl):
        self._StreamBeginNotifyUrl = StreamBeginNotifyUrl

    @property
    def StreamEndNotifyUrl(self):
        """断流回调 URL。
        :rtype: str
        """
        return self._StreamEndNotifyUrl

    @StreamEndNotifyUrl.setter
    def StreamEndNotifyUrl(self, StreamEndNotifyUrl):
        self._StreamEndNotifyUrl = StreamEndNotifyUrl

    @property
    def RecordNotifyUrl(self):
        """录制文件回调 URL。
        :rtype: str
        """
        return self._RecordNotifyUrl

    @RecordNotifyUrl.setter
    def RecordNotifyUrl(self, RecordNotifyUrl):
        self._RecordNotifyUrl = RecordNotifyUrl

    @property
    def RecordStatusNotifyUrl(self):
        """录制状态回调 URL 。
        :rtype: str
        """
        return self._RecordStatusNotifyUrl

    @RecordStatusNotifyUrl.setter
    def RecordStatusNotifyUrl(self, RecordStatusNotifyUrl):
        self._RecordStatusNotifyUrl = RecordStatusNotifyUrl

    @property
    def SnapshotNotifyUrl(self):
        """截图回调 URL。
        :rtype: str
        """
        return self._SnapshotNotifyUrl

    @SnapshotNotifyUrl.setter
    def SnapshotNotifyUrl(self, SnapshotNotifyUrl):
        self._SnapshotNotifyUrl = SnapshotNotifyUrl

    @property
    def PornCensorshipNotifyUrl(self):
        """鉴黄回调 URL。
        :rtype: str
        """
        return self._PornCensorshipNotifyUrl

    @PornCensorshipNotifyUrl.setter
    def PornCensorshipNotifyUrl(self, PornCensorshipNotifyUrl):
        self._PornCensorshipNotifyUrl = PornCensorshipNotifyUrl

    @property
    def CallbackKey(self):
        """回调 Key，回调 URL 公用，回调签名详见事件消息通知文档。
[事件消息通知](/document/product/267/32744)。
        :rtype: str
        """
        return self._CallbackKey

    @CallbackKey.setter
    def CallbackKey(self, CallbackKey):
        self._CallbackKey = CallbackKey

    @property
    def PushExceptionNotifyUrl(self):
        """推流异常回调 URL。
        :rtype: str
        """
        return self._PushExceptionNotifyUrl

    @PushExceptionNotifyUrl.setter
    def PushExceptionNotifyUrl(self, PushExceptionNotifyUrl):
        self._PushExceptionNotifyUrl = PushExceptionNotifyUrl

    @property
    def AudioAuditNotifyUrl(self):
        """音频审核回调 URL。
        :rtype: str
        """
        return self._AudioAuditNotifyUrl

    @AudioAuditNotifyUrl.setter
    def AudioAuditNotifyUrl(self, AudioAuditNotifyUrl):
        self._AudioAuditNotifyUrl = AudioAuditNotifyUrl

    @property
    def RecordExceptionNotifyUrl(self):
        """录制异常回调 URL。	
        :rtype: str
        """
        return self._RecordExceptionNotifyUrl

    @RecordExceptionNotifyUrl.setter
    def RecordExceptionNotifyUrl(self, RecordExceptionNotifyUrl):
        self._RecordExceptionNotifyUrl = RecordExceptionNotifyUrl

    @property
    def RecordExceptionLevels(self):
        """录制异常回调级别，可选择：error、warning、info。
        :rtype: list of str
        """
        return self._RecordExceptionLevels

    @RecordExceptionLevels.setter
    def RecordExceptionLevels(self, RecordExceptionLevels):
        self._RecordExceptionLevels = RecordExceptionLevels


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        self._TemplateName = params.get("TemplateName")
        self._Description = params.get("Description")
        self._StreamBeginNotifyUrl = params.get("StreamBeginNotifyUrl")
        self._StreamEndNotifyUrl = params.get("StreamEndNotifyUrl")
        self._RecordNotifyUrl = params.get("RecordNotifyUrl")
        self._RecordStatusNotifyUrl = params.get("RecordStatusNotifyUrl")
        self._SnapshotNotifyUrl = params.get("SnapshotNotifyUrl")
        self._PornCensorshipNotifyUrl = params.get("PornCensorshipNotifyUrl")
        self._CallbackKey = params.get("CallbackKey")
        self._PushExceptionNotifyUrl = params.get("PushExceptionNotifyUrl")
        self._AudioAuditNotifyUrl = params.get("AudioAuditNotifyUrl")
        self._RecordExceptionNotifyUrl = params.get("RecordExceptionNotifyUrl")
        self._RecordExceptionLevels = params.get("RecordExceptionLevels")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyLiveCallbackTemplateResponse(AbstractModel):
    """ModifyLiveCallbackTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyLiveDomainCertBindingsRequest(AbstractModel):
    """ModifyLiveDomainCertBindings请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DomainInfos: 要绑定证书的播放域名/状态 信息列表。
如果CloudCertId和证书公钥私钥对均不传，且域名列表已有绑定规则，只批量更新域名https规则的启用状态，并把未上传至腾讯云ssl的已有自有证书上传。
        :type DomainInfos: list of LiveCertDomainInfo
        :param _CloudCertId: 腾讯云ssl的证书Id。
见 https://cloud.tencent.com/document/api/400/41665
        :type CloudCertId: str
        :param _CertificatePublicKey: 证书公钥。
CloudCertId和公钥私钥对二选一，若CloudCertId将会舍弃公钥和私钥参数，否则将自动先把公钥私钥对上传至ssl新建证书，并使用上传成功后返回的CloudCertId。
        :type CertificatePublicKey: str
        :param _CertificatePrivateKey: 证书私钥。
CloudCertId和公钥私钥对二选一，若传CloudCertId将会舍弃公钥和私钥参数，否则将自动先把公钥私钥对上传至ssl新建证书，并使用上传成功后返回的CloudCertId。
        :type CertificatePrivateKey: str
        :param _CertificateAlias: 上传至ssl证书中心的备注信息，只有新建证书时有效。传CloudCertId时会忽略。
        :type CertificateAlias: str
        """
        self._DomainInfos = None
        self._CloudCertId = None
        self._CertificatePublicKey = None
        self._CertificatePrivateKey = None
        self._CertificateAlias = None

    @property
    def DomainInfos(self):
        """要绑定证书的播放域名/状态 信息列表。
如果CloudCertId和证书公钥私钥对均不传，且域名列表已有绑定规则，只批量更新域名https规则的启用状态，并把未上传至腾讯云ssl的已有自有证书上传。
        :rtype: list of LiveCertDomainInfo
        """
        return self._DomainInfos

    @DomainInfos.setter
    def DomainInfos(self, DomainInfos):
        self._DomainInfos = DomainInfos

    @property
    def CloudCertId(self):
        """腾讯云ssl的证书Id。
见 https://cloud.tencent.com/document/api/400/41665
        :rtype: str
        """
        return self._CloudCertId

    @CloudCertId.setter
    def CloudCertId(self, CloudCertId):
        self._CloudCertId = CloudCertId

    @property
    def CertificatePublicKey(self):
        """证书公钥。
CloudCertId和公钥私钥对二选一，若CloudCertId将会舍弃公钥和私钥参数，否则将自动先把公钥私钥对上传至ssl新建证书，并使用上传成功后返回的CloudCertId。
        :rtype: str
        """
        return self._CertificatePublicKey

    @CertificatePublicKey.setter
    def CertificatePublicKey(self, CertificatePublicKey):
        self._CertificatePublicKey = CertificatePublicKey

    @property
    def CertificatePrivateKey(self):
        """证书私钥。
CloudCertId和公钥私钥对二选一，若传CloudCertId将会舍弃公钥和私钥参数，否则将自动先把公钥私钥对上传至ssl新建证书，并使用上传成功后返回的CloudCertId。
        :rtype: str
        """
        return self._CertificatePrivateKey

    @CertificatePrivateKey.setter
    def CertificatePrivateKey(self, CertificatePrivateKey):
        self._CertificatePrivateKey = CertificatePrivateKey

    @property
    def CertificateAlias(self):
        """上传至ssl证书中心的备注信息，只有新建证书时有效。传CloudCertId时会忽略。
        :rtype: str
        """
        return self._CertificateAlias

    @CertificateAlias.setter
    def CertificateAlias(self, CertificateAlias):
        self._CertificateAlias = CertificateAlias


    def _deserialize(self, params):
        if params.get("DomainInfos") is not None:
            self._DomainInfos = []
            for item in params.get("DomainInfos"):
                obj = LiveCertDomainInfo()
                obj._deserialize(item)
                self._DomainInfos.append(obj)
        self._CloudCertId = params.get("CloudCertId")
        self._CertificatePublicKey = params.get("CertificatePublicKey")
        self._CertificatePrivateKey = params.get("CertificatePrivateKey")
        self._CertificateAlias = params.get("CertificateAlias")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyLiveDomainCertBindingsResponse(AbstractModel):
    """ModifyLiveDomainCertBindings返回参数结构体

    """

    def __init__(self):
        r"""
        :param _MismatchedDomainNames: DomainNames 入参中，与证书不匹配的域名列表，将会跳过处理。
        :type MismatchedDomainNames: list of str
        :param _Errors: 操作失败的域名及错误码，错误信息，包括MismatchedDomainNames中的域名。
        :type Errors: list of BatchDomainOperateErrors
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._MismatchedDomainNames = None
        self._Errors = None
        self._RequestId = None

    @property
    def MismatchedDomainNames(self):
        """DomainNames 入参中，与证书不匹配的域名列表，将会跳过处理。
        :rtype: list of str
        """
        return self._MismatchedDomainNames

    @MismatchedDomainNames.setter
    def MismatchedDomainNames(self, MismatchedDomainNames):
        self._MismatchedDomainNames = MismatchedDomainNames

    @property
    def Errors(self):
        """操作失败的域名及错误码，错误信息，包括MismatchedDomainNames中的域名。
        :rtype: list of BatchDomainOperateErrors
        """
        return self._Errors

    @Errors.setter
    def Errors(self, Errors):
        self._Errors = Errors

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._MismatchedDomainNames = params.get("MismatchedDomainNames")
        if params.get("Errors") is not None:
            self._Errors = []
            for item in params.get("Errors"):
                obj = BatchDomainOperateErrors()
                obj._deserialize(item)
                self._Errors.append(obj)
        self._RequestId = params.get("RequestId")


class ModifyLiveDomainRefererRequest(AbstractModel):
    """ModifyLiveDomainReferer请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DomainName: 播放域名。
        :type DomainName: str
        :param _Enable: 是否开启当前域名的 Referer 黑白名单鉴权。
        :type Enable: int
        :param _Type: 名单类型，0：黑名单，1：白名单。
        :type Type: int
        :param _AllowEmpty: 是否允许空 Referer，0：不允许，1：允许。
        :type AllowEmpty: int
        :param _Rules: Referer 名单列表，以;分隔。
        :type Rules: str
        """
        self._DomainName = None
        self._Enable = None
        self._Type = None
        self._AllowEmpty = None
        self._Rules = None

    @property
    def DomainName(self):
        """播放域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def Enable(self):
        """是否开启当前域名的 Referer 黑白名单鉴权。
        :rtype: int
        """
        return self._Enable

    @Enable.setter
    def Enable(self, Enable):
        self._Enable = Enable

    @property
    def Type(self):
        """名单类型，0：黑名单，1：白名单。
        :rtype: int
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def AllowEmpty(self):
        """是否允许空 Referer，0：不允许，1：允许。
        :rtype: int
        """
        return self._AllowEmpty

    @AllowEmpty.setter
    def AllowEmpty(self, AllowEmpty):
        self._AllowEmpty = AllowEmpty

    @property
    def Rules(self):
        """Referer 名单列表，以;分隔。
        :rtype: str
        """
        return self._Rules

    @Rules.setter
    def Rules(self, Rules):
        self._Rules = Rules


    def _deserialize(self, params):
        self._DomainName = params.get("DomainName")
        self._Enable = params.get("Enable")
        self._Type = params.get("Type")
        self._AllowEmpty = params.get("AllowEmpty")
        self._Rules = params.get("Rules")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyLiveDomainRefererResponse(AbstractModel):
    """ModifyLiveDomainReferer返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyLivePadTemplateRequest(AbstractModel):
    """ModifyLivePadTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TemplateId: 模板id。
        :type TemplateId: int
        :param _Url: 垫片内容。
        :type Url: str
        :param _WaitDuration: 断流等待时间。
取值范围：0-30000。
单位：ms。
        :type WaitDuration: int
        :param _MaxDuration: 最大垫片时长。
取值范围：0 - 正无穷。
单位：ms。
        :type MaxDuration: int
        :param _TemplateName: 模板名称。
长度上限：255字节。
仅支持中文、英文、数字、_、-。
        :type TemplateName: str
        :param _Description: 描述信息。
长度上限：1024字节。
仅支持中文、英文、数字、_、-。
        :type Description: str
        :param _Type: 垫片内容类型： 1：图片，2：视频。 默认值：1。
        :type Type: int
        """
        self._TemplateId = None
        self._Url = None
        self._WaitDuration = None
        self._MaxDuration = None
        self._TemplateName = None
        self._Description = None
        self._Type = None

    @property
    def TemplateId(self):
        """模板id。
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId

    @property
    def Url(self):
        """垫片内容。
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def WaitDuration(self):
        """断流等待时间。
取值范围：0-30000。
单位：ms。
        :rtype: int
        """
        return self._WaitDuration

    @WaitDuration.setter
    def WaitDuration(self, WaitDuration):
        self._WaitDuration = WaitDuration

    @property
    def MaxDuration(self):
        """最大垫片时长。
取值范围：0 - 正无穷。
单位：ms。
        :rtype: int
        """
        return self._MaxDuration

    @MaxDuration.setter
    def MaxDuration(self, MaxDuration):
        self._MaxDuration = MaxDuration

    @property
    def TemplateName(self):
        """模板名称。
长度上限：255字节。
仅支持中文、英文、数字、_、-。
        :rtype: str
        """
        return self._TemplateName

    @TemplateName.setter
    def TemplateName(self, TemplateName):
        self._TemplateName = TemplateName

    @property
    def Description(self):
        """描述信息。
长度上限：1024字节。
仅支持中文、英文、数字、_、-。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Type(self):
        """垫片内容类型： 1：图片，2：视频。 默认值：1。
        :rtype: int
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        self._Url = params.get("Url")
        self._WaitDuration = params.get("WaitDuration")
        self._MaxDuration = params.get("MaxDuration")
        self._TemplateName = params.get("TemplateName")
        self._Description = params.get("Description")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyLivePadTemplateResponse(AbstractModel):
    """ModifyLivePadTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyLivePlayAuthKeyRequest(AbstractModel):
    """ModifyLivePlayAuthKey请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DomainName: 播放域名。
        :type DomainName: str
        :param _Enable: 是否启用，0：关闭，1：启用。
不传表示不修改当前值。
        :type Enable: int
        :param _AuthKey: 鉴权key。
不传表示不修改当前值。
        :type AuthKey: str
        :param _AuthDelta: 有效时间，单位：秒。
不传表示不修改当前值。
        :type AuthDelta: int
        :param _AuthBackKey: 鉴权备用key。
不传表示不修改当前值。
        :type AuthBackKey: str
        """
        self._DomainName = None
        self._Enable = None
        self._AuthKey = None
        self._AuthDelta = None
        self._AuthBackKey = None

    @property
    def DomainName(self):
        """播放域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def Enable(self):
        """是否启用，0：关闭，1：启用。
不传表示不修改当前值。
        :rtype: int
        """
        return self._Enable

    @Enable.setter
    def Enable(self, Enable):
        self._Enable = Enable

    @property
    def AuthKey(self):
        """鉴权key。
不传表示不修改当前值。
        :rtype: str
        """
        return self._AuthKey

    @AuthKey.setter
    def AuthKey(self, AuthKey):
        self._AuthKey = AuthKey

    @property
    def AuthDelta(self):
        """有效时间，单位：秒。
不传表示不修改当前值。
        :rtype: int
        """
        return self._AuthDelta

    @AuthDelta.setter
    def AuthDelta(self, AuthDelta):
        self._AuthDelta = AuthDelta

    @property
    def AuthBackKey(self):
        """鉴权备用key。
不传表示不修改当前值。
        :rtype: str
        """
        return self._AuthBackKey

    @AuthBackKey.setter
    def AuthBackKey(self, AuthBackKey):
        self._AuthBackKey = AuthBackKey


    def _deserialize(self, params):
        self._DomainName = params.get("DomainName")
        self._Enable = params.get("Enable")
        self._AuthKey = params.get("AuthKey")
        self._AuthDelta = params.get("AuthDelta")
        self._AuthBackKey = params.get("AuthBackKey")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyLivePlayAuthKeyResponse(AbstractModel):
    """ModifyLivePlayAuthKey返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyLivePlayDomainRequest(AbstractModel):
    """ModifyLivePlayDomain请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DomainName: 播放域名。
        :type DomainName: str
        :param _PlayType: 拉流域名类型。1-国内；2-全球；3-境外
        :type PlayType: int
        """
        self._DomainName = None
        self._PlayType = None

    @property
    def DomainName(self):
        """播放域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def PlayType(self):
        """拉流域名类型。1-国内；2-全球；3-境外
        :rtype: int
        """
        return self._PlayType

    @PlayType.setter
    def PlayType(self, PlayType):
        self._PlayType = PlayType


    def _deserialize(self, params):
        self._DomainName = params.get("DomainName")
        self._PlayType = params.get("PlayType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyLivePlayDomainResponse(AbstractModel):
    """ModifyLivePlayDomain返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyLivePullStreamTaskRequest(AbstractModel):
    """ModifyLivePullStreamTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务Id。
        :type TaskId: str
        :param _Operator: 操作人姓名。
        :type Operator: str
        :param _SourceUrls: 拉流源url列表。
SourceType为直播（PullLivePushLive）只可以填1个，
SourceType为点播（PullVodPushLive）可以填多个，上限30个。
        :type SourceUrls: list of str
        :param _StartTime: 开始时间。
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#I)。
        :type StartTime: str
        :param _EndTime: 结束时间，注意：
1. 结束时间必须大于开始时间；
2. 结束时间和开始时间必须大于当前时间；
3. 结束时间 和 开始时间 间隔必须小于30天。
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#I)。
        :type EndTime: str
        :param _VodLoopTimes: 点播拉流转推循环次数。
-1：无限循环，直到任务结束。
0：不循环。
>0：具体循环次数。次数和时间以先结束的为准。
注意：拉流源为点播，该配置生效。
        :type VodLoopTimes: int
        :param _VodRefreshType: 点播更新SourceUrls后的播放方式：
ImmediateNewSource：立即从更新的拉流源开始播放；
ContinueBreakPoint：从上次断流url源的断点处继续，结束后再使用新的拉流源。
注意：拉流源为点播，该配置生效。
        :type VodRefreshType: str
        :param _Status: 任务状态：
enable - 启用，
pause - 暂停。
        :type Status: str
        :param _CallbackEvents: 选择需要回调的事件（不填则回调全部）：
TaskStart：任务启动回调，
TaskExit：任务停止回调，
VodSourceFileStart：从点播源文件开始拉流回调，
VodSourceFileFinish：从点播源文件拉流结束回调，
ResetTaskConfig：任务更新回调。
        :type CallbackEvents: list of str
        :param _CallbackUrl: 自定义回调地址。
相关事件会回调到该地址。
        :type CallbackUrl: str
        :param _FileIndex: 指定播放文件索引。
注意： 从1开始，不大于SourceUrls中文件个数。
        :type FileIndex: int
        :param _OffsetTime: 指定播放文件偏移。
注意：
1. 单位：秒，配合FileIndex使用。
        :type OffsetTime: int
        :param _SpecifyTaskId: 指定任务 ID 修改任务。

注意：该自定义任务 ID 只有在创建任务时指定了，才可在此处修改时使用。否则请使用系统返回的任务 ID。
        :type SpecifyTaskId: str
        :param _ToUrl: 目标 Url。
换目标地址，会断流重推到新地址。
        :type ToUrl: str
        :param _Comment: 任务备注。
        :type Comment: str
        :param _BackupSourceType: 备源的类型：
PullLivePushLive -直播，
PullVodPushLive -点播。
注意：
1. 仅当主源类型为直播源时，备源才会生效。
2. 将该参数置为空，则可将任务去除备源信息。
3. 主直播源拉流中断时，自动使用备源进行拉流。
4. 如果备源为点播文件时，则每次轮播完点播文件就检查主源是否恢复，如果主源恢复则自动切回到主源，否则继续拉备源。
        :type BackupSourceType: str
        :param _BackupSourceUrl: 备源 URL。
只允许填一个备源 URL
        :type BackupSourceUrl: str
        :param _WatermarkList: 水印信息列表。
注意：
1. 最多支持4个不同位置的水印。
2. 水印图片 URL 请使用合法外网可访问地址。
3. 支持的水印图片格式：png，jpg等。
4. 轮播任务修改水印后，轮播到下一个文件时新水印生效。
5. 直播源任务修改水印后，水印立即生效。
6. 清除水印时，需携带该水印列表参数，内容为空数组。
7. 暂不支持动图水印。
        :type WatermarkList: list of PullPushWatermarkInfo
        :param _VodLocalMode: 点播源是否启用本地推流模式，默认0，不启用。
0 - 不启用。
1 - 启用。
注意：启用本地模式后，会将源列表中的 MP4 文件进行本地下载，优先使用本地已下载文件进行推流，提高点播源推流稳定性。使用本地下载文件推流时，会产生增值费用。
        :type VodLocalMode: int
        :param _BackupToUrl: 新的目标地址。传空值，则取消该地址的推流。
传入新值，则替换原有地址。
        :type BackupToUrl: str
        :param _BackupVodUrl: 点播垫片文件地址。注意：用于在主源拉不到时自动兜底到垫片文件，切到垫片文件后，每次播完垫片会尝试拉主源，如果主源恢复则自动切回主源。可根据需要的轮询检查时长来传入对应时长的垫片文件。
        :type BackupVodUrl: str
        """
        self._TaskId = None
        self._Operator = None
        self._SourceUrls = None
        self._StartTime = None
        self._EndTime = None
        self._VodLoopTimes = None
        self._VodRefreshType = None
        self._Status = None
        self._CallbackEvents = None
        self._CallbackUrl = None
        self._FileIndex = None
        self._OffsetTime = None
        self._SpecifyTaskId = None
        self._ToUrl = None
        self._Comment = None
        self._BackupSourceType = None
        self._BackupSourceUrl = None
        self._WatermarkList = None
        self._VodLocalMode = None
        self._BackupToUrl = None
        self._BackupVodUrl = None

    @property
    def TaskId(self):
        """任务Id。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Operator(self):
        """操作人姓名。
        :rtype: str
        """
        return self._Operator

    @Operator.setter
    def Operator(self, Operator):
        self._Operator = Operator

    @property
    def SourceUrls(self):
        """拉流源url列表。
SourceType为直播（PullLivePushLive）只可以填1个，
SourceType为点播（PullVodPushLive）可以填多个，上限30个。
        :rtype: list of str
        """
        return self._SourceUrls

    @SourceUrls.setter
    def SourceUrls(self, SourceUrls):
        self._SourceUrls = SourceUrls

    @property
    def StartTime(self):
        """开始时间。
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#I)。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束时间，注意：
1. 结束时间必须大于开始时间；
2. 结束时间和开始时间必须大于当前时间；
3. 结束时间 和 开始时间 间隔必须小于30天。
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/267/38543#I)。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def VodLoopTimes(self):
        """点播拉流转推循环次数。
-1：无限循环，直到任务结束。
0：不循环。
>0：具体循环次数。次数和时间以先结束的为准。
注意：拉流源为点播，该配置生效。
        :rtype: int
        """
        return self._VodLoopTimes

    @VodLoopTimes.setter
    def VodLoopTimes(self, VodLoopTimes):
        self._VodLoopTimes = VodLoopTimes

    @property
    def VodRefreshType(self):
        """点播更新SourceUrls后的播放方式：
ImmediateNewSource：立即从更新的拉流源开始播放；
ContinueBreakPoint：从上次断流url源的断点处继续，结束后再使用新的拉流源。
注意：拉流源为点播，该配置生效。
        :rtype: str
        """
        return self._VodRefreshType

    @VodRefreshType.setter
    def VodRefreshType(self, VodRefreshType):
        self._VodRefreshType = VodRefreshType

    @property
    def Status(self):
        """任务状态：
enable - 启用，
pause - 暂停。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def CallbackEvents(self):
        """选择需要回调的事件（不填则回调全部）：
TaskStart：任务启动回调，
TaskExit：任务停止回调，
VodSourceFileStart：从点播源文件开始拉流回调，
VodSourceFileFinish：从点播源文件拉流结束回调，
ResetTaskConfig：任务更新回调。
        :rtype: list of str
        """
        return self._CallbackEvents

    @CallbackEvents.setter
    def CallbackEvents(self, CallbackEvents):
        self._CallbackEvents = CallbackEvents

    @property
    def CallbackUrl(self):
        """自定义回调地址。
相关事件会回调到该地址。
        :rtype: str
        """
        return self._CallbackUrl

    @CallbackUrl.setter
    def CallbackUrl(self, CallbackUrl):
        self._CallbackUrl = CallbackUrl

    @property
    def FileIndex(self):
        """指定播放文件索引。
注意： 从1开始，不大于SourceUrls中文件个数。
        :rtype: int
        """
        return self._FileIndex

    @FileIndex.setter
    def FileIndex(self, FileIndex):
        self._FileIndex = FileIndex

    @property
    def OffsetTime(self):
        """指定播放文件偏移。
注意：
1. 单位：秒，配合FileIndex使用。
        :rtype: int
        """
        return self._OffsetTime

    @OffsetTime.setter
    def OffsetTime(self, OffsetTime):
        self._OffsetTime = OffsetTime

    @property
    def SpecifyTaskId(self):
        """指定任务 ID 修改任务。

注意：该自定义任务 ID 只有在创建任务时指定了，才可在此处修改时使用。否则请使用系统返回的任务 ID。
        :rtype: str
        """
        return self._SpecifyTaskId

    @SpecifyTaskId.setter
    def SpecifyTaskId(self, SpecifyTaskId):
        self._SpecifyTaskId = SpecifyTaskId

    @property
    def ToUrl(self):
        """目标 Url。
换目标地址，会断流重推到新地址。
        :rtype: str
        """
        return self._ToUrl

    @ToUrl.setter
    def ToUrl(self, ToUrl):
        self._ToUrl = ToUrl

    @property
    def Comment(self):
        """任务备注。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def BackupSourceType(self):
        """备源的类型：
PullLivePushLive -直播，
PullVodPushLive -点播。
注意：
1. 仅当主源类型为直播源时，备源才会生效。
2. 将该参数置为空，则可将任务去除备源信息。
3. 主直播源拉流中断时，自动使用备源进行拉流。
4. 如果备源为点播文件时，则每次轮播完点播文件就检查主源是否恢复，如果主源恢复则自动切回到主源，否则继续拉备源。
        :rtype: str
        """
        return self._BackupSourceType

    @BackupSourceType.setter
    def BackupSourceType(self, BackupSourceType):
        self._BackupSourceType = BackupSourceType

    @property
    def BackupSourceUrl(self):
        """备源 URL。
只允许填一个备源 URL
        :rtype: str
        """
        return self._BackupSourceUrl

    @BackupSourceUrl.setter
    def BackupSourceUrl(self, BackupSourceUrl):
        self._BackupSourceUrl = BackupSourceUrl

    @property
    def WatermarkList(self):
        """水印信息列表。
注意：
1. 最多支持4个不同位置的水印。
2. 水印图片 URL 请使用合法外网可访问地址。
3. 支持的水印图片格式：png，jpg等。
4. 轮播任务修改水印后，轮播到下一个文件时新水印生效。
5. 直播源任务修改水印后，水印立即生效。
6. 清除水印时，需携带该水印列表参数，内容为空数组。
7. 暂不支持动图水印。
        :rtype: list of PullPushWatermarkInfo
        """
        return self._WatermarkList

    @WatermarkList.setter
    def WatermarkList(self, WatermarkList):
        self._WatermarkList = WatermarkList

    @property
    def VodLocalMode(self):
        """点播源是否启用本地推流模式，默认0，不启用。
0 - 不启用。
1 - 启用。
注意：启用本地模式后，会将源列表中的 MP4 文件进行本地下载，优先使用本地已下载文件进行推流，提高点播源推流稳定性。使用本地下载文件推流时，会产生增值费用。
        :rtype: int
        """
        return self._VodLocalMode

    @VodLocalMode.setter
    def VodLocalMode(self, VodLocalMode):
        self._VodLocalMode = VodLocalMode

    @property
    def BackupToUrl(self):
        """新的目标地址。传空值，则取消该地址的推流。
传入新值，则替换原有地址。
        :rtype: str
        """
        return self._BackupToUrl

    @BackupToUrl.setter
    def BackupToUrl(self, BackupToUrl):
        self._BackupToUrl = BackupToUrl

    @property
    def BackupVodUrl(self):
        """点播垫片文件地址。注意：用于在主源拉不到时自动兜底到垫片文件，切到垫片文件后，每次播完垫片会尝试拉主源，如果主源恢复则自动切回主源。可根据需要的轮询检查时长来传入对应时长的垫片文件。
        :rtype: str
        """
        return self._BackupVodUrl

    @BackupVodUrl.setter
    def BackupVodUrl(self, BackupVodUrl):
        self._BackupVodUrl = BackupVodUrl


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Operator = params.get("Operator")
        self._SourceUrls = params.get("SourceUrls")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._VodLoopTimes = params.get("VodLoopTimes")
        self._VodRefreshType = params.get("VodRefreshType")
        self._Status = params.get("Status")
        self._CallbackEvents = params.get("CallbackEvents")
        self._CallbackUrl = params.get("CallbackUrl")
        self._FileIndex = params.get("FileIndex")
        self._OffsetTime = params.get("OffsetTime")
        self._SpecifyTaskId = params.get("SpecifyTaskId")
        self._ToUrl = params.get("ToUrl")
        self._Comment = params.get("Comment")
        self._BackupSourceType = params.get("BackupSourceType")
        self._BackupSourceUrl = params.get("BackupSourceUrl")
        if params.get("WatermarkList") is not None:
            self._WatermarkList = []
            for item in params.get("WatermarkList"):
                obj = PullPushWatermarkInfo()
                obj._deserialize(item)
                self._WatermarkList.append(obj)
        self._VodLocalMode = params.get("VodLocalMode")
        self._BackupToUrl = params.get("BackupToUrl")
        self._BackupVodUrl = params.get("BackupVodUrl")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyLivePullStreamTaskResponse(AbstractModel):
    """ModifyLivePullStreamTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyLivePushAuthKeyRequest(AbstractModel):
    """ModifyLivePushAuthKey请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DomainName: 推流域名。
        :type DomainName: str
        :param _Enable: 是否启用，0：关闭，1：启用。
不传表示不修改当前值。
        :type Enable: int
        :param _MasterAuthKey: 主鉴权key。
不传表示不修改当前值。
        :type MasterAuthKey: str
        :param _BackupAuthKey: 备鉴权key。
不传表示不修改当前值。
        :type BackupAuthKey: str
        :param _AuthDelta: 有效时间，单位：秒。
        :type AuthDelta: int
        """
        self._DomainName = None
        self._Enable = None
        self._MasterAuthKey = None
        self._BackupAuthKey = None
        self._AuthDelta = None

    @property
    def DomainName(self):
        """推流域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def Enable(self):
        """是否启用，0：关闭，1：启用。
不传表示不修改当前值。
        :rtype: int
        """
        return self._Enable

    @Enable.setter
    def Enable(self, Enable):
        self._Enable = Enable

    @property
    def MasterAuthKey(self):
        """主鉴权key。
不传表示不修改当前值。
        :rtype: str
        """
        return self._MasterAuthKey

    @MasterAuthKey.setter
    def MasterAuthKey(self, MasterAuthKey):
        self._MasterAuthKey = MasterAuthKey

    @property
    def BackupAuthKey(self):
        """备鉴权key。
不传表示不修改当前值。
        :rtype: str
        """
        return self._BackupAuthKey

    @BackupAuthKey.setter
    def BackupAuthKey(self, BackupAuthKey):
        self._BackupAuthKey = BackupAuthKey

    @property
    def AuthDelta(self):
        """有效时间，单位：秒。
        :rtype: int
        """
        return self._AuthDelta

    @AuthDelta.setter
    def AuthDelta(self, AuthDelta):
        self._AuthDelta = AuthDelta


    def _deserialize(self, params):
        self._DomainName = params.get("DomainName")
        self._Enable = params.get("Enable")
        self._MasterAuthKey = params.get("MasterAuthKey")
        self._BackupAuthKey = params.get("BackupAuthKey")
        self._AuthDelta = params.get("AuthDelta")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyLivePushAuthKeyResponse(AbstractModel):
    """ModifyLivePushAuthKey返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyLiveRecordTemplateRequest(AbstractModel):
    """ModifyLiveRecordTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TemplateId: DescribeRecordTemplates接口获取到的模板 ID。
        :type TemplateId: int
        :param _TemplateName: 模板名称。
        :type TemplateName: str
        :param _Description: 描述信息。
        :type Description: str
        :param _FlvParam: FLV 录制参数，开启 FLV 录制时设置。
        :type FlvParam: :class:`tencentcloud.live.v20180801.models.RecordParam`
        :param _HlsParam: HLS 录制参数，开启 HLS 录制时设置。
        :type HlsParam: :class:`tencentcloud.live.v20180801.models.RecordParam`
        :param _Mp4Param: MP4 录制参数，开启 MP4 录制时设置。
        :type Mp4Param: :class:`tencentcloud.live.v20180801.models.RecordParam`
        :param _AacParam: AAC 录制参数，开启 AAC 录制时设置。
        :type AacParam: :class:`tencentcloud.live.v20180801.models.RecordParam`
        :param _HlsSpecialParam: HLS 录制定制参数。
        :type HlsSpecialParam: :class:`tencentcloud.live.v20180801.models.HlsSpecialParam`
        :param _Mp3Param: MP3 录制参数，开启 MP3 录制时设置。
        :type Mp3Param: :class:`tencentcloud.live.v20180801.models.RecordParam`
        :param _RemoveWatermark: 是否去除水印，类型为慢直播时此参数无效。
        :type RemoveWatermark: bool
        :param _FlvSpecialParam: FLV 录制定制参数。
        :type FlvSpecialParam: :class:`tencentcloud.live.v20180801.models.FlvSpecialParam`
        """
        self._TemplateId = None
        self._TemplateName = None
        self._Description = None
        self._FlvParam = None
        self._HlsParam = None
        self._Mp4Param = None
        self._AacParam = None
        self._HlsSpecialParam = None
        self._Mp3Param = None
        self._RemoveWatermark = None
        self._FlvSpecialParam = None

    @property
    def TemplateId(self):
        """DescribeRecordTemplates接口获取到的模板 ID。
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId

    @property
    def TemplateName(self):
        """模板名称。
        :rtype: str
        """
        return self._TemplateName

    @TemplateName.setter
    def TemplateName(self, TemplateName):
        self._TemplateName = TemplateName

    @property
    def Description(self):
        """描述信息。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def FlvParam(self):
        """FLV 录制参数，开启 FLV 录制时设置。
        :rtype: :class:`tencentcloud.live.v20180801.models.RecordParam`
        """
        return self._FlvParam

    @FlvParam.setter
    def FlvParam(self, FlvParam):
        self._FlvParam = FlvParam

    @property
    def HlsParam(self):
        """HLS 录制参数，开启 HLS 录制时设置。
        :rtype: :class:`tencentcloud.live.v20180801.models.RecordParam`
        """
        return self._HlsParam

    @HlsParam.setter
    def HlsParam(self, HlsParam):
        self._HlsParam = HlsParam

    @property
    def Mp4Param(self):
        """MP4 录制参数，开启 MP4 录制时设置。
        :rtype: :class:`tencentcloud.live.v20180801.models.RecordParam`
        """
        return self._Mp4Param

    @Mp4Param.setter
    def Mp4Param(self, Mp4Param):
        self._Mp4Param = Mp4Param

    @property
    def AacParam(self):
        """AAC 录制参数，开启 AAC 录制时设置。
        :rtype: :class:`tencentcloud.live.v20180801.models.RecordParam`
        """
        return self._AacParam

    @AacParam.setter
    def AacParam(self, AacParam):
        self._AacParam = AacParam

    @property
    def HlsSpecialParam(self):
        """HLS 录制定制参数。
        :rtype: :class:`tencentcloud.live.v20180801.models.HlsSpecialParam`
        """
        return self._HlsSpecialParam

    @HlsSpecialParam.setter
    def HlsSpecialParam(self, HlsSpecialParam):
        self._HlsSpecialParam = HlsSpecialParam

    @property
    def Mp3Param(self):
        """MP3 录制参数，开启 MP3 录制时设置。
        :rtype: :class:`tencentcloud.live.v20180801.models.RecordParam`
        """
        return self._Mp3Param

    @Mp3Param.setter
    def Mp3Param(self, Mp3Param):
        self._Mp3Param = Mp3Param

    @property
    def RemoveWatermark(self):
        """是否去除水印，类型为慢直播时此参数无效。
        :rtype: bool
        """
        return self._RemoveWatermark

    @RemoveWatermark.setter
    def RemoveWatermark(self, RemoveWatermark):
        self._RemoveWatermark = RemoveWatermark

    @property
    def FlvSpecialParam(self):
        """FLV 录制定制参数。
        :rtype: :class:`tencentcloud.live.v20180801.models.FlvSpecialParam`
        """
        return self._FlvSpecialParam

    @FlvSpecialParam.setter
    def FlvSpecialParam(self, FlvSpecialParam):
        self._FlvSpecialParam = FlvSpecialParam


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        self._TemplateName = params.get("TemplateName")
        self._Description = params.get("Description")
        if params.get("FlvParam") is not None:
            self._FlvParam = RecordParam()
            self._FlvParam._deserialize(params.get("FlvParam"))
        if params.get("HlsParam") is not None:
            self._HlsParam = RecordParam()
            self._HlsParam._deserialize(params.get("HlsParam"))
        if params.get("Mp4Param") is not None:
            self._Mp4Param = RecordParam()
            self._Mp4Param._deserialize(params.get("Mp4Param"))
        if params.get("AacParam") is not None:
            self._AacParam = RecordParam()
            self._AacParam._deserialize(params.get("AacParam"))
        if params.get("HlsSpecialParam") is not None:
            self._HlsSpecialParam = HlsSpecialParam()
            self._HlsSpecialParam._deserialize(params.get("HlsSpecialParam"))
        if params.get("Mp3Param") is not None:
            self._Mp3Param = RecordParam()
            self._Mp3Param._deserialize(params.get("Mp3Param"))
        self._RemoveWatermark = params.get("RemoveWatermark")
        if params.get("FlvSpecialParam") is not None:
            self._FlvSpecialParam = FlvSpecialParam()
            self._FlvSpecialParam._deserialize(params.get("FlvSpecialParam"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyLiveRecordTemplateResponse(AbstractModel):
    """ModifyLiveRecordTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyLiveSnapshotTemplateRequest(AbstractModel):
    """ModifyLiveSnapshotTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TemplateId: 模板 ID。
        :type TemplateId: int
        :param _CosAppId: Cos 应用 ID。
**注：此参数现在须必选。**
        :type CosAppId: int
        :param _CosBucket: Cos Bucket名称。
注：CosBucket参数值不能包含-[appid] 部分。
**注：此参数现在须必选。**
        :type CosBucket: str
        :param _CosRegion: Cos 地域。
**注：此参数现在须必选。**
        :type CosRegion: str
        :param _TemplateName: 模板名称。
长度上限：255字节。
        :type TemplateName: str
        :param _Description: 描述信息。
长度上限：1024字节。
        :type Description: str
        :param _SnapshotInterval: 截图间隔，单位s，默认10s。
范围： 5s ~ 300s。
        :type SnapshotInterval: int
        :param _Width: 截图宽度。默认：0（原始宽）。
        :type Width: int
        :param _Height: 截图高度。默认：0（原始高）。
        :type Height: int
        :param _PornFlag: 是否开启鉴黄，默认 0 。
0：不开启。
1：开启。
        :type PornFlag: int
        :param _CosPrefix: Cos Bucket文件夹前缀。
        :type CosPrefix: str
        :param _CosFileName: Cos 文件名称。
        :type CosFileName: str
        """
        self._TemplateId = None
        self._CosAppId = None
        self._CosBucket = None
        self._CosRegion = None
        self._TemplateName = None
        self._Description = None
        self._SnapshotInterval = None
        self._Width = None
        self._Height = None
        self._PornFlag = None
        self._CosPrefix = None
        self._CosFileName = None

    @property
    def TemplateId(self):
        """模板 ID。
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId

    @property
    def CosAppId(self):
        """Cos 应用 ID。
**注：此参数现在须必选。**
        :rtype: int
        """
        return self._CosAppId

    @CosAppId.setter
    def CosAppId(self, CosAppId):
        self._CosAppId = CosAppId

    @property
    def CosBucket(self):
        """Cos Bucket名称。
注：CosBucket参数值不能包含-[appid] 部分。
**注：此参数现在须必选。**
        :rtype: str
        """
        return self._CosBucket

    @CosBucket.setter
    def CosBucket(self, CosBucket):
        self._CosBucket = CosBucket

    @property
    def CosRegion(self):
        """Cos 地域。
**注：此参数现在须必选。**
        :rtype: str
        """
        return self._CosRegion

    @CosRegion.setter
    def CosRegion(self, CosRegion):
        self._CosRegion = CosRegion

    @property
    def TemplateName(self):
        """模板名称。
长度上限：255字节。
        :rtype: str
        """
        return self._TemplateName

    @TemplateName.setter
    def TemplateName(self, TemplateName):
        self._TemplateName = TemplateName

    @property
    def Description(self):
        """描述信息。
长度上限：1024字节。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def SnapshotInterval(self):
        """截图间隔，单位s，默认10s。
范围： 5s ~ 300s。
        :rtype: int
        """
        return self._SnapshotInterval

    @SnapshotInterval.setter
    def SnapshotInterval(self, SnapshotInterval):
        self._SnapshotInterval = SnapshotInterval

    @property
    def Width(self):
        """截图宽度。默认：0（原始宽）。
        :rtype: int
        """
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        """截图高度。默认：0（原始高）。
        :rtype: int
        """
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def PornFlag(self):
        """是否开启鉴黄，默认 0 。
0：不开启。
1：开启。
        :rtype: int
        """
        return self._PornFlag

    @PornFlag.setter
    def PornFlag(self, PornFlag):
        self._PornFlag = PornFlag

    @property
    def CosPrefix(self):
        """Cos Bucket文件夹前缀。
        :rtype: str
        """
        return self._CosPrefix

    @CosPrefix.setter
    def CosPrefix(self, CosPrefix):
        self._CosPrefix = CosPrefix

    @property
    def CosFileName(self):
        """Cos 文件名称。
        :rtype: str
        """
        return self._CosFileName

    @CosFileName.setter
    def CosFileName(self, CosFileName):
        self._CosFileName = CosFileName


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        self._CosAppId = params.get("CosAppId")
        self._CosBucket = params.get("CosBucket")
        self._CosRegion = params.get("CosRegion")
        self._TemplateName = params.get("TemplateName")
        self._Description = params.get("Description")
        self._SnapshotInterval = params.get("SnapshotInterval")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._PornFlag = params.get("PornFlag")
        self._CosPrefix = params.get("CosPrefix")
        self._CosFileName = params.get("CosFileName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyLiveSnapshotTemplateResponse(AbstractModel):
    """ModifyLiveSnapshotTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyLiveStreamMonitorRequest(AbstractModel):
    """ModifyLiveStreamMonitor请求参数结构体

    """

    def __init__(self):
        r"""
        :param _MonitorId: 监播任务ID。
        :type MonitorId: str
        :param _MonitorName: 监播任务的名称。长度128字节以内（一个汉字两个字节）。
        :type MonitorName: str
        :param _OutputInfo: 监播任务输出信息。
        :type OutputInfo: :class:`tencentcloud.live.v20180801.models.LiveStreamMonitorOutputInfo`
        :param _InputList: 待监播的输入流信息。
        :type InputList: list of LiveStreamMonitorInputInfo
        :param _NotifyPolicy: 监播事件通知策略。
        :type NotifyPolicy: :class:`tencentcloud.live.v20180801.models.LiveStreamMonitorNotifyPolicy`
        :param _AsrLanguage: 智能语音识别语种：
0 关闭 1 中文 2 英文 3 日文 4 韩文。
        :type AsrLanguage: int
        :param _OcrLanguage: 智能文字识别语种：
0 关闭 1 中、英文。
        :type OcrLanguage: int
        :param _AiAsrInputIndexList: 语音识别输入流列表，1代表第一条输入流。
        :type AiAsrInputIndexList: list of int non-negative
        :param _AiOcrInputIndexList: 文字识别输入流列表，1代表第一条输入流。
        :type AiOcrInputIndexList: list of int non-negative
        :param _CheckStreamBroken: 是否开启断流检测。
        :type CheckStreamBroken: int
        :param _CheckStreamLowFrameRate: 是否开启低帧率检测。
        :type CheckStreamLowFrameRate: int
        :param _AllowMonitorReport: 是否存储监播事件到监播报告，以及是否允许查询监播报告。
        :type AllowMonitorReport: int
        :param _AiFormatDiagnose: 是否开启格式诊断。
        :type AiFormatDiagnose: int
        :param _AiQualityControl: 是否开启内容质检。
        :type AiQualityControl: int
        """
        self._MonitorId = None
        self._MonitorName = None
        self._OutputInfo = None
        self._InputList = None
        self._NotifyPolicy = None
        self._AsrLanguage = None
        self._OcrLanguage = None
        self._AiAsrInputIndexList = None
        self._AiOcrInputIndexList = None
        self._CheckStreamBroken = None
        self._CheckStreamLowFrameRate = None
        self._AllowMonitorReport = None
        self._AiFormatDiagnose = None
        self._AiQualityControl = None

    @property
    def MonitorId(self):
        """监播任务ID。
        :rtype: str
        """
        return self._MonitorId

    @MonitorId.setter
    def MonitorId(self, MonitorId):
        self._MonitorId = MonitorId

    @property
    def MonitorName(self):
        """监播任务的名称。长度128字节以内（一个汉字两个字节）。
        :rtype: str
        """
        return self._MonitorName

    @MonitorName.setter
    def MonitorName(self, MonitorName):
        self._MonitorName = MonitorName

    @property
    def OutputInfo(self):
        """监播任务输出信息。
        :rtype: :class:`tencentcloud.live.v20180801.models.LiveStreamMonitorOutputInfo`
        """
        return self._OutputInfo

    @OutputInfo.setter
    def OutputInfo(self, OutputInfo):
        self._OutputInfo = OutputInfo

    @property
    def InputList(self):
        """待监播的输入流信息。
        :rtype: list of LiveStreamMonitorInputInfo
        """
        return self._InputList

    @InputList.setter
    def InputList(self, InputList):
        self._InputList = InputList

    @property
    def NotifyPolicy(self):
        """监播事件通知策略。
        :rtype: :class:`tencentcloud.live.v20180801.models.LiveStreamMonitorNotifyPolicy`
        """
        return self._NotifyPolicy

    @NotifyPolicy.setter
    def NotifyPolicy(self, NotifyPolicy):
        self._NotifyPolicy = NotifyPolicy

    @property
    def AsrLanguage(self):
        """智能语音识别语种：
0 关闭 1 中文 2 英文 3 日文 4 韩文。
        :rtype: int
        """
        return self._AsrLanguage

    @AsrLanguage.setter
    def AsrLanguage(self, AsrLanguage):
        self._AsrLanguage = AsrLanguage

    @property
    def OcrLanguage(self):
        """智能文字识别语种：
0 关闭 1 中、英文。
        :rtype: int
        """
        return self._OcrLanguage

    @OcrLanguage.setter
    def OcrLanguage(self, OcrLanguage):
        self._OcrLanguage = OcrLanguage

    @property
    def AiAsrInputIndexList(self):
        """语音识别输入流列表，1代表第一条输入流。
        :rtype: list of int non-negative
        """
        return self._AiAsrInputIndexList

    @AiAsrInputIndexList.setter
    def AiAsrInputIndexList(self, AiAsrInputIndexList):
        self._AiAsrInputIndexList = AiAsrInputIndexList

    @property
    def AiOcrInputIndexList(self):
        """文字识别输入流列表，1代表第一条输入流。
        :rtype: list of int non-negative
        """
        return self._AiOcrInputIndexList

    @AiOcrInputIndexList.setter
    def AiOcrInputIndexList(self, AiOcrInputIndexList):
        self._AiOcrInputIndexList = AiOcrInputIndexList

    @property
    def CheckStreamBroken(self):
        """是否开启断流检测。
        :rtype: int
        """
        return self._CheckStreamBroken

    @CheckStreamBroken.setter
    def CheckStreamBroken(self, CheckStreamBroken):
        self._CheckStreamBroken = CheckStreamBroken

    @property
    def CheckStreamLowFrameRate(self):
        """是否开启低帧率检测。
        :rtype: int
        """
        return self._CheckStreamLowFrameRate

    @CheckStreamLowFrameRate.setter
    def CheckStreamLowFrameRate(self, CheckStreamLowFrameRate):
        self._CheckStreamLowFrameRate = CheckStreamLowFrameRate

    @property
    def AllowMonitorReport(self):
        """是否存储监播事件到监播报告，以及是否允许查询监播报告。
        :rtype: int
        """
        return self._AllowMonitorReport

    @AllowMonitorReport.setter
    def AllowMonitorReport(self, AllowMonitorReport):
        self._AllowMonitorReport = AllowMonitorReport

    @property
    def AiFormatDiagnose(self):
        """是否开启格式诊断。
        :rtype: int
        """
        return self._AiFormatDiagnose

    @AiFormatDiagnose.setter
    def AiFormatDiagnose(self, AiFormatDiagnose):
        self._AiFormatDiagnose = AiFormatDiagnose

    @property
    def AiQualityControl(self):
        """是否开启内容质检。
        :rtype: int
        """
        return self._AiQualityControl

    @AiQualityControl.setter
    def AiQualityControl(self, AiQualityControl):
        self._AiQualityControl = AiQualityControl


    def _deserialize(self, params):
        self._MonitorId = params.get("MonitorId")
        self._MonitorName = params.get("MonitorName")
        if params.get("OutputInfo") is not None:
            self._OutputInfo = LiveStreamMonitorOutputInfo()
            self._OutputInfo._deserialize(params.get("OutputInfo"))
        if params.get("InputList") is not None:
            self._InputList = []
            for item in params.get("InputList"):
                obj = LiveStreamMonitorInputInfo()
                obj._deserialize(item)
                self._InputList.append(obj)
        if params.get("NotifyPolicy") is not None:
            self._NotifyPolicy = LiveStreamMonitorNotifyPolicy()
            self._NotifyPolicy._deserialize(params.get("NotifyPolicy"))
        self._AsrLanguage = params.get("AsrLanguage")
        self._OcrLanguage = params.get("OcrLanguage")
        self._AiAsrInputIndexList = params.get("AiAsrInputIndexList")
        self._AiOcrInputIndexList = params.get("AiOcrInputIndexList")
        self._CheckStreamBroken = params.get("CheckStreamBroken")
        self._CheckStreamLowFrameRate = params.get("CheckStreamLowFrameRate")
        self._AllowMonitorReport = params.get("AllowMonitorReport")
        self._AiFormatDiagnose = params.get("AiFormatDiagnose")
        self._AiQualityControl = params.get("AiQualityControl")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyLiveStreamMonitorResponse(AbstractModel):
    """ModifyLiveStreamMonitor返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyLiveTimeShiftTemplateRequest(AbstractModel):
    """ModifyLiveTimeShiftTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TemplateId: 时移模板id。
        :type TemplateId: int
        :param _TemplateName: 模板名称。
仅支持中文、英文、数字、_、-。
        :type TemplateName: str
        :param _Description: 描述信息。
长度上限：1024字节。
仅支持中文、英文、数字、_、-。
        :type Description: str
        :param _Duration: 时移时长。
单位：s。
        :type Duration: int
        :param _ItemDuration: 分片时长。
可取3-10。
单位：s。
默认值：5。
        :type ItemDuration: int
        :param _RemoveWatermark: 是否去除水印。
传true则将录制原始流。
默认值：false。
        :type RemoveWatermark: bool
        :param _TranscodeTemplateIds: 转码流id列表。
此参数仅在 RemoveWatermark为false时生效。
        :type TranscodeTemplateIds: list of int
        :param _Area: 地域。
Mainland：中国大陆。
Overseas：海外及港澳台地区。
默认值：Mainland。
        :type Area: str
        """
        self._TemplateId = None
        self._TemplateName = None
        self._Description = None
        self._Duration = None
        self._ItemDuration = None
        self._RemoveWatermark = None
        self._TranscodeTemplateIds = None
        self._Area = None

    @property
    def TemplateId(self):
        """时移模板id。
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId

    @property
    def TemplateName(self):
        """模板名称。
仅支持中文、英文、数字、_、-。
        :rtype: str
        """
        return self._TemplateName

    @TemplateName.setter
    def TemplateName(self, TemplateName):
        self._TemplateName = TemplateName

    @property
    def Description(self):
        """描述信息。
长度上限：1024字节。
仅支持中文、英文、数字、_、-。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Duration(self):
        """时移时长。
单位：s。
        :rtype: int
        """
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration

    @property
    def ItemDuration(self):
        """分片时长。
可取3-10。
单位：s。
默认值：5。
        :rtype: int
        """
        return self._ItemDuration

    @ItemDuration.setter
    def ItemDuration(self, ItemDuration):
        self._ItemDuration = ItemDuration

    @property
    def RemoveWatermark(self):
        """是否去除水印。
传true则将录制原始流。
默认值：false。
        :rtype: bool
        """
        return self._RemoveWatermark

    @RemoveWatermark.setter
    def RemoveWatermark(self, RemoveWatermark):
        self._RemoveWatermark = RemoveWatermark

    @property
    def TranscodeTemplateIds(self):
        """转码流id列表。
此参数仅在 RemoveWatermark为false时生效。
        :rtype: list of int
        """
        return self._TranscodeTemplateIds

    @TranscodeTemplateIds.setter
    def TranscodeTemplateIds(self, TranscodeTemplateIds):
        self._TranscodeTemplateIds = TranscodeTemplateIds

    @property
    def Area(self):
        """地域。
Mainland：中国大陆。
Overseas：海外及港澳台地区。
默认值：Mainland。
        :rtype: str
        """
        return self._Area

    @Area.setter
    def Area(self, Area):
        self._Area = Area


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        self._TemplateName = params.get("TemplateName")
        self._Description = params.get("Description")
        self._Duration = params.get("Duration")
        self._ItemDuration = params.get("ItemDuration")
        self._RemoveWatermark = params.get("RemoveWatermark")
        self._TranscodeTemplateIds = params.get("TranscodeTemplateIds")
        self._Area = params.get("Area")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyLiveTimeShiftTemplateResponse(AbstractModel):
    """ModifyLiveTimeShiftTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyLiveTranscodeTemplateRequest(AbstractModel):
    """ModifyLiveTranscodeTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TemplateId: 模板 Id。
        :type TemplateId: int
        :param _Vcodec: 视频编码：h264/h265/origin，默认origin。

origin: 保持原始编码格式
        :type Vcodec: str
        :param _Acodec: 音频编码：aac，默认aac。
注意：当前该参数未生效，待后续支持！
        :type Acodec: str
        :param _AudioBitrate: 音频码率，默认0。
范围：0-500。
        :type AudioBitrate: int
        :param _Description: 模板描述。
        :type Description: str
        :param _VideoBitrate: 视频码率。范围：0kbps - 8000kbps。
0为保持原始码率。
注: 转码模板有码率唯一要求，最终保存的码率可能与输入码率有所差别。
        :type VideoBitrate: int
        :param _Width: 宽。0-3000。
数值必须是2的倍数，0是原始宽度
        :type Width: int
        :param _NeedVideo: 是否保留视频，0：否，1：是。默认1。
        :type NeedVideo: int
        :param _NeedAudio: 是否保留音频，0：否，1：是。默认1。
        :type NeedAudio: int
        :param _Height: 高。0-3000。
数值必须是2的倍数，0是原始宽度
        :type Height: int
        :param _Fps: 帧率，默认0。
范围0-60
        :type Fps: int
        :param _Gop: 关键帧间隔，单位：秒。
范围2-6
        :type Gop: int
        :param _Rotate: 旋转角度，默认0。
可取值：0，90，180，270
        :type Rotate: int
        :param _Profile: 编码质量：
baseline/main/high。
        :type Profile: str
        :param _BitrateToOrig: 当设置的码率>原始码率时，是否以原始码率为准。
0：否， 1：是
默认 0。
        :type BitrateToOrig: int
        :param _HeightToOrig: 当设置的高度>原始高度时，是否以原始高度为准。
0：否， 1：是
默认 0。
        :type HeightToOrig: int
        :param _FpsToOrig: 当设置的帧率>原始帧率时，是否以原始帧率为准。
0：否， 1：是
默认 0。
        :type FpsToOrig: int
        :param _AdaptBitratePercent: 极速高清视频码率压缩比。
极速高清目标码率=VideoBitrate * (1-AdaptBitratePercent)

取值范围：0.0到0.5
        :type AdaptBitratePercent: float
        :param _ShortEdgeAsHeight: 是否以短边作为高度，0：否，1：是。默认0。
        :type ShortEdgeAsHeight: int
        :param _DRMType: DRM 加密类型，可选值：fairplay、normalaes、widevine。
不传递或者为空字符串，清空之前的DRM配置。
        :type DRMType: str
        :param _DRMTracks: DRM 加密项，可选值：AUDIO、SD、HD、UHD1、UHD2，后四个为一组，同组中的内容只能选一个。
不传递或者为空字符串，清空之前的DRM配置。
        :type DRMTracks: str
        """
        self._TemplateId = None
        self._Vcodec = None
        self._Acodec = None
        self._AudioBitrate = None
        self._Description = None
        self._VideoBitrate = None
        self._Width = None
        self._NeedVideo = None
        self._NeedAudio = None
        self._Height = None
        self._Fps = None
        self._Gop = None
        self._Rotate = None
        self._Profile = None
        self._BitrateToOrig = None
        self._HeightToOrig = None
        self._FpsToOrig = None
        self._AdaptBitratePercent = None
        self._ShortEdgeAsHeight = None
        self._DRMType = None
        self._DRMTracks = None

    @property
    def TemplateId(self):
        """模板 Id。
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId

    @property
    def Vcodec(self):
        """视频编码：h264/h265/origin，默认origin。

origin: 保持原始编码格式
        :rtype: str
        """
        return self._Vcodec

    @Vcodec.setter
    def Vcodec(self, Vcodec):
        self._Vcodec = Vcodec

    @property
    def Acodec(self):
        """音频编码：aac，默认aac。
注意：当前该参数未生效，待后续支持！
        :rtype: str
        """
        return self._Acodec

    @Acodec.setter
    def Acodec(self, Acodec):
        self._Acodec = Acodec

    @property
    def AudioBitrate(self):
        """音频码率，默认0。
范围：0-500。
        :rtype: int
        """
        return self._AudioBitrate

    @AudioBitrate.setter
    def AudioBitrate(self, AudioBitrate):
        self._AudioBitrate = AudioBitrate

    @property
    def Description(self):
        """模板描述。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def VideoBitrate(self):
        """视频码率。范围：0kbps - 8000kbps。
0为保持原始码率。
注: 转码模板有码率唯一要求，最终保存的码率可能与输入码率有所差别。
        :rtype: int
        """
        return self._VideoBitrate

    @VideoBitrate.setter
    def VideoBitrate(self, VideoBitrate):
        self._VideoBitrate = VideoBitrate

    @property
    def Width(self):
        """宽。0-3000。
数值必须是2的倍数，0是原始宽度
        :rtype: int
        """
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def NeedVideo(self):
        """是否保留视频，0：否，1：是。默认1。
        :rtype: int
        """
        return self._NeedVideo

    @NeedVideo.setter
    def NeedVideo(self, NeedVideo):
        self._NeedVideo = NeedVideo

    @property
    def NeedAudio(self):
        """是否保留音频，0：否，1：是。默认1。
        :rtype: int
        """
        return self._NeedAudio

    @NeedAudio.setter
    def NeedAudio(self, NeedAudio):
        self._NeedAudio = NeedAudio

    @property
    def Height(self):
        """高。0-3000。
数值必须是2的倍数，0是原始宽度
        :rtype: int
        """
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def Fps(self):
        """帧率，默认0。
范围0-60
        :rtype: int
        """
        return self._Fps

    @Fps.setter
    def Fps(self, Fps):
        self._Fps = Fps

    @property
    def Gop(self):
        """关键帧间隔，单位：秒。
范围2-6
        :rtype: int
        """
        return self._Gop

    @Gop.setter
    def Gop(self, Gop):
        self._Gop = Gop

    @property
    def Rotate(self):
        """旋转角度，默认0。
可取值：0，90，180，270
        :rtype: int
        """
        return self._Rotate

    @Rotate.setter
    def Rotate(self, Rotate):
        self._Rotate = Rotate

    @property
    def Profile(self):
        """编码质量：
baseline/main/high。
        :rtype: str
        """
        return self._Profile

    @Profile.setter
    def Profile(self, Profile):
        self._Profile = Profile

    @property
    def BitrateToOrig(self):
        """当设置的码率>原始码率时，是否以原始码率为准。
0：否， 1：是
默认 0。
        :rtype: int
        """
        return self._BitrateToOrig

    @BitrateToOrig.setter
    def BitrateToOrig(self, BitrateToOrig):
        self._BitrateToOrig = BitrateToOrig

    @property
    def HeightToOrig(self):
        """当设置的高度>原始高度时，是否以原始高度为准。
0：否， 1：是
默认 0。
        :rtype: int
        """
        return self._HeightToOrig

    @HeightToOrig.setter
    def HeightToOrig(self, HeightToOrig):
        self._HeightToOrig = HeightToOrig

    @property
    def FpsToOrig(self):
        """当设置的帧率>原始帧率时，是否以原始帧率为准。
0：否， 1：是
默认 0。
        :rtype: int
        """
        return self._FpsToOrig

    @FpsToOrig.setter
    def FpsToOrig(self, FpsToOrig):
        self._FpsToOrig = FpsToOrig

    @property
    def AdaptBitratePercent(self):
        """极速高清视频码率压缩比。
极速高清目标码率=VideoBitrate * (1-AdaptBitratePercent)

取值范围：0.0到0.5
        :rtype: float
        """
        return self._AdaptBitratePercent

    @AdaptBitratePercent.setter
    def AdaptBitratePercent(self, AdaptBitratePercent):
        self._AdaptBitratePercent = AdaptBitratePercent

    @property
    def ShortEdgeAsHeight(self):
        """是否以短边作为高度，0：否，1：是。默认0。
        :rtype: int
        """
        return self._ShortEdgeAsHeight

    @ShortEdgeAsHeight.setter
    def ShortEdgeAsHeight(self, ShortEdgeAsHeight):
        self._ShortEdgeAsHeight = ShortEdgeAsHeight

    @property
    def DRMType(self):
        """DRM 加密类型，可选值：fairplay、normalaes、widevine。
不传递或者为空字符串，清空之前的DRM配置。
        :rtype: str
        """
        return self._DRMType

    @DRMType.setter
    def DRMType(self, DRMType):
        self._DRMType = DRMType

    @property
    def DRMTracks(self):
        """DRM 加密项，可选值：AUDIO、SD、HD、UHD1、UHD2，后四个为一组，同组中的内容只能选一个。
不传递或者为空字符串，清空之前的DRM配置。
        :rtype: str
        """
        return self._DRMTracks

    @DRMTracks.setter
    def DRMTracks(self, DRMTracks):
        self._DRMTracks = DRMTracks


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        self._Vcodec = params.get("Vcodec")
        self._Acodec = params.get("Acodec")
        self._AudioBitrate = params.get("AudioBitrate")
        self._Description = params.get("Description")
        self._VideoBitrate = params.get("VideoBitrate")
        self._Width = params.get("Width")
        self._NeedVideo = params.get("NeedVideo")
        self._NeedAudio = params.get("NeedAudio")
        self._Height = params.get("Height")
        self._Fps = params.get("Fps")
        self._Gop = params.get("Gop")
        self._Rotate = params.get("Rotate")
        self._Profile = params.get("Profile")
        self._BitrateToOrig = params.get("BitrateToOrig")
        self._HeightToOrig = params.get("HeightToOrig")
        self._FpsToOrig = params.get("FpsToOrig")
        self._AdaptBitratePercent = params.get("AdaptBitratePercent")
        self._ShortEdgeAsHeight = params.get("ShortEdgeAsHeight")
        self._DRMType = params.get("DRMType")
        self._DRMTracks = params.get("DRMTracks")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyLiveTranscodeTemplateResponse(AbstractModel):
    """ModifyLiveTranscodeTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyPullStreamConfigRequest(AbstractModel):
    """ModifyPullStreamConfig请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ConfigId: 配置 ID。
获取来源：
1. 创建拉流配置接口CreatePullStreamConfig返回的配置 ID。
2. 通过查询接口DescribePullStreamConfigs获取配置 ID。
        :type ConfigId: str
        :param _FromUrl: 源 URL，用于拉流的地址。目前可支持直播流及点播文件。
注意：
1. 多个点播 URL 之间使用空格拼接。
2. 目前上限支持10个 URL。
3. 支持拉流文件格式：FLV，RTMP，HLS，MP4。
4. 使用标准三层样式，如：http://test.com/live/stream.flv。
        :type FromUrl: str
        :param _ToUrl: 目的 URL，用于推流的地址，目前限制该目标地址为腾讯域名。
1. 仅支持 RTMP 协议。
2. 使用标准三层样式，如：http://test.com/live/stream.flv。
        :type ToUrl: str
        :param _AreaId: 区域 ID：
1-深圳。
2-上海。
3-天津。
4-中国香港。
如有改动，需同时传入IspId。
        :type AreaId: int
        :param _IspId: 运营商 ID，
1：电信。
2：移动。
3：联通。
4：其他。
AreaId为4的时候，IspId只能为其他。如有改动，需同时传入AreaId。
        :type IspId: int
        :param _StartTime: 开始时间。
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :type StartTime: str
        :param _EndTime: 结束时间，注意：
1. 结束时间必须大于开始时间；
2. 结束时间和开始时间必须大于当前时间；
3. 结束时间 和 开始时间 间隔必须小于七天。

使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :type EndTime: str
        """
        self._ConfigId = None
        self._FromUrl = None
        self._ToUrl = None
        self._AreaId = None
        self._IspId = None
        self._StartTime = None
        self._EndTime = None

    @property
    def ConfigId(self):
        """配置 ID。
获取来源：
1. 创建拉流配置接口CreatePullStreamConfig返回的配置 ID。
2. 通过查询接口DescribePullStreamConfigs获取配置 ID。
        :rtype: str
        """
        return self._ConfigId

    @ConfigId.setter
    def ConfigId(self, ConfigId):
        self._ConfigId = ConfigId

    @property
    def FromUrl(self):
        """源 URL，用于拉流的地址。目前可支持直播流及点播文件。
注意：
1. 多个点播 URL 之间使用空格拼接。
2. 目前上限支持10个 URL。
3. 支持拉流文件格式：FLV，RTMP，HLS，MP4。
4. 使用标准三层样式，如：http://test.com/live/stream.flv。
        :rtype: str
        """
        return self._FromUrl

    @FromUrl.setter
    def FromUrl(self, FromUrl):
        self._FromUrl = FromUrl

    @property
    def ToUrl(self):
        """目的 URL，用于推流的地址，目前限制该目标地址为腾讯域名。
1. 仅支持 RTMP 协议。
2. 使用标准三层样式，如：http://test.com/live/stream.flv。
        :rtype: str
        """
        return self._ToUrl

    @ToUrl.setter
    def ToUrl(self, ToUrl):
        self._ToUrl = ToUrl

    @property
    def AreaId(self):
        """区域 ID：
1-深圳。
2-上海。
3-天津。
4-中国香港。
如有改动，需同时传入IspId。
        :rtype: int
        """
        return self._AreaId

    @AreaId.setter
    def AreaId(self, AreaId):
        self._AreaId = AreaId

    @property
    def IspId(self):
        """运营商 ID，
1：电信。
2：移动。
3：联通。
4：其他。
AreaId为4的时候，IspId只能为其他。如有改动，需同时传入AreaId。
        :rtype: int
        """
        return self._IspId

    @IspId.setter
    def IspId(self, IspId):
        self._IspId = IspId

    @property
    def StartTime(self):
        """开始时间。
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束时间，注意：
1. 结束时间必须大于开始时间；
2. 结束时间和开始时间必须大于当前时间；
3. 结束时间 和 开始时间 间隔必须小于七天。

使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._ConfigId = params.get("ConfigId")
        self._FromUrl = params.get("FromUrl")
        self._ToUrl = params.get("ToUrl")
        self._AreaId = params.get("AreaId")
        self._IspId = params.get("IspId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyPullStreamConfigResponse(AbstractModel):
    """ModifyPullStreamConfig返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyPullStreamStatusRequest(AbstractModel):
    """ModifyPullStreamStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ConfigIds: 配置 ID 列表。
        :type ConfigIds: list of str
        :param _Status: 目标状态。0无效，2正在运行，4暂停。
        :type Status: str
        """
        self._ConfigIds = None
        self._Status = None

    @property
    def ConfigIds(self):
        """配置 ID 列表。
        :rtype: list of str
        """
        return self._ConfigIds

    @ConfigIds.setter
    def ConfigIds(self, ConfigIds):
        self._ConfigIds = ConfigIds

    @property
    def Status(self):
        """目标状态。0无效，2正在运行，4暂停。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._ConfigIds = params.get("ConfigIds")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyPullStreamStatusResponse(AbstractModel):
    """ModifyPullStreamStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class MonitorStreamPlayInfo(AbstractModel):
    """监控播放数据

    """

    def __init__(self):
        r"""
        :param _PlayDomain: 播放域名。
        :type PlayDomain: str
        :param _StreamName: 流id。
        :type StreamName: str
        :param _Rate: 播放码率，0表示原始码率。
        :type Rate: int
        :param _Protocol: 播放协议，可选值包括 Unknown，Flv，Hls，Rtmp，Huyap2p。
        :type Protocol: str
        :param _Bandwidth: 带宽，单位是Mbps。
        :type Bandwidth: float
        :param _Online: 在线人数，1分钟采样一个点，统计采样点的tcp链接数目。
        :type Online: int
        :param _Request: 请求数。
        :type Request: int
        """
        self._PlayDomain = None
        self._StreamName = None
        self._Rate = None
        self._Protocol = None
        self._Bandwidth = None
        self._Online = None
        self._Request = None

    @property
    def PlayDomain(self):
        """播放域名。
        :rtype: str
        """
        return self._PlayDomain

    @PlayDomain.setter
    def PlayDomain(self, PlayDomain):
        self._PlayDomain = PlayDomain

    @property
    def StreamName(self):
        """流id。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName

    @property
    def Rate(self):
        """播放码率，0表示原始码率。
        :rtype: int
        """
        return self._Rate

    @Rate.setter
    def Rate(self, Rate):
        self._Rate = Rate

    @property
    def Protocol(self):
        """播放协议，可选值包括 Unknown，Flv，Hls，Rtmp，Huyap2p。
        :rtype: str
        """
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def Bandwidth(self):
        """带宽，单位是Mbps。
        :rtype: float
        """
        return self._Bandwidth

    @Bandwidth.setter
    def Bandwidth(self, Bandwidth):
        self._Bandwidth = Bandwidth

    @property
    def Online(self):
        """在线人数，1分钟采样一个点，统计采样点的tcp链接数目。
        :rtype: int
        """
        return self._Online

    @Online.setter
    def Online(self, Online):
        self._Online = Online

    @property
    def Request(self):
        """请求数。
        :rtype: int
        """
        return self._Request

    @Request.setter
    def Request(self, Request):
        self._Request = Request


    def _deserialize(self, params):
        self._PlayDomain = params.get("PlayDomain")
        self._StreamName = params.get("StreamName")
        self._Rate = params.get("Rate")
        self._Protocol = params.get("Protocol")
        self._Bandwidth = params.get("Bandwidth")
        self._Online = params.get("Online")
        self._Request = params.get("Request")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PadStreamInfo(AbstractModel):
    """查询当前垫片流的信息

    """

    def __init__(self):
        r"""
        :param _StreamName: 流名称。
        :type StreamName: str
        :param _AppName: 应用名称。
        :type AppName: str
        :param _DomainName: 推流域名。
        :type DomainName: str
        :param _PadStreamType: 垫片流类型。
0-自动垫片；
1-手动切入垫片。
        :type PadStreamType: str
        :param _PublishTime: 垫片流开始时间。UTC时间，示例：2025-04-10T00:01:00Z。注意：该时间与北京时间相差八小时。
        :type PublishTime: str
        """
        self._StreamName = None
        self._AppName = None
        self._DomainName = None
        self._PadStreamType = None
        self._PublishTime = None

    @property
    def StreamName(self):
        """流名称。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName

    @property
    def AppName(self):
        """应用名称。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def DomainName(self):
        """推流域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def PadStreamType(self):
        """垫片流类型。
0-自动垫片；
1-手动切入垫片。
        :rtype: str
        """
        return self._PadStreamType

    @PadStreamType.setter
    def PadStreamType(self, PadStreamType):
        self._PadStreamType = PadStreamType

    @property
    def PublishTime(self):
        """垫片流开始时间。UTC时间，示例：2025-04-10T00:01:00Z。注意：该时间与北京时间相差八小时。
        :rtype: str
        """
        return self._PublishTime

    @PublishTime.setter
    def PublishTime(self, PublishTime):
        self._PublishTime = PublishTime


    def _deserialize(self, params):
        self._StreamName = params.get("StreamName")
        self._AppName = params.get("AppName")
        self._DomainName = params.get("DomainName")
        self._PadStreamType = params.get("PadStreamType")
        self._PublishTime = params.get("PublishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PadTemplate(AbstractModel):
    """直播垫片模板。

    """

    def __init__(self):
        r"""
        :param _TemplateId: 模板id。
        :type TemplateId: int
        :param _TemplateName: 模板名称。
        :type TemplateName: str
        :param _Url: 垫片内容。
        :type Url: str
        :param _CreateTime: 模板创建时间。
        :type CreateTime: str
        :param _UpdateTime: 模板修改时间。
        :type UpdateTime: str
        :param _Description: 模板描述。
        :type Description: str
        :param _WaitDuration: 断流等待时间。
取值范围：0-30000。
单位：ms。
        :type WaitDuration: int
        :param _MaxDuration: 最大垫片时长。
取值范围：0 - 正无穷。
单位：ms。
        :type MaxDuration: int
        :param _Type: 垫片内容类型： 1：图片，2：视频。 默认值：1。
        :type Type: int
        """
        self._TemplateId = None
        self._TemplateName = None
        self._Url = None
        self._CreateTime = None
        self._UpdateTime = None
        self._Description = None
        self._WaitDuration = None
        self._MaxDuration = None
        self._Type = None

    @property
    def TemplateId(self):
        """模板id。
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId

    @property
    def TemplateName(self):
        """模板名称。
        :rtype: str
        """
        return self._TemplateName

    @TemplateName.setter
    def TemplateName(self, TemplateName):
        self._TemplateName = TemplateName

    @property
    def Url(self):
        """垫片内容。
        :rtype: str
        """
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def CreateTime(self):
        """模板创建时间。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        """模板修改时间。
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def Description(self):
        """模板描述。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def WaitDuration(self):
        """断流等待时间。
取值范围：0-30000。
单位：ms。
        :rtype: int
        """
        return self._WaitDuration

    @WaitDuration.setter
    def WaitDuration(self, WaitDuration):
        self._WaitDuration = WaitDuration

    @property
    def MaxDuration(self):
        """最大垫片时长。
取值范围：0 - 正无穷。
单位：ms。
        :rtype: int
        """
        return self._MaxDuration

    @MaxDuration.setter
    def MaxDuration(self, MaxDuration):
        self._MaxDuration = MaxDuration

    @property
    def Type(self):
        """垫片内容类型： 1：图片，2：视频。 默认值：1。
        :rtype: int
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        self._TemplateName = params.get("TemplateName")
        self._Url = params.get("Url")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._Description = params.get("Description")
        self._WaitDuration = params.get("WaitDuration")
        self._MaxDuration = params.get("MaxDuration")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PlayAuthKeyInfo(AbstractModel):
    """播放鉴权key信息。

    """

    def __init__(self):
        r"""
        :param _DomainName: 域名。
        :type DomainName: str
        :param _Enable: 是否启用:
0: 关闭。
1: 启用。
        :type Enable: int
        :param _AuthKey: 鉴权 Key。
        :type AuthKey: str
        :param _AuthDelta: 有效时间，单位：秒。
        :type AuthDelta: int
        :param _AuthBackKey: 鉴权 BackKey。
        :type AuthBackKey: str
        """
        self._DomainName = None
        self._Enable = None
        self._AuthKey = None
        self._AuthDelta = None
        self._AuthBackKey = None

    @property
    def DomainName(self):
        """域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def Enable(self):
        """是否启用:
0: 关闭。
1: 启用。
        :rtype: int
        """
        return self._Enable

    @Enable.setter
    def Enable(self, Enable):
        self._Enable = Enable

    @property
    def AuthKey(self):
        """鉴权 Key。
        :rtype: str
        """
        return self._AuthKey

    @AuthKey.setter
    def AuthKey(self, AuthKey):
        self._AuthKey = AuthKey

    @property
    def AuthDelta(self):
        """有效时间，单位：秒。
        :rtype: int
        """
        return self._AuthDelta

    @AuthDelta.setter
    def AuthDelta(self, AuthDelta):
        self._AuthDelta = AuthDelta

    @property
    def AuthBackKey(self):
        """鉴权 BackKey。
        :rtype: str
        """
        return self._AuthBackKey

    @AuthBackKey.setter
    def AuthBackKey(self, AuthBackKey):
        self._AuthBackKey = AuthBackKey


    def _deserialize(self, params):
        self._DomainName = params.get("DomainName")
        self._Enable = params.get("Enable")
        self._AuthKey = params.get("AuthKey")
        self._AuthDelta = params.get("AuthDelta")
        self._AuthBackKey = params.get("AuthBackKey")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PlayCodeTotalInfo(AbstractModel):
    """各状态码的总次数，支持大多数的 HTTP 协议返回码。

    """

    def __init__(self):
        r"""
        :param _Code: HTTP code，可选值包括:
400，403，404，500，502，503，504。
        :type Code: str
        :param _Num: 总次数。
        :type Num: int
        """
        self._Code = None
        self._Num = None

    @property
    def Code(self):
        """HTTP code，可选值包括:
400，403，404，500，502，503，504。
        :rtype: str
        """
        return self._Code

    @Code.setter
    def Code(self, Code):
        self._Code = Code

    @property
    def Num(self):
        """总次数。
        :rtype: int
        """
        return self._Num

    @Num.setter
    def Num(self, Num):
        self._Num = Num


    def _deserialize(self, params):
        self._Code = params.get("Code")
        self._Num = params.get("Num")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PlayDataInfoByStream(AbstractModel):
    """流维度的播放信息。

    """

    def __init__(self):
        r"""
        :param _StreamName: 流名称。
        :type StreamName: str
        :param _TotalFlux: 总流量，单位: MB。
        :type TotalFlux: float
        """
        self._StreamName = None
        self._TotalFlux = None

    @property
    def StreamName(self):
        """流名称。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName

    @property
    def TotalFlux(self):
        """总流量，单位: MB。
        :rtype: float
        """
        return self._TotalFlux

    @TotalFlux.setter
    def TotalFlux(self, TotalFlux):
        self._TotalFlux = TotalFlux


    def _deserialize(self, params):
        self._StreamName = params.get("StreamName")
        self._TotalFlux = params.get("TotalFlux")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PlayStatInfo(AbstractModel):
    """按省份运营商查询的播放信息。

    """

    def __init__(self):
        r"""
        :param _Time: 数据时间点。
        :type Time: str
        :param _Value: 带宽/流量/请求数/并发连接数/下载速度的值，若没数据返回时该值为0。
        :type Value: float
        """
        self._Time = None
        self._Value = None

    @property
    def Time(self):
        """数据时间点。
        :rtype: str
        """
        return self._Time

    @Time.setter
    def Time(self, Time):
        self._Time = Time

    @property
    def Value(self):
        """带宽/流量/请求数/并发连接数/下载速度的值，若没数据返回时该值为0。
        :rtype: float
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value


    def _deserialize(self, params):
        self._Time = params.get("Time")
        self._Value = params.get("Value")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PlaySumStatInfo(AbstractModel):
    """播放汇总统计信息。

    """

    def __init__(self):
        r"""
        :param _Name: 域名或流 ID。
        :type Name: str
        :param _AvgFluxPerSecond: 平均下载速度，
单位: MB/s。
计算公式: 每分钟的下载速度求平均值。
        :type AvgFluxPerSecond: float
        :param _TotalFlux: 总流量，单位: MB。
        :type TotalFlux: float
        :param _TotalRequest: 总请求数。
        :type TotalRequest: int
        """
        self._Name = None
        self._AvgFluxPerSecond = None
        self._TotalFlux = None
        self._TotalRequest = None

    @property
    def Name(self):
        """域名或流 ID。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def AvgFluxPerSecond(self):
        """平均下载速度，
单位: MB/s。
计算公式: 每分钟的下载速度求平均值。
        :rtype: float
        """
        return self._AvgFluxPerSecond

    @AvgFluxPerSecond.setter
    def AvgFluxPerSecond(self, AvgFluxPerSecond):
        self._AvgFluxPerSecond = AvgFluxPerSecond

    @property
    def TotalFlux(self):
        """总流量，单位: MB。
        :rtype: float
        """
        return self._TotalFlux

    @TotalFlux.setter
    def TotalFlux(self, TotalFlux):
        self._TotalFlux = TotalFlux

    @property
    def TotalRequest(self):
        """总请求数。
        :rtype: int
        """
        return self._TotalRequest

    @TotalRequest.setter
    def TotalRequest(self, TotalRequest):
        self._TotalRequest = TotalRequest


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._AvgFluxPerSecond = params.get("AvgFluxPerSecond")
        self._TotalFlux = params.get("TotalFlux")
        self._TotalRequest = params.get("TotalRequest")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ProIspPlayCodeDataInfo(AbstractModel):
    """播放错误码信息

    """

    def __init__(self):
        r"""
        :param _CountryAreaName: 国家或地区。
        :type CountryAreaName: str
        :param _ProvinceName: 省份。
        :type ProvinceName: str
        :param _IspName: 运营商。
        :type IspName: str
        :param _Code2xx: 错误码为2开头的次数。
        :type Code2xx: int
        :param _Code3xx: 错误码为3开头的次数。
        :type Code3xx: int
        :param _Code4xx: 错误码为4开头的次数。
        :type Code4xx: int
        :param _Code5xx: 错误码为5开头的次数。
        :type Code5xx: int
        """
        self._CountryAreaName = None
        self._ProvinceName = None
        self._IspName = None
        self._Code2xx = None
        self._Code3xx = None
        self._Code4xx = None
        self._Code5xx = None

    @property
    def CountryAreaName(self):
        """国家或地区。
        :rtype: str
        """
        return self._CountryAreaName

    @CountryAreaName.setter
    def CountryAreaName(self, CountryAreaName):
        self._CountryAreaName = CountryAreaName

    @property
    def ProvinceName(self):
        """省份。
        :rtype: str
        """
        return self._ProvinceName

    @ProvinceName.setter
    def ProvinceName(self, ProvinceName):
        self._ProvinceName = ProvinceName

    @property
    def IspName(self):
        """运营商。
        :rtype: str
        """
        return self._IspName

    @IspName.setter
    def IspName(self, IspName):
        self._IspName = IspName

    @property
    def Code2xx(self):
        """错误码为2开头的次数。
        :rtype: int
        """
        return self._Code2xx

    @Code2xx.setter
    def Code2xx(self, Code2xx):
        self._Code2xx = Code2xx

    @property
    def Code3xx(self):
        """错误码为3开头的次数。
        :rtype: int
        """
        return self._Code3xx

    @Code3xx.setter
    def Code3xx(self, Code3xx):
        self._Code3xx = Code3xx

    @property
    def Code4xx(self):
        """错误码为4开头的次数。
        :rtype: int
        """
        return self._Code4xx

    @Code4xx.setter
    def Code4xx(self, Code4xx):
        self._Code4xx = Code4xx

    @property
    def Code5xx(self):
        """错误码为5开头的次数。
        :rtype: int
        """
        return self._Code5xx

    @Code5xx.setter
    def Code5xx(self, Code5xx):
        self._Code5xx = Code5xx


    def _deserialize(self, params):
        self._CountryAreaName = params.get("CountryAreaName")
        self._ProvinceName = params.get("ProvinceName")
        self._IspName = params.get("IspName")
        self._Code2xx = params.get("Code2xx")
        self._Code3xx = params.get("Code3xx")
        self._Code4xx = params.get("Code4xx")
        self._Code5xx = params.get("Code5xx")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ProIspPlaySumInfo(AbstractModel):
    """获取省份/运营商的播放信息。

    """

    def __init__(self):
        r"""
        :param _Name: 省份/运营商/国家或地区。
        :type Name: str
        :param _TotalFlux: 总流量，单位: MB。
        :type TotalFlux: float
        :param _TotalRequest: 总请求数。
        :type TotalRequest: int
        :param _AvgFluxPerSecond: 平均下载流量，单位: MB/s。
        :type AvgFluxPerSecond: float
        """
        self._Name = None
        self._TotalFlux = None
        self._TotalRequest = None
        self._AvgFluxPerSecond = None

    @property
    def Name(self):
        """省份/运营商/国家或地区。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def TotalFlux(self):
        """总流量，单位: MB。
        :rtype: float
        """
        return self._TotalFlux

    @TotalFlux.setter
    def TotalFlux(self, TotalFlux):
        self._TotalFlux = TotalFlux

    @property
    def TotalRequest(self):
        """总请求数。
        :rtype: int
        """
        return self._TotalRequest

    @TotalRequest.setter
    def TotalRequest(self, TotalRequest):
        self._TotalRequest = TotalRequest

    @property
    def AvgFluxPerSecond(self):
        """平均下载流量，单位: MB/s。
        :rtype: float
        """
        return self._AvgFluxPerSecond

    @AvgFluxPerSecond.setter
    def AvgFluxPerSecond(self, AvgFluxPerSecond):
        self._AvgFluxPerSecond = AvgFluxPerSecond


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._TotalFlux = params.get("TotalFlux")
        self._TotalRequest = params.get("TotalRequest")
        self._AvgFluxPerSecond = params.get("AvgFluxPerSecond")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PublishTime(AbstractModel):
    """推流时间。

    """

    def __init__(self):
        r"""
        :param _PublishTime: 推流时间。
UTC 格式，例如：2018-06-29T19:00:00Z。
        :type PublishTime: str
        """
        self._PublishTime = None

    @property
    def PublishTime(self):
        """推流时间。
UTC 格式，例如：2018-06-29T19:00:00Z。
        :rtype: str
        """
        return self._PublishTime

    @PublishTime.setter
    def PublishTime(self, PublishTime):
        self._PublishTime = PublishTime


    def _deserialize(self, params):
        self._PublishTime = params.get("PublishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PullPushWatermarkInfo(AbstractModel):
    """云转推水印信息。

    """

    def __init__(self):
        r"""
        :param _PictureUrl: 水印图片 URL。
URL中禁止包含的字符：
;(){}$>`#"'|
        :type PictureUrl: str
        :param _XPosition: 显示位置，X轴偏移，单位是百分比，默认 0。
        :type XPosition: int
        :param _YPosition: 显示位置，Y轴偏移，单位是百分比，默认 0。
        :type YPosition: int
        :param _Width: 水印宽度，占直播原始画面宽度百分比，建议高宽只设置一项，另外一项会自适应缩放，避免变形。默认原始宽度。
        :type Width: int
        :param _Height: 水印高度，占直播原始画面高度百分比，建议高宽只设置一项，另外一项会自适应缩放，避免变形。默认原始高度。
        :type Height: int
        :param _Location: 水印位置，默认 0。
0：左上角。
1：右上角。
2：右下角。
3：左下角。
        :type Location: int
        """
        self._PictureUrl = None
        self._XPosition = None
        self._YPosition = None
        self._Width = None
        self._Height = None
        self._Location = None

    @property
    def PictureUrl(self):
        """水印图片 URL。
URL中禁止包含的字符：
;(){}$>`#"'|
        :rtype: str
        """
        return self._PictureUrl

    @PictureUrl.setter
    def PictureUrl(self, PictureUrl):
        self._PictureUrl = PictureUrl

    @property
    def XPosition(self):
        """显示位置，X轴偏移，单位是百分比，默认 0。
        :rtype: int
        """
        return self._XPosition

    @XPosition.setter
    def XPosition(self, XPosition):
        self._XPosition = XPosition

    @property
    def YPosition(self):
        """显示位置，Y轴偏移，单位是百分比，默认 0。
        :rtype: int
        """
        return self._YPosition

    @YPosition.setter
    def YPosition(self, YPosition):
        self._YPosition = YPosition

    @property
    def Width(self):
        """水印宽度，占直播原始画面宽度百分比，建议高宽只设置一项，另外一项会自适应缩放，避免变形。默认原始宽度。
        :rtype: int
        """
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        """水印高度，占直播原始画面高度百分比，建议高宽只设置一项，另外一项会自适应缩放，避免变形。默认原始高度。
        :rtype: int
        """
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def Location(self):
        """水印位置，默认 0。
0：左上角。
1：右上角。
2：右下角。
3：左下角。
        :rtype: int
        """
        return self._Location

    @Location.setter
    def Location(self, Location):
        self._Location = Location


    def _deserialize(self, params):
        self._PictureUrl = params.get("PictureUrl")
        self._XPosition = params.get("XPosition")
        self._YPosition = params.get("YPosition")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._Location = params.get("Location")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PullStreamConfig(AbstractModel):
    """拉流配置。

    """

    def __init__(self):
        r"""
        :param _ConfigId: 拉流配置 ID。
        :type ConfigId: str
        :param _FromUrl: 源 URL。
        :type FromUrl: str
        :param _ToUrl: 目的 URL。
        :type ToUrl: str
        :param _AreaName: 区域名。
        :type AreaName: str
        :param _IspName: 运营商名。
        :type IspName: str
        :param _StartTime: 开始时间。
UTC格式时间，例如: 2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :type StartTime: str
        :param _EndTime: 结束时间。

UTC格式时间，例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :type EndTime: str
        :param _Status: 状态:
0: 无效。
1: 初始状态。
2: 正在运行。
3: 拉起失败。
4: 暂停。
        :type Status: str
        """
        self._ConfigId = None
        self._FromUrl = None
        self._ToUrl = None
        self._AreaName = None
        self._IspName = None
        self._StartTime = None
        self._EndTime = None
        self._Status = None

    @property
    def ConfigId(self):
        """拉流配置 ID。
        :rtype: str
        """
        return self._ConfigId

    @ConfigId.setter
    def ConfigId(self, ConfigId):
        self._ConfigId = ConfigId

    @property
    def FromUrl(self):
        """源 URL。
        :rtype: str
        """
        return self._FromUrl

    @FromUrl.setter
    def FromUrl(self, FromUrl):
        self._FromUrl = FromUrl

    @property
    def ToUrl(self):
        """目的 URL。
        :rtype: str
        """
        return self._ToUrl

    @ToUrl.setter
    def ToUrl(self, ToUrl):
        self._ToUrl = ToUrl

    @property
    def AreaName(self):
        """区域名。
        :rtype: str
        """
        return self._AreaName

    @AreaName.setter
    def AreaName(self, AreaName):
        self._AreaName = AreaName

    @property
    def IspName(self):
        """运营商名。
        :rtype: str
        """
        return self._IspName

    @IspName.setter
    def IspName(self, IspName):
        self._IspName = IspName

    @property
    def StartTime(self):
        """开始时间。
UTC格式时间，例如: 2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束时间。

UTC格式时间，例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Status(self):
        """状态:
0: 无效。
1: 初始状态。
2: 正在运行。
3: 拉起失败。
4: 暂停。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._ConfigId = params.get("ConfigId")
        self._FromUrl = params.get("FromUrl")
        self._ToUrl = params.get("ToUrl")
        self._AreaName = params.get("AreaName")
        self._IspName = params.get("IspName")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PullStreamTaskInfo(AbstractModel):
    """直播拉流任务信息。

    """

    def __init__(self):
        r"""
        :param _TaskId: 拉流任务Id。
        :type TaskId: str
        :param _SourceType: 拉流源的类型：
PullLivePushLive -直播，
PullVodPushLive -点播，
PullPicPushLive -图片。
        :type SourceType: str
        :param _SourceUrls: 拉流源url列表。
SourceType为直播（PullLiveToLive）只可以填1个，
SourceType为点播（PullVodToLive）可以填多个，上限10个。
        :type SourceUrls: list of str
        :param _DomainName: 推流域名。
将拉到的源推到该域名。
        :type DomainName: str
        :param _AppName: 推流路径。
将拉到的源推到该路径。
        :type AppName: str
        :param _StreamName: 流名称。
将拉到的源推到该流名称。
        :type StreamName: str
        :param _PushArgs: 推流参数。
推流携带的自定义参数。
        :type PushArgs: str
        :param _StartTime: 开始时间。
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :type StartTime: str
        :param _EndTime: 结束时间，注意：
1. 结束时间必须大于开始时间；
2. 结束时间和开始时间必须大于当前时间；
3. 结束时间 和 开始时间 间隔必须小于七天。
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :type EndTime: str
        :param _Region: 任务创建所在地域：
ap-beijing - 华北地区(北京)，
ap-shanghai -华东地区(上海)，
ap-guangzhou -华南地区(广州)，
ap-mumbai - 印度，
ap-hongkong - 香港，
eu-frankfurt - 德国，
ap-seoul - 韩国，
ap-bangkok - 泰国，
ap-singapore - 新加坡，
na-siliconvalley - 美西，
na-ashburn - 美东，
ap-tokyo - 日本。
        :type Region: str
        :param _VodLoopTimes: 点播拉流转推循环次数。
-1：无限循环，直到任务结束。
0：不循环。
>0：具体循环次数。次数和时间以先结束的为准。
注意：拉流源为点播，该配置生效。
        :type VodLoopTimes: int
        :param _VodRefreshType: 点播更新SourceUrls后的播放方式：
ImmediateNewSource：立即从更新的拉流源开始播放；
ContinueBreakPoint：从上次断流url源的断点处继续，结束后再使用新的拉流源。

注意：拉流源为点播，该配置生效。
        :type VodRefreshType: str
        :param _CreateTime: 任务创建时间。
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :type CreateTime: str
        :param _UpdateTime: 任务更新时间。
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :type UpdateTime: str
        :param _CreateBy: 创建任务的操作者。
        :type CreateBy: str
        :param _UpdateBy: 最后更新任务的操作者。
        :type UpdateBy: str
        :param _CallbackUrl: 回调地址。
        :type CallbackUrl: str
        :param _CallbackEvents: 选择需要回调的事件：
TaskStart：任务启动回调，
TaskExit：任务停止回调，
VodSourceFileStart：从点播源文件开始拉流回调，
VodSourceFileFinish：从点播源文件拉流结束回调，
ResetTaskConfig：任务更新回调。
        :type CallbackEvents: list of str
        :param _CallbackInfo: 注意：该信息暂不返回。
最后一次回调信息。
        :type CallbackInfo: str
        :param _ErrorInfo: 注意：该信息暂不返回。
错误信息。
        :type ErrorInfo: str
        :param _Status: 状态。
enable：生效中。
pause：暂停中。
        :type Status: str
        :param _RecentPullInfo: 注意：该信息仅在查询单个任务时返回。
任务最新拉流信息。
包含：源 url，偏移时间，上报时间。
        :type RecentPullInfo: :class:`tencentcloud.live.v20180801.models.RecentPullInfo`
        :param _Comment: 任务备注信息。
        :type Comment: str
        :param _BackupSourceType: 备源类型：
PullLivePushLive -直播，
PullVodPushLive -点播。
        :type BackupSourceType: str
        :param _BackupSourceUrl: 备源URL。
        :type BackupSourceUrl: str
        :param _WatermarkList: 水印信息列表。
        :type WatermarkList: list of PullPushWatermarkInfo
        :param _VodLocalMode: 点播源是否启用本地推流模式，默认0，不启用。
0 - 不启用。
1 - 启用。
        :type VodLocalMode: int
        :param _RecordTemplateId: 录制模板 ID。
        :type RecordTemplateId: str
        :param _BackupToUrl: 新增的推流地址。用于单任务推两路场景。
        :type BackupToUrl: str
        :param _TranscodeTemplateName: 直播转码模板。
        :type TranscodeTemplateName: str
        """
        self._TaskId = None
        self._SourceType = None
        self._SourceUrls = None
        self._DomainName = None
        self._AppName = None
        self._StreamName = None
        self._PushArgs = None
        self._StartTime = None
        self._EndTime = None
        self._Region = None
        self._VodLoopTimes = None
        self._VodRefreshType = None
        self._CreateTime = None
        self._UpdateTime = None
        self._CreateBy = None
        self._UpdateBy = None
        self._CallbackUrl = None
        self._CallbackEvents = None
        self._CallbackInfo = None
        self._ErrorInfo = None
        self._Status = None
        self._RecentPullInfo = None
        self._Comment = None
        self._BackupSourceType = None
        self._BackupSourceUrl = None
        self._WatermarkList = None
        self._VodLocalMode = None
        self._RecordTemplateId = None
        self._BackupToUrl = None
        self._TranscodeTemplateName = None

    @property
    def TaskId(self):
        """拉流任务Id。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def SourceType(self):
        """拉流源的类型：
PullLivePushLive -直播，
PullVodPushLive -点播，
PullPicPushLive -图片。
        :rtype: str
        """
        return self._SourceType

    @SourceType.setter
    def SourceType(self, SourceType):
        self._SourceType = SourceType

    @property
    def SourceUrls(self):
        """拉流源url列表。
SourceType为直播（PullLiveToLive）只可以填1个，
SourceType为点播（PullVodToLive）可以填多个，上限10个。
        :rtype: list of str
        """
        return self._SourceUrls

    @SourceUrls.setter
    def SourceUrls(self, SourceUrls):
        self._SourceUrls = SourceUrls

    @property
    def DomainName(self):
        """推流域名。
将拉到的源推到该域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def AppName(self):
        """推流路径。
将拉到的源推到该路径。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def StreamName(self):
        """流名称。
将拉到的源推到该流名称。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName

    @property
    def PushArgs(self):
        """推流参数。
推流携带的自定义参数。
        :rtype: str
        """
        return self._PushArgs

    @PushArgs.setter
    def PushArgs(self, PushArgs):
        self._PushArgs = PushArgs

    @property
    def StartTime(self):
        """开始时间。
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """结束时间，注意：
1. 结束时间必须大于开始时间；
2. 结束时间和开始时间必须大于当前时间；
3. 结束时间 和 开始时间 间隔必须小于七天。
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Region(self):
        """任务创建所在地域：
ap-beijing - 华北地区(北京)，
ap-shanghai -华东地区(上海)，
ap-guangzhou -华南地区(广州)，
ap-mumbai - 印度，
ap-hongkong - 香港，
eu-frankfurt - 德国，
ap-seoul - 韩国，
ap-bangkok - 泰国，
ap-singapore - 新加坡，
na-siliconvalley - 美西，
na-ashburn - 美东，
ap-tokyo - 日本。
        :rtype: str
        """
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def VodLoopTimes(self):
        """点播拉流转推循环次数。
-1：无限循环，直到任务结束。
0：不循环。
>0：具体循环次数。次数和时间以先结束的为准。
注意：拉流源为点播，该配置生效。
        :rtype: int
        """
        return self._VodLoopTimes

    @VodLoopTimes.setter
    def VodLoopTimes(self, VodLoopTimes):
        self._VodLoopTimes = VodLoopTimes

    @property
    def VodRefreshType(self):
        """点播更新SourceUrls后的播放方式：
ImmediateNewSource：立即从更新的拉流源开始播放；
ContinueBreakPoint：从上次断流url源的断点处继续，结束后再使用新的拉流源。

注意：拉流源为点播，该配置生效。
        :rtype: str
        """
        return self._VodRefreshType

    @VodRefreshType.setter
    def VodRefreshType(self, VodRefreshType):
        self._VodRefreshType = VodRefreshType

    @property
    def CreateTime(self):
        """任务创建时间。
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        """任务更新时间。
使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def CreateBy(self):
        """创建任务的操作者。
        :rtype: str
        """
        return self._CreateBy

    @CreateBy.setter
    def CreateBy(self, CreateBy):
        self._CreateBy = CreateBy

    @property
    def UpdateBy(self):
        """最后更新任务的操作者。
        :rtype: str
        """
        return self._UpdateBy

    @UpdateBy.setter
    def UpdateBy(self, UpdateBy):
        self._UpdateBy = UpdateBy

    @property
    def CallbackUrl(self):
        """回调地址。
        :rtype: str
        """
        return self._CallbackUrl

    @CallbackUrl.setter
    def CallbackUrl(self, CallbackUrl):
        self._CallbackUrl = CallbackUrl

    @property
    def CallbackEvents(self):
        """选择需要回调的事件：
TaskStart：任务启动回调，
TaskExit：任务停止回调，
VodSourceFileStart：从点播源文件开始拉流回调，
VodSourceFileFinish：从点播源文件拉流结束回调，
ResetTaskConfig：任务更新回调。
        :rtype: list of str
        """
        return self._CallbackEvents

    @CallbackEvents.setter
    def CallbackEvents(self, CallbackEvents):
        self._CallbackEvents = CallbackEvents

    @property
    def CallbackInfo(self):
        """注意：该信息暂不返回。
最后一次回调信息。
        :rtype: str
        """
        return self._CallbackInfo

    @CallbackInfo.setter
    def CallbackInfo(self, CallbackInfo):
        self._CallbackInfo = CallbackInfo

    @property
    def ErrorInfo(self):
        """注意：该信息暂不返回。
错误信息。
        :rtype: str
        """
        return self._ErrorInfo

    @ErrorInfo.setter
    def ErrorInfo(self, ErrorInfo):
        self._ErrorInfo = ErrorInfo

    @property
    def Status(self):
        """状态。
enable：生效中。
pause：暂停中。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def RecentPullInfo(self):
        """注意：该信息仅在查询单个任务时返回。
任务最新拉流信息。
包含：源 url，偏移时间，上报时间。
        :rtype: :class:`tencentcloud.live.v20180801.models.RecentPullInfo`
        """
        return self._RecentPullInfo

    @RecentPullInfo.setter
    def RecentPullInfo(self, RecentPullInfo):
        self._RecentPullInfo = RecentPullInfo

    @property
    def Comment(self):
        """任务备注信息。
        :rtype: str
        """
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def BackupSourceType(self):
        """备源类型：
PullLivePushLive -直播，
PullVodPushLive -点播。
        :rtype: str
        """
        return self._BackupSourceType

    @BackupSourceType.setter
    def BackupSourceType(self, BackupSourceType):
        self._BackupSourceType = BackupSourceType

    @property
    def BackupSourceUrl(self):
        """备源URL。
        :rtype: str
        """
        return self._BackupSourceUrl

    @BackupSourceUrl.setter
    def BackupSourceUrl(self, BackupSourceUrl):
        self._BackupSourceUrl = BackupSourceUrl

    @property
    def WatermarkList(self):
        """水印信息列表。
        :rtype: list of PullPushWatermarkInfo
        """
        return self._WatermarkList

    @WatermarkList.setter
    def WatermarkList(self, WatermarkList):
        self._WatermarkList = WatermarkList

    @property
    def VodLocalMode(self):
        """点播源是否启用本地推流模式，默认0，不启用。
0 - 不启用。
1 - 启用。
        :rtype: int
        """
        return self._VodLocalMode

    @VodLocalMode.setter
    def VodLocalMode(self, VodLocalMode):
        self._VodLocalMode = VodLocalMode

    @property
    def RecordTemplateId(self):
        """录制模板 ID。
        :rtype: str
        """
        return self._RecordTemplateId

    @RecordTemplateId.setter
    def RecordTemplateId(self, RecordTemplateId):
        self._RecordTemplateId = RecordTemplateId

    @property
    def BackupToUrl(self):
        """新增的推流地址。用于单任务推两路场景。
        :rtype: str
        """
        return self._BackupToUrl

    @BackupToUrl.setter
    def BackupToUrl(self, BackupToUrl):
        self._BackupToUrl = BackupToUrl

    @property
    def TranscodeTemplateName(self):
        """直播转码模板。
        :rtype: str
        """
        return self._TranscodeTemplateName

    @TranscodeTemplateName.setter
    def TranscodeTemplateName(self, TranscodeTemplateName):
        self._TranscodeTemplateName = TranscodeTemplateName


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._SourceType = params.get("SourceType")
        self._SourceUrls = params.get("SourceUrls")
        self._DomainName = params.get("DomainName")
        self._AppName = params.get("AppName")
        self._StreamName = params.get("StreamName")
        self._PushArgs = params.get("PushArgs")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Region = params.get("Region")
        self._VodLoopTimes = params.get("VodLoopTimes")
        self._VodRefreshType = params.get("VodRefreshType")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._CreateBy = params.get("CreateBy")
        self._UpdateBy = params.get("UpdateBy")
        self._CallbackUrl = params.get("CallbackUrl")
        self._CallbackEvents = params.get("CallbackEvents")
        self._CallbackInfo = params.get("CallbackInfo")
        self._ErrorInfo = params.get("ErrorInfo")
        self._Status = params.get("Status")
        if params.get("RecentPullInfo") is not None:
            self._RecentPullInfo = RecentPullInfo()
            self._RecentPullInfo._deserialize(params.get("RecentPullInfo"))
        self._Comment = params.get("Comment")
        self._BackupSourceType = params.get("BackupSourceType")
        self._BackupSourceUrl = params.get("BackupSourceUrl")
        if params.get("WatermarkList") is not None:
            self._WatermarkList = []
            for item in params.get("WatermarkList"):
                obj = PullPushWatermarkInfo()
                obj._deserialize(item)
                self._WatermarkList.append(obj)
        self._VodLocalMode = params.get("VodLocalMode")
        self._RecordTemplateId = params.get("RecordTemplateId")
        self._BackupToUrl = params.get("BackupToUrl")
        self._TranscodeTemplateName = params.get("TranscodeTemplateName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PushAuthKeyInfo(AbstractModel):
    """推流鉴权key信息。

    """

    def __init__(self):
        r"""
        :param _DomainName: 域名。
        :type DomainName: str
        :param _Enable: 是否启用，0：关闭，1：启用。
        :type Enable: int
        :param _MasterAuthKey: 主鉴权 Key。
        :type MasterAuthKey: str
        :param _BackupAuthKey: 备鉴权 Key。
        :type BackupAuthKey: str
        :param _AuthDelta: 有效时间，单位：秒。
        :type AuthDelta: int
        """
        self._DomainName = None
        self._Enable = None
        self._MasterAuthKey = None
        self._BackupAuthKey = None
        self._AuthDelta = None

    @property
    def DomainName(self):
        """域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def Enable(self):
        """是否启用，0：关闭，1：启用。
        :rtype: int
        """
        return self._Enable

    @Enable.setter
    def Enable(self, Enable):
        self._Enable = Enable

    @property
    def MasterAuthKey(self):
        """主鉴权 Key。
        :rtype: str
        """
        return self._MasterAuthKey

    @MasterAuthKey.setter
    def MasterAuthKey(self, MasterAuthKey):
        self._MasterAuthKey = MasterAuthKey

    @property
    def BackupAuthKey(self):
        """备鉴权 Key。
        :rtype: str
        """
        return self._BackupAuthKey

    @BackupAuthKey.setter
    def BackupAuthKey(self, BackupAuthKey):
        self._BackupAuthKey = BackupAuthKey

    @property
    def AuthDelta(self):
        """有效时间，单位：秒。
        :rtype: int
        """
        return self._AuthDelta

    @AuthDelta.setter
    def AuthDelta(self, AuthDelta):
        self._AuthDelta = AuthDelta


    def _deserialize(self, params):
        self._DomainName = params.get("DomainName")
        self._Enable = params.get("Enable")
        self._MasterAuthKey = params.get("MasterAuthKey")
        self._BackupAuthKey = params.get("BackupAuthKey")
        self._AuthDelta = params.get("AuthDelta")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PushDataInfo(AbstractModel):
    """推流数据信息

    """

    def __init__(self):
        r"""
        :param _StreamName: 流名称。
        :type StreamName: str
        :param _AppName: 推流路径。
        :type AppName: str
        :param _ClientIp: 推流客户端 IP。
        :type ClientIp: str
        :param _ServerIp: 接流服务器 IP。
        :type ServerIp: str
        :param _VideoFps: 推流视频帧率，单位: Hz。
        :type VideoFps: int
        :param _VideoSpeed: 推流视频码率，单位: bps。
        :type VideoSpeed: int
        :param _AudioFps: 推流音频帧率，单位: Hz。
        :type AudioFps: int
        :param _AudioSpeed: 推流音频码率，单位: bps。
        :type AudioSpeed: int
        :param _PushDomain: 推流域名。
        :type PushDomain: str
        :param _BeginPushTime: 推流开始时间。
        :type BeginPushTime: str
        :param _Acodec: 音频编码格式，
例："AAC"。
        :type Acodec: str
        :param _Vcodec: 视频编码格式，
例："H264"。
        :type Vcodec: str
        :param _Resolution: 分辨率。
        :type Resolution: str
        :param _AsampleRate: 采样率。
        :type AsampleRate: int
        :param _MetaAudioSpeed: metadata 中的音频码率，单位: bps。
        :type MetaAudioSpeed: int
        :param _MetaVideoSpeed: metadata 中的视频码率，单位: bps。
        :type MetaVideoSpeed: int
        :param _MetaFps: metadata 中的帧率。
        :type MetaFps: int
        """
        self._StreamName = None
        self._AppName = None
        self._ClientIp = None
        self._ServerIp = None
        self._VideoFps = None
        self._VideoSpeed = None
        self._AudioFps = None
        self._AudioSpeed = None
        self._PushDomain = None
        self._BeginPushTime = None
        self._Acodec = None
        self._Vcodec = None
        self._Resolution = None
        self._AsampleRate = None
        self._MetaAudioSpeed = None
        self._MetaVideoSpeed = None
        self._MetaFps = None

    @property
    def StreamName(self):
        """流名称。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName

    @property
    def AppName(self):
        """推流路径。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def ClientIp(self):
        """推流客户端 IP。
        :rtype: str
        """
        return self._ClientIp

    @ClientIp.setter
    def ClientIp(self, ClientIp):
        self._ClientIp = ClientIp

    @property
    def ServerIp(self):
        """接流服务器 IP。
        :rtype: str
        """
        return self._ServerIp

    @ServerIp.setter
    def ServerIp(self, ServerIp):
        self._ServerIp = ServerIp

    @property
    def VideoFps(self):
        """推流视频帧率，单位: Hz。
        :rtype: int
        """
        return self._VideoFps

    @VideoFps.setter
    def VideoFps(self, VideoFps):
        self._VideoFps = VideoFps

    @property
    def VideoSpeed(self):
        """推流视频码率，单位: bps。
        :rtype: int
        """
        return self._VideoSpeed

    @VideoSpeed.setter
    def VideoSpeed(self, VideoSpeed):
        self._VideoSpeed = VideoSpeed

    @property
    def AudioFps(self):
        """推流音频帧率，单位: Hz。
        :rtype: int
        """
        return self._AudioFps

    @AudioFps.setter
    def AudioFps(self, AudioFps):
        self._AudioFps = AudioFps

    @property
    def AudioSpeed(self):
        """推流音频码率，单位: bps。
        :rtype: int
        """
        return self._AudioSpeed

    @AudioSpeed.setter
    def AudioSpeed(self, AudioSpeed):
        self._AudioSpeed = AudioSpeed

    @property
    def PushDomain(self):
        """推流域名。
        :rtype: str
        """
        return self._PushDomain

    @PushDomain.setter
    def PushDomain(self, PushDomain):
        self._PushDomain = PushDomain

    @property
    def BeginPushTime(self):
        """推流开始时间。
        :rtype: str
        """
        return self._BeginPushTime

    @BeginPushTime.setter
    def BeginPushTime(self, BeginPushTime):
        self._BeginPushTime = BeginPushTime

    @property
    def Acodec(self):
        """音频编码格式，
例："AAC"。
        :rtype: str
        """
        return self._Acodec

    @Acodec.setter
    def Acodec(self, Acodec):
        self._Acodec = Acodec

    @property
    def Vcodec(self):
        """视频编码格式，
例："H264"。
        :rtype: str
        """
        return self._Vcodec

    @Vcodec.setter
    def Vcodec(self, Vcodec):
        self._Vcodec = Vcodec

    @property
    def Resolution(self):
        """分辨率。
        :rtype: str
        """
        return self._Resolution

    @Resolution.setter
    def Resolution(self, Resolution):
        self._Resolution = Resolution

    @property
    def AsampleRate(self):
        """采样率。
        :rtype: int
        """
        return self._AsampleRate

    @AsampleRate.setter
    def AsampleRate(self, AsampleRate):
        self._AsampleRate = AsampleRate

    @property
    def MetaAudioSpeed(self):
        """metadata 中的音频码率，单位: bps。
        :rtype: int
        """
        return self._MetaAudioSpeed

    @MetaAudioSpeed.setter
    def MetaAudioSpeed(self, MetaAudioSpeed):
        self._MetaAudioSpeed = MetaAudioSpeed

    @property
    def MetaVideoSpeed(self):
        """metadata 中的视频码率，单位: bps。
        :rtype: int
        """
        return self._MetaVideoSpeed

    @MetaVideoSpeed.setter
    def MetaVideoSpeed(self, MetaVideoSpeed):
        self._MetaVideoSpeed = MetaVideoSpeed

    @property
    def MetaFps(self):
        """metadata 中的帧率。
        :rtype: int
        """
        return self._MetaFps

    @MetaFps.setter
    def MetaFps(self, MetaFps):
        self._MetaFps = MetaFps


    def _deserialize(self, params):
        self._StreamName = params.get("StreamName")
        self._AppName = params.get("AppName")
        self._ClientIp = params.get("ClientIp")
        self._ServerIp = params.get("ServerIp")
        self._VideoFps = params.get("VideoFps")
        self._VideoSpeed = params.get("VideoSpeed")
        self._AudioFps = params.get("AudioFps")
        self._AudioSpeed = params.get("AudioSpeed")
        self._PushDomain = params.get("PushDomain")
        self._BeginPushTime = params.get("BeginPushTime")
        self._Acodec = params.get("Acodec")
        self._Vcodec = params.get("Vcodec")
        self._Resolution = params.get("Resolution")
        self._AsampleRate = params.get("AsampleRate")
        self._MetaAudioSpeed = params.get("MetaAudioSpeed")
        self._MetaVideoSpeed = params.get("MetaVideoSpeed")
        self._MetaFps = params.get("MetaFps")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PushLogInfo(AbstractModel):
    """推流域名日志信息。

    """

    def __init__(self):
        r"""
        :param _LogName: 日志名称。
        :type LogName: str
        :param _LogUrl: 日志下载地址。
        :type LogUrl: str
        :param _LogTime: 日志时间。UTC 格式，例如：2018-11-29T19:00:00Z。
注意：
1. 北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :type LogTime: str
        :param _FileSize: 文件大小，单位字节。
        :type FileSize: int
        """
        self._LogName = None
        self._LogUrl = None
        self._LogTime = None
        self._FileSize = None

    @property
    def LogName(self):
        """日志名称。
        :rtype: str
        """
        return self._LogName

    @LogName.setter
    def LogName(self, LogName):
        self._LogName = LogName

    @property
    def LogUrl(self):
        """日志下载地址。
        :rtype: str
        """
        return self._LogUrl

    @LogUrl.setter
    def LogUrl(self, LogUrl):
        self._LogUrl = LogUrl

    @property
    def LogTime(self):
        """日志时间。UTC 格式，例如：2018-11-29T19:00:00Z。
注意：
1. 北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._LogTime

    @LogTime.setter
    def LogTime(self, LogTime):
        self._LogTime = LogTime

    @property
    def FileSize(self):
        """文件大小，单位字节。
        :rtype: int
        """
        return self._FileSize

    @FileSize.setter
    def FileSize(self, FileSize):
        self._FileSize = FileSize


    def _deserialize(self, params):
        self._LogName = params.get("LogName")
        self._LogUrl = params.get("LogUrl")
        self._LogTime = params.get("LogTime")
        self._FileSize = params.get("FileSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PushQualityData(AbstractModel):
    """某条流的推流质量详情数据。

    """

    def __init__(self):
        r"""
        :param _Time: 数据时间，使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :type Time: str
        :param _PushDomain: 推流域名。
        :type PushDomain: str
        :param _AppName: 推流路径。
        :type AppName: str
        :param _ClientIp: 推流客户端 IP。
        :type ClientIp: str
        :param _BeginPushTime: 开始推流时间，格式: %Y-%m-%d %H:%M:%S.%ms，精确到毫秒级。
        :type BeginPushTime: str
        :param _Resolution: 分辨率信息。
        :type Resolution: str
        :param _VCodec: 视频编码格式。
        :type VCodec: str
        :param _ACodec: 音频编码格式。
        :type ACodec: str
        :param _Sequence: 推流序列号，用来唯一的标志一次推流。
        :type Sequence: str
        :param _VideoFps: 视频帧率。
        :type VideoFps: int
        :param _VideoRate: 视频码率，单位: bps。
        :type VideoRate: int
        :param _AudioFps: 音频帧率。
        :type AudioFps: int
        :param _AudioRate: 音频码率，单位: bps。
        :type AudioRate: int
        :param _LocalTs: 本地流逝时间，单位: ms，音视频流逝时间与本地流逝时间的差距越大表示推流质量越差，上行卡顿越严重。
        :type LocalTs: int
        :param _VideoTs: 视频流逝时间，单位: ms。
        :type VideoTs: int
        :param _AudioTs: 音频流逝时间，单位: ms。
        :type AudioTs: int
        :param _MetaVideoRate: metadata 中的视频码率，单位: kbps。
        :type MetaVideoRate: int
        :param _MetaAudioRate: metadata 中的音频码率，单位: kbps。
        :type MetaAudioRate: int
        :param _MateFps: metadata 中的帧率。
        :type MateFps: int
        :param _StreamParam: 推流参数
        :type StreamParam: str
        :param _Bandwidth: 带宽，单位Mbps。
        :type Bandwidth: float
        :param _Flux: 流量，单位MB。
        :type Flux: float
        :param _ServerIp: 推流服务端 IP。
        :type ServerIp: str
        :param _GopSize: 关键帧间隔 GOP ，单位：ms。
        :type GopSize: int
        """
        self._Time = None
        self._PushDomain = None
        self._AppName = None
        self._ClientIp = None
        self._BeginPushTime = None
        self._Resolution = None
        self._VCodec = None
        self._ACodec = None
        self._Sequence = None
        self._VideoFps = None
        self._VideoRate = None
        self._AudioFps = None
        self._AudioRate = None
        self._LocalTs = None
        self._VideoTs = None
        self._AudioTs = None
        self._MetaVideoRate = None
        self._MetaAudioRate = None
        self._MateFps = None
        self._StreamParam = None
        self._Bandwidth = None
        self._Flux = None
        self._ServerIp = None
        self._GopSize = None

    @property
    def Time(self):
        """数据时间，使用UTC格式时间，
例如：2019-01-08T10:00:00Z。
注意：北京时间值为 UTC 时间值 + 8 小时，格式按照 ISO 8601 标准表示，详见 [ISO 日期格式说明](https://cloud.tencent.com/document/product/266/11732#I)。
        :rtype: str
        """
        return self._Time

    @Time.setter
    def Time(self, Time):
        self._Time = Time

    @property
    def PushDomain(self):
        """推流域名。
        :rtype: str
        """
        return self._PushDomain

    @PushDomain.setter
    def PushDomain(self, PushDomain):
        self._PushDomain = PushDomain

    @property
    def AppName(self):
        """推流路径。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def ClientIp(self):
        """推流客户端 IP。
        :rtype: str
        """
        return self._ClientIp

    @ClientIp.setter
    def ClientIp(self, ClientIp):
        self._ClientIp = ClientIp

    @property
    def BeginPushTime(self):
        """开始推流时间，格式: %Y-%m-%d %H:%M:%S.%ms，精确到毫秒级。
        :rtype: str
        """
        return self._BeginPushTime

    @BeginPushTime.setter
    def BeginPushTime(self, BeginPushTime):
        self._BeginPushTime = BeginPushTime

    @property
    def Resolution(self):
        """分辨率信息。
        :rtype: str
        """
        return self._Resolution

    @Resolution.setter
    def Resolution(self, Resolution):
        self._Resolution = Resolution

    @property
    def VCodec(self):
        """视频编码格式。
        :rtype: str
        """
        return self._VCodec

    @VCodec.setter
    def VCodec(self, VCodec):
        self._VCodec = VCodec

    @property
    def ACodec(self):
        """音频编码格式。
        :rtype: str
        """
        return self._ACodec

    @ACodec.setter
    def ACodec(self, ACodec):
        self._ACodec = ACodec

    @property
    def Sequence(self):
        """推流序列号，用来唯一的标志一次推流。
        :rtype: str
        """
        return self._Sequence

    @Sequence.setter
    def Sequence(self, Sequence):
        self._Sequence = Sequence

    @property
    def VideoFps(self):
        """视频帧率。
        :rtype: int
        """
        return self._VideoFps

    @VideoFps.setter
    def VideoFps(self, VideoFps):
        self._VideoFps = VideoFps

    @property
    def VideoRate(self):
        """视频码率，单位: bps。
        :rtype: int
        """
        return self._VideoRate

    @VideoRate.setter
    def VideoRate(self, VideoRate):
        self._VideoRate = VideoRate

    @property
    def AudioFps(self):
        """音频帧率。
        :rtype: int
        """
        return self._AudioFps

    @AudioFps.setter
    def AudioFps(self, AudioFps):
        self._AudioFps = AudioFps

    @property
    def AudioRate(self):
        """音频码率，单位: bps。
        :rtype: int
        """
        return self._AudioRate

    @AudioRate.setter
    def AudioRate(self, AudioRate):
        self._AudioRate = AudioRate

    @property
    def LocalTs(self):
        """本地流逝时间，单位: ms，音视频流逝时间与本地流逝时间的差距越大表示推流质量越差，上行卡顿越严重。
        :rtype: int
        """
        return self._LocalTs

    @LocalTs.setter
    def LocalTs(self, LocalTs):
        self._LocalTs = LocalTs

    @property
    def VideoTs(self):
        """视频流逝时间，单位: ms。
        :rtype: int
        """
        return self._VideoTs

    @VideoTs.setter
    def VideoTs(self, VideoTs):
        self._VideoTs = VideoTs

    @property
    def AudioTs(self):
        """音频流逝时间，单位: ms。
        :rtype: int
        """
        return self._AudioTs

    @AudioTs.setter
    def AudioTs(self, AudioTs):
        self._AudioTs = AudioTs

    @property
    def MetaVideoRate(self):
        """metadata 中的视频码率，单位: kbps。
        :rtype: int
        """
        return self._MetaVideoRate

    @MetaVideoRate.setter
    def MetaVideoRate(self, MetaVideoRate):
        self._MetaVideoRate = MetaVideoRate

    @property
    def MetaAudioRate(self):
        """metadata 中的音频码率，单位: kbps。
        :rtype: int
        """
        return self._MetaAudioRate

    @MetaAudioRate.setter
    def MetaAudioRate(self, MetaAudioRate):
        self._MetaAudioRate = MetaAudioRate

    @property
    def MateFps(self):
        """metadata 中的帧率。
        :rtype: int
        """
        return self._MateFps

    @MateFps.setter
    def MateFps(self, MateFps):
        self._MateFps = MateFps

    @property
    def StreamParam(self):
        """推流参数
        :rtype: str
        """
        return self._StreamParam

    @StreamParam.setter
    def StreamParam(self, StreamParam):
        self._StreamParam = StreamParam

    @property
    def Bandwidth(self):
        """带宽，单位Mbps。
        :rtype: float
        """
        return self._Bandwidth

    @Bandwidth.setter
    def Bandwidth(self, Bandwidth):
        self._Bandwidth = Bandwidth

    @property
    def Flux(self):
        """流量，单位MB。
        :rtype: float
        """
        return self._Flux

    @Flux.setter
    def Flux(self, Flux):
        self._Flux = Flux

    @property
    def ServerIp(self):
        """推流服务端 IP。
        :rtype: str
        """
        return self._ServerIp

    @ServerIp.setter
    def ServerIp(self, ServerIp):
        self._ServerIp = ServerIp

    @property
    def GopSize(self):
        """关键帧间隔 GOP ，单位：ms。
        :rtype: int
        """
        return self._GopSize

    @GopSize.setter
    def GopSize(self, GopSize):
        self._GopSize = GopSize


    def _deserialize(self, params):
        self._Time = params.get("Time")
        self._PushDomain = params.get("PushDomain")
        self._AppName = params.get("AppName")
        self._ClientIp = params.get("ClientIp")
        self._BeginPushTime = params.get("BeginPushTime")
        self._Resolution = params.get("Resolution")
        self._VCodec = params.get("VCodec")
        self._ACodec = params.get("ACodec")
        self._Sequence = params.get("Sequence")
        self._VideoFps = params.get("VideoFps")
        self._VideoRate = params.get("VideoRate")
        self._AudioFps = params.get("AudioFps")
        self._AudioRate = params.get("AudioRate")
        self._LocalTs = params.get("LocalTs")
        self._VideoTs = params.get("VideoTs")
        self._AudioTs = params.get("AudioTs")
        self._MetaVideoRate = params.get("MetaVideoRate")
        self._MetaAudioRate = params.get("MetaAudioRate")
        self._MateFps = params.get("MateFps")
        self._StreamParam = params.get("StreamParam")
        self._Bandwidth = params.get("Bandwidth")
        self._Flux = params.get("Flux")
        self._ServerIp = params.get("ServerIp")
        self._GopSize = params.get("GopSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RecentPullInfo(AbstractModel):
    """直播拉流当前正在拉的文件信息。

    """

    def __init__(self):
        r"""
        :param _FileUrl: 当前正在拉的文件地址。
        :type FileUrl: str
        :param _OffsetTime: 当前正在拉的文件偏移，单位：秒。
        :type OffsetTime: int
        :param _ReportTime: 最新上报偏移信息时间。UTC格式。
如：2020-07-23T03:20:39Z。
注意：与北京时间相差八小时。
        :type ReportTime: str
        :param _LoopedTimes: 已经轮播的次数。
        :type LoopedTimes: int
        """
        self._FileUrl = None
        self._OffsetTime = None
        self._ReportTime = None
        self._LoopedTimes = None

    @property
    def FileUrl(self):
        """当前正在拉的文件地址。
        :rtype: str
        """
        return self._FileUrl

    @FileUrl.setter
    def FileUrl(self, FileUrl):
        self._FileUrl = FileUrl

    @property
    def OffsetTime(self):
        """当前正在拉的文件偏移，单位：秒。
        :rtype: int
        """
        return self._OffsetTime

    @OffsetTime.setter
    def OffsetTime(self, OffsetTime):
        self._OffsetTime = OffsetTime

    @property
    def ReportTime(self):
        """最新上报偏移信息时间。UTC格式。
如：2020-07-23T03:20:39Z。
注意：与北京时间相差八小时。
        :rtype: str
        """
        return self._ReportTime

    @ReportTime.setter
    def ReportTime(self, ReportTime):
        self._ReportTime = ReportTime

    @property
    def LoopedTimes(self):
        """已经轮播的次数。
        :rtype: int
        """
        return self._LoopedTimes

    @LoopedTimes.setter
    def LoopedTimes(self, LoopedTimes):
        self._LoopedTimes = LoopedTimes


    def _deserialize(self, params):
        self._FileUrl = params.get("FileUrl")
        self._OffsetTime = params.get("OffsetTime")
        self._ReportTime = params.get("ReportTime")
        self._LoopedTimes = params.get("LoopedTimes")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RecordParam(AbstractModel):
    """录制模板参数。

    """

    def __init__(self):
        r"""
        :param _RecordInterval: 录制间隔。
单位秒，默认：1800。
取值范围：30-7200。
此参数对 HLS 无效，当录制 HLS 时从推流到断流生成一个文件。
        :type RecordInterval: int
        :param _StorageTime: 录制存储时长。
单位秒，取值范围： 0 - 1500天。
0：表示永久存储。
        :type StorageTime: int
        :param _Enable: 是否开启当前格式录制，默认值为0，0：否， 1：是。
        :type Enable: int
        :param _VodSubAppId: 点播子应用 ID。
        :type VodSubAppId: int
        :param _VodFileName: 录制文件名。
支持的特殊占位符有：
{StreamID}: 流ID
{StartYear}: 开始时间-年
{StartMonth}: 开始时间-月
{StartDay}: 开始时间-日
{StartHour}: 开始时间-小时
{StartMinute}: 开始时间-分钟
{StartSecond}: 开始时间-秒
{StartMillisecond}: 开始时间-毫秒
{EndYear}: 结束时间-年
{EndMonth}: 结束时间-月
{EndDay}: 结束时间-日
{EndHour}: 结束时间-小时
{EndMinute}: 结束时间-分钟
{EndSecond}: 结束时间-秒
{EndMillisecond}: 结束时间-毫秒

若未设置默认录制文件名为{StreamID}_{StartYear}-{StartMonth}-{StartDay}-{StartHour}-{StartMinute}-{StartSecond}_{EndYear}-{EndMonth}-{EndDay}-{EndHour}-{EndMinute}-{EndSecond}
        :type VodFileName: str
        :param _Procedure: 任务流
注意：此字段可能返回 null，表示取不到有效值。
        :type Procedure: str
        :param _StorageMode: 视频存储策略。
normal：标准存储。
cold：低频存储。
注意：此字段可能返回 null，表示取不到有效值。
        :type StorageMode: str
        :param _ClassId: 点播应用分类
注意：此字段可能返回 null，表示取不到有效值。
        :type ClassId: int
        :param _CosBucketName: 存储至 cos 的 bucket 桶名称。
注：CosBucketName参数值不能包含-[appid] 部分。
注意：此字段可能返回 null，表示取不到有效值。
        :type CosBucketName: str
        :param _CosBucketRegion: 存储至 cos 的 bucket 区域。
注意：此字段可能返回 null，表示取不到有效值。
        :type CosBucketRegion: str
        :param _CosBucketPath: 存储至 cos 的 bucket 路径。
注意：此字段可能返回 null，表示取不到有效值。
        :type CosBucketPath: str
        """
        self._RecordInterval = None
        self._StorageTime = None
        self._Enable = None
        self._VodSubAppId = None
        self._VodFileName = None
        self._Procedure = None
        self._StorageMode = None
        self._ClassId = None
        self._CosBucketName = None
        self._CosBucketRegion = None
        self._CosBucketPath = None

    @property
    def RecordInterval(self):
        """录制间隔。
单位秒，默认：1800。
取值范围：30-7200。
此参数对 HLS 无效，当录制 HLS 时从推流到断流生成一个文件。
        :rtype: int
        """
        return self._RecordInterval

    @RecordInterval.setter
    def RecordInterval(self, RecordInterval):
        self._RecordInterval = RecordInterval

    @property
    def StorageTime(self):
        """录制存储时长。
单位秒，取值范围： 0 - 1500天。
0：表示永久存储。
        :rtype: int
        """
        return self._StorageTime

    @StorageTime.setter
    def StorageTime(self, StorageTime):
        self._StorageTime = StorageTime

    @property
    def Enable(self):
        """是否开启当前格式录制，默认值为0，0：否， 1：是。
        :rtype: int
        """
        return self._Enable

    @Enable.setter
    def Enable(self, Enable):
        self._Enable = Enable

    @property
    def VodSubAppId(self):
        """点播子应用 ID。
        :rtype: int
        """
        return self._VodSubAppId

    @VodSubAppId.setter
    def VodSubAppId(self, VodSubAppId):
        self._VodSubAppId = VodSubAppId

    @property
    def VodFileName(self):
        """录制文件名。
支持的特殊占位符有：
{StreamID}: 流ID
{StartYear}: 开始时间-年
{StartMonth}: 开始时间-月
{StartDay}: 开始时间-日
{StartHour}: 开始时间-小时
{StartMinute}: 开始时间-分钟
{StartSecond}: 开始时间-秒
{StartMillisecond}: 开始时间-毫秒
{EndYear}: 结束时间-年
{EndMonth}: 结束时间-月
{EndDay}: 结束时间-日
{EndHour}: 结束时间-小时
{EndMinute}: 结束时间-分钟
{EndSecond}: 结束时间-秒
{EndMillisecond}: 结束时间-毫秒

若未设置默认录制文件名为{StreamID}_{StartYear}-{StartMonth}-{StartDay}-{StartHour}-{StartMinute}-{StartSecond}_{EndYear}-{EndMonth}-{EndDay}-{EndHour}-{EndMinute}-{EndSecond}
        :rtype: str
        """
        return self._VodFileName

    @VodFileName.setter
    def VodFileName(self, VodFileName):
        self._VodFileName = VodFileName

    @property
    def Procedure(self):
        """任务流
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Procedure

    @Procedure.setter
    def Procedure(self, Procedure):
        self._Procedure = Procedure

    @property
    def StorageMode(self):
        """视频存储策略。
normal：标准存储。
cold：低频存储。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._StorageMode

    @StorageMode.setter
    def StorageMode(self, StorageMode):
        self._StorageMode = StorageMode

    @property
    def ClassId(self):
        """点播应用分类
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._ClassId

    @ClassId.setter
    def ClassId(self, ClassId):
        self._ClassId = ClassId

    @property
    def CosBucketName(self):
        """存储至 cos 的 bucket 桶名称。
注：CosBucketName参数值不能包含-[appid] 部分。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CosBucketName

    @CosBucketName.setter
    def CosBucketName(self, CosBucketName):
        self._CosBucketName = CosBucketName

    @property
    def CosBucketRegion(self):
        """存储至 cos 的 bucket 区域。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CosBucketRegion

    @CosBucketRegion.setter
    def CosBucketRegion(self, CosBucketRegion):
        self._CosBucketRegion = CosBucketRegion

    @property
    def CosBucketPath(self):
        """存储至 cos 的 bucket 路径。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CosBucketPath

    @CosBucketPath.setter
    def CosBucketPath(self, CosBucketPath):
        self._CosBucketPath = CosBucketPath


    def _deserialize(self, params):
        self._RecordInterval = params.get("RecordInterval")
        self._StorageTime = params.get("StorageTime")
        self._Enable = params.get("Enable")
        self._VodSubAppId = params.get("VodSubAppId")
        self._VodFileName = params.get("VodFileName")
        self._Procedure = params.get("Procedure")
        self._StorageMode = params.get("StorageMode")
        self._ClassId = params.get("ClassId")
        self._CosBucketName = params.get("CosBucketName")
        self._CosBucketRegion = params.get("CosBucketRegion")
        self._CosBucketPath = params.get("CosBucketPath")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RecordTask(AbstractModel):
    """录制任务

    """

    def __init__(self):
        r"""
        :param _TaskId: 录制任务ID。
        :type TaskId: str
        :param _DomainName: 推流域名。
        :type DomainName: str
        :param _AppName: 推流路径。
        :type AppName: str
        :param _StreamName: 流名称。
        :type StreamName: str
        :param _StartTime: 任务开始时间，Unix时间戳。
        :type StartTime: int
        :param _EndTime: 任务结束时间，Unix时间戳。
        :type EndTime: int
        :param _TemplateId: 录制模板ID。
        :type TemplateId: int
        :param _Stopped: 调用 StopRecordTask 停止任务时间，Unix时间戳。值为0表示未曾调用接口停止任务。
        :type Stopped: int
        """
        self._TaskId = None
        self._DomainName = None
        self._AppName = None
        self._StreamName = None
        self._StartTime = None
        self._EndTime = None
        self._TemplateId = None
        self._Stopped = None

    @property
    def TaskId(self):
        """录制任务ID。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def DomainName(self):
        """推流域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def AppName(self):
        """推流路径。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def StreamName(self):
        """流名称。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName

    @property
    def StartTime(self):
        """任务开始时间，Unix时间戳。
        :rtype: int
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """任务结束时间，Unix时间戳。
        :rtype: int
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def TemplateId(self):
        """录制模板ID。
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId

    @property
    def Stopped(self):
        """调用 StopRecordTask 停止任务时间，Unix时间戳。值为0表示未曾调用接口停止任务。
        :rtype: int
        """
        return self._Stopped

    @Stopped.setter
    def Stopped(self, Stopped):
        self._Stopped = Stopped


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._DomainName = params.get("DomainName")
        self._AppName = params.get("AppName")
        self._StreamName = params.get("StreamName")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._TemplateId = params.get("TemplateId")
        self._Stopped = params.get("Stopped")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RecordTemplateInfo(AbstractModel):
    """录制模板信息

    """

    def __init__(self):
        r"""
        :param _TemplateId: 模板 ID。
        :type TemplateId: int
        :param _TemplateName: 模板名称。
        :type TemplateName: str
        :param _Description: 描述信息。
        :type Description: str
        :param _FlvParam: FLV 录制参数。
        :type FlvParam: :class:`tencentcloud.live.v20180801.models.RecordParam`
        :param _HlsParam: HLS 录制参数。
        :type HlsParam: :class:`tencentcloud.live.v20180801.models.RecordParam`
        :param _Mp4Param: MP4 录制参数。
        :type Mp4Param: :class:`tencentcloud.live.v20180801.models.RecordParam`
        :param _AacParam: AAC 录制参数。
        :type AacParam: :class:`tencentcloud.live.v20180801.models.RecordParam`
        :param _IsDelayLive: 0：普通直播，
1：慢直播。
        :type IsDelayLive: int
        :param _HlsSpecialParam: HLS 录制定制参数。
        :type HlsSpecialParam: :class:`tencentcloud.live.v20180801.models.HlsSpecialParam`
        :param _Mp3Param: MP3 录制参数。
        :type Mp3Param: :class:`tencentcloud.live.v20180801.models.RecordParam`
        :param _RemoveWatermark: 是否去除水印。
注意：此字段可能返回 null，表示取不到有效值。
        :type RemoveWatermark: bool
        :param _CosStore: 是否存储至cos
注意：此字段可能返回 null，表示取不到有效值。
        :type CosStore: int
        :param _FlvSpecialParam: FLV 录制定制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :type FlvSpecialParam: :class:`tencentcloud.live.v20180801.models.FlvSpecialParam`
        """
        self._TemplateId = None
        self._TemplateName = None
        self._Description = None
        self._FlvParam = None
        self._HlsParam = None
        self._Mp4Param = None
        self._AacParam = None
        self._IsDelayLive = None
        self._HlsSpecialParam = None
        self._Mp3Param = None
        self._RemoveWatermark = None
        self._CosStore = None
        self._FlvSpecialParam = None

    @property
    def TemplateId(self):
        """模板 ID。
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId

    @property
    def TemplateName(self):
        """模板名称。
        :rtype: str
        """
        return self._TemplateName

    @TemplateName.setter
    def TemplateName(self, TemplateName):
        self._TemplateName = TemplateName

    @property
    def Description(self):
        """描述信息。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def FlvParam(self):
        """FLV 录制参数。
        :rtype: :class:`tencentcloud.live.v20180801.models.RecordParam`
        """
        return self._FlvParam

    @FlvParam.setter
    def FlvParam(self, FlvParam):
        self._FlvParam = FlvParam

    @property
    def HlsParam(self):
        """HLS 录制参数。
        :rtype: :class:`tencentcloud.live.v20180801.models.RecordParam`
        """
        return self._HlsParam

    @HlsParam.setter
    def HlsParam(self, HlsParam):
        self._HlsParam = HlsParam

    @property
    def Mp4Param(self):
        """MP4 录制参数。
        :rtype: :class:`tencentcloud.live.v20180801.models.RecordParam`
        """
        return self._Mp4Param

    @Mp4Param.setter
    def Mp4Param(self, Mp4Param):
        self._Mp4Param = Mp4Param

    @property
    def AacParam(self):
        """AAC 录制参数。
        :rtype: :class:`tencentcloud.live.v20180801.models.RecordParam`
        """
        return self._AacParam

    @AacParam.setter
    def AacParam(self, AacParam):
        self._AacParam = AacParam

    @property
    def IsDelayLive(self):
        """0：普通直播，
1：慢直播。
        :rtype: int
        """
        return self._IsDelayLive

    @IsDelayLive.setter
    def IsDelayLive(self, IsDelayLive):
        self._IsDelayLive = IsDelayLive

    @property
    def HlsSpecialParam(self):
        """HLS 录制定制参数。
        :rtype: :class:`tencentcloud.live.v20180801.models.HlsSpecialParam`
        """
        return self._HlsSpecialParam

    @HlsSpecialParam.setter
    def HlsSpecialParam(self, HlsSpecialParam):
        self._HlsSpecialParam = HlsSpecialParam

    @property
    def Mp3Param(self):
        """MP3 录制参数。
        :rtype: :class:`tencentcloud.live.v20180801.models.RecordParam`
        """
        return self._Mp3Param

    @Mp3Param.setter
    def Mp3Param(self, Mp3Param):
        self._Mp3Param = Mp3Param

    @property
    def RemoveWatermark(self):
        """是否去除水印。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._RemoveWatermark

    @RemoveWatermark.setter
    def RemoveWatermark(self, RemoveWatermark):
        self._RemoveWatermark = RemoveWatermark

    @property
    def CosStore(self):
        """是否存储至cos
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._CosStore

    @CosStore.setter
    def CosStore(self, CosStore):
        self._CosStore = CosStore

    @property
    def FlvSpecialParam(self):
        """FLV 录制定制参数。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.live.v20180801.models.FlvSpecialParam`
        """
        return self._FlvSpecialParam

    @FlvSpecialParam.setter
    def FlvSpecialParam(self, FlvSpecialParam):
        self._FlvSpecialParam = FlvSpecialParam


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        self._TemplateName = params.get("TemplateName")
        self._Description = params.get("Description")
        if params.get("FlvParam") is not None:
            self._FlvParam = RecordParam()
            self._FlvParam._deserialize(params.get("FlvParam"))
        if params.get("HlsParam") is not None:
            self._HlsParam = RecordParam()
            self._HlsParam._deserialize(params.get("HlsParam"))
        if params.get("Mp4Param") is not None:
            self._Mp4Param = RecordParam()
            self._Mp4Param._deserialize(params.get("Mp4Param"))
        if params.get("AacParam") is not None:
            self._AacParam = RecordParam()
            self._AacParam._deserialize(params.get("AacParam"))
        self._IsDelayLive = params.get("IsDelayLive")
        if params.get("HlsSpecialParam") is not None:
            self._HlsSpecialParam = HlsSpecialParam()
            self._HlsSpecialParam._deserialize(params.get("HlsSpecialParam"))
        if params.get("Mp3Param") is not None:
            self._Mp3Param = RecordParam()
            self._Mp3Param._deserialize(params.get("Mp3Param"))
        self._RemoveWatermark = params.get("RemoveWatermark")
        self._CosStore = params.get("CosStore")
        if params.get("FlvSpecialParam") is not None:
            self._FlvSpecialParam = FlvSpecialParam()
            self._FlvSpecialParam._deserialize(params.get("FlvSpecialParam"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RefererAuthConfig(AbstractModel):
    """直播域名Referer黑白名单配置

    """

    def __init__(self):
        r"""
        :param _DomainName: 域名。
        :type DomainName: str
        :param _Enable: 是否启用，0：关闭，1：启用。
        :type Enable: int
        :param _Type: 名单类型，0：黑名单，1：白名单。
        :type Type: int
        :param _AllowEmpty: 是否允许空Referer，0：不允许，1：允许。
        :type AllowEmpty: int
        :param _Rules: 名单列表，以分号(;)分隔。
        :type Rules: str
        """
        self._DomainName = None
        self._Enable = None
        self._Type = None
        self._AllowEmpty = None
        self._Rules = None

    @property
    def DomainName(self):
        """域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def Enable(self):
        """是否启用，0：关闭，1：启用。
        :rtype: int
        """
        return self._Enable

    @Enable.setter
    def Enable(self, Enable):
        self._Enable = Enable

    @property
    def Type(self):
        """名单类型，0：黑名单，1：白名单。
        :rtype: int
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def AllowEmpty(self):
        """是否允许空Referer，0：不允许，1：允许。
        :rtype: int
        """
        return self._AllowEmpty

    @AllowEmpty.setter
    def AllowEmpty(self, AllowEmpty):
        self._AllowEmpty = AllowEmpty

    @property
    def Rules(self):
        """名单列表，以分号(;)分隔。
        :rtype: str
        """
        return self._Rules

    @Rules.setter
    def Rules(self, Rules):
        self._Rules = Rules


    def _deserialize(self, params):
        self._DomainName = params.get("DomainName")
        self._Enable = params.get("Enable")
        self._Type = params.get("Type")
        self._AllowEmpty = params.get("AllowEmpty")
        self._Rules = params.get("Rules")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ReleaseCasterRequest(AbstractModel):
    """ReleaseCaster请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CasterId: 导播台ID。
        :type CasterId: int
        """
        self._CasterId = None

    @property
    def CasterId(self):
        """导播台ID。
        :rtype: int
        """
        return self._CasterId

    @CasterId.setter
    def CasterId(self, CasterId):
        self._CasterId = CasterId


    def _deserialize(self, params):
        self._CasterId = params.get("CasterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ReleaseCasterResponse(AbstractModel):
    """ReleaseCaster返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class RestartLivePullStreamTaskRequest(AbstractModel):
    """RestartLivePullStreamTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务 Id。
        :type TaskId: str
        :param _Operator: 操作人备注名称。
        :type Operator: str
        """
        self._TaskId = None
        self._Operator = None

    @property
    def TaskId(self):
        """任务 Id。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Operator(self):
        """操作人备注名称。
        :rtype: str
        """
        return self._Operator

    @Operator.setter
    def Operator(self, Operator):
        self._Operator = Operator


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Operator = params.get("Operator")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RestartLivePullStreamTaskResponse(AbstractModel):
    """RestartLivePullStreamTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ResumeDelayLiveStreamRequest(AbstractModel):
    """ResumeDelayLiveStream请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AppName: 推流路径，与推流和播放地址中的AppName保持一致，默认为live。
        :type AppName: str
        :param _DomainName: 推流域名。
        :type DomainName: str
        :param _StreamName: 流名称。
        :type StreamName: str
        """
        self._AppName = None
        self._DomainName = None
        self._StreamName = None

    @property
    def AppName(self):
        """推流路径，与推流和播放地址中的AppName保持一致，默认为live。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def DomainName(self):
        """推流域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def StreamName(self):
        """流名称。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName


    def _deserialize(self, params):
        self._AppName = params.get("AppName")
        self._DomainName = params.get("DomainName")
        self._StreamName = params.get("StreamName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ResumeDelayLiveStreamResponse(AbstractModel):
    """ResumeDelayLiveStream返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ResumeLiveStreamRequest(AbstractModel):
    """ResumeLiveStream请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AppName: 推流路径，与推流和播放地址中的AppName保持一致，默认为 live。
        :type AppName: str
        :param _DomainName: 您的推流域名。
        :type DomainName: str
        :param _StreamName: 流名称。
        :type StreamName: str
        """
        self._AppName = None
        self._DomainName = None
        self._StreamName = None

    @property
    def AppName(self):
        """推流路径，与推流和播放地址中的AppName保持一致，默认为 live。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def DomainName(self):
        """您的推流域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def StreamName(self):
        """流名称。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName


    def _deserialize(self, params):
        self._AppName = params.get("AppName")
        self._DomainName = params.get("DomainName")
        self._StreamName = params.get("StreamName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ResumeLiveStreamResponse(AbstractModel):
    """ResumeLiveStream返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class RuleInfo(AbstractModel):
    """规则信息。

    """

    def __init__(self):
        r"""
        :param _CreateTime: 规则创建时间。
注：此字段为北京时间（UTC+8时区）。
        :type CreateTime: str
        :param _UpdateTime: 规则更新时间。
注：此字段为北京时间（UTC+8时区）。
        :type UpdateTime: str
        :param _TemplateId: 模板 ID。
        :type TemplateId: int
        :param _DomainName: 推流域名。
        :type DomainName: str
        :param _AppName: 推流路径。
        :type AppName: str
        :param _StreamName: 流名称。
        :type StreamName: str
        """
        self._CreateTime = None
        self._UpdateTime = None
        self._TemplateId = None
        self._DomainName = None
        self._AppName = None
        self._StreamName = None

    @property
    def CreateTime(self):
        """规则创建时间。
注：此字段为北京时间（UTC+8时区）。
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        """规则更新时间。
注：此字段为北京时间（UTC+8时区）。
        :rtype: str
        """
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def TemplateId(self):
        """模板 ID。
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId

    @property
    def DomainName(self):
        """推流域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def AppName(self):
        """推流路径。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def StreamName(self):
        """流名称。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName


    def _deserialize(self, params):
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._TemplateId = params.get("TemplateId")
        self._DomainName = params.get("DomainName")
        self._AppName = params.get("AppName")
        self._StreamName = params.get("StreamName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ScreenshotTask(AbstractModel):
    """截图任务

    """

    def __init__(self):
        r"""
        :param _TaskId: 截图任务ID。
        :type TaskId: str
        :param _DomainName: 推流域名。
        :type DomainName: str
        :param _AppName: 推流路径。
        :type AppName: str
        :param _StreamName: 流名称。
        :type StreamName: str
        :param _StartTime: 任务开始时间，Unix时间戳。
        :type StartTime: int
        :param _EndTime: 任务结束时间，Unix时间戳。
        :type EndTime: int
        :param _TemplateId: 截图模板ID。
        :type TemplateId: int
        :param _Stopped: 调用 StopScreenshotTask 停止任务时间，Unix时间戳。值为0表示未曾调用接口停止任务。
        :type Stopped: int
        """
        self._TaskId = None
        self._DomainName = None
        self._AppName = None
        self._StreamName = None
        self._StartTime = None
        self._EndTime = None
        self._TemplateId = None
        self._Stopped = None

    @property
    def TaskId(self):
        """截图任务ID。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def DomainName(self):
        """推流域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def AppName(self):
        """推流路径。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def StreamName(self):
        """流名称。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName

    @property
    def StartTime(self):
        """任务开始时间，Unix时间戳。
        :rtype: int
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        """任务结束时间，Unix时间戳。
        :rtype: int
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def TemplateId(self):
        """截图模板ID。
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId

    @property
    def Stopped(self):
        """调用 StopScreenshotTask 停止任务时间，Unix时间戳。值为0表示未曾调用接口停止任务。
        :rtype: int
        """
        return self._Stopped

    @Stopped.setter
    def Stopped(self, Stopped):
        self._Stopped = Stopped


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._DomainName = params.get("DomainName")
        self._AppName = params.get("AppName")
        self._StreamName = params.get("StreamName")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._TemplateId = params.get("TemplateId")
        self._Stopped = params.get("Stopped")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SendLiveCloudEffectRequest(AbstractModel):
    """SendLiveCloudEffect请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AppName: 推流路径，与推流和播放地址中的AppName保持一致，默认为 live。
        :type AppName: str
        :param _PushDomainName: 您的推流域名。
        :type PushDomainName: str
        :param _StreamName: 流名称。
        :type StreamName: str
        :param _Id: 云端特效 ID。
        :type Id: str
        :param _Operator: 操作人备注信息。
        :type Operator: str
        :param _ZoomFactor: 缩小比例，默认0 不缩放。
可选值：0-9， 值越大，越缩小。
        :type ZoomFactor: int
        :param _XPosition: 指定云端特效渲染位置百分比。默认居中显示。
原点为画面左上角，该参数指定特效渲染离原点的横向比例，可选值 0 - 100。
        :type XPosition: str
        :param _YPosition: 指定云端特效渲染位置百分比。默认居中显示。
原点为画面左上角，该参数指定特效渲染离原点的纵向比例，可选值 0 - 100。
        :type YPosition: str
        """
        self._AppName = None
        self._PushDomainName = None
        self._StreamName = None
        self._Id = None
        self._Operator = None
        self._ZoomFactor = None
        self._XPosition = None
        self._YPosition = None

    @property
    def AppName(self):
        """推流路径，与推流和播放地址中的AppName保持一致，默认为 live。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def PushDomainName(self):
        """您的推流域名。
        :rtype: str
        """
        return self._PushDomainName

    @PushDomainName.setter
    def PushDomainName(self, PushDomainName):
        self._PushDomainName = PushDomainName

    @property
    def StreamName(self):
        """流名称。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName

    @property
    def Id(self):
        """云端特效 ID。
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Operator(self):
        """操作人备注信息。
        :rtype: str
        """
        return self._Operator

    @Operator.setter
    def Operator(self, Operator):
        self._Operator = Operator

    @property
    def ZoomFactor(self):
        """缩小比例，默认0 不缩放。
可选值：0-9， 值越大，越缩小。
        :rtype: int
        """
        return self._ZoomFactor

    @ZoomFactor.setter
    def ZoomFactor(self, ZoomFactor):
        self._ZoomFactor = ZoomFactor

    @property
    def XPosition(self):
        """指定云端特效渲染位置百分比。默认居中显示。
原点为画面左上角，该参数指定特效渲染离原点的横向比例，可选值 0 - 100。
        :rtype: str
        """
        return self._XPosition

    @XPosition.setter
    def XPosition(self, XPosition):
        self._XPosition = XPosition

    @property
    def YPosition(self):
        """指定云端特效渲染位置百分比。默认居中显示。
原点为画面左上角，该参数指定特效渲染离原点的纵向比例，可选值 0 - 100。
        :rtype: str
        """
        return self._YPosition

    @YPosition.setter
    def YPosition(self, YPosition):
        self._YPosition = YPosition


    def _deserialize(self, params):
        self._AppName = params.get("AppName")
        self._PushDomainName = params.get("PushDomainName")
        self._StreamName = params.get("StreamName")
        self._Id = params.get("Id")
        self._Operator = params.get("Operator")
        self._ZoomFactor = params.get("ZoomFactor")
        self._XPosition = params.get("XPosition")
        self._YPosition = params.get("YPosition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SendLiveCloudEffectResponse(AbstractModel):
    """SendLiveCloudEffect返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class SnapshotTemplateInfo(AbstractModel):
    """截图模板信息。

    """

    def __init__(self):
        r"""
        :param _TemplateId: 模板 ID。
        :type TemplateId: int
        :param _TemplateName: 模板名称。
        :type TemplateName: str
        :param _SnapshotInterval: 截图时间间隔，5-300秒。
        :type SnapshotInterval: int
        :param _Width: 截图宽度，范围：0-3000。 
0：原始宽度并适配原始比例。
        :type Width: int
        :param _Height: 截图高度，范围：0-2000。
0：原始高度并适配原始比例。
        :type Height: int
        :param _PornFlag: 是否开启鉴黄，0：不开启，1：开启。
        :type PornFlag: int
        :param _CosAppId: Cos 应用 ID。
        :type CosAppId: int
        :param _CosBucket: Cos Bucket名称。
        :type CosBucket: str
        :param _CosRegion: Cos 地域。
        :type CosRegion: str
        :param _Description: 模板描述。
        :type Description: str
        :param _CosPrefix: Cos Bucket文件夹前缀。
注意：此字段可能返回 null，表示取不到有效值。
        :type CosPrefix: str
        :param _CosFileName: Cos 文件名称。
注意：此字段可能返回 null，表示取不到有效值。
        :type CosFileName: str
        """
        self._TemplateId = None
        self._TemplateName = None
        self._SnapshotInterval = None
        self._Width = None
        self._Height = None
        self._PornFlag = None
        self._CosAppId = None
        self._CosBucket = None
        self._CosRegion = None
        self._Description = None
        self._CosPrefix = None
        self._CosFileName = None

    @property
    def TemplateId(self):
        """模板 ID。
        :rtype: int
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId

    @property
    def TemplateName(self):
        """模板名称。
        :rtype: str
        """
        return self._TemplateName

    @TemplateName.setter
    def TemplateName(self, TemplateName):
        self._TemplateName = TemplateName

    @property
    def SnapshotInterval(self):
        """截图时间间隔，5-300秒。
        :rtype: int
        """
        return self._SnapshotInterval

    @SnapshotInterval.setter
    def SnapshotInterval(self, SnapshotInterval):
        self._SnapshotInterval = SnapshotInterval

    @property
    def Width(self):
        """截图宽度，范围：0-3000。 
0：原始宽度并适配原始比例。
        :rtype: int
        """
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        """截图高度，范围：0-2000。
0：原始高度并适配原始比例。
        :rtype: int
        """
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def PornFlag(self):
        """是否开启鉴黄，0：不开启，1：开启。
        :rtype: int
        """
        return self._PornFlag

    @PornFlag.setter
    def PornFlag(self, PornFlag):
        self._PornFlag = PornFlag

    @property
    def CosAppId(self):
        """Cos 应用 ID。
        :rtype: int
        """
        return self._CosAppId

    @CosAppId.setter
    def CosAppId(self, CosAppId):
        self._CosAppId = CosAppId

    @property
    def CosBucket(self):
        """Cos Bucket名称。
        :rtype: str
        """
        return self._CosBucket

    @CosBucket.setter
    def CosBucket(self, CosBucket):
        self._CosBucket = CosBucket

    @property
    def CosRegion(self):
        """Cos 地域。
        :rtype: str
        """
        return self._CosRegion

    @CosRegion.setter
    def CosRegion(self, CosRegion):
        self._CosRegion = CosRegion

    @property
    def Description(self):
        """模板描述。
        :rtype: str
        """
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def CosPrefix(self):
        """Cos Bucket文件夹前缀。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CosPrefix

    @CosPrefix.setter
    def CosPrefix(self, CosPrefix):
        self._CosPrefix = CosPrefix

    @property
    def CosFileName(self):
        """Cos 文件名称。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._CosFileName

    @CosFileName.setter
    def CosFileName(self, CosFileName):
        self._CosFileName = CosFileName


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        self._TemplateName = params.get("TemplateName")
        self._SnapshotInterval = params.get("SnapshotInterval")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._PornFlag = params.get("PornFlag")
        self._CosAppId = params.get("CosAppId")
        self._CosBucket = params.get("CosBucket")
        self._CosRegion = params.get("CosRegion")
        self._Description = params.get("Description")
        self._CosPrefix = params.get("CosPrefix")
        self._CosFileName = params.get("CosFileName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class StartLivePadStreamRequest(AbstractModel):
    """StartLivePadStream请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AppName: 推流路径，与推流和播放地址中的AppName保持一致，默认为 live。
        :type AppName: str
        :param _PushDomainName: 您的推流域名。
        :type PushDomainName: str
        :param _StreamName: 流名称。
        :type StreamName: str
        :param _Operator: 操作人备注信息。
        :type Operator: str
        """
        self._AppName = None
        self._PushDomainName = None
        self._StreamName = None
        self._Operator = None

    @property
    def AppName(self):
        """推流路径，与推流和播放地址中的AppName保持一致，默认为 live。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def PushDomainName(self):
        """您的推流域名。
        :rtype: str
        """
        return self._PushDomainName

    @PushDomainName.setter
    def PushDomainName(self, PushDomainName):
        self._PushDomainName = PushDomainName

    @property
    def StreamName(self):
        """流名称。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName

    @property
    def Operator(self):
        """操作人备注信息。
        :rtype: str
        """
        return self._Operator

    @Operator.setter
    def Operator(self, Operator):
        self._Operator = Operator


    def _deserialize(self, params):
        self._AppName = params.get("AppName")
        self._PushDomainName = params.get("PushDomainName")
        self._StreamName = params.get("StreamName")
        self._Operator = params.get("Operator")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class StartLivePadStreamResponse(AbstractModel):
    """StartLivePadStream返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class StartLiveStreamMonitorRequest(AbstractModel):
    """StartLiveStreamMonitor请求参数结构体

    """

    def __init__(self):
        r"""
        :param _MonitorId: 监播ID。
        :type MonitorId: str
        :param _AudibleInputIndexList: 监播画面声音InputIndex,支持多个输入声音。
取值范围 InputIndex必须已经存在。
不填默认无声音输出。
        :type AudibleInputIndexList: list of int non-negative
        """
        self._MonitorId = None
        self._AudibleInputIndexList = None

    @property
    def MonitorId(self):
        """监播ID。
        :rtype: str
        """
        return self._MonitorId

    @MonitorId.setter
    def MonitorId(self, MonitorId):
        self._MonitorId = MonitorId

    @property
    def AudibleInputIndexList(self):
        """监播画面声音InputIndex,支持多个输入声音。
取值范围 InputIndex必须已经存在。
不填默认无声音输出。
        :rtype: list of int non-negative
        """
        return self._AudibleInputIndexList

    @AudibleInputIndexList.setter
    def AudibleInputIndexList(self, AudibleInputIndexList):
        self._AudibleInputIndexList = AudibleInputIndexList


    def _deserialize(self, params):
        self._MonitorId = params.get("MonitorId")
        self._AudibleInputIndexList = params.get("AudibleInputIndexList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class StartLiveStreamMonitorResponse(AbstractModel):
    """StartLiveStreamMonitor返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class StopCasterPgmRequest(AbstractModel):
    """StopCasterPgm请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CasterId: 导播台ID。
        :type CasterId: int
        """
        self._CasterId = None

    @property
    def CasterId(self):
        """导播台ID。
        :rtype: int
        """
        return self._CasterId

    @CasterId.setter
    def CasterId(self, CasterId):
        self._CasterId = CasterId


    def _deserialize(self, params):
        self._CasterId = params.get("CasterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class StopCasterPgmResponse(AbstractModel):
    """StopCasterPgm返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class StopCasterPvwRequest(AbstractModel):
    """StopCasterPvw请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CasterId: 导播台ID。
        :type CasterId: int
        """
        self._CasterId = None

    @property
    def CasterId(self):
        """导播台ID。
        :rtype: int
        """
        return self._CasterId

    @CasterId.setter
    def CasterId(self, CasterId):
        self._CasterId = CasterId


    def _deserialize(self, params):
        self._CasterId = params.get("CasterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class StopCasterPvwResponse(AbstractModel):
    """StopCasterPvw返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class StopLivePadStreamRequest(AbstractModel):
    """StopLivePadStream请求参数结构体

    """

    def __init__(self):
        r"""
        :param _AppName: 推流路径，与推流和播放地址中的AppName保持一致，默认为 live。
        :type AppName: str
        :param _PushDomainName: 您的推流域名。
        :type PushDomainName: str
        :param _StreamName: 流名称。
        :type StreamName: str
        :param _Operator: 操作人备注信息。
        :type Operator: str
        """
        self._AppName = None
        self._PushDomainName = None
        self._StreamName = None
        self._Operator = None

    @property
    def AppName(self):
        """推流路径，与推流和播放地址中的AppName保持一致，默认为 live。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def PushDomainName(self):
        """您的推流域名。
        :rtype: str
        """
        return self._PushDomainName

    @PushDomainName.setter
    def PushDomainName(self, PushDomainName):
        self._PushDomainName = PushDomainName

    @property
    def StreamName(self):
        """流名称。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName

    @property
    def Operator(self):
        """操作人备注信息。
        :rtype: str
        """
        return self._Operator

    @Operator.setter
    def Operator(self, Operator):
        self._Operator = Operator


    def _deserialize(self, params):
        self._AppName = params.get("AppName")
        self._PushDomainName = params.get("PushDomainName")
        self._StreamName = params.get("StreamName")
        self._Operator = params.get("Operator")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class StopLivePadStreamResponse(AbstractModel):
    """StopLivePadStream返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class StopLiveRecordRequest(AbstractModel):
    """StopLiveRecord请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StreamName: 流名称。
        :type StreamName: str
        :param _TaskId: 任务ID，由CreateLiveRecord接口返回。
        :type TaskId: int
        """
        self._StreamName = None
        self._TaskId = None

    @property
    def StreamName(self):
        """流名称。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName

    @property
    def TaskId(self):
        """任务ID，由CreateLiveRecord接口返回。
        :rtype: int
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._StreamName = params.get("StreamName")
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class StopLiveRecordResponse(AbstractModel):
    """StopLiveRecord返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class StopLiveStreamMonitorRequest(AbstractModel):
    """StopLiveStreamMonitor请求参数结构体

    """

    def __init__(self):
        r"""
        :param _MonitorId: 监播ID
        :type MonitorId: str
        """
        self._MonitorId = None

    @property
    def MonitorId(self):
        """监播ID
        :rtype: str
        """
        return self._MonitorId

    @MonitorId.setter
    def MonitorId(self, MonitorId):
        self._MonitorId = MonitorId


    def _deserialize(self, params):
        self._MonitorId = params.get("MonitorId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class StopLiveStreamMonitorResponse(AbstractModel):
    """StopLiveStreamMonitor返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class StopRecordTaskRequest(AbstractModel):
    """StopRecordTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 录制任务ID。
        :type TaskId: str
        """
        self._TaskId = None

    @property
    def TaskId(self):
        """录制任务ID。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class StopRecordTaskResponse(AbstractModel):
    """StopRecordTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class StopScreenshotTaskRequest(AbstractModel):
    """StopScreenshotTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 截图任务ID。
        :type TaskId: str
        """
        self._TaskId = None

    @property
    def TaskId(self):
        """截图任务ID。
        :rtype: str
        """
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class StopScreenshotTaskResponse(AbstractModel):
    """StopScreenshotTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        """唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class StreamEventInfo(AbstractModel):
    """推断流事件信息。

    """

    def __init__(self):
        r"""
        :param _AppName: 应用名称。
        :type AppName: str
        :param _DomainName: 推流域名。
        :type DomainName: str
        :param _StreamName: 流名称。
        :type StreamName: str
        :param _StreamStartTime: 推流开始时间。
UTC 格式时间，例如：2019-01-07T12:00:00Z。
        :type StreamStartTime: str
        :param _StreamEndTime: 推流结束时间。
UTC 格式时间，例如：2019-01-07T15:00:00Z。
        :type StreamEndTime: str
        :param _StopReason: 停止原因。
        :type StopReason: str
        :param _Duration: 推流持续时长，单位：秒。
        :type Duration: int
        :param _ClientIp: 主播 IP。
当客户端为内网推流时，展示为: - 。
        :type ClientIp: str
        :param _Resolution: 分辨率。
        :type Resolution: str
        """
        self._AppName = None
        self._DomainName = None
        self._StreamName = None
        self._StreamStartTime = None
        self._StreamEndTime = None
        self._StopReason = None
        self._Duration = None
        self._ClientIp = None
        self._Resolution = None

    @property
    def AppName(self):
        """应用名称。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def DomainName(self):
        """推流域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def StreamName(self):
        """流名称。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName

    @property
    def StreamStartTime(self):
        """推流开始时间。
UTC 格式时间，例如：2019-01-07T12:00:00Z。
        :rtype: str
        """
        return self._StreamStartTime

    @StreamStartTime.setter
    def StreamStartTime(self, StreamStartTime):
        self._StreamStartTime = StreamStartTime

    @property
    def StreamEndTime(self):
        """推流结束时间。
UTC 格式时间，例如：2019-01-07T15:00:00Z。
        :rtype: str
        """
        return self._StreamEndTime

    @StreamEndTime.setter
    def StreamEndTime(self, StreamEndTime):
        self._StreamEndTime = StreamEndTime

    @property
    def StopReason(self):
        """停止原因。
        :rtype: str
        """
        return self._StopReason

    @StopReason.setter
    def StopReason(self, StopReason):
        self._StopReason = StopReason

    @property
    def Duration(self):
        """推流持续时长，单位：秒。
        :rtype: int
        """
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration

    @property
    def ClientIp(self):
        """主播 IP。
当客户端为内网推流时，展示为: - 。
        :rtype: str
        """
        return self._ClientIp

    @ClientIp.setter
    def ClientIp(self, ClientIp):
        self._ClientIp = ClientIp

    @property
    def Resolution(self):
        """分辨率。
        :rtype: str
        """
        return self._Resolution

    @Resolution.setter
    def Resolution(self, Resolution):
        self._Resolution = Resolution


    def _deserialize(self, params):
        self._AppName = params.get("AppName")
        self._DomainName = params.get("DomainName")
        self._StreamName = params.get("StreamName")
        self._StreamStartTime = params.get("StreamStartTime")
        self._StreamEndTime = params.get("StreamEndTime")
        self._StopReason = params.get("StopReason")
        self._Duration = params.get("Duration")
        self._ClientIp = params.get("ClientIp")
        self._Resolution = params.get("Resolution")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class StreamName(AbstractModel):
    """流名称列表。

    """

    def __init__(self):
        r"""
        :param _StreamName: 流名称。
        :type StreamName: str
        :param _AppName: 应用名称。
        :type AppName: str
        :param _DomainName: 推流域名。
        :type DomainName: str
        :param _StreamStartTime: 推流开始时间。
UTC格式时间，例如：2019-01-07T12:00:00Z。
        :type StreamStartTime: str
        :param _StreamEndTime: 推流结束时间。
UTC格式时间，例如：2019-01-07T15:00:00Z。
        :type StreamEndTime: str
        :param _StopReason: 停止原因。
        :type StopReason: str
        :param _Duration: 推流持续时长，单位：秒。
        :type Duration: int
        :param _ClientIp: 主播 IP。
        :type ClientIp: str
        :param _Resolution: 分辨率。
        :type Resolution: str
        """
        self._StreamName = None
        self._AppName = None
        self._DomainName = None
        self._StreamStartTime = None
        self._StreamEndTime = None
        self._StopReason = None
        self._Duration = None
        self._ClientIp = None
        self._Resolution = None

    @property
    def StreamName(self):
        """流名称。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName

    @property
    def AppName(self):
        """应用名称。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def DomainName(self):
        """推流域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def StreamStartTime(self):
        """推流开始时间。
UTC格式时间，例如：2019-01-07T12:00:00Z。
        :rtype: str
        """
        return self._StreamStartTime

    @StreamStartTime.setter
    def StreamStartTime(self, StreamStartTime):
        self._StreamStartTime = StreamStartTime

    @property
    def StreamEndTime(self):
        """推流结束时间。
UTC格式时间，例如：2019-01-07T15:00:00Z。
        :rtype: str
        """
        return self._StreamEndTime

    @StreamEndTime.setter
    def StreamEndTime(self, StreamEndTime):
        self._StreamEndTime = StreamEndTime

    @property
    def StopReason(self):
        """停止原因。
        :rtype: str
        """
        return self._StopReason

    @StopReason.setter
    def StopReason(self, StopReason):
        self._StopReason = StopReason

    @property
    def Duration(self):
        """推流持续时长，单位：秒。
        :rtype: int
        """
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration

    @property
    def ClientIp(self):
        """主播 IP。
        :rtype: str
        """
        return self._ClientIp

    @ClientIp.setter
    def ClientIp(self, ClientIp):
        self._ClientIp = ClientIp

    @property
    def Resolution(self):
        """分辨率。
        :rtype: str
        """
        return self._Resolution

    @Resolution.setter
    def Resolution(self, Resolution):
        self._Resolution = Resolution


    def _deserialize(self, params):
        self._StreamName = params.get("StreamName")
        self._AppName = params.get("AppName")
        self._DomainName = params.get("DomainName")
        self._StreamStartTime = params.get("StreamStartTime")
        self._StreamEndTime = params.get("StreamEndTime")
        self._StopReason = params.get("StopReason")
        self._Duration = params.get("Duration")
        self._ClientIp = params.get("ClientIp")
        self._Resolution = params.get("Resolution")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class StreamOnlineInfo(AbstractModel):
    """查询当前正在推流的信息

    """

    def __init__(self):
        r"""
        :param _StreamName: 流名称。
        :type StreamName: str
        :param _PublishTimeList: 推流时间列表
        :type PublishTimeList: list of PublishTime
        :param _AppName: 应用名称。
        :type AppName: str
        :param _DomainName: 推流域名。
        :type DomainName: str
        :param _PushToDelay: 流是否推送到延播。
0 - 无延播，
1 - 有延播。
        :type PushToDelay: int
        """
        self._StreamName = None
        self._PublishTimeList = None
        self._AppName = None
        self._DomainName = None
        self._PushToDelay = None

    @property
    def StreamName(self):
        """流名称。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName

    @property
    def PublishTimeList(self):
        """推流时间列表
        :rtype: list of PublishTime
        """
        return self._PublishTimeList

    @PublishTimeList.setter
    def PublishTimeList(self, PublishTimeList):
        self._PublishTimeList = PublishTimeList

    @property
    def AppName(self):
        """应用名称。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def DomainName(self):
        """推流域名。
        :rtype: str
        """
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def PushToDelay(self):
        """流是否推送到延播。
0 - 无延播，
1 - 有延播。
        :rtype: int
        """
        return self._PushToDelay

    @PushToDelay.setter
    def PushToDelay(self, PushToDelay):
        self._PushToDelay = PushToDelay


    def _deserialize(self, params):
        self._StreamName = params.get("StreamName")
        if params.get("PublishTimeList") is not None:
            self._PublishTimeList = []
            for item in params.get("PublishTimeList"):
                obj = PublishTime()
                obj._deserialize(item)
                self._PublishTimeList.append(obj)
        self._AppName = params.get("AppName")
        self._DomainName = params.get("DomainName")
        self._PushToDelay = params.get("PushToDelay")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SwitchBackupStreamRequest(AbstractModel):
    """SwitchBackupStream请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PushDomainName: 推流域名。
        :type PushDomainName: str
        :param _AppName: 应用名称。
        :type AppName: str
        :param _StreamName: 流名称。
        :type StreamName: str
        :param _UpstreamSequence: 查询接口获取到该流所有在推的上行 Sequence。指定要切到的目标上行 Sequence。
        :type UpstreamSequence: str
        """
        self._PushDomainName = None
        self._AppName = None
        self._StreamName = None
        self._UpstreamSequence = None

    @property
    def PushDomainName(self):
        """推流域名。
        :rtype: str
        """
        return self._PushDomainName

    @PushDomainName.setter
    def PushDomainName(self, PushDomainName):
        self._PushDomainName = PushDomainName

    @property
    def AppName(self):
        """应用名称。
        :rtype: str
        """
        return self._AppName

    @AppName.setter
    def AppName(self, AppName):
        self._AppName = AppName

    @property
    def StreamName(self):
        """流名称。
        :rtype: str
        """
        return self._StreamName

    @StreamName.setter
    def StreamName(self, StreamName):
        self._StreamName = StreamName

    @property
    def UpstreamSequence(self):
        """查询接口获取到该流所有在推的上行 Sequence。指定要切到的目标上行 Sequence。
        :rtype: str
        """
        return self._UpstreamSequence

    @UpstreamSequence.setter
    def UpstreamSequence(self, UpstreamSequence):
        self._UpstreamSequence = UpstreamSequence


    def _deserialize(self, params):
        self._PushDomainName = params.get("PushDomainName")
        self._AppName = params.get("AppName")
        self._StreamName = params.get("StreamName")
        self._UpstreamSequence = params.get("UpstreamSequence")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
      