# -*- coding: utf8 -*-
# Copyright (c) 2017-2021 THL A29 Limited, a Tencent company. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class AcceptVpcPeerConnectionRequest(AbstractModel):
    """AcceptVpcPeerConnection请求参数结构体

    """

    def __init__(self):
        """
        :param VpcPeerConnectionId: 黑石对等连接实例ID\n        :type VpcPeerConnectionId: str\n        """
        self.VpcPeerConnectionId = None


    def _deserialize(self, params):
        self.VpcPeerConnectionId = params.get("VpcPeerConnectionId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AcceptVpcPeerConnectionResponse(AbstractModel):
    """AcceptVpcPeerConnection返回参数结构体

    """

    def __init__(self):
        """
        :param TaskId: 任务ID\n        :type TaskId: int\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.TaskId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.RequestId = params.get("RequestId")


class AsyncRegisterIpsRequest(AbstractModel):
    """AsyncRegisterIps请求参数结构体

    """

    def __init__(self):
        """
        :param VpcId: 私有网络的唯一ID。\n        :type VpcId: str\n        :param SubnetId: 子网唯一ID。\n        :type SubnetId: str\n        :param Ips: 需要注册的IP列表。\n        :type Ips: list of str\n        """
        self.VpcId = None
        self.SubnetId = None
        self.Ips = None


    def _deserialize(self, params):
        self.VpcId = params.get("VpcId")
        self.SubnetId = params.get("SubnetId")
        self.Ips = params.get("Ips")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AsyncRegisterIpsResponse(AbstractModel):
    """AsyncRegisterIps返回参数结构体

    """

    def __init__(self):
        """
        :param TaskId: 任务ID。\n        :type TaskId: int\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.TaskId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.RequestId = params.get("RequestId")


class BindEipsToNatGatewayRequest(AbstractModel):
    """BindEipsToNatGateway请求参数结构体

    """

    def __init__(self):
        """
        :param NatId: NAT网关ID，例如：nat-kdm476mp\n        :type NatId: str\n        :param VpcId: 私有网络ID，例如：vpc-kd7d06of\n        :type VpcId: str\n        :param AssignedEips: 已分配的EIP列表；AssignedEips和AutoAllocEipNum至少输入一个\n        :type AssignedEips: list of str\n        :param AutoAllocEipNum: 新建EIP数目，系统将会按您的要求生产该数目个数EIP；AssignedEips和AutoAllocEipNum至少输入一个\n        :type AutoAllocEipNum: int\n        """
        self.NatId = None
        self.VpcId = None
        self.AssignedEips = None
        self.AutoAllocEipNum = None


    def _deserialize(self, params):
        self.NatId = params.get("NatId")
        self.VpcId = params.get("VpcId")
        self.AssignedEips = params.get("AssignedEips")
        self.AutoAllocEipNum = params.get("AutoAllocEipNum")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BindEipsToNatGatewayResponse(AbstractModel):
    """BindEipsToNatGateway返回参数结构体

    """

    def __init__(self):
        """
        :param TaskId: 任务ID\n        :type TaskId: int\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.TaskId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.RequestId = params.get("RequestId")


class BindIpsToNatGatewayRequest(AbstractModel):
    """BindIpsToNatGateway请求参数结构体

    """

    def __init__(self):
        """
        :param NatId: NAT网关ID，例如：nat-kdm476mp\n        :type NatId: str\n        :param VpcId: 私有网络ID，例如：vpc-kd7d06of\n        :type VpcId: str\n        :param IpInfoSet: 部分IP信息，子网下只有该部分IP将加入NAT，仅当网关转发模式为IP方式有效\n        :type IpInfoSet: list of IpInfo\n        """
        self.NatId = None
        self.VpcId = None
        self.IpInfoSet = None


    def _deserialize(self, params):
        self.NatId = params.get("NatId")
        self.VpcId = params.get("VpcId")
        if params.get("IpInfoSet") is not None:
            self.IpInfoSet = []
            for item in params.get("IpInfoSet"):
                obj = IpInfo()
                obj._deserialize(item)
                self.IpInfoSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BindIpsToNatGatewayResponse(AbstractModel):
    """BindIpsToNatGateway返回参数结构体

    """

    def __init__(self):
        """
        :param TaskId: 任务ID\n        :type TaskId: int\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.TaskId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.RequestId = params.get("RequestId")


class BindSubnetsToNatGatewayRequest(AbstractModel):
    """BindSubnetsToNatGateway请求参数结构体

    """

    def __init__(self):
        """
        :param NatId: NAT网关ID，例如：nat-kdm476mp\n        :type NatId: str\n        :param VpcId: 私有网络ID，例如：vpc-kd7d06of\n        :type VpcId: str\n        :param SubnetIds: 子网ID列表，子网下全部IP将加入NAT，不区分网关转发方式\n        :type SubnetIds: list of str\n        """
        self.NatId = None
        self.VpcId = None
        self.SubnetIds = None


    def _deserialize(self, params):
        self.NatId = params.get("NatId")
        self.VpcId = params.get("VpcId")
        self.SubnetIds = params.get("SubnetIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BindSubnetsToNatGatewayResponse(AbstractModel):
    """BindSubnetsToNatGateway返回参数结构体

    """

    def __init__(self):
        """
        :param TaskId: 任务ID\n        :type TaskId: int\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.TaskId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.RequestId = params.get("RequestId")


class CreateCustomerGatewayRequest(AbstractModel):
    """CreateCustomerGateway请求参数结构体

    """

    def __init__(self):
        """
        :param CustomerGatewayName: 对端网关名称，可任意命名，但不得超过60个字符。\n        :type CustomerGatewayName: str\n        :param IpAddress: 对端网关公网IP。\n        :type IpAddress: str\n        :param Zone: 可用区ID\n        :type Zone: str\n        """
        self.CustomerGatewayName = None
        self.IpAddress = None
        self.Zone = None


    def _deserialize(self, params):
        self.CustomerGatewayName = params.get("CustomerGatewayName")
        self.IpAddress = params.get("IpAddress")
        self.Zone = params.get("Zone")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateCustomerGatewayResponse(AbstractModel):
    """CreateCustomerGateway返回参数结构体

    """

    def __init__(self):
        """
        :param CustomerGateway: 对端网关对象\n        :type CustomerGateway: :class:`tencentcloud.bmvpc.v20180625.models.CustomerGateway`\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.CustomerGateway = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("CustomerGateway") is not None:
            self.CustomerGateway = CustomerGateway()
            self.CustomerGateway._deserialize(params.get("CustomerGateway"))
        self.RequestId = params.get("RequestId")


class CreateDockerSubnetWithVlanRequest(AbstractModel):
    """CreateDockerSubnetWithVlan请求参数结构体

    """

    def __init__(self):
        """
        :param VpcId: 系统分配的私有网络ID，例如：vpc-kd7d06of\n        :type VpcId: str\n        :param SubnetSet: 子网信息\n        :type SubnetSet: list of SubnetCreateInputInfo\n        """
        self.VpcId = None
        self.SubnetSet = None


    def _deserialize(self, params):
        self.VpcId = params.get("VpcId")
        if params.get("SubnetSet") is not None:
            self.SubnetSet = []
            for item in params.get("SubnetSet"):
                obj = SubnetCreateInputInfo()
                obj._deserialize(item)
                self.SubnetSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDockerSubnetWithVlanResponse(AbstractModel):
    """CreateDockerSubnetWithVlan返回参数结构体

    """

    def __init__(self):
        """
        :param TaskId: 任务ID\n        :type TaskId: int\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.TaskId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.RequestId = params.get("RequestId")


class CreateHostedInterfaceRequest(AbstractModel):
    """CreateHostedInterface请求参数结构体

    """

    def __init__(self):
        """
        :param InstanceIds: 托管机器唯一ID 数组\n        :type InstanceIds: list of str\n        :param VpcId: 私有网络ID或者私有网络统一ID，建议使用统一ID\n        :type VpcId: str\n        :param SubnetId: 子网ID或者子网统一ID，建议使用统一ID\n        :type SubnetId: str\n        """
        self.InstanceIds = None
        self.VpcId = None
        self.SubnetId = None


    def _deserialize(self, params):
        self.InstanceIds = params.get("InstanceIds")
        self.VpcId = params.get("VpcId")
        self.SubnetId = params.get("SubnetId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateHostedInterfaceResponse(AbstractModel):
    """CreateHostedInterface返回参数结构体

    """

    def __init__(self):
        """
        :param TaskId: 异步任务ID\n        :type TaskId: int\n        :param ResourceIds: 黑石托管机器ID\n        :type ResourceIds: list of str\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.TaskId = None
        self.ResourceIds = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.ResourceIds = params.get("ResourceIds")
        self.RequestId = params.get("RequestId")


class CreateInterfacesRequest(AbstractModel):
    """CreateInterfaces请求参数结构体

    """

    def __init__(self):
        """
        :param InstanceIds: 物理机实例ID列表\n        :type InstanceIds: list of str\n        :param VpcId: 私有网络ID\n        :type VpcId: str\n        :param SubnetId: 子网ID\n        :type SubnetId: str\n        """
        self.InstanceIds = None
        self.VpcId = None
        self.SubnetId = None


    def _deserialize(self, params):
        self.InstanceIds = params.get("InstanceIds")
        self.VpcId = params.get("VpcId")
        self.SubnetId = params.get("SubnetId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateInterfacesResponse(AbstractModel):
    """CreateInterfaces返回参数结构体

    """

    def __init__(self):
        """
        :param TaskId: 任务ID\n        :type TaskId: int\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.TaskId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.RequestId = params.get("RequestId")


class CreateNatGatewayRequest(AbstractModel):
    """CreateNatGateway请求参数结构体

    """

    def __init__(self):
        """
        :param ForwardMode: 转发模式，其中0表示IP方式，1表示网段方式；通过cidr方式可支持更多的IP接入到NAT网关\n        :type ForwardMode: str\n        :param VpcId: 私有网络ID，例如：vpc-kd7d06of\n        :type VpcId: str\n        :param NatName: NAT名称\n        :type NatName: str\n        :param MaxConcurrent: 并发连接数规格；取值为1000000、3000000、10000000，分别对应小型、中型、大型NAT网关\n        :type MaxConcurrent: int\n        :param SubnetIds: 子网ID列表，子网下全部IP将加入NAT，不区分网关转发方式\n        :type SubnetIds: list of str\n        :param IpInfoSet: 部分IP信息，子网下只有该部分IP将加入NAT，仅当网关转发模式为IP方式有效；IpInfoSet和SubnetIds中的子网ID不能同时存在\n        :type IpInfoSet: list of IpInfo\n        :param AssignedEips: 已分配的EIP列表, AssignedEips和AutoAllocEipNum至少输入一个\n        :type AssignedEips: list of str\n        :param AutoAllocEipNum: 新建EIP数目，系统将会按您的要求生产该数目个数EIP, AssignedEips和AutoAllocEipNum至少输入一个\n        :type AutoAllocEipNum: int\n        :param Exclusive: 独占标识，取值为0和1，默认值为0；0和1分别表示创建共享型NAT网关和独占NAT型网关；由于同一个VPC网络内，指向NAT集群的默认路由只有一条，因此VPC内只能创建一种类型NAT网关；创建独占型NAT网关时，需联系对应架构师进行独占NAT集群搭建，否则无法创建独占型NAT网关。\n        :type Exclusive: int\n        """
        self.ForwardMode = None
        self.VpcId = None
        self.NatName = None
        self.MaxConcurrent = None
        self.SubnetIds = None
        self.IpInfoSet = None
        self.AssignedEips = None
        self.AutoAllocEipNum = None
        self.Exclusive = None


    def _deserialize(self, params):
        self.ForwardMode = params.get("ForwardMode")
        self.VpcId = params.get("VpcId")
        self.NatName = params.get("NatName")
        self.MaxConcurrent = params.get("MaxConcurrent")
        self.SubnetIds = params.get("SubnetIds")
        if params.get("IpInfoSet") is not None:
            self.IpInfoSet = []
            for item in params.get("IpInfoSet"):
                obj = IpInfo()
                obj._deserialize(item)
                self.IpInfoSet.append(obj)
        self.AssignedEips = params.get("AssignedEips")
        self.AutoAllocEipNum = params.get("AutoAllocEipNum")
        self.Exclusive = params.get("Exclusive")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateNatGatewayResponse(AbstractModel):
    """CreateNatGateway返回参数结构体

    """

    def __init__(self):
        """
        :param TaskId: 任务ID\n        :type TaskId: int\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.TaskId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.RequestId = params.get("RequestId")


class CreateRoutePoliciesRequest(AbstractModel):
    """CreateRoutePolicies请求参数结构体

    """

    def __init__(self):
        """
        :param RouteTableId: 路由表ID\n        :type RouteTableId: str\n        :param RoutePolicySet: 新增的路由\n        :type RoutePolicySet: list of RoutePolicy\n        """
        self.RouteTableId = None
        self.RoutePolicySet = None


    def _deserialize(self, params):
        self.RouteTableId = params.get("RouteTableId")
        if params.get("RoutePolicySet") is not None:
            self.RoutePolicySet = []
            for item in params.get("RoutePolicySet"):
                obj = RoutePolicy()
                obj._deserialize(item)
                self.RoutePolicySet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRoutePoliciesResponse(AbstractModel):
    """CreateRoutePolicies返回参数结构体

    """

    def __init__(self):
        """
        :param TaskId: 异步任务ID\n        :type TaskId: int\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.TaskId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.RequestId = params.get("RequestId")


class CreateSubnetRequest(AbstractModel):
    """CreateSubnet请求参数结构体

    """

    def __init__(self):
        """
        :param VpcId: 系统分配的私有网络ID，例如：vpc-kd7d06of\n        :type VpcId: str\n        :param SubnetSet: 子网信息\n        :type SubnetSet: list of SubnetCreateInputInfo\n        """
        self.VpcId = None
        self.SubnetSet = None


    def _deserialize(self, params):
        self.VpcId = params.get("VpcId")
        if params.get("SubnetSet") is not None:
            self.SubnetSet = []
            for item in params.get("SubnetSet"):
                obj = SubnetCreateInputInfo()
                obj._deserialize(item)
                self.SubnetSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSubnetResponse(AbstractModel):
    """CreateSubnet返回参数结构体

    """

    def __init__(self):
        """
        :param TaskId: 任务ID\n        :type TaskId: int\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.TaskId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.RequestId = params.get("RequestId")


class CreateVirtualSubnetWithVlanRequest(AbstractModel):
    """CreateVirtualSubnetWithVlan请求参数结构体

    """

    def __init__(self):
        """
        :param VpcId: 系统分配的私有网络ID，例如：vpc-kd7d06of\n        :type VpcId: str\n        :param SubnetSet: 子网信息\n        :type SubnetSet: list of SubnetCreateInputInfo\n        """
        self.VpcId = None
        self.SubnetSet = None


    def _deserialize(self, params):
        self.VpcId = params.get("VpcId")
        if params.get("SubnetSet") is not None:
            self.SubnetSet = []
            for item in params.get("SubnetSet"):
                obj = SubnetCreateInputInfo()
                obj._deserialize(item)
                self.SubnetSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVirtualSubnetWithVlanResponse(AbstractModel):
    """CreateVirtualSubnetWithVlan返回参数结构体

    """

    def __init__(self):
        """
        :param TaskId: 任务ID\n        :type TaskId: int\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.TaskId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.RequestId = params.get("RequestId")


class CreateVpcPeerConnectionRequest(AbstractModel):
    """CreateVpcPeerConnection请求参数结构体

    """

    def __init__(self):
        """
        :param VpcId: 本端VPC唯一ID\n        :type VpcId: str\n        :param PeerVpcId: 对端VPC唯一ID\n        :type PeerVpcId: str\n        :param PeerRegion: 对端地域，取值范围为gz,sh,bj,hk,cd,de,sh_bm,gz_bm,bj_bm,cq_bm等\n        :type PeerRegion: str\n        :param VpcPeerConnectionName: 对等连接名称\n        :type VpcPeerConnectionName: str\n        :param PeerUin: 对端账户OwnerUin（默认值为本端账户）\n        :type PeerUin: str\n        :param Bandwidth: 跨地域必传，带宽上限值\n        :type Bandwidth: int\n        """
        self.VpcId = None
        self.PeerVpcId = None
        self.PeerRegion = None
        self.VpcPeerConnectionName = None
        self.PeerUin = None
        self.Bandwidth = None


    def _deserialize(self, params):
        self.VpcId = params.get("VpcId")
        self.PeerVpcId = params.get("PeerVpcId")
        self.PeerRegion = params.get("PeerRegion")
        self.VpcPeerConnectionName = params.get("VpcPeerConnectionName")
        self.PeerUin = params.get("PeerUin")
        self.Bandwidth = params.get("Bandwidth")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVpcPeerConnectionResponse(AbstractModel):
    """CreateVpcPeerConnection返回参数结构体

    """

    def __init__(self):
        """
        :param TaskId: 任务ID\n        :type TaskId: int\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.TaskId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.RequestId = params.get("RequestId")


class CreateVpcRequest(AbstractModel):
    """CreateVpc请求参数结构体

    """

    def __init__(self):
        """
        :param VpcName: 私有网络的名称\n        :type VpcName: str\n        :param CidrBlock: 私有网络的CIDR\n        :type CidrBlock: str\n        :param Zone: 私有网络的可用区\n        :type Zone: str\n        :param SubnetSet: 子网信息\n        :type SubnetSet: list of VpcSubnetCreateInfo\n        :param EnableMonitoring: 是否启用内网监控\n        :type EnableMonitoring: bool\n        """
        self.VpcName = None
        self.CidrBlock = None
        self.Zone = None
        self.SubnetSet = None
        self.EnableMonitoring = None


    def _deserialize(self, params):
        self.VpcName = params.get("VpcName")
        self.CidrBlock = params.get("CidrBlock")
        self.Zone = params.get("Zone")
        if params.get("SubnetSet") is not None:
            self.SubnetSet = []
            for item in params.get("SubnetSet"):
                obj = VpcSubnetCreateInfo()
                obj._deserialize(item)
                self.SubnetSet.append(obj)
        self.EnableMonitoring = params.get("EnableMonitoring")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVpcResponse(AbstractModel):
    """CreateVpc返回参数结构体

    """

    def __init__(self):
        """
        :param TaskId: 异步任务ID\n        :type TaskId: int\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.TaskId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.RequestId = params.get("RequestId")


class CustomerGateway(AbstractModel):
    """对端网关

    """

    def __init__(self):
        """
        :param CustomerGatewayId: 用户网关唯一ID\n        :type CustomerGatewayId: str\n        :param CustomerGatewayName: 网关名称\n        :type CustomerGatewayName: str\n        :param IpAddress: 公网地址\n        :type IpAddress: str\n        :param CreateTime: 创建时间\n        :type CreateTime: str\n        :param VpnConnNum: VPN通道引用个数
注意：此字段可能返回 null，表示取不到有效值。\n        :type VpnConnNum: int\n        """
        self.CustomerGatewayId = None
        self.CustomerGatewayName = None
        self.IpAddress = None
        self.CreateTime = None
        self.VpnConnNum = None


    def _deserialize(self, params):
        self.CustomerGatewayId = params.get("CustomerGatewayId")
        self.CustomerGatewayName = params.get("CustomerGatewayName")
        self.IpAddress = params.get("IpAddress")
        self.CreateTime = params.get("CreateTime")
        self.VpnConnNum = params.get("VpnConnNum")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCustomerGatewayRequest(AbstractModel):
    """DeleteCustomerGateway请求参数结构体

    """

    def __init__(self):
        """
        :param CustomerGatewayId: 对端网关ID，例如：bmcgw-2wqq41m9，可通过DescribeCustomerGateways接口查询对端网关。\n        :type CustomerGatewayId: str\n        """
        self.CustomerGatewayId = None


    def _deserialize(self, params):
        self.CustomerGatewayId = params.get("CustomerGatewayId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCustomerGatewayResponse(AbstractModel):
    """DeleteCustomerGateway返回参数结构体

    """

    def __init__(self):
        """
        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class DeleteHostedInterfaceRequest(AbstractModel):
    """DeleteHostedInterface请求参数结构体

    """

    def __init__(self):
        """
        :param InstanceIds: 托管机器唯一ID 数组\n        :type InstanceIds: list of str\n        :param VpcId: 私有网络ID或者私有网络统一ID，建议使用统一ID\n        :type VpcId: str\n        :param SubnetId: 子网ID或者子网统一ID，建议使用统一ID\n        :type SubnetId: str\n        """
        self.InstanceIds = None
        self.VpcId = None
        self.SubnetId = None


    def _deserialize(self, params):
        self.InstanceIds = params.get("InstanceIds")
        self.VpcId = params.get("VpcId")
        self.SubnetId = params.get("SubnetId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteHostedInterfaceResponse(AbstractModel):
    """DeleteHostedInterface返回参数结构体

    """

    def __init__(self):
        """
        :param TaskId: 异步任务ID\n        :type TaskId: int\n        :param ResourceIds: 黑石托管机器ID\n        :type ResourceIds: list of str\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.TaskId = None
        self.ResourceIds = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.ResourceIds = params.get("ResourceIds")
        self.RequestId = params.get("RequestId")


class DeleteHostedInterfacesRequest(AbstractModel):
    """DeleteHostedInterfaces请求参数结构体

    """

    def __init__(self):
        """
        :param InstanceId: 物理机ID\n        :type InstanceId: str\n        :param SubnetIds: 物理机ID\n        :type SubnetIds: list of str\n        """
        self.InstanceId = None
        self.SubnetIds = None


    def _deserialize(self, params):
        self.InstanceId = params.get("InstanceId")
        self.SubnetIds = params.get("SubnetIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteHostedInterfacesResponse(AbstractModel):
    """DeleteHostedInterfaces返回参数结构体

    """

    def __init__(self):
        """
        :param TaskId: 异步任务ID\n        :type TaskId: int\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.TaskId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.RequestId = params.get("RequestId")


class DeleteInterfacesRequest(AbstractModel):
    """DeleteInterfaces请求参数结构体

    """

    def __init__(self):
        """
        :param InstanceId: 物理机ID\n        :type InstanceId: str\n        :param SubnetIds: 子网的唯一ID列表\n        :type SubnetIds: list of str\n        """
        self.InstanceId = None
        self.SubnetIds = None


    def _deserialize(self, params):
        self.InstanceId = params.get("InstanceId")
        self.SubnetIds = params.get("SubnetIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteInterfacesResponse(AbstractModel):
    """DeleteInterfaces返回参数结构体

    """

    def __init__(self):
        """
        :param TaskId: 异步任务ID\n        :type TaskId: int\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.TaskId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.RequestId = params.get("RequestId")


class DeleteNatGatewayRequest(AbstractModel):
    """DeleteNatGateway请求参数结构体

    """

    def __init__(self):
        """
        :param NatId: NAT网关ID，例如：nat-kdm476mp\n        :type NatId: str\n        :param VpcId: 私有网络ID，例如：vpc-kd7d06of\n        :type VpcId: str\n        """
        self.NatId = None
        self.VpcId = None


    def _deserialize(self, params):
        self.NatId = params.get("NatId")
        self.VpcId = params.get("VpcId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteNatGatewayResponse(AbstractModel):
    """DeleteNatGateway返回参数结构体

    """

    def __init__(self):
        """
        :param TaskId: 任务ID\n        :type TaskId: int\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.TaskId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.RequestId = params.get("RequestId")


class DeleteRoutePolicyRequest(AbstractModel):
    """DeleteRoutePolicy请求参数结构体

    """

    def __init__(self):
        """
        :param RouteTableId: 路由表ID\n        :type RouteTableId: str\n        :param RoutePolicyId: 路由表策略ID\n        :type RoutePolicyId: str\n        """
        self.RouteTableId = None
        self.RoutePolicyId = None


    def _deserialize(self, params):
        self.RouteTableId = params.get("RouteTableId")
        self.RoutePolicyId = params.get("RoutePolicyId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRoutePolicyResponse(AbstractModel):
    """DeleteRoutePolicy返回参数结构体

    """

    def __init__(self):
        """
        :param TaskId: 异步任务ID\n        :type TaskId: int\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.TaskId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.RequestId = params.get("RequestId")


class DeleteSubnetRequest(AbstractModel):
    """DeleteSubnet请求参数结构体

    """

    def __init__(self):
        """
        :param VpcId: 私有网络ID。可通过DescribeVpcs接口返回值中的VpcId获取。\n        :type VpcId: str\n        :param SubnetId: 子网实例ID。可通过DescribeSubnets接口返回值中的SubnetId获取。\n        :type SubnetId: str\n        """
        self.VpcId = None
        self.SubnetId = None


    def _deserialize(self, params):
        self.VpcId = params.get("VpcId")
        self.SubnetId = params.get("SubnetId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSubnetResponse(AbstractModel):
    """DeleteSubnet返回参数结构体

    """

    def __init__(self):
        """
        :param TaskId: 异步任务ID。\n        :type TaskId: int\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.TaskId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.RequestId = params.get("RequestId")


class DeleteVirtualIpRequest(AbstractModel):
    """DeleteVirtualIp请求参数结构体

    """

    def __init__(self):
        """
        :param VpcId: 私有网络唯一ID。\n        :type VpcId: str\n        :param Ips: 退还的IP列表。\n        :type Ips: list of str\n        """
        self.VpcId = None
        self.Ips = None


    def _deserialize(self, params):
        self.VpcId = params.get("VpcId")
        self.Ips = params.get("Ips")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteVirtualIpResponse(AbstractModel):
    """DeleteVirtualIp返回参数结构体

    """

    def __init__(self):
        """
        :param TaskId: 异步任务ID。\n        :type TaskId: int\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.TaskId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.RequestId = params.get("RequestId")


class DeleteVpcPeerConnectionRequest(AbstractModel):
    """DeleteVpcPeerConnection请求参数结构体

    """

    def __init__(self):
        """
        :param VpcPeerConnectionId: 黑石对等连接实例ID\n        :type VpcPeerConnectionId: str\n        """
        self.VpcPeerConnectionId = None


    def _deserialize(self, params):
        self.VpcPeerConnectionId = params.get("VpcPeerConnectionId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteVpcPeerConnectionResponse(AbstractModel):
    """DeleteVpcPeerConnection返回参数结构体

    """

    def __init__(self):
        """
        :param TaskId: 任务ID\n        :type TaskId: int\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.TaskId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.RequestId = params.get("RequestId")


class DeleteVpcRequest(AbstractModel):
    """DeleteVpc请求参数结构体

    """

    def __init__(self):
        """
        :param VpcId: VPC实例ID。可通过DescribeVpcs接口返回值中的VpcId获取。\n        :type VpcId: str\n        """
        self.VpcId = None


    def _deserialize(self, params):
        self.VpcId = params.get("VpcId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteVpcResponse(AbstractModel):
    """DeleteVpc返回参数结构体

    """

    def __init__(self):
        """
        :param TaskId: 异步任务ID。\n        :type TaskId: int\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.TaskId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.RequestId = params.get("RequestId")


class DeleteVpnConnectionRequest(AbstractModel):
    """DeleteVpnConnection请求参数结构体

    """

    def __init__(self):
        """
        :param VpnConnectionId: VPN通道实例ID。形如：bmvpnx-f49l6u0z。\n        :type VpnConnectionId: str\n        """
        self.VpnConnectionId = None


    def _deserialize(self, params):
        self.VpnConnectionId = params.get("VpnConnectionId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteVpnConnectionResponse(AbstractModel):
    """DeleteVpnConnection返回参数结构体

    """

    def __init__(self):
        """
        :param TaskId: 任务ID\n        :type TaskId: int\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.TaskId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.RequestId = params.get("RequestId")


class DeleteVpnGatewayRequest(AbstractModel):
    """DeleteVpnGateway请求参数结构体

    """

    def __init__(self):
        """
        :param VpnGatewayId: VPN网关实例ID。\n        :type VpnGatewayId: str\n        """
        self.VpnGatewayId = None


    def _deserialize(self, params):
        self.VpnGatewayId = params.get("VpnGatewayId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteVpnGatewayResponse(AbstractModel):
    """DeleteVpnGateway返回参数结构体

    """

    def __init__(self):
        """
        :param TaskId: 任务ID\n        :type TaskId: int\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.TaskId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.RequestId = params.get("RequestId")


class DeregisterIpsRequest(AbstractModel):
    """DeregisterIps请求参数结构体

    """

    def __init__(self):
        """
        :param VpcId: 私有网络ID\n        :type VpcId: str\n        :param IpSet: 注销指定IP的列表\n        :type IpSet: list of str\n        :param SubnetId: 私有网络子网ID\n        :type SubnetId: str\n        """
        self.VpcId = None
        self.IpSet = None
        self.SubnetId = None


    def _deserialize(self, params):
        self.VpcId = params.get("VpcId")
        self.IpSet = params.get("IpSet")
        self.SubnetId = params.get("SubnetId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeregisterIpsResponse(AbstractModel):
    """DeregisterIps返回参数结构体

    """

    def __init__(self):
        """
        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class DescribeCustomerGatewaysRequest(AbstractModel):
    """DescribeCustomerGateways请求参数结构体

    """

    def __init__(self):
        """
        :param CustomerGatewayIds: 对端网关ID，例如：bmcgw-2wqq41m9。每次请求的实例的上限为100。参数不支持同时指定CustomerGatewayIds和Filters。\n        :type CustomerGatewayIds: list of str\n        :param Filters: 过滤条件，详见下表：实例过滤条件表。每次请求的Filters的上限为10，Filter.Values的上限为5。参数不支持同时指定CustomerGatewayIds和Filters。
<li>customergateway-name - String - （过滤条件）对端网关名称。</li>
<li>ip-address - String - （过滤条件)对端网关地址。</li>
<li>customergateway-id - String - （过滤条件）对端网关唯一ID。</li>
<li>zone - String - （过滤条件）对端所在可用区，形如：ap-guangzhou-2。</li>\n        :type Filters: list of Filter\n        :param Offset: 偏移量，默认为0。关于Offset的更进一步介绍请参考 API 简介中的相关小节。\n        :type Offset: int\n        :param Limit: 返回数量，默认为20，最大值为100。\n        :type Limit: int\n        :param OrderField: 排序字段, 支持"CreateTime"排序\n        :type OrderField: str\n        :param OrderDirection: 排序方向, “asc”、“desc”\n        :type OrderDirection: str\n        """
        self.CustomerGatewayIds = None
        self.Filters = None
        self.Offset = None
        self.Limit = None
        self.OrderField = None
        self.OrderDirection = None


    def _deserialize(self, params):
        self.CustomerGatewayIds = params.get("CustomerGatewayIds")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Offset = params.get("Offset")
        self.Limit = params.get("Limit")
        self.OrderField = params.get("OrderField")
        self.OrderDirection = params.get("OrderDirection")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCustomerGatewaysResponse(AbstractModel):
    """DescribeCustomerGateways返回参数结构体

    """

    def __init__(self):
        """
        :param CustomerGatewaySet: 对端网关对象列表\n        :type CustomerGatewaySet: list of CustomerGateway\n        :param TotalCount: 符合条件的实例数量。\n        :type TotalCount: int\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.CustomerGatewaySet = None
        self.TotalCount = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("CustomerGatewaySet") is not None:
            self.CustomerGatewaySet = []
            for item in params.get("CustomerGatewaySet"):
                obj = CustomerGateway()
                obj._deserialize(item)
                self.CustomerGatewaySet.append(obj)
        self.TotalCount = params.get("TotalCount")
        self.RequestId = params.get("RequestId")


class DescribeNatGatewaysRequest(AbstractModel):
    """DescribeNatGateways请求参数结构体

    """

    def __init__(self):
        """
        :param NatId: NAT网关ID，例如：nat-kdm476mp\n        :type NatId: str\n        :param NatName: NAT名称\n        :type NatName: str\n        :param SearchKey: 搜索字段\n        :type SearchKey: str\n        :param VpcId: 私有网络ID，例如：vpc-kd7d06of\n        :type VpcId: str\n        :param Offset: 起始值\n        :type Offset: int\n        :param Limit: 偏移值，默认值为 20\n        :type Limit: int\n        :param Zone: NAT所在可用区，形如：ap-guangzhou-2。\n        :type Zone: str\n        :param OrderField: 排序字段, 支持"CreateTime"排序\n        :type OrderField: str\n        :param OrderDirection: 排序方向, “asc”、“desc”\n        :type OrderDirection: str\n        """
        self.NatId = None
        self.NatName = None
        self.SearchKey = None
        self.VpcId = None
        self.Offset = None
        self.Limit = None
        self.Zone = None
        self.OrderField = None
        self.OrderDirection = None


    def _deserialize(self, params):
        self.NatId = params.get("NatId")
        self.NatName = params.get("NatName")
        self.SearchKey = params.get("SearchKey")
        self.VpcId = params.get("VpcId")
        self.Offset = params.get("Offset")
        self.Limit = params.get("Limit")
        self.Zone = params.get("Zone")
        self.OrderField = params.get("OrderField")
        self.OrderDirection = params.get("OrderDirection")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNatGatewaysResponse(AbstractModel):
    """DescribeNatGateways返回参数结构体

    """

    def __init__(self):
        """
        :param NatGatewayInfoSet: NAT网关信息列表\n        :type NatGatewayInfoSet: list of NatGatewayInfo\n        :param TotalCount: 总数目\n        :type TotalCount: int\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.NatGatewayInfoSet = None
        self.TotalCount = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("NatGatewayInfoSet") is not None:
            self.NatGatewayInfoSet = []
            for item in params.get("NatGatewayInfoSet"):
                obj = NatGatewayInfo()
                obj._deserialize(item)
                self.NatGatewayInfoSet.append(obj)
        self.TotalCount = params.get("TotalCount")
        self.RequestId = params.get("RequestId")


class DescribeNatSubnetsRequest(AbstractModel):
    """DescribeNatSubnets请求参数结构体

    """

    def __init__(self):
        """
        :param NatId: NAT网关ID，例如：nat-kdm476mp\n        :type NatId: str\n        :param VpcId: 私有网络ID，例如：vpc-kd7d06of\n        :type VpcId: str\n        """
        self.NatId = None
        self.VpcId = None


    def _deserialize(self, params):
        self.NatId = params.get("NatId")
        self.VpcId = params.get("VpcId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNatSubnetsResponse(AbstractModel):
    """DescribeNatSubnets返回参数结构体

    """

    def __init__(self):
        """
        :param NatSubnetInfoSet: NAT子网信息\n        :type NatSubnetInfoSet: list of NatSubnetInfo\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.NatSubnetInfoSet = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("NatSubnetInfoSet") is not None:
            self.NatSubnetInfoSet = []
            for item in params.get("NatSubnetInfoSet"):
                obj = NatSubnetInfo()
                obj._deserialize(item)
                self.NatSubnetInfoSet.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeRoutePoliciesRequest(AbstractModel):
    """DescribeRoutePolicies请求参数结构体

    """

    def __init__(self):
        """
        :param RouteTableId: 路由表实例ID，例如：rtb-afg8md3c。\n        :type RouteTableId: str\n        :param RoutePolicyIds: 路由策略实例ID，例如：rti-azd4dt1c。\n        :type RoutePolicyIds: list of str\n        :param Filters: 过滤条件，参数不支持同时指定RoutePolicyIds和Filters。
route-table-id - String - （过滤条件）路由表实例ID。
vpc-id - String - （过滤条件）VPC实例ID，形如：vpc-f49l6u0z。
route-policy-id - String - （过滤条件）路由策略ID。
route-policy-description-like - String -（过滤条件）路由项备注。
route-policy-type - String - （过滤条件）路由项策略类型。
destination-cidr-like - String - （过滤条件）路由项目的地址。
gateway-id-like - String - （过滤条件）路由项下一跳网关。
gateway-type - String - （过滤条件）路由项下一条网关类型。
enable - Bool - （过滤条件）路由策略是否启用。\n        :type Filters: list of Filter\n        :param Offset: 初始行的偏移量，默认为0。\n        :type Offset: int\n        :param Limit: 每页行数，默认为20。\n        :type Limit: int\n        """
        self.RouteTableId = None
        self.RoutePolicyIds = None
        self.Filters = None
        self.Offset = None
        self.Limit = None


    def _deserialize(self, params):
        self.RouteTableId = params.get("RouteTableId")
        self.RoutePolicyIds = params.get("RoutePolicyIds")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Offset = params.get("Offset")
        self.Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRoutePoliciesResponse(AbstractModel):
    """DescribeRoutePolicies返回参数结构体

    """

    def __init__(self):
        """
        :param TotalCount: 路由策略数\n        :type TotalCount: int\n        :param RoutePolicySet: 路由策略列表\n        :type RoutePolicySet: list of RoutePolicy\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.TotalCount = None
        self.RoutePolicySet = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalCount = params.get("TotalCount")
        if params.get("RoutePolicySet") is not None:
            self.RoutePolicySet = []
            for item in params.get("RoutePolicySet"):
                obj = RoutePolicy()
                obj._deserialize(item)
                self.RoutePolicySet.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeRouteTablesRequest(AbstractModel):
    """DescribeRouteTables请求参数结构体

    """

    def __init__(self):
        """
        :param RouteTableIds: 路由表实例ID，例如：rtb-azd4dt1c。\n        :type RouteTableIds: list of str\n        :param Filters: 过滤条件，参数不支持同时指定RouteTableIds和Filters。
route-table-id - String - （过滤条件）路由表实例ID。
route-table-name - String - （过滤条件）路由表名称。
route-table-id-like - String - （模糊过滤条件）路由表实例ID。
route-table-name-like - String - （模糊过滤条件）路由表名称。
vpc-id - String - （过滤条件）VPC实例ID，形如：vpc-f49l6u0z。
zone - String - （过滤条件）可用区。\n        :type Filters: list of Filter\n        :param Offset: 初始行的偏移量，默认为0。\n        :type Offset: int\n        :param Limit: 每页行数，默认为20。\n        :type Limit: int\n        :param OrderField: 排序字段, 支持按“RouteTableId”，“VpcId”, "RouteTableName", "CreateTime"\n        :type OrderField: str\n        :param OrderDirection: 排序方向, “asc”、“desc”\n        :type OrderDirection: str\n        """
        self.RouteTableIds = None
        self.Filters = None
        self.Offset = None
        self.Limit = None
        self.OrderField = None
        self.OrderDirection = None


    def _deserialize(self, params):
        self.RouteTableIds = params.get("RouteTableIds")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Offset = params.get("Offset")
        self.Limit = params.get("Limit")
        self.OrderField = params.get("OrderField")
        self.OrderDirection = params.get("OrderDirection")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRouteTablesResponse(AbstractModel):
    """DescribeRouteTables返回参数结构体

    """

    def __init__(self):
        """
        :param TotalCount: 路由表个数\n        :type TotalCount: int\n        :param RouteTableSet: 路由表列表\n        :type RouteTableSet: list of RouteTable\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.TotalCount = None
        self.RouteTableSet = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalCount = params.get("TotalCount")
        if params.get("RouteTableSet") is not None:
            self.RouteTableSet = []
            for item in params.get("RouteTableSet"):
                obj = RouteTable()
                obj._deserialize(item)
                self.RouteTableSet.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeSubnetAvailableIpsRequest(AbstractModel):
    """DescribeSubnetAvailableIps请求参数结构体

    """

    def __init__(self):
        """
        :param SubnetId: 私有网络子网ID\n        :type SubnetId: str\n        :param Cidr: CIDR前缀，例如10.0.1\n        :type Cidr: str\n        """
        self.SubnetId = None
        self.Cidr = None


    def _deserialize(self, params):
        self.SubnetId = params.get("SubnetId")
        self.Cidr = params.get("Cidr")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSubnetAvailableIpsResponse(AbstractModel):
    """DescribeSubnetAvailableIps返回参数结构体

    """

    def __init__(self):
        """
        :param IpSet: 可用IP的范围列表\n        :type IpSet: list of str\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.IpSet = None
        self.RequestId = None


    def _deserialize(self, params):
        self.IpSet = params.get("IpSet")
        self.RequestId = params.get("RequestId")


class DescribeSubnetByDeviceRequest(AbstractModel):
    """DescribeSubnetByDevice请求参数结构体

    """

    def __init__(self):
        """
        :param InstanceId: 物理机ID\n        :type InstanceId: str\n        :param Types: 子网类型。0: 物理机子网; 7: DOCKER子网 8: 虚拟子网\n        :type Types: list of int non-negative\n        :param Offset: 查询的起始位置。\n        :type Offset: int\n        :param Limit: 查询的个数。\n        :type Limit: int\n        """
        self.InstanceId = None
        self.Types = None
        self.Offset = None
        self.Limit = None


    def _deserialize(self, params):
        self.InstanceId = params.get("InstanceId")
        self.Types = params.get("Types")
        self.Offset = params.get("Offset")
        self.Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSubnetByDeviceResponse(AbstractModel):
    """DescribeSubnetByDevice返回参数结构体

    """

    def __init__(self):
        """
        :param TotalCount: 子网个数\n        :type TotalCount: int\n        :param Data: 子网列表\n        :type Data: list of SubnetInfo\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.TotalCount = None
        self.Data = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalCount = params.get("TotalCount")
        if params.get("Data") is not None:
            self.Data = []
            for item in params.get("Data"):
                obj = SubnetInfo()
                obj._deserialize(item)
                self.Data.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeSubnetByHostedDeviceRequest(AbstractModel):
    """DescribeSubnetByHostedDevice请求参数结构体

    """

    def __init__(self):
        """
        :param InstanceId: 托管机器ID, 如chm-xasdfx2j\n        :type InstanceId: str\n        :param Types: 子网类型。0: 物理机子网; 7: DOCKER子网 8: 虚拟子网\n        :type Types: list of int non-negative\n        :param Offset: 查询的起始位置。\n        :type Offset: int\n        :param Limit: 查询的个数。\n        :type Limit: int\n        """
        self.InstanceId = None
        self.Types = None
        self.Offset = None
        self.Limit = None


    def _deserialize(self, params):
        self.InstanceId = params.get("InstanceId")
        self.Types = params.get("Types")
        self.Offset = params.get("Offset")
        self.Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSubnetByHostedDeviceResponse(AbstractModel):
    """DescribeSubnetByHostedDevice返回参数结构体

    """

    def __init__(self):
        """
        :param TotalCount: 子网个数\n        :type TotalCount: int\n        :param Data: 子网列表\n        :type Data: list of SubnetInfo\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.TotalCount = None
        self.Data = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalCount = params.get("TotalCount")
        if params.get("Data") is not None:
            self.Data = []
            for item in params.get("Data"):
                obj = SubnetInfo()
                obj._deserialize(item)
                self.Data.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeSubnetsRequest(AbstractModel):
    """DescribeSubnets请求参数结构体

    """

    def __init__(self):
        """
        :param SubnetIds: 子网实例ID查询。形如：subnet-pxir56ns。参数不支持同时指定SubnetIds和Filters。\n        :type SubnetIds: list of str\n        :param Filters: 过滤条件，参数不支持同时指定SubnetIds和Filters。
subnet-id - String - （过滤条件）Subnet实例名称。
vpc-id - String - （过滤条件）VPC实例ID，形如：vpc-f49l6u0z。
cidr-block - String - （过滤条件）vpc的cidr。
subnet-name - String - （过滤条件）子网名称。
zone - String - （过滤条件）可用区。\n        :type Filters: list of Filter\n        :param Offset: 偏移量\n        :type Offset: int\n        :param Limit: 返回数量\n        :type Limit: int\n        :param OrderField: 排序字段, 支持按“CreateTime”，“VlanId”\n        :type OrderField: str\n        :param OrderDirection: 排序方向, “asc”、“desc”\n        :type OrderDirection: str\n        """
        self.SubnetIds = None
        self.Filters = None
        self.Offset = None
        self.Limit = None
        self.OrderField = None
        self.OrderDirection = None


    def _deserialize(self, params):
        self.SubnetIds = params.get("SubnetIds")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Offset = params.get("Offset")
        self.Limit = params.get("Limit")
        self.OrderField = params.get("OrderField")
        self.OrderDirection = params.get("OrderDirection")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSubnetsResponse(AbstractModel):
    """DescribeSubnets返回参数结构体

    """

    def __init__(self):
        """
        :param SubnetSet: 子网列表信息\n        :type SubnetSet: list of SubnetInfo\n        :param TotalCount: 返回的子网总数\n        :type TotalCount: int\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.SubnetSet = None
        self.TotalCount = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("SubnetSet") is not None:
            self.SubnetSet = []
            for item in params.get("SubnetSet"):
                obj = SubnetInfo()
                obj._deserialize(item)
                self.SubnetSet.append(obj)
        self.TotalCount = params.get("TotalCount")
        self.RequestId = params.get("RequestId")


class DescribeTaskStatusRequest(AbstractModel):
    """DescribeTaskStatus请求参数结构体

    """

    def __init__(self):
        """
        :param TaskId: 任务ID\n        :type TaskId: int\n        """
        self.TaskId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskStatusResponse(AbstractModel):
    """DescribeTaskStatus返回参数结构体

    """

    def __init__(self):
        """
        :param Status: 任务状态，其中0表示任务执行成功，1表示任务执行失败，2表示任务正在执行中\n        :type Status: int\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.Status = None
        self.RequestId = None


    def _deserialize(self, params):
        self.Status = params.get("Status")
        self.RequestId = params.get("RequestId")


class DescribeVpcPeerConnectionsRequest(AbstractModel):
    """DescribeVpcPeerConnections请求参数结构体

    """

    def __init__(self):
        """
        :param VpcPeerConnectionIds: 对等连接实例ID\n        :type VpcPeerConnectionIds: list of str\n        :param Filters: 过滤条件，详见下表：实例过滤条件表。每次请求的Filters的上限为10，Filter.Values的上限为5。参数不支持同时指定VpcPeerConnectionIds和Filters。
过滤条件，参数不支持同时指定VpcPeerConnectionIds和Filters。
<li>peer-name - String - （过滤条件）对等连接名称。</li>\n        :type Filters: list of Filter\n        :param Offset: 偏移量，默认为0。关于Offset的更进一步介绍请参考 API 简介中的相关小节。\n        :type Offset: int\n        :param Limit: 返回数量，默认为20，最大值为100。\n        :type Limit: int\n        :param VpcId: 私有网络ID\n        :type VpcId: str\n        """
        self.VpcPeerConnectionIds = None
        self.Filters = None
        self.Offset = None
        self.Limit = None
        self.VpcId = None


    def _deserialize(self, params):
        self.VpcPeerConnectionIds = params.get("VpcPeerConnectionIds")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Offset = params.get("Offset")
        self.Limit = params.get("Limit")
        self.VpcId = params.get("VpcId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVpcPeerConnectionsResponse(AbstractModel):
    """DescribeVpcPeerConnections返回参数结构体

    """

    def __init__(self):
        """
        :param TotalCount: 符合条件的实例数量。\n        :type TotalCount: int\n        :param VpcPeerConnectionSet: 对等连接实例。\n        :type VpcPeerConnectionSet: list of VpcPeerConnection\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.TotalCount = None
        self.VpcPeerConnectionSet = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalCount = params.get("TotalCount")
        if params.get("VpcPeerConnectionSet") is not None:
            self.VpcPeerConnectionSet = []
            for item in params.get("VpcPeerConnectionSet"):
                obj = VpcPeerConnection()
                obj._deserialize(item)
                self.VpcPeerConnectionSet.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeVpcQuotaRequest(AbstractModel):
    """DescribeVpcQuota请求参数结构体

    """

    def __init__(self):
        """
        :param TypeIds: 类型\n        :type TypeIds: list of int non-negative\n        """
        self.TypeIds = None


    def _deserialize(self, params):
        self.TypeIds = params.get("TypeIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVpcQuotaResponse(AbstractModel):
    """DescribeVpcQuota返回参数结构体

    """

    def __init__(self):
        """
        :param VpcQuotaSet: 配额信息\n        :type VpcQuotaSet: list of VpcQuota\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.VpcQuotaSet = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("VpcQuotaSet") is not None:
            self.VpcQuotaSet = []
            for item in params.get("VpcQuotaSet"):
                obj = VpcQuota()
                obj._deserialize(item)
                self.VpcQuotaSet.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeVpcResourceRequest(AbstractModel):
    """DescribeVpcResource请求参数结构体

    """

    def __init__(self):
        """
        :param VpcIds: 私有网络实例ID\n        :type VpcIds: list of str\n        :param Filters: 过滤条件，参数不支持同时指定SubnetIds和Filters。
vpc-id - String - （过滤条件）私有网络实例ID，形如：vpc-f49l6u0z。
vpc-name - String - （过滤条件）私有网络名称。
zone - String - （过滤条件）可用区。
state - String - （过滤条件）VPC状态。available: 运营中; pending: 创建中; failed: 创建失败; deleting: 删除中\n        :type Filters: list of Filter\n        :param Offset: 偏移量\n        :type Offset: int\n        :param Limit: 返回数量\n        :type Limit: int\n        :param OrderField: 排序字段\n        :type OrderField: str\n        :param OrderDirection: 排序方向, “asc”、“desc”\n        :type OrderDirection: str\n        """
        self.VpcIds = None
        self.Filters = None
        self.Offset = None
        self.Limit = None
        self.OrderField = None
        self.OrderDirection = None


    def _deserialize(self, params):
        self.VpcIds = params.get("VpcIds")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Offset = params.get("Offset")
        self.Limit = params.get("Limit")
        self.OrderField = params.get("OrderField")
        self.OrderDirection = params.get("OrderDirection")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVpcResourceResponse(AbstractModel):
    """DescribeVpcResource返回参数结构体

    """

    def __init__(self):
        """
        :param VpcResourceSet: VPC数据\n        :type VpcResourceSet: list of VpcResource\n        :param TotalCount: VPC个数\n        :type TotalCount: int\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.VpcResourceSet = None
        self.TotalCount = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("VpcResourceSet") is not None:
            self.VpcResourceSet = []
            for item in params.get("VpcResourceSet"):
                obj = VpcResource()
                obj._deserialize(item)
                self.VpcResourceSet.append(obj)
        self.TotalCount = params.get("TotalCount")
        self.RequestId = params.get("RequestId")


class DescribeVpcViewRequest(AbstractModel):
    """DescribeVpcView请求参数结构体

    """

    def __init__(self):
        """
        :param VpcId: 私有网络唯一ID\n        :type VpcId: str\n        """
        self.VpcId = None


    def _deserialize(self, params):
        self.VpcId = params.get("VpcId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVpcViewResponse(AbstractModel):
    """DescribeVpcView返回参数结构体

    """

    def __init__(self):
        """
        :param VpcView: VPC视图信息\n        :type VpcView: :class:`tencentcloud.bmvpc.v20180625.models.VpcViewInfo`\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.VpcView = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("VpcView") is not None:
            self.VpcView = VpcViewInfo()
            self.VpcView._deserialize(params.get("VpcView"))
        self.RequestId = params.get("RequestId")


class DescribeVpcsRequest(AbstractModel):
    """DescribeVpcs请求参数结构体

    """

    def __init__(self):
        """
        :param VpcIds: VPC实例ID。形如：vpc-f49l6u0z。每次请求的实例的上限为100。参数不支持同时指定VpcIds和Filters。\n        :type VpcIds: list of str\n        :param Filters: 过滤条件，参数不支持同时指定VpcIds和Filters。
vpc-name - String - （过滤条件）VPC实例名称。
vpc-id - String - （过滤条件）VPC实例ID形如：vpc-f49l6u0z。
cidr-block - String - （过滤条件）vpc的cidr。
state - String - （过滤条件）VPC状态。(pending | available).
zone -  String - （过滤条件）VPC的可用区。\n        :type Filters: list of Filter\n        :param Offset: 初始行的偏移量，默认为0。\n        :type Offset: int\n        :param Limit: 每页行数，默认为20。\n        :type Limit: int\n        """
        self.VpcIds = None
        self.Filters = None
        self.Offset = None
        self.Limit = None


    def _deserialize(self, params):
        self.VpcIds = params.get("VpcIds")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Offset = params.get("Offset")
        self.Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVpcsResponse(AbstractModel):
    """DescribeVpcs返回参数结构体

    """

    def __init__(self):
        """
        :param VpcSet: VPC列表\n        :type VpcSet: list of VpcInfo\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.VpcSet = None
        self.RequestId = None


    def _deserialize(self, params):
        if params.get("VpcSet") is not None:
            self.VpcSet = []
            for item in params.get("VpcSet"):
                obj = VpcInfo()
                obj._deserialize(item)
                self.VpcSet.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeVpnConnectionsRequest(AbstractModel):
    """DescribeVpnConnections请求参数结构体

    """

    def __init__(self):
        """
        :param VpnConnectionIds: VPN通道实例ID。形如：bmvpnx-f49l6u0z。每次请求的实例的上限为100。参数不支持同时指定VpnConnectionIds和Filters。\n        :type VpnConnectionIds: list of str\n        :param Filters: 过滤条件，详见下表：实例过滤条件表。每次请求的Filters的上限为10，Filter.Values的上限为5。参数不支持同时指定VpnConnectionIds和Filters。
<li>vpc-id - String - （过滤条件）VPC实例ID形如：vpc-f49l6u0z。</li>
<li>state - String - （过滤条件 VPN状态：creating，available，createfailed，changing，changefailed，deleting，deletefailed。</li>
<li>zone - String - （过滤条件）VPN所在可用区，形如：ap-guangzhou-2。</li>\n        :type Filters: list of Filter\n        :param Offset: 偏移量，默认为0。关于Offset的更进一步介绍请参考 API 简介中的相关小节。\n        :type Offset: int\n        :param Limit: 返回数量，默认为20，最大值为100。\n        :type Limit: int\n        :param VpnGatewayId: VPN网关实例ID\n        :type VpnGatewayId: str\n        :param VpnConnectionName: VPN通道名称\n        :type VpnConnectionName: str\n        :param OrderField: 排序字段, 支持"CreateTime"排序\n        :type OrderField: str\n        :param OrderDirection: 排序方向, “asc”、“desc”\n        :type OrderDirection: str\n        """
        self.VpnConnectionIds = None
        self.Filters = None
        self.Offset = None
        self.Limit = None
        self.VpnGatewayId = None
        self.VpnConnectionName = None
        self.OrderField = None
        self.OrderDirection = None


    def _deserialize(self, params):
        self.VpnConnectionIds = params.get("VpnConnectionIds")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Offset = params.get("Offset")
        self.Limit = params.get("Limit")
        self.VpnGatewayId = params.get("VpnGatewayId")
        self.VpnConnectionName = params.get("VpnConnectionName")
        self.OrderField = params.get("OrderField")
        self.OrderDirection = params.get("OrderDirection")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVpnConnectionsResponse(AbstractModel):
    """DescribeVpnConnections返回参数结构体

    """

    def __init__(self):
        """
        :param TotalCount: 符合条件的实例数量。\n        :type TotalCount: int\n        :param VpnConnectionSet: VPN通道实例。\n        :type VpnConnectionSet: list of VpnConnection\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.TotalCount = None
        self.VpnConnectionSet = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalCount = params.get("TotalCount")
        if params.get("VpnConnectionSet") is not None:
            self.VpnConnectionSet = []
            for item in params.get("VpnConnectionSet"):
                obj = VpnConnection()
                obj._deserialize(item)
                self.VpnConnectionSet.append(obj)
        self.RequestId = params.get("RequestId")


class DescribeVpnGatewaysRequest(AbstractModel):
    """DescribeVpnGateways请求参数结构体

    """

    def __init__(self):
        """
        :param VpnGatewayIds: VPN网关实例ID。形如：bmvpngw-f49l6u0z。每次请求的实例的上限为100。参数不支持同时指定VpnGatewayIds和Filters。\n        :type VpnGatewayIds: list of str\n        :param Filters: 过滤条件，参数不支持同时指定VpnGatewayIds和Filters。
<li>vpc-id - String - （过滤条件）VPC实例ID形如：vpc-f49l6u0z。</li>
<li>state - String - （过滤条件 VPN状态：creating，available，createfailed，changing，changefailed，deleting，deletefailed。</li>
<li>zone - String - （过滤条件）VPN所在可用区，形如：ap-guangzhou-2。</li>
<li>vpngw-name - String - （过滤条件）vpn网关名称。</li>\n        :type Filters: list of Filter\n        :param Offset: 偏移量\n        :type Offset: int\n        :param Limit: 请求对象个数\n        :type Limit: int\n        :param OrderField: 排序字段, 支持"CreateTime"排序\n        :type OrderField: str\n        :param OrderDirection: 排序方向, “asc”、“desc”\n        :type OrderDirection: str\n        """
        self.VpnGatewayIds = None
        self.Filters = None
        self.Offset = None
        self.Limit = None
        self.OrderField = None
        self.OrderDirection = None


    def _deserialize(self, params):
        self.VpnGatewayIds = params.get("VpnGatewayIds")
        if params.get("Filters") is not None:
            self.Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self.Filters.append(obj)
        self.Offset = params.get("Offset")
        self.Limit = params.get("Limit")
        self.OrderField = params.get("OrderField")
        self.OrderDirection = params.get("OrderDirection")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVpnGatewaysResponse(AbstractModel):
    """DescribeVpnGateways返回参数结构体

    """

    def __init__(self):
        """
        :param TotalCount: 符合条件的实例数量。\n        :type TotalCount: int\n        :param VpnGatewaySet: VPN网关实例详细信息列表。\n        :type VpnGatewaySet: list of VpnGateway\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.TotalCount = None
        self.VpnGatewaySet = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TotalCount = params.get("TotalCount")
        if params.get("VpnGatewaySet") is not None:
            self.VpnGatewaySet = []
            for item in params.get("VpnGatewaySet"):
                obj = VpnGateway()
                obj._deserialize(item)
                self.VpnGatewaySet.append(obj)
        self.RequestId = params.get("RequestId")


class DownloadCustomerGatewayConfigurationRequest(AbstractModel):
    """DownloadCustomerGatewayConfiguration请求参数结构体

    """

    def __init__(self):
        """
        :param VpnConnectionId: VPN通道实例ID。形如：bmvpnx-f49l6u0z。\n        :type VpnConnectionId: str\n        :param VendorName: 厂商,取值 h3c，cisco\n        :type VendorName: str\n        """
        self.VpnConnectionId = None
        self.VendorName = None


    def _deserialize(self, params):
        self.VpnConnectionId = params.get("VpnConnectionId")
        self.VendorName = params.get("VendorName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DownloadCustomerGatewayConfigurationResponse(AbstractModel):
    """DownloadCustomerGatewayConfiguration返回参数结构体

    """

    def __init__(self):
        """
        :param CustomerGatewayConfiguration: 配置信息。\n        :type CustomerGatewayConfiguration: str\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.CustomerGatewayConfiguration = None
        self.RequestId = None


    def _deserialize(self, params):
        self.CustomerGatewayConfiguration = params.get("CustomerGatewayConfiguration")
        self.RequestId = params.get("RequestId")


class Filter(AbstractModel):
    """过滤器

    """

    def __init__(self):
        """
        :param Name: 属性名称, 若存在多个Filter时，Filter间的关系为逻辑与（AND）关系。\n        :type Name: str\n        :param Values: 属性值, 若同一个Filter存在多个Values，同一Filter下Values间的关系为逻辑或（OR）关系。\n        :type Values: list of str\n        """
        self.Name = None
        self.Values = None


    def _deserialize(self, params):
        self.Name = params.get("Name")
        self.Values = params.get("Values")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class IKEOptionsSpecification(AbstractModel):
    """IKE配置（Internet Key Exchange，因特网密钥交换），IKE具有一套自我保护机制，用户配置网络安全协议

    """

    def __init__(self):
        """
        :param PropoEncryAlgorithm: 加密算法，可选值：'3DES-CBC', 'AES-CBC-128', 'AES-CBC-192', 'AES-CBC-256', 'DES-CBC'，默认为3DES-CBC\n        :type PropoEncryAlgorithm: str\n        :param PropoAuthenAlgorithm: 认证算法：可选值：'MD5', 'SHA1'，默认为MD5\n        :type PropoAuthenAlgorithm: str\n        :param ExchangeMode: 协商模式：可选值：'AGGRESSIVE', 'MAIN'，默认为MAIN\n        :type ExchangeMode: str\n        :param LocalIdentity: 本端标识类型：可选值：'ADDRESS', 'FQDN'，默认为ADDRESS\n        :type LocalIdentity: str\n        :param RemoteIdentity: 对端标识类型：可选值：'ADDRESS', 'FQDN'，默认为ADDRESS\n        :type RemoteIdentity: str\n        :param LocalAddress: 本端标识，当LocalIdentity选为ADDRESS时，LocalAddress必填。localAddress默认为vpn网关公网IP\n        :type LocalAddress: str\n        :param RemoteAddress: 对端标识，当RemoteIdentity选为ADDRESS时，RemoteAddress必填\n        :type RemoteAddress: str\n        :param LocalFqdnName: 本端标识，当LocalIdentity选为FQDN时，LocalFqdnName必填\n        :type LocalFqdnName: str\n        :param RemoteFqdnName: 对端标识，当remoteIdentity选为FQDN时，RemoteFqdnName必填\n        :type RemoteFqdnName: str\n        :param DhGroupName: DH group，指定IKE交换密钥时使用的DH组，可选值：'GROUP1', 'GROUP2', 'GROUP5', 'GROUP14', 'GROUP24'，\n        :type DhGroupName: str\n        :param IKESaLifetimeSeconds: IKE SA Lifetime，单位：秒，设置IKE SA的生存周期，取值范围：60-604800\n        :type IKESaLifetimeSeconds: int\n        :param IKEVersion: IKE版本\n        :type IKEVersion: str\n        """
        self.PropoEncryAlgorithm = None
        self.PropoAuthenAlgorithm = None
        self.ExchangeMode = None
        self.LocalIdentity = None
        self.RemoteIdentity = None
        self.LocalAddress = None
        self.RemoteAddress = None
        self.LocalFqdnName = None
        self.RemoteFqdnName = None
        self.DhGroupName = None
        self.IKESaLifetimeSeconds = None
        self.IKEVersion = None


    def _deserialize(self, params):
        self.PropoEncryAlgorithm = params.get("PropoEncryAlgorithm")
        self.PropoAuthenAlgorithm = params.get("PropoAuthenAlgorithm")
        self.ExchangeMode = params.get("ExchangeMode")
        self.LocalIdentity = params.get("LocalIdentity")
        self.RemoteIdentity = params.get("RemoteIdentity")
        self.LocalAddress = params.get("LocalAddress")
        self.RemoteAddress = params.get("RemoteAddress")
        self.LocalFqdnName = params.get("LocalFqdnName")
        self.RemoteFqdnName = params.get("RemoteFqdnName")
        self.DhGroupName = params.get("DhGroupName")
        self.IKESaLifetimeSeconds = params.get("IKESaLifetimeSeconds")
        self.IKEVersion = params.get("IKEVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class IPSECOptionsSpecification(AbstractModel):
    """IPSec配置，腾讯云提供IPSec安全会话设置

    """

    def __init__(self):
        """
        :param PfsDhGroup: PFS：可选值：'NULL', 'DH-GROUP1', 'DH-GROUP2', 'DH-GROUP5', 'DH-GROUP14', 'DH-GROUP24'，默认为NULL\n        :type PfsDhGroup: str\n        :param IPSECSaLifetimeTraffic: IPsec SA lifetime(KB)：单位KB，取值范围：2560-604800\n        :type IPSECSaLifetimeTraffic: int\n        :param EncryptAlgorithm: 加密算法，可选值：'3DES-CBC', 'AES-CBC-128', 'AES-CBC-192', 'AES-CBC-256', 'DES-CBC', 'NULL'， 默认为AES-CBC-128\n        :type EncryptAlgorithm: str\n        :param IntegrityAlgorith: 认证算法：可选值：'MD5', 'SHA1'，默认为\n        :type IntegrityAlgorith: str\n        :param IPSECSaLifetimeSeconds: IPsec SA lifetime(s)：单位秒，取值范围：180-604800\n        :type IPSECSaLifetimeSeconds: int\n        :param SecurityProto: 安全协议，默认为ESP\n        :type SecurityProto: str\n        :param EncapMode: 报文封装模式:默认为Tunnel\n        :type EncapMode: str\n        """
        self.PfsDhGroup = None
        self.IPSECSaLifetimeTraffic = None
        self.EncryptAlgorithm = None
        self.IntegrityAlgorith = None
        self.IPSECSaLifetimeSeconds = None
        self.SecurityProto = None
        self.EncapMode = None


    def _deserialize(self, params):
        self.PfsDhGroup = params.get("PfsDhGroup")
        self.IPSECSaLifetimeTraffic = params.get("IPSECSaLifetimeTraffic")
        self.EncryptAlgorithm = params.get("EncryptAlgorithm")
        self.IntegrityAlgorith = params.get("IntegrityAlgorith")
        self.IPSECSaLifetimeSeconds = params.get("IPSECSaLifetimeSeconds")
        self.SecurityProto = params.get("SecurityProto")
        self.EncapMode = params.get("EncapMode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class IpInfo(AbstractModel):
    """NAT IP信息

    """

    def __init__(self):
        """
        :param SubnetId: 子网ID\n        :type SubnetId: str\n        :param Ips: IP列表\n        :type Ips: list of str\n        """
        self.SubnetId = None
        self.Ips = None


    def _deserialize(self, params):
        self.SubnetId = params.get("SubnetId")
        self.Ips = params.get("Ips")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyCustomerGatewayAttributeRequest(AbstractModel):
    """ModifyCustomerGatewayAttribute请求参数结构体

    """

    def __init__(self):
        """
        :param CustomerGatewayId: 对端网关ID，例如：bmcgw-2wqq41m9，可通过DescribeCustomerGateways接口查询对端网关。\n        :type CustomerGatewayId: str\n        :param CustomerGatewayName: 对端网关名称，可任意命名，但不得超过60个字符。\n        :type CustomerGatewayName: str\n        """
        self.CustomerGatewayId = None
        self.CustomerGatewayName = None


    def _deserialize(self, params):
        self.CustomerGatewayId = params.get("CustomerGatewayId")
        self.CustomerGatewayName = params.get("CustomerGatewayName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyCustomerGatewayAttributeResponse(AbstractModel):
    """ModifyCustomerGatewayAttribute返回参数结构体

    """

    def __init__(self):
        """
        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class ModifyRoutePolicyRequest(AbstractModel):
    """ModifyRoutePolicy请求参数结构体

    """

    def __init__(self):
        """
        :param RouteTableId: 路由表ID\n        :type RouteTableId: str\n        :param RoutePolicy: 修改的路由\n        :type RoutePolicy: :class:`tencentcloud.bmvpc.v20180625.models.RoutePolicy`\n        """
        self.RouteTableId = None
        self.RoutePolicy = None


    def _deserialize(self, params):
        self.RouteTableId = params.get("RouteTableId")
        if params.get("RoutePolicy") is not None:
            self.RoutePolicy = RoutePolicy()
            self.RoutePolicy._deserialize(params.get("RoutePolicy"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyRoutePolicyResponse(AbstractModel):
    """ModifyRoutePolicy返回参数结构体

    """

    def __init__(self):
        """
        :param TaskId: 异步任务ID\n        :type TaskId: int\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.TaskId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.RequestId = params.get("RequestId")


class ModifyRouteTableRequest(AbstractModel):
    """ModifyRouteTable请求参数结构体

    """

    def __init__(self):
        """
        :param RouteTableId: 路由表ID\n        :type RouteTableId: str\n        :param RouteTableName: 路由表名称\n        :type RouteTableName: str\n        """
        self.RouteTableId = None
        self.RouteTableName = None


    def _deserialize(self, params):
        self.RouteTableId = params.get("RouteTableId")
        self.RouteTableName = params.get("RouteTableName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyRouteTableResponse(AbstractModel):
    """ModifyRouteTable返回参数结构体

    """

    def __init__(self):
        """
        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class ModifySubnetAttributeRequest(AbstractModel):
    """ModifySubnetAttribute请求参数结构体

    """

    def __init__(self):
        """
        :param VpcId: 私有网络ID\n        :type VpcId: str\n        :param SubnetId: 子网ID\n        :type SubnetId: str\n        :param SubnetName: 子网名称\n        :type SubnetName: str\n        """
        self.VpcId = None
        self.SubnetId = None
        self.SubnetName = None


    def _deserialize(self, params):
        self.VpcId = params.get("VpcId")
        self.SubnetId = params.get("SubnetId")
        self.SubnetName = params.get("SubnetName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifySubnetAttributeResponse(AbstractModel):
    """ModifySubnetAttribute返回参数结构体

    """

    def __init__(self):
        """
        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class ModifySubnetDHCPRelayRequest(AbstractModel):
    """ModifySubnetDHCPRelay请求参数结构体

    """

    def __init__(self):
        """
        :param VpcId: 私有网络ID\n        :type VpcId: str\n        :param SubnetId: 子网ID\n        :type SubnetId: str\n        :param EnableDHCP: 是否开启DHCP Relay\n        :type EnableDHCP: bool\n        :param ServerIps: DHCP服务器IP\n        :type ServerIps: list of str\n        :param ReservedIpCount: 预留IP个数\n        :type ReservedIpCount: int\n        """
        self.VpcId = None
        self.SubnetId = None
        self.EnableDHCP = None
        self.ServerIps = None
        self.ReservedIpCount = None


    def _deserialize(self, params):
        self.VpcId = params.get("VpcId")
        self.SubnetId = params.get("SubnetId")
        self.EnableDHCP = params.get("EnableDHCP")
        self.ServerIps = params.get("ServerIps")
        self.ReservedIpCount = params.get("ReservedIpCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifySubnetDHCPRelayResponse(AbstractModel):
    """ModifySubnetDHCPRelay返回参数结构体

    """

    def __init__(self):
        """
        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class ModifyVpcAttributeRequest(AbstractModel):
    """ModifyVpcAttribute请求参数结构体

    """

    def __init__(self):
        """
        :param VpcId: 私有网络ID\n        :type VpcId: str\n        :param VpcName: 私有网络名称\n        :type VpcName: str\n        :param EnableMonitor: 是否开启内网监控，0为关闭，1为开启\n        :type EnableMonitor: bool\n        """
        self.VpcId = None
        self.VpcName = None
        self.EnableMonitor = None


    def _deserialize(self, params):
        self.VpcId = params.get("VpcId")
        self.VpcName = params.get("VpcName")
        self.EnableMonitor = params.get("EnableMonitor")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyVpcAttributeResponse(AbstractModel):
    """ModifyVpcAttribute返回参数结构体

    """

    def __init__(self):
        """
        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class ModifyVpcPeerConnectionRequest(AbstractModel):
    """ModifyVpcPeerConnection请求参数结构体

    """

    def __init__(self):
        """
        :param VpcPeerConnectionId: 黑石对等连接唯一ID\n        :type VpcPeerConnectionId: str\n        :param Bandwidth: 对等连接带宽\n        :type Bandwidth: int\n        :param VpcPeerConnectionName: 对等连接名称\n        :type VpcPeerConnectionName: str\n        """
        self.VpcPeerConnectionId = None
        self.Bandwidth = None
        self.VpcPeerConnectionName = None


    def _deserialize(self, params):
        self.VpcPeerConnectionId = params.get("VpcPeerConnectionId")
        self.Bandwidth = params.get("Bandwidth")
        self.VpcPeerConnectionName = params.get("VpcPeerConnectionName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyVpcPeerConnectionResponse(AbstractModel):
    """ModifyVpcPeerConnection返回参数结构体

    """

    def __init__(self):
        """
        :param TaskId: 任务ID\n        :type TaskId: int\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.TaskId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.RequestId = params.get("RequestId")


class ModifyVpnConnectionAttributeRequest(AbstractModel):
    """ModifyVpnConnectionAttribute请求参数结构体

    """

    def __init__(self):
        """
        :param VpnConnectionId: VPN通道实例ID。形如：bmvpnx-f49l6u0z。\n        :type VpnConnectionId: str\n        :param VpcId: VPC实例ID\n        :type VpcId: str\n        :param VpnConnectionName: VPN通道名称，可任意命名，但不得超过60个字符。\n        :type VpnConnectionName: str\n        :param PreShareKey: 预共享密钥。\n        :type PreShareKey: str\n        :param SecurityPolicyDatabases: SPD策略组，例如：{"10.0.0.5/24":["172.123.10.5/16"]}，10.0.0.5/24是vpc内网段172.123.10.5/16是IDC网段。用户指定VPC内哪些网段可以和您IDC中哪些网段通信。\n        :type SecurityPolicyDatabases: list of SecurityPolicyDatabase\n        :param IKEOptionsSpecification: IKE配置（Internet Key Exchange，因特网密钥交换），IKE具有一套自我保护机制，用户配置网络安全协议。\n        :type IKEOptionsSpecification: :class:`tencentcloud.bmvpc.v20180625.models.IKEOptionsSpecification`\n        :param IPSECOptionsSpecification: IPSec配置，腾讯云提供IPSec安全会话设置。\n        :type IPSECOptionsSpecification: :class:`tencentcloud.bmvpc.v20180625.models.IPSECOptionsSpecification`\n        """
        self.VpnConnectionId = None
        self.VpcId = None
        self.VpnConnectionName = None
        self.PreShareKey = None
        self.SecurityPolicyDatabases = None
        self.IKEOptionsSpecification = None
        self.IPSECOptionsSpecification = None


    def _deserialize(self, params):
        self.VpnConnectionId = params.get("VpnConnectionId")
        self.VpcId = params.get("VpcId")
        self.VpnConnectionName = params.get("VpnConnectionName")
        self.PreShareKey = params.get("PreShareKey")
        if params.get("SecurityPolicyDatabases") is not None:
            self.SecurityPolicyDatabases = []
            for item in params.get("SecurityPolicyDatabases"):
                obj = SecurityPolicyDatabase()
                obj._deserialize(item)
                self.SecurityPolicyDatabases.append(obj)
        if params.get("IKEOptionsSpecification") is not None:
            self.IKEOptionsSpecification = IKEOptionsSpecification()
            self.IKEOptionsSpecification._deserialize(params.get("IKEOptionsSpecification"))
        if params.get("IPSECOptionsSpecification") is not None:
            self.IPSECOptionsSpecification = IPSECOptionsSpecification()
            self.IPSECOptionsSpecification._deserialize(params.get("IPSECOptionsSpecification"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyVpnConnectionAttributeResponse(AbstractModel):
    """ModifyVpnConnectionAttribute返回参数结构体

    """

    def __init__(self):
        """
        :param TaskId: 任务ID\n        :type TaskId: int\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.TaskId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.RequestId = params.get("RequestId")


class ModifyVpnGatewayAttributeRequest(AbstractModel):
    """ModifyVpnGatewayAttribute请求参数结构体

    """

    def __init__(self):
        """
        :param VpnGatewayId: VPN网关实例ID。\n        :type VpnGatewayId: str\n        :param VpnGatewayName: VPN网关名称，最大长度不能超过60个字节。\n        :type VpnGatewayName: str\n        """
        self.VpnGatewayId = None
        self.VpnGatewayName = None


    def _deserialize(self, params):
        self.VpnGatewayId = params.get("VpnGatewayId")
        self.VpnGatewayName = params.get("VpnGatewayName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyVpnGatewayAttributeResponse(AbstractModel):
    """ModifyVpnGatewayAttribute返回参数结构体

    """

    def __init__(self):
        """
        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class NatGatewayInfo(AbstractModel):
    """NAT详情

    """

    def __init__(self):
        """
        :param NatId: NAT网关ID\n        :type NatId: str\n        :param NatName: 网关名称\n        :type NatName: str\n        :param VpcId: 私有网络ID\n        :type VpcId: str\n        :param VpcName: 私有网络名称\n        :type VpcName: str\n        :param ProductionStatus: 网关创建状态，其中0表示创建中，1表示运行中，2表示创建失败\n        :type ProductionStatus: int\n        :param Eips: EIP列表\n        :type Eips: list of str\n        :param MaxConcurrent: 并发连接数规格，取值为1000000, 3000000, 10000000\n        :type MaxConcurrent: int\n        :param Zone: 可用区\n        :type Zone: str\n        :param Exclusive: 独占标识，其中0表示共享，1表示独占，默认值为0\n        :type Exclusive: int\n        :param ForwardMode: 转发模式，其中0表示IP方式，1表示网段方式\n        :type ForwardMode: int\n        :param VpcCidrBlock: 私有网络网段\n        :type VpcCidrBlock: str\n        :param Type: 网关类型，取值为 small，middle，big，分别对应小型、中型、大型\n        :type Type: str\n        :param CreateTime: 创建时间\n        :type CreateTime: str\n        :param State: 网关启用状态，1为禁用，0为启用。\n        :type State: int\n        :param IntVpcId: 私有网络整型ID\n        :type IntVpcId: int\n        :param NatResourceId: NAT资源ID\n        :type NatResourceId: int\n        """
        self.NatId = None
        self.NatName = None
        self.VpcId = None
        self.VpcName = None
        self.ProductionStatus = None
        self.Eips = None
        self.MaxConcurrent = None
        self.Zone = None
        self.Exclusive = None
        self.ForwardMode = None
        self.VpcCidrBlock = None
        self.Type = None
        self.CreateTime = None
        self.State = None
        self.IntVpcId = None
        self.NatResourceId = None


    def _deserialize(self, params):
        self.NatId = params.get("NatId")
        self.NatName = params.get("NatName")
        self.VpcId = params.get("VpcId")
        self.VpcName = params.get("VpcName")
        self.ProductionStatus = params.get("ProductionStatus")
        self.Eips = params.get("Eips")
        self.MaxConcurrent = params.get("MaxConcurrent")
        self.Zone = params.get("Zone")
        self.Exclusive = params.get("Exclusive")
        self.ForwardMode = params.get("ForwardMode")
        self.VpcCidrBlock = params.get("VpcCidrBlock")
        self.Type = params.get("Type")
        self.CreateTime = params.get("CreateTime")
        self.State = params.get("State")
        self.IntVpcId = params.get("IntVpcId")
        self.NatResourceId = params.get("NatResourceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NatSubnetInfo(AbstractModel):
    """NAT子网信息

    """

    def __init__(self):
        """
        :param Name: 子网名称\n        :type Name: str\n        :param SubnetId: 子网ID\n        :type SubnetId: str\n        :param SubnetNatType: NAT子网类型，其中0表示绑定部分IP的NAT子网，1表示绑定全部IP的NAT子网，2表示绑定网关方式的NAT子网\n        :type SubnetNatType: int\n        :param CidrBlock: 子网网段\n        :type CidrBlock: str\n        """
        self.Name = None
        self.SubnetId = None
        self.SubnetNatType = None
        self.CidrBlock = None


    def _deserialize(self, params):
        self.Name = params.get("Name")
        self.SubnetId = params.get("SubnetId")
        self.SubnetNatType = params.get("SubnetNatType")
        self.CidrBlock = params.get("CidrBlock")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RejectVpcPeerConnectionRequest(AbstractModel):
    """RejectVpcPeerConnection请求参数结构体

    """

    def __init__(self):
        """
        :param VpcPeerConnectionId: 黑石对等连接实例ID\n        :type VpcPeerConnectionId: str\n        """
        self.VpcPeerConnectionId = None


    def _deserialize(self, params):
        self.VpcPeerConnectionId = params.get("VpcPeerConnectionId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RejectVpcPeerConnectionResponse(AbstractModel):
    """RejectVpcPeerConnection返回参数结构体

    """

    def __init__(self):
        """
        :param TaskId: 任务ID\n        :type TaskId: int\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.TaskId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.RequestId = params.get("RequestId")


class ResetVpnConnectionRequest(AbstractModel):
    """ResetVpnConnection请求参数结构体

    """

    def __init__(self):
        """
        :param VpcId: VPC唯一ID\n        :type VpcId: str\n        :param VpnConnectionId: VPN通道实例ID。形如：bmvpnx-f49l6u0z。\n        :type VpnConnectionId: str\n        """
        self.VpcId = None
        self.VpnConnectionId = None


    def _deserialize(self, params):
        self.VpcId = params.get("VpcId")
        self.VpnConnectionId = params.get("VpnConnectionId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ResetVpnConnectionResponse(AbstractModel):
    """ResetVpnConnection返回参数结构体

    """

    def __init__(self):
        """
        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.RequestId = None


    def _deserialize(self, params):
        self.RequestId = params.get("RequestId")


class RoutePolicy(AbstractModel):
    """路由条目

    """

    def __init__(self):
        """
        :param DestinationCidrBlock: 目的网段\n        :type DestinationCidrBlock: str\n        :param GatewayType: 下一跳类型，目前我们支持的类型有：
LOCAL：物理机默认路由；
VPN：VPN网关；
PEERCONNECTION：对等连接；
CPM：物理机自定义路由；
CCN：云联网；
TGW：公网默认路由；
SSLVPN : SSH SSL VPN网关。\n        :type GatewayType: str\n        :param GatewayId: 下一跳地址，这里只需要指定不同下一跳类型的网关ID，系统会自动匹配到下一跳地址。\n        :type GatewayId: str\n        :param RouteDescription: 路由策略描述。\n        :type RouteDescription: str\n        :param RoutePolicyId: 路由策略ID\n        :type RoutePolicyId: str\n        :param RoutePolicyType: 路由类型，目前我们支持的类型有：
USER：用户自定义路由；
NETD：网络探测路由，创建网络探测实例时，系统默认下发，不可编辑与删除；
CCN：云联网路由，系统默认下发，不可编辑与删除。
用户只能添加和编辑USER 类型的路由。\n        :type RoutePolicyType: str\n        :param Enabled: 是否启用\n        :type Enabled: bool\n        """
        self.DestinationCidrBlock = None
        self.GatewayType = None
        self.GatewayId = None
        self.RouteDescription = None
        self.RoutePolicyId = None
        self.RoutePolicyType = None
        self.Enabled = None


    def _deserialize(self, params):
        self.DestinationCidrBlock = params.get("DestinationCidrBlock")
        self.GatewayType = params.get("GatewayType")
        self.GatewayId = params.get("GatewayId")
        self.RouteDescription = params.get("RouteDescription")
        self.RoutePolicyId = params.get("RoutePolicyId")
        self.RoutePolicyType = params.get("RoutePolicyType")
        self.Enabled = params.get("Enabled")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RouteTable(AbstractModel):
    """路由表对象

    """

    def __init__(self):
        """
        :param VpcId: VPC实例ID。\n        :type VpcId: str\n        :param VpcName: VPC的名称\n        :type VpcName: str\n        :param VpcCidrBlock: VPC的CIDR\n        :type VpcCidrBlock: str\n        :param Zone: 可用区\n        :type Zone: str\n        :param RouteTableId: 路由表实例ID，例如：rtb-azd4dt1c。\n        :type RouteTableId: str\n        :param RouteTableName: 路由表名称。\n        :type RouteTableName: str\n        :param CreateTime: 创建时间。\n        :type CreateTime: str\n        """
        self.VpcId = None
        self.VpcName = None
        self.VpcCidrBlock = None
        self.Zone = None
        self.RouteTableId = None
        self.RouteTableName = None
        self.CreateTime = None


    def _deserialize(self, params):
        self.VpcId = params.get("VpcId")
        self.VpcName = params.get("VpcName")
        self.VpcCidrBlock = params.get("VpcCidrBlock")
        self.Zone = params.get("Zone")
        self.RouteTableId = params.get("RouteTableId")
        self.RouteTableName = params.get("RouteTableName")
        self.CreateTime = params.get("CreateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SecurityPolicyDatabase(AbstractModel):
    """SecurityPolicyDatabase策略

    """

    def __init__(self):
        """
        :param LocalCidrBlock: 本端网段\n        :type LocalCidrBlock: str\n        :param RemoteCidrBlock: 对端网段\n        :type RemoteCidrBlock: list of str\n        """
        self.LocalCidrBlock = None
        self.RemoteCidrBlock = None


    def _deserialize(self, params):
        self.LocalCidrBlock = params.get("LocalCidrBlock")
        self.RemoteCidrBlock = params.get("RemoteCidrBlock")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SubnetCreateInputInfo(AbstractModel):
    """创建子网时的子网类型

    """

    def __init__(self):
        """
        :param SubnetName: 子网名称，可任意命名，但不得超过60个字符\n        :type SubnetName: str\n        :param CidrBlock: 子网网段，子网网段必须在VPC网段内，相同VPC内子网网段不能重叠\n        :type CidrBlock: str\n        :param DistributedFlag: 是否开启子网分布式网关，默认传1，传0为关闭子网分布式网关。关闭分布式网关子网用于云服务器化子网，此子网中只能有一台物理机，同时此物理机及其上子机只能在此子网中\n        :type DistributedFlag: int\n        :param DhcpEnable: 是否开启dhcp relay ，关闭为0，开启为1。默认为0\n        :type DhcpEnable: int\n        :param DhcpServerIp: DHCP SERVER 的IP地址数组。IP地址为相同VPC的子网内分配的IP\n        :type DhcpServerIp: list of str\n        :param IpReserve: 预留的IP个数。从该子网的最大可分配IP倒序分配N个IP 用于DHCP 动态分配使用的地址段\n        :type IpReserve: int\n        :param VlanId: 子网绑定的vlanId。VlanId取值范围为2000-2999。创建物理机子网，VlanId默认为5; 创建docker子网或者虚拟子网，VlanId默认会分配2000--2999未使用的数值。\n        :type VlanId: int\n        :param Zone: 黑石子网的可用区\n        :type Zone: str\n        :param IsSmartNic: 是否25G子网，1为是，0为否。\n        :type IsSmartNic: int\n        """
        self.SubnetName = None
        self.CidrBlock = None
        self.DistributedFlag = None
        self.DhcpEnable = None
        self.DhcpServerIp = None
        self.IpReserve = None
        self.VlanId = None
        self.Zone = None
        self.IsSmartNic = None


    def _deserialize(self, params):
        self.SubnetName = params.get("SubnetName")
        self.CidrBlock = params.get("CidrBlock")
        self.DistributedFlag = params.get("DistributedFlag")
        self.DhcpEnable = params.get("DhcpEnable")
        self.DhcpServerIp = params.get("DhcpServerIp")
        self.IpReserve = params.get("IpReserve")
        self.VlanId = params.get("VlanId")
        self.Zone = params.get("Zone")
        self.IsSmartNic = params.get("IsSmartNic")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SubnetInfo(AbstractModel):
    """黑石子网的信息

    """

    def __init__(self):
        """
        :param VpcId: 私有网络的唯一ID。\n        :type VpcId: str\n        :param VpcName: VPC的名称。\n        :type VpcName: str\n        :param VpcCidrBlock: VPC的CIDR。\n        :type VpcCidrBlock: str\n        :param SubnetId: 私有网络的唯一ID\n        :type SubnetId: str\n        :param SubnetName: 子网名称。\n        :type SubnetName: str\n        :param CidrBlock: 子网CIDR。\n        :type CidrBlock: str\n        :param Type: 子网类型。0: 黑石物理机子网; 6: ccs子网; 7 Docker子网; 8: 虚拟机子网\n        :type Type: int\n        :param ZoneId: 子网可用区ID。\n        :type ZoneId: int\n        :param CpmNum: 子网物理机的个数\n        :type CpmNum: int\n        :param VlanId: 子网的VlanId。\n        :type VlanId: int\n        :param DistributedFlag: 是否开启分布式网关 ，关闭为0，开启为1。\n        :type DistributedFlag: int\n        :param DhcpEnable: 是否开启dhcp relay ，关闭为0，开启为1。默认为0。\n        :type DhcpEnable: int\n        :param DhcpServerIp: DHCP SERVER 的IP地址数组。IP地址为相同VPC的子网内分配的IP。\n        :type DhcpServerIp: list of str\n        :param IpReserve: 预留的IP个数。从该子网的最大可分配IP倒序分配N个IP 用于DHCP 动态分配使用的地址段。\n        :type IpReserve: int\n        :param AvailableIpNum: 子网中可用的IP个数\n        :type AvailableIpNum: int\n        :param TotalIpNum: 子网中总共的IP个数\n        :type TotalIpNum: int\n        :param SubnetCreateTime: 子网创建时间\n        :type SubnetCreateTime: str\n        :param IsSmartNic: 25G子网标识\n        :type IsSmartNic: int\n        :param Zone: 子网可用区。
注意：此字段可能返回 null，表示取不到有效值。\n        :type Zone: str\n        :param VpcZoneId: VPC所在可用区ID\n        :type VpcZoneId: int\n        :param VpcZone: VPC所在可用区\n        :type VpcZone: str\n        :param BroadcastFlag: 是否开启广播，关闭为0，开启为1。\n        :type BroadcastFlag: int\n        """
        self.VpcId = None
        self.VpcName = None
        self.VpcCidrBlock = None
        self.SubnetId = None
        self.SubnetName = None
        self.CidrBlock = None
        self.Type = None
        self.ZoneId = None
        self.CpmNum = None
        self.VlanId = None
        self.DistributedFlag = None
        self.DhcpEnable = None
        self.DhcpServerIp = None
        self.IpReserve = None
        self.AvailableIpNum = None
        self.TotalIpNum = None
        self.SubnetCreateTime = None
        self.IsSmartNic = None
        self.Zone = None
        self.VpcZoneId = None
        self.VpcZone = None
        self.BroadcastFlag = None


    def _deserialize(self, params):
        self.VpcId = params.get("VpcId")
        self.VpcName = params.get("VpcName")
        self.VpcCidrBlock = params.get("VpcCidrBlock")
        self.SubnetId = params.get("SubnetId")
        self.SubnetName = params.get("SubnetName")
        self.CidrBlock = params.get("CidrBlock")
        self.Type = params.get("Type")
        self.ZoneId = params.get("ZoneId")
        self.CpmNum = params.get("CpmNum")
        self.VlanId = params.get("VlanId")
        self.DistributedFlag = params.get("DistributedFlag")
        self.DhcpEnable = params.get("DhcpEnable")
        self.DhcpServerIp = params.get("DhcpServerIp")
        self.IpReserve = params.get("IpReserve")
        self.AvailableIpNum = params.get("AvailableIpNum")
        self.TotalIpNum = params.get("TotalIpNum")
        self.SubnetCreateTime = params.get("SubnetCreateTime")
        self.IsSmartNic = params.get("IsSmartNic")
        self.Zone = params.get("Zone")
        self.VpcZoneId = params.get("VpcZoneId")
        self.VpcZone = params.get("VpcZone")
        self.BroadcastFlag = params.get("BroadcastFlag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UnbindEipsFromNatGatewayRequest(AbstractModel):
    """UnbindEipsFromNatGateway请求参数结构体

    """

    def __init__(self):
        """
        :param NatId: NAT网关ID，例如：nat-kdm476mp\n        :type NatId: str\n        :param VpcId: 私有网络ID，例如：vpc-kd7d06of\n        :type VpcId: str\n        :param AssignedEips: 已分配的EIP列表\n        :type AssignedEips: list of str\n        """
        self.NatId = None
        self.VpcId = None
        self.AssignedEips = None


    def _deserialize(self, params):
        self.NatId = params.get("NatId")
        self.VpcId = params.get("VpcId")
        self.AssignedEips = params.get("AssignedEips")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UnbindEipsFromNatGatewayResponse(AbstractModel):
    """UnbindEipsFromNatGateway返回参数结构体

    """

    def __init__(self):
        """
        :param TaskId: 任务ID\n        :type TaskId: int\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.TaskId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.RequestId = params.get("RequestId")


class UnbindIpsFromNatGatewayRequest(AbstractModel):
    """UnbindIpsFromNatGateway请求参数结构体

    """

    def __init__(self):
        """
        :param NatId: NAT网关ID，例如：nat-kdm476mp\n        :type NatId: str\n        :param VpcId: 私有网络ID，例如：vpc-kd7d06of\n        :type VpcId: str\n        :param IpInfoSet: 部分IP信息；子网须以部分IP将加入NAT网关\n        :type IpInfoSet: list of IpInfo\n        """
        self.NatId = None
        self.VpcId = None
        self.IpInfoSet = None


    def _deserialize(self, params):
        self.NatId = params.get("NatId")
        self.VpcId = params.get("VpcId")
        if params.get("IpInfoSet") is not None:
            self.IpInfoSet = []
            for item in params.get("IpInfoSet"):
                obj = IpInfo()
                obj._deserialize(item)
                self.IpInfoSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UnbindIpsFromNatGatewayResponse(AbstractModel):
    """UnbindIpsFromNatGateway返回参数结构体

    """

    def __init__(self):
        """
        :param TaskId: 任务ID\n        :type TaskId: int\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.TaskId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.RequestId = params.get("RequestId")


class UnbindSubnetsFromNatGatewayRequest(AbstractModel):
    """UnbindSubnetsFromNatGateway请求参数结构体

    """

    def __init__(self):
        """
        :param NatId: NAT网关ID，例如：nat-kdm476mp\n        :type NatId: str\n        :param VpcId: 私有网络ID，例如：vpc-kd7d06of\n        :type VpcId: str\n        :param SubnetIds: 子网ID列表，子网不区分加入NAT网关的转发方式\n        :type SubnetIds: list of str\n        """
        self.NatId = None
        self.VpcId = None
        self.SubnetIds = None


    def _deserialize(self, params):
        self.NatId = params.get("NatId")
        self.VpcId = params.get("VpcId")
        self.SubnetIds = params.get("SubnetIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UnbindSubnetsFromNatGatewayResponse(AbstractModel):
    """UnbindSubnetsFromNatGateway返回参数结构体

    """

    def __init__(self):
        """
        :param TaskId: 任务ID\n        :type TaskId: int\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.TaskId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.RequestId = params.get("RequestId")


class UpgradeNatGatewayRequest(AbstractModel):
    """UpgradeNatGateway请求参数结构体

    """

    def __init__(self):
        """
        :param NatId: NAT网关ID，例如：nat-kdm476mp\n        :type NatId: str\n        :param VpcId: 私有网络ID，例如：vpc-kd7d06of\n        :type VpcId: str\n        :param MaxConcurrent: 并发连接数规格；取值为1000000、3000000、10000000，分别对应小型、中型、大型NAT网关\n        :type MaxConcurrent: int\n        """
        self.NatId = None
        self.VpcId = None
        self.MaxConcurrent = None


    def _deserialize(self, params):
        self.NatId = params.get("NatId")
        self.VpcId = params.get("VpcId")
        self.MaxConcurrent = params.get("MaxConcurrent")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class UpgradeNatGatewayResponse(AbstractModel):
    """UpgradeNatGateway返回参数结构体

    """

    def __init__(self):
        """
        :param TaskId: 任务ID\n        :type TaskId: int\n        :param RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。\n        :type RequestId: str\n        """
        self.TaskId = None
        self.RequestId = None


    def _deserialize(self, params):
        self.TaskId = params.get("TaskId")
        self.RequestId = params.get("RequestId")


class VpcInfo(AbstractModel):
    """VPC信息

    """

    def __init__(self):
        """
        :param VpcId: 私有网络的唯一ID。\n        :type VpcId: str\n        :param VpcName: VPC的名称。\n        :type VpcName: str\n        :param CidrBlock: VPC的CIDR。\n        :type CidrBlock: str\n        :param Zone: 可用区\n        :type Zone: str\n        :param State: VPC状态\n        :type State: str\n        :param CreateTime: 创建时间\n        :type CreateTime: str\n        :param IntVpcId: 整型私有网络ID。\n        :type IntVpcId: int\n        """
        self.VpcId = None
        self.VpcName = None
        self.CidrBlock = None
        self.Zone = None
        self.State = None
        self.CreateTime = None
        self.IntVpcId = None


    def _deserialize(self, params):
        self.VpcId = params.get("VpcId")
        self.VpcName = params.get("VpcName")
        self.CidrBlock = params.get("CidrBlock")
        self.Zone = params.get("Zone")
        self.State = params.get("State")
        self.CreateTime = params.get("CreateTime")
        self.IntVpcId = params.get("IntVpcId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class VpcPeerConnection(AbstractModel):
    """对等连接对象

    """

    def __init__(self):
        """
        :param VpcId: 本端VPC唯一ID\n        :type VpcId: str\n        :param PeerVpcId: 对端VPC唯一ID\n        :type PeerVpcId: str\n        :param AppId: 本端APPID\n        :type AppId: str\n        :param PeerAppId: 对端APPID\n        :type PeerAppId: str\n        :param VpcPeerConnectionId: 对等连接唯一ID\n        :type VpcPeerConnectionId: str\n        :param VpcPeerConnectionName: 对等连接名称\n        :type VpcPeerConnectionName: str\n        :param State: 对等连接状态。pending:申请中,available:运行中,expired:已过期,rejected:已拒绝,deleted:已删除\n        :type State: str\n        :param VpcZone: 本端VPC所属可用区
注意：此字段可能返回 null，表示取不到有效值。\n        :type VpcZone: str\n        :param PeerVpcZone: 对端VPC所属可用区
注意：此字段可能返回 null，表示取不到有效值。\n        :type PeerVpcZone: str\n        :param Uin: 本端Uin\n        :type Uin: int\n        :param PeerUin: 对端Uin\n        :type PeerUin: int\n        :param PeerType: 对等连接类型\n        :type PeerType: int\n        :param Bandwidth: 对等连接带宽\n        :type Bandwidth: int\n        :param Region: 本端VPC地域\n        :type Region: str\n        :param PeerRegion: 对端VPC地域\n        :type PeerRegion: str\n        :param DeleteFlag: 是否允许删除
注意：此字段可能返回 null，表示取不到有效值。\n        :type DeleteFlag: int\n        :param CreateTime: 创建时间\n        :type CreateTime: str\n        """
        self.VpcId = None
        self.PeerVpcId = None
        self.AppId = None
        self.PeerAppId = None
        self.VpcPeerConnectionId = None
        self.VpcPeerConnectionName = None
        self.State = None
        self.VpcZone = None
        self.PeerVpcZone = None
        self.Uin = None
        self.PeerUin = None
        self.PeerType = None
        self.Bandwidth = None
        self.Region = None
        self.PeerRegion = None
        self.DeleteFlag = None
        self.CreateTime = None


    def _deserialize(self, params):
        self.VpcId = params.get("VpcId")
        self.PeerVpcId = params.get("PeerVpcId")
        self.AppId = params.get("AppId")
        self.PeerAppId = params.get("PeerAppId")
        self.VpcPeerConnectionId = params.get("VpcPeerConnectionId")
        self.VpcPeerConnectionName = params.get("VpcPeerConnectionName")
        self.State = params.get("State")
        self.VpcZone = params.get("VpcZone")
        self.PeerVpcZone = params.get("PeerVpcZone")
        self.Uin = params.get("Uin")
        self.PeerUin = params.get("PeerUin")
        self.PeerType = params.get("PeerType")
        self.Bandwidth = params.get("Bandwidth")
        self.Region = params.get("Region")
        self.PeerRegion = params.get("PeerRegion")
        self.DeleteFlag = params.get("DeleteFlag")
        self.CreateTime = params.get("CreateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class VpcQuota(AbstractModel):
    """VPC限额信息

    """

    def __init__(self):
        """
        :param TypeId: 配额类型ID\n        :type TypeId: int\n        :param Quota: 配额\n        :type Quota: int\n        """
        self.TypeId = None
        self.Quota = None


    def _deserialize(self, params):
        self.TypeId = params.get("TypeId")
        self.Quota = params.get("Quota")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class VpcResource(AbstractModel):
    """VPC占用资源

    """

    def __init__(self):
        """
        :param VpcId: 私有网络ID\n        :type VpcId: str\n        :param VpcName: 私有网络名称\n        :type VpcName: str\n        :param CidrBlock: 私有网络的CIDR\n        :type CidrBlock: str\n        :param SubnetNum: 子网个数\n        :type SubnetNum: int\n        :param NatNum: NAT个数\n        :type NatNum: int\n        :param State: VPC状态\n        :type State: str\n        :param MonitorFlag: 是否开启监控\n        :type MonitorFlag: bool\n        :param CpmNum: 物理机个数\n        :type CpmNum: int\n        :param LeaveIpNum: 可用IP个数\n        :type LeaveIpNum: int\n        :param LbNum: 负载均衡个数\n        :type LbNum: int\n        :param TrafficMirrorNum: 流量镜像网关个数\n        :type TrafficMirrorNum: int\n        :param EipNum: 弹性IP个数\n        :type EipNum: int\n        :param PlgwNum: 专线网关个数\n        :type PlgwNum: int\n        :param PlvpNum: 专线通道个数\n        :type PlvpNum: int\n        :param SslVpnGwNum: ssl vpn网关个数\n        :type SslVpnGwNum: int\n        :param VpcPeerNum: 对等链接个数\n        :type VpcPeerNum: int\n        :param IpsecVpnGwNum: ipsec vpn网关个数\n        :type IpsecVpnGwNum: int\n        :param Zone: 可用区\n        :type Zone: str\n        :param CreateTime: 创建时间\n        :type CreateTime: str\n        :param IsOld: 是否老专区VPC\n        :type IsOld: bool\n        :param CcnServiceNum: 云联网服务个数
注意：此字段可能返回 null，表示取不到有效值。\n        :type CcnServiceNum: int\n        :param VpcPeerLimitToAllRegion: VPC允许创建的对等连接个数
注意：此字段可能返回 null，表示取不到有效值。\n        :type VpcPeerLimitToAllRegion: int\n        :param VpcPeerLimitToSameRegion: VPC允许创建的同地域的对等连接的个数
注意：此字段可能返回 null，表示取不到有效值。\n        :type VpcPeerLimitToSameRegion: int\n        :param IntVpcId: 整型私有网络ID\n        :type IntVpcId: int\n        """
        self.VpcId = None
        self.VpcName = None
        self.CidrBlock = None
        self.SubnetNum = None
        self.NatNum = None
        self.State = None
        self.MonitorFlag = None
        self.CpmNum = None
        self.LeaveIpNum = None
        self.LbNum = None
        self.TrafficMirrorNum = None
        self.EipNum = None
        self.PlgwNum = None
        self.PlvpNum = None
        self.SslVpnGwNum = None
        self.VpcPeerNum = None
        self.IpsecVpnGwNum = None
        self.Zone = None
        self.CreateTime = None
        self.IsOld = None
        self.CcnServiceNum = None
        self.VpcPeerLimitToAllRegion = None
        self.VpcPeerLimitToSameRegion = None
        self.IntVpcId = None


    def _deserialize(self, params):
        self.VpcId = params.get("VpcId")
        self.VpcName = params.get("VpcName")
        self.CidrBlock = params.get("CidrBlock")
        self.SubnetNum = params.get("SubnetNum")
        self.NatNum = params.get("NatNum")
        self.State = params.get("State")
        self.MonitorFlag = params.get("MonitorFlag")
        self.CpmNum = params.get("CpmNum")
        self.LeaveIpNum = params.get("LeaveIpNum")
        self.LbNum = params.get("LbNum")
        self.TrafficMirrorNum = params.get("TrafficMirrorNum")
        self.EipNum = params.get("EipNum")
        self.PlgwNum = params.get("PlgwNum")
        self.PlvpNum = params.get("PlvpNum")
        self.SslVpnGwNum = params.get("SslVpnGwNum")
        self.VpcPeerNum = params.get("VpcPeerNum")
        self.IpsecVpnGwNum = params.get("IpsecVpnGwNum")
        self.Zone = params.get("Zone")
        self.CreateTime = params.get("CreateTime")
        self.IsOld = params.get("IsOld")
        self.CcnServiceNum = params.get("CcnServiceNum")
        self.VpcPeerLimitToAllRegion = params.get("VpcPeerLimitToAllRegion")
        self.VpcPeerLimitToSameRegion = params.get("VpcPeerLimitToSameRegion")
        self.IntVpcId = params.get("IntVpcId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class VpcSubnetCreateInfo(AbstractModel):
    """创建VPC下默认子网

    """

    def __init__(self):
        """
        :param SubnetName: 子网名称\n        :type SubnetName: str\n        :param CidrBlock: 子网的CIDR\n        :type CidrBlock: str\n        :param Zone: 子网的可用区\n        :type Zone: str\n        """
        self.SubnetName = None
        self.CidrBlock = None
        self.Zone = None


    def _deserialize(self, params):
        self.SubnetName = params.get("SubnetName")
        self.CidrBlock = params.get("CidrBlock")
        self.Zone = params.get("Zone")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class VpcSubnetViewInfo(AbstractModel):
    """VPC视图子网信息

    """

    def __init__(self):
        """
        :param SubnetId: 子网ID\n        :type SubnetId: str\n        :param SubnetName: 子网名称\n        :type SubnetName: str\n        :param CidrBlock: 子网CIDR\n        :type CidrBlock: str\n        :param CpmNum: 子网下设备个数\n        :type CpmNum: int\n        :param LbNum: 内网负载均衡个数\n        :type LbNum: int\n        :param Zone: 子网所在可用区\n        :type Zone: str\n        """
        self.SubnetId = None
        self.SubnetName = None
        self.CidrBlock = None
        self.CpmNum = None
        self.LbNum = None
        self.Zone = None


    def _deserialize(self, params):
        self.SubnetId = params.get("SubnetId")
        self.SubnetName = params.get("SubnetName")
        self.CidrBlock = params.get("CidrBlock")
        self.CpmNum = params.get("CpmNum")
        self.LbNum = params.get("LbNum")
        self.Zone = params.get("Zone")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class VpcViewInfo(AbstractModel):
    """VPC视图信息

    """

    def __init__(self):
        """
        :param VpcId: 私有网络ID\n        :type VpcId: str\n        :param VpcName: 私有网络名称\n        :type VpcName: str\n        :param CidrBlock: 私有网络CIDR\n        :type CidrBlock: str\n        :param Zone: 私有网络所在可用区\n        :type Zone: str\n        :param LbNum: 外网负载均衡个数\n        :type LbNum: int\n        :param EipNum: 弹性公网IP个数\n        :type EipNum: int\n        :param NatNum: NAT网关个数\n        :type NatNum: int\n        :param SubnetSet: 子网列表\n        :type SubnetSet: list of VpcSubnetViewInfo\n        """
        self.VpcId = None
        self.VpcName = None
        self.CidrBlock = None
        self.Zone = None
        self.LbNum = None
        self.EipNum = None
        self.NatNum = None
        self.SubnetSet = None


    def _deserialize(self, params):
        self.VpcId = params.get("VpcId")
        self.VpcName = params.get("VpcName")
        self.CidrBlock = params.get("CidrBlock")
        self.Zone = params.get("Zone")
        self.LbNum = params.get("LbNum")
        self.EipNum = params.get("EipNum")
        self.NatNum = params.get("NatNum")
        if params.get("SubnetSet") is not None:
            self.SubnetSet = []
            for item in params.get("SubnetSet"):
                obj = VpcSubnetViewInfo()
                obj._deserialize(item)
                self.SubnetSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class VpnConnection(AbstractModel):
    """VPN通道对象。

    """

    def __init__(self):
        """
        :param VpnConnectionId: 通道实例ID。\n        :type VpnConnectionId: str\n        :param VpnConnectionName: 通道名称。\n        :type VpnConnectionName: str\n        :param VpcId: VPC实例ID。\n        :type VpcId: str\n        :param VpnGatewayId: VPN网关实例ID。\n        :type VpnGatewayId: str\n        :param CustomerGatewayId: 对端网关实例ID。\n        :type CustomerGatewayId: str\n        :param PreShareKey: 预共享密钥。\n        :type PreShareKey: str\n        :param VpnProto: 通道传输协议。\n        :type VpnProto: str\n        :param CreateTime: 创建时间。\n        :type CreateTime: str\n        :param State: 通道的生产状态\n        :type State: str\n        :param NetStatus: 通道连接状态\n        :type NetStatus: str\n        :param SecurityPolicyDatabaseSet: SPD。\n        :type SecurityPolicyDatabaseSet: list of SecurityPolicyDatabase\n        :param IKEOptionsSpecification: IKE选项。\n        :type IKEOptionsSpecification: :class:`tencentcloud.bmvpc.v20180625.models.IKEOptionsSpecification`\n        :param IPSECOptionsSpecification: IPSEC选项。\n        :type IPSECOptionsSpecification: :class:`tencentcloud.bmvpc.v20180625.models.IPSECOptionsSpecification`\n        :param Zone: 可用区\n        :type Zone: str\n        :param VpcCidrBlock: VPC网段\n        :type VpcCidrBlock: str\n        :param VpcName: VPC名称\n        :type VpcName: str\n        :param VpnGatewayName: VPN网关名称\n        :type VpnGatewayName: str\n        :param CustomerGatewayName: 对端网关名称\n        :type CustomerGatewayName: str\n        :param DestinationCidr: IPSEC VPN通道路由策略目的端地址
注意：此字段可能返回 null，表示取不到有效值。\n        :type DestinationCidr: list of str\n        :param SourceCidr: IPSEC VPN通道路由策略源端地址
注意：此字段可能返回 null，表示取不到有效值。\n        :type SourceCidr: list of str\n        """
        self.VpnConnectionId = None
        self.VpnConnectionName = None
        self.VpcId = None
        self.VpnGatewayId = None
        self.CustomerGatewayId = None
        self.PreShareKey = None
        self.VpnProto = None
        self.CreateTime = None
        self.State = None
        self.NetStatus = None
        self.SecurityPolicyDatabaseSet = None
        self.IKEOptionsSpecification = None
        self.IPSECOptionsSpecification = None
        self.Zone = None
        self.VpcCidrBlock = None
        self.VpcName = None
        self.VpnGatewayName = None
        self.CustomerGatewayName = None
        self.DestinationCidr = None
        self.SourceCidr = None


    def _deserialize(self, params):
        self.VpnConnectionId = params.get("VpnConnectionId")
        self.VpnConnectionName = params.get("VpnConnectionName")
        self.VpcId = params.get("VpcId")
        self.VpnGatewayId = params.get("VpnGatewayId")
        self.CustomerGatewayId = params.get("CustomerGatewayId")
        self.PreShareKey = params.get("PreShareKey")
        self.VpnProto = params.get("VpnProto")
        self.CreateTime = params.get("CreateTime")
        self.State = params.get("State")
        self.NetStatus = params.get("NetStatus")
        if params.get("SecurityPolicyDatabaseSet") is not None:
            self.SecurityPolicyDatabaseSet = []
            for item in params.get("SecurityPolicyDatabaseSet"):
                obj = SecurityPolicyDatabase()
                obj._deserialize(item)
                self.SecurityPolicyDatabaseSet.append(obj)
        if params.get("IKEOptionsSpecification") is not None:
            self.IKEOptionsSpecification = IKEOptionsSpecification()
            self.IKEOptionsSpecification._deserialize(params.get("IKEOptionsSpecification"))
        if params.get("IPSECOptionsSpecification") is not None:
            self.IPSECOptionsSpecification = IPSECOptionsSpecification()
            self.IPSECOptionsSpecification._deserialize(params.get("IPSECOptionsSpecification"))
        self.Zone = params.get("Zone")
        self.VpcCidrBlock = params.get("VpcCidrBlock")
        self.VpcName = params.get("VpcName")
        self.VpnGatewayName = params.get("VpnGatewayName")
        self.CustomerGatewayName = params.get("CustomerGatewayName")
        self.DestinationCidr = params.get("DestinationCidr")
        self.SourceCidr = params.get("SourceCidr")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class VpnGateway(AbstractModel):
    """VPN网关对象。

    """

    def __init__(self):
        """
        :param VpnGatewayId: 网关实例ID。\n        :type VpnGatewayId: str\n        :param VpcId: VPC实例ID。\n        :type VpcId: str\n        :param VpnGatewayName: 网关实例名称。\n        :type VpnGatewayName: str\n        :param VpcCidrBlock: VPC网段\n        :type VpcCidrBlock: str\n        :param VpcName: VPC名称\n        :type VpcName: str\n        :param InternetMaxBandwidthOut: 网关出带宽。\n        :type InternetMaxBandwidthOut: int\n        :param State: 网关实例状态\n        :type State: str\n        :param PublicIpAddress: 网关公网IP。\n        :type PublicIpAddress: str\n        :param CreateTime: 创建时间。\n        :type CreateTime: str\n        :param Zone: 可用区，如：ap-guangzhou\n        :type Zone: str\n        :param VpnConnNum: VPN网关的通道数\n        :type VpnConnNum: int\n        """
        self.VpnGatewayId = None
        self.VpcId = None
        self.VpnGatewayName = None
        self.VpcCidrBlock = None
        self.VpcName = None
        self.InternetMaxBandwidthOut = None
        self.State = None
        self.PublicIpAddress = None
        self.CreateTime = None
        self.Zone = None
        self.VpnConnNum = None


    def _deserialize(self, params):
        self.VpnGatewayId = params.get("VpnGatewayId")
        self.VpcId = params.get("VpcId")
        self.VpnGatewayName = params.get("VpnGatewayName")
        self.VpcCidrBlock = params.get("VpcCidrBlock")
        self.VpcName = params.get("VpcName")
        self.InternetMaxBandwidthOut = params.get("InternetMaxBandwidthOut")
        self.State = params.get("State")
        self.PublicIpAddress = params.get("PublicIpAddress")
        self.CreateTime = params.get("CreateTime")
        self.Zone = params.get("Zone")
        self.VpnConnNum = params.get("VpnConnNum")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            if name in memeber_set:
                memeber_set.remove(name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        