# -*- coding: utf8 -*-
# Copyright (c) 2017-2021 THL A29 Limited, a Tencent company. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import json

from tencentcloud.common.exception.tencent_cloud_sdk_exception import TencentCloudSDKException
from tencentcloud.common.abstract_client import AbstractClient
from tencentcloud.advisor.v20200721 import models


class AdvisorClient(AbstractClient):
    _apiVersion = '2020-07-21'
    _endpoint = 'advisor.tencentcloudapi.com'
    _service = 'advisor'


    def DescribeStrategies(self, request):
        """用于查询评估项的信息

        :param request: Request instance for DescribeStrategies.
        :type request: :class:`tencentcloud.advisor.v20200721.models.DescribeStrategiesRequest`
        :rtype: :class:`tencentcloud.advisor.v20200721.models.DescribeStrategiesResponse`

        """
        try:
            params = request._serialize()
            headers = request.headers
            body = self.call("DescribeStrategies", params, headers=headers)
            response = json.loads(body)
            model = models.DescribeStrategiesResponse()
            model._deserialize(response["Response"])
            return model
        except Exception as e:
            if isinstance(e, TencentCloudSDKException):
                raise
            else:
                raise TencentCloudSDKException(e.message, e.message)


    def DescribeTaskStrategyRisks(self, request):
        """查询评估项风险实例列表

        :param request: Request instance for DescribeTaskStrategyRisks.
        :type request: :class:`tencentcloud.advisor.v20200721.models.DescribeTaskStrategyRisksRequest`
        :rtype: :class:`tencentcloud.advisor.v20200721.models.DescribeTaskStrategyRisksResponse`

        """
        try:
            params = request._serialize()
            headers = request.headers
            body = self.call("DescribeTaskStrategyRisks", params, headers=headers)
            response = json.loads(body)
            model = models.DescribeTaskStrategyRisksResponse()
            model._deserialize(response["Response"])
            return model
        except Exception as e:
            if isinstance(e, TencentCloudSDKException):
                raise
            else:
                raise TencentCloudSDKException(e.message, e.message)