# -*- coding: utf8 -*-
# Copyright (c) 2017-2021 THL A29 Limited, a Tencent company. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class AccountStatistics(AbstractModel):
    """帐号统计数据。

    """

    def __init__(self):
        r"""
        :param _Username: 用户名。
        :type Username: str
        :param _MachineNum: 主机数量。
        :type MachineNum: int
        """
        self._Username = None
        self._MachineNum = None

    @property
    def Username(self):
        return self._Username

    @Username.setter
    def Username(self, Username):
        self._Username = Username

    @property
    def MachineNum(self):
        return self._MachineNum

    @MachineNum.setter
    def MachineNum(self, MachineNum):
        self._MachineNum = MachineNum


    def _deserialize(self, params):
        self._Username = params.get("Username")
        self._MachineNum = params.get("MachineNum")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AlarmInfo(AbstractModel):
    """节点关联的告警信息

    """

    def __init__(self):
        r"""
        :param _AlarmId: 该节点关联的告警，告警的table_name+id（t1:id1,t2:id2,...)
        :type AlarmId: str
        :param _Status: 告警事件表状态，当该节点为告警点时生效
        :type Status: int
        """
        self._AlarmId = None
        self._Status = None

    @property
    def AlarmId(self):
        return self._AlarmId

    @AlarmId.setter
    def AlarmId(self, AlarmId):
        self._AlarmId = AlarmId

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._AlarmId = params.get("AlarmId")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetAppBaseInfo(AbstractModel):
    """资源管理进程基本信息

    """

    def __init__(self):
        r"""
        :param _MachineIp: 主机内网IP
        :type MachineIp: str
        :param _MachineName: 主机名称
        :type MachineName: str
        :param _MachineWanIp: 主机外网IP
        :type MachineWanIp: str
        :param _Uuid: 主机Uuid
        :type Uuid: str
        :param _Quuid: 主机Quuid
        :type Quuid: str
        :param _ProjectId: 主机业务组ID
        :type ProjectId: int
        :param _Tag: 主机标签
注意：此字段可能返回 null，表示取不到有效值。
        :type Tag: list of MachineTag
        :param _Name: 应用名称
        :type Name: str
        :param _Type: 应用类型	
1: 运维
2 : 数据库
3 : 安全
4 : 可疑应用
5 : 系统架构
6 : 系统应用
7 : WEB服务
99: 其他
        :type Type: int
        :param _BinPath: 二进制路径
        :type BinPath: str
        :param _OsInfo: 操作系统信息
        :type OsInfo: str
        :param _ProcessCount: 关联进程数
        :type ProcessCount: int
        :param _Desc: 应用描述
        :type Desc: str
        :param _Version: 版本号
        :type Version: str
        :param _ConfigPath: 配置文件路径
        :type ConfigPath: str
        :param _FirstTime: 首次采集时间
        :type FirstTime: str
        :param _UpdateTime: 数据更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: str
        :param _IsNew: 是否新增[0:否|1:是]
注意：此字段可能返回 null，表示取不到有效值。
        :type IsNew: int
        :param _MachineExtraInfo: 附加信息
注意：此字段可能返回 null，表示取不到有效值。
        :type MachineExtraInfo: :class:`tencentcloud.cwp.v20180228.models.MachineExtraInfo`
        """
        self._MachineIp = None
        self._MachineName = None
        self._MachineWanIp = None
        self._Uuid = None
        self._Quuid = None
        self._ProjectId = None
        self._Tag = None
        self._Name = None
        self._Type = None
        self._BinPath = None
        self._OsInfo = None
        self._ProcessCount = None
        self._Desc = None
        self._Version = None
        self._ConfigPath = None
        self._FirstTime = None
        self._UpdateTime = None
        self._IsNew = None
        self._MachineExtraInfo = None

    @property
    def MachineIp(self):
        return self._MachineIp

    @MachineIp.setter
    def MachineIp(self, MachineIp):
        self._MachineIp = MachineIp

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def MachineWanIp(self):
        return self._MachineWanIp

    @MachineWanIp.setter
    def MachineWanIp(self, MachineWanIp):
        self._MachineWanIp = MachineWanIp

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Tag(self):
        return self._Tag

    @Tag.setter
    def Tag(self, Tag):
        self._Tag = Tag

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def BinPath(self):
        return self._BinPath

    @BinPath.setter
    def BinPath(self, BinPath):
        self._BinPath = BinPath

    @property
    def OsInfo(self):
        return self._OsInfo

    @OsInfo.setter
    def OsInfo(self, OsInfo):
        self._OsInfo = OsInfo

    @property
    def ProcessCount(self):
        return self._ProcessCount

    @ProcessCount.setter
    def ProcessCount(self, ProcessCount):
        self._ProcessCount = ProcessCount

    @property
    def Desc(self):
        return self._Desc

    @Desc.setter
    def Desc(self, Desc):
        self._Desc = Desc

    @property
    def Version(self):
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def ConfigPath(self):
        return self._ConfigPath

    @ConfigPath.setter
    def ConfigPath(self, ConfigPath):
        self._ConfigPath = ConfigPath

    @property
    def FirstTime(self):
        return self._FirstTime

    @FirstTime.setter
    def FirstTime(self, FirstTime):
        self._FirstTime = FirstTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def IsNew(self):
        return self._IsNew

    @IsNew.setter
    def IsNew(self, IsNew):
        self._IsNew = IsNew

    @property
    def MachineExtraInfo(self):
        return self._MachineExtraInfo

    @MachineExtraInfo.setter
    def MachineExtraInfo(self, MachineExtraInfo):
        self._MachineExtraInfo = MachineExtraInfo


    def _deserialize(self, params):
        self._MachineIp = params.get("MachineIp")
        self._MachineName = params.get("MachineName")
        self._MachineWanIp = params.get("MachineWanIp")
        self._Uuid = params.get("Uuid")
        self._Quuid = params.get("Quuid")
        self._ProjectId = params.get("ProjectId")
        if params.get("Tag") is not None:
            self._Tag = []
            for item in params.get("Tag"):
                obj = MachineTag()
                obj._deserialize(item)
                self._Tag.append(obj)
        self._Name = params.get("Name")
        self._Type = params.get("Type")
        self._BinPath = params.get("BinPath")
        self._OsInfo = params.get("OsInfo")
        self._ProcessCount = params.get("ProcessCount")
        self._Desc = params.get("Desc")
        self._Version = params.get("Version")
        self._ConfigPath = params.get("ConfigPath")
        self._FirstTime = params.get("FirstTime")
        self._UpdateTime = params.get("UpdateTime")
        self._IsNew = params.get("IsNew")
        if params.get("MachineExtraInfo") is not None:
            self._MachineExtraInfo = MachineExtraInfo()
            self._MachineExtraInfo._deserialize(params.get("MachineExtraInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetAppProcessInfo(AbstractModel):
    """软件应用关联进程信息

    """

    def __init__(self):
        r"""
        :param _Name: 名称
        :type Name: str
        :param _Status: 进程状态
        :type Status: str
        :param _Version: 进程版本
        :type Version: str
        :param _Path: 路径
        :type Path: str
        :param _User: 用户
        :type User: str
        :param _StartTime: 启动时间
        :type StartTime: str
        """
        self._Name = None
        self._Status = None
        self._Version = None
        self._Path = None
        self._User = None
        self._StartTime = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Version(self):
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def Path(self):
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def User(self):
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Status = params.get("Status")
        self._Version = params.get("Version")
        self._Path = params.get("Path")
        self._User = params.get("User")
        self._StartTime = params.get("StartTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetCoreModuleBaseInfo(AbstractModel):
    """资产管理内核模块列表

    """

    def __init__(self):
        r"""
        :param _Name: 名称
        :type Name: str
        :param _Desc: 描述
        :type Desc: str
        :param _Path: 路径
        :type Path: str
        :param _Version: 版本
        :type Version: str
        :param _MachineIp: 服务器IP
        :type MachineIp: str
        :param _MachineName: 服务器名称
        :type MachineName: str
        :param _OsInfo: 操作系统
        :type OsInfo: str
        :param _Size: 模块大小
        :type Size: int
        :param _ProcessCount: 依赖进程数
        :type ProcessCount: int
        :param _ModuleCount: 依赖模块数
        :type ModuleCount: int
        :param _Id: 模块ID
        :type Id: str
        :param _Quuid: 主机Quuid
        :type Quuid: str
        :param _Uuid: 主机uuid
        :type Uuid: str
        :param _UpdateTime: 数据更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: str
        :param _FirstTime: 首次采集时间
        :type FirstTime: str
        :param _IsNew: 是否新增[0:否|1:是]
        :type IsNew: int
        :param _MachineWanIp: 服务器外网IP
        :type MachineWanIp: str
        :param _MachineExtraInfo:  附加信息
注意：此字段可能返回 null，表示取不到有效值。
        :type MachineExtraInfo: :class:`tencentcloud.cwp.v20180228.models.MachineExtraInfo`
        """
        self._Name = None
        self._Desc = None
        self._Path = None
        self._Version = None
        self._MachineIp = None
        self._MachineName = None
        self._OsInfo = None
        self._Size = None
        self._ProcessCount = None
        self._ModuleCount = None
        self._Id = None
        self._Quuid = None
        self._Uuid = None
        self._UpdateTime = None
        self._FirstTime = None
        self._IsNew = None
        self._MachineWanIp = None
        self._MachineExtraInfo = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Desc(self):
        return self._Desc

    @Desc.setter
    def Desc(self, Desc):
        self._Desc = Desc

    @property
    def Path(self):
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def Version(self):
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def MachineIp(self):
        return self._MachineIp

    @MachineIp.setter
    def MachineIp(self, MachineIp):
        self._MachineIp = MachineIp

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def OsInfo(self):
        return self._OsInfo

    @OsInfo.setter
    def OsInfo(self, OsInfo):
        self._OsInfo = OsInfo

    @property
    def Size(self):
        return self._Size

    @Size.setter
    def Size(self, Size):
        self._Size = Size

    @property
    def ProcessCount(self):
        return self._ProcessCount

    @ProcessCount.setter
    def ProcessCount(self, ProcessCount):
        self._ProcessCount = ProcessCount

    @property
    def ModuleCount(self):
        return self._ModuleCount

    @ModuleCount.setter
    def ModuleCount(self, ModuleCount):
        self._ModuleCount = ModuleCount

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def FirstTime(self):
        return self._FirstTime

    @FirstTime.setter
    def FirstTime(self, FirstTime):
        self._FirstTime = FirstTime

    @property
    def IsNew(self):
        return self._IsNew

    @IsNew.setter
    def IsNew(self, IsNew):
        self._IsNew = IsNew

    @property
    def MachineWanIp(self):
        return self._MachineWanIp

    @MachineWanIp.setter
    def MachineWanIp(self, MachineWanIp):
        self._MachineWanIp = MachineWanIp

    @property
    def MachineExtraInfo(self):
        return self._MachineExtraInfo

    @MachineExtraInfo.setter
    def MachineExtraInfo(self, MachineExtraInfo):
        self._MachineExtraInfo = MachineExtraInfo


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Desc = params.get("Desc")
        self._Path = params.get("Path")
        self._Version = params.get("Version")
        self._MachineIp = params.get("MachineIp")
        self._MachineName = params.get("MachineName")
        self._OsInfo = params.get("OsInfo")
        self._Size = params.get("Size")
        self._ProcessCount = params.get("ProcessCount")
        self._ModuleCount = params.get("ModuleCount")
        self._Id = params.get("Id")
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._UpdateTime = params.get("UpdateTime")
        self._FirstTime = params.get("FirstTime")
        self._IsNew = params.get("IsNew")
        self._MachineWanIp = params.get("MachineWanIp")
        if params.get("MachineExtraInfo") is not None:
            self._MachineExtraInfo = MachineExtraInfo()
            self._MachineExtraInfo._deserialize(params.get("MachineExtraInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetCoreModuleDetail(AbstractModel):
    """资产管理内核模块详情

    """

    def __init__(self):
        r"""
        :param _Name: 名称
        :type Name: str
        :param _Desc: 描述
        :type Desc: str
        :param _Path: 路径
        :type Path: str
        :param _Version: 版本
        :type Version: str
        :param _Size: 大小
        :type Size: int
        :param _Processes: 依赖进程
        :type Processes: str
        :param _Modules: 被依赖模块
        :type Modules: str
        :param _Params: 参数信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Params: list of AssetCoreModuleParam
        :param _UpdateTime: 数据更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: str
        """
        self._Name = None
        self._Desc = None
        self._Path = None
        self._Version = None
        self._Size = None
        self._Processes = None
        self._Modules = None
        self._Params = None
        self._UpdateTime = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Desc(self):
        return self._Desc

    @Desc.setter
    def Desc(self, Desc):
        self._Desc = Desc

    @property
    def Path(self):
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def Version(self):
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def Size(self):
        return self._Size

    @Size.setter
    def Size(self, Size):
        self._Size = Size

    @property
    def Processes(self):
        return self._Processes

    @Processes.setter
    def Processes(self, Processes):
        self._Processes = Processes

    @property
    def Modules(self):
        return self._Modules

    @Modules.setter
    def Modules(self, Modules):
        self._Modules = Modules

    @property
    def Params(self):
        return self._Params

    @Params.setter
    def Params(self, Params):
        self._Params = Params

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Desc = params.get("Desc")
        self._Path = params.get("Path")
        self._Version = params.get("Version")
        self._Size = params.get("Size")
        self._Processes = params.get("Processes")
        self._Modules = params.get("Modules")
        if params.get("Params") is not None:
            self._Params = []
            for item in params.get("Params"):
                obj = AssetCoreModuleParam()
                obj._deserialize(item)
                self._Params.append(obj)
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetCoreModuleParam(AbstractModel):
    """资产管理内核模块参数

    """

    def __init__(self):
        r"""
        :param _Name: 名称
        :type Name: str
        :param _Data: 数据
        :type Data: str
        """
        self._Name = None
        self._Data = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Data = params.get("Data")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetDatabaseBaseInfo(AbstractModel):
    """资源管理数据库列表信息

    """

    def __init__(self):
        r"""
        :param _MachineIp: 主机内网IP
        :type MachineIp: str
        :param _MachineWanIp: 主机外网IP
        :type MachineWanIp: str
        :param _Quuid: 主机Quuid
        :type Quuid: str
        :param _Uuid: 主机Uuid
        :type Uuid: str
        :param _OsInfo: 操作系统信息
        :type OsInfo: str
        :param _ProjectId: 主机业务组ID
        :type ProjectId: int
        :param _Tag: 主机标签
注意：此字段可能返回 null，表示取不到有效值。
        :type Tag: list of MachineTag
        :param _Name: 数据库名
        :type Name: str
        :param _Version: 版本
        :type Version: str
        :param _Port: 监听端口
        :type Port: str
        :param _Proto: 协议
        :type Proto: str
        :param _User: 运行用户
        :type User: str
        :param _Ip: 绑定IP
        :type Ip: str
        :param _ConfigPath: 配置文件路径
        :type ConfigPath: str
        :param _LogPath: 日志文件路径
        :type LogPath: str
        :param _DataPath: 数据路径
        :type DataPath: str
        :param _Permission: 运行权限
        :type Permission: str
        :param _ErrorLogPath: 错误日志路径
        :type ErrorLogPath: str
        :param _PlugInPath: 插件路径
        :type PlugInPath: str
        :param _BinPath: 二进制路径
        :type BinPath: str
        :param _Param: 启动参数
        :type Param: str
        :param _Id: 数据库ID
        :type Id: str
        :param _UpdateTime: 数据更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: str
        :param _FirstTime: 首次采集时间
        :type FirstTime: str
        :param _IsNew: 是否新增[0:否|1:是]
        :type IsNew: int
        :param _MachineName: 主机名称
        :type MachineName: str
        :param _MachineExtraInfo:  附加信息
注意：此字段可能返回 null，表示取不到有效值。
        :type MachineExtraInfo: :class:`tencentcloud.cwp.v20180228.models.MachineExtraInfo`
        """
        self._MachineIp = None
        self._MachineWanIp = None
        self._Quuid = None
        self._Uuid = None
        self._OsInfo = None
        self._ProjectId = None
        self._Tag = None
        self._Name = None
        self._Version = None
        self._Port = None
        self._Proto = None
        self._User = None
        self._Ip = None
        self._ConfigPath = None
        self._LogPath = None
        self._DataPath = None
        self._Permission = None
        self._ErrorLogPath = None
        self._PlugInPath = None
        self._BinPath = None
        self._Param = None
        self._Id = None
        self._UpdateTime = None
        self._FirstTime = None
        self._IsNew = None
        self._MachineName = None
        self._MachineExtraInfo = None

    @property
    def MachineIp(self):
        return self._MachineIp

    @MachineIp.setter
    def MachineIp(self, MachineIp):
        self._MachineIp = MachineIp

    @property
    def MachineWanIp(self):
        return self._MachineWanIp

    @MachineWanIp.setter
    def MachineWanIp(self, MachineWanIp):
        self._MachineWanIp = MachineWanIp

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def OsInfo(self):
        return self._OsInfo

    @OsInfo.setter
    def OsInfo(self, OsInfo):
        self._OsInfo = OsInfo

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Tag(self):
        return self._Tag

    @Tag.setter
    def Tag(self, Tag):
        self._Tag = Tag

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Version(self):
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def Port(self):
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def Proto(self):
        return self._Proto

    @Proto.setter
    def Proto(self, Proto):
        self._Proto = Proto

    @property
    def User(self):
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def Ip(self):
        return self._Ip

    @Ip.setter
    def Ip(self, Ip):
        self._Ip = Ip

    @property
    def ConfigPath(self):
        return self._ConfigPath

    @ConfigPath.setter
    def ConfigPath(self, ConfigPath):
        self._ConfigPath = ConfigPath

    @property
    def LogPath(self):
        return self._LogPath

    @LogPath.setter
    def LogPath(self, LogPath):
        self._LogPath = LogPath

    @property
    def DataPath(self):
        return self._DataPath

    @DataPath.setter
    def DataPath(self, DataPath):
        self._DataPath = DataPath

    @property
    def Permission(self):
        return self._Permission

    @Permission.setter
    def Permission(self, Permission):
        self._Permission = Permission

    @property
    def ErrorLogPath(self):
        return self._ErrorLogPath

    @ErrorLogPath.setter
    def ErrorLogPath(self, ErrorLogPath):
        self._ErrorLogPath = ErrorLogPath

    @property
    def PlugInPath(self):
        return self._PlugInPath

    @PlugInPath.setter
    def PlugInPath(self, PlugInPath):
        self._PlugInPath = PlugInPath

    @property
    def BinPath(self):
        return self._BinPath

    @BinPath.setter
    def BinPath(self, BinPath):
        self._BinPath = BinPath

    @property
    def Param(self):
        return self._Param

    @Param.setter
    def Param(self, Param):
        self._Param = Param

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def FirstTime(self):
        return self._FirstTime

    @FirstTime.setter
    def FirstTime(self, FirstTime):
        self._FirstTime = FirstTime

    @property
    def IsNew(self):
        return self._IsNew

    @IsNew.setter
    def IsNew(self, IsNew):
        self._IsNew = IsNew

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def MachineExtraInfo(self):
        return self._MachineExtraInfo

    @MachineExtraInfo.setter
    def MachineExtraInfo(self, MachineExtraInfo):
        self._MachineExtraInfo = MachineExtraInfo


    def _deserialize(self, params):
        self._MachineIp = params.get("MachineIp")
        self._MachineWanIp = params.get("MachineWanIp")
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._OsInfo = params.get("OsInfo")
        self._ProjectId = params.get("ProjectId")
        if params.get("Tag") is not None:
            self._Tag = []
            for item in params.get("Tag"):
                obj = MachineTag()
                obj._deserialize(item)
                self._Tag.append(obj)
        self._Name = params.get("Name")
        self._Version = params.get("Version")
        self._Port = params.get("Port")
        self._Proto = params.get("Proto")
        self._User = params.get("User")
        self._Ip = params.get("Ip")
        self._ConfigPath = params.get("ConfigPath")
        self._LogPath = params.get("LogPath")
        self._DataPath = params.get("DataPath")
        self._Permission = params.get("Permission")
        self._ErrorLogPath = params.get("ErrorLogPath")
        self._PlugInPath = params.get("PlugInPath")
        self._BinPath = params.get("BinPath")
        self._Param = params.get("Param")
        self._Id = params.get("Id")
        self._UpdateTime = params.get("UpdateTime")
        self._FirstTime = params.get("FirstTime")
        self._IsNew = params.get("IsNew")
        self._MachineName = params.get("MachineName")
        if params.get("MachineExtraInfo") is not None:
            self._MachineExtraInfo = MachineExtraInfo()
            self._MachineExtraInfo._deserialize(params.get("MachineExtraInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetDatabaseDetail(AbstractModel):
    """资源管理数据库列表信息

    """

    def __init__(self):
        r"""
        :param _MachineIp: 主机内网IP
        :type MachineIp: str
        :param _MachineWanIp: 主机外网IP
        :type MachineWanIp: str
        :param _Quuid: 主机Quuid
        :type Quuid: str
        :param _Uuid: 主机Uuid
        :type Uuid: str
        :param _OsInfo: 操作系统信息
        :type OsInfo: str
        :param _Name: 数据库名
        :type Name: str
        :param _Version: 版本
        :type Version: str
        :param _Port: 监听端口
        :type Port: str
        :param _Proto: 协议
        :type Proto: str
        :param _User: 运行用户
        :type User: str
        :param _Ip: 绑定IP
        :type Ip: str
        :param _ConfigPath: 配置文件路径
        :type ConfigPath: str
        :param _LogPath: 日志文件路径
        :type LogPath: str
        :param _DataPath: 数据路径
        :type DataPath: str
        :param _Permission: 运行权限
        :type Permission: str
        :param _ErrorLogPath: 错误日志路径
        :type ErrorLogPath: str
        :param _PlugInPath: 插件路径
        :type PlugInPath: str
        :param _BinPath: 二进制路径
        :type BinPath: str
        :param _Param: 启动参数
        :type Param: str
        :param _UpdateTime: 数据更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: str
        """
        self._MachineIp = None
        self._MachineWanIp = None
        self._Quuid = None
        self._Uuid = None
        self._OsInfo = None
        self._Name = None
        self._Version = None
        self._Port = None
        self._Proto = None
        self._User = None
        self._Ip = None
        self._ConfigPath = None
        self._LogPath = None
        self._DataPath = None
        self._Permission = None
        self._ErrorLogPath = None
        self._PlugInPath = None
        self._BinPath = None
        self._Param = None
        self._UpdateTime = None

    @property
    def MachineIp(self):
        return self._MachineIp

    @MachineIp.setter
    def MachineIp(self, MachineIp):
        self._MachineIp = MachineIp

    @property
    def MachineWanIp(self):
        return self._MachineWanIp

    @MachineWanIp.setter
    def MachineWanIp(self, MachineWanIp):
        self._MachineWanIp = MachineWanIp

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def OsInfo(self):
        return self._OsInfo

    @OsInfo.setter
    def OsInfo(self, OsInfo):
        self._OsInfo = OsInfo

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Version(self):
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def Port(self):
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def Proto(self):
        return self._Proto

    @Proto.setter
    def Proto(self, Proto):
        self._Proto = Proto

    @property
    def User(self):
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def Ip(self):
        return self._Ip

    @Ip.setter
    def Ip(self, Ip):
        self._Ip = Ip

    @property
    def ConfigPath(self):
        return self._ConfigPath

    @ConfigPath.setter
    def ConfigPath(self, ConfigPath):
        self._ConfigPath = ConfigPath

    @property
    def LogPath(self):
        return self._LogPath

    @LogPath.setter
    def LogPath(self, LogPath):
        self._LogPath = LogPath

    @property
    def DataPath(self):
        return self._DataPath

    @DataPath.setter
    def DataPath(self, DataPath):
        self._DataPath = DataPath

    @property
    def Permission(self):
        return self._Permission

    @Permission.setter
    def Permission(self, Permission):
        self._Permission = Permission

    @property
    def ErrorLogPath(self):
        return self._ErrorLogPath

    @ErrorLogPath.setter
    def ErrorLogPath(self, ErrorLogPath):
        self._ErrorLogPath = ErrorLogPath

    @property
    def PlugInPath(self):
        return self._PlugInPath

    @PlugInPath.setter
    def PlugInPath(self, PlugInPath):
        self._PlugInPath = PlugInPath

    @property
    def BinPath(self):
        return self._BinPath

    @BinPath.setter
    def BinPath(self, BinPath):
        self._BinPath = BinPath

    @property
    def Param(self):
        return self._Param

    @Param.setter
    def Param(self, Param):
        self._Param = Param

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._MachineIp = params.get("MachineIp")
        self._MachineWanIp = params.get("MachineWanIp")
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._OsInfo = params.get("OsInfo")
        self._Name = params.get("Name")
        self._Version = params.get("Version")
        self._Port = params.get("Port")
        self._Proto = params.get("Proto")
        self._User = params.get("User")
        self._Ip = params.get("Ip")
        self._ConfigPath = params.get("ConfigPath")
        self._LogPath = params.get("LogPath")
        self._DataPath = params.get("DataPath")
        self._Permission = params.get("Permission")
        self._ErrorLogPath = params.get("ErrorLogPath")
        self._PlugInPath = params.get("PlugInPath")
        self._BinPath = params.get("BinPath")
        self._Param = params.get("Param")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetDiskPartitionInfo(AbstractModel):
    """资产管理磁盘分区信息

    """

    def __init__(self):
        r"""
        :param _Name: 分区名
        :type Name: str
        :param _Size: 分区大小：单位G
        :type Size: int
        :param _Percent: 分区使用率
        :type Percent: float
        :param _Type: 文件系统类型
        :type Type: str
        :param _Path: 挂载目录
        :type Path: str
        :param _Used: 已使用空间：单位G
        :type Used: int
        """
        self._Name = None
        self._Size = None
        self._Percent = None
        self._Type = None
        self._Path = None
        self._Used = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Size(self):
        return self._Size

    @Size.setter
    def Size(self, Size):
        self._Size = Size

    @property
    def Percent(self):
        return self._Percent

    @Percent.setter
    def Percent(self, Percent):
        self._Percent = Percent

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Path(self):
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def Used(self):
        return self._Used

    @Used.setter
    def Used(self, Used):
        self._Used = Used


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Size = params.get("Size")
        self._Percent = params.get("Percent")
        self._Type = params.get("Type")
        self._Path = params.get("Path")
        self._Used = params.get("Used")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetEnvBaseInfo(AbstractModel):
    """资产管理环境变量列表

    """

    def __init__(self):
        r"""
        :param _Name: 名称
        :type Name: str
        :param _Type: 类型：
0:用户变量
1:系统变量
        :type Type: int
        :param _User: 启动用户
        :type User: str
        :param _Value: 环境变量值
        :type Value: str
        :param _MachineIp: 服务器IP
        :type MachineIp: str
        :param _MachineName: 服务器名称
        :type MachineName: str
        :param _OsInfo: 操作系统
        :type OsInfo: str
        :param _Quuid: 主机Quuid
        :type Quuid: str
        :param _Uuid: 主机uuid
        :type Uuid: str
        :param _UpdateTime: 数据更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: str
        :param _FirstTime: 首次采集时间
        :type FirstTime: str
        :param _IsNew: 是否新增[0:否|1:是]
        :type IsNew: int
        :param _MachineWanIp: 服务器外网IP
        :type MachineWanIp: str
        :param _MachineExtraInfo:  附加信息

注意：此字段可能返回 null，表示取不到有效值。
        :type MachineExtraInfo: :class:`tencentcloud.cwp.v20180228.models.MachineExtraInfo`
        """
        self._Name = None
        self._Type = None
        self._User = None
        self._Value = None
        self._MachineIp = None
        self._MachineName = None
        self._OsInfo = None
        self._Quuid = None
        self._Uuid = None
        self._UpdateTime = None
        self._FirstTime = None
        self._IsNew = None
        self._MachineWanIp = None
        self._MachineExtraInfo = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def User(self):
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def Value(self):
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value

    @property
    def MachineIp(self):
        return self._MachineIp

    @MachineIp.setter
    def MachineIp(self, MachineIp):
        self._MachineIp = MachineIp

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def OsInfo(self):
        return self._OsInfo

    @OsInfo.setter
    def OsInfo(self, OsInfo):
        self._OsInfo = OsInfo

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def FirstTime(self):
        return self._FirstTime

    @FirstTime.setter
    def FirstTime(self, FirstTime):
        self._FirstTime = FirstTime

    @property
    def IsNew(self):
        return self._IsNew

    @IsNew.setter
    def IsNew(self, IsNew):
        self._IsNew = IsNew

    @property
    def MachineWanIp(self):
        return self._MachineWanIp

    @MachineWanIp.setter
    def MachineWanIp(self, MachineWanIp):
        self._MachineWanIp = MachineWanIp

    @property
    def MachineExtraInfo(self):
        return self._MachineExtraInfo

    @MachineExtraInfo.setter
    def MachineExtraInfo(self, MachineExtraInfo):
        self._MachineExtraInfo = MachineExtraInfo


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Type = params.get("Type")
        self._User = params.get("User")
        self._Value = params.get("Value")
        self._MachineIp = params.get("MachineIp")
        self._MachineName = params.get("MachineName")
        self._OsInfo = params.get("OsInfo")
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._UpdateTime = params.get("UpdateTime")
        self._FirstTime = params.get("FirstTime")
        self._IsNew = params.get("IsNew")
        self._MachineWanIp = params.get("MachineWanIp")
        if params.get("MachineExtraInfo") is not None:
            self._MachineExtraInfo = MachineExtraInfo()
            self._MachineExtraInfo._deserialize(params.get("MachineExtraInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetFilters(AbstractModel):
    """容器安全
    描述键值对过滤器，用于条件过滤查询。例如过滤ID、名称、状态等
    若存在多个Filter时，Filter间的关系为逻辑与（AND）关系。
    若同一个Filter存在多个Values，同一Filter下Values间的关系为逻辑或（OR）关系。

    """

    def __init__(self):
        r"""
        :param _Name: 过滤键的名称。
        :type Name: str
        :param _Values: 一个或者多个过滤值。
        :type Values: list of str
        :param _ExactMatch: 是否模糊查询
        :type ExactMatch: bool
        """
        self._Name = None
        self._Values = None
        self._ExactMatch = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Values(self):
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values

    @property
    def ExactMatch(self):
        return self._ExactMatch

    @ExactMatch.setter
    def ExactMatch(self, ExactMatch):
        self._ExactMatch = ExactMatch


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Values = params.get("Values")
        self._ExactMatch = params.get("ExactMatch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetInitServiceBaseInfo(AbstractModel):
    """资产管理启动服务列表

    """

    def __init__(self):
        r"""
        :param _Name: 名称
        :type Name: str
        :param _Type: 类型：
1:编码器
2:IE插件
3:网络提供者
4:镜像劫持
5:LSA提供者
6:KnownDLLs
7:启动执行
8:WMI
9:计划任务
10:Winsock提供者
11:打印监控器
12:资源管理器
13:驱动服务
14:登录
        :type Type: int
        :param _Status: 默认启用状态：0未启用，1启用
        :type Status: int
        :param _User: 启动用户
        :type User: str
        :param _Path: 路径
        :type Path: str
        :param _MachineIp: 服务器IP
        :type MachineIp: str
        :param _MachineName: 服务器名称
        :type MachineName: str
        :param _OsInfo: 操作系统
        :type OsInfo: str
        :param _Quuid: 主机Quuid
        :type Quuid: str
        :param _Uuid: 主机uuid
        :type Uuid: str
        :param _UpdateTime: 数据更新时间
        :type UpdateTime: str
        :param _FirstTime: 首次采集时间
        :type FirstTime: str
        :param _IsNew: 是否新增[0:否|1:是]
        :type IsNew: int
        :param _MachineWanIp: 服务器外网IP
        :type MachineWanIp: str
        :param _MachineExtraInfo:  附加信息

注意：此字段可能返回 null，表示取不到有效值。
        :type MachineExtraInfo: :class:`tencentcloud.cwp.v20180228.models.MachineExtraInfo`
        """
        self._Name = None
        self._Type = None
        self._Status = None
        self._User = None
        self._Path = None
        self._MachineIp = None
        self._MachineName = None
        self._OsInfo = None
        self._Quuid = None
        self._Uuid = None
        self._UpdateTime = None
        self._FirstTime = None
        self._IsNew = None
        self._MachineWanIp = None
        self._MachineExtraInfo = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def User(self):
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def Path(self):
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def MachineIp(self):
        return self._MachineIp

    @MachineIp.setter
    def MachineIp(self, MachineIp):
        self._MachineIp = MachineIp

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def OsInfo(self):
        return self._OsInfo

    @OsInfo.setter
    def OsInfo(self, OsInfo):
        self._OsInfo = OsInfo

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def FirstTime(self):
        return self._FirstTime

    @FirstTime.setter
    def FirstTime(self, FirstTime):
        self._FirstTime = FirstTime

    @property
    def IsNew(self):
        return self._IsNew

    @IsNew.setter
    def IsNew(self, IsNew):
        self._IsNew = IsNew

    @property
    def MachineWanIp(self):
        return self._MachineWanIp

    @MachineWanIp.setter
    def MachineWanIp(self, MachineWanIp):
        self._MachineWanIp = MachineWanIp

    @property
    def MachineExtraInfo(self):
        return self._MachineExtraInfo

    @MachineExtraInfo.setter
    def MachineExtraInfo(self, MachineExtraInfo):
        self._MachineExtraInfo = MachineExtraInfo


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Type = params.get("Type")
        self._Status = params.get("Status")
        self._User = params.get("User")
        self._Path = params.get("Path")
        self._MachineIp = params.get("MachineIp")
        self._MachineName = params.get("MachineName")
        self._OsInfo = params.get("OsInfo")
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._UpdateTime = params.get("UpdateTime")
        self._FirstTime = params.get("FirstTime")
        self._IsNew = params.get("IsNew")
        self._MachineWanIp = params.get("MachineWanIp")
        if params.get("MachineExtraInfo") is not None:
            self._MachineExtraInfo = MachineExtraInfo()
            self._MachineExtraInfo._deserialize(params.get("MachineExtraInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetJarBaseInfo(AbstractModel):
    """资产管理jar包列表

    """

    def __init__(self):
        r"""
        :param _Name: 名称
        :type Name: str
        :param _Type: 类型：1应用程序，2系统类库，3Web服务自带库，8:其他，
        :type Type: int
        :param _Status: 是否可执行：0未知，1是，2否
        :type Status: int
        :param _Version: 版本
        :type Version: str
        :param _Path: 路径
        :type Path: str
        :param _MachineIp: 服务器IP
        :type MachineIp: str
        :param _MachineName: 服务器名称
        :type MachineName: str
        :param _OsInfo: 操作系统
        :type OsInfo: str
        :param _Id: Jar包ID
        :type Id: str
        :param _Md5: Jar包Md5
        :type Md5: str
        :param _Quuid: 主机Quuid
        :type Quuid: str
        :param _Uuid: 主机uuid
        :type Uuid: str
        :param _UpdateTime: 数据更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: str
        :param _FirstTime: 首次采集时间
        :type FirstTime: str
        :param _IsNew: 是否新增[0:否|1:是]
        :type IsNew: int
        :param _MachineWanIp: 服务器外网IP
        :type MachineWanIp: str
        :param _MachineExtraInfo:  附加信息

注意：此字段可能返回 null，表示取不到有效值。
        :type MachineExtraInfo: :class:`tencentcloud.cwp.v20180228.models.MachineExtraInfo`
        """
        self._Name = None
        self._Type = None
        self._Status = None
        self._Version = None
        self._Path = None
        self._MachineIp = None
        self._MachineName = None
        self._OsInfo = None
        self._Id = None
        self._Md5 = None
        self._Quuid = None
        self._Uuid = None
        self._UpdateTime = None
        self._FirstTime = None
        self._IsNew = None
        self._MachineWanIp = None
        self._MachineExtraInfo = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Version(self):
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def Path(self):
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def MachineIp(self):
        return self._MachineIp

    @MachineIp.setter
    def MachineIp(self, MachineIp):
        self._MachineIp = MachineIp

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def OsInfo(self):
        return self._OsInfo

    @OsInfo.setter
    def OsInfo(self, OsInfo):
        self._OsInfo = OsInfo

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Md5(self):
        return self._Md5

    @Md5.setter
    def Md5(self, Md5):
        self._Md5 = Md5

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def FirstTime(self):
        return self._FirstTime

    @FirstTime.setter
    def FirstTime(self, FirstTime):
        self._FirstTime = FirstTime

    @property
    def IsNew(self):
        return self._IsNew

    @IsNew.setter
    def IsNew(self, IsNew):
        self._IsNew = IsNew

    @property
    def MachineWanIp(self):
        return self._MachineWanIp

    @MachineWanIp.setter
    def MachineWanIp(self, MachineWanIp):
        self._MachineWanIp = MachineWanIp

    @property
    def MachineExtraInfo(self):
        return self._MachineExtraInfo

    @MachineExtraInfo.setter
    def MachineExtraInfo(self, MachineExtraInfo):
        self._MachineExtraInfo = MachineExtraInfo


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Type = params.get("Type")
        self._Status = params.get("Status")
        self._Version = params.get("Version")
        self._Path = params.get("Path")
        self._MachineIp = params.get("MachineIp")
        self._MachineName = params.get("MachineName")
        self._OsInfo = params.get("OsInfo")
        self._Id = params.get("Id")
        self._Md5 = params.get("Md5")
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._UpdateTime = params.get("UpdateTime")
        self._FirstTime = params.get("FirstTime")
        self._IsNew = params.get("IsNew")
        self._MachineWanIp = params.get("MachineWanIp")
        if params.get("MachineExtraInfo") is not None:
            self._MachineExtraInfo = MachineExtraInfo()
            self._MachineExtraInfo._deserialize(params.get("MachineExtraInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetJarDetail(AbstractModel):
    """资产管理jar包详情

    """

    def __init__(self):
        r"""
        :param _Name: 名称
        :type Name: str
        :param _Type: 类型：1应用程序，2系统类库，3Web服务自带库，8:其他，
        :type Type: int
        :param _Status: 是否可执行：0未知，1是，2否
        :type Status: int
        :param _Version: 版本
        :type Version: str
        :param _Path: 路径
        :type Path: str
        :param _MachineIp: 服务器IP
        :type MachineIp: str
        :param _MachineName: 服务器名称
        :type MachineName: str
        :param _OsInfo: 操作系统
        :type OsInfo: str
        :param _Process: 引用进程列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Process: list of AssetAppProcessInfo
        :param _Md5: Jar包Md5
注意：此字段可能返回 null，表示取不到有效值。
        :type Md5: str
        :param _UpdateTime: 数据更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: str
        """
        self._Name = None
        self._Type = None
        self._Status = None
        self._Version = None
        self._Path = None
        self._MachineIp = None
        self._MachineName = None
        self._OsInfo = None
        self._Process = None
        self._Md5 = None
        self._UpdateTime = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Version(self):
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def Path(self):
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def MachineIp(self):
        return self._MachineIp

    @MachineIp.setter
    def MachineIp(self, MachineIp):
        self._MachineIp = MachineIp

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def OsInfo(self):
        return self._OsInfo

    @OsInfo.setter
    def OsInfo(self, OsInfo):
        self._OsInfo = OsInfo

    @property
    def Process(self):
        return self._Process

    @Process.setter
    def Process(self, Process):
        self._Process = Process

    @property
    def Md5(self):
        return self._Md5

    @Md5.setter
    def Md5(self, Md5):
        self._Md5 = Md5

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Type = params.get("Type")
        self._Status = params.get("Status")
        self._Version = params.get("Version")
        self._Path = params.get("Path")
        self._MachineIp = params.get("MachineIp")
        self._MachineName = params.get("MachineName")
        self._OsInfo = params.get("OsInfo")
        if params.get("Process") is not None:
            self._Process = []
            for item in params.get("Process"):
                obj = AssetAppProcessInfo()
                obj._deserialize(item)
                self._Process.append(obj)
        self._Md5 = params.get("Md5")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetKeyVal(AbstractModel):
    """key-val类型的通用数据结构

    """

    def __init__(self):
        r"""
        :param _Key: 标签
        :type Key: str
        :param _Value: 数量
        :type Value: int
        :param _Desc: 描述信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Desc: str
        :param _NewCount: 今日新增数量
注意：此字段可能返回 null，表示取不到有效值。
        :type NewCount: int
        """
        self._Key = None
        self._Value = None
        self._Desc = None
        self._NewCount = None

    @property
    def Key(self):
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key

    @property
    def Value(self):
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value

    @property
    def Desc(self):
        return self._Desc

    @Desc.setter
    def Desc(self, Desc):
        self._Desc = Desc

    @property
    def NewCount(self):
        return self._NewCount

    @NewCount.setter
    def NewCount(self, NewCount):
        self._NewCount = NewCount


    def _deserialize(self, params):
        self._Key = params.get("Key")
        self._Value = params.get("Value")
        self._Desc = params.get("Desc")
        self._NewCount = params.get("NewCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetMachineBaseInfo(AbstractModel):
    """资产指纹中服务器列表的基本信息

    """

    def __init__(self):
        r"""
        :param _Quuid: 服务器Quuid
        :type Quuid: str
        :param _Uuid: 服务器uuid
        :type Uuid: str
        :param _MachineIp: 服务器内网IP
        :type MachineIp: str
        :param _MachineName: 服务器名称
        :type MachineName: str
        :param _OsInfo: 操作系统名称
        :type OsInfo: str
        :param _Cpu: CPU信息
        :type Cpu: str
        :param _MemSize: 内存容量：单位G
        :type MemSize: int
        :param _MemLoad: 内存使用率百分比
        :type MemLoad: str
        :param _DiskSize: 硬盘容量：单位G
        :type DiskSize: int
        :param _DiskLoad: 硬盘使用率百分比
        :type DiskLoad: str
        :param _PartitionCount: 分区数
        :type PartitionCount: int
        :param _MachineWanIp: 主机外网IP
        :type MachineWanIp: str
        :param _ProjectId: 业务组ID
        :type ProjectId: int
        :param _CpuSize: Cpu数量
        :type CpuSize: int
        :param _CpuLoad: Cpu使用率百分比
        :type CpuLoad: str
        :param _Tag: 标签
注意：此字段可能返回 null，表示取不到有效值。
        :type Tag: list of MachineTag
        :param _UpdateTime: 数据更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: str
        :param _IsNew: 是否新增[0:否|1:是]
        :type IsNew: int
        :param _FirstTime: 首次采集时间
        :type FirstTime: str
        :param _MachineExtraInfo: 附加信息
注意：此字段可能返回 null，表示取不到有效值。
        :type MachineExtraInfo: :class:`tencentcloud.cwp.v20180228.models.MachineExtraInfo`
        """
        self._Quuid = None
        self._Uuid = None
        self._MachineIp = None
        self._MachineName = None
        self._OsInfo = None
        self._Cpu = None
        self._MemSize = None
        self._MemLoad = None
        self._DiskSize = None
        self._DiskLoad = None
        self._PartitionCount = None
        self._MachineWanIp = None
        self._ProjectId = None
        self._CpuSize = None
        self._CpuLoad = None
        self._Tag = None
        self._UpdateTime = None
        self._IsNew = None
        self._FirstTime = None
        self._MachineExtraInfo = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def MachineIp(self):
        return self._MachineIp

    @MachineIp.setter
    def MachineIp(self, MachineIp):
        self._MachineIp = MachineIp

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def OsInfo(self):
        return self._OsInfo

    @OsInfo.setter
    def OsInfo(self, OsInfo):
        self._OsInfo = OsInfo

    @property
    def Cpu(self):
        return self._Cpu

    @Cpu.setter
    def Cpu(self, Cpu):
        self._Cpu = Cpu

    @property
    def MemSize(self):
        return self._MemSize

    @MemSize.setter
    def MemSize(self, MemSize):
        self._MemSize = MemSize

    @property
    def MemLoad(self):
        return self._MemLoad

    @MemLoad.setter
    def MemLoad(self, MemLoad):
        self._MemLoad = MemLoad

    @property
    def DiskSize(self):
        return self._DiskSize

    @DiskSize.setter
    def DiskSize(self, DiskSize):
        self._DiskSize = DiskSize

    @property
    def DiskLoad(self):
        return self._DiskLoad

    @DiskLoad.setter
    def DiskLoad(self, DiskLoad):
        self._DiskLoad = DiskLoad

    @property
    def PartitionCount(self):
        return self._PartitionCount

    @PartitionCount.setter
    def PartitionCount(self, PartitionCount):
        self._PartitionCount = PartitionCount

    @property
    def MachineWanIp(self):
        return self._MachineWanIp

    @MachineWanIp.setter
    def MachineWanIp(self, MachineWanIp):
        self._MachineWanIp = MachineWanIp

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def CpuSize(self):
        return self._CpuSize

    @CpuSize.setter
    def CpuSize(self, CpuSize):
        self._CpuSize = CpuSize

    @property
    def CpuLoad(self):
        return self._CpuLoad

    @CpuLoad.setter
    def CpuLoad(self, CpuLoad):
        self._CpuLoad = CpuLoad

    @property
    def Tag(self):
        return self._Tag

    @Tag.setter
    def Tag(self, Tag):
        self._Tag = Tag

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def IsNew(self):
        return self._IsNew

    @IsNew.setter
    def IsNew(self, IsNew):
        self._IsNew = IsNew

    @property
    def FirstTime(self):
        return self._FirstTime

    @FirstTime.setter
    def FirstTime(self, FirstTime):
        self._FirstTime = FirstTime

    @property
    def MachineExtraInfo(self):
        return self._MachineExtraInfo

    @MachineExtraInfo.setter
    def MachineExtraInfo(self, MachineExtraInfo):
        self._MachineExtraInfo = MachineExtraInfo


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._MachineIp = params.get("MachineIp")
        self._MachineName = params.get("MachineName")
        self._OsInfo = params.get("OsInfo")
        self._Cpu = params.get("Cpu")
        self._MemSize = params.get("MemSize")
        self._MemLoad = params.get("MemLoad")
        self._DiskSize = params.get("DiskSize")
        self._DiskLoad = params.get("DiskLoad")
        self._PartitionCount = params.get("PartitionCount")
        self._MachineWanIp = params.get("MachineWanIp")
        self._ProjectId = params.get("ProjectId")
        self._CpuSize = params.get("CpuSize")
        self._CpuLoad = params.get("CpuLoad")
        if params.get("Tag") is not None:
            self._Tag = []
            for item in params.get("Tag"):
                obj = MachineTag()
                obj._deserialize(item)
                self._Tag.append(obj)
        self._UpdateTime = params.get("UpdateTime")
        self._IsNew = params.get("IsNew")
        self._FirstTime = params.get("FirstTime")
        if params.get("MachineExtraInfo") is not None:
            self._MachineExtraInfo = MachineExtraInfo()
            self._MachineExtraInfo._deserialize(params.get("MachineExtraInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetMachineDetail(AbstractModel):
    """资产指纹中服务器列表的基本信息

    """

    def __init__(self):
        r"""
        :param _Quuid: 服务器Quuid
        :type Quuid: str
        :param _Uuid: 服务器uuid
        :type Uuid: str
        :param _MachineIp: 服务器内网IP
        :type MachineIp: str
        :param _MachineName: 服务器名称
        :type MachineName: str
        :param _OsInfo: 操作系统名称
        :type OsInfo: str
        :param _Cpu: CPU信息
        :type Cpu: str
        :param _MemSize: 内存容量：单位G
        :type MemSize: int
        :param _MemLoad: 内存使用率百分比
        :type MemLoad: str
        :param _DiskSize: 硬盘容量：单位G
        :type DiskSize: int
        :param _DiskLoad: 硬盘使用率百分比
        :type DiskLoad: str
        :param _PartitionCount: 分区数
        :type PartitionCount: int
        :param _MachineWanIp: 主机外网IP
        :type MachineWanIp: str
        :param _CpuSize: Cpu数量
        :type CpuSize: int
        :param _CpuLoad: Cpu使用率百分比
        :type CpuLoad: str
        :param _ProtectLevel: 防护级别：0基础版，1专业版，2旗舰版，3普惠版
        :type ProtectLevel: int
        :param _RiskStatus: 风险状态：UNKNOW-未知，RISK-风险，SAFT-安全
        :type RiskStatus: str
        :param _ProtectDays: 已防护天数
        :type ProtectDays: int
        :param _BuyTime: 专业版开通时间
        :type BuyTime: str
        :param _EndTime: 专业版到期时间
        :type EndTime: str
        :param _CoreVersion: 内核版本
        :type CoreVersion: str
        :param _OsType: linux/windows
        :type OsType: str
        :param _AgentVersion: agent版本
        :type AgentVersion: str
        :param _InstallTime: 安装时间
        :type InstallTime: str
        :param _BootTime: 系统启动时间
        :type BootTime: str
        :param _LastLiveTime: 最后上线时间
        :type LastLiveTime: str
        :param _Producer: 生产商
        :type Producer: str
        :param _SerialNumber: 序列号
        :type SerialNumber: str
        :param _NetCards: 网卡
        :type NetCards: list of AssetNetworkCardInfo
        :param _Disks: 分区
        :type Disks: list of AssetDiskPartitionInfo
        :param _Status: 0在线，1已离线
        :type Status: int
        :param _ProjectId: 业务组ID
        :type ProjectId: int
        :param _DeviceVersion: 设备型号
        :type DeviceVersion: str
        :param _OfflineTime: 离线时间
注意：此字段可能返回 null，表示取不到有效值。
        :type OfflineTime: str
        :param _InstanceId: 主机ID
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceId: str
        :param _UpdateTime: 数据更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: str
        :param _MachineExtraInfo: 主机二外信息
注意：此字段可能返回 null，表示取不到有效值。
        :type MachineExtraInfo: :class:`tencentcloud.cwp.v20180228.models.MachineExtraInfo`
        """
        self._Quuid = None
        self._Uuid = None
        self._MachineIp = None
        self._MachineName = None
        self._OsInfo = None
        self._Cpu = None
        self._MemSize = None
        self._MemLoad = None
        self._DiskSize = None
        self._DiskLoad = None
        self._PartitionCount = None
        self._MachineWanIp = None
        self._CpuSize = None
        self._CpuLoad = None
        self._ProtectLevel = None
        self._RiskStatus = None
        self._ProtectDays = None
        self._BuyTime = None
        self._EndTime = None
        self._CoreVersion = None
        self._OsType = None
        self._AgentVersion = None
        self._InstallTime = None
        self._BootTime = None
        self._LastLiveTime = None
        self._Producer = None
        self._SerialNumber = None
        self._NetCards = None
        self._Disks = None
        self._Status = None
        self._ProjectId = None
        self._DeviceVersion = None
        self._OfflineTime = None
        self._InstanceId = None
        self._UpdateTime = None
        self._MachineExtraInfo = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def MachineIp(self):
        return self._MachineIp

    @MachineIp.setter
    def MachineIp(self, MachineIp):
        self._MachineIp = MachineIp

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def OsInfo(self):
        return self._OsInfo

    @OsInfo.setter
    def OsInfo(self, OsInfo):
        self._OsInfo = OsInfo

    @property
    def Cpu(self):
        return self._Cpu

    @Cpu.setter
    def Cpu(self, Cpu):
        self._Cpu = Cpu

    @property
    def MemSize(self):
        return self._MemSize

    @MemSize.setter
    def MemSize(self, MemSize):
        self._MemSize = MemSize

    @property
    def MemLoad(self):
        return self._MemLoad

    @MemLoad.setter
    def MemLoad(self, MemLoad):
        self._MemLoad = MemLoad

    @property
    def DiskSize(self):
        return self._DiskSize

    @DiskSize.setter
    def DiskSize(self, DiskSize):
        self._DiskSize = DiskSize

    @property
    def DiskLoad(self):
        return self._DiskLoad

    @DiskLoad.setter
    def DiskLoad(self, DiskLoad):
        self._DiskLoad = DiskLoad

    @property
    def PartitionCount(self):
        return self._PartitionCount

    @PartitionCount.setter
    def PartitionCount(self, PartitionCount):
        self._PartitionCount = PartitionCount

    @property
    def MachineWanIp(self):
        return self._MachineWanIp

    @MachineWanIp.setter
    def MachineWanIp(self, MachineWanIp):
        self._MachineWanIp = MachineWanIp

    @property
    def CpuSize(self):
        return self._CpuSize

    @CpuSize.setter
    def CpuSize(self, CpuSize):
        self._CpuSize = CpuSize

    @property
    def CpuLoad(self):
        return self._CpuLoad

    @CpuLoad.setter
    def CpuLoad(self, CpuLoad):
        self._CpuLoad = CpuLoad

    @property
    def ProtectLevel(self):
        return self._ProtectLevel

    @ProtectLevel.setter
    def ProtectLevel(self, ProtectLevel):
        self._ProtectLevel = ProtectLevel

    @property
    def RiskStatus(self):
        return self._RiskStatus

    @RiskStatus.setter
    def RiskStatus(self, RiskStatus):
        self._RiskStatus = RiskStatus

    @property
    def ProtectDays(self):
        return self._ProtectDays

    @ProtectDays.setter
    def ProtectDays(self, ProtectDays):
        self._ProtectDays = ProtectDays

    @property
    def BuyTime(self):
        return self._BuyTime

    @BuyTime.setter
    def BuyTime(self, BuyTime):
        self._BuyTime = BuyTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def CoreVersion(self):
        return self._CoreVersion

    @CoreVersion.setter
    def CoreVersion(self, CoreVersion):
        self._CoreVersion = CoreVersion

    @property
    def OsType(self):
        return self._OsType

    @OsType.setter
    def OsType(self, OsType):
        self._OsType = OsType

    @property
    def AgentVersion(self):
        return self._AgentVersion

    @AgentVersion.setter
    def AgentVersion(self, AgentVersion):
        self._AgentVersion = AgentVersion

    @property
    def InstallTime(self):
        return self._InstallTime

    @InstallTime.setter
    def InstallTime(self, InstallTime):
        self._InstallTime = InstallTime

    @property
    def BootTime(self):
        return self._BootTime

    @BootTime.setter
    def BootTime(self, BootTime):
        self._BootTime = BootTime

    @property
    def LastLiveTime(self):
        return self._LastLiveTime

    @LastLiveTime.setter
    def LastLiveTime(self, LastLiveTime):
        self._LastLiveTime = LastLiveTime

    @property
    def Producer(self):
        return self._Producer

    @Producer.setter
    def Producer(self, Producer):
        self._Producer = Producer

    @property
    def SerialNumber(self):
        return self._SerialNumber

    @SerialNumber.setter
    def SerialNumber(self, SerialNumber):
        self._SerialNumber = SerialNumber

    @property
    def NetCards(self):
        return self._NetCards

    @NetCards.setter
    def NetCards(self, NetCards):
        self._NetCards = NetCards

    @property
    def Disks(self):
        return self._Disks

    @Disks.setter
    def Disks(self, Disks):
        self._Disks = Disks

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def DeviceVersion(self):
        return self._DeviceVersion

    @DeviceVersion.setter
    def DeviceVersion(self, DeviceVersion):
        self._DeviceVersion = DeviceVersion

    @property
    def OfflineTime(self):
        return self._OfflineTime

    @OfflineTime.setter
    def OfflineTime(self, OfflineTime):
        self._OfflineTime = OfflineTime

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def MachineExtraInfo(self):
        return self._MachineExtraInfo

    @MachineExtraInfo.setter
    def MachineExtraInfo(self, MachineExtraInfo):
        self._MachineExtraInfo = MachineExtraInfo


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._MachineIp = params.get("MachineIp")
        self._MachineName = params.get("MachineName")
        self._OsInfo = params.get("OsInfo")
        self._Cpu = params.get("Cpu")
        self._MemSize = params.get("MemSize")
        self._MemLoad = params.get("MemLoad")
        self._DiskSize = params.get("DiskSize")
        self._DiskLoad = params.get("DiskLoad")
        self._PartitionCount = params.get("PartitionCount")
        self._MachineWanIp = params.get("MachineWanIp")
        self._CpuSize = params.get("CpuSize")
        self._CpuLoad = params.get("CpuLoad")
        self._ProtectLevel = params.get("ProtectLevel")
        self._RiskStatus = params.get("RiskStatus")
        self._ProtectDays = params.get("ProtectDays")
        self._BuyTime = params.get("BuyTime")
        self._EndTime = params.get("EndTime")
        self._CoreVersion = params.get("CoreVersion")
        self._OsType = params.get("OsType")
        self._AgentVersion = params.get("AgentVersion")
        self._InstallTime = params.get("InstallTime")
        self._BootTime = params.get("BootTime")
        self._LastLiveTime = params.get("LastLiveTime")
        self._Producer = params.get("Producer")
        self._SerialNumber = params.get("SerialNumber")
        if params.get("NetCards") is not None:
            self._NetCards = []
            for item in params.get("NetCards"):
                obj = AssetNetworkCardInfo()
                obj._deserialize(item)
                self._NetCards.append(obj)
        if params.get("Disks") is not None:
            self._Disks = []
            for item in params.get("Disks"):
                obj = AssetDiskPartitionInfo()
                obj._deserialize(item)
                self._Disks.append(obj)
        self._Status = params.get("Status")
        self._ProjectId = params.get("ProjectId")
        self._DeviceVersion = params.get("DeviceVersion")
        self._OfflineTime = params.get("OfflineTime")
        self._InstanceId = params.get("InstanceId")
        self._UpdateTime = params.get("UpdateTime")
        if params.get("MachineExtraInfo") is not None:
            self._MachineExtraInfo = MachineExtraInfo()
            self._MachineExtraInfo._deserialize(params.get("MachineExtraInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetNetworkCardInfo(AbstractModel):
    """资产管理网卡信息

    """

    def __init__(self):
        r"""
        :param _Name: 网卡名称
        :type Name: str
        :param _Ip: Ipv4对应IP
        :type Ip: str
        :param _GateWay: 网关
        :type GateWay: str
        :param _Mac: MAC地址
        :type Mac: str
        :param _Ipv6: Ipv6对应IP
        :type Ipv6: str
        :param _DnsServer: DNS服务器
        :type DnsServer: str
        """
        self._Name = None
        self._Ip = None
        self._GateWay = None
        self._Mac = None
        self._Ipv6 = None
        self._DnsServer = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Ip(self):
        return self._Ip

    @Ip.setter
    def Ip(self, Ip):
        self._Ip = Ip

    @property
    def GateWay(self):
        return self._GateWay

    @GateWay.setter
    def GateWay(self, GateWay):
        self._GateWay = GateWay

    @property
    def Mac(self):
        return self._Mac

    @Mac.setter
    def Mac(self, Mac):
        self._Mac = Mac

    @property
    def Ipv6(self):
        return self._Ipv6

    @Ipv6.setter
    def Ipv6(self, Ipv6):
        self._Ipv6 = Ipv6

    @property
    def DnsServer(self):
        return self._DnsServer

    @DnsServer.setter
    def DnsServer(self, DnsServer):
        self._DnsServer = DnsServer


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Ip = params.get("Ip")
        self._GateWay = params.get("GateWay")
        self._Mac = params.get("Mac")
        self._Ipv6 = params.get("Ipv6")
        self._DnsServer = params.get("DnsServer")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetPlanTask(AbstractModel):
    """资产管理计划任务列表

    """

    def __init__(self):
        r"""
        :param _Status: 默认启用状态：1启用，2未启用
        :type Status: int
        :param _Cycle: 执行周期
        :type Cycle: str
        :param _Command: 执行命令或脚本
        :type Command: str
        :param _User: 启动用户
        :type User: str
        :param _ConfigPath: 配置文件路径
        :type ConfigPath: str
        :param _MachineIp: 服务器IP
        :type MachineIp: str
        :param _MachineName: 服务器名称
        :type MachineName: str
        :param _OsInfo: 操作系统
        :type OsInfo: str
        :param _Quuid: 主机Quuid
        :type Quuid: str
        :param _Uuid: 主机uuid
        :type Uuid: str
        :param _UpdateTime: 数据更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: str
        :param _FirstTime: 首次采集时间
        :type FirstTime: str
        :param _IsNew: 是否新增[0:否|1:是]
        :type IsNew: int
        :param _MachineWanIp: 服务器外网IP
        :type MachineWanIp: str
        :param _MachineExtraInfo:  附加信息
注意：此字段可能返回 null，表示取不到有效值。
        :type MachineExtraInfo: :class:`tencentcloud.cwp.v20180228.models.MachineExtraInfo`
        """
        self._Status = None
        self._Cycle = None
        self._Command = None
        self._User = None
        self._ConfigPath = None
        self._MachineIp = None
        self._MachineName = None
        self._OsInfo = None
        self._Quuid = None
        self._Uuid = None
        self._UpdateTime = None
        self._FirstTime = None
        self._IsNew = None
        self._MachineWanIp = None
        self._MachineExtraInfo = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Cycle(self):
        return self._Cycle

    @Cycle.setter
    def Cycle(self, Cycle):
        self._Cycle = Cycle

    @property
    def Command(self):
        return self._Command

    @Command.setter
    def Command(self, Command):
        self._Command = Command

    @property
    def User(self):
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def ConfigPath(self):
        return self._ConfigPath

    @ConfigPath.setter
    def ConfigPath(self, ConfigPath):
        self._ConfigPath = ConfigPath

    @property
    def MachineIp(self):
        return self._MachineIp

    @MachineIp.setter
    def MachineIp(self, MachineIp):
        self._MachineIp = MachineIp

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def OsInfo(self):
        return self._OsInfo

    @OsInfo.setter
    def OsInfo(self, OsInfo):
        self._OsInfo = OsInfo

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def FirstTime(self):
        return self._FirstTime

    @FirstTime.setter
    def FirstTime(self, FirstTime):
        self._FirstTime = FirstTime

    @property
    def IsNew(self):
        return self._IsNew

    @IsNew.setter
    def IsNew(self, IsNew):
        self._IsNew = IsNew

    @property
    def MachineWanIp(self):
        return self._MachineWanIp

    @MachineWanIp.setter
    def MachineWanIp(self, MachineWanIp):
        self._MachineWanIp = MachineWanIp

    @property
    def MachineExtraInfo(self):
        return self._MachineExtraInfo

    @MachineExtraInfo.setter
    def MachineExtraInfo(self, MachineExtraInfo):
        self._MachineExtraInfo = MachineExtraInfo


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._Cycle = params.get("Cycle")
        self._Command = params.get("Command")
        self._User = params.get("User")
        self._ConfigPath = params.get("ConfigPath")
        self._MachineIp = params.get("MachineIp")
        self._MachineName = params.get("MachineName")
        self._OsInfo = params.get("OsInfo")
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._UpdateTime = params.get("UpdateTime")
        self._FirstTime = params.get("FirstTime")
        self._IsNew = params.get("IsNew")
        self._MachineWanIp = params.get("MachineWanIp")
        if params.get("MachineExtraInfo") is not None:
            self._MachineExtraInfo = MachineExtraInfo()
            self._MachineExtraInfo._deserialize(params.get("MachineExtraInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetPortBaseInfo(AbstractModel):
    """资源管理账号基本信息

    """

    def __init__(self):
        r"""
        :param _MachineIp: 主机内网IP
        :type MachineIp: str
        :param _MachineWanIp: 主机外网IP
        :type MachineWanIp: str
        :param _Quuid: 主机Quuid
        :type Quuid: str
        :param _Uuid: 主机Uuid
        :type Uuid: str
        :param _OsInfo: 操作系统信息
        :type OsInfo: str
        :param _ProjectId: 主机业务组ID
        :type ProjectId: int
        :param _Tag: 主机标签
注意：此字段可能返回 null，表示取不到有效值。
        :type Tag: list of MachineTag
        :param _ProcessName: 进程名称
        :type ProcessName: str
        :param _ProcessVersion: 进程版本
        :type ProcessVersion: str
        :param _ProcessPath: 进程路径
        :type ProcessPath: str
        :param _Pid: 进程ID
        :type Pid: str
        :param _User: 运行用户
        :type User: str
        :param _StartTime: 启动时间
        :type StartTime: str
        :param _Param: 启动参数
        :type Param: str
        :param _Teletype: 进程TTY
        :type Teletype: str
        :param _Port: 端口
        :type Port: str
        :param _GroupName: 所属用户组
        :type GroupName: str
        :param _Md5: 进程MD5
        :type Md5: str
        :param _Ppid: 父进程ID
        :type Ppid: str
        :param _ParentProcessName: 父进程名称
        :type ParentProcessName: str
        :param _Proto: 端口协议
        :type Proto: str
        :param _BindIp: 绑定IP
        :type BindIp: str
        :param _MachineName: 主机名称
        :type MachineName: str
        :param _UpdateTime: 数据更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: str
        :param _FirstTime: 首次采集时间
        :type FirstTime: str
        :param _IsNew: 是否新增[0:否|1:是]
        :type IsNew: int
        :param _MachineExtraInfo:  附加信息
注意：此字段可能返回 null，表示取不到有效值。
        :type MachineExtraInfo: :class:`tencentcloud.cwp.v20180228.models.MachineExtraInfo`
        """
        self._MachineIp = None
        self._MachineWanIp = None
        self._Quuid = None
        self._Uuid = None
        self._OsInfo = None
        self._ProjectId = None
        self._Tag = None
        self._ProcessName = None
        self._ProcessVersion = None
        self._ProcessPath = None
        self._Pid = None
        self._User = None
        self._StartTime = None
        self._Param = None
        self._Teletype = None
        self._Port = None
        self._GroupName = None
        self._Md5 = None
        self._Ppid = None
        self._ParentProcessName = None
        self._Proto = None
        self._BindIp = None
        self._MachineName = None
        self._UpdateTime = None
        self._FirstTime = None
        self._IsNew = None
        self._MachineExtraInfo = None

    @property
    def MachineIp(self):
        return self._MachineIp

    @MachineIp.setter
    def MachineIp(self, MachineIp):
        self._MachineIp = MachineIp

    @property
    def MachineWanIp(self):
        return self._MachineWanIp

    @MachineWanIp.setter
    def MachineWanIp(self, MachineWanIp):
        self._MachineWanIp = MachineWanIp

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def OsInfo(self):
        return self._OsInfo

    @OsInfo.setter
    def OsInfo(self, OsInfo):
        self._OsInfo = OsInfo

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Tag(self):
        return self._Tag

    @Tag.setter
    def Tag(self, Tag):
        self._Tag = Tag

    @property
    def ProcessName(self):
        return self._ProcessName

    @ProcessName.setter
    def ProcessName(self, ProcessName):
        self._ProcessName = ProcessName

    @property
    def ProcessVersion(self):
        return self._ProcessVersion

    @ProcessVersion.setter
    def ProcessVersion(self, ProcessVersion):
        self._ProcessVersion = ProcessVersion

    @property
    def ProcessPath(self):
        return self._ProcessPath

    @ProcessPath.setter
    def ProcessPath(self, ProcessPath):
        self._ProcessPath = ProcessPath

    @property
    def Pid(self):
        return self._Pid

    @Pid.setter
    def Pid(self, Pid):
        self._Pid = Pid

    @property
    def User(self):
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def Param(self):
        return self._Param

    @Param.setter
    def Param(self, Param):
        self._Param = Param

    @property
    def Teletype(self):
        return self._Teletype

    @Teletype.setter
    def Teletype(self, Teletype):
        self._Teletype = Teletype

    @property
    def Port(self):
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def GroupName(self):
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName

    @property
    def Md5(self):
        return self._Md5

    @Md5.setter
    def Md5(self, Md5):
        self._Md5 = Md5

    @property
    def Ppid(self):
        return self._Ppid

    @Ppid.setter
    def Ppid(self, Ppid):
        self._Ppid = Ppid

    @property
    def ParentProcessName(self):
        return self._ParentProcessName

    @ParentProcessName.setter
    def ParentProcessName(self, ParentProcessName):
        self._ParentProcessName = ParentProcessName

    @property
    def Proto(self):
        return self._Proto

    @Proto.setter
    def Proto(self, Proto):
        self._Proto = Proto

    @property
    def BindIp(self):
        return self._BindIp

    @BindIp.setter
    def BindIp(self, BindIp):
        self._BindIp = BindIp

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def FirstTime(self):
        return self._FirstTime

    @FirstTime.setter
    def FirstTime(self, FirstTime):
        self._FirstTime = FirstTime

    @property
    def IsNew(self):
        return self._IsNew

    @IsNew.setter
    def IsNew(self, IsNew):
        self._IsNew = IsNew

    @property
    def MachineExtraInfo(self):
        return self._MachineExtraInfo

    @MachineExtraInfo.setter
    def MachineExtraInfo(self, MachineExtraInfo):
        self._MachineExtraInfo = MachineExtraInfo


    def _deserialize(self, params):
        self._MachineIp = params.get("MachineIp")
        self._MachineWanIp = params.get("MachineWanIp")
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._OsInfo = params.get("OsInfo")
        self._ProjectId = params.get("ProjectId")
        if params.get("Tag") is not None:
            self._Tag = []
            for item in params.get("Tag"):
                obj = MachineTag()
                obj._deserialize(item)
                self._Tag.append(obj)
        self._ProcessName = params.get("ProcessName")
        self._ProcessVersion = params.get("ProcessVersion")
        self._ProcessPath = params.get("ProcessPath")
        self._Pid = params.get("Pid")
        self._User = params.get("User")
        self._StartTime = params.get("StartTime")
        self._Param = params.get("Param")
        self._Teletype = params.get("Teletype")
        self._Port = params.get("Port")
        self._GroupName = params.get("GroupName")
        self._Md5 = params.get("Md5")
        self._Ppid = params.get("Ppid")
        self._ParentProcessName = params.get("ParentProcessName")
        self._Proto = params.get("Proto")
        self._BindIp = params.get("BindIp")
        self._MachineName = params.get("MachineName")
        self._UpdateTime = params.get("UpdateTime")
        self._FirstTime = params.get("FirstTime")
        self._IsNew = params.get("IsNew")
        if params.get("MachineExtraInfo") is not None:
            self._MachineExtraInfo = MachineExtraInfo()
            self._MachineExtraInfo._deserialize(params.get("MachineExtraInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetProcessBaseInfo(AbstractModel):
    """资源管理进程基本信息

    """

    def __init__(self):
        r"""
        :param _MachineIp: 主机内网IP
        :type MachineIp: str
        :param _MachineWanIp: 主机外网IP
        :type MachineWanIp: str
        :param _Quuid: 主机Quuid
        :type Quuid: str
        :param _Uuid: 主机Uuid
        :type Uuid: str
        :param _OsInfo: 操作系统信息
        :type OsInfo: str
        :param _ProjectId: 主机业务组ID
        :type ProjectId: int
        :param _Tag: 主机标签
注意：此字段可能返回 null，表示取不到有效值。
        :type Tag: list of MachineTag
        :param _Name: 进程名称
        :type Name: str
        :param _Desc: 进程说明
        :type Desc: str
        :param _Path: 进程路径
        :type Path: str
        :param _Pid: 进程ID
        :type Pid: str
        :param _User: 运行用户
        :type User: str
        :param _StartTime: 启动时间
        :type StartTime: str
        :param _Param: 启动参数
        :type Param: str
        :param _Tty: 进程TTY
        :type Tty: str
        :param _Version: 进程版本
        :type Version: str
        :param _GroupName: 进程用户组
        :type GroupName: str
        :param _Md5: 进程MD5
        :type Md5: str
        :param _Ppid: 父进程ID
        :type Ppid: str
        :param _ParentProcessName: 父进程名称
        :type ParentProcessName: str
        :param _Status: 进程状态
        :type Status: str
        :param _HasSign: 数字签名:0无，1有， 999 空，仅windows
        :type HasSign: int
        :param _InstallByPackage: 是否通过安装包安装：:0否，1是， 999 空，仅linux
        :type InstallByPackage: int
        :param _PackageName: 软件包名
        :type PackageName: str
        :param _MachineName: 主机名称
        :type MachineName: str
        :param _UpdateTime: 数据更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: str
        :param _FirstTime: 首次采集时间
        :type FirstTime: str
        :param _IsNew: 是否新增[0:否|1:是]
        :type IsNew: int
        :param _MachineExtraInfo: 
 附加信息

注意：此字段可能返回 null，表示取不到有效值。
        :type MachineExtraInfo: :class:`tencentcloud.cwp.v20180228.models.MachineExtraInfo`
        """
        self._MachineIp = None
        self._MachineWanIp = None
        self._Quuid = None
        self._Uuid = None
        self._OsInfo = None
        self._ProjectId = None
        self._Tag = None
        self._Name = None
        self._Desc = None
        self._Path = None
        self._Pid = None
        self._User = None
        self._StartTime = None
        self._Param = None
        self._Tty = None
        self._Version = None
        self._GroupName = None
        self._Md5 = None
        self._Ppid = None
        self._ParentProcessName = None
        self._Status = None
        self._HasSign = None
        self._InstallByPackage = None
        self._PackageName = None
        self._MachineName = None
        self._UpdateTime = None
        self._FirstTime = None
        self._IsNew = None
        self._MachineExtraInfo = None

    @property
    def MachineIp(self):
        return self._MachineIp

    @MachineIp.setter
    def MachineIp(self, MachineIp):
        self._MachineIp = MachineIp

    @property
    def MachineWanIp(self):
        return self._MachineWanIp

    @MachineWanIp.setter
    def MachineWanIp(self, MachineWanIp):
        self._MachineWanIp = MachineWanIp

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def OsInfo(self):
        return self._OsInfo

    @OsInfo.setter
    def OsInfo(self, OsInfo):
        self._OsInfo = OsInfo

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Tag(self):
        return self._Tag

    @Tag.setter
    def Tag(self, Tag):
        self._Tag = Tag

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Desc(self):
        return self._Desc

    @Desc.setter
    def Desc(self, Desc):
        self._Desc = Desc

    @property
    def Path(self):
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def Pid(self):
        return self._Pid

    @Pid.setter
    def Pid(self, Pid):
        self._Pid = Pid

    @property
    def User(self):
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def Param(self):
        return self._Param

    @Param.setter
    def Param(self, Param):
        self._Param = Param

    @property
    def Tty(self):
        return self._Tty

    @Tty.setter
    def Tty(self, Tty):
        self._Tty = Tty

    @property
    def Version(self):
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def GroupName(self):
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName

    @property
    def Md5(self):
        return self._Md5

    @Md5.setter
    def Md5(self, Md5):
        self._Md5 = Md5

    @property
    def Ppid(self):
        return self._Ppid

    @Ppid.setter
    def Ppid(self, Ppid):
        self._Ppid = Ppid

    @property
    def ParentProcessName(self):
        return self._ParentProcessName

    @ParentProcessName.setter
    def ParentProcessName(self, ParentProcessName):
        self._ParentProcessName = ParentProcessName

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def HasSign(self):
        return self._HasSign

    @HasSign.setter
    def HasSign(self, HasSign):
        self._HasSign = HasSign

    @property
    def InstallByPackage(self):
        return self._InstallByPackage

    @InstallByPackage.setter
    def InstallByPackage(self, InstallByPackage):
        self._InstallByPackage = InstallByPackage

    @property
    def PackageName(self):
        return self._PackageName

    @PackageName.setter
    def PackageName(self, PackageName):
        self._PackageName = PackageName

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def FirstTime(self):
        return self._FirstTime

    @FirstTime.setter
    def FirstTime(self, FirstTime):
        self._FirstTime = FirstTime

    @property
    def IsNew(self):
        return self._IsNew

    @IsNew.setter
    def IsNew(self, IsNew):
        self._IsNew = IsNew

    @property
    def MachineExtraInfo(self):
        return self._MachineExtraInfo

    @MachineExtraInfo.setter
    def MachineExtraInfo(self, MachineExtraInfo):
        self._MachineExtraInfo = MachineExtraInfo


    def _deserialize(self, params):
        self._MachineIp = params.get("MachineIp")
        self._MachineWanIp = params.get("MachineWanIp")
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._OsInfo = params.get("OsInfo")
        self._ProjectId = params.get("ProjectId")
        if params.get("Tag") is not None:
            self._Tag = []
            for item in params.get("Tag"):
                obj = MachineTag()
                obj._deserialize(item)
                self._Tag.append(obj)
        self._Name = params.get("Name")
        self._Desc = params.get("Desc")
        self._Path = params.get("Path")
        self._Pid = params.get("Pid")
        self._User = params.get("User")
        self._StartTime = params.get("StartTime")
        self._Param = params.get("Param")
        self._Tty = params.get("Tty")
        self._Version = params.get("Version")
        self._GroupName = params.get("GroupName")
        self._Md5 = params.get("Md5")
        self._Ppid = params.get("Ppid")
        self._ParentProcessName = params.get("ParentProcessName")
        self._Status = params.get("Status")
        self._HasSign = params.get("HasSign")
        self._InstallByPackage = params.get("InstallByPackage")
        self._PackageName = params.get("PackageName")
        self._MachineName = params.get("MachineName")
        self._UpdateTime = params.get("UpdateTime")
        self._FirstTime = params.get("FirstTime")
        self._IsNew = params.get("IsNew")
        if params.get("MachineExtraInfo") is not None:
            self._MachineExtraInfo = MachineExtraInfo()
            self._MachineExtraInfo._deserialize(params.get("MachineExtraInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetSystemPackageInfo(AbstractModel):
    """资源管理系统安装包列表信息

    """

    def __init__(self):
        r"""
        :param _Name: 数据库名
        :type Name: str
        :param _Desc: 描述
        :type Desc: str
        :param _Version: 版本
        :type Version: str
        :param _InstallTime: 安装时间
        :type InstallTime: str
        :param _Type: 类型
        :type Type: str
        :param _MachineName: 主机名称
        :type MachineName: str
        :param _MachineIp: 主机IP
        :type MachineIp: str
        :param _OsInfo: 操作系统
        :type OsInfo: str
        :param _UpdateTime: 数据更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: str
        :param _FirstTime: 首次采集时间
        :type FirstTime: str
        :param _IsNew: 是否新增[0:否|1:是]
        :type IsNew: int
        :param _MachineExtraInfo: 附加信息
        :type MachineExtraInfo: :class:`tencentcloud.cwp.v20180228.models.MachineExtraInfo`
        :param _Quuid: 主机Id
        :type Quuid: str
        :param _Uuid: Agent Id
        :type Uuid: str
        """
        self._Name = None
        self._Desc = None
        self._Version = None
        self._InstallTime = None
        self._Type = None
        self._MachineName = None
        self._MachineIp = None
        self._OsInfo = None
        self._UpdateTime = None
        self._FirstTime = None
        self._IsNew = None
        self._MachineExtraInfo = None
        self._Quuid = None
        self._Uuid = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Desc(self):
        return self._Desc

    @Desc.setter
    def Desc(self, Desc):
        self._Desc = Desc

    @property
    def Version(self):
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def InstallTime(self):
        return self._InstallTime

    @InstallTime.setter
    def InstallTime(self, InstallTime):
        self._InstallTime = InstallTime

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def MachineIp(self):
        return self._MachineIp

    @MachineIp.setter
    def MachineIp(self, MachineIp):
        self._MachineIp = MachineIp

    @property
    def OsInfo(self):
        return self._OsInfo

    @OsInfo.setter
    def OsInfo(self, OsInfo):
        self._OsInfo = OsInfo

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def FirstTime(self):
        return self._FirstTime

    @FirstTime.setter
    def FirstTime(self, FirstTime):
        self._FirstTime = FirstTime

    @property
    def IsNew(self):
        return self._IsNew

    @IsNew.setter
    def IsNew(self, IsNew):
        self._IsNew = IsNew

    @property
    def MachineExtraInfo(self):
        return self._MachineExtraInfo

    @MachineExtraInfo.setter
    def MachineExtraInfo(self, MachineExtraInfo):
        self._MachineExtraInfo = MachineExtraInfo

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Desc = params.get("Desc")
        self._Version = params.get("Version")
        self._InstallTime = params.get("InstallTime")
        self._Type = params.get("Type")
        self._MachineName = params.get("MachineName")
        self._MachineIp = params.get("MachineIp")
        self._OsInfo = params.get("OsInfo")
        self._UpdateTime = params.get("UpdateTime")
        self._FirstTime = params.get("FirstTime")
        self._IsNew = params.get("IsNew")
        if params.get("MachineExtraInfo") is not None:
            self._MachineExtraInfo = MachineExtraInfo()
            self._MachineExtraInfo._deserialize(params.get("MachineExtraInfo"))
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetUserBaseInfo(AbstractModel):
    """资源管理账号基本信息

    """

    def __init__(self):
        r"""
        :param _MachineIp: 主机内网IP
        :type MachineIp: str
        :param _MachineWanIp: 主机外网IP
        :type MachineWanIp: str
        :param _MachineName: 主机名称
        :type MachineName: str
        :param _OsInfo: 操作系统信息
        :type OsInfo: str
        :param _Uuid: 主机Uuid
        :type Uuid: str
        :param _Quuid: 主机Quuid
        :type Quuid: str
        :param _Uid: 账号UID
        :type Uid: str
        :param _Gid: 账号GID
        :type Gid: str
        :param _Status: 账号状态：0-禁用；1-启用
        :type Status: int
        :param _IsRoot: 是否有root权限：0-否；1是，999为空: 仅linux
        :type IsRoot: int
        :param _LoginType: 登录方式：0-不可登录；1-只允许key登录；2只允许密码登录；3-允许key和密码，999为空，仅linux
        :type LoginType: int
        :param _LastLoginTime: 上次登录时间
        :type LastLoginTime: str
        :param _Name: 账号名称
        :type Name: str
        :param _ProjectId: 主机业务组ID
        :type ProjectId: int
        :param _UserType: 账号类型：0访客用户，1标准用户，2管理员用户 ,999为空,仅windows
        :type UserType: int
        :param _IsDomain: 是否域账号：0否， 1是，2否, 999为空  仅windows
        :type IsDomain: int
        :param _IsSudo: 是否有sudo权限，1是，0否, 999为空, 仅linux
        :type IsSudo: int
        :param _IsSshLogin: 是否允许ssh登录，1是，0否, 999为空, 仅linux
        :type IsSshLogin: int
        :param _HomePath: Home目录
        :type HomePath: str
        :param _Shell: Shell路径  仅linux
        :type Shell: str
        :param _ShellLoginStatus: 是否shell登录性，0不是；1是 仅linux
        :type ShellLoginStatus: int
        :param _PasswordChangeTime: 密码修改时间
        :type PasswordChangeTime: str
        :param _PasswordDueTime: 密码过期时间  仅linux
        :type PasswordDueTime: str
        :param _PasswordLockDays: 密码锁定时间：单位天, -1为永不锁定 999为空，仅linux
        :type PasswordLockDays: int
        :param _PasswordStatus: 密码状态：1正常 2即将过期 3已过期 4已锁定 999为空 仅linux
        :type PasswordStatus: int
        :param _UpdateTime: 更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: str
        :param _FirstTime: 首次采集时间
        :type FirstTime: str
        :param _IsNew: 是否新增[0:否|1:是]
        :type IsNew: int
        :param _MachineExtraInfo: 
 附加信息
注意：此字段可能返回 null，表示取不到有效值。
        :type MachineExtraInfo: :class:`tencentcloud.cwp.v20180228.models.MachineExtraInfo`
        """
        self._MachineIp = None
        self._MachineWanIp = None
        self._MachineName = None
        self._OsInfo = None
        self._Uuid = None
        self._Quuid = None
        self._Uid = None
        self._Gid = None
        self._Status = None
        self._IsRoot = None
        self._LoginType = None
        self._LastLoginTime = None
        self._Name = None
        self._ProjectId = None
        self._UserType = None
        self._IsDomain = None
        self._IsSudo = None
        self._IsSshLogin = None
        self._HomePath = None
        self._Shell = None
        self._ShellLoginStatus = None
        self._PasswordChangeTime = None
        self._PasswordDueTime = None
        self._PasswordLockDays = None
        self._PasswordStatus = None
        self._UpdateTime = None
        self._FirstTime = None
        self._IsNew = None
        self._MachineExtraInfo = None

    @property
    def MachineIp(self):
        return self._MachineIp

    @MachineIp.setter
    def MachineIp(self, MachineIp):
        self._MachineIp = MachineIp

    @property
    def MachineWanIp(self):
        return self._MachineWanIp

    @MachineWanIp.setter
    def MachineWanIp(self, MachineWanIp):
        self._MachineWanIp = MachineWanIp

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def OsInfo(self):
        return self._OsInfo

    @OsInfo.setter
    def OsInfo(self, OsInfo):
        self._OsInfo = OsInfo

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uid(self):
        return self._Uid

    @Uid.setter
    def Uid(self, Uid):
        self._Uid = Uid

    @property
    def Gid(self):
        return self._Gid

    @Gid.setter
    def Gid(self, Gid):
        self._Gid = Gid

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def IsRoot(self):
        return self._IsRoot

    @IsRoot.setter
    def IsRoot(self, IsRoot):
        self._IsRoot = IsRoot

    @property
    def LoginType(self):
        return self._LoginType

    @LoginType.setter
    def LoginType(self, LoginType):
        self._LoginType = LoginType

    @property
    def LastLoginTime(self):
        return self._LastLoginTime

    @LastLoginTime.setter
    def LastLoginTime(self, LastLoginTime):
        self._LastLoginTime = LastLoginTime

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def UserType(self):
        return self._UserType

    @UserType.setter
    def UserType(self, UserType):
        self._UserType = UserType

    @property
    def IsDomain(self):
        return self._IsDomain

    @IsDomain.setter
    def IsDomain(self, IsDomain):
        self._IsDomain = IsDomain

    @property
    def IsSudo(self):
        return self._IsSudo

    @IsSudo.setter
    def IsSudo(self, IsSudo):
        self._IsSudo = IsSudo

    @property
    def IsSshLogin(self):
        return self._IsSshLogin

    @IsSshLogin.setter
    def IsSshLogin(self, IsSshLogin):
        self._IsSshLogin = IsSshLogin

    @property
    def HomePath(self):
        return self._HomePath

    @HomePath.setter
    def HomePath(self, HomePath):
        self._HomePath = HomePath

    @property
    def Shell(self):
        return self._Shell

    @Shell.setter
    def Shell(self, Shell):
        self._Shell = Shell

    @property
    def ShellLoginStatus(self):
        return self._ShellLoginStatus

    @ShellLoginStatus.setter
    def ShellLoginStatus(self, ShellLoginStatus):
        self._ShellLoginStatus = ShellLoginStatus

    @property
    def PasswordChangeTime(self):
        return self._PasswordChangeTime

    @PasswordChangeTime.setter
    def PasswordChangeTime(self, PasswordChangeTime):
        self._PasswordChangeTime = PasswordChangeTime

    @property
    def PasswordDueTime(self):
        return self._PasswordDueTime

    @PasswordDueTime.setter
    def PasswordDueTime(self, PasswordDueTime):
        self._PasswordDueTime = PasswordDueTime

    @property
    def PasswordLockDays(self):
        return self._PasswordLockDays

    @PasswordLockDays.setter
    def PasswordLockDays(self, PasswordLockDays):
        self._PasswordLockDays = PasswordLockDays

    @property
    def PasswordStatus(self):
        return self._PasswordStatus

    @PasswordStatus.setter
    def PasswordStatus(self, PasswordStatus):
        self._PasswordStatus = PasswordStatus

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def FirstTime(self):
        return self._FirstTime

    @FirstTime.setter
    def FirstTime(self, FirstTime):
        self._FirstTime = FirstTime

    @property
    def IsNew(self):
        return self._IsNew

    @IsNew.setter
    def IsNew(self, IsNew):
        self._IsNew = IsNew

    @property
    def MachineExtraInfo(self):
        return self._MachineExtraInfo

    @MachineExtraInfo.setter
    def MachineExtraInfo(self, MachineExtraInfo):
        self._MachineExtraInfo = MachineExtraInfo


    def _deserialize(self, params):
        self._MachineIp = params.get("MachineIp")
        self._MachineWanIp = params.get("MachineWanIp")
        self._MachineName = params.get("MachineName")
        self._OsInfo = params.get("OsInfo")
        self._Uuid = params.get("Uuid")
        self._Quuid = params.get("Quuid")
        self._Uid = params.get("Uid")
        self._Gid = params.get("Gid")
        self._Status = params.get("Status")
        self._IsRoot = params.get("IsRoot")
        self._LoginType = params.get("LoginType")
        self._LastLoginTime = params.get("LastLoginTime")
        self._Name = params.get("Name")
        self._ProjectId = params.get("ProjectId")
        self._UserType = params.get("UserType")
        self._IsDomain = params.get("IsDomain")
        self._IsSudo = params.get("IsSudo")
        self._IsSshLogin = params.get("IsSshLogin")
        self._HomePath = params.get("HomePath")
        self._Shell = params.get("Shell")
        self._ShellLoginStatus = params.get("ShellLoginStatus")
        self._PasswordChangeTime = params.get("PasswordChangeTime")
        self._PasswordDueTime = params.get("PasswordDueTime")
        self._PasswordLockDays = params.get("PasswordLockDays")
        self._PasswordStatus = params.get("PasswordStatus")
        self._UpdateTime = params.get("UpdateTime")
        self._FirstTime = params.get("FirstTime")
        self._IsNew = params.get("IsNew")
        if params.get("MachineExtraInfo") is not None:
            self._MachineExtraInfo = MachineExtraInfo()
            self._MachineExtraInfo._deserialize(params.get("MachineExtraInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetUserDetail(AbstractModel):
    """资源管理账号基本信息

    """

    def __init__(self):
        r"""
        :param _MachineIp: 主机内网IP
        :type MachineIp: str
        :param _MachineName: 主机名称
        :type MachineName: str
        :param _Uuid: 主机Uuid
        :type Uuid: str
        :param _Quuid: 主机Quuid
        :type Quuid: str
        :param _Uid: 账号UID
        :type Uid: str
        :param _Gid: 账号GID
        :type Gid: str
        :param _Status: 账号状态：0-禁用；1-启用
        :type Status: int
        :param _IsRoot: 是否有root权限：0-否；1是，999为空: 仅linux
        :type IsRoot: int
        :param _LastLoginTime: 上次登录时间
        :type LastLoginTime: str
        :param _Name: 账号名称
        :type Name: str
        :param _UserType: 账号类型：0访客用户，1标准用户，2管理员用户 ,999为空,仅windows
        :type UserType: int
        :param _IsDomain: 是否域账号：0否， 1是, 999为空  仅windows
        :type IsDomain: int
        :param _IsSshLogin: 是否允许ssh登录，1是，0否, 999为空, 仅linux
        :type IsSshLogin: int
        :param _HomePath: Home目录
        :type HomePath: str
        :param _Shell: Shell路径  仅linux
        :type Shell: str
        :param _ShellLoginStatus: 是否shell登录性，0不是；1是 仅linux
        :type ShellLoginStatus: int
        :param _PasswordChangeTime: 密码修改时间
        :type PasswordChangeTime: str
        :param _PasswordDueTime: 密码过期时间  仅linux
        :type PasswordDueTime: str
        :param _PasswordLockDays: 密码锁定时间：单位天, -1为永不锁定 999为空，仅linux
        :type PasswordLockDays: int
        :param _Remark: 备注
        :type Remark: str
        :param _GroupName: 用户组名
        :type GroupName: str
        :param _DisableTime: 账号到期时间
        :type DisableTime: str
        :param _LastLoginTerminal: 最近登录终端
        :type LastLoginTerminal: str
        :param _LastLoginLoc: 最近登录位置
        :type LastLoginLoc: str
        :param _LastLoginIp: 最近登录IP
        :type LastLoginIp: str
        :param _PasswordWarnDays: 密码过期提醒：单位天
        :type PasswordWarnDays: int
        :param _PasswordChangeType: 密码修改设置：0-不可修改，1-可修改
        :type PasswordChangeType: int
        :param _Keys: 用户公钥列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Keys: list of AssetUserKeyInfo
        :param _UpdateTime: 数据更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: str
        """
        self._MachineIp = None
        self._MachineName = None
        self._Uuid = None
        self._Quuid = None
        self._Uid = None
        self._Gid = None
        self._Status = None
        self._IsRoot = None
        self._LastLoginTime = None
        self._Name = None
        self._UserType = None
        self._IsDomain = None
        self._IsSshLogin = None
        self._HomePath = None
        self._Shell = None
        self._ShellLoginStatus = None
        self._PasswordChangeTime = None
        self._PasswordDueTime = None
        self._PasswordLockDays = None
        self._Remark = None
        self._GroupName = None
        self._DisableTime = None
        self._LastLoginTerminal = None
        self._LastLoginLoc = None
        self._LastLoginIp = None
        self._PasswordWarnDays = None
        self._PasswordChangeType = None
        self._Keys = None
        self._UpdateTime = None

    @property
    def MachineIp(self):
        return self._MachineIp

    @MachineIp.setter
    def MachineIp(self, MachineIp):
        self._MachineIp = MachineIp

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uid(self):
        return self._Uid

    @Uid.setter
    def Uid(self, Uid):
        self._Uid = Uid

    @property
    def Gid(self):
        return self._Gid

    @Gid.setter
    def Gid(self, Gid):
        self._Gid = Gid

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def IsRoot(self):
        return self._IsRoot

    @IsRoot.setter
    def IsRoot(self, IsRoot):
        self._IsRoot = IsRoot

    @property
    def LastLoginTime(self):
        return self._LastLoginTime

    @LastLoginTime.setter
    def LastLoginTime(self, LastLoginTime):
        self._LastLoginTime = LastLoginTime

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def UserType(self):
        return self._UserType

    @UserType.setter
    def UserType(self, UserType):
        self._UserType = UserType

    @property
    def IsDomain(self):
        return self._IsDomain

    @IsDomain.setter
    def IsDomain(self, IsDomain):
        self._IsDomain = IsDomain

    @property
    def IsSshLogin(self):
        return self._IsSshLogin

    @IsSshLogin.setter
    def IsSshLogin(self, IsSshLogin):
        self._IsSshLogin = IsSshLogin

    @property
    def HomePath(self):
        return self._HomePath

    @HomePath.setter
    def HomePath(self, HomePath):
        self._HomePath = HomePath

    @property
    def Shell(self):
        return self._Shell

    @Shell.setter
    def Shell(self, Shell):
        self._Shell = Shell

    @property
    def ShellLoginStatus(self):
        return self._ShellLoginStatus

    @ShellLoginStatus.setter
    def ShellLoginStatus(self, ShellLoginStatus):
        self._ShellLoginStatus = ShellLoginStatus

    @property
    def PasswordChangeTime(self):
        return self._PasswordChangeTime

    @PasswordChangeTime.setter
    def PasswordChangeTime(self, PasswordChangeTime):
        self._PasswordChangeTime = PasswordChangeTime

    @property
    def PasswordDueTime(self):
        return self._PasswordDueTime

    @PasswordDueTime.setter
    def PasswordDueTime(self, PasswordDueTime):
        self._PasswordDueTime = PasswordDueTime

    @property
    def PasswordLockDays(self):
        return self._PasswordLockDays

    @PasswordLockDays.setter
    def PasswordLockDays(self, PasswordLockDays):
        self._PasswordLockDays = PasswordLockDays

    @property
    def Remark(self):
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def GroupName(self):
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName

    @property
    def DisableTime(self):
        return self._DisableTime

    @DisableTime.setter
    def DisableTime(self, DisableTime):
        self._DisableTime = DisableTime

    @property
    def LastLoginTerminal(self):
        return self._LastLoginTerminal

    @LastLoginTerminal.setter
    def LastLoginTerminal(self, LastLoginTerminal):
        self._LastLoginTerminal = LastLoginTerminal

    @property
    def LastLoginLoc(self):
        return self._LastLoginLoc

    @LastLoginLoc.setter
    def LastLoginLoc(self, LastLoginLoc):
        self._LastLoginLoc = LastLoginLoc

    @property
    def LastLoginIp(self):
        return self._LastLoginIp

    @LastLoginIp.setter
    def LastLoginIp(self, LastLoginIp):
        self._LastLoginIp = LastLoginIp

    @property
    def PasswordWarnDays(self):
        return self._PasswordWarnDays

    @PasswordWarnDays.setter
    def PasswordWarnDays(self, PasswordWarnDays):
        self._PasswordWarnDays = PasswordWarnDays

    @property
    def PasswordChangeType(self):
        return self._PasswordChangeType

    @PasswordChangeType.setter
    def PasswordChangeType(self, PasswordChangeType):
        self._PasswordChangeType = PasswordChangeType

    @property
    def Keys(self):
        return self._Keys

    @Keys.setter
    def Keys(self, Keys):
        self._Keys = Keys

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._MachineIp = params.get("MachineIp")
        self._MachineName = params.get("MachineName")
        self._Uuid = params.get("Uuid")
        self._Quuid = params.get("Quuid")
        self._Uid = params.get("Uid")
        self._Gid = params.get("Gid")
        self._Status = params.get("Status")
        self._IsRoot = params.get("IsRoot")
        self._LastLoginTime = params.get("LastLoginTime")
        self._Name = params.get("Name")
        self._UserType = params.get("UserType")
        self._IsDomain = params.get("IsDomain")
        self._IsSshLogin = params.get("IsSshLogin")
        self._HomePath = params.get("HomePath")
        self._Shell = params.get("Shell")
        self._ShellLoginStatus = params.get("ShellLoginStatus")
        self._PasswordChangeTime = params.get("PasswordChangeTime")
        self._PasswordDueTime = params.get("PasswordDueTime")
        self._PasswordLockDays = params.get("PasswordLockDays")
        self._Remark = params.get("Remark")
        self._GroupName = params.get("GroupName")
        self._DisableTime = params.get("DisableTime")
        self._LastLoginTerminal = params.get("LastLoginTerminal")
        self._LastLoginLoc = params.get("LastLoginLoc")
        self._LastLoginIp = params.get("LastLoginIp")
        self._PasswordWarnDays = params.get("PasswordWarnDays")
        self._PasswordChangeType = params.get("PasswordChangeType")
        if params.get("Keys") is not None:
            self._Keys = []
            for item in params.get("Keys"):
                obj = AssetUserKeyInfo()
                obj._deserialize(item)
                self._Keys.append(obj)
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetUserKeyInfo(AbstractModel):
    """资产管理账号key详情

    """

    def __init__(self):
        r"""
        :param _Value: 公钥值
        :type Value: str
        :param _Comment: 公钥备注
        :type Comment: str
        :param _EncryptType: 加密方式
        :type EncryptType: str
        """
        self._Value = None
        self._Comment = None
        self._EncryptType = None

    @property
    def Value(self):
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def EncryptType(self):
        return self._EncryptType

    @EncryptType.setter
    def EncryptType(self, EncryptType):
        self._EncryptType = EncryptType


    def _deserialize(self, params):
        self._Value = params.get("Value")
        self._Comment = params.get("Comment")
        self._EncryptType = params.get("EncryptType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetWebAppBaseInfo(AbstractModel):
    """资源管理Web应用列表信息

    """

    def __init__(self):
        r"""
        :param _MachineIp: 主机内网IP
        :type MachineIp: str
        :param _MachineWanIp: 主机外网IP
        :type MachineWanIp: str
        :param _Quuid: 主机Quuid
        :type Quuid: str
        :param _Uuid: 主机Uuid
        :type Uuid: str
        :param _OsInfo: 操作系统信息
        :type OsInfo: str
        :param _ProjectId: 主机业务组ID
        :type ProjectId: int
        :param _Tag: 主机标签
注意：此字段可能返回 null，表示取不到有效值。
        :type Tag: list of MachineTag
        :param _Name: 应用名
        :type Name: str
        :param _Version: 版本
        :type Version: str
        :param _RootPath: 根路径
        :type RootPath: str
        :param _ServiceType: 服务类型
        :type ServiceType: str
        :param _Domain: 站点域名
        :type Domain: str
        :param _VirtualPath: 虚拟路径
        :type VirtualPath: str
        :param _PluginCount: 插件数
        :type PluginCount: int
        :param _Id: 应用ID
        :type Id: str
        :param _Desc: 应用描述
        :type Desc: str
        :param _MachineName: 主机名称
        :type MachineName: str
        :param _UpdateTime: 数据更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: str
        :param _FirstTime: 首次采集时间
        :type FirstTime: str
        :param _IsNew: 是否新增[0:否|1:是]
        :type IsNew: int
        :param _MachineExtraInfo:  附加信息
注意：此字段可能返回 null，表示取不到有效值。
        :type MachineExtraInfo: :class:`tencentcloud.cwp.v20180228.models.MachineExtraInfo`
        """
        self._MachineIp = None
        self._MachineWanIp = None
        self._Quuid = None
        self._Uuid = None
        self._OsInfo = None
        self._ProjectId = None
        self._Tag = None
        self._Name = None
        self._Version = None
        self._RootPath = None
        self._ServiceType = None
        self._Domain = None
        self._VirtualPath = None
        self._PluginCount = None
        self._Id = None
        self._Desc = None
        self._MachineName = None
        self._UpdateTime = None
        self._FirstTime = None
        self._IsNew = None
        self._MachineExtraInfo = None

    @property
    def MachineIp(self):
        return self._MachineIp

    @MachineIp.setter
    def MachineIp(self, MachineIp):
        self._MachineIp = MachineIp

    @property
    def MachineWanIp(self):
        return self._MachineWanIp

    @MachineWanIp.setter
    def MachineWanIp(self, MachineWanIp):
        self._MachineWanIp = MachineWanIp

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def OsInfo(self):
        return self._OsInfo

    @OsInfo.setter
    def OsInfo(self, OsInfo):
        self._OsInfo = OsInfo

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Tag(self):
        return self._Tag

    @Tag.setter
    def Tag(self, Tag):
        self._Tag = Tag

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Version(self):
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def RootPath(self):
        return self._RootPath

    @RootPath.setter
    def RootPath(self, RootPath):
        self._RootPath = RootPath

    @property
    def ServiceType(self):
        return self._ServiceType

    @ServiceType.setter
    def ServiceType(self, ServiceType):
        self._ServiceType = ServiceType

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def VirtualPath(self):
        return self._VirtualPath

    @VirtualPath.setter
    def VirtualPath(self, VirtualPath):
        self._VirtualPath = VirtualPath

    @property
    def PluginCount(self):
        return self._PluginCount

    @PluginCount.setter
    def PluginCount(self, PluginCount):
        self._PluginCount = PluginCount

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Desc(self):
        return self._Desc

    @Desc.setter
    def Desc(self, Desc):
        self._Desc = Desc

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def FirstTime(self):
        return self._FirstTime

    @FirstTime.setter
    def FirstTime(self, FirstTime):
        self._FirstTime = FirstTime

    @property
    def IsNew(self):
        return self._IsNew

    @IsNew.setter
    def IsNew(self, IsNew):
        self._IsNew = IsNew

    @property
    def MachineExtraInfo(self):
        return self._MachineExtraInfo

    @MachineExtraInfo.setter
    def MachineExtraInfo(self, MachineExtraInfo):
        self._MachineExtraInfo = MachineExtraInfo


    def _deserialize(self, params):
        self._MachineIp = params.get("MachineIp")
        self._MachineWanIp = params.get("MachineWanIp")
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._OsInfo = params.get("OsInfo")
        self._ProjectId = params.get("ProjectId")
        if params.get("Tag") is not None:
            self._Tag = []
            for item in params.get("Tag"):
                obj = MachineTag()
                obj._deserialize(item)
                self._Tag.append(obj)
        self._Name = params.get("Name")
        self._Version = params.get("Version")
        self._RootPath = params.get("RootPath")
        self._ServiceType = params.get("ServiceType")
        self._Domain = params.get("Domain")
        self._VirtualPath = params.get("VirtualPath")
        self._PluginCount = params.get("PluginCount")
        self._Id = params.get("Id")
        self._Desc = params.get("Desc")
        self._MachineName = params.get("MachineName")
        self._UpdateTime = params.get("UpdateTime")
        self._FirstTime = params.get("FirstTime")
        self._IsNew = params.get("IsNew")
        if params.get("MachineExtraInfo") is not None:
            self._MachineExtraInfo = MachineExtraInfo()
            self._MachineExtraInfo._deserialize(params.get("MachineExtraInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetWebAppPluginInfo(AbstractModel):
    """资产管理Web应用插件详情

    """

    def __init__(self):
        r"""
        :param _Name: 名称
        :type Name: str
        :param _Desc: 描述
        :type Desc: str
        :param _Version: 版本
        :type Version: str
        :param _Link: 链接
        :type Link: str
        """
        self._Name = None
        self._Desc = None
        self._Version = None
        self._Link = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Desc(self):
        return self._Desc

    @Desc.setter
    def Desc(self, Desc):
        self._Desc = Desc

    @property
    def Version(self):
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def Link(self):
        return self._Link

    @Link.setter
    def Link(self, Link):
        self._Link = Link


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Desc = params.get("Desc")
        self._Version = params.get("Version")
        self._Link = params.get("Link")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetWebFrameBaseInfo(AbstractModel):
    """资源管理Web应用列表信息

    """

    def __init__(self):
        r"""
        :param _MachineIp: 主机内网IP
        :type MachineIp: str
        :param _MachineWanIp: 主机外网IP
        :type MachineWanIp: str
        :param _Quuid: 主机Quuid
        :type Quuid: str
        :param _Uuid: 主机Uuid
        :type Uuid: str
        :param _OsInfo: 操作系统信息
        :type OsInfo: str
        :param _ProjectId: 主机业务组ID
        :type ProjectId: int
        :param _Tag: 主机标签
注意：此字段可能返回 null，表示取不到有效值。
        :type Tag: list of MachineTag
        :param _Name: 数据库名
        :type Name: str
        :param _Version: 版本
        :type Version: str
        :param _Lang: 语言
        :type Lang: str
        :param _ServiceType: 服务类型
        :type ServiceType: str
        :param _MachineName: 主机名称
        :type MachineName: str
        :param _UpdateTime: 数据更新时间
        :type UpdateTime: str
        :param _FirstTime: 首次采集时间
        :type FirstTime: str
        :param _IsNew: 是否新增[0:否|1:是]
        :type IsNew: int
        :param _MachineExtraInfo:  附加信息
注意：此字段可能返回 null，表示取不到有效值。
        :type MachineExtraInfo: :class:`tencentcloud.cwp.v20180228.models.MachineExtraInfo`
        :param _Path: 应用路径
        :type Path: str
        """
        self._MachineIp = None
        self._MachineWanIp = None
        self._Quuid = None
        self._Uuid = None
        self._OsInfo = None
        self._ProjectId = None
        self._Tag = None
        self._Name = None
        self._Version = None
        self._Lang = None
        self._ServiceType = None
        self._MachineName = None
        self._UpdateTime = None
        self._FirstTime = None
        self._IsNew = None
        self._MachineExtraInfo = None
        self._Path = None

    @property
    def MachineIp(self):
        return self._MachineIp

    @MachineIp.setter
    def MachineIp(self, MachineIp):
        self._MachineIp = MachineIp

    @property
    def MachineWanIp(self):
        return self._MachineWanIp

    @MachineWanIp.setter
    def MachineWanIp(self, MachineWanIp):
        self._MachineWanIp = MachineWanIp

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def OsInfo(self):
        return self._OsInfo

    @OsInfo.setter
    def OsInfo(self, OsInfo):
        self._OsInfo = OsInfo

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Tag(self):
        return self._Tag

    @Tag.setter
    def Tag(self, Tag):
        self._Tag = Tag

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Version(self):
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def Lang(self):
        return self._Lang

    @Lang.setter
    def Lang(self, Lang):
        self._Lang = Lang

    @property
    def ServiceType(self):
        return self._ServiceType

    @ServiceType.setter
    def ServiceType(self, ServiceType):
        self._ServiceType = ServiceType

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def FirstTime(self):
        return self._FirstTime

    @FirstTime.setter
    def FirstTime(self, FirstTime):
        self._FirstTime = FirstTime

    @property
    def IsNew(self):
        return self._IsNew

    @IsNew.setter
    def IsNew(self, IsNew):
        self._IsNew = IsNew

    @property
    def MachineExtraInfo(self):
        return self._MachineExtraInfo

    @MachineExtraInfo.setter
    def MachineExtraInfo(self, MachineExtraInfo):
        self._MachineExtraInfo = MachineExtraInfo

    @property
    def Path(self):
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path


    def _deserialize(self, params):
        self._MachineIp = params.get("MachineIp")
        self._MachineWanIp = params.get("MachineWanIp")
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._OsInfo = params.get("OsInfo")
        self._ProjectId = params.get("ProjectId")
        if params.get("Tag") is not None:
            self._Tag = []
            for item in params.get("Tag"):
                obj = MachineTag()
                obj._deserialize(item)
                self._Tag.append(obj)
        self._Name = params.get("Name")
        self._Version = params.get("Version")
        self._Lang = params.get("Lang")
        self._ServiceType = params.get("ServiceType")
        self._MachineName = params.get("MachineName")
        self._UpdateTime = params.get("UpdateTime")
        self._FirstTime = params.get("FirstTime")
        self._IsNew = params.get("IsNew")
        if params.get("MachineExtraInfo") is not None:
            self._MachineExtraInfo = MachineExtraInfo()
            self._MachineExtraInfo._deserialize(params.get("MachineExtraInfo"))
        self._Path = params.get("Path")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetWebLocationBaseInfo(AbstractModel):
    """资产管理Web站点列表信息

    """

    def __init__(self):
        r"""
        :param _Uuid: 主机Uuid
        :type Uuid: str
        :param _Quuid: 主机Quuid
        :type Quuid: str
        :param _MachineIp: 内网IP
        :type MachineIp: str
        :param _MachineWanIp: 外网IP
        :type MachineWanIp: str
        :param _MachineName: 主机名称
        :type MachineName: str
        :param _OsInfo: 操作系统
        :type OsInfo: str
        :param _Name: 域名
        :type Name: str
        :param _Port: 站点端口
        :type Port: str
        :param _Proto: 站点协议
        :type Proto: str
        :param _ServiceType: 服务类型
        :type ServiceType: str
        :param _PathCount: 站点路经数
        :type PathCount: int
        :param _User: 运行用户
        :type User: str
        :param _MainPath: 主目录
        :type MainPath: str
        :param _MainPathOwner: 主目录所有者
        :type MainPathOwner: str
        :param _Permission: 拥有者权限
        :type Permission: str
        :param _ProjectId: 主机业务组ID
        :type ProjectId: int
        :param _Tag: 主机标签
        :type Tag: list of MachineTag
        :param _Id: Web站点Id
        :type Id: str
        :param _UpdateTime: 数据更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: str
        :param _FirstTime: 首次采集时间
        :type FirstTime: str
        :param _IsNew: 是否新增[0:否|1:是]
注意：此字段可能返回 null，表示取不到有效值。
        :type IsNew: int
        :param _MachineExtraInfo:  附加信息
注意：此字段可能返回 null，表示取不到有效值。
        :type MachineExtraInfo: :class:`tencentcloud.cwp.v20180228.models.MachineExtraInfo`
        """
        self._Uuid = None
        self._Quuid = None
        self._MachineIp = None
        self._MachineWanIp = None
        self._MachineName = None
        self._OsInfo = None
        self._Name = None
        self._Port = None
        self._Proto = None
        self._ServiceType = None
        self._PathCount = None
        self._User = None
        self._MainPath = None
        self._MainPathOwner = None
        self._Permission = None
        self._ProjectId = None
        self._Tag = None
        self._Id = None
        self._UpdateTime = None
        self._FirstTime = None
        self._IsNew = None
        self._MachineExtraInfo = None

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def MachineIp(self):
        return self._MachineIp

    @MachineIp.setter
    def MachineIp(self, MachineIp):
        self._MachineIp = MachineIp

    @property
    def MachineWanIp(self):
        return self._MachineWanIp

    @MachineWanIp.setter
    def MachineWanIp(self, MachineWanIp):
        self._MachineWanIp = MachineWanIp

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def OsInfo(self):
        return self._OsInfo

    @OsInfo.setter
    def OsInfo(self, OsInfo):
        self._OsInfo = OsInfo

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Port(self):
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def Proto(self):
        return self._Proto

    @Proto.setter
    def Proto(self, Proto):
        self._Proto = Proto

    @property
    def ServiceType(self):
        return self._ServiceType

    @ServiceType.setter
    def ServiceType(self, ServiceType):
        self._ServiceType = ServiceType

    @property
    def PathCount(self):
        return self._PathCount

    @PathCount.setter
    def PathCount(self, PathCount):
        self._PathCount = PathCount

    @property
    def User(self):
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def MainPath(self):
        return self._MainPath

    @MainPath.setter
    def MainPath(self, MainPath):
        self._MainPath = MainPath

    @property
    def MainPathOwner(self):
        return self._MainPathOwner

    @MainPathOwner.setter
    def MainPathOwner(self, MainPathOwner):
        self._MainPathOwner = MainPathOwner

    @property
    def Permission(self):
        return self._Permission

    @Permission.setter
    def Permission(self, Permission):
        self._Permission = Permission

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Tag(self):
        return self._Tag

    @Tag.setter
    def Tag(self, Tag):
        self._Tag = Tag

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def FirstTime(self):
        return self._FirstTime

    @FirstTime.setter
    def FirstTime(self, FirstTime):
        self._FirstTime = FirstTime

    @property
    def IsNew(self):
        return self._IsNew

    @IsNew.setter
    def IsNew(self, IsNew):
        self._IsNew = IsNew

    @property
    def MachineExtraInfo(self):
        return self._MachineExtraInfo

    @MachineExtraInfo.setter
    def MachineExtraInfo(self, MachineExtraInfo):
        self._MachineExtraInfo = MachineExtraInfo


    def _deserialize(self, params):
        self._Uuid = params.get("Uuid")
        self._Quuid = params.get("Quuid")
        self._MachineIp = params.get("MachineIp")
        self._MachineWanIp = params.get("MachineWanIp")
        self._MachineName = params.get("MachineName")
        self._OsInfo = params.get("OsInfo")
        self._Name = params.get("Name")
        self._Port = params.get("Port")
        self._Proto = params.get("Proto")
        self._ServiceType = params.get("ServiceType")
        self._PathCount = params.get("PathCount")
        self._User = params.get("User")
        self._MainPath = params.get("MainPath")
        self._MainPathOwner = params.get("MainPathOwner")
        self._Permission = params.get("Permission")
        self._ProjectId = params.get("ProjectId")
        if params.get("Tag") is not None:
            self._Tag = []
            for item in params.get("Tag"):
                obj = MachineTag()
                obj._deserialize(item)
                self._Tag.append(obj)
        self._Id = params.get("Id")
        self._UpdateTime = params.get("UpdateTime")
        self._FirstTime = params.get("FirstTime")
        self._IsNew = params.get("IsNew")
        if params.get("MachineExtraInfo") is not None:
            self._MachineExtraInfo = MachineExtraInfo()
            self._MachineExtraInfo._deserialize(params.get("MachineExtraInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetWebLocationInfo(AbstractModel):
    """资产管理Web站点列表信息

    """

    def __init__(self):
        r"""
        :param _Name: 域名
        :type Name: str
        :param _Port: 站点端口
        :type Port: str
        :param _Proto: 站点协议
        :type Proto: str
        :param _ServiceType: 服务类型
        :type ServiceType: str
        :param _SafeStatus: 安全模块状态：0未启用，1启用，999空，仅nginx
        :type SafeStatus: int
        :param _User: 运行用户
        :type User: str
        :param _MainPath: 主目录
        :type MainPath: str
        :param _Command: 启动命令
        :type Command: str
        :param _Ip: 绑定IP
        :type Ip: str
        :param _UpdateTime: 数据更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: str
        """
        self._Name = None
        self._Port = None
        self._Proto = None
        self._ServiceType = None
        self._SafeStatus = None
        self._User = None
        self._MainPath = None
        self._Command = None
        self._Ip = None
        self._UpdateTime = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Port(self):
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def Proto(self):
        return self._Proto

    @Proto.setter
    def Proto(self, Proto):
        self._Proto = Proto

    @property
    def ServiceType(self):
        return self._ServiceType

    @ServiceType.setter
    def ServiceType(self, ServiceType):
        self._ServiceType = ServiceType

    @property
    def SafeStatus(self):
        return self._SafeStatus

    @SafeStatus.setter
    def SafeStatus(self, SafeStatus):
        self._SafeStatus = SafeStatus

    @property
    def User(self):
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def MainPath(self):
        return self._MainPath

    @MainPath.setter
    def MainPath(self, MainPath):
        self._MainPath = MainPath

    @property
    def Command(self):
        return self._Command

    @Command.setter
    def Command(self, Command):
        self._Command = Command

    @property
    def Ip(self):
        return self._Ip

    @Ip.setter
    def Ip(self, Ip):
        self._Ip = Ip

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Port = params.get("Port")
        self._Proto = params.get("Proto")
        self._ServiceType = params.get("ServiceType")
        self._SafeStatus = params.get("SafeStatus")
        self._User = params.get("User")
        self._MainPath = params.get("MainPath")
        self._Command = params.get("Command")
        self._Ip = params.get("Ip")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetWebServiceBaseInfo(AbstractModel):
    """资源管理Web服务列表信息

    """

    def __init__(self):
        r"""
        :param _MachineIp: 主机内网IP
        :type MachineIp: str
        :param _MachineWanIp: 主机外网IP
        :type MachineWanIp: str
        :param _Quuid: 主机Quuid
        :type Quuid: str
        :param _Uuid: 主机Uuid
        :type Uuid: str
        :param _OsInfo: 操作系统信息
        :type OsInfo: str
        :param _ProjectId: 主机业务组ID
        :type ProjectId: int
        :param _Tag: 主机标签
注意：此字段可能返回 null，表示取不到有效值。
        :type Tag: list of MachineTag
        :param _Name: 数据库名
        :type Name: str
        :param _Version: 版本
        :type Version: str
        :param _BinPath: 二进制路径
        :type BinPath: str
        :param _User: 启动用户
        :type User: str
        :param _InstallPath: 安装路径
        :type InstallPath: str
        :param _ConfigPath: 配置路径
        :type ConfigPath: str
        :param _ProcessCount: 关联进程数
        :type ProcessCount: int
        :param _Id: Web服务ID
        :type Id: str
        :param _MachineName: 主机名称
        :type MachineName: str
        :param _Desc: 描述
        :type Desc: str
        :param _UpdateTime: 数据更新时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UpdateTime: str
        :param _FirstTime: 首次采集时间
        :type FirstTime: str
        :param _IsNew: 是否新增[0:否|1:是]
        :type IsNew: int
        :param _MachineExtraInfo:  附加信息
注意：此字段可能返回 null，表示取不到有效值。
        :type MachineExtraInfo: :class:`tencentcloud.cwp.v20180228.models.MachineExtraInfo`
        """
        self._MachineIp = None
        self._MachineWanIp = None
        self._Quuid = None
        self._Uuid = None
        self._OsInfo = None
        self._ProjectId = None
        self._Tag = None
        self._Name = None
        self._Version = None
        self._BinPath = None
        self._User = None
        self._InstallPath = None
        self._ConfigPath = None
        self._ProcessCount = None
        self._Id = None
        self._MachineName = None
        self._Desc = None
        self._UpdateTime = None
        self._FirstTime = None
        self._IsNew = None
        self._MachineExtraInfo = None

    @property
    def MachineIp(self):
        return self._MachineIp

    @MachineIp.setter
    def MachineIp(self, MachineIp):
        self._MachineIp = MachineIp

    @property
    def MachineWanIp(self):
        return self._MachineWanIp

    @MachineWanIp.setter
    def MachineWanIp(self, MachineWanIp):
        self._MachineWanIp = MachineWanIp

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def OsInfo(self):
        return self._OsInfo

    @OsInfo.setter
    def OsInfo(self, OsInfo):
        self._OsInfo = OsInfo

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def Tag(self):
        return self._Tag

    @Tag.setter
    def Tag(self, Tag):
        self._Tag = Tag

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Version(self):
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def BinPath(self):
        return self._BinPath

    @BinPath.setter
    def BinPath(self, BinPath):
        self._BinPath = BinPath

    @property
    def User(self):
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def InstallPath(self):
        return self._InstallPath

    @InstallPath.setter
    def InstallPath(self, InstallPath):
        self._InstallPath = InstallPath

    @property
    def ConfigPath(self):
        return self._ConfigPath

    @ConfigPath.setter
    def ConfigPath(self, ConfigPath):
        self._ConfigPath = ConfigPath

    @property
    def ProcessCount(self):
        return self._ProcessCount

    @ProcessCount.setter
    def ProcessCount(self, ProcessCount):
        self._ProcessCount = ProcessCount

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def Desc(self):
        return self._Desc

    @Desc.setter
    def Desc(self, Desc):
        self._Desc = Desc

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def FirstTime(self):
        return self._FirstTime

    @FirstTime.setter
    def FirstTime(self, FirstTime):
        self._FirstTime = FirstTime

    @property
    def IsNew(self):
        return self._IsNew

    @IsNew.setter
    def IsNew(self, IsNew):
        self._IsNew = IsNew

    @property
    def MachineExtraInfo(self):
        return self._MachineExtraInfo

    @MachineExtraInfo.setter
    def MachineExtraInfo(self, MachineExtraInfo):
        self._MachineExtraInfo = MachineExtraInfo


    def _deserialize(self, params):
        self._MachineIp = params.get("MachineIp")
        self._MachineWanIp = params.get("MachineWanIp")
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._OsInfo = params.get("OsInfo")
        self._ProjectId = params.get("ProjectId")
        if params.get("Tag") is not None:
            self._Tag = []
            for item in params.get("Tag"):
                obj = MachineTag()
                obj._deserialize(item)
                self._Tag.append(obj)
        self._Name = params.get("Name")
        self._Version = params.get("Version")
        self._BinPath = params.get("BinPath")
        self._User = params.get("User")
        self._InstallPath = params.get("InstallPath")
        self._ConfigPath = params.get("ConfigPath")
        self._ProcessCount = params.get("ProcessCount")
        self._Id = params.get("Id")
        self._MachineName = params.get("MachineName")
        self._Desc = params.get("Desc")
        self._UpdateTime = params.get("UpdateTime")
        self._FirstTime = params.get("FirstTime")
        self._IsNew = params.get("IsNew")
        if params.get("MachineExtraInfo") is not None:
            self._MachineExtraInfo = MachineExtraInfo()
            self._MachineExtraInfo._deserialize(params.get("MachineExtraInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BanWhiteListDetail(AbstractModel):
    """阻断白名单展示列表，包含了机器的信息

    """

    def __init__(self):
        r"""
        :param _Id: 白名单ID
        :type Id: str
        :param _Remark: 白名单别名
        :type Remark: str
        :param _SrcIp: 阻断来源IP
        :type SrcIp: str
        :param _ModifyTime: 修改白名单时间
        :type ModifyTime: str
        :param _CreateTime: 创建白名单时间
        :type CreateTime: str
        :param _IsGlobal: 白名单是否全局
        :type IsGlobal: bool
        :param _Quuid: 机器的UUID
        :type Quuid: str
        :param _Uuid: 主机安全程序的UUID
        :type Uuid: str
        :param _MachineIp: 机器IP
        :type MachineIp: str
        :param _MachineName: 机器名称
        :type MachineName: str
        """
        self._Id = None
        self._Remark = None
        self._SrcIp = None
        self._ModifyTime = None
        self._CreateTime = None
        self._IsGlobal = None
        self._Quuid = None
        self._Uuid = None
        self._MachineIp = None
        self._MachineName = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Remark(self):
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def SrcIp(self):
        return self._SrcIp

    @SrcIp.setter
    def SrcIp(self, SrcIp):
        self._SrcIp = SrcIp

    @property
    def ModifyTime(self):
        return self._ModifyTime

    @ModifyTime.setter
    def ModifyTime(self, ModifyTime):
        self._ModifyTime = ModifyTime

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def IsGlobal(self):
        return self._IsGlobal

    @IsGlobal.setter
    def IsGlobal(self, IsGlobal):
        self._IsGlobal = IsGlobal

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def MachineIp(self):
        return self._MachineIp

    @MachineIp.setter
    def MachineIp(self, MachineIp):
        self._MachineIp = MachineIp

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Remark = params.get("Remark")
        self._SrcIp = params.get("SrcIp")
        self._ModifyTime = params.get("ModifyTime")
        self._CreateTime = params.get("CreateTime")
        self._IsGlobal = params.get("IsGlobal")
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._MachineIp = params.get("MachineIp")
        self._MachineName = params.get("MachineName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaselineBasicInfo(AbstractModel):
    """基线基础信息

    """

    def __init__(self):
        r"""
        :param _Name: 基线名称
注意：此字段可能返回 null，表示取不到有效值。
        :type Name: str
        :param _BaselineId: 基线id
注意：此字段可能返回 null，表示取不到有效值。
        :type BaselineId: int
        :param _ParentId: 父级id
注意：此字段可能返回 null，表示取不到有效值。
        :type ParentId: int
        """
        self._Name = None
        self._BaselineId = None
        self._ParentId = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def BaselineId(self):
        return self._BaselineId

    @BaselineId.setter
    def BaselineId(self, BaselineId):
        self._BaselineId = BaselineId

    @property
    def ParentId(self):
        return self._ParentId

    @ParentId.setter
    def ParentId(self, ParentId):
        self._ParentId = ParentId


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._BaselineId = params.get("BaselineId")
        self._ParentId = params.get("ParentId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaselineCategory(AbstractModel):
    """基线规则或项的分类

    """

    def __init__(self):
        r"""
        :param _CategoryId: 分类Id
        :type CategoryId: int
        :param _CategoryName: 分类名称
        :type CategoryName: str
        :param _ParentCategoryId: 父分类ID,如果为0则没有父分类
        :type ParentCategoryId: int
        """
        self._CategoryId = None
        self._CategoryName = None
        self._ParentCategoryId = None

    @property
    def CategoryId(self):
        return self._CategoryId

    @CategoryId.setter
    def CategoryId(self, CategoryId):
        self._CategoryId = CategoryId

    @property
    def CategoryName(self):
        return self._CategoryName

    @CategoryName.setter
    def CategoryName(self, CategoryName):
        self._CategoryName = CategoryName

    @property
    def ParentCategoryId(self):
        return self._ParentCategoryId

    @ParentCategoryId.setter
    def ParentCategoryId(self, ParentCategoryId):
        self._ParentCategoryId = ParentCategoryId


    def _deserialize(self, params):
        self._CategoryId = params.get("CategoryId")
        self._CategoryName = params.get("CategoryName")
        self._ParentCategoryId = params.get("ParentCategoryId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaselineCustomRuleIdName(AbstractModel):
    """基线自定规则ID和名字

    """

    def __init__(self):
        r"""
        :param _RuleId: 自定义规则ID　
注意：此字段可能返回 null，表示取不到有效值。
        :type RuleId: int
        :param _RuleName: 自定义规则名字
注意：此字段可能返回 null，表示取不到有效值。
        :type RuleName: str
        """
        self._RuleId = None
        self._RuleName = None

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def RuleName(self):
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        self._RuleName = params.get("RuleName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaselineDetail(AbstractModel):
    """基线详情

    """

    def __init__(self):
        r"""
        :param _Description: 基线描述
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        :param _Level: 危害等级
注意：此字段可能返回 null，表示取不到有效值。
        :type Level: int
        :param _PackageName: package名
注意：此字段可能返回 null，表示取不到有效值。
        :type PackageName: str
        :param _ParentId: 父级id
注意：此字段可能返回 null，表示取不到有效值。
        :type ParentId: int
        :param _Name: 基线名
注意：此字段可能返回 null，表示取不到有效值。
        :type Name: str
        """
        self._Description = None
        self._Level = None
        self._PackageName = None
        self._ParentId = None
        self._Name = None

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Level(self):
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level

    @property
    def PackageName(self):
        return self._PackageName

    @PackageName.setter
    def PackageName(self, PackageName):
        self._PackageName = PackageName

    @property
    def ParentId(self):
        return self._ParentId

    @ParentId.setter
    def ParentId(self, ParentId):
        self._ParentId = ParentId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Description = params.get("Description")
        self._Level = params.get("Level")
        self._PackageName = params.get("PackageName")
        self._ParentId = params.get("ParentId")
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaselineDetectParam(AbstractModel):
    """基线扫描参数

    """

    def __init__(self):
        r"""
        :param _PolicyIds: 检测的策略集合
        :type PolicyIds: list of int
        :param _RuleIds: 检测的规则集合
        :type RuleIds: list of int
        :param _ItemIds: 检测项集合
        :type ItemIds: list of int
        :param _HostIds: 检测的主机ID集合
        :type HostIds: list of str
        """
        self._PolicyIds = None
        self._RuleIds = None
        self._ItemIds = None
        self._HostIds = None

    @property
    def PolicyIds(self):
        return self._PolicyIds

    @PolicyIds.setter
    def PolicyIds(self, PolicyIds):
        self._PolicyIds = PolicyIds

    @property
    def RuleIds(self):
        return self._RuleIds

    @RuleIds.setter
    def RuleIds(self, RuleIds):
        self._RuleIds = RuleIds

    @property
    def ItemIds(self):
        return self._ItemIds

    @ItemIds.setter
    def ItemIds(self, ItemIds):
        self._ItemIds = ItemIds

    @property
    def HostIds(self):
        return self._HostIds

    @HostIds.setter
    def HostIds(self, HostIds):
        self._HostIds = HostIds


    def _deserialize(self, params):
        self._PolicyIds = params.get("PolicyIds")
        self._RuleIds = params.get("RuleIds")
        self._ItemIds = params.get("ItemIds")
        self._HostIds = params.get("HostIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaselineDownload(AbstractModel):
    """基线导出结果下载

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务Id
        :type TaskId: int
        :param _TaskName: 任务名称
        :type TaskName: str
        :param _Status: 状态0:未完成 1:完成
        :type Status: int
        :param _StartTime: 开始时间
        :type StartTime: str
        :param _EndTime: 完成时间
        :type EndTime: str
        :param _DownloadUrl: 下载地址
        :type DownloadUrl: str
        """
        self._TaskId = None
        self._TaskName = None
        self._Status = None
        self._StartTime = None
        self._EndTime = None
        self._DownloadUrl = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TaskName(self):
        return self._TaskName

    @TaskName.setter
    def TaskName(self, TaskName):
        self._TaskName = TaskName

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._TaskName = params.get("TaskName")
        self._Status = params.get("Status")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._DownloadUrl = params.get("DownloadUrl")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaselineEffectHost(AbstractModel):
    """基线影响主机信息

    """

    def __init__(self):
        r"""
        :param _PassCount: 通过项
注意：此字段可能返回 null，表示取不到有效值。
        :type PassCount: int
        :param _FailCount: 风险项
注意：此字段可能返回 null，表示取不到有效值。
        :type FailCount: int
        :param _FirstScanTime: 首次检测事件
注意：此字段可能返回 null，表示取不到有效值。
        :type FirstScanTime: str
        :param _LastScanTime: 最后检测时间
注意：此字段可能返回 null，表示取不到有效值。
        :type LastScanTime: str
        :param _Status: 风险项处理状态状态：0-未通过，1-通过
注意：此字段可能返回 null，表示取不到有效值。
        :type Status: int
        :param _Quuid: 主机Quuid
注意：此字段可能返回 null，表示取不到有效值。
        :type Quuid: str
        :param _HostIp: 主机IP
注意：此字段可能返回 null，表示取不到有效值。
        :type HostIp: str
        :param _AliasName: 主机别名
注意：此字段可能返回 null，表示取不到有效值。
        :type AliasName: str
        :param _Uuid: 主机Uuid
注意：此字段可能返回 null，表示取不到有效值。
        :type Uuid: str
        :param _MaxStatus: 检测中状态
注意：此字段可能返回 null，表示取不到有效值。
        :type MaxStatus: int
        """
        self._PassCount = None
        self._FailCount = None
        self._FirstScanTime = None
        self._LastScanTime = None
        self._Status = None
        self._Quuid = None
        self._HostIp = None
        self._AliasName = None
        self._Uuid = None
        self._MaxStatus = None

    @property
    def PassCount(self):
        return self._PassCount

    @PassCount.setter
    def PassCount(self, PassCount):
        self._PassCount = PassCount

    @property
    def FailCount(self):
        return self._FailCount

    @FailCount.setter
    def FailCount(self, FailCount):
        self._FailCount = FailCount

    @property
    def FirstScanTime(self):
        return self._FirstScanTime

    @FirstScanTime.setter
    def FirstScanTime(self, FirstScanTime):
        self._FirstScanTime = FirstScanTime

    @property
    def LastScanTime(self):
        return self._LastScanTime

    @LastScanTime.setter
    def LastScanTime(self, LastScanTime):
        self._LastScanTime = LastScanTime

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def HostIp(self):
        return self._HostIp

    @HostIp.setter
    def HostIp(self, HostIp):
        self._HostIp = HostIp

    @property
    def AliasName(self):
        return self._AliasName

    @AliasName.setter
    def AliasName(self, AliasName):
        self._AliasName = AliasName

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def MaxStatus(self):
        return self._MaxStatus

    @MaxStatus.setter
    def MaxStatus(self, MaxStatus):
        self._MaxStatus = MaxStatus


    def _deserialize(self, params):
        self._PassCount = params.get("PassCount")
        self._FailCount = params.get("FailCount")
        self._FirstScanTime = params.get("FirstScanTime")
        self._LastScanTime = params.get("LastScanTime")
        self._Status = params.get("Status")
        self._Quuid = params.get("Quuid")
        self._HostIp = params.get("HostIp")
        self._AliasName = params.get("AliasName")
        self._Uuid = params.get("Uuid")
        self._MaxStatus = params.get("MaxStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaselineEventLevelInfo(AbstractModel):
    """服务器风险Top的主机信息

    """

    def __init__(self):
        r"""
        :param _EventLevel: 危害等级：1-低危；2-中危；3-高危；4-严重
注意：此字段可能返回 null，表示取不到有效值。
        :type EventLevel: int
        :param _EventCount: 漏洞数量
注意：此字段可能返回 null，表示取不到有效值。
        :type EventCount: int
        """
        self._EventLevel = None
        self._EventCount = None

    @property
    def EventLevel(self):
        return self._EventLevel

    @EventLevel.setter
    def EventLevel(self, EventLevel):
        self._EventLevel = EventLevel

    @property
    def EventCount(self):
        return self._EventCount

    @EventCount.setter
    def EventCount(self, EventCount):
        self._EventCount = EventCount


    def _deserialize(self, params):
        self._EventLevel = params.get("EventLevel")
        self._EventCount = params.get("EventCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaselineFix(AbstractModel):
    """基线密码修复

    """

    def __init__(self):
        r"""
        :param _ItemName: 修复项名称
        :type ItemName: str
        :param _HostIp: 主机Ip
        :type HostIp: str
        :param _CreateTime: 首次检测时间
        :type CreateTime: str
        :param _ModifyTime: 最后检测时间
        :type ModifyTime: str
        :param _FixTime: 修复时间
        :type FixTime: str
        :param _Id: 基线检测项结果ID
        :type Id: int
        :param _MachineExtraInfo: 主机额外信息
注意：此字段可能返回 null，表示取不到有效值。
        :type MachineExtraInfo: :class:`tencentcloud.cwp.v20180228.models.MachineExtraInfo`
        """
        self._ItemName = None
        self._HostIp = None
        self._CreateTime = None
        self._ModifyTime = None
        self._FixTime = None
        self._Id = None
        self._MachineExtraInfo = None

    @property
    def ItemName(self):
        return self._ItemName

    @ItemName.setter
    def ItemName(self, ItemName):
        self._ItemName = ItemName

    @property
    def HostIp(self):
        return self._HostIp

    @HostIp.setter
    def HostIp(self, HostIp):
        self._HostIp = HostIp

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ModifyTime(self):
        return self._ModifyTime

    @ModifyTime.setter
    def ModifyTime(self, ModifyTime):
        self._ModifyTime = ModifyTime

    @property
    def FixTime(self):
        return self._FixTime

    @FixTime.setter
    def FixTime(self, FixTime):
        self._FixTime = FixTime

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def MachineExtraInfo(self):
        return self._MachineExtraInfo

    @MachineExtraInfo.setter
    def MachineExtraInfo(self, MachineExtraInfo):
        self._MachineExtraInfo = MachineExtraInfo


    def _deserialize(self, params):
        self._ItemName = params.get("ItemName")
        self._HostIp = params.get("HostIp")
        self._CreateTime = params.get("CreateTime")
        self._ModifyTime = params.get("ModifyTime")
        self._FixTime = params.get("FixTime")
        self._Id = params.get("Id")
        if params.get("MachineExtraInfo") is not None:
            self._MachineExtraInfo = MachineExtraInfo()
            self._MachineExtraInfo._deserialize(params.get("MachineExtraInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaselineHost(AbstractModel):
    """基线主机信息

    """

    def __init__(self):
        r"""
        :param _HostId: 主机Id
        :type HostId: str
        :param _HostName: 主机名称
注意：此字段可能返回 null，表示取不到有效值。
        :type HostName: str
        :param _HostTag: 主机标签
注意：此字段可能返回 null，表示取不到有效值。
        :type HostTag: str
        :param _HostIp: 内网Ip
注意：此字段可能返回 null，表示取不到有效值。
        :type HostIp: str
        :param _WanIp: 外网Ip
注意：此字段可能返回 null，表示取不到有效值。
        :type WanIp: str
        :param _MachineExtraInfo: 主机额外信息
注意：此字段可能返回 null，表示取不到有效值。
        :type MachineExtraInfo: :class:`tencentcloud.cwp.v20180228.models.MachineExtraInfo`
        """
        self._HostId = None
        self._HostName = None
        self._HostTag = None
        self._HostIp = None
        self._WanIp = None
        self._MachineExtraInfo = None

    @property
    def HostId(self):
        return self._HostId

    @HostId.setter
    def HostId(self, HostId):
        self._HostId = HostId

    @property
    def HostName(self):
        return self._HostName

    @HostName.setter
    def HostName(self, HostName):
        self._HostName = HostName

    @property
    def HostTag(self):
        return self._HostTag

    @HostTag.setter
    def HostTag(self, HostTag):
        self._HostTag = HostTag

    @property
    def HostIp(self):
        return self._HostIp

    @HostIp.setter
    def HostIp(self, HostIp):
        self._HostIp = HostIp

    @property
    def WanIp(self):
        return self._WanIp

    @WanIp.setter
    def WanIp(self, WanIp):
        self._WanIp = WanIp

    @property
    def MachineExtraInfo(self):
        return self._MachineExtraInfo

    @MachineExtraInfo.setter
    def MachineExtraInfo(self, MachineExtraInfo):
        self._MachineExtraInfo = MachineExtraInfo


    def _deserialize(self, params):
        self._HostId = params.get("HostId")
        self._HostName = params.get("HostName")
        self._HostTag = params.get("HostTag")
        self._HostIp = params.get("HostIp")
        self._WanIp = params.get("WanIp")
        if params.get("MachineExtraInfo") is not None:
            self._MachineExtraInfo = MachineExtraInfo()
            self._MachineExtraInfo._deserialize(params.get("MachineExtraInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaselineHostDetect(AbstractModel):
    """基线主机检测

    """

    def __init__(self):
        r"""
        :param _HostId: 主机Id
        :type HostId: str
        :param _HostIp: 内网Ip
        :type HostIp: str
        :param _HostName: 主机名称
        :type HostName: str
        :param _WanIp: 外网Ip
        :type WanIp: str
        :param _DetectStatus: 0:未通过 1:忽略 3:通过 5:检测中
        :type DetectStatus: int
        :param _PassedItemCount: 检测通过数
        :type PassedItemCount: int
        :param _ItemCount: 关联检测项数
        :type ItemCount: int
        :param _NotPassedItemCount: 检测未通过数
        :type NotPassedItemCount: int
        :param _FirstTime: 首次检测时间
        :type FirstTime: str
        :param _LastTime: 最后检测时间
        :type LastTime: str
        :param _Uuid: 主机安全UUID
注意：此字段可能返回 null，表示取不到有效值。
        :type Uuid: str
        :param _MachineExtraInfo: 主机额外信息
注意：此字段可能返回 null，表示取不到有效值。
        :type MachineExtraInfo: :class:`tencentcloud.cwp.v20180228.models.MachineExtraInfo`
        """
        self._HostId = None
        self._HostIp = None
        self._HostName = None
        self._WanIp = None
        self._DetectStatus = None
        self._PassedItemCount = None
        self._ItemCount = None
        self._NotPassedItemCount = None
        self._FirstTime = None
        self._LastTime = None
        self._Uuid = None
        self._MachineExtraInfo = None

    @property
    def HostId(self):
        return self._HostId

    @HostId.setter
    def HostId(self, HostId):
        self._HostId = HostId

    @property
    def HostIp(self):
        return self._HostIp

    @HostIp.setter
    def HostIp(self, HostIp):
        self._HostIp = HostIp

    @property
    def HostName(self):
        return self._HostName

    @HostName.setter
    def HostName(self, HostName):
        self._HostName = HostName

    @property
    def WanIp(self):
        return self._WanIp

    @WanIp.setter
    def WanIp(self, WanIp):
        self._WanIp = WanIp

    @property
    def DetectStatus(self):
        return self._DetectStatus

    @DetectStatus.setter
    def DetectStatus(self, DetectStatus):
        self._DetectStatus = DetectStatus

    @property
    def PassedItemCount(self):
        return self._PassedItemCount

    @PassedItemCount.setter
    def PassedItemCount(self, PassedItemCount):
        self._PassedItemCount = PassedItemCount

    @property
    def ItemCount(self):
        return self._ItemCount

    @ItemCount.setter
    def ItemCount(self, ItemCount):
        self._ItemCount = ItemCount

    @property
    def NotPassedItemCount(self):
        return self._NotPassedItemCount

    @NotPassedItemCount.setter
    def NotPassedItemCount(self, NotPassedItemCount):
        self._NotPassedItemCount = NotPassedItemCount

    @property
    def FirstTime(self):
        return self._FirstTime

    @FirstTime.setter
    def FirstTime(self, FirstTime):
        self._FirstTime = FirstTime

    @property
    def LastTime(self):
        return self._LastTime

    @LastTime.setter
    def LastTime(self, LastTime):
        self._LastTime = LastTime

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def MachineExtraInfo(self):
        return self._MachineExtraInfo

    @MachineExtraInfo.setter
    def MachineExtraInfo(self, MachineExtraInfo):
        self._MachineExtraInfo = MachineExtraInfo


    def _deserialize(self, params):
        self._HostId = params.get("HostId")
        self._HostIp = params.get("HostIp")
        self._HostName = params.get("HostName")
        self._WanIp = params.get("WanIp")
        self._DetectStatus = params.get("DetectStatus")
        self._PassedItemCount = params.get("PassedItemCount")
        self._ItemCount = params.get("ItemCount")
        self._NotPassedItemCount = params.get("NotPassedItemCount")
        self._FirstTime = params.get("FirstTime")
        self._LastTime = params.get("LastTime")
        self._Uuid = params.get("Uuid")
        if params.get("MachineExtraInfo") is not None:
            self._MachineExtraInfo = MachineExtraInfo()
            self._MachineExtraInfo._deserialize(params.get("MachineExtraInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaselineHostTopList(AbstractModel):
    """基线影响服务器列表数据

    """

    def __init__(self):
        r"""
        :param _EventLevelList: 事件等级与次数列表
注意：此字段可能返回 null，表示取不到有效值。
        :type EventLevelList: list of BaselineEventLevelInfo
        :param _HostName: 主机名称
注意：此字段可能返回 null，表示取不到有效值。
        :type HostName: str
        :param _Quuid: 主机Quuid
注意：此字段可能返回 null，表示取不到有效值。
        :type Quuid: str
        :param _Score: 计算权重的分数
注意：此字段可能返回 null，表示取不到有效值。
        :type Score: int
        """
        self._EventLevelList = None
        self._HostName = None
        self._Quuid = None
        self._Score = None

    @property
    def EventLevelList(self):
        return self._EventLevelList

    @EventLevelList.setter
    def EventLevelList(self, EventLevelList):
        self._EventLevelList = EventLevelList

    @property
    def HostName(self):
        return self._HostName

    @HostName.setter
    def HostName(self, HostName):
        self._HostName = HostName

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Score(self):
        return self._Score

    @Score.setter
    def Score(self, Score):
        self._Score = Score


    def _deserialize(self, params):
        if params.get("EventLevelList") is not None:
            self._EventLevelList = []
            for item in params.get("EventLevelList"):
                obj = BaselineEventLevelInfo()
                obj._deserialize(item)
                self._EventLevelList.append(obj)
        self._HostName = params.get("HostName")
        self._Quuid = params.get("Quuid")
        self._Score = params.get("Score")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaselineInfo(AbstractModel):
    """基线信息

    """

    def __init__(self):
        r"""
        :param _Name: 基线名
注意：此字段可能返回 null，表示取不到有效值。
        :type Name: str
        :param _Level: 危害等级：1-低危；2-中危；3-高危；4-严重
注意：此字段可能返回 null，表示取不到有效值。
        :type Level: int
        :param _RuleCount: 检测项数量
注意：此字段可能返回 null，表示取不到有效值。
        :type RuleCount: int
        :param _HostCount: 影响服务器数量
注意：此字段可能返回 null，表示取不到有效值。
        :type HostCount: int
        :param _Status: 通过状态:0:未通过,1:已通过
注意：此字段可能返回 null，表示取不到有效值。
        :type Status: int
        :param _CategoryId: 基线id
注意：此字段可能返回 null，表示取不到有效值。
        :type CategoryId: int
        :param _LastScanTime: 最后检测时间
注意：此字段可能返回 null，表示取不到有效值。
        :type LastScanTime: str
        :param _MaxStatus: 检测中状态: 5
注意：此字段可能返回 null，表示取不到有效值。
        :type MaxStatus: int
        :param _BaselineFailCount: 基线风险项
注意：此字段可能返回 null，表示取不到有效值。
        :type BaselineFailCount: int
        """
        self._Name = None
        self._Level = None
        self._RuleCount = None
        self._HostCount = None
        self._Status = None
        self._CategoryId = None
        self._LastScanTime = None
        self._MaxStatus = None
        self._BaselineFailCount = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Level(self):
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level

    @property
    def RuleCount(self):
        return self._RuleCount

    @RuleCount.setter
    def RuleCount(self, RuleCount):
        self._RuleCount = RuleCount

    @property
    def HostCount(self):
        return self._HostCount

    @HostCount.setter
    def HostCount(self, HostCount):
        self._HostCount = HostCount

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def CategoryId(self):
        return self._CategoryId

    @CategoryId.setter
    def CategoryId(self, CategoryId):
        self._CategoryId = CategoryId

    @property
    def LastScanTime(self):
        return self._LastScanTime

    @LastScanTime.setter
    def LastScanTime(self, LastScanTime):
        self._LastScanTime = LastScanTime

    @property
    def MaxStatus(self):
        return self._MaxStatus

    @MaxStatus.setter
    def MaxStatus(self, MaxStatus):
        self._MaxStatus = MaxStatus

    @property
    def BaselineFailCount(self):
        return self._BaselineFailCount

    @BaselineFailCount.setter
    def BaselineFailCount(self, BaselineFailCount):
        self._BaselineFailCount = BaselineFailCount


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Level = params.get("Level")
        self._RuleCount = params.get("RuleCount")
        self._HostCount = params.get("HostCount")
        self._Status = params.get("Status")
        self._CategoryId = params.get("CategoryId")
        self._LastScanTime = params.get("LastScanTime")
        self._MaxStatus = params.get("MaxStatus")
        self._BaselineFailCount = params.get("BaselineFailCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaselineItem(AbstractModel):
    """基线项

    """

    def __init__(self):
        r"""
        :param _ItemId: 项Id
        :type ItemId: int
        :param _ItemName: 项名称
        :type ItemName: str
        :param _CategoryId: 检测项分类
        :type CategoryId: int
        :param _ItemDesc: 项描述
        :type ItemDesc: str
        :param _FixMethod: 修复方法
        :type FixMethod: str
        :param _RuleName: 所属规则
        :type RuleName: str
        :param _DetectResultDesc: 检测结果描述
注意：此字段可能返回 null，表示取不到有效值。
        :type DetectResultDesc: str
        :param _Level: 危险等级
注意：此字段可能返回 null，表示取不到有效值。
        :type Level: int
        :param _DetectStatus: 检测状态：0 未通过，1：忽略，3：通过，5：检测中
注意：此字段可能返回 null，表示取不到有效值。
        :type DetectStatus: int
        :param _HostId: 主机ID
注意：此字段可能返回 null，表示取不到有效值。
        :type HostId: str
        :param _HostName: 主机名
注意：此字段可能返回 null，表示取不到有效值。
        :type HostName: str
        :param _HostIp: 主机IP
注意：此字段可能返回 null，表示取不到有效值。
        :type HostIp: str
        :param _WanIp: 外网IP
注意：此字段可能返回 null，表示取不到有效值。
        :type WanIp: str
        :param _FirstTime: 第一次出现时间
注意：此字段可能返回 null，表示取不到有效值。
        :type FirstTime: str
        :param _LastTime: 最近出现时间
注意：此字段可能返回 null，表示取不到有效值。
        :type LastTime: str
        :param _CanBeFixed: 是否可以修复
注意：此字段可能返回 null，表示取不到有效值。
        :type CanBeFixed: int
        :param _Uuid: 主机安全uuid
注意：此字段可能返回 null，表示取不到有效值。
        :type Uuid: str
        :param _MachineExtraInfo: 主机额外信息
注意：此字段可能返回 null，表示取不到有效值。
        :type MachineExtraInfo: :class:`tencentcloud.cwp.v20180228.models.MachineExtraInfo`
        """
        self._ItemId = None
        self._ItemName = None
        self._CategoryId = None
        self._ItemDesc = None
        self._FixMethod = None
        self._RuleName = None
        self._DetectResultDesc = None
        self._Level = None
        self._DetectStatus = None
        self._HostId = None
        self._HostName = None
        self._HostIp = None
        self._WanIp = None
        self._FirstTime = None
        self._LastTime = None
        self._CanBeFixed = None
        self._Uuid = None
        self._MachineExtraInfo = None

    @property
    def ItemId(self):
        return self._ItemId

    @ItemId.setter
    def ItemId(self, ItemId):
        self._ItemId = ItemId

    @property
    def ItemName(self):
        return self._ItemName

    @ItemName.setter
    def ItemName(self, ItemName):
        self._ItemName = ItemName

    @property
    def CategoryId(self):
        return self._CategoryId

    @CategoryId.setter
    def CategoryId(self, CategoryId):
        self._CategoryId = CategoryId

    @property
    def ItemDesc(self):
        return self._ItemDesc

    @ItemDesc.setter
    def ItemDesc(self, ItemDesc):
        self._ItemDesc = ItemDesc

    @property
    def FixMethod(self):
        return self._FixMethod

    @FixMethod.setter
    def FixMethod(self, FixMethod):
        self._FixMethod = FixMethod

    @property
    def RuleName(self):
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName

    @property
    def DetectResultDesc(self):
        return self._DetectResultDesc

    @DetectResultDesc.setter
    def DetectResultDesc(self, DetectResultDesc):
        self._DetectResultDesc = DetectResultDesc

    @property
    def Level(self):
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level

    @property
    def DetectStatus(self):
        return self._DetectStatus

    @DetectStatus.setter
    def DetectStatus(self, DetectStatus):
        self._DetectStatus = DetectStatus

    @property
    def HostId(self):
        return self._HostId

    @HostId.setter
    def HostId(self, HostId):
        self._HostId = HostId

    @property
    def HostName(self):
        return self._HostName

    @HostName.setter
    def HostName(self, HostName):
        self._HostName = HostName

    @property
    def HostIp(self):
        return self._HostIp

    @HostIp.setter
    def HostIp(self, HostIp):
        self._HostIp = HostIp

    @property
    def WanIp(self):
        return self._WanIp

    @WanIp.setter
    def WanIp(self, WanIp):
        self._WanIp = WanIp

    @property
    def FirstTime(self):
        return self._FirstTime

    @FirstTime.setter
    def FirstTime(self, FirstTime):
        self._FirstTime = FirstTime

    @property
    def LastTime(self):
        return self._LastTime

    @LastTime.setter
    def LastTime(self, LastTime):
        self._LastTime = LastTime

    @property
    def CanBeFixed(self):
        return self._CanBeFixed

    @CanBeFixed.setter
    def CanBeFixed(self, CanBeFixed):
        self._CanBeFixed = CanBeFixed

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def MachineExtraInfo(self):
        return self._MachineExtraInfo

    @MachineExtraInfo.setter
    def MachineExtraInfo(self, MachineExtraInfo):
        self._MachineExtraInfo = MachineExtraInfo


    def _deserialize(self, params):
        self._ItemId = params.get("ItemId")
        self._ItemName = params.get("ItemName")
        self._CategoryId = params.get("CategoryId")
        self._ItemDesc = params.get("ItemDesc")
        self._FixMethod = params.get("FixMethod")
        self._RuleName = params.get("RuleName")
        self._DetectResultDesc = params.get("DetectResultDesc")
        self._Level = params.get("Level")
        self._DetectStatus = params.get("DetectStatus")
        self._HostId = params.get("HostId")
        self._HostName = params.get("HostName")
        self._HostIp = params.get("HostIp")
        self._WanIp = params.get("WanIp")
        self._FirstTime = params.get("FirstTime")
        self._LastTime = params.get("LastTime")
        self._CanBeFixed = params.get("CanBeFixed")
        self._Uuid = params.get("Uuid")
        if params.get("MachineExtraInfo") is not None:
            self._MachineExtraInfo = MachineExtraInfo()
            self._MachineExtraInfo._deserialize(params.get("MachineExtraInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaselineItemDetect(AbstractModel):
    """基线检测项

    """

    def __init__(self):
        r"""
        :param _ItemId: 项Id
注意：此字段可能返回 null，表示取不到有效值。
        :type ItemId: int
        :param _ItemName: 项名称
注意：此字段可能返回 null，表示取不到有效值。
        :type ItemName: str
        :param _ItemDesc: 项描述
注意：此字段可能返回 null，表示取不到有效值。
        :type ItemDesc: str
        :param _FixMethod: 修复方法
注意：此字段可能返回 null，表示取不到有效值。
        :type FixMethod: str
        :param _RuleName: 所属规则
注意：此字段可能返回 null，表示取不到有效值。
        :type RuleName: str
        :param _DetectStatus: 0:未通过 1:忽略 3:通过 5:检测中
注意：此字段可能返回 null，表示取不到有效值。
        :type DetectStatus: int
        :param _Level: 风险等级
注意：此字段可能返回 null，表示取不到有效值。
        :type Level: int
        :param _HostCount: 影响服务器数
注意：此字段可能返回 null，表示取不到有效值。
        :type HostCount: int
        :param _FirstTime: 首次检测时间
注意：此字段可能返回 null，表示取不到有效值。
        :type FirstTime: str
        :param _LastTime: 最后检测时间
注意：此字段可能返回 null，表示取不到有效值。
        :type LastTime: str
        :param _DetectResult: 检测结果,Json字符串
注意：此字段可能返回 null，表示取不到有效值。
        :type DetectResult: str
        :param _RuleId: 所属规则ID
注意：此字段可能返回 null，表示取不到有效值。
        :type RuleId: int
        :param _PassedHostCount: 通过的服务器数
注意：此字段可能返回 null，表示取不到有效值。
        :type PassedHostCount: int
        :param _NotPassedHostCount: 未通过的服务器数
注意：此字段可能返回 null，表示取不到有效值。
        :type NotPassedHostCount: int
        """
        self._ItemId = None
        self._ItemName = None
        self._ItemDesc = None
        self._FixMethod = None
        self._RuleName = None
        self._DetectStatus = None
        self._Level = None
        self._HostCount = None
        self._FirstTime = None
        self._LastTime = None
        self._DetectResult = None
        self._RuleId = None
        self._PassedHostCount = None
        self._NotPassedHostCount = None

    @property
    def ItemId(self):
        return self._ItemId

    @ItemId.setter
    def ItemId(self, ItemId):
        self._ItemId = ItemId

    @property
    def ItemName(self):
        return self._ItemName

    @ItemName.setter
    def ItemName(self, ItemName):
        self._ItemName = ItemName

    @property
    def ItemDesc(self):
        return self._ItemDesc

    @ItemDesc.setter
    def ItemDesc(self, ItemDesc):
        self._ItemDesc = ItemDesc

    @property
    def FixMethod(self):
        return self._FixMethod

    @FixMethod.setter
    def FixMethod(self, FixMethod):
        self._FixMethod = FixMethod

    @property
    def RuleName(self):
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName

    @property
    def DetectStatus(self):
        return self._DetectStatus

    @DetectStatus.setter
    def DetectStatus(self, DetectStatus):
        self._DetectStatus = DetectStatus

    @property
    def Level(self):
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level

    @property
    def HostCount(self):
        return self._HostCount

    @HostCount.setter
    def HostCount(self, HostCount):
        self._HostCount = HostCount

    @property
    def FirstTime(self):
        return self._FirstTime

    @FirstTime.setter
    def FirstTime(self, FirstTime):
        self._FirstTime = FirstTime

    @property
    def LastTime(self):
        return self._LastTime

    @LastTime.setter
    def LastTime(self, LastTime):
        self._LastTime = LastTime

    @property
    def DetectResult(self):
        return self._DetectResult

    @DetectResult.setter
    def DetectResult(self, DetectResult):
        self._DetectResult = DetectResult

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def PassedHostCount(self):
        return self._PassedHostCount

    @PassedHostCount.setter
    def PassedHostCount(self, PassedHostCount):
        self._PassedHostCount = PassedHostCount

    @property
    def NotPassedHostCount(self):
        return self._NotPassedHostCount

    @NotPassedHostCount.setter
    def NotPassedHostCount(self, NotPassedHostCount):
        self._NotPassedHostCount = NotPassedHostCount


    def _deserialize(self, params):
        self._ItemId = params.get("ItemId")
        self._ItemName = params.get("ItemName")
        self._ItemDesc = params.get("ItemDesc")
        self._FixMethod = params.get("FixMethod")
        self._RuleName = params.get("RuleName")
        self._DetectStatus = params.get("DetectStatus")
        self._Level = params.get("Level")
        self._HostCount = params.get("HostCount")
        self._FirstTime = params.get("FirstTime")
        self._LastTime = params.get("LastTime")
        self._DetectResult = params.get("DetectResult")
        self._RuleId = params.get("RuleId")
        self._PassedHostCount = params.get("PassedHostCount")
        self._NotPassedHostCount = params.get("NotPassedHostCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaselineItemInfo(AbstractModel):
    """基线信息

    """

    def __init__(self):
        r"""
        :param _ItemId: 基线检测项ID
        :type ItemId: int
        :param _ItemName: 检测项名字
        :type ItemName: str
        :param _RuleId: 检测项所属规则的ID
注意：此字段可能返回 null，表示取不到有效值。
        :type RuleId: int
        :param _ItemDesc: 检测项描述
        :type ItemDesc: str
        :param _FixMethod: 检测项的修复方法
        :type FixMethod: str
        :param _RuleName: 检测项所属规则名字
        :type RuleName: str
        :param _Level: 危险等级
        :type Level: int
        :param _SysRuleId: 系统规则ID
注意：此字段可能返回 null，表示取不到有效值。
        :type SysRuleId: int
        :param _RelatedCustomRuleInfo: 被引自定义规则信息
注意：此字段可能返回 null，表示取不到有效值。
        :type RelatedCustomRuleInfo: list of BaselineCustomRuleIdName
        """
        self._ItemId = None
        self._ItemName = None
        self._RuleId = None
        self._ItemDesc = None
        self._FixMethod = None
        self._RuleName = None
        self._Level = None
        self._SysRuleId = None
        self._RelatedCustomRuleInfo = None

    @property
    def ItemId(self):
        return self._ItemId

    @ItemId.setter
    def ItemId(self, ItemId):
        self._ItemId = ItemId

    @property
    def ItemName(self):
        return self._ItemName

    @ItemName.setter
    def ItemName(self, ItemName):
        self._ItemName = ItemName

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def ItemDesc(self):
        return self._ItemDesc

    @ItemDesc.setter
    def ItemDesc(self, ItemDesc):
        self._ItemDesc = ItemDesc

    @property
    def FixMethod(self):
        return self._FixMethod

    @FixMethod.setter
    def FixMethod(self, FixMethod):
        self._FixMethod = FixMethod

    @property
    def RuleName(self):
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName

    @property
    def Level(self):
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level

    @property
    def SysRuleId(self):
        return self._SysRuleId

    @SysRuleId.setter
    def SysRuleId(self, SysRuleId):
        self._SysRuleId = SysRuleId

    @property
    def RelatedCustomRuleInfo(self):
        return self._RelatedCustomRuleInfo

    @RelatedCustomRuleInfo.setter
    def RelatedCustomRuleInfo(self, RelatedCustomRuleInfo):
        self._RelatedCustomRuleInfo = RelatedCustomRuleInfo


    def _deserialize(self, params):
        self._ItemId = params.get("ItemId")
        self._ItemName = params.get("ItemName")
        self._RuleId = params.get("RuleId")
        self._ItemDesc = params.get("ItemDesc")
        self._FixMethod = params.get("FixMethod")
        self._RuleName = params.get("RuleName")
        self._Level = params.get("Level")
        self._SysRuleId = params.get("SysRuleId")
        if params.get("RelatedCustomRuleInfo") is not None:
            self._RelatedCustomRuleInfo = []
            for item in params.get("RelatedCustomRuleInfo"):
                obj = BaselineCustomRuleIdName()
                obj._deserialize(item)
                self._RelatedCustomRuleInfo.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaselinePolicy(AbstractModel):
    """基线策略信息

    """

    def __init__(self):
        r"""
        :param _PolicyName: 策略名称,长度不超过128英文字符
        :type PolicyName: str
        :param _DetectInterval: 检测间隔[1:1天|3:3天|5:5天|7:7天]
        :type DetectInterval: int
        :param _DetectTime: 检测时间
        :type DetectTime: str
        :param _IsEnabled: 是否开启[0:未开启|1:开启]
        :type IsEnabled: int
        :param _AssetType: 资产类型[0:所有专业版旗舰版|1:id|2:ip]
        :type AssetType: int
        :param _PolicyId: 策略Id
        :type PolicyId: int
        :param _RuleCount: 关联基线项数目
        :type RuleCount: int
        :param _ItemCount: 关联基线项数目
        :type ItemCount: int
        :param _HostCount: 关联基线主机数目
        :type HostCount: int
        :param _RuleIds: 规则Id
        :type RuleIds: list of int
        :param _HostIds: 主机Id
        :type HostIds: list of str
        :param _HostIps: 主机Ip
        :type HostIps: list of str
        :param _IsDefault: 是否是系统默认
        :type IsDefault: int
        """
        self._PolicyName = None
        self._DetectInterval = None
        self._DetectTime = None
        self._IsEnabled = None
        self._AssetType = None
        self._PolicyId = None
        self._RuleCount = None
        self._ItemCount = None
        self._HostCount = None
        self._RuleIds = None
        self._HostIds = None
        self._HostIps = None
        self._IsDefault = None

    @property
    def PolicyName(self):
        return self._PolicyName

    @PolicyName.setter
    def PolicyName(self, PolicyName):
        self._PolicyName = PolicyName

    @property
    def DetectInterval(self):
        return self._DetectInterval

    @DetectInterval.setter
    def DetectInterval(self, DetectInterval):
        self._DetectInterval = DetectInterval

    @property
    def DetectTime(self):
        return self._DetectTime

    @DetectTime.setter
    def DetectTime(self, DetectTime):
        self._DetectTime = DetectTime

    @property
    def IsEnabled(self):
        return self._IsEnabled

    @IsEnabled.setter
    def IsEnabled(self, IsEnabled):
        self._IsEnabled = IsEnabled

    @property
    def AssetType(self):
        return self._AssetType

    @AssetType.setter
    def AssetType(self, AssetType):
        self._AssetType = AssetType

    @property
    def PolicyId(self):
        return self._PolicyId

    @PolicyId.setter
    def PolicyId(self, PolicyId):
        self._PolicyId = PolicyId

    @property
    def RuleCount(self):
        return self._RuleCount

    @RuleCount.setter
    def RuleCount(self, RuleCount):
        self._RuleCount = RuleCount

    @property
    def ItemCount(self):
        return self._ItemCount

    @ItemCount.setter
    def ItemCount(self, ItemCount):
        self._ItemCount = ItemCount

    @property
    def HostCount(self):
        return self._HostCount

    @HostCount.setter
    def HostCount(self, HostCount):
        self._HostCount = HostCount

    @property
    def RuleIds(self):
        return self._RuleIds

    @RuleIds.setter
    def RuleIds(self, RuleIds):
        self._RuleIds = RuleIds

    @property
    def HostIds(self):
        return self._HostIds

    @HostIds.setter
    def HostIds(self, HostIds):
        self._HostIds = HostIds

    @property
    def HostIps(self):
        return self._HostIps

    @HostIps.setter
    def HostIps(self, HostIps):
        self._HostIps = HostIps

    @property
    def IsDefault(self):
        return self._IsDefault

    @IsDefault.setter
    def IsDefault(self, IsDefault):
        self._IsDefault = IsDefault


    def _deserialize(self, params):
        self._PolicyName = params.get("PolicyName")
        self._DetectInterval = params.get("DetectInterval")
        self._DetectTime = params.get("DetectTime")
        self._IsEnabled = params.get("IsEnabled")
        self._AssetType = params.get("AssetType")
        self._PolicyId = params.get("PolicyId")
        self._RuleCount = params.get("RuleCount")
        self._ItemCount = params.get("ItemCount")
        self._HostCount = params.get("HostCount")
        self._RuleIds = params.get("RuleIds")
        self._HostIds = params.get("HostIds")
        self._HostIps = params.get("HostIps")
        self._IsDefault = params.get("IsDefault")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaselinePolicyDetect(AbstractModel):
    """基线检测策略

    """

    def __init__(self):
        r"""
        :param _PolicyId: 策略Id
        :type PolicyId: int
        :param _TaskId: 检测任务Id
        :type TaskId: int
        :param _HostCount: 关联主机数
        :type HostCount: int
        :param _StartTime: 开始时间
        :type StartTime: str
        :param _FinishTime: 结束时间
        :type FinishTime: str
        :param _PolicyName: 策略名称
        :type PolicyName: str
        :param _SuccessCount: 成功主机数
        :type SuccessCount: int
        :param _FailedCount: 失败主技数
        :type FailedCount: int
        :param _TimeoutCount: 失败主机数
        :type TimeoutCount: int
        :param _PolicyDetectStatus: 1:检测中 2:检测完成
注意：此字段可能返回 null，表示取不到有效值。
        :type PolicyDetectStatus: int
        """
        self._PolicyId = None
        self._TaskId = None
        self._HostCount = None
        self._StartTime = None
        self._FinishTime = None
        self._PolicyName = None
        self._SuccessCount = None
        self._FailedCount = None
        self._TimeoutCount = None
        self._PolicyDetectStatus = None

    @property
    def PolicyId(self):
        return self._PolicyId

    @PolicyId.setter
    def PolicyId(self, PolicyId):
        self._PolicyId = PolicyId

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def HostCount(self):
        return self._HostCount

    @HostCount.setter
    def HostCount(self, HostCount):
        self._HostCount = HostCount

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def FinishTime(self):
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime

    @property
    def PolicyName(self):
        return self._PolicyName

    @PolicyName.setter
    def PolicyName(self, PolicyName):
        self._PolicyName = PolicyName

    @property
    def SuccessCount(self):
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def FailedCount(self):
        return self._FailedCount

    @FailedCount.setter
    def FailedCount(self, FailedCount):
        self._FailedCount = FailedCount

    @property
    def TimeoutCount(self):
        return self._TimeoutCount

    @TimeoutCount.setter
    def TimeoutCount(self, TimeoutCount):
        self._TimeoutCount = TimeoutCount

    @property
    def PolicyDetectStatus(self):
        return self._PolicyDetectStatus

    @PolicyDetectStatus.setter
    def PolicyDetectStatus(self, PolicyDetectStatus):
        self._PolicyDetectStatus = PolicyDetectStatus


    def _deserialize(self, params):
        self._PolicyId = params.get("PolicyId")
        self._TaskId = params.get("TaskId")
        self._HostCount = params.get("HostCount")
        self._StartTime = params.get("StartTime")
        self._FinishTime = params.get("FinishTime")
        self._PolicyName = params.get("PolicyName")
        self._SuccessCount = params.get("SuccessCount")
        self._FailedCount = params.get("FailedCount")
        self._TimeoutCount = params.get("TimeoutCount")
        self._PolicyDetectStatus = params.get("PolicyDetectStatus")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaselineRiskItem(AbstractModel):
    """基线检测项top5

    """

    def __init__(self):
        r"""
        :param _ItemId: 检测项Id
注意：此字段可能返回 null，表示取不到有效值。
        :type ItemId: int
        :param _ItemName: 检测项名字
        :type ItemName: str
        :param _Level: 风险等级
        :type Level: int
        :param _HostCount: 影响服务器数
        :type HostCount: int
        """
        self._ItemId = None
        self._ItemName = None
        self._Level = None
        self._HostCount = None

    @property
    def ItemId(self):
        return self._ItemId

    @ItemId.setter
    def ItemId(self, ItemId):
        self._ItemId = ItemId

    @property
    def ItemName(self):
        return self._ItemName

    @ItemName.setter
    def ItemName(self, ItemName):
        self._ItemName = ItemName

    @property
    def Level(self):
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level

    @property
    def HostCount(self):
        return self._HostCount

    @HostCount.setter
    def HostCount(self, HostCount):
        self._HostCount = HostCount


    def _deserialize(self, params):
        self._ItemId = params.get("ItemId")
        self._ItemName = params.get("ItemName")
        self._Level = params.get("Level")
        self._HostCount = params.get("HostCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaselineRule(AbstractModel):
    """基线规则

    """

    def __init__(self):
        r"""
        :param _RuleName: 规则名称,长度不超过128英文字符
        :type RuleName: str
        :param _RuleId: 规则Id
        :type RuleId: int
        :param _RuleType: 规则类型 [0:系统|1:自定义]
        :type RuleType: int
        :param _CategoryId: 规则分类
        :type CategoryId: int
        :param _RuleDesc: 规则描述
        :type RuleDesc: str
        :param _HostCount: 主机数
        :type HostCount: int
        :param _Items: 适配项ID列表
        :type Items: list of Item
        :param _AssetType: [0:所有专业版旗舰版|1:hostID|2:ip]
注意：此字段可能返回 null，表示取不到有效值。
        :type AssetType: int
        :param _HostIds: 主机Id集合
注意：此字段可能返回 null，表示取不到有效值。
        :type HostIds: list of str
        :param _HostIps: 主机IP
注意：此字段可能返回 null，表示取不到有效值。
        :type HostIps: list of str
        """
        self._RuleName = None
        self._RuleId = None
        self._RuleType = None
        self._CategoryId = None
        self._RuleDesc = None
        self._HostCount = None
        self._Items = None
        self._AssetType = None
        self._HostIds = None
        self._HostIps = None

    @property
    def RuleName(self):
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def RuleType(self):
        return self._RuleType

    @RuleType.setter
    def RuleType(self, RuleType):
        self._RuleType = RuleType

    @property
    def CategoryId(self):
        return self._CategoryId

    @CategoryId.setter
    def CategoryId(self, CategoryId):
        self._CategoryId = CategoryId

    @property
    def RuleDesc(self):
        return self._RuleDesc

    @RuleDesc.setter
    def RuleDesc(self, RuleDesc):
        self._RuleDesc = RuleDesc

    @property
    def HostCount(self):
        return self._HostCount

    @HostCount.setter
    def HostCount(self, HostCount):
        self._HostCount = HostCount

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def AssetType(self):
        return self._AssetType

    @AssetType.setter
    def AssetType(self, AssetType):
        self._AssetType = AssetType

    @property
    def HostIds(self):
        return self._HostIds

    @HostIds.setter
    def HostIds(self, HostIds):
        self._HostIds = HostIds

    @property
    def HostIps(self):
        return self._HostIps

    @HostIps.setter
    def HostIps(self, HostIps):
        self._HostIps = HostIps


    def _deserialize(self, params):
        self._RuleName = params.get("RuleName")
        self._RuleId = params.get("RuleId")
        self._RuleType = params.get("RuleType")
        self._CategoryId = params.get("CategoryId")
        self._RuleDesc = params.get("RuleDesc")
        self._HostCount = params.get("HostCount")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = Item()
                obj._deserialize(item)
                self._Items.append(obj)
        self._AssetType = params.get("AssetType")
        self._HostIds = params.get("HostIds")
        self._HostIps = params.get("HostIps")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaselineRuleDetect(AbstractModel):
    """基线规则检测

    """

    def __init__(self):
        r"""
        :param _RuleId: 规则Id
        :type RuleId: int
        :param _RuleName: 规则名称
        :type RuleName: str
        :param _RuleDesc: 规则描述
        :type RuleDesc: str
        :param _ItemCount: 关联项数
        :type ItemCount: int
        :param _HostCount: 关联主机数
        :type HostCount: int
        :param _FirstTime: 首次检测时间
        :type FirstTime: str
        :param _LastTime: string
        :type LastTime: str
        :param _DetectStatus: 0:未通过 1:忽略 3:通过 5:检测中
        :type DetectStatus: int
        :param _ItemIds: ItemID集合
注意：此字段可能返回 null，表示取不到有效值。
        :type ItemIds: list of int
        """
        self._RuleId = None
        self._RuleName = None
        self._RuleDesc = None
        self._ItemCount = None
        self._HostCount = None
        self._FirstTime = None
        self._LastTime = None
        self._DetectStatus = None
        self._ItemIds = None

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def RuleName(self):
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName

    @property
    def RuleDesc(self):
        return self._RuleDesc

    @RuleDesc.setter
    def RuleDesc(self, RuleDesc):
        self._RuleDesc = RuleDesc

    @property
    def ItemCount(self):
        return self._ItemCount

    @ItemCount.setter
    def ItemCount(self, ItemCount):
        self._ItemCount = ItemCount

    @property
    def HostCount(self):
        return self._HostCount

    @HostCount.setter
    def HostCount(self, HostCount):
        self._HostCount = HostCount

    @property
    def FirstTime(self):
        return self._FirstTime

    @FirstTime.setter
    def FirstTime(self, FirstTime):
        self._FirstTime = FirstTime

    @property
    def LastTime(self):
        return self._LastTime

    @LastTime.setter
    def LastTime(self, LastTime):
        self._LastTime = LastTime

    @property
    def DetectStatus(self):
        return self._DetectStatus

    @DetectStatus.setter
    def DetectStatus(self, DetectStatus):
        self._DetectStatus = DetectStatus

    @property
    def ItemIds(self):
        return self._ItemIds

    @ItemIds.setter
    def ItemIds(self, ItemIds):
        self._ItemIds = ItemIds


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        self._RuleName = params.get("RuleName")
        self._RuleDesc = params.get("RuleDesc")
        self._ItemCount = params.get("ItemCount")
        self._HostCount = params.get("HostCount")
        self._FirstTime = params.get("FirstTime")
        self._LastTime = params.get("LastTime")
        self._DetectStatus = params.get("DetectStatus")
        self._ItemIds = params.get("ItemIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaselineRuleInfo(AbstractModel):
    """基线检测信息

    """

    def __init__(self):
        r"""
        :param _RuleName: 检测项名称
        :type RuleName: str
        :param _Description: 检测项描述
        :type Description: str
        :param _FixMessage: 修复建议
        :type FixMessage: str
        :param _Level: 危害等级
        :type Level: int
        :param _Status: 状态
        :type Status: int
        :param _RuleId: 检测项id
        :type RuleId: int
        :param _LastScanAt: 最后检测时间
        :type LastScanAt: str
        :param _RuleRemark: 具体原因说明
        :type RuleRemark: str
        :param _Uuid: 唯一Uuid
        :type Uuid: str
        :param _EventId: 唯一事件ID
        :type EventId: int
        """
        self._RuleName = None
        self._Description = None
        self._FixMessage = None
        self._Level = None
        self._Status = None
        self._RuleId = None
        self._LastScanAt = None
        self._RuleRemark = None
        self._Uuid = None
        self._EventId = None

    @property
    def RuleName(self):
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def FixMessage(self):
        return self._FixMessage

    @FixMessage.setter
    def FixMessage(self, FixMessage):
        self._FixMessage = FixMessage

    @property
    def Level(self):
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def LastScanAt(self):
        return self._LastScanAt

    @LastScanAt.setter
    def LastScanAt(self, LastScanAt):
        self._LastScanAt = LastScanAt

    @property
    def RuleRemark(self):
        return self._RuleRemark

    @RuleRemark.setter
    def RuleRemark(self, RuleRemark):
        self._RuleRemark = RuleRemark

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def EventId(self):
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId


    def _deserialize(self, params):
        self._RuleName = params.get("RuleName")
        self._Description = params.get("Description")
        self._FixMessage = params.get("FixMessage")
        self._Level = params.get("Level")
        self._Status = params.get("Status")
        self._RuleId = params.get("RuleId")
        self._LastScanAt = params.get("LastScanAt")
        self._RuleRemark = params.get("RuleRemark")
        self._Uuid = params.get("Uuid")
        self._EventId = params.get("EventId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaselineRuleTopInfo(AbstractModel):
    """基线检测项TOP信息

    """

    def __init__(self):
        r"""
        :param _RuleName: 基线检测项名
注意：此字段可能返回 null，表示取不到有效值。
        :type RuleName: str
        :param _Level: 检测项危害等级
注意：此字段可能返回 null，表示取不到有效值。
        :type Level: int
        :param _EventCount: 事件总数
注意：此字段可能返回 null，表示取不到有效值。
        :type EventCount: int
        :param _RuleId: 检测项id
注意：此字段可能返回 null，表示取不到有效值。
        :type RuleId: int
        """
        self._RuleName = None
        self._Level = None
        self._EventCount = None
        self._RuleId = None

    @property
    def RuleName(self):
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName

    @property
    def Level(self):
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level

    @property
    def EventCount(self):
        return self._EventCount

    @EventCount.setter
    def EventCount(self, EventCount):
        self._EventCount = EventCount

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId


    def _deserialize(self, params):
        self._RuleName = params.get("RuleName")
        self._Level = params.get("Level")
        self._EventCount = params.get("EventCount")
        self._RuleId = params.get("RuleId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BaselineWeakPassword(AbstractModel):
    """基线弱口令

    """

    def __init__(self):
        r"""
        :param _PasswordId: 密码Id
        :type PasswordId: int
        :param _WeakPassword: 密码
        :type WeakPassword: str
        :param _CreateTime: 创建时间
        :type CreateTime: str
        :param _ModifyTime: 修改时间
        :type ModifyTime: str
        """
        self._PasswordId = None
        self._WeakPassword = None
        self._CreateTime = None
        self._ModifyTime = None

    @property
    def PasswordId(self):
        return self._PasswordId

    @PasswordId.setter
    def PasswordId(self, PasswordId):
        self._PasswordId = PasswordId

    @property
    def WeakPassword(self):
        return self._WeakPassword

    @WeakPassword.setter
    def WeakPassword(self, WeakPassword):
        self._WeakPassword = WeakPassword

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ModifyTime(self):
        return self._ModifyTime

    @ModifyTime.setter
    def ModifyTime(self, ModifyTime):
        self._ModifyTime = ModifyTime


    def _deserialize(self, params):
        self._PasswordId = params.get("PasswordId")
        self._WeakPassword = params.get("WeakPassword")
        self._CreateTime = params.get("CreateTime")
        self._ModifyTime = params.get("ModifyTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BashEvent(AbstractModel):
    """高危命令数据

    """

    def __init__(self):
        r"""
        :param _Id: 数据ID
        :type Id: int
        :param _Uuid: 主机安全ID
        :type Uuid: str
        :param _Quuid: 主机ID
        :type Quuid: str
        :param _Hostip: 主机内网IP
        :type Hostip: str
        :param _User: 执行用户名
        :type User: str
        :param _Platform: 平台类型
        :type Platform: int
        :param _BashCmd: 执行命令
        :type BashCmd: str
        :param _RuleId: 规则ID
        :type RuleId: int
        :param _RuleName: 规则名称
        :type RuleName: str
        :param _RuleLevel: 规则等级：1-高 2-中 3-低
        :type RuleLevel: int
        :param _Status: 处理状态： 0 = 待处理 1= 已处理, 2 = 已加白， 3 = 已忽略
        :type Status: int
        :param _CreateTime: 发生时间
        :type CreateTime: str
        :param _MachineName: 主机名
        :type MachineName: str
        :param _DetectBy: 0: bash日志 1: 实时监控(雷霆版)
注意：此字段可能返回 null，表示取不到有效值。
        :type DetectBy: int
        :param _Pid: 进程id
注意：此字段可能返回 null，表示取不到有效值。
        :type Pid: str
        :param _Exe: 进程名称
注意：此字段可能返回 null，表示取不到有效值。
        :type Exe: str
        :param _ModifyTime: 处理时间
注意：此字段可能返回 null，表示取不到有效值。
        :type ModifyTime: str
        :param _RuleCategory: 规则类别  0=系统规则，1=用户规则
注意：此字段可能返回 null，表示取不到有效值。
        :type RuleCategory: int
        :param _RegexBashCmd: 自动生成的正则表达式
注意：此字段可能返回 null，表示取不到有效值。
        :type RegexBashCmd: str
        """
        self._Id = None
        self._Uuid = None
        self._Quuid = None
        self._Hostip = None
        self._User = None
        self._Platform = None
        self._BashCmd = None
        self._RuleId = None
        self._RuleName = None
        self._RuleLevel = None
        self._Status = None
        self._CreateTime = None
        self._MachineName = None
        self._DetectBy = None
        self._Pid = None
        self._Exe = None
        self._ModifyTime = None
        self._RuleCategory = None
        self._RegexBashCmd = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Hostip(self):
        return self._Hostip

    @Hostip.setter
    def Hostip(self, Hostip):
        self._Hostip = Hostip

    @property
    def User(self):
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def Platform(self):
        return self._Platform

    @Platform.setter
    def Platform(self, Platform):
        self._Platform = Platform

    @property
    def BashCmd(self):
        return self._BashCmd

    @BashCmd.setter
    def BashCmd(self, BashCmd):
        self._BashCmd = BashCmd

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def RuleName(self):
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName

    @property
    def RuleLevel(self):
        return self._RuleLevel

    @RuleLevel.setter
    def RuleLevel(self, RuleLevel):
        self._RuleLevel = RuleLevel

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def DetectBy(self):
        return self._DetectBy

    @DetectBy.setter
    def DetectBy(self, DetectBy):
        self._DetectBy = DetectBy

    @property
    def Pid(self):
        return self._Pid

    @Pid.setter
    def Pid(self, Pid):
        self._Pid = Pid

    @property
    def Exe(self):
        return self._Exe

    @Exe.setter
    def Exe(self, Exe):
        self._Exe = Exe

    @property
    def ModifyTime(self):
        return self._ModifyTime

    @ModifyTime.setter
    def ModifyTime(self, ModifyTime):
        self._ModifyTime = ModifyTime

    @property
    def RuleCategory(self):
        return self._RuleCategory

    @RuleCategory.setter
    def RuleCategory(self, RuleCategory):
        self._RuleCategory = RuleCategory

    @property
    def RegexBashCmd(self):
        return self._RegexBashCmd

    @RegexBashCmd.setter
    def RegexBashCmd(self, RegexBashCmd):
        self._RegexBashCmd = RegexBashCmd


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Uuid = params.get("Uuid")
        self._Quuid = params.get("Quuid")
        self._Hostip = params.get("Hostip")
        self._User = params.get("User")
        self._Platform = params.get("Platform")
        self._BashCmd = params.get("BashCmd")
        self._RuleId = params.get("RuleId")
        self._RuleName = params.get("RuleName")
        self._RuleLevel = params.get("RuleLevel")
        self._Status = params.get("Status")
        self._CreateTime = params.get("CreateTime")
        self._MachineName = params.get("MachineName")
        self._DetectBy = params.get("DetectBy")
        self._Pid = params.get("Pid")
        self._Exe = params.get("Exe")
        self._ModifyTime = params.get("ModifyTime")
        self._RuleCategory = params.get("RuleCategory")
        self._RegexBashCmd = params.get("RegexBashCmd")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BashEventNew(AbstractModel):
    """高危命令数据(新)

    """

    def __init__(self):
        r"""
        :param _Id: 数据ID
        :type Id: int
        :param _Uuid: 主机安全ID
        :type Uuid: str
        :param _Quuid: 主机ID
        :type Quuid: str
        :param _HostIp: 主机内网IP
        :type HostIp: str
        :param _User: 执行用户名
        :type User: str
        :param _Platform: 平台类型
        :type Platform: int
        :param _BashCmd: 执行命令
        :type BashCmd: str
        :param _RuleId: 规则ID
        :type RuleId: int
        :param _RuleName: 规则名称
        :type RuleName: str
        :param _RuleLevel: 规则等级：1-高 2-中 3-低
        :type RuleLevel: int
        :param _Status: 处理状态： 0 = 待处理 1= 已处理, 2 = 已加白， 3 = 已忽略
        :type Status: int
        :param _CreateTime: 发生时间
        :type CreateTime: str
        :param _MachineName: 主机名
        :type MachineName: str
        :param _DetectBy: 0: bash日志 1: 实时监控(雷霆版)
注意：此字段可能返回 null，表示取不到有效值。
        :type DetectBy: int
        :param _Pid: 进程id
注意：此字段可能返回 null，表示取不到有效值。
        :type Pid: str
        :param _Exe: 进程名称
注意：此字段可能返回 null，表示取不到有效值。
        :type Exe: str
        :param _ModifyTime: 处理时间
注意：此字段可能返回 null，表示取不到有效值。
        :type ModifyTime: str
        :param _RuleCategory: 规则类别  0=系统规则，1=用户规则
注意：此字段可能返回 null，表示取不到有效值。
        :type RuleCategory: int
        :param _RegexBashCmd: 自动生成的正则表达式
注意：此字段可能返回 null，表示取不到有效值。
        :type RegexBashCmd: str
        :param _MachineType: 0:普通 1:专业版 2:旗舰版
注意：此字段可能返回 null，表示取不到有效值。
        :type MachineType: int
        :param _MachineExtraInfo: 机器额外信息
注意：此字段可能返回 null，表示取不到有效值。
        :type MachineExtraInfo: :class:`tencentcloud.cwp.v20180228.models.MachineExtraInfo`
        """
        self._Id = None
        self._Uuid = None
        self._Quuid = None
        self._HostIp = None
        self._User = None
        self._Platform = None
        self._BashCmd = None
        self._RuleId = None
        self._RuleName = None
        self._RuleLevel = None
        self._Status = None
        self._CreateTime = None
        self._MachineName = None
        self._DetectBy = None
        self._Pid = None
        self._Exe = None
        self._ModifyTime = None
        self._RuleCategory = None
        self._RegexBashCmd = None
        self._MachineType = None
        self._MachineExtraInfo = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def HostIp(self):
        return self._HostIp

    @HostIp.setter
    def HostIp(self, HostIp):
        self._HostIp = HostIp

    @property
    def User(self):
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def Platform(self):
        return self._Platform

    @Platform.setter
    def Platform(self, Platform):
        self._Platform = Platform

    @property
    def BashCmd(self):
        return self._BashCmd

    @BashCmd.setter
    def BashCmd(self, BashCmd):
        self._BashCmd = BashCmd

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def RuleName(self):
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName

    @property
    def RuleLevel(self):
        return self._RuleLevel

    @RuleLevel.setter
    def RuleLevel(self, RuleLevel):
        self._RuleLevel = RuleLevel

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def DetectBy(self):
        return self._DetectBy

    @DetectBy.setter
    def DetectBy(self, DetectBy):
        self._DetectBy = DetectBy

    @property
    def Pid(self):
        return self._Pid

    @Pid.setter
    def Pid(self, Pid):
        self._Pid = Pid

    @property
    def Exe(self):
        return self._Exe

    @Exe.setter
    def Exe(self, Exe):
        self._Exe = Exe

    @property
    def ModifyTime(self):
        return self._ModifyTime

    @ModifyTime.setter
    def ModifyTime(self, ModifyTime):
        self._ModifyTime = ModifyTime

    @property
    def RuleCategory(self):
        return self._RuleCategory

    @RuleCategory.setter
    def RuleCategory(self, RuleCategory):
        self._RuleCategory = RuleCategory

    @property
    def RegexBashCmd(self):
        return self._RegexBashCmd

    @RegexBashCmd.setter
    def RegexBashCmd(self, RegexBashCmd):
        self._RegexBashCmd = RegexBashCmd

    @property
    def MachineType(self):
        return self._MachineType

    @MachineType.setter
    def MachineType(self, MachineType):
        self._MachineType = MachineType

    @property
    def MachineExtraInfo(self):
        return self._MachineExtraInfo

    @MachineExtraInfo.setter
    def MachineExtraInfo(self, MachineExtraInfo):
        self._MachineExtraInfo = MachineExtraInfo


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Uuid = params.get("Uuid")
        self._Quuid = params.get("Quuid")
        self._HostIp = params.get("HostIp")
        self._User = params.get("User")
        self._Platform = params.get("Platform")
        self._BashCmd = params.get("BashCmd")
        self._RuleId = params.get("RuleId")
        self._RuleName = params.get("RuleName")
        self._RuleLevel = params.get("RuleLevel")
        self._Status = params.get("Status")
        self._CreateTime = params.get("CreateTime")
        self._MachineName = params.get("MachineName")
        self._DetectBy = params.get("DetectBy")
        self._Pid = params.get("Pid")
        self._Exe = params.get("Exe")
        self._ModifyTime = params.get("ModifyTime")
        self._RuleCategory = params.get("RuleCategory")
        self._RegexBashCmd = params.get("RegexBashCmd")
        self._MachineType = params.get("MachineType")
        if params.get("MachineExtraInfo") is not None:
            self._MachineExtraInfo = MachineExtraInfo()
            self._MachineExtraInfo._deserialize(params.get("MachineExtraInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BashEventsInfoNew(AbstractModel):
    """高危命令数据详情(新)

    """

    def __init__(self):
        r"""
        :param _Id: 数据ID
        :type Id: int
        :param _Uuid: 主机安全ID
        :type Uuid: str
        :param _Quuid: 主机ID
        :type Quuid: str
        :param _HostIp: 主机内网IP
        :type HostIp: str
        :param _Platform: 平台类型
        :type Platform: int
        :param _BashCmd: 执行命令
        :type BashCmd: str
        :param _RuleId: 规则ID,等于0表示已规则已被删除或生效范围已修改
        :type RuleId: int
        :param _RuleName: 规则名称
        :type RuleName: str
        :param _RuleLevel: 规则等级：1-高 2-中 3-低
        :type RuleLevel: int
        :param _Status: 处理状态： 0 = 待处理 1= 已处理, 2 = 已加白， 3= 已忽略
        :type Status: int
        :param _CreateTime: 发生时间
        :type CreateTime: str
        :param _MachineName: 主机名
        :type MachineName: str
        :param _Exe: 进程名称
注意：此字段可能返回 null，表示取不到有效值。
        :type Exe: str
        :param _ModifyTime: 处理时间
注意：此字段可能返回 null，表示取不到有效值。
        :type ModifyTime: str
        :param _RuleCategory: 规则类别  0=系统规则，1=用户规则
注意：此字段可能返回 null，表示取不到有效值。
        :type RuleCategory: int
        :param _RegexBashCmd: 自动生成的正则表达式
注意：此字段可能返回 null，表示取不到有效值。
        :type RegexBashCmd: str
        :param _PsTree: 进程树 json  pid:进程id，exe:文件路径 ，account:进程所属用组和用户 ,cmdline:执行命令，ssh_service: SSH服务ip, ssh_soure:登录源
注意：此字段可能返回 null，表示取不到有效值。
        :type PsTree: str
        :param _SuggestScheme: 建议方案
注意：此字段可能返回 null，表示取不到有效值。
        :type SuggestScheme: str
        :param _HarmDescribe: 描述
注意：此字段可能返回 null，表示取不到有效值。
        :type HarmDescribe: str
        :param _Tags: 标签
注意：此字段可能返回 null，表示取不到有效值。
        :type Tags: list of str
        :param _References: 参考链接
注意：此字段可能返回 null，表示取不到有效值。
        :type References: list of str
        :param _MachineWanIp: 主机外网ip
注意：此字段可能返回 null，表示取不到有效值。
        :type MachineWanIp: str
        :param _MachineStatus: 主机在线状态 OFFLINE  ONLINE
注意：此字段可能返回 null，表示取不到有效值。
        :type MachineStatus: str
        :param _User: 登录用户
注意：此字段可能返回 null，表示取不到有效值。
        :type User: str
        :param _Pid: 进程号
注意：此字段可能返回 null，表示取不到有效值。
        :type Pid: str
        :param _MachineType: 0:普通 1:专业版 2:旗舰版
注意：此字段可能返回 null，表示取不到有效值。
        :type MachineType: int
        :param _DetectBy: 检测来源 0:bash日志 1:实时监控
注意：此字段可能返回 null，表示取不到有效值。
        :type DetectBy: int
        """
        self._Id = None
        self._Uuid = None
        self._Quuid = None
        self._HostIp = None
        self._Platform = None
        self._BashCmd = None
        self._RuleId = None
        self._RuleName = None
        self._RuleLevel = None
        self._Status = None
        self._CreateTime = None
        self._MachineName = None
        self._Exe = None
        self._ModifyTime = None
        self._RuleCategory = None
        self._RegexBashCmd = None
        self._PsTree = None
        self._SuggestScheme = None
        self._HarmDescribe = None
        self._Tags = None
        self._References = None
        self._MachineWanIp = None
        self._MachineStatus = None
        self._User = None
        self._Pid = None
        self._MachineType = None
        self._DetectBy = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def HostIp(self):
        return self._HostIp

    @HostIp.setter
    def HostIp(self, HostIp):
        self._HostIp = HostIp

    @property
    def Platform(self):
        return self._Platform

    @Platform.setter
    def Platform(self, Platform):
        self._Platform = Platform

    @property
    def BashCmd(self):
        return self._BashCmd

    @BashCmd.setter
    def BashCmd(self, BashCmd):
        self._BashCmd = BashCmd

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def RuleName(self):
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName

    @property
    def RuleLevel(self):
        return self._RuleLevel

    @RuleLevel.setter
    def RuleLevel(self, RuleLevel):
        self._RuleLevel = RuleLevel

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def Exe(self):
        return self._Exe

    @Exe.setter
    def Exe(self, Exe):
        self._Exe = Exe

    @property
    def ModifyTime(self):
        return self._ModifyTime

    @ModifyTime.setter
    def ModifyTime(self, ModifyTime):
        self._ModifyTime = ModifyTime

    @property
    def RuleCategory(self):
        return self._RuleCategory

    @RuleCategory.setter
    def RuleCategory(self, RuleCategory):
        self._RuleCategory = RuleCategory

    @property
    def RegexBashCmd(self):
        return self._RegexBashCmd

    @RegexBashCmd.setter
    def RegexBashCmd(self, RegexBashCmd):
        self._RegexBashCmd = RegexBashCmd

    @property
    def PsTree(self):
        return self._PsTree

    @PsTree.setter
    def PsTree(self, PsTree):
        self._PsTree = PsTree

    @property
    def SuggestScheme(self):
        return self._SuggestScheme

    @SuggestScheme.setter
    def SuggestScheme(self, SuggestScheme):
        self._SuggestScheme = SuggestScheme

    @property
    def HarmDescribe(self):
        return self._HarmDescribe

    @HarmDescribe.setter
    def HarmDescribe(self, HarmDescribe):
        self._HarmDescribe = HarmDescribe

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def References(self):
        return self._References

    @References.setter
    def References(self, References):
        self._References = References

    @property
    def MachineWanIp(self):
        return self._MachineWanIp

    @MachineWanIp.setter
    def MachineWanIp(self, MachineWanIp):
        self._MachineWanIp = MachineWanIp

    @property
    def MachineStatus(self):
        return self._MachineStatus

    @MachineStatus.setter
    def MachineStatus(self, MachineStatus):
        self._MachineStatus = MachineStatus

    @property
    def User(self):
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def Pid(self):
        return self._Pid

    @Pid.setter
    def Pid(self, Pid):
        self._Pid = Pid

    @property
    def MachineType(self):
        return self._MachineType

    @MachineType.setter
    def MachineType(self, MachineType):
        self._MachineType = MachineType

    @property
    def DetectBy(self):
        return self._DetectBy

    @DetectBy.setter
    def DetectBy(self, DetectBy):
        self._DetectBy = DetectBy


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Uuid = params.get("Uuid")
        self._Quuid = params.get("Quuid")
        self._HostIp = params.get("HostIp")
        self._Platform = params.get("Platform")
        self._BashCmd = params.get("BashCmd")
        self._RuleId = params.get("RuleId")
        self._RuleName = params.get("RuleName")
        self._RuleLevel = params.get("RuleLevel")
        self._Status = params.get("Status")
        self._CreateTime = params.get("CreateTime")
        self._MachineName = params.get("MachineName")
        self._Exe = params.get("Exe")
        self._ModifyTime = params.get("ModifyTime")
        self._RuleCategory = params.get("RuleCategory")
        self._RegexBashCmd = params.get("RegexBashCmd")
        self._PsTree = params.get("PsTree")
        self._SuggestScheme = params.get("SuggestScheme")
        self._HarmDescribe = params.get("HarmDescribe")
        self._Tags = params.get("Tags")
        self._References = params.get("References")
        self._MachineWanIp = params.get("MachineWanIp")
        self._MachineStatus = params.get("MachineStatus")
        self._User = params.get("User")
        self._Pid = params.get("Pid")
        self._MachineType = params.get("MachineType")
        self._DetectBy = params.get("DetectBy")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BashRule(AbstractModel):
    """高危命令规则

    """

    def __init__(self):
        r"""
        :param _Id: 规则ID
        :type Id: int
        :param _Uuid: 客户端ID
        :type Uuid: str
        :param _Name: 规则名称
        :type Name: str
        :param _Level: 危险等级(0 ：无 1: 高危 2:中危 3: 低危)
        :type Level: int
        :param _Rule: 正则表达式
        :type Rule: str
        :param _Decription: 规则描述
        :type Decription: str
        :param _Operator: 操作人
        :type Operator: str
        :param _IsGlobal: 是否全局规则
        :type IsGlobal: int
        :param _Status: 状态 (0: 有效 1: 无效)
        :type Status: int
        :param _CreateTime: 创建时间
        :type CreateTime: str
        :param _ModifyTime: 修改时间
        :type ModifyTime: str
        :param _Hostip: 主机IP
        :type Hostip: str
        :param _Uuids: 生效服务器的uuid数组
注意：此字段可能返回 null，表示取不到有效值。
        :type Uuids: list of str
        :param _White: 0=黑名单 1=白名单
注意：此字段可能返回 null，表示取不到有效值。
        :type White: int
        :param _DealOldEvents: 是否处理之前的事件 0: 不处理 1:处理
注意：此字段可能返回 null，表示取不到有效值。
        :type DealOldEvents: int
        """
        self._Id = None
        self._Uuid = None
        self._Name = None
        self._Level = None
        self._Rule = None
        self._Decription = None
        self._Operator = None
        self._IsGlobal = None
        self._Status = None
        self._CreateTime = None
        self._ModifyTime = None
        self._Hostip = None
        self._Uuids = None
        self._White = None
        self._DealOldEvents = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Level(self):
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level

    @property
    def Rule(self):
        return self._Rule

    @Rule.setter
    def Rule(self, Rule):
        self._Rule = Rule

    @property
    def Decription(self):
        return self._Decription

    @Decription.setter
    def Decription(self, Decription):
        self._Decription = Decription

    @property
    def Operator(self):
        return self._Operator

    @Operator.setter
    def Operator(self, Operator):
        self._Operator = Operator

    @property
    def IsGlobal(self):
        return self._IsGlobal

    @IsGlobal.setter
    def IsGlobal(self, IsGlobal):
        self._IsGlobal = IsGlobal

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ModifyTime(self):
        return self._ModifyTime

    @ModifyTime.setter
    def ModifyTime(self, ModifyTime):
        self._ModifyTime = ModifyTime

    @property
    def Hostip(self):
        return self._Hostip

    @Hostip.setter
    def Hostip(self, Hostip):
        self._Hostip = Hostip

    @property
    def Uuids(self):
        return self._Uuids

    @Uuids.setter
    def Uuids(self, Uuids):
        self._Uuids = Uuids

    @property
    def White(self):
        return self._White

    @White.setter
    def White(self, White):
        self._White = White

    @property
    def DealOldEvents(self):
        return self._DealOldEvents

    @DealOldEvents.setter
    def DealOldEvents(self, DealOldEvents):
        self._DealOldEvents = DealOldEvents


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Uuid = params.get("Uuid")
        self._Name = params.get("Name")
        self._Level = params.get("Level")
        self._Rule = params.get("Rule")
        self._Decription = params.get("Decription")
        self._Operator = params.get("Operator")
        self._IsGlobal = params.get("IsGlobal")
        self._Status = params.get("Status")
        self._CreateTime = params.get("CreateTime")
        self._ModifyTime = params.get("ModifyTime")
        self._Hostip = params.get("Hostip")
        self._Uuids = params.get("Uuids")
        self._White = params.get("White")
        self._DealOldEvents = params.get("DealOldEvents")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BruteAttackInfo(AbstractModel):
    """密码破解列表实体

    """

    def __init__(self):
        r"""
        :param _Id: 唯一Id
        :type Id: int
        :param _Uuid: 主机安全客户端唯一标识UUID
注意：此字段可能返回 null，表示取不到有效值。
        :type Uuid: str
        :param _MachineIp: 主机ip
注意：此字段可能返回 null，表示取不到有效值。
        :type MachineIp: str
        :param _MachineName: 主机名
注意：此字段可能返回 null，表示取不到有效值。
        :type MachineName: str
        :param _UserName: 用户名
注意：此字段可能返回 null，表示取不到有效值。
        :type UserName: str
        :param _SrcIp: 来源ip
注意：此字段可能返回 null，表示取不到有效值。
        :type SrcIp: str
        :param _Status: SUCCESS：破解成功；FAILED：破解失败
注意：此字段可能返回 null，表示取不到有效值。
        :type Status: str
        :param _Country: 国家id
注意：此字段可能返回 null，表示取不到有效值。
        :type Country: int
        :param _City: 城市id
注意：此字段可能返回 null，表示取不到有效值。
        :type City: int
        :param _Province: 省份id
注意：此字段可能返回 null，表示取不到有效值。
        :type Province: int
        :param _CreateTime: 创建时间
注意：此字段可能返回 null，表示取不到有效值。
        :type CreateTime: str
        :param _BanStatus: 阻断状态：1-阻断成功；非1-阻断失败
注意：此字段可能返回 null，表示取不到有效值。
        :type BanStatus: int
        :param _EventType: 事件类型：200-暴力破解事件，300-暴力破解成功事件（页面展示），400-暴力破解不存在的帐号事件
注意：此字段可能返回 null，表示取不到有效值。
        :type EventType: int
        :param _Count: 发生次数
注意：此字段可能返回 null，表示取不到有效值。
        :type Count: int
        :param _Quuid: 机器UUID
注意：此字段可能返回 null，表示取不到有效值。
        :type Quuid: str
        :param _IsProVersion: 是否为专业版（true/false）
注意：此字段可能返回 null，表示取不到有效值。
        :type IsProVersion: bool
        :param _Protocol: 被攻击的服务的用户名
注意：此字段可能返回 null，表示取不到有效值。
        :type Protocol: str
        :param _Port: 端口
注意：此字段可能返回 null，表示取不到有效值。
        :type Port: int
        :param _ModifyTime: 最近攻击时间
注意：此字段可能返回 null，表示取不到有效值。
        :type ModifyTime: str
        :param _InstanceId: 实例ID
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceId: str
        :param _DataStatus: 0：待处理，1：忽略，5：已处理，6：加入白名单
注意：此字段可能返回 null，表示取不到有效值。
        :type DataStatus: int
        :param _MachineExtraInfo: 附加信息
注意：此字段可能返回 null，表示取不到有效值。
        :type MachineExtraInfo: :class:`tencentcloud.cwp.v20180228.models.MachineExtraInfo`
        :param _Location: 地理位置中文名
注意：此字段可能返回 null，表示取不到有效值。
        :type Location: str
        """
        self._Id = None
        self._Uuid = None
        self._MachineIp = None
        self._MachineName = None
        self._UserName = None
        self._SrcIp = None
        self._Status = None
        self._Country = None
        self._City = None
        self._Province = None
        self._CreateTime = None
        self._BanStatus = None
        self._EventType = None
        self._Count = None
        self._Quuid = None
        self._IsProVersion = None
        self._Protocol = None
        self._Port = None
        self._ModifyTime = None
        self._InstanceId = None
        self._DataStatus = None
        self._MachineExtraInfo = None
        self._Location = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def MachineIp(self):
        return self._MachineIp

    @MachineIp.setter
    def MachineIp(self, MachineIp):
        self._MachineIp = MachineIp

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def UserName(self):
        return self._UserName

    @UserName.setter
    def UserName(self, UserName):
        self._UserName = UserName

    @property
    def SrcIp(self):
        return self._SrcIp

    @SrcIp.setter
    def SrcIp(self, SrcIp):
        self._SrcIp = SrcIp

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Country(self):
        return self._Country

    @Country.setter
    def Country(self, Country):
        self._Country = Country

    @property
    def City(self):
        return self._City

    @City.setter
    def City(self, City):
        self._City = City

    @property
    def Province(self):
        return self._Province

    @Province.setter
    def Province(self, Province):
        self._Province = Province

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def BanStatus(self):
        return self._BanStatus

    @BanStatus.setter
    def BanStatus(self, BanStatus):
        self._BanStatus = BanStatus

    @property
    def EventType(self):
        return self._EventType

    @EventType.setter
    def EventType(self, EventType):
        self._EventType = EventType

    @property
    def Count(self):
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def IsProVersion(self):
        return self._IsProVersion

    @IsProVersion.setter
    def IsProVersion(self, IsProVersion):
        self._IsProVersion = IsProVersion

    @property
    def Protocol(self):
        return self._Protocol

    @Protocol.setter
    def Protocol(self, Protocol):
        self._Protocol = Protocol

    @property
    def Port(self):
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def ModifyTime(self):
        return self._ModifyTime

    @ModifyTime.setter
    def ModifyTime(self, ModifyTime):
        self._ModifyTime = ModifyTime

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def DataStatus(self):
        return self._DataStatus

    @DataStatus.setter
    def DataStatus(self, DataStatus):
        self._DataStatus = DataStatus

    @property
    def MachineExtraInfo(self):
        return self._MachineExtraInfo

    @MachineExtraInfo.setter
    def MachineExtraInfo(self, MachineExtraInfo):
        self._MachineExtraInfo = MachineExtraInfo

    @property
    def Location(self):
        return self._Location

    @Location.setter
    def Location(self, Location):
        self._Location = Location


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Uuid = params.get("Uuid")
        self._MachineIp = params.get("MachineIp")
        self._MachineName = params.get("MachineName")
        self._UserName = params.get("UserName")
        self._SrcIp = params.get("SrcIp")
        self._Status = params.get("Status")
        self._Country = params.get("Country")
        self._City = params.get("City")
        self._Province = params.get("Province")
        self._CreateTime = params.get("CreateTime")
        self._BanStatus = params.get("BanStatus")
        self._EventType = params.get("EventType")
        self._Count = params.get("Count")
        self._Quuid = params.get("Quuid")
        self._IsProVersion = params.get("IsProVersion")
        self._Protocol = params.get("Protocol")
        self._Port = params.get("Port")
        self._ModifyTime = params.get("ModifyTime")
        self._InstanceId = params.get("InstanceId")
        self._DataStatus = params.get("DataStatus")
        if params.get("MachineExtraInfo") is not None:
            self._MachineExtraInfo = MachineExtraInfo()
            self._MachineExtraInfo._deserialize(params.get("MachineExtraInfo"))
        self._Location = params.get("Location")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BruteAttackRule(AbstractModel):
    """标准阻断模式规则

    """

    def __init__(self):
        r"""
        :param _TimeRange: 爆破事件发生的时间范围，单位：秒
        :type TimeRange: int
        :param _LoginFailTimes: 爆破事件失败次数
        :type LoginFailTimes: int
        """
        self._TimeRange = None
        self._LoginFailTimes = None

    @property
    def TimeRange(self):
        return self._TimeRange

    @TimeRange.setter
    def TimeRange(self, TimeRange):
        self._TimeRange = TimeRange

    @property
    def LoginFailTimes(self):
        return self._LoginFailTimes

    @LoginFailTimes.setter
    def LoginFailTimes(self, LoginFailTimes):
        self._LoginFailTimes = LoginFailTimes


    def _deserialize(self, params):
        self._TimeRange = params.get("TimeRange")
        self._LoginFailTimes = params.get("LoginFailTimes")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BruteAttackRuleList(AbstractModel):
    """暴力破解判定规则列表

    """

    def __init__(self):
        r"""
        :param _TimeRange: 爆破事件发生的时间范围，单位：秒
        :type TimeRange: int
        :param _LoginFailTimes: 爆破事件失败次数
        :type LoginFailTimes: int
        :param _Enable: 规则是否为空，为空则填充默认规则
        :type Enable: bool
        :param _TimeRangeDefault: 爆破事件发生的时间范围，单位：秒（默认规则）
        :type TimeRangeDefault: int
        :param _LoginFailTimesDefault: 爆破事件失败次数（默认规则）
        :type LoginFailTimesDefault: int
        """
        self._TimeRange = None
        self._LoginFailTimes = None
        self._Enable = None
        self._TimeRangeDefault = None
        self._LoginFailTimesDefault = None

    @property
    def TimeRange(self):
        return self._TimeRange

    @TimeRange.setter
    def TimeRange(self, TimeRange):
        self._TimeRange = TimeRange

    @property
    def LoginFailTimes(self):
        return self._LoginFailTimes

    @LoginFailTimes.setter
    def LoginFailTimes(self, LoginFailTimes):
        self._LoginFailTimes = LoginFailTimes

    @property
    def Enable(self):
        return self._Enable

    @Enable.setter
    def Enable(self, Enable):
        self._Enable = Enable

    @property
    def TimeRangeDefault(self):
        return self._TimeRangeDefault

    @TimeRangeDefault.setter
    def TimeRangeDefault(self, TimeRangeDefault):
        self._TimeRangeDefault = TimeRangeDefault

    @property
    def LoginFailTimesDefault(self):
        return self._LoginFailTimesDefault

    @LoginFailTimesDefault.setter
    def LoginFailTimesDefault(self, LoginFailTimesDefault):
        self._LoginFailTimesDefault = LoginFailTimesDefault


    def _deserialize(self, params):
        self._TimeRange = params.get("TimeRange")
        self._LoginFailTimes = params.get("LoginFailTimes")
        self._Enable = params.get("Enable")
        self._TimeRangeDefault = params.get("TimeRangeDefault")
        self._LoginFailTimesDefault = params.get("LoginFailTimesDefault")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CancelIgnoreVulRequest(AbstractModel):
    """CancelIgnoreVul请求参数结构体

    """

    def __init__(self):
        r"""
        :param _EventIds: 漏洞事件id串，多个用英文逗号分隔
        :type EventIds: str
        """
        self._EventIds = None

    @property
    def EventIds(self):
        return self._EventIds

    @EventIds.setter
    def EventIds(self, EventIds):
        self._EventIds = EventIds


    def _deserialize(self, params):
        self._EventIds = params.get("EventIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CancelIgnoreVulResponse(AbstractModel):
    """CancelIgnoreVul返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ChangeRuleEventsIgnoreStatusRequest(AbstractModel):
    """ChangeRuleEventsIgnoreStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _IgnoreStatus: 忽略状态 0:取消忽略 ； 1:忽略
        :type IgnoreStatus: int
        :param _RuleIdList: 检测项id数组
        :type RuleIdList: list of int non-negative
        :param _EventIdList: 事件id数组
        :type EventIdList: list of int non-negative
        """
        self._IgnoreStatus = None
        self._RuleIdList = None
        self._EventIdList = None

    @property
    def IgnoreStatus(self):
        return self._IgnoreStatus

    @IgnoreStatus.setter
    def IgnoreStatus(self, IgnoreStatus):
        self._IgnoreStatus = IgnoreStatus

    @property
    def RuleIdList(self):
        return self._RuleIdList

    @RuleIdList.setter
    def RuleIdList(self, RuleIdList):
        self._RuleIdList = RuleIdList

    @property
    def EventIdList(self):
        return self._EventIdList

    @EventIdList.setter
    def EventIdList(self, EventIdList):
        self._EventIdList = EventIdList


    def _deserialize(self, params):
        self._IgnoreStatus = params.get("IgnoreStatus")
        self._RuleIdList = params.get("RuleIdList")
        self._EventIdList = params.get("EventIdList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ChangeRuleEventsIgnoreStatusResponse(AbstractModel):
    """ChangeRuleEventsIgnoreStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CheckBashRuleParamsRequest(AbstractModel):
    """CheckBashRuleParams请求参数结构体

    """

    def __init__(self):
        r"""
        :param _CheckField: 校验内容 Name或Rule ，两个都要校验时逗号分割
        :type CheckField: str
        :param _EventId: 在事件列表中新增白名时需要提交事件ID
        :type EventId: int
        :param _Name: 填入的规则名称
        :type Name: str
        :param _Rule: 用户填入的正则表达式："正则表达式" 需与 "提交EventId对应的命令内容" 相匹配
        :type Rule: str
        :param _Id: 编辑时传的规则id
        :type Id: int
        """
        self._CheckField = None
        self._EventId = None
        self._Name = None
        self._Rule = None
        self._Id = None

    @property
    def CheckField(self):
        return self._CheckField

    @CheckField.setter
    def CheckField(self, CheckField):
        self._CheckField = CheckField

    @property
    def EventId(self):
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Rule(self):
        return self._Rule

    @Rule.setter
    def Rule(self, Rule):
        self._Rule = Rule

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._CheckField = params.get("CheckField")
        self._EventId = params.get("EventId")
        self._Name = params.get("Name")
        self._Rule = params.get("Rule")
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckBashRuleParamsResponse(AbstractModel):
    """CheckBashRuleParams返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ErrCode: 0=校验通过  1=规则名称校验不通过 2=正则表达式校验不通过
        :type ErrCode: int
        :param _ErrMsg: 校验信息
        :type ErrMsg: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ErrCode = None
        self._ErrMsg = None
        self._RequestId = None

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def ErrMsg(self):
        return self._ErrMsg

    @ErrMsg.setter
    def ErrMsg(self, ErrMsg):
        self._ErrMsg = ErrMsg

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ErrCode = params.get("ErrCode")
        self._ErrMsg = params.get("ErrMsg")
        self._RequestId = params.get("RequestId")


class ComponentStatistics(AbstractModel):
    """组件统计数据。

    """

    def __init__(self):
        r"""
        :param _Id: 组件ID。
        :type Id: int
        :param _MachineNum: 主机数量。
        :type MachineNum: int
        :param _ComponentName: 组件名称。
        :type ComponentName: str
        :param _ComponentType: 组件类型。
<li>WEB：Web组件</li>
<li>SYSTEM：系统组件</li>
        :type ComponentType: str
        :param _Description: 组件描述。
        :type Description: str
        """
        self._Id = None
        self._MachineNum = None
        self._ComponentName = None
        self._ComponentType = None
        self._Description = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def MachineNum(self):
        return self._MachineNum

    @MachineNum.setter
    def MachineNum(self, MachineNum):
        self._MachineNum = MachineNum

    @property
    def ComponentName(self):
        return self._ComponentName

    @ComponentName.setter
    def ComponentName(self, ComponentName):
        self._ComponentName = ComponentName

    @property
    def ComponentType(self):
        return self._ComponentType

    @ComponentType.setter
    def ComponentType(self, ComponentType):
        self._ComponentType = ComponentType

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._MachineNum = params.get("MachineNum")
        self._ComponentName = params.get("ComponentName")
        self._ComponentType = params.get("ComponentType")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateBaselineStrategyRequest(AbstractModel):
    """CreateBaselineStrategy请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StrategyName: 策略名称
        :type StrategyName: str
        :param _ScanCycle: 检测周期, 表示每隔多少天进行检测.示例: 2, 表示每2天进行检测一次.
        :type ScanCycle: int
        :param _ScanAt: 定期检测时间，该时间下发扫描. 示例:“22:00”, 表示在22:00下发检测
        :type ScanAt: str
        :param _CategoryIds: 该策略下选择的基线id数组. 示例: [1,3,5,7]
        :type CategoryIds: list of int non-negative
        :param _IsGlobal: 扫描范围是否全部服务器, 1:是  0:否, 为1则为全部专业版主机
        :type IsGlobal: int
        :param _MachineType: 云主机类型：
CVM：虚拟主机
BM：裸金属
ECM：边缘计算主机
LH：轻量应用服务器
Other：混合云机器
        :type MachineType: str
        :param _RegionCode: 主机地域. 示例: "ap-guangzhou"
        :type RegionCode: str
        :param _Quuids: 主机id数组. 示例: ["quuid1","quuid2"]
        :type Quuids: list of str
        """
        self._StrategyName = None
        self._ScanCycle = None
        self._ScanAt = None
        self._CategoryIds = None
        self._IsGlobal = None
        self._MachineType = None
        self._RegionCode = None
        self._Quuids = None

    @property
    def StrategyName(self):
        return self._StrategyName

    @StrategyName.setter
    def StrategyName(self, StrategyName):
        self._StrategyName = StrategyName

    @property
    def ScanCycle(self):
        return self._ScanCycle

    @ScanCycle.setter
    def ScanCycle(self, ScanCycle):
        self._ScanCycle = ScanCycle

    @property
    def ScanAt(self):
        return self._ScanAt

    @ScanAt.setter
    def ScanAt(self, ScanAt):
        self._ScanAt = ScanAt

    @property
    def CategoryIds(self):
        return self._CategoryIds

    @CategoryIds.setter
    def CategoryIds(self, CategoryIds):
        self._CategoryIds = CategoryIds

    @property
    def IsGlobal(self):
        return self._IsGlobal

    @IsGlobal.setter
    def IsGlobal(self, IsGlobal):
        self._IsGlobal = IsGlobal

    @property
    def MachineType(self):
        return self._MachineType

    @MachineType.setter
    def MachineType(self, MachineType):
        self._MachineType = MachineType

    @property
    def RegionCode(self):
        return self._RegionCode

    @RegionCode.setter
    def RegionCode(self, RegionCode):
        self._RegionCode = RegionCode

    @property
    def Quuids(self):
        return self._Quuids

    @Quuids.setter
    def Quuids(self, Quuids):
        self._Quuids = Quuids


    def _deserialize(self, params):
        self._StrategyName = params.get("StrategyName")
        self._ScanCycle = params.get("ScanCycle")
        self._ScanAt = params.get("ScanAt")
        self._CategoryIds = params.get("CategoryIds")
        self._IsGlobal = params.get("IsGlobal")
        self._MachineType = params.get("MachineType")
        self._RegionCode = params.get("RegionCode")
        self._Quuids = params.get("Quuids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateBaselineStrategyResponse(AbstractModel):
    """CreateBaselineStrategy返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateEmergencyVulScanRequest(AbstractModel):
    """CreateEmergencyVulScan请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VulId: 漏洞id
        :type VulId: int
        :param _Uuids: 自选服务器时生效，主机uuid的string数组
        :type Uuids: list of str
        :param _TimeoutPeriod: 扫描超时时长 ，单位秒
        :type TimeoutPeriod: int
        """
        self._VulId = None
        self._Uuids = None
        self._TimeoutPeriod = None

    @property
    def VulId(self):
        return self._VulId

    @VulId.setter
    def VulId(self, VulId):
        self._VulId = VulId

    @property
    def Uuids(self):
        return self._Uuids

    @Uuids.setter
    def Uuids(self, Uuids):
        self._Uuids = Uuids

    @property
    def TimeoutPeriod(self):
        return self._TimeoutPeriod

    @TimeoutPeriod.setter
    def TimeoutPeriod(self, TimeoutPeriod):
        self._TimeoutPeriod = TimeoutPeriod


    def _deserialize(self, params):
        self._VulId = params.get("VulId")
        self._Uuids = params.get("Uuids")
        self._TimeoutPeriod = params.get("TimeoutPeriod")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateEmergencyVulScanResponse(AbstractModel):
    """CreateEmergencyVulScan返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateLicenseOrderRequest(AbstractModel):
    """CreateLicenseOrder请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Tags: 标签数组, 空则表示不需要绑定标签
        :type Tags: list of Tags
        :param _LicenseType: 授权类型, 0 专业版-按量计费, 1专业版-包年包月 , 2 旗舰版-包年包月
默认为0
        :type LicenseType: int
        :param _LicenseNum: 授权数量 , 需要购买的数量.
默认为1
        :type LicenseNum: int
        :param _RegionId: 购买订单地域,这里仅支持 1 广州,9 新加坡. 推荐选择广州. 新加坡地域为白名单用户购买.
默认为1
        :type RegionId: int
        :param _ProjectId: 项目ID .
默认为0
        :type ProjectId: int
        :param _TimeSpan: 购买时间长度,默认1 , 可选值为1,2,3,4,5,6,7,8,9,10,11,12,24,36
该参数仅包年包月生效
        :type TimeSpan: int
        :param _AutoRenewFlag: 是否自动续费, 默认不自动续费.
该参数仅包年包月生效
        :type AutoRenewFlag: bool
        :param _AutoProtectOpenConfig: 该字段作废
        :type AutoProtectOpenConfig: str
        :param _ModifyConfig: 变配参数
        :type ModifyConfig: :class:`tencentcloud.cwp.v20180228.models.OrderModifyObject`
        """
        self._Tags = None
        self._LicenseType = None
        self._LicenseNum = None
        self._RegionId = None
        self._ProjectId = None
        self._TimeSpan = None
        self._AutoRenewFlag = None
        self._AutoProtectOpenConfig = None
        self._ModifyConfig = None

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def LicenseType(self):
        return self._LicenseType

    @LicenseType.setter
    def LicenseType(self, LicenseType):
        self._LicenseType = LicenseType

    @property
    def LicenseNum(self):
        return self._LicenseNum

    @LicenseNum.setter
    def LicenseNum(self, LicenseNum):
        self._LicenseNum = LicenseNum

    @property
    def RegionId(self):
        return self._RegionId

    @RegionId.setter
    def RegionId(self, RegionId):
        self._RegionId = RegionId

    @property
    def ProjectId(self):
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TimeSpan(self):
        return self._TimeSpan

    @TimeSpan.setter
    def TimeSpan(self, TimeSpan):
        self._TimeSpan = TimeSpan

    @property
    def AutoRenewFlag(self):
        return self._AutoRenewFlag

    @AutoRenewFlag.setter
    def AutoRenewFlag(self, AutoRenewFlag):
        self._AutoRenewFlag = AutoRenewFlag

    @property
    def AutoProtectOpenConfig(self):
        return self._AutoProtectOpenConfig

    @AutoProtectOpenConfig.setter
    def AutoProtectOpenConfig(self, AutoProtectOpenConfig):
        self._AutoProtectOpenConfig = AutoProtectOpenConfig

    @property
    def ModifyConfig(self):
        return self._ModifyConfig

    @ModifyConfig.setter
    def ModifyConfig(self, ModifyConfig):
        self._ModifyConfig = ModifyConfig


    def _deserialize(self, params):
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tags()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._LicenseType = params.get("LicenseType")
        self._LicenseNum = params.get("LicenseNum")
        self._RegionId = params.get("RegionId")
        self._ProjectId = params.get("ProjectId")
        self._TimeSpan = params.get("TimeSpan")
        self._AutoRenewFlag = params.get("AutoRenewFlag")
        self._AutoProtectOpenConfig = params.get("AutoProtectOpenConfig")
        if params.get("ModifyConfig") is not None:
            self._ModifyConfig = OrderModifyObject()
            self._ModifyConfig._deserialize(params.get("ModifyConfig"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateLicenseOrderResponse(AbstractModel):
    """CreateLicenseOrder返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DealNames: 订单号列表
        :type DealNames: list of str
        :param _ResourceIds: 资源ID列表,预付费订单该字段空值
        :type ResourceIds: list of str
        :param _BigDealId: 大订单号 , 后付费该字段空值
        :type BigDealId: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DealNames = None
        self._ResourceIds = None
        self._BigDealId = None
        self._RequestId = None

    @property
    def DealNames(self):
        return self._DealNames

    @DealNames.setter
    def DealNames(self, DealNames):
        self._DealNames = DealNames

    @property
    def ResourceIds(self):
        return self._ResourceIds

    @ResourceIds.setter
    def ResourceIds(self, ResourceIds):
        self._ResourceIds = ResourceIds

    @property
    def BigDealId(self):
        return self._BigDealId

    @BigDealId.setter
    def BigDealId(self, BigDealId):
        self._BigDealId = BigDealId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DealNames = params.get("DealNames")
        self._ResourceIds = params.get("ResourceIds")
        self._BigDealId = params.get("BigDealId")
        self._RequestId = params.get("RequestId")


class CreateProtectServerRequest(AbstractModel):
    """CreateProtectServer请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ProtectDir: 防护目录地址
        :type ProtectDir: str
        :param _ProtectHostConfig: 防护机器 信息
        :type ProtectHostConfig: list of ProtectHostConfig
        """
        self._ProtectDir = None
        self._ProtectHostConfig = None

    @property
    def ProtectDir(self):
        return self._ProtectDir

    @ProtectDir.setter
    def ProtectDir(self, ProtectDir):
        self._ProtectDir = ProtectDir

    @property
    def ProtectHostConfig(self):
        return self._ProtectHostConfig

    @ProtectHostConfig.setter
    def ProtectHostConfig(self, ProtectHostConfig):
        self._ProtectHostConfig = ProtectHostConfig


    def _deserialize(self, params):
        self._ProtectDir = params.get("ProtectDir")
        if params.get("ProtectHostConfig") is not None:
            self._ProtectHostConfig = []
            for item in params.get("ProtectHostConfig"):
                obj = ProtectHostConfig()
                obj._deserialize(item)
                self._ProtectHostConfig.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateProtectServerResponse(AbstractModel):
    """CreateProtectServer返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateScanMalwareSettingRequest(AbstractModel):
    """CreateScanMalwareSetting请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ScanPattern: 扫描模式 0 全盘扫描, 1 快速扫描
        :type ScanPattern: int
        :param _HostType: 服务器分类：1:专业版服务器；2:自选服务器
        :type HostType: int
        :param _QuuidList: 自选服务器时生效，主机quuid的string数组
        :type QuuidList: list of str
        :param _TimeoutPeriod: 超时时间单位 秒 默认3600 秒
        :type TimeoutPeriod: int
        :param _EngineType: 1标准模式（只报严重、高危）、2增强模式（报严重、高危、中危）、3严格模式（报严重、高、中、低、提示）
        :type EngineType: int
        :param _EnableMemShellScan: 是否开启恶意进程查杀[0:未开启,1:开启]
        :type EnableMemShellScan: int
        """
        self._ScanPattern = None
        self._HostType = None
        self._QuuidList = None
        self._TimeoutPeriod = None
        self._EngineType = None
        self._EnableMemShellScan = None

    @property
    def ScanPattern(self):
        return self._ScanPattern

    @ScanPattern.setter
    def ScanPattern(self, ScanPattern):
        self._ScanPattern = ScanPattern

    @property
    def HostType(self):
        return self._HostType

    @HostType.setter
    def HostType(self, HostType):
        self._HostType = HostType

    @property
    def QuuidList(self):
        return self._QuuidList

    @QuuidList.setter
    def QuuidList(self, QuuidList):
        self._QuuidList = QuuidList

    @property
    def TimeoutPeriod(self):
        return self._TimeoutPeriod

    @TimeoutPeriod.setter
    def TimeoutPeriod(self, TimeoutPeriod):
        self._TimeoutPeriod = TimeoutPeriod

    @property
    def EngineType(self):
        return self._EngineType

    @EngineType.setter
    def EngineType(self, EngineType):
        self._EngineType = EngineType

    @property
    def EnableMemShellScan(self):
        return self._EnableMemShellScan

    @EnableMemShellScan.setter
    def EnableMemShellScan(self, EnableMemShellScan):
        self._EnableMemShellScan = EnableMemShellScan


    def _deserialize(self, params):
        self._ScanPattern = params.get("ScanPattern")
        self._HostType = params.get("HostType")
        self._QuuidList = params.get("QuuidList")
        self._TimeoutPeriod = params.get("TimeoutPeriod")
        self._EngineType = params.get("EngineType")
        self._EnableMemShellScan = params.get("EnableMemShellScan")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateScanMalwareSettingResponse(AbstractModel):
    """CreateScanMalwareSetting返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateSearchLogRequest(AbstractModel):
    """CreateSearchLog请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SearchContent: 搜索内容
        :type SearchContent: str
        """
        self._SearchContent = None

    @property
    def SearchContent(self):
        return self._SearchContent

    @SearchContent.setter
    def SearchContent(self, SearchContent):
        self._SearchContent = SearchContent


    def _deserialize(self, params):
        self._SearchContent = params.get("SearchContent")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSearchLogResponse(AbstractModel):
    """CreateSearchLog返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Status: 0：成功，非0：失败
        :type Status: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Status = None
        self._RequestId = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._RequestId = params.get("RequestId")


class CreateSearchTemplateRequest(AbstractModel):
    """CreateSearchTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _SearchTemplate: 搜索模板
        :type SearchTemplate: :class:`tencentcloud.cwp.v20180228.models.SearchTemplate`
        """
        self._SearchTemplate = None

    @property
    def SearchTemplate(self):
        return self._SearchTemplate

    @SearchTemplate.setter
    def SearchTemplate(self, SearchTemplate):
        self._SearchTemplate = SearchTemplate


    def _deserialize(self, params):
        if params.get("SearchTemplate") is not None:
            self._SearchTemplate = SearchTemplate()
            self._SearchTemplate._deserialize(params.get("SearchTemplate"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSearchTemplateResponse(AbstractModel):
    """CreateSearchTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Status: 0：成功，非0：失败
        :type Status: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Status = None
        self._RequestId = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._RequestId = params.get("RequestId")


class DefendAttackLog(AbstractModel):
    """网络攻击日志

    """

    def __init__(self):
        r"""
        :param _Id: 日志ID
        :type Id: int
        :param _Uuid: 客户端ID
        :type Uuid: str
        :param _SrcIp: 来源IP
        :type SrcIp: str
        :param _SrcPort: 来源端口
        :type SrcPort: int
        :param _HttpMethod: 攻击方式
        :type HttpMethod: str
        :param _HttpCgi: 攻击描述
        :type HttpCgi: str
        :param _HttpParam: 攻击参数
        :type HttpParam: str
        :param _VulType: 威胁类型
        :type VulType: str
        :param _CreatedAt: 攻击时间
        :type CreatedAt: str
        :param _MachineIp: 目标服务器IP
        :type MachineIp: str
        :param _MachineName: 目标服务器名称
        :type MachineName: str
        :param _DstIp: 目标IP
        :type DstIp: str
        :param _DstPort: 目标端口
        :type DstPort: int
        :param _HttpContent: 攻击内容
        :type HttpContent: str
        :param _MachineExtraInfo: 主机额外信息
注意：此字段可能返回 null，表示取不到有效值。
        :type MachineExtraInfo: :class:`tencentcloud.cwp.v20180228.models.MachineExtraInfo`
        """
        self._Id = None
        self._Uuid = None
        self._SrcIp = None
        self._SrcPort = None
        self._HttpMethod = None
        self._HttpCgi = None
        self._HttpParam = None
        self._VulType = None
        self._CreatedAt = None
        self._MachineIp = None
        self._MachineName = None
        self._DstIp = None
        self._DstPort = None
        self._HttpContent = None
        self._MachineExtraInfo = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def SrcIp(self):
        return self._SrcIp

    @SrcIp.setter
    def SrcIp(self, SrcIp):
        self._SrcIp = SrcIp

    @property
    def SrcPort(self):
        return self._SrcPort

    @SrcPort.setter
    def SrcPort(self, SrcPort):
        self._SrcPort = SrcPort

    @property
    def HttpMethod(self):
        return self._HttpMethod

    @HttpMethod.setter
    def HttpMethod(self, HttpMethod):
        self._HttpMethod = HttpMethod

    @property
    def HttpCgi(self):
        return self._HttpCgi

    @HttpCgi.setter
    def HttpCgi(self, HttpCgi):
        self._HttpCgi = HttpCgi

    @property
    def HttpParam(self):
        return self._HttpParam

    @HttpParam.setter
    def HttpParam(self, HttpParam):
        self._HttpParam = HttpParam

    @property
    def VulType(self):
        return self._VulType

    @VulType.setter
    def VulType(self, VulType):
        self._VulType = VulType

    @property
    def CreatedAt(self):
        return self._CreatedAt

    @CreatedAt.setter
    def CreatedAt(self, CreatedAt):
        self._CreatedAt = CreatedAt

    @property
    def MachineIp(self):
        return self._MachineIp

    @MachineIp.setter
    def MachineIp(self, MachineIp):
        self._MachineIp = MachineIp

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def DstIp(self):
        return self._DstIp

    @DstIp.setter
    def DstIp(self, DstIp):
        self._DstIp = DstIp

    @property
    def DstPort(self):
        return self._DstPort

    @DstPort.setter
    def DstPort(self, DstPort):
        self._DstPort = DstPort

    @property
    def HttpContent(self):
        return self._HttpContent

    @HttpContent.setter
    def HttpContent(self, HttpContent):
        self._HttpContent = HttpContent

    @property
    def MachineExtraInfo(self):
        return self._MachineExtraInfo

    @MachineExtraInfo.setter
    def MachineExtraInfo(self, MachineExtraInfo):
        self._MachineExtraInfo = MachineExtraInfo


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Uuid = params.get("Uuid")
        self._SrcIp = params.get("SrcIp")
        self._SrcPort = params.get("SrcPort")
        self._HttpMethod = params.get("HttpMethod")
        self._HttpCgi = params.get("HttpCgi")
        self._HttpParam = params.get("HttpParam")
        self._VulType = params.get("VulType")
        self._CreatedAt = params.get("CreatedAt")
        self._MachineIp = params.get("MachineIp")
        self._MachineName = params.get("MachineName")
        self._DstIp = params.get("DstIp")
        self._DstPort = params.get("DstPort")
        self._HttpContent = params.get("HttpContent")
        if params.get("MachineExtraInfo") is not None:
            self._MachineExtraInfo = MachineExtraInfo()
            self._MachineExtraInfo._deserialize(params.get("MachineExtraInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAttackLogsRequest(AbstractModel):
    """DeleteAttackLogs请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Ids: 日志ID数组，最大100条。
        :type Ids: list of int non-negative
        :param _IsAll: 是否全部删除
        :type IsAll: bool
        """
        self._Ids = None
        self._IsAll = None

    @property
    def Ids(self):
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids

    @property
    def IsAll(self):
        return self._IsAll

    @IsAll.setter
    def IsAll(self, IsAll):
        self._IsAll = IsAll


    def _deserialize(self, params):
        self._Ids = params.get("Ids")
        self._IsAll = params.get("IsAll")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAttackLogsResponse(AbstractModel):
    """DeleteAttackLogs返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteBaselinePolicyRequest(AbstractModel):
    """DeleteBaselinePolicy请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PolicyIds: 策略Id
        :type PolicyIds: list of int
        """
        self._PolicyIds = None

    @property
    def PolicyIds(self):
        return self._PolicyIds

    @PolicyIds.setter
    def PolicyIds(self, PolicyIds):
        self._PolicyIds = PolicyIds


    def _deserialize(self, params):
        self._PolicyIds = params.get("PolicyIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteBaselinePolicyResponse(AbstractModel):
    """DeleteBaselinePolicy返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteBaselineRuleIgnoreRequest(AbstractModel):
    """DeleteBaselineRuleIgnore请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleIds: 规则Id
        :type RuleIds: list of int
        """
        self._RuleIds = None

    @property
    def RuleIds(self):
        return self._RuleIds

    @RuleIds.setter
    def RuleIds(self, RuleIds):
        self._RuleIds = RuleIds


    def _deserialize(self, params):
        self._RuleIds = params.get("RuleIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteBaselineRuleIgnoreResponse(AbstractModel):
    """DeleteBaselineRuleIgnore返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteBaselineRuleRequest(AbstractModel):
    """DeleteBaselineRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleId: 规则Id
        :type RuleId: int
        """
        self._RuleId = None

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteBaselineRuleResponse(AbstractModel):
    """DeleteBaselineRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteBaselineStrategyRequest(AbstractModel):
    """DeleteBaselineStrategy请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StrategyId: 基线策略id
        :type StrategyId: int
        """
        self._StrategyId = None

    @property
    def StrategyId(self):
        return self._StrategyId

    @StrategyId.setter
    def StrategyId(self, StrategyId):
        self._StrategyId = StrategyId


    def _deserialize(self, params):
        self._StrategyId = params.get("StrategyId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteBaselineStrategyResponse(AbstractModel):
    """DeleteBaselineStrategy返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteBaselineWeakPasswordRequest(AbstractModel):
    """DeleteBaselineWeakPassword请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PasswordIds: 弱口令Id
        :type PasswordIds: list of int
        """
        self._PasswordIds = None

    @property
    def PasswordIds(self):
        return self._PasswordIds

    @PasswordIds.setter
    def PasswordIds(self, PasswordIds):
        self._PasswordIds = PasswordIds


    def _deserialize(self, params):
        self._PasswordIds = params.get("PasswordIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteBaselineWeakPasswordResponse(AbstractModel):
    """DeleteBaselineWeakPassword返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteBashEventsRequest(AbstractModel):
    """DeleteBashEvents请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Ids: ID数组，最大100条。
        :type Ids: list of int non-negative
        """
        self._Ids = None

    @property
    def Ids(self):
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids


    def _deserialize(self, params):
        self._Ids = params.get("Ids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteBashEventsResponse(AbstractModel):
    """DeleteBashEvents返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteBashRulesRequest(AbstractModel):
    """DeleteBashRules请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Ids: ID数组，最大100条。
        :type Ids: list of int non-negative
        """
        self._Ids = None

    @property
    def Ids(self):
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids


    def _deserialize(self, params):
        self._Ids = params.get("Ids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteBashRulesResponse(AbstractModel):
    """DeleteBashRules返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteBruteAttacksRequest(AbstractModel):
    """DeleteBruteAttacks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Ids: 暴力破解事件Id数组。(最大 100条)
        :type Ids: list of int non-negative
        """
        self._Ids = None

    @property
    def Ids(self):
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids


    def _deserialize(self, params):
        self._Ids = params.get("Ids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteBruteAttacksResponse(AbstractModel):
    """DeleteBruteAttacks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteLicenseRecordRequest(AbstractModel):
    """DeleteLicenseRecord请求参数结构体

    """

    def __init__(self):
        r"""
        :param _LicenseId: 授权ID ,可以用授权订单列表获取.
        :type LicenseId: int
        :param _LicenseType: 授权类型
        :type LicenseType: int
        :param _ResourceId: 资源ID
        :type ResourceId: str
        """
        self._LicenseId = None
        self._LicenseType = None
        self._ResourceId = None

    @property
    def LicenseId(self):
        return self._LicenseId

    @LicenseId.setter
    def LicenseId(self, LicenseId):
        self._LicenseId = LicenseId

    @property
    def LicenseType(self):
        return self._LicenseType

    @LicenseType.setter
    def LicenseType(self, LicenseType):
        self._LicenseType = LicenseType

    @property
    def ResourceId(self):
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId


    def _deserialize(self, params):
        self._LicenseId = params.get("LicenseId")
        self._LicenseType = params.get("LicenseType")
        self._ResourceId = params.get("ResourceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteLicenseRecordResponse(AbstractModel):
    """DeleteLicenseRecord返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteLoginWhiteListRequest(AbstractModel):
    """DeleteLoginWhiteList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Ids: 白名单ID (最大 100 条)
        :type Ids: list of int non-negative
        """
        self._Ids = None

    @property
    def Ids(self):
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids


    def _deserialize(self, params):
        self._Ids = params.get("Ids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteLoginWhiteListResponse(AbstractModel):
    """DeleteLoginWhiteList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteMachineRequest(AbstractModel):
    """DeleteMachine请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Uuid: 主机安全客户端Uuid。
        :type Uuid: str
        """
        self._Uuid = None

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid


    def _deserialize(self, params):
        self._Uuid = params.get("Uuid")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteMachineResponse(AbstractModel):
    """DeleteMachine返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteMachineTagRequest(AbstractModel):
    """DeleteMachineTag请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Rid: 关联的标签ID
        :type Rid: int
        """
        self._Rid = None

    @property
    def Rid(self):
        return self._Rid

    @Rid.setter
    def Rid(self, Rid):
        self._Rid = Rid


    def _deserialize(self, params):
        self._Rid = params.get("Rid")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteMachineTagResponse(AbstractModel):
    """DeleteMachineTag返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteMaliciousRequestsRequest(AbstractModel):
    """DeleteMaliciousRequests请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Ids: 恶意请求记录ID数组，(最大100条)
        :type Ids: list of int non-negative
        """
        self._Ids = None

    @property
    def Ids(self):
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids


    def _deserialize(self, params):
        self._Ids = params.get("Ids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteMaliciousRequestsResponse(AbstractModel):
    """DeleteMaliciousRequests返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteMalwareScanTaskRequest(AbstractModel):
    """DeleteMalwareScanTask请求参数结构体

    """


class DeleteMalwareScanTaskResponse(AbstractModel):
    """DeleteMalwareScanTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteMalwaresRequest(AbstractModel):
    """DeleteMalwares请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Ids: 木马记录ID数组 (最大100条)
        :type Ids: list of int non-negative
        """
        self._Ids = None

    @property
    def Ids(self):
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids


    def _deserialize(self, params):
        self._Ids = params.get("Ids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteMalwaresResponse(AbstractModel):
    """DeleteMalwares返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteNonlocalLoginPlacesRequest(AbstractModel):
    """DeleteNonlocalLoginPlaces请求参数结构体

    """

    def __init__(self):
        r"""
        :param _DelType: 删除异地登录事件的方式，可选值："Ids"、"Ip"、"All"，默认为Ids
        :type DelType: str
        :param _Ids: 异地登录事件ID数组。DelType为Ids或DelType未填时此项必填
        :type Ids: list of int non-negative
        :param _Ip: 异地登录事件的Ip。DelType为Ip时必填
        :type Ip: list of str
        :param _Uuid: 主机Uuid
        :type Uuid: str
        """
        self._DelType = None
        self._Ids = None
        self._Ip = None
        self._Uuid = None

    @property
    def DelType(self):
        return self._DelType

    @DelType.setter
    def DelType(self, DelType):
        self._DelType = DelType

    @property
    def Ids(self):
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids

    @property
    def Ip(self):
        return self._Ip

    @Ip.setter
    def Ip(self, Ip):
        self._Ip = Ip

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid


    def _deserialize(self, params):
        self._DelType = params.get("DelType")
        self._Ids = params.get("Ids")
        self._Ip = params.get("Ip")
        self._Uuid = params.get("Uuid")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteNonlocalLoginPlacesResponse(AbstractModel):
    """DeleteNonlocalLoginPlaces返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeletePrivilegeEventsRequest(AbstractModel):
    """DeletePrivilegeEvents请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Ids: ID数组. (最大100条)
        :type Ids: list of int non-negative
        """
        self._Ids = None

    @property
    def Ids(self):
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids


    def _deserialize(self, params):
        self._Ids = params.get("Ids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeletePrivilegeEventsResponse(AbstractModel):
    """DeletePrivilegeEvents返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeletePrivilegeRulesRequest(AbstractModel):
    """DeletePrivilegeRules请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Ids: ID数组，最大100条。
        :type Ids: list of int non-negative
        """
        self._Ids = None

    @property
    def Ids(self):
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids


    def _deserialize(self, params):
        self._Ids = params.get("Ids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeletePrivilegeRulesResponse(AbstractModel):
    """DeletePrivilegeRules返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteProtectDirRequest(AbstractModel):
    """DeleteProtectDir请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Ids: 删除的目录ID 最大100条
        :type Ids: list of str
        """
        self._Ids = None

    @property
    def Ids(self):
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids


    def _deserialize(self, params):
        self._Ids = params.get("Ids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteProtectDirResponse(AbstractModel):
    """DeleteProtectDir返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteReverseShellEventsRequest(AbstractModel):
    """DeleteReverseShellEvents请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Ids: ID数组. (最大100条)
        :type Ids: list of int non-negative
        """
        self._Ids = None

    @property
    def Ids(self):
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids


    def _deserialize(self, params):
        self._Ids = params.get("Ids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteReverseShellEventsResponse(AbstractModel):
    """DeleteReverseShellEvents返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteReverseShellRulesRequest(AbstractModel):
    """DeleteReverseShellRules请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Ids: ID数组. (最大100条)
        :type Ids: list of int non-negative
        """
        self._Ids = None

    @property
    def Ids(self):
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids


    def _deserialize(self, params):
        self._Ids = params.get("Ids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteReverseShellRulesResponse(AbstractModel):
    """DeleteReverseShellRules返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteScanTaskRequest(AbstractModel):
    """DeleteScanTask请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务Id
        :type TaskId: int
        :param _ModuleType: 模块类型 当前提供 Malware 木马 , Vul 漏洞 , Baseline 基线
        :type ModuleType: str
        :param _QuuidList: 自选服务器时生效，主机quuid的string数组
        :type QuuidList: list of str
        """
        self._TaskId = None
        self._ModuleType = None
        self._QuuidList = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ModuleType(self):
        return self._ModuleType

    @ModuleType.setter
    def ModuleType(self, ModuleType):
        self._ModuleType = ModuleType

    @property
    def QuuidList(self):
        return self._QuuidList

    @QuuidList.setter
    def QuuidList(self, QuuidList):
        self._QuuidList = QuuidList


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ModuleType = params.get("ModuleType")
        self._QuuidList = params.get("QuuidList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteScanTaskResponse(AbstractModel):
    """DeleteScanTask返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteSearchTemplateRequest(AbstractModel):
    """DeleteSearchTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 模板ID
        :type Id: int
        """
        self._Id = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSearchTemplateResponse(AbstractModel):
    """DeleteSearchTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Status: 0：成功，非0：失败
        :type Status: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Status = None
        self._RequestId = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._RequestId = params.get("RequestId")


class DeleteTagsRequest(AbstractModel):
    """DeleteTags请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Ids: 标签ID (最大100 条)
        :type Ids: list of int non-negative
        """
        self._Ids = None

    @property
    def Ids(self):
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids


    def _deserialize(self, params):
        self._Ids = params.get("Ids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteTagsResponse(AbstractModel):
    """DeleteTags返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteWebPageEventLogRequest(AbstractModel):
    """DeleteWebPageEventLog请求参数结构体

    """


class DeleteWebPageEventLogResponse(AbstractModel):
    """DeleteWebPageEventLog返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DescribeAccountStatisticsRequest(AbstractModel):
    """DescribeAccountStatistics请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 返回数量，默认为10，最大值为100。
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>Username - String - 是否必填：否 - 帐号用户名</li>
        :type Filters: list of Filter
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAccountStatisticsResponse(AbstractModel):
    """DescribeAccountStatistics返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 帐号统计列表记录总数。
        :type TotalCount: int
        :param _AccountStatistics: 帐号统计列表。
        :type AccountStatistics: list of AccountStatistics
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._AccountStatistics = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AccountStatistics(self):
        return self._AccountStatistics

    @AccountStatistics.setter
    def AccountStatistics(self, AccountStatistics):
        self._AccountStatistics = AccountStatistics

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AccountStatistics") is not None:
            self._AccountStatistics = []
            for item in params.get("AccountStatistics"):
                obj = AccountStatistics()
                obj._deserialize(item)
                self._AccountStatistics.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAlarmIncidentNodesRequest(AbstractModel):
    """DescribeAlarmIncidentNodes请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Uuid: 机器uuid
        :type Uuid: str
        :param _AlarmVid: 告警vid
        :type AlarmVid: str
        :param _AlarmTime: 告警时间
        :type AlarmTime: int
        :param _TableId: 告警来源表ID
        :type TableId: int
        """
        self._Uuid = None
        self._AlarmVid = None
        self._AlarmTime = None
        self._TableId = None

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def AlarmVid(self):
        return self._AlarmVid

    @AlarmVid.setter
    def AlarmVid(self, AlarmVid):
        self._AlarmVid = AlarmVid

    @property
    def AlarmTime(self):
        return self._AlarmTime

    @AlarmTime.setter
    def AlarmTime(self, AlarmTime):
        self._AlarmTime = AlarmTime

    @property
    def TableId(self):
        return self._TableId

    @TableId.setter
    def TableId(self, TableId):
        self._TableId = TableId


    def _deserialize(self, params):
        self._Uuid = params.get("Uuid")
        self._AlarmVid = params.get("AlarmVid")
        self._AlarmTime = params.get("AlarmTime")
        self._TableId = params.get("TableId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAlarmIncidentNodesResponse(AbstractModel):
    """DescribeAlarmIncidentNodes返回参数结构体

    """

    def __init__(self):
        r"""
        :param _IncidentNodes: 告警点所在事件的所有节点信息,可能包含多事件
注意：此字段可能返回 null，表示取不到有效值。
        :type IncidentNodes: list of IncidentVertexInfo
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._IncidentNodes = None
        self._RequestId = None

    @property
    def IncidentNodes(self):
        return self._IncidentNodes

    @IncidentNodes.setter
    def IncidentNodes(self, IncidentNodes):
        self._IncidentNodes = IncidentNodes

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("IncidentNodes") is not None:
            self._IncidentNodes = []
            for item in params.get("IncidentNodes"):
                obj = IncidentVertexInfo()
                obj._deserialize(item)
                self._IncidentNodes.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAlarmVertexIdRequest(AbstractModel):
    """DescribeAlarmVertexId请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Uuid: 机器uuid
        :type Uuid: str
        :param _StartTime: 开始时间戳
        :type StartTime: int
        :param _EndTime: 结束时间戳
        :type EndTime: int
        """
        self._Uuid = None
        self._StartTime = None
        self._EndTime = None

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._Uuid = params.get("Uuid")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAlarmVertexIdResponse(AbstractModel):
    """DescribeAlarmVertexId返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AlarmVertexIds: 告警点id列表
注意：此字段可能返回 null，表示取不到有效值。
        :type AlarmVertexIds: list of str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AlarmVertexIds = None
        self._RequestId = None

    @property
    def AlarmVertexIds(self):
        return self._AlarmVertexIds

    @AlarmVertexIds.setter
    def AlarmVertexIds(self, AlarmVertexIds):
        self._AlarmVertexIds = AlarmVertexIds

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AlarmVertexIds = params.get("AlarmVertexIds")
        self._RequestId = params.get("RequestId")


class DescribeAssetAppListRequest(AbstractModel):
    """DescribeAssetAppList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Quuid: 查询指定Quuid主机的信息
        :type Quuid: str
        :param _Filters: 过滤条件。
<li>AppName- string - 是否必填：否 - 应用名搜索</li>
<li>IpOrAlias - String - 是否必填：否 - 主机ip或别名筛选</li>
<li>Type - int - 是否必填：否 - 类型	: 仅linux
0: 全部
1: 运维
2 : 数据库
3 : 安全
4 : 可疑应用
5 : 系统架构
6 : 系统应用
7 : WEB服务
99:其他</li>
<li>OsType - uint64 - 是否必填：否 - windows/linux</li>
<li>Os -String 是否必填: 否 - 操作系统( DescribeMachineOsList 接口 值 )</li>
        :type Filters: list of AssetFilters
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Order: 排序方式，asc升序 或 desc降序
        :type Order: str
        :param _By: 排序方式：[FirstTime|ProcessCount]
        :type By: str
        """
        self._Quuid = None
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetAppListResponse(AbstractModel):
    """DescribeAssetAppList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Apps: 应用列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Apps: list of AssetAppBaseInfo
        :param _Total: 总数量
        :type Total: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Apps = None
        self._Total = None
        self._RequestId = None

    @property
    def Apps(self):
        return self._Apps

    @Apps.setter
    def Apps(self, Apps):
        self._Apps = Apps

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Apps") is not None:
            self._Apps = []
            for item in params.get("Apps"):
                obj = AssetAppBaseInfo()
                obj._deserialize(item)
                self._Apps.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeAssetAppProcessListRequest(AbstractModel):
    """DescribeAssetAppProcessList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Quuid: 主机Quuid
        :type Quuid: str
        :param _Uuid: 主机Uuid
        :type Uuid: str
        :param _Name: App名
        :type Name: str
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        """
        self._Quuid = None
        self._Uuid = None
        self._Name = None
        self._Offset = None
        self._Limit = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._Name = params.get("Name")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetAppProcessListResponse(AbstractModel):
    """DescribeAssetAppProcessList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Process: 进程列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Process: list of AssetAppProcessInfo
        :param _Total: 分区总数
        :type Total: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Process = None
        self._Total = None
        self._RequestId = None

    @property
    def Process(self):
        return self._Process

    @Process.setter
    def Process(self, Process):
        self._Process = Process

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Process") is not None:
            self._Process = []
            for item in params.get("Process"):
                obj = AssetAppProcessInfo()
                obj._deserialize(item)
                self._Process.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeAssetCoreModuleInfoRequest(AbstractModel):
    """DescribeAssetCoreModuleInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Quuid: 服务器Quuid
        :type Quuid: str
        :param _Uuid: 服务器Uuid
        :type Uuid: str
        :param _Id: 内核模块ID
        :type Id: str
        """
        self._Quuid = None
        self._Uuid = None
        self._Id = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetCoreModuleInfoResponse(AbstractModel):
    """DescribeAssetCoreModuleInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Module: 内核模块详情
        :type Module: :class:`tencentcloud.cwp.v20180228.models.AssetCoreModuleDetail`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Module = None
        self._RequestId = None

    @property
    def Module(self):
        return self._Module

    @Module.setter
    def Module(self, Module):
        self._Module = Module

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Module") is not None:
            self._Module = AssetCoreModuleDetail()
            self._Module._deserialize(params.get("Module"))
        self._RequestId = params.get("RequestId")


class DescribeAssetCoreModuleListRequest(AbstractModel):
    """DescribeAssetCoreModuleList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Uuid: 服务器Uuid
        :type Uuid: str
        :param _Quuid: 服务器Quuid
        :type Quuid: str
        :param _Filters: 过滤条件。
<li>IpOrAlias - String - 是否必填：否 - 主机ip或别名筛选</li>
<li>Name- string - 是否必填：否 - 包名</li>
<li>User- string - 是否必填：否 - 用户</li>
        :type Filters: list of AssetFilters
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Order: 排序方式，asc升序 或 desc降序
        :type Order: str
        :param _By: 排序依据[Size|FirstTime|ProcessCount|ModuleCount]
        :type By: str
        """
        self._Uuid = None
        self._Quuid = None
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._Order = None
        self._By = None

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Uuid = params.get("Uuid")
        self._Quuid = params.get("Quuid")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetCoreModuleListResponse(AbstractModel):
    """DescribeAssetCoreModuleList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Modules: 列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Modules: list of AssetCoreModuleBaseInfo
        :param _Total: 总数量
        :type Total: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Modules = None
        self._Total = None
        self._RequestId = None

    @property
    def Modules(self):
        return self._Modules

    @Modules.setter
    def Modules(self, Modules):
        self._Modules = Modules

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Modules") is not None:
            self._Modules = []
            for item in params.get("Modules"):
                obj = AssetCoreModuleBaseInfo()
                obj._deserialize(item)
                self._Modules.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeAssetDatabaseInfoRequest(AbstractModel):
    """DescribeAssetDatabaseInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Quuid: 服务器Quuid
        :type Quuid: str
        :param _Uuid: 服务器Uuid
        :type Uuid: str
        :param _Id: 数据库ID
        :type Id: str
        """
        self._Quuid = None
        self._Uuid = None
        self._Id = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetDatabaseInfoResponse(AbstractModel):
    """DescribeAssetDatabaseInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Database: 数据库详情
        :type Database: :class:`tencentcloud.cwp.v20180228.models.AssetDatabaseDetail`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Database = None
        self._RequestId = None

    @property
    def Database(self):
        return self._Database

    @Database.setter
    def Database(self, Database):
        self._Database = Database

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Database") is not None:
            self._Database = AssetDatabaseDetail()
            self._Database._deserialize(params.get("Database"))
        self._RequestId = params.get("RequestId")


class DescribeAssetDatabaseListRequest(AbstractModel):
    """DescribeAssetDatabaseList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Quuid: 查询指定Quuid主机的信息
        :type Quuid: str
        :param _Filters: 过滤条件。
<li>IpOrAlias - String - 是否必填：否 - 主机ip或别名筛选</li>
<li>User- string - 是否必填：否 - 运行用户</li>
<li>Ip - String - 是否必填：否 - 绑定IP</li>
<li>Port - Int - 是否必填：否 - 端口</li>
<li>Name - Int - 是否必填：否 - 数据库名称
0:全部
1:MySQL
2:Redis
3:Oracle
4:MongoDB
5:MemCache
6:PostgreSQL
7:HBase
8:DB2
9:Sybase
10:TiDB</li>
<li>Proto - String - 是否必填：否 - 协议：1:TCP, 2:UDP, 3:未知</li>
<li>OsType - String - 是否必填：否 - 操作系统: linux/windows</li>
<li>Os -String 是否必填: 否 - 操作系统( DescribeMachineOsList 接口 值 )</li>
        :type Filters: list of AssetFilters
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Order: 排序方式，asc升序 或 desc降序
        :type Order: str
        :param _By: 排序方式：[FirstTime]
        :type By: str
        """
        self._Quuid = None
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._Order = None
        self._By = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetDatabaseListResponse(AbstractModel):
    """DescribeAssetDatabaseList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Databases: 列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Databases: list of AssetDatabaseBaseInfo
        :param _Total: 总数量
        :type Total: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Databases = None
        self._Total = None
        self._RequestId = None

    @property
    def Databases(self):
        return self._Databases

    @Databases.setter
    def Databases(self, Databases):
        self._Databases = Databases

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Databases") is not None:
            self._Databases = []
            for item in params.get("Databases"):
                obj = AssetDatabaseBaseInfo()
                obj._deserialize(item)
                self._Databases.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeAssetEnvListRequest(AbstractModel):
    """DescribeAssetEnvList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Uuid: 服务器Uuid
        :type Uuid: str
        :param _Quuid: 服务器Quuid
        :type Quuid: str
        :param _Type: 该字段已废弃，由Filters代替
        :type Type: int
        :param _Filters: 过滤条件。
<li>IpOrAlias - String - 是否必填：否 - 主机ip或别名筛选</li>
<li>Name- string - 是否必填：否 - 环境变量名</li>
<li>Type- int - 是否必填：否 - 类型：0用户变量，1系统变量</li>
        :type Filters: list of AssetFilters
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Order: 排序方式，asc升序 或 desc降序
        :type Order: str
        :param _By: 排序方式：[FirstTime]
        :type By: str
        """
        self._Uuid = None
        self._Quuid = None
        self._Type = None
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._Order = None
        self._By = None

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Uuid = params.get("Uuid")
        self._Quuid = params.get("Quuid")
        self._Type = params.get("Type")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetEnvListResponse(AbstractModel):
    """DescribeAssetEnvList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Envs: 列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Envs: list of AssetEnvBaseInfo
        :param _Total: 总数量
        :type Total: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Envs = None
        self._Total = None
        self._RequestId = None

    @property
    def Envs(self):
        return self._Envs

    @Envs.setter
    def Envs(self, Envs):
        self._Envs = Envs

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Envs") is not None:
            self._Envs = []
            for item in params.get("Envs"):
                obj = AssetEnvBaseInfo()
                obj._deserialize(item)
                self._Envs.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeAssetHostTotalCountRequest(AbstractModel):
    """DescribeAssetHostTotalCount请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Uuid: 主机Uuid
        :type Uuid: str
        :param _Quuid: 主机Quuid
        :type Quuid: str
        """
        self._Uuid = None
        self._Quuid = None

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid


    def _deserialize(self, params):
        self._Uuid = params.get("Uuid")
        self._Quuid = params.get("Quuid")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetHostTotalCountResponse(AbstractModel):
    """DescribeAssetHostTotalCount返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Types: 各项资源数量
system : 资源监控
account: 账号
port: 端口
process: 进程
app: 应用软件
database:数据库
webapp: Web应用
webframe: Web框架
webservice: Web服务
weblocation: Web站点
systempackage: 系统安装包
jar: jar包
initservice:启动服务
env: 环境变量
coremodule: 内核模块
        :type Types: list of AssetKeyVal
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Types = None
        self._RequestId = None

    @property
    def Types(self):
        return self._Types

    @Types.setter
    def Types(self, Types):
        self._Types = Types

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Types") is not None:
            self._Types = []
            for item in params.get("Types"):
                obj = AssetKeyVal()
                obj._deserialize(item)
                self._Types.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAssetInfoRequest(AbstractModel):
    """DescribeAssetInfo请求参数结构体

    """


class DescribeAssetInfoResponse(AbstractModel):
    """DescribeAssetInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _MachineCount: 主机数
        :type MachineCount: int
        :param _AccountCount: 账号数
        :type AccountCount: int
        :param _PortCount: 端口数
        :type PortCount: int
        :param _ProcessCount: 进程数
        :type ProcessCount: int
        :param _SoftwareCount: 软件数
        :type SoftwareCount: int
        :param _DatabaseCount: 数据库数
        :type DatabaseCount: int
        :param _WebAppCount: Web应用数
        :type WebAppCount: int
        :param _WebFrameCount: Web框架数
        :type WebFrameCount: int
        :param _WebServiceCount: Web服务数
        :type WebServiceCount: int
        :param _WebLocationCount: Web站点数
        :type WebLocationCount: int
        :param _AccountNewCount: 账号今日新增
        :type AccountNewCount: int
        :param _PortNewCount: 端口今日新增
        :type PortNewCount: int
        :param _ProcessNewCount: 进程今日新增
        :type ProcessNewCount: int
        :param _SoftwareNewCount: 软件今日新增
        :type SoftwareNewCount: int
        :param _DatabaseNewCount: 数据库今日新增
        :type DatabaseNewCount: int
        :param _WebAppNewCount: Web应用今日新增
        :type WebAppNewCount: int
        :param _WebFrameNewCount: Web框架今日新增
        :type WebFrameNewCount: int
        :param _WebServiceNewCount: Web服务今日新增
        :type WebServiceNewCount: int
        :param _WebLocationNewCount: Web站点今日新增
        :type WebLocationNewCount: int
        :param _MachineNewCount: 主机今日新增
        :type MachineNewCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._MachineCount = None
        self._AccountCount = None
        self._PortCount = None
        self._ProcessCount = None
        self._SoftwareCount = None
        self._DatabaseCount = None
        self._WebAppCount = None
        self._WebFrameCount = None
        self._WebServiceCount = None
        self._WebLocationCount = None
        self._AccountNewCount = None
        self._PortNewCount = None
        self._ProcessNewCount = None
        self._SoftwareNewCount = None
        self._DatabaseNewCount = None
        self._WebAppNewCount = None
        self._WebFrameNewCount = None
        self._WebServiceNewCount = None
        self._WebLocationNewCount = None
        self._MachineNewCount = None
        self._RequestId = None

    @property
    def MachineCount(self):
        return self._MachineCount

    @MachineCount.setter
    def MachineCount(self, MachineCount):
        self._MachineCount = MachineCount

    @property
    def AccountCount(self):
        return self._AccountCount

    @AccountCount.setter
    def AccountCount(self, AccountCount):
        self._AccountCount = AccountCount

    @property
    def PortCount(self):
        return self._PortCount

    @PortCount.setter
    def PortCount(self, PortCount):
        self._PortCount = PortCount

    @property
    def ProcessCount(self):
        return self._ProcessCount

    @ProcessCount.setter
    def ProcessCount(self, ProcessCount):
        self._ProcessCount = ProcessCount

    @property
    def SoftwareCount(self):
        return self._SoftwareCount

    @SoftwareCount.setter
    def SoftwareCount(self, SoftwareCount):
        self._SoftwareCount = SoftwareCount

    @property
    def DatabaseCount(self):
        return self._DatabaseCount

    @DatabaseCount.setter
    def DatabaseCount(self, DatabaseCount):
        self._DatabaseCount = DatabaseCount

    @property
    def WebAppCount(self):
        return self._WebAppCount

    @WebAppCount.setter
    def WebAppCount(self, WebAppCount):
        self._WebAppCount = WebAppCount

    @property
    def WebFrameCount(self):
        return self._WebFrameCount

    @WebFrameCount.setter
    def WebFrameCount(self, WebFrameCount):
        self._WebFrameCount = WebFrameCount

    @property
    def WebServiceCount(self):
        return self._WebServiceCount

    @WebServiceCount.setter
    def WebServiceCount(self, WebServiceCount):
        self._WebServiceCount = WebServiceCount

    @property
    def WebLocationCount(self):
        return self._WebLocationCount

    @WebLocationCount.setter
    def WebLocationCount(self, WebLocationCount):
        self._WebLocationCount = WebLocationCount

    @property
    def AccountNewCount(self):
        return self._AccountNewCount

    @AccountNewCount.setter
    def AccountNewCount(self, AccountNewCount):
        self._AccountNewCount = AccountNewCount

    @property
    def PortNewCount(self):
        return self._PortNewCount

    @PortNewCount.setter
    def PortNewCount(self, PortNewCount):
        self._PortNewCount = PortNewCount

    @property
    def ProcessNewCount(self):
        return self._ProcessNewCount

    @ProcessNewCount.setter
    def ProcessNewCount(self, ProcessNewCount):
        self._ProcessNewCount = ProcessNewCount

    @property
    def SoftwareNewCount(self):
        return self._SoftwareNewCount

    @SoftwareNewCount.setter
    def SoftwareNewCount(self, SoftwareNewCount):
        self._SoftwareNewCount = SoftwareNewCount

    @property
    def DatabaseNewCount(self):
        return self._DatabaseNewCount

    @DatabaseNewCount.setter
    def DatabaseNewCount(self, DatabaseNewCount):
        self._DatabaseNewCount = DatabaseNewCount

    @property
    def WebAppNewCount(self):
        return self._WebAppNewCount

    @WebAppNewCount.setter
    def WebAppNewCount(self, WebAppNewCount):
        self._WebAppNewCount = WebAppNewCount

    @property
    def WebFrameNewCount(self):
        return self._WebFrameNewCount

    @WebFrameNewCount.setter
    def WebFrameNewCount(self, WebFrameNewCount):
        self._WebFrameNewCount = WebFrameNewCount

    @property
    def WebServiceNewCount(self):
        return self._WebServiceNewCount

    @WebServiceNewCount.setter
    def WebServiceNewCount(self, WebServiceNewCount):
        self._WebServiceNewCount = WebServiceNewCount

    @property
    def WebLocationNewCount(self):
        return self._WebLocationNewCount

    @WebLocationNewCount.setter
    def WebLocationNewCount(self, WebLocationNewCount):
        self._WebLocationNewCount = WebLocationNewCount

    @property
    def MachineNewCount(self):
        return self._MachineNewCount

    @MachineNewCount.setter
    def MachineNewCount(self, MachineNewCount):
        self._MachineNewCount = MachineNewCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._MachineCount = params.get("MachineCount")
        self._AccountCount = params.get("AccountCount")
        self._PortCount = params.get("PortCount")
        self._ProcessCount = params.get("ProcessCount")
        self._SoftwareCount = params.get("SoftwareCount")
        self._DatabaseCount = params.get("DatabaseCount")
        self._WebAppCount = params.get("WebAppCount")
        self._WebFrameCount = params.get("WebFrameCount")
        self._WebServiceCount = params.get("WebServiceCount")
        self._WebLocationCount = params.get("WebLocationCount")
        self._AccountNewCount = params.get("AccountNewCount")
        self._PortNewCount = params.get("PortNewCount")
        self._ProcessNewCount = params.get("ProcessNewCount")
        self._SoftwareNewCount = params.get("SoftwareNewCount")
        self._DatabaseNewCount = params.get("DatabaseNewCount")
        self._WebAppNewCount = params.get("WebAppNewCount")
        self._WebFrameNewCount = params.get("WebFrameNewCount")
        self._WebServiceNewCount = params.get("WebServiceNewCount")
        self._WebLocationNewCount = params.get("WebLocationNewCount")
        self._MachineNewCount = params.get("MachineNewCount")
        self._RequestId = params.get("RequestId")


class DescribeAssetInitServiceListRequest(AbstractModel):
    """DescribeAssetInitServiceList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Uuid: 服务器Uuid
        :type Uuid: str
        :param _Quuid: 服务器Quuid
        :type Quuid: str
        :param _Filters: 过滤条件。
<li>IpOrAlias - String - 是否必填：否 - 主机ip或别名筛选</li>
<li>Name- string - 是否必填：否 - 包名</li>
<li>User- string - 是否必填：否 - 用户</li>
<li>Status- string - 是否必填：否 - 默认启用状态：0未启用， 1启用 仅linux</li>
<li>Type- string - 是否必填：否 - 类型：类型 仅windows：
1:编码器
2:IE插件
3:网络提供者
4:镜像劫持
5:LSA提供者
6:KnownDLLs
7:启动执行
8:WMI
9:计划任务
10:Winsock提供者
11:打印监控器
12:资源管理器
13:驱动服务
14:登录</li>
        :type Filters: list of AssetFilters
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Order: 排序方式，asc升序 或 desc降序
        :type Order: str
        :param _By: 排序方式：[FirstTime]
        :type By: str
        """
        self._Uuid = None
        self._Quuid = None
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._Order = None
        self._By = None

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Uuid = params.get("Uuid")
        self._Quuid = params.get("Quuid")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetInitServiceListResponse(AbstractModel):
    """DescribeAssetInitServiceList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Services: 列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Services: list of AssetInitServiceBaseInfo
        :param _Total: 总数量
        :type Total: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Services = None
        self._Total = None
        self._RequestId = None

    @property
    def Services(self):
        return self._Services

    @Services.setter
    def Services(self, Services):
        self._Services = Services

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Services") is not None:
            self._Services = []
            for item in params.get("Services"):
                obj = AssetInitServiceBaseInfo()
                obj._deserialize(item)
                self._Services.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeAssetJarInfoRequest(AbstractModel):
    """DescribeAssetJarInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Quuid: 服务器Quuid
        :type Quuid: str
        :param _Uuid: 服务器Uuid
        :type Uuid: str
        :param _Id: Jar包ID
        :type Id: str
        """
        self._Quuid = None
        self._Uuid = None
        self._Id = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetJarInfoResponse(AbstractModel):
    """DescribeAssetJarInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Jar: Jar包详情
        :type Jar: :class:`tencentcloud.cwp.v20180228.models.AssetJarDetail`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Jar = None
        self._RequestId = None

    @property
    def Jar(self):
        return self._Jar

    @Jar.setter
    def Jar(self, Jar):
        self._Jar = Jar

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Jar") is not None:
            self._Jar = AssetJarDetail()
            self._Jar._deserialize(params.get("Jar"))
        self._RequestId = params.get("RequestId")


class DescribeAssetJarListRequest(AbstractModel):
    """DescribeAssetJarList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Uuid: 服务器Uuid
        :type Uuid: str
        :param _Quuid: 服务器Quuid
        :type Quuid: str
        :param _Filters: 过滤条件。
<li>IpOrAlias - String - 是否必填：否 - 主机ip或别名筛选</li>
<li>Name- string - 是否必填：否 - 包名</li>
<li>Type- uint - 是否必填：否 - 类型	
1: 应用程序
2 : 系统类库
3 : Web服务自带库
4 : 其他依赖包</li>
<li>Status- string - 是否必填：否 - 是否可执行：0否，1是</li>
        :type Filters: list of AssetFilters
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Order: 排序方式，asc升序 或 desc降序
        :type Order: str
        :param _By: 排序方式：[FirstTime]
        :type By: str
        """
        self._Uuid = None
        self._Quuid = None
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._Order = None
        self._By = None

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Uuid = params.get("Uuid")
        self._Quuid = params.get("Quuid")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetJarListResponse(AbstractModel):
    """DescribeAssetJarList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Jars: 应用列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Jars: list of AssetJarBaseInfo
        :param _Total: 总数量
        :type Total: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Jars = None
        self._Total = None
        self._RequestId = None

    @property
    def Jars(self):
        return self._Jars

    @Jars.setter
    def Jars(self, Jars):
        self._Jars = Jars

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Jars") is not None:
            self._Jars = []
            for item in params.get("Jars"):
                obj = AssetJarBaseInfo()
                obj._deserialize(item)
                self._Jars.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeAssetMachineDetailRequest(AbstractModel):
    """DescribeAssetMachineDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Quuid: 服务器Quuid
        :type Quuid: str
        :param _Uuid: 服务器Uuid
        :type Uuid: str
        """
        self._Quuid = None
        self._Uuid = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetMachineDetailResponse(AbstractModel):
    """DescribeAssetMachineDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _MachineDetail: 主机详情
        :type MachineDetail: :class:`tencentcloud.cwp.v20180228.models.AssetMachineDetail`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._MachineDetail = None
        self._RequestId = None

    @property
    def MachineDetail(self):
        return self._MachineDetail

    @MachineDetail.setter
    def MachineDetail(self, MachineDetail):
        self._MachineDetail = MachineDetail

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("MachineDetail") is not None:
            self._MachineDetail = AssetMachineDetail()
            self._MachineDetail._deserialize(params.get("MachineDetail"))
        self._RequestId = params.get("RequestId")


class DescribeAssetMachineListRequest(AbstractModel):
    """DescribeAssetMachineList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤条件。
<li>IpOrAlias - String - 是否必填：否 - 主机ip或别名筛选</li>
<li>OsType - String - 是否必填：否 - windows或linux</li>
<li>CpuLoad - Int - 是否必填：否 - 
0: 未知  1: 低负载
2: 中负载  3: 高负载</li>
<li>DiskLoad - Int - 是否必填：否 - 
0: 0%或未知  1: 0%～20%
2: 20%～50%  3: 50%～80%
4: 80%～100%</li>
<li>MemLoad - Int - 是否必填：否 - 
0: 0%或未知  1: 0%～20%
2: 20%～50%  3: 50%～80%
4: 80%～100%</li>
<li>Quuid：主机Quuid</li>
<li>Os -String 是否必填: 否 - 操作系统( DescribeMachineOsList 接口 值 )</li>
        :type Filters: list of Filter
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Order: 排序方式，asc升序 或 desc降序
        :type Order: str
        :param _By: 可选排序[FirstTime|PartitionCount]
        :type By: str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetMachineListResponse(AbstractModel):
    """DescribeAssetMachineList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Total: 总数
        :type Total: int
        :param _Machines: 记录列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Machines: list of AssetMachineBaseInfo
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Total = None
        self._Machines = None
        self._RequestId = None

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Machines(self):
        return self._Machines

    @Machines.setter
    def Machines(self, Machines):
        self._Machines = Machines

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("Machines") is not None:
            self._Machines = []
            for item in params.get("Machines"):
                obj = AssetMachineBaseInfo()
                obj._deserialize(item)
                self._Machines.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAssetPlanTaskListRequest(AbstractModel):
    """DescribeAssetPlanTaskList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Uuid: 服务器Uuid
        :type Uuid: str
        :param _Quuid: 服务器Quuid
        :type Quuid: str
        :param _Filters: 过滤条件。
<li>IpOrAlias - String - 是否必填：否 - 主机ip或别名筛选</li>
<li>User- string - 是否必填：否 - 用户</li>
<li>Status- int - 是否必填：否 - 默认启用状态：0未启用， 1启用 </li>
        :type Filters: list of AssetFilters
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Order: 排序方式，asc升序 或 desc降序
        :type Order: str
        :param _By: 排序方式：[FirstTime]
        :type By: str
        """
        self._Uuid = None
        self._Quuid = None
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._Order = None
        self._By = None

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Uuid = params.get("Uuid")
        self._Quuid = params.get("Quuid")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetPlanTaskListResponse(AbstractModel):
    """DescribeAssetPlanTaskList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Tasks: 列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Tasks: list of AssetPlanTask
        :param _Total: 总数量
        :type Total: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Tasks = None
        self._Total = None
        self._RequestId = None

    @property
    def Tasks(self):
        return self._Tasks

    @Tasks.setter
    def Tasks(self, Tasks):
        self._Tasks = Tasks

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Tasks") is not None:
            self._Tasks = []
            for item in params.get("Tasks"):
                obj = AssetPlanTask()
                obj._deserialize(item)
                self._Tasks.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeAssetPortInfoListRequest(AbstractModel):
    """DescribeAssetPortInfoList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Quuid: 查询指定Quuid主机的信息
        :type Quuid: str
        :param _Filters: 过滤条件。
<li>Port - uint64 - 是否必填：否 - 端口</li>
<li>Ip - String - 是否必填：否 - 绑定IP</li>
<li>ProcessName - String - 是否必填：否 - 监听进程</li>
<li>Pid - uint64 - 是否必填：否 - PID</li>
<li>User - String - 是否必填：否 - 运行用户</li>
<li>Group - String - 是否必填：否 - 所属用户组</li>
<li>Ppid - uint64 - 是否必填：否 - PPID</li>
<li>Proto - string - 是否必填：否 - tcp/udp或“”(空字符串筛选未知状态)</li>
<li>OsType - uint64 - 是否必填：否 - windows/linux</li>
<li>RunTimeStart - String - 是否必填：否 - 运行开始时间</li>
<li>RunTimeEnd - String - 是否必填：否 - 运行结束时间</li>
<li>Os -String 是否必填: 否 - 操作系统( DescribeMachineOsList 接口 值 )</li>
        :type Filters: list of Filter
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Order: 排序方式，asc升序 或 desc降序
        :type Order: str
        :param _By: 排序方式：[FirstTime|StartTime]
        :type By: str
        """
        self._Quuid = None
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetPortInfoListResponse(AbstractModel):
    """DescribeAssetPortInfoList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Total: 记录总数
        :type Total: int
        :param _Ports: 列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Ports: list of AssetPortBaseInfo
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Total = None
        self._Ports = None
        self._RequestId = None

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Ports(self):
        return self._Ports

    @Ports.setter
    def Ports(self, Ports):
        self._Ports = Ports

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("Ports") is not None:
            self._Ports = []
            for item in params.get("Ports"):
                obj = AssetPortBaseInfo()
                obj._deserialize(item)
                self._Ports.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAssetProcessInfoListRequest(AbstractModel):
    """DescribeAssetProcessInfoList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Quuid: 查询指定Quuid主机的信息
        :type Quuid: str
        :param _Filters: 过滤条件。
<li>IpOrAlias - String - 是否必填：否 - 主机ip或别名筛选</li>
<li>Name - String - 是否必填：否 - 进程名</li>
<li>User - String - 是否必填：否 - 进程用户</li>
<li>Group - String - 是否必填：否 - 进程用户组</li>
<li>Pid - uint64 - 是否必填：否 - 进程ID</li>
<li>Ppid - uint64 - 是否必填：否 - 父进程ID</li>
<li>OsType - uint64 - 是否必填：否 - windows/linux</li>
<li>Status - string - 是否必填：否 - 进程状态：
1:R 可执行
2:S 可中断
3:D 不可中断
4:T 暂停状态或跟踪状态
5:Z 僵尸状态
6:X 将被销毁</li>
<li>RunTimeStart - String - 是否必填：否 - 运行开始时间</li>
<li>RunTimeEnd - String - 是否必填：否 - 运行结束时间</li>
<li>InstallByPackage - uint64 - 是否必填：否 - 是否包安装：0否，1是</li>
<li>Os -String 是否必填: 否 - 操作系统( DescribeMachineOsList 接口 值 )</li>
        :type Filters: list of Filter
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Order: 排序方式，asc升序 或 desc降序
        :type Order: str
        :param _By: 排序方式：[FirstTime|StartTime]
        :type By: str
        """
        self._Quuid = None
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetProcessInfoListResponse(AbstractModel):
    """DescribeAssetProcessInfoList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Total: 记录总数
        :type Total: int
        :param _Process: 列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Process: list of AssetProcessBaseInfo
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Total = None
        self._Process = None
        self._RequestId = None

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Process(self):
        return self._Process

    @Process.setter
    def Process(self, Process):
        self._Process = Process

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("Process") is not None:
            self._Process = []
            for item in params.get("Process"):
                obj = AssetProcessBaseInfo()
                obj._deserialize(item)
                self._Process.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAssetRecentMachineInfoRequest(AbstractModel):
    """DescribeAssetRecentMachineInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _BeginDate: 开始时间，如：2020-09-22
        :type BeginDate: str
        :param _EndDate: 结束时间，如：2020-09-22
        :type EndDate: str
        """
        self._BeginDate = None
        self._EndDate = None

    @property
    def BeginDate(self):
        return self._BeginDate

    @BeginDate.setter
    def BeginDate(self, BeginDate):
        self._BeginDate = BeginDate

    @property
    def EndDate(self):
        return self._EndDate

    @EndDate.setter
    def EndDate(self, EndDate):
        self._EndDate = EndDate


    def _deserialize(self, params):
        self._BeginDate = params.get("BeginDate")
        self._EndDate = params.get("EndDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetRecentMachineInfoResponse(AbstractModel):
    """DescribeAssetRecentMachineInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalList: 总数量列表
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalList: list of AssetKeyVal
        :param _LiveList: 在线数量列表
注意：此字段可能返回 null，表示取不到有效值。
        :type LiveList: list of AssetKeyVal
        :param _OfflineList: 离线数量列表
注意：此字段可能返回 null，表示取不到有效值。
        :type OfflineList: list of AssetKeyVal
        :param _RiskList: 风险数量列表
注意：此字段可能返回 null，表示取不到有效值。
        :type RiskList: list of AssetKeyVal
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalList = None
        self._LiveList = None
        self._OfflineList = None
        self._RiskList = None
        self._RequestId = None

    @property
    def TotalList(self):
        return self._TotalList

    @TotalList.setter
    def TotalList(self, TotalList):
        self._TotalList = TotalList

    @property
    def LiveList(self):
        return self._LiveList

    @LiveList.setter
    def LiveList(self, LiveList):
        self._LiveList = LiveList

    @property
    def OfflineList(self):
        return self._OfflineList

    @OfflineList.setter
    def OfflineList(self, OfflineList):
        self._OfflineList = OfflineList

    @property
    def RiskList(self):
        return self._RiskList

    @RiskList.setter
    def RiskList(self, RiskList):
        self._RiskList = RiskList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TotalList") is not None:
            self._TotalList = []
            for item in params.get("TotalList"):
                obj = AssetKeyVal()
                obj._deserialize(item)
                self._TotalList.append(obj)
        if params.get("LiveList") is not None:
            self._LiveList = []
            for item in params.get("LiveList"):
                obj = AssetKeyVal()
                obj._deserialize(item)
                self._LiveList.append(obj)
        if params.get("OfflineList") is not None:
            self._OfflineList = []
            for item in params.get("OfflineList"):
                obj = AssetKeyVal()
                obj._deserialize(item)
                self._OfflineList.append(obj)
        if params.get("RiskList") is not None:
            self._RiskList = []
            for item in params.get("RiskList"):
                obj = AssetKeyVal()
                obj._deserialize(item)
                self._RiskList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAssetSystemPackageListRequest(AbstractModel):
    """DescribeAssetSystemPackageList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Uuid: 主机Uuid
        :type Uuid: str
        :param _Quuid: 主机Quuid
        :type Quuid: str
        :param _Filters: 过滤条件。
<li>Name - String - 是否必填：否 - 包 名</li>
<li>StartTime - String - 是否必填：否 - 安装开始时间</li>
<li>EndTime - String - 是否必填：否 - 安装开始时间</li>
<li>Type - int - 是否必填：否 - 安装包类型：
1:rmp
2:dpkg
3:java
4:system</li>
        :type Filters: list of Filter
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Order: 排序方式，asc-升序 或 desc-降序。默认：desc-降序
        :type Order: str
        :param _By: 排序方式可选：[FistTime|InstallTime:安装时间]
        :type By: str
        """
        self._Uuid = None
        self._Quuid = None
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._Order = None
        self._By = None

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Uuid = params.get("Uuid")
        self._Quuid = params.get("Quuid")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetSystemPackageListResponse(AbstractModel):
    """DescribeAssetSystemPackageList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Total: 记录总数
        :type Total: int
        :param _Packages: 列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Packages: list of AssetSystemPackageInfo
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Total = None
        self._Packages = None
        self._RequestId = None

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Packages(self):
        return self._Packages

    @Packages.setter
    def Packages(self, Packages):
        self._Packages = Packages

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("Packages") is not None:
            self._Packages = []
            for item in params.get("Packages"):
                obj = AssetSystemPackageInfo()
                obj._deserialize(item)
                self._Packages.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAssetUserInfoRequest(AbstractModel):
    """DescribeAssetUserInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Quuid: 云服务器UUID
        :type Quuid: str
        :param _Uuid: 主机安全UUID
        :type Uuid: str
        :param _Name: 账户名
        :type Name: str
        """
        self._Quuid = None
        self._Uuid = None
        self._Name = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetUserInfoResponse(AbstractModel):
    """DescribeAssetUserInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _User: 用户详细信息
        :type User: :class:`tencentcloud.cwp.v20180228.models.AssetUserDetail`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._User = None
        self._RequestId = None

    @property
    def User(self):
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("User") is not None:
            self._User = AssetUserDetail()
            self._User._deserialize(params.get("User"))
        self._RequestId = params.get("RequestId")


class DescribeAssetUserListRequest(AbstractModel):
    """DescribeAssetUserList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Quuid: 查询指定Quuid主机的信息
        :type Quuid: str
        :param _Filters: 过滤条件。
<li>IpOrAlias - String - 是否必填：否 - 主机ip或别名筛选</li>
<li>Name - String - 是否必填：否 - 账户名（模糊匹配）</li>
<li>NameStrict - String - 是否必填：否 - 账户名（严格匹配）</li>
<li>Uid - uint64 - 是否必填：否 - Uid</li>
<li>Guid - uint64 - 是否必填：否 - Guid</li>
<li>LoginTimeStart - String - 是否必填：否 - 开始时间，如：2021-01-11</li>
<li>LoginTimeEnd - String - 是否必填：否 - 结束时间，如：2021-01-11</li>
<li>LoginType - uint64 - 是否必填：否 - 0-不可登录；1-只允许key登录；2只允许密码登录；3-允许key和密码 仅linux</li>
<li>OsType - String - 是否必填：否 - windows或linux</li>
<li>Status - uint64 - 是否必填：否 - 账号状态：0-禁用；1-启用</li>
<li>UserType - uint64 - 是否必填：否 - 账号类型：0访客用户，1标准用户，2管理员用户 仅windows</li>
<li>IsDomain - uint64 - 是否必填：否 - 是否域账号：0 不是，1是 仅windows
<li>IsRoot - uint64 - 是否必填：否 - 是否Root权限：0 不是，1是 仅linux
<li>IsSudo - uint64 - 是否必填：否 - 是否Sudo权限：0 不是，1是 仅linux</li>
<li>IsSshLogin - uint64 - 是否必填：否 - 是否ssh登录：0 不是，1是 仅linux</li>
<li>ShellLoginStatus - uint64 - 是否必填：否 - 是否shell登录性，0不是；1是 仅linux</li>
<li>PasswordStatus - uint64 - 是否必填：否 - 密码状态：1正常 2即将过期 3已过期 4已锁定 仅linux</li>
<li>Os -String 是否必填: 否 - 操作系统( DescribeMachineOsList 接口 值 )</li>
        :type Filters: list of Filter
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Order: 排序方式，asc升序 或 desc降序
        :type Order: str
        :param _By: 可选排序：[FirstTime|LoginTime|PasswordChangeTime|PasswordDuaTime]
PasswordLockDays
        :type By: str
        """
        self._Quuid = None
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetUserListResponse(AbstractModel):
    """DescribeAssetUserList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Total: 记录总数
        :type Total: int
        :param _Users: 账号列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Users: list of AssetUserBaseInfo
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Total = None
        self._Users = None
        self._RequestId = None

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Users(self):
        return self._Users

    @Users.setter
    def Users(self, Users):
        self._Users = Users

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("Users") is not None:
            self._Users = []
            for item in params.get("Users"):
                obj = AssetUserBaseInfo()
                obj._deserialize(item)
                self._Users.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAssetWebAppListRequest(AbstractModel):
    """DescribeAssetWebAppList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Quuid: 查询指定Quuid主机的信息
        :type Quuid: str
        :param _Filters: 过滤条件。
<li>IpOrAlias - String - 是否必填：否 - 主机ip或别名筛选</li>
<li>Name - String - 是否必填：否 - 应用名</li>
<li>Domain - String - 是否必填：否 - 站点域名</li>
<li>Type - int - 是否必填：否 - 服务类型：
0：全部
1:Tomcat
2:Apache
3:Nginx
4:WebLogic
5:Websphere
6:JBoss
7:Jetty
8:IHS
9:Tengine</li>
<li>OsType - String - 是否必填：否 - windows/linux</li>
<li>Os -String 是否必填: 否 - 操作系统( DescribeMachineOsList 接口 值 )</li>
        :type Filters: list of Filter
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Order: 排序方式，asc升序 或 desc降序
        :type Order: str
        :param _By: 可选排序：[FirstTime|PluginCount]
        :type By: str
        """
        self._Quuid = None
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._Order = None
        self._By = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetWebAppListResponse(AbstractModel):
    """DescribeAssetWebAppList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Total: 记录总数
        :type Total: int
        :param _WebApps: 列表
注意：此字段可能返回 null，表示取不到有效值。
        :type WebApps: list of AssetWebAppBaseInfo
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Total = None
        self._WebApps = None
        self._RequestId = None

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def WebApps(self):
        return self._WebApps

    @WebApps.setter
    def WebApps(self, WebApps):
        self._WebApps = WebApps

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("WebApps") is not None:
            self._WebApps = []
            for item in params.get("WebApps"):
                obj = AssetWebAppBaseInfo()
                obj._deserialize(item)
                self._WebApps.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAssetWebAppPluginListRequest(AbstractModel):
    """DescribeAssetWebAppPluginList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Quuid: 主机Quuid
        :type Quuid: str
        :param _Uuid: 主机Uuid
        :type Uuid: str
        :param _Id: Web应用ID
        :type Id: str
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        """
        self._Quuid = None
        self._Uuid = None
        self._Id = None
        self._Offset = None
        self._Limit = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._Id = params.get("Id")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetWebAppPluginListResponse(AbstractModel):
    """DescribeAssetWebAppPluginList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Plugins: 列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Plugins: list of AssetWebAppPluginInfo
        :param _Total: 分区总数
        :type Total: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Plugins = None
        self._Total = None
        self._RequestId = None

    @property
    def Plugins(self):
        return self._Plugins

    @Plugins.setter
    def Plugins(self, Plugins):
        self._Plugins = Plugins

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Plugins") is not None:
            self._Plugins = []
            for item in params.get("Plugins"):
                obj = AssetWebAppPluginInfo()
                obj._deserialize(item)
                self._Plugins.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeAssetWebFrameListRequest(AbstractModel):
    """DescribeAssetWebFrameList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Quuid: 查询指定Quuid主机的信息
        :type Quuid: str
        :param _Filters: 过滤条件。
<li>IpOrAlias - String - 是否必填：否 - 主机ip或别名筛选</li>
<li>Name - String - 是否必填：否 - 框架名</li>
<li>NameStrict - String - 是否必填：否 - 框架名（严格匹配）</li>
<li>Lang - String - 是否必填：否 - 框架语言:java/python</li>
<li>Type - String - 是否必填：否 - 服务类型：
0：全部
1:Tomcat
2:Apache
3:Nginx
4:WebLogic
5:Websphere
6:JBoss
7:WildFly
8:Jetty
9:IHS
10:Tengine</li>
<li>OsType - String - 是否必填：否 - windows/linux</li>
<li>Os -String 是否必填: 否 - 操作系统( DescribeMachineOsList 接口 值 )</li>
        :type Filters: list of Filter
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Order: 排序方式，asc升序 或 desc降序
        :type Order: str
        :param _By: 可选排序：[FirstTime|JarCount]
        :type By: str
        """
        self._Quuid = None
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._Order = None
        self._By = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetWebFrameListResponse(AbstractModel):
    """DescribeAssetWebFrameList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Total: 记录总数
        :type Total: int
        :param _WebFrames: 列表
注意：此字段可能返回 null，表示取不到有效值。
        :type WebFrames: list of AssetWebFrameBaseInfo
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Total = None
        self._WebFrames = None
        self._RequestId = None

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def WebFrames(self):
        return self._WebFrames

    @WebFrames.setter
    def WebFrames(self, WebFrames):
        self._WebFrames = WebFrames

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("WebFrames") is not None:
            self._WebFrames = []
            for item in params.get("WebFrames"):
                obj = AssetWebFrameBaseInfo()
                obj._deserialize(item)
                self._WebFrames.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAssetWebLocationInfoRequest(AbstractModel):
    """DescribeAssetWebLocationInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Quuid: 服务器Quuid
        :type Quuid: str
        :param _Uuid: 服务器Uuid
        :type Uuid: str
        :param _Id: 站点Id
        :type Id: str
        """
        self._Quuid = None
        self._Uuid = None
        self._Id = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetWebLocationInfoResponse(AbstractModel):
    """DescribeAssetWebLocationInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _WebLocation: 站点信息
注意：此字段可能返回 null，表示取不到有效值。
        :type WebLocation: :class:`tencentcloud.cwp.v20180228.models.AssetWebLocationInfo`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._WebLocation = None
        self._RequestId = None

    @property
    def WebLocation(self):
        return self._WebLocation

    @WebLocation.setter
    def WebLocation(self, WebLocation):
        self._WebLocation = WebLocation

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("WebLocation") is not None:
            self._WebLocation = AssetWebLocationInfo()
            self._WebLocation._deserialize(params.get("WebLocation"))
        self._RequestId = params.get("RequestId")


class DescribeAssetWebLocationListRequest(AbstractModel):
    """DescribeAssetWebLocationList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Quuid: 查询指定Quuid主机的信息
        :type Quuid: str
        :param _Filters: 过滤条件。
<li>IpOrAlias - String - 是否必填：否 - 主机ip或别名筛选</li>
<li>Name - String - 是否必填：否 - 域名</li>
<li>User - String - 是否必填：否 - 运行用户</li>
<li>Port - uint64 - 是否必填：否 - 站点端口</li>
<li>Proto - uint64 - 是否必填：否 - 站点协议：1:HTTP,2:HTTPS</li>
<li>ServiceType - uint64 - 是否必填：否 - 服务类型：
1:Tomcat
2：Apache
3:Nginx
4:WebLogic
5:Websphere
6:JBoss
7:WildFly
8:Jetty
9:IHS
10:Tengine</li>
<li>OsType - String - 是否必填：否 - windows/linux</li>
<li>Os -String 是否必填: 否 - 操作系统( DescribeMachineOsList 接口 值 )</li>
        :type Filters: list of Filter
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Order: 排序方式，asc升序 或 desc降序
        :type Order: str
        :param _By: 可选排序：[FirstTime|PathCount]
        :type By: str
        """
        self._Quuid = None
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._Order = None
        self._By = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetWebLocationListResponse(AbstractModel):
    """DescribeAssetWebLocationList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Total: 记录总数
        :type Total: int
        :param _Locations: 站点列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Locations: list of AssetWebLocationBaseInfo
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Total = None
        self._Locations = None
        self._RequestId = None

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Locations(self):
        return self._Locations

    @Locations.setter
    def Locations(self, Locations):
        self._Locations = Locations

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("Locations") is not None:
            self._Locations = []
            for item in params.get("Locations"):
                obj = AssetWebLocationBaseInfo()
                obj._deserialize(item)
                self._Locations.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAssetWebServiceInfoListRequest(AbstractModel):
    """DescribeAssetWebServiceInfoList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Quuid: 查询指定Quuid主机的信息
        :type Quuid: str
        :param _Filters: 过滤条件。
<li>User- string - 是否必填：否 - 运行用户</li>
<li>Name- string - 是否必填：否 - Web服务名：
1:Tomcat
2:Apache
3:Nginx
4:WebLogic
5:Websphere
6:JBoss
7:WildFly
8:Jetty
9:IHS
10:Tengine</li>
<li>OsType- string - 是否必填：否 - Windows/linux</li>
<li>Os -String 是否必填: 否 - 操作系统( DescribeMachineOsList 接口 值 )</li>
        :type Filters: list of AssetFilters
        :param _Offset: 偏移量，默认为0。
<li>IpOrAlias - String - 是否必填：否 - 主机ip或别名筛选</li>
        :type Offset: int
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Order: 排序方式，asc升序 或 desc降序
        :type Order: str
        :param _By: 可选排序：[FirstTime|ProcessCount]
        :type By: str
        """
        self._Quuid = None
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._Order = None
        self._By = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetWebServiceInfoListResponse(AbstractModel):
    """DescribeAssetWebServiceInfoList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _WebServices: 列表
注意：此字段可能返回 null，表示取不到有效值。
        :type WebServices: list of AssetWebServiceBaseInfo
        :param _Total: 总数量
        :type Total: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._WebServices = None
        self._Total = None
        self._RequestId = None

    @property
    def WebServices(self):
        return self._WebServices

    @WebServices.setter
    def WebServices(self, WebServices):
        self._WebServices = WebServices

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("WebServices") is not None:
            self._WebServices = []
            for item in params.get("WebServices"):
                obj = AssetWebServiceBaseInfo()
                obj._deserialize(item)
                self._WebServices.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeAssetWebServiceProcessListRequest(AbstractModel):
    """DescribeAssetWebServiceProcessList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Quuid: 主机Quuid
        :type Quuid: str
        :param _Uuid: 主机Uuid
        :type Uuid: str
        :param _Id: Web服务ID
        :type Id: str
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        """
        self._Quuid = None
        self._Uuid = None
        self._Id = None
        self._Offset = None
        self._Limit = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._Id = params.get("Id")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetWebServiceProcessListResponse(AbstractModel):
    """DescribeAssetWebServiceProcessList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Process: 进程列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Process: list of AssetAppProcessInfo
        :param _Total: 总数
        :type Total: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Process = None
        self._Total = None
        self._RequestId = None

    @property
    def Process(self):
        return self._Process

    @Process.setter
    def Process(self, Process):
        self._Process = Process

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Process") is not None:
            self._Process = []
            for item in params.get("Process"):
                obj = AssetAppProcessInfo()
                obj._deserialize(item)
                self._Process.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeAttackLogInfoRequest(AbstractModel):
    """DescribeAttackLogInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 日志ID
        :type Id: int
        """
        self._Id = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAttackLogInfoResponse(AbstractModel):
    """DescribeAttackLogInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 日志ID
        :type Id: int
        :param _Quuid: 主机ID
        :type Quuid: str
        :param _SrcPort: 攻击来源端口
        :type SrcPort: int
        :param _SrcIp: 攻击来源IP
        :type SrcIp: str
        :param _DstPort: 攻击目标端口
        :type DstPort: int
        :param _DstIp: 攻击目标IP
        :type DstIp: str
        :param _HttpMethod: 攻击方法
        :type HttpMethod: str
        :param _HttpHost: 攻击目标主机
        :type HttpHost: str
        :param _HttpHead: 攻击头信息
        :type HttpHead: str
        :param _HttpUserAgent: 攻击者浏览器标识
        :type HttpUserAgent: str
        :param _HttpReferer: 请求源
        :type HttpReferer: str
        :param _VulType: 威胁类型
        :type VulType: str
        :param _HttpCgi: 攻击路径
        :type HttpCgi: str
        :param _HttpParam: 攻击参数
        :type HttpParam: str
        :param _CreatedAt: 攻击时间
        :type CreatedAt: str
        :param _HttpContent: 攻击内容
        :type HttpContent: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Id = None
        self._Quuid = None
        self._SrcPort = None
        self._SrcIp = None
        self._DstPort = None
        self._DstIp = None
        self._HttpMethod = None
        self._HttpHost = None
        self._HttpHead = None
        self._HttpUserAgent = None
        self._HttpReferer = None
        self._VulType = None
        self._HttpCgi = None
        self._HttpParam = None
        self._CreatedAt = None
        self._HttpContent = None
        self._RequestId = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def SrcPort(self):
        return self._SrcPort

    @SrcPort.setter
    def SrcPort(self, SrcPort):
        self._SrcPort = SrcPort

    @property
    def SrcIp(self):
        return self._SrcIp

    @SrcIp.setter
    def SrcIp(self, SrcIp):
        self._SrcIp = SrcIp

    @property
    def DstPort(self):
        return self._DstPort

    @DstPort.setter
    def DstPort(self, DstPort):
        self._DstPort = DstPort

    @property
    def DstIp(self):
        return self._DstIp

    @DstIp.setter
    def DstIp(self, DstIp):
        self._DstIp = DstIp

    @property
    def HttpMethod(self):
        return self._HttpMethod

    @HttpMethod.setter
    def HttpMethod(self, HttpMethod):
        self._HttpMethod = HttpMethod

    @property
    def HttpHost(self):
        return self._HttpHost

    @HttpHost.setter
    def HttpHost(self, HttpHost):
        self._HttpHost = HttpHost

    @property
    def HttpHead(self):
        return self._HttpHead

    @HttpHead.setter
    def HttpHead(self, HttpHead):
        self._HttpHead = HttpHead

    @property
    def HttpUserAgent(self):
        return self._HttpUserAgent

    @HttpUserAgent.setter
    def HttpUserAgent(self, HttpUserAgent):
        self._HttpUserAgent = HttpUserAgent

    @property
    def HttpReferer(self):
        return self._HttpReferer

    @HttpReferer.setter
    def HttpReferer(self, HttpReferer):
        self._HttpReferer = HttpReferer

    @property
    def VulType(self):
        return self._VulType

    @VulType.setter
    def VulType(self, VulType):
        self._VulType = VulType

    @property
    def HttpCgi(self):
        return self._HttpCgi

    @HttpCgi.setter
    def HttpCgi(self, HttpCgi):
        self._HttpCgi = HttpCgi

    @property
    def HttpParam(self):
        return self._HttpParam

    @HttpParam.setter
    def HttpParam(self, HttpParam):
        self._HttpParam = HttpParam

    @property
    def CreatedAt(self):
        return self._CreatedAt

    @CreatedAt.setter
    def CreatedAt(self, CreatedAt):
        self._CreatedAt = CreatedAt

    @property
    def HttpContent(self):
        return self._HttpContent

    @HttpContent.setter
    def HttpContent(self, HttpContent):
        self._HttpContent = HttpContent

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Quuid = params.get("Quuid")
        self._SrcPort = params.get("SrcPort")
        self._SrcIp = params.get("SrcIp")
        self._DstPort = params.get("DstPort")
        self._DstIp = params.get("DstIp")
        self._HttpMethod = params.get("HttpMethod")
        self._HttpHost = params.get("HttpHost")
        self._HttpHead = params.get("HttpHead")
        self._HttpUserAgent = params.get("HttpUserAgent")
        self._HttpReferer = params.get("HttpReferer")
        self._VulType = params.get("VulType")
        self._HttpCgi = params.get("HttpCgi")
        self._HttpParam = params.get("HttpParam")
        self._CreatedAt = params.get("CreatedAt")
        self._HttpContent = params.get("HttpContent")
        self._RequestId = params.get("RequestId")


class DescribeAttackLogsRequest(AbstractModel):
    """DescribeAttackLogs请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 返回数量，最大值为100。
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>HttpMethod - String - 是否必填：否 - 攻击方法(POST|GET)</li>
<li>DateRange - String - 是否必填：否 - 时间范围(存储最近3个月的数据)，如最近一个月["2019-11-17", "2019-12-17"]</li>
<li>VulType - String 威胁类型 - 是否必填: 否</li>
<li>SrcIp - String 攻击源IP - 是否必填: 否</li>
<li>DstIp - String 攻击目标IP - 是否必填: 否</li>
<li>SrcPort - String 攻击源端口 - 是否必填: 否</li>
<li>DstPort - String 攻击目标端口 - 是否必填: 否</li>
        :type Filters: list of Filter
        :param _Uuid: 主机安全客户端ID
        :type Uuid: str
        :param _Quuid: 云主机机器ID
        :type Quuid: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Uuid = None
        self._Quuid = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Uuid = params.get("Uuid")
        self._Quuid = params.get("Quuid")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAttackLogsResponse(AbstractModel):
    """DescribeAttackLogs返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AttackLogs: 日志列表
注意：此字段可能返回 null，表示取不到有效值。
        :type AttackLogs: list of DefendAttackLog
        :param _TotalCount: 总条数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AttackLogs = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def AttackLogs(self):
        return self._AttackLogs

    @AttackLogs.setter
    def AttackLogs(self, AttackLogs):
        self._AttackLogs = AttackLogs

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("AttackLogs") is not None:
            self._AttackLogs = []
            for item in params.get("AttackLogs"):
                obj = DefendAttackLog()
                obj._deserialize(item)
                self._AttackLogs.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAttackVulTypeListRequest(AbstractModel):
    """DescribeAttackVulTypeList请求参数结构体

    """


class DescribeAttackVulTypeListResponse(AbstractModel):
    """DescribeAttackVulTypeList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 威胁类型列表
        :type List: list of str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._List = params.get("List")
        self._RequestId = params.get("RequestId")


class DescribeAvailableExpertServiceDetailRequest(AbstractModel):
    """DescribeAvailableExpertServiceDetail请求参数结构体

    """


class DescribeAvailableExpertServiceDetailResponse(AbstractModel):
    """DescribeAvailableExpertServiceDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ExpertService: 安全管家订单
        :type ExpertService: list of ExpertServiceOrderInfo
        :param _EmergencyResponse: 应急响应可用次数
        :type EmergencyResponse: int
        :param _ProtectNet: 旗舰护网可用次数
        :type ProtectNet: int
        :param _ExpertServiceBuy: 是否购买过安全管家
        :type ExpertServiceBuy: bool
        :param _EmergencyResponseBuy: 是否购买过应急响应
        :type EmergencyResponseBuy: bool
        :param _ProtectNetBuy: 是否购买过旗舰护网
        :type ProtectNetBuy: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ExpertService = None
        self._EmergencyResponse = None
        self._ProtectNet = None
        self._ExpertServiceBuy = None
        self._EmergencyResponseBuy = None
        self._ProtectNetBuy = None
        self._RequestId = None

    @property
    def ExpertService(self):
        return self._ExpertService

    @ExpertService.setter
    def ExpertService(self, ExpertService):
        self._ExpertService = ExpertService

    @property
    def EmergencyResponse(self):
        return self._EmergencyResponse

    @EmergencyResponse.setter
    def EmergencyResponse(self, EmergencyResponse):
        self._EmergencyResponse = EmergencyResponse

    @property
    def ProtectNet(self):
        return self._ProtectNet

    @ProtectNet.setter
    def ProtectNet(self, ProtectNet):
        self._ProtectNet = ProtectNet

    @property
    def ExpertServiceBuy(self):
        return self._ExpertServiceBuy

    @ExpertServiceBuy.setter
    def ExpertServiceBuy(self, ExpertServiceBuy):
        self._ExpertServiceBuy = ExpertServiceBuy

    @property
    def EmergencyResponseBuy(self):
        return self._EmergencyResponseBuy

    @EmergencyResponseBuy.setter
    def EmergencyResponseBuy(self, EmergencyResponseBuy):
        self._EmergencyResponseBuy = EmergencyResponseBuy

    @property
    def ProtectNetBuy(self):
        return self._ProtectNetBuy

    @ProtectNetBuy.setter
    def ProtectNetBuy(self, ProtectNetBuy):
        self._ProtectNetBuy = ProtectNetBuy

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ExpertService") is not None:
            self._ExpertService = []
            for item in params.get("ExpertService"):
                obj = ExpertServiceOrderInfo()
                obj._deserialize(item)
                self._ExpertService.append(obj)
        self._EmergencyResponse = params.get("EmergencyResponse")
        self._ProtectNet = params.get("ProtectNet")
        self._ExpertServiceBuy = params.get("ExpertServiceBuy")
        self._EmergencyResponseBuy = params.get("EmergencyResponseBuy")
        self._ProtectNetBuy = params.get("ProtectNetBuy")
        self._RequestId = params.get("RequestId")


class DescribeBanModeRequest(AbstractModel):
    """DescribeBanMode请求参数结构体

    """


class DescribeBanModeResponse(AbstractModel):
    """DescribeBanMode返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Mode: 阻断模式，STANDARD_MODE：标准阻断，DEEP_MODE：深度阻断
        :type Mode: str
        :param _StandardModeConfig: 标准阻断模式的配置
        :type StandardModeConfig: :class:`tencentcloud.cwp.v20180228.models.StandardModeConfig`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Mode = None
        self._StandardModeConfig = None
        self._RequestId = None

    @property
    def Mode(self):
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def StandardModeConfig(self):
        return self._StandardModeConfig

    @StandardModeConfig.setter
    def StandardModeConfig(self, StandardModeConfig):
        self._StandardModeConfig = StandardModeConfig

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Mode = params.get("Mode")
        if params.get("StandardModeConfig") is not None:
            self._StandardModeConfig = StandardModeConfig()
            self._StandardModeConfig._deserialize(params.get("StandardModeConfig"))
        self._RequestId = params.get("RequestId")


class DescribeBanRegionsRequest(AbstractModel):
    """DescribeBanRegions请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Mode: 阻断模式，STANDARD_MODE：标准阻断，DEEP_MODE：深度阻断
        :type Mode: str
        """
        self._Mode = None

    @property
    def Mode(self):
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode


    def _deserialize(self, params):
        self._Mode = params.get("Mode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBanRegionsResponse(AbstractModel):
    """DescribeBanRegions返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RegionSet: 地域信息列表
        :type RegionSet: list of RegionSet
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RegionSet = None
        self._RequestId = None

    @property
    def RegionSet(self):
        return self._RegionSet

    @RegionSet.setter
    def RegionSet(self, RegionSet):
        self._RegionSet = RegionSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RegionSet") is not None:
            self._RegionSet = []
            for item in params.get("RegionSet"):
                obj = RegionSet()
                obj._deserialize(item)
                self._RegionSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBanStatusRequest(AbstractModel):
    """DescribeBanStatus请求参数结构体

    """


class DescribeBanStatusResponse(AbstractModel):
    """DescribeBanStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Status: 阻断开关状态 0:关闭 1:开启
        :type Status: int
        :param _ShowTips: 是否弹窗提示信息 false: 关闭，true: 开启
        :type ShowTips: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Status = None
        self._ShowTips = None
        self._RequestId = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ShowTips(self):
        return self._ShowTips

    @ShowTips.setter
    def ShowTips(self, ShowTips):
        self._ShowTips = ShowTips

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ShowTips = params.get("ShowTips")
        self._RequestId = params.get("RequestId")


class DescribeBanWhiteListRequest(AbstractModel):
    """DescribeBanWhiteList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Limit: 返回数量，最大值为100。
        :type Limit: int
        :param _Filters: 过滤条件。
<li>Keywords - String - 是否必填：否 - 查询关键字 </li>
        :type Filters: list of Filter
        """
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBanWhiteListResponse(AbstractModel):
    """DescribeBanWhiteList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总记录数
        :type TotalCount: int
        :param _WhiteList: 白名单列表
        :type WhiteList: list of BanWhiteListDetail
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._WhiteList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def WhiteList(self):
        return self._WhiteList

    @WhiteList.setter
    def WhiteList(self, WhiteList):
        self._WhiteList = WhiteList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("WhiteList") is not None:
            self._WhiteList = []
            for item in params.get("WhiteList"):
                obj = BanWhiteListDetail()
                obj._deserialize(item)
                self._WhiteList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBaselineAnalysisDataRequest(AbstractModel):
    """DescribeBaselineAnalysisData请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StrategyId: 基线策略id
        :type StrategyId: int
        """
        self._StrategyId = None

    @property
    def StrategyId(self):
        return self._StrategyId

    @StrategyId.setter
    def StrategyId(self, StrategyId):
        self._StrategyId = StrategyId


    def _deserialize(self, params):
        self._StrategyId = params.get("StrategyId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselineAnalysisDataResponse(AbstractModel):
    """DescribeBaselineAnalysisData返回参数结构体

    """

    def __init__(self):
        r"""
        :param _LatestScanTime: 最后检测时间
注意：此字段可能返回 null，表示取不到有效值。
        :type LatestScanTime: str
        :param _IsGlobal: 是否全部服务器：1-是 0-否
注意：此字段可能返回 null，表示取不到有效值。
        :type IsGlobal: int
        :param _ScanHostCount: 服务器总数
注意：此字段可能返回 null，表示取不到有效值。
        :type ScanHostCount: int
        :param _ScanRuleCount: 检测项总数
注意：此字段可能返回 null，表示取不到有效值。
        :type ScanRuleCount: int
        :param _IfFirstScan: 是否是第一次检测  1是 0不是
注意：此字段可能返回 null，表示取不到有效值。
        :type IfFirstScan: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._LatestScanTime = None
        self._IsGlobal = None
        self._ScanHostCount = None
        self._ScanRuleCount = None
        self._IfFirstScan = None
        self._RequestId = None

    @property
    def LatestScanTime(self):
        return self._LatestScanTime

    @LatestScanTime.setter
    def LatestScanTime(self, LatestScanTime):
        self._LatestScanTime = LatestScanTime

    @property
    def IsGlobal(self):
        return self._IsGlobal

    @IsGlobal.setter
    def IsGlobal(self, IsGlobal):
        self._IsGlobal = IsGlobal

    @property
    def ScanHostCount(self):
        return self._ScanHostCount

    @ScanHostCount.setter
    def ScanHostCount(self, ScanHostCount):
        self._ScanHostCount = ScanHostCount

    @property
    def ScanRuleCount(self):
        return self._ScanRuleCount

    @ScanRuleCount.setter
    def ScanRuleCount(self, ScanRuleCount):
        self._ScanRuleCount = ScanRuleCount

    @property
    def IfFirstScan(self):
        return self._IfFirstScan

    @IfFirstScan.setter
    def IfFirstScan(self, IfFirstScan):
        self._IfFirstScan = IfFirstScan

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._LatestScanTime = params.get("LatestScanTime")
        self._IsGlobal = params.get("IsGlobal")
        self._ScanHostCount = params.get("ScanHostCount")
        self._ScanRuleCount = params.get("ScanRuleCount")
        self._IfFirstScan = params.get("IfFirstScan")
        self._RequestId = params.get("RequestId")


class DescribeBaselineBasicInfoRequest(AbstractModel):
    """DescribeBaselineBasicInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _BaselineName: 基线名称
        :type BaselineName: str
        """
        self._BaselineName = None

    @property
    def BaselineName(self):
        return self._BaselineName

    @BaselineName.setter
    def BaselineName(self, BaselineName):
        self._BaselineName = BaselineName


    def _deserialize(self, params):
        self._BaselineName = params.get("BaselineName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselineBasicInfoResponse(AbstractModel):
    """DescribeBaselineBasicInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _BaselineBasicInfoList: 基线基础信息列表
注意：此字段可能返回 null，表示取不到有效值。
        :type BaselineBasicInfoList: list of BaselineBasicInfo
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._BaselineBasicInfoList = None
        self._RequestId = None

    @property
    def BaselineBasicInfoList(self):
        return self._BaselineBasicInfoList

    @BaselineBasicInfoList.setter
    def BaselineBasicInfoList(self, BaselineBasicInfoList):
        self._BaselineBasicInfoList = BaselineBasicInfoList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("BaselineBasicInfoList") is not None:
            self._BaselineBasicInfoList = []
            for item in params.get("BaselineBasicInfoList"):
                obj = BaselineBasicInfo()
                obj._deserialize(item)
                self._BaselineBasicInfoList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBaselineDetailRequest(AbstractModel):
    """DescribeBaselineDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _BaselineId: 基线id
        :type BaselineId: int
        """
        self._BaselineId = None

    @property
    def BaselineId(self):
        return self._BaselineId

    @BaselineId.setter
    def BaselineId(self, BaselineId):
        self._BaselineId = BaselineId


    def _deserialize(self, params):
        self._BaselineId = params.get("BaselineId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselineDetailResponse(AbstractModel):
    """DescribeBaselineDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _BaselineDetail: 基线详情
注意：此字段可能返回 null，表示取不到有效值。
        :type BaselineDetail: :class:`tencentcloud.cwp.v20180228.models.BaselineDetail`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._BaselineDetail = None
        self._RequestId = None

    @property
    def BaselineDetail(self):
        return self._BaselineDetail

    @BaselineDetail.setter
    def BaselineDetail(self, BaselineDetail):
        self._BaselineDetail = BaselineDetail

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("BaselineDetail") is not None:
            self._BaselineDetail = BaselineDetail()
            self._BaselineDetail._deserialize(params.get("BaselineDetail"))
        self._RequestId = params.get("RequestId")


class DescribeBaselineDetectListRequest(AbstractModel):
    """DescribeBaselineDetectList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: <li>PolicyName - string - 是否必填：否 - 策略名称</li>
<li>PolicyDetectStatus - int - 是否必填：否 - 1:检测中 2:检测完成</li>
<li>FirstTime - string - 是否必填：否 - 开始时间</li>
<li>LastTime - string - 是否必填：否 - 结束时间</li>
        :type Filters: list of Filter
        :param _Limit: 限制条数,默认10,最大100
        :type Limit: int
        :param _Offset: 偏移量,默认0
        :type Offset: int
        :param _Order: 排序方式: [ASC:升序|DESC:降序]
        :type Order: str
        :param _By: 可选排序列: [HostCount|StartTime|StopTime]
        :type By: str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselineDetectListResponse(AbstractModel):
    """DescribeBaselineDetectList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 无
        :type List: list of BaselinePolicyDetect
        :param _Total: 总数
        :type Total: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._Total = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = BaselinePolicyDetect()
                obj._deserialize(item)
                self._List.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeBaselineDetectOverviewRequest(AbstractModel):
    """DescribeBaselineDetectOverview请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PolicyId: 策略Id
        :type PolicyId: int
        """
        self._PolicyId = None

    @property
    def PolicyId(self):
        return self._PolicyId

    @PolicyId.setter
    def PolicyId(self, PolicyId):
        self._PolicyId = PolicyId


    def _deserialize(self, params):
        self._PolicyId = params.get("PolicyId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselineDetectOverviewResponse(AbstractModel):
    """DescribeBaselineDetectOverview返回参数结构体

    """

    def __init__(self):
        r"""
        :param _HostCount: 检测服务器数
        :type HostCount: int
        :param _ItemCount: 检测项
        :type ItemCount: int
        :param _PolicyCount: 检测策略项
        :type PolicyCount: int
        :param _PassRate: 通过率*100%
        :type PassRate: int
        :param _LatestPassCount: 最近一次检测通过个数
注意：此字段可能返回 null，表示取不到有效值。
        :type LatestPassCount: int
        :param _LatestNotPassCount: 最近一次检测未通过个数
注意：此字段可能返回 null，表示取不到有效值。
        :type LatestNotPassCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._HostCount = None
        self._ItemCount = None
        self._PolicyCount = None
        self._PassRate = None
        self._LatestPassCount = None
        self._LatestNotPassCount = None
        self._RequestId = None

    @property
    def HostCount(self):
        return self._HostCount

    @HostCount.setter
    def HostCount(self, HostCount):
        self._HostCount = HostCount

    @property
    def ItemCount(self):
        return self._ItemCount

    @ItemCount.setter
    def ItemCount(self, ItemCount):
        self._ItemCount = ItemCount

    @property
    def PolicyCount(self):
        return self._PolicyCount

    @PolicyCount.setter
    def PolicyCount(self, PolicyCount):
        self._PolicyCount = PolicyCount

    @property
    def PassRate(self):
        return self._PassRate

    @PassRate.setter
    def PassRate(self, PassRate):
        self._PassRate = PassRate

    @property
    def LatestPassCount(self):
        return self._LatestPassCount

    @LatestPassCount.setter
    def LatestPassCount(self, LatestPassCount):
        self._LatestPassCount = LatestPassCount

    @property
    def LatestNotPassCount(self):
        return self._LatestNotPassCount

    @LatestNotPassCount.setter
    def LatestNotPassCount(self, LatestNotPassCount):
        self._LatestNotPassCount = LatestNotPassCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._HostCount = params.get("HostCount")
        self._ItemCount = params.get("ItemCount")
        self._PolicyCount = params.get("PolicyCount")
        self._PassRate = params.get("PassRate")
        self._LatestPassCount = params.get("LatestPassCount")
        self._LatestNotPassCount = params.get("LatestNotPassCount")
        self._RequestId = params.get("RequestId")


class DescribeBaselineDownloadListRequest(AbstractModel):
    """DescribeBaselineDownloadList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: <li>Status - int - 是否必填：否 - 0:导出中 1:已完成</li>
<li>StartTime - string - 是否必填：否 - 开始时间</li>
<li>EndTime - string - 是否必填：否 - 结束时间</li>
<li>TaskName - string - 是否必填：否 - 任务名称</li>
        :type Filters: list of Filter
        :param _Limit: 限制条数,默认10,最大100
        :type Limit: int
        :param _Offset: 偏移量,默认0
        :type Offset: int
        :param _Order: 排序方式: [ASC:升序|DESC:降序]
        :type Order: str
        :param _By: 可选排序列: [StartTime|EndTime]
        :type By: str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselineDownloadListResponse(AbstractModel):
    """DescribeBaselineDownloadList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 无
        :type List: list of BaselineDownload
        :param _Total: 总数
        :type Total: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._Total = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = BaselineDownload()
                obj._deserialize(item)
                self._List.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeBaselineEffectHostListRequest(AbstractModel):
    """DescribeBaselineEffectHostList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 分页参数 最大100条
        :type Limit: int
        :param _Offset: 分页参数
        :type Offset: int
        :param _BaselineId: 基线id
        :type BaselineId: int
        :param _Filters: 过滤条件。
<li>AliasName- String- 主机别名</li>
<li>Status- Uint- 1已通过  0未通过 5检测中</li>
        :type Filters: list of Filters
        :param _StrategyId: 策略id
        :type StrategyId: int
        :param _UuidList: 主机uuid数组
        :type UuidList: list of str
        """
        self._Limit = None
        self._Offset = None
        self._BaselineId = None
        self._Filters = None
        self._StrategyId = None
        self._UuidList = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def BaselineId(self):
        return self._BaselineId

    @BaselineId.setter
    def BaselineId(self, BaselineId):
        self._BaselineId = BaselineId

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def StrategyId(self):
        return self._StrategyId

    @StrategyId.setter
    def StrategyId(self, StrategyId):
        self._StrategyId = StrategyId

    @property
    def UuidList(self):
        return self._UuidList

    @UuidList.setter
    def UuidList(self, UuidList):
        self._UuidList = UuidList


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._BaselineId = params.get("BaselineId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._StrategyId = params.get("StrategyId")
        self._UuidList = params.get("UuidList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselineEffectHostListResponse(AbstractModel):
    """DescribeBaselineEffectHostList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 记录总数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _EffectHostList: 影响服务器列表
注意：此字段可能返回 null，表示取不到有效值。
        :type EffectHostList: list of BaselineEffectHost
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._EffectHostList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def EffectHostList(self):
        return self._EffectHostList

    @EffectHostList.setter
    def EffectHostList(self, EffectHostList):
        self._EffectHostList = EffectHostList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("EffectHostList") is not None:
            self._EffectHostList = []
            for item in params.get("EffectHostList"):
                obj = BaselineEffectHost()
                obj._deserialize(item)
                self._EffectHostList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBaselineFixListRequest(AbstractModel):
    """DescribeBaselineFixList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: <li>ItemName- string - 是否必填：否 - 项名称</li>
        :type Filters: list of Filter
        :param _Limit: 限制条数,默认10,最大100
        :type Limit: int
        :param _Offset: 偏移量,默认0
        :type Offset: int
        :param _Order: 排序方式: [ASC:升序|DESC:降序]
        :type Order: str
        :param _By: 可选排序列: [CreateTime|MoifyTime|FixTime]
        :type By: str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselineFixListResponse(AbstractModel):
    """DescribeBaselineFixList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 无
        :type List: list of BaselineFix
        :param _Total: 总数
        :type Total: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._Total = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = BaselineFix()
                obj._deserialize(item)
                self._List.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeBaselineHostDetectListRequest(AbstractModel):
    """DescribeBaselineHostDetectList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: <li>PolicyId - int64 - 是否必填：否 - 策略Id</li>
<li>HostName - string - 是否必填：否 - 主机名称</i>
<li>HostIp - string - 是否必填：否 - 主机Ip</i>
<li>ItemId - int64 - 是否必填：否 - 项Id</i>
<li>RuleId - int64 - 是否必填：否 - 规则Id</li>
<li>DetectStatus - int - 是否必填：否 - 检测状态</li>
<li>Level - int - 是否必填：否 - 风险等级</li>
<li>StartTime - string - 是否必填：否 - 开时时间</li>
<li>EndTime - string - 是否必填：否 - 结束时间</li>
        :type Filters: list of Filter
        :param _Limit: 限制条数,默认10,最大100
        :type Limit: int
        :param _Offset: 偏移量,默认0
        :type Offset: int
        :param _Order: 排序方式: [ASC:升序|DESC:降序]
        :type Order: str
        :param _By: 可选排序列: [LastTime|ItemCount|PassedItemCount|NotPassedItemCount|FirstTime]
        :type By: str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselineHostDetectListResponse(AbstractModel):
    """DescribeBaselineHostDetectList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 无
        :type List: list of BaselineHostDetect
        :param _Total: 总数
        :type Total: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._Total = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = BaselineHostDetect()
                obj._deserialize(item)
                self._List.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeBaselineHostIgnoreListRequest(AbstractModel):
    """DescribeBaselineHostIgnoreList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleID: 请求的规则
        :type RuleID: int
        :param _Limit: 限制条数,默认10,最大100
        :type Limit: int
        :param _Offset: 偏移量,默认0
        :type Offset: int
        """
        self._RuleID = None
        self._Limit = None
        self._Offset = None

    @property
    def RuleID(self):
        return self._RuleID

    @RuleID.setter
    def RuleID(self, RuleID):
        self._RuleID = RuleID

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._RuleID = params.get("RuleID")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselineHostIgnoreListResponse(AbstractModel):
    """DescribeBaselineHostIgnoreList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Total: 总数
        :type Total: int
        :param _List: 无
        :type List: list of BaselineHost
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Total = None
        self._List = None
        self._RequestId = None

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = BaselineHost()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBaselineHostRiskTopRequest(AbstractModel):
    """DescribeBaselineHostRiskTop请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PolicyId: 策略ID
        :type PolicyId: int
        """
        self._PolicyId = None

    @property
    def PolicyId(self):
        return self._PolicyId

    @PolicyId.setter
    def PolicyId(self, PolicyId):
        self._PolicyId = PolicyId


    def _deserialize(self, params):
        self._PolicyId = params.get("PolicyId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselineHostRiskTopResponse(AbstractModel):
    """DescribeBaselineHostRiskTop返回参数结构体

    """

    def __init__(self):
        r"""
        :param _HostRiskTop5: 风险主机top5
        :type HostRiskTop5: list of HostRiskLevelCount
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._HostRiskTop5 = None
        self._RequestId = None

    @property
    def HostRiskTop5(self):
        return self._HostRiskTop5

    @HostRiskTop5.setter
    def HostRiskTop5(self, HostRiskTop5):
        self._HostRiskTop5 = HostRiskTop5

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("HostRiskTop5") is not None:
            self._HostRiskTop5 = []
            for item in params.get("HostRiskTop5"):
                obj = HostRiskLevelCount()
                obj._deserialize(item)
                self._HostRiskTop5.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBaselineHostTopRequest(AbstractModel):
    """DescribeBaselineHostTop请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Top: 动态top值
        :type Top: int
        :param _StrategyId: 策略id
        :type StrategyId: int
        """
        self._Top = None
        self._StrategyId = None

    @property
    def Top(self):
        return self._Top

    @Top.setter
    def Top(self, Top):
        self._Top = Top

    @property
    def StrategyId(self):
        return self._StrategyId

    @StrategyId.setter
    def StrategyId(self, StrategyId):
        self._StrategyId = StrategyId


    def _deserialize(self, params):
        self._Top = params.get("Top")
        self._StrategyId = params.get("StrategyId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselineHostTopResponse(AbstractModel):
    """DescribeBaselineHostTop返回参数结构体

    """

    def __init__(self):
        r"""
        :param _BaselineHostTopList: 主机基线策略事件Top
注意：此字段可能返回 null，表示取不到有效值。
        :type BaselineHostTopList: list of BaselineHostTopList
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._BaselineHostTopList = None
        self._RequestId = None

    @property
    def BaselineHostTopList(self):
        return self._BaselineHostTopList

    @BaselineHostTopList.setter
    def BaselineHostTopList(self, BaselineHostTopList):
        self._BaselineHostTopList = BaselineHostTopList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("BaselineHostTopList") is not None:
            self._BaselineHostTopList = []
            for item in params.get("BaselineHostTopList"):
                obj = BaselineHostTopList()
                obj._deserialize(item)
                self._BaselineHostTopList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBaselineItemDetectListRequest(AbstractModel):
    """DescribeBaselineItemDetectList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: <li>HostId - string - 是否必填：否 - 主机Id</li>
<li>RuleId - int64 - 是否必填：否 - 规则Id</li>
<li>PolicyId - int64 - 是否必填：否 - 规则Id</li>
<li>ItemName - string - 是否必填：否 - 项名称</li>
<li>DetectStatus - int - 是否必填：否 - 检测状态</li>
<li>Level - int - 是否必填：否 - 风险等级</li>
<li>StartTime - string - 是否必填：否 - 开始时间</li>
<li>EndTime - string - 是否必填：否 - 结束时间</li>
        :type Filters: list of Filter
        :param _Limit: 限制条数,默认10,最大100
        :type Limit: int
        :param _Offset: 偏移量,默认0
        :type Offset: int
        :param _Order: 排序方式: [ASC:升序|DESC:降序]
        :type Order: str
        :param _By: 可选排序列: [HostCount|FirstTime|LastTime]
        :type By: str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselineItemDetectListResponse(AbstractModel):
    """DescribeBaselineItemDetectList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Total: 总数
        :type Total: int
        :param _List: 无
        :type List: list of BaselineItemDetect
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Total = None
        self._List = None
        self._RequestId = None

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = BaselineItemDetect()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBaselineItemIgnoreListRequest(AbstractModel):
    """DescribeBaselineItemIgnoreList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleID: 忽略规则ID
        :type RuleID: int
        :param _Limit: 限制条数,默认10,最大100
        :type Limit: int
        :param _Offset: 请求偏移默认0
        :type Offset: int
        :param _Filters: <li>CatgoryId - int64 - 是否必填：否 - 规则Id</li>
        :type Filters: list of Filter
        :param _Order: 排序方式 [ASC:升序|DESC:降序]
        :type Order: str
        :param _By: 可选排序列 [ID]
        :type By: str
        """
        self._RuleID = None
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def RuleID(self):
        return self._RuleID

    @RuleID.setter
    def RuleID(self, RuleID):
        self._RuleID = RuleID

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._RuleID = params.get("RuleID")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselineItemIgnoreListResponse(AbstractModel):
    """DescribeBaselineItemIgnoreList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 无
        :type List: list of BaselineItemInfo
        :param _Total: 总数
        :type Total: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._Total = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = BaselineItemInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeBaselineItemInfoRequest(AbstractModel):
    """DescribeBaselineItemInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: <li>ItemId - int64 - 是否必填：否 - 项Id</i>
<li>PolicyId - int64 - 是否必填：否 - 项Id</i>
<li>Level - int - 是否必填：否 - 风险等级</li>
<li>ItemName - string - 是否必填：否 - 检测项名字</li>
<li>RuleId - int - 是否必填：否 - 规则Id</li>
        :type Filters: list of Filter
        :param _Limit: 限制条数,默认10,最大100
        :type Limit: int
        :param _Offset: 偏移量,默认0
        :type Offset: int
        :param _Order: 排序方式: [ASC:升序|DESC:降序]
        :type Order: str
        :param _By: 可选排序列
        :type By: str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselineItemInfoResponse(AbstractModel):
    """DescribeBaselineItemInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 结果列表
        :type List: list of BaselineItemInfo
        :param _Total: 总条目数
        :type Total: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._Total = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = BaselineItemInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeBaselineItemListRequest(AbstractModel):
    """DescribeBaselineItemList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: <li>PolicyId - int64 - 是否必填：否 - 策略Id</li>
<li>RuleId - int64 - 是否必填：否 - 规则Id</li>
<li>HostId - string - 是否必填：否 - 主机Id</li>
<li>HostName - string - 是否必填：否 - 主机名</li>
<li>HostIp - string - 是否必填：否 - 主机IP</li>
<li>ItemId - String - 是否必填：否 - 检测项Id</li>
<li>ItemName - String - 是否必填：否 - 项名称</li>
<li>DetectStatus - int - 是否必填：否 - 检测状态[0:未通过|3:通过|5:检测中]</li>
<li>Level - int - 是否必填：否 - 风险等级</li>
<li>StartTime - string - 是否必填：否 - 开始时间</li>
<li>EndTime - string - 是否必填：否 - 结束时间</li>
        :type Filters: list of Filter
        :param _Limit: 限制条数,默认10,最大100
        :type Limit: int
        :param _Offset: 偏移量,默认0
        :type Offset: int
        :param _Order: 排序方式: [ASC:升序|DESC:降序]
        :type Order: str
        :param _By: 可选排序列
        :type By: str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselineItemListResponse(AbstractModel):
    """DescribeBaselineItemList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 无
        :type List: list of BaselineItem
        :param _Total: 总数
        :type Total: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._Total = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = BaselineItem()
                obj._deserialize(item)
                self._List.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeBaselineItemRiskTopRequest(AbstractModel):
    """DescribeBaselineItemRiskTop请求参数结构体

    """

    def __init__(self):
        r"""
        :param _PolicyId: 策略ID
        :type PolicyId: int
        """
        self._PolicyId = None

    @property
    def PolicyId(self):
        return self._PolicyId

    @PolicyId.setter
    def PolicyId(self, PolicyId):
        self._PolicyId = PolicyId


    def _deserialize(self, params):
        self._PolicyId = params.get("PolicyId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselineItemRiskTopResponse(AbstractModel):
    """DescribeBaselineItemRiskTop返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RiskItemTop5: 结果数组
        :type RiskItemTop5: list of BaselineRiskItem
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RiskItemTop5 = None
        self._RequestId = None

    @property
    def RiskItemTop5(self):
        return self._RiskItemTop5

    @RiskItemTop5.setter
    def RiskItemTop5(self, RiskItemTop5):
        self._RiskItemTop5 = RiskItemTop5

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RiskItemTop5") is not None:
            self._RiskItemTop5 = []
            for item in params.get("RiskItemTop5"):
                obj = BaselineRiskItem()
                obj._deserialize(item)
                self._RiskItemTop5.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBaselineListRequest(AbstractModel):
    """DescribeBaselineList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 分页参数 最大100条
        :type Limit: int
        :param _Offset: 分页参数
        :type Offset: int
        :param _Filters: 过滤条件。
<li>StrategyId- Uint64 - 基线策略id</li>
<li>Status - Uint64 - 处理状态1已通过 0未通过</li>
<li>Level - Uint64[] - 处理状态1已通过 0未通过</li>BaselineName 
<li>BaselineName  - String - 基线名称</li>
<li>Quuid- String - 主机quuid</li>
<li>Uuid- String - 主机uuid</li>
        :type Filters: list of Filters
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselineListResponse(AbstractModel):
    """DescribeBaselineList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _BaselineList: 基线信息列表
注意：此字段可能返回 null，表示取不到有效值。
        :type BaselineList: list of BaselineInfo
        :param _TotalCount: 分页查询记录总数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._BaselineList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def BaselineList(self):
        return self._BaselineList

    @BaselineList.setter
    def BaselineList(self, BaselineList):
        self._BaselineList = BaselineList

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("BaselineList") is not None:
            self._BaselineList = []
            for item in params.get("BaselineList"):
                obj = BaselineInfo()
                obj._deserialize(item)
                self._BaselineList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeBaselinePolicyListRequest(AbstractModel):
    """DescribeBaselinePolicyList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: <li>PolicyName - String - 是否必填：否 - 策略名称</li>
        :type Filters: list of Filter
        :param _Limit: 限制条数,默认10,最大100
        :type Limit: int
        :param _Offset: 偏移量,默认0
        :type Offset: int
        :param _Order: 排序方式: [ASC:升序|DESC:降序]
        :type Order: str
        :param _By: 可选排序列: [RuleCount|ItemCount|HostCount]
        :type By: str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselinePolicyListResponse(AbstractModel):
    """DescribeBaselinePolicyList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 无
        :type List: list of BaselinePolicy
        :param _Total: 总数
        :type Total: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._Total = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = BaselinePolicy()
                obj._deserialize(item)
                self._List.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeBaselineRuleCategoryListRequest(AbstractModel):
    """DescribeBaselineRuleCategoryList请求参数结构体

    """


class DescribeBaselineRuleCategoryListResponse(AbstractModel):
    """DescribeBaselineRuleCategoryList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 无
        :type List: list of BaselineCategory
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = BaselineCategory()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBaselineRuleDetectListRequest(AbstractModel):
    """DescribeBaselineRuleDetectList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: <li>PolicyId - int64 - 是否必填：否 - 策略Id</li>
<li>ItemId - int64 - 是否必填：否 - 策略Id</li>
<li>RuleName - string - 是否必填：否 - 规则名称</li>
<li>DetectStatus - int - 是否必填：否 - 检测状态</li>
<li>StartTime - string - 是否必填：否 - 开时时间</li>
<li>EndTime - string - 是否必填：否 - 结束时间</li>
        :type Filters: list of Filter
        :param _Limit: 限制条数,默认10,最大100
        :type Limit: int
        :param _Offset: 偏移量,默认0
        :type Offset: int
        :param _Order: 排序方式: [ASC:升序|DESC:降序]
        :type Order: str
        :param _By: 可选排序列: [HostCount|FirstTime|LastTime]
        :type By: str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselineRuleDetectListResponse(AbstractModel):
    """DescribeBaselineRuleDetectList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 无
        :type List: list of BaselineRuleDetect
        :param _Total: 总数
        :type Total: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._Total = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = BaselineRuleDetect()
                obj._deserialize(item)
                self._List.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeBaselineRuleIgnoreListRequest(AbstractModel):
    """DescribeBaselineRuleIgnoreList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: <li>RuleName - String - 是否必填：否 - 规则名称</li>
<li>ItemId- int - 是否必填：否 - 检测项Id</li>
        :type Filters: list of Filter
        :param _Limit: 限制条数,默认10,最大100
        :type Limit: int
        :param _Offset: 偏移量,默认0
        :type Offset: int
        :param _Order: 排序方式: [ASC:升序|DESC:降序]
        :type Order: str
        :param _By: 可选排序列: [HostCount]
        :type By: str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselineRuleIgnoreListResponse(AbstractModel):
    """DescribeBaselineRuleIgnoreList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Total: 总数
        :type Total: int
        :param _List: 列表
        :type List: list of BaselineRule
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Total = None
        self._List = None
        self._RequestId = None

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = BaselineRule()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBaselineRuleListRequest(AbstractModel):
    """DescribeBaselineRuleList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: <li>RuleName - String - 是否必填：否 - 规则名称</li>
<li>CategoryId - int64 - 是否必填：否 自定义筛选为-1 - 规则分类</li>
<li>RuleType - int - 是否必填：否 0:系统 1:自定义 - 规则类型</li>
        :type Filters: list of Filter
        :param _Limit: 限制条数,默认10,最大100
        :type Limit: int
        :param _Offset: 偏移量,默认0
        :type Offset: int
        :param _Order: 排序方式: [ASC:升序|DESC:降序]
        :type Order: str
        :param _By: 可选排序列
        :type By: str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselineRuleListResponse(AbstractModel):
    """DescribeBaselineRuleList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 无
        :type List: list of BaselineRule
        :param _Total: 总数
        :type Total: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._Total = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = BaselineRule()
                obj._deserialize(item)
                self._List.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeBaselineRuleRequest(AbstractModel):
    """DescribeBaselineRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _BaselineId: 基线id
        :type BaselineId: int
        :param _Limit: 分页参数 最大100条
        :type Limit: int
        :param _Offset: 分页参数
        :type Offset: int
        :param _Level: 危害等级
        :type Level: list of int non-negative
        :param _Status: 状态
        :type Status: int
        :param _Quuid: 主机quuid
        :type Quuid: str
        :param _Uuid: 主机uuid
        :type Uuid: str
        """
        self._BaselineId = None
        self._Limit = None
        self._Offset = None
        self._Level = None
        self._Status = None
        self._Quuid = None
        self._Uuid = None

    @property
    def BaselineId(self):
        return self._BaselineId

    @BaselineId.setter
    def BaselineId(self, BaselineId):
        self._BaselineId = BaselineId

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Level(self):
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid


    def _deserialize(self, params):
        self._BaselineId = params.get("BaselineId")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Level = params.get("Level")
        self._Status = params.get("Status")
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselineRuleResponse(AbstractModel):
    """DescribeBaselineRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 分页查询记录总数
        :type TotalCount: int
        :param _BaselineRuleList: 基线检测项列表
注意：此字段可能返回 null，表示取不到有效值。
        :type BaselineRuleList: list of BaselineRuleInfo
        :param _ShowRuleRemark: 是否显示说明列：true-是，false-否
注意：此字段可能返回 null，表示取不到有效值。
        :type ShowRuleRemark: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._BaselineRuleList = None
        self._ShowRuleRemark = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def BaselineRuleList(self):
        return self._BaselineRuleList

    @BaselineRuleList.setter
    def BaselineRuleList(self, BaselineRuleList):
        self._BaselineRuleList = BaselineRuleList

    @property
    def ShowRuleRemark(self):
        return self._ShowRuleRemark

    @ShowRuleRemark.setter
    def ShowRuleRemark(self, ShowRuleRemark):
        self._ShowRuleRemark = ShowRuleRemark

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("BaselineRuleList") is not None:
            self._BaselineRuleList = []
            for item in params.get("BaselineRuleList"):
                obj = BaselineRuleInfo()
                obj._deserialize(item)
                self._BaselineRuleList.append(obj)
        self._ShowRuleRemark = params.get("ShowRuleRemark")
        self._RequestId = params.get("RequestId")


class DescribeBaselineScanScheduleRequest(AbstractModel):
    """DescribeBaselineScanSchedule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: int
        """
        self._TaskId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselineScanScheduleResponse(AbstractModel):
    """DescribeBaselineScanSchedule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Schedule: 检测进度(百分比)
注意：此字段可能返回 null，表示取不到有效值。
        :type Schedule: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Schedule = None
        self._RequestId = None

    @property
    def Schedule(self):
        return self._Schedule

    @Schedule.setter
    def Schedule(self, Schedule):
        self._Schedule = Schedule

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Schedule = params.get("Schedule")
        self._RequestId = params.get("RequestId")


class DescribeBaselineStrategyDetailRequest(AbstractModel):
    """DescribeBaselineStrategyDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StrategyId: 用户基线策略id
        :type StrategyId: int
        """
        self._StrategyId = None

    @property
    def StrategyId(self):
        return self._StrategyId

    @StrategyId.setter
    def StrategyId(self, StrategyId):
        self._StrategyId = StrategyId


    def _deserialize(self, params):
        self._StrategyId = params.get("StrategyId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselineStrategyDetailResponse(AbstractModel):
    """DescribeBaselineStrategyDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _PassRate: 策略扫描通过率
注意：此字段可能返回 null，表示取不到有效值。
        :type PassRate: int
        :param _StrategyName: 策略名
注意：此字段可能返回 null，表示取不到有效值。
        :type StrategyName: str
        :param _ScanCycle: 策略扫描周期(天)
注意：此字段可能返回 null，表示取不到有效值。
        :type ScanCycle: str
        :param _ScanAt: 定期检测时间, 该时间下发扫描
注意：此字段可能返回 null，表示取不到有效值。
        :type ScanAt: str
        :param _IsGlobal: 扫描范围是否全部服务器, 1:是  0:否, 为1则为全部专业版主机
注意：此字段可能返回 null，表示取不到有效值。
        :type IsGlobal: int
        :param _MachineType: 云服务器类型：
cvm：腾讯云服务器
bm：裸金属
ecm：边缘计算主机
lh: 轻量应用服务器
ohter: 混合云机器
注意：此字段可能返回 null，表示取不到有效值。
        :type MachineType: str
        :param _Region: 主机地域
注意：此字段可能返回 null，表示取不到有效值。
        :type Region: str
        :param _Quuids: 用户该策略下的所有主机id
注意：此字段可能返回 null，表示取不到有效值。
        :type Quuids: list of str
        :param _CategoryIds: 用户该策略下所有的基线id
注意：此字段可能返回 null，表示取不到有效值。
        :type CategoryIds: list of str
        :param _IfScanned: 1 表示扫描过, 0没扫描过
注意：此字段可能返回 null，表示取不到有效值。
        :type IfScanned: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._PassRate = None
        self._StrategyName = None
        self._ScanCycle = None
        self._ScanAt = None
        self._IsGlobal = None
        self._MachineType = None
        self._Region = None
        self._Quuids = None
        self._CategoryIds = None
        self._IfScanned = None
        self._RequestId = None

    @property
    def PassRate(self):
        return self._PassRate

    @PassRate.setter
    def PassRate(self, PassRate):
        self._PassRate = PassRate

    @property
    def StrategyName(self):
        return self._StrategyName

    @StrategyName.setter
    def StrategyName(self, StrategyName):
        self._StrategyName = StrategyName

    @property
    def ScanCycle(self):
        return self._ScanCycle

    @ScanCycle.setter
    def ScanCycle(self, ScanCycle):
        self._ScanCycle = ScanCycle

    @property
    def ScanAt(self):
        return self._ScanAt

    @ScanAt.setter
    def ScanAt(self, ScanAt):
        self._ScanAt = ScanAt

    @property
    def IsGlobal(self):
        return self._IsGlobal

    @IsGlobal.setter
    def IsGlobal(self, IsGlobal):
        self._IsGlobal = IsGlobal

    @property
    def MachineType(self):
        return self._MachineType

    @MachineType.setter
    def MachineType(self, MachineType):
        self._MachineType = MachineType

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Quuids(self):
        return self._Quuids

    @Quuids.setter
    def Quuids(self, Quuids):
        self._Quuids = Quuids

    @property
    def CategoryIds(self):
        return self._CategoryIds

    @CategoryIds.setter
    def CategoryIds(self, CategoryIds):
        self._CategoryIds = CategoryIds

    @property
    def IfScanned(self):
        return self._IfScanned

    @IfScanned.setter
    def IfScanned(self, IfScanned):
        self._IfScanned = IfScanned

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._PassRate = params.get("PassRate")
        self._StrategyName = params.get("StrategyName")
        self._ScanCycle = params.get("ScanCycle")
        self._ScanAt = params.get("ScanAt")
        self._IsGlobal = params.get("IsGlobal")
        self._MachineType = params.get("MachineType")
        self._Region = params.get("Region")
        self._Quuids = params.get("Quuids")
        self._CategoryIds = params.get("CategoryIds")
        self._IfScanned = params.get("IfScanned")
        self._RequestId = params.get("RequestId")


class DescribeBaselineStrategyListRequest(AbstractModel):
    """DescribeBaselineStrategyList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 分页参数 最大100
        :type Limit: int
        :param _Offset: 分页参数
        :type Offset: int
        :param _Enabled: 规则开关，1：打开 0：关闭  2:全部
        :type Enabled: int
        """
        self._Limit = None
        self._Offset = None
        self._Enabled = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Enabled(self):
        return self._Enabled

    @Enabled.setter
    def Enabled(self, Enabled):
        self._Enabled = Enabled


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Enabled = params.get("Enabled")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselineStrategyListResponse(AbstractModel):
    """DescribeBaselineStrategyList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 分页查询记录的总数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _StrategyList: 用户策略信息列表
注意：此字段可能返回 null，表示取不到有效值。
        :type StrategyList: list of Strategy
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._StrategyList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def StrategyList(self):
        return self._StrategyList

    @StrategyList.setter
    def StrategyList(self, StrategyList):
        self._StrategyList = StrategyList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("StrategyList") is not None:
            self._StrategyList = []
            for item in params.get("StrategyList"):
                obj = Strategy()
                obj._deserialize(item)
                self._StrategyList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBaselineTopRequest(AbstractModel):
    """DescribeBaselineTop请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Top: 动态top值
        :type Top: int
        :param _StrategyId: 策略id
        :type StrategyId: int
        """
        self._Top = None
        self._StrategyId = None

    @property
    def Top(self):
        return self._Top

    @Top.setter
    def Top(self, Top):
        self._Top = Top

    @property
    def StrategyId(self):
        return self._StrategyId

    @StrategyId.setter
    def StrategyId(self, StrategyId):
        self._StrategyId = StrategyId


    def _deserialize(self, params):
        self._Top = params.get("Top")
        self._StrategyId = params.get("StrategyId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselineTopResponse(AbstractModel):
    """DescribeBaselineTop返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleTopList: 检测项Top列表
注意：此字段可能返回 null，表示取不到有效值。
        :type RuleTopList: list of BaselineRuleTopInfo
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RuleTopList = None
        self._RequestId = None

    @property
    def RuleTopList(self):
        return self._RuleTopList

    @RuleTopList.setter
    def RuleTopList(self, RuleTopList):
        self._RuleTopList = RuleTopList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RuleTopList") is not None:
            self._RuleTopList = []
            for item in params.get("RuleTopList"):
                obj = BaselineRuleTopInfo()
                obj._deserialize(item)
                self._RuleTopList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBaselineWeakPasswordListRequest(AbstractModel):
    """DescribeBaselineWeakPasswordList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: <li>WeakPassword - string - 是否必填：否 - 弱口令</li>
        :type Filters: list of Filter
        :param _Limit: 限制条数,默认10,最大100
        :type Limit: int
        :param _Offset: 偏移量,默认0
        :type Offset: int
        :param _Order: 排序方式 [ASC:升序|DESC:降序]
        :type Order: str
        :param _By: 可选排序列 [CreateTime|ModifyTime]
        :type By: str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBaselineWeakPasswordListResponse(AbstractModel):
    """DescribeBaselineWeakPasswordList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Total: 总数
        :type Total: int
        :param _List: 无
        :type List: list of BaselineWeakPassword
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Total = None
        self._List = None
        self._RequestId = None

    @property
    def Total(self):
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = BaselineWeakPassword()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBashEventsInfoNewRequest(AbstractModel):
    """DescribeBashEventsInfoNew请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 事件id
        :type Id: int
        """
        self._Id = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBashEventsInfoNewResponse(AbstractModel):
    """DescribeBashEventsInfoNew返回参数结构体

    """

    def __init__(self):
        r"""
        :param _BashEventsInfo: 事件详情
注意：此字段可能返回 null，表示取不到有效值。
        :type BashEventsInfo: :class:`tencentcloud.cwp.v20180228.models.BashEventsInfoNew`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._BashEventsInfo = None
        self._RequestId = None

    @property
    def BashEventsInfo(self):
        return self._BashEventsInfo

    @BashEventsInfo.setter
    def BashEventsInfo(self, BashEventsInfo):
        self._BashEventsInfo = BashEventsInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("BashEventsInfo") is not None:
            self._BashEventsInfo = BashEventsInfoNew()
            self._BashEventsInfo._deserialize(params.get("BashEventsInfo"))
        self._RequestId = params.get("RequestId")


class DescribeBashEventsNewRequest(AbstractModel):
    """DescribeBashEventsNew请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 返回数量，默认为10，最大值为100。
        :type Limit: int
        :param _Filters: 过滤条件。
<li>HostName - String - 是否必填：否 - 主机名</li>
<li>Hostip - String - 是否必填：否 - 主机内网IP</li>
<li>HostIp - String - 是否必填：否 - 主机内网IP</li>
<li>RuleCategory - Int - 是否必填：否 - 策略类型,全部或者单选(0:系统 1:用户)</li>
<li>RuleName - String - 是否必填：否 - 策略名称</li>
<li>RuleLevel - Int - 是否必填：否 - 威胁等级,可以多选</li>
<li>Status - Int - 是否必填：否 - 处理状态,可多选(0:待处理 1:已处理 2:已加白  3:已忽略 4:已删除 5:已拦截)</li>
<li>DetectBy - Int - 是否必填：否 - 数据来源,可多选(0:bash日志 1:实时监控)</li>
<li>StartTime - String - 是否必填：否 - 开始时间</li>
<li>EndTime - String - 是否必填：否 - 结束时间</li>
        :type Filters: list of Filter
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Order: 排序方式：根据请求次数排序：asc-升序/desc-降序
        :type Order: str
        :param _By: 排序字段：CreateTime-发生时间。ModifyTime-处理时间
        :type By: str
        """
        self._Limit = None
        self._Filters = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBashEventsNewResponse(AbstractModel):
    """DescribeBashEventsNew返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总条数
        :type TotalCount: int
        :param _List: 高危命令事件列表
        :type List: list of BashEventNew
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._List = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = BashEventNew()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBashEventsRequest(AbstractModel):
    """DescribeBashEvents请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 返回数量，默认为10，最大值为100。
        :type Limit: int
        :param _Filters: 过滤条件。
<li>HostName - String - 是否必填：否 - 主机名</li>
<li>Hostip - String - 是否必填：否 - 主机内网IP</li>
<li>RuleCategory - Int - 是否必填：否 - 策略类型,全部或者单选(0:系统 1:用户)</li>
<li>RuleName - String - 是否必填：否 - 策略名称</li>
<li>RuleLevel - Int - 是否必填：否 - 威胁等级,可以多选</li>
<li>Status - Int - 是否必填：否 - 处理状态,可多选(0:待处理 1:已处理 2:已加白  3:已忽略 4:已删除 5:已拦截)</li>
<li>DetectBy - Int - 是否必填：否 - 数据来源,可多选(0:bash日志 1:实时监控)</li>
<li>StartTime - String - 是否必填：否 - 开始时间</li>
<li>EndTime - String - 是否必填：否 - 结束时间</li>
        :type Filters: list of Filter
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Order: 排序方式：根据请求次数排序：asc-升序/desc-降序
        :type Order: str
        :param _By: 排序字段：CreateTime-发生时间。ModifyTime-处理时间
        :type By: str
        """
        self._Limit = None
        self._Filters = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBashEventsResponse(AbstractModel):
    """DescribeBashEvents返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总条数
        :type TotalCount: int
        :param _List: 高危命令事件列表
        :type List: list of BashEvent
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._List = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = BashEvent()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBashRulesRequest(AbstractModel):
    """DescribeBashRules请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Type: 0-系统规则; 1-用户规则
        :type Type: int
        :param _Limit: 返回数量，最大值为100。
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>Keywords - String - 是否必填：否 - 关键字(规则名称)</li>
        :type Filters: list of Filter
        """
        self._Type = None
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBashRulesResponse(AbstractModel):
    """DescribeBashRules返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 列表内容
        :type List: list of BashRule
        :param _TotalCount: 总条数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = BashRule()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeBruteAttackListRequest(AbstractModel):
    """DescribeBruteAttackList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 需要返回的数量，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>IpOrAlias - String - 是否必填：否 - 主机ip或别名筛选</li>
<li>Uuid - String - 是否必填：否 - 主机安全唯一Uuid</li>
<li>Quuid - String - 是否必填：否 - 云服务器uuid</li>
<li>Status - String - 是否必填：否 - 状态筛选：失败：FAILED 成功：SUCCESS</li>
<li>UserName - String - 是否必填：否 - UserName筛选</li>
<li>SrcIp - String - 是否必填：否 - 来源ip筛选</li>
<li>CreateBeginTime - String - 是否必填：否 - 首次攻击时间筛选，开始时间</li>
<li>CreateEndTime - String - 是否必填：否 - 首次攻击时间筛选，结束时间</li>
<li>ModifyBeginTime - String - 是否必填：否 - 最近攻击时间筛选，开始时间</li>
<li>ModifyEndTime - String - 是否必填：否 - 最近攻击时间筛选，结束时间</li>
<li>Banned - String - 是否必填：否 - 阻断状态筛选，多个用","分割：0-未阻断（全局ZK开关关闭），82-未阻断(非专业版)，83-未阻断(已加白名单)，1-已阻断，2-未阻断-程序异常，3-未阻断-内网攻击暂不支持阻断，4-未阻断-安平暂不支持阻断</li>
        :type Filters: list of Filter
        :param _Order: 排序方式：根据请求次数排序：asc-升序/desc-降序
        :type Order: str
        :param _By: 排序字段：CreateTime-首次攻击时间
        :type By: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBruteAttackListResponse(AbstractModel):
    """DescribeBruteAttackList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _BruteAttackList: 密码破解列表
注意：此字段可能返回 null，表示取不到有效值。
        :type BruteAttackList: list of BruteAttackInfo
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._BruteAttackList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def BruteAttackList(self):
        return self._BruteAttackList

    @BruteAttackList.setter
    def BruteAttackList(self, BruteAttackList):
        self._BruteAttackList = BruteAttackList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("BruteAttackList") is not None:
            self._BruteAttackList = []
            for item in params.get("BruteAttackList"):
                obj = BruteAttackInfo()
                obj._deserialize(item)
                self._BruteAttackList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBruteAttackRulesRequest(AbstractModel):
    """DescribeBruteAttackRules请求参数结构体

    """


class DescribeBruteAttackRulesResponse(AbstractModel):
    """DescribeBruteAttackRules返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Rules: 爆破阻断规则列表
        :type Rules: list of BruteAttackRuleList
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Rules = None
        self._RequestId = None

    @property
    def Rules(self):
        return self._Rules

    @Rules.setter
    def Rules(self, Rules):
        self._Rules = Rules

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Rules") is not None:
            self._Rules = []
            for item in params.get("Rules"):
                obj = BruteAttackRuleList()
                obj._deserialize(item)
                self._Rules.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeClientExceptionRequest(AbstractModel):
    """DescribeClientException请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ExceptionType: 客户端异常类型 1:客户端离线，2:客户端卸载
        :type ExceptionType: int
        :param _Offset: 分页的偏移量
        :type Offset: int
        :param _Limit: 分页单页限制数目，不为0，最大值100
        :type Limit: int
        :param _StartTime: 起始时间 `2006-01-02 15:04:05` 格式
        :type StartTime: str
        :param _EndTime: 结束时间 `2006-01-02 15:04:05` 格式
        :type EndTime: str
        """
        self._ExceptionType = None
        self._Offset = None
        self._Limit = None
        self._StartTime = None
        self._EndTime = None

    @property
    def ExceptionType(self):
        return self._ExceptionType

    @ExceptionType.setter
    def ExceptionType(self, ExceptionType):
        self._ExceptionType = ExceptionType

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._ExceptionType = params.get("ExceptionType")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClientExceptionResponse(AbstractModel):
    """DescribeClientException返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 事件总数量
        :type TotalCount: int
        :param _Records: 事件详情
        :type Records: list of RecordInfo
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._Records = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Records(self):
        return self._Records

    @Records.setter
    def Records(self, Records):
        self._Records = Records

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Records") is not None:
            self._Records = []
            for item in params.get("Records"):
                obj = RecordInfo()
                obj._deserialize(item)
                self._Records.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeComponentStatisticsRequest(AbstractModel):
    """DescribeComponentStatistics请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 返回数量，默认为10，最大值为100。
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
ComponentName - String - 是否必填：否 - 组件名称
        :type Filters: list of Filter
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeComponentStatisticsResponse(AbstractModel):
    """DescribeComponentStatistics返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 组件统计列表记录总数。
        :type TotalCount: int
        :param _ComponentStatistics: 组件统计列表数据数组。
        :type ComponentStatistics: list of ComponentStatistics
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._ComponentStatistics = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ComponentStatistics(self):
        return self._ComponentStatistics

    @ComponentStatistics.setter
    def ComponentStatistics(self, ComponentStatistics):
        self._ComponentStatistics = ComponentStatistics

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ComponentStatistics") is not None:
            self._ComponentStatistics = []
            for item in params.get("ComponentStatistics"):
                obj = ComponentStatistics()
                obj._deserialize(item)
                self._ComponentStatistics.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeESAggregationsRequest(AbstractModel):
    """DescribeESAggregations请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Query: ES聚合条件JSON
        :type Query: str
        """
        self._Query = None

    @property
    def Query(self):
        return self._Query

    @Query.setter
    def Query(self, Query):
        self._Query = Query


    def _deserialize(self, params):
        self._Query = params.get("Query")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeESAggregationsResponse(AbstractModel):
    """DescribeESAggregations返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: ES聚合结果JSON
        :type Data: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DescribeEmergencyResponseListRequest(AbstractModel):
    """DescribeEmergencyResponseList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤条件。
<li>Keyword- String - 是否必填：否 - 关键词过滤，</li>
<li>Uuids - String - 是否必填：否 - 主机id过滤</li>
        :type Filters: list of Filters
        :param _Limit: 需要返回的数量，最大值为100
        :type Limit: int
        :param _Offset: 排序步长
        :type Offset: int
        :param _Order: 排序方法
        :type Order: str
        :param _By: 排序字段 StartTime，EndTime
        :type By: str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEmergencyResponseListResponse(AbstractModel):
    """DescribeEmergencyResponseList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总条数
        :type TotalCount: int
        :param _List: 应急响应列表
        :type List: list of EmergencyResponseInfo
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._List = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = EmergencyResponseInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeEmergencyVulListRequest(AbstractModel):
    """DescribeEmergencyVulList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 返回数量，最大值为100。
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>Status - String - 是否必填：是 - 漏洞状态筛选，0//未检测 1有风险 ，2无风险 ，3 检查中展示progress</li>
<li>Level - String - 是否必填：否 - 漏洞等级筛选 1:低 2:中 3:高 4:提示</li>
<li>VulName- String - 是否必填：否 - 漏洞名称搜索</li>
<li>Uuids- String - 是否必填：否 - 主机uuid</li>
<li>IsSupportDefense - int- 是否必填：否 - 是否支持防御 0:不支持 1:支持</li>
        :type Filters: list of Filters
        :param _Order: 排序方式 desc , asc
        :type Order: str
        :param _By: 排序字段 PublishDate  LastScanTime HostCount
        :type By: str
        :param _HotspotAttack: 是否热点漏洞
        :type HotspotAttack: bool
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None
        self._HotspotAttack = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def HotspotAttack(self):
        return self._HotspotAttack

    @HotspotAttack.setter
    def HotspotAttack(self, HotspotAttack):
        self._HotspotAttack = HotspotAttack


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        self._HotspotAttack = params.get("HotspotAttack")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEmergencyVulListResponse(AbstractModel):
    """DescribeEmergencyVulList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 漏洞列表
注意：此字段可能返回 null，表示取不到有效值。
        :type List: list of EmergencyVul
        :param _TotalCount: 漏洞总条数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _ExistsRisk: 是否存在风险
注意：此字段可能返回 null，表示取不到有效值。
        :type ExistsRisk: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._ExistsRisk = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ExistsRisk(self):
        return self._ExistsRisk

    @ExistsRisk.setter
    def ExistsRisk(self, ExistsRisk):
        self._ExistsRisk = ExistsRisk

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = EmergencyVul()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._ExistsRisk = params.get("ExistsRisk")
        self._RequestId = params.get("RequestId")


class DescribeEventByTableRequest(AbstractModel):
    """DescribeEventByTable请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TableName: 事件表名
        :type TableName: str
        :param _Ids: 事件表id号
        :type Ids: list of int
        """
        self._TableName = None
        self._Ids = None

    @property
    def TableName(self):
        return self._TableName

    @TableName.setter
    def TableName(self, TableName):
        self._TableName = TableName

    @property
    def Ids(self):
        return self._Ids

    @Ids.setter
    def Ids(self, Ids):
        self._Ids = Ids


    def _deserialize(self, params):
        self._TableName = params.get("TableName")
        self._Ids = params.get("Ids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEventByTableResponse(AbstractModel):
    """DescribeEventByTable返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Type: 告警类型，爆破bruteattack，高危命令bash，恶意文件malware，恶意请求risk_dns，本地提权privilege_escalation，反弹shell reverse_shell，内存马java_shell
        :type Type: str
        :param _Value: 事件内容的json编码字符串，字段结构对齐事件表
        :type Value: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Type = None
        self._Value = None
        self._RequestId = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Value(self):
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Value = params.get("Value")
        self._RequestId = params.get("RequestId")


class DescribeExpertServiceListRequest(AbstractModel):
    """DescribeExpertServiceList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤条件。
<li>Keyword- String - 是否必填：否 - 关键词过滤，</li>
<li>Uuids - String - 是否必填：否 - 主机id过滤</li>
        :type Filters: list of Filters
        :param _Limit: 需要返回的数量，最大值为100
        :type Limit: int
        :param _Offset: 排序步长
        :type Offset: int
        :param _Order: 排序方法
        :type Order: str
        :param _By: 排序字段 StartTime，EndTime
        :type By: str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeExpertServiceListResponse(AbstractModel):
    """DescribeExpertServiceList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总条数
        :type TotalCount: int
        :param _List: 安全管家数据
        :type List: list of SecurityButlerInfo
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._List = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = SecurityButlerInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeExpertServiceOrderListRequest(AbstractModel):
    """DescribeExpertServiceOrderList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: <li>InquireType- String - 是否必填：否 - 订单类型过滤，</li>
        :type Filters: list of Filters
        :param _Limit: 分页条数 最大100条
        :type Limit: int
        :param _Offset: 分页步长
        :type Offset: int
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeExpertServiceOrderListResponse(AbstractModel):
    """DescribeExpertServiceOrderList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总条数
        :type TotalCount: int
        :param _List: 订单列表
        :type List: list of ExpertServiceOrderInfo
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._List = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ExpertServiceOrderInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeExportMachinesRequest(AbstractModel):
    """DescribeExportMachines请求参数结构体

    """

    def __init__(self):
        r"""
        :param _MachineType: 云主机类型。
<li>CVM：表示虚拟主机</li>
<li>BM:  表示黑石物理机</li>
        :type MachineType: str
        :param _MachineRegion: 机器所属地域。如：ap-guangzhou，ap-shanghai
        :type MachineRegion: str
        :param _Limit: 返回数量，默认为10，最大值为100。
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>Keywords - String - 是否必填：否 - 查询关键字 </li>
<li>Status - String - 是否必填：否 - 客户端在线状态（OFFLINE: 离线 | ONLINE: 在线 | UNINSTALLED：未安装）</li>
<li>Version - String  是否必填：否 - 当前防护版本（ PRO_VERSION：专业版 | BASIC_VERSION：基础版）</li>
每个过滤条件只支持一个值，暂不支持多个值“或”关系查询
        :type Filters: list of Filter
        :param _ProjectIds: 机器所属业务ID列表
        :type ProjectIds: list of int non-negative
        """
        self._MachineType = None
        self._MachineRegion = None
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._ProjectIds = None

    @property
    def MachineType(self):
        return self._MachineType

    @MachineType.setter
    def MachineType(self, MachineType):
        self._MachineType = MachineType

    @property
    def MachineRegion(self):
        return self._MachineRegion

    @MachineRegion.setter
    def MachineRegion(self, MachineRegion):
        self._MachineRegion = MachineRegion

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def ProjectIds(self):
        return self._ProjectIds

    @ProjectIds.setter
    def ProjectIds(self, ProjectIds):
        self._ProjectIds = ProjectIds


    def _deserialize(self, params):
        self._MachineType = params.get("MachineType")
        self._MachineRegion = params.get("MachineRegion")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._ProjectIds = params.get("ProjectIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeExportMachinesResponse(AbstractModel):
    """DescribeExportMachines返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务ID,需要到接口“异步导出任务”ExportTasks获取DownloadUrl下载地址
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class DescribeFileTamperEventsRequest(AbstractModel):
    """DescribeFileTamperEvents请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤条件。
<li>Status - String - 是否必填：否 - 处理状态  0 -- 待处理 1 -- 已加白 2 -- 已删除 3 - 已忽略</li>
<li>ModifyTime - String - 是否必填：否 - 最近发生时间</li>
<li>Uuid- String - 是否必填：否 - 主机uuid查询</li>
<li>RuleCategory- string - 是否必填：否 - 规则类别 0 系统规则 1 自定义规则</li>
<li>FileAction- string - 是否必填：否 - 威胁行为 read 读取文件 write 写文件</li>
        :type Filters: list of Filters
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Order: 排序方式 ASC,DESC
        :type Order: str
        :param _By: 排序字段 CreateTime、ModifyTime
        :type By: str
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFileTamperEventsResponse(AbstractModel):
    """DescribeFileTamperEvents返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 核心文件事件列表
注意：此字段可能返回 null，表示取不到有效值。
        :type List: list of FileTamperEvent
        :param _TotalCount: 数据总条数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = FileTamperEvent()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeGeneralStatRequest(AbstractModel):
    """DescribeGeneralStat请求参数结构体

    """

    def __init__(self):
        r"""
        :param _MachineType: 云主机类型。
<li>CVM：表示腾讯云服务器</li>
<li>BM:  表示黑石物理机</li>
<li>ECM:  表示边缘计算服务器</li>
<li>LH:  表示轻量应用服务器</li>
<li>Other:  表示混合云机器</li>
        :type MachineType: str
        :param _MachineRegion: 机器所属地域。如：ap-guangzhou，ap-shanghai
        :type MachineRegion: str
        """
        self._MachineType = None
        self._MachineRegion = None

    @property
    def MachineType(self):
        return self._MachineType

    @MachineType.setter
    def MachineType(self, MachineType):
        self._MachineType = MachineType

    @property
    def MachineRegion(self):
        return self._MachineRegion

    @MachineRegion.setter
    def MachineRegion(self, MachineRegion):
        self._MachineRegion = MachineRegion


    def _deserialize(self, params):
        self._MachineType = params.get("MachineType")
        self._MachineRegion = params.get("MachineRegion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeGeneralStatResponse(AbstractModel):
    """DescribeGeneralStat返回参数结构体

    """

    def __init__(self):
        r"""
        :param _MachinesAll: 云主机总数
        :type MachinesAll: int
        :param _MachinesUninstalled: 云主机没有安装主机安全客户端的总数
        :type MachinesUninstalled: int
        :param _AgentsAll: 主机安全客户端总数的总数
        :type AgentsAll: int
        :param _AgentsOnline: 主机安全客户端在线的总数
        :type AgentsOnline: int
        :param _AgentsOffline: 主机安全客户端 离线+关机 的总数
        :type AgentsOffline: int
        :param _AgentsPro: 主机安全客户端专业版的总数
        :type AgentsPro: int
        :param _AgentsBasic: 主机安全客户端基础版的总数
        :type AgentsBasic: int
        :param _AgentsProExpireWithInSevenDays: 7天内到期的预付费专业版总数
        :type AgentsProExpireWithInSevenDays: int
        :param _RiskMachine: 风险主机总数
        :type RiskMachine: int
        :param _Shutdown: 已关机总数
        :type Shutdown: int
        :param _Offline: 已离线总数
        :type Offline: int
        :param _FlagshipMachineCnt: 旗舰版主机数
注意：此字段可能返回 null，表示取不到有效值。
        :type FlagshipMachineCnt: int
        :param _ProtectDays: 保护天数
注意：此字段可能返回 null，表示取不到有效值。
        :type ProtectDays: int
        :param _AddedOnTheFifteen: 15天内新增的主机数
注意：此字段可能返回 null，表示取不到有效值。
        :type AddedOnTheFifteen: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._MachinesAll = None
        self._MachinesUninstalled = None
        self._AgentsAll = None
        self._AgentsOnline = None
        self._AgentsOffline = None
        self._AgentsPro = None
        self._AgentsBasic = None
        self._AgentsProExpireWithInSevenDays = None
        self._RiskMachine = None
        self._Shutdown = None
        self._Offline = None
        self._FlagshipMachineCnt = None
        self._ProtectDays = None
        self._AddedOnTheFifteen = None
        self._RequestId = None

    @property
    def MachinesAll(self):
        return self._MachinesAll

    @MachinesAll.setter
    def MachinesAll(self, MachinesAll):
        self._MachinesAll = MachinesAll

    @property
    def MachinesUninstalled(self):
        return self._MachinesUninstalled

    @MachinesUninstalled.setter
    def MachinesUninstalled(self, MachinesUninstalled):
        self._MachinesUninstalled = MachinesUninstalled

    @property
    def AgentsAll(self):
        return self._AgentsAll

    @AgentsAll.setter
    def AgentsAll(self, AgentsAll):
        self._AgentsAll = AgentsAll

    @property
    def AgentsOnline(self):
        return self._AgentsOnline

    @AgentsOnline.setter
    def AgentsOnline(self, AgentsOnline):
        self._AgentsOnline = AgentsOnline

    @property
    def AgentsOffline(self):
        return self._AgentsOffline

    @AgentsOffline.setter
    def AgentsOffline(self, AgentsOffline):
        self._AgentsOffline = AgentsOffline

    @property
    def AgentsPro(self):
        return self._AgentsPro

    @AgentsPro.setter
    def AgentsPro(self, AgentsPro):
        self._AgentsPro = AgentsPro

    @property
    def AgentsBasic(self):
        return self._AgentsBasic

    @AgentsBasic.setter
    def AgentsBasic(self, AgentsBasic):
        self._AgentsBasic = AgentsBasic

    @property
    def AgentsProExpireWithInSevenDays(self):
        return self._AgentsProExpireWithInSevenDays

    @AgentsProExpireWithInSevenDays.setter
    def AgentsProExpireWithInSevenDays(self, AgentsProExpireWithInSevenDays):
        self._AgentsProExpireWithInSevenDays = AgentsProExpireWithInSevenDays

    @property
    def RiskMachine(self):
        return self._RiskMachine

    @RiskMachine.setter
    def RiskMachine(self, RiskMachine):
        self._RiskMachine = RiskMachine

    @property
    def Shutdown(self):
        return self._Shutdown

    @Shutdown.setter
    def Shutdown(self, Shutdown):
        self._Shutdown = Shutdown

    @property
    def Offline(self):
        return self._Offline

    @Offline.setter
    def Offline(self, Offline):
        self._Offline = Offline

    @property
    def FlagshipMachineCnt(self):
        return self._FlagshipMachineCnt

    @FlagshipMachineCnt.setter
    def FlagshipMachineCnt(self, FlagshipMachineCnt):
        self._FlagshipMachineCnt = FlagshipMachineCnt

    @property
    def ProtectDays(self):
        return self._ProtectDays

    @ProtectDays.setter
    def ProtectDays(self, ProtectDays):
        self._ProtectDays = ProtectDays

    @property
    def AddedOnTheFifteen(self):
        return self._AddedOnTheFifteen

    @AddedOnTheFifteen.setter
    def AddedOnTheFifteen(self, AddedOnTheFifteen):
        self._AddedOnTheFifteen = AddedOnTheFifteen

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._MachinesAll = params.get("MachinesAll")
        self._MachinesUninstalled = params.get("MachinesUninstalled")
        self._AgentsAll = params.get("AgentsAll")
        self._AgentsOnline = params.get("AgentsOnline")
        self._AgentsOffline = params.get("AgentsOffline")
        self._AgentsPro = params.get("AgentsPro")
        self._AgentsBasic = params.get("AgentsBasic")
        self._AgentsProExpireWithInSevenDays = params.get("AgentsProExpireWithInSevenDays")
        self._RiskMachine = params.get("RiskMachine")
        self._Shutdown = params.get("Shutdown")
        self._Offline = params.get("Offline")
        self._FlagshipMachineCnt = params.get("FlagshipMachineCnt")
        self._ProtectDays = params.get("ProtectDays")
        self._AddedOnTheFifteen = params.get("AddedOnTheFifteen")
        self._RequestId = params.get("RequestId")


class DescribeHistoryAccountsRequest(AbstractModel):
    """DescribeHistoryAccounts请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Uuid: 云镜客户端唯一Uuid。
        :type Uuid: str
        :param _Limit: 返回数量，默认为10，最大值为100。
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>Username - String - 是否必填：否 - 帐号名</li>
        :type Filters: list of Filter
        """
        self._Uuid = None
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Uuid = params.get("Uuid")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeHistoryAccountsResponse(AbstractModel):
    """DescribeHistoryAccounts返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 帐号变更历史列表记录总数。
        :type TotalCount: int
        :param _HistoryAccounts: 帐号变更历史数据数组。
        :type HistoryAccounts: list of HistoryAccount
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._HistoryAccounts = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def HistoryAccounts(self):
        return self._HistoryAccounts

    @HistoryAccounts.setter
    def HistoryAccounts(self, HistoryAccounts):
        self._HistoryAccounts = HistoryAccounts

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("HistoryAccounts") is not None:
            self._HistoryAccounts = []
            for item in params.get("HistoryAccounts"):
                obj = HistoryAccount()
                obj._deserialize(item)
                self._HistoryAccounts.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeHistoryServiceRequest(AbstractModel):
    """DescribeHistoryService请求参数结构体

    """


class DescribeHistoryServiceResponse(AbstractModel):
    """DescribeHistoryService返回参数结构体

    """

    def __init__(self):
        r"""
        :param _BuyStatus: 1 可购买 2 只能升降配 3 只能跳到续费管理页
        :type BuyStatus: int
        :param _InquireNum: 用户已购容量 单位 G
        :type InquireNum: int
        :param _EndTime: 到期时间
        :type EndTime: str
        :param _IsAutoOpenRenew: 是否自动续费,0 初始值, 1 开通 2 没开通
        :type IsAutoOpenRenew: int
        :param _ResourceId: 资源ID
        :type ResourceId: str
        :param _Status: 0 没开通 1 正常 2隔离 3销毁
        :type Status: int
        :param _StartTime: 开始时间
        :type StartTime: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._BuyStatus = None
        self._InquireNum = None
        self._EndTime = None
        self._IsAutoOpenRenew = None
        self._ResourceId = None
        self._Status = None
        self._StartTime = None
        self._RequestId = None

    @property
    def BuyStatus(self):
        return self._BuyStatus

    @BuyStatus.setter
    def BuyStatus(self, BuyStatus):
        self._BuyStatus = BuyStatus

    @property
    def InquireNum(self):
        return self._InquireNum

    @InquireNum.setter
    def InquireNum(self, InquireNum):
        self._InquireNum = InquireNum

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def IsAutoOpenRenew(self):
        return self._IsAutoOpenRenew

    @IsAutoOpenRenew.setter
    def IsAutoOpenRenew(self, IsAutoOpenRenew):
        self._IsAutoOpenRenew = IsAutoOpenRenew

    @property
    def ResourceId(self):
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._BuyStatus = params.get("BuyStatus")
        self._InquireNum = params.get("InquireNum")
        self._EndTime = params.get("EndTime")
        self._IsAutoOpenRenew = params.get("IsAutoOpenRenew")
        self._ResourceId = params.get("ResourceId")
        self._Status = params.get("Status")
        self._StartTime = params.get("StartTime")
        self._RequestId = params.get("RequestId")


class DescribeHostLoginListRequest(AbstractModel):
    """DescribeHostLoginList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 需要返回的数量，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>IpOrAlias - String - 是否必填：否 - 主机ip或别名筛选</li>
<li>Uuid - String - 是否必填：否 - 主机安全唯一Uuid</li>
<li>Quuid - String - 是否必填：否 - 云服务器uuid</li>
<li>UserName - String - 是否必填：否 - 用户名筛选</li>
<li>LoginTimeBegin - String - 是否必填：否 - 按照修改时间段筛选，开始时间</li>
<li>LoginTimeEnd - String - 是否必填：否 - 按照修改时间段筛选，结束时间</li>
<li>SrcIp - String - 是否必填：否 - 来源ip筛选</li>
<li>Status - int - 是否必填：否 - 状态筛选1:正常登录；5：已加白,14:已处理，15：已忽略</li>
<li>RiskLevel - int - 是否必填：否 - 状态筛选0:高危；1：可疑</li>
        :type Filters: list of Filter
        :param _Order: 排序方式：根据请求次数排序：asc-升序/desc-降序
        :type Order: str
        :param _By: 排序字段：LoginTime-发生时间
        :type By: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeHostLoginListResponse(AbstractModel):
    """DescribeHostLoginList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总数
        :type TotalCount: int
        :param _HostLoginList: 登录审计列表
注意：此字段可能返回 null，表示取不到有效值。
        :type HostLoginList: list of HostLoginList
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._HostLoginList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def HostLoginList(self):
        return self._HostLoginList

    @HostLoginList.setter
    def HostLoginList(self, HostLoginList):
        self._HostLoginList = HostLoginList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("HostLoginList") is not None:
            self._HostLoginList = []
            for item in params.get("HostLoginList"):
                obj = HostLoginList()
                obj._deserialize(item)
                self._HostLoginList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeIgnoreBaselineRuleRequest(AbstractModel):
    """DescribeIgnoreBaselineRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 分页参数 最大100条
        :type Limit: int
        :param _Offset: 分页参数
        :type Offset: int
        :param _RuleName: 检测项名称
        :type RuleName: str
        """
        self._Limit = None
        self._Offset = None
        self._RuleName = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def RuleName(self):
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._RuleName = params.get("RuleName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIgnoreBaselineRuleResponse(AbstractModel):
    """DescribeIgnoreBaselineRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _IgnoreBaselineRuleList: 忽略基线检测项列表信息
注意：此字段可能返回 null，表示取不到有效值。
        :type IgnoreBaselineRuleList: list of IgnoreBaselineRule
        :param _TotalCount: 分页查询记录总数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._IgnoreBaselineRuleList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def IgnoreBaselineRuleList(self):
        return self._IgnoreBaselineRuleList

    @IgnoreBaselineRuleList.setter
    def IgnoreBaselineRuleList(self, IgnoreBaselineRuleList):
        self._IgnoreBaselineRuleList = IgnoreBaselineRuleList

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("IgnoreBaselineRuleList") is not None:
            self._IgnoreBaselineRuleList = []
            for item in params.get("IgnoreBaselineRuleList"):
                obj = IgnoreBaselineRule()
                obj._deserialize(item)
                self._IgnoreBaselineRuleList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeIgnoreHostAndItemConfigRequest(AbstractModel):
    """DescribeIgnoreHostAndItemConfig请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: <li>ItemId - int64 - 是否必填：否 - 项Id</i>
<li>RuleId - int64 - 是否必填：否 - 规则Id</li>
<li>HostId - string - 是否必填：否 - 主机Id</li>
        :type Filters: list of Filter
        """
        self._Filters = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIgnoreHostAndItemConfigResponse(AbstractModel):
    """DescribeIgnoreHostAndItemConfig返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ItemSet: 受影响检测项
注意：此字段可能返回 null，表示取不到有效值。
        :type ItemSet: list of BaselineItemInfo
        :param _HostSet: 受影响主机
注意：此字段可能返回 null，表示取不到有效值。
        :type HostSet: list of BaselineHost
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ItemSet = None
        self._HostSet = None
        self._RequestId = None

    @property
    def ItemSet(self):
        return self._ItemSet

    @ItemSet.setter
    def ItemSet(self, ItemSet):
        self._ItemSet = ItemSet

    @property
    def HostSet(self):
        return self._HostSet

    @HostSet.setter
    def HostSet(self, HostSet):
        self._HostSet = HostSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ItemSet") is not None:
            self._ItemSet = []
            for item in params.get("ItemSet"):
                obj = BaselineItemInfo()
                obj._deserialize(item)
                self._ItemSet.append(obj)
        if params.get("HostSet") is not None:
            self._HostSet = []
            for item in params.get("HostSet"):
                obj = BaselineHost()
                obj._deserialize(item)
                self._HostSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeIgnoreRuleEffectHostListRequest(AbstractModel):
    """DescribeIgnoreRuleEffectHostList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 分页参数 最大100条
        :type Limit: int
        :param _Offset: 分页参数
        :type Offset: int
        :param _RuleId: 检测项id
        :type RuleId: int
        :param _Filters: 过滤条件。
<li>AliasName- String- 主机别名</li>
        :type Filters: list of Filters
        :param _TagNames: 主机标签名
        :type TagNames: list of str
        """
        self._Limit = None
        self._Offset = None
        self._RuleId = None
        self._Filters = None
        self._TagNames = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def TagNames(self):
        return self._TagNames

    @TagNames.setter
    def TagNames(self, TagNames):
        self._TagNames = TagNames


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._RuleId = params.get("RuleId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._TagNames = params.get("TagNames")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIgnoreRuleEffectHostListResponse(AbstractModel):
    """DescribeIgnoreRuleEffectHostList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _IgnoreRuleEffectHostList: 忽略检测项影响主机列表
注意：此字段可能返回 null，表示取不到有效值。
        :type IgnoreRuleEffectHostList: list of IgnoreRuleEffectHostInfo
        :param _TotalCount: 分页查询记录总数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._IgnoreRuleEffectHostList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def IgnoreRuleEffectHostList(self):
        return self._IgnoreRuleEffectHostList

    @IgnoreRuleEffectHostList.setter
    def IgnoreRuleEffectHostList(self, IgnoreRuleEffectHostList):
        self._IgnoreRuleEffectHostList = IgnoreRuleEffectHostList

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("IgnoreRuleEffectHostList") is not None:
            self._IgnoreRuleEffectHostList = []
            for item in params.get("IgnoreRuleEffectHostList"):
                obj = IgnoreRuleEffectHostInfo()
                obj._deserialize(item)
                self._IgnoreRuleEffectHostList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeImportMachineInfoRequest(AbstractModel):
    """DescribeImportMachineInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _MachineList: 服务器内网IP（默认）/ 服务器名称 / 服务器ID 数组 (最大 1000条)
        :type MachineList: list of str
        :param _ImportType: 批量导入的数据类型：Ip、Name、Id 三选一
        :type ImportType: str
        :param _IsQueryProMachine: 该参数已作废.
        :type IsQueryProMachine: bool
        :param _Filters: 过滤条件：
<li>Version - String  是否必填：否 - 当前防护版本（ PRO_VERSION：专业版 | BASIC_VERSION：基础版 | Flagship：旗舰版 | ProtectedMachines：专业版+旗舰版） | BASIC_PROPOST_GENERAL_DISCOUNT：普惠版+专业版按量计费+基础版主机 | UnFlagship：专业版预付费+专业版后付费+基础版+普惠版</li>
        :type Filters: list of Filters
        """
        self._MachineList = None
        self._ImportType = None
        self._IsQueryProMachine = None
        self._Filters = None

    @property
    def MachineList(self):
        return self._MachineList

    @MachineList.setter
    def MachineList(self, MachineList):
        self._MachineList = MachineList

    @property
    def ImportType(self):
        return self._ImportType

    @ImportType.setter
    def ImportType(self, ImportType):
        self._ImportType = ImportType

    @property
    def IsQueryProMachine(self):
        return self._IsQueryProMachine

    @IsQueryProMachine.setter
    def IsQueryProMachine(self, IsQueryProMachine):
        self._IsQueryProMachine = IsQueryProMachine

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._MachineList = params.get("MachineList")
        self._ImportType = params.get("ImportType")
        self._IsQueryProMachine = params.get("IsQueryProMachine")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeImportMachineInfoResponse(AbstractModel):
    """DescribeImportMachineInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _EffectiveMachineInfoList: 有效的机器信息列表：机器名称、机器公网/内网ip、机器标签
注意：此字段可能返回 null，表示取不到有效值。
        :type EffectiveMachineInfoList: list of EffectiveMachineInfo
        :param _InvalidMachineList: 用户批量导入失败的机器列表（例如机器不存在等...）
注意：此字段可能返回 null，表示取不到有效值。
        :type InvalidMachineList: list of str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._EffectiveMachineInfoList = None
        self._InvalidMachineList = None
        self._RequestId = None

    @property
    def EffectiveMachineInfoList(self):
        return self._EffectiveMachineInfoList

    @EffectiveMachineInfoList.setter
    def EffectiveMachineInfoList(self, EffectiveMachineInfoList):
        self._EffectiveMachineInfoList = EffectiveMachineInfoList

    @property
    def InvalidMachineList(self):
        return self._InvalidMachineList

    @InvalidMachineList.setter
    def InvalidMachineList(self, InvalidMachineList):
        self._InvalidMachineList = InvalidMachineList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("EffectiveMachineInfoList") is not None:
            self._EffectiveMachineInfoList = []
            for item in params.get("EffectiveMachineInfoList"):
                obj = EffectiveMachineInfo()
                obj._deserialize(item)
                self._EffectiveMachineInfoList.append(obj)
        self._InvalidMachineList = params.get("InvalidMachineList")
        self._RequestId = params.get("RequestId")


class DescribeIndexListRequest(AbstractModel):
    """DescribeIndexList请求参数结构体

    """


class DescribeIndexListResponse(AbstractModel):
    """DescribeIndexList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: ES 索引信息
        :type Data: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DescribeJavaMemShellListRequest(AbstractModel):
    """DescribeJavaMemShellList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤条件：Keywords: ip或者主机名模糊查询, Type，Status精确匹配，CreateBeginTime，CreateEndTime时间段
        :type Filters: list of Filters
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeJavaMemShellListResponse(AbstractModel):
    """DescribeJavaMemShellList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 事件列表
注意：此字段可能返回 null，表示取不到有效值。
        :type List: list of JavaMemShellInfo
        :param _TotalCount: 总数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = JavaMemShellInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeLicenseBindListRequest(AbstractModel):
    """DescribeLicenseBindList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _LicenseId: 授权ID
        :type LicenseId: int
        :param _LicenseType: 授权类型
        :type LicenseType: int
        :param _ResourceId: 资源ID
        :type ResourceId: str
        :param _Filters: <li>Keywords 机器别名/公私IP 模糊查询</li>
        :type Filters: list of Filters
        :param _Limit: 限制条数,默认10.
        :type Limit: int
        :param _Offset: 偏移量,默认0.
        :type Offset: int
        """
        self._LicenseId = None
        self._LicenseType = None
        self._ResourceId = None
        self._Filters = None
        self._Limit = None
        self._Offset = None

    @property
    def LicenseId(self):
        return self._LicenseId

    @LicenseId.setter
    def LicenseId(self, LicenseId):
        self._LicenseId = LicenseId

    @property
    def LicenseType(self):
        return self._LicenseType

    @LicenseType.setter
    def LicenseType(self, LicenseType):
        self._LicenseType = LicenseType

    @property
    def ResourceId(self):
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._LicenseId = params.get("LicenseId")
        self._LicenseType = params.get("LicenseType")
        self._ResourceId = params.get("ResourceId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLicenseBindListResponse(AbstractModel):
    """DescribeLicenseBindList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总条数
        :type TotalCount: int
        :param _List: 绑定机器列表信息
        :type List: list of LicenseBindDetail
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._List = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = LicenseBindDetail()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLicenseBindScheduleRequest(AbstractModel):
    """DescribeLicenseBindSchedule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务ID
        :type TaskId: int
        :param _Limit: 限制条数,默认10.
        :type Limit: int
        :param _Offset: 偏移量,默认0
        :type Offset: int
        :param _Filters: 过滤参数
Status 绑定进度状态 0 进行中 1 已完成 2 失败
        :type Filters: list of Filter
        """
        self._TaskId = None
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLicenseBindScheduleResponse(AbstractModel):
    """DescribeLicenseBindSchedule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Schedule: 进度
        :type Schedule: int
        :param _List: 绑定任务详情
        :type List: list of LicenseBindTaskDetail
        :param _TotalCount: 总条数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Schedule = None
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def Schedule(self):
        return self._Schedule

    @Schedule.setter
    def Schedule(self, Schedule):
        self._Schedule = Schedule

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Schedule = params.get("Schedule")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = LicenseBindTaskDetail()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeLicenseGeneralRequest(AbstractModel):
    """DescribeLicenseGeneral请求参数结构体

    """


class DescribeLicenseGeneralResponse(AbstractModel):
    """DescribeLicenseGeneral返回参数结构体

    """

    def __init__(self):
        r"""
        :param _LicenseCnt: 总授权数 (包含隔离,过期等不可用状态)
        :type LicenseCnt: int
        :param _AvailableLicenseCnt: 可用授权数
        :type AvailableLicenseCnt: int
        :param _AvailableProVersionLicenseCnt: 可用专业版授权数(包含后付费).
        :type AvailableProVersionLicenseCnt: int
        :param _AvailableFlagshipVersionLicenseCnt: 可用旗舰版授权数
        :type AvailableFlagshipVersionLicenseCnt: int
        :param _NearExpiryLicenseCnt: 即将到期授权数 (15天内到期的)
        :type NearExpiryLicenseCnt: int
        :param _ExpireLicenseCnt: 已到期授权数(不包含已删除的记录)
        :type ExpireLicenseCnt: int
        :param _AutoOpenStatus: 自动升级开关状态,默认 false,  true 开启, false 关闭
        :type AutoOpenStatus: bool
        :param _ProtectType: PROVERSION_POSTPAY 专业版-后付费, PROVERSION_PREPAY 专业版-预付费, FLAGSHIP_PREPAY 旗舰版-预付费
        :type ProtectType: str
        :param _IsOpenStatusHistory: 历史是否开通过自动升级开关
        :type IsOpenStatusHistory: bool
        :param _UsedLicenseCnt: 已使用授权数
        :type UsedLicenseCnt: int
        :param _NotExpiredLicenseCnt: 未到期授权数
        :type NotExpiredLicenseCnt: int
        :param _FlagshipVersionLicenseCnt: 旗舰版总授权数(有效订单)
        :type FlagshipVersionLicenseCnt: int
        :param _ProVersionLicenseCnt: 专业版总授权数(有效订单)
        :type ProVersionLicenseCnt: int
        :param _CwpVersionLicenseCnt: 普惠版总授权数(有效订单的授权数)
        :type CwpVersionLicenseCnt: int
        :param _AvailableLHLicenseCnt: 可用惠普版授权数
        :type AvailableLHLicenseCnt: int
        :param _AutoRepurchaseSwitch: 自动加购开关, true 开启, false 关闭
        :type AutoRepurchaseSwitch: bool
        :param _AutoRepurchaseRenewSwitch: 自动加购订单是否自动续费 ,true 开启, false 关闭
        :type AutoRepurchaseRenewSwitch: bool
        :param _DestroyOrderNum: 已销毁订单数
        :type DestroyOrderNum: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._LicenseCnt = None
        self._AvailableLicenseCnt = None
        self._AvailableProVersionLicenseCnt = None
        self._AvailableFlagshipVersionLicenseCnt = None
        self._NearExpiryLicenseCnt = None
        self._ExpireLicenseCnt = None
        self._AutoOpenStatus = None
        self._ProtectType = None
        self._IsOpenStatusHistory = None
        self._UsedLicenseCnt = None
        self._NotExpiredLicenseCnt = None
        self._FlagshipVersionLicenseCnt = None
        self._ProVersionLicenseCnt = None
        self._CwpVersionLicenseCnt = None
        self._AvailableLHLicenseCnt = None
        self._AutoRepurchaseSwitch = None
        self._AutoRepurchaseRenewSwitch = None
        self._DestroyOrderNum = None
        self._RequestId = None

    @property
    def LicenseCnt(self):
        return self._LicenseCnt

    @LicenseCnt.setter
    def LicenseCnt(self, LicenseCnt):
        self._LicenseCnt = LicenseCnt

    @property
    def AvailableLicenseCnt(self):
        return self._AvailableLicenseCnt

    @AvailableLicenseCnt.setter
    def AvailableLicenseCnt(self, AvailableLicenseCnt):
        self._AvailableLicenseCnt = AvailableLicenseCnt

    @property
    def AvailableProVersionLicenseCnt(self):
        return self._AvailableProVersionLicenseCnt

    @AvailableProVersionLicenseCnt.setter
    def AvailableProVersionLicenseCnt(self, AvailableProVersionLicenseCnt):
        self._AvailableProVersionLicenseCnt = AvailableProVersionLicenseCnt

    @property
    def AvailableFlagshipVersionLicenseCnt(self):
        return self._AvailableFlagshipVersionLicenseCnt

    @AvailableFlagshipVersionLicenseCnt.setter
    def AvailableFlagshipVersionLicenseCnt(self, AvailableFlagshipVersionLicenseCnt):
        self._AvailableFlagshipVersionLicenseCnt = AvailableFlagshipVersionLicenseCnt

    @property
    def NearExpiryLicenseCnt(self):
        return self._NearExpiryLicenseCnt

    @NearExpiryLicenseCnt.setter
    def NearExpiryLicenseCnt(self, NearExpiryLicenseCnt):
        self._NearExpiryLicenseCnt = NearExpiryLicenseCnt

    @property
    def ExpireLicenseCnt(self):
        return self._ExpireLicenseCnt

    @ExpireLicenseCnt.setter
    def ExpireLicenseCnt(self, ExpireLicenseCnt):
        self._ExpireLicenseCnt = ExpireLicenseCnt

    @property
    def AutoOpenStatus(self):
        return self._AutoOpenStatus

    @AutoOpenStatus.setter
    def AutoOpenStatus(self, AutoOpenStatus):
        self._AutoOpenStatus = AutoOpenStatus

    @property
    def ProtectType(self):
        return self._ProtectType

    @ProtectType.setter
    def ProtectType(self, ProtectType):
        self._ProtectType = ProtectType

    @property
    def IsOpenStatusHistory(self):
        return self._IsOpenStatusHistory

    @IsOpenStatusHistory.setter
    def IsOpenStatusHistory(self, IsOpenStatusHistory):
        self._IsOpenStatusHistory = IsOpenStatusHistory

    @property
    def UsedLicenseCnt(self):
        return self._UsedLicenseCnt

    @UsedLicenseCnt.setter
    def UsedLicenseCnt(self, UsedLicenseCnt):
        self._UsedLicenseCnt = UsedLicenseCnt

    @property
    def NotExpiredLicenseCnt(self):
        return self._NotExpiredLicenseCnt

    @NotExpiredLicenseCnt.setter
    def NotExpiredLicenseCnt(self, NotExpiredLicenseCnt):
        self._NotExpiredLicenseCnt = NotExpiredLicenseCnt

    @property
    def FlagshipVersionLicenseCnt(self):
        return self._FlagshipVersionLicenseCnt

    @FlagshipVersionLicenseCnt.setter
    def FlagshipVersionLicenseCnt(self, FlagshipVersionLicenseCnt):
        self._FlagshipVersionLicenseCnt = FlagshipVersionLicenseCnt

    @property
    def ProVersionLicenseCnt(self):
        return self._ProVersionLicenseCnt

    @ProVersionLicenseCnt.setter
    def ProVersionLicenseCnt(self, ProVersionLicenseCnt):
        self._ProVersionLicenseCnt = ProVersionLicenseCnt

    @property
    def CwpVersionLicenseCnt(self):
        return self._CwpVersionLicenseCnt

    @CwpVersionLicenseCnt.setter
    def CwpVersionLicenseCnt(self, CwpVersionLicenseCnt):
        self._CwpVersionLicenseCnt = CwpVersionLicenseCnt

    @property
    def AvailableLHLicenseCnt(self):
        return self._AvailableLHLicenseCnt

    @AvailableLHLicenseCnt.setter
    def AvailableLHLicenseCnt(self, AvailableLHLicenseCnt):
        self._AvailableLHLicenseCnt = AvailableLHLicenseCnt

    @property
    def AutoRepurchaseSwitch(self):
        return self._AutoRepurchaseSwitch

    @AutoRepurchaseSwitch.setter
    def AutoRepurchaseSwitch(self, AutoRepurchaseSwitch):
        self._AutoRepurchaseSwitch = AutoRepurchaseSwitch

    @property
    def AutoRepurchaseRenewSwitch(self):
        return self._AutoRepurchaseRenewSwitch

    @AutoRepurchaseRenewSwitch.setter
    def AutoRepurchaseRenewSwitch(self, AutoRepurchaseRenewSwitch):
        self._AutoRepurchaseRenewSwitch = AutoRepurchaseRenewSwitch

    @property
    def DestroyOrderNum(self):
        return self._DestroyOrderNum

    @DestroyOrderNum.setter
    def DestroyOrderNum(self, DestroyOrderNum):
        self._DestroyOrderNum = DestroyOrderNum

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._LicenseCnt = params.get("LicenseCnt")
        self._AvailableLicenseCnt = params.get("AvailableLicenseCnt")
        self._AvailableProVersionLicenseCnt = params.get("AvailableProVersionLicenseCnt")
        self._AvailableFlagshipVersionLicenseCnt = params.get("AvailableFlagshipVersionLicenseCnt")
        self._NearExpiryLicenseCnt = params.get("NearExpiryLicenseCnt")
        self._ExpireLicenseCnt = params.get("ExpireLicenseCnt")
        self._AutoOpenStatus = params.get("AutoOpenStatus")
        self._ProtectType = params.get("ProtectType")
        self._IsOpenStatusHistory = params.get("IsOpenStatusHistory")
        self._UsedLicenseCnt = params.get("UsedLicenseCnt")
        self._NotExpiredLicenseCnt = params.get("NotExpiredLicenseCnt")
        self._FlagshipVersionLicenseCnt = params.get("FlagshipVersionLicenseCnt")
        self._ProVersionLicenseCnt = params.get("ProVersionLicenseCnt")
        self._CwpVersionLicenseCnt = params.get("CwpVersionLicenseCnt")
        self._AvailableLHLicenseCnt = params.get("AvailableLHLicenseCnt")
        self._AutoRepurchaseSwitch = params.get("AutoRepurchaseSwitch")
        self._AutoRepurchaseRenewSwitch = params.get("AutoRepurchaseRenewSwitch")
        self._DestroyOrderNum = params.get("DestroyOrderNum")
        self._RequestId = params.get("RequestId")


class DescribeLicenseListRequest(AbstractModel):
    """DescribeLicenseList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 多个条件筛选时 LicenseStatus,DeadlineStatus,ResourceId,Keywords 取交集
<li> LicenseStatus 授权状态信息,0 未使用,1 部分使用, 2 已用完, 3 不可用  4 可使用</li>
<li> BuyTime 购买时间</li>
<li> LicenseType  授权类型, 0 专业版-按量计费, 1专业版-包年包月 , 2 旗舰版-包年包月</li>
<li>DeadlineStatus 到期状态 NotExpired 未过期, Expire 已过期(包含已销毁) NearExpiry 即将到期</li>
<li>ResourceId 资源ID</li>
<li>Keywords IP筛选</li>
<li>PayMode 付费模式 0 按量计费 , 1 包年包月</li>
<li>OrderStatus 订单状态 1 正常 2 隔离 3 销毁</li>
        :type Filters: list of Filters
        :param _Limit: 限制条数,默认10.
        :type Limit: int
        :param _Offset: 偏移量,默认0.
        :type Offset: int
        :param _Tags: 标签筛选,平台标签能力,这里传入 标签键,标签值作为一个对象
        :type Tags: list of Tags
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Tags = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tags()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLicenseListResponse(AbstractModel):
    """DescribeLicenseList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总条数
        :type TotalCount: int
        :param _List: 授权数列表信息
        :type List: list of LicenseDetail
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._List = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = LicenseDetail()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLogStorageConfigRequest(AbstractModel):
    """DescribeLogStorageConfig请求参数结构体

    """


class DescribeLogStorageConfigResponse(AbstractModel):
    """DescribeLogStorageConfig返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Type: 存储类型，string数组
注意：此字段可能返回 null，表示取不到有效值。
        :type Type: list of str
        :param _Period: 日志存储天数，3640表示不限
注意：此字段可能返回 null，表示取不到有效值。
        :type Period: int
        :param _PeriodModifyCount: 本月Period的修改次数
注意：此字段可能返回 null，表示取不到有效值。
        :type PeriodModifyCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Type = None
        self._Period = None
        self._PeriodModifyCount = None
        self._RequestId = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Period(self):
        return self._Period

    @Period.setter
    def Period(self, Period):
        self._Period = Period

    @property
    def PeriodModifyCount(self):
        return self._PeriodModifyCount

    @PeriodModifyCount.setter
    def PeriodModifyCount(self, PeriodModifyCount):
        self._PeriodModifyCount = PeriodModifyCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Period = params.get("Period")
        self._PeriodModifyCount = params.get("PeriodModifyCount")
        self._RequestId = params.get("RequestId")


class DescribeLogStorageRecordRequest(AbstractModel):
    """DescribeLogStorageRecord请求参数结构体

    """


class DescribeLogStorageRecordResponse(AbstractModel):
    """DescribeLogStorageRecord返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Records: 存储量记录
注意：此字段可能返回 null，表示取不到有效值。
        :type Records: list of LogStorageRecord
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Records = None
        self._RequestId = None

    @property
    def Records(self):
        return self._Records

    @Records.setter
    def Records(self, Records):
        self._Records = Records

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Records") is not None:
            self._Records = []
            for item in params.get("Records"):
                obj = LogStorageRecord()
                obj._deserialize(item)
                self._Records.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLogStorageStatisticRequest(AbstractModel):
    """DescribeLogStorageStatistic请求参数结构体

    """


class DescribeLogStorageStatisticResponse(AbstractModel):
    """DescribeLogStorageStatistic返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalSize: 总容量（单位：GB）
        :type TotalSize: int
        :param _UsedSize: 已使用容量（单位：GB）
        :type UsedSize: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalSize = None
        self._UsedSize = None
        self._RequestId = None

    @property
    def TotalSize(self):
        return self._TotalSize

    @TotalSize.setter
    def TotalSize(self, TotalSize):
        self._TotalSize = TotalSize

    @property
    def UsedSize(self):
        return self._UsedSize

    @UsedSize.setter
    def UsedSize(self, UsedSize):
        self._UsedSize = UsedSize

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalSize = params.get("TotalSize")
        self._UsedSize = params.get("UsedSize")
        self._RequestId = params.get("RequestId")


class DescribeLoginWhiteCombinedListRequest(AbstractModel):
    """DescribeLoginWhiteCombinedList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>IpOrAlias - String - 是否必填：否 - 主机ip或别名筛选</li>
<li>UserName - String - 是否必填：否 - 用户名筛选</li>
<li>ModifyBeginTime - String - 是否必填：否 - 按照修改时间段筛选，开始时间</li>
<li>ModifyEndTime - String - 是否必填：否 - 按照修改时间段筛选，结束时间</li>
        :type Filters: list of Filter
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLoginWhiteCombinedListResponse(AbstractModel):
    """DescribeLoginWhiteCombinedList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总数量
        :type TotalCount: int
        :param _LoginWhiteCombinedInfos: 合并后的白名单列表
注意：此字段可能返回 null，表示取不到有效值。
        :type LoginWhiteCombinedInfos: list of LoginWhiteCombinedInfo
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._LoginWhiteCombinedInfos = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def LoginWhiteCombinedInfos(self):
        return self._LoginWhiteCombinedInfos

    @LoginWhiteCombinedInfos.setter
    def LoginWhiteCombinedInfos(self, LoginWhiteCombinedInfos):
        self._LoginWhiteCombinedInfos = LoginWhiteCombinedInfos

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("LoginWhiteCombinedInfos") is not None:
            self._LoginWhiteCombinedInfos = []
            for item in params.get("LoginWhiteCombinedInfos"):
                obj = LoginWhiteCombinedInfo()
                obj._deserialize(item)
                self._LoginWhiteCombinedInfos.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLoginWhiteListRequest(AbstractModel):
    """DescribeLoginWhiteList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 返回数量，最大值为100。
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>IpOrAlias - String - 是否必填：否 - 查询关键字 </li>
<li>UserName - String - 是否必填：否 - 用户名筛选 </li>
<li>ModifyBeginTime - String - 是否必填：否 - 按照修改时间段筛选，开始时间 </li>
<li>ModifyEndTime - String - 是否必填：否 - 按照修改时间段筛选，结束时间 </li>
        :type Filters: list of Filter
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLoginWhiteListResponse(AbstractModel):
    """DescribeLoginWhiteList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 记录总数
        :type TotalCount: int
        :param _LoginWhiteLists: 异地登录白名单数组
        :type LoginWhiteLists: list of LoginWhiteLists
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._LoginWhiteLists = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def LoginWhiteLists(self):
        return self._LoginWhiteLists

    @LoginWhiteLists.setter
    def LoginWhiteLists(self, LoginWhiteLists):
        self._LoginWhiteLists = LoginWhiteLists

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("LoginWhiteLists") is not None:
            self._LoginWhiteLists = []
            for item in params.get("LoginWhiteLists"):
                obj = LoginWhiteLists()
                obj._deserialize(item)
                self._LoginWhiteLists.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeMachineInfoRequest(AbstractModel):
    """DescribeMachineInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Uuid: 主机安全客户端唯一Uuid。
        :type Uuid: str
        :param _Quuid: Quuid , Uuid 必填一项
        :type Quuid: str
        """
        self._Uuid = None
        self._Quuid = None

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid


    def _deserialize(self, params):
        self._Uuid = params.get("Uuid")
        self._Quuid = params.get("Quuid")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMachineInfoResponse(AbstractModel):
    """DescribeMachineInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _MachineIp: 机器ip。
        :type MachineIp: str
        :param _ProtectDays: 受主机安全保护天数。
        :type ProtectDays: int
        :param _MachineOs: 操作系统。
        :type MachineOs: str
        :param _MachineName: 主机名称。
        :type MachineName: str
        :param _MachineStatus: 在线状态。
<li>ONLINE： 在线</li>
<li>OFFLINE：离线</li>
        :type MachineStatus: str
        :param _InstanceId: CVM或BM主机唯一标识。
        :type InstanceId: str
        :param _MachineWanIp: 主机外网IP。
        :type MachineWanIp: str
        :param _Quuid: CVM或BM主机唯一Uuid。
        :type Quuid: str
        :param _Uuid: 主机安全客户端唯一Uuid。
        :type Uuid: str
        :param _IsProVersion: 是否开通专业版。
<li>true：是</li>
<li>false：否</li>
        :type IsProVersion: bool
        :param _ProVersionOpenDate: 专业版开通时间。
        :type ProVersionOpenDate: str
        :param _MachineType: 云服务器类型。
<li>CVM: 腾讯云服务器</li>
<li>BM: 黑石物理机</li>
<li>ECM: 边缘计算服务器</li>
<li>LH: 轻量应用服务器</li>
<li>Other: 混合云机器</li>
        :type MachineType: str
        :param _MachineRegion: 机器所属地域。如：ap-guangzhou，ap-shanghai
        :type MachineRegion: str
        :param _PayMode: 主机状态。
<li>POSTPAY: 表示后付费，即按量计费  </li>
<li>PREPAY: 表示预付费，即包年包月</li>
        :type PayMode: str
        :param _FreeMalwaresLeft: 免费木马剩余检测数量。
        :type FreeMalwaresLeft: int
        :param _FreeVulsLeft: 免费漏洞剩余检测数量。
        :type FreeVulsLeft: int
        :param _AgentVersion: agent版本号
        :type AgentVersion: str
        :param _ProVersionDeadline: 专业版到期时间(仅预付费)
        :type ProVersionDeadline: str
        :param _HasAssetScan: 是否有资产扫描记录，0无，1有
        :type HasAssetScan: int
        :param _ProtectType: 防护版本：BASIC_VERSION 基础版，PRO_VERSION 专业版，Flagship 旗舰版，GENERAL_DISCOUNT 普惠版
        :type ProtectType: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._MachineIp = None
        self._ProtectDays = None
        self._MachineOs = None
        self._MachineName = None
        self._MachineStatus = None
        self._InstanceId = None
        self._MachineWanIp = None
        self._Quuid = None
        self._Uuid = None
        self._IsProVersion = None
        self._ProVersionOpenDate = None
        self._MachineType = None
        self._MachineRegion = None
        self._PayMode = None
        self._FreeMalwaresLeft = None
        self._FreeVulsLeft = None
        self._AgentVersion = None
        self._ProVersionDeadline = None
        self._HasAssetScan = None
        self._ProtectType = None
        self._RequestId = None

    @property
    def MachineIp(self):
        return self._MachineIp

    @MachineIp.setter
    def MachineIp(self, MachineIp):
        self._MachineIp = MachineIp

    @property
    def ProtectDays(self):
        return self._ProtectDays

    @ProtectDays.setter
    def ProtectDays(self, ProtectDays):
        self._ProtectDays = ProtectDays

    @property
    def MachineOs(self):
        return self._MachineOs

    @MachineOs.setter
    def MachineOs(self, MachineOs):
        self._MachineOs = MachineOs

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def MachineStatus(self):
        return self._MachineStatus

    @MachineStatus.setter
    def MachineStatus(self, MachineStatus):
        self._MachineStatus = MachineStatus

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def MachineWanIp(self):
        return self._MachineWanIp

    @MachineWanIp.setter
    def MachineWanIp(self, MachineWanIp):
        self._MachineWanIp = MachineWanIp

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def IsProVersion(self):
        return self._IsProVersion

    @IsProVersion.setter
    def IsProVersion(self, IsProVersion):
        self._IsProVersion = IsProVersion

    @property
    def ProVersionOpenDate(self):
        return self._ProVersionOpenDate

    @ProVersionOpenDate.setter
    def ProVersionOpenDate(self, ProVersionOpenDate):
        self._ProVersionOpenDate = ProVersionOpenDate

    @property
    def MachineType(self):
        return self._MachineType

    @MachineType.setter
    def MachineType(self, MachineType):
        self._MachineType = MachineType

    @property
    def MachineRegion(self):
        return self._MachineRegion

    @MachineRegion.setter
    def MachineRegion(self, MachineRegion):
        self._MachineRegion = MachineRegion

    @property
    def PayMode(self):
        return self._PayMode

    @PayMode.setter
    def PayMode(self, PayMode):
        self._PayMode = PayMode

    @property
    def FreeMalwaresLeft(self):
        return self._FreeMalwaresLeft

    @FreeMalwaresLeft.setter
    def FreeMalwaresLeft(self, FreeMalwaresLeft):
        self._FreeMalwaresLeft = FreeMalwaresLeft

    @property
    def FreeVulsLeft(self):
        return self._FreeVulsLeft

    @FreeVulsLeft.setter
    def FreeVulsLeft(self, FreeVulsLeft):
        self._FreeVulsLeft = FreeVulsLeft

    @property
    def AgentVersion(self):
        return self._AgentVersion

    @AgentVersion.setter
    def AgentVersion(self, AgentVersion):
        self._AgentVersion = AgentVersion

    @property
    def ProVersionDeadline(self):
        return self._ProVersionDeadline

    @ProVersionDeadline.setter
    def ProVersionDeadline(self, ProVersionDeadline):
        self._ProVersionDeadline = ProVersionDeadline

    @property
    def HasAssetScan(self):
        return self._HasAssetScan

    @HasAssetScan.setter
    def HasAssetScan(self, HasAssetScan):
        self._HasAssetScan = HasAssetScan

    @property
    def ProtectType(self):
        return self._ProtectType

    @ProtectType.setter
    def ProtectType(self, ProtectType):
        self._ProtectType = ProtectType

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._MachineIp = params.get("MachineIp")
        self._ProtectDays = params.get("ProtectDays")
        self._MachineOs = params.get("MachineOs")
        self._MachineName = params.get("MachineName")
        self._MachineStatus = params.get("MachineStatus")
        self._InstanceId = params.get("InstanceId")
        self._MachineWanIp = params.get("MachineWanIp")
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._IsProVersion = params.get("IsProVersion")
        self._ProVersionOpenDate = params.get("ProVersionOpenDate")
        self._MachineType = params.get("MachineType")
        self._MachineRegion = params.get("MachineRegion")
        self._PayMode = params.get("PayMode")
        self._FreeMalwaresLeft = params.get("FreeMalwaresLeft")
        self._FreeVulsLeft = params.get("FreeVulsLeft")
        self._AgentVersion = params.get("AgentVersion")
        self._ProVersionDeadline = params.get("ProVersionDeadline")
        self._HasAssetScan = params.get("HasAssetScan")
        self._ProtectType = params.get("ProtectType")
        self._RequestId = params.get("RequestId")


class DescribeMachineListRequest(AbstractModel):
    """DescribeMachineList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _MachineType: 云主机类型。
<li>CVM：表示虚拟主机</li>
<li>BM:  表示黑石物理机</li>
<li>ECM:  表示边缘计算服务器</li>
<li>LH:  表示轻量应用服务器</li>
<li>Other:  表示混合云机器</li>
        :type MachineType: str
        :param _MachineRegion: 机器所属地域。如：ap-guangzhou，ap-shanghai
        :type MachineRegion: str
        :param _Limit: 返回数量，默认为10，最大值为100。
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>Keywords - String - 是否必填：否 - 查询关键字 </li>
<li>Status - String - 是否必填：否 - 客户端在线状态（OFFLINE: 离线 | ONLINE: 在线 | UNINSTALLED：未安装）</li>
<li>Version - String  是否必填：否 - 当前防护版本（ PRO_VERSION：专业版 | BASIC_VERSION：基础版）</li>
每个过滤条件只支持一个值，暂不支持多个值“或”关系查询
        :type Filters: list of AssetFilters
        """
        self._MachineType = None
        self._MachineRegion = None
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def MachineType(self):
        return self._MachineType

    @MachineType.setter
    def MachineType(self, MachineType):
        self._MachineType = MachineType

    @property
    def MachineRegion(self):
        return self._MachineRegion

    @MachineRegion.setter
    def MachineRegion(self, MachineRegion):
        self._MachineRegion = MachineRegion

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._MachineType = params.get("MachineType")
        self._MachineRegion = params.get("MachineRegion")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMachineListResponse(AbstractModel):
    """DescribeMachineList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Machines: 主机列表
        :type Machines: list of Machine
        :param _TotalCount: 主机数量
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Machines = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def Machines(self):
        return self._Machines

    @Machines.setter
    def Machines(self, Machines):
        self._Machines = Machines

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Machines") is not None:
            self._Machines = []
            for item in params.get("Machines"):
                obj = Machine()
                obj._deserialize(item)
                self._Machines.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeMachineOsListRequest(AbstractModel):
    """DescribeMachineOsList请求参数结构体

    """


class DescribeMachineOsListResponse(AbstractModel):
    """DescribeMachineOsList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 操作系统列表
        :type List: list of OsName
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = OsName()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeMachineRegionsRequest(AbstractModel):
    """DescribeMachineRegions请求参数结构体

    """


class DescribeMachineRegionsResponse(AbstractModel):
    """DescribeMachineRegions返回参数结构体

    """

    def __init__(self):
        r"""
        :param _CVM: CVM 云服务器地域列表
        :type CVM: list of RegionInfo
        :param _BM: BM 黑石机器地域列表
        :type BM: list of RegionInfo
        :param _LH: LH 轻量应用服务器地域列表
        :type LH: list of RegionInfo
        :param _ECM: ECM 边缘计算服务器地域列表
        :type ECM: list of RegionInfo
        :param _Other: Other 混合云地域列表
        :type Other: list of RegionInfo
        :param _ALL: 所有地域列表(包含以上所有地域)
        :type ALL: list of RegionInfo
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._CVM = None
        self._BM = None
        self._LH = None
        self._ECM = None
        self._Other = None
        self._ALL = None
        self._RequestId = None

    @property
    def CVM(self):
        return self._CVM

    @CVM.setter
    def CVM(self, CVM):
        self._CVM = CVM

    @property
    def BM(self):
        return self._BM

    @BM.setter
    def BM(self, BM):
        self._BM = BM

    @property
    def LH(self):
        return self._LH

    @LH.setter
    def LH(self, LH):
        self._LH = LH

    @property
    def ECM(self):
        return self._ECM

    @ECM.setter
    def ECM(self, ECM):
        self._ECM = ECM

    @property
    def Other(self):
        return self._Other

    @Other.setter
    def Other(self, Other):
        self._Other = Other

    @property
    def ALL(self):
        return self._ALL

    @ALL.setter
    def ALL(self, ALL):
        self._ALL = ALL

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("CVM") is not None:
            self._CVM = []
            for item in params.get("CVM"):
                obj = RegionInfo()
                obj._deserialize(item)
                self._CVM.append(obj)
        if params.get("BM") is not None:
            self._BM = []
            for item in params.get("BM"):
                obj = RegionInfo()
                obj._deserialize(item)
                self._BM.append(obj)
        if params.get("LH") is not None:
            self._LH = []
            for item in params.get("LH"):
                obj = RegionInfo()
                obj._deserialize(item)
                self._LH.append(obj)
        if params.get("ECM") is not None:
            self._ECM = []
            for item in params.get("ECM"):
                obj = RegionInfo()
                obj._deserialize(item)
                self._ECM.append(obj)
        if params.get("Other") is not None:
            self._Other = []
            for item in params.get("Other"):
                obj = RegionInfo()
                obj._deserialize(item)
                self._Other.append(obj)
        if params.get("ALL") is not None:
            self._ALL = []
            for item in params.get("ALL"):
                obj = RegionInfo()
                obj._deserialize(item)
                self._ALL.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeMachinesRequest(AbstractModel):
    """DescribeMachines请求参数结构体

    """

    def __init__(self):
        r"""
        :param _MachineType: 机器所属专区类型 
CVM 云服务器
BM 黑石
ECM 边缘计算
LH 轻量应用服务器
Other 混合云专区
        :type MachineType: str
        :param _MachineRegion: 机器所属地域。如：ap-guangzhou，ap-shanghai
        :type MachineRegion: str
        :param _Limit: 返回数量，默认为10，最大值为100。
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>Ips - String - 是否必填：否 - 通过ip查询 </li>
<li>Names - String - 是否必填：否 - 通过实例名查询 </li>
<li>InstanceIds - String - 是否必填：否 - 通过实例id查询 </li>
<li>Status - String - 是否必填：否 - 客户端在线状态（OFFLINE: 离线/关机 | ONLINE: 在线 | UNINSTALLED：未安装 | AGENT_OFFLINE 离线| AGENT_SHUTDOWN 已关机）</li>
<li>Version - String  是否必填：否 - 当前防护版本（ PRO_VERSION：专业版 | BASIC_VERSION：基础版 | Flagship : 旗舰版 | ProtectedMachines: 专业版+旗舰版）</li>
<li>Risk - String 是否必填: 否 - 风险主机( yes ) </li>
<li>Os -String 是否必填: 否 - 操作系统( DescribeMachineOsList 接口 值 )
每个过滤条件只支持一个值，暂不支持多个值“或”关系查询
<li>Quuid - String - 是否必填: 否 - 云服务器uuid  最大100条.</li>
<li>AddedOnTheFifteen- String 是否必填: 否 - 是否只查询15天内新增的主机( 1：是) </li>
        :type Filters: list of Filter
        :param _ProjectIds: 机器所属业务ID列表
        :type ProjectIds: list of int non-negative
        """
        self._MachineType = None
        self._MachineRegion = None
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._ProjectIds = None

    @property
    def MachineType(self):
        return self._MachineType

    @MachineType.setter
    def MachineType(self, MachineType):
        self._MachineType = MachineType

    @property
    def MachineRegion(self):
        return self._MachineRegion

    @MachineRegion.setter
    def MachineRegion(self, MachineRegion):
        self._MachineRegion = MachineRegion

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def ProjectIds(self):
        return self._ProjectIds

    @ProjectIds.setter
    def ProjectIds(self, ProjectIds):
        self._ProjectIds = ProjectIds


    def _deserialize(self, params):
        self._MachineType = params.get("MachineType")
        self._MachineRegion = params.get("MachineRegion")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._ProjectIds = params.get("ProjectIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMachinesResponse(AbstractModel):
    """DescribeMachines返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Machines: 主机列表
        :type Machines: list of Machine
        :param _TotalCount: 主机数量
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Machines = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def Machines(self):
        return self._Machines

    @Machines.setter
    def Machines(self, Machines):
        self._Machines = Machines

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Machines") is not None:
            self._Machines = []
            for item in params.get("Machines"):
                obj = Machine()
                obj._deserialize(item)
                self._Machines.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeMalWareListRequest(AbstractModel):
    """DescribeMalWareList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>IpOrAlias - String - 是否必填：否 - 主机ip或别名筛选</li>
<li>FilePath - String - 是否必填：否 - 路径筛选</li>
<li>VirusName - String - 是否必填：否 - 描述筛选</li>
<li>CreateBeginTime - String - 是否必填：否 - 创建时间筛选-开始时间</li>
<li>CreateEndTime - String - 是否必填：否 - 创建时间筛选-结束时间</li>
<li>Status - String - 是否必填：否 - 状态筛选 4待处理,5信任,6已隔离,10隔离中,11恢复隔离中</li>
        :type Filters: list of Filter
        :param _By: 检测排序 CreateTime
        :type By: str
        :param _Order: 排序方式 ASC,DESC
        :type Order: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._By = None
        self._Order = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMalWareListResponse(AbstractModel):
    """DescribeMalWareList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _MalWareList: 木马列表
注意：此字段可能返回 null，表示取不到有效值。
        :type MalWareList: list of MalWareList
        :param _TotalCount: 总数量
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._MalWareList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def MalWareList(self):
        return self._MalWareList

    @MalWareList.setter
    def MalWareList(self, MalWareList):
        self._MalWareList = MalWareList

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("MalWareList") is not None:
            self._MalWareList = []
            for item in params.get("MalWareList"):
                obj = MalWareList()
                obj._deserialize(item)
                self._MalWareList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeMaliciousRequestWhiteListRequest(AbstractModel):
    """DescribeMaliciousRequestWhiteList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 返回数量，默认为10，最大值为100。
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。

<li>Domain  - String - 基线名称</li>
        :type Filters: list of Filters
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMaliciousRequestWhiteListResponse(AbstractModel):
    """DescribeMaliciousRequestWhiteList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 白名单信息列表
注意：此字段可能返回 null，表示取不到有效值。
        :type List: list of MaliciousRequestWhiteListInfo
        :param _TotalCount: 分页查询记录总数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = MaliciousRequestWhiteListInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeMalwareFileRequest(AbstractModel):
    """DescribeMalwareFile请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 木马记录ID
        :type Id: int
        """
        self._Id = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMalwareFileResponse(AbstractModel):
    """DescribeMalwareFile返回参数结构体

    """

    def __init__(self):
        r"""
        :param _FileUrl: 木马文件下载地址
        :type FileUrl: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._FileUrl = None
        self._RequestId = None

    @property
    def FileUrl(self):
        return self._FileUrl

    @FileUrl.setter
    def FileUrl(self, FileUrl):
        self._FileUrl = FileUrl

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FileUrl = params.get("FileUrl")
        self._RequestId = params.get("RequestId")


class DescribeMalwareInfoRequest(AbstractModel):
    """DescribeMalwareInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 唯一ID
        :type Id: int
        """
        self._Id = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMalwareInfoResponse(AbstractModel):
    """DescribeMalwareInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _MalwareInfo: 恶意文件详情信息
        :type MalwareInfo: :class:`tencentcloud.cwp.v20180228.models.MalwareInfo`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._MalwareInfo = None
        self._RequestId = None

    @property
    def MalwareInfo(self):
        return self._MalwareInfo

    @MalwareInfo.setter
    def MalwareInfo(self, MalwareInfo):
        self._MalwareInfo = MalwareInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("MalwareInfo") is not None:
            self._MalwareInfo = MalwareInfo()
            self._MalwareInfo._deserialize(params.get("MalwareInfo"))
        self._RequestId = params.get("RequestId")


class DescribeMalwareRiskWarningRequest(AbstractModel):
    """DescribeMalwareRiskWarning请求参数结构体

    """


class DescribeMalwareRiskWarningResponse(AbstractModel):
    """DescribeMalwareRiskWarning返回参数结构体

    """

    def __init__(self):
        r"""
        :param _IsCheckRisk: 是否开启自动扫描：true-开启，false-未开启
        :type IsCheckRisk: bool
        :param _List: 风险文件列表信息
注意：此字段可能返回 null，表示取不到有效值。
        :type List: list of MalwareRisk
        :param _IsPop: 是否弹出提示 true 弹出, false不弹
        :type IsPop: bool
        :param _ProcessList: 异常进程列表信息
注意：此字段可能返回 null，表示取不到有效值。
        :type ProcessList: list of MalwareRisk
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._IsCheckRisk = None
        self._List = None
        self._IsPop = None
        self._ProcessList = None
        self._RequestId = None

    @property
    def IsCheckRisk(self):
        return self._IsCheckRisk

    @IsCheckRisk.setter
    def IsCheckRisk(self, IsCheckRisk):
        self._IsCheckRisk = IsCheckRisk

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def IsPop(self):
        return self._IsPop

    @IsPop.setter
    def IsPop(self, IsPop):
        self._IsPop = IsPop

    @property
    def ProcessList(self):
        return self._ProcessList

    @ProcessList.setter
    def ProcessList(self, ProcessList):
        self._ProcessList = ProcessList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._IsCheckRisk = params.get("IsCheckRisk")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = MalwareRisk()
                obj._deserialize(item)
                self._List.append(obj)
        self._IsPop = params.get("IsPop")
        if params.get("ProcessList") is not None:
            self._ProcessList = []
            for item in params.get("ProcessList"):
                obj = MalwareRisk()
                obj._deserialize(item)
                self._ProcessList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeMalwareTimingScanSettingRequest(AbstractModel):
    """DescribeMalwareTimingScanSetting请求参数结构体

    """


class DescribeMalwareTimingScanSettingResponse(AbstractModel):
    """DescribeMalwareTimingScanSetting返回参数结构体

    """

    def __init__(self):
        r"""
        :param _CheckPattern: 检测模式 0 全盘检测  1快速检测
        :type CheckPattern: int
        :param _StartTime: 检测周期 开始时间
        :type StartTime: str
        :param _EndTime: 检测周期 超时结束时间
        :type EndTime: str
        :param _IsGlobal: 是否全部服务器 1 全部 2 自选
        :type IsGlobal: int
        :param _QuuidList: 自选服务器时必须 主机quuid的string数组
注意：此字段可能返回 null，表示取不到有效值。
        :type QuuidList: list of str
        :param _MonitoringPattern: 监控模式 0 标准 1深度
        :type MonitoringPattern: int
        :param _Cycle: 周期 1每天
        :type Cycle: int
        :param _EnableScan: 定时检测开关 0 关闭1 开启
        :type EnableScan: int
        :param _Id: 唯一ID
        :type Id: int
        :param _RealTimeMonitoring: 实时监控0 关闭 1开启
        :type RealTimeMonitoring: int
        :param _AutoIsolation: 是否自动隔离：1-是，0-否
        :type AutoIsolation: int
        :param _ClickTimeout: 一键扫描超时时长，如：1800秒（s）
        :type ClickTimeout: int
        :param _KillProcess: 是否杀掉进程 1杀掉 0不杀掉 只有开启自动隔离才生效
        :type KillProcess: int
        :param _EngineType: 1标准模式（只报严重、高危）、2增强模式（报严重、高危、中危）、3严格模式（报严重、高、中、低、提示）
        :type EngineType: int
        :param _EnableInspiredEngine: 启发引擎 0 关闭 1开启
        :type EnableInspiredEngine: int
        :param _EnableMemShellScan: 是否开启恶意进程查杀[0:未开启,1:开启]
        :type EnableMemShellScan: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._CheckPattern = None
        self._StartTime = None
        self._EndTime = None
        self._IsGlobal = None
        self._QuuidList = None
        self._MonitoringPattern = None
        self._Cycle = None
        self._EnableScan = None
        self._Id = None
        self._RealTimeMonitoring = None
        self._AutoIsolation = None
        self._ClickTimeout = None
        self._KillProcess = None
        self._EngineType = None
        self._EnableInspiredEngine = None
        self._EnableMemShellScan = None
        self._RequestId = None

    @property
    def CheckPattern(self):
        return self._CheckPattern

    @CheckPattern.setter
    def CheckPattern(self, CheckPattern):
        self._CheckPattern = CheckPattern

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def IsGlobal(self):
        return self._IsGlobal

    @IsGlobal.setter
    def IsGlobal(self, IsGlobal):
        self._IsGlobal = IsGlobal

    @property
    def QuuidList(self):
        return self._QuuidList

    @QuuidList.setter
    def QuuidList(self, QuuidList):
        self._QuuidList = QuuidList

    @property
    def MonitoringPattern(self):
        return self._MonitoringPattern

    @MonitoringPattern.setter
    def MonitoringPattern(self, MonitoringPattern):
        self._MonitoringPattern = MonitoringPattern

    @property
    def Cycle(self):
        return self._Cycle

    @Cycle.setter
    def Cycle(self, Cycle):
        self._Cycle = Cycle

    @property
    def EnableScan(self):
        return self._EnableScan

    @EnableScan.setter
    def EnableScan(self, EnableScan):
        self._EnableScan = EnableScan

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def RealTimeMonitoring(self):
        return self._RealTimeMonitoring

    @RealTimeMonitoring.setter
    def RealTimeMonitoring(self, RealTimeMonitoring):
        self._RealTimeMonitoring = RealTimeMonitoring

    @property
    def AutoIsolation(self):
        return self._AutoIsolation

    @AutoIsolation.setter
    def AutoIsolation(self, AutoIsolation):
        self._AutoIsolation = AutoIsolation

    @property
    def ClickTimeout(self):
        return self._ClickTimeout

    @ClickTimeout.setter
    def ClickTimeout(self, ClickTimeout):
        self._ClickTimeout = ClickTimeout

    @property
    def KillProcess(self):
        return self._KillProcess

    @KillProcess.setter
    def KillProcess(self, KillProcess):
        self._KillProcess = KillProcess

    @property
    def EngineType(self):
        return self._EngineType

    @EngineType.setter
    def EngineType(self, EngineType):
        self._EngineType = EngineType

    @property
    def EnableInspiredEngine(self):
        return self._EnableInspiredEngine

    @EnableInspiredEngine.setter
    def EnableInspiredEngine(self, EnableInspiredEngine):
        self._EnableInspiredEngine = EnableInspiredEngine

    @property
    def EnableMemShellScan(self):
        return self._EnableMemShellScan

    @EnableMemShellScan.setter
    def EnableMemShellScan(self, EnableMemShellScan):
        self._EnableMemShellScan = EnableMemShellScan

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._CheckPattern = params.get("CheckPattern")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._IsGlobal = params.get("IsGlobal")
        self._QuuidList = params.get("QuuidList")
        self._MonitoringPattern = params.get("MonitoringPattern")
        self._Cycle = params.get("Cycle")
        self._EnableScan = params.get("EnableScan")
        self._Id = params.get("Id")
        self._RealTimeMonitoring = params.get("RealTimeMonitoring")
        self._AutoIsolation = params.get("AutoIsolation")
        self._ClickTimeout = params.get("ClickTimeout")
        self._KillProcess = params.get("KillProcess")
        self._EngineType = params.get("EngineType")
        self._EnableInspiredEngine = params.get("EnableInspiredEngine")
        self._EnableMemShellScan = params.get("EnableMemShellScan")
        self._RequestId = params.get("RequestId")


class DescribeMonthInspectionReportRequest(AbstractModel):
    """DescribeMonthInspectionReport请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 分页大小
        :type Limit: int
        :param _Offset: 分页步长
        :type Offset: int
        """
        self._Limit = None
        self._Offset = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMonthInspectionReportResponse(AbstractModel):
    """DescribeMonthInspectionReport返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总条数
        :type TotalCount: int
        :param _List: 巡检报告列表
        :type List: list of MonthInspectionReport
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._List = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = MonthInspectionReport()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeOpenPortStatisticsRequest(AbstractModel):
    """DescribeOpenPortStatistics请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 返回数量，默认为10，最大值为100。
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>Port - Uint64 - 是否必填：否 - 端口号</li>
        :type Filters: list of Filter
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOpenPortStatisticsResponse(AbstractModel):
    """DescribeOpenPortStatistics返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 端口统计列表总数
        :type TotalCount: int
        :param _OpenPortStatistics: 端口统计数据列表
        :type OpenPortStatistics: list of OpenPortStatistics
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._OpenPortStatistics = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def OpenPortStatistics(self):
        return self._OpenPortStatistics

    @OpenPortStatistics.setter
    def OpenPortStatistics(self, OpenPortStatistics):
        self._OpenPortStatistics = OpenPortStatistics

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("OpenPortStatistics") is not None:
            self._OpenPortStatistics = []
            for item in params.get("OpenPortStatistics"):
                obj = OpenPortStatistics()
                obj._deserialize(item)
                self._OpenPortStatistics.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeOverviewStatisticsRequest(AbstractModel):
    """DescribeOverviewStatistics请求参数结构体

    """


class DescribeOverviewStatisticsResponse(AbstractModel):
    """DescribeOverviewStatistics返回参数结构体

    """

    def __init__(self):
        r"""
        :param _OnlineMachineNum: 服务器在线数。
        :type OnlineMachineNum: int
        :param _ProVersionMachineNum: 专业服务器数。
        :type ProVersionMachineNum: int
        :param _MalwareNum: 木马文件数。
        :type MalwareNum: int
        :param _NonlocalLoginNum: 异地登录数。
        :type NonlocalLoginNum: int
        :param _BruteAttackSuccessNum: 暴力破解成功数。
        :type BruteAttackSuccessNum: int
        :param _VulNum: 漏洞数。
        :type VulNum: int
        :param _BaseLineNum: 安全基线数。
        :type BaseLineNum: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._OnlineMachineNum = None
        self._ProVersionMachineNum = None
        self._MalwareNum = None
        self._NonlocalLoginNum = None
        self._BruteAttackSuccessNum = None
        self._VulNum = None
        self._BaseLineNum = None
        self._RequestId = None

    @property
    def OnlineMachineNum(self):
        return self._OnlineMachineNum

    @OnlineMachineNum.setter
    def OnlineMachineNum(self, OnlineMachineNum):
        self._OnlineMachineNum = OnlineMachineNum

    @property
    def ProVersionMachineNum(self):
        return self._ProVersionMachineNum

    @ProVersionMachineNum.setter
    def ProVersionMachineNum(self, ProVersionMachineNum):
        self._ProVersionMachineNum = ProVersionMachineNum

    @property
    def MalwareNum(self):
        return self._MalwareNum

    @MalwareNum.setter
    def MalwareNum(self, MalwareNum):
        self._MalwareNum = MalwareNum

    @property
    def NonlocalLoginNum(self):
        return self._NonlocalLoginNum

    @NonlocalLoginNum.setter
    def NonlocalLoginNum(self, NonlocalLoginNum):
        self._NonlocalLoginNum = NonlocalLoginNum

    @property
    def BruteAttackSuccessNum(self):
        return self._BruteAttackSuccessNum

    @BruteAttackSuccessNum.setter
    def BruteAttackSuccessNum(self, BruteAttackSuccessNum):
        self._BruteAttackSuccessNum = BruteAttackSuccessNum

    @property
    def VulNum(self):
        return self._VulNum

    @VulNum.setter
    def VulNum(self, VulNum):
        self._VulNum = VulNum

    @property
    def BaseLineNum(self):
        return self._BaseLineNum

    @BaseLineNum.setter
    def BaseLineNum(self, BaseLineNum):
        self._BaseLineNum = BaseLineNum

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._OnlineMachineNum = params.get("OnlineMachineNum")
        self._ProVersionMachineNum = params.get("ProVersionMachineNum")
        self._MalwareNum = params.get("MalwareNum")
        self._NonlocalLoginNum = params.get("NonlocalLoginNum")
        self._BruteAttackSuccessNum = params.get("BruteAttackSuccessNum")
        self._VulNum = params.get("VulNum")
        self._BaseLineNum = params.get("BaseLineNum")
        self._RequestId = params.get("RequestId")


class DescribePrivilegeEventInfoRequest(AbstractModel):
    """DescribePrivilegeEventInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 事件id
        :type Id: int
        """
        self._Id = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePrivilegeEventInfoResponse(AbstractModel):
    """DescribePrivilegeEventInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _PrivilegeEventInfo: 本地提权详情
注意：此字段可能返回 null，表示取不到有效值。
        :type PrivilegeEventInfo: :class:`tencentcloud.cwp.v20180228.models.PrivilegeEventInfo`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._PrivilegeEventInfo = None
        self._RequestId = None

    @property
    def PrivilegeEventInfo(self):
        return self._PrivilegeEventInfo

    @PrivilegeEventInfo.setter
    def PrivilegeEventInfo(self, PrivilegeEventInfo):
        self._PrivilegeEventInfo = PrivilegeEventInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("PrivilegeEventInfo") is not None:
            self._PrivilegeEventInfo = PrivilegeEventInfo()
            self._PrivilegeEventInfo._deserialize(params.get("PrivilegeEventInfo"))
        self._RequestId = params.get("RequestId")


class DescribePrivilegeEventsRequest(AbstractModel):
    """DescribePrivilegeEvents请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 返回数量，最大值为100。
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>Keywords - String - 是否必填：否 - 关键词(主机IP)</li>
        :type Filters: list of Filter
        :param _Order: 排序方式：根据请求次数排序：asc-升序/desc-降序
        :type Order: str
        :param _By: 排序字段：CreateTime-发现时间
        :type By: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePrivilegeEventsResponse(AbstractModel):
    """DescribePrivilegeEvents返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 数据列表
        :type List: list of PrivilegeEscalationProcess
        :param _TotalCount: 总条数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = PrivilegeEscalationProcess()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribePrivilegeRulesRequest(AbstractModel):
    """DescribePrivilegeRules请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 返回数量，最大值为100。
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>Keywords - String - 是否必填：否 - 关键字(进程名称)</li>
        :type Filters: list of Filter
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePrivilegeRulesResponse(AbstractModel):
    """DescribePrivilegeRules返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 列表内容
        :type List: list of PrivilegeRule
        :param _TotalCount: 总条数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = PrivilegeRule()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeProVersionInfoRequest(AbstractModel):
    """DescribeProVersionInfo请求参数结构体

    """


class DescribeProVersionInfoResponse(AbstractModel):
    """DescribeProVersionInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _PostPayCost: 后付费昨日扣费
        :type PostPayCost: int
        :param _IsAutoOpenProVersion: 新增主机是否自动开通专业版
        :type IsAutoOpenProVersion: bool
        :param _ProVersionNum: 开通专业版主机数
        :type ProVersionNum: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._PostPayCost = None
        self._IsAutoOpenProVersion = None
        self._ProVersionNum = None
        self._RequestId = None

    @property
    def PostPayCost(self):
        return self._PostPayCost

    @PostPayCost.setter
    def PostPayCost(self, PostPayCost):
        self._PostPayCost = PostPayCost

    @property
    def IsAutoOpenProVersion(self):
        return self._IsAutoOpenProVersion

    @IsAutoOpenProVersion.setter
    def IsAutoOpenProVersion(self, IsAutoOpenProVersion):
        self._IsAutoOpenProVersion = IsAutoOpenProVersion

    @property
    def ProVersionNum(self):
        return self._ProVersionNum

    @ProVersionNum.setter
    def ProVersionNum(self, ProVersionNum):
        self._ProVersionNum = ProVersionNum

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._PostPayCost = params.get("PostPayCost")
        self._IsAutoOpenProVersion = params.get("IsAutoOpenProVersion")
        self._ProVersionNum = params.get("ProVersionNum")
        self._RequestId = params.get("RequestId")


class DescribeProVersionStatusRequest(AbstractModel):
    """DescribeProVersionStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Uuid: 主机安全客户端UUID、填写"all"表示所有主机。
        :type Uuid: str
        """
        self._Uuid = None

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid


    def _deserialize(self, params):
        self._Uuid = params.get("Uuid")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeProVersionStatusResponse(AbstractModel):
    """DescribeProVersionStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DescribeProcessStatisticsRequest(AbstractModel):
    """DescribeProcessStatistics请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 返回数量，默认为10，最大值为100。
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>ProcessName - String - 是否必填：否 - 进程名</li>
        :type Filters: list of Filter
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeProcessStatisticsResponse(AbstractModel):
    """DescribeProcessStatistics返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 进程统计列表记录总数。
        :type TotalCount: int
        :param _ProcessStatistics: 进程统计列表数据数组。
        :type ProcessStatistics: list of ProcessStatistics
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._ProcessStatistics = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ProcessStatistics(self):
        return self._ProcessStatistics

    @ProcessStatistics.setter
    def ProcessStatistics(self, ProcessStatistics):
        self._ProcessStatistics = ProcessStatistics

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ProcessStatistics") is not None:
            self._ProcessStatistics = []
            for item in params.get("ProcessStatistics"):
                obj = ProcessStatistics()
                obj._deserialize(item)
                self._ProcessStatistics.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeProtectDirListRequest(AbstractModel):
    """DescribeProtectDirList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 分页条数 最大100条
        :type Limit: int
        :param _Offset: 偏移量
        :type Offset: int
        :param _Filters: DirName 网站名称
DirPath 网站防护目录地址
        :type Filters: list of AssetFilters
        :param _Order: asc：升序/desc：降序
        :type Order: str
        :param _By: 排序字段
        :type By: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeProtectDirListResponse(AbstractModel):
    """DescribeProtectDirList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总数
        :type TotalCount: int
        :param _List: 防护目录列表信息
        :type List: list of ProtectDirInfo
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._List = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ProtectDirInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeProtectDirRelatedServerRequest(AbstractModel):
    """DescribeProtectDirRelatedServer请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 唯一ID
        :type Id: str
        :param _Limit: 分页条数 最大100条
        :type Limit: int
        :param _Offset: 偏移量
        :type Offset: int
        :param _Filters: 过滤参数 ProtectStatus
        :type Filters: list of Filter
        :param _Order: 排序方式
        :type Order: str
        :param _By: 排序值
        :type By: str
        """
        self._Id = None
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeProtectDirRelatedServerResponse(AbstractModel):
    """DescribeProtectDirRelatedServer返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 网站关联服务器列表信息
        :type List: list of ProtectDirRelatedServer
        :param _TotalCount: 总数
        :type TotalCount: int
        :param _ProtectServerCount: 已开启防护总数
        :type ProtectServerCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._ProtectServerCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ProtectServerCount(self):
        return self._ProtectServerCount

    @ProtectServerCount.setter
    def ProtectServerCount(self, ProtectServerCount):
        self._ProtectServerCount = ProtectServerCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ProtectDirRelatedServer()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._ProtectServerCount = params.get("ProtectServerCount")
        self._RequestId = params.get("RequestId")


class DescribeProtectNetListRequest(AbstractModel):
    """DescribeProtectNetList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤条件。
<li>Keyword- String - 是否必填：否 - 关键词过滤，</li>
<li>Uuids - String - 是否必填：否 - 主机id过滤</li>
        :type Filters: list of Filters
        :param _Limit: 需要返回的数量，最大值为100
        :type Limit: int
        :param _Offset: 排序步长
        :type Offset: int
        :param _Order: 排序方法
        :type Order: str
        :param _By: 排序字段 StartTime，EndTime
        :type By: str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeProtectNetListResponse(AbstractModel):
    """DescribeProtectNetList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总条数
        :type TotalCount: int
        :param _List: 安全管家数据
        :type List: list of ProtectNetInfo
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._List = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ProtectNetInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeReverseShellEventInfoRequest(AbstractModel):
    """DescribeReverseShellEventInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 事件id
        :type Id: int
        """
        self._Id = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeReverseShellEventInfoResponse(AbstractModel):
    """DescribeReverseShellEventInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ReverseShellEventInfo: 反弹shell详情信息
注意：此字段可能返回 null，表示取不到有效值。
        :type ReverseShellEventInfo: :class:`tencentcloud.cwp.v20180228.models.ReverseShellEventInfo`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ReverseShellEventInfo = None
        self._RequestId = None

    @property
    def ReverseShellEventInfo(self):
        return self._ReverseShellEventInfo

    @ReverseShellEventInfo.setter
    def ReverseShellEventInfo(self, ReverseShellEventInfo):
        self._ReverseShellEventInfo = ReverseShellEventInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ReverseShellEventInfo") is not None:
            self._ReverseShellEventInfo = ReverseShellEventInfo()
            self._ReverseShellEventInfo._deserialize(params.get("ReverseShellEventInfo"))
        self._RequestId = params.get("RequestId")


class DescribeReverseShellEventsRequest(AbstractModel):
    """DescribeReverseShellEvents请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 返回数量，最大值为100。
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>Keywords - String - 是否必填：否 - 关键字(主机内网IP|进程名)</li>
        :type Filters: list of Filter
        :param _Order: 排序方式：根据请求次数排序：asc-升序/desc-降序
        :type Order: str
        :param _By: 排序字段：CreateTime-发生时间
        :type By: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeReverseShellEventsResponse(AbstractModel):
    """DescribeReverseShellEvents返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 列表内容
        :type List: list of ReverseShell
        :param _TotalCount: 总条数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ReverseShell()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeReverseShellRulesRequest(AbstractModel):
    """DescribeReverseShellRules请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 返回数量，默认为10，最大值为100。
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>Keywords - String - 是否必填：否 - 关键字(进程名称)</li>
        :type Filters: list of Filter
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeReverseShellRulesResponse(AbstractModel):
    """DescribeReverseShellRules返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 列表内容
        :type List: list of ReverseShellRule
        :param _TotalCount: 总条数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ReverseShellRule()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeRiskDnsEventInfoRequest(AbstractModel):
    """DescribeRiskDnsEventInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 恶意请求事件Id
        :type Id: int
        """
        self._Id = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRiskDnsEventInfoResponse(AbstractModel):
    """DescribeRiskDnsEventInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Info: 恶意请求事件详情
注意：此字段可能返回 null，表示取不到有效值。
        :type Info: :class:`tencentcloud.cwp.v20180228.models.RiskDnsEvent`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Info = None
        self._RequestId = None

    @property
    def Info(self):
        return self._Info

    @Info.setter
    def Info(self, Info):
        self._Info = Info

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Info") is not None:
            self._Info = RiskDnsEvent()
            self._Info._deserialize(params.get("Info"))
        self._RequestId = params.get("RequestId")


class DescribeRiskDnsEventListRequest(AbstractModel):
    """DescribeRiskDnsEventList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: <li>IpOrName - String - 是否必填：否 - 主机Ip或别名筛选</li>
<li>HostId - String - 是否必填：否 - 主机Id</li>
<li>AgentId - String - 是否必填：否 - 客户端Id</li>
<li>PolicyType - String - 是否必填：否 - 策略类型,0:系统策略1:用户自定义策略</li>
<li>Domain - String - 是否必填：否 - 域名(先对域名做urlencode,再base64)</li>
<li>HandleStatus - String - 是否必填：否 - 状态筛选0:待处理；2:信任；3:不信任</li>
<li>BeginTime - String - 是否必填：否 - 最近访问开始时间</li>
<li>EndTime - String - 是否必填：否 - 最近访问结束时间</li>
        :type Filters: list of Filter
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Order: 排序方式：根据请求次数排序：[asc:升序|desc:降序]
        :type Order: str
        :param _By: 排序字段：[AccessCount:请求次数|LastTime:最近请求时间]
        :type By: str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRiskDnsEventListResponse(AbstractModel):
    """DescribeRiskDnsEventList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 恶意请求事件列表
注意：此字段可能返回 null，表示取不到有效值。
        :type List: list of RiskDnsEvent
        :param _TotalCount: 总数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = RiskDnsEvent()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeRiskDnsListRequest(AbstractModel):
    """DescribeRiskDnsList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>IpOrAlias - String - 是否必填：否 - 主机ip或别名筛选</li>
<li>Url - String - 是否必填：否 - Url筛选</li>
<li>Status - String - 是否必填：否 - 状态筛选0:待处理；2:信任；3:不信任</li>
<li>MergeBeginTime - String - 是否必填：否 - 最近访问开始时间</li>
<li>MergeEndTime - String - 是否必填：否 - 最近访问结束时间</li>
        :type Filters: list of Filter
        :param _Order: 排序方式：根据请求次数排序：asc-升序/desc-降序
        :type Order: str
        :param _By: 排序字段：AccessCount-请求次数。MergeTime-最近请求时间
        :type By: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRiskDnsListResponse(AbstractModel):
    """DescribeRiskDnsList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RiskDnsList: 恶意请求列表数组
注意：此字段可能返回 null，表示取不到有效值。
        :type RiskDnsList: list of RiskDnsList
        :param _TotalCount: 总数量
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RiskDnsList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def RiskDnsList(self):
        return self._RiskDnsList

    @RiskDnsList.setter
    def RiskDnsList(self, RiskDnsList):
        self._RiskDnsList = RiskDnsList

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RiskDnsList") is not None:
            self._RiskDnsList = []
            for item in params.get("RiskDnsList"):
                obj = RiskDnsList()
                obj._deserialize(item)
                self._RiskDnsList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeScanMalwareScheduleRequest(AbstractModel):
    """DescribeScanMalwareSchedule请求参数结构体

    """


class DescribeScanMalwareScheduleResponse(AbstractModel):
    """DescribeScanMalwareSchedule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Schedule: 扫描进度（单位：%）
        :type Schedule: int
        :param _RiskFileNumber: 风险文件数,当进度满了以后才有该值
        :type RiskFileNumber: int
        :param _IsSchedule: 是否正在扫描中
        :type IsSchedule: bool
        :param _ScanStatus: 0 从未扫描过、 1 扫描中、 2扫描完成、 3停止中、 4停止完成
        :type ScanStatus: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Schedule = None
        self._RiskFileNumber = None
        self._IsSchedule = None
        self._ScanStatus = None
        self._RequestId = None

    @property
    def Schedule(self):
        return self._Schedule

    @Schedule.setter
    def Schedule(self, Schedule):
        self._Schedule = Schedule

    @property
    def RiskFileNumber(self):
        return self._RiskFileNumber

    @RiskFileNumber.setter
    def RiskFileNumber(self, RiskFileNumber):
        self._RiskFileNumber = RiskFileNumber

    @property
    def IsSchedule(self):
        return self._IsSchedule

    @IsSchedule.setter
    def IsSchedule(self, IsSchedule):
        self._IsSchedule = IsSchedule

    @property
    def ScanStatus(self):
        return self._ScanStatus

    @ScanStatus.setter
    def ScanStatus(self, ScanStatus):
        self._ScanStatus = ScanStatus

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Schedule = params.get("Schedule")
        self._RiskFileNumber = params.get("RiskFileNumber")
        self._IsSchedule = params.get("IsSchedule")
        self._ScanStatus = params.get("ScanStatus")
        self._RequestId = params.get("RequestId")


class DescribeScanScheduleRequest(AbstractModel):
    """DescribeScanSchedule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: int
        """
        self._TaskId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeScanScheduleResponse(AbstractModel):
    """DescribeScanSchedule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Schedule: 检测进度
注意：此字段可能返回 null，表示取不到有效值。
        :type Schedule: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Schedule = None
        self._RequestId = None

    @property
    def Schedule(self):
        return self._Schedule

    @Schedule.setter
    def Schedule(self, Schedule):
        self._Schedule = Schedule

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Schedule = params.get("Schedule")
        self._RequestId = params.get("RequestId")


class DescribeScanStateRequest(AbstractModel):
    """DescribeScanState请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ModuleType: 模块类型 当前提供 Malware 木马 , Vul 漏洞 , Baseline 基线
        :type ModuleType: str
        :param _Filters: 过滤参数;
<li>StrategyId 基线策略ID ,仅ModuleType 为 Baseline 时需要</li>
        :type Filters: list of Filters
        """
        self._ModuleType = None
        self._Filters = None

    @property
    def ModuleType(self):
        return self._ModuleType

    @ModuleType.setter
    def ModuleType(self, ModuleType):
        self._ModuleType = ModuleType

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._ModuleType = params.get("ModuleType")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeScanStateResponse(AbstractModel):
    """DescribeScanState返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ScanState: 0 从未扫描过、 1 扫描中、 2扫描完成、 3停止中、 4停止完成
        :type ScanState: int
        :param _Schedule: 扫描进度
        :type Schedule: int
        :param _TaskId: 任务Id
        :type TaskId: int
        :param _VulId: 任务扫描的漏洞id
        :type VulId: list of int non-negative
        :param _Type: 0一键检测 1定时检测
        :type Type: int
        :param _ScanBeginTime: 开始扫描时间
注意：此字段可能返回 null，表示取不到有效值。
        :type ScanBeginTime: str
        :param _RiskEventCount: 扫描漏洞数
注意：此字段可能返回 null，表示取不到有效值。
        :type RiskEventCount: int
        :param _ScanEndTime: 扫描结束时间
注意：此字段可能返回 null，表示取不到有效值。
        :type ScanEndTime: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ScanState = None
        self._Schedule = None
        self._TaskId = None
        self._VulId = None
        self._Type = None
        self._ScanBeginTime = None
        self._RiskEventCount = None
        self._ScanEndTime = None
        self._RequestId = None

    @property
    def ScanState(self):
        return self._ScanState

    @ScanState.setter
    def ScanState(self, ScanState):
        self._ScanState = ScanState

    @property
    def Schedule(self):
        return self._Schedule

    @Schedule.setter
    def Schedule(self, Schedule):
        self._Schedule = Schedule

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def VulId(self):
        return self._VulId

    @VulId.setter
    def VulId(self, VulId):
        self._VulId = VulId

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def ScanBeginTime(self):
        return self._ScanBeginTime

    @ScanBeginTime.setter
    def ScanBeginTime(self, ScanBeginTime):
        self._ScanBeginTime = ScanBeginTime

    @property
    def RiskEventCount(self):
        return self._RiskEventCount

    @RiskEventCount.setter
    def RiskEventCount(self, RiskEventCount):
        self._RiskEventCount = RiskEventCount

    @property
    def ScanEndTime(self):
        return self._ScanEndTime

    @ScanEndTime.setter
    def ScanEndTime(self, ScanEndTime):
        self._ScanEndTime = ScanEndTime

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ScanState = params.get("ScanState")
        self._Schedule = params.get("Schedule")
        self._TaskId = params.get("TaskId")
        self._VulId = params.get("VulId")
        self._Type = params.get("Type")
        self._ScanBeginTime = params.get("ScanBeginTime")
        self._RiskEventCount = params.get("RiskEventCount")
        self._ScanEndTime = params.get("ScanEndTime")
        self._RequestId = params.get("RequestId")


class DescribeScanTaskDetailsRequest(AbstractModel):
    """DescribeScanTaskDetails请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ModuleType: 模块类型 当前提供 Malware 木马 , Vul 漏洞 , Baseline 基线
        :type ModuleType: str
        :param _TaskId: 任务ID
        :type TaskId: int
        :param _Filters: 过滤参数
        :type Filters: list of Filters
        :param _Limit: 需要返回的数量，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        """
        self._ModuleType = None
        self._TaskId = None
        self._Filters = None
        self._Limit = None
        self._Offset = None

    @property
    def ModuleType(self):
        return self._ModuleType

    @ModuleType.setter
    def ModuleType(self, ModuleType):
        self._ModuleType = ModuleType

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._ModuleType = params.get("ModuleType")
        self._TaskId = params.get("TaskId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeScanTaskDetailsResponse(AbstractModel):
    """DescribeScanTaskDetails返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ScanTaskDetailList: 扫描任务信息列表
        :type ScanTaskDetailList: list of ScanTaskDetails
        :param _TotalCount: 总数
        :type TotalCount: int
        :param _ScanMachineCount: 扫描机器总数
        :type ScanMachineCount: int
        :param _RiskMachineCount: 发现风险机器数
        :type RiskMachineCount: int
        :param _ScanBeginTime: 扫描开始时间
        :type ScanBeginTime: str
        :param _ScanEndTime: 扫描结束时间
        :type ScanEndTime: str
        :param _ScanTime: 检测时间
        :type ScanTime: int
        :param _ScanProgress: 扫描进度
        :type ScanProgress: int
        :param _ScanLeftTime: 扫描剩余时间
        :type ScanLeftTime: int
        :param _ScanContent: 扫描内容
        :type ScanContent: list of str
        :param _VulInfo: 漏洞信息
注意：此字段可能返回 null，表示取不到有效值。
        :type VulInfo: list of VulDetailInfo
        :param _RiskEventCount: 风险事件个数
注意：此字段可能返回 null，表示取不到有效值。
        :type RiskEventCount: int
        :param _Type: 0一键检测 1定时检测
注意：此字段可能返回 null，表示取不到有效值。
        :type Type: int
        :param _StoppingAll: 任务是否全部正在被停止 ture是
注意：此字段可能返回 null，表示取不到有效值。
        :type StoppingAll: bool
        :param _VulCount: 扫描出漏洞个数
注意：此字段可能返回 null，表示取不到有效值。
        :type VulCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ScanTaskDetailList = None
        self._TotalCount = None
        self._ScanMachineCount = None
        self._RiskMachineCount = None
        self._ScanBeginTime = None
        self._ScanEndTime = None
        self._ScanTime = None
        self._ScanProgress = None
        self._ScanLeftTime = None
        self._ScanContent = None
        self._VulInfo = None
        self._RiskEventCount = None
        self._Type = None
        self._StoppingAll = None
        self._VulCount = None
        self._RequestId = None

    @property
    def ScanTaskDetailList(self):
        return self._ScanTaskDetailList

    @ScanTaskDetailList.setter
    def ScanTaskDetailList(self, ScanTaskDetailList):
        self._ScanTaskDetailList = ScanTaskDetailList

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ScanMachineCount(self):
        return self._ScanMachineCount

    @ScanMachineCount.setter
    def ScanMachineCount(self, ScanMachineCount):
        self._ScanMachineCount = ScanMachineCount

    @property
    def RiskMachineCount(self):
        return self._RiskMachineCount

    @RiskMachineCount.setter
    def RiskMachineCount(self, RiskMachineCount):
        self._RiskMachineCount = RiskMachineCount

    @property
    def ScanBeginTime(self):
        return self._ScanBeginTime

    @ScanBeginTime.setter
    def ScanBeginTime(self, ScanBeginTime):
        self._ScanBeginTime = ScanBeginTime

    @property
    def ScanEndTime(self):
        return self._ScanEndTime

    @ScanEndTime.setter
    def ScanEndTime(self, ScanEndTime):
        self._ScanEndTime = ScanEndTime

    @property
    def ScanTime(self):
        return self._ScanTime

    @ScanTime.setter
    def ScanTime(self, ScanTime):
        self._ScanTime = ScanTime

    @property
    def ScanProgress(self):
        return self._ScanProgress

    @ScanProgress.setter
    def ScanProgress(self, ScanProgress):
        self._ScanProgress = ScanProgress

    @property
    def ScanLeftTime(self):
        return self._ScanLeftTime

    @ScanLeftTime.setter
    def ScanLeftTime(self, ScanLeftTime):
        self._ScanLeftTime = ScanLeftTime

    @property
    def ScanContent(self):
        return self._ScanContent

    @ScanContent.setter
    def ScanContent(self, ScanContent):
        self._ScanContent = ScanContent

    @property
    def VulInfo(self):
        return self._VulInfo

    @VulInfo.setter
    def VulInfo(self, VulInfo):
        self._VulInfo = VulInfo

    @property
    def RiskEventCount(self):
        return self._RiskEventCount

    @RiskEventCount.setter
    def RiskEventCount(self, RiskEventCount):
        self._RiskEventCount = RiskEventCount

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def StoppingAll(self):
        return self._StoppingAll

    @StoppingAll.setter
    def StoppingAll(self, StoppingAll):
        self._StoppingAll = StoppingAll

    @property
    def VulCount(self):
        return self._VulCount

    @VulCount.setter
    def VulCount(self, VulCount):
        self._VulCount = VulCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ScanTaskDetailList") is not None:
            self._ScanTaskDetailList = []
            for item in params.get("ScanTaskDetailList"):
                obj = ScanTaskDetails()
                obj._deserialize(item)
                self._ScanTaskDetailList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._ScanMachineCount = params.get("ScanMachineCount")
        self._RiskMachineCount = params.get("RiskMachineCount")
        self._ScanBeginTime = params.get("ScanBeginTime")
        self._ScanEndTime = params.get("ScanEndTime")
        self._ScanTime = params.get("ScanTime")
        self._ScanProgress = params.get("ScanProgress")
        self._ScanLeftTime = params.get("ScanLeftTime")
        self._ScanContent = params.get("ScanContent")
        if params.get("VulInfo") is not None:
            self._VulInfo = []
            for item in params.get("VulInfo"):
                obj = VulDetailInfo()
                obj._deserialize(item)
                self._VulInfo.append(obj)
        self._RiskEventCount = params.get("RiskEventCount")
        self._Type = params.get("Type")
        self._StoppingAll = params.get("StoppingAll")
        self._VulCount = params.get("VulCount")
        self._RequestId = params.get("RequestId")


class DescribeScanTaskStatusRequest(AbstractModel):
    """DescribeScanTaskStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ModuleType: 模块类型 当前提供 Malware 木马 , Vul 漏洞 , Baseline 基线
        :type ModuleType: str
        """
        self._ModuleType = None

    @property
    def ModuleType(self):
        return self._ModuleType

    @ModuleType.setter
    def ModuleType(self, ModuleType):
        self._ModuleType = ModuleType


    def _deserialize(self, params):
        self._ModuleType = params.get("ModuleType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeScanTaskStatusResponse(AbstractModel):
    """DescribeScanTaskStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _State: 任务扫描状态列表
        :type State: :class:`tencentcloud.cwp.v20180228.models.TaskStatus`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._State = None
        self._RequestId = None

    @property
    def State(self):
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("State") is not None:
            self._State = TaskStatus()
            self._State._deserialize(params.get("State"))
        self._RequestId = params.get("RequestId")


class DescribeScanVulSettingRequest(AbstractModel):
    """DescribeScanVulSetting请求参数结构体

    """


class DescribeScanVulSettingResponse(AbstractModel):
    """DescribeScanVulSetting返回参数结构体

    """

    def __init__(self):
        r"""
        :param _VulCategories: 漏洞类型：1: web-cms漏洞 2:应用漏洞  4: Linux软件漏洞 5: Windows系统漏洞
        :type VulCategories: str
        :param _VulLevels: 危害等级：1-低危；2-中危；3-高危；4-严重 (多选英文逗号分隔)
        :type VulLevels: str
        :param _TimerInterval: 定期检测间隔时间（天）
        :type TimerInterval: int
        :param _TimerTime: 定期检测时间，如：00:00
        :type TimerTime: str
        :param _VulEmergency: 是否紧急漏洞：0-否 1-是
        :type VulEmergency: int
        :param _StartTime: 开始时间
        :type StartTime: str
        :param _EnableScan: 是否开启
        :type EnableScan: int
        :param _EndTime: 结束时间
        :type EndTime: str
        :param _ClickTimeout: 一键扫描超时时长，如：1800秒（s）
        :type ClickTimeout: int
        :param _Uuids: 为空默认扫描全部专业版、旗舰版、普惠版主机，不为空只扫描选中主机
        :type Uuids: list of str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._VulCategories = None
        self._VulLevels = None
        self._TimerInterval = None
        self._TimerTime = None
        self._VulEmergency = None
        self._StartTime = None
        self._EnableScan = None
        self._EndTime = None
        self._ClickTimeout = None
        self._Uuids = None
        self._RequestId = None

    @property
    def VulCategories(self):
        return self._VulCategories

    @VulCategories.setter
    def VulCategories(self, VulCategories):
        self._VulCategories = VulCategories

    @property
    def VulLevels(self):
        return self._VulLevels

    @VulLevels.setter
    def VulLevels(self, VulLevels):
        self._VulLevels = VulLevels

    @property
    def TimerInterval(self):
        return self._TimerInterval

    @TimerInterval.setter
    def TimerInterval(self, TimerInterval):
        self._TimerInterval = TimerInterval

    @property
    def TimerTime(self):
        return self._TimerTime

    @TimerTime.setter
    def TimerTime(self, TimerTime):
        self._TimerTime = TimerTime

    @property
    def VulEmergency(self):
        return self._VulEmergency

    @VulEmergency.setter
    def VulEmergency(self, VulEmergency):
        self._VulEmergency = VulEmergency

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EnableScan(self):
        return self._EnableScan

    @EnableScan.setter
    def EnableScan(self, EnableScan):
        self._EnableScan = EnableScan

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def ClickTimeout(self):
        return self._ClickTimeout

    @ClickTimeout.setter
    def ClickTimeout(self, ClickTimeout):
        self._ClickTimeout = ClickTimeout

    @property
    def Uuids(self):
        return self._Uuids

    @Uuids.setter
    def Uuids(self, Uuids):
        self._Uuids = Uuids

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._VulCategories = params.get("VulCategories")
        self._VulLevels = params.get("VulLevels")
        self._TimerInterval = params.get("TimerInterval")
        self._TimerTime = params.get("TimerTime")
        self._VulEmergency = params.get("VulEmergency")
        self._StartTime = params.get("StartTime")
        self._EnableScan = params.get("EnableScan")
        self._EndTime = params.get("EndTime")
        self._ClickTimeout = params.get("ClickTimeout")
        self._Uuids = params.get("Uuids")
        self._RequestId = params.get("RequestId")


class DescribeSearchLogsRequest(AbstractModel):
    """DescribeSearchLogs请求参数结构体

    """


class DescribeSearchLogsResponse(AbstractModel):
    """DescribeSearchLogs返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Data: 历史搜索记录 保留最新的10条
        :type Data: list of str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DescribeSearchTemplatesRequest(AbstractModel):
    """DescribeSearchTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Limit: 返回数量，默认为10，最大值为100。
        :type Limit: int
        """
        self._Offset = None
        self._Limit = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSearchTemplatesResponse(AbstractModel):
    """DescribeSearchTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总数
        :type TotalCount: int
        :param _List: 模板列表
        :type List: list of SearchTemplate
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._List = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = SearchTemplate()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSecurityDynamicsRequest(AbstractModel):
    """DescribeSecurityDynamics请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 返回数量，最大值为100。
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        """
        self._Limit = None
        self._Offset = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSecurityDynamicsResponse(AbstractModel):
    """DescribeSecurityDynamics返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SecurityDynamics: 安全事件消息数组。
        :type SecurityDynamics: list of SecurityDynamic
        :param _TotalCount: 记录总数。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SecurityDynamics = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SecurityDynamics(self):
        return self._SecurityDynamics

    @SecurityDynamics.setter
    def SecurityDynamics(self, SecurityDynamics):
        self._SecurityDynamics = SecurityDynamics

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SecurityDynamics") is not None:
            self._SecurityDynamics = []
            for item in params.get("SecurityDynamics"):
                obj = SecurityDynamic()
                obj._deserialize(item)
                self._SecurityDynamics.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeSecurityEventStatRequest(AbstractModel):
    """DescribeSecurityEventStat请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 该接口无过滤条件
        :type Filters: list of Filter
        """
        self._Filters = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSecurityEventStatResponse(AbstractModel):
    """DescribeSecurityEventStat返回参数结构体

    """

    def __init__(self):
        r"""
        :param _MalwareStat: 木马事件统计
        :type MalwareStat: :class:`tencentcloud.cwp.v20180228.models.EventStat`
        :param _HostLoginStat: 异地事件统计
        :type HostLoginStat: :class:`tencentcloud.cwp.v20180228.models.EventStat`
        :param _BruteAttackStat: 爆破事件统计
        :type BruteAttackStat: :class:`tencentcloud.cwp.v20180228.models.EventStat`
        :param _MaliciousRequestStat: 恶意请求事件统计
        :type MaliciousRequestStat: :class:`tencentcloud.cwp.v20180228.models.EventStat`
        :param _PrivilegeStat: 本地提权事件统计
        :type PrivilegeStat: :class:`tencentcloud.cwp.v20180228.models.EventStat`
        :param _ReverseShellStat: 反弹Shell事件统计
        :type ReverseShellStat: :class:`tencentcloud.cwp.v20180228.models.EventStat`
        :param _HighRiskBashStat: 高危命令事件统计
        :type HighRiskBashStat: :class:`tencentcloud.cwp.v20180228.models.EventStat`
        :param _AttackLogsStat: 网络攻击事件统计
        :type AttackLogsStat: :class:`tencentcloud.cwp.v20180228.models.EventStat`
        :param _VulHighStat: 高危漏洞事件统计
        :type VulHighStat: :class:`tencentcloud.cwp.v20180228.models.EventStat`
        :param _VulNormalStat: 中危漏洞事件统计
        :type VulNormalStat: :class:`tencentcloud.cwp.v20180228.models.EventStat`
        :param _VulLowStat: 低危漏洞事件统计
        :type VulLowStat: :class:`tencentcloud.cwp.v20180228.models.EventStat`
        :param _BaselineHighStat: 高危基线漏洞事件统计
        :type BaselineHighStat: :class:`tencentcloud.cwp.v20180228.models.EventStat`
        :param _BaselineNormalStat: 中危基线漏事件统计
        :type BaselineNormalStat: :class:`tencentcloud.cwp.v20180228.models.EventStat`
        :param _BaselineLowStat: 低危基线漏事件统计
        :type BaselineLowStat: :class:`tencentcloud.cwp.v20180228.models.EventStat`
        :param _MachineTotalAffectNum: 有未处理安全事件的机器总数
        :type MachineTotalAffectNum: int
        :param _InvasionTotalAffectNum: 有未处理入侵安全事件的机器总数
        :type InvasionTotalAffectNum: int
        :param _VulTotalAffectNum: 有未处理漏洞安全事件的机器总数
        :type VulTotalAffectNum: int
        :param _BaseLineTotalAffectNum: 有未处理基线安全事件的机器总数
        :type BaseLineTotalAffectNum: int
        :param _CyberAttackTotalAffectNum: 有未处理网络攻击安全事件的机器总数
        :type CyberAttackTotalAffectNum: int
        :param _VulRiskStat: 严重漏洞事件统计
        :type VulRiskStat: :class:`tencentcloud.cwp.v20180228.models.EventStat`
        :param _BaselineRiskStat: 严重基线漏洞事件统计
        :type BaselineRiskStat: :class:`tencentcloud.cwp.v20180228.models.EventStat`
        :param _VulStat: 漏洞数统计
        :type VulStat: :class:`tencentcloud.cwp.v20180228.models.EventStat`
        :param _Score: 安全得分
        :type Score: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._MalwareStat = None
        self._HostLoginStat = None
        self._BruteAttackStat = None
        self._MaliciousRequestStat = None
        self._PrivilegeStat = None
        self._ReverseShellStat = None
        self._HighRiskBashStat = None
        self._AttackLogsStat = None
        self._VulHighStat = None
        self._VulNormalStat = None
        self._VulLowStat = None
        self._BaselineHighStat = None
        self._BaselineNormalStat = None
        self._BaselineLowStat = None
        self._MachineTotalAffectNum = None
        self._InvasionTotalAffectNum = None
        self._VulTotalAffectNum = None
        self._BaseLineTotalAffectNum = None
        self._CyberAttackTotalAffectNum = None
        self._VulRiskStat = None
        self._BaselineRiskStat = None
        self._VulStat = None
        self._Score = None
        self._RequestId = None

    @property
    def MalwareStat(self):
        return self._MalwareStat

    @MalwareStat.setter
    def MalwareStat(self, MalwareStat):
        self._MalwareStat = MalwareStat

    @property
    def HostLoginStat(self):
        return self._HostLoginStat

    @HostLoginStat.setter
    def HostLoginStat(self, HostLoginStat):
        self._HostLoginStat = HostLoginStat

    @property
    def BruteAttackStat(self):
        return self._BruteAttackStat

    @BruteAttackStat.setter
    def BruteAttackStat(self, BruteAttackStat):
        self._BruteAttackStat = BruteAttackStat

    @property
    def MaliciousRequestStat(self):
        return self._MaliciousRequestStat

    @MaliciousRequestStat.setter
    def MaliciousRequestStat(self, MaliciousRequestStat):
        self._MaliciousRequestStat = MaliciousRequestStat

    @property
    def PrivilegeStat(self):
        return self._PrivilegeStat

    @PrivilegeStat.setter
    def PrivilegeStat(self, PrivilegeStat):
        self._PrivilegeStat = PrivilegeStat

    @property
    def ReverseShellStat(self):
        return self._ReverseShellStat

    @ReverseShellStat.setter
    def ReverseShellStat(self, ReverseShellStat):
        self._ReverseShellStat = ReverseShellStat

    @property
    def HighRiskBashStat(self):
        return self._HighRiskBashStat

    @HighRiskBashStat.setter
    def HighRiskBashStat(self, HighRiskBashStat):
        self._HighRiskBashStat = HighRiskBashStat

    @property
    def AttackLogsStat(self):
        return self._AttackLogsStat

    @AttackLogsStat.setter
    def AttackLogsStat(self, AttackLogsStat):
        self._AttackLogsStat = AttackLogsStat

    @property
    def VulHighStat(self):
        return self._VulHighStat

    @VulHighStat.setter
    def VulHighStat(self, VulHighStat):
        self._VulHighStat = VulHighStat

    @property
    def VulNormalStat(self):
        return self._VulNormalStat

    @VulNormalStat.setter
    def VulNormalStat(self, VulNormalStat):
        self._VulNormalStat = VulNormalStat

    @property
    def VulLowStat(self):
        return self._VulLowStat

    @VulLowStat.setter
    def VulLowStat(self, VulLowStat):
        self._VulLowStat = VulLowStat

    @property
    def BaselineHighStat(self):
        return self._BaselineHighStat

    @BaselineHighStat.setter
    def BaselineHighStat(self, BaselineHighStat):
        self._BaselineHighStat = BaselineHighStat

    @property
    def BaselineNormalStat(self):
        return self._BaselineNormalStat

    @BaselineNormalStat.setter
    def BaselineNormalStat(self, BaselineNormalStat):
        self._BaselineNormalStat = BaselineNormalStat

    @property
    def BaselineLowStat(self):
        return self._BaselineLowStat

    @BaselineLowStat.setter
    def BaselineLowStat(self, BaselineLowStat):
        self._BaselineLowStat = BaselineLowStat

    @property
    def MachineTotalAffectNum(self):
        return self._MachineTotalAffectNum

    @MachineTotalAffectNum.setter
    def MachineTotalAffectNum(self, MachineTotalAffectNum):
        self._MachineTotalAffectNum = MachineTotalAffectNum

    @property
    def InvasionTotalAffectNum(self):
        return self._InvasionTotalAffectNum

    @InvasionTotalAffectNum.setter
    def InvasionTotalAffectNum(self, InvasionTotalAffectNum):
        self._InvasionTotalAffectNum = InvasionTotalAffectNum

    @property
    def VulTotalAffectNum(self):
        return self._VulTotalAffectNum

    @VulTotalAffectNum.setter
    def VulTotalAffectNum(self, VulTotalAffectNum):
        self._VulTotalAffectNum = VulTotalAffectNum

    @property
    def BaseLineTotalAffectNum(self):
        return self._BaseLineTotalAffectNum

    @BaseLineTotalAffectNum.setter
    def BaseLineTotalAffectNum(self, BaseLineTotalAffectNum):
        self._BaseLineTotalAffectNum = BaseLineTotalAffectNum

    @property
    def CyberAttackTotalAffectNum(self):
        return self._CyberAttackTotalAffectNum

    @CyberAttackTotalAffectNum.setter
    def CyberAttackTotalAffectNum(self, CyberAttackTotalAffectNum):
        self._CyberAttackTotalAffectNum = CyberAttackTotalAffectNum

    @property
    def VulRiskStat(self):
        return self._VulRiskStat

    @VulRiskStat.setter
    def VulRiskStat(self, VulRiskStat):
        self._VulRiskStat = VulRiskStat

    @property
    def BaselineRiskStat(self):
        return self._BaselineRiskStat

    @BaselineRiskStat.setter
    def BaselineRiskStat(self, BaselineRiskStat):
        self._BaselineRiskStat = BaselineRiskStat

    @property
    def VulStat(self):
        return self._VulStat

    @VulStat.setter
    def VulStat(self, VulStat):
        self._VulStat = VulStat

    @property
    def Score(self):
        return self._Score

    @Score.setter
    def Score(self, Score):
        self._Score = Score

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("MalwareStat") is not None:
            self._MalwareStat = EventStat()
            self._MalwareStat._deserialize(params.get("MalwareStat"))
        if params.get("HostLoginStat") is not None:
            self._HostLoginStat = EventStat()
            self._HostLoginStat._deserialize(params.get("HostLoginStat"))
        if params.get("BruteAttackStat") is not None:
            self._BruteAttackStat = EventStat()
            self._BruteAttackStat._deserialize(params.get("BruteAttackStat"))
        if params.get("MaliciousRequestStat") is not None:
            self._MaliciousRequestStat = EventStat()
            self._MaliciousRequestStat._deserialize(params.get("MaliciousRequestStat"))
        if params.get("PrivilegeStat") is not None:
            self._PrivilegeStat = EventStat()
            self._PrivilegeStat._deserialize(params.get("PrivilegeStat"))
        if params.get("ReverseShellStat") is not None:
            self._ReverseShellStat = EventStat()
            self._ReverseShellStat._deserialize(params.get("ReverseShellStat"))
        if params.get("HighRiskBashStat") is not None:
            self._HighRiskBashStat = EventStat()
            self._HighRiskBashStat._deserialize(params.get("HighRiskBashStat"))
        if params.get("AttackLogsStat") is not None:
            self._AttackLogsStat = EventStat()
            self._AttackLogsStat._deserialize(params.get("AttackLogsStat"))
        if params.get("VulHighStat") is not None:
            self._VulHighStat = EventStat()
            self._VulHighStat._deserialize(params.get("VulHighStat"))
        if params.get("VulNormalStat") is not None:
            self._VulNormalStat = EventStat()
            self._VulNormalStat._deserialize(params.get("VulNormalStat"))
        if params.get("VulLowStat") is not None:
            self._VulLowStat = EventStat()
            self._VulLowStat._deserialize(params.get("VulLowStat"))
        if params.get("BaselineHighStat") is not None:
            self._BaselineHighStat = EventStat()
            self._BaselineHighStat._deserialize(params.get("BaselineHighStat"))
        if params.get("BaselineNormalStat") is not None:
            self._BaselineNormalStat = EventStat()
            self._BaselineNormalStat._deserialize(params.get("BaselineNormalStat"))
        if params.get("BaselineLowStat") is not None:
            self._BaselineLowStat = EventStat()
            self._BaselineLowStat._deserialize(params.get("BaselineLowStat"))
        self._MachineTotalAffectNum = params.get("MachineTotalAffectNum")
        self._InvasionTotalAffectNum = params.get("InvasionTotalAffectNum")
        self._VulTotalAffectNum = params.get("VulTotalAffectNum")
        self._BaseLineTotalAffectNum = params.get("BaseLineTotalAffectNum")
        self._CyberAttackTotalAffectNum = params.get("CyberAttackTotalAffectNum")
        if params.get("VulRiskStat") is not None:
            self._VulRiskStat = EventStat()
            self._VulRiskStat._deserialize(params.get("VulRiskStat"))
        if params.get("BaselineRiskStat") is not None:
            self._BaselineRiskStat = EventStat()
            self._BaselineRiskStat._deserialize(params.get("BaselineRiskStat"))
        if params.get("VulStat") is not None:
            self._VulStat = EventStat()
            self._VulStat._deserialize(params.get("VulStat"))
        self._Score = params.get("Score")
        self._RequestId = params.get("RequestId")


class DescribeSecurityEventsCntRequest(AbstractModel):
    """DescribeSecurityEventsCnt请求参数结构体

    """


class DescribeSecurityEventsCntResponse(AbstractModel):
    """DescribeSecurityEventsCnt返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Malware: 木马文件相关风险事件
        :type Malware: :class:`tencentcloud.cwp.v20180228.models.SecurityEventInfo`
        :param _HostLogin: 登录审计相关风险事件
        :type HostLogin: :class:`tencentcloud.cwp.v20180228.models.SecurityEventInfo`
        :param _BruteAttack: 密码破解相关风险事件
        :type BruteAttack: :class:`tencentcloud.cwp.v20180228.models.SecurityEventInfo`
        :param _RiskDns: 恶意请求相关风险事件
        :type RiskDns: :class:`tencentcloud.cwp.v20180228.models.SecurityEventInfo`
        :param _Bash: 高危命令相关风险事件
        :type Bash: :class:`tencentcloud.cwp.v20180228.models.SecurityEventInfo`
        :param _PrivilegeRules: 本地提权相关风险事件
        :type PrivilegeRules: :class:`tencentcloud.cwp.v20180228.models.SecurityEventInfo`
        :param _ReverseShell: 反弹Shell相关风险事件
        :type ReverseShell: :class:`tencentcloud.cwp.v20180228.models.SecurityEventInfo`
        :param _SysVul: 应用漏洞风险事件
        :type SysVul: :class:`tencentcloud.cwp.v20180228.models.SecurityEventInfo`
        :param _WebVul: Web应用漏洞相关风险事件
        :type WebVul: :class:`tencentcloud.cwp.v20180228.models.SecurityEventInfo`
        :param _EmergencyVul: 应急漏洞相关风险事件
        :type EmergencyVul: :class:`tencentcloud.cwp.v20180228.models.SecurityEventInfo`
        :param _BaseLine: 安全基线相关风险事件
        :type BaseLine: :class:`tencentcloud.cwp.v20180228.models.SecurityEventInfo`
        :param _AttackLogs: 攻击检测相关风险事件
        :type AttackLogs: :class:`tencentcloud.cwp.v20180228.models.SecurityEventInfo`
        :param _EffectMachineCount: 受影响机器数
        :type EffectMachineCount: int
        :param _EventsCount: 所有事件总数
        :type EventsCount: int
        :param _WindowVul: window 系统漏洞事件总数
注意：此字段可能返回 null，表示取不到有效值。
        :type WindowVul: :class:`tencentcloud.cwp.v20180228.models.SecurityEventInfo`
        :param _LinuxVul: linux系统漏洞事件总数
注意：此字段可能返回 null，表示取不到有效值。
        :type LinuxVul: :class:`tencentcloud.cwp.v20180228.models.SecurityEventInfo`
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Malware = None
        self._HostLogin = None
        self._BruteAttack = None
        self._RiskDns = None
        self._Bash = None
        self._PrivilegeRules = None
        self._ReverseShell = None
        self._SysVul = None
        self._WebVul = None
        self._EmergencyVul = None
        self._BaseLine = None
        self._AttackLogs = None
        self._EffectMachineCount = None
        self._EventsCount = None
        self._WindowVul = None
        self._LinuxVul = None
        self._RequestId = None

    @property
    def Malware(self):
        return self._Malware

    @Malware.setter
    def Malware(self, Malware):
        self._Malware = Malware

    @property
    def HostLogin(self):
        return self._HostLogin

    @HostLogin.setter
    def HostLogin(self, HostLogin):
        self._HostLogin = HostLogin

    @property
    def BruteAttack(self):
        return self._BruteAttack

    @BruteAttack.setter
    def BruteAttack(self, BruteAttack):
        self._BruteAttack = BruteAttack

    @property
    def RiskDns(self):
        return self._RiskDns

    @RiskDns.setter
    def RiskDns(self, RiskDns):
        self._RiskDns = RiskDns

    @property
    def Bash(self):
        return self._Bash

    @Bash.setter
    def Bash(self, Bash):
        self._Bash = Bash

    @property
    def PrivilegeRules(self):
        return self._PrivilegeRules

    @PrivilegeRules.setter
    def PrivilegeRules(self, PrivilegeRules):
        self._PrivilegeRules = PrivilegeRules

    @property
    def ReverseShell(self):
        return self._ReverseShell

    @ReverseShell.setter
    def ReverseShell(self, ReverseShell):
        self._ReverseShell = ReverseShell

    @property
    def SysVul(self):
        return self._SysVul

    @SysVul.setter
    def SysVul(self, SysVul):
        self._SysVul = SysVul

    @property
    def WebVul(self):
        return self._WebVul

    @WebVul.setter
    def WebVul(self, WebVul):
        self._WebVul = WebVul

    @property
    def EmergencyVul(self):
        return self._EmergencyVul

    @EmergencyVul.setter
    def EmergencyVul(self, EmergencyVul):
        self._EmergencyVul = EmergencyVul

    @property
    def BaseLine(self):
        return self._BaseLine

    @BaseLine.setter
    def BaseLine(self, BaseLine):
        self._BaseLine = BaseLine

    @property
    def AttackLogs(self):
        return self._AttackLogs

    @AttackLogs.setter
    def AttackLogs(self, AttackLogs):
        self._AttackLogs = AttackLogs

    @property
    def EffectMachineCount(self):
        return self._EffectMachineCount

    @EffectMachineCount.setter
    def EffectMachineCount(self, EffectMachineCount):
        self._EffectMachineCount = EffectMachineCount

    @property
    def EventsCount(self):
        return self._EventsCount

    @EventsCount.setter
    def EventsCount(self, EventsCount):
        self._EventsCount = EventsCount

    @property
    def WindowVul(self):
        return self._WindowVul

    @WindowVul.setter
    def WindowVul(self, WindowVul):
        self._WindowVul = WindowVul

    @property
    def LinuxVul(self):
        return self._LinuxVul

    @LinuxVul.setter
    def LinuxVul(self, LinuxVul):
        self._LinuxVul = LinuxVul

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Malware") is not None:
            self._Malware = SecurityEventInfo()
            self._Malware._deserialize(params.get("Malware"))
        if params.get("HostLogin") is not None:
            self._HostLogin = SecurityEventInfo()
            self._HostLogin._deserialize(params.get("HostLogin"))
        if params.get("BruteAttack") is not None:
            self._BruteAttack = SecurityEventInfo()
            self._BruteAttack._deserialize(params.get("BruteAttack"))
        if params.get("RiskDns") is not None:
            self._RiskDns = SecurityEventInfo()
            self._RiskDns._deserialize(params.get("RiskDns"))
        if params.get("Bash") is not None:
            self._Bash = SecurityEventInfo()
            self._Bash._deserialize(params.get("Bash"))
        if params.get("PrivilegeRules") is not None:
            self._PrivilegeRules = SecurityEventInfo()
            self._PrivilegeRules._deserialize(params.get("PrivilegeRules"))
        if params.get("ReverseShell") is not None:
            self._ReverseShell = SecurityEventInfo()
            self._ReverseShell._deserialize(params.get("ReverseShell"))
        if params.get("SysVul") is not None:
            self._SysVul = SecurityEventInfo()
            self._SysVul._deserialize(params.get("SysVul"))
        if params.get("WebVul") is not None:
            self._WebVul = SecurityEventInfo()
            self._WebVul._deserialize(params.get("WebVul"))
        if params.get("EmergencyVul") is not None:
            self._EmergencyVul = SecurityEventInfo()
            self._EmergencyVul._deserialize(params.get("EmergencyVul"))
        if params.get("BaseLine") is not None:
            self._BaseLine = SecurityEventInfo()
            self._BaseLine._deserialize(params.get("BaseLine"))
        if params.get("AttackLogs") is not None:
            self._AttackLogs = SecurityEventInfo()
            self._AttackLogs._deserialize(params.get("AttackLogs"))
        self._EffectMachineCount = params.get("EffectMachineCount")
        self._EventsCount = params.get("EventsCount")
        if params.get("WindowVul") is not None:
            self._WindowVul = SecurityEventInfo()
            self._WindowVul._deserialize(params.get("WindowVul"))
        if params.get("LinuxVul") is not None:
            self._LinuxVul = SecurityEventInfo()
            self._LinuxVul._deserialize(params.get("LinuxVul"))
        self._RequestId = params.get("RequestId")


class DescribeSecurityTrendsRequest(AbstractModel):
    """DescribeSecurityTrends请求参数结构体

    """

    def __init__(self):
        r"""
        :param _BeginDate: 开始时间，如：2021-07-10
        :type BeginDate: str
        :param _EndDate: 结束时间，如：2021-07-10
        :type EndDate: str
        """
        self._BeginDate = None
        self._EndDate = None

    @property
    def BeginDate(self):
        return self._BeginDate

    @BeginDate.setter
    def BeginDate(self, BeginDate):
        self._BeginDate = BeginDate

    @property
    def EndDate(self):
        return self._EndDate

    @EndDate.setter
    def EndDate(self, EndDate):
        self._EndDate = EndDate


    def _deserialize(self, params):
        self._BeginDate = params.get("BeginDate")
        self._EndDate = params.get("EndDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSecurityTrendsResponse(AbstractModel):
    """DescribeSecurityTrends返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Malwares: 木马事件统计数据数组。
        :type Malwares: list of SecurityTrend
        :param _NonLocalLoginPlaces: 异地登录事件统计数据数组。
        :type NonLocalLoginPlaces: list of SecurityTrend
        :param _BruteAttacks: 密码破解事件统计数据数组。
        :type BruteAttacks: list of SecurityTrend
        :param _Vuls: 漏洞统计数据数组。
        :type Vuls: list of SecurityTrend
        :param _BaseLines: 基线统计数据数组。
        :type BaseLines: list of SecurityTrend
        :param _MaliciousRequests: 恶意请求统计数据数组。
        :type MaliciousRequests: list of SecurityTrend
        :param _HighRiskBashs: 高危命令统计数据数组。
        :type HighRiskBashs: list of SecurityTrend
        :param _ReverseShells: 反弹shell统计数据数组。
        :type ReverseShells: list of SecurityTrend
        :param _PrivilegeEscalations: 本地提权统计数据数组。
        :type PrivilegeEscalations: list of SecurityTrend
        :param _CyberAttacks: 网络攻击统计数据数组。
        :type CyberAttacks: list of SecurityTrend
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Malwares = None
        self._NonLocalLoginPlaces = None
        self._BruteAttacks = None
        self._Vuls = None
        self._BaseLines = None
        self._MaliciousRequests = None
        self._HighRiskBashs = None
        self._ReverseShells = None
        self._PrivilegeEscalations = None
        self._CyberAttacks = None
        self._RequestId = None

    @property
    def Malwares(self):
        return self._Malwares

    @Malwares.setter
    def Malwares(self, Malwares):
        self._Malwares = Malwares

    @property
    def NonLocalLoginPlaces(self):
        return self._NonLocalLoginPlaces

    @NonLocalLoginPlaces.setter
    def NonLocalLoginPlaces(self, NonLocalLoginPlaces):
        self._NonLocalLoginPlaces = NonLocalLoginPlaces

    @property
    def BruteAttacks(self):
        return self._BruteAttacks

    @BruteAttacks.setter
    def BruteAttacks(self, BruteAttacks):
        self._BruteAttacks = BruteAttacks

    @property
    def Vuls(self):
        return self._Vuls

    @Vuls.setter
    def Vuls(self, Vuls):
        self._Vuls = Vuls

    @property
    def BaseLines(self):
        return self._BaseLines

    @BaseLines.setter
    def BaseLines(self, BaseLines):
        self._BaseLines = BaseLines

    @property
    def MaliciousRequests(self):
        return self._MaliciousRequests

    @MaliciousRequests.setter
    def MaliciousRequests(self, MaliciousRequests):
        self._MaliciousRequests = MaliciousRequests

    @property
    def HighRiskBashs(self):
        return self._HighRiskBashs

    @HighRiskBashs.setter
    def HighRiskBashs(self, HighRiskBashs):
        self._HighRiskBashs = HighRiskBashs

    @property
    def ReverseShells(self):
        return self._ReverseShells

    @ReverseShells.setter
    def ReverseShells(self, ReverseShells):
        self._ReverseShells = ReverseShells

    @property
    def PrivilegeEscalations(self):
        return self._PrivilegeEscalations

    @PrivilegeEscalations.setter
    def PrivilegeEscalations(self, PrivilegeEscalations):
        self._PrivilegeEscalations = PrivilegeEscalations

    @property
    def CyberAttacks(self):
        return self._CyberAttacks

    @CyberAttacks.setter
    def CyberAttacks(self, CyberAttacks):
        self._CyberAttacks = CyberAttacks

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Malwares") is not None:
            self._Malwares = []
            for item in params.get("Malwares"):
                obj = SecurityTrend()
                obj._deserialize(item)
                self._Malwares.append(obj)
        if params.get("NonLocalLoginPlaces") is not None:
            self._NonLocalLoginPlaces = []
            for item in params.get("NonLocalLoginPlaces"):
                obj = SecurityTrend()
                obj._deserialize(item)
                self._NonLocalLoginPlaces.append(obj)
        if params.get("BruteAttacks") is not None:
            self._BruteAttacks = []
            for item in params.get("BruteAttacks"):
                obj = SecurityTrend()
                obj._deserialize(item)
                self._BruteAttacks.append(obj)
        if params.get("Vuls") is not None:
            self._Vuls = []
            for item in params.get("Vuls"):
                obj = SecurityTrend()
                obj._deserialize(item)
                self._Vuls.append(obj)
        if params.get("BaseLines") is not None:
            self._BaseLines = []
            for item in params.get("BaseLines"):
                obj = SecurityTrend()
                obj._deserialize(item)
                self._BaseLines.append(obj)
        if params.get("MaliciousRequests") is not None:
            self._MaliciousRequests = []
            for item in params.get("MaliciousRequests"):
                obj = SecurityTrend()
                obj._deserialize(item)
                self._MaliciousRequests.append(obj)
        if params.get("HighRiskBashs") is not None:
            self._HighRiskBashs = []
            for item in params.get("HighRiskBashs"):
                obj = SecurityTrend()
                obj._deserialize(item)
                self._HighRiskBashs.append(obj)
        if params.get("ReverseShells") is not None:
            self._ReverseShells = []
            for item in params.get("ReverseShells"):
                obj = SecurityTrend()
                obj._deserialize(item)
                self._ReverseShells.append(obj)
        if params.get("PrivilegeEscalations") is not None:
            self._PrivilegeEscalations = []
            for item in params.get("PrivilegeEscalations"):
                obj = SecurityTrend()
                obj._deserialize(item)
                self._PrivilegeEscalations.append(obj)
        if params.get("CyberAttacks") is not None:
            self._CyberAttacks = []
            for item in params.get("CyberAttacks"):
                obj = SecurityTrend()
                obj._deserialize(item)
                self._CyberAttacks.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeServerRelatedDirInfoRequest(AbstractModel):
    """DescribeServerRelatedDirInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 唯一ID
        :type Id: int
        """
        self._Id = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeServerRelatedDirInfoResponse(AbstractModel):
    """DescribeServerRelatedDirInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _HostName: 服务器名称
        :type HostName: str
        :param _HostIp: 服务器IP
        :type HostIp: str
        :param _ProtectDirNum: 防护目录数量
        :type ProtectDirNum: int
        :param _ProtectFileNum: 防护文件数量
        :type ProtectFileNum: int
        :param _ProtectTamperNum: 防篡改数量
        :type ProtectTamperNum: int
        :param _ProtectLinkNum: 防护软链数量
        :type ProtectLinkNum: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._HostName = None
        self._HostIp = None
        self._ProtectDirNum = None
        self._ProtectFileNum = None
        self._ProtectTamperNum = None
        self._ProtectLinkNum = None
        self._RequestId = None

    @property
    def HostName(self):
        return self._HostName

    @HostName.setter
    def HostName(self, HostName):
        self._HostName = HostName

    @property
    def HostIp(self):
        return self._HostIp

    @HostIp.setter
    def HostIp(self, HostIp):
        self._HostIp = HostIp

    @property
    def ProtectDirNum(self):
        return self._ProtectDirNum

    @ProtectDirNum.setter
    def ProtectDirNum(self, ProtectDirNum):
        self._ProtectDirNum = ProtectDirNum

    @property
    def ProtectFileNum(self):
        return self._ProtectFileNum

    @ProtectFileNum.setter
    def ProtectFileNum(self, ProtectFileNum):
        self._ProtectFileNum = ProtectFileNum

    @property
    def ProtectTamperNum(self):
        return self._ProtectTamperNum

    @ProtectTamperNum.setter
    def ProtectTamperNum(self, ProtectTamperNum):
        self._ProtectTamperNum = ProtectTamperNum

    @property
    def ProtectLinkNum(self):
        return self._ProtectLinkNum

    @ProtectLinkNum.setter
    def ProtectLinkNum(self, ProtectLinkNum):
        self._ProtectLinkNum = ProtectLinkNum

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._HostName = params.get("HostName")
        self._HostIp = params.get("HostIp")
        self._ProtectDirNum = params.get("ProtectDirNum")
        self._ProtectFileNum = params.get("ProtectFileNum")
        self._ProtectTamperNum = params.get("ProtectTamperNum")
        self._ProtectLinkNum = params.get("ProtectLinkNum")
        self._RequestId = params.get("RequestId")


class DescribeServersAndRiskAndFirstInfoRequest(AbstractModel):
    """DescribeServersAndRiskAndFirstInfo请求参数结构体

    """


class DescribeServersAndRiskAndFirstInfoResponse(AbstractModel):
    """DescribeServersAndRiskAndFirstInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RiskFileCount: 风险文件数
        :type RiskFileCount: int
        :param _AddRiskFileCount: 今日新增风险文件数
        :type AddRiskFileCount: int
        :param _ServersCount: 受影响服务器台数
        :type ServersCount: int
        :param _IsFirstCheck: 是否试用：true-是，false-否
        :type IsFirstCheck: bool
        :param _ScanTime: 木马最近检测时间
        :type ScanTime: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RiskFileCount = None
        self._AddRiskFileCount = None
        self._ServersCount = None
        self._IsFirstCheck = None
        self._ScanTime = None
        self._RequestId = None

    @property
    def RiskFileCount(self):
        return self._RiskFileCount

    @RiskFileCount.setter
    def RiskFileCount(self, RiskFileCount):
        self._RiskFileCount = RiskFileCount

    @property
    def AddRiskFileCount(self):
        return self._AddRiskFileCount

    @AddRiskFileCount.setter
    def AddRiskFileCount(self, AddRiskFileCount):
        self._AddRiskFileCount = AddRiskFileCount

    @property
    def ServersCount(self):
        return self._ServersCount

    @ServersCount.setter
    def ServersCount(self, ServersCount):
        self._ServersCount = ServersCount

    @property
    def IsFirstCheck(self):
        return self._IsFirstCheck

    @IsFirstCheck.setter
    def IsFirstCheck(self, IsFirstCheck):
        self._IsFirstCheck = IsFirstCheck

    @property
    def ScanTime(self):
        return self._ScanTime

    @ScanTime.setter
    def ScanTime(self, ScanTime):
        self._ScanTime = ScanTime

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RiskFileCount = params.get("RiskFileCount")
        self._AddRiskFileCount = params.get("AddRiskFileCount")
        self._ServersCount = params.get("ServersCount")
        self._IsFirstCheck = params.get("IsFirstCheck")
        self._ScanTime = params.get("ScanTime")
        self._RequestId = params.get("RequestId")


class DescribeStrategyExistRequest(AbstractModel):
    """DescribeStrategyExist请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StrategyName: 策略名
        :type StrategyName: str
        """
        self._StrategyName = None

    @property
    def StrategyName(self):
        return self._StrategyName

    @StrategyName.setter
    def StrategyName(self, StrategyName):
        self._StrategyName = StrategyName


    def _deserialize(self, params):
        self._StrategyName = params.get("StrategyName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeStrategyExistResponse(AbstractModel):
    """DescribeStrategyExist返回参数结构体

    """

    def __init__(self):
        r"""
        :param _IfExist: 策略是否存在, 1是 0否
注意：此字段可能返回 null，表示取不到有效值。
        :type IfExist: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._IfExist = None
        self._RequestId = None

    @property
    def IfExist(self):
        return self._IfExist

    @IfExist.setter
    def IfExist(self, IfExist):
        self._IfExist = IfExist

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._IfExist = params.get("IfExist")
        self._RequestId = params.get("RequestId")


class DescribeTagMachinesRequest(AbstractModel):
    """DescribeTagMachines请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 标签ID
        :type Id: int
        """
        self._Id = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTagMachinesResponse(AbstractModel):
    """DescribeTagMachines返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 列表数据
        :type List: list of TagMachine
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = TagMachine()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTagsRequest(AbstractModel):
    """DescribeTags请求参数结构体

    """

    def __init__(self):
        r"""
        :param _MachineType: 云主机类型。
<li>CVM：表示云服务器</li>
<li>BM:  表示黑石物理机</li>
<li>ECM:  表示边缘计算服务器</li>
<li>LH:  表示轻量应用服务器</li>
<li>Other:  表示混合云服务器</li>
        :type MachineType: str
        :param _MachineRegion: 机器所属地域。如：ap-guangzhou
        :type MachineRegion: str
        :param _Filters: 过滤条件。
<li>Keywords - String - 是否必填：否 - 查询关键字(机器名称/机器IP </li>
<li>Status - String - 是否必填：否 - 客户端在线状态（OFFLINE: 离线 | ONLINE: 在线 | UNINSTALLED：未安装 | SHUTDOWN 已关机）</li>
<li>Version - String  是否必填：否 - 当前防护版本（ PRO_VERSION：专业版 | BASIC_VERSION：基础版）</li>
<li>Risk - String 是否必填: 否 - 风险主机( yes ) </li>
<li>Os -String 是否必填: 否 - 操作系统( DescribeMachineOsList 接口 值 )
每个过滤条件只支持一个值，暂不支持多个值“或”关系查询</li>
        :type Filters: list of Filters
        """
        self._MachineType = None
        self._MachineRegion = None
        self._Filters = None

    @property
    def MachineType(self):
        return self._MachineType

    @MachineType.setter
    def MachineType(self, MachineType):
        self._MachineType = MachineType

    @property
    def MachineRegion(self):
        return self._MachineRegion

    @MachineRegion.setter
    def MachineRegion(self, MachineRegion):
        self._MachineRegion = MachineRegion

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._MachineType = params.get("MachineType")
        self._MachineRegion = params.get("MachineRegion")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTagsResponse(AbstractModel):
    """DescribeTags返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 列表信息
        :type List: list of Tag
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = Tag()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeUndoVulCountsRequest(AbstractModel):
    """DescribeUndoVulCounts请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VulCategory: 漏洞分类，1: web-cms漏洞 2:应用漏洞  4: Linux软件漏洞 5: Windows系统漏洞
        :type VulCategory: int
        :param _IfEmergency: 是否应急漏洞筛选, 是 : yes
        :type IfEmergency: str
        """
        self._VulCategory = None
        self._IfEmergency = None

    @property
    def VulCategory(self):
        return self._VulCategory

    @VulCategory.setter
    def VulCategory(self, VulCategory):
        self._VulCategory = VulCategory

    @property
    def IfEmergency(self):
        return self._IfEmergency

    @IfEmergency.setter
    def IfEmergency(self, IfEmergency):
        self._IfEmergency = IfEmergency


    def _deserialize(self, params):
        self._VulCategory = params.get("VulCategory")
        self._IfEmergency = params.get("IfEmergency")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeUndoVulCountsResponse(AbstractModel):
    """DescribeUndoVulCounts返回参数结构体

    """

    def __init__(self):
        r"""
        :param _UndoVulCount: 未处理的漏洞数
注意：此字段可能返回 null，表示取不到有效值。
        :type UndoVulCount: int
        :param _UndoHostCount: 未处理的主机数
注意：此字段可能返回 null，表示取不到有效值。
        :type UndoHostCount: int
        :param _NotProfessionCount: 普通版主机数
注意：此字段可能返回 null，表示取不到有效值。
        :type NotProfessionCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._UndoVulCount = None
        self._UndoHostCount = None
        self._NotProfessionCount = None
        self._RequestId = None

    @property
    def UndoVulCount(self):
        return self._UndoVulCount

    @UndoVulCount.setter
    def UndoVulCount(self, UndoVulCount):
        self._UndoVulCount = UndoVulCount

    @property
    def UndoHostCount(self):
        return self._UndoHostCount

    @UndoHostCount.setter
    def UndoHostCount(self, UndoHostCount):
        self._UndoHostCount = UndoHostCount

    @property
    def NotProfessionCount(self):
        return self._NotProfessionCount

    @NotProfessionCount.setter
    def NotProfessionCount(self, NotProfessionCount):
        self._NotProfessionCount = NotProfessionCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._UndoVulCount = params.get("UndoVulCount")
        self._UndoHostCount = params.get("UndoHostCount")
        self._NotProfessionCount = params.get("NotProfessionCount")
        self._RequestId = params.get("RequestId")


class DescribeUsualLoginPlacesRequest(AbstractModel):
    """DescribeUsualLoginPlaces请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Uuid: 主机安全客户端UUID
        :type Uuid: str
        """
        self._Uuid = None

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid


    def _deserialize(self, params):
        self._Uuid = params.get("Uuid")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeUsualLoginPlacesResponse(AbstractModel):
    """DescribeUsualLoginPlaces返回参数结构体

    """

    def __init__(self):
        r"""
        :param _UsualLoginPlaces: 常用登录地数组
        :type UsualLoginPlaces: list of UsualPlace
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._UsualLoginPlaces = None
        self._RequestId = None

    @property
    def UsualLoginPlaces(self):
        return self._UsualLoginPlaces

    @UsualLoginPlaces.setter
    def UsualLoginPlaces(self, UsualLoginPlaces):
        self._UsualLoginPlaces = UsualLoginPlaces

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("UsualLoginPlaces") is not None:
            self._UsualLoginPlaces = []
            for item in params.get("UsualLoginPlaces"):
                obj = UsualPlace()
                obj._deserialize(item)
                self._UsualLoginPlaces.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeVersionStatisticsRequest(AbstractModel):
    """DescribeVersionStatistics请求参数结构体

    """


class DescribeVersionStatisticsResponse(AbstractModel):
    """DescribeVersionStatistics返回参数结构体

    """

    def __init__(self):
        r"""
        :param _BasicVersionNum: 基础版数量
        :type BasicVersionNum: int
        :param _ProVersionNum: 专业版数量
        :type ProVersionNum: int
        :param _UltimateVersionNum: 旗舰版数量
        :type UltimateVersionNum: int
        :param _GeneralVersionNum: 普惠版数量
        :type GeneralVersionNum: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._BasicVersionNum = None
        self._ProVersionNum = None
        self._UltimateVersionNum = None
        self._GeneralVersionNum = None
        self._RequestId = None

    @property
    def BasicVersionNum(self):
        return self._BasicVersionNum

    @BasicVersionNum.setter
    def BasicVersionNum(self, BasicVersionNum):
        self._BasicVersionNum = BasicVersionNum

    @property
    def ProVersionNum(self):
        return self._ProVersionNum

    @ProVersionNum.setter
    def ProVersionNum(self, ProVersionNum):
        self._ProVersionNum = ProVersionNum

    @property
    def UltimateVersionNum(self):
        return self._UltimateVersionNum

    @UltimateVersionNum.setter
    def UltimateVersionNum(self, UltimateVersionNum):
        self._UltimateVersionNum = UltimateVersionNum

    @property
    def GeneralVersionNum(self):
        return self._GeneralVersionNum

    @GeneralVersionNum.setter
    def GeneralVersionNum(self, GeneralVersionNum):
        self._GeneralVersionNum = GeneralVersionNum

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._BasicVersionNum = params.get("BasicVersionNum")
        self._ProVersionNum = params.get("ProVersionNum")
        self._UltimateVersionNum = params.get("UltimateVersionNum")
        self._GeneralVersionNum = params.get("GeneralVersionNum")
        self._RequestId = params.get("RequestId")


class DescribeVertexDetailRequest(AbstractModel):
    """DescribeVertexDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VertexIds: 点id列表
        :type VertexIds: list of str
        :param _IncidentId: 事件id
        :type IncidentId: str
        :param _TableName: 事件所在表名
        :type TableName: str
        """
        self._VertexIds = None
        self._IncidentId = None
        self._TableName = None

    @property
    def VertexIds(self):
        return self._VertexIds

    @VertexIds.setter
    def VertexIds(self, VertexIds):
        self._VertexIds = VertexIds

    @property
    def IncidentId(self):
        return self._IncidentId

    @IncidentId.setter
    def IncidentId(self, IncidentId):
        self._IncidentId = IncidentId

    @property
    def TableName(self):
        return self._TableName

    @TableName.setter
    def TableName(self, TableName):
        self._TableName = TableName


    def _deserialize(self, params):
        self._VertexIds = params.get("VertexIds")
        self._IncidentId = params.get("IncidentId")
        self._TableName = params.get("TableName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVertexDetailResponse(AbstractModel):
    """DescribeVertexDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _VertexDetails: 指定点列表的属性信息
注意：此字段可能返回 null，表示取不到有效值。
        :type VertexDetails: list of VertexDetail
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._VertexDetails = None
        self._RequestId = None

    @property
    def VertexDetails(self):
        return self._VertexDetails

    @VertexDetails.setter
    def VertexDetails(self, VertexDetails):
        self._VertexDetails = VertexDetails

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("VertexDetails") is not None:
            self._VertexDetails = []
            for item in params.get("VertexDetails"):
                obj = VertexDetail()
                obj._deserialize(item)
                self._VertexDetails.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeVulCountByDatesRequest(AbstractModel):
    """DescribeVulCountByDates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _LastDays: 需要查询最近几天的数据，需要都 -1后传入
        :type LastDays: list of int non-negative
        :param _VulCategory: 漏洞的分类: 1: web-cms漏洞 2:应用漏洞  4: Linux软件漏洞 5: Windows系统漏洞
        :type VulCategory: int
        :param _IfEmergency: 是否为应急漏洞筛选  是: yes
        :type IfEmergency: str
        """
        self._LastDays = None
        self._VulCategory = None
        self._IfEmergency = None

    @property
    def LastDays(self):
        return self._LastDays

    @LastDays.setter
    def LastDays(self, LastDays):
        self._LastDays = LastDays

    @property
    def VulCategory(self):
        return self._VulCategory

    @VulCategory.setter
    def VulCategory(self, VulCategory):
        self._VulCategory = VulCategory

    @property
    def IfEmergency(self):
        return self._IfEmergency

    @IfEmergency.setter
    def IfEmergency(self, IfEmergency):
        self._IfEmergency = IfEmergency


    def _deserialize(self, params):
        self._LastDays = params.get("LastDays")
        self._VulCategory = params.get("VulCategory")
        self._IfEmergency = params.get("IfEmergency")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVulCountByDatesResponse(AbstractModel):
    """DescribeVulCountByDates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _VulCount: 批量获得对应天数的漏洞数量
注意：此字段可能返回 null，表示取不到有效值。
        :type VulCount: list of int non-negative
        :param _HostCount: 批量获得对应天数的主机数量
        :type HostCount: list of int non-negative
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._VulCount = None
        self._HostCount = None
        self._RequestId = None

    @property
    def VulCount(self):
        return self._VulCount

    @VulCount.setter
    def VulCount(self, VulCount):
        self._VulCount = VulCount

    @property
    def HostCount(self):
        return self._HostCount

    @HostCount.setter
    def HostCount(self, HostCount):
        self._HostCount = HostCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._VulCount = params.get("VulCount")
        self._HostCount = params.get("HostCount")
        self._RequestId = params.get("RequestId")


class DescribeVulEffectHostListRequest(AbstractModel):
    """DescribeVulEffectHostList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 分页limit 最大100
        :type Limit: int
        :param _Offset: 分页Offset
        :type Offset: int
        :param _VulId: 漏洞id
        :type VulId: int
        :param _Filters: 过滤条件：
<li>AliasName - String - 主机名筛选</li>
<li>TagIds - String - 主机标签id串，多个用英文用逗号分隔</li>
<li>Status - String - 状态：0-待处理 1-忽略  3-已修复  5-检测中  6-修复中  8-修复失败</li>
<li>Uuid - String数组 - Uuid串数组</li>
<li>Version - String数组 - 付费版本数组："Flagship"-旗舰版 "PRO_VERSION"-专业版 "BASIC_VERSION"-基础版</li>
<li>InstanceState - String数组 - 实例状态数组："PENDING"-创建中 "LAUNCH_FAILED"-创建失败 "RUNNING"-运行中 "STOPPED"-关机 "STARTING"-开机中 "STOPPING"-关机中 "REBOOTING"-重启中 "SHUTDOWN"-待销毁 "TERMINATING"-销毁中 "UNKNOWN"-未知（针对非腾讯云机器，且客户端离线的场景） </li>
        :type Filters: list of Filter
        """
        self._Limit = None
        self._Offset = None
        self._VulId = None
        self._Filters = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def VulId(self):
        return self._VulId

    @VulId.setter
    def VulId(self, VulId):
        self._VulId = VulId

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._VulId = params.get("VulId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVulEffectHostListResponse(AbstractModel):
    """DescribeVulEffectHostList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 列表总数量
        :type TotalCount: int
        :param _VulEffectHostList: 影响主机列表
注意：此字段可能返回 null，表示取不到有效值。
        :type VulEffectHostList: list of VulEffectHostList
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._VulEffectHostList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def VulEffectHostList(self):
        return self._VulEffectHostList

    @VulEffectHostList.setter
    def VulEffectHostList(self, VulEffectHostList):
        self._VulEffectHostList = VulEffectHostList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("VulEffectHostList") is not None:
            self._VulEffectHostList = []
            for item in params.get("VulEffectHostList"):
                obj = VulEffectHostList()
                obj._deserialize(item)
                self._VulEffectHostList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeVulHostCountScanTimeRequest(AbstractModel):
    """DescribeVulHostCountScanTime请求参数结构体

    """


class DescribeVulHostCountScanTimeResponse(AbstractModel):
    """DescribeVulHostCountScanTime返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalVulCount: 总漏洞数
        :type TotalVulCount: int
        :param _VulHostCount: 漏洞影响主机数
        :type VulHostCount: int
        :param _ScanTime: 扫描时间
        :type ScanTime: str
        :param _IfFirstScan: 是否第一次检测
        :type IfFirstScan: bool
        :param _TaskId: 运行中的任务号, 没有任务则为0
        :type TaskId: int
        :param _LastFixTime: 最后一次修复漏洞的时间
        :type LastFixTime: str
        :param _hadAutoFixVul: 是否有支持自动修复的漏洞事件
        :type hadAutoFixVul: bool
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalVulCount = None
        self._VulHostCount = None
        self._ScanTime = None
        self._IfFirstScan = None
        self._TaskId = None
        self._LastFixTime = None
        self._hadAutoFixVul = None
        self._RequestId = None

    @property
    def TotalVulCount(self):
        return self._TotalVulCount

    @TotalVulCount.setter
    def TotalVulCount(self, TotalVulCount):
        self._TotalVulCount = TotalVulCount

    @property
    def VulHostCount(self):
        return self._VulHostCount

    @VulHostCount.setter
    def VulHostCount(self, VulHostCount):
        self._VulHostCount = VulHostCount

    @property
    def ScanTime(self):
        return self._ScanTime

    @ScanTime.setter
    def ScanTime(self, ScanTime):
        self._ScanTime = ScanTime

    @property
    def IfFirstScan(self):
        return self._IfFirstScan

    @IfFirstScan.setter
    def IfFirstScan(self, IfFirstScan):
        self._IfFirstScan = IfFirstScan

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def LastFixTime(self):
        return self._LastFixTime

    @LastFixTime.setter
    def LastFixTime(self, LastFixTime):
        self._LastFixTime = LastFixTime

    @property
    def hadAutoFixVul(self):
        return self._hadAutoFixVul

    @hadAutoFixVul.setter
    def hadAutoFixVul(self, hadAutoFixVul):
        self._hadAutoFixVul = hadAutoFixVul

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalVulCount = params.get("TotalVulCount")
        self._VulHostCount = params.get("VulHostCount")
        self._ScanTime = params.get("ScanTime")
        self._IfFirstScan = params.get("IfFirstScan")
        self._TaskId = params.get("TaskId")
        self._LastFixTime = params.get("LastFixTime")
        self._hadAutoFixVul = params.get("hadAutoFixVul")
        self._RequestId = params.get("RequestId")


class DescribeVulHostTopRequest(AbstractModel):
    """DescribeVulHostTop请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Top: 获取top值，1-100
        :type Top: int
        :param _VulCategory: 1:web-cms 漏洞，2.应用漏洞   4: Linux软件漏洞 5: windows系统漏洞 6:应急漏洞，不填或者填0时返回 1，2，4，5 的总统计数据
        :type VulCategory: int
        :param _IsFollowVul: 是否仅统计重点关注漏洞 1=仅统计重点关注漏洞, 0=统计全部漏洞
        :type IsFollowVul: int
        """
        self._Top = None
        self._VulCategory = None
        self._IsFollowVul = None

    @property
    def Top(self):
        return self._Top

    @Top.setter
    def Top(self, Top):
        self._Top = Top

    @property
    def VulCategory(self):
        return self._VulCategory

    @VulCategory.setter
    def VulCategory(self, VulCategory):
        self._VulCategory = VulCategory

    @property
    def IsFollowVul(self):
        return self._IsFollowVul

    @IsFollowVul.setter
    def IsFollowVul(self, IsFollowVul):
        self._IsFollowVul = IsFollowVul


    def _deserialize(self, params):
        self._Top = params.get("Top")
        self._VulCategory = params.get("VulCategory")
        self._IsFollowVul = params.get("IsFollowVul")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVulHostTopResponse(AbstractModel):
    """DescribeVulHostTop返回参数结构体

    """

    def __init__(self):
        r"""
        :param _VulHostTopList: 服务器风险top列表
注意：此字段可能返回 null，表示取不到有效值。
        :type VulHostTopList: list of VulHostTopInfo
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._VulHostTopList = None
        self._RequestId = None

    @property
    def VulHostTopList(self):
        return self._VulHostTopList

    @VulHostTopList.setter
    def VulHostTopList(self, VulHostTopList):
        self._VulHostTopList = VulHostTopList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("VulHostTopList") is not None:
            self._VulHostTopList = []
            for item in params.get("VulHostTopList"):
                obj = VulHostTopInfo()
                obj._deserialize(item)
                self._VulHostTopList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeVulInfoCvssRequest(AbstractModel):
    """DescribeVulInfoCvss请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VulId: 漏洞id
        :type VulId: int
        """
        self._VulId = None

    @property
    def VulId(self):
        return self._VulId

    @VulId.setter
    def VulId(self, VulId):
        self._VulId = VulId


    def _deserialize(self, params):
        self._VulId = params.get("VulId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVulInfoCvssResponse(AbstractModel):
    """DescribeVulInfoCvss返回参数结构体

    """

    def __init__(self):
        r"""
        :param _VulId: 漏洞id
注意：此字段可能返回 null，表示取不到有效值。
        :type VulId: int
        :param _VulName: 漏洞名称
注意：此字段可能返回 null，表示取不到有效值。
        :type VulName: str
        :param _VulLevel: 危害等级：1-低危；2-中危；3-高危；4-严重
注意：此字段可能返回 null，表示取不到有效值。
        :type VulLevel: int
        :param _VulType: 漏洞分类 1: web-cms漏洞 2:应用漏洞  4: Linux软件漏洞 5: Windows系统漏洞
注意：此字段可能返回 null，表示取不到有效值。
        :type VulType: int
        :param _Description: 漏洞描述信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Description: str
        :param _RepairPlan: 修复方案
注意：此字段可能返回 null，表示取不到有效值。
        :type RepairPlan: str
        :param _CveId: 漏洞CVEID
注意：此字段可能返回 null，表示取不到有效值。
        :type CveId: str
        :param _Reference: 参考链接
注意：此字段可能返回 null，表示取不到有效值。
        :type Reference: str
        :param _CVSS: CVSS信息
注意：此字段可能返回 null，表示取不到有效值。
        :type CVSS: str
        :param _PublicDate: 发布时间
注意：此字段可能返回 null，表示取不到有效值。
        :type PublicDate: str
        :param _CvssScore: Cvss分数
注意：此字段可能返回 null，表示取不到有效值。
        :type CvssScore: int
        :param _CveInfo: cvss详情
注意：此字段可能返回 null，表示取不到有效值。
        :type CveInfo: str
        :param _CvssScoreFloat: cvss 分数 浮点型
注意：此字段可能返回 null，表示取不到有效值。
        :type CvssScoreFloat: float
        :param _Labels: 漏洞标签 多个逗号分割
注意：此字段可能返回 null，表示取不到有效值。
        :type Labels: str
        :param _DefenseAttackCount: 已防御的攻击次数
注意：此字段可能返回 null，表示取不到有效值。
        :type DefenseAttackCount: int
        :param _SuccessFixCount: 全网修复成功次数, 不支持自动修复的漏洞默认返回0
注意：此字段可能返回 null，表示取不到有效值。
        :type SuccessFixCount: int
        :param _FixSwitch: 修复是否支持：0-windows/linux均不支持修复 ;1-windows/linux 均支持修复 ;2-仅linux支持修复;3-仅windows支持修复
注意：此字段可能返回 null，表示取不到有效值。
        :type FixSwitch: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._VulId = None
        self._VulName = None
        self._VulLevel = None
        self._VulType = None
        self._Description = None
        self._RepairPlan = None
        self._CveId = None
        self._Reference = None
        self._CVSS = None
        self._PublicDate = None
        self._CvssScore = None
        self._CveInfo = None
        self._CvssScoreFloat = None
        self._Labels = None
        self._DefenseAttackCount = None
        self._SuccessFixCount = None
        self._FixSwitch = None
        self._RequestId = None

    @property
    def VulId(self):
        return self._VulId

    @VulId.setter
    def VulId(self, VulId):
        self._VulId = VulId

    @property
    def VulName(self):
        return self._VulName

    @VulName.setter
    def VulName(self, VulName):
        self._VulName = VulName

    @property
    def VulLevel(self):
        return self._VulLevel

    @VulLevel.setter
    def VulLevel(self, VulLevel):
        self._VulLevel = VulLevel

    @property
    def VulType(self):
        return self._VulType

    @VulType.setter
    def VulType(self, VulType):
        self._VulType = VulType

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def RepairPlan(self):
        return self._RepairPlan

    @RepairPlan.setter
    def RepairPlan(self, RepairPlan):
        self._RepairPlan = RepairPlan

    @property
    def CveId(self):
        return self._CveId

    @CveId.setter
    def CveId(self, CveId):
        self._CveId = CveId

    @property
    def Reference(self):
        return self._Reference

    @Reference.setter
    def Reference(self, Reference):
        self._Reference = Reference

    @property
    def CVSS(self):
        return self._CVSS

    @CVSS.setter
    def CVSS(self, CVSS):
        self._CVSS = CVSS

    @property
    def PublicDate(self):
        return self._PublicDate

    @PublicDate.setter
    def PublicDate(self, PublicDate):
        self._PublicDate = PublicDate

    @property
    def CvssScore(self):
        return self._CvssScore

    @CvssScore.setter
    def CvssScore(self, CvssScore):
        self._CvssScore = CvssScore

    @property
    def CveInfo(self):
        return self._CveInfo

    @CveInfo.setter
    def CveInfo(self, CveInfo):
        self._CveInfo = CveInfo

    @property
    def CvssScoreFloat(self):
        return self._CvssScoreFloat

    @CvssScoreFloat.setter
    def CvssScoreFloat(self, CvssScoreFloat):
        self._CvssScoreFloat = CvssScoreFloat

    @property
    def Labels(self):
        return self._Labels

    @Labels.setter
    def Labels(self, Labels):
        self._Labels = Labels

    @property
    def DefenseAttackCount(self):
        return self._DefenseAttackCount

    @DefenseAttackCount.setter
    def DefenseAttackCount(self, DefenseAttackCount):
        self._DefenseAttackCount = DefenseAttackCount

    @property
    def SuccessFixCount(self):
        return self._SuccessFixCount

    @SuccessFixCount.setter
    def SuccessFixCount(self, SuccessFixCount):
        self._SuccessFixCount = SuccessFixCount

    @property
    def FixSwitch(self):
        return self._FixSwitch

    @FixSwitch.setter
    def FixSwitch(self, FixSwitch):
        self._FixSwitch = FixSwitch

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._VulId = params.get("VulId")
        self._VulName = params.get("VulName")
        self._VulLevel = params.get("VulLevel")
        self._VulType = params.get("VulType")
        self._Description = params.get("Description")
        self._RepairPlan = params.get("RepairPlan")
        self._CveId = params.get("CveId")
        self._Reference = params.get("Reference")
        self._CVSS = params.get("CVSS")
        self._PublicDate = params.get("PublicDate")
        self._CvssScore = params.get("CvssScore")
        self._CveInfo = params.get("CveInfo")
        self._CvssScoreFloat = params.get("CvssScoreFloat")
        self._Labels = params.get("Labels")
        self._DefenseAttackCount = params.get("DefenseAttackCount")
        self._SuccessFixCount = params.get("SuccessFixCount")
        self._FixSwitch = params.get("FixSwitch")
        self._RequestId = params.get("RequestId")


class DescribeVulLevelCountRequest(AbstractModel):
    """DescribeVulLevelCount请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VulCategory: 1:web-cms 漏洞，2.应用漏洞 3:安全基线 4: Linux软件漏洞 5: windows系统漏洞 6:应急漏洞，不填或者填0时返回 1，2，4，5 的总统计数据
        :type VulCategory: int
        :param _IsFollowVul: 是否仅统计重点关注漏洞 1=仅统计重点关注漏洞, 0=统计全部漏洞
        :type IsFollowVul: int
        """
        self._VulCategory = None
        self._IsFollowVul = None

    @property
    def VulCategory(self):
        return self._VulCategory

    @VulCategory.setter
    def VulCategory(self, VulCategory):
        self._VulCategory = VulCategory

    @property
    def IsFollowVul(self):
        return self._IsFollowVul

    @IsFollowVul.setter
    def IsFollowVul(self, IsFollowVul):
        self._IsFollowVul = IsFollowVul


    def _deserialize(self, params):
        self._VulCategory = params.get("VulCategory")
        self._IsFollowVul = params.get("IsFollowVul")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVulLevelCountResponse(AbstractModel):
    """DescribeVulLevelCount返回参数结构体

    """

    def __init__(self):
        r"""
        :param _VulLevelList: 统计结果
注意：此字段可能返回 null，表示取不到有效值。
        :type VulLevelList: list of VulLevelInfo
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._VulLevelList = None
        self._RequestId = None

    @property
    def VulLevelList(self):
        return self._VulLevelList

    @VulLevelList.setter
    def VulLevelList(self, VulLevelList):
        self._VulLevelList = VulLevelList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("VulLevelList") is not None:
            self._VulLevelList = []
            for item in params.get("VulLevelList"):
                obj = VulLevelInfo()
                obj._deserialize(item)
                self._VulLevelList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeVulListRequest(AbstractModel):
    """DescribeVulList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 返回数量，最大值为100。
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Filters: 过滤条件。
<li>Status - String - 是否必填：否 - 处理状态  0 -- 待处理 1 -- 已加白 2 -- 已删除 3 - 已忽略</li>
<li>ModifyTime - String - 是否必填：否 - 最近发生时间</li>
<li>Uuid- String - 是否必填：否 - 主机uuid查询</li>
<li>VulName- string -</li>
<li>VulCategory- string - 是否必填：否 - 漏洞类别 1: web-cms漏洞 2:应用漏洞  4: Linux软件漏洞 5: Windows系统漏洞</li>
<li>IsSupportDefense - int- 是否必填：否 - 是否支持防御 0:不支持 1:支持</li>
<li>Labels- string- 是否必填：否 - 标签搜索</li>
<li>IsSupportAutoFix- string- 是否必填：否 - 是否支持自动修复 0:不支持 1:支持</li>
<li>CvssScore- string- 是否必填：否 - CvssScore大于多少</li>
<li>AttackLevel- string- 是否必填：否 - 攻击热度大于多少</li>


        :type Filters: list of Filters
        :param _By: 可选排序字段 Level，LastTime，HostCount
        :type By: str
        :param _Order: 排序顺序：desc  默认asc
        :type Order: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._By = None
        self._Order = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVulListResponse(AbstractModel):
    """DescribeVulList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _VulInfoList: 漏洞列表
注意：此字段可能返回 null，表示取不到有效值。
        :type VulInfoList: list of VulInfoList
        :param _TotalCount: 漏洞总条数
注意：此字段可能返回 null，表示取不到有效值。
        :type TotalCount: int
        :param _FollowVulCount: 重点关注漏洞总数
注意：此字段可能返回 null，表示取不到有效值。
        :type FollowVulCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._VulInfoList = None
        self._TotalCount = None
        self._FollowVulCount = None
        self._RequestId = None

    @property
    def VulInfoList(self):
        return self._VulInfoList

    @VulInfoList.setter
    def VulInfoList(self, VulInfoList):
        self._VulInfoList = VulInfoList

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def FollowVulCount(self):
        return self._FollowVulCount

    @FollowVulCount.setter
    def FollowVulCount(self, FollowVulCount):
        self._FollowVulCount = FollowVulCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("VulInfoList") is not None:
            self._VulInfoList = []
            for item in params.get("VulInfoList"):
                obj = VulInfoList()
                obj._deserialize(item)
                self._VulInfoList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._FollowVulCount = params.get("FollowVulCount")
        self._RequestId = params.get("RequestId")


class DescribeVulStoreListRequest(AbstractModel):
    """DescribeVulStoreList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 
<li>VulName- string - 是否必填：否 - 漏洞名称</li>
<li>CveId- string - 是否必填：否 - cveid</li>
<li>VulCategory- string - 是否必填：否 - 漏洞分类  1 Web-CMS漏洞 ,2 应用漏洞 ,4 Linux软件漏洞,5 Windows系统漏洞</li>
<li>Method- string - 是否必填：否 - 检测方法 0版本对比,1 poc检测 </li>
<li>SupportDefense- string - 是否必填：否 - 是否支持防御 0不支持,1支持</li>
<li>FixSwitch- string - 是否必填：否 - 是否支持自动修复 0不支持,1支持</li>

        :type Filters: list of Filter
        :param _Limit: 限制条数,默认10,最大100
        :type Limit: int
        :param _Offset: 偏移量,默认0
        :type Offset: int
        :param _Order: 排序方式: [ASC:升序|DESC:降序]
        :type Order: str
        :param _By: 可选排序列: [PublishDate]
        :type By: str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVulStoreListResponse(AbstractModel):
    """DescribeVulStoreList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 漏洞信息
注意：此字段可能返回 null，表示取不到有效值。
        :type List: list of VulStoreListInfo
        :param _TotalCount: 总数
        :type TotalCount: int
        :param _Remaining: 今日剩余搜索此时
        :type Remaining: int
        :param _FreeSearchTimes: 免费搜索次数
        :type FreeSearchTimes: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._Remaining = None
        self._FreeSearchTimes = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Remaining(self):
        return self._Remaining

    @Remaining.setter
    def Remaining(self, Remaining):
        self._Remaining = Remaining

    @property
    def FreeSearchTimes(self):
        return self._FreeSearchTimes

    @FreeSearchTimes.setter
    def FreeSearchTimes(self, FreeSearchTimes):
        self._FreeSearchTimes = FreeSearchTimes

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = VulStoreListInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._Remaining = params.get("Remaining")
        self._FreeSearchTimes = params.get("FreeSearchTimes")
        self._RequestId = params.get("RequestId")


class DescribeVulTopRequest(AbstractModel):
    """DescribeVulTop请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Top: 漏洞风险服务器top，1-100
        :type Top: int
        :param _VulCategory: 1:web-cms 漏洞，2.应用漏洞 4: Linux软件漏洞 5: windows系统漏洞 6:应急漏洞，不填或者填0时返回 1，2，4，5 的总统计数据
        :type VulCategory: int
        :param _IsFollowVul: 是否仅统计重点关注漏洞 1=仅统计重点关注漏洞, 0=统计全部漏洞
        :type IsFollowVul: int
        """
        self._Top = None
        self._VulCategory = None
        self._IsFollowVul = None

    @property
    def Top(self):
        return self._Top

    @Top.setter
    def Top(self, Top):
        self._Top = Top

    @property
    def VulCategory(self):
        return self._VulCategory

    @VulCategory.setter
    def VulCategory(self, VulCategory):
        self._VulCategory = VulCategory

    @property
    def IsFollowVul(self):
        return self._IsFollowVul

    @IsFollowVul.setter
    def IsFollowVul(self, IsFollowVul):
        self._IsFollowVul = IsFollowVul


    def _deserialize(self, params):
        self._Top = params.get("Top")
        self._VulCategory = params.get("VulCategory")
        self._IsFollowVul = params.get("IsFollowVul")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVulTopResponse(AbstractModel):
    """DescribeVulTop返回参数结构体

    """

    def __init__(self):
        r"""
        :param _VulTopList: 漏洞top列表
注意：此字段可能返回 null，表示取不到有效值。
        :type VulTopList: list of VulTopInfo
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._VulTopList = None
        self._RequestId = None

    @property
    def VulTopList(self):
        return self._VulTopList

    @VulTopList.setter
    def VulTopList(self, VulTopList):
        self._VulTopList = VulTopList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("VulTopList") is not None:
            self._VulTopList = []
            for item in params.get("VulTopList"):
                obj = VulTopInfo()
                obj._deserialize(item)
                self._VulTopList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeWarningListRequest(AbstractModel):
    """DescribeWarningList请求参数结构体

    """


class DescribeWarningListResponse(AbstractModel):
    """DescribeWarningList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _WarningInfoList: 获取告警列表
        :type WarningInfoList: list of WarningInfoObj
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._WarningInfoList = None
        self._RequestId = None

    @property
    def WarningInfoList(self):
        return self._WarningInfoList

    @WarningInfoList.setter
    def WarningInfoList(self, WarningInfoList):
        self._WarningInfoList = WarningInfoList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("WarningInfoList") is not None:
            self._WarningInfoList = []
            for item in params.get("WarningInfoList"):
                obj = WarningInfoObj()
                obj._deserialize(item)
                self._WarningInfoList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeWebPageEventListRequest(AbstractModel):
    """DescribeWebPageEventList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤条件
<li>IpOrAlias - String - 是否必填：否 - 主机ip或别名筛选</li>
<li>EventType - String - 是否必填：否 - 事件类型</li>
<li>EventStatus - String - 是否必填：否 - 事件状态</li>
        :type Filters: list of AssetFilters
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        :param _Limit: 返回数量，默认为10，最大值为100。
        :type Limit: int
        :param _By: 排序方式：CreateTime 或 RestoreTime，默认为CreateTime
        :type By: str
        :param _Order: 排序方式，0降序，1升序，默认为0
        :type Order: int
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._By = None
        self._Order = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeWebPageEventListResponse(AbstractModel):
    """DescribeWebPageEventList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _List: 防护事件列表信息
        :type List: list of ProtectEventLists
        :param _TotalCount: 总数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ProtectEventLists()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeWebPageGeneralizeRequest(AbstractModel):
    """DescribeWebPageGeneralize请求参数结构体

    """


class DescribeWebPageGeneralizeResponse(AbstractModel):
    """DescribeWebPageGeneralize返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ProtectMonitor: 防护监测 0 未开启 1 已开启 2 异常
        :type ProtectMonitor: int
        :param _ProtectDirNum: 防护目录数
        :type ProtectDirNum: int
        :param _ProtectFileNum: 防护文件数
        :type ProtectFileNum: int
        :param _TamperFileNum: 篡改文件数
        :type TamperFileNum: int
        :param _TamperNum: 篡改数
        :type TamperNum: int
        :param _ProtectToday: 今日防护数
        :type ProtectToday: int
        :param _ProtectHostNum: 防护主机数
        :type ProtectHostNum: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ProtectMonitor = None
        self._ProtectDirNum = None
        self._ProtectFileNum = None
        self._TamperFileNum = None
        self._TamperNum = None
        self._ProtectToday = None
        self._ProtectHostNum = None
        self._RequestId = None

    @property
    def ProtectMonitor(self):
        return self._ProtectMonitor

    @ProtectMonitor.setter
    def ProtectMonitor(self, ProtectMonitor):
        self._ProtectMonitor = ProtectMonitor

    @property
    def ProtectDirNum(self):
        return self._ProtectDirNum

    @ProtectDirNum.setter
    def ProtectDirNum(self, ProtectDirNum):
        self._ProtectDirNum = ProtectDirNum

    @property
    def ProtectFileNum(self):
        return self._ProtectFileNum

    @ProtectFileNum.setter
    def ProtectFileNum(self, ProtectFileNum):
        self._ProtectFileNum = ProtectFileNum

    @property
    def TamperFileNum(self):
        return self._TamperFileNum

    @TamperFileNum.setter
    def TamperFileNum(self, TamperFileNum):
        self._TamperFileNum = TamperFileNum

    @property
    def TamperNum(self):
        return self._TamperNum

    @TamperNum.setter
    def TamperNum(self, TamperNum):
        self._TamperNum = TamperNum

    @property
    def ProtectToday(self):
        return self._ProtectToday

    @ProtectToday.setter
    def ProtectToday(self, ProtectToday):
        self._ProtectToday = ProtectToday

    @property
    def ProtectHostNum(self):
        return self._ProtectHostNum

    @ProtectHostNum.setter
    def ProtectHostNum(self, ProtectHostNum):
        self._ProtectHostNum = ProtectHostNum

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ProtectMonitor = params.get("ProtectMonitor")
        self._ProtectDirNum = params.get("ProtectDirNum")
        self._ProtectFileNum = params.get("ProtectFileNum")
        self._TamperFileNum = params.get("TamperFileNum")
        self._TamperNum = params.get("TamperNum")
        self._ProtectToday = params.get("ProtectToday")
        self._ProtectHostNum = params.get("ProtectHostNum")
        self._RequestId = params.get("RequestId")


class DescribeWebPageProtectStatRequest(AbstractModel):
    """DescribeWebPageProtectStat请求参数结构体

    """


class DescribeWebPageProtectStatResponse(AbstractModel):
    """DescribeWebPageProtectStat返回参数结构体

    """

    def __init__(self):
        r"""
        :param _FileTamperNum: 文件篡改信息
        :type FileTamperNum: list of ProtectStat
        :param _ProtectFileType: 防护文件分类信息
        :type ProtectFileType: list of ProtectStat
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._FileTamperNum = None
        self._ProtectFileType = None
        self._RequestId = None

    @property
    def FileTamperNum(self):
        return self._FileTamperNum

    @FileTamperNum.setter
    def FileTamperNum(self, FileTamperNum):
        self._FileTamperNum = FileTamperNum

    @property
    def ProtectFileType(self):
        return self._ProtectFileType

    @ProtectFileType.setter
    def ProtectFileType(self, ProtectFileType):
        self._ProtectFileType = ProtectFileType

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("FileTamperNum") is not None:
            self._FileTamperNum = []
            for item in params.get("FileTamperNum"):
                obj = ProtectStat()
                obj._deserialize(item)
                self._FileTamperNum.append(obj)
        if params.get("ProtectFileType") is not None:
            self._ProtectFileType = []
            for item in params.get("ProtectFileType"):
                obj = ProtectStat()
                obj._deserialize(item)
                self._ProtectFileType.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeWebPageServiceInfoRequest(AbstractModel):
    """DescribeWebPageServiceInfo请求参数结构体

    """


class DescribeWebPageServiceInfoResponse(AbstractModel):
    """DescribeWebPageServiceInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Status: 是否已购服务：true-是，false-否
        :type Status: bool
        :param _UsedNum: 已使用授权数
        :type UsedNum: int
        :param _ResidueNum: 剩余授权数
        :type ResidueNum: int
        :param _BuyNum: 已购授权数
        :type BuyNum: int
        :param _ExpireNum: 临近到期数量
        :type ExpireNum: int
        :param _AllAuthorizedMachines: 所有授权机器信息
        :type AllAuthorizedMachines: list of ProtectMachineInfo
        :param _ExpireAuthorizedMachines: 临近到期授权机器信息
        :type ExpireAuthorizedMachines: list of ProtectMachine
        :param _ExpiredNum: 已过期授权数
        :type ExpiredNum: int
        :param _ProtectDirNum: 防护目录数
        :type ProtectDirNum: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Status = None
        self._UsedNum = None
        self._ResidueNum = None
        self._BuyNum = None
        self._ExpireNum = None
        self._AllAuthorizedMachines = None
        self._ExpireAuthorizedMachines = None
        self._ExpiredNum = None
        self._ProtectDirNum = None
        self._RequestId = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def UsedNum(self):
        return self._UsedNum

    @UsedNum.setter
    def UsedNum(self, UsedNum):
        self._UsedNum = UsedNum

    @property
    def ResidueNum(self):
        return self._ResidueNum

    @ResidueNum.setter
    def ResidueNum(self, ResidueNum):
        self._ResidueNum = ResidueNum

    @property
    def BuyNum(self):
        return self._BuyNum

    @BuyNum.setter
    def BuyNum(self, BuyNum):
        self._BuyNum = BuyNum

    @property
    def ExpireNum(self):
        return self._ExpireNum

    @ExpireNum.setter
    def ExpireNum(self, ExpireNum):
        self._ExpireNum = ExpireNum

    @property
    def AllAuthorizedMachines(self):
        return self._AllAuthorizedMachines

    @AllAuthorizedMachines.setter
    def AllAuthorizedMachines(self, AllAuthorizedMachines):
        self._AllAuthorizedMachines = AllAuthorizedMachines

    @property
    def ExpireAuthorizedMachines(self):
        return self._ExpireAuthorizedMachines

    @ExpireAuthorizedMachines.setter
    def ExpireAuthorizedMachines(self, ExpireAuthorizedMachines):
        self._ExpireAuthorizedMachines = ExpireAuthorizedMachines

    @property
    def ExpiredNum(self):
        return self._ExpiredNum

    @ExpiredNum.setter
    def ExpiredNum(self, ExpiredNum):
        self._ExpiredNum = ExpiredNum

    @property
    def ProtectDirNum(self):
        return self._ProtectDirNum

    @ProtectDirNum.setter
    def ProtectDirNum(self, ProtectDirNum):
        self._ProtectDirNum = ProtectDirNum

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._UsedNum = params.get("UsedNum")
        self._ResidueNum = params.get("ResidueNum")
        self._BuyNum = params.get("BuyNum")
        self._ExpireNum = params.get("ExpireNum")
        if params.get("AllAuthorizedMachines") is not None:
            self._AllAuthorizedMachines = []
            for item in params.get("AllAuthorizedMachines"):
                obj = ProtectMachineInfo()
                obj._deserialize(item)
                self._AllAuthorizedMachines.append(obj)
        if params.get("ExpireAuthorizedMachines") is not None:
            self._ExpireAuthorizedMachines = []
            for item in params.get("ExpireAuthorizedMachines"):
                obj = ProtectMachine()
                obj._deserialize(item)
                self._ExpireAuthorizedMachines.append(obj)
        self._ExpiredNum = params.get("ExpiredNum")
        self._ProtectDirNum = params.get("ProtectDirNum")
        self._RequestId = params.get("RequestId")


class DestroyOrderRequest(AbstractModel):
    """DestroyOrder请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ResourceId: 资源ID
        :type ResourceId: str
        :param _LicenseType: 授权类型 0 专业版-按量计费, 1专业版-包年包月 , 2 旗舰版-包年包月
        :type LicenseType: int
        """
        self._ResourceId = None
        self._LicenseType = None

    @property
    def ResourceId(self):
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId

    @property
    def LicenseType(self):
        return self._LicenseType

    @LicenseType.setter
    def LicenseType(self, LicenseType):
        self._LicenseType = LicenseType


    def _deserialize(self, params):
        self._ResourceId = params.get("ResourceId")
        self._LicenseType = params.get("LicenseType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DestroyOrderResponse(AbstractModel):
    """DestroyOrder返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class EditBashRulesRequest(AbstractModel):
    """EditBashRules请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 规则ID（新增时不填）
        :type Id: int
        :param _Uuids: 客户端ID数组
        :type Uuids: list of str
        :param _HostIp: 主机IP
        :type HostIp: str
        :param _Name: 规则名称，编辑时不可修改规则名称
        :type Name: str
        :param _Level: 危险等级(0:无，1: 高危 2:中危 3: 低危)
        :type Level: int
        :param _Rule: 正则表达式 ，编辑时不可修改正则表达式，需要对内容QueryEscape后再base64
        :type Rule: str
        :param _IsGlobal: 是否全局规则(默认否)：1-全局，0-非全局
        :type IsGlobal: int
        :param _White: 0=黑名单， 1=白名单
        :type White: int
        :param _EventId: 事件列表点击“加入白名单”时,需要传EventId 事件的id
        :type EventId: int
        :param _DealOldEvents: 是否处理旧事件为白名单 0=不处理 1=处理
        :type DealOldEvents: int
        """
        self._Id = None
        self._Uuids = None
        self._HostIp = None
        self._Name = None
        self._Level = None
        self._Rule = None
        self._IsGlobal = None
        self._White = None
        self._EventId = None
        self._DealOldEvents = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Uuids(self):
        return self._Uuids

    @Uuids.setter
    def Uuids(self, Uuids):
        self._Uuids = Uuids

    @property
    def HostIp(self):
        return self._HostIp

    @HostIp.setter
    def HostIp(self, HostIp):
        self._HostIp = HostIp

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Level(self):
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level

    @property
    def Rule(self):
        return self._Rule

    @Rule.setter
    def Rule(self, Rule):
        self._Rule = Rule

    @property
    def IsGlobal(self):
        return self._IsGlobal

    @IsGlobal.setter
    def IsGlobal(self, IsGlobal):
        self._IsGlobal = IsGlobal

    @property
    def White(self):
        return self._White

    @White.setter
    def White(self, White):
        self._White = White

    @property
    def EventId(self):
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId

    @property
    def DealOldEvents(self):
        return self._DealOldEvents

    @DealOldEvents.setter
    def DealOldEvents(self, DealOldEvents):
        self._DealOldEvents = DealOldEvents


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Uuids = params.get("Uuids")
        self._HostIp = params.get("HostIp")
        self._Name = params.get("Name")
        self._Level = params.get("Level")
        self._Rule = params.get("Rule")
        self._IsGlobal = params.get("IsGlobal")
        self._White = params.get("White")
        self._EventId = params.get("EventId")
        self._DealOldEvents = params.get("DealOldEvents")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EditBashRulesResponse(AbstractModel):
    """EditBashRules返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class EditTagsRequest(AbstractModel):
    """EditTags请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 标签名
        :type Name: str
        :param _Id: 标签ID
        :type Id: int
        :param _Quuids: Quuid
        :type Quuids: list of str
        """
        self._Name = None
        self._Id = None
        self._Quuids = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Quuids(self):
        return self._Quuids

    @Quuids.setter
    def Quuids(self, Quuids):
        self._Quuids = Quuids


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Id = params.get("Id")
        self._Quuids = params.get("Quuids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EditTagsResponse(AbstractModel):
    """EditTags返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class EffectiveMachineInfo(AbstractModel):
    """批量导入机器信息.

    """

    def __init__(self):
        r"""
        :param _MachineName: 机器名称
注意：此字段可能返回 null，表示取不到有效值。
        :type MachineName: str
        :param _MachinePublicIp: 机器公网ip
注意：此字段可能返回 null，表示取不到有效值。
        :type MachinePublicIp: str
        :param _MachinePrivateIp: 机器内网ip
注意：此字段可能返回 null，表示取不到有效值。
        :type MachinePrivateIp: str
        :param _MachineTag: 机器标签
注意：此字段可能返回 null，表示取不到有效值。
        :type MachineTag: list of MachineTag
        :param _Quuid: 机器Quuid
注意：此字段可能返回 null，表示取不到有效值。
        :type Quuid: str
        :param _Uuid: 云镜Uuid
注意：此字段可能返回 null，表示取不到有效值。
        :type Uuid: str
        :param _KernelVersion: 内核版本号
注意：此字段可能返回 null，表示取不到有效值。
        :type KernelVersion: str
        :param _MachineStatus: 在线状态 OFFLINE，ONLINE
注意：此字段可能返回 null，表示取不到有效值。
        :type MachineStatus: str
        :param _LicenseOrder: 授权订单对象
注意：此字段可能返回 null，表示取不到有效值。
        :type LicenseOrder: :class:`tencentcloud.cwp.v20180228.models.LicenseOrder`
        :param _VulNum: 漏洞数量
注意：此字段可能返回 null，表示取不到有效值。
        :type VulNum: int
        :param _CloudTags: 云标签信息
注意：此字段可能返回 null，表示取不到有效值。
        :type CloudTags: list of Tags
        :param _InstanceID: 机器instance ID
注意：此字段可能返回 null，表示取不到有效值。
        :type InstanceID: str
        """
        self._MachineName = None
        self._MachinePublicIp = None
        self._MachinePrivateIp = None
        self._MachineTag = None
        self._Quuid = None
        self._Uuid = None
        self._KernelVersion = None
        self._MachineStatus = None
        self._LicenseOrder = None
        self._VulNum = None
        self._CloudTags = None
        self._InstanceID = None

    @property
    def MachineName(self):
        return self._MachineName

    @MachineName.setter
    def MachineName(self, MachineName):
        self._MachineName = MachineName

    @property
    def MachinePublicIp(self):
        return self._MachinePublicIp

    @MachinePublicIp.setter
    def MachinePublicIp(self, MachinePublicIp):
        self._MachinePublicIp = MachinePublicIp

    @property
    def MachinePrivateIp(self):
        return self._MachinePrivateIp

    @MachinePrivateIp.setter
    def MachinePrivateIp(self, MachinePrivateIp):
        self._MachinePrivateIp = MachinePrivateIp

    @property
    def MachineTag(self):
        return self._MachineTag

    @MachineTag.setter
    def MachineTag(self, MachineTag):
        self._MachineTag = MachineTag

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def KernelVersion(self):
        return self._KernelVersion

    @KernelVersion.setter
    def KernelVersion(self, KernelVersion):
        self._KernelVersion = KernelVersion

    @property
    def MachineStatus(self):
        return self._MachineStatus

    @MachineStatus.setter
    def MachineStatus(self, MachineStatus):
        self._MachineStatus = MachineStatus

    @property
    def LicenseOrder(self):
        return self._LicenseOrder

    @LicenseOrder.setter
    def LicenseOrder(self, LicenseOrder):
        self._LicenseOrder = LicenseOrder

    @property
    def VulNum(self):
        return self._VulNum

    @VulNum.setter
    def VulNum(self, VulNum):
        self._VulNum = VulNum

    @property
    def CloudTags(self):
        return self._CloudTags

    @CloudTags.setter
    def CloudTags(self, CloudTags):
        self._CloudTags = CloudTags

    @property
    def InstanceID(self):
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID


    def _deserialize(self, params):
        self._MachineName = params.get("MachineName")
        self._MachinePublicIp = params.get("MachinePublicIp")
        self._MachinePrivateIp = params.get("MachinePrivateIp")
        if params.get("MachineTag") is not None:
            self._MachineTag = []
            for item in params.get("MachineTag"):
                obj = MachineTag()
                obj._deserialize(item)
                self._MachineTag.append(obj)
        self._Quuid = params.get("Quuid")
        self._Uuid = params.get("Uuid")
        self._KernelVersion = params.get("KernelVersion")
        self._MachineStatus = params.get("MachineStatus")
        if params.get("LicenseOrder") is not None:
            self._LicenseOrder = LicenseOrder()
            self._LicenseOrder._deserialize(params.get("LicenseOrder"))
        self._VulNum = params.get("VulNum")
        if params.get("CloudTags") is not None:
            self._CloudTags = []
            for item in params.get("CloudTags"):
                obj = Tags()
                obj._deserialize(item)
                self._CloudTags.append(obj)
        self._InstanceID = params.get("InstanceID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EmergencyResponseInfo(AbstractModel):
    """专家服务-应急响应信息

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务id
        :type TaskId: str
        :param _HostNum: 主机个数
        :type HostNum: int
        :param _Status: 服务状态 0未启动，·响应中，2响应完成
        :type Status: int
        :param _StartTime: 服务开始时间
        :type StartTime: str
        :param _EndTime: 服务结束时间
        :type EndTime: str
        :param _ReportPath: 报告下载地址
        :type ReportPath: str
        """
        self._TaskId = None
        self._HostNum = None
        self._Status = None
        self._StartTime = None
        self._EndTime = None
        self._ReportPath = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def HostNum(self):
        return self._HostNum

    @HostNum.setter
    def HostNum(self, HostNum):
        self._HostNum = HostNum

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def ReportPath(self):
        return self._ReportPath

    @ReportPath.setter
    def ReportPath(self, ReportPath):
        self._ReportPath = ReportPath


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._HostNum = params.get("HostNum")
        self._Status = params.get("Status")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._ReportPath = params.get("ReportPath")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EmergencyVul(AbstractModel):
    """应急漏洞信息

    """

    def __init__(self):
        r"""
        :param _VulId: 漏洞id
        :type VulId: int
        :param _Level: 漏洞级别
        :type Level: int
        :param _VulName: 漏洞名称
        :type VulName: str
        :param _PublishDate: 发布日期
        :type PublishDate: str
        :param _Category: 漏洞分类
        :type Category: int
        :param _Status: 漏洞状态 0未检测 1有风险 ，2无风险 ，3 检查中展示progress
        :type Status: int
        :param _LastScanTime: 最后扫描时间
        :type LastScanTime: str
        :param _Progress: 扫描进度
        :type Progress: int
        :param _CveId: cve编号
注意：此字段可能返回 null，表示取不到有效值。
        :type CveId: str
        :param _CvssScore: CVSS评分
注意：此字段可能返回 null，表示取不到有效值。
        :type CvssScore: float
        :param _Labels: 漏洞标签 多个逗号分割
注意：此字段可能返回 null，表示取不到有效值。
        :type Labels: str
        :param _HostCount: 影响机器数
注意：此字段可能返回 null，表示取不到有效值。
        :type HostCount: int
        :param _IsSupportDefense: 是否支持防御， 0:不支持 1:支持
注意：此字段可能返回 null，表示取不到有效值。
        :type IsSupportDefense: int
        :param _DefenseAttackCount: 已防御的攻击次数
注意：此字段可能返回 null，表示取不到有效值。
        :type DefenseAttackCount: int
        :param _Method: 检测规则 0 - 版本比对, 1 - POC验证
注意：此字段可能返回 null，表示取不到有效值。
        :type Method: int
        :param _AttackLevel: 攻击热度级别
注意：此字段可能返回 null，表示取不到有效值。
        :type AttackLevel: int
        :param _DefenseState: 是否有漏洞主机开启漏洞防御
注意：此字段可能返回 null，表示取不到有效值。
        :type DefenseState: bool
        """
        self._VulId = None
        self._Level = None
        self._VulName = None
        self._PublishDate = None
        self._Category = None
        self._Status = None
        self._LastScanTime = None
        self._Progress = None
        self._CveId = None
        self._CvssScore = None
        self._Labels = None
        self._HostCount = None
        self._IsSupportDefense = None
        self._DefenseAttackCount = None
        self._Method = None
        self._AttackLevel = None
        self._DefenseState = None

    @property
    def VulId(self):
        return self._VulId

    @VulId.setter
    def VulId(self, VulId):
        self._VulId = VulId

    @property
    def Level(self):
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level

    @property
    def VulName(self):
        return self._VulName

    @VulName.setter
    def VulName(self, VulName):
        self._VulName = VulName

    @property
    def PublishDate(self):
        return self._PublishDate

    @PublishDate.setter
    def PublishDate(self, PublishDate):
        self._PublishDate = PublishDate

    @property
    def Category(self):
        return self._Category

    @Category.setter
    def Category(self, Category):
        self._Category = Category

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def LastScanTime(self):
        return self._LastScanTime

    @LastScanTime.setter
    def LastScanTime(self, LastScanTime):
        self._LastScanTime = LastScanTime

    @property
    def Progress(self):
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def CveId(self):
        return self._CveId

    @CveId.setter
    def CveId(self, CveId):
        self._CveId = CveId

    @property
    def CvssScore(self):
        return self._CvssScore

    @CvssScore.setter
    def CvssScore(self, CvssScore):
        self._CvssScore = CvssScore

    @property
    def Labels(self):
        return self._Labels

    @Labels.setter
    def Labels(self, Labels):
        self._Labels = Labels

    @property
    def HostCount(self):
        return self._HostCount

    @HostCount.setter
    def HostCount(self, HostCount):
        self._HostCount = HostCount

    @property
    def IsSupportDefense(self):
        return self._IsSupportDefense

    @IsSupportDefense.setter
    def IsSupportDefense(self, IsSupportDefense):
        self._IsSupportDefense = IsSupportDefense

    @property
    def DefenseAttackCount(self):
        return self._DefenseAttackCount

    @DefenseAttackCount.setter
    def DefenseAttackCount(self, DefenseAttackCount):
        self._DefenseAttackCount = DefenseAttackCount

    @property
    def Method(self):
        return self._Method

    @Method.setter
    def Method(self, Method):
        self._Method = Method

    @property
    def AttackLevel(self):
        return self._AttackLevel

    @AttackLevel.setter
    def AttackLevel(self, AttackLevel):
        self._AttackLevel = AttackLevel

    @property
    def DefenseState(self):
        return self._DefenseState

    @DefenseState.setter
    def DefenseState(self, DefenseState):
        self._DefenseState = DefenseState


    def _deserialize(self, params):
        self._VulId = params.get("VulId")
        self._Level = params.get("Level")
        self._VulName = params.get("VulName")
        self._PublishDate = params.get("PublishDate")
        self._Category = params.get("Category")
        self._Status = params.get("Status")
        self._LastScanTime = params.get("LastScanTime")
        self._Progress = params.get("Progress")
        self._CveId = params.get("CveId")
        self._CvssScore = params.get("CvssScore")
        self._Labels = params.get("Labels")
        self._HostCount = params.get("HostCount")
        self._IsSupportDefense = params.get("IsSupportDefense")
        self._DefenseAttackCount = params.get("DefenseAttackCount")
        self._Method = params.get("Method")
        self._AttackLevel = params.get("AttackLevel")
        self._DefenseState = params.get("DefenseState")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EventStat(AbstractModel):
    """未处理的安全事件统计信息

    """

    def __init__(self):
        r"""
        :param _EventsNum: 事件数
        :type EventsNum: int
        :param _MachineAffectNum: 受影响的主机数
        :type MachineAffectNum: int
        """
        self._EventsNum = None
        self._MachineAffectNum = None

    @property
    def EventsNum(self):
        return self._EventsNum

    @EventsNum.setter
    def EventsNum(self, EventsNum):
        self._EventsNum = EventsNum

    @property
    def MachineAffectNum(self):
        return self._MachineAffectNum

    @MachineAffectNum.setter
    def MachineAffectNum(self, MachineAffectNum):
        self._MachineAffectNum = MachineAffectNum


    def _deserialize(self, params):
        self._EventsNum = params.get("EventsNum")
        self._MachineAffectNum = params.get("MachineAffectNum")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExpertServiceOrderInfo(AbstractModel):
    """专家服务订单信息

    """

    def __init__(self):
        r"""
        :param _OrderId: 订单id
        :type OrderId: int
        :param _InquireType: 订单类型 1应急 2 旗舰重保 3 安全管家
        :type InquireType: int
        :param _InquireNum: 服务数量
        :type InquireNum: int
        :param _BeginTime: 服务开始时间
        :type BeginTime: str
        :param _EndTime: 服务结束时间
        :type EndTime: str
        :param _ServiceTime: 服务时长几个月
        :type ServiceTime: int
        :param _Status: 订单状态 0 未启动 1 服务中 2已过期 3完成，4退费销毁
        :type Status: int
        """
        self._OrderId = None
        self._InquireType = None
        self._InquireNum = None
        self._BeginTime = None
        self._EndTime = None
        self._ServiceTime = None
        self._Status = None

    @property
    def OrderId(self):
        return self._OrderId

    @OrderId.setter
    def OrderId(self, OrderId):
        self._OrderId = OrderId

    @property
    def InquireType(self):
        return self._InquireType

    @InquireType.setter
    def InquireType(self, InquireType):
        self._InquireType = InquireType

    @property
    def InquireNum(self):
        return self._InquireNum

    @InquireNum.setter
    def InquireNum(self, InquireNum):
        self._InquireNum = InquireNum

    @property
    def BeginTime(self):
        return self._BeginTime

    @BeginTime.setter
    def BeginTime(self, BeginTime):
        self._BeginTime = BeginTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def ServiceTime(self):
        return self._ServiceTime

    @ServiceTime.setter
    def ServiceTime(self, ServiceTime):
        self._ServiceTime = ServiceTime

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._OrderId = params.get("OrderId")
        self._InquireType = params.get("InquireType")
        self._InquireNum = params.get("InquireNum")
        self._BeginTime = params.get("BeginTime")
        self._EndTime = params.get("EndTime")
        self._ServiceTime = params.get("ServiceTime")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExportAssetCoreModuleListRequest(AbstractModel):
    """ExportAssetCoreModuleList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Uuid: 服务器Uuid
        :type Uuid: str
        :param _Quuid: 服务器Quuid
        :type Quuid: str
        :param _Filters: 过滤条件。
<li>Name- string - 是否必填：否 - 包名</li>
<li>User- string - 是否必填：否 - 用户</li>
        :type Filters: list of AssetFilters
        :param _Order: 排序方式，asc升序 或 desc降序
        :type Order: str
        :param _By: 排序依据[FirstTime|Size|ProcessCount|ModuleCount]
        :type By: str
        """
        self._Uuid = None
        self._Quuid = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Uuid = params.get("Uuid")
        self._Quuid = params.get("Quuid")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExportAssetCoreModuleListResponse(AbstractModel):
    """ExportAssetCoreModuleList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 异步下载任务ID，需要配合ExportTasks接口使用
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class ExportAssetWebServiceInfoListRequest(AbstractModel):
    """ExportAssetWebServiceInfoList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Quuid: 查询指定Quuid主机的信息
        :type Quuid: str
        :param _Filters: 过滤条件。
<li>User- string - 是否必填：否 - 运行用户</li>
<li>Name- string - 是否必填：否 - Web服务名：
1:Tomcat
2:Apache
3:Nginx
4:WebLogic
5:Websphere
6:JBoss
7:WildFly
8:Jetty
9:IHS
10:Tengine</li>
<li>OsType- string - 是否必填：否 - Windows/linux</li>
        :type Filters: list of AssetFilters
        :param _Order: 排序方式，asc升序 或 desc降序
        :type Order: str
        :param _By: 可选排序：[FirstTime|ProcessCount]
        :type By: str
        """
        self._Quuid = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Quuid = params.get("Quuid")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExportAssetWebServiceInfoListResponse(AbstractModel):
    """ExportAssetWebServiceInfoList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 异步下载任务ID，需要配合ExportTasks接口使用
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class ExportAttackLogsRequest(AbstractModel):
    """ExportAttackLogs请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤条件。
<li>HttpMethod - String - 是否必填：否 - 攻击方法(POST|GET)</li>
<li>DateRange - String - 是否必填：否 - 时间范围(存储最近3个月的数据)，如最近一个月["2019-11-17", "2019-12-17"]</li>
<li>VulType - String 威胁类型 - 是否必填: 否</li>
<li>SrcIp - String 攻击源IP - 是否必填: 否</li>
<li>DstIp - String 攻击目标IP - 是否必填: 否</li>
<li>SrcPort - String 攻击源端口 - 是否必填: 否</li>
<li>DstPort - String 攻击目标端口 - 是否必填: 否</li>
        :type Filters: list of Filters
        :param _Uuid: 主机安全客户端ID
        :type Uuid: str
        :param _Quuid: 云主机机器ID
        :type Quuid: str
        """
        self._Filters = None
        self._Uuid = None
        self._Quuid = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid

    @property
    def Quuid(self):
        return self._Quuid

    @Quuid.setter
    def Quuid(self, Quuid):
        self._Quuid = Quuid


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Uuid = params.get("Uuid")
        self._Quuid = params.get("Quuid")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExportAttackLogsResponse(AbstractModel):
    """ExportAttackLogs返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: 已废弃
        :type DownloadUrl: str
        :param _TaskId: 任务ID,需要到接口“异步导出任务”ExportTasks获取DownloadUrl下载地址
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._TaskId = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class ExportBaselineEffectHostListRequest(AbstractModel):
    """ExportBaselineEffectHostList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _BaselineId: 基线id
        :type BaselineId: int
        :param _Filters: 筛选条件
<li>AliasName- String- 主机别名</li>
        :type Filters: list of Filters
        :param _StrategyId: 策略id
        :type StrategyId: int
        :param _UuidList: 主机uuid数组
        :type UuidList: list of str
        :param _BaselineName: 基线名称
        :type BaselineName: str
        """
        self._BaselineId = None
        self._Filters = None
        self._StrategyId = None
        self._UuidList = None
        self._BaselineName = None

    @property
    def BaselineId(self):
        return self._BaselineId

    @BaselineId.setter
    def BaselineId(self, BaselineId):
        self._BaselineId = BaselineId

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def StrategyId(self):
        return self._StrategyId

    @StrategyId.setter
    def StrategyId(self, StrategyId):
        self._StrategyId = StrategyId

    @property
    def UuidList(self):
        return self._UuidList

    @UuidList.setter
    def UuidList(self, UuidList):
        self._UuidList = UuidList

    @property
    def BaselineName(self):
        return self._BaselineName

    @BaselineName.setter
    def BaselineName(self, BaselineName):
        self._BaselineName = BaselineName


    def _deserialize(self, params):
        self._BaselineId = params.get("BaselineId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._StrategyId = params.get("StrategyId")
        self._UuidList = params.get("UuidList")
        self._BaselineName = params.get("BaselineName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExportBaselineEffectHostListResponse(AbstractModel):
    """ExportBaselineEffectHostList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: 该参数已废弃
注意：此字段可能返回 null，表示取不到有效值。
        :type DownloadUrl: str
        :param _TaskId: 任务ID,需要到接口“异步导出任务”ExportTasks获取DownloadUrl下载地址
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._TaskId = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class ExportBaselineFixListRequest(AbstractModel):
    """ExportBaselineFixList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: <li>ItemName - String - 是否必填：否 - 项名称</li>
        :type Filters: list of Filter
        :param _ExportAll: 0:过滤的结果导出；1:全部导出
        :type ExportAll: int
        """
        self._Filters = None
        self._ExportAll = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def ExportAll(self):
        return self._ExportAll

    @ExportAll.setter
    def ExportAll(self, ExportAll):
        self._ExportAll = ExportAll


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._ExportAll = params.get("ExportAll")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExportBaselineFixListResponse(AbstractModel):
    """ExportBaselineFixList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ExportBaselineHostDetectListRequest(AbstractModel):
    """ExportBaselineHostDetectList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: <li>HostTag - string - 是否必填：否 - 主机标签</i>
<li>ItemId - int64 - 是否必填：否 - 项Id</i>
<li>RuleId - int64 - 是否必填：否 - 规则Id</li>
<li>IsPassed - int - 是否必填：否 - 是否通过</li>
<li>RiskTier - int - 是否必填：否 - 风险等级</li>
        :type Filters: list of Filter
        :param _ExportAll: 0:过滤的结果导出；1:全部导出
        :type ExportAll: int
        """
        self._Filters = None
        self._ExportAll = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def ExportAll(self):
        return self._ExportAll

    @ExportAll.setter
    def ExportAll(self, ExportAll):
        self._ExportAll = ExportAll


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._ExportAll = params.get("ExportAll")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExportBaselineHostDetectListResponse(AbstractModel):
    """ExportBaselineHostDetectList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ExportBaselineItemDetectListRequest(AbstractModel):
    """ExportBaselineItemDetectList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: <li>HostId - string - 是否必填：否 - 主机Id</i>
<li>RuleId - int64 - 是否必填：否 - 规则Id</i>
<li>IsPassed - int - 是否必填：否 - 是否通过</li>
<li>RiskTier - int - 是否必填：否 - 风险等级</li>
        :type Filters: list of Filter
        :param _ExportAll: 0:过滤的结果导出；1:全部导出
        :type ExportAll: int
        """
        self._Filters = None
        self._ExportAll = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def ExportAll(self):
        return self._ExportAll

    @ExportAll.setter
    def ExportAll(self, ExportAll):
        self._ExportAll = ExportAll


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._ExportAll = params.get("ExportAll")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExportBaselineItemDetectListResponse(AbstractModel):
    """ExportBaselineItemDetectList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ExportBaselineItemListRequest(AbstractModel):
    """ExportBaselineItemList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: <li>PolicyId - int64 - 是否必填：否 - 策略Id</li>
<li>RuleId - int64 - 是否必填：否 - 规则Id</li>
<li>HostId - string - 是否必填：否 - 主机Id</li>
<li>HostName - string - 是否必填：否 - 主机名</li>
<li>HostIp - string - 是否必填：否 - 主机IP</li>
<li>ItemId - String - 是否必填：否 - 检测项Id</li>
<li>ItemName - String - 是否必填：否 - 项名称</li>
<li>DetectStatus - int - 是否必填：否 - 检测状态[0:未通过|3:通过|5:检测中]</li>
<li>Level - int - 是否必填：否 - 风险等级</li>
<li>StartTime - string - 是否必填：否 - 开时时间</li>
<li>EndTime - string - 是否必填：否 - 结束时间</li>
        :type Filters: list of Filter
        :param _ExportAll: 0:过滤的结果导出；1:全部导出
        :type ExportAll: int
        """
        self._Filters = None
        self._ExportAll = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def ExportAll(self):
        return self._ExportAll

    @ExportAll.setter
    def ExportAll(self, ExportAll):
        self._ExportAll = ExportAll


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._ExportAll = params.get("ExportAll")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExportBaselineItemListResponse(AbstractModel):
    """ExportBaselineItemList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ExportBaselineListRequest(AbstractModel):
    """ExportBaselineList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤条件：
<li>StrategyId- Uint64 - 基线策略id</li>
<li>Status - Uint64 - 事件状态：0-未通过，1-忽略，3-通过，5-检测中</li>
<li>BaselineName  - String - 基线名称</li>
<li>AliasName- String - 服务器名称/服务器ip</li>
<li>Uuid- String - 主机uuid</li>
        :type Filters: list of Filters
        :param _IfDetail: 已废弃
        :type IfDetail: int
        """
        self._Filters = None
        self._IfDetail = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def IfDetail(self):
        return self._IfDetail

    @IfDetail.setter
    def IfDetail(self, IfDetail):
        self._IfDetail = IfDetail


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._IfDetail = params.get("IfDetail")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExportBaselineListResponse(AbstractModel):
    """ExportBaselineList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: 导出文件下载地址（已弃用）
注意：此字段可能返回 null，表示取不到有效值。
        :type DownloadUrl: str
        :param _TaskId: 任务ID,需要到接口“异步导出任务”ExportTasks获取DownloadUrl下载地址
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._TaskId = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class ExportBaselineRuleDetectListRequest(AbstractModel):
    """ExportBaselineRuleDetectList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: <li>RuleName - string - 是否必填：否 - 规则名称</i>
<li>IsPassed - int - 是否必填：否 - 是否通过</li>
<li>RiskTier - int - 是否必填：否 - 风险等级</li>
        :type Filters: list of Filter
        :param _ExportAll: 0:过滤的结果导出；1:全部导出
        :type ExportAll: int
        """
        self._Filters = None
        self._ExportAll = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def ExportAll(self):
        return self._ExportAll

    @ExportAll.setter
    def ExportAll(self, ExportAll):
        self._ExportAll = ExportAll


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._ExportAll = params.get("ExportAll")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExportBaselineRuleDetectListResponse(AbstractModel):
    """ExportBaselineRuleDetectList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ExportBaselineWeakPasswordListRequest(AbstractModel):
    """ExportBaselineWeakPasswordList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: <li>WeakPassword - string - 是否必填：否 - 弱口令</li>
        :type Filters: list of Filter
        :param _ExportAll: 0:过滤的结果导出；1:全部导出
        :type ExportAll: int
        """
        self._Filters = None
        self._ExportAll = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def ExportAll(self):
        return self._ExportAll

    @ExportAll.setter
    def ExportAll(self, ExportAll):
        self._ExportAll = ExportAll


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._ExportAll = params.get("ExportAll")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExportBaselineWeakPasswordListResponse(AbstractModel):
    """ExportBaselineWeakPasswordList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ExportBashEventsRequest(AbstractModel):
    """ExportBashEvents请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤参数
        :type Filters: list of Filters
        """
        self._Filters = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExportBashEventsResponse(AbstractModel):
    """ExportBashEvents返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: 导出文件下载链接地址。
        :type DownloadUrl: str
        :param _TaskId: 任务ID,需要到接口“异步导出任务”ExportTasks获取DownloadUrl下载地址
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._TaskId = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class ExportBruteAttacksRequest(AbstractModel):
    """ExportBruteAttacks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤参数
        :type Filters: list of Filters
        """
        self._Filters = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExportBruteAttacksResponse(AbstractModel):
    """ExportBruteAttacks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: 该参数已废弃
        :type DownloadUrl: str
        :param _TaskId: 任务ID,需要到接口“异步导出任务”ExportTasks获取DownloadUrl下载地址
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._TaskId = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class ExportIgnoreBaselineRuleRequest(AbstractModel):
    """ExportIgnoreBaselineRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleName: 检测项名称
        :type RuleName: str
        """
        self._RuleName = None

    @property
    def RuleName(self):
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName


    def _deserialize(self, params):
        self._RuleName = params.get("RuleName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExportIgnoreBaselineRuleResponse(AbstractModel):
    """ExportIgnoreBaselineRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: 该参数已废弃
        :type DownloadUrl: str
        :param _TaskId: 任务ID,需要到接口“异步导出任务”ExportTasks获取DownloadUrl下载地址
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._TaskId = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class ExportIgnoreRuleEffectHostListRequest(AbstractModel):
    """ExportIgnoreRuleEffectHostList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RuleId: 检测项id
        :type RuleId: int
        :param _Filters: 过滤条件。
<li>AliasName- String- 主机别名</li>
        :type Filters: list of Filters
        """
        self._RuleId = None
        self._Filters = None

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExportIgnoreRuleEffectHostListResponse(AbstractModel):
    """ExportIgnoreRuleEffectHostList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: 该参数已废弃
        :type DownloadUrl: str
        :param _TaskId: 任务ID,需要到接口“异步导出任务”ExportTasks获取DownloadUrl下载地址
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._TaskId = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class ExportLicenseDetailRequest(AbstractModel):
    """ExportLicenseDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 多个条件筛选时 LicenseStatus,DeadlineStatus,ResourceId,Keywords 取交集
<li> LicenseType  授权类型, 0 专业版-按量计费, 1专业版-包年包月 , 2 旗舰版-包年包月</li>
<li>ResourceId 资源ID</li>
        :type Filters: list of Filters
        :param _IsHistory: 是否导出全部授权详情
        :type IsHistory: bool
        :param _Tags: 标签筛选,平台标签能力,这里传入 标签键,标签值作为一个对象
        :type Tags: list of Tags
        :param _ExportMonth: 导出月份, 该参数仅在IsHistory 时可选.
        :type ExportMonth: str
        """
        self._Filters = None
        self._IsHistory = None
        self._Tags = None
        self._ExportMonth = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def IsHistory(self):
        return self._IsHistory

    @IsHistory.setter
    def IsHistory(self, IsHistory):
        self._IsHistory = IsHistory

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def ExportMonth(self):
        return self._ExportMonth

    @ExportMonth.setter
    def ExportMonth(self, ExportMonth):
        self._ExportMonth = ExportMonth


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._IsHistory = params.get("IsHistory")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tags()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._ExportMonth = params.get("ExportMonth")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExportLicenseDetailResponse(AbstractModel):
    """ExportLicenseDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: 下载地址,该字段废弃
        :type DownloadUrl: str
        :param _TaskId: 任务ID,需要到接口“异步导出任务”ExportTasks获取DownloadUrl下载地址
        :type TaskId: int
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._TaskId = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class ExportMaliciousRequestsRequest(AbstractModel):
    """ExportMaliciousRequests请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤参数
        :type Filters: list of Filters
        """
        self._Filters = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExportMaliciousRequestsResponse(AbstractModel):
    """ExportMaliciousRequests返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: 该参数已废弃
        :type DownloadUrl: str
        :param _TaskId: 任务ID,需要到接口“异步导出任务”ExportTasks获取DownloadUrl下载地址
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._TaskId = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class ExportMalwaresRequest(AbstractModel):
    """ExportMalwares请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 限制条数,默认10
        :type Limit: int
        :param _Offset: 偏移量 默认0
        :type Offset: int
        :param _Filters: 过滤参数。
<li>IpOrAlias - String - 是否必填：否 - 主机ip或别名筛选</li>
<li>FilePath - String - 是否必填：否 - 路径筛选</li>
<li>VirusName - String - 是否必填：否 - 描述筛选</li>
<li>CreateBeginTime - String - 是否必填：否 - 创建时间筛选-开始时间</li>
<li>CreateEndTime - String - 是否必填：否 - 创建时间筛选-结束时间</li>
<li>Status - String - 是否必填：否 - 状态筛选</li>
        :type Filters: list of Filters
        :param _By: 排序值 CreateTime
        :type By: str
        :param _Order: 排序 方式 ，ASC，DESC
        :type Order: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._By = None
        self._Order = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExportMalwaresResponse(AbstractModel):
    """ExportMalwares返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: 该参数已废弃
        :type DownloadUrl: str
        :param _TaskId: 任务ID,需要到接口“异步导出任务”ExportTasks获取DownloadUrl下载地址
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._TaskId = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class ExportNonlocalLoginPlacesRequest(AbstractModel):
    """ExportNonlocalLoginPlaces请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: <li>Status - int - 是否必填：否 - 状态筛选1:正常登录；2：异地登录</li>
        :type Filters: list of Filter
        """
        self._Filters = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExportNonlocalLoginPlacesResponse(AbstractModel):
    """ExportNonlocalLoginPlaces返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: 该参数已废弃
        :type DownloadUrl: str
        :param _TaskId: 任务ID,需要到接口“异步导出任务”ExportTasks获取DownloadUrl下载地址
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._TaskId = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class ExportPrivilegeEventsRequest(AbstractModel):
    """ExportPrivilegeEvents请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤参数
        :type Filters: list of Filters
        """
        self._Filters = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExportPrivilegeEventsResponse(AbstractModel):
    """ExportPrivilegeEvents返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: 该参数已废弃
        :type DownloadUrl: str
        :param _TaskId: 任务ID,需要到接口“异步导出任务”ExportTasks获取DownloadUrl下载地址
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._TaskId = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class ExportProtectDirListRequest(AbstractModel):
    """ExportProtectDirList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: DirName 网站名称
DirPath 网站防护目录地址
        :type Filters: list of AssetFilters
        :param _Order: asc：升序/desc：降序
        :type Order: str
        :param _By: 排序字段
        :type By: str
        """
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExportProtectDirListResponse(AbstractModel):
    """ExportProtectDirList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务ID,需要到接口“异步导出任务”ExportTasks获取DownloadUrl下载地址
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class ExportReverseShellEventsRequest(AbstractModel):
    """ExportReverseShellEvents请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 过滤参数
        :type Filters: list of Filters
        """
        self._Filters = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExportReverseShellEventsResponse(AbstractModel):
    """ExportReverseShellEvents返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: 该参数已废弃
        :type DownloadUrl: str
        :param _TaskId: 任务ID,需要到接口“异步导出任务”ExportTasks获取DownloadUrl下载地址
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._TaskId = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class ExportScanTaskDetailsRequest(AbstractModel):
    """ExportScanTaskDetails请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 本次检测的任务id（不同于出参的导出本次检测Excel的任务Id）
        :type TaskId: int
        :param _ModuleType: 模块类型，当前提供：Malware 木马 , Vul 漏洞 , Baseline 基线
        :type ModuleType: str
        :param _Filters: 过滤参数：ipOrAlias（服务器名/ip）
        :type Filters: list of Filters
        """
        self._TaskId = None
        self._ModuleType = None
        self._Filters = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ModuleType(self):
        return self._ModuleType

    @ModuleType.setter
    def ModuleType(self, ModuleType):
        self._ModuleType = ModuleType

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ModuleType = params.get("ModuleType")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExportScanTaskDetailsResponse(AbstractModel):
    """ExportScanTaskDetails返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务ID,需要到接口“异步导出任务”ExportTasks获取DownloadUrl下载地址(不同于入参的本次检测任务id)
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class ExportSecurityTrendsRequest(AbstractModel):
    """ExportSecurityTrends请求参数结构体

    """

    def __init__(self):
        r"""
        :param _BeginDate: 开始时间。
        :type BeginDate: str
        :param _EndDate: 结束时间。
        :type EndDate: str
        """
        self._BeginDate = None
        self._EndDate = None

    @property
    def BeginDate(self):
        return self._BeginDate

    @BeginDate.setter
    def BeginDate(self, BeginDate):
        self._BeginDate = BeginDate

    @property
    def EndDate(self):
        return self._EndDate

    @EndDate.setter
    def EndDate(self, EndDate):
        self._EndDate = EndDate


    def _deserialize(self, params):
        self._BeginDate = params.get("BeginDate")
        self._EndDate = params.get("EndDate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExportSecurityTrendsResponse(AbstractModel):
    """ExportSecurityTrends返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: 导出文件下载链接地址。
        :type DownloadUrl: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._RequestId = params.get("RequestId")


class ExportTasksRequest(AbstractModel):
    """ExportTasks请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 任务ID
        :type TaskId: str
        """
        self._TaskId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExportTasksResponse(AbstractModel):
    """ExportTasks返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Status: PENDING：正在生成下载链接，FINISHED：下载链接已生成，ERROR：网络异常等异常情况
        :type Status: str
        :param _DownloadUrl: 下载链接
        :type DownloadUrl: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Status = None
        self._DownloadUrl = None
        self._RequestId = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._DownloadUrl = params.get("DownloadUrl")
        self._RequestId = params.get("RequestId")


class ExportVulDetectionExcelRequest(AbstractModel):
    """ExportVulDetectionExcel请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 本次漏洞检测任务id（不同于出参的导出本次漏洞检测Excel的任务Id）
        :type TaskId: int
        """
        self._TaskId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExportVulDetectionExcelResponse(AbstractModel):
    """ExportVulDetectionExcel返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: 该参数已废弃
        :type DownloadUrl: str
        :param _TaskId: 任务ID,需要到接口“异步导出任务”ExportTasks获取DownloadUrl下载地址（不同于入参的本次漏洞检测任务id）
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._TaskId = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class ExportVulDetectionReportRequest(AbstractModel):
    """ExportVulDetectionReport请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TaskId: 漏洞扫描任务id（不同于出参的导出检测报告的任务Id）
        :type TaskId: int
        :param _Filters: 过滤参数
        :type Filters: list of Filters
        :param _Limit: 需要返回的数量，默认为10，最大值为100
        :type Limit: int
        :param _Offset: 偏移量，默认为0。
        :type Offset: int
        """
        self._TaskId = None
        self._Filters = None
        self._Limit = None
        self._Offset = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExportVulDetectionReportResponse(AbstractModel):
    """ExportVulDetectionReport返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: 导出文件下载链接地址
        :type DownloadUrl: str
        :param _TaskId: 导出检测报告的任务Id（不同于入参的漏洞扫描任务id）
        :type TaskId: str
        :param _RequestId: 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._TaskId = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class ExportVulEffectHostListRequest(AbstractModel):
    """ExportVulEffectHostList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VulId: 漏洞id
        :type VulId: int
        :param _Filters: 过滤条件。
<li>AliasName - String - 主机名筛选</li>
        :type Filters: list of Filter
        """
        self._VulId = None
        self._Filters = None

    @property
    def VulId(self):
        return self._VulId

    @VulId.setter
    def VulId(self, VulId):
        self._VulId = VulId

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._VulId = params.get("VulId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExportVulEffectHostListResponse(AbstractModel):
    """ExportVulEffectHostList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: 已废弃
注意：此字段可能返回 null，表示取不到有效值。
        :ty